% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{pos_neg_select}
\alias{pos_neg_select}
\title{adapt clustify to tweak score for pos and neg markers}
\usage{
pos_neg_select(
  input,
  ref_mat,
  metadata,
  cluster_col = "cluster",
  cutoff_n = 0,
  cutoff_score = 0.5
)
}
\arguments{
\item{input}{single-cell expression matrix}

\item{ref_mat}{reference expression matrix with positive and
negative markers(set expression at 0)}

\item{metadata}{cell cluster assignments,
supplied as a vector or data.frame. If
data.frame is supplied then \code{cluster_col} needs to be set.
Not required if running correlation per cell.}

\item{cluster_col}{column in metadata that contains cluster ids per cell.
Will default to first
column of metadata if not supplied.
Not required if running correlation per cell.}

\item{cutoff_n}{expression cutoff where genes ranked below n are
considered non-expressing}

\item{cutoff_score}{positive score lower than this cutoff will be
considered as 0 to not influence scores}

\item{...}{additional arguments to pass to compute_method function}
}
\value{
matrix of numeric values, clusters from input as row names,
cell types from ref_mat as column names
}
\description{
adapt clustify to tweak score for pos and neg markers
}
\examples{
pn_ref <- data.frame(
    "Myeloid" = c(1, 0.01, 0),
    row.names = c("CD74", "clustifyr0", "CD79A")
)

pos_neg_select(
    input = pbmc_matrix_small,
    ref_mat = pn_ref,
    metadata = pbmc_meta,
    cluster_col = "classified",
    cutoff_score = 0.8
)
}
