% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_gene}
\alias{plot_gene}
\title{Plot gene expression on to tSNE or umap}
\usage{
plot_gene(expr_mat, metadata, genes, cell_col = NULL, ...)
}
\arguments{
\item{expr_mat}{input single cell matrix}

\item{metadata}{data.frame with tSNE or umap coordinates}

\item{genes}{gene(s) to color tSNE or umap}

\item{cell_col}{column name in metadata containing cell ids, defaults
to rownames if not supplied}

\item{...}{additional arguments passed to \verb{[clustifyr::plot_dims()]}}
}
\value{
list of ggplot object, cells projected by dr,
colored by gene expression
}
\description{
Plot gene expression on to tSNE or umap
}
\examples{
genes <- c(
    "RP11-314N13.3",
    "ARF4"
)

plot_gene(
    expr_mat = pbmc_matrix_small,
    metadata = tibble::rownames_to_column(pbmc_meta, "rn"),
    genes = genes,
    cell_col = "rn"
)
}
