% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_dims}
\alias{plot_dims}
\title{Plot a tSNE or umap colored by feature.}
\usage{
plot_dims(
  data,
  x = "UMAP_1",
  y = "UMAP_2",
  feature = NULL,
  legend_name = "",
  c_cols = pretty_palette2,
  d_cols = NULL,
  pt_size = 0.25,
  alpha_col = NULL,
  group_col = NULL,
  scale_limits = NULL,
  do_label = FALSE,
  do_legend = TRUE,
  do_repel = TRUE
)
}
\arguments{
\item{data}{input data}

\item{x}{x variable}

\item{y}{y variable}

\item{feature}{feature to color by}

\item{legend_name}{legend name to display, defaults to no name}

\item{c_cols}{character vector of colors to build color gradient
for continuous values, defaults to \code{\link[clustifyr:pretty_palette]{clustifyr::pretty_palette}}}

\item{d_cols}{character vector of colors for discrete values.
defaults to RColorBrewer paired palette}

\item{pt_size}{point size}

\item{alpha_col}{whether to refer to data column for alpha values}

\item{group_col}{group by another column instead of feature,
useful for labels}

\item{scale_limits}{defaults to min = 0, max = max(data$x),
otherwise a two-element numeric vector indicating min and max to plot}

\item{do_label}{whether to label each cluster at median center}

\item{do_legend}{whether to draw legend}

\item{do_repel}{whether to use ggrepel on labels}
}
\value{
ggplot object, cells projected by dr, colored by feature
}
\description{
Plot a tSNE or umap colored by feature.
}
\examples{
plot_dims(
    pbmc_meta,
    feature = "classified"
)
}
