% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seurat_wrapper.R
\name{object_ref}
\alias{object_ref}
\title{Function to convert labelled object to avg expression matrix}
\usage{
object_ref(
  input,
  cluster_col = NULL,
  var_genes_only = FALSE,
  assay_name = NULL,
  method = "mean",
  lookuptable = NULL,
  if_log = TRUE
)
}
\arguments{
\item{input}{object after tsne or umap projections and clustering}

\item{cluster_col}{column name where classified cluster names
are stored in seurat meta data, cannot be "rn"}

\item{var_genes_only}{whether to keep only var.genes in the
final matrix output, could also look up genes used for PCA}

\item{assay_name}{any additional assay data, such as ADT, to include.
If more than 1, pass a vector of names}

\item{method}{whether to take mean (default) or median}

\item{lookuptable}{if not supplied, will look
in built-in table for object parsing}

\item{if_log}{input data is natural log,
averaging will be done on unlogged data}
}
\value{
reference expression matrix, with genes as row names,
and cell types as column names
}
\description{
Function to convert labelled object to avg expression matrix
}
\examples{
object_ref(
    s_small3,
    cluster_col = "RNA_snn_res.1"
)
}
