% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seurat_wrapper.R
\name{object_data}
\alias{object_data}
\alias{object_data.seurat}
\alias{object_data.Seurat}
\alias{object_data.SingleCellExperiment}
\title{Function to access object data}
\usage{
object_data(object, ...)

\method{object_data}{seurat}(object, slot, ...)

\method{object_data}{Seurat}(object, slot, ...)

\method{object_data}{SingleCellExperiment}(object, slot, ...)
}
\arguments{
\item{object}{object after tsne or umap projections
and clustering}

\item{...}{additional arguments}

\item{slot}{data to access}
}
\value{
expression matrix, with genes as row names,
and cell types as column names
}
\description{
Function to access object data
}
\examples{
mat <- object_data(
    object = s_small,
    slot = "data"
)
mat[1:3, 1:3]
mat <- object_data(
    object = s_small3,
    slot = "data"
)
mat[1:3, 1:3]
mat <- object_data(
    object = sce_small,
    slot = "data"
)
mat[1:3, 1:3]
}
