% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{gmt_to_list}
\alias{gmt_to_list}
\title{convert gmt format of pathways to list of vectors}
\usage{
gmt_to_list(
  path,
  cutoff = 0,
  sep = "\\thttp://www.broadinstitute.org/gsea/msigdb/cards/.*?\\t"
)
}
\arguments{
\item{path}{gmt file path}

\item{cutoff}{remove pathways with less genes than this cutoff}

\item{sep}{sep used in file to split path and genes}
}
\value{
list of genes in each pathway
}
\description{
convert gmt format of pathways to list of vectors
}
\examples{
gmt_file <- system.file(
    "extdata",
    "c2.cp.reactome.v6.2.symbols.gmt.gz",
    package = "clustifyr"
)

gl <- gmt_to_list(path = gmt_file)
length(gl)
}
