% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{gene_pct_markerm}
\alias{gene_pct_markerm}
\title{pct of cells in every cluster that express a series of genelists}
\usage{
gene_pct_markerm(matrix, marker_m, metadata, cluster_col = NULL, norm = NULL)
}
\arguments{
\item{matrix}{expression matrix}

\item{marker_m}{matrixized markers}

\item{metadata}{data.frame or vector containing cluster
assignments per cell.
Order must match column order in supplied matrix. If a data.frame
provide the cluster_col parameters.}

\item{cluster_col}{column in metadata with cluster number}

\item{norm}{whether and how the results are normalized}
}
\value{
matrix of numeric values, clusters from mat as row names,
cell types from marker_m as column names
}
\description{
pct of cells in every cluster that express a series of genelists
}
\examples{
gene_pct_markerm(
    matrix = pbmc_matrix_small,
    marker_m = cbmc_m,
    metadata = pbmc_meta,
    cluster_col = "classified"
)
}
