% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cor_to_call_topn}
\alias{cor_to_call_topn}
\title{get top calls for each cluster}
\usage{
cor_to_call_topn(
  cor_mat,
  metadata = NULL,
  col = "cluster",
  collapse_to_cluster = FALSE,
  threshold = 0,
  topn = 2
)
}
\arguments{
\item{cor_mat}{input similarity matrix}

\item{metadata}{input metadata with tsne or umap coordinates
and cluster ids}

\item{col}{metadata column, can be cluster or cellid}

\item{collapse_to_cluster}{if a column name is provided,
takes the most frequent call of entire cluster to color in plot}

\item{threshold}{minimum correlation coefficent cutoff for calling clusters}

\item{topn}{number of calls for each cluster}
}
\value{
dataframe of cluster, new potential ident, and r info
}
\description{
get top calls for each cluster
}
\examples{
res <- clustify(
    input = pbmc_matrix_small,
    metadata = pbmc_meta,
    ref_mat = cbmc_ref,
    query_genes = pbmc_vargenes,
    cluster_col = "classified"
)

cor_to_call_topn(
    cor_mat = res,
    metadata = pbmc_meta,
    col = "classified",
    collapse_to_cluster = FALSE,
    threshold = 0.5
)
}
