% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_dplyr.R
\name{cor_to_call_rank}
\alias{cor_to_call_rank}
\title{get ranked calls for each cluster}
\usage{
cor_to_call_rank(
  cor_mat,
  metadata = NULL,
  cluster_col = "cluster",
  collapse_to_cluster = FALSE,
  threshold = 0,
  rename_prefix = NULL,
  top_n = NULL
)
}
\arguments{
\item{cor_mat}{input similarity matrix}

\item{metadata}{input metadata with tsne or umap coordinates
and cluster ids}

\item{cluster_col}{metadata column, can be cluster or cellid}

\item{collapse_to_cluster}{if a column name is provided, takes the most
frequent call of entire cluster to color in plot}

\item{threshold}{minimum correlation coefficent cutoff for calling clusters}

\item{rename_prefix}{prefix to add to type and r column names}

\item{top_n}{the number of ranks to keep, the rest will be set to 100}
}
\value{
dataframe of cluster, new ident, and r info
}
\description{
get ranked calls for each cluster
}
\examples{
res <- clustify(
    input = pbmc_matrix_small,
    metadata = pbmc_meta,
    cluster_col = "classified",
    ref_mat = cbmc_ref
)

cor_to_call_rank(res, threshold = "auto")
}
