% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{clustify}
\alias{clustify}
\alias{clustify.default}
\alias{clustify.seurat}
\alias{clustify.Seurat}
\alias{clustify.SingleCellExperiment}
\title{Compare scRNA-seq data to reference data.}
\usage{
clustify(input, ...)

\method{clustify}{default}(
  input,
  ref_mat,
  metadata = NULL,
  cluster_col = NULL,
  query_genes = NULL,
  per_cell = FALSE,
  n_perm = 0,
  compute_method = "spearman",
  verbose = FALSE,
  lookuptable = NULL,
  rm0 = FALSE,
  obj_out = TRUE,
  seurat_out = TRUE,
  rename_prefix = NULL,
  threshold = "auto",
  low_threshold_cell = 10,
  exclude_genes = c(),
  ...
)

\method{clustify}{seurat}(
  input,
  ref_mat,
  cluster_col = NULL,
  query_genes = NULL,
  per_cell = FALSE,
  n_perm = 0,
  compute_method = "spearman",
  use_var_genes = TRUE,
  dr = "umap",
  seurat_out = TRUE,
  obj_out = TRUE,
  threshold = "auto",
  verbose = FALSE,
  rm0 = FALSE,
  rename_prefix = NULL,
  exclude_genes = c(),
  ...
)

\method{clustify}{Seurat}(
  input,
  ref_mat,
  cluster_col = NULL,
  query_genes = NULL,
  per_cell = FALSE,
  n_perm = 0,
  compute_method = "spearman",
  use_var_genes = TRUE,
  dr = "umap",
  seurat_out = TRUE,
  obj_out = TRUE,
  threshold = "auto",
  verbose = FALSE,
  rm0 = FALSE,
  rename_prefix = NULL,
  exclude_genes = c(),
  ...
)

\method{clustify}{SingleCellExperiment}(
  input,
  ref_mat,
  cluster_col = NULL,
  query_genes = NULL,
  per_cell = FALSE,
  n_perm = 0,
  compute_method = "spearman",
  use_var_genes = TRUE,
  dr = "umap",
  seurat_out = TRUE,
  obj_out = TRUE,
  threshold = "auto",
  verbose = FALSE,
  rm0 = FALSE,
  rename_prefix = NULL,
  exclude_genes = c(),
  ...
)
}
\arguments{
\item{input}{single-cell expression matrix or Seurat object}

\item{...}{additional arguments to pass to compute_method function}

\item{ref_mat}{reference expression matrix}

\item{metadata}{cell cluster assignments,
supplied as a vector or data.frame.
If data.frame is supplied then \code{cluster_col} needs to be set.
Not required if running correlation per cell.}

\item{cluster_col}{column in metadata that contains cluster ids per cell.
Will default to first column of metadata if not supplied.
Not required if running correlation per cell.}

\item{query_genes}{A vector of genes of interest to compare. If NULL, then
common genes between the expr_mat and ref_mat
will be used for comparision.}

\item{per_cell}{if true run per cell, otherwise per cluster.}

\item{n_perm}{number of permutations, set to 0 by default}

\item{compute_method}{method(s) for computing similarity scores}

\item{verbose}{whether to report certain variables chosen}

\item{lookuptable}{if not supplied, will look in built-in table
for object parsing}

\item{rm0}{consider 0 as missing data, recommended for per_cell}

\item{obj_out}{whether to output object instead of cor matrix}

\item{seurat_out}{output cor matrix or called seurat object
(deprecated, use obj_out instead)}

\item{rename_prefix}{prefix to add to type and r column names}

\item{threshold}{identity calling minimum correlation score threshold,
only used when obj_out = TRUE}

\item{low_threshold_cell}{option to remove clusters with too few cells}

\item{exclude_genes}{a vector of gene names to throw out of query}

\item{use_var_genes}{if providing a seurat object, use the variable genes
(stored in seurat_object@var.genes) as the query_genes.}

\item{dr}{stored dimension reduction}
}
\value{
single cell object with identity assigned in metadata,
or matrix of correlation values, clusters from input as row names, cell
types from ref_mat as column names
}
\description{
Compare scRNA-seq data to reference data.
}
\examples{
# Annotate a matrix and metadata
clustify(
    input = pbmc_matrix_small,
    metadata = pbmc_meta,
    ref_mat = cbmc_ref,
    query_genes = pbmc_vargenes,
    cluster_col = "classified",
    verbose = TRUE
)

# Annotate using a different method
clustify(
    input = pbmc_matrix_small,
    metadata = pbmc_meta,
    ref_mat = cbmc_ref,
    query_genes = pbmc_vargenes,
    cluster_col = "classified",
    compute_method = "cosine"
)

# Annotate a Seurat object
clustify(
    s_small,
    cbmc_ref,
    cluster_col = "res.1",
    obj_out = TRUE,
    per_cell = FALSE,
    dr = "tsne"
)

# Annotate (and return) a Seurat object per-cell
clustify(
    input = s_small,
    ref_mat = cbmc_ref,
    cluster_col = "res.1",
    obj_out = TRUE,
    per_cell = TRUE,
    dr = "tsne"
)
}
