% TmB4 field induced paper
%example of loading the data of figure 4
%Diane Lanon 08/10/20019
 
load data_figure4.mat

dred=[0.7430 0 0];
dblue=[0.18 0.18 0.53]
figure
coef=K1p7_1_100_ii(1)/amps_100_FP3(1,1)

subplot(2,2,1)
hold on
axis([-0.1 5.1 -0.1 3])
box on
h1_3=errorbar(fields_K1p7_1(1:28),K1p7_1_100_ii(1:28),K1p7_1_100_ee(1:28),'-ko'); hold on;
h=errorbar(fields_FP3(1:6),amps_100_FP3((1:6),1)*coef,amps_100_FP3((1:6),2)*coef,'^','MarkerFaceColor',dred,'markeredgecolor',dred,'Color',dred);
set(h1_3,'markerfacecolor',[ 0.5843 0.8157 0.9882],'markeredgecolor',[ 0.5843 0.8157 0.9882],'color',[ 0.5843 0.8157 0.9882]);
h1_2=errorbar(fields_K5_1(1:28),K5_1_100_ii(1:28),K5_1_100_ee(1:28),'-ks');
set(h1_2,'markerfacecolor','[0 0.5 1]','markeredgecolor','[0 0.5 1]','color','[0 0.5 1]');
h1_1=errorbar(fields_K7_2(1:27),K7_2_100_ii(1:27),K7_2_100_ee(1:27),'-kd');
set(h1_1,'markerfacecolor',dblue,'markeredgecolor',dblue,'color',dblue);
set(gca,'fontsize',14,'fontname','times')
ylabel('Intensity [arb. units]','interpreter','latex')
annotation('arrow',[0.262 0.342],[0.94 0.941],'LineWidth',1.5);
text(2,3.6,'Field ramp','fontsize',14,'fontname','times')
set(gca,'XTick',[0:1:5])
line([1.4 1.4], [-0.1 5],'Linestyle','--','Color','k')
line([1.7 1.7], [-0.1 5],'Linestyle','--','Color','k')
line([1.4 1.4], [-0.1 5],'Linestyle','--','Color','k')
line([3.5 3.5], [-0.1 5],'Linestyle','--','Color','k')
text(0.05,2.7,'a) (1,0,0)','fontsize',14,'fontname','times');

subplot(2,2,2)
hold on
axis([-0.1 5.1 -0.1 3])
box on
h2_3=errorbar(fields_K1p7_1(28:55),K1p7_1_100_ii(28:55),K1p7_1_100_ee(28:55),'-ko');
h2=errorbar(fields_FP3(6:end),amps_100_FP3(6:end,1)*coef,amps_100_FP3(6:end,2),'v','MarkerFaceColor',dred,'markeredgecolor',dred,'Color',dred);
h3=errorbar(fields_FR,amps_100_FR(:,1)*coef,amps_100_FR(:,2),'v','MarkerFaceColor',dred,'markeredgecolor',dred,'Color',dred);
set(h2_3,'markerfacecolor','[ 0.5843 0.8157 0.9882]','markeredgecolor','[ 0.5843 0.8157 0.9882]','color','[ 0.5843 0.8157 0.9882]');
h2_2=errorbar(fields_K5_1(28:55),K5_1_100_ii(28:55),K5_1_100_ee(28:55),'-ks');
set(h2_2,'markerfacecolor','[0 0.5 1]','markeredgecolor','[0 0.5 1]','color','[0 0.5 1]');
h2_1=errorbar(fields_K7_2(27:53),K7_2_100_ii(27:53),K7_2_100_ee(27:53),'-kd');
set(h2_1,'markerfacecolor',dblue,'markeredgecolor',dblue,'color',dblue);
set(gca,'fontsize',14,'fontname','times')
% hleg_2=legend([h2_1;h2_2;h2_3;h2],char('7 K (down)','5 K (down)','1.7 K (down)','1.7K otherdataset (down)'))
% set(hleg_2,'interpreter','latex','location','northeast')
% hold off
annotation('arrow',[0.78 0.70],...
    [0.94 0.941],'LineWidth',1.5);
text(2,3.6,'Field ramp','fontsize',14,'fontname','times')
%set(gca,'XTick',[0:0.5:5])
line([1.4 1.4], [-0.1 5],'Linestyle','--','Color','k')
line([1.7 1.7], [-0.1 5],'Linestyle','--','Color','k')
line([1.4 1.4], [-0.1 5],'Linestyle','--','Color','k')
line([3.5 3.5], [-0.1 5],'Linestyle','--','Color','k')
text(0.05,2.7,'b) (1,0,0)','fontsize',14,'fontname','times');


subplot(2,2,3)
hold on
axis([-0.1 5.1 -0.1 1.5])
box on
h1=errorbar(fields_K1p7_1(1:28),K1p7_1_1pk00_ii(1:28),K1p7_1_1pk00_ee(1:28),'-ko');
set(h1,'markerfacecolor','[ 0.5843 0.8157 0.9882]','markeredgecolor','[ 0.5843 0.8157 0.9882]','color','[ 0.5843 0.8157 0.9882]');
h1=errorbar(fields_K5_1(1:28),K5_1_1pk00_ii(1:28),K5_1_1pk00_ee(1:28),'-ks');
set(h1,'markerfacecolor','[0 0.5 1]','markeredgecolor','[0 0.5 1]','color','[0 0.5 1]');
h1=errorbar(fields_K7_2(1:27),K7_2_1pk00_ii(1:27),K7_2_1pk00_ee(1:27),'-kd');
set(h1,'markerfacecolor',dblue,'markeredgecolor',dblue,'color',dblue);
h=errorbar(fields_FP3(1:6),amps_1k0_FP3((1:6),1)*coef,amps_1k0_FP3((1:6),2)*coef,'v','Color','r','MarkerFaceColor','r');
hp=errorbar(fields_FP3(1:6),amps_1pk00_FP3((1:6),1)*coef,amps_1pk00_FP3((1:6),2)*coef,'^','MarkerFaceColor',dred,'markeredgecolor',dred,'Color',dred);
ylabel('Intensity [arb. units]','interpreter','latex')
hold off
set(gca,'fontsize',14,'fontname','times')
line([1.4 1.4], [-0.1 5],'Linestyle','--','Color','k')
line([1.7 1.7], [-0.1 5],'Linestyle','--','Color','k')
line([1.4 1.4], [-0.1 5],'Linestyle','--','Color','k')
line([3.5 3.5], [-0.1 5],'Linestyle','--','Color','k')
%text(-0.02,1.32,'Incommensurate','fontsize',10,'fontname','times','interp','latex');
text(0.05,1.32,'c) (1+$\delta$,0,0)*/(1,$\delta$,0)$\dagger$','fontsize',14,'fontname','times','interp','latex');
xlabel('Applied Field [T]','interpreter','latex')


subplot(2,2,4)
hold on
axis([-0.1 5.1 -0.1 1.5])
box on
h1=errorbar(fields_K1p7_1(28:55),K1p7_1_1pk00_ii(28:55),K1p7_1_1pk00_ee(28:55),'-kO');
set(h1,'markerfacecolor','[ 0.5843 0.8157 0.9882]','markeredgecolor','[ 0.5843 0.8157 0.9882]','color','[ 0.5843 0.8157 0.9882]');
h1=errorbar(fields_K5_1(28:55),K5_1_1pk00_ii(28:55),K5_1_1pk00_ee(28:55),'-ks');
set(h1,'markerfacecolor','[0 0.5 1]','markeredgecolor','[0 0.5 1]','color','[0 0.5 1]');
h1=errorbar(fields_K7_2(27:53),K7_2_1pk00_ii(27:53),K7_2_1pk00_ee(27:53),'-kd');
set(h1,'markerfacecolor',dblue,'markeredgecolor',dblue,'color',dblue);
h2=errorbar(fields_FP3(6:end),amps_1k0_FP3(6:end,1)*coef,amps_1k0_FP3(6:end,2),'vk');
set(h2,'Color','r','MarkerFaceColor','r');
h3=errorbar(fields_FR,amps_1k0_FR(:,1)*coef,amps_1k0_FR(:,2),'v','Color','r','MarkerFaceColor','r');
h2p=errorbar(fields_FP3(6:end),amps_1pk00_FP3(6:end,1)*coef,amps_1pk00_FP3(6:end,2),'^','MarkerFaceColor',dred,'markeredgecolor',dred,'Color',dred);
h3p=errorbar(fields_FR,amps_1pk00_FR(:,1)*coef,amps_1pk00_FR(:,2),'^','MarkerFaceColor',dred,'markeredgecolor',dred,'Color',dred);
pause(0.1); % cette pause donne l "le temps" a matlab de faire la legende correctement
hleg_1=legend([h1_1;h1_2;h1_3;h3p;h2],char('7 K ','5 K ','1.7K A*','1.7K B*','1.7K C$\dagger$'))
set(hleg_1,'interpreter','latex','location','northeast')
set(gca,'fontsize',14,'fontname','times')
line([1.4 1.4], [-0.1 5],'Linestyle','--','Color','k')
line([1.7 1.7], [-0.1 5],'Linestyle','--','Color','k')
line([1.4 1.4], [-0.1 5],'Linestyle','--','Color','k')
line([3.5 3.5], [-0.1 5],'Linestyle','--','Color','k')
%text(-0.02,1.32,'Incommensurate','fontsize',10,'fontname','times','interp','latex');
text(0.05,1.32,'d) (1+$\delta$,0,0)*/(1,$\delta$,0)$\dagger$','fontsize',14,'fontname','times','interp','latex');
xlabel('Applied Field [T]','interpreter','latex')
set(gcf,'color','w');
set(gca,'LooseInset', max(get(gca,'TightInset'), 0.02))
