% TmB4 field induced paper
%example of loading the data of figure 2
%Diane Lancon 18/08/2020

load squiddata
% data can be found also as a txt file for each temperature.

figure
hold on
h1p0a=plot(T1p0K.data(1:102,2),T1p0K.data(1:102,4),'ok')
h1p0b=plot(T1p0K.data(103:204,2),T1p0K.data(103:204,4),'ok')

h2p0a=plot(T2p0K.data(1:189,3),T2p0K.data(1:189,5),'>r')
h2p0b=plot(T2p0K.data(190:320,3),T2p0K.data(190:320,5),'>r')

h3p5a=plot(T3p5K.data(411:589,3),T3p5K.data(411:589,5),'dm')
h3p5b=plot(T3p5K.data(590:670,3),T3p5K.data(590:670,5),'dm')

set(h1p0a,'markerfacecolor','w','markeredgecolor','k')
set(h1p0b,'markerfacecolor','k','markeredgecolor','k')

set(h2p0a,'markerfacecolor','w','markeredgecolor',[0.5 0.5 0.5])
set(h2p0b,'markerfacecolor',[0.5 0.5 0.5],'markeredgecolor','k')

set(h3p5a,'markerfacecolor','w','markeredgecolor','r')
set(h3p5b,'markerfacecolor','r','markeredgecolor','k')

axis([-0.1 6.1 -0.1 7])
box on

xlabel('$\mu_0 H$ [T]','interpreter','latex','fontsize',14,'fontname','times')
ylabel('$\mu_B$ per Tm ion','interpreter','latex','fontsize',14,'fontname','times')

set(gca,'fontname','times','fontsize',14)
text(0.4,6.5,'a)','fontname','times','fontsize',14)

hleg1=legend([h1p0a;h2p0a;h3p5a],char('1.0 K','2.0 K','3.5 K'))
set(hleg1,'interpreter','latex','location','southeast','orientation','vertical')




figure 
hold on
hup1p0=plot(T1p0K.data(9:48,2),T1p0K.data(9:48,4),'ok')
hdn1p0=plot(T1p0K.data(157:196,2),T1p0K.data(157:196,4),'ok')

hup2p0=plot(T2p0K.data(34:155,3),T2p0K.data(34:155,5),'>r')
hdn2p0=plot(T2p0K.data(225:315,3),T2p0K.data(225:315,5),'>r')

hup3p5=plot(T3p5K.data(430:550,3),T3p5K.data(430:550,5),'dm')
hdn3p5=plot(T3p5K.data(600:660,3),T3p5K.data(600:660,5),'dm')

set(hup1p0,'markerfacecolor','w','markeredgecolor','k')
set(hdn1p0,'markerfacecolor','k','markeredgecolor','k')
set(hup2p0,'markerfacecolor','w','markeredgecolor',[0.5 0.5 0.5])
set(hdn2p0,'markerfacecolor',[0.5 0.5 0.5],'markeredgecolor','k')
set(hup3p5,'markerfacecolor','w','markeredgecolor','r')
set(hdn3p5,'markerfacecolor','r','markeredgecolor','k')
hleg=legend([hup1p0;hdn1p0],char('$H \nearrow$','$H \swarrow$'))
set(hleg,'interpreter','latex','location','northwest','orientation','vertical')
text(1.9,0.05,'b)','fontname','times','fontsize',14)

axis([1 2 -0.05 1.2])
box on
xlabel('$\mu_0 H$ [T]','interpreter','latex','fontsize',14,'fontname','times')
ylabel('$\mu_B$ per Tm ion','interpreter','latex','fontsize',14,'fontname','times')

set(gca,'fontname','times','fontsize',14)
text(0.4,6.5,'a)','fontname','times','fontsize',14)
set(gcf,'color','w');

