/**
 * Copyright (c) 2017-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

module.exports = {
  docs: {
    Introduction: ['overview', 'acknowledgements'],
    'Core Concepts': [
      'concepts/nodes',
      'concepts/user-components',
      'concepts/editor-components',
    ],
    Guides: ['guides/basic-tutorial', 'guides/save-load-state'],
    'API Reference': [
      'api/editor-state',
      'api/node',
      'api/user-component',
      'api/nodetree',
      'api/editor',
      'api/frame',
      'api/element',
      'api/useEditor',
      'api/useNode',
      'api/helpers',
    ],
    'Additional Packages': ['additional/layers'],
  },
};
