import LeNet5
from tensorflow import keras
import numpy as np
import os
import statistics
import sys

"""
this main evaluates the le-net-5 models that we save with all the test


"""

if __name__ == '__main__':
    entries = os.listdir('../models')
    epochs = 100000
    for learning_rate in [0.1, 0.01, 0.001, 0.0001]:
        for train_size_per_number in [5, 10, 100]:
            accuracy_results = []
            f = open("../output/accuracy_lenet5_" + str(train_size_per_number) + "_" + str(learning_rate) + "_nonoise.csv", "w+")
            for run_id in range(1, 31):
                fileName = '../models/learningRate_' + str(learning_rate) + '_maxEpochs_' + str(epochs) + '_trainingSizePerNumber_' + str(train_size_per_number) + '_runId_' + str(run_id) + ".h5"
                model = keras.models.load_model(fileName)
                acc = LeNet5.evaluate_lenet(model)
                accuracy_results = np.append(accuracy_results, acc)
                f.write(str(acc)+"\n")
            print(str(train_size_per_number) + ',' + str(learning_rate) + ',' + str(30) + ',' + str(statistics.median(accuracy_results)) + ',' + str(statistics.mean(accuracy_results)) + ',' + str(min(accuracy_results)) + ',' + str(max(accuracy_results)))
            sys.stdout.flush()

