
from tensorflow import keras
import numpy as np
import os
import statistics
import sys
from keras.utils import np_utils
import csv
import numpy

"""
this main evaluates the le-net-5 models that we saved with noise given from file


"""

if __name__ == '__main__':
    for level_noise in [40]:
        print("noise level" + str(level_noise))
        # prepare the noise
        test_images = np.ndarray(shape=(10000, 28, 28))
        test_labels = numpy.empty(10000, dtype=int)
        with open('../test-dataset-noisy/noise_dataset_'+str(level_noise)+'_perc.csv') as csv_file:
            csv_reader = csv.reader(csv_file, delimiter=';')
            line_count = -1
            for row in csv_reader:
                if 0 <= line_count:
                    number_matrix = np.ndarray(shape=(28, 28), dtype="int")
                    countPixel = 0
                    for i in range(0, 28):
                        for j in range(0, 28):
                            # plus one because the first element in a row is the number
                            number_matrix[i, j] = int(row[countPixel+1])
                            countPixel = countPixel + 1
                    # print check if ok
                    #number_matrix = number_matrix.astype('float32')
                    #cv2.imshow(str(row[0]), number_matrix)
                    #cv2.waitKey(0)
                    test_images[line_count] = number_matrix.copy()
                    test_labels[line_count] = row[0]
                line_count += 1
            print(f'Processed {line_count} lines.')

        x_test = test_images.astype('float32')
        x_test /= 255
        y_test = np_utils.to_categorical(test_labels, 10)
        x_test = x_test.reshape(x_test.shape[0], 28, 28, 1)

        entries = os.listdir('../models')
        epochs = 100000
        for learning_rate in [0.1, 0.01, 0.001, 0.0001]:
            for train_size_per_number in [5, 10, 100]:
                accuracy_results = []
                f = open(
                    "../output/accuracy_lenet5_" + str(train_size_per_number) + "_" + str(learning_rate) + "_noise_" + str(level_noise) + ".csv",
                    "w+")
                for run_id in range(1, 31):
                    fileName = '../models/learningRate_' + str(learning_rate) + '_maxEpochs_' + str(epochs) + '_trainingSizePerNumber_' + str(train_size_per_number) + '_runId_' + str(run_id) + ".h5"
                    model = keras.models.load_model(fileName)
                    loss, acc = model.evaluate(x_test, y_test, verbose=0)
                    accuracy_results = np.append(accuracy_results, acc)
                    f.write(str(acc) + "\n")
                print(str(train_size_per_number) + ',' + str(learning_rate) + ',' + str(30) + ',' + str(statistics.median(accuracy_results)) + ',' + str(statistics.mean(accuracy_results)) + ',' + str(min(accuracy_results)) + ',' + str(max(accuracy_results)))
                sys.stdout.flush()

