(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[  15268028,     293533]
NotebookOptionsPosition[  14886973,     288129]
NotebookOutlinePosition[  14888304,     288163]
CellTagsIndexPosition[  14888261,     288160]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Redesign of the didactics of S(E)IR(D) \[Rule] SI(EY)A(CD) models of \
infectious epidemics\
\>", "Title",ExpressionUUID->"3bda83ee-3725-4b6d-8930-508b618cb937"],

Cell["\<\
Reference to exit strategies for the economic crisis. A nasty virus, asking \
for eradication. Could the virus be used as its own vaccine for some ? How \
immune will one be ? Didactics on modeling of the SARS-CoV-2 (covid-19) \
pandemic of 2020, with the example case of Holland. Prevent or prepare for \
the next pandemic, perhaps already this Fall or Winter.\
\>", "Subtitle",ExpressionUUID->"a8dc26fa-e5f2-4821-8f67-959ec98ee5ef"],

Cell["\<\
Thomas Colignatus
June 15 2020
https://zenodo.org/communities/re-engineering-math-ed/about/\
\>", "Text",ExpressionUUID->"90f8a449-4b14-4683-9cd0-2195e60de396"],

Cell[CellGroupData[{

Cell["Abstract", "Subsection",ExpressionUUID->"29d03ff8-d994-4cd9-b402-2f3e3e89863c"],

Cell[TextData[{
 "This notebook and package redesign the didactics of the classic SIR, SIRD \
and SEIRD models. A first step is to relabel to SI(EY)A(CD). The acquitted ",
 StyleBox["A = C + D",
  FontSlant->"Italic"],
 " are the cleared or deceased. This avoids the triple use of ",
 StyleBox["R ",
  FontSlant->"Italic"],
 "for removed, recovered and reproductive number. The infected ",
 StyleBox["I = E + Y ",
  FontSlant->"Italic"],
 "are the exposed and infectious. The basic structure is given by the \
Euler-Lotka renewal equation. The format of ordinary differential equations \
(ODE) should not distract. The deceased are a fraction of the acquitted, ",
 StyleBox["D ",
  FontSlant->"Italic"],
 "= \[CurlyPhi] ",
 StyleBox["A",
  FontSlant->"Italic"],
 ", with \[CurlyPhi] the infection fatality factor (IFF). The ODE format ",
 StyleBox["D\[CloseCurlyQuote] ",
  FontSlant->"Italic"],
 "= \[Mu] ",
 StyleBox["I ",
  FontSlant->"Italic"],
 "or ",
 StyleBox["D\[CloseCurlyQuote] ",
  FontSlant->"Italic"],
 "= \[Mu] ",
 StyleBox["Y",
  FontSlant->"Italic"],
 " can be rejected since it turns the model into a course in differential \
equations, with the need to prove ",
 StyleBox["D ",
  FontSlant->"Italic"],
 "= \[CurlyPhi] ",
 StyleBox["A ",
  FontSlant->"Italic"],
 "what can already be stated from the start. The ODE format also causes \
distracting questions what \[Mu] might be and whether there is a difference \
between a lethal acquittal period and a clearing acquittal period, and how \
parameters values must be adapted when the acquittal rate \[Gamma] changes. \
The didactic redesign is discussed with the example of the SARS-CoV-2 \
pandemic. The common formula on herd immunity 1 - 1 / ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "6c3b34a6-3918-4d95-8998-90d27d205a02"],
 " assumes a steady state, but unless infections are zero then they actually \
proceed in a steady state, and thus not with the promised protection. \
SI(EY)A(CD) has only an ",
 StyleBox["asymptotic ",
  FontSlant->"Italic"],
 "steady state so that this formula does not even apply. For SI(EY)A(CD) a \
notion of \[OpenCurlyDoubleQuote]near herd immunity\[CloseCurlyDoubleQuote] \
might be 95% of the limit values. For SARS-CoV-2, RIVM (the Dutch CDC) has \
mentioned ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "fdb368a4-0a06-4a7d-9df5-6396a3ad397e"],
 " = 2.5 and herd immunity of 60%, presumably using another type of model. In \
SI(EY)A(CD) an infection with ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "3f7478ec-162a-438b-bc59-07fc6ddf7c4d"],
 " = 2.5 proceeds after 60% till the limit value of 89.3%, which, with IFF = \
1.5%, would mean another 78,000 deceased in Holland, compared to 9,000 at the \
end of May. For Public Health, it is important to balance medical and \
economic issues. A better understanding of the SI(EY)A(CD) family of models \
helps to gauge exit strategies for the pandemic and its economic crisis. A \
possible strategy is to eradicate the virus: with ",
 StyleBox["test, test, and test ",
  FontSlant->"Italic"],
 "it would be possible to put positively tested persons in quarantine till \
they have cleared. Another possible strategy is that the vulnerable (elderly \
and comorbid younger) are put into quarantine while the less vulnerable are \
infected (in cohorts dictated by ICU capacity), effectively using the virus \
as its own vaccine, for a period of 12-16 months until there is a proper \
vaccine for the vulnerable compartment of society. It is remarkable that \
these scenario\[CloseCurlyQuote]s are so little discussed in policy making \
circles, where there seems to be a preference for a lock-on-off approach, \
that is risky and prolongs the economic crisis.",
 StyleBox[" ",
  FontSlant->"Italic"],
 "Epidemiology exists for longer than a century and there have been many \
warnings about the risk of pandemics. Lessons learnt at the level of cities \
and nations are now learnt at world level. There is something fundamentally \
wrong in the relation between society in general and science & learning. For \
the democratic setup of each nation it is advisable to have both an ",
 StyleBox["Economic Supreme Court",
  FontSlant->"Italic"],
 " and a ",
 StyleBox["National Assembly of Science and Learning",
  FontSlant->"Italic"],
 ". We want to save lives and livelihoods but let us not forget fundamental \
insights about democracy and science & learning. "
}], "Text",ExpressionUUID->"a820b73e-d842-42e4-9013-7353464bfd0b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Keywords and codes", "Subsection",ExpressionUUID->"5f5ebbd3-c59d-471a-a463-08839b36505d"],

Cell["\<\
Journal of Economic Literature (JEL) codes: P16 (political economy), E66 \
(macro-economics, general outlook), I18 (public health), Q56 \
(sustainability), D60 (welfare economics), A12 (general economics and \
teaching, relation to other disciplines)\
\>", "Text",ExpressionUUID->"33389205-9643-4130-9850-1d550c508802"],

Cell["\<\
Medical Subject Headings (MeSH) (IDs): D011634 (Public health), C000656484 \
(COVID-19), D004813 (Epidemiology), D000066949 (Biobehavioral sciences), \
D015233 (Models, Statistical), D000075082 (Proof of Concept Didactics), \
D017145 (Models, Educational), D004778 (Environment and public health), \
D000072440 (Public health systems research), D040381 (Education, public \
health professional), D006285 (Health planning), D004989 (ethics)\
\>", "Text",ExpressionUUID->"6aa1324f-9dc1-498e-82ce-e517a8c11e4a"],

Cell["\<\
MSC2010: 92D30 (Epidemiology),  \t92C60 (Medical epidemiology), 91B64 \
(Macroeconomic theory), 91B76 (Environmental economics), 00-01 (Introductory \
exposition)\
\>", "Text",ExpressionUUID->"7458ceaf-4456-4215-9ab4-1f114cde1edf"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Disclaimer and declaration of interest", "Subsection",ExpressionUUID->"7e4de916-2973-4a6c-be36-80ae4eb0dd32"],

Cell[TextData[{
 "Thomas Colignatus is the scientific name of Thomas Cool, econometrician \
(Groningen 1982) and teacher of mathematics (Leiden 2008), in Scheveningen, \
The Netherlands. He worked at Erasmus Medical Center (Rotterdam 2002-2004) on \
(Markov) modeling for screening on the Human Papilloma Virus (HPV) concerning \
cervical cancer.  The article has used software of ",
 StyleBox["The Economics Pack. Applications of Mathematica",
  FontSlant->"Italic"],
 ", which has been developed by the author since 1993, which is proprietary \
software, available at a price, and not falling under the CC license for the \
PDF. The targeted publication venue is not a journal but a book publisher."
}], "Text",ExpressionUUID->"aa7bf6fe-346c-4815-a637-81cff0e4120a"],

Cell["\<\
(c) Thomas Colignatus 2020
CC BY-NC-ND \
\>", "Text",ExpressionUUID->"5be68f92-3cd6-415c-89ac-7cc63217f971"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Table of contents", "Section",
 PageBreakAbove->True,ExpressionUUID->"1e3113db-1d7a-4d33-a35a-9576b1cc06da"],

Cell["Abstract", "Outline3",ExpressionUUID->"9a03be24-0463-448e-bf8e-7bcab99835ba"],

Cell["Keywords and codes", "Outline3",ExpressionUUID->"213b0ef9-4382-4074-8ec9-1564fc1eeca9"],

Cell["Disclaimer and declaration of interest", "Outline3",ExpressionUUID->"c7f5fb92-2365-4937-8d8d-5cb78372baff"],

Cell["1. Introduction", "Outline2",ExpressionUUID->"f3a927df-75bf-4d2c-9c44-451966a1c491"],

Cell["1.1. What this notebook and package do", "Outline3",ExpressionUUID->"df580587-d56d-47f7-a7a8-d9336a512983"],

Cell["1.1.1. Didactic redesign", "Outline4",ExpressionUUID->"5ba064f2-fae8-4f13-9e2d-6b823411faf8"],

Cell["1.1.2. There already is an abundance", "Outline4",ExpressionUUID->"76e913e0-c0d8-4b4f-9a33-30df35e4c63e"],

Cell[TextData[{
 "1.1.3. Overview of this ",
 StyleBox["Introduction",
  FontSlant->"Italic"]
}], "Outline4",ExpressionUUID->"9b16958a-e919-4ebf-a170-b3bc3caf3dba"],

Cell["1.2. The renaming S(E)IR(D) \[Rule] SI(EY)A(CD)", "Outline3",ExpressionUUID->"a7a1d746-9cda-4e77-b857-c574609fdd43"],

Cell["\<\
1.3. Infection Fatality Factor (IFF) and symptomatic Case Fatality Factor \
(sCFF)\
\>", "Outline3",ExpressionUUID->"65e70f34-0aa1-44da-99f5-2c09cd06adf3"],

Cell[TextData[{
 "1.4. The meaning of parameters ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "9227bf62-bfd2-47b4-aa4d-331d3fe5bbf5"],
 ", \[Alpha], \[Beta] and \[Gamma]"
}], "Outline3",ExpressionUUID->"d4d0e66d-f32f-4f6d-a274-9a21bdb1ce01"],

Cell["1.4.1. Euler 1767", "Outline4",ExpressionUUID->"1941804d-f240-49ee-a2b5-01beb741e923"],

Cell["1.4.2. Constant generation interval", "Outline4",ExpressionUUID->"a16317cb-7751-486b-8820-2e7d670e28b3"],

Cell["1.4.3. Normal distribution", "Outline4",ExpressionUUID->"d9b7c9c2-1907-459f-ab54-b3a891ff4261"],

Cell["1.4.4. The SI(EY)A(CD) family", "Outline4",ExpressionUUID->"6dcdbd00-41f8-43cf-8451-e5042cd3c598"],

Cell["1.4.5. Empirical distributions", "Outline4",ExpressionUUID->"e3dcfe10-37c7-48c6-80cd-73ba60e3078b"],

Cell["1.4.6. Interpretation of \[Gamma], also for estimation", "Outline4",ExpressionUUID->"79742a00-fbba-47bd-a2e2-08b2051650eb"],

Cell["\<\
1.5. Benefit of better didactics on SI(EY)A(CD) epidemic models. \
Understanding herd immunity\
\>", "Outline3",ExpressionUUID->"b85f4821-6e59-4585-bfad-f2e0adff5507"],

Cell["1.5.1. General understanding and communication", "Outline4",ExpressionUUID->"5a10b327-c425-4f98-bd88-6dac7cb4faca"],

Cell["1.5.2. Interpreting official reports", "Outline4",ExpressionUUID->"78742817-7192-43b4-a54f-186d60556ffa"],

Cell["1.5.3. Remarkable statistical fits", "Outline4",ExpressionUUID->"856e3644-6c13-4561-8b4a-8791c4e45023"],

Cell["1.5.4. Limit values", "Outline4",ExpressionUUID->"3ad5544c-6eca-4a52-93f1-43834b334161"],

Cell["1.5.5. Understanding herd immunity", "Outline4",ExpressionUUID->"21f1e8d7-8329-495d-ae20-88f22070566d"],

Cell["1.5.6. Relevance of better didactics", "Outline4",ExpressionUUID->"5bfcf36b-4919-463d-9765-430ea22aa679"],

Cell["\<\
1.6. A nasty virus, asking for eradication. A challenge anyway\
\>", "Outline3",ExpressionUUID->"f3f58ef3-97d1-4cf9-beee-ca559eb27d93"],

Cell["1.6.1. A world at risk but also badly managed", "Outline4",ExpressionUUID->"49d6fff8-f438-48d6-ba03-2b33f847d05e"],

Cell["1.6.2. Prevent future pandemics", "Outline4",ExpressionUUID->"5abd7ba7-7a51-4bb5-9a61-8c6a497886d0"],

Cell["1.6.3. A nasty virus, asking for eradication", "Outline4",ExpressionUUID->"241977fa-4c5f-4903-98d0-a74ba8959cbd"],

Cell["\<\
1.6.4. Under normal conditions the virus can no longer be contained\
\>", "Outline4",ExpressionUUID->"7f1ace26-ad46-4905-8a58-ab4a792cc7a8"],

Cell["\<\
1.6.5. Return to some normalcy, or consider what urgently requires improvement\
\>", "Outline4",ExpressionUUID->"f1489256-8036-4169-a6c3-ef2c6547799d"],

Cell["\<\
1.6.6. While there is no vaccine: options for an exit strategy\
\>", "Outline4",ExpressionUUID->"5dee13ed-9857-4efe-9a13-184306403501"],

Cell["1.6.7. Information that is missing now about such scenarios", "Outline4",ExpressionUUID->"d1ae7bed-d132-4be7-ba8f-056c935086ec"],

Cell["1.7. Summary of a complex objective", "Outline3",ExpressionUUID->"9ee090d0-f347-43af-adba-2e3c82888f4e"],

Cell["1.8. Structure of this notebook", "Outline3",ExpressionUUID->"b8fdb558-a024-4578-a3bf-3c41676a7235"],

Cell["1.9. About the author", "Outline3",ExpressionUUID->"fc861aa0-2f47-43f4-9a26-54d6ca16914d"],

Cell["1.9.1. Caveat", "Outline4",ExpressionUUID->"5d20e2e3-eba7-499c-b466-b5a30ad8c22b"],

Cell["1.9.2. Work related to medicine", "Outline4",ExpressionUUID->"96d47c49-578c-4c92-9d8c-0b7b08049bbf"],

Cell["2. Timeline and assumptions of the Dutch case", "Outline2",ExpressionUUID->"41e40de5-126c-464e-83fd-4614c52b6bee"],

Cell["2.1. Introduction", "Outline3",ExpressionUUID->"81ea97c5-0b56-4385-a9dc-f32b63d3e954"],

Cell["\<\
2.2. Properties of SARS-CoV-2 and some support for the Dutch policy statement \
of 2020-03-16\
\>", "Outline3",ExpressionUUID->"f79bdb39-438b-46b2-b741-d799e45f8ae0"],

Cell["2.3. Relating to the RIVM data and parameters (1)", "Outline3",ExpressionUUID->"4a54319e-47e7-441e-8217-4007185d60fc"],

Cell[TextData[{
 "2.4. Basic parameters ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "f37f0c46-1d50-4c0d-bbb1-3206ef1920bd"],
 ", \[Alpha], \[Beta] and \[Gamma] for unmitigated spreading before the \
lockdown"
}], "Outline3",ExpressionUUID->"8ec051e5-c9ad-490a-afb2-80768d7bc62e"],

Cell["2.4.1. Choice of latency \[Alpha]", "Outline4",ExpressionUUID->"3ac8e997-c97e-4c45-88f6-61f3b2ba5bcc"],

Cell[TextData[{
 "2.4.2. Choice of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "53623dd7-6500-4adb-82e9-ee87f7191557"]
}], "Outline4",ExpressionUUID->"587a0821-2eda-44cc-8285-ec58c4d3b300"],

Cell["2.4.3. Choice of \[Gamma] ", "Outline4",ExpressionUUID->"a9217be0-9074-4523-a9b0-a5b8c0a05464"],

Cell["2.4.4. Consequence for \[Beta]", "Outline4",ExpressionUUID->"678a7e96-eb43-4336-a7b1-ce47e48f665a"],

Cell[TextData[{
 "2.4.5. General understanding about the choice of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "4764ff27-d673-4a97-87d8-d50c044ce3c6"]
}], "Outline4",ExpressionUUID->"499c67be-25f2-4f2e-9e62-4441ac862c76"],

Cell["2.5. Choice of Infection Fatality Factor (\[CurlyPhi] = IFF)", \
"Outline3",ExpressionUUID->"b6e36202-0819-40e4-9150-fce27a461097"],

Cell["\<\
2.6. A timeline with scores from a SEYCD model without intervention\
\>", "Outline3",ExpressionUUID->"9710a925-2927-4292-b907-1b3c4de1670a"],

Cell["\<\
2.7. Dutch data are unreliable, but the 70-79 age group might be stable\
\>", "Outline3",ExpressionUUID->"510d873e-7e12-428b-a1ff-57889db4f7ee"],

Cell["\<\
2.8. Timeline of the Dutch case, to determine onset and when \[Beta] changed\
\>", "Outline3",ExpressionUUID->"4a355cab-b7e4-4bb2-9b1e-a1f5b249ca84"],

Cell["2.9. Relating to the RIVM data and parameters (2)", "Outline3",ExpressionUUID->"27fd0884-e008-42e9-b56e-b15e85798237"],

Cell["2.9.1. Introduction", "Outline4",ExpressionUUID->"79702a94-f491-43c0-b80f-7985d4396c0d"],

Cell["\<\
2.9.2. RIVM & the Outbreak Management Team (OMT) (2020) on source and contact \
tracing\
\>", "Outline4",ExpressionUUID->"97c4eee0-071b-4de5-8850-931156deb4f7"],

Cell["2.9.3. RIVM January 27", "Outline4",ExpressionUUID->"4bdc0142-c0b8-49d3-8c78-061f27f8ccdd"],

Cell["2.9.4. RIVM March 25", "Outline4",ExpressionUUID->"5ed53fe4-8de3-4937-8959-0e618703c575"],

Cell["2.9.5. RIVM April 8", "Outline4",ExpressionUUID->"eb21e1e3-94cb-4a65-8017-83dabc82284b"],

Cell["2.9.6. RIVM April 22", "Outline4",ExpressionUUID->"4d7efccb-9381-4541-96a0-8a788fcbd589"],

Cell["2.9.7. RIVM May 7", "Outline4",ExpressionUUID->"6711b247-2702-48e1-84ce-73b656471006"],

Cell["2.9.8. RIVM May 20", "Outline4",ExpressionUUID->"23033705-da86-4926-9468-797b59bb15dd"],

Cell["2.9.9. RIVM May 25", "Outline4",ExpressionUUID->"f9056c18-1f18-4722-b2eb-a2fa8c5401bc"],

Cell["2.10. A partial result of this exercise", "Outline3",ExpressionUUID->"66f267d7-43bc-40c0-8543-08b620d2d681"],

Cell["2.10.1. A result for us", "Outline4",ExpressionUUID->"98758d8f-6613-429c-b276-2c5d940c9b95"],

Cell["2.10.2. A list of questions for others", "Outline4",ExpressionUUID->"9406b781-7380-4450-9517-299f6e056a10"],

Cell["3. The package", "Outline2",ExpressionUUID->"0b410c68-835d-4e1a-9add-306fd70fae58"],

Cell["\<\
3.1. Caveat: This is didactics. The package only hints at the real world\
\>", "Outline3",ExpressionUUID->"a271c4b7-eb1b-4208-aa70-4692218fecb0"],

Cell["3.2. Design / Redesign of didactics", "Outline3",ExpressionUUID->"addc6317-1e0b-496e-a2fa-cea29e6b1c6b"],

Cell[TextData[{
 "3.2.1 Avoid using ",
 StyleBox["R ",
  FontSlant->"Italic"],
 "for compartments, and instead use ",
 StyleBox["A ",
  FontSlant->"Italic"],
 "and",
 StyleBox[" C",
  FontSlant->"Italic"]
}], "Outline4",ExpressionUUID->"2271ceca-977f-47ce-95b7-9dfbf11e3658"],

Cell[TextData[{
 "3.2.2. Have ",
 StyleBox["D",
  FontSlant->"Italic"],
 " = \[CurlyPhi] A",
 StyleBox[" ",
  FontSlant->"Italic"],
 "as an explicit proportion"
}], "Outline4",ExpressionUUID->"14ed83aa-381f-430b-b63b-e7b4ca4bf3a7"],

Cell[TextData[{
 "3.2.3. One single conceptual model SIA with two kinds of splits: ",
 StyleBox["A = C + D",
  FontSlant->"Italic"],
 " and ",
 StyleBox["I = E + Y",
  FontSlant->"Italic"]
}], "Outline4",ExpressionUUID->"76fe102c-6756-4da6-8909-25f0a0130950"],

Cell["3.2.4. Separate models but joint options", "Outline4",ExpressionUUID->"64a73211-d157-4a62-b341-39385531460d"],

Cell["3.2.5. Joint set of parameters and variables", "Outline4",ExpressionUUID->"e2fabd7e-eeec-41ba-9779-2a3332bcf365"],

Cell["\<\
3.2.6. Distinction between infections and symptomatic disease\
\>", "Outline4",ExpressionUUID->"8b403f7a-dfb1-40d2-b736-282fe97dcc1c"],

Cell["3.2.7. Models SEYCDT and SEYCDB for estimation", "Outline4",ExpressionUUID->"50297b57-abb4-4b26-877e-a2a9a5914e91"],

Cell["3.2.8. Modularity", "Outline4",ExpressionUUID->"5861d1fc-2f3e-43ee-8ade-baaf6a414de3"],

Cell["3.2.9. Administration of scenarios", "Outline4",ExpressionUUID->"13b4ef1d-c47c-4a41-9c71-87f481234f44"],

Cell["3.3. General setting on programming", "Outline3",ExpressionUUID->"50019cc6-92a2-4366-99d4-6aaa28e4ee35"],

Cell[TextData[{
 "3.3.1. Reasons for choosing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Outline4",ExpressionUUID->"f3a605dc-b85e-4c85-9c74-873338d52739"],

Cell[TextData[{
 "3.3.2. ",
 StyleBox["The Economics Pack",
  FontSlant->"Italic"]
}], "Outline4",ExpressionUUID->"b85c3620-04ee-4c54-b6b2-19657207df5a"],

Cell["3.4. The SIA package", "Outline3",ExpressionUUID->"cc5d8d98-79be-454b-9bd5-afe9708510de"],

Cell["\<\
3.5. Initialisation cells for loading of The Economics Pack and Survival`SIA`\
\>", "Outline3",ExpressionUUID->"bf771b0e-8e1f-4464-8871-967808d96b48"],

Cell["3.5.1. The Economics Pack", "Outline4",ExpressionUUID->"243db3ac-97e3-448a-aa3c-ff8110b17158"],

Cell["3.5.2. The survival packages", "Outline4",ExpressionUUID->"3463cf31-e64e-4a6b-8741-ab373e2ad4f9"],

Cell["3.5.3. ApplySIA` (not documented)", "Outline4",ExpressionUUID->"8895ba1e-7883-415d-b6f6-ed0a3f7c2d8c"],

Cell["4. Compartments", "Outline2",ExpressionUUID->"bb59762e-0c8b-44ff-ae88-698dcff322aa"],

Cell["4.1. Principle", "Outline3",ExpressionUUID->"ea7ae742-3ade-4905-9c77-f6527be139b0"],

Cell["4.2. The meaning of red for regulation", "Outline3",ExpressionUUID->"383f8503-ab0c-4d29-ad5e-c86b88179a59"],

Cell["4.3. Suggested colour scheme", "Outline3",ExpressionUUID->"4f2cdab8-d2e9-4b72-8480-8649445d8b58"],

Cell["4.4. Use of these colours in the SI(EY)A(CD) plots", "Outline3",ExpressionUUID->"7ef59390-6b3d-4525-a8f7-b74ea6946411"],

Cell["4.5. When in lack of colours", "Outline3",ExpressionUUID->"66225526-42ff-47b6-be93-1af49fd28d80"],

Cell["5. SIA", "Outline2",ExpressionUUID->"9d5b124d-6433-4c00-a4bd-54915b158e6e"],

Cell["Clear", "Outline3",ExpressionUUID->"e6bd1c33-a7ac-4c2b-ad1f-4e41363e43c3"],

Cell["5.1. Basic model in standard formulas", "Outline3",ExpressionUUID->"7045fa41-c721-4437-a0c5-c98b3803f88f"],

Cell["5.2. Computable format", "Outline3",ExpressionUUID->"3468f202-6ea9-458e-a752-da2578bdd5f0"],

Cell["5.3. The different formats", "Outline3",ExpressionUUID->"d0ea4688-3e96-442c-9844-f2d5dcc9d362"],

Cell[TextData[{
 "5.4. Model formulation, choice of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "07b9ad77-e0d9-4d74-a29a-79ce7e4dcbca"],
 " = 4 and acquittal period of 10 days"
}], "Outline3",ExpressionUUID->"c0da8ede-ab01-4e23-9047-27199d71091b"],

Cell["5.5. Fast-track run and plot", "Outline3",ExpressionUUID->"ca70c04e-bbeb-496a-a64c-609acc0f4026"],

Cell["\<\
5.6. Interpretation of the result and finding crucial moments of the path\
\>", "Outline3",ExpressionUUID->"049878e8-24a4-41aa-88be-61c7e7021fee"],

Cell["5.7. Growth rates of SIA", "Outline3",ExpressionUUID->"3364b0a3-71ee-4c94-b236-5481398e40a7"],

Cell["5.7.1. Formal", "Outline4",ExpressionUUID->"384df6c2-b3f2-424d-9fa4-a88ba2f2ce96"],

Cell["\<\
5.7.2. An important analytical result for the long term limit values\
\>", "Outline4",ExpressionUUID->"8e993861-809f-4585-af6b-d3ee441e229e"],

Cell["5.7.3. Plotting numerical results", "Outline4",ExpressionUUID->"edbc9a6c-9650-4f9c-92b9-c135465d2502"],

Cell["5.7.4. Difference between SIA and exponential functions", "Outline4",ExpressionUUID->"58ef5bfb-d214-440a-b1ba-881c82f4ccb0"],

Cell["5.8. How to use the SIA routine", "Outline3",ExpressionUUID->"03297fcb-0d32-4a6b-a396-e03d1899762f"],

Cell["Appendix: In steps (for more control of details)", "Outline3",ExpressionUUID->"e11d600f-9c03-4b90-83de-9fa6f02424b0"],

Cell["Meaning of this appendix", "Outline4",ExpressionUUID->"1d78ff9b-2f3c-4766-92f1-f48977203384"],

Cell["Setting the size of the population and other options", "Outline4",ExpressionUUID->"bfc49c66-37cc-4155-805e-ddcecac1e6d6"],

Cell[TextData[{
 "Choosing a model with formal ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["t", "0"], TraditionalForm]],ExpressionUUID->
  "f014164c-7312-4589-8490-cc45b56c248a"],
 " or with the Onset from the options"
}], "Outline4",ExpressionUUID->"ef23e4c3-718d-4b59-9bc7-4ad974267d87"],

Cell["\<\
Solving and approximating by NDSolve for a specified time window\
\>", "Outline4",ExpressionUUID->"ea2b601b-1b35-4616-8b7a-d1ae4b3356fc"],

Cell["Making the variables directly available", "Outline4",ExpressionUUID->"206b6cfb-056e-48be-971b-7df52044f8c5"],

Cell["Plotting in levels and proportions", "Outline4",ExpressionUUID->"0d74de65-0041-4dbc-a033-54ca909a99f5"],

Cell["PM. Separate levels and proportions", "Outline4",ExpressionUUID->"bbf60642-5e35-41cf-acf3-881a36a03445"],

Cell["\<\
Appendix: Comparison with the traditional form for the equations\
\>", "Outline3",ExpressionUUID->"f2d5c7d3-eb19-4d50-a39b-f7ca43a3eef1"],

Cell["Appendix: Technical notes", "Outline3",ExpressionUUID->"3afb3329-34ed-4c8f-8a38-0ce1c391fcff"],

Cell["6. Analytical properties of SIA", "Outline2",ExpressionUUID->"50f9212d-f6d8-407f-af28-209c52bb2435"],

Cell["6.1. Proportionality between numbers and proportions", "Outline3",ExpressionUUID->"8e8d24a4-5ab2-46f1-92cf-0479a91d203c"],

Cell["6.2. Exponential phases, doubling period and half-life", "Outline3",ExpressionUUID->"317b1421-1e88-4eb9-9bf4-e6cbc921a3a5"],

Cell[TextData[{
 "6.3. ",
 StyleBox["Effective reproduction factor R",
  FontSlant->"Italic"],
 "[",
 StyleBox["t",
  FontSlant->"Italic"],
 "], ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["R", "0"], ","}], TraditionalForm]],ExpressionUUID->
  "d8a1713c-2498-4a83-bf5a-63ad13e4975f"],
 StyleBox[" ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "00"], TraditionalForm]],ExpressionUUID->
  "c2cf99e0-14fb-48be-9b07-c669a4f204f7"]
}], "Outline3",ExpressionUUID->"9043a254-1efd-4073-9770-8e2e167bea51"],

Cell[TextData[{
 "6.3.1. Dynamic \[Beta][",
 StyleBox["t",
  FontSlant->"Italic"],
 "] / \[Gamma][",
 StyleBox["t",
  FontSlant->"Italic"],
 "] and effective reproduction factor ",
 StyleBox["R",
  FontSlant->"Italic"],
 "[",
 StyleBox["t",
  FontSlant->"Italic"],
 "]"
}], "Outline4",ExpressionUUID->"a0d54c86-493e-4421-ae1e-be4e148d3962"],

Cell[TextData[{
 "6.3.2. Basic reproduction factor ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "1a486018-bf0f-4379-b1c9-fc8f0e3d4cc1"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "= ",
 StyleBox["R",
  FontSlant->"Italic"],
 "[",
 Cell[BoxData[
  FormBox[
   SubscriptBox["t", "0"], TraditionalForm]],ExpressionUUID->
  "4a4ad2b6-1dfd-4b42-b312-4d9ad4d4c17e"],
 "] = \[Beta][",
 Cell[BoxData[
  FormBox[
   SubscriptBox["t", "0"], TraditionalForm]],ExpressionUUID->
  "a0b7fc10-b30d-4cf1-b9e2-63a628d3862c"],
 "] / \[Gamma][",
 Cell[BoxData[
  FormBox[
   SubscriptBox["t", "0"], TraditionalForm]],ExpressionUUID->
  "de86abff-4ec3-4483-9ad5-cfaf51b599f2"],
 "] = \[Beta] / \[Gamma] (assuming ",
 StyleBox["Sp",
  FontSlant->"Italic"],
 "[",
 Cell[BoxData[
  FormBox[
   SubscriptBox["t", "0"], TraditionalForm]],ExpressionUUID->
  "fd860daf-ae79-4eae-8ce8-571f2b2d04e1"],
 "]",
 StyleBox[" ",
  FontSlant->"Italic"],
 "\[Rule] 1)"
}], "Outline4",ExpressionUUID->"28eb39ce-b0c1-4977-a862-055123d0471c"],

Cell["6.4. Growth rate and steady state", "Outline3",ExpressionUUID->"c0ee66ad-9338-43d3-8c12-533b3d2692b3"],

Cell["6.4.1. Dynamics of infection", "Outline4",ExpressionUUID->"3e7b7784-001a-43d6-b46d-c6b45e91f789"],

Cell["\<\
6.4.2. Comparison to a disease with a steady state of inflow and outflow\
\>", "Outline4",ExpressionUUID->"e7460687-f4a9-4282-af93-87c703c27f57"],

Cell["\<\
6.5. Maximal infections at the origin or later in the process\
\>", "Outline3",ExpressionUUID->"281589f9-50c1-4e2a-a1f9-031b606d0e31"],

Cell[TextData[{
 "6.5.1. A maximum at the seed when ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["S", "p"], TraditionalForm]],ExpressionUUID->
  "c8364366-2665-49c3-a358-4b9a44b79470"],
 "[0] \[LessEqual] 1 / ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "825930b7-f3e0-4377-91bf-23c16881c09f"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "and thereafter decay"
}], "Outline4",ExpressionUUID->"e451d1c6-af7f-4ac3-a7bd-36a3ba6ed018"],

Cell[TextData[{
 "6.5.2. A maximum after the seed when ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["S", "p"], TraditionalForm]],ExpressionUUID->
  "41215605-e695-4242-8406-fa85f21a2d41"],
 "[0] > 1 / ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "e72e7ca6-c783-45c0-8b8a-191ee932ba70"],
 StyleBox[" ",
  FontSlant->"Italic"]
}], "Outline4",ExpressionUUID->"0107d0af-4200-4b2a-bc9e-bfd389cbf536"],

Cell[TextData[{
 "6.6. Later in the process, consequences of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "6f83e375-9d63-47a8-98f9-4ae7d92fa346"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "> 1 / ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["S", "p"], TraditionalForm]],ExpressionUUID->
  "53d3fbb1-213c-49c4-9eef-36b902e8e97a"],
 "[0], \[OpenCurlyDoubleQuote]the\[CloseCurlyDoubleQuote] top of infections"
}], "Outline3",ExpressionUUID->"36da0b64-5559-4688-b7e6-af5e7e562884"],

Cell["6.6.1. The values of the shares at the top", "Outline4",ExpressionUUID->"5b1c0057-524f-48fd-ace2-d13d3d296b4e"],

Cell[TextData[{
 "6.6.2. The value of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["t", "Top"], TraditionalForm]],ExpressionUUID->
  "e353b6af-633d-49ac-984e-6d070bb36110"]
}], "Outline4",ExpressionUUID->"e443e4ae-d56d-42d6-b1e2-a111b7e95eb4"],

Cell["6.7. The exponential growth phase revisited", "Outline3",ExpressionUUID->"3929daf1-477f-4969-b06c-af7776378a99"],

Cell["\<\
6.8. Exponential growth and exponentially distributed acquittal periods\
\>", "Outline3",ExpressionUUID->"325fc70e-7a3f-4dcc-8655-eb03e24032ed"],

Cell["\<\
6.8.1. One function for two purposes: probability and dynamics\
\>", "Outline4",ExpressionUUID->"457e09f5-bbf2-403f-93e8-7a1b53ad00e9"],

Cell["6.8.2. Plotting with mean acquittal period 1 / \[Gamma]", "Outline4",ExpressionUUID->"5a6e415a-5bbb-4208-96a2-5238089c023a"],

Cell["\<\
6.8.3. Interpretation of the mean acquittal period 1 / \[Gamma] in SIA\
\>", "Outline4",ExpressionUUID->"fdb4ee11-fb4f-467e-b324-e2367ae6158b"],

Cell[TextData[{
 "6.9. The limit with the ",
 StyleBox["Lambert W ",
  FontSlant->"Italic"],
 "or ",
 StyleBox["ProductLog ",
  FontSlant->"Italic"],
 "function"
}], "Outline3",ExpressionUUID->"ef6e2d1a-111c-4652-b054-f9ba507995cb"],

Cell["6.9.1. Finding the limit values", "Outline4",ExpressionUUID->"b1504dad-6dd0-442e-bdbd-f8569eed7788"],

Cell["6.9.2. Difference between top and limit outcomes", "Outline4",ExpressionUUID->"ff6b4447-42db-4acd-ad3b-a0b47038a75c"],

Cell["6.9.3. Deduction", "Outline4",ExpressionUUID->"3726c11a-b9ff-4488-808e-ba934de590b9"],

Cell["6.10. The importance of t50 and t95", "Outline3",ExpressionUUID->"bcee379e-d026-410e-9b84-14cc2c4c1bb4"],

Cell["6.11. Herd immunity", "Outline3",ExpressionUUID->"3c11d971-e903-419d-a2b4-3775e66d1ba4"],

Cell["\<\
6.11.1. Population immunity, herd immunity and pseudo herd immunity\
\>", "Outline4",ExpressionUUID->"89052a5d-fc1c-4aeb-aac7-48aa9608efce"],

Cell["6.11.2. Solving for an assumed herd immunity", "Outline4",ExpressionUUID->"96e0113a-7b5f-4f82-9653-5cfe3772c3c0"],

Cell["\<\
6.11.3. A confusing notion of heard immunity from a consideration of the \
steady state\
\>", "Outline4",ExpressionUUID->"bdfe2485-df06-41b2-8edf-1242e63051a3"],

Cell["6.11.4. In sum", "Outline4",ExpressionUUID->"dcaf0a2d-49d3-4e79-a02c-10986031d4d4"],

Cell["6.12. Attack rate vs force of infection", "Outline3",ExpressionUUID->"d4a2221b-4a37-4277-bbb6-aab3b458d8c3"],

Cell["7. SICD", "Outline2",ExpressionUUID->"03b757f2-ab6e-4038-9a38-6b10bf8ccedd"],

Cell["Clear", "Outline3",ExpressionUUID->"46a0fece-3a71-4002-8547-ad2cfb87fed8"],

Cell["7.1. Fast-track run and plot", "Outline3",ExpressionUUID->"e7ad23d4-7c0a-48e4-9363-5a74c5f2005d"],

Cell["7.2. Relation to capacity of ICU beds", "Outline3",ExpressionUUID->"13a3468f-5bc3-48e7-803d-0c9f6df8c997"],

Cell[TextData[{
 "7.3. Inclusion of ",
 StyleBox["C ",
  FontSlant->"Italic"],
 "and ",
 StyleBox["D ",
  FontSlant->"Italic"],
 "in SIA"
}], "Outline3",ExpressionUUID->"dad88a0e-e4f2-43ea-a2e4-f999039b3577"],

Cell["7.3.1. Introduction", "Outline4",ExpressionUUID->"d7f9d962-7b32-4ebb-9604-27d90f2439e6"],

Cell[TextData[{
 "7.3.2. The traditional format for ",
 StyleBox["C",
  FontSlant->"Italic"],
 " and ",
 StyleBox["D ",
  FontSlant->"Italic"],
 "causes conceptual questions"
}], "Outline4",ExpressionUUID->"8ea62f73-94d8-4726-a3f8-33fa423b681e"],

Cell[TextData[{
 "7.3.3. A clearer format for ",
 StyleBox["C",
  FontSlant->"Italic"],
 " and ",
 StyleBox["D ",
  FontSlant->"Italic"],
 "but still not perfect"
}], "Outline4",ExpressionUUID->"4e5d599a-6c44-4c99-aee3-8514a84ccfe0"],

Cell[TextData[{
 "7.3.4. Didactically clearest format for ",
 StyleBox["C",
  FontSlant->"Italic"],
 " and ",
 StyleBox["D",
  FontSlant->"Italic"]
}], "Outline4",ExpressionUUID->"6c4f622f-80af-48ed-9623-069dfa4c1eae"],

Cell["7.4. Basic model ", "Outline3",ExpressionUUID->"6afc7163-a064-4c5f-bbfb-763369f80554"],

Cell[TextData[{
 "7.5. Computable format (",
 StyleBox["Copy from SIA",
  FontSlant->"Italic"],
 ")"
}], "Outline3",ExpressionUUID->"c6cd69dd-0fea-4cdc-a72a-b2f639e0637c"],

Cell["7.6. The didactic and traditional formats", "Outline3",ExpressionUUID->"f76e80fd-ea70-40b5-af9d-2bd5f0349aa2"],

Cell[TextData[{
 "7.7. Choice of ",
 Cell[BoxData[
  SubscriptBox["R", "0"]],ExpressionUUID->
  "ef957bcf-492e-4e3a-9da3-6c7637b036c9"],
 " = 4 and acquittal period of 10 days (",
 StyleBox["Copy from SIA",
  FontSlant->"Italic"],
 ")"
}], "Outline3",ExpressionUUID->"c0aaba07-6e95-4b27-9ea9-f2d76b3275cc"],

Cell["\<\
7.8. Infection Fatality Factor (IFF) and symptomatic Case Fatality Factor \
(sCFF)\
\>", "Outline3",ExpressionUUID->"d4fc5ffa-ea92-49ff-8989-cb48c7cca411"],

Cell["7.8.1. Infections versus symptomatic cases", "Outline4",ExpressionUUID->"b269bd6d-868f-4417-81c3-f9ae62f81b45"],

Cell[TextData[{
 "7.8.2. IFF[",
 StyleBox["t",
  FontSlant->"Italic"],
 "] and the eventual limit value IFF[\[Infinity]]"
}], "Outline4",ExpressionUUID->"32da4979-6e19-476d-b842-730d618395d8"],

Cell["\<\
7.8.3. Short conversion from IFF (observation) to IFR (model parameter \[Mu])\
\>", "Outline4",ExpressionUUID->"23893093-1a9d-472a-98f1-872b7f5a8268"],

Cell["\<\
7.8.4. An expected death toll of 250,000, if there had been no interventions\
\>", "Outline4",ExpressionUUID->"221466a4-925f-4654-a338-e6a3e6113113"],

Cell["\<\
7.8.5. Traditional limit, IFF (observation) \[Rule] (model parameter \[Mu]), \
starting values\
\>", "Outline4",ExpressionUUID->"c1147a0d-0bc1-4c58-8d69-8ff71f5bf19e"],

Cell["7.8.6. A small check on consistency of the starting values", "Outline4",ExpressionUUID->"e545c879-cb69-4081-9ba5-0d62e91581e4"],

Cell["7.8.7. Summary of terms", "Outline4",ExpressionUUID->"381f42e2-dc6c-4940-8276-735bc71e7d64"],

Cell["\<\
7.9. Interpretation of the result and finding crucial moments of the path\
\>", "Outline3",ExpressionUUID->"612b399d-b989-4e2b-9b0d-d5fff2c1bb20"],

Cell["7.10. How to use the SICD routine", "Outline3",ExpressionUUID->"8ebbf7a6-beae-4524-a0e0-a82f715ce09d"],

Cell["Appendix. In steps (for management of details)", "Outline3",ExpressionUUID->"fabed3d6-d219-4cb9-b932-b03b0b7ad255"],

Cell["Setting the size of the population and other options", "Outline4",ExpressionUUID->"cb1bd208-66f4-4142-ba12-6b0f140ff9ec"],

Cell[TextData[{
 "Choosing a model with formal ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["t", "0"], TraditionalForm]],ExpressionUUID->
  "552f70c6-398c-46c8-9815-64dd0d140eef"],
 " or with the Onset from the options"
}], "Outline4",ExpressionUUID->"1b7e510f-2a01-4073-8446-74cac5e6059c"],

Cell["\<\
Solving and approximating by NDSolve for a specified time window\
\>", "Outline4",ExpressionUUID->"5c818ab9-557f-4a46-90d9-5d1297c585e7"],

Cell["Making the variables directly available", "Outline4",ExpressionUUID->"df9feedf-260d-4239-b2ae-9d17a574601a"],

Cell["Plotting in levels and proportions", "Outline4",ExpressionUUID->"7fa3857b-0ce8-4122-9936-7d74b4350aa6"],

Cell["Recapitulation", "Outline4",ExpressionUUID->"2a09fb4d-08ae-43d7-b71a-e1d69276c932"],

Cell["Proportions ", "Outline4",ExpressionUUID->"ac48d150-7dee-435b-9fdc-3b7e8be5c402"],

Cell["\<\
Appendix. Comparison with the traditional form for the equations\
\>", "Outline3",ExpressionUUID->"1d57b065-4b0d-489b-a5be-3c19155a578d"],

Cell["\<\
Appendix. The mistake to regard 1 / \[Mu] and 1 / \[Lambda] as implied \
infectious periods\
\>", "Outline3",ExpressionUUID->"69810cae-362a-4962-972d-9fc4d0df69b5"],

Cell["8. SI(EY)A(CD)", "Outline2",ExpressionUUID->"c1db9795-7a9c-4168-af92-c92ce79aebfc"],

Cell["Clear", "Outline3",ExpressionUUID->"7aabf7ae-2813-4e78-b92f-35a78b9ed479"],

Cell["8.1. Fast-track run and plot", "Outline3",ExpressionUUID->"9c99f2bc-9cfe-4c34-9ef3-736ecb931104"],

Cell["8.2. Relation to capacity of ICU beds", "Outline3",ExpressionUUID->"7c33ecbd-6c1e-450c-bdbf-501d25a2b592"],

Cell["8.3. Keeping the same compartments or recompartmentalise ?", "Outline3",ExpressionUUID->"9feedf98-6763-482a-be68-d1e626e67594"],

Cell["\<\
8.3.1. The traditional choice of keeping the same word \
\[OpenCurlyDoubleQuote]infectious\[CloseCurlyDoubleQuote]\
\>", "Outline4",ExpressionUUID->"544cff50-d900-4884-96a0-8aa2628c627b"],

Cell["\<\
8.3.2. The didactic approach to maintain the same compartments\
\>", "Outline4",ExpressionUUID->"50058233-5681-4cb2-b0ef-02097451464c"],

Cell["8.3.3. The choice (leave it up to the user)", "Outline4",ExpressionUUID->"f44ce273-b72e-4783-84df-3e52464bada0"],

Cell["8.4. Basic model in standard formulas (didactic format)", "Outline3",ExpressionUUID->"4806beb5-7f0c-42a7-a74b-622d0e1b907a"],

Cell[TextData[{
 "8.5. Computable format (",
 StyleBox["Copy from SIA",
  FontSlant->"Italic"],
 ")"
}], "Outline3",ExpressionUUID->"84f57353-6ccb-45cf-9f73-085ad787860e"],

Cell["8.6. The different formats", "Outline3",ExpressionUUID->"d38689d7-9d52-4fe5-93ee-3468eba7e6dc"],

Cell["\<\
8.7. Choice of parameters such that SEYCD is similar to SIA(CD)\
\>", "Outline3",ExpressionUUID->"62551a73-7cec-49f8-b56b-8a245ffc3547"],

Cell[TextData[{
 "8.8. The infection fatality rate (",
 StyleBox["Copy from SICD",
  FontSlant->"Italic"],
 ")"
}], "Outline3",ExpressionUUID->"70fcd6b5-c3ca-424c-baa7-60bf733c18ab"],

Cell[TextData[{
 "8.9. Choice of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["R",
    FontSlant->"Italic"], "0"]],ExpressionUUID->
  "aa39a636-36cd-4633-acbc-537356d6bc9b"],
 " = 4 and acquittal period of 10 days (",
 StyleBox["Copy from SIA",
  FontSlant->"Italic"],
 ")"
}], "Outline3",ExpressionUUID->"edf9f00b-fb30-43d8-8ad0-b45871c7da8f"],

Cell["8.10. How to use the SEYCD routine", "Outline3",ExpressionUUID->"7ce4907f-a41e-4f51-91e5-f6eeae927fa8"],

Cell["Appendix. Run in steps (for management of details)", "Outline3",ExpressionUUID->"481438aa-b84e-4a81-8a2c-34f65659ba5a"],

Cell[TextData[{
 "Appendix. Comparison with the traditional form for the equations (",
 StyleBox["Y = E + I",
  FontSlant->"Italic"],
 ")"
}], "Outline3",ExpressionUUID->"80475672-85b6-4a1b-90df-603c80ecdb39"],

Cell["9. Analytical properties of SEYCD", "Outline2",ExpressionUUID->"cd832d39-155e-4350-b45f-2bd132735d33"],

Cell["\<\
9.1. Using didactic SEYCD with I = E + Y rather than traditional SEYCD with Y \
= E + I\
\>", "Outline3",ExpressionUUID->"b051a8b9-0581-461e-a4eb-171e462e146f"],

Cell[TextData[{
 "9.2. The growth rate of ",
 StyleBox["I ",
  FontSlant->"Italic"],
 "depends upon ",
 StyleBox["Y ",
  FontSlant->"Italic"],
 "/",
 StyleBox[" I",
  FontSlant->"Italic"]
}], "Outline3",ExpressionUUID->"2d19b92f-8f2a-4f2b-9c4b-354aebce8f2e"],

Cell["\<\
9.3. The key equation on Sp, with consequences for top and limit\
\>", "Outline3",ExpressionUUID->"9a615241-d671-4c85-97de-4943fe80ac6b"],

Cell["9.3.1. For the limit", "Outline4",ExpressionUUID->"91c34bd4-eecb-439c-a16f-576096bbbcbc"],

Cell["9.3.2. For the top", "Outline4",ExpressionUUID->"45a7b8db-d321-42ec-92a9-bb8035167bf3"],

Cell[TextData[{
 "9.4. The top of ",
 StyleBox["I ",
  FontSlant->"Italic"],
 "at ",
 StyleBox["I",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote] = 0 is unchanged"
}], "Outline3",ExpressionUUID->"3f06aac4-29f2-41f5-85d9-c22d6a4cbd7d"],

Cell["9.4.1. Basics unchanged", "Outline4",ExpressionUUID->"9c543be7-aeb2-4766-a4c1-0c3bc1109900"],

Cell[TextData[{
 "9.4.2. ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    RowBox[{"{", 
     RowBox[{"S", ",", " ", "I", ",", " ", "A"}], "}"}], "Top"], 
   TraditionalForm]],ExpressionUUID->"41040c74-eae7-47ee-adcc-0b83c47efd74"],
 " are the same"
}], "Outline4",ExpressionUUID->"c1393468-1f44-4002-979f-5dca14eed694"],

Cell[TextData[{
 "9.4.3. To plot ",
 StyleBox["I ",
  FontSlant->"Italic"],
 "or not to plot ",
 StyleBox["I",
  FontSlant->"Italic"]
}], "Outline4",ExpressionUUID->"06e048bf-6b3c-4f40-ba3f-1324ece00f89"],

Cell["9.4.4. Main point: delay in the top", "Outline4",ExpressionUUID->"0ad681a3-7218-4e1d-a4a8-417e660bf023"],

Cell[TextData[{
 "9.4.5. Trying to find analytical values for ",
 StyleBox["E ",
  FontSlant->"Italic"],
 "and ",
 StyleBox["Y ",
  FontSlant->"Italic"],
 "at the top"
}], "Outline4",ExpressionUUID->"1f61299a-6c7c-4e4f-a5f2-d087deea490a"],

Cell[TextData[{
 "9.5. Summary on the top of ",
 StyleBox["I ",
  FontSlant->"Italic"],
 "at ",
 StyleBox["I",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote] = 0"
}], "Outline3",ExpressionUUID->"fb58207a-5be3-4716-bfdc-28a569095c54"],

Cell[TextData[{
 "9.6. The subsequent issues concern ",
 StyleBox["E ",
  FontSlant->"Italic"],
 "and ",
 StyleBox["Y, ",
  FontSlant->"Italic"],
 "and no longer ",
 StyleBox["S, I ",
  FontSlant->"Italic"],
 "and ",
 StyleBox["A",
  FontSlant->"Italic"]
}], "Outline3",ExpressionUUID->"d6dc22aa-c641-421d-9b9e-9dc55bacc08d"],

Cell[TextData[{
 "9.7. The top of ",
 StyleBox["E, ",
  FontSlant->"Italic"],
 "or when ",
 StyleBox["E\[CloseCurlyQuote] ",
  FontSlant->"Italic"],
 "= 0, giving routine TforTopEq"
}], "Outline3",ExpressionUUID->"8cf99e22-e4c5-4132-8c84-113f2a261ac6"],

Cell[TextData[{
 "9.8. The top of ",
 StyleBox["Y, ",
  FontSlant->"Italic"],
 "or when ",
 StyleBox["Y\[CloseCurlyQuote] ",
  FontSlant->"Italic"],
 "= 0, giving routine TforTopYq"
}], "Outline3",ExpressionUUID->"f6e67116-aa70-497f-813d-9d4ad17b2491"],

Cell["9.8.1. Analytically", "Outline4",ExpressionUUID->"81a1d2ff-8327-4b19-b251-347afab659a6"],

Cell["9.8.2. PM. On taking second derivatives", "Outline4",ExpressionUUID->"7129a0dd-0b14-4768-8e6c-794b42de003b"],

Cell["9.8.3. Numerically, giving routine TforTopYp", "Outline4",ExpressionUUID->"e65b774e-dc4d-4eb9-86d8-f97c8d8e5f23"],

Cell[TextData[{
 "9.8.4. Time between the tops of ",
 StyleBox["E, I",
  FontSlant->"Italic"],
 " and ",
 StyleBox["Y",
  FontSlant->"Italic"]
}], "Outline4",ExpressionUUID->"6183f4b1-8d9a-44c9-88ad-e74b37f22cb8"],

Cell[TextData[{
 "9.8.5. Substituting ",
 StyleBox["Y ",
  FontSlant->"Italic"],
 "in ",
 StyleBox["S\[CloseCurlyQuote]",
  FontSlant->"Italic"]
}], "Outline4",ExpressionUUID->"092481d6-d406-47d1-9462-53db4162a47e"],

Cell["9.8.6. Plotting {\[Gamma], \[Alpha]} / (\[Alpha] + \[Gamma]) Iq    ", \
"Outline4",ExpressionUUID->"af706440-ae66-4757-97af-7ca0cf5a87e0"],

Cell[TextData[{
 "9.9. Plots for ",
 StyleBox["E\[CloseCurlyQuote] ",
  FontSlant->"Italic"],
 "= 0 and ",
 StyleBox["Y\[CloseCurlyQuote] ",
  FontSlant->"Italic"],
 "= 0 (but generally not both at the same time)"
}], "Outline3",ExpressionUUID->"fc1c88cd-e1df-41d9-8360-c10d136f3ee6"],

Cell["9.10. Conclusion of this chapter", "Outline3",ExpressionUUID->"502ef7d0-b7a4-4e9b-b89d-6ef02dbd8feb"],

Cell["Appendix. An exercise on growth (for the record only)", "Outline3",ExpressionUUID->"d0a929ef-bf46-4ba2-83bc-2846a3b41912"],

Cell["10. Infections versus symptoms", "Outline2",ExpressionUUID->"9e2e2ff6-2626-47e0-beea-4aed9913e7b7"],

Cell["10.1. Introduction", "Outline3",ExpressionUUID->"88406293-2922-4326-afe0-12a42ab72129"],

Cell["10.2. Comparing IFF and sCFF", "Outline3",ExpressionUUID->"c4dc7b41-72a3-4309-b57e-c3c2e75fc63a"],

Cell["10.3. Infection versus symptomatic disease", "Outline3",ExpressionUUID->"ffe8d2ca-dd0c-4f5d-a3a1-523e69c81d33"],

Cell["10.3.1. Arrival periods for a single unit", "Outline4",ExpressionUUID->"280dc4d7-eaad-405b-b968-00e3890a6797"],

Cell["10.3.2. Interarrival periods between two units", "Outline4",ExpressionUUID->"3c97fd94-93cc-4808-8732-eed365ec72a9"],

Cell["10.3.3. Complication for the population averages", "Outline4",ExpressionUUID->"a9e43eb5-e1bf-4c9c-966b-8aa7202a75ae"],

Cell["10.4. Additive equations in the package", "Outline3",ExpressionUUID->"ce9f51b0-ffe8-4162-8409-738bf35a2aa4"],

Cell["10.5. Formulas for generation interval ", "Outline3",ExpressionUUID->"c605fb48-ead5-40ba-8656-950044d36330"],

Cell["10.5.1. Theory", "Outline4",ExpressionUUID->"d9fe2e24-dcdc-4536-a545-21dbddf202f3"],

Cell["10.5.2. Mean interarrival period (MIAP) for infections", "Outline4",ExpressionUUID->"6f51a595-4d3e-4a43-8479-8a9d46a750ff"],

Cell["\<\
10.5.3. Infections: Primary and secondary generation interval\
\>", "Outline4",ExpressionUUID->"04a907c2-073b-4476-97a7-e97de82e1469"],

Cell["10.6. Ganyani et al. (2020) on the generation interval", "Outline3",ExpressionUUID->"32dff355-5048-494b-889e-19b7ad0c64c2"],

Cell["\<\
10.7. Kucharski et al. (2020) and Goh (2020) epidemic calculator on symptoms\
\>", "Outline3",ExpressionUUID->"5efa11c7-ffd1-46ad-a17b-a300f42671c2"],

Cell["10.8. Other literature", "Outline3",ExpressionUUID->"8ed5ca4f-3545-4180-807a-99d83b87f658"],

Cell["10.8.1. Anderson et al. (2020)", "Outline4",ExpressionUUID->"babe9fe0-8f2a-47f2-b2dd-b7c669881f00"],

Cell["10.8.2. Flaxman et al. (2020)", "Outline4",ExpressionUUID->"80b30ff1-ba4d-4ede-8572-b0ca4f620afe"],

Cell["10.8.3. Other cases mentioned by Svensson (2005, 2007)", "Outline4",ExpressionUUID->"6785c804-5b5d-4178-8eb6-e97d04bd39d0"],

Cell["10.8.4. Tao Liu et al. (2020) ", "Outline4",ExpressionUUID->"7e1d4338-5b26-41e0-a298-50ede529a3df"],

Cell["10.8.5. Feretti et al. (2020)", "Outline4",ExpressionUUID->"72dce0b5-7eeb-4bf2-b9f7-183c78e3c2f1"],

Cell["10.8.6. Summing up", "Outline4",ExpressionUUID->"c4a2d626-c038-4028-90e0-5e010ad06f65"],

Cell["11. Comparison with SEYCD studies by others", "Outline2",ExpressionUUID->"632a35eb-4d27-4871-a586-98952b36f473"],

Cell["11.1. Yan and Chowell (2019) on SEIA", "Outline3",ExpressionUUID->"573d332f-7bf4-4333-a62f-b1b0e6646c6e"],

Cell["11.1.1. Names", "Outline4",ExpressionUUID->"a243a14f-9f48-498c-8f8e-39e0e5f69193"],

Cell["11.1.2. Set options, time horizon, run and plot ", "Outline4",ExpressionUUID->"8e14e5d8-1412-449e-b917-d6ddba67efef"],

Cell["11.1.3. Limit values", "Outline4",ExpressionUUID->"8496f886-dd19-461f-903f-9e887e0718d1"],

Cell["11.1.4. The top of Iq ", "Outline4",ExpressionUUID->"0650ec39-b92e-4c6a-ac80-c1e4950b9ecd"],

Cell["11.1.5. Reset options", "Outline4",ExpressionUUID->"1de5a2df-e434-4f4c-a011-9a7bae9f9804"],

Cell["11.2. Lin et al. (2010) on SICD", "Outline3",ExpressionUUID->"1ac3d319-5c29-4d3f-bd63-7108a690b9e0"],

Cell["11.2.1. Names", "Outline4",ExpressionUUID->"a539f76b-39c5-4070-9379-3e10dbc546a7"],

Cell["\<\
11.2.2. Their model (a): Set options, time horizon, run and plot \
\>", "Outline4",ExpressionUUID->"d82a4e58-9761-4189-b479-46b7dc37c30c"],

Cell["\<\
11.2.3. Their model (c): Set options, time horizon, run and plot \
\>", "Outline4",ExpressionUUID->"432f6e8d-26fe-4ff3-af83-59e9b38081bd"],

Cell["11.2.4. Reset options", "Outline4",ExpressionUUID->"187962a4-a40a-413a-aadd-d3aa6fa44f46"],

Cell["\<\
11.3. Maugeri et al. (2020) using SEYCD on SARS-CoV-2 in China\
\>", "Outline3",ExpressionUUID->"1d9f3a8a-d7e6-4cb1-b341-a03edd6b19f0"],

Cell["\<\
11.3.1. Their example: Set options, time horizon, run and plot \
\>", "Outline4",ExpressionUUID->"50f0b109-2c2c-41c0-9223-7517c6eb8ba2"],

Cell["\<\
11.3.2. Their finding on China: Set options, time horizon, run and plot \
\>", "Outline4",ExpressionUUID->"2854f424-7c32-4319-8c6a-e77526d3c374"],

Cell["11.3.3. Reset options", "Outline4",ExpressionUUID->"224b8723-c947-4a17-86e7-d55c89012f99"],

Cell["\<\
11.4. Kucharski et al. (2020), with use in the \
\[OpenCurlyDoubleQuote]epidemic calculator\[CloseCurlyDoubleQuote] by Goh \
(2020) \
\>", "Outline3",ExpressionUUID->"9f8cdf01-4a14-4f1a-bc2a-5e58e586518c"],

Cell["11.4.1. Goh\[CloseCurlyQuote]s parameters on SEIRD or SI(EY)A(CD) \
itself", "Outline4",ExpressionUUID->"6c4b9fab-d3a0-452a-bf55-dc0b292223ed"],

Cell["11.4.2. Names", "Outline4",ExpressionUUID->"0d85e73e-7ffa-4bc9-afc6-075a5a440696"],

Cell["11.4.3. Set options, time horizon, run and plot ", "Outline4",ExpressionUUID->"84ae2d82-661c-473f-be9f-2edf7c1cebaf"],

Cell["11.4.4. Numerical outcomes from reading the graph ", "Outline4",ExpressionUUID->"44ba524e-4dcb-4af5-9791-74f961b8e60a"],

Cell["11.4.5. Goh\[CloseCurlyQuote]s parameters on hospitalisation", \
"Outline4",ExpressionUUID->"ba5202e7-adf4-4e8b-8d5c-8b9f51d4f55f"],

Cell["11.4.6. Reset options", "Outline4",ExpressionUUID->"e6204c51-fc0a-4613-a83f-927cdb4130d4"],

Cell["12. Intervention", "Outline2",ExpressionUUID->"6daeacfe-53e0-4a24-8de3-bbfd6adb9505"],

Cell["Clear", "Outline3",ExpressionUUID->"8824caee-0700-4bac-ba40-666a35778d15"],

Cell["12.1. Introduction", "Outline3",ExpressionUUID->"cea9eead-7693-45dc-8045-19b461a434e8"],

Cell["12.1.1. Keeping \[Gamma] = 1/10 fixed", "Outline4",ExpressionUUID->"4f697b53-758b-42c1-bdec-79dc28814c6b"],

Cell["12.2. Two methods", "Outline4",ExpressionUUID->"4830d71c-1caf-4268-b673-1a51b51689d0"],

Cell["12.3. Interpretation of the estimation result", "Outline4",ExpressionUUID->"a6e46d74-0795-4bd9-8b35-cfae9a99b33c"],

Cell["12.2. Principles for parameters", "Outline3",ExpressionUUID->"84ad8934-6770-4711-8bc5-60c526734ae6"],

Cell["12.3. Principles for routines", "Outline3",ExpressionUUID->"887a6e45-e771-45e1-9a0a-04731fe1df8f"],

Cell["12.3.1. Method 1. Using two full SEYCD models", "Outline4",ExpressionUUID->"cca6808c-adde-46f4-8f1b-39778835a1c8"],

Cell["\<\
12.3.2. Method 2. A fast track with SEYCDT and SEYCDB inserts\
\>", "Outline4",ExpressionUUID->"3c43b6d9-27f3-4ae3-a86b-f912c923803a"],

Cell["12.3.3. Comparison of the methods", "Outline4",ExpressionUUID->"b5ca4cd2-e9e9-4f38-ba50-58a7b8405727"],

Cell["13. Intervention using two full SEYCD models", "Outline2",ExpressionUUID->"9b0268c4-6c40-491b-8307-c8363b074d8f"],

Cell["Clear", "Outline3",ExpressionUUID->"d615c625-28c2-46ab-8510-23d219258fa6"],

Cell["13.1. Base case without intervention", "Outline3",ExpressionUUID->"217e2ebf-4756-4552-8ca7-1a5729f92ed7"],

Cell["13.2. Alternative case, with the intervention (SEYCD)", "Outline3",ExpressionUUID->"d533d2fd-42de-4742-809b-7637705c2607"],

Cell["13.2.1. Choosing the intervention parameters", "Outline4",ExpressionUUID->"ffaa5dad-0f12-411f-ba4c-f4bc85d3bcf1"],

Cell["13.2.2. The model values at t = 24", "Outline4",ExpressionUUID->"e236cbc7-0d27-49bd-a262-7c49e3f4c1a0"],

Cell["13.2.3. Running the Alternative model", "Outline4",ExpressionUUID->"a28a894e-ad55-43d7-8a9d-ccd7e9ca1b47"],

Cell["13.2.4. Use of default routines on top and limit", "Outline4",ExpressionUUID->"37eb16a0-56d0-43c8-b92e-777ba317111b"],

Cell["\<\
13.2.5. Conclusion on the comparison of the Base versus Alternative model\
\>", "Outline4",ExpressionUUID->"9e39c074-83d7-438b-bb1f-5348b9c1d5f2"],

Cell["14. Data", "Outline2",ExpressionUUID->"46bca07b-2684-4e59-9231-1211eb2607ce"],

Cell["14.1. Recorded death data", "Outline3",ExpressionUUID->"2eb88654-054d-4aa5-9882-99c0fe78f866"],

Cell["14.2. Back-tracing in linear manner", "Outline3",ExpressionUUID->"c697b1fb-1db6-4eef-99c4-4206cf39a489"],

Cell["14.3. The data, and elimination of the presumed onset", "Outline3",ExpressionUUID->"a36d1c3c-86b3-4092-abf2-536a53cb4133"],

Cell["14.4. Comparison with the data", "Outline3",ExpressionUUID->"36e0d510-f54d-4898-81d9-bfa30a5941ab"],

Cell["15. Intervention and estimation, using SEYCDT", "Outline2",ExpressionUUID->"90178a81-8477-4fce-8909-2444f168190e"],

Cell["15.1. Introduction", "Outline3",ExpressionUUID->"28ad9f82-d36c-4b49-9230-170537a2ab71"],

Cell["15.2. Find the intervention parameters for SEYCDT", "Outline3",ExpressionUUID->"4a7329c5-5a26-463a-a1d9-0eb6d31d80f5"],

Cell["15.3. Intervention at t = 24, using SEYCDT", "Outline3",ExpressionUUID->"f64412ec-ed39-42a2-9502-03512043430c"],

Cell["15.4. Estimation: aim and result", "Outline3",ExpressionUUID->"444c56e7-6106-4e82-addc-d28fdc0d48b5"],

Cell["15.5. Major routine: the definition of the error", "Outline3",ExpressionUUID->"78285a3b-24ef-4c3d-9c28-8cba0cbc0751"],

Cell["15.6. Minimising the RMSE", "Outline3",ExpressionUUID->"40629105-91d6-4161-8dd5-1f9a1f1317d3"],

Cell[TextData[{
 "15.7. Combined estimate of new onset, pre-intervention ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "9e063f7a-79f3-49bf-9290-c46146f453e2"],
 ", intervention ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "6224d44d-5853-4dd5-a9c6-06d563698157"],
 ", and back-tracing"
}], "Outline3",ExpressionUUID->"1643f6f2-4808-4778-a23a-8314591b1394"],

Cell["15.7.1. Calculating RMSE given numerical parameter values", "Outline4",ExpressionUUID->"67b381bc-53b2-4f4b-92d7-03766204975d"],

Cell["15.7.2. FindMinimum on the RMSE", "Outline4",ExpressionUUID->"7a417bd9-f28f-434b-bc14-46388d1a1909"],

Cell["15.7.3. Indication of lack of sensitivity to small changes", "Outline4",ExpressionUUID->"4b8a342b-31fb-4b3f-bce9-80e3da19c72c"],

Cell["15.7.4. FindMinimum with a condition", "Outline4",ExpressionUUID->"cbd964d4-23f2-474b-a2cd-0a7f15e53863"],

Cell["15.8. Variant of startvalues from 1 to 6", "Outline3",ExpressionUUID->"703c550f-fbd5-48bc-b970-dd38f031907e"],

Cell["15.9. NMinimize, but the problem is not so well-behaved", "Outline3",ExpressionUUID->"7484107c-a748-4fec-b398-e587e4add86b"],

Cell["15.10. The lowest value found", "Outline3",ExpressionUUID->"c7bd3438-b3c4-4d18-bf5c-6e99059149c9"],

Cell["15.11. Contours", "Outline3",ExpressionUUID->"583ec9bf-d015-4bf0-a309-a3a020b1d0b3"],

Cell["16. Intervention and estimation using SEYCDB", "Outline2",ExpressionUUID->"eaccd3c7-48b8-4b91-a112-655992d4206e"],

Cell["16.1. Introduction", "Outline3",ExpressionUUID->"86e6afb6-dc44-4172-b549-2abcebdaaec8"],

Cell["16.2. Find the intervention parameters for SEYCDB", "Outline3",ExpressionUUID->"1dd5b5d0-f079-47f7-9937-bcc48456edc7"],

Cell["16.3. Intervention at t = 24, using SEYCDB", "Outline3",ExpressionUUID->"da7b9ec2-58ba-4a1f-a7cf-514232e210c2"],

Cell["16.4. Estimation: aim and result", "Outline3",ExpressionUUID->"3969829a-bfae-4a43-a7ef-fc8cb0c41601"],

Cell["16.5. Major routine: the definition of the error", "Outline3",ExpressionUUID->"02c5c540-6731-4d0f-a8f2-90a328791d69"],

Cell["16.6. Minimising the RMSE", "Outline3",ExpressionUUID->"d954f520-3809-4626-8ce7-9bc4491d122f"],

Cell["\<\
16.7. Combined estimate of new onset, pre-intervention beta, intervention \
beta, and back-tracing\
\>", "Outline3",ExpressionUUID->"a0ff6a16-8bf3-4c55-adfd-3d5701e3fe3d"],

Cell["16.7.1. Calculating RMSE given numerical parameter values", "Outline4",ExpressionUUID->"a3fc7a7f-c0d7-42cb-8722-006079ac3ecc"],

Cell["16.7.2. FindMinimum on the RMSE", "Outline4",ExpressionUUID->"c0b958e2-c33c-4376-bf55-a5a167f4918a"],

Cell["16.7.3. Indication of lack of sensitivity to small changes", "Outline4",ExpressionUUID->"bc1986c7-220f-4146-9d5e-f643962652ee"],

Cell["16.7.4. FindMinimum with a condition", "Outline4",ExpressionUUID->"97176cab-b470-4a48-b43c-7c3fe5861d6a"],

Cell["16.8. Variant of startvalues from 0.1 to 0.6", "Outline3",ExpressionUUID->"c20138d1-f239-4dad-8438-76738ecc4cb4"],

Cell["16.9. NMinimize, but the problem is not so well-behaved", "Outline3",ExpressionUUID->"41b7f0b6-ec3e-4ca0-9ab5-519bc19fa43f"],

Cell["16.10. The lowest value found", "Outline3",ExpressionUUID->"51aea977-736a-4e39-9a89-35e5d124a688"],

Cell["16.11. Contours", "Outline3",ExpressionUUID->"bd0efd34-ebc6-4be2-99de-0c13b10aef39"],

Cell["\<\
16.12. Earlier finding on the need to perhaps move the date of onset\
\>", "Outline3",ExpressionUUID->"b28fb939-3204-4a87-ba33-86b9b39d1778"],

Cell["16.13. Post mortem on \[Gamma]: intervention at t = 24 - variant", \
"Outline3",ExpressionUUID->"3eb61bf9-2128-4736-91a2-7c6d5799d1d8"],

Cell["16.13.1. Why changing \[Gamma] is tricky", "Outline4",ExpressionUUID->"fe5eefa8-ff22-4f37-a1e5-dee297f25949"],

Cell["16.13.2. Choosing base values with \[Beta] = 0.6 and \[Gamma] = 0.1", \
"Outline4",ExpressionUUID->"003b5927-feae-40da-b2f1-8853fa47335b"],

Cell["16.13.3. Intervention", "Outline4",ExpressionUUID->"88ded6e2-2962-4035-9291-306bd237deb7"],

Cell["16.13.4. One of the earlier estimation efforts", "Outline4",ExpressionUUID->"46e41fca-a6a3-406a-b540-710f8997cdbd"],

Cell["Appendix A. Recall exponential decay, reliability, survival", "Outline2",ExpressionUUID->"752f7239-3741-4491-9be4-ebd689dd51f6"],

Cell["A.1 Introduction", "Outline3",ExpressionUUID->"e7b90981-bcb9-4c76-871e-f0f5257a148b"],

Cell["A.2 Half-life and doubling period", "Outline3",ExpressionUUID->"69c8513f-49ea-466f-9568-6eeee9a6afaf"],

Cell["\<\
A.3 Two compartments, one with exponential decay. Duration vs calendar time \
(stocks and flows)\
\>", "Outline3",ExpressionUUID->"26b3b6fe-f054-48ee-bc74-36acd966055c"],

Cell["A.4. Factors and rates", "Outline3",ExpressionUUID->"4c12bcca-9a95-4b19-b2f6-5cf0a4767a53"],

Cell["A.5. One point of observation suffices", "Outline3",ExpressionUUID->"78b9d2b0-2414-418f-9845-18031b0b05a3"],

Cell["\<\
A.6. Dynamic growth versus probability. CDF, PDF, and properties\
\>", "Outline3",ExpressionUUID->"7b2b9d36-d84c-4f73-8959-3a4c195869eb"],

Cell["A.7. Subject areas: duration or calendar time", "Outline3",ExpressionUUID->"6a9175e3-23d3-4f66-9bcc-cd8136f8c8ad"],

Cell["\<\
(1.a) Periods of a homogenous population, only information about periods\
\>", "Outline4",ExpressionUUID->"e06f8dce-257d-4c8e-8e84-d85410c50790"],

Cell["\<\
(1.b) Periods of a heterogenous population, also with information on events\
\>", "Outline4",ExpressionUUID->"ac68a844-becf-470e-80f3-a4dc6d049e62"],

Cell["(2) Calendar time", "Outline4",ExpressionUUID->"bf94c204-bf20-454e-b109-d269d465b23a"],

Cell["A.8. Comparison with SICD and SEYCD", "Outline3",ExpressionUUID->"1db802c8-b8b1-4336-9d66-47f14db2f534"],

Cell["Appendix B. Recall Poisson, Erlang and exponential", "Outline2",ExpressionUUID->"6b37333c-9e20-4594-b9f5-d2fc2a404c71"],

Cell["B.1. Toolkit", "Outline3",ExpressionUUID->"cf4c1fc6-cd96-453d-a16d-347606552440"],

Cell["B.2. Basics", "Outline3",ExpressionUUID->"9476c2b2-7b4b-4e5b-a409-b23a33bfbb1e"],

Cell["B.3. Parameterisation such that \[Mu] = expected value", "Outline3",ExpressionUUID->"e29594d8-9296-4be4-b8aa-aac5035ab711"],

Cell["B.4. The exponential distribution", "Outline3",ExpressionUUID->"0eaec3dc-6ead-4e33-88f1-052515c183d4"],

Cell["B.5. A random simulation with a Poisson process", "Outline3",ExpressionUUID->"916e279c-511d-4cee-a665-ddae9189ce60"],

Cell["A short run", "Outline4",ExpressionUUID->"665097cd-2b94-42ff-b5a4-8ebc3e0ef8f0"],

Cell["A long run", "Outline4",ExpressionUUID->"6b59a2fe-19d9-435c-b718-bde400b03703"],

Cell["\<\
B.6. Poisson process (exponential IAP) versus exponential process\
\>", "Outline3",ExpressionUUID->"9006a908-c2fa-44aa-bac3-4ee265f5f9ee"],

Cell["Comparison with the former longer run simulation", "Outline4",ExpressionUUID->"df992999-3f5d-456f-bf06-fb7d94fe6344"],

Cell["Normalising to another period", "Outline4",ExpressionUUID->"ba51f8b1-636c-4ea6-8cc5-89a10fe2127b"],

Cell["B.7. Package on queueing", "Outline3",ExpressionUUID->"fe7c5b3b-c8ef-44d6-8cb4-ffa49b4a91d9"],

Cell["Appendix C. Recall Survival analysis", "Outline2",ExpressionUUID->"48402ec4-8fe0-44a6-823d-549b8787e7ac"],

Cell["C.1. Load packages", "Outline3",ExpressionUUID->"03f48a22-7bb5-4713-8c48-c75223a46b94"],

Cell["C.2. Some spare examples", "Outline3",ExpressionUUID->"12301b46-2c07-4a5e-98d0-a4a790061a9f"],

Cell["Example 1", "Outline4",ExpressionUUID->"a2f64010-098c-44dc-baeb-3d93d44f236a"],

Cell["Example 2", "Outline4",ExpressionUUID->"ea45d7c9-ec0b-47d7-ac7e-6c4349245920"],

Cell[TextData[{
 "Appendix D. Example of ",
 StyleBox["not",
  FontSlant->"Italic"],
 " using the package"
}], "Outline2",ExpressionUUID->"df9f3f7f-503f-4392-9231-03270d13390a"],

Cell["D.1. Needless learning curve for experienced users", "Outline3",ExpressionUUID->"61680db6-9140-40e5-ba5f-cc25ea19d10c"],

Cell["D.2. A model", "Outline3",ExpressionUUID->"6929269a-54c9-42eb-a4b1-159f35958264"],

Cell["D.3. A model with an intervention", "Outline3",ExpressionUUID->"a32d863e-ed7a-45ca-b5e1-cc05e84c7982"],

Cell["References", "Outline2",ExpressionUUID->"325aae46-628a-4d62-bb3a-3b2476a78573"],

Cell["R.1. Timeline", "Outline3",ExpressionUUID->"0fa0b6f5-31c4-4fa0-ba0c-c8a6886cbcdf"],

Cell["R.2. On the gap between society and science", "Outline3",ExpressionUUID->"ee971097-370d-436f-91d3-69dbbccf724e"],

Cell["R.3. Own research in public health economics before 2020", "Outline3",ExpressionUUID->"7c625158-f7e0-4a2c-ae58-63196fdeda20"],

Cell["\<\
R.4. Standard discussions about SI(EY)A(CD) or epidemiology in general\
\>", "Outline3",ExpressionUUID->"13380eb3-43de-4c89-aeba-12b13b0ad9d2"],

Cell["R.5. Specifically about SARS-CoV-2 (Covid-19)", "Outline3",ExpressionUUID->"09f46790-5957-4cd0-a8e4-2871e8dec231"],

Cell["R.6. With Mathematica code", "Outline3",ExpressionUUID->"0a9bdf71-a7d8-4949-aaed-aa42a75222d0"],

Cell["R.7. The Dutch case", "Outline3",ExpressionUUID->"6df53cd8-8abf-4947-a64a-ddccc66ca419"],

Cell["R.8. Economics about the pandemic", "Outline3",ExpressionUUID->"7fd8dbc8-1910-4682-9874-f1836098a487"],

Cell["R.9. Other redesign of didactics", "Outline3",ExpressionUUID->"4019dd2b-3084-41b2-8bf9-fb5560db822f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1. Introduction", "Section",
 PageBreakAbove->True,ExpressionUUID->"10049ace-e365-46d4-9005-9ca386974021"],

Cell[CellGroupData[{

Cell["1.1. What this notebook and package do", "Subsection",ExpressionUUID->"38ceed71-aa09-45b4-960a-e7d2884e3b7a"],

Cell[CellGroupData[{

Cell["1.1.1. Didactic redesign", "Subsubsection",ExpressionUUID->"abc84347-1383-444a-a5f2-b765e016b329"],

Cell["\<\
This notebook and package redesign didactics for the S(E)IR(D) \[Rule] \
SI(EY)A(CD) epidemic models. \
\>", "Text",ExpressionUUID->"a1f2a157-1833-4126-8434-1f930fc36c09"],

Cell["\<\
- There is no new finding on content. There is no new analysis. There are no \
new parameter estimates. \
\>", "Text",ExpressionUUID->"a5008aaf-8621-4ea4-8b38-f6ba97a5bd08"],

Cell[TextData[{
 "- There is only an effort at ",
 StyleBox["better didactics ",
  FontSlant->"Italic"],
 "of what already is known in the field. "
}], "Text",ExpressionUUID->"01c3cf3c-311a-4726-9bdf-ac6647c63e63"],

Cell[TextData[{
 "- Readers of this notebook may be researchers from other fields than \
epidemiology or they may be first-year students from a general background. \
Readers will have at least a first-year student understanding of mathematics \
and they will be open to the use of ",
 StyleBox["Mathematica. ",
  FontSlant->"Italic"],
 "Readers will ",
 StyleBox["require ",
  FontSlant->"Italic"],
 "a discussion that uses mathematics. "
}], "Text",ExpressionUUID->"51e9223d-55b3-47ff-a089-fd989f7d9a41"],

Cell["\<\
A readership with such competence should have little problem with the \
standard didactics of the S(E)IR(D) models. Thus, an effort at improving \
these didactics can only have a very marginal effect. However, advancement \
comes in little steps. The pandemic will cause an interest by researchers \
from other areas and new students. They can be served by clearer exposition, \
with the benefit of computer algebra and a computable environment. One hope \
is that this notebook also reaches conventional teachers: they may not adopt \
all suggestions but can find some alerts. \
\>", "Text",ExpressionUUID->"740c3d45-e697-4d33-ab7a-20d2b4b814e4"],

Cell["\<\
PM. A new element may be the distinction in quarantine classes with a \
colouring scheme in Chapter 4 that could contribute to better communication.\
\>", "Text",ExpressionUUID->"d367855f-794a-40ad-8f64-9956b47dc8fe"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.1.2. There already is an abundance", "Subsubsection",ExpressionUUID->"3a5cf341-dfcd-4d54-855a-265608334054"],

Cell["In addition:", "Text",ExpressionUUID->"d78ec948-e1a5-4b52-8714-8a2c8985f762"],

Cell[TextData[{
 "- There is an abundance of SI(EY)A(CD) modeling. Important is the Berger, \
Herkenhoff and Mongey (2020) (March 29) paper, that adapts the SEIRD \[Rule] \
SEYCD model to test-dependent states of quarantine. Their code in Python is \
available. These authors are not epidemiologists but they present their paper \
as a proof of concept for the exit scenario of ",
 StyleBox["test, test, and test.",
  FontSlant->"Italic"],
 " See Tabarrok (2020) for an independent appreciation that this exit \
scenario is cost-effective. Acemoglu et al. (2020) (May) employ a SIRD \
\[Rule] SICD model with at least three age compartments, and plot GDP & Death \
policy frontiers. See another application in Python at Idmod.org, called \
\[OpenCurlyDoubleQuote]Emod\[CloseCurlyDoubleQuote]. "
}], "Text",ExpressionUUID->"6e68c4c4-d3bc-4aa6-96a8-08d6db413ca7"],

Cell[TextData[{
 "- Such abundance also exists for ",
 StyleBox["Mathematica, ",
  FontSlant->"Italic"],
 "see the list of references. For SARS-CoV-2 (Covid-19), the Kaurov (2020) \
collection of ",
 StyleBox["computational publications ",
  FontSlant->"Italic"],
 "must be mentioned. ",
 StyleBox["Appendix D",
  FontWeight->"Bold"],
 " shows that one does not need this present notebook and package of mine. \
Who knows the S(E)IR(D) models and ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "will find it simple and straightforward to create such model in ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "and run a WhenEvent policy intervention. This present notebook and package \
only provide structure in use, though at the cost of a learning curve. We \
only assume now that (such) experienced readers are willing to look at the \
issue from the angle of didactics. "
}], "Text",ExpressionUUID->"264fed10-3ca5-40c2-bafd-8cd362c34974"],

Cell["\<\
- There are other approaches to epidemic modeling than the SI(EY)A(CD) \
models. A fine discussion has been given by 3Blue1Brown (2020). See the \
interview by Spinney (2020) with Karl Friston on models derived from physics. \
This kind of modeling is supported by Gill (2020).\
\>", "Text",ExpressionUUID->"eee1e5ac-a32b-4cbb-b1ac-d942425505e8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "1.1.3. Overview of this ",
 StyleBox["Introduction",
  FontSlant->"Italic"]
}], "Subsubsection",ExpressionUUID->"fb2eb3a1-28ea-4ce6-8a92-045e3765b6d9"],

Cell[TextData[{
 "This ",
 StyleBox["Introduction ",
  FontSlant->"Italic"],
 "proceeds with (i) the overview of didactic redesign, (ii) the context of \
the SARS-CoV-2 pandemic and exit strategies, (iii) the overview of the \
notebook itself."
}], "Text",ExpressionUUID->"953ad2d4-fe75-46db-8987-972632c1fabb"],

Cell["\<\
PM. Overall, this notebook has a lot of repetition. Not only the models are \
much alike, but also the analytical properties and the explanations of the \
routines, and the discussion of the aspects of the SARS-CoV-2 pandemic (e.g. \
in Holland and elsewhere). The assumption has been that readers might skip \
sections (e.g. jump to their model of interest), so that such repetition is \
beneficial.\
\>", "Text",ExpressionUUID->"a72627a6-6a27-4140-81ef-35564b9b5506"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.2. The renaming S(E)IR(D) \[Rule] SI(EY)A(CD)", "Subsection",ExpressionUUID->"fdee66d3-e36e-43f2-83c6-94eb5d338edd"],

Cell["\<\
The S(E)IR(D) abbreviation stands for the family of epidemic models that have \
these compartments or phases (switched on or off): \
\>", "Text",ExpressionUUID->"39a82d9e-92c3-41bd-aa7f-c8d80b66e30e"],

Cell["Susceptible - Exposed - Infectious - Cleared or Deceased", "Text",
 TextAlignment->Center,ExpressionUUID->"a52df839-7344-47f5-882b-5723beebe3b9"],

Cell[TextData[{
 "The conventional S(E)IR(D) setup uses the label ",
 StyleBox["\[OpenCurlyDoubleQuote]R\[CloseCurlyDoubleQuote] ",
  FontSlant->"Italic"],
 "in three different meanings: ",
 StyleBox["Removed ",
  FontSlant->"Italic"],
 "in the SIR model, ",
 StyleBox["Recovered ",
  FontSlant->"Italic"],
 "in SIRD and SEIRD, and overall for the (basic) ",
 StyleBox["reproductive factor",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "ec294db4-45c8-49a8-8f1a-c9a95cd2f0e0"],
 ". Also, all models use the ",
 StyleBox["\[OpenCurlyDoubleQuote]I\[CloseCurlyDoubleQuote] ",
  FontSlant->"Italic"],
 "for the infectious compartment, but some also for \
\[OpenCurlyDoubleQuote]Infected\[CloseCurlyDoubleQuote]. SEIR(D) includes the \
",
 StyleBox["exposed, ",
  FontSlant->"Italic"],
 "as the infected but not infectious yet. Since all models claim to add up to \
the total population, and the exposed did not occur in SIR or SIRD, this \
implies that SEIR(D) would describe a different population."
}], "Text",ExpressionUUID->"e0b6a4ab-34d5-4e62-bd12-a38dbe46e816"],

Cell[TextData[{
 "This family of models has been presented in this manner for half a century. \
Within the computer algebra environment of ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "it appeared that there is a clear advantage of a better nomenclature. \
Unique names help the identification of variables, their parameters and the \
application of associated routines. When we discuss the same population then \
our analysis should not be cluttered with issues on the administration of the \
compartments. While humans are flexible, computers are a bit less so, and \
when humans work with computers then humans become rather inflexible too."
}], "Text",ExpressionUUID->"93edd04a-8f49-4c73-a85c-2d21d8ccddc7"],

Cell["This notebook and package use:", "Text",ExpressionUUID->"bc4c9eab-981c-4983-b6d9-d4320546adb4"],

Cell[TextData[{
 "- The Acquitted ",
 StyleBox["A ",
  FontSlant->"Italic"],
 "instead of the ",
 StyleBox["Removed. \n",
  FontSlant->"Italic"],
 "- The Cleared ",
 StyleBox["C ",
  FontSlant->"Italic"],
 "instead of the ",
 StyleBox["Recovered.\n",
  FontSlant->"Italic"],
 "- So that the ",
 StyleBox["A ",
  FontSlant->"Italic"],
 "compartment can be split in ",
 StyleBox["A ",
  FontSlant->"Italic"],
 "= ",
 StyleBox["C ",
  FontSlant->"Italic"],
 "+ ",
 StyleBox["D ",
  FontSlant->"Italic"],
 "or the Cleared or Deceased.",
 StyleBox["\n",
  FontSlant->"Italic"],
 "- The Infected ",
 StyleBox["I ",
  FontSlant->"Italic"],
 "can be ",
 StyleBox["infectious",
  FontSlant->"Italic"],
 " or ",
 StyleBox["exposed but not infectious yet",
  FontSlant->"Italic"],
 ".\n- The Infectious ",
 StyleBox["Y.\n",
  FontSlant->"Italic"],
 "- So that the ",
 StyleBox["I ",
  FontSlant->"Italic"],
 "compartment can be split in ",
 StyleBox["I ",
  FontSlant->"Italic"],
 "= ",
 StyleBox["E ",
  FontSlant->"Italic"],
 "+ ",
 StyleBox["Y ",
  FontSlant->"Italic"],
 "or the Exposed and Infectious.",
 StyleBox["\n",
  FontSlant->"Italic"],
 "- So that the SIA and SICD models have ",
 StyleBox["E ",
  FontSlant->"Italic"],
 "= 0 and ",
 StyleBox["I ",
  FontSlant->"Italic"],
 "= ",
 StyleBox["Y",
  FontSlant->"Italic"],
 ", or that their ",
 StyleBox["infected I ",
  FontSlant->"Italic"],
 "are also the ",
 StyleBox["infectious Y.",
  FontSlant->"Italic"]
}], "Text",ExpressionUUID->"fae9aece-1672-4b33-9f40-c0c810a5b4bc"],

Cell[TextData[{
 "Thus we get the abbreviation SI(EY)A(CD). For all variables ",
 StyleBox["V ",
  FontSlant->"Italic"],
 "we distinguish ",
 StyleBox["Vq",
  FontSlant->"Italic"],
 " for the levels and ",
 StyleBox["Vp",
  FontSlant->"Italic"],
 " for the proportions w.r.t. the population ",
 StyleBox["N",
  FontSlant->"Italic"],
 "[0]. For plotting we can also plot the current population ",
 StyleBox["N ",
  FontSlant->"Italic"],
 "= ",
 StyleBox["N",
  FontSlant->"Italic"],
 "[0] - ",
 StyleBox["D.",
  FontSlant->"Italic"]
}], "Text",ExpressionUUID->"02185fd5-36e8-4aa5-8d2a-1bcf3581650e"],

Cell[TextData[{
 "The decision to choose these names in this manner was taken with quite some \
hesitation and consideration but would seem to be optimal. A practical \
argument for this compartmentalisation and nomenclature is that the limit \
properties of SI(EY)A(CD) are determined by ",
 StyleBox["I ",
  FontSlant->"Italic"],
 "(i.e. the sum ",
 StyleBox["I ",
  FontSlant->"Italic"],
 "= ",
 StyleBox["E ",
  FontSlant->"Italic"],
 "+ ",
 StyleBox["Y",
  FontSlant->"Italic"],
 ")",
 StyleBox[" ",
  FontSlant->"Italic"],
 "just like in the SIA model, without the need for relabeling in SEYA(CD). \
The introduction of the exposed compartment has only effect for the short run \
behaviour. For the (crucial) limit property there really is a compartment ",
 StyleBox["I ",
  FontSlant->"Italic"],
 "= ",
 StyleBox["E ",
  FontSlant->"Italic"],
 "+ ",
 StyleBox["Y",
  FontSlant->"Italic"],
 ", apart from the temporary distinction in the phases of ",
 StyleBox["E ",
  FontSlant->"Italic"],
 "and ",
 StyleBox["Y. ",
  FontSlant->"Italic"],
 "The package allows the user to adopt the conventional nomenclature, \
including the possibility of using ",
 StyleBox["Y",
  FontSlant->"Italic"],
 " = ",
 StyleBox["E ",
  FontSlant->"Italic"],
 "+ ",
 StyleBox["I ",
  FontSlant->"Italic"],
 "instead. The underlying programming structure however is as above, and \
there is no reason to hide it and not take advantage of it."
}], "Text",ExpressionUUID->"8a8409c4-ac0e-4644-82aa-61e2fc07c381"],

Cell[TextData[{
 "With a standard SEYCD model, an unhindered pandemic in Holland would have \
given ",
 StyleBox["roughly ",
  FontSlant->"Italic"],
 "the following path, i.e. neglecting a change in parameters due to the \
intervention in March. These figures have only a didactic meaning, see below \
for a comparison to RIVM figures (the Dutch CDC).  The first death was \
reported on March 6 but according to the model there were actually already 6 \
that day. The eventual total death toll could have been around 250,000, with \
95% reached by May 22, and the remaining 5% spreading over the remainder of \
the year. Only 2% of the population would not have been infected at one \
stage. "
}], "Text",ExpressionUUID->"d4ba5cb7-1320-4b8b-a649-e9169203a9a2"],

Cell["\<\
Table legend: S = Susceptibles (uninfected), I = Infected (exposed or \
infectious), D = Deceased, C = Cleared, N = N[0] - D remaining population, A \
= C + D (the acquitted). Percentages (p) are w.r.t. the onset, i.e. N[0]. \
(Table taken from below.)\
\>", "Text",ExpressionUUID->"ee35c9da-6d07-498d-9ed7-7eccc9935074"],

Cell[BoxData[
 FormBox[
  TagBox[
   TagBox[GridBox[{
      {
       StyleBox["\[Null]",
        ShowStringCharacters->False], 
       TagBox[
        TemplateBox[{
          StyleBox["\"p\"", 
           GrayLevel[1], StripOnInput -> False], "\"Date\""},
         "RowDefault"],
        HoldForm], 
       TagBox["\<\"Day\"\>",
        HoldForm], 
       TagBox["\<\"Sp\"\>",
        HoldForm], 
       TagBox["\<\"Ip\"\>",
        HoldForm], 
       TagBox["\<\"Dp\"\>",
        HoldForm], 
       TagBox["\<\"Cp\"\>",
        HoldForm], 
       TagBox["\<\"Np\"\>",
        HoldForm], 
       TagBox["\<\"Ap\"\>",
        HoldForm]},
      {
       TagBox["\<\"Onset\"\>",
        HoldForm], "\<\"2020-02-23\"\>", 
       TagBox[
        InterpretationBox["\<\"     0\"\>",
         0,
         Editable->False],
        PaddedForm[#, 5]& ], 
       TagBox[
        InterpretationBox["\<\" 100.0\"\>",
         99.99942528735633,
         AutoDelete->True],
        PaddedForm[#, {4, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"  0.0\"\>",
         0.0005747126436781609,
         AutoDelete->True],
        PaddedForm[#, {3, 1}]& ], 
       TagBox[
        InterpretationBox["\<\" 0.0\"\>",
         0.,
         AutoDelete->True],
        PaddedForm[#, {2, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"  0.0\"\>",
         0.,
         AutoDelete->True],
        PaddedForm[#, {3, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"  100\"\>",
         100,
         Editable->False],
        PaddedForm[#, 4]& ], 
       TagBox[
        InterpretationBox["\<\"  0.0\"\>",
         0.,
         AutoDelete->True],
        PaddedForm[#, {3, 1}]& ]},
      {
       TagBox["\<\"1st Death\"\>",
        HoldForm], "\<\"2020-03-06\"\>", 
       TagBox[
        InterpretationBox["\<\"    12\"\>",
         12,
         Editable->False],
        PaddedForm[#, 5]& ], 
       TagBox[
        InterpretationBox["\<\" 100.0\"\>",
         99.99030944370776,
         AutoDelete->True],
        PaddedForm[#, {4, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"  0.0\"\>",
         0.007411478401651695,
         AutoDelete->True],
        PaddedForm[#, {3, 1}]& ], 
       TagBox[
        InterpretationBox["\<\" 0.0\"\>",
         0.00003418616835897067,
         AutoDelete->True],
        PaddedForm[#, {2, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"  0.0\"\>",
         0.002244891722239074,
         AutoDelete->True],
        PaddedForm[#, {3, 1}]& ], 
       TagBox[
        InterpretationBox["\<\" 100.0\"\>",
         99.99996581383198,
         AutoDelete->True],
        PaddedForm[#, {4, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"  0.0\"\>",
         0.002279077890598046,
         AutoDelete->True],
        PaddedForm[#, {3, 1}]& ]},
      {
       TagBox["\<\"1st Intervention\"\>",
        HoldForm], "\<\"2020-03-18\"\>", 
       TagBox[
        InterpretationBox["\<\"    24\"\>",
         24,
         Editable->False],
        PaddedForm[#, 5]& ], 
       TagBox[
        InterpretationBox["\<\"  99.9\"\>",
         99.85120583685939,
         AutoDelete->True],
        PaddedForm[#, {4, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"  0.1\"\>",
         0.11171159877960656`,
         AutoDelete->True],
        PaddedForm[#, {3, 1}]& ], 
       TagBox[
        InterpretationBox["\<\" 0.0\"\>",
         0.0005562384654146821,
         AutoDelete->True],
        PaddedForm[#, {2, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"  0.0\"\>",
         0.036526325895564114`,
         AutoDelete->True],
        PaddedForm[#, {3, 1}]& ], 
       TagBox[
        InterpretationBox["\<\" 100.0\"\>",
         99.99944376178208,
         AutoDelete->True],
        PaddedForm[#, {4, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"  0.0\"\>",
         0.037082564360975054`,
         AutoDelete->True],
        PaddedForm[#, {3, 1}]& ]},
      {
       TagBox["\<\"Top if free\"\>",
        HoldForm], "\<\"2020-04-21\"\>", 
       TagBox[
        InterpretationBox["\<\"    58\"\>",
         58,
         Editable->False],
        PaddedForm[#, 5]& ], 
       TagBox[
        InterpretationBox["\<\"  25.0\"\>",
         24.99999999999999,
         AutoDelete->True],
        PaddedForm[#, {4, 1}]& ], 
       TagBox[
        InterpretationBox["\<\" 40.3\"\>",
         40.34278352632779,
         AutoDelete->True],
        PaddedForm[#, {3, 1}]& ], 
       TagBox[
        InterpretationBox["\<\" 0.5\"\>",
         0.5198582471134668,
         AutoDelete->True],
        PaddedForm[#, {2, 1}]& ], 
       TagBox[
        InterpretationBox["\<\" 34.1\"\>",
         34.13735822711767,
         AutoDelete->True],
        PaddedForm[#, {3, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"  99.5\"\>",
         99.4801417569632,
         AutoDelete->True],
        PaddedForm[#, {4, 1}]& ], 
       TagBox[
        InterpretationBox["\<\" 34.7\"\>",
         34.65721647450097,
         AutoDelete->True],
        PaddedForm[#, {3, 1}]& ]},
      {
       TagBox["\<\"Ap = 50%\"\>",
        HoldForm], "\<\"2020-04-25\"\>", 
       TagBox[
        InterpretationBox["\<\"    62\"\>",
         62,
         Editable->False],
        PaddedForm[#, 5]& ], 
       TagBox[
        InterpretationBox["\<\"  13.5\"\>",
         13.533451053630294`,
         AutoDelete->True],
        PaddedForm[#, {4, 1}]& ], 
       TagBox[
        InterpretationBox["\<\" 36.5\"\>",
         36.46654894636973,
         AutoDelete->True],
        PaddedForm[#, {3, 1}]& ], 
       TagBox[
        InterpretationBox["\<\" 0.7\"\>",
         0.7499999999999997,
         AutoDelete->True],
        PaddedForm[#, {2, 1}]& ], 
       TagBox[
        InterpretationBox["\<\" 49.2\"\>",
         49.24999999999998,
         AutoDelete->True],
        PaddedForm[#, {3, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"  99.2\"\>",
         99.24999999999994,
         AutoDelete->True],
        PaddedForm[#, {4, 1}]& ], 
       TagBox[
        InterpretationBox["\<\" 50.0\"\>",
         49.999999999999964`,
         AutoDelete->True],
        PaddedForm[#, {3, 1}]& ]},
      {
       TagBox["\<\"95% Ap[\[Infinity]]\"\>",
        HoldForm], "\<\"2020-05-22\"\>", 
       TagBox[
        InterpretationBox["\<\"    89\"\>",
         89,
         Editable->False],
        PaddedForm[#, 5]& ], 
       TagBox[
        InterpretationBox["\<\"   2.4\"\>",
         2.4121263929822727`,
         AutoDelete->True],
        PaddedForm[#, {4, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"  4.5\"\>",
         4.471476728779514,
         AutoDelete->True],
        PaddedForm[#, {3, 1}]& ], 
       TagBox[
        InterpretationBox["\<\" 1.4\"\>",
         1.39674595317361,
         AutoDelete->True],
        PaddedForm[#, {2, 1}]& ], 
       TagBox[
        InterpretationBox["\<\" 91.7\"\>",
         91.71965092506701,
         AutoDelete->True],
        PaddedForm[#, {3, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"  98.6\"\>",
         98.60325404680601,
         AutoDelete->True],
        PaddedForm[#, {4, 1}]& ], 
       TagBox[
        InterpretationBox["\<\" 93.1\"\>",
         93.11639687823103,
         AutoDelete->True],
        PaddedForm[#, {3, 1}]& ]},
      {
       TagBox["\<\"Limit if free\"\>",
        HoldForm], "\[Infinity]", "\[Infinity]", 
       TagBox[
        InterpretationBox["\<\"   2.0\"\>",
         1.982727751539194,
         AutoDelete->True],
        PaddedForm[#, {4, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"  0.0\"\>",
         0.,
         AutoDelete->True],
        PaddedForm[#, {3, 1}]& ], 
       TagBox[
        InterpretationBox["\<\" 1.5\"\>",
         1.4702590837268992`,
         AutoDelete->True],
        PaddedForm[#, {2, 1}]& ], 
       TagBox[
        InterpretationBox["\<\" 96.5\"\>",
         96.54701316473393,
         AutoDelete->True],
        PaddedForm[#, {3, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"  98.5\"\>",
         98.5297409162731,
         AutoDelete->True],
        PaddedForm[#, {4, 1}]& ], 
       TagBox[
        InterpretationBox["\<\" 98.0\"\>",
         98.01727224846081,
         AutoDelete->True],
        PaddedForm[#, {3, 1}]& ]}
     },
     GridBoxAlignment->{"Columns" -> {{Right}}, "Rows" -> {{Bottom}}},
     GridBoxDividers->{
      "Columns" -> {False, True, {False}, False}, 
       "Rows" -> {False, True, {False}, False}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[2.0999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, 
     TableHeadings -> {{
       "Onset", "1st Death", "1st Intervention", "Top if free", "Ap = 50%", 
        "95% Ap[\[Infinity]]", "Limit if free"}, {
        Row[{
          Style["p", 
           GrayLevel[1]], "Date"}], "Day", "Sp", "Ip", "Dp", "Cp", "Np", 
        "Ap"}}, TableAlignments -> {Right, Bottom}]]], 
  TraditionalForm]], "Output",
 CellLabel->
  "Out[309]//TableForm=",ExpressionUUID->"df1ff522-df61-4531-90de-\
a7047e2b4bf4"],

Cell["\<\
The levels (q) of the relevant compartments are as follows. (Table taken from \
below.)\
\>", "Text",ExpressionUUID->"6f3545a0-4147-486f-8d5d-fb8cfbe2c3eb"],

Cell[BoxData[
 FormBox[
  TagBox[
   TagBox[GridBox[{
      {
       StyleBox["\[Null]",
        ShowStringCharacters->False], 
       TagBox[
        TemplateBox[{
          StyleBox["\"p\"", 
           GrayLevel[1], StripOnInput -> False], "\"Date\""},
         "RowDefault"],
        HoldForm], 
       TagBox["\<\"Day\"\>",
        HoldForm], 
       TagBox["\<\"Sq\"\>",
        HoldForm], 
       TagBox["\<\"Iq\"\>",
        HoldForm], 
       TagBox["\<\"Cq\"\>",
        HoldForm], 
       TagBox["\<\"Dq\"\>",
        HoldForm]},
      {
       TagBox["\<\"Onset\"\>",
        HoldForm], "\<\"2020-02-23\"\>", 
       TagBox[
        InterpretationBox["\<\"     0\"\>",
         0,
         Editable->False],
        PaddedForm[#, 5]& ], 
       TagBox[
        TagBox[
         InterpretationBox[
          RowBox[{"\<\"17.4\"\>", "\[Times]", 
           SuperscriptBox["10", "\<\"6\"\>"]}],
          1.73999*^7,
          AutoDelete->True],
         EngineeringForm[#, 3]& ],
        PaddedForm[#, {9, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"      100\"\>",
         100,
         Editable->False],
        PaddedForm[#, 8]& ], 
       TagBox[
        InterpretationBox["\<\"         0\"\>",
         0,
         Editable->False],
        PaddedForm[#, 9]& ], 
       TagBox[
        InterpretationBox["\<\"       0\"\>",
         0,
         Editable->False],
        PaddedForm[#, 7]& ]},
      {
       TagBox["\<\"1st Death\"\>",
        HoldForm], "\<\"2020-03-06\"\>", 
       TagBox[
        InterpretationBox["\<\"    12\"\>",
         12,
         Editable->False],
        PaddedForm[#, 5]& ], 
       TagBox[
        TagBox[
         InterpretationBox[
          RowBox[{"\<\"17.4\"\>", "\[Times]", 
           SuperscriptBox["10", "\<\"6\"\>"]}],
          1.7398313843205143`*^7,
          AutoDelete->True],
         EngineeringForm[#, 3]& ],
        PaddedForm[#, {9, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"     1290\"\>",
         1290,
         Editable->False],
        PaddedForm[#, {8, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"       391\"\>",
         391,
         Editable->False],
        PaddedForm[#, {9, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"       6\"\>",
         6,
         Editable->False],
        PaddedForm[#, {7, 1}]& ]},
      {
       TagBox["\<\"1st Intervention\"\>",
        HoldForm], "\<\"2020-03-18\"\>", 
       TagBox[
        InterpretationBox["\<\"    24\"\>",
         24,
         Editable->False],
        PaddedForm[#, 5]& ], 
       TagBox[
        TagBox[
         InterpretationBox[
          RowBox[{"\<\"17.4\"\>", "\[Times]", 
           SuperscriptBox["10", "\<\"6\"\>"]}],
          1.7374109815613538`*^7,
          AutoDelete->True],
         EngineeringForm[#, 3]& ],
        PaddedForm[#, {9, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"    19438\"\>",
         19438,
         Editable->False],
        PaddedForm[#, {8, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"      6356\"\>",
         6356,
         Editable->False],
        PaddedForm[#, {9, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"      97\"\>",
         97,
         Editable->False],
        PaddedForm[#, {7, 1}]& ]},
      {
       TagBox["\<\"Top if free\"\>",
        HoldForm], "\<\"2020-04-21\"\>", 
       TagBox[
        InterpretationBox["\<\"    58\"\>",
         58,
         Editable->False],
        PaddedForm[#, 5]& ], 
       TagBox[
        TagBox[
         InterpretationBox[
          RowBox[{"\<\"4.4\"\>", "\[Times]", 
           SuperscriptBox["10", "\<\"6\"\>"]}],
          4.35*^6,
          AutoDelete->True],
         EngineeringForm[#, 3]& ],
        PaddedForm[#, {9, 1}]& ], 
       TagBox[
        TagBox[
         InterpretationBox[
          RowBox[{"\<\"7.\"\>", "\[Times]", 
           SuperscriptBox["10", "\<\"6\"\>"]}],
          7.019644333581039*^6,
          AutoDelete->True],
         EngineeringForm[#, 3]& ],
        PaddedForm[#, {8, 1}]& ], 
       TagBox[
        TagBox[
         InterpretationBox[
          RowBox[{"\<\"5.9\"\>", "\[Times]", 
           SuperscriptBox["10", "\<\"6\"\>"]}],
          5.939900331518477*^6,
          AutoDelete->True],
         EngineeringForm[#, 3]& ],
        PaddedForm[#, {9, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"   90455\"\>",
         90455,
         Editable->False],
        PaddedForm[#, {7, 1}]& ]},
      {
       TagBox["\<\"Ap = 50%\"\>",
        HoldForm], "\<\"2020-04-25\"\>", 
       TagBox[
        InterpretationBox["\<\"    62\"\>",
         62,
         Editable->False],
        PaddedForm[#, 5]& ], 
       TagBox[
        TagBox[
         InterpretationBox[
          RowBox[{"\<\"2.4\"\>", "\[Times]", 
           SuperscriptBox["10", "\<\"6\"\>"]}],
          2.354820483331672*^6,
          AutoDelete->True],
         EngineeringForm[#, 3]& ],
        PaddedForm[#, {9, 1}]& ], 
       TagBox[
        TagBox[
         InterpretationBox[
          RowBox[{"\<\"6.3\"\>", "\[Times]", 
           SuperscriptBox["10", "\<\"6\"\>"]}],
          6.345179516668335*^6,
          AutoDelete->True],
         EngineeringForm[#, 3]& ],
        PaddedForm[#, {8, 1}]& ], 
       TagBox[
        TagBox[
         InterpretationBox[
          RowBox[{"\<\"8.6\"\>", "\[Times]", 
           SuperscriptBox["10", "\<\"6\"\>"]}],
          8.5695*^6,
          AutoDelete->True],
         EngineeringForm[#, 3]& ],
        PaddedForm[#, {9, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"  130500\"\>",
         130500,
         Editable->False],
        PaddedForm[#, {7, 1}]& ]},
      {
       TagBox["\<\"95% Ap[\[Infinity]]\"\>",
        HoldForm], "\<\"2020-05-22\"\>", 
       TagBox[
        InterpretationBox["\<\"    89\"\>",
         89,
         Editable->False],
        PaddedForm[#, 5]& ], 
       TagBox[
        InterpretationBox["\<\"    419710\"\>",
         419710,
         Editable->False],
        PaddedForm[#, {9, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"   778037\"\>",
         778037,
         Editable->False],
        PaddedForm[#, {8, 1}]& ], 
       TagBox[
        TagBox[
         InterpretationBox[
          RowBox[{"\<\"16.\"\>", "\[Times]", 
           SuperscriptBox["10", "\<\"6\"\>"]}],
          1.5959219260961665`*^7,
          AutoDelete->True],
         EngineeringForm[#, 3]& ],
        PaddedForm[#, {9, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"  243034\"\>",
         243034,
         Editable->False],
        PaddedForm[#, {7, 1}]& ]},
      {
       TagBox["\<\"Limit if free\"\>",
        HoldForm], "\[Infinity]", "\[Infinity]", 
       TagBox[
        InterpretationBox["\<\"    344995\"\>",
         344995,
         Editable->False],
        PaddedForm[#, {9, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"        0\"\>",
         0,
         Editable->False],
        PaddedForm[#, {8, 1}]& ], 
       TagBox[
        TagBox[
         InterpretationBox[
          RowBox[{"\<\"16.8\"\>", "\[Times]", 
           SuperscriptBox["10", "\<\"6\"\>"]}],
          1.67991802906637*^7,
          AutoDelete->True],
         EngineeringForm[#, 3]& ],
        PaddedForm[#, {9, 1}]& ], 
       TagBox[
        InterpretationBox["\<\"  255825\"\>",
         255825,
         Editable->False],
        PaddedForm[#, {7, 1}]& ]}
     },
     GridBoxAlignment->{"Columns" -> {{Right}}, "Rows" -> {{Bottom}}},
     GridBoxDividers->{
      "Columns" -> {False, True, {False}, False}, 
       "Rows" -> {False, True, {False}, False}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[1.4]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableSpacing -> {1, 2}, 
     TableHeadings -> {{
       "Onset", "1st Death", "1st Intervention", "Top if free", "Ap = 50%", 
        "95% Ap[\[Infinity]]", "Limit if free"}, {
        Row[{
          Style["p", 
           GrayLevel[1]], "Date"}], "Day", "Sq", "Iq", "Cq", "Dq"}}, 
     TableAlignments -> {Right, Bottom}]]], TraditionalForm]], "Output",
 CellLabel->
  "Out[311]//TableForm=",ExpressionUUID->"446a98c2-c9d0-434c-bff9-\
12fb740c31db"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ReadMeSIA", "[", "\"\<Symbol\>\"", "]"}], "  "}]], "Input",Expressi\
onUUID->"e1cf52c1-b18c-46e2-95e5-1ea6134b0c05"],

Cell[BoxData[
 FormBox["\<\"N[0] = S + E + Y + C + D, with I = E + Y, is the startup \
population of units.\\nN = N[0] - D is the current population, mainly used in \
plotting.\\nS are the Susceptible.\\nE are the Exposed but not infectious \
yet. (They might become diseased.)\\nY are the Infectious. The (currently) \
Infected are I = E + Y, while C + D are have-beens.\\nA = C + D are the \
Acquitted, or the Aftermath. (A avoids confusion with R0. A is conventionally \
denoted as R that may cause that confusion.)\\nC are the Cleared. (Avoid the \
confusing use of R as \\\"Recovered\\\".)\\nD are the Deceased.\\nI = E + Y \
are the Infected. In SIA E = 0 and I = Y.\\nO = N[0] - S - I are \\\"the \
other\\\", so that these are all SIO models.\\nFor variable V: Vq is the \
level and Vp = Vq / N[0] (and explicitly not divided by N).\"\>", 
  TraditionalForm]], "Output",
 CellLabel->"Out[4]=",ExpressionUUID->"6decc791-7abd-47f8-859b-88570a90a57f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "ReadMeSIA"}]], "Input",
 CellLabel->"In[6]:=",ExpressionUUID->"d77f8c97-1e82-4b4e-835a-7f217271c658"],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   StyleBox[
    FrameBox[
     DynamicModuleBox[{System`InformationDump`open$$ = False, 
      System`InformationDump`mouseOver$$ = False}, 
      PaneSelectorBox[{True->
       TagBox[GridBox[{
          {
           ItemBox[
            PaneBox[
             StyleBox["\<\" Symbol\"\>", "InformationTitleText",
              StripOnInput->False,
              BaseStyle -> None],
             FrameMargins->{{4, 0}, {-1, 1}}],
            BaseStyle->"InformationTitleBackground",
            StripOnInput->False], 
           ItemBox["\<\"\"\>",
            BaseStyle->"InformationTitleBackground",
            StripOnInput->False]},
          {
           ItemBox[
            PaneBox[
             
             StyleBox["\<\"ReadMeSIA[] gives an overall explanation of the \
SIA` package. See there for: \\nReadMeSIA[\\\"Terminology\\\"]\\nReadMeSIA[\\\
\"Symbol\\\"]\\nReadMeSIA[\\\"Period\\\"]\\nReadMeSIA[model] for models SIA, \
SICD and SEYCD\\nReadMeSIA[SEYCD, Simplify]\"\>", "InformationUsageText",
              StripOnInput->False,
              LineSpacing->{1.5, 1.5, 3.}],
             FrameMargins->{{10, 10}, {8, 10}}],
            BaseStyle->"InformationUsageSubtitleBackground",
            StripOnInput->False], 
           ItemBox["\<\"\"\>",
            BaseStyle->"InformationUsageSubtitleBackground",
            StripOnInput->False]},
          {
           PaneBox[GridBox[{
              {
               
               DynamicModuleBox[{System`InformationDump`open$$ = {
                False, False, False, False, False, False, False, False, False,
                  False, False, False}}, 
                StyleBox[GridBox[{
                   {
                    TagBox[
                    TooltipBox[
                    StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Definitions\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Definitions", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"ReadMeSIA", "[", "]"}], 
                    "=", "\<\"The SIA` package recognises the levels (q) and \
proportions (p) with Vp = Vq / Nq[0] for variable V: N, S, E, I, R, A, C, D, \
Y, O. The proportions are w.r.t. N[0] and explicitly not current Nq (thus not \
Vp = Vq / Nq). The didactic assumptions are A = C + D and I = E + Y (with Y \
the infectious). The package uses the short names Vq. The long names like \
Exposed etcetera are available as symbols only.\\n  \\nThe routines generally \
allow for user options when these are relevant.\\n  \
\\nReadMeSIA[\\\"Terminology\\\"] clarifies terms on mortality, fatality, \
factor and rate.\\nReadMeSIA[\\\"Period\\\"] gives equations on latency \
period and serial interval (using Strings).\\nReadMeSIA[\\\"Symbol\\\"] lists \
the meanings of the symbols.\\n  \\nThe basic routines f are SIA, SICD and \
SEYCD. They operate via the standard Mathematica practice of using options. \
We do SetOptions[SIA, ...] for the parameters, call sol = f[NDSolve, ...], \
call f[Set, sol] to set Sq[t], Iq[t] etcetera, and then SetOptions[Plot, ...] \
and Plot[f[t], {t, 0, tmax}] and also f[Plot, ....].\\n  \\nWe want to use \
Sq[t] for both numerical output at one time and as a variable or a symbolic \
expression for solving at another time. To do so, the runnable equations are \
put into Hold. We first clear the variables before submitting them to \
NDSolve.\\n  \\nThe models can be presented in traditional or simplified \
form. Default is the latter. \\nReadMeSIA[model] for SIA, SICD, SEYCD gives \
an even more simplified form, using \[Beta]* = \[Beta] / \
Nqt0.\\nReadMeSIA[SEYCD, Simplify] gives an even more simplified \
format.\\nFor traditional form use f[Equations, TraditionalForm, ...] and \
f[N, TraditionalForm, ...]\\n  \\nPM 1. In Mathematica: N is the number \
function, E is the exponential number, I is the unit complex number, C the \
coefficient, D the differential operatator, and O for Landau, and there are \
In[] and Out[], so that we use q instead of n for the number. We avoid name \
conflicts, and actually enhance clarity, by using Vq and Vp. At times, using \
Script font appears to work was well.\\nPM 2. Default parameters R0 -> 4 and \
\[Gamma] -> 1/10 and \[CurlyPhi] -> 0.015 and \[Alpha] -> 1 are for Holland \
and the SARS-Cov-2 pandemic, April 21 2020. PM. The SIA model uses \[Beta] = \
R0 * \[Gamma]\"\>"}]},
                    {
                    RowBox[{
                    RowBox[{"ReadMeSIA", "[", "\<\"Symbol\"\>", "]"}], 
                    "=", "\<\"N[0] = S + E + Y + C + D, with I = E + Y, is \
the startup population of units.\\nN = N[0] - D is the current population, \
mainly used in plotting.\\nS are the Susceptible.\\nE are the Exposed but not \
infectious yet. (They might become diseased.)\\nY are the Infectious. The \
(currently) Infected are I = E + Y, while C + D are have-beens.\\nA = C + D \
are the Acquitted, or the Aftermath. (A avoids confusion with R0. A is \
conventionally denoted as R that may cause that confusion.)\\nC are the \
Cleared. (Avoid the confusing use of R as \\\"Recovered\\\".)\\nD are the \
Deceased.\\nI = E + Y are the Infected. In SIA E = 0 and I = Y.\\nO = N[0] - \
S - I are \\\"the other\\\", so that these are all SIO models.\\nFor variable \
V: Vq is the level and Vp = Vq / N[0] (and explicitly not divided by \
N).\"\>"}]},
                    {
                    RowBox[{
                    RowBox[{"ReadMeSIA", "[", "\<\"Terminology\"\>", "]"}], 
                    "=", "\<\"This terminology applies to the SICD \
model:\\nSICD improves on SIA by distinguishing A = C + D, for D deceased and \
C cleared.\\n\\t(-Sp') is the *incidence* of infections at moment t.\\n\\tIp \
is the *prevalence* of infections at moment t.\\n\\t1 - Sp = I + C + D is the \
*cumulated prevalence* at moment t (i.e. the haves and hads).\\n\\t1 - Sp[\
\[Infinity]] = Ap[\[Infinity]] in both SIA and SICD is the *limit \
prevalence*, since Ip[\[Infinity]] = 0.\\n\\tCp is the cumulated survival \
factor at moment t (but the Sp also count as living).\\n\\tDp is the \
*cumulated mortality factor* at moment t  (mortality ~ population).\\n\\tCp[\
\[Infinity]] is the limit cumulated survival, and part of the burden of \
disease (infection).\\n\\tDp[\[Infinity]] is the *limit (specific) Infection \
Mortality Factor* (IMF) (prevalence of death).\\n\\tDp[\[Infinity]] / Ap[\
\[Infinity]] = Dp[\[Infinity]] / (Cp[\[Infinity]] + Dp[\[Infinity]]) is the \
*limit Infection Fatality Factor* (IFF).\\n\\tMuSICD[] is the \
*(instantaneous) Infection Fatality Rate* (IFR) (fatality ~ \
infection).\\n\\tMuSICD[] = GammaSIA[] * PhiSICD[] in the model, with \
PhiSICD[] the IFF.\\n\\tIn addition for SEYCD:\\n\\tIp = Ep + Yp subdivides \
into Exposed (but not infectious) and Infectious.\"\>"}]},
                    {
                    RowBox[{
                    RowBox[{"ReadMeSIA", "[", "\<\"Period\"\>", "]"}], "=", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Period", "[", "\<\"Generation\"\>", "]"}], 
                    "\[Equal]", 
                    RowBox[{
                    RowBox[{"InfectionInterval", "[", "]"}], "+", 
                    RowBox[{"Period", "[", "\<\"Latency\"\>", "]"}]}]}], ",", 
                    RowBox[{
                    RowBox[{"Period", "[", "\<\"SerialInterval\"\>", "]"}], 
                    "\[Equal]", 
                    RowBox[{"Period", "[", "\<\"Transmission\"\>", "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"Period", "[", "\<\"SerialInterval\"\>", "]"}], 
                    "\[Equal]", 
                    RowBox[{
                    RowBox[{"Period", "[", "\<\"Incubation\"\>", "]"}], "+", 
                    RowBox[{"Period", "[", "\<\"Symptomatic\"\>", "]"}]}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{
                    "Period", "[", "\<\"Asymptomatic infectious\"\>", "]"}], 
                    "\[Equal]", 
                    RowBox[{
                    RowBox[{"Period", "[", "\<\"Incubation\"\>", "]"}], "-", 
                    RowBox[{"Period", "[", "\<\"Latency\"\>", "]"}]}]}], ",", 
                    RowBox[{
                    RowBox[{"Period", "[", "\<\"Symptomatic\"\>", "]"}], 
                    "\[Equal]", 
                    RowBox[{
                    RowBox[{"Period", "[", "\<\"At hospital\"\>", "]"}], "+", 
                    RowBox[{
                    "Period", "[", "\<\"Delay to hospital\"\>", "]"}]}]}]}], 
                    "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"ReadMeSIA", "[", "SIA", "]"}], ":=", 
                    RowBox[{"TableForm", "[", 
                    RowBox[{
                    RowBox[{"SEYCDLettersOnly", "[", 
                    RowBox[{"Simplify", ",", 
                    RowBox[{"SIA", "[", 
                    RowBox[{"Equations", ",", "\<\"t0\"\>", ",", "t"}], 
                    "]"}]}], "]"}], ",", 
                    RowBox[{"TableSpacing", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "3"}], "}"}]}]}], "]"}]}]},
                    {
                    RowBox[{
                    RowBox[{"ReadMeSIA", "[", "SICD", "]"}], ":=", 
                    RowBox[{"TableForm", "[", 
                    RowBox[{
                    RowBox[{"SEYCDLettersOnly", "[", 
                    RowBox[{"Simplify", ",", 
                    RowBox[{"SICD", "[", 
                    RowBox[{"Equations", ",", "t0", ",", "t"}], "]"}]}], 
                    "]"}], ",", 
                    RowBox[{"TableSpacing", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "3"}], "}"}]}]}], "]"}]}]},
                    {
                    RowBox[{
                    RowBox[{"ReadMeSIA", "[", "SEYCD", "]"}], ":=", 
                    RowBox[{"TableForm", "[", 
                    RowBox[{
                    RowBox[{"SEYCDLettersOnly", "[", 
                    RowBox[{"Simplify", ",", 
                    RowBox[{"SEYCD", "[", 
                    RowBox[{"Equations", ",", "t0", ",", "t"}], "]"}]}], 
                    "]"}], ",", 
                    RowBox[{"TableSpacing", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "3"}], "}"}]}]}], "]"}]}]},
                    {
                    RowBox[{
                    RowBox[{"ReadMeSIA", "[", 
                    RowBox[{"SEYCD", ",", "Simplify"}], "]"}], ":=", 
                    RowBox[{"TableForm", "[", 
                    RowBox[{
                    RowBox[{"SEYCDLettersOnly", "[", 
                    RowBox[{"FullSimplify", ",", 
                    RowBox[{"SEYCD", "[", 
                    RowBox[{"Equations", ",", "t0", ",", "t"}], "]"}]}], 
                    "]"}], ",", 
                    RowBox[{"TableSpacing", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "3"}], "}"}]}]}], "]"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                   {
                    TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                    RowBox[{"{", "Protected", "}"}]},
                   {
                    TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"Cool`Survival`SIA`ReadMeSIA\"\>"}
                  },
                  AutoDelete->False,
                  GridBoxAlignment->{"Columns" -> {Right, Left}},
                  GridBoxDividers->None,
                  GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                 StripOnInput->False],
                DynamicModuleValues:>{}]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.5599999999999999]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[3.6]}, 
                 Offset[0.2]}}],
            FrameMargins->6], ""},
          {
           ItemBox[
            TagBox[
             ButtonBox[
              PaneSelectorBox[{False->
               
               DynamicBox[FEPrivate`FrontEndResource[
                "FEBitmaps", "UpPointerOpener"]], True->
               
               DynamicBox[FEPrivate`FrontEndResource[
                "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
               System`InformationDump`mouseOver$$]],
              Alignment->Left,
              Appearance->{"Default" -> None},
              
              ButtonFunction:>FEPrivate`Set[
               System`InformationDump`open$$, False],
              Evaluator->Automatic,
              FrameMargins->{{9, 0}, {0, 0}},
              ImageMargins->0,
              ImageSize->Full,
              Method->"Preemptive"],
             
             EventHandlerTag[{
              "MouseEntered" :> 
               FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
               "MouseExited" :> 
               FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
               Method -> "Preemptive", PassEventsDown -> Automatic, 
               PassEventsUp -> True}]],
            BaseStyle->"InformationTitleBackground",
            StripOnInput->False], "\[SpanFromLeft]"}
         },
         AutoDelete->False,
         FrameStyle->Directive[
           GrayLevel[0.8], 
           Thickness[Tiny]],
         GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
         GridBoxDividers->{
          "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Grid"], False->
       TagBox[GridBox[{
          {
           ItemBox[
            PaneBox[
             StyleBox["\<\" Symbol\"\>", "InformationTitleText",
              StripOnInput->False],
             FrameMargins->{{4, 0}, {-1, 1}}],
            BaseStyle->"InformationTitleBackground",
            StripOnInput->False], 
           ItemBox["\<\"\"\>",
            BaseStyle->"InformationTitleBackground",
            StripOnInput->False]},
          {
           ItemBox[
            PaneBox[
             
             StyleBox["\<\"ReadMeSIA[] gives an overall explanation of the \
SIA` package. See there for: \\nReadMeSIA[\\\"Terminology\\\"]\\nReadMeSIA[\\\
\"Symbol\\\"]\\nReadMeSIA[\\\"Period\\\"]\\nReadMeSIA[model] for models SIA, \
SICD and SEYCD\\nReadMeSIA[SEYCD, Simplify]\"\>", "InformationUsageText",
              StripOnInput->False,
              LineSpacing->{1.5, 1.5, 3.}],
             FrameMargins->{{10, 10}, {8, 10}}],
            BaseStyle->"InformationUsageSubtitleBackground",
            StripOnInput->False], 
           ItemBox["\<\"\"\>",
            BaseStyle->"InformationUsageSubtitleBackground",
            StripOnInput->False]},
          {
           ItemBox[
            TagBox[
             ButtonBox[
              PaneSelectorBox[{False->
               
               DynamicBox[FEPrivate`FrontEndResource[
                "FEBitmaps", "DownPointerOpener"],
                ImageSizeCache->{10., {2., 8.}}], True->
               
               DynamicBox[FEPrivate`FrontEndResource[
                "FEBitmaps", "DownPointerOpenerHot"],
                ImageSizeCache->{10., {2., 8.}}]}, Dynamic[
               System`InformationDump`mouseOver$$]],
              Alignment->Left,
              Appearance->{"Default" -> None},
              
              ButtonFunction:>FEPrivate`Set[
               System`InformationDump`open$$, True],
              Evaluator->Automatic,
              FrameMargins->{{9, 0}, {0, 0}},
              ImageMargins->0,
              ImageSize->Full,
              Method->"Preemptive"],
             
             EventHandlerTag[{
              "MouseEntered" :> 
               FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
               "MouseExited" :> 
               FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
               Method -> "Preemptive", PassEventsDown -> Automatic, 
               PassEventsUp -> True}]],
            BaseStyle->"InformationTitleBackground",
            StripOnInput->False], "\[SpanFromLeft]"}
         },
         AutoDelete->False,
         FrameStyle->Directive[
           GrayLevel[0.8], 
           Thickness[Tiny]],
         GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
         GridBoxDividers->{
          "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Grid"]}, Dynamic[System`InformationDump`open$$],
       BaselinePosition->Baseline,
       FrameMargins->0,
       ImageSize->Automatic],
      DynamicModuleValues:>{}],
     BaseStyle->"InformationGridFrame",
     StripOnInput->False], "InformationGridPlain",
    StripOnInput->False],
   InformationData[
    Association[
    "ObjectType" -> "Symbol", "Usage" -> 
     "ReadMeSIA[] gives an overall explanation of the SIA` package. See there \
for: \nReadMeSIA[\"Terminology\"]\nReadMeSIA[\"Symbol\"]\n\
ReadMeSIA[\"Period\"]\nReadMeSIA[model] for models SIA, SICD and SEYCD\n\
ReadMeSIA[SEYCD, Simplify]", "Documentation" -> None, "OwnValues" -> None, 
     "UpValues" -> None, "DownValues" -> 
     Information`InformationValueForm[
      DownValues, Cool`Survival`SIA`ReadMeSIA, {
       Cool`Survival`SIA`ReadMeSIA[] -> 
        "The SIA` package recognises the levels (q) and proportions (p) with \
Vp = Vq / Nq[0] for variable V: N, S, E, I, R, A, C, D, Y, O. The proportions \
are w.r.t. N[0] and explicitly not current Nq (thus not Vp = Vq / Nq). The \
didactic assumptions are A = C + D and I = E + Y (with Y the infectious). The \
package uses the short names Vq. The long names like Exposed etcetera are \
available as symbols only.\n  \nThe routines generally allow for user options \
when these are relevant.\n  \nReadMeSIA[\"Terminology\"] clarifies terms on \
mortality, fatality, factor and rate.\nReadMeSIA[\"Period\"] gives equations \
on latency period and serial interval (using Strings).\nReadMeSIA[\"Symbol\"] \
lists the meanings of the symbols.\n  \nThe basic routines f are SIA, SICD \
and SEYCD. They operate via the standard Mathematica practice of using \
options. We do SetOptions[SIA, ...] for the parameters, call sol = f[NDSolve, \
...], call f[Set, sol] to set Sq[t], Iq[t] etcetera, and then \
SetOptions[Plot, ...] and Plot[f[t], {t, 0, tmax}] and also f[Plot, ....].\n  \
\nWe want to use Sq[t] for both numerical output at one time and as a \
variable or a symbolic expression for solving at another time. To do so, the \
runnable equations are put into Hold. We first clear the variables before \
submitting them to NDSolve.\n  \nThe models can be presented in traditional \
or simplified form. Default is the latter. \nReadMeSIA[model] for SIA, SICD, \
SEYCD gives an even more simplified form, using \[Beta]* = \[Beta] / Nqt0.\n\
ReadMeSIA[SEYCD, Simplify] gives an even more simplified format.\nFor \
traditional form use f[Equations, TraditionalForm, ...] and f[N, \
TraditionalForm, ...]\n  \nPM 1. In Mathematica: N is the number function, E \
is the exponential number, I is the unit complex number, C the coefficient, D \
the differential operatator, and O for Landau, and there are In[] and Out[], \
so that we use q instead of n for the number. We avoid name conflicts, and \
actually enhance clarity, by using Vq and Vp. At times, using Script font \
appears to work was well.\nPM 2. Default parameters R0 -> 4 and \[Gamma] -> \
1/10 and \[CurlyPhi] -> 0.015 and \[Alpha] -> 1 are for Holland and the \
SARS-Cov-2 pandemic, April 21 2020. PM. The SIA model uses \[Beta] = R0 * \
\[Gamma]", Cool`Survival`SIA`ReadMeSIA["Symbol"] -> 
        "N[0] = S + E + Y + C + D, with I = E + Y, is the startup population \
of units.\nN = N[0] - D is the current population, mainly used in plotting.\n\
S are the Susceptible.\nE are the Exposed but not infectious yet. (They might \
become diseased.)\nY are the Infectious. The (currently) Infected are I = E + \
Y, while C + D are have-beens.\nA = C + D are the Acquitted, or the \
Aftermath. (A avoids confusion with R0. A is conventionally denoted as R that \
may cause that confusion.)\nC are the Cleared. (Avoid the confusing use of R \
as \"Recovered\".)\nD are the Deceased.\nI = E + Y are the Infected. In SIA E \
= 0 and I = Y.\nO = N[0] - S - I are \"the other\", so that these are all SIO \
models.\nFor variable V: Vq is the level and Vp = Vq / N[0] (and explicitly \
not divided by N).", Cool`Survival`SIA`ReadMeSIA["Terminology"] -> 
        "This terminology applies to the SICD model:\nSICD improves on SIA by \
distinguishing A = C + D, for D deceased and C cleared.\n\t(-Sp') is the \
*incidence* of infections at moment t.\n\tIp is the *prevalence* of \
infections at moment t.\n\t1 - Sp = I + C + D is the *cumulated prevalence* \
at moment t (i.e. the haves and hads).\n\t1 - Sp[\[Infinity]] = \
Ap[\[Infinity]] in both SIA and SICD is the *limit prevalence*, since Ip[\
\[Infinity]] = 0.\n\tCp is the cumulated survival factor at moment t (but the \
Sp also count as living).\n\tDp is the *cumulated mortality factor* at moment \
t  (mortality ~ population).\n\tCp[\[Infinity]] is the limit cumulated \
survival, and part of the burden of disease (infection).\n\tDp[\[Infinity]] \
is the *limit (specific) Infection Mortality Factor* (IMF) (prevalence of \
death).\n\tDp[\[Infinity]] / Ap[\[Infinity]] = Dp[\[Infinity]] / (Cp[\
\[Infinity]] + Dp[\[Infinity]]) is the *limit Infection Fatality Factor* \
(IFF).\n\tMuSICD[] is the *(instantaneous) Infection Fatality Rate* (IFR) \
(fatality ~ infection).\n\tMuSICD[] = GammaSIA[] * PhiSICD[] in the model, \
with PhiSICD[] the IFF.\n\tIn addition for SEYCD:\n\tIp = Ep + Yp subdivides \
into Exposed (but not infectious) and Infectious.", 
        Cool`Survival`SIA`ReadMeSIA["Period"] -> {
         Cool`Common`Period["Generation"] == 
          Cool`Statistics`Gamma`InfectionInterval[] + 
           Cool`Common`Period["Latency"], 
          Cool`Common`Period["SerialInterval"] == 
          Cool`Common`Period["Transmission"], 
          Cool`Common`Period["SerialInterval"] == 
          Cool`Common`Period["Incubation"] + 
           Cool`Common`Period["Symptomatic"], 
          Cool`Common`Period["Asymptomatic infectious"] == 
          Cool`Common`Period["Incubation"] - Cool`Common`Period["Latency"], 
          Cool`Common`Period["Symptomatic"] == 
          Cool`Common`Period["At hospital"] + 
           Cool`Common`Period["Delay to hospital"]}, 
        Cool`Survival`SIA`ReadMeSIA[Cool`Survival`SIA`SIA] :> TableForm[
          Cool`Survival`SIA`SEYCDLettersOnly[Simplify, 
           Cool`Survival`SIA`SIA[
           Cool`Common`Equations, "t0", $CellContext`t]], 
          TableSpacing -> {2, 3}], 
        Cool`Survival`SIA`ReadMeSIA[Cool`Survival`SIA`SICD] :> TableForm[
          Cool`Survival`SIA`SEYCDLettersOnly[Simplify, 
           Cool`Survival`SIA`SICD[
           Cool`Common`Equations, $CellContext`t0, $CellContext`t]], 
          TableSpacing -> {2, 3}], 
        Cool`Survival`SIA`ReadMeSIA[Cool`Survival`SIA`SEYCD] :> TableForm[
          Cool`Survival`SIA`SEYCDLettersOnly[Simplify, 
           Cool`Survival`SIA`SEYCD[
           Cool`Common`Equations, $CellContext`t0, $CellContext`t]], 
          TableSpacing -> {2, 3}], 
        Cool`Survival`SIA`ReadMeSIA[Cool`Survival`SIA`SEYCD, Simplify] :> 
        TableForm[
          Cool`Survival`SIA`SEYCDLettersOnly[FullSimplify, 
           Cool`Survival`SIA`SEYCD[
           Cool`Common`Equations, $CellContext`t0, $CellContext`t]], 
          TableSpacing -> {2, 3}]}], "SubValues" -> None, "DefaultValues" -> 
     None, "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
     "Attributes" -> {Protected}, "FullName" -> 
     "Cool`Survival`SIA`ReadMeSIA"], False]], TraditionalForm]], "Output",
 CellLabel->"Out[6]=",ExpressionUUID->"d92613f3-384e-4251-a5a9-020c16beba8a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadMeSIA", "[", "\"\<Terminology\>\"", "]"}]], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"246e3aa6-17d5-4e7e-a8db-a40818e773c1"],

Cell[BoxData[
 FormBox["\<\"This terminology applies to the SICD model:\\nSICD improves on \
SIA by distinguishing A = C + D, for D deceased and C cleared.\\n\\t(-Sp') is \
the *incidence* of infections at moment t.\\n\\tIp is the *prevalence* of \
infections at moment t.\\n\\t1 - Sp = I + C + D is the *cumulated prevalence* \
at moment t (i.e. the haves and hads).\\n\\t1 - Sp[\[Infinity]] = Ap[\
\[Infinity]] in both SIA and SICD is the *limit prevalence*, since Ip[\
\[Infinity]] = 0.\\n\\tCp is the cumulated survival factor at moment t (but \
the Sp also count as living).\\n\\tDp is the *cumulated mortality factor* at \
moment t  (mortality ~ population).\\n\\tCp[\[Infinity]] is the limit \
cumulated survival, and part of the burden of disease (infection).\\n\\tDp[\
\[Infinity]] is the *limit (specific) Infection Mortality Factor* (IMF) \
(prevalence of death).\\n\\tDp[\[Infinity]] / Ap[\[Infinity]] = \
Dp[\[Infinity]] / (Cp[\[Infinity]] + Dp[\[Infinity]]) is the *limit Infection \
Fatality Factor* (IFF).\\n\\tMuSICD[] is the *(instantaneous) Infection \
Fatality Rate* (IFR) (fatality ~ infection).\\n\\tMuSICD[] = GammaSIA[] * \
PhiSICD[] in the model, with PhiSICD[] the IFF.\\n\\tIn addition for \
SEYCD:\\n\\tIp = Ep + Yp subdivides into Exposed (but not infectious) and \
Infectious.\"\>", TraditionalForm]], "Output",
 CellLabel->"Out[5]=",ExpressionUUID->"8ac0f584-ed36-4556-bab0-4a2c0e164077"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
1.3. Infection Fatality Factor (IFF) and symptomatic Case Fatality Factor \
(sCFF)\
\>", "Subsection",ExpressionUUID->"dc891902-1a9b-4578-b442-a19bee802107"],

Cell["\<\
The conventional discussion of the SI(EY)A(CD) model family is oriented at \
the ordinary differential equations (ODE). In particular, the development of \
the deceased compartment is modeled as: \
\>", "Text",ExpressionUUID->"36b9891a-605a-4eb4-8492-bc60c4c7ccc8"],

Cell[TextData[{
 StyleBox["D\[CloseCurlyQuote] ",
  FontSlant->"Italic"],
 "= \[Mu] ",
 StyleBox["I  ",
  FontSlant->"Italic"],
 "in SICD\n",
 StyleBox["D\[CloseCurlyQuote] ",
  FontSlant->"Italic"],
 "= \[Mu] ",
 StyleBox["Y  ",
  FontSlant->"Italic"],
 "in SEYCD"
}], "Text",ExpressionUUID->"1610ba6d-0f2f-4cfe-9ec9-d14216b603cb"],

Cell[TextData[{
 "This causes the question what \[Mu] stands for. What happens if the \
parameter \[Gamma] for the infectious period 1/\[Gamma] changes ? Would there \
be a distinction between a \[OpenCurlyDoubleQuote]lethal infectious period\
\[CloseCurlyDoubleQuote] and a \[OpenCurlyDoubleQuote]clearing infectious \
period\[CloseCurlyDoubleQuote] ? Maugeri et al. (2020) have the better format \
",
 StyleBox["D\[CloseCurlyQuote] ",
  FontSlant->"Italic"],
 "= \[Gamma] sCFF, for the symptomatic case fatality factor (sCFF). A change \
in \[Gamma] will not affect the sCFF and the limit property of the model. The \
Maugeri et al. (2020) formulation still relies upon the ODE format. "
}], "Text",ExpressionUUID->"07451fd7-28f6-4fea-a0c7-ce34732370f0"],

Cell[TextData[{
 "It appears that the ",
 StyleBox["C ",
  FontSlant->"Italic"],
 "and ",
 StyleBox["D ",
  FontSlant->"Italic"],
 "compartments are mere proportions of the acquitted ",
 StyleBox["A ",
  FontSlant->"Italic"],
 "department. The formulation as an ODE is only mathematical convenience of \
modelers who have adopted this format but it is not the essential property of \
the model as such. ",
 StyleBox["A discussion of these epidemic models should not be confused with \
a course on differential equations. ",
  FontSlant->"Italic"],
 "Assuming that didactics is targeted at the relevant property, we get this \
structure, with \[CurlyPhi] the infection fatality factor (IFF):"
}], "Text",ExpressionUUID->"b844f103-a71b-4149-a2a9-c87d3d3fffcb"],

Cell[TextData[{
 StyleBox["A\[CloseCurlyQuote] ",
  FontSlant->"Italic"],
 "= \[Gamma] ",
 StyleBox["I  ",
  FontSlant->"Italic"],
 "in SIA(CD)\n",
 StyleBox["A\[CloseCurlyQuote] ",
  FontSlant->"Italic"],
 "= \[Gamma] ",
 StyleBox["Y  ",
  FontSlant->"Italic"],
 "in SEYA(CD)\n",
 StyleBox["D ",
  FontSlant->"Italic"],
 "= \[CurlyPhi] ",
 StyleBox["A\nC = ",
  FontSlant->"Italic"],
 "(1 - \[CurlyPhi]) ",
 StyleBox["A ",
  FontSlant->"Italic"],
 "= ",
 StyleBox["A ",
  FontSlant->"Italic"],
 "- ",
 StyleBox["D",
  FontSlant->"Italic"]
}], "Text",ExpressionUUID->"1137eb27-19d6-4934-afba-4f5d50ef0b6f"],

Cell["\<\
This immediately clarifies that there is no distinction between a lethal \
infectious period and a clearing infectious period: both compartments have \
the common 1/\[Gamma] infectious period.  (Some readers might want to check \
Appendix A.)\
\>", "Text",ExpressionUUID->"264af6b5-558a-402c-8961-7de0fd60b589"],

Cell["\<\
The package allows the conventional format too, and such properties can then \
derived, even though it is also mathematically more elegant to directly \
specify what the model does.\
\>", "Text",ExpressionUUID->"b4c7f54a-6d0a-45f4-8e8a-5f37ff60e7ae"],

Cell["\<\
This notebook and package use an Infection Fatality Factor (IFF) of 1.5%, \
based upon reweighing the Verity et al. (2020) and Ferguson et al. (2020) \
estimates, applying the Dutch age composition and inserting a special \
assumption on the age 70-79 group, see Colignatus (2020cd), part of which is \
reproduced below in section 2.7. In testimony for Dutch Parliament, RIVM \
(2020e) mentions 9,000 deaths, and, using tests on antibodies that cause an \
expected value of the prevalence of infected (current and past) of 650,000 \
(3.74%), arrives at a crude IFF \[TildeTilde] 1.38%, not far of the 1.5% used \
in this notebook (that is directed at didactics). \
\>", "Text",ExpressionUUID->"4297f3cb-ea18-4dfc-a000-af76f9385c38"],

Cell[TextData[{
 "PM. Not irrelevant: these models for infections are also used for \
symptomatic phases, which is also the case for the Goh (2020) \
\[OpenCurlyDoubleQuote]epidemic calculator\[CloseCurlyDoubleQuote]. Thus \
below we also discuss the distinction between the infection ",
 StyleBox["generation interval",
  FontSlant->"Italic"],
 " and the symptomatic ",
 StyleBox["serial interval",
  FontSlant->"Italic"],
 ". The sCFF has a higher value than the infection fatality factor (IFF) \
since sCFF excludes the ",
 StyleBox["infections without symptoms",
  FontSlant->"Italic"],
 ", which is important in the SARS-CoV-2 case."
}], "Text",ExpressionUUID->"d0f2a581-515a-4b3c-993b-7a2ae8a11dcc"],

Cell["\<\
PM. For antibody testing, see Slot et al. (2020), who also mention a 9.5% \
prevalence in the hardest hit areas, and \[OpenCurlyDoubleQuote]that the \
protective effect of SARS-CoV-2-specific antibodies is not yet known\
\[CloseCurlyDoubleQuote]. \
\>", "Text",ExpressionUUID->"bc494e12-3c92-4826-90b5-fdace60c3a88"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "1.4. The meaning of parameters ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "42866546-152e-4bc0-a992-87bbbb24d238"],
 ", \[Alpha], \[Beta] and \[Gamma]"
}], "Subsection",ExpressionUUID->"1f10021d-0e34-47e7-ab7a-4cb9ede7c1a3"],

Cell[CellGroupData[{

Cell["1.4.1. Euler 1767", "Subsubsection",ExpressionUUID->"f837ff10-f9df-4dbd-a9fa-7d36675a7562"],

Cell[TextData[{
 "Leonhard Euler in 1767 already formulated a \[OpenCurlyDoubleQuote]",
 StyleBox["renewal equation",
  FontSlant->"Italic"],
 "\[CloseCurlyDoubleQuote] for population dynamics, and the SI(EY)A(CD) model \
appears to be a reformulation in terms of (ordinary) differential equations \
(ODE). Relevant papers are Fine (2003), Svensson (2005, 2007), Breda et al. \
(2012) and Champredon, Dushoff & Earn (2018). The latter paper is quite \
recommendable, though they regrettably do not refer to Svensson while a \
comparison of results would have been informative. Delamater et al. (2019) \
clarify that George MacDonald who introduced the term of \
\[OpenCurlyDoubleQuote]reproductive number\[CloseCurlyDoubleQuote] (factor) \
in the epidemiological literature in the 1950s used ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Z", "0"], TraditionalForm]],ExpressionUUID->
  "483a211c-7ee1-4d67-9205-0fd8c8f1e3f9"],
 ". See Heesterbeek (2002) for an overall brief history. "
}], "Text",ExpressionUUID->"b328a787-2035-40ba-a0d1-2e46d7383261"],

Cell["\<\
The structure that seems best for didactics can be found in the Wallinga & \
Lipsitch (2006) paper. For understanding of the SI(EY)A(CD) model family we \
better now specify the latter main structure here at the outset. Let us \
mention two models that do not apply - the fixed period and the normal \
distribution - and one model that does apply: the exponential distribution \
(to be distinguished from exponential growth).\
\>", "Text",ExpressionUUID->"50ec1288-94de-4d2e-9ff3-c91a4c39eb17"],

Cell[TextData[{
 "The general structure is that ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "d8d4df34-d4b6-4132-836e-0fc56035c9ed"],
 ", \[Beta] and \[Gamma] are related to ",
 StyleBox["r, ",
  FontSlant->"Italic"],
 "the rate of growth of the infected compartment, and the Euler-Lotka \
\"renewal\" format rather than the ODE. In general a growth process ",
 StyleBox["x",
  FontSlant->"Italic"],
 "[t] has an ",
 StyleBox["average",
  FontSlant->"Italic"],
 " factor of growth ",
 StyleBox["f ",
  FontSlant->"Italic"],
 "= ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       StyleBox["x",
        FontSlant->"Italic"], "[", "t", "]"}], "/", 
      RowBox[{
       StyleBox["x",
        FontSlant->"Italic"], "[", "0", "]"}]}], ")"}], 
    RowBox[{"1", "/", "t"}]], TraditionalForm]],ExpressionUUID->
  "f1f606fa-7072-45c9-9da8-39a66f1dc951"],
 " and then a rate ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "= ",
 StyleBox["f ",
  FontSlant->"Italic"],
 "- 1 or ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "= Log[",
 StyleBox["f",
  FontSlant->"Italic"],
 "] depending upon one\[CloseCurlyQuote]s preference for linear or \
exponential format. For small values ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "\[TildeTilde] Log[1 + ",
 StyleBox["r",
  FontSlant->"Italic"],
 "] so that the formats differ but the numbers not so much. We may also write \
",
 StyleBox["r",
  FontSlant->"Italic"],
 " = Log[1 + \[Rho]] or 1 + \[Rho] = Exp[",
 StyleBox["r",
  FontSlant->"Italic"],
 "]. The process may be written with a linear or exponential rate ",
 StyleBox["x",
  FontSlant->"Italic"],
 "[",
 StyleBox["t",
  FontSlant->"Italic"],
 "] = x[",
 StyleBox["t",
  FontSlant->"Italic"],
 "-1] (1 + \[Rho][",
 StyleBox["t",
  FontSlant->"Italic"],
 "]) = ",
 StyleBox["x",
  FontSlant->"Italic"],
 "[",
 StyleBox["t",
  FontSlant->"Italic"],
 "-1] Exp[",
 StyleBox["r",
  FontSlant->"Italic"],
 "[",
 StyleBox["t",
  FontSlant->"Italic"],
 "]]. For a constant or average we get ",
 StyleBox["x",
  FontSlant->"Italic"],
 "[",
 StyleBox["t",
  FontSlant->"Italic"],
 "] = x[0] ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", " ", "+", " ", "\[Rho]"}], ")"}], "t"], TraditionalForm]],
  ExpressionUUID->"f64e8b3e-0aca-4ba6-9de9-be7b343543c8"],
 " = x[0] Exp[",
 StyleBox["r",
  FontSlant->"Italic"],
 " ",
 StyleBox["t",
  FontSlant->"Italic"],
 "]. A doubling period is ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "d"], TraditionalForm]],ExpressionUUID->
  "558441d1-5c0d-4a71-b01d-05dce22928c0"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "= Log[2] / ",
 StyleBox["r",
  FontSlant->"Italic"],
 ". The point for SI(EY)A(CD) is that exponential growth is impossible \
because the pool of susceptibles shrinks. Nevertheless, during the first \
growth phase the share of susceptibles is close to 1 for a relatively long \
period and we might e.g. estimate \[Beta] - \[Gamma] \[TildeTilde] Log[2] / ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "d"], TraditionalForm]],ExpressionUUID->
  "981f6e62-b6f1-4dc8-9042-eb910da98d56"],
 ". "
}], "Text",ExpressionUUID->"dd76c1e9-f569-4fc5-b13d-38e02fd5f5a0"],

Cell[TextData[{
 "Two new variables are ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "c"], TraditionalForm]],ExpressionUUID->
  "c3d9ab58-65ab-47fe-870b-d47d5f0ef325"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "74a642da-53c7-4770-85c8-729f90422b5e"],
 ". They basically restate what has already been stated above, but now shift \
to the context of an infection."
}], "Text",ExpressionUUID->"5a45211c-1995-4609-bbe4-dacd1aec4d19"],

Cell[TextData[{
 "- There is the  \[OpenCurlyDoubleQuote]generation interval\
\[CloseCurlyDoubleQuote], denoted as ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "c"], TraditionalForm]],ExpressionUUID->
  "8e319a80-b056-4b2e-b2c0-a7c3583e6acc"],
 ", with \[OpenCurlyDoubleQuote]c\[CloseCurlyDoubleQuote] standing for the \
contribution to the 2nd generation. This interval starts when the infector \
got infected, and it ends when the infector infects another unit (and thus \
when a new generation starts). (There might be some ambiguity however when a ",
 StyleBox["mean ",
  FontSlant->"Italic"],
 "interval concerns the mean age of the new generation.)"
}], "Text",ExpressionUUID->"90349af4-6fab-41a2-abcf-a422f9e4ccc5"],

Cell[TextData[{
 "- Starting with infector 0, the multiplication factor for the secondary \
infections of the new generation with be denoted by ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "afb29c50-9da0-4b99-a121-3b653cd19af5"],
 ". Conventionally the factor is called a number, but it is in relation to \
the number count 1 of the first generation. PM. This generation interval \
differs from the \"serial interval\" for symptomatic disease, see Chapter 10."
}], "Text",ExpressionUUID->"b483b8bb-760d-4ad6-b97e-a1acc1092f00"],

Cell[TextData[{
 "The linear growth rate is ",
 StyleBox["r",
  FontSlant->"Italic"],
 " = (",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "7f2a5ada-8804-40ca-a032-9f2ea21b4760"],
 " - 1) / \[Delta], so that ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "3ca170ae-360d-4728-9b1d-a6d193115e60"],
 " = 1 + \[Delta] ",
 StyleBox["r",
  FontSlant->"Italic"],
 ", in which ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "0f1a17e9-ac6a-4b59-9b9f-cc5aa0db32d9"],
 " - 1 is the increase of the next generation compared to the single \
originator, and \[Delta] is the duration over which this increase happens. \
Rewrite ",
 StyleBox["r",
  FontSlant->"Italic"],
 " = (",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "b3411893-a8d5-481e-8680-485ce731452f"],
 " - 1) / \[Delta] = ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "59b7a698-0eaa-4dad-95ab-3c7430e8d8d6"],
 " / \[Delta] - 1 / \[Delta] = \[Beta] - \[Gamma], with \[Beta] =  ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "357cace6-cbb2-467c-9cae-563075c5c3c4"],
 " / \[Delta] as the contribution to the second generation over the \
generating / infectious period of the originator, and \[Gamma] = 1/\[Delta] \
as the rate per time. It may be convenient sometimes to write \[Gamma] = ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Delta]", "H"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "250e54b3-8064-4958-8ffb-7776c070e130"],
 " or \[Delta] = ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Gamma]", "H"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "27b7fa54-a8a8-431f-8a0d-5b68271bad00"],
 " with ",
 StyleBox["H ",
  FontSlant->"Italic"],
 "= -1 in multiplicative format, see Colignatus (2018). SI(EY)A(CD) models \
are defined in terms of \[Beta] and \[Gamma] and not in terms of the direct ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "321af80f-2a20-4f00-afb4-fd8372dca9e2"],
 " and \[Delta], nor even ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "76c9069b-7985-44e9-81ba-7f51915eb4f5"],
 " ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Delta]", "H"], TraditionalForm]],ExpressionUUID->
  "3e6ccb2f-b86a-420a-b153-3bdd10744fe6"],
 " and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Delta]", "H"], TraditionalForm]],ExpressionUUID->
  "4cbd5d4f-3b41-4809-9f38-9045c8c21028"],
 ". Standard modeling then proceeds in the exponential format, see the \
following."
}], "Text",ExpressionUUID->"69e0b4cf-79ff-475e-a74f-bc128988f573"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.4.2. Constant generation interval", "Subsubsection",ExpressionUUID->"31bba68f-8a25-42a5-ac6f-e626f741317d"],

Cell[TextData[{
 "When the generation interval is constant then all secondary infections \
arise exactly after the same period. This constant ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "c"], TraditionalForm]],ExpressionUUID->
  "64111392-1058-454d-8905-ab39cd1abf5e"],
 " then is also the ",
 StyleBox["mean",
  FontSlant->"Italic"],
 " generation interval. The distribution of the infections over time is \
called the \[OpenCurlyDoubleQuote]delta distribution\[CloseCurlyDoubleQuote]. \
With the rate of growth ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "and the period over which this applies, the number of secondary infections \
will be:"
}], "Text",ExpressionUUID->"54d42978-f168-4d7c-a26f-56a5d539c1f3"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "c2cc6bc9-8e79-4596-97c8-b458f76fef17"],
 " = Exp[",
 StyleBox["r",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "c"], TraditionalForm]],ExpressionUUID->
  "75e14845-fc2c-4785-b45c-d0f99c3e65ab"],
 "] = ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"\[ExponentialE]", " "}], 
    RowBox[{"r", 
     FormBox[
      SubscriptBox["P", "c"],
      TraditionalForm]}]], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "eb1a5512-9faf-4f48-a2d9-b7623b613b84"]
}], "Text",ExpressionUUID->"4f98016a-28ad-42d0-966e-8ac4fdbb8f6d"],

Cell[TextData[{
 "The development over time would show ",
 StyleBox["R",
  FontSlant->"Italic"],
 "[",
 StyleBox["t",
  FontSlant->"Italic"],
 "] = ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    SubscriptBox["R", "0"], "t"], TraditionalForm]],ExpressionUUID->
  "8a4bed85-e044-4bfd-9009-c063624f3e4d"],
 " = Exp[",
 StyleBox["r",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "c"], TraditionalForm]],ExpressionUUID->
  "9fdee35f-3e5e-4353-aa94-0a0b518f5fc5"],
 " ",
 StyleBox["t",
  FontSlant->"Italic"],
 "]"
}], "Text",ExpressionUUID->"9d747ccf-260b-4a39-8404-d224ae6f74db"],

Cell[TextData[{
 "Above, we had the rate ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "= ",
 StyleBox["f ",
  FontSlant->"Italic"],
 "- 1 or ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "= Log[",
 StyleBox["f",
  FontSlant->"Italic"],
 "]. Now we have ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "= Log[",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "4198a5d9-3838-4db9-bbad-aae021b81475"],
 "] / ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "c"], TraditionalForm]],ExpressionUUID->
  "d64320df-e1f9-4de9-bc90-8119b296394c"],
 " so that the unit of account for ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "1fecde11-f2ec-4a61-996c-6883460bc873"],
 " is not 1 but the generation interval. A historical reason is that ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "0ea0e718-23d8-4b6a-b9aa-487bc9519677"],
 " counted discrete units rather than being an average. Another reason is \
that we may attach some interpretation to the generation interval."
}], "Text",ExpressionUUID->"9c082ba9-7c6f-4f8d-9979-06a59a8a661f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.4.3. Normal distribution", "Subsubsection",ExpressionUUID->"ecc35b93-cd2d-461c-81f5-23da26b41690"],

Cell[TextData[{
 "When infections arrive with a generation interval with mean ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "c"], TraditionalForm]],ExpressionUUID->
  "26df69b8-9c6a-467f-a0d9-0b05f8813637"],
 " and a standard deviation \[Sigma] then, with appeal to the law of large \
numbers, they might approximate the normal distribution. The Dublin-Lotka \
result of 1925 is:"
}], "Text",ExpressionUUID->"934a992d-f80c-4677-90b2-9a2e71487f2c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{
    SubscriptBox["R", "0"], " "}],
   TraditionalForm], "\[Equal]", " ", 
  RowBox[{"R0DublinLotka", "[", 
   RowBox[{"r", ",", " ", 
    SubscriptBox["P", "c"], ",", " ", "\[Sigma]"}], "]"}]}]], "Input",
 CellLabel->"In[11]:=",ExpressionUUID->"861c04b9-f077-4eb1-9a66-18317c224b53"],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["R", "0"], "\[LongEqual]", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"r", " ", 
      SubscriptBox["P", "c"]}], "-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox["\[Sigma]", "2"]}], "2"]}]]}], 
  TraditionalForm]], "Output",
 CellLabel->"Out[11]=",ExpressionUUID->"a2484083-b1df-4ec0-8226-0de87bf1f73d"]
}, Open  ]],

Cell[TextData[{
 "Note the constant value when \[Sigma] = 0. Also, the more dispersion, the \
lower ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "83b89061-68c5-40e3-b19f-40377b35a4b1"],
 ", meaning that faster growing infection paths cannot compensate for the \
slower paths. "
}], "Text",ExpressionUUID->"09e49c5e-ad01-4ce2-a4b3-3a4ca7bfdf12"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.4.4. The SI(EY)A(CD) family", "Subsubsection",ExpressionUUID->"0b86b7cd-760d-43cc-80ed-37d06afcb961"],

Cell["\<\
Epidemiology uses these notions from demographics for the SI(EY)A(CD) family \
of models. See the formulas and the plot of the growth rates in Section 5.7 \
on the SIA model. The demographic model assumes exponential growth of the \
population. This will only work in the first and final phases of an epidemic. \
For a long period, the development is distinctly not exponential. However, \
the first and last phases can still be used for estimating the relevant \
parameters.\
\>", "Text",ExpressionUUID->"3376c5e0-0279-4a0b-ad7a-8a292a779ac1"],

Cell["The relevant distinction within the SI(EY)A(CD) family is:", "Text",ExpressionUUID->"e0c7a930-f88c-4d46-bc39-927869abc09c"],

Cell[TextData[{
 "(1)  ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "c"], TraditionalForm]],ExpressionUUID->
  "35a91756-1135-49a8-b13e-ccac5c34c030"],
 " = ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "inf"], TraditionalForm]],ExpressionUUID->
  "b0306805-dfaf-4d17-8d62-ab23699a3ade"],
 ", or the generation interval is also the",
 StyleBox[" infectious period. ",
  FontSlant->"Italic"],
 "This assumes an exponential distribution."
}], "Text",ExpressionUUID->"013d6174-52d0-4f51-a872-f2828119999e"],

Cell[TextData[{
 "(2)  ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "c"], TraditionalForm]],ExpressionUUID->
  "39be650f-9317-4582-82c1-864ea98b6f63"],
 " = ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "exp"], TraditionalForm]],ExpressionUUID->
  "1c4d46e1-13b4-4e01-849c-bbc4e7745315"],
 " + ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "inf"], TraditionalForm]],ExpressionUUID->
  "455e57db-7cb0-45e4-a210-66a5611d1a6f"],
 ", or the generation interval consists of the ",
 StyleBox["infectious period ",
  FontSlant->"Italic"],
 "and a preceding ",
 StyleBox["exposed",
  FontSlant->"Italic"],
 " period during which the unit is not infectious. This assumes the sum of \
two exponential distributions, for both exposed and infectious."
}], "Text",ExpressionUUID->"f12d68b8-03ba-435e-8d5d-ef5740fad7e8"],

Cell[TextData[{
 "Define the ",
 StyleBox["infections over the infectious period ",
  FontSlant->"Italic"],
 "as \[Beta] = ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "af60c96e-1fff-49ec-ba90-d3d7d6d7434b"],
 " / ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "inf"], TraditionalForm]],ExpressionUUID->
  "53d68619-9d02-4cc1-a1f9-91317466619e"],
 " (the 2nd generation considered over the infectious period of the \
originator). ",
 StyleBox["This holds for both models",
  FontSlant->"Italic"],
 ". Thus ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "176646c1-cd8f-4bf5-9fa9-b030958d2984"],
 " = \[Beta] ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "inf"], TraditionalForm]],ExpressionUUID->
  "5c6a997c-40a1-43e6-bdf1-586c3296ba4b"],
 "."
}], "Text",ExpressionUUID->"4299a584-cd95-4222-a04c-3cb023c089cd"],

Cell[TextData[{
 "The rate of leaving the infectious period is denoted as \[Gamma], so that \
\[Gamma] = 1 / ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "inf"], TraditionalForm]],ExpressionUUID->
  "dafdf547-b202-49ee-9588-007b7cde29a1"],
 " or ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "inf"], TraditionalForm]],ExpressionUUID->
  "53a50f79-0920-4faa-b2a5-05da92bb2201"],
 " = 1 / \[Gamma]. This notebook takes ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "inf"], TraditionalForm]],ExpressionUUID->
  "5b06c1fa-2c91-429a-935a-826a7b5a3b9f"],
 " = 10 days."
}], "Text",ExpressionUUID->"fbc23f99-e333-4c2f-9c32-30ae10b8f092"],

Cell[TextData[{
 "The rate of leaving the exposed period is denoted as \[Alpha], so that \
\[Alpha] = 1 / ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "exp"], TraditionalForm]],ExpressionUUID->
  "1cedaa8f-2bc6-45fe-996c-4da83cd4217a"],
 " or ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "exp"], TraditionalForm]],ExpressionUUID->
  "55d737d7-84fd-450b-bd20-559af323cd4c"],
 " = 1 / \[Alpha]. This notebook takes ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "exp"], TraditionalForm]],ExpressionUUID->
  "65648d95-da97-45ce-a7c1-2d667050f573"],
 " = 1 day."
}], "Text",ExpressionUUID->"7c585625-d56c-48df-808f-89ac2a38a8c4"],

Cell["Rewriting from periods to the parameters for the rates:", "Text",ExpressionUUID->"ad8477bf-d9de-4aaa-8199-98bd07f7fa9e"],

Cell[TextData[{
 "(ad 1)  ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "c"], TraditionalForm]],ExpressionUUID->
  "f94a5d81-e094-4420-83f1-bf596e88c427"],
 " =  1 / \[Gamma]"
}], "Text",ExpressionUUID->"17cdf113-d99b-4a94-9b05-cf5eae7fa485"],

Cell[TextData[{
 "(ad 2)  ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "c"], TraditionalForm]],ExpressionUUID->
  "089eba16-bb99-4e0e-bf41-510ef53c1df1"],
 " = 1 / \[Alpha] + 1 / \[Gamma] "
}], "Text",ExpressionUUID->"821a136e-d86e-4d8d-81ff-d91a4f95af2d"],

Cell[TextData[{
 "Each case has its relationship between the reproductive number and the \
growth rate ",
 StyleBox["r.",
  FontSlant->"Italic"]
}], "Text",ExpressionUUID->"4db80e92-57f2-4ec9-83a2-bc93034ee93f"],

Cell[TextData[{
 "(ad 1) ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "7153c27d-c090-4f12-bc75-a28e2e20b93f"],
 " = 1 + ",
 StyleBox["r ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "inf"], TraditionalForm]],ExpressionUUID->
  "c02b0a01-f92c-4227-8ed9-6919e4f07347"],
 " = 1 + ",
 StyleBox["r",
  FontSlant->"Italic"],
 " / \[Gamma]"
}], "Text",ExpressionUUID->"a381e4d1-a535-4068-b035-36aac60e6ec5"],

Cell[TextData[{
 "(ad 2) ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "58e22f6d-158f-487c-b20f-2e55373501a6"],
 " = (1 + ",
 StyleBox["r ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "exp"], TraditionalForm]],ExpressionUUID->
  "ecae4a22-c827-46b1-bb2a-12aae1c17107"],
 ")(1 + ",
 StyleBox["r ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "inf"], TraditionalForm]],ExpressionUUID->
  "68ffcf3c-a1e0-47b4-bc8b-e38a901fe3ea"],
 ") =  (1 + ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "/ \[Alpha])(1 + ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "/ \[Gamma]) "
}], "Text",ExpressionUUID->"4284717f-a97a-4fed-9291-87a421698ed1"],

Cell[TextData[{
 "PM 1. We have done quite a roundabout to reproduce the original notion that \
",
 StyleBox["r ",
  FontSlant->"Italic"],
 "= (",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "66f056cc-9ad4-430d-bcd0-dc3aa7ce7b8a"],
 " - 1) /",
 StyleBox[" ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "inf"], TraditionalForm]],ExpressionUUID->
  "6fc1db5f-3f7a-4ab4-9794-9f8c4418988d"],
 " \[TildeTilde] Log[",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "7b9caece-8d78-49c0-a4af-ad0830f50ef1"],
 "] / ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "inf"], TraditionalForm]],ExpressionUUID->
  "0061e5c6-18fb-47a4-b288-cea5fa0abb28"],
 ". However, while we can apply such transformation for any dynamic process \
at any particular moment in time, only the exponential distribution will \
generate constant parameter values, as assumed here."
}], "Text",ExpressionUUID->"7e85e2d4-29f6-428b-94af-45ec8d2d1b8d"],

Cell[TextData[{
 "PM 2. Using ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "10a8e452-b291-4e27-a99c-ae92c91fefd4"],
 " = \[Beta] / \[Gamma]:"
}], "Text",ExpressionUUID->"f2ee836e-6605-4103-9009-2c77163a0a87"],

Cell[TextData[{
 "(ad 1)  \[Beta] / \[Gamma] = 1 + ",
 StyleBox["r",
  FontSlant->"Italic"],
 " / \[Gamma]  or ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "= \[Beta] - \[Gamma]"
}], "Text",ExpressionUUID->"51402102-5274-485c-bfdf-0d195236d75c"],

Cell[TextData[{
 "For example, RIVM & Van Dissel (2020a)(the Dutch CDC) mention ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "2ab8714e-ea89-45e3-bb06-f98f0ec0c299"],
 " = 2.7 and a doubling period of 5-6 days. If the SIA model applies:"
}], "Text",ExpressionUUID->"ce3d94cd-9c4b-4279-947a-9cfeca6be7c7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqs", " ", "=", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r0", " ", "\[Equal]", " ", "2.7"}], ",", " ", 
     RowBox[{"r0", " ", "\[Equal]", " ", 
      RowBox[{"beta", " ", "/", " ", "gamma"}]}], ",", " ", 
     RowBox[{"r", " ", "==", " ", 
      RowBox[{"beta", " ", "-", " ", "gamma"}]}]}], "}"}], " ", "/.", " ", 
   RowBox[{"{", 
    RowBox[{"r", " ", "\[Rule]", " ", 
     RowBox[{
      RowBox[{"Log", "[", "2", "]"}], " ", "/", " ", "5.5"}]}], 
    "}"}]}]}]], "Input",
 CellLabel->"In[16]:=",ExpressionUUID->"de319764-9278-4f02-a0ce-833934b15b2e"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"r0", "\[LongEqual]", "2.7`"}], ",", 
    RowBox[{"r0", "\[LongEqual]", 
     FractionBox["beta", "gamma"]}], ",", 
    RowBox[{"0.12602676010180824`", "\[LongEqual]", 
     RowBox[{"beta", "-", "gamma"}]}]}], "}"}], TraditionalForm]], "Output",
 CellLabel->"Out[16]=",ExpressionUUID->"dba4f930-bfdd-4241-ae2e-1e4b3f60dfed"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{"eqs", ",", " ", 
     RowBox[{"{", 
      RowBox[{"r0", ",", " ", "beta", ",", " ", "gamma"}], "}"}]}], "]"}], 
   " ", "//", " ", "Quiet"}]}]], "Input",
 CellLabel->"In[17]:=",ExpressionUUID->"849e7fb7-878d-422e-9247-049975da249f"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r0", "\[Rule]", "2.7`"}], ",", 
     RowBox[{"beta", "\[Rule]", "0.20016014839698956`"}], ",", 
     RowBox[{"gamma", "\[Rule]", "0.07413338829518132`"}]}], "}"}], "}"}], 
  TraditionalForm]], "Output",
 CellLabel->"Out[17]=",ExpressionUUID->"f981372b-1b8c-47e4-b3d4-632169e0b9fe"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "/", "gamma"}], " ", "/.", " ", 
  RowBox[{"sol", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellLabel->"In[18]:=",ExpressionUUID->"e6a8151f-8529-4caf-b776-30811a55b403"],

Cell[BoxData[
 FormBox["13.489198632311808`", TraditionalForm]], "Output",
 CellLabel->"Out[18]=",ExpressionUUID->"f64a85e5-8001-4d83-9e12-7fe91897549c"]
}, Open  ]],

Cell[TextData[{
 "(ad 2) \[Beta] / \[Gamma]  =  (1 + ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "/ \[Alpha])(1 + ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "/ \[Gamma]) "
}], "Text",ExpressionUUID->"1c924c93-aea7-4634-b259-2512e42dd59e"],

Cell[TextData[{
 "\t(PM. ad 2) Log[\[Beta] / \[Gamma]]  = Log[ (1 + ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "/ \[Alpha])(1 + ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "/ \[Gamma])]"
}], "Text",ExpressionUUID->"1263ec4e-7608-4fdf-a104-b6faaaa6728e"],

Cell[TextData[{
 "\t(PM. ad 2) Log[\[Beta]] - Log[\[Gamma]] \[TildeTilde] \[Beta] - \[Gamma] \
= Log[1 + ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "/ \[Alpha]] + Log[1 + ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "/ \[Gamma]] \[TildeTilde] ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "/ \[Alpha] + ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "/ \[Gamma]"
}], "Text",ExpressionUUID->"9a9ef7fb-09de-4f9d-8ebb-e1e5ba792dd8"],

Cell[TextData[{
 "\t(PM. ad 2) ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "\[TildeTilde] (\[Beta] - \[Gamma]) / (1",
 StyleBox[" ",
  FontSlant->"Italic"],
 "/ \[Alpha] + 1",
 StyleBox[" ",
  FontSlant->"Italic"],
 "/ \[Gamma])"
}], "Text",ExpressionUUID->"21c85c7d-2c8d-42d6-aab0-f334ed3a8291"],

Cell[TextData[{
 "\t(PM. ad 2) The latter expression reduces for \[Alpha] \[Rule] \[Infinity] \
to ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "\[TildeTilde] \[Gamma] (\[Beta] - \[Gamma]) which shows that the latter is \
a worse estimate than using the original non-approximated expression (1 + ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "/ \[Alpha])(1 + ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "/ \[Gamma]) \[Rule] (1 + ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "/ \[Gamma]). It seems advisable to use (2) rather than the linearisation."
}], "Text",ExpressionUUID->"b9c2da07-2977-4f10-82da-8db10f13b385"],

Cell["For the RIVM figures, assuming the SEYCD model:", "Text",ExpressionUUID->"ebd8520f-049d-46b9-870f-6048724f430d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqs", " ", "=", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r0", " ", "\[Equal]", " ", "2.7"}], ",", " ", 
     RowBox[{"r0", " ", "\[Equal]", " ", 
      RowBox[{"beta", " ", "/", " ", "gamma"}]}], ",", " ", 
     RowBox[{"r0", " ", "\[Equal]", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", " ", "+", 
         RowBox[{"r", "/", "alpha"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", " ", 
         RowBox[{"r", "/", "gamma"}]}], ")"}]}]}]}], " ", "}"}], " ", "/.", 
   " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r", "  ", "\[Rule]", " ", 
      RowBox[{
       RowBox[{"Log", "[", "2", "]"}], " ", "/", "5.5"}]}], ",", " ", 
     RowBox[{"alpha", " ", "\[Rule]", " ", "1"}]}], "}"}]}]}]], "Input",
 CellLabel->"In[23]:=",ExpressionUUID->"24ade3b6-3f29-4c37-9800-14bd2028f706"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"r0", "\[LongEqual]", "2.7`"}], ",", 
    RowBox[{"r0", "\[LongEqual]", 
     FractionBox["beta", "gamma"]}], ",", 
    RowBox[{"r0", "\[LongEqual]", 
     RowBox[{"1.1260267601018081`", " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox["0.12602676010180824`", "gamma"], "+", "1"}], ")"}]}]}]}],
    "}"}], TraditionalForm]], "Output",
 CellLabel->"Out[23]=",ExpressionUUID->"cc8911e2-3ec2-4248-ae81-e83678b52ccf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{"eqs", ",", " ", 
     RowBox[{"{", 
      RowBox[{"r0", ",", " ", "beta", ",", " ", "gamma"}], "}"}]}], "]"}], 
   " ", "//", " ", "Quiet"}]}]], "Input",
 CellLabel->"In[24]:=",ExpressionUUID->"8062f84d-b01b-4c2d-ac83-ea13e881c84c"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r0", "\[Rule]", "2.7`"}], ",", 
     RowBox[{"beta", "\[Rule]", "0.2434321321793337`"}], ",", 
     RowBox[{"gamma", "\[Rule]", "0.09016004895530878`"}]}], "}"}], "}"}], 
  TraditionalForm]], "Output",
 CellLabel->"Out[24]=",ExpressionUUID->"640988f6-c480-4b94-b1c3-b78746936922"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "/", "gamma"}], " ", "/.", " ", 
  RowBox[{"sol", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellLabel->"In[25]:=",ExpressionUUID->"f0b0a4f1-0550-4754-9dba-64087e5f3c16"],

Cell[BoxData[
 FormBox["11.091387056540837`", TraditionalForm]], "Output",
 CellLabel->"Out[25]=",ExpressionUUID->"3063766a-6cdf-4532-863d-8df2c7822d66"]
}, Open  ]],

Cell[TextData[{
 "PM 3. The growth of the infected = infectious in SIA can be found in ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "= dLog[",
 StyleBox["I",
  FontSlant->"Italic"],
 "] = ",
 StyleBox["I\[OpenCurlyQuote]",
  FontSlant->"Italic"],
 " /",
 StyleBox[" I ",
  FontSlant->"Italic"],
 "= \[ScriptI] = \[Beta] ",
 StyleBox["Sp",
  FontSlant->"Italic"],
 " - \[Gamma], see Section 5.7. It will be useful to identify the ",
 StyleBox["dynamic ",
  FontSlant->"Italic"],
 "reproductive factor ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "04a20703-7858-452f-b5cd-83757ade1c87"],
 "[",
 StyleBox["t",
  FontSlant->"Italic"],
 "] = \[Beta][",
 StyleBox["t",
  FontSlant->"Italic"],
 "] / \[Gamma][",
 StyleBox["t",
  FontSlant->"Italic"],
 "] and the ",
 StyleBox["effective ",
  FontSlant->"Italic"],
 "reproductive factor ",
 StyleBox["R",
  FontSlant->"Italic"],
 "[",
 StyleBox["t",
  FontSlant->"Italic"],
 "] = ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "f453428c-1d7f-4aa9-ac28-70b623df5abd"],
 "[",
 StyleBox["t",
  FontSlant->"Italic"],
 "] ",
 StyleBox["Sp",
  FontSlant->"Italic"],
 "[",
 StyleBox["t",
  FontSlant->"Italic"],
 "], where the latter corrects for the influence of the declining share of \
susceptibles. In SIA thus ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "= ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SubscriptBox["R", "0"]}], TraditionalForm]],ExpressionUUID->
  "1c2062b1-71f4-402a-8c55-b5342878f1ba"],
 " ",
 StyleBox["Sp",
  FontSlant->"Italic"],
 " - 1) / \[Delta] for \[Delta] = 1/\[Gamma], which gives an ",
 StyleBox["effective ",
  FontSlant->"Italic"],
 "version of the above. Here ",
 StyleBox["Sp ",
  FontSlant->"Italic"],
 "would be a dimensionless number, as units of susceptibles per units of the \
base population. "
}], "Text",ExpressionUUID->"c73cbee8-8f2a-4f53-8fa6-fb4072bbaa92"],

Cell["\<\
PM 4. It is useful here to refer to the same result as in Chapter 10. The PDF \
of the random variable that is the sum of two exponentially distributed \
variables is (and observe the symmetry):\
\>", "Text",ExpressionUUID->"e7f6aceb-800c-4f23-9f75-9cd032dcd2b6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SumTwoExp", "[", 
  RowBox[{"\[Alpha]", ",", " ", "\[Gamma]", ",", " ", "t"}], "]"}]], "Input",
 CellLabel->"In[8]:=",ExpressionUUID->"3565cc08-1609-46da-b911-808cf79b30d9"],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"\[Alpha]", " ", "\[Gamma]", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Alpha]", " ", 
        RowBox[{"(", 
         RowBox[{"-", "t"}], ")"}]}]], "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Gamma]", " ", 
        RowBox[{"(", 
         RowBox[{"-", "t"}], ")"}]}]]}], ")"}]}], 
   RowBox[{"\[Gamma]", "-", "\[Alpha]"}]], TraditionalForm]], "Output",
 CellLabel->"Out[8]=",ExpressionUUID->"835617a2-8a12-45aa-95d9-f8fa9c82e03d"]
}, Open  ]],

Cell[TextData[{
 "When we substitute this pdf in the Moment Generating Function as indicated \
by Wallinga & Lipsitch (2006), then (while remembering that this only holds \
for ",
 StyleBox["part ",
  FontSlant->"Italic"],
 "of the process in SEYA(CD), namely the exponential phases):"
}], "Text",ExpressionUUID->"e6b64ad2-16c3-444f-b234-f74cff2ad5e9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"R0", " ", "\[Equal]", " ", 
  RowBox[{"1", "/", " ", 
   RowBox[{"Integrate", "[", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "r"}], " ", "t"}], "]"}], " ", 
      RowBox[{"SumTwoExp", "[", 
       RowBox[{"\[Gamma]", ",", " ", "\[Alpha]", ",", " ", "t"}], "]"}]}], 
     ",", "  ", 
     RowBox[{"{", 
      RowBox[{"t", ",", " ", "0", ",", " ", "Infinity"}], "}"}], ",", " ", 
     RowBox[{"Assumptions", " ", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"r", ",", " ", "\[Gamma]", ",", " ", "\[Alpha]"}], "}"}], 
         " ", "\[Element]", " ", "Reals"}], ",", " ", 
        RowBox[{
         RowBox[{"\[Gamma]", " ", "+", " ", "r"}], " ", ">", " ", "0"}], ",", 
        " ", 
        RowBox[{
         RowBox[{"\[Alpha]", " ", "+", " ", "r"}], " ", ">", " ", "0"}]}], 
       " ", "}"}]}]}], "]"}]}]}]], "Input",
 CellLabel->"In[9]:=",ExpressionUUID->"2bd2fc56-b738-4f3d-824f-dcfa33fd085e"],

Cell[BoxData[
 FormBox[
  RowBox[{"R0", "\[LongEqual]", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Alpha]", "+", "r"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"\[Gamma]", "+", "r"}], ")"}]}], 
    RowBox[{"\[Alpha]", " ", "\[Gamma]"}]]}], TraditionalForm]], "Output",
 CellLabel->"Out[9]=",ExpressionUUID->"5cdc5298-e076-4a71-8e4c-1a1649c81d4c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.4.5. Empirical distributions", "Subsubsection",ExpressionUUID->"cb4325dd-6257-4d6e-8d64-66331b493538"],

Cell[TextData[{
 "Wallinga & Lipsitch (2006) mention the important case when the ",
 StyleBox["R",
  FontSlant->"Italic"],
 "[",
 StyleBox["t",
  FontSlant->"Italic"],
 "] can be taken from the moment generating function of an empirically \
observed distribution of interarrival times. Wallinga has been affiliated \
with the RIVM, the Dutch counterpart of the US CDC, and has a special \
professorship in Leiden. He is also co-editor of the \
\[OpenCurlyDoubleQuote]Handbook of infectious disease data analysis\
\[CloseCurlyDoubleQuote]. Our chapter 2 below will copy the RIVM graph of \
such ",
 StyleBox["R",
  FontSlant->"Italic"],
 "[",
 StyleBox["t",
  FontSlant->"Italic"],
 "]. See section 5.2 for terminology, with \[Beta][",
 StyleBox["t",
  FontSlant->"Italic"],
 "] / \[Gamma][",
 StyleBox["t",
  FontSlant->"Italic"],
 "] for the \[OpenCurlyDoubleQuote]",
 StyleBox["dynamic",
  FontSlant->"Italic"],
 " reproduction factor\[CloseCurlyDoubleQuote], while the \
\[OpenCurlyDoubleQuote]",
 StyleBox["effective ",
  FontSlant->"Italic"],
 "reproduction factor\[CloseCurlyDoubleQuote] ",
 StyleBox["R",
  FontSlant->"Italic"],
 "[",
 StyleBox["t",
  FontSlant->"Italic"],
 "] also corrects for the level of susceptibles Sp[",
 StyleBox["t",
  FontSlant->"Italic"],
 "]."
}], "Text",ExpressionUUID->"b80629db-f542-4f9b-b846-ded26872e23e"],

Cell[TextData[{
 "A comment from theory is that it would remain important to distinguish \
different types of infectious paths. (i) For a longer horizon, there are \
births and background deaths. (ii) When there is symptomatic disease, there \
may be asymptomatic transmission, see Chapter 10, and this may have \
complications for estimation and source and contact tracing. (iii) When one \
path systematically has short intervals and another path has systematically \
longer intervals, then the joint distribution is not stable, and one might \
better distinguish two compartments. A distinction may be that the elderly \
have faster symptoms and clear later. (iv) The RIVM ",
 StyleBox["R",
  FontSlant->"Italic"],
 "[",
 StyleBox["t",
  FontSlant->"Italic"],
 "] graph is estimated on hospital admissions but over time in Holland the \
empirical value of this series has not been constant. There was a \
learning-effect about the virus, with a shift away from hospitalisation, with \
deaths no longer tested and not officially recorded as \
\[OpenCurlyDoubleQuote]SARS-CoV-2 deaths\[CloseCurlyDoubleQuote] but showing \
up as \[OpenCurlyDoubleQuote]surplus deaths\[CloseCurlyDoubleQuote] in the \
monthly statistics."
}], "Text",ExpressionUUID->"ebcf342b-0457-424d-bfb2-5134993d082d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.4.6. Interpretation of \[Gamma], also for estimation", "Subsubsection",ExpressionUUID->"62845116-b737-4e01-bcbe-3bbf6bf5bd89"],

Cell[TextData[{
 "Above discussion with the generation interval has the didactically \
beneficial property that the emphasis lies on the periods and not the rates. \
In the conventional ODE format, the SI(EY)A(CD) models are formulated with \
\[Beta] and \[Gamma], and subsequently the relevance of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "91820933-ae53-4e37-9fa7-14c1b28e7393"],
 " = \[Beta] / \[Gamma] is deduced. Below we will also present the models \
with those rates. However, the above should provide some antidote, that \
underlying assumptions already have a close connection with the periods, the \
rate of growth and the reproductive factor, via the notion that ",
 StyleBox["r ",
  FontSlant->"Italic"],
 "= (",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "5fd01fa4-c972-40ef-aff1-f0613c8fc154"],
 " - 1) /",
 StyleBox[" ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "inf"], TraditionalForm]],ExpressionUUID->
  "59be69ce-8d42-4ecb-a1e8-72673e27271b"],
 " \[TildeTilde] Log[",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "1c55281c-e91c-4257-9ae7-a545bd4f12f2"],
 "] / ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "inf"], TraditionalForm]],ExpressionUUID->
  "893eb901-805a-4b52-82ed-b1b508cc7e3c"],
 "."
}], "Text",ExpressionUUID->"e7f79c2d-2a70-4c8f-b17c-7c219f6e26c9"],

Cell["\<\
The interpretations of \[OpenCurlyDoubleQuote]infectious period\
\[CloseCurlyDoubleQuote] and rate of acquittal are adequate for an \
application for e.g. such natural infectious period (a \
\[OpenCurlyDoubleQuote]real infectious period\[CloseCurlyDoubleQuote]). The \
issue may become more complicated when we change our assumptions and the \
model might not quite apply like we might suppose.\
\>", "Text",ExpressionUUID->"3ce525a1-fb6e-4fca-bfaf-7aa5759d38fe"],

Cell[TextData[{
 "On occasion a better format for the model may be to replace \[Beta] \[Rule] \
",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "227cbb3c-7e58-4968-baed-95a53a2ab44e"],
 " / ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "inf"], TraditionalForm]],ExpressionUUID->
  "bb1c9a3a-cc3d-4438-80bd-62958c95960f"],
 ". While ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "0441cd99-5efc-4d28-a2e5-c23030aa4b2b"],
 " gives the number of infections, those ",
 StyleBox["given ",
  FontSlant->"Italic"],
 "infections are spread over said period. A change of the \"infectious period\
\" then does not affect the given number of infections. In this manner, \
\[Beta] has been made \[OpenCurlyDoubleQuote]variable\[CloseCurlyDoubleQuote] \
in order to fit the given number of infections ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "ef96947b-4b97-4d90-af10-5517b3e117f0"],
 ". This perspective appears relevant when modeling and estimating an \
intervention. An estimation routine may be ill-conditioned for \[Beta] and \
\[Gamma], and show no real differences in outcome, when their ratio ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "d71d7e7f-93fd-4638-835e-cff8ecf21a8b"],
 " does not change along the ray \[Beta] = ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "6be31c45-8c6a-4628-afa3-52c0fdc80411"],
 " \[Gamma]. In this perspective the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "inf"], TraditionalForm]],ExpressionUUID->
  "11ec1df8-3d16-4840-a0d6-3a7960797874"],
 " can better be seen as a normalisation factor, that cannot be changed, and \
the estimation then concerns ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "02c2efb2-d9e6-4548-8b7d-b145db46e439"],
 " only. "
}], "Text",ExpressionUUID->"6dd657a5-3618-4cf2-8fce-029c2396df32"],

Cell[TextData[{
 "Let us consider another case when both ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "25a83b55-9412-4618-b9f1-653b81642c1e"],
 " and \[Beta] are reduced, with a reduction of the infections, accompanied \
by a reduction of the \[OpenCurlyDoubleQuote]infectious period\
\[CloseCurlyDoubleQuote]. The rise in the rate of acquittals \[Gamma] causes \
a surge of the acquittals, and thus also a rise in the death toll (in the \
short run). Let us first give a numerical example before discussing the issue \
further. The following has values relevant for SARS-CoV-2."
}], "Text",ExpressionUUID->"95cd4e30-62d0-4187-9c2c-8b04bb338978"],

Cell[TextData[{
 "(base) There is a base case \[Beta] = 0.6 and \[Gamma] = 0.1. Thus ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "61354dc1-3607-49a9-9605-0612fb94922e"],
 " = 6 and the infectious period is 10 days. The graph below depicts this \
base case with ",
 StyleBox["dot-dashed",
  FontSlant->"Italic"],
 " lines (and not just dashed)."
}], "Text",ExpressionUUID->"430c8ab2-8ef5-4f17-ac56-8605d03362f4"],

Cell[TextData[{
 "(intervention) Subsequently there is an intervention on day 24 with \[Beta] \
= 0.4 and \[Gamma] = 2. Thus ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "520e38b2-86ee-46f7-8684-48f840f47310"],
 " = 0.2 and the infectious period is 1/2 day. This is depicted with ",
 StyleBox["drawn",
  FontSlant->"Italic"],
 " lines (the deceased dashed though)."
}], "Text",ExpressionUUID->"a94265dc-a6c1-4abb-a7df-203f35439f31"],

Cell["\<\
The intervention is dramatically effective. The death toll quickly tops at \
its limiting value of some 7000 persons (including those of before the \
intervention). \
\>", "Text",ExpressionUUID->"9438cfd5-dbcd-4971-a069-c2882657708d"],

Cell["(The following graphs are copied from section 16.13.)", "Text",ExpressionUUID->"b548d1d6-e579-4474-8b88-c0796c80c51e"],

Cell[BoxData[
 FormBox[
  TagBox[
   FormBox[
    GraphicsBox[{InsetBox[
       GraphicsBox[{{{{}, {}, {}, 
           TagBox[
            {Hue[0.59, 1, 1], AbsoluteThickness[1.6], Opacity[1.], 
             LineBox[CompressedData["
1:eJwdlXk41I0ChZHSIjKIrGMwdkYpkvyOEGPf19JU2qQ0Ci22LCFLQorEFFmG
rCmiQqFdqS9XqWwRlbJ8TNPE7d7zPOd5/znP++9R2hXkskeAj4+v7m//Tw/e
v99vPDbdMbOMx13wQlKHX49zWglR7xJtrz7sifR3MacU0m4T7DGV7uI+D0yo
ly8+y24lOsNOW9C+uCNrOOu5YFon0SYYGp252B3GrMgLUcznhDvfEfW6dW74
qXNTN4L9iugRXb8zjumK7LErs3OpPYR2/M0Te6RdcKAzw6c+6h0x9Sz5TU2U
M0yuJ9wLZn4gpJbal1CnnZBoZip2Sb+f2BO0wnRxsBOY1UYPQtkDxN3H1Rc3
zDnCR3FdiLvyEHHQedY+TsERFmk6agZ5w4SU0AmJZi8H6P5R6yVJjhC3hkrq
7xTZQyqQkjyZOkqYFA5JHuG3B997uc0vl4wRUTtCJj4cssM4XepHZdQ4MXqh
qGT1mC1eN4hdTeV8JfaduuVqEmyLZjVh10DmdyL3ZXVB1FJbFGcvWWw7PkGU
j6l8Uyi3waOY6PdZ+j+JxHHxoD3eNjC5E2EgOPGTcHxz0ItNskHN5MnUo+xJ
Iq6aJ+30lg6qxvGRwb1TxEf+waIHhXTkMkIIF+VpYs1UTfupk3SIXgq+1Ppp
mmDmy8RwvOmI6wqapOXNENcyeyPbzOj4teSQDcvrX+KAkGFogD4dh00DCkUl
Z4nBrQ9vJKrTMRiyjxf5apa4pH8qv5lKh+cNf/eJ1DlCWq+JqNCi49nwzsrt
NhwClpdfLzKkA3I7hJ4v+UUYxzECQqzpqHfdxjB58IuQzCaSG3bQoZns3Vge
xSWiNR/1JoXTkd/mQZI1+U2o7Nvczs6nQ5zrevAs5zdRPvDaeKCdjkR954e/
bvKIp+/6t81N0sHb7yB/gPmHYLyuIJooNmCybEP/ozNPtN/2Y8972mCkx7rL
anyekMtV68s+b4P9hVeRqc+HwbZ71zTFbEEhyN+fnONDrkuzXr+HLfre5ecI
TPDhWCB3tR/LFs6kvCkmmx8OXc97zE3tIFwpU1C2VACllk++nsiwQwc9x3Zg
rwCk8oQSJMbtYHw6u8hJeRHSmcGOmoX2UPmZ7qGXJwgLe/urCpsc8TFZdNE+
riBKuiPJNaWOyFFLq8r3Wgwljo95nrATRHYkLxWRXIJZV3uvuNNOmHsef+db
qhD6nq3kOxfuDH9iuZHYjBD2Z9hUxT50Rnd1Wv16n6WQuH7RgSLigsrMi9WR
1GW4P7dRw6/YBf7eZcWr7i8HddlNmclxV3Q/0VFZr7oClL4Hei5wA0xqr3on
r0Arw/t+wEU3yCo25V3zFIYva2vLSxt3dA8/yzD4uRLxu3fJfunwADycV3l7
iCBqt7vZSU1PVHb+kxrRLIK0Lkm5sXOeSGJ/TOxIFIXK2nSFEIYXyEbHiYr0
VVj74r3wvLQPev4krTfVIEGbu7Bp+8R2pG2wO+a0jQSyQym/+FE/WASJ1O06
R8ImL7ItheuH2v4MWsK/JCy3Tza7I8RA2oPLWi9bxfFh4dYfAe2dsORtDxic
EQef/F1Xl+M7wTMgl82oSWBredkRTvtOBBQXUdekScB1QzqVsWcXLJNuKO3y
kURYtTjHsn43eK1BjGOpkugX+LRxWtgftVz9gjMtkjj970KW+l5/kANvyZVT
V+PaaHjKVvk94Dncl5qZWo1k8xZN8YK9qJN4tfJMsjRya7gBp+YOoJkpO7y+
SRpyx343++0OwMMXe+58HpeGfIjxO4FXAXibyN1rabMGavPd+eyag+DwlFsE
l8nAteKuqG3SIfD7HM6+aSQD4pxW0xLBw1h+uyHQf78MCqwiK1uiD0OWab/m
YeffPcWrxCk6CKafQ4Njz8jiw9DN4P3PjsBqS6v1uluysGyQEzAkMeFUsEJx
6LMscuhbGtS8mdjpzXq6xVIOpvObY2PGmYh7/lhFQFAeM0cnNYplj+JJvVxP
9GkFNO5VO6bXHIJu0r4btBoFrJKJN41ZHYr3QTWx/f0KkO3+5WcXHIpvGltp
gCJiudvkduiGQTQ/KGlhXhHnOg666TUeR8qfvipPKTJ8q0T4viuewCptgct6
emSc9Ze84J54AmuS7Jif/MjI2M5xNPc7CU3zAXniHhkfHcZUfBTDUclcskzq
LRmbiC2RhlnhWMfSmpn4TsbcL8eD3OURMPkT8iRfXgnkIkqR03wE7G8vD5sP
V8LXLe+clf9E4YiWwcu7myjQefvKIkI/Bh8NrRbkXSmo3BLgdulUDOwtfHQj
AyhIMHWlDXTEQHN7dIppDgVFu8hpojtj8TntmfX9WQrOZJaoBBTFwe3ypzBF
EWVYssutIjlxaCuZKo5SVUbMfHHXF/t4sFqkF8NNGZNBh0be8uLhM+Xf2lKj
DJrBVo36gwl4NB/2k/xYGdNacY/XPE2A4YpkxdP9f30ewn0C2omQUKmJMBNV
gVbsPcVTU4l44f5nY1ugCjZJKLnfzjgL88YLtQ/UVPElxeO3IzUNte2lA8qE
Km4f18yRuZoGcnfTqjgPVeSmC6n3yp/D/PjAYYt4VQy0G8yXiqSjQU5Xq31Q
FWd+vU9IkTn/9y/MfFS5qtiXzD5kwDiPC+vdkuLFqJiopYzOFZ9HsMPJUUtQ
sXBZs3zIMAPa0R2FHVeoqBjONXq1LxO5Kb3d1Hoq5k/NcHpuZWJZzjf+hGdU
ZLx+E0AWysJIDYlh9ZuKeyNLRs+WZ+HqkJ/cIy81bDwknOojmI3VVnNZj8XV
MRo8WtDFvYSpR7YcFR11OJ1ojzI6kIPnNizf6K3qeH1vRDGpNwdxDnSK4Ql1
+Oqr717Ukosp98tVRR/V8TQ7vNDpeh5e9Pwg8XHUETbboP1V+QrKvC1CfcU0
0EXSGL9ZdAWM7d9NSBYa8Kw0r+VV5OO5P/EkqkwD9vxLp+8EslA6kqnzvk0D
Q4vZZU71LMTt/5K+oU8DH4M3jVMXWDAOPO/5XUQTFG7Y5vLsqyg9OjTsc0wT
Rx4Zv6775xriYhIW1hNaYFRENyjmXAdDsG/XeS8tVBzWmUjhXMemM7SOb0wt
5LPu+xV4F2MqqTelsEgLt3uppFfkEjDOa8mILdeGt++OauOHpTARj44IVNaG
o8rku0L9MkhdeNPfaaIN3ie7dz9YZXhxKaIkMkgbaXIldc7xbJiwugy+vdGG
w92u47p7KyBNUblkNaGNzdRYTv5QBaYLj/++JqSD0WidD0a7b4BdotTmbawD
yw8JwqIHKiFdddSxs0AHzJ8zw9rW1Zi+KxVwLUAXqQu/3juV14LjTMuxi9EF
Ixb16zi14H22fjSbo4sN4S9qXLbWQVDkJNX2sS6qFDX2e4/UYbVf3+C0mh7u
KXGvy22oh8zUjFg+oQfzsC9jwan1UDiz0szaUw97rJQotJF6qFWaFuSd0UOf
4MbI2cu3YDTP8rX8rIema37h3msaYJLRePYHTw/zvZ2+qeENIIuP9dktp6Hf
oqPFa6ABqiX8wnNKNPAuzpm9rGqEbtfaAFtnGn5kloguMJpAKF6gzlTRUMqy
f1Igcx9bDiiZPm6iwaWGY56dex8WdTfc8ztpWDv+e8hOpAXWVh1x1p9ocIw7
234sswVOQXODeSL6sDyr69/FboVLYyyXKaOPvo3rm8OmW+G2aBXJiqqPnf+Q
ftM3t8H7orrZ5GZ9pDwYNYp604b9EpLnG730wfe/JD7AfwHT/guT
              "]], LineBox[CompressedData["
1:eJwlmmk8Fc73x5GQnaJCtqgsiRSKO3O4tsvFvcgSEl872ZdCCS1KWbJE9kKR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              "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQBmIQ7Whls9TgeLADAxR02QYzd54JdihI7f+6VWWGLR+D
xazN54Mdduh9T5iftch24iEZw3uXgh0ayu5+umyzwlaklfEEx7VgB4Pst43z
utfaznB/Fmd8M9jhwLcz+Zd0NtrKcJ3+Gnsn2EHj7aq8YyGbbRecWd/TcR9o
PoeX2j+7rbYq/VOUNz8KduDYkVx/5s022+WBlbvuPg12+JC1MaklfodtwbRr
WpdeBDvMmGF8NKx1p63FbePZx14D5eWljryr3GXLqDCRe/c7oH2ZP0/H2+22
PZXyrnr9x2CHE3dTPfde3m07aaX3m8Vfgh0cnnxeIWW9xzb63YqYGd+DHTqe
mod3l+6xVTFmO9vzC6je89gBpZY9tm/Kk20b/wY7WFQaB31J32O7dc+BtaUM
IQ4cd4QrhJX22NYxysllMYc4ONz6PW/y5t22bm7VfXFsIQ4dd+qNO2R32/J3
3/gXxAnke5ksYkncZXvjvGm+O0+Iw4GeteEy9TttF4hMvm/NH+KwgrvhwKOK
HbaZkR/8DYRCHE7oOXhm+2+3NZrne0BFNMRhR1xT3Enmbba/H60ykJQAqme+
nSMwfYvtEXWOhbzSQPnWew+CuTbbhm481PhNIcThQ2t+hLXWelu5b/KfXimH
ODDMydk5NXa17TOr2qT7aiEOBuuTvFoil9tWHDF3PqET4vBAcNfBovS5to6c
Uzfv0Qfqf5RqOFtnii2X3yfljUYhDgvipkxx1Wi1rTOYNfOEaQg8fQAA7Lb9
Vg==
              "]], LineBox[CompressedData["
1:eJw9VXs01fkeJYUeGI9rCHklpUaihuJTH4Vk5H2+v5NSIip5dyZdugwVcjzy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              "]], LineBox[CompressedData["
1:eJw9mHs01F3Ux0kuyUOhVMotlVwjxYPNLhJFpSTm8pvfyCUqKeJRlJRELs0w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              "]]},
            Annotation[#, "Charting`Private`Tag$7301#2"]& ], 
           TagBox[
            {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
             LineBox[CompressedData["
1:eJwVkHc41YsDxiW7ri17HRw7Kqs61/fNqIz88svIKTOUiA46Utfe4aDMZISI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              "]], LineBox[CompressedData["
1:eJwlmnc0F97/x4mQkVEqFBEqqUhGeN/7sjfvt2wyijIyQpL5ySrKnlmRkV1W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              "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAUjk8pTDHU0AAAAAAAAAAAIo9UwOJ
zFNAMHIfyKSTkj0OADias89TQJBxYHUsV5w9kcIcMd7SU0CIQfhAM6aiPRSF
AcgI1lNASN4OALO7pj2YR+ZeM9lTQIgaGwEfbqo9HArL9V3cU0Co/kPNgL+t
PaDMr4yI31NAMErY9vBYsD0kj5Qjs+JTQPTyw/Wlo7E9p1F5ut3lU0Akfvgn
5MCyPXCW1irS6FNAnNeBrPeisz042zObxutTQMiK7X4qX7Q9ASCRC7vuU0DM
096KUPa0Pcpk7nuv8VNAkO34uz1ptT2SqUvso/RTQDwT3/3FuLU9W+6oXJj3
U0CEgDQ8veW1PSQzBs2M+lNAgHCcYvfwtT3sd2M9gf1TQKAeulxI27U9tbzA
rXUAVEAExjAWhKW1PX4BHh5qA1RAQKKjen5QtT1GRnuOXgZUQKDutXUL3bQ9
D4vY/lIJVEBM5grz/ku0PdjPNW9HDFRAlMRF3iyesz2gFJPfOw9UQDTFCSNp
1LI9aVnwTzASVED0Ivqsh++xPTKeTcAkFVRATBm6Z1zwsD374qowGRhUQIjH
2X12r689xCcIoQ0bVEAYe2s88EytPVWxwoH2IFRAkBktR7f6pz0e9h/y6iNU
QDjx6UFUDqU95jp9Yt8mVEAIw+ypTPehPXjEN0PILFRAcFa8Pd6flj1BCZWz
vC9UQMC/ZmmjC489Ck7yI7EyVEAgItSAdUeAPW4xmpnINVRAAAAAAAAAAAB3
bQK/
              "]], LineBox[CompressedData["
1:eJw9VXs0lXkXPkU3hpNLVDpSRhpFmUKMvdoy5yipkPf3nkTpKJki1yJCjm+o
hCTJbWp8kpAIU4wiconjct73CKOYKFPKRGm6KL7zrfWtb6+11/7jWc+zn7We
tddeJvJzPjCTw+EEy/u/s0s9XHPyLIWc/9URyzl8jyQKi3TnNnxtCoFHaW0K
BakUHnd20+WYpUKui2s05FAYGU4Ji02uQ0/MXQ/RVQovXfuwuOlmESiX6WFc
PoUvbEZ5LmolEKj211RnMYWvYrbbK/uVgU170In9v1OotKTHduJRJfTbJYTE
yyjUeWi5crCkDtRDxkhJN4Uegdlmd1zrgZ+307zrDwodp1rJzhkPoEhx8Xvd
pxTm+1xKGf2xAcLv5wXeGqVQT0Sttc1rguKxec7dYxSWPz22gDVvhsGlvqZf
3lH46+WTZ50eNIN95Lox/mcKk2N2vzF59BAW/lDr2zub4PzC1PtfulrB4ZD+
tql5BJP69vqd3y6BqPTY1foqBN2vrjHGBxIY/uDwykeDoHLZ32kf89qgvLzX
m6NHsOGok+cR+w54MWS92UCfoK3pzRaqqAN0NK4Y2q8gWDym7VEzqxPEAV7D
KasJ3vNyUery6AQnk3eehpYEbVr82idnS6FloH2JljXBl85+TRVGUtiUXNCl
uJGg+LV4oeM2Kayf2Gc3+CPBQ3vKjE2SpFB0FThSO4Kh1eaGx4qlYEAvqqyx
J2hmkTmUJ5GCVlWnUbYjQYtEGbd1FgNJh4uG4ncSdB3jVtTpMTCXdyorjBBs
DvsUV2jFwKeojapCN4LfauYu23WYgUBTnSbBXoKv8lt5y8UMjAz+E2UmIng5
4MitZ2kMPOYXj6t7E0woeMvdW8sA9eF0wYzDBC9esVLVYRlozz/gOeYr3/+o
hdv7jAGBq82SAX+CzolkTeZ7BmqUeV1tQQT7lZPjPGexsOHux4TqYwTrko3X
rddkoeSITFB4nGCfaMCBu5yFHGn8nVNRBCPf7jAbtWJBJ+ZgQIiYIGt+1HKC
z8KF9bZGXj8TVGFOaKk6svDNsO6QyymCGnMW/2W9i4Wf0z5n2sYTlC3kNIr3
sTC1+ZHL94lyf/aDbU+9WTj2uVRlWTJB/f6gRW5+LLwpTGjkXiAYp+1d/y6Y
BW/3n6KmLhLcYhk4XHCchaeq/A2j6QRdYvnZMREsuNbqjfdlETxnkzrz5EkW
mIAv11suy/O8oWmaI2Zhq36PqDKHoJ1qiO3rGBasY5NkF/MJVv5WGsn5Fwsm
LwWC4GKC65wHTrfJ+dcylk+LSgm6iUyvTMn19RymbjuVE1T4mG61P4yFS197
/fE2wQVEEsQ5xoLazYrv1lQRDKkJ9+ryZ+GMR/Ig764cD9lt/PwQCzPVfTO/
qSX4pEZ3yHQ/C+H1m10m6wiWPg7NuevGwkTwtyojDQQj5vNiz7iw4LuC09jT
THDVL/fyM7ayMNzdF9nUSjC/eb7BmA0Le07ftvitXa7HNC5IsGCh2yplLFdK
8MZ0SmrQahYcXx+5niIjOOv8qpqreiw0Z9uLxN0EuyR4w0CebxVnpmzvE4K+
dqU22p8Y+P7Wk7Pb/yTIVQniJYwwUOhZyYch+X3FRq3c1cdAVqP/7cUvCRrn
8C2+VDEQdXYgo2tCnkfLMv3rgQzk+dhWKXwkmOW2Z5ObOwMSh2u9ppMEk8el
N3bbMbBQxW9h4gwaDUBsYL+IgVsJU6kCVRojuYp311ZIocdXVBGsRqPv4fei
5AwpTG1rlOVo0njp64G2nVFS2KqaqDG9mMaD/S8K59pJ4VkiL/m2IY2dgsDy
iI5OUPKLLnluROOOea7/tijpBNMdzzs0TGj81Wxeh/e5Tojk3lD1X09jyfOn
l37Y0Qna56zPrrSh0bDkrfnjhA6wT94dl+5KYwBxmFtr0wb+ATV5Te5yvn5U
2uUJCVx00m9870HjnJR90fV5EhhSe6XofJDGr/ERT0bnSuDE+TCxUrDcn6Py
DM+GFriZkh4RnkBjke8WfrR+M2he7A5yr6Xxd6cC1Muog5Mfy3yoehozzZSS
xvl18Mr13IFtjTRqrrtfUT5+H+qWbqFBQuPhIE2F5Vvug//1KiteD42csoEq
g7EaaK3OnvHkDY3DPuP6G8urwHxp2GfZWxqv1Kvnr1etgpxo8k7ynsYzCwZT
0r0rIVTAfV49SeOyX+zPyXTvwIrOk81Zc4T4sl+cpXC+AsRDnkluS4VYp5Wg
OJJRAn/z8ZTLciEqzl5U2zd9E3blL4l2MBBilldQeW9rMaz17Qq0XiXE3Jyq
tVM/FUH/PwKyxEKIAr56KFN7DSyVjHiPtwuxYlNt/J8d2ZDrM1tL5iTEnQdX
amuXZcL8jkFViYsQd1cLPnlnpcNwSian2lWIcfVXQ0eiU+ECT+VZppcQtY52
P/TZEA8bBhzuTZ8Q/v9f/geW419n
              "]], LineBox[CompressedData["
1:eJw9l3k0lV/Ux6kMqciQChnSYApJUWxtiVRIA3Gfe5/nISKpKBHKUCjzfZAo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              "]]},
            Annotation[#, "Charting`Private`Tag$7301#3"]& ], 
           TagBox[
            {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
             LineBox[CompressedData["
1:eJwVlWk41AsDxXHdXGTPEsIYM9ZhbFHkf5S5JIQsFymFsuZOi+JmSdZokiVk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              "]]},
            Annotation[#, "Charting`Private`Tag$7301#4"]& ], 
           TagBox[
            {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
             Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxF1nc8Vt8fAPBIhaRIsrLJ3nvdj/F4HjMjO6QoRXaIZGRkZpY9orL3fIqM
SjKKREZKSaIUWSn87n1+31f9c+/r/Tr3fs7nnPM59x6uM+4mTuS7du26i16w
e535n9VvFT1qw/3Z3/yqQ1Wjn9qNGifcRyhCzR3TfXmRxPGwQPaEJqQ+lImZ
nksLWRQo2xNT2oEonL/WkEEwR1JnUvspErqRsO4RylPBZxGl/GtpwZ79iPOR
VCH8ziXkh2i9WFDpIJLqXh39DncZ6dpfkqyUPYycfKnQxRR1Fbn1JWdtPX4U
8fql2+xyKgy50J1s3RA8jij2SFTUzUUiKnej2rw83yKaRJPxTx9jkRvqanTp
ku8R1iH8/m9FiYhntUKXb+k0Mj1c6XgqNgWx5pC+bMbzESGeizoUWHgL0UoQ
PS6TPYP4uVDX31vIQI66cscuxX9GzvV/XuW4no/smmBTfbn3C1J3nbxxt8sd
ZF7n6PfK4Hnkfm7fL5xzEfLwOI2pq+c3RMhEtmA4vxipWQqI9y5dQvZ+Gsmi
26lG+AX9Zz+cW0bUWZvfmWjUIpmnLyMmPD8RDkPp5NaEOiT8hfuSRPYKwmQy
Zluo0YhYVDiaLcavI/pfpsfDGR4ifTMOlba6G8ibvb9+PsttRYDNfl//3l+I
3NaFvgbJR4hQrFVLWfAm8sZeQapdoQP542x47ILnFoIuXE1c+WPEM1/P943o
NrIpqHrbOfUJMjtKeIGf30YKjIMoykOeIs6FBZAiuQuuxiudjzj3DDGmz172
LCWDwAXckpdzH0JTyZJXQkkOSTM8ly/79CNPdTL0ps+Rw7MM70vCEQOIUuit
IiOe3eC8wBviZf0S4f2RaC6eTQHV5IZrsfeHkPX+COLX+H3g1D6VZ9I2ijgi
1Ap0K/sgJMRd/MLVN8hQdUKDrDUlpP28yv9RdQypTLldfY2fCsQlvkgp9I4j
jlYl9w49oobfbY+3fh2aQoaei/LK8u2Hn5dNCx8uTCGgUltgFbsfvM+zaVg9
f4ewcjzIvmNBA+qpJw/W9LxHhmb6kmV+HIC8SL4GQtkHBMyND1mZ08Lvi276
uwQ/IpXdr+ODHtLCQH8o/ULxRyS6dOrG0xsH4cAuxvyQqhmEU8EfKU88BLvo
nfW73swio1vRsmqC9HBxd1csxd0FJEFO38foFD28NbOpea37FdFyp607c5Me
lrNC7WN+fkVq3ydLRK3SAx3laOWgwSKS0JUl/LLjMGR9o/O+l/IDwf2xvfhh
5TA4t482jiz/QP7IcJasHGcA9ZUVqSrTJeTivSJ+5gQGUOj0cfZlWUZw0RVc
Z6yPgH4uB4dM60/kT4f7aZ/4I7DvXWVRoNAKUrspmRfZfgS8q86Sl2asIJyu
jWxl/Ixwu9EA9zZoFflj+OjoyjIjxH1JEk21W0fqGAYPRMYygaL5hGFg9G/k
oSfrjOwDJrBj9md7f/AP8njAifhpngksk2KCvdP/ICM3Ns/hdJnBJ63VR7d6
C9n4w9NOQcUC+Kwmk/bfOwiZtdutegUW4HvRvt9IdxdQNzW7OjqzQFmZb/bW
7V3A6mnA/LibBcREP1/nlycDtU++XtcjWSH9801OXAQ54DU6CNKNrLD0YqZU
fpIcjPL2c3z8xApSO9dupsjsBger/F4NHBsI6TVu5X7ZDeH9PbzkFMdAm5yC
WOm0B543sI2GhLIDLph5yaqMEoboz1dI1LBDcFqt/TgrFUy411x//54dLu65
YyWWQAVfBbUlADjAxv2Rp7s/NRzMdY/e2eaAaJddCVKONBC3NVllcZQThG/7
LwnN0MAhEfIscXFOCMt7JiB/7gAwR+t7vrPjhNNOjF0VHrQgpDl9DGnjBCt1
JoF9Roeg0nMv1dERThg5XBTzIv0QSOcLryx+4wQ8R/G5px8OgcrW5ee5x7hg
kHG3pmkAHRg0UfttX+UCaYtpdv9mevAQlnnZqswN/vnzGaWXj8CUPH7nmCk3
xBxgFt0cPAIGWtZi1y5yw/K3iecd4owgZBsSp5bBDRNsuOOD3xnhU0If4dEa
N+zOFKDIDWOCk1nv/DhoecB3SHjEeoEJOu8v3wvm44GVw7pGnWbMkN/OtAdO
8gAZjfOVcnEWsF527Giv4YGhC4HZtRus8Gzb7wdnDw+sx6u9u+HOBvL7YzlC
3/PA0QlVec05NmDgrQlSP8gLpvkGtNffHYMBsy3FTlde+MV8ZJR2lgM0W9Jq
u47zgfyck+5pUW6ofVI8zYPwgZBIq+bUFW7gHHpwKNycD+yDV16mdHPD9vy0
m1YEH1gmhsS2nOOBZjYx4Scf+KD25aJ5cD0v8AuqW/Nt8gHDoxIpnf18kCZ7
MjqCjh/2U/cm+pzlAy/DgM844IehOvy5vUz8IBLytPBpDj+8LZ8uakk+Dplx
Y0P8Dfwg1//smNTqcaDK+EoW1ccPlfdTy5StBGC2hv40/jc/KBkXFbDyC0LB
Rzu2Z5bHwaGvj+nZKyFgxK+n9hwWAEFld8X1cDFYfqa3wSsqABRGkYGJtOLQ
r5tvE6ItAF+qXx2KyRSHcEMdbvkrAhDrIywxc0oCls2yqoqmBKBNxD7POFYS
Bka/0+/aEICfImVt8uOSUGKl5WtDJwh3fimVBghJwWnbbyr0WoJgdY36sPgL
Keh3RJ4HlwjCGNkVFzIhGSieTRGd6BSED/uKPa6Gy0C481yi3KQg1BdcvRT1
XgaUXJMsvtEKQf6eILoLObJQ7P1xxtpHCAbdOud4hOUhPCxqRxYRBgHyg0+E
cpTgNMXkmSRLYTgredRFgEEZlCMlnn71FIYA3zNkMvHKsBw9FldYJAx7a9X8
MiJU4HSSMAsdtQgYp3Ddv5uoBiqHQ4JceUQgd5VyjpkZgaNpw++7VUSAZdNI
7UshAgPpQfevuYuAwtfCQIfTACr5L2S+DovAxp2OZkKcOjBx86bjF0UgYFl6
K2JcHX4W+v++s08Ufh+epDgmpAGl97k6rZREQeDThqlHvwYwVXmf6M4TBe5V
QpQVnxb8bD168c5FMaDoJW/Z4cDDhrFEhn6YGJhOBTKvBePhzyfCs7UMMVCU
U/npN40HCtoAfr0eMVgPYc+VLyEAo93kh5/HxeFlhI+nvb4usCyv0OUi4kAx
Kxd7oUUX2CMPqBMsxIE5cmhFRkAPjleq5WVHikOIn+QDkf36oLCdb4P7JA4p
gonPPD8bgEpyS8z3P+JQ05WkZ3HWEDgPf5nUp5aAh8GzWsrThsB3n4xmnUsC
JDJ8Ezg+ngCxF1IX9YwlgC90dZhnlzEgHGn8K1US0Kia/nzb1BQ0LnCp9TyQ
gKT4fa4bhaagVVdhltstAT7RK57Kq6ZAwD8NJ7yTAL8aq4XarJNg5L7+IZtW
EurlxYTIfpmBScv1TU8WSdChtlmaMjWHk7sP0eP5JUHpx4UZqWpzsLotoL6k
Kgl/yLw8zC5ZwJlHVnm4S5LAXk4bKb1pCY5Us40sVyTh19FLLh4OVnDO1Gvg
e7gkbGrwmZs/twKXzzFbGdmSUCNmlK9QYA0+Bx/aLPZKQmj/Fvkxx1MQYc/O
dButa4Lf8TOB3KdBzbG354K8FNwZihh4cPE0rDn7B6poScFJ+bg7avWnwdlr
aGraVgrW3Nx/c+k5gG5E5F2RJCkQiJTIJI8+A+Qx0hY7OVIQWx1etjFxBh4k
vKccKpWCr8XRHaclzoJIupKr32O0P3vzb/lvzwJt2aJU57oUNCSW8mTrOsHT
qqyZVAppWAk++mWyxAmC6wm3ztNJwyrvtsVT6nPwo/XOLxphaRhksl2oHjwH
r16at1vYSUNWwBW9Bz7OkL7WZvDtsTScS3Tk6GN0BaPfLjuPBqVhdEKxwyLV
Fah2MdckT0nDzHe5dHqGSxBA5c2gsCENcyxz+SosbmDLdnwiTFgGLDwWWNW4
PICRazjOTEEG6JOnl/UveMAAX6iaAE4GTr+wjciu9QAQnyjot5OBWd5NYQYd
T+DWuOnMlCwDx5izR/dGesG4tgrLQq4MSMW3Wz984wUpel96W8tkQKL+Y/20
iDdQmGmKn30iA3mLezLSxrzh8/n11YoNGTAhv/zQGncZyuPtr2vay4Kvzari
dVd/sA7dbTHuIgveFuKeHqP+QHn5vpCnvyy4d8lWiWtdgbOnvg/mJslCB4d/
gyZPALAIB3NudsmCksfLvfc3AuEZO89K4ku0nfbSUUrvq+BL3919/K0scB2/
thj0/SoM/qJ1N1uTBYK222rvYhDcQA+91QJy0JIoL/h7dwjIPdRIwsvKwfYH
1sZduiEwUzXrOKUuB8858FVySSGA3BajobGRg5gXbCkEnlBYc2qzPh8vB/5C
Jvnp5mHguHtq/diyHPRGvjGc2A4H+vXQ3vptOZA/S7UYbB0B7fN8eXr75WHx
st9gTVMEsA5d0r7CKw8+YWwLo76RMJS/lTpsLg8r0pftFilvQEhqgbPLWXl4
ysgw89DzBojdwKmQe8iDlz7TpNHkDYh2j/8oHo22m/QEfG6MBlA7JhX7QB4O
PMs4XxoWC4uSHXu4n8lDFZXhwLXNWMjmcxprHpYHha68EEufONBlpqo4MS0P
vp2DHPAjDtZpKkJmv8mDqdzds2pu8VC0y/hk0KY8GOmMKp2nSgCTFfT0uE8B
PlSKBPW9S4Jdc+m/Sw8rwCuCVnJ94i2onFB5oc6pAH7Tc+u3FjLh1Iv3d96I
KEBnIwWtwkYuUHWF+7orKsAzL4WVHrsCaGwU0N2rrQC1UyuFvzgLwbG071iO
iQLc7+SRCn5SBPS5HkvS9gpgIKjxdtbwHrQnMTx57qIAnx8PRlx9dB9Yr5xy
3QhXAGfK/TvadqUwdfnD3cZEBShqt6s8eLUM8r2c3/lkK0BSb/ZBx5hy4HX1
MVmqUwD+kjbxY0GVMOu8GVv1SAHYRtk/BZytgmKnkCeXehWgf1DfR5SjGkTs
4xTmPyjABfwrRev5ali0ofcqXlQAydTW7aeEGqi2TC87t6kAR3t7/Ufu1ICs
SRH7RzpFaE9fTF3WrYUNQyHLgmOKAO0Dg4EZtUDUq06yF1SEwSqznYKZWlDD
PaSYBEXwLB0vi/Wsg10aGmqZ+opw/HvvWnFdHXSqPfOztFQEpjwe/6M/6wCv
MDw/7K4I676HmK5crAdqWWvelEBFoPRIlqu8Uw99ku9tjaMUgVZVfKf5TT0Y
CX992Z+rCC83BYofqDUAvYAXdVypIjguxtF/cmuAYd4NTd1GRYi62XADn9MA
luwUTU/7FeH0evsS1WoDONCx5Tz6owhqRmJSocmNwEt7ZySIUgleF1DNX2ls
hFlqgUMqDEqQ67onQnqsES5SyFxvFlaCGKt8AhtrE4iQER/6yivBCpWe/Fml
JljcQtZkNJXAkjazItOyCbzW9S7UWCtBRGeHLUVyE8isDN5xP6cEwTu933Qq
mmDth8WkqJcSuI/Pdd7rboLA+bMnSqOVQHJXCdOzX00Q/jZQtrBZCaoMAiZD
TzaD9jiZu8NjJbh1R2ef7YVmoByNKuZ4qQQGlEFITFAzxL9MYc3+rAQ3MhXL
lgubwaif2cz6pxL8kqqWUGxsBvrneQlMO0pgHtZ6aa67GW51lZGlMSqDibSU
VdqXZrBsl1Q25VaGCPn5muxfzcDS2uRDJ6YMBYkZrJxULZDb2PU5HqcMUxxH
Ysv5W+B+yUR/pI8yqIsmsBicagFOh7ACjVBlCE07erPiQgukMwle3kbPOY8C
OCtu+7ZATJQvm+99ZWA0mHJlvtkC5MixH5L1ytAmh/vRnNkCgWtdXd/alSE+
te/j0t0WcHWic3EaV4aFC1dN1B60wAxbsxrXZ2Xw3vp4y/JJC9gO29G//akM
zlvR75lftIChZnnLyQMqQGkm1Z0z3QISXHhKLVABN/q69k1yIhS/+Taxo68C
KycaP+RQE4ErMbXqgZUKiO0szW3REYF+Z9pc2lsFZjdODm5xECG28YbQ92AV
IKp2HL3DTwQKN/Ht0jgV2MkIo6ERJcLq5NW73PdUYL3kw7qCIhHcUnmuTNWq
gOyj6tYdNSLM6j3Xz3ykAj+FwwdTtIjwhnh0hW5MBdpTN/qEThCBmF6rQUaj
Cr4puWLqZ4ggZWTF2MqkCvoPHFbzzhGhbN+ueX8+VcDd5nd+c5EI2b4GST/U
VIElayRqwosIR8RWHMv1VOHtGG19sS8REj5lKjhbqsKDtJKYkwFECD459+6d
pypMuT9/pB9KhI39N+uyrqlCPO8DnaxwInh0yUZZxKrC/Z9Rr/uiiHBG6rrY
iyJVcHwrNDMZTwStQ+xBbaOqcI5DNuN5OhEedj82CphRhaxJOkm9LCLIBrvw
yi2pQvLXmLGGHCLwLzb3VlCrgXH9mrn+HSLk3bXPu3BUDZznFTOuFBGByXav
Nx+vGjD3P3qaco8IVH2mLDmqahDRfTkwqZQIYdc3v1nqqkEdFwf4lhNhU6mg
g8FCDag9H7roVhLha8mic5yHGkw/fqfQVUOEgajopsBCNVi9LOu4p5kINgT6
JbsqNZgyntU81UKEOcosIY0HalB246lQMZGInm/KcyhfqUGiLI03ZysRburK
ji5MqcFCQmKwQRsR2Pa3HXoxrwaTE1TzHo+IIBf34noaOQKv9zyny+4gQpe+
Zas/LQKmUledijqJYHRges2GBYE5k3HNoi4iXExYvsAthUCl/5O62Cfo+BOP
GFU5IEC/GuK6q4cIIsa50cmXEDATfinVh5pId7zr8hUEOO9+8056ToThZAU5
lSQEynJOKVH1EcHBtMOdIweBFlkXvoeoFw/rlpCXIPBY9Iv5hX4iUKbZsPW0
o/1nyePrBoiQZjZjVt6HAPobsDd6QQRuxks3b75BgFkmxmMOtcrta+TmPxBY
e7qPm3qQCM19Rj5LBwHcx8p+HH1FhG2RI3QfjwBURgvSJKHGxY9VDLMCDA/k
4PcOE2HI4MznpuMA+3u1sj+hZqrkDy8RBcjds3/5xGsi2NMucGZJA/S5Pn7f
iPrrgLf1NQRgZuTKesAIWt/iCuvuOAA9np6Tb1BfufknxUEPwIjnUoPUKBH2
GkX0a1kAbHz/8H4KNdfgLdjvDkCdFH766BgRnCVt3v7xAdDPKLC2R12ZxBGw
GIDmQ8W07y5qFZPiusFIADlm8k7BcbSeal2NuuIA1qv8V5xR99BLfqtPBvjq
iHDdQ23+qoU/PReAbDGsjGUC3V/S17qiiwDKZeIETFB/TNE4HVgKEBi0/10U
ao+TvRl2jQDRK0JSi6hjXk/S8A0AHE0tXLg/SQS9imzixiuAtz7pU4OoaSJO
OfeNAbzbvB2yiTpBZrLL+xPAUGzeb/xbIpygyfbEL6D5CAzPuaI+NGPDwboE
cKvlXEUi6pSUiYDOPwALdrnTw6hPumQJ3CJXh6A2srOrqBk1bUYuUKrD0SuE
dwxTREhfHpekY1CHr992fzFCnW08PmcvjHpmgrENta1g5i1pSXX4xvhVexQ1
O5m11j55dTi47175d9T51WN5lRrqEAbGUuzv0Pq7kWEQRlAHv/s2djKouU9b
/TYzVAeGfP03OqiLDo6Zb1mpw8NJqj4v1E6f0ykG7dVhwyLYKBI1/yPL2iIn
dThzXUQhA3Wx25sD+p7q8ESyUasVdUX/6OPMG+qQ/75/aBu1293bXm4J6qCe
4LV84D0RJIIsODVS1eHSp6x0NtS1IqOBX/LUYfx3epQCam+K24Ktd9VBe7h2
FIdaZtJ8NLFMHVJmxx+aoG6MHZFSaFIHfpEyUxfUfmdvvd/fqg6RV5r3+6FW
UDZPeNepDji1Qqcw1MT5118iB9TB9nc3dTrqNp3X+a8/qYNBqOX5R6iDudIM
SxbUocZ7z9VnqOHXyT9Xl9ShkaEdP4i6s3jYgndLHfreXj7wAfX1kNQ9G+Qa
UFvVv38etZblybpeSg14yPmjZwl1975hWm8GDdgvmRS/a5oIN96lPNRm0QCn
P59v7UOt22R6kYVTAwY8m8/Tou479+pJh7AGXJMYOseK+uWToauHNDVANo2f
Shr1180762d0NKA6NnVJATWlhLdXwwkN6HG5dU8NtXrmYWfrUxpgt6YVpIPa
7sXHD+VnNIAuXfOOIeoAinrbHWcNKFQLzDRFXet20rTosgZ4VOdS26IeKOQd
WAvUAMHvbhEOqBferBB0wjSgnlt9zAk1r2aa2mKCBoj7i9G5oU47OiKoUKwB
JgdvzFzF4unfK4qp1IDrS2y6IVi8UF+Ot/UaUPeKM/k66r1fGY+EdWjAjXWv
/mjU3Fyfbw53a0Bla0lnHGrEvIn6+IAGWL3iyr2J2r/dYlffuAbk2xruT0Od
uno8kH1aA0L9ynNvo64W2lj1+KwBCT55rJmov6SmLxxZ0YDFEZ3XuaitL4yN
2B/QhLWPXjb3UfvmlhjXHtYEZzeXEyWok19d6aNg0YRkG0epMtS9qiydJfya
8L2goLsS9ZzXvMofEU0Y5NwJqEZNUUxsMpTWhBHOmxy1qFXobSp+IpowRqOt
1oDaEi8soK2tCRGBDi2NqC9f/X0nXV8TstUyjjejrpzNSle10oQkX5Z3RNQc
DyavR3lpAgdF+5NHWLwf5dtj/ppQLCH3qR2Lxxd0RSRYE1ZUZzc7UCfePOY+
GKsJW2k46seoyx9/+8KTrAmC7rconqDu+dXq6JuuCdoFjmuYyR3trFnvakKb
bW5HN2r2DLHXl8o0oa/6VtYz1EoD2yfaazTh1RSfWw9qb4U8nFObJjzwoNx+
jnqG5r1E1agm4CzOvehHHaNdYJf2VhNuV/VeGEAtGXImLvAj2h6ks4P52s+Z
z/jvmkAfLcr2EqsX0XtHxFY1oSHlXSHm3nPnNRl+awKPscbxQdRM419y3+/V
gtjkIq4h1G2Hy/qe0mgBv8rndMxOBq6b5fRasCp8muYVVl/ti2ZX2LVA9oPb
HGaD+z9p6OW0oPsnj/9r1Cvv65U2lLVA30FjGHMmi6/zlLoW7KX0ER3B1jN+
o6vUQAsY2dxHMSd0tywlmqLx7jsJjKKWJQvk8LPSAj37Hl/MYT5bAZpOWuAb
J0rzBrVAZVuxoIsWHFk1M8X84nPwyEFP9Pls5XTMbDbkUpNXtaCCJ4p1DHWj
+r4vPqlaUGKym3oc9anAZ4w2mVowWP4LMO9uiNZSz9eCx2ySvpiNBGjyD5Rr
wR6znAnMaw79/T9rtEBZamH/BOqcrITfY01asP90tRLmeVo6i3tdWiDp/SoF
cyJhKDyuRwtOexHaMMuHpdR6vdCCNbuznzGHrx6hRSa0wDqkWXYSq4dJliej
y+j8D+5+jPnxkcnl1g0tuDHSP4PZ5UQOZ9G2Fow7JlK8Rd3cyXHVgxoHoccY
1DHb/XlfYn4IBz3NM7aY98jdGVVhxAHX0d4rmE1KeKWpuHHo/tiqxLzx4dPp
78dxoHHP5BnmPLb7Ca9FcZDXNPIe89ebgvMFijgwfJx6cAp1lK9YgZIxDqZG
fR0x3ziwKzvPAgc/k+5dwRxTNHiLwg4Hcic4EzAnDPnEDVzEwbfgxXrMiRe0
o6Q9cXDG3qIbc/IuprB0PxzEz/CMYU4Te+B3JhwHe0vfbWK+9STOqzsGB5lH
xqjfoU4/ZXdJJAkHvXInWTBnx5CdXcvBgch2qTzmwlm8YUwTDn7RB7piLgpi
1vneioPsvYn+mO8xLGiefIwD7Xn3cMylGgmK7IM4EN+4mYm5fMxe5vooDk4w
0tzFXOkhKT73FgcVZeJVmGtyh3lr53Gg892tE3Ot7D2Oo0s4YD6Q14u5vs+P
5eo6DtLqEoYxN2+yHNKm0Ia8VflPmB+ZO/weO6YNP8Vddr9H3f5Nak2NVxuu
XrWlxtwZTrFUKKQNNCvSdJif1t6fvSSvDe7UL45hfqZzZXpIVRsceTJ4MD9/
rzspr6UNu4iugpj7aRcHyYy1wcNIRwbzwN1HfecstMEzfl4R80uVpO5eW21Q
7GlUwzx8UaY17aI24I4YEzCPkO1t3vTQhkOR1/Uxv0kfrbX3Q9+XrzHGPPE0
oFgwXBum/jRYYZ601S9MiNGGpN93bDFPrRzL/ZmoDYZd5A6YP3B3pLTmaIN5
qpwz5pmW5ATuIjS/tydcMc8aOUZHlWpD5t5gd8xzn2XDv1Zrw9tAcy/MX67t
CzZu0oaxo2K+mOePjF1pbNWGlQ9O/pi/lpf6sD7WhpyzHYGYf4wbXPz0UhvW
yCJCMC97cjjpjmpD++3Z65hXKJfsq95qw8MspkjM63KpZlfmtSEo7UsMZh+c
g0P7D23g/XgonhTPVOzSvnVtkPQ3vEnKz+NZeNpuPOREK6VgdgxOS5ykwkPq
XoE0zNPxZ7J5DuEhJl/mNma7bPHii4x4YDjZkI55vPRPXQ0bHug3aLMwm7f0
PNrgxsPSE/pszEPdt3oRQTxkg3gOZsORs6OR4niYE1jJw9w7I/GxXxaPfqs2
8jE/ZHeinzfEQ0sm+z3MCqJS7JJmeDBOa7iPuV55R9DfBn2eZr0Yc4Vlhvpe
Zzx4xXmUYRY6f87AwA0PDeR55ZjvXZa2SvXBwx7VhxWYc5P7PbhD8fAqpa0K
M0tB5tULUXhIDmqqxny76vyN6ng8hHrdq8Gc2EeWr5aJh2+vXOowh+6Ve2Fd
hwfrV/cbMW8z7J4oaMFDxLRjE+YAnpezc4/wwB/J2ozZCy5u+/bhITDctwXz
oqE8ddsQHmjwrETMLrYUjHvG8BB8hUiyY0CuaMonPBR9nXuA+f0NF8XxBTw8
vuH/EPOp2wo4rmU8hOvtbsVsVj90qmobDwEL1G2YtRf3xvUeJYDE8Owj0v77
8+o2PTsBKL+btmNW219QaMVLAGubVpLlBZQffJYgQElRRAdpfuUou8XkCSDY
NkOyBO710GVVAvDcgU7MAmfc53frEkBY9jvJRR4qa7pGBChi1ujCzBVMRZ5s
ToA3kskks2QXMnOeJcCEjdBjzPtHRgkqVwmgSKv6BDP9l7R9R8MI4DDhRzLT
H9OnS1EEGO+vJpmf+6Xm/RQ0H7tjTzGLyCaQh2Wg42E2JlmaoN9xKo8AeKnr
JIPbMzX6MgIY1H8gWTs0cutrNQFuyR3qxmyQqvWwu5EAnjoqJFsT2xWDOgnA
dCKRZJ+9LTJzYwRAqASfkdaT2e9n5zsCfFHXJzlURLY25xM6v3ZuJCeY1Iib
LhEg0KmK5FQn90XRdQL0OgyQnOUvWkG5RYCvZ7+SXJxbItRGqQPqGXw9mCtr
zn9Jp9WBwgkgueExX7E3gw7MqduQ3DlfwCfIqQPbafEkT8plcqbK64A53ReS
P+hYvnNT1QFpoW2Sv5xizNXR1IG6dPrnmNfCkll3DHVAI06R5D9pRuNjJ3Ug
i1Wf5N0ltBn11jrAdMSO5EMvYhgvntOBKKsQkhk/EF5ruepAYEUiycdW96Zy
eOlAWlA+yUKs1+leB+nAvsI2knHnA2kgTQd+uK2SrB+g2MuSpQO/6Mh7MZvE
r0ev5qM2pCX5dJ33vrJyHZgq5CP53FPJpxG1OjDZIUHypbHv4aebdYAhUpnk
gB0XcsbHOlBOY0RyCL1Qx48eHTg3bEVyFN9ccO8LHRA0OEtyqp7jVsiEDozZ
XCa58vapjYVlHXAUu0XyIUrhcNwvHVBzyCXZy//XwbwdNJ7+PZJlrW4dN6HR
hetmDSTf6nGsK6PXBSr/hyRvKEoje5h1QfhUF8kPWV6aN/PpwoTnS5LZY3M/
0Inowtn7I//P97erm4uULpTemyRZc5Iqkh3RhU6qOZKf52g2hFvqwnbSH5IT
rr3vk3fShZSXe/owG9sHzcx76oK2By3JDMDyJ+eaLvQGMpL8hrPpsHGsLtBu
HSM5m+ykMEU62v8WL8n2H35oNBXpwqkIYZJnC4W8jrXpgoy+PMmXnBwLro/q
wsdYdZJX+HNffvmhC3x+uiQHzo3unKDWA3klE5LJS+nEG3n0gPDbkuRDohHx
YeZ64PHrLMns1RsLhtF6MKLvSvLU9vdR7jk9eDroS3KuweeuNW19KGEI6vv/
/2Wq6vldfRgfCCH52MLrrFwKA3i69zrJFDIvj3AOGcANpQiS568+v1mQZwiG
S/83d4O0oNOFE+AlEklyha+hQyqzEXDC/33J5rBtjZ8RuGv/36LwxnLgtREE
E/7v/M07fG+UjcFZ5/8+3HBpebrAGCb/s1AzYZGfzAR26/7f6g945l1OmwDD
fyaTa1wdbDUBgf/cUU0gU2A1Bd7/LEM2/TYmxBTo/vN94yvEt59MYf9/bpvn
euqidRJo/vPr688Hf905CbT/OX/Zv9KHygwO/ueLDsdjv7ub/X1/Ch/vFzts
BpT/2Vjs59njiuaw7z87214I3r71z8Fx7zJfr/wzw61Rb9t2C6D6z2Efz948
xWEJ1P/5h8SPUptrln/727cmPRI48c/sD/zIshWs/nrOrGOrOOef635QbzaQ
W/+NxzXsyLd9+p9vNrUZaT/65yHBazrVsTZ/fUrULj9R99RfK3BWMNbtsf1r
a/dxbkmXfw5s2yde9dL273jAHHfRWdzur/csht3lSvjntWdUbZds7P86u2dn
M4j+9F87rFNrh3j889gm6xn3kX/+nF8eRbHX4a9XtVUrMmQd/ubzprjEGnH8
ZyI1I+Wn5H/2tdjDHvrkn6WKVqSPbTj8nT844jptfvzMXxtGfkxINP9n5z0q
WoTYM3/r53p46q+dR//8P9+meD0=
              "]]},
            Annotation[#, "Charting`Private`Tag$7301#5"]& ], 
           TagBox[
            {Hue[0.91, 1, 1], AbsoluteThickness[1.6], Opacity[1.], 
             Dashing[{0.05, 0.03}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQvTnsz9e3a0/aMYBAwXSH8LUpoe96v9vD+N/Ptu56
08vuAONvFrnI29YtAecXaJtc2GutBOeLuX+fclJYA87/vFc8a1GWHpzfGi8n
MV3LCM5f0xvf7BxvCudLV8bk/GixgPOXr7x9tq3EGs4/1965vXqxHZzfdfUO
j+o5Bzj/wtFLNQLOTnD+E54HBuuvO8P57WV6C60CXeH872ZTQitfucH53Neu
e9jUeMD566bH/Hj9yRPOl9vw47VfpzecL/v66ux5LL5w/quaU/0L5/vB+WvL
/BKnSAbA+boONyLOXUXwhbfmfnq4MBDOd9yt/Co7IQjOP7jBg9FCOhgRHoGV
u+4+RfCvNp+6+HNRCJyflaje/T4/FM4P1PucrG4ZBufX99yfdfULgi8y7Xpx
7IFwOP+DwYdV0XURCP/uLmecYxEJ52/+wPVrK1MUnN+/fV+A234E/5JmneeG
7mg4P0Y3bsEErxg430Jhrdhm1lg4v3ofu/76Cwg+67umpYp9cXD+txOc+3Kj
4+H8OSf//6oVSoDzE79zuTUUIPg3f0kn5V9D8L+62a6daZoI5+/iEuN4OgnB
N1ryxVj2B4Lv1/a4b0JYEpyfwWrj4tGN4De3TPn5fz+CDwDDagXs
              "]]},
            Annotation[#, "Charting`Private`Tag$7301#6"]& ]}, {}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{
          FormBox["\"Day\"", TraditionalForm], 
          FormBox["\"People & ICU capacity\\n\"", TraditionalForm]},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImagePadding->All,
        ImageSize->450,
        LabelStyle->{FontSize -> 13},
        Method->{
         "DefaultBoundaryStyle" -> Automatic, 
          "DefaultGraphicsInteraction" -> {
           "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
            "Effects" -> {
             "Highlight" -> {"ratio" -> 2}, 
              "HighlightPoint" -> {"ratio" -> 2}, 
              "Droplines" -> {
               "freeformCursorMode" -> True, 
                "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
          "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
          None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& )}},
        PlotLabel->None,
        PlotRange->{{0., 149.99999693877552`}, {0, 10000}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {0, 0}},
        Ticks->{Automatic, Automatic}], Scaled[{0.5, 0.5}], Center, 
       Scaled[{1, 1}]], InsetBox[
       TemplateBox[{
        "\"Susceptible\"", "\"Exposed\"", "\"Infectious\"", "\"Cleared\"", 
         "\"Deceased\"", "\"ICU capacity\""},
        "LineLegend",
        DisplayFunction->(FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.007000000000000006] -> 
                    Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Hue[0.59, 1, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Hue[0.59, 1, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.007000000000000006] -> 
                    Baseline)], #2}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.007000000000000006] -> 
                    Baseline)], #3}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.007000000000000006] -> 
                    Baseline)], #4}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Dashing[{Small, Small}], 
                    GrayLevel[0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Dashing[{Small, Small}], 
                    GrayLevel[0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.007000000000000006] -> 
                    Baseline)], #5}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Dashing[{0.45, 0.27}], 
                    Hue[0.91, 1, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Dashing[{0.45, 0.27}], 
                    Hue[0.91, 1, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.007000000000000006] -> 
                    Baseline)], #6}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
               GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}},
                AutoDelete -> False, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
              "Grid"], Alignment -> Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontSize -> 13, FontFamily -> "Arial"}, Background -> Automatic, 
           StripOnInput -> False], TraditionalForm]& ),
        Editable->True,
        InterpretationFunction:>(RowBox[{"LineLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0., 0.6666666666666666, 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    Hue[0.59, 1, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> Hue[0.59, 1., 0.6666666666666667], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"Hue", "[", 
                    RowBox[{"0.59`", ",", "1", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    Hue[0.59, 1, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    Hue[0.59, 1, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                   "]"}], ",", 
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0.05`", ",", "0.03`"}], "}"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    Hue[0.91, 1, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> Hue[0.91, 1., 0.6666666666666667], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"Hue", "[", 
                    RowBox[{"0.91`", ",", "1", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    Hue[0.91, 1, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    Hue[0.91, 1, 1], Editable -> False, Selectable -> 
                    False]}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6}], 
               "}"}], ",", 
             RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
             RowBox[{"LabelStyle", "\[Rule]", 
               RowBox[{"{", 
                 RowBox[{"FontSize", "\[Rule]", "13"}], "}"}]}], ",", 
             RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
       Scaled[{1, 0.3}], ImageScaled[{0.3, 0}],
       BaseStyle->{FontSize -> Larger},
       FormatType->StandardForm]},
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     Axes->False,
     AxesLabel->{
       FormBox["\"Day\"", TraditionalForm], 
       FormBox["\"People & ICU capacity\\n\"", TraditionalForm]},
     AxesOrigin->{0, 0},
     DisplayFunction->Identity,
     Frame->False,
     FrameLabel->{{None, None}, {None, None}},
     FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
     ImagePadding->All,
     ImageSize->450,
     LabelStyle->{FontSize -> 13},
     Method->{
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}},
     PlotLabel->None,
     PlotRange->Automatic,
     PlotRangeClipping->False,
     PlotRangePadding->{{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}},
     Ticks->{Automatic, Automatic}],
    TraditionalForm],
   InterpretTemplate[Legended[
     Graphics[{{{{}, {}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Hue[0.59, 1, 1]], 
           Line[CompressedData["
1:eJwdlXk41I0ChZHSIjKIrGMwdkYpkvyOEGPf19JU2qQ0Ci22LCFLQorEFFmG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            "]], 
           Line[CompressedData["
1:eJwlmmk8Fc73x5GQnaJCtqgsiRSKO3O4tsvFvcgSEl872ZdCCS1KWbJE9kKR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            "]], 
           Line[CompressedData["
1:eJxTTMoPSmViYGBQBmIQ7Whls9TgeLADAxR02QYzd54JdihI7f+6VWWGLR+D
xazN54Mdduh9T5iftch24iEZw3uXgh0ayu5+umyzwlaklfEEx7VgB4Pst43z
utfaznB/Fmd8M9jhwLcz+Zd0NtrKcJ3+Gnsn2EHj7aq8YyGbbRecWd/TcR9o
PoeX2j+7rbYq/VOUNz8KduDYkVx/5s022+WBlbvuPg12+JC1MaklfodtwbRr
WpdeBDvMmGF8NKx1p63FbePZx14D5eWljryr3GXLqDCRe/c7oH2ZP0/H2+22
PZXyrnr9x2CHE3dTPfde3m07aaX3m8Vfgh0cnnxeIWW9xzb63YqYGd+DHTqe
mod3l+6xVTFmO9vzC6je89gBpZY9tm/Kk20b/wY7WFQaB31J32O7dc+BtaUM
IQ4cd4QrhJX22NYxysllMYc4ONz6PW/y5t22bm7VfXFsIQ4dd+qNO2R32/J3
3/gXxAnke5ksYkncZXvjvGm+O0+Iw4GeteEy9TttF4hMvm/NH+KwgrvhwKOK
HbaZkR/8DYRCHE7oOXhm+2+3NZrne0BFNMRhR1xT3Enmbba/H60ykJQAqme+
nSMwfYvtEXWOhbzSQPnWew+CuTbbhm481PhNIcThQ2t+hLXWelu5b/KfXimH
ODDMydk5NXa17TOr2qT7aiEOBuuTvFoil9tWHDF3PqET4vBAcNfBovS5to6c
Uzfv0Qfqf5RqOFtnii2X3yfljUYhDgvipkxx1Wi1rTOYNfOEaQg8fQAA7Lb9
Vg==
            "]], 
           Line[CompressedData["
1:eJw9VXs01fkeJYUeGI9rCHklpUaihuJTH4Vk5H2+v5NSIip5dyZdugwVcjzy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            "]], 
           Line[CompressedData["
1:eJw9mHs01F3Ux0kuyUOhVMotlVwjxYPNLhJFpSTm8pvfyCUqKeJRlJRELs0w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            "]]}, "Charting`Private`Tag$7301#2"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            RGBColor[0, 0, 1]], 
           Line[CompressedData["
1:eJwVkHc41YsDxiW7ri17HRw7Kqs61/fNqIz88svIKTOUiA46Utfe4aDMZISI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            "]], 
           Line[CompressedData["
1:eJwlmnc0F97/x4mQkVEqFBEqqUhGeN/7sjfvt2wyijIyQpL5ySrKnlmRkV1W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            "]], 
           Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAUjk8pTDHU0AAAAAAAAAAAIo9UwOJ
zFNAMHIfyKSTkj0OADias89TQJBxYHUsV5w9kcIcMd7SU0CIQfhAM6aiPRSF
AcgI1lNASN4OALO7pj2YR+ZeM9lTQIgaGwEfbqo9HArL9V3cU0Co/kPNgL+t
PaDMr4yI31NAMErY9vBYsD0kj5Qjs+JTQPTyw/Wlo7E9p1F5ut3lU0Akfvgn
5MCyPXCW1irS6FNAnNeBrPeisz042zObxutTQMiK7X4qX7Q9ASCRC7vuU0DM
096KUPa0Pcpk7nuv8VNAkO34uz1ptT2SqUvso/RTQDwT3/3FuLU9W+6oXJj3
U0CEgDQ8veW1PSQzBs2M+lNAgHCcYvfwtT3sd2M9gf1TQKAeulxI27U9tbzA
rXUAVEAExjAWhKW1PX4BHh5qA1RAQKKjen5QtT1GRnuOXgZUQKDutXUL3bQ9
D4vY/lIJVEBM5grz/ku0PdjPNW9HDFRAlMRF3iyesz2gFJPfOw9UQDTFCSNp
1LI9aVnwTzASVED0Ivqsh++xPTKeTcAkFVRATBm6Z1zwsD374qowGRhUQIjH
2X12r689xCcIoQ0bVEAYe2s88EytPVWxwoH2IFRAkBktR7f6pz0e9h/y6iNU
QDjx6UFUDqU95jp9Yt8mVEAIw+ypTPehPXjEN0PILFRAcFa8Pd6flj1BCZWz
vC9UQMC/ZmmjC489Ck7yI7EyVEAgItSAdUeAPW4xmpnINVRAAAAAAAAAAAB3
bQK/
            "]], 
           Line[CompressedData["
1:eJw9VXs0lXkXPkU3hpNLVDpSRhpFmUKMvdoy5yipkPf3nkTpKJki1yJCjm+o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            "]], 
           Line[CompressedData["
1:eJw9l3k0lV/Ux6kMqciQChnSYApJUWxtiVRIA3Gfe5/nISKpKBHKUCjzfZAo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            "]]}, "Charting`Private`Tag$7301#3"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            RGBColor[0, 1, 0]], 
           Line[CompressedData["
1:eJwVlWk41AsDxXHdXGTPEsIYM9ZhbFHkf5S5JIQsFymFsuZOi+JmSdZokiVk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            "]]}, "Charting`Private`Tag$7301#4"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Dashing[{Small, Small}], 
            GrayLevel[0]], 
           Line[CompressedData["
1:eJxF1nc8Vt8fAPBIhaRIsrLJ3nvdj/F4HjMjO6QoRXaIZGRkZpY9orL3fIqM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            "]]}, "Charting`Private`Tag$7301#5"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            Dashing[{0.05, 0.03}], 
            Hue[0.91, 1, 1]], 
           Line[CompressedData["
1:eJxTTMoPSmViYGAwAWIQvTnsz9e3a0/aMYBAwXSH8LUpoe96v9vD+N/Ptu56
08vuAONvFrnI29YtAecXaJtc2GutBOeLuX+fclJYA87/vFc8a1GWHpzfGi8n
MV3LCM5f0xvf7BxvCudLV8bk/GixgPOXr7x9tq3EGs4/1965vXqxHZzfdfUO
j+o5Bzj/wtFLNQLOTnD+E54HBuuvO8P57WV6C60CXeH872ZTQitfucH53Neu
e9jUeMD566bH/Hj9yRPOl9vw47VfpzecL/v66ux5LL5w/quaU/0L5/vB+WvL
/BKnSAbA+boONyLOXUXwhbfmfnq4MBDOd9yt/Co7IQjOP7jBg9FCOhgRHoGV
u+4+RfCvNp+6+HNRCJyflaje/T4/FM4P1PucrG4ZBufX99yfdfULgi8y7Xpx
7IFwOP+DwYdV0XURCP/uLmecYxEJ52/+wPVrK1MUnN+/fV+A234E/5JmneeG
7mg4P0Y3bsEErxg430Jhrdhm1lg4v3ofu/76Cwg+67umpYp9cXD+txOc+3Kj
4+H8OSf//6oVSoDzE79zuTUUIPg3f0kn5V9D8L+62a6daZoI5+/iEuN4OgnB
N1ryxVj2B4Lv1/a4b0JYEpyfwWrj4tGN4De3TPn5fz+CDwDDagXs
            "]]}, "Charting`Private`Tag$7301#6"]}}, {}}, {
      DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
       AxesOrigin -> {0, 0}, 
       FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
       GridLines -> {None, None}, DisplayFunction -> Identity, 
       PlotRangePadding -> {{
          Scaled[0.02], 
          Scaled[0.02]}, {0, 0}}, PlotRangeClipping -> True, ImagePadding -> 
       All, DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
       Axes -> {True, True}, AxesLabel -> {"Day", "People & ICU capacity\n"}, 
       AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
       Frame -> {{False, False}, {False, False}}, 
       FrameLabel -> {{None, None}, {None, None}}, 
       FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
       GridLines -> {None, None}, GridLinesStyle -> Directive[
         GrayLevel[0.5, 0.4]], ImageSize -> 450, 
       LabelStyle -> {FontSize -> 13}, 
       Method -> {
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}}, 
       PlotRange -> {{0., 149.99999693877552`}, {0, 10000}}, 
       PlotRangeClipping -> True, PlotRangePadding -> {{
          Scaled[0.02], 
          Scaled[0.02]}, {Automatic, Automatic}}, 
       Ticks -> {Automatic, Automatic}}], 
     Placed[
      Unevaluated[
       LineLegend[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 1, 1]], 
         Directive[
          Opacity[1.], 
          AbsoluteThickness[1.6], 
          Hue[0.59, 1, 1]], 
         Directive[
          Opacity[1.], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 0, 1]], 
         Directive[
          Opacity[1.], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 1, 0]], 
         Directive[
          Opacity[1.], 
          AbsoluteThickness[1.6], 
          Dashing[{Small, Small}], 
          GrayLevel[0]], 
         Directive[
          Opacity[1.], 
          AbsoluteThickness[1.6], 
          Dashing[{0.05, 0.03}], 
          Hue[0.91, 1, 1]]}, {
        "Susceptible", "Exposed", "Infectious", "Cleared", "Deceased", 
         "ICU capacity"}, LegendMarkers -> None, 
        LabelStyle -> {FontSize -> 13}, LegendLayout -> "Column"]], {{
       1, 0.3}, {0.3, 0}}, Identity]]& ],
   AutoDelete->True,
   Editable->True,
   SelectWithContents->False,
   Selectable->True], TraditionalForm]], "Output",
 CellLabel->"Out[24]=",ExpressionUUID->"1257993d-55df-462a-8715-4b074e3376e3"],

Cell["\<\
However, let us focus on the lower ranges. To the left of the intervention, \
the plotted lines overlap. At the intervention and some few days after it, we \
see a surge of clearings and deaths. With \[Gamma] changing from 1/10 to 2, \
the model presumes that there is an acceleration in acquittals indeed.\
\>", "Text",ExpressionUUID->"449b964b-547f-47c3-a41c-cae152bcf2e5"],

Cell[BoxData[
 FormBox[
  TagBox[
   FormBox[
    GraphicsBox[{InsetBox[
       GraphicsBox[{{{{{}, {}, 
            TagBox[
             {RGBColor[0, 1, 1], AbsoluteThickness[1.6], Opacity[1.], 
              Dashing[{0, Small, Small, Small}], LineBox[CompressedData["
1:eJwd13c4le8bAHArKyVCJSTSl4zsGc8te++9j3OOvUcilMooWZGMikglqyIR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               "]]},
             Annotation[#, "Charting`Private`Tag$385807#1"]& ], 
            TagBox[
             {Hue[0.59, 1, 1], AbsoluteThickness[1.6], Opacity[1.], 
              Dashing[{0, Small, Small, Small}], LineBox[CompressedData["
1:eJwVV3c4l+8XtrMimQlZFUL27H2eY++9Nx9771WS9TUayMoMoSmUWUkZSYOQ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               "]]},
             Annotation[#, "Charting`Private`Tag$385807#2"]& ], 
            TagBox[
             {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
              Dashing[{0, Small, Small, Small}], LineBox[CompressedData["
1:eJwVVnc0EG4XtmUrkmSv7L3lfa+99957byl7C6mEqIyMFJL8JCuEUEmlkh1S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               "]]},
             Annotation[#, "Charting`Private`Tag$385807#3"]& ], 
            TagBox[
             {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
              Dashing[{0, Small, Small, Small}], LineBox[CompressedData["
1:eJwd13k4VO8XAHAUQlGylX0NIftu3mNN9n1fxoyxZy+SFImUkBASylJfoU3K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               "]]},
             Annotation[#, "Charting`Private`Tag$385807#4"]& ], 
            TagBox[
             {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
              Dashing[{0, Small, Small, Small}], LineBox[CompressedData["
1:eJwd13c0198fB3Drq1CUlZWtyEi28L4vI3vv7eNjZpMksyTbB0Uls0QSUkYL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               "]]},
             Annotation[#, "Charting`Private`Tag$385807#5"]& ], 
            TagBox[
             {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
              Dashing[{0, Small, Small, Small}], LineBox[CompressedData["
1:eJwl13c81d8bAPBQVETK+soe2bI397Fl7z2vPbKJhhJZRVZJhBYSTSsZhbKK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               "]]},
             Annotation[#, "Charting`Private`Tag$385807#6"]& ], 
            TagBox[
             {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
              Dashing[{0.005, 0.005}], LineBox[CompressedData["
1:eJwVV3c4EF4XtiKSkRFCZtl7j3uPmb333ntTGcnMqqyoRKIhRMNWSKhQKcre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               "]]},
             
             Annotation[#, 
              "Charting`Private`Tag$385807#7"]& ]}, {}}, {{{}, {}, 
            TagBox[
             {RGBColor[0, 1, 1], AbsoluteThickness[1.6], Opacity[1.], 
              LineBox[CompressedData["
1:eJxF1nc81d//AHBbKCNlZ11k73Wt9+vea2RFpaGoEBEVUmSk+ihpERqkooQo
SSSzMkKDyF4pI/ttZ+Z33p/P98df9/F83Md5v87rvM55nSPhfHKnKwMdHZ0f
PR0d8Ts8uWRl6tZoNDd9ZXJqBcd8n57VME56jeXnGo4SDuAYdRNMKsP2Zg53
EtYx3pIT5fMVe+i5t4JwUEkKHVPSd8yhTzmZcFubUSoW0YJx1HEEEdb702Qd
5NOJBWeftiD8NUInsF3xJ5b3pmcj4eW7/1jPJ/ZgKw4lDZPIiim14vyb+7GF
icNRhB1yhKc1IwYwlV9CpoSLvr2O9/YZxSykuhInkEe6Vo7f7MOxT0t2poRv
zj4Vb1KcwOJY3/ePI5cwTU5NJU5hzbQFAcJNHPc6GdqnMcea5XQceWyjUSXP
5llMyemQLmFRiavxKhFz2A664yZjyNqyqmFGZfPY71cyFaPI21WajlsvL2Af
PfcD4RBDSYqnzzLmzCclN4Ica1wlH5jxFzO99/zOMPJzyxObIvpWsOzc2JUh
Ip5i56nvivTw0M2qbJCIpy9nNpHICKxPHLh/I6cbLRXOGTIBKXV2Tz8Rn1qr
StfOBCPnre71EfHNTwtxbWaBr/V57L3I5/Z+GFWMWAfjSxwZ3cjsB2KdNWXY
4KEAV/kP5DsHjzbrl7HBE+t3TV3Ima4bPlgss8N5zbCBDuTOU/ax7j4bQPhb
x9sWZHd/RTZvTk5QtomMb0aeDlwJ8c/ghAreML8m5PUXnx693McF9ltcuBuI
+VcFbKlX5IHyG/0/a5B7zX817w7iAZX+5NCvRD6fLaNbq3lg3qWV9wuRT60o
60+3jXAj56FoNZFPU/k4nsgLYX7r3pQih/5wtOec5YWkH5Ft75GzBmY/KFpu
AidjnYkSZJ5F2RiPmU2QWWgyVYDcIHZDq8ecD8652RplIzPLyTykf8QH39Pb
fr8k4qm/YxGf5oOlXeOhL5DvGk80OzzkhzPYq7NpyPs9dgc2TQqAzo/dYQ+Q
r/mO/Zo2EwTpAvGYeGK/BYVb8j4QhFDP6Wt3kbfczBexNROC8x0S5FvI3dlb
3lXfFwZ7Zt8T/xDzK3qzdWBcGA6wnS8IRaZW2ESxmIqA0pXBoSDk5OYLTrRx
EYjJjpw5hXx0qY+x2FgUHvDzxjsj32MO9WqPE4Xab5wTjshVnAKN82OiMDkM
0vbI8hIWKdpxYlAjqy5hg/xHcq9Uyxlx6L09v42MHJX6ZN/RJHHwHLnqqYEs
qzh+ffazODxvtXNWQt6nFTGzSUICXvOcqBRHLjAr/LjjswQ0rYs2Z0be+YV1
sXtGAppLGAaW/+LYsK2dire4JGRdO2Aziyyyf/TuzdOSEDNu5duPHOIl5vFZ
jATnGdVay5D5Jjwf7LcgQaOKRmQBcubpt3WDfiSQ/tS9koXcdW6H3rpPJOhb
FGR7gAy3/uEw8ZOCwuikcz7IlV18RgwJUsDuvXTHDXm7Yrr3uzIpmFLwcjmA
7Fj5rZHMKw0c3nrcxsiBy1sSlbOlod9XPpgHmd7yVf1wqzSUryfNMSJfuWfM
/IxeBjbsY+abXUb11/A8RtohA7zX9ZRakXM83moKjMvA6NSOkHhk/TzLo438
W8E95k9RBHIp04+4aGwrjHQyXglArnvEvLI+civ4r7v52g55rHFnNb2yLOzw
lGJgRT5N6l8s2S0LHSetsMklHFvyPqscHCILrZJ/hjuQOdYnxsx+kQXKNHNY
FrIsddRx2FMONu8DPVvkl5Hno9Ji5ODxe49QbWTtTt4y10I5IHdc4RFBNgnQ
k+1ml4dxEi9b3yKOOWeGTzY8k4c3sVk5x5EHF4Wko+vkIauxpM4a2ds8c6/N
vDzEzM1yKyGH9jYUVW9TgLrdyZ0DCziWICQZXvJbAViMa5fskEnuuflBXIpQ
byR8Vgk5PXfbiK6OIjzwuvWLCTnf9uSO15cV4cDo9MGsedRPLxcJp0krwUVq
pdj8HI4dbLDZ7mqtBN+tB2WrkPskes5LnlaC2LY7nbeRp4vY+hPKleBA1FEp
JWSeqT1Zt1yUIZ7ZcrPFH9RPHCXswq8qw8ZLEQ85kRUrh/8Ev1IGeeHs6LpZ
HNt2/zzmvqIMPr4+UTuRz9HSa4zuq0BdkshjbAbHrr/w89UsVYHCLHqT2Wkc
i+PH+OQHVcAsxmE6HbltZjDzqrAqYJb8NE7k2epzs6c9VIHS9pevcBLdR39d
qsaDVSGkBu4cRmbSNI/3jFKFxBOJLxiReR7yGjnlqYLMDwYX6gSan2/aJStm
NYhJSWNMxHFMI/XG3koBNfhezuisiqzX4StHVVSDoMNQXTyG5m9q+FVnlxqc
GA1xqh3FMReh+k2kJDWYlE048nkYx47Z5PU/yFGDmv38+RRk77CEtwJVauA1
quKWM4TyHXNz4MTVQOpsu9vNQRyLL118Mm+gDlKB8VIbf+NY0p/u03626nCm
m8PVvR/H0hQ/muEu6uAxHCJdgO7J3DtRw71X1eHp5ukMm14c+3ZMWuNbizrk
XrO3wH7iWPMjdmbLEXUQaX/KfqIbndcGvKliRR3czIrg7g903xoVBBbKaMAK
o2ZASyeOsfLalKb4acDG3DulPG04xrlNM1biigaUB7X0cbXi2KYQQbeE+xog
EmGgy9qCY5K/e9iiSzXgM9v77O5GHDMqDNgRwq0JbjfgNbkOx8TrB2seSmtC
e+/9ku5adJ4H91u919OEI3jwQEgNjpXzGZoxumqCJuz2j/uMYxa+9IYR+Zow
J9OsYF2B6hHhW5BeownFj/l6EspwbENij86XHk2wB2tK9weU79cKdS5OLZga
P3QdSnBsj9xV2dvOWtDkrM3k+AbHdGHx6Rt/LTjD3pWO5eCY4F4vUst1LfjE
vTywMRvHOsK2iwrnaYFhqtLJiBfo/HVv3JTEoQ3txRmNz57gmPGff26VimvD
JebuYKYkHJPmnOHs1dKGmnLWScuHODag38y29bA2JA8PSj66h2Mn795feZ6j
DU38/I2m13HMNnN9SE21NkhApf7cFRxTrwhZwLu0Yedg18dbl9B+nTw0o86m
A+fuX0oLPIdjwdulht866oDdgy5D7pPo/Lnedm/z1YEG+UeX8WM4hgWz9C+G
68DhuXiDV244xpA+0G2UrQMtXusLWxzRff3e/uDhSh2QE8lpN7DHsYrmT+0X
OnTgrGi40Hk7HEsZ07d/MqEDvGW9shdtUD9lftFUzqILJnrp5mqWaL+KiNr1
C+uCIFy9oLANxyw1IutY1XRhN9UhNtQE1cOCzkbOVBc0M0ke4jS0P5x8vlgc
0AUN2ydsjBQcG/f/Ze7lrQtWEptNRDHUX2/uqrxxSRcCMxVcjhniWPbTcuOX
8bpw19u+t1sfva+KtEq/vdSFGZWt1sF6OHbmewo2Wa4LCa9SFnTIOLZ3iL+Y
t00XOFn3/uXSRfWkj9DTwnWB9ZYxHb0OjgkJLOTtYSLDhgQTmXXaqD8re2oF
CJKh9ZDniqQWeg+ZdGTHKZMh/Oucr40mjiWeKnnRsY8M/DwfFJvUcWx+bKf8
bS8yODBeOaqLvPPY7xTr82RwdjPuTlbDsYy+IBJLLBk+OUwVCiEzOXEnlqSS
gS/fTDdOFd1fHcki/oVk4D5MThNDfrOXHKdSS4bcSUGfFyro/bXdOTpxlgwK
P7HxDmUc+1A9y2nPrge85RffhiALmVy7xiOqB/tsnBdIyF/0c8IumujBZUpD
SKgS2m952+j17fVgYLOkiCbyOfXOkCkvPTjBWzo8oohjqnIs/kdi9aDmcLHw
MeSI5PgpkTQ9sP98i0UZ+ZeYindjoR5wl7/SnlFA6823z8O0Rw+irsumXkce
vTXS93dWDxgXsiMdkE03XHDOY9cH9yOHNqggzzGmH5BV1wdnbSntdnkc2xFq
1NJtog/i078e5CCnL9Tbxdnrw7r1ebxRyA4Ti9bsF/RhzEvurRVyrlfUp9JY
fdggoZythMw5IGUWlKYP62PbbLmR33VZw0itPryQ/CTZJodjAvt/FSX36EM7
Y4jiB2TvxjNkxz/6MJdzM/wZsuSXR+o1ogagJPp5KAQ5yEzz5WV1A3in8aPO
A7mhtEoBMzWA5FDWqj3Il/MnpLKOG8AgqS1NA/mH5uUk9wsG0OO/4SwJWTdL
SFTitgF0TdmSNiEPpdD4o4sMoHg6suWPLI7RJFtiLL4ZwIty25oh5IQHXtyM
vQYQ+eP+qS7k7bG32fw4DMHOxCKtEjmVS/6yopghOAQ/lClGprtWwtCnbggr
kjvUXyNnX/i9uHu/IQhq+DYkInMsBwVwnjCE17u2Ot5DPhLAPfPxgiE8+1K8
NwqZ7yR5TOeZIeicGrp6Afnk0Ndj40WG0LjP720gcpWr8++0b4ZwKLWE4occ
6HCtW3AOxcu/aueO/L1ZzLGewwjyc2UanZEVd+W0XhUzgsdNWY8ckbvMO+sX
TY1gIpXMaIe8MXV5Yb+DEeRtadG1QTZlEiUV+BgBj5RojgXyi5KDpwISjMDx
JosXFblbOPR+8ysjkDvhnmSEvOnsozLtSiNIDBjaoI8crNHNOzNhBMelZkM1
kbOi6AzsWDGof1IaqobcMyp+5LUIBpfoVDOUkS3SnHJ8zDBIxbcGySGfY77Y
8c0Bg60tW4W3Euvn/JhJ1ReDYZuXnVLIglt67MYSMJgxiisVR7YKZAyxzsbg
e6zLT1Hk882kp88rMYhlvyi8BXng1pGZY5MYSMcmtAsi3/Qv5exjBLh59P1B
AWTZlPrHsZwAXxwu/eFDPsA49WmKBOCcIeS6CXlajfHQE2UAn5fpOrzE+MO8
UzvJANaS9sIbkUuLNYSztwPQDetv5EZ2GKG9dLIHiBdOI3EhzwrZ0XiOAOyq
T6RyIssH+Hl6nwXYKK2Ssh65PCVsRSwMgJZzYJAD+WBjbEztTYC/IRQdwtHq
uYXKycgLdeNsRD2dKmy6MgGuTR48QPhjZGPPjXyArxnuNeuQ50dmOEZrAM5+
5fjCSowXZklMaAWw5SrbTVjRgk/TqhcgY0GtnwX5cKq2Q8Y8QOPrXEHCC42m
4/uZKNB9gb+IGTmWaW8YOxcFWBw/uRCucvJ/7iFFgRDvyQ9MyM5R4SCoQoFn
y63+hJdK7jZUkSlAq5hVI6wi8nZpqw0FMqu6XjES4y2qoprtKdDVQ/Yn7Hy2
RSr8CAW47gxihO80zVn1n6VAf114GwOyKjPbz9thFLiXsOU54U8agqdNIikw
pb7nPOG/UeQHyckUuJEioEr43jtzNbuXFGgxdeAgrD5mX8FYQAHPxdwBemRX
y8BR51oKfGDVfEZYnNLyoLuVAtfTk68T7tDW3n6wlwIkuRc+hHdKTmbaz1PA
aUkBCHMK2B5qZqSifhogR7h6QybXbk4qHLdi20QY5j28bUlUWGbJGqEj1mOs
UrxGiQqdNclthPN6pessdamQZ3y/mrDyt59qZtZUkLtil054qAL7Vb6XCq6T
S/cJPy18EE11pkKaku9NwiKp9lOG/lSIY7lzmnBLQt6TwgtU+JiucoxwTPRm
O/J1KpgKex0izH6uLkcziQpnIp9ZEv54SsU1O4MK8DuOSviCx43Nqm+ocOEp
hx7hOTvzMwqfqVDasUeecI5FqsyzRioc2UwiET4JzM0y3VSIl90jQrhf4YOO
5AwVqIZtXISTJMQGHq1QweaNODthB/6Qe1vYaaAy/paJ8HcG8ryAGA3Cnn1Z
WNmKztPcnWd35GhQVI3NErYYm7bfpEkDct/UBOH3rVkFXOY06PvAPUQ4uJbT
88YuGpxv9+0nrFPhJcxxkAYZ99f1EM7Mkg1mOUUD5+yyDsLHUi4rhoXQoKmk
p5WwdEJvB/0VGhi2KjYTTghPNFxOoIGLilo94X0hf0cDU2nQrj1QS5j3lMPD
uVc0kOh+95Xw1YMCK1MfaSA6VF1NmN6i4RDeToO7I5SPhAO0ot4PjdPAaEG4
jDAubiXRz2wMg97W7wm7rV938aeQMaQ2fikmbNcTSmsxNgaRS7H5hCkFf5hq
TxjDcgP5DeGFeb8wgWJj+PUi+xXhHPIkozOHCXi5vMskfPzsyX8y7E2gEfv+
nLBM/gjDTKoJ5MdEZxC+p/ub/oqxKVQGkdMJc7z9SSf80xQq/qQ8I3y/ITYv
Q3MbJBZY/muFCbMTBlfMYfKc4b9W363Gb1hhAXZ2+v9aL1/ovSGDFXhP6v1r
P/riSXqyNZj+/M8vzQ9Jfzy5HaS7/nPsy3fcM+9tILLzPxezc//libCFM/+z
e3dpq2vWmje9OZ2b37xmL6d2LyeZHeD3Pwu9TWnPKluz5D+LPgUCu1Z9UJ0t
Ovyo3ap55KyTyx/tXvVJQ5uTXpN7Vm0cF64Yprxv1eUbzz1muWS/an9vpcdW
jftXnbSZN5aBy2Ht/5Y3RiQXx7Xxv6LaXyceXPt+HYlhXcuhVb89UeDdE3t4
1REC51oD1Z1WrVqX+NCsc83ji49kZ8OcV+1lUZDhIOGy6uJUjWtzn9b8SbbK
xcrjyKonhMn0F5lcVz26hW1x5Pman9KmR7ks3FatHmBk6D695qBvTy4FxBxd
dWd8X/QxFfdVb/a7vHSrZc1sPtRDPmc8Vl0f7Ch6WeLYqnMX7B4HV695V8JR
MQU3z1VXWrXOcXJ7rXpW3O1zeuaasaO1zrIWx9fqXXR3T/vkmnW1gmimUSfW
5sN2RIQ0sOa2DquZFdTF/t//B5HcScQ=
               "]]},
             Annotation[#, "Charting`Private`Tag$387352#1"]& ], 
            TagBox[
             {Hue[0.59, 1, 1], AbsoluteThickness[1.6], Opacity[1.], 
              LineBox[CompressedData["
1:eJwVV2c41v8XRkYiKytkE7L3eL6f77F5bBHK+NmJrKyEoiIUshqUGaWijBSS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               "]]},
             Annotation[#, "Charting`Private`Tag$387352#2"]& ], 
            TagBox[
             {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
              LineBox[CompressedData["
1:eJwVl3c41t8bx22JyMiIbLKyt+fzObc9Hh47lGRky4rMjERUylekMkJGSKQk
HiMjJCHJKMpKshIZJfn1++ec633d9zmv+33u6zrXOUKuAVbuVBQUFCH/hv/P
i2t/TA083uMfTxfRVvO/wIKLI5T0Cp6g2bEk/b+nc/BwxmUPnoJ2JLqS503Q
q8DV9I48TQt6g2pczz2uePQEj2ouoaApeIfka3tbj5nW4x8+4KUoZRTxenM6
Vl5uxjW3hs2igiZQsmeTS8CzVnw3K8HsV/4MUsq9HFMu24nLlPQLch2aQ7+z
X9obYN2441Pen8op8+hbNAvxlWIP3jjw5G5g0DKyCXwm9/PzG7yZZm19PX8d
GROr+RcMB/FhxtsTVB9/ohO3cqWfsr3DV9jwLtZDm+jb9ddVHz+8w/mFrtyV
S9lG2nHrjWb/fF7AhLV9g3ZRj15rZl7UKM6vJWn4I58aeH1LmyQYP+Pl+B/y
NkYD3Qsexp3Ln3FVnX55io804CVwlJzqM4mTjEMPsxyig0Wq4R+xDlN4jF3r
skzKPsh6mr/t5zCD7z+Z4aoszgB5O6QXalMz+C0nzxGtdgZoeO2v6+w3iz9y
P9Bqsrsf9o8PXNBP/YJPnHPI8Ao6APpi05Qdf77iXmEyDIHMzPD58O0nk4Xz
+M/IvQthFcxwlPKG+nGzbzjTxWLPpC8scHrohPtA1QLO3x1+ZFCGFTb+NO+2
P1rGZ42nR2yjWEH51Ei1R9QKXv6amD72ihUKW5SfRZt9x1X7+emnPNigmqXH
yTx+FScNd6x+z2eH9oTP83dOrOGxn085MG+yQ5nf9d/1M2t49fxmqwyRA97Z
dfUOB67jrDsSN703OOAPe8f32Kyf+JBAqsqMMSfw0o7Hsh7ewmklxfMo73GC
/NaI/83OLVxVsYVO8Ccn0Dv+OMgXvo1n6f0YcczjgsIp+8NjC7/wE962kcNr
3MAwxpDgwb6LXw1emf5pyAN3us0Vo5Z28caoy0T2XB54JuJOOfv6L37kej2f
heFhgDVZXXVzCjRZc6TlVTYvpF+0ZtglUiHWxmdH51d54WTL18HMISqk89I8
jc6AD3wUI7SkXKhR0Ui8i+4qH5y80UpuSqJBnn++UDfp8cOFCV3RffT06DZt
rN/HO/ygX/x1arWGHnUzc7//tcIPn1N8Po277UNSQiYlqncE4D7zITvb9wxo
S9hOdPS8IEhbyoWJ7zChtNL79p4FgqAUfUgp7t0BJCGzem3ztSCE+ZbNStQw
I3uVlA0OISHg7L/mn659EDUYkjstXwuBmAwTz30CG7Lqpd+Z3BCCT7k1g50d
bGjRwkYuUFAYCO6B5GkLdsR3YjnreqgwNM3qhEaGcqALfgLerwVEwDq2tidv
nRNx/vDNPWEiAsLsm+nreVzoUejzt99CRODR8t2jhubc6FOMpea+HhHAIyK+
xLXwIPgvgVE/RBRu8Rfcvj3Nh7o+ceJUOaIwVXHQmVxxBJFkygNb2kUh9Alr
zPFIfnSqa+C9BrsYOLqfTzbkEESRu0fyZWvEIGptVJw8J4QoiY8HF8fEQDuS
5qOzmzBKvq1HW0YpDlyLGSSfGWGUpeTrI2IpDq963wXRr4igp97PlblXxeFs
WleghLw40qojer7nOgrSqpaPi3vEURvN5zvp6Cj0lGYcP+59FL29R7vHdOMo
PFrkjO96IoFW3lu9opSVgEqNws+kOGkUKjK302wrAcc8XqR3IRn0JzBCNvqC
BCxxHlwNoTmGGJnyb272SkDQ0ruIvVxZJKGzfGrRVxLK1BhSaRgVUNWNuLQH
NyWhm2/fRnm8AlKdYG93J0vC1Asmlqs7Ckg/XFNicr8UXBLxfGj1SxG5Prq8
NlQmBS/m6l7fFVBB33YOi6W/lQK/I1QUJTUqKND4kZ35Lym4IC1pXm2simJn
hxpfGUnDZ0/Er3hJDeUcFr7c/FUaDsU9nhOV1UQiXrX1USwysMTdeMZpVhOV
1xotqavJAG+9dfTVe1qo3iLA8kmSDGS9I1IRxTA0nNTI+0DsGKRsn/aQ0wDk
NGROcjc7BqLchRJc5YC+CM3ECYceA9kEBe6D/NroZyPDXE7HMWCx0Ne9yqKD
WNePV//nJgvhHziMBHn1EP8pIZvLV2ShviLVFhXpIZmuxa3ox7LQWG7ymEZB
HxllxyGvPVmQYc3Sm7M1QDG65X14thxwBLaqz/UboWuVIcHKbXJwQehmE0eE
MbrDhTilvslBupvv5XZxE/Rh49ujK7zyYBItxnokjYg2X8VshnrLw+rooVjT
PBLa/evWvRotD3MGtHY0AeaIRtn4rm+aPFgE58YUCVsg1jx23KVOHvg/eigm
U1oimeAHiaa0CnBM5L3+zowVUipNteviVgDDxbysZ2eskeZ4sKSOjALoE+jK
JuatkZEB9kbNWgEqSrl9e3dskNvhQQ6RAgUY3b92eIJkh3zM6+ZynypAzf5c
hvvLdijwUs5z7m4FUBh+rZOfZo9iVjwcmb8rwJaarsOTGQd0t23n/i+CIhxg
SXW52uqICrYmQ0MsFOEyb1yFbeIp9ECm0/C7myK0nH0TZUlyQrW30hZnryhC
u6iPlO/qaTTgI6Y0MKoIKTUxc9mNLmjk3n5a4pIiMBAEdkxVXNGnoe/DL/cU
YcuYoUL+sStawhsiyeJKIN/bmjdX44bo2c3bSkKU4PfRYPFrk+6I2Ug5QyhZ
CZ6rvqo1C/VAHBd4PHKylYDv/K2Ovwc8kfDXGYb0NiUolDhccIfohXByuOWF
g8qQk99wr+23DxIc/NaXJ6YMndSsQ72tvojy2wnTF5rKcMjRTf7adT/UwYkZ
UrsrwxX6CO+3Gv7IJJgSS6lXhhW18JeiK4FIJiW4obxPGbrOvY+e9QlCB/Jn
1HpnlEH9nlOtymIQGnjzUpGFWQWyy7Tjfm4Go+OSVyQyXVXAPSr98gwWitRh
p/hZmAoEji1dkPoQinjs/ERGr6lA/1yU/FzkeTR+icTPW6cCZCvhPkJPGHKd
ZOMoYFSF7UR4yV8UifS2Ev5rE1SFl3etWJo9o5AY8wbzrIoqFNDO1y/KR6N5
rRGGo86qsLhP1+G/oQsoICt77+FTVSh7zP29ryYOWTxiutD3ShXchqpOCR6L
R4ovL/z+/kkVUs4+eDpXHo82105vKDKoQfenEnPlxxdRNEl08fkpNbg7GctS
sngJOblnen0IVgOmj/JlZy8lIhRNN7dzWQ2uKpRXxwolIcGbYW5HctWgtEdo
+1dbEqIqn5/Ea9TgqeNtzh2vy2j2hYOTc5ca2HL7BReyJ6OXIz0f48fV4LK5
nfDB9mRUsqLlcP+HGjzYrC75HpWCkmkrhzvo1OEi01Zw5bdk5MPHbzPHqw7f
s/2v7dtJRESlG2/pFdTh5LRMwLnIBCRjQmEuaaAOd49GNO3ZxiNml6Bek5Pq
8LWr8U/6bgxaDZs29gtUB3vt5OjpgSj09rp1V2qiOiS++/P2BGsEqinu0Ku6
qw5KK/kGE5XnUUajSttAlTrEe87tk7gdgs6/K0FrHepgGR88Yt8RjOwWuJrY
P6iDS4aKWKJEEFKnTNFU+f6vy3mkqO7wAHSY+3fdcRoNqH/A7npwzQ/9kfVV
CefRgI1vl8f0H/ugCf3xmjuyGmCbNshY8dALNTuayZN1NaBo3q2WZdwD5Z9r
rhy31wDitUSt6+ru6NeKlVSm3z/NuxyQOeSGrHy+lpjFaYC1b0tSz3VXVPEl
SoQuQwPMpx+zN7i5IBqXg/nNpRrgXnm4xM/CGZ0aL+ILI2uArrqXW2mRE3pm
p3FHrl8DalirV4P7HJEXyTU9f1MDBlgW38kmOqDWV5vMDvs1oSfUg2Ka0R4d
1r96lZVfE4aFK6k3Ko6jcy8E9vUoaEJGWIWHtJst6tV6eumivibEhAc5XJOz
QWJ1RpRaDpqQvo+BwYHFGsUoTlxY99OE8j66cBpKKyQvSRd2JkMTWBtrAzI4
LFBK0d11vgea0GCRZIN7kdC0gFzge7ImVD489CKr1RRlcNp7G8xowoOE6oY/
ZGO0/N/Sl7+bmhB+ta5r0sEIGRyId63brwX2Jv0i1YyGaJu6/KSEohbcXNZT
FSjRQ5ax+OikvhY4nWLnuXRNF5X/HrS546AFukzMZxwu6iDHHztm++O1wOeW
ny35NqBav7Setgwt4EijSTUIQIh5XtQw6oEWCLTyBjq9xFDLJzNY6tcCV+vu
we2nmoj7xHRj0YwWLNrZft0haqDA9+c1Tm1pQQNNZqrephoS7r2n2MdPgFmd
3/rn41RQlKFyVZIiAcra2Q4EOCmjobZuaWRAgAda5xN6iEooqf6HaPVZAtx+
mFfsbKmAPisnFXjFE8AvS/YJh5c8Uq8+zC+USQB7ezcTDU45tFCiy5XeSADF
eSUWvq/SSFd49KbJAAFGU1jjLwZIoZxcv4PUswSoawmurWWURKSMTIYQRgyy
pky7TkaJo1IWqSQZAQxSSlslP5uKIYqrzVRfFDFgeu1bSpIVRTXxX3dsT2Dg
GRopf++IMGLcjQpn9sfgiS2P0LqkEDoTfnCjMx77dyanarl0BRFngMaKWhkG
6X+Gn5krHkEBC298VhsxSBQ5t/mgjBd1u7t+fTCAwR7FwotilcMo0vHqJM82
Bn10khPoMhd6NyJwapARh/ldHalxE04kY/107IoADlmyJH9ugUPok/HE4I4B
DmV9DfK7G2yIrXT39wlHHKyf3AklTbMiAxp+kYYgHGSyGPqMPh1Elc1O58Jz
cOhyZnbxo2ZGk7yx2SOP/2lZYQsWcybEEXGvXbULh5lLZRpRT/ajaKVJ9o0f
OKy5NrkKttKj6jQKgg09goiz59c7POnQzLLgmSd8COiFcz7QCdMikwcuT4MM
ETQ3rS7s9lKhGNqL4wOOCGh82UgPyJT//pWFNPLBCKwKcqtH6ykQz5EZm5Uc
BNDI3F7YtoubRlJfMKtBoPtNjHKb9Q8eNyJS/LALwe8TLMWfI37j8/+d2fBZ
Q3BN/Jrjl9Qt/HpYG/MXaoBaalJhiNomLlEyWJjBDGBu9TXk/M+f+Enq9Z51
EYDWuvx354vW8J8K1KfvywKY7jUdC8j8gV93Zl+30gC4dit6/HXmKt7WpMRb
QwI4Ih6VH3txGXdc0q1ycQCYNab9FvF+Ed88bKPLegZAKpEt4C0s4FLhIb6B
EQC0fy/dEDn5Fe8oubQncAnA7eTYtwz6OdzpfcbN/usAmuRTH0lds3i6Yi1Z
tgig894CFTF6GpdxeWn+6RGANme619WAKbzzxvuZ1HqAvd7hDebgSfzX0gbj
ch/AE6Ptg990JvB0Xrr8nDGA1dJP7bF3PuIyJpzKprMANGc/aKF9H3DnUlXH
il8AXb454f0SI/jv9warJ2i04ZGVUQTf6Hs8g8bu0n4WbXgVcf1i8t0hvNsl
7KG3qDbkUB9MCLUZxF3TLgOPnDYU3FjY2jZ+i/9pzhrq1tAGGLR+nEcawOX4
nv85aq4N8vbhzz9Qv8G7TbrTRhy0oYiam53O6TXuGjEqevmMNtQ1OoqKD7zC
bw1vm85FaINw9jG2r5uduDwtw1TmJW34fU4+k6HsJd6jxBOqf0Mb8p9Hrwj5
d+B/0zRyi4q04UnIHeUNmTb8douxgk2VNiTU//76TLQVV1xxeEndoA33Lpfr
RUq/wN2Jkcuu/dqw43za2fplIy6oPZo7OaYNHOzAEipFxsdVVUlOs9rAbz6B
Xyypx62E1x45/NKG0g5KQZtPz3BmbovTI9Q60ETXs9aSVYu/OvCIxZZZB4Lu
B113c3uKwy/vQAsRHfhwwu2P+bEa/M9Kl2DfMR0oC3dXIUs+xutmxd4S1XWg
unYwqEC5GpcdmFIwNNOBCEfpYqcvD/GFl2i6w04HMkoCqp4ZVeDF5Nx0HVcd
iPHTaGdvL8P5Sh3WsTAd+Bs17tW7VYKP5tTdJ8frgBQja0xvVTF+M/2QjcY1
HejZSSrhjizC98e8fapcoAN4gMKt69qFeOc5OfeaCh2YuuVTPUoowOO9Uw/J
P9MB58r93ysN8vFtG+Pz0q91oFLoh20qbS7+1KRUvOy9Drgk1HTweGbjAUA7
Ij6pA1ypulMdn+/gc9KtasIbOvBMzGTKmTULLxASmL+3pwP+b7dK17sycUeu
C7eP7NcF4vHrM3NpGfg7Ko1f3AK6sNCUdm/GNh2/vn2r7JakLghcSXRktPgP
N1n56cChrAupxywD++zT8Bdj1Q0sxrpwnuEv+bNYKh7dz+ybaq0LeTw76XmJ
V3G1l368jE66kBxKPZr5JwV/VC0RTXdOF1xMSlpYpS/jPiVJMpcu6EJx4JVC
lclEXCxndpwyWRfGHGKC+0ov4TmX87HdHF24FWOOm/tcxO0v/F2OLNUFwtCS
o7VbPM5+zjFv+7EuhF2L4KT2jcOvOHHvrXf+q+dCwsHjBhdwA5vzVUFvdcFn
gWyuXxSFU5oMnf7+URfIL0PHkngi8XCVtBcLq7rgYNEh91kvDFeWXgn02tEF
JrZPt9K3Q/HvgqZCc7R6oBbWENHfHIJ7MO27OHVYDz629v73NiYYF6byUDwt
pgfHPZ/1VZ8Pwie22qfH5fSgijzyh3ghELeZidUd1dODwc6PCaseZ3GWsYl1
W3M9cL8dKcHc7ov39GkVvXPQg52z0Qdvq/rg2g1bNP3+elAQ3Wb3yskTV3f9
qnw7XA/aZkz8J8U9cPn9I2dcLupBQm2Fp+beGZz/xLOO9Uw9WCp/pOw04Yof
oir52XhPD8jfcqyzplxwpvJM0aQyPdBRfv9ydc0Z//0r5BJ3kx5kbcYwFIY4
4T8Kzjyd6tQDl2PBDRKfHPF5Y5vZ8gE9SJ1W8Zh0PImP3FHSw2b14MhFjC8p
0x7v0xYJoVvRg88nCje8zezwzm9sRf1bekA73zHvxXkcf6qxRu3KqA/+icVv
FEet8YqpKSXpQ/pQGfBK077fCi9Meev2k18fog4wJJgOWeJpY9XtSYr6MG4Z
wtNDY4Ffjs9fNyfoA13WcbO/p0h4jGSaCI/BP71GJfWk2xQ/GxGQUOGgD55P
G1I8xo3xM0Knn4S46QMWMd+CEoxwx1ekGeysPrxe2B/HRTDETXhkdQfi9IHt
RkcM86Qert165NydK/owr+ZyIviVLq7ufeC+a4Y+qF54VO7YqoOL1y9RbZTq
A+shonHXGOBHXMYVmx/rQ/C0u0v7D4RzMPS6Xibrg2LgL0tfQxyncqho4+nX
h1NMRpzaylr4L4rstelRfThU0MNy7JUGvvrgivDDaX0QXuIeoQtSxz9ve1/E
N/WhkagVkLehgg/nO9TQUxjAMEn/bcqAMt5nZDw9wGAAM206XY0NSnjjbQkd
tyMGICnmcHqoXgF/AtzBMkcNwOGebTS8kcfL5+kLN+QNQDXQVYTmgxx+W/0r
ZbKeAaSRBK5s5crgNyaHFSxJBnDJUnqBXlAaT0rudDlsbwC/D97oonwmiYeO
Frc+9DWAoo6Qt7d5juJ+cZk/QkMNgOq5tiXxixh+RiJRCMUawBwb242DraK4
VfiZ+LfpBpDT8vrMpWJh3FjQ5vHdHAOIF/v3cH8ohEO37pRbiQHo3uuYansh
iMtyi2hv1hsAd+0bjbDD/LjYC7aglnYDeKZuSXyczIfzeVEVJL8xgFWX69kT
jLw44/MpCt4pA6BZvrvWZMqNr1pkJdUtGsBiNvXKh2VOfOibKZPN5j++1Rax
rfAQnsv7nCuV0RAGTl7XvKLLjl98ejZXktMQbuKz75yOseEeZiIinYKGENNR
rz0rzorLxV6X3VMxBD238nT6q8w4B7fe02wwhJlJ0qc/b5nw7epfGupEQ1iM
8esbVGDEW6fP6Ac5G0LB6tpkluo+vCTq8OsDvobw62+Exs9ROvwKx4BFeagh
jNlfPslwgxa3NtBynLliCPcZghZ/K1Dj6p9Xp2IzDYGJo2a3l48K5wsv8eTL
NwS2Sld/bS5K/EsZ6znbWkNogtlq2YC/WI9O1/aPFkPY2RV9VFv3B3v0MTrm
eo8hJC9nP6bj2cHCDsyndH02hPT3274JgtuYY0kuy5kFQ8gZkM7n79jEAFln
UmwYwkb/8FPnqA2MIag5X2O/EWg8LGaJFFzHVhhCxIc5jOAbsdXQiGkNGyyU
fBgsYARsJ7pkH9L/wLKHMuoqlI3AIS09LNB6BYs7a4IZISMQ1ZJjSs5dws7Q
UbTPGhvBnyhRTluKReyYum/fkdNG0J9f6Ze8fx5jeyto0+BtBAHCH6Ndquaw
Te/hseMhRqC6KHG+3/ML1pKt/eVGihH8EPjxhJllBitS3vKRyTCCVPVJsQ87
U1jym4er3Xn/eBKdx6W2JzHLPa4/lE+NoJmrjGVI7ROmevtNfF6zEbhK8PdF
J4xjhxUS6LVeGcEeQeJ7y9cP2IzrClvIJyMwW9gXXPxzBOveuX/74DcjMJ6I
oSHfHcYeZjjwV64bwVRBC6+1zXsstLNDcm6fMTClXC+o3R3ETpyOrLrIbgyv
xI/lRS6+xfBtORUBfmOoq04OfT4/gNFLZYO9kjFMFLLGWvP1YUttFp0/MWMY
/np7MMm7Fxs4SWf6n5ExcLV50Ov292B3UoPsek4Zw4Ffno4jn7qwGPGjEx5e
xnDHuHtePKkTc20Zd6U+ZwzX3zGkzsNLTPqHoT8h2Ri41e2KfZfaMFPCjXOi
6f/4xz0MhpdaMb/Lw+FMOcYwv870nfz7BfbwiHvCeJUxkAKb6E6GN2O9Xg+T
O+qNIe3j7+bB8UZs6cl66sN2Y9BNqCTsHSdjMiYXb0ePGMNdmUaxrcvPMdPM
V7lnpoyhRrZ+/j6hDvObPHjfdNEYZmIpjd9QPcMqz9+r5Nszhqe/blYutDzB
+lrnamgYTIDyFWlPurYGW2GSfb7EZgJNycqJcc8fY7L3G9saxU3gP/qje196
qzDSCnV3kbwJuIhu3/UQeIT5axDfXNM0gQSSW3pq8kOsqn9sxJFkAs6E35pC
d8uwgcNCE3r2JtB8xHrTDh5gq+5e0zKuJmB83ZzxzXYJJv9nc+lPqAk8a/SW
L84pwiwM8bXZWBOQja36BEn3scD0xK3eFBN4l18tdD2mEHsswUGVm2sC5Bu0
bUdv52OD507SJ5aaQPWi2xBz4D1srbmQ6exjE6hTl3c/15WLKdoqcGEvTYCq
UeuJ7vO7mFV+OJ9YvwnI+GdVuprfwYIXW4QOjJkADzGQ6sqvLOxJPElmYskE
soOdmakSMrGh3kyFl5smcMTaZ/S8cwb2k2tCtZKCCKvnWr6A2U1M+ZGv9gUO
Ivyqaii/Y/kfZvOrxsCdnwjVJ44Z1nmmYSF6v4lmEkQwnz974DTHDaz2Q/Lx
IwQiuB/z56KbuYoNiw2cpDUgQnbPAe9zPlewzUAul2Xzf/nVJ1920KZgqvQl
vk1uRNBRTGUln0vCjlstBxafJYKns+rfq3qJ2Plc5fOpYURYk1YbdBa7hNUp
tcedukoEY1a5qnT2i9hozP4k/Uwi0J79wRUqEI9tv7K8euweEYz49QmYehym
7jyZuVtDBN5InT5H3guYfcXR7C+NRPi+ocqpnx6FhW/657/pJMKl4J30tSOR
WP213fLcD0QI9QlP5w0Iwz6M6FUnzhKhhtZRsUjxPPZb+Frt2RUinNcNO/+F
LhTTrD/8AqMyBcJnRamViWAs+nXV1DqjKWQx22bsmw3Cmif0qMsPmf677yry
OLcCMW2qAANOSVPo7Cr0Srroj13koPHqVTSFqkcZzzxX/LAO8TspFwmmIEuz
7yAhwBczIrb3rpibwgiNLLNGhRd25ZT9SpGDKfy+lu537own1huwzHLSzRQO
mARN5sl6YBYZXNZd501BWDXvz9E1Nyy95GHIhThT+Ok5qLD6zRUbeq59S+mK
KSxfbwrx/e6C2U34jt3LNYV9f/PDbgg6Y7e/U+zYlprCr8bxb+OZTtgHylt8
TI9NoWhx71sbxSnMSfzF6fAOU3hzyG3KhOMElq9uGy/b9y9ODrUZbrDHpk0W
CmdHTEE7n6rU9Jwd5hHAMWex+M+/4Z6XCKct9iC+jJ5+wxQqKTflB/5aYws3
ccmmv//4u5StvzassLPPvfwk2czgAvtu1UMmS+xRz27qZ14z6J5niX8rZYGt
jqdXZYqZwZc7OoYOZSQshLJpjVLDDGI/MjLwpBOxZ+xWHM91/uVLpleMi5pg
22JfVfxNzaBepCU+rccIizZhjfhw2gzSw8xN+0wMsGbHkrtp3mZg2bF4LFZE
H6MI0Go0OGcGdAZ/3eMY9bCEm+57NUlmkLW3JI3R6WAdxb8FvdPMwIirZSaa
Sxuje35DR+CuGawEjFPKqgB2Zbw+8WqlGbxpLL4zJY5hvSukUu06Mzg/rWD+
X7EWxkw52731wgx0YvalENQ1sXQxZqYzQ2ZAZDLWzstQw4bU7h87/MkMmu/m
2YQ6qmKcJurmA1/N4HJ3jOmasgp2x981nbBjBhUdo14HOJSwD3FbT9ZoSEC0
T6Ju5VbE+G5ee/+AmQTU745vGEgpYPl1z7gPCZOgdlvf325SFpt+RdR8LU2C
FwF9v02NjmGi45Mn41VIUM4Y6KraKY09oGC8t2xEghX/lKFLfyWwBbb8F/et
/q3P6Pyq8ewoJiOmMu3gSAKlnNKvF2PEsSrj02KdASSoOYWXPCSIYp9MG3LM
I0lwvk+E4SifCMZscYhj7BIJbmWv36BhEsb8jr+mWrpDAinK37eucAti2Q7i
kaFFpH/93ddI78GP9TjG//j7iAR+vRJ6PE/4MAk3tUnWDhLcedV93zaTB7Pz
SLfL7iPBcnXVnr8EN5bkvdwnOkaCZNM/gA9wYl8C7jeprZCgd/HVa0l7Dozj
3F/l1m0SNHkbxl5QYcf0zjs8NKE2B9rakm/cImxYYTRL9iluc1jeI9oxyRzE
3sb6sH0VNgexlzVMDFeZMYqElymBx8xB2nngbtgIE+aUEhWeoGMOhqXROwO1
DFjqteHvTGbmYD+R13/fYB/WeEPB85adOfxRkaMgL9FhvLe+2pb5mQOXyMPP
K8E0mMkdnTeKYebQVyDUftSCGovMydVrjDcHLS4uvwkCFTZaaK3Uf8scvLO7
mjl0KTD6kkfl9gXmINO6e/p73V+CahmD8HSFOXDI9cWy0ewSMqpaDm68MIfY
xsYrtjO/CO01h5NjXptDxGf/Pc/gbcJabege/bA5lGY+XA09tEWwbJReObz4
z79EhWfPrZ8E+6nAFU4KC5hgI351dFojXJ597Z6/3wLeUQuaNbusEp59FZ+Q
PGQB0evKrzVUlwlzC/E2TwQsIHHjqm8l0wLh0Mr4a4KUBdB7VUv6an4l6P1Q
0+1UtoBgYtDp5tpZwrmf6Q3myAIIDWuDR6KnCYVbywpjxhbwSa0J8MRJwtvf
RmWuNhbQbZmuWZk2QaD4e19wyckCamaONGhFfCDIUe5lhXpbQMbKgW+ZNSME
J5oTLHvnLOCylnW1pPR7wnX62qTkGAvoKG12/7Q4SGjaf/Ava4oFbLaJRdIw
viWkh35bJOdYwFPrJZqexF6C12TbmHu1BQRJZNBw7HYR+LU0bC1qLUCppfU7
+Usn4V1m1YBmgwXY9Yq3F/S8JODEnC6WDgvIPv24I+5BO4HjWWht/YgFCGUW
ZZ4ufkF4cVXivwN7FlB0w1CcCa8n+Ll89HMRtwTnwBSuL8qPCcKNlvNEaUuI
E/cYmYmpJoxwdrupylvCKVdZbu7iKoJO79MTjJqWEG5wKX6Tp5LArXbdqNbM
EgbMB+UX2R4Q2pm0RRlCLWG3vC+yCnIIh5+XfKxut4S/y9xdu3YJBANGCira
V5ZwUDZqrvVBPCHYyUHCoc8SqvH53TSGOEIPDVMo5dg/vqTUT1aqSEKUZRCz
1cq//R+4V9c3BRDGF7S017mtoGGsfq110Y6Qd+RtiYq/FVTgQwX2bQGNwgk7
QQ3c1vB38+1P6g/xjU6KDOmXPW2A6qTZVO03nUZWSbOijnu2cLKbI07olhgh
ADMP8Fs7Dpm/T7M0jVoS9O5clrkkaw8CDWd1rUSlCB1sMYV0iQ5gIk97quLH
ODks8Fih6fsToChUKj3PLUEoOMSeQcXiCA136/jc6yQJYaPPcBG3U+AaePvj
3LIAoWM67eOTfCfY+xoyTmQ6QNB7K0K1b/Q0nJmQrwhmPEh47t8QOJPhDIN3
C6Jniw4SUrhjxiIVXcBeiCt5QY+OIP82P89wwgXa+hc+8N+Z1FrduSexeckV
RCJ6LDeSf5H9TBoqHIXcoCL93lErf9rGplKlq9s9biCXyO952oWmsUei283U
+wyconpeFt/4i/yDV4PyIo07/Dr+jRjkNExePsKws/TQHV5nqVOKeS1rFev+
XGYx8YBAQe1kyvVtLcVwHPP66QEnlJ6rrLptaUUN3E8Mv+kJQ1JpxD7jJa2J
u1/SfeS8oLujcKty/wutQyFJf/4b9QK0EH5SuW2GzBCkczrovDdMPmq+aduw
Qh6MPsWfJOQDgs/rlg/XLpJrf9sURr/ygZGo5tf56Z/I1jmeAtIevrBVOkmj
cPs/cpfp2DbzQT9o+WC5ya78QWtT0ON1+SM/YAg5SlXsPa2FPPtdJUzOwrHS
s7IDa5+1nBqzjn9cOwsRyasKBS4DWuoqUboGaf7Qjp5PGfFmkIejdKRob/rD
wc7TJxhHb5ND2xhYOzL9wa6oPCoxLZdcY377k3a2P4ybDicxRt4ny/jURmAl
/pAbuT298eIhWfDe9yrlRn/4Ob97/YZHHZmB4QyfyLw/VA5o5dzk6SA/MJem
nl7whwtRQH6a1UE2uLX2LX/ZH2q7P4q2c7wkXxKJr+Nf9wel9KTCW4yd5L9Y
ntXhv/4QMRAzeG+xi7wWPJrMyhEAEhdTToYFvSan1d8LGOAMAIPS/Fmv8ddk
OQrP4zd4AoDmKssMlUEv2S91Q+SAQAC8GCraL3DoDXmulK1ln1QAFLjG3ogt
7CNfWhkr7pIJAGc/cRKBqp8solJwLUkuAB61JXLFOveTndvkTtCoBMCTN9d7
dJgGyH/3bUG7WgCUCNrZCWoMkHPNm49e1AyAU03vSOruA2TCrURmbexf/OGJ
K8lpA+QP46YbeygALLe0Z5jJA+T/AWou024=
               "]]},
             Annotation[#, "Charting`Private`Tag$387352#3"]& ], 
            TagBox[
             {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
              LineBox[CompressedData["
1:eJxF13c81e/7B3CzPiiysvfIyt7jfV+Oc46VmZ3KSlYZESpEA5WSEQ6KMgpF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               "]]},
             Annotation[#, "Charting`Private`Tag$387352#4"]& ], 
            TagBox[
             {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
              Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxF1nc419/7B3C7UISS7J2y9/tlnHPzRlFGiChEtsoom6ZEpWQkUQgpFTJC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               "]]},
             Annotation[#, "Charting`Private`Tag$387352#5"]& ], 
            TagBox[
             {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
              LineBox[CompressedData["
1:eJxF1Xk4VV0XAPCMRZkic2YyyzVeXHddQqZEt0TIEFIqicjYINKAUBKiMvTq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               "]]},
             Annotation[#, "Charting`Private`Tag$387352#6"]& ], 
            TagBox[
             {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
              Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwVV3c4198XNxOJZM/s7L193u977D1TRvZe2STZyaqQkMqeJS0qFUmSkJXM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               "]]},
             Annotation[#, "Charting`Private`Tag$387352#7"]& ]}, {}}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{False, False},
        AxesLabel->{
          FormBox["\"Day\"", TraditionalForm], 
          FormBox["\"Units\"", TraditionalForm]},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{True, True}, {True, False}},
        FrameLabel->{{None, None}, {
           FormBox["\"Day\"", TraditionalForm], None}},
        FrameStyle->Automatic,
        FrameTicks->{{{{0., 
             FormBox["0", TraditionalForm], {0.01, 0.}}, {0.2, 
             FormBox[
              TagBox[
               InterpretationBox[
               "\"0.2\"", 0.2`15.954589770191003, AutoDelete -> True], 
               NumberForm[#, {
                 DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
            0.4, 
             FormBox[
              TagBox[
               InterpretationBox[
               "\"0.4\"", 0.4`15.954589770191003, AutoDelete -> True], 
               NumberForm[#, {
                 DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
            0.6, 
             FormBox[
              TagBox[
               InterpretationBox[
               "\"0.6\"", 0.6`15.954589770191003, AutoDelete -> True], 
               NumberForm[#, {
                 DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
            0.8, 
             FormBox[
              TagBox[
               InterpretationBox[
               "\"0.8\"", 0.8`15.954589770191003, AutoDelete -> True], 
               NumberForm[#, {
                 DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
            1., 
             FormBox[
              TagBox[
               InterpretationBox[
               "\"1.0\"", 1.`15.954589770191003, AutoDelete -> True], 
               NumberForm[#, {
                 DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
            0.05, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {0.1, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {0.15, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {0.25, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {0.3, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {0.35, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {0.45, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {0.5, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {0.55, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {0.65, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {0.7, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {0.75, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {0.85, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {0.9, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {0.95, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {1.05, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {1.1, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {1.15, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {1.2, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}}, {{0., 
             FormBox["0.`", TraditionalForm]}, {0.1, 
             FormBox["\"\"", TraditionalForm]}, {0.2, 
             FormBox["3.480000002376827`*^6", TraditionalForm]}, {
            0.30000000000000004`, 
             FormBox["\"\"", TraditionalForm]}, {0.4, 
             FormBox["6.960000004753654`*^6", TraditionalForm]}, {0.5, 
             FormBox["\"\"", TraditionalForm]}, {0.6000000000000001, 
             FormBox["1.0440000007130481`*^7", TraditionalForm]}, {
            0.7000000000000001, 
             FormBox["\"\"", TraditionalForm]}, {0.8, 
             FormBox["1.3920000009507308`*^7", TraditionalForm]}, {0.9, 
             FormBox["\"\"", TraditionalForm]}, {1., 
             FormBox["1.7400000011884134`*^7", TraditionalForm]}}}, {{{0., 
             FormBox["0", TraditionalForm], {0.01, 0.}}, {50., 
             FormBox["50", TraditionalForm], {0.01, 0.}}, {100., 
             FormBox["100", TraditionalForm], {0.01, 0.}}, {150., 
             FormBox["150", TraditionalForm], {0.01, 0.}}, {200., 
             FormBox["200", TraditionalForm], {0.01, 0.}}, {250., 
             FormBox["250", TraditionalForm], {0.01, 0.}}, {10., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {20., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {30., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {40., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {60., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {70., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {80., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {90., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {110., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {120., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {130., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {140., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {160., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {170., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {180., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {190., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {210., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {220., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {230., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {240., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {260., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {270., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {280., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {290., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}, {300., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
             0.}}}, {}}},
        GridLines->{Automatic, Automatic},
        GridLinesStyle->Directive[
          GrayLevel[0.4, 0.5], 
          AbsoluteThickness[1], 
          AbsoluteDashing[{1, 2}]],
        ImagePadding->70,
        ImageSize->Full,
        LabelStyle->{FontSize -> 13},
        Method->{
         "DefaultBoundaryStyle" -> Automatic, 
          "DefaultGraphicsInteraction" -> {
           "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
            "Effects" -> {
             "Highlight" -> {"ratio" -> 2}, 
              "HighlightPoint" -> {"ratio" -> 2}, 
              "Droplines" -> {
               "freeformCursorMode" -> True, 
                "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
          "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
          None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& )}},
        PlotLabel->None,
        PlotRange->{{20, 30}, {0, 0.008}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.05], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}], Scaled[{0.5, 0.5}], Center, 
       Scaled[{1, 1}]], InsetBox[
       TagBox[GridBox[{
          {
           FormBox[
            FormBox[
             
             TemplateBox[{
              "\"Susceptible\"", "\"Exposed\"", "\"Infectious\"", 
               "\"Cleared\"", "\"Deceased\"", "\"Population\"", 
               "\"Infected\""},
              "LineLegend",
              DisplayFunction->(FormBox[
                StyleBox[
                 StyleBox[
                  PaneBox[
                   TagBox[
                    GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Dashing[{0, Small, Small, Small}], 
                    RGBColor[0, 1, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Dashing[{0, Small, Small, Small}], 
                    RGBColor[0, 1, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.007000000000000006] -> 
                    Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Dashing[{0, Small, Small, Small}], 
                    Hue[0.59, 1, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Dashing[{0, Small, Small, Small}], 
                    Hue[0.59, 1, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.007000000000000006] -> 
                    Baseline)], #2}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Dashing[{0, Small, Small, Small}], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Dashing[{0, Small, Small, Small}], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.007000000000000006] -> 
                    Baseline)], #3}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Dashing[{0, Small, Small, Small}], 
                    RGBColor[0, 1, 0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Dashing[{0, Small, Small, Small}], 
                    RGBColor[0, 1, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.007000000000000006] -> 
                    Baseline)], #4}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Dashing[{0, Small, Small, Small}], 
                    GrayLevel[0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Dashing[{0, Small, Small, Small}], 
                    GrayLevel[0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.007000000000000006] -> 
                    Baseline)], #5}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Dashing[{0, Small, Small, Small}], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Dashing[{0, Small, Small, Small}], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.007000000000000006] -> 
                    Baseline)], #6}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Dashing[{0.045, 0.045}], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Dashing[{0.045, 0.045}], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.007000000000000006] -> 
                    Baseline)], #7}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}],
                     "Grid"], Alignment -> Left, AppearanceElements -> None, 
                   ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                   "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
                 FontSize -> 13, FontFamily -> "Arial"}, Background -> 
                 Automatic, StripOnInput -> False], TraditionalForm]& ),
              Editable->True,
              InterpretationFunction:>(RowBox[{"LineLegend", "[", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small", ",", "Small", ",", "Small"}], 
                    "}"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0., 0.6666666666666666, 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small", ",", "Small", ",", "Small"}], 
                    "}"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    Hue[0.59, 1, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> Hue[0.59, 1., 0.6666666666666667], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"Hue", "[", 
                    RowBox[{"0.59`", ",", "1", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    Hue[0.59, 1, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    Hue[0.59, 1, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small", ",", "Small", ",", "Small"}], 
                    "}"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small", ",", "Small", ",", "Small"}], 
                    "}"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small", ",", "Small", ",", "Small"}], 
                    "}"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small", ",", "Small", ",", "Small"}], 
                    "}"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0.005`", ",", "0.005`"}], "}"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    
                    RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6, 
                    ",", #7}], "}"}], ",", 
                   RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
                   RowBox[{"LabelStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"FontSize", "\[Rule]", "13"}], "}"}]}], ",", 
                   RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
                 "]"}]& )],
             TraditionalForm],
            TraditionalForm]},
          {
           FormBox[
            FormBox[
             
             TemplateBox[{
              "\"Susceptible\"", "\"Exposed\"", "\"Infectious\"", 
               "\"Cleared\"", "\"Deceased\"", "\"Population\"", 
               "\"Infected\""},
              "LineLegend",
              DisplayFunction->(FormBox[
                StyleBox[
                 StyleBox[
                  PaneBox[
                   TagBox[
                    GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.007000000000000006] -> 
                    Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Hue[0.59, 1, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Hue[0.59, 1, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.007000000000000006] -> 
                    Baseline)], #2}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.007000000000000006] -> 
                    Baseline)], #3}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.007000000000000006] -> 
                    Baseline)], #4}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Dashing[{Small, Small}], 
                    GrayLevel[0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Dashing[{Small, Small}], 
                    GrayLevel[0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.007000000000000006] -> 
                    Baseline)], #5}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.007000000000000006] -> 
                    Baseline)], #6}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Dashing[{Small, Small}], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Dashing[{Small, Small}], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.007000000000000006] -> 
                    Baseline)], #7}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}],
                     "Grid"], Alignment -> Left, AppearanceElements -> None, 
                   ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                   "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
                 FontSize -> 13, FontFamily -> "Arial"}, Background -> 
                 Automatic, StripOnInput -> False], TraditionalForm]& ),
              Editable->True,
              InterpretationFunction:>(RowBox[{"LineLegend", "[", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0., 0.6666666666666666, 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    Hue[0.59, 1, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> Hue[0.59, 1., 0.6666666666666667], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"Hue", "[", 
                    RowBox[{"0.59`", ",", "1", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    Hue[0.59, 1, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    Hue[0.59, 1, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    
                    RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6, 
                    ",", #7}], "}"}], ",", 
                   RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
                   RowBox[{"LabelStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"FontSize", "\[Rule]", "13"}], "}"}]}], ",", 
                   RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
                 "]"}]& )],
             TraditionalForm],
            TraditionalForm]}
         },
         AutoDelete->False,
         GridBoxAlignment->{"Columns" -> {{Left}}},
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
         GridBoxSpacings->{"Columns" -> {{0}}}],
        "Grid"], Scaled[{1, 0.3}], ImageScaled[{0.3, 0}],
       BaseStyle->{FontSize -> Larger},
       FormatType->StandardForm]},
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     Axes->False,
     AxesLabel->{
       FormBox["\"Day\"", TraditionalForm], 
       FormBox["\"Units\"", TraditionalForm]},
     AxesOrigin->{0, 0},
     DisplayFunction->Identity,
     Frame->False,
     FrameLabel->{{None, None}, {
        FormBox["\"Day\"", TraditionalForm], None}},
     FrameStyle->Automatic,
     FrameTicks->{{{{0., 
          FormBox["0", TraditionalForm], {0.01, 0.}}, {0.2, 
          FormBox[
           TagBox[
            InterpretationBox[
            "\"0.2\"", 0.2`15.954589770191003, AutoDelete -> True], 
            NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
         0.4, 
          FormBox[
           TagBox[
            InterpretationBox[
            "\"0.4\"", 0.4`15.954589770191003, AutoDelete -> True], 
            NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
         0.6, 
          FormBox[
           TagBox[
            InterpretationBox[
            "\"0.6\"", 0.6`15.954589770191003, AutoDelete -> True], 
            NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
         0.8, 
          FormBox[
           TagBox[
            InterpretationBox[
            "\"0.8\"", 0.8`15.954589770191003, AutoDelete -> True], 
            NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {1., 
          FormBox[
           TagBox[
            InterpretationBox[
            "\"1.0\"", 1.`15.954589770191003, AutoDelete -> True], 
            NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
         0.05, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         0.1, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         0.15, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         0.25, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         0.3, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         0.35, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         0.45, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         0.5, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         0.55, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         0.65, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         0.7, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         0.75, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         0.85, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         0.9, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         0.95, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         1.05, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         1.1, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         1.15, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         1.2, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
         0., 
          FormBox["0.`", TraditionalForm]}, {0.1, 
          FormBox["\"\"", TraditionalForm]}, {0.2, 
          FormBox["3.480000002376827`*^6", TraditionalForm]}, {
         0.30000000000000004`, 
          FormBox["\"\"", TraditionalForm]}, {0.4, 
          FormBox["6.960000004753654`*^6", TraditionalForm]}, {0.5, 
          FormBox["\"\"", TraditionalForm]}, {0.6000000000000001, 
          FormBox["1.0440000007130481`*^7", TraditionalForm]}, {
         0.7000000000000001, 
          FormBox["\"\"", TraditionalForm]}, {0.8, 
          FormBox["1.3920000009507308`*^7", TraditionalForm]}, {0.9, 
          FormBox["\"\"", TraditionalForm]}, {1., 
          FormBox["1.7400000011884134`*^7", TraditionalForm]}}}, {{{0., 
          FormBox["0", TraditionalForm], {0.01, 0.}}, {50., 
          FormBox["50", TraditionalForm], {0.01, 0.}}, {100., 
          FormBox["100", TraditionalForm], {0.01, 0.}}, {150., 
          FormBox["150", TraditionalForm], {0.01, 0.}}, {200., 
          FormBox["200", TraditionalForm], {0.01, 0.}}, {250., 
          FormBox["250", TraditionalForm], {0.01, 0.}}, {10., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         20., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         30., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         40., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         60., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         70., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         80., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         90., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         110., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         120., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         130., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         140., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         160., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         170., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         180., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         190., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         210., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         220., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         230., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         240., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         260., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         270., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         280., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         290., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
         300., 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
          0.}}}, {}}},
     ImagePadding->All,
     ImageSize->Full,
     LabelStyle->{FontSize -> 13},
     Method->{
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}},
     PlotLabel->None,
     PlotRange->Automatic,
     PlotRangeClipping->False,
     PlotRangePadding->{{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}},
     Ticks->{Automatic, Automatic}],
    TraditionalForm],
   InterpretTemplate[Legended[
     Graphics[{{{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[1.6], 
             Dashing[{0, Small, Small, Small}], 
             RGBColor[0, 1, 1]], 
            Line[CompressedData["
1:eJwd13c4le8bAHArKyVCJSTSl4zsGc8te++9j3OOvUcilMooWZGMikglqyIR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             "]]}, "Charting`Private`Tag$385807#1"], 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[1.6], 
             Dashing[{0, Small, Small, Small}], 
             Hue[0.59, 1, 1]], 
            Line[CompressedData["
1:eJwVV3c4l+8XtrMimQlZFUL27H2eY++9Nx9771WS9TUayMoMoSmUWUkZSYOQ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             "]]}, "Charting`Private`Tag$385807#2"], 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[1.6], 
             Dashing[{0, Small, Small, Small}], 
             RGBColor[0, 0, 1]], 
            Line[CompressedData["
1:eJwVVnc0EG4XtmUrkmSv7L3lfa+99957byl7C6mEqIyMFJL8JCuEUEmlkh1S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             "]]}, "Charting`Private`Tag$385807#3"], 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[1.6], 
             Dashing[{0, Small, Small, Small}], 
             RGBColor[0, 1, 0]], 
            Line[CompressedData["
1:eJwd13k4VO8XAHAUQlGylX0NIftu3mNN9n1fxoyxZy+SFImUkBASylJfoU3K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             "]]}, "Charting`Private`Tag$385807#4"], 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[1.6], 
             Dashing[{0, Small, Small, Small}], 
             GrayLevel[0]], 
            Line[CompressedData["
1:eJwd13c0198fB3Drq1CUlZWtyEi28L4vI3vv7eNjZpMksyTbB0Uls0QSUkYL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             "]]}, "Charting`Private`Tag$385807#5"], 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[1.6], 
             Dashing[{0, Small, Small, Small}], 
             RGBColor[1, 0, 0]], 
            Line[CompressedData["
1:eJwl13c81d8bAPBQVETK+soe2bI397Fl7z2vPbKJhhJZRVZJhBYSTSsZhbKK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             "]]}, "Charting`Private`Tag$385807#6"], 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[1.6], 
             Dashing[{0.005, 0.005}], 
             RGBColor[0, 0, 1]], 
            Line[CompressedData["
1:eJwVV3c4EF4XtiKSkRFCZtl7j3uPmb333ntTGcnMqqyoRKIhRMNWSKhQKcre
VPQzskeUz/fXfd7nrPec59xz7uV0CTRxJyIgICgkJiD4/7mwtq+n6dGPWAPr
GZZZhlDIowhJ9eJqrDD2/msr9xAKP7bkwVzcjnmqvqZoKw8hWXW2mszgT1gp
PuMeeAyhqJYSApLir3j6Ritv4t0hNDKCHuPUIex2dXGRbmYIKWwP6EcFj2Pz
xTBmKslh9ClVNnJUaBqvJhAdq8gYRn9vJejvFs3iHVe623h7GAmVfOY4yfAT
U67o3BTzHkF2Nac2pFLncfEuW8mf7yOo6Uv1naDgJSzj6dntuDOKFicO/NN/
/MZsG8Om6hljKH3rEceA0CpmaX40niUyjlpI1tbXi9bxw+InRElXJtDAsdvj
RKMbONL9sUO/0iRaPoHe0zJs4X5qCYvxvUnEzpl2RzR1B9uJGyi6dk4hGT6x
RNS+i3OuPgjSkpxGBqID/vp//+DRCq3CteJpFK3MpeIb/Bcz1zl03UubQTnq
nQKRT/5hcseQnUqSWVShG0Cf+uMAp/it89yKn0XLQuOhX4UIQTs9+zZf2nfE
rsh/brWIGMrumNCudP1E5Wj/1Y4yCRyocRQFus0hGdXPYgSjJJACp0tMiOeR
gfZ5FmoGUpiayy17YPALXbZ8sySUehRo9pkI7dkXEYVtjovUGXI48qpLbWRi
Ed108BxUbCeHqHPDeQUPl9BT9+NvdP5SABVWEwqH32g81DrHK/g4HB+L8X/j
sIq8LgqRB1FRwTpHggblwCraiDyIvviEClb2Zb9lGq0hyvhHnkk/qIFunl6v
0HAdsXeGs/UJ0cLiQF+Wcfgm+q49M2geRQti26SvF49tofIPutnDXbRw/DSj
TdyDLSTzmZ1s2uMEjIyKUZNMbiODgY6V30V0oBBHTHYr7Q+KmbS3ptqiA/Xm
svvVRnvo+fzWGyFdeqAvM1a6zbqPaPf4bnhv0sMxKu4hj3d/0bfT16VntRlh
WZ/BIbOaAB/hP1NIeI8RBqIJ/yqLEWIZidekHBuMwG88ez39OSG+pb46aFd4
Ei6qBvZcaSLCNt7mkQNrTPC+43jiNskRfDVkeWbjHDOYBnlIzRQfwU1Rybp0
d5lh0HbSzkmNFLOlN7IanWMBSRWuyqIcMjxVxfa6K/8UNJMujgmHUWDaprqz
8yungP+xnXm5/DGs+tYwk1STFTL3Zil+kVDih4NxzmorrFBKd8LapvI49tz/
Qdyszg7+89QRKY9o8O0jMX6jeeygG2TX8YmTFndSMfXvLrPDY1u36qpiWizA
qVMik3caxJPOh3ZWnMDbXJY8Qxc4QNJJr0J3nR5nPn5g5VnMAbXqvUwvMhgw
n9DKta0PHDCDf/56JMaIraRTN+k5OcGYf2PgXexJ/PLcq3fGHzjh8a/14Ql7
FmzykWxvapMTxLVNZl9wncILRmaiQRxcwKRlR6S6dAqz2izdSj/PBQ+cHpJr
5rDhaL/T3h9Oc0O4RH1QwC0OzLjqe9dGhxvIVclJteg48dPzDb2/wrhhxF9m
ozmbE09cNlY42s0NR5Kwx0IBF4ashGMaYTwQSzJQFjzNg99PMCKiAh7Iievh
HwjhxQZC5UGv23kggO/6N5GjZ7D9+y/98nS80Ed0I1wQn8WRf9mKRKp4YSg2
40biND8m1H3RtzDMC5LrXxkbcgVwym31I2WEZ0ClrGi310AQ35L09eE2PgOX
AhvPqn4RwjXeDVJMK2fgR1+o+BEKMaxYr+vZf/IsRBGEJD6PEMNtJJN52fgs
VKfsnnBfFMO9944cUGachb8Pk5bQqDhe7jfpIhThg14fjyn+aUl8nvvnXos5
HwgEeGRk+Erh/aAIkUvRfLA/QWzfsCuFj1EW3dj6yAczXy0qmzhlMJ/qkv2C
Lz+kRFwPufNADj/LiM0svcEPb22aX7AbymOZcbp291f80O9saqJ3II81whX4
pigE4Bsjv+yZAEXs8jR57VuZAOT1h6bcTkX41x4Lb3avADCEhBCcccA4SPup
peGuABBuiR1RZgUc8/1bU5eWIDjzUdZfPQBcwMKV3DInCCFPnmV7Lapibq/a
xihqIXhA0jfMEqSGy2u1FuVkhaDa+ti+07YabjQKNK5OEgIJsaNjlLQaeCCp
6VQprzDU9OLdt6HnsMM3QwN3fWEg24u5tcmohX9wzsZynT/E23WlN1q08EYT
+c+CDmHQWFDcuXlKB9OuWzzPchWBfo+rY3o0+pjdntMsOU0EknPEA8MH9LHQ
+4XtSy9E4O1SavWvYgOslR+LvQ5EQP6LWOdNHiN8Wa28B+WLAqtvu9OLZWN8
rTIsRKpNFGKaWWaWvUxw3knMKPBLFK4Ws8X5/TTBI5u/nqadEoMswvLl2AVT
vNV1eeu8txic/Pjty10OC/z3n2vnyiUxUB2Le+5Zb4FJpLTv+GaKwUj9qrWk
iSWmLaRDzvViYNLE7qWcY4WFQkqv6B0RB8t6IRo1fVss+fi65XsmcXCp/cyl
TGZ3uEdD+FWFxEFtV9n+7Ds7rKWp/EnWVBwG1shGTEwdsCtLHz13sTjQviNj
Cx10wj6G9T/v1ojD1bGKf2w6zjgosaCBqVMczD9sZH197YwvL3vYUf0Wh/JG
1cAXNS74Ttveg10lCeCo+bSY984NF29PnQ8zkoAu9YeXdkzdcanQu3O/XSUg
RWpmgOGHO669mbnwPU0C7gp8eLp2whN/8eGV/DIkAWcH7a9xFnnjwXsUR3QX
JaBFM13a0cAHT3z7PfD2QAIkspWn5Ah98SJ6GfnqjCRcbR6eVTrvh8noDNtK
wiSBmLNvk+1OIKbSksrhTJGEjdZJWw+5IEwfzexRkC8Jv3rTHW6UBGGuuVny
7DZJ+LJDmPDyajBGr8KNo2mk4Bl68TwwKhRz9P3qKeSVAlAiYCQ4FoYJf9no
tSpIAeN+0+KTwjDcwah8jthdCl6+XUv91Hce64QQKqc2SgEP0cdvFcHhWCg1
5GV5jxSw8zbdS+aNwMeLZmU/zkqBXsCD7ISJCPzl01sJaippqP3ZdS7UKQpb
8Kfx5bpIQ7OcsmVk6WUsB3uP6i5KA64f3bqXGoOZLf24h65JAxF0R+TKxeKx
RAP2U/XSYPxK2pFeIA67TJ2gLz4mA02/xX8nySZg9e2ErDYOGWCVCEoz6kjA
vFSbVN+lZWAWxCgZzBPxvOIg+VknGfhQYvHwIP4KDryVf1BRIwP7rvkaBXQp
2OgpZXRPlwzUXhhZCW9PwRJvo//8npABa63X3prhqXhrzXFTglwWlJyErdFq
Gr5kwLPQYC8L2u0rdQU86djBPddrJEQW/mh8Wt44SMf4EunPvWRZSIhYveQz
nYGJyuenUJUsuNsabJePZuKUI5UDHaRycIlfJYdwJBv7sLKb/TwlB/XKdlup
LjewrmRGL5m4HBh8JOAdXL6BqZyDP+rYykFiFXMkL10uzmmSbvvyTA5Ct6pX
Iq7fwhe+luC1Djm4G0L7klL2Nrb872Qz3YgczEniA/TjNmZh+lNvQSIPgjMl
AnuGd3BRaEvlmJU8tGqdltV0uYt3l00Ecv3k4Wcr5yP6M4XYxGeuRD9WHlRl
T9Z0LRdiEmeaopbH8rCN2dIqzxVhLwOX7KIteaB/f5ZS7Oh9/KZri8qaQgG8
lSMumMTcxywaV6/SsiuA0edKR5fd+/ijYk1ivIYCrI9K3L+29QCL8ZNedMtR
ACrzOoo5xhKc+vDOOmupAszULd0zfFyCZ06LBvW/UoDXnb/PiCk+xjmMVt6a
swrAwnri+33/UrxDXG7LJ6EID0adthwPyrFxDBqa0lCE8nNGvrcqn+DyP31m
edaKUCREvTjpWIHtVvf0KeIUQXHYXn7jSyV+PaEPi58VwU+nOeNF6HPMZDPT
9HBWERw/kXsJjz3HQf0X5O23FYFYkyCf+NwLzPXxnkQPuxIQkjb0zXNX4aTG
VZ7n/krgY+Bu+GqvGk9KJRV7xSkBnyrBBZHwGiz3nIWdM1cJNI8jW8PtGvxf
idrJ7CYlYFUItm3/W4sNcnLJw44pw7MVrq/XhRrwY2qBJKHTyuDuuTic8roB
E1xtIfohoQwdbW1lseaNuCpubs/cRhk4z2cxXk17iRkD5Zdly5Rh0dEP/jI3
4wnt8b49TQS0G+ruwT5v8InHf//Y2CFQJvlDcHzgDdYkYed+GYzA2eKzapla
G65scQgNL0BgnObp/x9PO74kOUW3uYrgv+Dj9x4edGBmtlmz5QIMb2RLGxfo
u7BeJHG0fhUGh5gnL/SLunDsIPejivcYLkuUT1wT7sbzWW6bPmsYLk6tKSXo
f8C2xOvd69wAP2MZ2rXuf8IC4WG+QREASKtMXVinF3eUJB6cTgQoi6urZivo
xQ79OTc+pwM4hm56Ziz34myJ2lciDwESSU6e+pTTh3cXN48t9QBMVX3Rifzx
FXc6X6zw5lGBauobP99fG8AumcnALKoC62sfUxWmB/B+y61vnfIq0Pfitrer
9CAWZW3YP2uoAqdOgs/dsUF8c2BH72eECvRuoUEG3mHsrhu55PJZBVrDtxYM
s0Yxh8rQ3alhFZgtmlMmGB7FYzIyBg7fVWCL/hd9+ukxbMK19tR6VwUmP+4J
0pWNYdj1DjLiVgW211Ynr1eM4/3l9xw9wqqg3/H2+uqvcVz/nbdXV04VpjVG
+Sd5J7DIl2nxc/qqsHUx8Z1k3gRmfWy9rnxRFYiaXJ/+9pvEQwX1D17FqQJf
PLfw+7uT+EY2g5n8NVX48vjM85WPk5jicm+NVLEqBH50JKWnm8LvQkXdq56o
gu9Er+BJvikc532dQaxOFeRUGNsUlabwjpn2BcEPqhA9cLrgu/MUrtF5fKas
XxXY6ywFPEOncCAcGTwzpQrUIxrvyBKnsICMa/LD/1RhbeSUxLsbU/in4BtZ
rk1VaLV+HX7//hQu5jw9f+9AFdpeCQ4WPJ/Cdiejb7NRqMGN3e89tc1T+CuR
/C7TaTU4YXf2jmb/FE7fuVl2k18N6OzRldbJKayzvGFNL6UGWkEXhe1/TeEj
300ospEa3JTR42Ffm8Ktw89fUmurwU6UCPeRP1P40mcq3+umarAVeoWZnnAa
y771O3XMQQ36uxnY9cmm8drL7g8pXof2o+9Dqyin8dPnfJdIQ9XgkW9Hkibt
NPYpSRJKjFYDVjX4cYxhGvMWfB8jTFGDWt4UzSNM03gqS/V6TLYa0FSGR0uz
TOOC5CLlvwVqEEx1Lu7eqWlsFf1vKfKxGlDk3nXRZJ3GdKF2hTsv1ADvRxoI
H+Ier5cGF5oO7Sm20ywP9dMcmA7W36nBdbKHIZ3M01jT7MKz4F41yFeJuZhw
choT6nxz/D2qBitddSzX6KdxE5ag8f+pBrR9aSs/aKZxuHRm638ranAprTcv
5zAfKcHlIK89NdjbvtuRf5jvbw49zp9H1IGipY//4LAe5Yzlva406pB71Dat
bW8Ke1AejZ9mUT+cR6bPfm1MYS4iDwlHXnVg/WrlEb40hce322fGRNWBhDAy
LuTHFDabjVEbUleHU5250g1fpzD18Pi6uaE6HBVjDj/WPYW7exQffrVWB+pA
5sDh11NY5eU2yecAdfjswV6zUTaF5VzmpG6Hq8PSlVp6xntTWIxi0M05Xh1E
Fut9vxz2D7tNXcd67mG8mb/krJem8J/dsESmZnXwn2ZectaawqvFbjXT79Qh
wkuLrFBhCs9rm30v/6IOMr+dg9OEpvBgnqS68nd1sAocUYqhPuxf+TVil2Ma
sF0gLXju4SR+Mj0tKcigAS5sonU2iZP4fmqv6wa7Bgj5aPXsuE7izOHn7UkS
GvDkn+bWHOck9o8ITHhirQGKF/xI6A/v35nGRaLNxxpAwus44Bo+jtmcxyRa
XmjAOZemSXHTcUxP/tEl+ZUGtIeFznwUHsdE1k/amD9rAFGCrtzFmTE8ueMd
j7Y04E0gjdyW9hi+LTdHmKKuCUbE0d856EfxsYZpglPTmsBtfkfL+dEQXjG6
lVS/oAnpvPEmuVFD+NsvPUqzLU1g4GhmnDYewndPNZy8fuwcMMlt/Hv773B+
xaSLHEifg/fXBUyWrAexqaai3WzaOZg6RjPRzjiA87/l1D+R0gKGs+/YG55/
xbH+OspaWAu0FYg4Vq5+xW6kBO3ftbVgcz7nkY3nVyws59vD5qgF1Qv+tp3s
X/HrfJUfGalacHuwlPR4Zh+edVk+ETahBWyacWuOl3qx4Oq5AKUUbYgoFtIg
3u3BekoZoTzZ2vBJUqI2vrUH+yUPhFMWaEOr2LiyXUoPrmBzTxh7pg0Jz45U
sjL3YCGd+NuXBrXhmvMnio/oExZ50NTWdEYH5slOE5bc+YAlzMVPKr/VgWna
U+5/sjqxSVE4K+9nHQjLXaY469aJQxZecx4f1oFynzWRBzKduDrOQGh8UQfG
uh5ap4y9x1JPfVWi6XXBV1Hnzx/B91iGrMS32VUXyvMUTM8Mv8UKjSytykR6
0CfBJ1DjfbjvPjybXj+mB06Omw4tGu24ZVyduJxBD+JUNd2PcrVjFaJATUZ+
PRD+3udgM9qGtXTbPy4b6kFnJ7v9glEbthz3Hb53Vw/G/D1O+Z97g8MIm9cI
5fVBsDaooaGlBdfRmdA3qOqDaMO/DqMrLXiHd046QE8ftozcThvrteBLOrQR
I476MIdriVNGm3HCDfeDqiR9EGnPKH71rwln81JRun3TB26qwJJHlq/wM21H
3neBBrBIIf6X0rABT+i9LDCMNABeIqKwDLYGTGXEQD+caAC7TcVjYYv12M/i
A9FingG0n7t+w/1qPeZzlZ2i7TjERfE63Z/q8P1L1Pn2TIbgyhqsT+RWi3tj
fE7McRlCv22gpINcLSZIeJsaJGwIFWM5X2mP12KH1KjwBFVDqKL7VRBdX4NP
3ZwzL/MzBDyxQmlOU4Nznr2m2Ww1hF6a64NhvVW4vYol5fIHQ3AioDM8KK/C
a7XnD8gGDIG8I8VvMLEKGzcJLrMsGEKc80e5APkqnPz9g3sRhRF0W+k385a8
wOqrsmrvpIzgGvnBitL157iZguYfbaoRyBcrVaWyVuIQ96SI/etGMMvv0D32
vQLzte5v/Mw2AstSgYt5lRU4+/yvhVcFRsDbyRajBxXYa6pt2P25ESg/yRBI
9HmC6evO1zYOGkHo4Kx0bm8Z7qZZFHs4ZgTtinPJfEVlOMbXpSJ92gj6Cm92
MQeW4f84DB+4LhjBgvZnOzqqMtx6lS/r+IER/Fz2mjI0KsV+zqN+zmeMAS8n
Mdj+KMFcTcbzuoLGEFI3Vh3dWIIHGTtdZcSM4e4i4dD69RKs+rHG5piCMZSI
vsVDsiWYSTZdq1bfGGoVZ8qCMh7hdkoVHvLzxnD/wDDYTv8hZmkoGX3ebgx5
j/zDFAjuY81jBERHuozhyqVR3c8jxTjEwZrPuscY2I7rZb2oLcbdJJTnCYeN
Af37sWjrV4yjjIOpTJaNgcBWbFxmvAiP/aeoss5kAk/op7yJ8u7hoyjX8xy7
CZDXG4TpWN7DUlnL1/O5TSA0+kQJC+M9fE22eERNxARKNid5DXMLsXIiaViO
mgnMz1298l/eXVzI1lsiHWACHb/uWRG+ysfdQQKfUkNN4AwRe5R+XD7eak9Y
Hw83AR/HBS1arXxs4CMDSQkmYN60S7s/cAcf1OUPD9w2AbO3ESNqf/Kwk5EH
ZXi7CcxNNr7oMb+NuRL2gl8ymQJF/qByu00unmyMKtlkM4U/dTsZLKK5uGBl
b0SM2xRirbsXu4lzMaPDvtpjYVPwl8rakHyagynk/zLkqJoCc0tSHx1ZDl5d
/tfo72cK9VrZ+6Gd2fgpb8xyabApjBSP61HcP/yP2R1wfb9gCoMGEYS/o7Lx
966DqzZxpnCR9xVLsVg2HnpI4HDupik8nDm6evNuFm61ISLibDUF41sUoH4l
E0dnxcvYvTWFrzpL38JdM7FCJ5HvrW5TYAtY91lTycQ10sTfjvebwvL3/F63
gwxcSkNS8ufXId/JbbHK/XSc8e6Izjc6M9B90qp7nvo6dpAgz072NINhyemD
vfRULK9qkuTlZwaNjVXHxR1SMb1JfqR2sBmIh7/maBdOxV3Bwq7HoszgtpRR
9t6nFCz1wlgqI90MMvYVi8tPpOBjYncGbtaawfHn4z7+FUn4J57tvvjSDJ6/
GH7CFZeEWw2FXlu9NoNrus1RAhZJ+EJgy2OWLjMIqwu0ECVMwjNPZ8ILx8yg
yCqb6q/NFdwgLHiqhNgcgjwXWHjZEvEN5TDq5KPm0P7MTqBpKwEH6DcTex03
hzFmz8sFXxIwt7/hIv9Jc7gR+rFT5koCTq8Iba4UMIc6C8Gfbavx2E2wybHW
2BwSPruldgzGYVp+/Ycd98zhS39i9/rjGOwiHqFG/cgcJJpyvN08Yg7fA49m
rMvNQYM7vsqONwZb6Pzl+F1jDnM8B9OTDy/jAt/Ku8zd5lDttXr3RHk05nt6
/FbAhjk0Jb2awR+jcGSdvEzjrjl4RRxPq8iOwh9a3PuJD8yh+aKGXaZ1FA74
3EyXR24Bpd/bHzfOR+KaFf/MdnYLCD5e4BVOGYlBsieVSdsCKEj/wbBXOM5W
/MPnamABf5VKzbRlwvGs2pnOSlMLODE/TMdFEo6TzC6TqjlYAOeGrwRF8UX8
8bxIgn+oBWg7azXenbyArRrSL7XdtQD+pYeRbIHncaCyYaDfmgW8XnjaJdYX
gifY1Xvsti1AcrTRo6syBBsQyAvr71tAMwGPe2lqCBZq51oQJrWETNleN1nV
EPyf1pbHb2ZL8OIZ7k+rC8ZuZncdQlQswXTyd0/ukyD8TTq72UXTEsRiRlct
rgZhtZPJrKa6lnC8itDfwjcIc40EjUiaW8KIlV0alVAQnnRUt9j0soTqsqit
CqdAbOO7oB+eaQlXTSs6W5P9cZfeVIVXriWcvt3CVGzgj+VE+o9Z37GEhm/l
E78Z/PHJ1ZYu+YeWwOPgF9X/yA9/u5CtsVdvCd4h136Udftiw3h55cuTlrDW
81fx7VkfrJ6XLJQoYgVmGb8JYgU8sUCoo8yEpBVod9uyb+x6YBp9WZCTtwJG
zvHfn7o88BjBnOmimhU479XYPvPxwGFemlFm1lbAQUccc+KFO34oe6SbJ9EK
yJ7yJZcauuE02vGvl1OtgPp6WedJXjcctFAzPpRuBUPjF2Wn/rhipXtuq9fy
rIBWwKw+4rEr/kbawbT51Aqmm2oFXpG4YpKBeM+3w1YAdl+Nx3qc8X/PbIJP
T1qBfUiWQFqZM/6SKhEV8d0KZD5IyCQlOuMC5Zl04d9W8GHukrmHojOWeqRS
l0tiDV/O0vDWVjhhtzCCIx6i1mDs9vIsuYIj7jhx+T7pFWtYJZC5+dnJFit+
ufTyXJo1HCz55YXz2eKq61F9KRnWICoql5q7YoPvHY0gOnbHGoBK1vdsvA2O
/BfqQv3MGo5c13qZVW6Nxf/z5mIatoY9jaTKRmorXPrYS8F6who2Mi8+k56w
xOzuniZ3Zq1h++5+zslKS0w55RbPumwNxXR9b8n1LPF8v+MMB7EN0Jx9z5yV
boEL35jf5xe2Af4/vVTRvOaYIcbspY+EDZhOPUnZ2TXD15RM+57I2kBDTMjV
Tz1mOKLeiEhE1QZc7Zkt4iLMsFmlrouEpQ18fSwhvt9niinyVLgU42zgw7VN
vUe5JvhikPB9vX4byDoeuIbNjTAl2WaE5IgNFAztic1IG+Giu03GLJM2oKb6
8UkroxHu7tYlnJ+3Adpc1+POVYaYldfHKWH/UC55917hGwPcNlzC/pLbFhbk
Bc4Zb+phi6CArSI+W3jnwhhc06yHF0hlepKFbaGfbsw5PkkP00u9jTaXtYXP
o/EBtsx62DN9dmxFxxYOFG+jRTVdTKnGkX82xBbEtaz/G3uijYuG50KoLtrC
mXe7PzIitbF00DOdzShbOBZBlFmsrY0d7qI/bVcO/V0IYZiY18Ivtu2sHfJs
YU5PVKVUUAtbVOSdzG21hbabjy1+vdHExQx0OUTUdqDA70ZUJKSOKx42M5rS
2wFPQ+nVYiJ13CDplfeA2Q4uqvPF/BlSwz3GzYXqPHYwOlrY+SxJDe9f9yxL
kreDhUFtc/qfqtiCtKmFws0O/KhrvgvXqGCXXA8VW287yGLR7zPNUMH+PLQd
TwLsgEOT+/w7HxWcqOrRpRdhB5EBZ50yuFTwi8s039LT7eCmo9b1wlzAlNtu
v0402kEDB3mtzQmMmZKo/Vxb7CCB14SsshdhboaXy9XtdjA0WL55JQthBUnq
DbMeOzBSf2H+/gTCnoGN/27O2kGLERmzzyll3DZ3nP4UlT04HeVb1FBXxBeH
6hC3qz2wBIv9F74ki4tAII7Zyx4CR/9VbLTI4u7Su+3U/vZgeU1ksjtTFrNG
JGrtX7CHud+xvQnSsriV2cSkP80e6q7qLtAnyGAK2yX35Cp7yP3PSI1TRBpL
tjuVRtfbQ7VGt8kGiTS2E/z2X2iTPRhSHPU9OSaFn+29DHR6Zw/zIsZGulel
sFlBSoT8iD24Xg8B6yVJXDjOfX2B0AE60n39rr6WwO81bn2eJnUAa/u2TqZ8
CbxSSXFi6JgDHFCnEi5dkMBql1dvdjA4QBz5iQlPUQk8z/666C6/A4x7FHvf
fiCOxZ1sagyNHWAyQL0v+LYY7pjJHK0ucoDEvJxM5CyML4sICmU9coCKlfVX
iF8Yy0W+vRRQ7gAsiQGPylaFcAXtHzb+mkM5wealpgQhnAOuToXvHaBWb8yt
tUIQuxVK/0hZdoAot1dEt2gFMPt/n6U91h1g5VPsp5+T/HhI2idJbccBuLT+
0819yo/1PhWe/UfoCJIhUvnH9Pmx1D6ZTyiDI2TAseM66XyYxGZk2V7JEVbE
+tgucp7FLY/CsKKKIxSGREY5bZ7B4atUmUyajvCZvGrmbtcZvJiiJv7V0BF4
bhGdOxF6Bn+rrwjVcj309+On3JcuXvyQIWZHIs0RyptOfGdJ4sHqvdxER4cc
gbDoWe+GNBc+z1D812DcEcRbHX8a0nDhEmv23dwZR9AIjfiw8x8nJpthWuFe
coRLN8gSxIs5sfsu6e/ThE5Ql9HhJ0zLifko9scUGZ3A2f82bfbf0xgqXtpM
MjmBaJT4QdCr09jKIGIo/pQT0F3mKh6KOI1Ts7e+dnE4gVv160fKO+z4P5bV
bktBJ9DkSBOGPTZcKfizIRScgI9F9agiMyt+9+mhzEk1Jzj6XiKVd/IUngh0
rXmpcRiP2ogt5dEpTFUz9YxQ1wmIAykev5A8hYOURksyzJ1g/VyWW5Q5C5bQ
/5LzxMcJaDTeXGN5yoQbAl4GzeY4QV4vw63gSgbsGG3fY33LCf40Xoq9m8CA
Sa8RCH3Jc4KeJTk2FhsGbF6mOddU6ATFT/WIiY8y4LXZPvubpU4wxtuyGu9J
j4WsF3S0m5zAN//15wYpOvzVM730dYsTNOtJ3iyjpsORF8RJZd44wT/lZ2PT
/53AXTcuvuF65wRpR+o+nLl/Anv0EMvtf3YCdTs1p3W6E7hIjZX32awTKHIn
NHKT0OJzJq/jeX86gdRRTyGDWRq87OQylT9/WP8i7736NhqsfLk0P2XJCeK0
LTrPxdPgkQapEy7bTkBeSz+pQ0KD6UX0D+iPOUOTmWDu6hkqnMp0eThSwhmK
G0SoxusosN+DbMoz0s4Q2ZbgTBxDgQ1EHuNeWWeYalmMKDxHgenVvzw6q+wM
pyWrWEVHyHFhIFfIt3PO0FXqy1hEQo6r3r2jELF3hlNMgTmb/mQ4x3hUedjR
GXoqqRd3lcjwxbHfQYkuzhBzTLTUjZIMK60xDY54OkN30iaJTwUpfs/m+yA5
xBnaB8vM2VaP4LEwaqXpZGcQLXj1KPQaCW454A68luYM66/uDUc7k+DiNLn7
sted4blu/dS0DAn2KHI+mp7tDHzBWRdrZojx6ofqbwp3neHXXa+LgYgYk3Jb
+edUOcP9srjnRUeIsFhvUeG5cWcgpa0NrCg4QKOfOq1+TjoD94g6RZftAUrq
XjlxZeZQTuM64HPqAI21Q3LbnDNMePt0yRf8Qyl1U4HKa84QRXMhe+7BXzSV
z6EiSeYCtldzHxd276Grt7X2esldgIzZciI7aw/J5AbVBlG6QL3dsNi+1R66
lt7K/5TWBZjW2J0Efv1BcnFOJ/hZXaDSjPPPCNUflOlRNMsu7gLmPpQCbwN2
kKJr591mSRfIfS5nW6i0g346rljaybjAlYKEyAmKHaRkDR/zFF3g7hSdfGbp
NprXnaqh13SBJcp/Sg/mtxCIcyRR2LoAgRPx+4HITbSyd49vK9EF1rVnDdVn
1pCAe0WbZ7IL9N/74MjSsobcehrshlNdoEAVVUvfWUNDRb2ZTekucO4ZHZWC
6Rpq1SDejb/tAix6fIq+nasoI8Oji7rCBejjV/oIXq+gzp0Q17inLqBdaray
XLiCiFxi/q49d4G019fDWWJW0AWp2+IDtS4Qo3Rl8SysIIfhrryC1y7w1mCx
7HTabyTCLezD/9UFMkUCb7tULyGva/Ik+f0uYMhAWRQXuYTub2oUUg65gPjl
yMzjqkuIsdOh7/eYC9z+1PTbq28R/fPLVKj76QKWHAShJ3cW0Ke6dQq1Py7w
PIg176HFf8hP5+UTO05XsLtmrGdpO4emReVOEfO4guJxApNhgTlkwVCXVnbG
FXT2k0hb//xEKlMvvLcEXYHHzVG5If8nYrxQdjZTxhXC0odUlWd+oNbi2w/a
dV1hNZelZCH2O5JOZqTzMXAFc/3oMzYW31G5X048jbErmCyJknMKfUe5spnO
9hausI49qGqHZpHPp+TT206u8K9RKmxGehbR717IF7jgCu+4YKHxYBqlTmxQ
9Ia7AjXbzWLbkWn0rz0k8mKUK4jXBP/SqZ1Gv9IDrDtiXcGjs7+G2m8atfB4
nHS46gp6B95/OcankJeR+Y2sIldIsG65Up83iZofS17d6T7kX7sTGdM8itp2
c0eCP7lC1PqDFw3Jo+id7g7/wmdXcDKnErQxGUU9v5s6x7+5AqltSF3f/Aia
kNUkbZ9wBf40Bv9ElhFE0GkVd33NFVy6TSJUMocQCcurL6SbrrDx/Lb8A6ch
dNSPjSN22xWG/i5qO4sPIVqamZaQfVfgFVpI/f11EHFZ+e5bkrrBtfYcexW2
QaQ+H32Ri8UN3O58aOZp7UdaClPv8lndQKvwV/if3H6kd02VkeG0G6g/+77K
6dePzMXIasl43GBx0PyRK3M/8gjPXFsUdgPnGXxQdPEbSj76wL9exQ0E72hQ
xqh+Rd18na563m5w/9/Y4MTxXnRzUVmh0fdQf3XZ7PzSF+T6vJrmTIAbmNOF
+2l/+oL2Ze81H4S4QXM5cW7p9S9I9NyFk9WX3KCM+pW0DO0XlOPO84E50w0i
XzwMsdbsQU78d4qTst1A45venc+UPUh4iTp8PccN+m78Y6n++gm9C9vj+ZTn
BtqKT1daXD6h3YS+y7EP3GCl4ta1r1c+Iof7sRJzdW5AVtGfrDrZjQQ8to6a
NbrBg4ghObGKbrTN7zfZ+soNnj8t3Lsc0Y0yX1heu9PqBiSUlr1KDN2ovVXk
p363GzAHDU7zGnchvsmxvJpxN3jT/58q3ch7tHpKnjCexB0e9YU/6hZ8i3Zs
OSq5ydzhHc8xOl6Ct4iggMz6Lbk7hD7IvTT8rQPRsA48P0rtDjHsRHb6MR1I
jDXUKYPZHYwonrvqD7WjINbK1wUi7nAh5Aw9/Z02FG6X44vE3cH680jYy9A2
FFsQdXJK0h2KRspnnum3oUxWnUBueXeY96n0vkLUhp6zzrGXq7nDdzx3pyvw
DfrNynm53sodZIXPuYpYtaItu6MC1rbusKVmI3ZJphX9K/jd/8feHTwfOgVT
M7QiKrYWYeTqDi+vJ8sdLXmNRNhsxzv83aH2TlWh8MMWFMCWq9QX7w7cTvnk
3xqa0BIb+d5ihTtM+fCkpCg1osTub0nOz9zhVUz82T/HGhHLxaITAy/cgUrP
Q7xrtAFpfZEVeF3nDkpbDU2XLjWgh/Ee1lmt7tD/It73TFs9sp1rr5f+5g4/
Sqzzluzr0NqNDLXyAXdYP/7y4XeJOpQCtp/Zh92BskMkVuRoHarLW/tJNuEO
yfn89A3VteiEHifjyJw7nFQx7cuiqkVdzy+HXd5zB77oLKWRvmrkZK9DsP7X
HRTUMndrK6rRFjnjNU8CDxDaVGEeTapGPK6VD4yOeIB8V47+gWI1imUY6+Oi
9oALs0dti8qqkGykvPh7Lg+4wtPxuyfrBXqktrFEreMBEmcdY9/wPEPhfuKG
jXoeMNmpad87+xTp5AY8dzH0AMZdhkKvB0/R8s/5kFozD3ibTrHOx/MUyaSN
b9s4egCZ9v71PsFK1PnlHWFJmAdkuhzjmTB5gu7sErsaXvSA3Ugysh/MT5Af
l0rHToQH6AzY1bpMlyPasFdJujEecKO5Lr0luBzZnHx+bDXVA5RtfXvGb5Wh
Rfs8BqV7HnB0LGB4YecxakkauPCj+JBvz6sHv989RpnP6IbSH3rAq1t05ba5
j5E0Yfqd6TIPYGusIfSWfIwuP4w/nVzjAQ9IFUJVwkoQ9YIvf1+XB6zhwmSp
o4+QRDhS9trwABqv5T+fQ++jG8edLn/f8oACvzWWKcP7aON+3GunXQ+4t+Aq
IyN0H9V96lCx/ucB880sKlU/ipEit66mzlFPQDk8TKO2xUi9x9JQiPUQC80+
jDYrQo9cIzJL2T1hb7Bl7plUESLdvdPLw+kJhF8jWTkYilAn94Qp2xlPAFPC
1aDKe0g/ws2KSswTpJkWRy82FiILnmDnFTVPqDtnrG8yV4DqG7Pv+2l6wsRu
xkuyZwWIybBmdl7LEy6K+L8VuFiARiK23af1PaHAJsSr7mgBcvwc7dNn6QlE
/gzkn8TykVdkWmiNryfIir+bU8/JQ1FfHlwJv+EJU5Wu1iwPbqKHg0P687me
cLqaJXrq4k3UM3Gc0eq2J3yPj+bb1buJuJYulsje9YRB749lp3dyUSe53vut
Ek8g1sv1EzPJRfRqG0fPv/SE7aidkTH6HIR0+Hu/N3mCN/qkkbh8A3kaO+SZ
vT7UpzZZCOu8gV46dvJLdRzyJWmpEY2+gZwuFeisf/KEJ/c/8+z/ykYVterX
gqcP6/OVoD7qSxYaaIowm571hA22OZeLT7PQQftTVuOfnpDfpUBYcy0LmfQx
VYoteELe0qTgsnYW2lle/PR745D/hdHfVu8zkTpfLnXAUS+oChINg/wMNH7n
R7aPqBcwhazHdJFfQ6rs18SoJQ7xRq74q89XUUmxRE+1lBeElvMx8N68ioJK
Y8j/ynvBsmZnnj3PVURSxxyboe4FqfZftzQ105Bgr75/jbUX/N2zUhK8l4Iy
zTYorO28oPsRybyoXwraGLxT+tfBCySrYngL5VNQy8TcrKabFwzsrs9U9ycj
k8U4m+EAL+BV+0dYeSIZRZDVnfuX4AXyN8IenL53BU2k2f24n+QFxmgj3ybk
ClKlIk44l+oFe9sc2msaVxAlg1FLZroX0CdbdkgtJ6Iirv+kuPO8wLS2ImZV
NRG9V2bn0nrqBXk3nVTL9+MRQ1jSftaQF5R7mr11rYhFR91oI8lHvSCoKHqM
71os2jct2I4d94LhiCsqQn6x6Ltk1VrgjBfc/KxAtSgUi2rWx+f1F72gOij+
/hWXGGQSKt1PTuANc755aV9So5Gma6tJHJE3pDiMmNcbRSMFU90vOyTeUJhZ
FkvJFI04JZ0/zJF7Q4fIjcf/Hl9CK2vX3ryl84bjMsOCCx+jUEbI98q4s96Q
mNleKSEQieJdAgV3+b2h9A3tbOF2BLpg8qc0SMgbNnmTxv3eRiAHCZqHjuLe
4I9+8Qq6RCCRNcU7yorekE5U/ZW1KBx9DL6RtGvgDS36T1NlhC8i8mBVx+AL
3sD8utn8dnIYkhtHVWwR3kAVU/rojl0Y8tJWPNId5Q1W6yX7W+Jh6B2n1BOu
OG94OV7y/uV4KIrv493+etUbMnJ/NdjIh6J9SfIMmWJv+BO30ONAEIIEi47M
zDzwhgc/28IqRoKRDSWRdEaJN1gU8B/Xrg1GDd//jMw98YaTpGvRfr7B6Hzu
4pm8Om94++pmus5oEFre+tyy98EbBndufKjOCkRsrh9pS3u8QWVpY/OWYSDS
+9zpZtbrDZ9eimeSUgWi8sdvKCoHvAFf/Xnr8rUA5GlVbeEw7Q26ki4VLzP8
0VTjzeXWLW8wTTVMCH7qi/ou2bMncfqAQ+YFulYNL9Rt47/Dy+MDWIfj9BCd
F3ojF9339owPpLHNdFrMeKLnGwVJR4R8IL3q/P3EWE+U7je2nCjjA9ramgNX
33ggXTvb1wm6PkBldMLhtrk7UlXwzeM28IHh362zL/ndkQJTVGi7kQ9USznk
y/5zQwLf7pwltvAB0p97zUqlbuio3khGvJMPSLj6vXUmcEMditZOced9QGlp
0f9SqwtqYvZW4Aw/5Gdorbqc54Kqt8Pp30T6gEj7jPWzUBd0v/p2J0GsDxyN
Nf7MyueCYgWHxGLTfICgXNz+Ro4zUjplSRhzzweUQx1+e0Q5odo/ZvcvdfnA
zFt/UaNdO6SkoW33+4MPeGpJ07x8Y4faMpQZXXp8YKt//2Z6mh3q4TmTdu6r
D3zm3PUMY7ND8wbbwSfGfSCXL2uFVcsWsT7IUyld8YHR4tYymefW6P7S9T2W
dR9IbYuXWb5sjfjl4muvb/rA9c/mhiQG1kjmkw9/6B8fsG99rqO9ZIWMthVp
EYkviLxOouUWs0KJuhNTX0/6Qu8DmpXodxaI4mbfHU0WX4hrk+f6eMcCZU29
M2tk9YXhE278AYEWqPD8s85CTt/D9/KSzBNmC9RwL/a5t6AvsFe8+bEdbI4W
17liD5AvVHPJCJuLmyHTAs/Tgh6+0ElMdJd3zhjRu3562uflC/WKtwr/e2OM
BvglUaSvLyxIRx//W2CMbOr/2XUF+cKIws0qMjNj5NKXe8czyhcaP5rX3H9r
hIKOdjA8zPQFI48Vtq9+hkjiM/8j3Ru+QCRTZBYhaIg2cjOk1nN9YSfxgv/j
/wzQRW5bU9V8X9DcSl246WOALqO1zKlHvmCoavzpYZA+uh7GQcn2yhcKGIdt
M3N0kYFiUn5H8yH/rUZvaVtdREO0KODXeoiB9bUxly7KyajXfvXWFwJLDC0W
X+iggnKDZOsvvlAZm9qYPqCNyqcuEd384Quvn5AkNEppofd6wztUNH7QSNIz
mI00EFMst1fqCT9QbgxlNmbQQF7V/oPEDH5ApY/DHRfVEQULUd0Osx88TFLl
88lXR3pzAqEz3H5wuTcm+8xfNdQXd2mpVtYP3Ii3rRp7VBF37Ts7MQU/aPdI
4ZAsV0Vh8zQfy5X8QO/rg8H1K6qIwfBR+T0VP7h1oDN/DqkiK9Yez1RdP9D5
YvxesEoFTdSdnrFz9AOLiV3/wBJAov95Gw86+4H2XedW5iRAsWw1rcZufnB3
AY0TeQDiTNS6p+ntB2eebuRknAHkZhxsJxbqBxQD8xXHzDH6b6FtgDjZD3bE
x5QPIpXRFofHh/KnfiDEdAXrMisg6nftb5he+MF5/jMqd+bkEZ8vZ0NStR/Q
TD+dOFcnj2xqxx66NBzG09nmaTKTR6+1TS+ztPmBiGOVz2auHEoJAfG0fj94
ejSbjp5fFhWfLDy7M+gHZJ2FOnv7Muhl0x6bx4gfFEkkhcv0yqBF0noK1Uk/
WLn2SqIkUgYZ5wt/3533g2ffd/9Y90ojlg6WW977flBfzC58/boUkvQOvz74
zw/oTz0x9/WQQnpUAwkahP4wArX/bmApdNkqK4iT1B94rxbdb1uTRLOLZDrD
1P5QqpExd8VOElUwbO5rcfsDw1ruLWFlCYQ9P7vw6fiD+9fgUzGiYignpVDk
g54/ZHn0Zp+gEkPzZf5//A39wSthRWhgWBRlLh7LrjbzBx+HcNI+C1E0E6z1
Bjn6g+hbnjRaSxGUdOnNafMwfxhWDLRsDxRCI3czF7Yv+EPmlrwuhbQQEn3t
WH8nwh8aJ0tDuv8IoiHCfwZTl/3Bk1z9RlWyIBJIVrjsm+oPFl0P28keC6Ce
rOqxuEJ/kKCVFtn4w4e4quNLeYr94TjLsJrDez508Ztx2PsH/vDD5um8RA4f
4ji5cux4mT8Ey3b6MYnyoZACIcXb1f5g5Ceh0eR9FjE+fpT3tNMfmF+IOz5f
5UUOTbcsRtf84f0/mr/fNbmRqo4ukfGmP0TdJGBo5uRGvEP/Kt9t+8McY+qX
sX2uw/nhfqRq3x8sn2aRr1ZzoQhBqZoU0gBIvnDU056XC+Xc+UIrwxIA3P2V
En30nCicL7H5CWsAdL9laf6xzoFs62S9OU8HAAWN/ku5rxyIq6+wlZInAOTt
KU7mZ3Og5+T+gbPCAaC6PX1BnZ4DfQgn/5SpEgAzGTUhKRrs6ClpczipegBI
MYxbiB5jR9k5QTyXNANAU263WrOXDVk9H4zy1A0Auhx0pd2BDf2ceySAzANg
Qd1efuIyKyKyVE1Z8AoA05yzD6b6WJCcdJSaZmYAbIwxX3/TcRINRKkKHLkR
AOedG08+yDqJzreR03bkBsC/O2pJaw4nUZXh7QmV/AB4rXX68uAfRiTkUxuh
XBIAb5q6ZopkGRHHvd/PpJoO82mJv+LbQY9aftTdXG8JAG97u+Q3t+iRvdDl
6Ko3AcCQxnnvoi89utNIqSv2PgDS9TI+ENDTI/pv/D8F+wLAxn46IsibDpGT
u7FyzwfAzVt4kIX3BCo1FCSe+S8A9F48u0X/jxZp3lz7VbQUAOsFjaoug7Qo
kTuunn09AHzXDfK20mjRP+VCE5Z/AdA35Xt8ZZMGrYUMpdDSB8JVbaPTbLXU
KLPxXuAXxkBQPH20eSGIGokSeFpkMAfCbbsLFPrC1Mjv+ib38dOB4Er9r7zt
MRX6+fjE66MCgcA2a/DN8sFxlLg8/Oi9UCD8ueXQmOd6HHFLF19LEg0EP6bo
Vjee48ipTdSGRDoQ/nJ8vJn1mBL9O7oN7bKH/qJ+M656U6K7hi1n4xUC4bcG
2al+IUqkdPMKlYpyIOTnFkUrrRxDI2N6mwc4ELa7FoTP1BxD/wNTi11s
             "]]}, "Charting`Private`Tag$385807#7"]}}, {}}, {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 1, 1]], 
            Line[CompressedData["
1:eJxF1nc81d//AHBbKCNlZ11k73Wt9+vea2RFpaGoEBEVUmSk+ihpERqkooQo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             "]]}, "Charting`Private`Tag$387352#1"], 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[1.6], 
             Hue[0.59, 1, 1]], 
            Line[CompressedData["
1:eJwVV2c41v8XRkYiKytkE7L3eL6f77F5bBHK+NmJrKyEoiIUshqUGaWijBSS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             "]]}, "Charting`Private`Tag$387352#2"], 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 0, 1]], 
            Line[CompressedData["
1:eJwVl3c41t8bx22JyMiIbLKyt+fzObc9Hh47lGRky4rMjERUylekMkJGSKQk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             "]]}, "Charting`Private`Tag$387352#3"], 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 1, 0]], 
            Line[CompressedData["
1:eJxF13c81e/7B3CzPiiysvfIyt7jfV+Oc46VmZ3KSlYZESpEA5WSEQ6KMgpF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             "]]}, "Charting`Private`Tag$387352#4"], 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[1.6], 
             Dashing[{Small, Small}], 
             GrayLevel[0]], 
            Line[CompressedData["
1:eJxF1nc419/7B3C7UISS7J2y9/tlnHPzRlFGiChEtsoom6ZEpWQkUQgpFTJC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             "]]}, "Charting`Private`Tag$387352#5"], 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[1.6], 
             RGBColor[1, 0, 0]], 
            Line[CompressedData["
1:eJxF1Xk4VV0XAPCMRZkic2YyyzVeXHddQqZEt0TIEFIqicjYINKAUBKiMvTq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             "]]}, "Charting`Private`Tag$387352#6"], 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[1.6], 
             Dashing[{Small, Small}], 
             RGBColor[0, 0, 1]], 
            Line[CompressedData["
1:eJwVV3c4198XNxOJZM/s7L193u977D1TRvZe2STZyaqQkMqeJS0qFUmSkJXM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             "]]}, "Charting`Private`Tag$387352#7"]}}, {}}}, {
      PlotRange -> {{20, 30}, {0, 0.008}}, DisplayFunction -> Identity, 
       Ticks -> {Automatic, Automatic}, AxesOrigin -> {0, 0}, 
       FrameTicks -> {{{{0., 0, {0.01, 0.}}, {0.2, 
            NumberForm[0.2`15.954589770191003, {
              DirectedInfinity[1], 1}], {0.01, 0.}}, {0.4, 
            NumberForm[0.4`15.954589770191003, {
              DirectedInfinity[1], 1}], {0.01, 0.}}, {0.6, 
            NumberForm[0.6`15.954589770191003, {
              DirectedInfinity[1], 1}], {0.01, 0.}}, {0.8, 
            NumberForm[0.8`15.954589770191003, {
              DirectedInfinity[1], 1}], {0.01, 0.}}, {1., 
            NumberForm[1.`15.954589770191003, {
              DirectedInfinity[1], 1}], {0.01, 0.}}, {0.05, 
            Spacer[{0, 0}], {0.005, 0.}}, {0.1, 
            Spacer[{0, 0}], {0.005, 0.}}, {0.15, 
            Spacer[{0, 0}], {0.005, 0.}}, {0.25, 
            Spacer[{0, 0}], {0.005, 0.}}, {0.3, 
            Spacer[{0, 0}], {0.005, 0.}}, {0.35, 
            Spacer[{0, 0}], {0.005, 0.}}, {0.45, 
            Spacer[{0, 0}], {0.005, 0.}}, {0.5, 
            Spacer[{0, 0}], {0.005, 0.}}, {0.55, 
            Spacer[{0, 0}], {0.005, 0.}}, {0.65, 
            Spacer[{0, 0}], {0.005, 0.}}, {0.7, 
            Spacer[{0, 0}], {0.005, 0.}}, {0.75, 
            Spacer[{0, 0}], {0.005, 0.}}, {0.85, 
            Spacer[{0, 0}], {0.005, 0.}}, {0.9, 
            Spacer[{0, 0}], {0.005, 0.}}, {0.95, 
            Spacer[{0, 0}], {0.005, 0.}}, {1.05, 
            Spacer[{0, 0}], {0.005, 0.}}, {1.1, 
            Spacer[{0, 0}], {0.005, 0.}}, {1.15, 
            Spacer[{0, 0}], {0.005, 0.}}, {1.2, 
            Spacer[{0, 0}], {0.005, 0.}}}, {{0., 0.}, {0.1, ""}, {0.2, 
           3.480000002376827*^6}, {0.30000000000000004`, ""}, {0.4, 
           6.960000004753654*^6}, {0.5, ""}, {0.6000000000000001, 
           1.0440000007130481`*^7}, {0.7000000000000001, ""}, {0.8, 
           1.3920000009507308`*^7}, {0.9, ""}, {1., 
           1.7400000011884134`*^7}}}, {{{0., 0, {0.01, 0.}}, {
           50., 50, {0.01, 0.}}, {100., 100, {0.01, 0.}}, {
           150., 150, {0.01, 0.}}, {200., 200, {0.01, 0.}}, {
           250., 250, {0.01, 0.}}, {10., 
            Spacer[{0, 0}], {0.005, 0.}}, {20., 
            Spacer[{0, 0}], {0.005, 0.}}, {30., 
            Spacer[{0, 0}], {0.005, 0.}}, {40., 
            Spacer[{0, 0}], {0.005, 0.}}, {60., 
            Spacer[{0, 0}], {0.005, 0.}}, {70., 
            Spacer[{0, 0}], {0.005, 0.}}, {80., 
            Spacer[{0, 0}], {0.005, 0.}}, {90., 
            Spacer[{0, 0}], {0.005, 0.}}, {110., 
            Spacer[{0, 0}], {0.005, 0.}}, {120., 
            Spacer[{0, 0}], {0.005, 0.}}, {130., 
            Spacer[{0, 0}], {0.005, 0.}}, {140., 
            Spacer[{0, 0}], {0.005, 0.}}, {160., 
            Spacer[{0, 0}], {0.005, 0.}}, {170., 
            Spacer[{0, 0}], {0.005, 0.}}, {180., 
            Spacer[{0, 0}], {0.005, 0.}}, {190., 
            Spacer[{0, 0}], {0.005, 0.}}, {210., 
            Spacer[{0, 0}], {0.005, 0.}}, {220., 
            Spacer[{0, 0}], {0.005, 0.}}, {230., 
            Spacer[{0, 0}], {0.005, 0.}}, {240., 
            Spacer[{0, 0}], {0.005, 0.}}, {260., 
            Spacer[{0, 0}], {0.005, 0.}}, {270., 
            Spacer[{0, 0}], {0.005, 0.}}, {280., 
            Spacer[{0, 0}], {0.005, 0.}}, {290., 
            Spacer[{0, 0}], {0.005, 0.}}, {300., 
            Spacer[{0, 0}], {0.005, 0.}}}, {}}}, 
       GridLines -> {Automatic, Automatic}, DisplayFunction -> Identity, 
       PlotRangePadding -> {{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.05], 
          Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> 70, 
       DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
       Axes -> {False, False}, AxesLabel -> {"Day", "Units"}, 
       AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
       Frame -> {{True, True}, {True, False}}, 
       FrameLabel -> {{None, None}, {"Day", None}}, FrameStyle -> Automatic, 
       FrameTicks -> {{
         All, {{0., 0.}, {0.1, ""}, {0.2, 3.480000002376827*^6}, {
           0.30000000000000004`, ""}, {0.4, 6.960000004753654*^6}, {
           0.5, ""}, {0.6000000000000001, 1.0440000007130481`*^7}, {
           0.7000000000000001, ""}, {0.8, 1.3920000009507308`*^7}, {
           0.9, ""}, {1., 1.7400000011884134`*^7}}}, {All, None}}, 
       GridLines -> {Automatic, Automatic}, GridLinesStyle -> Directive[
         GrayLevel[0.4, 0.5], 
         AbsoluteThickness[1], 
         AbsoluteDashing[{1, 2}]], ImagePadding -> 70, ImageSize -> Full, 
       LabelStyle -> {FontSize -> 13}, 
       Method -> {
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
       True, PlotRangePadding -> {{Automatic, Automatic}, {
         Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}], 
     Placed[
      Unevaluated[
       Unevaluated[
        LineLegend[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 1, 1]], 
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           Hue[0.59, 1, 1]], 
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 0, 1]], 
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 1, 0]], 
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           Dashing[{Small, Small}], 
           GrayLevel[0]], 
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[1, 0, 0]], 
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           Dashing[{Small, Small}], 
           RGBColor[0, 0, 1]]}, {
         "Susceptible", "Exposed", "Infectious", "Cleared", "Deceased", 
          "Population", "Infected"}, LegendMarkers -> None, 
         LabelStyle -> {FontSize -> 13}, LegendLayout -> "Column"]]], {{
       1, 0.3}, {0.3, 0}}, Identity]]& ],
   AutoDelete->True,
   Editable->True,
   SelectWithContents->False,
   Selectable->True], TraditionalForm]], "Output",
 CellLabel->
  "Out[378]=",ExpressionUUID->"18b7dda2-d0e3-46f7-823c-15de70bcac7b"],

Cell[TextData[{
 "Now that the graphs have been shown it will be easier to discuss the issue. \
The point is that the SI(EY)A(CD) model concerns ",
 StyleBox["compartments ",
  FontSlant->"Italic"],
 "and not necessarily ",
 StyleBox["events. ",
  FontSlant->"Italic"],
 " It is true that the intervention with the quarantine reduced the \
\[OpenCurlyDoubleQuote]infectious period\[CloseCurlyDoubleQuote] from 10 days \
to 1/2 day. And it is true that the Infection Fatality Factor (IFF) \
proportion of those acquitted belongs to the compartment of the (soon to be) \
deceased. However, the intervention did not speed up the process of dying. \
Given the new \[OpenCurlyDoubleQuote]infectious \
period\[CloseCurlyDoubleQuote] from the intervention, the infected are \
properly allocated to their compartment but we should not assume that this \
\[OpenCurlyDoubleQuote]infectious period\[CloseCurlyDoubleQuote] still would \
be a \[OpenCurlyDoubleQuote]natural or real infectious period\
\[CloseCurlyDoubleQuote] (ending e.g. in death). ( A consideration might be \
to use ",
 StyleBox["D\[CloseCurlyQuote] ",
  FontSlant->"Italic"],
 "= \[Mu] ",
 StyleBox["I ",
  FontSlant->"Italic"],
 "and not change \[Mu], so that the change in the \
\[OpenCurlyDoubleQuote]infectious period\[CloseCurlyDoubleQuote] is borne by ",
 StyleBox["C\[CloseCurlyQuote] ",
  FontSlant->"Italic"],
 "= \[Lambda] ",
 StyleBox["I. ",
  FontSlant->"Italic"],
 "However, this implies changing the IFF. The intervention cannot change \
this. A given proportion of the infected belongs to the compartment of the \
deceased.) Thus, entry into the compartment of the deceased does not yet \
indicate the day of actual death. The estimation on the observed death toll \
requires that we take into account that the model speeds up the allocation to \
this compartment, so that we need a longer period from ",
 StyleBox["entry into the compartment ",
  FontSlant->"Italic"],
 "to ",
 StyleBox["actual death",
  FontSlant->"Italic"],
 "."
}], "Text",ExpressionUUID->"cc9e34ac-e37c-4f5e-a816-87aae2ce7b47"],

Cell["\<\
The conclusion is unavoidable that the SI(EY)A(CD) model has a parameter \
\[Gamma] that must be treated with some care. The reading of 1/\[Gamma] as \
the \[OpenCurlyDoubleQuote]infectious period\[CloseCurlyDoubleQuote] would be \
unproblematic for the natural process. When this interpretation is changed, \
in the context of an intervention, then 1/\[Gamma] is rather regarded as a \
normalising constant and the interpretation as \
\[OpenCurlyDoubleQuote]infectious period\[CloseCurlyDoubleQuote] should not \
be taken too literally with connotations from the other context.\
\>", "Text",ExpressionUUID->"95dd1049-69e8-4a93-9526-e149e36deae9"],

Cell[TextData[{
 "PM. Also stated below: Yan & Chowell (2019:167) nicely show how the \
rescaling of time into \[Tau] = \[Gamma] ",
 StyleBox["t ",
  FontSlant->"Italic"],
 "changes the SEYCD model into one that is dominated by only two parameters: \
\[Beta] / \[Gamma] and \[Alpha] / \[Gamma]. Thus we basically still need \
three parameters, the latter two, and the scaling of time. Their deduction \
however helps us to focus on ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "0dff943e-0458-49b4-ac37-71a88dc2cbb5"],
 " and these ratios, and not on \[Beta] / \[Alpha].  "
}], "Text",ExpressionUUID->"807bf699-a46c-4f77-9d8a-ed8f52e582b8"],

Cell[TextData[{
 "That said, the notebook and package have the conventional formulation with \
\[Beta] and \[Gamma] and only consider this substitution \[Beta] \[Rule] ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "e69ccff9-12b5-49bd-ba19-b5d7be87dde9"],
 " / ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "inf"], TraditionalForm]],ExpressionUUID->
  "4a1ccb66-d7f8-46f6-9d28-bb36b898b603"],
 " as a possibility for estimation. "
}], "Text",ExpressionUUID->"8ff7c60b-d4c8-4c7a-9368-6e19516b1bd7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
1.5. Benefit of better didactics on SI(EY)A(CD) epidemic models. \
Understanding herd immunity\
\>", "Subsection",ExpressionUUID->"6041efdd-7654-44f3-a82f-8d622aa3bddf"],

Cell[CellGroupData[{

Cell["1.5.1. General understanding and communication", "Subsubsection",ExpressionUUID->"f3aed2ee-fc1c-4ced-9d19-3cf1397c3031"],

Cell["\<\
The 2020 pandemic (again) proves the relevance of the SI(EY)A(CD) models for \
the common understanding of infectious epidemics and their impact on the \
economy. The Goh (2020) \[OpenCurlyDoubleQuote]epidemic calculator\
\[CloseCurlyDoubleQuote] allowed perhaps millions of people a better \
understanding, and clarified for them the notion of \
\[OpenCurlyDoubleQuote]flattening the curve\[CloseCurlyDoubleQuote] to remain \
within the capacity of the health system. Pueyo (2020) provided clarity for \
many too. There is common use of the model in the literature (see the \
references). The model appears to be of key importance for a world at mercy \
of the pandemic, not only for education, but also for communication between \
research communities and for the media and general public. It stands to \
reason, but is not guaranteed, that better didactics would be beneficial for \
such understanding and communication.\
\>", "Text",ExpressionUUID->"1cb38325-cfc6-4d89-8271-46e31b3fc3ab"],

Cell["\<\
The SI(EY)A(CD) model remains too simple as a foundation for practical policy \
making (when we have better models, see e.g. Diekmann et al. (1990) and Grant \
(2020)). However, the model remains relevant for general understanding, and \
such general understanding very much concerns issues of strategy too.\
\>", "Text",ExpressionUUID->"e503f974-a7b6-4bbb-b7e7-1df401a1eb44"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.5.2. Interpreting official reports", "Subsubsection",ExpressionUUID->"e1db3a3c-6970-40f4-8f57-d83d45034f0b"],

Cell[TextData[{
 "RIVM - the Dutch equivalent of the US CDC - provides the national reservoir \
of experience in infectious diseases and must have employed more complex \
models than SI(EY)A(CD) for its substantiation to the Dutch government that \
there ",
 StyleBox["was",
  FontSlant->"Italic"],
 " a deadly pandemic. The international reports, the WHO PHEIC of January 30, \
and the growing alarm in Dutch hospitals themselves were factors too of \
course. The point remains that, against this backdrop, the SI(EY)A(CD) family \
of models can still be regarded as a bedrock for our understanding of \
epidemics. "
}], "Text",ExpressionUUID->"966c47c6-3d8c-4a6c-a10c-beb726ab3599"],

Cell[TextData[{
 "RIVM has had a policy of ",
 StyleBox["not-mentioning the death-toll at stake",
  FontSlant->"Italic"],
 " but ",
 StyleBox["focusing on flattening the curve ",
  FontSlant->"Italic"],
 "with the ICU capacity as a target. The RIVM (2020a-f) reports to Parliament \
have a speculation about \[OpenCurlyDoubleQuote]avoided ICU admissions\
\[CloseCurlyDoubleQuote] . However, \[OpenCurlyDoubleQuote]avoided deaths\
\[CloseCurlyDoubleQuote] are rather implied in the published parameters. RIVM \
has reported values of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "a4c50190-9c70-42a1-a729-c60bf8555fb8"],
 " to Dutch Parliament starting with 2.7, down to 2.3 and up to 2.5 again. \
With ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "a4697f72-4e50-48d7-87ab-d0e21f34eba0"],
 " = 2.5 and their IFF =1.38%, the death toll for a population of 17.4 \
million would have been, had there been no intervention:"
}], "Text",ExpressionUUID->"cdb4d0d5-416b-4662-8347-db228e820f5b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Explain", "[", 
  RowBox[{
   RowBox[{"SICD", "[", 
    RowBox[{"Limit", ",", " ", 
     RowBox[{
      RowBox[{"BetaSIA", "[", "]"}], " ", "\[Rule]", " ", 
      RowBox[{"2.5", " ", 
       RowBox[{"GammaSIA", "[", "]"}]}]}], ",", " ", 
     RowBox[{
      RowBox[{"PhiSICD", "[", "]"}], " ", "\[Rule]", "  ", "0.0138"}]}], 
    "]"}], ",", " ", "SICD"}], "]"}]], "Input",
 CellLabel->"In[16]:=",ExpressionUUID->"3c278114-a308-40e4-b198-317dc9a7c659"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\<\"S\"\>", "\[Rule]", "0.10735440307119928`"}], ",", 
    RowBox[{"\<\"I\"\>", "\[Rule]", "0"}], ",", 
    RowBox[{"\<\"C\"\>", "\[Rule]", "0.8803270876911833`"}], ",", 
    RowBox[{"\<\"D\"\>", "\[Rule]", "0.012318509237617459`"}], ",", 
    RowBox[{"\<\"N\"\>", "\[Rule]", "0.9876814907623825`"}], ",", 
    RowBox[{"\<\"A\"\>", "\[Rule]", "0.8926455969288007`"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellLabel->"Out[16]=",ExpressionUUID->"5e2ee815-8f6a-4299-9bfd-cf53b45da146"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"17.4", " ", 
    RowBox[{"10", "^", "6"}], " ", "*", " ", "\"\<D\>\""}], " ", "/.", " ", 
   "TheFormer"}]}]], "Input",
 CellLabel->"In[17]:=",ExpressionUUID->"4792a80d-c544-4419-b228-ed72dfc97f36"],

Cell[BoxData[
 FormBox["214342.06073454377`", TraditionalForm]], "Output",
 CellLabel->"Out[17]=",ExpressionUUID->"4ccf1a57-b7c3-4c0c-bf52-0c34552f2a7b"]
}, Open  ]],

Cell["\<\
The RIVM policy of not mentioning an implied death toll seems rather a \
consequence of the attitude of avoiding speculation and \
\[OpenCurlyDoubleQuote]sticking to the facts\[CloseCurlyDoubleQuote]. \
However, it is actually better to mention these implications, because death \
toll estimates make for a more transparant discussion about the \
\[OpenCurlyDoubleQuote]value of a statistical life\[CloseCurlyDoubleQuote]. \
There may be a difference between the world of Public Health (including \
economics) and the world of Medicine (without economics), with RIVM too much \
influenced by the latter.\
\>", "Text",ExpressionUUID->"b394918e-a838-4438-a9ee-5d196bf1e61c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.5.3. Remarkable statistical fits", "Subsubsection",ExpressionUUID->"2178968e-99e8-4685-8d1c-868b9aebd63f"],

Cell[TextData[{
 "This notebook took ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "1bbe53c8-5645-4d78-a711-3d2b20bd104e"],
 " = 4 from the literature, and \[CurlyPhi] = 1.5 was found by using \
international age-specific factors for the Dutch population composition. The \
explanatory power of the SI(EY)A(CD) model remains baffling. The following \
plot has used SEYCD and shows the fit of the model to the official number of \
deceased in Holland till May 20, to a total of 5748 deaths. This still \
excludes the untested non-hospitalised \"surplus deaths\" of these months, so \
that the actual death toll is likely 9000. For all clarity: this estimation \
is only for didactic purposes. This uses only 15 data-points on the \
cumulative death toll, and includes a heuristic linear-proportional \
back-tracing of the recorded day of death to an estimated end of the \
\[OpenCurlyDoubleQuote]infectious period\[CloseCurlyDoubleQuote]. (Graph \
copied from below.)"
}], "Text",ExpressionUUID->"5038bca9-5a88-47f1-8a64-6d05b409f66f"],

Cell[BoxData[
 FormBox[
  TemplateBox[{
    GraphicsBox[{{}, {{{}, {}, 
        TagBox[{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           PointSize[
            NCache[
             Rational[7, 360], 0.019444444444444445`]], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]], 
          
          LineBox[{{12., 1.}, {21., 8.}, {24., 58.}, {31., 356.}, {38., 
           1173.}, {42., 1766.}, {51., 2945.}, {58., 3916.}, {67., 4795.}, {
           71., 5082.}, {76., 5422.}, {79., 5510.}, {83., 5670.}, {86., 
           5715.}, {87., 5748.}}]}, 
         Annotation[#, {{Legended}, Charting`Private`Tag$390861, {1}}]& ], 
        TagBox[{
          Hue[0.9060679774997897, 0.6, 0.6], 
          Directive[
           PointSize[
            NCache[
             Rational[7, 360], 0.019444444444444445`]], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6]], 
          
          LineBox[{{12., 13.215448657982078`}, {21., 63.13721194194177}, {24.,
            105.61887420730234`}, {31., 349.04619920306254`}, {38., 
           1134.0892931846051`}, {42., 1809.8670276864523`}, {51., 
           3095.0664435794233`}, {58., 3883.7170718765096`}, {67., 
           4684.573880357368}, {71., 4977.315721462212}, {76., 
           5297.497826669397}, {79., 5467.934889816061}, {83., 
           5672.729343904354}, {86., 5811.067896448824}, {87., 
           5854.497215977088}}]}, 
         Annotation[#, {{Legended}, Charting`Private`Tag$390861, {2}}]& ]}, {
        TagBox[{
          Directive[
           PointSize[
            NCache[
             Rational[7, 360], 0.019444444444444445`]], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]]}, 
         Annotation[#, {{Legended}, Charting`Private`Tag$390861, {1}}]& ], 
        TagBox[{
          Directive[
           PointSize[
            NCache[
             Rational[7, 360], 0.019444444444444445`]], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6]]}, 
         Annotation[#, {{Legended}, Charting`Private`Tag$390861, {2}}]& ]}, {
        TagBox[{
          Directive[
           PointSize[
            NCache[
             Rational[7, 360], 0.019444444444444445`]], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]]}, 
         Annotation[#, {{Legended}, Charting`Private`Tag$390861, {1}}]& ], 
        TagBox[{
          Directive[
           PointSize[
            NCache[
             Rational[7, 360], 0.019444444444444445`]], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6]]}, 
         Annotation[#, {{Legended}, Charting`Private`Tag$390861, {
           2}}]& ], {}, {}, {}}, {
        TagBox[{
          Directive[
           PointSize[
            NCache[
             Rational[7, 360], 0.019444444444444445`]], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]]}, 
         Annotation[#, {{Legended}, Charting`Private`Tag$390861, {1}}]& ], 
        TagBox[{
          Directive[
           PointSize[
            NCache[
             Rational[7, 360], 0.019444444444444445`]], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6]]}, 
         Annotation[#, {{Legended}, Charting`Private`Tag$390861, {
           2}}]& ], {}, {}, {}}}, {{}, {}}}, {
     DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
      NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
      AxesLabel -> {
        FormBox["\"Day since\\n2020-02-23\"", TraditionalForm], 
        FormBox["\"Cum. Deceased\"", TraditionalForm]}, AxesOrigin -> {0, 0}, 
      DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
      FrameLabel -> {{None, None}, {None, None}}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, GridLinesStyle -> Directive[
        GrayLevel[0.5, 0.4]], 
      Method -> {
       "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )}}, PlotLabel -> 
      FormBox["\"Constant -> 6.2885, Slope -> 0.754, Plus -> 9.847\"", 
        TraditionalForm], PlotRange -> {{0, 87.}, {0, 5854.497215977088}}, 
      PlotRangeClipping -> True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
    FormBox[
     FormBox[
      TemplateBox[{"\"Observed\"", "\"Model\"", "None", "None"}, "LineLegend",
        DisplayFunction -> (FormBox[
         StyleBox[
          StyleBox[
           PaneBox[
            TagBox[
             GridBox[{{
                TagBox[
                 GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                  GridBoxAlignment -> {
                   "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                  AutoDelete -> False, 
                  GridBoxDividers -> {
                   "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {
                   "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
              AutoDelete -> False, 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
             "Grid"], Alignment -> Left, AppearanceElements -> None, 
            ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
            "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
          False], TraditionalForm]& ), 
       InterpretationFunction :> (RowBox[{"LineLegend", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["7", "360"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["7", "360"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], 
                    "]"}]}], "}"}], ",", 
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["7", "360"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["7", "360"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], 
                    "]"}]}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{#, ",", #2}], "}"}], ",", 
                RowBox[{"{", 
                  RowBox[{#3, ",", #4}], "}"}]}], "}"}], ",", 
            RowBox[{"LegendMarkers", "\[Rule]", 
              RowBox[{"{", 
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}], ",", 
                  RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], 
                "}"}]}], ",", 
            RowBox[{"Joined", "\[Rule]", 
              RowBox[{"{", 
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"True", ",", "True"}], "}"}], ",", 
                  RowBox[{"{", 
                    RowBox[{"True", ",", "True"}], "}"}]}], "}"}]}], ",", 
            RowBox[{"LabelStyle", "\[Rule]", 
              RowBox[{"{", "}"}]}], ",", 
            RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
       Editable -> True], TraditionalForm], TraditionalForm]},
   "Legended",
   DisplayFunction->(FormBox[
     GridBox[{{
        TagBox[
         ItemBox[
          PaneBox[
           TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
           BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
         "SkipImageSizeLevel"], 
        ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
      GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
      AutoDelete -> False, GridBoxItemSize -> Automatic, 
      BaselinePosition -> {1, 1}], TraditionalForm]& ),
   Editable->True,
   InterpretationFunction->(FormBox[
     RowBox[{"Legended", "(", 
       RowBox[{#, ",", 
         RowBox[{"Placed", "[", 
           RowBox[{#2, ",", "After"}], "]"}]}], ")"}], TraditionalForm]& )], 
  TraditionalForm]], "Output",
 CellLabel->
  "Out[150]=",ExpressionUUID->"85acc3fb-2c38-40ab-8437-45a1e8dc9e3a"],

Cell[TextData[{
 "This \[OpenCurlyDoubleQuote]didactic estimate\[CloseCurlyDoubleQuote] also \
allows to locate the Dutch onset to between Valentine\[CloseCurlyQuote]s Day \
(February 14) and Dutch Carnival (February 23). There are also reasonable \
estimates of the basic reproductive factor ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "e0122eed-22af-4805-880e-521a40e456f9"],
 " of the period before and after the intervention of the partial lockdown \
announced on March 12 and the closing of the schools on March 15. ",
 StyleBox["The estimate indicates that there would have been some ",
  FontSlant->"Italic"],
 "250,000 ",
 StyleBox["deaths if there had been no intervention. ",
  FontSlant->"Italic"],
 "It is testimony of the quality of the model that such an estimate can be \
regarded as reasonable. The difference with the similarly implied outcome of \
the RIVM parameters is not overly large. It are the properties of exponential \
processes, the SI(EY)A(CD) modeling itself, and such statistical fitting that \
makes this inference about the avoided death toll so reasonable. The Dutch \
economy suffers a lot, but the alternative, this death toll, would have been \
stark - while it remains an open question how the economy would have reacted \
if these deaths had actually occurred. National disasters were the flood of \
1953 with 1836 deaths and the 2014 MH17 plane with 298 deaths, and we are now \
considering disaster sizes of 130 floods or 800 planes."
}], "Text",ExpressionUUID->"d2b53de4-0dcc-4ad7-8500-9bd012344cd1"],

Cell[TextData[{
 "Above graph and \[OpenCurlyDoubleQuote]didactic estimation\
\[CloseCurlyDoubleQuote] on the official death count figures awkwardly \
exclude the \"surplus deaths\" while the parameter \[CurlyPhi] = IFF = 1.5% \
in the estimation includes them. It would seem that the estimate on the \
distribution of deaths is not affected by the proportional parameter. A \
reduction to \[CurlyPhi] = 1% within the estimation would basically mean a \
lower RMSE. The model is flexible and can be adapted. The following graph \
clarifies that above estimate has used such flexibility. This graph shows the \
Root Mean Squared Error (RMSE) as a function of both the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["R",
    FontSlant->"Italic"], "0"]],ExpressionUUID->
  "283b9294-c376-450d-be75-687d6cf75b08"],
 " before the intervention (",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["R",
    FontSlant->"Italic"], "0"]],ExpressionUUID->
  "57ca3061-a8ed-496d-87ba-7af2ae810f16"],
 "-pre) and the possibility that the onset of infections happened some days \
earlier than Carnival, February 23 2020.  (Graph copied from below.)"
}], "Text",ExpressionUUID->"91310c1e-bb86-454a-bc9e-215865cc942b"],

Cell[BoxData[
 FormBox[
  TemplateBox[{
    GraphicsBox[{{}, {{{}, {}, 
        TagBox[{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           PointSize[
            NCache[
             Rational[7, 360], 0.019444444444444445`]], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]], 
          
          LineBox[{{0., 1084.9217966455417`}, {4., 499.9286312293403}, {6., 
           294.1250884737027}, {9., 114.07994316779357`}, {10., 
           75.43119619333604}, {11., 203.37164005515535`}}]}, 
         Annotation[#, {{Legended}, Charting`Private`Tag$10372405, {1}}]& ], 
        TagBox[{
          Hue[0.9060679774997897, 0.6, 0.6], 
          Directive[
           PointSize[
            NCache[
             Rational[7, 360], 0.019444444444444445`]], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6]], 
          
          LineBox[{{0., 745.80601196887}, {4., 232.1599547034138}, {7., 
           75.57435004285226}, {9., 690.909831544809}}]}, 
         Annotation[#, {{Legended}, Charting`Private`Tag$10372405, {2}}]& ], 
        TagBox[{
          Hue[0.1421359549995791, 0.6, 0.6], 
          Directive[
           PointSize[
            NCache[
             Rational[7, 360], 0.019444444444444445`]], 
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[1.6]], 
          
          LineBox[{{0., 570.7865756784906}, {4., 153.71882925249776`}, {5., 
           93.04718401501316}, {6., 75.10048236910804}, {7., 
           452.8968439183787}}]}, 
         Annotation[#, {{Legended}, Charting`Private`Tag$10372405, {3}}]& ], 
        TagBox[{
          Hue[0.37820393249936934`, 0.6, 0.6], 
          Directive[
           PointSize[
            NCache[
             Rational[7, 360], 0.019444444444444445`]], 
           RGBColor[0.922526, 0.385626, 0.209179], 
           AbsoluteThickness[1.6]], 
          
          LineBox[{{0., 79.3333807522855}, {1., 620.9492622612958}, {2., 
           1093.4814013348546`}}]}, 
         Annotation[#, {{Legended}, Charting`Private`Tag$10372405, {4}}]& ]}, {
        TagBox[{
          Directive[
           PointSize[
            NCache[
             Rational[7, 360], 0.019444444444444445`]], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]]}, 
         Annotation[#, {{Legended}, Charting`Private`Tag$10372405, {1}}]& ], 
        TagBox[{
          Directive[
           PointSize[
            NCache[
             Rational[7, 360], 0.019444444444444445`]], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6]]}, 
         Annotation[#, {{Legended}, Charting`Private`Tag$10372405, {2}}]& ], 
        TagBox[{
          Directive[
           PointSize[
            NCache[
             Rational[7, 360], 0.019444444444444445`]], 
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[1.6]]}, 
         Annotation[#, {{Legended}, Charting`Private`Tag$10372405, {3}}]& ], 
        TagBox[{
          Directive[
           PointSize[
            NCache[
             Rational[7, 360], 0.019444444444444445`]], 
           RGBColor[0.922526, 0.385626, 0.209179], 
           AbsoluteThickness[1.6]]}, 
         Annotation[#, {{Legended}, Charting`Private`Tag$10372405, {4}}]& ]}, {
        TagBox[{
          Directive[
           PointSize[
            NCache[
             Rational[7, 360], 0.019444444444444445`]], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]]}, 
         Annotation[#, {{Legended}, Charting`Private`Tag$10372405, {1}}]& ], 
        TagBox[{
          Directive[
           PointSize[
            NCache[
             Rational[7, 360], 0.019444444444444445`]], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6]]}, 
         Annotation[#, {{Legended}, Charting`Private`Tag$10372405, {2}}]& ], 
        TagBox[{
          Directive[
           PointSize[
            NCache[
             Rational[7, 360], 0.019444444444444445`]], 
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[1.6]]}, 
         Annotation[#, {{Legended}, Charting`Private`Tag$10372405, {3}}]& ], 
        TagBox[{
          Directive[
           PointSize[
            NCache[
             Rational[7, 360], 0.019444444444444445`]], 
           RGBColor[0.922526, 0.385626, 0.209179], 
           AbsoluteThickness[1.6]]}, 
         Annotation[#, {{Legended}, Charting`Private`Tag$10372405, {
           4}}]& ], {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
        TagBox[{
          Directive[
           PointSize[
            NCache[
             Rational[7, 360], 0.019444444444444445`]], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]]}, 
         Annotation[#, {{Legended}, Charting`Private`Tag$10372405, {1}}]& ], 
        TagBox[{
          Directive[
           PointSize[
            NCache[
             Rational[7, 360], 0.019444444444444445`]], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6]]}, 
         Annotation[#, {{Legended}, Charting`Private`Tag$10372405, {2}}]& ], 
        TagBox[{
          Directive[
           PointSize[
            NCache[
             Rational[7, 360], 0.019444444444444445`]], 
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[1.6]]}, 
         Annotation[#, {{Legended}, Charting`Private`Tag$10372405, {3}}]& ], 
        TagBox[{
          Directive[
           PointSize[
            NCache[
             Rational[7, 360], 0.019444444444444445`]], 
           RGBColor[0.922526, 0.385626, 0.209179], 
           AbsoluteThickness[1.6]]}, 
         Annotation[#, {{Legended}, Charting`Private`Tag$10372405, {
           4}}]& ], {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}, {{},
        {}}}, {
     DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
      NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
      AxesLabel -> {
        FormBox["\"Earlier onset\\nbefore Feb 23\"", TraditionalForm], 
        FormBox["\"RMSE\"", TraditionalForm]}, AxesOrigin -> {0, 0}, 
      DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
      FrameLabel -> {{None, None}, {None, None}}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, GridLinesStyle -> Directive[
        GrayLevel[0.5, 0.4]], 
      Method -> {
       "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )}}, 
      PlotRange -> {{0, 11.}, {0, 1093.4814013348546`}}, PlotRangeClipping -> 
      True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
    FormBox[
     FormBox[
      TemplateBox[{
       "\"\\!\\(\\*SubscriptBox[StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"],\
 \\\"0\\\"]\\)-pre = 4\"", 
        "\"\\!\\(\\*SubscriptBox[StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]\
, \\\"0\\\"]\\)-pre = 4.37\"", 
        "\"\\!\\(\\*SubscriptBox[StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]\
, \\\"0\\\"]\\)-pre = 4.55\"", 
        "\"\\!\\(\\*SubscriptBox[StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]\
, \\\"0\\\"]\\)-pre = 5.7\"", "None", "None", "None", "None"}, "LineLegend", 
       DisplayFunction -> (FormBox[
         StyleBox[
          StyleBox[
           PaneBox[
            TagBox[
             GridBox[{{
                TagBox[
                 GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}}, 
                  GridBoxAlignment -> {
                   "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                  AutoDelete -> False, 
                  GridBoxDividers -> {
                   "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {
                   "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
              AutoDelete -> False, 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
             "Grid"], Alignment -> Left, AppearanceElements -> None, 
            ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
            "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
          False], TraditionalForm]& ), 
       InterpretationFunction :> (RowBox[{"LineLegend", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["7", "360"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["7", "360"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["7", "360"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["7", "360"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.922526`", ",", "0.385626`", ",", "0.209179`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], 
                    "]"}]}], "}"}], ",", 
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["7", "360"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["7", "360"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["7", "360"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["7", "360"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.922526`", ",", "0.385626`", ",", "0.209179`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], 
                    "]"}]}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], ",", 
                RowBox[{"{", 
                  RowBox[{#5, ",", #6, ",", #7, ",", #8}], "}"}]}], "}"}], 
            ",", 
            RowBox[{"LegendMarkers", "\[Rule]", 
              RowBox[{"{", 
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}], ",", 
                  RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], 
                "}"}]}], ",", 
            RowBox[{"Joined", "\[Rule]", 
              RowBox[{"{", 
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"True", ",", "True", ",", "True", ",", "True"}], 
                    "}"}], ",", 
                  RowBox[{"{", 
                    RowBox[{"True", ",", "True", ",", "True", ",", "True"}], 
                    "}"}]}], "}"}]}], ",", 
            RowBox[{"LabelStyle", "\[Rule]", 
              RowBox[{"{", "}"}]}], ",", 
            RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
       Editable -> True], TraditionalForm], TraditionalForm]},
   "Legended",
   DisplayFunction->(FormBox[
     GridBox[{{
        TagBox[
         ItemBox[
          PaneBox[
           TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
           BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
         "SkipImageSizeLevel"], 
        ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
      GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
      AutoDelete -> False, GridBoxItemSize -> Automatic, 
      BaselinePosition -> {1, 1}], TraditionalForm]& ),
   Editable->True,
   InterpretationFunction->(FormBox[
     RowBox[{"Legended", "(", 
       RowBox[{#, ",", 
         RowBox[{"Placed", "[", 
           RowBox[{#2, ",", "After"}], "]"}]}], ")"}], TraditionalForm]& )], 
  TraditionalForm]], "Output",
 CellLabel->"Out[36]=",ExpressionUUID->"75a08d9a-4c4f-4591-8aae-7d97aa45a297"],

Cell[TextData[{
 "This notebook chose ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["R",
    FontSlant->"Italic"], "0"]],ExpressionUUID->
  "48ad85eb-2a73-4e23-b388-f78940f5b11e"],
 " = 4 with reference to the literature, before doing this estimation on \
Dutch data. The value of 4 agrees with 9-10 days earlier than Carnival: \
Valentine\[CloseCurlyQuote]s Day. With a higher ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["R",
    FontSlant->"Italic"], "0"]],ExpressionUUID->
  "a7e9e6c1-ee6e-46c2-b590-377b194c6884"],
 " then there is less need for an earlier onset to explain the cumulative \
death toll at the end of May. We can maintain the onset at Carnival, if ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["R",
    FontSlant->"Italic"], "0"]],ExpressionUUID->
  "7a68e1ac-5d32-43ee-a151-3f13af49c3c3"],
 "-pre would be 5.7, and then have the same RMSE level as in other cases - \
which RMSE is so uniform low because all fits are so well (or so worse since \
none reaches 0). In all these cases we maintained \[Gamma] = 0.1. The range \
of 4 - 5.7 seems rather large. However, it so happens for the SI(EY)A(CD) \
model family that this range is not unreasonable."
}], "Text",ExpressionUUID->"5ad18e8a-89b9-4c2f-8ba8-4e1644d450e7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.5.4. Limit values", "Subsubsection",ExpressionUUID->"317aa67c-8d07-430e-a07f-d844c80d2076"],

Cell[TextData[{
 "The following gives the contours of the proportion of the acquitted ",
 StyleBox["A ",
  FontSlant->"Italic"],
 "= (1 - susceptible - infected), as a function of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "d90ce366-9819-4a44-b751-82c21ec73703"],
 ". There is a close relation between ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "1b621d7d-2eba-4398-a248-094e5ec66af7"],
 " and the limit value of those affected in society. Remember that the death \
toll is a fixed proportion of the acquitted as well. Based upon the age \
composition of Dutch society, the IFF \[TildeTilde] 1.5%. For our assumption \
of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "462c2fcf-93a6-4fa3-b6ed-5662f123d7bc"],
 " = 4, the top of infections would have been reached after 58 days. The \
level of 50% of the population would have been reached after 62 days. The \
limit value of some 98% would never have been reached because it is a limit \
value. However, 95% of this limit value would have been reached after 89 \
days, say three months. The point to observe is that the values of the limit \
shares are rather flat in the range of 4 \[LessEqual] ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "e8243027-58a9-4490-940c-25b176aafbc6"],
 " \[LessEqual] 6. This gives some leeway for above \
\[OpenCurlyDoubleQuote]didactic estimation\[CloseCurlyDoubleQuote] outcome.  \
(Graph copied from below.)"
}], "Text",ExpressionUUID->"7e5bb480-cb34-411c-8a9d-ec1917c12ec8"],

Cell[BoxData[
 FormBox[
  TemplateBox[{
    GraphicsBox[{{{{{}, {}, 
         TagBox[
          TagBox[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[1.6], 
             RGBColor[0.6, 0.4, 0.2]], 
            LineBox[CompressedData["
1:eJwt13k0Vd8XAPD3ePeZpTKGnkQpoRRCtXeSZKoMaQ4ZigbJV9Fo/JaIpCRT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             "]]}, 
           Annotation[#, {{Legended}, Charting`Private`Tag$16324, {1}}]& ], 
          Annotation[#, "Charting`Private`Tag$16324#1"]& ], 
         TagBox[
          TagBox[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[1.6], 
             Thickness[Large], 
             RGBColor[0.4, 0.2666666666666667, 0.13333333333333336`]], 
            
            LineBox[{{0.0049073234636479056`, 0.}, {0.00981448366198969, 
             0.}, {0.019628804058673257`, 2.220446049250313*^-16}, {
             0.03925744485204039, 1.1102230246251565`*^-16}, {
             0.07851472643877466, 0.}, {0.1570292896122432, 0.}, {
             0.32726685668366917`, 1.1102230246251565`*^-16}, {
             0.4862230685612167, 0.}, {0.6420611905510084, 0.}, {
             0.644702543093419, 2.220446049250313*^-16}, {0.6455829939408892, 
             0.}}], 
            
            LineBox[{{0.8054477121029804, 0.}, {0.8058250481804676, 
             1.1102230246251565`*^-16}, {0.8084664007228783, 
             2.220446049250313*^-16}, {0.8111077532652889, 
             7.771561172376096*^-16}, {0.8135728346327953, 
             1.1102230246251565`*^-16}, {0.8160379160003015, 
             6.661338147750939*^-16}, {0.8185029973678077, 
             5.551115123125783*^-16}, {0.8209680787353141, 
             3.3306690738754696`*^-16}, {0.8224471275558178, 0.}}], 
            LineBox[CompressedData["
1:eJw113k0ldsbB/BzzFMHJ2SIQ2n4NaCICM9OUplClOEmpISQ4YomGZOISmVO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             "]], 
            
            LineBox[{{0.8875252756579837, 0.}, {0.88999035702549, 0.}, {
             0.8924554383929963, 4.440892098500626*^-16}, {0.8949205197605026,
              1.887379141862766*^-15}, {0.8973856011280088, 0.}, {
             0.8998506824955151, 9.992007221626409*^-16}, {0.9023157638630215,
              9.992007221626409*^-16}, {0.9040223586559104, 0.}}], 
            
            LineBox[{{0.7556393498746656, 0.}, {0.7582807024170762, 
             7.771561172376096*^-16}, {0.7609220549594868, 
             7.771561172376096*^-16}, {0.7635634075018976, 
             1.1102230246251565`*^-16}, {0.7662047600443082, 
             2.220446049250313*^-16}, {0.7688461125867188, 
             1.1102230246251565`*^-16}, {0.769726563434189, 0.}}], 
            
            LineBox[{{0.6596702075004126, 0.}, {0.6605506583478828, 
             1.1102230246251565`*^-16}, {0.6631920108902936, 
             3.3306690738754696`*^-16}, {0.6643240191227553, 0.}}], 
            
            LineBox[{{0.8289795931797095, 0.}, {0.8308284042053392, 
             6.661338147750939*^-16}, {0.8332934855728455, 
             3.3306690738754696`*^-16}, {0.8357585669403518, 
             2.220446049250313*^-16}, {0.8369911076241049, 0.}}], 
            
            LineBox[{{0.9080676203872027, 0.}, {0.9097110079655403, 
             4.440892098500626*^-16}, {0.9121760893330466, 
             1.1102230246251565`*^-15}, {0.9146411707005528, 
             4.440892098500626*^-16}, {0.9162845582788903, 0.}}], 
            
            LineBox[{{0.8669829309287647, 0.}, {0.8678046247179334, 
             2.220446049250313*^-16}, {0.8702697060854397, 
             7.771561172376096*^-16}, {0.8727347874529461, 
             6.661338147750939*^-16}, {0.8745835984785757, 0.}}], 
            
            LineBox[{{0.948277603553945, 0.}, {0.9491523098456408, 
             1.2212453270876722`*^-15}, {0.9507473624952038, 0.}}], 
            
            LineBox[{{0.6499852481782403, 0.}, {0.6526266007206509, 0.}, {
             0.6552679532630616, 1.1102230246251565`*^-16}, {
             0.6561484041105319, 0.}}], 
            
            LineBox[{{0.9776730750335899, 0.}, {0.9795588138009967, 
             2.6645352591003757`*^-15}, {0.9810853642317547, 0.}}], 
            
            LineBox[{{0.7279051481793539, 0.}, {0.7292258244505593, 
             2.220446049250313*^-16}, {0.7318671769929699, 0.}, {
             0.7345085295353806, 1.1102230246251565`*^-16}, {
             0.7371498820777912, 3.3306690738754696`*^-16}, {
             0.7397912346202018, 0.}}], 
            
            LineBox[{{0.8530141365128958, 0.}, {0.855479217880402, 0.}, {
             0.8579442992479083, 1.1102230246251565`*^-16}, {
             0.8604093806154146, 4.440892098500626*^-16}, {0.862874461982921, 
             0.}}], 
            
            LineBox[{{0.7767701702139507, 0.}, {0.7794115227563613, 
             2.220446049250313*^-16}, {0.7820528752987719, 0.}, {
             0.7846942278411826, 0.}, {0.7873355803835932, 0.}}], 
            
            LineBox[{{0.6679464454666326, 0.}, {0.6684747159751148, 
             1.1102230246251565`*^-16}, {0.6737574210599361, 
             1.1102230246251565`*^-16}, {0.6746378719074063, 0.}}], 
            
            LineBox[{{0.8394561889916112, 0.}, {0.8406887296753643, 
             2.220446049250313*^-16}, {0.8415104234645331, 0.}}], 
            
            LineBox[{{0.9305272506244823, 0.}, {0.9318967402730969, 
             1.1102230246251565`*^-15}, {0.9343618216406031, 
             8.881784197001252*^-16}, {0.9353478541876056, 0.}}], 
            
            LineBox[{{0.9523217001752918, 0.}, {0.9540824725806534, 
             1.6653345369377348`*^-15}, {0.955451962229268, 0.}}], 
            
            LineBox[{{0.9403299133724604, 0.}, {0.941757065743122, 
             1.2212453270876722`*^-15}, {0.9442221471106282, 
             1.6653345369377348`*^-15}, {0.9452786105538452, 0.}}], 
            
            LineBox[{{0.6772792244498169, 0.}, {0.6790401261447574, 
             4.440892098500626*^-16}, {0.681681478687168, 
             2.220446049250313*^-16}, {0.6843228312295786, 0.}}], 
            
            LineBox[{{0.8441398435898732, 0.}, {0.8456188924103769, 
             6.661338147750939*^-16}, {0.8480839737778831, 0.}}], 
            
            LineBox[{{0.920349780183199, 0.}, {0.9220364148030717, 
             1.4432899320127035`*^-15}, {0.924501496170578, 
             7.771561172376096*^-16}, {0.9269665775380842, 
             5.551115123125783*^-16}, {0.9279146857563558, 0.}}], 
            
            LineBox[{{0.9707811488241385, 0.}, {0.9715444240395175, 
             1.7763568394002505`*^-15}, {0.9721380825403678, 0.}}], 
            LineBox[{{0.8812677614173908, 0.}, {0.8825951129229712, 
             7.771561172376096*^-16}, {0.8845123984310316, 0.}}], 
            
            LineBox[{{0.9660997442472464, 0.}, {0.9664078794181847, 
             6.661338147750939*^-16}, {0.9667294117704681, 0.}}]}, 
           Annotation[#, {{Legended}, Charting`Private`Tag$16324, {2}}]& ], 
          Annotation[#, "Charting`Private`Tag$16324#2"]& ], 
         TagBox[
          TagBox[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[1.6], 
             Dashing[{Small, Small}], 
             Thickness[Large], 
             RGBColor[0.4, 0.2666666666666667, 0.13333333333333336`]], 
            
            LineBox[{{0.0049073234636479056`, 0.}, {0.00981448366198969, 
             0.}, {0.019628804058673257`, 2.1094237467877973`*^-16}, {
             0.03925744485204039, 1.0547118733938987`*^-16}, {
             0.07851472643877466, 0.}, {0.1570292896122432, 0.}, {
             0.32726685668366917`, 1.0547118733938987`*^-16}, {
             0.4862230685612167, 0.}, {0.6420611905510084, 0.}, {
             0.644702543093419, 2.1094237467877973`*^-16}, {
             0.6455829939408892, 0.}}], 
            
            LineBox[{{0.8054477121029804, 0.}, {0.8058250481804676, 
             1.0547118733938987`*^-16}, {0.8084664007228783, 
             2.1094237467877973`*^-16}, {0.8111077532652889, 
             7.38298311375729*^-16}, {0.8135728346327953, 
             1.0547118733938987`*^-16}, {0.8160379160003015, 
             6.328271240363391*^-16}, {0.8185029973678077, 
             5.273559366969494*^-16}, {0.8209680787353141, 
             3.1641356201816957`*^-16}, {0.8224471275558178, 0.}}], 
            LineBox[CompressedData["
1:eJwt1nk01N3/APAZO6NhhmRtQvn2RFS2SN6XFDEiJZEl0qIeLYhUHlmTbKGy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             "]], 
            
            LineBox[{{0.8875252756579837, 0.}, {0.88999035702549, 0.}, {
             0.8924554383929963, 4.2188474935755947`*^-16}, {
             0.8949205197605026, 1.7930101847696277`*^-15}, {
             0.8973856011280088, 0.}, {0.8998506824955151, 
             9.492406860545087*^-16}, {0.9023157638630215, 
             9.492406860545087*^-16}, {0.9040223586559104, 0.}}], 
            
            LineBox[{{0.7556393498746656, 0.}, {0.7582807024170762, 
             7.38298311375729*^-16}, {0.7609220549594868, 
             7.38298311375729*^-16}, {0.7635634075018976, 
             1.0547118733938987`*^-16}, {0.7662047600443082, 
             2.1094237467877973`*^-16}, {0.7688461125867188, 
             1.0547118733938987`*^-16}, {0.769726563434189, 0.}}], 
            
            LineBox[{{0.6596702075004126, 0.}, {0.6605506583478828, 
             1.0547118733938987`*^-16}, {0.6631920108902936, 
             3.1641356201816957`*^-16}, {0.6643240191227553, 0.}}], 
            
            LineBox[{{0.8289795931797095, 0.}, {0.8308284042053392, 
             6.328271240363391*^-16}, {0.8332934855728455, 
             3.1641356201816957`*^-16}, {0.8357585669403518, 
             2.1094237467877973`*^-16}, {0.8369911076241049, 0.}}], 
            
            LineBox[{{0.9080676203872027, 0.}, {0.9097110079655403, 
             4.2188474935755947`*^-16}, {0.9121760893330466, 
             1.0547118733938987`*^-15}, {0.9146411707005528, 
             4.2188474935755947`*^-16}, {0.9162845582788903, 0.}}], 
            
            LineBox[{{0.8669829309287647, 0.}, {0.8678046247179334, 
             2.1094237467877973`*^-16}, {0.8702697060854397, 
             7.38298311375729*^-16}, {0.8727347874529461, 
             6.328271240363391*^-16}, {0.8745835984785757, 0.}}], 
            
            LineBox[{{0.948277603553945, 0.}, {0.9491523098456408, 
             1.1601830607332885`*^-15}, {0.9507473624952038, 0.}}], 
            
            LineBox[{{0.6499852481782403, 0.}, {0.6526266007206509, 0.}, {
             0.6552679532630616, 1.0547118733938987`*^-16}, {
             0.6561484041105319, 0.}}], 
            
            LineBox[{{0.9776730750335899, 0.}, {0.9795588138009967, 
             2.5313084961453566`*^-15}, {0.9810853642317547, 0.}}], 
            
            LineBox[{{0.7279051481793539, 0.}, {0.7292258244505593, 
             2.1094237467877973`*^-16}, {0.7318671769929699, 0.}, {
             0.7345085295353806, 1.0547118733938987`*^-16}, {
             0.7371498820777912, 3.1641356201816957`*^-16}, {
             0.7397912346202018, 0.}}], 
            
            LineBox[{{0.8530141365128958, 0.}, {0.855479217880402, 0.}, {
             0.8579442992479083, 1.0547118733938987`*^-16}, {
             0.8604093806154146, 4.2188474935755947`*^-16}, {
             0.862874461982921, 0.}}], 
            
            LineBox[{{0.7767701702139507, 0.}, {0.7794115227563613, 
             2.1094237467877973`*^-16}, {0.7820528752987719, 0.}, {
             0.7846942278411826, 0.}, {0.7873355803835932, 0.}}], 
            
            LineBox[{{0.6679464454666326, 0.}, {0.6684747159751148, 
             1.0547118733938987`*^-16}, {0.6737574210599361, 
             1.0547118733938987`*^-16}, {0.6746378719074063, 0.}}], 
            
            LineBox[{{0.8394561889916112, 0.}, {0.8406887296753643, 
             2.1094237467877973`*^-16}, {0.8415104234645331, 0.}}], 
            
            LineBox[{{0.9305272506244823, 0.}, {0.9318967402730969, 
             1.0547118733938987`*^-15}, {0.9343618216406031, 
             8.437694987151189*^-16}, {0.9353478541876056, 0.}}], 
            
            LineBox[{{0.9523217001752918, 0.}, {0.9540824725806534, 
             1.582067810090848*^-15}, {0.955451962229268, 0.}}], 
            
            LineBox[{{0.9403299133724604, 0.}, {0.941757065743122, 
             1.1601830607332885`*^-15}, {0.9442221471106282, 
             1.582067810090848*^-15}, {0.9452786105538452, 0.}}], 
            
            LineBox[{{0.6772792244498169, 0.}, {0.6790401261447574, 
             4.2188474935755947`*^-16}, {0.681681478687168, 
             2.1094237467877973`*^-16}, {0.6843228312295786, 0.}}], 
            
            LineBox[{{0.8441398435898732, 0.}, {0.8456188924103769, 
             6.328271240363391*^-16}, {0.8480839737778831, 0.}}], 
            
            LineBox[{{0.920349780183199, 0.}, {0.9220364148030717, 
             1.3711254354120683`*^-15}, {0.924501496170578, 
             7.38298311375729*^-16}, {0.9269665775380842, 
             5.273559366969494*^-16}, {0.9279146857563558, 0.}}], 
            
            LineBox[{{0.9707811488241385, 0.}, {0.9715444240395175, 
             1.6875389974302379`*^-15}, {0.9721380825403678, 0.}}], 
            
            LineBox[{{0.8812677614173908, 0.}, {0.8825951129229712, 
             7.38298311375729*^-16}, {0.8845123984310316, 0.}}], 
            
            LineBox[{{0.9660997442472464, 0.}, {0.9664078794181847, 
             6.328271240363391*^-16}, {0.9667294117704681, 0.}}]}, 
           Annotation[#, {{Legended}, Charting`Private`Tag$16324, {3}}]& ], 
          Annotation[#, "Charting`Private`Tag$16324#3"]& ]}}, {}}, {
       PointSize[Medium], 
       PointBox[
        NCache[{{4, Rational[1, 4] Log[4]}, {4, 0.5}, {
          4, 0.9311639687823104}, {
          4, 1 + Rational[1, 4] ProductLog[(-4) E^(-4)]}}, {{
          4, 0.34657359027997264`}, {4, 0.5}, {4, 0.9311639687823104}, {
          4, 0.9801725987182216}}]], 
       Dashing[{Small, Small}], 
       LineBox[{{1.3862943611198906`, 0}, {1.3862943611198906`, 0.5}}], 
       LineBox[{{4, 0}, {4, 1}}], 
       LineBox[{{0, 0.5}, {8, 0.5}}]}, {
       InsetBox[
        FormBox["\"58 days\"", TraditionalForm], 
        NCache[{4, Rational[1, 4] Log[4]}, {4, 0.34657359027997264`}], 
        ImageScaled[{-0.25, 
          Rational[3, 2]}]], 
       InsetBox[
        FormBox["\"62 days\"", TraditionalForm], {4, 0.5}, 
        ImageScaled[{-0.25, 
          Rational[3, 2]}]], 
       InsetBox[
        FormBox["\"89 days\"", TraditionalForm], {4, 0.7841380789745773}, 
        ImageScaled[{-0.25, 
          Rational[-1, 2]}]]}}, {
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
      AxesOrigin -> {0., 0.}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}}, PlotRangeClipping -> True, ImagePadding -> 
      All, DisplayFunction -> Identity, AspectRatio -> 
      NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
      AxesLabel -> {
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(R\\), \\(0\\)]\\)\"", TraditionalForm], 
        FormBox["\"A = 1 - S - I\"", TraditionalForm]}, 
      AxesOrigin -> {0., 0.}, BaseStyle -> {FontSize -> 13}, DisplayFunction :> 
      Identity, Frame -> {{False, False}, {False, False}}, 
      FrameLabel -> {{None, None}, {None, None}}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, GridLinesStyle -> Directive[
        GrayLevel[0.5, 0.4]], 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, 
      PlotRange -> {{0., 7.999999836734694}, {0, 1}}, PlotRangeClipping -> 
      True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {Automatic, Automatic}}, 
      Ticks -> {Automatic, Automatic}}], 
    FormBox[
     FormBox[
      TemplateBox[{
       "\"A at top I\"", "\"A[\[Infinity]]\"", "\"95% A[\[Infinity]]\""}, 
       "LineLegend", DisplayFunction -> (FormBox[
         StyleBox[
          StyleBox[
           PaneBox[
            TagBox[
             GridBox[{{
                TagBox[
                 GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], FontSize -> 13, 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0.6, 0.4, 0.2]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], FontSize -> 13, 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0.6, 0.4, 0.2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], FontSize -> 13, 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large], 
                    RGBColor[0.4, 0.2666666666666667, 0.13333333333333336`]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], FontSize -> 13, 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large], 
                    RGBColor[
                    0.4, 0.2666666666666667, 0.13333333333333336`]], {}}}, 
                    AspectRatio -> Full, ImageSize -> {40, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], FontSize -> 13, 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Dashing[{Small, Small}], 
                    Thickness[Large], 
                    RGBColor[0.4, 0.2666666666666667, 0.13333333333333336`]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], FontSize -> 13, 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Dashing[{Small, Small}], 
                    Thickness[Large], 
                    RGBColor[
                    0.4, 0.2666666666666667, 0.13333333333333336`]], {}}}, 
                    AspectRatio -> Full, ImageSize -> {40, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                  GridBoxAlignment -> {
                   "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                  AutoDelete -> False, 
                  GridBoxDividers -> {
                   "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {
                   "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
              AutoDelete -> False, 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
             "Grid"], Alignment -> Left, AppearanceElements -> None, 
            ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
            "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
          False], TraditionalForm]& ), 
       InterpretationFunction :> (RowBox[{"LineLegend", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"FontSize", "\[Rule]", "13"}], ",", 
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.6, 0.4, 0.2], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0.4, 0.2666666666666667, 0.13333333333333336`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.6`", ",", "0.4`", ",", "0.2`"}], "]"}], 
                    NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.6, 0.4, 0.2]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.6, 0.4, 0.2], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"FontSize", "\[Rule]", "13"}], ",", 
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Thickness", "[", "Large", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.4, 0.2666666666666667, 0.13333333333333336`], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.2666666666666667, 0.1777777777777778, 
                    0.0888888888888889], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    
                    RowBox[{"0.4`", ",", "0.2666666666666667`", ",", 
                    "0.13333333333333336`"}], "]"}], NumberMarks -> False]], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.4, 0.2666666666666667, 0.13333333333333336`]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.4, 0.2666666666666667, 0.13333333333333336`], 
                    Editable -> False, Selectable -> False]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"FontSize", "\[Rule]", "13"}], ",", 
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", "Large", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.4, 0.2666666666666667, 0.13333333333333336`], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.2666666666666667, 0.1777777777777778, 
                    0.0888888888888889], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    
                    RowBox[{"0.4`", ",", "0.2666666666666667`", ",", 
                    "0.13333333333333336`"}], "]"}], NumberMarks -> False]], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.4, 0.2666666666666667, 0.13333333333333336`]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.4, 0.2666666666666667, 0.13333333333333336`], 
                    Editable -> False, Selectable -> False]}], "]"}]}], "}"}],
                 ",", 
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"FontSize", "\[Rule]", "13"}], ",", 
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.6, 0.4, 0.2], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0.4, 0.2666666666666667, 0.13333333333333336`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.6`", ",", "0.4`", ",", "0.2`"}], "]"}], 
                    NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.6, 0.4, 0.2]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.6, 0.4, 0.2], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"FontSize", "\[Rule]", "13"}], ",", 
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Thickness", "[", "Large", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.4, 0.2666666666666667, 0.13333333333333336`], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.2666666666666667, 0.1777777777777778, 
                    0.0888888888888889], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    
                    RowBox[{"0.4`", ",", "0.2666666666666667`", ",", 
                    "0.13333333333333336`"}], "]"}], NumberMarks -> False]], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.4, 0.2666666666666667, 0.13333333333333336`]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.4, 0.2666666666666667, 0.13333333333333336`], 
                    Editable -> False, Selectable -> False]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"FontSize", "\[Rule]", "13"}], ",", 
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", "Large", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.4, 0.2666666666666667, 0.13333333333333336`], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.2666666666666667, 0.1777777777777778, 
                    0.0888888888888889], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    
                    RowBox[{"0.4`", ",", "0.2666666666666667`", ",", 
                    "0.13333333333333336`"}], "]"}], NumberMarks -> False]], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.4, 0.2666666666666667, 0.13333333333333336`]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.4, 0.2666666666666667, 0.13333333333333336`], 
                    Editable -> False, Selectable -> False]}], "]"}]}], 
                  "}"}]}], "}"}], ",", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
                RowBox[{"{", "}"}]}], "}"}], ",", 
            RowBox[{"LegendMarkers", "\[Rule]", 
              RowBox[{"{", 
                RowBox[{
                  RowBox[{"{", "None", "}"}], ",", 
                  RowBox[{"{", "None", "}"}]}], "}"}]}], ",", 
            RowBox[{"LabelStyle", "\[Rule]", 
              RowBox[{"{", "}"}]}], ",", 
            RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
       Editable -> True], TraditionalForm], TraditionalForm]},
   "Legended",
   DisplayFunction->(FormBox[
     GridBox[{{
        TagBox[
         ItemBox[
          PaneBox[
           TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
           BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
         "SkipImageSizeLevel"], 
        ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
      GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
      AutoDelete -> False, GridBoxItemSize -> Automatic, 
      BaselinePosition -> {1, 1}], TraditionalForm]& ),
   Editable->True,
   InterpretationFunction->(FormBox[
     RowBox[{"Legended", "(", 
       RowBox[{#, ",", 
         RowBox[{"Placed", "[", 
           RowBox[{#2, ",", "After"}], "]"}]}], ")"}], TraditionalForm]& )], 
  TraditionalForm]], "Output",
 CellLabel->"Out[25]=",ExpressionUUID->"2fd3c920-7ec5-4a3a-87a3-bf96120b3295"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.5.5. Understanding herd immunity", "Subsubsection",ExpressionUUID->"aab51b60-f407-48a0-965e-9e6068cd8d2b"],

Cell[TextData[{
 "RIVM informed the Dutch Prime Minister about the notion of \
\[OpenCurlyDoubleQuote]herd immunity\[CloseCurlyDoubleQuote] which \
information the PM used in his television speech of March 16. Rutte (2020) \
did not mention a specific number but RIVM circulated that herd immunity \
would be around 60% of the population, see the interview by journalist \
Tweebeeke and RIVM department head Van Dissel (2020). There are at least four \
possibilities how to arrive at such notion with such value, see ",
 StyleBox["Chapter 6",
  FontWeight->"Bold"],
 ". "
}], "Text",ExpressionUUID->"a45e1640-d822-4d54-9ad5-6fb1476b0ad0"],

Cell[TextData[{
 "(a) When ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "28cb3f44-1fba-4934-b93e-6bc13f4dfae4"],
 " \[TildeTilde] 1.5, then the ",
 StyleBox["limit ",
  FontSlant->"Italic"],
 "value can be 60% (see above graph). It is less likely that RIVM used this \
notion, when they explicitly reported ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "0e5932b8-77ac-4a06-b22c-d7c0f6f95b87"],
 " in the range of 2.7 to 2.3, and when the notion of herd immunity was \
indicated for the period ",
 StyleBox["after ",
  FontSlant->"Italic"],
 "the lockdown. But conceivably RIVM might have the argument that ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "1246e86e-4761-481f-8d2f-b9408befb560"],
 " \[TildeTilde] 1.5 might work for the new rules on social distancing. \
Still, RIVM then seems to imply that ",
 StyleBox["also the vulnerables would be exposed",
  FontSlant->"Italic"],
 " while the very idea is to protect them. The implied death toll is 60% * \
1.5% = 0.9% of the population, or 156,600 persons. Perhaps this issue \
clarifies to RIVM that it ",
 StyleBox["is ",
  FontSlant->"Italic"],
 "useful to also mention the death toll, even while it is \
\[OpenCurlyDoubleQuote]speculative\[CloseCurlyDoubleQuote]."
}], "Text",ExpressionUUID->"559ba92b-fd70-476f-9c8e-e92dddefa709"],

Cell["\<\
(b)Potentially, 40% of society (7 million) will remain in permanent \
quarantine, so that 60% (10.4 million) would be the less vulnerables. This \
would work, see below, but it is remarkable that RIVM does not discuss the \
issue in these terms.\
\>", "Text",ExpressionUUID->"bd62b992-5b06-44c1-91f4-f9bad15d7fbf"],

Cell[TextData[{
 "(c) Within the epidemiological literature there might be authors who are \
subject to confused reasoning with a formula 1 - 1 / ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "095ce7cb-cc50-4ae3-8c90-3a4a37c595e3"],
 ". When RIVM has ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "947aecf5-94cd-459b-8cfb-6019fa79f604"],
 " = 2.5 and applies this formula then this gives 1 - 1 / 2.5 = 60% indeed. \
The formula arises as follows. With ",
 StyleBox["Ap",
  FontSlant->"Italic"],
 " the proportion of immune, the effective reproduction (1 - ",
 StyleBox["Ap",
  FontSlant->"Italic"],
 ") ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "3681dec4-4e86-4ba7-a80c-81336a856a3a"],
 " \[LessEqual] 1 if ",
 StyleBox["Ap ",
  FontSlant->"Italic"],
 "\[GreaterEqual] 1 - 1 / ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "de895c5d-e878-4c97-82d3-af5b9526e5ca"],
 ". However, this still means that ",
 StyleBox["infections continue",
  FontSlant->"Italic"],
 ". The literature calls this \"overshoot\", which doesn't provide the \
protection that RIVM refers to. Thus the death toll would be higher than \
156,000. The reasoning also requires a model with a steady state."
}], "Text",ExpressionUUID->"3ee65f0c-3525-4f42-9bf5-306ad1df70b1"],

Cell[TextData[{
 "(d) The SI(EY)A(CD) family of models does not have a steady state but an \
\[OpenCurlyDoubleQuote]",
 StyleBox["asymptotical",
  FontSlant->"Italic"],
 " steady state\[CloseCurlyDoubleQuote]. If ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "35922fa0-792b-436c-9c39-12e8791bc8bd"],
 " > 1 then the infections have a top when the susceptibles are at Sp = 1/",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "555362ba-9fcc-4c49-929e-f43272dce827"],
 ". Perhaps this invites attention for 1 - Sp = 1 - 1/",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "3a90c5b7-39c3-4689-8c1c-62de4132dd16"],
 " again but this has another interpretation, because the level of \
infectiousness at this top is nonzero and not a steady state or limit value. \
After the top the infections decline, but the infections continue \
nevertheless. When ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "788ff1fd-34b5-42ed-88cd-3bd1a311c849"],
 " = 2.5, then the limit value Ap[\[Infinity]] = 90% (see above graph). When \
the Acquitted are at 60%, the infection may be reducing, but is not over yet, \
and still continues with 30% * 1.5% = 0.45% of the population or 78000 \
deaths. "
}], "Text",ExpressionUUID->"4b00de59-c003-4b73-9c39-825d8e55014c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Explain", "[", 
   RowBox[{
    RowBox[{"SIA", "[", 
     RowBox[{"Ip", ",", " ", "Top", ",", " ", "R0"}], "]"}], ",", " ", 
    "SIA"}], "]"}], "   ", 
  RowBox[{"(*", " ", 
   RowBox[{"the", " ", "real", " ", "top", " ", "of", " ", "Ip"}], " ", 
   "*)"}]}]], "Input",
 CellLabel->"In[18]:=",ExpressionUUID->"cda384f1-9e72-419b-835d-03ea0acaed8b"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\<\"S\"\>", "\[Rule]", 
     FractionBox["1", "R0"]}], ",", 
    RowBox[{"\<\"I\"\>", "\[Rule]", 
     FractionBox[
      RowBox[{"R0", "-", 
       RowBox[{"log", "(", "R0", ")"}], "-", "1"}], "R0"]}], ",", 
    RowBox[{"\<\"A\"\>", "\[Rule]", 
     FractionBox[
      RowBox[{"log", "(", "R0", ")"}], "R0"]}]}], "}"}], 
  TraditionalForm]], "Output",
 CellLabel->"Out[18]=",ExpressionUUID->"ab457170-3023-4e6d-9857-e03c7a3633f0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Explain", "[", 
   RowBox[{
    RowBox[{"SICD", "[", 
     RowBox[{"Limit", ",", " ", 
      RowBox[{
       RowBox[{"BetaSIA", "[", "]"}], " ", "\[Rule]", " ", 
       RowBox[{"2.5", " ", 
        RowBox[{"GammaSIA", "[", "]"}]}]}]}], "]"}], ",", " ", "SICD"}], 
   "]"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"the", " ", "limit", " ", "values", " ", "for", " ", "R0"}], " ", 
    "=", " ", "2.5"}], " ", "*)"}]}]], "Input",
 CellLabel->"In[17]:=",ExpressionUUID->"e3992228-d75d-4516-b89f-5d3011e0b6c3"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\<\"S\"\>", "\[Rule]", "0.10735440307119928`"}], ",", 
    RowBox[{"\<\"I\"\>", "\[Rule]", "0"}], ",", 
    RowBox[{"\<\"C\"\>", "\[Rule]", "0.8792559129748687`"}], ",", 
    RowBox[{"\<\"D\"\>", "\[Rule]", "0.01338968395393203`"}], ",", 
    RowBox[{"\<\"N\"\>", "\[Rule]", "0.986610316046068`"}], ",", 
    RowBox[{"\<\"A\"\>", "\[Rule]", "0.8926455969288007`"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellLabel->"Out[17]=",ExpressionUUID->"1a95a1e4-c1b4-4187-8496-6d9493cc1dac"]
}, Open  ]],

Cell[TextData[{
 "In the following plot, the difference between the lines ",
 StyleBox["times ",
  FontSlant->"Italic"],
 "the  population",
 StyleBox[" times ",
  FontSlant->"Italic"],
 "the Infection Fatality Factor is the overshoot in deaths, that is not \
accounted for by the claim that ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Ap", "HI"], TraditionalForm]],ExpressionUUID->
  "292aa82a-4b5e-44de-9aa6-2b9e3d314e42"],
 " = 1 - 1 / ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "8c9cd8c0-7df6-4732-98bb-82a796f13878"],
 " would give \[OpenCurlyDoubleQuote]protection\[CloseCurlyDoubleQuote] (\
\[OpenCurlyDoubleQuote]herd immunity\[CloseCurlyDoubleQuote])."
}], "Text",ExpressionUUID->"3f0bd5e5-7c83-4784-aa91-25cea03aaf61"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ApByR0Plot", "[", "\"\<HerdImmunity\>\"", "]"}]], "Input",
 CellLabel->"In[19]:=",ExpressionUUID->"17da18db-3ba9-4e83-b9ae-ed669e9b1e13"],

Cell[BoxData[
 FormBox[
  TemplateBox[{
    GraphicsBox[{{{{}, {}, 
        TagBox[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           Thickness[Large], 
           RGBColor[0.4, 0.2666666666666667, 0.13333333333333336`]], 
          LineBox[CompressedData["
1:eJwV0Wk4FF4bBvAxCyYpZC2aRCKKkLLkOUlkiVBZImUXQqlUtqK8IVH+RVGi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           "]]}, Annotation[#, "Charting`Private`Tag$6141#1"]& ], 
        TagBox[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[1, 
            NCache[
             Rational[1, 3], 0.3333333333333333], 
            NCache[
             Rational[1, 3], 0.3333333333333333]]], 
          LineBox[CompressedData["
1:eJwVy3k81PkfB/BBtKLcYlZ9c+TOFrG1hvcn/HQ4HrlalOTclS2yttpqCx0j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           "]]}, Annotation[#, "Charting`Private`Tag$6141#2"]& ]}}, {}}, {
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
      AxesOrigin -> {0., 0.}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}}, PlotRangeClipping -> True, ImagePadding -> 
      All, DisplayFunction -> Identity, AspectRatio -> 
      NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
      AxesLabel -> {
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(R\\), \\(0\\)]\\)\"", TraditionalForm], 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(A\\), \\(HI\\)]\\) called Herd \
Immunity\"", TraditionalForm]}, AxesOrigin -> {0., 0.}, 
      BaseStyle -> {FontSize -> 13}, DisplayFunction :> Identity, 
      Frame -> {{False, False}, {False, False}}, 
      FrameLabel -> {{None, None}, {None, None}}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, GridLinesStyle -> Directive[
        GrayLevel[0.5, 0.4]], 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, 
      PlotRange -> {{0., 7.999999857142857}, {0, 1}}, PlotRangeClipping -> 
      True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {Automatic, Automatic}}, 
      Ticks -> {Automatic, Automatic}}], 
    FormBox[
     FormBox[
      TemplateBox[{
       "\"A[\[Infinity]]\"", 
        "\"\\!\\(\\*SubscriptBox[\\(A\\), \\(HI\\)]\\) = 1 - 1 / \
\\!\\(\\*SubscriptBox[\\(R\\), \\(0\\)]\\)\""}, "LineLegend", 
       DisplayFunction -> (FormBox[
         StyleBox[
          StyleBox[
           PaneBox[
            TagBox[
             GridBox[{{
                TagBox[
                 GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], FontSize -> 13, 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large], 
                    RGBColor[0.4, 0.2666666666666667, 0.13333333333333336`]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], FontSize -> 13, 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large], 
                    RGBColor[
                    0.4, 0.2666666666666667, 0.13333333333333336`]], {}}}, 
                    AspectRatio -> Full, ImageSize -> {20, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], FontSize -> 13, 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 
                    NCache[
                    Rational[1, 3], 0.3333333333333333], 
                    NCache[
                    Rational[1, 3], 0.3333333333333333]]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], FontSize -> 13, 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 
                    NCache[
                    Rational[1, 3], 0.3333333333333333], 
                    NCache[
                    Rational[1, 3], 0.3333333333333333]]], {}}}, AspectRatio -> 
                    Full, ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                  GridBoxAlignment -> {
                   "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                  AutoDelete -> False, 
                  GridBoxDividers -> {
                   "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {
                   "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
              AutoDelete -> False, 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
             "Grid"], Alignment -> Left, AppearanceElements -> None, 
            ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
            "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
          False], TraditionalForm]& ), 
       InterpretationFunction :> (RowBox[{"LineLegend", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                RowBox[{"Directive", "[", 
                  RowBox[{
                    RowBox[{"FontSize", "\[Rule]", "13"}], ",", 
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Thickness", "[", "Large", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.4, 0.2666666666666667, 0.13333333333333336`], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.2666666666666667, 0.1777777777777778, 
                    0.0888888888888889], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    
                    RowBox[{
                    "0.4`", ",", "0.2666666666666667`", ",", 
                    "0.13333333333333336`"}], "]"}], NumberMarks -> False]], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.4, 0.2666666666666667, 0.13333333333333336`]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.4, 0.2666666666666667, 0.13333333333333336`], 
                    Editable -> False, Selectable -> False]}], "]"}], ",", 
                RowBox[{"Directive", "[", 
                  RowBox[{
                    RowBox[{"FontSize", "\[Rule]", "13"}], ",", 
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 
                    Rational[1, 3], 
                    Rational[1, 3]], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.6666666666666666, 0.2222222222222222, 
                    0.2222222222222222], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", 
                    FractionBox["1", "3"], ",", 
                    FractionBox["1", "3"]}], "]"}], NumberMarks -> False]], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
                    Rational[1, 3], 
                    Rational[1, 3]]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 
                    Rational[1, 3], 
                    Rational[1, 3]], Editable -> False, Selectable -> 
                    False]}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
              RowBox[{#, ",", #2}], "}"}], ",", 
            RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
            RowBox[{"LabelStyle", "\[Rule]", 
              RowBox[{"{", "}"}]}], ",", 
            RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
       Editable -> True], TraditionalForm], TraditionalForm]},
   "Legended",
   DisplayFunction->(FormBox[
     GridBox[{{
        TagBox[
         ItemBox[
          PaneBox[
           TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
           BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
         "SkipImageSizeLevel"], 
        ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
      GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
      AutoDelete -> False, GridBoxItemSize -> Automatic, 
      BaselinePosition -> {1, 1}], TraditionalForm]& ),
   Editable->True,
   InterpretationFunction->(FormBox[
     RowBox[{"Legended", "(", 
       RowBox[{#, ",", 
         RowBox[{"Placed", "[", 
           RowBox[{#2, ",", "After"}], "]"}]}], ")"}], TraditionalForm]& )], 
  TraditionalForm]], "Output",
 CellLabel->"Out[19]=",ExpressionUUID->"8d7d3909-b589-48dc-9866-6b93af476b52"]
}, Open  ]],

Cell[TextData[{
 "(abcd) In sum, the possibility cannot be excluded that Dutch RIVM was \
itself the cause for confusion here, and that it was reticent in discussing \
the implied death counts for such policy scenario\[CloseCurlyQuote]s. For \
journalists, it might be that it requires knowledge of mathematical modeling \
to know when those models are ",
 StyleBox["not ",
  FontSlant->"Italic"],
 "needed when IFF values can applied directly."
}], "Text",ExpressionUUID->"13142eeb-4c87-4b94-a9c1-d9dd20050cdd"],

Cell[TextData[{
 "PM. The three (inadequate) scenario\[CloseCurlyQuote]s as proposed by RIVM: \
",
 StyleBox["https://www.rivm.nl/en/novel-coronavirus-covid-19/dutch-response-\
to-coronavirus",
  FontSlant->"Italic"],
 " or ",
 StyleBox["https://web.archive.org/web/20200527143138/https://www.rivm.nl/en/\
novel-coronavirus-covid-19/dutch-response-to-coronavirus.",
  FontSlant->"Italic"]
}], "Text",ExpressionUUID->"b6462463-41cb-45d1-b226-e91da893b104"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.5.6. Relevance of better didactics", "Subsubsection",ExpressionUUID->"b0e04c29-840d-4d6e-bd0a-30ee12dd3c7c"],

Cell["\<\
A presumption of better didactics is that it would be beneficial for the \
general discussion, at least within the wider community of researchers and \
policy makers, when such notions, as just discussed, would be \
well-understood. \
\>", "Text",ExpressionUUID->"58895380-fc23-4058-8095-8351610ba33c"],

Cell[TextData[{
 "PM. In a paper that got through peer-review, Ioannidis (2020) (my italics): \
\[OpenCurlyDoubleQuote]Focusing on protecting ",
 StyleBox["susceptible",
  FontSlant->"Italic"],
 " individuals may be preferable to maintaining countrywide lockdowns \
longterm.\[CloseCurlyDoubleQuote] Likely he means \
\[OpenCurlyDoubleQuote]protecting ",
 StyleBox["vulnerable ",
  FontSlant->"Italic"],
 "individuals\[CloseCurlyDoubleQuote]. With the terminology of \
epidemiological models, protection of all susceptibles requires a national \
lockdown."
}], "Text",ExpressionUUID->"373ea4d9-9bee-4abc-9829-76063d710bf8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
1.6. A nasty virus, asking for eradication. A challenge anyway\
\>", "Subsection",ExpressionUUID->"2de8a624-3711-4bb7-a165-1688c979beae"],

Cell[CellGroupData[{

Cell["1.6.1. A world at risk but also badly managed", "Subsubsection",ExpressionUUID->"dc0d1a9d-506c-4098-aaeb-a472b12390d3"],

Cell[TextData[{
 "John Snow (1813-1858) is considered one of the founders of modern \
epidemiology, when he deliberately searched for and identified a Soho water \
pump in the London cholera epidemic of 1854. We are more than 150 years \
later. It is not for nought that the world has set up the WHO and created the \
notion of an official warning of a ",
 StyleBox["public health emergency of international concern",
  FontSlant->"Italic"],
 " (PHEIC). Recent more general warnings were e.g. from HIV / AIDS \
1981-present, SARS 2003, MERS 2012-present, the Mexican \
\[OpenCurlyDoubleQuote]swine flu\[CloseCurlyDoubleQuote] 2009, Ebola \
2013-2016 and 2018-2020 and still risky, and Zika 2015-2016. Microsoft \
founder Bill Gates is credited for a 2015 TED talk warning for \
\[OpenCurlyDoubleQuote]the next outbreak\[CloseCurlyDoubleQuote]. Piot (2018) \
is more recent and essentially more qualified. The UK government provided for \
a study how to respond to pandemics, which study was duly used by Singapore \
for the current SARS-CoV-2 outbreak. However, it was not used by the UK \
itself. The USA response team was dismantled from the US White House a few \
years ago. Something has gone badly wrong in the last decade. The world in \
the last few years shows a huge ",
 StyleBox["pandemic mismanagement,",
  FontSlant->"Italic"],
 " likely caused by fundamental misunderstandings, while the issue was \
already clearly spelled out in the literature decades ago.  "
}], "Text",ExpressionUUID->"a5e34dbf-5cef-460d-ba05-81d4b92b8580"],

Cell[TextData[{
 "Observations are: (1) The health community has a hierarchical setup and \
mindset while the economic community is more liberally minded. When top \
health officials do not strongly criticise policy makers - because they have \
to work with them on a daily basis - then the health community apparently \
also subdues criticism. But economics is not perfect either. (2) What are \
severely lacking in the democratic setup of each nation are both an ",
 StyleBox["Economic Supreme Court",
  FontSlant->"Italic"],
 " and a ",
 StyleBox["National Assembly of Science and Learning, ",
  FontSlant->"Italic"],
 "see Colignatus (2020a)."
}], "Text",ExpressionUUID->"f85edfdc-bf66-4db2-95c4-bf0adbd604a4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.6.2. Prevent future pandemics", "Subsubsection",ExpressionUUID->"584ea420-bae3-4815-a085-239cb23bc964"],

Cell["\<\
Future pandemics are better prevented. The BBC Horizon (2020) broadcast can \
be much recommended for its overview of the issue and essential information, \
including the discussion of the WHO 2018 warning on pandemics and the \
identification of risk \"hotspots\". At roots, the lessons already learnt on \
epidemics ages ago are rediscovered for the world-scale without \
world-governance, and with scientists already warning for decades. Mankind is \
advised to make some fundamental changes, towards much lower world population \
and  environmentally sustainability, including less contact with wildlife and \
their pathogens, but also in the information and decision making structure in \
society, see Colignatus (2020ab).\
\>", "Text",ExpressionUUID->"10fc169e-24db-4cf8-be3a-381d5f5bdd2d"],

Cell["\<\
There is a perspective that SARS-CoV-2 might only mean a reduction of \
life-expectancy of 1%, see Richardson & Spiegelhalter (2020). For Dutch \
readers there is Jaspers (2020). From this perspective, there is only a \
limited effect, and there might be no need for more involved changes. \
However, the other view is that we got only lucky now. And perhaps we are not \
so lucky actually, since the virus appears to be a nasty one.\
\>", "Text",ExpressionUUID->"8df9c99e-f10f-4c32-ae47-b2864cfcd643"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.6.3. A nasty virus, asking for eradication", "Subsubsection",ExpressionUUID->"3c0a4083-368f-40a2-b330-b9b36c5bd3c8"],

Cell["\<\
SARS-CoV-2 is a nasty virus that attacks many parts of the body, see the \
column by Collins (2020), the director of the US National Institutes of \
Health (NIH), and the interview with Longley by BBC Horizon (2020) (May 26). \
For Dutch readers there is De Visser (2020). A possibility is also that the \
body is cleared of infection but that the immune system is out of control and \
starts to attack the own body.\
\>", "Text",ExpressionUUID->"e1f57147-39c5-47de-abf2-c99481d0cb0b"],

Cell["\<\
Draulans & Piot (2020), is an interview with Piot, who suffered the virus, \
and who says: \
\>", "Text",ExpressionUUID->"f482c7b8-6888-42be-93e5-0147e6b36d7d"],

Cell["\<\
\"Many people think COVID-19 kills 1% of patients, and the rest get away with \
some flu-like symptoms. But the story gets more complicated. Many people will \
be left with chronic kidney and heart problems. Even their neural system is \
disrupted. There will be hundreds of thousands of people worldwide, possibly \
more, who will need treatments such as renal dialysis for the rest of their \
lives. The more we learn about the coronavirus, the more questions arise. We \
are learning while we are sailing. That's why I get so annoyed by the many \
commentators on the sidelines who, without much insight, criticize the \
scientists and policymakers trying hard to get the epidemic under control. \
That's very unfair.\" \
\>", "Text",ExpressionUUID->"a39e2970-cc5e-4f2b-8d86-3f29c9f2b7c3"],

Cell["\<\
Viruses mutate fast, and are apt in exchanging parts of their RNA, and we \
would not want that this \"multi-system attack property\" is spread amongst \
viruses. Perhaps it is still feasible to choose for eradication. The example \
of smallpox, eradicated, and polio, though still with problems, is \
encouraging, see WHO GPEI & Heymann (2020). This notebook will not arrive at \
a choice, and only mention the options: either eradication or find a way to \
live with the virus till there is a vaccine. There is an overlap in measures: \
a discussion about \[OpenCurlyDoubleQuote]herd immunity\
\[CloseCurlyDoubleQuote] might also fit a scenario of eradication.\
\>", "Text",ExpressionUUID->"e5b6615e-adcf-4129-bc84-4a5b0362aaa0"],

Cell["\<\
Piot also states: \[OpenCurlyDoubleQuote]Let\[CloseCurlyQuote]s be clear: \
Without a coronavirus vaccine, we will never be able to live normally again. \
The only real exit strategy from this crisis is a vaccine that can be rolled \
out worldwide. That means producing billions of doses of it, which, in \
itself, is a huge challenge in terms of manufacturing logistics. And despite \
the efforts, it is still not even certain that developing a COVID-19 vaccine \
is possible.\[CloseCurlyDoubleQuote]\
\>", "Text",ExpressionUUID->"f2bdbc69-d4bb-4b6e-8240-b39006b8e0a9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
1.6.4. Under normal conditions the virus can no longer be contained\
\>", "Subsubsection",ExpressionUUID->"4538e716-213f-4708-a240-bf2e959bfcbd"],

Cell["\<\
If we want to eradicate SARS-CoV-2 then special conditions must apply. Under \
normal conditions it can no longer be contained in the world. The reasons for \
the latter are standard from an introductory course in infectious disease - \
see e.g. BCM (2020).\
\>", "Text",ExpressionUUID->"2bd24a38-7665-483c-a582-94023c5c97d1"],

Cell[TextData[{
 "- getting a vaccine takes time (perhaps 1.5 years) \[Ellipsis] and then \
give it to 7.5 billion people on the planet\n- health care is under strain, \
will perform less well, thus there will be breaches and ever newer infections\
\n- the virus already shows mutations and is likely to continue to do so: \
every new mutation would require a swift reaction for new containment \[Dash] \
but the health care system already is under strain\n- special for SARS-CoV-2:",
 StyleBox[" ",
  FontSlant->"Italic"],
 "the pandemic cannot be suppressed because of the ",
 StyleBox["asymptomatic infectious",
  FontSlant->"Italic"],
 "."
}], "Text",ExpressionUUID->"1b199efe-edba-46f2-b260-602cdd832747"],

Cell["\<\
Kissler et al. (2020) at Harvard mention already two strains and suggest that \
intermediate periods of national lockdowns might be needed (\
\[OpenCurlyDoubleQuote]lock-on-off\[CloseCurlyDoubleQuote]). The logic is \
impeccable, and worthy of more than a century of research in epidemiology. \
The logic however leads to the absurd conclusion that we must destroy our \
economy in order to save lives, while the destruction of the economy also \
costs lives - not included in their study. Epidemiologists have lived too \
long in a world that accepted models without consequences for the economy.\
\>", "Text",ExpressionUUID->"38e51fd4-f2f4-4107-bcc7-e404493426cd"],

Cell[TextData[{
 "Less developed nations lack the medical systems of the developed world, \
will be open to the virus, and will form breeding grounds for ",
 StyleBox["new waves",
  FontSlant->"Italic"],
 " and ",
 StyleBox["mutations",
  FontSlant->"Italic"],
 ". Developed nations might think that they might insulate themselves by \
containment and suppression, but it is dubious that they can insulate \
themselves forever.  We can expect waves of new infections indeed, like with \
the flu, but then 10 times more infectious / deadlier than the flu, with the \
risk of shorter intervals because of faster mutations. The Northern \
hemisphere now benefits from the Summer, but in Autumn the reduced health \
because of the common cold and flu will combine with SARS-CoV-2, causing \
increased joint mortality. The Summer of 2020 should rather not be wasted. "
}], "Text",ExpressionUUID->"0c8288f6-71c6-4cce-b9f9-3b3ff6f85c2f"],

Cell["\<\
There are more than 7.5 billion people on the planet. Not all will comply \
with quarantine or get the eventual vaccine in time. Viruses mutate. This \
virus derives from the common cold strain and people may lose immunity after \
a period. The economic price of national lockdowns is high and it seems that \
the virus is \[OpenCurlyDoubleQuote]not terrible or deadly enough\
\[CloseCurlyDoubleQuote] for people to bear that price, causing much \
indecision and delay perhaps till it is too late again.\
\>", "Text",ExpressionUUID->"2865cbcc-4b2c-4a4b-a789-28a7d9aeeff2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
1.6.5. Return to some normalcy, or consider what urgently requires improvement\
\>", "Subsubsection",ExpressionUUID->"781bcefc-4bca-4b46-b2c1-b9d3931ebcee"],

Cell["\<\
With the pandemic still continuing, the medical world faces the challenge to \
restore care to the level of before the pandemic.  Gupta (2020) reports that \
some 40% of normal care has fallen away because of the focus on SARS-CoV-2 \
and the fear amongst patients of getting infected in the hospital. De Rek & \
Goudsmit (2020) is an interview with virologist Jaap Goudsmit (involved in \
finding HIV) who comments that the emergency brake of the national lockdown \
contained the problem but that normal care ought to be restored, and: (i) \
there is a lack of data, (ii) reliance on models means also a reliance upon \
assumptions, (iii) there is too little attention for scenario\
\[CloseCurlyQuote]s (the three scenario\[CloseCurlyQuote]s presented by RIVM \
are not enough). See https://jaapgoudsmit-over-corona.nl/\
\>", "Text",ExpressionUUID->"47af04ab-7c2f-4918-8c9c-e6c0927ea360"],

Cell["\<\
The economy faces the similar challenge, see Baldwin (2020ab), Baldwin & \
Weder di Mauro (2020), Berger et al. (2020) and Acemoglu et al. (2020).\
\>", "Text",ExpressionUUID->"786f0bdf-8a35-48ad-94d5-f4cbac653400"],

Cell[TextData[{
 "A core question is: if some return to normalcy would be possible today, in \
May through September 2020, then ",
 StyleBox["why wasn\[CloseCurlyQuote]t it considered in January ? ",
  FontSlant->"Italic"],
 "Was it really necessary for Western Europe to first have this wave and \
national lockdowns from February to May, before its CDCs, governments and \
citizens would accept the idea that \[OpenCurlyDoubleQuote]normalcy\
\[CloseCurlyDoubleQuote] would require some adaptation ? If CDCs have only an \
advisory role, what happened at the ",
 StyleBox["government",
  FontSlant->"Italic"],
 " Departments of Health ? Indeed, it is reported that Taiwan, Hong Kong, \
Singapore and South Korea learned their lessons by the SARS-CoV-1 epidemic in \
2003. ",
 StyleBox[" Would this mean that countries can only learn from disasters \
happening on their own territory ? ",
  FontSlant->"Italic"],
 "And if this would be the sad truth indeed, then ",
 StyleBox["what have countries learned from the present episode ?",
  FontSlant->"Italic"],
 " (It is said, however, that Singapore used the pandemic scenario developed \
in London, that London itself did not use. Thus Singapore can learn, and what \
is so special about Singapore ?)"
}], "Text",ExpressionUUID->"d5276b2c-7e70-42f8-a387-af44993b30a4"],

Cell[TextData[{
 "RIVM, the Dutch counterpart of the US CDC, issued a health warning in \
January. RIVM (2020) advised the Ministry to give alert status A to \
SARS-CoV-2, which e.g. allows mandatory quarantine. This status was assigned. \
(https://www.rivm.nl/meldingsplicht-infectieziekten/welke-infectieziekten-\
zijn-meldingsplichtig) However, when a general practitioner doctor (GP) \
reports a case, the case is only a \[OpenCurlyDoubleQuote]suspected case\
\[CloseCurlyDoubleQuote], and there is no legal obligation for \
microbiological testing, and somehow this then isn\[CloseCurlyQuote]t done. \
Thus, Dutch statistics, with the official death toll of 5748 at the end of \
May 2020, are based upon hospital admissions. RIVM\[CloseCurlyQuote]s \
modelers estimated the dynamic reproductive number ",
 StyleBox["R",
  FontSlant->"Italic"],
 "[",
 StyleBox["t",
  FontSlant->"Italic"],
 "] as getting below 1 by March 16, but based upon such hospital admissions \
where such testing is done. At the end of May, CBS Statistics Netherlands \
reported a total of 9000 \[OpenCurlyDoubleQuote]surplus death\
\[CloseCurlyDoubleQuote], i.e. above the normal level expected from earlier \
years. Thus some 3000 cases (likely mostly reported) were left untested.",
 StyleBox[" Why doesn\[CloseCurlyQuote]t RIVM make sure that all suspected \
cases are tested and included in the official statistics ? ",
  FontSlant->"Italic"],
 "If making sure that statistics are collected is not in ",
 StyleBox["their ",
  FontSlant->"Italic"],
 "job description, then in whose job description is it ?"
}], "Text",ExpressionUUID->"3ff34141-4a6c-45db-8085-01732ee140d4"],

Cell["\<\
Originally there was source and contact tracing by GGD but this was later \
repealed when the number of cases rose, instead of hiring more people to do \
the job. In May, the GGD director stated that they would be capable to take \
up source and contact tracing again. The media and eventually Parliament \
found it problematic that he mentioned some 2-3 hours per case, and that he \
intended to use of a letter of warning. Germany uses some 16 hours per case. \
A letter of warning might be used for a sexually transmitted infection while \
SARS-CoV-2 requires direct telephone calls. \
\>", "Text",ExpressionUUID->"3fae7f2a-30cc-4887-a001-674ecbc89f7a"],

Cell[TextData[{
 "If Holland had clammed down the infections from January like Taiwan did, \
and e.g. forbidden Carnival, and quarantined the provinces of Brabant and \
Limburg where they had the Carnival festivities anyway, then the economy \
would not have needed to lock down, and 9000 deaths by the end of May could \
have been prevented. Comparison with Malaysia Airlines MH17 with 298 deaths \
in 2014 might be seen as somewhat dramatic, but we are speaking about ",
 StyleBox["thirty ",
  FontSlant->"Italic"],
 "of such disasters, caused by home-grown ",
 StyleBox["failure of the protective system",
  FontSlant->"Italic"],
 "."
}], "Text",ExpressionUUID->"abff6cfd-92b8-4377-b0c3-4d2bea1c94b4"],

Cell[TextData[{
 "So, if RIVM is only advisory, what prevented the Dutch ",
 StyleBox["Ministry of Health ",
  FontSlant->"Italic"],
 "from seeing the notion of a ",
 StyleBox["pandemic",
  FontSlant->"Italic"],
 " in proper perspective, even while there had been ample warnings about \
pandemics before, and while",
 StyleBox[" they are the professionals on public health ",
  FontSlant->"Italic"],
 "? If we can understand what is blocking insights at government Departments \
of Health the world over, then perhaps we can find out what is blocking the ",
 StyleBox["insight on preventing",
  FontSlant->"Italic"],
 " pandemics in the first place. Yes, indeed \[OpenCurlyDoubleQuote]the world\
\[CloseCurlyDoubleQuote] is a big vague place outside of your own territory, \
but are you sure that you can really continue to neglect it ?"
}], "Text",ExpressionUUID->"615c722a-b36f-4241-93c6-050cce87ed76"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
1.6.6. While there is no vaccine: options for an exit strategy\
\>", "Subsubsection",ExpressionUUID->"6aee57c9-4b94-40e4-8912-e2de9796ba75"],

Cell["\<\
In all cases, there remains the challenge for the upcoming period till there \
would be a vaccine. \
\>", "Text",ExpressionUUID->"c764f68e-c3c5-42bd-a72f-8b10616db739"],

Cell[TextData[{
 "As an economist, I find it remarkable that the Dutch Prime Minister Mark \
Rutte (2020) (March 16) spoke about \"herd immunity\", first as one of the \
aims of the Dutch partial lockdown but later corrected to only a consequence \
and by-product of the real policy aim of flattening the curve. A crucial \
question is: if the government ",
 StyleBox["allows",
  FontSlant->"Italic"],
 " the virus to spread in a more natural way amongst the less-vulnerables, as \
a by-product, then why not use the virus as its own vaccine ? Apparently \
there is ",
 StyleBox["only ",
  FontSlant->"Italic"],
 "the problem of ",
 StyleBox["responsibility",
  FontSlant->"Italic"],
 " - so to speak \"",
 StyleBox["the (legal) blame",
  FontSlant->"Italic"],
 "\" - of ",
 StyleBox["who causes an infection",
  FontSlant->"Italic"],
 ", especially when it goes wrong: either some \"natural cause\", or the \
person self or a vaccinator. This issue of responsibility can better be \
discussed openly with an evaluation of the options, risks and costs involved. \
Also with an eye on future pandemics (that we rather ought to prevent \
though). Obviously, herd immunity is an objective in any vaccination \
programme, and vaccines differ from the dangerous pathogens: so the properly \
phrased question is whether this virus for this target subgroup of the \
less-vulnerables is like such vaccine and thus not the dangerous pathogen as \
it is for the vulnerables. One cannot avoid the impression that the Dutch \
government thought so, as it ",
 StyleBox["allowed ",
  FontSlant->"Italic"],
 "the virus to spread (though asking for self-quarantine)."
}], "Text",ExpressionUUID->"7dff0935-83ab-451d-ad51-a7ee515a6de8"],

Cell[TextData[{
 "Another element is: a vaccine test on humans also requires deliberate \
infection. McKie (2020) reports in May about the Van Bunnik et al. (2020) \
paper: \[OpenCurlyDoubleQuote]UK scientists want to infect volunteers with \
Covid-19 in race to find vaccine. Trials could be speeded up by using risky \
strategy of deliberately introducing the virus\[CloseCurlyDoubleQuote].  \
Critical researcher Riley at Edinburgh University: \
\[OpenCurlyDoubleQuote]Challenge studies are done for many diseases but only \
when strict criteria are followed. Firstly, the virus should be really well \
studied and its clinical behaviour understood in detail. It should also be \
incapable of causing severe illness in healthy individuals, or there should \
be a highly effective drug to clear the infection. None of these criteria are \
met for Covid-19, and I would be very concerned to hear challenge studies \
were being planned.\[CloseCurlyDoubleQuote] The latter reasoning is within \
the well-defined world of medical testing and its protocols. It neglects the \
phenomenon that the lifting of lockdown will cause the virus to spread again ",
 StyleBox["anyhow",
  FontSlant->"Italic"],
 ", and that the economy collapses if we do not lift the lockdown. "
}], "Text",ExpressionUUID->"6b9e7078-9247-4e94-8afb-f3dff7e20614"],

Cell[TextData[{
 "There are four main scenario\[CloseCurlyQuote]s on the table. All scenario\
\[CloseCurlyQuote]s rely upon some notion of ",
 StyleBox["infection status",
  FontSlant->"Italic"],
 ".  ",
 StyleBox["Chapter 4 ",
  FontWeight->"Bold"],
 "distinguishes actually 11 compartments with own risk profiles, and the \
compartments are indicated by a colouring scheme. An inspiration was my \
suggestion of having a \
\[OpenCurlyDoubleQuote]passport\[CloseCurlyDoubleQuote] for the status on \
sexually transmitted infections, see Colignatus (2004). At issue is not \
whether such compartments might exist, since any scenario uses their \
existence. At issue is whether it is feasible or even desirable to give ",
 StyleBox["an official role",
  FontSlant->"Italic"],
 " for such compartments."
}], "Text",ExpressionUUID->"8a258736-1afd-429e-a06c-f4969ad6db16"],

Cell[TextData[{
 StyleBox["(1) ",
  FontWeight->"Bold"],
 "The current policy by the Dutch government: muddle through, wait and see, \
prepare ICU capacity for the Autumn, apparently especially for the vulnerable \
compartment that has only a 50% of survival at the ICU (see below \
\[OpenCurlyDoubleQuote]ad 1\[CloseCurlyDoubleQuote])."
}], "Text",ExpressionUUID->"0a9680e2-d893-406b-84b4-050e4469ba15"],

Cell[TextData[{
 StyleBox["(2) ",
  FontWeight->"Bold"],
 "Lock-on-off. The \[OpenCurlyDoubleQuote]Harvard study\
\[CloseCurlyDoubleQuote], or Kissler et al. (2020). RIVM commented on it \
favourably, but also called it risky, and it need not be the policy of the \
Dutch government. Kissler et al. (2020) point to the need to have (recurrent) \
lock-on-offs to \[OpenCurlyDoubleQuote]flatten the curve\
\[CloseCurlyDoubleQuote] and remain within the capacity of the health system. \
They suggest that over two years some \[OpenCurlyDoubleQuote]herd immunity\
\[CloseCurlyDoubleQuote] can arise as a by-product as well. Thus, they allow \
infections, but shift the blame to \[OpenCurlyDoubleQuote]natural causes\
\[CloseCurlyDoubleQuote]. They might also think that it is ",
 StyleBox["impossible ",
  FontSlant->"Italic"],
 "to shield the vulnerables by quarantine so that there indeed would be a \
high demand for the ICU. Remarkably, RIVM (2020ef) in May still discuss only \
the Harvard study but ",
 StyleBox["not ",
  FontSlant->"Italic"],
 "the two following options that should already have been obvious in February \
too."
}], "Text",ExpressionUUID->"45652575-8064-4508-9ecd-06eb07fae929"],

Cell[TextData[{
 StyleBox["(3) ",
  FontWeight->"Bold"],
 "Eradication. There is the ",
 StyleBox["test, test, and test ",
  FontSlant->"Italic"],
 "approach, and then quarantine anybody who tests positive. Berger, \
Herkenhoff and Mongey (2020) provide a model-based ",
 StyleBox["proof of concept",
  FontSlant->"Italic"],
 ". Tabarrok (2020) supports the cost-effectiveness. Suppression fits the \
observation by Draulans and Piot (2020) that an infection may cause more \
damage than thought. It may be that the use of a SI(EY)A(CD) model is \
required for the proof of concept, but one might also argue that the method \
would be logical by itself too. The death toll could likely be calculated \
directly without a model run. In Holland in March, RIVM stated that there was \
a lack of tests. However, Alex Friedrich, head of microbiology and infection \
diseases of the University of Groningen medical center (UMCG), states that \
RIVM made a deliberate decision, and he arranged a testing strategy for \
Groningen, see 1V EenVandaag (2020) (April 17). RIVM misinformed the public \
about the options. At the end of May, the government and RIVM are making \
tests available for the whole country. Tweebeeke & Sietsma (2020) (June 10) \
report that elderly home care managers are distressed and furious that the \
much higher available capacity for testing has not been used at a much \
earlier moment."
}], "Text",ExpressionUUID->"b2bb310e-7b5f-4fd0-bdeb-de3e057236e7"],

Cell[TextData[{
 StyleBox["(4) ",
  FontWeight->"Bold"],
 "Segment and shield. A policy is to distinguish a compartment of vulnerables \
- say 60+ and those with comorbidity - and a compartment of less vulnerables \
- the younger others though perhaps still with some hidden risk. Van Bunnik \
et al. (2020) (May 5) call this \[OpenCurlyDoubleQuote]segmenting and \
shielding\[CloseCurlyDoubleQuote], see also Sample & Mason (2020). The issue \
is discussed by Colignatus (2020bcd) (March 31) and with a full model by \
epidemiologists De Vlas & Coffeng (2020) (April 12) at Erasmus MC, while \
Frijters (2020) (March 21) has much by implication. A non-quantitative \
discussion is by Eichenberger et al. (2020) (March 25), who also point to the",
 StyleBox[" rising frustration by the immune compartment when they would be \
subjected to a string of lock-on-offs. ",
  FontSlant->"Italic"],
 "Criticism is:",
 StyleBox[" ",
  FontSlant->"Italic"],
 "(a) Sridhar & Rafiei (2020) argue that it is ",
 StyleBox["practically impossible ",
  FontSlant->"Italic"],
 "to shield the vulnerables. Government policies like in the UK and Holland \
already promised such shielding but actually only achieved this by the \
national lockdown. Adamik et al. (2020) alert us that families magnify the \
number of contacts. The proper question is: ",
 StyleBox["Have we done enough to achieve the required shielding ? ",
  FontSlant->"Italic"],
 "(b) There is the protest that deliberate infection runs against the rules \
for vaccination. This is better seen in the light of the Draulans and Piot \
(2020) observation that it is a nasty virus that can have chronic effects. If \
there were no nasty effects then the principle on vaccination would actually \
be adhered to (which is also why the idea originated)."
}], "Text",ExpressionUUID->"9aaa91e4-84c7-4b29-956c-9a9b6b0a071b"],

Cell[TextData[{
 "We arrive at the latter scenario ",
 StyleBox["without ",
  FontSlant->"Italic"],
 "the SI(EY)A(CD) models. Thus, our praise for SI(EY)A(CD) is guarded. We \
could have arrived at such compartmentalisation also in February, right after \
the WHO declaration of the PHEIC. A modeler\[CloseCurlyQuote]s question \
obviously is whether these two sections in the population can be put into the \
 model, and how would they interact ? To some extent it is remarkable and \
even amazing that RIVM in its reports to Dutch parliament hasn\
\[CloseCurlyQuote]t much reported on these two structural compartments, and \
still presents only a single ",
 StyleBox["R",
  FontSlant->"Italic"],
 "[",
 StyleBox["t",
  FontSlant->"Italic"],
 "], as if persons from the two compartments could freely mingle, and as if \
it should not be obvious that there is quite a distinction between the \
elderly and comorbids who would ",
 StyleBox["always",
  FontSlant->"Italic"],
 " have to be quarantined and the others for who contact reduction is ",
 StyleBox["less relevant",
  FontSlant->"Italic"],
 "."
}], "Text",ExpressionUUID->"ca4bc0ca-d408-409c-b43c-4b2bcda4bb44"],

Cell["\<\
Consider the following figures about the Dutch population, latest age-group \
data of 2019, using the level of 17.4 million of 2020. For SARS-CoV-2 there \
are 9000 \[OpenCurlyDoubleQuote]surplus deaths\[CloseCurlyDoubleQuote] \
including 5748 official deaths, of which 177 below the age of 60, of which \
none in the ages 9-14. Let us allocate the 3252 = 9000 - 5748 unofficial \
deaths in proportion. The distinction of the chronically ill and multi-morbid \
are by Van Oostrom et al. (2011). Multi-morbidity is defined as having at \
least 2 chronic afflictions. Their age-group specific prevalences are applied \
to the age-groups of 2019. It is remarkable that the younger vulnerables have \
such a low SARS-CoV-2 death score, but they do not tend to live in care \
homes. \
\>", "Text",ExpressionUUID->"bcc4e7e2-a177-406f-b5e2-c1eeb4c485f6"],

Cell[TextData[Cell[BoxData[GridBox[{
   {
    RowBox[{"Category", " ", "\\", " ", "Age"}], 
    RowBox[{"<", "60"}], 
    RowBox[{"60", "+"}], "Total"},
   {
    RowBox[{"Population", " ", "2019"}], "12.9", "4.5", 
    RowBox[{"17.4", " ", "million"}]},
   {
    RowBox[{"Chronically", " ", "ill"}], "3.4", "3.1", 
    RowBox[{"6.4", " ", "million"}]},
   {
    RowBox[{"Multi", " ", "morbid"}], "0.9", "1.8", 
    RowBox[{"2.7", " ", "million"}]},
   {
    RowBox[{"SARS", "-", "CoV", "-", 
     RowBox[{"2", " ", "dead"}]}], "177", "5571", 
    RowBox[{"5748", " ", "persons"}]},
   {
    RowBox[{"Idem", " ", "unofficial"}], "100", "3152", 
    RowBox[{"3252", "persons"}]}
  },
  GridBoxDividers->{
   "Columns" -> {{True}}, 
    "Rows" -> {{
      True}}}]],ExpressionUUID->"cdee6f0e-a0ba-469b-9e47-d5cd0b059402"]], \
"Text",
 FontSize->12,ExpressionUUID->"c7889614-f4e0-4536-80a7-b2b6a24680c9"],

Cell["\<\
Let us identify the vulnerables as the 60+ and the younger chronically ill \
(which includes the multi-morbid), thus 4.5 + 3.4 \[TildeTilde] 7.9 million \
(45%). Then the less-vulnerables are 9.5 million (55%).\
\>", "Text",ExpressionUUID->"c6aaa225-ecfd-4470-a46a-8a5d074d1e23"],

Cell["\<\
Let us assume that the vulnerables are put into quarantine but that 1% of \
quarantines will be breached, with the group-specific IFF of 5.1% (observed \
for the 60+), meaning 7.9 million x 1% x 5.1% \[TildeTilde] 4029 deaths. \
Potentially, all these deaths have tried the ICU with a 50% chance of \
survival (but still this net outcome). Regrettably there is no good \
indication for the IFF of the younger vulnerables.\
\>", "Text",ExpressionUUID->"36976bdf-f9b3-4723-bf3a-14798945ccaf"],

Cell[TextData[{
 "The less-vulnerables will have the (observed) group-specific IFF of 0.06%. \
Avoiding the confusion of \"herd immunity\" we adopt 95% of the limit value \
Ap[\[Infinity]]. With a ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "46221014-4e4e-4af6-b860-9f71aef4c7ae"],
 " = 4 (chosen from the literature), the limit value of all infections is Ap[\
\[Infinity]] = 0.98. A value of 95% of this limit value is 93.1% and this is \
reached after some three months. This means 9.5 million x 93.1% x 0.06% \
\[TildeTilde] 5307 deaths. All these youngsters will likely have been to the \
ICU, with a 90% chance at survival (and still said net outcome). The ICU will \
not be oversupplied (allowing for normal service too) if the infections take \
place in cohorts of 325,000 every 1.5 weeks, for a total of some 10 months. \
These cohorts are spread over hospital service areas. These assumptions give \
the following table, and a more detailed discussion with an Excel spreadsheet \
is provided by Colignatus (2020d) (update in the next week)."
}], "Text",ExpressionUUID->"df155830-1081-4c9e-9a67-201233e911e4"],

Cell[TextData[Cell[BoxData[GridBox[{
   {
    RowBox[{"Category", " ", "\\", " ", "Compartment"}], "Vulnerables", 
    RowBox[{"Less", " ", "Vulnerables"}], "Total"},
   {
    RowBox[{"Population", " ", "2019"}], "7.9", "9.5", 
    RowBox[{"17.4", " ", "million"}]},
   {
    RowBox[{"Infected", ":", " ", 
     RowBox[{"breaches", " ", "vs", " ", "deliberate"}]}], 
    RowBox[{"1", "%"}], 
    RowBox[{"93.1", " ", "%"}], 
    RowBox[{"8.9", " ", "million"}]},
   {
    RowBox[{"Infection", " ", "Fatality", " ", "Factor", " ", 
     RowBox[{"(", "IFF", ")"}]}], 
    RowBox[{"5.1", "%"}], 
    RowBox[{"0.06", " ", "%"}], 
    RowBox[{"Quarantine", " ", "average"}]},
   {
    RowBox[{"SARS", "-", "CoV", "-", 
     RowBox[{"2", " ", "deaths"}]}], "4029", "5307", 
    RowBox[{"9336", "persons"}]},
   {
    RowBox[{"Maximum", " ", "deaths", " ", 
     RowBox[{"(", 
      RowBox[{"100", "%"}], ")"}]}], "402900", "5700", 
    RowBox[{"408600", " ", "persons"}]}
  },
  GridBoxDividers->{
   "Columns" -> {{True}}, 
    "Rows" -> {{
      True}}}]],ExpressionUUID->"ebfdc6f9-418f-4656-93c5-740401845bcd"]], \
"Text",
 FontSize->12,ExpressionUUID->"57199ae6-1a94-480d-8206-3f90f8cb9cf3"],

Cell[TextData[{
 "At issue is not the choice between",
 StyleBox[" lockdown ",
  FontSlant->"Italic"],
 "versus \[OpenCurlyDoubleQuote]",
 StyleBox["let the pandemic run its course",
  FontSlant->"Italic"],
 "\[CloseCurlyDoubleQuote]. At issue is a sound (and not only preached) \
quarantine of the vulnerable ",
 StyleBox["and",
  FontSlant->"Italic"],
 " ",
 StyleBox["possibly ",
  FontSlant->"Italic"],
 "deliberate (self-) infection of the less-vulnerable with sufficient medical \
backup if something goes wrong (because it remains risky to predict who would \
be less-vulnerable). This does not yet include the observation by Peter Piot \
on chronic effects of infection."
}], "Text",ExpressionUUID->"68e1695e-ac41-4fbe-8556-61021eb3e8f7"],

Cell[TextData[{
 "The scheme is not without risks, for example when people cross the \
quarantine barriers. This idea thus requires close discussion. See Van Bunnik \
et al. (2020) for their version of \[OpenCurlyDoubleQuote]segment and shield\
\[CloseCurlyDoubleQuote] and self-infection, see also McKie (2020). The idea \
to deliberately speed up the path to the limit values provides a way to cope \
with the economic recession, which otherwise might develop into worse than \
the Depression of 1930-1941. The world has some luck that the SARS-CoV-2 \
pandemic hits an identifiable compartment in society. In another situation, \
when potential victims cannot be identified so easily, it would be much \
harder to think of a solution approach (other than ",
 StyleBox["test, test, and test",
  FontSlant->"Italic"],
 "). The sobering idea is the observation by Peter Piot that we actually may \
be in such a much harder situation, with a burden of disease that still must \
be diagnosed."
}], "Text",ExpressionUUID->"55cfdb2a-33b3-4308-b642-b2252d18a6e9"],

Cell[TextData[{
 "Above compartmentalisation could have been done in February with the \
information available at that time. Why were these policy options not \
formulated in this manner ? The potential answer is: RIVM might be rather a \
\[OpenCurlyDoubleQuote]",
 StyleBox["Bureau of Infection Statistics",
  FontSlant->"Italic"],
 "\[CloseCurlyDoubleQuote] and not an \[OpenCurlyDoubleQuote]",
 StyleBox["Infection Planning Bureau",
  FontSlant->"Italic"],
 "\[CloseCurlyDoubleQuote]. Though there are \[OpenCurlyDoubleQuote]the three \
scenario\[CloseCurlyQuote]s\[CloseCurlyDoubleQuote], also on the RIVM \
website, it still seems as if they do not have a tradition of making such \
scenario\[CloseCurlyQuote]s, and if they do not wish to speculate about the \
number of deaths as if such discussion would make it seem as if they are \
responsible for those deaths. RIVM advises, they report and trace infections \
and advise on vaccinations rather than \[OpenCurlyDoubleQuote]plan\
\[CloseCurlyDoubleQuote] infections in the sense of advising on organising \
who gets what. Vaccinations are ",
 StyleBox["designed t",
  FontSlant->"Italic"],
 "o protect the ",
 StyleBox["vaccinator",
  FontSlant->"Italic"],
 " from accusations of wrong-doing. By consequence, at the end of May, \
Holland has 9000 deaths, but precisely in the category of the vulnerables, \
the very group that RIVM advised to protect. Risk aversion behaviour caused \
the risk to actually happen (to others than RIVM itself). And while Holland \
in May somewhat recovers from the first wave, above scenario with another \
9336 deaths is still in the waiting, at least if we want \
\[OpenCurlyDoubleQuote]segment and shield\[CloseCurlyDoubleQuote] as an exit \
strategy for the economic crisis."
}], "Text",ExpressionUUID->"b372c88c-1ac5-4903-a15e-7c3c6938dc75"],

Cell[TextData[{
 "(ad 1) We can compare with the Dutch planning on ICU beds, see NVIC & \
Gommers (2020) and NVIC (2020) (April 26), the Dutch association of intensive \
care doctors. Their calculation is elementary. Their population are the 20+ \
aged: 13,490,325. They observe that 4% has been infected (based upon testing \
of blood samples) and that this will grow to 60% in the next three years. \
(Possibly confused about herd immunity, or assuming a permanent quarantine of \
40%, or assuming a ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "31f27675-af11-42cd-8476-1fbed8b9617f"],
 " = 1.5.) The 4% arose over 8 weeks, so that the other 56% would take some \
112 weeks, but with a lower ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "0"], TraditionalForm]],ExpressionUUID->
  "5e3f06af-1ef3-4f22-acd4-be104b0abde4"],
 " they now assume 156 weeks or three years. Of the infected, 0.45% arrives \
at the ICU. (Thus they assume that the vulnerables will not be protected, \
because only those have such high demand.) With 19 days per patient (indeed \
for the vulnerables) this translates into 700,000 bed-days. In the 8 weeks \
from March to April 2020 there were 2500 patients. With another 37500 persons \
to go, this would imply 15 other 8 week periods. While 1150 ICU beds is the \
Dutch standard, the new standard would be 1531 beds. A peak capacity of 2400 \
beds seems required. NVIC admits that regular care has suffered from the \
SARS-CoV-2 episode. What is remarkable in this calculation is that NVIC does \
not distinguish between the two compartments. It is remarkable that they do \
not mention the death toll: they plan beds, and if survival is only 50%, then \
this is not in their planning. They do not strongly advise that much more is \
done to ",
 StyleBox["prevent",
  FontSlant->"Italic"],
 " vulnerable patients to get infected in the first place. This kind of \
planning helps to obscure the issue. When there are sufficient beds \
available, then beginning-of-pipe organisations with care of the vulnerables \
might think that they have room to send patients downstream, while an \
infection may still come with quite some risk."
}], "Text",ExpressionUUID->"c23ee4cf-5cb1-4d70-b7ca-70405ea83f69"],

Cell[TextData[{
 "We will return to the issue in ",
 StyleBox["Chapter 2",
  FontWeight->"Bold"],
 ". In all cases, a discussion of these aspects requires an underlying \
understanding of epidemics. This translates as a basic understanding of \
models of epidemics."
}], "Text",ExpressionUUID->"8c152d32-ff00-45d5-8a56-40e99b4e22af"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.6.7. Information that is missing now about such scenarios", \
"Subsubsection",ExpressionUUID->"11094856-4a68-4b86-a710-a9ef819ef0f8"],

Cell["\<\
Information that is missing now, and that we would need for informed decision \
making, is the following.\
\>", "Text",ExpressionUUID->"b1f12237-2c99-4b7f-91aa-79d4eed51a29"],

Cell["\<\
Common effect measures are lives extended (\[OpenCurlyDoubleQuote]lives saved\
\[CloseCurlyDoubleQuote]) and (quality adjusted) life-years gained. \
Colignatus (2003) (2020b) proposes the Unit-Sqrt compromise: though mortality \
and qaly\[CloseCurlyQuote]s might no longer be needed, it still would be \
useful to calculate them to clarify the compromise. The issue is complicated \
by the Piot (2020) implication of chronic effects (an argument for \
eradication and an argument against deliberate infection: but there is \
uncertainty about the effect size), and we may include the increased \
awareness of the Post Intensive Care Syndrome (PICS). Such effects do not \
affect the death count but reduce the qaly\[CloseCurlyQuote]s and increase \
economic costs. PM. Such effect measures require the extension of the \
modeling with the hospital sector, not included in the present SI(EY)A(CD) \
model family. Models with such enlargement are Goh (2020) and Berger et al. \
(2020) and Acemoglu et al. (2020). Relevant is Bodenstein, Corsetti, \
Guerrieri (2020), for the distinctions in economic sectors, and that rational \
policies, including lockdowns, are preferable above chaos. For the present \
modeling, I give priority on didactics above including such enlargements.\
\>", "Text",ExpressionUUID->"30164348-d07a-48ec-80c8-f06b0751f47e"],

Cell["\<\
While the alternative scenarios of eradication (assuming that asymptomatic \
infection allows this) versus \[OpenCurlyDoubleQuote]segment and shield\
\[CloseCurlyDoubleQuote] (with quarantine for the vulnerables and cohort-wise \
deliberate infection for the less vulnerables) seem rather well defined, it \
is still unclear what the current government policy is (except that it starts \
to look like the Harvard lock-on-off), and it needs to be defined if we want \
to be able to compare outcomes. \
\>", "Text",ExpressionUUID->"5208340e-88f8-40cb-86ef-18e91d4b0fda"],

Cell["\<\
For the base scenario, the first half of the year 2020 forms a sunk cost. We \
would be interested in an evaluation but there is no use in crying over \
spilled milk (except for restructuring the social decision making process). \
We better start from the present state of the economy and health system, and \
work from there. Since government policy can be expected to be erratic, we \
need a stable base scenario. The best selection is a path that avoids global \
warming and reduces the risks of future pandemics. It would be rather \
irrational to assume a path towards global warming with new pandemics, and \
then try to micro-manage the case of 2020 on this path. Indeed, it makes \
sense to assume a structural change, and then evaluate policies about \
SARS-CoV-2 in this context. See Colignatus (2020fg) for the Tinbergen & \
Hueting approach in the economics of National Accounts and ecological \
survival.\
\>", "Text",ExpressionUUID->"37ea085d-872a-46fe-9d8e-a933c0260793"],

Cell["\<\
The required information is in the following table. We would gauge the costs \
not only in sizeable percentages of national income and national debt, but \
also in terms of unemployment, private debt and bankruptcy, and measures of \
inequality. We see a strange combination of both epidemiological modeling \
that reckons in days and macro-economic modeling that concerns the medium \
term (5 years) and the long term (the year 2100). A new topic is how the \
standard economic models would need to be adapted to the new circumstances - \
while it seems that we did not yet finish the discussion on including the \
financial crisis. PM. Mortality rates are w.r.t. the population (as opposed \
to the IFF that is w.r.t. the infected). PM. S&S = \
\[OpenCurlyDoubleQuote]segment and shield\[CloseCurlyDoubleQuote].\
\>", "Text",ExpressionUUID->"6900d1af-a9a6-4139-8e43-581abbd5aa05"],

Cell[TextData[Cell[BoxData[GridBox[{
   {
    RowBox[{"Category", " ", "\\", " ", "Compartment"}], "Vulnerables", 
    RowBox[{"Less", " ", "Vulnerables"}], "Total"},
   {
    RowBox[{"Population", " ", "2019"}], "7.9", "9.5", 
    RowBox[{"17.4", " ", "million"}]},
   {
    RowBox[{
     RowBox[{"Mortality", " ", "by", " ", "SARS"}], "-", "CoV", "-", "2"}], 
    SubscriptBox["\[Mu]", "VC"], 
    SubscriptBox["\[Mu]", "LC"], 
    RowBox[{"(", 
     RowBox[{"2020", " ", "as", " ", "sunk", " ", "cost"}], ")"}]},
   {
    RowBox[{"Mortality", " ", "by", " ", "reduced", " ", "care"}], 
    SubscriptBox["\[Mu]", "VR"], 
    SubscriptBox["\[Mu]", "LR"], 
    RowBox[{"(", 
     RowBox[{"take", " ", "a", " ", "longer", " ", "horizon"}], ")"}]},
   {
    RowBox[{"Mortality", " ", "in", " ", "eradication"}], 
    SubscriptBox["\[Mu]", "VE"], 
    SubscriptBox["\[Mu]", "LE"], 
    RowBox[{"(", 
     RowBox[{"needs", " ", "elaboration"}], ")"}]},
   {
    RowBox[{
     RowBox[{
      RowBox[{"Mortality", " ", "in", " ", "S"}], "&"}], "S"}], 
    SubscriptBox["\[Mu]", "VA"], 
    SubscriptBox["\[Mu]", "LA"], 
    RowBox[{"(", 
     RowBox[{"quarantine", " ", "vs", " ", "deliberate", " ", "infection"}], 
     ")"}]},
   {
    RowBox[{
     RowBox[{"Lifeyears", " ", "Lost", " ", "by", " ", "SARS"}], "-", "CoV", 
     "-", "2"}], 
    SubscriptBox["\[Lambda]", "VC"], 
    SubscriptBox["\[Lambda]", "LC"], 
    RowBox[{"(", 
     RowBox[{"2020", "  ", "as", " ", "sunk", " ", "cost"}], ")"}]},
   {
    RowBox[{
    "Lifeyears", " ", "lost", " ", "by", " ", "reduced", " ", "care"}], 
    SubscriptBox["\[Lambda]", "VR"], 
    SubscriptBox["\[Lambda]", "LR"], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2020", "  ", "as", " ", "sunk", " ", "cost"}], ")"}], " "}]},
   {
    RowBox[{"Lifeyears", " ", "lost", " ", "in", " ", "eradication"}], 
    SubscriptBox["\[Lambda]", "VE"], 
    SubscriptBox["\[Lambda]", "LE"], " "},
   {
    RowBox[{
     RowBox[{
      RowBox[{"Lifeyears", " ", "lost", " ", "in", " ", "S"}], "&"}], "S"}], 
    SubscriptBox["\[Lambda]", "VA"], 
    SubscriptBox["\[Lambda]", "LA"], " "},
   {
    RowBox[{
     RowBox[{"Unit", " ", "sqrt", " ", "measure"}], ",", " ", 
     RowBox[{"govt", " ", "policy"}]}], 
    SubscriptBox["\[Upsilon]", 
     RowBox[{
      RowBox[{"VC", "&"}], "R"}]], 
    SubscriptBox["\[Upsilon]", 
     RowBox[{
      RowBox[{"VL", "&"}], "R"}]], 
    RowBox[{"Colignatus", " ", 
     RowBox[{"(", "2003", ")"}]}]},
   {
    RowBox[{"Unit", " ", "sqrt", " ", "in", " ", "eradication"}], 
    SubscriptBox["\[Upsilon]", "VE"], 
    SubscriptBox["\[Upsilon]", "LE"], " "},
   {
    RowBox[{
     RowBox[{
      RowBox[{"Unit", " ", "sqrt", " ", "in", " ", "S"}], "&"}], "S"}], 
    SubscriptBox["\[Upsilon]", "VA"], 
    SubscriptBox["\[Upsilon]", "LA"], " "},
   {
    RowBox[{
     RowBox[{"Economic", " ", "cost"}], ",", " ", 
     RowBox[{"govt", " ", "policy"}]}], " ", " ", 
    RowBox[{"(", 
     RowBox[{"likely", " ", "aggregate", " ", "only"}], ")"}]},
   {
    RowBox[{"Economic", " ", "cost", " ", "in", " ", "eradication"}], " ", 
    " ", 
    RowBox[{"(", 
     RowBox[{"cost", " ", "defined", " ", 
      RowBox[{"w", ".", "r", ".", "t", ".", " ", "base"}], " ", "scenario"}], 
     ")"}]},
   {
    RowBox[{
     RowBox[{
      RowBox[{"Economic", " ", "cost", " ", "in", " ", "S"}], "&"}], "S"}], 
    " ", " ", " "}
  },
  GridBoxDividers->{
   "Columns" -> {{True}}, 
    "Rows" -> {{
      True}}}]],ExpressionUUID->"08bd30db-2970-4e5d-bece-ff55b0d72098"]], \
"Text",
 FontSize->12,ExpressionUUID->"f6758eb8-8bd0-429a-8eaa-fae5d4d9ce7f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.7. Summary of a complex objective", "Subsection",ExpressionUUID->"91f5ccfc-2e50-423a-918e-932834f43e6b"],

Cell["In summary, this notebook has a complex objective:", "Text",ExpressionUUID->"6c84c41e-c476-491f-bcb7-e6828c446318"],

Cell[TextData[{
 "(a) Redesign of didactics about SI(EY)A(CD) in order to reduce confusion.\n\
(b) Document the latter within the computer algebra environment of ",
 StyleBox["Mathematica.\n",
  FontSlant->"Italic"],
 "(c) Middle of the road: we may assume novice readers but do not aspire at \
an introductory ",
 StyleBox["course ",
  FontSlant->"Italic"],
 "for novices, and allow for refreshment for modelers.",
 StyleBox["\n",
  FontSlant->"Italic"],
 "(d) Make this modeling and documentation very accessible for others, also \
for variants.\n(e) Use SARS-CoV-2 parameter estimates and scenarios as \
examples for such SI(EY)A(CD).\n(f) Place the discussion within the \
literature, with real data and commentary about the quality of the data.\n(g) \
Allow for some creativity along the way, like the use of colour-coding for \
(quarantine) compartments.\n(h) Give the context of above ",
 StyleBox["exit strategies ",
  FontSlant->"Italic"],
 "of eradication or using the virus as its own vaccine.\n(i) Identify what \
information is missing, which we need when we want to make informed \
decisions.\n(j) Regard the pandemic as only an example of a much more \
fundamental issue, see Colignatus (2020a)."
}], "Text",ExpressionUUID->"6ea7b554-6a35-4098-a0a4-2e4bbe6db753"],

Cell[TextData[{
 "SI(EY)A(CD) is only a very basic model. It is adequate only for ",
 StyleBox["outlining",
  FontSlant->"Italic"],
 " the ",
 StyleBox["exit strategies. ",
  FontSlant->"Italic"],
 "It allows us to show that the current (partial) lockdown is wise as an \
emergency brake - for Holland - given the otherwise deadly outbreak, with a \
rough indication of how many deaths would have occurred otherwise. It allows \
us to observe that said ",
 StyleBox["exit strategies ",
  FontSlant->"Italic"],
 "were already feasible in February, so that the lockdown in March was an ",
 StyleBox["emergency brake ",
  FontSlant->"Italic"],
 "indeed. It also allows us (in a later notebook) to evaluate the (quality \
adjusted) life-years gained, since we should not focus on the mortality count \
only