/*************************************************************

  LSD 7.1 - December 2018
  written by Marco Valente, Universita' dell'Aquila
  and by Marcelo Pereira, University of Campinas

  Copyright Marco Valente and Marcelo Pereira
  LSD is distributed under the GNU General Public License

 *************************************************************/

/*************************************************************
  NOLH.H
  Contains near-orthogonal Latin hypercube designs of experiments (DoE).

  The DoEs contained here are used under the license of the copyright owners:
  NOLHDesigns_v6.xls is copyrighted by Susan M. Sanchez under a GPL 2.1 license, http://harvest.nps.edu
  NOB_Mixed_512DP_v1.xls is copyrighted by Helcio Vieira under a GPL 2.1 license, http://harvest.nps.edu
*************************************************************/

// NOLH tables (Sanchez 2009 + Cioppa 2002)
int NOLH_1[ ][ 7 ] = { {6, 17, 14, 7, 5, 16, 10}, {2, 5, 15, 10, 1, 6, 11}, {3, 8, 2, 5, 11, 14, 17}, {4, 11, 6, 17, 10, 3, 13}, {13, 16, 8, 3, 6, 1, 14},
  {17, 6, 7, 14, 2, 13, 15}, {11, 4, 17, 6, 15, 8, 16}, {10, 15, 13, 16, 14, 11, 12}, {9, 9, 9, 9, 9, 9, 9}, {12, 1, 4, 11, 13, 2, 8}, {16, 13, 3, 8, 17, 12, 7},
  {15, 10, 16, 13, 7, 4, 1}, {14, 7, 12, 1, 8, 15, 5}, {5, 2, 10, 15, 12, 17, 4}, {1, 12, 11, 4, 16, 5, 3}, {7, 14, 1, 12, 3, 10, 2}, {8, 3, 5, 2, 4, 7, 6},
  {14, 10, 5, 16, 6, 17, 7}, {15, 11, 1, 6, 2, 5, 10}, {2, 17, 11, 14, 3, 8, 5}, {6, 13, 10, 3, 4, 11, 17}, {8, 14, 6, 1, 13, 16, 3}, {7, 15, 2, 13, 17, 6, 14},
  {17, 16, 15, 8, 11, 4, 6}, {13, 12, 14, 11, 10, 15, 16}, {4, 8, 13, 2, 12, 1, 11}, {3, 7, 17, 12, 16, 13, 8}, {16, 1, 7, 4, 15, 10, 13}, {12, 5, 8, 15, 14, 7, 1},
  {10, 4, 12, 17, 5, 2, 15}, {11, 3, 16, 5, 1, 12, 4}, {1, 2, 3, 10, 7, 14, 12}, {5, 6, 4, 7, 8, 3, 2}
};

int NOLH_2[ ][11] = { {15, 7, 29, 23, 16, 33, 23, 21, 4, 20, 33}, {5, 13, 16, 25, 11, 30, 15, 7, 33, 28, 30}, {30, 6, 2, 24, 2, 11, 32, 20, 15, 13, 29},
  {33, 14, 31, 27, 3, 15, 4, 6, 29, 8, 19}, {16, 8, 23, 14, 19, 3, 5, 24, 2, 23, 31}, {11, 10, 15, 6, 29, 2, 18, 8, 31, 25, 32}, {32, 9, 1, 13, 30, 29, 1, 22, 16, 10, 23},
  {31, 12, 30, 8, 33, 18, 31, 9, 23, 7, 18}, {8, 18, 24, 1, 7, 20, 20, 11, 9, 3, 22}, {10, 23, 8, 4, 13, 28, 7, 18, 22, 2, 25}, {25, 32, 12, 5, 6, 13, 21, 3, 8, 22, 24},
  {22, 31, 25, 16, 14, 8, 6, 32, 24, 19, 26}, {7, 19, 20, 32, 26, 12, 10, 5, 6, 1, 20}, {13, 29, 6, 31, 24, 9, 26, 19, 20, 5, 28}, {28, 30, 13, 22, 25, 24, 12, 1, 7, 30, 21},
  {20, 33, 27, 19, 22, 27, 25, 30, 21, 18, 27}, {17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17}, {19, 27, 5, 11, 18, 1, 11, 13, 30, 14, 1}, {29, 21, 18, 9, 23, 4, 19, 27, 1, 6, 4},
  {4, 28, 32, 10, 32, 23, 2, 14, 19, 21, 5}, {1, 20, 3, 7, 31, 19, 30, 28, 5, 26, 15}, {18, 26, 11, 20, 15, 31, 29, 10, 32, 11, 3}, {23, 24, 19, 28, 5, 32, 16, 26, 3, 9, 2},
  {2, 25, 33, 21, 4, 5, 33, 12, 18, 24, 11}, {3, 22, 4, 26, 1, 16, 3, 25, 11, 27, 16}, {26, 16, 10, 33, 27, 14, 14, 23, 25, 31, 12}, {24, 11, 26, 30, 21, 6, 27, 16, 12, 32, 9},
  {9, 2, 22, 29, 28, 21, 13, 31, 26, 12, 10}, {12, 3, 9, 18, 20, 26, 28, 2, 10, 15, 8}, {27, 15, 14, 2, 8, 22, 24, 29, 28, 33, 14}, {21, 5, 28, 3, 10, 25, 8, 15, 14, 29, 6},
  {6, 4, 21, 12, 9, 10, 22, 33, 27, 4, 13}, {14, 1, 7, 15, 12, 7, 9, 4, 13, 16, 7}, {29, 4, 33, 7, 21, 15, 20, 23, 33, 16, 23}, {16, 33, 30, 13, 7, 5, 28, 15, 30, 11, 25},
  {2, 15, 11, 6, 20, 30, 13, 32, 29, 2, 24}, {31, 29, 15, 14, 6, 33, 8, 4, 19, 3, 27}, {23, 2, 3, 8, 24, 16, 23, 5, 31, 19, 14}, {15, 31, 2, 10, 8, 11, 25, 18, 32, 29, 6},
  {1, 16, 29, 9, 22, 32, 10, 1, 23, 30, 13}, {30, 23, 18, 12, 9, 31, 7, 31, 18, 33, 8}, {24, 9, 20, 18, 11, 8, 3, 20, 22, 7, 1}, {8, 22, 28, 23, 18, 10, 2, 7, 25, 13, 4},
  {12, 8, 13, 32, 3, 25, 22, 21, 24, 6, 5}, {25, 24, 8, 31, 32, 22, 19, 6, 26, 14, 16}, {20, 6, 12, 19, 5, 7, 1, 10, 20, 26, 32}, {6, 20, 9, 29, 19, 13, 5, 26, 28, 24, 31},
  {13, 7, 24, 30, 1, 28, 30, 12, 21, 25, 22}, {27, 21, 27, 33, 30, 20, 18, 25, 27, 22, 19}, {5, 30, 1, 27, 13, 19, 14, 11, 1, 18, 11}, {18, 1, 4, 21, 27, 29, 6, 19, 4, 23, 9},
  {32, 19, 23, 28, 14, 4, 21, 2, 5, 32, 10}, {3, 5, 19, 20, 28, 1, 26, 30, 15, 31, 7}, {11, 32, 31, 26, 10, 18, 11, 29, 3, 15, 20}, {19, 3, 32, 24, 26, 23, 9, 16, 2, 5, 28},
  {33, 18, 5, 25, 12, 2, 24, 33, 11, 4, 21}, {4, 11, 16, 22, 25, 3, 27, 3, 16, 1, 26}, {10, 25, 14, 16, 23, 26, 31, 14, 12, 27, 33}, {26, 12, 6, 11, 16, 24, 32, 27, 9, 21, 30},
  {22, 26, 21, 2, 31, 9, 12, 13, 10, 28, 29}, {9, 10, 26, 3, 2, 12, 15, 28, 8, 20, 18}, {14, 28, 22, 15, 29, 27, 33, 24, 14, 8, 2}, {28, 14, 25, 5, 15, 21, 29, 8, 6, 10, 3},
  {21, 27, 10, 4, 33, 6, 4, 22, 13, 9, 12}, {7, 13, 7, 1, 4, 14, 16, 9, 7, 12, 15}
};

int NOLH_3[ ][16] = { {47, 24, 22, 9, 50, 52, 32, 47, 36, 61, 63, 4, 13, 41, 53, 45}, {62, 8, 28, 23, 17, 36, 49, 60, 50, 32, 47, 47, 16, 23, 23, 11}, {58, 62, 15, 20, 56, 11, 30, 38, 52, 57, 27, 24, 31, 34, 18, 58},
  {42, 47, 30, 5, 28, 18, 18, 64, 59, 41, 9, 58, 6, 14, 56, 22}, {60, 13, 2, 7, 11, 17, 40, 32, 5, 55, 40, 31, 42, 39, 46, 52}, {35, 16, 32, 11, 43, 10, 56, 8, 27, 51, 58, 60, 58, 5, 12, 4},
  {50, 35, 3, 17, 22, 58, 28, 29, 23, 59, 11, 13, 62, 48, 7, 36}, {53, 60, 21, 25, 60, 46, 2, 21, 2, 42, 17, 50, 47, 3, 36, 13}, {45, 2, 53, 27, 40, 26, 7, 20, 55, 26, 52, 3, 22, 16, 34, 65},
  {63, 32, 50, 1, 19, 60, 25, 1, 44, 3, 44, 45, 28, 55, 2, 31}, {34, 63, 35, 14, 29, 21, 45, 16, 47, 13, 2, 2, 15, 4, 16, 54}, {64, 45, 60, 12, 5, 25, 53, 25, 35, 17, 21, 34, 30, 38, 60, 15},
  {36, 22, 42, 26, 32, 13, 19, 62, 10, 4, 62, 15, 64, 12, 41, 48}, {51, 28, 58, 18, 63, 4, 1, 35, 17, 20, 34, 36, 34, 44, 26, 26}, {38, 51, 62, 29, 15, 31, 61, 54, 1, 29, 10, 22, 63, 20, 38, 56},
  {44, 36, 47, 10, 62, 65, 37, 53, 24, 8, 30, 38, 45, 64, 55, 29}, {56, 26, 9, 44, 65, 51, 63, 39, 21, 19, 38, 29, 27, 42, 44, 25}, {37, 18, 23, 38, 30, 54, 52, 48, 8, 1, 24, 56, 1, 6, 24, 46},
  {48, 37, 20, 51, 58, 3, 27, 52, 32, 6, 35, 26, 14, 57, 3, 34}, {40, 56, 5, 36, 12, 29, 12, 57, 4, 28, 53, 48, 12, 17, 31, 47}, {54, 27, 7, 64, 25, 2, 46, 7, 28, 12, 20, 14, 40, 53, 65, 27},
  {52, 1, 11, 34, 46, 32, 58, 23, 60, 21, 12, 54, 48, 10, 29, 64}, {65, 52, 17, 63, 9, 47, 9, 22, 37, 18, 37, 27, 37, 36, 14, 17}, {39, 54, 25, 45, 35, 38, 15, 5, 46, 14, 65, 65, 56, 15, 61, 60},
  {41, 7, 39, 53, 48, 61, 11, 11, 18, 43, 7, 17, 9, 1, 58, 24}, {49, 11, 65, 50, 13, 42, 24, 30, 3, 56, 25, 41, 23, 37, 4, 61}, {55, 49, 52, 35, 59, 22, 62, 17, 15, 39, 50, 7, 20, 8, 27, 9},
  {59, 41, 54, 60, 21, 9, 43, 24, 25, 64, 48, 55, 5, 47, 45, 38}, {61, 9, 40, 42, 14, 27, 6, 56, 57, 36, 15, 20, 59, 21, 47, 7}, {46, 23, 48, 58, 64, 23, 35, 51, 40, 44, 5, 61, 55, 40, 17, 43},
  {43, 46, 37, 62, 27, 50, 50, 63, 53, 35, 60, 9, 49, 7, 9, 16}, {57, 61, 56, 47, 42, 59, 44, 40, 54, 50, 43, 43, 41, 35, 51, 63}, {33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33},
  {19, 42, 44, 57, 16, 14, 34, 19, 30, 5, 3, 62, 53, 25, 13, 21}, {4, 58, 38, 43, 49, 30, 17, 6, 16, 34, 19, 19, 50, 43, 43, 55}, {8, 4, 51, 46, 10, 55, 36, 28, 14, 9, 39, 42, 35, 32, 48, 8},
  {24, 19, 36, 61, 38, 48, 48, 2, 7, 25, 57, 8, 60, 52, 10, 44}, {6, 53, 64, 59, 55, 49, 26, 34, 61, 11, 26, 35, 24, 27, 20, 14}, {31, 50, 34, 55, 23, 56, 10, 58, 39, 15, 8, 6, 8, 61, 54, 62},
  {16, 31, 63, 49, 44, 8, 38, 37, 43, 7, 55, 53, 4, 18, 59, 30}, {13, 6, 45, 41, 6, 20, 64, 45, 64, 24, 49, 16, 19, 63, 30, 53}, {21, 64, 13, 39, 26, 40, 59, 46, 11, 40, 14, 63, 44, 50, 32, 1},
  {3, 34, 16, 65, 47, 6, 41, 65, 22, 63, 22, 21, 38, 11, 64, 35}, {32, 3, 31, 52, 37, 45, 21, 50, 19, 53, 64, 64, 51, 62, 50, 12}, {2, 21, 6, 54, 61, 41, 13, 41, 31, 49, 45, 32, 36, 28, 6, 51},
  {30, 44, 24, 40, 34, 53, 47, 4, 56, 62, 4, 51, 2, 54, 25, 18}, {15, 38, 8, 48, 3, 62, 65, 31, 49, 46, 32, 30, 32, 22, 40, 40}, {28, 15, 4, 37, 51, 35, 5, 12, 65, 37, 56, 44, 3, 46, 28, 10},
  {22, 30, 19, 56, 4, 1, 29, 13, 42, 58, 36, 28, 21, 2, 11, 37}, {10, 40, 57, 22, 1, 15, 3, 27, 45, 47, 28, 37, 39, 24, 22, 41}, {29, 48, 43, 28, 36, 12, 14, 18, 58, 65, 42, 10, 65, 60, 42, 20},
  {18, 29, 46, 15, 8, 63, 39, 14, 34, 60, 31, 40, 52, 9, 63, 32}, {26, 10, 61, 30, 54, 37, 54, 9, 62, 38, 13, 18, 54, 49, 35, 19}, {12, 39, 59, 2, 41, 64, 20, 59, 38, 54, 46, 52, 26, 13, 1, 39},
  {14, 65, 55, 32, 20, 34, 8, 43, 6, 45, 54, 12, 18, 56, 37, 2}, {1, 14, 49, 3, 57, 19, 57, 44, 29, 48, 29, 39, 29, 30, 52, 49}, {27, 12, 41, 21, 31, 28, 51, 61, 20, 52, 1, 1, 10, 51, 5, 6},
  {25, 59, 27, 13, 18, 5, 55, 55, 48, 23, 59, 49, 57, 65, 8, 42}, {17, 55, 1, 16, 53, 24, 42, 36, 63, 10, 41, 25, 43, 29, 62, 5}, {11, 17, 14, 31, 7, 44, 4, 49, 51, 27, 16, 59, 46, 58, 39, 57},
  {7, 25, 12, 6, 45, 57, 23, 42, 41, 2, 18, 11, 61, 19, 21, 28}, {5, 57, 26, 24, 52, 39, 60, 10, 9, 30, 51, 46, 7, 45, 19, 59}, {20, 43, 18, 8, 2, 43, 31, 15, 26, 22, 61, 5, 11, 26, 49, 23},
  {23, 20, 29, 4, 39, 16, 16, 3, 13, 31, 6, 57, 17, 59, 57, 50}, {9, 5, 10, 19, 24, 7, 22, 26, 12, 16, 23, 23, 25, 31, 15, 3}, {4, 50, 61, 22, 53, 41, 36, 45, 9, 13, 52, 24, 63, 47, 32, 47},
  {47, 17, 32, 28, 23, 23, 50, 11, 23, 16, 36, 8, 47, 62, 49, 60}, {24, 56, 57, 15, 18, 34, 52, 58, 20, 31, 11, 62, 27, 58, 30, 38}, {58, 28, 41, 30, 56, 14, 59, 22, 5, 6, 18, 47, 9, 42, 18, 64},
  {31, 11, 55, 2, 46, 39, 5, 52, 7, 42, 17, 13, 40, 60, 40, 32}, {60, 43, 51, 32, 12, 5, 27, 4, 11, 58, 10, 16, 58, 35, 56, 8}, {13, 22, 59, 3, 7, 48, 23, 36, 17, 62, 58, 35, 11, 50, 28, 29},
  {50, 60, 42, 21, 36, 3, 2, 13, 25, 47, 46, 60, 17, 53, 2, 21}, {3, 40, 26, 53, 34, 16, 55, 65, 27, 22, 26, 2, 52, 45, 7, 20}, {45, 19, 3, 50, 2, 55, 44, 31, 1, 28, 60, 32, 44, 63, 25, 1},
  {2, 29, 13, 35, 16, 4, 47, 54, 14, 15, 21, 63, 2, 34, 45, 16}, {34, 5, 17, 60, 60, 38, 35, 15, 12, 30, 25, 45, 21, 64, 53, 25}, {15, 32, 4, 42, 41, 12, 10, 48, 26, 64, 13, 22, 62, 36, 19, 62},
  {36, 63, 20, 58, 26, 44, 17, 26, 18, 34, 4, 28, 34, 51, 1, 35}, {22, 15, 29, 62, 38, 20, 1, 56, 29, 63, 31, 51, 10, 38, 61, 54}, {38, 62, 8, 47, 55, 64, 24, 29, 10, 45, 65, 36, 30, 44, 37, 53},
  {29, 65, 19, 9, 44, 42, 21, 25, 44, 27, 51, 26, 38, 56, 63, 39}, {56, 30, 1, 23, 24, 6, 8, 46, 38, 1, 54, 18, 24, 37, 52, 48}, {26, 58, 6, 20, 3, 57, 32, 34, 51, 14, 3, 37, 35, 48, 27, 52},
  {48, 12, 28, 5, 31, 17, 4, 47, 36, 12, 29, 56, 53, 40, 12, 57}, {14, 25, 12, 7, 65, 53, 28, 27, 64, 40, 2, 27, 20, 54, 46, 7}, {54, 46, 21, 11, 29, 10, 60, 64, 34, 48, 32, 1, 12, 52, 58, 23},
  {27, 9, 18, 17, 14, 36, 37, 17, 63, 37, 47, 52, 37, 65, 9, 22}, {65, 35, 14, 25, 61, 15, 46, 60, 45, 56, 38, 54, 65, 39, 15, 5}, {17, 48, 43, 39, 58, 1, 18, 24, 53, 9, 61, 7, 7, 41, 11, 11},
  {41, 13, 56, 65, 4, 37, 3, 61, 50, 23, 42, 11, 25, 49, 24, 30}, {7, 59, 39, 52, 27, 8, 15, 9, 35, 20, 22, 49, 50, 55, 62, 17}, {55, 21, 64, 54, 45, 47, 25, 38, 60, 5, 9, 41, 48, 59, 43, 24},
  {20, 14, 36, 40, 47, 21, 57, 7, 42, 59, 27, 9, 15, 61, 6, 56}, {61, 64, 44, 48, 17, 40, 40, 43, 58, 55, 23, 23, 5, 46, 35, 51}, {9, 27, 35, 37, 9, 7, 53, 16, 62, 49, 50, 46, 60, 43, 50, 63},
  {43, 42, 50, 56, 51, 35, 54, 63, 47, 41, 59, 61, 43, 57, 44, 40}, {62, 16, 5, 44, 13, 25, 30, 21, 57, 53, 14, 42, 3, 19, 34, 19}, {19, 49, 34, 38, 43, 43, 16, 55, 43, 50, 30, 58, 19, 4, 17, 6},
  {42, 10, 9, 51, 48, 32, 14, 8, 46, 35, 55, 4, 39, 8, 36, 28}, {8, 38, 25, 36, 10, 52, 7, 44, 61, 60, 48, 19, 57, 24, 48, 2}, {35, 55, 11, 64, 20, 27, 61, 14, 59, 24, 49, 53, 26, 6, 26, 34},
  {6, 23, 15, 34, 54, 61, 39, 62, 55, 8, 56, 50, 8, 31, 10, 58}, {53, 44, 7, 63, 59, 18, 43, 30, 49, 4, 8, 31, 55, 16, 38, 37}, {16, 6, 24, 45, 30, 63, 64, 53, 41, 19, 20, 6, 49, 13, 64, 45},
  {63, 26, 40, 13, 32, 50, 11, 1, 39, 44, 40, 64, 14, 21, 59, 46}, {21, 47, 63, 16, 64, 11, 22, 35, 65, 38, 6, 34, 22, 3, 41, 65}, {64, 37, 53, 31, 50, 62, 19, 12, 52, 51, 45, 3, 64, 32, 21, 50},
  {32, 61, 49, 6, 6, 28, 31, 51, 54, 36, 41, 21, 45, 2, 13, 41}, {51, 34, 62, 24, 25, 54, 56, 18, 40, 2, 53, 44, 4, 30, 47, 4}, {30, 3, 46, 8, 40, 22, 49, 40, 48, 32, 62, 38, 32, 15, 65, 31},
  {44, 51, 37, 4, 28, 46, 65, 10, 37, 3, 35, 15, 56, 28, 5, 12}, {28, 4, 58, 19, 11, 2, 42, 37, 56, 21, 1, 30, 36, 22, 29, 13}, {37, 1, 47, 57, 22, 24, 45, 41, 22, 39, 15, 40, 28, 10, 3, 27},
  {10, 36, 65, 43, 42, 60, 58, 20, 28, 65, 12, 48, 42, 29, 14, 18}, {40, 8, 60, 46, 63, 9, 34, 32, 15, 52, 63, 29, 31, 18, 39, 14}, {18, 54, 38, 61, 35, 49, 62, 19, 30, 54, 37, 10, 13, 26, 54, 9},
  {52, 41, 54, 59, 1, 13, 38, 39, 2, 26, 64, 39, 46, 12, 20, 59}, {12, 20, 45, 55, 37, 56, 6, 2, 32, 18, 34, 65, 54, 14, 8, 43}, {39, 57, 48, 49, 52, 30, 29, 49, 3, 29, 19, 14, 29, 1, 57, 44},
  {1, 31, 52, 41, 5, 51, 20, 6, 21, 10, 28, 12, 1, 27, 51, 61}, {49, 18, 23, 27, 8, 65, 48, 42, 13, 57, 5, 59, 59, 25, 55, 55}, {25, 53, 10, 1, 62, 29, 63, 5, 16, 43, 24, 55, 41, 17, 42, 36},
  {59, 7, 27, 14, 39, 58, 51, 57, 31, 46, 44, 17, 16, 11, 4, 49}, {11, 45, 2, 12, 21, 19, 41, 28, 6, 61, 57, 25, 18, 7, 23, 42}, {46, 52, 30, 26, 19, 45, 9, 59, 24, 7, 39, 57, 51, 5, 60, 10},
  {5, 2, 22, 18, 49, 26, 26, 23, 8, 11, 43, 43, 61, 20, 31, 15}, {57, 39, 31, 29, 57, 59, 13, 50, 4, 17, 16, 20, 6, 23, 16, 3}, {23, 24, 16, 10, 15, 31, 12, 3, 19, 25, 7, 5, 23, 9, 22, 26}
};

int NOLH_4[ ][22] = { {32, 58, 51, 59, 89, 73, 98, 72, 120, 100, 98, 78, 129, 120, 80, 109, 44, 70, 116, 124, 34, 115}, {115, 40, 56, 60, 59, 55, 27, 62, 50, 119, 77, 80, 122, 94, 104, 117, 13, 75, 79, 94, 29, 98},
  {58, 98, 1, 36, 21, 97, 84, 79, 74, 61, 21, 63, 111, 128, 82, 72, 54, 20, 108, 85, 62, 90}, {90, 115, 39, 48, 98, 10, 53, 35, 60, 54, 49, 44, 127, 87, 125, 79, 57, 47, 76, 100, 33, 72},
  {1, 51, 72, 31, 69, 47, 120, 129, 82, 15, 128, 110, 35, 58, 57, 113, 14, 87, 94, 84, 7, 91}, {91, 56, 90, 2, 43, 76, 6, 33, 16, 24, 129, 81, 63, 41, 45, 119, 52, 113, 98, 95, 11, 129},
  {51, 129, 98, 38, 30, 32, 121, 124, 94, 91, 14, 1, 15, 61, 41, 118, 21, 45, 121, 88, 4, 74}, {74, 91, 115, 9, 119, 112, 3, 40, 28, 64, 12, 22, 37, 44, 56, 61, 45, 13, 125, 75, 3, 79},
  {4, 7, 34, 27, 126, 94, 56, 94, 110, 96, 36, 77, 34, 122, 103, 101, 26, 126, 43, 4, 79, 127}, {127, 11, 29, 35, 14, 27, 71, 26, 19, 63, 18, 90, 16, 118, 59, 94, 16, 90, 29, 48, 74, 126},
  {7, 126, 62, 37, 10, 100, 29, 80, 107, 22, 70, 36, 30, 97, 121, 93, 41, 28, 39, 1, 129, 119}, {119, 127, 33, 50, 129, 66, 117, 37, 41, 32, 87, 33, 57, 109, 70, 76, 19, 26, 26, 9, 91, 123},
  {62, 34, 123, 24, 93, 7, 47, 85, 115, 2, 28, 117, 94, 42, 15, 99, 53, 107, 60, 62, 72, 97}, {97, 29, 119, 46, 31, 118, 70, 27, 51, 3, 42, 109, 121, 47, 28, 87, 12, 63, 64, 32, 90, 68},
  {34, 68, 126, 30, 28, 5, 19, 127, 104, 109, 97, 31, 68, 39, 10, 81, 61, 15, 19, 60, 98, 101}, {101, 97, 127, 5, 67, 126, 94, 32, 55, 124, 80, 43, 76, 34, 12, 127, 23, 49, 74, 37, 115, 96},
  {30, 24, 27, 96, 90, 89, 64, 28, 77, 81, 78, 27, 128, 6, 101, 10, 6, 116, 107, 10, 59, 125}, {125, 46, 35, 101, 26, 20, 62, 96, 6, 77, 93, 57, 80, 11, 88, 62, 55, 100, 123, 39, 60, 100},
  {24, 100, 37, 68, 5, 88, 69, 31, 119, 41, 63, 92, 124, 9, 87, 8, 28, 54, 50, 41, 36, 84}, {84, 125, 50, 97, 103, 45, 21, 70, 32, 8, 61, 85, 79, 3, 78, 47, 17, 7, 67, 31, 48, 106},
  {37, 27, 106, 123, 86, 40, 129, 14, 83, 23, 126, 3, 59, 106, 11, 15, 64, 86, 128, 50, 31, 80}, {80, 35, 84, 119, 17, 111, 35, 125, 73, 7, 75, 2, 17, 71, 49, 23, 49, 80, 113, 8, 2, 93},
  {27, 93, 100, 126, 45, 8, 122, 7, 113, 104, 6, 116, 52, 103, 69, 22, 43, 33, 105, 51, 38, 95}, {95, 80, 125, 127, 81, 105, 37, 128, 52, 82, 17, 120, 38, 85, 32, 4, 25, 58, 83, 28, 9, 103},
  {38, 31, 59, 79, 128, 61, 34, 57, 106, 71, 56, 35, 14, 7, 107, 44, 42, 118, 18, 119, 103, 121}, {121, 2, 60, 74, 38, 50, 105, 81, 38, 85, 44, 4, 26, 49, 117, 20, 20, 121, 49, 128, 95, 92},
  {31, 92, 36, 129, 16, 78, 40, 39, 108, 60, 91, 66, 23, 50, 75, 64, 8, 18, 30, 112, 93, 128}, {128, 121, 48, 91, 97, 37, 76, 126, 8, 38, 105, 79, 5, 66, 92, 28, 22, 41, 57, 107, 80, 99},
  {36, 59, 99, 72, 70, 1, 49, 41, 61, 5, 10, 5, 87, 99, 17, 57, 47, 114, 11, 109, 106, 82}, {82, 60, 128, 90, 55, 96, 118, 74, 46, 40, 20, 48, 91, 129, 6, 46, 63, 108, 41, 71, 84, 94},
  {59, 94, 92, 98, 51, 6, 2, 17, 112, 121, 104, 70, 84, 73, 8, 24, 10, 62, 68, 101, 100, 70}, {70, 82, 121, 115, 95, 86, 99, 101, 4, 95, 90, 88, 89, 95, 34, 52, 18, 39, 6, 76, 125, 71},
  {10, 47, 42, 44, 64, 117, 73, 117, 67, 116, 96, 74, 110, 84, 14, 6, 71, 52, 1, 115, 6, 112}, {112, 63, 20, 13, 52, 49, 5, 43, 68, 117, 123, 62, 85, 107, 25, 33, 70, 42, 48, 78, 55, 120},
  {47, 120, 8, 54, 20, 121, 106, 69, 54, 31, 45, 19, 82, 76, 19, 41, 94, 71, 33, 127, 28, 67}, {67, 112, 22, 57, 123, 15, 17, 52, 103, 36, 16, 25, 77, 92, 44, 55, 82, 77, 15, 81, 17, 83},
  {8, 42, 83, 14, 108, 62, 86, 76, 2, 29, 100, 96, 31, 60, 68, 40, 99, 10, 55, 106, 64, 108}, {108, 20, 67, 52, 39, 77, 79, 11, 101, 19, 95, 113, 29, 48, 84, 2, 128, 31, 42, 111, 49, 122},
  {42, 122, 120, 21, 8, 29, 110, 88, 12, 78, 51, 55, 60, 20, 76, 59, 92, 125, 34, 118, 43, 110}, {110, 108, 112, 45, 111, 128, 48, 21, 100, 87, 68, 18, 27, 18, 79, 30, 121, 92, 46, 97, 25, 88},
  {43, 64, 6, 26, 88, 72, 14, 110, 31, 112, 9, 121, 28, 105, 2, 9, 103, 73, 120, 47, 88, 105}, {105, 49, 55, 16, 68, 3, 92, 24, 93, 114, 27, 93, 11, 67, 21, 14, 95, 37, 110, 34, 110, 87},
  {64, 87, 28, 41, 36, 116, 15, 107, 45, 47, 101, 24, 69, 125, 36, 18, 93, 111, 127, 58, 122, 81}, {81, 105, 17, 19, 96, 31, 119, 38, 86, 12, 107, 32, 64, 77, 1, 32, 80, 106, 102, 25, 108, 66},
  {28, 6, 66, 53, 73, 38, 72, 118, 43, 28, 5, 115, 108, 17, 77, 26, 106, 6, 69, 61, 83, 113}, {113, 55, 81, 12, 3, 67, 87, 55, 109, 46, 22, 72, 117, 37, 90, 50, 84, 25, 99, 63, 67, 102},
  {6, 102, 87, 61, 18, 23, 22, 108, 3, 80, 59, 11, 123, 26, 97, 34, 100, 94, 59, 5, 120, 75}, {75, 113, 105, 23, 101, 91, 126, 59, 95, 79, 83, 76, 109, 19, 99, 39, 125, 101, 86, 40, 112, 124},
  {61, 53, 26, 124, 124, 113, 123, 53, 33, 126, 57, 30, 90, 14, 7, 125, 96, 27, 8, 14, 44, 107}, {107, 12, 16, 75, 53, 21, 52, 122, 105, 74, 76, 7, 106, 29, 4, 95, 101, 64, 35, 38, 13, 69},
  {53, 69, 41, 102, 24, 114, 67, 15, 39, 27, 3, 83, 75, 55, 20, 82, 68, 95, 24, 73, 54, 118}, {118, 107, 19, 113, 72, 46, 50, 100, 71, 10, 41, 124, 112, 56, 22, 111, 97, 98, 40, 64, 57, 77},
  {41, 26, 77, 66, 107, 11, 89, 48, 13, 44, 84, 23, 72, 108, 100, 74, 123, 2, 45, 16, 14, 111}, {111, 16, 118, 81, 13, 70, 33, 67, 125, 58, 119, 39, 42, 98, 64, 85, 119, 1, 13, 13, 52, 89},
  {26, 89, 69, 87, 9, 28, 91, 25, 9, 129, 48, 84, 25, 79, 106, 105, 126, 109, 53, 20, 21, 114}, {114, 111, 107, 105, 80, 74, 28, 86, 129, 68, 13, 59, 49, 102, 114, 92, 127, 122, 52, 43, 45, 104},
  {21, 14, 44, 88, 84, 108, 18, 16, 49, 75, 8, 28, 33, 13, 18, 123, 79, 46, 126, 113, 104, 85}, {85, 52, 13, 110, 25, 35, 104, 84, 72, 73, 38, 8, 47, 16, 35, 103, 74, 3, 118, 104, 114, 109},
  {14, 109, 54, 122, 47, 71, 23, 18, 42, 25, 106, 114, 10, 68, 37, 129, 129, 74, 93, 86, 89, 78}, {78, 85, 57, 108, 118, 51, 88, 121, 123, 33, 99, 89, 56, 40, 58, 114, 91, 79, 114, 74, 111, 116},
  {54, 44, 116, 83, 115, 48, 16, 66, 40, 37, 19, 12, 118, 100, 91, 63, 72, 11, 103, 103, 77, 73}, {73, 13, 78, 67, 48, 106, 85, 83, 64, 17, 58, 26, 86, 126, 127, 88, 90, 34, 72, 108, 118, 76},
  {44, 76, 109, 120, 54, 43, 30, 19, 14, 88, 115, 69, 126, 115, 67, 77, 98, 82, 109, 77, 69, 117}, {117, 73, 85, 112, 74, 104, 75, 120, 96, 110, 66, 101, 98, 78, 83, 70, 115, 69, 92, 123, 107, 86},
  {65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65}, {98, 72, 79, 71, 41, 57, 32, 58, 10, 30, 32, 52, 1, 10, 50, 21, 86, 60, 14, 6, 96, 15},
  {15, 90, 74, 70, 71, 75, 103, 68, 80, 11, 53, 50, 8, 36, 26, 13, 117, 55, 51, 36, 101, 32}, {72, 32, 129, 94, 109, 33, 46, 51, 56, 69, 109, 67, 19, 2, 48, 58, 76, 110, 22, 45, 68, 40},
  {40, 15, 91, 82, 32, 120, 77, 95, 70, 76, 81, 86, 3, 43, 5, 51, 73, 83, 54, 30, 97, 58}, {129, 79, 58, 99, 61, 83, 10, 1, 48, 115, 2, 20, 95, 72, 73, 17, 116, 43, 36, 46, 123, 39},
  {39, 74, 40, 128, 87, 54, 124, 97, 114, 106, 1, 49, 67, 89, 85, 11, 78, 17, 32, 35, 119, 1}, {79, 1, 32, 92, 100, 98, 9, 6, 36, 39, 116, 129, 115, 69, 89, 12, 109, 85, 9, 42, 126, 56},
  {56, 39, 15, 121, 11, 18, 127, 90, 102, 66, 118, 108, 93, 86, 74, 69, 85, 117, 5, 55, 127, 51}, {126, 123, 96, 103, 4, 36, 74, 36, 20, 34, 94, 53, 96, 8, 27, 29, 104, 4, 87, 126, 51, 3},
  {3, 119, 101, 95, 116, 103, 59, 104, 111, 67, 112, 40, 114, 12, 71, 36, 114, 40, 101, 82, 56, 4}, {123, 4, 68, 93, 120, 30, 101, 50, 23, 108, 60, 94, 100, 33, 9, 37, 89, 102, 91, 129, 1, 11},
  {11, 3, 97, 80, 1, 64, 13, 93, 89, 98, 43, 97, 73, 21, 60, 54, 111, 104, 104, 121, 39, 7}, {68, 96, 7, 106, 37, 123, 83, 45, 15, 128, 102, 13, 36, 88, 115, 31, 77, 23, 70, 68, 58, 33},
  {33, 101, 11, 84, 99, 12, 60, 103, 79, 127, 88, 21, 9, 83, 102, 43, 118, 67, 66, 98, 40, 62}, {96, 62, 4, 100, 102, 125, 111, 3, 26, 21, 33, 99, 62, 91, 120, 49, 69, 115, 111, 70, 32, 29},
  {29, 33, 3, 125, 63, 4, 36, 98, 75, 6, 50, 87, 54, 96, 118, 3, 107, 81, 56, 93, 15, 34}, {100, 106, 103, 34, 40, 41, 66, 102, 53, 49, 52, 103, 2, 124, 29, 120, 124, 14, 23, 120, 71, 5},
  {5, 84, 95, 29, 104, 110, 68, 34, 124, 53, 37, 73, 50, 119, 42, 68, 75, 30, 7, 91, 70, 30}, {106, 30, 93, 62, 125, 42, 61, 99, 11, 89, 67, 38, 6, 121, 43, 122, 102, 76, 80, 89, 94, 46},
  {46, 5, 80, 33, 27, 85, 109, 60, 98, 122, 69, 45, 51, 127, 52, 83, 113, 123, 63, 99, 82, 24}, {93, 103, 24, 7, 44, 90, 1, 116, 47, 107, 4, 127, 71, 24, 119, 115, 66, 44, 2, 80, 99, 50},
  {50, 95, 46, 11, 113, 19, 95, 5, 57, 123, 55, 128, 113, 59, 81, 107, 81, 50, 17, 122, 128, 37}, {103, 37, 30, 4, 85, 122, 8, 123, 17, 26, 124, 14, 78, 27, 61, 108, 87, 97, 25, 79, 92, 35},
  {35, 50, 5, 3, 49, 25, 93, 2, 78, 48, 113, 10, 92, 45, 98, 126, 105, 72, 47, 102, 121, 27}, {92, 99, 71, 51, 2, 69, 96, 73, 24, 59, 74, 95, 116, 123, 23, 86, 88, 12, 112, 11, 27, 9},
  {9, 128, 70, 56, 92, 80, 25, 49, 92, 45, 86, 126, 104, 81, 13, 110, 110, 9, 81, 2, 35, 38}, {99, 38, 94, 1, 114, 52, 90, 91, 22, 70, 39, 64, 107, 80, 55, 66, 122, 112, 100, 18, 37, 2},
  {2, 9, 82, 39, 33, 93, 54, 4, 122, 92, 25, 51, 125, 64, 38, 102, 108, 89, 73, 23, 50, 31}, {94, 71, 31, 58, 60, 129, 81, 89, 69, 125, 120, 125, 43, 31, 113, 73, 83, 16, 119, 21, 24, 48},
  {48, 70, 2, 40, 75, 34, 12, 56, 84, 90, 110, 82, 39, 1, 124, 84, 67, 22, 89, 59, 46, 36}, {71, 36, 38, 32, 79, 124, 128, 113, 18, 9, 26, 60, 46, 57, 122, 106, 120, 68, 62, 29, 30, 60},
  {60, 48, 9, 15, 35, 44, 31, 29, 126, 35, 40, 42, 41, 35, 96, 78, 112, 91, 124, 54, 5, 59}, {120, 83, 88, 86, 66, 13, 57, 13, 63, 14, 34, 56, 20, 46, 116, 124, 59, 78, 129, 15, 124, 18},
  {18, 67, 110, 117, 78, 81, 125, 87, 62, 13, 7, 68, 45, 23, 105, 97, 60, 88, 82, 52, 75, 10}, {83, 10, 122, 76, 110, 9, 24, 61, 76, 99, 85, 111, 48, 54, 111, 89, 36, 59, 97, 3, 102, 63},
  {63, 18, 108, 73, 7, 115, 113, 78, 27, 94, 114, 105, 53, 38, 86, 75, 48, 53, 115, 49, 113, 47}, {122, 88, 47, 116, 22, 68, 44, 54, 128, 101, 30, 34, 99, 70, 62, 90, 31, 120, 75, 24, 66, 22},
  {22, 110, 63, 78, 91, 53, 51, 119, 29, 111, 35, 17, 101, 82, 46, 128, 2, 99, 88, 19, 81, 8}, {88, 8, 10, 109, 122, 101, 20, 42, 118, 52, 79, 75, 70, 110, 54, 71, 38, 5, 96, 12, 87, 20},
  {20, 22, 18, 85, 19, 2, 82, 109, 30, 43, 62, 112, 103, 112, 51, 100, 9, 38, 84, 33, 105, 42}, {87, 66, 124, 104, 42, 58, 116, 20, 99, 18, 121, 9, 102, 25, 128, 121, 27, 57, 10, 83, 42, 25},
  {25, 81, 75, 114, 62, 127, 38, 106, 37, 16, 103, 37, 119, 63, 109, 116, 35, 93, 20, 96, 20, 43}, {66, 43, 102, 89, 94, 14, 115, 23, 85, 83, 29, 106, 61, 5, 94, 112, 37, 19, 3, 72, 8, 49},
  {49, 25, 113, 111, 34, 99, 11, 92, 44, 118, 23, 98, 66, 53, 129, 98, 50, 24, 28, 105, 22, 64}, {102, 124, 64, 77, 57, 92, 58, 12, 87, 102, 125, 15, 22, 113, 53, 104, 24, 124, 61, 69, 47, 17},
  {17, 75, 49, 118, 127, 63, 43, 75, 21, 84, 108, 58, 13, 93, 40, 80, 46, 105, 31, 67, 63, 28}, {124, 28, 43, 69, 112, 107, 108, 22, 127, 50, 71, 119, 7, 104, 33, 96, 30, 36, 71, 125, 10, 55},
  {55, 17, 25, 107, 29, 39, 4, 71, 35, 51, 47, 54, 21, 111, 31, 91, 5, 29, 44, 90, 18, 6}, {69, 77, 104, 6, 6, 17, 7, 77, 97, 4, 73, 100, 40, 116, 123, 5, 34, 103, 122, 116, 86, 23},
  {23, 118, 114, 55, 77, 109, 78, 8, 25, 56, 54, 123, 24, 101, 126, 35, 29, 66, 95, 92, 117, 61}, {77, 61, 89, 28, 106, 16, 63, 115, 91, 103, 127, 47, 55, 75, 110, 48, 62, 35, 106, 57, 76, 12},
  {12, 23, 111, 17, 58, 84, 80, 30, 59, 120, 89, 6, 18, 74, 108, 19, 33, 32, 90, 66, 73, 53}, {89, 104, 53, 64, 23, 119, 41, 82, 117, 86, 46, 107, 58, 22, 30, 56, 7, 128, 85, 114, 116, 19},
  {19, 114, 12, 49, 117, 60, 97, 63, 5, 72, 11, 91, 88, 32, 66, 45, 11, 129, 117, 117, 78, 41}, {104, 41, 61, 43, 121, 102, 39, 105, 121, 1, 82, 46, 105, 51, 24, 25, 4, 21, 77, 110, 109, 16},
  {16, 19, 23, 25, 50, 56, 102, 44, 1, 62, 117, 71, 81, 28, 16, 38, 3, 8, 78, 87, 85, 26}, {109, 116, 86, 42, 46, 22, 112, 114, 81, 55, 122, 102, 97, 117, 112, 7, 51, 84, 4, 17, 26, 45},
  {45, 78, 117, 20, 105, 95, 26, 46, 58, 57, 92, 122, 83, 114, 95, 27, 56, 127, 12, 26, 16, 21}, {116, 21, 76, 8, 83, 59, 107, 112, 88, 105, 24, 16, 120, 62, 93, 1, 1, 56, 37, 44, 41, 52},
  {52, 45, 73, 22, 12, 79, 42, 9, 7, 97, 31, 41, 74, 90, 72, 16, 39, 51, 16, 56, 19, 14}, {76, 86, 14, 47, 15, 82, 114, 64, 90, 93, 111, 118, 12, 30, 39, 67, 58, 119, 27, 27, 53, 57},
  {57, 117, 52, 63, 82, 24, 45, 47, 66, 113, 72, 104, 44, 4, 3, 42, 40, 96, 58, 22, 12, 54}, {86, 54, 21, 10, 76, 87, 100, 111, 116, 42, 15, 61, 4, 15, 63, 53, 32, 48, 21, 53, 61, 13},
  {13, 57, 45, 18, 56, 26, 55, 10, 34, 20, 64, 29, 32, 52, 47, 60, 15, 61, 38, 7, 23, 44}, {70, 124, 72, 80, 98, 120, 78, 109, 89, 115, 34, 59, 32, 129, 100, 44, 51, 116, 120, 98, 73, 58},
  {75, 94, 62, 104, 77, 50, 80, 117, 59, 98, 29, 60, 115, 122, 119, 13, 56, 79, 94, 27, 55, 40}, {20, 85, 79, 82, 21, 74, 63, 72, 21, 90, 62, 36, 58, 111, 61, 54, 1, 108, 128, 84, 97, 98},
  {47, 100, 35, 125, 49, 60, 44, 79, 98, 72, 33, 48, 90, 127, 54, 57, 39, 76, 87, 53, 10, 115}, {87, 84, 129, 57, 128, 82, 110, 113, 69, 91, 7, 31, 1, 35, 15, 14, 72, 94, 58, 120, 47, 51},
  {113, 95, 33, 45, 129, 16, 81, 119, 43, 129, 11, 2, 91, 63, 24, 52, 90, 98, 41, 6, 76, 56}, {45, 88, 124, 41, 14, 94, 1, 118, 30, 74, 4, 38, 51, 15, 91, 21, 98, 121, 61, 121, 32, 129},
  {13, 75, 40, 56, 12, 28, 22, 61, 119, 79, 3, 9, 74, 37, 64, 45, 115, 125, 44, 3, 112, 91}, {126, 4, 94, 103, 36, 110, 77, 101, 126, 127, 79, 27, 4, 34, 96, 26, 34, 43, 122, 56, 94, 7},
  {90, 48, 26, 59, 18, 19, 90, 94, 14, 126, 74, 35, 127, 16, 63, 16, 29, 29, 118, 71, 27, 11}, {28, 1, 80, 121, 70, 107, 36, 93, 10, 119, 129, 37, 7, 30, 22, 41, 62, 39, 97, 29, 100, 126},
  {26, 9, 37, 70, 87, 41, 33, 76, 129, 123, 91, 50, 119, 57, 32, 19, 33, 26, 109, 117, 66, 127}, {107, 62, 85, 15, 28, 115, 117, 99, 93, 97, 72, 24, 62, 94, 2, 53, 123, 60, 42, 47, 7, 34},
  {63, 32, 27, 28, 42, 51, 109, 87, 31, 68, 90, 46, 97, 121, 3, 12, 119, 64, 47, 70, 118, 29}, {15, 60, 127, 10, 97, 104, 31, 81, 28, 101, 98, 30, 34, 68, 109, 61, 126, 19, 39, 19, 5, 68},
  {49, 37, 32, 12, 80, 55, 43, 127, 67, 96, 115, 5, 101, 76, 124, 23, 127, 74, 34, 94, 126, 97}, {116, 10, 28, 101, 78, 77, 27, 10, 90, 125, 59, 96, 30, 128, 81, 6, 27, 107, 6, 64, 89, 24},
  {100, 39, 96, 88, 93, 6, 57, 62, 26, 100, 60, 101, 125, 80, 77, 55, 35, 123, 11, 62, 20, 46}, {54, 41, 31, 87, 63, 119, 92, 8, 5, 84, 36, 68, 24, 124, 41, 28, 37, 50, 9, 69, 88, 100},
  {7, 31, 70, 78, 61, 32, 85, 47, 103, 106, 48, 97, 84, 79, 8, 17, 50, 67, 3, 21, 45, 125}, {86, 50, 14, 11, 126, 83, 3, 15, 86, 80, 31, 123, 37, 59, 23, 64, 106, 128, 106, 129, 40, 27},
  {80, 8, 125, 49, 75, 73, 2, 23, 17, 93, 2, 119, 80, 17, 7, 49, 84, 113, 71, 35, 111, 35}, {33, 51, 7, 69, 6, 113, 116, 22, 45, 95, 38, 126, 27, 52, 104, 43, 100, 105, 103, 122, 8, 93},
  {58, 28, 128, 32, 17, 52, 120, 4, 81, 103, 9, 127, 95, 38, 82, 25, 125, 83, 85, 37, 105, 80}, {118, 119, 57, 107, 56, 106, 35, 44, 128, 121, 103, 79, 38, 14, 71, 42, 59, 18, 7, 34, 61, 31},
  {121, 128, 81, 117, 44, 38, 4, 20, 38, 92, 95, 74, 121, 26, 85, 20, 60, 49, 49, 105, 50, 2}, {18, 112, 39, 75, 91, 108, 66, 64, 16, 128, 93, 129, 31, 23, 60, 8, 36, 30, 50, 40, 78, 92},
  {41, 107, 126, 92, 105, 8, 79, 28, 97, 99, 80, 91, 128, 5, 38, 22, 48, 57, 66, 76, 37, 121}, {114, 109, 41, 17, 10, 61, 5, 57, 70, 82, 106, 72, 36, 87, 5, 47, 99, 11, 99, 49, 1, 59},
  {108, 71, 74, 6, 20, 46, 48, 46, 55, 94, 84, 90, 82, 91, 40, 63, 128, 41, 129, 118, 96, 60}, {62, 101, 17, 8, 104, 112, 70, 24, 51, 70, 100, 98, 59, 84, 121, 10, 92, 68, 73, 2, 6, 94},
  {39, 76, 101, 34, 90, 4, 88, 52, 95, 71, 125, 115, 70, 89, 95, 18, 121, 6, 95, 99, 86, 82}, {52, 115, 117, 14, 96, 67, 74, 6, 64, 112, 6, 44, 10, 110, 116, 71, 42, 1, 84, 73, 117, 47},
  {42, 78, 43, 25, 123, 68, 62, 33, 52, 120, 55, 13, 112, 85, 117, 70, 20, 48, 107, 5, 49, 63}, {71, 127, 69, 19, 45, 54, 19, 41, 20, 67, 28, 54, 47, 82, 31, 94, 8, 33, 76, 106, 121, 120},
  {77, 81, 52, 44, 16, 103, 25, 55, 123, 83, 17, 57, 67, 77, 36, 82, 22, 15, 92, 17, 15, 112}, {10, 106, 76, 68, 100, 2, 96, 40, 108, 108, 64, 14, 8, 31, 29, 99, 83, 55, 60, 86, 62, 42},
  {31, 111, 11, 84, 95, 101, 113, 2, 39, 122, 49, 52, 108, 29, 19, 128, 67, 42, 48, 79, 77, 20}, {125, 118, 88, 76, 51, 12, 55, 59, 8, 110, 43, 21, 42, 60, 78, 92, 120, 34, 20, 110, 29, 122},
  {92, 97, 21, 79, 68, 100, 18, 30, 111, 88, 25, 45, 110, 27, 87, 121, 112, 46, 18, 48, 128, 108}, {73, 47, 110, 2, 9, 31, 121, 9, 88, 105, 88, 26, 43, 28, 112, 103, 6, 120, 105, 14, 72, 64},
  {37, 34, 24, 21, 27, 93, 93, 14, 68, 87, 110, 16, 105, 11, 114, 95, 55, 110, 67, 92, 3, 49}, {111, 58, 107, 36, 101, 45, 24, 18, 36, 81, 122, 41, 64, 69, 47, 93, 28, 127, 125, 15, 116, 87},
  {106, 25, 38, 1, 107, 86, 32, 32, 96, 66, 108, 19, 81, 64, 12, 80, 17, 102, 77, 119, 31, 105}, {6, 61, 118, 77, 5, 43, 115, 26, 73, 113, 83, 53, 28, 108, 28, 106, 66, 69, 17, 72, 38, 6},
  {25, 63, 55, 90, 22, 109, 72, 50, 3, 102, 67, 12, 113, 117, 46, 84, 81, 99, 37, 87, 67, 55}, {94, 5, 108, 97, 59, 3, 11, 34, 18, 75, 120, 61, 6, 123, 80, 100, 87, 59, 26, 22, 23, 102},
  {101, 40, 59, 99, 83, 95, 76, 39, 101, 124, 112, 23, 75, 109, 79, 125, 105, 86, 19, 126, 91, 113}, {27, 14, 53, 7, 57, 33, 30, 125, 124, 107, 44, 124, 61, 90, 126, 96, 26, 8, 14, 123, 113, 53},
  {64, 38, 122, 4, 76, 105, 7, 95, 53, 69, 13, 75, 107, 106, 74, 101, 16, 35, 29, 52, 21, 12}, {95, 73, 15, 20, 3, 39, 83, 82, 24, 118, 54, 102, 53, 75, 27, 68, 41, 24, 55, 67, 114, 69},
  {98, 64, 100, 22, 41, 71, 124, 111, 72, 77, 57, 113, 118, 112, 10, 97, 19, 40, 56, 50, 46, 107}, {2, 16, 48, 100, 84, 13, 23, 74, 107, 111, 14, 66, 41, 72, 44, 123, 77, 45, 108, 89, 11, 26},
  {1, 13, 67, 64, 119, 125, 39, 85, 13, 89, 52, 81, 111, 42, 58, 119, 118, 13, 98, 33, 70, 16}, {109, 20, 25, 106, 48, 9, 84, 105, 9, 114, 21, 87, 26, 25, 129, 126, 69, 53, 79, 91, 28, 89},
  {122, 43, 86, 114, 13, 129, 59, 92, 80, 104, 45, 105, 114, 49, 68, 127, 107, 52, 102, 28, 74, 111}, {46, 113, 16, 18, 8, 49, 28, 123, 84, 85, 104, 88, 21, 33, 75, 79, 44, 126, 13, 18, 108, 14},
  {3, 104, 84, 35, 38, 72, 8, 103, 25, 109, 114, 110, 85, 47, 73, 74, 13, 118, 16, 104, 35, 52}, {74, 86, 18, 37, 106, 42, 114, 129, 47, 78, 89, 122, 14, 10, 25, 129, 54, 93, 68, 23, 71, 109},
  {79, 74, 121, 58, 99, 123, 89, 114, 118, 116, 111, 108, 78, 56, 33, 91, 57, 114, 40, 88, 51, 85}, {11, 103, 66, 91, 19, 40, 12, 63, 115, 73, 77, 83, 54, 118, 37, 72, 116, 103, 100, 16, 48, 44},
  {34, 108, 83, 127, 58, 64, 26, 88, 48, 76, 118, 67, 73, 86, 17, 90, 78, 72, 126, 85, 106, 13}, {82, 77, 19, 67, 115, 14, 69, 77, 54, 117, 69, 120, 44, 126, 88, 98, 109, 109, 115, 30, 43, 76},
  {69, 123, 120, 83, 66, 96, 101, 70, 74, 86, 107, 112, 117, 98, 110, 115, 85, 92, 78, 75, 104, 73}, {60, 6, 58, 50, 32, 10, 52, 21, 41, 15, 96, 71, 98, 1, 30, 86, 79, 14, 10, 32, 57, 72},
  {55, 36, 68, 26, 53, 80, 50, 13, 71, 32, 101, 70, 15, 8, 11, 117, 74, 51, 36, 103, 75, 90}, {110, 45, 51, 48, 109, 56, 67, 58, 109, 40, 68, 94, 72, 19, 69, 76, 129, 22, 2, 46, 33, 32},
  {83, 30, 95, 5, 81, 70, 86, 51, 32, 58, 97, 82, 40, 3, 76, 73, 91, 54, 43, 77, 120, 15}, {43, 46, 1, 73, 2, 48, 20, 17, 61, 39, 123, 99, 129, 95, 115, 116, 58, 36, 72, 10, 83, 79},
  {17, 35, 97, 85, 1, 114, 49, 11, 87, 1, 119, 128, 39, 67, 106, 78, 40, 32, 89, 124, 54, 74}, {85, 42, 6, 89, 116, 36, 129, 12, 100, 56, 126, 92, 79, 115, 39, 109, 32, 9, 69, 9, 98, 1},
  {117, 55, 90, 74, 118, 102, 108, 69, 11, 51, 127, 121, 56, 93, 66, 85, 15, 5, 86, 127, 18, 39}, {4, 126, 36, 27, 94, 20, 53, 29, 4, 3, 51, 103, 126, 96, 34, 104, 96, 87, 8, 74, 36, 123},
  {40, 82, 104, 71, 112, 111, 40, 36, 116, 4, 56, 95, 3, 114, 67, 114, 101, 101, 12, 59, 103, 119}, {102, 129, 50, 9, 60, 23, 94, 37, 120, 11, 1, 93, 123, 100, 108, 89, 68, 91, 33, 101, 30, 4},
  {104, 121, 93, 60, 43, 89, 97, 54, 1, 7, 39, 80, 11, 73, 98, 111, 97, 104, 21, 13, 64, 3}, {23, 68, 45, 115, 102, 15, 13, 31, 37, 33, 58, 106, 68, 36, 128, 77, 7, 70, 88, 83, 123, 96},
  {67, 98, 103, 102, 88, 79, 21, 43, 99, 62, 40, 84, 33, 9, 127, 118, 11, 66, 83, 60, 12, 101}, {115, 70, 3, 120, 33, 26, 99, 49, 102, 29, 32, 100, 96, 62, 21, 69, 4, 111, 91, 111, 125, 62},
  {81, 93, 98, 118, 50, 75, 87, 3, 63, 34, 15, 125, 29, 54, 6, 107, 3, 56, 96, 36, 4, 33}, {14, 120, 102, 29, 52, 53, 103, 120, 40, 5, 71, 34, 100, 2, 49, 124, 103, 23, 124, 66, 41, 106},
  {30, 91, 34, 42, 37, 124, 73, 68, 104, 30, 70, 29, 5, 50, 53, 75, 95, 7, 119, 68, 110, 84}, {76, 89, 99, 43, 67, 11, 38, 122, 125, 46, 94, 62, 106, 6, 89, 102, 93, 80, 121, 61, 42, 30},
  {123, 99, 60, 52, 69, 98, 45, 83, 27, 24, 82, 33, 46, 51, 122, 113, 80, 63, 127, 109, 85, 5}, {44, 80, 116, 119, 4, 47, 127, 115, 44, 50, 99, 7, 93, 71, 107, 66, 24, 2, 24, 1, 90, 103},
  {50, 122, 5, 81, 55, 57, 128, 107, 113, 37, 128, 11, 50, 113, 123, 81, 46, 17, 59, 95, 19, 95}, {97, 79, 123, 61, 124, 17, 14, 108, 85, 35, 92, 4, 103, 78, 26, 87, 30, 25, 27, 8, 122, 37},
  {72, 102, 2, 98, 113, 78, 10, 126, 49, 27, 121, 3, 35, 92, 48, 105, 5, 47, 45, 93, 25, 50}, {12, 11, 73, 23, 74, 24, 95, 86, 2, 9, 27, 51, 92, 116, 59, 88, 71, 112, 123, 96, 69, 99},
  {9, 2, 49, 13, 86, 92, 126, 110, 92, 38, 35, 56, 9, 104, 45, 110, 70, 81, 81, 25, 80, 128}, {112, 18, 91, 55, 39, 22, 64, 66, 114, 2, 37, 1, 99, 107, 70, 122, 94, 100, 80, 90, 52, 38},
  {89, 23, 4, 38, 25, 122, 51, 102, 33, 31, 50, 39, 2, 125, 92, 108, 82, 73, 64, 54, 93, 9}, {16, 21, 89, 113, 120, 69, 125, 73, 60, 48, 24, 58, 94, 43, 125, 83, 31, 119, 31, 81, 129, 71},
  {22, 59, 56, 124, 110, 84, 82, 84, 75, 36, 46, 40, 48, 39, 90, 67, 2, 89, 1, 12, 34, 70}, {68, 29, 113, 122, 26, 18, 60, 106, 79, 60, 30, 32, 71, 46, 9, 120, 38, 62, 57, 128, 124, 36},
  {91, 54, 29, 96, 40, 126, 42, 78, 35, 59, 5, 15, 60, 41, 35, 112, 9, 124, 35, 31, 44, 48}, {78, 15, 13, 116, 34, 63, 56, 124, 66, 18, 124, 86, 120, 20, 14, 59, 88, 129, 46, 57, 13, 83},
  {88, 52, 87, 105, 7, 62, 68, 97, 78, 10, 75, 117, 18, 45, 13, 60, 110, 82, 23, 125, 81, 67}, {59, 3, 61, 111, 85, 76, 111, 89, 110, 63, 102, 76, 83, 48, 99, 36, 122, 97, 54, 24, 9, 10},
  {53, 49, 78, 86, 114, 27, 105, 75, 7, 47, 113, 73, 63, 53, 94, 48, 108, 115, 38, 113, 115, 18}, {120, 24, 54, 62, 30, 128, 34, 90, 22, 22, 66, 116, 122, 99, 101, 31, 47, 75, 70, 44, 68, 88},
  {99, 19, 119, 46, 35, 29, 17, 128, 91, 8, 81, 78, 22, 101, 111, 2, 63, 88, 82, 51, 53, 110}, {5, 12, 42, 54, 79, 118, 75, 71, 122, 20, 87, 109, 88, 70, 52, 38, 10, 96, 110, 20, 101, 8},
  {38, 33, 109, 51, 62, 30, 112, 100, 19, 42, 105, 85, 20, 103, 43, 9, 18, 84, 112, 82, 2, 22}, {57, 83, 20, 128, 121, 99, 9, 121, 42, 25, 42, 104, 87, 102, 18, 27, 124, 10, 25, 116, 58, 66},
  {93, 96, 106, 109, 103, 37, 37, 116, 62, 43, 20, 114, 25, 119, 16, 35, 75, 20, 63, 38, 127, 81}, {19, 72, 23, 94, 29, 85, 106, 112, 94, 49, 8, 89, 66, 61, 83, 37, 102, 3, 5, 115, 14, 43},
  {24, 105, 92, 129, 23, 44, 98, 98, 34, 64, 22, 111, 49, 66, 118, 50, 113, 28, 53, 11, 99, 25}, {124, 69, 12, 53, 125, 87, 15, 104, 57, 17, 47, 77, 102, 22, 102, 24, 64, 61, 113, 58, 92, 124},
  {105, 67, 75, 40, 108, 21, 58, 80, 127, 28, 63, 118, 17, 13, 84, 46, 49, 31, 93, 43, 63, 75}, {36, 125, 22, 33, 71, 127, 119, 96, 112, 55, 10, 69, 124, 7, 50, 30, 43, 71, 104, 108, 107, 28},
  {29, 90, 71, 31, 47, 35, 54, 91, 29, 6, 18, 107, 55, 21, 51, 5, 25, 44, 111, 4, 39, 17}, {103, 116, 77, 123, 73, 97, 100, 5, 6, 23, 86, 6, 69, 40, 4, 34, 104, 122, 116, 7, 17, 77},
  {66, 92, 8, 126, 54, 25, 123, 35, 77, 61, 117, 55, 23, 24, 56, 29, 114, 95, 101, 78, 109, 118}, {35, 57, 115, 110, 127, 91, 47, 48, 106, 12, 76, 28, 77, 55, 103, 62, 89, 106, 75, 63, 16, 61},
  {32, 66, 30, 108, 89, 59, 6, 19, 58, 53, 73, 17, 12, 18, 120, 33, 111, 90, 74, 80, 84, 23}, {128, 114, 82, 30, 46, 117, 107, 56, 23, 19, 116, 64, 89, 58, 86, 7, 53, 85, 22, 41, 119, 104},
  {129, 117, 63, 66, 11, 5, 91, 45, 117, 41, 78, 49, 19, 88, 72, 11, 12, 117, 32, 97, 60, 114}, {21, 110, 105, 24, 82, 121, 46, 25, 121, 16, 109, 43, 104, 105, 1, 4, 61, 77, 51, 39, 102, 41},
  {8, 87, 44, 16, 117, 1, 71, 38, 50, 26, 85, 25, 16, 81, 62, 3, 23, 78, 28, 102, 56, 19}, {84, 17, 114, 112, 122, 81, 102, 7, 46, 45, 26, 42, 109, 97, 55, 51, 86, 4, 117, 112, 22, 116},
  {127, 26, 46, 95, 92, 58, 122, 27, 105, 21, 16, 20, 45, 83, 57, 56, 117, 12, 114, 26, 95, 78}, {56, 44, 112, 93, 24, 88, 16, 1, 83, 52, 41, 8, 116, 120, 105, 1, 76, 37, 62, 107, 59, 21},
  {51, 56, 9, 72, 31, 7, 41, 16, 12, 14, 19, 22, 52, 74, 97, 39, 73, 16, 90, 42, 79, 45}, {119, 27, 64, 39, 111, 90, 118, 67, 15, 57, 53, 47, 76, 12, 93, 58, 14, 27, 30, 114, 82, 86},
  {96, 22, 47, 3, 72, 66, 104, 42, 82, 54, 12, 63, 57, 44, 113, 40, 52, 58, 4, 45, 24, 117}, {48, 53, 111, 63, 15, 116, 61, 53, 76, 13, 61, 10, 86, 4, 42, 32, 21, 21, 15, 100, 87, 54},
  {61, 7, 10, 47, 64, 34, 29, 60, 56, 44, 23, 18, 13, 32, 20, 15, 45, 38, 52, 55, 26, 57}
};

int NOLH_5[ ][29] = {
  {103, 227, 153, 158, 162, 231, 257, 225, 49, 18, 62, 100, 17, 48, 88, 102, 115, 16, 10, 45, 72, 63, 76, 97, 50, 14, 77, 62, 8},
  {31, 103, 216, 246, 185, 137, 250, 217, 140, 157, 161, 191, 257, 228, 132, 7, 17, 36, 2, 91, 149, 62, 107, 134, 65, 102, 64, 65, 102},
  {42, 153, 31, 144, 247, 209, 242, 229, 166, 94, 53, 64, 34, 38, 241, 214, 146, 239, 217, 63, 22, 40, 10, 80, 5, 111, 76, 114, 49},
  {105, 42, 103, 163, 188, 192, 226, 244, 40, 141, 241, 201, 248, 245, 166, 150, 203, 257, 200, 5, 37, 55, 115, 61, 102, 104, 53, 50, 62},
  {95, 144, 158, 105, 239, 204, 194, 177, 18, 210, 23, 15, 83, 21, 130, 42, 39, 30, 72, 239, 169, 217, 221, 76, 88, 61, 72, 150, 16},
  {114, 95, 246, 42, 222, 233, 189, 245, 186, 118, 216, 196, 216, 182, 235, 110, 99, 114, 96, 229, 224, 233, 252, 147, 9, 103, 45, 90, 36},
  {12, 158, 114, 31, 133, 134, 197, 151, 173, 151, 2, 70, 80, 83, 38, 234, 235, 170, 252, 205, 126, 247, 210, 79, 104, 110, 71, 38, 66},
  {100, 12, 95, 103, 238, 191, 180, 175, 125, 19, 120, 137, 208, 168, 110, 233, 188, 214, 158, 175, 218, 246, 237, 59, 70, 31, 110, 20, 33},
  {20, 133, 239, 162, 100, 202, 190, 252, 46, 99, 243, 60, 118, 111, 48, 169, 105, 77, 88, 159, 49, 19, 59, 223, 231, 152, 44, 94, 21},
  {125, 20, 222, 185, 12, 157, 146, 142, 246, 193, 104, 176, 195, 244, 35, 144, 114, 29, 66, 212, 128, 71, 108, 133, 199, 125, 61, 75, 15},
  {36, 239, 125, 247, 114, 130, 251, 154, 232, 74, 166, 55, 55, 104, 167, 27, 198, 134, 136, 224, 111, 4, 135, 252, 190, 232, 13, 27, 109},
  {19, 36, 20, 188, 95, 172, 198, 160, 127, 254, 113, 127, 252, 164, 185, 112, 154, 206, 215, 158, 68, 81, 73, 202, 191, 169, 60, 2, 115},
  {70, 247, 162, 19, 105, 205, 166, 171, 96, 241, 197, 54, 12, 122, 209, 172, 67, 21, 53, 113, 181, 216, 170, 175, 226, 207, 41, 10, 84},
  {11, 70, 185, 36, 42, 206, 254, 132, 184, 47, 91, 200, 173, 170, 155, 223, 109, 89, 80, 114, 133, 249, 158, 222, 243, 245, 14, 89, 30},
  {73, 162, 11, 125, 31, 136, 196, 145, 190, 250, 146, 69, 13, 39, 29, 79, 216, 246, 140, 32, 216, 140, 146, 116, 233, 199, 33, 48, 9},
  {96, 73, 70, 20, 103, 186, 241, 220, 28, 130, 4, 136, 199, 149, 46, 95, 182, 188, 144, 122, 202, 168, 234, 212, 257, 251, 92, 105, 113},
  {72, 136, 205, 202, 231, 96, 165, 170, 41, 95, 131, 168, 32, 85, 86, 87, 213, 40, 29, 82, 220, 32, 105, 165, 144, 29, 230, 249, 131},
  {122, 72, 206, 157, 137, 73, 219, 174, 199, 202, 233, 63, 157, 162, 123, 45, 228, 48, 40, 125, 153, 78, 81, 247, 81, 6, 176, 158, 154},
  {52, 205, 122, 130, 209, 11, 224, 203, 174, 60, 63, 186, 41, 26, 178, 136, 100, 197, 190, 4, 243, 27, 47, 241, 56, 122, 241, 145, 31},
  {53, 52, 72, 172, 192, 70, 200, 236, 120, 112, 207, 6, 220, 208, 199, 218, 74, 183, 146, 49, 247, 28, 8, 171, 34, 67, 178, 172, 117},
  {86, 130, 202, 53, 204, 19, 253, 248, 97, 191, 8, 205, 29, 44, 238, 77, 236, 24, 106, 202, 39, 178, 240, 162, 94, 116, 167, 186, 151},
  {128, 86, 157, 52, 233, 36, 223, 212, 197, 31, 191, 12, 244, 253, 125, 71, 108, 63, 64, 187, 21, 253, 192, 151, 97, 64, 209, 213, 44},
  {101, 202, 128, 122, 134, 125, 201, 187, 177, 190, 57, 230, 45, 92, 77, 253, 27, 226, 220, 118, 71, 210, 187, 238, 73, 1, 130, 142, 116},
  {56, 101, 86, 72, 191, 20, 210, 169, 123, 100, 125, 130, 189, 191, 66, 175, 1, 250, 241, 207, 90, 174, 166, 138, 119, 11, 184, 257, 72},
  {67, 134, 204, 231, 56, 100, 138, 256, 19, 126, 160, 214, 76, 15, 106, 197, 197, 83, 121, 206, 131, 111, 31, 40, 250, 176, 218, 146, 55},
  {124, 67, 233, 137, 101, 12, 176, 228, 195, 232, 56, 66, 125, 247, 78, 132, 133, 102, 34, 112, 225, 120, 11, 139, 194, 172, 188, 154, 119},
  {25, 204, 124, 209, 128, 114, 156, 208, 185, 63, 173, 142, 75, 118, 143, 109, 34, 194, 237, 182, 245, 74, 117, 47, 220, 221, 183, 236, 82},
  {54, 25, 67, 192, 86, 95, 179, 140, 122, 207, 135, 109, 146, 207, 252, 63, 79, 145, 234, 204, 150, 39, 44, 14, 240, 253, 256, 143, 10},
  {66, 209, 231, 54, 53, 105, 215, 199, 126, 251, 193, 199, 60, 98, 218, 207, 138, 136, 20, 68, 115, 182, 174, 69, 196, 209, 219, 235, 13},
  {49, 66, 137, 25, 52, 42, 193, 148, 231, 54, 41, 111, 205, 190, 165, 100, 229, 86, 14, 120, 134, 163, 189, 13, 209, 239, 215, 250, 136},
  {121, 231, 49, 124, 122, 31, 173, 234, 183, 171, 177, 153, 106, 16, 32, 48, 40, 193, 164, 92, 59, 175, 236, 54, 215, 164, 239, 209, 108},
  {27, 121, 66, 67, 72, 103, 139, 240, 55, 122, 109, 37, 164, 231, 57, 18, 110, 235, 206, 36, 102, 145, 241, 82, 165, 189, 249, 228, 69},
  {119, 173, 215, 138, 165, 257, 27, 182, 86, 103, 37, 8, 150, 110, 37, 47, 49, 180, 5, 40, 55, 183, 53, 30, 223, 108, 114, 36, 236},
  {85, 119, 193, 176, 219, 250, 121, 149, 233, 150, 158, 248, 43, 193, 98, 59, 15, 245, 111, 13, 60, 127, 113, 71, 126, 75, 203, 102, 239},
  {65, 215, 85, 156, 224, 242, 49, 147, 149, 82, 55, 46, 210, 24, 142, 217, 255, 92, 141, 64, 69, 214, 95, 16, 218, 17, 199, 52, 148},
  {43, 65, 119, 179, 200, 226, 66, 249, 111, 154, 219, 244, 56, 152, 140, 192, 254, 71, 197, 12, 18, 181, 80, 110, 221, 121, 165, 76, 200},
  {79, 156, 138, 43, 253, 194, 54, 214, 108, 188, 13, 80, 243, 117, 121, 16, 51, 185, 62, 186, 230, 36, 222, 48, 176, 90, 123, 13, 124},
  {102, 79, 176, 65, 223, 189, 25, 150, 148, 46, 249, 218, 61, 217, 145, 39, 63, 184, 113, 196, 235, 37, 180, 19, 123, 34, 107, 34, 175},
  {82, 138, 102, 85, 201, 197, 124, 178, 194, 139, 34, 81, 204, 84, 50, 221, 176, 9, 135, 247, 251, 104, 122, 106, 149, 85, 246, 55, 234},
  {120, 82, 79, 119, 210, 180, 67, 184, 121, 79, 194, 222, 128, 189, 30, 248, 201, 81, 233, 173, 229, 13, 202, 52, 205, 92, 154, 46, 235},
  {48, 201, 253, 165, 120, 190, 56, 183, 43, 52, 180, 91, 161, 91, 28, 164, 94, 182, 102, 128, 3, 194, 134, 207, 113, 181, 240, 44, 162},
  {57, 48, 223, 219, 82, 146, 101, 159, 251, 183, 128, 166, 58, 177, 44, 183, 11, 140, 4, 142, 44, 144, 114, 227, 124, 139, 131, 3, 212},
  {35, 253, 57, 224, 102, 251, 128, 243, 234, 73, 169, 49, 179, 108, 206, 81, 189, 120, 142, 198, 45, 192, 12, 229, 20, 130, 226, 88, 216},
  {5, 35, 48, 200, 79, 198, 86, 161, 67, 237, 108, 251, 135, 251, 204, 138, 178, 91, 160, 233, 47, 173, 120, 185, 45, 213, 257, 92, 246},
  {58, 224, 165, 5, 43, 166, 53, 131, 51, 245, 182, 13, 214, 10, 184, 121, 2, 179, 124, 79, 227, 96, 149, 226, 69, 230, 190, 64, 223},
  {34, 58, 219, 35, 65, 254, 52, 232, 206, 34, 19, 173, 65, 124, 231, 157, 91, 162, 109, 96, 233, 117, 244, 257, 51, 145, 206, 37, 206},
  {39, 165, 34, 57, 85, 196, 122, 152, 221, 216, 119, 33, 192, 121, 13, 54, 240, 50, 239, 110, 183, 98, 140, 225, 101, 127, 171, 12, 188},
  {93, 39, 58, 48, 119, 241, 72, 141, 54, 62, 68, 227, 134, 163, 12, 26, 160, 69, 132, 139, 162, 18, 176, 243, 41, 217, 160, 139, 157},
  {17, 196, 166, 190, 257, 93, 96, 135, 3, 98, 20, 224, 185, 28, 69, 21, 226, 152, 93, 77, 196, 211, 29, 145, 187, 52, 54, 165, 233},
  {62, 17, 254, 146, 250, 39, 73, 237, 155, 168, 257, 74, 89, 127, 3, 13, 210, 255, 65, 39, 194, 158, 42, 213, 242, 115, 96, 161, 185},
  {4, 166, 62, 251, 242, 34, 11, 221, 228, 24, 44, 211, 174, 103, 162, 235, 72, 53, 240, 35, 215, 227, 72, 230, 203, 80, 31, 254, 146},
  {92, 4, 17, 198, 226, 58, 70, 167, 42, 217, 253, 43, 4, 229, 163, 257, 77, 107, 151, 97, 212, 257, 127, 216, 147, 74, 120, 127, 163},
  {60, 251, 190, 92, 194, 5, 19, 143, 105, 238, 73, 237, 219, 80, 253, 46, 205, 225, 57, 183, 61, 59, 165, 188, 158, 36, 46, 124, 194},
  {7, 60, 146, 4, 189, 35, 36, 168, 189, 71, 186, 29, 7, 138, 175, 33, 211, 133, 49, 250, 16, 21, 231, 166, 138, 57, 85, 247, 197},
  {112, 190, 7, 62, 197, 57, 125, 255, 205, 214, 59, 234, 228, 54, 31, 162, 12, 20, 168, 243, 50, 57, 208, 143, 239, 27, 81, 149, 147},
  {68, 112, 60, 17, 180, 48, 20, 218, 10, 32, 187, 89, 114, 257, 89, 143, 14, 35, 181, 252, 35, 123, 119, 126, 174, 96, 56, 188, 240},
  {78, 197, 194, 257, 68, 120, 100, 195, 65, 10, 157, 143, 239, 40, 36, 186, 234, 161, 15, 251, 145, 152, 25, 91, 57, 248, 78, 177, 155},
  {61, 78, 189, 250, 112, 82, 12, 211, 187, 256, 87, 103, 98, 184, 18, 256, 156, 137, 36, 185, 138, 243, 96, 74, 121, 225, 145, 163, 170},
  {69, 194, 61, 242, 7, 102, 114, 213, 182, 38, 206, 170, 148, 22, 256, 113, 135, 17, 211, 255, 244, 215, 41, 67, 29, 193, 42, 141, 218},
  {64, 69, 78, 226, 60, 79, 95, 230, 50, 246, 11, 83, 104, 205, 257, 78, 136, 100, 179, 163, 180, 149, 39, 18, 11, 141, 115, 199, 166},
  {32, 242, 257, 64, 92, 43, 105, 181, 8, 186, 255, 182, 212, 34, 191, 227, 127, 164, 31, 27, 83, 115, 256, 55, 91, 165, 29, 244, 253},
  {16, 32, 250, 69, 4, 65, 42, 207, 254, 81, 88, 27, 100, 153, 224, 166, 192, 243, 108, 1, 92, 136, 223, 86, 3, 233, 5, 147, 257},
  {8, 257, 16, 61, 62, 85, 31, 164, 237, 173, 234, 174, 142, 20, 68, 3, 75, 45, 242, 109, 144, 8, 207, 10, 36, 235, 102, 126, 201},
  {1, 8, 32, 78, 17, 119, 103, 235, 22, 58, 47, 96, 23, 158, 105, 88, 64, 119, 187, 104, 81, 97, 173, 101, 116, 158, 34, 181, 210},
  {23, 164, 181, 195, 135, 182, 225, 1, 39, 55, 36, 86, 47, 255, 10, 117, 19, 2, 221, 30, 26, 94, 167, 90, 44, 223, 21, 190, 153},
  {94, 23, 207, 211, 237, 149, 217, 8, 164, 197, 148, 165, 233, 4, 24, 58, 44, 4, 212, 20, 86, 101, 203, 95, 125, 174, 30, 240, 252},
  {51, 181, 94, 213, 221, 147, 229, 16, 220, 14, 103, 4, 22, 241, 164, 252, 172, 200, 8, 101, 121, 29, 195, 25, 103, 240, 105, 198, 220},
  {77, 51, 23, 230, 167, 249, 244, 32, 93, 215, 229, 139, 242, 37, 174, 173, 126, 232, 1, 155, 94, 61, 206, 114, 96, 140, 111, 191, 126},
  {28, 213, 195, 77, 143, 214, 177, 64, 48, 219, 90, 107, 28, 188, 219, 60, 68, 68, 188, 152, 239, 244, 26, 77, 92, 171, 136, 187, 152},
  {45, 28, 211, 51, 168, 150, 245, 69, 196, 89, 134, 207, 186, 66, 177, 4, 20, 116, 174, 220, 160, 220, 16, 21, 99, 256, 63, 200, 137},
  {47, 195, 45, 94, 255, 178, 151, 61, 235, 228, 33, 98, 95, 197, 15, 184, 130, 230, 73, 237, 161, 213, 1, 68, 85, 109, 20, 175, 251},
  {63, 47, 28, 23, 218, 184, 175, 78, 45, 84, 244, 213, 155, 77, 64, 135, 171, 199, 69, 169, 193, 205, 20, 53, 12, 226, 16, 155, 123},
  {40, 255, 143, 135, 63, 183, 252, 68, 89, 36, 213, 79, 119, 145, 70, 236, 119, 108, 199, 248, 136, 49, 251, 153, 186, 60, 84, 197, 219},
  {3, 40, 168, 237, 47, 159, 142, 112, 134, 149, 75, 157, 253, 63, 56, 230, 5, 95, 203, 165, 103, 107, 183, 170, 168, 43, 101, 202, 130},
  {90, 143, 3, 221, 45, 243, 154, 7, 222, 110, 242, 102, 109, 206, 215, 69, 170, 178, 99, 230, 84, 126, 255, 135, 225, 48, 47, 185, 202},
  {115, 90, 40, 167, 28, 161, 160, 60, 6, 235, 50, 249, 151, 6, 168, 99, 163, 244, 32, 227, 139, 50, 155, 200, 198, 68, 48, 205, 229},
  {91, 221, 135, 115, 77, 131, 171, 92, 15, 167, 212, 17, 122, 250, 195, 239, 118, 49, 245, 22, 142, 190, 67, 232, 245, 12, 36, 195, 177},
  {37, 91, 237, 90, 51, 232, 132, 4, 139, 142, 77, 126, 188, 82, 250, 165, 89, 110, 169, 41, 246, 150, 4, 154, 228, 8, 66, 233, 254},
  {21, 135, 37, 3, 94, 152, 145, 62, 179, 218, 220, 141, 35, 249, 79, 50, 220, 165, 28, 43, 195, 155, 132, 108, 182, 3, 51, 211, 190},
  {123, 21, 91, 40, 23, 141, 220, 17, 34, 6, 94, 163, 141, 60, 139, 67, 121, 173, 74, 105, 191, 241, 58, 177, 244, 50, 103, 179, 133},
  {117, 152, 131, 183, 182, 123, 170, 93, 13, 97, 117, 236, 87, 223, 111, 12, 180, 27, 214, 67, 192, 82, 224, 221, 24, 161, 235, 39, 179},
  {106, 117, 232, 159, 149, 21, 174, 39, 112, 170, 200, 108, 165, 78, 7, 119, 199, 25, 236, 84, 249, 91, 225, 140, 21, 177, 139, 91, 158},
  {26, 131, 106, 243, 147, 37, 203, 34, 116, 83, 32, 152, 11, 202, 171, 168, 33, 141, 26, 107, 151, 60, 215, 209, 105, 204, 137, 5, 199},
  {127, 26, 117, 161, 249, 91, 236, 58, 83, 225, 153, 30, 207, 43, 154, 205, 56, 131, 54, 80, 141, 20, 249, 160, 61, 202, 201, 106, 213},
  {97, 243, 183, 127, 214, 115, 248, 5, 77, 229, 115, 159, 49, 225, 120, 107, 208, 67, 231, 241, 79, 242, 70, 193, 112, 146, 193, 78, 195},
  {15, 97, 159, 26, 150, 90, 212, 35, 180, 125, 210, 123, 249, 2, 144, 56, 212, 54, 202, 156, 73, 202, 40, 215, 42, 175, 163, 35, 161},
  {99, 183, 15, 106, 178, 3, 187, 57, 130, 115, 80, 242, 77, 216, 41, 140, 96, 207, 42, 126, 27, 171, 30, 180, 10, 188, 150, 123, 164},
  {75, 99, 97, 117, 184, 40, 169, 48, 5, 86, 189, 11, 176, 55, 107, 209, 103, 215, 7, 221, 118, 193, 86, 195, 23, 159, 255, 80, 181},
  {74, 178, 214, 182, 75, 63, 256, 120, 91, 113, 162, 180, 26, 165, 16, 185, 245, 132, 195, 134, 234, 26, 175, 23, 171, 44, 161, 69, 180},
  {80, 74, 150, 149, 99, 47, 228, 82, 198, 178, 83, 42, 250, 115, 122, 241, 174, 18, 125, 160, 170, 33, 152, 3, 172, 39, 158, 66, 144},
  {108, 214, 80, 147, 15, 45, 208, 102, 168, 5, 159, 226, 105, 172, 183, 91, 85, 247, 85, 197, 254, 119, 197, 99, 192, 62, 233, 29, 193},
  {44, 108, 74, 249, 97, 28, 140, 79, 44, 131, 40, 35, 196, 101, 193, 70, 62, 217, 97, 135, 184, 70, 181, 121, 252, 22, 196, 28, 184},
  {9, 147, 182, 44, 127, 77, 199, 43, 104, 147, 232, 208, 111, 185, 186, 134, 221, 34, 155, 88, 17, 148, 110, 72, 230, 58, 250, 24, 205},
  {111, 9, 149, 108, 26, 51, 148, 65, 171, 49, 132, 68, 187, 31, 205, 131, 147, 6, 157, 33, 41, 228, 87, 50, 212, 55, 247, 31, 232},
  {109, 182, 111, 80, 106, 94, 234, 85, 244, 189, 136, 239, 18, 139, 124, 43, 31, 157, 76, 70, 95, 234, 97, 4, 136, 9, 185, 6, 138},
  {76, 109, 9, 74, 117, 23, 240, 119, 98, 57, 102, 114, 225, 89, 62, 103, 54, 192, 23, 86, 104, 255, 98, 109, 169, 123, 236, 17, 224},
  {18, 234, 199, 256, 170, 225, 76, 27, 115, 45, 107, 25, 159, 142, 71, 20, 35, 227, 180, 69, 91, 191, 184, 34, 150, 180, 232, 160, 98},
  {24, 18, 148, 228, 174, 217, 109, 121, 211, 257, 174, 219, 90, 36, 47, 111, 8, 146, 191, 78, 112, 166, 157, 112, 151, 95, 189, 232, 89},
  {110, 199, 24, 208, 203, 229, 111, 49, 242, 123, 27, 26, 256, 211, 198, 160, 232, 82, 87, 44, 36, 137, 198, 122, 206, 186, 208, 226, 90},
  {59, 110, 18, 140, 236, 244, 9, 66, 31, 199, 209, 257, 126, 72, 244, 193, 215, 84, 30, 42, 57, 172, 235, 75, 131, 211, 223, 133, 14},
  {118, 208, 256, 59, 248, 177, 44, 54, 35, 144, 43, 20, 166, 233, 197, 68, 73, 159, 210, 211, 207, 10, 45, 100, 163, 170, 243, 148, 71},
  {50, 118, 228, 110, 212, 245, 108, 25, 256, 76, 251, 181, 64, 62, 203, 97, 106, 196, 148, 193, 252, 99, 89, 128, 232, 124, 200, 136, 91},
  {30, 256, 50, 24, 187, 151, 80, 124, 141, 236, 74, 120, 190, 201, 101, 194, 237, 105, 33, 164, 238, 102, 104, 85, 130, 138, 191, 237, 86},
  {2, 30, 118, 18, 169, 175, 74, 67, 57, 16, 179, 183, 86, 128, 45, 244, 165, 57, 75, 203, 182, 69, 38, 2, 200, 238, 231, 157, 87},
  {89, 187, 248, 170, 2, 252, 75, 56, 58, 124, 240, 94, 170, 144, 4, 142, 116, 186, 167, 240, 30, 153, 209, 155, 106, 38, 234, 218, 20},
  {71, 89, 212, 174, 30, 142, 99, 101, 249, 194, 6, 235, 78, 46, 100, 243, 113, 236, 119, 232, 110, 133, 137, 156, 74, 101, 254, 107, 75},
  {46, 248, 71, 203, 50, 154, 15, 128, 176, 25, 147, 110, 156, 171, 156, 9, 206, 115, 115, 131, 158, 236, 194, 251, 98, 40, 132, 217, 28},
  {10, 46, 89, 236, 118, 160, 97, 86, 66, 205, 66, 145, 20, 132, 173, 38, 252, 60, 45, 242, 52, 116, 196, 169, 48, 42, 172, 239, 17},
  {22, 203, 170, 10, 59, 171, 127, 53, 99, 231, 142, 133, 237, 199, 159, 228, 7, 155, 175, 87, 159, 112, 79, 219, 4, 30, 175, 171, 51},
  {55, 22, 174, 46, 110, 132, 26, 52, 178, 9, 54, 197, 131, 49, 207, 222, 117, 135, 138, 50, 123, 6, 125, 253, 117, 79, 220, 251, 47},
  {84, 170, 55, 71, 24, 145, 106, 122, 247, 180, 230, 52, 137, 183, 22, 104, 134, 46, 60, 23, 200, 128, 102, 201, 75, 105, 221, 176, 43},
  {88, 84, 22, 89, 18, 220, 117, 72, 70, 93, 12, 171, 113, 125, 21, 62, 187, 128, 35, 24, 253, 54, 28, 214, 78, 46, 133, 159, 76},
  {38, 145, 171, 252, 225, 88, 123, 96, 113, 106, 60, 161, 234, 187, 109, 8, 242, 149, 176, 57, 152, 212, 239, 246, 241, 185, 109, 96, 41},
  {113, 38, 132, 142, 217, 84, 21, 73, 158, 243, 237, 104, 120, 99, 82, 32, 166, 219, 255, 117, 176, 256, 159, 231, 148, 242, 134, 118, 85},
  {126, 171, 113, 154, 229, 55, 37, 11, 202, 77, 31, 253, 167, 194, 146, 201, 97, 5, 81, 2, 205, 169, 212, 131, 179, 237, 7, 85, 11},
  {87, 126, 38, 160, 244, 22, 91, 70, 88, 121, 248, 73, 27, 12, 232, 247, 90, 87, 127, 121, 248, 165, 253, 198, 175, 167, 146, 42, 80},
  {98, 154, 252, 87, 177, 10, 115, 19, 95, 120, 22, 220, 162, 213, 247, 55, 151, 203, 246, 192, 1, 88, 65, 141, 227, 195, 117, 84, 93},
  {104, 98, 142, 126, 245, 46, 90, 36, 238, 66, 188, 18, 115, 18, 108, 105, 177, 220, 154, 249, 70, 52, 15, 234, 219, 151, 10, 120, 27},
  {116, 252, 104, 113, 151, 71, 3, 125, 151, 208, 93, 193, 218, 239, 131, 224, 36, 90, 39, 168, 85, 23, 54, 220, 195, 234, 116, 74, 118},
  {6, 116, 98, 38, 175, 89, 40, 20, 102, 102, 152, 112, 3, 123, 58, 178, 9, 98, 51, 244, 54, 134, 94, 236, 204, 160, 99, 51, 67},
  {83, 151, 177, 225, 6, 2, 63, 100, 1, 37, 163, 217, 191, 226, 42, 130, 175, 251, 172, 184, 226, 251, 168, 94, 47, 76, 88, 54, 50},
  {107, 83, 245, 217, 116, 30, 47, 12, 144, 223, 35, 2, 57, 79, 9, 176, 217, 154, 153, 150, 210, 185, 226, 62, 7, 114, 89, 130, 99},
  {13, 177, 107, 229, 104, 50, 45, 114, 152, 3, 176, 134, 222, 156, 233, 84, 58, 47, 9, 111, 171, 224, 201, 64, 77, 66, 79, 33, 54},
  {81, 13, 83, 244, 98, 118, 28, 95, 101, 230, 121, 48, 37, 112, 225, 29, 10, 37, 95, 200, 178, 186, 130, 9, 118, 4, 90, 43, 37},
  {14, 229, 225, 81, 87, 59, 77, 105, 32, 247, 140, 140, 206, 200, 182, 206, 233, 248, 166, 59, 101, 35, 111, 8, 80, 53, 6, 16, 32},
  {29, 14, 217, 13, 126, 110, 51, 42, 229, 92, 86, 71, 81, 97, 141, 133, 230, 147, 247, 115, 8, 51, 116, 66, 22, 15, 94, 57, 60},
  {41, 225, 29, 107, 113, 24, 94, 31, 225, 153, 228, 255, 227, 151, 19, 106, 101, 56, 50, 81, 93, 58, 13, 41, 2, 71, 106, 121, 3},
  {33, 41, 14, 83, 38, 18, 23, 103, 17, 96, 114, 56, 74, 23, 97, 76, 65, 42, 128, 48, 2, 79, 68, 84, 143, 126, 118, 15, 2},
  {129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129},
  {155, 31, 105, 100, 96, 27, 1, 33, 209, 240, 196, 158, 241, 210, 170, 156, 143, 242, 248, 213, 186, 195, 182, 161, 208, 244, 181, 196, 250},
  {227, 155, 42, 12, 73, 121, 8, 41, 118, 101, 97, 67, 1, 30, 126, 251, 241, 222, 256, 167, 109, 196, 151, 124, 193, 156, 194, 193, 156},
  {216, 105, 227, 114, 11, 49, 16, 29, 92, 164, 205, 194, 224, 220, 17, 44, 112, 19, 41, 195, 236, 218, 248, 178, 253, 147, 182, 144, 209},
  {153, 216, 155, 95, 70, 66, 32, 14, 218, 117, 17, 57, 10, 13, 92, 108, 55, 1, 58, 253, 221, 203, 143, 197, 156, 154, 205, 208, 196},
  {163, 114, 100, 153, 19, 54, 64, 81, 240, 48, 235, 243, 175, 237, 128, 216, 219, 228, 186, 19, 89, 41, 37, 182, 170, 197, 186, 108, 242},
  {144, 163, 12, 216, 36, 25, 69, 13, 72, 140, 42, 62, 42, 76, 23, 148, 159, 144, 162, 29, 34, 25, 6, 111, 249, 155, 213, 168, 222},
  {246, 100, 144, 227, 125, 124, 61, 107, 85, 107, 256, 188, 178, 175, 220, 24, 23, 88, 6, 53, 132, 11, 48, 179, 154, 148, 187, 220, 192},
  {158, 246, 163, 155, 20, 67, 78, 83, 133, 239, 138, 121, 50, 90, 148, 25, 70, 44, 100, 83, 40, 12, 21, 199, 188, 227, 148, 238, 225},
  {238, 125, 19, 96, 158, 56, 68, 6, 212, 159, 15, 198, 140, 147, 210, 89, 153, 181, 170, 99, 209, 239, 199, 35, 27, 106, 214, 164, 237},
  {133, 238, 36, 73, 246, 101, 112, 116, 12, 65, 154, 82, 63, 14, 223, 114, 144, 229, 192, 46, 130, 187, 150, 125, 59, 133, 197, 183, 243},
  {222, 19, 133, 11, 144, 128, 7, 104, 26, 184, 92, 203, 203, 154, 91, 231, 60, 124, 122, 34, 147, 254, 123, 6, 68, 26, 245, 231, 149},
  {239, 222, 238, 70, 163, 86, 60, 98, 131, 4, 145, 131, 6, 94, 73, 146, 104, 52, 43, 100, 190, 177, 185, 56, 67, 89, 198, 256, 143},
  {188, 11, 96, 239, 153, 53, 92, 87, 162, 17, 61, 204, 246, 136, 49, 86, 191, 237, 205, 145, 77, 42, 88, 83, 32, 51, 217, 248, 174},
  {247, 188, 73, 222, 216, 52, 4, 126, 74, 211, 167, 58, 85, 88, 103, 35, 149, 169, 178, 144, 125, 9, 100, 36, 15, 13, 244, 169, 228},
  {185, 96, 247, 133, 227, 122, 62, 113, 68, 8, 112, 189, 245, 219, 229, 179, 42, 12, 118, 226, 42, 118, 112, 142, 25, 59, 225, 210, 249},
  {162, 185, 188, 238, 155, 72, 17, 38, 230, 128, 254, 122, 59, 109, 212, 163, 76, 70, 114, 136, 56, 90, 24, 46, 1, 7, 166, 153, 145},
  {186, 122, 53, 56, 27, 162, 93, 88, 217, 163, 127, 90, 226, 173, 172, 171, 45, 218, 229, 176, 38, 226, 153, 93, 114, 229, 28, 9, 127},
  {136, 186, 52, 101, 121, 185, 39, 84, 59, 56, 25, 195, 101, 96, 135, 213, 30, 210, 218, 133, 105, 180, 177, 11, 177, 252, 82, 100, 104},
  {206, 53, 136, 128, 49, 247, 34, 55, 84, 198, 195, 72, 217, 232, 80, 122, 158, 61, 68, 254, 15, 231, 211, 17, 202, 136, 17, 113, 227},
  {205, 206, 186, 86, 66, 188, 58, 22, 138, 146, 51, 252, 38, 50, 59, 40, 184, 75, 112, 209, 11, 230, 250, 87, 224, 191, 80, 86, 141},
  {172, 128, 56, 205, 54, 239, 5, 10, 161, 67, 250, 53, 229, 214, 20, 181, 22, 234, 152, 56, 219, 80, 18, 96, 164, 142, 91, 72, 107},
  {130, 172, 101, 206, 25, 222, 35, 46, 61, 227, 67, 246, 14, 5, 133, 187, 150, 195, 194, 71, 237, 5, 66, 107, 161, 194, 49, 45, 214},
  {157, 56, 130, 136, 124, 133, 57, 71, 81, 68, 201, 28, 213, 166, 181, 5, 231, 32, 38, 140, 187, 48, 71, 20, 185, 257, 128, 116, 142},
  {202, 157, 172, 186, 67, 238, 48, 89, 135, 158, 133, 128, 69, 67, 192, 83, 257, 8, 17, 51, 168, 84, 92, 120, 139, 247, 74, 1, 186},
  {191, 124, 54, 27, 202, 158, 120, 2, 239, 132, 98, 44, 182, 243, 152, 61, 61, 175, 137, 52, 127, 147, 227, 218, 8, 82, 40, 112, 203},
  {134, 191, 25, 121, 157, 246, 82, 30, 63, 26, 202, 192, 133, 11, 180, 126, 125, 156, 224, 146, 33, 138, 247, 119, 64, 86, 70, 104, 139},
  {233, 54, 134, 49, 130, 144, 102, 50, 73, 195, 85, 116, 183, 140, 115, 149, 224, 64, 21, 76, 13, 184, 141, 211, 38, 37, 75, 22, 176},
  {204, 233, 191, 66, 172, 163, 79, 118, 136, 51, 123, 149, 112, 51, 6, 195, 179, 113, 24, 54, 108, 219, 214, 244, 18, 5, 2, 115, 248},
  {192, 49, 27, 204, 205, 153, 43, 59, 132, 7, 65, 59, 198, 160, 40, 51, 120, 122, 238, 190, 143, 76, 84, 189, 62, 49, 39, 23, 245},
  {209, 192, 121, 233, 206, 216, 65, 110, 27, 204, 217, 147, 53, 68, 93, 158, 29, 172, 244, 138, 124, 95, 69, 245, 49, 19, 43, 8, 122},
  {137, 27, 209, 134, 136, 227, 85, 24, 75, 87, 81, 105, 152, 242, 226, 210, 218, 65, 94, 166, 199, 83, 22, 204, 43, 94, 19, 49, 150},
  {231, 137, 192, 191, 186, 155, 119, 18, 203, 136, 149, 221, 94, 27, 201, 240, 148, 23, 52, 222, 156, 113, 17, 176, 93, 69, 9, 30, 189},
  {139, 85, 43, 120, 93, 1, 231, 76, 172, 155, 221, 250, 108, 148, 221, 211, 209, 78, 253, 218, 203, 75, 205, 228, 35, 150, 144, 222, 22},
  {173, 139, 65, 82, 39, 8, 137, 109, 25, 108, 100, 10, 215, 65, 160, 199, 243, 13, 147, 245, 198, 131, 145, 187, 132, 183, 55, 156, 19},
  {193, 43, 173, 102, 34, 16, 209, 111, 109, 176, 203, 212, 48, 234, 116, 41, 3, 166, 117, 194, 189, 44, 163, 242, 40, 241, 59, 206, 110},
  {215, 193, 139, 79, 58, 32, 192, 9, 147, 104, 39, 14, 202, 106, 118, 66, 4, 187, 61, 246, 240, 77, 178, 148, 37, 137, 93, 182, 58},
  {179, 102, 120, 215, 5, 64, 204, 44, 150, 70, 245, 178, 15, 141, 137, 242, 207, 73, 196, 72, 28, 222, 36, 210, 82, 168, 135, 245, 134},
  {156, 179, 82, 193, 35, 69, 233, 108, 110, 212, 9, 40, 197, 41, 113, 219, 195, 74, 145, 62, 23, 221, 78, 239, 135, 224, 151, 224, 83},
  {176, 120, 156, 173, 57, 61, 134, 80, 64, 119, 224, 177, 54, 174, 208, 37, 82, 249, 123, 11, 7, 154, 136, 152, 109, 173, 12, 203, 24},
  {138, 176, 179, 139, 48, 78, 191, 74, 137, 179, 64, 36, 130, 69, 228, 10, 57, 177, 25, 85, 29, 245, 56, 206, 53, 166, 104, 212, 23},
  {210, 57, 5, 93, 138, 68, 202, 75, 215, 206, 78, 167, 97, 167, 230, 94, 164, 76, 156, 130, 255, 64, 124, 51, 145, 77, 18, 214, 96},
  {201, 210, 35, 39, 176, 112, 157, 99, 7, 75, 130, 92, 200, 81, 214, 75, 247, 118, 254, 116, 214, 114, 144, 31, 134, 119, 127, 255, 46},
  {223, 5, 201, 34, 156, 7, 130, 15, 24, 185, 89, 209, 79, 150, 52, 177, 69, 138, 116, 60, 213, 66, 246, 29, 238, 128, 32, 170, 42},
  {253, 223, 210, 58, 179, 60, 172, 97, 191, 21, 150, 7, 123, 7, 54, 120, 80, 167, 98, 25, 211, 85, 138, 73, 213, 45, 1, 166, 12},
  {200, 34, 93, 253, 215, 92, 205, 127, 207, 13, 76, 245, 44, 248, 74, 137, 256, 79, 134, 179, 31, 162, 109, 32, 189, 28, 68, 194, 35},
  {224, 200, 39, 223, 193, 4, 206, 26, 52, 224, 239, 85, 193, 134, 27, 101, 167, 96, 149, 162, 25, 141, 14, 1, 207, 113, 52, 221, 52},
  {219, 93, 224, 201, 173, 62, 136, 106, 37, 42, 139, 225, 66, 137, 245, 204, 18, 208, 19, 148, 75, 160, 118, 33, 157, 131, 87, 246, 70},
  {165, 219, 200, 210, 139, 17, 186, 117, 204, 196, 190, 31, 124, 95, 246, 232, 98, 189, 126, 119, 96, 240, 82, 15, 217, 41, 98, 119, 101},
  {241, 62, 92, 68, 1, 165, 162, 123, 255, 160, 238, 34, 73, 230, 189, 237, 32, 106, 165, 181, 62, 47, 229, 113, 71, 206, 204, 93, 25},
  {196, 241, 4, 112, 8, 219, 185, 21, 103, 90, 1, 184, 169, 131, 255, 245, 48, 3, 193, 219, 64, 100, 216, 45, 16, 143, 162, 97, 73},
  {254, 92, 196, 7, 16, 224, 247, 37, 30, 234, 214, 47, 84, 155, 96, 23, 186, 205, 18, 223, 43, 31, 186, 28, 55, 178, 227, 4, 112},
  {166, 254, 241, 60, 32, 200, 188, 91, 216, 41, 5, 215, 254, 29, 95, 1, 181, 151, 107, 161, 46, 1, 131, 42, 111, 184, 138, 131, 95},
  {198, 7, 68, 166, 64, 253, 239, 115, 153, 20, 185, 21, 39, 178, 5, 212, 53, 33, 201, 75, 197, 199, 93, 70, 100, 222, 212, 134, 64},
  {251, 198, 112, 254, 69, 223, 222, 90, 69, 187, 72, 229, 251, 120, 83, 225, 47, 125, 209, 8, 242, 237, 27, 92, 120, 201, 173, 11, 61},
  {146, 68, 251, 196, 61, 201, 133, 3, 53, 44, 199, 24, 30, 204, 227, 96, 246, 238, 90, 15, 208, 201, 50, 115, 19, 231, 177, 109, 111},
  {190, 146, 198, 241, 78, 210, 238, 40, 248, 226, 71, 169, 144, 1, 169, 115, 244, 223, 77, 6, 223, 135, 139, 132, 84, 162, 202, 70, 18},
  {180, 61, 64, 1, 190, 138, 158, 63, 193, 248, 101, 115, 19, 218, 222, 72, 24, 97, 243, 7, 113, 106, 233, 167, 201, 10, 180, 81, 103},
  {197, 180, 69, 8, 146, 176, 246, 47, 71, 2, 171, 155, 160, 74, 240, 2, 102, 121, 222, 73, 120, 15, 162, 184, 137, 33, 113, 95, 88},
  {189, 64, 197, 16, 251, 156, 144, 45, 76, 220, 52, 88, 110, 236, 2, 145, 123, 241, 47, 3, 14, 43, 217, 191, 229, 65, 216, 117, 40},
  {194, 189, 180, 32, 198, 179, 163, 28, 208, 12, 247, 175, 154, 53, 1, 180, 122, 158, 79, 95, 78, 109, 219, 240, 247, 117, 143, 59, 92},
  {226, 16, 1, 194, 166, 215, 153, 77, 250, 72, 3, 76, 46, 224, 67, 31, 131, 94, 227, 231, 175, 143, 2, 203, 167, 93, 229, 14, 5},
  {242, 226, 8, 189, 254, 193, 216, 51, 4, 177, 170, 231, 158, 105, 34, 92, 66, 15, 150, 257, 166, 122, 35, 172, 255, 25, 253, 111, 1},
  {250, 1, 242, 197, 196, 173, 227, 94, 21, 85, 24, 84, 116, 238, 190, 255, 183, 213, 16, 149, 114, 250, 51, 248, 222, 23, 156, 132, 57},
  {257, 250, 226, 180, 241, 139, 155, 23, 236, 200, 211, 162, 235, 100, 153, 170, 194, 139, 71, 154, 177, 161, 85, 157, 142, 100, 224, 77, 48},
  {235, 94, 77, 63, 123, 76, 33, 257, 219, 203, 222, 172, 211, 3, 248, 141, 239, 256, 37, 228, 232, 164, 91, 168, 214, 35, 237, 68, 105},
  {164, 235, 51, 47, 21, 109, 41, 250, 94, 61, 110, 93, 25, 254, 234, 200, 214, 254, 46, 238, 172, 157, 55, 163, 133, 84, 228, 18, 6},
  {207, 77, 164, 45, 37, 111, 29, 242, 38, 244, 155, 254, 236, 17, 94, 6, 86, 58, 250, 157, 137, 229, 63, 233, 155, 18, 153, 60, 38},
  {181, 207, 235, 28, 91, 9, 14, 226, 165, 43, 29, 119, 16, 221, 84, 85, 132, 26, 257, 103, 164, 197, 52, 144, 162, 118, 147, 67, 132},
  {230, 45, 63, 181, 115, 44, 81, 194, 210, 39, 168, 151, 230, 70, 39, 198, 190, 190, 70, 106, 19, 14, 232, 181, 166, 87, 122, 71, 106},
  {213, 230, 47, 207, 90, 108, 13, 189, 62, 169, 124, 51, 72, 192, 81, 254, 238, 142, 84, 38, 98, 38, 242, 237, 159, 2, 195, 58, 121},
  {211, 63, 213, 164, 3, 80, 107, 197, 23, 30, 225, 160, 163, 61, 243, 74, 128, 28, 185, 21, 97, 45, 257, 190, 173, 149, 238, 83, 7},
  {195, 211, 230, 235, 40, 74, 83, 180, 213, 174, 14, 45, 103, 181, 194, 123, 87, 59, 189, 89, 65, 53, 238, 205, 246, 32, 242, 103, 135},
  {218, 3, 115, 123, 195, 75, 6, 190, 169, 222, 45, 179, 139, 113, 188, 22, 139, 150, 59, 10, 122, 209, 7, 105, 72, 198, 174, 61, 39},
  {255, 218, 90, 21, 211, 99, 116, 146, 124, 109, 183, 101, 5, 195, 202, 28, 253, 163, 55, 93, 155, 151, 75, 88, 90, 215, 157, 56, 128},
  {168, 115, 255, 37, 213, 15, 104, 251, 36, 148, 16, 156, 149, 52, 43, 189, 88, 80, 159, 28, 174, 132, 3, 123, 33, 210, 211, 73, 56},
  {143, 168, 218, 91, 230, 97, 98, 198, 252, 23, 208, 9, 107, 252, 90, 159, 95, 14, 226, 31, 119, 208, 103, 58, 60, 190, 210, 53, 29},
  {167, 37, 123, 143, 181, 127, 87, 166, 243, 91, 46, 241, 136, 8, 63, 19, 140, 209, 13, 236, 116, 68, 191, 26, 13, 246, 222, 63, 81},
  {221, 167, 21, 168, 207, 26, 126, 254, 119, 116, 181, 132, 70, 176, 8, 93, 169, 148, 89, 217, 12, 108, 254, 104, 30, 250, 192, 25, 4},
  {237, 123, 221, 255, 164, 106, 113, 196, 79, 40, 38, 117, 223, 9, 179, 208, 38, 93, 230, 215, 63, 103, 126, 150, 76, 255, 207, 47, 68},
  {135, 237, 167, 218, 235, 117, 38, 241, 224, 252, 164, 95, 117, 198, 119, 191, 137, 85, 184, 153, 67, 17, 200, 81, 14, 208, 155, 79, 125},
  {141, 106, 127, 75, 76, 135, 88, 165, 245, 161, 141, 22, 171, 35, 147, 246, 78, 231, 44, 191, 66, 176, 34, 37, 234, 97, 23, 219, 79},
  {152, 141, 26, 99, 109, 237, 84, 219, 146, 88, 58, 150, 93, 180, 251, 139, 59, 233, 22, 174, 9, 167, 33, 118, 237, 81, 119, 167, 100},
  {232, 127, 152, 15, 111, 221, 55, 224, 142, 175, 226, 106, 247, 56, 87, 90, 225, 117, 232, 151, 107, 198, 43, 49, 153, 54, 121, 253, 59},
  {131, 232, 141, 97, 9, 167, 22, 200, 175, 33, 105, 228, 51, 215, 104, 53, 202, 127, 204, 178, 117, 238, 9, 98, 197, 56, 57, 152, 45},
  {161, 15, 75, 131, 44, 143, 10, 253, 181, 29, 143, 99, 209, 33, 138, 151, 50, 191, 27, 17, 179, 16, 188, 65, 146, 112, 65, 180, 63},
  {243, 161, 99, 232, 108, 168, 46, 223, 78, 133, 48, 135, 9, 256, 114, 202, 46, 204, 56, 102, 185, 56, 218, 43, 216, 83, 95, 223, 97},
  {159, 75, 243, 152, 80, 255, 71, 201, 128, 143, 178, 16, 181, 42, 217, 118, 162, 51, 216, 132, 231, 87, 228, 78, 248, 70, 108, 135, 94},
  {183, 159, 161, 141, 74, 218, 89, 210, 253, 172, 69, 247, 82, 203, 151, 49, 155, 43, 251, 37, 140, 65, 172, 63, 235, 99, 3, 178, 77},
  {184, 80, 44, 76, 183, 195, 2, 138, 167, 145, 96, 78, 232, 93, 242, 73, 13, 126, 63, 124, 24, 232, 83, 235, 87, 214, 97, 189, 78},
  {178, 184, 108, 109, 159, 211, 30, 176, 60, 80, 175, 216, 8, 143, 136, 17, 84, 240, 133, 98, 88, 225, 106, 255, 86, 219, 100, 192, 114},
  {150, 44, 178, 111, 243, 213, 50, 156, 90, 253, 99, 32, 153, 86, 75, 167, 173, 11, 173, 61, 4, 139, 61, 159, 66, 196, 25, 229, 65},
  {214, 150, 184, 9, 161, 230, 118, 179, 214, 127, 218, 223, 62, 157, 65, 188, 196, 41, 161, 123, 74, 188, 77, 137, 6, 236, 62, 230, 74},
  {249, 111, 76, 214, 131, 181, 59, 215, 154, 111, 26, 50, 147, 73, 72, 124, 37, 224, 103, 170, 241, 110, 148, 186, 28, 200, 8, 234, 53},
  {147, 249, 109, 150, 232, 207, 110, 193, 87, 209, 126, 190, 71, 227, 53, 127, 111, 252, 101, 225, 217, 30, 171, 208, 46, 203, 11, 227, 26},
  {149, 76, 147, 178, 152, 164, 24, 173, 14, 69, 122, 19, 240, 119, 134, 215, 227, 101, 182, 188, 163, 24, 161, 254, 122, 249, 73, 252, 120},
  {182, 149, 249, 184, 141, 235, 18, 139, 160, 201, 156, 144, 33, 169, 196, 155, 204, 66, 235, 172, 154, 3, 160, 149, 89, 135, 22, 241, 34},
  {240, 24, 59, 2, 88, 33, 182, 231, 143, 213, 151, 233, 99, 116, 187, 238, 223, 31, 78, 189, 167, 67, 74, 224, 108, 78, 26, 98, 160},
  {234, 240, 110, 30, 84, 41, 149, 137, 47, 1, 84, 39, 168, 222, 211, 147, 250, 112, 67, 180, 146, 92, 101, 146, 107, 163, 69, 26, 169},
  {148, 59, 234, 50, 55, 29, 147, 209, 16, 135, 231, 232, 2, 47, 60, 98, 26, 176, 171, 214, 222, 121, 60, 136, 52, 72, 50, 32, 168},
  {199, 148, 240, 118, 22, 14, 249, 192, 227, 59, 49, 1, 132, 186, 14, 65, 43, 174, 228, 216, 201, 86, 23, 183, 127, 47, 35, 125, 244},
  {140, 50, 2, 199, 10, 81, 214, 204, 223, 114, 215, 238, 92, 25, 61, 190, 185, 99, 48, 47, 51, 248, 213, 158, 95, 88, 15, 110, 187},
  {208, 140, 30, 148, 46, 13, 150, 233, 2, 182, 7, 77, 194, 196, 55, 161, 152, 62, 110, 65, 6, 159, 169, 130, 26, 134, 58, 122, 167},
  {228, 2, 208, 234, 71, 107, 178, 134, 117, 22, 184, 138, 68, 57, 157, 64, 21, 153, 225, 94, 20, 156, 154, 173, 128, 120, 67, 21, 172},
  {256, 228, 140, 240, 89, 83, 184, 191, 201, 242, 79, 75, 172, 130, 213, 14, 93, 201, 183, 55, 76, 189, 220, 256, 58, 20, 27, 101, 171},
  {169, 71, 10, 88, 256, 6, 183, 202, 200, 134, 18, 164, 88, 114, 254, 116, 142, 72, 91, 18, 228, 105, 49, 103, 152, 220, 24, 40, 238},
  {187, 169, 46, 84, 228, 116, 159, 157, 9, 64, 252, 23, 180, 212, 158, 15, 145, 22, 139, 26, 148, 125, 121, 102, 184, 157, 4, 151, 183},
  {212, 10, 187, 55, 208, 104, 243, 130, 82, 233, 111, 148, 102, 87, 102, 249, 52, 143, 143, 127, 100, 22, 64, 7, 160, 218, 126, 41, 230},
  {248, 212, 169, 22, 140, 98, 161, 172, 192, 53, 192, 113, 238, 126, 85, 220, 6, 198, 213, 16, 206, 142, 62, 89, 210, 216, 86, 19, 241},
  {236, 55, 88, 248, 199, 87, 131, 205, 159, 27, 116, 125, 21, 59, 99, 30, 251, 103, 83, 171, 99, 146, 179, 39, 254, 228, 83, 87, 207},
  {203, 236, 84, 212, 148, 126, 232, 206, 80, 249, 204, 61, 127, 209, 51, 36, 141, 123, 120, 208, 135, 252, 133, 5, 141, 179, 38, 7, 211},
  {174, 88, 203, 187, 234, 113, 152, 136, 11, 78, 28, 206, 121, 75, 236, 154, 124, 212, 198, 235, 58, 130, 156, 57, 183, 153, 37, 82, 215},
  {170, 174, 236, 169, 240, 38, 141, 186, 188, 165, 246, 87, 145, 133, 237, 196, 71, 130, 223, 234, 5, 204, 230, 44, 180, 212, 125, 99, 182},
  {220, 113, 87, 6, 33, 170, 135, 162, 145, 152, 198, 97, 24, 71, 149, 250, 16, 109, 82, 201, 106, 46, 19, 12, 17, 73, 149, 162, 217},
  {145, 220, 126, 116, 41, 174, 237, 185, 100, 15, 21, 154, 138, 159, 176, 226, 92, 39, 3, 141, 82, 2, 99, 27, 110, 16, 124, 140, 173},
  {132, 87, 145, 104, 29, 203, 221, 247, 56, 181, 227, 5, 91, 64, 112, 57, 161, 253, 177, 256, 53, 89, 46, 127, 79, 21, 251, 173, 247},
  {171, 132, 220, 98, 14, 236, 167, 188, 170, 137, 10, 185, 231, 246, 26, 11, 168, 171, 131, 137, 10, 93, 5, 60, 83, 91, 112, 216, 178},
  {160, 104, 6, 171, 81, 248, 143, 239, 163, 138, 236, 38, 96, 45, 11, 203, 107, 55, 12, 66, 257, 170, 193, 117, 31, 63, 141, 174, 165},
  {154, 160, 116, 132, 13, 212, 168, 222, 20, 192, 70, 240, 143, 240, 150, 153, 81, 38, 104, 9, 188, 206, 243, 24, 39, 107, 248, 138, 231},
  {142, 6, 154, 145, 107, 187, 255, 133, 107, 50, 165, 65, 40, 19, 127, 34, 222, 168, 219, 90, 173, 235, 204, 38, 63, 24, 142, 184, 140},
  {252, 142, 160, 220, 83, 169, 218, 238, 156, 156, 106, 146, 255, 135, 200, 80, 249, 160, 207, 14, 204, 124, 164, 22, 54, 98, 159, 207, 191},
  {175, 107, 81, 33, 252, 256, 195, 158, 257, 221, 95, 41, 67, 32, 216, 128, 83, 7, 86, 74, 32, 7, 90, 164, 211, 182, 170, 204, 208},
  {151, 175, 13, 41, 142, 228, 211, 246, 114, 35, 223, 256, 201, 179, 249, 82, 41, 104, 105, 108, 48, 73, 32, 196, 251, 144, 169, 128, 159},
  {245, 81, 151, 29, 154, 208, 213, 144, 106, 255, 82, 124, 36, 102, 25, 174, 200, 211, 249, 147, 87, 34, 57, 194, 181, 192, 179, 225, 204},
  {177, 245, 175, 14, 160, 140, 230, 163, 157, 28, 137, 210, 221, 146, 33, 229, 248, 221, 163, 58, 80, 72, 128, 249, 140, 254, 168, 215, 221},
  {244, 29, 33, 177, 171, 199, 181, 153, 226, 11, 118, 118, 52, 58, 76, 52, 25, 10, 92, 199, 157, 223, 147, 250, 178, 205, 252, 242, 226},
  {229, 244, 41, 245, 132, 148, 207, 216, 29, 166, 172, 187, 177, 161, 117, 125, 28, 111, 11, 143, 250, 207, 142, 192, 236, 243, 164, 201, 198},
  {217, 33, 229, 151, 145, 234, 164, 227, 33, 105, 30, 3, 31, 107, 239, 152, 157, 202, 208, 177, 165, 200, 245, 217, 256, 187, 152, 137, 255},
  {225, 217, 244, 175, 220, 240, 235, 155, 241, 162, 144, 202, 184, 235, 161, 182, 193, 216, 130, 210, 256, 179, 190, 174, 115, 132, 140, 243, 256}
};

int NOLH_6[ ][100] = {
  {38, 483, 88, 483, 410, 29, 451, 108, 275, 337, 382, 6, 285, 287, 459, 172, 327, 2, 251, 391, 277, 54, 384, 500, 156, 11, 471, 73, 230, 79, 239, 41, 253, 211, 177, 487, 199, 26, 68, 348, 301, 113, 229, 375, 110, 81, 279, 374, 147, 454, 90, 94, 68, 107, 294, 145, 315, 449, 266, 253, 459, 393, 39, 253, 36, 41, 151, 70, 224, 81, 512, 199, 374, 131, 435, 295, 22, 268, 306, 114, 350, 257, 23, 241, 292, 468, 230, 94, 282, 23, 232, 408, 18, 325, 169, 69, 75, 139, 21, 169},
  {253, 185, 430, 90, 185, 115, 273, 82, 383, 166, 214, 399, 116, 105, 458, 451, 234, 405, 155, 175, 451, 292, 247, 308, 202, 383, 399, 232, 369, 180, 124, 330, 234, 166, 147, 446, 369, 17, 383, 382, 399, 244, 292, 59, 7, 308, 54, 116, 291, 466, 405, 166, 440, 353, 124, 54, 321, 19, 451, 446, 186, 496, 350, 357, 282, 43, 373, 28, 458, 11, 480, 224, 331, 234, 202, 64, 232, 428, 342, 214, 80, 247, 328, 504, 39, 220, 56, 399, 308, 116, 480, 263, 64, 346, 80, 3, 308, 369, 446, 80},
  {185, 447, 22, 123, 38, 351, 182, 242, 465, 338, 288, 292, 141, 56, 500, 293, 236, 399, 98, 273, 403, 122, 473, 18, 95, 255, 464, 337, 292, 101, 180, 406, 12, 390, 71, 445, 158, 146, 234, 376, 290, 198, 13, 467, 229, 159, 79, 416, 222, 13, 242, 115, 161, 464, 39, 12, 142, 14, 190, 229, 238, 288, 393, 447, 178, 317, 270, 164, 426, 362, 34, 22, 194, 132, 379, 445, 485, 414, 207, 478, 400, 313, 37, 218, 241, 360, 91, 63, 47, 13, 214, 376, 113, 498, 190, 159, 200, 231, 51, 111},
  {230, 18, 489, 406, 355, 123, 185, 190, 223, 122, 412, 433, 153, 394, 288, 78, 17, 35, 151, 365, 394, 369, 277, 512, 15, 49, 148, 424, 343, 229, 371, 148, 207, 440, 170, 123, 358, 61, 193, 118, 461, 353, 143, 507, 293, 130, 73, 155, 244, 18, 325, 358, 422, 208, 499, 276, 473, 277, 194, 443, 187, 183, 62, 143, 105, 117, 347, 61, 226, 357, 452, 440, 461, 397, 457, 50, 257, 365, 41, 130, 172, 323, 489, 453, 502, 181, 36, 146, 325, 34, 77, 102, 78, 257, 109, 123, 330, 371, 152, 490},
  {407, 504, 90, 64, 148, 236, 338, 486, 235, 37, 113, 361, 140, 29, 270, 485, 182, 104, 435, 192, 37, 270, 165, 424, 193, 111, 26, 170, 273, 451, 44, 212, 298, 368, 18, 135, 243, 497, 72, 123, 197, 436, 74, 440, 436, 495, 133, 23, 381, 190, 236, 235, 360, 85, 512, 98, 107, 25, 244, 97, 480, 75, 108, 133, 278, 198, 454, 98, 18, 132, 505, 79, 317, 129, 158, 97, 474, 369, 99, 470, 35, 183, 54, 55, 164, 499, 224, 35, 362, 164, 125, 339, 504, 242, 36, 151, 65, 308, 142, 170},
  {512, 154, 463, 494, 269, 167, 198, 232, 92, 117, 38, 333, 429, 204, 26, 19, 326, 128, 230, 49, 46, 306, 96, 246, 1, 128, 41, 118, 184, 143, 211, 143, 41, 429, 93, 69, 176, 168, 95, 406, 328, 205, 334, 178, 232, 3, 45, 138, 67, 102, 128, 95, 356, 40, 75, 1, 398, 144, 230, 300, 478, 150, 12, 40, 441, 19, 237, 141, 222, 210, 178, 100, 66, 127, 400, 58, 53, 342, 467, 74, 191, 99, 95, 251, 145, 236, 181, 116, 69, 327, 35, 191, 74, 95, 1, 119, 441, 298, 67, 21},
  {454, 225, 69, 32, 331, 379, 351, 169, 16, 164, 469, 193, 494, 16, 372, 206, 344, 131, 62, 1, 260, 313, 24, 23, 448, 68, 195, 50, 313, 157, 205, 180, 452, 185, 228, 222, 396, 52, 367, 191, 352, 194, 1, 493, 194, 227, 367, 140, 331, 440, 240, 123, 326, 386, 50, 418, 329, 464, 157, 228, 500, 411, 433, 234, 289, 295, 76, 234, 495, 425, 217, 482, 305, 222, 68, 379, 366, 408, 293, 501, 262, 282, 180, 457, 320, 56, 49, 232, 326, 130, 51, 422, 475, 288, 246, 61, 163, 274, 321, 61},
  {242, 493, 148, 106, 161, 201, 368, 499, 184, 200, 35, 134, 288, 174, 99, 363, 134, 323, 66, 158, 267, 467, 362, 154, 37, 3, 154, 76, 159, 510, 2, 145, 39, 259, 134, 139, 105, 35, 53, 329, 72, 21, 485, 14, 82, 222, 231, 284, 53, 142, 511, 201, 471, 498, 101, 383, 200, 154, 107, 214, 210, 506, 154, 267, 491, 200, 369, 62, 349, 146, 192, 27, 1, 298, 213, 456, 17, 245, 35, 78, 462, 101, 159, 356, 390, 80, 450, 367, 35, 408, 117, 499, 134, 146, 310, 211, 431, 53, 206, 178},
  {68, 116, 469, 431, 491, 376, 359, 23, 129, 75, 504, 242, 405, 93, 252, 318, 301, 75, 210, 242, 406, 224, 183, 250, 451, 504, 276, 14, 137, 226, 476, 443, 361, 137, 66, 15, 451, 276, 23, 424, 246, 183, 201, 210, 144, 93, 176, 371, 110, 508, 371, 49, 293, 91, 95, 78, 106, 378, 171, 476, 509, 118, 16, 242, 269, 318, 188, 154, 49, 71, 5, 331, 111, 287, 8, 169, 482, 322, 144, 115, 110, 169, 249, 167, 341, 254, 477, 176, 276, 169, 261, 154, 498, 297, 266, 464, 364, 250, 35, 323},
  {222, 111, 490, 463, 216, 285, 39, 350, 52, 230, 446, 50, 39, 322, 104, 268, 268, 8, 221, 314, 314, 447, 302, 275, 136, 52, 485, 368, 394, 309, 88, 82, 446, 267, 34, 151, 190, 268, 338, 102, 164, 120, 316, 508, 225, 67, 505, 346, 164, 28, 261, 140, 33, 406, 231, 497, 459, 134, 505, 200, 105, 154, 467, 509, 388, 273, 143, 467, 110, 202, 322, 388, 170, 149, 122, 362, 145, 93, 503, 479, 255, 485, 338, 36, 188, 505, 313, 50, 94, 46, 380, 338, 380, 9, 509, 350, 94, 36, 474, 100},
  {35, 6, 6, 105, 384, 419, 150, 286, 488, 418, 498, 370, 81, 472, 375, 280, 45, 264, 174, 430, 419, 302, 173, 118, 264, 418, 137, 86, 450, 184, 232, 45, 252, 281, 107, 287, 40, 325, 153, 250, 486, 441, 423, 4, 47, 261, 296, 40, 210, 184, 351, 33, 264, 30, 222, 391, 139, 103, 79, 178, 185, 41, 432, 485, 231, 47, 469, 66, 466, 416, 357, 106, 372, 148, 181, 312, 77, 479, 219, 206, 9, 161, 367, 416, 233, 471, 2, 273, 264, 473, 466, 20, 212, 409, 485, 148, 231, 203, 173, 391},
  {278, 428, 93, 487, 382, 62, 173, 254, 391, 314, 397, 314, 77, 92, 215, 156, 295, 425, 236, 413, 8, 305, 69, 468, 206, 227, 77, 67, 320, 337, 150, 369, 460, 435, 264, 163, 258, 359, 441, 133, 323, 391, 191, 331, 150, 439, 235, 175, 339, 291, 206, 384, 337, 310, 16, 439, 305, 132, 424, 127, 250, 378, 91, 359, 495, 440, 365, 206, 206, 227, 206, 36, 149, 34, 192, 425, 83, 460, 47, 397, 424, 320, 468, 128, 31, 431, 220, 305, 440, 390, 18, 288, 222, 338, 364, 81, 117, 294, 264, 394},
  {213, 194, 364, 404, 437, 97, 319, 241, 378, 497, 292, 161, 120, 179, 80, 319, 26, 443, 202, 494, 226, 440, 153, 242, 183, 4, 168, 32, 348, 235, 120, 489, 44, 386, 138, 110, 153, 424, 304, 290, 258, 241, 99, 512, 81, 489, 417, 202, 235, 497, 296, 153, 298, 193, 161, 508, 453, 434, 32, 497, 18, 143, 47, 31, 63, 123, 253, 97, 181, 44, 259, 445, 287, 179, 191, 235, 246, 416, 337, 443, 500, 329, 259, 153, 322, 165, 168, 120, 20, 178, 138, 172, 138, 401, 363, 259, 396, 476, 475, 49},
  {465, 169, 241, 437, 73, 283, 210, 240, 221, 311, 421, 324, 492, 420, 169, 52, 271, 269, 194, 19, 152, 182, 288, 379, 229, 478, 469, 164, 22, 311, 196, 365, 152, 485, 152, 432, 271, 417, 217, 507, 129, 127, 151, 198, 440, 420, 388, 271, 372, 92, 22, 283, 5, 327, 379, 502, 58, 242, 52, 303, 88, 100, 483, 399, 357, 359, 62, 52, 455, 421, 399, 423, 501, 494, 453, 281, 216, 288, 445, 76, 164, 65, 217, 237, 279, 365, 65, 271, 372, 322, 114, 450, 359, 135, 291, 221, 494, 440, 251, 229},
  {414, 363, 471, 152, 225, 56, 353, 381, 115, 153, 426, 500, 467, 24, 63, 336, 87, 56, 127, 162, 502, 360, 303, 61, 128, 87, 2, 80, 248, 104, 30, 56, 487, 452, 380, 437, 104, 113, 168, 157, 488, 488, 81, 229, 512, 348, 61, 454, 394, 301, 56, 315, 348, 1, 303, 117, 244, 293, 303, 236, 195, 322, 94, 48, 433, 11, 206, 114, 276, 118, 248, 301, 175, 217, 319, 37, 359, 229, 42, 442, 374, 84, 442, 90, 264, 1, 143, 360, 502, 433, 502, 270, 30, 487, 394, 24, 356, 68, 94, 494},
  {397, 508, 260, 96, 129, 473, 367, 1, 240, 171, 17, 42, 254, 82, 297, 179, 364, 91, 340, 342, 205, 297, 380, 403, 386, 380, 214, 363, 365, 481, 380, 428, 492, 427, 363, 10, 428, 457, 42, 242, 481, 79, 502, 182, 30, 346, 294, 247, 386, 203, 79, 204, 473, 453, 414, 138, 23, 411, 279, 370, 200, 483, 83, 411, 170, 179, 39, 438, 387, 2, 30, 269, 270, 335, 131, 259, 361, 246, 86, 428, 449, 74, 127, 429, 116, 115, 103, 233, 17, 338, 402, 222, 189, 479, 46, 339, 266, 150, 319, 380},
  {460, 215, 66, 15, 326, 140, 195, 215, 232, 120, 274, 243, 482, 206, 110, 69, 127, 125, 217, 122, 153, 338, 27, 54, 69, 274, 174, 449, 29, 140, 504, 388, 269, 101, 125, 320, 156, 464, 82, 288, 13, 54, 114, 445, 12, 153, 223, 91, 426, 39, 215, 464, 56, 276, 27, 317, 450, 322, 139, 426, 257, 266, 502, 39, 90, 206, 449, 101, 300, 56, 13, 140, 445, 252, 195, 266, 79, 458, 391, 174, 176, 449, 130, 272, 111, 33, 13, 90, 54, 345, 206, 493, 152, 422, 431, 206, 326, 13, 45, 512},
  {158, 359, 460, 330, 307, 505, 356, 107, 489, 432, 219, 127, 209, 437, 280, 100, 454, 171, 320, 480, 454, 204, 189, 143, 40, 59, 405, 12, 240, 22, 274, 287, 285, 81, 321, 267, 147, 67, 432, 390, 127, 187, 158, 101, 163, 302, 204, 449, 315, 163, 501, 88, 207, 363, 480, 40, 72, 345, 67, 189, 128, 303, 352, 12, 345, 480, 54, 67, 288, 78, 501, 314, 51, 315, 330, 449, 317, 503, 483, 489, 207, 225, 12, 277, 19, 143, 222, 67, 40, 511, 333, 189, 204, 35, 238, 288, 274, 464, 331, 433},
  {99, 416, 350, 260, 6, 394, 11, 37, 496, 70, 70, 405, 205, 325, 341, 49, 235, 40, 296, 102, 449, 153, 15, 108, 398, 449, 112, 252, 416, 391, 329, 269, 85, 40, 56, 218, 61, 360, 1, 95, 394, 453, 474, 155, 365, 56, 158, 170, 423, 234, 252, 423, 449, 214, 483, 449, 418, 120, 136, 335, 207, 74, 279, 405, 32, 122, 416, 96, 453, 234, 229, 360, 47, 258, 17, 483, 178, 331, 186, 170, 15, 170, 289, 354, 269, 293, 484, 433, 449, 307, 257, 252, 198, 370, 398, 423, 296, 341, 236, 269},
  {1, 92, 174, 37, 115, 350, 333, 480, 323, 137, 398, 45, 60, 214, 2, 104, 329, 260, 110, 238, 20, 20, 406, 98, 309, 391, 19, 115, 33, 89, 131, 398, 467, 229, 351, 349, 406, 301, 89, 12, 425, 38, 439, 369, 32, 448, 115, 115, 480, 192, 204, 416, 318, 150, 20, 214, 18, 223, 440, 230, 359, 351, 233, 74, 329, 192, 415, 214, 172, 38, 268, 406, 178, 261, 153, 172, 512, 231, 133, 152, 396, 131, 214, 298, 36, 362, 231, 301, 503, 281, 378, 324, 104, 280, 386, 458, 205, 208, 306, 20},
  {324, 500, 453, 486, 66, 184, 197, 231, 461, 263, 471, 230, 27, 203, 16, 428, 219, 208, 431, 402, 141, 416, 428, 262, 454, 406, 185, 136, 259, 454, 230, 177, 480, 93, 141, 162, 219, 123, 116, 124, 82, 266, 47, 109, 406, 255, 454, 177, 212, 150, 454, 504, 485, 238, 325, 24, 379, 344, 379, 203, 485, 459, 96, 325, 82, 454, 303, 100, 393, 406, 245, 91, 8, 263, 210, 373, 186, 243, 298, 245, 434, 50, 404, 276, 24, 168, 38, 317, 263, 265, 231, 40, 454, 30, 150, 98, 154, 152, 174, 45},
  {51, 93, 118, 378, 345, 141, 51, 507, 495, 384, 357, 172, 7, 54, 205, 395, 229, 38, 368, 120, 219, 229, 121, 493, 395, 229, 151, 281, 239, 348, 181, 248, 348, 135, 370, 254, 433, 248, 99, 175, 336, 11, 402, 341, 407, 458, 110, 76, 371, 482, 378, 348, 4, 366, 105, 4, 100, 11, 99, 326, 69, 161, 185, 430, 219, 83, 137, 407, 499, 162, 110, 459, 351, 3, 337, 135, 489, 374, 373, 34, 173, 510, 193, 246, 175, 44, 106, 248, 382, 38, 52, 86, 142, 13, 357, 384, 248, 347, 451, 190},
  {32, 14, 351, 89, 460, 380, 358, 177, 40, 93, 138, 466, 226, 172, 73, 390, 32, 267, 414, 189, 298, 480, 73, 251, 485, 138, 159, 439, 59, 32, 439, 201, 382, 420, 439, 269, 178, 172, 446, 367, 508, 442, 250, 136, 242, 400, 267, 285, 138, 330, 160, 420, 141, 435, 390, 400, 35, 421, 267, 56, 491, 264, 380, 201, 112, 442, 355, 56, 304, 442, 267, 251, 224, 439, 327, 358, 420, 419, 222, 366, 20, 130, 267, 327, 165, 336, 359, 32, 366, 183, 83, 439, 400, 246, 183, 442, 251, 93, 304, 304},
  {300, 167, 314, 501, 512, 40, 199, 250, 207, 85, 21, 276, 512, 142, 225, 200, 276, 121, 477, 221, 262, 352, 292, 85, 189, 133, 317, 8, 466, 190, 142, 40, 388, 406, 53, 433, 7, 142, 437, 27, 141, 61, 321, 490, 39, 73, 220, 121, 130, 349, 216, 231, 154, 11, 422, 215, 401, 315, 122, 80, 394, 158, 282, 437, 506, 263, 266, 39, 246, 175, 141, 187, 411, 282, 420, 242, 277, 10, 94, 175, 276, 37, 422, 428, 476, 124, 358, 496, 39, 7, 264, 53, 53, 506, 73, 492, 128, 492, 3, 220},
  {259, 108, 75, 303, 200, 36, 321, 163, 375, 344, 36, 280, 375, 1, 46, 383, 460, 501, 125, 104, 345, 192, 282, 318, 192, 125, 153, 478, 30, 192, 79, 60, 412, 412, 383, 36, 472, 196, 330, 395, 152, 383, 174, 221, 429, 280, 258, 9, 495, 280, 152, 405, 36, 221, 60, 19, 320, 188, 400, 405, 255, 173, 470, 212, 152, 344, 84, 82, 82, 429, 82, 328, 439, 260, 303, 443, 120, 142, 399, 330, 192, 36, 303, 374, 445, 355, 507, 330, 58, 102, 375, 280, 375, 136, 102, 212, 382, 236, 414, 344},
  {346, 351, 95, 6, 398, 3, 147, 78, 25, 235, 283, 55, 428, 127, 296, 289, 241, 366, 116, 13, 113, 57, 178, 312, 475, 315, 131, 29, 496, 113, 259, 199, 351, 351, 283, 194, 504, 387, 475, 488, 496, 439, 335, 72, 366, 447, 104, 55, 98, 366, 447, 3, 163, 232, 250, 401, 237, 394, 234, 249, 127, 186, 203, 361, 199, 384, 447, 1, 315, 494, 346, 287, 183, 138, 510, 504, 451, 30, 278, 49, 330, 5, 361, 436, 379, 207, 16, 109, 351, 483, 304, 22, 199, 19, 374, 234, 297, 199, 198, 156},
  {369, 227, 424, 346, 450, 200, 391, 344, 227, 452, 180, 227, 180, 285, 36, 129, 136, 333, 352, 251, 372, 425, 227, 19, 409, 454, 122, 349, 322, 200, 59, 205, 445, 3, 156, 111, 262, 111, 292, 24, 349, 171, 503, 156, 38, 15, 172, 44, 44, 304, 285, 370, 332, 272, 274, 472, 280, 216, 84, 227, 147, 405, 74, 418, 332, 333, 448, 130, 5, 495, 146, 495, 315, 227, 372, 332, 383, 68, 253, 332, 180, 476, 135, 486, 388, 445, 253, 381, 425, 31, 488, 370, 303, 374, 227, 97, 115, 454, 479, 19},
  {288, 197, 345, 132, 219, 278, 313, 32, 295, 180, 338, 119, 252, 470, 94, 338, 479, 342, 500, 482, 183, 397, 444, 413, 221, 397, 87, 413, 258, 80, 119, 429, 430, 119, 189, 362, 459, 295, 65, 261, 166, 303, 453, 359, 263, 364, 47, 110, 494, 453, 214, 313, 80, 409, 310, 404, 24, 244, 240, 313, 172, 10, 124, 255, 119, 42, 17, 404, 364, 431, 208, 102, 196, 80, 175, 48, 20, 281, 403, 464, 430, 32, 119, 295, 30, 407, 460, 279, 404, 332, 366, 183, 255, 116, 295, 203, 412, 65, 330, 221},
  {296, 83, 30, 399, 396, 250, 341, 226, 171, 496, 238, 16, 306, 267, 421, 171, 73, 29, 180, 407, 250, 455, 201, 511, 59, 108, 509, 139, 298, 114, 102, 250, 220, 489, 226, 25, 305, 511, 235, 209, 175, 62, 312, 13, 146, 432, 430, 83, 9, 357, 151, 357, 502, 13, 211, 186, 163, 102, 16, 169, 97, 217, 479, 488, 175, 121, 472, 283, 382, 108, 511, 437, 211, 226, 312, 442, 211, 197, 475, 226, 5, 142, 497, 15, 229, 235, 8, 376, 169, 475, 496, 393, 169, 282, 204, 428, 211, 5, 405, 489},
  {77, 236, 482, 429, 356, 437, 181, 45, 386, 446, 502, 95, 181, 3, 368, 224, 471, 389, 115, 45, 471, 167, 230, 347, 171, 129, 105, 198, 471, 198, 316, 153, 224, 1, 82, 60, 126, 376, 243, 227, 105, 102, 49, 118, 105, 30, 105, 300, 186, 305, 212, 35, 260, 161, 82, 95, 148, 342, 146, 153, 410, 428, 407, 300, 344, 300, 158, 471, 35, 502, 212, 192, 276, 446, 260, 437, 371, 170, 83, 82, 316, 146, 305, 240, 80, 266, 262, 260, 315, 422, 133, 389, 437, 443, 460, 115, 462, 495, 372, 437},
  {146, 421, 153, 71, 45, 156, 509, 472, 163, 22, 407, 130, 383, 130, 69, 245, 283, 68, 201, 140, 156, 245, 156, 361, 300, 468, 78, 501, 409, 92, 130, 83, 239, 468, 128, 491, 159, 280, 130, 343, 409, 199, 473, 362, 36, 64, 300, 189, 163, 336, 472, 200, 230, 314, 437, 465, 203, 311, 61, 199, 340, 391, 137, 417, 465, 77, 466, 94, 212, 486, 216, 473, 338, 156, 11, 325, 459, 253, 259, 91, 466, 216, 239, 3, 510, 22, 362, 220, 391, 466, 61, 444, 472, 223, 300, 468, 278, 472, 280, 495},
  {15, 52, 389, 298, 305, 328, 4, 407, 121, 203, 16, 160, 97, 109, 455, 406, 328, 138, 322, 302, 109, 406, 264, 146, 419, 118, 97, 328, 367, 73, 367, 73, 411, 455, 252, 141, 184, 305, 30, 386, 341, 220, 65, 322, 301, 367, 188, 382, 262, 139, 154, 185, 288, 254, 19, 387, 354, 160, 7, 93, 154, 401, 67, 382, 97, 188, 189, 455, 261, 16, 388, 232, 344, 160, 279, 388, 220, 456, 84, 499, 298, 234, 264, 317, 307, 29, 364, 387, 62, 170, 447, 139, 367, 130, 90, 469, 170, 434, 33, 387},
  {391, 282, 20, 440, 116, 321, 55, 300, 120, 183, 440, 346, 33, 293, 256, 327, 240, 440, 252, 504, 466, 205, 432, 149, 321, 293, 327, 105, 375, 100, 277, 355, 383, 466, 440, 389, 293, 273, 361, 358, 300, 149, 129, 64, 179, 65, 321, 162, 266, 169, 84, 310, 390, 387, 293, 414, 417, 50, 293, 149, 206, 293, 314, 321, 149, 383, 440, 169, 321, 240, 97, 414, 470, 137, 190, 8, 218, 275, 471, 120, 33, 414, 372, 482, 100, 269, 452, 414, 422, 448, 266, 414, 300, 113, 346, 432, 57, 346, 19, 266},
  {486, 358, 375, 94, 495, 221, 131, 171, 379, 334, 385, 430, 343, 279, 187, 366, 402, 274, 488, 508, 447, 164, 315, 255, 315, 314, 282, 290, 257, 10, 256, 418, 272, 257, 314, 442, 277, 241, 343, 419, 379, 385, 387, 465, 44, 320, 343, 315, 334, 476, 95, 379, 272, 415, 334, 272, 302, 501, 282, 282, 303, 47, 301, 355, 502, 379, 53, 314, 307, 340, 1, 384, 166, 340, 221, 402, 208, 258, 265, 334, 385, 433, 257, 387, 187, 193, 472, 272, 159, 470, 263, 385, 291, 92, 315, 41, 3, 334, 401, 267},
  {436, 443, 70, 221, 96, 470, 96, 79, 147, 506, 370, 131, 90, 496, 272, 62, 22, 233, 390, 90, 47, 131, 330, 208, 188, 90, 47, 380, 150, 165, 21, 1, 419, 233, 64, 313, 496, 79, 183, 431, 104, 196, 251, 415, 173, 173, 224, 150, 104, 178, 89, 483, 316, 64, 104, 107, 406, 400, 114, 398, 453, 233, 491, 188, 73, 453, 496, 270, 506, 178, 21, 395, 15, 90, 439, 314, 249, 40, 303, 62, 468, 483, 483, 245, 472, 4, 448, 47, 91, 419, 79, 42, 438, 432, 499, 496, 305, 305, 313, 496},
  {363, 362, 272, 56, 408, 161, 238, 362, 412, 38, 490, 111, 64, 158, 447, 367, 57, 277, 312, 161, 436, 341, 213, 426, 467, 490, 245, 436, 64, 488, 57, 211, 458, 57, 182, 97, 426, 259, 172, 155, 377, 185, 397, 83, 286, 48, 377, 399, 341, 193, 341, 151, 133, 113, 78, 296, 4, 470, 111, 193, 161, 384, 370, 408, 259, 64, 473, 132, 40, 323, 296, 211, 251, 18, 15, 118, 150, 227, 129, 111, 213, 117, 467, 220, 85, 119, 500, 95, 457, 277, 40, 69, 139, 350, 182, 436, 208, 499, 329, 213},
  {92, 274, 304, 506, 81, 289, 78, 276, 83, 367, 457, 255, 489, 129, 416, 39, 157, 206, 286, 463, 385, 157, 281, 215, 72, 289, 255, 178, 55, 191, 157, 31, 482, 174, 416, 170, 260, 62, 144, 59, 31, 248, 257, 283, 187, 266, 416, 149, 483, 206, 140, 55, 336, 102, 206, 362, 431, 502, 232, 501, 307, 427, 55, 473, 248, 24, 278, 7, 191, 385, 232, 43, 97, 413, 228, 94, 487, 366, 375, 157, 344, 63, 215, 351, 257, 300, 485, 259, 416, 248, 303, 218, 218, 172, 483, 303, 336, 85, 15, 206},
  {216, 256, 128, 470, 397, 223, 442, 333, 100, 142, 483, 503, 198, 48, 448, 316, 120, 72, 262, 377, 244, 286, 442, 321, 340, 43, 510, 486, 437, 85, 270, 37, 503, 120, 295, 275, 172, 252, 154, 93, 402, 58, 5, 434, 323, 337, 270, 309, 15, 431, 431, 480, 355, 417, 286, 444, 147, 172, 321, 198, 263, 87, 499, 2, 295, 372, 321, 120, 483, 444, 372, 85, 210, 321, 3, 104, 171, 73, 470, 333, 486, 48, 306, 154, 136, 24, 169, 361, 161, 333, 252, 466, 81, 493, 207, 223, 395, 466, 392, 286},
  {283, 458, 136, 93, 168, 14, 414, 35, 117, 258, 286, 507, 402, 231, 147, 505, 131, 238, 303, 6, 496, 209, 17, 159, 236, 69, 392, 375, 17, 8, 421, 139, 117, 8, 14, 510, 507, 336, 481, 135, 209, 139, 390, 196, 107, 375, 58, 147, 91, 14, 477, 323, 69, 166, 209, 341, 366, 106, 242, 286, 277, 90, 183, 97, 261, 481, 505, 240, 147, 193, 238, 95, 346, 183, 390, 238, 215, 181, 113, 336, 123, 209, 481, 59, 7, 166, 499, 477, 243, 131, 81, 209, 69, 237, 205, 14, 421, 247, 308, 407},
  {376, 360, 74, 251, 483, 226, 134, 62, 90, 196, 184, 348, 196, 348, 208, 76, 303, 303, 346, 449, 458, 226, 66, 503, 166, 53, 76, 343, 323, 432, 500, 450, 219, 303, 284, 169, 410, 303, 52, 446, 436, 33, 145, 235, 500, 360, 141, 474, 302, 157, 176, 90, 391, 483, 118, 174, 482, 208, 76, 174, 472, 98, 229, 125, 394, 4, 241, 26, 51, 408, 204, 174, 417, 458, 489, 474, 71, 156, 140, 436, 106, 343, 336, 223, 79, 507, 10, 247, 141, 303, 509, 343, 247, 505, 251, 472, 95, 166, 470, 124},
  {455, 372, 165, 374, 468, 33, 110, 430, 145, 241, 123, 258, 274, 430, 430, 457, 476, 167, 446, 27, 274, 175, 499, 58, 313, 415, 68, 242, 227, 331, 183, 385, 149, 145, 155, 348, 149, 504, 430, 387, 194, 415, 131, 80, 476, 96, 334, 38, 208, 138, 219, 309, 139, 326, 194, 271, 253, 335, 430, 167, 33, 477, 488, 17, 96, 2, 286, 474, 403, 82, 487, 358, 437, 241, 477, 194, 441, 148, 229, 171, 288, 304, 86, 4, 201, 288, 291, 60, 81, 175, 47, 17, 68, 360, 154, 68, 385, 232, 68, 222},
  {487, 174, 368, 70, 294, 330, 379, 460, 439, 43, 480, 496, 104, 260, 235, 21, 365, 473, 330, 277, 157, 56, 489, 110, 214, 30, 169, 255, 246, 508, 188, 159, 201, 278, 105, 387, 188, 388, 290, 274, 441, 129, 318, 116, 447, 416, 330, 214, 512, 43, 209, 388, 174, 379, 5, 496, 238, 207, 21, 478, 123, 135, 130, 135, 452, 233, 174, 45, 188, 321, 246, 485, 254, 478, 486, 330, 321, 425, 1, 310, 104, 116, 353, 58, 358, 90, 127, 154, 302, 223, 243, 416, 388, 10, 276, 209, 7, 330, 232, 137},
  {234, 283, 142, 235, 235, 496, 225, 310, 181, 77, 108, 484, 349, 275, 175, 25, 105, 305, 370, 269, 80, 421, 214, 491, 247, 25, 181, 77, 435, 386, 491, 368, 453, 195, 112, 363, 76, 227, 450, 295, 124, 407, 210, 66, 450, 349, 232, 146, 416, 167, 496, 160, 105, 277, 97, 512, 216, 205, 461, 431, 42, 32, 135, 452, 26, 178, 453, 146, 205, 50, 134, 212, 201, 105, 218, 453, 38, 136, 488, 416, 265, 88, 186, 288, 304, 261, 184, 224, 80, 484, 435, 134, 157, 224, 275, 499, 275, 376, 476, 249},
  {98, 391, 135, 245, 242, 429, 362, 313, 331, 31, 313, 116, 461, 40, 366, 259, 485, 10, 473, 128, 160, 223, 92, 204, 332, 455, 334, 194, 237, 105, 24, 237, 278, 261, 473, 55, 44, 6, 346, 291, 218, 204, 391, 90, 370, 229, 402, 455, 252, 133, 512, 187, 218, 337, 482, 252, 188, 128, 237, 463, 313, 48, 429, 6, 204, 473, 511, 71, 209, 463, 237, 313, 340, 24, 70, 271, 153, 360, 307, 485, 313, 229, 198, 39, 345, 338, 115, 27, 402, 482, 299, 442, 223, 457, 402, 366, 165, 271, 455, 10},
  {456, 106, 224, 45, 61, 11, 250, 88, 216, 457, 406, 381, 127, 100, 148, 275, 381, 170, 211, 433, 351, 98, 449, 394, 346, 201, 507, 359, 125, 503, 359, 158, 451, 289, 339, 281, 332, 479, 12, 200, 406, 263, 456, 473, 125, 8, 149, 451, 460, 278, 424, 61, 470, 492, 456, 285, 440, 212, 187, 216, 20, 410, 336, 98, 501, 6, 479, 235, 394, 31, 460, 400, 73, 12, 275, 381, 87, 131, 423, 1, 63, 127, 216, 328, 209, 177, 203, 6, 30, 479, 406, 501, 501, 31, 158, 346, 258, 332, 74, 173},
  {23, 43, 299, 249, 493, 336, 283, 89, 287, 190, 460, 70, 30, 30, 129, 441, 70, 270, 334, 308, 270, 255, 89, 69, 367, 416, 319, 16, 49, 231, 414, 166, 231, 231, 474, 223, 180, 270, 222, 360, 37, 425, 484, 247, 467, 194, 70, 134, 367, 16, 210, 467, 460, 190, 210, 284, 181, 494, 180, 16, 319, 417, 423, 20, 504, 250, 379, 187, 231, 250, 209, 474, 62, 37, 367, 491, 25, 208, 420, 460, 231, 215, 449, 405, 70, 71, 326, 190, 336, 156, 191, 60, 231, 495, 263, 37, 157, 80, 185, 417},
  {58, 491, 103, 27, 415, 215, 467, 136, 432, 62, 355, 148, 126, 62, 113, 163, 387, 428, 245, 432, 111, 293, 33, 180, 469, 140, 62, 163, 265, 98, 163, 419, 5, 298, 116, 63, 215, 253, 87, 70, 44, 478, 302, 73, 2, 25, 472, 477, 493, 215, 470, 281, 179, 137, 458, 506, 360, 62, 17, 385, 148, 345, 36, 339, 403, 55, 354, 33, 293, 10, 101, 348, 475, 390, 69, 427, 421, 327, 261, 121, 506, 87, 385, 451, 154, 175, 302, 322, 42, 230, 390, 98, 121, 87, 124, 238, 273, 428, 468, 352},
  {219, 384, 138, 500, 472, 408, 216, 394, 438, 177, 473, 194, 232, 196, 222, 482, 222, 216, 342, 177, 438, 249, 394, 27, 216, 378, 408, 7, 362, 262, 222, 272, 196, 151, 163, 369, 408, 133, 358, 232, 408, 438, 310, 75, 420, 154, 197, 368, 369, 369, 17, 205, 408, 325, 420, 452, 105, 240, 40, 290, 466, 232, 298, 141, 136, 136, 408, 19, 343, 401, 114, 81, 236, 93, 482, 136, 248, 240, 61, 459, 47, 355, 420, 134, 310, 136, 229, 253, 59, 420, 194, 136, 76, 483, 40, 19, 48, 182, 420, 354},
  {285, 119, 507, 61, 247, 99, 458, 47, 37, 296, 200, 341, 184, 342, 220, 79, 176, 489, 276, 414, 290, 318, 184, 490, 176, 222, 171, 415, 199, 380, 382, 5, 320, 69, 471, 257, 257, 431, 21, 380, 211, 296, 66, 148, 395, 156, 361, 239, 361, 146, 106, 248, 275, 16, 295, 211, 93, 90, 22, 415, 342, 205, 131, 431, 323, 176, 45, 341, 461, 272, 361, 65, 135, 21, 257, 412, 156, 144, 343, 471, 141, 412, 192, 158, 344, 259, 72, 318, 436, 69, 171, 431, 296, 349, 341, 213, 150, 299, 18, 295},
  {261, 304, 400, 423, 179, 166, 124, 426, 308, 6, 2, 245, 495, 262, 409, 5, 262, 193, 6, 81, 120, 184, 409, 398, 480, 77, 280, 280, 280, 14, 77, 194, 20, 344, 255, 497, 108, 458, 331, 112, 400, 481, 354, 422, 210, 466, 277, 307, 194, 248, 400, 21, 339, 227, 509, 344, 118, 182, 47, 13, 471, 203, 456, 276, 387, 277, 40, 210, 73, 409, 200, 164, 232, 2, 443, 452, 85, 493, 111, 200, 229, 291, 344, 192, 174, 68, 142, 34, 166, 50, 153, 480, 480, 243, 511, 488, 197, 262, 22, 89},
  {479, 74, 447, 183, 217, 417, 267, 431, 259, 462, 5, 237, 103, 475, 499, 185, 138, 259, 162, 490, 52, 232, 322, 198, 253, 492, 312, 224, 423, 76, 475, 52, 356, 487, 224, 391, 4, 59, 24, 109, 232, 427, 349, 377, 131, 27, 185, 96, 131, 372, 81, 168, 312, 369, 417, 135, 285, 201, 475, 183, 427, 426, 65, 186, 299, 312, 61, 289, 490, 459, 85, 153, 229, 10, 134, 261, 299, 185, 112, 31, 88, 286, 322, 82, 1, 57, 159, 208, 119, 153, 404, 224, 409, 245, 130, 372, 64, 423, 402, 230},
  {187, 173, 129, 338, 267, 25, 460, 317, 396, 346, 387, 177, 183, 372, 364, 326, 426, 450, 494, 142, 303, 280, 119, 59, 139, 296, 396, 389, 114, 294, 304, 253, 380, 430, 41, 458, 238, 1, 427, 359, 387, 270, 113, 54, 401, 39, 328, 304, 346, 170, 317, 364, 427, 301, 335, 158, 493, 191, 156, 140, 280, 341, 64, 402, 335, 426, 59, 218, 410, 318, 344, 236, 43, 194, 300, 364, 114, 500, 491, 95, 481, 354, 222, 508, 4, 3, 116, 270, 14, 335, 347, 51, 354, 326, 335, 426, 175, 402, 1, 270},
  {356, 449, 356, 381, 119, 214, 221, 134, 153, 368, 489, 235, 490, 117, 315, 143, 40, 464, 197, 196, 393, 492, 84, 489, 492, 310, 99, 200, 16, 134, 310, 169, 200, 497, 379, 410, 99, 12, 200, 445, 490, 180, 205, 139, 489, 438, 180, 464, 421, 421, 423, 180, 208, 474, 464, 32, 207, 93, 310, 8, 15, 234, 246, 303, 260, 3, 423, 3, 97, 205, 180, 273, 472, 294, 72, 438, 265, 394, 159, 368, 423, 393, 368, 102, 52, 357, 412, 403, 228, 74, 32, 130, 249, 260, 343, 334, 92, 26, 274, 464},
  {497, 130, 354, 362, 210, 423, 491, 253, 236, 79, 282, 108, 37, 223, 470, 248, 412, 477, 505, 167, 494, 91, 91, 412, 120, 113, 254, 394, 275, 125, 55, 360, 116, 254, 94, 473, 125, 412, 484, 267, 444, 155, 472, 177, 327, 125, 138, 373, 363, 225, 360, 197, 231, 194, 205, 37, 357, 459, 306, 145, 256, 353, 113, 112, 360, 351, 359, 282, 83, 327, 112, 2, 448, 212, 161, 92, 340, 413, 3, 496, 160, 265, 205, 403, 78, 345, 273, 311, 346, 444, 444, 223, 148, 354, 282, 92, 15, 275, 463, 412},
  {163, 10, 146, 505, 18, 271, 423, 211, 370, 295, 468, 493, 165, 165, 383, 412, 456, 141, 195, 232, 17, 165, 221, 229, 310, 221, 412, 165, 109, 304, 412, 182, 144, 264, 251, 335, 185, 157, 277, 319, 426, 374, 45, 270, 456, 271, 264, 283, 95, 468, 221, 141, 489, 212, 426, 333, 352, 140, 165, 251, 426, 409, 288, 84, 321, 311, 133, 379, 125, 349, 165, 496, 498, 299, 114, 114, 72, 21, 446, 36, 333, 109, 349, 57, 51, 276, 86, 415, 36, 363, 239, 194, 415, 125, 185, 252, 28, 426, 7, 264},
  {150, 121, 253, 175, 464, 95, 369, 354, 264, 221, 506, 115, 10, 452, 206, 431, 47, 41, 212, 136, 108, 475, 171, 123, 474, 95, 332, 509, 438, 236, 184, 26, 227, 276, 67, 453, 205, 251, 100, 342, 88, 175, 471, 85, 172, 21, 49, 511, 317, 10, 408, 215, 41, 436, 14, 10, 11, 366, 472, 477, 184, 454, 102, 195, 271, 224, 215, 195, 167, 49, 184, 311, 52, 184, 381, 117, 6, 435, 180, 153, 6, 58, 175, 489, 454, 230, 288, 236, 332, 397, 141, 477, 264, 156, 224, 408, 18, 195, 157, 193},
  {477, 100, 329, 369, 303, 51, 158, 273, 190, 363, 260, 300, 477, 244, 21, 312, 2, 496, 416, 91, 237, 315, 343, 2, 378, 469, 432, 269, 172, 24, 328, 123, 339, 86, 160, 1, 244, 128, 155, 189, 139, 128, 78, 11, 472, 160, 353, 190, 497, 377, 287, 178, 377, 318, 72, 218, 403, 221, 328, 27, 27, 79, 54, 218, 331, 469, 173, 85, 377, 378, 291, 256, 27, 377, 180, 251, 431, 491, 101, 218, 139, 377, 315, 151, 125, 64, 311, 101, 313, 331, 353, 433, 202, 377, 189, 113, 331, 344, 222, 160},
  {96, 143, 258, 306, 32, 18, 305, 393, 501, 476, 100, 352, 217, 306, 100, 7, 267, 78, 55, 145, 178, 171, 434, 193, 85, 434, 417, 417, 442, 420, 417, 140, 501, 217, 275, 385, 453, 434, 344, 369, 212, 85, 267, 389, 398, 161, 363, 383, 267, 232, 440, 96, 290, 349, 252, 440, 108, 38, 476, 240, 483, 115, 378, 440, 442, 18, 302, 24, 363, 510, 342, 349, 109, 473, 322, 39, 233, 145, 280, 342, 483, 351, 383, 477, 413, 212, 506, 66, 389, 403, 417, 325, 461, 319, 217, 281, 437, 169, 399, 98},
  {415, 31, 397, 337, 374, 192, 129, 454, 186, 56, 205, 353, 158, 186, 453, 439, 118, 234, 292, 230, 258, 496, 480, 16, 146, 84, 183, 334, 277, 93, 479, 412, 84, 94, 126, 490, 331, 219, 93, 335, 186, 386, 196, 23, 353, 353, 27, 120, 496, 1, 290, 412, 311, 263, 232, 435, 335, 181, 376, 7, 344, 249, 11, 105, 353, 120, 317, 166, 146, 120, 386, 56, 86, 186, 198, 317, 296, 190, 300, 291, 266, 141, 471, 426, 335, 490, 154, 93, 186, 219, 463, 142, 412, 394, 94, 480, 153, 412, 263, 398},
  {410, 81, 491, 213, 149, 486, 438, 198, 109, 431, 116, 87, 100, 379, 146, 408, 158, 58, 268, 502, 261, 143, 143, 442, 180, 116, 189, 356, 507, 201, 109, 291, 163, 343, 214, 302, 508, 384, 379, 451, 41, 201, 348, 84, 303, 325, 57, 58, 459, 12, 488, 163, 2, 230, 276, 189, 55, 392, 201, 172, 84, 323, 48, 100, 435, 276, 71, 22, 356, 75, 43, 121, 281, 84, 294, 291, 90, 325, 393, 446, 48, 35, 466, 46, 321, 38, 420, 512, 22, 283, 364, 379, 507, 139, 428, 466, 96, 58, 188, 2},
  {291, 484, 297, 416, 300, 469, 295, 423, 152, 282, 25, 356, 327, 73, 125, 138, 152, 294, 71, 254, 408, 194, 127, 8, 228, 272, 37, 85, 48, 497, 207, 125, 421, 456, 63, 400, 325, 473, 294, 328, 473, 486, 346, 217, 51, 272, 228, 405, 215, 265, 369, 371, 371, 365, 125, 23, 43, 480, 92, 85, 152, 148, 497, 272, 61, 402, 255, 264, 201, 85, 125, 55, 467, 51, 447, 228, 190, 141, 454, 462, 473, 462, 427, 85, 482, 413, 279, 275, 162, 160, 160, 289, 427, 49, 115, 179, 222, 51, 497, 182},
  {442, 353, 64, 286, 178, 404, 322, 497, 1, 236, 110, 272, 396, 404, 486, 445, 203, 272, 213, 315, 234, 99, 373, 272, 373, 24, 210, 432, 445, 404, 146, 373, 472, 313, 219, 341, 434, 9, 35, 105, 432, 264, 452, 313, 340, 322, 373, 35, 351, 472, 330, 472, 246, 95, 69, 210, 276, 219, 431, 63, 445, 157, 192, 99, 319, 407, 401, 353, 404, 343, 373, 63, 132, 343, 139, 473, 430, 163, 161, 81, 199, 246, 445, 512, 110, 307, 476, 261, 219, 24, 140, 81, 39, 215, 491, 306, 272, 239, 466, 262},
  {478, 142, 8, 43, 388, 178, 26, 487, 474, 407, 49, 215, 220, 281, 460, 178, 428, 73, 432, 352, 443, 34, 269, 261, 381, 474, 379, 462, 66, 121, 379, 407, 375, 297, 483, 227, 74, 49, 299, 38, 154, 347, 362, 251, 58, 220, 349, 34, 134, 404, 12, 44, 96, 203, 142, 347, 475, 63, 474, 460, 289, 151, 163, 439, 142, 462, 207, 178, 33, 74, 154, 235, 23, 193, 325, 141, 511, 294, 354, 363, 512, 81, 297, 400, 352, 228, 80, 482, 114, 404, 58, 511, 193, 438, 313, 261, 244, 480, 362, 226},
  {138, 433, 40, 206, 459, 497, 454, 484, 166, 160, 389, 450, 29, 110, 230, 85, 443, 341, 112, 498, 248, 287, 301, 479, 73, 41, 64, 91, 115, 479, 443, 367, 240, 273, 123, 134, 135, 288, 73, 130, 220, 411, 381, 9, 511, 198, 26, 375, 61, 367, 273, 341, 327, 393, 173, 64, 219, 186, 12, 176, 198, 289, 3, 176, 375, 258, 332, 203, 421, 308, 341, 411, 350, 445, 197, 230, 453, 434, 15, 402, 504, 135, 273, 30, 508, 94, 353, 193, 320, 224, 233, 115, 484, 225, 328, 511, 328, 467, 215, 485},
  {299, 82, 193, 262, 426, 426, 90, 512, 97, 10, 166, 454, 179, 133, 193, 43, 115, 43, 345, 246, 357, 74, 357, 79, 500, 205, 85, 74, 117, 194, 153, 266, 310, 414, 359, 401, 510, 429, 180, 332, 62, 119, 3, 495, 510, 140, 140, 275, 62, 31, 492, 290, 63, 343, 270, 402, 182, 241, 229, 275, 449, 473, 115, 426, 402, 502, 298, 287, 259, 186, 506, 57, 419, 259, 26, 206, 149, 272, 282, 85, 375, 23, 402, 117, 402, 340, 508, 74, 163, 437, 147, 133, 229, 406, 512, 57, 123, 192, 37, 7},
  {380, 388, 26, 471, 285, 503, 143, 219, 503, 239, 39, 29, 3, 28, 319, 239, 188, 202, 279, 362, 287, 485, 202, 495, 32, 218, 270, 188, 312, 65, 32, 359, 96, 395, 485, 345, 239, 80, 188, 225, 135, 324, 259, 351, 324, 174, 239, 2, 96, 412, 478, 494, 250, 495, 65, 164, 213, 170, 395, 61, 338, 153, 194, 164, 398, 510, 157, 65, 439, 239, 324, 369, 155, 219, 232, 243, 60, 58, 188, 21, 28, 194, 2, 132, 298, 63, 99, 148, 501, 188, 267, 448, 32, 324, 156, 239, 33, 21, 486, 503},
  {209, 479, 192, 339, 442, 288, 135, 474, 276, 212, 453, 371, 149, 365, 44, 328, 165, 19, 69, 442, 365, 16, 309, 304, 184, 168, 474, 114, 3, 480, 106, 121, 94, 116, 44, 171, 474, 309, 178, 33, 438, 276, 86, 81, 404, 459, 506, 340, 253, 365, 300, 147, 93, 184, 365, 459, 481, 386, 390, 339, 61, 458, 169, 204, 106, 391, 165, 384, 253, 371, 276, 113, 75, 16, 256, 54, 151, 101, 158, 83, 94, 506, 331, 344, 254, 160, 141, 454, 184, 438, 384, 147, 276, 171, 149, 300, 178, 50, 512, 44},
  {26, 73, 54, 12, 467, 302, 180, 319, 450, 450, 24, 313, 466, 319, 180, 272, 42, 237, 261, 461, 100, 109, 187, 252, 319, 488, 272, 346, 73, 398, 302, 142, 319, 272, 166, 272, 425, 108, 118, 141, 12, 190, 87, 192, 479, 99, 60, 302, 450, 437, 450, 12, 395, 462, 337, 425, 264, 165, 60, 336, 237, 420, 395, 248, 395, 416, 66, 450, 227, 450, 295, 136, 83, 395, 310, 164, 126, 438, 410, 395, 479, 337, 248, 465, 146, 406, 396, 105, 89, 236, 192, 272, 361, 437, 259, 126, 335, 244, 481, 492},
  {374, 337, 462, 162, 165, 433, 160, 470, 433, 502, 50, 89, 50, 197, 152, 502, 5, 297, 52, 444, 481, 218, 311, 163, 203, 72, 335, 153, 222, 108, 87, 374, 91, 359, 433, 172, 502, 322, 311, 503, 452, 91, 451, 31, 359, 115, 166, 504, 383, 308, 336, 181, 220, 157, 15, 340, 257, 101, 265, 340, 502, 19, 406, 203, 46, 126, 72, 502, 72, 276, 197, 433, 63, 504, 362, 268, 507, 90, 324, 117, 181, 166, 89, 112, 246, 389, 394, 383, 417, 374, 218, 117, 12, 475, 126, 219, 304, 291, 12, 335},
  {386, 357, 470, 476, 271, 358, 236, 9, 196, 488, 488, 488, 458, 248, 339, 109, 54, 290, 474, 429, 4, 393, 129, 358, 9, 236, 156, 412, 178, 187, 499, 138, 249, 16, 16, 93, 154, 98, 474, 385, 495, 117, 240, 292, 393, 10, 108, 54, 178, 422, 495, 422, 88, 441, 48, 412, 31, 211, 154, 117, 80, 174, 443, 168, 79, 488, 236, 168, 249, 393, 274, 196, 20, 276, 38, 327, 48, 451, 171, 260, 358, 156, 154, 339, 108, 378, 126, 364, 48, 79, 504, 412, 133, 2, 35, 446, 34, 72, 467, 488},
  {440, 415, 443, 135, 264, 150, 155, 279, 230, 369, 212, 101, 221, 411, 231, 255, 304, 494, 139, 493, 146, 288, 246, 441, 438, 28, 329, 203, 319, 40, 224, 364, 455, 7, 146, 183, 319, 419, 340, 79, 20, 157, 405, 243, 460, 243, 329, 299, 466, 364, 355, 125, 477, 280, 319, 116, 484, 510, 460, 219, 244, 137, 186, 259, 507, 369, 43, 243, 503, 475, 203, 403, 329, 7, 406, 182, 7, 166, 323, 176, 268, 125, 7, 347, 421, 341, 71, 70, 248, 347, 17, 476, 460, 250, 212, 279, 448, 245, 96, 301},
  {235, 502, 48, 442, 334, 252, 315, 321, 143, 143, 115, 382, 321, 39, 173, 88, 318, 53, 2, 381, 299, 215, 465, 507, 138, 40, 233, 494, 160, 254, 493, 77, 493, 160, 158, 156, 416, 365, 40, 408, 318, 455, 414, 462, 455, 223, 117, 182, 248, 436, 131, 139, 465, 53, 416, 295, 136, 497, 382, 498, 5, 242, 93, 27, 232, 451, 182, 29, 351, 89, 193, 266, 171, 232, 160, 131, 318, 126, 376, 5, 67, 241, 197, 190, 465, 278, 81, 108, 410, 246, 506, 88, 211, 286, 197, 507, 376, 235, 502, 88},
  {154, 21, 45, 233, 75, 159, 81, 325, 509, 92, 247, 445, 414, 494, 17, 160, 480, 98, 319, 397, 98, 11, 440, 409, 60, 35, 117, 295, 168, 494, 285, 479, 127, 355, 159, 436, 223, 60, 214, 26, 168, 133, 479, 315, 108, 365, 199, 452, 35, 262, 428, 392, 60, 41, 504, 219, 79, 506, 188, 131, 4, 231, 236, 251, 122, 265, 276, 396, 223, 265, 128, 409, 434, 355, 395, 71, 303, 410, 494, 251, 469, 68, 117, 315, 18, 325, 31, 188, 504, 11, 226, 394, 60, 268, 257, 500, 81, 237, 50, 445},
  {167, 149, 57, 109, 291, 145, 79, 304, 272, 168, 181, 181, 275, 511, 412, 53, 334, 320, 8, 42, 102, 501, 34, 6, 275, 320, 278, 51, 441, 145, 320, 320, 159, 121, 501, 447, 386, 107, 348, 414, 167, 84, 360, 402, 399, 59, 121, 278, 153, 159, 181, 89, 484, 475, 454, 38, 267, 225, 276, 473, 59, 482, 199, 145, 115, 334, 400, 59, 486, 491, 320, 203, 460, 107, 36, 454, 159, 306, 473, 484, 414, 158, 220, 97, 259, 386, 437, 473, 253, 429, 499, 348, 429, 512, 89, 100, 31, 6, 363, 107},
  {471, 314, 505, 16, 320, 257, 505, 366, 59, 323, 275, 179, 460, 432, 320, 269, 446, 20, 235, 74, 414, 407, 104, 356, 356, 107, 192, 304, 217, 239, 408, 251, 192, 389, 269, 373, 356, 380, 365, 5, 151, 444, 262, 58, 70, 499, 407, 318, 118, 407, 368, 441, 476, 22, 103, 471, 407, 107, 142, 341, 432, 141, 434, 116, 251, 310, 194, 107, 171, 487, 160, 280, 151, 348, 494, 223, 182, 264, 372, 23, 499, 104, 380, 172, 210, 225, 178, 407, 29, 304, 250, 432, 441, 264, 23, 251, 171, 504, 320, 171},
  {305, 284, 173, 225, 187, 281, 376, 243, 357, 69, 224, 455, 234, 459, 468, 455, 499, 192, 336, 422, 374, 323, 485, 404, 351, 278, 6, 211, 60, 42, 455, 323, 58, 71, 237, 32, 113, 127, 176, 430, 113, 413, 504, 387, 428, 502, 488, 42, 23, 101, 211, 57, 71, 468, 30, 192, 98, 399, 69, 123, 111, 64, 427, 224, 176, 380, 393, 459, 57, 410, 167, 101, 256, 82, 306, 419, 439, 389, 401, 46, 485, 123, 57, 252, 408, 380, 312, 485, 428, 499, 154, 267, 428, 411, 113, 419, 488, 170, 429, 101},
  {97, 248, 478, 224, 386, 132, 466, 157, 168, 114, 284, 157, 438, 382, 327, 197, 256, 393, 103, 105, 23, 296, 197, 498, 498, 5, 239, 452, 314, 382, 3, 505, 3, 68, 157, 173, 401, 116, 43, 316, 273, 510, 9, 98, 180, 68, 20, 233, 313, 87, 104, 157, 253, 481, 180, 306, 414, 42, 20, 323, 414, 5, 316, 429, 192, 80, 461, 445, 428, 129, 157, 438, 126, 23, 282, 428, 105, 157, 274, 498, 369, 233, 80, 34, 121, 36, 45, 39, 216, 234, 180, 104, 87, 59, 327, 253, 45, 342, 153, 368},
  {313, 155, 18, 23, 122, 58, 27, 358, 248, 199, 155, 96, 450, 329, 88, 115, 99, 123, 40, 278, 242, 199, 361, 402, 8, 479, 115, 215, 380, 199, 215, 497, 115, 402, 131, 203, 252, 77, 175, 94, 492, 8, 340, 106, 77, 278, 437, 77, 143, 379, 136, 216, 450, 251, 155, 84, 197, 192, 96, 84, 230, 237, 386, 289, 380, 222, 289, 8, 317, 119, 42, 329, 252, 484, 9, 176, 396, 182, 415, 421, 7, 248, 155, 346, 268, 339, 147, 479, 68, 413, 31, 77, 497, 413, 160, 216, 242, 42, 147, 175},
  {381, 424, 504, 504, 380, 64, 231, 100, 8, 245, 321, 409, 411, 479, 226, 8, 170, 500, 175, 476, 315, 332, 217, 41, 64, 409, 29, 41, 411, 278, 204, 284, 409, 341, 176, 278, 228, 508, 413, 393, 311, 29, 256, 127, 231, 479, 318, 479, 204, 376, 479, 217, 186, 32, 8, 380, 103, 47, 100, 502, 443, 81, 377, 266, 85, 204, 338, 196, 413, 238, 18, 186, 285, 120, 380, 446, 285, 237, 119, 230, 328, 214, 3, 78, 202, 215, 227, 235, 217, 231, 41, 304, 186, 66, 274, 479, 120, 431, 197, 72},
  {176, 329, 321, 475, 299, 234, 220, 442, 441, 299, 26, 144, 44, 431, 337, 26, 321, 47, 254, 224, 217, 266, 144, 62, 352, 476, 390, 260, 287, 122, 374, 299, 328, 167, 167, 328, 253, 55, 150, 381, 195, 195, 11, 328, 217, 228, 196, 441, 237, 8, 407, 167, 287, 506, 182, 7, 350, 429, 38, 484, 365, 300, 454, 108, 467, 328, 287, 222, 62, 189, 44, 451, 231, 417, 150, 217, 384, 391, 145, 44, 38, 361, 189, 247, 221, 352, 90, 484, 237, 15, 38, 173, 476, 347, 128, 23, 59, 125, 340, 442},
  {178, 136, 352, 402, 136, 331, 506, 355, 344, 392, 409, 51, 404, 392, 166, 173, 20, 504, 348, 149, 391, 464, 404, 338, 512, 106, 422, 116, 421, 163, 409, 346, 37, 364, 280, 33, 37, 106, 13, 402, 231, 208, 24, 497, 95, 69, 457, 331, 506, 317, 413, 51, 106, 348, 409, 375, 29, 37, 97, 69, 346, 212, 265, 499, 364, 193, 203, 20, 239, 231, 84, 193, 259, 22, 369, 159, 304, 22, 43, 422, 327, 20, 24, 391, 333, 455, 167, 331, 140, 393, 177, 239, 413, 348, 464, 338, 486, 37, 390, 331},
  {191, 56, 381, 419, 118, 195, 57, 158, 367, 34, 57, 286, 468, 428, 144, 398, 63, 332, 466, 127, 366, 309, 260, 177, 377, 234, 224, 460, 460, 290, 344, 116, 266, 45, 438, 332, 485, 207, 57, 128, 34, 138, 309, 314, 290, 450, 463, 267, 66, 110, 260, 468, 199, 167, 318, 148, 427, 507, 45, 309, 388, 385, 206, 82, 463, 144, 422, 34, 61, 271, 309, 130, 238, 423, 464, 34, 19, 153, 19, 296, 463, 224, 230, 81, 256, 305, 114, 501, 249, 503, 388, 174, 306, 233, 367, 137, 6, 501, 192, 52},
  {483, 453, 480, 160, 194, 39, 102, 26, 48, 161, 347, 350, 277, 98, 469, 17, 373, 124, 506, 496, 203, 308, 325, 21, 249, 137, 63, 482, 187, 48, 482, 147, 140, 98, 238, 7, 63, 410, 327, 82, 172, 203, 399, 261, 149, 505, 90, 459, 276, 276, 187, 378, 300, 392, 17, 216, 15, 150, 504, 243, 197, 430, 501, 482, 48, 147, 116, 276, 482, 332, 211, 216, 34, 75, 209, 19, 278, 215, 292, 90, 17, 300, 208, 371, 275, 303, 469, 26, 19, 453, 228, 187, 378, 315, 187, 258, 160, 377, 384, 203},
  {282, 41, 21, 3, 274, 138, 405, 73, 200, 27, 93, 271, 73, 477, 199, 4, 482, 419, 375, 130, 407, 370, 472, 452, 30, 230, 407, 132, 4, 505, 308, 4, 206, 329, 137, 470, 96, 21, 288, 9, 477, 308, 221, 348, 206, 33, 80, 163, 97, 238, 4, 264, 498, 499, 487, 406, 185, 373, 14, 108, 130, 307, 27, 230, 370, 375, 264, 242, 80, 329, 498, 220, 100, 406, 481, 187, 254, 225, 137, 311, 284, 47, 487, 510, 61, 434, 435, 406, 498, 88, 123, 271, 95, 164, 88, 348, 472, 206, 387, 117},
  {243, 356, 373, 462, 471, 68, 294, 92, 333, 57, 295, 349, 8, 328, 242, 161, 322, 392, 278, 214, 218, 392, 111, 174, 148, 392, 325, 325, 272, 209, 203, 228, 175, 392, 287, 383, 349, 110, 254, 66, 414, 19, 287, 7, 196, 189, 161, 148, 328, 371, 340, 19, 228, 312, 38, 312, 161, 372, 175, 250, 434, 9, 271, 175, 392, 44, 322, 189, 161, 328, 205, 503, 68, 218, 463, 111, 67, 177, 412, 33, 161, 327, 67, 343, 430, 233, 497, 349, 33, 253, 410, 126, 172, 313, 409, 139, 172, 253, 258, 70},
  {276, 153, 221, 66, 292, 424, 71, 365, 305, 21, 122, 322, 78, 63, 13, 154, 154, 484, 137, 454, 34, 506, 242, 34, 53, 305, 242, 502, 108, 258, 108, 34, 341, 130, 402, 360, 194, 291, 289, 484, 493, 163, 460, 381, 424, 41, 392, 510, 402, 483, 482, 108, 21, 456, 255, 96, 208, 352, 48, 375, 41, 89, 144, 414, 145, 477, 44, 402, 235, 211, 385, 96, 368, 95, 433, 322, 509, 452, 203, 12, 325, 242, 78, 113, 328, 304, 37, 145, 364, 344, 344, 61, 235, 269, 289, 82, 90, 122, 396, 414},
  {113, 94, 419, 280, 9, 280, 352, 84, 107, 471, 320, 136, 308, 483, 221, 204, 183, 471, 48, 324, 336, 110, 55, 243, 391, 423, 120, 423, 101, 428, 78, 122, 342, 428, 96, 416, 231, 4, 191, 468, 253, 309, 461, 179, 471, 221, 429, 136, 263, 50, 253, 385, 107, 457, 391, 457, 9, 281, 457, 384, 110, 246, 504, 107, 378, 13, 391, 457, 332, 204, 289, 391, 457, 391, 125, 289, 385, 221, 89, 221, 87, 110, 400, 40, 35, 479, 245, 110, 23, 155, 320, 498, 120, 405, 195, 4, 82, 457, 146, 231},
  {129, 54, 7, 215, 273, 495, 291, 488, 214, 410, 141, 250, 465, 208, 401, 221, 111, 401, 420, 110, 410, 420, 381, 182, 135, 163, 465, 166, 420, 120, 201, 353, 126, 271, 333, 129, 241, 450, 54, 255, 86, 504, 152, 470, 504, 208, 285, 32, 488, 241, 457, 101, 233, 443, 32, 245, 272, 334, 147, 191, 214, 302, 174, 484, 111, 135, 208, 188, 228, 135, 86, 375, 127, 289, 253, 245, 264, 363, 88, 228, 74, 165, 191, 127, 189, 364, 410, 228, 294, 32, 208, 333, 155, 40, 175, 54, 93, 132, 166, 457},
  {265, 366, 169, 158, 78, 319, 52, 509, 298, 484, 448, 293, 175, 288, 10, 351, 503, 159, 250, 291, 416, 61, 305, 365, 12, 251, 116, 135, 113, 137, 418, 399, 125, 67, 5, 28, 256, 234, 67, 470, 480, 458, 168, 45, 28, 331, 226, 251, 34, 176, 288, 453, 34, 398, 484, 453, 408, 173, 385, 365, 336, 129, 125, 450, 209, 458, 34, 209, 175, 222, 50, 370, 511, 161, 118, 484, 217, 76, 356, 169, 169, 450, 190, 450, 159, 82, 83, 169, 429, 67, 385, 351, 34, 368, 484, 176, 209, 78, 389, 386},
  {180, 281, 166, 36, 1, 139, 465, 263, 71, 414, 250, 283, 301, 125, 75, 372, 457, 351, 484, 257, 311, 446, 148, 111, 208, 283, 39, 500, 351, 334, 478, 351, 108, 311, 192, 181, 66, 16, 403, 179, 150, 505, 273, 289, 446, 167, 159, 272, 384, 463, 446, 255, 115, 4, 178, 230, 209, 80, 208, 495, 8, 463, 34, 235, 340, 111, 413, 75, 250, 381, 337, 125, 153, 384, 220, 44, 300, 430, 174, 384, 159, 486, 21, 463, 133, 258, 397, 280, 292, 111, 44, 429, 58, 203, 321, 128, 78, 27, 355, 128},
  {511, 319, 212, 502, 270, 117, 349, 492, 470, 158, 433, 342, 501, 210, 426, 59, 496, 44, 109, 211, 142, 44, 249, 129, 322, 381, 59, 222, 35, 322, 113, 459, 139, 433, 441, 438, 444, 94, 433, 469, 223, 242, 79, 19, 362, 378, 486, 145, 139, 368, 441, 72, 190, 351, 169, 143, 483, 117, 334, 410, 39, 365, 455, 113, 462, 242, 307, 492, 158, 117, 433, 44, 207, 69, 285, 99, 256, 160, 413, 492, 299, 132, 486, 392, 318, 302, 342, 459, 222, 268, 69, 19, 72, 65, 242, 441, 393, 285, 219, 476},
  {467, 476, 77, 1, 44, 420, 400, 74, 12, 225, 229, 107, 23, 14, 312, 420, 242, 137, 298, 62, 348, 94, 254, 12, 43, 74, 157, 213, 229, 54, 97, 422, 305, 74, 462, 87, 420, 90, 69, 163, 305, 225, 33, 503, 315, 257, 287, 135, 157, 314, 461, 275, 265, 187, 448, 132, 138, 57, 350, 449, 448, 395, 473, 419, 420, 14, 351, 399, 381, 448, 409, 110, 386, 74, 471, 461, 9, 364, 223, 506, 195, 399, 152, 358, 353, 420, 69, 337, 331, 350, 420, 331, 420, 441, 501, 60, 422, 420, 220, 26},
  {118, 211, 127, 511, 376, 442, 56, 308, 512, 206, 23, 325, 76, 102, 232, 90, 253, 132, 169, 143, 302, 206, 243, 371, 266, 266, 300, 443, 181, 418, 178, 235, 462, 214, 486, 107, 217, 122, 439, 152, 217, 379, 246, 295, 37, 496, 102, 418, 256, 76, 102, 102, 244, 418, 363, 379, 363, 243, 192, 102, 497, 470, 311, 122, 301, 497, 243, 2, 301, 154, 132, 393, 280, 13, 405, 496, 91, 432, 153, 327, 418, 122, 48, 469, 455, 381, 280, 486, 456, 427, 361, 512, 243, 262, 340, 190, 76, 379, 336, 456},
  {328, 273, 99, 201, 221, 447, 163, 289, 209, 280, 327, 360, 238, 155, 54, 56, 341, 482, 373, 26, 424, 236, 50, 209, 127, 200, 305, 40, 238, 188, 40, 196, 410, 349, 419, 419, 196, 150, 209, 292, 196, 215, 170, 32, 99, 238, 249, 341, 349, 457, 265, 257, 299, 375, 127, 265, 412, 275, 209, 238, 470, 99, 5, 313, 200, 196, 178, 261, 278, 280, 249, 99, 154, 221, 86, 209, 116, 207, 266, 141, 212, 325, 209, 289, 350, 482, 503, 165, 450, 16, 116, 457, 209, 446, 142, 265, 99, 221, 441, 81},
  {233, 45, 408, 350, 354, 190, 192, 397, 45, 426, 82, 343, 203, 307, 502, 309, 280, 446, 387, 452, 489, 279, 397, 134, 446, 114, 416, 341, 245, 439, 149, 478, 426, 114, 15, 457, 65, 475, 360, 212, 119, 426, 325, 82, 233, 176, 214, 30, 439, 428, 324, 475, 324, 160, 377, 477, 248, 505, 439, 439, 347, 191, 99, 15, 265, 168, 279, 212, 309, 360, 45, 168, 492, 302, 291, 279, 230, 238, 355, 439, 149, 353, 99, 161, 351, 237, 104, 52, 489, 27, 260, 45, 131, 317, 439, 347, 480, 136, 421, 168},
  {198, 426, 96, 385, 440, 147, 500, 127, 128, 167, 150, 171, 473, 422, 30, 146, 38, 472, 22, 345, 150, 147, 365, 43, 196, 132, 38, 434, 451, 400, 449, 460, 286, 327, 248, 100, 214, 78, 62, 74, 267, 316, 344, 472, 492, 94, 490, 196, 196, 511, 196, 132, 455, 357, 98, 232, 99, 96, 434, 504, 331, 475, 512, 127, 355, 365, 89, 367, 12, 62, 254, 171, 108, 269, 415, 12, 35, 103, 4, 380, 406, 267, 88, 437, 295, 188, 194, 196, 380, 190, 235, 315, 469, 39, 470, 51, 397, 168, 10, 422},
  {387, 354, 485, 283, 362, 204, 494, 173, 125, 382, 231, 436, 6, 441, 405, 368, 382, 6, 483, 11, 30, 512, 218, 60, 382, 298, 362, 231, 302, 256, 268, 298, 71, 317, 354, 51, 362, 317, 405, 322, 244, 302, 255, 195, 256, 396, 313, 490, 170, 396, 6, 382, 396, 218, 396, 405, 265, 309, 426, 362, 101, 103, 145, 362, 471, 268, 19, 180, 121, 125, 233, 188, 265, 362, 225, 340, 315, 341, 431, 150, 354, 451, 376, 322, 171, 140, 153, 366, 340, 262, 60, 340, 125, 295, 392, 447, 9, 392, 282, 281},
  {341, 414, 293, 414, 490, 91, 77, 59, 172, 227, 508, 5, 310, 284, 74, 93, 150, 354, 451, 361, 484, 162, 293, 293, 453, 261, 482, 461, 491, 484, 288, 491, 434, 227, 194, 284, 270, 284, 506, 272, 261, 354, 370, 113, 227, 387, 316, 324, 211, 414, 86, 11, 91, 329, 291, 150, 507, 97, 261, 156, 63, 145, 413, 270, 484, 354, 419, 503, 211, 291, 63, 135, 272, 434, 18, 74, 344, 455, 108, 324, 362, 143, 11, 386, 397, 40, 416, 211, 208, 143, 362, 278, 135, 247, 179, 331, 5, 31, 199, 256},
  {246, 67, 273, 126, 297, 345, 342, 42, 377, 247, 142, 46, 390, 390, 176, 303, 10, 404, 147, 356, 186, 470, 31, 280, 497, 158, 419, 386, 419, 377, 214, 386, 10, 164, 142, 246, 68, 232, 46, 46, 507, 404, 365, 296, 248, 508, 111, 183, 135, 97, 85, 298, 508, 69, 214, 46, 205, 126, 497, 106, 333, 499, 153, 274, 190, 254, 493, 345, 85, 248, 455, 497, 369, 112, 247, 386, 253, 242, 481, 298, 241, 85, 164, 340, 169, 474, 429, 483, 452, 380, 164, 298, 187, 270, 201, 435, 190, 24, 438, 17},
  {140, 336, 343, 473, 272, 476, 366, 214, 490, 283, 401, 490, 272, 124, 58, 127, 96, 361, 490, 64, 418, 40, 366, 476, 486, 96, 344, 313, 58, 430, 338, 127, 314, 462, 85, 472, 251, 462, 386, 25, 314, 233, 117, 303, 339, 77, 306, 314, 22, 403, 71, 361, 85, 243, 311, 82, 28, 282, 49, 126, 40, 361, 286, 343, 311, 58, 136, 375, 258, 476, 20, 498, 418, 166, 127, 375, 59, 277, 214, 403, 82, 14, 206, 45, 291, 283, 66, 497, 412, 395, 71, 166, 184, 314, 206, 412, 232, 462, 317, 272},
  {240, 156, 390, 383, 279, 446, 310, 85, 408, 400, 85, 62, 156, 178, 487, 484, 58, 508, 83, 134, 42, 85, 408, 432, 83, 299, 321, 142, 316, 136, 429, 408, 448, 302, 464, 142, 489, 141, 244, 210, 163, 100, 182, 349, 15, 380, 406, 254, 171, 279, 448, 316, 189, 131, 357, 178, 177, 407, 252, 408, 321, 221, 263, 42, 220, 189, 99, 512, 275, 484, 220, 275, 508, 64, 277, 342, 21, 409, 31, 505, 206, 275, 499, 332, 38, 470, 252, 85, 465, 42, 275, 15, 430, 375, 15, 220, 380, 156, 418, 126},
  {90, 48, 43, 192, 123, 59, 344, 150, 21, 156, 465, 239, 293, 6, 71, 321, 274, 195, 282, 108, 201, 68, 511, 179, 187, 167, 18, 186, 142, 469, 75, 435, 303, 321, 88, 128, 131, 195, 283, 57, 23, 131, 416, 431, 268, 171, 501, 438, 29, 469, 469, 334, 101, 234, 6, 511, 252, 214, 498, 187, 201, 170, 394, 101, 396, 443, 172, 21, 283, 59, 435, 291, 392, 256, 22, 101, 305, 429, 26, 293, 49, 511, 114, 424, 271, 509, 282, 75, 55, 252, 484, 109, 71, 309, 3, 101, 259, 397, 262, 59},
  {169, 464, 440, 405, 501, 224, 38, 29, 127, 297, 221, 158, 369, 368, 410, 386, 15, 69, 313, 119, 469, 368, 447, 221, 224, 435, 275, 52, 338, 312, 71, 440, 335, 127, 49, 386, 169, 15, 275, 409, 386, 197, 42, 51, 197, 127, 94, 325, 221, 386, 224, 174, 341, 127, 369, 227, 60, 218, 386, 499, 54, 168, 114, 410, 18, 410, 98, 432, 105, 368, 463, 231, 410, 15, 178, 29, 392, 347, 297, 285, 96, 266, 308, 501, 278, 441, 166, 202, 9, 54, 132, 488, 338, 170, 432, 197, 341, 481, 121, 82},
  {111, 425, 5, 101, 229, 403, 190, 50, 339, 205, 189, 167, 2, 385, 419, 352, 205, 445, 288, 423, 50, 488, 388, 326, 502, 13, 346, 167, 75, 205, 23, 23, 230, 188, 470, 463, 352, 13, 445, 436, 111, 376, 190, 458, 216, 50, 252, 188, 52, 216, 37, 99, 31, 226, 398, 470, 333, 296, 403, 143, 160, 317, 262, 348, 135, 1, 26, 88, 100, 207, 482, 288, 463, 248, 103, 65, 40, 188, 90, 315, 370, 160, 285, 232, 427, 172, 119, 126, 352, 445, 13, 143, 88, 78, 152, 188, 470, 497, 225, 188},
  {251, 187, 210, 361, 404, 17, 72, 21, 318, 335, 90, 452, 108, 317, 285, 489, 133, 497, 264, 223, 55, 37, 149, 265, 3, 405, 296, 440, 90, 298, 510, 257, 176, 25, 490, 417, 165, 489, 373, 31, 53, 317, 261, 200, 497, 410, 257, 176, 108, 121, 416, 41, 149, 484, 165, 270, 191, 266, 90, 440, 367, 412, 10, 506, 292, 142, 183, 35, 355, 279, 41, 416, 129, 207, 174, 7, 332, 384, 444, 166, 119, 497, 142, 341, 330, 330, 109, 143, 477, 121, 176, 446, 90, 469, 265, 373, 113, 100, 379, 166},
  {74, 385, 465, 40, 63, 108, 286, 363, 210, 110, 281, 363, 41, 17, 223, 423, 363, 465, 294, 132, 13, 13, 338, 417, 210, 178, 473, 220, 161, 504, 391, 413, 427, 95, 144, 502, 170, 131, 117, 466, 170, 45, 350, 152, 13, 467, 208, 249, 484, 208, 103, 8, 447, 144, 404, 169, 156, 53, 496, 192, 3, 467, 323, 208, 12, 284, 227, 358, 66, 358, 420, 481, 46, 103, 323, 326, 284, 104, 38, 55, 305, 41, 125, 116, 139, 105, 88, 481, 317, 244, 326, 220, 103, 427, 317, 192, 473, 104, 271, 404},
  {255, 189, 409, 91, 257, 237, 293, 373, 466, 226, 449, 9, 337, 504, 429, 13, 357, 183, 200, 266, 148, 75, 504, 161, 28, 102, 367, 138, 152, 466, 117, 207, 510, 153, 504, 406, 183, 148, 404, 364, 42, 337, 320, 320, 391, 42, 504, 429, 452, 477, 466, 107, 138, 101, 271, 44, 167, 9, 115, 171, 327, 56, 224, 172, 117, 256, 477, 204, 135, 42, 107, 7, 237, 495, 356, 495, 133, 293, 213, 135, 138, 290, 429, 221, 216, 19, 300, 429, 411, 84, 354, 350, 102, 119, 135, 504, 459, 90, 48, 411},
  {124, 220, 428, 115, 98, 208, 242, 465, 445, 152, 228, 28, 470, 230, 371, 354, 93, 327, 462, 409, 310, 28, 278, 341, 145, 452, 292, 247, 485, 445, 159, 103, 398, 290, 341, 482, 282, 398, 28, 287, 445, 272, 202, 120, 445, 316, 19, 6, 400, 310, 426, 159, 193, 80, 485, 445, 127, 298, 445, 39, 329, 29, 430, 459, 426, 424, 411, 36, 50, 182, 445, 92, 354, 424, 302, 68, 247, 386, 125, 386, 239, 114, 201, 201, 192, 6, 110, 182, 26, 386, 310, 327, 470, 93, 247, 358, 35, 209, 459, 290},
  {496, 333, 392, 326, 182, 96, 456, 455, 123, 310, 68, 123, 53, 163, 493, 496, 279, 174, 161, 103, 236, 146, 204, 355, 212, 22, 490, 99, 307, 279, 377, 203, 111, 163, 307, 149, 221, 125, 267, 233, 221, 310, 268, 121, 238, 207, 365, 184, 307, 300, 486, 68, 328, 217, 415, 5, 286, 294, 203, 129, 271, 332, 156, 279, 437, 271, 329, 73, 238, 388, 68, 439, 366, 371, 151, 163, 508, 344, 397, 497, 103, 328, 27, 169, 98, 447, 441, 355, 271, 6, 149, 125, 80, 336, 490, 369, 500, 238, 281, 6},
  {3, 237, 441, 230, 10, 484, 99, 68, 131, 204, 297, 259, 309, 416, 395, 215, 325, 363, 215, 427, 215, 411, 35, 90, 29, 93, 450, 34, 251, 343, 450, 485, 484, 421, 196, 167, 87, 257, 208, 122, 308, 280, 88, 438, 507, 134, 467, 90, 217, 34, 309, 196, 215, 151, 7, 242, 146, 381, 309, 134, 216, 328, 175, 68, 3, 112, 385, 321, 149, 68, 297, 424, 433, 181, 483, 62, 170, 469, 27, 160, 450, 392, 93, 376, 497, 158, 369, 409, 172, 507, 368, 441, 450, 466, 383, 450, 53, 201, 131, 257},
  {112, 311, 448, 256, 93, 406, 208, 145, 311, 125, 464, 261, 182, 212, 420, 364, 315, 349, 393, 133, 446, 112, 135, 477, 34, 101, 279, 112, 432, 204, 349, 446, 213, 436, 26, 239, 204, 326, 11, 372, 420, 349, 133, 391, 174, 406, 107, 483, 199, 27, 420, 206, 267, 219, 174, 451, 76, 295, 420, 72, 135, 55, 354, 53, 446, 145, 112, 252, 86, 55, 483, 237, 9, 237, 61, 53, 237, 8, 462, 237, 464, 331, 73, 2, 214, 271, 473, 212, 304, 342, 460, 204, 43, 266, 326, 112, 349, 406, 162, 392},
  {393, 293, 248, 190, 8, 459, 404, 424, 369, 223, 149, 110, 431, 292, 62, 444, 233, 30, 427, 415, 161, 60, 334, 13, 399, 123, 110, 161, 430, 264, 411, 236, 218, 424, 279, 98, 46, 331, 459, 48, 381, 328, 37, 321, 361, 29, 283, 204, 31, 194, 365, 229, 444, 228, 328, 175, 411, 195, 381, 394, 297, 310, 208, 110, 411, 139, 38, 394, 320, 361, 407, 77, 90, 229, 451, 468, 457, 214, 370, 60, 62, 394, 17, 362, 348, 321, 304, 444, 77, 99, 446, 151, 65, 24, 478, 264, 192, 459, 465, 328},
  {212, 175, 101, 28, 86, 225, 80, 113, 72, 381, 230, 426, 237, 377, 476, 220, 392, 4, 21, 472, 480, 230, 426, 480, 274, 245, 350, 264, 209, 249, 111, 332, 307, 415, 340, 232, 350, 340, 415, 355, 153, 369, 512, 57, 257, 177, 247, 369, 406, 307, 189, 447, 340, 352, 58, 302, 445, 30, 369, 105, 444, 364, 235, 161, 146, 350, 196, 392, 58, 320, 444, 67, 57, 360, 488, 196, 146, 222, 256, 122, 130, 402, 307, 67, 99, 42, 20, 177, 426, 217, 209, 33, 284, 62, 480, 360, 392, 331, 343, 350},
  {89, 247, 263, 353, 89, 198, 325, 406, 406, 444, 46, 284, 83, 434, 457, 478, 331, 383, 421, 375, 168, 383, 196, 5, 48, 92, 434, 338, 254, 306, 115, 270, 270, 253, 365, 67, 365, 83, 58, 108, 353, 115, 367, 361, 42, 137, 1, 126, 230, 58, 63, 284, 236, 169, 253, 419, 73, 135, 196, 58, 99, 239, 382, 228, 419, 460, 254, 149, 270, 30, 115, 20, 233, 300, 236, 126, 481, 154, 440, 458, 278, 254, 115, 334, 371, 114, 505, 353, 178, 110, 42, 99, 325, 162, 48, 83, 419, 254, 202, 24},
  {5, 498, 404, 55, 469, 395, 165, 401, 146, 324, 337, 468, 225, 395, 379, 216, 395, 490, 35, 419, 476, 107, 500, 337, 490, 17, 453, 288, 225, 401, 298, 50, 280, 324, 124, 79, 167, 182, 298, 487, 140, 9, 124, 481, 459, 113, 288, 132, 509, 132, 150, 150, 381, 297, 339, 52, 434, 61, 432, 361, 326, 399, 245, 428, 459, 225, 177, 50, 245, 369, 258, 327, 169, 361, 5, 66, 289, 319, 192, 193, 107, 322, 337, 441, 173, 510, 202, 375, 386, 432, 100, 193, 4, 459, 381, 477, 169, 216, 471, 280},
  {117, 17, 425, 137, 475, 240, 237, 120, 453, 157, 71, 27, 342, 277, 254, 435, 512, 413, 410, 169, 461, 46, 110, 258, 219, 413, 89, 33, 499, 381, 321, 405, 438, 70, 272, 175, 272, 342, 102, 341, 70, 56, 270, 363, 199, 342, 81, 468, 19, 45, 321, 511, 135, 378, 432, 71, 225, 380, 364, 206, 405, 133, 404, 8, 230, 27, 296, 465, 71, 185, 478, 59, 49, 301, 416, 240, 475, 290, 344, 19, 491, 97, 321, 61, 288, 218, 299, 321, 27, 294, 46, 413, 493, 481, 437, 166, 58, 185, 373, 240},
  {493, 389, 336, 68, 486, 82, 2, 369, 322, 89, 301, 75, 341, 38, 389, 153, 464, 82, 76, 217, 139, 325, 318, 389, 287, 153, 411, 493, 236, 23, 275, 341, 464, 345, 230, 340, 301, 368, 286, 151, 190, 301, 26, 189, 322, 370, 157, 389, 357, 411, 168, 354, 172, 96, 204, 495, 490, 75, 418, 241, 48, 78, 26, 241, 509, 435, 304, 227, 438, 107, 51, 221, 494, 11, 182, 189, 202, 476, 465, 30, 53, 179, 389, 53, 305, 27, 155, 332, 265, 389, 182, 106, 468, 449, 10, 49, 281, 241, 290, 389},
  {179, 312, 216, 161, 256, 238, 226, 481, 111, 498, 10, 61, 256, 132, 267, 130, 500, 180, 344, 18, 415, 234, 312, 438, 204, 498, 111, 204, 26, 118, 467, 438, 429, 61, 25, 81, 456, 455, 493, 228, 27, 480, 44, 352, 190, 157, 480, 311, 79, 346, 438, 254, 61, 512, 111, 61, 330, 327, 148, 42, 190, 113, 33, 66, 238, 180, 35, 200, 481, 212, 469, 476, 283, 480, 199, 429, 364, 132, 218, 309, 477, 274, 200, 255, 212, 26, 128, 204, 438, 180, 477, 458, 1, 63, 153, 291, 80, 286, 227, 42},
  {294, 183, 393, 176, 394, 481, 409, 109, 39, 222, 408, 251, 144, 393, 142, 34, 250, 63, 369, 159, 309, 129, 40, 171, 110, 142, 508, 75, 461, 68, 388, 16, 408, 205, 184, 346, 143, 171, 366, 457, 115, 3, 141, 304, 363, 123, 69, 237, 486, 268, 222, 429, 102, 207, 240, 26, 45, 431, 393, 429, 211, 38, 315, 393, 407, 363, 309, 429, 298, 481, 142, 167, 435, 363, 48, 296, 478, 292, 18, 329, 410, 184, 283, 9, 360, 122, 421, 511, 268, 222, 34, 179, 50, 293, 232, 393, 496, 363, 71, 250},
  {308, 501, 328, 78, 445, 507, 23, 217, 283, 217, 248, 495, 216, 344, 424, 66, 24, 321, 311, 390, 174, 88, 82, 47, 81, 105, 103, 24, 300, 424, 49, 340, 182, 457, 172, 200, 150, 174, 226, 199, 24, 258, 506, 125, 496, 240, 192, 28, 88, 467, 283, 143, 143, 185, 269, 188, 131, 193, 269, 28, 396, 156, 56, 258, 216, 248, 103, 81, 418, 346, 299, 511, 396, 215, 297, 469, 13, 328, 87, 289, 230, 153, 126, 197, 273, 404, 68, 155, 475, 300, 283, 354, 143, 7, 24, 138, 354, 384, 9, 143},
  {451, 383, 340, 248, 423, 130, 269, 65, 140, 234, 3, 228, 1, 300, 370, 512, 354, 207, 229, 272, 512, 246, 3, 445, 150, 103, 33, 103, 308, 64, 156, 300, 103, 438, 103, 205, 77, 404, 377, 47, 90, 150, 458, 475, 313, 120, 234, 492, 154, 49, 404, 329, 121, 444, 234, 226, 336, 148, 280, 382, 413, 235, 428, 354, 121, 392, 274, 478, 282, 260, 90, 41, 142, 475, 387, 211, 161, 56, 358, 448, 271, 228, 339, 189, 325, 103, 62, 475, 448, 103, 441, 404, 83, 408, 38, 484, 56, 465, 247, 35},
  {17, 289, 487, 118, 137, 287, 119, 498, 203, 388, 161, 311, 287, 388, 481, 464, 307, 172, 95, 43, 198, 428, 427, 203, 442, 343, 28, 311, 341, 301, 89, 381, 73, 399, 472, 225, 124, 63, 61, 265, 388, 311, 306, 205, 491, 473, 411, 287, 223, 423, 311, 409, 183, 126, 317, 448, 40, 363, 464, 311, 273, 327, 112, 287, 273, 203, 238, 15, 384, 324, 343, 127, 84, 72, 273, 38, 260, 450, 387, 124, 146, 388, 498, 225, 151, 329, 25, 395, 131, 243, 341, 445, 38, 55, 91, 127, 263, 263, 113, 364},
  {106, 214, 302, 293, 220, 188, 435, 404, 96, 362, 209, 38, 163, 44, 498, 74, 76, 203, 502, 21, 364, 3, 275, 386, 460, 188, 500, 262, 500, 440, 297, 335, 449, 431, 466, 282, 288, 490, 410, 398, 505, 348, 219, 288, 373, 386, 174, 165, 119, 462, 410, 203, 76, 2, 275, 482, 468, 340, 86, 188, 60, 511, 388, 449, 431, 247, 371, 125, 390, 440, 236, 247, 72, 117, 280, 21, 341, 247, 414, 474, 117, 46, 131, 434, 21, 45, 218, 314, 348, 512, 50, 335, 46, 357, 104, 125, 186, 186, 5, 362},
  {382, 195, 429, 240, 193, 317, 239, 272, 261, 68, 367, 425, 197, 465, 91, 32, 265, 155, 232, 201, 167, 418, 176, 395, 473, 497, 56, 512, 261, 474, 497, 409, 299, 366, 68, 407, 382, 345, 56, 264, 327, 53, 330, 197, 19, 408, 380, 448, 293, 261, 53, 16, 132, 323, 215, 45, 436, 22, 78, 315, 454, 325, 381, 293, 233, 474, 293, 167, 380, 114, 418, 197, 450, 479, 111, 300, 307, 295, 396, 473, 68, 293, 253, 290, 44, 462, 455, 68, 176, 261, 497, 265, 94, 431, 427, 293, 194, 388, 6, 215},
  {40, 166, 333, 139, 405, 488, 511, 205, 238, 9, 368, 263, 488, 407, 348, 310, 97, 177, 10, 234, 263, 27, 245, 124, 97, 426, 119, 291, 205, 15, 291, 366, 366, 373, 119, 115, 263, 330, 390, 486, 252, 501, 241, 119, 97, 442, 263, 321, 54, 73, 315, 219, 97, 75, 500, 209, 505, 440, 151, 95, 395, 107, 50, 238, 154, 373, 456, 192, 323, 309, 139, 119, 162, 284, 354, 30, 69, 38, 117, 426, 177, 309, 42, 456, 6, 146, 453, 62, 488, 297, 130, 492, 177, 53, 95, 456, 136, 86, 485, 95},
  {303, 454, 307, 422, 316, 44, 171, 323, 15, 308, 233, 159, 218, 335, 136, 490, 407, 228, 398, 385, 500, 15, 370, 323, 308, 377, 308, 323, 12, 335, 389, 200, 237, 370, 476, 486, 392, 112, 443, 40, 77, 125, 59, 91, 433, 214, 142, 337, 407, 488, 377, 86, 453, 437, 233, 447, 135, 64, 218, 447, 392, 128, 281, 335, 177, 353, 108, 237, 170, 36, 47, 512, 24, 44, 208, 77, 143, 407, 20, 149, 407, 159, 279, 248, 184, 435, 170, 498, 392, 237, 12, 177, 490, 343, 64, 93, 249, 114, 256, 337},
  {422, 105, 295, 294, 72, 402, 416, 207, 280, 84, 404, 483, 373, 58, 483, 483, 166, 143, 101, 109, 43, 42, 438, 266, 326, 247, 456, 438, 84, 153, 16, 137, 223, 439, 153, 61, 31, 373, 159, 421, 58, 71, 476, 258, 422, 340, 352, 71, 448, 114, 199, 377, 366, 293, 43, 297, 251, 336, 320, 224, 66, 330, 32, 240, 66, 52, 92, 326, 340, 298, 382, 195, 190, 99, 476, 498, 128, 404, 121, 42, 482, 456, 31, 478, 386, 93, 296, 428, 432, 326, 66, 240, 288, 450, 234, 278, 144, 320, 492, 405},
  {122, 408, 479, 63, 208, 377, 259, 410, 54, 356, 83, 103, 356, 160, 346, 120, 300, 227, 445, 216, 353, 97, 152, 7, 80, 228, 505, 473, 193, 129, 398, 152, 290, 186, 398, 422, 268, 75, 119, 304, 248, 461, 252, 133, 119, 377, 221, 473, 261, 152, 208, 300, 425, 333, 120, 498, 348, 206, 492, 92, 193, 440, 438, 80, 225, 227, 31, 4, 473, 261, 23, 290, 309, 313, 324, 356, 283, 191, 309, 453, 186, 425, 395, 179, 220, 428, 160, 410, 4, 141, 168, 27, 163, 79, 338, 440, 358, 398, 499, 1},
  {46, 445, 108, 321, 158, 299, 464, 504, 82, 507, 135, 285, 406, 412, 244, 349, 39, 46, 448, 446, 467, 198, 237, 138, 99, 214, 72, 299, 214, 349, 168, 316, 267, 82, 3, 95, 475, 162, 315, 501, 467, 381, 443, 232, 135, 239, 88, 466, 120, 381, 445, 481, 8, 376, 445, 173, 275, 152, 349, 378, 507, 371, 374, 24, 212, 296, 115, 230, 457, 296, 466, 456, 322, 88, 16, 475, 452, 433, 287, 177, 445, 83, 316, 155, 282, 16, 426, 49, 381, 37, 59, 309, 182, 393, 504, 39, 101, 507, 445, 207},
  {338, 239, 76, 510, 290, 94, 503, 129, 400, 373, 298, 205, 503, 81, 268, 253, 255, 367, 269, 258, 233, 314, 164, 428, 71, 271, 273, 258, 295, 373, 76, 164, 137, 129, 444, 47, 273, 47, 258, 187, 233, 116, 222, 238, 443, 166, 200, 358, 373, 99, 137, 240, 428, 98, 373, 456, 439, 508, 428, 366, 146, 256, 292, 329, 493, 499, 121, 184, 386, 216, 25, 386, 464, 233, 505, 184, 46, 193, 25, 22, 136, 314, 428, 5, 244, 139, 457, 348, 309, 209, 224, 295, 192, 37, 268, 184, 413, 400, 114, 366},
  {364, 109, 484, 391, 479, 258, 246, 67, 504, 147, 185, 457, 11, 205, 212, 81, 245, 11, 422, 343, 243, 90, 126, 119, 243, 89, 11, 492, 45, 141, 67, 451, 500, 109, 349, 197, 287, 281, 32, 7, 75, 483, 23, 281, 470, 90, 167, 5, 401, 109, 489, 268, 67, 332, 492, 11, 382, 166, 482, 109, 274, 210, 178, 336, 492, 489, 8, 258, 11, 145, 11, 504, 499, 55, 147, 298, 480, 158, 348, 32, 66, 54, 141, 337, 83, 478, 504, 492, 126, 26, 253, 281, 109, 478, 280, 256, 288, 349, 79, 401},
  {389, 68, 475, 17, 480, 35, 463, 340, 9, 510, 366, 184, 289, 37, 51, 35, 60, 52, 85, 131, 379, 401, 506, 83, 306, 493, 414, 511, 340, 56, 362, 80, 364, 426, 149, 503, 12, 477, 184, 89, 340, 184, 178, 420, 71, 324, 113, 360, 284, 253, 171, 112, 184, 159, 316, 324, 287, 367, 235, 9, 192, 39, 293, 9, 130, 96, 306, 223, 48, 426, 130, 510, 59, 100, 455, 263, 464, 502, 493, 113, 493, 502, 100, 234, 289, 287, 215, 460, 460, 89, 238, 475, 112, 69, 279, 364, 261, 130, 410, 56},
  {57, 13, 335, 83, 489, 134, 411, 298, 437, 11, 304, 246, 122, 403, 192, 247, 272, 134, 465, 240, 472, 384, 7, 496, 55, 26, 403, 53, 329, 272, 206, 447, 470, 144, 292, 188, 380, 363, 120, 254, 298, 463, 291, 239, 261, 122, 341, 95, 238, 479, 159, 393, 384, 469, 304, 423, 327, 158, 62, 141, 296, 450, 342, 246, 70, 479, 191, 373, 472, 384, 27, 107, 200, 109, 246, 363, 250, 282, 272, 208, 83, 447, 5, 199, 505, 210, 488, 334, 261, 292, 184, 155, 144, 64, 373, 155, 206, 403, 253, 246},
  {447, 213, 209, 388, 461, 233, 67, 443, 98, 389, 420, 122, 171, 145, 306, 188, 277, 444, 153, 14, 293, 188, 274, 420, 365, 99, 320, 400, 293, 499, 99, 226, 50, 404, 458, 30, 310, 58, 329, 153, 156, 121, 46, 211, 16, 226, 72, 270, 159, 267, 44, 193, 214, 136, 31, 74, 317, 234, 132, 6, 469, 512, 149, 79, 69, 91, 86, 491, 400, 203, 177, 458, 64, 461, 329, 210, 236, 17, 314, 58, 214, 271, 53, 297, 118, 392, 496, 8, 307, 510, 389, 274, 273, 94, 474, 365, 61, 310, 407, 132},
  {53, 232, 115, 308, 87, 196, 161, 270, 34, 7, 289, 13, 447, 265, 174, 276, 175, 15, 136, 477, 445, 120, 323, 196, 342, 358, 232, 191, 158, 147, 447, 445, 119, 17, 205, 370, 59, 323, 482, 147, 466, 232, 100, 484, 289, 62, 96, 294, 342, 352, 59, 226, 461, 294, 147, 308, 471, 262, 323, 246, 345, 163, 328, 503, 47, 342, 209, 423, 502, 473, 394, 359, 352, 500, 214, 403, 506, 509, 196, 248, 289, 196, 156, 175, 262, 163, 242, 257, 314, 196, 421, 129, 466, 202, 78, 482, 455, 89, 208, 423},
  {354, 70, 318, 454, 190, 116, 482, 195, 421, 123, 198, 15, 267, 278, 18, 67, 59, 436, 170, 190, 81, 116, 421, 478, 58, 254, 442, 254, 400, 159, 134, 231, 198, 383, 478, 280, 198, 421, 231, 234, 179, 134, 389, 12, 442, 381, 216, 478, 32, 177, 282, 436, 436, 46, 436, 195, 224, 2, 383, 155, 240, 381, 204, 442, 213, 421, 221, 213, 299, 192, 144, 58, 246, 474, 35, 383, 448, 269, 234, 134, 279, 478, 299, 369, 501, 295, 365, 59, 312, 288, 124, 28, 383, 165, 110, 134, 36, 487, 25, 119},
  {10, 318, 113, 401, 130, 85, 219, 389, 260, 322, 362, 362, 283, 140, 195, 305, 434, 322, 216, 340, 412, 124, 45, 44, 283, 322, 158, 465, 462, 397, 260, 289, 202, 475, 122, 154, 397, 244, 376, 323, 284, 344, 379, 161, 296, 462, 348, 397, 274, 283, 339, 366, 325, 156, 140, 15, 152, 376, 222, 397, 46, 305, 460, 389, 457, 293, 420, 322, 435, 412, 362, 366, 117, 31, 392, 457, 444, 495, 14, 182, 75, 250, 226, 33, 132, 174, 144, 244, 195, 158, 376, 169, 322, 333, 296, 222, 103, 348, 400, 296},
  {327, 152, 203, 195, 192, 369, 455, 293, 431, 124, 86, 135, 367, 104, 445, 15, 510, 293, 510, 50, 124, 478, 240, 135, 443, 160, 461, 10, 5, 124, 394, 62, 99, 190, 22, 253, 53, 5, 207, 458, 255, 167, 418, 88, 167, 461, 431, 215, 74, 287, 394, 507, 182, 423, 225, 81, 508, 382, 488, 456, 265, 254, 132, 299, 62, 74, 394, 369, 431, 422, 461, 104, 319, 367, 106, 124, 313, 511, 334, 491, 431, 34, 240, 47, 432, 353, 264, 227, 328, 418, 201, 342, 456, 428, 270, 189, 104, 149, 240, 276},
  {231, 172, 41, 9, 358, 440, 140, 347, 250, 359, 196, 269, 294, 164, 214, 124, 419, 421, 492, 418, 347, 342, 102, 433, 161, 242, 355, 456, 342, 359, 468, 290, 133, 228, 304, 299, 309, 370, 319, 297, 370, 395, 212, 346, 294, 218, 347, 62, 370, 337, 250, 172, 430, 5, 359, 63, 199, 460, 250, 76, 155, 144, 421, 269, 477, 304, 508, 400, 294, 172, 406, 83, 466, 115, 77, 121, 267, 46, 58, 99, 440, 281, 63, 449, 323, 70, 408, 121, 395, 270, 396, 76, 196, 305, 269, 250, 430, 396, 158, 57},
  {379, 481, 47, 434, 455, 160, 117, 260, 2, 175, 291, 104, 311, 345, 247, 55, 393, 345, 176, 76, 194, 111, 481, 492, 279, 363, 130, 22, 393, 243, 363, 345, 401, 118, 276, 41, 20, 320, 451, 237, 421, 490, 378, 410, 243, 382, 324, 78, 490, 160, 276, 276, 457, 76, 176, 492, 496, 23, 39, 22, 83, 349, 157, 35, 257, 175, 163, 436, 424, 382, 78, 149, 336, 345, 113, 61, 301, 149, 150, 204, 208, 93, 504, 18, 471, 443, 434, 118, 129, 276, 236, 500, 443, 159, 85, 382, 398, 374, 187, 311},
  {405, 165, 44, 356, 83, 74, 254, 8, 376, 412, 507, 340, 139, 202, 446, 37, 215, 454, 86, 304, 432, 133, 163, 287, 75, 481, 187, 376, 130, 41, 273, 325, 413, 206, 133, 261, 340, 215, 169, 480, 454, 432, 137, 334, 202, 187, 187, 442, 282, 298, 353, 454, 27, 141, 496, 80, 88, 445, 363, 51, 259, 422, 7, 215, 356, 511, 82, 27, 187, 43, 75, 376, 4, 501, 382, 9, 164, 44, 429, 318, 442, 27, 345, 210, 494, 59, 76, 287, 71, 391, 369, 484, 442, 273, 192, 413, 481, 442, 377, 325},
  {64, 430, 432, 128, 304, 372, 245, 224, 418, 113, 305, 224, 189, 148, 171, 392, 451, 276, 54, 259, 308, 113, 99, 11, 96, 265, 256, 296, 110, 45, 334, 28, 110, 315, 99, 307, 417, 418, 170, 1, 462, 148, 422, 110, 272, 202, 492, 392, 148, 148, 127, 372, 223, 118, 188, 223, 510, 359, 54, 372, 137, 155, 40, 320, 272, 417, 144, 159, 465, 256, 491, 478, 187, 96, 89, 173, 139, 36, 461, 265, 30, 418, 113, 468, 17, 148, 451, 373, 170, 351, 229, 395, 485, 462, 37, 304, 492, 30, 378, 148},
  {388, 350, 427, 304, 46, 382, 429, 337, 169, 304, 425, 337, 263, 304, 248, 149, 439, 232, 238, 57, 328, 337, 75, 169, 337, 291, 454, 454, 439, 102, 271, 255, 439, 353, 385, 365, 366, 407, 126, 196, 79, 475, 156, 446, 91, 11, 337, 192, 391, 66, 110, 291, 454, 434, 308, 126, 322, 169, 27, 263, 134, 359, 369, 475, 160, 291, 148, 290, 454, 434, 436, 240, 266, 349, 377, 391, 269, 299, 156, 423, 42, 232, 183, 198, 49, 141, 495, 308, 207, 461, 337, 168, 154, 86, 425, 169, 504, 126, 303, 11},
  {11, 15, 442, 458, 206, 378, 164, 479, 417, 349, 169, 170, 392, 141, 196, 449, 323, 365, 386, 470, 255, 429, 425, 160, 234, 360, 249, 397, 349, 296, 425, 349, 53, 479, 463, 329, 289, 422, 196, 252, 276, 75, 323, 308, 192, 326, 37, 206, 268, 311, 255, 311, 271, 316, 479, 261, 313, 171, 422, 349, 164, 20, 190, 149, 134, 101, 37, 160, 492, 354, 99, 308, 377, 58, 385, 439, 55, 50, 9, 392, 420, 237, 425, 71, 404, 349, 492, 323, 112, 370, 269, 417, 29, 490, 378, 474, 363, 261, 424, 108},
  {188, 60, 259, 420, 145, 265, 484, 234, 435, 273, 136, 446, 354, 240, 245, 48, 174, 483, 80, 499, 259, 145, 232, 150, 152, 339, 298, 284, 174, 261, 136, 174, 369, 158, 429, 89, 245, 96, 220, 201, 192, 136, 167, 213, 264, 136, 307, 446, 405, 106, 185, 308, 136, 39, 267, 151, 385, 333, 145, 78, 325, 324, 317, 265, 198, 163, 452, 354, 441, 174, 136, 198, 220, 255, 203, 174, 275, 420, 437, 300, 384, 494, 104, 194, 156, 111, 179, 315, 83, 174, 259, 163, 267, 397, 406, 132, 458, 163, 449, 138},
  {170, 261, 23, 426, 76, 101, 191, 220, 290, 36, 192, 396, 463, 425, 240, 466, 218, 7, 74, 203, 313, 413, 313, 348, 375, 179, 218, 273, 425, 297, 452, 400, 326, 65, 20, 397, 103, 452, 203, 500, 203, 440, 118, 62, 251, 5, 409, 440, 432, 375, 130, 238, 203, 292, 22, 366, 157, 260, 507, 466, 452, 338, 375, 425, 425, 348, 201, 425, 32, 452, 278, 289, 91, 20, 143, 487, 343, 286, 512, 127, 505, 149, 348, 106, 242, 248, 261, 487, 10, 290, 36, 502, 101, 102, 65, 163, 38, 108, 511, 36},
  {279, 332, 269, 311, 340, 212, 300, 18, 294, 287, 18, 2, 379, 192, 117, 122, 110, 111, 385, 264, 355, 273, 167, 354, 169, 379, 257, 226, 70, 507, 41, 230, 82, 379, 32, 230, 230, 2, 138, 365, 8, 412, 258, 250, 151, 296, 175, 63, 454, 384, 257, 224, 44, 163, 76, 166, 441, 141, 511, 70, 511, 261, 231, 151, 354, 51, 499, 44, 412, 213, 499, 412, 41, 159, 504, 51, 476, 422, 405, 77, 258, 384, 512, 72, 93, 508, 415, 203, 238, 458, 88, 12, 151, 436, 203, 437, 54, 98, 77, 151},
  {152, 413, 117, 297, 251, 129, 301, 168, 415, 385, 235, 443, 400, 337, 185, 241, 225, 337, 412, 220, 65, 86, 337, 30, 304, 76, 261, 495, 443, 170, 453, 168, 35, 507, 185, 177, 462, 400, 382, 247, 356, 433, 361, 105, 330, 7, 68, 322, 501, 281, 61, 121, 30, 135, 473, 62, 388, 391, 359, 399, 264, 480, 307, 47, 94, 105, 185, 115, 467, 356, 168, 60, 221, 147, 265, 507, 80, 176, 497, 105, 105, 366, 304, 467, 96, 390, 47, 264, 400, 495, 170, 185, 419, 447, 7, 400, 235, 304, 327, 218},
  {37, 343, 508, 194, 333, 222, 118, 428, 106, 378, 361, 297, 168, 305, 258, 14, 12, 201, 283, 51, 368, 298, 316, 494, 93, 282, 145, 422, 126, 3, 410, 382, 258, 41, 342, 380, 413, 126, 310, 203, 346, 287, 429, 406, 265, 433, 410, 94, 464, 309, 277, 346, 378, 88, 368, 114, 343, 21, 330, 298, 24, 366, 444, 409, 382, 484, 488, 410, 430, 330, 347, 484, 158, 242, 183, 287, 450, 475, 315, 409, 433, 378, 462, 364, 270, 17, 268, 112, 306, 464, 382, 46, 258, 310, 433, 75, 11, 359, 81, 162},
  {370, 42, 229, 477, 36, 452, 459, 137, 266, 23, 384, 384, 235, 211, 357, 40, 390, 48, 94, 351, 470, 259, 43, 333, 108, 512, 427, 470, 67, 459, 261, 36, 29, 36, 482, 18, 69, 499, 171, 315, 48, 325, 97, 29, 1, 155, 152, 123, 482, 324, 397, 23, 439, 455, 246, 207, 61, 28, 509, 179, 352, 219, 400, 67, 80, 53, 229, 211, 251, 106, 285, 319, 454, 246, 259, 301, 123, 444, 198, 38, 495, 187, 440, 367, 311, 123, 58, 237, 301, 152, 205, 507, 67, 474, 385, 171, 444, 301, 165, 23},
  {52, 361, 97, 218, 373, 427, 127, 119, 444, 98, 203, 121, 427, 445, 475, 267, 259, 61, 120, 202, 334, 361, 445, 482, 450, 394, 180, 180, 306, 36, 336, 118, 349, 293, 108, 444, 311, 197, 322, 278, 427, 94, 197, 214, 148, 217, 18, 427, 197, 464, 129, 306, 429, 240, 279, 16, 378, 427, 56, 94, 222, 421, 187, 388, 284, 97, 123, 220, 138, 110, 163, 499, 420, 401, 142, 16, 24, 406, 254, 129, 217, 444, 341, 460, 84, 366, 42, 89, 453, 450, 489, 43, 97, 15, 311, 18, 427, 213, 2, 115},
  {225, 512, 65, 509, 228, 390, 93, 218, 457, 159, 240, 304, 445, 480, 311, 307, 123, 410, 129, 34, 179, 105, 307, 230, 113, 491, 436, 218, 509, 320, 141, 11, 308, 180, 69, 214, 38, 436, 218, 467, 173, 250, 96, 39, 344, 390, 116, 50, 173, 320, 180, 113, 17, 433, 378, 204, 397, 213, 342, 266, 17, 175, 2, 480, 436, 436, 22, 38, 116, 445, 360, 312, 299, 165, 509, 436, 414, 387, 96, 173, 11, 59, 320, 435, 428, 256, 443, 123, 104, 105, 72, 330, 390, 238, 457, 204, 84, 436, 439, 113},
  {392, 207, 180, 478, 85, 81, 340, 186, 49, 501, 381, 289, 162, 221, 472, 152, 286, 344, 73, 209, 266, 168, 250, 122, 286, 501, 262, 487, 429, 431, 416, 162, 2, 268, 38, 34, 132, 8, 132, 3, 312, 77, 30, 414, 221, 501, 3, 509, 150, 286, 167, 221, 344, 270, 28, 167, 5, 124, 64, 510, 73, 66, 107, 261, 372, 104, 119, 40, 350, 338, 244, 389, 364, 286, 189, 481, 350, 43, 139, 250, 122, 509, 38, 68, 496, 167, 498, 81, 15, 504, 183, 206, 110, 289, 117, 429, 465, 69, 59, 97},
  {61, 101, 290, 182, 365, 12, 330, 390, 176, 500, 109, 117, 13, 252, 464, 126, 306, 235, 481, 360, 441, 126, 95, 166, 61, 211, 497, 390, 415, 415, 348, 357, 450, 136, 24, 136, 235, 390, 85, 280, 355, 252, 355, 117, 377, 252, 275, 20, 182, 270, 327, 404, 259, 33, 85, 235, 338, 509, 189, 235, 156, 121, 225, 390, 464, 308, 202, 377, 136, 404, 223, 415, 365, 483, 219, 70, 212, 470, 478, 215, 390, 404, 464, 123, 97, 481, 287, 418, 327, 478, 429, 391, 391, 42, 60, 377, 487, 411, 411, 450},
  {102, 201, 181, 58, 239, 84, 449, 138, 133, 144, 353, 152, 105, 336, 332, 388, 432, 1, 512, 163, 323, 454, 248, 105, 54, 487, 301, 93, 69, 443, 189, 105, 229, 342, 27, 145, 388, 454, 205, 450, 487, 367, 153, 477, 421, 425, 398, 276, 398, 359, 359, 9, 125, 147, 501, 159, 340, 45, 479, 10, 372, 491, 356, 210, 318, 394, 5, 171, 427, 315, 152, 11, 480, 42, 332, 222, 501, 179, 40, 391, 487, 512, 469, 324, 10, 157, 189, 157, 427, 359, 39, 443, 171, 205, 116, 336, 469, 44, 507, 27},
  {22, 317, 102, 489, 4, 179, 183, 14, 281, 292, 259, 238, 19, 289, 109, 384, 85, 127, 305, 124, 33, 459, 375, 232, 270, 361, 194, 195, 334, 410, 483, 95, 104, 418, 415, 118, 144, 282, 232, 300, 459, 144, 166, 181, 134, 401, 144, 174, 374, 153, 500, 104, 245, 308, 179, 326, 438, 418, 409, 204, 363, 67, 276, 466, 418, 116, 509, 224, 8, 241, 195, 179, 488, 238, 176, 254, 483, 152, 281, 144, 270, 231, 238, 50, 480, 32, 15, 245, 289, 72, 254, 495, 363, 234, 449, 85, 282, 289, 494, 436},
  {45, 485, 495, 226, 360, 79, 188, 485, 239, 406, 158, 99, 295, 135, 93, 426, 298, 239, 152, 431, 104, 321, 389, 459, 92, 135, 135, 31, 9, 1, 501, 94, 135, 350, 445, 273, 394, 391, 447, 429, 56, 158, 408, 184, 214, 135, 278, 250, 449, 48, 77, 280, 171, 304, 510, 14, 444, 280, 268, 445, 407, 62, 106, 481, 171, 156, 380, 31, 445, 115, 171, 382, 168, 488, 96, 241, 112, 392, 79, 26, 409, 459, 455, 475, 461, 397, 247, 10, 158, 115, 352, 35, 488, 27, 225, 199, 79, 158, 454, 92},
  {396, 397, 211, 46, 71, 324, 222, 36, 328, 463, 175, 208, 106, 268, 439, 256, 108, 18, 18, 467, 256, 130, 122, 89, 242, 18, 477, 484, 477, 112, 281, 307, 121, 335, 408, 13, 67, 89, 194, 149, 307, 200, 54, 44, 133, 484, 103, 484, 158, 122, 268, 242, 273, 188, 67, 268, 369, 467, 417, 324, 28, 82, 417, 181, 89, 408, 474, 208, 169, 437, 95, 463, 484, 157, 129, 60, 131, 216, 126, 365, 163, 208, 185, 380, 403, 224, 490, 158, 495, 185, 383, 396, 175, 278, 495, 2, 26, 438, 42, 91},
  {9, 231, 438, 276, 69, 466, 371, 491, 195, 370, 462, 440, 507, 296, 338, 459, 491, 370, 102, 33, 3, 466, 56, 440, 205, 466, 259, 370, 288, 61, 346, 278, 499, 50, 344, 164, 321, 265, 106, 63, 239, 50, 392, 344, 208, 319, 128, 265, 109, 288, 370, 302, 73, 139, 61, 332, 452, 304, 160, 208, 248, 344, 147, 277, 50, 73, 361, 370, 265, 33, 122, 138, 482, 154, 296, 56, 499, 7, 459, 385, 151, 1, 417, 479, 407, 414, 14, 278, 231, 73, 220, 462, 79, 381, 393, 160, 125, 296, 30, 159},
  {192, 246, 187, 271, 207, 220, 298, 184, 483, 371, 252, 505, 66, 220, 330, 417, 200, 114, 46, 82, 171, 5, 93, 133, 232, 411, 48, 477, 252, 371, 505, 483, 336, 252, 372, 53, 411, 310, 263, 111, 372, 397, 142, 123, 477, 311, 378, 200, 505, 258, 105, 93, 49, 130, 92, 165, 133, 439, 274, 66, 245, 320, 274, 158, 203, 274, 265, 11, 337, 311, 425, 30, 500, 30, 193, 82, 175, 339, 289, 444, 322, 287, 84, 160, 332, 337, 190, 114, 135, 30, 244, 287, 158, 419, 75, 312, 302, 135, 200, 5},
  {424, 387, 379, 207, 117, 218, 240, 281, 430, 423, 218, 233, 345, 76, 283, 218, 146, 110, 482, 456, 66, 398, 321, 53, 47, 263, 74, 239, 284, 283, 93, 258, 311, 39, 345, 427, 370, 446, 281, 338, 281, 500, 91, 457, 120, 36, 155, 169, 316, 439, 74, 500, 370, 404, 23, 367, 65, 343, 23, 388, 504, 201, 119, 370, 120, 476, 310, 281, 185, 468, 464, 430, 476, 496, 128, 294, 187, 461, 386, 24, 39, 181, 500, 262, 126, 20, 284, 465, 120, 260, 211, 91, 311, 281, 193, 476, 299, 267, 169, 146},
  {489, 407, 134, 168, 253, 269, 202, 34, 473, 512, 127, 165, 408, 446, 381, 147, 287, 178, 372, 282, 39, 351, 61, 392, 426, 147, 244, 445, 309, 28, 445, 276, 329, 269, 61, 242, 91, 389, 152, 88, 319, 392, 359, 1, 237, 497, 39, 377, 271, 329, 226, 6, 200, 511, 408, 147, 8, 13, 71, 271, 488, 43, 418, 28, 488, 237, 79, 485, 392, 104, 489, 302, 143, 341, 145, 14, 351, 52, 351, 165, 341, 220, 82, 287, 362, 100, 96, 174, 473, 48, 163, 119, 505, 271, 71, 144, 410, 197, 260, 122},
  {499, 499, 385, 384, 344, 247, 76, 132, 459, 40, 172, 459, 40, 384, 304, 139, 130, 449, 148, 46, 191, 468, 182, 276, 289, 412, 359, 2, 206, 384, 238, 362, 417, 384, 77, 461, 84, 362, 317, 159, 266, 358, 207, 129, 276, 441, 236, 156, 45, 443, 72, 478, 20, 354, 429, 149, 228, 6, 72, 412, 378, 441, 436, 103, 276, 483, 330, 236, 186, 158, 417, 218, 334, 387, 271, 459, 355, 51, 235, 375, 115, 437, 4, 92, 26, 201, 180, 313, 359, 441, 45, 436, 304, 390, 332, 470, 384, 222, 428, 263},
  {252, 85, 380, 379, 422, 352, 396, 101, 306, 437, 380, 1, 329, 15, 188, 329, 217, 275, 275, 465, 9, 439, 418, 390, 421, 276, 220, 329, 167, 352, 446, 390, 254, 9, 301, 405, 21, 272, 321, 140, 418, 352, 493, 157, 220, 464, 464, 380, 102, 390, 244, 418, 100, 356, 167, 417, 12, 456, 155, 100, 306, 484, 360, 301, 102, 32, 503, 418, 289, 157, 390, 146, 146, 102, 499, 320, 479, 218, 187, 220, 223, 61, 329, 507, 281, 113, 367, 446, 356, 81, 9, 188, 320, 345, 418, 421, 195, 512, 406, 315},
  {326, 326, 366, 48, 311, 261, 73, 438, 19, 294, 276, 174, 59, 406, 24, 369, 504, 406, 415, 462, 350, 93, 29, 183, 240, 350, 435, 360, 103, 350, 84, 488, 304, 194, 403, 112, 174, 145, 261, 54, 503, 207, 184, 115, 449, 195, 55, 240, 75, 325, 93, 438, 129, 268, 329, 438, 77, 406, 202, 135, 89, 278, 439, 435, 202, 12, 434, 311, 360, 183, 207, 194, 163, 415, 42, 207, 369, 340, 371, 29, 287, 19, 194, 184, 489, 126, 328, 488, 272, 166, 103, 456, 230, 17, 384, 174, 44, 29, 223, 133},
  {27, 489, 130, 319, 240, 65, 394, 338, 63, 390, 140, 74, 351, 189, 292, 281, 147, 74, 265, 505, 245, 176, 258, 421, 457, 134, 258, 182, 100, 351, 158, 343, 147, 245, 411, 52, 479, 100, 502, 182, 390, 350, 295, 172, 245, 74, 502, 65, 245, 292, 202, 390, 134, 61, 134, 88, 390, 284, 361, 74, 168, 44, 182, 140, 158, 398, 244, 134, 194, 246, 88, 35, 152, 122, 159, 366, 320, 337, 339, 224, 277, 176, 32, 43, 266, 180, 376, 453, 378, 147, 290, 378, 421, 384, 479, 398, 506, 474, 195, 318},
  {494, 226, 371, 122, 141, 344, 510, 182, 389, 148, 330, 368, 258, 219, 282, 443, 474, 186, 343, 353, 130, 231, 87, 330, 174, 159, 303, 314, 330, 363, 11, 470, 11, 422, 278, 459, 368, 87, 352, 374, 148, 329, 85, 427, 141, 460, 368, 159, 219, 474, 436, 320, 368, 385, 238, 392, 160, 416, 205, 294, 242, 51, 264, 250, 159, 78, 231, 291, 263, 461, 186, 151, 17, 6, 293, 45, 30, 353, 428, 92, 392, 470, 59, 329, 446, 472, 384, 434, 329, 509, 365, 238, 238, 395, 330, 344, 148, 59, 163, 186},
  {137, 72, 280, 102, 156, 456, 217, 416, 371, 398, 91, 182, 312, 114, 126, 345, 448, 64, 479, 118, 58, 32, 58, 414, 70, 146, 225, 30, 498, 342, 342, 91, 9, 44, 330, 414, 342, 312, 70, 19, 407, 293, 227, 269, 273, 70, 498, 503, 58, 398, 9, 342, 64, 445, 220, 113, 342, 215, 471, 448, 55, 86, 138, 94, 508, 405, 155, 55, 9, 20, 187, 108, 407, 398, 469, 398, 108, 189, 173, 312, 64, 91, 274, 396, 153, 249, 355, 99, 3, 414, 118, 329, 272, 452, 489, 118, 508, 489, 144, 356},
  {501, 328, 312, 370, 507, 270, 470, 76, 26, 237, 160, 214, 194, 493, 437, 404, 194, 384, 382, 207, 61, 155, 6, 339, 65, 82, 160, 489, 490, 284, 249, 339, 313, 347, 347, 155, 247, 205, 270, 84, 437, 362, 269, 103, 338, 284, 452, 489, 225, 26, 155, 501, 160, 500, 130, 6, 198, 273, 397, 130, 339, 485, 79, 138, 44, 371, 501, 254, 254, 160, 323, 201, 273, 53, 276, 234, 387, 490, 322, 138, 371, 155, 437, 319, 442, 376, 226, 130, 490, 446, 313, 44, 170, 455, 496, 178, 254, 205, 510, 409},
  {249, 305, 233, 328, 126, 366, 172, 5, 157, 66, 225, 221, 471, 413, 121, 6, 413, 140, 395, 53, 437, 173, 396, 145, 157, 175, 333, 437, 123, 135, 489, 394, 123, 510, 300, 409, 438, 250, 333, 366, 145, 135, 82, 206, 416, 429, 194, 75, 499, 113, 195, 127, 59, 282, 160, 510, 1, 100, 6, 52, 143, 348, 462, 394, 250, 171, 1, 284, 247, 173, 38, 178, 394, 279, 262, 145, 326, 324, 367, 100, 10, 94, 438, 377, 56, 203, 494, 100, 270, 66, 279, 160, 446, 300, 210, 240, 408, 416, 501, 307},
  {73, 230, 330, 493, 40, 463, 123, 418, 428, 146, 481, 156, 112, 453, 399, 500, 305, 215, 463, 25, 482, 365, 177, 295, 273, 225, 146, 265, 192, 493, 305, 215, 442, 215, 500, 337, 336, 109, 265, 11, 250, 273, 106, 6, 8, 262, 98, 216, 396, 221, 383, 43, 177, 253, 383, 20, 504, 291, 329, 344, 203, 446, 308, 56, 95, 399, 360, 95, 494, 325, 133, 109, 82, 399, 19, 20, 432, 440, 378, 164, 109, 133, 365, 183, 503, 440, 26, 499, 225, 221, 336, 399, 510, 109, 28, 292, 350, 55, 17, 336},
  {47, 162, 349, 60, 414, 19, 447, 106, 154, 460, 374, 133, 374, 191, 264, 166, 399, 26, 27, 283, 238, 316, 238, 309, 259, 374, 368, 316, 434, 506, 61, 87, 425, 434, 442, 460, 168, 337, 79, 302, 225, 168, 356, 30, 282, 287, 50, 130, 241, 332, 494, 460, 367, 269, 244, 399, 247, 168, 314, 114, 332, 200, 291, 50, 511, 337, 399, 414, 154, 264, 300, 189, 115, 228, 107, 191, 28, 499, 336, 348, 346, 168, 225, 131, 234, 421, 360, 380, 280, 242, 348, 244, 411, 454, 422, 72, 343, 243, 348, 367},
  {337, 71, 157, 199, 13, 149, 212, 297, 29, 83, 65, 482, 346, 83, 388, 433, 346, 418, 397, 428, 103, 29, 160, 434, 482, 186, 491, 373, 129, 70, 83, 75, 457, 362, 136, 250, 186, 491, 105, 13, 362, 103, 245, 135, 230, 22, 59, 411, 418, 186, 406, 176, 426, 133, 186, 220, 53, 387, 465, 503, 220, 204, 51, 434, 15, 29, 263, 337, 47, 65, 281, 157, 415, 328, 46, 470, 376, 486, 249, 261, 380, 305, 272, 164, 467, 39, 391, 186, 244, 186, 459, 261, 482, 261, 30, 29, 220, 328, 422, 75},
  {207, 144, 266, 408, 163, 342, 337, 20, 315, 325, 20, 410, 505, 295, 209, 371, 374, 106, 209, 330, 477, 241, 332, 410, 170, 295, 342, 342, 374, 257, 458, 439, 376, 172, 357, 255, 385, 32, 334, 410, 315, 375, 432, 511, 270, 321, 281, 85, 410, 129, 342, 376, 270, 200, 216, 140, 235, 51, 123, 274, 260, 224, 220, 386, 241, 404, 113, 312, 385, 350, 172, 410, 184, 62, 216, 81, 181, 380, 294, 14, 312, 326, 140, 203, 504, 384, 132, 312, 354, 298, 274, 321, 281, 477, 410, 32, 404, 321, 334, 32},
  {82, 39, 208, 329, 372, 501, 248, 330, 224, 343, 244, 166, 166, 181, 4, 20, 473, 168, 142, 261, 321, 254, 114, 170, 349, 198, 202, 137, 453, 49, 191, 191, 454, 59, 59, 379, 398, 91, 302, 143, 83, 431, 303, 25, 20, 53, 342, 295, 295, 145, 254, 75, 482, 111, 321, 275, 41, 1, 485, 128, 109, 33, 30, 137, 59, 230, 295, 202, 339, 496, 497, 155, 333, 145, 448, 224, 47, 481, 359, 410, 234, 191, 170, 120, 249, 88, 149, 16, 64, 254, 127, 190, 59, 23, 502, 370, 204, 88, 191, 244},
  {289, 334, 11, 418, 392, 430, 282, 123, 288, 499, 156, 97, 415, 476, 207, 452, 61, 146, 304, 280, 125, 156, 369, 369, 437, 317, 16, 256, 391, 7, 51, 144, 387, 76, 499, 424, 248, 371, 399, 444, 449, 387, 275, 413, 431, 133, 476, 366, 277, 218, 298, 81, 194, 321, 114, 170, 477, 184, 304, 146, 217, 218, 77, 146, 366, 21, 437, 506, 196, 277, 376, 62, 491, 170, 346, 344, 10, 130, 102, 110, 476, 430, 87, 236, 473, 104, 259, 448, 110, 193, 431, 256, 317, 463, 21, 277, 72, 218, 196, 69},
  {435, 394, 176, 352, 109, 401, 20, 160, 93, 238, 455, 277, 58, 171, 34, 323, 260, 498, 26, 439, 284, 264, 137, 82, 489, 424, 323, 47, 399, 277, 511, 495, 322, 354, 121, 325, 95, 274, 408, 475, 424, 48, 223, 216, 408, 89, 436, 22, 89, 95, 354, 137, 23, 341, 93, 253, 400, 317, 228, 137, 419, 57, 511, 307, 367, 213, 195, 137, 379, 221, 354, 253, 123, 56, 254, 22, 154, 345, 212, 274, 69, 367, 399, 263, 137, 331, 193, 430, 274, 98, 305, 121, 373, 421, 408, 111, 268, 455, 164, 285},
  {272, 170, 398, 228, 402, 346, 106, 46, 497, 29, 479, 265, 352, 67, 413, 346, 56, 5, 19, 469, 127, 289, 385, 234, 472, 148, 30, 37, 37, 53, 165, 308, 350, 134, 234, 234, 400, 236, 269, 61, 471, 451, 58, 5, 400, 234, 209, 289, 308, 246, 217, 114, 210, 372, 56, 246, 394, 226, 183, 308, 113, 122, 228, 512, 443, 387, 75, 269, 318, 294, 477, 13, 300, 447, 264, 400, 437, 113, 416, 2, 404, 376, 443, 177, 438, 409, 171, 195, 201, 272, 342, 148, 66, 201, 497, 230, 387, 16, 125, 413},
  {333, 63, 474, 142, 101, 182, 141, 468, 225, 218, 402, 312, 14, 334, 41, 182, 378, 84, 37, 424, 478, 281, 273, 502, 401, 241, 314, 126, 297, 252, 481, 63, 32, 31, 334, 263, 421, 297, 449, 238, 241, 424, 437, 378, 402, 237, 5, 471, 443, 56, 352, 451, 212, 128, 300, 41, 462, 447, 3, 402, 489, 501, 309, 401, 161, 89, 396, 145, 140, 225, 471, 24, 271, 52, 85, 499, 429, 204, 154, 145, 471, 244, 263, 462, 33, 263, 322, 107, 256, 451, 167, 300, 449, 209, 77, 63, 107, 366, 346, 291},
  {336, 322, 213, 334, 56, 341, 395, 437, 372, 198, 296, 372, 9, 199, 387, 30, 172, 328, 11, 116, 48, 275, 199, 497, 223, 398, 60, 106, 65, 468, 495, 296, 330, 296, 241, 289, 114, 118, 462, 158, 398, 172, 226, 396, 60, 437, 30, 21, 468, 164, 179, 138, 295, 225, 9, 437, 497, 404, 414, 103, 21, 497, 278, 275, 263, 505, 176, 190, 198, 9, 198, 103, 130, 60, 62, 501, 196, 49, 178, 118, 219, 398, 150, 235, 370, 192, 43, 341, 277, 172, 372, 368, 9, 299, 198, 273, 368, 116, 311, 14},
  {284, 466, 201, 151, 478, 435, 35, 237, 499, 380, 358, 487, 487, 94, 157, 397, 44, 12, 259, 154, 18, 228, 300, 456, 380, 373, 424, 83, 483, 275, 193, 197, 74, 124, 390, 140, 506, 315, 397, 266, 97, 4, 385, 390, 94, 97, 44, 506, 64, 143, 143, 506, 83, 170, 198, 397, 311, 237, 433, 321, 390, 449, 243, 373, 476, 5, 273, 198, 397, 40, 510, 230, 405, 143, 328, 89, 442, 372, 325, 112, 113, 346, 318, 152, 373, 191, 67, 503, 44, 324, 159, 97, 318, 207, 476, 152, 219, 145, 149, 424},
  {358, 204, 497, 445, 49, 418, 461, 249, 132, 41, 64, 198, 55, 498, 358, 98, 89, 510, 315, 52, 371, 276, 358, 388, 41, 388, 216, 276, 27, 27, 9, 456, 495, 183, 324, 94, 494, 328, 88, 427, 485, 456, 134, 186, 98, 445, 10, 24, 152, 187, 301, 401, 304, 403, 157, 328, 409, 321, 371, 409, 129, 138, 505, 371, 55, 301, 161, 155, 163, 230, 456, 494, 119, 216, 28, 27, 406, 122, 11, 108, 334, 157, 98, 38, 12, 268, 4, 252, 106, 328, 152, 341, 301, 511, 371, 157, 214, 212, 186, 239},
  {65, 450, 362, 76, 84, 268, 189, 153, 296, 396, 300, 508, 300, 149, 120, 296, 342, 242, 302, 491, 354, 483, 468, 136, 441, 285, 353, 485, 433, 268, 92, 434, 81, 139, 179, 71, 35, 11, 372, 499, 482, 81, 189, 26, 354, 44, 266, 354, 99, 250, 308, 80, 81, 79, 353, 136, 386, 443, 326, 136, 205, 478, 240, 372, 99, 357, 285, 46, 200, 466, 318, 296, 262, 441, 437, 91, 95, 307, 509, 161, 412, 18, 482, 62, 198, 274, 385, 342, 357, 148, 223, 52, 15, 378, 318, 318, 223, 483, 412, 110},
  {425, 455, 200, 443, 429, 506, 426, 199, 286, 256, 29, 295, 152, 228, 504, 174, 196, 54, 65, 386, 492, 431, 117, 93, 429, 136, 467, 257, 228, 414, 436, 19, 436, 152, 506, 91, 19, 474, 381, 512, 138, 295, 440, 364, 117, 289, 485, 168, 161, 181, 228, 208, 54, 324, 296, 90, 112, 92, 216, 387, 276, 238, 181, 467, 414, 485, 74, 136, 474, 152, 345, 341, 212, 119, 245, 276, 308, 127, 98, 48, 425, 10, 199, 494, 117, 387, 427, 507, 188, 228, 321, 21, 358, 229, 218, 21, 478, 54, 34, 48},
  {316, 439, 286, 367, 174, 157, 363, 292, 31, 61, 346, 48, 159, 512, 440, 73, 51, 417, 449, 426, 369, 106, 145, 307, 185, 402, 462, 89, 39, 51, 272, 136, 106, 331, 389, 456, 281, 402, 476, 23, 369, 314, 71, 286, 369, 292, 510, 46, 275, 189, 387, 389, 46, 201, 51, 79, 300, 179, 292, 307, 153, 431, 139, 171, 237, 197, 180, 112, 139, 137, 224, 470, 195, 38, 32, 476, 449, 165, 22, 432, 389, 51, 46, 355, 406, 282, 278, 162, 463, 508, 308, 305, 310, 152, 229, 90, 227, 510, 112, 369},
  {30, 269, 472, 34, 444, 181, 271, 51, 14, 133, 147, 334, 247, 455, 108, 347, 351, 71, 90, 297, 32, 166, 259, 139, 17, 338, 430, 151, 149, 247, 7, 193, 17, 419, 193, 109, 32, 487, 409, 30, 120, 493, 176, 226, 309, 295, 193, 460, 16, 383, 493, 299, 16, 285, 457, 468, 319, 356, 58, 118, 409, 195, 277, 493, 39, 75, 378, 383, 338, 217, 111, 338, 76, 383, 217, 180, 110, 312, 65, 394, 309, 115, 151, 484, 401, 408, 258, 500, 484, 108, 230, 67, 455, 322, 139, 383, 347, 119, 394, 419},
  {480, 298, 182, 241, 51, 274, 128, 159, 395, 188, 106, 423, 124, 143, 507, 158, 293, 241, 225, 188, 28, 434, 112, 277, 338, 238, 277, 319, 250, 501, 431, 124, 255, 193, 215, 354, 427, 143, 293, 425, 201, 234, 434, 274, 277, 19, 434, 203, 172, 512, 395, 465, 358, 328, 476, 359, 145, 274, 484, 158, 311, 342, 414, 89, 404, 20, 32, 447, 195, 255, 338, 315, 325, 39, 116, 404, 425, 396, 435, 277, 116, 255, 359, 294, 197, 98, 483, 53, 476, 215, 440, 420, 277, 169, 112, 356, 88, 215, 293, 359},
  {28, 276, 145, 146, 222, 416, 88, 503, 201, 361, 11, 315, 395, 245, 485, 264, 264, 229, 321, 157, 435, 366, 211, 474, 447, 85, 45, 42, 164, 295, 148, 486, 435, 207, 145, 428, 315, 76, 485, 177, 229, 36, 217, 392, 485, 265, 42, 124, 264, 277, 411, 318, 167, 467, 315, 17, 423, 72, 264, 164, 447, 193, 211, 167, 17, 48, 395, 80, 36, 116, 6, 214, 413, 295, 80, 142, 135, 121, 474, 17, 23, 295, 463, 447, 487, 213, 349, 447, 85, 474, 503, 411, 251, 142, 430, 272, 295, 300, 375, 142},
  {134, 263, 422, 4, 12, 422, 412, 301, 61, 104, 290, 419, 99, 381, 289, 64, 475, 435, 135, 489, 67, 465, 175, 316, 323, 495, 437, 146, 346, 110, 216, 302, 422, 148, 13, 479, 354, 269, 212, 241, 61, 254, 445, 358, 495, 452, 290, 419, 13, 339, 427, 183, 421, 68, 110, 146, 273, 29, 354, 508, 98, 22, 247, 19, 194, 146, 450, 199, 232, 482, 179, 465, 147, 35, 39, 323, 122, 472, 273, 104, 437, 357, 457, 316, 42, 110, 199, 357, 337, 43, 146, 337, 397, 362, 249, 136, 271, 479, 29, 326},
  {290, 306, 281, 113, 419, 412, 375, 392, 65, 453, 151, 139, 475, 116, 333, 400, 449, 416, 357, 320, 453, 238, 32, 32, 423, 131, 108, 78, 203, 106, 48, 217, 416, 283, 256, 481, 201, 449, 98, 377, 428, 98, 364, 253, 106, 251, 100, 500, 428, 388, 306, 29, 315, 245, 152, 131, 299, 324, 70, 221, 315, 279, 494, 457, 125, 106, 124, 271, 286, 302, 7, 434, 361, 139, 165, 32, 51, 116, 194, 39, 8, 252, 71, 264, 302, 58, 489, 80, 286, 146, 449, 438, 178, 363, 108, 254, 416, 229, 213, 471},
  {115, 219, 306, 377, 29, 57, 243, 331, 390, 209, 72, 403, 292, 506, 452, 283, 142, 506, 96, 172, 452, 181, 8, 267, 175, 173, 142, 331, 38, 338, 94, 99, 173, 460, 489, 143, 8, 377, 268, 477, 506, 165, 199, 437, 465, 216, 408, 308, 101, 429, 249, 267, 28, 176, 86, 181, 402, 361, 311, 400, 322, 377, 46, 57, 103, 377, 46, 412, 347, 370, 293, 263, 277, 220, 188, 408, 262, 260, 361, 297, 142, 29, 343, 75, 499, 83, 286, 338, 102, 249, 302, 249, 173, 104, 429, 38, 41, 133, 495, 8},
  {452, 206, 436, 81, 28, 93, 304, 341, 491, 54, 341, 86, 499, 263, 303, 203, 410, 113, 491, 245, 300, 123, 98, 113, 491, 470, 12, 104, 179, 47, 470, 246, 97, 184, 203, 54, 300, 451, 135, 73, 329, 236, 140, 287, 250, 286, 66, 227, 184, 465, 113, 184, 320, 493, 263, 18, 306, 408, 227, 159, 492, 80, 250, 477, 20, 303, 154, 87, 152, 168, 159, 363, 161, 477, 146, 123, 96, 402, 64, 86, 303, 152, 91, 384, 433, 316, 135, 104, 246, 369, 113, 30, 93, 355, 477, 502, 264, 184, 453, 510},
  {342, 327, 319, 147, 19, 155, 398, 493, 456, 309, 95, 132, 18, 400, 467, 385, 109, 236, 379, 125, 397, 69, 306, 343, 6, 210, 493, 245, 6, 126, 354, 132, 95, 322, 95, 322, 259, 385, 342, 506, 497, 211, 395, 150, 262, 371, 462, 268, 114, 111, 322, 498, 442, 431, 400, 322, 151, 118, 164, 353, 412, 149, 41, 283, 54, 185, 484, 299, 10, 417, 94, 114, 11, 456, 417, 95, 434, 137, 71, 467, 137, 371, 301, 440, 418, 226, 380, 333, 1, 456, 394, 381, 260, 417, 467, 173, 100, 155, 90, 309},
  {301, 374, 449, 203, 509, 267, 9, 193, 394, 267, 165, 267, 472, 456, 494, 292, 263, 76, 178, 160, 44, 193, 494, 292, 158, 193, 512, 176, 279, 369, 369, 232, 327, 247, 19, 252, 312, 19, 19, 101, 165, 238, 185, 316, 224, 446, 286, 106, 121, 140, 146, 82, 227, 390, 236, 171, 13, 491, 480, 292, 446, 185, 446, 469, 214, 456, 405, 89, 369, 470, 214, 34, 218, 155, 187, 214, 338, 60, 183, 472, 155, 339, 405, 271, 498, 79, 487, 472, 190, 2, 485, 292, 17, 267, 100, 17, 262, 246, 269, 152},
  {105, 3, 79, 111, 324, 135, 336, 128, 365, 291, 167, 499, 155, 167, 391, 181, 348, 346, 204, 165, 135, 178, 64, 178, 257, 260, 167, 69, 282, 44, 155, 155, 141, 64, 281, 45, 292, 132, 328, 127, 309, 93, 398, 329, 5, 178, 314, 29, 10, 487, 264, 210, 346, 143, 154, 300, 164, 78, 167, 23, 295, 34, 19, 309, 23, 298, 212, 278, 401, 155, 8, 40, 110, 167, 404, 155, 496, 348, 238, 183, 198, 198, 149, 137, 101, 297, 206, 178, 198, 57, 135, 178, 253, 179, 309, 110, 191, 282, 342, 155},
  {361, 61, 111, 438, 343, 431, 244, 496, 434, 284, 375, 244, 387, 237, 39, 105, 238, 105, 478, 376, 291, 187, 420, 141, 324, 55, 55, 430, 363, 144, 420, 111, 23, 496, 6, 496, 363, 302, 76, 81, 375, 83, 477, 416, 244, 106, 173, 242, 216, 340, 363, 343, 406, 439, 109, 177, 166, 286, 106, 237, 9, 447, 60, 308, 434, 401, 349, 309, 336, 138, 196, 74, 440, 130, 373, 127, 504, 75, 53, 57, 510, 460, 146, 108, 5, 285, 357, 164, 242, 177, 156, 253, 465, 284, 271, 503, 461, 340, 265, 9},
  {194, 279, 433, 430, 16, 468, 136, 288, 167, 189, 51, 278, 118, 364, 72, 114, 30, 96, 332, 137, 360, 41, 78, 422, 7, 417, 215, 277, 32, 74, 10, 58, 287, 417, 355, 212, 476, 214, 378, 49, 364, 459, 231, 379, 484, 476, 41, 497, 26, 452, 109, 399, 463, 146, 170, 421, 178, 500, 124, 417, 56, 433, 57, 147, 303, 166, 381, 421, 214, 109, 26, 134, 94, 63, 98, 84, 207, 480, 165, 84, 292, 226, 334, 162, 65, 451, 240, 328, 288, 41, 476, 246, 387, 191, 389, 7, 510, 437, 246, 303},
  {286, 110, 477, 167, 173, 69, 382, 185, 24, 115, 81, 469, 96, 358, 81, 144, 452, 402, 300, 166, 268, 23, 216, 216, 38, 382, 502, 300, 503, 447, 104, 222, 469, 284, 338, 220, 322, 469, 213, 317, 38, 243, 404, 448, 6, 268, 183, 61, 431, 333, 69, 493, 126, 394, 382, 318, 254, 26, 33, 132, 162, 380, 347, 115, 6, 194, 146, 268, 189, 126, 447, 61, 373, 325, 108, 79, 113, 310, 233, 88, 364, 126, 503, 136, 423, 438, 235, 197, 115, 233, 287, 233, 423, 444, 382, 257, 37, 38, 75, 322},
  {190, 300, 435, 469, 230, 124, 101, 399, 161, 150, 246, 105, 399, 360, 164, 150, 163, 67, 132, 437, 40, 334, 21, 471, 470, 471, 438, 507, 196, 321, 219, 508, 294, 495, 89, 76, 54, 86, 305, 327, 279, 253, 369, 338, 418, 465, 332, 218, 438, 259, 471, 22, 334, 389, 418, 92, 47, 465, 73, 151, 458, 147, 232, 124, 438, 470, 28, 58, 500, 441, 334, 185, 349, 382, 132, 315, 294, 25, 357, 399, 185, 446, 418, 493, 399, 118, 377, 438, 41, 197, 418, 430, 185, 359, 481, 13, 477, 249, 141, 185},
  {48, 438, 291, 447, 104, 307, 332, 166, 185, 265, 459, 88, 138, 26, 243, 155, 416, 65, 508, 331, 185, 335, 487, 31, 215, 231, 138, 43, 62, 138, 152, 218, 363, 300, 493, 20, 79, 375, 157, 383, 112, 307, 377, 284, 65, 309, 375, 328, 487, 342, 41, 164, 342, 451, 375, 152, 119, 187, 277, 17, 166, 14, 14, 118, 207, 412, 455, 138, 55, 375, 375, 26, 138, 185, 501, 26, 229, 102, 304, 313, 215, 375, 69, 105, 48, 199, 336, 412, 226, 481, 363, 299, 234, 132, 441, 243, 51, 368, 318, 441},
  {36, 346, 42, 403, 435, 290, 115, 245, 27, 26, 211, 106, 61, 462, 407, 11, 486, 217, 160, 392, 462, 290, 26, 436, 281, 453, 58, 411, 305, 462, 319, 189, 344, 58, 48, 411, 407, 71, 10, 325, 174, 261, 488, 142, 396, 343, 38, 379, 259, 358, 26, 48, 152, 82, 185, 372, 465, 267, 407, 113, 430, 198, 129, 142, 83, 305, 152, 483, 150, 453, 319, 48, 134, 407, 424, 489, 152, 83, 127, 483, 150, 496, 270, 200, 506, 506, 46, 217, 128, 305, 142, 259, 62, 67, 105, 26, 217, 48, 298, 473},
  {4, 222, 457, 343, 37, 472, 495, 156, 75, 100, 470, 331, 419, 415, 503, 472, 330, 265, 498, 313, 85, 301, 195, 57, 501, 57, 268, 330, 170, 419, 237, 183, 129, 156, 290, 474, 142, 445, 472, 97, 128, 178, 247, 350, 302, 490, 481, 57, 174, 297, 292, 272, 321, 295, 21, 128, 189, 119, 137, 83, 442, 369, 159, 297, 156, 419, 210, 170, 297, 57, 350, 466, 128, 142, 487, 162, 252, 120, 82, 11, 40, 396, 490, 122, 340, 361, 60, 292, 257, 142, 350, 146, 495, 88, 256, 396, 366, 105, 151, 228},
  {173, 431, 510, 21, 97, 480, 95, 266, 255, 13, 456, 120, 204, 371, 76, 91, 164, 364, 277, 32, 225, 322, 179, 22, 477, 100, 283, 446, 226, 196, 135, 480, 300, 266, 247, 82, 109, 266, 480, 260, 446, 340, 480, 67, 254, 14, 109, 18, 434, 506, 375, 59, 196, 336, 117, 249, 345, 44, 343, 467, 503, 316, 463, 254, 266, 393, 240, 275, 178, 165, 340, 4, 427, 499, 375, 353, 349, 108, 438, 142, 353, 292, 340, 32, 162, 309, 316, 456, 375, 375, 411, 135, 467, 420, 196, 491, 121, 225, 364, 343},
  {41, 99, 106, 234, 284, 89, 241, 306, 53, 435, 227, 287, 304, 467, 139, 265, 66, 353, 356, 195, 128, 211, 453, 382, 384, 42, 380, 11, 304, 29, 287, 384, 384, 104, 435, 3, 42, 361, 435, 186, 161, 188, 248, 204, 29, 350, 23, 66, 469, 397, 403, 128, 11, 265, 166, 42, 223, 82, 29, 53, 1, 487, 464, 211, 211, 319, 348, 176, 199, 485, 353, 202, 37, 306, 266, 277, 268, 16, 485, 287, 355, 138, 507, 353, 451, 346, 246, 106, 241, 477, 11, 485, 106, 256, 194, 380, 89, 176, 352, 466},
  {463, 87, 415, 449, 133, 31, 365, 265, 316, 326, 326, 31, 368, 175, 326, 473, 88, 467, 227, 370, 138, 58, 12, 162, 18, 117, 236, 453, 153, 287, 122, 262, 481, 230, 427, 464, 379, 413, 96, 326, 207, 368, 511, 482, 103, 82, 503, 407, 176, 335, 138, 207, 58, 99, 265, 258, 115, 48, 150, 96, 150, 30, 207, 500, 254, 406, 101, 197, 41, 254, 389, 172, 383, 230, 466, 88, 205, 336, 285, 500, 247, 389, 485, 393, 478, 252, 213, 7, 509, 467, 314, 316, 207, 54, 47, 439, 180, 117, 370, 145},
  {366, 118, 262, 44, 432, 197, 30, 225, 194, 155, 427, 451, 313, 65, 349, 313, 209, 88, 239, 100, 75, 427, 1, 291, 284, 161, 23, 459, 459, 107, 427, 161, 131, 260, 239, 512, 483, 218, 249, 321, 185, 322, 492, 56, 66, 175, 403, 49, 389, 23, 483, 130, 155, 224, 450, 352, 194, 122, 360, 133, 183, 434, 111, 36, 65, 427, 18, 501, 329, 451, 4, 483, 122, 450, 75, 133, 115, 187, 36, 98, 427, 105, 122, 156, 392, 347, 480, 175, 175, 218, 49, 427, 329, 188, 503, 249, 239, 49, 297, 427},
  {507, 486, 12, 35, 202, 354, 285, 208, 387, 449, 486, 427, 15, 399, 124, 70, 251, 308, 289, 148, 317, 359, 382, 73, 408, 73, 441, 324, 364, 303, 376, 283, 66, 84, 250, 101, 446, 283, 167, 307, 447, 24, 482, 388, 271, 478, 143, 208, 190, 199, 66, 58, 398, 8, 344, 330, 457, 424, 447, 73, 451, 73, 81, 315, 37, 324, 490, 303, 190, 478, 263, 335, 99, 231, 6, 303, 137, 382, 430, 356, 301, 296, 246, 101, 53, 231, 225, 250, 116, 44, 84, 84, 395, 89, 493, 296, 63, 172, 52, 102},
  {2, 86, 384, 166, 248, 262, 444, 188, 251, 28, 316, 335, 109, 194, 20, 251, 43, 378, 350, 354, 166, 482, 331, 156, 51, 439, 188, 160, 195, 230, 172, 468, 28, 66, 51, 209, 482, 468, 316, 277, 378, 66, 62, 353, 188, 232, 156, 100, 156, 503, 304, 156, 37, 290, 477, 68, 368, 185, 335, 413, 37, 375, 168, 378, 11, 85, 192, 476, 378, 460, 64, 14, 503, 135, 350, 304, 336, 199, 5, 73, 331, 413, 85, 265, 11, 270, 423, 290, 220, 505, 505, 18, 270, 96, 155, 43, 166, 447, 393, 184},
  {271, 286, 452, 354, 249, 348, 498, 379, 348, 71, 120, 254, 500, 25, 390, 294, 162, 491, 455, 346, 324, 272, 224, 475, 348, 176, 207, 15, 468, 512, 312, 18, 120, 305, 143, 144, 255, 138, 140, 471, 71, 137, 509, 403, 53, 57, 240, 390, 25, 25, 234, 25, 255, 360, 137, 424, 246, 67, 468, 45, 57, 169, 353, 92, 390, 321, 14, 500, 131, 505, 124, 270, 395, 57, 44, 6, 438, 405, 277, 53, 455, 312, 76, 415, 297, 294, 173, 147, 487, 92, 162, 41, 312, 235, 120, 162, 131, 124, 273, 224},
  {433, 184, 1, 246, 466, 239, 103, 383, 113, 169, 268, 229, 355, 106, 321, 503, 75, 355, 434, 495, 192, 452, 416, 397, 344, 400, 299, 344, 99, 169, 503, 61, 402, 204, 456, 189, 211, 355, 113, 104, 45, 465, 496, 86, 458, 477, 301, 261, 132, 86, 432, 301, 380, 7, 424, 75, 240, 65, 13, 434, 349, 295, 496, 61, 416, 234, 397, 477, 99, 503, 31, 226, 87, 61, 446, 106, 259, 71, 312, 262, 416, 431, 163, 257, 64, 402, 308, 231, 18, 204, 486, 180, 99, 430, 163, 185, 507, 45, 26, 13},
  {62, 309, 151, 284, 412, 320, 159, 75, 99, 288, 254, 462, 146, 363, 79, 487, 406, 225, 499, 363, 62, 92, 142, 10, 325, 190, 22, 107, 72, 166, 37, 363, 31, 62, 52, 190, 327, 225, 204, 129, 177, 1, 52, 384, 487, 363, 52, 494, 417, 363, 417, 225, 456, 204, 494, 381, 174, 49, 125, 381, 436, 404, 363, 487, 472, 22, 431, 308, 153, 454, 284, 111, 507, 177, 339, 472, 244, 220, 246, 72, 175, 72, 327, 368, 66, 48, 34, 173, 204, 241, 512, 406, 45, 12, 462, 501, 425, 115, 388, 204},
  {416, 420, 105, 455, 58, 508, 45, 359, 282, 486, 232, 473, 206, 333, 307, 207, 362, 32, 417, 295, 87, 177, 298, 189, 20, 223, 452, 428, 452, 282, 428, 387, 443, 140, 74, 426, 89, 494, 391, 253, 109, 99, 497, 130, 132, 307, 46, 426, 415, 473, 452, 32, 379, 165, 468, 130, 404, 512, 372, 161, 141, 286, 13, 333, 298, 282, 487, 428, 244, 1, 210, 428, 426, 333, 492, 226, 245, 426, 206, 494, 459, 415, 258, 6, 343, 66, 228, 83, 494, 336, 89, 198, 206, 468, 178, 56, 189, 324, 140, 153},
  {55, 203, 326, 42, 260, 199, 512, 175, 337, 116, 495, 464, 291, 380, 274, 291, 151, 81, 351, 197, 51, 262, 435, 81, 89, 183, 451, 435, 269, 411, 12, 337, 418, 337, 150, 238, 381, 382, 36, 502, 422, 299, 322, 245, 155, 247, 336, 317, 162, 223, 346, 74, 418, 302, 299, 346, 375, 197, 374, 12, 269, 54, 82, 244, 348, 423, 470, 380, 450, 374, 81, 3, 360, 381, 29, 337, 206, 88, 50, 136, 4, 423, 323, 114, 338, 450, 44, 115, 118, 323, 175, 336, 226, 491, 452, 226, 184, 336, 110, 273},
  {248, 251, 94, 75, 296, 28, 303, 81, 284, 119, 332, 37, 12, 46, 261, 134, 501, 284, 168, 265, 90, 277, 492, 28, 134, 287, 163, 240, 479, 81, 225, 348, 92, 46, 335, 102, 449, 160, 210, 68, 494, 462, 371, 400, 310, 415, 245, 432, 202, 362, 376, 228, 111, 401, 475, 393, 241, 308, 441, 21, 304, 260, 270, 501, 210, 432, 9, 253, 81, 171, 28, 276, 45, 304, 495, 462, 446, 449, 458, 398, 376, 28, 333, 439, 468, 320, 156, 171, 318, 506, 398, 111, 92, 403, 319, 397, 161, 28, 46, 37},
  {139, 245, 116, 508, 125, 357, 440, 457, 436, 47, 176, 162, 334, 313, 471, 499, 258, 108, 113, 253, 197, 294, 159, 406, 91, 216, 31, 190, 197, 111, 373, 101, 406, 340, 273, 240, 313, 101, 457, 162, 132, 132, 265, 47, 130, 197, 427, 347, 310, 282, 60, 111, 176, 307, 248, 369, 202, 370, 53, 377, 377, 343, 313, 497, 497, 236, 427, 415, 37, 377, 189, 432, 506, 162, 102, 85, 127, 115, 231, 47, 310, 455, 47, 89, 68, 342, 466, 471, 224, 251, 3, 471, 330, 112, 507, 497, 66, 153, 324, 334},
  {457, 77, 219, 351, 21, 474, 53, 111, 338, 233, 317, 129, 70, 308, 200, 249, 148, 375, 255, 35, 36, 487, 268, 487, 445, 286, 96, 433, 317, 248, 46, 317, 317, 467, 249, 46, 111, 338, 469, 509, 63, 213, 274, 355, 46, 1, 210, 467, 46, 243, 319, 287, 412, 149, 364, 244, 69, 478, 375, 289, 11, 461, 90, 96, 10, 467, 364, 177, 106, 243, 70, 364, 216, 408, 117, 233, 14, 255, 439, 243, 46, 487, 162, 133, 326, 398, 332, 213, 454, 198, 210, 78, 436, 193, 308, 289, 243, 1, 356, 317},
  {67, 440, 466, 375, 108, 146, 233, 64, 88, 439, 251, 357, 45, 88, 394, 29, 420, 165, 459, 388, 106, 481, 491, 245, 190, 482, 481, 61, 57, 185, 125, 21, 146, 218, 319, 367, 34, 130, 375, 20, 106, 511, 34, 298, 61, 283, 310, 481, 232, 255, 48, 5, 110, 222, 146, 403, 260, 473, 1, 407, 104, 276, 196, 185, 25, 218, 156, 481, 375, 142, 29, 46, 375, 257, 338, 171, 148, 61, 263, 457, 1, 113, 218, 432, 219, 214, 479, 215, 12, 457, 75, 230, 263, 484, 482, 131, 291, 73, 286, 500},
  {315, 301, 502, 482, 352, 2, 389, 179, 477, 355, 62, 391, 164, 318, 60, 16, 77, 372, 456, 478, 304, 73, 510, 103, 430, 32, 221, 1, 470, 463, 81, 264, 62, 122, 455, 293, 242, 495, 425, 53, 87, 477, 462, 419, 27, 431, 381, 355, 479, 391, 16, 122, 39, 414, 129, 291, 292, 419, 477, 355, 381, 301, 266, 223, 304, 266, 404, 51, 233, 391, 304, 163, 125, 168, 20, 252, 319, 107, 115, 352, 295, 340, 181, 214, 94, 308, 266, 128, 464, 55, 198, 470, 107, 178, 107, 198, 312, 313, 39, 474},
  {277, 89, 274, 316, 157, 393, 386, 361, 226, 466, 411, 231, 72, 42, 204, 162, 336, 42, 32, 36, 276, 333, 431, 447, 258, 121, 196, 197, 361, 162, 182, 501, 256, 258, 246, 86, 139, 144, 219, 258, 456, 402, 27, 476, 255, 142, 242, 255, 387, 319, 361, 365, 402, 120, 226, 286, 337, 123, 178, 181, 32, 311, 160, 170, 333, 25, 13, 133, 95, 364, 415, 42, 93, 305, 92, 387, 279, 376, 506, 256, 197, 178, 494, 404, 40, 350, 471, 139, 262, 415, 8, 66, 424, 140, 336, 16, 300, 175, 291, 120},
  {500, 249, 13, 86, 278, 41, 453, 501, 321, 208, 262, 23, 215, 410, 402, 63, 208, 87, 219, 317, 431, 456, 71, 257, 496, 14, 439, 98, 18, 193, 400, 512, 188, 275, 431, 207, 3, 188, 123, 384, 208, 173, 108, 215, 278, 184, 101, 143, 179, 507, 443, 278, 14, 142, 402, 473, 269, 422, 173, 465, 305, 84, 215, 353, 429, 262, 135, 490, 220, 305, 147, 78, 295, 275, 235, 297, 390, 351, 30, 377, 143, 469, 302, 7, 486, 487, 329, 385, 143, 76, 377, 257, 321, 433, 278, 410, 284, 500, 44, 247},
  {307, 335, 496, 272, 409, 465, 228, 53, 13, 470, 253, 424, 147, 50, 465, 50, 396, 93, 159, 309, 155, 96, 228, 167, 33, 386, 13, 306, 215, 465, 198, 17, 166, 492, 297, 465, 328, 57, 64, 36, 448, 78, 130, 228, 157, 163, 507, 72, 272, 126, 112, 509, 386, 508, 508, 239, 395, 451, 28, 215, 300, 265, 251, 282, 167, 267, 459, 328, 43, 72, 508, 350, 71, 121, 459, 396, 389, 284, 200, 406, 509, 336, 129, 170, 383, 315, 123, 167, 132, 192, 6, 175, 477, 91, 138, 242, 226, 43, 353, 191},
  {432, 344, 240, 372, 232, 118, 475, 95, 149, 232, 390, 296, 318, 207, 492, 463, 232, 118, 391, 70, 232, 274, 376, 102, 207, 396, 25, 366, 396, 396, 5, 149, 259, 336, 221, 245, 62, 463, 501, 193, 259, 498, 290, 227, 14, 259, 262, 343, 376, 195, 419, 274, 349, 411, 138, 415, 214, 396, 185, 182, 299, 469, 141, 462, 296, 149, 16, 376, 30, 24, 149, 227, 174, 486, 78, 376, 335, 119, 74, 482, 366, 268, 362, 96, 272, 50, 251, 138, 462, 366, 445, 277, 362, 358, 463, 142, 181, 268, 24, 99},
  {459, 462, 377, 144, 223, 432, 264, 464, 139, 108, 324, 125, 113, 386, 159, 300, 78, 182, 406, 364, 280, 474, 326, 306, 126, 20, 52, 358, 182, 500, 486, 2, 78, 15, 233, 398, 486, 306, 497, 420, 451, 161, 254, 325, 161, 17, 182, 15, 408, 108, 99, 246, 95, 129, 451, 433, 32, 190, 408, 333, 100, 452, 451, 395, 334, 16, 222, 182, 264, 390, 173, 261, 409, 182, 512, 216, 64, 244, 456, 326, 432, 145, 390, 261, 382, 511, 387, 149, 266, 95, 108, 157, 334, 494, 451, 200, 185, 315, 102, 233},
  {317, 238, 123, 347, 302, 164, 307, 353, 502, 339, 287, 355, 322, 43, 436, 193, 427, 301, 23, 474, 411, 222, 81, 121, 265, 357, 381, 60, 487, 389, 243, 472, 195, 372, 322, 339, 389, 155, 458, 91, 89, 372, 382, 487, 389, 60, 89, 487, 470, 299, 389, 491, 462, 298, 272, 490, 36, 112, 378, 345, 171, 304, 177, 41, 8, 81, 358, 127, 505, 389, 352, 293, 326, 322, 427, 188, 454, 18, 204, 273, 345, 57, 158, 99, 277, 464, 70, 20, 355, 8, 355, 400, 224, 61, 302, 263, 411, 81, 105, 426},
  {378, 96, 119, 250, 47, 294, 207, 462, 265, 434, 307, 84, 281, 137, 37, 141, 335, 191, 15, 326, 434, 265, 141, 137, 63, 300, 328, 418, 165, 241, 29, 9, 56, 401, 484, 85, 454, 366, 401, 154, 288, 35, 481, 225, 236, 366, 293, 330, 260, 42, 460, 314, 175, 237, 330, 434, 393, 199, 308, 330, 475, 179, 261, 347, 195, 330, 259, 300, 101, 464, 227, 454, 431, 94, 130, 55, 334, 12, 226, 347, 484, 308, 55, 330, 160, 21, 97, 480, 252, 381, 29, 5, 335, 18, 137, 87, 252, 265, 181, 491},
  {44, 271, 195, 62, 65, 104, 378, 441, 67, 303, 34, 90, 212, 53, 354, 10, 167, 319, 388, 380, 228, 458, 106, 224, 155, 324, 106, 510, 402, 308, 210, 441, 34, 285, 392, 462, 458, 44, 417, 170, 222, 82, 138, 442, 441, 481, 153, 505, 93, 90, 246, 67, 131, 346, 53, 365, 416, 312, 195, 364, 417, 69, 392, 406, 140, 285, 88, 505, 324, 196, 277, 334, 428, 498, 215, 324, 380, 124, 511, 167, 12, 80, 120, 14, 177, 418, 55, 267, 185, 308, 10, 212, 82, 138, 67, 417, 134, 505, 322, 406},
  {311, 487, 126, 50, 57, 296, 252, 368, 160, 422, 444, 401, 270, 401, 27, 311, 27, 380, 172, 448, 163, 354, 4, 238, 354, 496, 86, 72, 52, 491, 129, 114, 399, 488, 148, 153, 503, 258, 127, 347, 188, 496, 10, 231, 100, 491, 244, 444, 467, 105, 27, 188, 52, 397, 228, 89, 176, 176, 296, 268, 47, 120, 123, 345, 328, 148, 387, 482, 213, 439, 213, 97, 191, 510, 267, 148, 136, 89, 63, 50, 349, 148, 15, 382, 176, 298, 54, 354, 439, 75, 213, 467, 278, 510, 121, 311, 213, 399, 171, 127},
  {20, 267, 250, 270, 420, 48, 114, 447, 197, 511, 186, 206, 384, 339, 22, 119, 470, 135, 280, 323, 72, 135, 101, 488, 27, 233, 479, 216, 241, 57, 27, 305, 72, 449, 197, 384, 101, 500, 374, 438, 295, 409, 427, 233, 111, 419, 31, 127, 319, 433, 11, 77, 351, 123, 285, 475, 21, 417, 500, 255, 241, 503, 21, 58, 351, 159, 199, 433, 456, 159, 500, 255, 388, 337, 478, 333, 117, 510, 68, 223, 250, 273, 70, 224, 107, 498, 324, 394, 88, 106, 495, 313, 295, 464, 177, 406, 70, 295, 444, 135},
  {502, 417, 316, 236, 227, 235, 132, 133, 242, 249, 396, 109, 358, 161, 386, 97, 332, 262, 376, 222, 93, 476, 470, 506, 133, 249, 231, 133, 10, 509, 73, 190, 238, 200, 262, 159, 509, 509, 454, 309, 509, 491, 505, 176, 159, 109, 106, 109, 43, 21, 316, 332, 109, 92, 217, 36, 259, 351, 10, 396, 223, 465, 384, 415, 361, 93, 323, 150, 493, 396, 174, 491, 345, 316, 462, 178, 488, 105, 349, 509, 242, 56, 288, 267, 194, 173, 440, 470, 200, 200, 188, 268, 33, 339, 415, 379, 454, 40, 155, 149},
  {63, 102, 78, 448, 142, 275, 184, 252, 257, 25, 152, 453, 195, 484, 302, 92, 11, 117, 450, 358, 386, 343, 462, 444, 295, 432, 267, 233, 136, 103, 34, 487, 203, 506, 81, 421, 447, 151, 44, 16, 335, 457, 132, 423, 195, 233, 508, 167, 103, 275, 294, 484, 504, 504, 135, 22, 193, 368, 455, 150, 275, 13, 475, 119, 406, 167, 350, 302, 257, 201, 257, 343, 77, 492, 115, 185, 263, 439, 363, 343, 101, 44, 39, 300, 267, 109, 35, 379, 232, 167, 87, 101, 5, 98, 299, 191, 52, 22, 460, 209},
  {304, 370, 38, 446, 474, 482, 346, 287, 78, 78, 201, 260, 211, 495, 154, 416, 102, 188, 114, 468, 373, 52, 208, 283, 106, 395, 265, 395, 486, 323, 361, 416, 100, 416, 413, 451, 52, 211, 55, 8, 159, 416, 107, 95, 260, 128, 465, 220, 188, 154, 269, 461, 416, 206, 52, 229, 186, 360, 425, 379, 136, 453, 191, 504, 252, 201, 297, 301, 361, 504, 266, 148, 316, 225, 345, 52, 325, 77, 67, 447, 24, 315, 450, 301, 134, 5, 165, 64, 486, 159, 78, 266, 394, 371, 260, 301, 91, 106, 245, 346},
  {365, 478, 421, 389, 417, 310, 179, 258, 237, 477, 63, 82, 325, 11, 1, 263, 422, 325, 274, 260, 95, 214, 105, 367, 74, 475, 352, 472, 50, 325, 28, 167, 204, 4, 263, 368, 455, 346, 162, 244, 214, 34, 214, 278, 367, 34, 222, 60, 280, 214, 499, 50, 204, 52, 74, 388, 154, 83, 11, 50, 355, 312, 238, 121, 127, 352, 267, 509, 236, 499, 414, 295, 28, 509, 47, 244, 32, 496, 8, 302, 34, 204, 488, 511, 186, 314, 297, 452, 367, 325, 452, 310, 162, 226, 162, 280, 400, 463, 490, 134},
  {350, 243, 275, 325, 510, 295, 436, 316, 327, 354, 132, 306, 376, 249, 156, 405, 377, 426, 439, 249, 405, 295, 405, 285, 252, 224, 338, 339, 354, 82, 236, 249, 432, 358, 254, 26, 345, 201, 80, 78, 302, 283, 94, 50, 314, 219, 295, 301, 236, 500, 302, 339, 401, 300, 259, 432, 391, 454, 295, 285, 252, 263, 165, 295, 201, 260, 410, 317, 274, 405, 269, 405, 502, 376, 440, 219, 119, 273, 49, 339, 422, 408, 236, 401, 511, 290, 188, 265, 447, 259, 327, 306, 339, 1, 288, 375, 143, 401, 88, 314},
  {127, 91, 222, 289, 99, 205, 7, 90, 270, 456, 430, 241, 381, 200, 317, 510, 128, 456, 57, 416, 430, 148, 205, 67, 79, 447, 164, 282, 78, 344, 404, 329, 143, 503, 100, 355, 17, 158, 114, 498, 47, 60, 494, 266, 116, 392, 190, 222, 86, 501, 480, 503, 146, 421, 447, 377, 502, 316, 273, 49, 428, 509, 422, 377, 447, 33, 281, 393, 344, 90, 221, 190, 512, 32, 493, 100, 503, 24, 327, 241, 456, 90, 33, 205, 411, 477, 148, 509, 430, 302, 392, 279, 381, 184, 222, 483, 329, 470, 368, 377},
  {70, 352, 100, 170, 7, 276, 427, 174, 269, 32, 265, 478, 193, 147, 451, 244, 71, 45, 290, 193, 137, 70, 215, 462, 422, 104, 503, 297, 489, 269, 269, 244, 113, 191, 503, 489, 75, 339, 174, 416, 52, 339, 375, 220, 114, 379, 303, 413, 137, 78, 101, 169, 147, 78, 128, 321, 34, 71, 34, 269, 180, 130, 267, 70, 84, 215, 122, 244, 470, 479, 138, 351, 180, 365, 124, 157, 443, 358, 455, 249, 470, 422, 433, 491, 481, 449, 201, 327, 174, 82, 351, 215, 214, 263, 174, 433, 511, 322, 435, 479},
  {130, 23, 215, 227, 434, 333, 314, 433, 360, 261, 118, 220, 462, 247, 238, 360, 433, 360, 130, 187, 429, 261, 401, 305, 293, 316, 140, 293, 176, 360, 187, 281, 360, 83, 274, 334, 384, 308, 336, 139, 417, 159, 415, 218, 325, 333, 308, 293, 220, 316, 220, 152, 185, 103, 261, 199, 466, 358, 223, 247, 258, 494, 458, 256, 133, 281, 58, 333, 271, 274, 305, 159, 36, 247, 206, 274, 73, 464, 116, 441, 168, 401, 261, 148, 447, 28, 352, 401, 223, 274, 316, 384, 401, 508, 417, 333, 405, 223, 115, 245},
  {482, 444, 268, 244, 433, 388, 420, 411, 193, 279, 33, 395, 102, 209, 106, 142, 497, 457, 123, 12, 1, 364, 400, 164, 355, 311, 429, 491, 395, 395, 107, 260, 217, 451, 492, 477, 193, 186, 230, 435, 324, 414, 7, 279, 93, 212, 395, 142, 300, 449, 449, 230, 257, 259, 381, 182, 277, 433, 117, 81, 477, 262, 399, 379, 193, 251, 414, 117, 296, 164, 230, 144, 379, 429, 244, 128, 502, 442, 326, 304, 381, 212, 103, 142, 495, 419, 183, 462, 117, 182, 451, 419, 244, 212, 2, 107, 406, 144, 128, 449},
  {166, 378, 311, 53, 454, 300, 218, 280, 329, 130, 363, 329, 21, 310, 488, 467, 239, 476, 329, 123, 10, 251, 132, 501, 10, 347, 21, 39, 359, 354, 300, 378, 21, 378, 298, 202, 280, 378, 104, 412, 146, 95, 327, 510, 432, 86, 354, 104, 378, 354, 258, 146, 266, 288, 41, 378, 175, 397, 120, 452, 227, 318, 357, 432, 496, 452, 175, 239, 120, 337, 359, 258, 203, 512, 359, 179, 227, 352, 469, 61, 269, 432, 476, 226, 172, 322, 221, 310, 467, 10, 403, 57, 179, 329, 375, 473, 182, 318, 159, 179},
  {357, 38, 53, 400, 335, 293, 329, 210, 385, 293, 336, 376, 433, 169, 250, 192, 403, 396, 413, 303, 399, 414, 239, 80, 144, 280, 79, 68, 310, 30, 484, 461, 79, 473, 414, 509, 209, 255, 306, 337, 293, 209, 236, 343, 23, 242, 276, 209, 403, 123, 192, 326, 192, 55, 79, 260, 89, 111, 483, 306, 439, 439, 6, 312, 473, 264, 486, 361, 237, 353, 467, 353, 67, 48, 13, 413, 225, 117, 56, 4, 44, 445, 414, 270, 387, 245, 3, 345, 96, 60, 82, 345, 210, 126, 403, 487, 381, 293, 391, 227},
  {292, 347, 194, 268, 252, 194, 343, 183, 334, 364, 417, 344, 231, 302, 257, 430, 417, 432, 489, 284, 320, 417, 347, 165, 276, 243, 347, 383, 366, 214, 18, 6, 357, 320, 115, 72, 308, 73, 402, 276, 338, 15, 459, 326, 48, 270, 255, 344, 430, 222, 243, 432, 294, 116, 156, 264, 323, 238, 15, 283, 294, 236, 268, 288, 249, 252, 145, 288, 230, 257, 383, 444, 495, 264, 506, 450, 280, 35, 221, 320, 27, 270, 65, 64, 474, 240, 449, 408, 383, 402, 349, 276, 183, 231, 216, 392, 320, 276, 426, 243},
  {443, 395, 185, 220, 191, 211, 401, 13, 356, 320, 194, 441, 323, 89, 356, 337, 337, 388, 43, 332, 337, 21, 356, 344, 504, 174, 243, 236, 2, 464, 471, 135, 194, 146, 291, 251, 344, 164, 74, 32, 373, 186, 447, 159, 228, 102, 211, 89, 48, 54, 121, 347, 180, 42, 201, 320, 489, 16, 80, 211, 243, 247, 29, 453, 35, 367, 292, 344, 13, 35, 504, 505, 406, 426, 333, 264, 460, 398, 366, 389, 261, 479, 406, 80, 103, 18, 379, 163, 339, 301, 128, 453, 261, 396, 74, 99, 67, 337, 279, 74},
  {227, 124, 131, 382, 135, 61, 209, 54, 505, 149, 492, 501, 145, 491, 511, 61, 187, 282, 501, 98, 425, 45, 124, 117, 172, 240, 501, 425, 492, 251, 327, 98, 76, 5, 420, 266, 457, 187, 419, 340, 126, 492, 260, 336, 473, 327, 311, 248, 84, 492, 233, 13, 38, 3, 45, 124, 2, 55, 105, 420, 323, 468, 332, 169, 358, 72, 485, 215, 266, 23, 105, 392, 101, 460, 43, 76, 408, 354, 283, 344, 492, 311, 311, 470, 72, 296, 430, 135, 76, 377, 419, 482, 23, 356, 20, 415, 345, 307, 312, 198},
  {263, 257, 62, 424, 481, 438, 481, 505, 108, 35, 371, 77, 480, 215, 134, 495, 161, 493, 39, 512, 77, 183, 185, 425, 90, 459, 20, 367, 311, 171, 52, 198, 51, 22, 183, 168, 48, 341, 251, 403, 306, 67, 29, 485, 140, 480, 150, 198, 359, 35, 161, 333, 123, 138, 183, 430, 210, 89, 438, 424, 512, 273, 76, 217, 217, 501, 23, 430, 511, 67, 329, 297, 26, 98, 21, 444, 497, 471, 291, 510, 77, 217, 374, 243, 191, 458, 337, 251, 124, 329, 371, 107, 217, 335, 239, 493, 309, 161, 433, 444},
  {110, 396, 61, 88, 465, 16, 380, 440, 413, 118, 472, 494, 46, 9, 163, 36, 179, 356, 270, 399, 349, 35, 262, 29, 118, 194, 511, 122, 506, 413, 440, 380, 118, 96, 165, 327, 179, 10, 149, 344, 96, 474, 296, 509, 218, 16, 474, 128, 47, 68, 232, 490, 494, 231, 470, 194, 291, 253, 35, 35, 167, 354, 437, 29, 118, 150, 166, 319, 165, 29, 80, 284, 465, 91, 65, 166, 132, 39, 228, 16, 194, 9, 203, 314, 477, 14, 32, 398, 196, 263, 203, 273, 203, 20, 347, 194, 27, 255, 347, 118},
  {69, 8, 434, 143, 383, 63, 82, 4, 62, 269, 267, 414, 436, 355, 450, 125, 379, 62, 177, 93, 326, 202, 158, 296, 76, 62, 413, 289, 358, 326, 173, 134, 77, 224, 409, 291, 26, 221, 26, 333, 383, 289, 455, 34, 31, 304, 269, 221, 445, 197, 451, 31, 314, 507, 202, 134, 282, 466, 367, 31, 310, 165, 319, 366, 67, 314, 376, 355, 31, 153, 355, 141, 205, 380, 229, 465, 468, 48, 317, 252, 196, 358, 277, 310, 140, 379, 219, 277, 466, 493, 409, 202, 402, 45, 434, 236, 464, 326, 83, 31},
  {310, 4, 89, 457, 375, 335, 178, 7, 398, 176, 377, 153, 320, 22, 255, 380, 438, 509, 45, 481, 121, 445, 235, 153, 335, 130, 310, 235, 377, 17, 251, 57, 75, 310, 80, 429, 377, 243, 303, 115, 289, 363, 38, 262, 266, 511, 75, 97, 380, 235, 52, 7, 363, 223, 401, 241, 503, 259, 130, 458, 506, 251, 396, 130, 377, 151, 12, 266, 52, 424, 438, 249, 274, 178, 53, 96, 360, 6, 383, 463, 57, 236, 233, 118, 236, 291, 438, 458, 377, 472, 151, 377, 41, 41, 440, 80, 85, 211, 345, 130},
  {168, 240, 230, 368, 39, 71, 439, 343, 35, 96, 343, 203, 344, 312, 33, 45, 21, 162, 408, 96, 71, 149, 379, 429, 368, 438, 162, 125, 463, 35, 218, 286, 25, 111, 120, 104, 45, 344, 312, 148, 240, 23, 501, 78, 438, 18, 312, 312, 312, 252, 331, 428, 140, 373, 438, 203, 312, 229, 46, 111, 74, 177, 440, 45, 349, 509, 269, 405, 312, 299, 428, 377, 504, 312, 497, 125, 102, 62, 32, 10, 405, 240, 136, 444, 62, 405, 249, 362, 148, 240, 428, 71, 40, 166, 468, 140, 340, 162, 415, 40},
  {157, 459, 357, 120, 128, 103, 83, 103, 69, 253, 178, 301, 425, 31, 23, 474, 370, 481, 7, 7, 474, 345, 103, 405, 104, 47, 222, 100, 253, 142, 454, 210, 88, 12, 481, 501, 33, 120, 389, 217, 331, 470, 470, 444, 481, 200, 423, 277, 379, 273, 54, 78, 276, 74, 239, 3, 78, 129, 370, 33, 490, 6, 151, 317, 454, 141, 428, 277, 290, 54, 370, 180, 474, 489, 184, 405, 93, 85, 463, 284, 448, 222, 96, 19, 381, 238, 164, 405, 2, 120, 65, 152, 345, 379, 168, 210, 32, 405, 381, 210},
  {100, 133, 218, 129, 74, 368, 40, 86, 23, 475, 53, 155, 333, 216, 505, 228, 33, 194, 93, 97, 257, 17, 57, 187, 462, 220, 506, 401, 93, 43, 221, 173, 155, 132, 310, 317, 497, 228, 109, 50, 489, 46, 435, 368, 169, 374, 511, 224, 287, 289, 43, 431, 127, 317, 469, 66, 66, 105, 348, 139, 102, 216, 61, 23, 400, 289, 132, 57, 93, 249, 67, 173, 234, 469, 241, 368, 424, 174, 130, 27, 154, 67, 431, 107, 414, 197, 386, 1, 197, 101, 289, 435, 489, 206, 412, 381, 447, 23, 92, 497},
  {441, 429, 296, 49, 113, 55, 370, 380, 419, 19, 476, 232, 250, 419, 397, 396, 19, 295, 183, 181, 88, 388, 443, 88, 31, 335, 475, 419, 335, 19, 295, 397, 186, 42, 55, 356, 419, 304, 313, 286, 396, 12, 368, 277, 186, 32, 356, 335, 250, 356, 55, 359, 313, 344, 121, 356, 479, 477, 499, 218, 267, 419, 416, 375, 147, 186, 284, 359, 484, 105, 119, 137, 48, 449, 173, 46, 165, 297, 62, 420, 475, 279, 250, 29, 459, 484, 509, 152, 63, 19, 137, 369, 279, 107, 369, 335, 388, 449, 505, 408},
  {437, 32, 310, 491, 391, 428, 255, 61, 231, 127, 179, 183, 161, 12, 118, 403, 314, 485, 468, 178, 457, 457, 252, 384, 142, 48, 129, 302, 210, 438, 485, 370, 161, 499, 240, 117, 97, 349, 407, 447, 99, 351, 500, 183, 203, 507, 203, 273, 21, 502, 35, 119, 112, 124, 428, 454, 498, 228, 251, 210, 385, 471, 116, 322, 368, 103, 444, 259, 240, 273, 351, 29, 481, 274, 88, 183, 379, 462, 510, 51, 2, 210, 231, 304, 354, 52, 402, 457, 401, 129, 474, 383, 353, 36, 370, 1, 438, 490, 145, 259},
  {71, 258, 9, 413, 91, 206, 148, 16, 36, 454, 416, 383, 121, 86, 29, 252, 290, 101, 469, 440, 16, 307, 320, 201, 285, 191, 393, 206, 208, 416, 147, 129, 59, 314, 454, 431, 57, 129, 41, 165, 158, 44, 464, 144, 358, 248, 29, 59, 343, 271, 156, 243, 252, 125, 465, 446, 303, 174, 158, 55, 481, 313, 338, 191, 343, 466, 69, 439, 414, 208, 314, 396, 347, 454, 200, 335, 193, 146, 333, 335, 335, 201, 479, 505, 490, 411, 185, 180, 499, 343, 360, 307, 191, 369, 465, 314, 12, 198, 361, 396},
  {418, 409, 437, 481, 127, 9, 490, 376, 211, 472, 54, 211, 101, 448, 260, 71, 220, 411, 293, 41, 177, 477, 11, 1, 506, 152, 455, 66, 378, 455, 339, 376, 243, 393, 218, 338, 81, 220, 273, 273, 235, 508, 400, 428, 241, 424, 205, 199, 30, 220, 30, 455, 51, 430, 393, 172, 295, 60, 220, 220, 334, 337, 287, 314, 286, 50, 211, 205, 391, 177, 392, 32, 213, 332, 270, 464, 16, 505, 508, 9, 220, 454, 241, 350, 426, 11, 271, 48, 435, 51, 424, 255, 205, 134, 81, 77, 426, 303, 315, 486},
  {84, 57, 410, 392, 236, 202, 86, 146, 354, 268, 59, 24, 282, 346, 172, 113, 214, 17, 349, 466, 439, 66, 304, 142, 45, 246, 100, 4, 478, 146, 337, 462, 506, 282, 104, 449, 492, 256, 49, 259, 385, 422, 112, 302, 488, 132, 422, 462, 122, 173, 122, 408, 19, 460, 159, 504, 116, 189, 88, 173, 124, 296, 85, 385, 14, 154, 462, 297, 422, 282, 486, 408, 202, 202, 408, 385, 238, 335, 395, 244, 132, 333, 132, 48, 231, 363, 447, 132, 73, 462, 189, 478, 372, 509, 14, 457, 73, 478, 23, 225},
  {199, 158, 147, 460, 226, 375, 31, 349, 199, 76, 499, 321, 24, 375, 316, 437, 207, 51, 433, 383, 296, 278, 118, 38, 251, 499, 206, 145, 118, 375, 185, 432, 261, 49, 303, 68, 437, 465, 339, 249, 193, 206, 475, 494, 129, 249, 320, 173, 375, 71, 123, 24, 278, 216, 283, 411, 384, 338, 355, 89, 499, 400, 361, 349, 71, 223, 316, 30, 123, 131, 49, 244, 253, 278, 331, 393, 36, 235, 451, 469, 339, 223, 123, 146, 331, 92, 511, 306, 512, 14, 199, 192, 414, 177, 63, 349, 152, 233, 229, 141},
  {153, 321, 370, 210, 473, 467, 169, 482, 102, 416, 443, 338, 151, 51, 251, 479, 117, 486, 453, 301, 209, 200, 411, 401, 402, 277, 372, 117, 138, 66, 17, 436, 221, 24, 510, 378, 250, 492, 16, 2, 238, 27, 89, 16, 85, 338, 91, 16, 85, 117, 96, 15, 117, 84, 367, 212, 255, 239, 324, 459, 341, 36, 237, 163, 363, 212, 366, 255, 372, 251, 16, 320, 30, 251, 79, 510, 63, 283, 93, 96, 320, 482, 413, 77, 367, 169, 257, 316, 278, 502, 119, 138, 242, 327, 33, 309, 372, 171, 503, 79},
  {135, 179, 308, 31, 152, 219, 168, 476, 246, 181, 87, 26, 407, 91, 228, 497, 116, 152, 58, 204, 56, 179, 272, 140, 62, 235, 395, 92, 383, 58, 105, 219, 193, 374, 57, 418, 164, 70, 507, 479, 57, 152, 160, 114, 284, 193, 419, 219, 419, 313, 18, 470, 206, 215, 260, 183, 346, 127, 116, 231, 361, 488, 500, 454, 409, 209, 55, 238, 56, 281, 36, 502, 29, 116, 138, 161, 412, 239, 441, 213, 52, 419, 52, 124, 75, 241, 50, 56, 419, 355, 386, 297, 313, 376, 498, 246, 377, 370, 139, 12},
  {295, 97, 265, 67, 255, 449, 450, 458, 218, 257, 458, 210, 441, 460, 456, 80, 282, 158, 164, 328, 118, 26, 478, 509, 149, 506, 488, 46, 494, 486, 137, 502, 80, 323, 174, 236, 467, 134, 300, 17, 93, 400, 448, 134, 118, 444, 14, 410, 234, 134, 266, 45, 26, 264, 46, 122, 245, 341, 200, 509, 67, 245, 310, 257, 486, 322, 204, 124, 20, 488, 137, 209, 343, 200, 397, 478, 2, 192, 507, 93, 444, 368, 105, 320, 299, 13, 456, 69, 245, 20, 467, 58, 478, 255, 5, 105, 292, 84, 448, 410},
  {220, 371, 121, 69, 243, 389, 37, 453, 22, 52, 42, 219, 435, 291, 509, 118, 106, 90, 371, 455, 64, 159, 441, 253, 435, 483, 141, 457, 42, 244, 507, 42, 377, 397, 488, 382, 64, 427, 453, 496, 345, 507, 148, 166, 291, 203, 22, 320, 106, 427, 505, 270, 90, 412, 427, 474, 308, 24, 333, 493, 77, 206, 198, 3, 405, 36, 497, 118, 174, 3, 93, 399, 124, 338, 403, 267, 354, 47, 275, 504, 22, 429, 106, 188, 183, 377, 191, 350, 230, 360, 427, 7, 405, 220, 377, 294, 110, 435, 423, 58},
  {149, 264, 33, 380, 425, 308, 299, 449, 446, 216, 418, 408, 56, 427, 284, 282, 310, 299, 207, 107, 375, 172, 52, 75, 339, 124, 240, 308, 95, 483, 167, 347, 43, 192, 265, 295, 418, 343, 187, 236, 287, 32, 326, 319, 75, 418, 322, 385, 273, 496, 172, 414, 282, 486, 107, 343, 425, 143, 389, 287, 228, 190, 222, 192, 469, 219, 96, 346, 446, 219, 424, 66, 96, 427, 263, 192, 391, 55, 479, 247, 129, 219, 29, 135, 448, 459, 87, 216, 152, 247, 311, 56, 389, 105, 219, 308, 177, 177, 130, 55},
  {175, 266, 202, 459, 458, 186, 326, 432, 79, 276, 204, 460, 268, 213, 198, 28, 103, 289, 182, 89, 392, 127, 28, 101, 195, 127, 92, 298, 144, 160, 276, 186, 211, 339, 195, 276, 195, 277, 324, 120, 28, 16, 329, 99, 392, 506, 298, 205, 330, 4, 2, 92, 6, 210, 471, 127, 130, 233, 392, 160, 373, 424, 447, 213, 305, 160, 324, 466, 127, 443, 218, 6, 342, 213, 391, 57, 276, 498, 296, 468, 193, 235, 242, 407, 243, 95, 28, 2, 423, 117, 469, 103, 426, 351, 506, 506, 106, 339, 440, 251},
  {245, 141, 51, 54, 393, 27, 215, 434, 447, 348, 67, 366, 170, 23, 234, 402, 394, 511, 30, 503, 96, 258, 23, 231, 154, 154, 348, 94, 124, 421, 96, 424, 496, 241, 267, 351, 192, 358, 248, 121, 348, 447, 4, 347, 113, 258, 315, 394, 289, 119, 125, 170, 74, 473, 113, 315, 179, 147, 347, 170, 467, 76, 214, 463, 113, 128, 60, 348, 447, 402, 46, 447, 455, 464, 423, 28, 222, 95, 302, 192, 402, 289, 358, 141, 15, 202, 425, 119, 323, 189, 173, 344, 364, 210, 475, 66, 8, 378, 28, 347},
  {238, 367, 399, 10, 180, 477, 176, 98, 179, 139, 66, 456, 133, 49, 43, 302, 98, 120, 247, 318, 400, 493, 456, 448, 66, 511, 448, 183, 194, 225, 194, 47, 45, 182, 86, 185, 120, 466, 179, 397, 136, 279, 438, 132, 503, 78, 405, 361, 38, 493, 133, 66, 493, 419, 162, 370, 356, 493, 419, 107, 213, 12, 506, 194, 489, 381, 382, 489, 419, 91, 151, 279, 260, 8, 349, 349, 88, 468, 382, 456, 257, 22, 456, 459, 138, 134, 111, 151, 139, 388, 96, 474, 302, 52, 22, 367, 265, 493, 287, 338},
  {182, 331, 114, 288, 60, 500, 87, 246, 58, 305, 493, 189, 129, 96, 331, 246, 350, 403, 92, 20, 195, 63, 267, 380, 163, 273, 226, 403, 480, 370, 403, 163, 273, 149, 270, 336, 163, 443, 355, 490, 40, 401, 499, 382, 439, 293, 177, 213, 8, 171, 142, 403, 512, 424, 40, 310, 165, 264, 380, 177, 29, 132, 152, 273, 107, 129, 186, 470, 96, 512, 91, 129, 293, 195, 252, 129, 348, 143, 426, 189, 31, 140, 172, 366, 263, 205, 146, 238, 11, 426, 107, 197, 246, 337, 96, 67, 373, 486, 156, 355},
  {417, 253, 301, 394, 506, 125, 234, 415, 229, 306, 61, 480, 49, 349, 203, 421, 324, 218, 403, 267, 119, 64, 488, 336, 329, 421, 387, 172, 134, 2, 368, 476, 42, 255, 308, 249, 415, 42, 103, 432, 64, 390, 308, 405, 304, 329, 148, 93, 476, 351, 194, 415, 437, 381, 151, 48, 362, 18, 31, 194, 49, 71, 492, 387, 27, 229, 460, 368, 29, 283, 449, 336, 399, 196, 149, 421, 316, 80, 23, 288, 377, 129, 165, 499, 452, 219, 136, 61, 437, 315, 48, 421, 368, 117, 387, 129, 303, 329, 285, 129},
  {466, 233, 35, 5, 283, 231, 377, 255, 300, 184, 139, 266, 278, 255, 417, 217, 139, 429, 133, 492, 507, 463, 225, 470, 255, 250, 149, 278, 71, 490, 430, 238, 215, 177, 475, 11, 112, 23, 314, 489, 184, 326, 243, 237, 165, 504, 6, 507, 192, 486, 231, 417, 99, 410, 112, 450, 485, 475, 238, 357, 12, 299, 295, 461, 352, 504, 47, 231, 184, 430, 368, 126, 359, 223, 212, 447, 255, 504, 59, 133, 300, 137, 470, 323, 314, 15, 343, 490, 160, 401, 443, 165, 174, 334, 8, 241, 215, 71, 160, 93},
  {434, 303, 416, 237, 233, 143, 275, 377, 105, 254, 143, 354, 239, 239, 309, 65, 299, 371, 401, 210, 114, 134, 493, 449, 88, 303, 4, 189, 163, 155, 90, 179, 391, 143, 448, 88, 294, 20, 309, 246, 205, 251, 345, 317, 142, 285, 112, 408, 414, 444, 430, 269, 375, 510, 467, 259, 432, 365, 98, 32, 189, 367, 296, 239, 189, 71, 217, 331, 485, 199, 65, 309, 471, 331, 429, 492, 288, 373, 185, 407, 179, 427, 354, 481, 166, 286, 413, 427, 105, 285, 86, 504, 3, 458, 337, 427, 323, 309, 40, 189},
  {195, 507, 420, 26, 211, 343, 65, 27, 249, 372, 369, 80, 348, 19, 265, 409, 119, 209, 355, 146, 343, 144, 174, 269, 307, 334, 107, 286, 107, 364, 372, 185, 60, 239, 286, 39, 466, 203, 505, 185, 133, 228, 14, 394, 239, 88, 438, 80, 409, 80, 485, 437, 468, 155, 312, 396, 192, 74, 4, 144, 249, 336, 409, 32, 256, 133, 21, 437, 256, 188, 188, 17, 337, 188, 278, 390, 239, 395, 425, 437, 280, 203, 133, 443, 400, 200, 383, 468, 394, 409, 155, 468, 357, 167, 396, 438, 23, 395, 509, 292},
  {373, 349, 267, 313, 428, 185, 146, 312, 245, 195, 177, 47, 497, 469, 360, 9, 375, 433, 12, 479, 297, 490, 490, 36, 288, 375, 357, 448, 336, 376, 103, 261, 69, 88, 329, 83, 323, 28, 255, 69, 376, 428, 165, 301, 349, 428, 195, 386, 474, 120, 312, 103, 474, 174, 163, 360, 288, 511, 108, 65, 287, 321, 53, 413, 288, 386, 451, 386, 109, 103, 255, 506, 33, 273, 82, 288, 8, 236, 384, 196, 86, 64, 195, 17, 484, 209, 285, 103, 273, 312, 413, 161, 360, 388, 358, 36, 255, 509, 473, 103},
  {181, 446, 156, 472, 351, 34, 227, 459, 174, 300, 145, 218, 335, 454, 123, 341, 360, 22, 63, 194, 83, 357, 85, 197, 503, 66, 376, 496, 223, 281, 435, 265, 170, 170, 407, 217, 499, 307, 60, 508, 16, 454, 279, 463, 246, 454, 118, 118, 49, 165, 174, 223, 118, 340, 192, 257, 7, 438, 85, 265, 140, 394, 103, 319, 330, 246, 290, 83, 3, 307, 55, 435, 223, 85, 93, 441, 15, 259, 16, 246, 3, 174, 223, 296, 143, 206, 436, 300, 491, 498, 62, 96, 153, 131, 471, 141, 142, 491, 242, 341},
  {464, 234, 3, 59, 370, 298, 144, 55, 363, 478, 222, 4, 199, 418, 512, 222, 248, 455, 34, 369, 82, 82, 455, 148, 418, 212, 5, 421, 267, 212, 250, 280, 325, 155, 171, 210, 25, 204, 27, 460, 122, 318, 343, 222, 506, 267, 280, 363, 392, 82, 286, 286, 165, 93, 372, 499, 170, 435, 5, 391, 122, 340, 148, 148, 185, 130, 181, 148, 409, 392, 199, 325, 192, 65, 283, 4, 493, 305, 286, 242, 337, 498, 421, 63, 245, 216, 256, 335, 298, 18, 136, 286, 96, 143, 419, 453, 267, 39, 457, 470},
  {429, 463, 303, 264, 68, 361, 328, 477, 219, 317, 199, 442, 443, 152, 376, 210, 431, 200, 191, 334, 493, 472, 170, 126, 431, 472, 389, 431, 25, 285, 4, 477, 268, 477, 259, 133, 140, 351, 396, 60, 18, 443, 498, 191, 351, 303, 99, 412, 39, 63, 34, 245, 181, 44, 2, 86, 114, 292, 404, 152, 199, 398, 426, 491, 412, 431, 216, 163, 77, 398, 484, 404, 496, 404, 376, 339, 251, 167, 21, 317, 317, 442, 280, 485, 437, 367, 117, 140, 181, 396, 181, 349, 404, 80, 472, 270, 135, 443, 386, 472},
  {419, 280, 456, 254, 162, 113, 98, 490, 355, 375, 505, 389, 365, 241, 241, 494, 204, 377, 256, 83, 367, 248, 286, 368, 250, 307, 40, 309, 286, 213, 54, 241, 296, 18, 494, 455, 2, 286, 107, 279, 333, 484, 64, 460, 143, 389, 460, 69, 127, 127, 241, 65, 241, 117, 196, 99, 446, 385, 412, 494, 455, 357, 503, 451, 500, 40, 406, 468, 204, 143, 156, 425, 145, 250, 224, 280, 141, 445, 151, 307, 71, 213, 109, 335, 300, 326, 140, 71, 99, 227, 468, 425, 377, 485, 76, 431, 339, 427, 72, 451},
  {403, 241, 403, 188, 2, 461, 262, 346, 119, 3, 261, 385, 173, 461, 449, 205, 358, 478, 480, 371, 129, 233, 503, 385, 239, 239, 199, 130, 408, 216, 229, 146, 423, 442, 377, 271, 274, 3, 428, 220, 210, 143, 495, 452, 461, 58, 53, 245, 304, 495, 190, 98, 261, 205, 164, 292, 512, 482, 233, 233, 335, 443, 366, 260, 98, 316, 313, 84, 129, 322, 15, 442, 296, 293, 449, 260, 223, 261, 248, 267, 32, 269, 371, 130, 82, 155, 17, 205, 53, 346, 120, 428, 233, 217, 442, 486, 22, 204, 508, 403},
  {236, 35, 294, 57, 503, 313, 97, 259, 341, 329, 45, 416, 265, 321, 141, 212, 384, 231, 99, 60, 499, 349, 363, 483, 305, 290, 247, 21, 274, 446, 384, 157, 358, 481, 423, 310, 404, 147, 341, 391, 439, 278, 149, 160, 183, 355, 304, 157, 257, 98, 384, 265, 173, 283, 200, 282, 17, 495, 103, 305, 358, 456, 252, 384, 123, 278, 439, 305, 416, 372, 450, 407, 324, 372, 251, 384, 104, 82, 379, 69, 108, 372, 313, 100, 466, 152, 75, 289, 192, 126, 282, 231, 181, 507, 329, 355, 371, 224, 231, 278},
  {431, 288, 167, 80, 295, 286, 388, 282, 66, 109, 434, 282, 324, 324, 373, 324, 72, 469, 16, 68, 246, 310, 463, 66, 280, 463, 366, 385, 135, 324, 324, 175, 324, 97, 135, 324, 440, 364, 463, 150, 55, 319, 332, 241, 253, 352, 241, 113, 492, 417, 25, 213, 364, 429, 352, 373, 64, 469, 231, 327, 78, 139, 221, 10, 490, 434, 471, 403, 124, 47, 306, 373, 121, 385, 412, 352, 191, 448, 422, 354, 383, 400, 294, 360, 248, 327, 319, 417, 86, 266, 324, 113, 286, 32, 352, 325, 124, 352, 70, 324},
  {177, 129, 264, 121, 88, 353, 125, 322, 5, 131, 13, 262, 353, 507, 355, 480, 465, 189, 206, 199, 509, 450, 131, 342, 262, 480, 326, 285, 447, 450, 8, 224, 47, 243, 266, 274, 10, 184, 198, 318, 43, 382, 90, 461, 89, 149, 237, 117, 489, 149, 184, 64, 162, 442, 10, 331, 232, 161, 131, 480, 433, 83, 23, 4, 307, 433, 433, 475, 374, 66, 183, 507, 487, 36, 441, 15, 491, 162, 243, 268, 391, 95, 447, 303, 92, 72, 214, 131, 507, 184, 465, 285, 98, 81, 285, 414, 130, 174, 133, 468},
  {458, 403, 414, 296, 338, 367, 311, 311, 89, 136, 487, 14, 187, 173, 218, 410, 113, 379, 374, 355, 251, 103, 439, 311, 456, 83, 371, 228, 173, 456, 63, 268, 18, 512, 373, 402, 136, 439, 211, 218, 433, 466, 163, 8, 101, 211, 206, 367, 311, 151, 173, 56, 211, 289, 197, 120, 48, 410, 74, 30, 35, 255, 290, 63, 393, 238, 429, 293, 74, 395, 311, 268, 385, 440, 41, 433, 45, 424, 411, 101, 356, 439, 196, 260, 347, 102, 33, 374, 74, 134, 187, 293, 47, 364, 456, 332, 210, 83, 193, 211},
  {31, 122, 481, 407, 447, 10, 263, 494, 373, 274, 410, 71, 389, 176, 294, 57, 294, 85, 377, 486, 510, 385, 294, 510, 123, 294, 176, 347, 171, 217, 154, 331, 154, 494, 36, 330, 82, 159, 240, 285, 423, 294, 115, 471, 385, 453, 331, 288, 288, 240, 372, 84, 331, 31, 423, 137, 126, 319, 366, 485, 425, 500, 425, 13, 4, 395, 331, 294, 510, 359, 118, 28, 269, 253, 163, 455, 197, 11, 149, 210, 118, 332, 229, 497, 389, 34, 113, 439, 373, 202, 85, 251, 494, 5, 103, 154, 176, 234, 89, 154},
  {241, 348, 445, 138, 195, 45, 89, 238, 392, 186, 348, 279, 440, 424, 50, 481, 159, 304, 316, 252, 112, 14, 229, 144, 168, 215, 400, 420, 94, 33, 223, 333, 105, 348, 261, 319, 452, 261, 125, 463, 142, 285, 410, 479, 298, 215, 186, 491, 286, 360, 392, 144, 491, 440, 245, 112, 355, 303, 214, 142, 118, 413, 244, 380, 68, 506, 159, 144, 45, 22, 439, 452, 279, 45, 318, 168, 324, 129, 443, 440, 73, 112, 452, 195, 509, 324, 481, 160, 506, 22, 285, 85, 35, 114, 366, 35, 298, 389, 66, 348},
  {16, 268, 235, 310, 26, 136, 433, 439, 310, 399, 350, 294, 493, 397, 427, 151, 82, 255, 163, 464, 151, 460, 116, 349, 320, 327, 370, 259, 82, 327, 294, 49, 136, 13, 318, 450, 460, 354, 483, 401, 68, 154, 83, 366, 147, 294, 95, 201, 399, 266, 418, 449, 399, 465, 399, 354, 349, 32, 239, 207, 194, 182, 101, 136, 480, 119, 87, 449, 142, 4, 164, 310, 144, 277, 314, 377, 101, 466, 160, 433, 259, 370, 184, 421, 368, 132, 400, 239, 212, 208, 415, 73, 116, 465, 355, 255, 428, 7, 349, 483},
  {19, 79, 112, 412, 22, 246, 25, 165, 84, 480, 314, 431, 38, 126, 484, 227, 309, 23, 331, 29, 465, 140, 94, 219, 396, 36, 309, 371, 219, 314, 169, 321, 295, 396, 140, 19, 329, 316, 444, 156, 254, 419, 337, 439, 112, 84, 201, 296, 251, 112, 227, 177, 305, 246, 331, 431, 328, 175, 143, 474, 387, 11, 121, 381, 144, 331, 184, 69, 180, 355, 434, 25, 157, 314, 227, 170, 339, 403, 37, 431, 498, 285, 355, 414, 493, 116, 5, 455, 38, 63, 245, 48, 444, 456, 314, 455, 112, 227, 270, 112},
  {266, 297, 63, 279, 457, 384, 133, 500, 205, 465, 79, 323, 307, 188, 384, 393, 35, 24, 42, 227, 57, 473, 308, 15, 230, 6, 307, 230, 88, 453, 343, 223, 282, 90, 253, 16, 152, 103, 90, 423, 282, 485, 393, 435, 24, 103, 384, 282, 420, 47, 200, 304, 269, 25, 35, 205, 420, 246, 450, 90, 179, 109, 468, 152, 487, 39, 36, 420, 411, 200, 35, 267, 478, 465, 307, 290, 427, 81, 100, 465, 307, 4, 79, 326, 135, 452, 74, 307, 290, 494, 251, 245, 290, 251, 380, 307, 39, 450, 216, 420},
  {66, 255, 168, 238, 277, 241, 402, 25, 91, 129, 14, 149, 5, 59, 210, 148, 49, 148, 47, 404, 165, 115, 509, 55, 439, 253, 177, 148, 493, 96, 422, 39, 55, 375, 40, 500, 493, 383, 500, 92, 7, 235, 41, 188, 482, 253, 340, 99, 451, 334, 15, 54, 148, 428, 55, 97, 501, 483, 207, 67, 383, 382, 493, 14, 417, 84, 375, 128, 207, 493, 253, 105, 307, 482, 484, 177, 272, 454, 502, 65, 253, 11, 128, 49, 363, 30, 281, 181, 496, 440, 482, 59, 128, 435, 49, 5, 452, 417, 374, 54},
  {88, 392, 323, 180, 205, 303, 5, 391, 297, 333, 269, 365, 496, 373, 442, 389, 249, 334, 353, 445, 220, 353, 353, 467, 330, 323, 365, 143, 235, 60, 353, 499, 83, 334, 361, 125, 361, 181, 257, 117, 359, 305, 194, 168, 45, 330, 282, 279, 279, 419, 92, 353, 249, 260, 243, 250, 71, 420, 24, 302, 224, 108, 242, 268, 180, 243, 97, 249, 269, 292, 496, 23, 438, 176, 383, 305, 486, 274, 189, 373, 323, 303, 408, 372, 55, 416, 486, 268, 334, 490, 288, 308, 305, 496, 292, 351, 30, 391, 84, 164},
  {108, 406, 251, 202, 67, 396, 112, 314, 55, 301, 255, 369, 17, 463, 290, 377, 463, 386, 79, 237, 26, 386, 359, 46, 350, 33, 420, 5, 387, 46, 164, 33, 463, 463, 83, 375, 279, 314, 223, 75, 430, 472, 333, 371, 437, 463, 145, 430, 226, 420, 164, 459, 170, 478, 247, 420, 262, 222, 226, 369, 290, 308, 383, 93, 359, 345, 224, 279, 370, 144, 416, 345, 182, 5, 34, 10, 374, 508, 69, 477, 128, 297, 386, 338, 394, 463, 290, 416, 472, 500, 215, 164, 55, 292, 19, 463, 16, 128, 76, 76},
  {297, 364, 17, 217, 456, 7, 478, 43, 256, 345, 405, 197, 227, 366, 47, 471, 80, 160, 59, 99, 504, 471, 108, 366, 220, 292, 80, 234, 355, 176, 358, 108, 355, 10, 220, 395, 130, 176, 161, 206, 123, 489, 421, 430, 189, 487, 13, 234, 160, 36, 272, 395, 10, 313, 444, 119, 120, 155, 452, 395, 64, 17, 449, 471, 108, 471, 129, 456, 272, 15, 366, 292, 79, 470, 366, 36, 183, 483, 225, 123, 54, 472, 292, 202, 470, 10, 381, 161, 293, 471, 438, 80, 7, 16, 395, 489, 317, 473, 104, 144},
  {160, 19, 288, 103, 313, 311, 472, 66, 410, 154, 311, 226, 119, 367, 52, 99, 244, 154, 154, 24, 498, 367, 169, 191, 218, 410, 311, 410, 249, 178, 226, 84, 338, 367, 509, 31, 137, 226, 279, 243, 143, 408, 407, 60, 350, 169, 420, 398, 435, 410, 178, 1, 238, 448, 168, 408, 258, 393, 377, 320, 495, 252, 285, 111, 93, 403, 197, 461, 108, 244, 226, 398, 505, 41, 343, 367, 419, 485, 264, 119, 13, 435, 74, 65, 77, 448, 200, 450, 191, 12, 367, 13, 254, 488, 286, 218, 357, 256, 506, 320},
  {218, 497, 144, 323, 511, 301, 399, 97, 177, 187, 55, 274, 510, 274, 151, 344, 437, 287, 337, 111, 442, 138, 415, 130, 177, 196, 374, 393, 56, 478, 325, 344, 187, 471, 118, 65, 442, 84, 92, 160, 213, 42, 72, 474, 84, 118, 82, 274, 82, 415, 464, 145, 82, 112, 380, 466, 150, 87, 210, 262, 76, 31, 299, 65, 287, 177, 417, 442, 437, 411, 287, 323, 55, 442, 155, 308, 56, 210, 499, 415, 145, 504, 324, 178, 228, 247, 108, 411, 415, 229, 97, 65, 481, 497, 325, 84, 229, 382, 504, 382},
  {426, 103, 92, 258, 77, 148, 12, 135, 6, 260, 474, 91, 92, 458, 191, 422, 506, 175, 407, 4, 101, 260, 461, 435, 46, 60, 175, 267, 347, 175, 212, 29, 246, 223, 424, 43, 299, 135, 110, 465, 470, 223, 76, 146, 317, 397, 256, 258, 165, 135, 165, 331, 302, 452, 175, 91, 101, 278, 456, 212, 75, 329, 45, 200, 148, 183, 81, 165, 42, 58, 135, 165, 204, 506, 315, 202, 18, 350, 177, 424, 29, 461, 110, 56, 115, 107, 139, 347, 470, 212, 165, 320, 506, 244, 79, 424, 391, 148, 487, 321},
  {80, 250, 401, 110, 30, 454, 381, 57, 182, 509, 56, 375, 486, 115, 310, 488, 129, 248, 24, 56, 306, 104, 345, 115, 237, 172, 32, 414, 454, 232, 145, 473, 145, 381, 232, 182, 229, 506, 115, 39, 237, 37, 424, 455, 201, 104, 62, 39, 145, 172, 145, 134, 62, 339, 455, 488, 122, 194, 411, 310, 16, 277, 349, 104, 325, 161, 226, 488, 306, 455, 87, 264, 107, 375, 152, 434, 82, 172, 162, 87, 248, 434, 510, 331, 365, 395, 157, 198, 508, 454, 237, 62, 16, 25, 39, 8, 294, 129, 170, 509},
  {325, 405, 178, 355, 105, 272, 14, 221, 258, 51, 8, 168, 25, 90, 462, 286, 25, 240, 242, 485, 252, 25, 241, 226, 440, 342, 504, 381, 157, 388, 303, 354, 233, 100, 168, 38, 121, 440, 320, 456, 405, 249, 119, 450, 164, 241, 364, 370, 364, 89, 157, 381, 124, 374, 405, 202, 495, 479, 25, 416, 254, 257, 9, 139, 440, 232, 441, 446, 508, 334, 241, 31, 156, 49, 511, 75, 368, 262, 181, 495, 342, 405, 282, 186, 255, 7, 340, 25, 8, 157, 204, 334, 370, 127, 469, 298, 370, 345, 350, 370},
  {260, 324, 493, 490, 275, 305, 42, 302, 217, 248, 335, 415, 459, 359, 53, 438, 459, 415, 121, 239, 322, 508, 191, 508, 56, 217, 322, 407, 324, 302, 233, 324, 276, 35, 467, 6, 233, 198, 335, 370, 107, 6, 95, 104, 115, 110, 335, 439, 169, 264, 251, 407, 407, 359, 305, 335, 124, 268, 110, 222, 324, 505, 219, 157, 157, 100, 383, 60, 383, 263, 459, 53, 451, 303, 470, 424, 498, 326, 501, 305, 43, 467, 157, 390, 142, 73, 236, 11, 459, 439, 110, 415, 166, 219, 86, 416, 276, 407, 337, 176},
  {254, 477, 199, 299, 172, 260, 279, 216, 267, 357, 334, 67, 385, 153, 233, 415, 441, 448, 228, 37, 475, 299, 234, 357, 291, 387, 132, 174, 418, 407, 265, 464, 197, 385, 311, 469, 173, 461, 31, 116, 182, 10, 489, 76, 448, 144, 387, 119, 461, 64, 415, 173, 443, 235, 333, 461, 339, 486, 299, 351, 52, 387, 227, 52, 2, 448, 153, 173, 130, 407, 53, 204, 176, 347, 465, 415, 155, 304, 152, 102, 443, 192, 43, 325, 157, 87, 133, 392, 123, 4, 28, 153, 10, 503, 267, 20, 10, 52, 27, 174},
  {287, 474, 346, 257, 224, 405, 28, 235, 148, 87, 309, 435, 219, 4, 454, 140, 340, 187, 38, 507, 76, 210, 16, 235, 98, 369, 460, 62, 458, 148, 15, 448, 165, 369, 42, 113, 448, 25, 347, 100, 76, 479, 40, 27, 122, 405, 76, 235, 340, 435, 435, 508, 32, 180, 190, 193, 168, 289, 405, 25, 369, 271, 275, 458, 179, 90, 362, 382, 39, 295, 153, 322, 429, 309, 238, 508, 70, 198, 468, 180, 89, 369, 460, 464, 409, 179, 409, 324, 235, 53, 90, 235, 266, 429, 264, 386, 122, 140, 20, 18},
  {206, 51, 175, 229, 110, 177, 419, 307, 368, 39, 299, 94, 299, 119, 404, 429, 319, 252, 314, 457, 359, 237, 507, 112, 246, 177, 281, 177, 119, 25, 245, 133, 87, 501, 236, 40, 213, 408, 2, 229, 25, 327, 372, 138, 283, 158, 165, 52, 296, 260, 45, 307, 424, 202, 254, 190, 463, 177, 177, 469, 120, 92, 461, 220, 512, 181, 374, 295, 112, 319, 432, 286, 490, 432, 336, 213, 367, 378, 318, 404, 99, 341, 276, 70, 315, 112, 338, 424, 233, 40, 25, 469, 190, 415, 361, 509, 344, 451, 87, 390},
  {362, 316, 67, 239, 196, 504, 318, 364, 263, 60, 217, 394, 362, 301, 98, 365, 6, 447, 187, 299, 204, 484, 90, 455, 57, 8, 43, 362, 321, 263, 26, 65, 157, 226, 401, 78, 403, 50, 416, 214, 361, 420, 386, 327, 394, 250, 394, 217, 411, 321, 263, 175, 362, 395, 502, 157, 470, 330, 415, 2, 133, 16, 510, 416, 401, 54, 126, 151, 362, 77, 98, 12, 19, 455, 239, 416, 455, 276, 76, 43, 394, 403, 401, 476, 109, 453, 382, 283, 311, 348, 437, 455, 283, 502, 101, 175, 228, 364, 183, 333},
  {335, 1, 228, 219, 34, 60, 473, 473, 476, 197, 237, 247, 244, 95, 112, 374, 468, 95, 88, 335, 506, 443, 120, 95, 269, 441, 291, 355, 406, 318, 333, 172, 318, 75, 288, 75, 387, 406, 406, 194, 67, 495, 144, 2, 235, 63, 129, 12, 206, 499, 10, 259, 247, 119, 298, 269, 85, 149, 512, 75, 247, 162, 63, 173, 337, 441, 337, 486, 443, 413, 39, 206, 348, 113, 351, 406, 399, 74, 80, 238, 120, 188, 416, 502, 213, 432, 18, 113, 333, 255, 318, 387, 369, 6, 494, 237, 149, 456, 209, 284},
  {485, 75, 197, 114, 155, 510, 69, 291, 508, 30, 98, 22, 243, 505, 299, 379, 86, 492, 25, 231, 413, 1, 265, 259, 111, 445, 458, 388, 98, 211, 370, 410, 508, 376, 9, 70, 291, 161, 353, 18, 169, 259, 164, 339, 87, 162, 259, 111, 63, 331, 291, 485, 243, 9, 370, 83, 184, 113, 341, 299, 30, 159, 389, 505, 475, 9, 56, 47, 291, 508, 155, 133, 92, 87, 503, 511, 44, 332, 353, 211, 388, 86, 458, 121, 336, 280, 294, 111, 431, 310, 111, 55, 86, 180, 161, 471, 353, 63, 295, 416},
  {56, 401, 189, 439, 138, 42, 393, 334, 332, 165, 80, 118, 85, 84, 246, 208, 430, 312, 226, 329, 490, 461, 60, 446, 299, 365, 238, 372, 332, 12, 318, 430, 334, 407, 461, 392, 422, 299, 37, 448, 504, 118, 376, 265, 332, 72, 51, 238, 140, 128, 280, 37, 365, 402, 208, 208, 392, 164, 162, 225, 158, 438, 364, 37, 445, 332, 168, 158, 280, 101, 61, 321, 288, 318, 97, 208, 43, 263, 433, 452, 461, 360, 312, 256, 429, 222, 182, 390, 418, 365, 101, 228, 486, 28, 351, 390, 283, 61, 129, 192},
  {367, 139, 339, 211, 151, 102, 223, 102, 299, 394, 213, 199, 423, 166, 382, 86, 16, 459, 328, 219, 279, 151, 2, 458, 140, 264, 1, 168, 83, 174, 280, 70, 102, 299, 468, 321, 468, 350, 245, 22, 54, 423, 180, 94, 160, 151, 299, 435, 115, 409, 120, 218, 394, 459, 493, 256, 387, 346, 435, 168, 348, 498, 98, 280, 341, 102, 160, 140, 262, 497, 423, 160, 509, 199, 508, 218, 471, 183, 169, 279, 508, 508, 484, 305, 227, 403, 192, 256, 31, 49, 174, 120, 213, 486, 245, 341, 146, 102, 82, 511},
  {293, 379, 332, 2, 184, 512, 431, 161, 463, 503, 163, 173, 478, 508, 414, 187, 455, 33, 307, 333, 341, 408, 295, 463, 369, 16, 295, 45, 290, 240, 463, 8, 151, 115, 332, 290, 374, 414, 141, 67, 265, 123, 116, 151, 463, 455, 16, 141, 297, 294, 163, 321, 297, 56, 273, 463, 180, 448, 502, 43, 285, 455, 305, 332, 408, 249, 482, 497, 89, 123, 240, 436, 489, 270, 105, 389, 416, 118, 209, 331, 314, 193, 147, 307, 313, 512, 467, 37, 7, 220, 240, 290, 130, 253, 45, 130, 224, 217, 289, 440},
  {237, 127, 246, 371, 328, 5, 260, 318, 393, 341, 117, 506, 372, 10, 497, 350, 302, 331, 257, 72, 486, 150, 360, 350, 302, 51, 302, 350, 502, 207, 231, 273, 431, 244, 302, 64, 197, 173, 421, 442, 125, 224, 127, 173, 259, 393, 350, 359, 125, 328, 5, 303, 486, 454, 302, 303, 460, 251, 398, 505, 72, 180, 362, 5, 505, 138, 465, 431, 303, 467, 302, 467, 104, 323, 255, 350, 235, 33, 215, 259, 352, 60, 398, 495, 88, 277, 371, 136, 446, 125, 393, 359, 398, 312, 446, 409, 383, 32, 189, 90},
  {400, 404, 98, 386, 502, 47, 91, 49, 451, 424, 424, 273, 63, 443, 411, 424, 107, 36, 36, 69, 190, 355, 475, 416, 260, 425, 95, 250, 233, 365, 264, 85, 297, 102, 216, 403, 226, 260, 297, 223, 401, 323, 278, 332, 297, 49, 273, 323, 475, 424, 475, 352, 94, 355, 36, 129, 433, 151, 63, 367, 81, 18, 223, 1, 365, 10, 235, 451, 420, 181, 401, 234, 118, 451, 411, 359, 58, 251, 245, 328, 152, 8, 8, 445, 128, 348, 51, 443, 409, 107, 323, 479, 297, 499, 401, 297, 233, 425, 65, 260},
  {189, 104, 279, 464, 139, 43, 383, 93, 500, 243, 273, 374, 279, 45, 259, 454, 481, 142, 138, 39, 503, 195, 483, 256, 389, 458, 126, 129, 162, 358, 126, 242, 242, 113, 399, 394, 41, 74, 388, 294, 256, 156, 352, 42, 74, 411, 125, 512, 189, 374, 13, 457, 263, 305, 126, 31, 57, 138, 358, 454, 145, 40, 321, 305, 423, 486, 402, 9, 423, 195, 358, 475, 323, 125, 196, 503, 103, 171, 147, 490, 233, 162, 18, 275, 434, 457, 478, 45, 358, 319, 296, 171, 502, 323, 215, 145, 1, 242, 190, 374},
  {141, 457, 220, 107, 416, 107, 41, 141, 47, 340, 112, 475, 125, 357, 131, 196, 145, 502, 117, 164, 301, 62, 383, 199, 394, 348, 197, 199, 47, 152, 313, 55, 404, 181, 282, 42, 175, 38, 195, 29, 478, 262, 466, 126, 62, 313, 482, 357, 55, 229, 357, 262, 291, 509, 249, 394, 111, 145, 394, 490, 370, 292, 158, 55, 432, 152, 125, 310, 111, 394, 262, 394, 446, 394, 74, 357, 426, 494, 489, 449, 76, 417, 228, 69, 436, 299, 327, 125, 229, 460, 433, 451, 432, 58, 111, 187, 325, 19, 210, 506},
  {473, 506, 154, 273, 245, 490, 410, 342, 342, 107, 494, 142, 360, 414, 59, 440, 210, 462, 246, 425, 421, 190, 314, 132, 245, 403, 193, 312, 455, 293, 360, 421, 271, 107, 497, 504, 11, 210, 165, 396, 230, 332, 193, 412, 381, 190, 414, 381, 213, 228, 193, 293, 448, 29, 460, 460, 494, 252, 270, 11, 402, 65, 42, 193, 155, 92, 232, 113, 376, 41, 271, 147, 172, 497, 12, 193, 78, 92, 500, 323, 263, 245, 332, 471, 178, 461, 48, 223, 421, 356, 122, 375, 462, 402, 376, 228, 505, 190, 301, 255},
  {360, 168, 71, 38, 287, 489, 116, 24, 324, 508, 319, 10, 417, 500, 87, 106, 511, 130, 409, 3, 97, 426, 402, 63, 130, 70, 178, 70, 89, 489, 170, 356, 456, 423, 91, 435, 133, 501, 133, 375, 117, 170, 183, 280, 153, 334, 470, 269, 20, 272, 20, 63, 116, 45, 70, 197, 123, 402, 470, 489, 456, 462, 4, 154, 494, 70, 130, 49, 334, 97, 116, 294, 255, 70, 64, 458, 423, 168, 97, 282, 501, 489, 396, 180, 105, 142, 276, 396, 458, 501, 494, 294, 136, 198, 458, 362, 49, 187, 63, 187},
  {470, 76, 252, 231, 218, 327, 229, 456, 213, 482, 215, 434, 132, 55, 149, 492, 31, 112, 381, 85, 140, 240, 147, 383, 35, 484, 410, 147, 11, 215, 306, 383, 275, 486, 204, 66, 39, 115, 359, 441, 339, 448, 319, 169, 193, 24, 168, 482, 294, 115, 456, 222, 187, 21, 262, 196, 326, 310, 93, 34, 374, 194, 367, 11, 291, 449, 318, 172, 241, 215, 275, 342, 159, 97, 24, 78, 224, 19, 12, 70, 290, 471, 506, 11, 104, 43, 345, 222, 92, 383, 456, 510, 31, 33, 11, 248, 240, 290, 116, 3},
  {201, 135, 325, 512, 62, 478, 1, 247, 449, 491, 52, 439, 228, 283, 266, 108, 34, 314, 507, 9, 145, 284, 193, 190, 129, 19, 54, 271, 247, 117, 393, 314, 232, 108, 73, 73, 478, 81, 9, 222, 247, 268, 249, 97, 212, 54, 449, 404, 290, 451, 118, 34, 469, 18, 384, 314, 183, 10, 256, 5, 398, 202, 472, 331, 290, 507, 492, 434, 284, 170, 393, 357, 114, 1, 389, 394, 109, 436, 70, 266, 357, 108, 219, 60, 208, 496, 176, 478, 505, 357, 234, 505, 19, 123, 144, 290, 147, 219, 243, 478},
  {91, 223, 347, 499, 197, 491, 126, 80, 142, 391, 271, 12, 241, 423, 119, 235, 297, 219, 273, 443, 11, 43, 46, 14, 248, 304, 124, 405, 140, 476, 423, 120, 444, 279, 350, 258, 334, 296, 491, 452, 367, 506, 328, 201, 124, 80, 24, 508, 124, 405, 379, 367, 507, 279, 177, 142, 428, 247, 423, 390, 71, 124, 509, 472, 379, 214, 464, 390, 24, 304, 54, 39, 2, 291, 258, 430, 219, 230, 45, 199, 304, 120, 419, 111, 334, 489, 120, 3, 445, 269, 94, 464, 54, 187, 379, 177, 451, 121, 325, 125},
  {312, 456, 378, 177, 499, 255, 350, 17, 494, 207, 331, 257, 330, 272, 318, 102, 450, 70, 402, 271, 74, 207, 342, 378, 387, 430, 339, 144, 106, 368, 387, 318, 70, 125, 417, 105, 378, 102, 189, 361, 330, 17, 425, 236, 318, 92, 432, 74, 149, 387, 213, 402, 235, 181, 29, 484, 196, 463, 402, 272, 219, 213, 283, 126, 43, 66, 442, 41, 449, 102, 348, 184, 376, 235, 454, 417, 111, 250, 257, 430, 125, 484, 300, 281, 492, 312, 30, 144, 368, 235, 272, 207, 105, 157, 438, 102, 348, 430, 80, 205},
  {377, 159, 183, 263, 407, 30, 211, 386, 384, 319, 121, 253, 26, 421, 201, 419, 397, 144, 240, 180, 45, 329, 125, 453, 290, 267, 121, 63, 353, 77, 253, 107, 345, 498, 397, 493, 166, 267, 370, 219, 360, 360, 487, 74, 319, 107, 360, 243, 382, 156, 166, 338, 201, 447, 360, 94, 399, 232, 421, 386, 95, 3, 385, 360, 51, 228, 377, 360, 475, 267, 12, 112, 198, 236, 321, 282, 134, 333, 78, 405, 453, 301, 255, 209, 25, 456, 404, 225, 350, 405, 273, 94, 319, 82, 405, 70, 360, 386, 323, 360},
  {217, 117, 374, 7, 390, 374, 214, 294, 309, 94, 12, 476, 340, 474, 65, 112, 90, 374, 301, 287, 84, 53, 474, 374, 476, 244, 152, 244, 456, 20, 386, 53, 414, 89, 447, 268, 225, 386, 131, 417, 162, 345, 301, 240, 136, 345, 447, 244, 265, 244, 374, 474, 374, 110, 386, 100, 332, 79, 249, 301, 204, 281, 140, 26, 222, 99, 33, 121, 26, 233, 356, 421, 332, 366, 374, 466, 337, 97, 92, 172, 70, 421, 342, 411, 374, 62, 269, 449, 57, 291, 222, 225, 26, 387, 127, 172, 127, 323, 184, 345},
  {320, 259, 91, 468, 54, 251, 445, 327, 303, 313, 501, 20, 454, 327, 441, 355, 190, 313, 504, 394, 78, 348, 136, 175, 416, 364, 209, 251, 414, 347, 190, 327, 340, 286, 323, 121, 495, 7, 495, 422, 78, 169, 208, 441, 509, 124, 119, 364, 50, 251, 7, 97, 409, 28, 392, 364, 429, 110, 285, 175, 314, 45, 28, 262, 169, 338, 326, 495, 118, 124, 391, 257, 70, 392, 421, 262, 311, 361, 105, 3, 157, 495, 138, 313, 238, 125, 52, 124, 180, 314, 387, 434, 408, 471, 66, 202, 409, 10, 182, 84},
  {339, 5, 395, 212, 485, 457, 331, 121, 475, 401, 312, 327, 364, 217, 111, 425, 114, 292, 233, 185, 189, 77, 310, 217, 511, 44, 487, 294, 1, 436, 234, 452, 65, 37, 217, 244, 498, 294, 229, 505, 512, 181, 294, 436, 457, 457, 146, 436, 41, 52, 235, 234, 353, 196, 44, 327, 451, 254, 217, 338, 510, 339, 450, 364, 510, 512, 344, 129, 459, 270, 235, 229, 44, 505, 410, 105, 100, 459, 6, 217, 306, 62, 234, 219, 223, 97, 463, 9, 167, 487, 306, 312, 145, 439, 258, 275, 270, 167, 413, 312},
  {273, 198, 450, 18, 286, 119, 13, 339, 452, 405, 97, 186, 339, 405, 177, 325, 418, 339, 281, 307, 422, 494, 209, 362, 191, 97, 93, 379, 325, 442, 267, 22, 68, 405, 186, 174, 86, 379, 442, 77, 442, 267, 159, 257, 88, 498, 339, 303, 358, 201, 239, 383, 383, 183, 119, 180, 437, 114, 262, 209, 233, 283, 325, 134, 267, 358, 7, 143, 442, 383, 261, 493, 459, 292, 94, 67, 168, 512, 2, 427, 134, 379, 310, 370, 364, 195, 232, 325, 369, 358, 143, 93, 418, 285, 159, 201, 434, 141, 395, 459},
  {14, 242, 276, 453, 238, 121, 485, 420, 192, 173, 344, 479, 421, 311, 262, 232, 46, 92, 82, 434, 173, 161, 107, 332, 107, 404, 133, 396, 404, 332, 53, 285, 479, 53, 404, 286, 473, 245, 173, 491, 457, 359, 50, 404, 288, 277, 421, 133, 18, 219, 117, 154, 285, 67, 395, 395, 353, 355, 219, 242, 298, 508, 495, 344, 245, 46, 334, 53, 330, 151, 396, 355, 209, 491, 299, 410, 398, 266, 368, 25, 332, 424, 77, 269, 276, 279, 461, 133, 474, 449, 312, 365, 396, 149, 253, 315, 322, 365, 458, 365},
  {172, 490, 80, 359, 487, 475, 507, 181, 46, 358, 445, 317, 315, 378, 374, 27, 317, 439, 241, 395, 229, 201, 222, 315, 122, 353, 186, 229, 278, 95, 477, 304, 241, 333, 201, 165, 317, 353, 460, 90, 219, 482, 483, 141, 33, 263, 358, 33, 377, 85, 358, 439, 333, 391, 503, 263, 487, 108, 317, 358, 404, 335, 97, 286, 474, 95, 73, 122, 359, 161, 507, 480, 85, 76, 166, 98, 203, 474, 118, 178, 19, 272, 116, 230, 393, 433, 158, 172, 5, 353, 73, 496, 176, 461, 333, 186, 418, 358, 268, 430},
  {319, 510, 461, 191, 348, 493, 194, 40, 279, 250, 40, 222, 107, 233, 286, 493, 484, 107, 119, 305, 94, 250, 134, 439, 84, 446, 204, 382, 431, 305, 31, 79, 279, 179, 211, 374, 72, 65, 363, 6, 110, 378, 351, 185, 305, 26, 484, 153, 94, 382, 65, 142, 130, 426, 474, 493, 455, 133, 94, 157, 401, 49, 258, 492, 439, 94, 250, 68, 68, 237, 492, 431, 303, 204, 261, 232, 484, 362, 46, 94, 84, 334, 461, 473, 218, 131, 419, 258, 134, 431, 332, 232, 479, 128, 250, 65, 493, 189, 431, 94},
  {125, 340, 426, 19, 325, 23, 364, 104, 426, 170, 125, 320, 142, 242, 273, 376, 171, 424, 157, 88, 329, 432, 128, 396, 479, 376, 113, 128, 326, 179, 242, 154, 316, 363, 366, 114, 432, 285, 202, 205, 351, 396, 436, 158, 337, 13, 253, 486, 242, 69, 366, 253, 13, 27, 99, 350, 243, 159, 8, 380, 389, 58, 43, 376, 376, 475, 80, 424, 215, 7, 222, 33, 249, 285, 452, 40, 52, 265, 190, 303, 315, 475, 179, 461, 301, 161, 9, 230, 34, 424, 161, 314, 314, 195, 426, 161, 389, 408, 456, 283},
  {428, 112, 320, 133, 262, 75, 308, 502, 510, 312, 496, 213, 361, 502, 352, 509, 278, 86, 253, 184, 86, 24, 22, 147, 109, 38, 184, 205, 155, 315, 175, 86, 509, 213, 175, 90, 43, 206, 86, 51, 91, 86, 18, 385, 486, 385, 8, 253, 24, 445, 75, 279, 24, 241, 235, 34, 435, 401, 236, 91, 422, 172, 343, 43, 9, 184, 328, 298, 388, 253, 332, 318, 312, 208, 340, 509, 97, 278, 487, 147, 235, 24, 213, 318, 149, 401, 459, 319, 130, 430, 150, 318, 262, 249, 213, 86, 501, 488, 16, 361},
  {247, 217, 423, 345, 17, 502, 457, 277, 191, 428, 137, 19, 123, 258, 83, 370, 91, 243, 44, 327, 19, 502, 297, 168, 509, 34, 50, 56, 51, 238, 502, 465, 370, 277, 362, 484, 443, 31, 420, 171, 4, 114, 486, 28, 4, 509, 21, 420, 123, 103, 158, 18, 467, 407, 389, 39, 201, 115, 258, 342, 86, 319, 508, 443, 1, 420, 64, 272, 234, 19, 194, 158, 291, 191, 407, 137, 258, 465, 252, 502, 225, 218, 465, 217, 460, 127, 27, 194, 137, 39, 493, 487, 194, 57, 362, 247, 362, 502, 252, 62},
  {450, 69, 257, 441, 438, 400, 432, 271, 302, 141, 467, 180, 296, 314, 161, 506, 228, 382, 128, 296, 188, 435, 349, 325, 119, 197, 378, 353, 207, 399, 480, 15, 491, 248, 17, 492, 110, 293, 221, 296, 368, 321, 51, 451, 321, 188, 17, 212, 413, 498, 73, 413, 191, 320, 413, 467, 16, 8, 129, 442, 498, 97, 402, 229, 166, 261, 314, 64, 44, 400, 321, 5, 116, 265, 25, 112, 286, 14, 240, 413, 167, 298, 287, 28, 283, 242, 462, 221, 321, 293, 202, 424, 228, 60, 287, 180, 129, 424, 100, 232},
  {215, 78, 82, 417, 169, 90, 10, 191, 4, 429, 356, 364, 432, 347, 194, 167, 281, 214, 487, 94, 144, 326, 200, 281, 314, 313, 383, 28, 268, 299, 350, 457, 222, 110, 268, 357, 347, 40, 326, 426, 299, 275, 465, 153, 121, 35, 379, 191, 214, 180, 326, 434, 432, 47, 281, 368, 271, 299, 313, 383, 429, 370, 230, 350, 279, 299, 42, 385, 28, 457, 326, 356, 193, 110, 23, 347, 81, 313, 197, 393, 439, 347, 81, 242, 512, 198, 363, 393, 393, 379, 475, 144, 275, 501, 16, 467, 367, 432, 161, 313},
  {348, 128, 163, 265, 378, 329, 390, 268, 95, 413, 378, 40, 86, 282, 415, 375, 508, 197, 184, 170, 249, 498, 466, 375, 297, 367, 73, 466, 473, 139, 228, 500, 33, 505, 410, 206, 335, 335, 394, 308, 95, 73, 139, 108, 329, 95, 441, 139, 155, 116, 83, 285, 1, 244, 505, 139, 68, 59, 454, 273, 13, 355, 127, 498, 228, 329, 357, 183, 203, 492, 367, 207, 50, 296, 14, 197, 370, 254, 453, 139, 260, 33, 112, 379, 274, 265, 341, 33, 95, 282, 454, 358, 216, 21, 13, 233, 140, 207, 134, 454},
  {402, 302, 234, 503, 418, 88, 361, 212, 94, 408, 354, 339, 111, 246, 428, 353, 37, 116, 75, 208, 273, 189, 86, 17, 371, 61, 182, 3, 189, 280, 309, 467, 112, 371, 395, 294, 500, 467, 192, 14, 50, 417, 457, 122, 176, 165, 477, 456, 309, 144, 455, 324, 500, 315, 371, 334, 226, 455, 255, 428, 312, 95, 478, 88, 75, 270, 63, 273, 488, 17, 454, 213, 355, 467, 109, 239, 61, 447, 244, 162, 61, 2, 495, 119, 251, 65, 474, 508, 500, 267, 55, 203, 227, 181, 454, 104, 46, 8, 408, 77},
  {490, 148, 122, 79, 353, 334, 320, 172, 351, 474, 182, 299, 69, 351, 28, 290, 153, 153, 339, 63, 132, 505, 186, 155, 465, 456, 104, 351, 112, 319, 385, 100, 134, 138, 28, 505, 254, 238, 177, 472, 155, 290, 155, 256, 334, 246, 499, 502, 68, 302, 465, 124, 483, 71, 351, 319, 488, 263, 437, 112, 351, 220, 465, 456, 186, 153, 93, 351, 84, 206, 378, 252, 391, 203, 95, 319, 456, 463, 103, 481, 45, 124, 124, 488, 319, 96, 298, 351, 299, 112, 104, 481, 351, 176, 450, 385, 225, 64, 254, 351},
  {352, 369, 19, 153, 27, 128, 74, 396, 73, 266, 223, 207, 422, 2, 378, 285, 355, 487, 199, 389, 208, 381, 296, 345, 2, 433, 385, 140, 281, 4, 433, 171, 447, 472, 30, 237, 337, 437, 101, 64, 502, 162, 109, 285, 128, 45, 319, 498, 73, 188, 345, 76, 158, 491, 237, 304, 173, 137, 224, 507, 406, 510, 49, 247, 208, 478, 438, 340, 319, 140, 472, 82, 242, 502, 140, 215, 29, 98, 128, 154, 14, 77, 291, 417, 377, 369, 446, 183, 478, 406, 247, 472, 22, 418, 487, 215, 443, 2, 64, 487},
  {345, 275, 473, 131, 111, 114, 483, 70, 352, 140, 48, 393, 84, 20, 189, 135, 352, 352, 509, 384, 200, 402, 508, 84, 390, 393, 377, 184, 244, 133, 160, 150, 466, 175, 39, 288, 302, 82, 466, 270, 274, 393, 272, 190, 352, 244, 459, 84, 181, 96, 307, 244, 357, 94, 24, 247, 361, 54, 352, 332, 393, 466, 489, 441, 483, 455, 57, 352, 162, 290, 96, 68, 363, 466, 401, 1, 124, 457, 421, 184, 200, 278, 377, 98, 415, 483, 152, 218, 399, 140, 105, 269, 140, 196, 68, 329, 474, 173, 47, 165},
  {126, 9, 237, 104, 5, 291, 268, 87, 291, 33, 69, 98, 424, 111, 14, 68, 312, 369, 166, 135, 222, 154, 154, 473, 392, 29, 109, 196, 122, 471, 424, 466, 471, 251, 244, 511, 29, 356, 477, 190, 411, 356, 20, 372, 170, 85, 453, 453, 473, 24, 98, 411, 128, 24, 94, 500, 62, 84, 436, 196, 157, 146, 390, 291, 453, 496, 510, 330, 287, 94, 328, 368, 78, 244, 309, 146, 226, 151, 28, 411, 51, 411, 224, 458, 380, 454, 263, 437, 66, 392, 291, 39, 122, 147, 356, 62, 21, 160, 417, 139},
  {49, 373, 300, 189, 347, 171, 373, 510, 144, 201, 310, 54, 80, 146, 510, 54, 104, 385, 185, 263, 316, 336, 70, 427, 510, 166, 166, 243, 21, 38, 498, 202, 191, 142, 70, 192, 240, 498, 47, 453, 19, 47, 98, 421, 191, 191, 171, 166, 144, 450, 70, 495, 373, 38, 191, 278, 454, 496, 144, 314, 423, 284, 171, 445, 314, 438, 463, 228, 352, 166, 468, 385, 32, 54, 370, 414, 138, 110, 505, 301, 373, 171, 478, 147, 106, 410, 24, 352, 385, 171, 498, 449, 248, 373, 140, 47, 314, 110, 106, 223},
  {453, 160, 27, 397, 498, 78, 339, 202, 60, 15, 383, 66, 469, 224, 140, 414, 462, 28, 400, 325, 224, 462, 255, 364, 364, 164, 246, 364, 19, 423, 114, 401, 264, 511, 202, 425, 212, 318, 164, 392, 181, 92, 446, 502, 423, 224, 78, 423, 436, 224, 170, 386, 66, 413, 122, 69, 233, 204, 469, 318, 234, 326, 210, 304, 28, 364, 118, 10, 255, 436, 202, 225, 398, 462, 364, 181, 169, 381, 335, 325, 202, 92, 326, 286, 22, 332, 175, 122, 32, 364, 255, 401, 239, 365, 342, 10, 414, 469, 239, 242},
  {503, 252, 458, 427, 204, 282, 497, 200, 507, 403, 342, 345, 297, 297, 489, 357, 252, 156, 186, 121, 342, 405, 410, 282, 357, 489, 15, 321, 291, 127, 282, 427, 321, 403, 169, 480, 395, 200, 33, 144, 116, 282, 211, 312, 409, 310, 355, 297, 433, 162, 323, 232, 169, 87, 433, 427, 413, 452, 138, 261, 438, 131, 86, 216, 88, 508, 105, 103, 501, 376, 282, 260, 469, 357, 154, 397, 347, 329, 163, 128, 507, 338, 265, 506, 308, 189, 121, 44, 138, 206, 297, 92, 240, 248, 297, 282, 138, 210, 480, 452},
  {280, 20, 249, 275, 453, 80, 157, 400, 164, 18, 329, 249, 31, 80, 369, 51, 349, 474, 272, 80, 105, 180, 424, 466, 428, 182, 51, 387, 183, 13, 171, 234, 13, 356, 180, 215, 155, 66, 51, 433, 275, 512, 128, 208, 80, 31, 136, 349, 329, 136, 31, 466, 329, 57, 66, 87, 204, 349, 503, 245, 493, 68, 337, 231, 302, 164, 341, 365, 316, 365, 215, 486, 282, 46, 223, 316, 74, 397, 247, 400, 472, 302, 392, 418, 453, 500, 374, 269, 171, 68, 473, 303, 453, 211, 43, 164, 484, 278, 472, 83},
  {509, 278, 454, 39, 364, 38, 200, 144, 442, 101, 216, 470, 442, 144, 398, 340, 135, 169, 188, 501, 59, 486, 263, 504, 147, 346, 398, 476, 476, 274, 263, 454, 263, 388, 346, 17, 501, 416, 470, 281, 160, 70, 380, 33, 247, 274, 495, 476, 65, 345, 396, 486, 274, 105, 374, 361, 405, 56, 179, 47, 115, 362, 312, 278, 346, 239, 388, 147, 308, 147, 17, 38, 199, 17, 49, 486, 342, 180, 17, 278, 37, 53, 66, 115, 190, 475, 145, 329, 322, 245, 144, 210, 274, 194, 255, 374, 188, 96, 176, 329},
  {264, 338, 365, 173, 212, 15, 424, 30, 156, 74, 208, 25, 36, 32, 15, 465, 41, 268, 267, 506, 511, 30, 450, 236, 36, 226, 492, 490, 510, 115, 490, 115, 505, 450, 47, 208, 208, 88, 364, 275, 1, 202, 449, 409, 412, 351, 63, 194, 5, 394, 47, 47, 47, 309, 88, 224, 472, 202, 30, 511, 375, 379, 66, 156, 342, 30, 262, 496, 476, 32, 166, 16, 165, 134, 56, 505, 214, 415, 211, 156, 166, 15, 351, 66, 417, 358, 101, 339, 247, 476, 221, 236, 268, 311, 492, 320, 310, 25, 103, 375},
  {174, 432, 358, 373, 11, 455, 417, 372, 472, 1, 124, 63, 167, 266, 263, 331, 202, 422, 100, 292, 110, 372, 188, 372, 162, 202, 44, 162, 472, 405, 331, 395, 124, 6, 491, 146, 71, 153, 186, 83, 313, 291, 305, 264, 331, 186, 124, 396, 71, 494, 28, 247, 57, 73, 489, 494, 39, 489, 346, 202, 188, 243, 348, 95, 422, 444, 29, 76, 313, 275, 312, 455, 60, 422, 398, 18, 241, 315, 142, 455, 245, 200, 153, 145, 95, 101, 122, 266, 305, 313, 95, 140, 458, 442, 305, 402, 287, 131, 120, 305},
  {229, 382, 184, 157, 492, 363, 317, 197, 262, 211, 285, 404, 502, 21, 278, 317, 320, 149, 291, 17, 488, 363, 100, 363, 327, 502, 341, 124, 43, 270, 255, 426, 352, 458, 58, 233, 376, 237, 296, 301, 60, 255, 93, 345, 376, 116, 178, 376, 128, 166, 14, 60, 388, 236, 341, 184, 3, 3, 184, 197, 51, 408, 15, 334, 327, 425, 421, 388, 4, 92, 140, 124, 21, 43, 507, 140, 440, 161, 486, 488, 426, 163, 502, 349, 395, 356, 102, 426, 471, 425, 197, 2, 341, 467, 334, 109, 402, 453, 351, 402},
  {232, 210, 492, 198, 431, 111, 145, 466, 180, 17, 328, 41, 403, 69, 422, 23, 197, 226, 399, 144, 92, 128, 41, 128, 403, 199, 211, 65, 422, 168, 381, 69, 1, 128, 507, 35, 469, 136, 199, 248, 403, 142, 224, 92, 215, 245, 445, 11, 11, 491, 381, 189, 65, 497, 96, 53, 102, 432, 481, 304, 96, 389, 507, 150, 182, 23, 403, 260, 497, 469, 150, 69, 286, 507, 99, 41, 39, 377, 267, 374, 254, 466, 403, 166, 34, 150, 177, 343, 343, 398, 346, 363, 346, 133, 294, 232, 456, 433, 432, 504},
  {510, 7, 107, 134, 315, 253, 43, 10, 126, 433, 512, 411, 208, 488, 392, 446, 505, 223, 271, 488, 497, 449, 502, 317, 411, 86, 94, 392, 501, 355, 45, 64, 437, 382, 449, 84, 367, 72, 185, 178, 14, 355, 469, 407, 50, 314, 468, 352, 133, 470, 474, 14, 45, 168, 266, 299, 324, 389, 152, 190, 437, 111, 329, 87, 458, 382, 164, 152, 314, 14, 411, 156, 264, 71, 120, 175, 447, 346, 143, 512, 133, 16, 382, 41, 29, 301, 161, 72, 46, 114, 158, 95, 219, 74, 208, 114, 245, 87, 469, 339},
  {481, 84, 287, 200, 282, 421, 257, 227, 234, 459, 146, 417, 240, 417, 329, 165, 9, 253, 325, 372, 378, 410, 88, 227, 179, 187, 415, 59, 344, 234, 278, 279, 179, 196, 92, 279, 435, 459, 163, 45, 114, 146, 195, 324, 92, 23, 114, 305, 491, 393, 380, 179, 382, 199, 80, 76, 365, 383, 221, 451, 22, 275, 143, 34, 227, 114, 432, 443, 94, 380, 502, 417, 339, 210, 295, 346, 495, 303, 495, 346, 189, 410, 134, 213, 507, 351, 187, 219, 109, 417, 30, 390, 393, 99, 344, 305, 369, 57, 366, 393},
  {268, 492, 488, 20, 321, 175, 421, 357, 511, 479, 154, 202, 242, 294, 343, 288, 28, 210, 460, 153, 164, 139, 51, 294, 117, 510, 440, 57, 177, 467, 357, 240, 169, 212, 43, 80, 28, 166, 504, 99, 51, 464, 2, 307, 154, 28, 43, 424, 352, 57, 203, 62, 472, 197, 90, 486, 110, 446, 486, 186, 253, 352, 330, 117, 139, 169, 50, 139, 498, 428, 412, 19, 235, 430, 431, 93, 461, 175, 268, 203, 224, 144, 139, 42, 181, 281, 389, 43, 113, 387, 472, 124, 511, 331, 486, 352, 202, 164, 314, 28},
  {267, 66, 226, 259, 504, 337, 61, 427, 206, 162, 451, 43, 233, 440, 342, 491, 458, 245, 224, 293, 143, 67, 162, 195, 94, 206, 260, 399, 143, 245, 162, 90, 30, 157, 260, 314, 224, 18, 456, 336, 84, 231, 104, 291, 279, 399, 446, 241, 440, 460, 33, 499, 224, 281, 491, 307, 50, 66, 127, 281, 231, 229, 344, 184, 224, 482, 368, 427, 373, 127, 427, 420, 278, 351, 67, 440, 94, 399, 95, 511, 451, 288, 394, 282, 375, 2, 64, 368, 90, 491, 2, 440, 13, 480, 202, 143, 337, 143, 359, 30},
  {383, 150, 59, 165, 103, 397, 54, 451, 183, 495, 183, 39, 451, 264, 229, 226, 168, 278, 108, 373, 426, 197, 19, 192, 67, 144, 213, 508, 213, 154, 461, 96, 138, 391, 21, 5, 55, 352, 225, 164, 39, 126, 169, 69, 168, 148, 483, 67, 353, 426, 39, 325, 119, 191, 463, 266, 212, 276, 55, 425, 218, 297, 466, 310, 183, 226, 320, 126, 19, 83, 231, 51, 69, 425, 40, 351, 84, 443, 236, 148, 480, 119, 391, 233, 180, 310, 239, 226, 330, 109, 425, 247, 2, 161, 119, 183, 247, 477, 167, 197},
  {85, 465, 342, 425, 350, 264, 345, 463, 170, 278, 388, 407, 201, 499, 184, 46, 81, 431, 384, 460, 99, 320, 190, 247, 427, 451, 114, 451, 482, 333, 80, 274, 19, 509, 315, 122, 134, 264, 14, 455, 144, 191, 467, 374, 499, 43, 184, 499, 321, 107, 144, 510, 15, 189, 49, 374, 242, 162, 463, 427, 463, 406, 368, 165, 247, 459, 30, 226, 107, 286, 247, 448, 397, 144, 313, 49, 356, 308, 460, 286, 395, 25, 388, 409, 182, 69, 275, 510, 97, 299, 470, 463, 333, 392, 123, 407, 482, 123, 335, 238},
  {72, 411, 406, 285, 413, 67, 278, 96, 340, 8, 422, 318, 273, 473, 179, 194, 177, 348, 51, 405, 331, 362, 44, 289, 331, 119, 53, 227, 146, 164, 289, 252, 494, 425, 425, 262, 227, 247, 201, 289, 2, 74, 234, 459, 156, 76, 435, 421, 301, 61, 338, 488, 459, 362, 362, 443, 19, 375, 316, 316, 282, 227, 248, 189, 316, 124, 457, 419, 156, 345, 76, 418, 227, 418, 378, 227, 373, 99, 406, 418, 156, 207, 360, 455, 152, 333, 401, 179, 469, 207, 301, 494, 28, 472, 26, 146, 306, 74, 365, 67},
  {132, 265, 104, 395, 55, 4, 296, 228, 273, 145, 264, 432, 115, 481, 97, 432, 356, 318, 231, 411, 5, 7, 5, 335, 244, 156, 228, 169, 7, 273, 296, 481, 184, 219, 296, 434, 60, 481, 295, 44, 30, 145, 186, 337, 96, 145, 456, 402, 60, 432, 467, 71, 481, 35, 219, 156, 344, 270, 126, 184, 87, 432, 218, 318, 456, 464, 67, 91, 132, 490, 331, 344, 58, 288, 91, 423, 445, 138, 477, 493, 126, 177, 432, 95, 444, 415, 272, 91, 203, 203, 479, 145, 57, 380, 466, 58, 216, 356, 404, 432},
  {306, 137, 376, 507, 452, 356, 289, 187, 137, 215, 126, 191, 137, 323, 6, 447, 345, 480, 423, 86, 247, 47, 139, 114, 413, 318, 253, 427, 260, 6, 356, 119, 247, 154, 207, 300, 157, 36, 137, 476, 334, 334, 338, 499, 18, 407, 325, 280, 325, 236, 126, 165, 404, 306, 301, 325, 141, 98, 356, 368, 343, 444, 44, 356, 114, 137, 340, 318, 407, 480, 325, 283, 449, 378, 240, 401, 99, 205, 466, 89, 411, 407, 247, 454, 250, 318, 208, 435, 165, 435, 343, 29, 75, 353, 301, 368, 20, 306, 61, 376},
  {421, 262, 344, 474, 150, 413, 469, 425, 399, 65, 463, 81, 213, 122, 165, 2, 477, 391, 104, 459, 230, 213, 403, 52, 434, 213, 234, 391, 234, 158, 65, 463, 315, 79, 65, 24, 102, 425, 252, 239, 277, 320, 428, 55, 475, 40, 28, 160, 177, 59, 100, 476, 277, 311, 218, 160, 351, 437, 413, 500, 302, 8, 490, 281, 285, 108, 70, 338, 65, 28, 494, 37, 486, 146, 45, 17, 31, 209, 313, 239, 184, 239, 475, 452, 366, 383, 307, 476, 297, 187, 277, 437, 500, 182, 17, 326, 218, 230, 277, 158},
  {423, 62, 369, 479, 114, 37, 29, 176, 397, 487, 360, 83, 455, 33, 137, 339, 487, 414, 203, 347, 241, 282, 458, 116, 227, 46, 382, 429, 357, 422, 91, 131, 14, 312, 78, 441, 330, 24, 147, 407, 429, 304, 17, 71, 207, 279, 243, 195, 203, 46, 462, 277, 354, 422, 354, 67, 278, 450, 91, 163, 176, 26, 241, 91, 5, 339, 147, 357, 267, 98, 14, 131, 140, 26, 360, 431, 393, 134, 72, 414, 252, 363, 492, 442, 462, 311, 124, 382, 434, 354, 450, 34, 147, 236, 98, 388, 74, 312, 211, 429},
  {343, 418, 31, 181, 23, 76, 75, 382, 138, 14, 111, 310, 249, 182, 293, 333, 398, 211, 389, 382, 361, 423, 76, 127, 160, 333, 71, 310, 333, 426, 66, 32, 46, 361, 227, 247, 343, 46, 398, 202, 278, 494, 311, 426, 76, 373, 213, 488, 333, 32, 373, 322, 369, 77, 227, 2, 373, 444, 89, 455, 151, 35, 339, 427, 309, 76, 426, 374, 468, 310, 488, 94, 314, 249, 272, 2, 130, 125, 464, 194, 286, 374, 426, 292, 131, 486, 405, 76, 310, 250, 76, 301, 160, 144, 223, 260, 71, 373, 380, 455},
  {94, 412, 468, 130, 451, 487, 360, 446, 307, 458, 243, 472, 88, 273, 314, 209, 69, 34, 366, 156, 63, 382, 364, 472, 4, 428, 313, 209, 397, 313, 25, 256, 337, 26, 428, 466, 93, 64, 307, 418, 74, 80, 271, 199, 275, 235, 93, 252, 350, 256, 88, 497, 144, 70, 139, 155, 316, 390, 102, 331, 337, 114, 273, 209, 350, 472, 110, 487, 157, 113, 446, 1, 384, 487, 90, 122, 436, 20, 436, 364, 221, 428, 94, 308, 464, 182, 73, 159, 497, 275, 397, 26, 287, 274, 29, 395, 467, 94, 78, 467},
  {25, 505, 231, 155, 309, 126, 492, 201, 486, 347, 37, 163, 67, 444, 77, 238, 347, 311, 208, 67, 21, 347, 422, 225, 222, 422, 402, 450, 299, 87, 112, 504, 486, 398, 178, 211, 181, 163, 384, 269, 297, 212, 84, 447, 384, 297, 36, 260, 303, 11, 225, 489, 239, 463, 181, 267, 448, 256, 112, 260, 501, 373, 226, 316, 413, 37, 412, 201, 21, 489, 239, 361, 422, 163, 320, 422, 302, 178, 77, 255, 489, 317, 212, 10, 422, 275, 82, 466, 21, 225, 21, 112, 61, 68, 164, 244, 499, 277, 450, 65},
  {439, 146, 446, 136, 53, 174, 167, 329, 114, 321, 413, 485, 413, 439, 162, 271, 285, 100, 364, 205, 14, 271, 14, 370, 197, 329, 147, 55, 413, 255, 72, 176, 488, 176, 412, 57, 88, 381, 369, 298, 413, 333, 19, 224, 285, 83, 271, 25, 100, 55, 147, 369, 488, 502, 280, 240, 293, 405, 170, 120, 117, 372, 162, 369, 369, 439, 239, 334, 348, 472, 448, 285, 228, 198, 37, 72, 400, 383, 448, 370, 421, 89, 36, 284, 463, 501, 196, 413, 147, 306, 242, 32, 14, 115, 391, 284, 207, 421, 409, 274},
  {427, 451, 137, 124, 209, 347, 316, 189, 374, 316, 450, 489, 350, 235, 78, 250, 316, 468, 149, 206, 31, 55, 257, 213, 343, 259, 409, 455, 63, 123, 364, 66, 205, 316, 364, 316, 450, 235, 455, 320, 183, 274, 28, 276, 43, 164, 497, 401, 200, 347, 183, 419, 213, 278, 314, 316, 52, 271, 287, 291, 226, 72, 410, 21, 150, 259, 372, 292, 63, 48, 66, 381, 493, 329, 1, 63, 394, 256, 107, 6, 291, 154, 34, 410, 102, 425, 306, 304, 146, 239, 276, 31, 347, 155, 200, 316, 114, 350, 383, 78},
  {59, 11, 232, 415, 337, 1, 288, 41, 118, 81, 107, 188, 188, 232, 340, 332, 415, 358, 150, 311, 68, 303, 42, 373, 14, 344, 205, 270, 255, 345, 415, 293, 260, 508, 243, 404, 265, 396, 233, 173, 285, 18, 177, 299, 355, 205, 160, 98, 332, 401, 401, 355, 345, 322, 488, 255, 372, 235, 510, 401, 236, 414, 441, 323, 255, 397, 311, 265, 436, 344, 52, 281, 453, 344, 384, 285, 221, 202, 345, 316, 140, 319, 319, 86, 265, 359, 305, 281, 52, 485, 70, 90, 285, 73, 281, 391, 332, 415, 203, 265},
  {121, 325, 2, 465, 306, 183, 265, 421, 285, 213, 73, 252, 280, 72, 115, 373, 64, 460, 461, 182, 382, 356, 378, 443, 412, 460, 443, 467, 356, 208, 512, 188, 354, 47, 198, 22, 307, 397, 78, 86, 382, 460, 409, 194, 73, 427, 137, 27, 503, 44, 1, 443, 18, 427, 115, 337, 97, 428, 410, 26, 293, 77, 474, 85, 188, 143, 386, 285, 243, 12, 100, 429, 362, 459, 419, 269, 228, 487, 39, 280, 100, 344, 373, 51, 86, 488, 59, 344, 16, 330, 307, 72, 73, 8, 397, 299, 475, 188, 49, 34},
  {123, 495, 204, 140, 214, 24, 104, 149, 402, 97, 322, 113, 326, 447, 275, 189, 226, 503, 189, 235, 116, 160, 512, 65, 24, 301, 46, 447, 381, 197, 426, 292, 461, 387, 436, 119, 127, 372, 473, 110, 149, 59, 75, 360, 145, 503, 389, 336, 360, 93, 402, 473, 411, 140, 57, 59, 424, 231, 213, 14, 462, 274, 334, 214, 235, 418, 272, 426, 6, 462, 349, 462, 479, 29, 76, 365, 144, 507, 205, 322, 183, 381, 221, 174, 37, 239, 398, 255, 260, 29, 166, 24, 349, 197, 235, 235, 17, 381, 180, 418},
  {75, 381, 72, 333, 166, 187, 105, 267, 130, 106, 30, 85, 259, 286, 431, 418, 231, 309, 248, 453, 239, 119, 423, 393, 484, 54, 423, 374, 337, 475, 247, 195, 265, 209, 8, 393, 393, 177, 349, 211, 366, 286, 358, 397, 287, 20, 212, 259, 366, 242, 279, 452, 393, 350, 195, 65, 96, 305, 41, 20, 431, 187, 189, 374, 503, 313, 90, 313, 76, 287, 313, 265, 297, 393, 335, 203, 463, 473, 319, 40, 171, 416, 75, 422, 28, 78, 318, 431, 403, 87, 339, 326, 416, 239, 339, 287, 50, 393, 341, 300},
  {505, 34, 225, 309, 48, 163, 203, 248, 33, 417, 105, 377, 185, 35, 301, 295, 237, 198, 318, 417, 401, 185, 469, 324, 370, 485, 237, 150, 120, 417, 240, 417, 185, 51, 209, 56, 269, 486, 237, 195, 296, 2, 188, 131, 498, 61, 362, 185, 404, 315, 51, 336, 248, 480, 498, 77, 215, 178, 87, 185, 450, 196, 122, 22, 221, 307, 353, 185, 496, 379, 185, 354, 275, 124, 51, 35, 12, 241, 230, 257, 237, 362, 118, 412, 349, 491, 205, 22, 347, 352, 185, 214, 237, 51, 118, 394, 203, 325, 73, 200},
  {208, 180, 353, 22, 50, 137, 58, 239, 101, 264, 239, 21, 303, 442, 3, 83, 494, 179, 333, 289, 73, 504, 372, 3, 272, 464, 172, 6, 372, 390, 266, 372, 415, 491, 313, 9, 390, 313, 71, 224, 21, 399, 175, 230, 501, 354, 351, 415, 142, 217, 21, 288, 501, 252, 288, 101, 310, 258, 36, 354, 6, 388, 498, 83, 415, 411, 77, 464, 415, 288, 48, 441, 7, 239, 10, 255, 184, 27, 251, 351, 311, 21, 451, 363, 431, 135, 92, 254, 100, 21, 399, 217, 124, 386, 372, 462, 119, 511, 292, 71},
  {411, 342, 68, 184, 134, 229, 111, 19, 429, 330, 339, 387, 91, 254, 127, 219, 371, 254, 107, 421, 91, 227, 47, 152, 317, 330, 336, 108, 204, 288, 472, 336, 6, 445, 371, 440, 296, 271, 371, 399, 371, 107, 68, 244, 345, 412, 123, 8, 504, 489, 412, 387, 387, 19, 171, 345, 63, 457, 459, 288, 235, 392, 294, 351, 371, 34, 24, 306, 480, 76, 308, 383, 35, 412, 292, 115, 167, 123, 157, 191, 190, 387, 45, 474, 337, 176, 431, 371, 182, 127, 330, 254, 308, 71, 324, 371, 280, 445, 69, 241},
  {7, 208, 459, 314, 147, 106, 290, 506, 468, 350, 236, 178, 207, 7, 300, 191, 224, 224, 193, 483, 115, 141, 30, 314, 125, 308, 57, 505, 224, 498, 506, 7, 54, 141, 479, 353, 80, 423, 468, 378, 224, 429, 233, 234, 162, 260, 413, 14, 191, 413, 135, 295, 242, 345, 141, 323, 51, 415, 198, 468, 494, 42, 331, 198, 7, 468, 245, 135, 23, 477, 384, 152, 381, 324, 57, 153, 125, 94, 432, 314, 413, 260, 477, 399, 120, 244, 172, 187, 157, 191, 67, 162, 51, 252, 505, 229, 374, 178, 284, 15},
  {239, 323, 186, 141, 401, 259, 496, 72, 136, 327, 435, 140, 509, 510, 138, 47, 405, 103, 143, 236, 134, 8, 180, 303, 405, 354, 496, 158, 148, 26, 140, 192, 64, 504, 496, 4, 246, 405, 97, 478, 283, 405, 314, 443, 211, 192, 170, 19, 42, 29, 350, 239, 496, 51, 439, 29, 283, 85, 501, 433, 318, 24, 256, 420, 215, 376, 315, 246, 405, 278, 405, 326, 485, 511, 425, 119, 76, 164, 75, 227, 158, 106, 97, 73, 43, 186, 334, 326, 227, 385, 455, 170, 119, 259, 303, 508, 13, 180, 385, 180},
  {321, 270, 289, 484, 298, 392, 488, 114, 150, 353, 162, 463, 4, 236, 86, 299, 67, 222, 285, 510, 162, 89, 36, 299, 360, 309, 499, 287, 128, 128, 121, 334, 309, 474, 426, 195, 463, 224, 158, 492, 476, 177, 53, 21, 426, 290, 338, 41, 27, 67, 162, 236, 497, 482, 106, 187, 158, 180, 271, 41, 416, 309, 37, 338, 338, 162, 392, 398, 398, 474, 89, 453, 6, 431, 268, 299, 470, 287, 419, 353, 365, 55, 309, 419, 303, 480, 53, 276, 56, 162, 426, 74, 36, 174, 181, 285, 19, 460, 109, 353},
  {76, 448, 177, 348, 94, 498, 261, 408, 215, 451, 249, 288, 114, 27, 11, 199, 429, 420, 165, 171, 24, 80, 37, 465, 397, 150, 7, 248, 481, 84, 85, 113, 441, 150, 101, 241, 465, 124, 395, 462, 147, 288, 179, 162, 411, 483, 238, 178, 240, 504, 91, 91, 178, 496, 289, 222, 236, 347, 289, 147, 114, 209, 105, 199, 482, 113, 277, 395, 462, 63, 400, 347, 248, 330, 269, 43, 290, 91, 260, 408, 441, 395, 435, 425, 458, 147, 320, 451, 341, 85, 395, 347, 435, 423, 345, 27, 238, 360, 214, 104},
  {395, 107, 133, 295, 131, 210, 230, 336, 173, 469, 206, 33, 143, 383, 102, 180, 79, 59, 441, 248, 501, 507, 236, 274, 366, 440, 356, 156, 76, 156, 317, 43, 420, 28, 469, 248, 107, 33, 284, 21, 15, 20, 111, 167, 383, 317, 120, 228, 298, 284, 510, 351, 48, 233, 292, 507, 67, 371, 284, 363, 93, 436, 255, 341, 481, 134, 193, 507, 166, 163, 363, 142, 263, 356, 52, 236, 188, 2, 216, 59, 457, 364, 61, 31, 167, 196, 118, 79, 420, 317, 33, 79, 118, 303, 61, 340, 118, 118, 427, 51},
  {375, 98, 313, 232, 369, 338, 480, 131, 198, 251, 19, 78, 176, 128, 181, 128, 144, 470, 5, 23, 428, 495, 495, 268, 495, 486, 433, 272, 131, 425, 19, 375, 359, 52, 271, 312, 162, 347, 124, 192, 98, 176, 284, 480, 508, 395, 428, 417, 338, 425, 390, 425, 198, 172, 425, 121, 377, 236, 254, 19, 441, 374, 120, 271, 52, 69, 343, 42, 408, 61, 441, 248, 243, 136, 402, 3, 118, 54, 210, 232, 111, 98, 325, 244, 89, 250, 347, 199, 78, 176, 300, 213, 417, 332, 359, 452, 86, 503, 484, 288},
  {446, 50, 87, 433, 15, 326, 504, 99, 28, 464, 43, 32, 94, 438, 438, 198, 50, 80, 234, 374, 283, 79, 464, 91, 231, 341, 8, 79, 392, 267, 43, 455, 212, 2, 505, 285, 15, 512, 50, 324, 326, 189, 331, 175, 175, 231, 433, 469, 314, 306, 267, 212, 414, 485, 394, 35, 263, 69, 118, 195, 229, 407, 355, 464, 386, 109, 478, 469, 217, 223, 83, 170, 370, 402, 4, 113, 201, 321, 447, 168, 178, 390, 505, 139, 342, 394, 315, 464, 50, 287, 68, 63, 91, 308, 50, 33, 108, 314, 309, 195},
  {18, 140, 120, 327, 436, 483, 425, 384, 74, 192, 372, 93, 290, 497, 359, 159, 372, 251, 260, 22, 264, 412, 344, 26, 159, 12, 354, 348, 8, 492, 487, 110, 511, 465, 231, 48, 372, 175, 323, 183, 354, 487, 383, 41, 68, 150, 439, 351, 393, 290, 238, 396, 159, 258, 385, 106, 474, 379, 494, 259, 408, 164, 68, 396, 223, 31, 3, 462, 354, 351, 182, 508, 133, 152, 169, 205, 466, 140, 175, 54, 361, 128, 16, 93, 60, 430, 22, 54, 384, 311, 412, 397, 159, 489, 240, 150, 159, 498, 249, 248},
  {498, 386, 158, 366, 280, 144, 232, 230, 427, 443, 340, 397, 426, 195, 363, 202, 435, 166, 497, 387, 423, 216, 130, 423, 211, 370, 198, 237, 216, 50, 6, 393, 428, 14, 111, 359, 141, 263, 423, 439, 337, 76, 491, 140, 427, 306, 370, 230, 306, 7, 278, 158, 306, 331, 397, 363, 132, 350, 247, 423, 508, 495, 376, 340, 397, 157, 339, 408, 365, 100, 272, 272, 320, 320, 168, 160, 98, 441, 44, 295, 50, 197, 278, 278, 479, 374, 393, 92, 93, 36, 340, 195, 265, 111, 55, 317, 365, 92, 430, 383},
  {54, 437, 476, 205, 482, 450, 70, 236, 312, 272, 441, 18, 47, 75, 322, 18, 206, 296, 106, 115, 444, 18, 413, 86, 361, 98, 9, 352, 444, 182, 62, 206, 4, 502, 450, 358, 36, 152, 467, 306, 363, 31, 218, 468, 312, 47, 127, 86, 344, 361, 332, 448, 72, 153, 495, 238, 383, 40, 305, 348, 286, 110, 379, 18, 312, 368, 430, 499, 252, 86, 270, 332, 80, 190, 386, 167, 410, 385, 381, 419, 503, 391, 444, 490, 261, 190, 283, 18, 98, 3, 286, 373, 252, 118, 252, 389, 236, 419, 175, 172},
  {329, 212, 58, 72, 448, 434, 434, 335, 141, 328, 159, 498, 262, 492, 57, 314, 400, 451, 458, 511, 285, 65, 18, 359, 407, 389, 397, 318, 440, 18, 351, 389, 389, 274, 434, 298, 128, 208, 18, 257, 389, 55, 394, 48, 397, 181, 390, 400, 254, 62, 314, 191, 301, 162, 338, 51, 169, 442, 149, 376, 380, 282, 345, 404, 468, 327, 131, 327, 463, 112, 301, 98, 452, 243, 456, 451, 404, 114, 347, 359, 285, 310, 254, 413, 376, 47, 433, 288, 407, 497, 129, 159, 195, 103, 262, 156, 60, 327, 108, 236},
  {270, 196, 413, 301, 430, 312, 174, 483, 32, 59, 164, 169, 32, 227, 461, 274, 296, 57, 287, 274, 227, 101, 210, 33, 164, 427, 227, 498, 436, 291, 448, 310, 199, 33, 210, 318, 314, 27, 242, 373, 412, 153, 293, 3, 26, 436, 202, 101, 305, 227, 76, 241, 296, 271, 81, 413, 256, 388, 101, 491, 288, 102, 201, 222, 427, 132, 15, 32, 117, 93, 474, 117, 225, 33, 348, 154, 462, 34, 168, 476, 436, 227, 22, 448, 346, 436, 138, 436, 483, 339, 249, 237, 49, 48, 413, 73, 164, 413, 272, 448},
  {488, 287, 511, 410, 323, 26, 407, 274, 77, 436, 89, 390, 191, 198, 217, 3, 466, 109, 50, 359, 464, 239, 352, 158, 334, 340, 49, 97, 410, 340, 365, 490, 301, 85, 360, 390, 191, 374, 301, 262, 435, 97, 80, 429, 209, 9, 139, 43, 239, 343, 303, 292, 89, 364, 410, 455, 307, 436, 466, 77, 239, 63, 257, 483, 455, 158, 283, 342, 179, 191, 201, 362, 98, 346, 237, 497, 473, 355, 340, 390, 435, 464, 410, 253, 129, 85, 422, 191, 303, 463, 436, 260, 8, 460, 473, 89, 260, 67, 398, 201},
  {475, 452, 341, 127, 20, 21, 499, 192, 252, 80, 119, 379, 420, 177, 211, 342, 8, 288, 404, 59, 325, 100, 452, 381, 393, 371, 61, 152, 512, 496, 469, 420, 381, 480, 129, 344, 512, 119, 215, 493, 171, 335, 35, 10, 78, 119, 77, 231, 77, 210, 78, 512, 113, 36, 145, 339, 279, 104, 113, 435, 479, 178, 142, 252, 78, 231, 325, 480, 429, 111, 129, 215, 244, 111, 162, 512, 37, 257, 407, 445, 393, 45, 56, 191, 207, 91, 417, 201, 210, 119, 461, 490, 100, 75, 129, 133, 445, 77, 461, 252},
  {136, 402, 494, 73, 443, 414, 489, 130, 414, 360, 60, 402, 506, 402, 38, 334, 472, 97, 118, 509, 272, 219, 419, 125, 328, 385, 125, 469, 97, 260, 195, 181, 257, 295, 191, 224, 360, 311, 436, 345, 469, 104, 384, 370, 468, 510, 418, 181, 233, 41, 245, 46, 405, 396, 11, 27, 95, 374, 191, 124, 221, 188, 73, 166, 478, 8, 138, 74, 295, 46, 307, 307, 425, 334, 60, 102, 401, 467, 402, 454, 267, 385, 298, 1, 355, 151, 137, 402, 60, 334, 74, 418, 48, 29, 349, 55, 390, 127, 296, 460},
  {508, 205, 386, 291, 308, 443, 151, 178, 178, 121, 349, 58, 386, 238, 35, 121, 339, 244, 220, 484, 210, 387, 97, 72, 238, 162, 449, 320, 54, 485, 437, 311, 61, 232, 206, 152, 203, 43, 238, 230, 498, 257, 61, 386, 104, 368, 509, 154, 92, 249, 388, 335, 3, 34, 443, 311, 509, 167, 362, 244, 209, 269, 71, 51, 31, 415, 475, 174, 14, 268, 256, 509, 424, 420, 347, 31, 327, 421, 85, 219, 387, 12, 145, 125, 425, 67, 112, 5, 269, 145, 178, 118, 232, 389, 186, 50, 463, 146, 299, 443},
  {399, 33, 309, 29, 231, 242, 3, 303, 350, 342, 170, 291, 157, 350, 425, 195, 376, 350, 68, 173, 330, 327, 244, 284, 303, 326, 264, 404, 376, 289, 202, 303, 225, 63, 326, 226, 303, 292, 350, 131, 264, 330, 105, 93, 326, 236, 376, 342, 185, 158, 197, 195, 441, 66, 326, 376, 91, 52, 42, 350, 350, 123, 259, 326, 485, 210, 104, 181, 326, 303, 303, 73, 136, 342, 286, 378, 121, 343, 239, 270, 372, 284, 210, 87, 73, 12, 21, 419, 376, 93, 256, 242, 289, 190, 404, 404, 342, 404, 338, 216},
  {171, 37, 499, 365, 80, 509, 258, 2, 104, 219, 431, 307, 130, 52, 253, 453, 453, 99, 17, 150, 295, 436, 335, 437, 406, 195, 478, 123, 428, 78, 283, 350, 235, 20, 213, 412, 220, 213, 431, 52, 350, 130, 73, 492, 171, 213, 478, 493, 87, 455, 295, 294, 142, 384, 350, 509, 458, 339, 401, 436, 85, 91, 322, 162, 479, 87, 308, 123, 218, 130, 106, 254, 164, 307, 450, 479, 192, 301, 10, 52, 162, 151, 364, 373, 457, 476, 399, 15, 295, 45, 106, 219, 52, 151, 52, 401, 47, 482, 434, 25},
  {401, 178, 205, 456, 424, 399, 60, 348, 317, 448, 6, 336, 51, 253, 49, 304, 137, 461, 306, 65, 49, 136, 80, 399, 468, 390, 480, 181, 495, 461, 39, 74, 109, 131, 33, 333, 348, 448, 181, 461, 304, 398, 70, 496, 57, 383, 272, 291, 180, 378, 433, 136, 495, 90, 87, 348, 298, 504, 95, 492, 196, 280, 69, 448, 428, 390, 223, 323, 137, 51, 2, 80, 404, 448, 207, 329, 291, 478, 308, 276, 348, 49, 260, 293, 47, 399, 223, 51, 149, 273, 219, 398, 448, 228, 348, 182, 313, 137, 332, 332},
  {143, 290, 143, 261, 188, 332, 6, 105, 405, 2, 187, 92, 491, 183, 490, 284, 230, 505, 218, 225, 384, 499, 350, 263, 124, 384, 375, 208, 85, 62, 38, 184, 236, 38, 2, 443, 471, 471, 499, 449, 26, 284, 313, 154, 474, 230, 359, 338, 105, 211, 201, 273, 503, 14, 251, 338, 250, 430, 319, 87, 208, 244, 136, 187, 124, 208, 205, 175, 277, 500, 225, 299, 284, 490, 101, 201, 494, 86, 316, 263, 367, 38, 92, 91, 416, 260, 79, 346, 127, 139, 500, 392, 44, 277, 416, 319, 87, 183, 257, 105},
  {114, 260, 278, 51, 359, 462, 47, 436, 346, 16, 191, 190, 257, 331, 150, 462, 493, 324, 310, 396, 381, 510, 287, 92, 417, 494, 324, 221, 175, 378, 396, 59, 52, 478, 430, 259, 373, 480, 129, 413, 46, 313, 48, 306, 72, 126, 35, 108, 59, 191, 191, 373, 417, 198, 462, 28, 229, 499, 159, 296, 106, 96, 486, 327, 451, 494, 467, 162, 444, 52, 457, 72, 103, 481, 475, 380, 306, 401, 492, 361, 92, 436, 268, 129, 424, 473, 390, 46, 296, 28, 416, 361, 156, 451, 231, 208, 83, 494, 436, 373},
  {469, 469, 247, 97, 477, 227, 204, 143, 268, 193, 278, 212, 177, 154, 491, 322, 227, 83, 77, 183, 389, 324, 74, 205, 23, 443, 369, 192, 318, 177, 244, 433, 396, 222, 418, 430, 249, 14, 272, 213, 260, 5, 431, 417, 158, 143, 344, 114, 362, 22, 50, 42, 433, 287, 193, 491, 70, 474, 37, 154, 112, 250, 401, 177, 385, 287, 491, 14, 448, 342, 181, 123, 402, 77, 164, 418, 386, 106, 170, 41, 188, 205, 35, 250, 199, 424, 131, 73, 239, 489, 422, 123, 422, 391, 114, 158, 77, 260, 419, 508},
  {404, 423, 467, 187, 439, 359, 121, 385, 359, 112, 99, 56, 192, 79, 67, 101, 101, 291, 61, 92, 339, 19, 223, 210, 471, 149, 463, 223, 385, 366, 69, 156, 189, 332, 223, 228, 236, 180, 264, 172, 198, 449, 441, 411, 410, 449, 189, 457, 385, 505, 223, 471, 392, 367, 149, 236, 227, 36, 495, 359, 366, 445, 170, 476, 243, 428, 291, 332, 134, 99, 283, 9, 387, 410, 58, 471, 198, 112, 179, 254, 359, 505, 28, 430, 203, 497, 211, 378, 156, 447, 5, 311, 180, 265, 407, 495, 285, 264, 56, 316},
  {87, 503, 160, 52, 120, 263, 277, 38, 366, 366, 197, 308, 498, 8, 418, 175, 447, 475, 141, 215, 133, 285, 38, 360, 318, 366, 447, 96, 405, 329, 151, 423, 512, 56, 242, 176, 90, 231, 151, 305, 263, 151, 341, 418, 430, 388, 326, 246, 326, 183, 329, 492, 343, 472, 355, 103, 80, 468, 135, 360, 482, 350, 358, 263, 197, 326, 117, 366, 103, 447, 10, 45, 197, 175, 287, 231, 281, 206, 195, 151, 90, 318, 473, 12, 63, 485, 41, 96, 103, 442, 246, 128, 236, 11, 254, 418, 168, 281, 416, 277},
  {484, 224, 396, 87, 146, 254, 94, 63, 10, 281, 308, 195, 397, 112, 287, 116, 29, 37, 134, 447, 180, 243, 484, 188, 86, 63, 102, 159, 127, 69, 509, 415, 178, 54, 331, 331, 119, 85, 29, 443, 69, 210, 225, 165, 234, 512, 207, 180, 283, 392, 29, 317, 452, 284, 224, 287, 422, 146, 51, 180, 308, 403, 87, 180, 450, 498, 333, 86, 504, 180, 33, 15, 444, 503, 326, 302, 312, 379, 449, 63, 397, 195, 169, 163, 258, 495, 210, 127, 397, 86, 15, 503, 512, 291, 180, 52, 4, 279, 278, 86},
  {151, 511, 141, 186, 181, 180, 85, 356, 422, 246, 277, 59, 391, 256, 7, 230, 125, 495, 454, 357, 362, 422, 451, 37, 167, 204, 391, 402, 426, 91, 56, 506, 210, 216, 422, 508, 505, 393, 197, 106, 271, 445, 203, 70, 25, 185, 164, 197, 107, 79, 362, 426, 7, 432, 340, 382, 230, 476, 246, 277, 330, 490, 164, 123, 42, 275, 11, 256, 151, 220, 451, 330, 186, 164, 301, 237, 490, 323, 258, 294, 246, 75, 439, 420, 3, 204, 40, 356, 151, 362, 439, 426, 256, 90, 167, 91, 439, 506, 107, 340},
  {330, 218, 14, 98, 411, 209, 92, 422, 76, 49, 272, 201, 117, 201, 277, 358, 185, 266, 444, 218, 358, 49, 68, 461, 68, 461, 484, 185, 484, 223, 322, 444, 209, 484, 76, 147, 24, 185, 160, 510, 500, 230, 215, 488, 372, 323, 496, 414, 209, 269, 230, 120, 114, 182, 490, 234, 334, 297, 406, 234, 371, 347, 412, 44, 141, 253, 100, 460, 15, 79, 290, 471, 150, 369, 490, 426, 65, 390, 350, 358, 460, 380, 137, 23, 90, 289, 375, 234, 209, 65, 241, 201, 431, 43, 290, 44, 241, 47, 54, 234},
  {474, 28, 411, 95, 102, 373, 323, 413, 187, 99, 436, 373, 437, 41, 308, 436, 7, 205, 380, 410, 292, 268, 151, 35, 268, 368, 208, 35, 457, 437, 86, 160, 433, 448, 437, 483, 484, 29, 287, 107, 268, 218, 426, 469, 35, 413, 397, 103, 457, 293, 19, 2, 86, 400, 287, 371, 331, 413, 199, 373, 170, 507, 22, 71, 253, 255, 260, 511, 358, 373, 402, 419, 16, 493, 148, 336, 477, 53, 364, 345, 144, 102, 144, 389, 158, 156, 237, 493, 255, 144, 373, 317, 250, 453, 188, 337, 319, 354, 483, 282},
  {468, 188, 49, 497, 336, 66, 109, 290, 349, 105, 306, 497, 430, 320, 42, 279, 338, 306, 67, 213, 390, 163, 270, 176, 488, 37, 476, 9, 390, 150, 14, 12, 132, 220, 1, 315, 430, 287, 81, 394, 397, 342, 478, 367, 306, 488, 425, 1, 81, 338, 356, 260, 389, 446, 290, 458, 44, 492, 206, 461, 14, 306, 304, 342, 132, 306, 141, 90, 193, 458, 335, 176, 113, 359, 474, 33, 309, 29, 109, 338, 497, 488, 496, 173, 237, 194, 77, 384, 153, 132, 102, 264, 348, 482, 54, 425, 471, 338, 403, 287},
  {164, 131, 334, 317, 361, 243, 462, 467, 484, 275, 399, 388, 95, 259, 182, 58, 308, 317, 97, 47, 338, 212, 467, 96, 388, 336, 250, 121, 243, 393, 399, 259, 228, 482, 443, 62, 488, 484, 479, 464, 36, 141, 276, 275, 382, 443, 11, 465, 7, 418, 186, 192, 487, 338, 388, 289, 358, 425, 243, 15, 484, 21, 38, 7, 315, 191, 167, 484, 192, 259, 58, 75, 105, 201, 396, 165, 381, 375, 155, 212, 36, 96, 491, 309, 450, 335, 403, 156, 406, 295, 26, 186, 167, 283, 443, 465, 289, 66, 179, 167},
  {50, 398, 60, 461, 171, 256, 193, 299, 347, 336, 134, 76, 504, 123, 61, 89, 414, 307, 9, 84, 35, 269, 374, 104, 282, 467, 269, 27, 427, 458, 284, 361, 346, 198, 229, 99, 51, 472, 63, 245, 374, 51, 15, 323, 3, 440, 284, 443, 465, 6, 509, 251, 188, 49, 89, 201, 296, 472, 467, 256, 79, 215, 302, 178, 270, 346, 299, 296, 311, 414, 465, 93, 167, 471, 135, 307, 27, 506, 131, 235, 148, 6, 284, 427, 69, 227, 392, 336, 414, 399, 27, 284, 225, 227, 42, 353, 69, 496, 60, 399},
  {93, 44, 239, 209, 234, 365, 224, 170, 482, 505, 266, 192, 154, 222, 213, 186, 192, 66, 471, 322, 505, 12, 289, 376, 508, 141, 66, 266, 497, 429, 95, 44, 128, 352, 102, 178, 30, 502, 66, 481, 66, 502, 342, 61, 387, 71, 448, 102, 141, 341, 429, 502, 222, 267, 13, 489, 374, 302, 197, 24, 368, 418, 471, 489, 40, 461, 300, 389, 197, 141, 40, 387, 189, 453, 222, 272, 142, 64, 227, 417, 170, 448, 177, 388, 491, 253, 243, 24, 155, 411, 91, 302, 259, 500, 84, 30, 346, 95, 53, 66},
  {162, 16, 206, 163, 500, 189, 479, 39, 381, 45, 7, 347, 110, 34, 64, 77, 461, 60, 360, 487, 60, 244, 226, 97, 463, 414, 364, 301, 198, 97, 208, 112, 284, 470, 245, 92, 189, 45, 461, 440, 463, 271, 102, 171, 274, 335, 487, 31, 335, 118, 335, 40, 77, 158, 461, 487, 171, 462, 490, 295, 26, 358, 70, 490, 60, 118, 109, 444, 59, 64, 77, 490, 88, 364, 234, 318, 209, 26, 394, 388, 93, 463, 384, 321, 141, 184, 39, 29, 72, 226, 126, 371, 365, 434, 141, 267, 132, 112, 127, 385},
  {256, 291, 171, 364, 301, 266, 446, 489, 151, 467, 256, 422, 261, 389, 385, 233, 83, 357, 49, 15, 319, 395, 140, 319, 483, 165, 165, 322, 96, 88, 161, 89, 63, 464, 98, 277, 436, 290, 122, 43, 187, 40, 121, 293, 494, 38, 132, 256, 187, 447, 422, 319, 335, 494, 26, 422, 159, 337, 357, 46, 119, 25, 391, 496, 174, 165, 342, 63, 367, 26, 127, 145, 462, 151, 288, 246, 160, 173, 424, 475, 283, 78, 161, 94, 239, 46, 303, 57, 511, 436, 483, 127, 447, 445, 56, 322, 145, 46, 119, 46},
  {448, 434, 238, 171, 24, 314, 443, 118, 353, 473, 393, 112, 314, 225, 160, 42, 132, 263, 249, 368, 332, 72, 62, 418, 415, 237, 88, 64, 262, 487, 392, 263, 262, 357, 164, 361, 357, 438, 216, 268, 332, 357, 36, 145, 55, 117, 346, 64, 424, 438, 80, 194, 458, 505, 242, 237, 419, 81, 473, 450, 403, 363, 272, 132, 13, 241, 228, 241, 133, 465, 79, 118, 473, 27, 473, 13, 129, 267, 418, 438, 56, 263, 357, 52, 217, 54, 465, 467, 424, 368, 80, 216, 27, 222, 27, 225, 424, 357, 397, 435},
  {224, 216, 337, 452, 406, 216, 50, 196, 362, 277, 234, 223, 388, 352, 183, 450, 156, 221, 405, 141, 206, 389, 109, 340, 341, 399, 340, 179, 111, 307, 307, 431, 362, 234, 181, 137, 16, 51, 354, 353, 137, 109, 363, 356, 341, 79, 67, 129, 508, 245, 259, 296, 431, 425, 324, 385, 121, 196, 307, 37, 132, 61, 284, 479, 324, 217, 68, 324, 479, 156, 109, 88, 458, 352, 112, 156, 428, 291, 34, 450, 249, 259, 454, 168, 440, 51, 11, 442, 324, 488, 16, 184, 324, 258, 133, 324, 269, 257, 91, 208},
  {398, 480, 418, 300, 237, 122, 17, 69, 411, 481, 318, 68, 48, 85, 377, 297, 411, 466, 394, 244, 404, 242, 346, 464, 105, 143, 297, 327, 151, 151, 262, 187, 390, 441, 23, 27, 216, 441, 48, 103, 216, 281, 315, 399, 502, 456, 466, 122, 193, 51, 297, 105, 284, 487, 434, 179, 75, 395, 506, 506, 464, 50, 481, 205, 262, 216, 480, 105, 242, 27, 242, 238, 358, 224, 281, 258, 405, 59, 374, 18, 398, 441, 335, 383, 123, 396, 250, 441, 122, 205, 216, 262, 84, 410, 316, 327, 162, 297, 360, 484},
  {504, 296, 28, 336, 259, 316, 166, 222, 110, 504, 379, 418, 434, 77, 143, 183, 266, 126, 327, 16, 154, 39, 276, 214, 383, 477, 316, 261, 469, 242, 301, 392, 142, 292, 154, 507, 13, 222, 276, 4, 292, 418, 103, 107, 469, 111, 154, 501, 336, 19, 94, 469, 50, 104, 421, 57, 389, 306, 77, 166, 25, 105, 179, 433, 19, 490, 25, 77, 335, 13, 57, 166, 61, 126, 479, 220, 472, 370, 299, 79, 465, 443, 446, 8, 232, 465, 265, 469, 444, 316, 357, 460, 77, 342, 420, 214, 509, 111, 477, 446},
  {161, 339, 110, 116, 403, 444, 153, 203, 7, 163, 75, 69, 377, 151, 269, 211, 369, 423, 475, 256, 356, 339, 339, 151, 13, 269, 27, 377, 264, 472, 444, 106, 40, 197, 369, 8, 234, 507, 412, 251, 303, 57, 16, 478, 166, 500, 254, 485, 227, 226, 333, 266, 420, 420, 481, 476, 134, 369, 57, 138, 163, 222, 420, 363, 234, 446, 179, 251, 371, 266, 108, 333, 188, 47, 186, 23, 189, 234, 442, 7, 240, 420, 166, 149, 329, 422, 85, 243, 215, 284, 57, 122, 89, 385, 243, 40, 173, 269, 123, 29},
  {492, 228, 317, 450, 124, 273, 256, 283, 204, 242, 226, 187, 298, 150, 361, 298, 359, 330, 309, 436, 172, 267, 181, 469, 296, 442, 330, 504, 87, 172, 330, 208, 372, 443, 75, 309, 383, 298, 34, 356, 404, 106, 463, 433, 10, 404, 412, 372, 498, 442, 8, 87, 150, 20, 25, 355, 506, 46, 272, 88, 10, 230, 435, 75, 181, 429, 142, 371, 53, 245, 371, 242, 442, 245, 498, 306, 204, 437, 182, 37, 114, 150, 330, 182, 435, 385, 325, 404, 442, 138, 298, 25, 150, 440, 323, 269, 98, 372, 283, 50},
  {298, 488, 86, 436, 159, 230, 312, 233, 479, 91, 15, 290, 230, 190, 89, 456, 469, 133, 324, 44, 175, 331, 407, 223, 201, 110, 223, 238, 15, 149, 438, 288, 483, 319, 109, 12, 1, 394, 253, 303, 121, 63, 417, 267, 378, 196, 512, 472, 472, 395, 141, 375, 9, 399, 133, 213, 486, 288, 121, 252, 58, 479, 155, 507, 461, 45, 481, 307, 113, 438, 113, 469, 89, 438, 136, 371, 179, 111, 398, 461, 201, 121, 378, 378, 230, 170, 295, 98, 133, 58, 432, 196, 165, 26, 230, 165, 351, 9, 154, 371},
  {462, 12, 10, 421, 266, 325, 403, 328, 222, 415, 1, 7, 148, 271, 466, 266, 213, 452, 28, 174, 398, 174, 266, 70, 19, 325, 118, 58, 398, 271, 375, 312, 353, 19, 421, 388, 480, 415, 271, 473, 108, 312, 280, 395, 444, 398, 248, 229, 205, 456, 248, 271, 415, 256, 148, 398, 309, 285, 325, 57, 50, 171, 193, 368, 24, 195, 458, 229, 148, 176, 398, 241, 382, 174, 27, 158, 417, 368, 341, 466, 58, 490, 108, 375, 317, 121, 464, 421, 37, 428, 99, 208, 37, 72, 368, 490, 453, 292, 462, 271},
  {281, 2, 56, 100, 244, 479, 335, 52, 293, 210, 210, 429, 52, 108, 478, 132, 74, 147, 359, 298, 199, 78, 390, 346, 359, 275, 418, 479, 36, 265, 13, 493, 397, 237, 498, 265, 100, 154, 448, 62, 316, 69, 22, 300, 316, 332, 251, 316, 33, 147, 134, 52, 92, 380, 229, 390, 155, 210, 275, 329, 279, 285, 84, 72, 229, 450, 346, 498, 489, 5, 426, 132, 367, 118, 304, 448, 166, 78, 138, 198, 318, 172, 346, 408, 222, 25, 407, 359, 183, 56, 265, 132, 386, 287, 237, 359, 361, 390, 302, 363},
  {6, 436, 84, 266, 42, 32, 154, 296, 462, 244, 447, 34, 22, 60, 116, 110, 4, 395, 338, 112, 275, 497, 482, 207, 5, 64, 388, 263, 360, 52, 220, 128, 459, 459, 190, 187, 491, 216, 182, 363, 5, 437, 21, 46, 388, 168, 135, 17, 51, 303, 116, 263, 438, 450, 431, 436, 284, 156, 491, 414, 379, 241, 452, 232, 162, 491, 271, 17, 182, 69, 462, 182, 421, 388, 472, 345, 407, 155, 332, 186, 216, 491, 51, 359, 312, 149, 510, 246, 275, 5, 207, 182, 491, 426, 388, 207, 111, 34, 354, 482},
  {332, 192, 139, 30, 318, 52, 33, 164, 330, 179, 454, 151, 223, 490, 350, 131, 84, 336, 418, 212, 6, 9, 115, 248, 374, 208, 384, 87, 132, 357, 292, 338, 468, 263, 487, 350, 207, 178, 6, 474, 131, 300, 154, 383, 56, 312, 151, 445, 462, 353, 468, 289, 84, 248, 282, 357, 415, 95, 312, 418, 173, 125, 397, 292, 131, 207, 258, 191, 281, 179, 292, 223, 353, 271, 432, 292, 500, 349, 104, 56, 79, 164, 83, 394, 290, 313, 19, 504, 441, 384, 212, 282, 384, 38, 350, 122, 338, 151, 447, 16},
  {119, 163, 256, 243, 140, 92, 16, 142, 455, 4, 294, 428, 57, 435, 155, 382, 178, 21, 156, 339, 344, 469, 501, 454, 178, 45, 24, 361, 389, 316, 432, 507, 36, 444, 382, 58, 278, 432, 146, 174, 81, 341, 232, 454, 308, 91, 455, 81, 511, 344, 57, 116, 410, 171, 47, 228, 81, 403, 2, 432, 108, 53, 212, 76, 45, 155, 65, 219, 91, 242, 316, 278, 318, 104, 137, 370, 362, 232, 55, 360, 228, 186, 49, 181, 45, 99, 458, 389, 24, 257, 481, 382, 410, 382, 455, 135, 401, 147, 217, 219},
  {331, 368, 431, 363, 399, 441, 418, 444, 122, 485, 376, 412, 444, 157, 32, 157, 389, 49, 81, 300, 122, 203, 412, 486, 22, 192, 459, 283, 266, 119, 441, 267, 168, 221, 106, 270, 441, 262, 134, 166, 228, 435, 468, 464, 375, 300, 469, 353, 70, 481, 262, 106, 307, 122, 153, 353, 190, 331, 396, 470, 487, 396, 469, 392, 49, 355, 257, 349, 122, 70, 32, 49, 241, 444, 243, 355, 345, 201, 279, 425, 16, 134, 244, 258, 81, 262, 29, 502, 396, 179, 501, 110, 282, 330, 307, 168, 179, 287, 496, 330},
  {413, 90, 331, 332, 395, 494, 251, 429, 404, 102, 400, 164, 338, 87, 473, 87, 273, 273, 367, 30, 27, 300, 113, 20, 182, 312, 274, 214, 289, 448, 110, 403, 489, 60, 289, 452, 27, 482, 4, 197, 443, 222, 187, 40, 452, 359, 400, 225, 390, 257, 87, 400, 347, 81, 453, 72, 274, 33, 44, 404, 215, 258, 448, 494, 374, 79, 27, 304, 478, 121, 131, 390, 313, 267, 368, 116, 26, 1, 310, 507, 458, 238, 182, 143, 113, 221, 432, 309, 443, 9, 331, 4, 245, 56, 273, 79, 174, 138, 443, 507},
  {368, 59, 85, 480, 389, 154, 18, 31, 440, 103, 323, 143, 79, 509, 400, 240, 440, 285, 78, 367, 158, 152, 79, 297, 353, 281, 212, 13, 139, 130, 139, 130, 122, 437, 225, 59, 341, 488, 357, 188, 10, 122, 373, 252, 462, 281, 225, 172, 168, 2, 64, 83, 240, 211, 472, 407, 341, 458, 427, 48, 181, 207, 477, 225, 64, 86, 504, 473, 451, 228, 369, 352, 139, 353, 104, 369, 378, 453, 29, 205, 488, 251, 369, 342, 247, 74, 195, 296, 251, 480, 442, 473, 111, 76, 400, 31, 485, 458, 357, 181},
  {228, 345, 52, 274, 288, 53, 385, 60, 271, 111, 485, 100, 456, 162, 433, 254, 288, 300, 358, 66, 70, 304, 138, 202, 271, 288, 191, 217, 401, 5, 390, 213, 288, 34, 378, 116, 276, 433, 424, 379, 484, 111, 366, 203, 281, 100, 34, 298, 322, 458, 310, 374, 490, 100, 446, 60, 149, 487, 141, 248, 138, 126, 405, 120, 310, 202, 495, 401, 202, 73, 479, 479, 131, 25, 485, 73, 330, 252, 232, 487, 25, 107, 459, 503, 391, 273, 234, 372, 254, 59, 172, 459, 433, 240, 59, 378, 29, 70, 85, 177},
  {445, 419, 305, 492, 144, 151, 287, 139, 43, 73, 428, 57, 483, 280, 130, 260, 353, 77, 111, 126, 278, 117, 391, 106, 77, 15, 285, 268, 448, 435, 419, 151, 504, 106, 502, 260, 481, 240, 59, 351, 73, 315, 162, 124, 219, 170, 15, 339, 117, 9, 481, 252, 151, 466, 77, 505, 92, 307, 301, 54, 435, 176, 117, 285, 466, 170, 301, 106, 353, 284, 298, 339, 219, 339, 54, 500, 353, 194, 409, 372, 494, 473, 252, 285, 57, 246, 197, 461, 360, 94, 401, 3, 464, 145, 106, 498, 321, 452, 288, 372},
  {491, 441, 382, 390, 52, 13, 100, 115, 471, 351, 220, 471, 190, 471, 84, 308, 289, 181, 89, 471, 483, 509, 161, 239, 400, 171, 69, 101, 446, 259, 101, 24, 250, 171, 384, 306, 161, 190, 259, 167, 474, 65, 125, 272, 483, 482, 126, 327, 36, 230, 382, 36, 12, 358, 407, 168, 443, 5, 278, 101, 36, 166, 318, 190, 41, 292, 418, 441, 115, 471, 327, 282, 25, 133, 231, 309, 213, 186, 199, 190, 343, 202, 171, 171, 23, 344, 346, 142, 259, 382, 471, 36, 440, 307, 500, 443, 250, 101, 55, 327},
  {472, 294, 32, 193, 329, 411, 34, 223, 208, 411, 482, 330, 439, 180, 474, 273, 269, 347, 144, 406, 202, 330, 231, 40, 50, 209, 144, 279, 231, 250, 127, 377, 365, 29, 460, 161, 22, 392, 20, 283, 392, 509, 444, 376, 223, 147, 40, 144, 231, 231, 425, 220, 330, 388, 506, 50, 128, 326, 215, 482, 411, 437, 58, 202, 449, 288, 425, 416, 22, 316, 250, 245, 95, 411, 460, 392, 11, 330, 504, 290, 127, 330, 50, 402, 206, 412, 254, 263, 193, 154, 179, 83, 392, 22, 122, 231, 497, 387, 13, 22},
  {351, 310, 322, 467, 121, 98, 441, 213, 30, 5, 171, 504, 481, 409, 170, 448, 122, 512, 485, 73, 213, 87, 336, 310, 101, 180, 495, 20, 256, 412, 459, 14, 180, 187, 367, 23, 477, 139, 75, 146, 434, 292, 206, 68, 152, 87, 191, 409, 510, 348, 409, 10, 25, 342, 459, 336, 294, 412, 462, 422, 382, 298, 88, 422, 300, 409, 233, 409, 396, 367, 333, 487, 302, 101, 352, 409, 195, 423, 389, 367, 336, 103, 256, 385, 287, 138, 1, 298, 51, 168, 322, 227, 382, 110, 322, 227, 315, 181, 101, 87},
  {155, 313, 292, 145, 170, 297, 49, 370, 416, 46, 461, 328, 511, 370, 114, 469, 201, 31, 146, 451, 487, 121, 83, 430, 466, 500, 287, 173, 384, 328, 366, 239, 343, 411, 114, 120, 106, 239, 492, 362, 206, 380, 297, 79, 139, 430, 386, 87, 201, 380, 343, 73, 466, 477, 73, 479, 491, 131, 416, 121, 353, 435, 202, 46, 206, 7, 2, 494, 328, 87, 103, 461, 327, 209, 496, 138, 372, 411, 346, 401, 511, 474, 387, 54, 412, 267, 512, 31, 461, 465, 64, 114, 201, 183, 31, 343, 24, 380, 136, 461},
  {347, 49, 402, 428, 107, 249, 357, 71, 202, 490, 148, 358, 317, 103, 168, 262, 507, 407, 467, 497, 107, 81, 146, 56, 379, 507, 10, 249, 92, 132, 217, 358, 302, 103, 4, 495, 470, 41, 224, 494, 65, 503, 339, 357, 200, 339, 131, 3, 56, 30, 182, 250, 43, 37, 207, 200, 217, 384, 327, 104, 43, 134, 484, 114, 470, 56, 139, 43, 279, 224, 148, 317, 65, 373, 334, 490, 492, 100, 57, 308, 182, 503, 19, 212, 20, 391, 366, 423, 285, 455, 131, 355, 457, 290, 146, 71, 378, 56, 11, 217},
  {318, 161, 243, 99, 508, 318, 437, 261, 343, 228, 452, 380, 255, 374, 443, 261, 343, 400, 493, 75, 380, 221, 496, 391, 173, 352, 3, 369, 285, 452, 50, 30, 57, 238, 374, 184, 116, 510, 418, 65, 294, 41, 25, 255, 182, 37, 274, 306, 395, 70, 62, 261, 352, 249, 12, 191, 261, 35, 318, 343, 142, 504, 335, 294, 173, 294, 95, 207, 128, 306, 9, 191, 42, 421, 491, 374, 435, 298, 360, 321, 338, 261, 227, 13, 398, 272, 216, 400, 374, 452, 400, 380, 307, 154, 228, 9, 156, 343, 339, 237},
  {420, 25, 363, 197, 310, 425, 306, 478, 325, 202, 478, 444, 474, 184, 25, 356, 55, 381, 158, 229, 396, 453, 328, 328, 114, 328, 358, 48, 133, 511, 492, 503, 89, 432, 453, 304, 210, 242, 256, 142, 468, 389, 317, 393, 478, 55, 4, 480, 6, 448, 508, 249, 55, 347, 1, 133, 478, 300, 253, 62, 191, 1, 166, 221, 381, 290, 120, 363, 216, 432, 273, 501, 308, 123, 144, 372, 180, 296, 328, 396, 308, 492, 356, 211, 485, 439, 323, 262, 154, 133, 453, 346, 340, 276, 444, 444, 490, 76, 117, 161},
  {145, 171, 188, 432, 497, 340, 142, 315, 51, 72, 386, 502, 416, 99, 444, 133, 257, 362, 436, 168, 370, 489, 157, 237, 141, 362, 470, 416, 315, 361, 227, 396, 465, 133, 328, 126, 399, 191, 139, 119, 102, 361, 324, 340, 386, 315, 494, 495, 397, 130, 305, 458, 197, 416, 435, 384, 297, 485, 489, 328, 212, 88, 289, 423, 191, 65, 94, 37, 7, 139, 280, 305, 423, 396, 133, 399, 4, 147, 457, 20, 399, 477, 269, 126, 185, 55, 454, 397, 240, 443, 315, 89, 280, 416, 399, 363, 212, 240, 148, 258},
  {24, 460, 25, 252, 441, 322, 355, 56, 80, 438, 475, 60, 35, 5, 82, 407, 141, 136, 430, 250, 352, 396, 283, 334, 254, 508, 304, 202, 283, 441, 60, 342, 86, 246, 294, 296, 359, 209, 84, 299, 226, 430, 239, 311, 22, 475, 475, 56, 80, 441, 229, 328, 122, 501, 297, 13, 325, 12, 66, 464, 107, 60, 35, 78, 308, 283, 102, 108, 25, 507, 102, 239, 371, 283, 468, 283, 86, 367, 330, 209, 256, 438, 143, 185, 500, 437, 348, 102, 25, 122, 464, 374, 374, 199, 25, 461, 187, 508, 333, 493},
  {371, 47, 464, 196, 322, 415, 46, 278, 116, 259, 511, 303, 253, 185, 351, 277, 502, 453, 181, 350, 294, 191, 10, 185, 464, 185, 235, 193, 412, 227, 116, 277, 400, 360, 320, 201, 464, 156, 464, 483, 176, 140, 300, 489, 185, 199, 323, 37, 278, 480, 218, 327, 323, 58, 221, 221, 364, 116, 176, 453, 165, 290, 411, 196, 294, 221, 218, 18, 46, 226, 73, 52, 400, 211, 458, 334, 365, 289, 52, 163, 294, 52, 10, 381, 384, 164, 217, 23, 13, 400, 278, 116, 293, 318, 57, 46, 253, 18, 259, 163},
  {200, 377, 155, 108, 3, 391, 44, 77, 124, 126, 415, 53, 128, 70, 48, 434, 216, 250, 363, 2, 468, 48, 203, 300, 414, 345, 360, 488, 488, 222, 488, 391, 208, 326, 512, 423, 222, 233, 190, 235, 6, 371, 67, 193, 417, 417, 391, 266, 249, 15, 434, 233, 310, 334, 203, 217, 499, 471, 298, 392, 391, 59, 24, 290, 100, 360, 20, 216, 434, 300, 190, 443, 483, 266, 371, 341, 403, 431, 250, 146, 360, 345, 415, 104, 260, 400, 354, 391, 493, 416, 317, 360, 70, 14, 53, 434, 512, 11, 97, 53},
  {95, 151, 324, 340, 154, 279, 501, 28, 112, 441, 41, 30, 476, 362, 335, 362, 388, 329, 470, 228, 265, 71, 194, 298, 455, 279, 179, 335, 20, 434, 279, 214, 367, 203, 37, 468, 339, 30, 246, 207, 416, 246, 216, 268, 335, 210, 289, 179, 441, 17, 439, 368, 492, 335, 268, 409, 467, 461, 174, 471, 281, 28, 346, 174, 362, 388, 335, 339, 102, 335, 490, 210, 245, 14, 81, 286, 185, 31, 201, 201, 91, 17, 174, 165, 225, 162, 107, 58, 455, 492, 329, 14, 503, 304, 423, 430, 246, 439, 344, 279},
  {250, 221, 16, 178, 153, 22, 213, 374, 358, 377, 500, 510, 363, 489, 236, 137, 100, 479, 347, 306, 377, 374, 319, 411, 21, 50, 248, 109, 34, 183, 395, 204, 474, 308, 352, 494, 50, 456, 308, 263, 415, 7, 157, 259, 34, 131, 442, 158, 166, 40, 274, 135, 350, 213, 68, 125, 187, 353, 444, 148, 397, 27, 92, 421, 274, 199, 352, 343, 219, 96, 19, 397, 141, 40, 502, 328, 510, 356, 480, 275, 204, 118, 411, 397, 124, 117, 130, 166, 49, 412, 7, 10, 328, 328, 151, 64, 415, 444, 326, 109},
  {60, 123, 338, 159, 258, 244, 205, 403, 64, 48, 509, 236, 202, 64, 202, 44, 112, 212, 124, 398, 123, 38, 279, 451, 112, 509, 14, 506, 14, 495, 123, 449, 216, 123, 495, 499, 14, 183, 136, 37, 317, 14, 413, 17, 64, 254, 65, 458, 28, 202, 119, 20, 506, 371, 223, 123, 469, 423, 384, 223, 316, 4, 260, 383, 153, 38, 106, 131, 79, 506, 485, 89, 3, 180, 399, 198, 433, 217, 51, 236, 165, 79, 176, 395, 285, 53, 493, 302, 65, 123, 14, 509, 146, 414, 9, 321, 198, 302, 226, 123},
  {184, 235, 500, 292, 319, 355, 24, 112, 425, 425, 279, 185, 457, 159, 477, 242, 212, 281, 428, 114, 181, 84, 477, 131, 420, 112, 75, 131, 44, 392, 315, 306, 181, 469, 465, 311, 338, 420, 112, 42, 272, 469, 403, 483, 480, 108, 7, 211, 57, 20, 507, 27, 338, 368, 116, 480, 426, 31, 315, 374, 103, 429, 161, 226, 110, 374, 506, 250, 273, 348, 395, 457, 412, 374, 110, 90, 173, 302, 301, 508, 502, 465, 90, 406, 148, 368, 333, 134, 279, 469, 53, 181, 108, 241, 143, 411, 307, 385, 316, 131},
  {165, 177, 150, 435, 342, 383, 384, 155, 492, 178, 257, 234, 393, 486, 393, 320, 409, 119, 222, 312, 282, 344, 48, 320, 198, 75, 337, 384, 23, 218, 47, 453, 292, 306, 222, 326, 405, 435, 337, 226, 453, 421, 388, 242, 41, 146, 230, 313, 453, 355, 198, 282, 42, 291, 172, 93, 449, 77, 453, 98, 399, 270, 239, 227, 196, 107, 230, 453, 464, 313, 158, 346, 12, 435, 445, 361, 322, 196, 476, 299, 98, 139, 409, 500, 357, 129, 150, 299, 234, 77, 56, 8, 451, 372, 4, 313, 155, 134, 276, 60},
  {120, 461, 360, 253, 314, 173, 149, 180, 247, 468, 325, 270, 236, 450, 501, 475, 52, 247, 41, 500, 491, 158, 399, 186, 217, 505, 17, 468, 180, 246, 248, 20, 371, 304, 29, 323, 117, 37, 121, 459, 9, 219, 171, 163, 371, 6, 219, 348, 195, 323, 38, 186, 195, 115, 323, 118, 42, 86, 248, 217, 70, 223, 1, 236, 92, 323, 436, 217, 173, 197, 123, 120, 447, 468, 7, 435, 157, 248, 148, 503, 236, 26, 204, 446, 9, 444, 444, 505, 189, 195, 37, 6, 399, 173, 312, 283, 359, 485, 150, 150},
  {116, 199, 15, 444, 317, 304, 15, 12, 87, 332, 96, 448, 245, 170, 367, 335, 292, 335, 145, 28, 53, 403, 471, 45, 292, 332, 83, 111, 371, 292, 406, 319, 291, 413, 353, 303, 371, 321, 236, 208, 380, 471, 507, 65, 413, 12, 291, 362, 269, 475, 111, 424, 225, 109, 343, 233, 220, 91, 140, 371, 400, 390, 424, 245, 22, 413, 249, 233, 417, 149, 219, 371, 81, 354, 157, 86, 331, 309, 66, 202, 417, 182, 68, 35, 420, 466, 475, 282, 45, 100, 292, 1, 332, 425, 304, 485, 375, 446, 500, 96},
  {204, 209, 37, 393, 25, 511, 502, 147, 103, 194, 315, 281, 319, 464, 365, 60, 126, 280, 335, 310, 207, 500, 479, 415, 256, 473, 489, 120, 382, 403, 402, 78, 24, 453, 60, 148, 490, 69, 39, 132, 103, 52, 242, 143, 69, 403, 479, 310, 281, 94, 398, 69, 78, 303, 213, 108, 447, 70, 83, 165, 364, 208, 303, 478, 444, 61, 390, 247, 399, 194, 473, 324, 120, 158, 444, 103, 469, 280, 305, 382, 478, 324, 441, 480, 27, 382, 502, 489, 194, 280, 271, 141, 326, 47, 221, 78, 141, 120, 178, 428},
  {81, 442, 161, 223, 449, 471, 471, 471, 42, 494, 245, 175, 82, 457, 313, 476, 492, 102, 266, 78, 126, 442, 446, 407, 102, 407, 263, 442, 388, 224, 442, 245, 373, 446, 208, 158, 320, 442, 471, 215, 479, 193, 288, 63, 343, 2, 260, 4, 218, 185, 399, 126, 164, 330, 42, 442, 410, 41, 193, 116, 309, 346, 482, 60, 126, 309, 356, 153, 260, 60, 442, 340, 393, 336, 355, 463, 107, 133, 184, 126, 272, 253, 245, 509, 294, 372, 445, 153, 213, 78, 24, 465, 137, 424, 147, 153, 420, 200, 41, 465},
  {101, 58, 179, 318, 203, 191, 508, 251, 38, 191, 22, 437, 336, 299, 463, 394, 383, 437, 511, 393, 38, 95, 437, 485, 336, 120, 173, 207, 263, 383, 293, 482, 98, 225, 336, 467, 353, 22, 422, 346, 321, 336, 192, 52, 336, 394, 371, 207, 437, 38, 393, 133, 251, 60, 486, 293, 461, 409, 263, 486, 175, 7, 213, 144, 283, 370, 445, 257, 210, 95, 120, 18, 222, 370, 211, 229, 292, 279, 498, 155, 78, 262, 363, 238, 235, 427, 395, 293, 283, 486, 98, 323, 350, 221, 353, 167, 158, 335, 244, 299},
  {409, 65, 261, 360, 379, 105, 84, 244, 56, 393, 92, 217, 453, 501, 85, 213, 488, 408, 87, 288, 7, 252, 261, 181, 213, 401, 230, 25, 475, 131, 213, 92, 171, 410, 393, 199, 351, 453, 392, 404, 189, 217, 213, 87, 67, 291, 92, 92, 247, 430, 453, 430, 217, 145, 64, 305, 234, 73, 181, 38, 291, 116, 476, 153, 38, 325, 114, 102, 38, 122, 430, 217, 74, 140, 242, 257, 194, 45, 417, 131, 408, 69, 430, 352, 130, 84, 293, 291, 291, 83, 92, 131, 379, 400, 83, 25, 43, 311, 305, 421},
  {322, 470, 50, 11, 254, 213, 406, 11, 481, 307, 31, 449, 178, 361, 31, 470, 193, 94, 429, 290, 433, 380, 233, 68, 137, 157, 139, 303, 449, 394, 246, 315, 498, 380, 348, 396, 145, 300, 278, 10, 134, 30, 56, 491, 252, 485, 134, 82, 337, 233, 205, 433, 478, 10, 278, 21, 304, 398, 302, 60, 45, 23, 269, 233, 268, 60, 111, 157, 34, 498, 317, 183, 328, 433, 50, 278, 147, 484, 295, 292, 415, 31, 107, 472, 488, 128, 6, 369, 211, 376, 507, 226, 434, 361, 226, 481, 193, 60, 488, 302},
  {13, 494, 439, 222, 59, 70, 284, 508, 68, 374, 303, 302, 71, 426, 479, 458, 478, 398, 31, 113, 450, 208, 253, 87, 298, 436, 82, 398, 68, 228, 82, 227, 289, 483, 113, 132, 409, 409, 22, 339, 29, 87, 220, 111, 374, 409, 426, 13, 478, 326, 132, 450, 156, 63, 466, 426, 359, 325, 478, 82, 261, 416, 20, 358, 421, 503, 468, 109, 177, 214, 374, 177, 357, 272, 438, 411, 271, 334, 290, 319, 293, 13, 13, 206, 324, 243, 388, 78, 87, 214, 262, 105, 115, 122, 272, 387, 417, 113, 201, 358},
  {43, 64, 285, 357, 132, 407, 274, 209, 407, 318, 442, 447, 160, 187, 432, 442, 311, 397, 198, 435, 281, 311, 436, 51, 116, 297, 289, 71, 242, 37, 347, 27, 248, 447, 356, 476, 298, 332, 356, 271, 365, 406, 63, 170, 356, 318, 74, 406, 356, 104, 367, 344, 209, 12, 264, 231, 129, 125, 281, 297, 144, 199, 459, 397, 244, 280, 51, 280, 389, 209, 69, 304, 206, 311, 430, 467, 23, 427, 255, 272, 297, 406, 58, 88, 195, 393, 198, 242, 177, 373, 225, 356, 271, 153, 248, 74, 407, 353, 207, 275},
  {349, 410, 327, 398, 505, 207, 201, 371, 401, 182, 352, 44, 131, 218, 158, 401, 401, 14, 447, 255, 182, 4, 284, 260, 481, 21, 229, 326, 105, 502, 299, 271, 476, 476, 139, 198, 85, 105, 511, 204, 511, 105, 286, 310, 21, 105, 229, 105, 90, 205, 139, 349, 511, 59, 336, 481, 74, 348, 68, 430, 94, 104, 324, 511, 21, 182, 336, 336, 144, 229, 336, 374, 261, 197, 2, 488, 352, 417, 434, 35, 222, 175, 379, 302, 67, 504, 63, 14, 101, 80, 374, 447, 197, 504, 331, 302, 476, 14, 43, 349},
  {202, 181, 315, 290, 160, 133, 253, 275, 44, 174, 359, 52, 418, 387, 19, 498, 425, 249, 4, 473, 231, 31, 333, 322, 347, 71, 486, 102, 467, 402, 133, 282, 478, 80, 309, 103, 439, 503, 498, 58, 440, 192, 6, 102, 328, 347, 440, 164, 456, 81, 256, 440, 292, 275, 347, 104, 206, 364, 186, 322, 174, 333, 320, 486, 322, 315, 370, 387, 168, 148, 431, 222, 456, 128, 341, 152, 297, 211, 380, 376, 347, 185, 102, 254, 372, 460, 309, 137, 214, 128, 359, 486, 24, 492, 44, 478, 435, 107, 367, 254},
  {133, 272, 83, 278, 33, 284, 302, 409, 464, 483, 439, 256, 446, 408, 216, 96, 408, 204, 237, 58, 169, 441, 63, 100, 301, 169, 363, 441, 303, 408, 192, 511, 244, 162, 7, 454, 318, 357, 368, 282, 357, 147, 147, 249, 204, 468, 372, 131, 429, 296, 349, 202, 226, 370, 320, 389, 144, 265, 119, 68, 474, 376, 110, 77, 373, 320, 398, 454, 119, 399, 169, 169, 311, 327, 357, 284, 270, 497, 164, 68, 226, 258, 436, 361, 469, 354, 361, 192, 150, 367, 22, 454, 294, 412, 244, 357, 489, 429, 442, 147},
  {128, 307, 512, 335, 177, 72, 36, 414, 254, 493, 477, 114, 172, 503, 237, 41, 23, 488, 297, 176, 495, 114, 327, 431, 505, 10, 128, 44, 474, 72, 341, 220, 183, 112, 72, 131, 237, 34, 508, 134, 200, 394, 420, 335, 414, 288, 85, 210, 355, 5, 281, 85, 237, 83, 342, 281, 140, 301, 257, 254, 270, 397, 18, 474, 317, 341, 288, 440, 341, 53, 145, 298, 301, 281, 414, 5, 273, 57, 408, 158, 210, 230, 188, 222, 293, 334, 100, 377, 281, 135, 145, 489, 439, 106, 411, 88, 62, 248, 493, 342},
  {103, 114, 391, 320, 332, 448, 476, 122, 244, 421, 157, 146, 366, 68, 271, 411, 173, 173, 258, 441, 89, 444, 448, 271, 42, 351, 318, 187, 327, 221, 494, 411, 502, 394, 337, 193, 206, 53, 111, 357, 465, 384, 200, 273, 451, 451, 444, 281, 444, 318, 67, 421, 281, 175, 34, 111, 86, 257, 332, 444, 283, 294, 453, 444, 399, 15, 312, 263, 17, 366, 380, 337, 310, 508, 467, 273, 467, 320, 369, 15, 351, 206, 472, 498, 369, 154, 105, 42, 451, 394, 1, 366, 366, 383, 214, 53, 318, 202, 228, 202},
  {33, 496, 109, 396, 176, 158, 309, 126, 85, 50, 9, 240, 357, 429, 197, 107, 490, 373, 365, 450, 448, 399, 9, 302, 499, 2, 494, 90, 345, 460, 138, 13, 386, 126, 400, 439, 187, 460, 166, 138, 460, 13, 209, 53, 357, 98, 309, 137, 40, 400, 107, 345, 400, 178, 187, 280, 270, 76, 109, 472, 90, 192, 485, 25, 72, 422, 162, 25, 368, 21, 126, 205, 137, 50, 418, 460, 243, 388, 220, 13, 321, 499, 44, 487, 14, 292, 321, 28, 107, 90, 345, 362, 221, 46, 360, 276, 433, 109, 126, 357},
  {197, 24, 125, 47, 82, 172, 334, 326, 278, 397, 78, 305, 302, 61, 227, 278, 483, 326, 392, 316, 29, 51, 77, 157, 225, 184, 35, 225, 504, 21, 397, 3, 245, 77, 117, 160, 78, 104, 94, 454, 491, 410, 136, 398, 466, 51, 233, 434, 388, 196, 3, 70, 29, 383, 131, 386, 442, 283, 128, 18, 292, 181, 359, 337, 87, 302, 409, 104, 302, 386, 397, 219, 102, 172, 167, 265, 323, 23, 106, 222, 131, 189, 453, 279, 253, 86, 378, 358, 390, 1, 358, 149, 483, 341, 87, 310, 126, 35, 221, 498},
  {449, 292, 407, 24, 385, 73, 270, 469, 469, 302, 302, 413, 305, 139, 496, 190, 361, 387, 438, 129, 221, 137, 486, 233, 410, 270, 294, 336, 221, 387, 413, 10, 164, 256, 50, 186, 118, 95, 282, 181, 320, 256, 122, 263, 493, 336, 179, 333, 320, 274, 504, 305, 256, 257, 358, 198, 87, 136, 493, 29, 440, 211, 216, 128, 218, 68, 6, 286, 155, 333, 294, 139, 185, 4, 205, 493, 240, 139, 311, 179, 218, 256, 286, 74, 410, 503, 424, 274, 164, 264, 448, 410, 85, 175, 320, 108, 139, 266, 250, 469},
  {390, 509, 387, 322, 421, 451, 297, 351, 448, 63, 293, 65, 65, 226, 45, 201, 246, 139, 205, 8, 346, 142, 39, 484, 115, 450, 425, 38, 190, 219, 456, 38, 277, 330, 376, 231, 297, 246, 285, 34, 80, 240, 412, 506, 464, 376, 404, 47, 481, 75, 503, 190, 221, 23, 406, 49, 266, 34, 331, 437, 177, 70, 457, 160, 86, 82, 4, 510, 164, 456, 481, 380, 18, 436, 394, 313, 388, 5, 141, 387, 21, 39, 293, 24, 359, 257, 439, 82, 75, 341, 115, 221, 385, 137, 6, 448, 116, 448, 310, 297},
  {42, 475, 483, 74, 463, 176, 249, 124, 220, 461, 190, 176, 276, 356, 434, 461, 124, 25, 33, 276, 69, 328, 53, 254, 461, 139, 483, 201, 53, 356, 383, 254, 190, 365, 396, 478, 424, 403, 25, 400, 450, 403, 77, 164, 403, 139, 450, 475, 354, 254, 124, 406, 254, 62, 356, 283, 94, 354, 169, 44, 320, 291, 104, 298, 424, 361, 502, 458, 176, 314, 74, 154, 250, 106, 393, 139, 357, 300, 352, 45, 227, 348, 25, 365, 339, 255, 411, 206, 206, 361, 139, 483, 42, 70, 69, 354, 201, 220, 194, 47},
  {323, 145, 359, 331, 368, 153, 354, 378, 320, 286, 510, 8, 378, 13, 295, 399, 140, 310, 317, 338, 170, 438, 67, 71, 153, 79, 241, 474, 417, 449, 496, 221, 403, 346, 127, 229, 202, 92, 510, 176, 49, 476, 228, 43, 360, 494, 489, 79, 12, 295, 442, 79, 464, 476, 37, 8, 37, 332, 43, 79, 2, 331, 78, 510, 391, 396, 476, 472, 221, 8, 476, 446, 378, 476, 442, 343, 49, 195, 132, 197, 205, 307, 474, 103, 46, 343, 339, 240, 67, 378, 510, 156, 343, 213, 191, 205, 491, 159, 307, 33},
  {340, 380, 81, 409, 64, 50, 430, 452, 458, 270, 202, 367, 409, 121, 12, 243, 270, 246, 140, 275, 223, 312, 393, 184, 345, 503, 345, 246, 301, 167, 345, 25, 392, 210, 452, 204, 138, 395, 45, 72, 344, 499, 123, 380, 184, 256, 97, 68, 270, 312, 414, 17, 234, 286, 452, 154, 143, 318, 225, 457, 460, 356, 480, 155, 56, 437, 128, 493, 395, 45, 315, 175, 389, 78, 358, 494, 402, 359, 404, 97, 97, 167, 121, 312, 356, 159, 270, 77, 398, 423, 258, 68, 6, 344, 97, 345, 234, 258, 266, 499},
  {406, 30, 388, 185, 476, 109, 186, 256, 233, 135, 207, 474, 210, 338, 480, 413, 189, 190, 361, 341, 363, 6, 256, 109, 494, 457, 90, 274, 464, 63, 179, 494, 323, 408, 162, 49, 295, 428, 496, 354, 464, 90, 8, 373, 63, 121, 87, 388, 78, 484, 284, 109, 423, 48, 241, 162, 14, 121, 351, 284, 272, 502, 445, 109, 383, 220, 171, 23, 104, 6, 470, 306, 497, 428, 250, 195, 57, 270, 134, 143, 447, 365, 423, 266, 170, 306, 78, 200, 338, 232, 190, 250, 508, 4, 447, 274, 423, 272, 425, 480},
  {193, 193, 217, 466, 43, 170, 64, 167, 319, 67, 173, 64, 54, 113, 482, 348, 143, 338, 383, 458, 54, 511, 371, 4, 261, 355, 203, 54, 77, 444, 462, 102, 405, 307, 173, 179, 70, 249, 318, 136, 510, 182, 235, 22, 434, 435, 246, 232, 136, 263, 459, 487, 70, 6, 54, 288, 10, 7, 338, 226, 476, 112, 100, 33, 339, 110, 319, 435, 406, 435, 104, 379, 298, 485, 317, 338, 200, 32, 390, 103, 302, 147, 281, 283, 327, 35, 406, 170, 363, 371, 334, 70, 403, 366, 508, 22, 102, 4, 491, 505},
  {244, 125, 196, 349, 35, 49, 152, 387, 18, 42, 270, 154, 16, 466, 66, 507, 36, 196, 452, 55, 131, 263, 172, 120, 444, 349, 217, 357, 24, 220, 118, 126, 153, 291, 508, 297, 5, 121, 260, 137, 101, 101, 304, 223, 226, 357, 345, 470, 113, 416, 153, 427, 451, 209, 84, 501, 211, 357, 153, 36, 386, 15, 195, 328, 240, 131, 225, 232, 491, 509, 24, 274, 468, 153, 426, 321, 50, 69, 400, 240, 153, 382, 290, 268, 309, 153, 301, 17, 84, 349, 325, 357, 407, 316, 220, 196, 502, 252, 248, 477},
  {83, 157, 29, 169, 175, 485, 392, 125, 134, 419, 403, 200, 62, 468, 167, 486, 247, 316, 437, 138, 289, 247, 454, 419, 143, 431, 70, 480, 403, 186, 200, 117, 150, 325, 62, 292, 402, 289, 486, 125, 325, 388, 374, 425, 83, 402, 64, 329, 324, 459, 421, 227, 480, 255, 143, 25, 153, 328, 344, 421, 486, 334, 297, 403, 297, 366, 220, 79, 292, 236, 62, 143, 268, 240, 30, 480, 329, 9, 490, 486, 324, 111, 232, 239, 163, 41, 94, 214, 108, 62, 43, 64, 200, 448, 171, 459, 466, 422, 143, 431},
  {183, 95, 140, 247, 189, 193, 272, 264, 3, 134, 130, 512, 89, 341, 186, 231, 14, 27, 173, 79, 485, 400, 166, 94, 181, 23, 219, 464, 147, 341, 36, 402, 440, 169, 10, 29, 94, 447, 440, 405, 358, 124, 43, 271, 240, 384, 305, 10, 111, 350, 498, 39, 403, 89, 403, 144, 20, 503, 134, 496, 169, 214, 184, 438, 242, 63, 41, 193, 305, 80, 421, 316, 31, 169, 428, 144, 42, 63, 73, 80, 438, 373, 434, 431, 441, 429, 277, 440, 284, 181, 63, 100, 215, 321, 166, 42, 137, 193, 118, 400},
  {476, 29, 242, 149, 167, 499, 428, 194, 336, 298, 174, 35, 331, 251, 105, 75, 498, 427, 13, 106, 427, 10, 220, 270, 199, 319, 472, 354, 145, 372, 508, 178, 107, 178, 387, 191, 414, 97, 494, 35, 178, 331, 490, 212, 419, 75, 83, 125, 37, 510, 148, 237, 145, 220, 199, 102, 56, 323, 204, 232, 415, 253, 280, 508, 239, 173, 294, 372, 159, 37, 437, 277, 436, 83, 177, 25, 41, 203, 331, 306, 378, 277, 237, 228, 144, 187, 174, 97, 70, 321, 414, 205, 25, 192, 453, 494, 2, 75, 132, 502},
  {275, 355, 244, 85, 268, 6, 137, 204, 454, 352, 28, 150, 464, 250, 334, 214, 291, 157, 464, 408, 196, 118, 291, 408, 424, 257, 394, 503, 424, 67, 143, 295, 174, 454, 394, 415, 264, 478, 426, 368, 204, 96, 238, 89, 54, 114, 399, 264, 365, 247, 247, 477, 232, 242, 136, 85, 367, 269, 508, 115, 262, 136, 59, 407, 336, 28, 280, 72, 268, 247, 503, 150, 40, 67, 83, 150, 89, 41, 271, 480, 174, 335, 26, 27, 16, 76, 162, 303, 365, 17, 295, 50, 327, 399, 448, 454, 498, 283, 32, 85},
  {131, 134, 36, 287, 446, 410, 387, 309, 159, 290, 4, 438, 410, 131, 324, 177, 198, 442, 84, 438, 159, 503, 198, 290, 459, 94, 426, 444, 31, 336, 177, 309, 490, 48, 306, 301, 92, 367, 345, 313, 94, 239, 92, 100, 177, 46, 181, 395, 4, 155, 444, 350, 216, 471, 306, 115, 281, 320, 290, 279, 149, 457, 487, 38, 76, 336, 149, 48, 54, 418, 410, 372, 215, 79, 284, 250, 346, 317, 321, 132, 386, 507, 64, 208, 59, 370, 274, 386, 205, 410, 195, 352, 336, 306, 131, 512, 257, 418, 261, 395},
  {221, 308, 124, 8, 41, 168, 281, 229, 50, 404, 133, 326, 134, 36, 55, 468, 62, 199, 496, 61, 455, 358, 133, 50, 358, 109, 404, 157, 91, 161, 186, 475, 251, 21, 446, 106, 304, 401, 490, 352, 245, 68, 264, 137, 505, 361, 382, 463, 455, 490, 97, 209, 475, 179, 62, 109, 222, 217, 297, 317, 418, 167, 146, 62, 91, 272, 234, 93, 342, 134, 458, 468, 230, 452, 422, 186, 163, 3, 193, 340, 340, 71, 407, 291, 168, 492, 331, 209, 125, 97, 186, 199, 168, 129, 134, 330, 379, 91, 371, 481},
  {257, 80, 509, 174, 366, 315, 59, 360, 301, 383, 168, 378, 20, 71, 178, 301, 424, 9, 295, 475, 235, 479, 329, 301, 186, 81, 401, 82, 352, 367, 352, 93, 497, 168, 317, 256, 445, 202, 7, 371, 391, 88, 282, 354, 380, 493, 424, 461, 477, 175, 497, 442, 98, 65, 59, 248, 421, 58, 336, 352, 125, 460, 205, 352, 101, 445, 512, 13, 141, 352, 265, 367, 226, 66, 388, 47, 106, 418, 242, 383, 401, 136, 40, 159, 306, 442, 482, 284, 300, 47, 281, 82, 352, 367, 461, 445, 352, 383, 235, 253},
  {495, 132, 190, 344, 92, 127, 187, 445, 314, 172, 394, 3, 68, 257, 122, 270, 385, 3, 14, 400, 508, 253, 219, 460, 487, 65, 136, 127, 81, 90, 35, 35, 475, 11, 35, 485, 355, 217, 3, 482, 35, 373, 39, 36, 127, 341, 297, 428, 76, 74, 502, 435, 435, 108, 3, 478, 162, 209, 75, 201, 268, 448, 372, 49, 306, 98, 140, 225, 225, 511, 162, 21, 403, 409, 361, 130, 415, 482, 48, 207, 264, 359, 62, 423, 224, 493, 57, 297, 82, 278, 508, 11, 21, 294, 157, 460, 199, 82, 328, 501},
  {8, 22, 73, 117, 363, 245, 235, 15, 460, 220, 88, 509, 479, 276, 90, 176, 68, 220, 1, 336, 212, 346, 433, 212, 452, 88, 266, 406, 212, 276, 42, 484, 394, 236, 199, 74, 346, 68, 452, 87, 157, 214, 150, 112, 333, 421, 2, 36, 425, 60, 23, 131, 372, 262, 346, 462, 290, 248, 212, 346, 357, 184, 217, 455, 30, 257, 169, 221, 160, 88, 234, 161, 214, 308, 84, 311, 210, 70, 124, 357, 452, 452, 160, 76, 286, 234, 491, 294, 121, 318, 169, 508, 164, 148, 51, 266, 333, 333, 57, 425},
  {86, 36, 236, 208, 494, 436, 170, 151, 289, 289, 373, 481, 380, 120, 345, 359, 243, 409, 3, 179, 409, 2, 457, 206, 404, 359, 373, 26, 511, 409, 405, 67, 393, 490, 388, 343, 56, 199, 91, 169, 199, 26, 266, 248, 138, 172, 393, 48, 151, 373, 490, 496, 268, 503, 18, 55, 268, 484, 391, 393, 376, 225, 25, 424, 151, 457, 275, 316, 452, 128, 56, 84, 173, 457, 226, 120, 231, 400, 288, 337, 368, 70, 243, 311, 41, 106, 238, 189, 316, 61, 268, 506, 141, 302, 436, 195, 230, 375, 358, 289},
  {461, 427, 46, 488, 346, 464, 266, 419, 243, 214, 114, 491, 484, 101, 249, 391, 444, 359, 472, 48, 318, 377, 290, 172, 39, 39, 284, 340, 61, 39, 197, 442, 485, 377, 391, 498, 284, 230, 17, 71, 17, 452, 433, 96, 435, 305, 9, 447, 175, 237, 491, 53, 262, 86, 158, 441, 301, 272, 300, 162, 62, 423, 442, 398, 116, 17, 83, 391, 331, 427, 419, 262, 10, 400, 290, 212, 314, 446, 284, 264, 26, 294, 14, 398, 71, 89, 207, 88, 61, 136, 121, 243, 452, 320, 435, 262, 167, 284, 437, 214},
  {262, 375, 152, 156, 95, 217, 120, 48, 277, 138, 258, 36, 186, 138, 92, 164, 186, 230, 131, 268, 12, 424, 355, 400, 432, 9, 431, 481, 154, 473, 98, 510, 424, 288, 257, 157, 375, 93, 143, 216, 202, 370, 69, 128, 300, 66, 48, 73, 258, 509, 506, 258, 53, 106, 361, 110, 172, 481, 168, 481, 461, 383, 387, 131, 16, 67, 327, 452, 310, 483, 403, 402, 247, 310, 342, 310, 409, 311, 7, 451, 403, 453, 375, 229, 316, 323, 350, 87, 79, 459, 109, 258, 459, 121, 510, 48, 442, 154, 124, 68},
  {107, 164, 254, 148, 349, 460, 66, 33, 70, 53, 188, 332, 251, 57, 508, 33, 180, 376, 443, 349, 479, 220, 271, 25, 200, 7, 200, 210, 508, 385, 332, 51, 162, 159, 200, 264, 511, 496, 387, 495, 242, 25, 32, 35, 267, 486, 86, 496, 3, 174, 177, 482, 166, 152, 411, 294, 396, 99, 387, 125, 116, 226, 118, 367, 313, 400, 48, 411, 325, 301, 387, 472, 443, 437, 230, 506, 140, 65, 135, 271, 72, 173, 72, 348, 114, 144, 93, 506, 267, 70, 196, 332, 356, 141, 125, 103, 440, 3, 255, 212},
  {274, 40, 361, 307, 312, 46, 139, 352, 175, 24, 27, 137, 150, 316, 336, 103, 181, 463, 190, 294, 15, 217, 414, 64, 151, 78, 444, 175, 79, 59, 434, 414, 93, 400, 79, 308, 316, 137, 434, 180, 59, 237, 442, 209, 17, 4, 250, 387, 507, 212, 473, 161, 413, 239, 123, 349, 59, 414, 245, 389, 354, 106, 17, 197, 460, 463, 187, 413, 507, 187, 509, 122, 294, 463, 123, 275, 242, 135, 224, 187, 275, 349, 235, 249, 419, 319, 241, 463, 492, 309, 217, 322, 161, 275, 82, 117, 460, 362, 234, 378},
  {359, 399, 255, 282, 293, 248, 19, 269, 423, 12, 195, 128, 269, 74, 423, 225, 1, 164, 196, 101, 307, 375, 192, 24, 82, 31, 457, 458, 370, 374, 33, 458, 101, 202, 368, 366, 423, 483, 83, 331, 269, 269, 401, 149, 307, 269, 383, 292, 458, 446, 237, 38, 157, 195, 497, 176, 109, 313, 104, 325, 82, 127, 128, 346, 165, 286, 282, 508, 143, 269, 176, 488, 356, 192, 141, 225, 177, 72, 362, 269, 446, 43, 508, 79, 284, 375, 98, 12, 168, 468, 248, 497, 269, 301, 12, 12, 237, 475, 498, 458},
  {314, 191, 451, 25, 14, 162, 196, 461, 57, 231, 280, 458, 271, 97, 135, 82, 121, 55, 122, 147, 305, 448, 497, 220, 121, 58, 98, 305, 465, 330, 144, 352, 385, 287, 305, 352, 9, 167, 465, 389, 180, 216, 299, 174, 364, 275, 366, 26, 69, 124, 348, 162, 361, 247, 430, 33, 27, 220, 259, 512, 421, 119, 150, 465, 275, 269, 10, 504, 333, 252, 377, 477, 304, 73, 311, 24, 293, 357, 320, 231, 121, 82, 9, 357, 240, 178, 255, 40, 179, 421, 4, 211, 241, 470, 211, 121, 334, 179, 464, 73},
  {353, 88, 227, 13, 281, 152, 107, 332, 241, 409, 429, 209, 371, 78, 328, 170, 223, 302, 396, 366, 187, 415, 49, 218, 372, 429, 251, 275, 218, 310, 254, 109, 368, 409, 451, 14, 151, 223, 5, 428, 251, 366, 283, 290, 490, 344, 163, 433, 292, 200, 82, 198, 303, 489, 327, 428, 318, 15, 291, 479, 44, 451, 209, 302, 277, 57, 498, 78, 87, 363, 264, 489, 267, 414, 363, 354, 282, 66, 482, 429, 209, 100, 262, 193, 215, 120, 95, 363, 218, 151, 157, 87, 63, 185, 209, 193, 450, 471, 382, 319},
  {258, 400, 164, 269, 263, 381, 62, 402, 326, 90, 101, 264, 332, 332, 224, 136, 368, 283, 362, 286, 402, 291, 392, 264, 312, 232, 271, 36, 232, 71, 258, 104, 283, 240, 293, 371, 283, 254, 250, 96, 291, 164, 146, 501, 181, 422, 443, 326, 224, 209, 271, 398, 283, 408, 332, 313, 6, 4, 487, 71, 178, 189, 72, 436, 258, 115, 443, 347, 402, 423, 72, 90, 292, 254, 413, 293, 176, 489, 450, 181, 496, 276, 271, 207, 54, 81, 372, 432, 258, 289, 309, 402, 342, 101, 199, 217, 436, 259, 36, 308},
  {394, 182, 282, 172, 367, 228, 48, 450, 17, 395, 129, 511, 222, 451, 56, 257, 436, 298, 64, 198, 420, 371, 340, 76, 267, 268, 127, 23, 169, 482, 355, 379, 67, 199, 406, 124, 285, 117, 351, 415, 501, 174, 281, 309, 49, 112, 162, 223, 228, 198, 42, 397, 104, 382, 366, 163, 125, 227, 340, 406, 131, 140, 333, 129, 264, 340, 446, 397, 322, 397, 60, 243, 390, 268, 409, 42, 261, 213, 114, 28, 41, 42, 511, 306, 112, 77, 370, 340, 371, 340, 193, 137, 371, 473, 32, 451, 449, 17, 224, 298},
  {156, 200, 170, 312, 381, 8, 408, 388, 388, 445, 44, 141, 98, 118, 325, 169, 211, 286, 70, 87, 327, 256, 377, 222, 132, 408, 286, 18, 74, 406, 68, 247, 38, 265, 84, 138, 261, 169, 325, 221, 475, 22, 406, 219, 453, 423, 500, 286, 299, 53, 188, 199, 445, 266, 256, 243, 137, 153, 166, 475, 139, 442, 172, 159, 74, 174, 134, 325, 98, 18, 286, 464, 335, 68, 289, 420, 358, 318, 392, 233, 211, 299, 397, 231, 32, 328, 292, 420, 387, 211, 423, 461, 445, 352, 365, 342, 68, 165, 205, 199},
  {147, 53, 503, 387, 357, 385, 348, 475, 292, 86, 466, 420, 401, 243, 103, 387, 191, 161, 56, 155, 387, 76, 348, 77, 277, 306, 446, 212, 202, 203, 335, 68, 167, 165, 299, 37, 267, 348, 385, 240, 410, 365, 173, 297, 280, 273, 385, 356, 463, 91, 320, 410, 40, 361, 387, 30, 430, 329, 59, 59, 68, 240, 300, 306, 104, 59, 150, 356, 433, 167, 453, 450, 330, 379, 305, 485, 3, 200, 496, 234, 147, 356, 41, 299, 196, 469, 12, 474, 187, 91, 112, 167, 299, 50, 136, 323, 432, 103, 204, 306},
  {12, 376, 506, 376, 327, 86, 175, 412, 41, 376, 364, 421, 359, 156, 323, 31, 489, 438, 72, 285, 41, 376, 505, 249, 376, 145, 170, 463, 40, 477, 235, 404, 156, 72, 46, 221, 364, 505, 332, 330, 3, 265, 347, 294, 213, 52, 415, 319, 72, 207, 207, 129, 219, 177, 348, 9, 231, 224, 388, 86, 126, 46, 109, 460, 137, 279, 489, 364, 460, 415, 251, 87, 112, 86, 126, 69, 465, 109, 202, 435, 95, 468, 207, 22, 193, 108, 134, 422, 287, 216, 487, 283, 376, 279, 93, 268, 355, 251, 58, 447},
  {34, 202, 172, 33, 496, 360, 422, 148, 162, 427, 484, 11, 264, 290, 239, 427, 48, 368, 442, 38, 240, 170, 65, 240, 449, 437, 293, 241, 368, 427, 314, 170, 293, 318, 31, 305, 171, 212, 156, 15, 85, 297, 298, 187, 348, 474, 198, 437, 471, 471, 293, 360, 434, 296, 376, 273, 480, 279, 449, 264, 7, 248, 431, 502, 58, 447, 247, 329, 471, 84, 404, 162, 306, 28, 66, 149, 397, 42, 217, 109, 187, 342, 296, 273, 155, 145, 233, 241, 142, 104, 335, 241, 355, 272, 148, 224, 483, 351, 275, 268},
  {104, 467, 455, 485, 250, 362, 324, 3, 345, 262, 102, 392, 87, 315, 298, 145, 366, 271, 60, 54, 286, 196, 13, 279, 87, 91, 65, 315, 104, 83, 464, 474, 114, 250, 327, 413, 18, 114, 145, 284, 431, 227, 120, 18, 178, 469, 227, 263, 502, 408, 114, 362, 479, 377, 83, 464, 380, 441, 163, 239, 65, 464, 419, 237, 246, 297, 198, 362, 145, 297, 121, 71, 258, 114, 353, 132, 234, 84, 262, 71, 490, 40, 202, 336, 204, 9, 501, 41, 6, 337, 490, 37, 315, 3, 145, 449, 503, 288, 230, 434},
  {39, 229, 486, 277, 112, 323, 130, 94, 403, 379, 438, 359, 328, 18, 435, 234, 261, 261, 299, 281, 271, 430, 430, 99, 333, 337, 315, 171, 46, 116, 460, 425, 333, 493, 405, 216, 290, 470, 380, 350, 234, 377, 510, 498, 222, 225, 217, 51, 348, 182, 484, 312, 79, 449, 419, 141, 371, 362, 18, 312, 266, 425, 254, 207, 448, 430, 127, 479, 69, 312, 443, 10, 54, 403, 170, 348, 174, 224, 191, 107, 102, 493, 167, 44, 58, 8, 260, 185, 379, 258, 379, 403, 298, 340, 34, 28, 97, 191, 369, 379},
  {223, 285, 39, 84, 488, 120, 493, 495, 20, 430, 241, 492, 74, 261, 495, 361, 284, 279, 167, 379, 79, 33, 476, 194, 278, 284, 42, 49, 116, 202, 465, 233, 281, 249, 151, 488, 177, 476, 478, 114, 33, 229, 357, 246, 79, 414, 218, 107, 83, 213, 476, 100, 153, 261, 440, 279, 221, 453, 241, 278, 468, 268, 398, 495, 34, 349, 190, 119, 2, 449, 228, 449, 257, 405, 298, 190, 172, 184, 167, 369, 379, 73, 412, 280, 13, 502, 204, 229, 144, 213, 478, 38, 492, 34, 293, 405, 279, 62, 38, 183},
  {344, 138, 270, 281, 289, 54, 22, 257, 212, 331, 104, 49, 286, 136, 219, 111, 94, 176, 486, 77, 176, 257, 59, 329, 425, 465, 123, 110, 379, 379, 174, 225, 347, 301, 54, 347, 461, 399, 400, 56, 130, 49, 450, 486, 379, 182, 461, 431, 285, 141, 32, 211, 22, 229, 313, 185, 46, 488, 399, 257, 301, 117, 176, 219, 168, 347, 251, 6, 67, 331, 440, 426, 38, 59, 204, 477, 413, 371, 472, 379, 59, 426, 111, 466, 475, 426, 84, 494, 479, 286, 54, 229, 331, 150, 165, 170, 479, 461, 237, 462},
  {226, 315, 372, 302, 246, 339, 156, 295, 274, 20, 144, 225, 452, 478, 408, 258, 467, 430, 243, 5, 2, 404, 168, 9, 263, 372, 306, 365, 328, 253, 20, 72, 379, 78, 343, 21, 326, 430, 274, 126, 419, 364, 110, 453, 295, 426, 130, 45, 146, 137, 289, 182, 397, 273, 144, 274, 500, 290, 133, 347, 182, 37, 75, 69, 430, 385, 305, 448, 78, 326, 92, 208, 430, 206, 274, 87, 295, 228, 484, 159, 326, 397, 178, 483, 226, 183, 330, 38, 408, 71, 430, 275, 20, 254, 241, 399, 293, 228, 111, 397},
  {372, 277, 277, 305, 186, 458, 487, 345, 478, 492, 76, 17, 284, 449, 396, 315, 65, 150, 171, 321, 288, 235, 354, 42, 226, 302, 150, 333, 270, 362, 209, 209, 226, 92, 161, 420, 47, 444, 509, 80, 483, 247, 336, 504, 346, 391, 302, 257, 17, 33, 463, 110, 509, 319, 345, 416, 376, 68, 337, 441, 92, 101, 197, 106, 33, 500, 424, 110, 345, 136, 170, 492, 477, 416, 434, 382, 377, 15, 377, 106, 382, 76, 295, 215, 87, 494, 267, 491, 319, 210, 434, 491, 499, 232, 277, 76, 403, 226, 238, 106},
  {444, 147, 55, 65, 215, 292, 280, 22, 81, 185, 351, 298, 229, 134, 281, 22, 155, 163, 426, 233, 456, 378, 351, 331, 25, 331, 386, 119, 185, 457, 22, 141, 49, 73, 312, 506, 412, 369, 128, 334, 393, 226, 289, 260, 292, 470, 215, 187, 412, 37, 149, 444, 205, 405, 4, 351, 381, 287, 65, 205, 473, 481, 373, 412, 205, 495, 85, 378, 88, 341, 429, 116, 289, 9, 156, 331, 92, 159, 166, 378, 273, 386, 393, 433, 205, 388, 163, 65, 468, 35, 408, 386, 292, 100, 488, 271, 386, 273, 177, 43},
  {214, 473, 405, 342, 79, 169, 397, 367, 467, 252, 47, 467, 412, 330, 403, 72, 169, 151, 192, 10, 459, 433, 54, 107, 436, 151, 288, 95, 296, 9, 252, 243, 374, 500, 316, 150, 115, 275, 38, 293, 342, 72, 263, 202, 137, 372, 169, 171, 500, 125, 68, 330, 35, 114, 412, 485, 511, 261, 9, 403, 53, 152, 200, 243, 164, 125, 78, 350, 75, 169, 243, 54, 148, 389, 87, 200, 266, 316, 24, 350, 243, 350, 370, 333, 119, 446, 61, 86, 361, 372, 200, 176, 316, 230, 18, 422, 133, 316, 376, 64},
  {412, 341, 223, 324, 241, 445, 327, 117, 189, 229, 131, 486, 260, 47, 70, 94, 95, 129, 424, 344, 254, 379, 20, 353, 194, 67, 134, 497, 339, 233, 176, 216, 22, 161, 188, 376, 73, 194, 429, 312, 22, 108, 181, 318, 269, 358, 374, 151, 447, 389, 458, 297, 359, 54, 108, 47, 476, 426, 458, 419, 34, 94, 365, 330, 129, 465, 494, 161, 357, 339, 310, 427, 14, 472, 248, 270, 298, 37, 269, 341, 238, 481, 168, 196, 200, 223, 344, 210, 481, 238, 134, 423, 309, 168, 414, 505, 151, 194, 218, 415},
  {385, 468, 198, 498, 484, 349, 122, 375, 493, 151, 84, 216, 224, 269, 132, 330, 199, 39, 378, 378, 117, 419, 207, 39, 311, 419, 290, 409, 407, 11, 473, 54, 130, 242, 375, 196, 487, 279, 280, 55, 472, 39, 204, 330, 86, 129, 493, 422, 327, 100, 169, 171, 137, 192, 33, 290, 22, 17, 443, 280, 278, 472, 167, 64, 187, 414, 200, 335, 208, 419, 493, 76, 408, 171, 344, 151, 333, 128, 365, 283, 429, 199, 493, 109, 280, 251, 7, 150, 199, 279, 280, 452, 117, 120, 92, 361, 286, 12, 4, 116},
  {144, 320, 355, 495, 106, 453, 138, 58, 485, 58, 395, 102, 214, 193, 362, 223, 380, 213, 341, 226, 269, 186, 123, 499, 493, 181, 252, 471, 186, 31, 199, 76, 395, 328, 325, 130, 58, 426, 362, 184, 395, 28, 419, 456, 11, 492, 84, 186, 446, 204, 391, 446, 322, 132, 184, 309, 26, 94, 26, 213, 505, 160, 80, 446, 184, 235, 252, 5, 512, 289, 161, 181, 177, 419, 194, 247, 395, 285, 388, 434, 428, 190, 20, 204, 147, 229, 248, 84, 405, 161, 328, 200, 11, 160, 58, 11, 495, 394, 31, 136},
  {506, 115, 367, 267, 198, 439, 68, 320, 253, 88, 103, 124, 248, 298, 95, 501, 53, 89, 179, 243, 216, 22, 317, 288, 458, 258, 468, 149, 141, 433, 378, 322, 378, 235, 45, 108, 98, 56, 488, 485, 458, 245, 454, 500, 123, 356, 56, 345, 368, 168, 58, 149, 446, 121, 322, 298, 117, 198, 288, 40, 356, 259, 306, 179, 53, 378, 213, 99, 248, 420, 288, 378, 290, 317, 172, 253, 199, 219, 237, 412, 124, 306, 275, 492, 2, 60, 368, 168, 145, 124, 458, 47, 208, 108, 41, 45, 316, 367, 489, 381},
  {186, 176, 412, 411, 100, 203, 63, 140, 165, 489, 503, 275, 200, 353, 101, 511, 313, 145, 53, 40, 25, 108, 212, 244, 44, 1, 498, 292, 28, 300, 466, 509, 90, 208, 386, 77, 83, 278, 228, 28, 280, 298, 430, 180, 368, 183, 32, 70, 183, 322, 275, 463, 108, 186, 212, 503, 370, 27, 260, 438, 360, 368, 180, 264, 498, 335, 268, 245, 90, 446, 260, 50, 321, 108, 461, 11, 418, 412, 329, 371, 203, 352, 1, 144, 150, 31, 89, 495, 28, 201, 407, 296, 463, 216, 72, 120, 14, 99, 122, 438},
  {384, 254, 132, 255, 377, 409, 276, 448, 188, 365, 333, 400, 136, 369, 276, 84, 421, 122, 419, 95, 136, 125, 459, 450, 385, 189, 91, 307, 188, 189, 451, 165, 332, 309, 459, 2, 333, 329, 148, 314, 243, 112, 12, 333, 425, 369, 369, 403, 229, 285, 385, 155, 419, 173, 309, 342, 33, 314, 365, 267, 424, 197, 403, 391, 226, 244, 256, 267, 285, 285, 365, 200, 240, 189, 185, 110, 287, 249, 172, 125, 65, 383, 148, 25, 449, 208, 468, 425, 250, 165, 405, 409, 188, 85, 236, 6, 105, 361, 300, 294},
  {334, 55, 214, 125, 213, 371, 21, 324, 420, 420, 391, 196, 43, 391, 96, 12, 221, 441, 425, 247, 312, 391, 251, 351, 131, 420, 351, 154, 271, 346, 457, 229, 172, 461, 258, 166, 391, 229, 487, 198, 286, 221, 353, 38, 311, 301, 265, 393, 345, 84, 386, 391, 202, 299, 150, 469, 82, 255, 286, 122, 457, 2, 249, 206, 280, 172, 170, 92, 92, 190, 413, 47, 22, 150, 179, 221, 33, 212, 385, 140, 251, 221, 251, 438, 378, 371, 317, 13, 221, 271, 391, 234, 337, 214, 172, 295, 301, 441, 172, 196},
  {78, 422, 298, 154, 470, 165, 177, 110, 380, 128, 263, 147, 42, 485, 68, 343, 509, 257, 244, 71, 335, 59, 395, 200, 103, 170, 343, 332, 166, 237, 407, 294, 407, 87, 511, 475, 200, 485, 108, 504, 191, 338, 237, 207, 59, 179, 71, 378, 112, 77, 364, 4, 103, 164, 71, 153, 289, 250, 81, 4, 19, 287, 408, 365, 281, 26, 214, 54, 477, 501, 475, 250, 432, 81, 71, 59, 363, 79, 13, 188, 329, 409, 501, 227, 483, 284, 209, 365, 335, 25, 294, 353, 509, 296, 459, 59, 221, 97, 452, 439},
  {196, 471, 159, 315, 199, 87, 247, 305, 228, 315, 414, 477, 174, 376, 107, 381, 367, 390, 323, 412, 376, 390, 280, 228, 433, 444, 331, 134, 331, 286, 340, 81, 331, 280, 381, 283, 160, 149, 8, 76, 347, 166, 161, 147, 390, 298, 292, 53, 2, 399, 49, 340, 286, 97, 189, 43, 195, 203, 339, 1, 225, 476, 341, 81, 29, 211, 91, 315, 64, 150, 175, 64, 416, 280, 59, 134, 158, 150, 123, 381, 232, 480, 381, 138, 361, 61, 356, 21, 433, 149, 381, 388, 257, 200, 390, 245, 468, 414, 478, 41},
  {309, 365, 394, 179, 339, 387, 452, 44, 382, 44, 58, 319, 246, 354, 128, 460, 386, 434, 223, 270, 460, 102, 460, 286, 16, 122, 67, 17, 102, 195, 58, 88, 306, 201, 97, 50, 306, 319, 142, 437, 92, 343, 277, 24, 102, 434, 357, 290, 485, 434, 487, 117, 229, 17, 102, 206, 49, 139, 446, 258, 91, 272, 340, 102, 172, 493, 407, 194, 487, 133, 117, 500, 341, 187, 55, 147, 458, 67, 427, 67, 474, 501, 352, 496, 396, 37, 129, 117, 136, 496, 227, 407, 474, 189, 354, 475, 109, 319, 168, 194},
  {29, 390, 444, 451, 261, 20, 162, 435, 86, 224, 242, 79, 169, 270, 406, 229, 391, 458, 411, 139, 463, 409, 498, 78, 165, 248, 349, 426, 41, 99, 311, 437, 7, 270, 480, 448, 148, 165, 227, 511, 310, 468, 411, 466, 299, 282, 458, 236, 1, 406, 337, 30, 510, 154, 132, 251, 84, 249, 373, 293, 362, 85, 133, 468, 320, 127, 49, 406, 229, 34, 408, 115, 441, 173, 171, 502, 68, 488, 136, 8, 282, 30, 211, 140, 127, 137, 414, 30, 480, 256, 20, 75, 127, 186, 298, 403, 446, 20, 294, 453},
  {142, 295, 191, 77, 31, 110, 372, 206, 155, 271, 491, 268, 135, 433, 347, 236, 195, 343, 20, 241, 340, 317, 72, 278, 241, 219, 466, 219, 201, 206, 257, 326, 312, 189, 277, 342, 23, 39, 393, 113, 343, 434, 396, 505, 347, 206, 268, 391, 167, 72, 328, 337, 87, 26, 63, 70, 314, 245, 172, 99, 31, 415, 327, 16, 163, 343, 261, 156, 70, 317, 379, 233, 179, 326, 201, 482, 66, 4, 208, 362, 244, 500, 366, 157, 122, 232, 212, 19, 236, 163, 23, 9, 149, 163, 176, 328, 429, 409, 8, 157},
  {408, 472, 417, 112, 183, 277, 477, 284, 335, 386, 365, 248, 28, 340, 305, 378, 423, 340, 105, 403, 395, 350, 386, 481, 294, 256, 190, 317, 294, 94, 323, 275, 274, 294, 358, 399, 275, 334, 239, 311, 257, 277, 55, 365, 52, 180, 317, 334, 323, 485, 334, 214, 317, 15, 277, 429, 90, 183, 294, 334, 284, 315, 126, 284, 81, 389, 107, 248, 432, 403, 381, 422, 5, 443, 480, 360, 274, 87, 146, 66, 467, 316, 317, 37, 211, 467, 351, 370, 370, 194, 284, 248, 323, 218, 184, 147, 196, 410, 212, 293},
  {211, 330, 4, 204, 371, 492, 474, 395, 361, 442, 423, 204, 508, 482, 5, 95, 160, 256, 503, 319, 383, 132, 341, 74, 52, 27, 361, 19, 211, 86, 74, 492, 177, 147, 457, 44, 122, 333, 503, 434, 249, 160, 307, 77, 415, 204, 401, 365, 427, 131, 36, 256, 279, 148, 257, 410, 54, 200, 19, 483, 465, 52, 351, 30, 57, 35, 500, 16, 27, 293, 279, 86, 181, 19, 119, 395, 505, 338, 176, 355, 112, 249, 424, 345, 439, 317, 125, 4, 482, 150, 457, 16, 425, 158, 261, 95, 457, 317, 86, 235},
  {210, 393, 498, 164, 90, 398, 8, 417, 364, 95, 77, 461, 398, 398, 9, 287, 275, 412, 326, 200, 440, 36, 398, 173, 478, 126, 36, 483, 191, 173, 166, 301, 214, 173, 235, 364, 49, 54, 77, 349, 32, 110, 244, 20, 9, 328, 451, 226, 198, 478, 347, 148, 280, 490, 478, 301, 239, 498, 368, 110, 251, 492, 173, 54, 236, 356, 389, 463, 126, 198, 495, 246, 13, 214, 249, 256, 62, 13, 122, 137, 85, 280, 173, 110, 443, 130, 373, 36, 173, 137, 148, 54, 132, 398, 173, 124, 311, 196, 137, 38},
  {79, 435, 245, 341, 400, 112, 206, 83, 480, 440, 74, 406, 485, 168, 8, 168, 92, 50, 476, 262, 253, 83, 299, 313, 100, 462, 406, 253, 121, 55, 100, 313, 160, 117, 432, 180, 6, 170, 291, 497, 100, 446, 172, 424, 40, 299, 33, 112, 116, 83, 437, 456, 505, 134, 100, 329, 464, 39, 353, 462, 23, 489, 52, 400, 138, 245, 242, 274, 183, 258, 364, 228, 160, 92, 233, 83, 162, 169, 276, 253, 274, 7, 480, 26, 8, 417, 418, 141, 344, 33, 462, 364, 406, 83, 170, 376, 183, 33, 267, 121},
  {21, 113, 207, 92, 427, 232, 32, 262, 409, 402, 437, 316, 316, 107, 40, 237, 3, 499, 457, 31, 147, 451, 150, 457, 49, 207, 201, 499, 220, 353, 290, 297, 507, 262, 187, 471, 324, 324, 512, 85, 499, 346, 198, 49, 258, 201, 471, 332, 14, 3, 24, 26, 499, 250, 284, 262, 347, 230, 322, 488, 246, 228, 326, 59, 499, 88, 219, 142, 346, 232, 339, 70, 401, 290, 121, 407, 411, 314, 120, 229, 419, 3, 187, 150, 385, 133, 470, 207, 353, 113, 270, 49, 220, 204, 284, 420, 290, 157, 138, 114},
  {302, 186, 283, 216, 164, 100, 413, 398, 158, 132, 432, 398, 266, 326, 145, 504, 442, 79, 354, 420, 193, 373, 25, 327, 362, 115, 428, 81, 373, 266, 326, 471, 148, 105, 132, 243, 286, 411, 411, 98, 118, 306, 253, 401, 320, 362, 25, 384, 243, 179, 115, 479, 376, 458, 258, 58, 25, 163, 345, 64, 384, 386, 95, 249, 326, 362, 384, 179, 327, 25, 330, 413, 239, 297, 308, 249, 328, 226, 54, 258, 454, 458, 266, 274, 74, 423, 310, 295, 202, 320, 19, 405, 471, 404, 132, 34, 327, 79, 482, 310},
  {205, 27, 501, 214, 341, 386, 113, 152, 304, 447, 345, 145, 394, 487, 133, 117, 495, 394, 308, 151, 184, 491, 387, 387, 363, 262, 421, 475, 86, 75, 132, 496, 15, 30, 12, 408, 129, 327, 15, 41, 215, 260, 31, 282, 454, 141, 491, 152, 129, 327, 108, 363, 75, 274, 230, 277, 492, 142, 211, 411, 159, 314, 188, 86, 293, 49, 363, 262, 366, 184, 37, 365, 380, 368, 100, 204, 422, 28, 270, 281, 281, 211, 347, 84, 179, 264, 151, 129, 345, 118, 293, 108, 496, 44, 421, 15, 42, 15, 135, 63},
  {355, 126, 24, 358, 387, 309, 468, 154, 313, 82, 128, 386, 34, 309, 153, 123, 254, 16, 29, 117, 417, 283, 417, 273, 233, 321, 34, 408, 386, 34, 286, 469, 16, 99, 212, 372, 429, 193, 438, 310, 262, 179, 230, 37, 249, 276, 327, 450, 347, 239, 313, 462, 289, 50, 441, 254, 83, 130, 283, 270, 420, 360, 8, 183, 143, 187, 435, 417, 16, 433, 191, 128, 510, 386, 63, 143, 382, 96, 338, 349, 60, 321, 60, 187, 91, 23, 289, 320, 388, 407, 492, 372, 129, 476, 283, 106, 256, 355, 233, 388},
  {438, 46, 348, 150, 276, 83, 415, 405, 443, 64, 94, 126, 93, 234, 353, 477, 333, 115, 214, 279, 22, 319, 155, 211, 78, 56, 155, 84, 350, 317, 474, 328, 158, 43, 87, 235, 182, 140, 247, 388, 236, 43, 126, 15, 405, 209, 261, 88, 126, 88, 344, 118, 319, 438, 507, 225, 456, 43, 182, 487, 317, 486, 234, 182, 128, 140, 248, 12, 114, 39, 59, 460, 56, 350, 31, 248, 375, 271, 60, 225, 296, 440, 350, 176, 252, 49, 23, 55, 510, 96, 319, 150, 114, 298, 62, 510, 277, 484, 241, 140},
  {148, 190, 162, 242, 70, 370, 374, 511, 498, 387, 392, 465, 370, 66, 344, 1, 404, 315, 495, 401, 211, 50, 324, 505, 316, 252, 143, 378, 505, 109, 241, 97, 48, 23, 11, 96, 146, 189, 262, 256, 11, 450, 101, 254, 109, 471, 396, 425, 422, 370, 175, 505, 120, 488, 349, 358, 104, 157, 50, 337, 328, 267, 371, 324, 410, 190, 483, 320, 440, 262, 252, 303, 106, 358, 316, 109, 54, 492, 241, 216, 18, 66, 314, 83, 456, 171, 335, 388, 349, 434, 370, 23, 344, 124, 306, 96, 399, 41, 14, 39},
  {159, 299, 34, 119, 201, 364, 292, 116, 487, 55, 153, 73, 382, 436, 190, 38, 445, 13, 284, 152, 473, 225, 367, 48, 235, 356, 84, 345, 156, 210, 70, 48, 27, 27, 477, 381, 232, 48, 241, 168, 270, 497, 135, 342, 205, 101, 147, 193, 255, 461, 318, 356, 309, 43, 91, 105, 30, 490, 161, 356, 121, 474, 134, 311, 389, 240, 367, 186, 469, 235, 71, 300, 208, 141, 365, 432, 34, 223, 110, 195, 135, 283, 448, 21, 50, 373, 442, 445, 413, 64, 356, 367, 487, 97, 70, 181, 55, 270, 99, 4},
  {269, 244, 383, 496, 330, 306, 108, 6, 11, 255, 32, 351, 448, 229, 279, 508, 184, 184, 91, 186, 214, 437, 368, 241, 11, 448, 445, 88, 200, 339, 1, 71, 26, 91, 130, 377, 123, 493, 414, 231, 322, 467, 285, 408, 198, 138, 12, 350, 442, 402, 46, 445, 258, 72, 511, 56, 218, 109, 448, 276, 496, 402, 415, 90, 109, 205, 345, 116, 60, 336, 22, 259, 53, 205, 73, 108, 310, 477, 91, 116, 363, 243, 6, 20, 76, 75, 244, 286, 111, 296, 491, 158, 56, 84, 445, 116, 324, 214, 95, 475},
  {430, 26, 284, 14, 143, 131, 486, 91, 135, 240, 193, 72, 75, 396, 291, 306, 13, 507, 126, 337, 388, 169, 285, 377, 507, 203, 101, 141, 13, 16, 128, 371, 8, 55, 90, 127, 266, 192, 266, 145, 384, 473, 57, 449, 90, 152, 473, 262, 318, 65, 299, 28, 168, 470, 442, 483, 38, 88, 429, 119, 38, 493, 89, 296, 384, 487, 507, 111, 425, 218, 143, 271, 217, 262, 436, 199, 1, 393, 81, 75, 81, 180, 101, 16, 405, 211, 186, 285, 485, 52, 338, 328, 473, 407, 233, 286, 394, 468, 98, 384},
  {109, 482, 271, 82, 265, 142, 347, 285, 424, 285, 497, 309, 347, 303, 506, 24, 18, 185, 440, 348, 333, 394, 206, 49, 209, 155, 81, 155, 276, 470, 401, 498, 477, 32, 285, 219, 431, 99, 206, 161, 227, 89, 60, 432, 126, 264, 333, 161, 207, 385, 270, 394, 385, 461, 449, 73, 113, 20, 442, 3, 202, 142, 253, 470, 347, 62, 52, 381, 1, 347, 3, 401, 39, 89, 500, 107, 5, 233, 33, 185, 55, 457, 509, 259, 296, 185, 314, 249, 43, 173, 511, 291, 126, 208, 99, 94, 25, 142, 93, 463},
  {203, 120, 149, 41, 462, 77, 448, 162, 506, 455, 419, 138, 449, 343, 380, 184, 149, 258, 263, 191, 149, 340, 429, 352, 26, 80, 161, 113, 80, 181, 64, 46, 473, 338, 110, 213, 218, 179, 489, 411, 455, 64, 508, 305, 342, 472, 122, 7, 246, 161, 40, 380, 308, 479, 307, 161, 249, 377, 82, 319, 232, 93, 31, 73, 77, 492, 246, 422, 509, 387, 422, 8, 414, 319, 33, 80, 75, 501, 452, 64, 319, 264, 30, 216, 161, 217, 428, 184, 342, 199, 93, 319, 123, 77, 424, 149, 40, 280, 62, 261}
};


// characteristics of NOLH tables
static struct { int kMin, kMax, n1, n2, loLevel, hiLevel, *table; } NOLH[ ] = {
  { 0, 0, 0, 0, 0, 0, NULL },
  { 1, 7, 17, 33, 1, 17, NOLH_1[ 0 ] },
  { 8, 11, 33, 65, 1, 33, NOLH_2[ 0 ] },
  { 12, 16, 65, 129, 1, 65, NOLH_3[ 0 ] },
  { 17, 22, 129, 257, 1, 129, NOLH_4[ 0 ] },
  { 23, 29, 257, 257, 1, 257, NOLH_5[ 0 ] },
  { 30, 100, 512, 512, 1, 512, NOLH_6[ 0 ] }
};
