# LSD, Abmat and SimpleDOE

## LSD
Labortory for Simulation development, short **LSD**, is an integrated development framework (IDE) to produce, run and analyse agent-based models (ABMs). The process of building and validating the ABM can completely be done within LSD, using:
- the LSD Model Manager (LMM) to do the coding, 
- the LSD-Browser to set up the model structure in a manner very similar to UML (unified modelling language) Class-Diagram, 
- the LSD-Browser to run small samples and directly analyse the results to *vaildate* and *understand* the model implementation,
- the LSD-Browser to define simple Design-of-Experiments and set up automated batch-runs (using parallelisation, if whished for),
- ?? 

LSD already offers an intuitive and easy way to save time-series data. You simply mark a variable for saving in the LSD Browser. There are two standard options: save and save_single, the later will create a single file for each variable saved, containing the time-series data. The former will gather the data in a results file that can be zipped. If you run a batch of simulations, each run creates its own results file. Typically each run is thus associated to a single *.lsd* model file that contains the model and also the code (so its self-sustained) and a results file.  In addition to the time-series data, a totals file will be created in batch runs. In standard LSD is save the last datum (data point) for each time-series.

LSD automatically takes care of endogenous variables by tracking new variables that are created and also keeping data of variables that are deleted during the simulation.

For full information on *LSD*, please take a look at the html documentation: 
```Lsd/Manual/LSD_documentation.html```

## ABMAT
ABMAT is short for "ABM Analysis Toolkit" and provides utilities to automate part of the analysis of ABMs created with LSD. The ABMAT extension reduces the time needed for analysis and as a result improves the analysis by taking (what I term) a *managable big-data approach*. It is thus a part of an effective toolchain to improve the analysis of ABMs. 

ABMAT is completely detached from the normal model and will not interfere with it. Technically, statistics are gathered at the end of each simulation step outside of the updating scheme of LSD. ABMAT helps to create rich time-series data that is storred in the usual way in LSD results file. It also performs some analysis on this data, enriching the totals file and allowing a fast but detailed analysis of simulation runs by providing *clean and structured data*. The data is organised in a flat structure (using specific formats for the file names) so that each simulation run creates a bunch of scalar values (for a single macro variable currently 14 values, for a micro variable this number is squared, again), which can be explored easily by means of visualisation and is also ready to perform statistical analysis.

*Preliminary: In principle we could store all the multi-level data in such a way that we can post-process all the relations we want to. But this is tidius (so nobody does it), time consuming (you need to manually set-up the analysis, safe the data and load it back) and disk-space consuming (you generate a lot of intermediate data), etc. And remeber: If you want to do an analysis (after having lookied at all the data that you got so neatly organised because you used ABMAT), you can still gather the data by simple redoing the computational experiment, and this will be much faster. ABMAT shall help to understand the model and generate hypothesis. It is not a substitute for the definition of specific measurements and analysis!*

ABMAT categorises output variables in four types: **Macro**, **Micro**, **Comparative-Macro (Comp)** and **Conditional-Micro (Cond)** variables. In addition, it also takes care of saving the parameters (**P-Static**,**P-Micro**,**P-Macro**) alongside the data. A Macro variable is the typical single variable time-series. A Micro variable is a typical agent-level (heterogeneous) variable. The Micro-Conditional variable allows to automatically subset micro variables with the help of an additional variable (in R speech: Factor). Consider an agent has an attribute age and a second attribute region, this would allows us to build agent-sets by region. There can be as many different sets as wished for, e.g. age by sex could be another question of interest. The Comparative-Macro allows to compare two macro variables in a standard way (Distance measure, correlation, association measures). Any varables that is used as a comparative variable is automatically also used as a macro variable. Parameters are distinguished in constant static parameters and realised micro and macro parameters. Constant static parameters are single scalars, defined in front of the model run and. Together with the model structure (*.lsd* file) and code (*fun_\*.cpp* file) they allow to exactly reproduce the results. Micro and macro parameters are realised as part of the initialisation phase and based on external data as input, a random process based on some static constant parameters or a combination of both. This information is important to analyse the model. Note, this specification of parameters implies a specific design principle: The LSD structure model saved in the *.lsd*-file should consist of single instances only and without meaningful initial values.  

