#####################################################################################--
#          DESCRIPTION  ----
#####################################################################################--

# THIS SCRIPT AIMS TO

#####################################################################################-
#          PATH  ----
#####################################################################################-
SPATH <- dirname(rstudioapi::getSourceEditorContext()$path)
OUT.d <- paste0(SPATH,"/")
#####################################################################################-
#          LOAD LIBRARIES  ----
#####################################################################################-

source(paste0(OUT.d,"/LIBS/lrc_lib.R"))
source(paste0(OUT.d,"/LIBS/mrc_lib.R"))
source(paste0(OUT.d,"/LIBS/data_lib.R")) # load data
TMP.d <- create(paste0(SPATH,"/TMP/"))


#####################################################################################-
#
#          RUN  ----
#
#####################################################################################-


# Figure 5A  -----------------------------------------------------------------------
SUB <- "FIGURES/Figure_5/Figure_5A/"
OUTF.d <- create(OUT.d,SUB)

# This part has been preprocessed with "/PROCESSING_SCRIPTS/preprocess_tad_summits_interactions.R"
# Then, dump_feature_cmd.sh has been used with the config file associated generated by the latest script
# ./dump_feature_cmd.sh -c ../DATA/PROCESSED/Create_APA_TAD_Domain_summits/K27_BORDER_41_1000_ramirezS2WT_1000_wang_tad/config/apa.cfg
# This will require juicer tools to be installed (done with juicer_tools_0.7.5.jar)
# HiC interactions are KR normalized

bin41=41
hicName <- "ramirezS2WT_1000"
cons="wang_tad"
mybin=bin41
hic_res=1000
name=paste0("K27_BORDER_",mybin,"_",hic_res,"_",hicName,"_",cons)
source(paste0(OUT.d,"/DATA/PROCESSED/Create_APA_TAD_Domain_summits/",name,"/config/apa.cfg"))
out_apa.d <- create(paste0(OUTF.d,"/HEATMAP/",xpname,"/"))
out_data.d <- create(paste0(OUTF.d,"/DATA/",xpname,"/"))

# DROP HIC METRICS
m_size <- (bin-1)/2 # Middle pixel value - 1
x_msp <- (bin-1)/2+1;y_msp <- (bin-1)/2+1 # Center bin interaction of size (1bin;1bin)
x_mid <- m_size:(m_size+2);y_mid <- m_size:(m_size+2)
y_ll <- 1:3;x_ll <- (bin-2):bin
y_lr <- (bin-2):bin;x_lr <- (bin-2):bin
y_ul <- 1:3;x_ul <- 1:3
y_ur <- (bin-2):bin;x_ur <- 1:3
x_ctrl1 <- ((m_size):(m_size+2));y_ctrl1 <- 1:3
x_ctrl2 <- ((m_size):(m_size+2));y_ctrl2 <- (bin-2):(bin)

# exctract matrices from all the dumped matrices for a given resolution and a given compartment
df_p <- list()
myMat <- list()
ret <- sapply(dir(dumpdir,full.names = T), # For all dumped matrix 
              function(txt){
                if(grepl(".txt",txt)){
                  f_name <- basename(txt)
                  myMat <- list()
                  feat_apa.mtx <- matrix(0,bin,bin)
                  
                  if(!file.size(txt)) return(NULL)
                  mat <- read.table(txt)
                  domid <- gsub(".*dom=(.*)_K27LV.*","\\1",basename(txt))
                  txt_name <- gsub("(.*).txt","\\1",basename(txt))
                  k27lv <- gsub(".*K27LV=(.*)_TAD.*","\\1",basename(txt))
                  
                  mat$V1 <- (mat$V1/res)-(min(mat$V1/res))+1
                  mat$V2 <- (mat$V2/res)-(min(mat$V2/res))+1
                  mat$V3 <- mat$V3 + 1e-5 # Add a little value to avoid to make NA of trues zeros
                  feat_apa.mtx <- sparseMatrix(i=mat$V1,j=mat$V2,x=mat$V3,dims = c(bin,bin))
                  feat_apa.mtx <- Matrix(feat_apa.mtx,sparse=F)
                  feat_apa.mtx[!is.finite(feat_apa.mtx) | feat_apa.mtx==0] <- NA
                  
                  lowR_mat <- feat_apa.mtx[x_lr,y_lr]
                  upL_mat <- feat_apa.mtx[x_ul,y_ul]
                  lowL_mat <- feat_apa.mtx[x_ll,y_ll]
                  upR_mat <- feat_apa.mtx[x_ur,y_ur]
                  
                  norm <- mean(c(as.array(lowR_mat),as.array(upL_mat)),na.rm=T)
                  lctrl <- mean(as.array(feat_apa.mtx[x_ctrl1,y_ctrl1]),na.rm=T)
                  rctrl <- mean(as.array(feat_apa.mtx[x_ctrl2,y_ctrl2]),na.rm=T)
                  msp <- feat_apa.mtx[x_msp,y_msp]
                  ms <- mean(as.array(feat_apa.mtx[x_mid,y_mid]),na.rm=T)
                  ul <- mean(as.array(upL_mat),na.rm=T)
                  ll <- mean(as.array(lowL_mat),na.rm=T)
                  ur <- mean(as.array(upR_mat),na.rm=T)
                  lr <- mean(as.array(lowR_mat),na.rm=T)
                  
                  df_p <<- rbind(df_p,cbind.data.frame(domID=domid,
                                                       K27LV=k27lv,
                                                       ms=ms,
                                                       msp=msp,
                                                       lr=lr,
                                                       ur=ur,
                                                       ll=ll,
                                                       ul=ul,
                                                       lc=lctrl,
                                                       rc=rctrl,
                                                       norm=norm,
                                                       nme=txt_name))
                  myMat[[txt]] <<- as.matrix(feat_apa.mtx)
                  
                }
              })


saveRDS(df_p,paste0(out_data.d,"df_p.rds"))
saveRDS(myMat,paste0(out_data.d,"myMat.rds"))

# ANALYSE DATA
df_p <- readRDS(paste0(out_data.d,"df_p.rds"))
myMat <- readRDS(paste0(out_data.d,"myMat.rds"))

wang.gr <- readRDS(tadpath)
wang.gr$eucBOUNDED <- 0
sapply(2:(length(wang.gr)-1),function(i){
    if(wang.gr[i]$K27dens !=0 & wang.gr[i-1]$K27dens ==0 & wang.gr[i+1]$K27dens ==0 ){
      wang.gr[i]$eucBOUNDED <<- 1
    }
})



# Add TAD width
df_p$tadWDTH <- width(wang.gr[as.numeric(as.character(df_p$domID))])
df_p$typeWANG <- wang.gr[as.numeric(as.character(df_p$domID))]$type
df_p$eucBOUNDED <- wang.gr[as.numeric(as.character(df_p$domID))]$eucBOUNDED
df_p$idx <- 1:nrow(df_p)

df_p$BEAF_L <- 0 ; df_p$BEAF_R <- 0
df_p$GAF_L <- 0 ; df_p$GAF_R <- 0
df_p$GAFKC_L <- 0 ; df_p$GAFKC_R <- 0
df_p$CP190_L <- 0 ; df_p$CP190_R <- 0
df_p$CTCF_L <- 0 ; df_p$CTCF_R <- 0
df_p$COH_L <- 0 ; df_p$COH_R <- 0


# Associate tss from mrc with TAD border L & R
wangL.gr <- resize(wang.gr,1,"start")
wangR.gr <- resize(wang.gr,1,"end")

fol_L <- unique(queryHits(findOverlaps(wangL.gr,mrc_tss.gr[bg],maxgap=1000)))
fol_R <- unique(queryHits(findOverlaps(wangR.gr,mrc_tss.gr[bg],maxgap=1000)))
df_p[fol_L,"BEAF_L"] <- 1
df_p[fol_R,"BEAF_L"] <- 1
fol_L <- unique(queryHits(findOverlaps(wangL.gr,mrc_tss.gr[gaf],maxgap=1000)))
fol_R <- unique(queryHits(findOverlaps(wangR.gr,mrc_tss.gr[gaf],maxgap=1000)))
df_p[fol_L,"GAF_L"] <- 1
df_p[fol_R,"GAF_R"] <- 1
fol_L <- unique(queryHits(findOverlaps(wangL.gr,mrc_tss.gr[gaf_kc],maxgap=1000)))
fol_R <- unique(queryHits(findOverlaps(wangR.gr,mrc_tss.gr[gaf_kc],maxgap=1000)))
df_p[fol_L,"GAFKC_L"] <- 1
df_p[fol_R,"GAFKC_R"] <- 1
fol_L <- unique(queryHits(findOverlaps(wangL.gr,mrc_tss.gr[cp],maxgap=1000)))
fol_R <- unique(queryHits(findOverlaps(wangR.gr,mrc_tss.gr[cp],maxgap=1000)))
df_p[fol_L,"CP190_L"] <- 1
df_p[fol_R,"CP190_R"] <- 1
fol_L <- unique(queryHits(findOverlaps(wangL.gr,mrc_tss.gr[ctcf],maxgap=1000)))
fol_R <- unique(queryHits(findOverlaps(wangR.gr,mrc_tss.gr[ctcf],maxgap=1000)))
df_p[fol_L,"CTCF_L"] <- 1
df_p[fol_R,"CTCF_R"] <- 1
fol_L <- unique(queryHits(findOverlaps(wangL.gr,mrc_tss.gr[coh],maxgap=1000)))
fol_R <- unique(queryHits(findOverlaps(wangR.gr,mrc_tss.gr[coh],maxgap=1000)))
df_p[fol_L,"COH_L"] <- 1
df_p[fol_R,"COH_R"] <- 1





NME <- "HET"
K27_PERC <- 80
MINWIDTH <- 25000
df_p$K27LV <- as.numeric(as.character(df_p$K27LV))
DF_P_K27DENS <- subset(df_p,K27LV >= K27_PERC & tadWDTH > MINWIDTH)
my_palette <- colorRampPalette(c("white","black"))(n = 256)

DF_SUB <- DF_P_K27DENS %>% filter((BEAF_L==1 & GAFKC_R==1 & CP190_R==1) | (BEAF_R==1 & GAFKC_L==1 & CP190_L==1))

IDX <- DF_SUB$idx
MAT <- myMat[IDX]
apa_mat_p <- list()
Y <- do.call(cbind, MAT)
Y <- array(Y, dim=c(dim(MAT[[1]]), length(MAT)))
tmp <- lapply(MAT, function(X){
  matrix((data.frame(ok=as.vector(X)) %>% mutate(x=ntile(ok,500)))$x,bin,bin)})
Yquant <- do.call(cbind, tmp)
Yquant <- array(Yquant, dim=c(dim(tmp[[1]]), length(tmp)))
apa_mat_p[["QUANTSUM"]] <- apply(Yquant, c(1, 2), sum, na.rm = TRUE)

# DRAW THE HEATMAP
for(type in names(apa_mat_p)){
  ZLIM <- c(0,length(MAT)*400)
  mat_p <- apa_mat_p[[type]]
  od <- create(paste0(out_apa.d,NME,"/",NME,"_MINWIDTH_",MINWIDTH,"_K27DENSITY_",K27_PERC,"/BEAF_vs_GAFKC_CP190_",type,"/2D/"))
  jpeg(paste0(od,"heatmap_tadsummits_OE_bin",get("bin"),".jpeg"))
  heatmap(as.matrix(mat_p),Rowv=NA,Colv=NA,keep.dendro=F,scale="none",revC=T,col=my_palette,zlim=ZLIM)
  dev.off()
  od <- create(paste0(out_apa.d,NME,"/",NME,"_MINWIDTH_",MINWIDTH,"_K27DENSITY_",K27_PERC,"/BEAF_vs_GAFKC_CP190_",type,"/3D/"))
  apa3dPlot(mat_p,od)
}


DF_SUB <- DF_P_K27DENS %>% filter((BEAF_L==1 | BEAF_R==1) & (GAFKC_L==0 & GAFKC_R==0 & CP190_L==0 & CP190_R==0))

IDX <- DF_SUB$idx
MAT <- myMat[IDX]
apa_mat_p <- list()
Y <- do.call(cbind, MAT)
Y <- array(Y, dim=c(dim(MAT[[1]]), length(MAT)))
tmp <- lapply(MAT, function(X){
  matrix((data.frame(ok=as.vector(X)) %>% mutate(x=ntile(ok,500)))$x,bin,bin)})
Yquant <- do.call(cbind, tmp)
Yquant <- array(Yquant, dim=c(dim(tmp[[1]]), length(tmp)))
apa_mat_p[["QUANTSUM"]] <- apply(Yquant, c(1, 2), sum, na.rm = TRUE)

# DRAW THE HEATMAP
for(type in names(apa_mat_p)){
  ZLIM <- c(0,length(MAT)*400)
  mat_p <- apa_mat_p[[type]]
  od <- create(paste0(out_apa.d,NME,"/",NME,"_MINWIDTH_",MINWIDTH,"_K27DENSITY_",K27_PERC,"/BEAF_vs_NO_GAFKC_NOCP190_",type,"/2D/"))
  jpeg(paste0(od,"heatmap_tadsummits_OE_bin",get("bin"),".jpeg"))
  heatmap(as.matrix(mat_p),Rowv=NA,Colv=NA,keep.dendro=F,scale="none",revC=T,col=my_palette,zlim=ZLIM)
  dev.off()
  od <- create(paste0(out_apa.d,NME,"/",NME,"_MINWIDTH_",MINWIDTH,"_K27DENSITY_",K27_PERC,"/BEAF_vs_NO_GAFKC_NOCP190_",type,"/3D/"))
  apa3dPlot(mat_p,od)
}

#   -----------------------------------------------------------------------



# FIGURE 5C ---------------------------------------------------------------
SUB <- "FIGURES/Figure_5/Figure_5C/"
OUTF.d <- create(OUT.d,SUB)

TYPE <- "RPKM"
BS_WT_KD <- 40
FDR_WT_KD <- 0.1
DIFF_SCORE <- "ZS"
NTILE <- 10
SEP_NTILE <- 2
DST_BORDER <- 5000

WDTH_MAX <- 1500
WDTH_MIN <- 40

ctl.bwp <- bw.ll[[TYPE]][["sig"]][1]
trt.bwp <- bw.ll[[TYPE]][["sig"]][2]



microWT_KD.gr <- subset(mDOM.dm3.gr,width < WDTH_MAX & width >= WDTH_MIN)

seqlevelsStyle(microWT_KD.gr) <- "UCSC"
microWT_KD.gr <- bw_signal(trt.bwp = trt.bwp,ctl.bwp = ctl.bwp,anc.gr = microWT_KD.gr)
microWT_KD.gr <- lfc_zs_dif_decile(anc.gr = microWT_KD.gr,NTILE=NTILE,ASYM=T)
seqlevelsStyle(microWT_KD.gr) <- "Ensembl"

# LOAD 10KB RES COMPARTMENTS
K27AC_CENTER.gr <-  bw_signal_simple(ab_compRamirezWT.bwp,resize(k27ac.dm3.gr,1,"center")+100,"AB_EIGEN_RAMI_WT")
HET_CENTER.gr <- bw_signal_simple(ab_compRamirezWT.bwp,resize(Het.gr,1,"center")+100,"AB_EIGEN_RAMI_WT")
EUC_CENTER.gr <- bw_signal_simple(ab_compRamirezWT.bwp,resize(Euc.gr,1,"center")+100,"AB_EIGEN_RAMI_WT")
mDOM_CENTER.gr <- bw_signal_simple(ab_compRamirezWT.bwp,resize(microWT_KD.gr,1,"center")+100,"AB_EIGEN_RAMI_WT")

mDOM_CENTER_UP.gr <- subset(mDOM_CENTER.gr,decZS <= 10)
mDOM_CENTER_DOWN.gr <- subset(mDOM_CENTER.gr,decZS > 10)

plotDF <- NULL
plotDF <- rbind.data.frame(plotDF,
                           cbind.data.frame(VAL=K27AC_CENTER.gr$AB_EIGEN_RAMI_WT,TYPE="K27AC",COL="WT"),
                           cbind.data.frame(VAL=HET_CENTER.gr$AB_EIGEN_RAMI_WT,TYPE="HET",COL="WT"),
                           cbind.data.frame(VAL=mDOM_CENTER_DOWN.gr$AB_EIGEN_RAMI_WT,TYPE="mDOM_DOWN",COL="WT"))

pdf(paste0(OUTF.d,"EigenVector_boxplot_K27ac_K27me3_mDomDOWN_RAMIREZ_WT_KD.pdf"))
ggboxplot(plotDF,x="TYPE",y="VAL",fill="TYPE",palette="simpsons",width = 0.4,size = 1,outlier.shape = NA) + 
  geom_hline(yintercept = 0,linetype="dashed",size=0.5, col="darkgrey") + coord_cartesian(ylim=c(-50,60))
dev.off()

#   -----------------------------------------------------------------------



# FIGURE 5D ---------------------------------------------------------------
SUB <- "FIGURES/Figure_5/Figure_5D/"
OUTF.d <- create(OUT.d,SUB)

# PARAMS
BS_K27 <- 40
FDR_K27 <- 0.1
TYPE <- "RAW"
SQLVSTYLE <- ifelse(TYPE=="RPKM","UCSC","Ensembl")
DECTYPE_CHIP <- "ZS"
DECTYPE_APA_METRICS <- "ZS"
SPREAD <- "BOTH"
NTILE <- 10
baseSet <- "baseSet_TSS"
asymetric <- T
DST_BORDER <- 10000
bInf <- 40
bSup <- 1500
XMIN <- 2000
XMAX <- 2000
microDOMTYPE <- "WT_KD"



# RUN
source(paste0(OUT.d,"DATA/PROCESSED/APA/bgBordk27_noBg_41_1000_ramirezS2WT_1000/apa.cfg"))
WT.dfp <- readRDS(paste0(OUT.d,"DATA/PROCESSED/APA/bgBordk27_noBg_41_1000_ramirezS2WT_1000/df_p.rds"))
source(paste0(OUT.d,"DATA/PROCESSED/APA/bgBordk27_noBg_41_1000_ramirezS2bKD_1000/apa.cfg"))
KD.dfp <- readRDS(paste0(OUT.d,"DATA/PROCESSED/APA/bgBordk27_noBg_41_1000_ramirezS2bKD_1000/df_p.rds"))


WT.dfp$ancID <- unlist(lapply(strsplit(as.character(WT.dfp$ancID),"_"),"[",1))
KD.dfp$ancID <- unlist(lapply(strsplit(as.character(KD.dfp$ancID),"_"),"[",1))

WT.dfp$ancID_net <- gsub("(.*)(_toRev_1)|(_1)","\\1",WT.dfp$ancID)
KD.dfp$ancID_net <- gsub("(.*)(_toRev_1)|(_1)","\\1",KD.dfp$ancID)
apa_gid_WT <- unique(WT.dfp$ancID)
apa_gid_KD <- unique(KD.dfp$ancID)

# ASSOCIATE GENES FROM MATRECAP WITH THE CURRENT DATA FRAME
WT.dfp$ancIDmrcTss <- match(WT.dfp$ancID,mrc_tss.gr$gene_id)
KD.dfp$ancIDmrcTss <- match(KD.dfp$ancID,mrc_tss.gr$gene_id)
WT.dfp$intIDmrcTss <- match(WT.dfp$intID,mrc_tss.gr$gene_id)
KD.dfp$intIDmrcTss <- match(KD.dfp$intID,mrc_tss.gr$gene_id)


WT.dfp$msNorm <- WT.dfp$ms / WT.dfp$norm
WT.dfp$mspNorm <- WT.dfp$msp / WT.dfp$norm
WT.dfp$llNorm <- WT.dfp$ll / WT.dfp$norm
WT.dfp$urNorm <- WT.dfp$ur / WT.dfp$norm

KD.dfp$msNorm <- KD.dfp$ms / KD.dfp$norm
KD.dfp$mspNorm <- KD.dfp$msp / KD.dfp$norm
KD.dfp$llNorm <- KD.dfp$ll / KD.dfp$norm
KD.dfp$urNorm <- KD.dfp$ur / KD.dfp$norm

# TEST WT & KD DIST
KD_save.dfp <- KD.dfp
KD_save.dfp$type <- "KD"
WT_save.dfp <- WT.dfp
WT_save.dfp$type <- "WT"
WT_KD.df <- rbind(WT_save.dfp,KD_save.dfp)


idCOLN <- c("intID","ancID", "nme","ancID_net","ancIDmrcTss","intIDmrcTss")
valCOLN <- colnames(WT.dfp)[colnames(WT.dfp) %ni% idCOLN]


# CREATE DIFFERENTIAL DATA FRAME
# check if wt and kd df are sorted the same way
all.equal(KD.dfp$intID,WT.dfp$intID)
# T
idCOLN <- c("intID","ancID", "nme","ancID_net","ancIDmrcTss","intIDmrcTss")
valCOLN <- colnames(WT.dfp)[colnames(WT.dfp) %ni% idCOLN]

DIVZS.dfp <- WT.dfp[,c("intID","ancID", "nme","ancID_net","ancIDmrcTss","intIDmrcTss")]
for(valC in valCOLN){
  trtSIGNAL <- KD.dfp[,valC]+1e-5
  ctlSIGNAL <- WT.dfp[,valC]+1e-5
  DIVZS.dfp[,valC] <- -(trtSIGNAL - ctlSIGNAL)/sqrt(rowMeans(cbind(trtSIGNAL,ctlSIGNAL)))
}
# Split MS, MSP, LL and UR in Quartile
# Quartile are continuous
# Same for ZS
DIVZS_save.dfp <- DIVZS.dfp 
DIVZS_save.dfp <- DIVZS_save.dfp %>% 
  mutate(quartMSPnorm=ntile(mspNorm,4)) %>%
  mutate(quartMSnorm=ntile(msNorm,4)) %>%
  mutate(quartLLnorm=ntile(llNorm,4)) %>%
  mutate(quartURnorm=ntile(urNorm,4)) %>%
  mutate(quartPSnorm=ntile(phaseScore,4)) %>%
  mutate(quartMSP=ntile(msp,4)) %>%
  mutate(quartMS=ntile(ms,4)) %>%
  mutate(quartLL=ntile(ll,4)) %>%
  mutate(quartUR=ntile(ur,4)) 




# HIC DAT FRAME
HIC.df <- DIVZS_save.dfp



mrc_tss_tmp.gr <- mrc_tss.gr


# K27 CHIPSEQ
# BWP
YLIM <- bw.ll[[TYPE]][["ylim"]]
ctl.bwp <- bw.ll[[TYPE]][["sig"]][1]
trt.bwp <- bw.ll[[TYPE]][["sig"]][2]

# BWL
BW.l <- c(trt.bwp,ctl.bwp)

# MICRO DOMAINS
microKD_WT.gr <- subset(mDOM.dm3.gr,dtk27 > DST_BORDER & width < bSup & width >= bInf)
seqlevelsStyle(microKD_WT.gr) <- SQLVSTYLE


# COMPUTE SIGNAL FOR K27 CHIP
microKD_WT.gr <- bw_signal(trt.bwp = trt.bwp,ctl.bwp = ctl.bwp,anc.gr = microKD_WT.gr)
microKD_WT.gr <- lfc_zs_dif_decile(anc.gr = microKD_WT.gr,NTILE=NTILE,ASYM=T)
seqlevelsStyle(microKD_WT.gr) <- "Ensembl"
microKD_WT_DOWNKD.gr <- GRanges(as.data.frame(microKD_WT.gr) %>% filter(UQ(as.name(paste0("dec",DECTYPE_CHIP))) > NTILE +5))
microKD_WT_UPKD.gr <- GRanges(as.data.frame(microKD_WT.gr) %>% filter(UQ(as.name(paste0("dec",DECTYPE_CHIP))) <= NTILE-5))
microKD_WT_noUPDOWN.gr <- GRanges(as.data.frame(microKD_WT.gr) %>% filter(UQ(as.name(paste0("dec",DECTYPE_CHIP))) %in% ((NTILE-5) : (NTILE +5))))

microKD_WT_ALL.gr <- microKD_WT.gr
seqlevelsStyle(microKD_WT_DOWNKD.gr) <- "Ensembl"


# COMPUTE TSS DIST TO K27
mrc_tss_tmp.gr$dtk27 <- 0
dtn <- distanceToNearest(mrc_tss_tmp.gr,Het.gr)
mrc_tss_tmp.gr[dtn@from]$dtk27 <- mcols(dtn)$distance
mrc_tss_tmp.gr$ID <- 1:length(mrc_tss_tmp.gr)

# OUTPUT
idCOLN <- c("intID","ancID", "nme","ancID_net","ancIDmrcTss","intIDmrcTss")
valCOLN <- colnames(WT.dfp)[colnames(WT.dfp) %ni% idCOLN]



bw.l <- ctl.bwp
met <- "mspNorm"
for(mxgap in c(2000)){
  mydf <- NULL
  for(microDOMS in c("microKD_WT_ALL.gr")){
    nm <- gsub("microKD_WT_(.*).gr","\\1",microDOMS)
    microDOM <- get(microDOMS)
    myFOL <- findOverlaps(microDOM,mrc_tss.gr,maxgap=mxgap)
    tss_no_microdom.gr <- sample(subset(mrc_tss_tmp.gr, ID %ni% subjectHits(myFOL) & !bg & !cp & !gaf_kc & !bs & dtk27 > 5000),2*length(myFOL),replace=T)
    tss_no_microdom_nomcols.gr <- tss_no_microdom.gr
    mcols(tss_no_microdom_nomcols.gr) <- NULL
    
    # norm_gid <- mrc_tss.gr[unique(subjectHits(myFOL))]$gene_id
    df_pTMP <- HIC.df %>% filter(ancID_net %in% unique(c(unique(mrc_tss.gr[subjectHits(myFOL)]$gene_id),tss_no_microdom.gr$gene_id))) #Base set is only TSS microDOMAINS
    df_pTMP <- df_pTMP[order(df_pTMP[,met],decreasing = T),]
    
    
    tss_no_microdom.gr <- subset(tss_no_microdom.gr,gene_id %in% df_pTMP$ancID)
    
    GSEA <- df_pTMP[,met]
    names(GSEA) <- df_pTMP[,"ancIDmrcTss"]
    
    GSEA[is.nan(GSEA) | is.na(GSEA)] <- 0
    
    GSEA.lst <- NULL
    GSEA.lst[[nm]] <- unique(subjectHits(myFOL))
    
    fgseaRes <- fgsea(pathways = GSEA.lst, 
                      stats = GSEA,
                      minSize=5,
                      maxSize=max(unlist(lapply(GSEA.lst,length))),
                      nperm=1000)
    
    
    sink(paste0(OUTF.d,toupper(met),"_GSEA_RANKED_BY_WT_KD_",DECTYPE_APA_METRICS,"_SCORE_TSSMAXGAP=",mxgap,"_MICRODOMAIN_SUBTYPE_",nm,".txt"))
    print(fgseaRes)
    sink()
    
    pdf(paste0(OUTF.d,toupper(met),"_GSEA_RANKED_BY_WT_KD_",DECTYPE_APA_METRICS,"_SCORE_TSSMAXGAP=",mxgap,"_MICRODOMAIN_SUBTYPE_",nm,".pdf"),height=1000,width=1000)
    print(plotEnrichment(GSEA.lst[[nm]],GSEA) + labs(title=paste0("GSEA on ",nm)))
    dev.off()
  }
}



#   -----------------------------------------------------------------------


