readCsvData <- function(filename=""){
  if (filename=="") stop("No file given");
  if (!file.exists(filename)) stop("File not found");
  
  data <- read.table(file=filename
                     , header=TRUE
                     , sep=";"
                     , dec="."
                     , na.strings="NA"
                     , as.is=TRUE)
  data[,1] <- as.POSIXct(strptime(data[,1], "%Y-%m-%d %H:%M:%S"));
  
  return(data);
}

# readCSVData("../../data/challengeData.CSV")
