"""
This script parses execution logs from Charm++ and transforms them into
a single CSV file.
The results for a same configuration can be split into different
subdirectories.
A configuration is identified by the name of the file
It assumes the same number of repetitions was executed for all kinds of
results.
"""
import re
from os import walk
from collections import OrderedDict

mypath = '.'
mypattern = '\W*Total application time [\d.]* s'
myresults = OrderedDict()

print('Checking for information in files.')

# iterates over the directory and sub-directories
for (dirpath, dirnames, filenames) in walk(mypath):
    # ignores root path
    if dirpath is '.':
        continue
    # iterates over all files in a sub-directory
    for filename in filenames:
        # Opens the file and searches for the pattern
        with open(dirpath + '/' + filename, 'r') as myfile:
            log = myfile.read()
            times = re.findall(mypattern, log)
            # If it has found something, we add to the results
            if len(times) is not 0:
                # Check if we have this file name in the results already
                if filename not in myresults:
                    myresults[filename] = list()
                # Iterates over all the matches and addes the times to the list
                for line in times:
                    time = line.split()[3]
                    myresults[filename].append(time)

print('Writing parsed information to results.csv.')

# writes CSV file with all results
with open('results.csv', 'w') as csvfile:
    # writes all filenames (configurations) in order
    header = ''
    for name in myresults.keys():
        header += name + ','
    csvfile.write(header[:-1] + '\n')
    # finds how many iterations over the results will be necessary
    iterations = 0
    for time_list in myresults.values():
        iterations = max(iterations, len(time_list))
    # Runs all iterations (prepares a line, writes a line)
    for i in range(iterations):
        line = ''
        # adds all values to the line
        for time_list in myresults.values():
            if i < len(time_list):
                line += time_list[i] + ','
            else:
                line += ','
        # writes line
        csvfile.write(line[:-1] + '\n')

print('Writing done.')
