"""
This script parses execution logs from Charm++ and transforms them into
a single CSV file.
The results for a same configuration can be split into different
subdirectories.
A configuration is identified by the name of the file
It assumes the same number of repetitions was executed for all kinds of
results.
"""
import re
from os import walk
from collections import OrderedDict

mypath = '.'
mypattern = 'step \d finished at [\d.]* duration [\d.]*'
myresults = OrderedDict()

print('Checking for information in files.')

# iterates over the directory and sub-directories
for (dirpath, dirnames, filenames) in walk(mypath):
    # ignores root path
    if dirpath is '.':
        continue
    # iterates over all files in a sub-directory
    for filename in filenames:
        # Opens the file and searches for the pattern
        with open(dirpath + '/' + filename, 'r') as myfile:
            log = myfile.read()
            times = re.findall(mypattern, log)
            # If it has found something, we add to the results
            if len(times) is not 0:
                # Check if we have this file name in the results already
                if filename not in myresults:
                    myresults[filename] = list()
                # Iterates over all the matches and addes the times to the list
                for line in times:
                    time = line.split()[6]
                    myresults[filename].append(time)

print('Writing parsed information to lb_times.csv.')

# writes CSV file with all results
with open('lb_times.csv', 'w') as csvfile:
    # writes all filenames (configurations) in order
    header = ''
    for name in myresults.keys():
        header += name + ','
    csvfile.write(header[:-1] + '\n')
    # finds how many iterations over the results will be necessary
    iterations = 0
    for time_list in myresults.values():
        iterations = max(iterations, len(time_list))
    # Runs all iterations (prepares a line, writes a line)
    for i in range(iterations):
        line = ''
        # adds all values to the line
        for time_list in myresults.values():
            if i < len(time_list):
                line += time_list[i] + ','
            else:
                line += ','
        # writes line
        csvfile.write(line[:-1] + '\n')

print('Splitting lb_times.csv into three CSV files.')

# splits the CSV file in three for a special analysis
with open('lb_times.csv', 'r') as csvfile:
    # creates three csv files
    new_files = []
    new_files.append(open('lb_times_step_0.csv', 'w'))
    new_files.append(open('lb_times_step_1.csv', 'w'))
    new_files.append(open('lb_times_step_2.csv', 'w'))

    line = csvfile.readline()
    new_files[0].write(line)
    new_files[1].write(line)
    new_files[2].write(line)

    i = 0
    for line in csvfile:
        new_files[i].write(line)
        i = (i + 1) % 3

    new_files[0].close()
    new_files[1].close()
    new_files[2].close()

print('Writing done.')
