#!/bin/bash
## MSUB information for launching the job in the supercomputer
#MSUB -r leanmd_large
#MSUB -n 960
#MSUB -T 15000
#MSUB -q skylake
#MSUB -A gen10724
#MSUB -m work

## Benchmark parameters for multiple runs
#N_TESTS: size of the samples
#Z_DIM: size of the Z dimension for the grid
#TOTAL_ITER: total iterations of the benchmark
#LB_FREQ: period between load balancing calls
#FIRST_LB: first LB call
#X and Y: other dimensions of the grid
#LB_LIST: load balancers to run
N_TESTS=10
declare -a Z_DIM=(240 320)
TOTAL_ITER=301
LB_FREQ=100
FIRST_LB=40
X=5
Y=11
declare -a LB_LIST=('PackStealLB' 'PackDropLB' 'DummyLB')

# Benchmark path
BENCH_PATH=${BRIDGE_MSUB_PWD}/leanmd
# Results path
RES_PATH=${BRIDGE_MSUB_PWD}/oct24_2
# Base list of varying parameters
TEST_SET=${RES_PATH}/test_set

## Generates the set of experiments to run in one test
## (all sizes of Z dimension X all load balancers)
for z in "${Z_DIM[@]}"
do
    for lb in "${LB_LIST[@]}"
    do
        echo $lb $z >> $TEST_SET
    done
done

## Generates the different execution orders
for i in $(seq 1 $N_TESTS);
do
    cat $TEST_SET | shuf > $TEST_SET.$i
done

date
## Runs the experiments respecting the different orders
for i in $(seq 1 $N_TESTS);
do
    echo "--- Running repetition $i ---"
    # Reads one execution order file
    readarray a < $TEST_SET.$i
    # Iterates over its lines
    for line in "${a[@]}";
    do
        # Splits the line into an array of strings with the information we want
        info=(`echo $line`)
        lb=${info[0]}                   # load balancer
        z=${info[1]}                    # size of Z dimension
        output=${RES_PATH}/$lb.$z       # output file 

        # Runs the benchmark with the pre-defined parameters
        ${BENCH_PATH}/charmrun +p960 ${BENCH_PATH}/leanmd $z $Y $X ${TOTAL_ITER} ${FIRST_LB} ${LB_FREQ} +balancer $lb +LBSyncResume +LBDebug 1 +pemap 0-47 >> $output
    done
done
date

