(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     30295,        785]*)
(*NotebookOutlinePosition[     56628,       1735]*)
(*  CellTagsIndexPosition[     56584,       1731]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
CHR Paris, 4-10 May 1995 (version 6.1)
CHR Paris, 23 Sept 94  (version 6.0 started 1 September 1994)
copyright Charles H. Robert

A general way to approach the problem of the chain hydrodynamics using my \
little approximate approach. Please note: I don't want to hear any of those \
catty, thinly-veiled references to the varieties of pasta-code found in \
programs, etc.

Version 6.1 incorporates a correction function to apply to the <r^2> values. \
As I mention in my paper describing this work, for a stiff chain the \
difference between <1/r> and 1/Sqrt(<r^2>) is not large until the chain is \
long. When the chain is very long the difference between the two averages is \
maximal, and one over the average inverse can be calculated to be about 28% \
of the root mean square. I did a series of Monte carlo studies of \
Porod-Kratky chains used in these studies to evaluate how this correction \
behaves as a function of the length of the chain. A sigmoidal representation \
of this correction is now included in the program in the\"correctr\" and \
\"doKirkwood\" routines.

Version 6.1also incorporates a less inefficient way of calculating rij \
between any two frictional centers of the chain.  Instead of calculating all \
possible transformation matrices between any two elements, I have now simply \
programmed what I was too lazy to code initially: from a single list of \
successive products of rotation matrices progressing along the chain, R1, \
R1R2, R1R2R3, etc, which are correspondingly called A(1), A(2), A(3), ..., \
and along with a list of the inverses Ainv(1), Ainv(2), etc., one can get \
from any i to any j in the chain by calculating Aij=Ainv(i).A(j). The inverse \
cancels off all the unneeded preceding rotations in the product.

Finally, 6.1 loses some of the useless code that was spawned from early \
trials of 6.0.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Chain generators and conformational routines"], "Subsection",
  Evaluatable->False,
  PageBreakWithin->Automatic,
  AspectRatioFixed->True],

Cell[TextData[
"Needed:\n- vectors for two types of chain segments in the reference \
coordinate system: free-chain segments (vbp0, for basepairs) and chain \
displacement (virtual) segments (vnu0, for 'nucleosome'),\n- vector for the \
center of the chain-displacement segment in the reference coordinate system \
(vc0)\n- transformation matrix for any free-chain segment junction (P)\n- \
transformation matrix for any net change in chain direction across the \
displacement region (R)\n\nHigher level things:\n- Set of general \
mathematical tools\n\nLower level things:\n- Set of definitions for \
free-chain regions (variables and functions to define free segment objects \
vbp0 and P)\n- Set of definitions for chain displacement regions (variables \
and functions to define free segment objects vnu0, R)"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["General definitions"], "Subsubsection",
  Evaluatable->False,
  PageBreakWithin->Automatic,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Off[General::"\<spell\>"]; \)\), 
    \(\(Off[General::"\<spell1\>"]; \)\)}], "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Ax[w_] := {{1, 0, 0}, {0, Cos[w], Sin[w]}, {0, \(-Sin[w]\), Cos[w]}}; 
    \)\), 
    \(\(Ay[w_] := {{Cos[w], 0, \(-Sin[w]\)}, {0, 1, 0}, {Sin[w], 0, Cos[w]}}; 
    \)\), 
    \(\(Az[w_] := {{Cos[w], Sin[w], 0}, {\(-Sin[w]\), Cos[w], 0}, {0, 0, 1}}; 
    \)\)}], "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(AO := 
      Az[Random[Real, N[{0, 2\ \[Pi]}]]] . 
        Ax[Random[Real, N[{0, 2\ \[Pi]}]]] . 
        Az[Random[Real, N[{0, 2\ \[Pi]}]]]; \)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(norm2[v_] := v . v;\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(length[v_] := \@\(v . v\); \)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(rotate[A_, o_] := 
      Module[{i, j, depth}, depth = Depth[N[o]]; 
        Which[depth == 1, Print["\<Not done: \>", depth]; Return[o], 
          depth == 2, Return[N[A] . o], depth == 3, 
          Return[Transpose[N[A] . Transpose[o]]], depth == 4, 
          Return[\((Transpose[N[A] . Transpose[#1]]&)\)/@o], 
          depth \[GreaterEqual] 5, Print["\<Not done: \>", depth]; 
          Return[o]]]; \)\)], "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(translate[vt_, o_] := 
      Module[{i, j}, depth = Depth[N[o]]; 
        Which[depth == 1, Print["\<Not done: \>", depth]; Return[o], 
          depth == 2, Return[vt + o], depth == 3, Return[\((vt + #1&)\)/@o], 
          depth == 4, 
          Return[Table[
              \((vt + #1&)\)/@o\[LeftDoubleBracket]i\[RightDoubleBracket], {
                i, Length[o]}]], depth \[GreaterEqual] 5, 
          Print["\<Not done: \>", depth]; Return[o]]]; \)\)], "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Free-chain segment (basepair) definitions:"], "Subsubsection",
  Evaluatable->False,
  PageBreakWithin->Automatic,
  AspectRatioFixed->True],

Cell[TextData[
"Defines segment transformation matrix P for appropriate model. Here use a \
chain bending by an angle beta in the direction phi, with a fixed z-axis \
twist increment alpha. Pav is the same matrix averaged over the bending angle \
phi, for calculating average properties of a Porod-Kratky-like isotropically \
bending chain with a fixed twist increment. Otherwise for Monte-Carlo \
purposes P can be called with phi0, which randomly assigns a bending \
direction from the interval {0, 2 Pi}."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["Constants"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(el0 = 3.4; \)\), 
    \(\(persistence = 150\ el0; \)\), 
    \(\(repeat0 = 10.4; \)\)}], "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData["Functions"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(alpha0 := N[\(2\ \[Pi]\)\/repeat0]; \)\), 
    \(\(phi0 := Random[Real, N[{0, 2\ \[Pi]}]]; \)\), 
    \(\(beta0 := N[ArcCos[1 - el0\/persistence]]; \)\), 
    \(\(PPK[phi_, beta_] := Az[\(-phi\)] . Ax[beta] . Az[phi]; \)\), 
    \(\(Pbp[alpha_, phi_, beta_] := 
      Az[\(-phi\)] . Ax[beta] . Az[phi] . Az[alpha]; \)\), 
    \(\(Pavg[alpha_, 
        beta_] := {{Cos[alpha]\ Cos[beta\/2]\^2, Cos[beta\/2]\^2\ Sin[alpha], 
          0}, {\(-\((Cos[beta\/2]\^2\ Sin[alpha])\)\), 
          Cos[alpha]\ Cos[beta\/2]\^2, 0}, {0, 0, Cos[beta]}}; \)\), 
    \(\(definebasepair := 
      Module[{i, j}, Id = IdentityMatrix[3]; vbp0 = N[el0\ {0, 0, 1}]; 
        cbp0 = N[1\/2\ el0\ {0, 0, 1}]; 
        P[phi_] := N[Pbp[\(-alpha0\), \(-phi\), \(-beta0\)]]; 
        Pr := N[Pbp[\(-alpha0\), \(-phi0\), \(-beta0\)]]; 
        Prfast := N[PPK[\(-phi0\), \(-beta0\)]]; 
        Pav = N[Pavg[\(-alpha0\), \(-beta0\)]]; ]; \)\)}], "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Diplacement segment (nucleosome) definitions"], "Subsubsection",
  Evaluatable->False,
  PageBreakWithin->Automatic,
  AspectRatioFixed->True],

Cell[TextData[
"The transformation matrix across the nucleosome regions will include a \
basepair transformation, since at the far end of the nucleosome a bp-bp step \
occurs. This is arguably not necessary, since the transition from a \
nucleosomal bp to a free bp is not necessarily the same as that between two \
free bp, but hell, to first order they are the same."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["Constants"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(repeat1 = 10.15; \)\), 
    \(\(radius = 44.916; \)\), 
    \(\(turns = 1.75; \)\), 
    \(\(pitch = \(-28.571\); \)\)}], "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[TextData["Functions"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(helix[angle_, radius_, pitch_] := 
      N[\@\(1 + \((pitch\/\(2\ \[Pi]\ radius\))\)\^2\)\ Abs[angle]\ radius]; 
    \)\), 
    \(\(wrapbp := Floor[N[helix[2\ \[Pi]\ turns, radius, pitch]\/3.4]]; 
    \)\), 
    \(\(dyad := wrapbp\/2; \)\), 
    \(\(alpha1 := N[\(2\ \[Pi]\ wrapbp\)\/repeat1]; \)\), 
    \(\(beta1 := N[2\ \[Pi]\ turns]; \)\), 
    \(\(depth1 := N[turns\ pitch]; \)\), 
    \(\(angle := N[ArcSin[pitch\/\(2\ \[Pi]\ radius\)]]; \)\), 
    \(\(Tya := N[Ay[\(-angle\)]]; \)\), 
    \(\(Tyb := N[Ay[angle]]; \)\), 
    \(\(wrap[n_, option_] := 
      Block[{i, j, dbeta1, dalpha1, dl, r, vz, vz0}, r = {0, 0, 0}; 
        spiral = {r}; dbeta1 = N[beta1\/n]; dalpha1 = N[alpha1\/n]; 
        dl = \@N[
              \((2\ radius\ Cos[\(\[Pi] - dbeta1\)\/2])\)\^2 + 
                \((depth1\/n)\)\^2]; 
        Print["\<n = \>", n, "\< ; dl = \>", dl]; vz0 = {0, 0, dl}; 
        If[option == 1, vz0 = {0, 1, dl}]; 
        If[option == \(-1\), vz0 = {0, \(-1\), dl}]; 
        Do[vz = rotate[N[Ax[\(-i\)\ dbeta1] . Tya . Az[\(-i\)\ dalpha1]], 
              vz0]; r = r + vz; spiral = Append[spiral, r], {i, 1, n}]; 
        Return[rotate[N[Tyb . Ax[dbeta1\/2]], spiral]]]; \)\), 
    \(\(Rn[alpha_, beta_] := Tyb . Ax[beta] . Tya . Az[alpha]; \)\), 
    \(\(definenuke := 
      Module[{i, j}, onuke = N[wrap[20, 0]]; vnu0 = Last[onuke]; 
        cnu0 = Tyb . {depth1\/2, \(-radius\), 0}; 
        R = Rn[\(-alpha1\), \(-beta1\)]; RPr := N[R . Pr]; 
        RPav = N[R . Pav]; ]; \)\)}], "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData["Some nucleosome extras for testing, etc."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(gamma[n_] := N[1\/2\ \((\[Pi] - beta1\/n)\)]; \)\), 
    \(\(giveel[r_, n_] := 
      \@\(\((2\ r\ Cos[gamma[n]])\)\^2 + \((depth1\/n)\)\^2\); \)\), 
    \(\(giver[el_, n_] := 
      \@\(el\^2 - \((depth1\/n)\)\^2\)\/\(2\ Cos[gamma[n]]\); \)\)}], "Input",\

  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[
"Individual-chain definitions: vectors, transformation matrices, chain \
generators, |r(i,j)| length functions, drawing routines"], "Subsubsection",
  Evaluatable->False,
  PageBreakWithin->Automatic,
  AspectRatioFixed->True],

Cell[TextData[
"In these routines i, j, and k are indices of the chain segments. They \
indicate actual segment positions. The list 'np' contains the chain length \
and a list of of segments (positions) at which a chain displacement occurs \
(nucleosomal segments)."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(v0[k_, positions_] := 
      If[MemberQ[positions, k], Return[vnu0], Return[vbp0]]; \)\), 
    \(\(c0[k_, positions_] := 
      If[MemberQ[positions, k], Return[cnu0], Return[cbp0]]; \)\), 
    \(\(T[k_, kiQ_, positions_] := 
      If[kiQ, Return[Id], 
        If[MemberQ[positions, k - 1], Return[RPr], Return[Pr]]]; \)\)}], 
  "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(rij[i_, j_] := 
      r\[LeftDoubleBracket]j - 1\[RightDoubleBracket] + 
        clist\[LeftDoubleBracket]j\[RightDoubleBracket] - 
        \((r\[LeftDoubleBracket]i - 1\[RightDoubleBracket] + 
            clist\[LeftDoubleBracket]i\[RightDoubleBracket])\); \)\), 
    \(\(lrij[i_, j_] := length[rij[i, j]]; \)\)}], "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(fastPKr2[n_] := 
        Module[{M, r}, M = IdentityMatrix[3]; r = {0, 0, 0}; 
          Do[M = M . Prfast; r = r + M . vbp0, {k, n}]; 
          Return[norm2[r]]];\)\)], "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[
"Averaged-chain definitions: matrices and end-to-end length functions."], 
  "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Ta[k_, kiQ_, positions_] := 
      If[kiQ, Return[Id], 
        If[MemberQ[positions, k - 1], Return[RPav], Return[Pav]]]; \)\)], 
  "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(makeAs[np_] := 
      Module[{x}, n = np\[LeftDoubleBracket]1\[RightDoubleBracket]; 
        positions = np\[LeftDoubleBracket]2\[RightDoubleBracket]; 
        A = Table[0, {n}]; 
        A\[LeftDoubleBracket]1\[RightDoubleBracket] = IdentityMatrix[3]; 
        Ai = Table[0, {n}]; 
        Ai\[LeftDoubleBracket]1\[RightDoubleBracket] = IdentityMatrix[3]; 
        SAa = Table[0, {n}]; 
        SAa\[LeftDoubleBracket]1\[RightDoubleBracket] = Pav; 
        Do[A\[LeftDoubleBracket]j\[RightDoubleBracket] = 
            A\[LeftDoubleBracket]j - 1\[RightDoubleBracket] . 
              Ta[j, False, positions]; 
          Ai\[LeftDoubleBracket]j\[RightDoubleBracket] = 
            Inverse[A\[LeftDoubleBracket]j\[RightDoubleBracket]]; 
          SAa\[LeftDoubleBracket]j\[RightDoubleBracket] = 
            SAa\[LeftDoubleBracket]j - 1\[RightDoubleBracket] + 
              MatrixPower[Pav, j], {j, 2, n}]]; \)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(rcij[i_, j_, np_] := 
      Module[{v, vh, vi, s, positions}, 
        positions = np\[LeftDoubleBracket]2\[RightDoubleBracket]; 
        vk = \(-c0[i, positions]\) + v0[i, positions]; s = vk . vk; 
        s = s + \[Sum]\+\(k = i + 1\)\%\(j - 1\)\((vk = v0[k, positions]; 
                vk . vk)\); vk = c0[j, positions]; s = s + vk . vk; 
        Do[If[h == i, vh = \(-c0[h, positions]\) + v0[h, positions], 
            vh = v0[h, positions]]; 
          nointerrupt = 
            \((Range[h, j - 1])\) \[Intersection] positions == {}; 
          If[nointerrupt, 
            If[h == j - 1, s2 = vh . Pav . c0[j, positions], 
              s2 = vh . 
                    SAa\[LeftDoubleBracket]j - 1 - h\[RightDoubleBracket] . 
                    vbp0 + vh . MatrixPower[Pav, j - h] . c0[j, positions]], 
            s2 = \[Sum]\+\(k = h + 1\)\%j\((
                  If[k == j, vk = c0[k, positions], vk = v0[k, positions]]; 
                  vh . Ai\[LeftDoubleBracket]h\[RightDoubleBracket] . 
                    A\[LeftDoubleBracket]k\[RightDoubleBracket] . vk)\)]; 
          s = s + 2\ s2, {h, i, j - 1}]; Return[\@s]; ]; \)\)], "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Friction calculations (22 Sept 94)"], "Subsection",
  Evaluatable->False,
  PageBreakWithin->Automatic,
  AspectRatioFixed->True],

Cell[TextData[
"We'll use a notation in which the letter 'a' denotes properties for segments \
that can be treated individually, such as a nucleosome, and 'b' denotes the \
properties of a collection of segments, like a chain of basepairs. An \
individual basepair has 'a' properties as well, since if necessary a chain of \
basepairs can be treated at the level of the individual basepairs. This is \
time-consuming, however, and is not necessarily better. Any legitimate \
element is represented by a single spherical frictional element with a \
certain mass, Stokes radius, and a 'segment address' in the superchain, which \
is used to calculate the distances between pairs of elements. These distances \
will be calculated using the chain conformational properties defined in the \
preceding sections."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"As far as units are concerned, I will try to use the cgs units for \
convenience, since all of the frictional properties seem to be defined this \
way. But I will retain the simpler units of Angstroms for Stokes radii and bp \
for chain lengths, in order to make defining the properties of the DNA chain \
and the nucleosome easier and more intuitive. These are convertedwhere \
necessary inside the various friction routines."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["General Definitions"], "Subsubsection",
  Evaluatable->False,
  PageBreakWithin->Automatic,
  AspectRatioFixed->False],

Cell[TextData[
"Physical parameters are typical values relative to water taken from van \
Holde's Physical Biochemistry book (2nd ed., p.134 and p.166). In as much as \
water's values would be ro = 1 g/cm^3 and nu = 1 centipoise, they will be \
reasonable ballpark estimates for a buffer solution near 20 C (293 K). These \
values should be changed to reflect the true experimental conditions."], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(NAvo = 6.02\ 10\^23; \)\), 
    \(\(ro = 1.003; \)\), 
    \(\(visc = 0.01016; \)\)}], "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(gettrans[x_, tk_] := 
      Module[{i}, 
        kT = \(8.31433\ tk\ kg\ 
              m\^2\)\/\(\(\((mol\ s\^2)\)\ \((6.023\ 10\^23)\)\)\/mol\); 
        Return[\(kT\ 1000\ g\ \((\(100\ cm\)\/m)\)\^2\)\/\(kg\ x\)]]; \)\)], 
  "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[
"Chain elements: particle definitions (basepairs) mbpa,rbpa\nand collective \
definitions (uniform chains) mbpb[n], rbpb[n]"], "Subsubsection",
  Evaluatable->False,
  PageBreakWithin->Automatic,
  AspectRatioFixed->True],

Cell[TextData["Constants"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(mbpa = 660; \)\), 
    \(\(rbpa = 1.8294; \)\), 
    \(\(vDNA = 0.55; \)\), 
    \(\(dDNA = 27; \)\), 
    \(\(switchbp = 50; \)\)}], "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData["Functions"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(mbpb[n_] := n\ mbpa; \)\), 
    \(\(rellipsoid[n_, offset_] := 
      Module[{p, pdiff, foverf0, requiv, rb}, p = \(n\ el0\)\/dDNA; 
        If[p > 1, pdiff = \@\(1 - \((1\/p)\)\^2\); 
          foverf0 = pdiff\/\(\((1\/p)\)\^\(2/3\)\ Log[p\ \((1 + pdiff)\)]\), 
          p = 1\/p; pdiff = \@\(p\^2 - 1\); 
          foverf0 = pdiff\/\(p\^\(2/3\)\ ArcTan[pdiff]\)]; 
        requiv = \((n\ el0\ dDNA\^2)\)\^\(1/3\)\/\(2\ 10\^8\); 
        fb = foverf0\ \((6\ \[Pi]\ visc\ requiv)\); 
        rb = N[\(fb\ 10\^8\)\/\(6\ \[Pi]\ visc\) + offset]; Return[rb]]; 
    \)\), 
    \(\(rYF[n_] := 
      Module[{masstrue, massapp, sb, fb, rb}, masstrue = mbpb[n]; 
        massapp = \(masstrue\ 575\)\/persistence; 
        sb = \(1\/10\^13\((
            N[3.620\ \((
                  Log[10, masstrue] - 3.552 + \(3.23\ massapp\)\/10\^7 + 
                    \(1.63\ massapp\^2\)\/10\^13 - 
                    \(7.85\ massapp\^3\)\/10\^20)\)])\)\); 
        fb = \(masstrue\ \((1 - ro\ vDNA)\)\)\/\(NAvo\ sb\); 
        rb = N[fb\/\(6\ \[Pi]\ visc\)]; Return[rb\ 10\^8]; ]; \)\), 
    \(\(findoffset := 
      Module[{x}, offset = rYF[switchbp] - rellipsoid[switchbp, 0]; 
        Print["\<Stokes offset \>", offset, "\< A at \>", switchbp, 
          "\< bp\>"]; ]; \)\), 
    \(\(rbpb[n_] := 
      If[n > switchbp, Return[rYF[n]], 
        If[n > 0, Return[rellipsoid[n, offset]], Return[0]]]; \)\)}], "Input",\

  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(definebasepair; \)\), 
    \(findoffset\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData["Stokes offset 3.00764 A at 50 bp"], "Print",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(rbpb[10]; Print[N[fb]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData["          -8\n2.80519 10"], "Print",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[
"Chain-displacement elements (nucleosomes): particle definitions mnua, rnua \
only."], "Subsubsection",
  Evaluatable->False,
  PageBreakWithin->Automatic,
  AspectRatioFixed->True],

Cell[TextData["Constants"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(mhistone = 108500; \)\), 
    \(\(vhistone = 0.75; \)\), 
    \(\(score = 10.7\/10\^13; \)\), 
    \(\(mcore = 146\ mbpa + mhistone; \)\), 
    \(\(vcore = \(146\ mbpa\ vDNA + mhistone\ vhistone\)\/mcore; \)\)}], 
  "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData["Functions"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(mnu[n_] := mhistone + n\ mbpa; \)\), 
    \(\(vbar[n_] := \(n\ mbpa\ vDNA + mhistone\ vhistone\)\/mnu[n]; \)\), 
    \(\(rcore := 
      N[\(mcore\ \((1 - ro\ vcore)\)\ 10\^8\)\/\(6\ \[Pi]\ visc\ NAvo\ score
            \)]; \)\), 
    \(\(rnu[n_] := 
      N[rcore\ \((\(vbar[n]\ mnu[n]\)\/\(vcore\ mcore\))\)\^\(1/3\)]; \)\)}], 
  "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(definephysicalnuke := 
      Module[{x}, mnua = mnu[wrapbp]; rnua = rnu[wrapbp]; ]; \)\)], "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(report1 := 
      Module[{x, names, values}, 
        names = {"\<el0\>", "\<persistence\nlength\>", "\<repeat0\>", 
            "\<repeat1\>", "\<radius\>", "\<turns\>", "\<pitch\>"}; 
        values = {el0, persistence, repeat0, repeat1, radius, turns, pitch}; 
        units = {"\<A\>", "\<A\>", "\<bp/turn\>", "\<bp/turn\>", "\<A\>", 
            "\<turns\>", "\<A/turn\>"}; 
        Print[MatrixForm[Transpose[{names, values, units}]]]]; \)\), 
    \(\(report2 := 
      Module[{x}, Print["\<Array of chain lengths (bp)\>"]; Print[bns]; 
        Print["\<Array of friction element positions (bp)\>"]; Print[segs]; 
        Print["\<Array of Stokes radii (A)\>"]; Print[radii]; ]; \)\)}], 
  "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Create frictional description of chain"], "Subsubsection",
  Evaluatable->False,
  PageBreakWithin->Automatic,
  AspectRatioFixed->True],

Cell[TextData[
"As far as the conformational routines were concerned, a chain is specified \
by its length and by the positions of the displacement segments. For the \
frictional calculations, one needs to properly assign the Stokes radii of the \
elements and the segment at which the frictional effect is placed. Each \
frictional element in a list of elements can be either an individual segment \
or a collection of segments, so it is important to assign the properties \
appropriately.\n\nI will assume that there are two choices to be made: first, \
whether the uniform chain regions will be treated as individual links or as a \
collection, and second whether the conformational properties should be \
calculated by 1/Sqrt(<r^2>)(faster) or by Monte-Carlo simulation of <1/|r|> \
for a large sample of pseudorandom chains. These choices are indicated by the \
Boolean variables 'collective' and 'MonteCarlo'."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Note there is no error checking, so the chain lengths and nuke \
positions should be consistent! This is not a commercial program. Remember, \
the nucleosome occupies one segment. A segment is not a basepair, it is a \
logical segment of the whole superchain.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(assembleelements[np_] := 
      Module[{n, p, pp}, n = np\[LeftDoubleBracket]1\[RightDoubleBracket]; 
        p = np\[LeftDoubleBracket]2\[RightDoubleBracket]; 
        If[progress, Print["\<Chain of \>", n, "\< segments,\>"]; 
          Print["\<with displacements at segments \>", p]]; 
        If[collective, asegs = p; aStokes = Table[rnua, {i, Length[p]}]; 
            findoffset; pp = Prepend[Append[p, n + 1], 0]; 
            bns = Table[
                pp\[LeftDoubleBracket]i\[RightDoubleBracket] - 
                  pp\[LeftDoubleBracket]i - 1\[RightDoubleBracket] - 1, {i, 
                  2, Length[pp]}]; 
            bsegs = Take[pp, Length[pp] - 1] + Floor[bns\/2]; 
            bStokes = rbpb/@bns; bb = Transpose[{bsegs, bStokes}]; 
            bb = Select[
                bb, #1\[LeftDoubleBracket]2\[RightDoubleBracket] > 0&]; {
                bsegs, bStokes} = Transpose[bb]; x = Join[asegs, bsegs]; 
            y = Join[aStokes, bStokes]; {segs, radii} = 
              Transpose[Sort[Transpose[{x, y}]]], segs = Range[n]; 
            radii = Table[If[MemberQ[p, i], rnua, rbpa], {i, n}]; ]\ report1; 
        report2; ]; \)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(correctr[n_] := 
      Module[{a, b, m}, a = 0.7238; b = 0.002040; m = 1.9436; 
        Return[a + \(1 - a\)\/\(1 + b\^m\ n\^m\)]]; \)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(sediment[np_, f1_] := 
      Module[{n, positions, nnukes, nchain, mass1, vbar1}, 
        n = np\[LeftDoubleBracket]1\[RightDoubleBracket]; 
        positions = np\[LeftDoubleBracket]2\[RightDoubleBracket]; 
        nnukes = Length[positions]; nchain = n + nnukes\ \((wrapbp - 1)\); 
        mass1 = mbpb[nchain] + nnukes\ mhistone; 
        vbar1 = \(mbpb[nchain]\ vDNA + nnukes\ mhistone\ vhistone\)\/mass1; 
        s1 = \(mass1\ \((1 - ro\ vbar1)\)\ g\)\/\(NAvo\ f1\); 
        If[test, Print[{"\<np\>", "\<nchain\>", "\<mass1\>", "\<vbar1\>"}]; 
          Print[{np, nchain, mass1, vbar1}]]; Return[s1]]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(doKirkwood[np_] := 
      Block[{i, i0, j, j0, n, positions, ntot, rirj, delsum, sum, sumradii, 
          ffree}, If[MonteCarlo, rxij = rij, rxij = rcij]; 
        ntot = Length[radii]; If[progress, Print["\<...doKirkwood...\>"]]; 
        sumradii = 
          \[Sum]\+\(i = 1\)\%ntot radii\[LeftDoubleBracket]i
              \[RightDoubleBracket]; sum = 0; 
        Do[i0 = segs\[LeftDoubleBracket]i\[RightDoubleBracket]; 
          Do[rirj = 
              radii\[LeftDoubleBracket]i\[RightDoubleBracket]\ 
                radii\[LeftDoubleBracket]j\[RightDoubleBracket]; 
            j0 = segs\[LeftDoubleBracket]j\[RightDoubleBracket]; 
            If[rirj > 0, rijav = rxij[i0, j0, np]; 
              delsum = rirj\/\(correctr[j0 - i0]\ rijav\), delsum = 0]; 
            If[test, If[nointerrupt, rr = "\<*\>", rr = "\< \>"]; 
              Print["\<i,j,rij:\>", rr, i, "\< \>", j, "\< \>", rijav, 
                "\< corrected:\>", correctr[j0 - i0]\ rijav]]; 
            sum = sum + delsum, {j, i + 1, ntot}], {i, ntot}]; 
        ffree = \(N[\(6\ \[Pi]\ visc\ sumradii\)\/10\^8]\ g\)\/s; 
        f1 = \(N[
                \(6\ \[Pi]\ visc\ sumradii\)\/\(10\^8\ 
                    \((1 + \(2\ sum\)\/sumradii)\)\)]\ g\)\/s; 
        s1 = sediment[np, f1]; 
        If[progress, 
          Print["\<   Kirkwood results: {f free-draining,f1,s1}\>"]; 
          Print["\<   \>", N[{ffree, f1, s1}]]]; ]; \)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{0, 1440}, {0, 877}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{714, 822},
WindowMargins->{{6, Automatic}, {Automatic, 2}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1.5,
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Style Definitions", "Subtitle"],
  
  Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell["Style Environment Names", "Section"],
  
  Cell[StyleData[All, "Working"],
    PageWidth->WindowWidth,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Presentation"],
    PageWidth->WindowWidth,
    ScriptMinSize->12,
    FontSize->16],
  
  Cell[StyleData[All, "Condensed"],
    PageWidth->WindowWidth,
    CellBracketOptions->{"Margins"->{1, 1},
    "Widths"->{0, 5}},
    ScriptMinSize->8,
    FontSize->11],
  
  Cell[StyleData[All, "Printout"],
    PageWidth->PaperWidth,
    ScriptMinSize->5,
    FontSize->10,
    PrivateFontOptions->{"FontType"->"Outline"}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Notebook Options", "Section"],
  
  Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],
  
  Cell[StyleData["Notebook"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    CellFrameLabelMargins->6,
    StyleMenuListing->None]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headings", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Title"],
    CellMargins->{{7, Inherited}, {8, 40}},
    Evaluatable->False,
    CellGroupingRules->{"TitleGrouping", 0},
    CellHorizontalScrolling->False,
    PageBreakBelow->False,
    TextAlignment->Center,
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->24,
    FontWeight->"Bold"],
  
  Cell[StyleData["Title", "Presentation"],
    CellMargins->{{24, 10}, {20, 40}},
    LineSpacing->{1, 0},
    FontSize->44],
  
  Cell[StyleData["Title", "Condensed"],
    CellMargins->{{8, 10}, {4, 8}},
    FontSize->20],
  
  Cell[StyleData["Title", "Printout"],
    CellMargins->{{2, 10}, {12, 30}},
    FontSize->24]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subtitle"],
    CellMargins->{{7, Inherited}, {6, 15}},
    Evaluatable->False,
    CellGroupingRules->{"TitleGrouping", 10},
    CellHorizontalScrolling->False,
    PageBreakBelow->False,
    TextAlignment->Center,
    CounterIncrements->"Subtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subsubtitle", 0}},
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->18,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subtitle", "Presentation"],
    CellMargins->{{24, 10}, {20, 20}},
    LineSpacing->{1, 0},
    FontSize->36],
  
  Cell[StyleData["Subtitle", "Condensed"],
    CellMargins->{{8, 10}, {4, 4}},
    FontSize->14],
  
  Cell[StyleData["Subtitle", "Printout"],
    CellMargins->{{2, 10}, {12, 8}},
    FontSize->18]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubtitle"],
    CellMargins->{{7, Inherited}, {6, 15}},
    Evaluatable->False,
    CellGroupingRules->{"TitleGrouping", 20},
    CellHorizontalScrolling->False,
    PageBreakBelow->False,
    TextAlignment->Center,
    CounterIncrements->"Subsubtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->14,
    FontSlant->"Italic"],
  
  Cell[StyleData["Subsubtitle", "Presentation"],
    CellMargins->{{24, 10}, {20, 20}},
    LineSpacing->{1, 0},
    FontSize->24],
  
  Cell[StyleData["Subsubtitle", "Condensed"],
    CellMargins->{{8, 10}, {8, 8}},
    FontSize->12],
  
  Cell[StyleData["Subsubtitle", "Printout"],
    CellMargins->{{2, 10}, {12, 8}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    CellDingbat->"\[GraySquare]",
    CellMargins->{{9, 90}, {8, 20}},
    Evaluatable->False,
    CellGroupingRules->{"SectionGrouping", 30},
    CellHorizontalScrolling->False,
    PageBreakBelow->False,
    CellLabelMargins->{{-2, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0},
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->18,
    FontWeight->"Bold"],
  
  Cell[StyleData["Section", "Presentation"],
    CellMargins->{{40, 10}, {11, 32}},
    LineSpacing->{1, 0},
    FontSize->24],
  
  Cell[StyleData["Section", "Condensed"],
    CellMargins->{{18, Inherited}, {6, 12}},
    FontSize->12],
  
  Cell[StyleData["Section", "Printout"],
    CellMargins->{{13, 0}, {7, 22}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{9, 90}, {8, 15}},
    Evaluatable->False,
    CellGroupingRules->{"SectionGrouping", 40},
    CellHorizontalScrolling->False,
    PageBreakBelow->False,
    CellLabelMargins->{{-2, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0},
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubsection", 0}},
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsection", "Presentation"],
    CellMargins->{{36, 10}, {11, 32}},
    LineSpacing->{1, 0},
    FontSize->22],
  
  Cell[StyleData["Subsection", "Condensed"],
    CellMargins->{{16, Inherited}, {6, 12}},
    FontSize->12],
  
  Cell[StyleData["Subsection", "Printout"],
    CellMargins->{{9, 0}, {7, 22}},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsection"],
    CellDingbat->"\[EmptySquare]",
    CellMargins->{{9, 90}, {8, 12}},
    Evaluatable->False,
    CellGroupingRules->{"SectionGrouping", 50},
    CellHorizontalScrolling->False,
    PageBreakBelow->False,
    CellLabelMargins->{{-2, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0},
    CounterIncrements->"Subsubsection",
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsubsection", "Presentation"],
    CellMargins->{{34, 10}, {11, 26}},
    LineSpacing->{1, 0},
    FontSize->18],
  
  Cell[StyleData["Subsubsection", "Condensed"],
    CellMargins->{{17, Inherited}, {6, 12}},
    FontSize->10],
  
  Cell[StyleData["Subsubsection", "Printout"],
    CellMargins->{{9, 0}, {7, 14}},
    FontSize->11]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Body Text", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    CellMargins->{{9, 90}, {7, 7}},
    Evaluatable->False,
    CellHorizontalScrolling->False,
    PageBreakWithin->Automatic,
    CellLabelMargins->{{-2, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0},
    CounterIncrements->"Text",
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->12],
  
  Cell[StyleData["Text", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5}],
  
  Cell[StyleData["Text", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1}],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{2, 2}, {6, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallText"],
    CellMargins->{{9, 90}, {6, 6}},
    Evaluatable->False,
    CellHorizontalScrolling->False,
    PageBreakWithin->Automatic,
    CellLabelMargins->{{-2, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0},
    CounterIncrements->"SmallText",
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->10],
  
  Cell[StyleData["SmallText", "Presentation"],
    CellMargins->{{24, 10}, {8, 8}},
    LineSpacing->{1, 5},
    FontSize->12],
  
  Cell[StyleData["SmallText", "Condensed"],
    CellMargins->{{8, 10}, {5, 5}},
    LineSpacing->{1, 2},
    FontSize->9],
  
  Cell[StyleData["SmallText", "Printout"],
    CellMargins->{{2, 2}, {5, 5}},
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Input/Output", "Section"],
  
  Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names. Some attributes for these styles are actually set in FormatType Styles \
(in the last section of this stylesheet). \
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    CellMargins->{{22, 10}, {5, 7}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    LineSpacing->{1, 0},
    AutoItalicWords->{},
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    CounterIncrements->"Input",
    AspectRatioFixed->True,
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["Input", "Presentation"],
    CellMargins->{{72, Inherited}, {8, 10}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Input", "Condensed"],
    CellMargins->{{40, 10}, {2, 3}}],
  
  Cell[StyleData["Input", "Printout"],
    CellMargins->{{39, 0}, {4, 6}},
    FontSize->9]
  }, Closed]],
  
  Cell[StyleData["InputOnly"],
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    DefaultFormatType->DefaultInputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    CounterIncrements->"Input",
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Output"],
    CellMargins->{{22, 10}, {7, 5}},
    CellEditDuplicate->True,
    Evaluatable->False,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    LineSpacing->{1, 0},
    AutoItalicWords->{},
    FormatType->InputForm,
    CounterIncrements->"Output",
    AspectRatioFixed->True,
    FontFamily->"Courier",
    FontSize->12],
  
  Cell[StyleData["Output", "Presentation"],
    CellMargins->{{72, Inherited}, {10, 8}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Output", "Condensed"],
    CellMargins->{{41, Inherited}, {3, 2}}],
  
  Cell[StyleData["Output", "Printout"],
    CellMargins->{{39, 0}, {6, 4}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Message"],
    PageWidth->Infinity,
    CellMargins->{{22, Inherited}, {Inherited, Inherited}},
    Evaluatable->False,
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    LineSpacing->{1, 0},
    AutoItalicWords->{},
    FormatType->InputForm,
    CounterIncrements->"Message",
    AspectRatioFixed->True,
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    FontColor->RGBColor[1, 0, 0]],
  
  Cell[StyleData["Message", "Presentation"],
    CellMargins->{{72, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Message", "Condensed"],
    CellMargins->{{41, Inherited}, {Inherited, Inherited}}],
  
  Cell[StyleData["Message", "Printout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->8,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Print"],
    PageWidth->Infinity,
    CellMargins->{{22, Inherited}, {Inherited, Inherited}},
    Evaluatable->False,
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    LineSpacing->{1, 0},
    AutoItalicWords->{},
    FormatType->InputForm,
    CounterIncrements->"Print",
    AspectRatioFixed->True,
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12],
  
  Cell[StyleData["Print", "Presentation"],
    CellMargins->{{72, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Print", "Condensed"],
    CellMargins->{{41, Inherited}, {Inherited, Inherited}}],
  
  Cell[StyleData["Print", "Printout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Graphics"],
    PageWidth->Infinity,
    CellMargins->{{7, Inherited}, {Inherited, Inherited}},
    Evaluatable->False,
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->InputForm,
    CounterIncrements->"Graphics",
    AspectRatioFixed->True,
    ImageSize->{282, 287},
    ImageMargins->{{34, Inherited}, {Inherited, 0}},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12],
  
  Cell[StyleData["Graphics", "Presentation"],
    ImageMargins->{{62, Inherited}, {Inherited, 0}}],
  
  Cell[StyleData["Graphics", "Condensed"],
    ImageMargins->{{38, Inherited}, {Inherited, 0}},
    Magnification->0.6],
  
  Cell[StyleData["Graphics", "Printout"],
    ImageMargins->{{30, Inherited}, {Inherited, 0}},
    FontSize->9,
    Magnification->0.8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellLabel"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["CellLabel", "Presentation"],
    FontSize->12],
  
  Cell[StyleData["CellLabel", "Condensed"],
    FontSize->9],
  
  Cell[StyleData["CellLabel", "Printout"],
    FontFamily->"Courier",
    FontSize->8,
    FontSlant->"Italic",
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Formulas and Programming", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineFormula"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    ScriptLevel->1,
    SingleLetterItalics->True],
  
  Cell[StyleData["InlineFormula", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5}],
  
  Cell[StyleData["InlineFormula", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1}],
  
  Cell[StyleData["InlineFormula", "Printout"],
    CellMargins->{{2, 0}, {6, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayFormula"],
    CellMargins->{{42, Inherited}, {Inherited, Inherited}},
    CellHorizontalScrolling->True,
    DefaultFormatType->DefaultInputFormatType,
    ScriptLevel->0,
    SingleLetterItalics->True,
    UnderoverscriptBoxOptions->{LimitsPositioning->True}],
  
  Cell[StyleData["DisplayFormula", "Presentation"],
    LineSpacing->{1, 5}],
  
  Cell[StyleData["DisplayFormula", "Condensed"],
    LineSpacing->{1, 1}],
  
  Cell[StyleData["DisplayFormula", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headers and Footers", "Section"],
  
  Cell[StyleData["Header"],
    CellMargins->{{7, 0}, {4, 1}},
    Evaluatable->False,
    PageBreakWithin->Automatic,
    AspectRatioFixed->True,
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->12,
    FontSlant->"Italic"],
  
  Cell[StyleData["Footer"],
    CellMargins->{{7, 0}, {0, 4}},
    Evaluatable->False,
    PageBreakWithin->Automatic,
    TextAlignment->Center,
    AspectRatioFixed->True,
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->12,
    FontSlant->"Italic"],
  
  Cell[StyleData["PageNumber"],
    CellMargins->{{0, 0}, {4, 1}},
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Palette Styles", "Section"],
  
  Cell["\<\
The cells below define styles that define standard \
ButtonFunctions, for use in palette buttons.\
\>", "Text"],
  
  Cell[StyleData["Paste"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, After]}]&)}],
  
  Cell[StyleData["Evaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["EvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionMove[ 
          FrontEnd`InputNotebook[ ], All, Cell, 1], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Hyperlink Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Hyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonNote->ButtonData}],
  
  Cell[StyleData["Hyperlink", "Presentation"]],
  
  Cell[StyleData["Hyperlink", "Condensed"]],
  
  Cell[StyleData["Hyperlink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MainBookLink", "Presentation"]],
  
  Cell[StyleData["MainBookLink", "Condensed"]],
  
  Cell[StyleData["MainBookLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["AddOnsLink", "Presentation"]],
  
  Cell[StyleData["AddOnsLink", "Condensed"]],
  
  Cell[StyleData["AddOnLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RefGuideLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "RefGuideLink", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["RefGuideLink", "Presentation"]],
  
  Cell[StyleData["RefGuideLink", "Condensed"]],
  
  Cell[StyleData["RefGuideLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GettingStartedLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["GettingStartedLink", "Presentation"]],
  
  Cell[StyleData["GettingStartedLink", "Condensed"]],
  
  Cell[StyleData["GettingStartedLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OtherInformationLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["OtherInformationLink", "Presentation"]],
  
  Cell[StyleData["OtherInformationLink", "Condensed"]],
  
  Cell[StyleData["OtherInformationLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Placeholder Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making placeholder \
objects in palette templates.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Placeholder"],
    Editable->False,
    Selectable->False,
    StyleBoxAutoDelete->True,
    Placeholder->True,
    StyleMenuListing->None],
  
  Cell[StyleData["Placeholder", "Presentation"]],
  
  Cell[StyleData["Placeholder", "Condensed"]],
  
  Cell[StyleData["Placeholder", "Printout"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SelectionPlaceholder"],
    Editable->False,
    Selectable->False,
    StyleBoxAutoDelete->True,
    Placeholder->PrimaryPlaceholder,
    StyleMenuListing->None,
    DrawHighlighted->True],
  
  Cell[StyleData["SelectionPlaceholder", "Presentation"]],
  
  Cell[StyleData["SelectionPlaceholder", "Condensed"]],
  
  Cell[StyleData["SelectionPlaceholder", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["FormatType Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are mixed in with the styles \
of most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options. This is particularly true of Input and Output.\
\>", "Text"],
  
  Cell[StyleData["CellExpression"],
    PageWidth->Infinity,
    CellMargins->{{6, Inherited}, {Inherited, Inherited}},
    ShowCellLabel->False,
    ShowSpecialCharacters->False,
    AllowInlineCells->False,
    AutoItalicWords->{},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    Background->GrayLevel[1]],
  
  Cell[StyleData["InputForm"],
    AllowInlineCells->False,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["OutputForm"],
    PageWidth->Infinity,
    TextAlignment->Left,
    LineSpacing->{0.6, 1},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["StandardForm"],
    LineSpacing->{1.25, 0},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["TraditionalForm"],
    LineSpacing->{1.25, 0},
    SingleLetterItalics->True,
    TraditionalFunctionNotation->True,
    DelimiterMatching->None,
    StyleMenuListing->None],
  
  Cell["\<\
The style defined below is mixed in to any cell that is in an \
inline cell within another.\
\>", "Text"],
  
  Cell[StyleData["InlineCell"],
    TextAlignment->Left,
    ScriptLevel->1,
    StyleMenuListing->None],
  
  Cell[StyleData["InlineCellEditing"],
    StyleMenuListing->None,
    Background->RGBColor[1, 0.749996, 0.8]]
  }, Closed]]
  }, Open  ]]
  }]
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 1922, 35, 661, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3701, 90, 154, 3, 55, "Subsection",
  Evaluatable->False,
  PageBreakWithin->Automatic],
Cell[3858, 95, 869, 13, 381, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4752, 112, 132, 3, 51, "Subsubsection",
  Evaluatable->False,
  PageBreakWithin->Automatic],
Cell[4887, 117, 228, 6, 62, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[5118, 125, 413, 10, 154, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[5534, 137, 232, 6, 85, "Input",
  InitializationCell->True],
Cell[5769, 145, 110, 3, 39, "Input",
  InitializationCell->True],
Cell[5882, 150, 118, 3, 46, "Input",
  InitializationCell->True],
Cell[6003, 155, 564, 12, 154, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[6570, 169, 608, 13, 154, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[7215, 187, 155, 3, 51, "Subsubsection",
  Evaluatable->False,
  PageBreakWithin->Automatic],
Cell[7373, 192, 566, 9, 161, "Text",
  Evaluatable->False],
Cell[7942, 203, 83, 2, 41, "Text",
  Evaluatable->False],
Cell[8028, 207, 239, 7, 85, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[8270, 216, 83, 2, 41, "Text",
  Evaluatable->False],
Cell[8356, 220, 1070, 21, 559, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[9463, 246, 157, 3, 51, "Subsubsection",
  Evaluatable->False,
  PageBreakWithin->Automatic],
Cell[9623, 251, 427, 7, 121, "Text",
  Evaluatable->False],
Cell[10053, 260, 83, 2, 41, "Text",
  Evaluatable->False],
Cell[10139, 264, 273, 8, 108, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[10415, 274, 83, 2, 41, "Text",
  Evaluatable->False],
Cell[10501, 278, 1653, 34, 915, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[12157, 314, 114, 2, 41, "Text",
  Evaluatable->False],
Cell[12274, 318, 399, 10, 234, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[12710, 333, 241, 5, 72, "Subsubsection",
  Evaluatable->False,
  PageBreakWithin->Automatic],
Cell[12954, 340, 324, 6, 101, "Text",
  Evaluatable->False],
Cell[13281, 348, 479, 12, 154, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[13763, 362, 466, 10, 62, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[14232, 374, 320, 8, 85, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[14589, 387, 156, 4, 72, "Subsubsection",
  Evaluatable->False],
Cell[14748, 393, 282, 8, 85, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[15033, 403, 999, 19, 177, "Input",
  InitializationCell->True],
Cell[16035, 424, 1293, 24, 457, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[17377, 454, 144, 3, 55, "Subsection",
  Evaluatable->False,
  PageBreakWithin->Automatic],
Cell[17524, 459, 864, 13, 241, "Text",
  Evaluatable->False],
Cell[18391, 474, 501, 8, 141, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[18917, 486, 133, 3, 51, "Subsubsection",
  Evaluatable->False,
  PageBreakWithin->Automatic],
Cell[19053, 491, 455, 8, 141, "Text",
  Evaluatable->False],
Cell[19511, 501, 237, 7, 88, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[19751, 510, 312, 8, 137, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[20100, 523, 236, 5, 72, "Subsubsection",
  Evaluatable->False,
  PageBreakWithin->Automatic],
Cell[20339, 530, 83, 2, 41, "Text",
  Evaluatable->False],
Cell[20425, 534, 284, 9, 131, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[20712, 545, 83, 2, 41, "Text",
  Evaluatable->False],
Cell[20798, 549, 1554, 33, 870, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],

Cell[CellGroupData[{
Cell[22377, 586, 102, 3, 62, "Input"],
Cell[22482, 591, 107, 2, 31, "Print",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[22626, 598, 81, 2, 39, "Input"],
Cell[22710, 602, 99, 2, 50, "Print",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[22858, 610, 196, 5, 72, "Subsubsection",
  Evaluatable->False,
  PageBreakWithin->Automatic],
Cell[23057, 617, 83, 2, 41, "Text",
  Evaluatable->False],
Cell[23143, 621, 366, 10, 189, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[23512, 633, 83, 2, 41, "Text",
  Evaluatable->False],
Cell[23598, 637, 483, 12, 209, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[24084, 651, 240, 6, 62, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[24327, 659, 781, 15, 292, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[25145, 679, 151, 3, 51, "Subsubsection",
  Evaluatable->False,
  PageBreakWithin->Automatic],
Cell[25299, 684, 974, 14, 301, "Text",
  Evaluatable->False],
Cell[26276, 700, 331, 7, 101, "Text",
  Evaluatable->False],
Cell[26610, 709, 1244, 22, 432, "Input",
  InitializationCell->True],
Cell[27857, 733, 223, 5, 94, "Input",
  InitializationCell->True],
Cell[28083, 740, 674, 11, 294, "Input"],
Cell[28760, 753, 1507, 28, 568, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

