(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4944,        117]*)
(*NotebookOutlinePosition[      5608,        140]*)
(*  CellTagsIndexPosition[      5564,        136]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(box[{xmin_, ymin_}, {xmax_, ymax_}] := 
        Line[{{xmin, ymin}, {xmin, ymax}, {xmax, ymax}, {xmax, 
              ymin}}];\)\)], "Input",
  CellMargins->{{Inherited, 54}, {Inherited, Inherited}},
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(bar[x_, y_, dx_, g_] := {GrayLevel[g], 
          Rectangle[{x - dx, 0}, {x + dx, y}], GrayLevel[0], 
          box[{x - dx, 0}, {x + dx, y}]};\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(barchart[x_, y_, dx_, g_, title_] := 
        Module[{i, j, boxes, bars}, \n\t\t (*\ 
            Watch\ \(out\ --\)\ dx\ is\ the\ half - 
              width\ of\ a\ \(bar!\)\ *) \[IndentingNewLine]bars = 
            Table[bar[x\[LeftDoubleBracket]i\[RightDoubleBracket], 
                y\[LeftDoubleBracket]i\[RightDoubleBracket], dx, g], {i, 
                Length[y]}]; 
          Show[Graphics[bars], Axes \[Rule] True, PlotRange \[Rule] All, 
            PlotLabel \[Rule] title, 
            DisplayFunction \[Rule] Identity]];\)\)], "Input",
  CellMargins->{{Inherited, 54}, {Inherited, Inherited}},
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(wdistribution[rdata_, wdata_, binsize_, int_, gmin_, gmax_, grey_, 
          title_] := 
        Block[{i, j, j0, k, g1, x, min, max, nbins, integral, sums, total, 
            totalweight, xdata, top}, integral = int == 1; Clear[g1]; 
          n = Length[rdata]; min = gmin; max = gmax; 
          nbins = Floor[\(max - min\)\/binsize]; Print[{nbins, binsize, n}]; 
          sums = Table[0, {nbins}]; total = Table[0, {nbins}]; 
          totalweight = 0; 
          assignbin[{x_, w_}] := 
            Block[{j0}, j0 = Floor[\(x - min\)\/binsize] + 1; 
              If[j0 > nbins || j0 < 1, j0 = nbins]; 
              sums\[LeftDoubleBracket]j0\[RightDoubleBracket] = 
                sums\[LeftDoubleBracket]j0\[RightDoubleBracket] + w; 
              totalweight = totalweight + w]; 
          assignbin /@ Transpose[{rdata, wdata}]; Print["\<binned...\>"]; 
          total\[LeftDoubleBracket]1\[RightDoubleBracket] = 
            sums\[LeftDoubleBracket]1\[RightDoubleBracket]; 
          Do[total\[LeftDoubleBracket]j\[RightDoubleBracket] = 
              total\[LeftDoubleBracket]j - 1\[RightDoubleBracket] + 
                sums\[LeftDoubleBracket]j\[RightDoubleBracket], {j, 2, 
              nbins}]; 
          xdata = Table[
              min + \(\((j - 1\/2)\)\ \((max - min)\)\)\/nbins, {j, nbins}]; 
          top = rdata\ wdata; 
          Print["\<top summed...\>"]; \[IndentingNewLine]average = \(\[Sum]\+\
\(x = 1\)\%\(Length[top]\)top\[LeftDoubleBracket]x\[RightDoubleBracket]\)\/\
totalweight; \[IndentingNewLine]Print["\<Average is \>", average]; 
          If[integral, g1 = barchart[xdata, total, binsize\/2, grey, title], 
            g1 = barchart[xdata, sums, binsize\/2, grey, title]]; 
          Show[g1, DisplayFunction \[Rule] $DisplayFunction, 
            AspectRatio \[Rule] 1/GoldenRatio]];\)\)], "Input",
  CellMargins->{{Inherited, 54}, {Inherited, Inherited}},
  PageBreakAbove->False,
  InitializationCell->True,
  AspectRatioFixed->False]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{0, 1440}, {0, 877}},
AutoGeneratedPackage->None,
WindowSize->{866, 831},
WindowMargins->{{12, Automatic}, {0, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 275, 6, 43, "Input",
  InitializationCell->True],
Cell[2032, 59, 208, 4, 43, "Input",
  InitializationCell->True],
Cell[2243, 65, 687, 13, 91, "Input",
  InitializationCell->True],
Cell[2933, 80, 2007, 35, 405, "Input",
  PageBreakAbove->False,
  InitializationCell->True]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

