(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    107596,       2776]*)
(*NotebookOutlinePosition[    108464,       2806]*)
(*  CellTagsIndexPosition[    108420,       2802]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["\<\
Hydro MS Example 3: Vary nucleosome placements \
on template: 1.75 turns\
\>", "Subsubsection",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
Here are the calculations for the examples given in my paper for a \
chromatin saturation process. A trimer of positioning sites is envisioned, \
and the frictional properties of all possible species are calculated. Since \
when I did these I hadn't yet reactivated the sedimentation coefficient \
subroutine, I calculate all the sedimentation coefficients all at the \
end.\
\>", "Text",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
First clear the randomizing orientation matrix so that all of the \
chain pictures will be aligned in the same coordinate system.\
\>", "Text",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
ClearAll[A0];
A0=IdentityMatrix[3];\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
Define the chain and the nucleosomes for this example. Default \
parameters include persistence length of 150 bp.\
\>", "Text",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
turns=1.75;
definebasepair;
definenuke;
definephysicalnuke;
chaininitialize;
wrapbp\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["n = 20 ; dl = 24.5119", "Print",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[OutputFormData["\<\
146\
\>", "\<\
146\
\>"], "Output",
  ImageRegion->{{-0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
Now define a couple of things to make the example easier to do. The \
DNA chain is of length template (bp), and there are nnukes nucleosomes on it. \
The nucleosomes begin and end the chain. The linker length in bp is \
calculated, and the \"chain\" defined.  Remember that the chain of segments \
includes one segment for each free basepair (the linker) and one segment for \
each nucleosome.\
\>", "Text",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["ntemplate=624;\t\t\t(* total length, bp *)", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
species={{1},{2},{3},{1,2},{1,3},{2,3},{1,2,3}};
nt[spots_]:=ntemplate - Length[spots] wrapbp + Length[spots];
Map[nt,species]\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[OutputFormData["\<\
{479, 479, 479, 334, 334, 334, 189}\
\>", "\<\
{479, \
479, 479, 334, 334, 334, 189}\
\>"], "Output",
  ImageRegion->{{-0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
chain={\t{479,{1}},
\t\t{479,{209}},
\t\t{479,{417}},
\t\t{334,{1,64}},
\t\t{334,{1,272}},
\t\t{334,{209,272}},
\t\t{189,{1,64,127}}\t};\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
persistence=150 el0;
definebasepair;\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
collective=True;
test=True;
progress=True;
MonteCarlo=False;\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
Do[\tassembleelements[chain[[isp]]];
\tmakeAs[chain[[isp]]];
\tdoKirkwood[chain[[isp]]],
{isp,Length[species]}];\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\

Chain of 479 segments,
with displacements at segments {1}
Stokes offset 3.00764 A at 50 bp
el0           3.4           A
persistence
length        510.          A
repeat0       10.4          bp/turn
repeat1       10.15         bp/turn
radius        44.916        A
turns         1.75          turns
pitch         -28.571       A/turn
Array of chain lengths (bp)
{0, 478}
Array of friction element positions (bp)
{1, 240}
Array of Stokes radii (A)
{56.8124, 163.022}
...doKirkwood...
i,j,rij:*1 2 645.816 corrected:610.422
   Kirkwood results: {f free-draining,f1,s1}
              -7              -7
    4.21008 10   g  3.69942 10   g
   {--------------, --------------, s1}
          s               s
          
          
Chain of 479 segments,
with displacements at segments {209}
Stokes offset 3.00764 A at 50 bp
el0           3.4           A
persistence
length        510.          A
repeat0       10.4          bp/turn
repeat1       10.15         bp/turn
radius        44.916        A
turns         1.75          turns
pitch         -28.571       A/turn
Array of chain lengths (bp)
{208, 270}
Array of friction element positions (bp)
{104, 209, 344}
Array of Stokes radii (A)
{89.9682, 56.8124, 108.172}
...doKirkwood...
i,j,rij:*1 2 324.43 corrected:320.159
i,j,rij:*1 3 472.918 corrected:446.831
i,j,rij:*2 3 403.033 corrected:394.638
   Kirkwood results: {f free-draining,f1,s1}
              -7              -7
    4.88263 10   g  3.44271 10   g
   {--------------, --------------, s1}
          s               s
          
          
Chain of 479 segments,
with displacements at segments {417}
Stokes offset 3.00764 A at 50 bp
el0           3.4           A
persistence
length        510.          A
repeat0       10.4          bp/turn
repeat1       10.15         bp/turn
radius        44.916        A
turns         1.75          turns
pitch         -28.571       A/turn
Array of chain lengths (bp)
{416, 62}
Array of friction element positions (bp)
{208, 417, 448}
Array of Stokes radii (A)
{147.483, 56.8124, 40.8859}
...doKirkwood...
i,j,rij:*1 2 580.183 corrected:554.514
i,j,rij:*1 3 558.29 corrected:527.493
i,j,rij:*2 3 114.667 corrected:114.52
   Kirkwood results: {f free-draining,f1,s1}
              -7              -7
    4.69551 10   g  3.39772 10   g
   {--------------, --------------, s1}
          s               s
          
          
Chain of 334 segments,
with displacements at segments {1, 64}
Stokes offset 3.00764 A at 50 bp
el0           3.4           A
persistence
length        510.          A
repeat0       10.4          bp/turn
repeat1       10.15         bp/turn
radius        44.916        A
turns         1.75          turns
pitch         -28.571       A/turn
Array of chain lengths (bp)
{0, 62, 270}
Array of friction element positions (bp)
{1, 32, 64, 199}
Array of Stokes radii (A)
{56.8124, 40.8859, 56.8124, 108.172}
...doKirkwood...
i,j,rij:*1 2 114.667 corrected:114.52
i,j,rij:*1 3 216.181 corrected:215.094
i,j,rij:*1 4 389.412 corrected:373.65
i,j,rij:*2 3 117.624 corrected:117.463
i,j,rij:*2 4 380.308 corrected:368.775
i,j,rij:*3 4 403.033 corrected:394.638
   Kirkwood results: {f free-draining,f1,s1}
              -7              -7
    5.03067 10   g  2.86755 10   g
   {--------------, --------------, s1}
          s               s
          
          
Chain of 334 segments,
with displacements at segments {1, 272}
Stokes offset 3.00764 A at 50 bp
el0           3.4           A
persistence
length        510.          A
repeat0       10.4          bp/turn
repeat1       10.15         bp/turn
radius        44.916        A
turns         1.75          turns
pitch         -28.571       A/turn
Array of chain lengths (bp)
{0, 270, 62}
Array of friction element positions (bp)
{1, 136, 272, 303}
Array of Stokes radii (A)
{56.8124, 108.172, 56.8124, 40.8859}
...doKirkwood...
i,j,rij:*1 2 403.033 corrected:394.638
i,j,rij:*1 3 715.09 corrected:667.661
i,j,rij:*1 4 692.236 corrected:638.584
i,j,rij:*2 3 405.636 corrected:397.074
i,j,rij:*2 4 382.279 corrected:370.687
i,j,rij:*3 4 114.667 corrected:114.52
   Kirkwood results: {f free-draining,f1,s1}
              -7              -7
    5.03067 10   g  3.25362 10   g
   {--------------, --------------, s1}
          s               s
          
          
Chain of 334 segments,
with displacements at segments {209, 272}
Stokes offset 3.00764 A at 50 bp
el0           3.4           A
persistence
length        510.          A
repeat0       10.4          bp/turn
repeat1       10.15         bp/turn
radius        44.916        A
turns         1.75          turns
pitch         -28.571       A/turn
Array of chain lengths (bp)
{208, 62, 62}
Array of friction element positions (bp)
{104, 209, 240, 272, 303}
Array of Stokes radii (A)
{89.9682, 56.8124, 40.8859, 56.8124, 40.8859}
...doKirkwood...
i,j,rij:*1 2 324.43 corrected:320.159
i,j,rij:*1 3 301.232 corrected:294.874
i,j,rij:*1 4 317.637 corrected:307.905
i,j,rij:*1 5 358.974 corrected:344.322
i,j,rij:*2 3 114.667 corrected:114.52
i,j,rij:*2 4 216.181 corrected:215.094
i,j,rij:*2 5 177.429 corrected:175.527
i,j,rij:*3 4 117.624 corrected:117.463
i,j,rij:*3 5 111.337 corrected:110.777
i,j,rij:*4 5 114.667 corrected:114.52
   Kirkwood results: {f free-draining,f1,s1}
              -7              -7
    5.46506 10   g  2.58136 10   g
   {--------------, --------------, s1}
          s               s
          
          
Chain of 189 segments,
with displacements at segments {1, 64, 127}
Stokes offset 3.00764 A at 50 bp
el0           3.4           A
persistence
length        510.          A
repeat0       10.4          bp/turn
repeat1       10.15         bp/turn
radius        44.916        A
turns         1.75          turns
pitch         -28.571       A/turn
Array of chain lengths (bp)
{0, 62, 62, 62}
Array of friction element positions (bp)
{1, 32, 64, 95, 127, 158}
Array of Stokes radii (A)
{56.8124, 40.8859, 56.8124, 40.8859, 56.8124, 40.8859}
...doKirkwood...
i,j,rij:*1 2 114.667 corrected:114.52
i,j,rij:*1 3 216.181 corrected:215.094
i,j,rij:*1 4 177.429 corrected:175.527
i,j,rij:*1 5 207.821 corrected:203.999
i,j,rij:*1 6 245.647 corrected:238.957
i,j,rij:*2 3 117.624 corrected:117.463
i,j,rij:*2 4 111.337 corrected:110.777
i,j,rij:*2 5 178.214 corrected:176.266
i,j,rij:*2 6 184.858 corrected:181.459
i,j,rij:*3 4 114.667 corrected:114.52
i,j,rij:*3 5 216.181 corrected:215.094
i,j,rij:*3 6 177.429 corrected:175.527
i,j,rij:*4 5 117.624 corrected:117.463
i,j,rij:*4 6 111.337 corrected:110.777
i,j,rij:*5 6 114.667 corrected:114.52
   Kirkwood results: {f free-draining,f1,s1}
             -7              -7
    5.6131 10   g  2.15597 10   g
   {-------------, --------------, s1}
          s              s\
\>", "Print",
  ImageRegion->{{-0, 1}, {0, 1}}]
}, Open  ]],

Cell["Calculate sedimentation coefficients", "Text",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
First check \"sediment\" routine for a mononucleosome core particle\
\
\>", "Text",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["sediment[{1,{1}},1.09 10^-7 g/s]", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
{np, nchain, mass1, vbar1}
{{1, {1}}, 146, 204860, 0.655926}\
\>", "Print",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[OutputFormData["\<\
1.06805877960315767*10^-12*s\
\>", "\<\
          \
-12
1.06806 10    s\
\>"], "Output",
  ImageRegion->{{-0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "f1values={",
  StyleBox["3.69942,3.44271,3.39772,2.86755,\n            \
3.25362,2.58136,2.15597",
    FontWeight->"Plain"],
  "} 10^-7 g/s;\nDo[Print[\"\\n\",sediment[chain[[isp]],f1values[[isp]]]],\n\
{isp,Length[chain]}];"
}], "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
{np, nchain, mass1, vbar1}
{{479, {1}}, 624, 520340, 0.591704}
          -13
9.49818 10    s

{np, nchain, mass1, vbar1}
{{479, {209}}, 624, 520340, 0.591704}
          -12
1.02064 10    s

{np, nchain, mass1, vbar1}
{{479, {417}}, 624, 520340, 0.591704}
          -12
1.03416 10    s

{np, nchain, mass1, vbar1}
{{334, {1, 64}}, 624, 628840, 0.619016}
          -12
1.38108 10    s

{np, nchain, mass1, vbar1}
{{334, {1, 272}}, 624, 628840, 0.619016}
         -12
1.2172 10    s

{np, nchain, mass1, vbar1}
{{334, {209, 272}}, 624, 628840, 0.619016}
          -12
1.53419 10    s

{np, nchain, mass1, vbar1}
{{189, {1, 64, 127}}, 624, 737340, 0.63829}
          -12
2.04401 10    s\
\>", "Print",
  ImageRegion->{{-0, 1}, {0, 1}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Hydro MS Example 3: Generate sedimentation distributions for trimer\
\
\>", "Subsubsection",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["ss={8.1,9.5,10.2,10.3,13.8,12.2,15.3,20.4};", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
fcoop[x_]:=Module[{a,b},
\ta=(1-x);
\tb=x;
\t{a,0,0,0,0,0,0,b}];
frand[x_]:=Module[{a,b},
\ta=(1-x);
\tb=x;
\t{a^3,a^2 b,a^2 b,a^2 b,a b^2,a b^2,a b^2,b^3}];\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Print[MatrixForm[{ss,fcoop[0.5]}]]", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
8.1    9.5    10.2   10.3   13.8   12.2   15.3   20.4

0.5    0      0      0      0      0      0      0.5\
\>", "Print",
  ImageRegion->{{-0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Print[MatrixForm[{ss,frand[0.5]}]]", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
8.1     9.5     10.2    10.3    13.8    12.2    15.3    20.4

0.125   0.125   0.125   0.125   0.125   0.125   0.125   0.125\
\>", "Print",
  ImageRegion->{{-0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
Demonstrate that the sum of species fractions is always unity for \
both models\
\>", "Text",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
Print[Simplify[Apply[Plus,fcoop[x]]]];
Print[Simplify[Apply[Plus,frand[x]]]];\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
1
1\
\>", "Print",
  ImageRegion->{{-0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["wdistribution[ss,fcoop[0.5],1,0,5,22,0,\"coop\"];", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
{17, 1, 8}
binned...
top summed...
Average is 14.25\
\>", "Print",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.256303 0.0560224 0.0147151 1.17721 [
[(7.5)] .16387 .01472 0 2 Msboxa
[(10)] .30392 .01472 0 2 Msboxa
[(12.5)] .44398 .01472 0 2 Msboxa
[(15)] .58403 .01472 0 2 Msboxa
[(17.5)] .72409 .01472 0 2 Msboxa
[(20)] .86415 .01472 0 2 Msboxa
[(coop)] .5 .61803 0 -2 Msboxa
[(0.1)] .01131 .13244 1 0 Msboxa
[(0.2)] .01131 .25016 1 0 Msboxa
[(0.3)] .01131 .36788 1 0 Msboxa
[(0.4)] .01131 .4856 1 0 Msboxa
[(0.5)] .01131 .60332 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.16387 .01472 m
.16387 .02097 L
s
P
[(7.5)] .16387 .01472 0 2 Mshowa
p
.002 w
.30392 .01472 m
.30392 .02097 L
s
P
[(10)] .30392 .01472 0 2 Mshowa
p
.002 w
.44398 .01472 m
.44398 .02097 L
s
P
[(12.5)] .44398 .01472 0 2 Mshowa
p
.002 w
.58403 .01472 m
.58403 .02097 L
s
P
[(15)] .58403 .01472 0 2 Mshowa
p
.002 w
.72409 .01472 m
.72409 .02097 L
s
P
[(17.5)] .72409 .01472 0 2 Mshowa
p
.002 w
.86415 .01472 m
.86415 .02097 L
s
P
[(20)] .86415 .01472 0 2 Mshowa
p
.001 w
.05182 .01472 m
.05182 .01847 L
s
P
p
.001 w
.07983 .01472 m
.07983 .01847 L
s
P
p
.001 w
.10784 .01472 m
.10784 .01847 L
s
P
p
.001 w
.13585 .01472 m
.13585 .01847 L
s
P
p
.001 w
.19188 .01472 m
.19188 .01847 L
s
P
p
.001 w
.21989 .01472 m
.21989 .01847 L
s
P
p
.001 w
.2479 .01472 m
.2479 .01847 L
s
P
p
.001 w
.27591 .01472 m
.27591 .01847 L
s
P
p
.001 w
.33193 .01472 m
.33193 .01847 L
s
P
p
.001 w
.35994 .01472 m
.35994 .01847 L
s
P
p
.001 w
.38796 .01472 m
.38796 .01847 L
s
P
p
.001 w
.41597 .01472 m
.41597 .01847 L
s
P
p
.001 w
.47199 .01472 m
.47199 .01847 L
s
P
p
.001 w
.5 .01472 m
.5 .01847 L
s
P
p
.001 w
.52801 .01472 m
.52801 .01847 L
s
P
p
.001 w
.55602 .01472 m
.55602 .01847 L
s
P
p
.001 w
.61204 .01472 m
.61204 .01847 L
s
P
p
.001 w
.64006 .01472 m
.64006 .01847 L
s
P
p
.001 w
.66807 .01472 m
.66807 .01847 L
s
P
p
.001 w
.69608 .01472 m
.69608 .01847 L
s
P
p
.001 w
.7521 .01472 m
.7521 .01847 L
s
P
p
.001 w
.78011 .01472 m
.78011 .01847 L
s
P
p
.001 w
.80812 .01472 m
.80812 .01847 L
s
P
p
.001 w
.83613 .01472 m
.83613 .01847 L
s
P
p
.001 w
.89216 .01472 m
.89216 .01847 L
s
P
p
.001 w
.92017 .01472 m
.92017 .01847 L
s
P
p
.001 w
.94818 .01472 m
.94818 .01847 L
s
P
p
.001 w
.97619 .01472 m
.97619 .01847 L
s
P
p
.002 w
0 .01472 m
1 .01472 L
s
P
[(coop)] .5 .61803 0 -2 Mshowa
p
.002 w
.02381 .13244 m
.03006 .13244 L
s
P
[(0.1)] .01131 .13244 1 0 Mshowa
p
.002 w
.02381 .25016 m
.03006 .25016 L
s
P
[(0.2)] .01131 .25016 1 0 Mshowa
p
.002 w
.02381 .36788 m
.03006 .36788 L
s
P
[(0.3)] .01131 .36788 1 0 Mshowa
p
.002 w
.02381 .4856 m
.03006 .4856 L
s
P
[(0.4)] .01131 .4856 1 0 Mshowa
p
.002 w
.02381 .60332 m
.03006 .60332 L
s
P
[(0.5)] .01131 .60332 1 0 Mshowa
p
.001 w
.02381 .03826 m
.02756 .03826 L
s
P
p
.001 w
.02381 .0618 m
.02756 .0618 L
s
P
p
.001 w
.02381 .08535 m
.02756 .08535 L
s
P
p
.001 w
.02381 .10889 m
.02756 .10889 L
s
P
p
.001 w
.02381 .15598 m
.02756 .15598 L
s
P
p
.001 w
.02381 .17952 m
.02756 .17952 L
s
P
p
.001 w
.02381 .20307 m
.02756 .20307 L
s
P
p
.001 w
.02381 .22661 m
.02756 .22661 L
s
P
p
.001 w
.02381 .2737 m
.02756 .2737 L
s
P
p
.001 w
.02381 .29724 m
.02756 .29724 L
s
P
p
.001 w
.02381 .32079 m
.02756 .32079 L
s
P
p
.001 w
.02381 .34433 m
.02756 .34433 L
s
P
p
.001 w
.02381 .39142 m
.02756 .39142 L
s
P
p
.001 w
.02381 .41497 m
.02756 .41497 L
s
P
p
.001 w
.02381 .43851 m
.02756 .43851 L
s
P
p
.001 w
.02381 .46205 m
.02756 .46205 L
s
P
p
.001 w
.02381 .50914 m
.02756 .50914 L
s
P
p
.001 w
.02381 .53269 m
.02756 .53269 L
s
P
p
.001 w
.02381 .55623 m
.02756 .55623 L
s
P
p
.001 w
.02381 .57977 m
.02756 .57977 L
s
P
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
p
p
.02381 .01472 m
.02381 .01472 L
.07983 .01472 L
.07983 .01472 L
F
.07983 .01472 m
.07983 .01472 L
.13585 .01472 L
.13585 .01472 L
F
.13585 .01472 m
.13585 .01472 L
.19188 .01472 L
.19188 .01472 L
F
.19188 .01472 m
.19188 .60332 L
.2479 .60332 L
.2479 .01472 L
F
.2479 .01472 m
.2479 .01472 L
.30392 .01472 L
.30392 .01472 L
F
.30392 .01472 m
.30392 .01472 L
.35994 .01472 L
.35994 .01472 L
F
.35994 .01472 m
.35994 .01472 L
.41597 .01472 L
.41597 .01472 L
F
.41597 .01472 m
.41597 .01472 L
.47199 .01472 L
.47199 .01472 L
F
.47199 .01472 m
.47199 .01472 L
.52801 .01472 L
.52801 .01472 L
F
.52801 .01472 m
.52801 .01472 L
.58403 .01472 L
.58403 .01472 L
F
.58403 .01472 m
.58403 .01472 L
.64006 .01472 L
.64006 .01472 L
F
.64006 .01472 m
.64006 .01472 L
.69608 .01472 L
.69608 .01472 L
F
.69608 .01472 m
.69608 .01472 L
.7521 .01472 L
.7521 .01472 L
F
.7521 .01472 m
.7521 .01472 L
.80812 .01472 L
.80812 .01472 L
F
.80812 .01472 m
.80812 .01472 L
.86415 .01472 L
.86415 .01472 L
F
.86415 .01472 m
.86415 .60332 L
.92017 .60332 L
.92017 .01472 L
F
.92017 .01472 m
.92017 .01472 L
.97619 .01472 L
.97619 .01472 L
F
P
p
.004 w
.02381 .01472 m
.02381 .01472 L
.07983 .01472 L
.07983 .01472 L
s
.07983 .01472 m
.07983 .01472 L
.13585 .01472 L
.13585 .01472 L
s
.13585 .01472 m
.13585 .01472 L
.19188 .01472 L
.19188 .01472 L
s
.19188 .01472 m
.19188 .60332 L
.2479 .60332 L
.2479 .01472 L
s
.2479 .01472 m
.2479 .01472 L
.30392 .01472 L
.30392 .01472 L
s
.30392 .01472 m
.30392 .01472 L
.35994 .01472 L
.35994 .01472 L
s
.35994 .01472 m
.35994 .01472 L
.41597 .01472 L
.41597 .01472 L
s
.41597 .01472 m
.41597 .01472 L
.47199 .01472 L
.47199 .01472 L
s
.47199 .01472 m
.47199 .01472 L
.52801 .01472 L
.52801 .01472 L
s
.52801 .01472 m
.52801 .01472 L
.58403 .01472 L
.58403 .01472 L
s
.58403 .01472 m
.58403 .01472 L
.64006 .01472 L
.64006 .01472 L
s
.64006 .01472 m
.64006 .01472 L
.69608 .01472 L
.69608 .01472 L
s
.69608 .01472 m
.69608 .01472 L
.7521 .01472 L
.7521 .01472 L
s
.7521 .01472 m
.7521 .01472 L
.80812 .01472 L
.80812 .01472 L
s
.80812 .01472 m
.80812 .01472 L
.86415 .01472 L
.86415 .01472 L
s
.86415 .01472 m
.86415 .60332 L
.92017 .60332 L
.92017 .01472 L
s
.92017 .01472 m
.92017 .01472 L
.97619 .01472 L
.97619 .01472 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageRegion->{{-0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006W00011B000`400?l00000o`00003ooooooonX
ooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00G?ooool0
0ooMgMgo0000omgMg@06ooooo`03oiRHV?l0003oEEEE00Cooooo00Koc<c<ob4Q8Ol0003o0000oc8b
<_oMgMdOooooo`03oa0@4?l0003o000000;o000000?ogMgMooooooooool00_ooool01?mVIVKo0000
oc8b<_o^k^hKooooo`03oa0@4?l0003o000000;o000000CogMgMooooooooooooQhN71?l000000ol@
413oooooooooo`03ooooo`03oiRHV?l0003oEEEE00Cooooo00Koc<c<ob4Q8Ol0003o0000oc8b<_oM
gMdKooooo`03oa0@4?l0003o000000;o000000GogMgMooooooooooooc<c<ob4Q8@02o`000003oc8b
<_oMgMgooooo01[ooooo00?o410@o`000?l000000_l000000ooMgMgoooooooooo`02ooooo`03omgM
gOl0003ogMgM00Kooooo00?oV9RHo`000?mEEED01?ooool01_o<c<co8B4Qo`000?l0003o<S8bomgM
gA[ooooo00?oQhN7o`000?l000000_l000000ol@413oooooooooo`03ooooo`04ofIVI_l0003o<S8b
onk^kT3ooooo001Mooooo`03oc8b<_n7QhOooooo00Gooooo00?o<S8bo`000?l000001?ooool01_o<
c<coZJVYooooooooooooV9RHob4Q8B7ooooo00?o0000ooooooooool01?ooool2ohN7Q`03oooooon7
QhOoA4A401gooooo00?o0000ooooooooool00oooool00oo^k^ko<S8bolc<c008ooooo`03oc8b<_l0
003o000000Cooooo00Koc<c<ojVYZOoooooooooooiRHV?lQ8B4Mooooo`03o`000?oooooooooo00?o
oooo00Koc<c<ojVYZOoooooooooooiRHV?lQ8B4Mooooo`03o`000?oooooooooo00Kooooo00?o<S8b
ohN7Qoooool01Oooool00olb<S;o0000o`000004ooooo`06olc<c?nYZJWooooooooooonHV9So8B4Q
6_ooool00oo^k^ko<S8bolc<c007ooooo`;oQhN700?oooooohN7Qom4A4@0@?ooool005gooooo00?o
V9RHob4Q8Oooool01Oooool00onYZJWo8B4QogMgM`09ooooo`03ob4Q8Onj^[[ooooo01oooooo00?o
0000ooooooooool01?ooool01Olb<S;ooooooooooooooooo000001gooooo00?o0000ooooooooool0
1?ooool00oo^k^ko<S8bojVYZ@07ooooo`03ojVYZOlQ8B7oMgMg00Wooooo00?o8B4QokZj^_ooool0
6oooool00ol0003oooooooooo`08ooooo`03ob4Q8Onj^[[ooooo01_ooooo00?o0000ooooooooool0
1_ooool00onHV9So8B4Qooooo`05ooooo`03ojVYZOlQ8B7oMgMg00Wooooo00?o8B4QokZj^_ooool0
6Oooool00oo^k^ko<S8bojVYZ@06ooooo`05oc8b<_ooooooooooooooool00000@?ooool005gooooo
00?ok^k^o`000?o<c<`04Oooool00olQ8B7o^[Zjooooo`0Oooooo`03o`000?oooooooooo00Cooooo
00Ko<S8boooooooooooooooooc8b<_nj^[XLooooo`03o`000?oooooooooo00Gooooo00?ok^k^ob4Q
8OnHV9P04_ooool00olQ8B7o^[Zjooooo`0Kooooo`03o`000?oooooooooo00Sooooo00?o8B4QokZj
^_ooool06oooool00ol0003oooooooooo`06ooooo`03onk^k_l0003oc<c<017ooooo00?o8B4QokZj
^_ooool06_ooool00oo^k^ko8B4QoiRHV005ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj?ooo
ool005kooooo00?oEEEEofIVI_ooool03?ooool01OmVIVKogMgMoooooon7QhOo410@027ooooo00?o
0000ooooooooool01?ooool01_lb<S;ooooooooooooooooo<S8bokZj^Qcooooo00?o0000oooooooo
ool01_ooool00oo^k^ko<S8bolc<c00=ooooo`05ofIVI_oMgMgoooooohN7Qol@41007Oooool00ol0
003oooooooooo`04ooooo`05ofIVI_oMgMgoooooohN7Qol@41007Oooool00ol0003oooooooooo`07
ooooo`03oeEEEOmVIVKooooo00cooooo00GoIVIVomgMgOooooooQhN7oa0@400Mooooo`03onk^k_lb
<S;oc<c<00Cooooo00Ko<S8boooooooooooooooooc8b<_nj^[Xoooooo`00G_ooool00onj^[[o410@
ooooo`0<ooooo`05o`000?lQ8B7o0000oa0@4?o<c<`08Oooool00ol0003oooooooooo`04ooooo`06
oc8b<_oooooooooooooooolb<S;o^[Zj7?ooool00ol0003oooooooooo`07ooooo`03onk^k_m4A4Co
oooo00cooooo00Go0000ob4Q8Ol0003o410@olc<c00Mooooo`03o`000?oooooooooo00Cooooo00Go
0000ob4Q8Ol0003o410@olc<c00Mooooo`03o`000?oooooooooo00Oooooo00?o^[Zjoa0@4?ooool0
3?ooool01Ol0003o8B4Qo`000?l@413oc<c<01kooooo00?ok^k^odA4A?ooool00oooool01_lb<S;o
oooooooooooooooo<S8bokZj^Soooooo001Oooooo`03oa0@4?o<c<cooooo00_ooooo00?o0000oooo
ooooool08oooool00ol0003oooooooooo`04ooooo`05oc8b<_o^k^koooooonk^k_l000007Oooool0
0ol0003oooooooooo`04ooooo`05okZj^_oooooooooooooooolb<S803Oooool00ol0003ooooooooo
o`0Oooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool07oooool00ol0003ooooooooo
o`08ooooo`03oa0@4?o<c<cooooo00_ooooo00?o0000ooooooooool07Oooool01Onj^[[ooooooooo
oooooooo<S8b00Cooooo00Go<S8bonk^k_ooooook^k^o`000010ooooo`00Goooool00on7QhOoIVIV
ooooo`0;ooooo`03o`000?oooooooooo027ooooo00?oQhN7okZj^_l000001_ooool01On7QhOoIVIV
oooooomVIVKoA4A401_ooooo00?oQhN7okZj^_l000001Oooool01_o<c<co0000ohN7Qooooooo^[Zj
ob4Q8@gooooo00?o0000ooooooooool07Oooool00on7QhOo^[Zjo`000006ooooo`03o`000?oooooo
oooo01gooooo00?oQhN7okZj^_l000002_ooool00on7QhOoIVIVooooo`0;ooooo`03o`000?oooooo
oooo01cooooo00Koc<c<o`000?n7QhOooooookZj^_lQ8B44ooooo`05ohN7QomVIVKoooooofIVI_m4
A4@0@?ooool005_ooooo1Ol000000olb<S;oooooooooo`0:ooooo`Co000000?o410@ooooooooool0
7Oooool00on7QhOo<S8bo`000007ooooo`04ofIVI_l0003o<S8bonk^kQ_ooooo00?oQhN7oc8b<_l0
00001_ooool01OnYZJWo8B4Qo`000?l@413oc<c<00gooooo1?l000000ol@413oooooooooo`0Ioooo
o`03ohN7Qolb<S;o000000Kooooo1?l000000ol@413oooooooooo`0Iooooo`03ohN7Qolb<S;o0000
00Kooooo1Ol000000olb<S;oooooooooo`0:ooooo`Co000000?o410@ooooooooool06Oooool01OnY
ZJWo8B4Qo`000?l@413oc<c<00Gooooo00CoIVIVo`000?lb<S;ok^k^@?ooool00?ooooooZ?ooool0
0?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool003Cooooo00?o0000ooooooooool0oooo
oomaooooo`00=?ooool00ol0003oooooooooo`3oooooog7ooooo000dooooo`03o`000?oooooooooo
0?ooooooLOooool003Cooooo00?o0000ooooooooool0oooooomaooooo`00=?ooool00ol0003ooooo
ooooo`3oooooog7ooooo000/oooooooo0000I_l0000Fooooo`00=?ooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01ooooolEo`0000Wooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo5Ol00009
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool07?ooool003Cooooo00?o0000oooo
ooooool0;oooool00ol0003oooooooooo`07oooooaGo00004oooool00ol0003oooooooooo`0_oooo
o`03o`000?oooooooooo02oooooo00?o0000ooooooooool0;oooool00ol0003oooooooooo`0_oooo
oaGo0000<_ooool003Cooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`00
=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`03o`000?oo
oooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o0000ooooooooool0>OoooolE
o`000=_ooooo5Ol0000booooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`00
03;ooooo000dooooo`;o0000>_oooolEo`000=_ooooo5Ol0000booooo`00=?ooool00ol0003ooooo
ooooo`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`03o`000?oooooooooo03Wooooo5Ol0
003KoooooaGo0000<_ooool003Cooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000b
ooooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`03
o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o0000ooooooooool0
>OoooolEo`000=_ooooo5Ol0000booooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooo
oolEo`0003;ooooo000dooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool0
03Cooooo0_l0000joooooaGo0000fooooolEo`0003;ooooo000dooooo`03o`000?oooooooooo03Wo
oooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo
5Ol0000booooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000d
ooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o0000oooo
ooooool0>OoooolEo`000=_ooooo5Ol0000booooo`00=?ooool00ol0003oooooooooo`0ioooooaGo
0000fooooolEo`0003;ooooo000dooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000
<_ooool003Cooooo0_l0000joooooaGo0000fooooolEo`0003;ooooo000dooooo`03o`000?oooooo
oooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o0000ooooooooool0>OoooolEo`00
0=_ooooo5Ol0000booooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;o
oooo000dooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o
0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`00=?ooool00ol0003oooooooooo`0i
oooooaGo0000fooooolEo`0003;ooooo000dooooo`03o`000?oooooooooo03Wooooo5Ol0003Koooo
oaGo0000<_ooool003Cooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`00
=?ooool2o`0003[ooooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o0000ooooooooool0>Ooo
oolEo`000=_ooooo5Ol0000booooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolE
o`0003;ooooo000dooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Co
oooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`006?ooool01?mVIVKo0000
oc8b<_o^k^h5ooooo`03oiRHV?l0003oEEEE00Gooooo00?o410@o`000?l000000_l000000ooMgMgo
ooooooooo`03ooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool001Oooooo
0_n7QhL00oooooooQhN7odA4A005ooooo`03oc8b<_l0003o000000Oooooo00?o0000ooooooooool0
1_ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000Gooooo`05oc8b<_oo
ooooooooooooool000001Oooool00onYZJWo8B4QogMgM`07ooooo`03o`000?oooooooooo00Kooooo
00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`005oooool01_lb<S;ooooooooo
oooooooo<S8bokZj^Pkooooo00?o0000ooooooooool01_ooool3o`0003Wooooo5Ol0003KoooooaGo
0000<_ooool001Oooooo00Ko<S8boooooooooooooooooc8b<_nj^[X>ooooo`03o`000?oooooooooo
00Kooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`005oooool01_lb<S;o
oooooooooooooooo<S8bokZj^Pkooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0i
oooooaGo0000fooooolEo`0003;ooooo000Gooooo`05oc8b<_o^k^koooooonk^k_l000003oooool0
0ol0003oooooooooo`06ooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool0
01Oooooo00GoQhN7ofIVI_ooooooIVIVodA4A00=ooooo`03ohN7Qonj^[[o000000Sooooo00?o0000
ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`006?ooool01?mVIVKo0000oc8b<_o^k^h=
ooooo`03ohN7Qolb<S;o000000Sooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000b
ooooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`03
o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Cooooo0_l0000joooooaGo0000
fooooolEo`0003;ooooo000dooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_oo
ool003Cooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`00=?ooool00ol0
003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`03o`000?oooooooooo03Wo
oooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo
5Ol0000booooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000d
ooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o0000oooo
ooooool0>OoooolEo`000=_ooooo5Ol0000booooo`00=?ooool2o`0003[ooooo5Ol0003KoooooaGo
0000<_ooool003Cooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`00=?oo
ool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`03o`000?oooooo
oooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o0000ooooooooool0>OoooolEo`00
0=_ooooo5Ol0000booooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;o
oooo000dooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o
0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`00=?ooool2o`0003[ooooo5Ol0003K
oooooaGo0000<_ooool003Cooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000boooo
o`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`03o`00
0?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o0000ooooooooool0>Ooo
oolEo`000=_ooooo5Ol0000booooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolE
o`0003;ooooo000dooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Co
oooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`00=?ooool00ol0003ooooo
ooooo`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`;o0000>_oooolEo`000=_ooooo5Ol0
000booooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000doooo
o`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o0000oooooooo
ool0>OoooolEo`000=_ooooo5Ol0000booooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000
fooooolEo`0003;ooooo000Hooooo`04ofIVI_l0003o<S8bonk^kPGooooo00?oV9RHo`000?mEEED0
1?ooool00on7QhOo0000o`000002o`000003oa0@4?oooooooooo00Cooooo00?o0000ooooooooool0
>OoooolEo`000=_ooooo5Ol0000booooo`005oooool2ohN7Q`03oooooon7QhOoA4A400Gooooo00?o
<S8bo`000?l000001?ooool00oo^k^ko<S8bolc<c009ooooo`03o`000?oooooooooo03Wooooo5Ol0
003KoooooaGo0000<_ooool001Oooooo00Go<S8booooooooooooooooo`000005ooooo`03ojVYZOlQ
8B7oMgMg00Gooooo00?ok^k^oc8b<_nYZJT02?ooool00ol0003oooooooooo`0ioooooaGo0000fooo
oolEo`0003;ooooo000Gooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj3Oooool00oo^k^ko8B4Q
oiRHV007ooooo`?o0000>OoooolEo`000=_ooooo5Ol0000booooo`005oooool01_lb<S;ooooooooo
oooooooo<S8bokZj^Pkooooo00?ok^k^oc8b<_o<c<`01_ooool00ol0003oooooooooo`0ioooooaGo
0000fooooolEo`0003;ooooo000Gooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj3oooool00oo^
k^koA4A4ooooo`05ooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool001Oo
oooo00Go<S8bonk^k_ooooook^k^o`00000=ooooo`05okZj^_oooooooooooooooolb<S801_ooool0
0ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000Gooooo`05ohN7QomVIVKooooo
ofIVI_m4A4@03?ooool01_o<c<co0000ohN7Qooooooo^[Zjob4Q8@Kooooo00?o0000ooooooooool0
>OoooolEo`000=_ooooo5Ol0000booooo`006?ooool01?mVIVKo0000oc8b<_o^k^h=ooooo`05ojVY
ZOlQ8B7o0000oa0@4?o<c<`01_ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;o
oooo000dooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o
0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`00=?ooool2o`0003[ooooo5Ol0003K
oooooaGo0000<_ooool003Cooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000boooo
o`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`03o`00
0?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o0000ooooooooool0>Ooo
oolEo`000=_ooooo5Ol0000booooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolE
o`0003;ooooo000dooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Co
oooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`00=?ooool00ol0003ooooo
ooooo`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`;o0000>_oooolEo`000=_ooooo5Ol0
000booooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000doooo
o`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o0000oooooooo
ool0>OoooolEo`000=_ooooo5Ol0000booooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000
fooooolEo`0003;ooooo000dooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_oo
ool003Cooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`00=?ooool00ol0
003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`;o0000>_oooolEo`000=_o
oooo5Ol0000booooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo
000dooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o0000
ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`00=?ooool00ol0003oooooooooo`0ioooo
oaGo0000fooooolEo`0003;ooooo000dooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo
0000<_ooool003Cooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`00=?oo
ool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`;o0000>_oooolE
o`000=_ooooo5Ol0000booooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`00
03;ooooo000dooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Cooooo
00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`00=?ooool00ol0003ooooooooo
o`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`03o`000?oooooooooo03Wooooo5Ol0003K
oooooaGo0000<_ooool001Sooooo00CoIVIVo`000?lb<S;ok^k^1Oooool00onHV9So0000oeEEE@04
ooooo`06okZj^_m4A4Co0000o`000?lQ8B7oc<c<1_ooool00ol0003oooooooooo`0ioooooaGo0000
fooooolEo`0003;ooooo000Gooooo`;oQhN700?oooooohN7Qom4A4@01Oooool00olb<S;o0000o`00
0004ooooo`07ojVYZOnHV9Sooooooooooonj^[[o0000onk^kP05ooooo`03o`000?oooooooooo03Wo
oooo5Ol0003KoooooaGo0000<_ooool001Oooooo00Go<S8booooooooooooooooo`000005ooooo`03
ojVYZOlQ8B7oMgMg00Wooooo00?o<S8bokZj^_ooool01?ooool00ol0003oooooooooo`0ioooooaGo
0000fooooolEo`0003;ooooo000Gooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj3oooool00oo^
k^ko0000omgMg@05ooooo`?o0000>OoooolEo`000=_ooooo5Ol0000booooo`005oooool01_lb<S;o
oooooooooooooooo<S8bokZj^Pkooooo00?oIVIVoa0@4?n7QhL01_ooool00ol0003oooooooooo`0i
oooooaGo0000fooooolEo`0003;ooooo000Gooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj3_oo
ool00ooMgMgoMgMgofIVIP06ooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_oo
ool001Oooooo00Go<S8bonk^k_ooooook^k^o`00000Aooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`005oooool01On7QhOoIVIVoooooomV
IVKoA4A400gooooo00GoA4A4okZj^_ooooooV9RHoa0@4006ooooo`03o`000?oooooooooo03Wooooo
5Ol0003KoooooaGo0000<_ooool001Sooooo00CoIVIVo`000?lb<S;ok^k^3Oooool01On7QhOo410@
o`000?l@413oc<c<00Kooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`00
=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`03o`000?oo
oooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Cooooo0_l0000joooooaGo0000fooooolE
o`0003;ooooo000dooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Co
oooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`00=?ooool00ol0003ooooo
ooooo`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`03o`000?oooooooooo03Wooooo5Ol0
003KoooooaGo0000<_ooool003Cooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000b
ooooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`03
o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o0000ooooooooool0
>OoooolEo`000=_ooooo5Ol0000booooo`00=?ooool2o`0003[ooooo5Ol0003KoooooaGo0000<_oo
ool003Cooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`00=?ooool00ol0
003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`03o`000?oooooooooo03Wo
oooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo
5Ol0000booooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000d
ooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o0000oooo
ooooool0>OoooolEo`000=_ooooo5Ol0000booooo`00=?ooool2o`0003[ooooo5Ol0003KoooooaGo
0000<_ooool003Cooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`00=?oo
ool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`03o`000?oooooo
oooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o0000ooooooooool0>OoooolEo`00
0=_ooooo5Ol0000booooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;o
oooo000dooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o
0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`00=?ooool2o`0003[ooooo5Ol0003K
oooooaGo0000<_ooool003Cooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000boooo
o`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`03o`00
0?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o0000ooooooooool0>Ooo
oolEo`000=_ooooo5Ol0000booooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolE
o`0003;ooooo000Hooooo`04ofIVI_l0003o<S8bonk^kPGooooo00?oV9RHo`000?mEEED01oooool3
o`0000Kooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`005oooool2ohN7
Q`03oooooon7QhOoA4A400Gooooo00?o<S8bo`000?l000002?ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool001Oooooo00Go<S8boooooooo
ooooooooo`000005ooooo`03ojVYZOlQ8B7oMgMg00Cooooo00?o<S8bo`000?l000000ol00006oooo
o`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool001Oooooo00Ko<S8boooooooo
oooooooooc8b<_nj^[X;ooooo`06oeEEEOmgMgOoooooooooool0003ogMgM1_ooool3o`0003Wooooo
5Ol0003KoooooaGo0000<_ooool001Oooooo00Ko<S8boooooooooooooooooc8b<_nj^[X;ooooo`05
onk^k_l0003ogMgMooooool000001oooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`00
03;ooooo000Gooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj3?ooool01?nHV9SoA4A4ooooool0
0007ooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool001Oooooo00Go<S8b
onk^k_ooooook^k^o`00000>ooooo`03oc8b<_nj^[[o000000Oooooo00?o0000ooooooooool0>Ooo
oolEo`000=_ooooo5Ol0000booooo`005oooool01On7QhOoIVIVoooooomVIVKoA4A400kooooo00?o
c<c<ob4Q8Ol000001oooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000H
ooooo`04ofIVI_l0003o<S8bonk^kPoooooo00?oIVIVo`000?ooool01_ooool00ol0003ooooooooo
o`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`03o`000?oooooooooo03Wooooo5Ol0003K
oooooaGo0000<_ooool003Cooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000boooo
o`00=?ooool2o`0003[ooooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o0000ooooooooool0
>OoooolEo`000=_ooooo5Ol0000booooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooo
oolEo`0003;ooooo000dooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool0
03Cooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`00=?ooool00ol0003o
ooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`03o`000?oooooooooo03Wooooo
5Ol0003KoooooaGo0000<_ooool003Cooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0
000booooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000doooo
o`;o0000>_oooolEo`000=_ooooo5Ol0000booooo`00=?ooool00ol0003oooooooooo`0ioooooaGo
0000fooooolEo`0003;ooooo000dooooo`03o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000
<_ooool003Cooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`00=?ooool0
0ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`03o`000?oooooooooo
03Wooooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o0000ooooooooool0>OoooolEo`000=_o
oooo5Ol0000booooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo
000dooooo`;o0000>_oooolEo`000=_ooooo5Ol0000booooo`00=?ooool00ol0003oooooooooo`0i
oooooaGo0000fooooolEo`0003;ooooo000dooooo`03o`000?oooooooooo03Wooooo5Ol0003Koooo
oaGo0000<_ooool003Cooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`00
=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`03o`000?oo
oooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool003Cooooo00?o0000ooooooooool0>OoooolE
o`000=_ooooo5Ol0000booooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`00
03;ooooo000dooooo`;o0000>_oooolEo`000=_ooooo5Ol0000booooo`00=?ooool00ol0003ooooo
ooooo`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`03o`000?oooooooooo03Wooooo5Ol0
003KoooooaGo0000<_ooool003Cooooo00?o0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000b
ooooo`00=?ooool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000dooooo`03
o`000?oooooooooo03Wooooo5Ol0003KoooooaGo0000<_ooool001Sooooo00CoIVIVo`000?lb<S;o
k^k^1Oooool00onHV9So0000oeEEE@04ooooo`06olc<c?lQ8B7o0000o`000?lb<S;ogMgM1_ooool0
0ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000Gooooo`;oQhN700?oooooohN7
Qom4A4@01Oooool00olb<S;o0000o`000004ooooo`06olc<c?nYZJWooooooooooonHV9So8B4Q1_oo
ool00ol0003oooooooooo`0ioooooaGo0000fooooolEo`0003;ooooo000Gooooo`05oc8b<_oooooo
ooooooooool000001Oooool00onYZJWo8B4QogMgM`09ooooo`03ob4Q8Onj^[[ooooo00Cooooo00?o
0000ooooooooool0>OoooolEo`000=_ooooo5Ol0000booooo`005oooool01_lb<S;ooooooooooooo
oooo<S8bokZj^Q3ooooo00?o8B4QokZj^_ooool01?ooool3o`0003Wooooo5Ol0003KoooooaGo0000
<_ooool001Oooooo00Ko<S8boooooooooooooooooc8b<_nj^[X<ooooo`05ofIVI_oMgMgoooooohN7
Qol@41001_ooool00ol0003oooooooooo`3oooooog7ooooo000Gooooo`06oc8b<_oooooooooooooo
oolb<S;o^[Zj3?ooool01Ol0003o8B4Qo`000?l@413oc<c<00Kooooo00?o0000ooooooooool0oooo
oomaooooo`005oooool01Olb<S;ok^k^ooooooo^k^ko000000gooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`3oooooog7ooooo000Gooooo`05ohN7QomVIVKoooooofIVI_m4A4@03Ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo0?ooooooLOooool001Sooooo00CoIVIV
o`000?lb<S;ok^k^3Oooool4o`000003oa0@4?oooooooooo00Cooooo00?o0000ooooooooool0oooo
oomaooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooo
oonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00j?ooool3o`000003oc8b
<_oooooooooo0;Wooooo003Xooooo`03okZj^_l0003ooooo0;cooooo003Xooooo`03okZj^_l0003o
oooo0;cooooo003>ooooo`06ofIVI_l0003o0000ob4Q8OmgMgOok^k^0oooool01_n7QhOo410@o`00
0?l0003oIVIVonk^kP?ooooo00KoQhN7oa0@4?l0003o0000ofIVI_o^k^h2ooooo`03okZj^_l0003o
V9RH00;o000000?oIVIVooooooooool0]oooool00<gooooo00OoMgMgoeEEEOooooooooooomgMgOlQ
8B7oMgMg00;ooooo00OoQhN7oeEEEOo^k^koooooonk^k_mEEEGoA4A400;ooooo00OoQhN7oeEEEOo^
k^koooooonk^k_mEEEGoA4A400;ooooo00?o^[Zjo`000?mgMgL00_ooool2ogMgMkSooooo003=oooo
o`03ob4Q8Ooooooooooo00Kooooo00?o8B4Qooooooooool00oooool01?l0003ogMgMoooooolQ8B45
ooooo`05o`000?oMgMgooooookZj^_l@41001?ooool00olQ8B7oooooooooo`2fooooo`00cOooool0
0olb<S;oooooooooo`06ooooo`03oc8b<_oooooooooo00?ooooo00Co<S8bokZj^_oooooo<S8b1Ooo
ool01Olb<S;o^[Zjoooooonj^[[o<S8b00Cooooo00?o<S8booooooooool0]_ooool00<gooooo00?o
8B4Qooooooooool00_ooool01OmgMgOoV9RHoooooooooooo8B4Q00Gooooo00Co0000omgMgOoooooo
8B4Q1Oooool01_l0003ogMgMoooooonj^[[o0000onk^kP;ooooo00?ok^k^ob4Q8Oooool0]oooool0
0<gooooo00OoMgMgoeEEEOo^k^kooooookZj^_l0003oMgMg00;ooooo00GoQhN7oeEEEOo^k^kooooo
onk^kP02oeEEE@;ooooo00GoQhN7oeEEEOo^k^koooooonk^kP02oeEEE@;ooooo00?o^[Zjo`000?m4
A4@00_oMgMd00om4A4CoMgMgooooo`2gooooo`00c_ooool00omVIVKo0000o`000002ob4Q8@06ogMg
Mooooooooooooooooon7QhOo410@0_l000000omgMgOoooooooooo`02ooooo`05ohN7Qol@413o0000
o`000?mgMgL00oooool00ol@413o0000ogMgM`02o`000003ofIVI_oooooooooo0;Oooooo003ooooo
ojSooooo003oooooojSooooo003oooooojSooooo003oooooojSooooo0000\
\>"],
  ImageRangeCache->{{{0, 422}, {260, 0}} -> {2.36484, -0.0536318, 0.0751339, \
0.00357556}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["wdistribution[ss,frand[0.5],1,0,5,22,1,\"rand\"];", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
{17, 1, 8}
binned...
top summed...
Average is 12.475\
\>", "Print",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.256303 0.0560224 0.0147151 2.35442 [
[(7.5)] .16387 .01472 0 2 Msboxa
[(10)] .30392 .01472 0 2 Msboxa
[(12.5)] .44398 .01472 0 2 Msboxa
[(15)] .58403 .01472 0 2 Msboxa
[(17.5)] .72409 .01472 0 2 Msboxa
[(20)] .86415 .01472 0 2 Msboxa
[(rand)] .5 .61803 0 -2 Msboxa
[(0.05)] .01131 .13244 1 0 Msboxa
[(0.1)] .01131 .25016 1 0 Msboxa
[(0.15)] .01131 .36788 1 0 Msboxa
[(0.2)] .01131 .4856 1 0 Msboxa
[(0.25)] .01131 .60332 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.16387 .01472 m
.16387 .02097 L
s
P
[(7.5)] .16387 .01472 0 2 Mshowa
p
.002 w
.30392 .01472 m
.30392 .02097 L
s
P
[(10)] .30392 .01472 0 2 Mshowa
p
.002 w
.44398 .01472 m
.44398 .02097 L
s
P
[(12.5)] .44398 .01472 0 2 Mshowa
p
.002 w
.58403 .01472 m
.58403 .02097 L
s
P
[(15)] .58403 .01472 0 2 Mshowa
p
.002 w
.72409 .01472 m
.72409 .02097 L
s
P
[(17.5)] .72409 .01472 0 2 Mshowa
p
.002 w
.86415 .01472 m
.86415 .02097 L
s
P
[(20)] .86415 .01472 0 2 Mshowa
p
.001 w
.05182 .01472 m
.05182 .01847 L
s
P
p
.001 w
.07983 .01472 m
.07983 .01847 L
s
P
p
.001 w
.10784 .01472 m
.10784 .01847 L
s
P
p
.001 w
.13585 .01472 m
.13585 .01847 L
s
P
p
.001 w
.19188 .01472 m
.19188 .01847 L
s
P
p
.001 w
.21989 .01472 m
.21989 .01847 L
s
P
p
.001 w
.2479 .01472 m
.2479 .01847 L
s
P
p
.001 w
.27591 .01472 m
.27591 .01847 L
s
P
p
.001 w
.33193 .01472 m
.33193 .01847 L
s
P
p
.001 w
.35994 .01472 m
.35994 .01847 L
s
P
p
.001 w
.38796 .01472 m
.38796 .01847 L
s
P
p
.001 w
.41597 .01472 m
.41597 .01847 L
s
P
p
.001 w
.47199 .01472 m
.47199 .01847 L
s
P
p
.001 w
.5 .01472 m
.5 .01847 L
s
P
p
.001 w
.52801 .01472 m
.52801 .01847 L
s
P
p
.001 w
.55602 .01472 m
.55602 .01847 L
s
P
p
.001 w
.61204 .01472 m
.61204 .01847 L
s
P
p
.001 w
.64006 .01472 m
.64006 .01847 L
s
P
p
.001 w
.66807 .01472 m
.66807 .01847 L
s
P
p
.001 w
.69608 .01472 m
.69608 .01847 L
s
P
p
.001 w
.7521 .01472 m
.7521 .01847 L
s
P
p
.001 w
.78011 .01472 m
.78011 .01847 L
s
P
p
.001 w
.80812 .01472 m
.80812 .01847 L
s
P
p
.001 w
.83613 .01472 m
.83613 .01847 L
s
P
p
.001 w
.89216 .01472 m
.89216 .01847 L
s
P
p
.001 w
.92017 .01472 m
.92017 .01847 L
s
P
p
.001 w
.94818 .01472 m
.94818 .01847 L
s
P
p
.001 w
.97619 .01472 m
.97619 .01847 L
s
P
p
.002 w
0 .01472 m
1 .01472 L
s
P
[(rand)] .5 .61803 0 -2 Mshowa
p
.002 w
.02381 .13244 m
.03006 .13244 L
s
P
[(0.05)] .01131 .13244 1 0 Mshowa
p
.002 w
.02381 .25016 m
.03006 .25016 L
s
P
[(0.1)] .01131 .25016 1 0 Mshowa
p
.002 w
.02381 .36788 m
.03006 .36788 L
s
P
[(0.15)] .01131 .36788 1 0 Mshowa
p
.002 w
.02381 .4856 m
.03006 .4856 L
s
P
[(0.2)] .01131 .4856 1 0 Mshowa
p
.002 w
.02381 .60332 m
.03006 .60332 L
s
P
[(0.25)] .01131 .60332 1 0 Mshowa
p
.001 w
.02381 .03826 m
.02756 .03826 L
s
P
p
.001 w
.02381 .0618 m
.02756 .0618 L
s
P
p
.001 w
.02381 .08535 m
.02756 .08535 L
s
P
p
.001 w
.02381 .10889 m
.02756 .10889 L
s
P
p
.001 w
.02381 .15598 m
.02756 .15598 L
s
P
p
.001 w
.02381 .17952 m
.02756 .17952 L
s
P
p
.001 w
.02381 .20307 m
.02756 .20307 L
s
P
p
.001 w
.02381 .22661 m
.02756 .22661 L
s
P
p
.001 w
.02381 .2737 m
.02756 .2737 L
s
P
p
.001 w
.02381 .29724 m
.02756 .29724 L
s
P
p
.001 w
.02381 .32079 m
.02756 .32079 L
s
P
p
.001 w
.02381 .34433 m
.02756 .34433 L
s
P
p
.001 w
.02381 .39142 m
.02756 .39142 L
s
P
p
.001 w
.02381 .41497 m
.02756 .41497 L
s
P
p
.001 w
.02381 .43851 m
.02756 .43851 L
s
P
p
.001 w
.02381 .46205 m
.02756 .46205 L
s
P
p
.001 w
.02381 .50914 m
.02756 .50914 L
s
P
p
.001 w
.02381 .53269 m
.02756 .53269 L
s
P
p
.001 w
.02381 .55623 m
.02756 .55623 L
s
P
p
.001 w
.02381 .57977 m
.02756 .57977 L
s
P
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
p
1 g
p
.02381 .01472 m
.02381 .01472 L
.07983 .01472 L
.07983 .01472 L
F
.07983 .01472 m
.07983 .01472 L
.13585 .01472 L
.13585 .01472 L
F
.13585 .01472 m
.13585 .01472 L
.19188 .01472 L
.19188 .01472 L
F
.19188 .01472 m
.19188 .30902 L
.2479 .30902 L
.2479 .01472 L
F
.2479 .01472 m
.2479 .30902 L
.30392 .30902 L
.30392 .01472 L
F
.30392 .01472 m
.30392 .60332 L
.35994 .60332 L
.35994 .01472 L
F
.35994 .01472 m
.35994 .01472 L
.41597 .01472 L
.41597 .01472 L
F
.41597 .01472 m
.41597 .30902 L
.47199 .30902 L
.47199 .01472 L
F
.47199 .01472 m
.47199 .30902 L
.52801 .30902 L
.52801 .01472 L
F
.52801 .01472 m
.52801 .01472 L
.58403 .01472 L
.58403 .01472 L
F
.58403 .01472 m
.58403 .30902 L
.64006 .30902 L
.64006 .01472 L
F
.64006 .01472 m
.64006 .01472 L
.69608 .01472 L
.69608 .01472 L
F
.69608 .01472 m
.69608 .01472 L
.7521 .01472 L
.7521 .01472 L
F
.7521 .01472 m
.7521 .01472 L
.80812 .01472 L
.80812 .01472 L
F
.80812 .01472 m
.80812 .01472 L
.86415 .01472 L
.86415 .01472 L
F
.86415 .01472 m
.86415 .30902 L
.92017 .30902 L
.92017 .01472 L
F
.92017 .01472 m
.92017 .01472 L
.97619 .01472 L
.97619 .01472 L
F
P
0 g
p
.004 w
.02381 .01472 m
.02381 .01472 L
.07983 .01472 L
.07983 .01472 L
s
.07983 .01472 m
.07983 .01472 L
.13585 .01472 L
.13585 .01472 L
s
.13585 .01472 m
.13585 .01472 L
.19188 .01472 L
.19188 .01472 L
s
.19188 .01472 m
.19188 .30902 L
.2479 .30902 L
.2479 .01472 L
s
.2479 .01472 m
.2479 .30902 L
.30392 .30902 L
.30392 .01472 L
s
.30392 .01472 m
.30392 .60332 L
.35994 .60332 L
.35994 .01472 L
s
.35994 .01472 m
.35994 .01472 L
.41597 .01472 L
.41597 .01472 L
s
.41597 .01472 m
.41597 .30902 L
.47199 .30902 L
.47199 .01472 L
s
.47199 .01472 m
.47199 .30902 L
.52801 .30902 L
.52801 .01472 L
s
.52801 .01472 m
.52801 .01472 L
.58403 .01472 L
.58403 .01472 L
s
.58403 .01472 m
.58403 .30902 L
.64006 .30902 L
.64006 .01472 L
s
.64006 .01472 m
.64006 .01472 L
.69608 .01472 L
.69608 .01472 L
s
.69608 .01472 m
.69608 .01472 L
.7521 .01472 L
.7521 .01472 L
s
.7521 .01472 m
.7521 .01472 L
.80812 .01472 L
.80812 .01472 L
s
.80812 .01472 m
.80812 .01472 L
.86415 .01472 L
.86415 .01472 L
s
.86415 .01472 m
.86415 .30902 L
.92017 .30902 L
.92017 .01472 L
s
.92017 .01472 m
.92017 .01472 L
.97619 .01472 L
.97619 .01472 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageRegion->{{-0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006W00011B000`400?l00000o`00003ooooooonX
ooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00H?ooool0
0ooMgMgo0000omgMg@06ooooo`03oiRHV?l0003oEEEE00Cooooo00Koc<c<ob4Q8Ol0003o0000oc8b
<_oMgMdOooooo`03oa0@4?l0003o000000;o000000?ogMgMooooooooool00_ooool01?mVIVKo0000
oc8b<_o^k^hKooooo`03oa0@4?l0003o000000;o000000CogMgMooooooooooooQhN71?l000000ol@
413oooooooooo`03ooooo`03oiRHV?l0003oEEEE00Cooooo00Koc<c<ob4Q8Ol0003o0000oc8b<_oM
gMdKooooo`03oa0@4?l0003o000000;o000000GogMgMooooooooooooc<c<ob4Q8@02o`000003oc8b
<_oMgMgooooo01[ooooo00?o410@o`000?l000000_l000000ooMgMgoooooooooo`02ooooo`03omgM
gOl0003ogMgM00Kooooo00?oV9RHo`000?mEEED01?ooool01_o<c<co8B4Qo`000?l0003o<S8bomgM
gA[ooooo00?oQhN7o`000?l000000_l000000ol@413oooooooooo`03ooooo`04ofIVI_l0003o<S8b
onk^kScooooo001Qooooo`03oc8b<_n7QhOooooo00Gooooo00?o<S8bo`000?l000001?ooool01_o<
c<coZJVYooooooooooooV9RHob4Q8B7ooooo00?o0000ooooooooool01?ooool2ohN7Q`03oooooon7
QhOoA4A401gooooo00?o0000ooooooooool00oooool00oo^k^ko<S8bolc<c008ooooo`03oc8b<_l0
003o000000Cooooo00Koc<c<ojVYZOoooooooooooiRHV?lQ8B4Mooooo`03o`000?oooooooooo00?o
oooo00Koc<c<ojVYZOoooooooooooiRHV?lQ8B4Mooooo`03o`000?oooooooooo00Kooooo00?o<S8b
ohN7Qoooool01Oooool00olb<S;o0000o`000004ooooo`06olc<c?nYZJWooooooooooonHV9So8B4Q
6_ooool00oo^k^ko<S8bolc<c007ooooo`;oQhN700?oooooohN7Qom4A4@0??ooool0067ooooo00?o
V9RHob4Q8Oooool01Oooool00onYZJWo8B4QogMgM`09ooooo`03ob4Q8Onj^[[ooooo01oooooo00?o
0000ooooooooool01?ooool01Olb<S;ooooooooooooooooo000001gooooo00?o0000ooooooooool0
1?ooool00oo^k^ko<S8bojVYZ@07ooooo`03ojVYZOlQ8B7oMgMg00Wooooo00?o8B4QokZj^_ooool0
6oooool00ol0003oooooooooo`08ooooo`03ob4Q8Onj^[[ooooo01_ooooo00?o0000ooooooooool0
1_ooool00onHV9So8B4Qooooo`05ooooo`03ojVYZOlQ8B7oMgMg00Wooooo00?o8B4QokZj^_ooool0
6Oooool00oo^k^ko<S8bojVYZ@06ooooo`05oc8b<_ooooooooooooooool00000??ooool0067ooooo
00?ok^k^o`000?o<c<`04Oooool00olQ8B7o^[Zjooooo`0Oooooo`03o`000?oooooooooo00Cooooo
00Ko<S8boooooooooooooooooc8b<_nj^[XLooooo`03o`000?oooooooooo00Gooooo00?ok^k^ob4Q
8OnHV9P04_ooool00olQ8B7o^[Zjooooo`0Kooooo`03o`000?oooooooooo00Sooooo00?o8B4QokZj
^_ooool06oooool00ol0003oooooooooo`06ooooo`03onk^k_l0003oc<c<017ooooo00?o8B4QokZj
^_ooool06_ooool00oo^k^ko8B4QoiRHV005ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj>ooo
ool006;ooooo00?oEEEEofIVI_ooool03?ooool01OmVIVKogMgMoooooon7QhOo410@027ooooo00?o
0000ooooooooool01?ooool01_lb<S;ooooooooooooooooo<S8bokZj^Qcooooo00?o0000oooooooo
ool01_ooool00oo^k^ko<S8bolc<c00=ooooo`05ofIVI_oMgMgoooooohN7Qol@41007Oooool00ol0
003oooooooooo`04ooooo`05ofIVI_oMgMgoooooohN7Qol@41007Oooool00ol0003oooooooooo`07
ooooo`03oeEEEOmVIVKooooo00cooooo00GoIVIVomgMgOooooooQhN7oa0@400Mooooo`03onk^k_lb
<S;oc<c<00Cooooo00Ko<S8boooooooooooooooooc8b<_nj^[Xkooooo`00H_ooool00onj^[[o410@
ooooo`0<ooooo`05o`000?lQ8B7o0000oa0@4?o<c<`08Oooool00ol0003oooooooooo`04ooooo`06
oc8b<_oooooooooooooooolb<S;o^[Zj7?ooool00ol0003oooooooooo`07ooooo`03onk^k_m4A4Co
oooo00cooooo00Go0000ob4Q8Ol0003o410@olc<c00Mooooo`03o`000?oooooooooo00Cooooo00Go
0000ob4Q8Ol0003o410@olc<c00Mooooo`03o`000?oooooooooo00Oooooo00?o^[Zjoa0@4?ooool0
3?ooool01Ol0003o8B4Qo`000?l@413oc<c<01kooooo00?ok^k^odA4A?ooool00oooool01_lb<S;o
oooooooooooooooo<S8bokZj^S_ooooo001Sooooo`03oa0@4?o<c<cooooo00_ooooo00?o0000oooo
ooooool08oooool00ol0003oooooooooo`04ooooo`05oc8b<_o^k^koooooonk^k_l000007Oooool0
0ol0003oooooooooo`04ooooo`05okZj^_oooooooooooooooolb<S803Oooool00ol0003ooooooooo
o`0Oooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool07oooool00ol0003ooooooooo
o`08ooooo`03oa0@4?o<c<cooooo00_ooooo00?o0000ooooooooool07Oooool01Onj^[[ooooooooo
oooooooo<S8b00Cooooo00Go<S8bonk^k_ooooook^k^o`00000looooo`00Hoooool00on7QhOoIVIV
ooooo`0;ooooo`03o`000?oooooooooo027ooooo00?oQhN7okZj^_l000001_ooool01On7QhOoIVIV
oooooomVIVKoA4A401_ooooo00?oQhN7okZj^_l000001Oooool01_o<c<co0000ohN7Qooooooo^[Zj
ob4Q8@gooooo00?o0000ooooooooool07Oooool00on7QhOo^[Zjo`000006ooooo`03o`000?oooooo
oooo01gooooo00?oQhN7okZj^_l000002_ooool00on7QhOoIVIVooooo`0;ooooo`03o`000?oooooo
oooo01cooooo00Koc<c<o`000?n7QhOooooookZj^_lQ8B44ooooo`05ohN7QomVIVKoooooofIVI_m4
A4@0??ooool005oooooo1Ol000000olb<S;oooooooooo`0:ooooo`Co000000?o410@ooooooooool0
7Oooool00on7QhOo<S8bo`000007ooooo`04ofIVI_l0003o<S8bonk^kQ_ooooo00?oQhN7oc8b<_l0
00001_ooool01OnYZJWo8B4Qo`000?l@413oc<c<00gooooo1?l000000ol@413oooooooooo`0Ioooo
o`03ohN7Qolb<S;o000000Kooooo1?l000000ol@413oooooooooo`0Iooooo`03ohN7Qolb<S;o0000
00Kooooo1Ol000000olb<S;oooooooooo`0:ooooo`Co000000?o410@ooooooooool06Oooool01OnY
ZJWo8B4Qo`000?l@413oc<c<00Gooooo00CoIVIVo`000?lb<S;ok^k^??ooool00?ooooooZ?ooool0
0?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool003Wooooo00?o0000ooooooooool0oooo
oom/ooooo`00>Oooool00ol0003oooooooooo`3oooooofcooooo000iooooo`03o`000?oooooooooo
0?ooooooK?ooool003Wooooo00?o0000ooooooooool0oooooom/ooooo`00>Oooool00ol0003ooooo
ooooo`3oooooofcooooo000`oooooooo0000I_l0000Booooo`00>Oooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0@
ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0H
ooooo`00>Oooool00ol0003oooooooooo`0_ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool04?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo01_ooooo00?o0000oooo
ooooool0;oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo02cooooo000iooooo`03
o`000?oooooooooo03Wooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo04gooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0/ooooo`00
>Oooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
;?ooool003Wooooo00?o0000ooooooooool0>Oooool00ol0003oooooooooo`0@ooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo02cooooo000iooooo`03o`000?oooooooooo03Wooooo00?o0000ooooooooool04?ooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0/ooooo`00>Oooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo
013ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool0;?ooool003Wooooo0_l0000jooooo`03o`000?oooooooooo013o
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool0;?ooool003Wooooo00?o0000ooooooooool0>Oooool00ol0003ooooo
ooooo`0@ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003ooooo
ooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003ooooo
ooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0COooool00ol0003ooooo
ooooo`0Aooooo`03o`000?oooooooooo02cooooo000iooooo`03o`000?oooooooooo03Wooooo00?o
0000ooooooooool04?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo04gooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`0/ooooo`00>Oooool00ol0003oooooooooo`0i
ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`1=
ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0;?ooool003Wooooo00?o0000oooo
ooooool0>Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool0COooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo02cooooo000iooooo`03
o`000?oooooooooo03Wooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo04gooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0/ooooo`00
>Oooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
;?ooool003Wooooo00?o0000ooooooooool0>Oooool00ol0003oooooooooo`0@ooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo02cooooo000iooooo`03o`000?oooooooooo03Wooooo00?o0000ooooooooool04?ooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0/ooooo`00>Oooool2o`0003[ooooo00?o0000ooooooooool04?ooool00ol0
003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`0Aooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`0/ooooo`00>Oooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo013o
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool0;?ooool003Wooooo00?o0000ooooooooool0>Oooool00ol0003ooooo
ooooo`0@ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003ooooo
ooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003ooooo
ooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0COooool00ol0003ooooo
ooooo`0Aooooo`03o`000?oooooooooo02cooooo000iooooo`03o`000?oooooooooo03Wooooo00?o
0000ooooooooool04?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo04gooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`0/ooooo`00>Oooool00ol0003oooooooooo`0i
ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`1=
ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0;?ooool003Wooooo00?o0000oooo
ooooool0>Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool0COooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo02cooooo000iooooo`03
o`000?oooooooooo03Wooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo04gooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0/ooooo`00
>Oooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
;?ooool003Wooooo0_l0000jooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0;?oo
ool003Wooooo00?o0000ooooooooool0>Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo02cooooo000iooooo`03o`000?oooooooooo03Wooooo00?o0000ooooooooool04?ooool00ol0
003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`0Aooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`0/ooooo`00>Oooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo013o
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool0;?ooool003Wooooo00?o0000ooooooooool0>Oooool00ol0003ooooo
ooooo`0@ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003ooooo
ooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003ooooo
ooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0COooool00ol0003ooooo
ooooo`0Aooooo`03o`000?oooooooooo02cooooo000iooooo`03o`000?oooooooooo03Wooooo00?o
0000ooooooooool04?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo04gooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`0/ooooo`00>Oooool00ol0003oooooooooo`0i
ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`1=
ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0;?ooool003Wooooo00?o0000oooo
ooooool0>Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool0COooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo02cooooo000iooooo`03
o`000?oooooooooo03Wooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo04gooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0/ooooo`00
>Oooool2o`0003[ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo04gooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0/ooooo`00>Ooo
ool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0;?oo
ool003Wooooo00?o0000ooooooooool0>Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo02cooooo000iooooo`03o`000?oooooooooo03Wooooo00?o0000ooooooooool04?ooool00ol0
003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`0Aooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`0/ooooo`00>Oooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo013o
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool0;?ooool001?ooooo00CoIVIVo`000?lb<S;ok^k^1Oooool00onHV9So
0000oeEEE@06ooooo`04ofIVI_l0003o<S8bonk^kP?ooooo00Koc<c<ob4Q8Ol0003o0000oc8b<_oM
gMd7ooooo`03o`000?oooooooooo03Wooooo00?o0000ooooooooool04?ooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`0/ooooo`004_ooool2ohN7Q`03oooooon7QhOoA4A400Gooooo00?o<S8bo`000?l000001Oooool2
ohN7Q`03oooooon7QhOoA4A400?ooooo00Koc<c<ojVYZOoooooooooooiRHV?lQ8B47ooooo`03o`00
0?oooooooooo03Wooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo04gooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0/ooooo`004_oo
ool01Olb<S;ooooooooooooooooo000000Gooooo00?oZJVYob4Q8OmgMgL01Oooool01Olb<S;ooooo
oooooooooooo000000Sooooo00?o8B4QokZj^_ooool01Oooool00ol0003oooooooooo`0iooooo`03
o`000?oooooooooo013ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`1=ooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool0;?ooool001;ooooo00Ko<S8boooooooooooo
oooooc8b<_nj^[X<ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj1oooool00olQ8B7o^[Zjoooo
o`05ooooo`?o0000>Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool0COooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo02cooooo000B
ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj3?ooool01_lb<S;ooooooooooooooooo<S8bokZj
^P?ooooo00GoIVIVomgMgOooooooQhN7oa0@4007ooooo`03o`000?oooooooooo03Wooooo00?o0000
ooooooooool04?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo04gooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`0/ooooo`004_ooool01_lb<S;ooooooooooooooooo
<S8bokZj^Pcooooo00Ko<S8boooooooooooooooooc8b<_nj^[X3ooooo`05o`000?lQ8B7o0000oa0@
4?o<c<`01oooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo013ooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool0;?ooool001;ooooo00Go<S8bonk^k_ooooook^k^o`00000=ooooo`05oc8b<_o^k^kooooo
onk^k_l000001?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo03Wooooo00?o0000
ooooooooool04?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo04gooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`0/ooooo`004_ooool01On7QhOoIVIVoooooomVIVKo
A4A400gooooo00GoQhN7ofIVI_ooooooIVIVodA4A004ooooo`03o`000?oooooooooo00Wooooo00?o
0000ooooooooool0>Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool0COooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo02cooooo000C
ooooo`04ofIVI_l0003o<S8bonk^kPkooooo00CoIVIVo`000?lb<S;ok^k^1?ooool4o`000003oa0@
4?oooooooooo00Gooooo00?o0000ooooooooool0>Oooool00ol0003oooooooooo`0@ooooo`03o`00
0?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo017ooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo02cooooo000iooooo`03o`000?oooooooooo03Wooooo00?o0000ooooooooool04?oo
ool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`0/ooooo`00>Oooool00ol0003oooooooooo`0iooooo`03o`000?oooooo
oooo013ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool0;?ooool003Wooooo0_l0000jooooo`03o`000?oooooooooo
013ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool0;?ooool003Wooooo00?o0000ooooooooool0>Oooool00ol0003o
ooooooooo`0@ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003o
ooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003o
ooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0COooool00ol0003o
ooooooooo`0Aooooo`03o`000?oooooooooo02cooooo000iooooo`03o`000?oooooooooo03Wooooo
00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo
00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo
00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo04gooooo
00?o0000ooooooooool04Oooool00ol0003oooooooooo`0/ooooo`00>Oooool00ol0003ooooooooo
o`0iooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`1=ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0;?ooool003Wooooo00?o0000
ooooooooool0>Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool0COooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo02cooooo000ioooo
o`03o`000?oooooooooo03Wooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Aoooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aoooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aoooo
o`03o`000?oooooooooo04gooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0/oooo
o`00>Oooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo013ooooo00?o0000oooooooo
ool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000oooooooo
ool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000oooooooo
ool04Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo017ooooo00?o0000oooooooo
ool0;?ooool003Wooooo00?o0000ooooooooool0>Oooool00ol0003oooooooooo`0@ooooo`03o`00
0?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo017ooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo02cooooo000iooooo`03o`000?oooooooooo03Wooooo00?o0000ooooooooool04?oo
ool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`0/ooooo`00>Oooool2o`0003[ooooo00?o0000ooooooooool04?ooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0/ooooo`00>Oooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo
013ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool0;?ooool003Wooooo00?o0000ooooooooool0>Oooool00ol0003o
ooooooooo`0@ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003o
ooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003o
ooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0COooool00ol0003o
ooooooooo`0Aooooo`03o`000?oooooooooo02cooooo000iooooo`03o`000?oooooooooo03Wooooo
00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo
00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo
00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo04gooooo
00?o0000ooooooooool04Oooool00ol0003oooooooooo`0/ooooo`00>Oooool00ol0003ooooooooo
o`0iooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`1=ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0;?ooool003Wooooo00?o0000
ooooooooool0>Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool0COooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo02cooooo000ioooo
o`03o`000?oooooooooo03Wooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Aoooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aoooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aoooo
o`03o`000?oooooooooo04gooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0/oooo
o`00>Oooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo013ooooo00?o0000oooooooo
ool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000oooooooo
ool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000oooooooo
ool04Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo017ooooo00?o0000oooooooo
ool0;?ooool003Wooooo0_l0000jooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
;?ooool003Wooooo00?o0000ooooooooool0>Oooool00ol0003oooooooooo`0@ooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo02cooooo000iooooo`03o`000?oooooooooo03Wooooo00?o0000ooooooooool04?ooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0/ooooo`00>Oooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo
013ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool0;?ooool003Wooooo00?o0000ooooooooool0>Oooool00ol0003o
ooooooooo`0@ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003o
ooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003o
ooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0COooool00ol0003o
ooooooooo`0Aooooo`03o`000?oooooooooo02cooooo000iooooo`03o`000?oooooooooo03Wooooo
00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo
00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo
00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo04gooooo
00?o0000ooooooooool04Oooool00ol0003oooooooooo`0/ooooo`00>Oooool00ol0003ooooooooo
o`0iooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`1=ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0;?ooool003Wooooo00?o0000
ooooooooool0>Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool0COooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo02cooooo000ioooo
o`03o`000?oooooooooo03Wooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Aoooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aoooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aoooo
o`03o`000?oooooooooo04gooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0/oooo
o`00>Oooool2o`0003[ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo04gooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0/ooooo`00
>Oooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
;?ooool003Wooooo00?o0000ooooooooool0>Oooool00ol0003oooooooooo`0@ooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo02cooooo000iooooo`03o`000?oooooooooo03Wooooo00?o0000ooooooooool04?ooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0/ooooo`00>Oooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo
013ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool0;?ooool001cooooo00CoIVIVo`000?lb<S;ok^k^1Oooool00onH
V9So0000oeEEE@05ooooo`03oa0@4?l0003o000000;o000000?ogMgMooooooooool01?ooool00ol0
003oooooooooo`0iooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`1=ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0;?ooool001_o
oooo0_n7QhL00oooooooQhN7odA4A005ooooo`03oc8b<_l0003o000000Oooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo013ooooo00?o0000oooooooo
ool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000oooooooo
ool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000oooooooo
ool04Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo017ooooo00?o0000oooooooo
ool0;?ooool001_ooooo00Go<S8booooooooooooooooo`000005ooooo`03ojVYZOlQ8B7oMgMg00Oo
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo013o
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool0;?ooool001_ooooo00Ko<S8boooooooooooooooooc8b<_nj^[X>oooo
o`03o`000?oooooooooo00Oooooo0ol0000iooooo`03o`000?oooooooooo013ooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool0;?ooool001_ooooo00Ko<S8boooooooooooooooooc8b<_nj^[X>ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool0>Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo02cooooo000Kooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj3_ooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo03Wooooo00?o0000ooooooooool04?ooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`0/ooooo`006oooool01Olb<S;ok^k^ooooooo^k^ko000000oooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0;?oo
ool001_ooooo00GoQhN7ofIVI_ooooooIVIVodA4A00=ooooo`03ohN7Qonj^[[o000000Wooooo00?o
0000ooooooooool0>Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool0COooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo02cooooo000L
ooooo`04ofIVI_l0003o<S8bonk^kPgooooo00?oQhN7oc8b<_l000002Oooool00ol0003ooooooooo
o`0iooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`1=ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0;?ooool003Wooooo00?o0000
ooooooooool0>Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool0COooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo02cooooo000ioooo
o`03o`000?oooooooooo03Wooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Aoooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aoooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aoooo
o`03o`000?oooooooooo04gooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0/oooo
o`00>Oooool2o`0003[ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo04gooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0/ooooo`00
>Oooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
;?ooool003Wooooo00?o0000ooooooooool0>Oooool00ol0003oooooooooo`0@ooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo02cooooo000iooooo`03o`000?oooooooooo03Wooooo00?o0000ooooooooool04?ooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0/ooooo`00>Oooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo
013ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool0;?ooool003Wooooo00?o0000ooooooooool0>Oooool00ol0003o
ooooooooo`0@ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003o
ooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003o
ooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0COooool00ol0003o
ooooooooo`0Aooooo`03o`000?oooooooooo02cooooo000iooooo`03o`000?oooooooooo03Wooooo
00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo
00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo
00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo04gooooo
00?o0000ooooooooool04Oooool00ol0003oooooooooo`0/ooooo`00>Oooool00ol0003ooooooooo
o`0iooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`1=ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0;?ooool003Wooooo00?o0000
ooooooooool0>Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool0COooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo02cooooo000ioooo
o`;o0000>_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool0COooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo02cooooo000iooooo`03
o`000?oooooooooo03Wooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo04gooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0/ooooo`00
>Oooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
;?ooool003Wooooo00?o0000ooooooooool0>Oooool00ol0003oooooooooo`0@ooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo02cooooo000iooooo`03o`000?oooooooooo03Wooooo:?l0000Cooooo`03o`000?oooooo
oooo017ooooo:Ol0000CoooooaGo0000CooooolEo`0002kooooo000iooooo`03o`000?oooooooooo
063ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`3dooooo`00>Oooool00ol0003o
ooooooooo`1Pooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0m?ooool003Wooooo
00?o0000ooooooooool0H?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo0?Cooooo
000iooooo`;o0000HOooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo0?Cooooo000i
ooooo`03o`000?oooooooooo063ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`3d
ooooo`00>Oooool00ol0003oooooooooo`1Pooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool0m?ooool003Wooooo00?o0000ooooooooool0H?ooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo0?Cooooo000iooooo`03o`000?oooooooooo063ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`3dooooo`00>Oooool00ol0003oooooooooo`1Pooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool0m?ooool003Wooooo00?o0000ooooooooool0H?ooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo0?Cooooo000iooooo`03o`000?oooooooooo
063ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`3dooooo`00>Oooool2o`00067o
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`3dooooo`00>Oooool00ol0003ooooo
ooooo`1Pooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0m?ooool003Wooooo00?o
0000ooooooooool0H?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo0?Cooooo000i
ooooo`03o`000?oooooooooo063ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`3d
ooooo`00>Oooool00ol0003oooooooooo`1Pooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool0m?ooool003Wooooo00?o0000ooooooooool0H?ooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo0?Cooooo000Cooooo`04ofIVI_l0003o<S8bonk^kPGooooo00?oV9RHo`000?mE
EED01Oooool00ol@413o0000o`000002o`000005omgMgOooooooooooolc<c?lQ8B400_l000000olb
<S;ogMgMooooo`06ooooo`03o`000?oooooooooo063ooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`3dooooo`004_ooool2ohN7Q`03oooooon7QhOoA4A400Gooooo00?o<S8bo`000?l0
00001oooool00ol0003oooooooooo`03ooooo`06olc<c?nYZJWooooooooooonHV9So8B4Q1oooool0
0ol0003oooooooooo`1Pooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0m?ooool0
01;ooooo00Go<S8booooooooooooooooo`000005ooooo`03ojVYZOlQ8B7oMgMg00Oooooo00?o0000
ooooooooool02?ooool00olQ8B7o^[Zjooooo`05ooooo`03o`000?oooooooooo063ooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`3dooooo`004_ooool01_lb<S;ooooooooooooooooo
<S8bokZj^Pkooooo00?o0000ooooooooool02?ooool00olQ8B7o^[Zjooooo`05ooooo`?o0000H?oo
ool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo0?Cooooo000Booooo`06oc8b<_oooooo
oooooooooolb<S;o^[Zj3_ooool00ol0003oooooooooo`04ooooo`05ofIVI_oMgMgoooooohN7Qol@
41001oooool00ol0003oooooooooo`1Pooooo`03o`000?oooooooooo017ooooo00?o0000oooooooo
ool0m?ooool001;ooooo00Ko<S8boooooooooooooooooc8b<_nj^[X>ooooo`03o`000?oooooooooo
00Cooooo00Go0000ob4Q8Ol0003o410@olc<c007ooooo`03o`000?oooooooooo063ooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`3dooooo`004_ooool01Olb<S;ok^k^ooooooo^k^ko
000000oooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooo
oooo063ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`3dooooo`004_ooool01On7
QhOoIVIVoooooomVIVKoA4A400gooooo00?oQhN7okZj^_l000001_ooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo063ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`3d
ooooo`004oooool01?mVIVKo0000oc8b<_o^k^h=ooooo`03ohN7Qolb<S;o000000Kooooo1?l00000
0ol@413oooooooooo`05ooooo`03o`000?oooooooooo063ooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`3dooooo`00>Oooool00ol0003oooooooooo`1Pooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool0m?ooool003Wooooo00?o0000ooooooooool0H?ooool00ol0003o
ooooooooo`0Aooooo`03o`000?oooooooooo0?Cooooo000iooooo`;o0000HOooool00ol0003ooooo
ooooo`0Aooooo`03o`000?oooooooooo0?Cooooo000iooooo`03o`000?oooooooooo063ooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`3dooooo`00>Oooool00ol0003oooooooooo`1P
ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0m?ooool003Wooooo00?o0000oooo
ooooool0H?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo0?Cooooo000iooooo`03
o`000?oooooooooo063ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`3dooooo`00
>Oooool00ol0003oooooooooo`1Pooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
m?ooool003Wooooo00?o0000ooooooooool0H?ooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo0?Cooooo000iooooo`03o`000?oooooooooo063ooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`3dooooo`00>Oooool00ol0003oooooooooo`1Pooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool0m?ooool003Wooooo0_l0001Qooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool0m?ooool003Wooooo00?o0000ooooooooool0H?ooool00ol0003ooooo
ooooo`0Aooooo`03o`000?oooooooooo0?Cooooo000iooooo`03o`000?oooooooooo063ooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`3dooooo`00>Oooool00ol0003oooooooooo`1P
ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0m?ooool003Wooooo00?o0000oooo
ooooool0H?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo0?Cooooo000iooooo`03
o`000?oooooooooo063ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`3dooooo`00
>Oooool00ol0003oooooooooo`1Pooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
m?ooool003Wooooo00?o0000ooooooooool0H?ooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo0?Cooooo000iooooo`;o0000HOooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo0?Cooooo000iooooo`03o`000?oooooooooo063ooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`3dooooo`00>Oooool00ol0003oooooooooo`1Pooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool0m?ooool003Wooooo00?o0000ooooooooool0H?ooool00ol0003ooooo
ooooo`0Aooooo`03o`000?oooooooooo0?Cooooo000iooooo`03o`000?oooooooooo063ooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`3dooooo`00>Oooool00ol0003oooooooooo`1P
ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0m?ooool003Wooooo00?o0000oooo
ooooool0H?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo0?Cooooo000iooooo`03
o`000?oooooooooo063ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`3dooooo`00
>Oooool2o`00067ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`3dooooo`00>Ooo
ool00ol0003oooooooooo`1Pooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0m?oo
ool003Wooooo00?o0000ooooooooool0H?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo0?Cooooo000iooooo`03o`000?oooooooooo063ooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`3dooooo`00>Oooool00ol0003oooooooooo`1Pooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool0m?ooool003Wooooo00?o0000ooooooooool0H?ooool00ol0003ooooo
ooooo`0Aooooo`03o`000?oooooooooo0?Cooooo000Looooo`04ofIVI_l0003o<S8bonk^kPGooooo
00?oV9RHo`000?mEEED01?ooool00on7QhOo0000o`000002o`000003oa0@4?oooooooooo00Gooooo
00?o0000ooooooooool0H?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo0?Cooooo
000Kooooo`;oQhN700?oooooohN7Qom4A4@01Oooool00olb<S;o0000o`000004ooooo`03onk^k_lb
<S;oc<c<00[ooooo00?o0000ooooooooool0H?ooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo0?Cooooo000Kooooo`05oc8b<_ooooooooooooooool000001Oooool00onYZJWo8B4QogMg
M`05ooooo`03onk^k_lb<S;oZJVY00Wooooo00?o0000ooooooooool0H?ooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo0?Cooooo000Kooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj
3Oooool00oo^k^ko8B4QoiRHV008ooooo`?o0000H?ooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo0?Cooooo000Kooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj3_ooool00oo^k^ko
<S8bolc<c007ooooo`03o`000?oooooooooo063ooooo00?o0000ooooooooool04Oooool00ol0003o
ooooooooo`3dooooo`006oooool01_lb<S;ooooooooooooooooo<S8bokZj^Poooooo00?ok^k^odA4
A?ooool01_ooool00ol0003oooooooooo`1Pooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool0m?ooool001_ooooo00Go<S8bonk^k_ooooook^k^o`00000=ooooo`05okZj^_oooooooooo
oooooolb<S801oooool00ol0003oooooooooo`1Pooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool0m?ooool001_ooooo00GoQhN7ofIVI_ooooooIVIVodA4A00<ooooo`06olc<c?l0003o
QhN7oooooonj^[[o8B4Q1oooool00ol0003oooooooooo`1Pooooo`03o`000?oooooooooo017ooooo
00?o0000ooooooooool0m?ooool001cooooo00CoIVIVo`000?lb<S;ok^k^3Oooool01OnYZJWo8B4Q
o`000?l@413oc<c<00Oooooo00?o0000ooooooooool0H?ooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo0?Cooooo000iooooo`03o`000?oooooooooo063ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`3dooooo`00>Oooool00ol0003oooooooooo`1Pooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool0m?ooool003Wooooo0_l0001Qooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool0m?ooool003Wooooo00?o0000ooooooooool0H?ooool00ol0
003oooooooooo`0Aooooo`03o`000?oooooooooo0?Cooooo000iooooo`03o`000?oooooooooo063o
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`3dooooo`00>Oooool00ol0003ooooo
ooooo`1Pooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0m?ooool003Wooooo00?o
0000ooooooooool0H?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo0?Cooooo000i
ooooo`03o`000?oooooooooo063ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`3d
ooooo`00>Oooool00ol0003oooooooooo`1Pooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool0m?ooool003Wooooo00?o0000ooooooooool0H?ooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo0?Cooooo000iooooo`03o`000?oooooooooo063ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`3dooooo`00>Oooool2o`00067ooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`3dooooo`00>Oooool00ol0003oooooooooo`1Pooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool0m?ooool003Wooooo00?o0000ooooooooool0H?ooool00ol0
003oooooooooo`0Aooooo`03o`000?oooooooooo0?Cooooo000iooooo`03o`000?oooooooooo063o
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`3dooooo`00>Oooool00ol0003ooooo
ooooo`1Pooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0m?ooool003Wooooo00?o
0000ooooooooool0H?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo0?Cooooo000i
ooooo`03o`000?oooooooooo063ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`3d
ooooo`00>Oooool00ol0003oooooooooo`1Pooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool0m?ooool003Wooooo0_l0001Qooooo`03o`000?oooooooooo017ooooo00?o0000oooooooo
ool0m?ooool003Wooooo00?o0000ooooooooool0H?ooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo0?Cooooo000iooooo`03o`000?oooooooooo063ooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`3dooooo`00>Oooool00ol0003oooooooooo`1Pooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool0m?ooool003Wooooo00?o0000ooooooooool0H?ooool00ol0
003oooooooooo`0Aooooo`03o`000?oooooooooo0?Cooooo000iooooo`03o`000?oooooooooo063o
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`3dooooo`00>Oooool00ol0003ooooo
ooooo`1Pooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0m?ooool003Wooooo00?o
0000ooooooooool0H?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo0?Cooooo000i
ooooo`;o0000HOooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo0?Cooooo000ioooo
o`03o`000?oooooooooo063ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`3doooo
o`00>Oooool00ol0003oooooooooo`1Pooooo`03o`000?oooooooooo017ooooo00?o0000oooooooo
ool0m?ooool003Wooooo00?o0000ooooooooool0H?ooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo0?Cooooo000iooooo`03o`000?oooooooooo063ooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`3dooooo`00>Oooool00ol0003oooooooooo`1Pooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool0m?ooool001?ooooo00CoIVIVo`000?lb<S;ok^k^1Oooool0
0onHV9So0000oeEEE@04ooooo`03ohN7Qol0003o000000;o000000Ko410@ooooooooooooooooolc<
c?lQ8B42o`000003oc8b<_oMgMgooooo00Kooooo00?o0000ooooooooool0H?ooool00ol0003ooooo
ooooo`0Aooooo`03o`000?oooooooooo0?Cooooo000Booooo`;oQhN700?oooooohN7Qom4A4@01Ooo
ool00olb<S;o0000o`000004ooooo`03onk^k_lb<S;oc<c<00Kooooo00Koc<c<ojVYZOoooooooooo
oiRHV?lQ8B47ooooo`03o`000?oooooooooo063ooooo00?o0000ooooooooool04Oooool00ol0003o
ooooooooo`3dooooo`004_ooool01Olb<S;ooooooooooooooooo000000Gooooo00?oZJVYob4Q8Omg
MgL01Oooool00oo^k^ko<S8bojVYZ@0:ooooo`03ob4Q8Onj^[[ooooo00Gooooo00?o0000oooooooo
ool0H?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo0?Cooooo000Booooo`06oc8b
<_oooooooooooooooolb<S;o^[Zj3Oooool00oo^k^ko8B4QoiRHV009ooooo`03ob4Q8Onj^[[ooooo
00Gooooo0ol0001PoooooaGo0000m_ooool001;ooooo00Ko<S8boooooooooooooooooc8b<_nj^[X>
ooooo`03onk^k_lb<S;oc<c<00Cooooo00GoIVIVomgMgOooooooQhN7oa0@4007ooooo`03o`000?oo
oooooooo0?ooooooK?ooool001;ooooo00Ko<S8boooooooooooooooooc8b<_nj^[X?ooooo`03onk^
k_m4A4Cooooo00?ooooo00Go0000ob4Q8Ol0003o410@olc<c007ooooo`03o`000?oooooooooo0?oo
ooooK?ooool001;ooooo00Go<S8bonk^k_ooooook^k^o`00000=ooooo`05okZj^_oooooooooooooo
oolb<S801?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo0?ooooooK?ooool001;o
oooo00GoQhN7ofIVI_ooooooIVIVodA4A00<ooooo`06olc<c?l0003oQhN7oooooonj^[[o8B4Q1?oo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo0?ooooooK?ooool001?ooooo00CoIVIV
o`000?lb<S;ok^k^3Oooool01OnYZJWo8B4Qo`000?l@413oc<c<00Cooooo1?l000000ol@413ooooo
ooooo`05ooooo`03o`000?oooooooooo0?ooooooK?ooool00?ooooooZ?ooool00?ooooooZ?ooool0
0?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool0
0?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00=7ooooo00?o410@
o`000?l000000_l000002Ol@413oooooooooooooooooV9RHoa0@4?l0003o8B4QoiRHV002o`000003
omgMgOoooooo410@00;o000000Coooooo`000?l0003o410@0oooool01omgMgOo0000o`000?m4A4Co
ZJVYo`000?l@4100/oooool00=?ooooo00?o0000ooooooooool01?ooool01_lQ8B7ok^k^ooooooo^
k^koMgMgo`0000Cooooo00Go0000ooooooooooooooooo`000003ooooo`07ogMgMomEEEGok^k^oooo
ooo<c<co8B4Qo`00002dooooo`00doooool00ol0003oooooooooo`04ooooo`06ob4Q8OnYZJWooooo
oooooooMgMgo00001?ooool01Ol0003ooooooooooooooooo000000?ooooo00?o8B4Qooooooooool0
0_ooool00onj^[[o0000ooooo`2cooooo`00doooool00ol0003oooooooooo`04ooooo`06olc<c?m4
A4Co0000o`000?l@413o00001?ooool01Ol0003ooooooooooooooooo000000?ooooo00?o<S8boooo
ooooool00oooool00ol0003oooooooooo`2booooo`00doooool00ol0003oc<c<ooooo`09ooooo`03
o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`000003ooooo`03ob4Q8Ooooooooooo
00;ooooo00?oc<c<o`000?ooool0/oooool00=?ooooo00Wo0000oc8b<_nHV9SooooookZj^_oMgMgo
ooooolc<c?nHV9P00_ooool00on7QhOo8B4Qooooo`03ooooo`05o`000?n7QhOooooookZj^_l@4100
0oooool01onYZJWoEEEEonk^k_oooooogMgMob4Q8Ol00000]?ooool00=7ooooo00Go410@o`000?l0
003ok^k^ofIVIP02o`000004ojVYZOoooooo^[Zjob4Q8@;o000000?o8B4Qolc<c?ooool00_ooool2
o`000004ofIVI_l0003o0000okZj^PCooooo00KoZJVYoa0@4?l0003o0000ogMgMol0002dooooo`00
l_ooool00ol0003oooooooooo`2booooo`00l_ooool00ol0003oooooooooo`2booooo`00l?ooool0
0ol@413o0000o`00002dooooo`00oooooonXooooo`00\
\>"],
  ImageRangeCache->{{{0, 422}, {260, 0}} -> {2.13943, -0.0268159, 0.0751339, \
0.00178778}}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{0, 1440}, {0, 877}},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{714, 822},
WindowMargins->{{Automatic, 5}, {Automatic, 2}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1.5
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 139, 4, 41, "Subsubsection"],
Cell[1918, 59, 432, 8, 151, "Text"],
Cell[2353, 69, 187, 4, 73, "Text"],
Cell[2543, 75, 94, 4, 58, "Input"],
Cell[2640, 81, 171, 4, 73, "Text"],

Cell[CellGroupData[{
Cell[2836, 89, 142, 8, 138, "Input"],
Cell[2981, 99, 72, 1, 33, "Print"],
Cell[3056, 102, 94, 5, 37, "Output"]
}, Open  ]],
Cell[3165, 110, 451, 8, 151, "Text"],
Cell[3619, 120, 93, 1, 38, "Input"],

Cell[CellGroupData[{
Cell[3737, 125, 185, 5, 98, "Input"],
Cell[3925, 132, 160, 6, 37, "Output"]
}, Open  ]],
Cell[4100, 141, 195, 9, 158, "Input"],
Cell[4298, 152, 95, 4, 58, "Input"],
Cell[4396, 158, 119, 6, 98, "Input"],

Cell[CellGroupData[{
Cell[4540, 168, 171, 6, 98, "Input"],
Cell[4714, 176, 6773, 220, 4611, "Print"]
}, Open  ]],
Cell[11502, 399, 86, 1, 47, "Text"],
Cell[11591, 402, 127, 4, 47, "Text"],

Cell[CellGroupData[{
Cell[11743, 410, 83, 1, 38, "Input"],
Cell[11829, 413, 119, 4, 54, "Print"],
Cell[11951, 419, 147, 7, 50, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12135, 431, 291, 8, 120, "Input"],
Cell[12429, 441, 741, 36, 726, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[13219, 483, 136, 4, 41, "Subsubsection"],
Cell[13358, 489, 94, 1, 38, "Input"],
Cell[13455, 492, 216, 10, 178, "Input"],

Cell[CellGroupData[{
Cell[13696, 506, 85, 1, 38, "Input"],
Cell[13784, 509, 166, 5, 117, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13987, 519, 85, 1, 38, "Input"],
Cell[14075, 522, 182, 5, 117, "Print"]
}, Open  ]],
Cell[14272, 530, 137, 4, 47, "Text"],

Cell[CellGroupData[{
Cell[14434, 538, 136, 4, 58, "Input"],
Cell[14573, 544, 62, 4, 54, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14672, 553, 100, 1, 38, "Input"],
Cell[14775, 556, 110, 6, 96, "Print"],
Cell[14888, 564, 30500, 901, 273, 6203, 597, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],

Cell[CellGroupData[{
Cell[45425, 1470, 100, 1, 38, "Input"],
Cell[45528, 1473, 111, 6, 96, "Print"],
Cell[45642, 1481, 61926, 1291, 273, 6217, 599, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

