(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10156,        257]*)
(*NotebookOutlinePosition[     11024,        287]*)
(*  CellTagsIndexPosition[     10980,        283]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
CHR 2 November 1994
These are the examples that form part of my hydrodynamics paper.\
\>", "Text",\

  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Paper: Use Kirkwood and vary the number of turns", "Subsubsection",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
First clear the randomizing orientation matrix so that all of the \
chain pictures will be aligned in the same coordinate system.\
\>", "Text",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
ClearAll[A0];
A0=Identity[3];\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
Then define a couple of things to make the example easier to do... \
Here the DNA chain is of length template (bp), and there are nnukes \
nucleosomes on it. The nucleosomes begin and end the chain. The linker length \
in bp is calculated, and the \"chain\" defined.  Remember that the chain of \
segments includes one segment for each free basepair (the linker) and one \
segment for each nucleosome.\
\>", "Text",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
linker[length_,t_]:=length-t wrapbp;
ns[length_,t_]:=2+linker[length,t];
chain[length_,t_]:={ns[length,t],{1,ns[length,t]}};\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
template=354;
nnukes=2;\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
turns=1.75;
chain[template,nnukes]\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[OutputFormData["\<\
{64, {1, 64}}\
\>", "\<\
{64, {1, 64}}\
\>"], \
"Output",
  ImageRegion->{{-0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
I reset the persistence length and now will calculate the Kirkwood \
estimates of the frictional coefficients. This procedure (Kirkwood) does not \
require Monte Carlo trials, remember, so I don't need to bother anymore with \
A0.\
\>", "Text",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
template=354;
nnukes=2;
collective=True;
test=True;
progress=True;
MonteCarlo=False;\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
definebasepair;
Do[\tturns=turns0;
\tdefinenuke;
\tdefinephysicalnuke;
\tassembleelements[chain[template,nnukes]];
\tmakeAs[chain[template,nnukes]];
\tdoKirkwood[chain[template,nnukes]],
{turns0,1.5,2.0,0.1}];\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[TextData[{
  "n = 20 ; dl = 21.0801\nChain of 106 segments,\nwith displacements at \
segments {1, 106}\nStokes offset 3.00764 A at 50 bp\n\nel0           3.4      \
     A\n\npersistence\nlength        510.          A\n\n\nrepeat0       10.4  \
        bp/turn\n\n\nrepeat1       10.15         bp/turn\n\n\nradius        \
44.916        A\n\n\nturns         1.5           turns\n\n\npitch         \
-28.571       A/turn\nArray of chain lengths (bp)\n{0, 104, 0}\nArray of \
friction element positions (bp)\n{1, 53, 106}\nArray of Stokes radii (A)\n\
{55.7171, 56.2669, 55.7171}\n\n...doKirkwood...\ni,j,rij:*1 2 174.723\n\
i,j,rij:*1 3 328.72\ni,j,rij:*2 3 177.669",
  StyleBox["\n   Kirkwood results: {f free-draining,f1,s1}\n              -7  \
           -7\n    3.21167 10   g  2.0895 10   g\n   {--------------, \
-------------, s1}\n          s               s",
    FontWeight->"Bold"],
  "\n          \n          \n          \nn = 20 ; dl = 22.4569\nChain of 90 \
segments,\nwith displacements at segments {1, 90}\nStokes offset 3.00764 A at \
50 bp\n\nel0           3.4           A\n\npersistence\nlength        510.     \
     A\n\n\nrepeat0       10.4          bp/turn\n\n\nrepeat1       10.15      \
   bp/turn\n\n\nradius        44.916        A\n\n\nturns         1.6          \
 turns\n\n\npitch         -28.571       A/turn\nArray of chain lengths (bp)\n\
{0, 88, 0}\nArray of friction element positions (bp)\n{1, 45, 90}\nArray of \
Stokes radii (A)\n{56.1394, 50.5685, 56.1394}\n\n...doKirkwood...\ni,j,rij:*1 \
2 151.701\ni,j,rij:*1 3 291.824\ni,j,rij:*2 3 154.673",
  StyleBox["\n   Kirkwood results: {f free-draining,f1,s1}\n              -7  \
            -7\n    3.11871 10   g  1.96407 10   g\n   {--------------, \
--------------, s1}\n          s               s",
    FontWeight->"Bold"],
  "\n          \n          \n          \nn = 20 ; dl = 23.8283\nChain of 74 \
segments,\nwith displacements at segments {1, 74}\nStokes offset 3.00764 A at \
50 bp\n\nel0           3.4           A\n\npersistence\nlength        510.     \
     A\n\n\nrepeat0       10.4          bp/turn\n\n\nrepeat1       10.15      \
   bp/turn\n\n\nradius        44.916        A\n\n\nturns         1.7          \
 turns\n\n\npitch         -28.571       A/turn\nArray of chain lengths (bp)\n\
{0, 72, 0}\nArray of friction element positions (bp)\n{1, 37, 74}\nArray of \
Stokes radii (A)\n{56.5554, 44.6771, 56.5554}\n\n...doKirkwood...\ni,j,rij:*1 \
2 128.809\ni,j,rij:*1 3 241.539\ni,j,rij:*2 3 131.786",
  StyleBox["\n   Kirkwood results: {f free-draining,f1,s1}\n              -7  \
            -7\n    3.02182 10   g  1.82091 10   g\n   {--------------, \
--------------, s1}",
    FontWeight->"Bold"],
  "\n          s               s\nn = 20 ; dl = 25.1939\nChain of 56 \
segments,\nwith displacements at segments {1, 56}\nStokes offset 3.00764 A at \
50 bp\n\nel0           3.4           A\n\npersistence\nlength        510.     \
     A\n\n\nrepeat0       10.4          bp/turn\n\n\nrepeat1       10.15      \
   bp/turn\n\n\nradius        44.916        A\n\n\nturns         1.8          \
 turns\n\n\npitch         -28.571       A/turn\nArray of chain lengths (bp)\n\
{0, 54, 0}\nArray of friction element positions (bp)\n{1, 28, 56}\nArray of \
Stokes radii (A)\n{57.0163, 37.7895, 57.0163}\n\n...doKirkwood...\ni,j,rij:*1 \
2 103.623\ni,j,rij:*1 3 182.455\ni,j,rij:*2 3 106.546",
  StyleBox["\n   Kirkwood results: {f free-draining,f1,s1}\n              -7  \
            -7\n    2.90757 10   g  1.63805 10   g\n   {--------------, \
--------------, s1}\n          s               s",
    FontWeight->"Bold"],
  "\n          \n          \n          \nn = 20 ; dl = 26.5533\nChain of 40 \
segments,\nwith displacements at segments {1, 40}\nStokes offset 3.00764 A at \
50 bp\n\nel0           3.4           A\n\npersistence\nlength        510.     \
     A\n\n\nrepeat0       10.4          bp/turn\n\n\nrepeat1       10.15      \
   bp/turn\n\n\nradius        44.916        A\n\n\nturns         1.9          \
 turns\n\n\npitch         -28.571       A/turn\nArray of chain lengths (bp)\n\
{0, 38, 0}\nArray of friction element positions (bp)\n{1, 20, 40}\nArray of \
Stokes radii (A)\n{57.4198, 31.1152, 57.4198}\n\n...doKirkwood...\ni,j,rij:*1 \
2 82.7165\ni,j,rij:*1 3 138.442\ni,j,rij:*2 3 85.4716",
  StyleBox["\n   Kirkwood results: {f free-draining,f1,s1}\n             -7   \
           -7\n    2.7952 10   g  1.46442 10   g\n   {-------------, \
--------------, s1}\n          s              s",
    FontWeight->"Bold"],
  "\n          \n          \n          \nn = 20 ; dl = 27.9063\nChain of 24 \
segments,\nwith displacements at segments {1, 24}\nStokes offset 3.00764 A at \
50 bp\n\nel0           3.4           A\n\npersistence\nlength        510.     \
     A\n\n\nrepeat0       10.4          bp/turn\n\n\nrepeat1       10.15      \
   bp/turn\n\n\nradius        44.916        A\n\n\nturns         2.           \
 turns\n\n\npitch         -28.571       A/turn\nArray of chain lengths (bp)\n\
{0, 22, 0}\nArray of friction element positions (bp)\n{1, 12, 24}\nArray of \
Stokes radii (A)\n{57.8177, 23.7954, 57.8177}\n\n...doKirkwood...\ni,j,rij:*1 \
2 65.094\ni,j,rij:*1 3 125.456\ni,j,rij:*2 3 67.388",
  StyleBox["\n   Kirkwood results: {f free-draining,f1,s1}\n              -7  \
            -7\n    2.67026 10   g  1.34983 10   g\n   {--------------, \
--------------, s1}\n          s               s",
    FontWeight->"Bold"],
  ""
}], "Print",
  ImageRegion->{{-0, 1}, {0, 1}},
  FontSize->9]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
turnlist={1.5,1.6,1.7,1.8,1.9,2.0};
flist={2.0895,1.96407,1.82091,1.63805,1.46442,1.34983};
Dtlist=10^7 gettrans[flist 10^-7,296.15]/.
\t{cm->1,g->1,s->1}\
\>", "Input",
  GroupPageBreakWithin->Automatic,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[OutputFormData["\<\
{1.956517587502672315, 2.081465273176024176, 
 
  2.245110136737583847, 2.495737919530437901, 
 
  2.791646862981135059, 3.028635827538900308}\
\>", "\<\
{1.95652, 2.08147, \
2.24511, 2.49574, 2.79165, 3.02864}\
\>"], "Output",
  ImageRegion->{{-0, 1}, {0, 1}}]
}, Open  ]]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{0, 1440}, {0, 877}},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{714, 822},
WindowMargins->{{Automatic, 5}, {Automatic, 2}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1.5
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 144, 5, 73, "Text"],

Cell[CellGroupData[{
Cell[1923, 60, 107, 1, 41, "Subsubsection"],
Cell[2033, 63, 187, 4, 73, "Text"],
Cell[2223, 69, 88, 4, 58, "Input"],
Cell[2314, 75, 459, 8, 151, "Text"],
Cell[2776, 85, 183, 5, 78, "Input"],
Cell[2962, 92, 82, 4, 58, "Input"],

Cell[CellGroupData[{
Cell[3069, 100, 93, 4, 58, "Input"],
Cell[3165, 106, 116, 6, 37, "Output"]
}, Open  ]],
Cell[3296, 115, 288, 6, 99, "Text"],
Cell[3587, 123, 143, 8, 138, "Input"],

Cell[CellGroupData[{
Cell[3755, 135, 268, 10, 178, "Input"],
Cell[4026, 147, 5528, 82, 4044, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9603, 235, 248, 7, 118, "Input"],
Cell[9854, 244, 286, 10, 37, "Output"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

