(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    340288,       7776]*)
(*NotebookOutlinePosition[    341184,       7807]*)
(*  CellTagsIndexPosition[    341140,       7803]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
17-30 January 1995 CHR,  continuing from \"Oseen\", 2 November 1994
Use Zimm (1980) formulation to solve hydrodynamics of a given subunit array. \
Compare various aspects of the Kirkwood/Bloomfield et al. (which I will \
sometimes call \"K/B\") approximation.\
\>", "Text",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
General functions to define interaction tensor, velocity \
perturbations, etc.\
\>", "Subsubsection",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
Off[General::spell];
Off[General::spell1];\
\>", "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["avg[x_]:=Apply[Plus,x]/Length[x];", "Input",
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
l[r_]:=Sqrt[r.r];
rr[r_]:=Outer[Times,r,r];
Id[n_]:=IdentityMatrix[n];
zero[n_]:=Table[0,{n},{n}];\
\>", "Input",
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["T[r_]:=1/(8 Pi nu l[r])(Id[Length[r]]+rr[r]/l[r]^2);", "Input",
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["MatrixForm[T[{x,y,z}]]", "Input",
  GroupPageBreakWithin->Automatic,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[OutputFormData["\<\
MatrixForm[{{(1 + x^2/(x^2 + y^2 + \
z^2))/(8*nu*Pi*(x^2 + y^2 + z^2)^(1/2)), 
 
    (x*y)/(8*nu*Pi*(x^2 + y^2 + z^2)^(3/2)), 
 
    (x*z)/(8*nu*Pi*(x^2 + y^2 + z^2)^(3/2))}, 
 
   {(x*y)/(8*nu*Pi*(x^2 + y^2 + z^2)^(3/2)), 
 
    (1 + y^2/(x^2 + y^2 + z^2))/(8*nu*Pi*(x^2 + y^2 + z^2)^(1/2)), 
 
    (y*z)/(8*nu*Pi*(x^2 + y^2 + z^2)^(3/2))}, 
 
   {(x*z)/(8*nu*Pi*(x^2 + y^2 + z^2)^(3/2)), 
 
    (y*z)/(8*nu*Pi*(x^2 + y^2 + z^2)^(3/2)), 
 
    (1 + z^2/(x^2 + y^2 + z^2))/(8*nu*Pi*(x^2 + y^2 + z^2)^(1/2))}}]\
\>", \
"\<\
               2
              x
     1 + ------------
          2    2    2
         x  + y  + z                    x y                          x z
--------------------------   -------------------------    \
-------------------------
              2    2    2              2    2    2 3/2              2    2    \
2 3/2
8 nu Pi Sqrt[x  + y  + z ]   8 nu Pi (x  + y  + z )       8 nu Pi (x  + y  + \
z )

                                            2
                                           y
                                  1 + ------------
                                       2    2    2
           x y                        x  + y  + z                    y z
-------------------------    --------------------------   \
-------------------------
          2    2    2 3/2                  2    2    2              2    2    \
2 3/2
8 nu Pi (x  + y  + z )       8 nu Pi Sqrt[x  + y  + z ]   8 nu Pi (x  + y  + \
z )

                                                                         2
                                                                        z
                                                               1 + \
------------
                                                                    2    2    \
2
           x z                          y z                        x  + y  + \
z
-------------------------    -------------------------    \
--------------------------
          2    2    2 3/2              2    2    2 3/2                  2    \
2    2
8 nu Pi (x  + y  + z )       8 nu Pi (x  + y  + z )       8 nu Pi Sqrt[x  + y \
 + z ]\
\>"], "Output",
  GroupPageBreakWithin->Automatic,
  ImageRegion->{{-0, 1}, {0, 1}}]
}, Closed]],

Cell["Velocity and velocity perturbation functions.", "Text",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
V[i_,{p_,radius_}]:=Id[3]/(6 Pi nu radius[[i]])
dV[i_,j_,{p_,radius_}]:=T[p[[j]]-p[[i]]];
u[i_,{p_,radius_}]:={-p[[i,2]],p[[i,1]],0};
z[i_,{p_,radius_}]:={p[[i,2]],-p[[i,1]],0};\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["Demonstrate some velocity profiles", "Text",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[TextData[{
  "The perturbation of the velocity of the fluid at a given point r{x,y,z} \
with respect to a frictional sphere is given by the following expression for \
dv for a force f {x,y,z} acting on the center.\n\nThe viscosity nu has \
typically the units of poise, or g/(cm sec). If distances are in cm and force \
is (g cm/sec",
  StyleBox["2",
    FontSize->10,
    FontVariations->{"CompatibilityType"->"Superscript"}],
  "), the velocity given here is cm/sec.\nThe relative velocity dv0 is the \
relative solvent velocity perturbation about a particle travelling with \
whatever velocity results from a unit force acting on it, expressed in terms \
of the distance relative to the particle radius. The factor of the particle \
radius cancels. A positive value says that the sphere is dragging fluid with \
it."
}], "Text",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
ClearAll[dv,dv0];
dv[r_,f_]:=T[r].f;
dv0[r0_,f0_]:=dv[r0,f0] 6 Pi nu; \
\>", "Input",
  GroupPageBreakWithin->Automatic,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["dv[{1,0,0} cm,{1,0,0} g cm/s^2]/.nu->g/(cm s)", "Input",
  GroupPageBreakWithin->Automatic,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[OutputFormData["\<\
{cm^2/(4*(cm^2)^(1/2)*Pi*s), 0, 0}\
\>", "\<\
       \
  2
       cm
{----------------, 0, 0}
          2
 4 Sqrt[cm ] Pi s\
\>"], "Output",
  GroupPageBreakWithin->Automatic,
  ImageRegion->{{-0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["dv0[{1,0,0},{1,0,0}]", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[OutputFormData["\<\
{3/2, 0, 0}\
\>", "\<\
 3
{-, 0, 0}
 2\
\>"], "Output",
  ImageRegion->{{-0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["dv0[{1.1,0,0},{fx,fy,fz}]", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[OutputFormData["\<\
{1.363636363636363636*fx, 0.6818181818181818181*fy, \
0.6818181818181818181*fz}\
\>", "\<\
{1.36364 fx, 0.681818 fy, 0.681818 fz}\
\
\>"], "Output",
  ImageRegion->{{-0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Plot3D[r={x,y,0};l[N[dv0[r,{1,0,0}]]],
\t{x,-2,2},{y,-2,2},PlotPoints->20,
\tAxesLabel->{\"x\",\"y\",\"z\"}];\
\>", "Input",
  GroupPageBreakWithin->Automatic,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .82055 
MathPictureStart
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0249355 0.99742 -0.0396341 0.99742 [
[(-2)] .05113 .25884 1 .93395 Msboxa
[(-1)] .1926 .20316 .96648 1 Msboxa
[(0)] .34275 .1441 .86223 1 Msboxa
[(1)] .50241 .08133 .75799 1 Msboxa
[(2)] .6725 .0145 .65374 1 Msboxa
[(x)] .30204 .09689 .86223 1 Msboxa
[(-2)] .69093 .02039 -1 .39157 Msboxa
[(-1)] .76901 .13994 -1 .36413 Msboxa
[(0)] .83872 .24668 -1 .34028 Msboxa
[(1)] .90133 .34257 -1 .31937 Msboxa
[(2)] .95788 .42917 -1 .30087 Msboxa
[(y)] .89773 .2266 -1 .34028 Msboxa
[(0.5)] .04572 .29014 1 -0.38797 Msboxa
[(1)] .03695 .3451 1 -0.37709 Msboxa
[(1.5)] .02785 .40215 1 -0.36575 Msboxa
[(2)] .01839 .46142 1 -0.35393 Msboxa
[(z)] -0.02691 .40064 1 -0.37036 Msboxa
[ 0 0 0 0 ]
[ 1 .82055 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.06024 .26735 m
.67932 .02494 L
s
P
p
.002 w
.06024 .26735 m
.0648 .2716 L
s
P
[(-2)] .05113 .25884 1 .93395 Mshowa
p
.002 w
.20126 .21213 m
.2056 .21661 L
s
P
[(-1)] .1926 .20316 .96648 1 Mshowa
p
.002 w
.35089 .15354 m
.35496 .15826 L
s
P
[(0)] .34275 .1441 .86223 1 Mshowa
p
.002 w
.50994 .09126 m
.5137 .09623 L
s
P
[(1)] .50241 .08133 .75799 1 Mshowa
p
.002 w
.67932 .02494 m
.68274 .03015 L
s
P
[(2)] .6725 .0145 .65374 1 Mshowa
p
.001 w
.08779 .25656 m
.0905 .25914 L
s
P
p
.001 w
.11567 .24565 m
.11835 .24825 L
s
P
p
.001 w
.14386 .2346 m
.14652 .23724 L
s
P
p
.001 w
.17239 .22343 m
.17502 .22609 L
s
P
p
.001 w
.23048 .20069 m
.23305 .20341 L
s
P
p
.001 w
.26004 .18911 m
.26258 .19186 L
s
P
p
.001 w
.28996 .1774 m
.29247 .18017 L
s
P
p
.001 w
.32024 .16554 m
.32272 .16835 L
s
P
p
.001 w
.38192 .14139 m
.38433 .14425 L
s
P
p
.001 w
.41333 .12909 m
.4157 .13198 L
s
P
p
.001 w
.44513 .11664 m
.44747 .11956 L
s
P
p
.001 w
.47733 .10403 m
.47963 .10698 L
s
P
p
.001 w
.54296 .07833 m
.54518 .08134 L
s
P
p
.001 w
.5764 .06524 m
.57857 .06828 L
s
P
p
.001 w
.61027 .05198 m
.6124 .05505 L
s
P
p
.001 w
.64457 .03854 m
.64666 .04164 L
s
P
[(x)] .30204 .09689 .86223 1 Mshowa
P
p
p
.002 w
.67932 .02494 m
.94594 .43277 L
s
P
p
.002 w
.67932 .02494 m
.67352 .02721 L
s
P
[(-2)] .69093 .02039 -1 .39157 Mshowa
p
.002 w
.7573 .14421 m
.75144 .14634 L
s
P
[(-1)] .76901 .13994 -1 .36413 Mshowa
p
.002 w
.82692 .2507 m
.82101 .25271 L
s
P
[(0)] .83872 .24668 -1 .34028 Mshowa
p
.002 w
.88945 .34636 m
.88352 .34826 L
s
P
[(1)] .90133 .34257 -1 .31937 Mshowa
p
.002 w
.94594 .43277 m
.93997 .43456 L
s
P
[(2)] .95788 .42917 -1 .30087 Mshowa
p
.001 w
.69566 .04992 m
.69217 .05127 L
s
P
p
.001 w
.71161 .07432 m
.70811 .07565 L
s
P
p
.001 w
.72719 .09816 m
.72369 .09947 L
s
P
p
.001 w
.74242 .12145 m
.73891 .12274 L
s
P
p
.001 w
.77184 .16646 m
.76832 .16772 L
s
P
p
.001 w
.78607 .18822 m
.78254 .18947 L
s
P
p
.001 w
.79998 .2095 m
.79645 .21074 L
s
P
p
.001 w
.81359 .23032 m
.81006 .23154 L
s
P
p
.001 w
.83995 .27064 m
.83641 .27183 L
s
P
p
.001 w
.85272 .29017 m
.84917 .29135 L
s
P
p
.001 w
.86522 .30929 m
.86166 .31045 L
s
P
p
.001 w
.87746 .32802 m
.8739 .32917 L
s
P
p
.001 w
.90121 .36434 m
.89764 .36546 L
s
P
p
.001 w
.91272 .38196 m
.90915 .38307 L
s
P
p
.001 w
.92402 .39923 m
.92044 .40033 L
s
P
p
.001 w
.93508 .41616 m
.93151 .41725 L
s
P
[(y)] .89773 .2266 -1 .34028 Mshowa
P
p
p
.002 w
.06024 .26735 m
.02494 .49015 L
s
P
p
.002 w
.05735 .28563 m
.06316 .28337 L
s
P
[(0.5)] .04572 .29014 1 -0.38797 Mshowa
p
.002 w
.04862 .3407 m
.05445 .3385 L
s
P
[(1)] .03695 .3451 1 -0.37709 Mshowa
p
.002 w
.03956 .39786 m
.04541 .39572 L
s
P
[(1.5)] .02785 .40215 1 -0.36575 Mshowa
p
.002 w
.03015 .45726 m
.03602 .45518 L
s
P
[(2)] .01839 .46142 1 -0.35393 Mshowa
p
.001 w
.05563 .29648 m
.05912 .29513 L
s
P
p
.001 w
.05389 .30741 m
.05739 .30607 L
s
P
p
.001 w
.05215 .31842 m
.05564 .31709 L
s
P
p
.001 w
.05039 .32952 m
.05389 .32819 L
s
P
p
.001 w
.04683 .35196 m
.05034 .35065 L
s
P
p
.001 w
.04504 .3633 m
.04854 .362 L
s
P
p
.001 w
.04322 .37474 m
.04673 .37344 L
s
P
p
.001 w
.0414 .38626 m
.04491 .38497 L
s
P
p
.001 w
.03771 .40956 m
.04122 .40828 L
s
P
p
.001 w
.03584 .42135 m
.03936 .42008 L
s
P
p
.001 w
.03396 .43322 m
.03748 .43196 L
s
P
p
.001 w
.03206 .44519 m
.03558 .44394 L
s
P
p
.001 w
.05905 .27486 m
.06254 .2735 L
s
P
p
.001 w
.02822 .46941 m
.03175 .46817 L
s
P
p
.001 w
.02628 .48166 m
.02981 .48043 L
s
P
[(z)] -0.02691 .40064 1 -0.37036 Mshowa
P
0 0 m
1 0 L
1 .82055 L
0 .82055 L
closepath
clip
newpath
p
.002 w
.06024 .26735 m
.02494 .49015 L
s
.02494 .49015 m
.40296 .79562 L
s
.40296 .79562 m
.41001 .59401 L
s
.41001 .59401 m
.06024 .26735 L
s
.67932 .02494 m
.94594 .43277 L
s
.94594 .43277 m
.97506 .64585 L
s
.97506 .64585 m
.69286 .25814 L
s
.69286 .25814 m
.67932 .02494 L
s
.06024 .26735 m
.02494 .49015 L
s
.02494 .49015 m
.69286 .25814 L
s
.69286 .25814 m
.67932 .02494 L
s
.67932 .02494 m
.06024 .26735 L
s
.41001 .59401 m
.94594 .43277 L
s
.94594 .43277 m
.97506 .64585 L
s
.97506 .64585 m
.40296 .79562 L
s
.40296 .79562 m
.41001 .59401 L
s
P
p
.633 .79 .957 r
.0015 w
.39419 .59219 .40971 .60279 .43541 .59585 .42007 .58558 Metetra
.637 .798 .96 r
.42007 .58558 .43541 .59585 .46139 .58856 .44624 .57861 Metetra
.642 .807 .962 r
.44624 .57861 .46139 .58856 .48765 .58082 .4727 .57115 Metetra
.651 .815 .962 r
.4727 .57115 .48765 .58082 .51419 .57257 .49945 .56307 Metetra
.661 .823 .961 r
.49945 .56307 .51419 .57257 .54098 .56378 .52647 .55428 Metetra
.672 .827 .958 r
.52647 .55428 .54098 .56378 .56804 .55451 .55376 .54477 Metetra
.679 .828 .955 r
.55376 .54477 .56804 .55451 .59535 .54494 .58131 .53476 Metetra
.68 .823 .952 r
.58131 .53476 .59535 .54494 .62292 .5354 .60912 .52467 Metetra
.671 .815 .952 r
.60912 .52467 .62292 .5354 .65078 .52626 .63722 .51509 Metetra
.654 .805 .956 r
.63722 .51509 .65078 .52626 .67896 .51781 .66564 .50648 Metetra
.635 .8 .962 r
.66564 .50648 .67896 .51781 .70748 .51004 .69443 .49885 Metetra
.622 .8 .967 r
.69443 .49885 .70748 .51004 .73636 .50269 .72358 .49174 Metetra
.619 .805 .971 r
.72358 .49174 .73636 .50269 .76557 .49537 .75309 .48457 Metetra
.625 .813 .972 r
.75309 .48457 .76557 .49537 .79511 .48776 .78291 .47689 Metetra
.636 .818 .97 r
.78291 .47689 .79511 .48776 .82496 .47966 .81302 .46848 Metetra
.649 .82 .966 r
.81302 .46848 .82496 .47966 .85509 .47099 .84342 .45932 Metetra
.66 .818 .96 r
.84342 .45932 .85509 .47099 .88551 .46177 .87408 .44951 Metetra
.668 .814 .954 r
.87408 .44951 .88551 .46177 .91621 .45208 .90503 .43915 Metetra
.674 .809 .948 r
.90503 .43915 .91621 .45208 .9472 .44199 .93626 .42839 Metetra
.619 .791 .965 r
.37833 .5817 .39419 .59219 .42007 .58558 .40438 .57557 Metetra
.62 .802 .969 r
.40438 .57557 .42007 .58558 .44624 .57861 .43073 .56913 Metetra
.624 .814 .973 r
.43073 .56913 .44624 .57861 .4727 .57115 .45739 .56219 Metetra
.633 .826 .975 r
.45739 .56219 .4727 .57115 .49945 .56307 .48436 .55454 Metetra
.647 .839 .974 r
.48436 .55454 .49945 .56307 .52647 .55428 .51163 .54597 Metetra
.663 .849 .971 r
.51163 .54597 .52647 .55428 .55376 .54477 .53917 .53636 Metetra
.678 .853 .966 r
.53917 .53636 .55376 .54477 .58131 .53476 .56698 .52587 Metetra
.683 .849 .962 r
.56698 .52587 .58131 .53476 .60912 .52467 .59504 .51507 Metetra
.673 .838 .962 r
.59504 .51507 .60912 .52467 .63722 .51509 .62338 .50489 Metetra
.648 .824 .968 r
.62338 .50489 .63722 .51509 .66564 .50648 .65207 .49612 Metetra
.619 .815 .976 r
.65207 .49612 .66564 .50648 .69443 .49885 .68114 .48879 Metetra
.599 .815 .983 r
.68114 .48879 .69443 .49885 .72358 .49174 .7106 .48209 Metetra
.598 .824 .986 r
.7106 .48209 .72358 .49174 .75309 .48457 .74041 .47509 Metetra
.612 .835 .985 r
.74041 .47509 .75309 .48457 .78291 .47689 .77053 .4672 Metetra
.632 .841 .98 r
.77053 .4672 .78291 .47689 .81302 .46848 .80091 .45825 Metetra
.651 .841 .973 r
.80091 .45825 .81302 .46848 .84342 .45932 .83156 .44834 Metetra
.666 .837 .965 r
.83156 .44834 .84342 .45932 .87408 .44951 .86247 .43766 Metetra
.676 .829 .957 r
.86247 .43766 .87408 .44951 .90503 .43915 .89365 .42644 Metetra
.682 .82 .949 r
.89365 .42644 .90503 .43915 .93626 .42839 .92511 .41484 Metetra
.599 .791 .972 r
.36211 .57126 .37833 .5817 .40438 .57557 .38832 .56581 Metetra
.595 .803 .979 r
.38832 .56581 .40438 .57557 .43073 .56913 .41485 .56016 Metetra
.595 .817 .985 r
.41485 .56016 .43073 .56913 .45739 .56219 .4417 .55408 Metetra
.6 .835 .989 r
.4417 .55408 .45739 .56219 .48436 .55454 .46889 .54727 Metetra
.615 .855 .989 r
.46889 .54727 .48436 .55454 .51163 .54597 .49641 .53935 Metetra
.638 .874 .985 r
.49641 .53935 .51163 .54597 .53917 .53636 .52423 .52996 Metetra
.666 .886 .979 r
.52423 .52996 .53917 .53636 .56698 .52587 .55232 .51907 Metetra
.683 .886 .973 r
.55232 .51907 .56698 .52587 .59504 .51507 .58066 .50734 Metetra
.674 .872 .973 r
.58066 .50734 .59504 .51507 .62338 .50489 .60927 .49627 Metetra
.634 .85 .982 r
.60927 .49627 .62338 .50489 .65207 .49612 .63824 .48734 Metetra
.583 .833 .992 r
.63824 .48734 .65207 .49612 .68114 .48879 .66763 .48059 Metetra
.553 .834 .998 r
.66763 .48059 .68114 .48879 .7106 .48209 .69742 .47453 Metetra
.56 .849 .997 r
.69742 .47453 .7106 .48209 .74041 .47509 .72756 .46763 Metetra
.592 .865 .994 r
.72756 .46763 .74041 .47509 .77053 .4672 .75798 .45921 Metetra
.629 .872 .988 r
.75798 .45921 .77053 .4672 .80091 .45825 .78863 .44928 Metetra
.658 .869 .979 r
.78863 .44928 .80091 .45825 .83156 .44834 .81951 .43818 Metetra
.677 .858 .968 r
.81951 .43818 .83156 .44834 .86247 .43766 .85065 .42628 Metetra
.688 .845 .958 r
.85065 .42628 .86247 .43766 .89365 .42644 .88205 .4139 Metetra
.693 .831 .949 r
.88205 .4139 .89365 .42644 .92511 .41484 .91373 .40125 Metetra
.573 .786 .98 r
.34553 .56077 .36211 .57126 .38832 .56581 .37188 .5562 Metetra
.559 .798 .988 r
.37188 .5562 .38832 .56581 .41485 .56016 .39856 .55165 Metetra
.547 .813 .995 r
.39856 .55165 .41485 .56016 .4417 .55408 .4256 .5469 Metetra
.538 .833 .999 r
.4256 .5469 .4417 .55408 .46889 .54727 .453 .54157 Metetra
.542 .859 .997 r
.453 .54157 .46889 .54727 .49641 .53935 .48077 .53505 Metetra
.568 .889 .988 r
.48077 .53505 .49641 .53935 .52423 .52996 .50888 .52662 Metetra
.616 .918 .977 r
.50888 .52662 .52423 .52996 .55232 .51907 .53729 .51569 Metetra
.662 .932 .97 r
.53729 .51569 .55232 .51907 .58066 .50734 .56595 .50279 Metetra
.665 .92 .975 r
.56595 .50279 .58066 .50734 .60927 .49627 .59487 .49029 Metetra
.598 .884 .991 r
.59487 .49029 .60927 .49627 .63824 .48734 .62415 .48122 Metetra
.495 .843 .995 r
.62415 .48122 .63824 .48734 .66763 .48059 .6539 .47559 Metetra
.442 .836 .982 r
.6539 .47559 .66763 .48059 .69742 .47453 .68408 .47041 Metetra
.477 .865 .974 r
.68408 .47041 .69742 .47453 .72756 .46763 .71457 .46324 Metetra
.556 .899 .979 r
.71457 .46324 .72756 .46763 .75798 .45921 .74527 .45355 Metetra
.627 .911 .982 r
.74527 .45355 .75798 .45921 .78863 .44928 .77616 .44186 Metetra
.672 .902 .977 r
.77616 .44186 .78863 .44928 .81951 .43818 .80726 .42891 Metetra
.695 .882 .967 r
.80726 .42891 .81951 .43818 .85065 .42628 .8386 .4153 Metetra
.704 .861 .957 r
.8386 .4153 .85065 .42628 .88205 .4139 .8702 .40143 Metetra
.706 .842 .947 r
.8702 .40143 .88205 .4139 .91373 .40125 .9021 .3875 Metetra
.541 .775 .985 r
.32858 .55002 .34553 .56077 .37188 .5562 .35505 .54652 Metetra
.512 .784 .994 r
.35505 .54652 .37188 .5562 .39856 .55165 .38187 .5434 Metetra
.473 .793 .999 r
.38187 .5434 .39856 .55165 .4256 .5469 .40906 .54054 Metetra
.426 .803 .992 r
.40906 .54054 .4256 .5469 .453 .54157 .43664 .53758 Metetra
.38 .811 .964 r
.43664 .53758 .453 .54157 .48077 .53505 .46464 .53378 Metetra
.365 .827 .915 r
.46464 .53378 .48077 .53505 .50888 .52662 .49305 .52784 Metetra
.421 .867 .872 r
.49305 .52784 .50888 .52662 .53729 .51569 .52184 .51812 Metetra
.535 .925 .866 r
.52184 .51812 .53729 .51569 .56595 .50279 .55089 .50403 Metetra
.594 .948 .898 r
.55089 .50403 .56595 .50279 .59487 .49029 .58016 .48907 Metetra
.47 .884 .93 r
.58016 .48907 .59487 .49029 .62415 .48122 .60981 .47985 Metetra
.223 .741 .857 r
.60981 .47985 .62415 .48122 .6539 .47559 .64001 .47641 Metetra
.151 .694 .762 r
.64001 .47641 .6539 .47559 .68408 .47041 .67063 .47214 Metetra
.289 .787 .788 r
.67063 .47214 .68408 .47041 .71457 .46324 .70146 .46348 Metetra
.489 .902 .883 r
.70146 .46348 .71457 .46324 .74527 .45355 .73241 .45094 Metetra
.632 .948 .946 r
.73241 .45094 .74527 .45355 .77616 .44186 .7635 .43616 Metetra
.699 .936 .964 r
.7635 .43616 .77616 .44186 .80726 .42891 .79477 .42044 Metetra
.722 .905 .96 r
.79477 .42044 .80726 .42891 .8386 .4153 .82628 .40453 Metetra
.726 .875 .951 r
.82628 .40453 .8386 .4153 .8702 .40143 .85807 .3888 Metetra
.723 .849 .942 r
.85807 .3888 .8702 .40143 .9021 .3875 .89017 .3734 Metetra
.507 .759 .987 r
.31126 .53875 .32858 .55002 .35505 .54652 .33784 .53642 Metetra
.455 .759 .995 r
.33784 .53642 .35505 .54652 .38187 .5434 .36476 .53501 Metetra
.373 .749 .99 r
.36476 .53501 .38187 .5434 .40906 .54054 .39206 .53459 Metetra
.245 .714 .944 r
.39206 .53459 .40906 .54054 .43664 .53758 .41977 .53507 Metetra
.072 .628 .811 r
.41977 .53507 .43664 .53758 .46464 .53378 .44794 .53592 Metetra
.076 0 0 r
.44794 .53592 .46464 .53378 .49305 .52784 .47663 .53555 Metetra
.089 0 0 r
.47663 .53555 .49305 .52784 .52184 .51812 .50581 .53059 Metetra
.50581 .53059 .52184 .51812 .55089 .50403 .53538 .51685 Metetra
.53538 .51685 .55089 .50403 .58016 .48907 .56512 .49731 Metetra
.56512 .49731 .58016 .48907 .60981 .47985 .59523 .48797 Metetra
.307 0 0 r
.59523 .48797 .60981 .47985 .64001 .47641 .62603 .48889 Metetra
.242 0 0 r
.62603 .48889 .64001 .47641 .67063 .47214 .65715 .48405 Metetra
.65715 .48405 .67063 .47214 .70146 .46348 .68827 .47031 Metetra
.407 .828 .656 r
.68827 .47031 .70146 .46348 .73241 .45094 .71937 .4518 Metetra
.658 .972 .87 r
.71937 .4518 .73241 .45094 .7635 .43616 .75057 .43192 Metetra
.743 .964 .936 r
.75057 .43192 .7635 .43616 .79477 .42044 .78197 .41231 Metetra
.756 .921 .945 r
.78197 .41231 .79477 .42044 .82628 .40453 .81363 .39352 Metetra
.75 .881 .939 r
.81363 .39352 .82628 .40453 .85807 .3888 .8456 .37566 Metetra
.739 .851 .932 r
.8456 .37566 .85807 .3888 .89017 .3734 .87791 .35865 Metetra
.477 .738 .985 r
.29359 .5266 .31126 .53875 .33784 .53642 .32026 .52542 Metetra
.401 .724 .989 r
.32026 .52542 .33784 .53642 .36476 .53501 .34725 .52576 Metetra
.267 .684 .967 r
.34725 .52576 .36476 .53501 .39206 .53459 .37462 .52809 Metetra
.03 .566 .851 r
.37462 .52809 .39206 .53459 .41977 .53507 .40238 .53294 Metetra
.288 0 0 r
.40238 .53294 .41977 .53507 .44794 .53592 .43063 .54073 Metetra
.505 0 0 r
.43063 .54073 .44794 .53592 .47663 .53555 .45945 .55101 Metetra
.544 .072 .085 r
.45945 .55101 .47663 .53555 .50581 .53059 .48897 .55999 Metetra
.422 .022 .173 r
.48897 .55999 .50581 .53059 .53538 .51685 .5192 .55574 Metetra
.159 0 .123 r
.5192 .55574 .53538 .51685 .56512 .49731 .54969 .52835 Metetra
.364 0 .16 r
.54969 .52835 .56512 .49731 .59523 .48797 .58051 .51894 Metetra
.558 .163 .25 r
.58051 .51894 .59523 .48797 .62603 .48889 .6122 .52766 Metetra
.353 0 .215 r
.6122 .52766 .62603 .48889 .65715 .48405 .64375 .51311 Metetra
.037 0 0 r
.64375 .51311 .65715 .48405 .68827 .47031 .67493 .485 Metetra
.67493 .485 .68827 .47031 .71937 .4518 .70604 .45534 Metetra
.733 .988 .796 r
.70604 .45534 .71937 .4518 .75057 .43192 .73728 .42802 Metetra
.802 .975 .904 r
.73728 .42802 .75057 .43192 .78197 .41231 .76877 .40356 Metetra
.793 .92 .923 r
.76877 .40356 .78197 .41231 .81363 .39352 .80058 .38154 Metetra
.772 .876 .923 r
.80058 .38154 .81363 .39352 .8456 .37566 .83274 .36147 Metetra
.754 .845 .92 r
.83274 .36147 .8456 .37566 .87791 .35865 .86526 .34288 Metetra
.459 .716 .979 r
.27561 .51319 .29359 .5266 .32026 .52542 .30235 .51291 Metetra
.368 .69 .981 r
.30235 .51291 .32026 .52542 .34725 .52576 .32941 .51474 Metetra
.197 .621 .948 r
.32941 .51474 .34725 .52576 .37462 .52809 .3568 .51958 Metetra
0 .431 .779 r
.3568 .51958 .37462 .52809 .40238 .53294 .38456 .52884 Metetra
.514 0 0 r
.38456 .52884 .40238 .53294 .43063 .54073 .41274 .54479 Metetra
.719 .224 .064 r
.41274 .54479 .43063 .54073 .45945 .55101 .44144 .57101 Metetra
.757 .359 .298 r
.44144 .57101 .45945 .55101 .48897 .55999 .47092 .6116 Metetra
.511 .172 .329 r
.47092 .6116 .48897 .55999 .5192 .55574 .50197 .61205 Metetra
.45 .124 .32 r
.50197 .61205 .5192 .55574 .54969 .52835 .53356 .60283 Metetra
.478 .176 .376 r
.53356 .60283 .54969 .52835 .58051 .51894 .56553 .59349 Metetra
.478 .176 .376 r
.56553 .59349 .58051 .51894 .6122 .52766 .59789 .58404 Metetra
.378 .061 .295 r
.59789 .58404 .6122 .52766 .64375 .51311 .63033 .56475 Metetra
0 0 .088 r
.63033 .56475 .64375 .51311 .67493 .485 .66119 .50432 Metetra
.622 .827 .425 r
.66119 .50432 .67493 .485 .70604 .45534 .69216 .45808 Metetra
.858 .997 .782 r
.69216 .45808 .70604 .45534 .73728 .42802 .72343 .42203 Metetra
.855 .952 .876 r
.72343 .42203 .73728 .42802 .76877 .40356 .75505 .39264 Metetra
.819 .896 .897 r
.75505 .39264 .76877 .40356 .80058 .38154 .78704 .36764 Metetra
.787 .857 .903 r
.78704 .36764 .80058 .38154 .83274 .36147 .81942 .34561 Metetra
.763 .83 .904 r
.81942 .34561 .83274 .36147 .86526 .34288 .85219 .32567 Metetra
.459 .697 .97 r
.25733 .49818 .27561 .51319 .30235 .51291 .28417 .49836 Metetra
.37 .664 .971 r
.28417 .49836 .30235 .51291 .32941 .51474 .3113 .501 Metetra
.203 .588 .944 r
.3113 .501 .32941 .51474 .3568 .51958 .33873 .50734 Metetra
0 .392 .8 r
.33873 .50734 .3568 .51958 .38456 .52884 .36647 .51947 Metetra
.561 0 0 r
.36647 .51947 .38456 .52884 .41274 .54479 .39453 .54141 Metetra
.81 .334 .077 r
.39453 .54141 .41274 .54479 .44144 .57101 .42293 .58183 Metetra
.673 .196 .111 r
.42293 .58183 .44144 .57101 .47092 .6116 .45301 .60425 Metetra
.587 .873 .994 r
.45301 .60425 .47092 .6116 .50197 .61205 .48446 .59493 Metetra
.645 .763 .934 r
.48446 .59493 .50197 .61205 .53356 .60283 .5163 .5855 Metetra
.645 .763 .934 r
.5163 .5855 .53356 .60283 .56553 .59349 .54852 .57595 Metetra
.645 .763 .934 r
.54852 .57595 .56553 .59349 .59789 .58404 .58115 .56628 Metetra
.645 .763 .934 r
.58115 .56628 .59789 .58404 .63033 .56475 .61418 .55649 Metetra
.91 .893 .8 r
.61418 .55649 .63033 .56475 .66119 .50432 .64638 .51424 Metetra
.938 .95 .628 r
.64638 .51424 .66119 .50432 .69216 .45808 .67739 .45313 Metetra
.924 .933 .793 r
.67739 .45313 .69216 .45808 .72343 .42203 .70882 .41054 Metetra
.868 .886 .846 r
.70882 .41054 .72343 .42203 .75505 .39264 .74067 .37778 Metetra
.822 .85 .869 r
.74067 .37778 .75505 .39264 .78704 .36764 .77292 .35081 Metetra
.789 .826 .881 r
.77292 .35081 .78704 .36764 .81942 .34561 .80558 .32751 Metetra
.764 .808 .888 r
.80558 .32751 .81942 .34561 .85219 .32567 .83864 .30666 Metetra
.476 .683 .957 r
.2388 .48135 .25733 .49818 .28417 .49836 .26575 .48139 Metetra
.404 .651 .958 r
.26575 .48139 .28417 .49836 .3113 .501 .29299 .4839 Metetra
.281 .587 .945 r
.29299 .4839 .3113 .501 .33873 .50734 .32052 .49012 Metetra
.053 .449 .878 r
.32052 .49012 .33873 .50734 .36647 .51947 .34832 .50216 Metetra
0 .157 .648 r
.34832 .50216 .36647 .51947 .39453 .54141 .3764 .52406 Metetra
.735 .243 0 r
.3764 .52406 .39453 .54141 .42293 .58183 .40473 .56456 Metetra
0 .184 .671 r
.40473 .56456 .42293 .58183 .45301 .60425 .43486 .58696 Metetra
.645 .763 .934 r
.43486 .58696 .45301 .60425 .48446 .59493 .46655 .57742 Metetra
.645 .763 .934 r
.46655 .57742 .48446 .59493 .5163 .5855 .49864 .56777 Metetra
.645 .763 .934 r
.49864 .56777 .5163 .5855 .54852 .57595 .53113 .558 Metetra
.645 .763 .934 r
.53113 .558 .54852 .57595 .58115 .56628 .56402 .54811 Metetra
.645 .763 .934 r
.56402 .54811 .58115 .56628 .61418 .55649 .59734 .53809 Metetra
.872 .803 .78 r
.59734 .53809 .61418 .55649 .64638 .51424 .62998 .49542 Metetra
.916 .794 .712 r
.62998 .49542 .64638 .51424 .67739 .45313 .6615 .43379 Metetra
.875 .801 .774 r
.6615 .43379 .67739 .45313 .70882 .41054 .69337 .3908 Metetra
.836 .8 .816 r
.69337 .3908 .70882 .41054 .74067 .37778 .7256 .35769 Metetra
.804 .794 .843 r
.7256 .35769 .74067 .37778 .77292 .35081 .75821 .33039 Metetra
.778 .788 .861 r
.75821 .33039 .77292 .35081 .80558 .32751 .79121 .30678 Metetra
.758 .782 .873 r
.79121 .30678 .80558 .32751 .83864 .30666 .8246 .28563 Metetra
.504 .675 .941 r
.22002 .46267 .2388 .48135 .26575 .48139 .24714 .46196 Metetra
.456 .647 .94 r
.24714 .46196 .26575 .48139 .29299 .4839 .27454 .46338 Metetra
.384 .601 .933 r
.27454 .46338 .29299 .4839 .32052 .49012 .30225 .46784 Metetra
.277 .524 .908 r
.30225 .46784 .32052 .49012 .34832 .50216 .33026 .47678 Metetra
.124 .398 .85 r
.33026 .47678 .34832 .50216 .3764 .52406 .3586 .49253 Metetra
0 .227 .745 r
.3586 .49253 .3764 .52406 .40473 .56456 .38732 .51871 Metetra
0 .102 .643 r
.38732 .51871 .40473 .56456 .43486 .58696 .41661 .55953 Metetra
.521 .612 .884 r
.41661 .55953 .43486 .58696 .46655 .57742 .44823 .55951 Metetra
.645 .763 .934 r
.44823 .55951 .46655 .57742 .49864 .56777 .48057 .54964 Metetra
.645 .763 .934 r
.48057 .54964 .49864 .56777 .53113 .558 .51333 .53964 Metetra
.645 .763 .934 r
.51333 .53964 .53113 .558 .56402 .54811 .54649 .52951 Metetra
.752 .793 .886 r
.54649 .52951 .56402 .54811 .59734 .53809 .57991 .50936 Metetra
.877 .737 .703 r
.57991 .50936 .59734 .53809 .62998 .49542 .61236 .44737 Metetra
.784 .637 .698 r
.61236 .44737 .62998 .49542 .6615 .43379 .64468 .39984 Metetra
.795 .693 .752 r
.64468 .39984 .6615 .43379 .69337 .3908 .67715 .36268 Metetra
.788 .726 .794 r
.67715 .36268 .69337 .3908 .7256 .35769 .70987 .33228 Metetra
.775 .743 .824 r
.70987 .33228 .7256 .35769 .75821 .33039 .74291 .30632 Metetra
.76 .752 .846 r
.74291 .30632 .75821 .33039 .79121 .30678 .77631 .28338 Metetra
.746 .756 .861 r
.77631 .28338 .79121 .30678 .8246 .28563 .81009 .26254 Metetra
.535 .671 .925 r
.20101 .4423 .22002 .46267 .24714 .46196 .22832 .44036 Metetra
.507 .648 .92 r
.22832 .44036 .24714 .46196 .27454 .46338 .25595 .43998 Metetra
.473 .615 .91 r
.25595 .43998 .27454 .46338 .30225 .46784 .28391 .44161 Metetra
.436 .57 .89 r
.28391 .44161 .30225 .46784 .33026 .47678 .31224 .44582 Metetra
.407 .514 .855 r
.31224 .44582 .33026 .47678 .3586 .49253 .341 .45303 Metetra
.413 .461 .801 r
.341 .45303 .3586 .49253 .38732 .51871 .37032 .46279 Metetra
.476 .433 .73 r
.37032 .46279 .38732 .51871 .41661 .55953 .40043 .47121 Metetra
.57 .436 .659 r
.40043 .47121 .41661 .55953 .44823 .55951 .43169 .46603 Metetra
.651 .487 .648 r
.43169 .46603 .44823 .55951 .48057 .54964 .4639 .43706 Metetra
.581 .423 .633 r
.4639 .43706 .48057 .54964 .51333 .53964 .49595 .42654 Metetra
.515 .377 .632 r
.49595 .42654 .51333 .53964 .54649 .52951 .52843 .43463 Metetra
.607 .456 .652 r
.52843 .43463 .54649 .52951 .57991 .50936 .56143 .4188 Metetra
.655 .493 .652 r
.56143 .4188 .57991 .50936 .61236 .44737 .59442 .38904 Metetra
.706 .571 .7 r
.59442 .38904 .61236 .44737 .64468 .39984 .62736 .35769 Metetra
.735 .633 .746 r
.62736 .35769 .64468 .39984 .67715 .36268 .66039 .32874 Metetra
.745 .677 .785 r
.66039 .32874 .67715 .36268 .70987 .33228 .69362 .3027 Metetra
.745 .705 .814 r
.69362 .3027 .70987 .33228 .74291 .30632 .72712 .27917 Metetra
.739 .723 .837 r
.72712 .27917 .74291 .30632 .77631 .28338 .76094 .25761 Metetra
.732 .734 .853 r
.76094 .25761 .77631 .28338 .81009 .26254 .79512 .23755 Metetra
.563 .671 .911 r
.18174 .42053 .20101 .4423 .22832 .44036 .20928 .4171 Metetra
.549 .652 .903 r
.20928 .4171 .22832 .44036 .25595 .43998 .23717 .41459 Metetra
.536 .627 .889 r
.23717 .41459 .25595 .43998 .28391 .44161 .26544 .41309 Metetra
.528 .598 .867 r
.26544 .41309 .28391 .44161 .31224 .44582 .29413 .41251 Metetra
.531 .565 .835 r
.29413 .41251 .31224 .44582 .341 .45303 .32332 .41229 Metetra
.552 .535 .79 r
.32332 .41229 .341 .45303 .37032 .46279 .35313 .41078 Metetra
.59 .514 .738 r
.35313 .41078 .37032 .46279 .40043 .47121 .38369 .4045 Metetra
.628 .503 .692 r
.38369 .4045 .40043 .47121 .43169 .46603 .41504 .3891 Metetra
.641 .497 .671 r
.41504 .3891 .43169 .46603 .4639 .43706 .44682 .36768 Metetra
.602 .483 .69 r
.44682 .36768 .4639 .43706 .49595 .42654 .47861 .35678 Metetra
.544 .446 .694 r
.47861 .35678 .49595 .42654 .52843 .43463 .51075 .3565 Metetra
.574 .453 .677 r
.51075 .3565 .52843 .43463 .56143 .4188 .54349 .35022 Metetra
.624 .501 .692 r
.54349 .35022 .56143 .4188 .59442 .38904 .57658 .33469 Metetra
.667 .558 .723 r
.57658 .33469 .59442 .38904 .62736 .35769 .60986 .31422 Metetra
.696 .61 .757 r
.60986 .31422 .62736 .35769 .66039 .32874 .64331 .29232 Metetra
.712 .652 .788 r
.64331 .29232 .66039 .32874 .69362 .3027 .67698 .27067 Metetra
.719 .682 .813 r
.67698 .27067 .69362 .3027 .72712 .27917 .7109 .24986 Metetra
.72 .703 .834 r
.7109 .24986 .72712 .27917 .76094 .25761 .74514 .22998 Metetra
.717 .718 .849 r
.74514 .22998 .76094 .25761 .79512 .23755 .77973 .21096 Metetra
.587 .673 .899 r
.16218 .3977 .18174 .42053 .20928 .4171 .18997 .39272 Metetra
.582 .658 .89 r
.18997 .39272 .20928 .4171 .23717 .41459 .21814 .38811 Metetra
.579 .64 .875 r
.21814 .38811 .23717 .41459 .26544 .41309 .24671 .38374 Metetra
.581 .619 .855 r
.24671 .38374 .26544 .41309 .29413 .41251 .27575 .37924 Metetra
.591 .598 .827 r
.27575 .37924 .29413 .41251 .32332 .41229 .30531 .37383 Metetra
.609 .578 .794 r
.30531 .37383 .32332 .41229 .35313 .41078 .33546 .36617 Metetra
.633 .565 .76 r
.33546 .36617 .35313 .41078 .38369 .4045 .36624 .35452 Metetra
.653 .558 .735 r
.36624 .35452 .38369 .4045 .41504 .3891 .39758 .33829 Metetra
.656 .558 .732 r
.39758 .33829 .41504 .3891 .44682 .36768 .42921 .32112 Metetra
.626 .556 .756 r
.42921 .32112 .44682 .36768 .47861 .35678 .46097 .30991 Metetra
.58 .531 .764 r
.46097 .30991 .47861 .35678 .51075 .3565 .49307 .3047 Metetra
.583 .517 .745 r
.49307 .3047 .51075 .3565 .54349 .35022 .5257 .2986 Metetra
.615 .536 .743 r
.5257 .2986 .54349 .35022 .57658 .33469 .55881 .28787 Metetra
.647 .572 .757 r
.55881 .28787 .57658 .33469 .60986 .31422 .59228 .27307 Metetra
.672 .61 .778 r
.59228 .27307 .60986 .31422 .64331 .29232 .62602 .2559 Metetra
.689 .644 .799 r
.62602 .2559 .64331 .29232 .67698 .27067 .66004 .23772 Metetra
.699 .671 .819 r
.66004 .23772 .67698 .27067 .7109 .24986 .69435 .21932 Metetra
.703 .691 .836 r
.69435 .21932 .7109 .24986 .74514 .22998 .72897 .20107 Metetra
.704 .706 .849 r
.72897 .20107 .74514 .22998 .77973 .21096 .76395 .18314 Metetra
.607 .678 .891 r
.1423 .37416 .16218 .3977 .18997 .39272 .17034 .36771 Metetra
.606 .665 .882 r
.17034 .36771 .18997 .39272 .21814 .38811 .19878 .36124 Metetra
.608 .652 .868 r
.19878 .36124 .21814 .38811 .24671 .38374 .22765 .35454 Metetra
.613 .638 .851 r
.22765 .35454 .24671 .38374 .27575 .37924 .25699 .34718 Metetra
.624 .624 .83 r
.25699 .34718 .27575 .37924 .30531 .37383 .28684 .33855 Metetra
.638 .612 .807 r
.28684 .33855 .30531 .37383 .33546 .36617 .31723 .32785 Metetra
.654 .605 .787 r
.31723 .32785 .33546 .36617 .36624 .35452 .34816 .3145 Metetra
.665 .603 .776 r
.34816 .3145 .36624 .35452 .39758 .33829 .37951 .29904 Metetra
.664 .607 .782 r
.37951 .29904 .39758 .33829 .42921 .32112 .41113 .28397 Metetra
.64 .608 .802 r
.41113 .28397 .42921 .32112 .46097 .30991 .44297 .27246 Metetra
.607 .591 .81 r
.44297 .27246 .46097 .30991 .49307 .3047 .47515 .26453 Metetra
.6 .575 .798 r
.47515 .26453 .49307 .3047 .5257 .2986 .50781 .25704 Metetra
.616 .578 .789 r
.50781 .25704 .5257 .2986 .55881 .28787 .54098 .24742 Metetra
.638 .597 .791 r
.54098 .24742 .55881 .28787 .59228 .27307 .57458 .2351 Metetra
.658 .621 .802 r
.57458 .2351 .59228 .27307 .62602 .2559 .60854 .22064 Metetra
.673 .646 .815 r
.60854 .22064 .62602 .2559 .66004 .23772 .64285 .20482 Metetra
.683 .668 .829 r
.64285 .20482 .66004 .23772 .69435 .21932 .67749 .18827 Metetra
.69 .686 .841 r
.67749 .18827 .69435 .21932 .72897 .20107 .71247 .17139 Metetra
.693 .7 .852 r
.71247 .17139 .72897 .20107 .76395 .18314 .74782 .15443 Metetra
.622 .683 .886 r
.12205 .35017 .1423 .37416 .17034 .36771 .15034 .34242 Metetra
.623 .673 .877 r
.15034 .34242 .17034 .36771 .19878 .36124 .17903 .33441 Metetra
.627 .664 .866 r
.17903 .33441 .19878 .36124 .22765 .35454 .20817 .32592 Metetra
.634 .654 .852 r
.20817 .32592 .22765 .35454 .25699 .34718 .23777 .31661 Metetra
.643 .645 .837 r
.23777 .31661 .25699 .34718 .28684 .33855 .26787 .30608 Metetra
.654 .639 .823 r
.26787 .30608 .28684 .33855 .31723 .32785 .29845 .29395 Metetra
.665 .636 .812 r
.29845 .29395 .31723 .32785 .34816 .3145 .32949 .28018 Metetra
.671 .638 .809 r
.32949 .28018 .34816 .3145 .37951 .29904 .36091 .26548 Metetra
.666 .642 .817 r
.36091 .26548 .37951 .29904 .41113 .28397 .39262 .25144 Metetra
.648 .643 .831 r
.39262 .25144 .41113 .28397 .44297 .27246 .42459 .23964 Metetra
.624 .632 .838 r
.42459 .23964 .44297 .27246 .47515 .26453 .45691 .23009 Metetra
.615 .619 .832 r
.45691 .23009 .47515 .26453 .50781 .25704 .48968 .22122 Metetra
.622 .615 .823 r
.48968 .22122 .50781 .25704 .54098 .24742 .52295 .21142 Metetra
.636 .623 .821 r
.52295 .21142 .54098 .24742 .57458 .2351 .55669 .19996 Metetra
.65 .637 .824 r
.55669 .19996 .57458 .2351 .60854 .22064 .59085 .18685 Metetra
.663 .654 .831 r
.59085 .18685 .60854 .22064 .64285 .20482 .62541 .17244 Metetra
.673 .671 .84 r
.62541 .17244 .64285 .20482 .67749 .18827 .66034 .15715 Metetra
.679 .685 .848 r
.66034 .15715 .67749 .18827 .71247 .17139 .69565 .14129 Metetra
.683 .697 .857 r
.69565 .14129 .71247 .17139 .74782 .15443 .73135 .1251 Metetra
.633 .688 .884 r
.10139 .3259 .12205 .35017 .15034 .34242 .12992 .31705 Metetra
.636 .681 .876 r
.12992 .31705 .15034 .34242 .17903 .33441 .15886 .30782 Metetra
.64 .675 .867 r
.15886 .30782 .17903 .33441 .20817 .32592 .18824 .29801 Metetra
.646 .668 .857 r
.18824 .29801 .20817 .32592 .23777 .31661 .21808 .2874 Metetra
.654 .663 .846 r
.21808 .2874 .23777 .31661 .26787 .30608 .24838 .27575 Metetra
.662 .66 .837 r
.24838 .27575 .26787 .30608 .29845 .29395 .27913 .26295 Metetra
.669 .66 .832 r
.27913 .26295 .29845 .29395 .32949 .28018 .3103 .24915 Metetra
.672 .663 .833 r
.3103 .24915 .32949 .28018 .36091 .26548 .34183 .23498 Metetra
.667 .666 .84 r
.34183 .23498 .36091 .26548 .39262 .25144 .37366 .22142 Metetra
.652 .666 .851 r
.37366 .22142 .39262 .25144 .42459 .23964 .40579 .20932 Metetra
.636 .659 .856 r
.40579 .20932 .42459 .23964 .45691 .23009 .43828 .1987 Metetra
.627 .649 .853 r
.43828 .1987 .45691 .23009 .48968 .22122 .47122 .1887 Metetra
.628 .644 .847 r
.47122 .1887 .48968 .22122 .52295 .21142 .50464 .17833 Metetra
.637 .646 .843 r
.50464 .17833 .52295 .21142 .55669 .19996 .53854 .16694 Metetra
.647 .654 .843 r
.53854 .16694 .55669 .19996 .59085 .18685 .57289 .15436 Metetra
.657 .665 .846 r
.57289 .15436 .59085 .18685 .62541 .17244 .60769 .1407 Metetra
.665 .676 .851 r
.60769 .1407 .62541 .17244 .66034 .15715 .6429 .12616 Metetra
.672 .687 .856 r
.6429 .12616 .66034 .15715 .69565 .14129 .67852 .11098 Metetra
.676 .697 .862 r
.67852 .11098 .69565 .14129 .73135 .1251 .71455 .09534 Metetra
.642 .694 .883 r
.08029 .30147 .10139 .3259 .12992 .31705 .10905 .29171 Metetra
.645 .689 .877 r
.10905 .29171 .12992 .31705 .15886 .30782 .13822 .28152 Metetra
.649 .684 .869 r
.13822 .28152 .15886 .30782 .18824 .29801 .16782 .27074 Metetra
.655 .68 .862 r
.16782 .27074 .18824 .29801 .21808 .2874 .19787 .25925 Metetra
.661 .678 .855 r
.19787 .25925 .21808 .2874 .24838 .27575 .22836 .24693 Metetra
.667 .677 .85 r
.22836 .24693 .24838 .27575 .27913 .26295 .25928 .23379 Metetra
.671 .678 .848 r
.25928 .23379 .27913 .26295 .3103 .24915 .29059 .22004 Metetra
.672 .681 .85 r
.29059 .22004 .3103 .24915 .34183 .23498 .32226 .20616 Metetra
.666 .683 .856 r
.32226 .20616 .34183 .23498 .37366 .22142 .35425 .19278 Metetra
.655 .683 .864 r
.35425 .19278 .37366 .22142 .40579 .20932 .38657 .18039 Metetra
.643 .678 .868 r
.38657 .18039 .40579 .20932 .43828 .1987 .41926 .16898 Metetra
.635 .671 .867 r
.41926 .16898 .43828 .1987 .47122 .1887 .45238 .15808 Metetra
.635 .666 .863 r
.45238 .15808 .47122 .1887 .50464 .17833 .48598 .14705 Metetra
.639 .665 .859 r
.48598 .14705 .50464 .17833 .53854 .16694 .52007 .13539 Metetra
.646 .669 .857 r
.52007 .13539 .53854 .16694 .57289 .15436 .55463 .12288 Metetra
.654 .675 .858 r
.55463 .12288 .57289 .15436 .60769 .1407 .58966 .10951 Metetra
.66 .683 .86 r
.58966 .10951 .60769 .1407 .6429 .12616 .62513 .09535 Metetra
.666 .691 .864 r
.62513 .09535 .6429 .12616 .67852 .11098 .66105 .08055 Metetra
.67 .699 .868 r
.66105 .08055 .67852 .11098 .71455 .09534 .6974 .06525 Metetra
.648 .699 .883 r
.05872 .27693 .08029 .30147 .10905 .29171 .0877 .26641 Metetra
.652 .696 .878 r
.0877 .26641 .10905 .29171 .13822 .28152 .11709 .25546 Metetra
.655 .693 .873 r
.11709 .25546 .13822 .28152 .16782 .27074 .1469 .24397 Metetra
.66 .69 .868 r
.1469 .24397 .16782 .27074 .19787 .25925 .17715 .23186 Metetra
.665 .689 .863 r
.17715 .23186 .19787 .25925 .22836 .24693 .20782 .2191 Metetra
.669 .689 .86 r
.20782 .2191 .22836 .24693 .25928 .23379 .23891 .20576 Metetra
.671 .691 .86 r
.23891 .20576 .25928 .23379 .29059 .22004 .27038 .19203 Metetra
.671 .693 .863 r
.27038 .19203 .29059 .22004 .32226 .20616 .30221 .17828 Metetra
.666 .695 .868 r
.30221 .17828 .32226 .20616 .35425 .19278 .33437 .16491 Metetra
.657 .694 .873 r
.33437 .16491 .35425 .19278 .38657 .18039 .36689 .1522 Metetra
.648 .691 .876 r
.36689 .1522 .38657 .18039 .41926 .16898 .3998 .14018 Metetra
.642 .686 .876 r
.3998 .14018 .41926 .16898 .45238 .15808 .43313 .12853 Metetra
.64 .681 .873 r
.43313 .12853 .45238 .15808 .48598 .14705 .46694 .11685 Metetra
.642 .68 .87 r
.46694 .11685 .48598 .14705 .52007 .13539 .50124 .10478 Metetra
.647 .681 .868 r
.50124 .10478 .52007 .13539 .55463 .12288 .53602 .09209 Metetra
.652 .685 .868 r
.53602 .09209 .55463 .12288 .58966 .10951 .57129 .07871 Metetra
.657 .69 .869 r
.57129 .07871 .58966 .10951 .62513 .09535 .60703 .06467 Metetra
.662 .696 .871 r
.60703 .06467 .62513 .09535 .66105 .08055 .64323 .05002 Metetra
.666 .701 .873 r
.64323 .05002 .66105 .08055 .6974 .06525 .6799 .03486 Metetra
P
p
.002 w
.67932 .02494 m
.94594 .43277 L
s
.94594 .43277 m
.97506 .64585 L
s
.97506 .64585 m
.69286 .25814 L
s
.69286 .25814 m
.67932 .02494 L
s
.06024 .26735 m
.02494 .49015 L
s
.02494 .49015 m
.69286 .25814 L
s
.69286 .25814 m
.67932 .02494 L
s
.67932 .02494 m
.06024 .26735 L
s
P
p
p
.002 w
.06024 .26735 m
.67932 .02494 L
s
P
p
.002 w
.06024 .26735 m
.0648 .2716 L
s
P
[(-2)] .05113 .25884 1 .93395 Mshowa
p
.002 w
.20126 .21213 m
.2056 .21661 L
s
P
[(-1)] .1926 .20316 .96648 1 Mshowa
p
.002 w
.35089 .15354 m
.35496 .15826 L
s
P
[(0)] .34275 .1441 .86223 1 Mshowa
p
.002 w
.50994 .09126 m
.5137 .09623 L
s
P
[(1)] .50241 .08133 .75799 1 Mshowa
p
.002 w
.67932 .02494 m
.68274 .03015 L
s
P
[(2)] .6725 .0145 .65374 1 Mshowa
p
.001 w
.08779 .25656 m
.0905 .25914 L
s
P
p
.001 w
.11567 .24565 m
.11835 .24825 L
s
P
p
.001 w
.14386 .2346 m
.14652 .23724 L
s
P
p
.001 w
.17239 .22343 m
.17502 .22609 L
s
P
p
.001 w
.23048 .20069 m
.23305 .20341 L
s
P
p
.001 w
.26004 .18911 m
.26258 .19186 L
s
P
p
.001 w
.28996 .1774 m
.29247 .18017 L
s
P
p
.001 w
.32024 .16554 m
.32272 .16835 L
s
P
p
.001 w
.38192 .14139 m
.38433 .14425 L
s
P
p
.001 w
.41333 .12909 m
.4157 .13198 L
s
P
p
.001 w
.44513 .11664 m
.44747 .11956 L
s
P
p
.001 w
.47733 .10403 m
.47963 .10698 L
s
P
p
.001 w
.54296 .07833 m
.54518 .08134 L
s
P
p
.001 w
.5764 .06524 m
.57857 .06828 L
s
P
p
.001 w
.61027 .05198 m
.6124 .05505 L
s
P
p
.001 w
.64457 .03854 m
.64666 .04164 L
s
P
[(x)] .30204 .09689 .86223 1 Mshowa
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{388, 317},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageRegion->{{-0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000640001?B000`400?l00000o`00003ooooooon5
ooooo`00oooooon5ooooo`00oooooon5ooooo`00oooooon5ooooo`00oooooon5ooooo`00oooooon5
ooooo`00ooooool5ooooo`Go0000Noooool00?oooooo1_ooool01?l0003oooooooooool0001koooo
o`00ooooool7ooooo`03o`000?oooooooooo07_ooooo003oooooo`Sooooo00?o0000ooooooooool0
N_ooool00?oooooo1Oooool01Ol0003ooooooooooooooooo000007_ooooo003oooooo`Gooooo00Go
0000ooooooooooooooooo`00001kooooo`00ooooool6ooooo`?o00003_ooool5o`0006Wooooo003o
oooooaSooooo00Co0000oooooooooooo0000JOooool00?oooooo4Oooool5o`0000?ooooo00?o0000
ooooooooool0JOooool00?oooooo6_ooool00ol0003oooooooooo`1Xooooo`00oooooolGooooo`05
o`000?ooooooooooooooool00000JOooool00?oooooo5oooool01Ol0003ooooooooooooooooo0000
06Wooooo003oooooo`cooooo0_l0000:ooooo`?o0000J_ooool00?oooooo2Oooool3o`000003oooo
ool0003ooooo07Kooooo003oooooo`Oooooo0_l00004ooooo`;o0000M_ooool00?oooooo1?ooool3
o`0000Kooooo00?o0000ooooool00000MOooool00?oooooo0Oooool3o`0000Sooooo0_l000000ooo
oooo0000ooooo`1dooooo`00o_ooool2o`0000Sooooo0ol000001OnZ/moo0000oooooooooooo0000
07Cooooo003kooooo`?o000000?oooooo`000?ooool01Oooool2o`0000CoZ[?O0_l00002ooooo`03
o`000?oooooooooo077ooooo003iooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`;o0000
1_nZ/ml2o`0000;ooooo00?o0000ooooooooool0LOooool00?Kooooo0ol00008ooooo`?o00002?nZ
/ml00ol0003oZ[?Oo`000002ooooo`03o`000?oooooooooo073ooooo003dooooo`;o00002Oooool2
o`0000_oZ[?O00?o0000ojZcgol000000_ooool00ol0003oooooooooo`1`ooooo`00lOooool3o`00
00Wooooo0_l0000>ojZcg`03o`000?nZ/moo000000?o0000LOooool00>oooooo0_l000000ooooooo
0000ooooo`06ooooo`?o000000?oZK;No`000?nZ/ml03OnZ/ml01?l0003oZ[?OojZcgol00002oooo
o`03o`000?oooooooooo06kooooo003/ooooo`?o00001?ooool01?l0003oooooooooooooool3o`00
00GoZK;N00?o0000ojZcgonZ/ml02onZ/ml01?l0003oZ[?OojZcgol00002ooooo`03o`000?oooooo
oooo06kooooo0036ooooo`?o00008?ooool3o`0000Wooooo0_l00009ojVbgP03o`000?nZ/mooZ[?O
00[oZ[?O00Go0000ojZcgonZ/mooZ[?Oo`000002ooooo`03o`000?oooooooooo06gooooo0037oooo
o`03o`000?oooooooooo01gooooo0_l00009ooooo`?o00002onY/]h00ol0003oZ[?OojZcg`0:ojZc
g`05o`000?nZ/mooZ[?OojZcgol000000oooool00ol0003oooooooooo`1/ooooo`00aoooool00ol0
003oooooooooo`0Jooooo`?o00002Oooool2o`0000ooZK;N00?o0000ojZcgonZ/ml02OnZ/ml01?l0
003oZ[?OojZcgonZ/ml2o`0000;ooooo00?o0000ooooooooool0K?ooool00<Oooooo00?o0000oooo
ooooool06?ooool2o`0000;ooooo00?o0000ooooooooool01?ooool3o`000003ojR`g_l0003oZK;N
00ooZK;N00?o0000ojZcgonZ/ml02?nZ/ml01_l0003oZ[?Oo`000?l0003oZk;No`0000?ooooo00?o
0000ooooooooool0Joooool00<Oooooo00?o0000ooooooooool05Oooool3o`0000Sooooo0ol00005
ojR`gP03o`000?nY/]koZK;N00goZK;N00?o0000ojZcgonZ/ml02?nZ/ml2o`0000CoZk;N00Go0000
ooooooooooooooooo`00001/ooooo`00a_ooool2o`0001Gooooo0_l00008ooooo`?o00002?nX/=h0
0ol0003oZK;NojVbgP0>ojVbgP03o`000?nZ/mooZ[?O00CoZ[?O1?l00006oj^bgP04o`000?oooooo
ooooo`0006cooooo001jooooo`;o000000?oooooo`000?l00000B?ooool00ol0003oooooooooo`0@
ooooo`?o00001oooool3o`0000coZ;3N00?o0000ojVbg_nY/]h03OnY/]h00ol0003oZ[?OojZcg`02
ojZcg`;o00000on[/]h00ol0003oZk;Noj^bgP04oj^bgP03o`000?oooooo000000;o0000Joooool0
07_ooooo00?o0000ooooool00000F_ooool2o`0000Sooooo0_l0000?ojR`gP03o`000?nY/]koZK;N
00koZK;N00Co0000ojZcgol0003o00001On[/]h00ol0003oZk;Noj^bgP05oj^bgP05o`000?oooooo
ooooooooool00000J_ooool007cooooo00?o0000ooooooooool0E_ooool3o`0000;ooooo00?o0000
ooooooooool00_ooool3o`000003ojJ_g_l0003oZ;3N00ooZ;3N00?o0000ojVbg_nY/]h03OnY/]h2
o`0000OoZk;N00?o0000oj^bg_n[/]h01_n[/]h01?l0003oooooooooool0001Zooooo`00Noooool0
0ol0003oooooo`00001Dooooo`?o00001oooool3o`0000GoYZoN00?o0000ojR`g_nX/=h03_nX/=h0
0ol0003oZK;NojVbgP09ojVbgP?o000000?oZ[3Mo`000?n[/]h01_n[/]h00ol0003oZk;Noj^bgP06
oj^bgP05o`000?ooooooooooooooool00000JOooool007[ooooo0_l000000ooooooo0000o`00001A
ooooo`;o00002?ooool2o`0000SoYZoN00?o0000ojR`g_nX/=h03_nX/=h00ol0003oZK;NojVbgP06
ojVbgP?o00001OnZ/=d00ol0003oZk;Noj^bgP04oj^bgP03o`000?n[/]koZk;N00OoZk;N00Go0000
ooooooooooooooooo`00001Xooooo`00cOooool3o`0000Oooooo0ol0000;ojJ_gP03o`000?nX/=ko
Z;3N00koZ;3N00?o0000ojVbg_nY/]h00_nY/]h3o`0000SoZ[3M00?o0000oj^bg_n[/]h01?n[/]h0
0ol0003oZk;Noj^bgP07oj^bgP05o`000?ooooooooooooooool00000J?ooool00<_ooooo0ol00007
ooooo`;o00003onV[mh00ol0003oZ;3NojR`gP0=ojR`gP03o`000?nY/]ko000000;o00003?nZ/=d0
0ol0003oZk;Noj^bgP03oj^bgP03o`000?n[/]koZk;N00SoZk;N00Go0000ooooooooooooooooo`00
001Wooooo`00b?ooool3o`0000;ooooo00?o0000ooooooooool00_ooool3o`000003ojF^g_l0003o
YZoN00koYZoN00?o0000ojR`g_nX/=h03OnX/=h2o`0000ooZ[3M00?o0000oj^bg_n[/]h00on[/]h0
0ol0003oZk;Noj^bgP08oj^bgP;o00000_ooool00ol0003oooooooooo`1Uooooo`00a_ooool2o`00
00Kooooo1?l00005ojF^gP03o`000?nV[mkoYZoN00goYZoN00?o0000ojR`g_nX/=h02_nX/=h2o`00
0003ojR^g?l0003oZ[3M00ooZ[3M00?o0000oj^bg_n[/]h00on[/]h00ol0003oZk;Noj^bgP04oj^b
gP?o000000?o[K;Lo`000?ooool00_ooool00ol0003oooooooooo`1Tooooo`00`oooool3o`0000Oo
oooo0_l00008ojF^gP03o`000?nV[mkoYZoN00goYZoN00?o0000ojR`g_nX/=h02?nX/=h2o`0000Co
Z:kL00?o0000ojZ`gOnZ/=d03_nZ/=d00ol0003oZk;Noj^bgP02oj^bgP03o`000?n[/]koZk;N00;o
Zk;N0_l00005ojfbg003o`000?oooooo000000;o0000IOooool00<7ooooo0_l00007ooooo`?o0000
2onU[]h00ol0003oYZoNojJ_gP0=ojJ_gP03o`000?nX/=koZ;3N00CoZ;3N0ol00006ojR^g003o`00
0?nZ/=goZ[3M00koZ[3M00?o0000oj^bg_n[/]h00_n[/]h00ol0003oZk;Noj^bgP02o`0000Oo[K;L
00Go0000ooooooooooooooooo`00001Uooooo`00__ooool4o`0000Kooooo0_l0000?ojF^gP03o`00
0?nV[mkoYZoN00goYZoN00Co0000ojR`g_nX/=koZ;3N0_l0000:ojR^g003o`000?nZ/=goZ[3M00ko
Z[3M00Co0000oj^bg_n[/]koZk;N0ol0000:ojfbg005o`000?ooooooooooooooool00000I?ooool0
0;_ooooo0ol00003ooooo`04o`000?ooooooooooooooo`?o000000?oY:kNo`000?nU[]h03_nU[]h0
0ol0003oYZoNojJ_gP0=ojJ_gP04o`000?nX/=ko0000o`0000goZ:kL00?o0000ojZ`gOnZ/=d03OnZ
/=d00ol0003oZk;No`000002o`0000co[K;L00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`1Qooooo`00^Oooool2o`0000Oooooo0ol00005ojB^gP03o`000?nU[]koYJkN00goYJkN00?o0000
ojJ_g_nV[mh03?nV[mh2o`0000ooZ:kL00?o0000ojZ`gOnZ/=d03OnZ/=d2o`0000;o[K;L00?o0000
ojfbg?n]/]`02on]/]`01Ol0003ooooooooooooooooo000006?ooooo002fooooo`?o00001_ooool3
o`0000WoY:kN00?o0000ojF^g_nU[]h03?nU[]h00ol0003oYZoNojJ_gP09ojJ_gP?o000000?oYjcK
o`000?nX[]`03onX[]`00ol0003oZ[3MojZ`g@0:ojZ`g@;o000000Go[:oKo`000?n]/]co[K;Lo`00
000=ojfbg003o`000?oooooooooo00;ooooo00?o0000ooooooooool0H?ooool00;Cooooo0_l00006
ooooo`?o00003?nT[]h00ol0003oYJkNojF^gP0=ojF^gP03o`000?nV[mkoYZoN00GoYZoN0ol00005
ojN/f`03o`000?nX[]coZ:kL00goZ:kL00?o0000ojZ`gOnZ/=d02?nZ/=d2o`0000Co[:oK00?o0000
ojfbg?l000003_n]/]`00ol0003oooooooooo`02ooooo`03o`000?oooooooooo05oooooo002aoooo
o`?o00000_ooool00ol0003oooooooooo`03o`000003oj>^gol0003oY:kN00goY:kN00?o0000ojF^
g_nU[]h03OnU[]h00ol0003oYZoNojJ_gP02ojJ_gP;o00002OnW[=/00ol0003oZ:kLojR^g00=ojR^
g003o`000?nZ/=goZ[3M00CoZ[3M0ol00006ojb_f`03o`000?n]/]co000000ko[K;L00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`1Oooooo`00[oooool2o`0000Gooooo0ol00005oj>^g`03
o`000?nT[]koY:kN00coY:kN00?o0000ojF^g_nU[]h03?nU[]h00ol0003oYZoNo`000002o`0000_o
YjcK00?o0000ojR^g?nX[]`03_nX[]`01?l0003oZ[3MojZ`gOnZ/=d2o`0000[o[:oK0_l0000?ojfb
g003o`000?oooooooooo00;ooooo00?o0000ooooooooool0G_ooool008_ooooo0_l0000Oooooo`?o
00001Oooool2o`0000SoXjkO00?o0000ojB^g_nT[]h03?nT[]h00ol0003oYJkNojF^gP0;ojF^gP?o
00003onW[=/00ol0003oZ:kLojR^g00=ojR^g004o`000?nZ/=go0000o`0000go[:oK00?o0000ojfb
g?n]/]`03On]/]`01ol0003ooooooooooooooooo0000ooooool00000Goooool008[ooooo00Co0000
oooooooooooo00007?ooool2o`0000Gooooo0ol0000;oj>^g`03o`000?nT[]koY:kN00coY:kN00?o
0000ojF^g_nU[]h01onU[]h3o`0000;oYJ_K00?o0000ojN/fonW[=/03_nW[=/00ol0003oZ:kLojR^
g00<ojR^g0;o00003on/[m/00ol0003o[K;Lojfbg00=ojfbg0;o00001?ooool00ol0003ooooooooo
o`1Mooooo`00R_ooool01?l0003oooooooooool0000Iooooo`?o00001Oooool2o`0000ooXjkO00?o
0000ojB^g_nT[]h02onT[]h00ol0003oYJkNojF^gP04ojF^gP?o00001_nUZm/00ol0003oYjcKojN/
f`0=ojN/f`03o`000?nX[]coZ:kL00WoZ:kL0ol000000onZ[MWo0000ojb_f`0>ojb_f`;o00003?n]
/]`2o`000003ojjbfol0003ooooo00Cooooo00?o0000ooooooooool03?ooool3o`0004gooooo002:
ooooo`04o`000?ooooooooooo`0001Kooooo0ol00003ooooo`03o`000?oooooo000000;o000000?o
Y:oPo`000?nS[]l03_nS[]l00ol0003oY:kNojB^gP0<ojB^gP03o`000?nU[]koYJkN00?o00002_nU
Zm/00ol0003oYjcKojN/f`0=ojN/f`03o`000?nX[]coZ:kL00GoZ:kL0ol00005ojZ]f@03o`000?n/
[m_o[:oK00co[:oK0_l0000:ojfbg0;o00001?n^/]/00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo00gooooo00?o0000ooooooooool0C?ooool008[ooooo00Co0000oooooooooooo00005?oo
ool2o`0000Gooooo0ol00005ojB_h003o`000?nS[]ooXjkO00goXjkO00?o0000ojB^g_nT[]h02onT
[]h3o`0000goYJ_K00?o0000ojN/fonW[=/03OnW[=/00ol0003oZ:kLojR^g003ojR^g0;o00002?nZ
[MT00ol0003o[:oKojb_f`0<ojb_f`03o`000?n/[m_o000000Ko[K;L0ol00007ojjbf`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool01?ooool5o`0000?ooooo00?o0000ooooooooool0C?oo
ool008[ooooo00Co0000oooooooooooo00004Oooool3o`0000Cooooo0ol00009ojB_h003o`000?nS
[]ooXjkO00coXjkO00?o0000ojB^g_nT[]h02?nT[]h3o`000003oj>Zfol0003oYJ_K00koYJ_K00?o
0000ojN/fonW[=/03OnW[=/00ol0003oZ:kLo`000002o`0000_oZZgI00?o0000ojb_fon/[m/02on/
[m/01?l0003o[:oKojb_fol00003ojfbg0;o00002_n^/]/00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo00_ooooo00?o0000ooooooooool0C?ooool008_ooooo0_l0000@ooooo`;o00001?oo
ool3o`0000coY:oP00?o0000oj>^gonS[]l03OnS[]l00ol0003oY:kNojB^gP05ojB^gP;o00001OnS
Z]/00ol0003oYJ_KojF[f`0=ojF[f`03o`000?nW[=_oYjcK00coYjcK0_l0000>ojZ]f@03o`000?n/
[m_o[:oK00_o[:oK00Go0000ojb_fon/[m_o0000ojfbg002o`0000go[[;K00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo04cooooo002Jooooo`Co00000_oo
ool3o`000003ojF`h?l0003oY:oP00goY:oP00?o0000oj>^gonS[]l03OnS[]l00ol0003oY:kNojB^
gP02ojB^gP;o00001onSZ]/00ol0003oYJ_KojF[f`0=ojF[f`03o`000?nW[=_oYjcK00WoYjcK0ol0
00000onXZ]So0000ojZ]f@0>ojZ]f@03o`000?n/[m_o[:oK00_o[:oK00Co0000ojb_fol0003o0000
3on^/]/00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Wooooo0_l0001>ooooo`00V?oo
ool2o`0000Cooooo0_l00005ojF`h003o`000?nT[n3oY:oP00coY:oP00?o0000oj>^gonS[]l03?nS
[]l00ol0003oY:kNo`000002o`0000[oXj[K00?o0000ojF[fonUZm/03OnUZm/00ol0003oYjcKojN/
f`05ojN/f`?o00001OnXZ]P00ol0003oZZgIojZ]f@0=ojZ]f@03o`000?n/[m_o[:oK00Wo[:oK0ol0
00000on][mWo0000ojjbf`0?ojjbf`03o`000?oooooooooo00Co00002oooool00ol0003ooooooooo
o`1<ooooo`00UOooool3o`0000Cooooo0_l00008ojF`h003o`000?nT[n3oY:oP00_oY:oP00?o0000
oj>^gonS[]l02onS[]l3o`0000koXj[K00?o0000ojF[fonUZm/03?nUZm/00ol0003oYjcKojN/f`03
ojN/f`;o00002?nXZ]P00ol0003oZZgIojZ]f@0=ojZ]f@03o`000?n/[m_o[:oK00Ko[:oK0ol00000
0on][mWo0000ojf_f@02ojf_f@03o`000?n^/]_o[[;K00ko[[;K00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`1Hooooo`00Toooool2o`0000Cooooo0ol0000:ojF`h003o`000?nT[n3oY:oP
00coY:oP00?o0000oj>^gonS[]l01onS[]l3o`0000;oXZ[L00?o0000oj>ZfonSZ]/03?nSZ]/00ol0
003oYJ_KojF[f`0=ojF[f`03o`000?nW[=_o000000;o00002onXZ]P00ol0003oZZgIojZ]f@0=ojZ]
f@03o`000?n/[m_o[:oK00;o[:oK0ol00004ojf_f@05o`000?n][mWo[JoIojf_fOl000004?n^/]/0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo05Oooooo002@ooooo`?o00001?ooool2o`00
00koYK3P00?o0000ojB_h?nT[n002onT[n000ol0003oXjkOoj>^g`04oj>^g`?o00001_nRZ]`00ol0
003oXj[Koj>Zf`0<oj>Zf`03o`000?nUZm_oYJ_K00coYJ_K0_l0000?ojRZf003o`000?nZ[MWoZZgI
00coZZgI00?o0000ojb_fol000000_l00007ojf_f@03o`000?n][mWo[JoI00;o[JoI00?o0000ojjb
fon^/]/03On^/]/2o`0000Gooooo00?o0000ooooooooool0E_ooool008gooooo0ol00002ooooo`03
o`000?oooooo000000;o000000?oZ;7Oo`000?nU/>003_nU/>000ol0003oY:oPojB_h00;ojB_h003
o`000?nS[]ooXjkO00?o00002_nRZ]`00ol0003oXj[Koj>Zf`0;oj>Zf`03o`000?nUZm_oYJ_K00Wo
YJ_K0ol000000onUYmOo0000ojRZf00>ojRZf003o`000?nZ[MWoZZgI00coZZgI0_l0000:ojf_f@03
o`000?n][mWo[JoI00;o[JoI00?o0000ojjbfon^/]/02on^/]/2o`000003ok6cf_l0003ooooo00Co
oooo00?o0000ooooooooool0E_ooool008_ooooo0_l00004ooooo`?o00001OnX/Ml00ol0003oYK3P
ojF`h00<ojF`h003o`000?nT[n3oY:oP00_oY:oP0ol0000=oj:Zg003o`000?nSZ]_oXj[K00coXj[K
00?o0000ojF[fonUZm/01OnUZm/3o`0000GoYJOG00?o0000ojRZf?nXZ]P03OnXZ]P00ol0003oZZgI
ojZ]f@09ojZ]f@;o000000?o[:_Go`000?n][mT02On][mT00ol0003o[JoIojf_f@03ojf_f@03o`00
0?n^/]_o[[;K00So[[;K0_l00004ok6cfP03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
EOooool008Sooooo0ol00003ooooo`?o00002OnX/Ml00ol0003oYK3PojF`h00<ojF`h003o`000?nT
[n3oY:oP00OoY:oP0ol000000onRZmgo0000oj:Zg00>oj:Zg003o`000?nSZ]_oXj[K00coXj[K00?o
0000ojF[fonUZm/00_nUZm/2o`0000SoYJOG00?o0000ojRZf?nXZ]P03OnXZ]P00ol0003oZZgIojZ]
f@07ojZ]f@;o00001?n/ZmL00ol0003o[JoIojf_f@07ojf_f@03o`000?n][mWo[JoI00Co[JoI00?o
0000ojjbfon^/]/01On^/]/2o`0000Ko/K?J00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`1Dooooo`00Q_ooool2o`0000?ooooo0ol0000<ojRag`03o`000?nU/>3oYK3P00coYK3P00?o0000
ojB_h?nT[n001?nT[n03o`0000GoXZ_M00?o0000oj:Zg?nRZ]`03OnRZ]`00ol0003oXj[Koj>Zf`0;
oj>Zf`03o`000?nUZm_o000000;o00002onUYmL00ol0003oZ:[HojRZf00=ojRZf003o`000?nZ[MWo
ZZgI00CoZZgI0_l00006ojb[e`03o`000?n][mWo[JoI00Oo[JoI00?o0000ojf_fOn][mT01?n][mT0
0ol0003o[[;Kojjbf`04ojjbf`03o`000?na/m[o/K?J00Oo/K?J00?o0000ooooooooool00oooool0
0ol0003oooooooooo`1Dooooo`00Poooool4o`000006ooooool0003o0000o`000?nZ/Mko00003_nX
/Ml00ol0003oYK3PojF`h00<ojF`h003o`000?nT[n3oY:oP00?o00002OnRZmd00ol0003oXZ[Loj:Z
g00<oj:Zg003o`000?nSZ]_oXj[K00_oXj[K0_l0000?ojFWe`03o`000?nXZ]SoZ:[H00goZ:[H00Co
0000ojZ]fOnZ[MWoZZgI0_l00009ojb[e`03o`000?n][mWo[JoI00Ko[JoI00?o0000ojf_fOn][mT0
1On][mT01?l0003o[[;Kojjbfon^/]/2o`0000[o/K?J00?o0000ooooooooool00oooool2o`0005Go
oooo0021ooooo`;o00000oooool2o`0000GoZ[7N00?o0000ojRagonX/Ml03?nX/Ml00ol0003oYK3P
ojF`h00;ojF`h0?o00003?nRZmd00ol0003oXZ[Loj:Zg00=oj:Zg003o`000?nSZ]_oXj[K00OoXj[K
0ol000000onSYMOo0000ojFWe`0>ojFWe`03o`000?nXZ]SoZ:[H00goZ:[H00Co0000ojZ]fOl0003o
00003?n/ZmL00ol0003o[JoIojf_f@05ojf_f@03o`000?n][mWo[JoI00Go[JoI00Co0000ojjbfol0
003o00003Ona/mX00ol0003oooooooooo`03ooooo`03o`000?oooooooooo05?ooooo001nooooo`?o
00000oooool2o`0000SoZ[7N00?o0000ojRagonX/Ml03?nX/Ml00ol0003oYK3PojF`h007ojF`h0?o
000000?oY:gNo`000?nRZmd03OnRZmd00ol0003oXZ[Loj:Zg00<oj:Zg003o`000?nSZ]_oXj[K00Co
Xj[K0ol00005oj>Ue`03o`000?nUYmOoYJOG00goYJOG00?o0000ojRZf?nXZ]P03?nXZ]P2o`0000ko
[:_G00?o0000ojf_fOn][mT01On][mT00ol0003o[JoIojf_f@05ojf_f@;o00004?na/mX00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo05;ooooo001looooo`;o00000oooool3o`0000[oZ[7N
00?o0000ojRagonX/Ml03?nX/Ml00ol0003oYK3PojF`h004ojF`h0?o00001OnT[Mh00ol0003oXZ_M
oj:[g@0<oj:[g@03o`000?nRZ]coXZ[L00coXZ[L00?o0000oj>ZfonSZ]/00ol00008oj>Ue`03o`00
0?nUYmOoYJOG00goYJOG00?o0000ojRZf?nXZ]P02OnXZ]P3o`000003ojVWe?l0003o[:_G00ko[:_G
00?o0000ojf_fOn][mT01?n][mT00ol0003o[JoIojf_f@03ojf_f@;o000000?o/:oGo`000?na/mX0
3ona/mX00ol0003oooooooooo`04ooooo`03o`000?oooooooooo057ooooo001iooooo`?o00000ooo
ool2o`0000koZ[7N00?o0000ojRagonX/Ml03?nX/Ml00ol0003oYK3PojF`h003o`0000WoY:gN00?o
0000oj:[gOnRZmd02onRZmd00ol0003oXZ[Loj:Zg00;oj:Zg0Co00003?nSYML00ol0003oYJOGojFW
e`0=ojFWe`03o`000?nXZ]SoZ:[H00GoZ:[H0ol00005ojVWe003o`000?n/ZmOo[:_G00co[:_G00?o
0000ojf_fOn][mT01?n][mT01?l0003o[JoIojf_fOn][mT2o`0000Co/:oG00?o0000ok6cf_na/mX0
3_na/mX00ol0003oooooooooo`03ooooo`03o`000?oooooooooo057ooooo001Booooo`?o00008Ooo
ool3o`0000?ooooo0ol000000on[/Mco0000ojZagP0>ojZagP03o`000?nX/MooZ;7O00_oZ;7O0ol0
000<ojB]gP03o`000?nRZmgoXZ_M00coXZ_M00?o0000oj:Zg?nRZ]`01onRZ]`3o`0000;oX:CH00?o
0000oj>UeonSYML03?nSYML00ol0003oYJOGojFWe`0=ojFWe`03o`000?nXZ]SoZ:[H00;oZ:[H0_l0
0008ojVWe003o`000?n/ZmOo[:_G00go[:_G00?o0000ojf_fOn][mT00on][mT4o`0000Ko/:oG00?o
0000ok6cf_na/mX03_na/mX00ol0003oooooooooo`04ooooo`03o`000?oooooooooo053ooooo001C
ooooo`03o`000?oooooooooo01kooooo0_l00004ooooo`;o00001On[/M`00ol0003oZ[7NojZagP0<
ojZagP03o`000?nX/MooZ;7O00SoZ;7O0ol000000onW[]go0000ojB]gP0=ojB]gP03o`000?nRZmgo
XZ_M00_oXZ_M00?o0000oj:Zg?nRZ]`01?nRZ]`3o`0000KoX:CH00?o0000oj>UeonSYML02onSYML0
0ol0003oYJOGojFWe`0=ojFWe`03o`000?nXZ]So000000;o00002onYYm@00ol0003o[:_Gojb[e`0=
ojb[e`04o`000?n][mWo[JoIojf_f@;o00002_n`[mL00ol0003o/K?Jok6cfP0=ok6cfP;o00001_oo
ool00ol0003oooooooooo`1?ooooo`00Boooool5o`0000?ooooo00?o0000ooooooooool06oooool3
o`0000Cooooo0_l00008oj^ag003o`000?nZ/MkoZ[7N00coZ[7N00?o0000ojRagonX/Ml01OnX/Ml2
o`0000GoYjkM00?o0000ojB]g_nT[Mh03?nT[Mh00ol0003oXZ_Moj:[g@0;oj:[g@03o`000?nRZ]co
XZ[L00?o00002OnPY=P00ol0003oXjGGoj>Ue`0<oj>Ue`03o`000?nUYmOoYJOG00coYJOG0_l0000>
ojVWe003o`000?n/ZmOo[:_G00go[:_G00Ko0000ojf_fOl0003o0000ok2_eol0000:ok2_e`03o`00
0?na/m[o/K?J00_o/K?J0_l000000ond]=Wo0000ooooo`05ooooo`03o`000?oooooooooo04oooooo
001Cooooo`03o`000?oooooooooo01Wooooo0_l00004ooooo`?o00002_n[/M`00ol0003oZ[7NojZa
gP0<ojZagP03o`000?nX/MooZ;7O00?oZ;7O0_l00008ojN^g@03o`000?nT[MkoY:gN00_oY:gN00?o
0000oj:[gOnRZmd02onRZmd3o`0000goX:CH00?o0000oj>UeonSYML02onSYML00ol0003oYJOGojFW
e`09ojFWe`?o000000?oYZ?Bo`000?nYYm@03_nYYm@00ol0003o[:_Gojb[e`0<ojb[e`;o00000on`
[mL00ol0003o/:oGok2_e`09ok2_e`03o`000?na/m[o/K?J00So/K?J0_l00004okBdf@03o`000?oo
oooooooo00?ooooo0_l0001@ooooo`00Doooool00ol0003oooooooooo`0Fooooo`?o00000_ooool0
1?l0003oooooo`000?l0000>oj^ag003o`000?nZ/MkoZ[7N00coZ[7N00?o0000ojRagol000000_l0
000:ojN^g@03o`000?nT[MkoY:gN00coY:gN00?o0000oj:[gOnRZmd01onRZmd3o`000003oj2Vf_l0
003oX:CH00goX:CH00?o0000oj>UeonSYML03?nSYML00ol0003oYJOGojFWe`05ojFWe`?o00001OnV
Xm800ol0003oZJODojVWe00<ojVWe003o`000?n/ZmOo[:_G00[o[:_G0_l000000on^ZmCo0000ok2_
e`03ok2_e`03o`000?n`[mOo/:oG00Wo/:oG00?o0000ok6cf_na/mX01Ona/mX2o`0000Oo];CI00?o
0000ooooooooool01?ooool00ol0003oooooooooo`1=ooooo`00D_ooool2o`0001Kooooo0_l00004
ooooo`?o000000?oZk3Lo`000?n[/M`03_n[/M`00ol0003oZ[7NojZagP0;ojZagP;o00003_nW[]d0
0ol0003oY:gNojB]gP0;ojB]gP03o`000?nRZmgoXZ_M00CoXZ_M0ol00005oj2VfP03o`000?nPY=So
X:CH00coX:CH00?o0000oj>UeonSYML03?nSYML00ol0003oYJOGojFWe`02ojFWe`;o00002?nVXm80
0ol0003oZJODojVWe00=ojVWe003o`000?n/ZmOo[:_G00Oo[:_G0_l00004ojj[e005o`000?n`[mOo
/:oGok2_eol000002on`[mL00ol0003o/K?Jok6cfP04ok6cfP03o`000?nd]=Wo];CI00Oo];CI00?o
0000ooooooooool01?ooool00ol0003oooooooooo`1=ooooo`00Doooool00ol0003oooooooooo`0A
ooooo`?o00001?ooool2o`0000GoZk3L00?o0000oj^ag?n[/M`03?n[/M`00ol0003oZ[7NojZagP08
ojZagP?o000000?oZZkKo`000?nW[]d03_nW[]d00ol0003oY:gNojB]gP0;ojB]gP03o`000?nRZmgo
XZ_M00?o00002?nPY]X00ol0003oX:CHoj2Tf00=oj2Tf003o`000?nSYMOoXjGG00_oXjGG00?o0000
ojFWeol000000_l0000;ojJSdP03o`000?nYYmCoZJOD00coZJOD00?o0000ojb[eon/ZmL01?n/ZmL3
o`0000Ko[Z_D00Go0000ok2_eon`[mOo/:oGo`00000<ok2_e`04o`000?na/m[o/K?Jok6cfP;o0000
2ond]=T00ol0003oooooooooo`04ooooo`03o`000?oooooooooo04cooooo001Uooooo`;o00001Ooo
ool2o`0000SoZk3L00?o0000oj^ag?n[/M`03?n[/M`00ol0003oZ[7NojZagP05ojZagP;o00001OnZ
[]/00ol0003oYjkMojN^g@0<ojN^g@03o`000?nT[MkoY:gN00_oY:gN0ol0000<oj2VfP03o`000?nP
Y=SoX:CH00coX:CH00?o0000oj>UeonSYML02onSYML2o`0000koYZ?B00?o0000ojVWe?nYYm@03OnY
Ym@01?l0003o[:_Gojb[eon/ZmL2o`0000[o[Z_D00Co0000ok2_eon`[mOo00003?n`[mL01?l0003o
/K?Jo`000?l0000=okBdf@03o`000?oooooooooo00Gooooo00?o0000ooooooooool0Boooool006;o
oooo1?l00003ooooo`?o00002_n[/=`00ol0003oZk7Loj^ag00<oj^ag003o`000?nZ/MkoZ[7N00?o
Z[7N0_l00008ojZ^f`03o`000?nW[]goYjkM00coYjkM00?o0000ojB]g_nT[Mh01onT[Mh3o`000003
oj:Xfol0003oX:KJ00goX:KJ00?o0000oj2Tf?nPY=P03?nPY=P00ol0003oXjGGoj>Ue`07oj>Ue`?o
000000?oXYoBo`000?nVXm803_nVXm800ol0003oZJODojVWe00<ojVWe004o`000?n/ZmOo0000o`00
00co[Z_D00Co0000ok2_eon`[mOo00003?n`[mL2o`00013o];CI00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`1;ooooo`00Goooool3o`0000Cooooo0ol0000>oj^`g003o`000?n[/McoZk7L
00coZk7L00?o0000ojZag_l000000_l0000:ojZ^f`03o`000?nW[]goYjkM00coYjkM00?o0000ojB]
g_nT[Mh01?nT[Mh3o`0000GoXZSK00?o0000oj2Vf_nPY]X02onPY]X00ol0003oX:CHoj2Tf00<oj2T
f003o`000?nSYMOoXjGG00GoXjGG0_l00005oj:OdP03o`000?nVXm;oYZ?B00coYZ?B00?o0000ojVW
e?nYYm@03?nYYm@2o`0000oo[Z_D00?o0000ok2_eol000002_n`[mL2o`000003ok>`e_l0003o];CI
013o];CI00?o0000ooooooooool01?ooool00ol0003oooooooooo`1:ooooo`00GOooool2o`0000Ko
oooo0_l000000on[/=co0000oj^`g00>oj^`g003o`000?n[/McoZk7L00_oZk7L0_l0000>ojZ^f`03
o`000?nW[]goYjkM00coYjkM00?o0000ojB]g_nT[Mh00ol00009oj:Xf`03o`000?nPY][oX:KJ00_o
X:KJ00?o0000oj2Tf?nPY=P03?nPY=P00ol0003oXjGGoj>Ue`02oj>Ue`;o00001onRWm800ol0003o
YZ?BojJSdP0<ojJSdP03o`000?nYYmCoZJOD00[oZJOD0_l000000on/YM3o0000ojj[e00?ojj[e0;o
00002?n`[mL2o`0000Co/k3F00?o0000okBdfOnd]=T03_nd]=T00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo04Wooooo001Jooooo`?o00001Oooool3o`0000CoZk3L00?o0000oj^`g?n[/=`0
3?n[/=`00ol0003oZk7Loj^ag008oj^ag0?o000000?o[:kIo`000?nZ[]/03_nZ[]/00ol0003oYjkM
ojN^g@0;ojN^g@?o00003?nRZ=/00ol0003oX:KJoj2VfP0;oj2VfP03o`000?nPY=SoX:CH00coX:CH
00?o0000oj>Ueol000000_l0000:oj:OdP03o`000?nVXm;oYZ?B00coYZ?B00?o0000ojVWe?nYYm@0
1onYYm@2o`0000Co[:G@00?o0000ojj[e?n^Zm@03On^Zm@2o`0000Go/:oG0ol00007ok>`eP03o`00
0?nd]=Wo];CI00go];CI0_l00005ooooo`;o00009?ooool3o`0002Cooooo001Hooooo`Co00001?oo
ool2o`0000SoZk3L00?o0000oj^`g?n[/=`03?n[/=`00ol0003oZk7Loj^ag005oj^ag0;o00001On/
[]T00ol0003oZZkKojZ^f`0=ojZ^f`03o`000?nW[]goYjkM00OoYjkM0ol000000onVZ]Wo0000oj:X
f`0=oj:Xf`03o`000?nPY][oX:KJ00_oX:KJ00?o0000oj2Tf?nPY=P02_nPY=P3o`0000goXYoB00?o
0000ojJSd_nVXm803?nVXm800ol0003oZJODojVWe004ojVWe0?o00001_n/YM000ol0003o[Z_Dojj[
e00>ojj[e004o`000?n`[mOo/:oGok2_e`;o00002_nc/=H00ol0003o];CIokBdf@0;okBdf@;o0000
00?o]kOIo`000?ooool01_ooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo02?ooooo
001Eooooo`?o00001?ooool01?l0003oooooo`000?l0000;oj^`g003o`000?n[/=coZk3L00_oZk3L
00?o0000oj^ag?n[/M`00on[/M`2o`0000So[:kI00?o0000ojZ^fonZ[]/03?nZ[]/00ol0003oYjkM
ojN^g@04ojN^g@?o00001OnVZ]T00ol0003oXZSKoj:Xf`0<oj:Xf`03o`000?nPY][oX:KJ00_oX:KJ
00?o0000oj2Tf?nPY=P01?nPY=P5o`0000;oWigB00?o0000oj:Od_nRWm803?nRWm800ol0003oYZ?B
ojJSdP0<ojJSdP04o`000?nYYmCoZJODojVWe0;o00002_n/YM000ol0003o[Z_Dojj[e00=ojj[e004
o`000?n`[mOo0000o`0000go/k3F00?o0000okBdfOnd]=T02?nd]=T2o`0000Co]kOI00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo02;ooooo001Cooooo`;o
00001oooool2o`0000goZk3L00?o0000oj^`g?n[/=`03?n[/=`00ol0003oZk7Lo`000002o`0000[o
[:kI00?o0000ojZ^fonZ[]/03OnZ[]/00ol0003oYjkMojN^g@03o`0000WoYZ[I00?o0000oj:XfonR
Z=/02onRZ=/00ol0003oX:KJoj2VfP0;oj2VfP03o`000?nPY=SoX:CH00Co00002?nOWM800ol0003o
XYoBoj:OdP0<oj:OdP03o`000?nVXm;oYZ?B00_oYZ?B00Co0000ojVWe?l0003o00003?n/YM000ol0
003o[Z_Dojj[e00=ojj[e0;o00003onc/=H00ol0003o];CIokBdf@06okBdf@;o00001_ng]mT00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo02;ooooo00?o0000ooooooooool08_ooool0053o
oooo0ol00006ooooo`?o000000?oZ[3Lo`000?n[/=`03On[/=`00ol0003oZk3Loj^`g00;oj^`g0;o
00003_n/[]T00ol0003oZZkKojZ^f`0<ojZ^f`?o00003?nVZ]T00ol0003oXZSKoj:Xf`0<oj:Xf`03
o`000?nPY][oX:KJ00WoX:KJ1?l0000<oinMdP03o`000?nRWm;oXYoB00coXYoB00?o0000ojJSd_nV
Xm802onVXm82o`0000oo[:G@00?o0000ojj[e?n^Zm@02_n^Zm@4o`00013o/k3F00?o0000okBdfOnd
]=T01?nd]=T00ol0003o]kOIokNgf@07okNgf@03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool08?ooool00ol0003oooooo`00000Sooooo`00C_ooool2o`0000Oooooo0_l00005ojZ`g003o`00
0?n[/=coZk3L00coZk3L00?o0000oj^`g?n[/=`02?n[/=`2o`000003oj^]fOl0003o[:kI00ko[:kI
00?o0000ojZ^fonZ[]/02?nZ[]/3o`000003ojZZeol0003oYZ[I00goYZ[I00?o0000oj:XfonRZ=/0
2onRZ=/00ol0003oX:KJoj2VfP05oj2VfPCo00000_nMW]@00ol0003oWigBoinMdP0<oinMdP03o`00
0?nRWm;oXYoB00coXYoB00?o0000ojJSd_nVXm801onVXm83o`000003ojRNcOl0003o[:G@00ko[:G@
00?o0000ojj[e?n^Zm@02?n^Zm@2o`0000;o/Z_A00?o0000ok:[dOl000004?nc/=H01?l0003o];CI
okBdfOnd]=T2o`0000[o]kOI00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Pooooo`03
o`000?oooooo000002?ooooo001;ooooo`?o00000_ooool00ol0003oooooooooo`02ooooo`;o0000
2?nZ/=`00ol0003oZk3Loj^`g00;oj^`g003o`000?n[/=coZk3L00GoZk3L0ol00004oj^]f@03o`00
0?n/[]Wo[:kI00go[:kI00?o0000ojZ^fonZ[]/01OnZ[]/2o`0000GoZZ[G00?o0000ojJZfOnVZ]T0
3?nVZ]T00ol0003oXZSKoj:Xf`0;oj:Xf`03o`000?nPY][oX:KJ00Co00001onMW]@00ol0003oWigB
oinMdP0;oinMdP03o`000?nRWm;oXYoB00coXYoB00?o0000ojJSd_nVXm801OnVXm82o`0000GoZ9k=
00?o0000ojbUd?n/YM003On/YM000ol0003o[Z_Dojj[e005ojj[e0;o00001?nbZm400ol0003o/Z_A
o`00000@ok>`eP04o`000?nd]=Wo0000o`0000go]kOI00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`0Nooooo`;o000000?oooooo`000?l000008_ooool004Sooooo0ol00007ooooo`?o0000
2_nZ/=`00ol0003oZk3Loj^`g00<oj^`g003o`000?n[/=coZk3L00;oZk3L0_l00008oj^]f@03o`00
0?n/[]Wo[:kI00co[:kI00?o0000ojZ^fonZ[]/00onZ[]/2o`0000SoZZ[G00?o0000ojJZfOnVZ]T0
2onVZ]T00ol0003oXZSKoj:Xf`0;oj:Xf`?o00002onMW]@00ol0003oWigBoinMdP0<oinMdP03o`00
0?nRWm;oXYoB00coXYoB00?o0000ojJSd_nVXm800_nVXm82o`0000OoZ9k=00?o0000ojbUd?n/YM00
3On/YM000ol0003o[Z_Dojj[e004ojj[e003o`000?nbZm7o/Z_A00Co/Z_A00Co0000ok:[dOnbZm7o
00003onc/=H2o`0000oo]kOI00?o0000ooooooooool01_ooool00ol0003oooooooooo`14ooooo`00
A_ooool2o`0000Sooooo0_l0000>ojZ`g003o`000?n[/=coZk3L00coZk3L00Co0000oj^`g?l0003o
00002on[[MT00ol0003o[:kIojb^f@0<ojb^f@03o`000?nZ[]_o000000;o00002_nZZ]L00ol0003o
YZ[IojJZf@0<ojJZf@03o`000?nRZ=_oXZSK00OoXZSK0ol000000onOXMKo0000oifNe00<oifNe003
o`000?nOWM;oWigB00_oWigB00?o0000oj:Od_nRWm803?nRWm800ol0003oYZ?Bo`000002o`0000[o
Z9k=00?o0000ojbUd?n/YM003On/YM001?l0003o[Z_Dojj[e?n^Zm@2o`0000Oo/Z_A00Co0000ok:[
dOnbZm7o00003_nc/=H00ol0003o^;?Eo`00000@okNgf@03o`000?oooooooooo00Cooooo0_l00016
ooooo`00@oooool3o`0000Sooooo0_l000000onX/=ko0000ojZ`g00>ojZ`g003o`000?n[/=coZk3L
00_oZk3L0_l0000=oj^]f@03o`000?n/[]Wo[:kI00co[:kI0_l0000>ojZZe`03o`000?nVZ]WoYZ[I
00_oYZ[I00?o0000oj:XfonRZ=/01?nRZ=/3o`0000GoWj7F00?o0000oifNe?nMW]@02_nMW]@00ol0
003oWigBoinMdP0;oinMdP03o`000?nRWm;oXYoB00coXYoB0_l0000=ojRNc@03o`000?n/YM3o[:G@
00go[:G@00Co0000ojj[e?l0003o00002OnbZm401Ol0003o/Z_Aok:[dOnbZm7o000000_o/k3F0_l0
0003okRce@03o`000?ng]mWo]kOI00go]kOI00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`08ooooo`;o0000>Oooool001cooooo1Ol0000Pooooo`;o00000oooool00ol0003oooooooooo`02
ooooo`?o00001?nX/=h00ol0003oZ[3LojZ`g00<ojZ`g003o`000?n[/=coZk3L00SoZk3L0ol00000
0onZ[MWo0000oj^]f@0=oj^]f@03o`000?n/[]Wo[:kI00Wo[:kI0_l000000on/ZMGo0000ojZZe`0>
ojZZe`03o`000?nVZ]WoYZ[I00_oYZ[I00?o0000oj:XfonRZ=/00ol00008oinQeP03o`000?nMW]Co
WIkD00_oWIkD00?o0000oinMd_nOWM802onOWM800ol0003oXYoBoj:OdP08oj:OdP?o000000?oXiS:
o`000?nXW/d03OnXW/d00ol0003o[:G@ojbUd00<ojbUd0;o00003?nbZm401?l0003o/Z_Aok:[dOl0
0009ok>`eP;o00001Onh/mD00ol0003o]kOIokNgf@0=okNgf@;o00002?ooool00ol0003ooooooooo
o`06ooooo`04o`000?ooooooooooo`0003Sooooo000Mooooo`04o`000?ooooooooooo`0001gooooo
0ol00008ooooo`;o00002?nX/=h00ol0003oZ[3LojZ`g00<ojZ`g003o`000?n[/=coZk3L00GoZk3L
0_l00005ojZ]f@03o`000?n[[MWoZjgI00coZjgI00?o0000ojb^fOn/[]T01_n/[]T2o`0000Co[:WE
00?o0000ojZZeonZZ]L03?nZZ]L00ol0003oYZ[IojJZf@0;ojJZf@?o00003?nOXMH00ol0003oWIkD
oifNe00;oifNe003o`000?nOWM;oWigB00[oWigB00?o0000oj:Od_nRWm801OnRWm83o`0000GoXiS:
00?o0000ojRNcOnXW/d03?nXW/d00ol0003o[:G@ojbUd009ojbUd0;o000000?o/:C<o`000?nbZm40
2onbZm401Ol0003o/Z_Aok:[dOnbZm7o000000Oo/k3F00?o0000okRceOnh/mD01_nh/mD00ol0003o
]kOIokNgf@0;okNgf@03o`000?nk^m[o000000Sooooo00?o0000ooooooooool01_ooool01?l0003o
ooooooooool0000hooooo`005_ooool5o`0000?ooooo00?o0000ooooooooool06oooool2o`0000Wo
oooo0_l0000;ojR`gP03o`000?nZ/=coZ[3L00_oZ[3L00?o0000oj^`g?n[/=`00on[/=`2o`0000So
ZZgI00?o0000oj^]fOn[[MT02on[[MT00ol0003o[:kIojb^f@05ojb^f@03o`000?n/ZMGo[:WE00Co
[:WE00?o0000ojZZeonZZ]L03OnZZ]L00ol0003oYZ[IojJZf@07ojJZf@?o000000?oYJCDo`000?nO
XMH03?nOXMH00ol0003oWIkDoifNe00;oifNe003o`000?nOWM;oWigB00_oWigB00?o0000oj:Od_nR
Wm800_nRWm82o`0000SoXiS:00?o0000ojRNcOnXW/d03?nXW/d00ol0003o[:G@ojbUd008ojbUd003
o`000?n`Y<co/:C<00;o/:C<00?o0000ok:[dOnbZm402OnbZm401Ol0003o/Z_Aok:[dOnbZm7o0000
00Go/k3F0_l00009okRce@03o`000?ng]mWo]kOI00Wo]kOI0_l00003ok^kfP03o`000?oooooooooo
00Kooooo00?o0000ooooooooool01Oooool01?l0003oooooooooool0000hooooo`007oooool00ol0
003oooooooooo`0Gooooo`?o00002Oooool2o`0000koZ;3N00?o0000ojZ`g?nZ/=`02onZ/=`00ol0
003oZk3Lo`000002o`0000[oZZgI00?o0000oj^]fOn[[MT03?n[[MT00ol0003o[:kIojb^f@02ojb^
f@;o00002?n/ZMD00ol0003oZZ[GojZZe`0<ojZZe`03o`000?nVZ]WoYZ[I00CoYZ[I0ol00005ojFT
e003o`000?nOXMKoWj7F00_oWj7F00?o0000oifNe?nMW]@02onMW]@00ol0003oWigBoinMdP0:oinM
dP03o`000?nRWm;o000000;o00002onSV<X00ol0003oZ9k=ojRNc@0<ojRNc@03o`000?n/YM3o[:G@
00Go[:G@0_l00005ok2Tc003o`000?nbZm7o/Z_A00Wo/Z_A00?o0000ok:[dOnbZm400_nbZm400ol0
003o/k3Fok>`eP02o`0000co^;?E00?o0000okNgfOng]mT01ong]mT00ol0003o^k_Jok^kfP04ok^k
fP03o`000?oooooooooo00Kooooo00?o0000ooooooooool01?ooool01?l0003oooooooooool0000h
ooooo`007?ooool01Ol0003ooooooooooooooooo000001Kooooo0_l00002ooooo`03o`000?oooooo
oooo00Cooooo0ol000000onW/Moo0000ojR`gP0=ojR`gP03o`000?nZ/=coZ[3L00_oZ[3L0_l0000>
ojZ]f@03o`000?n[[MWoZjgI00coZjgI00Co0000ojb^fOl0003o00002on/ZMD00ol0003oZZ[GojZZ
e`0<ojZZe`03o`000?nVZ]WoYZ[I00?o00002?nUY=@00ol0003oWj7FoinQeP0<oinQeP03o`000?nM
W]CoWIkD00[oWIkD00?o0000oinMd_nOWM802OnOWM83o`0000koXiS:00?o0000ojRNcOnXW/d03?nX
W/d00ol0003o[:G@ojbUd003ojbUd0;o00002?n`Y<`00ol0003o/Z_Aok:[d@08ok:[d@03o`000?nb
Zm7o/Z_A00;o/Z_A00?o0000ok>`e_l000003onh/mD00ol0003o]kOIokNgf@04okNgf@;o00001onk
^mX00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Cooooo00Co0000oooooooooooo0000
>?ooool001cooooo00Go0000ooooooooooooooooo`00000Cooooo`?o00002?ooool3o`0000GoYk7O
00?o0000ojR`g_nX/=h03?nX/=h00ol0003oZ[3LojZ`g007ojZ`g0?o000000?oZJgJo`000?nZ[MT0
3_nZ[MT00ol0003oZjgIoj^]f@0;oj^]f@;o00003On/ZMD00ol0003oZZ[GojZZe`0<ojZZe`?o0000
3?nUY=@00ol0003oWj7FoinQeP0;oinQeP03o`000?nMW]CoWIkD00_oWIkD00?o0000oinMd_nOWM80
1?nOWM84o`0000;oWI?900?o0000oj>Hb_nSV<X03?nSV<X00ol0003oZ9k=ojRNc@0=ojRNc@05o`00
0?n/YM3o[:G@ojbUd?l000002_n`Y<`00ol0003o/Z_Aok:[d@08ok:[d@03o`000?nbZm7o/Z_A00;o
/Z_A0_l0000@okRce@03o`000?ng]mWo]kOI00?o]kOI00?o0000ok^kf_nk^mX02?nk^mX00ol0003o
ooooooooo`05ooooo`;o00001_ooool2o`0003Wooooo000Mooooo`?o00004Oooool3o`0000Sooooo
0ol00009ojNag`03o`000?nX/=koZ;3N00coZ;3N00?o0000ojZ`g?nZ/=`00onZ/=`3o`0000GoZJgJ
00?o0000ojZ]fOnZ[MT03?nZ[MT00ol0003oZjgIoj^]f@08oj^]f@?o000000?oZjSDo`000?n/ZMD0
3On/ZMD00ol0003oZZ[GojZZe`09ojZZe`;o000000?oZZCAo`000?nUY=@03OnUY=@00ol0003oWj7F
oinQeP0;oinQeP03o`000?nMW]CoWIkD00[oWIkD00?o0000oinMd_nOWM801?l00007oifCb@03o`00
0?nSV<[oXiS:00coXiS:00?o0000ojRNcOnXW/d03?nXW/d01?l0003o[:G@o`000?l0000<ok2Tc003
o`000?nbZm7o/Z_A00Oo/Z_A00Oo0000ok:[dOnbZm7o/Z_Ao`000?nh[]3o0000017o^;?E00?o0000
okNgfOng]mT00_l0000<ok^kfP03o`000?oooooooooo00?ooooo00?o0000ooooool00000@Oooool0
02oooooo0_l00009ooooo`;o00003OnW/Ml00ol0003oZ;3NojR`gP0<ojR`gP03o`000?nZ/=co0000
00;o00002OnY[MX00ol0003oZZgIojZ]f@0<ojZ]f@03o`000?n[[MWoZjgI00GoZjgI0_l00005oj^X
e003o`000?n/ZMGo[:WE00_o[:WE00?o0000ojZZeonZZ]L01onZZ]L2o`0000CoZZCA00?o0000ojFT
e?nUY=@02onUY=@00ol0003oWj7FoinQeP0;oinQeP03o`000?nMW]CoWIkD00WoWIkD1?l0000;oifC
b@03o`000?nSV<[oXiS:00coXiS:00?o0000ojRNcOnXW/d03?nXW/d2o`0000oo/:C<00?o0000ok:[
dOnbZm401_nbZm401?l0003o/Z_Ao`000?l00003okR^d003o`000?nh/mGo^;?E00ko^;?E00?o0000
okNgfOl000003_nk^mX00ol0003oooooooooo`06ooooo`03o`000?oooooooooo03kooooo000/oooo
o`?o00000_ooool00ol0003oooooooooo`03ooooo`?o000000?oY[;Po`000?nW/Ml03OnW/Ml00ol0
003oZ;3NojR`gP0;ojR`gP;o00003OnY[MX00ol0003oZZgIojZ]f@0;ojZ]f@03o`000?n[[MWoZjgI
00?oZjgI0_l00008oj^Xe003o`000?n/ZMGo[:WE00_o[:WE00?o0000ojZZeonZZ]L01?nZZ]L2o`00
00KoZZCA00?o0000ojFTe?nUY=@03?nUY=@00ol0003oWj7FoinQeP0;oinQeP03o`000?nMW]CoWIkD
00CoWIkD1?l00002oiVCc003o`000?nMTlWoWI?900_oWI?900?o0000oj>Hb_nSV<X03?nSV<X00ol0
003oZ9k=ojRNc@09ojRNc@;o000000?o[9c7o`000?n`Y<`03_n`Y<`00ol0003o/Z_Aok:[d@05ok:[
d@?o00001Onh[]000ol0003o^;?EokRce@0>okRce@;o00004?nk^mX00ol0003oooooooooo`06oooo
o`03o`000?oooooooooo03gooooo000Zooooo`;o00002?ooool3o`0000GoY[;P00?o0000ojNagonW
/Ml02onW/Ml00ol0003oZ;3NojR`gP09ojR`gP;o000000?oYjkLo`000?nY[MX03OnY[MX00ol0003o
ZZgIojZ]f@0;ojZ]f@03o`000?n[[MWo000000;o00002_n[Z=@00ol0003o[:WEojbYe@0<ojbYe@04
o`000?nZZ]OoZZ[GojZZe`;o00002OnZY=400ol0003oYJCDojFTe00;ojFTe003o`000?nOXMKoWj7F
00_oWj7F00?o0000oifNe?nMW]@01?l00007oiVCc003o`000?nMTlWoWI?900[oWI?900?o0000oj>H
b_nSV<X03?nSV<X00ol0003oZ9k=ojRNc@07ojRNc@;o00001?n/W<L00ol0003o/:C<ok2Tc00=ok2T
c004o`000?nbZm7o/Z_Aok:[d@Go00001onh[]000ol0003o^;?EokRce@0<okRce@03o`000?nm^MKo
0000013o^k_J0_l00007ooooo`03o`000?oooooooooo03gooooo000Wooooo`?o00001oooool3o`00
00WoY[;P00?o0000ojNagonW/Ml02onW/Ml00ol0003oZ;3NojR`gP05ojR`gP?o00001?nW[]`00ol0
003oZJgJojV]fP0;ojV]fP03o`000?nZ[MWoZZgI00_oZZgI0_l0000>oj^Xe003o`000?n/ZMGo[:WE
00_o[:WE00Co0000ojZZeol0003o00003?nZY=400ol0003oYJCDojFTe00;ojFTe003o`000?nOXMKo
Wj7F00WoWj7F1?l0000;oiVCc003o`000?nMTlWoWI?900_oWI?900?o0000oj>Hb_nSV<X03?nSV<X0
0ol0003oZ9k=ojRNc@03ojRNc@?o00001_n/W<L00ol0003o/:C<ok2Tc00=ok2Tc0Co00000_nbZm40
1?l0003o^:k@okR^d?l00006okR^d003o`000?nh/mGo^;?E00[o^;?E0_l00003okfieP03o`000?nk
^m[o^k_J00co^k_J00?o0000okk1g?l000002?ooool00ol0003oooooooooo`0looooo`009_ooool2
o`0000Oooooo0_l0000=ojJbh003o`000?nW/MooYk7O00_oYk7O00?o0000ojR`g_nX/=h00_nX/=h2
o`0000SoYjkL00?o0000ojV]f_nY[MX02onY[MX00ol0003oZZgIojZ]f@07ojZ]f@?o000000?oZJSF
o`000?n[Z=@03_n[Z=@00ol0003o[:WEojbYe@0:ojbYe@;o00003_nZY=400ol0003oYJCDojFTe00<
ojFTe003o`000?nOXMKoWj7F00CoWj7F1?l00002oi^Gc`03o`000?nITlcoVI?<00_oVI?<00?o0000
oifCbOnMTlT02_nMTlT00ol0003oXiS:oj>HbP0<oj>HbP04o`000?nXW/goZ9k=ojRNc@;o00002_n/
W<L00ol0003o/:C<ok2Tc00:ok2Tc0Co00000_nbZm42o`0000Co^:k@00?o0000okR^d?nh[]001?nh
[]000ol0003o^;?EokRce@07okRce@;o00001_nm^MH00ol0003o^k_Jok^kfP09ok^kfP;o00000onn
`M`00ol0003oooooooooo`06ooooo`03o`000?oooooooooo03_ooooo000Vooooo`?o00000oooool3
o`000003ojFbh_l0003oY[;P00goY[;P00?o0000ojNagonW/Ml02onW/Ml01?l0003oZ;3No`000?l0
000:ojN^g003o`000?nY[M[oZJgJ00coZJgJ00?o0000ojZ]fOnZ[MT00onZ[MT3o`0000GoZJSF00?o
0000oj^Xe?n[Z=@03?n[Z=@00ol0003o[:WEojbYe@08ojbYe@;o000000?oZj??o`000?nZY=403_nZ
Y=400ol0003oYJCDojFTe00;ojFTe003o`000?nOXMKoWj7F00Co00001onKUll00ol0003oVI?<oiVC
c00:oiVCc003o`000?nMTlWoWI?900_oWI?900?o0000oj>Hb_nSV<X02onSV<X01?l0003oZ9k=o`00
0?l0000<ojbLa`03o`000?n`Y<co/:C<00Oo/:C<0ol00003ok2Tc003o`000?nbZm7o000000Oo^:k@
00?o0000okR^d?nh[]001?nh[]000ol0003o^;?EokRce@05okRce@03o`000?nm^MKo_KWF00Ko_KWF
00?o0000ok^kf_nk^mX02?nk^mX00ol0003o_/7Lokk1g003okk1g003o`000?oooooooooo00Kooooo
00?o0000ooooooooool0>oooool002Kooooo00?o0000ooooool000000ol00005ojFbhP03o`000?nV
/^3oY[;P00_oY[;P00?o0000ojNagonW/Ml02onW/Ml2o`0000goYjkL00?o0000ojV]f_nY[MX03?nY
[MX00ol0003oZZgIo`000002o`0000WoZJSF00?o0000oj^Xe?n[Z=@03?n[Z=@00ol0003o[:WEojbY
e@04ojbYe@?o00001?n[Xll00ol0003oZZCAojZTd@0<ojZTd@03o`000?nUY=CoYJCD00_oYJCD0ol0
000;oi^Gc`03o`000?nITlcoVI?<00[oVI?<00?o0000oifCbOnMTlT02onMTlT00ol0003oXiS:oj>H
bP0;oj>HbP;o00003_n/W<L00ol0003o/:C<ok2Tc004ok2Tc0?o00001_n`Y<`2o`0000So^:k@00?o
0000okR^d?nh[]001?nh[]000ol0003o^;?EokRce@03okRce@;o00002_nm^MH00ol0003o^k_Jok^k
fP05ok^kfP;o00001onn`M`00ol0003oooooooooo`05ooooo`;o0000??ooool002Gooooo1?l00009
ojFbhP03o`000?nV/^3oY[;P00_oY[;P00?o0000ojNagonW/Ml01onW/Ml3o`000003ojJ_g_l0003o
YjkL00goYjkL00?o0000ojV]f_nY[MX02onY[MX2o`0000coZJSF00?o0000oj^Xe?n[Z=@03?n[Z=@0
0ol0003o[:WEojbYe@02ojbYe@;o00001on[Xll00ol0003oZZCAojZTd@0=ojZTd@03o`000?nUY=Co
YJCD00OoYJCD0ol000000onSVlgo0000oi^Gc`0;oi^Gc`03o`000?nITlcoVI?<00_oVI?<00?o0000
oifCbOnMTlT02_nMTlT00ol0003oXiS:oj>HbP09oj>HbP;o000000?oYI;1o`000?n/W<L03_n/W<L0
0ol0003o/:C<ok2Tc003o`0000So/:C<00?o0000okJVbOl000002Onh[]000ol0003o^:k@okR^d004
okR^d003o`000?nh/mGo^;?E00;o00003Onm^MH00ol0003o^k_Jok^kfP03ok^kfP03o`000?nn`Mco
_/7L00So_/7L00?o0000ooooooooool01_ooool00ol0003oooooooooo`0iooooo`009Oooool00ol0
003oYK;RojFbhP0;ojFbhP03o`000?nV/^3oY[;P00_oY[;P00?o0000ojNagonW/Ml00onW/Ml3o`00
00GoYZoN00?o0000ojN^g?nW[]`02onW[]`00ol0003oZJgJojV]fP08ojV]fP?o000000?oYjWHo`00
0?nYZ=H03?nYZ=H00ol0003oZjSDoj^Xe00<oj^Xe004o`000?n/ZMGo0000o`0000[oZj??00?o0000
ojZTdOnZY=403OnZY=400ol0003oYJCDojFTe003ojFTe0?o00001OnSVld00ol0003oViO?oi^Gc`0:
oi^Gc`03o`000?nITlcoVI?<00[oVI?<00?o0000oifCbOnMTlT02onMTlT00ol0003oXiS:oj>HbP06
oj>HbP;o00001?nUT/400ol0003o[9c7ojbLa`0<ojbLa`?o00002On`Y<`2o`0000?o]ZK900?o0000
okR^d?nh[]001onh[]000ol0003o^:k@okR^d003okR^d003o`000?nh/mGo000000oo_KWF00Co0000
ok^kf_nk^m[o^k_J0_l0000;okk1g003o`000?oooooooooo00Kooooo00?o0000ooooooooool0>Ooo
ool002Gooooo00?o0000ojFbh_nU/^803?nU/^800ol0003oY[;PojJbh00;ojJbh003o`000?nW/Moo
000000;o00002OnV[mh00ol0003oYjkLojN^g00;ojN^g003o`000?nY[M[oZJgJ00GoZJgJ0_l00005
ojNYf003o`000?nYZ=KoZJSF00_oZJSF00?o0000oj^Xe?n[Z=@02on[Z=@2o`0000goZj??00?o0000
ojZTdOnZY=403?nZY=400ol0003oYJCDojFTe003o`0000SoXi_=00?o0000oi^GconKUll02_nKUll0
0ol0003oVI?<oiVCc00;oiVCc003o`000?nMTlWoWI?900[oWI?900?o0000oj>Hb_nSV<X01?nSV<X2
o`0000KoYI;100?o0000ojbLaon/W<L02On/W<L3o`000003ojbLaol0003o/:C<00Oo/:C<0_l00005
okJVb@03o`000?nh[]3o^:k@00Oo^:k@00?o0000okR^d?nh[]000onh[]02o`00017o_KWF00?o0000
ok^kf_l000003_nn`M`00ol0003oooooooooo`06ooooo`03o`000?oooooooooo03Sooooo000Uoooo
o`;o00003_nU/^800ol0003oY[;PojJbh009ojJbh0?o00003?nV[mh00ol0003oYjkLojN^g00;ojN^
g003o`000?nY[M[oZJgJ00?oZJgJ0_l00007ojNYf003o`000?nYZ=KoZJSF00_oZJSF00?o0000oj^X
e?n[Z=@02?n[Z=@3o`000003ojZRcol0003oZj??00coZj??00?o0000ojZTdOnZY=403?nZY=43o`00
00coXi_=00?o0000oi^GconKUll02_nKUll00ol0003oVI?<oiVCc00:oiVCc003o`000?nMTlWoWI?9
00_oWI?900Co0000oj>Hb_nSV<[oXiS:0_l00009ojFB`@03o`000?n/W<Oo[9c700Ko[9c70_l00004
ojbLa`03o`000?n`Y<co/:C<00Go/:C<00?o0000okJVbOnfY/T01_nfY/T00ol0003o^:k@okR^d007
okR^d007o`000?nh[]3o^:k@okR^d?l0003o_[C@o`00000AokfieP;o00003onn`M`00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo03Oooooo000Uooooo`03o`000?oooooo000000koYK;R00?o
0000ojJbh?nV/^001?nV/^04o`0000;oYK3P00?o0000ojJ_g_nV[mh02onV[mh00ol0003oYjkLojN^
g00;ojN^g003o`000?nY[M[o000000;o00002_nWZMP00ol0003oZJSFojVXeP0;ojVXeP03o`000?n[
Z=CoZjSD00GoZjSD0_l00005ojZRc`03o`000?n[XlooZj??00_oZj??00?o0000ojZTdOnZY=402OnZ
Y=42o`000003ojVKb?l0003oXi_=00coXi_=00?o0000oi^GconKUll02_nKUll00ol0003oVI?<oiVC
c00;oiVCc003o`000?nMTlWoWI?900[oWI?900Co0000oj>Hb_l0003o00002onUT/400ol0003o[9c7
ojbLa`03ojbLa`?o00001on/W<L00ol0003o/:C<ok2Tc002ok2Tc0;o00002OnfY/T00ol0003o^:k@
okR^d008okR^d0?o00000onn]=000ol0003o_KWFokfieP0=okfieP03o`000?o2`=So000000oo_/7L
0_l00008ooooo`03o`000?oooooooooo03Oooooo000@ooooo`;o00001?ooool00ol0003ooooooooo
o`02ooooo`?o00001oooool01?l0003oooooooooool0000>ojFbhP03o`000?nV/^3oY[;P00?o0000
1onU/>000ol0003oYZoNojJ_gP0;ojJ_gP03o`000?nW[]coYjkL00[oYjkL0_l0000>ojNYf003o`00
0?nYZ=KoZJSF00[oZJSF00?o0000oj^Xe?n[Z=@00on[Z=@2o`0000OoZZ;?00?o0000oj^Scon[Xll0
2on[Xll00ol0003oZZCAojZTd@07ojZTd@;o00001?nYVlP00ol0003oXi_=oj>Kc@0;oj>Kc@03o`00
0?nKUlooViO?00WoViO?00?o0000oiVCc?nITl`02onITl`00ol0003oWI?9oifCb@0:oifCb@;o0000
3OnUT/400ol0003o[9c7ojbLa`03o`0000[o[9c700?o0000ok2Tc?n`Y<`00_l0000<okJVb@03o`00
0?nh[]3o^:k@00Oo^:k@0_l00005okjdd003o`000?nm^MKo_KWF00[o_KWF0_l00003ol;0f003o`00
0?nn`Mco_/7L00_o_/7L00?o0000ol;8gol000002Oooool00ol0003oooooooooo`0fooooo`003ooo
ool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool000001_ooool01Ol0003o
oooooooooooooooo000000goYK;R0ol0000;ojF`h003o`000?nV[mkoYZoN00_oYZoN00?o0000ojN^
g?nW[]`01_nW[]`3o`000003ojF[fol0003oYjWH00goYjWH00?o0000ojVXe_nYZ=H02onYZ=H00ol0
003oZjSDo`000002o`0000[oZZ;?00?o0000oj^Scon[Xll02on[Xll00ol0003oZZCAojZTd@04ojZT
d@;o00001_nYVlP00ol0003oXi_=oj>Kc@0;oj>Kc@03o`000?nKUlooViO?00[oViO?00?o0000oiVC
c?nITl`02_nITl`00ol0003oWI?9oifCb@07oifCb@?o000000?oWHVno`000?nUT/403?nUT/43o`00
00go[9c700?o0000ok2Tc?l000003onfY/T00ol0003o^:k@okR^d004okR^d0;o000000?o_[C@o`00
0?nn]=001?nn]=000ol0003o_KWFokfieP09okfieP03o`000?o2`=So`/3H00?o`/3H00?o0000okk1
g?nn`M`02Onn`M`2o`0000?o`/SO00?o0000ooooooooool01_ooool2o`0003Oooooo000?ooooo`04
o`000?ooooooooooo`0000_ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`02oooo
o`03o`000?nU/^;oYK;R00OoYK;R0ol000000onT/N;o0000ojF`h00<ojF`h003o`000?nV[mkoYZoN
00[oYZoN00?o0000ojN^g?nW[]`00onW[]`3o`0000GoYJ_K00?o0000ojNYf?nWZMP03?nWZMP00ol0
003oZJSFojVXeP0:ojVXeP;o00003OnZX/l00ol0003oZj??oj^Sc`0<oj^Sc`04o`000?nZY=7oZZCA
ojZTd@;o00002OnYVlP00ol0003oXi_=oj>Kc@0;oj>Kc@03o`000?nKUlooViO?00WoViO?00?o0000
oiVCc?nITl`02onITl`00ol0003oWI?9oifCb@03oifCb@?o00001OnMRKh00ol0003oYI;1ojFB`@07
ojFB`@?o000000?oYI;1o`000?n/W<L03On/W<L2o`00013o]ZK900?o0000okR^d?nh[]000onh[]00
0ol0003o_[C@okjdd002okjdd003o`000?nn]=3o_[C@00?o_[C@00?o0000okfie_nm^MH01_nm^MH2
o`0000Oo`/3H00?o0000okk1g?nn`M`01onn`M`00ol0003o`/SOol;8g`04ol;8g`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool0=Oooool000oooooo00Co0000oooooooooooo00002oooool0
0ol0003oooooooooo`03ooooo`;o00001Oooool00ol0003oYK;RojFbhP03ojFbhP?o00001OnT/N80
0ol0003oYK3PojF`h00;ojF`h003o`000?nV[mkoYZoN00[oYZoN00?o0000ojN^g?l000000_l00009
ojF[f`03o`000?nWZMSoYjWH00_oYjWH00?o0000ojVXe_nYZ=H02?nYZ=H2o`000003ojNSd_l0003o
ZZ;?00goZZ;?00?o0000oj^Scon[Xll02on[Xll01?l0003oZZCAo`000?l0000;ojVKb003o`000?nS
VlgoXi_=00_oXi_=00?o0000oi^GconKUll02_nKUll00ol0003oVI?<oiVCc00:oiVCc003o`000?nM
TlWoWI?900?o00002?nMRKh00ol0003oYI;1ojFB`@04ojFB`@?o00001OnUT/400ol0003o[9c7ojbL
a`0:ojbLa`03o`000?nbW<7o0000017o]ZK900?o0000okR^d?nh[]000_l00006okjdd003o`000?nn
]=3o_[C@00;o_[C@00?o0000okfie_nm^MH01Onm^MH00ol0003o`/3Hol;0f008ol;0f003o`000?nn
`Mco_/7L00Co_/7L0_l00008ol;8g`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0=?oo
ool000oooooo00Co0000oooooooooooo00001oooool4o`0000Kooooo00?o0000ooooooooool01Ooo
ool00ol0003oYK;Ro`000002o`0000WoY;7R00?o0000ojF`h?nU/>002_nU/>000ol0003oYZoNojJ_
gP09ojJ_gP?o00003OnUZm/00ol0003oYjWHojNYf00;ojNYf003o`000?nYZ=KoZJSF00CoZJSF0ol0
0004ojNSdP03o`000?nZX/ooZZ;?00coZZ;?00?o0000oj^Scon[Xll02_n[Xll2o`0000koZI_800?o
0000oj>KcOnSVld02onSVld00ol0003oViO?oi^Gc`09oi^Gc`03o`000?nITlcoVI?<00SoVI?<1Ol0
000;oif9_P04o`000?nUT/7oYI;1ojFB`@?o00002?nUT/400ol0003o[9c7ojbLa`08ojbLa`;o0000
0onbW<400ol0003o]ZK9okJVb@0>okJVb@03o`000?nh[]3o000000So_[C@00?o0000okjdd?nn]=00
0onn]=000ol0003o_KWFokfieP03okfieP03o`000?o2`=So`/3H00Wo`/3H00?o0000okk1g?nn`M`0
0onn`M`00ol0003o`/SOol;8g`08ol;8g`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0
=?ooool000oooooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Kooooo00?o0000ojBah_nT/N802onT/N800ol0003oYK3PojF`h00:ojF`h003o`00
0?nV[mkoYZoN00CoYZoN1?l00002oj>/g@03o`000?nUZm_oYJ_K00_oYJ_K00?o0000ojNYf?nWZMP0
3?nWZMP01?l0003oZJSFojVXe_nYZ=H2o`0000OoYj?B00?o0000ojZRconZX/l03?nZX/l00ol0003o
Zj??oj^Sc`08oj^Sc`;o000000?oZY[6o`000?nYVlP03OnYVlP00ol0003oXi_=oj>Kc@0;oj>Kc@03
o`000?nKUlooViO?00WoViO?00Co0000oiVCc?nITlcoVI?<1ol00003oiF4_P03o`000?nMRKkoWHVn
00_oWHVn0ol0000<ojFB`@03o`000?n/W<Oo[9c700Ko[9c700?o0000ok:L`OnbW<400onbW<400ol0
003o]ZK9okJVb@0>okJVb@;o00002_nn]=000ol0003o_[C@okjdd003okjdd003o`000?nm^MKo_KWF
00;o00003Oo2`=P00ol0003o_/7Lokk1g002o`0000co`/SO00?o0000ooooooooool01_ooool00ol0
003oooooooooo`0cooooo`004?ooool2o`0000Sooooo1Ol00005ooooo`03o`000?oooooooooo00Ko
oooo00?o0000ojBah_nT/N803?nT/N800ol0003oYK3PojF`h00:ojF`h003o`000?nV[mkoYZoN00?o
00001onS[=d00ol0003oYJ_KojF[f`0;ojF[f`03o`000?nWZMSoYjWH00_oYjWH00Co0000ojVXe_l0
003o00002_nWXm800ol0003oZZ;?ojZRc`0<ojZRc`03o`000?n[XlooZj??00GoZj??0_l00004ojZJ
aP03o`000?nYVlSoZI_800coZI_800?o0000oj>KcOnSVld02onSVld00ol0003oViO?oi^Gc`06oi^G
c`Ko00002_nEQ;h00ol0003oWHVnoif9_P09oif9_P?o00003_nUT/400ol0003o[9c7ojbLa`04ojbL
a`;o00001onbW<400ol0003o]ZK9okJVb@0<okJVb@03o`000?nn[LSo000000_o_[C@00?o0000okjd
d?nn]=000_nn]=000ol0003o_KWFo`00000?ol;0f003o`000?nn`Mco000000oo`/SO00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`0booooo`008oooool3o`0000Sooooo00?o0000ojBah_nT
/N802onT/N800ol0003oYK3PojF`h00:ojF`h0?o00002onS[=d00ol0003oYJ_KojF[f`0;ojF[f`03
o`000?nWZMSoYjWH00[oYjWH0_l0000<ojNSdP03o`000?nZX/ooZZ;?00coZZ;?00?o0000oj^Scon[
Xll01?n[Xll00ol0003oZY[6ojZJaP04ojZJaP03o`000?nYVlSoZI_800coZI_800?o0000oj>KcOnS
Vld02onSVld01?l0003oViO?oi^GconKUll5o`0000?oU8O300?o0000oiF4__nEQ;h02onEQ;h00ol0
003oWHVnoif9_P05oif9_P?o00000_nMRKh00ol0003oYI;1ojFB`@0<ojFB`@03o`000?n/W<Oo[9c7
00?o[9c700?o0000ok:L`OnbW<401onbW<400ol0003o]ZK9okJVb@0;okJVb@05o`000?nn[LSo_Zg8
okj]b?l000002onn]=001?l0003o_[C@okjdd?nn]=02o`00013o`/3H0_l0000@ol;8g`;o00001ooo
ool00ol0003oooooooooo`0booooo`009?ooool00ol0003oooooooooo`08ooooo`03o`000?nT/N;o
Y;7R00_oY;7R00?o0000ojF`h?nU/>001_nU/>03o`000003oj:^h?l0003oXjcM00coXjcM00?o0000
ojF[fonUZm/02_nUZm/00ol0003oYjWHojNYf007ojNYf0?o000000?oY:GFo`000?nWXm803?nWXm80
0ol0003oZZ;?ojZRc`0<ojZRc`04o`000?n[XlooZj??oj^Sc`;o00002?nZV/H00ol0003oZI_8ojVK
b00<ojVKb003o`000?nSVlgoXi_=00[oXi_=1?l00009oiB7``03o`000?nEQ;koUHBn00[oUHBn00?o
0000oif9__nMRKh00_nMRKh3o`0000KoWHVn00?o0000ojFB`OnUT/403?nUT/400ol0003o[9c7ojbL
a`02o`0000_o/Yc100?o0000okJVbOnfY/T02OnfY/T00ol0003o_Zg8okj]b002okj]b003o`000?nn
]=3o_[C@00Wo_[C@00Ko0000okjdd?nn]=3o0000olJnd_l0000?ol;0f003o`000?o7bMco000000oo
`/SO00?o0000ol?>hol000001oooool2o`0003?ooooo000Sooooo`03o`000?oooooooooo00[ooooo
00?o0000ojBah_nT/N802onT/N800ol0003oYK3PojF`h003ojF`h0;o00001OnR[^000ol0003oXjcM
oj>/g@0;oj>/g@03o`000?nUZm_oYJ_K00[oYJ_K00?o0000ojNYf?nWZMP00onWZMP3o`0000GoY:GF
00?o0000ojNSd_nWXm802onWXm800ol0003oZZ;?ojZRc`0;ojZRc`04o`000?n[Xloo0000o`0000[o
ZY[600?o0000ojVKb?nYVlP03?nYVlP00ol0003oXi_=oj>Kc@07oj>Kc@?o000000?oX8k1o`000?nD
Ql<02_nDQl<00ol0003oUHBnoiF4_P0:oiF4_P03o`000?nMRKko000000;o00002OnMRKh00ol0003o
YI;1ojFB`@0<ojFB`@03o`000?n/W<Oo000000ko/Yc100?o0000okJVbOnfY/T01onfY/T00ol0003o
_Zg8okj]b004okj]b003o`000?nn]=3o_[C@00Wo_[C@0_l00003olJndP03o`000?o2`=So`/3H00_o
`/3H00Go0000olO9g?o7bMcoalWLo`00000<ol;8g`;o00000oo3c^<00ol0003oooooooooo`06oooo
o`03o`000?oooooooooo033ooooo000Sooooo`03o`000?oooooooooo00_ooooo00?o0000ojBah_nT
/N802onT/N800ol0003oYK3Po`000002o`0000SoXZkP00?o0000oj>/gOnS[=d02_nS[=d00ol0003o
YJ_KojF[f`0;ojF[f`03o`000?nWZMSo000000;o00002?nTYMH00ol0003oYj?BojNSdP0;ojNSdP03
o`000?nZX/ooZZ;?00_oZZ;?0_l0000=ojZJaP03o`000?nYVlSoZI_800coZI_800?o0000oj>KcOnS
Vld00onSVld3o`0000GoX8k100?o0000oiB7`onDQl<02?nDQl<00ol0003oUHBnoiF4_P09oiF4_P?o
00003?nMRKh00ol0003oYI;1ojFB`@0<ojFB`@;o00003onbW<400ol0003o]ZK9okJVb@05okJVb@;o
00001onn[LP00ol0003o_[C@okjdd008okjdd0?o00001?o6_]800ol0003o`/3Hol;0f008ol;0f0;o
00001Oo7bM`00ol0003o`/SOol;8g`07ol;8g`;o00001_o3c^<00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo033ooooo000Sooooo`;o00003Oooool00ol0003oY;7RojBahP09ojBahP?o0000
3?nR[^000ol0003oXjcMoj>/g@0:oj>/g@03o`000?nUZm_oYJ_K00WoYJ_K0ol0000<ojBUeP03o`00
0?nWXm;oYj?B00_oYj?B00?o0000ojZRconZX/l01onZX/l3o`000003ojNJbOl0003oZY[600coZY[6
00?o0000ojVKb?nYVlP03?nYVlP00ol0003oXi_=oj>Kc@03o`0000SoX8k100?o0000oiB7`onDQl<0
2OnDQl<00ol0003oUHBnoiF4_P05oiF4_P?o00000_nEQ;h00ol0003oWHVnoif9_P0;oif9_P03o`00
0?nUT/7oYI;100WoYI;10_l000000onZS[Wo0000ok:L`@0?ok:L`@03o`000?nfY/Wo]ZK900?o]ZK9
00?o0000okj]b?nn[LP02?nn[LP00ol0003o_[C@okjdd006okjdd005o`000?o6_];oa[kBolJnd_l0
00000oo6_]800ol0003o`/3Hol;0f007ol;0f003o`000?o7bMcoalWL00GoalWL00?o0000ol;8goo2
b=l01_o2b=l00ol0003o`lkSol?>h`07ol?>h`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool0;oooool002?ooooo00?o0000ooooooooool03Oooool00ol0003oY;7RojBahP04ojBahPCo0000
0_nR/>800ol0003oXZkPoj:^h00;oj:^h003o`000?nS[=goXjcM00[oXjcM00?o0000ojF[fonUZm/0
1?nUZm/4o`0000;oXZOJ00?o0000ojBUe_nTYMH02onTYMH00ol0003oYj?BojNSdP0:ojNSdP03o`00
0?nZX/ooZZ;?00GoZZ;?0_l00005ojNJb@03o`000?nZV/KoZY[600_oZY[600?o0000ojVKb?nYVlP0
2onYVlP3o`0000_oX8k100?o0000oiB7`onDQl<02OnDQl<00ol0003oUHBnoiF4_P02oiF4_P?o0000
1OnEQ;h00ol0003oWHVnoif9_P0;oif9_P03o`000?nUT/7oYI;100OoYI;10_l00004ojZ>^@03o`00
0?nbW<7o/Yc100go/Yc100?o0000okJVbOnfY/T00_nfY/T00ol0003o_Zg8okj]b00:okj]b003o`00
0?nn]=3o_[C@00Co_[C@00?o0000olJnd_o6_]800_o6_]800ol0003oa[kBolJndP02olJndP03o`00
0?o2`=So`/3H00Go`/3H00?o0000olO9g?o7bM`01oo7bM`00ol0003o`/SOol;8g`03ol;8g`;o0000
2_o3c^<00ol0003oooooooooo`06ooooo`03o`000?oooooooooo02kooooo000Sooooo`03o`000?oo
oooooooo00kooooo00?o0000ojBah_nT/N800ol00007oj:`hP03o`000?nR[^3oXZkP00[oXZkP00?o
0000oj>/gOnS[=d02onS[=d00ol0003oYJ_KojF[f`03o`0000OoXZOJ00?o0000ojBUe_nTYMH02_nT
YMH00ol0003oYj?BojNSdP0;ojNSdP03o`000?nZX/ooZZ;?00;oZZ;?0_l00007ojNJb@03o`000?nZ
V/KoZY[600_oZY[600?o0000ojVKb?nYVlP02OnYVlP2o`000003ojN>^ol0003oX8k100coX8k100?o
0000oiB7`onDQl<02?nDQl<00ol0003oUHBno`000002o`0000WoUHBn00?o0000oif9__nMRKh02_nM
RKh00ol0003oYI;1ojFB`@05ojFB`@;o00001_nZS[T00ol0003o/Yc1ok:L`@0>ok:L`@04o`000?nf
Y/Wo]ZK9o`0000go_Zg800?o0000okjdd?nn]=000_nn]=02o`0000Koa[kB00?o0000olJnd_o6_]80
0_o6_]800ol0003o`/3Hol;0f002ol;0f0;o00002_o7bM`01?l0003o`/SOol;8goo2b=l2o`0000go
`lkS00?o0000ooooooooool01Oooool00ol0003oooooooooo`0^ooooo`008oooool00ol0003ooooo
ooooo`0?ooooo`;o00002onR/>800ol0003oXZkPoj:^h00:oj:^h003o`000?nS[=goXjcM00WoXjcM
1?l0000;oj:WfP03o`000?nTYMKoY:GF00[oY:GF00?o0000ojNSd_nWXm802_nWXm800ol0003oZZ;?
o`000002o`0000WoYi[900?o0000ojZJa_nZV/H02onZV/H00ol0003oZI_8ojVKb008ojVKb003o`00
0?nWS[_oYhjk00;oYhjk00?o0000oj2>`OnPS/402_nPS/400ol0003oU8O3oiB7``07oiB7``?o0000
3?nEQ;h00ol0003oWHVnoif9_P0;oif9_P03o`000?nUT/7oYI;100?oYI;100?o0000ojZ>^OnZS[T0
1_nZS[T00ol0003o/Yc1ok:L`@0>ok:L`@03o`000?nfY/Wo000000oo_Zg800Co0000okjdd?nn]=3o
00002Oo6_]801Ol0003oa[kBolJnd_o6_];o000000?o`/3H00?o0000olO9g?o7bM`02oo7bM`00ol0
003o`/SOo`00000?ol?>h`;o00001oooool00ol0003oooooooooo`0]ooooo`008_ooool2o`00017o
oooo00?o0000oj:`h_nR/>802onR/>800ol0003oXZkPoj:^h00:oj:^h003o`000?nS[=goXjcM00Co
XjcM1?l00002oj2Yg@03o`000?nRYm[oXZOJ00[oXZOJ00?o0000ojBUe_nTYMH02_nTYMH00ol0003o
Yj?BojNSdP0:ojNSdP;o00003OnWV/T00ol0003oZY[6ojZJaP0;ojZJaP03o`000?nYVlSoZI_800Go
ZI_80_l00005ojN>^`03o`000?nPS/7oX8k100[oX8k100?o0000oiB7`onDQl<01OnDQl<2o`0000;o
U8O300?o0000oiF4__nEQ;h02_nEQ;h00ol0003oWHVnoif9_P0;oif9_P04o`000?nUT/7oYI;1ojFB
`@;o00002_nZS[T00ol0003o/Yc1ok:L`@0=ok:L`@;o00004?nn[LP00ol0003o_[C@o`00000:olJn
dP03o`000?o6_];oa[kB00;oa[kB00?o0000ol;0f?l000003_o7bM`2o`0000ko`lkS0_l000000oo3
e>Oo0000ooooo`06ooooo`;o0000;_ooool002;ooooo00?o0000ooooooooool04Oooool00ol0003o
X[3Roj:`hP0;oj:`hP03o`000?nR[^3oXZkP00[oXZkP00?o0000oj>/gOnS[=d00ol00007oj2Yg@03
o`000?nRYm[oXZOJ00[oXZOJ00?o0000ojBUe_nTYMH02_nTYMH00ol0003oYj?BojNSdP06ojNSdP?o
000000?oXic>o`000?nWV/T03?nWV/T00ol0003oZY[6ojZJaP0;ojZJaP03o`000?nYVlSoZI_800?o
ZI_80_l00007ojN>^`03o`000?nPS/7oX8k100_oX8k100Co0000oiB7`onDQl?oU8O30ol00005oiB7
``03o`000?nEQ;koUHBn00[oUHBn00?o0000oif9__nMRKh02_nMRKh01?l0003oYI;1o`000?l0000<
ojZ>^@03o`000?nbW<7o/Yc100co/Yc100?o0000okbR__l000004Onn[LP00ol0003oa[kBolJndP0:
olJndP04o`000?o6_];oa[kBolJndP;o00003_o7bM`01?l0003obM?QolWChOl0000<ol?>h`03o`00
0?o3e>Oo`mCW00;o`mCW00?o0000ooooooooool01Oooool00ol0003oooooooooo`07ooooo`?o0000
8_ooool002;ooooo00?o0000ooooooooool04_ooool00ol0003oX[3Roj:`hP0:oj:`hP03o`000?nR
[^3oXZkP00WoXZkP1?l0000;oj2Yg@03o`000?nRYm[oXZOJ00[oXZOJ00?o0000ojBUe_nTYMH02_nT
YMH00ol0003oYj?BojNSdP02ojNSdP?o00001OnSW<h00ol0003oYi[9ojNJb@0;ojNJb@03o`000?nZ
V/KoZY[600_oZY[600Go0000ojVKb?nYVlSoZI_8o`00000:ojN>^`03o`000?nPS/7oX8k100[oX8k1
1?l00008oiB7``03o`000?nEQ;koUHBn00[oUHBn00?o0000oif9__nMRKh02_nMRKh2o`0000koZXji
00?o0000ok:L`OnbW<402onbW<401Ol0003o_::nokbR__nlX[ko000000oo_Zg80_l0000=olJndP05
o`000?o6_];o0000olg;eol000003?o7bM`2o`0000CobM?Q00?o0000ol?>hoo3c^<01oo3c^<2o`00
00Ko`mCW00?o0000ooooooooool01Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
027ooooo000Rooooo`03o`000?oooooooooo01?ooooo00?o0000oj:`h_nR/>802_nR/>800ol0003o
XZkPoj:^h004oj:^h0Co00000_nO[>000ol0003oX:WMoj2Yg@0:oj2Yg@03o`000?nRYm[oXZOJ00[o
XZOJ00?o0000ojBUe_nTYMH02_nTYMH00ol0003oYj?Bo`000002o`0000SoXic>00?o0000ojNJbOnW
V/T02onWV/T00ol0003oZY[6ojZJaP0;ojZJaP04o`000?nYVlSo0000o`0000_oYhjk00?o0000oj2>
`OnPS/402?nPS/43o`0000_oU8O300?o0000oiF4__nEQ;h02_nEQ;h00ol0003oWHVnoif9_P08oif9
_P;o000000?oWh2ao`000?nZS[T03_nZS[T00ol0003o/Yc1ok:L`@09ok:L`@03o`000?nlX[ko_::n
00;o_::n00?o0000okj]b?nn[LP03?nn[LP01?l0003obKW;olVibol0000=olJndP05o`000?o=bmOo
cL_Golg;eol000002_o7bM`00ol0003obM?QolWCh@05olWCh@03o`000?o3c^?o`lkS00Co`lkS0_l0
0009ol?Di`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`0Qooooo`008_ooool3o`0001Cooooo00?o0000oj:`h_nR/>802_nR/>800ol0003oXZkPoj:^h003
o`0000OoWjcP00?o0000oj2YgOnPZMd02_nPZMd00ol0003oXZOJoj:WfP0:oj:WfP03o`000?nTYMKo
Y:GF00SoY:GF0ol0000<oj>LcP03o`000?nWV/WoYi[900[oYi[900?o0000ojZJa_nZV/H02onZV/H2
o`0000goYhjk00?o0000oj2>`OnPS/401OnPS/43o`0000?oX8k100?o0000oiB7`onDQl<02OnDQl<0
0ol0003oUHBnoiF4_P0:oiF4_P03o`000?nMRKkoWHVn00GoWHVn0_l00004oin0/@03o`000?nZS[Wo
ZXji00coZXji00?o0000ok:L`OnbW<402?nbW<400ol0003o_::nokbR_P04okbR_P03o`000?nn[LSo
_Zg800[o_Zg800?o0000olViboo9^L/00_o9^L/00ol0003oa[kBolJndP09olJndP;o00001?o=bmL0
0ol0003oalWLolO9g005olO9g0;o00002Oo9dn400ol0003o`lkSol?>h`02ol?>h`03o`000?o3e>Oo
`mCW00[o`mCW00?o0000ooooooooool01?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooo
oooo027ooooo000Rooooo`03o`000?oooooooooo01Gooooo00?o0000oj:`h_nR/>802?nR/>84o`00
00_oWjcP00?o0000oj2YgOnPZMd02_nPZMd00ol0003oXZOJoj:WfP09oj:WfP03o`000?nTYMKoY:GF
00CoY:GF1?l00002oinOe003o`000?nSW<koXic>00[oXic>00?o0000ojNJbOnWV/T02onWV/T00ol0
003oZY[6ojZJaP08ojZJaP;o000000?oYhjlo`000?nWS[/03OnWS[/01?l0003oX8k1oj2>`OnPS/43
o`0000KoX8k100?o0000oiB7`onDQl<02OnDQl<00ol0003oUHBnoiF4_P0:oiF4_P03o`000?nMRKko
WHVn00?oWHVn0_l00006oin0/@03o`000?nZS[WoZXji00goZXji00?o0000ok:L`OnbW<401OnbW<42
o`0000Oo_::n00?o0000okj]b?nn[LP02Onn[LP00ol0003obKW;olVib`03olVib`03o`000?o6_];o
a[kB00Soa[kB00Co0000olg;eoo=bmOo00001?o=bmL00ol0003oalWLolO9g003olO9g003o`000?o9
dn7obM?Q00[obM?Q00Co0000ol?>hol0003o00003Oo3e>L2o`0000Kooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`0Qooooo`006?ooool3o`0000Oooooo00?o0000ooooooooool05_oo
ool00ol0003oX[3Roj:`hP04oj:`hP?o00000_nO[^800ol0003oWjcPoin/h00:oin/h003o`000?nP
ZMgoX:WM00[oX:WM00?o0000oj:Wf_nRYmX02_nRYmX00ol0003oY:GFojBUeP03o`0000OoWioD00?o
0000oj>Lc_nSW<h02_nSW<h00ol0003oYi[9ojNJb@0:ojNJb@03o`000?nZV/KoZY[600KoZY[60_l0
0004ojN>_003o`000?nWS[_oYhjk00_oYhjk1?l00009oj2>`@03o`000?nDQl?oU8O300WoU8O300?o
0000oiF4__nEQ;h02_nEQ;h01?l0003oWHVnoif9__nMRKh2o`0000SoWh2a00?o0000ojZ>^OnZS[T0
3OnZS[T00ol0003o/Yc1ok:L`@04ok:L`@03o`000?nlX[ko_::n00So_::n00?o0000okj]b?nn[LP0
1onn[LP00ol0003obKW;olVib`05olVib`03o`000?o6_];oa[kB00Goa[kB0_l00004olg;e`05o`00
0?o=bmOocL_Golg;eol000000oo7bM`2o`0000gobM?Q0_l0000=ol?Di`;o000000?o`MS[o`000?oo
ool01Oooool00ol0003oooooooooo`04ooooo`;o00008oooool001Wooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`0Hooooo`03o`000?nR/>;oX[3R00?o00001_nO[^800ol0003oWjcP
oin/h00:oin/h003o`000?nPZMgoX:WM00[oX:WM00?o0000oj:Wf_nRYmX02?nRYmX4o`0000[oWioD
00?o0000oj>Lc_nSW<h02_nSW<h00ol0003oYi[9ojNJb@0;ojNJb@03o`000?nZV/KoZY[600?oZY[6
0_l00006ojN>_003o`000?nWS[_oYhjk00WoYhjk0ol0000=oj2>`@03o`000?nDQl?oU8O300WoU8O3
00?o0000oiF4__nEQ;h02_nEQ;h3o`0000_oWh2a00?o0000ojZ>^OnZS[T03?nZS[T00ol0003o/Yc1
ok:L`@03ok:L`@03o`000?nlX[ko_::n00Wo_::n00?o0000okj]b?nn[LP01_nn[LP00ol0003obKW;
olVib`06olVib`03o`000?o6_];oa[kB00Coa[kB00?o0000olg;eoo=bmL01?o=bmL00ol0003ocL_G
olg;e`02olg;e`03o`000?o7bMco000000kobM?Q00?o0000olWKiol000002oo3e>L2o`0000Co`MS[
00?o0000ooooooooool00_ooool3o`0000Kooooo00?o0000ooooooooool08Oooool001Wooooo00?o
0000ooooooooool01Oooool2o`0001[ooooo0_l0000:oin^hP03o`000?nO[>3oWjcP00[oWjcP00?o
0000oj2YgOnPZMd02OnPZMd00ol0003oXZOJoj:WfP04oj:WfPCo00000_nLXmT00ol0003oWioDoinO
e00:oinOe003o`000?nSW<koXic>00[oXic>00?o0000ojNJbOnWV/T02_nWV/T01?l0003oZY[6ojZJ
a_nZV/H2o`0000SoYhjl00?o0000ojN>^onWS[/01onWS[/2o`0000?oYhjk00?o0000oj2>`OnPS/40
2_nPS/400ol0003oU8O3oiB7``09oiB7``03o`000?nEQ;koUHBn00OoUHBn1?l0000=oin0/@03o`00
0?nZS[WoZXji00goZXji00Go0000ok:L`OnbW<7o/Yc1o`00000<okbR_P03o`000?nn[LSo_Zg800Go
_Zg800?o0000olViboo9^L/02?o9^L/00ol0003oa[kBolJndP02olJndP03o`000?o=bmOocL_G00Ko
cL_G00Co0000olg;eoo=bmOocL_G0_l0000=olWCh@;o00000oo9fnL00ol0003o`mCWol?Di`06ol?D
i`;o00001oo1f>/00ol0003oooooooooo`04ooooo`03o`000?oooooooooo02Oooooo000Iooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool06Oooool00ol0003oWjkRoin^hP0:oin^hP03
o`000?nO[>3oWjcP00[oWjcP00?o0000oj2YgOnPZMd02OnPZMd00ol0003oXZOJoj:WfP03o`0000Oo
W:?I00?o0000oinOe?nOWm@02OnOWm@00ol0003oXic>oj>LcP0:oj>LcP03o`000?nWV/WoYi[900[o
Yi[900Co0000ojZJa_l0003o00002onWS[`00ol0003oYhjkojN>^`03ojN>^`?o00001OnWS[/00ol0
003oX8k1oj2>`@0:oj2>`@03o`000?nDQl?oU8O300WoU8O300Co0000oiF4__nEQ;koUHBn1_l00003
oi9c[@03o`000?nOP;7oWh2a00_oWh2a00?o0000ojZ>^OnZS[T03OnZS[T01?l0003o/Yc1ok:L`Ol0
000>okbR_P03o`000?nn[LSo_Zg800?o_Zg800?o0000olViboo9^L/02_o9^L/01?l0003oa[kBolJn
d_l0000:olg;e`05o`000?o=bmOo0000om;Ig_l000002oo9dn42o`0000KobM_W00?o0000ol?Dioo3
e>L01?o3e>L00ol0003o`MS[ol7Hj`07ol7Hj`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool09oooool001Wooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Jooooo`03o`00
0?nO[^;oWjkR00[oWjkR00?o0000oin/h?nO[>002OnO[>000ol0003oX:WMoj2Yg@07oj2Yg@Go0000
2_nLXmT00ol0003oWioDoinOe00:oinOe003o`000?nSW<koXic>00[oXic>00?o0000ojNJbOnWV/T0
2OnWV/T2o`0000goYhjl00?o0000ojN>^onWS[/00ol00008ojN>^`03o`000?nPS/7oX8k100[oX8k1
4?l00009oi9c[@03o`000?nOP;7oWh2a00coWh2a00?o0000ojZ>^OnZS[T03?nZS[T00ol0003o/Yc1
o`00000?okbR_P03o`000?nn[LSo_Zg800;o_Zg800?o0000olViboo9^L/02oo9^L/00ol0003oa[kB
o`00000<olg;e`05o`000?oBfMkod]WNom;Ig_l000002Oo9dn400ol0003obM_WolWKi`06olWKi`03
o`000?o3e>Oo`mCW00;o`mCW0_l0000;ol7Hj`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool09_ooool001Sooooo0_l00007ooooo`03o`000?oooooooooo01_ooooo00?o0000oin^h_nO[^80
2OnO[^800ol0003oWjcPoin/h00:oin/h004o`000?nPZMgoX:WMoj2Yg@Go00000onKY]h00ol0003o
W:?IoibSf@0:oibSf@03o`000?nOWmCoWioD00[oWioD00?o0000oj>Lc_nSW<h02OnSW<h00ol0003o
Yi[9ojNJb@06ojNJb@?o000000?oXY32o`000?nWS[`03?nWS[`3o`0000coYhjk00?o0000oj2>`OnP
S/401_nPS/43o`000003oiYk/?l0003oRg:a00[oRg:a00?o0000oi9c[OnBLjd02_nBLjd00ol0003o
Wh2aoin0/@0;oin0/@03o`000?nZS[WoZXji00coZXji0_l0000AokbR_P04o`000?nn[LSo_Zg8o`00
00oobKW;00?o0000olg;eoo=bmL02_o=bmL2o`0000Cod]WN00?o0000olWChOo9dn401?o9dn42o`00
00[obM_W00Co0000ol?Diol0003o00003Oo1f>/2o`0000Kooooo00?o0000ooooooooool09Oooool0
01Wooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Looooo`03o`000?nO[^;oWjkR
00WoWjkR00?o0000oin/h?nO[>002?nO[>05o`0000WoVjKN00?o0000oibSfOnLXmT02_nLXmT00ol0
003oWioDoinOe009oinOe003o`000?nSW<koXic>00[oXic>00?o0000ojNJbOnWV/T00_nWV/T3o`00
00GoXY3200?o0000ojN>_?nWS[`01onWS[`3o`000003ojN>_?l0003oYhjk00coYhjk00?o0000oj2>
`OnPS/401?nPS/42o`0000CoVW^`00?o0000oh]b/On;L[402On;L[400ol0003oTW>]oi9c[@0:oi9c
[@03o`000?nOP;7oWh2a00_oWh2a00?o0000ojZ>^OnZS[T02onZS[T00ol0003o]9:co`00000AokbR
_P03o`000?nn[LSo000000oobKW;0_l0000;olg;e`04o`000?oBfMkod]WNo`0000Cod]WN00Co0000
olWChOo9dn7obM?Q0_l0000<olWKi`;o00003Oo1f>/2o`000003okgIk_l0003ooooo00Gooooo00?o
0000ooooooooool09Oooool0023ooooo00?o0000ooooooooool07_ooool00ol0003oWjkRoin^hP09
oin^hP03o`000?nO[>3oWjcP00CoWjcP0ol00002oi^Zh@03o`000?nKY]koVjKN00[oVjKN00?o0000
oibSfOnLXmT02OnLXmT00ol0003oWioDoinOe00:oinOe003o`000?nSW<koXic>00WoXic>00?o0000
ojNJbOl000000_l00008oj:@`P03o`000?nWS[coYhjl00CoYhjl0ol00004ojN>_003o`000?nWS[_o
Yhjk00_oYhjk00?o0000oj2>`OnPS/400_nPS/42o`0000OoVW^`00?o0000oh]b/On;L[402On;L[40
0ol0003oTW>]oi9c[@09oi9c[@03o`000?nOP;7oWh2a00coWh2a00?o0000ojZ>^OnZS[T02OnZS[T0
1Ol0003o]9:cokBB/ondT[?o0000017o_::n00?o0000olViboo9^L/03Oo9^L/01?l0003oe/c@omK<
d?l00008olg;e`;o00001?oBfMh00ol0003od]WNom;IgP02om;IgP03o`000?o9dn7o000000gobM_W
00Co0000olGPk?o5h>co00002_o1f>/2o`0000Co_MW^00?o0000ooooooooool01?ooool2o`0002Go
oooo000Pooooo`03o`000?oooooooooo01kooooo00?o0000oin^h_nO[^802_nO[^800ol0003oWjcP
oin/h003o`0000KoVj[Q00?o0000oi^Vg_nKY]h02OnKY]h00ol0003oW:?IoibSf@0:oibSf@03o`00
0?nOWmCoWioD00WoWioD00?o0000oj>Lc_nSW<h02?nSW<h3o`0000_oXY3200Co0000ojN>_?nWS[co
Yhjl0ol00007ojN>_003o`000?nWS[_oYhjk00coYhjk1?l00009oiYk/003o`000?n;L[7oRg:a00Wo
Rg:a00?o0000oi9c[OnBLjd02_nBLjd00ol0003oWh2aoin0/@0;oin0/@03o`000?nZS[WoZXji00So
ZXji00?o0000okBB/ondT[<00_ndT[<00ol0003o_::nokbR_P0?okbR_P03o`000?o9^L_obKW;00co
bKW;00?o0000omK<d?oFc=000_oFc=000ol0003ocL_Golg;e`04olg;e`03o`000?oBfMkod]WN00Go
d]WN00Co0000om;Ig_oBfMkod]WN0_l0000=olWKi`03o`000?o5h>coaN3/00;oaN3/00?o0000ol7H
joo1f>/01Oo1f>/2o`0000Oo_MW^00?o0000ooooooooool00oooool2o`0002Gooooo000Pooooo`03
o`000?oooooooooo01oooooo00?o0000oin^h_nO[^801onO[^85o`0000[oVj[Q00?o0000oi^Vg_nK
Y]h02OnKY]h00ol0003oW:?IoibSf@09oibSf@03o`000?nOWmCoWioD00[oWioD00?o0000oj>Lc_nS
W<h00onSW<h4o`0000;oVi?;00?o0000oj:@`_nRT<802_nRT<83o`0000_oYhjl00?o0000ojN>^onW
S[/02_nWS[/2o`0000coVW^`00?o0000oh]b/On;L[402On;L[400ol0003oTW>]oi9c[@0:oi9c[@03
o`000?nOP;7oWh2a00_oWh2a00?o0000ojZ>^OnZS[T01onZS[T00ol0003o]9:cokBB/`04okBB/`03
o`000?nlX[ko_::n00go_::n00?o0000ol^a`?l000003?o9^L/00ol0003oe/c@omK<d004omK<d003
o`000?o=bmOocL_G00;ocL_G00?o0000om;Ig_oBfMh01_oBfMh01?l0003od]WNom;Ig_l00002om7U
i@03o`000?o9fnOobM_W00SobM_W0_l00006olGPk003o`000?o1f>_o`MS[00;o`MS[0_l0000:okgI
kP03o`000?oooooooooo00?ooooo00?o0000ooooooooool08oooool0023ooooo00?o0000oooooooo
ool08?ooool01?l0003oWjkRoin^h_nO[^85o`0000?oVjgT00?o0000oi^ZhOnKZ^402OnKZ^400ol0
003oVjKNoi^VgP0:oi^VgP03o`000?nLXmWoW:?I00WoW:?I00?o0000oinOe?nOWm@02OnOWm@00ol0
003oXic>oj>LcP03o`0000OoVi?;00?o0000oj:@`_nRT<801_nRT<84o`0000goYhjl00?o0000ojN>
^onWS[/02?nWS[/2o`000003ojAoZol0003oVW^`00_oVW^`00?o0000oh]b/On;L[402On;L[400ol0
003oTW>]oi9c[@0:oi9c[@03o`000?nOP;7oWh2a00coWh2a00?o0000ojZ>^OnZS[T01OnZS[T00ol0
003o]9:cokBB/`05okBB/`03o`000?nlX[ko_::n00co_::n00Go0000ol^a`?o;/L3obk70o`00000:
olVib`03o`000?oFc=3oe/c@00Goe/c@00Go0000olg;eoo=bmOocL_Go`00000:om;IgP;o00001?oA
iND00ol0003obM_WolWKi`06olWKi`03o`000?o5h>coaN3/00OoaN3/00Co0000ol7Hjol0003o0000
3OnmfNh00ol0003oooooooooo`03ooooo`03o`000?oooooooooo02;ooooo000Pooooo`;o00008_oo
ool3o`0000WoVjgT00?o0000oi^ZhOnKZ^402OnKZ^400ol0003oVjKNoi^VgP0:oi^VgP03o`000?nL
XmWoW:?I00WoW:?I00?o0000oinOe?nOWm@01_nOWm@5o`0000[oVi?;00?o0000oj:@`_nRT<801?nR
T<82o`0000CoXY3200?o0000ojN>_?nWS[`02_nWS[`00ol0003oYhjkojN>^`07ojN>^`05o`000?nT
Oj_oY7n[ojAoZol000003OnJNk000ol0003oRg:aoh]b/@09oh]b/@03o`000?nBLjgoTW>]00WoTW>]
00?o0000oin0/OnOP;403?nOP;400ol0003oZXjiojZ>^@04ojZ>^@03o`000?ndT[?o]9:c00Oo]9:c
00?o0000okbR__nlX[h02_nlX[h00ol0003obk70ol^a`002ol^a`003o`000?o9^L_obKW;00OobKW;
00?o0000omK<d?oFc=001ooFc=000ol0003ocL_Go`00000;om;IgP;o00001OoAiND00ol0003obM_W
olWKi`03olWKi`;o00002_o5h>`2o`0000oo_MW^0_l00004ooooo`03o`000?oooooooooo02;ooooo
000Pooooo`03o`000?oooooooooo027ooooo00?o0000oi^]i?nK[N@02_nK[N@00ol0003oVj[Qoi^Z
h@09oi^Zh@03o`000?nKY]koVjKN00WoVjKN00?o0000oibSfOnLXmT02OnLXmT01?l0003oWioDoinO
e?nOWm@5o`0000?oUiWC00?o0000oi^CbonKTl/02_nKTl/00ol0003oXY32oj:@`P03o`0000KoXY32
00?o0000ojN>_?nWS[`02onWS[`00ol0003oYhjkojN>^`04ojN>^`;o00001OnTOj/00ol0003oVW^`
oiYk/00:oiYk/003o`000?n;L[7oRg:a00WoRg:a00?o0000oi9c[OnBLjd02_nBLjd00ol0003oWh2a
oin0/@0;oin0/@03o`000?nZS[WoZXji00?oZXji00?o0000okBB/ondT[<02?ndT[<00ol0003o_::n
okbR_P09okbR_P03o`000?o;/L3obk7000Cobk7000?o0000olViboo9^L/01Oo9^L/00ol0003oe/c@
omK<d009omK<d003o`000?oBfMkod]WN00Wod]WN00?o0000om7UiOl000001_oAiND01Ol0003obM_W
olWKioo9fnOo000000[oaN3/0_l00002okoQl003o`000?nmfNko_MW^00Wo_MW^0ol000000onifO7o
0000ooooo`04ooooo`03o`000?oooooooooo027ooooo000Oooooo`03o`000?oooooooooo02?ooooo
00?o0000oi^]i?nK[N@02_nK[N@00ol0003oVj[Qoi^Zh@09oi^Zh@03o`000?nKY]koVjKN00WoVjKN
00?o0000oibSfOnLXmT01?nLXmT8o`0000WoUiWC00?o0000oi^CbonKTl/02OnKTl/3o`0000WoXY32
00?o0000ojN>_?nWS[`02onWS[`00ol0003oYhjkojN>^`02ojN>^`;o00001onTOj/00ol0003oVW^`
oiYk/00:oiYk/003o`000?n;L[7oRg:a00WoRg:a00?o0000oi9c[OnBLjd02_nBLjd00ol0003oWh2a
oin0/@0<oin0/@05o`000?nZS[WoZXjiojZ>^Ol000003?ndT[<00ol0003o_::nokbR_P07okbR_P03
o`000?o;/L3obk7000Gobk7000?o0000olViboo9^L/01?o9^L/00ol0003oe/c@omK<d009omK<d003
o`000?oNh]So000000Wod]WN00Go0000om7UiOoAiNGodNGUo`000006om7Ui@03o`000?o9fnOo0000
00[oaN3/00?o0000okoQl?nohO000onohO000ol0003o_MW^okgIkP06okgIkP;o00001OnifO400ol0
003oooooooooo`03ooooo`03o`000?oooooooooo023ooooo000Oooooo`03o`000?oooooooooo02Co
oooo00?o0000oi^]i?nK[N@02_nK[N@00ol0003oVj[Qoi^Zh@08oi^Zh@03o`000?nKY]koVjKN00Oo
VjKN2Ol00005oiBNfP03o`000?nGVM?oUiWC00WoUiWC00?o0000oi^CbonKTl/01_nKTl/4o`0000co
XY3200?o0000ojN>_?nWS[`02_nWS[`01Ol0003oYhjkojN>^onWS[_o000000WoY7n[00?o0000oiYk
/?nJNk002_nJNk000ol0003oRg:aoh]b/@09oh]b/@03o`000?nBLjgoTW>]00[oTW>]00?o0000oin0
/OnOP;403?nOP;401?l0003oZXjiojZ>^Ol0000=okBB/`03o`000?nlX[ko_::n00Ko_::n00?o0000
ol^a`?o;/L001oo;/L000ol0003obKW;olVib`02olVib`03o`000?oFc=3oe/c@00Woe/c@00Go0000
omkRf?oNh]Sog^;Ho`000007om;IgP03o`000?oAiNGodNGU00?odNGU00?o0000om7UiOoAiND00ooA
iND2o`0000WoaN3/0_l00007okoQl003o`000?nmfNko_MW^00?o_MW^0_l00008okWIl@03o`000?oo
oooooooo00;ooooo0_l0000Qooooo`007oooool2o`0002Kooooo00?o0000oi^]i?nK[N@02OnK[N@0
0ol0003oVj[Qoi^Zh@09oi^Zh@04o`000?nKY]koVjKNoi^VgPGo00000onDXml00ol0003oU9kJoiBN
fP09oiBNfP03o`000?nGVM?oUiWC00WoUiWC00?o0000oi^CbonKTl/00_nKTl/3o`0000CoVi?;00?o
0000oj:@`_nRT<802OnRT<800ol0003oYhjlojN>_00;ojN>_0?o00002onTOj/00ol0003oVW^`oiYk
/009oiYk/003o`000?n;L[7oRg:a00[oRg:a00?o0000oi9c[OnBLjd02_nBLjd00ol0003oWh2aoin0
/@0;oin0/@03o`000?nZS[Wo000000ko]9:c00?o0000okbR__nlX[h01OnlX[h00ol0003obk70ol^a
`009ol^a`004o`000?o9^L_obKW;o`0000_oe/c@00?o0000omkRf?oNh]P00ooNh]P00ol0003od]WN
om;IgP03om;IgP03o`000?oAiNGodNGU00GodNGU00Go0000om7UiOoAiNGodNGUo`000002ol_[k003
o`000?o5h>coaN3/00CoaN3/0_l0000:okoQl003o`000?nmfNko000000;o00002onifO400ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo01oooooo000Oooooo`03o`000?oooooooooo02Kooooo
00?o0000oi^]i?nK[N@02OnK[N@00ol0003oVj[Qoi^Zh@07oi^Zh@Go00002OnDXml00ol0003oU9kJ
oiBNfP08oiBNfP03o`000?nGVM?oUiWC00WoUiWC00?o0000oi^Cbol000000_l00007oi^Cb`03o`00
0?nRT<;oXY3200WoXY3200?o0000ojN>_?nWS[`02_nWS[`2o`0000goY7n[00?o0000oiYk/?nJNk00
2_nJNk000ol0003oRg:aoh]b/@09oh]b/@03o`000?nBLjgoTW>]00[oTW>]00?o0000oin0/OnOP;40
2onOP;42o`00013o]9:c00?o0000okbR__nlX[h00onlX[h00ol0003obk70ol^a`00:ol^a`003o`00
0?o9^L_o000000_oe/c@00?o0000omkRf?oNh]P01OoNh]P01Ol0003od]WNom;Ig_oBfMko000000So
dNGU00Co0000om7UiOl0003o00001?o;jn`00ol0003oaN3/olGPk002olGPk003o`000?nohO3o_n7`
00[o_n7`0_l0000>okWIl@;o00001?ooool00ol0003oooooooooo`0Nooooo`007oooool00ol0003o
ooooooooo`0Wooooo`03o`000?nK[NCoVjgT00WoVjgT00Co0000oi^ZhOnKZ^7oVj[Q1Ol00002oiBX
h`03o`000?nDXmooU:?O00[oU:?O00?o0000oiBNf_nDW]X02?nDW]X00ol0003oUiWCoiNId`07oiNI
d`?o00002onKTl/00ol0003oXY32oj:@`P09oj:@`P03o`000?nWS[coYhjl00OoYhjl0_l000000onP
P;7o0000ojAoZ`0<ojAoZ`03o`000?nJNk3oVW^`00[oVW^`00?o0000oh]b/On;L[402On;L[400ol0
003oTW>]oi9c[@0:oi9c[@03o`000?nOP;7oWh2a00[oWh2a00?o0000ojMnY_l000004?ndT[<00ol0
003o_::nokbR_P02okbR_P03o`000?o;/L3obk7000cobk7000?o0000omK<d?oFc=002OoFc=000ol0
003og^;HomkRf007omkRf003o`000?oBfMko000000[odNGU00?o0000ol_[k?o;jn`01Oo;jn`01?l0
003oaN3/o`000?l0000;okoQl0;o000000?o^Moco`000?nifO402_nifO43o`000003okCGl_l0003o
oooo00?ooooo00?o0000ooooooooool07_ooool001oooooo00?o0000ooooooooool0:?ooool00ol0
003oVjgToi^]i007oi^]i0Go00002?nDZ><00ol0003oU:?OoiBSg`09oiBSg`03o`000?nDW][oU9kJ
00WoU9kJ00?o0000oiNIdonGVM<00onGVM<3o`0000;oUiWC00?o0000oi^CbonKTl/02OnKTl/00ol0
003oXY32oj:@`P09oj:@`P03o`000?nWS[coYhjl00GoYhjl0_l00003oj20/@03o`000?nTOj_oY7n[
00_oY7n[00?o0000oiYk/?nJNk002_nJNk000ol0003oRg:aoh]b/@09oh]b/@03o`000?nBLjgoTW>]
00[oTW>]00?o0000oin0/OnOP;402OnOP;401?l0003oYgjVojMnY_l0000AokBB/`04o`000?nlX[ko
_::no`0000oobk7000?o0000omK<d?oFc=002?oFc=000ol0003og^;HomkRf008omkRf0?o00002?oA
iND2o`000003ol_[k?l0003obn_/00Gobn_/0ol0000:okoQl0;o00001?nigo<00ol0003o^MWaokWI
l@06okWIl@;o00001Ondeo800ol0003oooooooooo`02ooooo`03o`000?oooooooooo01gooooo000O
ooooo`;o0000:_ooool01?l0003oVjgToi^]i?nK[N@5o`0000;oUZcV00?o0000oiBXhonDZ><02OnD
Z><00ol0003oU:?OoiBSg`09oiBSg`03o`000?nDW][oU9kJ00SoU9kJ00?o0000oiNIdonGVM<00ol0
0005oiNId`03o`000?nKTl_oVi?;00[oVi?;00?o0000oj:@`_nRT<802OnRT<800ol0003oYhjlojN>
_003ojN>_003o`000?nPP;7oX82a00CoX82a00?o0000ojAoZonTOj/02onTOj/00ol0003oVW^`oiYk
/009oiYk/003o`000?n;L[7oRg:a00[oRg:a00?o0000oi9c[OnBLjd02_nBLjd00ol0003oWh2aoin0
/@07oin0/@03o`000?nWOZKoYgjV00;oYgjV00?o0000okBB/ondT[<03_ndT[<00ol0003o_::no`00
000?ol^a`003o`000?oOcLKo000000Soe/c@00?o0000omkRf?oNh]P02?oNh]P01Ol0003of_?Pom[c
h?oJln3o000000KodNGU00Go0000ol_[k?o;jncobn_/o`000005ol_[k005o`000?o1jo7o`N_aol7[
lOl000001onohO02o`0000Oo^Moc00?o0000okWIlOnifO400onifO42o`0000So]=Ob00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`0Looooo`001Ol0000Iooooo`03o`000?oooooooooo02_o
oooo0ol00008oiJ/iP03o`000?nDZ>?oU:SS00SoU:SS00?o0000oiBSgonDXml02_nDXml00ol0003o
U9kJoiBNfP08oiBNfP;o00002OnGVM<00ol0003oVi?;oi^Cb`09oi^Cb`03o`000?nRT<;oXY3200Wo
XY3200Co0000ojN>_?nWS[coYhjl0_l00007oj20/@03o`000?nTOj_oY7n[00_oY7n[00?o0000oiYk
/?nJNk002_nJNk000ol0003oRg:aoh]b/@09oh]b/@03o`000?nBLjgoTW>]00[oTW>]00?o0000oin0
/OnOP;401_nOP;400ol0003oYgjVojMnYP03ojMnYP03o`000?ndT[?o]9:c00oo]9:c00?o0000ol^a
`?o;/L003Oo;/L001Ol0003oglg6omo=a_oOcLKo000000Koe/c@00?o0000omkRf?oNh]P02?oNh]P0
0ol0003of_?Pom[ch003om[ch004o`000?oAiNGodNGUom7Ui@;o00001Oo;jn`00ol0003obn_/ol_[
k002o`0000Go`N_a00?o0000okoQl?nohO000_nohO02o`0000[o^Moc00?o0000okWIlOl000000_l0
000;okCGlP04o`000?ooooooooooooooo`;o00007Oooool00005ooooool0003oooooooooool00000
1?ooool3o`0000Cooooo00?o0000ooooooooool00_ooool3o`0000Kooooo00?o0000ooooooooool0
:oooool00ol0003oUZcVoiJ/iP09oiJ/iP03o`000?nDZ>?oU:SS00SoU:SS00?o0000oiBSgonDXml0
2OnDXml00ol0003oU9kJoiBNfP05oiBNfPCo00002_nGVM<00ol0003oVi?;oi^Cb`09oi^Cb`03o`00
0?nRT<;oXY3200WoXY3200Co0000ojN>_?l0003o00002OnPP;400ol0003oY7n[ojAoZ`0;ojAoZ`03
o`000?nJNk3oVW^`00[oVW^`00?o0000oh]b/On;L[402On;L[400ol0003oTW>]oi9c[@0:oi9c[@03
o`000?nOP;7oWh2a00GoWh2a00?o0000ojMnY_nWOZH01?nWOZH00ol0003o]9:cokBB/`0?okBB/`03
o`000?o;/L3obk7000cobk7000?o0000omo=a_oOcLH00ooOcLH00ol0003oe/c@omK<d002omK<d003
o`000?oNh]Sog^;H00Sog^;H00?o0000om[ch?oJln001OoJln000ol0003odNGUo`000008ol_[k0;o
00002?o1jo401?l0003o_n7`o`000?l0000<okWOl`;o00003_ndeo82o`0000;ooooo0_l0000Moooo
o`000_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Oooooo00Go0000oooooooo
ooooooooo`000005ooooo`03o`000?oooooooooo02cooooo00?o0000oiJ/i_nF[>H02OnF[>H00ol0
003oU:SSoiBXh`08oiBXh`03o`000?nDXmooU:?O00WoU:?O00Co0000oiBNf_nDW][oU9kJ0ol00004
oiBNfP03o`000?nGVM?oUiWC00SoUiWC00?o0000oi^CbonKTl/02OnKTl/00ol0003oXY32oj:@`P06
oj:@`PCo00002onPP;400ol0003oY7n[ojAoZ`0<ojAoZ`03o`000?nJNk3oVW^`00WoVW^`00?o0000
oh]b/On;L[402On;L[400ol0003oTW>]oi9c[@0:oi9c[@03o`000?nOP;7oWh2a00CoWh2a00?o0000
ojMnY_nWOZH01_nWOZH00ol0003o]9:cokBB/`0=okBB/`03o`000?o8Xk;o000000gobk7000?o0000
omo=a_oOcLH00ooOcLH01Ol0003oe/c@omK<d?oFc=3o000000[og^;H00?o0000om[ch?oJln001_oJ
ln03o`0000Oobn_/00?o0000ol7[lOl000002?o1jo43o`0000_o^Moc0_l00002okCLm003o`000?nd
eo;o]=Ob00Wo]=Ob0_l00002ok7DlP05o`000?ooooooooooooooool000007?ooool00004o`000?oo
ooooooooo`0000Kooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo02gooooo00?o0000oiJ/i_nF[>H02OnF[>H00ol0003oU:SSoiBXh`08oiBXh`03o`00
0?nDXmooU:?O00SoU:?O1?l00008oiBNfP03o`000?nGVM?oUiWC00OoUiWC00?o0000oi^CbonKTl/0
2OnKTl/01?l0003oXY32oj:@`_nRT<85o`0000?oUh>l00?o0000oj20/OnPP;402_nPP;400ol0003o
Y7n[ojAoZ`0;ojAoZ`03o`000?nJNk3oVW^`00WoVW^`00?o0000oh]b/On;L[402On;L[400ol0003o
TW>]oi9c[@0;oi9c[@03o`000?nOP;7oWh2a00;oWh2a00?o0000ojMnY_nWOZH01onWOZH00ol0003o
]9:cokBB/`0<okBB/`04o`000?o8Xk;ob:>bo`0000cobk7000?o0000omo=a_oOcLH01OoOcLH00ol0
003oe/c@o`00000:omkRf003o`000?oJln3of_?P00Kof_?P00Co0000olgiioo=nNOocOWW0_l00003
ol_[k0;o00000_o1jo400ol0003o`N_aol7[l@04ol7[l@;o00000onhioD00ol0003o^MocokWOl`05
okWOl`?o00001Ondg?@00ol0003o]=ObokCGlP05okCGlP?o00001Onae?801?l0003oooooooooool0
000Looooo`001Ol00005ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool00_ooool3
o`0002oooooo00?o0000oiJ/i_nF[>H02?nF[>H00ol0003oU:SSoiBXh`08oiBXh`03o`000?nDXmoo
U:?O00KoU:?O1?l0000:oiBNfP03o`000?nGVM?oUiWC00OoUiWC00?o0000oi^CbonKTl/01?nKTl/9
o`0000SoUh>l00?o0000oj20/OnPP;402_nPP;400ol0003oY7n[ojAoZ`0;ojAoZ`03o`000?nJNk3o
VW^`00[oVW^`00?o0000oh]b/On;L[402On;L[400ol0003oTW>]oi9c[@0:oi9c[@05o`000?nOP;7o
Wh2aoin0/Ol000002_nWOZH00ol0003o]9:cokBB/`0<okBB/`05o`000?o8Xk;ob:>bolRS/_l00000
2_o;/L000ol0003oglg6omo=aP07omo=aP;o00002OoNh]P00ol0003of_?Pom[ch006om[ch003o`00
0?o=nNOocOWW00CocOWW00?o0000ol_[k?l000001Oo1jo401?l0003o`N_aol7[lOo1jo42o`0000Ko
^>Oe00?o0000okWOlonigo<00_nigo<2o`0000Wo]=cd00?o0000okCGl_ndeo800_ndeo82o`0000Wo
/MCb00Co0000oooooooooooo00006oooool000[ooooo00?o0000ooooooooool01oooool4o`0000Ko
oooo00?o0000ooooooooool0;oooool00ol0003oUZcVoiJ/iP08oiJ/iP03o`000?nDZ>?oU:SS00So
U:SS00?o0000oiBSgonDXml00_nDXmlRo`0000KoSHS:00?o0000oiN3_?nGPk`02OnGPk`00ol0003o
X82aoj20/@09oj20/@03o`000?nTOj_oY7n[00_oY7n[00?o0000oiYk/?nJNk002_nJNk000ol0003o
Rg:aoh]b/@09oh]b/@03o`000?nBLjgoTW>]00[oTW>]00Co0000oin0/OnOP;7o00003?nWOZH00ol0
003o]9:cokBB/`0:okBB/`03o`000?o8Xk;ob:>b00;ob:>b00?o0000ol^a`?o;/L001oo;/L000ol0
003oglg6omo=aP08omo=aP03o`000?o/k/_o000000Oog^;H00?o0000om[ch?oJln001OoJln02o`00
00OocOWW0ol00006ol7[l@?o00002OnhioD01?l0003o^Moco`000?l0000<okCLm004o`000?ndeo;o
0000o`0000co/MCb00Co0000oooooooooooo00006_ooool000Wooooo0_l00009ooooo`03o`000?oo
oooooooo00Kooooo00?o0000ooooooooool0<Oooool00ol0003oUZcVoiJ/iP08oiJ/iP03o`000?nD
Z>?oU:SS00?oU:SS2ol00005ohVPh`03o`000?n7VMgoQiWM00SoQiWM00?o0000ohN@eOn7T=D01on7
T=D00ol0003oSHS:ohf8bP09ohf8bP03o`000?nGPkcoUh>l00WoUh>l00?o0000oj20/OnPP;402OnP
P;400ol0003oY7n[ojAoZ`0<ojAoZ`03o`000?nJNk3oVW^`00WoVW^`00?o0000oh]b/On;L[402On;
L[400ol0003oTW>]oi9c[@0;oi9c[@;o00003OnWOZH00ol0003o]9:cokBB/`09okBB/`03o`000?o8
Xk;ob:>b00Cob:>b00?o0000ol^a`?o;/L001_o;/L000ol0003oglg6omo=aP07omo=aP05o`000?o/
k/_ok>k;onc^bol000001OoNh]P00ol0003of_?Pom[ch005om[ch003o`000?o=nNOocOWW00GocOWW
0_l00003okkfk`03o`000?o1jo7o`N_a00;o`N_a0ol0000:okSWm@;o00003_ndg?@2o`0000ko/MCb
0_l000000ooooooo0000o`00000Iooooo`002_ooool00ol0003oooooooooo`07ooooo`Go00001?oo
ool00ol0003oooooooooo`0booooo`03o`000?nF[>KoUZcV00?oUZcV2_l00003ohbVi`?o00002on9
X><00ol0003oQiWMohNIg@08ohNIg@03o`000?n7T=GoQi3E00OoQi3E00?o0000ohf8b_n=R<X02On=
R<X00ol0003oUh>loiN3_008oiN3_003o`000?nPP;7oX82a00[oX82a00?o0000ojAoZonTOj/02onT
Oj/00ol0003oVW^`oiYk/009oiYk/003o`000?n;L[7oRg:a00WoRg:a00?o0000oi9c[OnBLjd02_nB
Ljd2o`0000koYgjV00?o0000okBB/ondT[<02OndT[<00ol0003ob:>bolRS/P04olRS/P03o`000?o;
/L3obk7000Gobk7000?o0000omo=a_oOcLH01ooOcLH00ol0003ok>k;onc^b`03onc^b`05o`000?oN
h]Sog^;HomkRf?l000001ooJln000ol0003ocOWWolgii`05olgii`03o`000?nnm^oo__K_00Co__K_
00Co0000ol7[lOl0003o00000_nhioD00ol0003o^>OeokSWm@05okSWm@?o00000_nahOL00ol0003o
]=cdokCLm008okCLm0?o00000_n`f?D00ol0003o/MCbok7DlP08ok7DlP?o000000?o[]7bo`000?oo
ool00_l00008ooooo`Go00003?ooool001gooooo0_l0000dooooo`Go00001On@ZnT00ol0003oS:KW
ohbVi`03ohbVi`;o00000on<Y^L00ol0003oRJ3SohVPh`09ohVPh`03o`000?n7VMgoQiWM00OoQiWM
00?o0000ohN@eOn7T=D01on7T=D00ol0003oSHS:ohf8bP09ohf8bP03o`000?nGPkcoUh>l00SoUh>l
00?o0000oj20/OnPP;402_nPP;400ol0003oY7n[ojAoZ`0;ojAoZ`03o`000?nJNk3oVW^`00WoVW^`
00?o0000oh]b/On;L[402_n;L[400ol0003oTW>]oi9c[@07oi9c[@;o000000?oVgBVo`000?nWOZH0
3_nWOZH00ol0003o]9:cokBB/`07okBB/`03o`000?o8Xk;ob:>b00Gob:>b00?o0000ol^a`?o;/L00
1?o;/L000ol0003oglg6omo=aP08omo=aP03o`000?o/k/_ok>k;00Cok>k;00?o0000omkRf?l00000
1_oJln02o`0000KocOWW0_l00007okkfk`?o00001?nhioD00ol0003o^>OeokSWm@02okSWm@;o0000
1_nahOL00ol0003o]=cdokCLm004okCLm0?o00001_n`f?D00ol0003o/MCbok7DlP04ok7DlP?o0000
1On^dO800ol0003oooooo`000009ooooo`04o`000?ooooooooooo`0000cooooo000Mooooo`03o`00
0?oooooooooo03?ooooo00?o0000oi2[jOn@ZnT02?n@ZnT00ol0003oS:KWo`000002o`0000KoS:KW
00?o0000ohVPhon9X><02?n9X><00ol0003oQiWMohNIg@08ohNIg@03o`000?n7T=GoQi3E00OoQi3E
00?o0000ohf8b_n=R<X02?n=R<X00ol0003oUh>loiN3_009oiN3_003o`000?nPP;7oX82a00WoX82a
00?o0000ojAoZonTOj/02onTOj/00ol0003oVW^`oiYk/00:oiYk/003o`000?n;L[7oRg:a00WoRg:a
00?o0000oi9c[OnBLjd01OnBLjd2o`0000?oVgBV00?o0000ojMnY_nWOZH03OnWOZH00ol0003o]9:c
okBB/`06okBB/`03o`000?o8Xk;ob:>b00Oob:>b00?o0000ol^a`?o;/L000_o;/L000ol0003oglg6
omo=aP08omo=aP03o`000?o/k/_ok>k;00Kok>k;0_l00005om[ch003o`000?o=nNOocOWW00CocOWW
0_l00007okkfk`;o00000onbkoH2o`0000?o^>Oe00Co0000okSWmOl0003o00002OnahOL00ol0003o
]=cdokCLm003o`0000[o/=Se00?o0000ok7Dl_nae?800ol00009ojkAlP03o`000?oooooo000000Wo
oooo00?o0000ooooooooool03?ooool001gooooo00?o0000ooooooooool0=?ooool00ol0003oT:_Y
oi2[j@06oi2[j@?o00002_n<Y^L00ol0003oRJ3SohVPh`08ohVPh`03o`000?n7VMgoQiWM00OoQiWM
00?o0000ohN@eOn7T=D01on7T=D00ol0003oSHS:ohf8bP09ohf8bP03o`000?nGPkcoUh>l00SoUh>l
00?o0000oj20/OnPP;402OnPP;400ol0003oY7n[ojAoZ`0<ojAoZ`03o`000?nJNk3oVW^`00SoVW^`
1?l00009oh]b/@03o`000?nBLjgoTW>]00?oTW>]0_l00006oi]dYP03o`000?nWOZKoYgjV00coYgjV
00?o0000okBB/ondT[<01_ndT[<00ol0003ob:>bolRS/P07olRS/P03o`000?o;/L3obk7000;obk70
00?o0000omo=a_oOcLH01ooOcLH00ol0003ok>k;onc^b`07onc^b`03o`000?oKolSo000000;o0000
00?of_?Po`000?o=nNL01Oo=nNL00ol0003o__K_okkfk`05okkfk`;o00001onbkoH00ol0003o^>Oe
o`000002o`0000_o/N7g0ol0000=ok3Hm@?o00003On^dO800ol0003oooooo`000009ooooo`03o`00
0?oooooooooo00_ooooo000Mooooo`03o`000?oooooooooo03Gooooo00?o0000oi2[jOn@ZnT00_n@
ZnT3o`0000?oT:_Y00?o0000ohbVion<Y^L02?n<Y^L00ol0003oRJ3SohVPh`08ohVPh`03o`000?n7
VMgoQiWM00OoQiWM00?o0000ohN@eOn7T=D01on7T=D00ol0003oSHS:ohf8bP08ohf8bP03o`000?nG
PkcoUh>l00SoUh>l00?o0000oj20/OnPP;402_nPP;400ol0003oY7n[ojAoZ`0;ojAoZ`03o`000?nJ
Nk3oVW^`00GoVW^`0ol000001?nDK:;o0000oh=PXOn3H:45o`0000CoRg:a00Co0000oi9c[OnBLjgo
TW>]0_l00008oi]dYP03o`000?nWOZKoYgjV00goYgjV00?o0000okBB/ondT[<01?ndT[<00ol0003o
b:>bolRS/P09olRS/P04o`000?o;/L3obk70o`0000[oglg600?o0000onc^boo/k//01_o/k//00ol0
003ofoo8om_ob002om_ob0Go00000_o=nNL2o`0000Oo__K_00?o0000ok;_m_nbkoH01onbkoH3o`00
0003ok7Qmol0003o/N7g00So/N7g0_l00002ojgKm`03o`000?n`f?Go/=Se00So/=Se0ol000000on]
e?Co0000ojkAlP0=ojkAlP?o00001_ooool01Ol0003ooooooooooooooooo000000cooooo000Moooo
o`03o`000?oooooooooo03Kooooo1?l00007oi2[j@03o`000?n<Y^OoS:KW00OoS:KW00?o0000ohVP
hon9X><02?n9X><00ol0003oQiWMohNIg@07ohNIg@03o`000?n7T=GoQi3E00OoQi3E00?o0000ohf8
b_n=R<X02?n=R<X00ol0003oUh>loiN3_008oiN3_003o`000?nPP;7oX82a00[oX82a00?o0000ojAo
ZonTOj/02onTOj/00ol0003oVW^`oiYk/002oiYk/0?o00001?nDK:800ol0003oPf2Qoh=PX@05oh=P
X@Co000000CoRg:ao`000?l0003o00002_nKM:H00ol0003oYgjVojMnYP0=ojMnYP03o`000?ndT[?o
]9:c00?o]9:c00?o0000olRS/_o8Xk802_o8Xk800ol0003obk70o`00000:omo=aP03o`000?o/k/_o
k>k;00Kok>k;00?o0000om_ob?oKolP00_oKolP00ol0003o^oc;ok_lb`03ok_lb`?o00001_nnm^l2
o`0000Oo/^of0ol00003ojcVnP03o`000?nahOOo000000Go/N7g0ol00005ojgKm`03o`000?n`f?Go
/=Se00Co/=Se0ol00005ojgDm003o`000?n^dO;o[]7b00So[]7b0ol000001?n/co;o0000ooooool0
0005ooooo`05o`000?ooooooooooooooool000003?ooool001cooooo00?o0000ooooooooool0=Ooo
ool4o`0000[oT:_Y00?o0000ohbVion<Y^L01on<Y^L00ol0003oRJ3SohVPh`08ohVPh`03o`000?n7
VMgoQiWM00OoQiWM00?o0000ohN@eOn7T=D01on7T=D00ol0003oSHS:ohf8bP08ohf8bP03o`000?nG
PkcoUh>l00SoUh>l00?o0000oj20/OnPP;402OnPP;400ol0003oY7n[ojAoZ`0<ojAoZ`Co00001onD
K:800ol0003oPf2Qoh=PX@09oh=PX@;o00003?nKM:H00ol0003oYgjVojMnYP0=ojMnYP03o`000?nd
T[?o]9:c00?o]9:c00?o0000olRS/_o8Xk802oo8Xk800ol0003oglg6omo=aP08omo=aP03o`000?o/
k/_ok>k;00Kok>k;00?o0000om_ob?oKolP00_oKolP00ol0003o^oc;ok_lb`03ok_lb`04o`000?nX
n=koZ?SNojShgP?o000000?o__K_o`000?l000001onbkoH2o`0000Oo[>Kj00?o0000ok7Qmol00000
0_nahOL2o`0000Wo[M_g00?o0000ok3HmOn`f?D00ol00009ojgDm003o`000?n^dO;o[]7b00Co[]7b
0ol00005ojc?lP?o00001Oooool3o`0000gooooo000Looooo`03o`000?oooooooooo03;ooooo0ol0
0004ooooo`03o`000?n@ZnWoT:_Y00SoT:_Y00?o0000ohbVion<Y^L01on<Y^L00ol0003oRJ3SohVP
h`07ohVPh`03o`000?n7VMgoQiWM00OoQiWM00?o0000ohN@eOn7T=D01on7T=D00ol0003oSHS:ohf8
bP08ohf8bP03o`000?nGPkcoUh>l00SoUh>l00?o0000oj20/OnPP;402OnPP;400ol0003oY7n[ojAo
Z`0;ojAoZ`;o00002onDK:800ol0003oPf2Qoh=PX@09oh=PX@03o`000?nKM:KoVgBV00[oVgBV00?o
0000ojMnY_nWOZH03_nWOZH01Ol0003o]9:cokBB/ondT[?o000000kob:>b00?o0000omo=a_oOcLH0
1ooOcLH00ol0003ok>k;onc^b`06onc^b`03o`000?oKolSofoo800;ofoo800?o0000ok_lbonko</0
0_nko</2o`0000KoZ?SN0ol00006ok;_mP;o00002_n/i_X4o`0000_o[M_g0ol0000=ojgDm003o`00
0?n^dO;o[]7b00?o00002On/co82o`0001Gooooo000Looooo`03o`000?oooooooooo02oooooo0ol0
0008ooooo`03o`000?n@ZnWoT:_Y00?oT:_Y5_l00003ohVPh`03o`000?n7VMgoQiWM00OoQiWM00?o
0000ohN@eOn7T=D01_n7T=D00ol0003oSHS:ohf8bP08ohf8bP03o`000?nGPkcoUh>l00SoUh>l00?o
0000oj20/OnPP;402OnPP;400ol0003oY7n[ojAoZ`0:ojAoZ`03o`000?nVO:Go000000_oU6bR00?o
0000oh=PXOn3H:402On3H:400ol0003oVgBVoi]dYP0;oi]dYP03o`000?nWOZKoYgjV00goYgjV00Co
0000okBB/ondT[?o00003_o8Xk800ol0003oj/^fo`000008omo=aP03o`000?o/k/_ok>k;00Gok>k;
00?o0000om_ob?oKolP00_oKolP00ol0003o^oc;ok_lb`02ok_lb`03o`000?nXn=koZ?SN00?oZ?SN
0ol00003oj7blP;o000000Co/^ofo`000?l0003o00003?n/i_X3o`0000Wo[M_g0ol00002oj[Fm`03
o`000?n]e?Co[MCd00_o[MCd0ol0000=ojc?lP03o`000?oooooooooo01?ooooo000Looooo`03o`00
0?oooooooooo02cooooo0ol0000<ooooo`Go00001On8Zn`00ol0003oPJG[oh6Uj`07oh6Uj`03o`00
0?miWNSoNIgX00CoNIgX2_l00003ohNIg@03o`000?n7T=GoQi3E00OoQi3E00?o0000ohf8b_n=R<X0
1on=R<X00ol0003oUh>loiN3_008oiN3_003o`000?nPP;7oX82a00[oX82a00?o0000ojAoZonTOj/0
2?nTOj/01?l0003oYWbUojIlYOl0000;oiA/XP03o`000?n3H:7oPf2Q00WoPf2Q00?o0000oi]dY_nK
M:H02onKM:H00ol0003oYgjVojMnYP0=ojMnYP04o`000?ndT[?o]9:co`0000kob:>b00Co0000on[;
]_oZbkKo00001_oOcLH00ol0003ok>k;onc^b`05onc^b`04o`000?oKolSofoo8om_ob0;o00000onk
o</2o`0000CoZ?SN0_l00007oj7blP?o00002on/i_X3o`0000?oZ=kj00?o0000ojgKmon]foL00on]
foL3o`0000KoZ]Kg00?o0000ojgDm?n]e?@01on]e?@3o`000003oj_@m?l0003o[<ob00go[<ob0_l0
000Dooooo`006oooool3o`0002_ooooo0_l0000?ooooo`03o`000?n8ZncoR:_/00SoR:_/00?o0000
oh6Ujon1YN/01on1YN/00ol0003oNIgXogVMj007ogVMj003o`000?m_TN?oKi7S00?oKi7S1ol00006
ohN@e@03o`000?n=R<[oSHS:00SoSHS:00?o0000oiN3_?nGPk`01onGPk`00ol0003oX82aoj20/@0:
oj20/@03o`000?nTOj_oY7n[00OoY7n[00Go0000ojIlYOnVO:GoYWbUo`00000;oiA/XP03o`000?n3
H:7oPf2Q00[oPf2Q00?o0000oi]dY_nKM:H02_nKM:H00ol0003oYgjVojMnYP0>ojMnYP;o00003_o8
Xk800ol0003oj/^fon[;]P02on[;]P03o`000?oOcLKoglg600;oglg600?o0000onc^boo/k//01Oo/
k//01Ol0003ofoo8om_ob?oKolSo000000Co^oc;00?o0000ojShg_nXn=h00_nXn=h2o`0000KoXO;b
0ol00003oj3Yn`;o00001_n/i_X3o`0000KoZ=kj0_l000001?n]foOo0000o`000?l0000:oj[Fm`03
o`000?n]e?Co[MCd00?o[MCd0ol00005oj_@m003o`000?n/co;o[<ob00So[<ob1?l0000Eooooo`00
7?ooool00ol0003oooooooooo`0Wooooo`?o00004_ooool00ol0003oR:_/ohR[k008ohR[k003o`00
0?n1YN_oPJG[00OoPJG[00?o0000ogVMj?miWNP01omiWNP00ol0003oKi7SofnAh`06ofnAh`03o`00
0?mXPm[oJ8?J00Co00000on7T=D00ol0003oSHS:ohf8bP07ohf8bP03o`000?nGPkcoUh>l00SoUh>l
00?o0000oj20/OnPP;402OnPP;400ol0003oY7n[ojAoZ`06ojAoZ`03o`000?nVO:GoYWbU00?oYWbU
00?o0000oiA/X_nDK:802?nDK:800ol0003oPf2Qoh=PX@0:oh=PX@03o`000?nKM:KoVgBV00[oVgBV
00?o0000ojMnY_nWOZH03_nWOZH00ol0003ob:>bolRS/P0=olRS/P03o`000?oZbkKoj/^f00?oj/^f
00Go0000omo=a_oOcLKoglg6o`000006onc^b`05o`000?oKolSofoo8om_ob?l000000onko</2o`00
00;oZ?SN0ol00005oj7blP?o00002?nPjO/00ol0003o[>KjojcVnP03o`0000[oZ=kj0_l0000>oj[F
m`03o`000?n]e?Co000000;o00002On[d?@00ol0003o[<obojc?lP04ojc?lP?o00001?ooool00ol0
003oooooooooo`0Booooo`006oooool00ol0003oooooooooo`0Uooooo`?o00005_ooool00ol0003o
R:_/ohR[k008ohR[k003o`000?n1YN_oPJG[00OoPJG[00?o0000ogVMj?miWNP01omiWNP00ol0003o
Ki7SofnAh`06ofnAh`03o`000?mXPm[oJ8?J00?oJ8?J1?l00009ohf8bP03o`000?nGPkcoUh>l00So
Uh>l00?o0000oj20/OnPP;402OnPP;400ol0003oY7n[ojAoZ`05ojAoZ`03o`000?nVO:GoYWbU00Co
YWbU00?o0000oiA/X_nDK:802?nDK:800ol0003oPf2Qoh=PX@0:oh=PX@03o`000?nKM:KoVgBV00[o
VgBV00?o0000ojMnY_nWOZH03_nWOZH00ol0003ob:>bolRS/P0<olRS/P03o`000?oZbkKoj/^f00Go
j/^f00?o0000omo=a_l000001_o/k//01Ol0003ofoo8om_ob?oKolSo000000?o^oc;00?o0000ojSh
g_l000001Ol00002oj7blP?o00002_nPjO/4o`0000[oZ=kj0ol000000onVeoWo0000oj[Fm`0=oj[F
m`;o00003On[d?@00ol0003o[<obojc?lP03o`0000Oooooo00?o0000ooooooooool04_ooool001_o
oooo00?o0000ooooooooool08_ooool3o`0001[ooooo00?o0000ohR[k?n8Zn`02?n8Zn`00ol0003o
PJG[oh6Uj`07oh6Uj`03o`000?miWNSoNIgX00KoNIgX00?o0000ofnAhom_TN<01_m_TN<00ol0003o
J8?JofR3fP06ofR3fP?o00002?n=R<X00ol0003oUh>loiN3_007oiN3_003o`000?nPP;7oX82a00[o
X82a00?o0000ojAoZonTOj/00onTOj/00ol0003oYWbUojIlY@05ojIlY@03o`000?nDK:;oU6bR00Wo
U6bR00?o0000oh=PXOn3H:402On3H:400ol0003oVgBVoi]dYP0;oi]dYP03o`000?nWOZKoYgjV00co
YgjV00?o0000on2l/ol000003Oo8Xk800ol0003oj/^fon[;]P06on[;]P;o00001Oo/k//01_l0003o
foo8om_ob?oKolSo0000ok_lb`Ko00001Ommi^83o`0000SoX>Wk1?l00004oj7Oo0;o00001OnXg_X3
o`0000GoY]Oi00?o0000oj[FmonZe_L02?nZe_L3o`0000;oZ=7e00?o0000oj_@m?n[d?@02On[d?@4
o`0000[ooooo00?o0000ooooooooool04_ooool001_ooooo0ol0000Oooooo`?o00007_ooool00ol0
003oR:_/ohR[k008ohR[k003o`000?n1YN_oPJG[00KoPJG[00?o0000ogVMj?miWNP01omiWNP00ol0
003oKi7SofnAh`06ofnAh`03o`000?mXPm[oJ8?J00KoJ8?J00?o0000ofUfcOl000000_l00005ohf8
bP03o`000?nGPkcoUh>l00OoUh>l00?o0000oj20/OnPP;402_nPP;400ol0003oY7n[ojAoZ`02ojAo
Z`03o`000?nVO:GoYWbU00KoYWbU00?o0000oiA/X_nDK:802OnDK:800ol0003oPf2Qoh=PX@09oh=P
X@03o`000?nKM:KoVgBV00_oVgBV00?o0000ojMnY_nWOZH03?nWOZH00ol0003oh;bco`00000<olRS
/P03o`000?oZbkKoj/^f00Ooj/^f00?o0000oo3cX?l000000_l000000oo/k/_o0000om_ob009o`00
00CoONKR0ol00003ohkVnP?o00000_nPjO/3o`0000[oXMol00?o0000ojSNn_l000000_l00008ojKG
n@;o00001_nZe_L3o`0000KoZ=7e00?o0000oj_@m?n[d?@01?n[d?@4o`0000kooooo00?o0000oooo
ooooool04_ooool001_ooooo00?o0000ooooooooool07?ooool3o`0002;ooooo00?o0000ohR[k?n8
Zn`02?n8Zn`00ol0003oPJG[oh6Uj`06oh6Uj`03o`000?miWNSoNIgX00OoNIgX00?o0000ofnAhom_
TN<01_m_TN<00ol0003oJ8?JofR3fP06ofR3fP04o`000?mYM/goJGK=ofUfc@?o00000_n=R<X00ol0
003oUh>loiN3_008oiN3_003o`000?nPP;7oX82a00WoX82a00Go0000ojAoZonTOj_oY7n[o`000009
ojIlY@03o`000?nDK:;oU6bR00WoU6bR00?o0000oh=PXOn3H:402On3H:400ol0003oVgBVoi]dYP0;
oi]dYP03o`000?nWOZKoYgjV00_oYgjV00Co0000on2l/ooP_;?o00003?o8Xk800ol0003oj/^fon[;
]P06on[;]P03o`000?o`lj3ol?>P00?ol?>P0ol000000onOdfco0000o`000003o`0000CoONKR0ol0
0008ohkVnP?o00003?nQgo`3o`0000coY]Oi0_l00002oj[Fm`?o00002_nXdOD00ol0003oZm3doj_@
m003o`0001;ooooo00?o0000ooooooooool04_ooool0013ooooo1Ol00006ooooo`03o`000?oooooo
oooo01Wooooo0ol0000Vooooo`03o`000?n8ZncoR:_/00?oR:_/2ol00003oh6Uj`03o`000?miWNSo
NIgX00OoNIgX00?o0000ofnAhom_TN<01Om_TN<00ol0003oJ8?JofR3fP06ofR3fP03o`000?mYM/go
JGK=00CoJGK=1?l00009oiN3_003o`000?nPP;7oX82a00WoX82a00Co0000ojAoZonTOj_o00002_nV
O:D00ol0003oU6bRoiA/XP09oiA/XP03o`000?n3H:7oPf2Q00[oPf2Q00?o0000oi]dY_nKM:H02_nK
M:H00ol0003oYgjVojMnYP0;ojMnYP05o`000?oP_;?oh;bcon2l/ol000002_o8Xk800ol0003oj/^f
on[;]P07on[;]P03o`000?o`lj3ol?>P00?ol?>P00?o0000oioCK?nOdf`01?l00003oggVhP?o0000
2?n>i_X3o`0000?oUmgn00?o0000oj7Oo?nQgo`01OnQgo`4o`0000?oXMOj00?o0000ojKGnOnVeoT0
2OnVeoT4o`0000goZ=7e0ol0000Eooooo`03o`000?oooooooooo01;ooooo000Aooooo`04o`000?oo
ooooooooo`0000Kooooo00?o0000ooooooooool05_ooool3o`0002[ooooo1Ol00005oh6/l003o`00
0?mdYO3oM:G`00?oM:G`2?l00005ogVMj003o`000?m_TN?oKi7S00KoKi7S00?o0000ofR3f_mXPmX0
1_mXPmX00ol0003oJGK=ofUfc@06ofUfc@?o00001onGPk`00ol0003oX82aoj20/@0:oj20/@;o0000
2onVO:D00ol0003oU6bRoiA/XP09oiA/XP03o`000?n3H:7oPf2Q00[oPf2Q00?o0000oi]dY_nKM:H0
2_nKM:H00ol0003oYgjVojMnYP0:ojMnYP03o`000?oP_;?oh;bc00;oh;bc00?o0000olRS/_o8Xk80
2?o8Xk800ol0003oj/^fon[;]P06on[;]P03o`000?o`lj3ol?>P00?ol?>P00?o0000oioCK?nOdf`0
2Ol00007ohkVnP?o00001onGgOh00ol0003oXMoloj7Oo004o`0000SoXMOj00?o0000ojKGnOnVeoT0
1?nVeoT4o`0000;oY]7g00?o0000ojKAmol000002OnXdOD3o`0001Sooooo00?o0000ooooooooool0
4_ooool001;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Eooooo`;o0000;_oo
ool00ol0003oPJc`oh6/l007oh6/l003o`000?mdYO3oM:G`00KoM:G`00Co0000of:Ik_mRVNkoHYW^
1Ol000000omiWNSo0000ofnAh`06ofnAh`03o`000?mXPm[oJ8?J00KoJ8?J00?o0000ofUfcOmYM/d0
1_mYM/d00ol0003oNFjjogU^^P04o`0000?oUh>l00?o0000oj20/OnPP;401onPP;44o`0000goYWbU
00?o0000oiA/X_nDK:802?nDK:800ol0003oPf2Qoh=PX@0:oh=PX@03o`000?nKM:KoVgBV00_oVgBV
00?o0000ojMnY_nWOZH02OnWOZH00ol0003oh;bcon2l/`02on2l/`03o`000?o8Xk;ob:>b00Oob:>b
00?o0000on[;]_oZbkH01ooZbkH00ol0003ol?>Poo3cX002oo3cX003o`000?nOdfcoWm=/00Ko0000
1?mjgOT2o`0000;oS^Kj0ol00009oiOMoPCo00003OnQeoX00ol0003oY]OiojKGn@03o`0000KoY]7g
00Co0000ojKAmonVdOOo00001OnXdOD3o`0001cooooo00?o0000ooooooooool04Oooool001?ooooo
00?o0000ooooooooool01?ooool2o`0001?ooooo0ol0000aooooo`03o`000?n1[?3oPJc`00OoPJc`
00?o0000ogBUl?mdYO001_mdYO000ol0003oHYW^of:IkP05of:IkPGo00001Om_TN<00ol0003oJ8?J
ofR3fP06ofR3fP03o`000?mYM/goJGK=00GoJGK=00?o0000ogU^^_miK[X01?miK[X3o`000004oiN3
_?l0003oX82aoj20/@Ko00000onAKjP00ol0003oYWbUojIlY@0;ojIlY@03o`000?nDK:;oU6bR00Wo
U6bR00?o0000oh=PXOn3H:402On3H:400ol0003oVgBVoi]dYP0;oi]dYP03o`000?nWOZKoYgjV00So
YgjV00?o0000on2l/ooP_;<01?oP_;<00ol0003ob:>bolRS/P05olRS/P03o`000?oZbkKoj/^f00Oo
j/^f00?o0000oo3cX?o`lj000oo`lj000ol0003oWm=/o`000002o`0000OoN]gi1Ol00008oiOMoPCo
00001?nLeO`00ol0003oXMOjoj7GnP09oj7GnPCo00002_nVdOL01Ol0003oY]7gojKAmol0003oZ=7e
00?o00007oooool00ol0003oooooooooo`0Aooooo`004?ooool01Ol0003ooooooooooooooooo0000
00Gooooo00?o0000ooooooooool03oooool3o`0003Gooooo00?o0000oh6/l?n1[?001on1[?000ol0
003oM:G`ogBUl006ogBUl003o`000?mRVNkoHYW^00KoHYW^00?o0000odJ6j?m6Q^P00ol00003ofnA
h`03o`000?mXPm[oJ8?J00GoJ8?J00?o0000ofUfcOmYM/d01_mYM/d00ol0003oNFjjogU^^P06ogU^
^PCo00002OnAKjP00ol0003oYWbUojIlY@0;ojIlY@03o`000?nDK:;oU6bR00WoU6bR00?o0000oh=P
XOn3H:402On3H:400ol0003oVgBVoi]dYP0;oi]dYP03o`000?nWOZKoYgjV00SoYgjV00?o0000on2l
/ooP_;<01?oP_;<00ol0003ob:>bolRS/P05olRS/P03o`000?oZbkKoj/^f00Ooj/^f00?o0000oo3c
X?o`lj000_o`lj001?l0003oWm=/o`000?l00004og[Mn@Go00001On?fOl3o`0000;oUmgn0ol00009
oicEo003o`000?nQeo[oXMOj00CoXMOj1?l00004oj;An003o`000?nVdOOoY]7g00SoY]7g1?l0000R
ooooo`03o`000?oooooooooo017ooooo000@ooooo`05o`000?ooooooooooooooool000001Oooool0
0ol0003oooooooooo`0<ooooo`?o0000>Oooool00ol0003oPJc`oh6/l007oh6/l003o`000?mdYO3o
M:G`00KoM:G`00?o0000of:Ik_mRVNh01_mRVNh00ol0003oAXKXodJ6j002odJ6j0Co00002?mXPmX0
0ol0003oJGK=ofUfc@05ofUfc@03o`000?miK[[oNFjj00OoNFjj00?o0000oi5_Z?nAKjP02OnAKjP0
0ol0003oYWbUojIlY@0;ojIlY@03o`000?nDK:;oU6bR00WoU6bR00?o0000oh=PXOn3H:402On3H:40
0ol0003oVgBVoi]dYP0;oi]dYP03o`000?nWOZKoYgjV00OoYgjV00?o0000on2l/ooP_;<01OoP_;<0
0ol0003ob:>bolRS/P04olRS/P03o`000?oZbkKoj/^f00Ooj/^f00?o0000oo3cX?o`lj000_o`lj00
0ol0003oWm=/o`000006o`0000_oSmWo1?l0000=oicEo003o`000?nQeo[oXMOj00?o00002OnRdOP0
0ol0003oY]7gojKAm`04ojKAm`Co00009Oooool00ol0003oooooooooo`0Aooooo`004Oooool3o`00
00Kooooo00?o0000ooooooooool02Oooool3o`0003gooooo00?o0000oh6/l?n1[?001on1[?000ol0
003oM:G`ogBUl006ogBUl003o`000?mRVNkoHYW^00KoHYW^00?o0000odJ6j?m6Q^P01?m6Q^P3o`00
00KoJ8?J00?o0000ofUfcOmYM/d01OmYM/d00ol0003oNFjjogU^^P07ogU^^P03o`000?nAKjSoTFnX
00[oTFnX00?o0000ojIlYOnVO:D02_nVO:D00ol0003oU6bRoiA/XP09oiA/XP03o`000?n3H:7oPf2Q
00[oPf2Q00?o0000oi]dY_nKM:H02_nKM:H00ol0003oYgjVojMnYP07ojMnYP03o`000?oP_;?oh;bc
00Koh;bc00?o0000olRS/_o8Xk800oo8Xk800ol0003oj/^fon[;]P07on[;]P03o`000?o`lj3ol?>P
00;ol?>P0ol00005ohgEo`;o00001_n?fOl4o`0000CoVM;l00?o0000oicEo?nLeO`02OnLeO`4o`00
00goX]7h00?o0000ojKAmonVdOL00ol00004ooooo`03o`000?oooooooooo02;ooooo00?o0000oooo
ooooool04Oooool001[ooooo0_l00007ooooo`?o0000@Oooool00ol0003oPJc`oh6/l007oh6/l003
o`000?mdYO3oM:G`00KoM:G`00?o0000of:Ik_mRVNh01_mRVNh00ol0003oAXKXodJ6j004odJ6j004
o`000?lOIMWo0000o`0000CoJ8?J00?o0000ofUfcOmYM/d01_mYM/d00ol0003oNFjjogU^^P06ogU^
^P03o`000?nAKjSoTFnX00[oTFnX00?o0000ojIlYOnVO:D02_nVO:D00ol0003oU6bRoiA/XP09oiA/
XP03o`000?n3H:7oPf2Q00[oPf2Q00?o0000oi]dY_nKM:H02onKM:H00ol0003oYgjVojMnYP05ojMn
YP03o`000?oP_;?oh;bc00Ooh;bc00?o0000olRS/_o8Xk800_o8Xk800ol0003oj/^fon[;]P07on[;
]P03o`000?o`lj3ol?>P00;ol?>P0_l00009ohgEo`03o`000?n?fOooSmWo00?o00002OnId_`00ol0
003oW=GloicEo004oicEo0Co00000onOd?P00ol0003oX]7hoj;An00:oj;An0Co00002?ooool00ol0
003oooooooooo`0Qooooo`03o`000?oooooooooo017ooooo000Iooooo`;o00001Oooool3o`0004Go
oooo4?l00003ogBUl003o`000?mRVNkoHYW^00GoHYW^00?o0000odJ6j?m6Q^P01Om6Q^P00ol0003o
7fGIoamUf@02o`0000?oJ8?J00?o0000ofUfcOmYM/d01OmYM/d00ol0003oNFjjogU^^P07ogU^^P03
o`000?nAKjSoTFnX00WoTFnX00?o0000ojIlYOnVO:D02_nVO:D00ol0003oU6bRoiA/XP09oiA/XP03
o`000?n3H:7oPf2Q00[oPf2Q00?o0000oi]dY_nKM:H02onKM:H00ol0003oYgjVojMnYP04ojMnYP03
o`000?oP_;?oh;bc00Soh;bc00?o0000olRS/_o8Xk800_o8Xk800ol0003oj/^fon[;]P07on[;]P04
o`000?o`lj3ol?>Poo3cX0;o00002?n=eOl5o`0000goVM;l00?o0000oicEo?nLeO`00ol00008oio@
n003o`000?nRdOSoX]7h00GoX]7h1?l0000=ooooo`03o`000?oooooooooo023ooooo00?o0000oooo
ooooool04Oooool001Wooooo00Co0000oooooooooooooooo0ol0001:ooooo`03o`000?mi[_CoNJkd
00OoNJkd00Co0000ofNVmOmWY_GoIjKe2?l00004of:IkP03o`000?m6Q^SoAXKX00GoAXKX00Go0000
oamUfOlOIMWo7fGIo`000002ofR3fP03o`000?mYM/goJGK=00GoJGK=00?o0000ogU^^_miK[X01omi
K[X00ol0003oTFnXoi5_Z009oi5_Z003o`000?nVO:GoYWbU00_oYWbU00?o0000oiA/X_nDK:802OnD
K:800ol0003oPf2Qoh=PX@09oh=PX@03o`000?nKM:KoVgBV00_oVgBV00?o0000ojMnY_nWOZH01?nW
OZH00ol0003oh;bcon2l/`09on2l/`04o`000?o8Xk;ob:>bo`0000Woj/^f00?o0000oo3cX?o`lj00
0_o`lj02o`0000?oSMGo1Ol00005oiW@n`03o`000?nId_coVM;l00WoVM;l1?l0000<oio@n003o`00
0?nRdOSoX]7h00Co00004Oooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo013ooooo
000Iooooo`Co0000C_ooool00ol0003oNJkdogV^m007ogV^m003o`000?mWY_GoIjKe00KoIjKe00?o
0000odNFlOl000001Ol00007odJ6j004o`000?lOIMWo7fGIoamUf@;o000000?oJ8?Jo`000?mYM/d0
1OmYM/d00ol0003oNFjjogU^^P07ogU^^P03o`000?nAKjSoTFnX00WoTFnX00?o0000ojIlYOnVO:D0
2onVO:D00ol0003oU6bRoiA/XP09oiA/XP03o`000?n3H:7oPf2Q00WoPf2Q00?o0000oi]dY_nKM:H0
2onKM:H00ol0003oYgjVojMnYP03ojMnYP03o`000?oP_;?oh;bc00[oh;bc00Co0000olRS/_o8Xk;o
00002?oZbkH00ol0003ol?>Poo3cX002oo3cX0Ko00002onId?/00ol0003oVM;loiWBo004oiWBo0Co
00001?nNc_P00ol0003oWm3hoio@n008oio@n0Co00005_ooool00ol0003oooooooooo`0Pooooo`03
o`000?oooooooooo013ooooo000Iooooo`;o0000DOooool00ol0003oNJkdogV^m007ogV^m003o`00
0?mWY_GoIjKe00KoIjKe00?o0000odNFlOm7U_400om7U_43o`0000KoAXKX00?o0000oamUfOlOIMT0
0_lOIMT2o`0000OoJGK=00?o0000ogU^^_miK[X01_miK[X00ol0003oTFnXoi5_Z009oi5_Z003o`00
0?nVO:GoYWbU00_oYWbU00?o0000oiA/X_nDK:802OnDK:800ol0003oPf2Qoh=PX@09oh=PX@03o`00
0?nKM:KoVgBV00_oVgBV00?o0000ojMnY_nWOZH00onWOZH00ol0003oh;bcon2l/`0:on2l/`03o`00
0?o8Xk;o000000Woj/^f00?o0000oo3cX?o`lj000_o`lj000ol0003oW]3ioik@n@02oik@n@03o`00
0?nId?_oVM3k00[oVM3k00?o0000oiWBo?nId_`00ol00009oik>n003o`000?nOd?SoWm3h00CoWm3h
0ol0000Kooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool04?ooool001_ooooo00?o
0000ooooooooool0Coooool00ol0003oNJkdogV^m007ogV^m003o`000?mWY_GoIjKe00KoIjKe00?o
0000odNFlOm7U_401Om7U_43o`0000?oAXKX00?o0000oamUfOlOIMT01?lOIMT00ol0003oJGK=ofUf
c@04ofUfc@03o`000?miK[[oNFjj00KoNFjj00?o0000oi5_Z?nAKjP02_nAKjP00ol0003oYWbUojIl
Y@0:ojIlY@03o`000?nDK:;oU6bR00WoU6bR00?o0000oh=PXOn3H:402_n3H:400ol0003oVgBVoi]d
YP0;oi]dYP05o`000?nWOZKoYgjVojMnY_l000003_oP_;<2o`0000Soj/^f00?o0000oo3cX?o`lj00
0_o`lj000ol0003oW]3ioik@n@04oik@n@03o`000?nId?_oVM3k00OoVM3k1Ol0000=oik>n003o`00
0?nOd?SoWm3h00?o00007_ooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo013ooooo
000Looooo`03o`000?oooooooooo04oooooo00?o0000ogV^m?mi[_@01omi[_@00ol0003oIjKeofNV
m@06ofNVm@03o`000?m7U_7oAiKa00GoAiKa00?o0000o`ebh?l000000_l000000om6Q^So0000oamU
f@04oamUf@;o00001OmYM/d00ol0003oNFjjogU^^P07ogU^^P03o`000?nAKjSoTFnX00WoTFnX00?o
0000ojIlYOnVO:D02_nVO:D00ol0003oU6bRoiA/XP09oiA/XP03o`000?n3H:7oPf2Q00[oPf2Q00?o
0000oi]dY_nKM:H02onKM:H01Ol0003oYgjVojMnY_nWOZKo000000koh;bc00?o0000on[;]_oZbkH0
1ooZbkH01Ol0003ol?>Poo3cX?o`lj3o000000SoW]3i00Co0000oiW@nonId?_oVM3k1Ol00005oio<
m`03o`000?nNc_SoW/kh00WoW/kh1?l0000Rooooo`03o`000?oooooooooo01kooooo00?o0000oooo
ooooool04?ooool001gooooo00?o0000ooooooooool0Coooool@o`0000?oIjKe00?o0000odNFlOm7
U_401Om7U_401?l0003o3G;Po`ebh?l=L^03o`0000Go7fGI0_l00005ofUfc@03o`000?miK[[oNFjj
00KoNFjj00?o0000oi5_Z?nAKjP02OnAKjP00ol0003oYWbUojIlY@0:ojIlY@03o`000?nDK:;oU6bR
00WoU6bR00?o0000oh=PXOn3H:402_n3H:400ol0003oVgBVoi]dYP0;oi]dYP04o`000?nWOZKoYgjV
o`0000ooh;bc00?o0000on[;]_oZbkH01_oZbkH00ol0003ol?>Poo3cX002oo3cX003o`000?nNd?Wo
W]3i00GoW]3i1Ol0000;oio<m`03o`000?nNc_SoW/kh00CoW/kh1?l0000Wooooo`03o`000?oooooo
oooo01gooooo00?o0000ooooooooool04?ooool001kooooo0_l0001Aooooo`03o`000?me/_SoMK;h
00OoMK;h00Co0000oejYn?mNZOSoGZWh2?l00004odNFl@03o`000?l=L^3o3G;P00?o3G;P0_l00003
oamUf@03o`000?l0>[ko000000CoJGK=00?o0000ogU^^_miK[X01_miK[X00ol0003oTFnXoi5_Z009
oi5_Z003o`000?nVO:GoYWbU00[oYWbU00?o0000oiA/X_nDK:802_nDK:800ol0003oPf2Qoh=PX@09
oh=PX@03o`000?nKM:KoVgBV00_oVgBV00Co0000ojMnY_nWOZKo00003_oP_;<00ol0003oglg7o`00
0007on[;]P05o`000?o`lj3ol?>Poo3cX?l000001?nNd?T4o`0000CoX/cf00?o0000oio<monOc?L0
2_nOc?L00ol0003oW/khoik>n003o`0002cooooo00?o0000ooooooooool07?ooool00ol0003ooooo
ooooo`0@ooooo`008?ooool00ol0003oooooooooo`1?ooooo`;o00002?me/_P2o`0000OoGZWh00?o
0000oc>FlOl000001Ol00004o`ebh003o`000?l0::Go000000?o7fGI00?o0000o`0j__l000000omY
M/d00ol0003oNFjjogU^^P06ogU^^P03o`000?nAKjSoTFnX00WoTFnX00?o0000ojIlYOnVO:D02onV
O:D00ol0003oU6bRoiA/XP09oiA/XP03o`000?n3H:7oPf2Q00WoPf2Q00?o0000oi]dY_nKM:H02onK
M:H00ol0003oYgjVo`00000>on2l/`05o`000?oOcLOoglg7omo=aol000001OoZbkH00ol0003ol?>P
oo3cX002o`0000;oW]3i0ol00009oj;<mP03o`000?nOc?OoWlcg00OoWlcg1Ol0000_ooooo`03o`00
0?oooooooooo01gooooo00?o0000ooooooooool03oooool0027ooooo00?o0000ooooooooool0D?oo
ool00ol0003oMK;hogFbn007ogFbn003o`000?mNZOSoGZWh00GoGZWh0_l00004oc>Fl@?o00000ol=
L^000ol0003o02RUo`000002oamUf@04o`000?l0>[ko03Zno`0000;oJGK=00?o0000ogU^^_miK[X0
1_miK[X00ol0003oTFnXoi5_Z009oi5_Z003o`000?nVO:GoYWbU00_oYWbU00?o0000oiA/X_nDK:80
2OnDK:800ol0003oPf2Qoh=PX@09oh=PX@03o`000?nKM:KoVgBV00coVgBV0_l0000=on2l/`03o`00
0?oOcLOoglg700?oglg700?o0000on[;]_oZbkH00_oZbkH01?l0003ol?>Po`000?oXi<`3o`0000go
X/cf00Co0000oio<monOc?OoWlcg1Ol0000eooooo`03o`000?oooooooooo01cooooo00?o0000oooo
ooooool03oooool002;ooooo00?o0000ooooooooool0D?ooool00ol0003oMK;hogFbn007ogFbn003
o`000?mNZOSoGZWh00KoGZWh00?o0000oc>FlOlcU_401?lcU_42o`0000;o3G;P00?o0000o`0XYOl0
00000_lOIMT01?l0003o03Zno`0j__l00002ofUfc@03o`000?miK[[oNFjj00GoNFjj00?o0000oi5_
Z?nAKjP02_nAKjP00ol0003oYWbUojIlY@0:ojIlY@03o`000?nDK:;oU6bR00WoU6bR00?o0000oh=P
XOn3H:402_n3H:400ol0003oVgBVoi]dYP0:oi]dYP;o00003_oP_;<00ol0003oglg7omo=a`04omo=
a`03o`000?oZbkKoj/^f00?o000000?oj>C<o`000?nWc_@00_nWc_@00ol0003oX/cfoj;<mP09oj;<
mPGo0000>oooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo00oooooo000Sooooo`;o
0000DOooool@o`0000?oGZWh00?o0000oc>FlOlcU_401?lcU_43o`000006o`ebh?l0003o02RUo`00
0?lOIMWo00000ol0>[h00ol0003oJGK=o`000008ogU^^P03o`000?nAKjSoTFnX00WoTFnX00?o0000
ojIlYOnVO:D02_nVO:D00ol0003oU6bRoiA/XP09oiA/XP03o`000?n3H:7oPf2Q00[oPf2Q00?o0000
oi]dY_nKM:H02OnKM:H00ol0003o`<_Ro`00000=on2l/`03o`000?oOcLOoglg700Koglg700?o0000
on[;]_l000000ooXi<`00ol0003oYlkdojO>m002ojO>m003o`000?nRc?KoX/cf00CoX/cf1?l00011
ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool03oooool002Gooooo00?o0000oooo
ooooool0D?ooool00ol0003oMKOjogFgnP07ogFgnP04o`000?mN/?_oG[3koej`n`So00001?lcU_44
o`000004o`0XYOl0003o7fGIo`0000?o03Zn0_l00008ogU^^P03o`000?nAKjSoTFnX00WoTFnX00?o
0000ojIlYOnVO:D02_nVO:D00ol0003oU6bRoiA/XP09oiA/XP03o`000?n3H:7oPf2Q00[oPf2Q00?o
0000oi]dY_nKM:H01onKM:H2o`0000?o`<_R00?o0000on2l/ooP_;<02OoP_;<00ol0003oglg7omo=
a`08omo=a`05o`000?oXi<coj>C<onSTc?l000001_nWc_@00ol0003oX/cfoj;<mP03o`0004Gooooo
00?o0000ooooooooool06_ooool00ol0003oooooooooo`0?ooooo`009_ooool00ol0003ooooooooo
o`1@ooooo`03o`000?me]o[oMKOj00OoMKOj00?o0000oej`nomN/?/01_mN/?/00ol0003o<Ykbo`00
0005o`000004o`1Tc?l0003o0000o`0XY@;o00001?l0>[h2o`0000OoNFjj00?o0000oi5_Z?nAKjP0
2OnAKjP00ol0003oYWbUojIlY@0:ojIlY@03o`000?nDK:;oU6bR00[oU6bR00?o0000oh=PXOn3H:40
2On3H:400ol0003oVgBVoi]dYP05oi]dYP;o00001Oo0bn800ol0003oh;bcon2l/`08on2l/`03o`00
0?oOcLOoglg700Woglg700Go0000onSTc?oXi<coj>C<o`000005ojO>m0Co0000BOooool00ol0003o
ooooooooo`0Iooooo`03o`000?oooooooooo00oooooo000Wooooo`03o`000?oooooooooo053ooooo
00?o0000ogFgn_me]oX01ome]oX00ol0003oG[3koej`n`06oej`n`;o00001?lbW_88o`0000Co03Zn
00?o0000ogU^^_miK[X01OmiK[X00ol0003oTFnXoi5_Z009oi5_Z003o`000?nVO:GoYWbU00[oYWbU
00?o0000oiA/X_nDK:802_nDK:800ol0003oPf2Qoh=PX@09oh=PX@03o`000?nKM:KoVgBV00CoVgBV
00?o0000ol3;h_o0bn801_o0bn800ol0003oh;bcon2l/`07on2l/`03o`000?oOcLOoglg700Soglg7
00Go0000onSTc?oXi<coj>C<o`000003ojO>m0?o0000C_ooool00ol0003oooooooooo`0Hooooo`03
o`000?oooooooooo00oooooo000Xooooo`03o`000?oooooooooo053ooooo00?o0000ogFgn_me]oX0
1ome]oX00ol0003oG[3koej`n`07oej`n`03o`000?lbW_;o<Ykb00Co<Ykb1Ol00004o`0j_P03o`00
0?miK[[oNFjj00GoNFjj00?o0000oi5_Z?nAKjP02_nAKjP00ol0003oYWbUojIlY@0:ojIlY@03o`00
0?nDK:;oU6bR00WoU6bR00?o0000oh=PXOn3H:402On3H:400ol0003oVgBVoi]dYP02oi]dYP;o0000
2Oo0bn800ol0003oh;bcon2l/`06on2l/`03o`000?oOcLOoglg700Soglg700?o0000onSTc?oXi<`0
0_oXi<`4o`00057ooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`0>ooooo`00:Ooo
ool2o`00057ooooo6_l00002oc:NlPCo00001?l0>[h00ol0003oNFjjogU^^P05ogU^^P03o`000?nA
KjSoTFnX00WoTFnX00?o0000ojIlYOnVO:D02_nVO:D00ol0003oU6bRoiA/XP09oiA/XP03o`000?n3
H:7oPf2Q00[oPf2Q00Co0000oi]dY_l0003o00003?o0bn800ol0003oh;bcon2l/`04on2l/`03o`00
0?oOcLOoglg700Soglg700?o0000onSTc?oXi<`00_oXi<`2o`0005Gooooo00?o0000ooooooooool0
6?ooool00ol0003oooooooooo`0>ooooo`00:oooool00ol0003oooooooooo`1@ooooo`03o`000?mj
_?coN[cl00OoN[cl0_l00008ofJio@;o00000_m4[oL6o`0000Co03Zn0_l00006ogU^^P03o`000?nA
KjSoTFnX00WoTFnX00?o0000ojIlYOnVO:D02_nVO:D00ol0003oU6bRoiA/XP09oiA/XP03o`000?n3
H:7oPf2Q00[oPf2Q0_l0000?ol3;hP03o`000?oP_;?oh;bc00;oh;bc00?o0000omo=aooOcLL02OoO
cLL00ol0003oj>C<onSTc002onSTc003o`000?oooooooooo05Gooooo00?o0000ooooooooool05ooo
ool00ol0003oooooooooo`0>ooooo`00;?ooool00ol0003oooooooooo`1@ooooo`;o00002Omj_?`0
0ol0003oI[WmofJio@07ofJio@03o`000?m4[oOoA:og00GoA:og00Oo0000o`0j__l0>[ko03Zno`00
0?l06ZCo000000GoNFjj00?o0000oi5_Z?nAKjP02OnAKjP00ol0003oYWbUojIlY@0:ojIlY@03o`00
0?nDK:;oU6bR00WoU6bR00?o0000oh=PXOn3H:402?n3H:44o`0000oo`<_R00?o0000on2l/ooP_;<0
0_oP_;<00ol0003oglg7omo=a`08omo=a`03o`000?oXi<coj>C<00;oj>C<00?o0000ooooooooool0
Eoooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00kooooo000]ooooo`03o`000?oo
oooooooo057ooooo00?o0000ogZlo?mj_?`01omj_?`2o`0000SoI[Wm0_l00005odB_m`;o00000ol0
>[h2o`0000GoNFjj00?o0000oi5_Z?nAKjP02OnAKjP00ol0003oYWbUojIlY@0:ojIlY@03o`000?nD
K:;oU6bR00[oU6bR00?o0000oh=PXOn3H:400on3H:44o`0000CoYL?_00?o0000ol3;h_o0bn803Oo0
bn801?l0003oh;bcon2l/ol0000:omo=a`03o`000?oXi<coj>C<00?oj>C<00?o0000ooooooooool0
Eoooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00kooooo000^ooooo`;o0000D_oo
ool00ol0003oN[clogZlo003ogZlo1Co00000_mO_od01_l0003o03Zno`0j__l0003o01ZTo`0000Co
NFjj00?o0000oi5_Z?nAKjP02OnAKjP00ol0003oYWbUojIlY@0:ojIlY@03o`000?nDK:;oU6bR00[o
U6bR00?o0000oh=PXOl000000ol00009ojG3k`03o`000?o0bn;o`<_R00co`<_R00?o0000on2l/ol0
00002_oOcLL00ol0003oj>C<onSTc003onSTc003o`000?oooooooooo05Wooooo00?o0000oooooooo
ool05Oooool00ol0003oooooooooo`0>ooooo`00<?ooool00ol0003oooooooooo`1@ooooo`Go0000
1on1`_`00ol0003oM<;nogC2oP07ogC2oP;o00000omO_od01ol0003o03Zno`0j__l0>[ko0000o`0J
Y?l000000omiK[X00ol0003oTFnXoi5_Z00:oi5_Z003o`000?nVO:GoYWbU00WoYWbU00?o0000oiA/
X_nDK:802OnDK:83o`0000koYL?_00?o0000ol3;h_o0bn802_o0bn83o`0000_oglg700?o0000onST
c?oXi<`00_oXi<`00ol0003oooooooooo`1Kooooo`03o`000?oooooooooo01Cooooo00?o0000oooo
ooooool03_ooool0037ooooo00?o0000ooooooooool0DOooool00ol0003oPL;loh72o008oh72o0;o
00002Omd`_h2o`0000;oGkom00Co0000o`0j__l0>[ko00000_l06Z@01Ol0003oNFjjogU^^_miK[[o
000000_oTFnX00?o0000ojIlYOnVO:D02_nVO:D00ol0003oU6bRoiA/XP05oiA/XP?o00000_nU`nl0
0ol0003oYL?_ojG3k`0=ojG3k`03o`000?o0bn;o`<_R00Go`<_R1?l00002ojG3k`03o`000?oOcLOo
glg700Soglg700?o0000onSTc?oXi<`00ooXi<`00ol0003oooooooooo`1Kooooo`03o`000?oooooo
oooo01Gooooo00?o0000ooooooooool03Oooool003;ooooo00?o0000ooooooooool0DOooool2o`00
00[oPL;l00?o0000ogC2o_md`_h00omd`_h9o`0000;o03Zn00?o0000o`0JY?l000000omiK[X00ol0
003oTFnXoi5_Z009oi5_Z003o`000?nVO:GoYWbU00[oYWbU00?o0000oiA/X_nDK:800_nDK:83o`00
00KoYL?_00?o0000ojG3konU`nl03OnU`nl00ol0003o`<_Rol3;hP04o`0000OoYL?_00?o0000omo=
aooOcLL01_oOcLL00ol0003oj>C<onSTc003onSTc003o`000?oooooooooo05gooooo00?o0000oooo
ooooool05?ooool00ol0003oooooooooo`0=ooooo`00<oooool2o`0005?ooooo00?o0000oh72o?n1
`_`00on1`_`:o`0000OoPlSn0ol000001Ol0>[ko0000o`0JY?l06ZCo000000;oNFjj00?o0000oi5_
Z?nAKjP02OnAKjP00ol0003oYWbUojIlY@0:ojIlY@03o`000?nDK:;o000000;o00002_nU`nl00ol0
003oYL?_ojG3k`0<ojG3k`?o00003?nU`nl00ol0003oglg7omo=a`04omo=a`03o`000?oXi<coj>C<
00Coj>C<00?o0000ooooooooool0G_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo
00gooooo000eooooo`03o`000?oooooooooo057ooooo1Ol00007oh[6o0;o00002_n3b?h00ol0003o
03Zno`000003o`0JY003o`000?miK[[o000000_oTFnX00?o0000ojIlYOnVO:D02OnVO:D3o`0000ko
YL?_00?o0000ojG3konU`nl02?nU`nl3o`000003ojG3kol0003oYL?_00goYL?_00?o0000omo=aooO
cLL00ooOcLL00ol0003oj>C<onSTc003onSTc003o`000?oooooooooo063ooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`0=ooooo`00=_ooool00ol0003oooooooooo`1Booooo`;o0000
2_n:a_`2o`0000GoPlSn1Ol000001ol0>[ko0000o`0JY?l06ZCo0000ogU^^_l000002onAKjP00ol0
003oYWbUojIlY@06ojIlY@?o000000?oYL?_o`000?nU`nl03onU`nl00ol0003oYL?_ojG3k`04ojG3
k`?o00001OnU`nl00ol0003oYL?_ojG3k`0<ojG3k`05o`000?oOcLOoglg7omo=aol000001_oXi<`0
0ol0003oooooooooo`1Pooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool03Oooool0
03Oooooo00?o0000ooooooooool0Doooool00ol0003oR/Kloh[6o007oh[6o0Oo00001On?c?`2o`00
00?o01ZT00?o0000ogU^^_l000002onAKjP00ol0003oYWbUojIlY@02ojIlY@?o00001OnU`nl00ol0
003oYL?_ojG3k`0>ojG3k`03o`000?nU`nooYL?_00?o00002OnU`nl00ol0003oYL?_ojG3k`0<ojG3
k`03o`000?oOcLOo000000Koj>C<00?o0000ooooooooool0H_ooool00ol0003oooooooooo`0Aoooo
o`03o`000?oooooooooo00gooooo000hooooo`;o0000E?ooool2o`0000;oR/Kl1Ol00004oi;9nP;o
00001_n?c?`00ol0003o03Zno`000003o`0JY0;o00002onAKjP00ol0003oYWbUo`000002o`0000Wo
YL?_00?o0000ojG3konU`nl03?nU`nl4o`0000goYL?_00?o0000ojG3konU`nl02_nU`nl4o`0000Ko
j>C<00?o0000ooooooooool0Hoooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00go
oooo000jooooo`03o`000?oooooooooo05?ooooo0_l0000;oi;9nP03o`000?n?c?coSlcl00CoSlcl
0_l00004o`0JY0ko00003OnU`nl00ol0003oYL?_ojG3k`08ojG3k`?o00000_nU`nl00ol0003oYL?_
ojG3k`0=ojG3k`03o`000?nU`nooYL?_00GoYL?_1?l00004ojG3k`;o00000ooXi<`00ol0003ooooo
ooooo`1Uooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool03Oooool003_ooooo00?o
0000ooooooooool0E?ooool00ol0003oT/Wjoi;9nP09oi;9nP;o00000_n?c?`4o`0000Co01ZT00?o
0000ohFLh_n5W>802on5W>800ol0003oYL?_ojG3k`0;ojG3k`03o`000?nU`nooYL?_00CoYL?_0ol0
0006ojG3k`03o`000?nU`nooYL?_00goYL?_00?o0000ojG3konU`nl01?l0000:ojG3k`;o000000?o
j>C<o`000?ooool0I_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00cooooo000l
ooooo`03o`000?oooooooooo05Cooooo0_l00009oi;9nPCo00001?nHcOX2o`0000?o01ZT00?o0000
ohFLh_n5W>802on5W>800ol0003oYL?_ojG3k`0;ojG3k`03o`000?nU`nooYL?_00?o00002_nU`nl0
0ol0003oYL?_ojG3k`0<ojG3k`?o00003onU`nl2o`0006Wooooo00?o0000ooooooooool03oooool0
0ol0003oooooooooo`0<ooooo`00?Oooool2o`0005Kooooo00Co0000oi;9n_nBbO[oT/Wj1Ol00004
oiW:n003o`000?nHcO[oV<gj00;oV<gj0_l00003o`0JY003o`000?n5W>;oQIcR00_oQIcR00?o0000
ojG3konU`nl02OnU`nl4o`0000koYL?_00?o0000ojG3konU`nl02?nU`nl3o`000003ojG3kol0003o
YL?_00goYL?_0_l0001/ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool03?ooool0
03oooooo00?o0000ooooooooool0E?ooool3o`0000[oVL[h0_l00003oiS=nP;o00000_l06Z@00ol0
003oQIcRohFLhP0<ohFLhP03o`000?nU`nooYL?_00CoYL?_1?l00004ojG3k`03o`000?nU`nooYL?_
00coYL?_00?o0000ojG3konU`nl01?nU`nl3o`0000GoYL?_00?o0000ojG3konU`nl02_nU`nl00ol0
003oooooooooo`1/ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool03?ooool0043o
oooo00?o0000ooooooooool0EOooool00ol0003oVL[hoiW:n00:oiW:n003o`000?nHcO[oV<gj00Co
000000?o01ZTo`000?n5W>803On5W>800ol0003oYL?_ojG3k`03o`0000WoYL?_00?o0000ojG3konU
`nl03?nU`nl00ol0003oYL?_ojG3k`03o`0000WoYL?_00?o0000ojG3konU`nl01onU`nl2o`00073o
oooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0<ooooo`00@Oooool00ol0003ooooo
ooooo`1Eooooo`;o00002OnIb_P4o`0000;oW/gh00Go0000o`0_Zol0003o01ZTo`00000=ohFLhP?o
00003OnU`nl00ol0003oYL?_ojG3k`0:ojG3k`Co00003OnU`nl00ol0003oYL?_ojG3k`04ojG3k`;o
0000Loooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00cooooo0012ooooo`;o0000
Eoooool01?l0003oVL[hoiW:n?nIb_P5o`0000CoW/[g0_l000000onNcOSo0000o`0_Z`03o`0000Wo
QIcR0ol000000onU`noo0000ojG3k`0>ojG3k`03o`000?nU`nooYL?_00GoYL?_1?l00003ojG3k`03
o`000?nU`nooYL?_00coYL?_00?o0000ojG3konU`nl00_nU`nl00ol0003oooooooooo`1dooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool03?ooool004Cooooo00?o0000ooooooooool0
EOooool3o`0000_oW/[g00Ko0000oik=n?l0003o0000o`0_Zol00006ohFLhP?o00001OnU`nl00ol0
003oYL?_ojG3k`0=ojG3k`03o`000?nU`nooYL?_00Co00002?nU`nl00ol0003oYL?_ojG3k`0<ojG3
k`04o`000?nU`noo0000o`0007Oooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0;
ooooo`00AOooool00ol0003oooooooooo`1Fooooo`03o`000?nNb_OoW/[g00WoW/[g1Ol000001?l0
;j_o0000ohFLh_n5W>83o`0000WoYL?_00?o0000ojG3konU`nl03?nU`nl3o`0000goYL?_00?o0000
ojG3konU`nl02_nU`nl3o`0007[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0;
ooooo`00A_ooool00ol0003oooooooooo`1Fooooo`;o00001_nNb_L3o`0000?oX/[d00?o0000oj?<
mOl000000ol0000=ojG3k`03o`000?nU`nooYL?_00SoYL?_0ol000000onU`noo0000ojG3k`0>ojG3
k`03o`000?nU`nooYL?_00GoYL?_1?l0001nooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02oooool004Oooooo00?o0000ooooooooool0Eoooool00ol0003oW/[goik:m`03o`0000Oo
X/[d0_l000001?nSc?Go0000o`0_Zol0000=ojG3k`03o`000?nU`nooYL?_00CoYL?_0ol00005ojG3
k`03o`000?nU`nooYL?_00goYL?_00?o0000ojG3konU`nl01?l00022ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool02oooool004Sooooo0_l0001Hooooo`;o00003?nRb_@00ol0003o
Xlceo`000002o`0000goYL?_00?o0000ojG3konU`nl00ol00009ojG3k`03o`000?nU`nooYL?_00co
YL?_0ol00027ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02oooool004[ooooo
00?o0000ooooooooool0Eoooool00ol0003oX/[doj;:m008oj;:m0Co000000?oooooo`000?l00000
2onU`nl4o`0000goYL?_00?o0000ojG3konU`nl02?nU`nl3o`0008_ooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`0;ooooo`00Boooool00ol0003oooooooooo`1Gooooo`03o`000?nR
b_CoX/[d00CoX/[d0ol00006ooooo`;o00001_nU`nl4o`0000CoU]on00?o0000ojG3konU`nl02onU
`nl00ol0003oYL?_ojG3k`04ojG3k`?o0000Soooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00_ooooo001<ooooo`03o`000?oooooooooo05Oooooo00?o0000oj;:m?nRb_@00ol0000;
ooooo`03o`000?nU`nooYL?_00?o00002OnFgoh00ol0003oYL?_ojG3k`0;ojG3k`03o`000?nU`noo
YL?_00?o0000T_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00[ooooo001=oooo
o`;o0000F?ooool2o`0000oooooo0_l0000=oiKOoP03o`000?nU`nooYL?_00WoYL?_1?l0002Foooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02_ooool004oooooo00?o0000oooooooo
ool0E_ooool00ol0003oooooooooo`0?ooooo`;o00003?nFgoh00ol0003oYL?_ojG3k`04ojG3k`Co
0000Voooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00[ooooo001@ooooo`03o`00
0?oooooooooo05Gooooo00?o0000ooooooooool04Oooool2o`0000_oU]on00?o0000ojG3konU`nl0
0ol0002Pooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool02_ooool0057ooooo00?o
0000ooooooooool0E?ooool00ol0003oooooooooo`0Cooooo`ko0000Xoooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00[ooooo001Booooo`;o0000E?ooool00ol0003oooooooooo`35
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool02_ooool005Cooooo00?o0000oooo
ooooool0DOooool00ol0003oooooooooo`36ooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool02_ooool005Gooooo00?o0000ooooooooool0D?ooool00ol0003oooooooooo`36ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool02Oooool005Kooooo00?o0000ooooooooool0
Coooool00ol0003oooooooooo`37ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
2Oooool005Oooooo0_l0001?ooooo`03o`000?oooooooooo0<Sooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`09ooooo`00FOooool00ol0003oooooooooo`1;ooooo`03o`000?oooooo
oooo0<[ooooo00Go0000ooooooooooooooooo`00000;ooooo`00F_ooool00ol0003oooooooooo`1:
ooooo`03o`000?oooooooooo0<[ooooo00Go0000ooooooooooooooooo`00000;ooooo`00Foooool0
0ol0003oooooooooo`19ooooo`03o`000?oooooooooo0<_ooooo00Co0000oooooooooooo00002ooo
ool005cooooo0_l00019ooooo`03o`000?oooooooooo0<cooooo00?o0000ooooool000002oooool0
05kooooo00?o0000ooooooooool0A_ooool00ol0003oooooooooo`3<ooooo`04o`000?oooooooooo
o`0000[ooooo001Oooooo`03o`000?oooooooooo04Gooooo00?o0000ooooooooool0cOooool00ol0
003oooooo`00000:ooooo`00H?ooool00ol0003oooooooooo`14ooooo`03o`000?oooooooooo0<ko
oooo0_l0000:ooooo`00HOooool00ol0003oooooooooo`13ooooo`03o`000?oooooooooo0<gooooo
0ol0000:ooooo`00H_ooool2o`0004?ooooo00?o0000ooooooooool0bOooool4o`0000gooooo001T
ooooo`03o`000?oooooooooo043ooooo00?o0000ooooooooool0aOooool4o`00017ooooo001Uoooo
o`03o`000?oooooooooo03oooooo00?o0000ooooooooool0`_ooool3o`0001Gooooo001Vooooo`03
o`000?oooooooooo03kooooo00?o0000ooooooooool0__ooool4o`0001Sooooo001Wooooo`;o0000
?_ooool00ol0003oooooooooo`2jooooo`Co00007?ooool006Wooooo00?o0000ooooooooool0>ooo
ool00ol0003oooooooooo`2fooooo`Co00008?ooool006[ooooo00?o0000ooooooooool0>_ooool0
0ol0003oooooooooo`2booooo`Co00009?ooool006_ooooo00?o0000ooooooooool0>Oooool00ol0
003oooooooooo`2^ooooo`Co0000:?ooool006cooooo0_l0000iooooo`03o`000?oooooooooo0:[o
oooo1?l0000/ooooo`00K_ooool00ol0003oooooooooo`0fooooo`03o`000?oooooooooo0:Oooooo
0ol0000`ooooo`00Koooool00ol0003oooooooooo`0eooooo`03o`000?oooooooooo0:?ooooo1?l0
000cooooo`00L?ooool00ol0003oooooooooo`0dooooo`03o`000?oooooooooo09oooooo1?l0000g
ooooo`00LOooool2o`0003Cooooo00?o0000ooooooooool0Voooool4o`0003_ooooo001cooooo`03
o`000?oooooooooo037ooooo00?o0000ooooooooool0Uoooool4o`0003oooooo001dooooo`03o`00
0?oooooooooo033ooooo00?o0000ooooooooool0Toooool4o`0004?ooooo001eooooo`03o`000?oo
oooooooo02oooooo00?o0000ooooooooool0Soooool4o`0004Oooooo001fooooo`;o0000;oooool0
0ol0003oooooooooo`2<ooooo`?o0000Boooool007Sooooo00?o0000ooooooooool0:oooool00ol0
003oooooooooo`29ooooo`Co0000C_ooool007Wooooo00?o0000ooooooooool0:_ooool00ol0003o
ooooooooo`25ooooo`Co0000D_ooool007[ooooo00?o0000ooooooooool0:Oooool00ol0003ooooo
ooooo`21ooooo`Co0000E_ooool007_ooooo00?o0000ooooooooool0:?ooool00ol0003ooooooooo
o`1mooooo`Co0000F_ooool007cooooo0_l0000Xooooo`03o`000?oooooooooo07Wooooo1?l0001N
ooooo`00O_ooool00ol0003oooooooooo`0Uooooo`03o`000?oooooooooo07Gooooo1?l0001Roooo
o`00Ooooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo07;ooooo0ol0001Vooooo`00
P?ooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo06kooooo1?l0001Yooooo`00POoo
ool2o`0002?ooooo00?o0000ooooooooool0J_ooool4o`0006gooooo0023ooooo`03o`000?oooooo
oooo023ooooo00?o0000ooooooooool0I_ooool4o`00077ooooo0024ooooo`03o`000?oooooooooo
01oooooo00?o0000ooooooooool0H_ooool4o`0007Gooooo0025ooooo`03o`000?oooooooooo01ko
oooo00?o0000ooooooooool0G_ooool4o`0007Wooooo0026ooooo`;o00007_ooool00ol0003ooooo
ooooo`1Jooooo`Co0000OOooool008Sooooo00?o0000ooooooooool06oooool00ol0003ooooooooo
o`1Gooooo`?o0000POooool008Wooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`1C
ooooo`Co0000Q?ooool008[ooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`1?oooo
o`Co0000R?ooool008_ooooo0_l0000Iooooo`03o`000?oooooooooo04_ooooo1?l0002<ooooo`00
SOooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo04Oooooo1?l0002@ooooo`00S_oo
ool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo04?ooooo1?l0002Dooooo`00Soooool0
0ol0003oooooooooo`0Dooooo`03o`000?oooooooooo03oooooo1?l0002Hooooo`00T?ooool2o`00
01Cooooo00?o0000ooooooooool0??ooool3o`0009cooooo002Booooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool0>?ooool4o`0009oooooo002Cooooo`03o`000?oooooooooo013ooooo
00?o0000ooooooooool0=?ooool4o`000:?ooooo002Dooooo`03o`000?oooooooooo00oooooo00?o
0000ooooooooool0<?ooool4o`000:Oooooo002Eooooo`;o00003oooool00ol0003oooooooooo`0/
ooooo`Co0000Zoooool009Oooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Yoooo
o`Co0000[oooool009Sooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Uooooo`Co
0000/oooool009Wooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0Rooooo`?o0000
]oooool009[ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Nooooo`Co0000^_oo
ool009_ooooo0_l00008ooooo`03o`000?oooooooooo01[ooooo1?l0002nooooo`00WOooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo01Kooooo1?l00032ooooo`00W_ooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo01;ooooo1?l00036ooooo`00Woooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo00kooooo1?l0003:ooooo`00X?ooool2o`0000?ooooo00?o
0000ooooooooool02_ooool4o`000<kooooo002Rooooo`04o`000?ooooooooooo`0000Wooooo0ol0
003Booooo`00Xoooool00ol0003oooooo`000005ooooo`Co0000eOooool00:Cooooo0_l000000ooo
oooo0000o`000002o`000=Wooooo002Uooooo`;o0000gOooool00?ooooooQOooool00?ooooooQOoo
ool00?ooooooQOooool00?ooooooQOooool00?ooooooQOooool00?ooooooQOooool00?ooooooQOoo
ool00?ooooooQOooool00?ooooooQOooool00?ooooooQOooool00?ooooooQOooool00?ooooooQOoo
ool00001\
\>"],
  ImageRangeCache->{{{0, 387}, {316, 0}} -> {-0.0681986, 0.0165155, \
0.0027023, 0.0027023}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Define matrix flatteners to set up the linear hydrodynamics \
equations:\
\>", "Subsubsection",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
flatmat[M_]:=Module[{Mt,Mf},
\tMt=Transpose[M,{1,3,2,4}];
\tMf=Table[Flatten[Mt[[i,j]]],{i,Length[Mt]},{j,Length[Mt[[1]]]}];
\tN[Flatten[Mf,1]]
];\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["flatvec[x_]:=Flatten[x,1];", "Input",
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
complete[M_,geo_]:=Module[{base,n,npoints,Mc},
\t(*\tUgly but necessary, since the additional equations required
\t\tto solve the tableau destroy the \"tensorness\" of the matrix
\t\tof matrices. *)
\tdim=Length[M];
\tn=dim/3-1;
\tMc=Table[0,{dim+1},{dim+1}];
\tDo[\tMc[[i,j]]=M[[i,j]],{i,dim},{j,dim}];
\tDo[\tbase=(i-1)*3;
\t\tMc[[base+1,dim+1]]=Evaluate[u[i,geo]][[1]];
\t\tMc[[base+2,dim+1]]=Evaluate[u[i,geo]][[2]];
\t\tMc[[base+3,dim+1]]=Evaluate[u[i,geo]][[3]],
\t{i,n}];
\tbottom=Flatten[Table[z[i,geo],{i,n}]];
\tDo[ Mc[[dim+1,j]]=bottom[[j]],{j,3*n}];
\tReturn[Mc]
];\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["Show tensor->matrix flattening in action:", "Text",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
M={\t{{{a1111,a1112},{a1121,a1122}},{{a1211,a1212},{a1221,a1222}}},
\t{{{a2111,a2112},{a2121,a2122}},{{a2211,a2212},{a2221,a2222}}} };\
\>", \
"Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["MatrixForm[M]", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[OutputFormData["\<\
MatrixForm[{{{{a1111, a1112}, {a1121, a1122}}, \
{{a1211, a1212}, {a1221, a1222}}}, 
 
   {{{a2111, a2112}, {a2121, a2122}}, {{a2211, a2212}, {a2221, \
a2222}}}}]\
\>", "\<\
a1111 a1112   a1211 a1212
a1121 a1122   a1221 a1222

a2111 a2112   a2211 a2212
a2121 a2122   a2221 a2222\
\>"], "Output",
  LineSpacing->{1, 0},
  ImageRegion->{{-0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MatrixForm[Transpose[M,{1,3,2,4}]]", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[OutputFormData["\<\
MatrixForm[{{{{a1111, a1112}, {a1211, a1212}}, \
{{a1121, a1122}, {a1221, a1222}}}, 
 
   {{{a2111, a2112}, {a2211, a2212}}, {{a2121, a2122}, {a2221, \
a2222}}}}]\
\>", "\<\
a1111 a1112   a1121 a1122
a1211 a1212   a1221 a1222

a2111 a2112   a2121 a2122
a2211 a2212   a2221 a2222\
\>"], "Output",
  LineSpacing->{1, 0},
  ImageRegion->{{-0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MatrixForm[flatmat[M]]", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[OutputFormData["\<\
MatrixForm[{{a1111, a1112, a1211, a1212}, {a1121, \
a1122, a1221, a1222}, 
 
   {a2111, a2112, a2211, a2212}, {a2121, a2122, a2221, a2222}}]\
\>", \
"\<\
a1111   a1112   a1211   a1212

a1121   a1122   a1221   a1222

a2111   a2112   a2211   a2212

a2121   a2122   a2221   a2222\
\>"], "Output",
  ImageRegion->{{-0, 1}, {0, 1}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Random-orientation matrix definition", "Subsubsection",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
These are from my Nov'94 hydrodynamics program for the random \
orientation of a chain\
\>", "Text",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
Ax[w_]:={\t{1,0,0},
\t\t\t{0,Cos[w],Sin[w]},
\t\t\t{0,-Sin[w],Cos[w]}\t};
Ay[w_]:={\t{Cos[w],0,-Sin[w]},
\t\t\t{0,1,0},
\t\t\t{Sin[w],0,Cos[w]}\t};
Az[w_]:={\t{Cos[w],Sin[w],0},
\t\t\t{-Sin[w],Cos[w],0},
\t\t\t{0,0,1}\t};\
\>", "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
AO:=Az[Random[Real,N[{0,2 Pi}]]].Ax[Random[Real,N[{0,2 Pi}]]].
\tAz[Random[Real,N[{0,2 Pi}]]];
\t\t\t\t\t\t(*\tRandom overall orientation matrix *)\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
rotate[A_,o_]:=Module[{i,j,depth},
\t(*\tRoutine to rotate vectors even when they are assembled
\t\tinto groups and lists of those groups. Rotation matrix
\t\tis A, vector object is o *)
\tdepth=Depth[N[o]];
\tWhich[\tdepth==1,Print[\"Not done: \",depth];Return[o],
\t\t\tdepth==2,Return[N[A].o],
\t\t\tdepth==3,Return[Transpose[N[A].Transpose[o]]],
\t\t\tdepth==4,Return[Map[
\t\t\t\t\t\tTranspose[N[A].Transpose[#]] &,o ]
\t\t\t\t\t ],
\t\t\tdepth>=5,Print[\"Not done: \",depth];Return[o]
\t]
];\t\t\t\
\>", "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Higher level (automating) routines", "Subsubsection",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\

element[i_,j_,geo_]:=If[And[i<n+1,j<n+1],
\t\t\t\t\t\tIf[i==j,V[i,geo],dV[i,j,geo]],
\t\t\t\t\t\tIf[i<j,-Id[3],If[i==j,zero[3],Id[3]]]
\t\t\t\t\t];\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
ClearAll[hydro];
hydro[geo_]:=Module[{},
\t(*\tSet up and solve tableau AC.xc = yc for xc for a given
\t\trigid set of particles at positions p with radii s and
\t\tfor a given viscosity nu (here nu->1). 'geo' is a
\t\tstructurecontaining a list of coordinates and an
\t\tassociated list of hydrodynamic radii *)
\tn=Length[geo[[1]]];
\tIf[\ttest,
\t\tPrint[\"Hydrodynamics of an assembly of \",n,\" spheres\"];
\t\tPrint[\" {x,y,z}   radius\"];
\t\tPrint[MatrixForm[Transpose[geo]]]
\t];
\tA=Table[element[i,j,geo]/.nu->1,{i,n+1},{j,n+1}];
\tAA=flatmat[A];
\tAC=complete[AA,geo];
\txx=Join[Table[Map[#<>ToString[i] &,{\"fx\",\"fy\",\"fz\"}],{i,n}],
\t\t{{\"ux\",\"uy\",\"uz\",\"omega z\"}}];
\txc=flatvec[xx];\t
\tyy=Join[Table[{0,0,0},{n}],{0,0,1,0}];
\tyc=flatvec[yy];
\tIf[test,Print[\"Matrix is size: \",Dimensions[AC]]];
\tG=Inverse[AC];
\tdata=Append[data,G.yc];
\tIf[test,Return[MatrixForm[Transpose[{xc,G.yc}]]]]
];\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Show relationships between equivalent sphere radius and distance in \
\"lollipop\" geometry\
\>", "Subsubsection",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
Copy over the constants used for the equivalent sphere \
calculations.\
\>", "Text",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
el0=3.4;\t\t\t\t(* bp length, A *)
persistence=150 el0;\t(* persistence length, A *)
repeat0=10.4;\t\t\t(* helical repeat of free chain bp/turn *)\
\>", "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
NAvo=6.02 10^23;
ro=1.003;\t\t\t\t(* density, g/cm^3 *)
visc=0.01016;\t\t\t(* viscosity, g/(cm s) or \"Poise\" *)\
\>", "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
mbpa=660;\t\t\t\t(* basepair mol. weight, g/mole *)
rbpa=1.8294;\t\t\t(* basepair Stokes radius, A *)
vDNA=0.55;\t\t\t\t(* specific volume of DNA, cm^3/g *)
dDNA=27;\t\t\t\t(* Yamagawa-Fujii (YF) diam, A *)
switchbp=50;\t\t\t(* point at which we switch from YF
\t\t\t\t\t\t   to ellipsoid model, bp *)\
\>", "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
mbpa=660;\t\t\t\t(* basepair mol. weight, g/mole *)
rbpa=1.8294;\t\t\t(* basepair Stokes radius, A *)
vDNA=0.55;\t\t\t\t(* specific volume of DNA, cm^3/g *)
dDNA=27;\t\t\t\t(* Yamagawa-Fujii (YF) diam, A *)
switchbp=50;\t\t\t(* point at which we switch from YF
\t\t\t\t\t\t   to ellipsoid model, bp *)\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["findoffset", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["Stokes offset 3.00764 A at 50 bp", "Print",
  ImageRegion->{{-0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Plot[{rootr2[i/2],rbpb[i]},{i,0.1,10000},
\tPlotRange->{-5000,5000},
\tAxesLabel->{\"DNA\\nlength, bp\",\"\[CapitalARing]\"}];\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 9.52381e-05 0.309017 6.18034e-05 [
[(2000)] .21429 .30902 0 2 Msboxa
[(4000)] .40476 .30902 0 2 Msboxa
[(6000)] .59524 .30902 0 2 Msboxa
[(8000)] .78571 .30902 0 2 Msboxa
[(10000)] .97619 .30902 0 2 Msboxa
[(DNA)(length, bp)] 1.025 .30902 -1 0 Msboxa
[(-4000)] .01131 .0618 1 0 Msboxa
[(-2000)] .01131 .18541 1 0 Msboxa
[(2000)] .01131 .43262 1 0 Msboxa
[(4000)] .01131 .55623 1 0 Msboxa
[(\\201)] .02381 .61803 0 -4 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.21429 .30902 m
.21429 .31527 L
s
P
[(2000)] .21429 .30902 0 2 Mshowa
p
.002 w
.40476 .30902 m
.40476 .31527 L
s
P
[(4000)] .40476 .30902 0 2 Mshowa
p
.002 w
.59524 .30902 m
.59524 .31527 L
s
P
[(6000)] .59524 .30902 0 2 Mshowa
p
.002 w
.78571 .30902 m
.78571 .31527 L
s
P
[(8000)] .78571 .30902 0 2 Mshowa
p
.002 w
.97619 .30902 m
.97619 .31527 L
s
P
[(10000)] .97619 .30902 0 2 Mshowa
p
.001 w
.0619 .30902 m
.0619 .31277 L
s
P
p
.001 w
.1 .30902 m
.1 .31277 L
s
P
p
.001 w
.1381 .30902 m
.1381 .31277 L
s
P
p
.001 w
.17619 .30902 m
.17619 .31277 L
s
P
p
.001 w
.25238 .30902 m
.25238 .31277 L
s
P
p
.001 w
.29048 .30902 m
.29048 .31277 L
s
P
p
.001 w
.32857 .30902 m
.32857 .31277 L
s
P
p
.001 w
.36667 .30902 m
.36667 .31277 L
s
P
p
.001 w
.44286 .30902 m
.44286 .31277 L
s
P
p
.001 w
.48095 .30902 m
.48095 .31277 L
s
P
p
.001 w
.51905 .30902 m
.51905 .31277 L
s
P
p
.001 w
.55714 .30902 m
.55714 .31277 L
s
P
p
.001 w
.63333 .30902 m
.63333 .31277 L
s
P
p
.001 w
.67143 .30902 m
.67143 .31277 L
s
P
p
.001 w
.70952 .30902 m
.70952 .31277 L
s
P
p
.001 w
.74762 .30902 m
.74762 .31277 L
s
P
p
.001 w
.82381 .30902 m
.82381 .31277 L
s
P
p
.001 w
.8619 .30902 m
.8619 .31277 L
s
P
p
.001 w
.9 .30902 m
.9 .31277 L
s
P
p
.001 w
.9381 .30902 m
.9381 .31277 L
s
P
[(DNA)(length, bp)] 1.025 .30902 -1 0 Mshowa
p
.002 w
0 .30902 m
1 .30902 L
s
P
p
.002 w
.02381 .0618 m
.03006 .0618 L
s
P
[(-4000)] .01131 .0618 1 0 Mshowa
p
.002 w
.02381 .18541 m
.03006 .18541 L
s
P
[(-2000)] .01131 .18541 1 0 Mshowa
p
.002 w
.02381 .43262 m
.03006 .43262 L
s
P
[(2000)] .01131 .43262 1 0 Mshowa
p
.002 w
.02381 .55623 m
.03006 .55623 L
s
P
[(4000)] .01131 .55623 1 0 Mshowa
p
.001 w
.02381 .08652 m
.02756 .08652 L
s
P
p
.001 w
.02381 .11125 m
.02756 .11125 L
s
P
p
.001 w
.02381 .13597 m
.02756 .13597 L
s
P
p
.001 w
.02381 .16069 m
.02756 .16069 L
s
P
p
.001 w
.02381 .21013 m
.02756 .21013 L
s
P
p
.001 w
.02381 .23485 m
.02756 .23485 L
s
P
p
.001 w
.02381 .25957 m
.02756 .25957 L
s
P
p
.001 w
.02381 .2843 m
.02756 .2843 L
s
P
p
.001 w
.02381 .33374 m
.02756 .33374 L
s
P
p
.001 w
.02381 .35846 m
.02756 .35846 L
s
P
p
.001 w
.02381 .38318 m
.02756 .38318 L
s
P
p
.001 w
.02381 .4079 m
.02756 .4079 L
s
P
p
.001 w
.02381 .45735 m
.02756 .45735 L
s
P
p
.001 w
.02381 .48207 m
.02756 .48207 L
s
P
p
.001 w
.02381 .50679 m
.02756 .50679 L
s
P
p
.001 w
.02381 .53151 m
.02756 .53151 L
s
P
p
.001 w
.02381 .03708 m
.02756 .03708 L
s
P
p
.001 w
.02381 .01236 m
.02756 .01236 L
s
P
p
.001 w
.02381 .58095 m
.02756 .58095 L
s
P
p
.001 w
.02381 .60567 m
.02756 .60567 L
s
P
[(\\201)] .02381 .61803 0 -4 Mshowa
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
p
.004 w
.02382 .30903 m
.0635 .34464 L
.08334 .35801 L
.10318 .36949 L
.14287 .38854 L
.18255 .4042 L
.22223 .41771 L
.26191 .42973 L
.30159 .44067 L
.34128 .45076 L
.38096 .46018 L
.42064 .46905 L
.46032 .47745 L
.5 .48545 L
.53969 .49311 L
.57937 .50046 L
.61905 .50753 L
.65873 .51437 L
.69842 .52098 L
.7381 .52739 L
.77778 .53362 L
.81746 .53968 L
.85714 .54559 L
.89683 .55135 L
.93651 .55698 L
.97619 .56248 L
s
P
P
p
p
.004 w
.02382 .30974 m
.0635 .31814 L
.08334 .32124 L
.10318 .32403 L
.14287 .32899 L
.18255 .33344 L
.22223 .33767 L
.26191 .34196 L
.30159 .34662 L
.34128 .35202 L
.38096 .35872 L
.4008 .36281 L
.42064 .36761 L
.44048 .37337 L
.46032 .38044 L
.48016 .38936 L
.5 .40102 L
.51985 .41695 L
.52977 .42734 L
.53969 .44009 L
.54961 .45611 L
.55953 .47684 L
.56945 .50474 L
.57441 .52265 L
.57937 .5443 L
.58433 .571 L
.58929 .60477 L
s
.59078 .61803 m
.58929 .60477 L
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
.62743 .61803 m
.62744 0 L
s
s
.62744 0 m
.62743 .61803 L
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
.6613 0 m
.66369 .02205 L
s
.66369 .02205 m
.66865 .05684 L
.67857 .10644 L
.68353 .12473 L
.68849 .14008 L
.69842 .1644 L
.70834 .1828 L
.71826 .19721 L
.72818 .20879 L
.7381 .21831 L
.75794 .23301 L
.77778 .24384 L
.79762 .25214 L
.81746 .25871 L
.8373 .26403 L
.85714 .26842 L
.89683 .27525 L
.93651 .2803 L
.97619 .28419 L
s
P
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageRegion->{{-0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006W00011B000`400?l00000o`00003ooooooonX
ooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonX
ooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonX
ooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonX
ooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonX
ooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00<?ooool00ol0003ooooooooo
o`2Xooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0_oooool0033ooooo00?o0000
ooooooooool0Z?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo0;oooooo000`oooo
o`03o`000?oooooooooo0:Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`2ooooo
o`00<?ooool00ol0003oooooooooo`2Xooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool0_oooool0033ooooo0_l0002Yooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
_oooool0033ooooo00?o0000ooooooooool0Z?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo0;oooooo000`ooooo`03o`000?oooooooooo0:Sooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`2oooooo`00<?ooool00ol0003oooooooooo`2Xooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool0_oooool0033ooooo00?o0000ooooooooool0Z?ooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo0;oooooo000`ooooo`03o`000?oooooooooo0:Sooooo
00?o0000ooooooooool01oooool00ol0003oooooooooo`2oooooo`00<?ooool00ol0003ooooooooo
o`2Xooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0__ooool0033ooooo0_l0002Y
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0__ooool0033ooooo00?o0000oooo
ooooool0Z?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo0;kooooo000`ooooo`03
o`000?oooooooooo0:Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`2nooooo`00
<?ooool00ol0003oooooooooo`2Xooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
__ooool000gooooo0ol00005ooooo`04ofIVI_l0003o<S8bonk^kPGooooo00CoIVIVo`000?lb<S;o
k^k^1Oooool01?mVIVKo0000oc8b<_o^k^h5ooooo`03o`000?oooooooooo0:Sooooo00?o0000oooo
ooooool02Oooool00ol0003oooooooooo`2mooooo`003_ooool00ol0003oooooooooo`03ooooo`;o
QhN700?oooooohN7Qom4A4@01?ooool2ohN7Q`03oooooon7QhOoA4A400Cooooo0_n7QhL00ooooooo
QhN7odA4A005ooooo`03o`000?oooooooooo0:Sooooo00?o0000ooooooooool02Oooool00ol0003o
ooooooooo`2mooooo`002_ooool00olb<S;o0000o`000003o`0000Cooooo00Go<S8boooooooooooo
ooooo`000004ooooo`05oc8b<_ooooooooooooooool000001?ooool01Olb<S;ooooooooooooooooo
000000Gooooo00?o0000ooooooooool0Z?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooo
oooo0;gooooo00000ooooooo410@o`000004o`000005oa0@4?oooooooooooeEEEOmgMgL00_ooool0
0ol0003ogMgMooooo`03ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj0oooool01_lb<S;ooooo
oooooooooooo<S8bokZj^P?ooooo00Ko<S8boooooooooooooooooc8b<_nj^[X4ooooo`?o0000Z?oo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo0;gooooo000:ooooo`05onk^k_l0003o
gMgMooooool000001Oooool01_lb<S;ooooooooooooooooo<S8bokZj^P?ooooo00Ko<S8boooooooo
oooooooooc8b<_nj^[X3ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj1?ooool00ol0003ooooo
ooooo`2Xooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0_Oooool000_ooooo00Co
V9RHodA4A?oooooo00001Oooool01_lb<S;ooooooooooooooooo<S8bokZj^P?ooooo00Ko<S8boooo
oooooooooooooc8b<_nj^[X3ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj1?ooool00ol0003o
ooooooooo`2Xooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0_Oooool000cooooo
00?o<S8bokZj^_l000001Oooool01Olb<S;ok^k^ooooooo^k^ko000000Cooooo00Go<S8bonk^k_oo
ooook^k^o`000004ooooo`05oc8b<_o^k^koooooonk^k_l000001Oooool00ol0003oooooooooo`2X
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0_?ooool000cooooo00?oc<c<ob4Q
8Ol000001Oooool01On7QhOoIVIVoooooomVIVKoA4A400Cooooo00GoQhN7ofIVI_ooooooIVIVodA4
A004ooooo`05ohN7QomVIVKoooooofIVI_m4A4@01Oooool00ol0003oooooooooo`2Xooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool0_?ooool000gooooo00?oIVIVo`000?ooool01Ooo
ool01?mVIVKo0000oc8b<_o^k^h5ooooo`04ofIVI_l0003o<S8bonk^kPGooooo00CoIVIVo`000?lb
<S;ok^k^1Oooool00ol0003oooooooooo`2Xooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool0_?ooool0033ooooo00?o0000ooooooooool0Z?ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo0;cooooo000`ooooo`;o0000ZOooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo0;cooooo000`ooooo`03o`000?oooooooooo0:Sooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`2looooo`00<?ooool00ol0003oooooooooo`2Xooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool0_?ooool0033ooooo00?o0000ooooooooool0Z?ooool00ol0
003oooooooooo`0;ooooo`03o`000?oooooooooo0;_ooooo000`ooooo`03o`000?oooooooooo0:So
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`2kooooo`00<?ooool00ol0003ooooo
ooooo`2Xooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0^oooool0033ooooo00?o
0000ooooooooool0Z?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo0;_ooooo000`
ooooo`;o0000ZOooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo0;_ooooo000`oooo
o`03o`000?oooooooooo0:Sooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`2joooo
o`00<?ooool00ol0003oooooooooo`2Xooooo`03o`000?oooooooooo00cooooo00?o0000oooooooo
ool0^_ooool0033ooooo00?o0000ooooooooool0Z?ooool00ol0003oooooooooo`0<ooooo`03o`00
0?oooooooooo0;[ooooo000`ooooo`03o`000?oooooooooo0:Sooooo00?o0000ooooooooool03Ooo
ool00ol0003oooooooooo`2iooooo`00<?ooool00ol0003oooooooooo`2Xooooo`03o`000?oooooo
oooo00gooooo00?o0000ooooooooool0^Oooool0033ooooo00?o0000ooooooooool0Z?ooool00ol0
003oooooooooo`0=ooooo`03o`000?oooooooooo0;Wooooo000`ooooo`;o0000ZOooool00ol0003o
ooooooooo`0>ooooo`03o`000?oooooooooo0;Sooooo000`ooooo`03o`000?oooooooooo0:Sooooo
00?o0000ooooooooool03_ooool00ol0003oooooooooo`2hooooo`00<?ooool00ol0003ooooooooo
o`2Xooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool0^?ooool0033ooooo00?o0000
ooooooooool0Z?ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo0;Oooooo000`oooo
o`03o`000?oooooooooo0:Sooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`2goooo
o`00<?ooool00ol0003oooooooooo`2Xooooo`03o`000?oooooooooo013ooooo00?o0000oooooooo
ool0]_ooool0033ooooo00?o0000ooooooooool0Z?ooool00ol0003oooooooooo`0@ooooo`03o`00
0?oooooooooo0;Kooooo000`ooooo`;o0000ZOooool00ol0003oooooooooo`0@ooooo`03o`000?oo
oooooooo0;Kooooo000`ooooo`03o`000?oooooooooo0:Sooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`2eooooo`00<?ooool00ol0003oooooooooo`2Xooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool0]Oooool0033ooooo00?o0000ooooooooool0Z?ooool00ol0003o
ooooooooo`0Booooo`03o`000?oooooooooo0;Cooooo000:ooooo`03ohN7Qol0003o000000;o0000
00?o410@ooooooooool00oooool01?mVIVKo0000oc8b<_o^k^h5ooooo`04ofIVI_l0003o<S8bonk^
kPGooooo00CoIVIVo`000?lb<S;ok^k^1Oooool00ol0003oooooooooo`2Xooooo`03o`000?oooooo
oooo01?ooooo00?o0000ooooooooool0/oooool000[ooooo00?ok^k^oc8b<_o<c<`01oooool2ohN7
Q`03oooooon7QhOoA4A400Cooooo0_n7QhL00oooooooQhN7odA4A004ooooo`;oQhN700?oooooohN7
Qom4A4@01Oooool00ol0003oooooooooo`2Xooooo`03o`000?oooooooooo01?ooooo00?o0000oooo
ooooool0/oooool000_ooooo00?ok^k^oc8b<_nYZJT01_ooool01Olb<S;ooooooooooooooooo0000
00Cooooo00Go<S8booooooooooooooooo`000004ooooo`05oc8b<_ooooooooooooooool000001Ooo
ool00ol0003oooooooooo`2Xooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0/_oo
ool00003ooooool@413o000000Co000000?o410@ooooooooool00_ooool00oo^k^ko8B4QoiRHV005
ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj0oooool01_lb<S;ooooooooooooooooo<S8bokZj
^P?ooooo00Ko<S8boooooooooooooooooc8b<_nj^[X4ooooo`?o0000Z?ooool00ol0003ooooooooo
o`0Dooooo`03o`000?oooooooooo0;;ooooo000=ooooo`03onk^k_lb<S;oc<c<00Cooooo00Ko<S8b
oooooooooooooooooc8b<_nj^[X3ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj0oooool01_lb
<S;ooooooooooooooooo<S8bokZj^PCooooo00?o0000ooooooooool0Z?ooool00ol0003ooooooooo
o`0Eooooo`03o`000?oooooooooo0;7ooooo000>ooooo`03onk^k_m4A4Cooooo00?ooooo00Ko<S8b
oooooooooooooooooc8b<_nj^[X3ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj0oooool01_lb
<S;ooooooooooooooooo<S8bokZj^PCooooo00?o0000ooooooooool0Z?ooool00ol0003ooooooooo
o`0Fooooo`03o`000?oooooooooo0;3ooooo000;ooooo`05okZj^_oooooooooooooooolb<S801?oo
ool01Olb<S;ok^k^ooooooo^k^ko000000Cooooo00Go<S8bonk^k_ooooook^k^o`000004ooooo`05
oc8b<_o^k^koooooonk^k_l000001Oooool00ol0003oooooooooo`2Xooooo`03o`000?oooooooooo
01Oooooo00?o0000ooooooooool0[oooool000[ooooo00Koc<c<o`000?n7QhOooooookZj^_lQ8B44
ooooo`05ohN7QomVIVKoooooofIVI_m4A4@01?ooool01On7QhOoIVIVoooooomVIVKoA4A400Cooooo
00GoQhN7ofIVI_ooooooIVIVodA4A005ooooo`03o`000?oooooooooo0:Sooooo00?o0000oooooooo
ool05oooool00ol0003oooooooooo`2_ooooo`002oooool01OnYZJWo8B4Qo`000?l@413oc<c<00Go
oooo00CoIVIVo`000?lb<S;ok^k^1Oooool01?mVIVKo0000oc8b<_o^k^h5ooooo`04ofIVI_l0003o
<S8bonk^kPGooooo00?o0000ooooooooool0Z?ooool00ol0003oooooooooo`0Hooooo`03o`000?oo
oooooooo0:kooooo000`ooooo`03o`000?oooooooooo0:Sooooo00?o0000ooooooooool06?ooool0
0ol0003oooooooooo`2^ooooo`00<?ooool2o`000:Wooooo00?o0000ooooooooool06Oooool2o`00
0:kooooo000`ooooo`03o`000?oooooooooo0:Sooooo00?o0000ooooooooool06oooool00ol0003o
ooooooooo`2[ooooo`00<?ooool00ol0003oooooooooo`2Xooooo`03o`000?oooooooooo01cooooo
0_l0002[ooooo`00<?ooool00ol0003oooooooooo`2Xooooo`03o`000?oooooooooo01kooooo00?o
0000ooooooooool0Z?ooool0033ooooo00?o0000ooooooooool0Z?ooool00ol0003oooooooooo`0O
ooooo`;o0000Z?ooool0033ooooo00?o0000ooooooooool0Z?ooool00ol0003oooooooooo`0Qoooo
o`03o`000?oooooooooo0:Gooooo000`ooooo`03o`000?oooooooooo0:Sooooo00?o0000oooooooo
ool08_ooool2o`000:Gooooo000`ooooo`;o0000ZOooool00ol0003oooooooooo`0Tooooo`;o0000
Xoooool0033ooooo00?o0000ooooooooool0Z?ooool00ol0003oooooooooo`0Vooooo`;o0000XOoo
ool0033ooooo00?o0000ooooooooool0Z?ooool00ol0003oooooooooo`0Xooooo`;o0000Woooool0
033ooooo00?o0000ooooooooool08_ooool00on7QhOo0000o`000002o`000003oa0@4?oooooooooo
00?ooooo00CoIVIVo`000?lb<S;ok^k^1Oooool01?mVIVKo0000oc8b<_o^k^h5ooooo`04ofIVI_l0
003o<S8bonk^kQSooooo0ol00005ooooo`04ofIVI_l0003o<S8bonk^kPGooooo00CoIVIVo`000?lb
<S;ok^k^1Oooool01?mVIVKo0000oc8b<_o^k^hGooooo`04ofIVI_l0003o410@olc<c0Gooooo00Co
IVIVo`000?lb<S;ok^k^1Oooool01?mVIVKo0000oc8b<_o^k^h2ooooo`07o`000?ooooooooooofIV
I_l0003o<S8bonk^kP0Fooooo`05olc<c?lb<S;o0000oa0@4?nYZJT01Oooool01?mVIVKo0000oc8b
<_o^k^h2ooooo`;o000000GoooooofIVI_l0003o<S8bonk^kP05ooooo`04ofIVI_l0003o<S8bonk^
kQ7ooooo00?o410@o`000?l000000_l000000ooMgMgoooooooooo`02ooooo`04ofIVI_l0003o<S8b
onk^kPGooooo00CoIVIVo`000?lb<S;ok^k^1Oooool01?mVIVKo0000oc8b<_o^k^h5ooooo`04ofIV
I_l0003o<S8bonk^kUGooooo000`ooooo`03o`000?oooooooooo02;ooooo00?ok^k^oc8b<_o<c<`0
1oooool2ohN7Q`03oooooon7QhOoA4A400Cooooo0_n7QhL00oooooooQhN7odA4A004ooooo`;oQhN7
00?oooooohN7Qom4A4@06Oooool00ol0003oooooooooo`03ooooo`;oQhN700?oooooohN7Qom4A4@0
1?ooool2ohN7Q`03oooooon7QhOoA4A400Cooooo0_n7QhL00oooooooQhN7odA4A00Fooooo`05ogMg
MonYZJWoooooolc<c?l000001?ooool2ohN7Q`03oooooon7QhOoA4A400Cooooo0_n7QhL00ooooooo
QhN7odA4A002ooooo`07o`000?ooooooQhN7ohN7QoooooooQhN7odA4A00Fooooo`06oc8b<_nYZJWo
oooookZj^_l0003ok^k^0oooool2ohN7Q`03oooooon7QhOoA4A400Cooooo00Go0000ohN7Qooooooo
QhN7odA4A004ooooo`;oQhN700?oooooohN7Qom4A4@04oooool00ol0003oooooooooo`04ooooo`;o
QhN700?oooooohN7Qom4A4@01?ooool2ohN7Q`03oooooon7QhOoA4A400Cooooo0_n7QhL00ooooooo
QhN7odA4A004ooooo`;oQhN700?oooooohN7Qom4A4@0EOooool0033ooooo00?o0000ooooooooool0
8oooool00oo^k^ko<S8bojVYZ@06ooooo`05oc8b<_ooooooooooooooool000001?ooool01Olb<S;o
oooooooooooooooo000000Cooooo00Go<S8booooooooooooooooo`00000Eooooo`03oc8b<_l0003o
000000?o00001?ooool01Olb<S;ooooooooooooooooo000000Cooooo00Go<S8boooooooooooooooo
o`000004ooooo`05oc8b<_ooooooooooooooool000005_ooool01_m4A4Cooooooooooooooooo<S8b
okZj^P?ooooo00Go<S8booooooooooooooooo`000004ooooo`05oc8b<_ooooooooooooooool00000
0_ooool00ol0003ooooooc8b<P03ooooo`03o`000?oooooooooo01Cooooo00Ko0000oooooooooooo
ooooo`000?nj^[X3ooooo`05oc8b<_ooooooooooooooool000001?ooool00olb<S;o0000o`000002
o`0000Cooooo00Go<S8booooooooooooooooo`00000Cooooo`03o`000?oooooooooo00Cooooo00Go
<S8booooooooooooooooo`000004ooooo`05oc8b<_ooooooooooooooool000001?ooool01Olb<S;o
oooooooooooooooo000000Cooooo00Go<S8booooooooooooooooo`00001Eooooo`00<?ooool00ol0
003oooooooooo`0Tooooo`03onk^k_lQ8B7oV9RH00Gooooo00Ko<S8boooooooooooooooooc8b<_nj
^[X3ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj0oooool01_lb<S;ooooooooooooooooo<S8b
okZj^QCooooo00KoEEEEogMgMoooooooooooo`000?oMgMd4ooooo`06oc8b<_oooooooooooooooolb
<S;o^[Zj0oooool01_lb<S;ooooooooooooooooo<S8bokZj^P?ooooo00Ko<S8boooooooooooooooo
oc8b<_nj^[XEooooo`06ob4Q8OoooooooooooooooolQ8B7o^[Zj0oooool01_lb<S;ooooooooooooo
oooo<S8bokZj^P?ooooo00[o<S8boooooooooooooooooc8b<_nj^[[oooooo`000?oooooo<S8b0ooo
ool00olb<S;o^[Zjooooo`0Dooooo`06oc8b<_nHV9SoooooohN7Qol0003ok^k^0oooool01_lb<S;o
oooooooooooooooo<S8bokZj^P?ooooo00Co<S8boooooooooooooooo0ol00002ooooo`06oc8b<_oo
oooooooooooooolb<S;o^[Zj4_ooool00ol0003oooooooooo`04ooooo`06oc8b<_oooooooooooooo
oolb<S;o^[Zj0oooool01_lb<S;ooooooooooooooooo<S8bokZj^P?ooooo00Ko<S8boooooooooooo
oooooc8b<_nj^[X3ooooo`06oc8b<_oooooooooooooooolb<S;o^[ZjE?ooool0033ooooo0_l0000V
ooooo`03onk^k_lb<S;oc<c<00Cooooo00Ko<S8boooooooooooooooooc8b<_nj^[X3ooooo`06oc8b
<_oooooooooooooooolb<S;o^[Zj0oooool01_lb<S;ooooooooooooooooo<S8bokZj^QCooooo00Go
k^k^o`000?oMgMgoooooo`000005ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj0oooool01_lb
<S;ooooooooooooooooo<S8bokZj^P?ooooo00Ko<S8boooooooooooooooooc8b<_nj^[XEooooo`05
o`000?nHV9SooooooiRHV?l@41001?ooool01_lb<S;ooooooooooooooooo<S8bokZj^P?ooooo00[o
<S8boooooooooooooooooc8b<_nj^[[oooooo`000?oooooo<S8b0oooool00olb<S;o^[Zjooooo`0D
ooooo`05onk^k_l0003o0000o`000?nj^[X01?ooool01_lb<S;ooooooooooooooooo<S8bokZj^P?o
oooo00Oo<S8boooooooooooooooooc8b<_nj^[[ooooo00Co00000_ooool00olb<S;o^[Zjooooo`0A
ooooo`03o`000?oooooooooo00Cooooo00Ko<S8boooooooooooooooooc8b<_nj^[X3ooooo`06oc8b
<_oooooooooooooooolb<S;o^[Zj0oooool01_lb<S;ooooooooooooooooo<S8bokZj^P?ooooo00Ko
<S8boooooooooooooooooc8b<_nj^[XFooooo`05oeEEEOl0003o0000odA4A?o^k^h0<?ooool3o`00
0003oc8b<_oooooooooo00?ooooo000`ooooo`03o`000?oooooooooo02Kooooo00?ok^k^odA4A?oo
ool00oooool01_lb<S;ooooooooooooooooo<S8bokZj^P?ooooo00Ko<S8boooooooooooooooooc8b
<_nj^[X3ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj5Oooool01?nHV9SoA4A4ooooool00005
ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj0oooool01_lb<S;ooooooooooooooooo<S8bokZj
^P?ooooo00Ko<S8boooooooooooooooooc8b<_nj^[XEooooo`05odA4A?lb<S;o0000ob4Q8Oo<c<`0
1?ooool01_lb<S;ooooooooooooooooo<S8bokZj^P?ooooo00[o<S8boooooooooooooooooc8b<_nj
^[[oooooo`000?oooooo<S8b0oooool00olb<S;o^[Zjooooo`0Dooooo`05ofIVI_nHV9SooooooiRH
V?m4A4@01?ooool01_lb<S;ooooooooooooooooo<S8bokZj^P?ooooo00Ko<S8boooooooooooooooo
oc8b<_nj^[X3ooooo`03oc8b<_oooooo000000Co00004Oooool00ol0003oooooooooo`04ooooo`06
oc8b<_oooooooooooooooolb<S;o^[Zj0oooool01_lb<S;ooooooooooooooooo<S8bokZj^P?ooooo
00Ko<S8boooooooooooooooooc8b<_nj^[X3ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj6Ooo
ool00on7QhOo<S8booooo`0Eooooo`03olc<c?l0003ok^k^01Oooooo00?o^[Zjo`000?ooool01_oo
ool0033ooooo00?o0000ooooooooool08oooool01Onj^[[ooooooooooooooooo<S8b00Cooooo00Go
<S8bonk^k_ooooook^k^o`000004ooooo`05oc8b<_o^k^koooooonk^k_l000001?ooool01Olb<S;o
k^k^ooooooo^k^ko000001Oooooo00?o<S8bokZj^_l000001Oooool01Olb<S;ok^k^ooooooo^k^ko
000000Cooooo00Go<S8bonk^k_ooooook^k^o`000004ooooo`05oc8b<_o^k^koooooonk^k_l00000
5_ooool00omgMgOoc<c<ooooo`06ooooo`05oc8b<_o^k^koooooonk^k_l000001?ooool01Olb<S;o
k^k^ooooooo^k^ko000000;ooooo00Oo0000oooooolb<S;ok^k^ooooooo^k^ko000001Kooooo00Go
8B4Qooooooooooooooooob4Q8@04ooooo`05oc8b<_o^k^koooooonk^k_l000001?ooool01Olb<S;o
k^k^ooooooo^k^ko000000Cooooo00Go<S8bonk^k_ooooook^k^o`000002ooooo`Ko00002oooool0
0ol0003oooooooooo`04ooooo`05oc8b<_o^k^koooooonk^k_l000001?ooool01Olb<S;ok^k^oooo
ooo^k^ko000000Cooooo00Go<S8bonk^k_ooooook^k^o`000004ooooo`05oc8b<_o^k^koooooonk^
k_l000006oooool00ol0003oooooooooo`0Dooooo`03onk^k_l0003oEEEE01Oooooo00?o^[Zjo`00
0?ooool01_ooool0033ooooo00?o0000ooooooooool08_ooool01_o<c<co0000ohN7Qooooooo^[Zj
ob4Q8@Cooooo00GoQhN7ofIVI_ooooooIVIVodA4A004ooooo`05ohN7QomVIVKoooooofIVI_m4A4@0
1?ooool01On7QhOoIVIVoooooomVIVKoA4A401Oooooo00?oc<c<ob4Q8Ol000001Oooool01On7QhOo
IVIVoooooomVIVKoA4A400Cooooo00GoQhN7ofIVI_ooooooIVIVodA4A004ooooo`05ohN7QomVIVKo
ooooofIVI_m4A4@05_ooool01?o^k^ko410@oiRHV?o^k^h5ooooo`05ohN7QomVIVKoooooofIVI_m4
A4@01?ooool01On7QhOoIVIVoooooomVIVKoA4A400;ooooo00Oo0000oooooon7QhOoIVIVoooooomV
IVKoA4A401Kooooo00Go8B4Qooooooooooooooooob4Q8@04ooooo`05ohN7QomVIVKoooooofIVI_m4
A4@01?ooool01On7QhOoIVIVoooooomVIVKoA4A400Cooooo00GoQhN7ofIVI_ooooooIVIVodA4A008
ooooo`Go00001?ooool00on7QhOo^[Zjo`000006ooooo`05ohN7QomVIVKoooooofIVI_m4A4@01?oo
ool01On7QhOoIVIVoooooomVIVKoA4A400Cooooo00GoQhN7ofIVI_ooooooIVIVodA4A004ooooo`03
o`P82?l0003o000000?o000000Go<S8booooooooooooooooofIVIP03o`000005odA4A?nHV9Sooooo
ooooool@41000_l000001?oooooo0000o`000?l@4103ooooo`05ofIVI_l0003o0000ofIVI_l00000
1Oooool02?nHV9So410@o`000?l@413oEEEEolc<c?oooooo410@0_l000001?oooooo0000o`000?l@
4104ooooo`03odA4A?l0003o^[Zj00gooooo00?o410@o`000?mVIVH00_l000001omgMgOooooooooo
oooooooo^[Zjo`000?nHV9P00_l000000omVIVKoooooooooo`01ooooo`00<?ooool00ol0003ooooo
ooooo`0Sooooo`05ojVYZOlQ8B7o0000oa0@4?o<c<`01Oooool01?mVIVKo0000oc8b<_o^k^h5oooo
o`04ofIVI_l0003o<S8bonk^kPGooooo00CoIVIVo`000?lb<S;ok^k^6?ooool00omVIVKo0000oooo
o`05ooooo`04ofIVI_l0003o<S8bonk^kPGooooo00CoIVIVo`000?lb<S;ok^k^1Oooool01?mVIVKo
0000oc8b<_o^k^hGooooo`05omgMgOm4A4Co0000o`000?oMgMd01?ooool01?mVIVKo0000oc8b<_o^
k^h5ooooo`04ofIVI_l0003o<S8bonk^kP;ooooo00Oo0000ooooooooooooIVIVo`000?lb<S;ok^k^
01Kooooo00GoA4A4oiRHV?ooooooV9RHodA4A005ooooo`04ofIVI_l0003o<S8bonk^kPGooooo00Co
IVIVo`000?lb<S;ok^k^1Oooool01?mVIVKo0000oc8b<_o^k^h=ooooo`Oo00001oooool01?mVIVKo
0000oc8b<_o^k^h5ooooo`04ofIVI_l0003o<S8bonk^kPGooooo00CoIVIVo`000?lb<S;ok^k^1Ooo
ool01?mVIVKo0000o`000?o^k^h4ooooo`07ogMgMomEEEGok^k^ooooooo^k^koV9RHoc8b<P03oooo
o`05o`000?ooooooooooooooool000000oooool01_mgMgOoEEEEonk^k_oMgMgo8B4Qo`0000Gooooo
00Ko0000olc<c?oooooogMgMohN7QonYZJT2ooooo`05o`000?ooooooooooooooool000001Oooool0
0onHV9So0000oc8b<P0>ooooo`04o`000?m4A4Cok^k^ooooo`;oMgMg0_ooool00onj^[[o0000ogMg
M`02ooooo`;oMgMg0_ooool0033ooooo00?o0000ooooooooool0Z?ooool00ol0003oooooooooo`0J
ooooo`05onk^k_lb<S;o0000oc8b<_o^k^h0;_ooool5o`00023ooooo00?o0000ooooooooool00ooo
ool00ol0003ok^k^ooooo`07ooooo`05o`000?ooooooooooooooool000000oooool01_lQ8B7ooooo
ooooooooooooc<c<o`0000Gooooo00?o0000ooooooooool01Oooool01Ol0003ooooooooooooooooo
000001Kooooo00?o0000omgMgOooool00_ooool01Olb<S;ooooooooooonj^[[o410@00Cooooo0OlQ
8B41ooooo`7ooooo000`ooooo`03o`000?oooooooooo0:Sooooo00?o0000ooooooooool0D_ooool9
o`0001Oooooo00?o0000ooooooooool00oooool7o`000004omgMgOooooooooooo`0000?ooooo00Go
0000oooooooooooooooooc8b<P04ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
1Oooool01Ol0003ooooooooooooooooo000001Kooooo00?o0000ooooooooool00_ooool01Olb<S;o
oooooooooonj^[[o<S8b00Cooooo0Olb<S81ooooo`7ooooo000`ooooo`;o0000ZOooool00ol0003o
ooooooooo`1Kooooo`Ko00004Oooool00ol0003oooooooooo`03ooooo`03oa0@4?oMgMgooooo00;o
oooo00?oV9RHo`000?ooool00_ooool01Ol0003ooooooooooooooooo000000?ooooo00Ko<S8boooo
ooooooooooooomgMgOl00005ooooo`03o`000?oooooooooo00Gooooo00Go0000oooooooooooooooo
o`00000Fooooo`03o`000?oMgMgooooo00;ooooo00Ko<S8boooooooooooo^[Zjo`000?o^k^h2oooo
o`03onk^k_lQ8B7ooooo007ooooo000`ooooo`03o`000?oooooooooo0:Sooooo00?o0000oooooooo
ool0L_ooool00ol0003oooooooooo`03ooooo`07ogMgMolQ8B7ogMgMoooooooMgMgo410@ofIVIP03
ooooo`05o`000?n7QhOooooookZj^_l@41000oooool2ogMgM`04ooooooo^k^koA4A4o`0000?ooooo
00?o410@o`000?l000000ol000002OmgMgOooooooooooooooooo0000ohN7Qooooooo^[Zjoa0@400F
ooooo`04o`000?m4A4Cok^k^ooooo`;oMgMg0_ooool00onj^[[o0000odA4A002omgMg@03odA4A?mg
MgOooooo007ooooo000`ooooo`03o`000?oooooooooo0:Sooooo00?o0000ooooooooool0L_ooool0
0ol0003oooooooooo`04ooooo`05ogMgMol@413o0000oa0@4?mgMgL00oooool2o`000004ofIVI_l0
003o0000okZj^PCooooo00KoIVIVo`000?l0003oEEEEo`000?lb<S84ooooo`03oc8b<_oooooooooo
00Gooooo00Go0000ogMgMol0003o0000okZj^P0Fooooo`05o`000?mVIVKo0000o`000?mVIVH00ooo
ool00ol@413o0000ogMgM`02o`000003ofIVI_oooooooooo007ooooo000`ooooo`03o`000?oooooo
oooo0:Sooooo00?o0000ooooooooool0L_ooool00ol0003oooooooooo`0Pooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0>ooooo`00<?ooool00ol0
003oooooooooo`2Xooooo`03o`000?oooooooooo07;ooooo00?o0000ooooooooool08?ooool00ol@
413oooooooooo`05ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool03_ooool0033o
oooo00?o0000ooooooooool0Z?ooool00ol0003oooooooooo`1`ooooo`03oa0@4?l0003o000002Wo
oooo00?o410@o`000?ooool06?ooool00ol@413o0000ooooo`0?ooooo`00<?ooool00ol0003ooooo
ooooo`2Xooooo`03o`000?oooooooooo0<Wooooo000Yoooooooo00007Ol0001Rooooo`00<?ooool0
1?l0003oooooo`000?ooool5o`0000;ooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooool000002Oooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0I_ooool0033ooooo00Co0000
oooooooooooo00001Oooool6o`0002Oooooo00?o0000ooooooooool0<oooool00ol0003ooooooooo
o`0cooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0:_ooool00ol0003ooooooooo
o`0cooooo`03o`000?oooooooooo06Kooooo000`ooooo`05o`000?ooooooooooooooool000002_oo
ool6o`0009Kooooo00?o0000ooooooooool0bOooool0033ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`0=ooooo`Ko0000T?ooool00ol0003oooooooooo`39ooooo`00<?ooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo01;ooooo1Ol0002;ooooo`03o`000?oooooooooo
0<Wooooo000`ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool05_ooool9o`0008;o
oooo00?o0000ooooooooool0L?ooool3o`000003oa0@4?nHV9Sooooo00;ooooo0ol00002ooooo`04
ofIVI_l0003ooooooa0@40;o000000CoEEEEooooooooooooEEEE0ol000000ooMgMgoooooooooo`0l
ooooo`00<?ooool2o`0000Kooooo00?o0000ooooooooool07_ooool;o`0007Oooooo00?o0000oooo
ooooool0L?ooool01_l0003ooooooooooonj^[[o8B4QokZj^P;ooooo00Go0000oooooooooooooooo
okZj^P02o`0000;ooooo00?o410@ojVYZOooool00oooool00onj^[[o0000omgMg@0oooooo`00<?oo
ool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo02Sooooo2ol0001/ooooo`03o`000?oo
oooooooo073ooooo00Ko0000ooooooooooooooooomgMgOm4A4@2ooooo`07o`000?ooooooooooonk^
k_l@413oA4A4o`000002ooooo`03ogMgMom4A4Cooooo00?ooooo0_mEEEE0ooooo`00<?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo03;ooooo2?l0001Tooooo`03o`000?oooooooooo
073ooooo00?o0000ooooooooool00_ooool01?lb<S;oooooooooool00002ooooo`04oeEEEOl0003o
k^k^o`0000;ooooo00?ogMgMo`000?l000001?l000000ooMgMgoooooooooo`0nooooo`00<?ooool0
0ol0003oooooooooo`08ooooo`;o0000>_ooool6o`0005kooooo00?o0000ooooooooool0L?ooool0
0ol0003oooooooooo`02ooooo`0:oc8b<_ooooooooooo`000?ooooooZJVYo`000?nYZJWoooooo`00
00?ooooo00Ko<S8boiRHV?ooooooooooogMgMolb<S91ooooo`00<?ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo03gooooo2Ol0001Eooooo`03o`000?oooooooooo073ooooo00?o0000
ooooooooool00_ooool01olQ8B7oooooooooool0003ok^k^o`000?m4A4@00_ooool01_l0003ooooo
ooooooooooooV9RHoa0@40;ooooo00?o410@okZj^_ooool0@?ooool0033ooooo00?o0000oooooooo
ool02oooool2o`0004Kooooo2?l0001=ooooo`03o`000?oooooooooo073ooooo00Ko0000oooooooo
ooooooooomgMgOm4A4@2ooooo`04o`000?m4A4Co0000omgMg@;ooooo00Ko0000oooooooooooooooo
onk^k_l00002oiRHV003oa0@4?oooooooooo043ooooo000`ooooo`03o`000?oooooooooo00gooooo
00?o0000ooooooooool0Boooool5o`0004Sooooo00?o0000ooooooooool0L?ooool01_l0003ooooo
oooooooMgMgo8B4QojVYZ@;ooooo0_l000001On7QhOooooooooooooooooo000000Cooooo00CoEEEE
oa0@4?l@413oV9RH@_ooool0033ooooo0_l0000?ooooo`;o0000D?ooool6o`0004;ooooo00?o0000
ooooooooool0L?ooool4o`000003ohN7QooooooogMgM00;o000000?o<S8booooooooool00ol00002
ooooo`05okZj^_l0003o0000o`000?l@4100@oooool0033ooooo00?o0000ooooooooool04?ooool2
o`0005Cooooo1_l0000looooo`03o`000?oooooooooo0<Wooooo000`ooooo`03o`000?oooooooooo
01;ooooo0_l0001Hooooo`Co0000>?ooool00ol0003oooooooooo`39ooooo`00<?ooool00ol0003o
ooooooooo`0Dooooo`;o0000F_ooool3o`0003Gooooo00?o0000ooooooooool0bOooool0033ooooo
00?o0000ooooooooool05_ooool2o`0005_ooooo0ol0000booooo`03o`000?oooooooooo0<Wooooo
000`ooooo`03o`000?oooooooooo01Sooooo0ol0001Kooooo`?o0000;oooool00ol0003ooooooooo
o`39ooooo`00<?ooool00ol0003oooooooooo`0Kooooo`;o0000G?ooool2o`0002gooooo00?o0000
ooooooooool0bOooool0033ooooo0_l0000Nooooo`;o0000G?ooool2o`0002_ooooo00?o0000oooo
ooooool0bOooool0033ooooo00?o0000ooooooooool07oooool2o`0005cooooo00?o0000oooooooo
ool0:?ooool00ol0003oooooooooo`39ooooo`00<?ooool00ol0003oooooooooo`0Qooooo`;o0000
Foooool2o`0002Sooooo00?o0000ooooooooool0bOooool0033ooooo00?o0000ooooooooool08ooo
ool3o`0005[ooooo0_l0000Vooooo`03o`000?oooooooooo0<Wooooo000`ooooo`03o`000?oooooo
oooo02Kooooo0_l0001Jooooo`;o00009?ooool00ol0003oooooooooo`39ooooo`00<?ooool00ol0
003oooooooooo`0Xooooo`;o0000F_ooool2o`0002;ooooo00?o0000ooooooooool0bOooool0033o
oooo00?o0000ooooooooool0:_ooool2o`0005[ooooo00?o0000ooooooooool07oooool00ol0003o
ooooooooo`39ooooo`00<?ooool2o`0002gooooo0ol0001Hooooo`03o`000?oooooooooo01kooooo
00?o0000ooooooooool0bOooool0033ooooo00?o0000ooooooooool0;oooool3o`0005Kooooo00?o
0000ooooooooool07Oooool00ol0003oooooooooo`39ooooo`00<?ooool00ol0003oooooooooo`0b
ooooo`?o0000E?ooool00ol0003oooooooooo`0Looooo`03o`000?oooooooooo0<Wooooo000`oooo
o`03o`000?oooooooooo03Gooooo0ol0001Booooo`03o`000?oooooooooo01_ooooo00?o0000oooo
ooooool0bOooool000[ooooo00?oQhN7o`000?l000000_l000000ol@413oooooooooo`03ooooo`04
ofIVI_l0003o<S8bonk^kPGooooo00CoIVIVo`000?lb<S;ok^k^1Oooool01?mVIVKo0000oc8b<_o^
k^h5ooooo`03o`000?oooooooooo03Sooooo1?l0001?ooooo`03o`000?oooooooooo01[ooooo00?o
0000ooooooooool0bOooool000[ooooo00?ok^k^oc8b<_o<c<`01oooool2ohN7Q`03oooooon7QhOo
A4A400Cooooo0_n7QhL00oooooooQhN7odA4A004ooooo`;oQhN700?oooooohN7Qom4A4@01Oooool0
0ol0003oooooooooo`0looooo`?o0000COooool00ol0003oooooooooo`0Iooooo`03o`000?oooooo
oooo0<Wooooo000;ooooo`03onk^k_lb<S;oZJVY00Kooooo00Go<S8booooooooooooooooo`000004
ooooo`05oc8b<_ooooooooooooooool000001?ooool01Olb<S;ooooooooooooooooo000000Gooooo
00?o0000ooooooooool0?oooool4o`0004Wooooo00?o0000ooooooooool06Oooool00ol0003ooooo
ooooo`39ooooo`003?ooool00oo^k^ko8B4QoiRHV005ooooo`06oc8b<_oooooooooooooooolb<S;o
^[Zj0oooool01_lb<S;ooooooooooooooooo<S8bokZj^P?ooooo00Ko<S8boooooooooooooooooc8b
<_nj^[X4ooooo`?o0000@oooool4o`0004Kooooo00?o0000ooooooooool06?ooool00ol0003ooooo
ooooo`39ooooo`003Oooool00oo^k^ko<S8bolc<c004ooooo`06oc8b<_oooooooooooooooolb<S;o
^[Zj0oooool01_lb<S;ooooooooooooooooo<S8bokZj^P?ooooo00Ko<S8boooooooooooooooooc8b
<_nj^[X4ooooo`03o`000?oooooooooo04Oooooo1?l00013ooooo`03o`000?oooooooooo01Oooooo
00?o0000ooooooooool0bOooool000kooooo00?ok^k^odA4A?ooool00oooool01_lb<S;ooooooooo
oooooooo<S8bokZj^P?ooooo00Ko<S8boooooooooooooooooc8b<_nj^[X3ooooo`06oc8b<_oooooo
oooooooooolb<S;o^[Zj1?ooool00ol0003oooooooooo`1;ooooo`Co0000@?ooool00ol0003ooooo
ooooo`0Fooooo`03o`000?oooooooooo0<Wooooo000;ooooo`05okZj^_oooooooooooooooolb<S80
1?ooool01Olb<S;ok^k^ooooooo^k^ko000000Cooooo00Go<S8bonk^k_ooooook^k^o`000004oooo
o`05oc8b<_o^k^koooooonk^k_l000001Oooool00ol0003oooooooooo`1?ooooo`Co0000??ooool0
0ol0003oooooooooo`0Fooooo`03o`000?oooooooooo0<Wooooo000:ooooo`06olc<c?l0003oQhN7
oooooonj^[[o8B4Q1?ooool01On7QhOoIVIVoooooomVIVKoA4A400Cooooo00GoQhN7ofIVI_oooooo
IVIVodA4A004ooooo`05ohN7QomVIVKoooooofIVI_m4A4@01Oooool00ol0003oooooooooo`1Coooo
o`?o0000>_ooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo0<Wooooo000;ooooo`05
ojVYZOlQ8B7o0000oa0@4?o<c<`01Oooool01?mVIVKo0000oc8b<_o^k^h5ooooo`04ofIVI_l0003o
<S8bonk^kPGooooo00CoIVIVo`000?lb<S;ok^k^1Oooool00ol0003oooooooooo`1Fooooo`Co0000
=oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo0<Wooooo000`ooooo`03o`000?oo
oooooooo05[ooooo1?l0000cooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0bOoo
ool0033ooooo0_l0001Oooooo`?o0000<Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooo
oooo0<Wooooo000`ooooo`03o`000?oooooooooo067ooooo1Ol0000/ooooo`03o`000?oooooooooo
01?ooooo00?o0000ooooooooool0bOooool0033ooooo00?o0000ooooooooool0I_ooool5o`0002So
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`39ooooo`00<?ooool00ol0003ooooo
ooooo`1[ooooo`Go00009?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo0<Wooooo
000`ooooo`03o`000?oooooooooo073ooooo1?l0000Pooooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool0bOooool0033ooooo00?o0000ooooooooool0M?ooool4o`0001gooooo00?o0000
ooooooooool04?ooool00ol0003oooooooooo`39ooooo`00<?ooool00ol0003oooooooooo`1hoooo
o`Go00006?ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo0<Wooooo000`ooooo`;o
0000O_ooool5o`0001Cooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`39ooooo`00
<?ooool00ol0003oooooooooo`22ooooo`Ko00003_ooool00ol0003oooooooooo`0?ooooo`03o`00
0?oooooooooo0<Wooooo000`ooooo`03o`000?oooooooooo08Sooooo1Ol00009ooooo`03o`000?oo
oooooooo00oooooo00?o0000ooooooooool0bOooool0033ooooo00?o0000ooooooooool0SOooool6
o`0000Cooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`39ooooo`00<?ooool00ol0
003oooooooooo`2Cooooo`Go00004?ooool00ol0003oooooooooo`39ooooo`00<?ooool00ol0003o
ooooooooo`2Gooooo`Oo00002_ooool00ol0003oooooooooo`39ooooo`00<?ooool00ol0003ooooo
ooooo`2Hooooo`03o`000?oooooooooo00?ooooo1_l00004ooooo`03o`000?oooooooooo0<Wooooo
000`ooooo`;o0000VOooool00ol0003oooooooooo`09ooooo`Ko0000b_ooool0033ooooo00?o0000
ooooooooool0V?ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooo000000Co0000aOooool0
033ooooo00?o0000ooooooooool0VOooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo
00Cooooo1_l0002oooooo`00<?ooool00ol0003oooooooooo`2Iooooo`03o`000?oooooooooo00co
oooo00?o0000ooooooooool02_ooool5o`000;[ooooo000`ooooo`03o`000?oooooooooo09Wooooo
00?o0000ooooooooool03?ooool00ol0003oooooooooo`0?ooooo`Ko0000]?ooool0033ooooo00?o
0000ooooooooool0VOooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo01Gooooo1Ol0
002_ooooo`00<?ooool00ol0003oooooooooo`2Iooooo`03o`000?oooooooooo00cooooo00?o0000
ooooooooool06_ooool9o`000:Kooooo000`ooooo`;o0000V_ooool00ol0003oooooooooo`0<oooo
o`03o`000?oooooooooo02?ooooo2Ol0002Mooooo`00<?ooool00ol0003oooooooooo`2Jooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool0;?ooool5o`0009Sooooo000`ooooo`03o`00
0?oooooooooo09[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0aooooo`Ko0000
T_ooool0033ooooo00?o0000ooooooooool0V_ooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo03Oooooo1Ol0002=ooooo`003Oooool3o`0000Gooooo00CoIVIVo`000?lb<S;ok^k^1Ooo
ool01?mVIVKo0000oc8b<_o^k^h5ooooo`04ofIVI_l0003o<S8bonk^kPGooooo00?o0000oooooooo
ool0V_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo03cooooo2Ol00024ooooo`00
3_ooool00ol0003oooooooooo`03ooooo`;oQhN700?oooooohN7Qom4A4@01?ooool2ohN7Q`03oooo
oon7QhOoA4A400Cooooo0_n7QhL00oooooooQhN7odA4A005ooooo`03o`000?oooooooooo09[ooooo
00?o0000ooooooooool02oooool00ol0003oooooooooo`15ooooo`So0000O?ooool000[ooooo00?o
<S8bo`000?l000000ol00004ooooo`05oc8b<_ooooooooooooooool000001?ooool01Olb<S;ooooo
oooooooooooo000000Cooooo00Go<S8booooooooooooooooo`000005ooooo`03o`000?oooooooooo
09[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`1=ooooo`Go0000Moooool000[o
oooo00KoEEEEogMgMoooooooooooo`000?oMgMd4ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj
0oooool01_lb<S;ooooooooooooooooo<S8bokZj^P?ooooo00Ko<S8boooooooooooooooooc8b<_nj
^[X4ooooo`?o0000Voooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo05;ooooo1_l0
001aooooo`002_ooool01Oo^k^ko0000omgMgOoooooo000000Gooooo00Ko<S8boooooooooooooooo
oc8b<_nj^[X3ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj0oooool01_lb<S;ooooooooooooo
oooo<S8bokZj^PCooooo00?o0000ooooooooool0Voooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo05Sooooo1_l0001[ooooo`002oooool01?nHV9SoA4A4ooooool00005ooooo`06oc8b
<_oooooooooooooooolb<S;o^[Zj0oooool01_lb<S;ooooooooooooooooo<S8bokZj^P?ooooo00Ko
<S8boooooooooooooooooc8b<_nj^[X4ooooo`03o`000?oooooooooo09_ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`1Nooooo`?o0000J?ooool000cooooo00?o<S8bokZj^_l00000
1Oooool01Olb<S;ok^k^ooooooo^k^ko000000Cooooo00Go<S8bonk^k_ooooook^k^o`000004oooo
o`05oc8b<_o^k^koooooonk^k_l000001Oooool00ol0003oooooooooo`2Looooo`03o`000?oooooo
oooo00Wooooo00?o0000ooooooooool0bOooool000cooooo00?oc<c<ob4Q8Ol000001Oooool01On7
QhOoIVIVoooooomVIVKoA4A400Cooooo00GoQhN7ofIVI_ooooooIVIVodA4A004ooooo`05ohN7QomV
IVKoooooofIVI_m4A4@01Oooool00ol0003oooooooooo`2Looooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool0bOooool000gooooo00?oIVIVo`000?ooool01Oooool01?mVIVKo0000oc8b
<_o^k^h5ooooo`04ofIVI_l0003o<S8bonk^kPGooooo00CoIVIVo`000?lb<S;ok^k^1Oooool00ol0
003oooooooooo`2Looooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0bOooool0033o
oooo00?o0000ooooooooool0W?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo0<Wo
oooo000`ooooo`;o0000WOooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo0<Wooooo
000`ooooo`03o`000?oooooooooo09cooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`39ooooo`00<?ooool00ol0003oooooooooo`2Looooo`03o`000?oooooooooo00Wooooo00?o0000
ooooooooool0bOooool0033ooooo00?o0000ooooooooool0WOooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo0<Wooooo000`ooooo`03o`000?oooooooooo09gooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`39ooooo`00<?ooool00ol0003oooooooooo`2Mooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool0bOooool0033ooooo00?o0000ooooooooool0WOoo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo0<Wooooo000`ooooo`;o0000W_ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo0<Wooooo000`ooooo`03o`000?oooooooooo
09gooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`39ooooo`00<?ooool00ol0003o
ooooooooo`2Nooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0bOooool0033ooooo
00?o0000ooooooooool0W_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo0<Wooooo
003oooooojSooooo003oooooojSooooo003oooooojSooooo003oooooojSooooo003oooooojSooooo
003oooooojSooooo003oooooojSooooo003oooooojSooooo003oooooojSooooo003oooooojSooooo
003oooooojSooooo003oooooojSooooo003oooooojSooooo003oooooojSooooo003oooooojSooooo
003oooooojSooooo003oooooojSooooo003oooooojSooooo003oooooojSooooo003oooooojSooooo
003oooooojSooooo003oooooojSooooo003oooooojSooooo003oooooojSooooo003oooooojSooooo
003oooooojSooooo003oooooojSooooo000/ooooo`06oa0@4?l0003o0000oeEEEOooooooEEEE0_l0
00000ol@413oooooooooo`3oooooog7ooooo000]ooooo`03oa0@4?nYZJWooooo00;ooooo00?oZJVY
o`000?o^k^h0oooooomcooooo`00;Oooool00omgMgOoIVIVooooo`02ooooo`03oeEEEOm4A4Cooooo
0?ooooooLoooool002gooooo00?ogMgMo`000?l000000ol000000onYZJWoooooooooo`3oooooog;o
oooo000^ooooo`05oc8b<_nYZJWoooooohN7Qol00000oooooomeooooo`00;_ooool01OnHV9SoEEEE
oooooolQ8B7oEEEE0?ooooooMOooool002kooooo00Gok^k^oa0@4?oMgMgo0000olc<c03oooooogGo
oooo000_ooooo`03oeEEEOlb<S;o410@0?ooooooM_ooool002gooooo00Go^[Zjo`000?l0003o0000
ogMgM`3oooooogKooooo000^ooooo`04oiRHV?l0003o0000oiRHV?ooooooM_ooool002kooooo00Co
0000olc<c?o^k^ko8B4Qoooooomfooooo`00;_ooool01?l0003oc<c<onk^k_lQ8B7oooooogKooooo
000^ooooo`04oiRHV?l0003o0000oiRHV?ooooooM_ooool00?ooooooZ?ooool00?ooooooZ?ooool0
0?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool0
0?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool0
0?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool0
0?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00001\
\>"],
  ImageRangeCache->{{{0, 422}, {260, 0}} -> {-1800.19, -6366.05, 55.6299, \
85.7248}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Plot[{rootr2[i/2],rbpb[i]},{i,0.1,2000},
\tAxesLabel->{\"DNA\\nlength, bp\",\"radius, \[CapitalARing]\"}];\
\>", \
"Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00047619 0.0147151 0.000342788 [
[(500)] .2619 .01472 0 2 Msboxa
[(1000)] .5 .01472 0 2 Msboxa
[(1500)] .7381 .01472 0 2 Msboxa
[(2000)] .97619 .01472 0 2 Msboxa
[(DNA)(length, bp)] 1.025 .01472 -1 0 Msboxa
[(250)] .01131 .10041 1 0 Msboxa
[(500)] .01131 .18611 1 0 Msboxa
[(750)] .01131 .27181 1 0 Msboxa
[(1000)] .01131 .3575 1 0 Msboxa
[(1250)] .01131 .4432 1 0 Msboxa
[(1500)] .01131 .5289 1 0 Msboxa
[(1750)] .01131 .61459 1 0 Msboxa
[(radius, \\201)] .02381 .61803 0 -4 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.2619 .01472 m
.2619 .02097 L
s
P
[(500)] .2619 .01472 0 2 Mshowa
p
.002 w
.5 .01472 m
.5 .02097 L
s
P
[(1000)] .5 .01472 0 2 Mshowa
p
.002 w
.7381 .01472 m
.7381 .02097 L
s
P
[(1500)] .7381 .01472 0 2 Mshowa
p
.002 w
.97619 .01472 m
.97619 .02097 L
s
P
[(2000)] .97619 .01472 0 2 Mshowa
p
.001 w
.07143 .01472 m
.07143 .01847 L
s
P
p
.001 w
.11905 .01472 m
.11905 .01847 L
s
P
p
.001 w
.16667 .01472 m
.16667 .01847 L
s
P
p
.001 w
.21429 .01472 m
.21429 .01847 L
s
P
p
.001 w
.30952 .01472 m
.30952 .01847 L
s
P
p
.001 w
.35714 .01472 m
.35714 .01847 L
s
P
p
.001 w
.40476 .01472 m
.40476 .01847 L
s
P
p
.001 w
.45238 .01472 m
.45238 .01847 L
s
P
p
.001 w
.54762 .01472 m
.54762 .01847 L
s
P
p
.001 w
.59524 .01472 m
.59524 .01847 L
s
P
p
.001 w
.64286 .01472 m
.64286 .01847 L
s
P
p
.001 w
.69048 .01472 m
.69048 .01847 L
s
P
p
.001 w
.78571 .01472 m
.78571 .01847 L
s
P
p
.001 w
.83333 .01472 m
.83333 .01847 L
s
P
p
.001 w
.88095 .01472 m
.88095 .01847 L
s
P
p
.001 w
.92857 .01472 m
.92857 .01847 L
s
P
[(DNA)(length, bp)] 1.025 .01472 -1 0 Mshowa
p
.002 w
0 .01472 m
1 .01472 L
s
P
p
.002 w
.02381 .10041 m
.03006 .10041 L
s
P
[(250)] .01131 .10041 1 0 Mshowa
p
.002 w
.02381 .18611 m
.03006 .18611 L
s
P
[(500)] .01131 .18611 1 0 Mshowa
p
.002 w
.02381 .27181 m
.03006 .27181 L
s
P
[(750)] .01131 .27181 1 0 Mshowa
p
.002 w
.02381 .3575 m
.03006 .3575 L
s
P
[(1000)] .01131 .3575 1 0 Mshowa
p
.002 w
.02381 .4432 m
.03006 .4432 L
s
P
[(1250)] .01131 .4432 1 0 Mshowa
p
.002 w
.02381 .5289 m
.03006 .5289 L
s
P
[(1500)] .01131 .5289 1 0 Mshowa
p
.002 w
.02381 .61459 m
.03006 .61459 L
s
P
[(1750)] .01131 .61459 1 0 Mshowa
p
.001 w
.02381 .03185 m
.02756 .03185 L
s
P
p
.001 w
.02381 .04899 m
.02756 .04899 L
s
P
p
.001 w
.02381 .06613 m
.02756 .06613 L
s
P
p
.001 w
.02381 .08327 m
.02756 .08327 L
s
P
p
.001 w
.02381 .11755 m
.02756 .11755 L
s
P
p
.001 w
.02381 .13469 m
.02756 .13469 L
s
P
p
.001 w
.02381 .15183 m
.02756 .15183 L
s
P
p
.001 w
.02381 .16897 m
.02756 .16897 L
s
P
p
.001 w
.02381 .20325 m
.02756 .20325 L
s
P
p
.001 w
.02381 .22039 m
.02756 .22039 L
s
P
p
.001 w
.02381 .23753 m
.02756 .23753 L
s
P
p
.001 w
.02381 .25467 m
.02756 .25467 L
s
P
p
.001 w
.02381 .28895 m
.02756 .28895 L
s
P
p
.001 w
.02381 .30608 m
.02756 .30608 L
s
P
p
.001 w
.02381 .32322 m
.02756 .32322 L
s
P
p
.001 w
.02381 .34036 m
.02756 .34036 L
s
P
p
.001 w
.02381 .37464 m
.02756 .37464 L
s
P
p
.001 w
.02381 .39178 m
.02756 .39178 L
s
P
p
.001 w
.02381 .40892 m
.02756 .40892 L
s
P
p
.001 w
.02381 .42606 m
.02756 .42606 L
s
P
p
.001 w
.02381 .46034 m
.02756 .46034 L
s
P
p
.001 w
.02381 .47748 m
.02756 .47748 L
s
P
p
.001 w
.02381 .49462 m
.02756 .49462 L
s
P
p
.001 w
.02381 .51176 m
.02756 .51176 L
s
P
p
.001 w
.02381 .54604 m
.02756 .54604 L
s
P
p
.001 w
.02381 .56318 m
.02756 .56318 L
s
P
p
.001 w
.02381 .58031 m
.02756 .58031 L
s
P
p
.001 w
.02381 .59745 m
.02756 .59745 L
s
P
[(radius, \\201)] .02381 .61803 0 -4 Mshowa
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
p
.004 w
.02386 .01477 m
.06354 .06118 L
.10322 .10366 L
.1429 .14273 L
.18258 .1788 L
.22226 .21226 L
.26194 .24342 L
.30162 .27257 L
.3413 .29993 L
.38098 .32571 L
.42066 .35009 L
.46034 .37323 L
.50002 .39526 L
.5397 .41629 L
.57938 .43643 L
.61907 .45576 L
.65875 .47435 L
.69843 .49228 L
.73811 .50961 L
.77779 .52638 L
.81747 .54263 L
.85715 .55842 L
.89683 .57378 L
.93651 .58874 L
.97619 .60332 L
s
P
P
p
p
.004 w
.02386 .01872 m
.06354 .03148 L
.10322 .04117 L
.1429 .04983 L
.18258 .05783 L
.22226 .06534 L
.26194 .07245 L
.30162 .07922 L
.3413 .08572 L
.38098 .09196 L
.42066 .09798 L
.46034 .1038 L
.50002 .10944 L
.5397 .11493 L
.57938 .12027 L
.61907 .12548 L
.65875 .13059 L
.69843 .13559 L
.73811 .14051 L
.77779 .14536 L
.81747 .15015 L
.85715 .15489 L
.89683 .1596 L
.93651 .16428 L
.97619 .16895 L
s
P
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageRegion->{{-0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006W00011B000`400?l00000o`00003ooooooonX
ooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonX
ooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonX
ooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonX
ooooo`00oooooonXooooo`00oooooonXooooo`00HOooool01_o<c<co8B4Qo`000?l0003o<S8bomgM
g@Gooooo00CoIVIVo`000?lb<S;ok^k^1Oooool01?mVIVKo0000oc8b<_o^k^hZooooo`03oa0@4?l0
003o000000;o000000?ogMgMooooooooool00_ooool01?mVIVKo0000oc8b<_o^k^h5ooooo`04ofIV
I_l0003o<S8bonk^kPGooooo00CoIVIVo`000?lb<S;ok^k^9Oooool00ol@413o0000o`000002o`00
0005omgMgOooooooooooolc<c?lQ8B400_l000000olb<S;ogMgMooooo`04ooooo`04ofIVI_l0003o
<S8bonk^kPGooooo00CoIVIVo`000?lb<S;ok^k^9?ooool00on7QhOo0000o`000002o`000003oa0@
4?oooooooooo00?ooooo00CoIVIVo`000?lb<S;ok^k^1Oooool01?mVIVKo0000oc8b<_o^k^h5oooo
o`04ofIVI_l0003o<S8bonk^kU[ooooo001Qooooo`06olc<c?nYZJWooooooooooonHV9So8B4Q1?oo
ool2ohN7Q`03oooooon7QhOoA4A400Cooooo0_n7QhL00oooooooQhN7odA4A00/ooooo`03o`000?oo
oooooooo00Cooooo0_n7QhL00oooooooQhN7odA4A004ooooo`;oQhN700?oooooohN7Qom4A4@01?oo
ool2ohN7Q`03oooooon7QhOoA4A402Oooooo00?o0000ooooooooool00oooool01_o<c<coZJVYoooo
ooooooooV9RHob4Q8@Cooooo0_n7QhL00oooooooQhN7odA4A004ooooo`;oQhN700?oooooohN7Qom4
A4@09?ooool00oo^k^ko<S8bolc<c007ooooo`;oQhN700?oooooohN7Qom4A4@01?ooool2ohN7Q`03
oooooon7QhOoA4A400Cooooo0_n7QhL00oooooooQhN7odA4A01Jooooo`00I_ooool00olQ8B7o^[Zj
ooooo`02ooooo`05oc8b<_ooooooooooooooool000001?ooool01Olb<S;ooooooooooooooooo0000
02cooooo00?o0000ooooooooool01?ooool01Olb<S;ooooooooooooooooo000000Cooooo00Go<S8b
ooooooooooooooooo`000004ooooo`05oc8b<_ooooooooooooooool000009oooool00ol0003ooooo
ooooo`08ooooo`03ob4Q8Onj^[[ooooo00;ooooo00Go<S8booooooooooooooooo`000004ooooo`05
oc8b<_ooooooooooooooool000009Oooool00oo^k^ko<S8bojVYZ@06ooooo`05oc8b<_oooooooooo
ooooool000001?ooool01Olb<S;ooooooooooooooooo000000Cooooo00Go<S8boooooooooooooooo
o`00001Jooooo`00I_ooool00olQ8B7o^[Zjooooo`02ooooo`06oc8b<_oooooooooooooooolb<S;o
^[Zj0oooool01_lb<S;ooooooooooooooooo<S8bokZj^R_ooooo00?o0000ooooooooool01?ooool0
1_lb<S;ooooooooooooooooo<S8bokZj^P?ooooo00Ko<S8boooooooooooooooooc8b<_nj^[X3oooo
o`06oc8b<_oooooooooooooooolb<S;o^[Zj9_ooool00ol0003oooooooooo`08ooooo`03ob4Q8Onj
^[[ooooo00;ooooo00Ko<S8boooooooooooooooooc8b<_nj^[X3ooooo`06oc8b<_oooooooooooooo
oolb<S;o^[Zj9Oooool00oo^k^ko8B4QoiRHV005ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj
0oooool01_lb<S;ooooooooooooooooo<S8bokZj^P?ooooo00Ko<S8boooooooooooooooooc8b<_nj
^[XKooooo`05oeEEEOl0003o0000odA4A?o^k^h0<?ooool3o`000003oc8b<_oooooooooo00?ooooo
001Rooooo`05ofIVI_oMgMgoooooohN7Qol@41001?ooool01_lb<S;ooooooooooooooooo<S8bokZj
^P?ooooo00Ko<S8boooooooooooooooooc8b<_nj^[X[ooooo`03o`000?oooooooooo00Cooooo00Ko
<S8boooooooooooooooooc8b<_nj^[X3ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj0oooool0
1_lb<S;ooooooooooooooooo<S8bokZj^RKooooo00?o0000ooooooooool01?ooool01OmVIVKogMgM
oooooon7QhOo410@00Cooooo00Ko<S8boooooooooooooooooc8b<_nj^[X3ooooo`06oc8b<_oooooo
oooooooooolb<S;o^[Zj9_ooool00oo^k^ko<S8bolc<c004ooooo`06oc8b<_oooooooooooooooolb
<S;o^[Zj0oooool01_lb<S;ooooooooooooooooo<S8bokZj^P?ooooo00Ko<S8boooooooooooooooo
oc8b<_nj^[XNooooo`03ohN7Qolb<S;ooooo01Gooooo00?oc<c<o`000?o^k^h05oooool00onj^[[o
0000ooooo`06ooooo`00H_ooool01Ol0003o8B4Qo`000?l@413oc<c<00Cooooo00Ko<S8boooooooo
oooooooooc8b<_nj^[X3ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj:oooool00ol0003ooooo
ooooo`04ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj0oooool01_lb<S;ooooooooooooooooo
<S8bokZj^P?ooooo00Ko<S8boooooooooooooooooc8b<_nj^[XVooooo`03o`000?oooooooooo00Co
oooo00Go0000ob4Q8Ol0003o410@olc<c004ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj0ooo
ool01_lb<S;ooooooooooooooooo<S8bokZj^ROooooo00?ok^k^odA4A?ooool00oooool01_lb<S;o
oooooooooooooooo<S8bokZj^P?ooooo00Ko<S8boooooooooooooooooc8b<_nj^[X3ooooo`06oc8b
<_oooooooooooooooolb<S;o^[Zj7oooool00ol0003oooooooooo`0Dooooo`03onk^k_l0003oEEEE
01Oooooo00?o^[Zjo`000?ooool01_ooool006;ooooo00?o0000ooooooooool01_ooool01Olb<S;o
k^k^ooooooo^k^ko000000Cooooo00Go<S8bonk^k_ooooook^k^o`00000/ooooo`03o`000?oooooo
oooo00Cooooo00Go<S8bonk^k_ooooook^k^o`000004ooooo`05oc8b<_o^k^koooooonk^k_l00000
1?ooool01Olb<S;ok^k^ooooooo^k^ko000002Oooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`06ooooo`05oc8b<_o^k^koooooonk^k_l000001?ooool01Olb<S;ok^k^ooooooo^k^ko
000002Gooooo00Go^[Zjoooooooooooooooooc8b<P04ooooo`05oc8b<_o^k^koooooonk^k_l00000
1?ooool01Olb<S;ok^k^ooooooo^k^ko000000Cooooo00Ko<S8bonk^k_ooooook^k^o`000?l@4105
o`000005oc8b<_oooooooooooooooomVIVH00ol000001Om4A4CoV9RHoooooooooooo410@00;o0000
00Coooooo`000?l0003o410@0oooool01OmVIVKo0000o`000?mVIVKo000000Gooooo00SoV9RHoa0@
4?l0003o410@oeEEEOo<c<cooooooa0@40;o000000Coooooo`000?l0003o410@1?ooool00om4A4Co
0000okZj^P0=ooooo`03oa0@4?l0003oIVIV00;o000000OoMgMgoooooooooooooooookZj^_l0003o
V9RH00;o000000?oIVIVooooooooool00Oooool006;ooooo00?o0000ooooooooool01_ooool01On7
QhOoIVIVoooooomVIVKoA4A400Cooooo00GoQhN7ofIVI_ooooooIVIVodA4A00Zooooo`03ohN7Qonj
^[[o000000Kooooo00GoQhN7ofIVI_ooooooIVIVodA4A004ooooo`05ohN7QomVIVKoooooofIVI_m4
A4@01?ooool01On7QhOoIVIVoooooomVIVKoA4A402Gooooo00?oQhN7okZj^_l000001_ooool00ol0
003oooooooooo`06ooooo`05ohN7QomVIVKoooooofIVI_m4A4@01?ooool01On7QhOoIVIVoooooomV
IVKoA4A402Cooooo00Koc<c<o`000?n7QhOooooookZj^_lQ8B44ooooo`05ohN7QomVIVKoooooofIV
I_m4A4@01?ooool01On7QhOoIVIVoooooomVIVKoA4A400Cooooo00GoQhN7ofIVI_ooooooIVIVodA4
A003ooooo`03o`000?oooooooooo00?ooooo00OoMgMgoeEEEOo^k^koooooonk^k_nHV9So<S8b00?o
oooo00Go0000ooooooooooooooooo`000003ooooo`06ogMgMomEEEGok^k^omgMgOlQ8B7o00001Ooo
ool01_l0003oc<c<oooooooMgMgoQhN7ojVYZ@;ooooo00Go0000ooooooooooooooooo`000005oooo
o`03oiRHV?l0003o<S8b00kooooo00Co0000odA4A?o^k^kooooo0_mgMgL2ooooo`03okZj^_l0003o
MgMg00;ooooo0_mgMgL2ooooo`00H_ooool4o`000003oa0@4?oooooooooo00?ooooo00CoIVIVo`00
0?lb<S;ok^k^1Oooool01?mVIVKo0000oc8b<_o^k^hZooooo`03ohN7Qolb<S;o000000Oooooo00Co
IVIVo`000?lb<S;ok^k^1Oooool01?mVIVKo0000oc8b<_o^k^h5ooooo`04ofIVI_l0003o<S8bonk^
kRGooooo00?oQhN7oc8b<_l000001_ooool4o`000003oa0@4?oooooooooo00?ooooo00CoIVIVo`00
0?lb<S;ok^k^1Oooool01?mVIVKo0000oc8b<_o^k^hUooooo`05ojVYZOlQ8B7o0000oa0@4?o<c<`0
1Oooool01?mVIVKo0000oc8b<_o^k^h5ooooo`04ofIVI_l0003o<S8bonk^kPGooooo00CoIVIVo`00
0?lb<S;ok^k^0oooool00ol0003oooooooooo`03ooooo`03o`000?o^k^kooooo00Oooooo00Go0000
ooooooooooooooooo`000003ooooo`06ob4Q8Oooooooooooooooooo<c<co00001Oooool00ol0003o
ooooooooo`05ooooo`05o`000?ooooooooooooooool000005_ooool00ol0003ogMgMooooo`02oooo
o`05oc8b<_oooooooooookZj^_l@41001?ooool1ob4Q8@7ooooo0Oooool00?ooooooDOooool00ol0
003oooooooooo`03ooooo`Oo000000CogMgMoooooooooooo00000oooool01Ol0003ooooooooooooo
oooo<S8b00Cooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`05ooooo`05o`000?oo
ooooooooooooool000005_ooool00ol0003oooooooooo`02ooooo`05oc8b<_oooooooooookZj^_lb
<S801?ooool1oc8b<P7ooooo0Oooool00?ooooooDOooool00ol0003oooooooooo`03ooooo`03oa0@
4?oMgMgooooo00;ooooo00?oV9RHo`000?ooool00_ooool01Ol0003ooooooooooooooooo000000?o
oooo00Ko<S8booooooooooooooooomgMgOl00005ooooo`03o`000?oooooooooo00Gooooo00Go0000
ooooooooooooooooo`00000Fooooo`03o`000?oMgMgooooo00;ooooo00Ko<S8boooooooooooo^[Zj
o`000?o^k^h2ooooo`03onk^k_lQ8B7ooooo007ooooo003ooooooe7ooooo00?o0000ooooooooool0
0oooool01omgMgOo8B4QomgMgOoooooogMgMoa0@4?mVIVH00oooool01Ol0003oQhN7oooooonj^[[o
410@00?ooooo0_mgMgL01?ooooook^k^odA4A?l00003ooooo`03oa0@4?l0003o000000?o000000Wo
MgMgooooooooooooooooo`000?n7QhOooooookZj^_l@41005_ooool01?l0003oA4A4onk^k_ooool2
ogMgM`;ooooo00?o^[Zjo`000?m4A4@00_oMgMd00om4A4CoMgMgooooo`01ooooo`00oooooomAoooo
o`03o`000?oooooooooo00Cooooo00GoMgMgoa0@4?l0003o410@ogMgM`03ooooo`;o000000CoIVIV
o`000?l0003o^[Zj1?ooool01_mVIVKo0000o`000?mEEEGo0000oc8b<PCooooo00?o<S8boooooooo
ool01Oooool01Ol0003oMgMgo`000?l0003o^[Zj01Kooooo00Go0000ofIVI_l0003o0000ofIVIP03
ooooo`03oa0@4?l0003oMgMg00;o000000?oIVIVooooooooool00Oooool002Sooooo00?o0000oooo
ooooool0oooooolVooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`0Hooooo`03o`000?oooooooooo00kooooo000Xooooo`03o`000?oooooooooo0?oo
oooo9_ooool00ol0003oooooooooo`0Pooooo`03oa0@4?oooooooooo00Gooooo00?o0000oooooooo
ool06?ooool00ol0003oooooooooo`0>ooooo`00:?ooool00ol0003oooooooooo`3oooooobCooooo
00?o410@o`000?l00000:Oooool00ol@413o0000ooooo`0Hooooo`03oa0@4?l0003ooooo00oooooo
000Xooooo`03o`000?oooooooooo0?ooooooOOooool0027oooooool0000Uo`0006;ooooo000Xoooo
o`?o00002oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00_ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00_ooooo00?o0000oooo
ooooool02oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00_ooooo00?o0000oooo
ooooool02oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool02oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00_ooooo00?o0000oooo
ooooool02oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00_ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo06Oooooo000Xooooo`;o
000000Coooooo`000?l0003o0000?oooool00ol0003oooooooooo`13ooooo`03o`000?oooooooooo
04;ooooo00?o0000ooooooooool0@_ooool00ol0003oooooooooo`1Wooooo`00:?ooool00ol0003o
ooooo`000003ooooo`?o0000oooooomgooooo`00:?ooool01?l0003oooooooooool00005ooooo`?o
0000oooooomdooooo`00:?ooool2o`0000;ooooo00?o0000ooooooooool01Oooool3o`000?oooooo
LOooool002Sooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`07ooooo`Co0000oooo
oom]ooooo`00:?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00[ooooo0ol0003o
oooooa7ooooo0ol000000ol@413oV9RHooooo`02ooooo`?o00000_ooool01?mVIVKo0000ooooool@
4102o`000004oeEEEOoooooooooooeEEE@?o000000?ogMgMooooooooool0??ooool002Sooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`0=ooooo`Go0000ooooool<ooooo`06o`000?oo
oooooooookZj^_lQ8B7o^[Zj0_ooool01Ol0003ooooooooooooooooo^[Zj00;o00000_ooool00ol@
413oZJVYooooo`03ooooo`03okZj^_l0003ogMgM03oooooo000Xooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool04Oooool6o`000?oooooo1_ooool01_l0003ooooooooooooooooogMgM
odA4A0;ooooo00Oo0000ooooooooooook^k^oa0@4?m4A4Co000000;ooooo00?oMgMgodA4A?ooool0
0oooool2oeEEED3ooooo000Xooooo`;o00001_ooool00ol0003oooooooooo`0Fooooo`Go0000oooo
ool1ooooo`03o`000?oooooooooo00;ooooo00Co<S8boooooooooooo00000_ooool01?mEEEGo0000
onk^k_l00002ooooo`03omgMgOl0003o000000Co000000?ogMgMooooooooool0?_ooool002Sooooo
00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Jooooo`Co0000o?ooool00ol0003ooooo
ooooo`02ooooo`0:oc8b<_ooooooooooo`000?ooooooZJVYo`000?nYZJWoooooo`0000?ooooo00Ko
<S8boiRHV?ooooooooooogMgMolb<S91ooooo`00:?ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo01gooooo0ol0003iooooo`03o`000?oooooooooo00;ooooo00Oo8B4Qoooooooooooo
0000onk^k_l0003oA4A400;ooooo00Ko0000oooooooooooooooooiRHV?l@4102ooooo`03oa0@4?nj
^[[ooooo043ooooo000Xooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool07oooool5
o`000?Cooooo00Ko0000ooooooooooooooooomgMgOm4A4@2ooooo`04o`000?m4A4Co0000omgMg@;o
oooo00Ko0000ooooooooooooooooonk^k_l00002oiRHV003oa0@4?oooooooooo043ooooo000Xoooo
o`03o`000?oooooooooo00Wooooo00?o0000ooooooooool08oooool6o`000>kooooo00Ko0000oooo
oooooooogMgMob4Q8OnYZJT2ooooo`;o000000GoQhN7ooooooooooooooooo`000004ooooo`04oeEE
EOl@413o410@oiRHV4;ooooo000Xooooo`;o00002_ooool00ol0003oooooooooo`0Yooooo`Ko0000
j?ooool4o`000003ohN7QooooooogMgM00;o000000?o<S8booooooooool00ol00002ooooo`05okZj
^_l0003o0000o`000?l@4100@oooool002Sooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0^ooooo`Go0000oooooolmooooo`00:?ooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo03;ooooo1_l0003oooooocOooooo000Xooooo`03o`000?oooooooooo00cooooo00?o0000
ooooooooool0=oooool6o`000?oooooo<Oooool002Sooooo00?o0000ooooooooool03Oooool00ol0
003oooooooooo`0looooo`Ko0000ooooool[ooooo`00:?ooool2o`0000oooooo00?o0000oooooooo
ool0@Oooool5o`000?oooooo9_ooool002Sooooo00?o0000ooooooooool03oooool00ol0003ooooo
ooooo`15ooooo`Ko0000oooooolPooooo`00:?ooool00ol0003oooooooooo`0@ooooo`03o`000?oo
oooooooo04[ooooo1_l0003ooooooa[ooooo000:ooooo`03ohN7Qol0003o000000;o000000Ko410@
ooooooooooooooooolc<c?lQ8B42o`000003oc8b<_oMgMgooooo00Cooooo00CoIVIVo`000?lb<S;o
k^k^1_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo04oooooo2Ol0003ooooooa7o
oooo000:ooooo`03onk^k_lb<S;oc<c<00Kooooo00Koc<c<ojVYZOoooooooooooiRHV?lQ8B44oooo
o`;oQhN700?oooooohN7Qom4A4@01_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo
05Oooooo2Ol0003oooooo`Sooooo000;ooooo`03onk^k_lb<S;oZJVY00[ooooo00?o8B4QokZj^_oo
ool00_ooool01Olb<S;ooooooooooooooooo000000Kooooo0ol0000Cooooo`03o`000?oooooooooo
05oooooo1Ol0003oooooo`?ooooo000<ooooo`03onk^k_lQ8B7oV9RH00Wooooo00?o8B4QokZj^_oo
ool00_ooool01_lb<S;ooooooooooooooooo<S8bokZj^PGooooo00?o0000ooooooooool05?ooool2
o`0006Cooooo1_l0003looooo`003Oooool00oo^k^ko<S8bolc<c004ooooo`05ofIVI_oMgMgooooo
ohN7Qol@41001?ooool01_lb<S;ooooooooooooooooo<S8bokZj^PGooooo00?o0000ooooooooool0
5_ooool00ol0003oooooooooo`1Wooooo`Ko0000m_ooool000kooooo00?ok^k^odA4A?ooool00ooo
ool01Ol0003o8B4Qo`000?l@413oc<c<00Cooooo00Ko<S8boooooooooooooooooc8b<_nj^[X5oooo
o`03o`000?oooooooooo01Oooooo00?o0000ooooooooool0K?ooool9o`000>gooooo000;ooooo`05
okZj^_oooooooooooooooolb<S801?ooool00ol0003oooooooooo`06ooooo`05oc8b<_o^k^kooooo
onk^k_l000001_ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo07Cooooo2?l0003U
ooooo`002_ooool01_o<c<co0000ohN7Qooooooo^[Zjob4Q8@Cooooo00?o0000ooooooooool01_oo
ool01On7QhOoIVIVoooooomVIVKoA4A400Kooooo0_l0000Jooooo`03o`000?oooooooooo07_ooooo
1_l0003Oooooo`002oooool01OnYZJWo8B4Qo`000?l@413oc<c<00Cooooo1?l000000ol@413ooooo
ooooo`03ooooo`04ofIVI_l0003o<S8bonk^kPKooooo00?o0000ooooooooool06_ooool00ol0003o
ooooooooo`20ooooo`Wo0000e_ooool002Sooooo00?o0000ooooooooool06oooool00ol0003ooooo
ooooo`28ooooo`So0000c_ooool002Sooooo00?o0000ooooooooool07?ooool00ol0003ooooooooo
o`2?ooooo`Ko0000b?ooool002Sooooo00?o0000ooooooooool07Oooool00ol0003oooooooooo`2D
ooooo`Wo0000_oooool002Sooooo0_l0000Oooooo`03o`000?oooooooooo09cooooo2?l0002goooo
o`00:?ooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo0:?ooooo1_l0002aooooo`00
:?ooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo0:Sooooo2Ol0002Xooooo`00:?oo
ool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo0;3ooooo2Ol0002Oooooo`00:?ooool0
0ol0003oooooooooo`0Rooooo`03o`000?oooooooooo0;Sooooo1Ol0002Jooooo`00:?ooool2o`00
02Cooooo00?o0000ooooooooool0_?ooool9o`00097ooooo000Xooooo`03o`000?oooooooooo02Co
oooo00?o0000ooooooooool0a?ooool<o`0008Gooooo000Xooooo`03o`000?oooooooooo02Gooooo
00?o0000ooooooooool0coooool8o`0007gooooo000Xooooo`03o`000?oooooooooo02Kooooo00?o
0000ooooooooool0e_ooool6o`0007Oooooo000Xooooo`03o`000?oooooooooo02Oooooo00?o0000
ooooooooool0foooool9o`0006kooooo000Xooooo`;o0000:Oooool00ol0003oooooooooo`3Soooo
o`Go0000JOooool002Sooooo00?o0000ooooooooool0:Oooool00ol0003oooooooooo`3ooooooe7o
oooo000Xooooo`03o`000?oooooooooo02[ooooo00?o0000ooooooooool0oooooom@ooooo`002_oo
ool01_o<c<co8B4Qo`000?l0003o<S8bomgMg@Gooooo00CoIVIVo`000?lb<S;ok^k^1Oooool01?mV
IVKo0000oc8b<_o^k^h6ooooo`03o`000?oooooooooo02_ooooo0_l0003ooooooe3ooooo000:oooo
o`06olc<c?nYZJWooooooooooonHV9So8B4Q1?ooool2ohN7Q`03oooooon7QhOoA4A400Cooooo0_n7
QhL00oooooooQhN7odA4A006ooooo`03o`000?oooooooooo02gooooo00?o0000ooooooooool0oooo
oom=ooooo`003oooool00olQ8B7o^[Zjooooo`02ooooo`05oc8b<_ooooooooooooooool000001?oo
ool01Olb<S;ooooooooooooooooo000000Kooooo0ol0000^ooooo`03o`000?oooooooooo0?oooooo
C?ooool000oooooo00?o8B4QokZj^_ooool00_ooool01_lb<S;ooooooooooooooooo<S8bokZj^P?o
oooo00Ko<S8boooooooooooooooooc8b<_nj^[X5ooooo`03o`000?oooooooooo02oooooo00?o0000
ooooooooool0oooooom;ooooo`002oooool01OmVIVKogMgMoooooon7QhOo410@00Cooooo00Ko<S8b
oooooooooooooooooc8b<_nj^[X3ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj1Oooool00ol0
003oooooooooo`0`ooooo`03o`000?oooooooooo0?ooooooB_ooool000_ooooo00Go0000ob4Q8Ol0
003o410@olc<c004ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj0oooool01_lb<S;ooooooooo
oooooooo<S8bokZj^PGooooo00?o0000ooooooooool0<Oooool2o`000?ooooooB_ooool000_ooooo
00?o0000ooooooooool01_ooool01Olb<S;ok^k^ooooooo^k^ko000000Cooooo00Go<S8bonk^k_oo
ooook^k^o`000006ooooo`03o`000?oooooooooo03?ooooo00?o0000ooooooooool0oooooom7oooo
o`002oooool00ol0003oooooooooo`06ooooo`05ohN7QomVIVKoooooofIVI_m4A4@01?ooool01On7
QhOoIVIVoooooomVIVKoA4A400Kooooo0_l0000eooooo`03o`000?oooooooooo0?ooooooA_ooool0
00_ooooo1?l000000ol@413oooooooooo`03ooooo`04ofIVI_l0003o<S8bonk^kPGooooo00CoIVIV
o`000?lb<S;ok^k^1_ooool00ol0003oooooooooo`0eooooo`03o`000?oooooooooo0?ooooooAOoo
ool002Sooooo00?o0000ooooooooool0=_ooool00ol0003oooooooooo`3oooooodCooooo000Xoooo
o`03o`000?oooooooooo03Oooooo0_l0003oooooodCooooo000Xooooo`03o`000?oooooooooo03Wo
oooo00?o0000ooooooooool0oooooom1ooooo`00:?ooool2o`0003_ooooo00?o0000ooooooooool0
oooooom0ooooo`00:?ooool00ol0003oooooooooo`0kooooo`03o`000?oooooooooo0?oooooo?ooo
ool002Sooooo00?o0000ooooooooool0??ooool2o`000?oooooo?oooool002Sooooo00?o0000oooo
ooooool0?_ooool00ol0003oooooooooo`3ooooooccooooo000Xooooo`03o`000?oooooooooo03oo
oooo00?o0000ooooooooool0oooooolkooooo`00:?ooool2o`00047ooooo00?o0000ooooooooool0
ooooooljooooo`00:?ooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo0?oooooo>Ooo
ool002Sooooo00?o0000ooooooooool0@_ooool2o`000?oooooo>Oooool002Sooooo00?o0000oooo
ooooool0A?ooool00ol0003oooooooooo`3oooooocKooooo000Xooooo`03o`000?oooooooooo04Go
oooo0_l0003oooooocKooooo000Xooooo`;o0000B?ooool00ol0003oooooooooo`3ooooooc?ooooo
000Xooooo`03o`000?oooooooooo04Sooooo0_l0003ooooooc?ooooo000Xooooo`03o`000?oooooo
oooo04[ooooo00?o0000ooooooooool0ooooool`ooooo`003?ooool00ooMgMgo0000omgMg@04oooo
o`06olc<c?lQ8B7o0000o`000?lb<S;ogMgM1Oooool01?mVIVKo0000oc8b<_o^k^h6ooooo`03o`00
0?oooooooooo04_ooooo0_l0003ooooooc3ooooo000=ooooo`03oc8b<_n7QhOooooo00?ooooo00Ko
c<c<ojVYZOoooooooooooiRHV?lQ8B44ooooo`;oQhN700?oooooohN7Qom4A4@01_ooool00ol0003o
ooooooooo`1=ooooo`03o`000?oooooooooo0?oooooo;Oooool000gooooo00?oV9RHob4Q8Oooool0
2?ooool00olQ8B7o^[Zjooooo`02ooooo`05oc8b<_ooooooooooooooool000001_ooool3o`0004ko
oooo0_l0003oooooobgooooo000=ooooo`03onk^k_l0003oc<c<00Sooooo00?o8B4QokZj^_ooool0
0_ooool01_lb<S;ooooooooooooooooo<S8bokZj^PGooooo00?o0000ooooooooool0D?ooool00ol0
003oooooooooo`3oooooob[ooooo000>ooooo`03oeEEEOmVIVKooooo00?ooooo00GoIVIVomgMgOoo
ooooQhN7oa0@4004ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj1Oooool00ol0003ooooooooo
o`1Aooooo`03o`000?oooooooooo0?oooooo:Oooool000kooooo00?o^[Zjoa0@4?ooool00oooool0
1Ol0003o8B4Qo`000?l@413oc<c<00Cooooo00Ko<S8boooooooooooooooooc8b<_nj^[X5ooooo`03
o`000?oooooooooo05;ooooo0_l0003oooooobWooooo000?ooooo`03oa0@4?o<c<cooooo00;ooooo
00?o0000ooooooooool01_ooool01Olb<S;ok^k^ooooooo^k^ko000000Kooooo00?o0000oooooooo
ool0E?ooool00ol0003oooooooooo`3oooooobKooooo000?ooooo`03ohN7QomVIVKooooo00;ooooo
00?o0000ooooooooool01_ooool01On7QhOoIVIVoooooomVIVKoA4A400Kooooo0_l0001Fooooo`;o
0000oooooolVooooo`002oooool5o`000004oc8b<_ooooooooooooooo`Co000000?o410@oooooooo
ool00oooool01?mVIVKo0000oc8b<_o^k^h6ooooo`03o`000?oooooooooo05Oooooo00?o0000oooo
ooooool0oooooolSooooo`00:?ooool00ol0003oooooooooo`1Hooooo`03o`000?oooooooooo0?oo
oooo8_ooool002Sooooo00?o0000ooooooooool0FOooool2o`000?oooooo8_ooool002Sooooo00?o
0000ooooooooool0Foooool00ol0003oooooooooo`3ooooooaoooooo000Xooooo`;o0000GOooool2
o`000?oooooo7oooool002Sooooo00?o0000ooooooooool0G_ooool00ol0003oooooooooo`3ooooo
oacooooo000Xooooo`03o`000?oooooooooo05oooooo0_l0003ooooooacooooo000Xooooo`03o`00
0?oooooooooo067ooooo00?o0000ooooooooool0oooooolIooooo`00:?ooool00ol0003ooooooooo
o`1Rooooo`;o0000oooooolIooooo`00:?ooool2o`0006Gooooo00?o0000ooooooooool0oooooolF
ooooo`00:?ooool00ol0003oooooooooo`1Uooooo`;o0000oooooolFooooo`00:?ooool00ol0003o
ooooooooo`1Wooooo`;o0000oooooolDooooo`00:?ooool00ol0003oooooooooo`1Yooooo`03o`00
0?oooooooooo0?oooooo4Oooool002Sooooo00?o0000ooooooooool0J_ooool2o`000?oooooo4Ooo
ool002Sooooo0_l0001]ooooo`;o0000ooooool?ooooo`00:?ooool00ol0003oooooooooo`1^oooo
o`03o`000?oooooooooo0?oooooo3?ooool000;ooooo00?o410@o`000?l000000_l000000ooMgMgo
ooooooooo`02ooooo`04ofIVI_l0003o<S8bonk^kPGooooo00CoIVIVo`000?lb<S;ok^k^1Oooool0
1?mVIVKo0000oc8b<_o^k^h6ooooo`03o`000?oooooooooo06oooooo0_l0003oooooo`cooooo0004
ooooo`03o`000?oooooooooo00Cooooo0_n7QhL00oooooooQhN7odA4A004ooooo`;oQhN700?ooooo
ohN7Qom4A4@01?ooool2ohN7Q`03oooooon7QhOoA4A400Kooooo00?o0000ooooooooool0LOooool2
o`000?oooooo2_ooool000Cooooo00?o0000ooooooooool01?ooool01Olb<S;ooooooooooooooooo
000000Cooooo00Go<S8booooooooooooooooo`000004ooooo`05oc8b<_ooooooooooooooool00000
1_ooool00ol0003oooooooooo`1cooooo`03o`000?oooooooooo0?oooooo1oooool000Cooooo00?o
0000ooooooooool01?ooool01_lb<S;ooooooooooooooooo<S8bokZj^P?ooooo00Ko<S8boooooooo
oooooooooc8b<_nj^[X3ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj1Oooool3o`0007Cooooo
0_l0003oooooo`Oooooo0004ooooo`03o`000?oooooooooo00Cooooo00Ko<S8boooooooooooooooo
oc8b<_nj^[X3ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj0oooool01_lb<S;ooooooooooooo
oooo<S8bokZj^PGooooo00?o0000ooooooooool0M_ooool2o`000?oooooo1Oooool000Cooooo00?o
0000ooooooooool01?ooool01_lb<S;ooooooooooooooooo<S8bokZj^P?ooooo00Ko<S8boooooooo
oooooooooc8b<_nj^[X3ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj1Oooool00ol0003ooooo
ooooo`1hooooo`03o`000?oooooooooo0?oooooo0_ooool000Cooooo00?o0000ooooooooool01?oo
ool01Olb<S;ok^k^ooooooo^k^ko000000Cooooo00Go<S8bonk^k_ooooook^k^o`000004ooooo`05
oc8b<_o^k^koooooonk^k_l000001_ooool00ol0003oooooooooo`1iooooo`;o0000ooooool2oooo
o`000_ooool00on7QhOo^[Zjo`000006ooooo`05ohN7QomVIVKoooooofIVI_m4A4@01?ooool01On7
QhOoIVIVoooooomVIVKoA4A400Cooooo00GoQhN7ofIVI_ooooooIVIVodA4A006ooooo`03o`000?oo
oooooooo07_ooooo00?o0000ooooooooool0o_ooool000;ooooo00?oQhN7oc8b<_l000001oooool0
1?mVIVKo0000oc8b<_o^k^h5ooooo`04ofIVI_l0003o<S8bonk^kPGooooo00CoIVIVo`000?lb<S;o
k^k^1_ooool2o`0007gooooo0_l0003nooooo`00:?ooool00ol0003oooooooooo`1nooooo`;o0000
o?ooool002Sooooo00?o0000ooooooooool0P?ooool2o`000?[ooooo000Xooooo`03o`000?oooooo
oooo08;ooooo0_l0003hooooo`00:?ooool00ol0003oooooooooo`24ooooo`;o0000m_ooool002So
oooo0_l00027ooooo`;o0000m?ooool002Sooooo00?o0000ooooooooool0R?ooool2o`000?;ooooo
000Xooooo`03o`000?oooooooooo08[ooooo0_l0003`ooooo`00:?ooool00ol0003oooooooooo`2<
ooooo`;o0000k_ooool002Sooooo00?o0000ooooooooool0S_ooool00ol0003oooooooooo`3[oooo
o`00:?ooool2o`00093ooooo0_l0003[ooooo`00:?ooool00ol0003oooooooooo`2Aooooo`;o0000
jOooool002Sooooo00?o0000ooooooooool0Toooool2o`000>Oooooo000Xooooo`03o`000?oooooo
oooo09Gooooo0_l0003Uooooo`00:?ooool00ol0003oooooooooo`2Gooooo`;o0000hoooool002So
oooo0_l0002Jooooo`;o0000hOooool002Sooooo00?o0000ooooooooool0Voooool2o`000=oooooo
0002ooooo`03oa0@4?l0003o000000;o000000CogMgMooooooooooooQhN71?l000001_l@413ooooo
ooooooooooooc<c<ob4Q8@;o000000?o<S8bomgMgOooool01?ooool01?mVIVKo0000oc8b<_o^k^h6
ooooo`03o`000?oooooooooo09gooooo0_l0003Mooooo`001?ooool00ol0003oooooooooo`03oooo
o`03onk^k_lb<S;oc<c<00Kooooo00Koc<c<ojVYZOoooooooooooiRHV?lQ8B44ooooo`;oQhN700?o
ooooohN7Qom4A4@01_ooool00ol0003oooooooooo`2Oooooo`;o0000foooool000Cooooo00?o0000
ooooooooool01?ooool00oo^k^ko<S8bojVYZ@0:ooooo`03ob4Q8Onj^[[ooooo00;ooooo00Go<S8b
ooooooooooooooooo`000006ooooo`03o`000?oooooooooo0:7ooooo0_l0003Iooooo`001?ooool0
0ol0003oooooooooo`05ooooo`03onk^k_lQ8B7oV9RH00Wooooo00?o8B4QokZj^_ooool00_ooool0
1_lb<S;ooooooooooooooooo<S8bokZj^PGooooo0ol0002Sooooo`;o0000eoooool000Cooooo00?o
0000ooooooooool01_ooool00oo^k^ko<S8bolc<c004ooooo`05ofIVI_oMgMgoooooohN7Qol@4100
1?ooool01_lb<S;ooooooooooooooooo<S8bokZj^PGooooo00?o0000ooooooooool0YOooool00ol0
003oooooooooo`3Dooooo`001?ooool00ol0003oooooooooo`07ooooo`03onk^k_m4A4Cooooo00?o
oooo00Go0000ob4Q8Ol0003o410@olc<c004ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj1Ooo
ool00ol0003oooooooooo`2Vooooo`;o0000e?ooool000Cooooo00?o0000ooooooooool01?ooool0
1Onj^[[ooooooooooooooooo<S8b00Cooooo00?o0000ooooooooool01_ooool01Olb<S;ok^k^oooo
ooo^k^ko000000Kooooo00?o0000ooooooooool0Z?ooool2o`000=;ooooo0002ooooo`03ohN7Qonj
^[[o000000Gooooo00Koc<c<o`000?n7QhOooooookZj^_lQ8B44ooooo`03o`000?oooooooooo00Ko
oooo00GoQhN7ofIVI_ooooooIVIVodA4A006ooooo`03o`000?oooooooooo0:[ooooo0_l0003@oooo
o`000_ooool00on7QhOo<S8bo`000006ooooo`05ojVYZOlQ8B7o0000oa0@4?o<c<`01?ooool4o`00
0003oa0@4?oooooooooo00?ooooo00CoIVIVo`000?lb<S;ok^k^1_ooool2o`000:gooooo0ol0003=
ooooo`00:?ooool00ol0003oooooooooo`2_ooooo`;o0000boooool002Sooooo00?o0000oooooooo
ool0/Oooool2o`000<Wooooo000Xooooo`03o`000?oooooooooo0;?ooooo0ol00036ooooo`00:?oo
ool00ol0003oooooooooo`2fooooo`;o0000a?ooool002Sooooo0_l0002iooooo`;o0000`_ooool0
02Sooooo00?o0000ooooooooool0^_ooool3o`000;oooooo000Xooooo`03o`000?oooooooooo0;go
oooo0_l0002mooooo`00:?ooool00ol0003oooooooooo`2oooooo`;o0000^oooool002Sooooo00?o
0000ooooooooool0`Oooool2o`000;Wooooo000Xooooo`;o0000a?ooool3o`000;Kooooo000Xoooo
o`03o`000?oooooooooo0<Kooooo0_l0002dooooo`00:?ooool00ol0003oooooooooo`38ooooo`;o
0000/_ooool002Sooooo00?o0000ooooooooool0b_ooool3o`000:oooooo000Xooooo`03o`000?oo
oooooooo0<gooooo0_l0002]ooooo`00:?ooool2o`000=3ooooo0ol0002Zooooo`00:?ooool00ol0
003oooooooooo`3Booooo`;o0000Z?ooool000;ooooo00?o410@o`000?l000000_l000001OoMgMgo
ooooooooooo<c<co8B4Q00;o000000?o<S8bomgMgOooool01?ooool01?mVIVKo0000oc8b<_o^k^h5
ooooo`04ofIVI_l0003o<S8bonk^kPKooooo00?o0000ooooooooool0e?ooool2o`000:Kooooo0004
ooooo`03o`000?oooooooooo00?ooooo00Koc<c<ojVYZOoooooooooooiRHV?lQ8B44ooooo`;oQhN7
00?oooooohN7Qom4A4@01?ooool2ohN7Q`03oooooon7QhOoA4A400Kooooo00?o0000ooooooooool0
e_ooool3o`000:?ooooo0004ooooo`03o`000?oooooooooo00Sooooo00?o8B4QokZj^_ooool00_oo
ool01Olb<S;ooooooooooooooooo000000Cooooo00Go<S8booooooooooooooooo`000006ooooo`03
o`000?oooooooooo0=Wooooo0_l0002Qooooo`001?ooool00ol0003oooooooooo`08ooooo`03ob4Q
8Onj^[[ooooo00;ooooo00Ko<S8boooooooooooooooooc8b<_nj^[X3ooooo`06oc8b<_oooooooooo
oooooolb<S;o^[Zj1Oooool3o`000=_ooooo0_l0002Oooooo`001?ooool00ol0003oooooooooo`04
ooooo`05ofIVI_oMgMgoooooohN7Qol@41001?ooool01_lb<S;ooooooooooooooooo<S8bokZj^P?o
oooo00Ko<S8boooooooooooooooooc8b<_nj^[X5ooooo`03o`000?oooooooooo0=gooooo0ol0002L
ooooo`001?ooool00ol0003oooooooooo`04ooooo`05o`000?lQ8B7o0000oa0@4?o<c<`01?ooool0
1_lb<S;ooooooooooooooooo<S8bokZj^P?ooooo00Ko<S8boooooooooooooooooc8b<_nj^[X5oooo
o`03o`000?oooooooooo0>3ooooo0_l0002Jooooo`001?ooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo00Kooooo00Go<S8bonk^k_ooooook^k^o`000004ooooo`05oc8b<_o^k^kooooo
onk^k_l000001_ooool00ol0003oooooooooo`3Rooooo`;o0000V?ooool000;ooooo00?oQhN7okZj
^_l000001_ooool00ol0003oooooooooo`06ooooo`05ohN7QomVIVKoooooofIVI_m4A4@01?ooool0
1On7QhOoIVIVoooooomVIVKoA4A400Kooooo00?o0000ooooooooool0i?ooool3o`0009Gooooo0002
ooooo`03ohN7Qolb<S;o000000Kooooo1?l000000ol@413oooooooooo`03ooooo`04ofIVI_l0003o
<S8bonk^kPGooooo00CoIVIVo`000?lb<S;ok^k^1_ooool2o`000>Sooooo0ol0002Booooo`00:?oo
ool00ol0003oooooooooo`3Zooooo`?o0000Soooool002Sooooo00?o0000ooooooooool0kOooool3
o`0008cooooo000Xooooo`03o`000?oooooooooo0?3ooooo0_l0002:ooooo`00:?ooool00ol0003o
ooooooooo`3booooo`;o0000R?ooool002Sooooo0_l0003eooooo`?o0000QOooool002Sooooo00?o
0000ooooooooool0moooool2o`0008?ooooo000Xooooo`03o`000?oooooooooo0?Wooooo0_l00021
ooooo`00:?ooool00ol0003oooooooooo`3kooooo`?o0000O_ooool002Sooooo00?o0000oooooooo
ool0o_ooool3o`0007_ooooo000Xooooo`;o0000ooooool3ooooo`?o0000N?ooool002Sooooo00?o
0000ooooooooool0ooooool5ooooo`?o0000MOooool002Sooooo00?o0000ooooooooool0ooooool8
ooooo`;o0000Loooool002Sooooo00?o0000ooooooooool0ooooool:ooooo`;o0000LOooool002So
oooo00?o0000ooooooooool0ooooool<ooooo`?o0000K_ooool002Sooooo0_l0003ooooooa3ooooo
0_l0001/ooooo`00:?ooool00ol0003oooooooooo`3ooooooa7ooooo0_l0001Zooooo`000_ooool0
0ol@413o0000o`000002o`000003omgMgOoooooooooo00;ooooo00?ogMgMo`000?oMgMd01?ooool0
1_o<c<co8B4Qo`000?l0003o<S8bomgMg@Gooooo00CoIVIVo`000?lb<S;ok^k^1_ooool00ol0003o
ooooooooo`3ooooooa?ooooo00?o0000ooooooooool0Ioooool000Cooooo00?o0000ooooooooool0
1_ooool00olb<S;oQhN7ooooo`03ooooo`06olc<c?nYZJWooooooooooonHV9So8B4Q1?ooool2ohN7
Q`03oooooon7QhOoA4A400Kooooo00?o0000ooooooooool0oooooommooooo`001?ooool00ol0003o
ooooooooo`06ooooo`03oiRHV?lQ8B7ooooo00Sooooo00?o8B4QokZj^_ooool00_ooool01Olb<S;o
oooooooooooooooo000000Kooooo00?o0000ooooooooool0oooooommooooo`001?ooool00ol0003o
ooooooooo`06ooooo`03onk^k_l0003oc<c<00Sooooo00?o8B4QokZj^_ooool00_ooool01_lb<S;o
oooooooooooooooo<S8bokZj^PGooooo0ol0003ooooooggooooo0004ooooo`03o`000?oooooooooo
00Oooooo00?oEEEEofIVI_ooool00oooool01OmVIVKogMgMoooooon7QhOo410@00Cooooo00Ko<S8b
oooooooooooooooooc8b<_nj^[X5ooooo`03o`000?oooooooooo0?ooooooOOooool000Cooooo00?o
0000ooooooooool01oooool00onj^[[o410@ooooo`03ooooo`05o`000?lQ8B7o0000oa0@4?o<c<`0
1?ooool01_lb<S;ooooooooooooooooo<S8bokZj^_ooooooQOooool000Cooooo00?o0000oooooooo
ool02?ooool00ol@413oc<c<ooooo`02ooooo`03o`000?oooooooooo00Kooooo00Go<S8bonk^k_oo
ooook^k^o`00003oooooohKooooo0002ooooo`03ohN7Qonj^[[o000000[ooooo00?oQhN7ofIVI_oo
ool00_ooool00ol0003oooooooooo`06ooooo`05ohN7QomVIVKoooooofIVI_m4A4@0oooooon6oooo
o`000_ooool00on7QhOo<S8bo`000006ooooo`Go000000Co<S8boooooooooooooooo1?l000000ol@
413oooooooooo`03ooooo`04ofIVI_l0003o<S8bonk^k_ooooooQ_ooool00?ooooooZ?ooool00?oo
ooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?oo
ooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?oo
ooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?oo
ooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool003Sooooo00?oc<c<o`00
0?o^k^h0oooooom]ooooo`00>?ooool00oo^k^ko0000oeEEE@3oooooofgooooo00000ooooooo410@
o`000003o`000009oa0@4?oooooooooooooooonHV9So410@o`000?lQ8B7oV9RH00;o000000CogMgM
ooooooooooooMgMg0_l000001_m4A4CoZJVYo`000?l@413ooooooc8b<PGo000000ko410@oooooooo
ooooooooolc<c?l@413o0000oa0@4?mgMgOo0000oa0@4?oooooo0000oc8b<P;o000000?o410@oiRH
V?ooool01?ooool00om4A4Co0000okZj^P0<ooooo`06oa0@4?l0003o0000oeEEEOooooooEEEE0_l0
00000ol@413oooooooooo`3ooooooeGooooo0003ooooo`03o`000?oooooooooo00Cooooo00Ko8B4Q
onk^k_ooooook^k^ogMgMol00003ooooo`07ogMgMomEEEGok^k^ooooooo<c<co8B4Qo`000005oooo
o`03o`000?oooooooooo00Cooooo00Ko8B4QoiRHV?oooooooooooeEEEOl00002ooooo`07o`000?n7
QhOooooooooooooMgMgo410@omgMg@04ooooo`03oiRHV?l0003o<S8b00gooooo00?o410@ojVYZOoo
ool00_ooool00onYZJWo0000onk^kP3ooooooeOooooo0003ooooo`03o`000?oooooooooo00Cooooo
00Ko8B4QojVYZOooooooooooomgMgOl00003ooooo`03ob4Q8Ooooooooooo00;ooooo00?o^[Zjo`00
0?ooool01?ooool00ol0003oooooooooo`04ooooo`06o`000?ooooooooooooooooo^k^ko00000_oo
ool01om4A4Coooooooooooooooook^k^oa0@4?o<c<`05?ooool00omgMgOoIVIVooooo`02ooooo`03
oeEEEOm4A4Cooooo0?ooooooEoooool000?ooooo00?o0000ooooooooool01?ooool01_o<c<coA4A4
o`000?l0003o410@o`0000?ooooo00?o<S8booooooooool00oooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo00Cooooo00Ko0000ooooooooooooooooolc<c?l00002ooooo`06olc<c?lQ
8B7o0000o`000?l@413oMgMg5Oooool00ooMgMgo0000o`000003o`000003ojVYZOoooooooooo0?oo
ooooE_ooool000?ooooo00?o0000olc<c?ooool02Oooool01Ol0003ooooooooooooooooo8B4Q00Co
oooo00?oc<c<o`000?ooool01?ooool00ol0003oooooooooo`04ooooo`06o`000?oooooooooooooo
oon7QhOo00000_ooool00olQ8B7ogMgMooooo`0Iooooo`05oc8b<_nYZJWoooooohN7Qol00000oooo
oomIooooo`000oooool02Ol0003o<S8boiRHV?oooooo^[ZjomgMgOooooooc<c<oiRHV002ooooo`03
ohN7QolQ8B7ooooo00;ooooo00OoZJVYoeEEEOo^k^koooooomgMgOlQ8B7o000000Gooooo00?o0000
ooooooooool01?ooool01_l0003oooooooooooooooooA4A4o`0000;ooooo00Ko8B4Qonk^k_oooooo
k^k^oeEEEOnHV9PFooooo`05oiRHV?mEEEGoooooob4Q8OmEEED0oooooomIooooo`0000Kooooooa0@
4?l0003o0000onk^k_mVIVH2o`000004ojVYZOoooooo^[Zjob4Q8@;o000000?o8B4Qolc<c?ooool0
0oooool01_nYZJWo410@o`000?l0003oMgMgo`0000?ooooo00?o410@o`000?l000001Oooool01?l@
413o0000ooooooooool3o`0000;ooooo00KoV9RHo`000?l0003o410@ob4Q8OmgMgLFooooo`05onk^
k_l@413ogMgMo`000?o<c<`0oooooomIooooo`006Oooool00ol0003oooooooooo`0_ooooo`03oeEE
EOlb<S;o410@0?ooooooF_ooool001Wooooo00?o0000ooooooooool0;Oooool01Onj^[[o0000o`00
0?l0003oMgMg0?ooooooF_ooool001Oooooo00?o410@o`000?l000001Oooool00ol0003oMgMgoooo
o`0Xooooo`04oiRHV?l0003o0000oiRHV?ooooooF_ooool004[ooooo00Co0000olc<c?o^k^ko8B4Q
oooooomJooooo`00B_ooool01?l0003oc<c<onk^k_lQ8B7ooooooe[ooooo001:ooooo`04oiRHV?l0
003o0000oiRHV?ooooooF_ooool00?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?oo
ooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?oo
ooooZ?ooool00?ooooooZ?ooool00001\
\>"],
  ImageRangeCache->{{{0, 422}, {260, 0}} -> {-292.127, -347.4, 10.8192, \
15.0296}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Plot[{rootr2[i/2],rbpb[i]},{i,0.1,200},
\tPlotRange->{0,150},
\tAxesLabel->{\"DNA\\nlength, bp\",\"\[CapitalARing]\"}];\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0047619 0 0.00412023 [
[(0)] .02381 0 0 2 Msboxa
[(50)] .2619 0 0 2 Msboxa
[(100)] .5 0 0 2 Msboxa
[(150)] .7381 0 0 2 Msboxa
[(200)] .97619 0 0 2 Msboxa
[(DNA)(length, bp)] 1.025 0 -1 0 Msboxa
[(20)] .01131 .0824 1 0 Msboxa
[(40)] .01131 .16481 1 0 Msboxa
[(60)] .01131 .24721 1 0 Msboxa
[(80)] .01131 .32962 1 0 Msboxa
[(100)] .01131 .41202 1 0 Msboxa
[(120)] .01131 .49443 1 0 Msboxa
[(140)] .01131 .57683 1 0 Msboxa
[(\\201)] .02381 .61803 0 -4 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 Mshowa
p
.002 w
.2619 0 m
.2619 .00625 L
s
P
[(50)] .2619 0 0 2 Mshowa
p
.002 w
.5 0 m
.5 .00625 L
s
P
[(100)] .5 0 0 2 Mshowa
p
.002 w
.7381 0 m
.7381 .00625 L
s
P
[(150)] .7381 0 0 2 Mshowa
p
.002 w
.97619 0 m
.97619 .00625 L
s
P
[(200)] .97619 0 0 2 Mshowa
p
.001 w
.07143 0 m
.07143 .00375 L
s
P
p
.001 w
.11905 0 m
.11905 .00375 L
s
P
p
.001 w
.16667 0 m
.16667 .00375 L
s
P
p
.001 w
.21429 0 m
.21429 .00375 L
s
P
p
.001 w
.30952 0 m
.30952 .00375 L
s
P
p
.001 w
.35714 0 m
.35714 .00375 L
s
P
p
.001 w
.40476 0 m
.40476 .00375 L
s
P
p
.001 w
.45238 0 m
.45238 .00375 L
s
P
p
.001 w
.54762 0 m
.54762 .00375 L
s
P
p
.001 w
.59524 0 m
.59524 .00375 L
s
P
p
.001 w
.64286 0 m
.64286 .00375 L
s
P
p
.001 w
.69048 0 m
.69048 .00375 L
s
P
p
.001 w
.78571 0 m
.78571 .00375 L
s
P
p
.001 w
.83333 0 m
.83333 .00375 L
s
P
p
.001 w
.88095 0 m
.88095 .00375 L
s
P
p
.001 w
.92857 0 m
.92857 .00375 L
s
P
[(DNA)(length, bp)] 1.025 0 -1 0 Mshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
.02381 .0824 m
.03006 .0824 L
s
P
[(20)] .01131 .0824 1 0 Mshowa
p
.002 w
.02381 .16481 m
.03006 .16481 L
s
P
[(40)] .01131 .16481 1 0 Mshowa
p
.002 w
.02381 .24721 m
.03006 .24721 L
s
P
[(60)] .01131 .24721 1 0 Mshowa
p
.002 w
.02381 .32962 m
.03006 .32962 L
s
P
[(80)] .01131 .32962 1 0 Mshowa
p
.002 w
.02381 .41202 m
.03006 .41202 L
s
P
[(100)] .01131 .41202 1 0 Mshowa
p
.002 w
.02381 .49443 m
.03006 .49443 L
s
P
[(120)] .01131 .49443 1 0 Mshowa
p
.002 w
.02381 .57683 m
.03006 .57683 L
s
P
[(140)] .01131 .57683 1 0 Mshowa
p
.001 w
.02381 .01648 m
.02756 .01648 L
s
P
p
.001 w
.02381 .03296 m
.02756 .03296 L
s
P
p
.001 w
.02381 .04944 m
.02756 .04944 L
s
P
p
.001 w
.02381 .06592 m
.02756 .06592 L
s
P
p
.001 w
.02381 .09889 m
.02756 .09889 L
s
P
p
.001 w
.02381 .11537 m
.02756 .11537 L
s
P
p
.001 w
.02381 .13185 m
.02756 .13185 L
s
P
p
.001 w
.02381 .14833 m
.02756 .14833 L
s
P
p
.001 w
.02381 .18129 m
.02756 .18129 L
s
P
p
.001 w
.02381 .19777 m
.02756 .19777 L
s
P
p
.001 w
.02381 .21425 m
.02756 .21425 L
s
P
p
.001 w
.02381 .23073 m
.02756 .23073 L
s
P
p
.001 w
.02381 .26369 m
.02756 .26369 L
s
P
p
.001 w
.02381 .28018 m
.02756 .28018 L
s
P
p
.001 w
.02381 .29666 m
.02756 .29666 L
s
P
p
.001 w
.02381 .31314 m
.02756 .31314 L
s
P
p
.001 w
.02381 .3461 m
.02756 .3461 L
s
P
p
.001 w
.02381 .36258 m
.02756 .36258 L
s
P
p
.001 w
.02381 .37906 m
.02756 .37906 L
s
P
p
.001 w
.02381 .39554 m
.02756 .39554 L
s
P
p
.001 w
.02381 .4285 m
.02756 .4285 L
s
P
p
.001 w
.02381 .44498 m
.02756 .44498 L
s
P
p
.001 w
.02381 .46147 m
.02756 .46147 L
s
P
p
.001 w
.02381 .47795 m
.02756 .47795 L
s
P
p
.001 w
.02381 .51091 m
.02756 .51091 L
s
P
p
.001 w
.02381 .52739 m
.02756 .52739 L
s
P
p
.001 w
.02381 .54387 m
.02756 .54387 L
s
P
p
.001 w
.02381 .56035 m
.02756 .56035 L
s
P
p
.001 w
.02381 .59331 m
.02756 .59331 L
s
P
p
.001 w
.02381 .60979 m
.02756 .60979 L
s
P
[(\\201)] .02381 .61803 0 -4 Mshowa
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
p
.004 w
.02429 .0007 m
.06395 .05877 L
.10361 .1163 L
.14327 .17331 L
.18294 .2298 L
.2226 .28578 L
.26226 .34125 L
.30192 .39623 L
.34159 .45072 L
.38125 .50473 L
.42091 .55825 L
.46058 .61131 L
s
.46564 .61803 m
.46058 .61131 L
s
s
s
s
s
s
s
s
s
s
s
s
s
s
P
P
p
p
.004 w
.02429 .04809 m
.06395 .06915 L
.10361 .08738 L
.14327 .10411 L
.18294 .11985 L
.2226 .13489 L
.26226 .14936 L
.30192 .16275 L
.34159 .1759 L
.38125 .18879 L
.42091 .20145 L
.46058 .21388 L
.50024 .2261 L
.5399 .23813 L
.57956 .24998 L
.61923 .26166 L
.65889 .27319 L
.69855 .28456 L
.73821 .29579 L
.77788 .3069 L
.81754 .31788 L
.8572 .32874 L
.89687 .33948 L
.93653 .35012 L
.97619 .36066 L
s
P
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{315, 193},
  ImageMargins->{{33, Inherited}, {Inherited, Inherited}},
  ImageRegion->{{-0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007H00018B000`400?l00000o`00003ooooooooI
ooooo`00oooooooIooooo`00oooooooIooooo`00oooooooIooooo`00oooooooIooooo`00oooooooI
ooooo`00oooooooIooooo`00oooooooIooooo`00oooooooIooooo`00oooooooIooooo`00oooooooI
ooooo`007Oooool01?mVIVKo0000oc8b<_o^k^i9ooooo`06olc<c?lQ8B7o0000o`000?lb<S;ogMgM
1Oooool01?mVIVKo0000oc8b<_o^k^i1ooooo`03oa0@4?l0003o000000;o000000?ogMgMoooooooo
ool00_ooool01?mVIVKo0000oc8b<_o^k^h5ooooo`04ofIVI_l0003o<S8bonk^kScooooo00?o410@
o`000?l000000_l000001OoMgMgoooooooooooo<c<co8B4Q00;o000000?o<S8bomgMgOooool01?oo
ool01?mVIVKo0000oc8b<_o^k^hkooooo`03ohN7Qol0003o000000;o000000?o410@ooooooooool0
0oooool01?mVIVKo0000oc8b<_o^k^h5ooooo`04ofIVI_l0003o<S8bonk^kV7ooooo000Looooo`;o
QhN700?oooooohN7Qom4A4@0BOooool01_o<c<coZJVYooooooooooooV9RHob4Q8@Cooooo0_n7QhL0
0oooooooQhN7odA4A013ooooo`03o`000?oooooooooo00Cooooo0_n7QhL00oooooooQhN7odA4A004
ooooo`;oQhN700?oooooohN7Qom4A4@0?_ooool00ol0003oooooooooo`03ooooo`06olc<c?nYZJWo
oooooooooonHV9So8B4Q1?ooool2ohN7Q`03oooooon7QhOoA4A403_ooooo00?ok^k^oc8b<_o<c<`0
1oooool2ohN7Q`03oooooon7QhOoA4A400Cooooo0_n7QhL00oooooooQhN7odA4A01Qooooo`007?oo
ool01Olb<S;ooooooooooooooooo000004kooooo00?o8B4QokZj^_ooool00_ooool01Olb<S;ooooo
oooooooooooo000004?ooooo00?o0000ooooooooool01?ooool01Olb<S;ooooooooooooooooo0000
00Cooooo00Go<S8booooooooooooooooo`00000nooooo`03o`000?oooooooooo00Sooooo00?o8B4Q
okZj^_ooool00_ooool01Olb<S;ooooooooooooooooo000003cooooo00?ok^k^oc8b<_nYZJT01_oo
ool01Olb<S;ooooooooooooooooo000000Cooooo00Go<S8booooooooooooooooo`00001Qooooo`00
7?ooool01_lb<S;ooooooooooooooooo<S8bokZj^Tgooooo00?o8B4QokZj^_ooool00_ooool01_lb
<S;ooooooooooooooooo<S8bokZj^T;ooooo00?o0000ooooooooool01?ooool01_lb<S;ooooooooo
oooooooo<S8bokZj^P?ooooo00Ko<S8boooooooooooooooooc8b<_nj^[Xmooooo`03o`000?oooooo
oooo00Sooooo00?o8B4QokZj^_ooool00_ooool01_lb<S;ooooooooooooooooo<S8bokZj^Scooooo
00?ok^k^ob4Q8OnHV9P01Oooool01_lb<S;ooooooooooooooooo<S8bokZj^P?ooooo00Ko<S8boooo
oooooooooooooc8b<_nj^[XRooooo`05oeEEEOl0003o0000odA4A?o^k^h0<?ooool3o`000003oc8b
<_oooooooooo00?ooooo000Looooo`06oc8b<_oooooooooooooooolb<S;o^[ZjBOooool01OmVIVKo
gMgMoooooon7QhOo410@00Cooooo00Ko<S8boooooooooooooooooc8b<_nj^[Y2ooooo`03o`000?oo
oooooooo00Cooooo00Ko<S8boooooooooooooooooc8b<_nj^[X3ooooo`06oc8b<_oooooooooooooo
oolb<S;o^[Zj?Oooool00ol0003oooooooooo`04ooooo`05ofIVI_oMgMgoooooohN7Qol@41001?oo
ool01_lb<S;ooooooooooooooooo<S8bokZj^Sgooooo00?ok^k^oc8b<_o<c<`01?ooool01_lb<S;o
oooooooooooooooo<S8bokZj^P?ooooo00Ko<S8boooooooooooooooooc8b<_nj^[XUooooo`03ohN7
Qolb<S;ooooo01Gooooo00?oc<c<o`000?o^k^h05oooool00onj^[[o0000ooooo`06ooooo`007?oo
ool01_lb<S;ooooooooooooooooo<S8bokZj^TWooooo00Go0000ob4Q8Ol0003o410@olc<c004oooo
o`06oc8b<_oooooooooooooooolb<S;o^[Zj@_ooool00ol0003oooooooooo`04ooooo`06oc8b<_oo
oooooooooooooolb<S;o^[Zj0oooool01_lb<S;ooooooooooooooooo<S8bokZj^Sgooooo00?o0000
ooooooooool01?ooool01Ol0003o8B4Qo`000?l@413oc<c<00Cooooo00Ko<S8boooooooooooooooo
oc8b<_nj^[Xnooooo`03onk^k_m4A4Cooooo00?ooooo00Ko<S8boooooooooooooooooc8b<_nj^[X3
ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj9_ooool00ol0003oooooooooo`0Dooooo`03onk^
k_l0003oEEEE01Oooooo00?o^[Zjo`000?ooool01_ooool001cooooo00Go<S8bonk^k_ooooook^k^
o`00001:ooooo`03o`000?oooooooooo00Kooooo00Go<S8bonk^k_ooooook^k^o`000013ooooo`03
o`000?oooooooooo00Cooooo00Go<S8bonk^k_ooooook^k^o`000004ooooo`05oc8b<_o^k^kooooo
onk^k_l00000?_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Kooooo00Go<S8b
onk^k_ooooook^k^o`00000looooo`05okZj^_oooooooooooooooolb<S801?ooool01Olb<S;ok^k^
ooooooo^k^ko000000Cooooo00Go<S8bonk^k_ooooook^k^o`000007ooooo`03oa0@4?l0003o0000
00?o000000Go<S8booooooooooooooooofIVIP03o`000005odA4A?nHV9Soooooooooool@41000_l0
00001?oooooo0000o`000?l@4103ooooo`05ofIVI_l0003o0000ofIVI_l000001Oooool02?nHV9So
410@o`000?l@413oEEEEolc<c?oooooo410@0_l000001?oooooo0000o`000?l@4104ooooo`03odA4
A?l0003o^[Zj00gooooo00?o410@o`000?mVIVH00_l000001omgMgOooooooooooooooooo^[Zjo`00
0?nHV9P00_l000000omVIVKoooooooooo`01ooooo`007?ooool01On7QhOoIVIVoooooomVIVKoA4A4
04[ooooo00?o0000ooooooooool01_ooool01On7QhOoIVIVoooooomVIVKoA4A4047ooooo00?oQhN7
okZj^_l000001_ooool01On7QhOoIVIVoooooomVIVKoA4A400Cooooo00GoQhN7ofIVI_ooooooIVIV
odA4A00looooo`03ohN7Qonj^[[o000000Kooooo00?o0000ooooooooool01_ooool01On7QhOoIVIV
oooooomVIVKoA4A403_ooooo00Koc<c<o`000?n7QhOooooookZj^_lQ8B44ooooo`05ohN7QomVIVKo
ooooofIVI_m4A4@01?ooool01On7QhOoIVIVoooooomVIVKoA4A400[ooooo00?o0000ooooooooool0
0oooool01omgMgOoEEEEonk^k_ooooook^k^oiRHV?lb<S800oooool01Ol0003ooooooooooooooooo
000000?ooooo00KoMgMgoeEEEOo^k^kogMgMob4Q8Ol00005ooooo`06o`000?o<c<coooooomgMgOn7
QhOoZJVY0_ooool01Ol0003ooooooooooooooooo000000Gooooo00?oV9RHo`000?lb<S803_ooool0
1?l0003oA4A4onk^k_ooool2ogMgM`;ooooo00?o^[Zjo`000?mgMgL00_ooool2ogMgM`;ooooo000M
ooooo`04ofIVI_l0003o<S8bonk^kT[ooooo1?l000000ol@413oooooooooo`03ooooo`04ofIVI_l0
003o<S8bonk^kT7ooooo00?oQhN7oc8b<_l000001oooool01?mVIVKo0000oc8b<_o^k^h5ooooo`04
ofIVI_l0003o<S8bonk^kScooooo00?oQhN7oc8b<_l000001_ooool4o`000003oa0@4?oooooooooo
00?ooooo00CoIVIVo`000?lb<S;ok^k^??ooool01OnYZJWo8B4Qo`000?l@413oc<c<00Gooooo00Co
IVIVo`000?lb<S;ok^k^1Oooool01?mVIVKo0000oc8b<_o^k^h:ooooo`03o`000?oooooooooo00?o
oooo00?o0000onk^k_ooool01oooool01Ol0003ooooooooooooooooo000000?ooooo00Ko8B4Qoooo
ooooooooooooolc<c?l00005ooooo`03o`000?oooooooooo00Gooooo00Go0000oooooooooooooooo
o`00000Fooooo`03o`000?oMgMgooooo00;ooooo00Go<S8boooooooooooo^[Zjoa0@4004ooooo`7o
8B4Q0Oooool1ooooo`00oooooon2ooooo`03o`000?oooooooooo00?ooooo1ol000001?oMgMgooooo
ooooool00003ooooo`05o`000?oooooooooooooooolb<S801?ooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo00Gooooo00Go0000ooooooooooooooooo`00000Fooooo`03o`000?oooooo
oooo00;ooooo00Go<S8boooooooooooo^[Zjoc8b<P04ooooo`7o<S8b0Oooool1ooooo`00oooooon2
ooooo`03o`000?oooooooooo00?ooooo00?o410@omgMgOooool00_ooool00onHV9So0000ooooo`02
ooooo`05o`000?ooooooooooooooool000000oooool01_lb<S;ooooooooooooooooogMgMo`0000Go
oooo00?o0000ooooooooool01Oooool01Ol0003ooooooooooooooooo000001Kooooo00?o0000omgM
gOooool00_ooool01_lb<S;ooooooooooonj^[[o0000onk^kP;ooooo00?ok^k^ob4Q8Oooool00Ooo
ool00?ooooooP_ooool00ol0003oooooooooo`03ooooo`07ogMgMolQ8B7ogMgMoooooooMgMgo410@
ofIVIP03ooooo`05o`000?n7QhOooooookZj^_l@41000oooool2ogMgM`04ooooooo^k^koA4A4o`00
00?ooooo00?o410@o`000?l000000ol000002OmgMgOooooooooooooooooo0000ohN7Qooooooo^[Zj
oa0@400Fooooo`04o`000?m4A4Cok^k^ooooo`;oMgMg0_ooool00onj^[[o0000odA4A002omgMg@03
odA4A?mgMgOooooo007ooooo003ooooooh;ooooo00?o0000ooooooooool01?ooool01OmgMgOo410@
o`000?l@413oMgMg00?ooooo0_l000001?mVIVKo0000o`000?nj^[X4ooooo`06ofIVI_l0003o0000
oeEEEOl0003o<S8b1?ooool00olb<S;oooooooooo`05ooooo`05o`000?mgMgOo0000o`000?nj^[X0
5_ooool01Ol0003oIVIVo`000?l0003oIVIV00?ooooo00?o410@o`000?mgMgL00_l000000omVIVKo
ooooooooo`01ooooo`00oooooon2ooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00kooooo003ooooooh;ooooo00?o
0000ooooooooool08?ooool00ol@413oooooooooo`05ooooo`03o`000?oooooooooo01Sooooo00?o
0000ooooooooool03_ooool00?ooooooP?ooool00ol@413o0000o`00000Yooooo`03oa0@4?l0003o
oooo01Sooooo00?o410@o`000?ooool03oooool00?oooooofOooool00?oooooofOooool001Oooooo
ool0001Oo`0006?ooooo000Oooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool03Ooo
ool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`1Yooooo`007oooool2o`00057ooooo00?o0000ooooooooool0D?ooool0
0ol0003oooooooooo`1Aooooo`03o`000?oooooooooo053ooooo00?o0000ooooooooool0JOooool0
01oooooo00?o0000ooooool00000oooooongooooo`007oooool00ol0003oooooo`00003ooooookOo
oooo000Oooooo`;o000000?oooooo`000?ooool0ooooooneooooo`007oooool01Ol0003ooooooooo
oooooooo00000?ooooooG?ooool3o`000003oa0@4?nHV9Sooooo00;ooooo0ol00002ooooo`04ofIV
I_l0003ooooooa0@40;o000000CoEEEEooooooooooooEEEE0ol000000ooMgMgoooooooooo`0loooo
o`007oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0?ooooooFOooool01_l0003o
oooooooooonj^[[o8B4QokZj^P;ooooo00Go0000oooooooooooooooookZj^P02o`0000;ooooo00?o
410@ojVYZOooool00oooool00onj^[[o0000omgMg@0oooooo`007oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo0?ooooooFOooool01_l0003ooooooooooooooooogMgModA4A0;ooooo
00Oo0000ooooooooooook^k^oa0@4?m4A4Co000000;ooooo00?oMgMgodA4A?ooool00oooool2oeEE
ED3ooooo000Oooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0oooooomHooooo`03
o`000?oooooooooo00;ooooo00Co<S8boooooooooooo00000_ooool01?mEEEGo0000onk^k_l00002
ooooo`03omgMgOl0003o000000Co000000?ogMgMooooooooool0?_ooool001oooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`3ooooooeOooooo00?o0000ooooooooool00_ooool02_lb
<S;oooooooooool0003oooooojVYZOl0003oZJVYooooool00003ooooo`06oc8b<_nHV9Sooooooooo
oomgMgOo<S8b@Oooool001oooooo0_l00005ooooo`03o`000?oooooooooo0?ooooooEoooool00ol0
003oooooooooo`02ooooo`07ob4Q8Oooooooooooo`000?o^k^ko0000odA4A002ooooo`06o`000?oo
oooooooooooooonHV9So410@0_ooool00ol@413o^[Zjooooo`10ooooo`007oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo0?ooooooE_ooool01_l0003ooooooooooooooooogMgModA4
A0;ooooo00Co0000odA4A?l0003ogMgM0_ooool01_l0003oooooooooooooooook^k^o`0000;oV9RH
00?o410@ooooooooool0@?ooool001oooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`3ooooooeGooooo00Ko0000oooooooooooogMgMob4Q8OnYZJT2ooooo`;o000000GoQhN7oooooooo
ooooooooo`000004ooooo`04oeEEEOl@413o410@oiRHV4;ooooo000Oooooo`03o`000?oooooooooo
00Kooooo00?o0000ooooooooool0oooooomEooooo`Co000000?oQhN7oooooooMgMd00_l000000olb
<S;oooooooooo`03o`0000;ooooo00Go^[Zjo`000?l0003o0000oa0@4013ooooo`007oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo0?oooooo[Oooool001oooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`3oooooojcooooo000Oooooo`;o00002_ooool00ol0003ooooo
ooooo`3ooooooj_ooooo000Oooooo`04o`000?oooooo0000o`0000Sooooo00?o0000ooooooooool0
oooooon[ooooo`007oooool01?l0003oooooooooooooool2o`0000Oooooo00?o0000ooooooooool0
oooooonZooooo`007oooool00ol0003oooooooooo`03ooooo`;o00001_ooool00ol0003ooooooooo
o`3oooooojWooooo000Oooooo`03o`000?oooooooooo00Gooooo0_l00004ooooo`03o`000?oooooo
oooo0?ooooooZOooool001oooooo00?o0000ooooooooool01oooool2o`0000?ooooo00?o0000oooo
ooooool0oooooonXooooo`007oooool2o`0000[ooooo0_l00002ooooo`03o`000?oooooooooo0?oo
ooooYoooool001oooooo00?o0000ooooooooool02oooool3o`000?ooooooZOooool001oooooo00?o
0000ooooooooool03Oooool3o`000?ooooooYoooool000[ooooo00?oQhN7o`000?l000000_l00000
0ol@413oooooooooo`03ooooo`04ofIVI_l0003o<S8bonk^kPKooooo00?o0000ooooooooool03ooo
ool3o`000?ooooooYOooool000[ooooo00?ok^k^oc8b<_o<c<`01oooool2ohN7Q`03oooooon7QhOo
A4A400Kooooo00?o0000ooooooooool04?ooool01?l0003oooooo`000?l0003ooooooj?ooooo000;
ooooo`03onk^k_lb<S;oZJVY00Kooooo00Go<S8booooooooooooooooo`000006ooooo`?o00004?oo
ool01?l0003oooooooooooooool3o`000?ooooooX?ooool000cooooo00?ok^k^ob4Q8OnHV9P01Ooo
ool01_lb<S;ooooooooooooooooo<S8bokZj^PGooooo00?o0000ooooooooool04Oooool00ol0003o
ooooooooo`03ooooo`;o0000oooooonNooooo`003Oooool00oo^k^ko<S8bolc<c004ooooo`06oc8b
<_oooooooooooooooolb<S;o^[Zj1Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo
00Cooooo0_l0003ooooooicooooo000>ooooo`03onk^k_m4A4Cooooo00?ooooo00Ko<S8boooooooo
oooooooooc8b<_nj^[X5ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool01_ooool3
o`000?ooooooVOooool000_ooooo00Go^[Zjoooooooooooooooooc8b<P04ooooo`05oc8b<_o^k^ko
ooooonk^k_l000001_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Sooooo0_l0
003ooooooiOooooo000:ooooo`06olc<c?l0003oQhN7oooooonj^[[o8B4Q1?ooool01On7QhOoIVIV
oooooomVIVKoA4A400Kooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`09ooooo`;o
0000oooooonEooooo`002oooool01OnYZJWo8B4Qo`000?l@413oc<c<00Gooooo00CoIVIVo`000?lb
<S;ok^k^1_ooool2o`0001Gooooo00?o0000ooooooooool02oooool3o`000?ooooooT_ooool001oo
oooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`0=ooooo`;o0000oooooon@ooooo`00
7oooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00kooooo0_l0003oooooohkooooo
000Oooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool03oooool3o`000?ooooooRooo
ool001oooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Booooo`;o0000oooooon9
ooooo`007oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo01?ooooo0_l0003ooooo
ohOooooo000Oooooo`;o00006_ooool00ol0003oooooooooo`0Dooooo`?o0000oooooon4ooooo`00
7oooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo01Oooooo0_l0003ooooooh;ooooo
000Oooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool06?ooool2o`000?ooooooP?oo
ool001oooooo00?o0000ooooooooool06oooool00ol0003oooooooooo`0Iooooo`?o0000oooooomm
ooooo`007oooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo01cooooo0ol0003ooooo
og[ooooo000Oooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool07_ooool2o`000?oo
ooooN?ooool001oooooo0_l0000Nooooo`03o`000?oooooooooo01oooooo0ol0003oooooogGooooo
000Oooooo`03o`000?oooooooooo01kooooo00?o0000ooooooooool08Oooool2o`000?ooooooLooo
ool001oooooo00?o0000ooooooooool07_ooool00ol0003oooooooooo`0Sooooo`?o0000oooooom`
ooooo`007oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo02Gooooo0ol0003ooooo
ofgooooo000Oooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool09oooool3o`000?oo
ooooJ_ooool001oooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`0Zooooo`?o0000
oooooomWooooo`007oooool2o`0002;ooooo00?o0000ooooooooool0;?ooool2o`000?ooooooIOoo
ool001oooooo00?o0000ooooooooool08_ooool00ol0003oooooooooo`0]ooooo`?o0000oooooomR
ooooo`007oooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo033ooooo0ol0003ooooo
oeoooooo000=ooooo`?o00001Oooool01?mVIVKo0000oc8b<_o^k^h6ooooo`03o`000?oooooooooo
02?ooooo00?o0000ooooooooool0<_ooool3o`000?ooooooG?ooool000kooooo00?o0000oooooooo
ool00oooool2ohN7Q`03oooooon7QhOoA4A400Kooooo00?o0000ooooooooool09?ooool00ol0003o
ooooooooo`0dooooo`?o0000oooooomIooooo`002_ooool00olb<S;o0000o`000003o`0000Cooooo
00Go<S8booooooooooooooooo`000006ooooo`?o00009Oooool00ol0003oooooooooo`0fooooo`?o
0000oooooomFooooo`002_ooool01_mEEEGoMgMgoooooooooooo0000omgMg@Cooooo00Ko<S8boooo
oooooooooooooc8b<_nj^[X5ooooo`03o`000?oooooooooo02Gooooo00?o0000ooooooooool0>Ooo
ool3o`000?ooooooDoooool000[ooooo00Gok^k^o`000?oMgMgoooooo`000005ooooo`06oc8b<_oo
oooooooooooooolb<S;o^[Zj1Oooool00ol0003oooooooooo`0Vooooo`03o`000?oooooooooo03_o
oooo1?l0003oooooodoooooo000;ooooo`04oiRHV?m4A4Coooooo`0000Gooooo00Ko<S8boooooooo
oooooooooc8b<_nj^[X5ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool0?_ooool3
o`000?ooooooC?ooool000cooooo00?o<S8bokZj^_l000001Oooool01Olb<S;ok^k^ooooooo^k^ko
000000Kooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`11ooooo`?o0000oooooom9
ooooo`003?ooool00oo<c<co8B4Qo`000005ooooo`05ohN7QomVIVKoooooofIVI_m4A4@01_ooool0
0ol0003oooooooooo`0Xooooo`03o`000?oooooooooo04?ooooo0ol0003oooooodKooooo000=oooo
o`03ofIVI_l0003ooooo00Gooooo00CoIVIVo`000?lb<S;ok^k^1_ooool2o`0002[ooooo00?o0000
ooooooooool0AOooool3o`000?oooooo@oooool001oooooo00?o0000ooooooooool0:Oooool00ol0
003oooooooooo`18ooooo`?o0000oooooom0ooooo`007oooool00ol0003oooooooooo`0Zooooo`03
o`000?oooooooooo04[ooooo0ol0003oooooocgooooo000Oooooo`03o`000?oooooooooo02_ooooo
00?o0000ooooooooool0C?ooool3o`000?oooooo>_ooool001oooooo00?o0000ooooooooool0;?oo
ool00ol0003oooooooooo`1>ooooo`?o0000oooooolgooooo`007oooool00ol0003oooooooooo`0/
ooooo`03o`000?oooooooooo057ooooo1?l0003ooooooc?ooooo000Oooooo`;o0000;_ooool00ol0
003oooooooooo`1Dooooo`?o0000ooooool`ooooo`007oooool00ol0003oooooooooo`0^ooooo`03
o`000?oooooooooo05Kooooo1?l0003oooooobcooooo000Oooooo`03o`000?oooooooooo02kooooo
00?o0000ooooooooool0F_ooool3o`000?oooooo:Oooool001oooooo00?o0000ooooooooool0;ooo
ool00ol0003oooooooooo`1Looooo`Co0000oooooolUooooo`007oooool00ol0003oooooooooo`0`
ooooo`03o`000?oooooooooo05oooooo0ol0003oooooob;ooooo000Oooooo`03o`000?oooooooooo
033ooooo00?o0000ooooooooool0H_ooool3o`000?oooooo7oooool001oooooo0_l0000booooo`03
o`000?oooooooooo06Cooooo0ol0003ooooooacooooo000Oooooo`03o`000?oooooooooo03;ooooo
00?o0000ooooooooool0I_ooool3o`000?oooooo6Oooool001oooooo00?o0000ooooooooool0<ooo
ool00ol0003oooooooooo`1Xooooo`;o0000oooooolGooooo`007oooool00ol0003oooooooooo`0c
ooooo`03o`000?oooooooooo06[ooooo0ol0003ooooooaCooooo000Oooooo`03o`000?oooooooooo
03Cooooo00?o0000ooooooooool0K?ooool3o`000?oooooo4Oooool001oooooo0_l0000fooooo`03
o`000?oooooooooo06kooooo0ol0003oooooo`kooooo000Oooooo`03o`000?oooooooooo03Gooooo
00?o0000ooooooooool0LOooool4o`000?oooooo2_ooool001oooooo00?o0000ooooooooool0=_oo
ool00ol0003oooooooooo`1dooooo`?o0000ooooool7ooooo`007oooool00ol0003oooooooooo`0g
ooooo`03o`000?oooooooooo07Kooooo1?l0003oooooo`?ooooo000<ooooo`04ofIVI_l0003o410@
olc<c0Gooooo00CoIVIVo`000?lb<S;ok^k^1_ooool00ol0003oooooooooo`0gooooo`03o`000?oo
oooooooo07[ooooo0ol0003oooooo`002oooool01OmgMgOoZJVYooooooo<c<co000000Cooooo0_n7
QhL00oooooooQhN7odA4A006ooooo`03o`000?oooooooooo03Sooooo00?o0000ooooooooool0O?oo
ool4o`000?_ooooo000;ooooo`06odA4A?oooooooooooooooolb<S;o^[Zj0oooool01Olb<S;ooooo
oooooooooooo000000Kooooo0ol0000iooooo`03o`000?oooooooooo07oooooo0ol0003hooooo`00
2oooool01_lQ8B7ooooooooooooooooo8B4QokZj^P?ooooo00Ko<S8boooooooooooooooooc8b<_nj
^[X5ooooo`03o`000?oooooooooo03Wooooo00?o0000ooooooooool0P_ooool4o`000?Cooooo000;
ooooo`05o`000?nHV9SooooooiRHV?l@41001?ooool01_lb<S;ooooooooooooooooo<S8bokZj^PGo
oooo00?o0000ooooooooool0>_ooool00ol0003oooooooooo`25ooooo`?o0000lOooool000_ooooo
00GoA4A4oc8b<_l0003o8B4Qolc<c004ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj1Oooool0
0ol0003oooooooooo`0kooooo`03o`000?oooooooooo08Oooooo1?l0003]ooooo`002oooool00omg
MgOoc<c<ooooo`06ooooo`05oc8b<_o^k^koooooonk^k_l000001_ooool00ol0003oooooooooo`0k
ooooo`03o`000?oooooooooo08_ooooo0ol0003Zooooo`002oooool01?o^k^ko410@oiRHV?o^k^h5
ooooo`05ohN7QomVIVKoooooofIVI_m4A4@01_ooool00ol0003oooooooooo`0looooo`03o`000?oo
oooooooo08gooooo1?l0003Vooooo`003?ooool01OoMgMgoA4A4o`000?l0003ogMgM00Cooooo00Co
IVIVo`000?lb<S;ok^k^1_ooool2o`0003gooooo00?o0000ooooooooool0TOooool3o`000>?ooooo
000Oooooo`03o`000?oooooooooo03gooooo00?o0000ooooooooool0Toooool4o`000=oooooo000O
ooooo`03o`000?oooooooooo03kooooo00?o0000ooooooooool0U_ooool3o`000=cooooo000Ooooo
o`03o`000?oooooooooo03kooooo00?o0000ooooooooool0VOooool4o`000=Sooooo000Oooooo`03
o`000?oooooooooo03oooooo00?o0000ooooooooool0W?ooool3o`000=Gooooo000Oooooo`03o`00
0?oooooooooo043ooooo00?o0000ooooooooool0W_ooool4o`000=7ooooo000Oooooo`;o0000@Ooo
ool00ol0003oooooooooo`2Rooooo`?o0000c_ooool001oooooo00?o0000ooooooooool0@Oooool0
0ol0003oooooooooo`2Tooooo`Co0000b_ooool001oooooo00?o0000ooooooooool0@_ooool00ol0
003oooooooooo`2Wooooo`?o0000aoooool001oooooo00?o0000ooooooooool0@_ooool00ol0003o
ooooooooo`2Zooooo`Co0000`oooool001oooooo00?o0000ooooooooool0@oooool00ol0003ooooo
ooooo`2]ooooo`?o0000`?ooool001oooooo0_l00015ooooo`03o`000?oooooooooo0:oooooo1?l0
002looooo`007oooool00ol0003oooooooooo`15ooooo`03o`000?oooooooooo0;;ooooo0ol0002i
ooooo`007oooool00ol0003oooooooooo`15ooooo`03o`000?oooooooooo0;Gooooo1?l0002eoooo
o`007oooool00ol0003oooooooooo`16ooooo`03o`000?oooooooooo0;Sooooo0ol0002booooo`00
7oooool00ol0003oooooooooo`17ooooo`03o`000?oooooooooo0;[ooooo1?l0002^ooooo`007ooo
ool00ol0003oooooooooo`18ooooo`03o`000?oooooooooo0;gooooo0ol0002[ooooo`007oooool2
o`0004Wooooo00?o0000ooooooooool0`?ooool3o`000:Sooooo000Oooooo`03o`000?oooooooooo
04Wooooo00?o0000ooooooooool0`_ooool3o`000:Gooooo000Oooooo`03o`000?oooooooooo04[o
oooo00?o0000ooooooooool0a?ooool4o`000:7ooooo000;ooooo`05olc<c?lb<S;o0000oa0@4?nY
ZJT01Oooool01?mVIVKo0000oc8b<_o^k^h6ooooo`03o`000?oooooooooo04[ooooo00?o0000oooo
ooooool0b?ooool3o`0009kooooo000;ooooo`06oc8b<_nYZJWooooookZj^_l0003ok^k^0oooool2
ohN7Q`03oooooon7QhOoA4A400Kooooo00?o0000ooooooooool0Boooool00ol0003oooooooooo`3:
ooooo`Co0000V_ooool000_ooooo00Ko0000ooooooooooooooooo`000?nj^[X3ooooo`05oc8b<_oo
ooooooooooooool000001_ooool00ol0003oooooooooo`1<ooooo`03o`000?oooooooooo0<gooooo
0ol0002Gooooo`002oooool01_lb<S;oV9RHoooooon7QhOo0000onk^kP?ooooo00Ko<S8boooooooo
oooooooooc8b<_nj^[X5ooooo`?o0000COooool00ol0003oooooooooo`3?ooooo`Co0000Toooool0
00_ooooo00Gok^k^o`000?l0003o0000okZj^P04ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj
1Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0=?ooooo1Ol0002>ooooo`002ooo
ool01OmVIVKoV9RHoooooonHV9SoA4A400Cooooo00Ko<S8boooooooooooooooooc8b<_nj^[X5oooo
o`03o`000?oooooooooo04kooooo00?o0000ooooooooool0eoooool5o`0008Wooooo000;ooooo`05
ob4Q8OoooooooooooooooolQ8B401?ooool01Olb<S;ok^k^ooooooo^k^ko000000Kooooo00?o0000
ooooooooool0Coooool00ol0003oooooooooo`3Kooooo`Co0000QOooool000_ooooo00Go8B4Qoooo
ooooooooooooob4Q8@04ooooo`05ohN7QomVIVKoooooofIVI_m4A4@01_ooool00ol0003ooooooooo
o`1@ooooo`03o`000?oooooooooo0=kooooo0ol00022ooooo`002oooool01Om4A4CoV9RHoooooonH
V9SoA4A400Gooooo00CoIVIVo`000?lb<S;ok^k^1_ooool00ol0003oooooooooo`1@ooooo`03o`00
0?oooooooooo0>7ooooo1?l0001nooooo`002oooool01Oo^k^ko<S8bo`000?lb<S;ok^k^00oooooo
0_l0001Booooo`03o`000?oooooooooo0>Cooooo0ol0001kooooo`007oooool00ol0003ooooooooo
o`1Booooo`03o`000?oooooooooo0>Kooooo1?l0001gooooo`007oooool00ol0003oooooooooo`1C
ooooo`03o`000?oooooooooo0>Wooooo0ol0001dooooo`007oooool00ol0003oooooooooo`1Coooo
o`03o`000?oooooooooo0>cooooo1?l0001`ooooo`007oooool00ol0003oooooooooo`1Dooooo`03
o`000?oooooooooo0>oooooo0ol0001]ooooo`007oooool2o`0005Kooooo00?o0000ooooooooool0
lOooool2o`0006_ooooo000Oooooo`03o`000?oooooooooo05Kooooo00?o0000ooooooooool0oooo
oomNooooo`007oooool00ol0003oooooooooo`1Fooooo`03o`000?oooooooooo0?ooooooG_ooool0
01oooooo00?o0000ooooooooool0Eoooool00ol0003oooooooooo`3ooooooegooooo000Oooooo`03
o`000?oooooooooo05Sooooo00?o0000ooooooooool0oooooomLooooo`007oooool00ol0003ooooo
ooooo`1Hooooo`03o`000?oooooooooo0?ooooooG?ooool001oooooo0_l0001Jooooo`03o`000?oo
oooooooo0?ooooooFoooool001oooooo00?o0000ooooooooool0F_ooool00ol0003oooooooooo`3o
oooooe[ooooo000Oooooo`03o`000?oooooooooo05_ooooo00?o0000ooooooooool0oooooomIoooo
o`007oooool00ol0003oooooooooo`1Kooooo`03o`000?oooooooooo0?ooooooFOooool001oooooo
00?o0000ooooooooool0G?ooool00ol0003oooooooooo`3ooooooeSooooo000Oooooo`03o`000?oo
oooooooo05gooooo00?o0000ooooooooool0oooooomGooooo`007oooool2o`0005oooooo00?o0000
ooooooooool0oooooomFooooo`007oooool00ol0003oooooooooo`1Nooooo`03o`000?oooooooooo
0?ooooooE_ooool001oooooo00?o0000ooooooooool0Goooool00ol0003oooooooooo`3ooooooeGo
oooo0002ooooo`03oa0@4?l0003o000000;o000000?ogMgMooooooooool00_ooool01?mVIVKo0000
oc8b<_o^k^h5ooooo`04ofIVI_l0003o<S8bonk^kPKooooo00?o0000ooooooooool0H?ooool00ol0
003oooooooooo`3ooooooeCooooo0004ooooo`03o`000?oooooooooo00Cooooo0_n7QhL00ooooooo
QhN7odA4A004ooooo`;oQhN700?oooooohN7Qom4A4@01_ooool00ol0003oooooooooo`1Qooooo`03
o`000?oooooooooo0?ooooooDoooool000Cooooo00?o0000ooooooooool01?ooool01Olb<S;ooooo
oooooooooooo000000Cooooo00Go<S8booooooooooooooooo`000006ooooo`03o`000?oooooooooo
067ooooo00?o0000ooooooooool0oooooomCooooo`001?ooool00ol0003oooooooooo`04ooooo`06
oc8b<_oooooooooooooooolb<S;o^[Zj0oooool01_lb<S;ooooooooooooooooo<S8bokZj^PGooooo
0ol0001Rooooo`03o`000?oooooooooo0?ooooooD_ooool000Cooooo00?o0000ooooooooool01?oo
ool01_lb<S;ooooooooooooooooo<S8bokZj^P?ooooo00Ko<S8boooooooooooooooooc8b<_nj^[X5
ooooo`03o`000?oooooooooo06?ooooo00?o0000ooooooooool0oooooomAooooo`001?ooool00ol0
003oooooooooo`04ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj0oooool01_lb<S;ooooooooo
oooooooo<S8bokZj^PGooooo00?o0000ooooooooool0I?ooool00ol0003oooooooooo`3ooooooe3o
oooo0004ooooo`03o`000?oooooooooo00Cooooo00Go<S8bonk^k_ooooook^k^o`000004ooooo`05
oc8b<_o^k^koooooonk^k_l000001_ooool00ol0003oooooooooo`1Tooooo`03o`000?oooooooooo
0?ooooooD?ooool000;ooooo00?oQhN7okZj^_l000001_ooool01On7QhOoIVIVoooooomVIVKoA4A4
00Cooooo00GoQhN7ofIVI_ooooooIVIVodA4A006ooooo`03o`000?oooooooooo06Gooooo00?o0000
ooooooooool0oooooom?ooooo`000_ooool00on7QhOo<S8bo`000007ooooo`04ofIVI_l0003o<S8b
onk^kPGooooo00CoIVIVo`000?lb<S;ok^k^1_ooool00ol0003oooooooooo`1Vooooo`03o`000?oo
oooooooo0?ooooooC_ooool001oooooo0_l0001Wooooo`03o`000?oooooooooo0?ooooooC_ooool0
01oooooo00?o0000ooooooooool0Ioooool00ol0003oooooooooo`3oooooodgooooo000Oooooo`03
o`000?oooooooooo06Sooooo00?o0000ooooooooool0oooooom<ooooo`007oooool00ol0003ooooo
ooooo`1Yooooo`03o`000?oooooooooo0?ooooooBoooool001oooooo00?o0000ooooooooool0JOoo
ool00ol0003oooooooooo`3ooooood_ooooo000Oooooo`;o0000Joooool00ol0003oooooooooo`3o
oooood[ooooo000Oooooo`03o`000?oooooooooo06_ooooo00?o0000ooooooooool0oooooom9oooo
o`007oooool00ol0003oooooooooo`1/ooooo`03o`000?oooooooooo0?ooooooB?ooool001oooooo
00?o0000ooooooooool0K?ooool00ol0003oooooooooo`3oooooodSooooo000Oooooo`03o`000?oo
oooooooo06gooooo00?o0000ooooooooool0oooooom7ooooo`007oooool00ol0003oooooooooo`1^
ooooo`03o`000?oooooooooo0?ooooooA_ooool001oooooo0_l0001`ooooo`03o`000?oooooooooo
0?ooooooAOooool001oooooo00?o0000ooooooooool0Koooool00ol0003oooooooooo`3oooooodGo
oooo000Oooooo`03o`000?oooooooooo073ooooo00?o0000ooooooooool0oooooom4ooooo`007ooo
ool00ol0003oooooooooo`1aooooo`03o`000?oooooooooo0?oooooo@oooool001oooooo00?o0000
ooooooooool0L_ooool00ol0003oooooooooo`3ooooood;ooooo000Oooooo`03o`000?oooooooooo
07;ooooo00?o0000ooooooooool0oooooom2ooooo`007oooool2o`0007Cooooo00?o0000oooooooo
ool0oooooom1ooooo`007oooool00ol0003oooooooooo`1dooooo`03o`000?oooooooooo0?oooooo
@?ooool001oooooo00?o0000ooooooooool0M?ooool00ol0003oooooooooo`3ooooood3ooooo0002
ooooo`03oa0@4?l0003o000000;o000000CogMgMooooooooooooQhN71?l000000ol@413ooooooooo
o`03ooooo`04ofIVI_l0003o<S8bonk^kPKooooo00?o0000ooooooooool0MOooool00ol0003ooooo
ooooo`3oooooocoooooo0004ooooo`03o`000?oooooooooo00?ooooo00?ok^k^oc8b<_o<c<`01ooo
ool2ohN7Q`03oooooon7QhOoA4A400Kooooo00?o0000ooooooooool0M_ooool00ol0003ooooooooo
o`3oooooockooooo0004ooooo`03o`000?oooooooooo00Cooooo00?ok^k^oc8b<_nYZJT01_ooool0
1Olb<S;ooooooooooooooooo000000Kooooo00?o0000ooooooooool0Moooool00ol0003ooooooooo
o`3oooooocgooooo0004ooooo`03o`000?oooooooooo00Gooooo00?ok^k^ob4Q8OnHV9P01Oooool0
1_lb<S;ooooooooooooooooo<S8bokZj^PGooooo0ol0001gooooo`03o`000?oooooooooo0?oooooo
?Oooool000Cooooo00?o0000ooooooooool01_ooool00oo^k^ko<S8bolc<c004ooooo`06oc8b<_oo
oooooooooooooolb<S;o^[Zj1Oooool00ol0003oooooooooo`1hooooo`03o`000?oooooooooo0?oo
oooo??ooool000Cooooo00?o0000ooooooooool01oooool00oo^k^koA4A4ooooo`03ooooo`06oc8b
<_oooooooooooooooolb<S;o^[Zj1Oooool00ol0003oooooooooo`1iooooo`03o`000?oooooooooo
0?oooooo>oooool000Cooooo00?o0000ooooooooool01?ooool01Onj^[[ooooooooooooooooo<S8b
00Cooooo00Go<S8bonk^k_ooooook^k^o`000006ooooo`03o`000?oooooooooo07[ooooo00?o0000
ooooooooool0ooooooljooooo`000_ooool00on7QhOo^[Zjo`000005ooooo`06olc<c?l0003oQhN7
oooooonj^[[o8B4Q1?ooool01On7QhOoIVIVoooooomVIVKoA4A400Kooooo00?o0000ooooooooool0
N_ooool00ol0003oooooooooo`3ooooooc[ooooo0002ooooo`03ohN7Qolb<S;o000000Kooooo00Go
ZJVYob4Q8Ol0003o410@olc<c005ooooo`04ofIVI_l0003o<S8bonk^kPKooooo0_l0001looooo`03
o`000?oooooooooo0?oooooo>Oooool001oooooo00?o0000ooooooooool0O?ooool00ol0003ooooo
ooooo`3oooooocSooooo000Oooooo`03o`000?oooooooooo07gooooo00?o0000ooooooooool0oooo
oolgooooo`007oooool00ol0003oooooooooo`1mooooo`03o`000?oooooooooo0?oooooo=oooool0
01oooooo00?o0000ooooooooool0O_ooool00ol0003oooooooooo`3oooooocKooooo000Oooooo`03
o`000?oooooooooo07oooooo00?o0000ooooooooool0ooooooleooooo`007oooool2o`00087ooooo
00?o0000ooooooooool0ooooooldooooo`007oooool00ol0003oooooooooo`20ooooo`03o`000?oo
oooooooo0?oooooo=?ooool001oooooo00?o0000ooooooooool0POooool00ol0003oooooooooo`3o
oooooc?ooooo000Oooooo`03o`000?oooooooooo08;ooooo00?o0000ooooooooool0oooooolboooo
o`007oooool00ol0003oooooooooo`22ooooo`03o`000?oooooooooo0?oooooo<_ooool001oooooo
00?o0000ooooooooool0Poooool00ol0003oooooooooo`3ooooooc7ooooo000Oooooo`;o0000QOoo
ool00ol0003oooooooooo`3ooooooc3ooooo000Oooooo`03o`000?oooooooooo08Gooooo00?o0000
ooooooooool0ooooool_ooooo`007oooool00ol0003oooooooooo`25ooooo`03o`000?oooooooooo
0?oooooo;oooool001oooooo00?o0000ooooooooool0Q_ooool00ol0003oooooooooo`3oooooobko
oooo000Oooooo`03o`000?oooooooooo08Oooooo00?o0000ooooooooool0ooooool]ooooo`007ooo
ool00ol0003oooooooooo`28ooooo`03o`000?oooooooooo0?oooooo;?ooool001oooooo0_l00029
ooooo`03o`000?oooooooooo0?oooooo;?ooool001oooooo00?o0000ooooooooool0ROooool00ol0
003oooooooooo`3oooooob_ooooo000Oooooo`03o`000?oooooooooo08[ooooo00?o0000oooooooo
ool0oooooolZooooo`000_ooool00ol@413o0000o`000002o`000003omgMgOoooooooooo00?ooooo
0ol00005ooooo`04ofIVI_l0003o<S8bonk^kPKooooo00?o0000ooooooooool0Roooool00ol0003o
ooooooooo`3oooooobWooooo0004ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
0oooool2ohN7Q`03oooooon7QhOoA4A400Kooooo00?o0000ooooooooool0S?ooool00ol0003ooooo
ooooo`3oooooobSooooo0004ooooo`03o`000?oooooooooo00?ooooo00?o<S8bo`000?l000000ol0
0004ooooo`05oc8b<_ooooooooooooooool000001_ooool3o`0008cooooo00?o0000ooooooooool0
oooooolXooooo`001?ooool00ol0003oooooooooo`03ooooo`06oeEEEOmgMgOoooooooooool0003o
gMgM1?ooool01_lb<S;ooooooooooooooooo<S8bokZj^PGooooo00?o0000ooooooooool0SOooool0
0ol0003oooooooooo`3oooooobOooooo0004ooooo`03o`000?oooooooooo00?ooooo00Gok^k^o`00
0?oMgMgoooooo`000005ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj1Oooool00ol0003ooooo
ooooo`2>ooooo`03o`000?oooooooooo0?oooooo9_ooool000Cooooo00?o0000ooooooooool01?oo
ool01?nHV9SoA4A4ooooool00005ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj1Oooool00ol0
003oooooooooo`2?ooooo`03o`000?oooooooooo0?oooooo9Oooool000Cooooo00?o0000oooooooo
ool01Oooool00olb<S;o^[Zjo`000005ooooo`05oc8b<_o^k^koooooonk^k_l000001_ooool00ol0
003oooooooooo`2?ooooo`03o`000?oooooooooo0?oooooo9Oooool000;ooooo00?oQhN7okZj^_l0
00001oooool00oo<c<co8B4Qo`000005ooooo`05ohN7QomVIVKoooooofIVI_m4A4@01_ooool00ol0
003oooooooooo`2@ooooo`03o`000?oooooooooo0?oooooo9?ooool000;ooooo00?oQhN7oc8b<_l0
00002?ooool00omVIVKo0000ooooo`05ooooo`04ofIVI_l0003o<S8bonk^kPKooooo0_l0002Boooo
o`03o`000?oooooooooo0?oooooo8oooool001oooooo00?o0000ooooooooool0T_ooool00ol0003o
ooooooooo`3oooooob;ooooo000Oooooo`03o`000?oooooooooo09?ooooo00?o0000ooooooooool0
oooooolQooooo`007oooool00ol0003oooooooooo`2Cooooo`03o`000?oooooooooo0?oooooo8Ooo
ool001oooooo00?o0000ooooooooool0U?ooool00ol0003oooooooooo`3oooooob3ooooo000Ooooo
o`03o`000?oooooooooo09Gooooo00?o0000ooooooooool0oooooolOooooo`007oooool2o`0009Oo
oooo00?o0000ooooooooool0oooooolNooooo`007oooool00ol0003oooooooooo`2Fooooo`03o`00
0?oooooooooo0?oooooo7_ooool001oooooo00?o0000ooooooooool0Uoooool00ol0003ooooooooo
o`3ooooooagooooo000Oooooo`03o`000?oooooooooo09Oooooo00?o0000ooooooooool0oooooolM
ooooo`00oooooooIooooo`00oooooooIooooo`00oooooooIooooo`00oooooooIooooo`00oooooooI
ooooo`00oooooooIooooo`00oooooooIooooo`00oooooooIooooo`00oooooooIooooo`00oooooooI
ooooo`00oooooooIooooo`00oooooooIooooo`00oooooooIooooo`00oooooooIooooo`00oooooooI
ooooo`00oooooooIooooo`00oooooooIooooo`00oooooooIooooo`00oooooooIooooo`00oooooooI
ooooo`00oooooooIooooo`00oooooooIooooo`00oooooooIooooo`00oooooooIooooo`00oooooooI
ooooo`00oooooooIooooo`006_ooool01_l@413o0000o`000?mEEEGooooooeEEE@;o000000?o410@
ooooooooool0oooooondooooo`006oooool00ol@413oZJVYooooo`02ooooo`03ojVYZOl0003ok^k^
0?oooooo]_ooool001_ooooo00?oMgMgofIVI_ooool00_ooool00omEEEGoA4A4ooooo`3ooooookKo
oooo000Kooooo`03omgMgOl0003o000000?o000000?oZJVYooooooooool0ooooooneooooo`007?oo
ool01Olb<S;oZJVYoooooon7QhOo00000?oooooo^?ooool001cooooo00GoV9RHoeEEEOoooooo8B4Q
oeEEE@3ooooookSooooo000Looooo`05onk^k_l@413ogMgMo`000?o<c<`0oooooonhooooo`007Ooo
ool00omEEEGo<S8boa0@403ooooookWooooo000Kooooo`05okZj^_l0003o0000o`000?mgMgL0oooo
ooniooooo`007?ooool01?nHV9So0000o`000?nHV9SooooookWooooo000Looooo`04o`000?o<c<co
k^k^ob4Q8Ooooooo^Oooool001cooooo00Co0000olc<c?o^k^ko8B4Qooooooniooooo`007?ooool0
1?nHV9So0000o`000?nHV9SooooookWooooo003oooooomWooooo003oooooomWooooo003oooooomWo
oooo003oooooomWooooo0000\
\>"],
  ImageRangeCache->{{{0, 471.5}, {288.5, 0}} -> {-18.8395, -19.9077, 0.90075, \
1.04103}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Plot[{rootr2[i/2],rbpb[i]},{i,0.1,20},
\tAxesLabel->{\"DNA\\nlength, bp\",\"\[CapitalARing]\"}];\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.047619 0.0147151 0.0175042 [
[(5)] .2619 .01472 0 2 Msboxa
[(10)] .5 .01472 0 2 Msboxa
[(15)] .7381 .01472 0 2 Msboxa
[(20)] .97619 .01472 0 2 Msboxa
[(DNA)(length, bp)] 1.025 .01472 -1 0 Msboxa
[(5)] .01131 .10224 1 0 Msboxa
[(10)] .01131 .18976 1 0 Msboxa
[(15)] .01131 .27728 1 0 Msboxa
[(20)] .01131 .3648 1 0 Msboxa
[(25)] .01131 .45232 1 0 Msboxa
[(30)] .01131 .53984 1 0 Msboxa
[(\\201)] .02381 .61803 0 -4 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.2619 .01472 m
.2619 .02097 L
s
P
[(5)] .2619 .01472 0 2 Mshowa
p
.002 w
.5 .01472 m
.5 .02097 L
s
P
[(10)] .5 .01472 0 2 Mshowa
p
.002 w
.7381 .01472 m
.7381 .02097 L
s
P
[(15)] .7381 .01472 0 2 Mshowa
p
.002 w
.97619 .01472 m
.97619 .02097 L
s
P
[(20)] .97619 .01472 0 2 Mshowa
p
.001 w
.07143 .01472 m
.07143 .01847 L
s
P
p
.001 w
.11905 .01472 m
.11905 .01847 L
s
P
p
.001 w
.16667 .01472 m
.16667 .01847 L
s
P
p
.001 w
.21429 .01472 m
.21429 .01847 L
s
P
p
.001 w
.30952 .01472 m
.30952 .01847 L
s
P
p
.001 w
.35714 .01472 m
.35714 .01847 L
s
P
p
.001 w
.40476 .01472 m
.40476 .01847 L
s
P
p
.001 w
.45238 .01472 m
.45238 .01847 L
s
P
p
.001 w
.54762 .01472 m
.54762 .01847 L
s
P
p
.001 w
.59524 .01472 m
.59524 .01847 L
s
P
p
.001 w
.64286 .01472 m
.64286 .01847 L
s
P
p
.001 w
.69048 .01472 m
.69048 .01847 L
s
P
p
.001 w
.78571 .01472 m
.78571 .01847 L
s
P
p
.001 w
.83333 .01472 m
.83333 .01847 L
s
P
p
.001 w
.88095 .01472 m
.88095 .01847 L
s
P
p
.001 w
.92857 .01472 m
.92857 .01847 L
s
P
[(DNA)(length, bp)] 1.025 .01472 -1 0 Mshowa
p
.002 w
0 .01472 m
1 .01472 L
s
P
p
.002 w
.02381 .10224 m
.03006 .10224 L
s
P
[(5)] .01131 .10224 1 0 Mshowa
p
.002 w
.02381 .18976 m
.03006 .18976 L
s
P
[(10)] .01131 .18976 1 0 Mshowa
p
.002 w
.02381 .27728 m
.03006 .27728 L
s
P
[(15)] .01131 .27728 1 0 Mshowa
p
.002 w
.02381 .3648 m
.03006 .3648 L
s
P
[(20)] .01131 .3648 1 0 Mshowa
p
.002 w
.02381 .45232 m
.03006 .45232 L
s
P
[(25)] .01131 .45232 1 0 Mshowa
p
.002 w
.02381 .53984 m
.03006 .53984 L
s
P
[(30)] .01131 .53984 1 0 Mshowa
p
.001 w
.02381 .03222 m
.02756 .03222 L
s
P
p
.001 w
.02381 .04972 m
.02756 .04972 L
s
P
p
.001 w
.02381 .06723 m
.02756 .06723 L
s
P
p
.001 w
.02381 .08473 m
.02756 .08473 L
s
P
p
.001 w
.02381 .11974 m
.02756 .11974 L
s
P
p
.001 w
.02381 .13724 m
.02756 .13724 L
s
P
p
.001 w
.02381 .15475 m
.02756 .15475 L
s
P
p
.001 w
.02381 .17225 m
.02756 .17225 L
s
P
p
.001 w
.02381 .20726 m
.02756 .20726 L
s
P
p
.001 w
.02381 .22477 m
.02756 .22477 L
s
P
p
.001 w
.02381 .24227 m
.02756 .24227 L
s
P
p
.001 w
.02381 .25977 m
.02756 .25977 L
s
P
p
.001 w
.02381 .29478 m
.02756 .29478 L
s
P
p
.001 w
.02381 .31229 m
.02756 .31229 L
s
P
p
.001 w
.02381 .32979 m
.02756 .32979 L
s
P
p
.001 w
.02381 .3473 m
.02756 .3473 L
s
P
p
.001 w
.02381 .3823 m
.02756 .3823 L
s
P
p
.001 w
.02381 .39981 m
.02756 .39981 L
s
P
p
.001 w
.02381 .41731 m
.02756 .41731 L
s
P
p
.001 w
.02381 .43482 m
.02756 .43482 L
s
P
p
.001 w
.02381 .46982 m
.02756 .46982 L
s
P
p
.001 w
.02381 .48733 m
.02756 .48733 L
s
P
p
.001 w
.02381 .50483 m
.02756 .50483 L
s
P
p
.001 w
.02381 .52234 m
.02756 .52234 L
s
P
p
.001 w
.02381 .55735 m
.02756 .55735 L
s
P
p
.001 w
.02381 .57485 m
.02756 .57485 L
s
P
p
.001 w
.02381 .59235 m
.02756 .59235 L
s
P
p
.001 w
.02381 .60986 m
.02756 .60986 L
s
P
[(\\201)] .02381 .61803 0 -4 Mshowa
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
p
.004 w
.02857 .01769 m
.06806 .04235 L
.10754 .06699 L
.14702 .0916 L
.18651 .11619 L
.22599 .14076 L
.26548 .16531 L
.30496 .18983 L
.34444 .21433 L
.38393 .23881 L
.42341 .26327 L
.4629 .2877 L
.50238 .31211 L
.54187 .3365 L
.58135 .36087 L
.62083 .38522 L
.66032 .40954 L
.6998 .43384 L
.73929 .45812 L
.77877 .48237 L
.81825 .50661 L
.85774 .53082 L
.89722 .55501 L
.93671 .57917 L
.97619 .60332 L
s
P
P
p
p
.004 w
.02857 .219 m
.06806 .22882 L
.10754 .23837 L
.14702 .24769 L
.18651 .2568 L
.22599 .26573 L
.26548 .27449 L
.30496 .28309 L
.34444 .29156 L
.38393 .2999 L
.42341 .30812 L
.4629 .31623 L
.50238 .32424 L
.54187 .33215 L
.58135 .33997 L
.62083 .34771 L
.66032 .35536 L
.6998 .36295 L
.73929 .37046 L
.77877 .3779 L
.81825 .38528 L
.85774 .39259 L
.89722 .39985 L
.93671 .40705 L
.97619 .4142 L
s
P
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageRegion->{{-0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006W00011B000`400?l00000o`00003ooooooonX
ooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonX
ooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonX
ooooo`00oooooonXooooo`00G?ooool01_o<c<co8B4Qo`000?l0003o<S8bomgMgD3ooooo00?o410@
o`000?l000000_l000000ooMgMgoooooooooo`02ooooo`04ofIVI_l0003o<S8bonk^kScooooo00?o
410@o`000?l000000_l000001OoMgMgoooooooooooo<c<co8B4Q00;o000000?o<S8bomgMgOooool0
>Oooool00on7QhOo0000o`000002o`000003oa0@4?oooooooooo00?ooooo00CoIVIVo`000?lb<S;o
k^k^I?ooool005cooooo00Koc<c<ojVYZOoooooooooooiRHV?lQ8B52ooooo`03o`000?oooooooooo
00Cooooo0_n7QhL00oooooooQhN7odA4A00nooooo`03o`000?oooooooooo00?ooooo00Koc<c<ojVY
ZOoooooooooooiRHV?lQ8B4jooooo`03onk^k_lb<S;oc<c<00Oooooo0_n7QhL00oooooooQhN7odA4
A01Tooooo`00HOooool00olQ8B7o^[Zjooooo`10ooooo`03o`000?oooooooooo00Cooooo00Go<S8b
ooooooooooooooooo`00000nooooo`03o`000?oooooooooo00Sooooo00?o8B4QokZj^_ooool0>Ooo
ool00oo^k^ko<S8bojVYZ@06ooooo`05oc8b<_ooooooooooooooool00000I?ooool0067ooooo00?o
8B4QokZj^_ooool0@?ooool00ol0003oooooooooo`04ooooo`06oc8b<_oooooooooooooooolb<S;o
^[Zj?Oooool00ol0003oooooooooo`08ooooo`03ob4Q8Onj^[[ooooo03[ooooo00?ok^k^ob4Q8OnH
V9P01Oooool01_lb<S;ooooooooooooooooo<S8bokZj^RGooooo00GoEEEEo`000?l0003oA4A4onk^
kP0`ooooo`?o000000?o<S8booooooooool00oooool005gooooo00GoIVIVomgMgOooooooQhN7oa0@
4012ooooo`03o`000?oooooooooo00Cooooo00Ko<S8boooooooooooooooooc8b<_nj^[Xmooooo`03
o`000?oooooooooo00Cooooo00GoIVIVomgMgOooooooQhN7oa0@400mooooo`03onk^k_lb<S;oc<c<
00Cooooo00Ko<S8boooooooooooooooooc8b<_nj^[XXooooo`03ohN7Qolb<S;ooooo01Gooooo00?o
c<c<o`000?o^k^h05oooool00onj^[[o0000ooooo`06ooooo`00GOooool01Ol0003o8B4Qo`000?l@
413oc<c<04;ooooo00?o0000ooooooooool01?ooool01_lb<S;ooooooooooooooooo<S8bokZj^Sgo
oooo00?o0000ooooooooool01?ooool01Ol0003o8B4Qo`000?l@413oc<c<03kooooo00?ok^k^odA4
A?ooool00oooool01_lb<S;ooooooooooooooooo<S8bokZj^RWooooo00?o0000ooooooooool05?oo
ool00oo^k^ko0000oeEEE@0Gooooo`03okZj^_l0003ooooo00Kooooo001Mooooo`03o`000?oooooo
oooo04Cooooo00?o0000ooooooooool01?ooool01Olb<S;ok^k^ooooooo^k^ko000003kooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`0mooooo`05okZj^_oooooooooooooooolb<S80
1?ooool01Olb<S;ok^k^ooooooo^k^ko000000[ooooo00?o410@o`000?l000000ol000001Olb<S;o
ooooooooooooooooIVIV00?o000000GoA4A4oiRHV?oooooooooooa0@4002o`000004ooooool0003o
0000oa0@40?ooooo00GoIVIVo`000?l0003oIVIVo`000005ooooo`08oiRHV?l@413o0000oa0@4?mE
EEGoc<c<ooooool@4102o`000004ooooool0003o0000oa0@40Cooooo00?oA4A4o`000?nj^[X03Ooo
ool00ol@413o0000ofIVIP02o`000007ogMgMooooooooooooooooonj^[[o0000oiRHV002o`000003
ofIVI_oooooooooo007ooooo001Mooooo`03o`000?oooooooooo04;ooooo00?oQhN7okZj^_l00000
1_ooool01On7QhOoIVIVoooooomVIVKoA4A403cooooo00?oQhN7okZj^_l000001_ooool00ol0003o
ooooooooo`0looooo`06olc<c?l0003oQhN7oooooonj^[[o8B4Q1?ooool01On7QhOoIVIVoooooomV
IVKoA4A400gooooo00?o0000ooooooooool00oooool01omgMgOoEEEEonk^k_ooooook^k^oiRHV?lb
<S800oooool01Ol0003ooooooooooooooooo000000?ooooo00KoMgMgoeEEEOo^k^kogMgMob4Q8Ol0
0005ooooo`06o`000?o<c<coooooomgMgOn7QhOoZJVY0_ooool01Ol0003ooooooooooooooooo0000
00Gooooo00?oV9RHo`000?lb<S803_ooool01?l0003oA4A4onk^k_ooool2ogMgM`;ooooo00?o^[Zj
o`000?mgMgL00_ooool2ogMgM`;ooooo001Mooooo`Co000000?o410@ooooooooool0?_ooool00on7
QhOo<S8bo`000007ooooo`04ofIVI_l0003o<S8bonk^kScooooo00?oQhN7oc8b<_l000001_ooool4
o`000003oa0@4?oooooooooo03Wooooo00GoZJVYob4Q8Ol0003o410@olc<c005ooooo`04ofIVI_l0
003o<S8bonk^kPgooooo00?o0000ooooooooool00oooool00ol0003ok^k^ooooo`07ooooo`05o`00
0?ooooooooooooooool000000oooool01_lQ8B7oooooooooooooooooc<c<o`0000Gooooo00?o0000
ooooooooool01Oooool01Ol0003ooooooooooooooooo000001Kooooo00?o0000omgMgOooool00_oo
ool01Olb<S;ooooooooooonj^[[o410@00Cooooo0OlQ8B41ooooo`7ooooo003ooooooe7ooooo00?o
0000ooooooooool00oooool7o`000004omgMgOooooooooooo`0000?ooooo00Go0000oooooooooooo
oooooc8b<P04ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01Oooool01Ol0003o
oooooooooooooooo000001Kooooo00?o0000ooooooooool00_ooool01Olb<S;ooooooooooonj^[[o
<S8b00Cooooo0Olb<S81ooooo`7ooooo003ooooooe7ooooo00?o0000ooooooooool00oooool00ol@
413ogMgMooooo`02ooooo`03oiRHV?l0003ooooo00;ooooo00Go0000ooooooooooooooooo`000003
ooooo`06oc8b<_oooooooooooooooooMgMgo00001Oooool00ol0003oooooooooo`05ooooo`05o`00
0?ooooooooooooooool000005_ooool00ol0003ogMgMooooo`02ooooo`06oc8b<_oooooooooookZj
^_l0003ok^k^0_ooool00oo^k^ko8B4Qooooo`01ooooo`00oooooomAooooo`03o`000?oooooooooo
00?ooooo00OoMgMgob4Q8OoMgMgoooooomgMgOl@413oIVIV00?ooooo00Go0000ohN7Qooooooo^[Zj
oa0@4003ooooo`;oMgMg00Coooooonk^k_m4A4Co00000oooool00ol@413o0000o`000003o`000009
ogMgMoooooooooooooooool0003oQhN7oooooonj^[[o410@01Kooooo00Co0000odA4A?o^k^kooooo
0_mgMgL2ooooo`03okZj^_l0003oA4A400;ogMgM00?oA4A4ogMgMoooool00Oooool00?ooooooDOoo
ool00ol0003oooooooooo`04ooooo`05ogMgMol@413o0000oa0@4?mgMgL00oooool2o`000004ofIV
I_l0003o0000okZj^PCooooo00KoIVIVo`000?l0003oEEEEo`000?lb<S84ooooo`03oc8b<_oooooo
oooo00Gooooo00Go0000ogMgMol0003o0000okZj^P0Fooooo`05o`000?mVIVKo0000o`000?mVIVH0
0oooool00ol@413o0000ogMgM`02o`000003ofIVI_oooooooooo007ooooo000Eooooo`03o`000?oo
oooooooo0?oooooo>Oooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool06?ooool00ol0003oooooooooo`0>ooooo`005Oooool00ol0003oooooooooo`3o
ooooocWooooo00?o0000ooooooooool08?ooool00ol@413oooooooooo`05ooooo`03o`000?oooooo
oooo01Sooooo00?o0000ooooooooool03_ooool001Gooooo00?o0000ooooooooool0oooooolgoooo
o`03oa0@4?l0003o000002Wooooo00?o410@o`000?ooool06?ooool00ol@413o0000ooooo`0?oooo
o`005Oooool00ol0003oooooooooo`3ooooooi3ooooo000Eooooo`03o`000?oooooooooo0?oooooo
T?ooool000koooooool0000ho`0006;ooooo000Eooooo`05o`000?ooooooooooooooool000002_oo
ool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool02ooo
ool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool03?oo
ool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool03?oo
ool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool03?oo
ool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool02ooo
ool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool03?oo
ool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo06Sooooo000Eooooo`03o`000?oooooo
oooo00;ooooo0_l0003oooooohcooooo000Eooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool0oooooon9ooooo`005Oooool00ol0003oooooooooo`05ooooo`;o0000oooooon9ooooo`00
5Oooool3o`0000Oooooo00?o0000ooooooooool0oooooon6ooooo`005Oooool00ol0003ooooooooo
o`08ooooo`;o0000ooooool]ooooo`?o000000?o410@oiRHV?ooool00_ooool3o`0000;ooooo00Co
IVIVo`000?oooooo410@0_l000001?mEEEGooooooooooomEEED3o`000003omgMgOoooooooooo03co
oooo000Eooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0oooooolZooooo`06o`00
0?oooooooooookZj^_lQ8B7o^[Zj0_ooool01Ol0003ooooooooooooooooo^[Zj00;o00000_ooool0
0ol@413oZJVYooooo`03ooooo`03okZj^_l0003ogMgM03oooooo000Eooooo`03o`000?oooooooooo
00_ooooo0_l0003oooooob[ooooo00Ko0000ooooooooooooooooomgMgOm4A4@2ooooo`07o`000?oo
ooooooooonk^k_l@413oA4A4o`000002ooooo`03ogMgMom4A4Cooooo00?ooooo0_mEEEE0ooooo`00
5Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo0?oooooo9oooool00ol0003ooooo
ooooo`02ooooo`04oc8b<_ooooooooooo`0000;ooooo00CoEEEEo`000?o^k^ko00000_ooool00ooM
gMgo0000o`000004o`000003omgMgOoooooooooo03kooooo000Eooooo`?o00003_ooool2o`000?oo
oooo9oooool00ol0003oooooooooo`02ooooo`0:oc8b<_ooooooooooo`000?ooooooZJVYo`000?nY
ZJWoooooo`0000?ooooo00Ko<S8boiRHV?ooooooooooogMgMolb<S91ooooo`005Oooool00ol0003o
ooooooooo`0@ooooo`03o`000?oooooooooo0?oooooo9?ooool00ol0003oooooooooo`02ooooo`07
ob4Q8Oooooooooooo`000?o^k^ko0000odA4A002ooooo`06o`000?oooooooooooooooonHV9So410@
0_ooool00ol@413o^[Zjooooo`10ooooo`005Oooool00ol0003oooooooooo`0Aooooo`;o0000oooo
oolTooooo`06o`000?oooooooooooooooooMgMgoA4A40_ooool01?l0003oA4A4o`000?oMgMd2oooo
o`06o`000?ooooooooooooooooo^k^ko00000_nHV9P00ol@413oooooooooo`10ooooo`005Oooool0
0ol0003oooooooooo`0Cooooo`03o`000?oooooooooo0?oooooo8Oooool01_l0003ooooooooooooM
gMgo8B4QojVYZ@;ooooo0_l000001On7QhOooooooooooooooooo000000Cooooo00CoEEEEoa0@4?l@
413oV9RH@_ooool001Gooooo00?o0000ooooooooool05?ooool2o`000?oooooo8Oooool4o`000003
ohN7QooooooogMgM00;o000000?o<S8booooooooool00ol00002ooooo`05okZj^_l0003o0000o`00
0?l@4100@oooool001Gooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`3oooooogOo
oooo000Eooooo`?o00005oooool2o`000?ooooooMoooool001Gooooo00?o0000ooooooooool06Ooo
ool2o`000?ooooooMOooool001Gooooo00?o0000ooooooooool06oooool2o`000?ooooooLoooool0
01Gooooo00?o0000ooooooooool07Oooool2o`000?ooooooLOooool001Gooooo00?o0000oooooooo
ool07oooool00ol0003oooooooooo`3oooooofkooooo000Eooooo`?o00008?ooool2o`000?oooooo
K_ooool001Gooooo00?o0000ooooooooool08_ooool2o`000?ooooooK?ooool001Gooooo00?o0000
ooooooooool09?ooool2o`000?ooooooJ_ooool000[ooooo00Koc<c<ob4Q8Ol0003o0000oc8b<_oM
gMd5ooooo`03o`000?oooooooooo02Kooooo00?o0000ooooooooool0oooooomWooooo`002_ooool0
1_o<c<coZJVYooooooooooooV9RHob4Q8@Gooooo00?o0000ooooooooool09oooool2o`000?oooooo
Ioooool000oooooo00?o8B4QokZj^_ooool00oooool00ol0003oooooooooo`0Yooooo`03o`000?oo
oooooooo0?ooooooI?ooool000oooooo00?o8B4QokZj^_ooool00oooool3o`0002[ooooo0_l0003o
ooooofCooooo000;ooooo`05ofIVI_oMgMgoooooohN7Qol@41001Oooool00ol0003oooooooooo`0/
ooooo`03o`000?oooooooooo0?ooooooHOooool000_ooooo00Go0000ob4Q8Ol0003o410@olc<c005
ooooo`03o`000?oooooooooo02gooooo0_l0003oooooof7ooooo000;ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool0;oooool00ol0003oooooooooo`3ooooooekooooo000;ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool0<?ooool2o`000?ooooooG_ooool000_ooooo
1?l000000ol@413oooooooooo`03ooooo`?o0000<_ooool00ol0003oooooooooo`3ooooooe_ooooo
000Eooooo`03o`000?oooooooooo03?ooooo0_l0003ooooooe_ooooo000Eooooo`03o`000?oooooo
oooo03Gooooo00?o0000ooooooooool0oooooomHooooo`005Oooool00ol0003oooooooooo`0foooo
o`;o0000oooooomHooooo`005Oooool00ol0003oooooooooo`0hooooo`03o`000?oooooooooo0?oo
ooooEOooool001Gooooo00?o0000ooooooooool0>Oooool2o`000?ooooooEOooool001Gooooo0ol0
000kooooo`03o`000?oooooooooo0?ooooooD_ooool001Gooooo00?o0000ooooooooool0??ooool2
o`000?ooooooD_ooool001Gooooo00?o0000ooooooooool0?_ooool2o`000?ooooooD?ooool001Go
oooo00?o0000ooooooooool0@?ooool00ol0003oooooooooo`3oooooodgooooo000Eooooo`03o`00
0?oooooooooo047ooooo0_l0003oooooodgooooo000Eooooo`?o0000@oooool2o`000?ooooooBooo
ool001Gooooo00?o0000ooooooooool0AOooool00ol0003oooooooooo`3oooooodSooooo000Eoooo
o`03o`000?oooooooooo04Kooooo0_l0003oooooodSooooo000Eooooo`03o`000?oooooooooo04So
oooo0_l0003oooooodKooooo000Eooooo`03o`000?oooooooooo04[ooooo00?o0000ooooooooool0
oooooom3ooooo`005Oooool3o`0004_ooooo0_l0003ooooood?ooooo000Eooooo`03o`000?oooooo
oooo04gooooo00?o0000ooooooooool0oooooom0ooooo`005Oooool00ol0003oooooooooo`1>oooo
o`;o0000oooooom0ooooo`000_ooool00ol@413o0000o`000002o`000003omgMgOoooooooooo00;o
oooo00CoIVIVo`000?lb<S;ok^k^1Oooool00ol0003oooooooooo`1@ooooo`03o`000?oooooooooo
0?oooooo?Oooool000Cooooo00?o0000ooooooooool01?ooool2ohN7Q`03oooooon7QhOoA4A400Go
oooo00?o0000ooooooooool0DOooool2o`000?oooooo?Oooool000Cooooo00?o0000ooooooooool0
1?ooool01Olb<S;ooooooooooooooooo000000Gooooo00?o0000ooooooooool0Doooool00ol0003o
ooooooooo`3ooooooc[ooooo0004ooooo`03o`000?oooooooooo00Cooooo00Ko<S8boooooooooooo
oooooc8b<_nj^[X4ooooo`?o0000E?ooool2o`000?oooooo>_ooool000Cooooo00?o0000oooooooo
ool01?ooool01_lb<S;ooooooooooooooooo<S8bokZj^PCooooo00?o0000ooooooooool0E_ooool2
o`000?oooooo>?ooool000Cooooo00?o0000ooooooooool01?ooool01_lb<S;ooooooooooooooooo
<S8bokZj^PCooooo00?o0000ooooooooool0F?ooool2o`000?oooooo=_ooool000Cooooo00?o0000
ooooooooool01?ooool01Olb<S;ok^k^ooooooo^k^ko000000Gooooo00?o0000ooooooooool0F_oo
ool2o`000?oooooo=?ooool000;ooooo00?oQhN7okZj^_l000001_ooool01On7QhOoIVIVoooooomV
IVKoA4A400Gooooo00?o0000ooooooooool0G?ooool00ol0003oooooooooo`3ooooooc7ooooo0002
ooooo`03ohN7Qolb<S;o000000Oooooo00CoIVIVo`000?lb<S;ok^k^1Oooool3o`0005gooooo0_l0
003ooooooc7ooooo000Eooooo`03o`000?oooooooooo05oooooo0_l0003ooooooboooooo000Eoooo
o`03o`000?oooooooooo067ooooo0_l0003oooooobgooooo000Eooooo`03o`000?oooooooooo06?o
oooo00?o0000ooooooooool0oooooolZooooo`005Oooool00ol0003oooooo`000002o`0006;ooooo
0_l0003oooooob[ooooo000Eooooo`03o`000?oooooooooo00;ooooo1?l0001Pooooo`03o`000?oo
oooooooo0?oooooo9oooool001Gooooo0ol00006ooooo`Co0000GOooool2o`000?oooooo9oooool0
01Gooooo00?o0000ooooooooool02_ooool4o`0005_ooooo00?o0000ooooooooool0oooooolToooo
o`005Oooool00ol0003oooooooooo`0>ooooo`Co0000F?ooool2o`000?oooooo9?ooool001Gooooo
00?o0000ooooooooool04_ooool4o`0005Kooooo00?o0000ooooooooool0oooooolQooooo`005Ooo
ool00ol0003oooooooooo`0Fooooo`Co0000Doooool2o`000?oooooo8Oooool001Gooooo0ol0000J
ooooo`Go0000D?ooool00ol0003oooooooooo`3ooooooakooooo000Eooooo`03o`000?oooooooooo
01oooooo1?l0001=ooooo`;o0000oooooolNooooo`005Oooool00ol0003oooooooooo`0Sooooo`Co
0000Boooool00ol0003oooooooooo`3ooooooa_ooooo000Eooooo`03o`000?oooooooooo02Oooooo
1?l00018ooooo`;o0000oooooolKooooo`005Oooool00ol0003oooooooooo`0[ooooo`Co0000A_oo
ool00ol0003oooooooooo`3ooooooaSooooo000Eooooo`?o0000;oooool5o`0004;ooooo0_l0003o
oooooaSooooo000Eooooo`03o`000?oooooooooo03Cooooo1_l0000nooooo`03o`000?oooooooooo
0?oooooo5Oooool001Gooooo00?o0000ooooooooool0>_ooool5o`0003[ooooo0_l0003ooooooaGo
oooo0002ooooo`03oa0@4?l0003o000000;o000000GogMgMooooooooooooc<c<ob4Q8@02o`000003
oc8b<_oMgMgooooo00Cooooo00?o0000ooooooooool0?oooool4o`0003Sooooo0_l0003ooooooa?o
oooo0004ooooo`03o`000?oooooooooo00?ooooo00Koc<c<ojVYZOoooooooooooiRHV?lQ8B45oooo
o`03o`000?oooooooooo04?ooooo1?l0000fooooo`03o`000?oooooooooo0?oooooo4?ooool000Co
oooo00?o0000ooooooooool02?ooool00olQ8B7o^[Zjooooo`03ooooo`03o`000?oooooooooo04Oo
oooo1?l0000cooooo`;o0000ooooool@ooooo`001?ooool00ol0003oooooooooo`08ooooo`03ob4Q
8Onj^[[ooooo00?ooooo0ol0001;ooooo`Co0000<Oooool2o`000?oooooo3_ooool000Cooooo00?o
0000ooooooooool01?ooool01OmVIVKogMgMoooooon7QhOo410@00Gooooo00?o0000ooooooooool0
Coooool4o`0002oooooo00?o0000ooooooooool0ooooool;ooooo`001?ooool00ol0003ooooooooo
o`04ooooo`05o`000?lQ8B7o0000oa0@4?o<c<`01Oooool00ol0003oooooooooo`1Cooooo`Go0000
:oooool2o`000?oooooo2oooool000Cooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo05Sooooo1ol0000Vooooo`;o0000ooooool9ooooo`000_ooool0
0on7QhOo^[Zjo`000006ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0Goooool5
o`0002?ooooo00?o0000ooooooooool0ooooool6ooooo`000_ooool00on7QhOo<S8bo`000006oooo
o`Co000000?o410@ooooooooool00oooool3o`0006Cooooo1?l0000Pooooo`;o0000ooooool6oooo
o`005Oooool00ol0003oooooooooo`1Xooooo`Co00007_ooool2o`000?oooooo1?ooool001Gooooo
00?o0000ooooooooool0K?ooool5o`0001_ooooo00?o0000ooooooooool0ooooool1ooooo`005Ooo
ool00ol0003oooooooooo`1aooooo`Ko00005_ooool2o`000?oooooo0Oooool001Gooooo00?o0000
ooooooooool0Moooool5o`0001?ooooo0_l0003nooooo`005Oooool00ol0003oooooooooo`1loooo
o`Co00004Oooool00ol0003oooooooooo`3kooooo`005Oooool3o`00083ooooo1?l0000>ooooo`;o
0000noooool001Gooooo00?o0000ooooooooool0Q?ooool5o`0000_ooooo0_l0003iooooo`005Ooo
ool00ol0003oooooooooo`29ooooo`Oo00001_ooool00ol0003oooooooooo`3fooooo`005Oooool0
0ol0003oooooooooo`2@ooooo`Go00000_ooool2o`000?Kooooo000Eooooo`03o`000?oooooooooo
09Gooooo1_l0003dooooo`005Oooool3o`0009Wooooo1?l0003booooo`005Oooool00ol0003ooooo
ooooo`2Looooo`Ko0000kOooool001Gooooo00?o0000ooooooooool0W_ooool2o`0000;ooooo1_l0
003Wooooo`005Oooool00ol0003oooooooooo`2Pooooo`03o`000?oooooooooo00Gooooo1Ol0003R
ooooo`005Oooool00ol0003oooooooooo`2Qooooo`;o00002_ooool4o`000=kooooo000Eooooo`03
o`000?oooooooooo0:?ooooo00?o0000ooooooooool02oooool4o`000=[ooooo000Eooooo`?o0000
Y?ooool2o`0000oooooo1Ol0003Eooooo`005Oooool00ol0003oooooooooo`2Vooooo`03o`000?oo
oooooooo017ooooo1ol0003>ooooo`0000?oooooohN7Qol000000ol000000ol@413oooooooooo`03
ooooo`04ofIVI_l0003o<S8bonk^kPGooooo00?o0000ooooooooool0Yoooool2o`0001Sooooo1_l0
0038ooooo`0000Coooooonk^k_lb<S;oc<c<1oooool2ohN7Q`03oooooon7QhOoA4A400Gooooo00?o
0000ooooooooool0ZOooool00ol0003oooooooooo`0Kooooo`Ko0000`_ooool000;ooooo00?ok^k^
oc8b<_nYZJT01_ooool01Olb<S;ooooooooooooooooo000000Gooooo00?o0000ooooooooool0Z_oo
ool2o`00027ooooo1Ol0002mooooo`000oooool00oo^k^ko8B4QoiRHV005ooooo`06oc8b<_oooooo
oooooooooolb<S;o^[Zj1?ooool3o`000:cooooo0_l0000Tooooo`Co0000^Oooool000Cooooo00?o
k^k^oc8b<_o<c<`01?ooool01_lb<S;ooooooooooooooooo<S8bokZj^PCooooo00?o0000oooooooo
ool0[_ooool00ol0003oooooooooo`0Uooooo`Co0000]Oooool000Gooooo00?ok^k^odA4A?ooool0
0oooool01_lb<S;ooooooooooooooooo<S8bokZj^PCooooo00?o0000ooooooooool0[oooool2o`00
02Wooooo1Ol0002`ooooo`000_ooool01Onj^[[ooooooooooooooooo<S8b00Cooooo00Go<S8bonk^
k_ooooook^k^o`000005ooooo`03o`000?oooooooooo0;7ooooo0_l0000/ooooo`Ko0000Z_ooool0
0007ooooooo<c<co0000ohN7Qooooooo^[Zjob4Q8@04ooooo`05ohN7QomVIVKoooooofIVI_m4A4@0
1Oooool00ol0003oooooooooo`2cooooo`03o`000?oooooooooo02oooooo1_l0002Tooooo`000_oo
ool01OnYZJWo8B4Qo`000?l@413oc<c<00Gooooo00CoIVIVo`000?lb<S;ok^k^1Oooool3o`000;Co
oooo0_l0000eooooo`Ko0000W_ooool001Gooooo00?o0000ooooooooool0]_ooool2o`0003Wooooo
1Ol0002Iooooo`005Oooool00ol0003oooooooooo`2hooooo`03o`000?oooooooooo03_ooooo1Ol0
002Dooooo`005Oooool00ol0003oooooooooo`2iooooo`;o0000@?ooool4o`00093ooooo000Eoooo
o`03o`000?oooooooooo0;_ooooo0_l00012ooooo`Go0000Roooool001Gooooo00?o0000oooooooo
ool0_Oooool00ol0003oooooooooo`14ooooo`Ko0000QOooool001Gooooo0ol0002nooooo`;o0000
B_ooool6o`0007oooooo000Eooooo`03o`000?oooooooooo0<3ooooo0_l0001>ooooo`Ko0000NOoo
ool001Gooooo00?o0000ooooooooool0`_ooool00ol0003oooooooooo`1Aooooo`Ko0000Loooool0
01Gooooo00?o0000ooooooooool0`oooool2o`0005Oooooo1_l0001]ooooo`005Oooool00ol0003o
ooooooooo`35ooooo`;o0000Foooool3o`0006[ooooo000Eooooo`?o0000aoooool00ol0003ooooo
ooooo`35ooooo`005Oooool00ol0003oooooooooo`38ooooo`;o0000aOooool001Gooooo00?o0000
ooooooooool0b_ooool2o`000<?ooooo000Eooooo`03o`000?oooooooooo0<cooooo00?o0000oooo
ooooool0`?ooool001Gooooo00?o0000ooooooooool0cOooool2o`000<3ooooo000Eooooo`03o`00
0?oooooooooo0<oooooo0_l0002nooooo`005Oooool3o`000=7ooooo00?o0000ooooooooool0^ooo
ool001Gooooo00?o0000ooooooooool0d_ooool2o`000;_ooooo000Eooooo`03o`000?oooooooooo
0=Cooooo00?o0000ooooooooool0^?ooool00003oooooon7QhOo000000?o000000Ko410@oooooooo
ooooooooolc<c?lQ8B42o`000003oc8b<_oMgMgooooo00Cooooo00?o0000ooooooooool0eOooool2
o`000;Sooooo00001?ooooook^k^oc8b<_o<c<`6ooooo`06olc<c?nYZJWooooooooooonHV9So8B4Q
1Oooool00ol0003oooooooooo`3Gooooo`03o`000?oooooooooo0;Gooooo0002ooooo`03onk^k_lb
<S;oZJVY00[ooooo00?o8B4QokZj^_ooool00oooool3o`000=Sooooo0_l0002eooooo`000oooool0
0oo^k^ko8B4QoiRHV009ooooo`03ob4Q8Onj^[[ooooo00?ooooo00?o0000ooooooooool0f_ooool0
0ol0003oooooooooo`2booooo`001?ooool00oo^k^ko<S8bolc<c004ooooo`05ofIVI_oMgMgooooo
ohN7Qol@41001Oooool00ol0003oooooooooo`3Kooooo`;o0000/_ooool000Gooooo00?ok^k^odA4
A?ooool00oooool01Ol0003o8B4Qo`000?l@413oc<c<00Gooooo00?o0000ooooooooool0gOooool2
o`000;3ooooo0002ooooo`05okZj^_oooooooooooooooolb<S801?ooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo0=oooooo00?o0000ooooooooool0[Oooool00007ooooooo<c<co0000
ohN7Qooooooo^[Zjob4Q8@04ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0h?oo
ool2o`000:gooooo0002ooooo`05ojVYZOlQ8B7o0000oa0@4?o<c<`01?ooool4o`000003oa0@4?oo
oooooooo00?ooooo0ol0003Rooooo`;o0000Zoooool001Gooooo00?o0000ooooooooool0i?ooool0
0ol0003oooooooooo`2Xooooo`005Oooool00ol0003oooooooooo`3Uooooo`;o0000Z?ooool001Go
oooo00?o0000ooooooooool0ioooool2o`000:Kooooo000Eooooo`03o`000?oooooooooo0>Wooooo
00?o0000ooooooooool0Xoooool001Gooooo0ol0003Zooooo`;o0000Xoooool001Gooooo00?o0000
ooooooooool0k?ooool00ol0003oooooooooo`2Pooooo`005Oooool00ol0003oooooooooo`3]oooo
o`;o0000X?ooool001Gooooo00?o0000ooooooooool0koooool00ol0003oooooooooo`2Mooooo`00
5Oooool00ol0003oooooooooo`3`ooooo`;o0000WOooool001Gooooo0ol0003booooo`03o`000?oo
oooooooo09[ooooo000Eooooo`03o`000?oooooooooo0??ooooo0_l0002Jooooo`005Oooool00ol0
003oooooooooo`3eooooo`;o0000V?ooool001Gooooo00?o0000ooooooooool0moooool2o`0009Ko
oooo000Eooooo`03o`000?oooooooooo0?Wooooo0_l0002Dooooo`005Oooool00ol0003ooooooooo
o`3kooooo`03o`000?oooooooooo097ooooo000Eooooo`?o0000o?ooool2o`00097ooooo000Eoooo
o`03o`000?oooooooooo0?kooooo0_l0002?ooooo`005Oooool00ol0003oooooooooo`3oooooo`7o
oooo0_l0002=ooooo`0000?ooooookZj^_m4A4@00_l000000olQ8B7oc<c<ooooo`04ooooo`04ofIV
I_l0003o<S8bonk^kPGooooo00?o0000ooooooooool0ooooool3ooooo`03o`000?oooooooooo08[o
oooo00000oooooooZJVYoiRHV002ooooo`03okZj^_l0003ok^k^00?ooooo0_n7QhL00oooooooQhN7
odA4A005ooooo`03o`000?oooooooooo0?oooooo1?ooool2o`0008[ooooo0006ooooo`03oc8b<_nj
^[[ooooo00;ooooo00Go<S8booooooooooooooooo`000005ooooo`?o0000ooooool6ooooo`03o`00
0?oooooooooo08Oooooo0005ooooo`03onk^k_l0003ogMgM00?ooooo00Ko<S8boooooooooooooooo
oc8b<_nj^[X4ooooo`03o`000?oooooooooo0?oooooo1oooool2o`0008Oooooo0004ooooo`03ofIV
I_l@413oQhN700Cooooo00Ko<S8boooooooooooooooooc8b<_nj^[X4ooooo`03o`000?oooooooooo
0?oooooo2Oooool00ol0003oooooooooo`24ooooo`001?ooool00ooMgMgoMgMgofIVIP04ooooo`06
oc8b<_oooooooooooooooolb<S;o^[Zj1?ooool00ol0003oooooooooo`3oooooo`[ooooo0_l00024
ooooo`001_ooool00ol0003oooooooooo`02ooooo`05oc8b<_o^k^koooooonk^k_l000001Oooool0
0ol0003oooooooooo`3oooooo`cooooo00?o0000ooooooooool0POooool000;ooooo00GoA4A4okZj
^_ooooooV9RHoa0@4004ooooo`05ohN7QomVIVKoooooofIVI_m4A4@01Oooool00ol0003ooooooooo
o`3oooooo`gooooo0_l00021ooooo`000_ooool01On7QhOo410@o`000?l@413oc<c<00Gooooo00Co
IVIVo`000?lb<S;ok^k^1Oooool3o`000?oooooo3oooool2o`0007oooooo000Eooooo`03o`000?oo
oooooooo0?oooooo4Oooool00ol0003oooooooooo`1looooo`005Oooool00ol0003oooooooooo`3o
oooooa;ooooo0_l0001looooo`005Oooool00ol0003oooooooooo`3ooooooaCooooo0_l0001joooo
o`005Oooool00ol0003oooooooooo`3ooooooaKooooo00?o0000ooooooooool0Moooool001Gooooo
0ol0003ooooooaOooooo0_l0001gooooo`005Oooool00ol0003oooooooooo`3ooooooaWooooo0_l0
001eooooo`005Oooool00ol0003oooooooooo`3ooooooa_ooooo00?o0000ooooooooool0L_ooool0
01Gooooo00?o0000ooooooooool0oooooolLooooo`;o0000L_ooool001Gooooo00?o0000oooooooo
ool0oooooolNooooo`03o`000?oooooooooo06oooooo000Eooooo`?o0000oooooolOooooo`;o0000
Koooool001Gooooo00?o0000ooooooooool0oooooolQooooo`03o`000?oooooooooo06cooooo000E
ooooo`03o`000?oooooooooo0?oooooo8_ooool2o`0006cooooo000Eooooo`03o`000?oooooooooo
0?oooooo9?ooool00ol0003oooooooooo`1Yooooo`005Oooool00ol0003oooooooooo`3oooooobGo
oooo00?o0000ooooooooool0J?ooool001Gooooo00?o0000ooooooooool0oooooon@ooooo`005Ooo
ool3o`000?ooooooT?ooool001Gooooo00?o0000ooooooooool0oooooon@ooooo`005Oooool00ol0
003oooooooooo`3ooooooi3ooooo003oooooojSooooo003oooooojSooooo003oooooojSooooo003o
ooooojSooooo003oooooojSooooo003oooooojSooooo003oooooojSooooo003oooooojSooooo003o
ooooojSooooo003oooooojSooooo003oooooojSooooo003oooooojSooooo003oooooojSooooo003o
ooooojSooooo003oooooojSooooo003oooooojSooooo003oooooojSooooo003oooooojSooooo003o
ooooojSooooo003oooooojSooooo003oooooojSooooo003oooooojSooooo003oooooojSooooo003o
ooooojSooooo003oooooojSooooo003oooooojSooooo003oooooojSooooo000Aooooo`06oa0@4?l0
003o0000oeEEEOooooooEEEE0_l000000ol@413oooooooooo`3oooooohcooooo000Booooo`03oa0@
4?nYZJWooooo00;ooooo00?oZJVYo`000?o^k^h0oooooon>ooooo`004_ooool00omgMgOoIVIVoooo
o`02ooooo`03oeEEEOm4A4Cooooo0?ooooooS_ooool001;ooooo00?ogMgMo`000?l000000ol00000
0onYZJWoooooooooo`3oooooohgooooo000Cooooo`05oc8b<_nYZJWoooooohN7Qol00000oooooon@
ooooo`004oooool01OnHV9SoEEEEoooooolQ8B7oEEEE0?ooooooT?ooool001?ooooo00Gok^k^oa0@
4?oMgMgo0000olc<c03ooooooi3ooooo000Dooooo`03oeEEEOlb<S;o410@0?ooooooTOooool001;o
oooo00Go^[Zjo`000?l0003o0000ogMgM`3ooooooi7ooooo000Cooooo`04oiRHV?l0003o0000oiRH
V?ooooooTOooool001?ooooo00Co0000olc<c?o^k^ko8B4QoooooonAooooo`004oooool01?l0003o
c<c<onk^k_lQ8B7ooooooi7ooooo000Cooooo`04oiRHV?l0003o0000oiRHV?ooooooTOooool00?oo
ooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00?ooooooZ?ooool00001\
\>"],
  ImageRangeCache->{{{0, 422}, {260, 0}} -> {-1.48291, -5.35942, 0.101693, \
0.276649}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Simulate lollipops to see applicability of Kirkwood/BDvH \
approximation\
\>", "Subsubsection",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
I make a two-particle system here that is again like one in my \
paper. The separation is taken as the center of the array of linker spheres \
(smaller spheres) from the previous example. First orient perpendicular to \
sedimentation direction, then nearly parallel (I used a 5 degree angle with \
the z axis. When the linear assembly is exactly parallel, the set of \
equations becomes singular).\
\>", "Text",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
test=True;
data={};
nall={};
radiiall={};
uall={};
fzall={};
fBzall={};
AFzall={};
AFBzall={};\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
Do[\tnbp=N[Exp[i/2.2]];
\tpoints={{0,0,0},{57+rootr2[nbp/2],0,0}};
\tradii={57,rbpb[nbp]};

\thydro[{points,radii}];
\tftrue=G.yc;

\tftruez=ftrue[[Range[3,3 n,3]]];
\tutruez=ftrue[[3 n+3]];
\tAAz=AA[[Range[3,3 n,3],Range[3,3 n,3]]];
\tAFz=N[-6 Pi radii AAz.DiagonalMatrix[ftruez]];
\tDo[AFz[[i,i]]=N[6 Pi radii[[i]] utruez],{i,Length[AFz]}];

\tfbloomz=N[Map[#/Apply[Plus,radii] &,radii]];
\tAAz=AA[[Range[3,3 n,3],Range[3,3 n,3]]];
\tAFBz=N[-6 Pi radii AAz.DiagonalMatrix[fbloomz]];
\tDo[AFBz[[i,i]]=N[6 Pi radii[[i]] utruez],{i,Length[AFBz]}];

\tAppendTo[nall,nbp];
\tAppendTo[radiiall,radii];
\tAppendTo[uall,utruez];
\tAppendTo[fzall,N[Apply[Plus,Apply[Plus,Transpose[AFz]]]]];
\tAppendTo[fBzall,N[Apply[Plus,Apply[Plus,Transpose[AFBz]]]]];
\tAppendTo[AFzall,AFz];
\tAppendTo[AFBzall,AFBz],
{i,-2,9}];\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
Hydrodynamics of an assembly of 2 spheres
 {x,y,z}   radius
{0, 0, 0}         57

{57.6848, 0, 0}   11.8775
Matrix is size: {10, 10}
Hydrodynamics of an assembly of 2 spheres
 {x,y,z}   radius
{0, 0, 0}         57

{58.0787, 0, 0}   12.0343
Matrix is size: {10, 10}
Hydrodynamics of an assembly of 2 spheres
 {x,y,z}   radius
{0, 0, 0}         57

{58.6991, 0, 0}   12.2788
Matrix is size: {10, 10}
Hydrodynamics of an assembly of 2 spheres
 {x,y,z}   radius
{0, 0, 0}         57

{59.6759, 0, 0}   12.6582
Matrix is size: {10, 10}
Hydrodynamics of an assembly of 2 spheres
 {x,y,z}   radius
{0, 0, 0}         57

{61.2137, 0, 0}   13.2427
Matrix is size: {10, 10}
Hydrodynamics of an assembly of 2 spheres
 {x,y,z}   radius
{0, 0, 0}         57

{63.6332, 0, 0}   14.1351
Matrix is size: {10, 10}
Hydrodynamics of an assembly of 2 spheres
 {x,y,z}   radius
{0, 0, 0}         57

{67.4374, 0, 0}   15.4827
Matrix is size: {10, 10}
Hydrodynamics of an assembly of 2 spheres
 {x,y,z}   radius
{0, 0, 0}         57

{73.4114, 0, 0}   17.4935
Matrix is size: {10, 10}
Hydrodynamics of an assembly of 2 spheres
 {x,y,z}   radius
{0, 0, 0}        57

{82.776, 0, 0}   20.46
Matrix is size: {10, 10}
Hydrodynamics of an assembly of 2 spheres
 {x,y,z}   radius
{0, 0, 0}        57

{97.413, 0, 0}   24.7961
Matrix is size: {10, 10}
Hydrodynamics of an assembly of 2 spheres
 {x,y,z}   radius
{0, 0, 0}         57

{120.189, 0, 0}   31.0949
Matrix is size: {10, 10}
Hydrodynamics of an assembly of 2 spheres
 {x,y,z}   radius
{0, 0, 0}         57

{155.383, 0, 0}   40.0377
Matrix is size: {10, 10}\
\>", "Print",
  ImageRegion->{{-0, 1}, {0, 1}}]
}, Closed]],

Cell["Results for orientation 1 (aligned in x direction)", "Text",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
MatrixForm[N[Transpose[{nall,radiiall,uall,fzall,fBzall}],4]]\
\>", \
"Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[OutputFormData["\<\
MatrixForm[{{0.4028903215291329984, {57., \
11.87754893057077024}, 
 
    0.0009162782992554211008, 1., 0.9340183206785410912}, 
 
   {0.6347364189402818552, {57., 12.03432365502225954}, 
 
    0.0009155269078632304049, 1., 0.9347151620927694008}, 
 
   {1., {57., 12.27881508474089497}, 0.0009143142497740764362, 1., 
 
    0.9358188084507654646}, {1.575457103390318266, 
 
    {57., 12.65817787817370561}, 0.0009123353701727025776, 1., 
 
    0.9375647789299521531}, {2.482065084623011977, 
 
    {57., 13.24269970542908097}, 0.0009090604123202511157, 1., 
 
    0.9403102686065944433}, {3.910387068646415636, 
 
    {57., 14.13512582760230466}, 0.0009035563500196934039, 1., 
 
    0.9445559648440521558}, {6.160647084304639614, 
 
    {57., 15.4827288857650432}, 0.0008941922255138103687, 1., 
 
    0.9508869995827738861}, {9.70583521044859737, 
 
    {57., 17.49353584482051243}, 0.0008782491451633630181, 1., 
 
    0.9597085663966829894}, {15.29112702663710731, 
 
    {57., 20.46002691653445146}, 0.0008516826460829173572, 1., 
 
    0.9707018752034526873}, {24.09051469295910709, 
 
    {57., 24.7960582814694225}, 0.0008096780536246922953, 1., 
 
    0.9823051890071555347}, {37.95357249735125726, 
 
    {57., 31.09488054660584041}, 0.0007486240975994876542, 1., 
 
    0.9920310357192703564}, {59.79422538999145958, 
 
    {57., 40.03772654369157374}, 0.0006696849851832519147, 1., 
 
    0.9978982151196419793}}]\
\>", "\<\
0.4029         {57., 11.88}   \
0.0009163      1.             0.934

0.6347         {57., 12.03}   0.0009155      1.             0.9347

1.             {57., 12.28}   0.0009143      1.             0.9358

1.575          {57., 12.66}   0.0009123      1.             0.9376

2.482          {57., 13.24}   0.0009091      1.             0.9403

3.91           {57., 14.14}   0.0009036      1.             0.9446

6.161          {57., 15.48}   0.0008942      1.             0.9509

9.706          {57., 17.49}   0.0008782      1.             0.9597

15.29          {57., 20.46}   0.0008517      1.             0.9707

24.09          {57., 24.8}    0.0008097      1.             0.9823

37.95          {57., 31.09}   0.0007486      1.             0.992

59.79          {57., 40.04}   0.0006697      1.             0.9979\
\>"], \
"Output",
  ImageRegion->{{-0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
r1plot1=nall;
fBplot1=fBzall;\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
ListPlot[Transpose[{r1plot1,fBplot1}],
\tPlotJoined->True,
\tAxesLabel->{\"length, bp\",\"F(eq 4)/F(true)\"},
\tPlotRange->{0.9,1}];\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0159276 -5.56231 6.18034 [
[(10)] .18309 .61803 0 2 Msboxa
[(20)] .34236 .61803 0 2 Msboxa
[(30)] .50164 .61803 0 2 Msboxa
[(40)] .66092 .61803 0 2 Msboxa
[(50)] .82019 .61803 0 2 Msboxa
[(60)] .97947 .61803 0 2 Msboxa
[(length, bp)] 1.025 .61803 -1 0 Msboxa
[(0.92)] .01131 .12361 1 0 Msboxa
[(0.94)] .01131 .24721 1 0 Msboxa
[(0.96)] .01131 .37082 1 0 Msboxa
[(0.98)] .01131 .49443 1 0 Msboxa
[(F\\(eq 4\\)/F\\(true\\))] .02381 .61803 0 -4 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .62528 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.18309 .61803 m
.18309 .62428 L
s
P
[(10)] .18309 .61803 0 2 Mshowa
p
.002 w
.34236 .61803 m
.34236 .62428 L
s
P
[(20)] .34236 .61803 0 2 Mshowa
p
.002 w
.50164 .61803 m
.50164 .62428 L
s
P
[(30)] .50164 .61803 0 2 Mshowa
p
.002 w
.66092 .61803 m
.66092 .62428 L
s
P
[(40)] .66092 .61803 0 2 Mshowa
p
.002 w
.82019 .61803 m
.82019 .62428 L
s
P
[(50)] .82019 .61803 0 2 Mshowa
p
.002 w
.97947 .61803 m
.97947 .62428 L
s
P
[(60)] .97947 .61803 0 2 Mshowa
p
.001 w
.05566 .61803 m
.05566 .62178 L
s
P
p
.001 w
.08752 .61803 m
.08752 .62178 L
s
P
p
.001 w
.11938 .61803 m
.11938 .62178 L
s
P
p
.001 w
.15123 .61803 m
.15123 .62178 L
s
P
p
.001 w
.21494 .61803 m
.21494 .62178 L
s
P
p
.001 w
.2468 .61803 m
.2468 .62178 L
s
P
p
.001 w
.27865 .61803 m
.27865 .62178 L
s
P
p
.001 w
.31051 .61803 m
.31051 .62178 L
s
P
p
.001 w
.37422 .61803 m
.37422 .62178 L
s
P
p
.001 w
.40607 .61803 m
.40607 .62178 L
s
P
p
.001 w
.43793 .61803 m
.43793 .62178 L
s
P
p
.001 w
.46978 .61803 m
.46978 .62178 L
s
P
p
.001 w
.53349 .61803 m
.53349 .62178 L
s
P
p
.001 w
.56535 .61803 m
.56535 .62178 L
s
P
p
.001 w
.5972 .61803 m
.5972 .62178 L
s
P
p
.001 w
.62906 .61803 m
.62906 .62178 L
s
P
p
.001 w
.69277 .61803 m
.69277 .62178 L
s
P
p
.001 w
.72463 .61803 m
.72463 .62178 L
s
P
p
.001 w
.75648 .61803 m
.75648 .62178 L
s
P
p
.001 w
.78834 .61803 m
.78834 .62178 L
s
P
p
.001 w
.85205 .61803 m
.85205 .62178 L
s
P
p
.001 w
.8839 .61803 m
.8839 .62178 L
s
P
p
.001 w
.91576 .61803 m
.91576 .62178 L
s
P
p
.001 w
.94761 .61803 m
.94761 .62178 L
s
P
[(length, bp)] 1.025 .61803 -1 0 Mshowa
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.02381 .12361 m
.03006 .12361 L
s
P
[(0.92)] .01131 .12361 1 0 Mshowa
p
.002 w
.02381 .24721 m
.03006 .24721 L
s
P
[(0.94)] .01131 .24721 1 0 Mshowa
p
.002 w
.02381 .37082 m
.03006 .37082 L
s
P
[(0.96)] .01131 .37082 1 0 Mshowa
p
.002 w
.02381 .49443 m
.03006 .49443 L
s
P
[(0.98)] .01131 .49443 1 0 Mshowa
p
.001 w
.02381 .02472 m
.02756 .02472 L
s
P
p
.001 w
.02381 .04944 m
.02756 .04944 L
s
P
p
.001 w
.02381 .07416 m
.02756 .07416 L
s
P
p
.001 w
.02381 .09889 m
.02756 .09889 L
s
P
p
.001 w
.02381 .14833 m
.02756 .14833 L
s
P
p
.001 w
.02381 .17305 m
.02756 .17305 L
s
P
p
.001 w
.02381 .19777 m
.02756 .19777 L
s
P
p
.001 w
.02381 .22249 m
.02756 .22249 L
s
P
p
.001 w
.02381 .27193 m
.02756 .27193 L
s
P
p
.001 w
.02381 .29666 m
.02756 .29666 L
s
P
p
.001 w
.02381 .32138 m
.02756 .32138 L
s
P
p
.001 w
.02381 .3461 m
.02756 .3461 L
s
P
p
.001 w
.02381 .39554 m
.02756 .39554 L
s
P
p
.001 w
.02381 .42026 m
.02756 .42026 L
s
P
p
.001 w
.02381 .44498 m
.02756 .44498 L
s
P
p
.001 w
.02381 .46971 m
.02756 .46971 L
s
P
p
.001 w
.02381 .51915 m
.02756 .51915 L
s
P
p
.001 w
.02381 .54387 m
.02756 .54387 L
s
P
p
.001 w
.02381 .56859 m
.02756 .56859 L
s
P
p
.001 w
.02381 .59331 m
.02756 .59331 L
s
P
[(F\\(eq 4\\)/F\\(true\\))] .02381 .61803 0 -4 Mshowa
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.004 w
.03023 .21024 m
.03392 .21455 L
.03974 .22137 L
.0489 .23216 L
.06334 .24913 L
.08609 .27537 L
.12193 .3145 L
.1784 .36902 L
.26736 .43696 L
.40751 .50867 L
.62832 .56878 L
.97619 .60504 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageRegion->{{-0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006W00011B000`400?l00000o`00003ooooooonX
ooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonX
ooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonX
ooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonX
ooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonX
ooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonX
ooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00@oooool0
0ol0003oooooooooo`3oooooof;ooooo0013ooooo`03o`000?oooooooooo0?ooooooH_ooool004?o
oooo00?o0000ooooooooool0oooooomRooooo`00@oooool00ol0003oooooooooo`3oooooof;ooooo
0013ooooo`03o`000?oooooooooo0?ooooooH_ooool004?ooooo00?o0000ooooooooool0oooooomR
ooooo`00@oooool00ol0003oooooooooo`3oooooof;ooooo0013ooooo`;o0000oooooomSooooo`00
@oooool00ol0003oooooooooo`3oooooof;ooooo0013ooooo`03o`000?oooooooooo0?ooooooH_oo
ool004?ooooo00?o0000ooooooooool0oooooomRooooo`00@oooool00ol0003oooooooooo`3ooooo
of;ooooo0013ooooo`03o`000?oooooooooo0?ooooooH_ooool004?ooooo0_l0003oooooof?ooooo
0013ooooo`03o`000?oooooooooo0?ooooooH_ooool004?ooooo00?o0000ooooooooool0oooooomR
ooooo`00@oooool00ol0003oooooooooo`3oooooof;ooooo0013ooooo`03o`000?oooooooooo0?oo
ooooH_ooool004?ooooo00?o0000ooooooooool0oooooomRooooo`00@oooool00ol0003ooooooooo
o`3oooooof;ooooo0013ooooo`;o0000oooooomSooooo`00@oooool00ol0003oooooooooo`3ooooo
of;ooooo0013ooooo`03o`000?oooooooooo0?ooooooH_ooool004?ooooo00?o0000ooooooooool0
oooooomRooooo`00@oooool00ol0003oooooooooo`3oooooof;ooooo0013ooooo`03o`000?oooooo
oooo0?ooooooH_ooool004?ooooo0_l0003oooooof?ooooo0013ooooo`03o`000?oooooooooo0?oo
ooooH_ooool004?ooooo00?o0000ooooooooool0oooooomRooooo`00@oooool00ol0003ooooooooo
o`3oooooof;ooooo000Oooooo`04ofIVI_l0003o<S8bonk^kPGooooo00?oV9RHo`000?mEEED00ooo
ool01Onj^[[o410@o`000?lQ8B7oQhN700Gooooo00?oQhN7o`000?l000000_l000000ol@413ooooo
ooooo`03ooooo`03o`000?oooooooooo0?ooooooH_ooool001kooooo0_n7QhL00oooooooQhN7odA4
A005ooooo`03oc8b<_l0003o000000Kooooo00CogMgMogMgMolQ8B7ok^k^0oooool00oo^k^ko<S8b
olc<c008ooooo`03o`000?oooooooooo0?ooooooH_ooool001kooooo00Go<S8boooooooooooooooo
o`000005ooooo`03ojVYZOlQ8B7oMgMg00Sooooo00?oV9RHoeEEEOooool00oooool00oo^k^ko<S8b
ojVYZ@07ooooo`03o`000?oooooooooo0?ooooooH_ooool001kooooo00Ko<S8boooooooooooooooo
oc8b<_nj^[X<ooooo`06ofIVI_l0003o0000odA4A?l@413ok^k^1?ooool00oo^k^ko8B4QoiRHV006
ooooo`?o0000oooooomRooooo`007_ooool01_lb<S;ooooooooooooooooo<S8bokZj^P_ooooo00Oo
IVIVogMgMoo^k^kok^k^ogMgMol0003o^[Zj00Gooooo00?ok^k^oc8b<_o<c<`01Oooool00ol0003o
ooooooooo`3oooooof;ooooo000Nooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj2oooool00olQ
8B7oooooooooo`02ooooo`03ob4Q8Onj^[[ooooo00Gooooo00?ok^k^odA4A?ooool01?ooool00ol0
003oooooooooo`3oooooof;ooooo000Nooooo`05oc8b<_o^k^koooooonk^k_l000003?ooool00olQ
8B7oooooooooo`02ooooo`03ob4Q8Oo^k^kooooo00;ooooo00Go^[Zjoooooooooooooooooc8b<P05
ooooo`03o`000?oooooooooo0?ooooooH_ooool001kooooo00GoQhN7ofIVI_ooooooIVIVodA4A00<
ooooo`04oeEEEOn7QhOoooooonk^kP;oIVIV0oooool01_o<c<co0000ohN7Qooooooo^[Zjob4Q8@Go
oooo00?o0000ooooooooool0oooooomRooooo`007oooool01?mVIVKo0000oc8b<_o^k^h<ooooo`06
onk^k_mEEEGo0000o`000?mVIVKok^k^1?ooool01OnYZJWo8B4Qo`000?l@413oc<c<00Gooooo00?o
0000ooooooooool0oooooomRooooo`00@oooool2o`000?ooooooHoooool004?ooooo00?o0000oooo
ooooool0oooooomRooooo`00@oooool00ol0003oooooooooo`3oooooof;ooooo0013ooooo`03o`00
0?oooooooooo0?ooooooH_ooool004?ooooo00?o0000ooooooooool0oooooomRooooo`00@oooool0
0ol0003oooooooooo`3oooooof;ooooo0013ooooo`03o`000?oooooooooo0?ooooooH_ooool004?o
oooo0_l0003oooooof?ooooo0013ooooo`03o`000?oooooooooo0?ooooooH_ooool004?ooooo00?o
0000ooooooooool0oooooomRooooo`00@oooool00ol0003oooooooooo`3oooooof;ooooo0013oooo
o`03o`000?oooooooooo0?ooooooH_ooool004?ooooo00?o0000ooooooooool0oooooomRooooo`00
@oooool2o`000?ooooooHoooool004?ooooo00?o0000ooooooooool0oooooomRooooo`00@oooool0
0ol0003oooooooooo`3oooooof;ooooo0013ooooo`03o`000?oooooooooo0?ooooooH_ooool004?o
oooo00?o0000ooooool00000oooooomRooooo`00@oooool01?l0003oooooooooool0003oooooof7o
oooo0013ooooo`04o`000?ooooooooooo`000?ooooooHOooool004?ooooo0_l00002ooooo`03o`00
0?oooooooooo0?ooooooG_ooool004?ooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`3ooooooegooooo0013ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0oooooomL
ooooo`00@oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo0?ooooooFoooool001oo
oooo00CoIVIVo`000?lb<S;ok^k^1Oooool00onHV9So0000oeEEE@03ooooo`05okZj^_l@413o0000
ob4Q8On7QhL02?ooool3o`0000Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3o
oooooe_ooooo000Nooooo`;oQhN700?oooooohN7Qom4A4@01Oooool00olb<S;o0000o`000006oooo
o`04omgMgOmgMgOo8B4Qonk^kPOooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo0?ooooooF_ooool001kooooo00Go<S8booooooooooooooooo`000005
ooooo`03ojVYZOlQ8B7oMgMg00Sooooo00?oV9RHoeEEEOooool00_ooool00olb<S;o0000o`000003
o`0000Gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`3ooooooeWooooo000Noooo
o`06oc8b<_oooooooooooooooolb<S;o^[Zj3?ooool01_mVIVKo0000o`000?m4A4Co410@onk^kP;o
oooo00KoEEEEogMgMoooooooooooo`000?oMgMd5ooooo`?o00001oooool00ol0003oooooooooo`3o
oooooeSooooo000Nooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj2oooool01omVIVKoMgMgonk^
k_o^k^koMgMgo`000?nj^[X00_ooool01Oo^k^ko0000omgMgOoooooo000000Kooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`3ooooooeSooooo000Nooooo`06oc8b<_oooooooooooooo
oolb<S;o^[Zj2oooool00olQ8B7oooooooooo`02ooooo`03ob4Q8Onj^[[ooooo00;ooooo00CoV9RH
odA4A?oooooo00001_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo0?ooooooEooo
ool001kooooo00Go<S8bonk^k_ooooook^k^o`00000<ooooo`03ob4Q8Ooooooooooo00;ooooo00?o
8B4Qonk^k_ooool00oooool00olb<S;o^[Zjo`000006ooooo`03o`000?oooooooooo00Wooooo00?o
0000ooooooooool0oooooomFooooo`007_ooool01On7QhOoIVIVoooooomVIVKoA4A400cooooo00Co
EEEEohN7Qoooooook^k^0_mVIVH5ooooo`03olc<c?lQ8B7o000000Kooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`3ooooooeGooooo000Oooooo`04ofIVI_l0003o<S8bonk^kPcooooo
00Kok^k^oeEEEOl0003o0000ofIVI_o^k^h6ooooo`03ofIVI_l0003ooooo00Gooooo00?o0000oooo
ooooool02oooool00ol0003oooooooooo`3ooooooeCooooo0013ooooo`;o00003Oooool00ol0003o
ooooooooo`3ooooooe?ooooo0013ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool0
oooooomBooooo`00@oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo0?ooooooDOoo
ool004?ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`3ooooooe3ooooo0013oooo
o`03o`000?oooooooooo013ooooo00?o0000ooooooooool0oooooom?ooooo`00@oooool00ol0003o
ooooooooo`0Aooooo`03o`000?oooooooooo0?ooooooC_ooool004?ooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`3oooooodgooooo0013ooooo`;o00005?ooool00ol0003ooooooooo
o`3oooooodcooooo0013ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0oooooom;
ooooo`00@oooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo0?ooooooB_ooool004?o
oooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`3oooooodWooooo0013ooooo`03o`00
0?oooooooooo01Oooooo00?o0000ooooooooool0oooooom8ooooo`00@oooool00ol0003ooooooooo
o`0Hooooo`03o`000?oooooooooo0?ooooooAoooool004?ooooo0_l0000Jooooo`03o`000?oooooo
oooo0?ooooooA_ooool004?ooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`3ooooo
odGooooo0013ooooo`03o`000?oooooooooo01_ooooo00?o0000ooooooooool0oooooom4ooooo`00
@oooool00ol0003oooooooooo`0Looooo`03o`000?oooooooooo0?oooooo@oooool004?ooooo00?o
0000ooooooooool07Oooool00ol0003oooooooooo`3ooooood;ooooo0013ooooo`03o`000?oooooo
oooo01kooooo00?o0000ooooooooool0oooooom1ooooo`00@oooool00ol0003oooooooooo`0Ooooo
o`03o`000?oooooooooo0?oooooo@?ooool004?ooooo0_l0000Qooooo`03o`000?oooooooooo0?oo
oooo?oooool004?ooooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`3oooooockooooo
0013ooooo`03o`000?oooooooooo02;ooooo00?o0000ooooooooool0oooooolmooooo`00@oooool0
0ol0003oooooooooo`0Sooooo`03o`000?oooooooooo0?oooooo??ooool001oooooo00CoIVIVo`00
0?lb<S;ok^k^1Oooool00onHV9So0000oeEEE@03ooooo`05okZj^_l@413o0000ob4Q8On7QhL01ooo
ool01?mVIVKo0000oa0@4?o<c<`5ooooo`03o`000?oooooooooo02Cooooo00?o0000ooooooooool0
oooooolkooooo`007_ooool2ohN7Q`03oooooon7QhOoA4A400Gooooo00?o<S8bo`000?l000001_oo
ool01?oMgMgoMgMgob4Q8Oo^k^h4ooooo`05ogMgMonYZJWoooooolc<c?l000001Oooool00ol0003o
ooooooooo`0Uooooo`03o`000?oooooooooo0?oooooo>_ooool001kooooo00Go<S8boooooooooooo
ooooo`000005ooooo`03ojVYZOlQ8B7oMgMg00Sooooo00?oV9RHoeEEEOooool00oooool01_m4A4Co
oooooooooooooooo<S8bokZj^PCooooo0ol0000Vooooo`;o0000ooooooljooooo`007_ooool01_lb
<S;ooooooooooooooooo<S8bokZj^Pcooooo00KoIVIVo`000?l0003oA4A4oa0@4?o^k^h3ooooo`06
ob4Q8OoooooooooooooooolQ8B7o^[Zj1?ooool00ol0003oooooooooo`0Xooooo`03o`000?oooooo
oooo0?oooooo=oooool001kooooo00Ko<S8boooooooooooooooooc8b<_nj^[X;ooooo`07ofIVI_mg
MgOok^k^onk^k_mgMgOo0000okZj^P03ooooo`05o`000?nHV9SooooooiRHV?l@41001Oooool00ol0
003oooooooooo`0Yooooo`03o`000?oooooooooo0?oooooo=_ooool001kooooo00Ko<S8boooooooo
oooooooooc8b<_nj^[X;ooooo`03ob4Q8Ooooooooooo00;ooooo00?o8B4QokZj^_ooool00_ooool0
1Om4A4Co<S8bo`000?lQ8B7oc<c<00Gooooo00?o0000ooooooooool0:_ooool00ol0003ooooooooo
o`3oooooocGooooo000Nooooo`05oc8b<_o^k^koooooonk^k_l000003?ooool00olQ8B7ooooooooo
o`02ooooo`03ob4Q8Oo^k^kooooo00;ooooo00?oMgMgolc<c?ooool01oooool00ol0003ooooooooo
o`0[ooooo`;o0000ooooooleooooo`007_ooool01On7QhOoIVIVoooooomVIVKoA4A400cooooo00Co
EEEEohN7Qoooooook^k^0_mVIVH4ooooo`04onk^k_l@413oV9RHonk^kPKooooo00?o0000oooooooo
ool0;Oooool00ol0003oooooooooo`3ooooooc;ooooo000Oooooo`04ofIVI_l0003o<S8bonk^kPco
oooo00Kok^k^oeEEEOl0003o0000ofIVI_o^k^h5ooooo`05omgMgOm4A4Co0000o`000?oMgMd01?oo
ool00ol0003oooooooooo`0^ooooo`03o`000?oooooooooo0?oooooo<Oooool004?ooooo0_l0000`
ooooo`;o0000oooooolaooooo`00@oooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo
0?oooooo;_ooool004?ooooo00?o0000ooooooooool0<_ooool00ol0003oooooooooo`3oooooobgo
oooo0013ooooo`03o`000?oooooooooo03?ooooo00?o0000ooooooooool0ooooool/ooooo`00@ooo
ool00ol0003oooooooooo`0dooooo`;o0000ooooool/ooooo`00@oooool00ol0003oooooooooo`0f
ooooo`03o`000?oooooooooo0?oooooo:Oooool004?ooooo0_l0000hooooo`03o`000?oooooooooo
0?oooooo:?ooool004?ooooo00?o0000ooooooooool0>?ooool2o`000?oooooo:?ooool004?ooooo
00?o0000ooooooooool0>_ooool00ol0003oooooooooo`3oooooobGooooo0013ooooo`03o`000?oo
oooooooo03_ooooo00?o0000ooooooooool0oooooolTooooo`00@oooool00ol0003oooooooooo`0l
ooooo`03o`000?oooooooooo0?oooooo8oooool004?ooooo00?o0000ooooooooool0?Oooool2o`00
0?oooooo8oooool004?ooooo00?o0000ooooooooool0?oooool2o`000?oooooo8Oooool004?ooooo
0_l00012ooooo`;o0000oooooolOooooo`00@oooool00ol0003oooooooooo`13ooooo`;o0000oooo
oolMooooo`00@oooool00ol0003oooooooooo`15ooooo`;o0000oooooolKooooo`00@oooool00ol0
003oooooooooo`17ooooo`;o0000oooooolIooooo`00@oooool00ol0003oooooooooo`19ooooo`;o
0000oooooolGooooo`00@oooool00ol0003oooooooooo`1;ooooo`;o0000oooooolEooooo`00@ooo
ool2o`0004kooooo0_l0003ooooooa?ooooo0013ooooo`03o`000?oooooooooo04oooooo0_l0003o
oooooa7ooooo0013ooooo`03o`000?oooooooooo057ooooo00?o0000ooooooooool0ooooool>oooo
o`00@oooool00ol0003oooooooooo`1Booooo`;o0000ooooool>ooooo`007oooool01?mVIVKo0000
oc8b<_o^k^h5ooooo`03oiRHV?l0003oEEEE00?ooooo00Go^[Zjoa0@4?l0003o8B4QohN7Q`06oooo
o`05olc<c?lb<S;o0000oa0@4?nYZJT01Oooool00ol0003oooooooooo`1Dooooo`;o0000ooooool<
ooooo`007_ooool2ohN7Q`03oooooon7QhOoA4A400Gooooo00?o<S8bo`000?l000001_ooool01?oM
gMgoMgMgob4Q8Oo^k^h4ooooo`06oc8b<_nYZJWooooookZj^_l0003ok^k^1?ooool00ol0003ooooo
ooooo`1Fooooo`;o0000ooooool:ooooo`007_ooool01Olb<S;ooooooooooooooooo000000Gooooo
00?oZJVYob4Q8OmgMgL02?ooool00onHV9SoEEEEooooo`03ooooo`06o`000?ooooooooooooooool0
003o^[Zj1?ooool00ol0003oooooooooo`1Hooooo`;o0000ooooool8ooooo`007_ooool01_lb<S;o
oooooooooooooooo<S8bokZj^Pcooooo00KoIVIVo`000?l0003oA4A4oa0@4?o^k^h3ooooo`06oc8b
<_nHV9SoooooohN7Qol0003ok^k^1?ooool3o`0005[ooooo0_l0003oooooo`Kooooo000Nooooo`06
oc8b<_oooooooooooooooolb<S;o^[Zj2oooool01omVIVKoMgMgonk^k_o^k^koMgMgo`000?nj^[X0
0oooool01Oo^k^ko0000o`000?l0003o^[Zj00Gooooo00?o0000ooooooooool0G?ooool2o`000?oo
oooo1?ooool001kooooo00Ko<S8boooooooooooooooooc8b<_nj^[X;ooooo`03ob4Q8Ooooooooooo
00;ooooo00?o8B4QokZj^_ooool00_ooool01OmVIVKoV9RHoooooonHV9SoA4A400Gooooo00?o0000
ooooooooool0G_ooool2o`000?oooooo0_ooool001kooooo00Go<S8bonk^k_ooooook^k^o`00000<
ooooo`03ob4Q8Ooooooooooo00;ooooo00?o8B4Qonk^k_ooool00_ooool01OlQ8B7ooooooooooooo
oooo8B4Q00Gooooo00?o0000ooooooooool0H?ooool2o`000?oooooo000Nooooo`05ohN7QomVIVKo
ooooofIVI_m4A4@03?ooool01?mEEEGoQhN7ooooooo^k^h2ofIVIPCooooo00Go8B4Qoooooooooooo
ooooob4Q8@05ooooo`03o`000?oooooooooo06;ooooo0ol0003looooo`007oooool01?mVIVKo0000
oc8b<_o^k^h<ooooo`06onk^k_mEEEGo0000o`000?mVIVKok^k^1?ooool01Om4A4CoV9RHoooooonH
V9SoA4A400Gooooo00?o0000ooooooooool0IOooool4o`000?Sooooo000iooooo`05onk^k_lb<S;o
0000oc8b<_o^k^h01Oooool2o`0006[ooooo0ol0003eooooo`00@oooool00ol0003oooooooooo`1/
ooooo`Co0000lOooool004?ooooo00?o0000ooooooooool0L?ooool4o`000>gooooo0013ooooo`03
o`000?oooooooooo07Cooooo0ol0003Zooooo`00@oooool00ol0003oooooooooo`1gooooo`Co0000
i_ooool004?ooooo00?o0000ooooooooool0Noooool4o`000>;ooooo0013ooooo`03o`000?oooooo
oooo07oooooo0ol0003Oooooo`00@oooool2o`0008?ooooo1?l0003Kooooo`00@oooool00ol0003o
ooooooooo`26ooooo`Co0000eoooool004?ooooo00?o0000ooooooooool08?ooool00ol@413o0000
o`000002o`000003omgMgOoooooooooo00;ooooo00CoIVIVo`000?lb<S;ok^k^6oooool00on7QhOo
0000o`000002o`000003oa0@4?oooooooooo00?ooooo00CoIVIVo`000?lb<S;ok^k^6oooool01_nj
^[[oA4A4o`000?l0003o8B4Qolc<c0Gooooo00CoIVIVo`000?lb<S;ok^k^2?ooool3o`0001?ooooo
0ol00005ooooo`04ofIVI_l0003o<S8bonk^kQ_ooooo00Koc<c<ob4Q8Ol0003o0000oc8b<_oMgMd5
ooooo`04ofIVI_l0003o<S8bonk^kQgooooo00CoIVIVo`000?l@413oc<c<1Oooool01?mVIVKo0000
oc8b<_o^k^iQooooo`00@oooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo00Cooooo
0_n7QhL00oooooooQhN7odA4A00Kooooo`03onk^k_lb<S;oc<c<00Oooooo0_n7QhL00oooooooQhN7
odA4A00Kooooo`07ojVYZOnHV9Sooooooooooonj^[[o0000onk^kP03ooooo`;oQhN700?oooooohN7
Qom4A4@02oooool4o`00013ooooo00?o0000ooooooooool00oooool2ohN7Q`03oooooon7QhOoA4A4
01_ooooo00Koc<c<ojVYZOoooooooooooiRHV?lQ8B44ooooo`;oQhN700?oooooohN7Qom4A4@07?oo
ool01OmgMgOoZJVYooooooo<c<co000000Cooooo0_n7QhL00oooooooQhN7odA4A01Qooooo`00@ooo
ool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo00Cooooo00Go<S8boooooooooooooooo
o`00000Looooo`03onk^k_lb<S;oZJVY00Kooooo00Go<S8booooooooooooooooo`00000Pooooo`03
oc8b<_nj^[[ooooo00;ooooo00Go<S8booooooooooooooooo`00000?ooooo`Co00002?ooool00olb
<S;o0000o`000003o`0000Cooooo00Go<S8booooooooooooooooo`00000Pooooo`03ob4Q8Onj^[[o
oooo00;ooooo00Go<S8booooooooooooooooo`00000Looooo`06odA4A?oooooooooooooooolb<S;o
^[Zj0oooool01Olb<S;ooooooooooooooooo0000067ooooo0013ooooo`03o`000?oooooooooo02;o
oooo00?o0000ooooooooool01?ooool01_lb<S;ooooooooooooooooo<S8bokZj^Qcooooo00?ok^k^
ob4Q8OnHV9P01Oooool01_lb<S;ooooooooooooooooo<S8bokZj^Qkooooo00?ok^k^o`000?oMgMd0
0oooool01_lb<S;ooooooooooooooooo<S8bokZj^Q;ooooo0ol00005ooooo`06oeEEEOmgMgOooooo
ooooool0003ogMgM1?ooool01_lb<S;ooooooooooooooooo<S8bokZj^Qoooooo00?o8B4QokZj^_oo
ool00_ooool01_lb<S;ooooooooooooooooo<S8bokZj^Q_ooooo00Ko8B4Qooooooooooooooooob4Q
8Onj^[X3ooooo`06oc8b<_oooooooooooooooolb<S;o^[ZjH?ooool004?ooooo0_l0000Sooooo`03
o`000?oooooooooo00Cooooo00Ko<S8boooooooooooooooooc8b<_nj^[XMooooo`03onk^k_lb<S;o
c<c<00Cooooo00Ko<S8boooooooooooooooooc8b<_nj^[XMooooo`03ofIVI_l@413oQhN700Cooooo
00Ko<S8boooooooooooooooooc8b<_nj^[XEooooo`Co000000Koooooonk^k_l0003ogMgMooooool0
0005ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj6oooool01OmVIVKogMgMoooooon7QhOo410@
00Cooooo00Ko<S8boooooooooooooooooc8b<_nj^[XKooooo`05o`000?nHV9SooooooiRHV?l@4100
1?ooool01_lb<S;ooooooooooooooooo<S8bokZj^V3ooooo0013ooooo`03o`000?oooooooooo02;o
oooo00?o0000ooooooooool01?ooool01_lb<S;ooooooooooooooooo<S8bokZj^Qkooooo00?ok^k^
odA4A?ooool00oooool01_lb<S;ooooooooooooooooo<S8bokZj^Qgooooo00?ogMgMogMgMomVIVH0
1?ooool01_lb<S;ooooooooooooooooo<S8bokZj^QWooooo1ol00004ooooo`06oc8b<_oooooooooo
oooooolb<S;o^[Zj6oooool01Ol0003o8B4Qo`000?l@413oc<c<00Cooooo00Ko<S8boooooooooooo
oooooc8b<_nj^[XKooooo`05odA4A?lb<S;o0000ob4Q8Oo<c<`01?ooool01_lb<S;ooooooooooooo
oooo<S8bokZj^V3ooooo0013ooooo`03o`000?oooooooooo02;ooooo00?o0000ooooooooool01?oo
ool01Olb<S;ok^k^ooooooo^k^ko000001cooooo00Go^[Zjoooooooooooooooooc8b<P04ooooo`05
oc8b<_o^k^koooooonk^k_l000008?ooool00ol0003oooooooooo`02ooooo`05oc8b<_o^k^kooooo
onk^k_l000007Oooool01?lb<S;o^[Zjo`000?ooool:o`0001_ooooo00?o0000ooooooooool01_oo
ool01Olb<S;ok^k^ooooooo^k^ko000001cooooo00?oMgMgolc<c?ooool01_ooool01Olb<S;ok^k^
ooooooo^k^ko0000067ooooo0013ooooo`03o`000?oooooooooo023ooooo00?oQhN7okZj^_l00000
1_ooool01On7QhOoIVIVoooooomVIVKoA4A401_ooooo00Koc<c<o`000?n7QhOooooookZj^_lQ8B44
ooooo`05ohN7QomVIVKoooooofIVI_m4A4@07?ooool01Om4A4Co^[ZjoooooonHV9So410@00Cooooo
00GoQhN7ofIVI_ooooooIVIVodA4A00Mooooo`03olc<c?lQ8B7o000000Gooooo00KoQhN7ofIVI_oo
ooooIVIVodA4A?ooool;o`00013ooooo00?o0000ooooooooool01_ooool01On7QhOoIVIVoooooomV
IVKoA4A401cooooo00Cok^k^oa0@4?nHV9Sok^k^1Oooool01On7QhOoIVIVoooooomVIVKoA4A4067o
oooo0013ooooo`03o`000?oooooooooo023ooooo00?oQhN7oc8b<_l000001oooool01?mVIVKo0000
oc8b<_o^k^hLooooo`05ojVYZOlQ8B7o0000oa0@4?o<c<`01Oooool01?mVIVKo0000oc8b<_o^k^hL
ooooo`05ohN7Qol@413o0000oa0@4?o<c<`01Oooool01?mVIVKo0000oc8b<_o^k^hNooooo`03ofIV
I_l0003ooooo00Gooooo00CoIVIVo`000?lb<S;ok^k^3?ooool:o`0000Kooooo1?l000000ol@413o
ooooooooo`03ooooo`04ofIVI_l0003o<S8bonk^kQgooooo00GogMgModA4A?l0003o0000omgMg@04
ooooo`04ofIVI_l0003o<S8bonk^kV7ooooo0013ooooo`03o`000?oooooooooo0<;ooooo2_l0002E
ooooo`00@oooool00ol0003oooooooooo`3<ooooo`[o0000Roooool004?ooooo0_l0003Gooooo`[o
0000POooool004?ooooo00?o0000ooooooooool0h?ooool;o`0003Sooooo00GoEEEEo`000?l0003o
A4A4onk^kP0`ooooo`?o000000?o<S8booooooooool00oooool004?ooooo00?o0000ooooooooool0
joooool:o`00037ooooo00?oQhN7oc8b<_ooool05Oooool00oo<c<co0000onk^kP0Gooooo`03okZj
^_l0003ooooo00Kooooo0013ooooo`03o`000?oooooooooo0?Gooooo1Ol0000]ooooo`03o`000?oo
oooooooo01Cooooo00?ok^k^o`000?mEEED05oooool00onj^[[o0000ooooo`06ooooo`00@oooool0
0ol0003oooooooooo`3oooooo`Sooooo00?o410@o`000?l000000ol000001Olb<S;ooooooooooooo
ooooIVIV00?o000000GoA4A4oiRHV?oooooooooooa0@4002o`000004ooooool0003o0000oa0@40?o
oooo00GoIVIVo`000?l0003oIVIVo`000005ooooo`08oiRHV?l@413o0000oa0@4?mEEEGoc<c<oooo
ool@4102o`000004ooooool0003o0000oa0@40Cooooo00?oA4A4o`000?nj^[X03Oooool00ol@413o
0000ofIVIP02o`000007ogMgMooooooooooooooooonj^[[o0000oiRHV002o`000003ofIVI_oooooo
oooo007ooooo0013ooooo`03o`000?oooooooooo0?oooooo2oooool00ol0003oooooooooo`03oooo
o`07ogMgMomEEEGok^k^ooooooo^k^koV9RHoc8b<P03ooooo`05o`000?ooooooooooooooool00000
0oooool01_mgMgOoEEEEonk^k_oMgMgo8B4Qo`0000Gooooo00Ko0000olc<c?oooooogMgMohN7QonY
ZJT2ooooo`05o`000?ooooooooooooooool000001Oooool00onHV9So0000oc8b<P0>ooooo`04o`00
0?m4A4Cok^k^ooooo`;oMgMg0_ooool00onj^[[o0000ogMgM`02ooooo`;oMgMg0_ooool004?ooooo
00?o0000ooooooooool0ooooool;ooooo`03o`000?oooooooooo00?ooooo00?o0000onk^k_ooool0
1oooool01Ol0003ooooooooooooooooo000000?ooooo00Ko8B4Qooooooooooooooooolc<c?l00005
ooooo`03o`000?oooooooooo00Gooooo00Go0000ooooooooooooooooo`00000Fooooo`03o`000?oM
gMgooooo00;ooooo00Go<S8boooooooooooo^[Zjoa0@4004ooooo`7o8B4Q0Oooool1ooooo`00?Ooo
ooooo`0000[o00002_ooool00ol0003oooooooooo`03ooooo`Oo000000CogMgMoooooooooooo0000
0oooool01Ol0003ooooooooooooooooo<S8b00Cooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`05ooooo`05o`000?ooooooooooooooool000005_ooool00ol0003oooooooooo`02oooo
o`05oc8b<_oooooooooookZj^_lb<S801?ooool1oc8b<P7ooooo0Oooool004_ooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00kooooo00?o0000oooo
ooooool00oooool00ol@413ogMgMooooo`02ooooo`03oiRHV?l0003ooooo00;ooooo00Go0000oooo
ooooooooooooo`000003ooooo`06oc8b<_oooooooooooooooooMgMgo00001Oooool00ol0003ooooo
ooooo`05ooooo`05o`000?ooooooooooooooool000005_ooool00ol0003ogMgMooooo`02ooooo`06
oc8b<_oooooooooookZj^_l0003ok^k^0_ooool00oo^k^ko8B4Qooooo`01ooooo`00oooooomAoooo
o`03o`000?oooooooooo00?ooooo00OoMgMgob4Q8OoMgMgoooooomgMgOl@413oIVIV00?ooooo00Go
0000ohN7Qooooooo^[Zjoa0@4003ooooo`;oMgMg00Coooooonk^k_m4A4Co00000oooool00ol@413o
0000o`000003o`000009ogMgMoooooooooooooooool0003oQhN7oooooonj^[[o410@01Kooooo00Co
0000odA4A?o^k^kooooo0_mgMgL2ooooo`03okZj^_l0003oA4A400;ogMgM00?oA4A4ogMgMoooool0
0Oooool00?ooooooDOooool00ol0003oooooooooo`04ooooo`05ogMgMol@413o0000oa0@4?mgMgL0
0oooool2o`000004ofIVI_l0003o0000okZj^PCooooo00KoIVIVo`000?l0003oEEEEo`000?lb<S84
ooooo`03oc8b<_oooooooooo00Gooooo00Go0000ogMgMol0003o0000okZj^P0Fooooo`05o`000?mV
IVKo0000o`000?mVIVH00oooool00ol@413o0000ogMgM`02o`000003ofIVI_oooooooooo007ooooo
003ooooooe7ooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo01Sooooo00?o0000ooooooooool03_ooool00?ooooooDOooool00ol0003oooooooooo`0P
ooooo`03oa0@4?oooooooooo00Gooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0>
ooooo`00oooooom?ooooo`03oa0@4?l0003o000002Wooooo00?o410@o`000?ooool06?ooool00ol@
413o0000ooooo`0?ooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonX
ooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonX
ooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonX
ooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`003Oooool00omEEEGoc<c<oooo
o`0?ooooo`?o000000?o410@ooooooooool05?ooool00oo<c<coEEEEooooo`0Iooooo`03oeEEEOo<
c<cooooo02Wooooo00?oc<c<oeEEEOooool0oooooolTooooo`003?ooool00onYZJWo8B4Qooooo`0B
ooooo`03o`000?oooooooooo01Kooooo00?o8B4QojVYZOooool05oooool00onYZJWo8B4Qooooo`0[
ooooo`03ob4Q8OnYZJWooooo0?oooooo8oooool000cooooo00?oEEEEoiRHV?ooool04_ooool00ol0
003oooooooooo`0Fooooo`03oiRHV?mEEEGooooo00?ooooo00?oc<c<oc8b<_ooool04Oooool00omE
EEGoV9RHooooo`0[ooooo`03oiRHV?mEEEGooooo0?oooooo8oooool00005oa0@4?l0003o0000o`00
0?l@41001oooool00olb<S;ok^k^ooooo`05ooooo`06ofIVI_l0003o0000o`000?m4A4CoV9RH0ooo
ool01OmVIVKo0000o`000?mgMgOo000000oooooo0ol00006ooooo`03onk^k_lb<S;ooooo00Cooooo
00?o410@okZj^_ooool01?ooool01Ol@413o0000o`000?l0003o410@00Oooooo00?o<S8bonk^k_oo
ool01_ooool02?nHV9So410@o`000?l@413oEEEEolc<c?oooooo410@1?l000000ol@413ooooooooo
o`02ooooo`07olc<c?l@413o0000oa0@4?mgMgOo0000oa0@4002ooooo`06ofIVI_l0003o0000o`00
0?m4A4CoV9RH1Oooool00oo^k^ko<S8booooo`3oooooob?ooooo0002ooooo`03o`000?oooooooooo
00Oooooo00?o410@ooooooooool01?ooool01omgMgOoEEEEonk^k_ooooook^k^oiRHV?lb<S800_oo
ool2ogMgM`04ooooooo^k^koA4A4o`00013ooooo00?o0000ooooooooool01_ooool00ol@413ooooo
ooooo`03ooooo`03oiRHV?lb<S;ooooo00Kooooo00?o0000ooooooooool01oooool00ol@413ooooo
ooooo`06ooooo`06o`000?o<c<coooooomgMgOn7QhOoZJVY0oooool00ol0003oooooooooo`05oooo
o`06ob4Q8OnHV9SooooooooooomEEEGo00000_ooool01omgMgOoEEEEonk^k_ooooook^k^oiRHV?lb
<S801_ooool00ol@413oooooooooo`3oooooob;ooooo0002ooooo`03o`000?oooooooooo00Oooooo
00?o<S8booooooooool01?ooool00ol0003ok^k^ooooo`06ooooo`06ob4Q8OoooooooooooooooooM
gMgo00003?ooool00olb<S;o0000o`000003o`0000Oooooo00?o<S8booooooooool01?ooool00ol0
003o^[Zjooooo`05ooooo`03o`000?oooooooooo00Oooooo00?o<S8booooooooool01_ooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo00Gooooo00Ko0000ooooooooooooooooonk^k_l0
0002ooooo`03o`000?o^k^kooooo00[ooooo00?o<S8booooooooool0oooooolRooooo`000_ooool0
0ol0003oooooooooo`07ooooo`03oc8b<_oooooooooo00Cooooo1ol000000ooMgMgooooooc8b<P04
ooooo`03o`000?oooooooooo00[ooooo00KoEEEEogMgMoooooooooooo`000?oMgMd7ooooo`03oc8b
<_oooooooooo00Cooooo00?oMgMgoc8b<_ooool01Oooool00ol0003oooooooooo`07ooooo`03oc8b
<_oooooooooo00Kooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`05ooooo`06o`00
0?ooooooooooooooooo<c<co00000_ooool7o`000003omgMgOoooooooooo00?ooooo00?o<S8boooo
ooooool0oooooolRooooo`000_ooool4o`0000Kooooo00?o410@ooooooooool01?ooool00ol@413o
gMgMooooo`02ooooo`05oiRHV?l0003ooooooooooolb<S800oooool00ooMgMgo0000ooooo`0;oooo
o`05onk^k_l0003ogMgMooooool000002?ooool00ol@413oooooooooo`04ooooo`03onk^k_l0003o
gMgM00Gooooo1?l00006ooooo`03oa0@4?oooooooooo00Kooooo00?o0000ooooooooool01_ooool0
0ol0003oc<c<ooooo`05ooooo`06o`000?oooooooooooooooon7QhOo00000_ooool00ol@413ogMgM
ooooo`02ooooo`03oiRHV?l0003ooooo00Gooooo00?o410@ooooooooool0oooooolRooooo`000_oo
ool00ol0003oooooooooo`07ooooo`03oc8b<_o^k^kooooo00Cooooo00OoMgMgob4Q8OoMgMgooooo
omgMgOl@413oIVIV00;ooooo0_mgMgL01?ooooook^k^odA4A?l0000=ooooo`04oiRHV?m4A4Cooooo
o`0000Oooooo00?ok^k^oc8b<_ooool01_ooool00omgMgOoEEEEooooo`04ooooo`03o`000?oooooo
oooo00Oooooo00?o<S8bonk^k_ooool01?ooool00ol@413o0000o`000003o`000003ogMgMooooooo
oooo00;ooooo00Ko0000oc8b<_nHV9SooooookZj^_oMgMd2ooooo`06o`000?oooooooooooooooom4
A4Co00000_ooool01omgMgOo8B4QomgMgOoooooogMgMoa0@4?mVIVH01Oooool00oo^k^ko<S8boooo
o`3oooooob?ooooo0002ooooo`03o`000?oooooooooo00;ooooo00?o8B4Qooooooooool00_ooool0
0omEEEGoV9RHooooo`05ooooo`05ogMgMol@413o0000oa0@4?mgMgL01?ooool01_mVIVKo0000o`00
0?mVIVKo0000oa0@40gooooo00?o<S8bokZj^_l000001oooool00onHV9SoEEEEooooo`06ooooo`03
onk^k_l0003ogMgM00Cooooo00?o0000ooooooooool00_ooool00olQ8B7oooooooooo`02ooooo`03
oeEEEOnHV9Sooooo00Kooooo00?o<S8booooooooool01?ooool01Ol@413o0000o`000?o^k^koIVIV
00;o000000CoZJVYooooool@413o00000_ooool3o`0000?ooooo00GoMgMgoa0@4?l0003o410@ogMg
M`06ooooo`03oiRHV?mEEEGooooo0?oooooo8oooool000;ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`02ooooo`03oiRHV?lQ8B7ooooo027ooooo00?oc<c<ob4Q8Ol000001oooool0
0olQ8B7oZJVYooooo`07ooooo`03ogMgMomEEEGooooo00?ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`02ooooo`03oiRHV?lQ8B7ooooo00Kooooo00?o0000ooooooooool08_ooool0
0olQ8B7oZJVYooooo`3oooooob?ooooo00000ol@413o0000o`000005o`0000Gooooo00?oA4A4olc<
c?ooool08Oooool00omVIVKo0000ooooo`05ooooo`03olc<c?m4A4Cooooo00Sooooo00GogMgMo`00
0?oMgMgooooooa0@4007o`0000Gooooo00?oA4A4olc<c?ooool01Oooool00ol@413oooooooooo`0Q
ooooo`03olc<c?m4A4Cooooo0?oooooo9?ooool004Gooooo00?oIVIVohN7Qoooool0oooooomPoooo
o`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXoooo
o`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXoooo
o`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXoooo
o`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXoooo
o`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXoooo
o`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXooooo`00oooooonXoooo
o`00\
\>"],
  ImageRangeCache->{{{0, 422}, {260, 0}} -> {-16.0419, 0.881782, 0.356481, \
0.000918701}}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{0, 1440}, {0, 877}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{714, 822},
WindowMargins->{{6, Automatic}, {Automatic, 2}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1.5
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 317, 6, 125, "Text"],

Cell[CellGroupData[{
Cell[2096, 61, 145, 4, 41, "Subsubsection"],
Cell[2244, 67, 194, 7, 58, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[2441, 76, 112, 2, 38, "Input",
  InitializationCell->True],
Cell[2556, 80, 220, 8, 98, "Input",
  InitializationCell->True],
Cell[2779, 90, 166, 3, 58, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[2970, 97, 108, 2, 38, "Input"],
Cell[3081, 101, 2215, 61, 359, "Output"]
}, Closed]],
Cell[5311, 165, 95, 1, 40, "Text"],
Cell[5409, 168, 264, 7, 98, "Input",
  InitializationCell->True],
Cell[5676, 177, 84, 1, 47, "Text"],
Cell[5763, 180, 870, 16, 312, "Text"],
Cell[6636, 198, 164, 6, 78, "Input"],

Cell[CellGroupData[{
Cell[6825, 208, 131, 2, 38, "Input"],
Cell[6959, 212, 234, 11, 89, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7230, 228, 71, 1, 38, "Input"],
Cell[7304, 231, 114, 7, 63, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7455, 243, 76, 1, 38, "Input"],
Cell[7534, 246, 207, 7, 37, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7778, 258, 203, 6, 78, "Input"],
Cell[7984, 266, 147287, 2777, 488, 35318, 1390, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[155320, 3049, 139, 4, 41, "Subsubsection"],
Cell[155462, 3055, 233, 8, 158, "Input",
  InitializationCell->True],
Cell[155698, 3065, 105, 2, 38, "Input",
  InitializationCell->True],
Cell[155806, 3069, 664, 20, 398, "Input",
  InitializationCell->True],
Cell[156473, 3091, 91, 1, 47, "Text"],
Cell[156567, 3094, 195, 5, 138, "Input"],

Cell[CellGroupData[{
Cell[156787, 3103, 64, 1, 38, "Input"],
Cell[156854, 3106, 377, 14, 113, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[157268, 3125, 85, 1, 38, "Input"],
Cell[157356, 3128, 377, 14, 113, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[157770, 3147, 73, 1, 38, "Input"],
Cell[157846, 3150, 352, 15, 115, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[158247, 3171, 95, 1, 41, "Subsubsection"],
Cell[158345, 3174, 144, 4, 73, "Text"],
Cell[158492, 3180, 373, 14, 198, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[158868, 3196, 234, 6, 118, "Input",
  InitializationCell->True],
Cell[159105, 3204, 655, 19, 418, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[159797, 3228, 93, 1, 41, "Subsubsection"],
Cell[159893, 3231, 235, 8, 158, "Input",
  InitializationCell->True],
Cell[160131, 3241, 1011, 29, 718, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[161179, 3275, 158, 4, 64, "Subsubsection"],
Cell[161340, 3281, 128, 4, 47, "Text"],
Cell[161471, 3287, 298, 8, 98, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[161772, 3297, 265, 8, 98, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[162040, 3307, 453, 11, 258, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[162496, 3320, 360, 8, 258, "Input"],

Cell[CellGroupData[{
Cell[162881, 3332, 61, 1, 38, "Input"],
Cell[162945, 3335, 83, 1, 33, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[163065, 3341, 185, 5, 78, "Input"],
Cell[163253, 3348, 39440, 923, 273, 4854, 492, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],

Cell[CellGroupData[{
Cell[202730, 4276, 167, 5, 58, "Input"],
Cell[202900, 4283, 36358, 857, 273, 4726, 462, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],

Cell[CellGroupData[{
Cell[239295, 5145, 178, 5, 78, "Input"],
Cell[239476, 5152, 35859, 876, 302, 4553, 485, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],

Cell[CellGroupData[{
Cell[275372, 6033, 155, 4, 58, "Input"],
Cell[275530, 6039, 27963, 747, 273, 4557, 454, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[303542, 6792, 139, 4, 41, "Subsubsection"],
Cell[303684, 6798, 455, 8, 151, "Text"],
Cell[304142, 6808, 153, 11, 198, "Input"],

Cell[CellGroupData[{
Cell[304320, 6823, 866, 28, 678, "Input"],
Cell[305189, 6853, 1648, 74, 105, "Print"]
}, Closed]],
Cell[306852, 6930, 100, 1, 40, "Text"],

Cell[CellGroupData[{
Cell[306977, 6935, 122, 4, 58, "Input"],
Cell[307102, 6941, 2330, 76, 321, "Output"]
}, Open  ]],
Cell[309447, 7020, 88, 4, 58, "Input"],

Cell[CellGroupData[{
Cell[309560, 7028, 191, 6, 98, "Input"],
Cell[309754, 7036, 30506, 736, 273, 3998, 404, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

