(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    607406,       9846]*)
(*NotebookOutlinePosition[    608302,       9877]*)
(*  CellTagsIndexPosition[    608258,       9873]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
CHR   20 April 1993
Final calculations for Figure 2 in the hydrodynamics paper... I leave the \
Garcia de la Torre results at the values already calculated (in Figure 2 \
data-- \"Garcia de la Torre Final\" or Cricket Graph file) and use my \
Kirkwood subroutine on radii and intersphere distances calculated for this \
example, which is particularly simple since the DNA is treated in the rigid \
limit.\
\>", "SmallText",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
Notice that the Yamakawa and Fujii equation for the sedimentation \
behavior in the limit of an infinite persistence length (rigid rod) reduces \
to 3.620 (log[masstrue]-3.552) For Kovacic and van Holde's fit to the DNA \
data.\
\>", "SmallText",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
t=.;
NAvo=6.02 10^23;
ro=1.003;\t\t\t\t\t\t(* density, g/cm^3 *)
visc=0.01016;\t\t\t\t\t(* viscosity, g/(cm s) or \"Poise\" *)
persistencelength=34000 10^-8;\t(* persistence length, cm *)
el=3.4 10^-8;\t\t\t\t\t(* height of basepair, cm *)
lx={0,0,1};\t\t\t\t\t\t(* chain vector for a basepair *)
ctorsion=2.4 10^-19;\t\t\t(* not used-- ergs/radian? *)
mhistone=108500;\t\t\t\t(* octamer mol. weight, g/mole *)
mbp=660;\t\t\t\t\t\t(* basepair mol. weight, g/mole *)
vdna=0.55;\t\t\t\t\t\t(* specific volume of DNA, cm^3/g *)
vhistone=0.75;\t\t\t\t\t(* same but of protein, cm^3/g *)
score=10.7 10^-13;\t\t\t\t(* core sedimentation coeff, sec *)
dDNA=27 10^-8;\t\t\t\t\t(* Yamagawa-Fujii (Y-F) diam, cm *)
switchbp=50;\t\t\t\t\t(* point at which we switch from *)
\t\t\t\t\t\t\t\t(* Y-F to ellipsoid model, bp *)\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->False,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
doKirkwoodG:=Block[{i,j,sum,sumradii},
\t(*\tCalculates friction and sedimentation coefficients, f1 and
\t\ts1, according to the standard Kirkwood-Riseman theory.\t*)
\tsumradii=Sum[radii[[i]],{i,ntot}];
\tsum=0;
\tDo[\tDo[\trirj=N[radii[[i]] radii[[j]]];
\t\t\tIf[\trirj>0,
\t\t\t\tdelsum=rirj/rij[[i,j]],
\t\t\t\tdelsum=0
\t\t\t];
\t\t\tIf[\ttest,
\t\t\t\tPrint[\"   i,j,rij(cm): \",i,\" \",j,\" \",N[rij[[i,j]]]]
\t\t\t];
\t\t\tsum=sum+delsum,
\t\t{j,i+1,ntot}],
\t{i,ntot}];
\t(* Notice we only counted the distance of each pair once,
\t   but we multiplied by two to make up for it.  Now calculate
\t   frictional coeff and convert from basepairs to cm: *)
\tffree=6 Pi visc sumradii g/s;
\tf1=6 Pi visc sumradii/(1 + 2 sum/sumradii) g/s;
\tPrint[\"   Kirkwood results: {f free-draining,f1}\"];
\tPrint[\"   \",N[{ffree,f1}]]
];\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
snaked[i_]:=Module[{j},
\ts1=3.620 (Log[10,i 660]-3.552) 10^-13;
\trstokes=((i 660) (1-vdna ro)/(NAvo s1))/(6 Pi visc)
];\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
Define radii of rigid-model DNA spheres and of globular region in \
cm:\
\>", "Text",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
r1=57 10^-8;
r2=16.534 10^-8; (*\tEqual volume achieved
\t\t\t\t\tby r2=Sqrt[3/2] 13.5 A *)\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["Values of the ratio L = length/r1 to use in the comparison.", "Text",
  AspectRatioFixed->False,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
(*\tValues of length/r1 to use in comparison and corresponding
\tnumbers of basepairs: *)
lengthp={3,4,5,6,8,10,12,14,16};
nbasepairs=(lengthp r1)/(3.4 10^-8);\
\>", "Input",
  AspectRatioFixed->False,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["nbasepairs", "Input",
  AspectRatioFixed->False,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!PS-Adobe-2.0 EPSF-1.2
%%BoundingBox: 6 6 788 45
%%HiResBoundingBox: 6 6 787.5 45
%%Creator: (Mathematica 5.2 for Macintosh)
%%CreationDate: (Monday, March 30, 2020) (20:40:43)
%%Title: Clipboard
%%DocumentNeededResources: (atend)
%%DocumentFonts: (atend)
%%DocumentNeededFonts: (atend)
%%EndComments
0 51 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def

%%MathematicaCell
%Cell[GraphicsData[\"PICT\", \\
%\"\\<\\
%0;P04`0X02d2<@0A0_l<0?ooool0:00001<0008a0000;@\\
%000000000N00402P0C
%02P0;@9@02`02P0F1d=_MG9YIG800`0F00d0300^00@0000002/Y7DUk=C0^<STd
%<B`P=SL^<3Dh>2`P>3<^>38c=B`P<C0`;SDh>2`P<C<d;S4a>2`P<CHg;SHd=b`P
%<S0a;S4g=R`P<S<d;SL`=R`P02X70B0002X72R0P<SHh;S8c=Gd0o`\\>\"], \\
%\"Graphics\",
%  ImageSize->{521, 26},
%  ImageMargins->{{0, Inherited}, {Inherited, Inherited}},
%  ImageRegion->{{-0, 1}, {0, 1}}]
%%EndMathematicaCell
1.5 setlinewidth
/Courier findfont 12 scalefont setfont
8 21 moveto ({50.2941, 67.0588, 83.8235, 100.588, 134.118, 167.647, 201.176, \
234.706, ) show
/Courier findfont 12 scalefont setfont
8 32 moveto ( ) show
/Courier findfont 12 scalefont setfont
8 42 moveto (  268.235}) show
%%Trailer
%%EOF
\
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{782, 38.9375},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000BE0000>R000`400?l00000o`00003ooooooooo
oooooooooooooooooonIooooo`00JOooool2o`000?oooooooooooooooooooooooooo;_ooool006_o
oooo00?o0000ooooooooool0ooooooooooooooooooooooooool[ooooo`00Joooool00ol0003ooooo
ooooo`3oooooooooooooooooooooooooob_ooooo001[ooooo`03o`000?oooooooooo0?oooooooooo
oooooooooooooooo:oooool001[ooooo2?l00006ooooo`?o00002?ooool3o`0000Sooooo00?o0000
ooooooooool01Oooool8o`0000Gooooo1?l00007ooooo`Co00002Oooool00ol0003oooooooooo`3o
ooooooooooooooooooooooooob_ooooo000Kooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool00oooool01Ol0003ooooooooooooooooo000000Kooooo00Go0000ooooooooooooooooo`00
0007ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0oooooooooooooooooooooooo
ool[ooooo`007?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00kooooo00?o0000
ooooooooool01_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`3oooooooooooooooooooooooooob_ooooo000Moooo
o`03o`000?oooooooooo00Kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0<oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`3ooooo
ooooooooooooooooooooob[ooooo000Nooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000004oooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`3oooooooooooooooooooooooooob_ooooo000Oooooo`03o`000?oooooooooo00Co
oooo0_l00003ooooo`03o`000?oooooooooo00Gooooo0ol0000Eooooo`03o`000?oooooooooo00Ko
oooo0ol0000;ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0oooooooooooooooo
ooooooooool[ooooo`008?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo000000;o0000
1oooool01Ol0003ooooooooooooooooo000001Gooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`03ooooo`Go00002Oooool00ol0003oooooooooo`3oooooooooooooooooooooooooob_o
oooo000Jooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool03?ooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`0;ooooo`03o`000?oooooooooo0?oooooooooooooooooooooooooo:oooool001[ooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00Cooooo00Go
0000ooooooooooooooooo`000006ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`3oooooooooooooooooooooooooob_ooooo000Kooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`07ooooo`05o`000?oo
ooooooooooooool000004?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00_ooooo
00?o0000ooooooooool0ooooooooooooooooooooooooool[ooooo`007?ooool4o`0000Wooooo0_l0
0008ooooo`?o00004_ooool4o`0000Oooooo1?l00006ooooo`Oo00001Oooool2o`000?oooooooooo
oooooooooooooooo;_ooool00?ooooooooooooooooooooooooooVOooool00?oooooooooooooooooo
ooooooooVOooool00?ooooooooooooooooooooooooooVOooool00?oooooooooooooooooooooooooo
VOooool00?ooooooooooooooooooooooooooVOooool00?ooooooooooooooooooooooooooVOooool0
0?ooooooooooooooooooooooooooVOooool00?ooooooooooooooooooooooooooVOooool00?oooooo
ooooooooooooooooooooVOooool00?ooooooooooooooooooooooooooVOooool00?oooooooooooooo
ooooooooooooVOooool00?ooooooooooooooooooooooooooVOooool00?oooooooooooooooooooooo
ooooVOooool00?ooooooooooooooooooooooooooVOooool00?ooooooooooooooooooooooooooVOoo
ool00?ooooooooooooooooooooooooooVOooool000Wooooo0_l0003ooooooooooooooooooooooooo
ohkooooo0008ooooo`03o`000?oooooooooo0?ooooooooooooooooooooooooooS_ooool000Sooooo
00?o0000ooooooooool0E?ooool00ol0003oooooooooo`1Pooooo`03o`000?oooooooooo063ooooo
00?o0000ooooooooool0H?ooool00ol0003oooooooooo`1Pooooo`03o`000?oooooooooo063ooooo
00?o0000ooooooooool0H?ooool00ol0003oooooooooo`1Pooooo`03o`000?oooooooooo0?oooooo
Ooooool000Sooooo00?o0000ooooooooool0EOooool00ol0003oooooooooo`1Pooooo`03o`000?oo
oooooooo063ooooo00?o0000ooooooooool0H?ooool00ol0003oooooooooo`1Pooooo`03o`000?oo
oooooooo063ooooo00?o0000ooooooooool0H?ooool00ol0003oooooooooo`1Pooooo`03o`000?oo
oooooooo0?ooooooO_ooool000Sooooo00?o0000ooooooooool01_ooool4o`0000Sooooo0ol00008
ooooo`03o`000?oooooooooo00Gooooo2?l00006ooooo`;o00002_ooool4o`0000Cooooo1ol00007
ooooo`;o00004oooool3o`0000Wooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08
ooooo`?o00001oooool4o`0000Sooooo0ol00008ooooo`?o00002Oooool2o`0001?ooooo0ol00007
ooooo`Co00002?ooool00ol0003oooooooooo`08ooooo`?o00001Oooool8o`0000Gooooo1?l00007
ooooo`Co00002Oooool2o`00017ooooo1ol00006ooooo`?o00002?ooool3o`0000Sooooo00?o0000
ooooooooool01oooool4o`0000Sooooo0ol00008ooooo`?o00002Oooool2o`00017ooooo1ol00005
ooooo`Co00002Oooool4o`0000Kooooo00?o0000ooooooooool01_ooool7o`0000Cooooo1ol00006
ooooo`?o00002Oooool2o`00017ooooo1ol00006ooooo`?o00002Oooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00Sooooo0ol00009ooooo`Co00001oooool00ol0003oooooooooo`08
ooooo`;o00004?ooool8o`0000Kooooo0ol00006ooooo`Oo00001_ooool00ol0003oooooooooo`06
ooooo`Oo00001oooool00ol0003oooooooooo`07ooooo`?o00002Oooool2o`00013ooooo2?l00005
ooooo`Co00002Oooool4o`0000Kooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`07
ooooo`?o00002?ooool3o`0000Wooooo0_l0003oooooogoooooo0008ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`04ooooo`05o`000?oooooooooo
ooooool000001oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool01_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Kooooo00?o0000
ooooooooool02Oooool2o`00017ooooo00Go0000ooooooooooooooooo`000008ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool01oooool01Ol0003ooooooooooooooooo000000Gooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`04ooooo`05o`000?ooooooooooooooool0
00001_ooool01Ol0003ooooooooooooooooo000000Wooooo0_l0000Aooooo`05o`000?oooooooooo
ooooool000001Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool01oooool01Ol0003ooooooooooooooooo000000Gooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Oooooo0_l0000Cooooo`03o`000?oo
oooooooo00Kooooo00Go0000ooooooooooooooooo`000006ooooo`05o`000?ooooooooooooooool0
00001oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool01?ooool01Ol0003ooooooooooooooooo000000Kooooo00Go0000ooooooooooooooooo`000009
ooooo`;o00004oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Wooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`06ooooo`05o`000?ooooooooooooooool000002Ooo
ool2o`0001?ooooo00?o0000ooooooooool01_ooool01Ol0003ooooooooooooooooo000000Sooooo
00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`05o`000?ooooooooooooooool0
00002_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Wooooo0_l0000@ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo0000
00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01_ooool01Ol0003ooooooooooooooooo000000Wooooo0_l0000@
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo00Kooooo00Go0000ooooooooooooooooo`000006ooooo`05o`000?oo
ooooooooooooool000002Oooool2o`000?ooooooO_ooool000Sooooo00?o0000ooooooooool02ooo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01_oo
ool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool00ooo
ool01Ol0003ooooooooooooooooo000000Kooooo00?o0000ooooooooool03Oooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01_ooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool06oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`0Kooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool06oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`0@ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01oooool00ol0003ooooo
ooooo`06ooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool01oooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool04oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`0Iooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`3oooooohKooooo0007ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool02ooo
ool00ol0003oooooooooo`02ooooo`So00001oooool00ol0003oooooooooo`0Kooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0?ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo01Sooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo00cooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Kooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo01_ooooo00?o0000ooooooooool02oooool01?l0003oooooooooooooool8o`0001;ooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool06oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool01_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00?ooooo
00Co0000oooooooooooooooo2?l00008ooooo`03o`000?oooooooooo01cooooo00?o0000oooooooo
ool01_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool04oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo00cooooo00Co0000oooooooo
oooooooo2?l0000Cooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0oooooon6oooo
o`002?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Oooooo0ol000000ooooooo
0000ooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01_ooool00ol0003o
ooooooooo`0Kooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01_ooool00ol0003o
ooooooooo`0?ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`03ooooo`05o`000?ooooooooooooooool000001_ooool01Ol0003ooooooooooooooooo
000001cooooo00Go0000ooooooooooooooooo`00000:ooooo`03o`000?oooooooooo00oooooo00Go
0000ooooooooooooooooo`000008ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2Oooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
4oooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000001_ooool01Ol0003o
oooooooooooooooo000001kooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Kooooo00Go0000ooooooooooooooooo`00000Nooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`06ooooo`03o`000?oooooo
oooo00oooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000000Gooooo00?o
0000ooooooooool01oooool00ol0003oooooooooo`0Mooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01?ooooo00?o
0000ooooooooool02Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool06oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool0oooooon6ooooo`002?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo00Gooooo00Co0000oooooooooooooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool01_ooool00ol0003oooooooooo`0Kooooo`;o00000oooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo00Gooooo0ol00008ooooo`?o00007_ooool3o`0000Sooooo0ol0
000Cooooo`?o00002_ooool00ol0003oooooooooo`06ooooo`?o00002oooool00ol0003ooooooooo
o`0Looooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`05ooooo`?o00002?ooool3o`0001oooooo00?o0000ooooooooool01oooool3o`0000Kooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool01oooool3o`0001oooooo00?o0000ooooooooool01Oooool2o`0000?ooooo00?o
0000ooooooooool01oooool00ol0003oooooooooo`0?ooooo`;o00000oooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`0Nooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`04ooooo`;o00000oooool00ol0003oooooooooo`0Mooooo`03o`000?oooooooooo00Kooooo0ol0
0006ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool2o`0000?ooooo00?o
0000ooooooooool0oooooon7ooooo`002?ooool00ol0003oooooooooo`05ooooo`Go00001_ooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00
0008ooooo`03o`000?oooooooooo01_ooooo00?o0000ooooool000000_l0000;ooooo`03o`000?oo
oooooooo00kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`Go00001ooo
ool01Ol0003ooooooooooooooooo000000Kooooo00Go0000ooooooooooooooooo`00000Looooo`05
o`000?ooooooooooooooool000002_ooool00ol0003oooooooooo`0?ooooo`05o`000?oooooooooo
ooooool000002_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00?ooooo1Ol0000O
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool03Oooool5o`0000Oooooo00Go0000
ooooooooooooooooo`000006ooooo`05o`000?ooooooooooooooool000007_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00Cooooo00Go0000ooooooooooooooooo`00000Cooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool01_ooool01Ol0003ooooooooooooooooo0000
01kooooo00?o0000ooooooooool01Oooool00ol0003oooooo`000002o`0000_ooooo00?o0000oooo
ooooool03_ooool00ol0003oooooo`000002o`0000Oooooo00Go0000ooooooooooooooooo`00000:
ooooo`03o`000?oooooooooo01kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooool000000_l0000Qooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool01?ooool01Ol0003ooooooooooooooooo000001Gooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooool000000_l0003ooooooh[ooooo0008ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00cooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool01?ooool01?l0003oooooooooool00008ooooo`03o`000?oooooooooo01cooooo00?o
0000ooooooooool03?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01Sooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00gooooo00?o
0000ooooooooool00oooool01Ol0003ooooooooooooooooo000000Kooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo027ooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
6oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Cooooo00Co0000oooooooooooo
00004oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo00Kooooo00?o0000oooooooo
ool03?ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00Wooooo00Co0000oooooooo
oooo00002_ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool04oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool07?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool01?ooool01?l0003oooooooooool0000Eooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo0?ooooooRoooool0
00Sooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`05ooooo`03o`000?oooooo0000
00Kooooo00?o0000ooooool000007_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo
00?ooooo00Go0000ooooooooooooooooo`000006ooooo`03o`000?oooooooooo00gooooo00?o0000
ooooooooool00oooool01Ol0003ooooooooooooooooo000000Kooooo00Go0000oooooooooooooooo
o`000006ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool07oooool00ol0003ooooo
o`000007ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`0Iooooo`03o`000?oooooo000000Kooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooo0000017ooooo00?o0000ooooool000002?ooool00ol0003ooooo
o`000007ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool06Oooool00ol0003ooooo
o`000008ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`0>ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooool000001Oooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003ooooo
o`00000Cooooo`03o`000?oooooo000000Oooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool01?ooool01Ol0003ooooo
oooooooooooo000000Kooooo00?o0000ooooooooool01Oooool00ol0003oooooo`00000@ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool0oooooon;ooooo`002?ooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Wooooo00Go0000ooooooooooooooooo`00000@ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool01?ooool01Ol0003ooooooooooooooooo0000
00Wooooo0_l00007ooooo`;o00007oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool03_ooool01Ol0003ooooooooooooooooo000000Gooooo00?o0000
ooooooooool02Oooool01Ol0003ooooooooooooooooo000000Kooooo00Go0000oooooooooooooooo
o`00000Looooo`05o`000?ooooooooooooooool000001Oooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo00oooooo00Go0000ooooooooooooooooo`000005ooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool08?ooool2o`0000Sooooo00Go0000ooooooooooooooooo`000006
ooooo`05o`000?ooooooooooooooool000004?ooool00ol0003oooooooooo`09ooooo`05o`000?oo
ooooooooooooool000001_ooool01Ol0003ooooooooooooooooo000001gooooo0_l00007ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool01oooool2o`0001;ooooo0_l00009ooooo`;o
00002?ooool01Ol0003ooooooooooooooooo000001gooooo0_l00009ooooo`03o`000?oooooooooo
00Kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo
00[ooooo0_l00005ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool06?ooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo00Cooooo00Go0000ooooooooooooooooo`000007
ooooo`;o00005?ooool2o`0000Oooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01oooool2o`00013ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000001ooo
ool00ol0003oooooooooo`3ooooooh[ooooo0009ooooo`;o00001Oooool7o`0000Kooooo0ol0000B
ooooo`Co00002?ooool3o`0000_ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0N
ooooo`;o00001_ooool7o`00017ooooo0ol00006ooooo`Oo00001_ooool3o`0000Sooooo0ol0000N
ooooo`?o00001oooool4o`0001?ooooo0ol00007ooooo`Co00001oooool4o`0000Kooooo1ol0000M
ooooo`03o`000?oooooooooo00Oooooo0ol00008ooooo`?o00004Oooool7o`0000Kooooo0ol00008
ooooo`?o00007oooool00ol0003oooooooooo`06ooooo`Co00002oooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool3o`0001oooooo00?o0000
ooooooooool02?ooool2o`0000Kooooo1ol0000Booooo`;o00002oooool00ol0003oooooooooo`03
ooooo`Oo00006oooool4o`0000Sooooo0ol00009ooooo`03o`000?oooooooooo01?ooooo00?o0000
ooooooooool01Oooool7o`0000Oooooo0_l0000Mooooo`Co00001oooool4o`0000_ooooo00?o0000
ooooooooool03_ooool7o`0000Kooooo0ol00009ooooo`;o0000oooooon:ooooo`00oooooooooooo
oooooooooooooonIooooo`00oooooooooooooooooooooooooonIooooo`00oooooooooooooooooooo
oooooonIooooo`00oooooooooooooooooooooooooonIooooo`00oooooooooooooooooooooooooonI
ooooo`00oooooooooooooooooooooooooonIooooo`00oooooooooooooooooooooooooonIooooo`00
oooooooooooooooooooooooooonIooooo`00oooooooooooooooooooooooooonIooooo`00oooooooo
oooooooooooooooooonIooooo`00oooooooooooooooooooooooooonIooooo`00\
\>"]]
}, Open  ]],

Cell[TextData[StyleBox["LOLLIPOPS",
  FontFamily->"Geneva",
  FontSize->14]], "Input",
  AspectRatioFixed->False,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
f1Kirk={};
f1robert={};
frictionratio={};
rij={};
Do[
\tPrint[nbasepairs[[k]],\" bp spacer\"];
\t
\tPrint[\"My model:\"];
\tntot=2;
\tsnaked[nbasepairs[[k]]];
\tradii={r1,rstokes};
\trij={{0,r1 + lengthp[[k]] r1/2},{r1 + lengthp[[k]] r1/2,0}};
\tdoKirkwoodG;
\tf1robert=Append[f1robert,f1];

\tPrint[\"Kirk's model:\"];\t
\tntot=lengthp[[k]]+1;
\tradii={r1};
\tDo[radii=Append[radii,r2],{i,lengthp[[k]]}];
\trij=Table[0,{i,ntot},{j,ntot}];
\tDo[ Do[\t
\t\t\trij[[i,j]]=radii[[i]] + (j-i-1) 2 r2 + r2,
\t\t{j,i+1,ntot}],
\t{i,ntot}];
\tdoKirkwoodG;
\tf1Kirk=Append[f1Kirk,N[f1]],

{k,Length[lengthp]}];\
\>", "Input",
  AspectRatioFixed->False,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!PS-Adobe-2.0 EPSF-1.2
%%BoundingBox: 6 6 267 1059
%%HiResBoundingBox: 6 6 267 1059
%%Creator: (Mathematica 5.2 for Macintosh)
%%CreationDate: (Monday, March 30, 2020) (20:39:25)
%%Title: Clipboard
%%DocumentNeededResources: (atend)
%%DocumentFonts: (atend)
%%DocumentNeededFonts: (atend)
%%EndComments
0 1065 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def

%%MathematicaCell
%Cell[GraphicsData[\"PICT\", \\
%\"\\<\\
%55X0100X0/80eP0A0_l<0?ooool0:00000@0003F0002`\\
%P000000000N00402P04
%02P2`P9@0380100X0/82D00b00@0:00:0U00;00:01H7@fmeLVUULP0301H03@06
%02h010000000:bT94CD`;S8i=34PHW0PLg1QHfEb03802P0X0102D00Z1PU=NB1]
%KfAUK3X00380400X01H2D00Z1RTP821;JG9[Mfm_I21bIG=eK7Ac>R1kIR1VLVEU
%;FAbHFU^JFiW;6HaO@00<P0F02P0709@02X6820P820P820P820P820P;CLP820P
%820P820P820P82dg0380700X0282D00Z1R8P820P<Bhg>CHc=20a<20P86LP834^
%<cHg<S@P<C0P821W03808P0X02P2D00Z1R<P821k;Bd];Bd];Bd];Bd];Bd/82d]
%;Bd];Bd];Bd];Bd]O@00<P0X02P0;P9@02X66b0P820P820P821c820P820P820P
%820P820PL`00<P0^02P0=09@02X63D]YLV/WLb1]KfAUK3X00380=00X03X2D00Z
%1RTP821;JG9[Mfm_I21bIG=eK7Ac>R1kIR1VLVEU;FAbHFU^JFiW;6HaO@00<P0j
%02P0@09@02X6820P820P820P820P820P;CLP820P820P820P820P82dg0380@00X
%04H2D00Z1R8P820P<Rh`=34e=B0a<20P86LP834^<3Hb>C@P<C0P821W0380AP0X
%04`2D00Z1R<P821k;Bd];Bd];Bd];Bd];Bd/82d];Bd];Bd];Bd];Bd]O@00<P1<
%02P0DP9@02X66b0P820P820P821c820P820P820P820P820PL`00<P1B02P0F09@
%02X64CHg;S0e>3PPHW0PLg1QHfEb000b05P0:01N0U00:PH9CGTPKFmTIF`j000b
%05h0:01T0U00:PHY820PBfUbJgM_Kf@PLVEcMFadLcXPNfHPIW9UIBeTLV5YKVU^
%IbaV<Gd00380I00X06X2D00Z1R0P820P820P820P820P82dg820P820P820P820P
%820]=`0b06X0:01`0U00:PHR820P834^>C8c>C@P<C0P821W820a;S@i<c8g834`
%820PI`0b0700:01f0U00:PHS820PNbd];Bd];Bd];Bd];Bd];20];Bd];Bd];Bd]
%;Bd];Gd00380MP0X07`2D00Z1Q/P820P820P820PLb0P820P820P820P820P87<0
%0380O00X0882D00Z1Pe;JG9[9g<PKFmTIF`j000b0880:0280U00:PHY820PBfUb
%JgM_Kf@PLVEcMFadLcXPNfHPIW9UIBeTLV5YKVU^IbaV<Gd00380R00X08h2D00Z
%1QlP820P820P820P820P;CLP820P820P820P820P82dg000b08h0:02D0U00:PHQ
%820P838^<cDh<R0a<20P86LP834^<C0f<CTP<C0P821W000b09@0:02J0U00:PHR
%820PNbd];Bd];Bd];Bd];Bd/82d];Bd];Bd];Bd];Bd]O@0b09X0:02P0U00:PHJ
%820P820P820P87<P820P820P820P820P87<0<P2P02P0YP9@02X64CPc;SPb<cDP
%HW0PLg1QHfEb000b0:H0:02/0U00:PH9CGTPKFmTIF`j000b0:`0:02b0U00:PHY
%820PBfUbJgM_Kf@PLVEcMFadLcXPNfHPIW9UIBeTLV5YKVU^IbaV<Gd00380/P0X
%0;P2D00Z1R0P820P820P820P820P82dg820P820P820P820P820]=`0b0;P0:02n
%0U00:PHR820P838^<3@g<cHP<C0P821W820a;SHa=S8c834`820PI`0b0;h0:034
%0U00:PHS820PNbd];Bd];Bd];Bd];Bd];20];Bd];Bd];Bd];Bd];Gd00380a00X
%0<X2D00Z1Q/P820P820P820PLb0P820P820P820P820P87<00380bP0X0=02D00Z
%1Pe;JG9[9g<PKFmTIF`j000b0=00:03F0U00:PHY820PBfUbJgM_Kf@PLVEcMFad
%LcXPNfHPIW9UIBeTLV5YKVU^IbaV<Gd00380eP0X0=`2D00Z1R0P820P820P820P
%820P82dg820P820P820P820P820]=`0b0=`0:03R0U00:PHR820P838^=SLd>3@P
%<C0P821W820a;S4e=cTb834`820PI`0b0>80:03X0U00:PHS820PNbd];Bd];Bd]
%;Bd];Bd];20];Bd];Bd];Bd];Bd];Gd00380j00X0>h2D00Z1Q/P820P820P820P
%Lb0P820P820P820P820P87<00380kP0X0?@2D00Z1Q4a<30^=CPh869`87=`HF=U
%LP00<P3d02P0nP9@02X62Dei86e_I6E/>P00<P3j02P1009@02X6:B0P84]YLV]g
%KfmT879ULgE/M7<j87]V86IbIFD]I79QJFiYKVL/IS5m000b0@00:0460U00:PHP
%820P820P820P820P820]=b0P820P820P820P820P;CL0<P4602P1309@02X68R0P
%820b;S4f=c0a834`820PIb0P<Bhg<cHb<B0a<20P86L0<P4<02P14P9@02X68b0P
%87/];Bd];Bd];Bd];Bd];B`P;Bd];Bd];Bd];Bd];Bem000b0A80:04H0U00:PHK
%820P820P820P87<P820P820P820P820P821c000b0AP0:04N0U00:PH=BfUbJbMc
%86e_I6E/>P00<P4N02P1909@02X6:B0P84]YLV]gKfmT879ULgE/M7<j87]V86Ib
%IFD]I79QJFiYKVL/IS5m000b0B@0:04Z0U00:PHP820P820P820P820P820]=b0P
%820P820P820P820P;CL0<P4Z02P1<09@02X68R0P820b;STi<C@i834`820PIb0P
%<Bhb<C@b>B0a<20P86L0<P4`02P1=P9@02X68b0P87/];Bd];Bd];Bd];Bd];B`P
%;Bd];Bd];Bd];Bd];Bem000b0CH0:04l0U00:PHK820P820P820P87<P820P820P
%820P820P821c000b0C`0:0520U00:PHA<C<d;S4a>21RL21cL65SIG800381@P0X
%0DP2D00Z1PU=NB1]KfAUK3X00381B00X0Dh2D00Z1RTP821;JG9[Mfm_I21bIG=e
%K7Ac>R1kIR1VLVEU;FAbHFU^JFiW;6HaO@00<P5>02P1E09@02X6820P820P820P
%820P820P;CLP820P820P820P820P82dg0381E00X0EX2D00Z1R8P820P<Rhc>CL`
%=R0a<20P86LP834^>CHh<STP<C0P821W0381FP0X0F02D00Z1R<P821k;Bd];Bd]
%;Bd];Bd];Bd/82d];Bd];Bd];Bd];Bd]O@00<P5P02P1IP9@02X66b0P820P820P
%821c820P820P820P820P820PL`00<P5V02P1K09@02X63D]YLV/WLb1]KfAUK3X0
%0381K00X0G82D00Z1RTP821;JG9[Mfm_I21bIG=eK7Ac>R1kIR1VLVEU;FAbHFU^
%JFiW;6HaO@00<P5b02P1N09@02X6820P820P820P820P820P;CLP820P820P820P
%820P82dg0381N00X0Gh2D00Z1R8P820P<bhf<S@g>20a<20P86LP834^<c<c=cPP
%<C0P821W0381OP0X0H@2D00Z1R<P821k;Bd];Bd];Bd];Bd];Bd/82d];Bd];Bd]
%;Bd];Bd]O@00<P6402P1RP9@02X66b0P820P820P821c820P820P820P820P820P
%L`00<P6:02P1T09@02X64C4f=bhf=3LPHW0PLg1QHfEb000b0I00:06F0U00:PH9
%CGTPKFmTIF`j000b0IH0:06L0U00:PHY820PBfUbJgM_Kf@PLVEcMFadLcXPNfHP
%IW9UIBeTLV5YKVU^IbaV<Gd00381W00X0J82D00Z1R0P820P820P820P820P82dg
%820P820P820P820P820]=`0b0J80:06X0U00:PHR820P838^=S4g=3<P<C0P821W
%820b;S4i<CDg834`820PI`0b0JP0:06^0U00:PHS820PNbd];Bd];Bd];Bd];Bd]
%;20];Bd];Bd];Bd];Bd];Gd00381[P0X0K@2D00Z1Q/P820P820P820PLb0P820P
%820P820P820P87<00381]00X0KX2D00Z1Pe;JG9[9g<PKFmTIF`j000b0KX0:070
%0U00:PHY820PBfUbJgM_Kf@PLVEcMFadLcXPNfHPIW9UIBeTLV5YKVU^IbaV<Gd0
%0381`00X0LH2D00Z1R0P820P820P820P820P82dg820P820P820P820P820]=`0b
%0LH0:07<0U00:PHR820P83@^<SDh<3LP<C0P821W820a;S@e=STe834`820PI`0b
%0L`0:07B0U00:PHS820PNbd];Bd];Bd];Bd];Bd];20];Bd];Bd];Bd];Bd];Gd0
%0381dP0X0MP2D00Z1Q/P820P820P820PLb0P820P820P820P820P87<00381f00X
%0Mh2D00Z1Q4b<34^<CLf869`87=`HF=ULP00<P7N02P1i09@02X62Dei86e_I6E/
%>P00<P7T02P1jP9@02X6:B0P84]YLV]gKfmT879ULgE/M7<j87]V86IbIFD]I79Q
%JFiYKVL/IS5m000b0NX0:07`0U00:PHP820P820P820P820P820]=b0P820P820P
%820P820P;CL0<P7`02P1mP9@02X68R0P820b;SPc<3<a834`820PIb0P<Rhd<3Lg
%<B0a<20P86L0<P7f02P1o09@02X68b0P87/];Bd];Bd];Bd];Bd];B`P;Bd];Bd]
%;Bd];Bd];Bem000b0O`0:0820U00:PHK820P820P820P87<P820P820P820P820P
%821c000b0P80:0880U00:PH=BfUbJbMc86e_I6E/>P00<P8802P23P9@02X6:B0P
%84]YLV]gKfmT879ULgE/M7<j87]V86IbIFD]I79QJFiYKVL/IS5m000b0Ph0:08D
%0U00:PHP820P820P820P820P820]=b0P820P820P820P820P;CL0<P8D02P26P9@
%02X68R0P820d;SPi<C<f834`820PIb0P<Bhe>30i=R0a<20P86L0<P8J02P2809@
%02X68b0P87/];Bd];Bd];Bd];Bd];B`P;Bd];Bd];Bd];Bd];Bem000b0R00:08V
%0U00:PHK820P820P820P87<P820P820P820P820P821c000b0RH0:08/0U00:PHA
%<S<d;SL`=R1RL21cL65SIG800382;00X0S82D00Z1PU=NB1]KfAUK3X00382<P0X
%0SP2D00Z1RTP821;JG9[Mfm_I21bIG=eK7Ac>R1kIR1VLVEU;FAbHFU^JFiW;6Ha
%O@00<P8h02P2?P9@02X6820P820P820P820P820P;CLP820P820P820P820P82dg
%0382?P0X0T@2D00Z1R8P820P<bh`<cLa>B0a<20P86LP838^=S4g>C@P<C0P821W
%0382A00X0TX2D00Z1R<P821k;Bd];Bd];Bd];Bd];Bd/82d];Bd];Bd];Bd];Bd]
%O@00<P9:02P2D09@02X66b0P820P820P821c820P820P820P820P820PL`00<P9@
%02P2EP9@02X63D]YLV/WLb1]KfAUK3X00382EP0X0U`2D00Z1RTP821;JG9[Mfm_
%I21bIG=eK7Ac>R1kIR1VLVEU;FAbHFU^JFiW;6HaO@00<P9L02P2HP9@02X6820P
%820P820P820P820P;CLP820P820P820P820P82dg0382HP0X0VP2D00Z1R8P820P
%=Bhe<S@f=B0a<20P86LP834^=c0d=SLP<C0P821W0382J00X0Vh2D00Z1R<P821k
%;Bd];Bd];Bd];Bd];Bd/82d];Bd];Bd];Bd];Bd]O@00<P9^02P2M09@02X66b0P
%820P820P821c820P820P820P820P820PL`00<P9d02P2NP9@02X64C8f>2hb<cDP
%HW0PLg1QHfEb000b0WX0:0:00U00:PH9CGTPKFmTIF`j000b0X00:0:60U00:PHY
%820PBfUbJgM_Kf@PLVEcMFadLcXPNfHPIW9UIBeTLV5YKVU^IbaV<Gd00382QP0X
%0X`2D00Z1QlP820P820P820P820P;CLP820P820P820P820P82dg000b0X`0:0:B
%0U00:PHQ820P83<^<S<i<B0a<20P86LP838^>38c<CHP<C0P821W000b0Y80:0:H
%0U00:PHR820PNbd];Bd];Bd];Bd];Bd/82d];Bd];Bd];Bd];Bd]O@0b0YP0:0:N
%0U00:PHJ820P820P820P87<P820P820P820P820P87<0<P:N02P2Y09@02X63D]Y
%LV/WLb1]KfAUK3X00382Y00X0ZX2D00Z1RTP821;JG9[Mfm_I21bIG=eK7Ac>R1k
%IR1VLVEU;FAbHFU^JFiW;6HaO@00<P:Z02P2/09@02X6820P820P820P820P820P
%;CLP820P820P820P820P82dg0382/00X0[H2D00Z1R8P820P=Rha=CLi=20a<20P
%86LP834^>38g=CLP<C0P821W0382]P0X0[`2D00Z1R<P821k;Bd];Bd];Bd];Bd]
%;Bd/82d];Bd];Bd];Bd];Bd]O@00<P:l02P2`P9@02X66b0P820P820P821c820P
%820P820P820P820PL`00<P;202P2`P9@0?l\\>\"], \"Graphics\",
%  ImageSize->{174, 702},
%  ImageMargins->{{0, Inherited}, {Inherited, Inherited}},
%  ImageRegion->{{-0, 1}, {0, 1}},
%  FontSize->6]
%%EndMathematicaCell
1 setgray
6 1059 moveto
834 1059 lineto
834 6 lineto
6 6 lineto
closepath
fill
6 15 moveto
834 15 lineto
834 6 lineto
6 6 lineto
closepath
fill
2 setlinewidth
0 setgray
/Courier findfont 6 scalefont setfont
8 14 moveto (50.2941 bp spacer) show
1 setgray
7 23 moveto
833 23 lineto
833 16 lineto
7 16 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 23 moveto (My model:) show
1 setgray
7 32 moveto
833 32 lineto
833 25 lineto
7 25 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 32 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 41 moveto
833 41 lineto
833 34 lineto
7 34 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 41 moveto (              -7              -7) show
1 setgray
7 50 moveto
833 50 lineto
833 43 lineto
7 43 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 50 moveto (    1.79634 10   g  1.36724 10   g) show
1 setgray
7 59 moveto
833 59 lineto
833 52 lineto
7 52 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 59 moveto (   {--------------, --------------}) show
1 setgray
7 68 moveto
833 68 lineto
833 61 lineto
7 61 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 68 moveto (          s               s) show
1 setgray
7 77 moveto
833 77 lineto
833 70 lineto
7 70 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 77 moveto (Kirk's model:) show
1 setgray
7 86 moveto
833 86 lineto
833 79 lineto
7 79 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 86 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 95 moveto
833 95 lineto
833 88 lineto
7 88 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 95 moveto (              -7              -7) show
1 setgray
7 104 moveto
833 104 lineto
833 97 lineto
7 97 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 104 moveto (    2.04155 10   g  1.06294 10   g) show
1 setgray
7 113 moveto
833 113 lineto
833 106 lineto
7 106 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 113 moveto (   {--------------, --------------}) show
1 setgray
7 122 moveto
833 122 lineto
833 115 lineto
7 115 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 122 moveto (          s               s) show
1 setgray
7 131 moveto
833 131 lineto
833 124 lineto
7 124 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 131 moveto (67.0588 bp spacer) show
1 setgray
7 140 moveto
833 140 lineto
833 133 lineto
7 133 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 140 moveto (My model:) show
1 setgray
7 149 moveto
833 149 lineto
833 142 lineto
7 142 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 149 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 158 moveto
833 158 lineto
833 151 lineto
7 151 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 158 moveto (              -7              -7) show
1 setgray
7 167 moveto
833 167 lineto
833 160 lineto
7 160 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 167 moveto (    1.92394 10   g  1.49327 10   g) show
1 setgray
7 176 moveto
833 176 lineto
833 169 lineto
7 169 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 176 moveto (   {--------------, --------------}) show
1 setgray
7 185 moveto
833 185 lineto
833 178 lineto
7 178 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 185 moveto (          s               s) show
1 setgray
7 194 moveto
833 194 lineto
833 187 lineto
7 187 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 194 moveto (Kirk's model:) show
1 setgray
7 203 moveto
833 203 lineto
833 196 lineto
7 196 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 203 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 212 moveto
833 212 lineto
833 205 lineto
7 205 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 212 moveto (             -7              -7) show
1 setgray
7 221 moveto
833 221 lineto
833 214 lineto
7 214 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 221 moveto (    2.3582 10   g  1.10619 10   g) show
1 setgray
7 230 moveto
833 230 lineto
833 223 lineto
7 223 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 230 moveto (   {-------------, --------------}) show
1 setgray
7 239 moveto
833 239 lineto
833 232 lineto
7 232 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 239 moveto (          s              s) show
1 setgray
7 248 moveto
833 248 lineto
833 241 lineto
7 241 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 248 moveto (83.8235 bp spacer) show
1 setgray
7 257 moveto
833 257 lineto
833 250 lineto
7 250 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 257 moveto (My model:) show
1 setgray
7 266 moveto
833 266 lineto
833 259 lineto
7 259 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 266 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 275 moveto
833 275 lineto
833 268 lineto
7 268 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 275 moveto (              -7              -7) show
1 setgray
7 284 moveto
833 284 lineto
833 277 lineto
7 277 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 284 moveto (    2.04736 10   g  1.61623 10   g) show
1 setgray
7 293 moveto
833 293 lineto
833 286 lineto
7 286 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 293 moveto (   {--------------, --------------}) show
1 setgray
7 302 moveto
833 302 lineto
833 295 lineto
7 295 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 302 moveto (          s               s) show
1 setgray
7 311 moveto
833 311 lineto
833 304 lineto
7 304 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 311 moveto (Kirk's model:) show
1 setgray
7 320 moveto
833 320 lineto
833 313 lineto
7 313 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 320 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 329 moveto
833 329 lineto
833 322 lineto
7 322 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 329 moveto (              -7              -7) show
1 setgray
7 338 moveto
833 338 lineto
833 331 lineto
7 331 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 338 moveto (    2.67484 10   g  1.15792 10   g) show
1 setgray
7 347 moveto
833 347 lineto
833 340 lineto
7 340 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 347 moveto (   {--------------, --------------}) show
1 setgray
7 356 moveto
833 356 lineto
833 349 lineto
7 349 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 356 moveto (          s               s) show
1 setgray
7 365 moveto
833 365 lineto
833 358 lineto
7 358 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 365 moveto (100.588 bp spacer) show
1 setgray
7 374 moveto
833 374 lineto
833 367 lineto
7 367 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 374 moveto (My model:) show
1 setgray
7 383 moveto
833 383 lineto
833 376 lineto
7 376 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 383 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 392 moveto
833 392 lineto
833 385 lineto
7 385 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 392 moveto (              -7              -7) show
1 setgray
7 401 moveto
833 401 lineto
833 394 lineto
7 394 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 401 moveto (    2.16701 10   g  1.73621 10   g) show
1 setgray
7 410 moveto
833 410 lineto
833 403 lineto
7 403 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 410 moveto (   {--------------, --------------}) show
1 setgray
7 419 moveto
833 419 lineto
833 412 lineto
7 412 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 419 moveto (          s               s) show
1 setgray
7 428 moveto
833 428 lineto
833 421 lineto
7 421 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 428 moveto (Kirk's model:) show
1 setgray
7 437 moveto
833 437 lineto
833 430 lineto
7 430 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 437 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 446 moveto
833 446 lineto
833 439 lineto
7 439 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 446 moveto (              -7              -7) show
1 setgray
7 455 moveto
833 455 lineto
833 448 lineto
7 448 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 455 moveto (    2.99149 10   g  1.21429 10   g) show
1 setgray
7 464 moveto
833 464 lineto
833 457 lineto
7 457 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 464 moveto (   {--------------, --------------}) show
1 setgray
7 473 moveto
833 473 lineto
833 466 lineto
7 466 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 473 moveto (          s               s) show
1 setgray
7 482 moveto
833 482 lineto
833 475 lineto
7 475 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 482 moveto (134.118 bp spacer) show
1 setgray
7 491 moveto
833 491 lineto
833 484 lineto
7 484 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 491 moveto (My model:) show
1 setgray
7 500 moveto
833 500 lineto
833 493 lineto
7 493 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 500 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 509 moveto
833 509 lineto
833 502 lineto
7 502 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 509 moveto (              -7              -7) show
1 setgray
7 518 moveto
833 518 lineto
833 511 lineto
7 511 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 518 moveto (    2.39706 10   g  1.96829 10   g) show
1 setgray
7 527 moveto
833 527 lineto
833 520 lineto
7 520 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 527 moveto (   {--------------, --------------}) show
1 setgray
7 536 moveto
833 536 lineto
833 529 lineto
7 529 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 536 moveto (          s               s) show
1 setgray
7 545 moveto
833 545 lineto
833 538 lineto
7 538 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 545 moveto (Kirk's model:) show
1 setgray
7 554 moveto
833 554 lineto
833 547 lineto
7 547 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 554 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 563 moveto
833 563 lineto
833 556 lineto
7 556 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 563 moveto (              -7              -7) show
1 setgray
7 572 moveto
833 572 lineto
833 565 lineto
7 565 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 572 moveto (    3.62478 10   g  1.33378 10   g) show
1 setgray
7 581 moveto
833 581 lineto
833 574 lineto
7 574 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 581 moveto (   {--------------, --------------}) show
1 setgray
7 590 moveto
833 590 lineto
833 583 lineto
7 583 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 590 moveto (          s               s) show
1 setgray
7 599 moveto
833 599 lineto
833 592 lineto
7 592 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 599 moveto (167.647 bp spacer) show
1 setgray
7 608 moveto
833 608 lineto
833 601 lineto
7 601 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 608 moveto (My model:) show
1 setgray
7 617 moveto
833 617 lineto
833 610 lineto
7 610 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 617 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 626 moveto
833 626 lineto
833 619 lineto
7 619 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 626 moveto (              -7              -7) show
1 setgray
7 635 moveto
833 635 lineto
833 628 lineto
7 628 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 635 moveto (    2.61743 10   g  2.19157 10   g) show
1 setgray
7 644 moveto
833 644 lineto
833 637 lineto
7 637 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 644 moveto (   {--------------, --------------}) show
1 setgray
7 653 moveto
833 653 lineto
833 646 lineto
7 646 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 653 moveto (          s               s) show
1 setgray
7 662 moveto
833 662 lineto
833 655 lineto
7 655 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 662 moveto (Kirk's model:) show
1 setgray
7 671 moveto
833 671 lineto
833 664 lineto
7 664 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 671 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 680 moveto
833 680 lineto
833 673 lineto
7 673 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 680 moveto (              -7              -7) show
1 setgray
7 689 moveto
833 689 lineto
833 682 lineto
7 682 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 689 moveto (    4.25807 10   g  1.45695 10   g) show
1 setgray
7 698 moveto
833 698 lineto
833 691 lineto
7 691 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 698 moveto (   {--------------, --------------}) show
1 setgray
7 707 moveto
833 707 lineto
833 700 lineto
7 700 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 707 moveto (          s               s) show
1 setgray
7 716 moveto
833 716 lineto
833 709 lineto
7 709 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 716 moveto (201.176 bp spacer) show
1 setgray
7 725 moveto
833 725 lineto
833 718 lineto
7 718 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 725 moveto (My model:) show
1 setgray
7 734 moveto
833 734 lineto
833 727 lineto
7 727 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 734 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 743 moveto
833 743 lineto
833 736 lineto
7 736 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 743 moveto (              -7              -7) show
1 setgray
7 752 moveto
833 752 lineto
833 745 lineto
7 745 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 752 moveto (    2.83031 10   g  2.40771 10   g) show
1 setgray
7 761 moveto
833 761 lineto
833 754 lineto
7 754 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 761 moveto (   {--------------, --------------}) show
1 setgray
7 770 moveto
833 770 lineto
833 763 lineto
7 763 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 770 moveto (          s               s) show
1 setgray
7 779 moveto
833 779 lineto
833 772 lineto
7 772 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 779 moveto (Kirk's model:) show
1 setgray
7 788 moveto
833 788 lineto
833 781 lineto
7 781 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 788 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 797 moveto
833 797 lineto
833 790 lineto
7 790 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 797 moveto (              -7              -7) show
1 setgray
7 806 moveto
833 806 lineto
833 799 lineto
7 799 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 806 moveto (    4.89136 10   g  1.58096 10   g) show
1 setgray
7 815 moveto
833 815 lineto
833 808 lineto
7 808 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 815 moveto (   {--------------, --------------}) show
1 setgray
7 824 moveto
833 824 lineto
833 817 lineto
7 817 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 824 moveto (          s               s) show
1 setgray
7 833 moveto
833 833 lineto
833 826 lineto
7 826 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 833 moveto (234.706 bp spacer) show
1 setgray
7 842 moveto
833 842 lineto
833 835 lineto
7 835 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 842 moveto (My model:) show
1 setgray
7 851 moveto
833 851 lineto
833 844 lineto
7 844 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 851 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 860 moveto
833 860 lineto
833 853 lineto
7 853 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 860 moveto (              -7              -7) show
1 setgray
7 869 moveto
833 869 lineto
833 862 lineto
7 862 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 869 moveto (    3.03719 10   g  2.61794 10   g) show
1 setgray
7 878 moveto
833 878 lineto
833 871 lineto
7 871 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 878 moveto (   {--------------, --------------}) show
1 setgray
7 887 moveto
833 887 lineto
833 880 lineto
7 880 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 887 moveto (          s               s) show
1 setgray
7 896 moveto
833 896 lineto
833 889 lineto
7 889 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 896 moveto (Kirk's model:) show
1 setgray
7 905 moveto
833 905 lineto
833 898 lineto
7 898 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 905 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 914 moveto
833 914 lineto
833 907 lineto
7 907 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 914 moveto (              -7              -7) show
1 setgray
7 923 moveto
833 923 lineto
833 916 lineto
7 916 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 923 moveto (    5.52465 10   g  1.70467 10   g) show
1 setgray
7 932 moveto
833 932 lineto
833 925 lineto
7 925 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 932 moveto (   {--------------, --------------}) show
1 setgray
7 941 moveto
833 941 lineto
833 934 lineto
7 934 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 941 moveto (          s               s) show
1 setgray
7 950 moveto
833 950 lineto
833 943 lineto
7 943 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 950 moveto (268.235 bp spacer) show
1 setgray
7 959 moveto
833 959 lineto
833 952 lineto
7 952 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 959 moveto (My model:) show
1 setgray
7 968 moveto
833 968 lineto
833 961 lineto
7 961 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 968 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 977 moveto
833 977 lineto
833 970 lineto
7 970 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 977 moveto (             -7              -7) show
1 setgray
7 986 moveto
833 986 lineto
833 979 lineto
7 979 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 986 moveto (    3.2391 10   g  2.82316 10   g) show
1 setgray
7 995 moveto
833 995 lineto
833 988 lineto
7 988 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 995 moveto (   {-------------, --------------}) show
1 setgray
7 1004 moveto
833 1004 lineto
833 997 lineto
7 997 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 1004 moveto (          s              s) show
1 setgray
7 1013 moveto
833 1013 lineto
833 1006 lineto
7 1006 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 1013 moveto (Kirk's model:) show
1 setgray
7 1022 moveto
833 1022 lineto
833 1015 lineto
7 1015 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 1022 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 1031 moveto
833 1031 lineto
833 1024 lineto
7 1024 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 1031 moveto (              -7              -7) show
1 setgray
7 1040 moveto
833 1040 lineto
833 1033 lineto
7 1033 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 1040 moveto (    6.15794 10   g  1.82757 10   g) show
1 setgray
7 1049 moveto
833 1049 lineto
833 1042 lineto
7 1042 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 1049 moveto (   {--------------, --------------}) show
1 setgray
7 1058 moveto
833 1058 lineto
833 1051 lineto
7 1051 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 1058 moveto (          s               s) show
1 setgray
7 1058 moveto
833 1058 lineto
833 1060 lineto
7 1060 lineto
closepath
fill
%%Trailer
%%EOF
\
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{261, 1053},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  FontSize->6,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000670006:b000`400?l00000o`00003ooooooon8
ooooo`00=Oooool3o`0004gooooo0ol0003oooooo`00=oooool2o`0004kooooo0_l0003nooooo`00
=Oooool2o`0004kooooo0_l0003oooooo`7ooooo000fooooo`?o0000COooool3o`000?kooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo001Nooooo`03o`000?oooooooooo0?oooooo
9oooool001Cooooo00?o0000ooooooooool0B?ooool00ol0003oooooooooo`1<ooooo`03o`000?oo
oooooooo0=Kooooo000Cooooo`03o`000?oooooooooo04Wooooo00?o0000ooooooooool0COooool0
0ol0003oooooooooo`3Eooooo`004oooool00ol0003oooooooooo`2Iooooo`03o`000?oooooooooo
0=Gooooo000Booooo`03o`000?oooooooooo00;ooooo1?l000000ooooooo0000o`000002o`000003
ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003
ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003
ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003
ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`0000_o
oooo1?l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l0
00000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l0
00000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l0
00000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l0
00000_l000000ooooooo0000o`000002o`0000Cooooo00?o0000ooooooooool0e?ooool001?ooooo
00?o0000ooooooooool0VOooool00ol0003oooooooooo`3Eooooo`004oooool00ol0003ooooooooo
o`2Iooooo`03o`000?oooooooooo0=Gooooo000Dooooo`03o`000?oooooooooo09Oooooo00?o0000
ooooooooool0e_ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?oo
ool00?ooooooR?ooool005Wooooo0_l0001>ooooo`;o0000g?ooool005_ooooo00?o0000oooooooo
ool0COooool00ol0003oooooooooo`3Iooooo`006?ooool2o`0000Cooooo00Co0000oooooooooooo
oooo0ol00002ooooo`;o00000oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool01Oooool3o`0000;ooooo0_l0000Booooo`?o00003?ooool3o`0000?o
oooo00Co0000oooooooooooooooo0_l00002ooooo`Co00000_ooool00ol0003oooooooooo`02oooo
o`;o00000oooool00ol0003oooooooooo`07ooooo`?o00000_ooool2o`0001;ooooo0ol0003Koooo
o`005oooool01?l0003oooooooooool00008ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000
oooooooooooo00001Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Kooooo00Co
0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`0000go
oooo00?o0000ooooooooool01Oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo
00;ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000[ooooo00Co
0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`000=_o
oooo000Gooooo`04o`000?ooooooooooo`0000Sooooo00?o0000ooooooooool00oooool01Ol0003o
oooooooooooooooo000000?ooooo0ol000000ooooooo0000o`000002o`0000Sooooo00Co0000oooo
oooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`0000gooooo00?o
0000ooooooooool01Oooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000000Wooooo00Co0000oooooooo
oooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`000=_ooooo000Goooo
o`?o00002Oooool00ol0003oooooooooo`03o`0000Cooooo00Co0000oooooooooooo00000_ooool0
1_l0003oooooooooool0003oooooo`0000Sooooo00Co0000oooooooooooo00000_ooool00ol0003o
ooooooooo`0?ooooo`?o00003Oooool00ol0003oooooooooo`06ooooo`;o00001Oooool01Ol0003o
oooooooooooooooo000000;ooooo0ol00004ooooo`03o`000?oooooooooo00Oooooo00Co0000oooo
oooooooo00000_ooool00ol0003oooooooooo`0?ooooo`?o0000foooool001Sooooo00?o0000oooo
ooooool02?ooool01?l0003oooooooooool00004ooooo`06o`000?ooooooooooo`000?oooooo0000
0_ooool01?l0003oooooooooooooool2o`0000Sooooo00Co0000oooooooooooo00000_ooool00ol0
003oooooooooo`0Oooooo`03o`000?oooooooooo00Gooooo00Ko0000oooooooooooo0000ooooool0
0002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool000001?ooool01?l0003ooooooooo
ool00008ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0kOooool001Wooooo
00?o0000ooooooooool01_ooool2o`0000;ooooo1?l000000ooooooo0000o`000002o`0000;ooooo
0_l00005ooooo`03o`000?oooooooooo00Gooooo0_l00003ooooo`;o00008Oooool2o`0000Sooooo
0_l00003ooooo`;o00000_ooool4o`000003ooooool0003o000000;o000000?oooooo`000?l00000
0_l00007ooooo`;o00000oooool2o`000?3ooooo003oooooohSooooo003oooooohSooooo003ooooo
ohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003ooooo
ohSooooo001?ooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0iOooool004oooooo
00?o0000ooooooooool0COooool00ol0003oooooooooo`3Uooooo`00BOooool4o`0000?ooooo00?o
0000ooooooooool0A_ooool4o`0000?ooooo00?o0000ooooooooool0i?ooool0053ooooo00?o0000
ooooooooool0COooool00ol0003oooooooooo`3Tooooo`00C_ooool01?l0003oooooooooool0001<
ooooo`04o`000?ooooooooooo`000>Gooooo001>ooooo`Co0000C?ooool4o`000>Gooooo003ooooo
ohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo002hoooo
o`;o00000oooool00ol0003oooooooooo`37ooooo`00K_ooool00ol0003oooooooooo`19ooooo`05
o`000?ooooooooooooooool000003Oooool00ol0003oooooooooo`2hooooo`004_ooool01?l0003o
ooooooooool00002ooooo`?o000000Coooooo`000?l0003o00000_ooool2o`000007ooooool0003o
0000ooooool0003oooooo`000002ooooo`;o00000oooool2o`0000?ooooo1?l00005ooooo`?o0000
0oooool3o`000004ooooool0003o0000o`0000?ooooo0ol00002ooooo`?o00000oooool2o`000004
ooooool0003o0000o`0000Cooooo00?o0000ooooooooool01_ooool01?l0003oooooooooooooool4
o`0000Kooooo1?l000001?oooooo0000o`000?l00003ooooo`?o00000_ooool3o`0000Oooooo1ol0
0003ooooo`?o00000_ooool3o`000005ooooool0003oooooooooool000000_ooool3o`000005oooo
ool0003oooooooooool000000_ooool3o`0000?ooooo00?o0000ooooooooool01?l00002ooooo`?o
00000oooool00ol0003oooooooooo`2gooooo`004_ooool00ol0003oooooo`000004ooooo`05o`00
0?ooooooooooooooool000001?ooool00ol0003oooooo`000002ooooo`05o`000?oooooo0000oooo
ool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000oooo
ooooool01Oooool01?l0003oooooooooooooool2o`0000Gooooo0_l000001Ooooooo0000oooooooo
oooo000000?ooooo00Go0000ooooooooooooooooo`000005ooooo`;o00003?ooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00_ooool01?l0003ooooo
ooooooooool2o`0000?ooooo0_l00008ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000oooo
ooooooooooooo`000002ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003ooooooooo
ool00003ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000_ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`2gooooo`004_ooool2o`0000Gooooo00Go0000ooooooooooooooooo`000004ooooo`;o
00000_ooool01?l0003oooooo`000?ooool2o`0000;ooooo00?o0000ooooool000000_ooool00ol0
003oooooo`000002ooooo`03o`000?oooooooooo00Gooooo00Ko0000ooooooooooooooooo`000?oo
ool2o`000003ooooool0003o000000?ooooo00Co0000oooooooooooo00000oooool01Ol0003ooooo
oooooooooooo000000?ooooo0_l0000=ooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`02ooooo`06o`000?ooooooooooooooool0003ooooo0_l00000
0ooooooo0000ooooo`02o`000003ooooool0003o000000;o000000Goooooo`000?ooooooooooo`00
0002ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooool000000oooool01?l0003ooooooooo
ool00002ooooo`05o`000?ooooooooooooooool000000_ooool01_l0003oooooooooool0003ooooo
o`0000;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool0]_ooool001;ooooo0_l00004ooooo`;o00000_ooool01?l0
003oooooo`000?l00002ooooo`0:o`000?oooooo0000ooooool0003oooooo`000?oooooo0000oooo
o`;o00000oooool2o`0000?ooooo0ol00006ooooo`04o`000?oooooo0000o`0000;ooooo0_l00003
ooooo`?o000000Goooooo`000?ooooooooooo`000003ooooo`03o`000?oooooooooo00Co00000_oo
ool3o`0000?ooooo00?o0000ooooooooool01_ooool01?l0003oooooooooooooool4o`0000Kooooo
1?l000000ooooooo0000ooooo`02o`0000;ooooo0_l00003ooooo`;o00002?ooool3o`000003oooo
ool0003ooooo00;o000000Coooooo`000?l0003o00000oooool2o`0000;ooooo0ol00003ooooo`;o
00000_ooool3o`0000?ooooo0ol00006ooooo`Co00000oooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo0;Oooooo000Booooo`03o`000?oooooo000000gooooo00?o0000ooooooooool0
4oooool00ol0003oooooooooo`0Jooooo`05o`000?ooooooooooooooool000004oooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool06?ooool00ol0003o
ooooooooo`0Xooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`2gooooo`004_ooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00Go
oooo0_l0000Dooooo`;o00006oooool2o`0001Sooooo00?o0000ooooooooool00_ooool2o`0000So
oooo0_l0000Gooooo`;o00003Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo017o
oooo0_l00002ooooo`;o00000oooool00ol0003oooooooooo`2hooooo`00oooooon8ooooo`00oooo
oon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooo
oon8ooooo`00oooooon8ooooo`000oooool01?l0003oooooooooool00002ooooo`?o000000Cooooo
o`000?l0003o00000_ooool2o`000003ooooool0003o000000Gooooo0ol00007ooooo`06o`000?oo
oooo0000ooooool0003ooooo0_l00003ooooo`Co000000Coooooo`000?l0003o00000_ooool3o`00
00?ooooo00?o0000ooooooooool0oooooom4ooooo`000oooool00ol0003oooooo`000004ooooo`05
o`000?ooooooooooooooool000001?ooool00ol0003oooooo`000008ooooo`;o00001_ooool01?l0
003oooooo`000?ooool2o`0000;ooooo00?o0000ooooool000000_ooool01?l0003oooooo`000?l0
0005ooooo`03o`000?oooooooooo0?ooooooBOooool000?ooooo0_l00005ooooo`05o`000?oooooo
ooooooooool000001?ooool2o`0000Oooooo0_l00008ooooo`04o`000?oooooo0000ooooo`;o0000
0_ooool00ol0003oooooo`000002ooooo`04o`000?oooooo0000ooooo`;o00000oooool00ol0003o
ooooooooo`3oooooodWooooo0003ooooo`;o00001?ooool2o`0000;ooooo00Co0000ooooool0003o
00000_ooool00ol0003oooooo`000007ooooo`?o00001_ooool2o`000004ooooool0003ooooooooo
o`;o00000oooool3o`0000;ooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool0oooooom4ooooo`000oooool00ol0003oooooo`00000=ooooo`03o`000?oooooooooo00;o
oooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo0?oo
ooooBOooool000?ooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`05ooooo`;o
00001?ooool00ol0003oooooooooo`0Gooooo`;o00001oooool2o`000?ooooooBoooool00?oooooo
R?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?oooooo
R?ooool00?ooooooR?ooool003Gooooo0ol00018ooooo`?o0000ooooool5ooooo`00=oooool2o`00
04Wooooo0_l0003oooooo`Cooooo000eooooo`;o0000BOooool2o`000?oooooo1_ooool003Kooooo
0ol00018ooooo`?o0000ooooool4ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8oooo
o`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8oooo
o`00FOooool00ol0003oooooooooo`3oooooobcooooo000Dooooo`03o`000?oooooooooo04?ooooo
00?o0000ooooooooool0C?ooool00ol0003oooooooooo`3Kooooo`004oooool00ol0003ooooooooo
o`14ooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0f_ooool001?ooooo00?o0000
ooooooooool0U?ooool00ol0003oooooooooo`3Jooooo`004_ooool00ol0003oooooooooo`02oooo
o`Co000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o0000
00;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o0000
00;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o0000
00;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o0000
00;o00002oooool4o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooo
oooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooo
oooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooo
oooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooo
oooo0000o`000002o`000003ooooool0003o000000;o00001?ooool00ol0003oooooooooo`3Ioooo
o`004oooool00ol0003oooooooooo`2Dooooo`03o`000?oooooooooo0=[ooooo000Cooooo`03o`00
0?oooooooooo09Cooooo00?o0000ooooooooool0f_ooool001Cooooo00?o0000ooooooooool0T_oo
ool00ol0003oooooooooo`3Kooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00oooooon8ooooo`00E?ooool2o`0004kooooo0_l0003Qooooo`00E_ooool00ol0
003oooooooooo`1=ooooo`03o`000?oooooooooo0=kooooo000Hooooo`;o00001?ooool00ol0003o
ooooooooo`04o`0000;ooooo0_l00003ooooo`03o`000?oooooooooo00;ooooo0ol00007ooooo`?o
00000_ooool2o`0001;ooooo0ol0000;ooooo`Co00000oooool01?l0003oooooooooooooool2o`00
00;ooooo1?l00002ooooo`;o00000oooool3o`0000;ooooo0_l00008ooooo`?o00000_ooool2o`00
01;ooooo0ol0003Pooooo`005oooool01?l0003oooooooooool00007ooooo`05o`000?oooooooooo
ooooool000000_ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool01ooo
ool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00kooooo00Co0000oooooooooooo
00003?ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000oooo
ooooooooooooo`000002ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003ooooooooo
ool00008ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0003o
ooooooooool0003Pooooo`006_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool00ol00003ooooo`03o`000?oooooooooo00Oooooo00Co0000oooooooo
oooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`0000gooooo00?o0000
ooooooooool01Oooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00?ooooo00Go
0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000Sooooo00Co0000oooooooo
oooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`000>3ooooo000Ioooo
o`03o`000?oooooooooo00Sooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oooooo
ooooo`0000?ooooo00?o0000ooooooooool01oooool01?l0003oooooooooool00002ooooo`03o`00
0?oooooooooo00oooooo0ol0000>ooooo`03o`000?oooooooooo00Gooooo0_l00005ooooo`05o`00
0?ooooooooooooooool000001?ooool00ol0003oooooooooo`03o`0000Wooooo00Co0000oooooooo
oooo00000_ooool00ol0003oooooooooo`0?ooooo`?o0000h?ooool001Oooooo00Co0000oooooooo
oooo00001_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000ooooool000000_oo
ool01Ol0003ooooooooooooooooo000000Wooooo00Co0000oooooooooooo00000_ooool00ol0003o
ooooooooo`0Mooooo`04o`000?ooooooooooo`0000Kooooo00Ko0000oooooooooooo0000ooooool0
0002ooooo`03o`000?oooooo000000;ooooo00Go0000ooooooooooooooooo`000003ooooo`03o`00
0?oooooooooo00Sooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`3booooo`00
6?ooool2o`0000Sooooo0_l00003ooooo`;o00000oooool2o`0000?ooooo0_l00008ooooo`;o0000
0oooool2o`00027ooooo0_l00008ooooo`;o00000oooool2o`0000?ooooo0_l00003ooooo`;o0000
1?ooool00ol0003oooooooooo`06ooooo`;o00000oooool2o`000?Gooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo001:ooooo`03o`000?oooooooooo04gooooo00?o0000oooooooo
ool0j_ooool004[ooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`3Zooooo`00A?oo
ool4o`0000?ooooo00?o0000ooooooooool0A_ooool4o`0000?ooooo00?o0000ooooooooool0jOoo
ool004_ooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`3Yooooo`00BOooool01?l0
003oooooooooool0001<ooooo`04o`000?ooooooooooo`000>[ooooo0019ooooo`Co0000C?ooool4
o`000>[ooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo002hooooo`;o00000oooool00ol0003oooooooooo`37ooooo`00K_ooool00ol0003o
ooooooooo`19ooooo`05o`000?ooooooooooooooool000003Oooool00ol0003oooooooooo`2hoooo
o`004_ooool01?l0003oooooooooool00002ooooo`?o000000Coooooo`000?l0003o00000_ooool2
o`000007ooooool0003o0000ooooool0003oooooo`000002ooooo`;o00000oooool2o`0000?ooooo
1?l00005ooooo`?o00000oooool3o`000004ooooool0003o0000o`0000?ooooo0ol00002ooooo`?o
00000oooool2o`000004ooooool0003o0000o`0000Cooooo00?o0000ooooooooool01_ooool01?l0
003oooooooooooooool4o`0000Kooooo1?l000001?oooooo0000o`000?l00003ooooo`?o00000_oo
ool3o`0000Oooooo1ol00003ooooo`?o00000_ooool3o`000005ooooool0003oooooooooool00000
0_ooool3o`000005ooooool0003oooooooooool000000_ooool3o`0000?ooooo00?o0000oooooooo
ool01?l00002ooooo`?o00000oooool00ol0003oooooooooo`2gooooo`004_ooool00ol0003ooooo
o`000004ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooo`000002ooooo`05
o`000?oooooo0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo0000
00;ooooo00?o0000ooooooooool01Oooool01?l0003oooooooooooooool2o`0000Gooooo0_l00000
1Ooooooo0000oooooooooooo000000?ooooo00Go0000ooooooooooooooooo`000005ooooo`;o0000
3?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
0_ooool01?l0003oooooooooooooool2o`0000?ooooo0_l00008ooooo`04o`000?ooooooooooo`00
00;ooooo00Go0000ooooooooooooooooo`000002ooooo`05o`000?ooooooooooooooool000000_oo
ool01?l0003oooooooooool00003ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool0
00000_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`2gooooo`004_ooool2o`0000Gooooo00Go0000oooooooooooo
ooooo`000004ooooo`;o00000_ooool01?l0003oooooo`000?ooool2o`0000;ooooo00?o0000oooo
ool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Gooooo00Ko0000oooo
ooooooooooooo`000?ooool2o`000003ooooool0003o000000?ooooo00Co0000oooooooooooo0000
0oooool01Ol0003ooooooooooooooooo000000?ooooo0_l0000=ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`02ooooo`06o`000?oooooooooooooo
ool0003ooooo0_l000000ooooooo0000ooooo`02o`000003ooooool0003o000000;o000000Gooooo
o`000?ooooooooooo`000002ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooool000000ooo
ool01?l0003oooooooooool00002ooooo`05o`000?ooooooooooooooool000000_ooool01_l0003o
ooooooooool0003oooooo`0000;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0]_ooool001;ooooo0_l00004oooo
o`;o00000_ooool01?l0003oooooo`000?l00002ooooo`0:o`000?oooooo0000ooooool0003ooooo
o`000?oooooo0000ooooo`;o00000oooool2o`0000?ooooo0ol00006ooooo`04o`000?oooooo0000
o`0000;ooooo0_l00003ooooo`?o000000Goooooo`000?ooooooooooo`000003ooooo`03o`000?oo
oooooooo00Co00000_ooool3o`0000?ooooo00?o0000ooooooooool01_ooool01?l0003ooooooooo
ooooool4o`0000Kooooo1?l000000ooooooo0000ooooo`02o`0000;ooooo0_l00003ooooo`;o0000
2?ooool3o`000003ooooool0003ooooo00;o000000Coooooo`000?l0003o00000oooool2o`0000;o
oooo0ol00003ooooo`;o00000_ooool3o`0000?ooooo0ol00006ooooo`Co00000oooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo0;Oooooo000Booooo`03o`000?oooooo000000gooooo
00?o0000ooooooooool04oooool00ol0003oooooooooo`0Jooooo`05o`000?ooooooooooooooool0
00004oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool06?ooool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`2gooooo`004_ooool01?l0003oooooooooool00003ooooo`03
o`000?oooooooooo00Gooooo0_l0000Dooooo`;o00006oooool2o`0001Sooooo00?o0000oooooooo
ool00_ooool2o`0000Sooooo0_l0000Gooooo`;o00003Oooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo017ooooo0_l00002ooooo`;o00000oooool00ol0003oooooooooo`2hooooo`00
oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`002Oooool00ol0003oooooooooo`3oooooogcooooo000:ooooo`03o`000?oooooo
oooo0?ooooooNoooool000?ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo
oooo00Gooooo00Ko0000ooooool0003oooooo`000?ooool2o`0000?ooooo1?l000001?oooooo0000
o`000?l00002ooooo`?o00000oooool00ol0003oooooooooo`3ooooooeSooooo0003ooooo`09o`00
0?ooooooooooooooool0003oooooo`000?oooooo000000Kooooo00Co0000ooooool0003ooooo0_l0
0002ooooo`03o`000?oooooo000000;ooooo00Co0000ooooool0003o00001Oooool00ol0003ooooo
ooooo`3ooooooegooooo0003ooooo`09o`000?ooooooooooooooool0003oooooo`000?oooooo0000
00Kooooo00Co0000ooooool0003ooooo0_l00002ooooo`03o`000?oooooo000000;ooooo00Co0000
ooooool0003ooooo0_l00003ooooo`03o`000?oooooooooo0?ooooooGOooool000?ooooo00Co0000
ooooool0003ooooo0ol000000ooooooo0000o`000005ooooo`;o000000Coooooo`000?oooooooooo
0_l00003ooooo`?o00000_ooool2o`0000Cooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`3ooooooeSooooo0003ooooo`;o000000?oooooo`000?l000005oooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo0?ooooooGOooool000?ooooo00Go0000ooooooooooooooooo`00
000Fooooo`;o00001oooool2o`000?ooooooGoooool00?ooooooR?ooool00?ooooooR?ooool00?oo
ooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0033ooooo0_l0000=ooooo`;o0000oooooom7
ooooo`00<?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo0?ooooooA_ooool000?o
oooo1?l00002ooooo`;o00000oooool2o`0000Cooooo00?o0000ooooooooool01?l00002ooooo`;o
00000oooool2o`0000Oooooo0ol00002ooooo`?o00001oooool3o`0000;ooooo0ol00003ooooo`?o
00000_ooool3o`0000;ooooo0ol000001?oooooo0000o`000?l0003ooooooc;ooooo0004ooooo`05
o`000?ooooooooooooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo
00Gooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000
ooooooooool01?ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000ooooooooool0
1_ooool2o`000007ooooool0003oooooooooool0003oooooo`000002ooooo`03o`000?oooooo0000
00Cooooo0_l00004ooooo`03o`000?oooooooooo0?oooooo<Oooool000Gooooo00Co0000oooooooo
oooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Cooooo00Ko0000oooo
oooooooo0000ooooool00002ooooo`03o`000?oooooooooo00Cooooo0_l00003ooooo`04o`000?oo
ooooooooo`0000;ooooo00Go0000ooooool0003oooooo`000002ooooo`04o`000?oooooo0000oooo
o`;o00000_ooool00ol0003oooooooooo`3ooooooc7ooooo0006ooooo`03o`000?oooooo000000;o
00000oooool2o`0000[ooooo00Go0000ooooooooooooooooo`000002ooooo`?o00001oooool3o`00
00;ooooo0ol00008ooooo`?o000000Coooooo`000?l0003o00000_ooool3o`0000?ooooo0ol00002
ooooo`;o00000_ooool01?l0003oooooo`000?l0003ooooooc7ooooo0003ooooo`04o`000?oooooo
ooooo`0000;ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooooooo00Cooooo
00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooo000000Wooooo00?o0000oooo
ooooool0oooooomJooooo`001?ooool2o`0000Cooooo00Co0000oooooooooooooooo0_l00008oooo
o`;o00000oooool2o`0000;ooooo1?l00006ooooo`03o`000?oooooooooo0?ooooooF_ooool00?oo
ooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?oo
ooooR?ooool00?ooooooR?ooool00?ooooooR?ooool003Gooooo0ol0001=ooooo`?o0000ooooool0
03Oooooo0_l0001>ooooo`;o0000o_ooool003Gooooo0_l0001>ooooo`;o0000ooooool1ooooo`00
=_ooool3o`0004gooooo0ol0003nooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8oooo
o`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00G_ooool00ol0
003oooooooooo`3oooooobOooooo000Dooooo`03o`000?oooooooooo04Sooooo00?o0000oooooooo
ool0C?ooool00ol0003oooooooooo`3Fooooo`004oooool00ol0003oooooooooo`19ooooo`03o`00
0?oooooooooo04gooooo00?o0000ooooooooool0eOooool001?ooooo00?o0000ooooooooool0VOoo
ool00ol0003oooooooooo`3Eooooo`004_ooool00ol0003oooooooooo`02ooooo`Co000000?ooooo
o`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?ooooo
o`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?ooooo
o`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?ooooo
o`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?ooooo
o`000?l000000_l0000;ooooo`Co000000?oooooo`000?l000000_l000000ooooooo0000o`000002
o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002
o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002
o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002
o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l00004ooooo`03o`000?oooooo
oooo0=Cooooo000Cooooo`03o`000?oooooooooo09Wooooo00?o0000ooooooooool0eOooool001?o
oooo00?o0000ooooooooool0VOooool00ol0003oooooooooo`3Eooooo`005?ooool00ol0003ooooo
ooooo`2Gooooo`03o`000?oooooooooo0=Kooooo003oooooohSooooo003oooooohSooooo003ooooo
ohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo001Iooooo`;o0000C_ooool2
o`000=cooooo001Kooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0fOooool001So
oooo0_l00004ooooo`04o`000?ooooooooooooooo`;o00000_ooool4o`0000Cooooo00?o0000oooo
ooooool00_l00003ooooo`;o00002?ooool3o`0000;ooooo0_l0000Booooo`?o00003?ooool3o`00
00?ooooo00Go0000ooooooooooooooooo`000004ooooo`;o00001Oooool00ol0003oooooooooo`02
o`0000?ooooo00?o0000ooooooooool01oooool3o`0000;ooooo0_l0000Booooo`?o0000foooool0
01Oooooo00Co0000oooooooooooo00001_ooool01?l0003oooooooooool00002ooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oo
oooooooo00Kooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`00
0?ooooooooooo`0000gooooo00?o0000ooooooooool01_ooool01Ol0003ooooooooooooooooo0000
00;ooooo00?o0000ooooooooool00_ooool00ol0003oooooo`000002ooooo`04o`000?oooooooooo
o`0000[ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?oo
ooooooooo`000=_ooooo000Jooooo`03o`000?oooooooooo00Oooooo00Go0000oooooooooooooooo
o`000002ooooo`Co000000Goooooo`000?ooooooooooo`000004ooooo`03o`000?oooooooooo00Ko
oooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?oooooooooo
o`0000gooooo00?o0000ooooooooool01oooool01?l0003oooooooooool00002ooooo`03o`000?oo
oooo000000?o000000Goooooo`000?ooooooooooo`000003ooooo`03o`000?oooooooooo00Oooooo
00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`00
0=_ooooo000Gooooo`?o00001oooool3o`0000Gooooo00Oo0000oooooooooooo0000ooooool0003o
oooo00?o00000_ooool3o`0000Wooooo00Co0000oooooooooooo00000_ooool00ol0003ooooooooo
o`0?ooooo`?o00003Oooool00ol0003oooooooooo`07ooooo`04o`000?ooooooooooo`0000;ooooo
00Oo0000oooooooooooo0000ooooool0003ooooo00?o00001?ooool00ol0003oooooooooo`07oooo
o`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool03oooool3o`000=_ooooo000Goooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00003
ooooo`;o00000_ooool01Ol0003ooooooooooooooooo000000_ooooo00Co0000oooooooooooo0000
0_ooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00Gooooo00Ko0000oooooooooooo
0000ooooool00002ooooo`04o`000?ooooooooooooooo`;o00000_ooool01Ol0003ooooooooooooo
oooo000000;ooooo00?o0000ooooooooool01_ooool01?l0003oooooooooool00002ooooo`03o`00
0?oooooooooo0>gooooo000Gooooo`Co00001_ooool4o`0000;ooooo0_l00005ooooo`05o`000?oo
ooooooooooooool000000_ooool4o`0000Oooooo0_l00003ooooo`;o00008Oooool2o`0000Oooooo
1?l00002ooooo`;o00001Oooool01Ol0003ooooooooooooooooo000000;ooooo1?l00007ooooo`;o
00000oooool2o`000?3ooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003ooooo
ohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo001?ooooo`03o`000?oooooo
oooo04gooooo00?o0000ooooooooool0iOooool004oooooo00?o0000ooooooooool0COooool00ol0
003oooooooooo`3Uooooo`00BOooool4o`0000?ooooo00?o0000ooooooooool0A_ooool4o`0000?o
oooo00?o0000ooooooooool0i?ooool0053ooooo00?o0000ooooooooool0COooool00ol0003ooooo
ooooo`3Tooooo`00C_ooool01?l0003oooooooooool0001<ooooo`04o`000?ooooooooooo`000>Go
oooo001>ooooo`Co0000C?ooool4o`000>Gooooo003oooooohSooooo003oooooohSooooo003ooooo
ohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo002hooooo`;o00000oooool0
0ol0003oooooooooo`37ooooo`00K_ooool00ol0003oooooooooo`19ooooo`05o`000?oooooooooo
ooooool000003Oooool00ol0003oooooooooo`2hooooo`004_ooool01?l0003oooooooooool00002
ooooo`?o000000Coooooo`000?l0003o00000_ooool2o`000007ooooool0003o0000ooooool0003o
ooooo`000002ooooo`;o00000oooool2o`0000?ooooo1?l00005ooooo`?o00000oooool3o`000004
ooooool0003o0000o`0000?ooooo0ol00002ooooo`?o00000oooool2o`000004ooooool0003o0000
o`0000Cooooo00?o0000ooooooooool01_ooool01?l0003oooooooooooooool4o`0000Kooooo1?l0
00001?oooooo0000o`000?l00003ooooo`?o00000_ooool3o`0000Oooooo1ol00003ooooo`?o0000
0_ooool3o`000005ooooool0003oooooooooool000000_ooool3o`000005ooooool0003ooooooooo
ool000000_ooool3o`0000?ooooo00?o0000ooooooooool01?l00002ooooo`?o00000oooool00ol0
003oooooooooo`2gooooo`004_ooool00ol0003oooooo`000004ooooo`05o`000?oooooooooooooo
ool000001?ooool00ol0003oooooo`000002ooooo`05o`000?oooooo0000ooooool000000_ooool0
0ol0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool01Oooool0
1?l0003oooooooooooooool2o`0000Gooooo0_l000001Ooooooo0000oooooooooooo000000?ooooo
00Go0000ooooooooooooooooo`000005ooooo`;o00003?ooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool00_ooool01?l0003oooooooooooooool2o`00
00?ooooo0_l00008ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000ooooooooooooooooo`00
0002ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool00003ooooo`04
o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2goooo
o`004_ooool2o`0000Gooooo00Go0000ooooooooooooooooo`000004ooooo`;o00000_ooool01?l0
003oooooo`000?ooool2o`0000;ooooo00?o0000ooooool000000_ooool00ol0003oooooo`000002
ooooo`03o`000?oooooooooo00Gooooo00Ko0000ooooooooooooooooo`000?ooool2o`000003oooo
ool0003o000000?ooooo00Co0000oooooooooooo00000oooool01Ol0003ooooooooooooooooo0000
00?ooooo0_l0000=ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`02ooooo`06o`000?ooooooooooooooool0003ooooo0_l000000ooooooo0000oooo
o`02o`000003ooooool0003o000000;o000000Goooooo`000?ooooooooooo`000002ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooool000000oooool01?l0003oooooooooool00002ooooo`05
o`000?ooooooooooooooool000000_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool0]_ooool001;ooooo0_l00004ooooo`;o00000_ooool01?l0003oooooo`000?l0
0002ooooo`0:o`000?oooooo0000ooooool0003oooooo`000?oooooo0000ooooo`;o00000oooool2
o`0000?ooooo0ol00006ooooo`04o`000?oooooo0000o`0000;ooooo0_l00003ooooo`?o000000Go
ooooo`000?ooooooooooo`000003ooooo`03o`000?oooooooooo00Co00000_ooool3o`0000?ooooo
00?o0000ooooooooool01_ooool01?l0003oooooooooooooool4o`0000Kooooo1?l000000ooooooo
0000ooooo`02o`0000;ooooo0_l00003ooooo`;o00002?ooool3o`000003ooooool0003ooooo00;o
000000Coooooo`000?l0003o00000oooool2o`0000;ooooo0ol00003ooooo`;o00000_ooool3o`00
00?ooooo0ol00006ooooo`Co00000oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
0;Oooooo000Booooo`03o`000?oooooo000000gooooo00?o0000ooooooooool04oooool00ol0003o
ooooooooo`0Jooooo`05o`000?ooooooooooooooool000004oooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0Xoooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2goooo
o`004_ooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00Gooooo0_l0000Doooo
o`;o00006oooool2o`0001Sooooo00?o0000ooooooooool00_ooool2o`0000Sooooo0_l0000Goooo
o`;o00003Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo017ooooo0_l00002oooo
o`;o00000oooool00ol0003oooooooooo`2hooooo`00oooooon8ooooo`00oooooon8ooooo`00oooo
oon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`000ooo
ool01?l0003oooooooooool00002ooooo`?o000000Coooooo`000?l0003o00000_ooool2o`000003
ooooool0003o000000Gooooo0ol00007ooooo`06o`000?oooooo0000ooooool0003ooooo0_l00003
ooooo`Co000000Coooooo`000?l0003o00000_ooool3o`0000?ooooo00?o0000ooooooooool0oooo
oom4ooooo`000oooool00ol0003oooooo`000004ooooo`05o`000?ooooooooooooooool000001?oo
ool00ol0003oooooo`000008ooooo`;o00001_ooool01?l0003oooooo`000?ooool2o`0000;ooooo
00?o0000ooooool000000_ooool01?l0003oooooo`000?l00005ooooo`03o`000?oooooooooo0?oo
ooooBOooool000?ooooo0_l00005ooooo`05o`000?ooooooooooooooool000001?ooool2o`0000Oo
oooo0_l00008ooooo`04o`000?oooooo0000ooooo`;o00000_ooool00ol0003oooooo`000002oooo
o`04o`000?oooooo0000ooooo`;o00000oooool00ol0003oooooooooo`3oooooodWooooo0003oooo
o`;o00001?ooool2o`0000;ooooo00Co0000ooooool0003o00000_ooool00ol0003oooooo`000007
ooooo`?o00001_ooool2o`000004ooooool0003oooooooooo`;o00000oooool3o`0000;ooooo0_l0
0004ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0oooooom4ooooo`000oooool0
0ol0003oooooo`00000=ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool06?ooool0
0ol0003oooooooooo`06ooooo`03o`000?oooooooooo0?ooooooBOooool000?ooooo00Co0000oooo
oooooooo00000oooool00ol0003oooooooooo`05ooooo`;o00001?ooool00ol0003oooooooooo`0G
ooooo`;o00001oooool2o`000?ooooooBoooool00?ooooooR?ooool00?ooooooR?ooool00?oooooo
R?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?oooooo
R?ooool003Gooooo0ol0001=ooooo`?o0000ooooool003Oooooo0_l0001>ooooo`;o0000o_ooool0
03Gooooo0_l0001>ooooo`;o0000ooooool1ooooo`00=_ooool3o`0004gooooo0ol0003nooooo`00
oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00oooooon8ooooo`00G_ooool00ol0003oooooooooo`3oooooobOooooo000Doooo
o`03o`000?oooooooooo04Sooooo00?o0000ooooooooool0C?ooool00ol0003oooooooooo`3Foooo
o`004oooool00ol0003oooooooooo`19ooooo`03o`000?oooooooooo04gooooo00?o0000oooooooo
ool0eOooool001?ooooo00?o0000ooooooooool0VOooool00ol0003oooooooooo`3Eooooo`004_oo
ool00ol0003oooooooooo`02ooooo`Co000000?oooooo`000?l000000_l000000ooooooo0000o`00
0002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`00
0002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`00
0002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`00
0002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l0000;ooooo`Co000000?o
ooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?o
ooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?o
ooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?o
ooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?o
ooooo`000?l000000_l00004ooooo`03o`000?oooooooooo0=Cooooo000Cooooo`03o`000?oooooo
oooo09Wooooo00?o0000ooooooooool0eOooool001?ooooo00?o0000ooooooooool0VOooool00ol0
003oooooooooo`3Eooooo`005?ooool00ol0003oooooooooo`2Gooooo`03o`000?oooooooooo0=Ko
oooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSo
oooo003oooooohSooooo001Iooooo`;o0000C_ooool2o`000=cooooo001Kooooo`03o`000?oooooo
oooo04gooooo00?o0000ooooooooool0fOooool001Sooooo0_l00004ooooo`04o`000?oooooooooo
ooooo`;o00000oooool2o`0000?ooooo00?o0000ooooooooool00_ooool3o`0000;ooooo00?o0000
ooooooooool01oooool3o`0000;ooooo0_l0000Booooo`?o00002oooool4o`0000?ooooo00Co0000
oooooooooooooooo0_l00003ooooo`?o00000_ooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool01Oooool3o`0000;ooooo0_l0000Booooo`?o0000fooo
ool001Oooooo00Co0000oooooooooooo00001_ooool01_l0003oooooooooool0003oooooo`0000;o
oooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
00Oooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?oooooo
ooooo`0000cooooo00?o0000ooooooooool01_ooool01?l0003oooooooooool00003ooooo`05o`00
0?ooooooooooooooool000001Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Ko
oooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?oooooooooo
o`000=_ooooo000Jooooo`03o`000?oooooooooo00Cooooo00Co0000oooooooooooo00001?ooool0
1Ol0003ooooooooooooooooo000000Cooooo00Co0000oooooooooooooooo0ol00008ooooo`04o`00
0?ooooooooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0003oooooooooool0000=oooo
o`03o`000?oooooooooo00Gooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`02
ooooo`04o`000?ooooooooooooooo`?o000000?oooooo`000?l000000_l00008ooooo`04o`000?oo
ooooooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0003oooooooooool0003Kooooo`00
6Oooool00ol0003oooooooooo`05ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooo
ooooool01_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00oooooo0ol0000>
ooooo`03o`000?oooooooooo00Cooooo0ol00004ooooo`03o`000?oooooooooo00;ooooo00Co0000
oooooooooooo00000_ooool01_l0003oooooooooool0003oooooo`0000Sooooo00Co0000oooooooo
oooo00000_ooool00ol0003oooooooooo`0?ooooo`?o0000foooool001Oooooo00Co0000oooooooo
oooo00001_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000ooooool000000_oo
ool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo00002?ooool01?l0003o
ooooooooool00002ooooo`03o`000?oooooooooo01gooooo00Co0000oooooooooooo00001oooool0
0ol0003oooooooooo`03ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000_oo
ool01?l0003oooooooooooooool2o`0000Sooooo00Co0000oooooooooooo00000_ooool00ol0003o
ooooooooo`3]ooooo`006?ooool2o`0000Sooooo0_l00003ooooo`;o00000_ooool4o`0000;ooooo
0_l00003ooooo`;o00002?ooool2o`0000?ooooo0_l0000Qooooo`;o00002Oooool01?l0003ooooo
ooooooooool2o`0000;ooooo1?l00002ooooo`;o00001Oooool00ol0003oooooooooo`05ooooo`;o
00000oooool2o`000?3ooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003ooooo
ohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo001?ooooo`03o`000?oooooo
oooo04gooooo00?o0000ooooooooool0iOooool004oooooo00?o0000ooooooooool0COooool00ol0
003oooooooooo`3Uooooo`00BOooool4o`0000?ooooo00?o0000ooooooooool0A_ooool4o`0000?o
oooo00?o0000ooooooooool0i?ooool0053ooooo00?o0000ooooooooool0COooool00ol0003ooooo
ooooo`3Tooooo`00C_ooool01?l0003oooooooooool0001<ooooo`04o`000?ooooooooooo`000>Go
oooo001>ooooo`Co0000C?ooool4o`000>Gooooo003oooooohSooooo003oooooohSooooo003ooooo
ohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo002hooooo`;o00000oooool0
0ol0003oooooooooo`37ooooo`00K_ooool00ol0003oooooooooo`19ooooo`05o`000?oooooooooo
ooooool000003Oooool00ol0003oooooooooo`2hooooo`004_ooool01?l0003oooooooooool00002
ooooo`?o000000Coooooo`000?l0003o00000_ooool2o`000007ooooool0003o0000ooooool0003o
ooooo`000002ooooo`;o00000oooool2o`0000?ooooo1?l00005ooooo`?o00000oooool3o`000004
ooooool0003o0000o`0000?ooooo0ol00002ooooo`?o00000oooool2o`000004ooooool0003o0000
o`0000Cooooo00?o0000ooooooooool01_ooool01?l0003oooooooooooooool4o`0000Kooooo1?l0
00001?oooooo0000o`000?l00003ooooo`?o00000_ooool3o`0000Oooooo1ol00003ooooo`?o0000
0_ooool3o`000005ooooool0003oooooooooool000000_ooool3o`000005ooooool0003ooooooooo
ool000000_ooool3o`0000?ooooo00?o0000ooooooooool01?l00002ooooo`?o00000oooool00ol0
003oooooooooo`2gooooo`004_ooool00ol0003oooooo`000004ooooo`05o`000?oooooooooooooo
ool000001?ooool00ol0003oooooo`000002ooooo`05o`000?oooooo0000ooooool000000_ooool0
0ol0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool01Oooool0
1?l0003oooooooooooooool2o`0000Gooooo0_l000001Ooooooo0000oooooooooooo000000?ooooo
00Go0000ooooooooooooooooo`000005ooooo`;o00003?ooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool00_ooool01?l0003oooooooooooooool2o`00
00?ooooo0_l00008ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000ooooooooooooooooo`00
0002ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool00003ooooo`04
o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2goooo
o`004_ooool2o`0000Gooooo00Go0000ooooooooooooooooo`000004ooooo`;o00000_ooool01?l0
003oooooo`000?ooool2o`0000;ooooo00?o0000ooooool000000_ooool00ol0003oooooo`000002
ooooo`03o`000?oooooooooo00Gooooo00Ko0000ooooooooooooooooo`000?ooool2o`000003oooo
ool0003o000000?ooooo00Co0000oooooooooooo00000oooool01Ol0003ooooooooooooooooo0000
00?ooooo0_l0000=ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`02ooooo`06o`000?ooooooooooooooool0003ooooo0_l000000ooooooo0000oooo
o`02o`000003ooooool0003o000000;o000000Goooooo`000?ooooooooooo`000002ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooool000000oooool01?l0003oooooooooool00002ooooo`05
o`000?ooooooooooooooool000000_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool0]_ooool001;ooooo0_l00004ooooo`;o00000_ooool01?l0003oooooo`000?l0
0002ooooo`0:o`000?oooooo0000ooooool0003oooooo`000?oooooo0000ooooo`;o00000oooool2
o`0000?ooooo0ol00006ooooo`04o`000?oooooo0000o`0000;ooooo0_l00003ooooo`?o000000Go
ooooo`000?ooooooooooo`000003ooooo`03o`000?oooooooooo00Co00000_ooool3o`0000?ooooo
00?o0000ooooooooool01_ooool01?l0003oooooooooooooool4o`0000Kooooo1?l000000ooooooo
0000ooooo`02o`0000;ooooo0_l00003ooooo`;o00002?ooool3o`000003ooooool0003ooooo00;o
000000Coooooo`000?l0003o00000oooool2o`0000;ooooo0ol00003ooooo`;o00000_ooool3o`00
00?ooooo0ol00006ooooo`Co00000oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
0;Oooooo000Booooo`03o`000?oooooo000000gooooo00?o0000ooooooooool04oooool00ol0003o
ooooooooo`0Jooooo`05o`000?ooooooooooooooool000004oooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0Xoooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2goooo
o`004_ooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00Gooooo0_l0000Doooo
o`;o00006oooool2o`0001Sooooo00?o0000ooooooooool00_ooool2o`0000Sooooo0_l0000Goooo
o`;o00003Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo017ooooo0_l00002oooo
o`;o00000oooool00ol0003oooooooooo`2hooooo`00oooooon8ooooo`00oooooon8ooooo`00oooo
oon8ooooo`00oooooon8ooooo`00oooooon8ooooo`002Oooool00ol0003oooooooooo`3oooooogco
oooo000:ooooo`03o`000?oooooooooo0?ooooooNoooool000?ooooo00Go0000oooooooooooooooo
o`000002ooooo`03o`000?oooooooooo00Gooooo00Ko0000ooooool0003oooooo`000?ooool2o`00
00?ooooo1?l000001?oooooo0000o`000?l00002ooooo`?o00000oooool00ol0003oooooooooo`3o
oooooeSooooo0003ooooo`09o`000?ooooooooooooooool0003oooooo`000?oooooo000000Kooooo
00Co0000ooooool0003ooooo0_l00002ooooo`03o`000?oooooo000000;ooooo00Co0000ooooool0
003o00001Oooool00ol0003oooooooooo`3ooooooegooooo0003ooooo`09o`000?oooooooooooooo
ool0003oooooo`000?oooooo000000Kooooo00Co0000ooooool0003ooooo0_l00002ooooo`03o`00
0?oooooo000000;ooooo00Co0000ooooool0003ooooo0_l00003ooooo`03o`000?oooooooooo0?oo
ooooGOooool000?ooooo00Co0000ooooool0003ooooo0ol000000ooooooo0000o`000005ooooo`;o
000000Coooooo`000?oooooooooo0_l00003ooooo`?o00000_ooool2o`0000Cooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`3ooooooeSooooo0003ooooo`;o000000?oooooo`000?l0
00005oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo0?ooooooGOooool000?ooooo
00Go0000ooooooooooooooooo`00000Fooooo`;o00001oooool2o`000?ooooooGoooool00?oooooo
R?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?oooooo
R?ooool0033ooooo0_l0000=ooooo`;o0000oooooom7ooooo`00<?ooool00ol0003oooooooooo`0<
ooooo`03o`000?oooooooooo0?ooooooA_ooool000?ooooo1?l00002ooooo`;o00001Oooool01Ol0
003ooooooooooooooooo000000?ooooo00?o0000ooooooooool00_ooool2o`0000?ooooo0_l00007
ooooo`?o00000_ooool3o`0000Oooooo0ol00002ooooo`?o00000oooool3o`0000;ooooo0ol00002
ooooo`?o000000Coooooo`000?l0003o0000oooooolbooooo`001?ooool01Ol0003ooooooooooooo
oooo000000;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`05ooooo`05o`000?oo
ooooooooooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Cooooo
00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooooooo00Kooooo0_l000001ooo
oooo0000oooooooooooo0000ooooool000000_ooool00ol0003oooooo`000004ooooo`;o00001?oo
ool00ol0003oooooooooo`3ooooooc7ooooo0005ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooool000000ol00008ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000_oo
ool00ol0003oooooooooo`04ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003o
ooooooooo`04ooooo`;o00000oooool01?l0003oooooooooool00002ooooo`05o`000?oooooo0000
ooooool000000_ooool01?l0003oooooo`000?ooool2o`0000;ooooo00?o0000ooooooooool0oooo
oolaooooo`001_ooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooool000002?oo
ool01?l0003oooooooooool00002ooooo`03o`000?oooooo000000;o00001oooool3o`0000;ooooo
0ol00008ooooo`?o000000Coooooo`000?l0003o00000_ooool3o`0000?ooooo0ol00002ooooo`;o
00000_ooool01?l0003oooooo`000?l0003ooooooc7ooooo0003ooooo`06o`000?ooooooooooo`00
0?oooooo00000_ooool01?l0003oooooooooooooool2o`0000Kooooo00Ko0000oooooooooooo0000
ooooool00002ooooo`04o`000?ooooooooooo`0000Sooooo00?o0000ooooooooool0oooooomJoooo
o`001?ooool2o`0000?ooooo0_l00005ooooo`03o`000?oooooooooo00Cooooo1?l00002ooooo`;o
00001?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo0?ooooooF_ooool00?oooooo
R?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?oooooo
R?ooool00?ooooooR?ooool003Gooooo0ol0001=ooooo`?o0000ooooool003Oooooo0_l0001>oooo
o`;o0000o_ooool003Gooooo0_l0001>ooooo`;o0000ooooool1ooooo`00=_ooool3o`0004gooooo
0ol0003nooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00G_ooool00ol0003o
ooooooooo`3oooooobOooooo000Dooooo`03o`000?oooooooooo04Sooooo00?o0000ooooooooool0
C?ooool00ol0003oooooooooo`3Fooooo`004oooool00ol0003oooooooooo`19ooooo`03o`000?oo
oooooooo04gooooo00?o0000ooooooooool0eOooool001?ooooo00?o0000ooooooooool0VOooool0
0ol0003oooooooooo`3Eooooo`004_ooool00ol0003oooooooooo`02ooooo`Co000000?oooooo`00
0?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`00
0?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`00
0?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`00
0?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`00
0?l000000_l0000;ooooo`Co000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`00
0003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`00
0003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`00
0003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`00
0003ooooool0003o000000;o000000?oooooo`000?l000000_l00004ooooo`03o`000?oooooooooo
0=Cooooo000Cooooo`03o`000?oooooooooo09Wooooo00?o0000ooooooooool0eOooool001?ooooo
00?o0000ooooooooool0VOooool00ol0003oooooooooo`3Eooooo`005?ooool00ol0003ooooooooo
o`2Gooooo`03o`000?oooooooooo0=Kooooo003oooooohSooooo003oooooohSooooo003oooooohSo
oooo003oooooohSooooo003oooooohSooooo001Iooooo`;o0000C_ooool2o`000=cooooo001Koooo
o`03o`000?oooooooooo04gooooo00?o0000ooooooooool0fOooool001[ooooo00Go0000oooooooo
ooooooooo`000003ooooo`;o00000oooool00ol0003oooooooooo`02ooooo`?o00000_ooool2o`00
00?ooooo0_l00008ooooo`?o00000_ooool2o`0001;ooooo0ol0000<ooooo`?o00000oooool01?l0
003oooooooooooooool2o`0000?ooooo0_l00003ooooo`;o00000oooool00ol0003oooooooooo`02
ooooo`;o00002?ooool3o`0000;ooooo0_l0000Booooo`?o0000foooool001[ooooo00?o0000oooo
ooooool01?ooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00;ooooo00Co0000
oooooooooooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Kooooo00Co
0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`0000go
oooo00?o0000ooooooooool01Oooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000
ooooool000000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo0000
2?ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00kooooo00Co0000oooooooo
oooo0000foooool001Oooooo1?l00006ooooo`04o`000?ooooooooooo`0000;ooooo0ol00003oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`06oooo
o`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0003oooooooooool0
000=ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooool000000_ooool00ol0003oooooo`00
0002ooooo`03o`000?oooooooooo00?o000000Goooooo`000?ooooooooooo`000008ooooo`04o`00
0?ooooooooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0003oooooooooool0003Koooo
o`006?ooool00ol0003oooooo`000007ooooo`;o00000_ooool01?l0003oooooooooool00003oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00ol00009ooooo`04o`000?oooooooooo
o`0000;ooooo00?o0000ooooooooool03oooool3o`0000gooooo00?o0000ooooooooool01Oooool3
o`0000?ooooo0_l00002ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003ooooo
o`000002o`0000Wooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0?ooooo`?o
0000foooool001Wooooo0_l00006ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool01Ol0
003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo00000_ooool00ol0003ooooooooo
o`08ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool07oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00;ooooo00Ko0000oooooooooooo0000ooooool00002oooo
o`03o`000?oooooo000000;ooooo00Co0000oooooooooooo00002_ooool01?l0003oooooooooool0
0002ooooo`03o`000?oooooooooo0>gooooo000Jooooo`03o`000?oooooooooo00Gooooo0_l00003
ooooo`;o00000oooool2o`0000?ooooo0_l00004ooooo`03o`000?oooooooooo00Kooooo0_l00003
ooooo`;o00008Oooool2o`0000Oooooo1?l00002ooooo`;o00000oooool2o`0000?ooooo0_l00004
ooooo`03o`000?oooooooooo00Kooooo0_l00003ooooo`;o0000l?ooool00?ooooooR?ooool00?oo
ooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?oo
ooooR?ooool00?ooooooR?ooool004oooooo00?o0000ooooooooool0COooool00ol0003ooooooooo
o`3Uooooo`00Coooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0>Gooooo0019oooo
o`Co00000oooool00ol0003oooooooooo`16ooooo`Co00000oooool00ol0003oooooooooo`3Toooo
o`00D?ooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0>Cooooo001>ooooo`04o`00
0?ooooooooooo`0004cooooo00Co0000oooooooooooo0000iOooool004kooooo1?l0001<ooooo`Co
0000iOooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?oo
ooooR?ooool00;Sooooo0_l00003ooooo`03o`000?oooooooooo0<Oooooo001^ooooo`03o`000?oo
oooooooo04Wooooo00Go0000ooooooooooooooooo`00000=ooooo`03o`000?oooooooooo0;Sooooo
000Booooo`04o`000?ooooooooooo`0000;ooooo0ol000001?oooooo0000o`000?l00002ooooo`;o
000000Ooooooo`000?l0003oooooo`000?oooooo000000;ooooo0_l00003ooooo`;o00000oooool4
o`0000Gooooo0ol00003ooooo`?o000000Coooooo`000?l0003o00000oooool3o`0000;ooooo0ol0
0003ooooo`;o000000Coooooo`000?l0003o00001?ooool00ol0003oooooooooo`06ooooo`04o`00
0?ooooooooooooooo`Co00001_ooool4o`000004ooooool0003o0000o`0000?ooooo0ol00002oooo
o`?o00001oooool7o`0000?ooooo0ol00002ooooo`?o000000Goooooo`000?ooooooooooo`000002
ooooo`?o000000Goooooo`000?ooooooooooo`000002ooooo`?o00000oooool00ol0003ooooooooo
o`04o`0000;ooooo0ol00003ooooo`03o`000?oooooooooo0;Oooooo000Booooo`03o`000?oooooo
000000Cooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooo000000;ooooo00Go
0000ooooool0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool00000
0_ooool00ol0003oooooooooo`05ooooo`04o`000?ooooooooooooooo`;o00001Oooool2o`000005
ooooool0003oooooooooool000000oooool01Ol0003ooooooooooooooooo000000Gooooo0_l0000<
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`02
ooooo`04o`000?ooooooooooooooo`;o00000oooool2o`0000Sooooo00Co0000oooooooooooo0000
0_ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000ooooooooooooooooo`000002oooo
o`04o`000?ooooooooooo`0000?ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`00
0002ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo0;Oooooo000Booooo`;o00001Oooool01Ol0003ooooooooooooo
oooo000000Cooooo0_l00002ooooo`04o`000?oooooo0000ooooo`;o00000_ooool00ol0003ooooo
o`000002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool01Oooool01_l0003ooooo
oooooooooooo0000ooooo`;o000000?oooooo`000?l000000oooool01?l0003oooooooooool00003
ooooo`05o`000?ooooooooooooooool000000oooool2o`0000gooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00;ooooo00Ko0000oooooooooooooooo
o`000?ooool2o`000003ooooool0003ooooo00;o000000?oooooo`000?l000000_l000001Ooooooo
0000oooooooooooo000000;ooooo00?o0000ooooooooool00_ooool00ol0003oooooo`000003oooo
o`04o`000?ooooooooooo`0000;ooooo00Go0000ooooooooooooooooo`000002ooooo`06o`000?oo
ooooooooo`000?oooooo00000_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2fooooo`004_ooool2o`0000Cooooo
0_l00002ooooo`04o`000?oooooo0000o`0000;ooooo00[o0000ooooool0003oooooo`000?oooooo
0000ooooool0003ooooo0_l00003ooooo`;o00000oooool3o`0000Kooooo00Co0000ooooool0003o
00000_ooool2o`0000?ooooo0ol000001Ooooooo0000oooooooooooo000000?ooooo00?o0000oooo
ooooool01?l00002ooooo`?o00000oooool00ol0003oooooooooo`06ooooo`04o`000?oooooooooo
ooooo`Co00001_ooool4o`000003ooooool0003ooooo00;o00000_ooool2o`0000?ooooo0_l00008
ooooo`?o000000?oooooo`000?ooool00_l000001?oooooo0000o`000?l00003ooooo`;o00000_oo
ool3o`0000?ooooo0_l00002ooooo`?o00000oooool3o`0000Kooooo1?l00003ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool0]oooool001;ooooo00?o0000ooooool000003Oooool0
0ol0003oooooooooo`0Cooooo`03o`000?oooooooooo01[ooooo00Go0000ooooooooooooooooo`00
000Cooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`0Hooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo0;Oooooo000Booooo`04o`000?ooooooooooo`0000?ooooo00?o
0000ooooooooool01Oooool2o`0001Cooooo0_l0000Kooooo`;o00006?ooool00ol0003ooooooooo
o`02ooooo`;o00002?ooool2o`0001Oooooo0_l0000=ooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool04Oooool2o`0000;ooooo0_l00003ooooo`03o`000?oooooooooo0;Sooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo0003ooooo`04o`000?ooooooooooo`0000;o
oooo0ol000001?oooooo0000o`000?l00002ooooo`;o000000?oooooo`000?l000001Oooool3o`00
00Oooooo00Ko0000ooooool0003oooooo`000?ooool2o`0000?ooooo1?l000001?oooooo0000o`00
0?l00002ooooo`?o00000oooool00ol0003oooooooooo`3oooooodCooooo0003ooooo`03o`000?oo
oooo000000Cooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooo000000Sooooo
0_l00006ooooo`04o`000?oooooo0000ooooo`;o00000_ooool00ol0003oooooo`000002ooooo`04
o`000?oooooo0000o`0000Gooooo00?o0000ooooooooool0oooooom9ooooo`000oooool2o`0000Go
oooo00Go0000ooooooooooooooooo`000004ooooo`;o00001oooool2o`0000Sooooo00Co0000oooo
ool0003ooooo0_l00002ooooo`03o`000?oooooo000000;ooooo00Co0000ooooool0003ooooo0_l0
0003ooooo`03o`000?oooooooooo0?ooooooBOooool000?ooooo0_l00004ooooo`;o00000_ooool0
1?l0003oooooo`000?l00002ooooo`03o`000?oooooo000000Oooooo0ol00006ooooo`;o000000Co
ooooo`000?oooooooooo0_l00003ooooo`?o00000_ooool2o`0000Cooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`3oooooodCooooo0003ooooo`03o`000?oooooo000000gooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00Kooooo00?o
0000ooooooooool0oooooom9ooooo`000oooool01?l0003oooooooooool00003ooooo`03o`000?oo
oooooooo00Gooooo0_l00004ooooo`03o`000?oooooooooo01Oooooo0_l00007ooooo`;o0000oooo
oom;ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooo
oon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00=Oooool3o`0004gooooo0ol0003oooooo`00
=oooool2o`0004kooooo0_l0003nooooo`00=Oooool2o`0004kooooo0_l0003oooooo`7ooooo000f
ooooo`?o0000COooool3o`000?kooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo
003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo
001Nooooo`03o`000?oooooooooo0?oooooo9oooool001Cooooo00?o0000ooooooooool0B?ooool0
0ol0003oooooooooo`1<ooooo`03o`000?oooooooooo0=Kooooo000Cooooo`03o`000?oooooooooo
04Wooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`3Eooooo`004oooool00ol0003o
ooooooooo`2Iooooo`03o`000?oooooooooo0=Gooooo000Booooo`03o`000?oooooooooo00;ooooo
1?l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l00000
0_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l00000
0_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l00000
0_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l00000
0_l000000ooooooo0000o`000002o`0000_ooooo1?l000000ooooooo0000o`000002o`000003oooo
ool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003oooo
ool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003oooo
ool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003oooo
ool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`0000Cooooo
00?o0000ooooooooool0e?ooool001?ooooo00?o0000ooooooooool0VOooool00ol0003ooooooooo
o`3Eooooo`004oooool00ol0003oooooooooo`2Iooooo`03o`000?oooooooooo0=Gooooo000Doooo
o`03o`000?oooooooooo09Oooooo00?o0000ooooooooool0e_ooool00?ooooooR?ooool00?oooooo
R?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool005Wooooo0_l0001>ooooo`;o
0000g?ooool005_ooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`3Iooooo`005ooo
ool4o`0000?ooooo00Co0000oooooooooooooooo0_l00003ooooo`;o00000oooool2o`0000?ooooo
0_l00003ooooo`?o00001oooool3o`0000;ooooo0_l0000Booooo`?o00002oooool4o`0000?ooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`02o`0000?ooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`02ooooo`?o00001oooool3o`0000;ooooo0_l0000Booooo`?o0000
foooool001Sooooo00?o0000ooooooooool01_ooool01_l0003oooooooooool0003oooooo`0000;o
oooo00?o0000ooooool000000_ooool00ol0003oooooo`000002ooooo`05o`000?oooooooooooooo
ool000002Oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00kooooo00Co0000
oooooooooooo00003?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooo000000;ooooo00Co
0000oooooooooooo00001?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Oooooo
00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`00
0=_ooooo000Iooooo`03o`000?oooooooooo00Gooooo00Co0000oooooooooooo00001?ooool00ol0
003oooooo`000002ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`000009
ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0003ooooooooo
ool0000=ooooo`03o`000?oooooooooo00Gooooo1?l000001Ooooooo0000oooooooooooo000000?o
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Oo
oooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?oooooooooo
o`000=_ooooo000Jooooo`03o`000?oooooooooo00Gooooo0_l00004ooooo`04o`000?oooooooooo
o`0000;ooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00Oooooo00Co
0000oooooooooooo00000_ooool00ol0003oooooooooo`0?ooooo`?o00003_ooool00ol0003ooooo
ooooo`05ooooo`05o`000?oooooo0000ooooool000000_ooool01Ol0003ooooooooooooooooo0000
00Cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`07ooooo`04o`000?oooooooooo
o`0000;ooooo00?o0000ooooooooool03oooool3o`000=_ooooo000Gooooo`04o`000?oooooooooo
o`0000Kooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooo000000;ooooo
00?o0000ooooool000000_ooool01Ol0003ooooooooooooooooo000000Wooooo00Co0000oooooooo
oooo00000_ooool00ol0003oooooooooo`0Mooooo`04o`000?ooooooooooo`0000Sooooo0_l00000
1ooooooo0000oooooooooooo0000ooooool000000_ooool00ol0003oooooo`000002ooooo`05o`00
0?ooooooooooooooool000002Oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo
0>gooooo000Hooooo`;o00002?ooool2o`0000?ooooo0_l00003ooooo`;o00000oooool2o`0000?o
oooo0_l00008ooooo`;o00000oooool2o`00027ooooo0_l0000:ooooo`03o`000?oooooooooo00;o
00000_ooool4o`000003ooooool0003o000000;o00000_ooool2o`0000Sooooo0_l00003ooooo`;o
0000l?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?oo
ooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool004oooooo00?o0000oooo
ooooool0COooool00ol0003oooooooooo`3Uooooo`00Coooool00ol0003oooooooooo`1=ooooo`03
o`000?oooooooooo0>Gooooo0019ooooo`Co00000oooool00ol0003oooooooooo`16ooooo`Co0000
0oooool00ol0003oooooooooo`3Tooooo`00D?ooool00ol0003oooooooooo`1=ooooo`03o`000?oo
oooooooo0>Cooooo001>ooooo`04o`000?ooooooooooo`0004cooooo00Co0000oooooooooooo0000
iOooool004kooooo1?l0001<ooooo`Co0000iOooool00?ooooooR?ooool00?ooooooR?ooool00?oo
ooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00;Sooooo0_l00003ooooo`03o`000?oooooo
oooo0<Oooooo001^ooooo`03o`000?oooooooooo04Wooooo00Go0000ooooooooooooooooo`00000=
ooooo`03o`000?oooooooooo0;Sooooo000Booooo`04o`000?ooooooooooo`0000;ooooo0ol00000
1?oooooo0000o`000?l00002ooooo`;o000000Ooooooo`000?l0003oooooo`000?oooooo000000;o
oooo0_l00003ooooo`;o00000oooool4o`0000Gooooo0ol00003ooooo`?o000000Coooooo`000?l0
003o00000oooool3o`0000;ooooo0ol00003ooooo`;o000000Coooooo`000?l0003o00001?ooool0
0ol0003oooooooooo`06ooooo`04o`000?ooooooooooooooo`Co00001_ooool4o`000004ooooool0
003o0000o`0000?ooooo0ol00002ooooo`?o00001oooool7o`0000?ooooo0ol00002ooooo`?o0000
00Goooooo`000?ooooooooooo`000002ooooo`?o000000Goooooo`000?ooooooooooo`000002oooo
o`?o00000oooool00ol0003oooooooooo`04o`0000;ooooo0ol00003ooooo`03o`000?oooooooooo
0;Oooooo000Booooo`03o`000?oooooo000000Cooooo00Go0000ooooooooooooooooo`000004oooo
o`03o`000?oooooo000000;ooooo00Go0000ooooool0003oooooo`000002ooooo`03o`000?oooooo
000000;ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`05ooooo`04o`000?oooooo
ooooooooo`;o00001Oooool2o`000005ooooool0003oooooooooool000000oooool01Ol0003ooooo
oooooooooooo000000Gooooo0_l0000<ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooooooo`;o00000oooool2o`00
00Sooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Go
0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000?ooooo00Co0000oooooooo
oooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0;Oooooo000Booooo`;o
00001Oooool01Ol0003ooooooooooooooooo000000Cooooo0_l00002ooooo`04o`000?oooooo0000
ooooo`;o00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000
ooooooooool01Oooool01_l0003ooooooooooooooooo0000ooooo`;o000000?oooooo`000?l00000
0oooool01?l0003oooooooooool00003ooooo`05o`000?ooooooooooooooool000000oooool2o`00
00gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00;ooooo00Ko0000ooooooooooooooooo`000?ooool2o`000003ooooool0003ooooo00;o000000?o
ooooo`000?l000000_l000001Ooooooo0000oooooooooooo000000;ooooo00?o0000ooooooooool0
0_ooool00ol0003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000oooooooo
ooooooooo`000002ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`2fooooo`004_ooool2o`0000Cooooo0_l00002ooooo`04o`000?oooooo0000o`0000;ooooo00[o
0000ooooool0003oooooo`000?oooooo0000ooooool0003ooooo0_l00003ooooo`;o00000oooool3
o`0000Kooooo00Co0000ooooool0003o00000_ooool2o`0000?ooooo0ol000001Ooooooo0000oooo
oooooooo000000?ooooo00?o0000ooooooooool01?l00002ooooo`?o00000oooool00ol0003ooooo
ooooo`06ooooo`04o`000?ooooooooooooooo`Co00001_ooool4o`000003ooooool0003ooooo00;o
00000_ooool2o`0000?ooooo0_l00008ooooo`?o000000?oooooo`000?ooool00_l000001?oooooo
0000o`000?l00003ooooo`;o00000_ooool3o`0000?ooooo0_l00002ooooo`?o00000oooool3o`00
00Kooooo1?l00003ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0]oooool001;o
oooo00?o0000ooooool000003Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo01[o
oooo00Go0000ooooooooooooooooo`00000Cooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo02Sooooo00?o0000oooo
ooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0;Oooooo000Booooo`04
o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool01Oooool2o`0001Cooooo0_l0000Koooo
o`;o00006?ooool00ol0003oooooooooo`02ooooo`;o00002?ooool2o`0001Oooooo0_l0000=oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool04Oooool2o`0000;ooooo0_l00003oooo
o`03o`000?oooooooooo0;Sooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo0009ooooo`03o`000?oooooooooo0?oooooo
O?ooool000[ooooo00?o0000ooooooooool0oooooomkooooo`000oooool01Ol0003ooooooooooooo
oooo000000;ooooo00?o0000ooooooooool01Oooool01_l0003oooooo`000?oooooo0000ooooo`;o
00000oooool4o`000004ooooool0003o0000o`0000;ooooo0ol00003ooooo`03o`000?oooooooooo
0?ooooooF?ooool000?ooooo00Wo0000ooooooooooooooooo`000?oooooo0000ooooool000001_oo
ool01?l0003oooooo`000?ooool2o`0000;ooooo00?o0000ooooool000000_ooool01?l0003ooooo
o`000?l00005ooooo`03o`000?oooooooooo0?ooooooGOooool000?ooooo00Wo0000oooooooooooo
ooooo`000?oooooo0000ooooool000001_ooool01?l0003oooooo`000?ooool2o`0000;ooooo00?o
0000ooooool000000_ooool01?l0003oooooo`000?ooool2o`0000?ooooo00?o0000ooooooooool0
oooooomMooooo`000oooool01?l0003oooooo`000?ooool3o`000003ooooool0003o000000Gooooo
0_l000001?oooooo0000ooooooooool2o`0000?ooooo0ol00002ooooo`;o00001?ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo0?ooooooF?ooool000?ooooo0_l000000ooooooo0000
o`00000Gooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0oooooomMooooo`000ooo
ool01Ol0003ooooooooooooooooo000001Kooooo0_l00007ooooo`;o0000oooooomOooooo`00oooo
oon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00<?oo
ool2o`0000gooooo0_l0003oooooodOooooo000`ooooo`03o`000?oooooooooo00cooooo00?o0000
ooooooooool0oooooom6ooooo`000oooool4o`0000;ooooo0_l00003ooooo`?o00000oooool01?l0
003oooooooooooooool3o`0000;ooooo00?o0000ooooooooool00_ooool2o`0000Oooooo0ol00002
ooooo`?o00001oooool3o`0000;ooooo0ol00003ooooo`?o00000_ooool3o`0000;ooooo0ol00000
1?oooooo0000o`000?l0003ooooooc;ooooo0004ooooo`05o`000?ooooooooooooooool000000_oo
ool01Ol0003ooooooooooooooooo000000Wooooo00Go0000ooooooooooooooooo`000003ooooo`04
o`000?ooooooooooo`0000Kooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oo
oooooooo00Kooooo0_l000001ooooooo0000oooooooooooo0000ooooool000000_ooool00ol0003o
ooooo`000004ooooo`;o00001?ooool00ol0003oooooooooo`3ooooooc7ooooo0005ooooo`04o`00
0?ooooooooooo`0000;ooooo00Go0000ooooooooooooooooo`000009ooooo`03o`000?oooooooooo
00;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`04ooooo`06o`000?oooooo
ooooo`000?oooooo00000_ooool00ol0003oooooooooo`04ooooo`;o00000oooool01?l0003ooooo
ooooool00002ooooo`05o`000?oooooo0000ooooool000000_ooool01?l0003oooooo`000?ooool2
o`0000;ooooo00?o0000ooooooooool0oooooolaooooo`001_ooool00ol0003oooooo`000002oooo
o`05o`000?ooooooooooooooool000002Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo00?o00001oooool3o`0000;ooooo0ol00008ooooo`?o000000Coooooo`000?l0003o00000_oo
ool3o`0000?ooooo0ol00002ooooo`;o00000_ooool01?l0003oooooo`000?l0003ooooooc7ooooo
0003ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool01Ol0003ooooooooooooooooo0000
00Wooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00008ooooo`03o`000?oo
oooooooo0?ooooooF_ooool000Cooooo0_l00003ooooo`;o00000oooool2o`0000Sooooo0_l00002
ooooo`Co00000oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo0?ooooooF_ooool0
0?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
0?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool003Gooooo0ol0001=ooooo`?o0000oooo
ool003Oooooo0_l0001>ooooo`;o0000o_ooool003Gooooo0_l0001>ooooo`;o0000ooooool1oooo
o`00=_ooool3o`0004gooooo0ol0003nooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8
ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00G_ooool0
0ol0003oooooooooo`3oooooobOooooo000Dooooo`03o`000?oooooooooo04Sooooo00?o0000oooo
ooooool0C?ooool00ol0003oooooooooo`3Fooooo`004oooool00ol0003oooooooooo`19ooooo`03
o`000?oooooooooo04gooooo00?o0000ooooooooool0eOooool001?ooooo00?o0000ooooooooool0
VOooool00ol0003oooooooooo`3Eooooo`004_ooool00ol0003oooooooooo`02ooooo`Co000000?o
ooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?o
ooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?o
ooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?o
ooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?o
ooooo`000?l000000_l0000;ooooo`Co000000?oooooo`000?l000000_l000000ooooooo0000o`00
0002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`00
0002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`00
0002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`00
0002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l00004ooooo`03o`000?oo
oooooooo0=Cooooo000Cooooo`03o`000?oooooooooo09Wooooo00?o0000ooooooooool0eOooool0
01?ooooo00?o0000ooooooooool0VOooool00ol0003oooooooooo`3Eooooo`005?ooool00ol0003o
ooooooooo`2Gooooo`03o`000?oooooooooo0=Kooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo001Iooooo`;o0000C_oo
ool2o`000=cooooo001Kooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0fOooool0
01[ooooo00Go0000ooooooooooooooooo`000002ooooo`Co00000_ooool2o`0000?ooooo0_l00003
ooooo`;o00000oooool00ol0003oooooooooo`07ooooo`?o00000_ooool2o`0001;ooooo0ol0000<
ooooo`?o00000oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;o00000oooool2
o`0000?ooooo00?o0000ooooooooool00_ooool2o`0000Sooooo0ol00002ooooo`;o00004_ooool3
o`000=_ooooo000Jooooo`03o`000?oooooooooo00Gooooo00Go0000ooooooooooooooooo`000002
ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool000000_ooool01?l0003oooooooooool0
000:ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0003ooooo
ooooool0000=ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooool000000_ooool00ol0003o
ooooo`000002ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool00008
ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0003ooooooooo
ool0003Kooooo`005oooool4o`0000Sooooo00?o0000ooooooooool00oooool00ol0003oooooo`00
0002ooooo`03o`000?oooooo000000;ooooo00Go0000ooooooooooooooooo`000009ooooo`04o`00
0?ooooooooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0003oooooooooool0000=oooo
o`03o`000?oooooooooo00Gooooo1?l00004ooooo`03o`000?oooooo000000;ooooo00?o0000oooo
ooooool00ol00004ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo00000_ooool0
0ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`000=_ooooo000Hooooo`03o`000?oooooo
000000Wooooo00?o0000ooooool000000_l00003ooooo`;o00000_ooool01?l0003oooooooooool0
0003ooooo`03o`000?oooooooooo00Oooooo00Co0000oooooooooooo00000_ooool00ol0003ooooo
ooooo`0?ooooo`?o00003Oooool00ol0003oooooooooo`06ooooo`04o`000?oooooo0000ooooo`?o
00000_ooool3o`0000;ooooo00Go0000oooooooooooo0000ooooo`03o`0000Wooooo00Co0000oooo
oooooooo00000_ooool00ol0003oooooooooo`0?ooooo`?o0000foooool001Wooooo0_l00006oooo
o`06o`000?ooooooooooo`000?oooooo00001?ooool01_l0003oooooooooool0003oooooo`0000;o
oooo00?o0000ooooool000000_ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`00
00;ooooo00?o0000ooooooooool07oooool00ol0003oooooooooo`07ooooo`;o000000?oooooo`00
0?ooool01?ooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooool000002oooool0
1?l0003oooooooooool00002ooooo`03o`000?oooooooooo0>gooooo000Jooooo`03o`000?oooooo
oooo00Gooooo0_l00002ooooo`Co00000_ooool2o`0000?ooooo0_l00002ooooo`Co00001oooool2
o`0000?ooooo0_l0000Qooooo`;o00002_ooool00ol0003oooooo`000003o`0000?ooooo00Co0000
oooooooooooooooo0_l00002ooooo`Co00001oooool2o`0000?ooooo0_l0003`ooooo`00oooooon8
ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8
ooooo`00oooooon8ooooo`00Coooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0>Go
oooo001?ooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0iOooool004Wooooo1?l0
0003ooooo`03o`000?oooooooooo04Kooooo1?l00003ooooo`03o`000?oooooooooo0>Cooooo001@
ooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0i?ooool004kooooo00Co0000oooo
oooooooo0000C?ooool01?l0003oooooooooool0003Uooooo`00C_ooool4o`0004cooooo1?l0003U
ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8
ooooo`00oooooon8ooooo`00^?ooool2o`0000?ooooo00?o0000ooooooooool0aoooool006kooooo
00?o0000ooooooooool0BOooool01Ol0003ooooooooooooooooo000000gooooo00?o0000oooooooo
ool0^?ooool001;ooooo00Co0000oooooooooooo00000_ooool3o`000004ooooool0003o0000o`00
00;ooooo0_l000001ooooooo0000o`000?oooooo0000ooooool000000_ooool2o`0000?ooooo0_l0
0003ooooo`Co00001Oooool3o`0000?ooooo0ol000001?oooooo0000o`000?l00003ooooo`?o0000
0_ooool3o`0000?ooooo0_l000001?oooooo0000o`000?l00004ooooo`03o`000?oooooooooo00Ko
oooo00Co0000oooooooooooooooo1?l00006ooooo`Co000000Coooooo`000?l0003o00000oooool3
o`0000;ooooo0ol00007ooooo`Oo00000oooool3o`0000;ooooo0ol000001Ooooooo0000oooooooo
oooo000000;ooooo0ol000001Ooooooo0000oooooooooooo000000;ooooo0ol00003ooooo`03o`00
0?oooooooooo00Co00000_ooool3o`0000?ooooo00?o0000ooooooooool0]oooool001;ooooo00?o
0000ooooool000001?ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooool00000
0_ooool01Ol0003oooooo`000?oooooo000000;ooooo00?o0000ooooool000000_ooool00ol0003o
ooooo`000002ooooo`03o`000?oooooooooo00Gooooo00Co0000oooooooooooooooo0_l00005oooo
o`;o000000Goooooo`000?ooooooooooo`000003ooooo`05o`000?ooooooooooooooool000001Ooo
ool2o`0000cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00;ooooo00Co0000oooooooooooooooo0_l00003ooooo`;o00002?ooool01?l0003ooooo
ooooool00002ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooooooooooo
000000;ooooo00Co0000oooooooooooo00000oooool01?l0003oooooooooool00002ooooo`03o`00
0?oooooo000000;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool0]oooool001;ooooo0_l00005ooooo`05o`000?oo
ooooooooooooool000001?ooool2o`0000;ooooo00Co0000ooooool0003ooooo0_l00002ooooo`03
o`000?oooooo000000;ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`05ooooo`06
o`000?ooooooooooooooool0003ooooo0_l000000ooooooo0000o`000003ooooo`04o`000?oooooo
ooooo`0000?ooooo00Go0000ooooooooooooooooo`000003ooooo`;o00003Oooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00_ooool01_l0003ooooo
oooooooooooo0000ooooo`;o000000?oooooo`000?ooool00_l000000ooooooo0000o`000002o`00
0005ooooool0003oooooooooool000000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
000000?ooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo000000;ooooo
00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool00oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo0;Kooooo000Booooo`;o
00001?ooool2o`0000;ooooo00Co0000ooooool0003o00000_ooool02_l0003oooooo`000?oooooo
0000ooooool0003oooooo`000?ooool2o`0000?ooooo0_l00003ooooo`?o00001_ooool01?l0003o
ooooo`000?l00002ooooo`;o00000oooool3o`000005ooooool0003oooooooooool000000oooool0
0ol0003oooooooooo`04o`0000;ooooo0ol00003ooooo`03o`000?oooooooooo00Kooooo00Co0000
oooooooooooooooo1?l00006ooooo`Co000000?oooooo`000?ooool00_l00002ooooo`;o00000ooo
ool2o`0000Sooooo0ol000000ooooooo0000ooooo`02o`000004ooooool0003o0000o`0000?ooooo
0_l00002ooooo`?o00000oooool2o`0000;ooooo0ol00003ooooo`?o00001_ooool4o`0000?ooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`2gooooo`004_ooool00ol0003oooooo`00
000=ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool06_ooool01Ol0003ooooooooo
oooooooo000001?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo01Sooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool0]oooool001;ooooo00Co0000oooooooooooo0000
0oooool00ol0003oooooooooo`05ooooo`;o00005?ooool2o`0001_ooooo0_l0000Hooooo`03o`00
0?oooooooooo00;ooooo0_l00008ooooo`;o00005oooool2o`0000gooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`0Aooooo`;o00000_ooool2o`0000?ooooo00?o0000ooooooooool0
^?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?oooooo
R?ooool00?ooooooR?ooool00?ooooooR?ooool000?ooooo00Co0000oooooooooooo00000_ooool3
o`000004ooooool0003o0000o`0000;ooooo0_l000000ooooooo0000o`000005ooooo`?o00001ooo
ool01_l0003oooooo`000?oooooo0000ooooo`;o00000oooool4o`000004ooooool0003o0000o`00
00;ooooo0ol00003ooooo`03o`000?oooooooooo0?ooooooA?ooool000?ooooo00?o0000ooooool0
00001?ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooool000002?ooool2o`00
00Kooooo00Co0000ooooool0003ooooo0_l00002ooooo`03o`000?oooooo000000;ooooo00Co0000
ooooool0003o00001Oooool00ol0003oooooooooo`3oooooodWooooo0003ooooo`;o00001Oooool0
1Ol0003ooooooooooooooooo000000Cooooo0_l00007ooooo`;o00002?ooool01?l0003oooooo`00
0?ooool2o`0000;ooooo00?o0000ooooool000000_ooool01?l0003oooooo`000?ooool2o`0000?o
oooo00?o0000ooooooooool0oooooom9ooooo`000oooool2o`0000Cooooo0_l00002ooooo`04o`00
0?oooooo0000o`0000;ooooo00?o0000ooooool000001oooool3o`0000Kooooo0_l000001?oooooo
0000ooooooooool2o`0000?ooooo0ol00002ooooo`;o00001?ooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo0?ooooooA?ooool000?ooooo00?o0000ooooool000003Oooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool01_ooool00ol0003o
ooooooooo`3oooooodWooooo0003ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000oooooooo
ool01Oooool2o`0000Cooooo00?o0000ooooooooool05oooool2o`0000Oooooo0_l0003ooooood_o
oooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSo
oooo003oooooohSooooo003oooooohSooooo003oooooohSooooo000eooooo`?o0000COooool3o`00
0?oooooo000gooooo`;o0000C_ooool2o`000?kooooo000eooooo`;o0000C_ooool2o`000?oooooo
0Oooool003Kooooo0ol0001=ooooo`?o0000o_ooool00?ooooooR?ooool00?ooooooR?ooool00?oo
ooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool005ko
oooo00?o0000ooooooooool0oooooolWooooo`005?ooool00ol0003oooooooooo`18ooooo`03o`00
0?oooooooooo04cooooo00?o0000ooooooooool0e_ooool001?ooooo00?o0000ooooooooool0BOoo
ool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0=Gooooo000Cooooo`03o`000?oooooo
oooo09Wooooo00?o0000ooooooooool0eOooool001;ooooo00?o0000ooooooooool00_ooool4o`00
0003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`00
0003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`00
0003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`00
0003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`00
0003ooooool0003o000000;o00002oooool4o`000003ooooool0003o000000;o000000?oooooo`00
0?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`00
0?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`00
0?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`00
0?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o00001?ooool00ol0
003oooooooooo`3Dooooo`004oooool00ol0003oooooooooo`2Iooooo`03o`000?oooooooooo0=Go
oooo000Cooooo`03o`000?oooooooooo09Wooooo00?o0000ooooooooool0eOooool001Cooooo00?o
0000ooooooooool0Uoooool00ol0003oooooooooo`3Fooooo`00oooooon8ooooo`00oooooon8oooo
o`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00FOooool2o`00
04kooooo0_l0003Looooo`00Foooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0=Wo
oooo000Gooooo`Co00000oooool01?l0003oooooooooooooool2o`0000?ooooo0ol00002ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool00_l00008ooooo`?o00000_ooool2o`0001;o
oooo0ol0000;ooooo`Co00000oooool01?l0003oooooooooooooool3o`0000;ooooo00?o0000oooo
ooooool00_ooool3o`0000;ooooo0_l00003ooooo`03o`000?oooooooooo00Oooooo0ol00002oooo
o`;o00004_ooool3o`000=_ooooo000Hooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooo
oooo00000oooool01Ol0003ooooooooooooooooo000000Kooooo00?o0000ooooool000000_ooool0
0ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool03_oo
ool01?l0003oooooooooool0000<ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooo
oooo00002_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00kooooo00Co0000
oooooooooooo0000foooool001Wooooo00?o0000ooooooooool01Oooool01?l0003oooooooooool0
0003ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01?l00004ooooo`03o`000?oo
oooooooo00Kooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`00
0?ooooooooooo`0000gooooo00?o0000ooooooooool01oooool01?l0003oooooooooooooool3o`00
00?ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000000Wooooo00Co0000
oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`000=_ooooo
000Jooooo`03o`000?oooooooooo00Cooooo0ol00004ooooo`03o`000?oooooooooo00;ooooo00Oo
0000ooooooooooooooooo`000?oooooo000000?ooooo00?o0000ooooooooool01oooool01?l0003o
ooooooooool00002ooooo`03o`000?oooooooooo00oooooo0ol0000>ooooo`03o`000?oooooooooo
00Kooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo000000;ooooo0ol0
0004ooooo`03o`000?oooooooooo00Oooooo00Co0000oooooooooooo00000_ooool00ol0003ooooo
ooooo`0?ooooo`?o0000foooool001Oooooo00Co0000oooooooooooo00001oooool00ol0003ooooo
ooooo`03ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooooooo0_l000001Ooo
oooo0000oooooooooooo000000Sooooo00Co0000oooooooooooo00000_ooool00ol0003ooooooooo
o`0Mooooo`04o`000?ooooooooooo`0000Sooooo00Co0000oooooooooooo00000_ooool01Ol0003o
oooooooooooooooo000000;ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00008
ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0kOooool001Sooooo0_l00009
ooooo`04o`000?ooooooooooooooo`;o00000_ooool4o`0000Cooooo00?o0000ooooooooool00_l0
0008ooooo`;o00000oooool2o`00027ooooo0_l00008ooooo`;o00000oooool2o`0000?ooooo0_l0
0002ooooo`Co000000?oooooo`000?l000000_l00007ooooo`;o00000oooool2o`000?3ooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo001?ooooo`03o`000?oooooooooo04gooooo00?o0000oooooooo
ool0iOooool004oooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`3Uooooo`00BOoo
ool4o`0000?ooooo00?o0000ooooooooool0A_ooool4o`0000?ooooo00?o0000ooooooooool0i?oo
ool0053ooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`3Tooooo`00C_ooool01?l0
003oooooooooool0001<ooooo`04o`000?ooooooooooo`000>Gooooo001>ooooo`Co0000C?ooool4
o`000>Gooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo002hooooo`;o00000oooool00ol0003oooooooooo`37ooooo`00
K_ooool00ol0003oooooooooo`19ooooo`05o`000?ooooooooooooooool000003Oooool00ol0003o
ooooooooo`2hooooo`004_ooool01?l0003oooooooooool00002ooooo`?o000000Coooooo`000?l0
003o00000_ooool2o`000007ooooool0003o0000ooooool0003oooooo`000002ooooo`;o00000ooo
ool2o`0000?ooooo1?l00005ooooo`?o00000oooool3o`000004ooooool0003o0000o`0000?ooooo
0ol00002ooooo`?o00000oooool2o`000004ooooool0003o0000o`0000Cooooo00?o0000oooooooo
ool01_ooool01?l0003oooooooooooooool4o`0000Kooooo1?l000001?oooooo0000o`000?l00003
ooooo`?o00000_ooool3o`0000Oooooo1ol00003ooooo`?o00000_ooool3o`000005ooooool0003o
ooooooooool000000_ooool3o`000005ooooool0003oooooooooool000000_ooool3o`0000?ooooo
00?o0000ooooooooool01?l00002ooooo`?o00000oooool00ol0003oooooooooo`2gooooo`004_oo
ool00ol0003oooooo`000004ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003ooooo
o`000002ooooo`05o`000?oooooo0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03
o`000?oooooo000000;ooooo00?o0000ooooooooool01Oooool01?l0003oooooooooooooool2o`00
00Gooooo0_l000001Ooooooo0000oooooooooooo000000?ooooo00Go0000ooooooooooooooooo`00
0005ooooo`;o00003?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool00_ooool01?l0003oooooooooooooool2o`0000?ooooo0_l00008ooooo`04o`00
0?ooooooooooo`0000;ooooo00Go0000ooooooooooooooooo`000002ooooo`05o`000?oooooooooo
ooooool000000_ooool01?l0003oooooooooool00003ooooo`04o`000?ooooooooooo`0000;ooooo
00?o0000ooooool000000_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`2gooooo`004_ooool2o`0000Gooooo00Go
0000ooooooooooooooooo`000004ooooo`;o00000_ooool01?l0003oooooo`000?ooool2o`0000;o
oooo00?o0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Go
oooo00Ko0000ooooooooooooooooo`000?ooool2o`000003ooooool0003o000000?ooooo00Co0000
oooooooooooo00000oooool01Ol0003ooooooooooooooooo000000?ooooo0_l0000=ooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`02ooooo`06o`00
0?ooooooooooooooool0003ooooo0_l000000ooooooo0000ooooo`02o`000003ooooool0003o0000
00;o000000Goooooo`000?ooooooooooo`000002ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooool000000oooool01?l0003oooooooooool00002ooooo`05o`000?ooooooooooooooool00000
0_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0]_ooool001;o
oooo0_l00004ooooo`;o00000_ooool01?l0003oooooo`000?l00002ooooo`0:o`000?oooooo0000
ooooool0003oooooo`000?oooooo0000ooooo`;o00000oooool2o`0000?ooooo0ol00006ooooo`04
o`000?oooooo0000o`0000;ooooo0_l00003ooooo`?o000000Goooooo`000?ooooooooooo`000003
ooooo`03o`000?oooooooooo00Co00000_ooool3o`0000?ooooo00?o0000ooooooooool01_ooool0
1?l0003oooooooooooooool4o`0000Kooooo1?l000000ooooooo0000ooooo`02o`0000;ooooo0_l0
0003ooooo`;o00002?ooool3o`000003ooooool0003ooooo00;o000000Coooooo`000?l0003o0000
0oooool2o`0000;ooooo0ol00003ooooo`;o00000_ooool3o`0000?ooooo0ol00006ooooo`Co0000
0oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0;Oooooo000Booooo`03o`000?oo
oooo000000gooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0Jooooo`05o`000?oo
ooooooooooooool000004oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Oooooo
00?o0000ooooooooool06?ooool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`2gooooo`004_ooool01?l0003ooooooooo
ool00003ooooo`03o`000?oooooooooo00Gooooo0_l0000Dooooo`;o00006oooool2o`0001Sooooo
00?o0000ooooooooool00_ooool2o`0000Sooooo0_l0000Gooooo`;o00003Oooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo017ooooo0_l00002ooooo`;o00000oooool00ol0003ooooo
ooooo`2hooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`002Oooool00ol0003oooooooooo`3oooooogcooooo000:ooooo`03o`000?oooooo
oooo0?ooooooNoooool000?ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo
oooo00Gooooo00Ko0000ooooool0003oooooo`000?ooool2o`0000?ooooo1?l000001?oooooo0000
o`000?l00002ooooo`?o00000oooool00ol0003oooooooooo`3ooooooeSooooo0003ooooo`09o`00
0?ooooooooooooooool0003oooooo`000?oooooo000000Kooooo00Co0000ooooool0003ooooo0_l0
0002ooooo`03o`000?oooooo000000;ooooo00Co0000ooooool0003o00001Oooool00ol0003ooooo
ooooo`3ooooooegooooo0003ooooo`09o`000?ooooooooooooooool0003oooooo`000?oooooo0000
00Kooooo00Co0000ooooool0003ooooo0_l00002ooooo`03o`000?oooooo000000;ooooo00Co0000
ooooool0003ooooo0_l00003ooooo`03o`000?oooooooooo0?ooooooGOooool000?ooooo00Co0000
ooooool0003ooooo0ol000000ooooooo0000o`000005ooooo`;o000000Coooooo`000?oooooooooo
0_l00003ooooo`?o00000_ooool2o`0000Cooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`3ooooooeSooooo0003ooooo`;o000000?oooooo`000?l000005oooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo0?ooooooGOooool000?ooooo00Go0000ooooooooooooooooo`00
000Fooooo`;o00001oooool2o`000?ooooooGoooool00?ooooooR?ooool00?ooooooR?ooool00?oo
ooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0033ooooo0_l0000=oooo
o`;o0000oooooom7ooooo`00<?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo0?oo
ooooA_ooool000Cooooo0ol00002ooooo`;o00000oooool00ol0003oooooooooo`03ooooo`04o`00
0?ooooooooooooooo`;o00001Oooool01?l0003oooooooooool00008ooooo`?o00000_ooool3o`00
00Oooooo0ol00002ooooo`?o00000oooool3o`0000;ooooo0ol00002ooooo`?o000000Coooooo`00
0?l0003o0000oooooolbooooo`001Oooool01?l0003oooooooooool00002ooooo`04o`000?oooooo
ooooo`0000Sooooo00Co0000oooooooooooo00001?ooool01?l0003oooooooooool00008ooooo`06
o`000?ooooooooooo`000?oooooo00000_ooool00ol0003oooooooooo`06ooooo`;o000000Oooooo
o`000?ooooooooooo`000?oooooo000000;ooooo00?o0000ooooool000001?ooool2o`0000Cooooo
00?o0000ooooooooool0oooooolaooooo`001Oooool01?l0003oooooooooool00002ooooo`05o`00
0?ooooooooooooooool000001oooool01Ol0003oooooooooool0003ooooo00Co00000oooool00ol0
003oooooooooo`05ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003ooooooooo
o`04ooooo`;o00000oooool01?l0003oooooooooool00002ooooo`05o`000?oooooo0000ooooool0
00000_ooool01?l0003oooooo`000?ooool2o`0000;ooooo00?o0000ooooooooool0oooooolaoooo
o`001Oooool00ol0003oooooooooo`03o`0000Cooooo00?o0000ooooooooool01Oooool3o`0000?o
oooo00?o0000ooooool000000oooool00ol0003oooooooooo`05ooooo`?o00000_ooool3o`0000So
oooo0ol000001?oooooo0000o`000?l00002ooooo`?o00000oooool3o`0000;ooooo0_l00002oooo
o`04o`000?oooooo0000o`000?oooooo<Oooool000Gooooo00Go0000ooooooooooooooooo`000003
ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000ooooooooool00oooool2o`000005ooooool0
003oooooooooool000001_ooool00ol0003oooooooooo`3ooooooe[ooooo0004ooooo`;o00001?oo
ool00ol0003oooooooooo`04o`0000Sooooo00?o0000ooooooooool00oooool00ol0003oooooo`00
0003o`0000Kooooo00?o0000ooooooooool0oooooomJooooo`00oooooon8ooooo`00oooooon8oooo
o`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8oooo
o`00=Oooool3o`0004gooooo0ol0003oooooo`00=oooool2o`0004kooooo0_l0003nooooo`00=Ooo
ool2o`0004kooooo0_l0003oooooo`7ooooo000fooooo`?o0000COooool3o`000?kooooo003ooooo
ohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003ooooo
ohSooooo003oooooohSooooo003oooooohSooooo001Nooooo`03o`000?oooooooooo0?oooooo9ooo
ool001Cooooo00?o0000ooooooooool0B?ooool00ol0003oooooooooo`1<ooooo`03o`000?oooooo
oooo0=Kooooo000Cooooo`03o`000?oooooooooo04Wooooo00?o0000ooooooooool0COooool00ol0
003oooooooooo`3Eooooo`004oooool00ol0003oooooooooo`2Iooooo`03o`000?oooooooooo0=Go
oooo000Booooo`03o`000?oooooooooo00;ooooo1?l000000ooooooo0000o`000002o`000003oooo
ool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003oooo
ool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003oooo
ool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003oooo
ool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`0000_ooooo
1?l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l00000
0_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l00000
0_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l00000
0_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l00000
0_l000000ooooooo0000o`000002o`0000Cooooo00?o0000ooooooooool0e?ooool001?ooooo00?o
0000ooooooooool0VOooool00ol0003oooooooooo`3Eooooo`004oooool00ol0003oooooooooo`2I
ooooo`03o`000?oooooooooo0=Gooooo000Dooooo`03o`000?oooooooooo09Oooooo00?o0000oooo
ooooool0e_ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
0?ooooooR?ooool005Wooooo0_l0001>ooooo`;o0000g?ooool005_ooooo00?o0000ooooooooool0
COooool00ol0003oooooooooo`3Iooooo`006?ooool2o`0000Cooooo00Co0000oooooooooooooooo
0_l00002ooooo`Co00001?ooool01?l0003oooooooooool00004ooooo`;o00002?ooool3o`0000;o
oooo0_l0000Booooo`?o00003?ooool3o`0000?ooooo00Co0000oooooooooooooooo0_l00003oooo
o`;o00000oooool2o`0000?ooooo00?o0000ooooooooool00_ooool2o`0000Sooooo0ol00002oooo
o`;o00004_ooool3o`000=_ooooo000Gooooo`04o`000?ooooooooooo`0000Kooooo00Co0000oooo
oooooooo00000_ooool00ol0003oooooooooo`04ooooo`04o`000?ooooooooooo`0000?ooooo00Co
0000oooooooooooo00002?ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00ko
oooo00Co0000oooooooooooo00003Oooool00ol0003oooooooooo`05ooooo`06o`000?oooooooooo
o`000?oooooo00000_ooool00ol0003oooooo`000002ooooo`04o`000?ooooooooooo`0000?ooooo
00Co0000oooooooooooo00002?ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo
00kooooo00Co0000oooooooooooo0000foooool001[ooooo00?o0000ooooooooool01?ooool01?l0
003oooooooooool00003ooooo`03o`000?oooooooooo00Co00000oooool01?l0003oooooooooool0
0002ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo00000_ooool00ol0003ooooo
ooooo`0>ooooo`04o`000?ooooooooooo`0000gooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`000002oooo
o`04o`000?ooooooooooo`0000Sooooo00Co0000oooooooooooo00000_ooool00ol0003ooooooooo
o`0>ooooo`04o`000?ooooooooooo`000=_ooooo000Iooooo`03o`000?oooooooooo00Gooooo0ol0
0005ooooo`06o`000?ooooooooooo`000?oooooo00000oooool01?l0003oooooooooooooool2o`00
00Wooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0?ooooo`?o00003Oooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`02ooooo`04o`000?ooooooooooooooo`;o00002Oooool01?l0003ooooooooo
ool00002ooooo`03o`000?oooooooooo00oooooo0ol0003Kooooo`005oooool01?l0003ooooooooo
ool00007ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooooooool2o`00
0007ooooool0003oooooooooool0003oooooo`000002ooooo`03o`000?oooooooooo00Kooooo00Co
0000oooooooooooo00000_ooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00Gooooo
00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooo000000;ooooo00?o0000oooo
ool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Kooooo00Co0000oooo
oooooooo00000_ooool00ol0003oooooooooo`3]ooooo`006?ooool2o`0000Wooooo00Co0000oooo
oooooooooooo0_l00005ooooo`03o`000?oooooo000000?o00000_ooool2o`0000Sooooo0_l00003
ooooo`;o00008Oooool2o`0000Sooooo0_l00003ooooo`;o00000oooool2o`0000;ooooo1?l00002
ooooo`;o00002?ooool2o`0000?ooooo0_l0003`ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00Coooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0>Gooooo001?
ooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0iOooool004Wooooo1?l00003oooo
o`03o`000?oooooooooo04Kooooo1?l00003ooooo`03o`000?oooooooooo0>Cooooo001@ooooo`03
o`000?oooooooooo04gooooo00?o0000ooooooooool0i?ooool004kooooo00Co0000oooooooooooo
0000C?ooool01?l0003oooooooooool0003Uooooo`00C_ooool4o`0004cooooo1?l0003Uooooo`00
oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
^?ooool2o`0000?ooooo00?o0000ooooooooool0aoooool006kooooo00?o0000ooooooooool0BOoo
ool01Ol0003ooooooooooooooooo000000gooooo00?o0000ooooooooool0^?ooool001;ooooo00Co
0000oooooooooooo00000_ooool3o`000004ooooool0003o0000o`0000;ooooo0_l000001ooooooo
0000o`000?oooooo0000ooooool000000_ooool2o`0000?ooooo0_l00003ooooo`Co00001Oooool3
o`0000?ooooo0ol000001?oooooo0000o`000?l00003ooooo`?o00000_ooool3o`0000?ooooo0_l0
00001?oooooo0000o`000?l00004ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo
oooo1?l00006ooooo`Co000000Coooooo`000?l0003o00000oooool3o`0000;ooooo0ol00007oooo
o`Oo00000oooool3o`0000;ooooo0ol000001Ooooooo0000oooooooooooo000000;ooooo0ol00000
1Ooooooo0000oooooooooooo000000;ooooo0ol00003ooooo`03o`000?oooooooooo00Co00000_oo
ool3o`0000?ooooo00?o0000ooooooooool0]oooool001;ooooo00?o0000ooooool000001?ooool0
1Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooool000000_ooool01Ol0003oooooo`00
0?oooooo000000;ooooo00?o0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`00
0?oooooooooo00Gooooo00Co0000oooooooooooooooo0_l00005ooooo`;o000000Goooooo`000?oo
ooooooooo`000003ooooo`05o`000?ooooooooooooooool000001Oooool2o`0000cooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00;ooooo00Co0000
oooooooooooooooo0_l00003ooooo`;o00002?ooool01?l0003oooooooooool00002ooooo`05o`00
0?ooooooooooooooool000000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooo
oooooooo00000oooool01?l0003oooooooooool00002ooooo`03o`000?oooooo000000;ooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool0]oooool001;ooooo0_l00005ooooo`05o`000?ooooooooooooooool000001?oo
ool2o`0000;ooooo00Co0000ooooool0003ooooo0_l00002ooooo`03o`000?oooooo000000;ooooo
00?o0000ooooool000000_ooool00ol0003oooooooooo`05ooooo`06o`000?ooooooooooooooool0
003ooooo0_l000000ooooooo0000o`000003ooooo`04o`000?ooooooooooo`0000?ooooo00Go0000
ooooooooooooooooo`000003ooooo`;o00003Oooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool00_ooool01_l0003ooooooooooooooooo0000ooooo`;o
000000?oooooo`000?ooool00_l000000ooooooo0000o`000002o`000005ooooool0003ooooooooo
ool000000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo000000?ooooo00Co0000oooo
oooooooo00000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Ko0000oooooooooooo0000
ooooool00002ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo0;Kooooo000Booooo`;o00001?ooool2o`0000;ooooo
00Co0000ooooool0003o00000_ooool02_l0003oooooo`000?oooooo0000ooooool0003oooooo`00
0?ooool2o`0000?ooooo0_l00003ooooo`?o00001_ooool01?l0003oooooo`000?l00002ooooo`;o
00000oooool3o`000005ooooool0003oooooooooool000000oooool00ol0003oooooooooo`04o`00
00;ooooo0ol00003ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooooooo1?l00006
ooooo`Co000000?oooooo`000?ooool00_l00002ooooo`;o00000oooool2o`0000Sooooo0ol00000
0ooooooo0000ooooo`02o`000004ooooool0003o0000o`0000?ooooo0_l00002ooooo`?o00000ooo
ool2o`0000;ooooo0ol00003ooooo`?o00001_ooool4o`0000?ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`2gooooo`004_ooool00ol0003oooooo`00000=ooooo`03o`000?oooooo
oooo01?ooooo00?o0000ooooooooool06_ooool01Ol0003ooooooooooooooooo000001?ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo01Sooooo00?o
0000ooooooooool0:?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool0]oooool001;ooooo00Co0000oooooooooooo00000oooool00ol0003ooooooooo
o`05ooooo`;o00005?ooool2o`0001_ooooo0_l0000Hooooo`03o`000?oooooooooo00;ooooo0_l0
0008ooooo`;o00005oooool2o`0000gooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`0Aooooo`;o00000_ooool2o`0000?ooooo00?o0000ooooooooool0^?ooool00?ooooooR?ooool0
0?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
0?ooooooR?ooool00?ooooooR?ooool000?ooooo00Co0000oooooooooooo00000_ooool3o`000004
ooooool0003o0000o`0000;ooooo0_l000000ooooooo0000o`000005ooooo`?o00001oooool01_l0
003oooooo`000?oooooo0000ooooo`;o00000oooool4o`000004ooooool0003o0000o`0000;ooooo
0ol00003ooooo`03o`000?oooooooooo0?ooooooA?ooool000?ooooo00?o0000ooooool000001?oo
ool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooool000002?ooool2o`0000Kooooo
00Co0000ooooool0003ooooo0_l00002ooooo`03o`000?oooooo000000;ooooo00Co0000ooooool0
003o00001Oooool00ol0003oooooooooo`3oooooodWooooo0003ooooo`;o00001Oooool01Ol0003o
oooooooooooooooo000000Cooooo0_l00007ooooo`;o00002?ooool01?l0003oooooo`000?ooool2
o`0000;ooooo00?o0000ooooool000000_ooool01?l0003oooooo`000?ooool2o`0000?ooooo00?o
0000ooooooooool0oooooom9ooooo`000oooool2o`0000Cooooo0_l00002ooooo`04o`000?oooooo
0000o`0000;ooooo00?o0000ooooool000001oooool3o`0000Kooooo0_l000001?oooooo0000oooo
ooooool2o`0000?ooooo0ol00002ooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo0?ooooooA?ooool000?ooooo00?o0000ooooool000003Oooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`3oooooodWooooo0003ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool01Ooo
ool2o`0000Cooooo00?o0000ooooooooool05oooool2o`0000Oooooo0_l0003ooooood_ooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo000eooooo`?o0000COooool3o`000?oooooo000gooooo`;o0000
C_ooool2o`000?kooooo000eooooo`;o0000C_ooool2o`000?oooooo0Oooool003Kooooo0ol0001=
ooooo`?o0000o_ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?oo
ool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool005kooooo00?o
0000ooooooooool0oooooolWooooo`005?ooool00ol0003oooooooooo`18ooooo`03o`000?oooooo
oooo04cooooo00?o0000ooooooooool0e_ooool001?ooooo00?o0000ooooooooool0BOooool00ol0
003oooooooooo`1=ooooo`03o`000?oooooooooo0=Gooooo000Cooooo`03o`000?oooooooooo09Wo
oooo00?o0000ooooooooool0eOooool001;ooooo00?o0000ooooooooool00_ooool4o`000003oooo
ool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003oooo
ool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003oooo
ool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003oooo
ool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003oooo
ool0003o000000;o00002oooool4o`000003ooooool0003o000000;o000000?oooooo`000?l00000
0_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l00000
0_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l00000
0_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l00000
0_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o00001?ooool00ol0003ooooo
ooooo`3Dooooo`004oooool00ol0003oooooooooo`2Iooooo`03o`000?oooooooooo0=Gooooo000C
ooooo`03o`000?oooooooooo09Wooooo00?o0000ooooooooool0eOooool001Cooooo00?o0000oooo
ooooool0Uoooool00ol0003oooooooooo`3Fooooo`00oooooon8ooooo`00oooooon8ooooo`00oooo
oon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00FOooool2o`0004kooooo0_l0003Looooo`00
Foooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0=Wooooo000Gooooo`Co00000ooo
ool01?l0003oooooooooooooool2o`0000?ooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`02ooooo`;o00000oooool2o`0000Sooooo0ol00002ooooo`;o00004_ooool3o`0000cooooo
0ol00003ooooo`05o`000?ooooooooooooooool000001?ooool2o`0000?ooooo0_l00002ooooo`Co
00000_ooool00ol0003oooooooooo`07ooooo`?o00000_ooool2o`0001;ooooo0ol0003Kooooo`00
6?ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`0000?ooooo00Go0000oooooooo
ooooooooo`000003ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003ooooooooo
o`06ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0003ooooo
ooooool0000=ooooo`03o`000?oooooooooo00Oooooo00Co0000oooooooooooo00000_ooool00ol0
003oooooo`000002ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool01oooool0
1?l0003oooooooooool00002ooooo`03o`000?oooooooooo00kooooo00Co0000oooooooooooo0000
foooool001Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`03o`0000?ooooo00Co
0000oooooooooooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Kooooo
00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`00
00gooooo00?o0000ooooooooool01_ooool3o`000007ooooool0003oooooooooool0003oooooo`00
0002ooooo`05o`000?ooooooooooooooool000000oooool3o`0000Sooooo00Co0000oooooooooooo
00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`000=_ooooo000Jooooo`03
o`000?oooooooooo00Kooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo
000000;ooooo00Go0000oooooooooooo0000ooooo`03o`0000Wooooo00Co0000oooooooooooo0000
0_ooool00ol0003oooooooooo`0?ooooo`?o00003Oooool00ol0003oooooooooo`05ooooo`05o`00
0?ooooooooooo`000?ooool00ol00003ooooo`;o00001Oooool00ol0003oooooo`000002ooooo`03
o`000?oooooooooo00Kooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0?oooo
o`?o0000foooool001Oooooo00Co0000oooooooooooo00001_ooool01_l0003oooooooooool0003o
ooooo`0000;ooooo00?o0000ooooool000000_ooool00ol0003oooooo`000002ooooo`04o`000?oo
ooooooooo`0000[ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0Oooooo`03
o`000?oooooooooo00Gooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo
000000;ooooo00?o0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo
oooo00Kooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`3]ooooo`006?ooool2
o`0000Sooooo0_l00003ooooo`;o00000_ooool4o`0000;ooooo0_l00004ooooo`03o`000?oooooo
oooo00Kooooo0_l00003ooooo`;o00008Oooool2o`0000Sooooo0_l00004ooooo`04o`000?oooooo
ooooooooo`;o00000oooool2o`0000?ooooo0_l00008ooooo`;o00000oooool2o`000?3ooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo001?ooooo`03o`000?oooooooooo04gooooo
00?o0000ooooooooool0iOooool004oooooo00?o0000ooooooooool0COooool00ol0003ooooooooo
o`3Uooooo`00BOooool4o`0000?ooooo00?o0000ooooooooool0A_ooool4o`0000?ooooo00?o0000
ooooooooool0i?ooool0053ooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`3Toooo
o`00C_ooool01?l0003oooooooooool0001<ooooo`04o`000?ooooooooooo`000>Gooooo001>oooo
o`Co0000C?ooool4o`000>Gooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo002hooooo`;o00000oooool00ol0003oooooooooo`37ooooo`00
K_ooool00ol0003oooooooooo`19ooooo`05o`000?ooooooooooooooool000003Oooool00ol0003o
ooooooooo`2hooooo`004_ooool01?l0003oooooooooool00002ooooo`?o000000Coooooo`000?l0
003o00000_ooool2o`000007ooooool0003o0000ooooool0003oooooo`000002ooooo`;o00000ooo
ool2o`0000?ooooo1?l00005ooooo`?o00000oooool3o`000004ooooool0003o0000o`0000?ooooo
0ol00002ooooo`?o00000oooool2o`000004ooooool0003o0000o`0000Cooooo00?o0000oooooooo
ool01_ooool01?l0003oooooooooooooool4o`0000Kooooo1?l000001?oooooo0000o`000?l00003
ooooo`?o00000_ooool3o`0000Oooooo1ol00003ooooo`?o00000_ooool3o`000005ooooool0003o
ooooooooool000000_ooool3o`000005ooooool0003oooooooooool000000_ooool3o`0000?ooooo
00?o0000ooooooooool01?l00002ooooo`?o00000oooool00ol0003oooooooooo`2gooooo`004_oo
ool00ol0003oooooo`000004ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003ooooo
o`000002ooooo`05o`000?oooooo0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03
o`000?oooooo000000;ooooo00?o0000ooooooooool01Oooool01?l0003oooooooooooooool2o`00
00Gooooo0_l000001Ooooooo0000oooooooooooo000000?ooooo00Go0000ooooooooooooooooo`00
0005ooooo`;o00003?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool00_ooool01?l0003oooooooooooooool2o`0000?ooooo0_l00008ooooo`04o`00
0?ooooooooooo`0000;ooooo00Go0000ooooooooooooooooo`000002ooooo`05o`000?oooooooooo
ooooool000000_ooool01?l0003oooooooooool00003ooooo`04o`000?ooooooooooo`0000;ooooo
00?o0000ooooool000000_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`2gooooo`004_ooool2o`0000Gooooo00Go
0000ooooooooooooooooo`000004ooooo`;o00000_ooool01?l0003oooooo`000?ooool2o`0000;o
oooo00?o0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Go
oooo00Ko0000ooooooooooooooooo`000?ooool2o`000003ooooool0003o000000?ooooo00Co0000
oooooooooooo00000oooool01Ol0003ooooooooooooooooo000000?ooooo0_l0000=ooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`02ooooo`06o`00
0?ooooooooooooooool0003ooooo0_l000000ooooooo0000ooooo`02o`000003ooooool0003o0000
00;o000000Goooooo`000?ooooooooooo`000002ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooool000000oooool01?l0003oooooooooool00002ooooo`05o`000?ooooooooooooooool00000
0_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0]_ooool001;o
oooo0_l00004ooooo`;o00000_ooool01?l0003oooooo`000?l00002ooooo`0:o`000?oooooo0000
ooooool0003oooooo`000?oooooo0000ooooo`;o00000oooool2o`0000?ooooo0ol00006ooooo`04
o`000?oooooo0000o`0000;ooooo0_l00003ooooo`?o000000Goooooo`000?ooooooooooo`000003
ooooo`03o`000?oooooooooo00Co00000_ooool3o`0000?ooooo00?o0000ooooooooool01_ooool0
1?l0003oooooooooooooool4o`0000Kooooo1?l000000ooooooo0000ooooo`02o`0000;ooooo0_l0
0003ooooo`;o00002?ooool3o`000003ooooool0003ooooo00;o000000Coooooo`000?l0003o0000
0oooool2o`0000;ooooo0ol00003ooooo`;o00000_ooool3o`0000?ooooo0ol00006ooooo`Co0000
0oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0;Oooooo000Booooo`03o`000?oo
oooo000000gooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0Jooooo`05o`000?oo
ooooooooooooool000004oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Oooooo
00?o0000ooooooooool06?ooool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`2gooooo`004_ooool01?l0003ooooooooo
ool00003ooooo`03o`000?oooooooooo00Gooooo0_l0000Dooooo`;o00006oooool2o`0001Sooooo
00?o0000ooooooooool00_ooool2o`0000Sooooo0_l0000Gooooo`;o00003Oooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo017ooooo0_l00002ooooo`;o00000oooool00ol0003ooooo
ooooo`2hooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00oooooon8ooooo`002Oooool00ol0003oooooooooo`3oooooogcooooo000:oooo
o`03o`000?oooooooooo0?ooooooNoooool000?ooooo00Go0000ooooooooooooooooo`000002oooo
o`03o`000?oooooooooo00Gooooo00Ko0000ooooool0003oooooo`000?ooool2o`0000?ooooo1?l0
00001?oooooo0000o`000?l00002ooooo`?o00000oooool00ol0003oooooooooo`3ooooooeSooooo
0003ooooo`09o`000?ooooooooooooooool0003oooooo`000?oooooo000000Kooooo00Co0000oooo
ool0003ooooo0_l00002ooooo`03o`000?oooooo000000;ooooo00Co0000ooooool0003o00001Ooo
ool00ol0003oooooooooo`3ooooooegooooo0003ooooo`09o`000?ooooooooooooooool0003ooooo
o`000?oooooo000000Kooooo00Co0000ooooool0003ooooo0_l00002ooooo`03o`000?oooooo0000
00;ooooo00Co0000ooooool0003ooooo0_l00003ooooo`03o`000?oooooooooo0?ooooooGOooool0
00?ooooo00Co0000ooooool0003ooooo0ol000000ooooooo0000o`000005ooooo`;o000000Cooooo
o`000?oooooooooo0_l00003ooooo`?o00000_ooool2o`0000Cooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`3ooooooeSooooo0003ooooo`;o000000?oooooo`000?l000005oooool0
0ol0003oooooooooo`06ooooo`03o`000?oooooooooo0?ooooooGOooool000?ooooo00Go0000oooo
ooooooooooooo`00000Fooooo`;o00001oooool2o`000?ooooooGoooool00?ooooooR?ooool00?oo
ooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0033ooooo0_l0000=oooo
o`;o0000oooooom7ooooo`00<?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo0?oo
ooooA_ooool000Cooooo0ol00002ooooo`;o00001Oooool01Ol0003ooooooooooooooooo000000?o
oooo0ol00002ooooo`?o00000_ooool2o`0000Oooooo0ol00002ooooo`?o00001oooool3o`0000;o
oooo0ol00003ooooo`?o00000_ooool3o`0000;ooooo0ol000001?oooooo0000o`000?l0003ooooo
oc;ooooo0005ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool0
0ol0003oooooooooo`04ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003ooooo
ooooo`06ooooo`;o000000Ooooooo`000?ooooooooooo`000?oooooo000000;ooooo00?o0000oooo
ool000001?ooool2o`0000Cooooo00?o0000ooooooooool0oooooolaooooo`001Oooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooo000000?o00002?ooool00ol0003oooooooooo`02ooooo`04
o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool01?ooool01_l0003oooooooooool0003o
ooooo`0000;ooooo00?o0000ooooooooool01?ooool2o`0000?ooooo00Co0000oooooooooooo0000
0_ooool01Ol0003oooooo`000?oooooo000000;ooooo00Co0000ooooool0003ooooo0_l00002oooo
o`03o`000?oooooooooo0?oooooo<Oooool000Gooooo00?o0000ooooooooool00_ooool01ol0003o
oooooooooooooooo0000ooooool000002?ooool00ol0003oooooooooo`02ooooo`04o`000?oooooo
ooooooooo`;o00001oooool3o`0000;ooooo0ol00008ooooo`?o000000Coooooo`000?l0003o0000
0_ooool3o`0000?ooooo0ol00002ooooo`;o00000_ooool01?l0003oooooo`000?l0003ooooooc7o
oooo0005ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooooooo0_l00008oooo
o`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo0?ooooooF_ooool000Cooooo0_l00003ooooo`;o00001Oooool00ol0
003oooooooooo`05ooooo`;o00000oooool2o`0000?ooooo0_l00007ooooo`03o`000?oooooooooo
0?ooooooF_ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
0?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool003Gooooo0ol0001=
ooooo`?o0000ooooool003Oooooo0_l0001>ooooo`;o0000o_ooool003Gooooo0_l0001>ooooo`;o
0000ooooool1ooooo`00=_ooool3o`0004gooooo0ol0003nooooo`00oooooon8ooooo`00oooooon8
ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8
ooooo`00G_ooool00ol0003oooooooooo`3oooooobOooooo000Dooooo`03o`000?oooooooooo04So
oooo00?o0000ooooooooool0C?ooool00ol0003oooooooooo`3Fooooo`004oooool00ol0003ooooo
ooooo`19ooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0eOooool001?ooooo00?o
0000ooooooooool0VOooool00ol0003oooooooooo`3Eooooo`004_ooool00ol0003oooooooooo`02
ooooo`Co000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o
000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o
000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o
000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o
000000;o000000?oooooo`000?l000000_l0000;ooooo`Co000000?oooooo`000?l000000_l00000
0ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l00000
0ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l00000
0ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l00000
0ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l00004
ooooo`03o`000?oooooooooo0=Cooooo000Cooooo`03o`000?oooooooooo09Wooooo00?o0000oooo
ooooool0eOooool001?ooooo00?o0000ooooooooool0VOooool00ol0003oooooooooo`3Eooooo`00
5?ooool00ol0003oooooooooo`2Gooooo`03o`000?oooooooooo0=Kooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo001I
ooooo`;o0000C_ooool2o`000=cooooo001Kooooo`03o`000?oooooooooo04gooooo00?o0000oooo
ooooool0fOooool001Oooooo1?l00003ooooo`05o`000?ooooooooooooooool000001?ooool00ol0
003oooooooooo`02ooooo`?o00001?ooool01?l0003oooooooooool00009ooooo`?o00000_ooool2
o`0001;ooooo0ol0000<ooooo`?o00000oooool00ol0003oooooooooo`04o`0000;ooooo0ol00004
ooooo`03o`000?oooooo000000?o00000_ooool00ol0003oooooooooo`07ooooo`?o00000_ooool2
o`0001;ooooo0ol0003Kooooo`006?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03ooooo`05o`000?oooooooooo
ooooool000002Oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00kooooo00Co
0000oooooooooooo00003Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool00oooool01?l0003oooooooooool00005ooooo`03o`000?oooooooooo00Oo
oooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?oooooooooo
o`000=_ooooo000Iooooo`03o`000?oooooooooo00Kooooo0ol00002ooooo`?o00000oooool00ol0
003oooooooooo`04o`0000;ooooo0ol00008ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000
ooooooooool03_ooool01?l0003oooooooooool0000=ooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`04o`0000?ooooo00Co0000oooooooooooooooo
0ol00008ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0003o
ooooooooool0003Kooooo`006_ooool00ol0003oooooooooo`04ooooo`06o`000?ooooooooooo`00
0?oooooo00000_ooool01Ol0003ooooooooooooooooo000000?ooooo00Go0000ooooool0003ooooo
o`000002ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo00000_ooool00ol0003o
ooooooooo`0?ooooo`?o00003Oooool00ol0003oooooooooo`08ooooo`05o`000?oooooooooooooo
ool000000oooool00ol0003oooooo`000004ooooo`03o`000?oooooo000000;ooooo00?o0000oooo
ooooool01_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00oooooo0ol0003K
ooooo`005oooool01?l0003oooooooooool00006ooooo`06o`000?ooooooooooo`000?oooooo0000
0_ooool01Ol0003ooooooooooooooooo000000Cooooo0_l000001Ooooooo0000oooooooooooo0000
00Sooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0Oooooo`03o`000?oooooo
oooo00Gooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`02ooooo`;o000000Oo
ooooo`000?ooooooooooo`000?oooooo000000;ooooo00?o0000ooooooooool01_ooool01?l0003o
ooooooooool00002ooooo`03o`000?oooooooooo0>gooooo000Hooooo`;o00002?ooool2o`0000?o
oooo0_l00003ooooo`;o00001Oooool00ol0003oooooooooo`02o`0000Sooooo0_l00003ooooo`;o
00008Oooool2o`0000Sooooo0_l00003ooooo`;o00001Oooool00ol0003oooooooooo`02o`0000?o
oooo0_l00008ooooo`;o00000oooool2o`000?3ooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo001?
ooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0iOooool004oooooo00?o0000oooo
ooooool0COooool00ol0003oooooooooo`3Uooooo`00BOooool4o`0000?ooooo00?o0000oooooooo
ool0A_ooool4o`0000?ooooo00?o0000ooooooooool0i?ooool0053ooooo00?o0000ooooooooool0
COooool00ol0003oooooooooo`3Tooooo`00C_ooool01?l0003oooooooooool0001<ooooo`04o`00
0?ooooooooooo`000>Gooooo001>ooooo`Co0000C?ooool4o`000>Gooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo002h
ooooo`;o00000oooool00ol0003oooooooooo`37ooooo`00K_ooool00ol0003oooooooooo`19oooo
o`05o`000?ooooooooooooooool000003Oooool00ol0003oooooooooo`2hooooo`004_ooool01?l0
003oooooooooool00002ooooo`?o000000Coooooo`000?l0003o00000_ooool2o`000007ooooool0
003o0000ooooool0003oooooo`000002ooooo`;o00000oooool2o`0000?ooooo1?l00005ooooo`?o
00000oooool3o`000004ooooool0003o0000o`0000?ooooo0ol00002ooooo`?o00000oooool2o`00
0004ooooool0003o0000o`0000Cooooo00?o0000ooooooooool01_ooool01?l0003ooooooooooooo
ool4o`0000Kooooo1?l000001?oooooo0000o`000?l00003ooooo`?o00000_ooool3o`0000Oooooo
1ol00003ooooo`?o00000_ooool3o`000005ooooool0003oooooooooool000000_ooool3o`000005
ooooool0003oooooooooool000000_ooool3o`0000?ooooo00?o0000ooooooooool01?l00002oooo
o`?o00000oooool00ol0003oooooooooo`2gooooo`004_ooool00ol0003oooooo`000004ooooo`05
o`000?ooooooooooooooool000001?ooool00ol0003oooooo`000002ooooo`05o`000?oooooo0000
ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000
ooooooooool01Oooool01?l0003oooooooooooooool2o`0000Gooooo0_l000001Ooooooo0000oooo
oooooooo000000?ooooo00Go0000ooooooooooooooooo`000005ooooo`;o00003?ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00_ooool01?l0003o
ooooooooooooool2o`0000?ooooo0_l00008ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000
ooooooooooooooooo`000002ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003ooooo
ooooool00003ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000_ooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`2gooooo`004_ooool2o`0000Gooooo00Go0000ooooooooooooooooo`000004oooo
o`;o00000_ooool01?l0003oooooo`000?ooool2o`0000;ooooo00?o0000ooooool000000_ooool0
0ol0003oooooo`000002ooooo`03o`000?oooooooooo00Gooooo00Ko0000ooooooooooooooooo`00
0?ooool2o`000003ooooool0003o000000?ooooo00Co0000oooooooooooo00000oooool01Ol0003o
oooooooooooooooo000000?ooooo0_l0000=ooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`02ooooo`06o`000?ooooooooooooooool0003ooooo0_l0
00000ooooooo0000ooooo`02o`000003ooooool0003o000000;o000000Goooooo`000?oooooooooo
o`000002ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooool000000oooool01?l0003ooooo
ooooool00002ooooo`05o`000?ooooooooooooooool000000_ooool01_l0003oooooooooool0003o
ooooo`0000;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool0]_ooool001;ooooo0_l00004ooooo`;o00000_ooool0
1?l0003oooooo`000?l00002ooooo`0:o`000?oooooo0000ooooool0003oooooo`000?oooooo0000
ooooo`;o00000oooool2o`0000?ooooo0ol00006ooooo`04o`000?oooooo0000o`0000;ooooo0_l0
0003ooooo`?o000000Goooooo`000?ooooooooooo`000003ooooo`03o`000?oooooooooo00Co0000
0_ooool3o`0000?ooooo00?o0000ooooooooool01_ooool01?l0003oooooooooooooool4o`0000Ko
oooo1?l000000ooooooo0000ooooo`02o`0000;ooooo0_l00003ooooo`;o00002?ooool3o`000003
ooooool0003ooooo00;o000000Coooooo`000?l0003o00000oooool2o`0000;ooooo0ol00003oooo
o`;o00000_ooool3o`0000?ooooo0ol00006ooooo`Co00000oooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo0;Oooooo000Booooo`03o`000?oooooo000000gooooo00?o0000oooooooo
ool04oooool00ol0003oooooooooo`0Jooooo`05o`000?ooooooooooooooool000004oooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool06?ooool00ol0
003oooooooooo`0Xooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`2gooooo`004_ooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo
00Gooooo0_l0000Dooooo`;o00006oooool2o`0001Sooooo00?o0000ooooooooool00_ooool2o`00
00Sooooo0_l0000Gooooo`;o00003Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
017ooooo0_l00002ooooo`;o00000oooool00ol0003oooooooooo`2hooooo`00oooooon8ooooo`00
oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`000oooool01?l0003oooooooooool00002ooooo`?o000000Coooooo`000?l0003o
00000_ooool2o`000003ooooool0003o000000Gooooo0ol00007ooooo`06o`000?oooooo0000oooo
ool0003ooooo0_l00003ooooo`Co000000Coooooo`000?l0003o00000_ooool3o`0000?ooooo00?o
0000ooooooooool0oooooom4ooooo`000oooool00ol0003oooooo`000004ooooo`05o`000?oooooo
ooooooooool000001?ooool00ol0003oooooo`000008ooooo`;o00001_ooool01?l0003oooooo`00
0?ooool2o`0000;ooooo00?o0000ooooool000000_ooool01?l0003oooooo`000?l00005ooooo`03
o`000?oooooooooo0?ooooooBOooool000?ooooo0_l00005ooooo`05o`000?ooooooooooooooool0
00001?ooool2o`0000Oooooo0_l00008ooooo`04o`000?oooooo0000ooooo`;o00000_ooool00ol0
003oooooo`000002ooooo`04o`000?oooooo0000ooooo`;o00000oooool00ol0003oooooooooo`3o
ooooodWooooo0003ooooo`;o00001?ooool2o`0000;ooooo00Co0000ooooool0003o00000_ooool0
0ol0003oooooo`000007ooooo`?o00001_ooool2o`000004ooooool0003oooooooooo`;o00000ooo
ool3o`0000;ooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0oooo
oom4ooooo`000oooool00ol0003oooooo`00000=ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool06?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo0?ooooooBOooool0
00?ooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`05ooooo`;o00001?ooool0
0ol0003oooooooooo`0Gooooo`;o00001oooool2o`000?ooooooBoooool00?ooooooR?ooool00?oo
ooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?oo
ooooR?ooool00?ooooooR?ooool003Gooooo0ol0001=ooooo`?o0000ooooool003Oooooo0_l0001>
ooooo`;o0000o_ooool003Gooooo0_l0001>ooooo`;o0000ooooool1ooooo`00=_ooool3o`0004go
oooo0ol0003nooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8oooo
o`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00G_ooool00ol0003oooooooooo`3o
ooooobOooooo000Dooooo`03o`000?oooooooooo04Sooooo00?o0000ooooooooool0C?ooool00ol0
003oooooooooo`3Fooooo`004oooool00ol0003oooooooooo`19ooooo`03o`000?oooooooooo04go
oooo00?o0000ooooooooool0eOooool001?ooooo00?o0000ooooooooool0VOooool00ol0003ooooo
ooooo`3Eooooo`004_ooool00ol0003oooooooooo`02ooooo`Co000000?oooooo`000?l000000_l0
00000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l0
00000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l0
00000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l0
00000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l0
000;ooooo`Co000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0
003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0
003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0
003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0
003o000000;o000000?oooooo`000?l000000_l00004ooooo`03o`000?oooooooooo0=Cooooo000C
ooooo`03o`000?oooooooooo09Wooooo00?o0000ooooooooool0eOooool001?ooooo00?o0000oooo
ooooool0VOooool00ol0003oooooooooo`3Eooooo`005?ooool00ol0003oooooooooo`2Gooooo`03
o`000?oooooooooo0=Kooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003ooooo
ohSooooo003oooooohSooooo003oooooohSooooo001Iooooo`;o0000C_ooool2o`000=cooooo001K
ooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0fOooool001Oooooo1?l00003oooo
o`04o`000?ooooooooooooooo`?o00000_ooool2o`0000?ooooo00?o0000ooooooooool00_ooool2
o`0000?ooooo0ol00007ooooo`?o00000_ooool2o`0001;ooooo0ol0000<ooooo`?o00000oooool0
1Ol0003ooooooooooooooooo000000Cooooo0_l00003ooooo`;o00000_ooool4o`0000;ooooo0ol0
0007ooooo`?o00000_ooool2o`0001;ooooo0ol0003Kooooo`006?ooool00ol0003oooooooooo`08
ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000oooool01?l0003ooooo
ooooool00003ooooo`03o`000?oooooooooo00Oooooo00Co0000oooooooooooo00000_ooool00ol0
003oooooooooo`0>ooooo`04o`000?ooooooooooo`0000gooooo00?o0000ooooooooool01_ooool0
1Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooool000000_ooool01?l0003ooooooooo
ool00005ooooo`03o`000?oooooooooo00Oooooo00Co0000oooooooooooo00000_ooool00ol0003o
ooooooooo`0>ooooo`04o`000?ooooooooooo`000=_ooooo000Iooooo`03o`000?oooooooooo00Oo
oooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000
oooooooooooo00000oooool00ol0003oooooooooo`07ooooo`04o`000?ooooooooooo`0000;ooooo
00?o0000ooooooooool03_ooool01?l0003oooooooooool0000=ooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool00oooool00ol0003oooooo`000002ooooo`05o`000?oooooooooooooo
ool000001?ooool00ol0003oooooooooo`07ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000
ooooooooool03_ooool01?l0003oooooooooool0003Kooooo`006_ooool00ol0003oooooooooo`06
ooooo`03o`000?oooooooooo00?o00001?ooool01?l0003oooooooooool00002ooooo`05o`000?oo
ooooooooooooool000002Oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00oo
oooo0ol0000=ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`03o`0000Gooooo00Go0000ooooooooooooooooo`000009ooooo`04o`000?oooooooooo
o`0000;ooooo00?o0000ooooooooool03oooool3o`000=_ooooo000Gooooo`04o`000?oooooooooo
o`0000Sooooo00Go0000ooooooooooooooooo`000003ooooo`06o`000?ooooooooooo`000?oooooo
00000_ooool01Ol0003ooooooooooooooooo000000Wooooo00Co0000oooooooooooo00000_ooool0
0ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00Gooooo00Ko0000oooooooooooo0000oooo
ool00002ooooo`04o`000?ooooooooooo`0000?ooooo00Co0000oooooooooooo00000oooool00ol0
003oooooooooo`07ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0kOooool0
01Sooooo0_l00008ooooo`;o00001?ooool00ol0003oooooooooo`04o`0000;ooooo0_l00003oooo
o`;o00002?ooool2o`0000?ooooo0_l0000Qooooo`;o00001oooool4o`0000;ooooo0_l00004oooo
o`04o`000?ooooooooooooooo`;o00000oooool2o`0000Sooooo0_l00003ooooo`;o0000l?ooool0
0?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
0?ooooooR?ooool00?ooooooR?ooool004oooooo00?o0000ooooooooool0COooool00ol0003ooooo
ooooo`3Uooooo`00Coooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0>Gooooo0019
ooooo`Co00000oooool00ol0003oooooooooo`16ooooo`Co00000oooool00ol0003oooooooooo`3T
ooooo`00D?ooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0>Cooooo001>ooooo`04
o`000?ooooooooooo`0004cooooo00Co0000oooooooooooo0000iOooool004kooooo1?l0001<oooo
o`Co0000iOooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
0?ooooooR?ooool00?ooooooR?ooool00;Sooooo0_l00003ooooo`03o`000?oooooooooo0<Oooooo
001^ooooo`03o`000?oooooooooo04Wooooo00Go0000ooooooooooooooooo`00000=ooooo`03o`00
0?oooooooooo0;Sooooo000Booooo`04o`000?ooooooooooo`0000;ooooo0ol000001?oooooo0000
o`000?l00002ooooo`;o000000Ooooooo`000?l0003oooooo`000?oooooo000000;ooooo0_l00003
ooooo`;o00000oooool4o`0000Gooooo0ol00003ooooo`?o000000Coooooo`000?l0003o00000ooo
ool3o`0000;ooooo0ol00003ooooo`;o000000Coooooo`000?l0003o00001?ooool00ol0003ooooo
ooooo`06ooooo`04o`000?ooooooooooooooo`Co00001_ooool4o`000004ooooool0003o0000o`00
00?ooooo0ol00002ooooo`?o00001oooool7o`0000?ooooo0ol00002ooooo`?o000000Goooooo`00
0?ooooooooooo`000002ooooo`?o000000Goooooo`000?ooooooooooo`000002ooooo`?o00000ooo
ool00ol0003oooooooooo`04o`0000;ooooo0ol00003ooooo`03o`000?oooooooooo0;Oooooo000B
ooooo`03o`000?oooooo000000Cooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oo
oooo000000;ooooo00Go0000ooooool0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo
00?o0000ooooool000000_ooool00ol0003oooooooooo`05ooooo`04o`000?ooooooooooooooo`;o
00001Oooool2o`000005ooooool0003oooooooooool000000oooool01Ol0003ooooooooooooooooo
000000Gooooo0_l0000<ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`02ooooo`04o`000?ooooooooooooooo`;o00000oooool2o`0000Sooooo00Co
0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000oooooooo
ooooooooo`000002ooooo`04o`000?ooooooooooo`0000?ooooo00Co0000oooooooooooo00000_oo
ool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0;Oooooo000Booooo`;o00001Oooool0
1Ol0003ooooooooooooooooo000000Cooooo0_l00002ooooo`04o`000?oooooo0000ooooo`;o0000
0_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool0
1Oooool01_l0003ooooooooooooooooo0000ooooo`;o000000?oooooo`000?l000000oooool01?l0
003oooooooooool00003ooooo`05o`000?ooooooooooooooool000000oooool2o`0000gooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00;ooooo00Ko
0000ooooooooooooooooo`000?ooool2o`000003ooooool0003ooooo00;o000000?oooooo`000?l0
00000_l000001Ooooooo0000oooooooooooo000000;ooooo00?o0000ooooooooool00_ooool00ol0
003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000ooooooooooooooooo`00
0002ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2fooooo`00
4_ooool2o`0000Cooooo0_l00002ooooo`04o`000?oooooo0000o`0000;ooooo00[o0000ooooool0
003oooooo`000?oooooo0000ooooool0003ooooo0_l00003ooooo`;o00000oooool3o`0000Kooooo
00Co0000ooooool0003o00000_ooool2o`0000?ooooo0ol000001Ooooooo0000oooooooooooo0000
00?ooooo00?o0000ooooooooool01?l00002ooooo`?o00000oooool00ol0003oooooooooo`06oooo
o`04o`000?ooooooooooooooo`Co00001_ooool4o`000003ooooool0003ooooo00;o00000_ooool2
o`0000?ooooo0_l00008ooooo`?o000000?oooooo`000?ooool00_l000001?oooooo0000o`000?l0
0003ooooo`;o00000_ooool3o`0000?ooooo0_l00002ooooo`?o00000oooool3o`0000Kooooo1?l0
0003ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0]oooool001;ooooo00?o0000
ooooool000003Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo01[ooooo00Go0000
ooooooooooooooooo`00000Cooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0;Oooooo000Booooo`04o`000?oooooo
ooooo`0000?ooooo00?o0000ooooooooool01Oooool2o`0001Cooooo0_l0000Kooooo`;o00006?oo
ool00ol0003oooooooooo`02ooooo`;o00002?ooool2o`0001Oooooo0_l0000=ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool04Oooool2o`0000;ooooo0_l00003ooooo`03o`000?oo
oooooooo0;Sooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo
003oooooohSooooo0009ooooo`03o`000?oooooooooo0?ooooooO?ooool000[ooooo00?o0000oooo
ooooool0oooooomkooooo`000oooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000oooo
ooooool01Oooool01_l0003oooooo`000?oooooo0000ooooo`;o00000oooool4o`000004ooooool0
003o0000o`0000;ooooo0ol00003ooooo`03o`000?oooooooooo0?ooooooF?ooool000?ooooo00Wo
0000ooooooooooooooooo`000?oooooo0000ooooool000001_ooool01?l0003oooooo`000?ooool2
o`0000;ooooo00?o0000ooooool000000_ooool01?l0003oooooo`000?l00005ooooo`03o`000?oo
oooooooo0?ooooooGOooool000?ooooo00Wo0000ooooooooooooooooo`000?oooooo0000ooooool0
00001_ooool01?l0003oooooo`000?ooool2o`0000;ooooo00?o0000ooooool000000_ooool01?l0
003oooooo`000?ooool2o`0000?ooooo00?o0000ooooooooool0oooooomMooooo`000oooool01?l0
003oooooo`000?ooool3o`000003ooooool0003o000000Gooooo0_l000001?oooooo0000oooooooo
ool2o`0000?ooooo0ol00002ooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo0?ooooooF?ooool000?ooooo0_l000000ooooooo0000o`00000Gooooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool0oooooomMooooo`000oooool01Ol0003ooooooooooooooooo
000001Kooooo0_l00007ooooo`;o0000oooooomOooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00<?ooool2o`0000go
oooo0_l0003oooooodOooooo000`ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0
oooooom6ooooo`001?ooool3o`0000;ooooo0_l00003ooooo`;o00001?ooool01?l0003ooooooooo
ooooool2o`0000?ooooo0_l00003ooooo`;o00001oooool3o`0000;ooooo0ol00007ooooo`?o0000
0_ooool3o`0000?ooooo0ol00002ooooo`?o00000_ooool3o`000004ooooool0003o0000o`000?oo
oooo<_ooool000Gooooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`000002ooooo`03
o`000?oooooooooo00Cooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooo
000000;ooooo00?o0000ooooooooool01?ooool01_l0003oooooooooool0003oooooo`0000;ooooo
00?o0000ooooooooool01_ooool2o`000007ooooool0003oooooooooool0003oooooo`000002oooo
o`03o`000?oooooo000000Cooooo0_l00004ooooo`03o`000?oooooooooo0?oooooo<Oooool000Go
oooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo
00Cooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooooooo00Cooooo0_l0
0003ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000ooooool0003oooooo`000002ooooo`04
o`000?oooooo0000ooooo`;o00000_ooool00ol0003oooooooooo`3ooooooc7ooooo0005ooooo`04
o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`04oooo
o`?o00000oooool2o`0000?ooooo0_l00007ooooo`?o00000_ooool3o`0000Sooooo0ol000001?oo
oooo0000o`000?l00002ooooo`?o00000oooool3o`0000;ooooo0_l00002ooooo`04o`000?oooooo
0000o`000?oooooo<Oooool000Gooooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`00
0002ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool01_l0003ooooooooo
ool0003oooooo`0000;ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3ooooooe[o
oooo0004ooooo`;o00000oooool2o`0000?ooooo0_l00007ooooo`Co00000_ooool2o`0000?ooooo
0_l00007ooooo`03o`000?oooooooooo0?ooooooF_ooool00?ooooooR?ooool00?ooooooR?ooool0
0?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
03Gooooo0ol0001=ooooo`?o0000ooooool003Oooooo0_l0001>ooooo`;o0000o_ooool003Gooooo
0_l0001>ooooo`;o0000ooooool1ooooo`00=_ooool3o`0004gooooo0ol0003nooooo`00oooooon8
ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8
ooooo`00oooooon8ooooo`00oooooon8ooooo`00G_ooool00ol0003oooooooooo`3oooooobOooooo
000Dooooo`03o`000?oooooooooo04Sooooo00?o0000ooooooooool0C?ooool00ol0003ooooooooo
o`3Fooooo`004oooool00ol0003oooooooooo`19ooooo`03o`000?oooooooooo04gooooo00?o0000
ooooooooool0eOooool001?ooooo00?o0000ooooooooool0VOooool00ol0003oooooooooo`3Eoooo
o`004_ooool00ol0003oooooooooo`02ooooo`Co000000?oooooo`000?l000000_l000000ooooooo
0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo
0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo
0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo
0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l0000;ooooo`Co
000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o
000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o
000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o
000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o
000000?oooooo`000?l000000_l00004ooooo`03o`000?oooooooooo0=Cooooo000Cooooo`03o`00
0?oooooooooo09Wooooo00?o0000ooooooooool0eOooool001?ooooo00?o0000ooooooooool0VOoo
ool00ol0003oooooooooo`3Eooooo`005?ooool00ol0003oooooooooo`2Gooooo`03o`000?oooooo
oooo0=Kooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo001Iooooo`;o0000C_ooool2o`000=cooooo001Kooooo`03o`000?oooooooooo04go
oooo00?o0000ooooooooool0fOooool001Oooooo1?l00003ooooo`04o`000?ooooooooooooooo`;o
00000oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00;o00001Oooool00ol0003o
ooooooooo`05ooooo`?o00000_ooool2o`0001;ooooo0ol0000<ooooo`?o00000oooool01?l0003o
ooooooooooooool3o`0000;ooooo0_l00003ooooo`03o`000?oooooooooo00;ooooo00Co0000oooo
oooooooooooo1?l00007ooooo`?o00000_ooool2o`0001;ooooo0ol0003Kooooo`006?ooool00ol0
003oooooooooo`06ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool01?ooool0
0ol0003oooooo`000002ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01_ooool0
1?l0003oooooooooool00002ooooo`03o`000?oooooooooo00kooooo00Co0000oooooooooooo0000
3Oooool00ol0003oooooooooo`07ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooo
oooo00001Oooool01Ol0003ooooooooooooooooo000000[ooooo00Co0000oooooooooooo00000_oo
ool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`000=_ooooo000Iooooo`03o`000?oo
oooooooo00Gooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`04o`000006oooo
ool0003oooooooooool0003ooooo1?l00008ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000
ooooooooool03_ooool01?l0003oooooooooool0000=ooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool00oooool01Ol0003ooooooooooooooooo000000?ooooo0ol00003ooooo`03o`00
0?oooooooooo00Oooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04
o`000?ooooooooooo`000=_ooooo000Jooooo`03o`000?oooooooooo00Cooooo0ol00004ooooo`07
o`000?ooooooooooooooool0003oooooo`000002ooooo`;o00000oooool00ol0003oooooo`000008
ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool03oooool3o`0000gooooo00?o
0000ooooooooool01oooool00ol0003oooooooooo`03o`0000Cooooo00Co0000oooooooooooo0000
0_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo
00000_ooool00ol0003oooooooooo`0?ooooo`?o0000foooool001Oooooo00Co0000oooooooooooo
00001oooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooooooo0_l00000
1Ooooooo0000oooooooooooo000000?ooooo0_l00008ooooo`04o`000?ooooooooooo`0000;ooooo
00?o0000ooooooooool07oooool00ol0003oooooooooo`07ooooo`04o`000?ooooooooooo`0000Co
oooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooo000000;ooooo00?o0000
ooooooooool01_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo0>gooooo000H
ooooo`;o00002Oooool00ol0003oooooooooo`04o`0000Cooooo00?o0000ooooooooool00_l00005
ooooo`03o`000?oooooooooo00Gooooo0_l00003ooooo`;o00008Oooool2o`0000Sooooo0_l00002
ooooo`Co000000?oooooo`000?l000000_l00002ooooo`;o00000oooool2o`0000Sooooo0_l00003
ooooo`;o0000l?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?oo
ool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool004oooooo00?o
0000ooooooooool0COooool00ol0003oooooooooo`3Uooooo`00Coooool00ol0003oooooooooo`1=
ooooo`03o`000?oooooooooo0>Gooooo0019ooooo`Co00000oooool00ol0003oooooooooo`16oooo
o`Co00000oooool00ol0003oooooooooo`3Tooooo`00D?ooool00ol0003oooooooooo`1=ooooo`03
o`000?oooooooooo0>Cooooo001>ooooo`04o`000?ooooooooooo`0004cooooo00Co0000oooooooo
oooo0000iOooool004kooooo1?l0001<ooooo`Co0000iOooool00?ooooooR?ooool00?ooooooR?oo
ool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00;Sooooo0_l00003ooooo`03o`00
0?oooooooooo0<Oooooo001^ooooo`03o`000?oooooooooo04Wooooo00Go0000oooooooooooooooo
o`00000=ooooo`03o`000?oooooooooo0;Sooooo000Booooo`04o`000?ooooooooooo`0000;ooooo
0ol000001?oooooo0000o`000?l00002ooooo`;o000000Ooooooo`000?l0003oooooo`000?oooooo
000000;ooooo0_l00003ooooo`;o00000oooool4o`0000Gooooo0ol00003ooooo`?o000000Cooooo
o`000?l0003o00000oooool3o`0000;ooooo0ol00003ooooo`;o000000Coooooo`000?l0003o0000
1?ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooooooo`Co00001_ooool4o`000004
ooooool0003o0000o`0000?ooooo0ol00002ooooo`?o00001oooool7o`0000?ooooo0ol00002oooo
o`?o000000Goooooo`000?ooooooooooo`000002ooooo`?o000000Goooooo`000?ooooooooooo`00
0002ooooo`?o00000oooool00ol0003oooooooooo`04o`0000;ooooo0ol00003ooooo`03o`000?oo
oooooooo0;Oooooo000Booooo`03o`000?oooooo000000Cooooo00Go0000ooooooooooooooooo`00
0004ooooo`03o`000?oooooo000000;ooooo00Go0000ooooool0003oooooo`000002ooooo`03o`00
0?oooooo000000;ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`05ooooo`04o`00
0?ooooooooooooooo`;o00001Oooool2o`000005ooooool0003oooooooooool000000oooool01Ol0
003ooooooooooooooooo000000Gooooo0_l0000<ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooooooo`;o00000ooo
ool2o`0000Sooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo000000;o
oooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000?ooooo00Co0000
oooooooooooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0;Oooooo000B
ooooo`;o00001Oooool01Ol0003ooooooooooooooooo000000Cooooo0_l00002ooooo`04o`000?oo
oooo0000ooooo`;o00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo
00?o0000ooooooooool01Oooool01_l0003ooooooooooooooooo0000ooooo`;o000000?oooooo`00
0?l000000oooool01?l0003oooooooooool00003ooooo`05o`000?ooooooooooooooool000000ooo
ool2o`0000gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00;ooooo00Ko0000ooooooooooooooooo`000?ooool2o`000003ooooool0003ooooo00;o
000000?oooooo`000?l000000_l000001Ooooooo0000oooooooooooo000000;ooooo00?o0000oooo
ooooool00_ooool00ol0003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000
ooooooooooooooooo`000002ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`2fooooo`004_ooool2o`0000Cooooo0_l00002ooooo`04o`000?oooooo0000o`0000;o
oooo00[o0000ooooool0003oooooo`000?oooooo0000ooooool0003ooooo0_l00003ooooo`;o0000
0oooool3o`0000Kooooo00Co0000ooooool0003o00000_ooool2o`0000?ooooo0ol000001Ooooooo
0000oooooooooooo000000?ooooo00?o0000ooooooooool01?l00002ooooo`?o00000oooool00ol0
003oooooooooo`06ooooo`04o`000?ooooooooooooooo`Co00001_ooool4o`000003ooooool0003o
oooo00;o00000_ooool2o`0000?ooooo0_l00008ooooo`?o000000?oooooo`000?ooool00_l00000
1?oooooo0000o`000?l00003ooooo`;o00000_ooool3o`0000?ooooo0_l00002ooooo`?o00000ooo
ool3o`0000Kooooo1?l00003ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0]ooo
ool001;ooooo00?o0000ooooool000003Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooo
oooo01[ooooo00Go0000ooooooooooooooooo`00000Cooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool01oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo02Sooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0;Oooooo000B
ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool01Oooool2o`0001Cooooo0_l0
000Kooooo`;o00006?ooool00ol0003oooooooooo`02ooooo`;o00002?ooool2o`0001Oooooo0_l0
000=ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool04Oooool2o`0000;ooooo0_l0
0003ooooo`03o`000?oooooooooo0;Sooooo003oooooohSooooo003oooooohSooooo003oooooohSo
oooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSo
oooo0003ooooo`04o`000?ooooooooooo`0000;ooooo0ol000001?oooooo0000o`000?l00002oooo
o`;o000000?oooooo`000?l000001Oooool3o`0000Oooooo00Ko0000ooooool0003oooooo`000?oo
ool2o`0000?ooooo1?l000001?oooooo0000o`000?l00002ooooo`?o00000oooool00ol0003ooooo
ooooo`3oooooodCooooo0003ooooo`03o`000?oooooo000000Cooooo00Go0000oooooooooooooooo
o`000004ooooo`03o`000?oooooo000000Sooooo0_l00006ooooo`04o`000?oooooo0000ooooo`;o
00000_ooool00ol0003oooooo`000002ooooo`04o`000?oooooo0000o`0000Gooooo00?o0000oooo
ooooool0oooooom9ooooo`000oooool2o`0000Gooooo00Go0000ooooooooooooooooo`000004oooo
o`;o00001oooool2o`0000Sooooo00Co0000ooooool0003ooooo0_l00002ooooo`03o`000?oooooo
000000;ooooo00Co0000ooooool0003ooooo0_l00003ooooo`03o`000?oooooooooo0?ooooooBOoo
ool000?ooooo0_l00004ooooo`;o00000_ooool01?l0003oooooo`000?l00002ooooo`03o`000?oo
oooo000000Oooooo0ol00006ooooo`;o000000Coooooo`000?oooooooooo0_l00003ooooo`?o0000
0_ooool2o`0000Cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`3oooooodCooooo
0003ooooo`03o`000?oooooo000000gooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`0Hooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0oooooom9ooooo`000oooool0
1?l0003oooooooooool00003ooooo`03o`000?oooooooooo00Gooooo0_l00004ooooo`03o`000?oo
oooooooo01Oooooo0_l00007ooooo`;o0000oooooom;ooooo`00oooooon8ooooo`00oooooon8oooo
o`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8oooo
o`00=Oooool3o`0004gooooo0ol0003oooooo`00=oooool2o`0004kooooo0_l0003nooooo`00=Ooo
ool2o`0004kooooo0_l0003oooooo`7ooooo000fooooo`?o0000COooool3o`000?kooooo003ooooo
ohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003ooooo
ohSooooo003oooooohSooooo003oooooohSooooo001Nooooo`03o`000?oooooooooo0?oooooo9ooo
ool001Cooooo00?o0000ooooooooool0B?ooool00ol0003oooooooooo`1<ooooo`03o`000?oooooo
oooo0=Kooooo000Cooooo`03o`000?oooooooooo04Wooooo00?o0000ooooooooool0COooool00ol0
003oooooooooo`3Eooooo`004oooool00ol0003oooooooooo`2Iooooo`03o`000?oooooooooo0=Go
oooo000Booooo`03o`000?oooooooooo00;ooooo1?l000000ooooooo0000o`000002o`000003oooo
ool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003oooo
ool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003oooo
ool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003oooo
ool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`0000_ooooo
1?l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l00000
0_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l00000
0_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l00000
0_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l00000
0_l000000ooooooo0000o`000002o`0000Cooooo00?o0000ooooooooool0e?ooool001?ooooo00?o
0000ooooooooool0VOooool00ol0003oooooooooo`3Eooooo`004oooool00ol0003oooooooooo`2I
ooooo`03o`000?oooooooooo0=Gooooo000Dooooo`03o`000?oooooooooo09Oooooo00?o0000oooo
ooooool0e_ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
0?ooooooR?ooool005Wooooo0_l0001>ooooo`;o0000g?ooool005_ooooo00?o0000ooooooooool0
COooool00ol0003oooooooooo`3Iooooo`005oooool4o`0000?ooooo00Co0000oooooooooooooooo
0_l00005ooooo`04o`000?ooooooooooo`0000Cooooo0_l00003ooooo`;o00002?ooool3o`0000;o
oooo0_l0000Booooo`?o00003?ooool3o`0000?ooooo00Co0000oooooooooooooooo0_l00003oooo
o`?o00000_ooool2o`0000;ooooo1?l00002ooooo`;o00002?ooool3o`0000;ooooo0_l0000Boooo
o`?o0000foooool001Sooooo00?o0000ooooooooool01_ooool01?l0003oooooooooool00004oooo
o`04o`000?ooooooooooo`0000?ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`00
0?oooooooooo00Kooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04
o`000?ooooooooooo`0000gooooo00?o0000ooooooooool01Oooool01?l0003oooooooooool00003
ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000oooool01?l0003ooooo
ooooool00008ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0
003oooooooooool0003Kooooo`006Oooool00ol0003oooooooooo`05ooooo`05o`000?oooooooooo
o`000?ooool01?l00003ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooool000000_ooool0
0ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool03_oo
ool01?l0003oooooooooool0000=ooooo`03o`000?oooooooooo00Gooooo00Co0000oooooooooooo
00000oooool01?l0003oooooooooool00002ooooo`05o`000?ooooooooooooooool000001Oooool0
0ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool03_oo
ool01?l0003oooooooooool0003Kooooo`006_ooool00ol0003oooooooooo`04ooooo`04o`000?oo
ooooooooo`0000;ooooo00?o0000ooooool000000oooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00?o00002Oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00oo
oooo0ol0000=ooooo`03o`000?oooooooooo00Gooooo0ol00004ooooo`03o`000?oooooooooo00?o
00001Oooool01Ol0003ooooooooooooooooo000000Wooooo00Co0000oooooooooooo00000_ooool0
0ol0003oooooooooo`0?ooooo`?o0000foooool001Oooooo00Co0000oooooooooooo00001_ooool0
1?l0003oooooooooool00003ooooo`;o000000Ooooooo`000?ooooooooooo`000?oooooo000000;o
oooo00Co0000oooooooooooo00002_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooo
oooo01oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`03ooooo`05o`000?oooooo
ooooooooool000000oooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000oooooooo
ool01_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo0>gooooo000Hooooo`;o
00002?ooool2o`0000Gooooo00?o0000ooooool000000ol00002ooooo`;o00001?ooool00ol0003o
ooooooooo`06ooooo`;o00000oooool2o`00027ooooo0_l00009ooooo`04o`000?oooooooooooooo
o`;o00001?ooool01?l0003oooooooooooooool2o`0000?ooooo0_l00008ooooo`;o00000oooool2
o`000?3ooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo001?ooooo`03o`000?oo
oooooooo04gooooo00?o0000ooooooooool0iOooool004oooooo00?o0000ooooooooool0COooool0
0ol0003oooooooooo`3Uooooo`00BOooool4o`0000?ooooo00?o0000ooooooooool0A_ooool4o`00
00?ooooo00?o0000ooooooooool0i?ooool0053ooooo00?o0000ooooooooool0COooool00ol0003o
ooooooooo`3Tooooo`00C_ooool01?l0003oooooooooool0001<ooooo`04o`000?ooooooooooo`00
0>Gooooo001>ooooo`Co0000C?ooool4o`000>Gooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo002hooooo`;o00000oooool00ol0003ooooo
ooooo`37ooooo`00K_ooool00ol0003oooooooooo`19ooooo`05o`000?ooooooooooooooool00000
3Oooool00ol0003oooooooooo`2hooooo`004_ooool01?l0003oooooooooool00002ooooo`?o0000
00Coooooo`000?l0003o00000_ooool2o`000007ooooool0003o0000ooooool0003oooooo`000002
ooooo`;o00000oooool2o`0000?ooooo1?l00005ooooo`?o00000oooool3o`000004ooooool0003o
0000o`0000?ooooo0ol00002ooooo`?o00000oooool2o`000004ooooool0003o0000o`0000Cooooo
00?o0000ooooooooool01_ooool01?l0003oooooooooooooool4o`0000Kooooo1?l000001?oooooo
0000o`000?l00003ooooo`?o00000_ooool3o`0000Oooooo1ol00003ooooo`?o00000_ooool3o`00
0005ooooool0003oooooooooool000000_ooool3o`000005ooooool0003oooooooooool000000_oo
ool3o`0000?ooooo00?o0000ooooooooool01?l00002ooooo`?o00000oooool00ol0003ooooooooo
o`2gooooo`004_ooool00ol0003oooooo`000004ooooo`05o`000?ooooooooooooooool000001?oo
ool00ol0003oooooo`000002ooooo`05o`000?oooooo0000ooooool000000_ooool00ol0003ooooo
o`000002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool01Oooool01?l0003ooooo
ooooooooool2o`0000Gooooo0_l000001Ooooooo0000oooooooooooo000000?ooooo00Go0000oooo
ooooooooooooo`000005ooooo`;o00003?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool00_ooool01?l0003oooooooooooooool2o`0000?ooooo0_l0
0008ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000ooooooooooooooooo`000002ooooo`05
o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool00003ooooo`04o`000?oooooo
ooooo`0000;ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2gooooo`004_ooool2
o`0000Gooooo00Go0000ooooooooooooooooo`000004ooooo`;o00000_ooool01?l0003oooooo`00
0?ooool2o`0000;ooooo00?o0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`00
0?oooooooooo00Gooooo00Ko0000ooooooooooooooooo`000?ooool2o`000003ooooool0003o0000
00?ooooo00Co0000oooooooooooo00000oooool01Ol0003ooooooooooooooooo000000?ooooo0_l0
000=ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`02ooooo`06o`000?ooooooooooooooool0003ooooo0_l000000ooooooo0000ooooo`02o`000003
ooooool0003o000000;o000000Goooooo`000?ooooooooooo`000002ooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooool000000oooool01?l0003oooooooooool00002ooooo`05o`000?oooooo
ooooooooool000000_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool0]_ooool001;ooooo0_l00004ooooo`;o00000_ooool01?l0003oooooo`000?l00002ooooo`0:
o`000?oooooo0000ooooool0003oooooo`000?oooooo0000ooooo`;o00000oooool2o`0000?ooooo
0ol00006ooooo`04o`000?oooooo0000o`0000;ooooo0_l00003ooooo`?o000000Goooooo`000?oo
ooooooooo`000003ooooo`03o`000?oooooooooo00Co00000_ooool3o`0000?ooooo00?o0000oooo
ooooool01_ooool01?l0003oooooooooooooool4o`0000Kooooo1?l000000ooooooo0000ooooo`02
o`0000;ooooo0_l00003ooooo`;o00002?ooool3o`000003ooooool0003ooooo00;o000000Cooooo
o`000?l0003o00000oooool2o`0000;ooooo0ol00003ooooo`;o00000_ooool3o`0000?ooooo0ol0
0006ooooo`Co00000oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0;Oooooo000B
ooooo`03o`000?oooooo000000gooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0J
ooooo`05o`000?ooooooooooooooool000004oooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0Xooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2gooooo`004_ooool0
1?l0003oooooooooool00003ooooo`03o`000?oooooooooo00Gooooo0_l0000Dooooo`;o00006ooo
ool2o`0001Sooooo00?o0000ooooooooool00_ooool2o`0000Sooooo0_l0000Gooooo`;o00003Ooo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo017ooooo0_l00002ooooo`;o00000ooo
ool00ol0003oooooooooo`2hooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`002Oooool00ol0003oooooooooo`3ooooo
ogcooooo000:ooooo`03o`000?oooooooooo0?ooooooNoooool000?ooooo00Go0000oooooooooooo
ooooo`000002ooooo`03o`000?oooooooooo00Gooooo00Ko0000ooooool0003oooooo`000?ooool2
o`0000?ooooo1?l000001?oooooo0000o`000?l00002ooooo`?o00000oooool00ol0003ooooooooo
o`3ooooooeSooooo0003ooooo`09o`000?ooooooooooooooool0003oooooo`000?oooooo000000Ko
oooo00Co0000ooooool0003ooooo0_l00002ooooo`03o`000?oooooo000000;ooooo00Co0000oooo
ool0003o00001Oooool00ol0003oooooooooo`3ooooooegooooo0003ooooo`09o`000?oooooooooo
ooooool0003oooooo`000?oooooo000000Kooooo00Co0000ooooool0003ooooo0_l00002ooooo`03
o`000?oooooo000000;ooooo00Co0000ooooool0003ooooo0_l00003ooooo`03o`000?oooooooooo
0?ooooooGOooool000?ooooo00Co0000ooooool0003ooooo0ol000000ooooooo0000o`000005oooo
o`;o000000Coooooo`000?oooooooooo0_l00003ooooo`?o00000_ooool2o`0000Cooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`3ooooooeSooooo0003ooooo`;o000000?oooooo`00
0?l000005oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo0?ooooooGOooool000?o
oooo00Go0000ooooooooooooooooo`00000Fooooo`;o00001oooool2o`000?ooooooGoooool00?oo
ooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0033o
oooo0_l0000=ooooo`;o0000oooooom7ooooo`00<?ooool00ol0003oooooooooo`0<ooooo`03o`00
0?oooooooooo0?ooooooA_ooool000Cooooo0_l00003ooooo`;o00001?ooool01?l0003ooooooooo
ooooool2o`0000;ooooo1?l00002ooooo`;o00000oooool2o`0000Oooooo0ol00002ooooo`?o0000
1oooool3o`0000;ooooo0ol00003ooooo`?o00000_ooool3o`0000;ooooo0ol000001?oooooo0000
o`000?l0003ooooooc;ooooo0003ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0
003oooooooooo`04ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000ooooooooooooooooo`00
0002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool01?ooool01_l0003ooooooooo
ool0003oooooo`0000;ooooo00?o0000ooooooooool01_ooool2o`000007ooooool0003ooooooooo
ool0003oooooo`000002ooooo`03o`000?oooooo000000Cooooo0_l00004ooooo`03o`000?oooooo
oooo0?oooooo<Oooool000?ooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`04
ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo00Cooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03
o`000?oooooooooo00Cooooo0_l00003ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000oooo
ool0003oooooo`000002ooooo`04o`000?oooooo0000ooooo`;o00000_ooool00ol0003ooooooooo
o`3ooooooc7ooooo0004ooooo`;o00001?ooool00ol0003oooooooooo`06ooooo`;o00001Oooool0
1Ol0003ooooooooooooooooo000000;ooooo0ol00007ooooo`?o00000_ooool3o`0000Sooooo0ol0
00001?oooooo0000o`000?l00002ooooo`?o00000oooool3o`0000;ooooo0_l00002ooooo`04o`00
0?oooooo0000o`000?oooooo<Oooool000?ooooo00Ko0000oooooooooooo0000ooooool00002oooo
o`03o`000?oooooooooo00Cooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oo
oooo000000;ooooo00?o0000ooooool000002Oooool00ol0003oooooooooo`3ooooooe[ooooo0004
ooooo`;o00000oooool2o`0000Sooooo0_l00003ooooo`;o00000oooool2o`0000;ooooo1?l00006
ooooo`03o`000?oooooooooo0?ooooooF_ooool00?ooooooR?ooool00?ooooooR?ooool00?oooooo
R?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?oooooo
R?ooool003Gooooo0ol00018ooooo`?o0000ooooool5ooooo`00=oooool2o`0004Wooooo0_l0003o
ooooo`Cooooo000eooooo`;o0000BOooool2o`000?oooooo1_ooool003Kooooo0ol00018ooooo`?o
0000ooooool4ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8oooo
o`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00FOooool00ol0003oooooooooo`3o
ooooobcooooo000Dooooo`03o`000?oooooooooo04?ooooo00?o0000ooooooooool0C?ooool00ol0
003oooooooooo`3Kooooo`004oooool00ol0003oooooooooo`14ooooo`03o`000?oooooooooo04go
oooo00?o0000ooooooooool0f_ooool001?ooooo00?o0000ooooooooool0U?ooool00ol0003ooooo
ooooo`3Jooooo`004_ooool00ol0003oooooooooo`02ooooo`Co000000?oooooo`000?l000000_l0
00000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l0
00000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l0
00000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l0
00000ooooooo0000o`000002o`000003ooooool0003o000000;o00002oooool4o`000003ooooool0
003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0
003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0
003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0
003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0
003o000000;o00001?ooool00ol0003oooooooooo`3Iooooo`004oooool00ol0003oooooooooo`2D
ooooo`03o`000?oooooooooo0=[ooooo000Cooooo`03o`000?oooooooooo09Cooooo00?o0000oooo
ooooool0f_ooool001Cooooo00?o0000ooooooooool0T_ooool00ol0003oooooooooo`3Kooooo`00
oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00E?ooool2o`0004kooooo0_l0003Qooooo`00E_ooool00ol0003oooooooooo`1=
ooooo`03o`000?oooooooooo0=kooooo000Gooooo`Co00000oooool01?l0003oooooooooooooool2
o`0000?ooooo0_l00003ooooo`;o00000_ooool4o`0000Oooooo0ol00002ooooo`;o00004_ooool3
o`0000cooooo0ol00003ooooo`04o`000?ooooooooooooooo`?o00000_ooool2o`0000?ooooo0_l0
0003ooooo`?o00000_ooool00ol0003oooooooooo`07ooooo`?o00000_ooool2o`0001;ooooo0ol0
003Pooooo`006?ooool00ol0003oooooooooo`06ooooo`06o`000?ooooooooooo`000?oooooo0000
0_ooool00ol0003oooooo`000002ooooo`04o`000?ooooooooooo`0000[ooooo00Co0000oooooooo
oooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`0000gooooo00?o0000
ooooooooool01oooool01?l0003oooooooooool00002ooooo`03o`000?oooooo000000;ooooo00Go
0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00Oooooo00Co0000oooooooooooo
00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`000>3ooooo000Iooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool00_ooool00ol0003oooooo`000002ooooo`05
o`000?ooooooooooooooool000002Oooool01?l0003oooooooooool00002ooooo`03o`000?oooooo
oooo00kooooo00Co0000oooooooooooo00003Oooool00ol0003oooooooooo`07ooooo`04o`000?oo
ooooooooo`0000;ooooo00?o0000ooooool000000_ooool01Ol0003ooooooooooooooooo000000?o
oooo0ol00008ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0
003oooooooooool0003Pooooo`006_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo
00?o00000oooool2o`0000Gooooo00?o0000ooooooooool01_ooool01?l0003oooooooooool00002
ooooo`03o`000?oooooooooo00oooooo0ol0000=ooooo`03o`000?oooooooooo00Oooooo00Co0000
oooooooooooo00000_ooool00ol0003oooooo`000002o`0000Cooooo00Co0000oooooooooooo0000
0_ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooooooo
ool03oooool3o`000>3ooooo000Gooooo`04o`000?ooooooooooo`0000Kooooo00Ko0000oooooooo
oooo0000ooooool00004ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003ooooo
ooooo`06ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool07oooool00ol0003o
ooooooooo`07ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00001Oooool0
1?l0003oooooooooool00002ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo0000
0_ooool00ol0003oooooooooo`3booooo`006?ooool2o`0000Sooooo0_l00002ooooo`Co00000_oo
ool2o`0000?ooooo0_l00008ooooo`;o00000oooool2o`00027ooooo0_l00008ooooo`;o00000ooo
ool2o`0000Cooooo00Co0000oooooooooooooooo0_l00003ooooo`;o00002?ooool2o`0000?ooooo
0_l0003eooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00B_ooool00ol0003oooooooooo`1=oooo
o`03o`000?oooooooooo0>[ooooo001:ooooo`03o`000?oooooooooo04gooooo00?o0000oooooooo
ool0j_ooool004Cooooo1?l00003ooooo`03o`000?oooooooooo04Kooooo1?l00003ooooo`03o`00
0?oooooooooo0>Wooooo001;ooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0jOoo
ool004Wooooo00Co0000oooooooooooo0000C?ooool01?l0003oooooooooool0003Zooooo`00BOoo
ool4o`0004cooooo1?l0003Zooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00^?ooool2o`0000?ooooo00?o0000oooo
ooooool0aoooool006kooooo00?o0000ooooooooool0BOooool01Ol0003ooooooooooooooooo0000
00gooooo00?o0000ooooooooool0^?ooool001;ooooo00Co0000oooooooooooo00000_ooool3o`00
0004ooooool0003o0000o`0000;ooooo0_l000001ooooooo0000o`000?oooooo0000ooooool00000
0_ooool2o`0000?ooooo0_l00003ooooo`Co00001Oooool3o`0000?ooooo0ol000001?oooooo0000
o`000?l00003ooooo`?o00000_ooool3o`0000?ooooo0_l000001?oooooo0000o`000?l00004oooo
o`03o`000?oooooooooo00Kooooo00Co0000oooooooooooooooo1?l00006ooooo`Co000000Cooooo
o`000?l0003o00000oooool3o`0000;ooooo0ol00007ooooo`Oo00000oooool3o`0000;ooooo0ol0
00001Ooooooo0000oooooooooooo000000;ooooo0ol000001Ooooooo0000oooooooooooo000000;o
oooo0ol00003ooooo`03o`000?oooooooooo00Co00000_ooool3o`0000?ooooo00?o0000oooooooo
ool0]oooool001;ooooo00?o0000ooooool000001?ooool01Ol0003ooooooooooooooooo000000Co
oooo00?o0000ooooool000000_ooool01Ol0003oooooo`000?oooooo000000;ooooo00?o0000oooo
ool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Gooooo00Co0000oooo
oooooooooooo0_l00005ooooo`;o000000Goooooo`000?ooooooooooo`000003ooooo`05o`000?oo
ooooooooooooool000001Oooool2o`0000cooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooooooo0_l00003ooooo`;o
00002?ooool01?l0003oooooooooool00002ooooo`05o`000?ooooooooooooooool000000_ooool0
1Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo00000oooool01?l0003ooooo
ooooool00002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0]oooool001;ooooo
0_l00005ooooo`05o`000?ooooooooooooooool000001?ooool2o`0000;ooooo00Co0000ooooool0
003ooooo0_l00002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool000000_ooool00ol0
003oooooooooo`05ooooo`06o`000?ooooooooooooooool0003ooooo0_l000000ooooooo0000o`00
0003ooooo`04o`000?ooooooooooo`0000?ooooo00Go0000ooooooooooooooooo`000003ooooo`;o
00003Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool00_ooool01_l0003ooooooooooooooooo0000ooooo`;o000000?oooooo`000?ooool00_l00000
0ooooooo0000o`000002o`000005ooooool0003oooooooooool000000_ooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooo000000?ooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooo
oooooooooooo000000;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo0;Kooooo000Booooo`;o00001?ooool2o`0000;ooooo00Co0000ooooool0003o00000_ooool0
2_l0003oooooo`000?oooooo0000ooooool0003oooooo`000?ooool2o`0000?ooooo0_l00003oooo
o`?o00001_ooool01?l0003oooooo`000?l00002ooooo`;o00000oooool3o`000005ooooool0003o
ooooooooool000000oooool00ol0003oooooooooo`04o`0000;ooooo0ol00003ooooo`03o`000?oo
oooooooo00Kooooo00Co0000oooooooooooooooo1?l00006ooooo`Co000000?oooooo`000?ooool0
0_l00002ooooo`;o00000oooool2o`0000Sooooo0ol000000ooooooo0000ooooo`02o`000004oooo
ool0003o0000o`0000?ooooo0_l00002ooooo`?o00000oooool2o`0000;ooooo0ol00003ooooo`?o
00001_ooool4o`0000?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2gooooo`00
4_ooool00ol0003oooooo`00000=ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool0
6_ooool01Ol0003ooooooooooooooooo000001?ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool0:?ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0]oooool001;ooooo
00Co0000oooooooooooo00000oooool00ol0003oooooooooo`05ooooo`;o00005?ooool2o`0001_o
oooo0_l0000Hooooo`03o`000?oooooooooo00;ooooo0_l00008ooooo`;o00005oooool2o`0000go
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Aooooo`;o00000_ooool2o`0000?o
oooo00?o0000ooooooooool0^?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
0?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool000?ooooo00Co0000
oooooooooooo00000_ooool3o`000004ooooool0003o0000o`0000;ooooo0_l000000ooooooo0000
o`000005ooooo`?o00001oooool01_l0003oooooo`000?oooooo0000ooooo`;o00000oooool4o`00
0004ooooool0003o0000o`0000;ooooo0ol00003ooooo`03o`000?oooooooooo0?ooooooA?ooool0
00?ooooo00?o0000ooooool000001?ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000
ooooool000002?ooool2o`0000Kooooo00Co0000ooooool0003ooooo0_l00002ooooo`03o`000?oo
oooo000000;ooooo00Co0000ooooool0003o00001Oooool00ol0003oooooooooo`3oooooodWooooo
0003ooooo`;o00001Oooool01Ol0003ooooooooooooooooo000000Cooooo0_l00007ooooo`;o0000
2?ooool01?l0003oooooo`000?ooool2o`0000;ooooo00?o0000ooooool000000_ooool01?l0003o
ooooo`000?ooool2o`0000?ooooo00?o0000ooooooooool0oooooom9ooooo`000oooool2o`0000Co
oooo0_l00002ooooo`04o`000?oooooo0000o`0000;ooooo00?o0000ooooool000001oooool3o`00
00Kooooo0_l000001?oooooo0000ooooooooool2o`0000?ooooo0ol00002ooooo`;o00001?ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo0?ooooooA?ooool000?ooooo00?o0000oooo
ool000003Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo01Sooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`3oooooodWooooo0003ooooo`04o`000?ooooooooooo`00
00?ooooo00?o0000ooooooooool01Oooool2o`0000Cooooo00?o0000ooooooooool05oooool2o`00
00Oooooo0_l0003ooooood_ooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo000e
ooooo`?o0000COooool3o`000?oooooo000gooooo`;o0000C_ooool2o`000?kooooo000eooooo`;o
0000C_ooool2o`000?oooooo0Oooool003Kooooo0ol0001=ooooo`?o0000o_ooool00?ooooooR?oo
ool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?oo
ool00?ooooooR?ooool005kooooo00?o0000ooooooooool0oooooolWooooo`005?ooool00ol0003o
ooooooooo`18ooooo`03o`000?oooooooooo04cooooo00?o0000ooooooooool0e_ooool001?ooooo
00?o0000ooooooooool0BOooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0=Gooooo
000Cooooo`03o`000?oooooooooo09Wooooo00?o0000ooooooooool0eOooool001;ooooo00?o0000
ooooooooool00_ooool4o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l00000
0ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l00000
0ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l00000
0ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l00000
0ooooooo0000o`000002o`000003ooooool0003o000000;o00002oooool4o`000003ooooool0003o
000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o
000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o
000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o
000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o
000000;o00001?ooool00ol0003oooooooooo`3Dooooo`004oooool00ol0003oooooooooo`2Ioooo
o`03o`000?oooooooooo0=Gooooo000Cooooo`03o`000?oooooooooo09Wooooo00?o0000oooooooo
ool0eOooool001Cooooo00?o0000ooooooooool0Uoooool00ol0003oooooooooo`3Fooooo`00oooo
oon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooo
oon8ooooo`00FOooool2o`0004kooooo0_l0003Looooo`00Foooool00ol0003oooooooooo`1=oooo
o`03o`000?oooooooooo0=Wooooo000Hooooo`?o00000oooool01Ol0003ooooooooooooooooo0000
00?ooooo1?l00002ooooo`;o00000oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00Gooooo0ol00002ooooo`;o00004_ooool3o`0000cooooo0ol00003ooooo`03o`000?oooooooooo
00?ooooo00Co0000oooooooooooo00001?ooool2o`0000;ooooo1?l00002ooooo`03o`000?oooooo
oooo00Oooooo0ol00002ooooo`;o00004_ooool3o`000=_ooooo000Iooooo`03o`000?oooooooooo
00Oooooo00Go0000ooooooooooooooooo`000003ooooo`04o`000?ooooooooooo`0000?ooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`0000;ooooo
00?o0000ooooooooool03_ooool01?l0003oooooooooool0000=ooooo`03o`000?oooooooooo00So
oooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`08ooooo`04o`000?ooooooooooo`0000;ooooo00?o
0000ooooooooool03_ooool01?l0003oooooooooool0003Kooooo`006Oooool00ol0003ooooooooo
o`06ooooo`?o00000oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?o000000?o
ooooo`000?l000000_l00008ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0
3_ooool01?l0003oooooooooool0000=ooooo`03o`000?oooooooooo00Gooooo1?l00002ooooo`?o
00001?ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool01oooool01?l0
003oooooooooool00002ooooo`03o`000?oooooooooo00kooooo00Co0000oooooooooooo0000fooo
ool001Wooooo00?o0000ooooooooool01Oooool01?l0003oooooooooool00004ooooo`05o`000?oo
ooooooooooooool000000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooo000000So
oooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0?ooooo`?o00003Oooool00ol0
003oooooooooo`06ooooo`05o`000?oooooo0000ooooool000000_ooool01Ol0003ooooooooooooo
oooo000000Gooooo00Go0000ooooooooooooooooo`000009ooooo`04o`000?ooooooooooo`0000;o
oooo00?o0000ooooooooool03oooool3o`000=_ooooo000Iooooo`03o`000?oooooooooo00Gooooo
00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooo000000;ooooo00?o0000oooo
ool000000_ooool01?l0003oooooooooooooool2o`0000Sooooo00Co0000oooooooooooo00000_oo
ool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00Oooooo0_l000001ooooooo0000oooo
oooooooo0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000;o
oooo00?o0000ooooooooool01_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo
0>gooooo000Hooooo`;o00002?ooool2o`0000?ooooo0_l00003ooooo`;o00000oooool2o`0000Go
oooo00?o0000ooooooooool01Oooool2o`0000?ooooo0_l0000Qooooo`;o00002_ooool00ol0003o
ooooooooo`02o`0000?ooooo0_l00003ooooo`;o00000_ooool4o`0000Oooooo0_l00003ooooo`;o
0000l?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?oo
ooooR?ooool00?ooooooR?ooool00?ooooooR?ooool004oooooo00?o0000ooooooooool0COooool0
0ol0003oooooooooo`3Uooooo`00Coooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo
0>Gooooo0019ooooo`Co00000oooool00ol0003oooooooooo`16ooooo`Co00000oooool00ol0003o
ooooooooo`3Tooooo`00D?ooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0>Cooooo
001>ooooo`04o`000?ooooooooooo`0004cooooo00Co0000oooooooooooo0000iOooool004kooooo
1?l0001<ooooo`Co0000iOooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?oo
ooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00;Sooooo0_l00003ooooo`03o`000?oooooo
oooo0<Oooooo001^ooooo`03o`000?oooooooooo04Wooooo00Go0000ooooooooooooooooo`00000=
ooooo`03o`000?oooooooooo0;Sooooo000Booooo`04o`000?ooooooooooo`0000;ooooo0ol00000
1?oooooo0000o`000?l00002ooooo`;o000000Ooooooo`000?l0003oooooo`000?oooooo000000;o
oooo0_l00003ooooo`;o00000oooool4o`0000Gooooo0ol00003ooooo`?o000000Coooooo`000?l0
003o00000oooool3o`0000;ooooo0ol00003ooooo`;o000000Coooooo`000?l0003o00001?ooool0
0ol0003oooooooooo`06ooooo`04o`000?ooooooooooooooo`Co00001_ooool4o`000004ooooool0
003o0000o`0000?ooooo0ol00002ooooo`?o00001oooool7o`0000?ooooo0ol00002ooooo`?o0000
00Goooooo`000?ooooooooooo`000002ooooo`?o000000Goooooo`000?ooooooooooo`000002oooo
o`?o00000oooool00ol0003oooooooooo`04o`0000;ooooo0ol00003ooooo`03o`000?oooooooooo
0;Oooooo000Booooo`03o`000?oooooo000000Cooooo00Go0000ooooooooooooooooo`000004oooo
o`03o`000?oooooo000000;ooooo00Go0000ooooool0003oooooo`000002ooooo`03o`000?oooooo
000000;ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`05ooooo`04o`000?oooooo
ooooooooo`;o00001Oooool2o`000005ooooool0003oooooooooool000000oooool01Ol0003ooooo
oooooooooooo000000Gooooo0_l0000<ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooooooo`;o00000oooool2o`00
00Sooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Go
0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000?ooooo00Co0000oooooooo
oooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0;Oooooo000Booooo`;o
00001Oooool01Ol0003ooooooooooooooooo000000Cooooo0_l00002ooooo`04o`000?oooooo0000
ooooo`;o00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000
ooooooooool01Oooool01_l0003ooooooooooooooooo0000ooooo`;o000000?oooooo`000?l00000
0oooool01?l0003oooooooooool00003ooooo`05o`000?ooooooooooooooool000000oooool2o`00
00gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00;ooooo00Ko0000ooooooooooooooooo`000?ooool2o`000003ooooool0003ooooo00;o000000?o
ooooo`000?l000000_l000001Ooooooo0000oooooooooooo000000;ooooo00?o0000ooooooooool0
0_ooool00ol0003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000oooooooo
ooooooooo`000002ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`2fooooo`004_ooool2o`0000Cooooo0_l00002ooooo`04o`000?oooooo0000o`0000;ooooo00[o
0000ooooool0003oooooo`000?oooooo0000ooooool0003ooooo0_l00003ooooo`;o00000oooool3
o`0000Kooooo00Co0000ooooool0003o00000_ooool2o`0000?ooooo0ol000001Ooooooo0000oooo
oooooooo000000?ooooo00?o0000ooooooooool01?l00002ooooo`?o00000oooool00ol0003ooooo
ooooo`06ooooo`04o`000?ooooooooooooooo`Co00001_ooool4o`000003ooooool0003ooooo00;o
00000_ooool2o`0000?ooooo0_l00008ooooo`?o000000?oooooo`000?ooool00_l000001?oooooo
0000o`000?l00003ooooo`;o00000_ooool3o`0000?ooooo0_l00002ooooo`?o00000oooool3o`00
00Kooooo1?l00003ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0]oooool001;o
oooo00?o0000ooooool000003Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo01[o
oooo00Go0000ooooooooooooooooo`00000Cooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo02Sooooo00?o0000oooo
ooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0;Oooooo000Booooo`04
o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool01Oooool2o`0001Cooooo0_l0000Koooo
o`;o00006?ooool00ol0003oooooooooo`02ooooo`;o00002?ooool2o`0001Oooooo0_l0000=oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool04Oooool2o`0000;ooooo0_l00003oooo
o`03o`000?oooooooooo0;Sooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo0009ooooo`03o`000?oooooooooo0?ooooooO?ooool000[ooooo
00?o0000ooooooooool0oooooomkooooo`000oooool01Ol0003ooooooooooooooooo000000;ooooo
00?o0000ooooooooool01Oooool01_l0003oooooo`000?oooooo0000ooooo`;o00000oooool4o`00
0004ooooool0003o0000o`0000;ooooo0ol00003ooooo`03o`000?oooooooooo0?ooooooF?ooool0
00?ooooo00Wo0000ooooooooooooooooo`000?oooooo0000ooooool000001_ooool01?l0003ooooo
o`000?ooool2o`0000;ooooo00?o0000ooooool000000_ooool01?l0003oooooo`000?l00005oooo
o`03o`000?oooooooooo0?ooooooGOooool000?ooooo00Wo0000ooooooooooooooooo`000?oooooo
0000ooooool000001_ooool01?l0003oooooo`000?ooool2o`0000;ooooo00?o0000ooooool00000
0_ooool01?l0003oooooo`000?ooool2o`0000?ooooo00?o0000ooooooooool0oooooomMooooo`00
0oooool01?l0003oooooo`000?ooool3o`000003ooooool0003o000000Gooooo0_l000001?oooooo
0000ooooooooool2o`0000?ooooo0ol00002ooooo`;o00001?ooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo0?ooooooF?ooool000?ooooo0_l000000ooooooo0000o`00000Gooooo`03
o`000?oooooooooo00Kooooo00?o0000ooooooooool0oooooomMooooo`000oooool01Ol0003ooooo
oooooooooooo000001Kooooo0_l00007ooooo`;o0000oooooomOooooo`00oooooon8ooooo`00oooo
oon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00<?oo
ool2o`0000gooooo0_l0003oooooodOooooo000`ooooo`03o`000?oooooooooo00cooooo00?o0000
ooooooooool0oooooom6ooooo`001?ooool2o`0000?ooooo00?o0000ooooooooool00oooool01?l0
003oooooooooooooool2o`0000?ooooo0_l00003ooooo`;o00000oooool2o`0000Oooooo0ol00002
ooooo`?o00001oooool3o`0000;ooooo0ol00003ooooo`?o00000_ooool3o`0000;ooooo0ol00000
1?oooooo0000o`000?l0003ooooooc;ooooo0003ooooo`04o`000?ooooooooooo`0000;ooooo00?o
0000ooooooooool01_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000ooooool0
00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Cooooo00Ko0000oooooooo
oooo0000ooooool00002ooooo`03o`000?oooooooooo00Kooooo0_l000001ooooooo0000oooooooo
oooo0000ooooool000000_ooool00ol0003oooooo`000004ooooo`;o00001?ooool00ol0003ooooo
ooooo`3ooooooc7ooooo0003ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool0
1Oooool01?l0003oooooooooool00004ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool0
00000_ooool00ol0003oooooooooo`04ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool0
0ol0003oooooooooo`04ooooo`;o00000oooool01?l0003oooooooooool00002ooooo`05o`000?oo
oooo0000ooooool000000_ooool01?l0003oooooo`000?ooool2o`0000;ooooo00?o0000oooooooo
ool0oooooolaooooo`000oooool3o`0000Cooooo00?o0000ooooooooool01Oooool01Ol0003ooooo
ooooool0003ooooo00?o00000oooool2o`0000?ooooo0_l00007ooooo`?o00000_ooool3o`0000So
oooo0ol000001?oooooo0000o`000?l00002ooooo`?o00000oooool3o`0000;ooooo0_l00002oooo
o`04o`000?oooooo0000o`000?oooooo<Oooool000Cooooo00Go0000ooooooooooooooooo`000002
ooooo`03o`000?oooooooooo00Cooooo00Ko0000oooooooooooo0000ooooool00004ooooo`06o`00
0?ooooooooooo`000?oooooo00000_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
0?ooooooF_ooool000Gooooo00?o0000ooooooooool01?l00007ooooo`;o00000_ooool4o`0000;o
oooo0_l00003ooooo`;o00001oooool00ol0003oooooooooo`3ooooooe[ooooo003oooooohSooooo
003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo
003oooooohSooooo000eooooo`?o0000COooool3o`000?oooooo000gooooo`;o0000C_ooool2o`00
0?kooooo000eooooo`;o0000C_ooool2o`000?oooooo0Oooool003Kooooo0ol0001=ooooo`?o0000
o_ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?oooooo
R?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool005kooooo00?o0000oooooooo
ool0oooooolWooooo`005?ooool00ol0003oooooooooo`18ooooo`03o`000?oooooooooo04cooooo
00?o0000ooooooooool0e_ooool001?ooooo00?o0000ooooooooool0BOooool00ol0003ooooooooo
o`1=ooooo`03o`000?oooooooooo0=Gooooo000Cooooo`03o`000?oooooooooo09Wooooo00?o0000
ooooooooool0eOooool001;ooooo00?o0000ooooooooool00_ooool4o`000003ooooool0003o0000
00;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o0000
00;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o0000
00;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o0000
00;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o0000
00;o00002oooool4o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooo
oooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooo
oooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooo
oooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooo
oooo0000o`000002o`000003ooooool0003o000000;o00001?ooool00ol0003oooooooooo`3Doooo
o`004oooool00ol0003oooooooooo`2Iooooo`03o`000?oooooooooo0=Gooooo000Cooooo`03o`00
0?oooooooooo09Wooooo00?o0000ooooooooool0eOooool001Cooooo00?o0000ooooooooool0Uooo
ool00ol0003oooooooooo`3Fooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00oooooon8ooooo`00FOooool2o`0004kooooo0_l0003Looooo`00Foooool00ol0
003oooooooooo`1=ooooo`03o`000?oooooooooo0=Wooooo000Gooooo`Co00000oooool01?l0003o
ooooooooooooool2o`0000Gooooo00?o0000ooooooooool00ol00002ooooo`;o00000oooool2o`00
00Sooooo0ol00002ooooo`;o00004_ooool3o`0000cooooo0ol00003ooooo`04o`000?oooooooooo
ooooo`;o00000oooool2o`0000;ooooo1?l00002ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool01Oooool3o`0000;ooooo0_l0000Booooo`?o0000foooool001Sooooo00?o0000oooo
ooooool01_ooool01?l0003oooooooooool00004ooooo`05o`000?ooooooooooooooool000000_oo
ool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000ooooooooool01_ooool01?l0003o
ooooooooool00002ooooo`03o`000?oooooooooo00kooooo00Co0000oooooooooooo00003Oooool0
0ol0003oooooooooo`05ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool01?l0003ooooo
ooooool00005ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01_ooool01?l0003o
ooooooooool00002ooooo`03o`000?oooooooooo00kooooo00Co0000oooooooooooo0000foooool0
01Wooooo00?o0000ooooooooool01Oooool01Ol0003oooooooooool0003ooooo00Co00000oooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01_ooool0
1?l0003oooooooooool00002ooooo`03o`000?oooooooooo00kooooo00Co0000oooooooooooo0000
3Oooool00ol0003oooooooooo`05ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool01Ol0
003ooooooooooooooooo000000?ooooo0ol000000ooooooo0000o`000002o`0000Sooooo00Co0000
oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`000=_ooooo
000Jooooo`03o`000?oooooooooo00Cooooo00Co0000oooooooooooo00000_ooool00ol0003ooooo
o`000003ooooo`03o`000?oooooooooo00?o00000_ooool3o`0000Wooooo00Co0000oooooooooooo
00000_ooool00ol0003oooooooooo`0?ooooo`?o00003Oooool00ol0003oooooooooo`05ooooo`05
o`000?ooooooooooo`000?ooool00ol00005ooooo`03o`000?oooooo000000;ooooo00Ko0000oooo
oooooooo0000ooooool00008ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0
3oooool3o`000=_ooooo000Gooooo`04o`000?ooooooooooo`0000Kooooo00Co0000oooooooooooo
00000oooool2o`0000?ooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`09oooo
o`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool07oooool00ol0003oooooooooo`05
ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`00
0?oooooo000000;ooooo00Co0000oooooooooooooooo0_l00008ooooo`04o`000?ooooooooooo`00
00;ooooo00?o0000ooooooooool0kOooool001Sooooo0_l00008ooooo`;o00001Oooool00ol0003o
ooooooooo`02o`0000;ooooo1?l000000ooooooo0000o`000002o`0000Oooooo0_l00003ooooo`;o
00008Oooool2o`0000Sooooo0_l00004ooooo`04o`000?ooooooooooooooo`;o00000oooool2o`00
00Gooooo00?o0000ooooooooool01Oooool2o`0000?ooooo0_l0003`ooooo`00oooooon8ooooo`00
oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00oooooon8ooooo`00Coooool00ol0003oooooooooo`1=ooooo`03o`000?oooooo
oooo0>Gooooo001?ooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0iOooool004Wo
oooo1?l00003ooooo`03o`000?oooooooooo04Kooooo1?l00003ooooo`03o`000?oooooooooo0>Co
oooo001@ooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0i?ooool004kooooo00Co
0000oooooooooooo0000C?ooool01?l0003oooooooooool0003Uooooo`00C_ooool4o`0004cooooo
1?l0003Uooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00^?ooool2o`0000?ooooo00?o0000ooooooooool0aoooool006kooooo00?o0000
ooooooooool0BOooool01Ol0003ooooooooooooooooo000000gooooo00?o0000ooooooooool0^?oo
ool001;ooooo00Co0000oooooooooooo00000_ooool3o`000004ooooool0003o0000o`0000;ooooo
0_l000001ooooooo0000o`000?oooooo0000ooooool000000_ooool2o`0000?ooooo0_l00003oooo
o`Co00001Oooool3o`0000?ooooo0ol000001?oooooo0000o`000?l00003ooooo`?o00000_ooool3
o`0000?ooooo0_l000001?oooooo0000o`000?l00004ooooo`03o`000?oooooooooo00Kooooo00Co
0000oooooooooooooooo1?l00006ooooo`Co000000Coooooo`000?l0003o00000oooool3o`0000;o
oooo0ol00007ooooo`Oo00000oooool3o`0000;ooooo0ol000001Ooooooo0000oooooooooooo0000
00;ooooo0ol000001Ooooooo0000oooooooooooo000000;ooooo0ol00003ooooo`03o`000?oooooo
oooo00Co00000_ooool3o`0000?ooooo00?o0000ooooooooool0]oooool001;ooooo00?o0000oooo
ool000001?ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooool000000_ooool0
1Ol0003oooooo`000?oooooo000000;ooooo00?o0000ooooool000000_ooool00ol0003oooooo`00
0002ooooo`03o`000?oooooooooo00Gooooo00Co0000oooooooooooooooo0_l00005ooooo`;o0000
00Goooooo`000?ooooooooooo`000003ooooo`05o`000?ooooooooooooooool000001Oooool2o`00
00cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00;ooooo00Co0000oooooooooooooooo0_l00003ooooo`;o00002?ooool01?l0003oooooooooool0
0002ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooooooooooo000000;o
oooo00Co0000oooooooooooo00000oooool01?l0003oooooooooool00002ooooo`03o`000?oooooo
000000;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool0]oooool001;ooooo0_l00005ooooo`05o`000?oooooooooo
ooooool000001?ooool2o`0000;ooooo00Co0000ooooool0003ooooo0_l00002ooooo`03o`000?oo
oooo000000;ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`05ooooo`06o`000?oo
ooooooooooooool0003ooooo0_l000000ooooooo0000o`000003ooooo`04o`000?ooooooooooo`00
00?ooooo00Go0000ooooooooooooooooo`000003ooooo`;o00003Oooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00_ooool01_l0003ooooooooooooo
oooo0000ooooo`;o000000?oooooo`000?ooool00_l000000ooooooo0000o`000002o`000005oooo
ool0003oooooooooool000000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo000000?o
oooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Ko0000
oooooooooooo0000ooooool00002ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo0;Kooooo000Booooo`;o00001?oo
ool2o`0000;ooooo00Co0000ooooool0003o00000_ooool02_l0003oooooo`000?oooooo0000oooo
ool0003oooooo`000?ooool2o`0000?ooooo0_l00003ooooo`?o00001_ooool01?l0003oooooo`00
0?l00002ooooo`;o00000oooool3o`000005ooooool0003oooooooooool000000oooool00ol0003o
ooooooooo`04o`0000;ooooo0ol00003ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooo
oooooooo1?l00006ooooo`Co000000?oooooo`000?ooool00_l00002ooooo`;o00000oooool2o`00
00Sooooo0ol000000ooooooo0000ooooo`02o`000004ooooool0003o0000o`0000?ooooo0_l00002
ooooo`?o00000oooool2o`0000;ooooo0ol00003ooooo`?o00001_ooool4o`0000?ooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`2gooooo`004_ooool00ol0003oooooo`00000=oooo
o`03o`000?oooooooooo01?ooooo00?o0000ooooooooool06_ooool01Ol0003ooooooooooooooooo
000001?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooo
oooo01Sooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool0]oooool001;ooooo00Co0000oooooooooooo00000oooool0
0ol0003oooooooooo`05ooooo`;o00005?ooool2o`0001_ooooo0_l0000Hooooo`03o`000?oooooo
oooo00;ooooo0_l00008ooooo`;o00005oooool2o`0000gooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`0Aooooo`;o00000_ooool2o`0000?ooooo00?o0000ooooooooool0^?ooool0
0?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
0?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool000?ooooo00Co0000oooooooooooo0000
0_ooool3o`000004ooooool0003o0000o`0000;ooooo0_l000000ooooooo0000o`000005ooooo`?o
00001oooool01_l0003oooooo`000?oooooo0000ooooo`;o00000oooool4o`000004ooooool0003o
0000o`0000;ooooo0ol00003ooooo`03o`000?oooooooooo0?ooooooA?ooool000?ooooo00?o0000
ooooool000001?ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooool000002?oo
ool2o`0000Kooooo00Co0000ooooool0003ooooo0_l00002ooooo`03o`000?oooooo000000;ooooo
00Co0000ooooool0003o00001Oooool00ol0003oooooooooo`3oooooodWooooo0003ooooo`;o0000
1Oooool01Ol0003ooooooooooooooooo000000Cooooo0_l00007ooooo`;o00002?ooool01?l0003o
ooooo`000?ooool2o`0000;ooooo00?o0000ooooool000000_ooool01?l0003oooooo`000?ooool2
o`0000?ooooo00?o0000ooooooooool0oooooom9ooooo`000oooool2o`0000Cooooo0_l00002oooo
o`04o`000?oooooo0000o`0000;ooooo00?o0000ooooool000001oooool3o`0000Kooooo0_l00000
1?oooooo0000ooooooooool2o`0000?ooooo0ol00002ooooo`;o00001?ooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo0?ooooooA?ooool000?ooooo00?o0000ooooool000003Oooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool01_ooool0
0ol0003oooooooooo`3oooooodWooooo0003ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000
ooooooooool01Oooool2o`0000Cooooo00?o0000ooooooooool05oooool2o`0000Oooooo0_l0003o
oooood_ooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo000eooooo`?o0000COooool3o`000?oooooo
000gooooo`;o0000C_ooool2o`000?kooooo000eooooo`;o0000C_ooool2o`000?oooooo0Oooool0
03Kooooo0ol0001=ooooo`?o0000o_ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?oo
ool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?oo
ool005kooooo00?o0000ooooooooool0oooooolWooooo`005?ooool00ol0003oooooooooo`18oooo
o`03o`000?oooooooooo04cooooo00?o0000ooooooooool0e_ooool001?ooooo00?o0000oooooooo
ool0BOooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0=Gooooo000Cooooo`03o`00
0?oooooooooo09Wooooo00?o0000ooooooooool0eOooool001;ooooo00?o0000ooooooooool00_oo
ool4o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`00
0002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`00
0002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`00
0002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`00
0002o`000003ooooool0003o000000;o00002oooool4o`000003ooooool0003o000000;o000000?o
ooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?o
ooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?o
ooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?o
ooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o00001?oo
ool00ol0003oooooooooo`3Dooooo`004oooool00ol0003oooooooooo`2Iooooo`03o`000?oooooo
oooo0=Gooooo000Cooooo`03o`000?oooooooooo09Wooooo00?o0000ooooooooool0eOooool001Co
oooo00?o0000ooooooooool0Uoooool00ol0003oooooooooo`3Fooooo`00oooooon8ooooo`00oooo
oon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00FOooool2o`0004kooooo
0_l0003Looooo`00Foooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0=Wooooo000H
ooooo`?o00000oooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool00_oo
ool2o`0000?ooooo0_l00005ooooo`03o`000?oooooooooo00Gooooo0ol00002ooooo`;o00004_oo
ool3o`0000cooooo0ol00003ooooo`04o`000?ooooooooooooooo`;o00000oooool2o`0000?ooooo
00Co0000oooooooooooooooo1?l00004ooooo`03o`000?oooooooooo00Gooooo0ol00002ooooo`;o
00004_ooool3o`000=_ooooo000Iooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0
0oooool01?l0003oooooooooool00002ooooo`03o`000?oooooo000000;ooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooo
ooooool03_ooool01?l0003oooooooooool0000=ooooo`03o`000?oooooooooo00Gooooo00Ko0000
oooooooooooo0000ooooool00002ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooo
ooooool03_ooool01?l0003oooooooooool0003Kooooo`006Oooool00ol0003oooooooooo`07oooo
o`04o`000?ooooooooooooooo`?o000000Goooooo`000?ooooooooooo`000004ooooo`03o`000?oo
oooo000000?o00002?ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00kooooo
00Co0000oooooooooooo00003Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo000000;o
oooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00Co00002?ooool01?l0
003oooooooooool00002ooooo`03o`000?oooooooooo00kooooo00Co0000oooooooooooo0000fooo
ool001Wooooo00?o0000ooooooooool01oooool01?l0003oooooooooool00002ooooo`03o`000?oo
oooo000000;o00001?ooool01ol0003ooooooooooooooooo0000ooooool000002?ooool01?l0003o
ooooooooool00002ooooo`03o`000?oooooooooo00oooooo0ol0000=ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool00ol00004ooooo`03o`000?oooooooooo00?ooooo00Ko0000oooo
oooooooo0000ooooool00008ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0
3oooool3o`000=_ooooo000Iooooo`03o`000?oooooooooo00Gooooo00Ko0000oooooooooooo0000
ooooool00002ooooo`04o`000?ooooooooooo`0000?ooooo00Co0000oooooooooooo00000oooool2
o`0000Sooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0Oooooo`03o`000?oo
oooooooo00Gooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo000000;o
oooo00?o0000ooooool000000_ooool01?l0003oooooooooooooool2o`0000Sooooo00Co0000oooo
oooooooo00000_ooool00ol0003oooooooooo`3]ooooo`006?ooool2o`0000Oooooo1?l00002oooo
o`;o00001?ooool01?l0003oooooooooooooool2o`0000Gooooo00?o0000ooooooooool01Oooool2
o`0000?ooooo0_l0000Qooooo`;o00002?ooool2o`0000Cooooo00?o0000ooooooooool01?l00002
ooooo`;o00001Oooool00ol0003oooooooooo`05ooooo`;o00000oooool2o`000?3ooooo003ooooo
ohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003ooooo
ohSooooo003oooooohSooooo003oooooohSooooo001?ooooo`03o`000?oooooooooo04gooooo00?o
0000ooooooooool0iOooool004oooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`3U
ooooo`00BOooool4o`0000?ooooo00?o0000ooooooooool0A_ooool4o`0000?ooooo00?o0000oooo
ooooool0i?ooool0053ooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`3Tooooo`00
C_ooool01?l0003oooooooooool0001<ooooo`04o`000?ooooooooooo`000>Gooooo001>ooooo`Co
0000C?ooool4o`000>Gooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003ooooo
ohSooooo003oooooohSooooo002hooooo`;o00000oooool00ol0003oooooooooo`37ooooo`00K_oo
ool00ol0003oooooooooo`19ooooo`05o`000?ooooooooooooooool000003Oooool00ol0003ooooo
ooooo`2hooooo`004_ooool01?l0003oooooooooool00002ooooo`?o000000Coooooo`000?l0003o
00000_ooool2o`000007ooooool0003o0000ooooool0003oooooo`000002ooooo`;o00000oooool2
o`0000?ooooo1?l00005ooooo`?o00000oooool3o`000004ooooool0003o0000o`0000?ooooo0ol0
0002ooooo`?o00000oooool2o`000004ooooool0003o0000o`0000Cooooo00?o0000ooooooooool0
1_ooool01?l0003oooooooooooooool4o`0000Kooooo1?l000001?oooooo0000o`000?l00003oooo
o`?o00000_ooool3o`0000Oooooo1ol00003ooooo`?o00000_ooool3o`000005ooooool0003ooooo
ooooool000000_ooool3o`000005ooooool0003oooooooooool000000_ooool3o`0000?ooooo00?o
0000ooooooooool01?l00002ooooo`?o00000oooool00ol0003oooooooooo`2gooooo`004_ooool0
0ol0003oooooo`000004ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooo`00
0002ooooo`05o`000?oooooo0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`00
0?oooooo000000;ooooo00?o0000ooooooooool01Oooool01?l0003oooooooooooooool2o`0000Go
oooo0_l000001Ooooooo0000oooooooooooo000000?ooooo00Go0000ooooooooooooooooo`000005
ooooo`;o00003?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool00_ooool01?l0003oooooooooooooool2o`0000?ooooo0_l00008ooooo`04o`000?oo
ooooooooo`0000;ooooo00Go0000ooooooooooooooooo`000002ooooo`05o`000?oooooooooooooo
ool000000_ooool01?l0003oooooooooool00003ooooo`04o`000?ooooooooooo`0000;ooooo00?o
0000ooooool000000_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`2gooooo`004_ooool2o`0000Gooooo00Go0000
ooooooooooooooooo`000004ooooo`;o00000_ooool01?l0003oooooo`000?ooool2o`0000;ooooo
00?o0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Gooooo
00Ko0000ooooooooooooooooo`000?ooool2o`000003ooooool0003o000000?ooooo00Co0000oooo
oooooooo00000oooool01Ol0003ooooooooooooooooo000000?ooooo0_l0000=ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`02ooooo`06o`000?oo
ooooooooooooool0003ooooo0_l000000ooooooo0000ooooo`02o`000003ooooool0003o000000;o
000000Goooooo`000?ooooooooooo`000002ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ool000000oooool01?l0003oooooooooool00002ooooo`05o`000?ooooooooooooooool000000_oo
ool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0]_ooool001;ooooo
0_l00004ooooo`;o00000_ooool01?l0003oooooo`000?l00002ooooo`0:o`000?oooooo0000oooo
ool0003oooooo`000?oooooo0000ooooo`;o00000oooool2o`0000?ooooo0ol00006ooooo`04o`00
0?oooooo0000o`0000;ooooo0_l00003ooooo`?o000000Goooooo`000?ooooooooooo`000003oooo
o`03o`000?oooooooooo00Co00000_ooool3o`0000?ooooo00?o0000ooooooooool01_ooool01?l0
003oooooooooooooool4o`0000Kooooo1?l000000ooooooo0000ooooo`02o`0000;ooooo0_l00003
ooooo`;o00002?ooool3o`000003ooooool0003ooooo00;o000000Coooooo`000?l0003o00000ooo
ool2o`0000;ooooo0ol00003ooooo`;o00000_ooool3o`0000?ooooo0ol00006ooooo`Co00000ooo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0;Oooooo000Booooo`03o`000?oooooo
000000gooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0Jooooo`05o`000?oooooo
ooooooooool000004oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool06?ooool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`2gooooo`004_ooool01?l0003oooooooooool0
0003ooooo`03o`000?oooooooooo00Gooooo0_l0000Dooooo`;o00006oooool2o`0001Sooooo00?o
0000ooooooooool00_ooool2o`0000Sooooo0_l0000Gooooo`;o00003Oooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo017ooooo0_l00002ooooo`;o00000oooool00ol0003ooooooooo
o`2hooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooo
oon8ooooo`00oooooon8ooooo`002Oooool00ol0003oooooooooo`3oooooogcooooo000:ooooo`03
o`000?oooooooooo0?ooooooNoooool000?ooooo00Go0000ooooooooooooooooo`000002ooooo`03
o`000?oooooooooo00Gooooo00Ko0000ooooool0003oooooo`000?ooool2o`0000?ooooo1?l00000
1?oooooo0000o`000?l00002ooooo`?o00000oooool00ol0003oooooooooo`3ooooooeSooooo0003
ooooo`09o`000?ooooooooooooooool0003oooooo`000?oooooo000000Kooooo00Co0000ooooool0
003ooooo0_l00002ooooo`03o`000?oooooo000000;ooooo00Co0000ooooool0003o00001Oooool0
0ol0003oooooooooo`3ooooooegooooo0003ooooo`09o`000?ooooooooooooooool0003oooooo`00
0?oooooo000000Kooooo00Co0000ooooool0003ooooo0_l00002ooooo`03o`000?oooooo000000;o
oooo00Co0000ooooool0003ooooo0_l00003ooooo`03o`000?oooooooooo0?ooooooGOooool000?o
oooo00Co0000ooooool0003ooooo0ol000000ooooooo0000o`000005ooooo`;o000000Coooooo`00
0?oooooooooo0_l00003ooooo`?o00000_ooool2o`0000Cooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`3ooooooeSooooo0003ooooo`;o000000?oooooo`000?l000005oooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo0?ooooooGOooool000?ooooo00Go0000oooooooo
ooooooooo`00000Fooooo`;o00001oooool2o`000?ooooooGoooool00?ooooooR?ooool00?oooooo
R?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0033ooooo0_l0000=ooooo`;o
0000oooooom7ooooo`00<?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo0?oooooo
A_ooool000Cooooo0_l00003ooooo`;o00001?ooool00ol0003oooooooooo`04o`0000;ooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`03o`0000Kooooo0ol00002ooooo`?o00001ooo
ool3o`0000;ooooo0ol00003ooooo`?o00000_ooool3o`0000;ooooo0ol000001?oooooo0000o`00
0?l0003ooooooc;ooooo0003ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool01Ol0003o
oooooooooooooooo000000Oooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oo
oooooooo00Kooooo0_l000001ooooooo0000oooooooooooo0000ooooool000000_ooool00ol0003o
ooooo`000004ooooo`;o00001?ooool00ol0003oooooooooo`3ooooooc7ooooo0006ooooo`03o`00
0?oooooo000000;ooooo00?o0000ooooooooool01_ooool01?l0003oooooooooooooool3o`000003
ooooool0003o000000;o00000oooool00ol0003oooooooooo`05ooooo`06o`000?ooooooooooo`00
0?oooooo00000_ooool00ol0003oooooooooo`04ooooo`;o00000oooool01?l0003oooooooooool0
0002ooooo`05o`000?oooooo0000ooooool000000_ooool01?l0003oooooo`000?ooool2o`0000;o
oooo00?o0000ooooooooool0oooooolaooooo`000oooool3o`0000;ooooo00Co0000oooooooooooo
00002Oooool00ol0003oooooo`000002ooooo`06o`000?ooooooooooo`000?oooooo00000oooool0
0ol0003oooooooooo`05ooooo`?o00000_ooool3o`0000Sooooo0ol000001?oooooo0000o`000?l0
0002ooooo`?o00000oooool3o`0000;ooooo0_l00002ooooo`04o`000?oooooo0000o`000?oooooo
<Oooool000?ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00006ooooo`06o`00
0?ooooooooooo`000?oooooo00000_ooool01?l0003oooooooooooooool2o`0000?ooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`3ooooooe[ooooo0003ooooo`Co00000_ooool2o`00
00Sooooo0_l00003ooooo`;o00001Oooool00ol0003oooooooooo`02o`0000Oooooo00?o0000oooo
ooooool0oooooomJooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8
ooooo`00oooooon8ooooo`00oooooon8ooooo`00\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
MatrixForm[Transpose[{N[nbasepairs,3],N[f1robert,4],N[f1Kirk,4]}]]\
\
\>", "Input",
  AspectRatioFixed->False,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!PS-Adobe-2.0 EPSF-1.2
%%BoundingBox: 6 6 336 344
%%HiResBoundingBox: 6 6 336 343.5
%%Creator: (Mathematica 5.2 for Macintosh)
%%CreationDate: (Monday, March 30, 2020) (20:39:34)
%%Title: Clipboard
%%DocumentNeededResources: (atend)
%%DocumentFonts: (atend)
%%DocumentNeededFonts: (atend)
%%EndComments
0 349.5 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def

%%MathematicaCell
%Cell[GraphicsData[\"PICT\", \\
%\"\\<\\
%24X04`0X0?@1100A0_l<0?ooool0:00001<\\
%000440000m0000000000N00402P0C
%02P0m09@02`02P0F1d=_MG9YIG800`0F00d02@0^00@0000002/Y6bPP820P820P
%820P820P820P820P820P82dg820P820P820P820P82dg000Z1BXP820P820P820P
%820P820a;S<f=b0a<20P86LP820a;S0f<b0a<20P86L0:PDZ820P820P820P820P
%820P;Bd];Bd];Bd];Bd]820P;Bd];Bd];Bd];Bd]02T2:R0P820P820P820P820P
%82d];Bd];Bd];Bd]820P82d];Bd];Bd];Bd]800X02X0:B@e<2hc820P820P820P
%820P820P87<P820P820P820P820P87<002X::20P820P820P820P820P820P820P
%820P;CLP820P820P820P820P;CL0:PDZ820P820P820P820P820P<Bhd>C<P<C0P
%821W820P<Bha<3HP<C0P821W02X5:R0P820P820P820P820P82d];Bd];Bd];Bd]
%;B0P82d];Bd];Bd];Bd];@0Y0RXP820P820P820P820P820];Bd];Bd];Bd];B0P
%820];Bd];Bd];Bd];B00:01302TT=SL^<B0P820P820P820P820P821c820P820P
%820P820P821c000Z2RPP820P820P820P820P820P820P820P82dg820P820P820P
%820P82dg02X5:R0P820P820P820P820P834^=S4f834`820PIb0P834^<CDh834`
%820PI`0Z1BXP820P820P820P820P820];Bd];Bd];Bd];BdP820];Bd];Bd];Bd]
%;Bd0:@8Z820P820P820P820P820P;Bd];Bd];Bd];BdP820P;Bd];Bd];Bd];BdP
%02P0G00Y93Pc;SPP820P820P820P820P820PLb0P820P820P820P820PL`00:PXX
%820P820P820P820P820P820P820P820]=b0P820P820P820P820]=`0Z1BXP820P
%820P820P820P820a;SLc=R0a<20P86LP820a;S8a=20a<20P86L0:PDZ820P820P
%820P820P820P;Bd];Bd];Bd];Bd]820P;Bd];Bd];Bd];Bd]02T2:R0P820P820P
%820P820P82d];Bd];Bd];Bd]820P82d];Bd];Bd];Bd]800X07D0:B@a<34^820P
%820P820P820P820P87<P820P820P820P820P87<002X::20P820P820P820P820P
%820P820P820P;CLP820P820P820P820P;CL0:PDZ820P820P820P820P820P<Bhi
%=SPP<C0P821W820P<Bhc<c@P<C0P821W02X5:R0P820P820P820P820P82d];Bd]
%;Bd];Bd];B0P82d];Bd];Bd];Bd];@0Y0RXP820P820P820P820P820];Bd];Bd]
%;Bd];B0P820];Bd];Bd];Bd];B00:02>02TT<C<d;R0P820P820P820P820P821c
%820P820P820P820P821c000Z2RPP820P820P820P820P820P820P820P82dg820P
%820P820P820P82dg02X5:R0P820P820P820P820P838^<CTb834`820PIb0P834^
%=3Dg834`820PI`0Z1BXP820P820P820P820P820];Bd];Bd];Bd];BdP820];Bd]
%;Bd];Bd];Bd0:@8Z820P820P820P820P820P;Bd];Bd];Bd];BdP820P;Bd];Bd]
%;Bd];BdP02P0Y`0Y934f>2hP820P820P820P820P820PLb0P820P820P820P820P
%L`00:PXX820P820P820P820P820P820P820P820]=b0P820P820P820P820]=`0Z
%1BXP820P820P820P820P820b;S@`>20a<20P86LP820a;SDh<B0a<20P86L0:PDZ
%820P820P820P820P820P;Bd];Bd];Bd];Bd]820P;Bd];Bd];Bd];Bd]02T2:R0P
%820P820P820P820P82d];Bd];Bd];Bd]820P82d];Bd];Bd];Bd]800X0<00:B@b
%<34^820P820P820P820P820P87<P820P820P820P820P87<002X::20P820P820P
%820P820P820P820P820P;CLP820P820P820P820P;CL0:PDZ820P820P820P820P
%820P<Rhf<CPP<C0P821W820P<Bhg<3DP<C0P821W02X5:R0P820P820P820P820P
%82d];Bd];Bd];Bd];B0P82d];Bd];Bd];Bd];@0Y0RXP820P820P820P820P820]
%;Bd];Bd];Bd];B0P820];Bd];Bd];Bd];B00:03I02TT<S<e;R0P820P820P820P
%820P821c820P820P820P820P821c000Z2RPP820P820P820P820P820P820P820P
%82dg820P820P820P820P82dg02X5:R0P820P820P820P820P838^>38c834`820P
%Ib0P834^>38h834`820PI`0Z1BXP820P820P820P820P820];Bd];Bd];Bd];BdP
%820];Bd];Bd];Bd];Bd0:@8Z820P820P820P820P820P;Bd];Bd];Bd];BdP820P
%;Bd];Bd];Bd];BdP02P0lP0Y938f>2hP820P820P820P820P820PLb0P820P820P
%820P820PL`00o`\\>\"], \"Graphics\",
%  ImageSize->{220, 225},
%  ImageMargins->{{0, Inherited}, {Inherited, Inherited}},
%  ImageRegion->{{-0, 1}, {0, 1}},
%  FontSize->9]
%%EndMathematicaCell
1.5 setlinewidth
/Courier findfont 9 scalefont setfont
8 18 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
8 26 moveto (               1.367 10   g   1.063 10   g) show
/Courier findfont 9 scalefont setfont
8 33 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
11 33 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
8 41 moveto (50.3                s              s) show
/Courier findfont 9 scalefont setfont
8 56 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
8 63 moveto (               1.493 10   g   1.106 10   g) show
/Courier findfont 9 scalefont setfont
8 71 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
11 71 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
8 78 moveto (67.1                s              s) show
/Courier findfont 9 scalefont setfont
8 93 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
8 101 moveto (               1.616 10   g   1.158 10   g) show
/Courier findfont 9 scalefont setfont
8 108 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
11 108 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
8 116 moveto (83.8                s              s) show
/Courier findfont 9 scalefont setfont
8 131 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
8 138 moveto (               1.736 10   g   1.214 10   g) show
/Courier findfont 9 scalefont setfont
8 146 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
11 146 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
8 153 moveto (101.                s              s) show
/Courier findfont 9 scalefont setfont
8 168 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
8 175 moveto (               1.968 10   g   1.334 10   g) show
/Courier findfont 9 scalefont setfont
8 183 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
11 183 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
8 190 moveto (134.                s              s) show
/Courier findfont 9 scalefont setfont
8 205 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
8 213 moveto (               2.192 10   g   1.457 10   g) show
/Courier findfont 9 scalefont setfont
8 220 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
11 220 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
8 228 moveto (168.                s              s) show
/Courier findfont 9 scalefont setfont
8 243 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
8 250 moveto (               2.408 10   g   1.581 10   g) show
/Courier findfont 9 scalefont setfont
8 258 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
11 258 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
8 265 moveto (201.                s              s) show
/Courier findfont 9 scalefont setfont
8 280 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
8 288 moveto (               2.618 10   g   1.705 10   g) show
/Courier findfont 9 scalefont setfont
8 295 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
11 295 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
8 303 moveto (235.                s              s) show
/Courier findfont 9 scalefont setfont
8 318 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
8 325 moveto (               2.823 10   g   1.828 10   g) show
/Courier findfont 9 scalefont setfont
8 333 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
11 333 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
8 340 moveto (268.                s              s) show
%%Trailer
%%EOF
\
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{330, 337.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  FontSize->9,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007_0001nR000`400?l00000o`00003oooooooo`
ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`001?ooool6
o`0000Cooooo0_l00005ooooo`Co00001Oooool00ol0003oooooooooo`23ooooo`Go0000Loooool5
o`000<kooooo0004ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`000002
ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`28ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool0L?ooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo0<_ooooo0005ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool0
1?l0003oooooooooool00004ooooo`03o`000?oooooooooo08gooooo00?o0000ooooooooool0MOoo
ool00ol0003oooooooooo`3;ooooo`001_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00;ooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`29ooooo`Co0000M?oo
ool4o`000<kooooo0007ooooo`03o`000?oooooooooo00;ooooo0_l00002ooooo`03o`000?oooooo
oooo00;ooooo1?l0002;ooooo`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0d?ooool0
00Sooooo00Ko0000ooooooooooooooooo`000?ooool2o`0000Cooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`28ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0L?oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0<_ooooo0009ooooo`04o`000?oooooo
ooooo`0000Oooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`29ooooo`Go0000Looo
ool5o`000<gooooo0004ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`00
0006ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0oooooooDooooo`001Oooool4
o`0000Gooooo0_l00005ooooo`Co0000oooooooGooooo`00ooooooo`ooooo`00ooooooo`ooooo`00
ooooooo`ooooo`00ooooooo`ooooo`00NooooomOo`0001WoooooGol0002Mooooo`00ooooooo`oooo
o`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00eOooool3o`00
07Gooooo0ol0002Oooooo`00f?ooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo09co
oooo003Iooooo`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0Voooool007cooooo1_l0
0004ooooo`03o`000?oooooooooo00Cooooo1?l00003ooooo`Ko00000oooool4o`0000_ooooo1Ol0
0004ooooo`?o00007Oooool3o`000003ooooool0003ooooo01Wooooo1Ol00005ooooo`03o`000?oo
oooooooo00Cooooo1?l00003ooooo`Ko00000oooool4o`0000_ooooo1Ol00004ooooo`?o00007Ooo
ool3o`000003ooooool0003ooooo09cooooo001looooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Cooooo00Co
0000oooooooooooo00001?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00?ooooo
00Go0000ooooooooooooooooo`00000Kooooo`04o`000?ooooooooooooooo`;o00007?ooool00ol0
003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00001?ooool0
1?l0003oooooooooool00004ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00ooo
ool01Ol0003ooooooooooooooooo000001_ooooo00Co0000oooooooooooooooo0_l0002Mooooo`00
OOooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00;ooooo00Go0000oooooooooooo
ooooo`00000;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00oooool01Ol0003o
oooooooooooooooo000001[ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Joooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo
000000Kooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00?ooooo00Go0000ooooooooooooooooo`00000Jooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool0Voooool007kooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000Jooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`03ooooo`05o`000?oo
ooooooooooooool000006_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo09_ooooo
001oooooo`03o`000?oooooooooo00_ooooo1?l00006ooooo`03o`000?oooooooooo00Cooooo0ol0
000=ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000Jooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0<ooooo`Co0000
1_ooool00ol0003oooooooooo`03ooooo`Co00003Oooool00ol0003oooooooooo`03ooooo`05o`00
0?ooooooooooooooool000006_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo09_o
oooo0020ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`03ooooo`05o`000?ooooooooooooooool000006oooool01?l0003oooooooooooooool2o`00
01cooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
00Cooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool00oooool01Ol0003ooooooooooooooooo000001_ooooo00Co0000oooooooooooooooo
0_l0002Mooooo`00POooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooool000001Oooool01Ol0003ooooooooooooooooo000001cooooo0ol000000ooooooo0000
ooooo`0Iooooo`03o`000?oooooo000000gooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`05ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000ooooooooool02?ooool00ol0003o
ooooo`000005ooooo`05o`000?ooooooooooooooool000007?ooool3o`000003ooooool0003ooooo
09cooooo001looooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`02ooooo`04o`000?ooooooooooo`0000Cooooo00Co0000oooooooooooo00001?ooool0
0ol0003oooooooooo`09ooooo`;o00001Oooool01Ol0003ooooooooooooooooo000003cooooo0_l0
000=ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00001?ooool01?l0003ooooo
ooooool00004ooooo`03o`000?oooooooooo00Wooooo0_l00005ooooo`05o`000?oooooooooooooo
ool00000__ooool007gooooo1?l0000<ooooo`Co00001?ooool4o`0000Cooooo1?l0000=ooooo`03
o`000?oooooooooo00Cooooo0ol0000nooooo`03o`000?oooooooooo00cooooo1?l00004ooooo`Co
00001?ooool4o`0000gooooo00?o0000ooooooooool01?ooool3o`000;oooooo003ooooooo3ooooo
003ooooooo3ooooo0036ooooo`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0[_ooool0
0<Kooooo00?o0000ooooooooool0MOooool00ol0003oooooooooo`2^ooooo`00aoooool00ol0003o
ooooooooo`1eooooo`03o`000?oooooooooo0:gooooo002kooooo`Oo00001Oooool00ol0003ooooo
ooooo`1Yooooo`Oo00001Oooool00ol0003oooooooooo`2]ooooo`00b?ooool00ol0003ooooooooo
o`1eooooo`03o`000?oooooooooo0:cooooo0038ooooo`03o`000?oooooooooo07Gooooo00?o0000
ooooooooool0[?ooool00<Wooooo00?o0000ooooooooool0MOooool00ol0003oooooooooo`2[oooo
o`00a?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo073ooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`2[ooooo`00a?ooool6o`0007;ooooo1_l0002]ooooo`00oooo
ooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00oooo
ooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00oooo
ooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`001?ooool6o`0000?ooooo1?l00004ooooo`?o
00001_ooool00ol0003oooooooooo`23ooooo`Go0000Loooool5o`000<kooooo0004ooooo`03o`00
0?oooooooooo00;ooooo00Co0000oooooooooooo00001?ooool01?l0003oooooooooool00003oooo
o`03o`000?oooooooooo08Wooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`1`oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0boooool000Gooooo00?o0000oooooooo
ool02Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo08gooooo00?o0000oooooooo
ool0MOooool00ol0003oooooooooo`3;ooooo`001_ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool0ROooool4o`0007Cooooo1?l0003>ooooo`001ooo
ool00ol0003oooooooooo`04ooooo`?o00001oooool00ol0003oooooooooo`29ooooo`03o`000?oo
oooooooo07Gooooo00?o0000ooooooooool0d?ooool000Sooooo00?o0000ooooooooool01_ooool0
0ol0003oooooooooo`04o`0008cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`1`
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0boooool000Wooooo00?o0000oooo
ooooool01Oooool01?l0003oooooooooool0002@ooooo`Go0000Loooool5o`000<gooooo0004oooo
o`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00001?ooool01?l0003oooooooooool0
003oooooom_ooooo0005ooooo`Co00001?ooool4o`0000?ooooo1_l0003oooooomKooooo003ooooo
oo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooo
oo3ooooo001koooooeoo00006OoooomOo`0009gooooo003ooooooo3ooooo003ooooooo3ooooo003o
oooooo3ooooo003ooooooo3ooooo003Eooooo`?o0000MOooool3o`0009oooooo003Hooooo`03o`00
0?oooooooooo07Gooooo00?o0000ooooooooool0W?ooool00=Wooooo00?o0000ooooooooool0MOoo
ool00ol0003oooooooooo`2Kooooo`00O?ooool6o`0000Cooooo00?o0000ooooooooool01Oooool2
o`0000Cooooo1Ol00004ooooo`Co00002oooool5o`0000Cooooo0ol0000Mooooo`?o000000?ooooo
o`000?ooool06Oooool5o`0000Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04
ooooo`?o00001Oooool3o`0000cooooo1Ol00004ooooo`?o00007Oooool3o`000003ooooool0003o
oooo09cooooo001looooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02Oooool01?l0
003oooooooooool00005ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00
000Kooooo`04o`000?ooooooooooooooo`;o00007?ooool00ol0003oooooooooo`0=ooooo`03o`00
0?oooooooooo00?ooooo00Go0000ooooooooooooooooo`000003ooooo`05o`000?oooooooooooooo
ool000003Oooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006oooool0
1?l0003oooooooooooooool2o`0009gooooo001mooooo`03o`000?oooooooooo00cooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00?ooooo00Go0000
ooooooooooooooooo`00000Jooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool06_oo
ool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00;ooooo00Go0000oooooooooooooooo
o`000008ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00oooool01Ol0003ooooo
oooooooooooo000001[ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2Kooooo`00
O_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006_ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool03_ooool00ol0003o
ooooooooo`02ooooo`05o`000?ooooooooooooooool000002?ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000Jooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool0Voooool007oooooo00?o0000ooooooooool02_ooool2o`00
00;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`04ooooo`Co00003Oooool00ol0
003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006_ooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool03oooool01Ol0003ooooooooooooo
oooo000000?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo00?ooooo00Go0000ooooooooooooooooo`00000Jooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool0Voooool0083ooooo00?o0000ooooooooool02Oooool01?l0003oooooo`00
0?l00006ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000Kooooo`04
o`000?ooooooooooooooo`;o00007?ooool00ol0003oooooooooo`0?ooooo`05o`000?oooooooooo
ooooool000000oooool01?l0003oooooooooooooool4o`0000kooooo00?o0000ooooooooool00ooo
ool01Ol0003ooooooooooooooooo000001_ooooo00Co0000oooooooooooooooo0_l0002Mooooo`00
POooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooool00000
1Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooool00000
1Oooool01Ol0003ooooooooooooooooo000001cooooo0ol000000ooooooo0000ooooo`0Iooooo`03
o`000?oooooo000001;ooooo00Co0000oooooooooooo00000oooool01Ol0003ooooooooooooooooo
000000oooooo00?o0000ooooool000001Oooool01Ol0003ooooooooooooooooo000001cooooo0ol0
00000ooooooo0000ooooo`2Looooo`00O?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo00Wooooo00?o0000ooooooooool01Oooool2o`0000Gooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`09ooooo`;o00001Oooool01Ol0003ooooooooooooooooo000003cooooo0_l0
000=ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000oooool01Ol0003ooooo
oooooooooooo0000013ooooo0_l00005ooooo`05o`000?ooooooooooooooool00000__ooool007go
oooo1?l0000=ooooo`;o00001_ooool00ol0003oooooooooo`04ooooo`Co00003Oooool00ol0003o
ooooooooo`04ooooo`?o0000?_ooool00ol0003oooooooooo`0;ooooo`Ko00000oooool3o`0000Co
oooo1_l0000<ooooo`03o`000?oooooooooo00Cooooo0ol0002oooooo`00ooooooo`ooooo`00oooo
ooo`ooooo`00ooooooo`ooooo`00a_ooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo
0:kooooo0036ooooo`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0[_ooool00<Oooooo
00?o0000ooooooooool0MOooool00ol0003oooooooooo`2]ooooo`00^oooool7o`0000Gooooo00?o
0000ooooooooool0JOooool7o`0000Gooooo00?o0000ooooooooool0[Oooool00<Sooooo00?o0000
ooooooooool0MOooool00ol0003oooooooooo`2/ooooo`00b?ooool00ol0003oooooooooo`1eoooo
o`03o`000?oooooooooo0:cooooo0039ooooo`03o`000?oooooooooo07Gooooo00?o0000oooooooo
ool0Zoooool00<Cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`1`ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool0Zoooool00<Cooooo1_l0001booooo`Ko0000[Ooo
ool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?oo
ool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?oo
ool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool000Cooooo1_l00003ooooo`?o0000
1?ooool5o`0000Gooooo00?o0000ooooooooool0Poooool5o`0007?ooooo1Ol0003>ooooo`001?oo
ool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`2;ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
L?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0<_ooooo0005ooooo`03o`000?oo
oooooooo00Cooooo00Go0000ooooooooooooooooo`000005ooooo`03o`000?oooooooooo093ooooo
00?o0000ooooooooool0MOooool00ol0003oooooooooo`3;ooooo`001_ooool00ol0003ooooooooo
o`03ooooo`05o`000?ooooooooooooooool000001Oooool00ol0003oooooooooo`2<ooooo`Co0000
M?ooool4o`000<kooooo0007ooooo`03o`000?oooooooooo00;ooooo00Go0000oooooooooooooooo
o`000005ooooo`03o`000?oooooooooo08_ooooo00?o0000ooooooooool0MOooool00ol0003ooooo
ooooo`3@ooooo`002?ooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`2;ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
L?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0<_ooooo0009ooooo`04o`000?oo
ooooooooo`0000?ooooo00Oo0000ooooooooooooooooo`000?oooooo000008kooooo1Ol0001coooo
o`Go0000cOooool000Cooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00003oooo
o`03o`000?oooooooooo00;ooooo0_l0003oooooomWooooo0005ooooo`Co00001?ooool3o`0000Ko
oooo00?o0000ooooooooool0oooooooGooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`
ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00NooooomOo`0001WoooooGol0002Mooooo`00oooo
ooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00eOoo
ool3o`0007Gooooo0ol0002Oooooo`00f?ooool00ol0003oooooooooo`1eooooo`03o`000?oooooo
oooo09cooooo003Iooooo`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0Voooool007co
oooo1_l00004ooooo`03o`000?oooooooooo00Gooooo1?l00003ooooo`?o00001Oooool4o`0000_o
oooo1Ol00004ooooo`?o00007Oooool3o`000003ooooool0003ooooo01Wooooo1Ol00005ooooo`03
o`000?oooooooooo00Cooooo0ol00005ooooo`Co00000oooool5o`0000_ooooo1Ol00004ooooo`?o
00007Oooool3o`000003ooooool0003ooooo09cooooo001looooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool03?ooool01Ol0003ooooooooooooooooo000000?ooooo00Go0000oooooooo
ooooooooo`000004ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00oooool01Ol0
003ooooooooooooooooo000001_ooooo00Co0000oooooooooooooooo0_l0000Looooo`03o`000?oo
oooooooo00_ooooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00?ooooo
00Go0000ooooooooooooooooo`00000Kooooo`04o`000?ooooooooooooooo`;o0000WOooool007go
oooo00?o0000ooooooooool04?ooool01Ol0003ooooooooooooooooo000000?ooooo00Go0000oooo
ooooooooooooo`000004ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00oooool0
1Ol0003ooooooooooooooooo000001[ooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`0Jooooo`03o`000?oooooooooo013ooooo00Co0000oooooooooooo00001?ooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool00oooool01Ol0003ooooo
oooooooooooo000001[ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2Kooooo`00
O_ooool00ol0003oooooooooo`0;ooooo`Ko00000_ooool01Ol0003ooooooooooooooooo000000?o
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00?o
oooo00Go0000ooooooooooooooooo`00000Jooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool06_ooool00ol0003oooooooooo`0@ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00?ooooo00Go0000
ooooooooooooooooo`00000Jooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0Vooo
ool007oooooo00?o0000ooooooooool02_ooool01Ol0003ooooooooooooooooo000000?ooooo00Go
0000ooooooooooooooooo`000004ooooo`Co00003Oooool00ol0003oooooooooo`03ooooo`05o`00
0?ooooooooooooooool000006_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01[o
oooo00?o0000ooooooooool03oooool00ol0003oooooooooo`02ooooo`Co00001Oooool00ol0003o
ooooooooo`0=ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000Joooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0Voooool0083ooooo00?o0000oooooooo
ool02_ooool01?l0003oooooooooool00003ooooo`05o`000?ooooooooooooooool000000oooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00oooool0
1Ol0003ooooooooooooooooo000001_ooooo00Co0000oooooooooooooooo0_l0000Looooo`03o`00
0?oooooooooo00_ooooo1?l00004ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00?ooooo00Go0000oooooooooooo
ooooo`00000Kooooo`04o`000?ooooooooooooooo`;o0000WOooool0087ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooo`000003ooooo`05o`000?ooooooooooooooool000000oooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooool000001Oooool01Ol0
003ooooooooooooooooo000001cooooo0ol000000ooooooo0000ooooo`0Iooooo`03o`000?oooooo
000000gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`02ooooo`06o`000?oooooo
ooooo`000?oooooo00003Oooool00ol0003oooooo`000005ooooo`05o`000?ooooooooooooooool0
00007?ooool3o`000003ooooool0003ooooo09cooooo001looooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool02oooool2o`0000?ooooo00Go0000ooooooooooooooooo`000003ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool02Oooool2o`0000Gooooo00Go0000oooooooo
ooooooooo`00000looooo`;o00003Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00;ooooo00Co0000oooooooooooooooo0_l0000>ooooo`;o00001Oooool01Ol0003ooooooooooooo
oooo00000;kooooo001mooooo`Co00003oooool00ol0003oooooooooo`02ooooo`?o00001Oooool4
o`0000gooooo00?o0000ooooooooool01?ooool3o`0003kooooo00?o0000ooooooooool02oooool6
o`0000?ooooo1?l00005ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool01?ooool3
o`000;oooooo003ooooooo3ooooo0036ooooo`03o`000?oooooooooo07Gooooo00?o0000oooooooo
ool0[_ooool00<Kooooo00?o0000ooooooooool0MOooool00ol0003oooooooooo`2^ooooo`00aooo
ool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo0:gooooo002kooooo`Oo00001Oooool0
0ol0003oooooooooo`1Yooooo`Oo00001Oooool00ol0003oooooooooo`2]ooooo`00b?ooool00ol0
003oooooooooo`1eooooo`03o`000?oooooooooo0:cooooo0038ooooo`03o`000?oooooooooo07Go
oooo00?o0000ooooooooool0[?ooool00<Wooooo00?o0000ooooooooool0MOooool00ol0003ooooo
ooooo`2[ooooo`00a?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo073ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`2[ooooo`00a?ooool6o`0007;ooooo1_l0002]
ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`
ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`
ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`001?ooool5
o`0000Gooooo0_l00005ooooo`Co00001Oooool00ol0003oooooooooo`23ooooo`Go0000Loooool5
o`000<kooooo0006ooooo`03o`000?oooooooooo00Cooooo00Co0000oooooooooooo00000oooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo08Sooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`1`ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0boooool0
00Kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`04o`000?oooooooooo
o`0000Cooooo00?o0000ooooooooool0SOooool00ol0003oooooooooo`1eooooo`03o`000?oooooo
oooo0<_ooooo0006ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool01?l0
003oooooooooool00004ooooo`03o`000?oooooooooo08Wooooo1?l0001dooooo`Co0000c_ooool0
00Kooooo00?o0000ooooooooool00oooool2o`0000;ooooo00?o0000ooooooooool00_ooool4o`00
08_ooooo00?o0000ooooooooool0MOooool00ol0003oooooooooo`3@ooooo`001_ooool00ol0003o
ooooooooo`03ooooo`04o`000?oooooo0000o`0000Cooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`28ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0L?ooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo0<_ooooo0004ooooo`03o`000?oooooo000000Go
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo08Wo
oooo1Ol0001cooooo`Go0000cOooool000Gooooo0_l00006ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`3oooooomCooooo0006ooooo`03o`000?oo
oooooooo00Gooooo0_l00005ooooo`Co0000oooooooGooooo`00ooooooo`ooooo`00ooooooo`oooo
o`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00NooooomOo`00
01WoooooGol0002Mooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00eOooool3
o`0007Gooooo0ol0002Oooooo`00f?ooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo
09cooooo003Iooooo`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0Voooool007cooooo
1_l00004ooooo`03o`000?oooooooooo00?ooooo1Ol00005ooooo`;o00001?ooool6o`0000[ooooo
1Ol00004ooooo`?o00007Oooool3o`000003ooooool0003ooooo01Wooooo1Ol00005ooooo`03o`00
0?oooooooooo00Gooooo1?l00003ooooo`?o00001_ooool00ol0003oooooooooo`0;ooooo`Go0000
1?ooool3o`0001gooooo0ol000000ooooooo0000ooooo`2Looooo`00O?ooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool01oooool01Ol0003ooooooooo
oooooooo000000Cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`03ooooo`05o`00
0?ooooooooooooooool000006oooool01?l0003oooooooooooooool2o`0001cooooo00?o0000oooo
ooooool03oooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00
000Kooooo`04o`000?ooooooooooooooo`;o0000WOooool007gooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`08ooooo`05o`000?ooooooooooooooool000004?ooool00ol0003ooooo
ooooo`03ooooo`05o`000?ooooooooooooooool000006_ooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo01[ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`06ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`03ooooo`05
o`000?ooooooooooooooool000006_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
09_ooooo001nooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool01Oooool2o`000003
ooooool0003ooooo00?ooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`03ooooo`05
o`000?ooooooooooooooool000006_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
01[ooooo00?o0000ooooooooool02oooool6o`0000Oooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`0<ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000J
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0Voooool007oooooo00?o0000oooo
ooooool03?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00;o00001Oooool00ol0
003oooooooooo`0<ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000J
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0;
ooooo`05o`000?ooooooooooooooool000001oooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo00_ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000001[ooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`2Kooooo`00P?ooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooo
oooooooo000001_ooooo00Co0000oooooooooooooooo0_l0000Looooo`03o`000?oooooooooo00co
oooo00Co0000oooooooooooo00000oooool4o`0000Sooooo00?o0000ooooooooool02oooool00ol0
003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006oooool01?l0003ooooooooooooo
ool2o`0009gooooo0021ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooool000001Oooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool02?ooool0
0ol0003oooooo`000005ooooo`05o`000?ooooooooooooooool000007?ooool3o`000003ooooool0
003ooooo01Wooooo00?o0000ooooool000003oooool00ol0003oooooo`000003ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool02?ooool00ol0003oooooo`000005ooooo`05o`000?oo
ooooooooooooool000007?ooool3o`000003ooooool0003ooooo09cooooo001looooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool02Oooool2o`0000Kooooo00Co0000oooooooooooo0000
0oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Wooooo0_l00005ooooo`05o`00
0?ooooooooooooooool00000??ooool2o`00013ooooo0_l00003ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`09ooooo`;o00001Oooool01Ol0003o
oooooooooooooooo00000;kooooo001mooooo`Co00003Oooool00ol0003oooooooooo`05ooooo`;o
00001Oooool4o`0000gooooo00?o0000ooooooooool01?ooool3o`0003kooooo00?o0000oooooooo
ool03oooool01?l0003oooooooooooooool6o`0000;ooooo1_l0000<ooooo`03o`000?oooooooooo
00Cooooo0ol0002oooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00a_ooool0
0ol0003oooooooooo`1eooooo`03o`000?oooooooooo0:kooooo0036ooooo`03o`000?oooooooooo
07Gooooo00?o0000ooooooooool0[_ooool00<Oooooo00?o0000ooooooooool0MOooool00ol0003o
ooooooooo`2]ooooo`00^oooool7o`0000Gooooo00?o0000ooooooooool0JOooool7o`0000Gooooo
00?o0000ooooooooool0[Oooool00<Sooooo00?o0000ooooooooool0MOooool00ol0003ooooooooo
o`2/ooooo`00b?ooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo0:cooooo0039oooo
o`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0Zoooool00<Cooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`1`ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool0Zoooool00<Cooooo1_l0001booooo`Ko0000[Oooool00?ooooool?ooool00?ooooool?ooool0
0?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool0
0?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool0
0?ooooool?ooool00?ooooool?ooool000Cooooo1Ol00004ooooo`Co00001Oooool4o`0000Cooooo
00?o0000ooooooooool0Poooool5o`0007?ooooo1Ol0003>ooooo`001_ooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`29ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0L?ooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo0<_ooooo0006ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`2>ooooo`03o`000?oooooooooo07Gooooo00?o0000
ooooooooool0boooool000Kooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`06o`00
08_ooooo1?l0001dooooo`Co0000c_ooool000Kooooo00?o0000ooooooooool01Oooool3o`0000?o
oooo00Go0000ooooooooooooooooo`00002;ooooo`03o`000?oooooooooo07Gooooo00?o0000oooo
ooooool0d?ooool000Kooooo00?o0000ooooooooool02?ooool01Ol0003ooooooooooooooooo0000
00;ooooo00?o0000ooooooooool0ROooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
073ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`3;ooooo`001?ooool00ol0003o
ooooo`00000:ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooool00000S?ooool5o`0007?o
oooo1Ol0003=ooooo`001Oooool2o`0000Gooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`03ooooo`;o0000oooooooGooooo`001_ooool00ol0003oooooooooo`04ooooo`Co00001ooo
ool00ol0003oooooooooo`3oooooomGooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3o
oooo003ooooooo3ooooo001koooooeoo00006OoooomOo`0009gooooo003ooooooo3ooooo003ooooo
oo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003Eooooo`?o0000MOooool3
o`0009oooooo003Hooooo`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0W?ooool00=Wo
oooo00?o0000ooooooooool0MOooool00ol0003oooooooooo`2Kooooo`00O?ooool5o`0000Gooooo
00?o0000ooooooooool01Oooool2o`0000Kooooo0_l00005ooooo`Co00002oooool5o`0000Cooooo
0ol0000Mooooo`?o000000?oooooo`000?ooool06Oooool5o`0000Gooooo00?o0000ooooooooool0
1?ooool4o`0000Cooooo1?l00005ooooo`Co00002_ooool5o`0000Cooooo0ol0000Mooooo`?o0000
00?oooooo`000?ooool0W?ooool007kooooo00?o0000ooooooooool03oooool00ol0003ooooooooo
o`02ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000Kooooo`04
o`000?ooooooooooooooo`;o00007?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo
00;ooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo00_ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000001_ooooo00Co
0000oooooooooooooooo0_l0002Mooooo`00O_ooool00ol0003oooooooooo`0@ooooo`04o`000?oo
ooooooooo`0000Cooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000Jooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo
00?ooooo00Go0000ooooooooooooooooo`00000Jooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool0Voooool007kooooo00?o0000ooooooooool03Oooool2o`000005ooooool0003ooooo
ooooool000001?ooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool00oooool01Ol0003ooooooooooooooooo000001[ooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`06o`0000cooooo00?o0000ooooooooool00oooool01Ol0003ooooo
oooooooooooo000001[ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2Kooooo`00
O_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00;o00000_ooool2o`0000;ooooo
00?o0000ooooooooool00_ooool4o`0000gooooo00?o0000ooooooooool00oooool01Ol0003ooooo
oooooooooooo000001[ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Jooooo`03
o`000?oooooooooo00gooooo0ol00005ooooo`?o00000oooool01Ol0003ooooooooooooooooo0000
00gooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000001[ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`2Kooooo`00O_ooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo00;ooooo00Go0000oooooooooooo0000ooooo`02o`0000Cooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00?ooooo00Go0000
ooooooooooooooooo`00000Kooooo`04o`000?ooooooooooooooo`;o00007?ooool00ol0003ooooo
ooooo`0@ooooo`03o`000?oooooooooo00Gooooo00Go0000ooooooooooooooooo`000002ooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo0000
01_ooooo00Co0000oooooooooooooooo0_l0002Mooooo`00O?ooool00ol0003oooooo`00000=oooo
o`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooool000001Oooool01Ol0003ooooooooooooo
oooo000001cooooo0ol000000ooooooo0000ooooo`0Iooooo`03o`000?oooooo000001;ooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooo000000_ooooo00?o
0000ooooool000001Oooool01Ol0003ooooooooooooooooo000001cooooo0ol000000ooooooo0000
ooooo`2Looooo`00OOooool2o`0000kooooo00Co0000oooooooooooo00001?ooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02Oooool2o`0000Gooooo
00Go0000ooooooooooooooooo`00000looooo`;o00003Oooool00ol0003oooooooooo`02ooooo`04
o`000?ooooooooooo`0000Cooooo00?o0000ooooooooool00oooool2o`0000cooooo0_l00005oooo
o`05o`000?ooooooooooooooool00000__ooool007kooooo00?o0000ooooooooool03Oooool2o`00
00Kooooo0_l00005ooooo`Co00003Oooool00ol0003oooooooooo`04ooooo`?o0000?_ooool00ol0
003oooooooooo`0<ooooo`Co00001?ooool4o`0000Oooooo00?o0000ooooooooool02oooool00ol0
003oooooooooo`04ooooo`?o0000_oooool00?ooooool?ooool00?ooooool?ooool00<Kooooo00?o
0000ooooooooool0MOooool00ol0003oooooooooo`2^ooooo`00a_ooool00ol0003oooooooooo`1e
ooooo`03o`000?oooooooooo0:kooooo0037ooooo`03o`000?oooooooooo07Gooooo00?o0000oooo
ooooool0[Oooool00;_ooooo1ol00005ooooo`03o`000?oooooooooo06Wooooo1ol00005ooooo`03
o`000?oooooooooo0:gooooo0038ooooo`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0
[?ooool00<Sooooo00?o0000ooooooooool0MOooool00ol0003oooooooooo`2/ooooo`00bOooool0
0ol0003oooooooooo`1eooooo`03o`000?oooooooooo0:_ooooo0034ooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool0L?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
0:_ooooo0034ooooo`Ko0000L_ooool6o`000:gooooo003ooooooo3ooooo003ooooooo3ooooo003o
oooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003o
oooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003o
oooooo3ooooo0004ooooo`Go00001?ooool3o`0000Cooooo1Ol00005ooooo`03o`000?oooooooooo
08?ooooo1Ol0001cooooo`Go0000c_ooool000Kooooo00?o0000ooooooooool00oooool01Ol0003o
oooooooooooooooo000000Gooooo00?o0000ooooooooool0Roooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo073ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`3;oooo
o`001_ooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000001Oooool00ol0
003oooooooooo`2@ooooo`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0boooool000Ko
oooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000000Gooooo00?o0000oooo
ooooool0S?ooool4o`0007Cooooo1?l0003>ooooo`001_ooool00ol0003oooooooooo`03ooooo`05
o`000?ooooooooooooooool000001Oooool00ol0003oooooooooo`2;ooooo`03o`000?oooooooooo
07Gooooo00?o0000ooooooooool0d?ooool000Kooooo00?o0000ooooooooool00oooool01Ol0003o
oooooooooooooooo000000Gooooo00?o0000ooooooooool0Roooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo073ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`3;oooo
o`001?ooool00ol0003oooooo`000005ooooo`05o`000?ooooooooooooooool000000oooool00ol0
003oooooo`00002>ooooo`Go0000Loooool5o`000<gooooo0005ooooo`;o00001Oooool01Ol0003o
oooooooooooooooo000000Cooooo0_l0003oooooomWooooo0006ooooo`03o`000?oooooooooo00Co
oooo0ol00006ooooo`03o`000?oooooooooo0?ooooooeoooool00?ooooool?ooool00?ooooool?oo
ool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool007_oooooGol0000Ioooooeoo0000
WOooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?oooooo
l?ooool00=Gooooo0ol0001eooooo`?o0000Woooool00=Sooooo00?o0000ooooooooool0MOooool0
0ol0003oooooooooo`2Looooo`00fOooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo
09_ooooo001looooo`Go00001Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Co
oooo1?l00005ooooo`;o00003?ooool5o`0000Cooooo0ol0000Mooooo`?o000000?oooooo`000?oo
ool06Oooool5o`0000Gooooo00?o0000ooooooooool00oooool6o`0000;ooooo1Ol00005ooooo`Co
00002_ooool5o`0000Cooooo0ol0000Mooooo`?o000000?oooooo`000?ooool0W?ooool007kooooo
00?o0000ooooooooool03Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo
00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool00oooool01Ol0003ooooooooooooooooo000001_ooooo00Co0000oooooooooooooooo0_l0000L
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`03
ooooo`05o`000?ooooooooooooooool000006oooool01?l0003oooooooooooooool2o`0009gooooo
001nooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool01oooool01?l0003ooooooooo
ool00004ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00oooool01Ol0003ooooo
oooooooooooo000001[ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Jooooo`03
o`000?oooooooooo00cooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo0000
01[ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2Kooooo`00O_ooool00ol0003o
ooooooooo`0>ooooo`03o`000?oooooooooo00Oooooo00Co0000oooooooooooo00001?ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000J
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0=
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00oooool6o`0000cooooo00?o0000
ooooooooool00oooool01Ol0003ooooooooooooooooo000001[ooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`2Kooooo`00O_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooo
oooo00?ooooo0ol00003ooooo`;o00000_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooo
oooo00?ooooo00Go0000ooooooooooooooooo`00000Jooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool06_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool00oooool01Ol0003ooooooooooooooooo000000gooooo00?o0000ooooooooool0
0oooool01Ol0003ooooooooooooooooo000001[ooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`2Kooooo`00O_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00Kooooo
00Go0000oooooooooooo0000ooooo`02o`0000kooooo00?o0000ooooooooool00oooool01Ol0003o
oooooooooooooooo000001_ooooo00Co0000oooooooooooooooo0_l0000Looooo`03o`000?oooooo
oooo00oooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`04ooooo`04o`000?oooooo
ooooo`0000gooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000001_ooooo
00Co0000oooooooooooooooo0_l0002Mooooo`00O?ooool00ol0003oooooo`00000Booooo`03o`00
0?oooooooooo00Gooooo00Co0000oooooooooooo00003oooool00ol0003oooooo`000005ooooo`05
o`000?ooooooooooooooool000007?ooool3o`000003ooooool0003ooooo01Wooooo00?o0000oooo
ool000004_ooool01_l0003oooooooooool0003oooooo`0000Oooooo00?o0000ooooool000002ooo
ool00ol0003oooooo`000005ooooo`05o`000?ooooooooooooooool000007?ooool3o`000003oooo
ool0003ooooo09cooooo001mooooo`;o00003Oooool00ol0003oooooooooo`02ooooo`04o`000?oo
ooooooooo`0000Cooooo00Go0000ooooooooooooooooo`00000?ooooo`;o00001Oooool01Ol0003o
oooooooooooooooo000003cooooo0_l0000=ooooo`03o`000?oooooooooo00;ooooo00Co0000oooo
oooooooooooo0_l00008ooooo`;o00003?ooool2o`0000Gooooo00Go0000ooooooooooooooooo`00
002nooooo`00O_ooool00ol0003oooooooooo`0;ooooo`Ko00000oooool4o`0000Gooooo0_l0000>
ooooo`03o`000?oooooooooo00Cooooo0ol0000nooooo`03o`000?oooooooooo00cooooo1?l00005
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`04
ooooo`?o0000_oooool00?ooooool?ooool00<Kooooo00?o0000ooooooooool0MOooool00ol0003o
ooooooooo`2^ooooo`00a_ooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo0:kooooo
0037ooooo`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0[Oooool00;_ooooo1ol00005
ooooo`03o`000?oooooooooo06Wooooo1ol00005ooooo`03o`000?oooooooooo0:gooooo0038oooo
o`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0[?ooool00<Sooooo00?o0000oooooooo
ool0MOooool00ol0003oooooooooo`2/ooooo`00bOooool00ol0003oooooooooo`1eooooo`03o`00
0?oooooooooo0:_ooooo0034ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0L?oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0:_ooooo0034ooooo`Ko0000L_ooool6
o`000:gooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003o
oooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003o
oooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo0005
ooooo`Co00001?ooool4o`0000Gooooo00?o0000ooooooooool01?ooool4o`0008?ooooo1Ol0001c
ooooo`Go0000c_ooool000Cooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00004
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`20
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0L?ooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo0<_ooooo0004ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool0QOooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo0<_ooooo0004ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool0POooool4o`0007Cooooo1?l0003>ooooo`00
1Oooool4o`0000Gooooo0ol0000<ooooo`Co0000Poooool00ol0003oooooooooo`1eooooo`03o`00
0?oooooooooo0=3ooooo0004ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0P?oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo073ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`3;ooooo`001?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo087ooooo1Ol0001cooooo`Go0000cOooool000Cooooo00?o0000ooooooooool00_ooool01?l0
003oooooooooool00004ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`3oooooolcooooo0005ooooo`Co00001?ooool4o`0000cooooo1?l0003ooooo
oloooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooo
oo3ooooo003ooooooo3ooooo001koooooeoo00006OoooomOo`0009gooooo003ooooooo3ooooo003o
oooooo3ooooo003ooooooo3ooooo003Eooooo`?o0000MOooool3o`0009oooooo003Hooooo`03o`00
0?oooooooooo07Gooooo00?o0000ooooooooool0W?ooool00=Wooooo00?o0000ooooooooool0MOoo
ool00ol0003oooooooooo`2Kooooo`00O?ooool5o`0000Gooooo00?o0000ooooooooool01Oooool2
o`0000Cooooo1Ol00005ooooo`;o00003?ooool5o`0000Cooooo0ol0000Mooooo`?o000000?ooooo
o`000?ooool06Oooool5o`0000Gooooo00?o0000ooooooooool00oooool5o`0000Cooooo0ol00005
ooooo`Co00002oooool5o`0000Cooooo0ol0000Mooooo`?o000000?oooooo`000?ooool0W?ooool0
07kooooo00?o0000ooooooooool03?ooool01?l0003oooooooooool00005ooooo`03o`000?oooooo
oooo00Cooooo00Co0000oooooooooooo00003Oooool00ol0003oooooooooo`03ooooo`05o`000?oo
ooooooooooooool000006oooool01?l0003oooooooooooooool2o`0001cooooo00?o0000oooooooo
ool03Oooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000000oooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00oooool01Ol0
003ooooooooooooooooo000001_ooooo00Co0000oooooooooooooooo0_l0002Mooooo`00O_ooool0
0ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006_ooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool03Oooool00ol0003ooooooooo
o`08ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`03ooooo`05o`000?ooooooooooooooool000006_ooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo09_ooooo001nooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00?ooooo00Go0000oooooooooooo
ooooo`00000Jooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool06_ooool00ol0003o
ooooooooo`0=ooooo`03o`000?oooooooooo00Sooooo00Co0000oooooooooooo00001?ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000J
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0Voooool007kooooo00?o0000oooo
ooooool02oooool2o`0000;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`03oooo
o`;o00000_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00?ooooo00Go0000oooo
ooooooooooooo`00000Jooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool06_ooool0
0ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00_ooool4
o`0000gooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000001[ooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`2Kooooo`00O_ooool00ol0003oooooooooo`0;
ooooo`04o`000?oooooo0000o`0000Kooooo00?o0000ooooooooool00oooool01?l0003oooooo`00
0?l0000>ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000Kooooo`04
o`000?ooooooooooooooo`;o00007?ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo
00?ooooo1?l00004ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006oooool01?l0003ooooooooooooo
ool2o`0009gooooo001looooo`03o`000?oooooo000000gooooo00?o0000ooooooooool01Oooool0
0ol0003oooooo`000005ooooo`03o`000?oooooooooo00gooooo00?o0000ooooool000001Oooool0
1Ol0003ooooooooooooooooo000001cooooo0ol000000ooooooo0000ooooo`0Iooooo`03o`000?oo
oooo000000gooooo00?o0000ooooool000001Oooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool02?ooool00ol0003oooooo`000005ooooo`05o`000?oo
ooooooooooooool000007?ooool3o`000003ooooool0003ooooo09cooooo001mooooo`;o00003_oo
ool00ol0003oooooooooo`05ooooo`;o00001_ooool00ol0003oooooooooo`0=ooooo`;o00001Ooo
ool01Ol0003ooooooooooooooooo000003cooooo0_l0000>ooooo`;o00001Oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02Oooool2o`0000Gooooo
00Go0000ooooooooooooooooo`00002nooooo`00O_ooool00ol0003oooooooooo`0=ooooo`;o0000
1_ooool00ol0003oooooooooo`05ooooo`;o00003_ooool00ol0003oooooooooo`04ooooo`?o0000
?_ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00?ooooo1_l00003ooooo`Co0000
3Oooool00ol0003oooooooooo`04ooooo`?o0000_oooool00?ooooool?ooool00?ooooool?ooool0
0?ooooool?ooool00<Kooooo00?o0000ooooooooool0MOooool00ol0003oooooooooo`2^ooooo`00
a_ooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo0:kooooo0037ooooo`03o`000?oo
oooooooo07Gooooo00?o0000ooooooooool0[Oooool00;_ooooo1ol00005ooooo`03o`000?oooooo
oooo06Wooooo1ol00005ooooo`03o`000?oooooooooo0:gooooo0038ooooo`03o`000?oooooooooo
07Gooooo00?o0000ooooooooool0[?ooool00<Sooooo00?o0000ooooooooool0MOooool00ol0003o
ooooooooo`2/ooooo`00bOooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo0:_ooooo
0034ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0L?ooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo0:_ooooo0034ooooo`Ko0000L_ooool6o`000:gooooo003ooooo
oo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooo
oo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooo
oo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo0006ooooo`;o00001_ooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo1Ol00023ooooo`Go0000Loooool5
o`000<kooooo0005ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool03Oooool0
0ol0003oooooooooo`23ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0L?ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo0<_ooooo0004ooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo
08Sooooo00?o0000ooooooooool0MOooool00ol0003oooooooooo`3;ooooo`001?ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool03?ooool00ol0003o
ooooooooo`24ooooo`Co0000M?ooool4o`000<kooooo0004ooooo`;o00000_ooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0Poooool00ol0003ooooo
ooooo`1eooooo`03o`000?oooooooooo0=3ooooo0004ooooo`04o`000?oooooo0000o`0000Sooooo
00?o0000ooooooooool02oooool00ol0003oooooooooo`23ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool0L?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0<_ooooo
0004ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02?ooool00ol0003oooooo`00
0026ooooo`Go0000Loooool5o`000<gooooo0005ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`09ooooo`;o0000oooooooAooooo`001_ooool2o`00
00Cooooo1_l0000<ooooo`03o`000?oooooooooo0?oooooocoooool00?ooooool?ooool00?oooooo
l?ooool00?ooooool?ooool00?ooooool?ooool007_oooooGol0000Ioooooeoo0000WOooool00?oo
ooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00=Go
oooo0ol0001eooooo`?o0000Woooool00=Sooooo00?o0000ooooooooool0MOooool00ol0003ooooo
ooooo`2Looooo`00fOooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo09_ooooo001l
ooooo`Go00001Oooool00ol0003oooooooooo`05ooooo`Co00001?ooool2o`0000Gooooo1?l0000;
ooooo`Go00001?ooool3o`0001gooooo0ol000000ooooooo0000ooooo`0Iooooo`Go00001Oooool0
0ol0003oooooooooo`03ooooo`Go00001?ooool3o`0000Kooooo0_l0000<ooooo`Go00001?ooool3
o`0001gooooo0ol000000ooooooo0000ooooo`2Looooo`00O_ooool00ol0003oooooooooo`0?oooo
o`03o`000?oooooooooo00Gooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000001_ooooo00Co
0000oooooooooooooooo0_l0000Looooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool0
0oooool01Ol0003ooooooooooooooooo000000Cooooo00Co0000oooooooooooo00003Oooool00ol0
003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006oooool01?l0003ooooooooooooo
ool2o`0009gooooo001nooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool01_ooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00oooool0
1Ol0003ooooooooooooooooo000001[ooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`0Jooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool00oooool01Ol0003ooooooooo
oooooooo000000?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000Jooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool0Voooool007kooooo00?o0000ooooooooool02oooool6o`0000Cooooo
0_l000000ooooooo0000ooooo`06ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
0oooool01Ol0003ooooooooooooooooo000001[ooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`0Jooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool00oooool01Ol0003o
oooooooooooooooo000000?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000Jooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool0Voooool007kooooo00?o0000ooooooooool02oooool01Ol0
003ooooooooooooooooo000000Cooooo00?o0000ooooooooool00_l00004ooooo`?o00003Oooool0
0ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006_ooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool03Oooool00ol0003ooooooooo
o`03ooooo`05o`000?ooooooooooooooool000000oooool2o`0000;ooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006_ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo09_ooooo001nooooo`03o`000?oooooooooo00cooooo
00Co0000oooooooooooo00000oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`03ooooo`05o`000?oooooooooooooo
ool000006oooool01?l0003oooooooooooooool2o`0001cooooo00?o0000ooooooooool03Oooool0
0ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000000oooool01?l0003oooooo`00
0?l0000>ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000Kooooo`04
o`000?ooooooooooooooo`;o0000WOooool007cooooo00?o0000ooooool000003oooool00ol0003o
ooooo`000003ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooo000000Gooooo00Go0000ooooooooooooooooo`00000Loooo
o`?o000000?oooooo`000?ooool06Oooool00ol0003oooooo`00000=ooooo`03o`000?oooooo0000
00Gooooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooooooo00gooooo00?o0000
ooooool000001Oooool01Ol0003ooooooooooooooooo000001cooooo0ol000000ooooooo0000oooo
o`2Looooo`00OOooool2o`00013ooooo0_l00004ooooo`04o`000?ooooooooooo`0000?ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`09ooooo`;o00001Oooool01Ol0003ooooooooo
oooooooo000003cooooo0_l0000>ooooo`;o00001Oooool01Ol0003ooooooooooooooooo000000Co
oooo00?o0000ooooooooool03Oooool2o`0000Gooooo00Go0000ooooooooooooooooo`00002noooo
o`00O_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00?ooooo0_l00005ooooo`Co
00003Oooool00ol0003oooooooooo`04ooooo`?o0000?_ooool00ol0003oooooooooo`0=ooooo`03
o`000?oooooooooo00Cooooo0ol00006ooooo`;o00003_ooool00ol0003oooooooooo`04ooooo`?o
0000_oooool00?ooooool?ooool00?ooooool?ooool00<Kooooo00?o0000ooooooooool0MOooool0
0ol0003oooooooooo`2^ooooo`00a_ooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo
0:kooooo0037ooooo`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0[Oooool00;_ooooo
1ol00005ooooo`03o`000?oooooooooo06Wooooo1ol00005ooooo`03o`000?oooooooooo0:gooooo
0038ooooo`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0[?ooool00<Sooooo00?o0000
ooooooooool0MOooool00ol0003oooooooooo`2/ooooo`00bOooool00ol0003oooooooooo`1eoooo
o`03o`000?oooooooooo0:_ooooo0034ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool0L?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0:_ooooo0034ooooo`Ko0000
L_ooool6o`000:gooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3o
oooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3o
oooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo0005ooooo`?o
00001Oooool3o`0000Kooooo00?o0000ooooooooool01?ooool4o`0008?ooooo1Ol0001cooooo`Go
0000c_ooool000Cooooo00Go0000ooooooooooooooooo`000003ooooo`05o`000?oooooooooooooo
ool000002oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo083ooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`1`ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool0boooool000Wooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`0>oooo
o`03o`000?oooooooooo08Gooooo00?o0000ooooooooool0MOooool00ol0003oooooooooo`3;oooo
o`002Oooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00kooooo00?o0000oooo
ooooool0POooool4o`0007Cooooo1?l0003>ooooo`002?ooool01Ol0003ooooooooooooooooo0000
00?ooooo00?o0000ooooooooool02oooool3o`0008?ooooo00?o0000ooooooooool0MOooool00ol0
003oooooooooo`3@ooooo`001?ooool4o`0000Cooooo00Go0000ooooooooooooooooo`00000@oooo
o`03o`000?oooooooooo083ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`1`oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0boooool000Cooooo00?o0000oooooooo
ool01Oooool01Ol0003ooooooooooooooooo0000013ooooo00?o0000ooooooooool0POooool5o`00
07?ooooo1Ol0003=ooooo`001?ooool00ol0003oooooooooo`05ooooo`05o`000?oooooooooooooo
ool000002oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0?ooooooc?ooool000Co
oooo1_l00003ooooo`?o00003Oooool4o`000?oooooocoooool00?ooooool?ooool00?ooooool?oo
ool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool007_oooooGol0
000Ioooooeoo0000WOooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?oooooo
l?ooool00=Gooooo0ol0001eooooo`?o0000Woooool00=Sooooo00?o0000ooooooooool0MOooool0
0ol0003oooooooooo`2Looooo`00fOooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo
09_ooooo001looooo`Go00001Oooool00ol0003oooooooooo`04ooooo`Co00001Oooool2o`0000Ko
oooo00?o0000ooooooooool02oooool5o`0000Cooooo0ol0000Mooooo`?o000000?oooooo`000?oo
ool06Oooool5o`0000Gooooo00?o0000ooooooooool01?ooool3o`0000Kooooo0_l00005ooooo`Co
00002oooool5o`0000Cooooo0ol0000Mooooo`?o000000?oooooo`000?ooool0W?ooool007kooooo
00?o0000ooooooooool02oooool00ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool0
00000_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00gooooo00?o0000oooooooo
ool00oooool01Ol0003ooooooooooooooooo000001_ooooo00Co0000oooooooooooooooo0_l0000L
ooooo`03o`000?oooooooooo00_ooooo00Go0000ooooooooooooooooo`000004ooooo`04o`000?oo
ooooooooo`0000?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000Kooooo`04o`000?oooooooooooooo
o`;o0000WOooool007kooooo00?o0000ooooooooool04?ooool01?l0003oooooooooool00004oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`03oooo
o`05o`000?ooooooooooooooool000006_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo01[ooooo00?o0000ooooooooool02oooool01Ol0003ooooooooooooooooo000000?ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool00oooool01Ol0003ooooooooooooooooo000001[ooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`2Kooooo`00O_ooool00ol0003oooooooooo`0@ooooo`04o`000?oo
ooooooooo`0000Cooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0<ooooo`03o`00
0?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000Jooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0;ooooo`05o`000?oooooooooooooo
ool000000oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006_ooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo09_ooooo001nooooo`03o`000?oooooooooo
00gooooo0ol00003ooooo`;o00000_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00_ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000001[ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo00_ooooo00Go0000
ooooooooooooooooo`000003ooooo`;o00000_ooool00ol0003oooooooooo`03ooooo`?o00003Ooo
ool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006_ooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo09_ooooo001nooooo`03o`000?oooooooooo013ooooo00Go
0000oooooooooooo0000ooooo`02o`0000Sooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`03ooooo`05o`000?ooooooooooooooool000006oooool01?l0003oooooooooooooool2o`00
01cooooo00?o0000ooooooooool02oooool01Ol0003ooooooooooooooooo000000?ooooo00Co0000
ooooool0003o00002Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00?ooooo00Go
0000ooooooooooooooooo`00000Kooooo`04o`000?ooooooooooooooo`;o0000WOooool007cooooo
00?o0000ooooool000004_ooool01?l0003oooooooooool0000<ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooool000001Oooool01Ol0003ooooooooooooooooo000001cooooo0ol000000ooo
oooo0000ooooo`0Iooooo`03o`000?oooooo000000gooooo00Go0000ooooooooooooooooo`000003
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02?ooool00ol0003oooooo`000005
ooooo`05o`000?ooooooooooooooool000007?ooool3o`000003ooooool0003ooooo09cooooo001m
ooooo`;o00003Oooool00ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool000001_oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Wooooo0_l00005ooooo`05o`000?oo
ooooooooooooool00000??ooool2o`0000gooooo00Go0000ooooooooooooooooo`000004ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`09ooooo`;o
00001Oooool01Ol0003ooooooooooooooooo00000;kooooo001nooooo`03o`000?oooooooooo00co
oooo1?l00005ooooo`;o00001?ooool6o`0000cooooo00?o0000ooooooooool01?ooool3o`0003ko
oooo00?o0000ooooooooool03?ooool3o`0000Kooooo0_l00005ooooo`Co00003Oooool00ol0003o
ooooooooo`04ooooo`?o0000_oooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool0
0<Kooooo00?o0000ooooooooool0MOooool00ol0003oooooooooo`2^ooooo`00a_ooool00ol0003o
ooooooooo`1eooooo`03o`000?oooooooooo0:kooooo0037ooooo`03o`000?oooooooooo07Gooooo
00?o0000ooooooooool0[Oooool00;_ooooo1ol00005ooooo`03o`000?oooooooooo06Wooooo1ol0
0005ooooo`03o`000?oooooooooo0:gooooo0038ooooo`03o`000?oooooooooo07Gooooo00?o0000
ooooooooool0[?ooool00<Sooooo00?o0000ooooooooool0MOooool00ol0003oooooooooo`2/oooo
o`00bOooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo0:_ooooo0034ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool0L?ooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo0:_ooooo0034ooooo`Ko0000L_ooool6o`000:gooooo003ooooooo3ooooo003ooooo
oo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooo
oo3ooooo003ooooooo3ooooo003ooooooo3ooooo0000\
\>"]]
}, Open  ]],

Cell[TextData[StyleBox["DUMBBELLS",
  FontFamily->"Geneva",
  FontSize->14]], "Input",
  AspectRatioFixed->False,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[TextData[StyleBox["Here are the dumbbell calculations.  We use a linear \
array that is the same as\nbefore, but another subunit is added at the end.",
  FontFamily->"Geneva",
  FontWeight->"Plain"]], "Input",
  AspectRatioFixed->False,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
f1Kirk={};
f1robert={};
frictionratio={};
rij={};
Do[
\tPrint[nbasepairs[[k]],\" bp spacer\"];
\t
\tPrint[\"My model:\"];
\tntot=3;
\tsnaked[nbasepairs[[k]]];
\tradii={r1,rstokes,r1};
\trij={{0,r1 + lengthp[[k]] r1/2,2 r1 + lengthp[[k]] r1},
\t\t {0,0,r1 + lengthp[[k]] r1/2},
\t\t {0,0,0}};
\tdoKirkwoodG;
\tf1robert=Append[f1robert,f1];

\tPrint[\"Kirk's model:\"];\t
\tntot=lengthp[[k]]+2;
\tradii={r1};
\tDo[radii=Append[radii,r2],{i,lengthp[[k]]}];
\tradii=Append[radii,r1];
\trij=Table[0,{i,ntot},{j,ntot}];
\tDo[ Do[\tIf[\tj<ntot,
\t\t\t\trij[[i,j]]=radii[[i]] + (j-i-1) 2 r2 + r2,
\t\t\t\trij[[i,j]]=radii[[i]] + (j-i-1) 2 r2 + radii[[j]]
\t\t\t],
\t\t{j,i+1,ntot}],
\t{i,ntot}];
\tdoKirkwoodG;
\tf1Kirk=Append[f1Kirk,N[f1]],

{k,Length[lengthp]}];\
\>", "Input",
  AspectRatioFixed->False,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!PS-Adobe-2.0 EPSF-1.2
%%BoundingBox: 6 6 267 1059
%%HiResBoundingBox: 6 6 267 1059
%%Creator: (Mathematica 5.2 for Macintosh)
%%CreationDate: (Monday, March 30, 2020) (20:39:41)
%%Title: Clipboard
%%DocumentNeededResources: (atend)
%%DocumentFonts: (atend)
%%DocumentNeededFonts: (atend)
%%EndComments
0 1065 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def

%%MathematicaCell
%Cell[GraphicsData[\"PICT\", \\
%\"\\<\\
%55X0100X0/80eP0A0_l<0?ooool0:00000@0003F0002`\\
%P000000000N00402P04
%02P2`P9@0380100X0/82D00b00@0:00:0U00;00:01H7@fmeLVUULP0301H03@06
%02h010000000:bT94CD`;S8i=34PHW0PLg1QHfEb03802P0X0102D00Z1PU=NB1]
%KfAUK3X00380400X01H2D00Z1RTP821;JG9[Mfm_I21bIG=eK7Ac>R1kIR1VLVEU
%;FAbHFU^JFiW;6HaO@00<P0F02P0709@02X6820P820P820P820P820P;CLP820P
%820P820P820P82dg0380700X0282D00Z1R8P820P<Rhh>3Li=R0a<20P86LP834^
%>3Lc<c4P<C0P821W03808P0X02P2D00Z1R<P821k;Bd];Bd];Bd];Bd];Bd/82d]
%;Bd];Bd];Bd];Bd]O@00<P0X02P0;P9@02X66b0P820P820P821c820P820P820P
%820P820PL`00<P0^02P0=09@02X63D]YLV/WLb1]KfAUK3X00380=00X03X2D00Z
%1RTP821;JG9[Mfm_I21bIG=eK7Ac>R1kIR1VLVEU;FAbHFU^JFiW;6HaO@00<P0j
%02P0@09@02X67b0P820P820P820P820P;CLP820P820P820P820P;CL00380@00X
%04H2D00Z1R4P820P<bha<c<a=b0a<20P86LP834^=3Hh=R0a<20P86L00380AP0X
%04`2D00Z1R8P821k;Bd];Bd];Bd];Bd];Bd/82d];Bd];Bd];Bd];Bem0380C00X
%0582D00Z1Q/P820P820P820PLb0P820P820P820P820P87<00380DP0X05P2D00Z
%1Q4f=bh`=CPh869`87=`HF=ULP00<P1H02P0GP9@02X62Dei86e_I6E/>P00<P1N
%02P0I09@02X6:B0P84]YLV]gKfmT879ULgE/M7<j87]V86IbIFD]I79QJFiYKVL/
%IS5m000b06@0:01Z0U00:PHP820P820P820P820P820]=b0P820P820P820P820P
%;CL0<P1Z02P0L09@02X68R0P820c;S0a=CDf834`820PIb0P<Rh`<SDf=R0a<20P
%86L0<P1`02P0MP9@02X68b0P87/];Bd];Bd];Bd];Bd];B`P;Bd];Bd];Bd];Bd]
%;Bem000b07H0:01l0U00:PHK820P820P820P87<P820P820P820P820P821c000b
%07`0:0220U00:PH=BfUbJbMc86e_I6E/>P00<P2202P0R09@02X6:B0P84]YLV]g
%KfmT879ULgE/M7<j87]V86IbIFD]I79QJFiYKVL/IS5m000b08P0:02>0U00:PHP
%820P820P820P820P820]=b0P820P820P820P820P;CL0<P2>02P0U09@02X68R0P
%820c;S@d>CPa834`820PIb0P<Bhe<38d=R0a<20P86L0<P2D02P0VP9@02X68b0P
%87/];Bd];Bd];Bd];Bd];B`P;Bd];Bd];Bd];Bd];Bem000b09X0:02P0U00:PHK
%820P820P820P87<P820P820P820P820P821c000b0:00:02V0U00:PHA>3<^>38c
%=B1RL21cL65SIG800380YP0X0:`2D00Z1PU=NB1]KfAUK3X00380[00X0;82D00Z
%1RTP821;JG9[Mfm_I21bIG=eK7Ac>R1kIR1VLVEU;FAbHFU^JFiW;6HaO@00<P2b
%02P0^09@02X67b0P820P820P820P820P;CLP820P820P820P820P;CL00380^00X
%0;h2D00Z1R4P820P<bha<cPi>20a<20P86LP838^<CHh>20a<20P86L00380_P0X
%0<@2D00Z1R8P821k;Bd];Bd];Bd];Bd];Bd/82d];Bd];Bd];Bd];Bem0380a00X
%0<X2D00Z1Q/P820P820P820PLb0P820P820P820P820P87<00380bP0X0=02D00Z
%1Pe;JG9[9g<PKFmTIF`j000b0=00:03F0U00:PHY820PBfUbJgM_Kf@PLVEcMFad
%LcXPNfHPIW9UIBeTLV5YKVU^IbaV<Gd00380eP0X0=`2D00Z1R0P820P820P820P
%820P82dg820P820P820P820P820]=`0b0=`0:03R0U00:PHR820P83<^=cHf=3HP
%<C0P821W820a;SDd<cTb834`820PI`0b0>80:03X0U00:PHS820PNbd];Bd];Bd]
%;Bd];Bd];20];Bd];Bd];Bd];Bd];Gd00380j00X0>h2D00Z1Q/P820P820P820P
%Lb0P820P820P820P820P87<00380kP0X0?@2D00Z1Q4a<30^=CPh869`87=`HF=U
%LP00<P3d02P0nP9@02X62Dei86e_I6E/>P00<P3j02P1009@02X6:B0P84]YLV]g
%KfmT879ULgE/M7<j87]V86IbIFD]I79QJFiYKVL/IS5m000b0@00:0460U00:PHP
%820P820P820P820P820]=b0P820P820P820P820P;CL0<P4602P1309@02X68R0P
%820c;S8e>3Hc834`820PIb0P<Rhc<3@i<b0a<20P86L0<P4<02P14P9@02X68b0P
%87/];Bd];Bd];Bd];Bd];B`P;Bd];Bd];Bd];Bd];Bem000b0A80:04H0U00:PHK
%820P820P820P87<P820P820P820P820P821c000b0AP0:04N0U00:PH=BfUbJbMc
%86e_I6E/>P00<P4N02P1909@02X6:B0P84]YLV]gKfmT879ULgE/M7<j87]V86Ib
%IFD]I79QJFiYKVL/IS5m000b0B@0:04Z0U00:PHO820P820P820P820P82dg820P
%820P820P820P820]=`00<P4Z02P1<09@02X68B0P820d;S0h<c4P<C0P821W820a
%;SDi<3<c834`820PI`00<P4`02P1=P9@02X68R0P87/];Bd];Bd];Bd];Bd];20]
%;Bd];Bd];Bd];Bd];Gd0<P4f02P1?09@02X66R0P820P820P821c820P820P820P
%820P821c0381?00X0D82D00Z1Q4a<c@^<C4h869`87=`HF=ULP00<P5202P1B09@
%02X62Dei86e_I6E/>P00<P5802P1CP9@02X6:B0P84]YLV]gKfmT879ULgE/M7<j
%87]V86IbIFD]I79QJFiYKVL/IS5m000b0Dh0:05D0U00:PHP820P820P820P820P
%820]=b0P820P820P820P820P;CL0<P5D02P1FP9@02X68R0P820c;S@h>3Hh834`
%820PIb0P<Rhe=S4e=R0a<20P86L0<P5J02P1H09@02X68b0P87/];Bd];Bd];Bd]
%;Bd];B`P;Bd];Bd];Bd];Bd];Bem000b0F00:05V0U00:PHK820P820P820P87<P
%820P820P820P820P821c000b0FH0:05/0U00:PH=BfUbJbMc86e_I6E/>P00<P5/
%02P1LP9@02X6:B0P84]YLV]gKfmT879ULgE/M7<j87]V86IbIFD]I79QJFiYKVL/
%IS5m000b0G80:05h0U00:PHP820P820P820P820P820]=b0P820P820P820P820P
%;CL0<P5h02P1OP9@02X68R0P820d;SLa=S<i834`820PIb0P<Bhf>C8a<R0a<20P
%86L0<P5n02P1Q09@02X68b0P87/];Bd];Bd];Bd];Bd];B`P;Bd];Bd];Bd];Bd]
%;Bem000b0H@0:06:0U00:PHK820P820P820P87<P820P820P820P820P821c000b
%0HX0:06@0U00:PHA<CHg;SHd=b1RL21cL65SIG800381T00X0IH2D00Z1PU=NB1]
%KfAUK3X00381UP0X0I`2D00Z1RTP821;JG9[Mfm_I21bIG=eK7Ac>R1kIR1VLVEU
%;FAbHFU^JFiW;6HaO@00<P6L02P1XP9@02X6820P820P820P820P820P;CLP820P
%820P820P820P82dg0381XP0X0JP2D00Z1R8P820P<bhg<3T`=20a<20P86LP838^
%>30b>3LP<C0P821W0381Z00X0Jh2D00Z1R<P821k;Bd];Bd];Bd];Bd];Bd/82d]
%;Bd];Bd];Bd];Bd]O@00<P6^02P1]09@02X66b0P820P820P821c820P820P820P
%820P820PL`00<P6d02P1^P9@02X63D]YLV/WLb1]KfAUK3X00381^P0X0L02D00Z
%1RTP821;JG9[Mfm_I21bIG=eK7Ac>R1kIR1VLVEU;FAbHFU^JFiW;6HaO@00<P70
%02P1aP9@02X6820P820P820P820P820P;CLP820P820P820P820P82dg0381aP0X
%0L`2D00Z1R8P820P=Bhc=3Tf>20a<20P86LP834^>30`=CDP<C0P821W0381c00X
%0M82D00Z1R<P821k;Bd];Bd];Bd];Bd];Bd/82d];Bd];Bd];Bd];Bd]O@00<P7B
%02P1f09@02X66b0P820P820P821c820P820P820P820P820PL`00<P7H02P1gP9@
%02X64C8`<Bha=cHPHW0PLg1QHfEb000b0Mh0:07T0U00:PH9CGTPKFmTIF`j000b
%0N@0:07Z0U00:PHY820PBfUbJgM_Kf@PLVEcMFadLcXPNfHPIW9UIBeTLV5YKVU^
%IbaV<Gd00381jP0X0O02D00Z1R0P820P820P820P820P82dg820P820P820P820P
%820]=`0b0O00:07f0U00:PHR820P83<^>C8a>C<P<C0P821W820c;S0c<STh834`
%820PI`0b0OH0:07l0U00:PHS820PNbd];Bd];Bd];Bd];Bd];20];Bd];Bd];Bd]
%;Bd];Gd00381o00X0P82D00Z1Q/P820P820P820PLb0P820P820P820P820P87<0
%03820P0X0PP2D00Z1Pe;JG9[9g<PKFmTIF`j000b0PP0:08>0U00:PHY820PBfUb
%JgM_Kf@PLVEcMFadLcXPNfHPIW9UIBeTLV5YKVU^IbaV<Gd003823P0X0Q@2D00Z
%1R0P820P820P820P820P82dg820P820P820P820P820]=`0b0Q@0:08J0U00:PHR
%820P83D^>CPb>CLP<C0P821W820a;STa<S8g834`820PI`0b0QX0:08P0U00:PHS
%820PNbd];Bd];Bd];Bd];Bd];20];Bd];Bd];Bd];Bd];Gd00382800X0RH2D00Z
%1Q/P820P820P820PLb0P820P820P820P820P87<003829P0X0R`2D00Z1Q4b<c@^
%=c0f869`87=`HF=ULP00<P8/02P2<P9@02X62Dei86e_I6E/>P00<P8b02P2>09@
%02X6:B0P84]YLV]gKfmT879ULgE/M7<j87]V86IbIFD]I79QJFiYKVL/IS5m000b
%0SP0:08n0U00:PHP820P820P820P820P820]=b0P820P820P820P820P;CL0<P8n
%02P2A09@02X68R0P820d;S4b>3Pa834`820PIb0P<bhb=C@d=b0a<20P86L0<P94
%02P2BP9@02X68b0P87/];Bd];Bd];Bd];Bd];B`P;Bd];Bd];Bd];Bd];Bem000b
%0TX0:09@0U00:PHK820P820P820P87<P820P820P820P820P821c000b0U00:09F
%0U00:PH=BfUbJbMc86e_I6E/>P00<P9F02P2G09@02X6:B0P84]YLV]gKfmT879U
%LgE/M7<j87]V86IbIFD]I79QJFiYKVL/IS5m000b0U`0:09R0U00:PHP820P820P
%820P820P820]=b0P820P820P820P820P;CL0<P9R02P2J09@02X68R0P820f;SHa
%=S8f834`820PIb0P<Rh`<SDe>B0a<20P86L0<P9X02P2KP9@02X68b0P87/];Bd]
%;Bd];Bd];Bd];B`P;Bd];Bd];Bd];Bd];Bem000b0Vh0:09d0U00:PHK820P820P
%820P87<P820P820P820P820P821c000b0W@0:09j0U00:PHA<SHh;S8c=B1RL21c
%L65SIG800382NP0X0X02D00Z1PU=NB1]KfAUK3X00382P00X0XH2D00Z1RTP821;
%JG9[Mfm_I21bIG=eK7Ac>R1kIR1VLVEU;FAbHFU^JFiW;6HaO@00<P:602P2S09@
%02X6820P820P820P820P820P;CLP820P820P820P820P82dg0382S00X0Y82D00Z
%1R8P820P=2hc<c0g<R0a<20P86LP83<^=3Hi<3<P<C0P821W0382TP0X0YP2D00Z
%1R<P821k;Bd];Bd];Bd];Bd];Bd/82d];Bd];Bd];Bd];Bd]O@00<P:H02P2WP9@
%02X66b0P820P820P821c820P820P820P820P820PL`00<P:N02P2Y09@02X63D]Y
%LV/WLb1]KfAUK3X00382Y00X0ZX2D00Z1RTP821;JG9[Mfm_I21bIG=eK7Ac>R1k
%IR1VLVEU;FAbHFU^JFiW;6HaO@00<P:Z02P2/09@02X6820P820P820P820P820P
%;CLP820P820P820P820P82dg0382/00X0[H2D00Z1R8P820P=bhb=3Te=B0a<20P
%86LP838^<C<i=CPP<C0P821W0382]P0X0[`2D00Z1R<P821k;Bd];Bd];Bd];Bd]
%;Bd/82d];Bd];Bd];Bd];Bd]O@00<P:l02P2`P9@02X66b0P820P820P821c820P
%820P820P820P820PL`00<P;202P2`P9@0?l\\>\"], \"Graphics\",
%  ImageSize->{174, 702},
%  ImageMargins->{{0, Inherited}, {Inherited, Inherited}},
%  ImageRegion->{{-0, 1}, {0, 1}},
%  FontSize->6]
%%EndMathematicaCell
1 setgray
6 1059 moveto
834 1059 lineto
834 6 lineto
6 6 lineto
closepath
fill
6 15 moveto
834 15 lineto
834 6 lineto
6 6 lineto
closepath
fill
2 setlinewidth
0 setgray
/Courier findfont 6 scalefont setfont
8 14 moveto (50.2941 bp spacer) show
1 setgray
7 23 moveto
833 23 lineto
833 16 lineto
7 16 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 23 moveto (My model:) show
1 setgray
7 32 moveto
833 32 lineto
833 25 lineto
7 25 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 32 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 41 moveto
833 41 lineto
833 34 lineto
7 34 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 41 moveto (              -7              -7) show
1 setgray
7 50 moveto
833 50 lineto
833 43 lineto
7 43 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 50 moveto (    2.88796 10   g  1.87331 10   g) show
1 setgray
7 59 moveto
833 59 lineto
833 52 lineto
7 52 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 59 moveto (   {--------------, --------------}) show
1 setgray
7 68 moveto
833 68 lineto
833 61 lineto
7 61 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 68 moveto (          s               s) show
1 setgray
7 77 moveto
833 77 lineto
833 70 lineto
7 70 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 77 moveto (Kirk's model:) show
1 setgray
7 86 moveto
833 86 lineto
833 79 lineto
7 79 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 86 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 95 moveto
833 95 lineto
833 88 lineto
7 88 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 95 moveto (              -7             -7) show
1 setgray
7 104 moveto
833 104 lineto
833 97 lineto
7 97 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 104 moveto (    3.13317 10   g  1.4686 10   g) show
1 setgray
7 113 moveto
833 113 lineto
833 106 lineto
7 106 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 113 moveto (   {--------------, -------------}) show
1 setgray
7 122 moveto
833 122 lineto
833 115 lineto
7 115 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 122 moveto (          s               s) show
1 setgray
7 131 moveto
833 131 lineto
833 124 lineto
7 124 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 131 moveto (67.0588 bp spacer) show
1 setgray
7 140 moveto
833 140 lineto
833 133 lineto
7 133 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 140 moveto (My model:) show
1 setgray
7 149 moveto
833 149 lineto
833 142 lineto
7 142 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 149 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 158 moveto
833 158 lineto
833 151 lineto
7 151 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 158 moveto (              -7              -7) show
1 setgray
7 167 moveto
833 167 lineto
833 160 lineto
7 160 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 167 moveto (    3.01556 10   g  2.02566 10   g) show
1 setgray
7 176 moveto
833 176 lineto
833 169 lineto
7 169 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 176 moveto (   {--------------, --------------}) show
1 setgray
7 185 moveto
833 185 lineto
833 178 lineto
7 178 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 185 moveto (          s               s) show
1 setgray
7 194 moveto
833 194 lineto
833 187 lineto
7 187 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 194 moveto (Kirk's model:) show
1 setgray
7 203 moveto
833 203 lineto
833 196 lineto
7 196 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 203 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 212 moveto
833 212 lineto
833 205 lineto
7 205 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 212 moveto (              -7              -7) show
1 setgray
7 221 moveto
833 221 lineto
833 214 lineto
7 214 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 221 moveto (    3.44981 10   g  1.50246 10   g) show
1 setgray
7 230 moveto
833 230 lineto
833 223 lineto
7 223 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 230 moveto (   {--------------, --------------}) show
1 setgray
7 239 moveto
833 239 lineto
833 232 lineto
7 232 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 239 moveto (          s               s) show
1 setgray
7 248 moveto
833 248 lineto
833 241 lineto
7 241 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 248 moveto (83.8235 bp spacer) show
1 setgray
7 257 moveto
833 257 lineto
833 250 lineto
7 250 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 257 moveto (My model:) show
1 setgray
7 266 moveto
833 266 lineto
833 259 lineto
7 259 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 266 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 275 moveto
833 275 lineto
833 268 lineto
7 268 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 275 moveto (              -7             -7) show
1 setgray
7 284 moveto
833 284 lineto
833 277 lineto
7 277 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 284 moveto (    3.13898 10   g  2.1688 10   g) show
1 setgray
7 293 moveto
833 293 lineto
833 286 lineto
7 286 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 293 moveto (   {--------------, -------------}) show
1 setgray
7 302 moveto
833 302 lineto
833 295 lineto
7 295 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 302 moveto (          s               s) show
1 setgray
7 311 moveto
833 311 lineto
833 304 lineto
7 304 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 311 moveto (Kirk's model:) show
1 setgray
7 320 moveto
833 320 lineto
833 313 lineto
7 313 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 320 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 329 moveto
833 329 lineto
833 322 lineto
7 322 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 329 moveto (              -7              -7) show
1 setgray
7 338 moveto
833 338 lineto
833 331 lineto
7 331 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 338 moveto (    3.76646 10   g  1.54392 10   g) show
1 setgray
7 347 moveto
833 347 lineto
833 340 lineto
7 340 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 347 moveto (   {--------------, --------------}) show
1 setgray
7 356 moveto
833 356 lineto
833 349 lineto
7 349 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 356 moveto (          s               s) show
1 setgray
7 365 moveto
833 365 lineto
833 358 lineto
7 358 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 365 moveto (100.588 bp spacer) show
1 setgray
7 374 moveto
833 374 lineto
833 367 lineto
7 367 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 374 moveto (My model:) show
1 setgray
7 383 moveto
833 383 lineto
833 376 lineto
7 376 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 383 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 392 moveto
833 392 lineto
833 385 lineto
7 385 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 392 moveto (              -7              -7) show
1 setgray
7 401 moveto
833 401 lineto
833 394 lineto
7 394 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 401 moveto (    3.25863 10   g  2.30493 10   g) show
1 setgray
7 410 moveto
833 410 lineto
833 403 lineto
7 403 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 410 moveto (   {--------------, --------------}) show
1 setgray
7 419 moveto
833 419 lineto
833 412 lineto
7 412 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 419 moveto (          s               s) show
1 setgray
7 428 moveto
833 428 lineto
833 421 lineto
7 421 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 428 moveto (Kirk's model:) show
1 setgray
7 437 moveto
833 437 lineto
833 430 lineto
7 430 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 437 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 446 moveto
833 446 lineto
833 439 lineto
7 439 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 446 moveto (             -7              -7) show
1 setgray
7 455 moveto
833 455 lineto
833 448 lineto
7 448 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 455 moveto (    4.0831 10   g  1.59033 10   g) show
1 setgray
7 464 moveto
833 464 lineto
833 457 lineto
7 457 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 464 moveto (   {-------------, --------------}) show
1 setgray
7 473 moveto
833 473 lineto
833 466 lineto
7 466 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 473 moveto (          s              s) show
1 setgray
7 482 moveto
833 482 lineto
833 475 lineto
7 475 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 482 moveto (134.118 bp spacer) show
1 setgray
7 491 moveto
833 491 lineto
833 484 lineto
7 484 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 491 moveto (My model:) show
1 setgray
7 500 moveto
833 500 lineto
833 493 lineto
7 493 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 500 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 509 moveto
833 509 lineto
833 502 lineto
7 502 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 509 moveto (              -7              -7) show
1 setgray
7 518 moveto
833 518 lineto
833 511 lineto
7 511 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 518 moveto (    3.48868 10   g  2.56156 10   g) show
1 setgray
7 527 moveto
833 527 lineto
833 520 lineto
7 520 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 527 moveto (   {--------------, --------------}) show
1 setgray
7 536 moveto
833 536 lineto
833 529 lineto
7 529 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 536 moveto (          s               s) show
1 setgray
7 545 moveto
833 545 lineto
833 538 lineto
7 538 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 545 moveto (Kirk's model:) show
1 setgray
7 554 moveto
833 554 lineto
833 547 lineto
7 547 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 554 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 563 moveto
833 563 lineto
833 556 lineto
7 556 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 563 moveto (              -7              -7) show
1 setgray
7 572 moveto
833 572 lineto
833 565 lineto
7 565 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 572 moveto (    4.71639 10   g  1.69212 10   g) show
1 setgray
7 581 moveto
833 581 lineto
833 574 lineto
7 574 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 581 moveto (   {--------------, --------------}) show
1 setgray
7 590 moveto
833 590 lineto
833 583 lineto
7 583 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 590 moveto (          s               s) show
1 setgray
7 599 moveto
833 599 lineto
833 592 lineto
7 592 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 599 moveto (167.647 bp spacer) show
1 setgray
7 608 moveto
833 608 lineto
833 601 lineto
7 601 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 608 moveto (My model:) show
1 setgray
7 617 moveto
833 617 lineto
833 610 lineto
7 610 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 617 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 626 moveto
833 626 lineto
833 619 lineto
7 619 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 626 moveto (              -7              -7) show
1 setgray
7 635 moveto
833 635 lineto
833 628 lineto
7 628 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 635 moveto (    3.70904 10   g  2.80287 10   g) show
1 setgray
7 644 moveto
833 644 lineto
833 637 lineto
7 637 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 644 moveto (   {--------------, --------------}) show
1 setgray
7 653 moveto
833 653 lineto
833 646 lineto
7 646 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 653 moveto (          s               s) show
1 setgray
7 662 moveto
833 662 lineto
833 655 lineto
7 655 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 662 moveto (Kirk's model:) show
1 setgray
7 671 moveto
833 671 lineto
833 664 lineto
7 664 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 671 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 680 moveto
833 680 lineto
833 673 lineto
7 673 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 680 moveto (              -7              -7) show
1 setgray
7 689 moveto
833 689 lineto
833 682 lineto
7 682 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 689 moveto (    5.34968 10   g  1.80055 10   g) show
1 setgray
7 698 moveto
833 698 lineto
833 691 lineto
7 691 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 698 moveto (   {--------------, --------------}) show
1 setgray
7 707 moveto
833 707 lineto
833 700 lineto
7 700 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 707 moveto (          s               s) show
1 setgray
7 716 moveto
833 716 lineto
833 709 lineto
7 709 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 716 moveto (201.176 bp spacer) show
1 setgray
7 725 moveto
833 725 lineto
833 718 lineto
7 718 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 725 moveto (My model:) show
1 setgray
7 734 moveto
833 734 lineto
833 727 lineto
7 727 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 734 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 743 moveto
833 743 lineto
833 736 lineto
7 736 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 743 moveto (              -7              -7) show
1 setgray
7 752 moveto
833 752 lineto
833 745 lineto
7 745 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 752 moveto (    3.92193 10   g  3.03298 10   g) show
1 setgray
7 761 moveto
833 761 lineto
833 754 lineto
7 754 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 761 moveto (   {--------------, --------------}) show
1 setgray
7 770 moveto
833 770 lineto
833 763 lineto
7 763 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 770 moveto (          s               s) show
1 setgray
7 779 moveto
833 779 lineto
833 772 lineto
7 772 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 779 moveto (Kirk's model:) show
1 setgray
7 788 moveto
833 788 lineto
833 781 lineto
7 781 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 788 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 797 moveto
833 797 lineto
833 790 lineto
7 790 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 797 moveto (              -7              -7) show
1 setgray
7 806 moveto
833 806 lineto
833 799 lineto
7 799 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 806 moveto (    5.98297 10   g  1.91227 10   g) show
1 setgray
7 815 moveto
833 815 lineto
833 808 lineto
7 808 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 815 moveto (   {--------------, --------------}) show
1 setgray
7 824 moveto
833 824 lineto
833 817 lineto
7 817 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 824 moveto (          s               s) show
1 setgray
7 833 moveto
833 833 lineto
833 826 lineto
7 826 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 833 moveto (234.706 bp spacer) show
1 setgray
7 842 moveto
833 842 lineto
833 835 lineto
7 835 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 842 moveto (My model:) show
1 setgray
7 851 moveto
833 851 lineto
833 844 lineto
7 844 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 851 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 860 moveto
833 860 lineto
833 853 lineto
7 853 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 860 moveto (              -7              -7) show
1 setgray
7 869 moveto
833 869 lineto
833 862 lineto
7 862 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 869 moveto (    4.12881 10   g  3.25447 10   g) show
1 setgray
7 878 moveto
833 878 lineto
833 871 lineto
7 871 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 878 moveto (   {--------------, --------------}) show
1 setgray
7 887 moveto
833 887 lineto
833 880 lineto
7 880 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 887 moveto (          s               s) show
1 setgray
7 896 moveto
833 896 lineto
833 889 lineto
7 889 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 896 moveto (Kirk's model:) show
1 setgray
7 905 moveto
833 905 lineto
833 898 lineto
7 898 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 905 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 914 moveto
833 914 lineto
833 907 lineto
7 907 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 914 moveto (              -7              -7) show
1 setgray
7 923 moveto
833 923 lineto
833 916 lineto
7 916 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 923 moveto (    6.61626 10   g  2.02559 10   g) show
1 setgray
7 932 moveto
833 932 lineto
833 925 lineto
7 925 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 932 moveto (   {--------------, --------------}) show
1 setgray
7 941 moveto
833 941 lineto
833 934 lineto
7 934 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 941 moveto (          s               s) show
1 setgray
7 950 moveto
833 950 lineto
833 943 lineto
7 943 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 950 moveto (268.235 bp spacer) show
1 setgray
7 959 moveto
833 959 lineto
833 952 lineto
7 952 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 959 moveto (My model:) show
1 setgray
7 968 moveto
833 968 lineto
833 961 lineto
7 961 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 968 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 977 moveto
833 977 lineto
833 970 lineto
7 970 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 977 moveto (              -7              -7) show
1 setgray
7 986 moveto
833 986 lineto
833 979 lineto
7 979 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 986 moveto (    4.33072 10   g  3.46903 10   g) show
1 setgray
7 995 moveto
833 995 lineto
833 988 lineto
7 988 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 995 moveto (   {--------------, --------------}) show
1 setgray
7 1004 moveto
833 1004 lineto
833 997 lineto
7 997 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 1004 moveto (          s               s) show
1 setgray
7 1013 moveto
833 1013 lineto
833 1006 lineto
7 1006 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 1013 moveto (Kirk's model:) show
1 setgray
7 1022 moveto
833 1022 lineto
833 1015 lineto
7 1015 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 1022 moveto (   Kirkwood results: {f free-draining,f1}) show
1 setgray
7 1031 moveto
833 1031 lineto
833 1024 lineto
7 1024 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 1031 moveto (              -7              -7) show
1 setgray
7 1040 moveto
833 1040 lineto
833 1033 lineto
7 1033 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 1040 moveto (    7.24955 10   g  2.13958 10   g) show
1 setgray
7 1049 moveto
833 1049 lineto
833 1042 lineto
7 1042 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 1049 moveto (   {--------------, --------------}) show
1 setgray
7 1058 moveto
833 1058 lineto
833 1051 lineto
7 1051 lineto
closepath
fill
0 setgray
/Courier findfont 6 scalefont setfont
8 1058 moveto (          s               s) show
1 setgray
7 1058 moveto
833 1058 lineto
833 1060 lineto
7 1060 lineto
closepath
fill
%%Trailer
%%EOF
\
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{261, 1053},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  FontSize->6,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000670006:b000`400?l00000o`00003ooooooon8
ooooo`00=Oooool3o`0004gooooo0ol0003oooooo`00=oooool2o`0004kooooo0_l0003nooooo`00
=Oooool2o`0004kooooo0_l0003oooooo`7ooooo000fooooo`?o0000COooool3o`000?kooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo001Nooooo`03o`000?oooooooooo0?oooooo
9oooool001Cooooo00?o0000ooooooooool0B?ooool00ol0003oooooooooo`1<ooooo`03o`000?oo
oooooooo0=Kooooo000Cooooo`03o`000?oooooooooo04Wooooo00?o0000ooooooooool0COooool0
0ol0003oooooooooo`3Eooooo`004oooool00ol0003oooooooooo`2Iooooo`03o`000?oooooooooo
0=Gooooo000Booooo`03o`000?oooooooooo00;ooooo1?l000000ooooooo0000o`000002o`000003
ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003
ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003
ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003
ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`0000_o
oooo1?l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l0
00000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l0
00000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l0
00000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l0
00000_l000000ooooooo0000o`000002o`0000Cooooo00?o0000ooooooooool0e?ooool001?ooooo
00?o0000ooooooooool0VOooool00ol0003oooooooooo`3Eooooo`004oooool00ol0003ooooooooo
o`2Iooooo`03o`000?oooooooooo0=Gooooo000Dooooo`03o`000?oooooooooo09Oooooo00?o0000
ooooooooool0e_ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?oo
ool00?ooooooR?ooool005Wooooo0_l0001>ooooo`;o0000g?ooool005_ooooo00?o0000oooooooo
ool0COooool00ol0003oooooooooo`3Iooooo`006?ooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo00Co00001?ooool01?l0003oooooooooool00004ooooo`;o00000oooool2o`0000So
oooo0ol00002ooooo`;o00004_ooool3o`0000_ooooo1?l00003ooooo`04o`000?oooooooooooooo
o`?o00000_ooool2o`0000?ooooo00?o0000ooooooooool00_ooool2o`0000?ooooo0_l00008oooo
o`?o00000_ooool2o`0001;ooooo0ol0003Kooooo`006?ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00Cooooo00Go0000ooooooooooooooooo`000002ooooo`06o`000?oooooooooo
o`000?oooooo00000_ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`0000;ooooo
00?o0000ooooooooool03_ooool01?l0003oooooooooool0000<ooooo`03o`000?oooooooooo00So
oooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Ko0000
oooooooooooo0000ooooool00002ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo
00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`000=_ooooo000Iooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool01?l00002ooooo`?o00001?ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo00000_ooool00ol0
003oooooooooo`0>ooooo`04o`000?ooooooooooo`0000gooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?o00001?ooool00ol0003oooooo`000002
ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo00000_ooool00ol0003ooooooooo
o`0>ooooo`04o`000?ooooooooooo`000=_ooooo000Iooooo`03o`000?oooooooooo00Sooooo00So
0000oooooooooooo0000ooooool0003oooooo`0000;ooooo00?o0000ooooool000000_l00002oooo
o`?o00002Oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00oooooo0ol0000>
ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool0
0002ooooo`03o`000?oooooo000000;o00000oooool2o`0000Wooooo00Co0000oooooooooooo0000
0_ooool00ol0003oooooooooo`0?ooooo`?o0000foooool001Oooooo00Co0000oooooooooooo0000
1_ooool01?l0003oooooooooool00003ooooo`;o000000Ooooooo`000?ooooooooooo`000?oooooo
000000Cooooo00?o0000ooooooooool02Oooool01?l0003oooooooooool00002ooooo`03o`000?oo
oooooooo01gooooo00Co0000oooooooooooo00002?ooool01?l0003oooooooooool00002ooooo`03
o`000?oooooo000000;ooooo00?o0000ooooool000001?ooool01?l0003oooooooooool00008oooo
o`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0kOooool001Oooooo1?l00007oooo
o`;o00001Oooool00ol0003oooooooooo`02o`0000;ooooo1?l000000ooooooo0000o`000002o`00
00Oooooo0_l00003ooooo`;o00008Oooool2o`0000Sooooo0_l00003ooooo`;o00000oooool2o`00
00;ooooo1?l00002ooooo`;o00002?ooool2o`0000?ooooo0_l0003`ooooo`00oooooon8ooooo`00
oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00oooooon8ooooo`00Coooool00ol0003oooooooooo`1=ooooo`03o`000?oooooo
oooo0>Gooooo001?ooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0iOooool004Wo
oooo1?l00003ooooo`03o`000?oooooooooo04Kooooo1?l00003ooooo`03o`000?oooooooooo0>Co
oooo001@ooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0i?ooool004kooooo00Co
0000oooooooooooo0000C?ooool01?l0003oooooooooool0003Uooooo`00C_ooool4o`0004cooooo
1?l0003Uooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00^?ooool2o`0000?ooooo00?o0000ooooooooool0aoooool006kooooo00?o0000
ooooooooool0BOooool01Ol0003ooooooooooooooooo000000gooooo00?o0000ooooooooool0^?oo
ool001;ooooo00Co0000oooooooooooo00000_ooool3o`000004ooooool0003o0000o`0000;ooooo
0_l000001ooooooo0000o`000?oooooo0000ooooool000000_ooool2o`0000?ooooo0_l00003oooo
o`Co00001Oooool3o`0000?ooooo0ol000001?oooooo0000o`000?l00003ooooo`?o00000_ooool3
o`0000?ooooo0_l000001?oooooo0000o`000?l00004ooooo`03o`000?oooooooooo00Kooooo00Co
0000oooooooooooooooo1?l00006ooooo`Co000000Coooooo`000?l0003o00000oooool3o`0000;o
oooo0ol00007ooooo`Oo00000oooool3o`0000;ooooo0ol000001Ooooooo0000oooooooooooo0000
00;ooooo0ol000001Ooooooo0000oooooooooooo000000;ooooo0ol00003ooooo`03o`000?oooooo
oooo00Co00000_ooool3o`0000?ooooo00?o0000ooooooooool0]oooool001;ooooo00?o0000oooo
ool000001?ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooool000000_ooool0
1Ol0003oooooo`000?oooooo000000;ooooo00?o0000ooooool000000_ooool00ol0003oooooo`00
0002ooooo`03o`000?oooooooooo00Gooooo00Co0000oooooooooooooooo0_l00005ooooo`;o0000
00Goooooo`000?ooooooooooo`000003ooooo`05o`000?ooooooooooooooool000001Oooool2o`00
00cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00;ooooo00Co0000oooooooooooooooo0_l00003ooooo`;o00002?ooool01?l0003oooooooooool0
0002ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooooooooooo000000;o
oooo00Co0000oooooooooooo00000oooool01?l0003oooooooooool00002ooooo`03o`000?oooooo
000000;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool0]oooool001;ooooo0_l00005ooooo`05o`000?oooooooooo
ooooool000001?ooool2o`0000;ooooo00Co0000ooooool0003ooooo0_l00002ooooo`03o`000?oo
oooo000000;ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`05ooooo`06o`000?oo
ooooooooooooool0003ooooo0_l000000ooooooo0000o`000003ooooo`04o`000?ooooooooooo`00
00?ooooo00Go0000ooooooooooooooooo`000003ooooo`;o00003Oooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00_ooool01_l0003ooooooooooooo
oooo0000ooooo`;o000000?oooooo`000?ooool00_l000000ooooooo0000o`000002o`000005oooo
ool0003oooooooooool000000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo000000?o
oooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Ko0000
oooooooooooo0000ooooool00002ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo0;Kooooo000Booooo`;o00001?oo
ool2o`0000;ooooo00Co0000ooooool0003o00000_ooool02_l0003oooooo`000?oooooo0000oooo
ool0003oooooo`000?ooool2o`0000?ooooo0_l00003ooooo`?o00001_ooool01?l0003oooooo`00
0?l00002ooooo`;o00000oooool3o`000005ooooool0003oooooooooool000000oooool00ol0003o
ooooooooo`04o`0000;ooooo0ol00003ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooo
oooooooo1?l00006ooooo`Co000000?oooooo`000?ooool00_l00002ooooo`;o00000oooool2o`00
00Sooooo0ol000000ooooooo0000ooooo`02o`000004ooooool0003o0000o`0000?ooooo0_l00002
ooooo`?o00000oooool2o`0000;ooooo0ol00003ooooo`?o00001_ooool4o`0000?ooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`2gooooo`004_ooool00ol0003oooooo`00000=oooo
o`03o`000?oooooooooo01?ooooo00?o0000ooooooooool06_ooool01Ol0003ooooooooooooooooo
000001?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooo
oooo01Sooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool0]oooool001;ooooo00Co0000oooooooooooo00000oooool0
0ol0003oooooooooo`05ooooo`;o00005?ooool2o`0001_ooooo0_l0000Hooooo`03o`000?oooooo
oooo00;ooooo0_l00008ooooo`;o00005oooool2o`0000gooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`0Aooooo`;o00000_ooool2o`0000?ooooo00?o0000ooooooooool0^?ooool0
0?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
0?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool000?ooooo00Co0000oooooooooooo0000
0_ooool3o`000004ooooool0003o0000o`0000;ooooo0_l000000ooooooo0000o`000005ooooo`?o
00001oooool01_l0003oooooo`000?oooooo0000ooooo`;o00000oooool4o`000004ooooool0003o
0000o`0000;ooooo0ol00003ooooo`03o`000?oooooooooo0?ooooooA?ooool000?ooooo00?o0000
ooooool000001?ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooool000002?oo
ool2o`0000Kooooo00Co0000ooooool0003ooooo0_l00002ooooo`03o`000?oooooo000000;ooooo
00Co0000ooooool0003o00001Oooool00ol0003oooooooooo`3oooooodWooooo0003ooooo`;o0000
1Oooool01Ol0003ooooooooooooooooo000000Cooooo0_l00007ooooo`;o00002?ooool01?l0003o
ooooo`000?ooool2o`0000;ooooo00?o0000ooooool000000_ooool01?l0003oooooo`000?ooool2
o`0000?ooooo00?o0000ooooooooool0oooooom9ooooo`000oooool2o`0000Cooooo0_l00002oooo
o`04o`000?oooooo0000o`0000;ooooo00?o0000ooooool000001oooool3o`0000Kooooo0_l00000
1?oooooo0000ooooooooool2o`0000?ooooo0ol00002ooooo`;o00001?ooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo0?ooooooA?ooool000?ooooo00?o0000ooooool000003Oooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool01_ooool0
0ol0003oooooooooo`3oooooodWooooo0003ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000
ooooooooool01Oooool2o`0000Cooooo00?o0000ooooooooool05oooool2o`0000Oooooo0_l0003o
oooood_ooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo000eooooo`?o0000COooool3o`000?oooooo
000gooooo`;o0000C_ooool2o`000?kooooo000eooooo`;o0000C_ooool2o`000?oooooo0Oooool0
03Kooooo0ol0001=ooooo`?o0000o_ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?oo
ool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?oo
ool005kooooo00?o0000ooooooooool0oooooolWooooo`005?ooool00ol0003oooooooooo`18oooo
o`03o`000?oooooooooo04cooooo00?o0000ooooooooool0e_ooool001?ooooo00?o0000oooooooo
ool0BOooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0=Gooooo000Cooooo`03o`00
0?oooooooooo09Wooooo00?o0000ooooooooool0eOooool001;ooooo00?o0000ooooooooool00_oo
ool4o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`00
0002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`00
0002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`00
0002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`00
0002o`000003ooooool0003o000000;o00002oooool4o`000003ooooool0003o000000;o000000?o
ooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?o
ooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?o
ooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?o
ooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o00001?oo
ool00ol0003oooooooooo`3Dooooo`004oooool00ol0003oooooooooo`2Iooooo`03o`000?oooooo
oooo0=Gooooo000Cooooo`03o`000?oooooooooo09Wooooo00?o0000ooooooooool0eOooool001Co
oooo00?o0000ooooooooool0Uoooool00ol0003oooooooooo`3Fooooo`00oooooon8ooooo`00oooo
oon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00FOooool2o`0004kooooo
0_l0003Looooo`00Foooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0=Wooooo000J
ooooo`05o`000?ooooooooooooooool000000oooool2o`0000?ooooo0_l00003ooooo`;o00000ooo
ool01?l0003oooooooooooooool4o`0000Oooooo0ol00002ooooo`;o00004_ooool3o`0000cooooo
0_l00004ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_l00003ooooo`03o`00
0?oooooooooo00;ooooo0_l00003ooooo`;o00002?ooool3o`0000;ooooo0_l0000Booooo`?o0000
foooool001[ooooo00?o0000ooooooooool01?ooool01_l0003oooooooooool0003oooooo`0000;o
oooo00?o0000ooooool000000_ooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo
00Sooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?oooooo
ooooo`0000_ooooo00Co0000oooooooooooo00002Oooool00ol0003oooooo`000002ooooo`05o`00
0?ooooooooooooooool000000_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000
ooooooooool01_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00kooooo00Co
0000oooooooooooo0000foooool001Oooooo1?l00009ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooool000000_ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool0
1oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00kooooo00Co0000oooooooo
oooo00003_ooool00ol0003oooooooooo`04ooooo`Co000000Goooooo`000?ooooooooooo`000002
ooooo`?o000000Goooooo`000?ooooooooooo`000004ooooo`03o`000?oooooooooo00Kooooo00Co
0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`000=_o
oooo000Hooooo`03o`000?oooooo000000Sooooo00?o0000ooooooooool00_ooool01?l0003ooooo
ooooool00002ooooo`05o`000?ooooooooooooooool000001Oooool00ol0003oooooooooo`06oooo
o`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool03oooool3o`0000gooooo00?o0000
ooooooooool01_ooool01?l0003oooooo`000?ooool3o`0000;ooooo00Ko0000oooooooooooo0000
ooooool00002ooooo`05o`000?ooooooooooooooool000002Oooool01?l0003oooooooooool00002
ooooo`03o`000?oooooooooo00oooooo0ol0003Kooooo`006Oooool2o`0000Kooooo00Ko0000oooo
oooooooo0000ooooool00002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool000000_oo
ool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo0000
0_ooool00ol0003oooooooooo`0Mooooo`04o`000?ooooooooooo`0000Sooooo0_l00002ooooo`05
o`000?ooooooooooooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo0000
00;ooooo00?o0000ooooooooool01_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooo
oooo0>gooooo000Jooooo`03o`000?oooooooooo00Gooooo0_l00003ooooo`;o00000oooool2o`00
00;ooooo1?l00002ooooo`;o00002?ooool2o`0000?ooooo0_l0000Qooooo`;o00002_ooool01Ol0
003ooooooooooooooooo000000?ooooo0_l00003ooooo`;o00000oooool2o`0000Sooooo0_l00003
ooooo`;o0000l?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?oo
ool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool004oooooo00?o
0000ooooooooool0COooool00ol0003oooooooooo`3Uooooo`00Coooool00ol0003oooooooooo`1=
ooooo`03o`000?oooooooooo0>Gooooo0019ooooo`Co00000oooool00ol0003oooooooooo`16oooo
o`Co00000oooool00ol0003oooooooooo`3Tooooo`00D?ooool00ol0003oooooooooo`1=ooooo`03
o`000?oooooooooo0>Cooooo001>ooooo`04o`000?ooooooooooo`0004cooooo00Co0000oooooooo
oooo0000iOooool004kooooo1?l0001<ooooo`Co0000iOooool00?ooooooR?ooool00?ooooooR?oo
ool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00;Sooooo0_l00003ooooo`03o`00
0?oooooooooo0<Oooooo001^ooooo`03o`000?oooooooooo04Wooooo00Go0000oooooooooooooooo
o`00000=ooooo`03o`000?oooooooooo0;Sooooo000Booooo`04o`000?ooooooooooo`0000;ooooo
0ol000001?oooooo0000o`000?l00002ooooo`;o000000Ooooooo`000?l0003oooooo`000?oooooo
000000;ooooo0_l00003ooooo`;o00000oooool4o`0000Gooooo0ol00003ooooo`?o000000Cooooo
o`000?l0003o00000oooool3o`0000;ooooo0ol00003ooooo`;o000000Coooooo`000?l0003o0000
1?ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooooooo`Co00001_ooool4o`000004
ooooool0003o0000o`0000?ooooo0ol00002ooooo`?o00001oooool7o`0000?ooooo0ol00002oooo
o`?o000000Goooooo`000?ooooooooooo`000002ooooo`?o000000Goooooo`000?ooooooooooo`00
0002ooooo`?o00000oooool00ol0003oooooooooo`04o`0000;ooooo0ol00003ooooo`03o`000?oo
oooooooo0;Oooooo000Booooo`03o`000?oooooo000000Cooooo00Go0000ooooooooooooooooo`00
0004ooooo`03o`000?oooooo000000;ooooo00Go0000ooooool0003oooooo`000002ooooo`03o`00
0?oooooo000000;ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`05ooooo`04o`00
0?ooooooooooooooo`;o00001Oooool2o`000005ooooool0003oooooooooool000000oooool01Ol0
003ooooooooooooooooo000000Gooooo0_l0000<ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooooooo`;o00000ooo
ool2o`0000Sooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo000000;o
oooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000?ooooo00Co0000
oooooooooooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0;Oooooo000B
ooooo`;o00001Oooool01Ol0003ooooooooooooooooo000000Cooooo0_l00002ooooo`04o`000?oo
oooo0000ooooo`;o00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo
00?o0000ooooooooool01Oooool01_l0003ooooooooooooooooo0000ooooo`;o000000?oooooo`00
0?l000000oooool01?l0003oooooooooool00003ooooo`05o`000?ooooooooooooooool000000ooo
ool2o`0000gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00;ooooo00Ko0000ooooooooooooooooo`000?ooool2o`000003ooooool0003ooooo00;o
000000?oooooo`000?l000000_l000001Ooooooo0000oooooooooooo000000;ooooo00?o0000oooo
ooooool00_ooool00ol0003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000
ooooooooooooooooo`000002ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`2fooooo`004_ooool2o`0000Cooooo0_l00002ooooo`04o`000?oooooo0000o`0000;o
oooo00[o0000ooooool0003oooooo`000?oooooo0000ooooool0003ooooo0_l00003ooooo`;o0000
0oooool3o`0000Kooooo00Co0000ooooool0003o00000_ooool2o`0000?ooooo0ol000001Ooooooo
0000oooooooooooo000000?ooooo00?o0000ooooooooool01?l00002ooooo`?o00000oooool00ol0
003oooooooooo`06ooooo`04o`000?ooooooooooooooo`Co00001_ooool4o`000003ooooool0003o
oooo00;o00000_ooool2o`0000?ooooo0_l00008ooooo`?o000000?oooooo`000?ooool00_l00000
1?oooooo0000o`000?l00003ooooo`;o00000_ooool3o`0000?ooooo0_l00002ooooo`?o00000ooo
ool3o`0000Kooooo1?l00003ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0]ooo
ool001;ooooo00?o0000ooooool000003Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooo
oooo01[ooooo00Go0000ooooooooooooooooo`00000Cooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool01oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo02Sooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0;Oooooo000B
ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool01Oooool2o`0001Cooooo0_l0
000Kooooo`;o00006?ooool00ol0003oooooooooo`02ooooo`;o00002?ooool2o`0001Oooooo0_l0
000=ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool04Oooool2o`0000;ooooo0_l0
0003ooooo`03o`000?oooooooooo0;Sooooo003oooooohSooooo003oooooohSooooo003oooooohSo
oooo003oooooohSooooo003oooooohSooooo003oooooohSooooo0009ooooo`03o`000?oooooooooo
0?ooooooO?ooool000[ooooo00?o0000ooooooooool0oooooomkooooo`000oooool01Ol0003ooooo
oooooooooooo000000;ooooo00?o0000ooooooooool01Oooool01_l0003oooooo`000?oooooo0000
ooooo`;o00000oooool4o`000004ooooool0003o0000o`0000;ooooo0ol00003ooooo`03o`000?oo
oooooooo0?ooooooF?ooool000?ooooo00Wo0000ooooooooooooooooo`000?oooooo0000ooooool0
00001_ooool01?l0003oooooo`000?ooool2o`0000;ooooo00?o0000ooooool000000_ooool01?l0
003oooooo`000?l00005ooooo`03o`000?oooooooooo0?ooooooGOooool000?ooooo00Wo0000oooo
ooooooooooooo`000?oooooo0000ooooool000001_ooool01?l0003oooooo`000?ooool2o`0000;o
oooo00?o0000ooooool000000_ooool01?l0003oooooo`000?ooool2o`0000?ooooo00?o0000oooo
ooooool0oooooomMooooo`000oooool01?l0003oooooo`000?ooool3o`000003ooooool0003o0000
00Gooooo0_l000001?oooooo0000ooooooooool2o`0000?ooooo0ol00002ooooo`;o00001?ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo0?ooooooF?ooool000?ooooo0_l000000ooo
oooo0000o`00000Gooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0oooooomMoooo
o`000oooool01Ol0003ooooooooooooooooo000001Kooooo0_l00007ooooo`;o0000oooooomOoooo
o`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8oooo
o`00<?ooool2o`0000gooooo0_l0003oooooodOooooo000`ooooo`03o`000?oooooooooo00cooooo
00?o0000ooooooooool0oooooom6ooooo`000oooool4o`0000;ooooo0_l00003ooooo`;o00001?oo
ool00ol0003oooooooooo`04o`0000;ooooo0_l00003ooooo`;o00001oooool3o`0000;ooooo0ol0
0007ooooo`?o00000_ooool3o`0000?ooooo0ol00002ooooo`?o00000_ooool3o`000004ooooool0
003o0000o`000?oooooo<_ooool000Cooooo00Go0000ooooooooooooooooo`000002ooooo`03o`00
0?oooooo000000;ooooo00?o0000ooooooooool01Oooool01Ol0003ooooooooooooooooo000000;o
oooo00?o0000ooooool000000_ooool00ol0003oooooooooo`04ooooo`06o`000?ooooooooooo`00
0?oooooo00000_ooool00ol0003oooooooooo`06ooooo`;o000000Ooooooo`000?ooooooooooo`00
0?oooooo000000;ooooo00?o0000ooooool000001?ooool2o`0000Cooooo00?o0000ooooooooool0
oooooolaooooo`001Oooool01?l0003oooooooooool00002ooooo`03o`000?oooooo000000;ooooo
00?o0000ooooooooool01_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool01?ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000oooo
ooooool01?ooool2o`0000?ooooo00Co0000oooooooooooo00000_ooool01Ol0003oooooo`000?oo
oooo000000;ooooo00Co0000ooooool0003ooooo0_l00002ooooo`03o`000?oooooooooo0?oooooo
<Oooool000Kooooo00?o0000ooooool000000_l00003ooooo`;o00002_ooool01Ol0003ooooooooo
oooooooo000000;ooooo0ol00007ooooo`?o00000_ooool3o`0000Sooooo0ol000001?oooooo0000
o`000?l00002ooooo`?o00000oooool3o`0000;ooooo0_l00002ooooo`04o`000?oooooo0000o`00
0?oooooo<Oooool000?ooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo
000000;ooooo00?o0000ooooooooool01?ooool01_l0003oooooooooool0003oooooo`0000;ooooo
00?o0000ooooool000002Oooool00ol0003oooooooooo`3ooooooe[ooooo0004ooooo`;o00001?oo
ool01?l0003oooooooooooooool2o`0000Sooooo0_l00003ooooo`;o00000_ooool4o`0000Kooooo
00?o0000ooooooooool0oooooomJooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8oooo
o`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8oooo
o`00=Oooool3o`0004gooooo0ol0003oooooo`00=oooool2o`0004kooooo0_l0003nooooo`00=Ooo
ool2o`0004kooooo0_l0003oooooo`7ooooo000fooooo`?o0000COooool3o`000?kooooo003ooooo
ohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003ooooo
ohSooooo003oooooohSooooo001Nooooo`03o`000?oooooooooo0?oooooo9oooool001Cooooo00?o
0000ooooooooool0B?ooool00ol0003oooooooooo`1<ooooo`03o`000?oooooooooo0=Kooooo000C
ooooo`03o`000?oooooooooo04Wooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`3E
ooooo`004oooool00ol0003oooooooooo`2Iooooo`03o`000?oooooooooo0=Gooooo000Booooo`03
o`000?oooooooooo00;ooooo1?l000000ooooooo0000o`000002o`000003ooooool0003o000000;o
000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o
000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o
000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o
000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`0000_ooooo1?l000000ooooooo
0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo
0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo
0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo
0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo
0000o`000002o`0000Cooooo00?o0000ooooooooool0e?ooool001?ooooo00?o0000ooooooooool0
VOooool00ol0003oooooooooo`3Eooooo`004oooool00ol0003oooooooooo`2Iooooo`03o`000?oo
oooooooo0=Gooooo000Dooooo`03o`000?oooooooooo09Oooooo00?o0000ooooooooool0e_ooool0
0?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
0?ooooooR?ooool005Wooooo0_l0001>ooooo`;o0000g?ooool005_ooooo00?o0000ooooooooool0
COooool00ol0003oooooooooo`3Iooooo`006?ooool2o`0000Cooooo00Co0000oooooooooooooooo
0_l00003ooooo`?o00000_ooool2o`0000;ooooo1?l00002ooooo`;o00002?ooool3o`0000;ooooo
0_l0000Booooo`?o00002oooool4o`0000?ooooo00Co0000oooooooooooooooo0_l00002ooooo`Co
00000_ooool2o`0000?ooooo0_l00003ooooo`03o`000?oooooooooo00Oooooo0ol00002ooooo`;o
00004_ooool3o`000=_ooooo000Gooooo`04o`000?ooooooooooo`0000Kooooo00Co0000oooooooo
oooo00000oooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000?ooooo00Co
0000oooooooooooo00002?ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00ko
oooo00Co0000oooooooooooo00003?ooool00ol0003oooooooooo`06ooooo`04o`000?oooooooooo
o`0000;ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo000000;ooooo00Go
0000ooooooooooooooooo`000009ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooooooo
ool03_ooool01?l0003oooooooooool0003Kooooo`005oooool01?l0003oooooooooool00006oooo
o`04o`000?ooooooooooo`0000?ooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooo
oooooooo000000;ooooo00Co0000oooooooooooo00002?ooool01?l0003oooooooooool00002oooo
o`03o`000?oooooooooo00kooooo00Co0000oooooooooooo00003Oooool00ol0003oooooooooo`05
ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo00?o00002?ooool01?l0003oooooooooool00002ooooo`03o`00
0?oooooooooo00kooooo00Co0000oooooooooooo0000foooool001Oooooo0ol00007ooooo`?o0000
1?ooool00ol0003oooooooooo`03o`0000Gooooo00?o0000ooooool000000_l00009ooooo`04o`00
0?ooooooooooo`0000;ooooo00?o0000ooooooooool03oooool3o`0000kooooo00?o0000oooooooo
ool01?ooool01?l0003oooooooooool00004ooooo`03o`000?oooooo000000;o00000_ooool3o`00
00;ooooo00Co0000oooooooooooo00002?ooool01?l0003oooooooooool00002ooooo`03o`000?oo
oooooooo00oooooo0ol0003Kooooo`006?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooo
oooo00?ooooo00Go0000ooooooooooooooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo
00?o0000ooooooooool02?ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo01go
oooo00Co0000oooooooooooo00001_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o
0000ooooool000001?ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Sooooo
00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`3]ooooo`006Oooool00ol0003ooooo
ooooo`07ooooo`04o`000?ooooooooooooooo`;o00001?ooool01?l0003oooooooooooooool2o`00
00Cooooo00?o0000ooooooooool01_ooool2o`0000?ooooo0_l0000Qooooo`;o00002?ooool2o`00
00?ooooo0_l00002ooooo`Co000000?oooooo`000?l000000_l00002ooooo`;o00002?ooool2o`00
00?ooooo0_l0003`ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8
ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00Coooool00ol0003ooooooooo
o`1=ooooo`03o`000?oooooooooo0>Gooooo001?ooooo`03o`000?oooooooooo04gooooo00?o0000
ooooooooool0iOooool004Wooooo1?l00003ooooo`03o`000?oooooooooo04Kooooo1?l00003oooo
o`03o`000?oooooooooo0>Cooooo001@ooooo`03o`000?oooooooooo04gooooo00?o0000oooooooo
ool0i?ooool004kooooo00Co0000oooooooooooo0000C?ooool01?l0003oooooooooool0003Uoooo
o`00C_ooool4o`0004cooooo1?l0003Uooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8
ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00^?ooool2o`0000?ooooo00?o
0000ooooooooool0aoooool006kooooo00?o0000ooooooooool0BOooool01Ol0003ooooooooooooo
oooo000000gooooo00?o0000ooooooooool0^?ooool001;ooooo00Co0000oooooooooooo00000_oo
ool3o`000004ooooool0003o0000o`0000;ooooo0_l000001ooooooo0000o`000?oooooo0000oooo
ool000000_ooool2o`0000?ooooo0_l00003ooooo`Co00001Oooool3o`0000?ooooo0ol000001?oo
oooo0000o`000?l00003ooooo`?o00000_ooool3o`0000?ooooo0_l000001?oooooo0000o`000?l0
0004ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooooooo1?l00006ooooo`Co0000
00Coooooo`000?l0003o00000oooool3o`0000;ooooo0ol00007ooooo`Oo00000oooool3o`0000;o
oooo0ol000001Ooooooo0000oooooooooooo000000;ooooo0ol000001Ooooooo0000oooooooooooo
000000;ooooo0ol00003ooooo`03o`000?oooooooooo00Co00000_ooool3o`0000?ooooo00?o0000
ooooooooool0]oooool001;ooooo00?o0000ooooool000001?ooool01Ol0003ooooooooooooooooo
000000Cooooo00?o0000ooooool000000_ooool01Ol0003oooooo`000?oooooo000000;ooooo00?o
0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Gooooo00Co
0000oooooooooooooooo0_l00005ooooo`;o000000Goooooo`000?ooooooooooo`000003ooooo`05
o`000?ooooooooooooooool000001Oooool2o`0000cooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooooooo0_l00003
ooooo`;o00002?ooool01?l0003oooooooooool00002ooooo`05o`000?ooooooooooooooool00000
0_ooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo00000oooool01?l0
003oooooooooool00002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0]oooool0
01;ooooo0_l00005ooooo`05o`000?ooooooooooooooool000001?ooool2o`0000;ooooo00Co0000
ooooool0003ooooo0_l00002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool000000_oo
ool00ol0003oooooooooo`05ooooo`06o`000?ooooooooooooooool0003ooooo0_l000000ooooooo
0000o`000003ooooo`04o`000?ooooooooooo`0000?ooooo00Go0000ooooooooooooooooo`000003
ooooo`;o00003Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool00_ooool01_l0003ooooooooooooooooo0000ooooo`;o000000?oooooo`000?ooool0
0_l000000ooooooo0000o`000002o`000005ooooool0003oooooooooool000000_ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooo000000?ooooo00Co0000oooooooooooo00000_ooool01Ol0
003ooooooooooooooooo000000;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo0;Kooooo000Booooo`;o00001?ooool2o`0000;ooooo00Co0000ooooool0003o0000
0_ooool02_l0003oooooo`000?oooooo0000ooooool0003oooooo`000?ooool2o`0000?ooooo0_l0
0003ooooo`?o00001_ooool01?l0003oooooo`000?l00002ooooo`;o00000oooool3o`000005oooo
ool0003oooooooooool000000oooool00ol0003oooooooooo`04o`0000;ooooo0ol00003ooooo`03
o`000?oooooooooo00Kooooo00Co0000oooooooooooooooo1?l00006ooooo`Co000000?oooooo`00
0?ooool00_l00002ooooo`;o00000oooool2o`0000Sooooo0ol000000ooooooo0000ooooo`02o`00
0004ooooool0003o0000o`0000?ooooo0_l00002ooooo`?o00000oooool2o`0000;ooooo0ol00003
ooooo`?o00001_ooool4o`0000?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2g
ooooo`004_ooool00ol0003oooooo`00000=ooooo`03o`000?oooooooooo01?ooooo00?o0000oooo
ooooool06_ooool01Ol0003ooooooooooooooooo000001?ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool0:?ooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0]oooool0
01;ooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`05ooooo`;o00005?ooool2
o`0001_ooooo0_l0000Hooooo`03o`000?oooooooooo00;ooooo0_l00008ooooo`;o00005oooool2
o`0000gooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Aooooo`;o00000_ooool2
o`0000?ooooo00?o0000ooooooooool0^?ooool00?ooooooR?ooool00?ooooooR?ooool00?oooooo
R?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool000?ooooo
00Co0000oooooooooooo00000_ooool3o`000004ooooool0003o0000o`0000;ooooo0_l000000ooo
oooo0000o`000005ooooo`?o00001oooool01_l0003oooooo`000?oooooo0000ooooo`;o00000ooo
ool4o`000004ooooool0003o0000o`0000;ooooo0ol00003ooooo`03o`000?oooooooooo0?oooooo
A?ooool000?ooooo00?o0000ooooool000001?ooool01Ol0003ooooooooooooooooo000000Cooooo
00?o0000ooooool000002?ooool2o`0000Kooooo00Co0000ooooool0003ooooo0_l00002ooooo`03
o`000?oooooo000000;ooooo00Co0000ooooool0003o00001Oooool00ol0003oooooooooo`3ooooo
odWooooo0003ooooo`;o00001Oooool01Ol0003ooooooooooooooooo000000Cooooo0_l00007oooo
o`;o00002?ooool01?l0003oooooo`000?ooool2o`0000;ooooo00?o0000ooooool000000_ooool0
1?l0003oooooo`000?ooool2o`0000?ooooo00?o0000ooooooooool0oooooom9ooooo`000oooool2
o`0000Cooooo0_l00002ooooo`04o`000?oooooo0000o`0000;ooooo00?o0000ooooool000001ooo
ool3o`0000Kooooo0_l000001?oooooo0000ooooooooool2o`0000?ooooo0ol00002ooooo`;o0000
1?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0?ooooooA?ooool000?ooooo00?o
0000ooooool000003Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo01Sooooo00?o
0000ooooooooool01_ooool00ol0003oooooooooo`3oooooodWooooo0003ooooo`04o`000?oooooo
ooooo`0000?ooooo00?o0000ooooooooool01Oooool2o`0000Cooooo00?o0000ooooooooool05ooo
ool2o`0000Oooooo0_l0003ooooood_ooooo003oooooohSooooo003oooooohSooooo003oooooohSo
oooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSo
oooo000eooooo`?o0000COooool3o`000?oooooo000gooooo`;o0000C_ooool2o`000?kooooo000e
ooooo`;o0000C_ooool2o`000?oooooo0Oooool003Kooooo0ol0001=ooooo`?o0000o_ooool00?oo
ooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?oo
ooooR?ooool00?ooooooR?ooool005kooooo00?o0000ooooooooool0oooooolWooooo`005?ooool0
0ol0003oooooooooo`18ooooo`03o`000?oooooooooo04cooooo00?o0000ooooooooool0e_ooool0
01?ooooo00?o0000ooooooooool0BOooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo
0=Gooooo000Cooooo`03o`000?oooooooooo09Wooooo00?o0000ooooooooool0eOooool001;ooooo
00?o0000ooooooooool00_ooool4o`000003ooooool0003o000000;o000000?oooooo`000?l00000
0_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l00000
0_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l00000
0_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l00000
0_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o00002oooool4o`000003oooo
ool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003oooo
ool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003oooo
ool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003oooo
ool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003oooo
ool0003o000000;o00001?ooool00ol0003oooooooooo`3Dooooo`004oooool00ol0003ooooooooo
o`2Iooooo`03o`000?oooooooooo0=Gooooo000Cooooo`03o`000?oooooooooo09Wooooo00?o0000
ooooooooool0eOooool001Cooooo00?o0000ooooooooool0Uoooool00ol0003oooooooooo`3Foooo
o`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8oooo
o`00oooooon8ooooo`00FOooool2o`0004kooooo0_l0003Looooo`00Foooool00ol0003ooooooooo
o`1=ooooo`03o`000?oooooooooo0=Wooooo000Jooooo`05o`000?ooooooooooooooool000000ooo
ool3o`000003ooooool0003o000000;o00000_ooool2o`0000?ooooo0_l00003ooooo`?o00001ooo
ool3o`0000;ooooo0_l0000Booooo`?o00003?ooool2o`0000Cooooo00?o0000ooooooooool01?l0
0002ooooo`;o00001Oooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Wooooo
0ol00002ooooo`;o00004_ooool3o`000=_ooooo000Jooooo`03o`000?oooooooooo00Kooooo00Go
0000ooooooooooooooooo`000003ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool01Ol0
003ooooooooooooooooo000000Wooooo00Co0000oooooooooooo00000_ooool00ol0003ooooooooo
o`0>ooooo`04o`000?ooooooooooo`0000_ooooo00Co0000oooooooooooo00001oooool01Ol0003o
oooooooooooooooo000000;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02oooo
o`04o`000?ooooooooooo`0000[ooooo00Co0000oooooooooooo00000_ooool00ol0003ooooooooo
o`0>ooooo`04o`000?ooooooooooo`000=_ooooo000Gooooo`Co00002?ooool00ol0003ooooooooo
o`02ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000_ooool01Ol0003ooooo
oooooooooooo000000Wooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>oooo
o`04o`000?ooooooooooo`0000kooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`03
ooooo`03o`000?oooooo000000?o000000?oooooo`000?l000000_l00003ooooo`03o`000?oooooo
oooo00Oooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?oo
ooooooooo`000=_ooooo000Hooooo`03o`000?oooooo000000Sooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`02o`0000?ooooo0_l00004ooooo`03o`000?oooooooooo00Oooooo00Co
0000oooooooooooo00000_ooool00ol0003oooooooooo`0?ooooo`?o00003Oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooo000000;o00000oooool00ol0003oooooo`000002ooooo`03o`00
0?oooooo000000?ooooo00?o0000ooooooooool01oooool01?l0003oooooooooool00002ooooo`03
o`000?oooooooooo00oooooo0ol0003Kooooo`006Oooool2o`0000Sooooo00Co0000oooooooooooo
00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00Go0000oooooooo
ooooooooo`000009ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool07Oooool0
1?l0003oooooooooool00006ooooo`06o`000?ooooooooooo`000?oooooo00001_ooool2o`0000?o
oooo0_l000001Ooooooo0000oooooooooooo000000Sooooo00Co0000oooooooooooo00000_ooool0
0ol0003oooooooooo`3]ooooo`006_ooool00ol0003oooooooooo`05ooooo`;o00000oooool2o`00
00?ooooo0_l00003ooooo`;o00000oooool2o`0000Sooooo0_l00003ooooo`;o00008Oooool2o`00
00Sooooo0_l00002ooooo`Co00001?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo0000
00?o00001oooool2o`0000?ooooo0_l0003`ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooo
oon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00Cooo
ool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0>Gooooo001?ooooo`03o`000?oooooo
oooo04gooooo00?o0000ooooooooool0iOooool004Wooooo1?l00003ooooo`03o`000?oooooooooo
04Kooooo1?l00003ooooo`03o`000?oooooooooo0>Cooooo001@ooooo`03o`000?oooooooooo04go
oooo00?o0000ooooooooool0i?ooool004kooooo00Co0000oooooooooooo0000C?ooool01?l0003o
ooooooooool0003Uooooo`00C_ooool4o`0004cooooo1?l0003Uooooo`00oooooon8ooooo`00oooo
oon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00^?oo
ool2o`0000?ooooo00?o0000ooooooooool0aoooool006kooooo00?o0000ooooooooool0BOooool0
1Ol0003ooooooooooooooooo000000gooooo00?o0000ooooooooool0^?ooool001;ooooo00Co0000
oooooooooooo00000_ooool3o`000004ooooool0003o0000o`0000;ooooo0_l000001ooooooo0000
o`000?oooooo0000ooooool000000_ooool2o`0000?ooooo0_l00003ooooo`Co00001Oooool3o`00
00?ooooo0ol000001?oooooo0000o`000?l00003ooooo`?o00000_ooool3o`0000?ooooo0_l00000
1?oooooo0000o`000?l00004ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooooooo
1?l00006ooooo`Co000000Coooooo`000?l0003o00000oooool3o`0000;ooooo0ol00007ooooo`Oo
00000oooool3o`0000;ooooo0ol000001Ooooooo0000oooooooooooo000000;ooooo0ol000001Ooo
oooo0000oooooooooooo000000;ooooo0ol00003ooooo`03o`000?oooooooooo00Co00000_ooool3
o`0000?ooooo00?o0000ooooooooool0]oooool001;ooooo00?o0000ooooool000001?ooool01Ol0
003ooooooooooooooooo000000Cooooo00?o0000ooooool000000_ooool01Ol0003oooooo`000?oo
oooo000000;ooooo00?o0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oo
oooooooo00Gooooo00Co0000oooooooooooooooo0_l00005ooooo`;o000000Goooooo`000?oooooo
ooooo`000003ooooo`05o`000?ooooooooooooooool000001Oooool2o`0000cooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00;ooooo00Co0000oooo
oooooooooooo0_l00003ooooo`;o00002?ooool01?l0003oooooooooool00002ooooo`05o`000?oo
ooooooooooooool000000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooo
oooo00000oooool01?l0003oooooooooool00002ooooo`03o`000?oooooo000000;ooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool0]oooool001;ooooo0_l00005ooooo`05o`000?ooooooooooooooool000001?ooool2
o`0000;ooooo00Co0000ooooool0003ooooo0_l00002ooooo`03o`000?oooooo000000;ooooo00?o
0000ooooool000000_ooool00ol0003oooooooooo`05ooooo`06o`000?ooooooooooooooool0003o
oooo0_l000000ooooooo0000o`000003ooooo`04o`000?ooooooooooo`0000?ooooo00Go0000oooo
ooooooooooooo`000003ooooo`;o00003Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool00_ooool01_l0003ooooooooooooooooo0000ooooo`;o0000
00?oooooo`000?ooool00_l000000ooooooo0000o`000002o`000005ooooool0003oooooooooool0
00000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo000000?ooooo00Co0000oooooooo
oooo00000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Ko0000oooooooooooo0000oooo
ool00002ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo0;Kooooo000Booooo`;o00001?ooool2o`0000;ooooo00Co
0000ooooool0003o00000_ooool02_l0003oooooo`000?oooooo0000ooooool0003oooooo`000?oo
ool2o`0000?ooooo0_l00003ooooo`?o00001_ooool01?l0003oooooo`000?l00002ooooo`;o0000
0oooool3o`000005ooooool0003oooooooooool000000oooool00ol0003oooooooooo`04o`0000;o
oooo0ol00003ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooooooo1?l00006oooo
o`Co000000?oooooo`000?ooool00_l00002ooooo`;o00000oooool2o`0000Sooooo0ol000000ooo
oooo0000ooooo`02o`000004ooooool0003o0000o`0000?ooooo0_l00002ooooo`?o00000oooool2
o`0000;ooooo0ol00003ooooo`?o00001_ooool4o`0000?ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`2gooooo`004_ooool00ol0003oooooo`00000=ooooo`03o`000?oooooooooo
01?ooooo00?o0000ooooooooool06_ooool01Ol0003ooooooooooooooooo000001?ooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo01Sooooo00?o0000
ooooooooool0:?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool0]oooool001;ooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`05
ooooo`;o00005?ooool2o`0001_ooooo0_l0000Hooooo`03o`000?oooooooooo00;ooooo0_l00008
ooooo`;o00005oooool2o`0000gooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0A
ooooo`;o00000_ooool2o`0000?ooooo00?o0000ooooooooool0^?ooool00?ooooooR?ooool00?oo
ooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool000Wooooo00?o0000oooo
ooooool0oooooomlooooo`002_ooool00ol0003oooooooooo`3oooooog_ooooo0003ooooo`05o`00
0?ooooooooooooooool000000_ooool00ol0003oooooooooo`05ooooo`06o`000?oooooo0000oooo
ool0003ooooo0_l00003ooooo`Co000000Coooooo`000?l0003o00000_ooool3o`0000?ooooo00?o
0000ooooooooool0oooooomHooooo`000oooool02Ol0003ooooooooooooooooo0000ooooool0003o
ooooo`000006ooooo`04o`000?oooooo0000ooooo`;o00000_ooool00ol0003oooooo`000002oooo
o`04o`000?oooooo0000o`0000Gooooo00?o0000ooooooooool0oooooomMooooo`000oooool02Ol0
003ooooooooooooooooo0000ooooool0003oooooo`000006ooooo`04o`000?oooooo0000ooooo`;o
00000_ooool00ol0003oooooo`000002ooooo`04o`000?oooooo0000ooooo`;o00000oooool00ol0
003oooooooooo`3ooooooegooooo0003ooooo`04o`000?oooooo0000ooooo`?o000000?oooooo`00
0?l000001Oooool2o`000004ooooool0003oooooooooo`;o00000oooool3o`0000;ooooo0_l00004
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0oooooomHooooo`000oooool2o`00
0003ooooool0003o000001Oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`3ooooo
oegooooo0003ooooo`05o`000?ooooooooooooooool000005_ooool2o`0000Oooooo0_l0003ooooo
oeoooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003ooooo
ohSooooo003oooooohSooooo000`ooooo`;o00003Oooool2o`000?ooooooAoooool0033ooooo00?o
0000ooooooooool03?ooool00ol0003oooooooooo`3oooooodKooooo0003ooooo`Co00000_ooool2
o`0000Gooooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooooooo00;ooooo0_l0
0003ooooo`;o00001oooool3o`0000;ooooo0ol00007ooooo`?o00000_ooool3o`0000?ooooo0ol0
0002ooooo`?o00000_ooool3o`000004ooooool0003o0000o`000?oooooo<_ooool000Cooooo00Go
0000ooooooooooooooooo`000002ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
1Oooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooool000000_ooool00ol0003o
ooooooooo`04ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003oooooooooo`06
ooooo`;o000000Ooooooo`000?ooooooooooo`000?oooooo000000;ooooo00?o0000ooooool00000
1?ooool2o`0000Cooooo00?o0000ooooooooool0oooooolaooooo`001Oooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooo000000?o00002?ooool01?l0003oooooooooool00002ooooo`03o`00
0?oooooo000000;ooooo00?o0000ooooooooool01?ooool01_l0003oooooooooool0003oooooo`00
00;ooooo00?o0000ooooooooool01?ooool2o`0000?ooooo00Co0000oooooooooooo00000_ooool0
1Ol0003oooooo`000?oooooo000000;ooooo00Co0000ooooool0003ooooo0_l00002ooooo`03o`00
0?oooooooooo0?oooooo<Oooool000Kooooo00Go0000ooooooooooooooooo`000003ooooo`03o`00
0?oooooo000000Sooooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`000002o`0000Oo
oooo0ol00002ooooo`?o00002?ooool3o`000004ooooool0003o0000o`0000;ooooo0ol00003oooo
o`?o00000_ooool2o`0000;ooooo00Co0000ooooool0003o0000oooooolaooooo`000oooool01_l0
003oooooooooool0003oooooo`0000;ooooo00Co0000oooooooooooooooo0_l00006ooooo`06o`00
0?ooooooooooo`000?oooooo00000_ooool01?l0003oooooooooool00008ooooo`03o`000?oooooo
oooo0?ooooooF_ooool000Cooooo0_l00003ooooo`;o00001Oooool00ol0003oooooooooo`04oooo
o`Co00000_ooool2o`0000Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`3ooooo
oe[ooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003ooooo
ohSooooo003oooooohSooooo003oooooohSooooo000eooooo`?o0000COooool3o`000?oooooo000g
ooooo`;o0000C_ooool2o`000?kooooo000eooooo`;o0000C_ooool2o`000?oooooo0Oooool003Ko
oooo0ol0001=ooooo`?o0000o_ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
0?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
05kooooo00?o0000ooooooooool0oooooolWooooo`005?ooool00ol0003oooooooooo`18ooooo`03
o`000?oooooooooo04cooooo00?o0000ooooooooool0e_ooool001?ooooo00?o0000ooooooooool0
BOooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0=Gooooo000Cooooo`03o`000?oo
oooooooo09Wooooo00?o0000ooooooooool0eOooool001;ooooo00?o0000ooooooooool00_ooool4
o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002
o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002
o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002
o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002
o`000003ooooool0003o000000;o00002oooool4o`000003ooooool0003o000000;o000000?ooooo
o`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?ooooo
o`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?ooooo
o`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?ooooo
o`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o00001?ooool0
0ol0003oooooooooo`3Dooooo`004oooool00ol0003oooooooooo`2Iooooo`03o`000?oooooooooo
0=Gooooo000Cooooo`03o`000?oooooooooo09Wooooo00?o0000ooooooooool0eOooool001Cooooo
00?o0000ooooooooool0Uoooool00ol0003oooooooooo`3Fooooo`00oooooon8ooooo`00oooooon8
ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00FOooool2o`0004kooooo0_l0
003Looooo`00Foooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0=Wooooo000Hoooo
o`;o00001?ooool01Ol0003ooooooooooooooooo000000Cooooo0_l00002ooooo`Co00000_ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Oooooo0ol00002ooooo`;o00004_ooool3
o`0000cooooo0ol00003ooooo`05o`000?ooooooooooooooool000001?ooool3o`000003ooooool0
003o000000;o000000?oooooo`000?l000000_l00002ooooo`03o`000?oooooooooo00Oooooo0ol0
0002ooooo`;o00004_ooool3o`000=_ooooo000Gooooo`04o`000?ooooooooooo`0000Sooooo00Co
0000oooooooooooo00000_ooool01?l0003oooooooooool00005ooooo`05o`000?oooooooooooooo
ool000002_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00kooooo00Co0000
oooooooooooo00003Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00;ooooo00Go
0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
2?ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00kooooo00Co0000oooooooo
oooo0000foooool001[ooooo00?o0000ooooooooool01Oooool3o`000005ooooool0003ooooooooo
ool000000oooool01?l0003oooooooooooooool3o`0000?ooooo00?o0000ooooooooool01oooool0
1?l0003oooooooooool00002ooooo`03o`000?oooooooooo00kooooo00Co0000oooooooooooo0000
3Oooool00ol0003oooooooooo`06ooooo`?o00000oooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`07ooooo`04o`00
0?ooooooooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0003oooooooooool0003Koooo
o`005oooool3o`0000Oooooo00Co0000oooooooooooo00000_ooool2o`0000Gooooo00?o0000oooo
ool000000_ooool01Ol0003ooooooooooooooooo000000Wooooo00Co0000oooooooooooo00000_oo
ool00ol0003oooooooooo`0?ooooo`?o00003Oooool00ol0003oooooooooo`05ooooo`04o`000?oo
ooooooooo`0000?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`05o`00
0?ooooooooooooooool000002Oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo
00oooooo0ol0003Kooooo`005oooool00ol0003oooooooooo`07ooooo`06o`000?ooooooooooo`00
0?oooooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000
ooooool000000_ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`0000;ooooo00?o
0000ooooooooool07oooool00ol0003oooooooooo`05ooooo`04o`000?ooooooooooo`0000?ooooo
00Co0000oooooooooooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000;o
oooo00?o0000ooooooooool01_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo
0>gooooo000Gooooo`Co00001oooool2o`0000?ooooo0_l00003ooooo`;o00000oooool2o`0000;o
oooo1?l00007ooooo`;o00000oooool2o`00027ooooo0_l00008ooooo`;o00000oooool2o`0000?o
oooo0_l00003ooooo`;o00000_ooool4o`0000Oooooo0_l00003ooooo`;o0000l?ooool00?oooooo
R?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?oooooo
R?ooool00?ooooooR?ooool00?ooooooR?ooool004oooooo00?o0000ooooooooool0COooool00ol0
003oooooooooo`3Uooooo`00Coooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0>Go
oooo0019ooooo`Co00000oooool00ol0003oooooooooo`16ooooo`Co00000oooool00ol0003ooooo
ooooo`3Tooooo`00D?ooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0>Cooooo001>
ooooo`04o`000?ooooooooooo`0004cooooo00Co0000oooooooooooo0000iOooool004kooooo1?l0
001<ooooo`Co0000iOooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?oooooo
R?ooool00?ooooooR?ooool00;Sooooo0_l00003ooooo`03o`000?oooooooooo0<Oooooo001^oooo
o`03o`000?oooooooooo04Wooooo00Go0000ooooooooooooooooo`00000=ooooo`03o`000?oooooo
oooo0;Sooooo000Booooo`04o`000?ooooooooooo`0000;ooooo0ol000001?oooooo0000o`000?l0
0002ooooo`;o000000Ooooooo`000?l0003oooooo`000?oooooo000000;ooooo0_l00003ooooo`;o
00000oooool4o`0000Gooooo0ol00003ooooo`?o000000Coooooo`000?l0003o00000oooool3o`00
00;ooooo0ol00003ooooo`;o000000Coooooo`000?l0003o00001?ooool00ol0003oooooooooo`06
ooooo`04o`000?ooooooooooooooo`Co00001_ooool4o`000004ooooool0003o0000o`0000?ooooo
0ol00002ooooo`?o00001oooool7o`0000?ooooo0ol00002ooooo`?o000000Goooooo`000?oooooo
ooooo`000002ooooo`?o000000Goooooo`000?ooooooooooo`000002ooooo`?o00000oooool00ol0
003oooooooooo`04o`0000;ooooo0ol00003ooooo`03o`000?oooooooooo0;Oooooo000Booooo`03
o`000?oooooo000000Cooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooo0000
00;ooooo00Go0000ooooool0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000
ooooool000000_ooool00ol0003oooooooooo`05ooooo`04o`000?ooooooooooooooo`;o00001Ooo
ool2o`000005ooooool0003oooooooooool000000oooool01Ol0003ooooooooooooooooo000000Go
oooo0_l0000<ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`02ooooo`04o`000?ooooooooooooooo`;o00000oooool2o`0000Sooooo00Co0000oooo
oooooooo00000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000oooooooooooooooo
o`000002ooooo`04o`000?ooooooooooo`0000?ooooo00Co0000oooooooooooo00000_ooool00ol0
003oooooo`000002ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo0;Oooooo000Booooo`;o00001Oooool01Ol0003o
oooooooooooooooo000000Cooooo0_l00002ooooo`04o`000?oooooo0000ooooo`;o00000_ooool0
0ol0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool01Oooool0
1_l0003ooooooooooooooooo0000ooooo`;o000000?oooooo`000?l000000oooool01?l0003ooooo
ooooool00003ooooo`05o`000?ooooooooooooooool000000oooool2o`0000gooooo00?o0000oooo
ooooool00oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00;ooooo00Ko0000oooo
ooooooooooooo`000?ooool2o`000003ooooool0003ooooo00;o000000?oooooo`000?l000000_l0
00001Ooooooo0000oooooooooooo000000;ooooo00?o0000ooooooooool00_ooool00ol0003ooooo
o`000003ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000ooooooooooooooooo`000002oooo
o`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2fooooo`004_ooool2
o`0000Cooooo0_l00002ooooo`04o`000?oooooo0000o`0000;ooooo00[o0000ooooool0003ooooo
o`000?oooooo0000ooooool0003ooooo0_l00003ooooo`;o00000oooool3o`0000Kooooo00Co0000
ooooool0003o00000_ooool2o`0000?ooooo0ol000001Ooooooo0000oooooooooooo000000?ooooo
00?o0000ooooooooool01?l00002ooooo`?o00000oooool00ol0003oooooooooo`06ooooo`04o`00
0?ooooooooooooooo`Co00001_ooool4o`000003ooooool0003ooooo00;o00000_ooool2o`0000?o
oooo0_l00008ooooo`?o000000?oooooo`000?ooool00_l000001?oooooo0000o`000?l00003oooo
o`;o00000_ooool3o`0000?ooooo0_l00002ooooo`?o00000oooool3o`0000Kooooo1?l00003oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0]oooool001;ooooo00?o0000ooooool0
00003Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo01[ooooo00Go0000oooooooo
ooooooooo`00000Cooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`0Hooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo0;Oooooo000Booooo`04o`000?ooooooooooo`00
00?ooooo00?o0000ooooooooool01Oooool2o`0001Cooooo0_l0000Kooooo`;o00006?ooool00ol0
003oooooooooo`02ooooo`;o00002?ooool2o`0001Oooooo0_l0000=ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool04Oooool2o`0000;ooooo0_l00003ooooo`03o`000?oooooooooo
0;Sooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003ooooo
ohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo0003ooooo`04o`000?oooooo
ooooo`0000;ooooo0ol000001?oooooo0000o`000?l00002ooooo`;o000000?oooooo`000?l00000
1Oooool3o`0000Oooooo00Ko0000ooooool0003oooooo`000?ooool2o`0000?ooooo1?l000001?oo
oooo0000o`000?l00002ooooo`?o00000oooool00ol0003oooooooooo`3oooooodCooooo0003oooo
o`03o`000?oooooo000000Cooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooo
000000Sooooo0_l00006ooooo`04o`000?oooooo0000ooooo`;o00000_ooool00ol0003oooooo`00
0002ooooo`04o`000?oooooo0000o`0000Gooooo00?o0000ooooooooool0oooooom9ooooo`000ooo
ool2o`0000Gooooo00Go0000ooooooooooooooooo`000004ooooo`;o00001oooool2o`0000Sooooo
00Co0000ooooool0003ooooo0_l00002ooooo`03o`000?oooooo000000;ooooo00Co0000ooooool0
003ooooo0_l00003ooooo`03o`000?oooooooooo0?ooooooBOooool000?ooooo0_l00004ooooo`;o
00000_ooool01?l0003oooooo`000?l00002ooooo`03o`000?oooooo000000Oooooo0ol00006oooo
o`;o000000Coooooo`000?oooooooooo0_l00003ooooo`?o00000_ooool2o`0000Cooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`3oooooodCooooo0003ooooo`03o`000?oooooo0000
00gooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo
00Kooooo00?o0000ooooooooool0oooooom9ooooo`000oooool01?l0003oooooooooool00003oooo
o`03o`000?oooooooooo00Gooooo0_l00004ooooo`03o`000?oooooooooo01Oooooo0_l00007oooo
o`;o0000oooooom;ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8
ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00=Oooool3o`0004gooooo0ol0
003oooooo`00=oooool2o`0004kooooo0_l0003nooooo`00=Oooool2o`0004kooooo0_l0003ooooo
o`7ooooo000fooooo`?o0000COooool3o`000?kooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo001Nooooo`03o`000?oooooooooo0?oooooo9oooool001Cooooo00?o0000oooooooo
ool0B?ooool00ol0003oooooooooo`1<ooooo`03o`000?oooooooooo0=Kooooo000Cooooo`03o`00
0?oooooooooo04Wooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`3Eooooo`004ooo
ool00ol0003oooooooooo`2Iooooo`03o`000?oooooooooo0=Gooooo000Booooo`03o`000?oooooo
oooo00;ooooo1?l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?ooooo
o`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?ooooo
o`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?ooooo
o`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?ooooo
o`000?l000000_l000000ooooooo0000o`000002o`0000_ooooo1?l000000ooooooo0000o`000002
o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002
o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002
o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002
o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002
o`0000Cooooo00?o0000ooooooooool0e?ooool001?ooooo00?o0000ooooooooool0VOooool00ol0
003oooooooooo`3Eooooo`004oooool00ol0003oooooooooo`2Iooooo`03o`000?oooooooooo0=Go
oooo000Dooooo`03o`000?oooooooooo09Oooooo00?o0000ooooooooool0e_ooool00?ooooooR?oo
ool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool005Wooooo0_l0
001>ooooo`;o0000g?ooool005_ooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`3I
ooooo`006?ooool2o`0000Cooooo00Go0000ooooooooooooooooo`000003ooooo`Co00000_ooool3
o`0000;ooooo00?o0000ooooooooool00_ooool2o`0000Sooooo0ol00002ooooo`;o00004_ooool3
o`0000cooooo0_l00004ooooo`04o`000?ooooooooooooooo`;o00000oooool2o`0000;ooooo1?l0
0002ooooo`03o`000?oooooooooo00;ooooo0_l00008ooooo`?o00000_ooool2o`0001;ooooo0ol0
003Kooooo`005oooool01?l0003oooooooooool00008ooooo`05o`000?ooooooooooooooool00000
1Oooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooooooo
ool01_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00kooooo00Co0000oooo
oooooooo00002oooool01?l0003oooooooooool00006ooooo`06o`000?ooooooooooo`000?oooooo
00000_ooool01?l0003oooooooooool00005ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000
ooooooooool01_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00kooooo00Co
0000oooooooooooo0000foooool001[ooooo00?o0000ooooooooool01Oooool3o`0000?ooooo00?o
0000ooooooooool00_ooool01?l0003oooooooooooooool3o`0000Cooooo00?o0000ooooooooool0
1_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00kooooo00Co0000oooooooo
oooo00003_ooool00ol0003oooooooooo`04ooooo`04o`000?ooooooooooo`0000Cooooo00Go0000
ooooooooooooooooo`000003ooooo`?o000000Goooooo`000?ooooooooooo`000008ooooo`04o`00
0?ooooooooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0003oooooooooool0003Koooo
o`006Oooool00ol0003oooooooooo`05ooooo`04o`000?ooooooooooo`0000Cooooo00Go0000oooo
ooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool01ooo
ool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00oooooo0ol0000=ooooo`03o`00
0?oooooooooo00Gooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`03ooooo`03
o`000?oooooo000000;ooooo00?o0000ooooooooool00_l00009ooooo`04o`000?ooooooooooo`00
00;ooooo00?o0000ooooooooool03oooool3o`000=_ooooo000Gooooo`04o`000?ooooooooooo`00
00Kooooo00Ko0000oooooooooooo0000ooooool00002ooooo`05o`000?ooooooooooooooool00000
0_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000ooooooooool01_ooool01?l0
003oooooooooool00002ooooo`03o`000?oooooooooo01gooooo00Co0000oooooooooooo00001_oo
ool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000ooooool000000_ooool00ol0003o
ooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool01_ooool01?l0003o
ooooooooool00002ooooo`03o`000?oooooooooo0>gooooo000Hooooo`;o00002?ooool2o`0000?o
oooo0_l00003ooooo`;o00000oooool2o`0000?ooooo0_l00008ooooo`;o00000oooool2o`00027o
oooo0_l00008ooooo`;o00000oooool2o`0000?ooooo0_l00003ooooo`;o00000oooool2o`0000So
oooo0_l00003ooooo`;o0000l?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
0?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
04oooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`3Uooooo`00Coooool00ol0003o
ooooooooo`1=ooooo`03o`000?oooooooooo0>Gooooo0019ooooo`Co00000oooool00ol0003ooooo
ooooo`16ooooo`Co00000oooool00ol0003oooooooooo`3Tooooo`00D?ooool00ol0003ooooooooo
o`1=ooooo`03o`000?oooooooooo0>Cooooo001>ooooo`04o`000?ooooooooooo`0004cooooo00Co
0000oooooooooooo0000iOooool004kooooo1?l0001<ooooo`Co0000iOooool00?ooooooR?ooool0
0?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00;Sooooo0_l00003
ooooo`03o`000?oooooooooo0<Oooooo001^ooooo`03o`000?oooooooooo04Wooooo00Go0000oooo
ooooooooooooo`00000=ooooo`03o`000?oooooooooo0;Sooooo000Booooo`04o`000?oooooooooo
o`0000;ooooo0ol000001?oooooo0000o`000?l00002ooooo`;o000000Ooooooo`000?l0003ooooo
o`000?oooooo000000;ooooo0_l00003ooooo`;o00000oooool4o`0000Gooooo0ol00003ooooo`?o
000000Coooooo`000?l0003o00000oooool3o`0000;ooooo0ol00003ooooo`;o000000Coooooo`00
0?l0003o00001?ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooooooo`Co00001_oo
ool4o`000004ooooool0003o0000o`0000?ooooo0ol00002ooooo`?o00001oooool7o`0000?ooooo
0ol00002ooooo`?o000000Goooooo`000?ooooooooooo`000002ooooo`?o000000Goooooo`000?oo
ooooooooo`000002ooooo`?o00000oooool00ol0003oooooooooo`04o`0000;ooooo0ol00003oooo
o`03o`000?oooooooooo0;Oooooo000Booooo`03o`000?oooooo000000Cooooo00Go0000oooooooo
ooooooooo`000004ooooo`03o`000?oooooo000000;ooooo00Go0000ooooool0003oooooo`000002
ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`05
ooooo`04o`000?ooooooooooooooo`;o00001Oooool2o`000005ooooool0003oooooooooool00000
0oooool01Ol0003ooooooooooooooooo000000Gooooo0_l0000<ooooo`03o`000?oooooooooo00;o
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`02ooooo`04o`000?oooooooooooooo
o`;o00000oooool2o`0000Sooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooo
oooo000000;ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000?o
oooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
0;Oooooo000Booooo`;o00001Oooool01Ol0003ooooooooooooooooo000000Cooooo0_l00002oooo
o`04o`000?oooooo0000ooooo`;o00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo
000000;ooooo00?o0000ooooooooool01Oooool01_l0003ooooooooooooooooo0000ooooo`;o0000
00?oooooo`000?l000000oooool01?l0003oooooooooool00003ooooo`05o`000?oooooooooooooo
ool000000oooool2o`0000gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo00;ooooo00Ko0000ooooooooooooooooo`000?ooool2o`000003ooooool0
003ooooo00;o000000?oooooo`000?l000000_l000001Ooooooo0000oooooooooooo000000;ooooo
00?o0000ooooooooool00_ooool00ol0003oooooo`000003ooooo`04o`000?ooooooooooo`0000;o
oooo00Go0000ooooooooooooooooo`000002ooooo`06o`000?ooooooooooo`000?oooooo00000_oo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`2fooooo`004_ooool2o`0000Cooooo0_l00002ooooo`04o`000?oooooo
0000o`0000;ooooo00[o0000ooooool0003oooooo`000?oooooo0000ooooool0003ooooo0_l00003
ooooo`;o00000oooool3o`0000Kooooo00Co0000ooooool0003o00000_ooool2o`0000?ooooo0ol0
00001Ooooooo0000oooooooooooo000000?ooooo00?o0000ooooooooool01?l00002ooooo`?o0000
0oooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooooooo`Co00001_ooool4o`000003
ooooool0003ooooo00;o00000_ooool2o`0000?ooooo0_l00008ooooo`?o000000?oooooo`000?oo
ool00_l000001?oooooo0000o`000?l00003ooooo`;o00000_ooool3o`0000?ooooo0_l00002oooo
o`?o00000oooool3o`0000Kooooo1?l00003ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool0]oooool001;ooooo00?o0000ooooool000003Oooool00ol0003oooooooooo`0Cooooo`03
o`000?oooooooooo01[ooooo00Go0000ooooooooooooooooo`00000Cooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo
02Sooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
0;Oooooo000Booooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool01Oooool2o`00
01Cooooo0_l0000Kooooo`;o00006?ooool00ol0003oooooooooo`02ooooo`;o00002?ooool2o`00
01Oooooo0_l0000=ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool04Oooool2o`00
00;ooooo0_l00003ooooo`03o`000?oooooooooo0;Sooooo003oooooohSooooo003oooooohSooooo
003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo0009ooooo`03o`00
0?oooooooooo0?ooooooO?ooool000[ooooo00?o0000ooooooooool0oooooomkooooo`000oooool0
1Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool01Oooool01_l0003oooooo`00
0?oooooo0000ooooo`;o00000oooool4o`000004ooooool0003o0000o`0000;ooooo0ol00003oooo
o`03o`000?oooooooooo0?ooooooF?ooool000?ooooo00Wo0000ooooooooooooooooo`000?oooooo
0000ooooool000001_ooool01?l0003oooooo`000?ooool2o`0000;ooooo00?o0000ooooool00000
0_ooool01?l0003oooooo`000?l00005ooooo`03o`000?oooooooooo0?ooooooGOooool000?ooooo
00Wo0000ooooooooooooooooo`000?oooooo0000ooooool000001_ooool01?l0003oooooo`000?oo
ool2o`0000;ooooo00?o0000ooooool000000_ooool01?l0003oooooo`000?ooool2o`0000?ooooo
00?o0000ooooooooool0oooooomMooooo`000oooool01?l0003oooooo`000?ooool3o`000003oooo
ool0003o000000Gooooo0_l000001?oooooo0000ooooooooool2o`0000?ooooo0ol00002ooooo`;o
00001?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0?ooooooF?ooool000?ooooo
0_l000000ooooooo0000o`00000Gooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0
oooooomMooooo`000oooool01Ol0003ooooooooooooooooo000001Kooooo0_l00007ooooo`;o0000
oooooomOooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00<?ooool2o`0000gooooo0_l0003oooooodOooooo000`ooooo`03o`000?oooooo
oooo00cooooo00?o0000ooooooooool0oooooom6ooooo`000oooool4o`0000;ooooo0_l00003oooo
o`?o00000oooool01?l0003oooooooooooooool3o`0000;ooooo00?o0000ooooooooool00_ooool2
o`0000Oooooo0ol00002ooooo`?o00001oooool3o`0000;ooooo0ol00003ooooo`?o00000_ooool3
o`0000;ooooo0ol000001?oooooo0000o`000?l0003ooooooc;ooooo0004ooooo`05o`000?oooooo
ooooooooool000000_ooool01Ol0003ooooooooooooooooo000000Wooooo00Go0000oooooooooooo
ooooo`000003ooooo`04o`000?ooooooooooo`0000Kooooo00Ko0000oooooooooooo0000ooooool0
0002ooooo`03o`000?oooooooooo00Kooooo0_l000001ooooooo0000oooooooooooo0000ooooool0
00000_ooool00ol0003oooooo`000004ooooo`;o00001?ooool00ol0003oooooooooo`3ooooooc7o
oooo0005ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000ooooooooooooooooo`000009oooo
o`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`04
ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003oooooooooo`04ooooo`;o0000
0oooool01?l0003oooooooooool00002ooooo`05o`000?oooooo0000ooooool000000_ooool01?l0
003oooooo`000?ooool2o`0000;ooooo00?o0000ooooooooool0oooooolaooooo`001_ooool00ol0
003oooooo`000002ooooo`05o`000?ooooooooooooooool000002Oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00?o00001oooool3o`0000;ooooo0ol00008ooooo`?o000000Cooooo
o`000?l0003o00000_ooool3o`0000?ooooo0ol00002ooooo`;o00000_ooool01?l0003oooooo`00
0?l0003ooooooc7ooooo0003ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool01Ol0003o
oooooooooooooooo000000Wooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool0
0008ooooo`03o`000?oooooooooo0?ooooooF_ooool000Cooooo0_l00003ooooo`;o00000oooool2
o`0000Sooooo0_l00002ooooo`Co00000oooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo0?ooooooF_ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?oo
ool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool003Gooooo0ol0
001=ooooo`?o0000ooooool003Oooooo0_l0001>ooooo`;o0000o_ooool003Gooooo0_l0001>oooo
o`;o0000ooooool1ooooo`00=_ooool3o`0004gooooo0ol0003nooooo`00oooooon8ooooo`00oooo
oon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooo
oon8ooooo`00G_ooool00ol0003oooooooooo`3oooooobOooooo000Dooooo`03o`000?oooooooooo
04Sooooo00?o0000ooooooooool0C?ooool00ol0003oooooooooo`3Fooooo`004oooool00ol0003o
ooooooooo`19ooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0eOooool001?ooooo
00?o0000ooooooooool0VOooool00ol0003oooooooooo`3Eooooo`004_ooool00ol0003ooooooooo
o`02ooooo`Co000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0
003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0
003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0
003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0
003o000000;o000000?oooooo`000?l000000_l0000;ooooo`Co000000?oooooo`000?l000000_l0
00000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l0
00000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l0
00000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l0
00000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l0
0004ooooo`03o`000?oooooooooo0=Cooooo000Cooooo`03o`000?oooooooooo09Wooooo00?o0000
ooooooooool0eOooool001?ooooo00?o0000ooooooooool0VOooool00ol0003oooooooooo`3Eoooo
o`005?ooool00ol0003oooooooooo`2Gooooo`03o`000?oooooooooo0=Kooooo003oooooohSooooo
003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo
001Iooooo`;o0000C_ooool2o`000=cooooo001Kooooo`03o`000?oooooooooo04gooooo00?o0000
ooooooooool0fOooool001Sooooo0_l00004ooooo`04o`000?ooooooooooooooo`;o00001Oooool0
1?l0003oooooooooool00004ooooo`;o00000oooool2o`0000Sooooo0ol00002ooooo`;o00004_oo
ool3o`0000cooooo0ol00003ooooo`04o`000?ooooooooooooooo`;o00000oooool2o`0000?ooooo
0_l00003ooooo`;o00000oooool2o`0000Sooooo0ol00002ooooo`;o00004_ooool3o`000=_ooooo
000Gooooo`04o`000?ooooooooooo`0000Kooooo00Co0000oooooooooooo00001?ooool01Ol0003o
oooooooooooooooo000000;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oo
oooooooo00Kooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`00
0?ooooooooooo`0000gooooo00?o0000ooooooooool01Oooool01_l0003oooooooooool0003ooooo
o`0000;ooooo00?o0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo
000000;ooooo00?o0000ooooooooool01_ooool01?l0003oooooooooool00002ooooo`03o`000?oo
oooooooo00kooooo00Co0000oooooooooooo0000foooool001[ooooo00?o0000ooooooooool01ooo
ool00ol0003oooooo`000003o`0000;ooooo0ol000001ooooooo0000oooooooooooo0000ooooool0
00000_ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooo
ooooool03_ooool01?l0003oooooooooool0000=ooooo`03o`000?oooooooooo00Gooooo00Ko0000
oooooooooooo0000ooooool00002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo
00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`000=_ooooo000Gooooo`?o
00002Oooool02Ol0003ooooooooooooooooo0000ooooool0003oooooo`000002ooooo`03o`000?oo
oooo000000;o00000oooool2o`0000Wooooo00Co0000oooooooooooo00000_ooool00ol0003ooooo
ooooo`0?ooooo`?o00003Oooool00ol0003oooooooooo`06ooooo`;o00000_ooool01_l0003ooooo
ooooool0003oooooo`0000;ooooo00?o0000ooooool000000_l00002ooooo`?o00002Oooool01?l0
003oooooooooool00002ooooo`03o`000?oooooooooo00oooooo0ol0003Kooooo`005oooool00ol0
003oooooooooo`07ooooo`04o`000?ooooooooooo`0000?ooooo0_l000001Ooooooo0000oooooooo
oooo000000;ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooooooo00Kooooo
00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00Go
oooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooo000000;ooooo00?o0000
ooooool000001?ooool00ol0003oooooooooo`09ooooo`04o`000?ooooooooooo`0000;ooooo00?o
0000ooooooooool0kOooool001Oooooo1?l00007ooooo`;o00001Oooool00ol0003oooooooooo`02
o`0000Cooooo00Co0000oooooooooooooooo0_l00008ooooo`;o00000oooool2o`00027ooooo0_l0
0008ooooo`;o00000oooool2o`0000?ooooo0_l00002ooooo`Co000000?oooooo`000?l000000_l0
0007ooooo`;o00000oooool2o`000?3ooooo003oooooohSooooo003oooooohSooooo003oooooohSo
oooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo001?ooooo`03
o`000?oooooooooo04gooooo00?o0000ooooooooool0iOooool004oooooo00?o0000ooooooooool0
COooool00ol0003oooooooooo`3Uooooo`00BOooool4o`0000?ooooo00?o0000ooooooooool0A_oo
ool4o`0000?ooooo00?o0000ooooooooool0i?ooool0053ooooo00?o0000ooooooooool0COooool0
0ol0003oooooooooo`3Tooooo`00C_ooool01?l0003oooooooooool0001<ooooo`04o`000?oooooo
ooooo`000>Gooooo001>ooooo`Co0000C?ooool4o`000>Gooooo003oooooohSooooo003oooooohSo
oooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo002hooooo`;o
00000oooool00ol0003oooooooooo`37ooooo`00K_ooool00ol0003oooooooooo`19ooooo`05o`00
0?ooooooooooooooool000003Oooool00ol0003oooooooooo`2hooooo`004_ooool01?l0003ooooo
ooooool00002ooooo`?o000000Coooooo`000?l0003o00000_ooool2o`000007ooooool0003o0000
ooooool0003oooooo`000002ooooo`;o00000oooool2o`0000?ooooo1?l00005ooooo`?o00000ooo
ool3o`000004ooooool0003o0000o`0000?ooooo0ol00002ooooo`?o00000oooool2o`000004oooo
ool0003o0000o`0000Cooooo00?o0000ooooooooool01_ooool01?l0003oooooooooooooool4o`00
00Kooooo1?l000001?oooooo0000o`000?l00003ooooo`?o00000_ooool3o`0000Oooooo1ol00003
ooooo`?o00000_ooool3o`000005ooooool0003oooooooooool000000_ooool3o`000005ooooool0
003oooooooooool000000_ooool3o`0000?ooooo00?o0000ooooooooool01?l00002ooooo`?o0000
0oooool00ol0003oooooooooo`2gooooo`004_ooool00ol0003oooooo`000004ooooo`05o`000?oo
ooooooooooooool000001?ooool00ol0003oooooo`000002ooooo`05o`000?oooooo0000ooooool0
00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000oooooooo
ool01Oooool01?l0003oooooooooooooool2o`0000Gooooo0_l000001Ooooooo0000oooooooooooo
000000?ooooo00Go0000ooooooooooooooooo`000005ooooo`;o00003?ooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00_ooool01?l0003ooooooooo
ooooool2o`0000?ooooo0_l00008ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000oooooooo
ooooooooo`000002ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool0
0003ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000_ooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`2gooooo`004_ooool2o`0000Gooooo00Go0000ooooooooooooooooo`000004ooooo`;o0000
0_ooool01?l0003oooooo`000?ooool2o`0000;ooooo00?o0000ooooool000000_ooool00ol0003o
ooooo`000002ooooo`03o`000?oooooooooo00Gooooo00Ko0000ooooooooooooooooo`000?ooool2
o`000003ooooool0003o000000?ooooo00Co0000oooooooooooo00000oooool01Ol0003ooooooooo
oooooooo000000?ooooo0_l0000=ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`02ooooo`06o`000?ooooooooooooooool0003ooooo0_l000000ooo
oooo0000ooooo`02o`000003ooooool0003o000000;o000000Goooooo`000?ooooooooooo`000002
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooool000000oooool01?l0003oooooooooool0
0002ooooo`05o`000?ooooooooooooooool000000_ooool01_l0003oooooooooool0003oooooo`00
00;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool0]_ooool001;ooooo0_l00004ooooo`;o00000_ooool01?l0003o
ooooo`000?l00002ooooo`0:o`000?oooooo0000ooooool0003oooooo`000?oooooo0000ooooo`;o
00000oooool2o`0000?ooooo0ol00006ooooo`04o`000?oooooo0000o`0000;ooooo0_l00003oooo
o`?o000000Goooooo`000?ooooooooooo`000003ooooo`03o`000?oooooooooo00Co00000_ooool3
o`0000?ooooo00?o0000ooooooooool01_ooool01?l0003oooooooooooooool4o`0000Kooooo1?l0
00000ooooooo0000ooooo`02o`0000;ooooo0_l00003ooooo`;o00002?ooool3o`000003ooooool0
003ooooo00;o000000Coooooo`000?l0003o00000oooool2o`0000;ooooo0ol00003ooooo`;o0000
0_ooool3o`0000?ooooo0ol00006ooooo`Co00000oooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo0;Oooooo000Booooo`03o`000?oooooo000000gooooo00?o0000ooooooooool04ooo
ool00ol0003oooooooooo`0Jooooo`05o`000?ooooooooooooooool000004oooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool06?ooool00ol0003ooooo
ooooo`0Xooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`2gooooo`004_ooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00Gooooo
0_l0000Dooooo`;o00006oooool2o`0001Sooooo00?o0000ooooooooool00_ooool2o`0000Sooooo
0_l0000Gooooo`;o00003Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo017ooooo
0_l00002ooooo`;o00000oooool00ol0003oooooooooo`2hooooo`00oooooon8ooooo`00oooooon8
ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8
ooooo`000oooool01?l0003oooooooooool00002ooooo`?o000000Coooooo`000?l0003o00000_oo
ool2o`000003ooooool0003o000000Gooooo0ol00007ooooo`06o`000?oooooo0000ooooool0003o
oooo0_l00003ooooo`Co000000Coooooo`000?l0003o00000_ooool3o`0000?ooooo00?o0000oooo
ooooool0oooooom4ooooo`000oooool00ol0003oooooo`000004ooooo`05o`000?oooooooooooooo
ool000001?ooool00ol0003oooooo`000008ooooo`;o00001_ooool01?l0003oooooo`000?ooool2
o`0000;ooooo00?o0000ooooool000000_ooool01?l0003oooooo`000?l00005ooooo`03o`000?oo
oooooooo0?ooooooBOooool000?ooooo0_l00005ooooo`05o`000?ooooooooooooooool000001?oo
ool2o`0000Oooooo0_l00008ooooo`04o`000?oooooo0000ooooo`;o00000_ooool00ol0003ooooo
o`000002ooooo`04o`000?oooooo0000ooooo`;o00000oooool00ol0003oooooooooo`3oooooodWo
oooo0003ooooo`;o00001?ooool2o`0000;ooooo00Co0000ooooool0003o00000_ooool00ol0003o
ooooo`000007ooooo`?o00001_ooool2o`000004ooooool0003oooooooooo`;o00000oooool3o`00
00;ooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0oooooom4oooo
o`000oooool00ol0003oooooo`00000=ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool06?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo0?ooooooBOooool000?ooooo
00Co0000oooooooooooo00000oooool00ol0003oooooooooo`05ooooo`;o00001?ooool00ol0003o
ooooooooo`0Gooooo`;o00001oooool2o`000?ooooooBoooool00?ooooooR?ooool00?ooooooR?oo
ool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?oo
ool00?ooooooR?ooool003Gooooo0ol0001=ooooo`?o0000ooooool003Oooooo0_l0001>ooooo`;o
0000o_ooool003Gooooo0_l0001>ooooo`;o0000ooooool1ooooo`00=_ooool3o`0004gooooo0ol0
003nooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooo
oon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00G_ooool00ol0003oooooooooo`3oooooobOo
oooo000Dooooo`03o`000?oooooooooo04Sooooo00?o0000ooooooooool0C?ooool00ol0003ooooo
ooooo`3Fooooo`004oooool00ol0003oooooooooo`19ooooo`03o`000?oooooooooo04gooooo00?o
0000ooooooooool0eOooool001?ooooo00?o0000ooooooooool0VOooool00ol0003oooooooooo`3E
ooooo`004_ooool00ol0003oooooooooo`02ooooo`Co000000?oooooo`000?l000000_l000000ooo
oooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooo
oooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooo
oooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooo
oooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l0000;oooo
o`Co000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o0000
00;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o0000
00;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o0000
00;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o0000
00;o000000?oooooo`000?l000000_l00004ooooo`03o`000?oooooooooo0=Cooooo000Cooooo`03
o`000?oooooooooo09Wooooo00?o0000ooooooooool0eOooool001?ooooo00?o0000ooooooooool0
VOooool00ol0003oooooooooo`3Eooooo`005?ooool00ol0003oooooooooo`2Gooooo`03o`000?oo
oooooooo0=Kooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo
003oooooohSooooo003oooooohSooooo001Iooooo`;o0000C_ooool2o`000=cooooo001Kooooo`03
o`000?oooooooooo04gooooo00?o0000ooooooooool0fOooool001Sooooo0_l00004ooooo`05o`00
0?ooooooooooooooool000001?ooool2o`0000?ooooo00?o0000ooooooooool00_ooool2o`0000Go
oooo00?o0000ooooooooool01Oooool3o`0000;ooooo0_l0000Booooo`?o00002oooool4o`0000?o
oooo00Co0000oooooooooooooooo0_l00003ooooo`;o00000_ooool4o`0000;ooooo0_l00003oooo
o`03o`000?oooooooooo00Oooooo0ol00002ooooo`;o00004_ooool3o`000=_ooooo000Gooooo`04
o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`000002ooooo`05o`000?oooooo
ooooooooool000000_ooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo00Kooooo
00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`00
00cooooo00?o0000ooooooooool01_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00Co
0000oooooooooooo00000oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00So
oooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?oooooooooo
o`000=_ooooo000Jooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo00000_ooool0
0ol0003oooooooooo`03o`000006ooooool0003oooooooooool0003ooooo1?l00008ooooo`04o`00
0?ooooooooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0003oooooooooool0000=oooo
o`03o`000?oooooooooo00Gooooo00Ko0000oooooooooooo0000ooooool00002ooooo`05o`000?oo
ooooooooooooool000000_ooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00Oo
oooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?oooooooooo
o`000=_ooooo000Iooooo`03o`000?oooooooooo00Oooooo00Co0000oooooooooooo00000_ooool0
0ol0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00Ko0000oooooooooooo0000oooo
ool00008ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool03oooool3o`0000ko
oooo00?o0000ooooooooool01Oooool2o`0000;ooooo00Co0000oooooooooooo00001?ooool00ol0
003oooooooooo`02o`0000Cooooo00?o0000ooooooooool01oooool01?l0003oooooooooool00002
ooooo`03o`000?oooooooooo00oooooo0ol0003Kooooo`005oooool01?l0003oooooooooool00006
ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003oooooo`000002ooooo`03o`00
0?oooooo000000;ooooo00Co0000oooooooooooooooo0_l00008ooooo`04o`000?ooooooooooo`00
00;ooooo00?o0000ooooooooool07Oooool01?l0003oooooooooool00006ooooo`06o`000?oooooo
ooooo`000?oooooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo
00?o0000ooooool000000_ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`0000;o
oooo00?o0000ooooooooool0kOooool001Sooooo0_l00007ooooo`Co00000_ooool2o`0000?ooooo
0_l00003ooooo`;o00001Oooool00ol0003oooooooooo`05ooooo`;o00000oooool2o`00027ooooo
0_l00008ooooo`;o00000oooool2o`0000?ooooo0_l00003ooooo`;o00000_ooool4o`0000Oooooo
0_l00003ooooo`;o0000l?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?oo
ooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool004oooooo00?o0000oooo
ooooool0COooool00ol0003oooooooooo`3Uooooo`00Coooool00ol0003oooooooooo`1=ooooo`03
o`000?oooooooooo0>Gooooo0019ooooo`Co00000oooool00ol0003oooooooooo`16ooooo`Co0000
0oooool00ol0003oooooooooo`3Tooooo`00D?ooool00ol0003oooooooooo`1=ooooo`03o`000?oo
oooooooo0>Cooooo001>ooooo`04o`000?ooooooooooo`0004cooooo00Co0000oooooooooooo0000
iOooool004kooooo1?l0001<ooooo`Co0000iOooool00?ooooooR?ooool00?ooooooR?ooool00?oo
ooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00;Sooooo0_l00003oooo
o`03o`000?oooooooooo0<Oooooo001^ooooo`03o`000?oooooooooo04Wooooo00Go0000oooooooo
ooooooooo`00000=ooooo`03o`000?oooooooooo0;Sooooo000Booooo`04o`000?ooooooooooo`00
00;ooooo0ol000001?oooooo0000o`000?l00002ooooo`;o000000Ooooooo`000?l0003oooooo`00
0?oooooo000000;ooooo0_l00003ooooo`;o00000oooool4o`0000Gooooo0ol00003ooooo`?o0000
00Coooooo`000?l0003o00000oooool3o`0000;ooooo0ol00003ooooo`;o000000Coooooo`000?l0
003o00001?ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooooooo`Co00001_ooool4
o`000004ooooool0003o0000o`0000?ooooo0ol00002ooooo`?o00001oooool7o`0000?ooooo0ol0
0002ooooo`?o000000Goooooo`000?ooooooooooo`000002ooooo`?o000000Goooooo`000?oooooo
ooooo`000002ooooo`?o00000oooool00ol0003oooooooooo`04o`0000;ooooo0ol00003ooooo`03
o`000?oooooooooo0;Oooooo000Booooo`03o`000?oooooo000000Cooooo00Go0000oooooooooooo
ooooo`000004ooooo`03o`000?oooooo000000;ooooo00Go0000ooooool0003oooooo`000002oooo
o`03o`000?oooooo000000;ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`05oooo
o`04o`000?ooooooooooooooo`;o00001Oooool2o`000005ooooool0003oooooooooool000000ooo
ool01Ol0003ooooooooooooooooo000000Gooooo0_l0000<ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool01oooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooooooo`;o
00000oooool2o`0000Sooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo
000000;ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000?ooooo
00Co0000oooooooooooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0;Oo
oooo000Booooo`;o00001Oooool01Ol0003ooooooooooooooooo000000Cooooo0_l00002ooooo`04
o`000?oooooo0000ooooo`;o00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo0000
00;ooooo00?o0000ooooooooool01Oooool01_l0003ooooooooooooooooo0000ooooo`;o000000?o
ooooo`000?l000000oooool01?l0003oooooooooool00003ooooo`05o`000?ooooooooooooooool0
00000oooool2o`0000gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00;ooooo00Ko0000ooooooooooooooooo`000?ooool2o`000003ooooool0003o
oooo00;o000000?oooooo`000?l000000_l000001Ooooooo0000oooooooooooo000000;ooooo00?o
0000ooooooooool00_ooool00ol0003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo
00Go0000ooooooooooooooooo`000002ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`2fooooo`004_ooool2o`0000Cooooo0_l00002ooooo`04o`000?oooooo0000
o`0000;ooooo00[o0000ooooool0003oooooo`000?oooooo0000ooooool0003ooooo0_l00003oooo
o`;o00000oooool3o`0000Kooooo00Co0000ooooool0003o00000_ooool2o`0000?ooooo0ol00000
1Ooooooo0000oooooooooooo000000?ooooo00?o0000ooooooooool01?l00002ooooo`?o00000ooo
ool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooooooo`Co00001_ooool4o`000003oooo
ool0003ooooo00;o00000_ooool2o`0000?ooooo0_l00008ooooo`?o000000?oooooo`000?ooool0
0_l000001?oooooo0000o`000?l00003ooooo`;o00000_ooool3o`0000?ooooo0_l00002ooooo`?o
00000oooool3o`0000Kooooo1?l00003ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool0]oooool001;ooooo00?o0000ooooool000003Oooool00ol0003oooooooooo`0Cooooo`03o`00
0?oooooooooo01[ooooo00Go0000ooooooooooooooooo`00000Cooooo`03o`000?oooooooooo00;o
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo02So
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0;Oo
oooo000Booooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool01Oooool2o`0001Co
oooo0_l0000Kooooo`;o00006?ooool00ol0003oooooooooo`02ooooo`;o00002?ooool2o`0001Oo
oooo0_l0000=ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool04Oooool2o`0000;o
oooo0_l00003ooooo`03o`000?oooooooooo0;Sooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo0009ooooo`03o`000?oooooooooo0?oooooo
O?ooool000[ooooo00?o0000ooooooooool0oooooomkooooo`000oooool01Ol0003ooooooooooooo
oooo000000;ooooo00?o0000ooooooooool01Oooool01_l0003oooooo`000?oooooo0000ooooo`;o
00000oooool4o`000004ooooool0003o0000o`0000;ooooo0ol00003ooooo`03o`000?oooooooooo
0?ooooooF?ooool000?ooooo00Wo0000ooooooooooooooooo`000?oooooo0000ooooool000001_oo
ool01?l0003oooooo`000?ooool2o`0000;ooooo00?o0000ooooool000000_ooool01?l0003ooooo
o`000?l00005ooooo`03o`000?oooooooooo0?ooooooGOooool000?ooooo00Wo0000oooooooooooo
ooooo`000?oooooo0000ooooool000001_ooool01?l0003oooooo`000?ooool2o`0000;ooooo00?o
0000ooooool000000_ooool01?l0003oooooo`000?ooool2o`0000?ooooo00?o0000ooooooooool0
oooooomMooooo`000oooool01?l0003oooooo`000?ooool3o`000003ooooool0003o000000Gooooo
0_l000001?oooooo0000ooooooooool2o`0000?ooooo0ol00002ooooo`;o00001?ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo0?ooooooF?ooool000?ooooo0_l000000ooooooo0000
o`00000Gooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0oooooomMooooo`000ooo
ool01Ol0003ooooooooooooooooo000001Kooooo0_l00007ooooo`;o0000oooooomOooooo`00oooo
oon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooo
oon8ooooo`00<?ooool2o`0000gooooo0_l0003oooooodOooooo000`ooooo`03o`000?oooooooooo
00cooooo00?o0000ooooooooool0oooooom6ooooo`001?ooool3o`0000;ooooo0_l00003ooooo`03
o`000?oooooooooo00?ooooo00Co0000oooooooooooooooo0_l00005ooooo`04o`000?oooooooooo
o`0000Sooooo0ol00002ooooo`?o00001oooool3o`0000;ooooo0ol00003ooooo`?o00000_ooool3
o`0000;ooooo0ol000001?oooooo0000o`000?l0003ooooooc;ooooo0005ooooo`04o`000?oooooo
ooooo`0000;ooooo00Co0000oooooooooooo00002?ooool01?l0003oooooooooool00004ooooo`04
o`000?ooooooooooo`0000Sooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oo
oooooooo00Kooooo0_l000001ooooooo0000oooooooooooo0000ooooool000000_ooool00ol0003o
ooooo`000004ooooo`;o00001?ooool00ol0003oooooooooo`3ooooooc7ooooo0005ooooo`04o`00
0?ooooooooooo`0000;ooooo00Go0000ooooooooooooooooo`000007ooooo`05o`000?oooooooooo
o`000?ooool01?l00003ooooo`03o`000?oooooooooo00Gooooo00Ko0000oooooooooooo0000oooo
ool00002ooooo`03o`000?oooooooooo00Cooooo0_l00003ooooo`04o`000?ooooooooooo`0000;o
oooo00Go0000ooooool0003oooooo`000002ooooo`04o`000?oooooo0000ooooo`;o00000_ooool0
0ol0003oooooooooo`3ooooooc7ooooo0005ooooo`03o`000?oooooooooo00?o00001?ooool00ol0
003oooooooooo`05ooooo`?o00000oooool00ol0003oooooo`000003ooooo`03o`000?oooooooooo
00Gooooo0ol00002ooooo`?o00002?ooool3o`000004ooooool0003o0000o`0000;ooooo0ol00003
ooooo`?o00000_ooool2o`0000;ooooo00Co0000ooooool0003o0000oooooolaooooo`001Oooool0
1Ol0003ooooooooooooooooo000000?ooooo00Co0000oooooooooooo00001oooool00ol0003ooooo
ooooo`03ooooo`;o000000Goooooo`000?ooooooooooo`000006ooooo`03o`000?oooooooooo0?oo
ooooF_ooool000Cooooo0_l00004ooooo`03o`000?oooooooooo00Co00002?ooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooo000000?o00001_ooool00ol0003oooooooooo`3ooooooe[ooooo
003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo
003oooooohSooooo003oooooohSooooo000eooooo`?o0000COooool3o`000?oooooo000gooooo`;o
0000C_ooool2o`000?kooooo000eooooo`;o0000C_ooool2o`000?oooooo0Oooool003Kooooo0ol0
001=ooooo`?o0000o_ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?oooooo
R?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool005kooooo
00?o0000ooooooooool0oooooolWooooo`005?ooool00ol0003oooooooooo`18ooooo`03o`000?oo
oooooooo04cooooo00?o0000ooooooooool0e_ooool001?ooooo00?o0000ooooooooool0BOooool0
0ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0=Gooooo000Cooooo`03o`000?oooooooooo
09Wooooo00?o0000ooooooooool0eOooool001;ooooo00?o0000ooooooooool00_ooool4o`000003
ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003
ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003
ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003
ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003
ooooool0003o000000;o00002oooool4o`000003ooooool0003o000000;o000000?oooooo`000?l0
00000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l0
00000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l0
00000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l0
00000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o00001?ooool00ol0003o
ooooooooo`3Dooooo`004oooool00ol0003oooooooooo`2Iooooo`03o`000?oooooooooo0=Gooooo
000Cooooo`03o`000?oooooooooo09Wooooo00?o0000ooooooooool0eOooool001Cooooo00?o0000
ooooooooool0Uoooool00ol0003oooooooooo`3Fooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00FOooool2o`0004kooooo0_l0003Loooo
o`00Foooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0=Wooooo000Jooooo`05o`00
0?ooooooooooooooool000000oooool00ol0003oooooooooo`02ooooo`?o00000_ooool2o`0000?o
oooo0_l00003ooooo`03o`000?oooooooooo00Oooooo0ol00002ooooo`;o00004_ooool3o`0000co
oooo0ol00003ooooo`04o`000?ooooooooooooooo`;o00000oooool01?l0003oooooooooooooool4
o`0000;ooooo0ol000000ooooooo0000o`000002o`0000Oooooo0ol00002ooooo`;o00004_ooool3
o`000=_ooooo000Jooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00oooool01?l0
003oooooooooool00002ooooo`03o`000?oooooo000000;ooooo00Go0000ooooooooooooooooo`00
0009ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0003ooooo
ooooool0000=ooooo`03o`000?oooooooooo00Gooooo00Co0000oooooooooooo00000oooool01Ol0
003ooooooooooooooooo000000Gooooo00Go0000ooooooooooooooooo`00000:ooooo`04o`000?oo
ooooooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0003oooooooooool0003Kooooo`00
5oooool4o`0000Sooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00002ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool00ol00008ooooo`04o`000?ooooooooooo`00
00;ooooo00?o0000ooooooooool03_ooool01?l0003oooooooooool0000=ooooo`03o`000?oooooo
oooo00Gooooo00Co0000oooooooooooo00000_ooool3o`0000?ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Oooooo00Co0000oooooooooooo0000
0_ooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`000=_ooooo000Hooooo`03o`00
0?oooooo000000Sooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03o`0000Cooooo
00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`00
00;ooooo00?o0000ooooooooool03oooool3o`0000gooooo00?o0000ooooooooool01Oooool3o`00
00;ooooo00Co0000oooooooooooo00001?ooool01Ol0003ooooooooooooooooo000000Gooooo00?o
0000ooooooooool01_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00oooooo
0ol0003Kooooo`006Oooool2o`0000Kooooo00Co0000oooooooooooo00000oooool01Ol0003ooooo
oooooooooooo000000?ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooo
oooo00Kooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0Oooooo`03o`000?oo
oooooooo00Kooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo000000;ooooo
00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000Sooooo00Co0000oooo
oooooooo00000_ooool00ol0003oooooooooo`3]ooooo`006_ooool00ol0003oooooooooo`04oooo
o`Co00000_ooool2o`0000Cooooo00Co0000oooooooooooooooo0_l00003ooooo`;o00002?ooool2
o`0000?ooooo0_l0000Qooooo`;o00002Oooool01?l0003oooooooooooooool2o`0000?ooooo0_l0
0003ooooo`;o00000oooool2o`0000Sooooo0_l00003ooooo`;o0000l?ooool00?ooooooR?ooool0
0?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
0?ooooooR?ooool00?ooooooR?ooool004oooooo00?o0000ooooooooool0COooool00ol0003ooooo
ooooo`3Uooooo`00Coooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0>Gooooo0019
ooooo`Co00000oooool00ol0003oooooooooo`16ooooo`Co00000oooool00ol0003oooooooooo`3T
ooooo`00D?ooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0>Cooooo001>ooooo`04
o`000?ooooooooooo`0004cooooo00Co0000oooooooooooo0000iOooool004kooooo1?l0001<oooo
o`Co0000iOooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
0?ooooooR?ooool00;Sooooo0_l00003ooooo`03o`000?oooooooooo0<Oooooo001^ooooo`03o`00
0?oooooooooo04Wooooo00Go0000ooooooooooooooooo`00000=ooooo`03o`000?oooooooooo0;So
oooo000Booooo`04o`000?ooooooooooo`0000;ooooo0ol000001?oooooo0000o`000?l00002oooo
o`;o000000Ooooooo`000?l0003oooooo`000?oooooo000000;ooooo0_l00003ooooo`;o00000ooo
ool4o`0000Gooooo0ol00003ooooo`?o000000Coooooo`000?l0003o00000oooool3o`0000;ooooo
0ol00003ooooo`;o000000Coooooo`000?l0003o00001?ooool00ol0003oooooooooo`06ooooo`04
o`000?ooooooooooooooo`Co00001_ooool4o`000004ooooool0003o0000o`0000?ooooo0ol00002
ooooo`?o00001oooool7o`0000?ooooo0ol00002ooooo`?o000000Goooooo`000?ooooooooooo`00
0002ooooo`?o000000Goooooo`000?ooooooooooo`000002ooooo`?o00000oooool00ol0003ooooo
ooooo`04o`0000;ooooo0ol00003ooooo`03o`000?oooooooooo0;Oooooo000Booooo`03o`000?oo
oooo000000Cooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooo000000;ooooo
00Go0000ooooool0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool0
00000_ooool00ol0003oooooooooo`05ooooo`04o`000?ooooooooooooooo`;o00001Oooool2o`00
0005ooooool0003oooooooooool000000oooool01Ol0003ooooooooooooooooo000000Gooooo0_l0
000<ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`02ooooo`04o`000?ooooooooooooooo`;o00000oooool2o`0000Sooooo00Co0000oooooooooooo
00000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000ooooooooooooooooo`000002
ooooo`04o`000?ooooooooooo`0000?ooooo00Co0000oooooooooooo00000_ooool00ol0003ooooo
o`000002ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo0;Oooooo000Booooo`;o00001Oooool01Ol0003ooooooooo
oooooooo000000Cooooo0_l00002ooooo`04o`000?oooooo0000ooooo`;o00000_ooool00ol0003o
ooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool01Oooool01_l0003o
oooooooooooooooo0000ooooo`;o000000?oooooo`000?l000000oooool01?l0003oooooooooool0
0003ooooo`05o`000?ooooooooooooooool000000oooool2o`0000gooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00;ooooo00Ko0000oooooooooooo
ooooo`000?ooool2o`000003ooooool0003ooooo00;o000000?oooooo`000?l000000_l000001Ooo
oooo0000oooooooooooo000000;ooooo00?o0000ooooooooool00_ooool00ol0003oooooo`000003
ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000ooooooooooooooooo`000002ooooo`06o`00
0?ooooooooooo`000?oooooo00000_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2fooooo`004_ooool2o`0000Co
oooo0_l00002ooooo`04o`000?oooooo0000o`0000;ooooo00[o0000ooooool0003oooooo`000?oo
oooo0000ooooool0003ooooo0_l00003ooooo`;o00000oooool3o`0000Kooooo00Co0000ooooool0
003o00000_ooool2o`0000?ooooo0ol000001Ooooooo0000oooooooooooo000000?ooooo00?o0000
ooooooooool01?l00002ooooo`?o00000oooool00ol0003oooooooooo`06ooooo`04o`000?oooooo
ooooooooo`Co00001_ooool4o`000003ooooool0003ooooo00;o00000_ooool2o`0000?ooooo0_l0
0008ooooo`?o000000?oooooo`000?ooool00_l000001?oooooo0000o`000?l00003ooooo`;o0000
0_ooool3o`0000?ooooo0_l00002ooooo`?o00000oooool3o`0000Kooooo1?l00003ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool0]oooool001;ooooo00?o0000ooooool000003Ooo
ool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo01[ooooo00Go0000oooooooooooooooo
o`00000Cooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01oooool00ol0003ooooo
ooooo`0Hooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo0;Oooooo000Booooo`04o`000?ooooooooooo`0000?ooooo
00?o0000ooooooooool01Oooool2o`0001Cooooo0_l0000Kooooo`;o00006?ooool00ol0003ooooo
ooooo`02ooooo`;o00002?ooool2o`0001Oooooo0_l0000=ooooo`03o`000?oooooooooo00Oooooo
00?o0000ooooooooool04Oooool2o`0000;ooooo0_l00003ooooo`03o`000?oooooooooo0;Sooooo
003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo
003oooooohSooooo003oooooohSooooo003oooooohSooooo0003ooooo`04o`000?ooooooooooo`00
00;ooooo0ol000001?oooooo0000o`000?l00002ooooo`;o000000?oooooo`000?l000001Oooool3
o`0000Oooooo00Ko0000ooooool0003oooooo`000?ooool2o`0000?ooooo1?l000001?oooooo0000
o`000?l00002ooooo`?o00000oooool00ol0003oooooooooo`3oooooodCooooo0003ooooo`03o`00
0?oooooo000000Cooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooo000000So
oooo0_l00006ooooo`04o`000?oooooo0000ooooo`;o00000_ooool00ol0003oooooo`000002oooo
o`04o`000?oooooo0000o`0000Gooooo00?o0000ooooooooool0oooooom9ooooo`000oooool2o`00
00Gooooo00Go0000ooooooooooooooooo`000004ooooo`;o00001oooool2o`0000Sooooo00Co0000
ooooool0003ooooo0_l00002ooooo`03o`000?oooooo000000;ooooo00Co0000ooooool0003ooooo
0_l00003ooooo`03o`000?oooooooooo0?ooooooBOooool000?ooooo0_l00004ooooo`;o00000_oo
ool01?l0003oooooo`000?l00002ooooo`03o`000?oooooo000000Oooooo0ol00006ooooo`;o0000
00Coooooo`000?oooooooooo0_l00003ooooo`?o00000_ooool2o`0000Cooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`3oooooodCooooo0003ooooo`03o`000?oooooo000000gooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00Kooooo
00?o0000ooooooooool0oooooom9ooooo`000oooool01?l0003oooooooooool00003ooooo`03o`00
0?oooooooooo00Gooooo0_l00004ooooo`03o`000?oooooooooo01Oooooo0_l00007ooooo`;o0000
oooooom;ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00=Oooool3o`0004gooooo0ol0003ooooo
o`00=oooool2o`0004kooooo0_l0003nooooo`00=Oooool2o`0004kooooo0_l0003oooooo`7ooooo
000fooooo`?o0000COooool3o`000?kooooo003oooooohSooooo003oooooohSooooo003oooooohSo
oooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSo
oooo001Nooooo`03o`000?oooooooooo0?oooooo9oooool001Cooooo00?o0000ooooooooool0B?oo
ool00ol0003oooooooooo`1<ooooo`03o`000?oooooooooo0=Kooooo000Cooooo`03o`000?oooooo
oooo04Wooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`3Eooooo`004oooool00ol0
003oooooooooo`2Iooooo`03o`000?oooooooooo0=Gooooo000Booooo`03o`000?oooooooooo00;o
oooo1?l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l0
00000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l0
00000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l0
00000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l0
00000_l000000ooooooo0000o`000002o`0000_ooooo1?l000000ooooooo0000o`000002o`000003
ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003
ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003
ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003
ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`0000Co
oooo00?o0000ooooooooool0e?ooool001?ooooo00?o0000ooooooooool0VOooool00ol0003ooooo
ooooo`3Eooooo`004oooool00ol0003oooooooooo`2Iooooo`03o`000?oooooooooo0=Gooooo000D
ooooo`03o`000?oooooooooo09Oooooo00?o0000ooooooooool0e_ooool00?ooooooR?ooool00?oo
ooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool005Wooooo0_l0001>oooo
o`;o0000g?ooool005_ooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`3Iooooo`00
6?ooool2o`0000Cooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02o`0000?ooooo
0_l00003ooooo`;o00000oooool2o`0000Sooooo0ol00002ooooo`;o00004_ooool3o`0000_ooooo
1?l00003ooooo`04o`000?ooooooooooooooo`;o00000oooool2o`0000?ooooo0ol00002ooooo`;o
00000oooool2o`0000Sooooo0ol00002ooooo`;o00004_ooool3o`000=_ooooo000Gooooo`04o`00
0?ooooooooooo`0000Wooooo00?o0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03
o`000?oooooo000000;ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`06ooooo`04
o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0003oooooooooool0000<
ooooo`03o`000?oooooooooo00Kooooo00Ko0000oooooooooooo0000ooooool00002ooooo`05o`00
0?ooooooooooooooool000000_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000
ooooooooool01_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00kooooo00Co
0000oooooooooooo0000foooool001[ooooo00?o0000ooooooooool01?ooool4o`000007ooooool0
003oooooooooool0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool0
00000_ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooo
ooooool03_ooool01?l0003oooooooooool0000=ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooool000000_ooool01Ol0003ooooooooooooooooo000000Gooooo00?o0000ooooool000000_oo
ool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0
3_ooool01?l0003oooooooooool0003Kooooo`006Oooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooo000000;ooooo0_l00003ooooo`;o00000_ooool3o`0000?ooooo0_l00009ooooo`04o`00
0?ooooooooooo`0000;ooooo00?o0000ooooooooool03oooool3o`0000kooooo00?o0000oooooooo
ool01?ooool3o`0000;ooooo0ol00004ooooo`03o`000?oooooooooo00?o00000_ooool3o`0000Wo
oooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0?ooooo`?o0000foooool001Oo
oooo00Co0000oooooooooooo00002?ooool2o`000007ooooool0003oooooooooool0003oooooo`00
0002ooooo`04o`000?ooooooooooo`0000?ooooo00Co0000oooooooooooo00002?ooool01?l0003o
ooooooooool00002ooooo`03o`000?oooooooooo01gooooo00Co0000oooooooooooo00001_ooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00001Ooo
ool00ol0003oooooooooo`08ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0
kOooool001Sooooo0_l0000:ooooo`03o`000?oooooooooo00;o00000oooool2o`0000Cooooo00Co
0000oooooooooooooooo0_l00008ooooo`;o00000oooool2o`00027ooooo0_l00007ooooo`Co0000
0oooool01?l0003oooooooooooooool2o`0000;ooooo1?l00003ooooo`03o`000?oooooooooo00Ko
oooo0_l00003ooooo`;o0000l?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
0?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
04oooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`3Uooooo`00Coooool00ol0003o
ooooooooo`1=ooooo`03o`000?oooooooooo0>Gooooo0019ooooo`Co00000oooool00ol0003ooooo
ooooo`16ooooo`Co00000oooool00ol0003oooooooooo`3Tooooo`00D?ooool00ol0003ooooooooo
o`1=ooooo`03o`000?oooooooooo0>Cooooo001>ooooo`04o`000?ooooooooooo`0004cooooo00Co
0000oooooooooooo0000iOooool004kooooo1?l0001<ooooo`Co0000iOooool00?ooooooR?ooool0
0?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00;Sooooo0_l00003
ooooo`03o`000?oooooooooo0<Oooooo001^ooooo`03o`000?oooooooooo04Wooooo00Go0000oooo
ooooooooooooo`00000=ooooo`03o`000?oooooooooo0;Sooooo000Booooo`04o`000?oooooooooo
o`0000;ooooo0ol000001?oooooo0000o`000?l00002ooooo`;o000000Ooooooo`000?l0003ooooo
o`000?oooooo000000;ooooo0_l00003ooooo`;o00000oooool4o`0000Gooooo0ol00003ooooo`?o
000000Coooooo`000?l0003o00000oooool3o`0000;ooooo0ol00003ooooo`;o000000Coooooo`00
0?l0003o00001?ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooooooo`Co00001_oo
ool4o`000004ooooool0003o0000o`0000?ooooo0ol00002ooooo`?o00001oooool7o`0000?ooooo
0ol00002ooooo`?o000000Goooooo`000?ooooooooooo`000002ooooo`?o000000Goooooo`000?oo
ooooooooo`000002ooooo`?o00000oooool00ol0003oooooooooo`04o`0000;ooooo0ol00003oooo
o`03o`000?oooooooooo0;Oooooo000Booooo`03o`000?oooooo000000Cooooo00Go0000oooooooo
ooooooooo`000004ooooo`03o`000?oooooo000000;ooooo00Go0000ooooool0003oooooo`000002
ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`05
ooooo`04o`000?ooooooooooooooo`;o00001Oooool2o`000005ooooool0003oooooooooool00000
0oooool01Ol0003ooooooooooooooooo000000Gooooo0_l0000<ooooo`03o`000?oooooooooo00;o
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`02ooooo`04o`000?oooooooooooooo
o`;o00000oooool2o`0000Sooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooo
oooo000000;ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000?o
oooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
0;Oooooo000Booooo`;o00001Oooool01Ol0003ooooooooooooooooo000000Cooooo0_l00002oooo
o`04o`000?oooooo0000ooooo`;o00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo
000000;ooooo00?o0000ooooooooool01Oooool01_l0003ooooooooooooooooo0000ooooo`;o0000
00?oooooo`000?l000000oooool01?l0003oooooooooool00003ooooo`05o`000?oooooooooooooo
ool000000oooool2o`0000gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo00;ooooo00Ko0000ooooooooooooooooo`000?ooool2o`000003ooooool0
003ooooo00;o000000?oooooo`000?l000000_l000001Ooooooo0000oooooooooooo000000;ooooo
00?o0000ooooooooool00_ooool00ol0003oooooo`000003ooooo`04o`000?ooooooooooo`0000;o
oooo00Go0000ooooooooooooooooo`000002ooooo`06o`000?ooooooooooo`000?oooooo00000_oo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`2fooooo`004_ooool2o`0000Cooooo0_l00002ooooo`04o`000?oooooo
0000o`0000;ooooo00[o0000ooooool0003oooooo`000?oooooo0000ooooool0003ooooo0_l00003
ooooo`;o00000oooool3o`0000Kooooo00Co0000ooooool0003o00000_ooool2o`0000?ooooo0ol0
00001Ooooooo0000oooooooooooo000000?ooooo00?o0000ooooooooool01?l00002ooooo`?o0000
0oooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooooooo`Co00001_ooool4o`000003
ooooool0003ooooo00;o00000_ooool2o`0000?ooooo0_l00008ooooo`?o000000?oooooo`000?oo
ool00_l000001?oooooo0000o`000?l00003ooooo`;o00000_ooool3o`0000?ooooo0_l00002oooo
o`?o00000oooool3o`0000Kooooo1?l00003ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool0]oooool001;ooooo00?o0000ooooool000003Oooool00ol0003oooooooooo`0Cooooo`03
o`000?oooooooooo01[ooooo00Go0000ooooooooooooooooo`00000Cooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo
02Sooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
0;Oooooo000Booooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool01Oooool2o`00
01Cooooo0_l0000Kooooo`;o00006?ooool00ol0003oooooooooo`02ooooo`;o00002?ooool2o`00
01Oooooo0_l0000=ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool04Oooool2o`00
00;ooooo0_l00003ooooo`03o`000?oooooooooo0;Sooooo003oooooohSooooo003oooooohSooooo
003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo0009ooooo`03o`00
0?oooooooooo0?ooooooO?ooool000[ooooo00?o0000ooooooooool0oooooomkooooo`000oooool0
1Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool01Oooool01_l0003oooooo`00
0?oooooo0000ooooo`;o00000oooool4o`000004ooooool0003o0000o`0000;ooooo0ol00003oooo
o`03o`000?oooooooooo0?ooooooF?ooool000?ooooo00Wo0000ooooooooooooooooo`000?oooooo
0000ooooool000001_ooool01?l0003oooooo`000?ooool2o`0000;ooooo00?o0000ooooool00000
0_ooool01?l0003oooooo`000?l00005ooooo`03o`000?oooooooooo0?ooooooGOooool000?ooooo
00Wo0000ooooooooooooooooo`000?oooooo0000ooooool000001_ooool01?l0003oooooo`000?oo
ool2o`0000;ooooo00?o0000ooooool000000_ooool01?l0003oooooo`000?ooool2o`0000?ooooo
00?o0000ooooooooool0oooooomMooooo`000oooool01?l0003oooooo`000?ooool3o`000003oooo
ool0003o000000Gooooo0_l000001?oooooo0000ooooooooool2o`0000?ooooo0ol00002ooooo`;o
00001?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0?ooooooF?ooool000?ooooo
0_l000000ooooooo0000o`00000Gooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0
oooooomMooooo`000oooool01Ol0003ooooooooooooooooo000001Kooooo0_l00007ooooo`;o0000
oooooomOooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00<?ooool2o`0000gooooo0_l0003oooooodOooooo000`ooooo`03o`000?oooooo
oooo00cooooo00?o0000ooooooooool0oooooom6ooooo`001?ooool3o`0000;ooooo0_l00005oooo
o`05o`000?ooooooooooooooool000000oooool3o`0000;ooooo0ol00002ooooo`;o00001oooool3
o`0000;ooooo0ol00007ooooo`?o00000_ooool3o`0000?ooooo0ol00002ooooo`?o00000_ooool3
o`000004ooooool0003o0000o`000?oooooo<_ooool000Gooooo00Co0000oooooooooooo00000_oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool00_oo
ool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00Cooooo00Ko0000oooooooooooo
0000ooooool00002ooooo`03o`000?oooooooooo00Kooooo0_l000001ooooooo0000oooooooooooo
0000ooooool000000_ooool00ol0003oooooo`000004ooooo`;o00001?ooool00ol0003ooooooooo
o`3ooooooc7ooooo0005ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooool000000ol00008
ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool00ol0003ooooooooo
o`04ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003oooooooooo`04ooooo`;o
00000oooool01?l0003oooooooooool00002ooooo`05o`000?oooooo0000ooooool000000_ooool0
1?l0003oooooo`000?ooool2o`0000;ooooo00?o0000ooooooooool0oooooolaooooo`001Oooool0
0ol0003oooooooooo`02ooooo`07o`000?ooooooooooooooool0003oooooo`000008ooooo`03o`00
0?oooooooooo00;ooooo00Co0000oooooooooooooooo0_l00007ooooo`?o00000_ooool3o`0000So
oooo0ol000001?oooooo0000o`000?l00002ooooo`?o00000oooool3o`0000;ooooo0_l00002oooo
o`04o`000?oooooo0000o`000?oooooo<Oooool000Gooooo00Co0000oooooooooooo00000_ooool0
1?l0003oooooooooooooool2o`0000Sooooo00?o0000ooooooooool00_ooool01?l0003ooooooooo
ool00002ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0oooooomJooooo`001?oo
ool2o`0000?ooooo0_l00005ooooo`03o`000?oooooooooo00Gooooo0_l00003ooooo`;o00000ooo
ool2o`0000Oooooo00?o0000ooooooooool0oooooomJooooo`00oooooon8ooooo`00oooooon8oooo
o`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8oooo
o`00oooooon8ooooo`00=Oooool3o`0004Sooooo0ol0003oooooo`Gooooo000gooooo`;o0000BOoo
ool2o`000?oooooo1?ooool003Gooooo0_l00019ooooo`;o0000ooooool6ooooo`00=_ooool3o`00
04Sooooo0ol0003oooooo`Cooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo001Iooooo`03o`000?oo
oooooooo0?oooooo;?ooool001Cooooo00?o0000ooooooooool0@oooool00ol0003oooooooooo`1<
ooooo`03o`000?oooooooooo0=_ooooo000Cooooo`03o`000?oooooooooo04Cooooo00?o0000oooo
ooooool0COooool00ol0003oooooooooo`3Jooooo`004oooool00ol0003oooooooooo`2Dooooo`03
o`000?oooooooooo0=[ooooo000Booooo`03o`000?oooooooooo00;ooooo1?l000000ooooooo0000
o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000
o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000
o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000
o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l0000;ooooo`Co0000
00?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o0000
00?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o0000
00?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o0000
00?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o0000
00?oooooo`000?l000000_l00004ooooo`03o`000?oooooooooo0=Wooooo000Cooooo`03o`000?oo
oooooooo09Cooooo00?o0000ooooooooool0f_ooool001?ooooo00?o0000ooooooooool0U?ooool0
0ol0003oooooooooo`3Jooooo`005?ooool00ol0003oooooooooo`2Booooo`03o`000?oooooooooo
0=_ooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003ooooo
ohSooooo003oooooohSooooo001Dooooo`;o0000C_ooool2o`000>7ooooo001Fooooo`03o`000?oo
oooooooo04gooooo00?o0000ooooooooool0g_ooool001[ooooo00Go0000ooooooooooooooooo`00
0003ooooo`;o00000oooool2o`0000?ooooo0_l00003ooooo`?o00001oooool3o`0000;ooooo0_l0
000Booooo`?o00003?ooool3o`0000?ooooo00Co0000oooooooooooooooo0_l00003ooooo`03o`00
0?oooooooooo00;ooooo0_l00003ooooo`;o00000oooool2o`0000Sooooo0ol00002ooooo`;o0000
4_ooool3o`000>3ooooo000Jooooo`03o`000?oooooooooo00Cooooo00Ko0000oooooooooooo0000
ooooool00002ooooo`03o`000?oooooo000000;ooooo00Go0000ooooooooooooooooo`000009oooo
o`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0003oooooooooool0
000=ooooo`03o`000?oooooooooo00Gooooo00Co0000oooooooooooo00000oooool01?l0003ooooo
ooooool00002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool000000_ooool00ol0003o
ooooooooo`06ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0
003oooooooooool0003Pooooo`005oooool4o`0000Kooooo00Ko0000oooooooooooo0000ooooool0
0002ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`000009ooooo`04o`00
0?ooooooooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0003oooooooooool0000=oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00ol000001Ooooooo0000oooooooooooo
000000Cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`06ooooo`04o`000?oooooo
ooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0003oooooooooool0003Pooooo`006?oo
ool00ol0003oooooo`000006ooooo`04o`000?ooooooooooo`0000;ooooo0_l00004ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool01oooool01?l0003oooooooooool00002ooooo`03
o`000?oooooooooo00oooooo0ol0000=ooooo`03o`000?oooooooooo00Gooooo0ol00002ooooo`06
o`000?ooooooooooo`000?oooooo00000_ooool01Ol0003ooooooooooooooooo000000Cooooo00?o
0000ooooooooool01oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00oooooo
0ol0003Pooooo`006Oooool2o`0000Kooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03
o`000?oooooo000000;ooooo00Go0000ooooooooooooooooo`000009ooooo`04o`000?oooooooooo
o`0000;ooooo00?o0000ooooooooool07oooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo00;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooo000000;ooooo
00?o0000ooooool000000_ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`0000;o
oooo00?o0000ooooooooool0l_ooool001[ooooo00?o0000ooooooooool01Oooool2o`0000?ooooo
0_l00003ooooo`;o00000oooool2o`0000Sooooo0_l00003ooooo`;o00008Oooool2o`0000Oooooo
1?l00002ooooo`;o00000oooool2o`0000?ooooo0_l00003ooooo`;o00002?ooool2o`0000?ooooo
0_l0003eooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00B_ooool00ol0003oooooooooo`1=oooo
o`03o`000?oooooooooo0>[ooooo001:ooooo`03o`000?oooooooooo04gooooo00?o0000oooooooo
ool0j_ooool004Cooooo1?l00003ooooo`03o`000?oooooooooo04Kooooo1?l00003ooooo`03o`00
0?oooooooooo0>Wooooo001;ooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0jOoo
ool004Wooooo00Co0000oooooooooooo0000C?ooool01?l0003oooooooooool0003Zooooo`00BOoo
ool4o`0004cooooo1?l0003Zooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00^?ooool2o`0000?ooooo00?o0000oooo
ooooool0aoooool006kooooo00?o0000ooooooooool0BOooool01Ol0003ooooooooooooooooo0000
00gooooo00?o0000ooooooooool0^?ooool001;ooooo00Co0000oooooooooooo00000_ooool3o`00
0004ooooool0003o0000o`0000;ooooo0_l000001ooooooo0000o`000?oooooo0000ooooool00000
0_ooool2o`0000?ooooo0_l00003ooooo`Co00001Oooool3o`0000?ooooo0ol000001?oooooo0000
o`000?l00003ooooo`?o00000_ooool3o`0000?ooooo0_l000001?oooooo0000o`000?l00004oooo
o`03o`000?oooooooooo00Kooooo00Co0000oooooooooooooooo1?l00006ooooo`Co000000Cooooo
o`000?l0003o00000oooool3o`0000;ooooo0ol00007ooooo`Oo00000oooool3o`0000;ooooo0ol0
00001Ooooooo0000oooooooooooo000000;ooooo0ol000001Ooooooo0000oooooooooooo000000;o
oooo0ol00003ooooo`03o`000?oooooooooo00Co00000_ooool3o`0000?ooooo00?o0000oooooooo
ool0]oooool001;ooooo00?o0000ooooool000001?ooool01Ol0003ooooooooooooooooo000000Co
oooo00?o0000ooooool000000_ooool01Ol0003oooooo`000?oooooo000000;ooooo00?o0000oooo
ool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Gooooo00Co0000oooo
oooooooooooo0_l00005ooooo`;o000000Goooooo`000?ooooooooooo`000003ooooo`05o`000?oo
ooooooooooooool000001Oooool2o`0000cooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooooooo0_l00003ooooo`;o
00002?ooool01?l0003oooooooooool00002ooooo`05o`000?ooooooooooooooool000000_ooool0
1Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo00000oooool01?l0003ooooo
ooooool00002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0]oooool001;ooooo
0_l00005ooooo`05o`000?ooooooooooooooool000001?ooool2o`0000;ooooo00Co0000ooooool0
003ooooo0_l00002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool000000_ooool00ol0
003oooooooooo`05ooooo`06o`000?ooooooooooooooool0003ooooo0_l000000ooooooo0000o`00
0003ooooo`04o`000?ooooooooooo`0000?ooooo00Go0000ooooooooooooooooo`000003ooooo`;o
00003Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool00_ooool01_l0003ooooooooooooooooo0000ooooo`;o000000?oooooo`000?ooool00_l00000
0ooooooo0000o`000002o`000005ooooool0003oooooooooool000000_ooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooo000000?ooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooo
oooooooooooo000000;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo0;Kooooo000Booooo`;o00001?ooool2o`0000;ooooo00Co0000ooooool0003o00000_ooool0
2_l0003oooooo`000?oooooo0000ooooool0003oooooo`000?ooool2o`0000?ooooo0_l00003oooo
o`?o00001_ooool01?l0003oooooo`000?l00002ooooo`;o00000oooool3o`000005ooooool0003o
ooooooooool000000oooool00ol0003oooooooooo`04o`0000;ooooo0ol00003ooooo`03o`000?oo
oooooooo00Kooooo00Co0000oooooooooooooooo1?l00006ooooo`Co000000?oooooo`000?ooool0
0_l00002ooooo`;o00000oooool2o`0000Sooooo0ol000000ooooooo0000ooooo`02o`000004oooo
ool0003o0000o`0000?ooooo0_l00002ooooo`?o00000oooool2o`0000;ooooo0ol00003ooooo`?o
00001_ooool4o`0000?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2gooooo`00
4_ooool00ol0003oooooo`00000=ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool0
6_ooool01Ol0003ooooooooooooooooo000001?ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool0:?ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0]oooool001;ooooo
00Co0000oooooooooooo00000oooool00ol0003oooooooooo`05ooooo`;o00005?ooool2o`0001_o
oooo0_l0000Hooooo`03o`000?oooooooooo00;ooooo0_l00008ooooo`;o00005oooool2o`0000go
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Aooooo`;o00000_ooool2o`0000?o
oooo00?o0000ooooooooool0^?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
0?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool000?ooooo00Co0000
oooooooooooo00000_ooool3o`000004ooooool0003o0000o`0000;ooooo0_l000000ooooooo0000
o`000005ooooo`?o00001oooool01_l0003oooooo`000?oooooo0000ooooo`;o00000oooool4o`00
0004ooooool0003o0000o`0000;ooooo0ol00003ooooo`03o`000?oooooooooo0?ooooooA?ooool0
00?ooooo00?o0000ooooool000001?ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000
ooooool000002?ooool2o`0000Kooooo00Co0000ooooool0003ooooo0_l00002ooooo`03o`000?oo
oooo000000;ooooo00Co0000ooooool0003o00001Oooool00ol0003oooooooooo`3oooooodWooooo
0003ooooo`;o00001Oooool01Ol0003ooooooooooooooooo000000Cooooo0_l00007ooooo`;o0000
2?ooool01?l0003oooooo`000?ooool2o`0000;ooooo00?o0000ooooool000000_ooool01?l0003o
ooooo`000?ooool2o`0000?ooooo00?o0000ooooooooool0oooooom9ooooo`000oooool2o`0000Co
oooo0_l00002ooooo`04o`000?oooooo0000o`0000;ooooo00?o0000ooooool000001oooool3o`00
00Kooooo0_l000001?oooooo0000ooooooooool2o`0000?ooooo0ol00002ooooo`;o00001?ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo0?ooooooA?ooool000?ooooo00?o0000oooo
ool000003Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo01Sooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`3oooooodWooooo0003ooooo`04o`000?ooooooooooo`00
00?ooooo00?o0000ooooooooool01Oooool2o`0000Cooooo00?o0000ooooooooool05oooool2o`00
00Oooooo0_l0003ooooood_ooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo000e
ooooo`?o0000COooool3o`000?oooooo000gooooo`;o0000C_ooool2o`000?kooooo000eooooo`;o
0000C_ooool2o`000?oooooo0Oooool003Kooooo0ol0001=ooooo`?o0000o_ooool00?ooooooR?oo
ool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?oo
ool00?ooooooR?ooool005kooooo00?o0000ooooooooool0oooooolWooooo`005?ooool00ol0003o
ooooooooo`18ooooo`03o`000?oooooooooo04cooooo00?o0000ooooooooool0e_ooool001?ooooo
00?o0000ooooooooool0BOooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0=Gooooo
000Cooooo`03o`000?oooooooooo09Wooooo00?o0000ooooooooool0eOooool001;ooooo00?o0000
ooooooooool00_ooool4o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l00000
0ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l00000
0ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l00000
0ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l00000
0ooooooo0000o`000002o`000003ooooool0003o000000;o00002oooool4o`000003ooooool0003o
000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o
000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o
000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o
000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o
000000;o00001?ooool00ol0003oooooooooo`3Dooooo`004oooool00ol0003oooooooooo`2Ioooo
o`03o`000?oooooooooo0=Gooooo000Cooooo`03o`000?oooooooooo09Wooooo00?o0000oooooooo
ool0eOooool001Cooooo00?o0000ooooooooool0Uoooool00ol0003oooooooooo`3Fooooo`00oooo
oon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooo
oon8ooooo`00FOooool2o`0004kooooo0_l0003Looooo`00Foooool00ol0003oooooooooo`1=oooo
o`03o`000?oooooooooo0=Wooooo000Hooooo`;o00001?ooool00ol0003oooooooooo`04o`0000;o
oooo0_l00003ooooo`;o00000oooool2o`0000?ooooo0_l00008ooooo`?o00000_ooool2o`0001;o
oooo0ol0000;ooooo`Co00000oooool01?l0003oooooooooooooool2o`0000?ooooo0_l00005oooo
o`04o`000?ooooooooooo`0000Cooooo0_l00008ooooo`?o00000_ooool2o`0001;ooooo0ol0003K
ooooo`005oooool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool000000_oo
ool00ol0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool000000_oo
ool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0
3_ooool01?l0003oooooooooool0000<ooooo`03o`000?oooooooooo00Kooooo00Ko0000oooooooo
oooo0000ooooool00002ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`00
0002ooooo`04o`000?ooooooooooo`0000Sooooo00Co0000oooooooooooo00000_ooool00ol0003o
ooooooooo`0>ooooo`04o`000?ooooooooooo`000=_ooooo000Jooooo`03o`000?oooooooooo00Ko
oooo00?o0000ooooooooool00oooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000;o
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`00
00;ooooo00?o0000ooooooooool03_ooool01?l0003oooooooooool0000=ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooool000000_ooool00ol0003oooooo`000003o`0000;ooooo0ol00004
ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo00000_ooool00ol0003ooooooooo
o`0>ooooo`04o`000?ooooooooooo`000=_ooooo000Iooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooool000000_l00003ooooo`;o00000_ooool3o`0000Cooooo00?o0000ooooooooool01ooo
ool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00oooooo0ol0000>ooooo`03o`00
0?oooooooooo00Kooooo00Co0000oooooooooooo00000_ooool02?l0003oooooooooool0003ooooo
o`000?oooooo00000_ooool01Ol0003ooooooooooooooooo000000Wooooo00Co0000oooooooooooo
00000_ooool00ol0003oooooooooo`0?ooooo`?o0000foooool001Oooooo00Co0000oooooooooooo
00001_ooool01_l0003oooooooooool0003oooooo`0000Cooooo00Co0000oooooooooooo00000_oo
ool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool01_ooool01?l0003ooooo
ooooool00002ooooo`03o`000?oooooooooo01gooooo00Co0000oooooooooooo00001_ooool01_l0
003oooooooooool0003oooooo`0000;ooooo00Co0000oooooooooooooooo0_l000001ooooooo0000
oooooooooooo0000ooooool000000_ooool00ol0003oooooooooo`06ooooo`04o`000?oooooooooo
o`0000;ooooo00?o0000ooooooooool0kOooool001Sooooo0_l00008ooooo`;o00000_ooool4o`00
00;ooooo0_l00004ooooo`04o`000?ooooooooooooooo`;o00002?ooool2o`0000?ooooo0_l0000Q
ooooo`;o00002?ooool2o`0000?ooooo0_l00005ooooo`03o`000?oooooooooo00;o00000oooool2
o`0000Sooooo0_l00003ooooo`;o0000l?ooool00?ooooooR?ooool00?ooooooR?ooool00?oooooo
R?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool004oooooo
00?o0000ooooooooool0COooool00ol0003oooooooooo`3Uooooo`00Coooool00ol0003ooooooooo
o`1=ooooo`03o`000?oooooooooo0>Gooooo0019ooooo`Co00000oooool00ol0003oooooooooo`16
ooooo`Co00000oooool00ol0003oooooooooo`3Tooooo`00D?ooool00ol0003oooooooooo`1=oooo
o`03o`000?oooooooooo0>Cooooo001>ooooo`04o`000?ooooooooooo`0004cooooo00Co0000oooo
oooooooo0000iOooool004kooooo1?l0001<ooooo`Co0000iOooool00?ooooooR?ooool00?oooooo
R?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00;Sooooo
0_l00003ooooo`03o`000?oooooooooo0<Oooooo001^ooooo`03o`000?oooooooooo04Wooooo00Go
0000ooooooooooooooooo`00000=ooooo`03o`000?oooooooooo0;Sooooo000Booooo`04o`000?oo
ooooooooo`0000;ooooo0ol000001?oooooo0000o`000?l00002ooooo`;o000000Ooooooo`000?l0
003oooooo`000?oooooo000000;ooooo0_l00003ooooo`;o00000oooool4o`0000Gooooo0ol00003
ooooo`?o000000Coooooo`000?l0003o00000oooool3o`0000;ooooo0ol00003ooooo`;o000000Co
ooooo`000?l0003o00001?ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooooooo`Co
00001_ooool4o`000004ooooool0003o0000o`0000?ooooo0ol00002ooooo`?o00001oooool7o`00
00?ooooo0ol00002ooooo`?o000000Goooooo`000?ooooooooooo`000002ooooo`?o000000Gooooo
o`000?ooooooooooo`000002ooooo`?o00000oooool00ol0003oooooooooo`04o`0000;ooooo0ol0
0003ooooo`03o`000?oooooooooo0;Oooooo000Booooo`03o`000?oooooo000000Cooooo00Go0000
ooooooooooooooooo`000004ooooo`03o`000?oooooo000000;ooooo00Go0000ooooool0003ooooo
o`000002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool000000_ooool00ol0003ooooo
ooooo`05ooooo`04o`000?ooooooooooooooo`;o00001Oooool2o`000005ooooool0003ooooooooo
ool000000oooool01Ol0003ooooooooooooooooo000000Gooooo0_l0000<ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`02ooooo`04o`000?oooooo
ooooooooo`;o00000oooool2o`0000Sooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooo
oooooooooooo000000;ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oooooooooo
o`0000?ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo0;Oooooo000Booooo`;o00001Oooool01Ol0003ooooooooooooooooo000000Cooooo0_l0
0002ooooo`04o`000?oooooo0000ooooo`;o00000_ooool00ol0003oooooo`000002ooooo`03o`00
0?oooooo000000;ooooo00?o0000ooooooooool01Oooool01_l0003ooooooooooooooooo0000oooo
o`;o000000?oooooo`000?l000000oooool01?l0003oooooooooool00003ooooo`05o`000?oooooo
ooooooooool000000oooool2o`0000gooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo00;ooooo00Ko0000ooooooooooooooooo`000?ooool2o`000003
ooooool0003ooooo00;o000000?oooooo`000?l000000_l000001Ooooooo0000oooooooooooo0000
00;ooooo00?o0000ooooooooool00_ooool00ol0003oooooo`000003ooooo`04o`000?oooooooooo
o`0000;ooooo00Go0000ooooooooooooooooo`000002ooooo`06o`000?ooooooooooo`000?oooooo
00000_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`2fooooo`004_ooool2o`0000Cooooo0_l00002ooooo`04o`00
0?oooooo0000o`0000;ooooo00[o0000ooooool0003oooooo`000?oooooo0000ooooool0003ooooo
0_l00003ooooo`;o00000oooool3o`0000Kooooo00Co0000ooooool0003o00000_ooool2o`0000?o
oooo0ol000001Ooooooo0000oooooooooooo000000?ooooo00?o0000ooooooooool01?l00002oooo
o`?o00000oooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooooooo`Co00001_ooool4
o`000003ooooool0003ooooo00;o00000_ooool2o`0000?ooooo0_l00008ooooo`?o000000?ooooo
o`000?ooool00_l000001?oooooo0000o`000?l00003ooooo`;o00000_ooool3o`0000?ooooo0_l0
0002ooooo`?o00000oooool3o`0000Kooooo1?l00003ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool0]oooool001;ooooo00?o0000ooooool000003Oooool00ol0003oooooooooo`0C
ooooo`03o`000?oooooooooo01[ooooo00Go0000ooooooooooooooooo`00000Cooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Hooooo`03o`000?oo
oooooooo02Sooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo0;Oooooo000Booooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool01Ooo
ool2o`0001Cooooo0_l0000Kooooo`;o00006?ooool00ol0003oooooooooo`02ooooo`;o00002?oo
ool2o`0001Oooooo0_l0000=ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool04Ooo
ool2o`0000;ooooo0_l00003ooooo`03o`000?oooooooooo0;Sooooo003oooooohSooooo003ooooo
ohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo0009ooooo`03o`000?oooooo
oooo0?ooooooO?ooool000[ooooo00?o0000ooooooooool0oooooomkooooo`000oooool01Ol0003o
oooooooooooooooo000000;ooooo00?o0000ooooooooool01Oooool01_l0003oooooo`000?oooooo
0000ooooo`;o00000oooool4o`000004ooooool0003o0000o`0000;ooooo0ol00003ooooo`03o`00
0?oooooooooo0?ooooooF?ooool000?ooooo00Wo0000ooooooooooooooooo`000?oooooo0000oooo
ool000001_ooool01?l0003oooooo`000?ooool2o`0000;ooooo00?o0000ooooool000000_ooool0
1?l0003oooooo`000?l00005ooooo`03o`000?oooooooooo0?ooooooGOooool000?ooooo00Wo0000
ooooooooooooooooo`000?oooooo0000ooooool000001_ooool01?l0003oooooo`000?ooool2o`00
00;ooooo00?o0000ooooool000000_ooool01?l0003oooooo`000?ooool2o`0000?ooooo00?o0000
ooooooooool0oooooomMooooo`000oooool01?l0003oooooo`000?ooool3o`000003ooooool0003o
000000Gooooo0_l000001?oooooo0000ooooooooool2o`0000?ooooo0ol00002ooooo`;o00001?oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0?ooooooF?ooool000?ooooo0_l00000
0ooooooo0000o`00000Gooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0oooooomM
ooooo`000oooool01Ol0003ooooooooooooooooo000001Kooooo0_l00007ooooo`;o0000oooooomO
ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8
ooooo`00oooooon8ooooo`00<?ooool2o`0000gooooo0_l0003oooooodOooooo000`ooooo`03o`00
0?oooooooooo00cooooo00?o0000ooooooooool0oooooom6ooooo`001?ooool3o`0000;ooooo0_l0
0003ooooo`;o00001?ooool01?l0003oooooooooooooool2o`0000?ooooo0_l00003ooooo`;o0000
1oooool3o`0000;ooooo0ol00007ooooo`?o00000_ooool3o`0000?ooooo0ol00002ooooo`?o0000
0_ooool3o`000004ooooool0003o0000o`000?oooooo<_ooool000Gooooo00Co0000oooooooooooo
00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Cooooo00Ko0000oooooooo
oooo0000ooooool00002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool01?ooool0
1_l0003oooooooooool0003oooooo`0000;ooooo00?o0000ooooooooool01_ooool2o`000007oooo
ool0003oooooooooool0003oooooo`000002ooooo`03o`000?oooooo000000Cooooo0_l00004oooo
o`03o`000?oooooooooo0?oooooo<Oooool000Gooooo00Co0000oooooooooooo00000_ooool00ol0
003oooooo`000002ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooool000000_ooool00ol0
003oooooo`000002ooooo`03o`000?oooooooooo00Cooooo00Ko0000oooooooooooo0000ooooool0
0002ooooo`03o`000?oooooooooo00Cooooo0_l00003ooooo`04o`000?ooooooooooo`0000;ooooo
00Go0000ooooool0003oooooo`000002ooooo`04o`000?oooooo0000ooooo`;o00000_ooool00ol0
003oooooooooo`3ooooooc7ooooo0005ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooo
ool000000_ooool00ol0003oooooooooo`04ooooo`?o00000oooool2o`0000?ooooo0_l00007oooo
o`?o00000_ooool3o`0000Sooooo0ol000001?oooooo0000o`000?l00002ooooo`?o00000oooool3
o`0000;ooooo0_l00002ooooo`04o`000?oooooo0000o`000?oooooo<Oooool000Gooooo00Co0000
oooooooooooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool00_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`3ooooooe[ooooo0004ooooo`;o00000oooool2o`0000?ooooo
0_l00007ooooo`Co00000_ooool2o`0000?ooooo0_l00007ooooo`03o`000?oooooooooo0?oooooo
F_ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?oooooo
R?ooool00?ooooooR?ooool00?ooooooR?ooool003Gooooo0ol0001=ooooo`?o0000ooooool003Oo
oooo0_l0001>ooooo`;o0000o_ooool003Gooooo0_l0001>ooooo`;o0000ooooool1ooooo`00=_oo
ool3o`0004gooooo0ol0003nooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
G_ooool00ol0003oooooooooo`3oooooobOooooo000Dooooo`03o`000?oooooooooo04Sooooo00?o
0000ooooooooool0C?ooool00ol0003oooooooooo`3Fooooo`004oooool00ol0003oooooooooo`19
ooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0eOooool001?ooooo00?o0000oooo
ooooool0VOooool00ol0003oooooooooo`3Eooooo`004_ooool00ol0003oooooooooo`02ooooo`Co
000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o
000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o
000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o
000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o
000000?oooooo`000?l000000_l0000;ooooo`Co000000?oooooo`000?l000000_l000000ooooooo
0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo
0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo
0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo
0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l00004ooooo`03
o`000?oooooooooo0=Cooooo000Cooooo`03o`000?oooooooooo09Wooooo00?o0000ooooooooool0
eOooool001?ooooo00?o0000ooooooooool0VOooool00ol0003oooooooooo`3Eooooo`005?ooool0
0ol0003oooooooooo`2Gooooo`03o`000?oooooooooo0=Kooooo003oooooohSooooo003oooooohSo
oooo003oooooohSooooo003oooooohSooooo003oooooohSooooo001Iooooo`;o0000C_ooool2o`00
0=cooooo001Kooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0fOooool001Sooooo
0_l00004ooooo`05o`000?ooooooooooooooool000001?ooool2o`0000?ooooo0_l00005ooooo`03
o`000?oooooooooo00;o00002?ooool3o`0000;ooooo0_l0000Booooo`?o00003?ooool3o`0000?o
oooo00Co0000oooooooooooooooo0_l00005ooooo`03o`000?oooooooooo00;o00000oooool01?l0
003oooooooooooooool4o`0000Oooooo0ol00002ooooo`;o00004_ooool3o`000=_ooooo000Goooo
o`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oo
oooo000000;ooooo00?o0000ooooooooool00_ooool00ol0003oooooo`000002ooooo`03o`000?oo
oooooooo00Kooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`00
0?ooooooooooo`0000gooooo00?o0000ooooooooool01Oooool01?l0003oooooooooool00004oooo
o`03o`000?oooooo000000;ooooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooo
oooo00Sooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?oo
ooooooooo`000=_ooooo000Jooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo0000
0_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000?o000000Goooooo`000?oooooo
ooooo`000008ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0
003oooooooooool0000=ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooool000000ol00004
ooooo`03o`000?oooooooooo00?o00000oooool00ol0003oooooooooo`07ooooo`04o`000?oooooo
ooooo`0000;ooooo00?o0000ooooooooool03_ooool01?l0003oooooooooool0003Kooooo`006Ooo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00?o00000_ooool3o`0000?ooooo00Co
0000ooooool0003ooooo0ol00009ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooooooo
ool03oooool3o`0000gooooo00?o0000ooooooooool01Oooool3o`0000?ooooo00?o0000ooooool0
00000oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool01_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00oooooo0ol0003K
ooooo`005oooool01?l0003oooooooooool00006ooooo`04o`000?ooooooooooo`0000;ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`03ooooo`;o00000_ooool00ol0003ooooooooo
o`08ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool07oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Cooooo0_l000001ooooooo0000oooooooooooo0000oooo
ool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Kooooo00Co0000oooo
oooooooo00000_ooool00ol0003oooooooooo`3]ooooo`006?ooool2o`0000Oooooo1?l00003oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo
000000Sooooo0_l00003ooooo`;o00008Oooool2o`0000Oooooo1?l00004ooooo`03o`000?oooooo
oooo00;o00000oooool2o`0000?ooooo0_l00008ooooo`;o00000oooool2o`000?3ooooo003ooooo
ohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003ooooo
ohSooooo003oooooohSooooo003oooooohSooooo001?ooooo`03o`000?oooooooooo04gooooo00?o
0000ooooooooool0iOooool004oooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`3U
ooooo`00BOooool4o`0000?ooooo00?o0000ooooooooool0A_ooool4o`0000?ooooo00?o0000oooo
ooooool0i?ooool0053ooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`3Tooooo`00
C_ooool01?l0003oooooooooool0001<ooooo`04o`000?ooooooooooo`000>Gooooo001>ooooo`Co
0000C?ooool4o`000>Gooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003ooooo
ohSooooo003oooooohSooooo002hooooo`;o00000oooool00ol0003oooooooooo`37ooooo`00K_oo
ool00ol0003oooooooooo`19ooooo`05o`000?ooooooooooooooool000003Oooool00ol0003ooooo
ooooo`2hooooo`004_ooool01?l0003oooooooooool00002ooooo`?o000000Coooooo`000?l0003o
00000_ooool2o`000007ooooool0003o0000ooooool0003oooooo`000002ooooo`;o00000oooool2
o`0000?ooooo1?l00005ooooo`?o00000oooool3o`000004ooooool0003o0000o`0000?ooooo0ol0
0002ooooo`?o00000oooool2o`000004ooooool0003o0000o`0000Cooooo00?o0000ooooooooool0
1_ooool01?l0003oooooooooooooool4o`0000Kooooo1?l000001?oooooo0000o`000?l00003oooo
o`?o00000_ooool3o`0000Oooooo1ol00003ooooo`?o00000_ooool3o`000005ooooool0003ooooo
ooooool000000_ooool3o`000005ooooool0003oooooooooool000000_ooool3o`0000?ooooo00?o
0000ooooooooool01?l00002ooooo`?o00000oooool00ol0003oooooooooo`2gooooo`004_ooool0
0ol0003oooooo`000004ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooo`00
0002ooooo`05o`000?oooooo0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`00
0?oooooo000000;ooooo00?o0000ooooooooool01Oooool01?l0003oooooooooooooool2o`0000Go
oooo0_l000001Ooooooo0000oooooooooooo000000?ooooo00Go0000ooooooooooooooooo`000005
ooooo`;o00003?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool00_ooool01?l0003oooooooooooooool2o`0000?ooooo0_l00008ooooo`04o`000?oo
ooooooooo`0000;ooooo00Go0000ooooooooooooooooo`000002ooooo`05o`000?oooooooooooooo
ool000000_ooool01?l0003oooooooooool00003ooooo`04o`000?ooooooooooo`0000;ooooo00?o
0000ooooool000000_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`2gooooo`004_ooool2o`0000Gooooo00Go0000
ooooooooooooooooo`000004ooooo`;o00000_ooool01?l0003oooooo`000?ooool2o`0000;ooooo
00?o0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Gooooo
00Ko0000ooooooooooooooooo`000?ooool2o`000003ooooool0003o000000?ooooo00Co0000oooo
oooooooo00000oooool01Ol0003ooooooooooooooooo000000?ooooo0_l0000=ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`02ooooo`06o`000?oo
ooooooooooooool0003ooooo0_l000000ooooooo0000ooooo`02o`000003ooooool0003o000000;o
000000Goooooo`000?ooooooooooo`000002ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ool000000oooool01?l0003oooooooooool00002ooooo`05o`000?ooooooooooooooool000000_oo
ool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0]_ooool001;ooooo
0_l00004ooooo`;o00000_ooool01?l0003oooooo`000?l00002ooooo`0:o`000?oooooo0000oooo
ool0003oooooo`000?oooooo0000ooooo`;o00000oooool2o`0000?ooooo0ol00006ooooo`04o`00
0?oooooo0000o`0000;ooooo0_l00003ooooo`?o000000Goooooo`000?ooooooooooo`000003oooo
o`03o`000?oooooooooo00Co00000_ooool3o`0000?ooooo00?o0000ooooooooool01_ooool01?l0
003oooooooooooooool4o`0000Kooooo1?l000000ooooooo0000ooooo`02o`0000;ooooo0_l00003
ooooo`;o00002?ooool3o`000003ooooool0003ooooo00;o000000Coooooo`000?l0003o00000ooo
ool2o`0000;ooooo0ol00003ooooo`;o00000_ooool3o`0000?ooooo0ol00006ooooo`Co00000ooo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0;Oooooo000Booooo`03o`000?oooooo
000000gooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0Jooooo`05o`000?oooooo
ooooooooool000004oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool06?ooool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`2gooooo`004_ooool01?l0003oooooooooool0
0003ooooo`03o`000?oooooooooo00Gooooo0_l0000Dooooo`;o00006oooool2o`0001Sooooo00?o
0000ooooooooool00_ooool2o`0000Sooooo0_l0000Gooooo`;o00003Oooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo017ooooo0_l00002ooooo`;o00000oooool00ol0003ooooooooo
o`2hooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooo
oon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`000oooool01?l0003ooooo
ooooool00002ooooo`?o000000Coooooo`000?l0003o00000_ooool2o`000003ooooool0003o0000
00Gooooo0ol00007ooooo`06o`000?oooooo0000ooooool0003ooooo0_l00003ooooo`Co000000Co
ooooo`000?l0003o00000_ooool3o`0000?ooooo00?o0000ooooooooool0oooooom4ooooo`000ooo
ool00ol0003oooooo`000004ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003ooooo
o`000008ooooo`;o00001_ooool01?l0003oooooo`000?ooool2o`0000;ooooo00?o0000ooooool0
00000_ooool01?l0003oooooo`000?l00005ooooo`03o`000?oooooooooo0?ooooooBOooool000?o
oooo0_l00005ooooo`05o`000?ooooooooooooooool000001?ooool2o`0000Oooooo0_l00008oooo
o`04o`000?oooooo0000ooooo`;o00000_ooool00ol0003oooooo`000002ooooo`04o`000?oooooo
0000ooooo`;o00000oooool00ol0003oooooooooo`3oooooodWooooo0003ooooo`;o00001?ooool2
o`0000;ooooo00Co0000ooooool0003o00000_ooool00ol0003oooooo`000007ooooo`?o00001_oo
ool2o`000004ooooool0003oooooooooo`;o00000oooool3o`0000;ooooo0_l00004ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool0oooooom4ooooo`000oooool00ol0003oooooo`00
000=ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool06?ooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo0?ooooooBOooool000?ooooo00Co0000oooooooooooo00000ooo
ool00ol0003oooooooooo`05ooooo`;o00001?ooool00ol0003oooooooooo`0Gooooo`;o00001ooo
ool2o`000?ooooooBoooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?oooooo
R?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool003Gooooo0ol0001=ooooo`?o
0000ooooool003Oooooo0_l0001>ooooo`;o0000o_ooool003Gooooo0_l0001>ooooo`;o0000oooo
ool1ooooo`00=_ooool3o`0004gooooo0ol0003nooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00G_ooool00ol0003oooooooooo`3oooooobOooooo000Dooooo`03o`000?oooooo
oooo04Sooooo00?o0000ooooooooool0Aoooool00ol0003oooooooooo`3Kooooo`004oooool00ol0
003oooooooooo`19ooooo`03o`000?oooooooooo04Sooooo00?o0000ooooooooool0f_ooool001?o
oooo00?o0000ooooooooool0U?ooool00ol0003oooooooooo`3Jooooo`004_ooool00ol0003ooooo
ooooo`02ooooo`Co000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003oooo
ool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003oooo
ool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003oooo
ool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003oooo
ool0003o000000;o000000?oooooo`000?l000000_l0000;ooooo`Co000000?oooooo`000?l00000
0_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l00000
0_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l00000
0_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l00000
0_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o00001?ooool00ol0003ooooo
ooooo`3Iooooo`004oooool00ol0003oooooooooo`2Dooooo`03o`000?oooooooooo0=[ooooo000C
ooooo`03o`000?oooooooooo09Cooooo00?o0000ooooooooool0f_ooool001Cooooo00?o0000oooo
ooooool0T_ooool00ol0003oooooooooo`3Kooooo`00oooooon8ooooo`00oooooon8ooooo`00oooo
oon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00FOooool2o`0004Wooooo0_l0003Qooooo`00
Foooool00ol0003oooooooooo`18ooooo`03o`000?oooooooooo0=kooooo000Hooooo`;o00001?oo
ool01?l0003oooooooooooooool3o`0000;ooooo0_l00003ooooo`;o00000oooool00ol0003ooooo
ooooo`02ooooo`;o00002?ooool3o`0000;ooooo0_l0000Booooo`?o00002oooool4o`0000?ooooo
00Co0000oooooooooooooooo0ol00002ooooo`;o00000oooool2o`0000?ooooo0_l00008ooooo`?o
00000_ooool2o`0001;ooooo0ol0003Pooooo`005oooool01?l0003oooooooooool00008ooooo`04
o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000_ooool01Ol0003ooooooooooooooooo
000000;ooooo00Co0000oooooooooooo00002?ooool01?l0003oooooooooool00002ooooo`03o`00
0?oooooooooo00kooooo00Co0000oooooooooooo00003?ooool00ol0003oooooooooo`08ooooo`04
o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000_ooool00ol0003oooooo`000002oooo
o`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>
ooooo`04o`000?ooooooooooo`000>3ooooo000Jooooo`03o`000?oooooooooo00Kooooo00?o0000
ooooooooool00oooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00?o000000Gooooo
o`000?ooooooooooo`000008ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0
3_ooool01?l0003oooooooooool0000=ooooo`03o`000?oooooooooo00Oooooo00Co0000oooooooo
oooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000oooo
ooooool01_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00kooooo00Co0000
oooooooooooo0000h?ooool001Wooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`02
ooooo`04o`000?ooooooooooooooo`;o00000_ooool01?l0003oooooooooool00002ooooo`;o0000
2Oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00oooooo0ol0000>ooooo`03
o`000?oooooooooo00Kooooo00?o0000ooooooooool00ol00003ooooo`;o00000oooool2o`0000Wo
oooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0?ooooo`?o0000h?ooool001Oo
oooo00Co0000oooooooooooo00002?ooool01?l0003oooooooooool00002ooooo`03o`000?oooooo
000000;ooooo00?o0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo
oooo00Kooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0Mooooo`04o`000?oo
ooooooooo`0000Sooooo00Go0000ooooooooooooooooo`000003ooooo`06o`000?ooooooooooo`00
0?oooooo00000_ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`0000;ooooo00?o
0000ooooooooool0l_ooool001Sooooo0_l00008ooooo`;o00000oooool2o`0000?ooooo0_l00003
ooooo`;o00000oooool2o`0000Sooooo0_l00003ooooo`;o00008Oooool2o`0000Sooooo0_l00004
ooooo`04o`000?ooooooooooooooo`;o00000oooool2o`0000Sooooo0_l00003ooooo`;o0000mOoo
ool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?oo
ool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool004oooooo00?o0000ooooooooool0
B?ooool00ol0003oooooooooo`3Zooooo`00Coooool00ol0003oooooooooo`18ooooo`03o`000?oo
oooooooo0>[ooooo0019ooooo`Co00000oooool00ol0003oooooooooo`11ooooo`Co00000oooool0
0ol0003oooooooooo`3Yooooo`00D?ooool00ol0003oooooooooo`18ooooo`03o`000?oooooooooo
0>Wooooo001>ooooo`04o`000?ooooooooooo`0004Oooooo00Co0000oooooooooooo0000j_ooool0
04kooooo1?l00017ooooo`Co0000j_ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?oo
ool00?ooooooR?ooool00?ooooooR?ooool00;Sooooo0_l00003ooooo`03o`000?oooooooooo0<Oo
oooo001^ooooo`03o`000?oooooooooo04Wooooo00Go0000ooooooooooooooooo`00000=ooooo`03
o`000?oooooooooo0;Sooooo000Booooo`04o`000?ooooooooooo`0000;ooooo0ol000001?oooooo
0000o`000?l00002ooooo`;o000000Ooooooo`000?l0003oooooo`000?oooooo000000;ooooo0_l0
0003ooooo`;o00000oooool4o`0000Gooooo0ol00003ooooo`?o000000Coooooo`000?l0003o0000
0oooool3o`0000;ooooo0ol00003ooooo`;o000000Coooooo`000?l0003o00001?ooool00ol0003o
ooooooooo`06ooooo`04o`000?ooooooooooooooo`Co00001_ooool4o`000004ooooool0003o0000
o`0000?ooooo0ol00002ooooo`?o00001oooool7o`0000?ooooo0ol00002ooooo`?o000000Gooooo
o`000?ooooooooooo`000002ooooo`?o000000Goooooo`000?ooooooooooo`000002ooooo`?o0000
0oooool00ol0003oooooooooo`04o`0000;ooooo0ol00003ooooo`03o`000?oooooooooo0;Oooooo
000Booooo`03o`000?oooooo000000Cooooo00Go0000ooooooooooooooooo`000004ooooo`03o`00
0?oooooo000000;ooooo00Go0000ooooool0003oooooo`000002ooooo`03o`000?oooooo000000;o
oooo00?o0000ooooool000000_ooool00ol0003oooooooooo`05ooooo`04o`000?oooooooooooooo
o`;o00001Oooool2o`000005ooooool0003oooooooooool000000oooool01Ol0003ooooooooooooo
oooo000000Gooooo0_l0000<ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooooooo`;o00000oooool2o`0000Sooooo
00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000oooo
ooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000?ooooo00Co0000oooooooooooo0000
0_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0;Oooooo000Booooo`;o00001Ooo
ool01Ol0003ooooooooooooooooo000000Cooooo0_l00002ooooo`04o`000?oooooo0000ooooo`;o
00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000oooooooo
ool01Oooool01_l0003ooooooooooooooooo0000ooooo`;o000000?oooooo`000?l000000oooool0
1?l0003oooooooooool00003ooooo`05o`000?ooooooooooooooool000000oooool2o`0000gooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00;ooooo
00Ko0000ooooooooooooooooo`000?ooool2o`000003ooooool0003ooooo00;o000000?oooooo`00
0?l000000_l000001Ooooooo0000oooooooooooo000000;ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000oooooooooooooooo
o`000002ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2foooo
o`004_ooool2o`0000Cooooo0_l00002ooooo`04o`000?oooooo0000o`0000;ooooo00[o0000oooo
ool0003oooooo`000?oooooo0000ooooool0003ooooo0_l00003ooooo`;o00000oooool3o`0000Ko
oooo00Co0000ooooool0003o00000_ooool2o`0000?ooooo0ol000001Ooooooo0000oooooooooooo
000000?ooooo00?o0000ooooooooool01?l00002ooooo`?o00000oooool00ol0003oooooooooo`06
ooooo`04o`000?ooooooooooooooo`Co00001_ooool4o`000003ooooool0003ooooo00;o00000_oo
ool2o`0000?ooooo0_l00008ooooo`?o000000?oooooo`000?ooool00_l000001?oooooo0000o`00
0?l00003ooooo`;o00000_ooool3o`0000?ooooo0_l00002ooooo`?o00000oooool3o`0000Kooooo
1?l00003ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0]oooool001;ooooo00?o
0000ooooool000003Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo01[ooooo00Go
0000ooooooooooooooooo`00000Cooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0;Oooooo000Booooo`04o`000?oo
ooooooooo`0000?ooooo00?o0000ooooooooool01Oooool2o`0001Cooooo0_l0000Kooooo`;o0000
6?ooool00ol0003oooooooooo`02ooooo`;o00002?ooool2o`0001Oooooo0_l0000=ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool04Oooool2o`0000;ooooo0_l00003ooooo`03o`00
0?oooooooooo0;Sooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSo
oooo003oooooohSooooo003oooooohSooooo0009ooooo`03o`000?oooooooooo0?ooooooO?ooool0
00[ooooo00?o0000ooooooooool0oooooomkooooo`000oooool01Ol0003ooooooooooooooooo0000
00;ooooo00?o0000ooooooooool01Oooool01_l0003oooooo`000?oooooo0000ooooo`;o00000ooo
ool4o`000004ooooool0003o0000o`0000;ooooo0ol00003ooooo`03o`000?oooooooooo0?oooooo
F?ooool000?ooooo00Wo0000ooooooooooooooooo`000?oooooo0000ooooool000001_ooool01?l0
003oooooo`000?ooool2o`0000;ooooo00?o0000ooooool000000_ooool01?l0003oooooo`000?l0
0005ooooo`03o`000?oooooooooo0?ooooooGOooool000?ooooo00Wo0000ooooooooooooooooo`00
0?oooooo0000ooooool000001_ooool01?l0003oooooo`000?ooool2o`0000;ooooo00?o0000oooo
ool000000_ooool01?l0003oooooo`000?ooool2o`0000?ooooo00?o0000ooooooooool0oooooomM
ooooo`000oooool01?l0003oooooo`000?ooool3o`000003ooooool0003o000000Gooooo0_l00000
1?oooooo0000ooooooooool2o`0000?ooooo0ol00002ooooo`;o00001?ooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo0?ooooooF?ooool000?ooooo0_l000000ooooooo0000o`00000G
ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0oooooomMooooo`000oooool01Ol0
003ooooooooooooooooo000001Kooooo0_l00007ooooo`;o0000oooooomOooooo`00oooooon8oooo
o`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00<?ooool2o`00
00gooooo0_l0003oooooodOooooo000`ooooo`03o`000?oooooooooo00cooooo00?o0000oooooooo
ool0oooooom6ooooo`001?ooool2o`0000?ooooo0_l00004ooooo`04o`000?ooooooooooooooo`;o
00000_ooool4o`0000;ooooo0_l00003ooooo`;o00001oooool3o`0000;ooooo0ol00007ooooo`?o
00000_ooool3o`0000?ooooo0ol00002ooooo`?o00000_ooool3o`000004ooooool0003o0000o`00
0?oooooo<_ooool000?ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooo
oooo00Cooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo000000;ooooo
00?o0000ooooool000000_ooool00ol0003oooooooooo`04ooooo`06o`000?ooooooooooo`000?oo
oooo00000_ooool00ol0003oooooooooo`06ooooo`;o000000Ooooooo`000?ooooooooooo`000?oo
oooo000000;ooooo00?o0000ooooool000001?ooool2o`0000Cooooo00?o0000ooooooooool0oooo
oolaooooo`000oooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo00Cooooo00Co
0000oooooooooooo00000oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool01?ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000oooo
ooooool01?ooool2o`0000?ooooo00Co0000oooooooooooo00000_ooool01Ol0003oooooo`000?oo
oooo000000;ooooo00Co0000ooooool0003ooooo0_l00002ooooo`03o`000?oooooooooo0?oooooo
<Oooool000Cooooo0_l00004ooooo`03o`000?oooooooooo00Kooooo0_l00005ooooo`05o`000?oo
ooooooooooooool000000_ooool3o`0000Oooooo0ol00002ooooo`?o00002?ooool3o`000004oooo
ool0003o0000o`0000;ooooo0ol00003ooooo`?o00000_ooool2o`0000;ooooo00Co0000ooooool0
003o0000oooooolaooooo`000oooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000
ooooooooool01?ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000ooooool00000
0_ooool00ol0003oooooo`000009ooooo`03o`000?oooooooooo0?ooooooF_ooool000Cooooo0_l0
0003ooooo`;o00002?ooool2o`0000?ooooo0_l00003ooooo`;o00000_ooool4o`0000Kooooo00?o
0000ooooooooool0oooooomJooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
=Oooool3o`0004gooooo0ol0003oooooo`00=oooool2o`0004kooooo0_l0003nooooo`00=Oooool2
o`0004kooooo0_l0003oooooo`7ooooo000fooooo`?o0000COooool3o`000?kooooo003oooooohSo
oooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSo
oooo003oooooohSooooo001Nooooo`03o`000?oooooooooo0?oooooo9oooool001Cooooo00?o0000
ooooooooool0B?ooool00ol0003oooooooooo`1<ooooo`03o`000?oooooooooo0=Kooooo000Coooo
o`03o`000?oooooooooo04Wooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`3Eoooo
o`004oooool00ol0003oooooooooo`2Iooooo`03o`000?oooooooooo0=Gooooo000Booooo`03o`00
0?oooooooooo00;ooooo1?l000000ooooooo0000o`000002o`000003ooooool0003o000000;o0000
00?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o0000
00?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o0000
00?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o0000
00?oooooo`000?l000000_l000000ooooooo0000o`000002o`0000_ooooo1?l000000ooooooo0000
o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000
o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000
o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000
o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000
o`000002o`0000Cooooo00?o0000ooooooooool0e?ooool001?ooooo00?o0000ooooooooool0VOoo
ool00ol0003oooooooooo`3Eooooo`004oooool00ol0003oooooooooo`2Iooooo`03o`000?oooooo
oooo0=Gooooo000Dooooo`03o`000?oooooooooo09Oooooo00?o0000ooooooooool0e_ooool00?oo
ooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?oo
ooooR?ooool005Wooooo0_l0001>ooooo`;o0000g?ooool005_ooooo00?o0000ooooooooool0COoo
ool00ol0003oooooooooo`3Iooooo`006?ooool2o`0000Cooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Cooooo0_l00003ooooo`?o00001ooo
ool3o`0000;ooooo0_l0000Booooo`?o00003?ooool3o`0000?ooooo00Co0000oooooooooooooooo
0_l00003ooooo`;o00000_ooool4o`0000Cooooo00?o0000ooooooooool00_l00008ooooo`?o0000
0_ooool2o`0001;ooooo0ol0003Kooooo`005oooool01?l0003oooooooooool00009ooooo`03o`00
0?oooooooooo00;ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`00
00?ooooo00?o0000ooooooooool01oooool01?l0003oooooooooool00002ooooo`03o`000?oooooo
oooo00kooooo00Co0000oooooooooooo00003Oooool00ol0003oooooooooo`05ooooo`06o`000?oo
ooooooooo`000?oooooo00000_ooool01?l0003oooooooooool00006ooooo`03o`000?oooooo0000
00;ooooo00?o0000ooooooooool01_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooo
oooo00kooooo00Co0000oooooooooooo0000foooool001[ooooo00?o0000ooooooooool01?ooool4
o`000003ooooool0003o000000;o00000_ooool3o`000005ooooool0003oooooooooool000000ooo
ool00ol0003oooooooooo`07ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0
3_ooool01?l0003oooooooooool0000=ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooool0
00000_ooool01Ol0003ooooooooooooooooo000000;ooooo1?l000001Ooooooo0000oooooooooooo
000000Sooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?oo
ooooooooo`000=_ooooo000Iooooo`03o`000?oooooooooo00Kooooo00?o0000ooooool000000_oo
ool01Ol0003oooooo`000?oooooo000000;ooooo00?o0000ooooooooool00_l00004ooooo`03o`00
0?oooooooooo00Oooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0?ooooo`?o
00003Oooool00ol0003oooooooooo`05ooooo`?o00000_ooool01?l0003oooooooooool00004oooo
o`07o`000?ooooooooooo`000?oooooo0000ooooo`03o`0000Wooooo00Co0000oooooooooooo0000
0_ooool00ol0003oooooooooo`0?ooooo`?o0000foooool001Oooooo00Co0000oooooooooooo0000
2?ooool2o`0000?ooooo0_l000001ooooooo0000oooooooooooo0000ooooool000000_ooool01Ol0
003ooooooooooooooooo000000Wooooo00Co0000oooooooooooo00000_ooool00ol0003ooooooooo
o`0Oooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00_ooool01_l0003ooooooooo
ool0003oooooo`0000;ooooo00Co0000oooooooooooooooo0_l00002ooooo`03o`000?oooooooooo
00Sooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`3]ooooo`006?ooool2o`00
00[ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02o`0000?ooooo0_l00003oooo
o`;o00002?ooool2o`0000?ooooo0_l0000Qooooo`;o00001oooool4o`0000;ooooo0_l00003oooo
o`;o00001Oooool01Ol0003ooooooooooooooooo000000Sooooo0_l00003ooooo`;o0000l?ooool0
0?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
0?ooooooR?ooool00?ooooooR?ooool004oooooo00?o0000ooooooooool0COooool00ol0003ooooo
ooooo`3Uooooo`00Coooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0>Gooooo0019
ooooo`Co00000oooool00ol0003oooooooooo`16ooooo`Co00000oooool00ol0003oooooooooo`3T
ooooo`00D?ooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0>Cooooo001>ooooo`04
o`000?ooooooooooo`0004cooooo00Co0000oooooooooooo0000iOooool004kooooo1?l0001<oooo
o`Co0000iOooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
0?ooooooR?ooool00?ooooooR?ooool00;Sooooo0_l00003ooooo`03o`000?oooooooooo0<Oooooo
001^ooooo`03o`000?oooooooooo04Wooooo00Go0000ooooooooooooooooo`00000=ooooo`03o`00
0?oooooooooo0;Sooooo000Booooo`04o`000?ooooooooooo`0000;ooooo0ol000001?oooooo0000
o`000?l00002ooooo`;o000000Ooooooo`000?l0003oooooo`000?oooooo000000;ooooo0_l00003
ooooo`;o00000oooool4o`0000Gooooo0ol00003ooooo`?o000000Coooooo`000?l0003o00000ooo
ool3o`0000;ooooo0ol00003ooooo`;o000000Coooooo`000?l0003o00001?ooool00ol0003ooooo
ooooo`06ooooo`04o`000?ooooooooooooooo`Co00001_ooool4o`000004ooooool0003o0000o`00
00?ooooo0ol00002ooooo`?o00001oooool7o`0000?ooooo0ol00002ooooo`?o000000Goooooo`00
0?ooooooooooo`000002ooooo`?o000000Goooooo`000?ooooooooooo`000002ooooo`?o00000ooo
ool00ol0003oooooooooo`04o`0000;ooooo0ol00003ooooo`03o`000?oooooooooo0;Oooooo000B
ooooo`03o`000?oooooo000000Cooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oo
oooo000000;ooooo00Go0000ooooool0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo
00?o0000ooooool000000_ooool00ol0003oooooooooo`05ooooo`04o`000?ooooooooooooooo`;o
00001Oooool2o`000005ooooool0003oooooooooool000000oooool01Ol0003ooooooooooooooooo
000000Gooooo0_l0000<ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`02ooooo`04o`000?ooooooooooooooo`;o00000oooool2o`0000Sooooo00Co
0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000oooooooo
ooooooooo`000002ooooo`04o`000?ooooooooooo`0000?ooooo00Co0000oooooooooooo00000_oo
ool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0;Oooooo000Booooo`;o00001Oooool0
1Ol0003ooooooooooooooooo000000Cooooo0_l00002ooooo`04o`000?oooooo0000ooooo`;o0000
0_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool0
1Oooool01_l0003ooooooooooooooooo0000ooooo`;o000000?oooooo`000?l000000oooool01?l0
003oooooooooool00003ooooo`05o`000?ooooooooooooooool000000oooool2o`0000gooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00;ooooo00Ko
0000ooooooooooooooooo`000?ooool2o`000003ooooool0003ooooo00;o000000?oooooo`000?l0
00000_l000001Ooooooo0000oooooooooooo000000;ooooo00?o0000ooooooooool00_ooool00ol0
003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000ooooooooooooooooo`00
0002ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2fooooo`00
4_ooool2o`0000Cooooo0_l00002ooooo`04o`000?oooooo0000o`0000;ooooo00[o0000ooooool0
003oooooo`000?oooooo0000ooooool0003ooooo0_l00003ooooo`;o00000oooool3o`0000Kooooo
00Co0000ooooool0003o00000_ooool2o`0000?ooooo0ol000001Ooooooo0000oooooooooooo0000
00?ooooo00?o0000ooooooooool01?l00002ooooo`?o00000oooool00ol0003oooooooooo`06oooo
o`04o`000?ooooooooooooooo`Co00001_ooool4o`000003ooooool0003ooooo00;o00000_ooool2
o`0000?ooooo0_l00008ooooo`?o000000?oooooo`000?ooool00_l000001?oooooo0000o`000?l0
0003ooooo`;o00000_ooool3o`0000?ooooo0_l00002ooooo`?o00000oooool3o`0000Kooooo1?l0
0003ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0]oooool001;ooooo00?o0000
ooooool000003Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo01[ooooo00Go0000
ooooooooooooooooo`00000Cooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0;Oooooo000Booooo`04o`000?oooooo
ooooo`0000?ooooo00?o0000ooooooooool01Oooool2o`0001Cooooo0_l0000Kooooo`;o00006?oo
ool00ol0003oooooooooo`02ooooo`;o00002?ooool2o`0001Oooooo0_l0000=ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool04Oooool2o`0000;ooooo0_l00003ooooo`03o`000?oo
oooooooo0;Sooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo
003oooooohSooooo003oooooohSooooo003oooooohSooooo0003ooooo`04o`000?ooooooooooo`00
00;ooooo0ol000001?oooooo0000o`000?l00002ooooo`;o000000?oooooo`000?l000001Oooool3
o`0000Oooooo00Ko0000ooooool0003oooooo`000?ooool2o`0000?ooooo1?l000001?oooooo0000
o`000?l00002ooooo`?o00000oooool00ol0003oooooooooo`3oooooodCooooo0003ooooo`03o`00
0?oooooo000000Cooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooo000000So
oooo0_l00006ooooo`04o`000?oooooo0000ooooo`;o00000_ooool00ol0003oooooo`000002oooo
o`04o`000?oooooo0000o`0000Gooooo00?o0000ooooooooool0oooooom9ooooo`000oooool2o`00
00Gooooo00Go0000ooooooooooooooooo`000004ooooo`;o00001oooool2o`0000Sooooo00Co0000
ooooool0003ooooo0_l00002ooooo`03o`000?oooooo000000;ooooo00Co0000ooooool0003ooooo
0_l00003ooooo`03o`000?oooooooooo0?ooooooBOooool000?ooooo0_l00004ooooo`;o00000_oo
ool01?l0003oooooo`000?l00002ooooo`03o`000?oooooo000000Oooooo0ol00006ooooo`;o0000
00Coooooo`000?oooooooooo0_l00003ooooo`?o00000_ooool2o`0000Cooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`3oooooodCooooo0003ooooo`03o`000?oooooo000000gooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00Kooooo
00?o0000ooooooooool0oooooom9ooooo`000oooool01?l0003oooooooooool00003ooooo`03o`00
0?oooooooooo00Gooooo0_l00004ooooo`03o`000?oooooooooo01Oooooo0_l00007ooooo`;o0000
oooooom;ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00
oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00=Oooool3o`0004go
oooo0ol0003oooooo`00=oooool2o`0004kooooo0_l0003nooooo`00=Oooool2o`0004kooooo0_l0
003oooooo`7ooooo000fooooo`?o0000COooool3o`000?kooooo003oooooohSooooo003oooooohSo
oooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSo
oooo001Nooooo`03o`000?oooooooooo0?oooooo9oooool001Cooooo00?o0000ooooooooool0B?oo
ool00ol0003oooooooooo`1<ooooo`03o`000?oooooooooo0=Kooooo000Cooooo`03o`000?oooooo
oooo04Wooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`3Eooooo`004oooool00ol0
003oooooooooo`2Iooooo`03o`000?oooooooooo0=Gooooo000Booooo`03o`000?oooooooooo00;o
oooo1?l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l0
00000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l0
00000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l0
00000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l0
00000_l000000ooooooo0000o`000002o`0000_ooooo1?l000000ooooooo0000o`000002o`000003
ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003
ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003
ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003
ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`0000Co
oooo00?o0000ooooooooool0e?ooool001?ooooo00?o0000ooooooooool0VOooool00ol0003ooooo
ooooo`3Eooooo`004oooool00ol0003oooooooooo`2Iooooo`03o`000?oooooooooo0=Gooooo000D
ooooo`03o`000?oooooooooo09Oooooo00?o0000ooooooooool0e_ooool00?ooooooR?ooool00?oo
ooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool005Wo
oooo0_l0001>ooooo`;o0000g?ooool005_ooooo00?o0000ooooooooool0COooool00ol0003ooooo
ooooo`3Iooooo`006?ooool2o`0000Cooooo00Co0000oooooooooooooooo0_l00003ooooo`?o0000
0_ooool2o`0000?ooooo0_l00003ooooo`;o00002?ooool3o`0000;ooooo0_l0000Booooo`?o0000
2oooool4o`0000?ooooo00Co0000oooooooooooooooo0_l00002ooooo`Co00000_ooool2o`0000?o
oooo0_l00003ooooo`;o00002?ooool3o`0000;ooooo0_l0000Booooo`?o0000foooool001Oooooo
00Co0000oooooooooooo00001_ooool01?l0003oooooooooool00003ooooo`04o`000?oooooooooo
o`0000;ooooo00?o0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo
oooo00Kooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?oo
ooooooooo`0000cooooo00?o0000ooooooooool01_ooool01?l0003oooooooooool00002ooooo`05
o`000?ooooooooooooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo0000
00;ooooo00?o0000ooooooooool01_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooo
oooo00kooooo00Co0000oooooooooooo0000foooool001[ooooo00?o0000ooooooooool01?ooool0
1?l0003oooooooooool00003ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo0000
0_ooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`0000gooooo00?o0000oooooooo
ool01Oooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Kooooo00Co0000oooo
oooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`000=_ooooo000I
ooooo`03o`000?oooooooooo00Gooooo00Co0000oooooooooooo00000oooool00ol0003ooooooooo
o`03o`0000;ooooo0ol00002ooooo`?o00002Oooool01?l0003oooooooooool00002ooooo`03o`00
0?oooooooooo00oooooo0ol0000>ooooo`03o`000?oooooooooo00Cooooo00Co0000oooooooooooo
00001?ooool00ol0003oooooo`000002o`0000;ooooo0ol00002ooooo`?o00002Oooool01?l0003o
ooooooooool00002ooooo`03o`000?oooooooooo00oooooo0ol0003Kooooo`005oooool01?l0003o
ooooooooool00006ooooo`04o`000?ooooooooooo`0000?ooooo00Co0000oooooooooooo00001?oo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Sooooo00Co0000oooooooooooo0000
0_ooool00ol0003oooooooooo`0Mooooo`04o`000?ooooooooooo`0000Kooooo00Ko0000oooooooo
oooo0000ooooool00002ooooo`03o`000?oooooo000000Gooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`08ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0kOoo
ool001Sooooo0_l00008ooooo`;o00000oooool2o`0000;ooooo1?l000000ooooooo0000o`000002
o`0000?ooooo00?o0000ooooooooool01_ooool2o`0000?ooooo0_l0000Qooooo`;o00002?ooool2
o`0000?ooooo0_l00002ooooo`Co00000oooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo00Kooooo0_l00003ooooo`;o0000l?ooool00?ooooooR?ooool00?ooooooR?ooool00?oooooo
R?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool004oooooo
00?o0000ooooooooool0COooool00ol0003oooooooooo`3Uooooo`00Coooool00ol0003ooooooooo
o`1=ooooo`03o`000?oooooooooo0>Gooooo0019ooooo`Co00000oooool00ol0003oooooooooo`16
ooooo`Co00000oooool00ol0003oooooooooo`3Tooooo`00D?ooool00ol0003oooooooooo`1=oooo
o`03o`000?oooooooooo0>Cooooo001>ooooo`04o`000?ooooooooooo`0004cooooo00Co0000oooo
oooooooo0000iOooool004kooooo1?l0001<ooooo`Co0000iOooool00?ooooooR?ooool00?oooooo
R?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00;Sooooo
0_l00003ooooo`03o`000?oooooooooo0<Oooooo001^ooooo`03o`000?oooooooooo04Wooooo00Go
0000ooooooooooooooooo`00000=ooooo`03o`000?oooooooooo0;Sooooo000Booooo`04o`000?oo
ooooooooo`0000;ooooo0ol000001?oooooo0000o`000?l00002ooooo`;o000000Ooooooo`000?l0
003oooooo`000?oooooo000000;ooooo0_l00003ooooo`;o00000oooool4o`0000Gooooo0ol00003
ooooo`?o000000Coooooo`000?l0003o00000oooool3o`0000;ooooo0ol00003ooooo`;o000000Co
ooooo`000?l0003o00001?ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooooooo`Co
00001_ooool4o`000004ooooool0003o0000o`0000?ooooo0ol00002ooooo`?o00001oooool7o`00
00?ooooo0ol00002ooooo`?o000000Goooooo`000?ooooooooooo`000002ooooo`?o000000Gooooo
o`000?ooooooooooo`000002ooooo`?o00000oooool00ol0003oooooooooo`04o`0000;ooooo0ol0
0003ooooo`03o`000?oooooooooo0;Oooooo000Booooo`03o`000?oooooo000000Cooooo00Go0000
ooooooooooooooooo`000004ooooo`03o`000?oooooo000000;ooooo00Go0000ooooool0003ooooo
o`000002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool000000_ooool00ol0003ooooo
ooooo`05ooooo`04o`000?ooooooooooooooo`;o00001Oooool2o`000005ooooool0003ooooooooo
ool000000oooool01Ol0003ooooooooooooooooo000000Gooooo0_l0000<ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`02ooooo`04o`000?oooooo
ooooooooo`;o00000oooool2o`0000Sooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooo
oooooooooooo000000;ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oooooooooo
o`0000?ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo0;Oooooo000Booooo`;o00001Oooool01Ol0003ooooooooooooooooo000000Cooooo0_l0
0002ooooo`04o`000?oooooo0000ooooo`;o00000_ooool00ol0003oooooo`000002ooooo`03o`00
0?oooooo000000;ooooo00?o0000ooooooooool01Oooool01_l0003ooooooooooooooooo0000oooo
o`;o000000?oooooo`000?l000000oooool01?l0003oooooooooool00003ooooo`05o`000?oooooo
ooooooooool000000oooool2o`0000gooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo00;ooooo00Ko0000ooooooooooooooooo`000?ooool2o`000003
ooooool0003ooooo00;o000000?oooooo`000?l000000_l000001Ooooooo0000oooooooooooo0000
00;ooooo00?o0000ooooooooool00_ooool00ol0003oooooo`000003ooooo`04o`000?oooooooooo
o`0000;ooooo00Go0000ooooooooooooooooo`000002ooooo`06o`000?ooooooooooo`000?oooooo
00000_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`2fooooo`004_ooool2o`0000Cooooo0_l00002ooooo`04o`00
0?oooooo0000o`0000;ooooo00[o0000ooooool0003oooooo`000?oooooo0000ooooool0003ooooo
0_l00003ooooo`;o00000oooool3o`0000Kooooo00Co0000ooooool0003o00000_ooool2o`0000?o
oooo0ol000001Ooooooo0000oooooooooooo000000?ooooo00?o0000ooooooooool01?l00002oooo
o`?o00000oooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooooooo`Co00001_ooool4
o`000003ooooool0003ooooo00;o00000_ooool2o`0000?ooooo0_l00008ooooo`?o000000?ooooo
o`000?ooool00_l000001?oooooo0000o`000?l00003ooooo`;o00000_ooool3o`0000?ooooo0_l0
0002ooooo`?o00000oooool3o`0000Kooooo1?l00003ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool0]oooool001;ooooo00?o0000ooooool000003Oooool00ol0003oooooooooo`0C
ooooo`03o`000?oooooooooo01[ooooo00Go0000ooooooooooooooooo`00000Cooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Hooooo`03o`000?oo
oooooooo02Sooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo0;Oooooo000Booooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool01Ooo
ool2o`0001Cooooo0_l0000Kooooo`;o00006?ooool00ol0003oooooooooo`02ooooo`;o00002?oo
ool2o`0001Oooooo0_l0000=ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool04Ooo
ool2o`0000;ooooo0_l00003ooooo`03o`000?oooooooooo0;Sooooo003oooooohSooooo003ooooo
ohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo0009ooooo`03o`000?oooooo
oooo0?ooooooO?ooool000[ooooo00?o0000ooooooooool0oooooomkooooo`000oooool01Ol0003o
oooooooooooooooo000000;ooooo00?o0000ooooooooool01Oooool01_l0003oooooo`000?oooooo
0000ooooo`;o00000oooool4o`000004ooooool0003o0000o`0000;ooooo0ol00003ooooo`03o`00
0?oooooooooo0?ooooooF?ooool000?ooooo00Wo0000ooooooooooooooooo`000?oooooo0000oooo
ool000001_ooool01?l0003oooooo`000?ooool2o`0000;ooooo00?o0000ooooool000000_ooool0
1?l0003oooooo`000?l00005ooooo`03o`000?oooooooooo0?ooooooGOooool000?ooooo00Wo0000
ooooooooooooooooo`000?oooooo0000ooooool000001_ooool01?l0003oooooo`000?ooool2o`00
00;ooooo00?o0000ooooool000000_ooool01?l0003oooooo`000?ooool2o`0000?ooooo00?o0000
ooooooooool0oooooomMooooo`000oooool01?l0003oooooo`000?ooool3o`000003ooooool0003o
000000Gooooo0_l000001?oooooo0000ooooooooool2o`0000?ooooo0ol00002ooooo`;o00001?oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0?ooooooF?ooool000?ooooo0_l00000
0ooooooo0000o`00000Gooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0oooooomM
ooooo`000oooool01Ol0003ooooooooooooooooo000001Kooooo0_l00007ooooo`;o0000oooooomO
ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8
ooooo`00oooooon8ooooo`00<?ooool2o`0000gooooo0_l0003oooooodOooooo000`ooooo`03o`00
0?oooooooooo00cooooo00?o0000ooooooooool0oooooom6ooooo`001?ooool2o`0000?ooooo00?o
0000ooooooooool00oooool01?l0003oooooooooooooool2o`0000?ooooo0_l00003ooooo`;o0000
0oooool2o`0000Oooooo0ol00002ooooo`?o00001oooool3o`0000;ooooo0ol00003ooooo`?o0000
0_ooool3o`0000;ooooo0ol000001?oooooo0000o`000?l0003ooooooc;ooooo0003ooooo`04o`00
0?ooooooooooo`0000;ooooo00?o0000ooooooooool01_ooool01_l0003oooooooooool0003ooooo
o`0000;ooooo00?o0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo
oooo00Cooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooooooo00Kooooo
0_l000001ooooooo0000oooooooooooo0000ooooool000000_ooool00ol0003oooooo`000004oooo
o`;o00001?ooool00ol0003oooooooooo`3ooooooc7ooooo0003ooooo`04o`000?ooooooooooo`00
00?ooooo00?o0000ooooooooool01Oooool01?l0003oooooooooool00004ooooo`03o`000?oooooo
000000;ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`04ooooo`06o`000?oooooo
ooooo`000?oooooo00000_ooool00ol0003oooooooooo`04ooooo`;o00000oooool01?l0003ooooo
ooooool00002ooooo`05o`000?oooooo0000ooooool000000_ooool01?l0003oooooo`000?ooool2
o`0000;ooooo00?o0000ooooooooool0oooooolaooooo`000oooool3o`0000Cooooo00?o0000oooo
ooooool01Oooool01Ol0003oooooooooool0003ooooo00?o00000oooool2o`0000?ooooo0_l00007
ooooo`?o00000_ooool3o`0000Sooooo0ol000001?oooooo0000o`000?l00002ooooo`?o00000ooo
ool3o`0000;ooooo0_l00002ooooo`04o`000?oooooo0000o`000?oooooo<Oooool000Cooooo00Go
0000ooooooooooooooooo`000002ooooo`03o`000?oooooooooo00Cooooo00Ko0000oooooooooooo
0000ooooool00004ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo0?ooooooF_ooool000Gooooo00?o0000ooooooooool01?l00007
ooooo`;o00000_ooool4o`0000;ooooo0_l00003ooooo`;o00001oooool00ol0003oooooooooo`3o
oooooe[ooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003o
ooooohSooooo003oooooohSooooo003oooooohSooooo000eooooo`?o0000COooool3o`000?oooooo
000gooooo`;o0000C_ooool2o`000?kooooo000eooooo`;o0000C_ooool2o`000?oooooo0Oooool0
03Kooooo0ol0001=ooooo`?o0000o_ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?oo
ool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?oo
ool005kooooo00?o0000ooooooooool0oooooolWooooo`005?ooool00ol0003oooooooooo`18oooo
o`03o`000?oooooooooo04Oooooo00?o0000ooooooooool0foooool001?ooooo00?o0000oooooooo
ool0BOooool00ol0003oooooooooo`18ooooo`03o`000?oooooooooo0=[ooooo000Cooooo`03o`00
0?oooooooooo09Cooooo00?o0000ooooooooool0f_ooool001;ooooo00?o0000ooooooooool00_oo
ool4o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`00
0002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`00
0002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`00
0002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooooooo0000o`00
0002o`000003ooooool0003o000000;o00002oooool4o`000003ooooool0003o000000;o000000?o
ooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?o
ooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?o
ooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o000000;o000000?o
ooooo`000?l000000_l000000ooooooo0000o`000002o`0000Cooooo00?o0000ooooooooool0fOoo
ool001?ooooo00?o0000ooooooooool0U?ooool00ol0003oooooooooo`3Jooooo`004oooool00ol0
003oooooooooo`2Dooooo`03o`000?oooooooooo0=[ooooo000Dooooo`03o`000?oooooooooo09;o
oooo00?o0000ooooooooool0foooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
0?ooooooR?ooool00?ooooooR?ooool005Wooooo0_l00019ooooo`;o0000hOooool005_ooooo00?o
0000ooooooooool0B?ooool00ol0003oooooooooo`3Nooooo`006?ooool2o`0000Cooooo00Co0000
oooooooooooooooo0ol00002ooooo`;o00000oooool2o`0000?ooooo0ol00002ooooo`03o`000?oo
oooooooo00Oooooo0ol00002ooooo`;o00004_ooool3o`0000cooooo0ol00003ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool00_l00003ooooo`;o00000oooool2o`0000Sooooo0ol0
0002ooooo`;o00004_ooool3o`000>3ooooo000Gooooo`04o`000?ooooooooooo`0000Sooooo00Co
0000oooooooooooo00000_ooool00ol0003oooooo`000002ooooo`05o`000?ooooooooooooooool0
00000oooool00ol0003oooooooooo`08ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooo
ooooool03_ooool01?l0003oooooooooool0000=ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000
ooooooooool01_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00kooooo00Co
0000oooooooooooo0000h?ooool001[ooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`000004ooooo`03o`00
0?oooooooooo00Oooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0>ooooo`04
o`000?ooooooooooo`0000gooooo00?o0000ooooooooool01Oooool4o`000007ooooool0003ooooo
ooooool0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool01_oo
ool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00kooooo00Co0000oooooooooooo
0000h?ooool001Wooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00Oooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0?ooooo`?o
00003Oooool00ol0003oooooooooo`06ooooo`04o`000?oooooo0000ooooo`?o00000oooool2o`00
00;ooooo0ol00009ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool03oooool3
o`000>3ooooo000Gooooo`04o`000?ooooooooooo`0000Sooooo00Co0000oooooooooooo00000_oo
ool00ol0003oooooo`000002ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003ooooo
ooooool00008ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool07oooool00ol0
003oooooooooo`07ooooo`;o00000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000
oooooooooooo00002_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo0?;ooooo
000Hooooo`;o00002?ooool2o`0000?ooooo0_l00003ooooo`;o00000oooool2o`0000;ooooo1?l0
0007ooooo`;o00000oooool2o`00027ooooo0_l0000:ooooo`05o`000?ooooooooooooooool00000
0oooool2o`0000Cooooo00?o0000ooooooooool01_ooool2o`0000?ooooo0_l0003eooooo`00oooo
oon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooo
oon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00Coooool00ol0003oooooooooo`18ooooo`03
o`000?oooooooooo0>[ooooo001?ooooo`03o`000?oooooooooo04Sooooo00?o0000ooooooooool0
j_ooool004Wooooo1?l00003ooooo`03o`000?oooooooooo047ooooo1?l00003ooooo`03o`000?oo
oooooooo0>Wooooo001@ooooo`03o`000?oooooooooo04Sooooo00?o0000ooooooooool0jOooool0
04kooooo00Co0000oooooooooooo0000Aoooool01?l0003oooooooooool0003Zooooo`00C_ooool4
o`0004Oooooo1?l0003Zooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooo
oon8ooooo`00oooooon8ooooo`00^?ooool2o`0000?ooooo00?o0000ooooooooool0aoooool006ko
oooo00?o0000ooooooooool0BOooool01Ol0003ooooooooooooooooo000000gooooo00?o0000oooo
ooooool0^?ooool001;ooooo00Co0000oooooooooooo00000_ooool3o`000004ooooool0003o0000
o`0000;ooooo0_l000001ooooooo0000o`000?oooooo0000ooooool000000_ooool2o`0000?ooooo
0_l00003ooooo`Co00001Oooool3o`0000?ooooo0ol000001?oooooo0000o`000?l00003ooooo`?o
00000_ooool3o`0000?ooooo0_l000001?oooooo0000o`000?l00004ooooo`03o`000?oooooooooo
00Kooooo00Co0000oooooooooooooooo1?l00006ooooo`Co000000Coooooo`000?l0003o00000ooo
ool3o`0000;ooooo0ol00007ooooo`Oo00000oooool3o`0000;ooooo0ol000001Ooooooo0000oooo
oooooooo000000;ooooo0ol000001Ooooooo0000oooooooooooo000000;ooooo0ol00003ooooo`03
o`000?oooooooooo00Co00000_ooool3o`0000?ooooo00?o0000ooooooooool0]oooool001;ooooo
00?o0000ooooool000001?ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooool0
00000_ooool01Ol0003oooooo`000?oooooo000000;ooooo00?o0000ooooool000000_ooool00ol0
003oooooo`000002ooooo`03o`000?oooooooooo00Gooooo00Co0000oooooooooooooooo0_l00005
ooooo`;o000000Goooooo`000?ooooooooooo`000003ooooo`05o`000?ooooooooooooooool00000
1Oooool2o`0000cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00;ooooo00Co0000oooooooooooooooo0_l00003ooooo`;o00002?ooool01?l0003o
ooooooooool00002ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooooooo
oooo000000;ooooo00Co0000oooooooooooo00000oooool01?l0003oooooooooool00002ooooo`03
o`000?oooooo000000;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool0]oooool001;ooooo0_l00005ooooo`05o`00
0?ooooooooooooooool000001?ooool2o`0000;ooooo00Co0000ooooool0003ooooo0_l00002oooo
o`03o`000?oooooo000000;ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`05oooo
o`06o`000?ooooooooooooooool0003ooooo0_l000000ooooooo0000o`000003ooooo`04o`000?oo
ooooooooo`0000?ooooo00Go0000ooooooooooooooooo`000003ooooo`;o00003Oooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00_ooool01_l0003o
oooooooooooooooo0000ooooo`;o000000?oooooo`000?ooool00_l000000ooooooo0000o`000002
o`000005ooooool0003oooooooooool000000_ooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooo000000?ooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo000000;o
oooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo0;Kooooo000Boooo
o`;o00001?ooool2o`0000;ooooo00Co0000ooooool0003o00000_ooool02_l0003oooooo`000?oo
oooo0000ooooool0003oooooo`000?ooool2o`0000?ooooo0_l00003ooooo`?o00001_ooool01?l0
003oooooo`000?l00002ooooo`;o00000oooool3o`000005ooooool0003oooooooooool000000ooo
ool00ol0003oooooooooo`04o`0000;ooooo0ol00003ooooo`03o`000?oooooooooo00Kooooo00Co
0000oooooooooooooooo1?l00006ooooo`Co000000?oooooo`000?ooool00_l00002ooooo`;o0000
0oooool2o`0000Sooooo0ol000000ooooooo0000ooooo`02o`000004ooooool0003o0000o`0000?o
oooo0_l00002ooooo`?o00000oooool2o`0000;ooooo0ol00003ooooo`?o00001_ooool4o`0000?o
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2gooooo`004_ooool00ol0003ooooo
o`00000=ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool06_ooool01Ol0003ooooo
oooooooooooo000001?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo01Sooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool0]oooool001;ooooo00Co0000oooooooooooo
00000oooool00ol0003oooooooooo`05ooooo`;o00005?ooool2o`0001_ooooo0_l0000Hooooo`03
o`000?oooooooooo00;ooooo0_l00008ooooo`;o00005oooool2o`0000gooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`0Aooooo`;o00000_ooool2o`0000?ooooo00?o0000oooooooo
ool0^?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?oo
ooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool000?ooooo00Co0000oooo
oooooooo00000_ooool3o`000004ooooool0003o0000o`0000;ooooo0_l000000ooooooo0000o`00
0005ooooo`?o00001oooool01_l0003oooooo`000?oooooo0000ooooo`;o00000oooool4o`000004
ooooool0003o0000o`0000;ooooo0ol00003ooooo`03o`000?oooooooooo0?ooooooA?ooool000?o
oooo00?o0000ooooool000001?ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000oooo
ool000002?ooool2o`0000Kooooo00Co0000ooooool0003ooooo0_l00002ooooo`03o`000?oooooo
000000;ooooo00Co0000ooooool0003o00001Oooool00ol0003oooooooooo`3oooooodWooooo0003
ooooo`;o00001Oooool01Ol0003ooooooooooooooooo000000Cooooo0_l00007ooooo`;o00002?oo
ool01?l0003oooooo`000?ooool2o`0000;ooooo00?o0000ooooool000000_ooool01?l0003ooooo
o`000?ooool2o`0000?ooooo00?o0000ooooooooool0oooooom9ooooo`000oooool2o`0000Cooooo
0_l00002ooooo`04o`000?oooooo0000o`0000;ooooo00?o0000ooooool000001oooool3o`0000Ko
oooo0_l000001?oooooo0000ooooooooool2o`0000?ooooo0ol00002ooooo`;o00001?ooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo0?ooooooA?ooool000?ooooo00?o0000ooooool0
00003Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo01Sooooo00?o0000oooooooo
ool01_ooool00ol0003oooooooooo`3oooooodWooooo0003ooooo`04o`000?ooooooooooo`0000?o
oooo00?o0000ooooooooool01Oooool2o`0000Cooooo00?o0000ooooooooool05oooool2o`0000Oo
oooo0_l0003ooooood_ooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003ooooo
ohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo000eooooo`?o0000COooool3
o`000?oooooo000gooooo`;o0000C_ooool2o`000?kooooo000eooooo`;o0000C_ooool2o`000?oo
oooo0Oooool003Kooooo0ol0001=ooooo`?o0000o_ooool00?ooooooR?ooool00?ooooooR?ooool0
0?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool0
0?ooooooR?ooool005kooooo00?o0000ooooooooool0oooooolWooooo`005?ooool00ol0003ooooo
ooooo`18ooooo`03o`000?oooooooooo04cooooo00?o0000ooooooooool0e_ooool001?ooooo00?o
0000ooooooooool0BOooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo0=Gooooo000C
ooooo`03o`000?oooooooooo09Wooooo00?o0000ooooooooool0eOooool001;ooooo00?o0000oooo
ooooool00_ooool4o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooo
oooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooo
oooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooo
oooo0000o`000002o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l000000ooo
oooo0000o`000002o`000003ooooool0003o000000;o00002oooool4o`000003ooooool0003o0000
00;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o0000
00;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o0000
00;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o0000
00;o000000?oooooo`000?l000000_l000000ooooooo0000o`000002o`000003ooooool0003o0000
00;o00001?ooool00ol0003oooooooooo`3Dooooo`004oooool00ol0003oooooooooo`2Iooooo`03
o`000?oooooooooo0=Gooooo000Cooooo`03o`000?oooooooooo09Wooooo00?o0000ooooooooool0
eOooool001Cooooo00?o0000ooooooooool0Uoooool00ol0003oooooooooo`3Fooooo`00oooooon8
ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00FOooool2
o`0004kooooo0_l0003Looooo`00Foooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo
0=Wooooo000Gooooo`Co00000oooool01?l0003oooooooooooooool2o`0000?ooooo0_l00003oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool2o`0000Sooooo0ol00002oooo
o`;o00004_ooool3o`0000cooooo0ol00003ooooo`04o`000?ooooooooooooooo`;o00000oooool0
0ol0003oooooooooo`02ooooo`;o00000oooool2o`0000?ooooo0ol00007ooooo`?o00000_ooool2
o`0001;ooooo0ol0003Kooooo`006?ooool00ol0003oooooooooo`06ooooo`06o`000?oooooooooo
o`000?oooooo00000_ooool01?l0003oooooooooool00005ooooo`04o`000?ooooooooooo`0000;o
oooo00?o0000ooooooooool01_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo
00kooooo00Co0000oooooooooooo00003Oooool00ol0003oooooooooo`05ooooo`04o`000?oooooo
ooooo`0000;ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo000000;ooooo
00Go0000ooooooooooooooooo`000009ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooo
ooooool03_ooool01?l0003oooooooooool0003Kooooo`006Oooool00ol0003oooooooooo`05oooo
o`06o`000?ooooooooooo`000?oooooo00000_ooool01Ol0003ooooooooooooooooo000000?ooooo
0ol000001Ooooooo0000oooooooooooo000000Sooooo00Co0000oooooooooooo00000_ooool00ol0
003oooooooooo`0>ooooo`04o`000?ooooooooooo`0000gooooo00?o0000ooooooooool01Oooool0
1?l0003oooooooooool00003ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_oo
ool01Ol0003ooooooooooooooooo000000Wooooo00Co0000oooooooooooo00000_ooool00ol0003o
ooooooooo`0>ooooo`04o`000?ooooooooooo`000=_ooooo000Jooooo`03o`000?oooooooooo00Go
oooo0_l00003ooooo`;o00001?ooool01?l0003oooooooooool00002ooooo`03o`000?oooooo0000
00;o00002Oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00oooooo0ol0000=
ooooo`03o`000?oooooooooo00Kooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Oooooo00Co0000
oooooooooooo00000_ooool00ol0003oooooooooo`0?ooooo`?o0000foooool001Oooooo00Co0000
oooooooooooo00001_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000ooooool0
00000_ooool00ol0003oooooo`000002ooooo`04o`000?ooooooooooo`0000[ooooo00Co0000oooo
oooooooo00000_ooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00Gooooo00Ko0000
oooooooooooo0000ooooool00002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool00000
0_ooool01Ol0003ooooooooooooooooo000000Wooooo00Co0000oooooooooooo00000_ooool00ol0
003oooooooooo`3]ooooo`006?ooool2o`0000Sooooo0_l00003ooooo`;o00000_ooool4o`0000;o
oooo0_l00004ooooo`03o`000?oooooooooo00Kooooo0_l00003ooooo`;o00008Oooool2o`0000So
oooo0_l00002ooooo`Co00000_ooool2o`0000?ooooo0_l00003ooooo`;o00002?ooool2o`0000?o
oooo0_l0003`ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8oooo
o`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00Coooool00ol0
003oooooooooo`1=ooooo`03o`000?oooooooooo0>Gooooo001?ooooo`03o`000?oooooooooo04go
oooo00?o0000ooooooooool0iOooool004Wooooo1?l00003ooooo`03o`000?oooooooooo04Kooooo
1?l00003ooooo`03o`000?oooooooooo0>Cooooo001@ooooo`03o`000?oooooooooo04gooooo00?o
0000ooooooooool0i?ooool004kooooo00Co0000oooooooooooo0000C?ooool01?l0003ooooooooo
ool0003Uooooo`00C_ooool4o`0004cooooo1?l0003Uooooo`00oooooon8ooooo`00oooooon8oooo
o`00oooooon8ooooo`00oooooon8ooooo`00oooooon8ooooo`00^?ooool2o`0000?ooooo00?o0000
ooooooooool0aoooool006kooooo00?o0000ooooooooool0BOooool01Ol0003ooooooooooooooooo
000000gooooo00?o0000ooooooooool0^?ooool001;ooooo00Co0000oooooooooooo00000_ooool3
o`000004ooooool0003o0000o`0000;ooooo0_l000001ooooooo0000o`000?oooooo0000ooooool0
00000_ooool2o`0000?ooooo0_l00003ooooo`Co00001Oooool3o`0000?ooooo0ol000001?oooooo
0000o`000?l00003ooooo`?o00000_ooool3o`0000?ooooo0_l000001?oooooo0000o`000?l00004
ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooooooo1?l00006ooooo`Co000000Co
ooooo`000?l0003o00000oooool3o`0000;ooooo0ol00007ooooo`Oo00000oooool3o`0000;ooooo
0ol000001Ooooooo0000oooooooooooo000000;ooooo0ol000001Ooooooo0000oooooooooooo0000
00;ooooo0ol00003ooooo`03o`000?oooooooooo00Co00000_ooool3o`0000?ooooo00?o0000oooo
ooooool0]oooool001;ooooo00?o0000ooooool000001?ooool01Ol0003ooooooooooooooooo0000
00Cooooo00?o0000ooooool000000_ooool01Ol0003oooooo`000?oooooo000000;ooooo00?o0000
ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Gooooo00Co0000
oooooooooooooooo0_l00005ooooo`;o000000Goooooo`000?ooooooooooo`000003ooooo`05o`00
0?ooooooooooooooool000001Oooool2o`0000cooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooooooo0_l00003oooo
o`;o00002?ooool01?l0003oooooooooool00002ooooo`05o`000?ooooooooooooooool000000_oo
ool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo00000oooool01?l0003o
ooooooooool00002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0]oooool001;o
oooo0_l00005ooooo`05o`000?ooooooooooooooool000001?ooool2o`0000;ooooo00Co0000oooo
ool0003ooooo0_l00002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool000000_ooool0
0ol0003oooooooooo`05ooooo`06o`000?ooooooooooooooool0003ooooo0_l000000ooooooo0000
o`000003ooooo`04o`000?ooooooooooo`0000?ooooo00Go0000ooooooooooooooooo`000003oooo
o`;o00003Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool00_ooool01_l0003ooooooooooooooooo0000ooooo`;o000000?oooooo`000?ooool00_l0
00000ooooooo0000o`000002o`000005ooooool0003oooooooooool000000_ooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooo000000?ooooo00Co0000oooooooooooo00000_ooool01Ol0003o
oooooooooooooooo000000;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo0;Kooooo000Booooo`;o00001?ooool2o`0000;ooooo00Co0000ooooool0003o00000_oo
ool02_l0003oooooo`000?oooooo0000ooooool0003oooooo`000?ooool2o`0000?ooooo0_l00003
ooooo`?o00001_ooool01?l0003oooooo`000?l00002ooooo`;o00000oooool3o`000005ooooool0
003oooooooooool000000oooool00ol0003oooooooooo`04o`0000;ooooo0ol00003ooooo`03o`00
0?oooooooooo00Kooooo00Co0000oooooooooooooooo1?l00006ooooo`Co000000?oooooo`000?oo
ool00_l00002ooooo`;o00000oooool2o`0000Sooooo0ol000000ooooooo0000ooooo`02o`000004
ooooool0003o0000o`0000?ooooo0_l00002ooooo`?o00000oooool2o`0000;ooooo0ol00003oooo
o`?o00001_ooool4o`0000?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2goooo
o`004_ooool00ol0003oooooo`00000=ooooo`03o`000?oooooooooo01?ooooo00?o0000oooooooo
ool06_ooool01Ol0003ooooooooooooooooo000001?ooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool0:?ooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0]oooool001;o
oooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`05ooooo`;o00005?ooool2o`00
01_ooooo0_l0000Hooooo`03o`000?oooooooooo00;ooooo0_l00008ooooo`;o00005oooool2o`00
00gooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Aooooo`;o00000_ooool2o`00
00?ooooo00?o0000ooooooooool0^?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?oo
ool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool000Wooooo00?o0000ooooooooool0
oooooomlooooo`002_ooool00ol0003oooooooooo`3oooooog_ooooo0003ooooo`05o`000?oooooo
ooooooooool000000_ooool00ol0003oooooooooo`05ooooo`06o`000?oooooo0000ooooool0003o
oooo0_l00003ooooo`Co000000Coooooo`000?l0003o00000_ooool3o`0000?ooooo00?o0000oooo
ooooool0oooooomHooooo`000oooool02Ol0003ooooooooooooooooo0000ooooool0003oooooo`00
0006ooooo`04o`000?oooooo0000ooooo`;o00000_ooool00ol0003oooooo`000002ooooo`04o`00
0?oooooo0000o`0000Gooooo00?o0000ooooooooool0oooooomMooooo`000oooool02Ol0003ooooo
oooooooooooo0000ooooool0003oooooo`000006ooooo`04o`000?oooooo0000ooooo`;o00000_oo
ool00ol0003oooooo`000002ooooo`04o`000?oooooo0000ooooo`;o00000oooool00ol0003ooooo
ooooo`3ooooooegooooo0003ooooo`04o`000?oooooo0000ooooo`?o000000?oooooo`000?l00000
1Oooool2o`000004ooooool0003oooooooooo`;o00000oooool3o`0000;ooooo0_l00004ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool0oooooomHooooo`000oooool2o`000003oooo
ool0003o000001Oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`3ooooooegooooo
0003ooooo`05o`000?ooooooooooooooool000005_ooool2o`0000Oooooo0_l0003ooooooeoooooo
003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo003oooooohSooooo
000`ooooo`;o00003Oooool2o`000?ooooooAoooool0033ooooo00?o0000ooooooooool03?ooool0
0ol0003oooooooooo`3oooooodKooooo0004ooooo`;o00000oooool2o`0000Cooooo00?o0000oooo
ooooool01?l00002ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00ol00006oooo
o`?o00000_ooool3o`0000Oooooo0ol00002ooooo`?o00000oooool3o`0000;ooooo0ol00002oooo
o`?o000000Coooooo`000?l0003o0000oooooolbooooo`000oooool01_l0003oooooooooool0003o
ooooo`0000;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00?ooooo00Go0000ooooooooooooooooo`000007ooooo`06o`000?ooooooooooo`000?oo
oooo00000_ooool00ol0003oooooooooo`06ooooo`;o000000Ooooooo`000?ooooooooooo`000?oo
oooo000000;ooooo00?o0000ooooool000001?ooool2o`0000Cooooo00?o0000ooooooooool0oooo
oolaooooo`001_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Kooooo00Co0000
oooooooooooooooo0ol000000ooooooo0000o`000002o`0000?ooooo00?o0000ooooooooool01Ooo
ool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000ooooooooool01?ooool2o`0000?o
oooo00Co0000oooooooooooo00000_ooool01Ol0003oooooo`000?oooooo000000;ooooo00Co0000
ooooool0003ooooo0_l00002ooooo`03o`000?oooooooooo0?oooooo<Oooool000?ooooo0ol00002
ooooo`04o`000?ooooooooooo`0000Wooooo00?o0000ooooool000000_ooool01_l0003ooooooooo
ool0003oooooo`0000?ooooo00?o0000ooooooooool01Oooool3o`0000;ooooo0ol00008ooooo`?o
000000Coooooo`000?l0003o00000_ooool3o`0000?ooooo0ol00002ooooo`;o00000_ooool01?l0
003oooooo`000?l0003ooooooc7ooooo0003ooooo`03o`000?oooooooooo00;ooooo00Co0000oooo
oooooooo00001_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00Co0000oooooooooooo
oooo0_l00003ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0oooooomJooooo`00
0oooool4o`0000;ooooo0_l00008ooooo`;o00000oooool2o`0000Gooooo00?o0000ooooooooool0
0_l00007ooooo`03o`000?oooooooooo0?ooooooF_ooool00?ooooooR?ooool00?ooooooR?ooool0
0?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00?ooooooR?ooool00001\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
MatrixForm[Transpose[{N[nbasepairs,3],N[f1robert,4],N[f1Kirk,4]}]]\
\
\>", "Input",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!PS-Adobe-2.0 EPSF-1.2
%%BoundingBox: 6 6 336 344
%%HiResBoundingBox: 6 6 336 343.5
%%Creator: (Mathematica 5.2 for Macintosh)
%%CreationDate: (Monday, March 30, 2020) (20:39:57)
%%Title: Clipboard
%%DocumentNeededResources: (atend)
%%DocumentFonts: (atend)
%%DocumentNeededFonts: (atend)
%%EndComments
0 349.5 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def

%%MathematicaCell
%Cell[GraphicsData[\"PICT\", \\
%\"\\<\\
%24X04`0X0?@1100A0_l<0?ooool0:00001<\\
%000440000m0000000000N00402P0C
%02P0m09@02`02P0F1d=_MG9YIG800`0F00d02@0^00@0000002/Y6bPP820P820P
%820P820P820P820P820P82dg820P820P820P820P82dg000Z1BXP820P820P820P
%820P820a;SPg<b0a<20P86LP820a;S@f>B0a<20P86L0:PDZ820P820P820P820P
%820P;Bd];Bd];Bd];Bd]820P;Bd];Bd];Bd];Bd]02T2:R0P820P820P820P820P
%82d];Bd];Bd];Bd]820P82d];Bd];Bd];Bd]800X02X0:B@e<2hc820P820P820P
%820P820P87<P820P820P820P820P87<002X::20P820P820P820P820P820P820P
%820P;CLP820P820P820P820P;CL0:PDZ820P820P820P820P820P<Rh`<SHP<C0P
%821W820P<Bhe<38P<C0P821W02X5:R0P820P820P820P820P82d];Bd];Bd];Bd]
%;B0P82d];Bd];Bd];Bd];@0Y0RXP820P820P820P820P820];Bd];Bd];Bd];B0P
%820];Bd];Bd];Bd];B00:01302TT=SL^<B0P820P820P820P820P821c820P820P
%820P820P821c000Z2RPP820P820P820P820P820P820P820P82dg820P820P820P
%820P82dg02X5:R0P820P820P820P820P838^<CHi834`820PIb0P834^=C@d834`
%820PI`0Z1BXP820P820P820P820P820];Bd];Bd];Bd];BdP820];Bd];Bd];Bd]
%;Bd0:@8Z820P820P820P820P820P;Bd];Bd];Bd];BdP820P;Bd];Bd];Bd];BdP
%02P0G00Y93Pc;SPP820P820P820P820P820PLb0P820P820P820P820PL`00:PXW
%820P820P820P820P820P820P820P820]=b0P820P820P820P82dg000Z1BTP820P
%820P820P820P820b;S<`=B0a<20P86LP820a;SDi834`820PI`00:PDY820P820P
%820P820P820P;Bd];Bd];Bd];Bd]820P;Bd];Bd];Bd];Bd002T2:B0P820P820P
%820P820P82d];Bd];Bd];Bd]820P82d];Bd];Bd];BdP000X07D0:B@a<34^820P
%820P820P820P820P87<P820P820P820P820P87<002X::20P820P820P820P820P
%820P820P820P;CLP820P820P820P820P;CL0:PDZ820P820P820P820P820P<Rhe
%=S8P<C0P821W820P<Bhf>C8P<C0P821W02X5:R0P820P820P820P820P82d];Bd]
%;Bd];Bd];B0P82d];Bd];Bd];Bd];@0Y0RXP820P820P820P820P820];Bd];Bd]
%;Bd];B0P820];Bd];Bd];Bd];B00:02>02TT<C<d;R0P820P820P820P820P821c
%820P820P820P820P821c000Z2RPP820P820P820P820P820P820P820P82dg820P
%820P820P820P82dg02X5:R0P820P820P820P820P838^>30c834`820PIb0P834^
%>30a834`820PI`0Z1BXP820P820P820P820P820];Bd];Bd];Bd];BdP820];Bd]
%;Bd];Bd];Bd0:@8Z820P820P820P820P820P;Bd];Bd];Bd];BdP820P;Bd];Bd]
%;Bd];BdP02P0Y`0Y934f>2hP820P820P820P820P820PLb0P820P820P820P820P
%L`00:PXX820P820P820P820P820P820P820P820]=b0P820P820P820P820]=`0Z
%1BXP820P820P820P820P820c;S0c<b0a<20P86LP820a;STa<R0a<20P86L0:PDZ
%820P820P820P820P820P;Bd];Bd];Bd];Bd]820P;Bd];Bd];Bd];Bd]02T2:R0P
%820P820P820P820P82d];Bd];Bd];Bd]820P82d];Bd];Bd];Bd]800X0<00:B@b
%<34^820P820P820P820P820P87<P820P820P820P820P87<002X::20P820P820P
%820P820P820P820P820P;CLP820P820P820P820P;CL0:PDZ820P820P820P820P
%820P<bhb=C@P<C0P821W820P<Rh`<SHP<C0P821W02X5:R0P820P820P820P820P
%82d];Bd];Bd];Bd];B0P82d];Bd];Bd];Bd];@0Y0RXP820P820P820P820P820]
%;Bd];Bd];Bd];B0P820];Bd];Bd];Bd];B00:03I02TT<S<e;R0P820P820P820P
%820P821c820P820P820P820P821c000Z2RLP820P820P820P820P820P820P820P
%82dg820P820P820P820P;CL002X5:B0P820P820P820P820P83<^=3Hi834`820P
%Ib0P838^<C@P<C0P821W000Z1BTP820P820P820P820P820];Bd];Bd];Bd];BdP
%820];Bd];Bd];Bd];@00:@8Y820P820P820P820P820P;Bd];Bd];Bd];BdP820P
%;Bd];Bd];Bd];B0002P0lP0Y938f>2hP820P820P820P820P820PLb0P820P820P
%820P820PL`00o`\\>\"], \"Graphics\",
%  ImageSize->{220, 225},
%  ImageMargins->{{0, Inherited}, {Inherited, Inherited}},
%  ImageRegion->{{-0, 1}, {0, 1}},
%  FontSize->9]
%%EndMathematicaCell
1.5 setlinewidth
/Courier findfont 9 scalefont setfont
8 18 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
8 26 moveto (               1.873 10   g   1.469 10   g) show
/Courier findfont 9 scalefont setfont
8 33 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
11 33 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
8 41 moveto (50.3                s              s) show
/Courier findfont 9 scalefont setfont
8 56 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
8 63 moveto (               2.026 10   g   1.502 10   g) show
/Courier findfont 9 scalefont setfont
8 71 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
11 71 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
8 78 moveto (67.1                s              s) show
/Courier findfont 9 scalefont setfont
8 93 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
8 101 moveto (               2.169 10   g   1.544 10   g) show
/Courier findfont 9 scalefont setfont
8 108 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
11 108 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
8 116 moveto (83.8                s              s) show
/Courier findfont 9 scalefont setfont
8 131 moveto (                       -7            -7) show
/Courier findfont 9 scalefont setfont
8 138 moveto (               2.305 10   g   1.59 10   g) show
/Courier findfont 9 scalefont setfont
8 146 moveto (               ------------   -----------) show
/Courier findfont 9 scalefont setfont
11 146 moveto (               -----------    ---------- ) show
/Courier findfont 9 scalefont setfont
8 153 moveto (101.                s              s) show
/Courier findfont 9 scalefont setfont
8 168 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
8 175 moveto (               2.562 10   g   1.692 10   g) show
/Courier findfont 9 scalefont setfont
8 183 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
11 183 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
8 190 moveto (134.                s              s) show
/Courier findfont 9 scalefont setfont
8 205 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
8 213 moveto (               2.803 10   g   1.801 10   g) show
/Courier findfont 9 scalefont setfont
8 220 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
11 220 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
8 228 moveto (168.                s              s) show
/Courier findfont 9 scalefont setfont
8 243 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
8 250 moveto (               3.033 10   g   1.912 10   g) show
/Courier findfont 9 scalefont setfont
8 258 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
11 258 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
8 265 moveto (201.                s              s) show
/Courier findfont 9 scalefont setfont
8 280 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
8 288 moveto (               3.254 10   g   2.026 10   g) show
/Courier findfont 9 scalefont setfont
8 295 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
11 295 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
8 303 moveto (235.                s              s) show
/Courier findfont 9 scalefont setfont
8 318 moveto (                       -7            -7) show
/Courier findfont 9 scalefont setfont
8 325 moveto (               3.469 10   g   2.14 10   g) show
/Courier findfont 9 scalefont setfont
8 333 moveto (               ------------   -----------) show
/Courier findfont 9 scalefont setfont
11 333 moveto (               -----------    ---------- ) show
/Courier findfont 9 scalefont setfont
8 340 moveto (268.                s              s) show
%%Trailer
%%EOF
\
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{330, 337.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  FontSize->9,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007_0001nR000`400?l00000o`00003oooooooo`
ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`001?ooool6
o`0000Cooooo0_l00005ooooo`Co00001Oooool00ol0003oooooooooo`23ooooo`Go0000Loooool5
o`000<kooooo0004ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`000002
ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`28ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool0L?ooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo0<_ooooo0005ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool0
1?l0003oooooooooool00004ooooo`03o`000?oooooooooo08gooooo00?o0000ooooooooool0MOoo
ool00ol0003oooooooooo`3;ooooo`001_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00;ooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`29ooooo`Co0000M?oo
ool4o`000<kooooo0007ooooo`03o`000?oooooooooo00;ooooo0_l00002ooooo`03o`000?oooooo
oooo00;ooooo1?l0002;ooooo`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0d?ooool0
00Sooooo00Ko0000ooooooooooooooooo`000?ooool2o`0000Cooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`28ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0L?oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0<_ooooo0009ooooo`04o`000?oooooo
ooooo`0000Oooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`29ooooo`Go0000Looo
ool5o`000<gooooo0004ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`00
0006ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0oooooooDooooo`001Oooool4
o`0000Gooooo0_l00005ooooo`Co0000oooooooGooooo`00ooooooo`ooooo`00ooooooo`ooooo`00
ooooooo`ooooo`00ooooooo`ooooo`00NooooomOo`0001WoooooEol0002Uooooo`00ooooooo`oooo
o`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00eOooool3o`00
06gooooo0ol0002Wooooo`00f?ooool00ol0003oooooooooo`1]ooooo`03o`000?oooooooooo0:Co
oooo003Iooooo`03o`000?oooooooooo06gooooo00?o0000ooooooooool0Xoooool007gooooo1?l0
0005ooooo`03o`000?oooooooooo00Gooooo1?l00004ooooo`;o00001_ooool2o`0000cooooo1Ol0
0004ooooo`?o00007Oooool3o`000003ooooool0003ooooo01Wooooo1_l00004ooooo`03o`000?oo
oooooooo00?ooooo1Ol00005ooooo`Co00002_ooool5o`0000Cooooo0ol0000Mooooo`?o000000?o
ooooo`000?ooool0Y?ooool007cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0<
ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00001oooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000Kooooo`04o`00
0?ooooooooooooooo`;o00006_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00?o
oooo00Go0000ooooooooooooooooo`00000Kooooo`04o`000?ooooooooooooooo`;o0000YOooool0
087ooooo00?o0000ooooooooool03?ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00?ooooo00Go0000
ooooooooooooooooo`00000Jooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool06Ooo
ool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02ooo
ool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006_ooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo0:?ooooo0021ooooo`03o`000?oooooooooo00Sooooo1_l0
0002ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool2o`000003ooooool0
003ooooo00_ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000001[ooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo00gooooo
00?o0000ooooooooool00oooool6o`0000cooooo00?o0000ooooooooool00oooool01Ol0003ooooo
oooooooooooo000001[ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2Sooooo`00
O_ooool3o`0000_ooooo00Go0000ooooooooooooooooo`000003ooooo`;o00000_ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo00;o00003?ooool00ol0003oooooooooo`03ooooo`05
o`000?ooooooooooooooool000006_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
01_ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`03ooooo`05o`000?oooooooooo
ooooool000003Oooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006_oo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo0:?ooooo0021ooooo`03o`000?oooooo
oooo00Wooooo00Co0000oooooooooooo00000oooool01?l0003oooooo`000?l00004ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`03ooooo`05o`00
0?ooooooooooooooool000006oooool01?l0003oooooooooooooool2o`0001kooooo00?o0000oooo
ooooool02oooool00ol0003oooooooooo`04ooooo`04o`000?ooooooooooo`0000gooooo00?o0000
ooooooooool00oooool01Ol0003ooooooooooooooooo000001_ooooo00Co0000oooooooooooooooo
0_l0002Uooooo`00POooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo000000?ooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooool000001Oooool01Ol0003ooooooooooooooooo000001cooooo0ol000000ooooooo0000
ooooo`0Nooooo`03o`000?oooooooooo00Sooooo00?o0000ooooool000001oooool00ol0003ooooo
o`00000;ooooo`03o`000?oooooo000000Gooooo00Go0000ooooooooooooooooo`00000Looooo`?o
000000?oooooo`000?ooool0Y?ooool007cooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`0;ooooo`;o00001?ooool00ol0003oooooooooo`05ooooo`04o`000?ooooooooooo`0000co
oooo0_l00005ooooo`05o`000?ooooooooooooooool00000>oooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo00Wooooo0_l00008ooooo`;o00003?ooool2o`0000Gooooo00Go0000oooo
ooooooooooooo`000036ooooo`00OOooool4o`0000oooooo00?o0000ooooooooool00oooool2o`00
00Kooooo0_l0000>ooooo`03o`000?oooooooooo00Cooooo0ol0000mooooo`Co00003Oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool01?ooool3o`00
0<Oooooo003ooooooo3ooooo003ooooooo3ooooo0036ooooo`03o`000?oooooooooo06gooooo00?o
0000ooooooooool0]_ooool00<Kooooo00?o0000ooooooooool0KOooool00ol0003oooooooooo`2f
ooooo`00aoooool00ol0003oooooooooo`1]ooooo`03o`000?oooooooooo0;Gooooo002kooooo`Oo
00001Oooool00ol0003oooooooooo`1Qooooo`Oo00001Oooool00ol0003oooooooooo`2eooooo`00
b?ooool00ol0003oooooooooo`1]ooooo`03o`000?oooooooooo0;Cooooo0038ooooo`03o`000?oo
oooooooo06gooooo00?o0000ooooooooool0]?ooool00<Wooooo00?o0000ooooooooool0KOooool0
0ol0003oooooooooo`2cooooo`00a?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
06Sooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2cooooo`00a?ooool6o`0006[o
oooo1_l0002eooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`oooo
o`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`oooo
o`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`001?ooool6o`00
00?ooooo1?l00004ooooo`?o00001_ooool00ol0003oooooooooo`23ooooo`Go0000Loooool5o`00
0<kooooo0004ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00001?ooool01?l0
003oooooooooool00003ooooo`03o`000?oooooooooo08Wooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`1`ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0boooool0
00Gooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
08gooooo00?o0000ooooooooool0MOooool00ol0003oooooooooo`3;ooooo`001_ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0ROooool4o`0007Co
oooo1?l0003>ooooo`001oooool00ol0003oooooooooo`04ooooo`?o00001oooool00ol0003ooooo
ooooo`29ooooo`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0d?ooool000Sooooo00?o
0000ooooooooool01_ooool00ol0003oooooooooo`04o`0008cooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`1`ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0booo
ool000Wooooo00?o0000ooooooooool01Oooool01?l0003oooooooooool0002@ooooo`Go0000Looo
ool5o`000<gooooo0004ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00001?oo
ool01?l0003oooooooooool0003oooooom_ooooo0005ooooo`Co00001?ooool4o`0000?ooooo1_l0
003oooooomKooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo
003ooooooo3ooooo003ooooooo3ooooo001koooooeoo00006OoooomOo`0009gooooo003ooooooo3o
oooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003Eooooo`?o0000MOooool3o`00
09oooooo003Hooooo`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0W?ooool00=Wooooo
00?o0000ooooooooool0MOooool00ol0003oooooooooo`2Kooooo`00OOooool4o`0000Gooooo00?o
0000ooooooooool00oooool6o`0000?ooooo0ol00006ooooo`Co00002_ooool5o`0000Cooooo0ol0
000Mooooo`?o000000?oooooo`000?ooool06Oooool6o`0000Cooooo00?o0000ooooooooool01?oo
ool3o`0000Cooooo1_l00004ooooo`;o00003?ooool5o`0000Cooooo0ol0000Mooooo`?o000000?o
ooooo`000?ooool0W?ooool007cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000oooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooo
oooooooo000001_ooooo00Co0000oooooooooooooooo0_l0000Jooooo`03o`000?oooooooooo00;o
oooo00?o0000ooooooooool02?ooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000oooo
ooooool00_ooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool02oooool0
0ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006oooool01?l0003ooooooooo
ooooool2o`0009gooooo0021ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool00ooo
ool01Ol0003ooooooooooooooooo000001[ooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`0Iooooo`03o`000?oooooooooo00cooooo00Go0000ooooooooooooooooo`000004ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000Jooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool0Voooool0087ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Ko00003?ooool00ol0003oooooooooo`03ooooo`05
o`000?ooooooooooooooool000006_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
01[ooooo00?o0000ooooooooool02oooool01Ol0003ooooooooooooooooo000000Gooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool00oooool01Ol0003ooooooooooooooooo000001[ooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`2Kooooo`00O_ooool3o`0000kooooo00?o0000ooooooooool01_ooool0
1Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooooooool02oooool00ol0003ooooooooo
o`03ooooo`05o`000?ooooooooooooooool000006_ooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo01_ooooo00?o0000ooooooooool02_ooool01Ol0003ooooooooooooooooo000000Ko
oooo00?o0000ooooooooool00_ooool2o`0000;ooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`03ooooo`05o`000?ooooooooooooooool000006_ooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo09_ooooo0021ooooo`03o`000?oooooooooo00cooooo00Co0000oooooooo
oooooooo1?l00005ooooo`04o`000?ooooooooooo`0000gooooo00?o0000ooooooooool00oooool0
1Ol0003ooooooooooooooooo000001_ooooo00Co0000oooooooooooooooo0_l0000Nooooo`03o`00
0?oooooooooo00Wooooo00Go0000ooooooooooooooooo`000007ooooo`06o`000?oooooooooooooo
ool0003ooooo0_l0000>ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00
000Kooooo`04o`000?ooooooooooooooo`;o0000WOooool0087ooooo00?o0000ooooooooool03Ooo
ool01?l0003oooooooooool00009ooooo`03o`000?oooooo000000_ooooo00?o0000ooooool00000
1Oooool01Ol0003ooooooooooooooooo000001cooooo0ol000000ooooooo0000ooooo`0Nooooo`03
o`000?oooooooooo00Sooooo00Go0000ooooooooooooooooo`000008ooooo`04o`000?oooooooooo
o`0000oooooo00?o0000ooooool000001Oooool01Ol0003ooooooooooooooooo000001cooooo0ol0
00000ooooooo0000ooooo`2Looooo`00O?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool0000:ooooo`;o00003?oo
ool2o`0000Gooooo00Go0000ooooooooooooooooo`00000kooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool02?ooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000oooooooo
ool00_ooool01Ol0003ooooooooooooooooo000000oooooo0_l00005ooooo`05o`000?oooooooooo
ooooool00000__ooool007gooooo1?l0000<ooooo`Co00000oooool6o`0000Kooooo00?o0000oooo
ooooool02oooool00ol0003oooooooooo`04ooooo`?o0000?Oooool4o`0000cooooo0ol00005oooo
o`Co00001Oooool2o`0000kooooo00?o0000ooooooooool01?ooool3o`000;oooooo003ooooooo3o
oooo003ooooooo3ooooo003ooooooo3ooooo0036ooooo`03o`000?oooooooooo07Gooooo00?o0000
ooooooooool0[_ooool00<Kooooo00?o0000ooooooooool0MOooool00ol0003oooooooooo`2^oooo
o`00aoooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo0:gooooo002kooooo`Oo0000
1Oooool00ol0003oooooooooo`1Yooooo`Oo00001Oooool00ol0003oooooooooo`2]ooooo`00b?oo
ool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo0:cooooo0038ooooo`03o`000?oooooo
oooo07Gooooo00?o0000ooooooooool0[?ooool00<Wooooo00?o0000ooooooooool0MOooool00ol0
003oooooooooo`2[ooooo`00a?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo073o
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2[ooooo`00a?ooool6o`0007;ooooo
1_l0002]ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00
ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00
ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`001?ooool6o`0000?o
oooo0ol00004ooooo`Go00001Oooool00ol0003oooooooooo`23ooooo`Go0000Loooool5o`000<ko
oooo0004ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000oooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo08_ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`1`ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0boooool000Gooooo
00?o0000ooooooooool01?ooool01Ol0003ooooooooooooooooo000000Gooooo00?o0000oooooooo
ool0T?ooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo0<_ooooo0006ooooo`03o`00
0?oooooooooo00?ooooo00Go0000ooooooooooooooooo`000005ooooo`03o`000?oooooooooo08co
oooo1?l0001dooooo`Co0000c_ooool000Oooooo00?o0000ooooooooool00_ooool01Ol0003ooooo
oooooooooooo000000Gooooo00?o0000ooooooooool0Roooool00ol0003oooooooooo`1eooooo`03
o`000?oooooooooo0=3ooooo0008ooooo`05o`000?ooooooooooooooool000000oooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo08_ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`1`ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0boooool000Wooooo
00Co0000oooooooooooo00000oooool01ol0003ooooooooooooooooo0000ooooool00000S_ooool5
o`0007?ooooo1Ol0003=ooooo`001?ooool00ol0003oooooooooo`02ooooo`04o`000?oooooooooo
o`0000?ooooo00?o0000ooooooooool00_ooool2o`000?oooooofOooool000Gooooo1?l00004oooo
o`?o00001_ooool00ol0003oooooooooo`3oooooomOooooo003ooooooo3ooooo003ooooooo3ooooo
003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo001koooooeoo00006OoooomOo`0009go
oooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3o
oooo003Eooooo`?o0000MOooool3o`0009oooooo003Hooooo`03o`000?oooooooooo07Gooooo00?o
0000ooooooooool0W?ooool00=Wooooo00?o0000ooooooooool0MOooool00ol0003oooooooooo`2K
ooooo`00OOooool4o`0000Gooooo00?o0000ooooooooool01?ooool3o`0000Gooooo1?l00004oooo
o`Co00002oooool5o`0000Cooooo0ol0000Mooooo`?o000000?oooooo`000?ooool06Oooool5o`00
00Gooooo00?o0000ooooooooool01Oooool2o`0000Cooooo1Ol00003ooooo`Ko00002_ooool5o`00
00Cooooo0ol0000Mooooo`?o000000?oooooo`000?ooool0W?ooool007cooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`08ooooo`05o`000?ooooooooooooooool000000oooool00ol0
003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006oooool01?l0003ooooooooo
ooooool2o`0001cooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000Kooooo`04o`000?oooooooooooooo
o`;o0000WOooool0087ooooo00?o0000ooooooooool02?ooool01Ol0003ooooooooooooooooo0000
00Sooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00?ooooo00Go0000ooooooooooooooooo`00000Jooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool06_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00?ooooo00Go0000
ooooooooooooooooo`00000Jooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0Vooo
ool0087ooooo00?o0000ooooooooool02?ooool01Ol0003ooooooooooooooooo000000Sooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00?ooooo00Go
0000ooooooooooooooooo`00000Jooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
6_ooool00ol0003oooooooooo`0=ooooo`;o000000?oooooo`000?ooool00oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool00oooool01Ol0003ooooo
oooooooooooo000001[ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2Kooooo`00
O_ooool3o`0000_ooooo00Go0000ooooooooooooooooo`000005ooooo`?o00001Oooool3o`0000go
oooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000001[ooooo00?o0000oooo
ooooool00oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo00cooooo00?o0000oooo
ooooool00_l00004ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool03?ooool00ol0
003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006_ooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo09_ooooo0021ooooo`03o`000?oooooooooo00Sooooo00Go0000oooo
ooooooooooooo`000008ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006oooool01?l0003ooooooooo
ooooool2o`0001cooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0;ooooo`03o`00
0?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000Kooooo`04o`000?oooooooooooooo
o`;o0000WOooool0087ooooo00?o0000ooooooooool02?ooool01Ol0003ooooooooooooooooo0000
00Sooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo0000
00Gooooo00Go0000ooooooooooooooooo`00000Looooo`?o000000?oooooo`000?ooool06Oooool0
0ol0003oooooo`00000=ooooo`03o`000?oooooooooo00;ooooo00Ko0000oooooooooooo0000oooo
ool0000:ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooool000001Oooool01Ol0003ooooo
oooooooooooo000001cooooo0ol000000ooooooo0000ooooo`2Looooo`00O?ooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo00Sooooo00Go0000ooooooooooooooooo`000003ooooo`03
o`000?oooooooooo00;ooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`09oooo
o`;o00001Oooool01Ol0003ooooooooooooooooo000003cooooo0_l0000>ooooo`04o`000?oooooo
ooooo`0000Cooooo0_l00005ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02Ooo
ool2o`0000Gooooo00Go0000ooooooooooooooooo`00002nooooo`00OOooool4o`0000cooooo0ol0
0005ooooo`Co00001?ooool4o`0000gooooo00?o0000ooooooooool01?ooool3o`0003kooooo00?o
0000ooooooooool03Oooool2o`0000Kooooo00?o0000ooooooooool01?ooool4o`0000gooooo00?o
0000ooooooooool01?ooool3o`000;oooooo003ooooooo3ooooo0036ooooo`03o`000?oooooooooo
07Gooooo00?o0000ooooooooool0[_ooool00<Kooooo00?o0000ooooooooool0MOooool00ol0003o
ooooooooo`2^ooooo`00aoooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo0:gooooo
002kooooo`Oo00001Oooool00ol0003oooooooooo`1Yooooo`Oo00001Oooool00ol0003ooooooooo
o`2]ooooo`00b?ooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo0:cooooo0038oooo
o`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0[?ooool00<Wooooo00?o0000oooooooo
ool0MOooool00ol0003oooooooooo`2[ooooo`00a?ooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo073ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2[ooooo`00a?oo
ool6o`0007;ooooo1_l0002]ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00
ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00
ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00
ooooooo`ooooo`001?ooool5o`0000Gooooo0_l00005ooooo`Co00001Oooool00ol0003ooooooooo
o`23ooooo`Go0000Loooool5o`000<kooooo0006ooooo`03o`000?oooooooooo00Cooooo00Co0000
oooooooooooo00000oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo08Sooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`1`ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool0boooool000Kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02
ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000ooooooooool0SOooool00ol0003ooooooooo
o`1eooooo`03o`000?oooooooooo0<_ooooo0006ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool00_ooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo08Wooooo1?l0
001dooooo`Co0000c_ooool000Kooooo00?o0000ooooooooool00oooool2o`0000;ooooo00?o0000
ooooooooool00_ooool4o`0008_ooooo00?o0000ooooooooool0MOooool00ol0003oooooooooo`3@
ooooo`001_ooool00ol0003oooooooooo`03ooooo`04o`000?oooooo0000o`0000Cooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`28ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool0L?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0<_ooooo0004oooo
o`03o`000?oooooo000000Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo08Wooooo1Ol0001cooooo`Go0000cOooool000Gooooo0_l00006ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`3oooooomCo
oooo0006ooooo`03o`000?oooooooooo00Gooooo0_l00005ooooo`Co0000oooooooGooooo`00oooo
ooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00oooo
ooo`ooooo`00NooooomOo`0001WoooooGol0002Mooooo`00ooooooo`ooooo`00ooooooo`ooooo`00
ooooooo`ooooo`00eOooool3o`0007Gooooo0ol0002Oooooo`00f?ooool00ol0003oooooooooo`1e
ooooo`03o`000?oooooooooo09cooooo003Iooooo`03o`000?oooooooooo07Gooooo00?o0000oooo
ooooool0Voooool007cooooo1_l00004ooooo`03o`000?oooooooooo00Cooooo1?l00004ooooo`?o
00001Oooool4o`0000_ooooo1Ol00004ooooo`?o00007Oooool3o`000003ooooool0003ooooo01Wo
oooo1Ol00005ooooo`03o`000?oooooooooo00Cooooo1?l00004ooooo`?o00001?ooool5o`0000_o
oooo1Ol00004ooooo`?o00007Oooool3o`000003ooooool0003ooooo09cooooo001looooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`02ooooo`04o`00
0?ooooooooooo`0000?ooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000001_ooooo00Co0000
oooooooooooooooo0_l0000Looooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool00_oo
ool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
3Oooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006oooool01?l0003o
ooooooooooooool2o`0009gooooo001mooooo`03o`000?oooooooooo00cooooo00?o0000oooooooo
ool00_ooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006_ooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool02oooool0
0ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00?ooooo00Go0000oooooooooooooooo
o`00000Jooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0Voooool007kooooo00?o
0000ooooooooool02oooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000?ooooo
00?o0000ooooooooool01_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00?ooooo
00Go0000ooooooooooooooooo`00000Jooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool06_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooo
oooo00000oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00gooooo00?o0000oooo
ooooool00oooool01Ol0003ooooooooooooooooo000001[ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`2Kooooo`00Ooooool00ol0003oooooooooo`0;ooooo`Co00000oooool01Ol0
003ooooooooooooooooo000000Gooooo0ol0000=ooooo`03o`000?oooooooooo00?ooooo00Go0000
ooooooooooooooooo`00000Jooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool06_oo
ool00ol0003oooooooooo`0<ooooo`Co00000oooool01Ol0003ooooooooooooooooo000000Gooooo
00?o0000ooooooooool03Oooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool0
00006_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo09_ooooo0020ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00003ooooo`03
o`000?oooooooooo00Kooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`03ooooo`05
o`000?ooooooooooooooool000006oooool01?l0003oooooooooooooool2o`0001cooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000?ooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00?ooooo00Go
0000ooooooooooooooooo`00000Kooooo`04o`000?ooooooooooooooo`;o0000WOooool0087ooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000?o
oooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo000000Go
oooo00Go0000ooooooooooooooooo`00000Looooo`?o000000?oooooo`000?ooool06Oooool00ol0
003oooooo`00000=ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000oooool0
1ol0003ooooooooooooooooo0000ooooool000003Oooool00ol0003oooooo`000005ooooo`05o`00
0?ooooooooooooooool000007?ooool3o`000003ooooool0003ooooo09cooooo001looooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`02ooooo`04o`00
0?ooooooooooo`0000?ooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo
00Wooooo0_l00005ooooo`05o`000?ooooooooooooooool00000??ooool2o`0000gooooo00?o0000
ooooooooool00_ooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00;ooooo0_l0
000>ooooo`;o00001Oooool01Ol0003ooooooooooooooooo00000;kooooo001mooooo`Co00003?oo
ool4o`0000Cooooo0ol00005ooooo`Co00003Oooool00ol0003oooooooooo`04ooooo`?o0000?_oo
ool00ol0003oooooooooo`0<ooooo`Co00001?ooool3o`0000Kooooo00?o0000ooooooooool03Ooo
ool00ol0003oooooooooo`04ooooo`?o0000_oooool00?ooooool?ooool00?ooooool?ooool00?oo
ooool?ooool00<Kooooo00?o0000ooooooooool0MOooool00ol0003oooooooooo`2^ooooo`00a_oo
ool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo0:kooooo0037ooooo`03o`000?oooooo
oooo07Gooooo00?o0000ooooooooool0[Oooool00;_ooooo1ol00005ooooo`03o`000?oooooooooo
06Wooooo1ol00005ooooo`03o`000?oooooooooo0:gooooo0038ooooo`03o`000?oooooooooo07Go
oooo00?o0000ooooooooool0[?ooool00<Sooooo00?o0000ooooooooool0MOooool00ol0003ooooo
ooooo`2/ooooo`00bOooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo0:_ooooo0034
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0L?ooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo0:_ooooo0034ooooo`Ko0000L_ooool6o`000:gooooo003ooooooo3o
oooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3o
oooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3o
oooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo0004ooooo`Go00001?ooool4o`00
00Gooooo1?l00004ooooo`03o`000?oooooooooo08?ooooo1Ol0001cooooo`Go0000c_ooool000Ko
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool0ROooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo073o
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`3;ooooo`001_ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0S_ooool00ol0003ooooo
ooooo`1eooooo`03o`000?oooooooooo0<_ooooo0006ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool01_l0002;ooooo`Co0000M?ooool4o`000<kooooo0006ooooo`03o`000?oooooo
oooo00Gooooo0ol00003ooooo`05o`000?ooooooooooooooool00000Roooool00ol0003ooooooooo
o`1eooooo`03o`000?oooooooooo0=3ooooo0006ooooo`03o`000?oooooooooo00Sooooo00Go0000
ooooooooooooooooo`000002ooooo`03o`000?oooooooooo08Wooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`1`ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0booo
ool000Cooooo00?o0000ooooool000002_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
000008cooooo1Ol0001cooooo`Go0000cOooool000Gooooo0_l00005ooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool00oooool2o`000?ooooooeoooool000Kooooo00?o0000oooooooo
ool01?ooool4o`0000Oooooo00?o0000ooooooooool0oooooooEooooo`00ooooooo`ooooo`00oooo
ooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00NooooomOo`0001WoooooGol0002Mooooo`00
ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00
eOooool3o`0007Gooooo0ol0002Oooooo`00f?ooool00ol0003oooooooooo`1eooooo`03o`000?oo
oooooooo09cooooo003Iooooo`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0Voooool0
07cooooo1_l00004ooooo`03o`000?oooooooooo00Cooooo0ol00006ooooo`;o00001?ooool6o`00
00[ooooo1Ol00004ooooo`?o00007Oooool3o`000003ooooool0003ooooo01Wooooo1Ol00005oooo
o`03o`000?oooooooooo00Gooooo0_l00006ooooo`;o00001?ooool6o`0000[ooooo1Ol00004oooo
o`?o00007Oooool3o`000003ooooool0003ooooo09cooooo001looooo`03o`000?oooooooooo00;o
oooo00?o0000ooooooooool02?ooool01Ol0003ooooooooooooooooo000000Cooooo00Co0000oooo
oooooooo00000oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool00oooool01Ol0003ooooooooooooooooo000001_ooooo00Co0000oooooooooooooooo
0_l0000Looooo`03o`000?oooooooooo00cooooo00Co0000oooooooooooo00001oooool01Ol0003o
oooooooooooooooo000000Cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`03oooo
o`05o`000?ooooooooooooooool000006oooool01?l0003oooooooooooooool2o`0009gooooo001m
ooooo`03o`000?oooooooooo017ooooo00Co0000oooooooooooo00001?ooool01Ol0003ooooooooo
oooooooo0000013ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000001[o
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo00_o
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`05ooooo`05o`000?oooooooooooooo
ool000004?ooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006_ooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo09_ooooo001nooooo`03o`000?oooooooooo
013ooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo00gooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000001[ooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`;o000000?oooooo`000?ooool00ooo
ool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00?ooooo00Go0000oooooooooooooooo
o`00000Jooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0Voooool007oooooo00?o
0000ooooooooool03_ooool01?l0003oooooooooooooool2o`0000;ooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00?ooooo00Go0000oooooooooooo
ooooo`00000Jooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool06_ooool00ol0003o
ooooooooo`0;ooooo`;o00000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;o
00001Oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00?ooooo00Go0000oooooooo
ooooooooo`00000Jooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0Voooool0083o
oooo00?o0000ooooooooool02Oooool4o`0000Cooooo00Co0000ooooool0003o00002?ooool00ol0
003oooooooooo`0;ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000K
ooooo`04o`000?ooooooooooooooo`;o00007?ooool00ol0003oooooooooo`0;ooooo`04o`000?oo
oooo0000o`0000Cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo00_ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000001_o
oooo00Co0000oooooooooooooooo0_l0002Mooooo`00POooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooo000000Gooooo00Go0000ooooooooooooooooo`00000Looooo`?o000000?oooooo`00
0?ooool06Oooool00ol0003oooooo`00000=ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ool000001Oooool01Ol0003ooooooooooooooooo000001cooooo0ol000000ooooooo0000ooooo`2L
ooooo`00O?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool02Oooool2o`0000Gooooo00Go0000ooooooooooooooooo`00000looooo`;o00003_ooool0
0ol0003oooooooooo`05ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`09ooooo`;o00001Oooool01Ol0003ooooooooooooooooo00000;kooooo
001mooooo`Co00002oooool6o`0000Cooooo0_l00005ooooo`Co00003Oooool00ol0003ooooooooo
o`04ooooo`?o0000?_ooool00ol0003oooooooooo`0=ooooo`;o00001_ooool2o`0000Gooooo1?l0
000=ooooo`03o`000?oooooooooo00Cooooo0ol0002oooooo`00ooooooo`ooooo`00ooooooo`oooo
o`00a_ooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo0:kooooo0036ooooo`03o`00
0?oooooooooo07Gooooo00?o0000ooooooooool0[_ooool00<Oooooo00?o0000ooooooooool0MOoo
ool00ol0003oooooooooo`2]ooooo`00^oooool7o`0000Gooooo00?o0000ooooooooool0JOooool7
o`0000Gooooo00?o0000ooooooooool0[Oooool00<Sooooo00?o0000ooooooooool0MOooool00ol0
003oooooooooo`2/ooooo`00b?ooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo0:co
oooo0039ooooo`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0Zoooool00<Cooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`1`ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool0Zoooool00<Cooooo1_l0001booooo`Ko0000[Oooool00?ooooool?ooool00?oo
ooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?oo
ooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?oo
ooool?ooool00?ooooool?ooool000Cooooo1Ol00004ooooo`?o00001?ooool5o`0000Gooooo00?o
0000ooooooooool0Poooool5o`0007?ooooo1Ol0003>ooooo`001_ooool00ol0003oooooooooo`03
ooooo`05o`000?ooooooooooooooool000001Oooool00ol0003oooooooooo`2;ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool0L?ooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo0<_ooooo0006ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00
0005ooooo`03o`000?oooooooooo093ooooo00?o0000ooooooooool0MOooool00ol0003ooooooooo
o`3;ooooo`001_ooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000001Ooo
ool00ol0003oooooooooo`2<ooooo`Co0000M?ooool4o`000<kooooo0006ooooo`03o`000?oooooo
oooo00?ooooo00Go0000ooooooooooooooooo`000005ooooo`03o`000?oooooooooo08_ooooo00?o
0000ooooooooool0MOooool00ol0003oooooooooo`3@ooooo`001_ooool00ol0003oooooooooo`03
ooooo`05o`000?ooooooooooooooool000001Oooool00ol0003oooooooooo`2;ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool0L?ooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo0<_ooooo0004ooooo`03o`000?oooooo000000Gooooo00Go0000ooooooooooooooooo`00
0003ooooo`03o`000?oooooo000008kooooo1Ol0001cooooo`Go0000cOooool000Gooooo0_l00005
ooooo`05o`000?ooooooooooooooool000001?ooool2o`000?oooooofOooool000Kooooo00?o0000
ooooooooool01?ooool3o`0000Kooooo00?o0000ooooooooool0oooooooGooooo`00ooooooo`oooo
o`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00NooooomOo`00
01WoooooEol0002Uooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`
ooooo`00ooooooo`ooooo`00eOooool3o`0006gooooo0ol0002Wooooo`00f?ooool00ol0003ooooo
ooooo`1]ooooo`03o`000?oooooooooo0:Cooooo003Iooooo`03o`000?oooooooooo06gooooo00?o
0000ooooooooool0Xoooool007cooooo1_l00004ooooo`03o`000?oooooooooo00Cooooo1?l00004
ooooo`?o00001Oooool3o`0000cooooo1Ol00004ooooo`?o00007Oooool3o`000003ooooool0003o
oooo01Wooooo1Ol00005ooooo`03o`000?oooooooooo00Cooooo0ol00006ooooo`;o00003?ooool5
o`0000Cooooo0ol0000Mooooo`?o000000?oooooo`000?ooool0Y?ooool007cooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00;ooooo00Co0000oooo
oooooooo00000oooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooooooool02ooo
ool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006oooool01?l0003ooooo
ooooooooool2o`0001cooooo00?o0000ooooooooool02oooool01Ol0003ooooooooooooooooo0000
00Oooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`03ooooo`05o`000?oooooooooo
ooooool000006oooool01?l0003oooooooooooooool2o`000:Gooooo001mooooo`03o`000?oooooo
oooo017ooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`06ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000001[ooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo013ooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00?ooooo
00Go0000ooooooooooooooooo`00000Jooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool0Xoooool007kooooo00?o0000ooooooooool04?ooool01?l0003oooooooooool00003ooooo`03
o`000?oooooooooo00Kooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`03ooooo`05
o`000?ooooooooooooooool000006_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
01[ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`02ooooo`;o000000?oooooo`00
0?ooool02oooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006_ooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo0:?ooooo001oooooo`03o`000?oooooooooo
00cooooo0ol00003ooooo`05o`000?ooooooooooooooool000001oooool00ol0003oooooooooo`0;
ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000Jooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0?ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool00_l0000<ooooo`03o`000?oooooooooo00?ooooo00Go
0000ooooooooooooooooo`00000Jooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
Xoooool0083ooooo00?o0000ooooooooool03_ooool01?l0003oooooooooool00003ooooo`04o`00
0?ooooooooooooooo`Co00003_ooool00ol0003oooooooooo`03ooooo`05o`000?oooooooooooooo
ool000006oooool01?l0003oooooooooooooool2o`0001cooooo00?o0000ooooooooool02oooool4
o`0000Cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00?ooooo00Go0000ooooooooooooooooo`00000Kooooo`04o`000?ooooooooooooooo`;o0000
YOooool0087ooooo00?o0000ooooooooool03Oooool01?l0003oooooooooool00003ooooo`05o`00
0?ooooooooooooooool000003oooool00ol0003oooooo`000005ooooo`05o`000?oooooooooooooo
ool000007?ooool3o`000003ooooool0003ooooo01Wooooo00?o0000ooooool000003Oooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02?ooool00ol0
003oooooo`000005ooooo`05o`000?ooooooooooooooool000007?ooool3o`000003ooooool0003o
oooo0:Cooooo001looooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`02ooooo`04o`000?ooooooooooo`0000?ooooo00Go0000ooooooooooooooooo`00
000@ooooo`;o00001Oooool01Ol0003ooooooooooooooooo000003cooooo0_l0000=ooooo`03o`00
0?oooooooooo00Kooooo00Co0000oooooooooooo00003?ooool2o`0000Gooooo00Go0000oooooooo
ooooooooo`000036ooooo`00OOooool4o`0000cooooo1?l00004ooooo`?o00001?ooool6o`0000co
oooo00?o0000ooooooooool01?ooool3o`0003kooooo00?o0000ooooooooool02oooool6o`0000Co
oooo0_l0000>ooooo`03o`000?oooooooooo00Cooooo0ol00037ooooo`00ooooooo`ooooo`00a_oo
ool00ol0003oooooooooo`1]ooooo`03o`000?oooooooooo0;Kooooo0036ooooo`03o`000?oooooo
oooo06gooooo00?o0000ooooooooool0]_ooool00<Oooooo00?o0000ooooooooool0KOooool00ol0
003oooooooooo`2eooooo`00^oooool7o`0000Gooooo00?o0000ooooooooool0HOooool7o`0000Go
oooo00?o0000ooooooooool0]Oooool00<Sooooo00?o0000ooooooooool0KOooool00ol0003ooooo
ooooo`2dooooo`00b?ooool00ol0003oooooooooo`1]ooooo`03o`000?oooooooooo0;Cooooo0039
ooooo`03o`000?oooooooooo06gooooo00?o0000ooooooooool0/oooool00<Cooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`1Xooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool0/oooool00<Cooooo1_l0001Zooooo`Ko0000]Oooool00?ooooool?ooool00?ooooool?oo
ool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?oo
ool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?oo
ool00?ooooool?ooool00?ooooool?ooool000Gooooo1?l00004ooooo`Co00001Oooool00ol0003o
ooooooooo`04ooooo`Co0000Poooool5o`0007?ooooo1Ol0003>ooooo`001?ooool00ol0003ooooo
ooooo`02ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo083ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`1`ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0boooool000Cooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`25ooooo`03o`000?oooooooooo07Gooooo
00?o0000ooooooooool0boooool000Cooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`21ooooo`Co0000M?ooool4o`000<kooooo0005ooooo`Co00001Oooool3o`0000cooooo1?l00023
ooooo`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0d?ooool000Cooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`20ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool0L?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0<_ooooo0004ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool0POooool5o`0007?ooooo1Ol0003=ooooo`00
1?ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0?ooooooc?ooool000Gooooo
1?l00004ooooo`Co00003?ooool4o`000?oooooocoooool00?ooooool?ooool00?ooooool?ooool0
0?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool007_oooooGol0000I
oooooeoo0000WOooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00=Gooooo0ol0
001eooooo`?o0000Woooool00=Sooooo00?o0000ooooooooool0MOooool00ol0003oooooooooo`2L
ooooo`00fOooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo09_ooooo001looooo`Ko
00001?ooool00ol0003oooooooooo`03ooooo`Go00001Oooool2o`0000Kooooo0_l0000<ooooo`Go
00001?ooool3o`0001gooooo0ol000000ooooooo0000ooooo`0Iooooo`Go00001Oooool00ol0003o
ooooooooo`04ooooo`?o00001_ooool4o`0000Cooooo1?l0000:ooooo`Go00001?ooool3o`0001go
oooo0ol000000ooooooo0000ooooo`2Looooo`00O?ooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool01?ooool01?l0003oooooooooool00007ooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo0000
01_ooooo00Co0000oooooooooooooooo0_l0000Looooo`03o`000?oooooooooo00_ooooo00Go0000
ooooooooooooooooo`000007ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool02ooo
ool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006oooool01?l0003ooooo
ooooooooool2o`0009gooooo001mooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006_ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool04?ooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`03ooooo`05o`000?ooooooooooooooool000006_ooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo09_ooooo001nooooo`03o`000?oooooooooo00gooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo0_l000000ooooooo
0000ooooo`0;ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000Joooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0@oooo
o`03o`000?oooooooooo00Ko00000_ooool6o`0000cooooo00?o0000ooooooooool00oooool01Ol0
003ooooooooooooooooo000001[ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2K
ooooo`00Ooooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00?ooooo0_l00002oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_l0000<ooooo`03o`000?oooooooooo
00?ooooo00Go0000ooooooooooooooooo`00000Jooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool06_ooool00ol0003oooooooooo`0?ooooo`05o`000?ooooooooooooooool000000ooo
ool01Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`03ooooo`05o`000?ooooooooooooooool000006_ooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo09_ooooo0020ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
0oooool01?l0003oooooo`000?l00004ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006oooool01?l0
003oooooooooooooool2o`0001cooooo00?o0000ooooooooool02oooool4o`0000Gooooo00Co0000
oooooooooooo00001?ooool01?l0003oooooooooool0000=ooooo`03o`000?oooooooooo00?ooooo
00Go0000ooooooooooooooooo`00000Kooooo`04o`000?ooooooooooooooo`;o0000WOooool0087o
oooo00?o0000ooooooooool02?ooool00ol0003oooooo`000005ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo000000Go
oooo00Go0000ooooooooooooooooo`00000Looooo`?o000000?oooooo`000?ooool06Oooool00ol0
003oooooo`00000=ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooool000001Oooool00ol0
003oooooo`00000;ooooo`03o`000?oooooo000000Gooooo00Go0000ooooooooooooooooo`00000L
ooooo`?o000000?oooooo`000?ooool0W?ooool007cooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`09ooooo`;o00001_ooool00ol0003oooooooooo`05ooooo`04o`000?oooooooooo
o`0000cooooo0_l00005ooooo`05o`000?ooooooooooooooool00000??ooool2o`0000gooooo00?o
0000ooooooooool02?ooool2o`0000Kooooo0_l0000<ooooo`;o00001Oooool01Ol0003ooooooooo
oooooooo00000;kooooo001mooooo`Co00003Oooool00ol0003oooooooooo`05ooooo`;o00001_oo
ool2o`0000kooooo00?o0000ooooooooool01?ooool3o`0003kooooo00?o0000ooooooooool02ooo
ool6o`0000Kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo00Cooooo0ol0002oooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00
a_ooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo0:kooooo0036ooooo`03o`000?oo
oooooooo07Gooooo00?o0000ooooooooool0[_ooool00<Oooooo00?o0000ooooooooool0MOooool0
0ol0003oooooooooo`2]ooooo`00^oooool7o`0000Gooooo00?o0000ooooooooool0JOooool7o`00
00Gooooo00?o0000ooooooooool0[Oooool00<Sooooo00?o0000ooooooooool0MOooool00ol0003o
ooooooooo`2/ooooo`00b?ooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo0:cooooo
0039ooooo`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0Zoooool00<Cooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`1`ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool0Zoooool00<Cooooo1_l0001booooo`Ko0000[Oooool00?ooooool?ooool00?oooooo
l?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?oooooo
l?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?oooooo
l?ooool00?ooooool?ooool00?ooooool?ooool000Kooooo0_l00006ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool00oooool5o`0008?ooooo1Ol0001cooooo`Go0000c_ooool000Go
oooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo
08?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`1`ooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool0boooool000Cooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0R?ooool00ol0003o
ooooooooo`1eooooo`03o`000?oooooooooo0<_ooooo0004ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo08Cooooo
1?l0001dooooo`Co0000c_ooool000Cooooo0_l00002ooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool02oooool00ol0003oooooooooo`23ooooo`03o`000?oooooooooo07Gooooo00?o
0000ooooooooool0d?ooool000Cooooo00Co0000ooooool0003o00002?ooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo08?ooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`1`ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0boooool000Cooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo000008Kooooo1Ol0001c
ooooo`Go0000cOooool000Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo00Wooooo0_l0003oooooom7ooooo0006ooooo`;o00001?ooool6o`0000co
oooo00?o0000ooooooooool0ooooooo?ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`
ooooo`00ooooooo`ooooo`00NooooomOo`0001WoooooGol0002Mooooo`00ooooooo`ooooo`00oooo
ooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00eOooool3o`0007Gooooo
0ol0002Oooooo`00f?ooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo09cooooo003I
ooooo`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0Voooool007cooooo1_l00004oooo
o`03o`000?oooooooooo00Cooooo0ol00004ooooo`Ko00001?ooool2o`0000cooooo1Ol00004oooo
o`?o00007Oooool3o`000003ooooool0003ooooo01Wooooo1Ol00005ooooo`03o`000?oooooooooo
00Cooooo0ol00005ooooo`?o00001?ooool6o`0000[ooooo1Ol00004ooooo`?o00007Oooool3o`00
0003ooooool0003ooooo09cooooo001looooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool02?ooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooooooool00_ooool01Ol0
003ooooooooooooooooo000000;ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`03
ooooo`05o`000?ooooooooooooooool000006oooool01?l0003oooooooooooooool2o`0001cooooo
00?o0000ooooooooool02oooool01Ol0003ooooooooooooooooo000000?ooooo00Go0000oooooooo
ooooooooo`000003ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`03ooooo`05o`000?ooooooooooooooool000006oooool01?l0003ooooooooooooo
ool2o`0009gooooo001mooooo`03o`000?oooooooooo00cooooo00Go0000ooooooooooooooooo`00
0004ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000Jooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0@ooooo`04o`00
0?ooooooooooo`0000?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0>ooooo`03
o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00000Jooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool0Voooool007kooooo00?o0000ooooooooool02oooool01Ol0003o
oooooooooooooooo000000Gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo
000001[ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooo
oooo013ooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00gooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000001[ooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`2Kooooo`00Ooooool00ol0003ooooooooo
o`0:ooooo`05o`000?ooooooooooooooool000001_ooool00ol0003oooooooooo`02ooooo`;o0000
0_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00?ooooo00Go0000oooooooooooo
ooooo`00000Jooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool06_ooool00ol0003o
ooooooooo`0?ooooo`05o`000?ooooooooooooooool000000oooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo00cooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo
000001[ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2Kooooo`00P?ooool00ol0
003oooooooooo`09ooooo`05o`000?ooooooooooooooool000001oooool01_l0003ooooooooooooo
oooo0000ooooo`;o00003_ooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool0
00006oooool01?l0003oooooooooooooool2o`0001cooooo00?o0000ooooooooool02oooool4o`00
00Cooooo00Go0000ooooooooooooooooo`000007ooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool00oooool01Ol0003ooooooooooooooooo000001_ooooo00Co0000oooooooooooooooo
0_l0002Mooooo`00POooool00ol0003oooooooooo`08ooooo`05o`000?ooooooooooooooool00000
2?ooool01?l0003oooooooooool0000?ooooo`03o`000?oooooo000000Gooooo00Go0000oooooooo
ooooooooo`00000Looooo`?o000000?oooooo`000?ooool06Oooool00ol0003oooooo`00000=oooo
o`03o`000?oooooooooo00Gooooo00Go0000ooooooooooooooooo`000008ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooool000001Oooool01Ol0003ooooooooooooooooo000001cooooo0ol0
00000ooooooo0000ooooo`2Looooo`00O?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo00Sooooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooooooo00;ooooo00Go
0000ooooooooooooooooo`00000?ooooo`;o00001Oooool01Ol0003ooooooooooooooooo000003co
oooo0_l0000=ooooo`03o`000?oooooooooo00Gooooo00Go0000ooooooooooooooooo`000003oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02Oooool2o`0000Gooooo00Go0000oooo
ooooooooooooo`00002nooooo`00OOooool4o`0000cooooo0ol00005ooooo`Co00001Oooool2o`00
00kooooo00?o0000ooooooooool01?ooool3o`0003kooooo00?o0000ooooooooool02oooool6o`00
00?ooooo0ol00005ooooo`Co00003Oooool00ol0003oooooooooo`04ooooo`?o0000_oooool00?oo
ooool?ooool00?ooooool?ooool00<Kooooo00?o0000ooooooooool0MOooool00ol0003ooooooooo
o`2^ooooo`00a_ooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo0:kooooo0037oooo
o`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0[Oooool00;_ooooo1ol00005ooooo`03
o`000?oooooooooo06Wooooo1ol00005ooooo`03o`000?oooooooooo0:gooooo0038ooooo`03o`00
0?oooooooooo07Gooooo00?o0000ooooooooool0[?ooool00<Sooooo00?o0000ooooooooool0MOoo
ool00ol0003oooooooooo`2/ooooo`00bOooool00ol0003oooooooooo`1eooooo`03o`000?oooooo
oooo0:_ooooo0034ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0L?ooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo0:_ooooo0034ooooo`Ko0000L_ooool6o`000:go
oooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3o
oooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3o
oooo003ooooooo3ooooo003ooooooo3ooooo003ooooooo3ooooo0005ooooo`?o00001Oooool3o`00
00Kooooo00?o0000ooooooooool01?ooool4o`0008?ooooo1Ol0001cooooo`Go0000c_ooool000Co
oooo00Go0000ooooooooooooooooo`000003ooooo`05o`000?ooooooooooooooool000002oooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo083ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`1`ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0boooool0
00Wooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooo
oooo08Gooooo00?o0000ooooooooool0MOooool00ol0003oooooooooo`3;ooooo`002Oooool01?l0
003oooooooooool00003ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool0POooool4
o`0007Cooooo1?l0003>ooooo`002?ooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000
ooooooooool02oooool3o`0008?ooooo00?o0000ooooooooool0MOooool00ol0003oooooooooo`3@
ooooo`001?ooool4o`0000Cooooo00Go0000ooooooooooooooooo`00000@ooooo`03o`000?oooooo
oooo083ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`1`ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool0boooool000Cooooo00?o0000ooooooooool01Oooool01Ol0
003ooooooooooooooooo0000013ooooo00?o0000ooooooooool0POooool5o`0007?ooooo1Ol0003=
ooooo`001?ooool00ol0003oooooooooo`05ooooo`05o`000?ooooooooooooooool000002oooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo0?ooooooc?ooool000Cooooo1_l00003oooo
o`?o00003Oooool4o`000?oooooocoooool00?ooooool?ooool00?ooooool?ooool00?ooooool?oo
ool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool007_oooooGol0000Ioooooeoo0000
WOooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00=Gooooo
0ol0001eooooo`?o0000Woooool00=Sooooo00?o0000ooooooooool0MOooool00ol0003ooooooooo
o`2Looooo`00fOooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo09_ooooo001loooo
o`Go00001Oooool00ol0003oooooooooo`04ooooo`Co00001Oooool00ol0003oooooooooo`04oooo
o`Co00002oooool5o`0000Cooooo0ol0000Mooooo`?o000000?oooooo`000?ooool06Oooool5o`00
00Gooooo00?o0000ooooooooool01Oooool4o`0000Cooooo0_l00006ooooo`;o00003?ooool5o`00
00Cooooo0ol0000Mooooo`?o000000?oooooo`000?ooool0W?ooool007kooooo00?o0000oooooooo
ool02oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool00oooool01Ol0003ooooooooooooooooo000001_ooooo00Co0000oooooooooooooooo0_l0000L
ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool0
0007ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooo
oooooooo000001_ooooo00Co0000oooooooooooooooo0_l0002Mooooo`00O_ooool00ol0003ooooo
ooooo`0;ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00oooool01Ol0003ooooo
oooooooooooo000001[ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Jooooo`03
o`000?oooooooooo00oooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`03ooooo`05o`000?oooooooooo
ooooool000006_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo09_ooooo001noooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`03oooo
o`05o`000?ooooooooooooooool000006_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo01[ooooo00?o0000ooooooooool02oooool6o`0000;ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`02ooooo`;o000000?oooooo`000?ooool02oooool00ol0003oooooooooo`03
ooooo`05o`000?ooooooooooooooool000006_ooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo09_ooooo001nooooo`03o`000?oooooooooo00cooooo1?l00007ooooo`03o`000?oooooo
oooo00?ooooo0ol0000=ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00
000Jooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool06_ooool00ol0003ooooooooo
o`0;ooooo`05o`000?ooooooooooooooool000000oooool2o`0000;ooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`02o`0000cooooo00?o0000ooooooooool00oooool01Ol0003ooooo
oooooooooooo000001[ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2Kooooo`00
O_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
0oooool01Ol0003ooooooooooooooooo000001_ooooo00Co0000oooooooooooooooo0_l0000Loooo
o`03o`000?oooooooooo00cooooo00Co0000oooooooooooo00000oooool01?l0003oooooo`000?l0
0004ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`03ooooo`05o`000?ooooooooooooooool000006oooool01?l0003oooooooooooooool2o`0009go
oooo001looooo`03o`000?oooooo000000gooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool02?ooool00ol0003ooooo
o`000005ooooo`05o`000?ooooooooooooooool000007?ooool3o`000003ooooool0003ooooo01Wo
oooo00?o0000ooooool000003oooool00ol0003oooooo`000003ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo000000Go
oooo00Go0000ooooooooooooooooo`00000Looooo`?o000000?oooooo`000?ooool0W?ooool007go
oooo0_l0000=ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00001?ooool01?l0
003oooooooooool00004ooooo`03o`000?oooooooooo00Wooooo0_l00005ooooo`05o`000?oooooo
ooooooooool00000??ooool2o`00013ooooo0_l00004ooooo`03o`000?oooooooooo00Gooooo00Co
0000oooooooooooo00003?ooool2o`0000Gooooo00Go0000ooooooooooooooooo`00002nooooo`00
O_ooool00ol0003oooooooooo`0<ooooo`Co00000oooool6o`0000?ooooo1?l0000=ooooo`03o`00
0?oooooooooo00Cooooo0ol0000nooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool0
0oooool2o`0000Kooooo0_l0000>ooooo`03o`000?oooooooooo00Cooooo0ol0002oooooo`00oooo
ooo`ooooo`00ooooooo`ooooo`00ooooooo`ooooo`00a_ooool00ol0003oooooooooo`1eooooo`03
o`000?oooooooooo0:kooooo0036ooooo`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0
[_ooool00<Oooooo00?o0000ooooooooool0MOooool00ol0003oooooooooo`2]ooooo`00^oooool7
o`0000Gooooo00?o0000ooooooooool0JOooool7o`0000Gooooo00?o0000ooooooooool0[Oooool0
0<Sooooo00?o0000ooooooooool0MOooool00ol0003oooooooooo`2/ooooo`00b?ooool00ol0003o
ooooooooo`1eooooo`03o`000?oooooooooo0:cooooo0039ooooo`03o`000?oooooooooo07Gooooo
00?o0000ooooooooool0Zoooool00<Cooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`1`ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0Zoooool00<Cooooo1_l0001b
ooooo`Ko0000[Oooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?oo
ool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?ooool00?ooooool?oo
ool00001\
\>"]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{0, 1440}, {0, 877}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{714, 822},
WindowMargins->{{Automatic, 5}, {Automatic, 2}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1.5
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 467, 9, 150, "SmallText"],
Cell[2224, 62, 290, 6, 84, "SmallText"],
Cell[2517, 70, 925, 20, 618, "Input",
  InitializationCell->True],
Cell[3445, 92, 920, 27, 638, "Input",
  InitializationCell->True],
Cell[4368, 121, 208, 7, 118, "Input",
  InitializationCell->True],
Cell[4579, 130, 129, 4, 47, "Text"],
Cell[4711, 136, 150, 5, 78, "Input"],
Cell[4864, 143, 136, 2, 47, "Text"],
Cell[5003, 147, 245, 7, 118, "Input"],

Cell[CellGroupData[{
Cell[5273, 158, 88, 2, 38, "Input"],
Cell[5364, 162, 25073, 349, 71, 1755, 57, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[30452, 514, 147, 4, 46, "Input"],

Cell[CellGroupData[{
Cell[30624, 522, 687, 31, 618, "Input"],
Cell[31314, 555, 221920, 3719, 1592, 29486, 1338, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[253271, 4279, 154, 5, 58, "Input"],
Cell[253428, 4286, 65413, 887, 519, 8647, 181, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[318856, 5176, 147, 4, 46, "Input"],
Cell[319006, 5182, 275, 5, 90, "Input"],

Cell[CellGroupData[{
Cell[319306, 5191, 842, 36, 738, "Input"],
Cell[320151, 5229, 221946, 3719, 1592, 29484, 1338, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[542134, 8953, 127, 4, 58, "Input"],
Cell[542264, 8959, 65126, 884, 519, 8639, 181, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

