
box[{xmin_, ymin_}, {xmax_, ymax_}] := 
    Line[{{xmin, ymin}, {xmin, ymax}, {xmax, ymax}, {xmax, ymin}}];
bar[x_, y_, dx_, g_] := {GrayLevel[g], Rectangle[{x - dx, 0}, {x + dx, y}], 
      GrayLevel[0], box[{x - dx, 0}, {x + dx, y}]};
barchart[x_, y_, dx_, g_, title_] := Module[{i, j, boxes, bars},
		(* Watch out -- dx is the half - width of a bar! *)
      
      bars = Table[
          bar[x\[LeftDoubleBracket]i\[RightDoubleBracket], 
            y\[LeftDoubleBracket]i\[RightDoubleBracket], dx, g], {i, 
            Length[y]}]; 
      Show[Graphics[bars], Axes -> True, PlotRange -> All, PlotLabel -> title,
         DisplayFunction -> Identity]];
\!\(\(wdistribution[rdata_, wdata_, binsize_, int_, gmin_, gmax_, grey_, title_] := Block[{i, j, j0, k, g1, x, min, max, nbins, integral, sums, total, totalweight, xdata, top}, integral = int == 1; Clear[g1]; n = Length[rdata]; min = gmin; max = gmax; nbins = Floor[\(max - min\)\/binsize]; Print[{nbins, binsize, n}]; sums = Table[0, {nbins}]; total = Table[0, {nbins}]; totalweight = 0; assignbin[{x_, w_}] := Block[{j0}, j0 = Floor[\(x - min\)\/binsize] + 1; If[j0 > nbins || j0 < 1, j0 = nbins]; sums\[LeftDoubleBracket]j0\[RightDoubleBracket] = sums\[LeftDoubleBracket]j0\[RightDoubleBracket] + w; totalweight = totalweight + w]; assignbin /@ Transpose[{rdata, wdata}]; Print["\<binned...\>"]; total\[LeftDoubleBracket]1\[RightDoubleBracket] = sums\[LeftDoubleBracket]1\[RightDoubleBracket]; Do[total\[LeftDoubleBracket]j\[RightDoubleBracket] = total\[LeftDoubleBracket]j - 1\[RightDoubleBracket] + sums\[LeftDoubleBracket]j\[RightDoubleBracket], {j, 2, nbins}]; xdata = Table[min + \(\((j - 1\/2)\)\ \((max - min)\)\)\/nbins, {j, nbins}]; top = rdata\ wdata; Print["\<top summed...\>"]; \[IndentingNewLine]average = \(\[Sum]\+\(x = 1\)\%\(Length[top]\)top\[LeftDoubleBracket]x\[RightDoubleBracket]\)\/totalweight; \[IndentingNewLine]Print["\<Average is \>", average]; If[integral, g1 = barchart[xdata, total, binsize\/2, grey, title], g1 = barchart[xdata, sums, binsize\/2, grey, title]]; Show[g1, DisplayFunction -> $DisplayFunction, AspectRatio -> 1/GoldenRatio]];\)\)
