(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    150151,       3584]*)
(*NotebookOutlinePosition[    151156,       3619]*)
(*  CellTagsIndexPosition[    151112,       3615]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "CHR started 18 Feb 2020. Test of reproducibility for the ReScience 10-year \
reproducibility challenge (https://rescience.github.io/ten-years/). Chosen \
paper is Robert, C.H. (1995) Estimating Friction Coefficients of Mixed \
Globular/Chain Molecules, such as Protein/DNA Complexes. Biophys J. 69, \
840-48.\n\nAll code in this file came from the original notebook \"Example 3 \
3x208.nb\" and was run using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " versions 5.2 and 12.0.\nChanges:\n- added dependence on library \
s6.1_repro.m\n- added dependence on additional routines I had written in \
other libraries and gathered into \"extra.m\"\n- removed terminal semicolons \
to see graphical output"
}], "Text",
  CellFrame->True,
  InitializationCell->True,
  ExpressionUUID -> "4395c488-107e-4ad3-a23d-de7f84ef685a",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    \(\(Get["\<ReScience/\>" <> "\<s6.1_repro.m\>"];\)\), \
"\[IndentingNewLine]", 
    \(\(Get["\<ReScience/\>" <> "\<extra.m\>"];\)\)}], "Input",
  ExpressionUUID -> "4ed2792d-9bd3-49da-8ab2-4888e1d3c66f"],

Cell["\<\
Off[General::spell];
Off[General::spell1];\
\>", "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "f08b2882-2bf3-47da-9f86-2fbf65286844"],

Cell[CellGroupData[{

Cell["\<\
Hydro MS Example 3: Vary nucleosome placements on template: 1.75 \
turns\
\>", "Subsubsection",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "7fa35ed6-7d93-41e1-bfdb-5d3b93f1230d"],

Cell["\<\
Here are the calculations for the examples given in my paper for a \
chromatin saturation process. A trimer of positioning sites is envisioned, \
and the frictional properties of all possible species are calculated. Since \
when I did these I hadn't yet reactivated the sedimentation coefficient \
subroutine, I calculate all the sedimentation coefficients all at the \
end.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "9b2ee285-ce70-41d7-ab50-fe22f9016d3c"],

Cell["\<\
First clear the randomizing orientation matrix so that all of the \
chain pictures will be aligned in the same coordinate system.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "0e9665a1-362a-4319-bd3c-b1ae4a7bccc1"],

Cell["\<\
ClearAll[A0];
A0=IdentityMatrix[3];\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "e9dad861-7470-42d9-bfa6-2871a5ee526a"],

Cell["\<\
Define the chain and the nucleosomes for this example. Default \
parameters include persistence length of 150 bp.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "3930d682-a671-4fee-becb-ea92bf0f3f61"],

Cell[CellGroupData[{

Cell["\<\
turns=1.75;
definebasepair;
definenuke;
definephysicalnuke;
chaininitialize;
wrapbp\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "5e42c659-122b-4f9f-9720-ad9095434504"],

Cell[BoxData[
    InterpretationBox[\("n = "\[InvisibleSpace]20\[InvisibleSpace]" ; dl = "\
\[InvisibleSpace]24.51185724694005`\),
      SequenceForm[ "n = ", 20, " ; dl = ", 24.51185724694005],
      Editable->False]], "Print"],

Cell[BoxData[
    \(146\)], "Output"]
}, Open  ]],

Cell["\<\
Now define a couple of things to make the example easier to do. The \
DNA chain is of length template (bp), and there are nnukes nucleosomes on it. \
The nucleosomes begin and end the chain. The linker length in bp is \
calculated, and the \"chain\" defined.  Remember that the chain of segments \
includes one segment for each free basepair (the linker) and one segment for \
each nucleosome.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "8f0f56c8-3c72-495e-9edd-484fe897c1b9"],

Cell["ntemplate=624;\t\t\t(* total length, bp *)", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "462bea87-c9e2-4eee-a0f8-e8fa1f2d17f9"],

Cell[CellGroupData[{

Cell["\<\
species={{1},{2},{3},{1,2},{1,3},{2,3},{1,2,3}};
nt[spots_]:=ntemplate - Length[spots] wrapbp + Length[spots];
Map[nt,species]\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "cb93d1fa-4a75-4a3c-8d7a-1da163fd72a4"],

Cell[BoxData[
    \({479, 479, 479, 334, 334, 334, 189}\)], "Output"]
}, Open  ]],

Cell["\<\
chain={\t{479,{1}},
\t\t{479,{209}},
\t\t{479,{417}},
\t\t{334,{1,64}},
\t\t{334,{1,272}},
\t\t{334,{209,272}},
\t\t{189,{1,64,127}}\t};\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "feb75349-28d4-4223-a028-710b0067f4b2"],

Cell[BoxData[{
    \(\(persistence = 150\ el0;\)\), "\n", 
    \(\(definebasepair;\)\)}], "Input",
  ExpressionUUID -> "2a13c0cf-b8ac-45a7-aa83-1e9028272846"],

Cell["\<\
collective=True;
test=True;
progress=True;
montecarlo=False;\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "2b92c31c-c934-4219-a5e1-86f523c56f05"],

Cell[CellGroupData[{

Cell["\<\
Do[\tassembleelements[chain[[isp]]];
\tmakeAs[chain[[isp]]];
\tdoKirkwood[chain[[isp]]],
{isp,Length[species]}];\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "c89b7b0a-7e39-4194-bde8-dcdd7c05f5de"],

Cell[BoxData[
    InterpretationBox[\("Chain of "\[InvisibleSpace]479\[InvisibleSpace]" \
segments,"\),
      SequenceForm[ "Chain of ", 479, " segments,"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("with displacements at segments "\[InvisibleSpace]{1}\
\),
      SequenceForm[ "with displacements at segments ", {1}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Stokes offset "\[InvisibleSpace]3.0076424054539146`\
\[InvisibleSpace]" A at "\[InvisibleSpace]50\[InvisibleSpace]" bp"\),
      SequenceForm[ 
      "Stokes offset ", 3.0076424054539146, " A at ", 50, " bp"],
      Editable->False]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
            {\("persistence\nlength"\), "510.`", "\<\"A\"\>"},
            {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
            {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
            {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
            {"\<\"turns\"\>", "1.75`", "\<\"turns\"\>"},
            {"\<\"pitch\"\>", \(-28.571`\), "\<\"A/turn\"\>"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("Array of chain lengths (bp)"\)], "Print"],

Cell[BoxData[
    \({0, 478}\)], "Print"],

Cell[BoxData[
    \("Array of friction element positions (bp)"\)], "Print"],

Cell[BoxData[
    \({1, 240}\)], "Print"],

Cell[BoxData[
    \("Array of Stokes radii (A)"\)], "Print"],

Cell[BoxData[
    \({56.81238789104188`, 163.0216893780777`}\)], "Print"],

Cell[BoxData[
    \("...doKirkwood..."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]" \
"\[InvisibleSpace]645.8155571508559`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]610.4217021660207`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 2, " ", 645.81555715085585, " corrected:", 
        610.42170216602074],
      Editable->False]], "Print"],

Cell[BoxData[
    \({"np", "nchain", "mass1", "vbar1"}\)], "Print"],

Cell[BoxData[
    \({{479, {1}}, 624, 520340, 0.5917035015566745`}\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1,s1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(4.2100751286712484`*^-7\ g\)\
\/s, \(3.6994206299600297`*^-7\ g\)\/s, 9.498180247177793`*^-13\ s}\),
      SequenceForm[ "   ", {
        Times[ 4.2100751286712484*^-07, g, 
          Power[ s, -1]], 
        Times[ 3.6994206299600297*^-07, g, 
          Power[ s, -1]], 
        Times[ 9.498180247177793*^-13, s]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Chain of "\[InvisibleSpace]479\[InvisibleSpace]" \
segments,"\),
      SequenceForm[ "Chain of ", 479, " segments,"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("with displacements at segments \
"\[InvisibleSpace]{209}\),
      SequenceForm[ "with displacements at segments ", {209}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Stokes offset "\[InvisibleSpace]3.0076424054539146`\
\[InvisibleSpace]" A at "\[InvisibleSpace]50\[InvisibleSpace]" bp"\),
      SequenceForm[ 
      "Stokes offset ", 3.0076424054539146, " A at ", 50, " bp"],
      Editable->False]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
            {\("persistence\nlength"\), "510.`", "\<\"A\"\>"},
            {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
            {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
            {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
            {"\<\"turns\"\>", "1.75`", "\<\"turns\"\>"},
            {"\<\"pitch\"\>", \(-28.571`\), "\<\"A/turn\"\>"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("Array of chain lengths (bp)"\)], "Print"],

Cell[BoxData[
    \({208, 270}\)], "Print"],

Cell[BoxData[
    \("Array of friction element positions (bp)"\)], "Print"],

Cell[BoxData[
    \({104, 209, 344}\)], "Print"],

Cell[BoxData[
    \("Array of Stokes radii (A)"\)], "Print"],

Cell[BoxData[
    \({89.96818327695928`, 56.81238789104188`, 
      108.17184797520562`}\)], "Print"],

Cell[BoxData[
    \("...doKirkwood..."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]" \
"\[InvisibleSpace]324.43031401801034`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]320.1594381327741`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 2, " ", 324.43031401801034, " corrected:", 
        320.15943813277408],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]472.9184509146818`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]446.8311934751571`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 3, " ", 472.91845091468178, " corrected:", 
        446.83119347515708],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]403.03341895592627`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]394.6383309173865`\),
      SequenceForm[ 
      "i,j,rij:", "*", 2, " ", 3, " ", 403.03341895592627, " corrected:", 
        394.6383309173865],
      Editable->False]], "Print"],

Cell[BoxData[
    \({"np", "nchain", "mass1", "vbar1"}\)], "Print"],

Cell[BoxData[
    \({{479, {209}}, 624, 520340, 0.5917035015566745`}\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1,s1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(4.882631720083008`*^-7\ \
g\)\/s, \(3.442705591770239`*^-7\ g\)\/s, 1.0206438807165194`*^-12\ s}\),
      SequenceForm[ "   ", {
        Times[ 4.8826317200830079*^-07, g, 
          Power[ s, -1]], 
        Times[ 3.4427055917702392*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.0206438807165194*^-12, s]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Chain of "\[InvisibleSpace]479\[InvisibleSpace]" \
segments,"\),
      SequenceForm[ "Chain of ", 479, " segments,"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("with displacements at segments \
"\[InvisibleSpace]{417}\),
      SequenceForm[ "with displacements at segments ", {417}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Stokes offset "\[InvisibleSpace]3.0076424054539146`\
\[InvisibleSpace]" A at "\[InvisibleSpace]50\[InvisibleSpace]" bp"\),
      SequenceForm[ 
      "Stokes offset ", 3.0076424054539146, " A at ", 50, " bp"],
      Editable->False]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
            {\("persistence\nlength"\), "510.`", "\<\"A\"\>"},
            {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
            {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
            {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
            {"\<\"turns\"\>", "1.75`", "\<\"turns\"\>"},
            {"\<\"pitch\"\>", \(-28.571`\), "\<\"A/turn\"\>"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("Array of chain lengths (bp)"\)], "Print"],

Cell[BoxData[
    \({416, 62}\)], "Print"],

Cell[BoxData[
    \("Array of friction element positions (bp)"\)], "Print"],

Cell[BoxData[
    \({208, 417, 448}\)], "Print"],

Cell[BoxData[
    \("Array of Stokes radii (A)"\)], "Print"],

Cell[BoxData[
    \({147.48346391059286`, 56.81238789104188`, 
      40.885858384248856`}\)], "Print"],

Cell[BoxData[
    \("...doKirkwood..."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]" \
"\[InvisibleSpace]580.1828562491935`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]554.5140033133057`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 2, " ", 580.18285624919349, " corrected:", 
        554.51400331330569],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]558.289936859844`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]527.4933940719919`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 3, " ", 558.28993685984403, " corrected:", 
        527.49339407199193],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]114.66687786172506`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]114.51956364643797`\),
      SequenceForm[ 
      "i,j,rij:", "*", 2, " ", 3, " ", 114.66687786172506, " corrected:", 
        114.51956364643797],
      Editable->False]], "Print"],

Cell[BoxData[
    \({"np", "nchain", "mass1", "vbar1"}\)], "Print"],

Cell[BoxData[
    \({{479, {417}}, 624, 520340, 0.5917035015566745`}\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1,s1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(4.6955114188007187`*^-7\ g\)\
\/s, \(3.397716272921084`*^-7\ g\)\/s, 1.0341582737065843`*^-12\ s}\),
      SequenceForm[ "   ", {
        Times[ 4.6955114188007187*^-07, g, 
          Power[ s, -1]], 
        Times[ 3.3977162729210842*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.0341582737065843*^-12, s]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Chain of "\[InvisibleSpace]334\[InvisibleSpace]" \
segments,"\),
      SequenceForm[ "Chain of ", 334, " segments,"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("with displacements at segments "\[InvisibleSpace]{1, 
          64}\),
      SequenceForm[ "with displacements at segments ", {1, 64}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Stokes offset "\[InvisibleSpace]3.0076424054539146`\
\[InvisibleSpace]" A at "\[InvisibleSpace]50\[InvisibleSpace]" bp"\),
      SequenceForm[ 
      "Stokes offset ", 3.0076424054539146, " A at ", 50, " bp"],
      Editable->False]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
            {\("persistence\nlength"\), "510.`", "\<\"A\"\>"},
            {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
            {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
            {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
            {"\<\"turns\"\>", "1.75`", "\<\"turns\"\>"},
            {"\<\"pitch\"\>", \(-28.571`\), "\<\"A/turn\"\>"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("Array of chain lengths (bp)"\)], "Print"],

Cell[BoxData[
    \({0, 62, 270}\)], "Print"],

Cell[BoxData[
    \("Array of friction element positions (bp)"\)], "Print"],

Cell[BoxData[
    \({1, 32, 64, 199}\)], "Print"],

Cell[BoxData[
    \("Array of Stokes radii (A)"\)], "Print"],

Cell[BoxData[
    \({56.81238789104188`, 40.885858384248856`, 56.81238789104188`, 
      108.17184797520562`}\)], "Print"],

Cell[BoxData[
    \("...doKirkwood..."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]" \
"\[InvisibleSpace]114.66687786172506`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]114.51956364643797`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 2, " ", 114.66687786172506, " corrected:", 
        114.51956364643797],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]216.18081933111512`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]215.09375144101062`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 3, " ", 216.18081933111512, " corrected:", 
        215.09375144101062],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]4\[InvisibleSpace]" \
"\[InvisibleSpace]389.411909204993`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]373.650014784126`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 4, " ", 389.41190920499298, " corrected:", 
        373.65001478412597],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]117.62366420737646`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]117.46298054434494`\),
      SequenceForm[ 
      "i,j,rij:", "*", 2, " ", 3, " ", 117.62366420737646, " corrected:", 
        117.46298054434494],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]4\[InvisibleSpace]" \
"\[InvisibleSpace]380.3077621656541`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]368.77534320017975`\),
      SequenceForm[ 
      "i,j,rij:", "*", 2, " ", 4, " ", 380.30776216565408, " corrected:", 
        368.77534320017975],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]4\[InvisibleSpace]" \
"\[InvisibleSpace]403.03341895592627`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]394.6383309173865`\),
      SequenceForm[ 
      "i,j,rij:", "*", 3, " ", 4, " ", 403.03341895592627, " corrected:", 
        394.6383309173865],
      Editable->False]], "Print"],

Cell[BoxData[
    \({"np", "nchain", "mass1", "vbar1"}\)], "Print"],

Cell[BoxData[
    \({{334, {1, 64}}, 624, 628840, 0.6190159659054768`}\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1,s1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(5.030671306923299`*^-7\ \
g\)\/s, \(2.8675503874395963`*^-7\ g\)\/s, 1.381075141865474`*^-12\ s}\),
      SequenceForm[ "   ", {
        Times[ 5.0306713069232988*^-07, g, 
          Power[ s, -1]], 
        Times[ 2.8675503874395963*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.381075141865474*^-12, s]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Chain of "\[InvisibleSpace]334\[InvisibleSpace]" \
segments,"\),
      SequenceForm[ "Chain of ", 334, " segments,"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("with displacements at segments "\[InvisibleSpace]{1, 
          272}\),
      SequenceForm[ "with displacements at segments ", {1, 272}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Stokes offset "\[InvisibleSpace]3.0076424054539146`\
\[InvisibleSpace]" A at "\[InvisibleSpace]50\[InvisibleSpace]" bp"\),
      SequenceForm[ 
      "Stokes offset ", 3.0076424054539146, " A at ", 50, " bp"],
      Editable->False]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
            {\("persistence\nlength"\), "510.`", "\<\"A\"\>"},
            {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
            {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
            {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
            {"\<\"turns\"\>", "1.75`", "\<\"turns\"\>"},
            {"\<\"pitch\"\>", \(-28.571`\), "\<\"A/turn\"\>"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("Array of chain lengths (bp)"\)], "Print"],

Cell[BoxData[
    \({0, 270, 62}\)], "Print"],

Cell[BoxData[
    \("Array of friction element positions (bp)"\)], "Print"],

Cell[BoxData[
    \({1, 136, 272, 303}\)], "Print"],

Cell[BoxData[
    \("Array of Stokes radii (A)"\)], "Print"],

Cell[BoxData[
    \({56.81238789104188`, 108.17184797520562`, 56.81238789104188`, 
      40.885858384248856`}\)], "Print"],

Cell[BoxData[
    \("...doKirkwood..."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]" \
"\[InvisibleSpace]403.03341895592627`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]394.6383309173865`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 2, " ", 403.03341895592627, " corrected:", 
        394.6383309173865],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]715.0896873239398`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]667.6613839236503`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 3, " ", 715.08968732393976, " corrected:", 
        667.66138392365031],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]4\[InvisibleSpace]" \
"\[InvisibleSpace]692.2355887402933`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]638.5842332995603`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 4, " ", 692.23558874029334, " corrected:", 
        638.58423329956031],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]405.636231573881`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]397.07418637837964`\),
      SequenceForm[ 
      "i,j,rij:", "*", 2, " ", 3, " ", 405.63623157388099, " corrected:", 
        397.07418637837964],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]4\[InvisibleSpace]" \
"\[InvisibleSpace]382.2790346174424`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]370.6868389603758`\),
      SequenceForm[ 
      "i,j,rij:", "*", 2, " ", 4, " ", 382.27903461744239, " corrected:", 
        370.68683896037578],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]4\[InvisibleSpace]" \
"\[InvisibleSpace]114.66687786172506`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]114.51956364643797`\),
      SequenceForm[ 
      "i,j,rij:", "*", 3, " ", 4, " ", 114.66687786172506, " corrected:", 
        114.51956364643797],
      Editable->False]], "Print"],

Cell[BoxData[
    \({"np", "nchain", "mass1", "vbar1"}\)], "Print"],

Cell[BoxData[
    \({{334, {1, 272}}, 624, 628840, 0.6190159659054768`}\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1,s1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(5.030671306923299`*^-7\ \
g\)\/s, \(3.253621026145971`*^-7\ g\)\/s, 1.2171984771166338`*^-12\ s}\),
      SequenceForm[ "   ", {
        Times[ 5.0306713069232988*^-07, g, 
          Power[ s, -1]], 
        Times[ 3.253621026145971*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.2171984771166338*^-12, s]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Chain of "\[InvisibleSpace]334\[InvisibleSpace]" \
segments,"\),
      SequenceForm[ "Chain of ", 334, " segments,"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("with displacements at segments \
"\[InvisibleSpace]{209, 272}\),
      SequenceForm[ "with displacements at segments ", {209, 272}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Stokes offset "\[InvisibleSpace]3.0076424054539146`\
\[InvisibleSpace]" A at "\[InvisibleSpace]50\[InvisibleSpace]" bp"\),
      SequenceForm[ 
      "Stokes offset ", 3.0076424054539146, " A at ", 50, " bp"],
      Editable->False]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
            {\("persistence\nlength"\), "510.`", "\<\"A\"\>"},
            {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
            {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
            {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
            {"\<\"turns\"\>", "1.75`", "\<\"turns\"\>"},
            {"\<\"pitch\"\>", \(-28.571`\), "\<\"A/turn\"\>"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("Array of chain lengths (bp)"\)], "Print"],

Cell[BoxData[
    \({208, 62, 62}\)], "Print"],

Cell[BoxData[
    \("Array of friction element positions (bp)"\)], "Print"],

Cell[BoxData[
    \({104, 209, 240, 272, 303}\)], "Print"],

Cell[BoxData[
    \("Array of Stokes radii (A)"\)], "Print"],

Cell[BoxData[
    \({89.96818327695928`, 56.81238789104188`, 40.885858384248856`, 
      56.81238789104188`, 40.885858384248856`}\)], "Print"],

Cell[BoxData[
    \("...doKirkwood..."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]" \
"\[InvisibleSpace]324.43031401801034`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]320.1594381327741`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 2, " ", 324.43031401801034, " corrected:", 
        320.15943813277408],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]301.2323890607516`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]294.87406815958417`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 3, " ", 301.23238906075159, " corrected:", 
        294.87406815958417],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]4\[InvisibleSpace]" \
"\[InvisibleSpace]317.63739195995055`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]307.9054369772628`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 4, " ", 317.63739195995055, " corrected:", 
        307.90543697726281],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]5\[InvisibleSpace]" \
"\[InvisibleSpace]358.9741319823608`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]344.3224010759045`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 5, " ", 358.9741319823608, " corrected:", 
        344.32240107590451],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]114.66687786172506`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]114.51956364643797`\),
      SequenceForm[ 
      "i,j,rij:", "*", 2, " ", 3, " ", 114.66687786172506, " corrected:", 
        114.51956364643797],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]4\[InvisibleSpace]" \
"\[InvisibleSpace]216.18081933111515`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]215.09375144101065`\),
      SequenceForm[ 
      "i,j,rij:", "*", 2, " ", 4, " ", 216.18081933111515, " corrected:", 
        215.09375144101065],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]5\[InvisibleSpace]" \
"\[InvisibleSpace]177.42851600296217`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]175.5273008559039`\),
      SequenceForm[ 
      "i,j,rij:", "*", 2, " ", 5, " ", 177.42851600296217, " corrected:", 
        175.52730085590389],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]4\[InvisibleSpace]" \
"\[InvisibleSpace]117.62366420737646`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]117.46298054434494`\),
      SequenceForm[ 
      "i,j,rij:", "*", 3, " ", 4, " ", 117.62366420737646, " corrected:", 
        117.46298054434494],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]5\[InvisibleSpace]" \
"\[InvisibleSpace]111.33731180467954`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]110.77745077256809`\),
      SequenceForm[ 
      "i,j,rij:", "*", 3, " ", 5, " ", 111.33731180467954, " corrected:", 
        110.77745077256809],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]4\
\[InvisibleSpace]" "\[InvisibleSpace]5\[InvisibleSpace]" \
"\[InvisibleSpace]114.66687786172506`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]114.51956364643797`\),
      SequenceForm[ 
      "i,j,rij:", "*", 4, " ", 5, " ", 114.66687786172506, " corrected:", 
        114.51956364643797],
      Editable->False]], "Print"],

Cell[BoxData[
    \({"np", "nchain", "mass1", "vbar1"}\)], "Print"],

Cell[BoxData[
    \({{334, {209, 272}}, 624, 628840, 0.6190159659054768`}\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1,s1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(5.465061373683697`*^-7\ \
g\)\/s, \(2.581364192961564`*^-7\ g\)\/s, 1.5341897780010402`*^-12\ s}\),
      SequenceForm[ "   ", {
        Times[ 5.4650613736836966*^-07, g, 
          Power[ s, -1]], 
        Times[ 2.5813641929615638*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.5341897780010402*^-12, s]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Chain of "\[InvisibleSpace]189\[InvisibleSpace]" \
segments,"\),
      SequenceForm[ "Chain of ", 189, " segments,"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("with displacements at segments "\[InvisibleSpace]{1, 
          64, 127}\),
      SequenceForm[ "with displacements at segments ", {1, 64, 127}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Stokes offset "\[InvisibleSpace]3.0076424054539146`\
\[InvisibleSpace]" A at "\[InvisibleSpace]50\[InvisibleSpace]" bp"\),
      SequenceForm[ 
      "Stokes offset ", 3.0076424054539146, " A at ", 50, " bp"],
      Editable->False]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
            {\("persistence\nlength"\), "510.`", "\<\"A\"\>"},
            {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
            {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
            {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
            {"\<\"turns\"\>", "1.75`", "\<\"turns\"\>"},
            {"\<\"pitch\"\>", \(-28.571`\), "\<\"A/turn\"\>"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("Array of chain lengths (bp)"\)], "Print"],

Cell[BoxData[
    \({0, 62, 62, 62}\)], "Print"],

Cell[BoxData[
    \("Array of friction element positions (bp)"\)], "Print"],

Cell[BoxData[
    \({1, 32, 64, 95, 127, 158}\)], "Print"],

Cell[BoxData[
    \("Array of Stokes radii (A)"\)], "Print"],

Cell[BoxData[
    \({56.81238789104188`, 40.885858384248856`, 56.81238789104188`, 
      40.885858384248856`, 56.81238789104188`, 
      40.885858384248856`}\)], "Print"],

Cell[BoxData[
    \("...doKirkwood..."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]" \
"\[InvisibleSpace]114.66687786172506`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]114.51956364643797`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 2, " ", 114.66687786172506, " corrected:", 
        114.51956364643797],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]216.18081933111512`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]215.09375144101062`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 3, " ", 216.18081933111512, " corrected:", 
        215.09375144101062],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]4\[InvisibleSpace]" \
"\[InvisibleSpace]177.42851600296217`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]175.5273008559039`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 4, " ", 177.42851600296217, " corrected:", 
        175.52730085590389],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]5\[InvisibleSpace]" \
"\[InvisibleSpace]207.82100286151973`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]203.99921228448463`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 5, " ", 207.82100286151973, " corrected:", 
        203.99921228448463],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]6\[InvisibleSpace]" \
"\[InvisibleSpace]245.64670725143486`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]238.95709297662984`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 6, " ", 245.64670725143486, " corrected:", 
        238.95709297662984],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]117.62366420737646`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]117.46298054434494`\),
      SequenceForm[ 
      "i,j,rij:", "*", 2, " ", 3, " ", 117.62366420737646, " corrected:", 
        117.46298054434494],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]4\[InvisibleSpace]" \
"\[InvisibleSpace]111.33731180467954`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]110.77745077256809`\),
      SequenceForm[ 
      "i,j,rij:", "*", 2, " ", 4, " ", 111.33731180467954, " corrected:", 
        110.77745077256809],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]5\[InvisibleSpace]" \
"\[InvisibleSpace]178.21424088986402`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]176.26649376934822`\),
      SequenceForm[ 
      "i,j,rij:", "*", 2, " ", 5, " ", 178.21424088986402, " corrected:", 
        176.26649376934822],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]6\[InvisibleSpace]" \
"\[InvisibleSpace]184.85807333874726`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]181.45856687382246`\),
      SequenceForm[ 
      "i,j,rij:", "*", 2, " ", 6, " ", 184.85807333874726, " corrected:", 
        181.45856687382246],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]4\[InvisibleSpace]" \
"\[InvisibleSpace]114.66687786172506`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]114.51956364643797`\),
      SequenceForm[ 
      "i,j,rij:", "*", 3, " ", 4, " ", 114.66687786172506, " corrected:", 
        114.51956364643797],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]5\[InvisibleSpace]" \
"\[InvisibleSpace]216.18081933111512`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]215.09375144101062`\),
      SequenceForm[ 
      "i,j,rij:", "*", 3, " ", 5, " ", 216.18081933111512, " corrected:", 
        215.09375144101062],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]6\[InvisibleSpace]" \
"\[InvisibleSpace]177.42851600296217`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]175.5273008559039`\),
      SequenceForm[ 
      "i,j,rij:", "*", 3, " ", 6, " ", 177.42851600296217, " corrected:", 
        175.52730085590389],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]4\
\[InvisibleSpace]" "\[InvisibleSpace]5\[InvisibleSpace]" \
"\[InvisibleSpace]117.62366420737646`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]117.46298054434494`\),
      SequenceForm[ 
      "i,j,rij:", "*", 4, " ", 5, " ", 117.62366420737646, " corrected:", 
        117.46298054434494],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]4\
\[InvisibleSpace]" "\[InvisibleSpace]6\[InvisibleSpace]" \
"\[InvisibleSpace]111.33731180467952`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]110.77745077256806`\),
      SequenceForm[ 
      "i,j,rij:", "*", 4, " ", 6, " ", 111.33731180467952, " corrected:", 
        110.77745077256806],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]5\
\[InvisibleSpace]" "\[InvisibleSpace]6\[InvisibleSpace]" \
"\[InvisibleSpace]114.66687786172506`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]114.51956364643797`\),
      SequenceForm[ 
      "i,j,rij:", "*", 5, " ", 6, " ", 114.66687786172506, " corrected:", 
        114.51956364643797],
      Editable->False]], "Print"],

Cell[BoxData[
    \({"np", "nchain", "mass1", "vbar1"}\)], "Print"],

Cell[BoxData[
    \({{189, {1, 64, 127}}, 624, 737340, 0.6382903409553259`}\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1,s1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(5.613100960523989`*^-7\ \
g\)\/s, \(2.1559699301318994`*^-7\ g\)\/s, 2.044012144761513`*^-12\ s}\),
      SequenceForm[ "   ", {
        Times[ 5.6131009605239885*^-07, g, 
          Power[ s, -1]], 
        Times[ 2.1559699301318994*^-07, g, 
          Power[ s, -1]], 
        Times[ 2.0440121447615132*^-12, s]}],
      Editable->False]], "Print"]
}, Open  ]],

Cell["Calculate sedimentation coefficients", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "8b54dffa-8e21-49b5-a682-07023b00e999"],

Cell["\<\
In the preceding doKirkwood loop output, the sedimentation \
coefficients s1 for each species (3rd value in the brackets) are calculated \
at the same time as the friction coefficients, but they were not calculated \
in the original 1995 output. In 1995, before running the loop, I apparently \
executed the cell defining doKirkwood in my library notebook manually (I did \
not yet use the \"Get\" command to load the library functions), and forgot to \
execute the cell defining the sediment[] function. This is why in the \
original output the sedimentation coefficients s1 had to be recalculated in \
this section, and at that point I must have executed the library cell \
defining the \"sediment\" function. No trace of this, however. This is an \
example of the pitfalls of \"hidden state\" in notebook computing.\
\>", \
"Text",
  CellFrame->True,
  ExpressionUUID -> "f77fd227-6c62-474a-b82d-39fe00bdd1bb",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[0.833326]],

Cell["\<\
First check \"sediment\" routine for a mononucleosome core particle\
\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "aadf60b2-f268-4aee-a75e-9a546ff1106d"],

Cell[CellGroupData[{

Cell["sediment[{1,{1}},1.09 10^-7 g/s]", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "0191a282-381b-4281-a82a-01c4fd343e60"],

Cell[BoxData[
    \({"np", "nchain", "mass1", "vbar1"}\)], "Print"],

Cell[BoxData[
    \({{1, {1}}, 146, 204860, 0.6559259982427024`}\)], "Print"],

Cell[BoxData[
    \(1.068058779603158`*^-12\ s\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "f1values={",
  StyleBox["3.69942,3.44271,3.39772,2.86755,\n            \
3.25362,2.58136,2.15597",
    FontWeight->"Plain"],
  "} 10^-7 g/s;\nDo[Print[\"\\n\",sediment[chain[[isp]],f1values[[isp]]]],\n\
{isp,Length[chain]}];"
}], "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "491321cd-3ee5-4d53-8a7a-9adadcd02bfc"],

Cell[BoxData[
    \({"np", "nchain", "mass1", "vbar1"}\)], "Print"],

Cell[BoxData[
    \({{479, {1}}, 624, 520340, 0.5917035015566745`}\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("\n"\[InvisibleSpace]\(9.498181864586445`*^-13\ s\)\),
      
      SequenceForm[ "\n", 
        Times[ 9.4981818645864448*^-13, s]],
      Editable->False]], "Print"],

Cell[BoxData[
    \({"np", "nchain", "mass1", "vbar1"}\)], "Print"],

Cell[BoxData[
    \({{479, {209}}, 624, 520340, 0.5917035015566745`}\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("\n"\[InvisibleSpace]\(1.0206425738295815`*^-12\ \
s\)\),
      SequenceForm[ "\n", 
        Times[ 1.0206425738295815*^-12, s]],
      Editable->False]], "Print"],

Cell[BoxData[
    \({"np", "nchain", "mass1", "vbar1"}\)], "Print"],

Cell[BoxData[
    \({{479, {417}}, 624, 520340, 0.5917035015566745`}\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("\n"\[InvisibleSpace]\(1.0341571393018961`*^-12\ \
s\)\),
      SequenceForm[ "\n", 
        Times[ 1.0341571393018961*^-12, s]],
      Editable->False]], "Print"],

Cell[BoxData[
    \({"np", "nchain", "mass1", "vbar1"}\)], "Print"],

Cell[BoxData[
    \({{334, {1, 64}}, 624, 628840, 0.6190159659054768`}\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("\n"\[InvisibleSpace]\(1.381075328464904`*^-12\ s\)\),
      
      SequenceForm[ "\n", 
        Times[ 1.381075328464904*^-12, s]],
      Editable->False]], "Print"],

Cell[BoxData[
    \({"np", "nchain", "mass1", "vbar1"}\)], "Print"],

Cell[BoxData[
    \({{334, {1, 272}}, 624, 628840, 0.6190159659054768`}\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("\n"\[InvisibleSpace]\(1.2171988610039082`*^-12\ \
s\)\),
      SequenceForm[ "\n", 
        Times[ 1.2171988610039082*^-12, s]],
      Editable->False]], "Print"],

Cell[BoxData[
    \({"np", "nchain", "mass1", "vbar1"}\)], "Print"],

Cell[BoxData[
    \({{334, {209, 272}}, 624, 628840, 0.6190159659054768`}\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("\n"\[InvisibleSpace]\(1.5341922700202746`*^-12\ \
s\)\),
      SequenceForm[ "\n", 
        Times[ 1.5341922700202746*^-12, s]],
      Editable->False]], "Print"],

Cell[BoxData[
    \({"np", "nchain", "mass1", "vbar1"}\)], "Print"],

Cell[BoxData[
    \({{189, {1, 64, 127}}, 624, 737340, 0.6382903409553259`}\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("\n"\[InvisibleSpace]\(2.0440120785216095`*^-12\ \
s\)\),
      SequenceForm[ "\n", 
        Times[ 2.0440120785216095*^-12, s]],
      Editable->False]], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Hydro MS Example 3: Generate sedimentation distributions for trimer\
\
\>", "Subsubsection",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "66e34c8a-7580-44a5-935b-8836e432267b"],

Cell["\<\
First use the Kovacik and van Holde to calculate the sedimentation \
of the free DNA\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "107312f5-7813-4b1b-bcee-aa5545a19e4a"],

Cell[CellGroupData[{

Cell["rYF[3 208]", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "b5ad5f73-3744-46fa-83c2-928c93be03d3"],

Cell[BoxData[
    \(197.51471778741566`\)], "Output"]
}, Open  ]],

Cell["\<\
This function rYF returns the hydrodynamic radius, not the \
sedimentation coefficient, so part of this calculation was apparently deleted \
from the notebook. I didn't pursue this further, because calculating the \
hydrodynamics of free DNA is not part of the novelty of the article. The \
correct value for 3x208 bp of free DNA is 8.1 S.\
\>", "Text",
  CellFrame->True,
  ExpressionUUID -> "cb01a7b8-97ea-4174-9a91-121338f73899",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[0.833326]],

Cell["\<\
The sedimentation coefficients as calculated above are identical to \
those  recopied to the list below, after scaling to Svedburg units of 10^-13 \
s.\
\>", "Text",
  CellFrame->True,
  ExpressionUUID -> "e7c2ca17-1672-43a8-a5d4-77ff21c9778c",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[0.833326]],

Cell["ss={8.1,9.5,10.2,10.3,13.8,12.2,15.3,20.4};", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "caaf747d-e6d7-4f36-b25f-960b78903644"],

Cell["\<\
fcoop[x_]:=Module[{a,b},
\ta=(1-x);
\tb=x;
\t{a,0,0,0,0,0,0,b}];
frand[x_]:=Module[{a,b},
\ta=(1-x);
\tb=x;
\t{a^3,a^2 b,a^2 b,a^2 b,a b^2,a b^2,a b^2,b^3}];\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "9a8c58da-12bc-4fa2-a98e-57c3442b1a23"],

Cell[CellGroupData[{

Cell["Print[MatrixForm[{ss,fcoop[0.5]}]]", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "f9a87104-33b9-4352-92d8-1227e0f452c9"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"8.1`", "9.5`", "10.2`", "10.3`", "13.8`", "12.2`", "15.3`", 
              "20.4`"},
            {"0.5`", "0", "0", "0", "0", "0", "0", "0.5`"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Print[MatrixForm[{ss,frand[0.5]}]]", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "f1761510-e5e5-4fc1-9655-178729caa3a3"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"8.1`", "9.5`", "10.2`", "10.3`", "13.8`", "12.2`", "15.3`", 
              "20.4`"},
            {"0.125`", "0.125`", "0.125`", "0.125`", "0.125`", "0.125`", 
              "0.125`", "0.125`"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"]
}, Open  ]],

Cell["\<\
The two saturation models fcoop (perfectly cooperative saturation) \
and frand (random saturation) were calculated using elementary statistics \
(see article text) and used to weight the calculated sedimentaiton \
coefficients for the plotted distributions.\
\>", "Text",
  CellFrame->True,
  ExpressionUUID -> "1dd4dddc-4a2d-421d-8409-1d6888f9f2f8",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[0.833326]],

Cell["\<\
Demonstrate that the sum of species fractions is always unity for \
both models\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "ee6e3eb8-bd76-42c8-856d-567b6bde59e7"],

Cell[CellGroupData[{

Cell["\<\
Print[Simplify[Apply[Plus,fcoop[x]]]];
Print[Simplify[Apply[Plus,frand[x]]]];\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "53a6af11-0002-4b4e-94a3-abd887eb03d7"],

Cell[BoxData[
    \({1, 1, 1, 1, 1, 1}\)], "Print"],

Cell[BoxData[
    \({1, 1, 1, 1, 1, 1}\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell["wdistribution[ss,fcoop[0.5],1,0,5,22,0,\"coop\"]", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "80094ce5-dab4-45a9-82bf-0fcb582f9190"],

Cell[BoxData[
    \({17, 1, 8}\)], "Print"],

Cell[BoxData[
    \("binned..."\)], "Print"],

Cell[BoxData[
    \("top summed..."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Average is "\[InvisibleSpace]14.25`\),
      SequenceForm[ "Average is ", 14.25],
      Editable->False]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.256303 0.0560224 0.0147151 1.17721 [
[.16387 .00222 -9 -9 ]
[.16387 .00222 9 0 ]
[.30392 .00222 -6 -9 ]
[.30392 .00222 6 0 ]
[.44398 .00222 -12 -9 ]
[.44398 .00222 12 0 ]
[.58403 .00222 -6 -9 ]
[.58403 .00222 6 0 ]
[.72409 .00222 -12 -9 ]
[.72409 .00222 12 0 ]
[.86415 .00222 -6 -9 ]
[.86415 .00222 6 0 ]
[.01131 .13244 -18 -4.5 ]
[.01131 .13244 0 4.5 ]
[.01131 .25016 -18 -4.5 ]
[.01131 .25016 0 4.5 ]
[.01131 .36788 -18 -4.5 ]
[.01131 .36788 0 4.5 ]
[.01131 .4856 -18 -4.5 ]
[.01131 .4856 0 4.5 ]
[.01131 .60332 -18 -4.5 ]
[.01131 .60332 0 4.5 ]
[.5 .63053 -14 0 ]
[.5 .63053 14 12 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16387 .01472 m
.16387 .02097 L
s
[(7.5)] .16387 .00222 0 1 Mshowa
.30392 .01472 m
.30392 .02097 L
s
[(10)] .30392 .00222 0 1 Mshowa
.44398 .01472 m
.44398 .02097 L
s
[(12.5)] .44398 .00222 0 1 Mshowa
.58403 .01472 m
.58403 .02097 L
s
[(15)] .58403 .00222 0 1 Mshowa
.72409 .01472 m
.72409 .02097 L
s
[(17.5)] .72409 .00222 0 1 Mshowa
.86415 .01472 m
.86415 .02097 L
s
[(20)] .86415 .00222 0 1 Mshowa
.125 Mabswid
.05182 .01472 m
.05182 .01847 L
s
.07983 .01472 m
.07983 .01847 L
s
.10784 .01472 m
.10784 .01847 L
s
.13585 .01472 m
.13585 .01847 L
s
.19188 .01472 m
.19188 .01847 L
s
.21989 .01472 m
.21989 .01847 L
s
.2479 .01472 m
.2479 .01847 L
s
.27591 .01472 m
.27591 .01847 L
s
.33193 .01472 m
.33193 .01847 L
s
.35994 .01472 m
.35994 .01847 L
s
.38796 .01472 m
.38796 .01847 L
s
.41597 .01472 m
.41597 .01847 L
s
.47199 .01472 m
.47199 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.52801 .01472 m
.52801 .01847 L
s
.55602 .01472 m
.55602 .01847 L
s
.61204 .01472 m
.61204 .01847 L
s
.64006 .01472 m
.64006 .01847 L
s
.66807 .01472 m
.66807 .01847 L
s
.69608 .01472 m
.69608 .01847 L
s
.7521 .01472 m
.7521 .01847 L
s
.78011 .01472 m
.78011 .01847 L
s
.80812 .01472 m
.80812 .01847 L
s
.83613 .01472 m
.83613 .01847 L
s
.89216 .01472 m
.89216 .01847 L
s
.92017 .01472 m
.92017 .01847 L
s
.94818 .01472 m
.94818 .01847 L
s
.97619 .01472 m
.97619 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13244 m
.03006 .13244 L
s
[(0.1)] .01131 .13244 1 0 Mshowa
.02381 .25016 m
.03006 .25016 L
s
[(0.2)] .01131 .25016 1 0 Mshowa
.02381 .36788 m
.03006 .36788 L
s
[(0.3)] .01131 .36788 1 0 Mshowa
.02381 .4856 m
.03006 .4856 L
s
[(0.4)] .01131 .4856 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(0.5)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .03826 m
.02756 .03826 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .08535 m
.02756 .08535 L
s
.02381 .10889 m
.02756 .10889 L
s
.02381 .15598 m
.02756 .15598 L
s
.02381 .17952 m
.02756 .17952 L
s
.02381 .20307 m
.02756 .20307 L
s
.02381 .22661 m
.02756 .22661 L
s
.02381 .2737 m
.02756 .2737 L
s
.02381 .29724 m
.02756 .29724 L
s
.02381 .32079 m
.02756 .32079 L
s
.02381 .34433 m
.02756 .34433 L
s
.02381 .39142 m
.02756 .39142 L
s
.02381 .41497 m
.02756 .41497 L
s
.02381 .43851 m
.02756 .43851 L
s
.02381 .46205 m
.02756 .46205 L
s
.02381 .50914 m
.02756 .50914 L
s
.02381 .53269 m
.02756 .53269 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .57977 m
.02756 .57977 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(coop) show
87.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.02381 .01472 m
.02381 .01472 L
.07983 .01472 L
.07983 .01472 L
F
.5 Mabswid
.02381 .01472 m
.02381 .01472 L
.07983 .01472 L
.07983 .01472 L
s
.07983 .01472 m
.07983 .01472 L
.13585 .01472 L
.13585 .01472 L
F
.07983 .01472 m
.07983 .01472 L
.13585 .01472 L
.13585 .01472 L
s
.13585 .01472 m
.13585 .01472 L
.19188 .01472 L
.19188 .01472 L
F
.13585 .01472 m
.13585 .01472 L
.19188 .01472 L
.19188 .01472 L
s
.19188 .01472 m
.19188 .60332 L
.2479 .60332 L
.2479 .01472 L
F
.19188 .01472 m
.19188 .60332 L
.2479 .60332 L
.2479 .01472 L
s
.2479 .01472 m
.2479 .01472 L
.30392 .01472 L
.30392 .01472 L
F
.2479 .01472 m
.2479 .01472 L
.30392 .01472 L
.30392 .01472 L
s
.30392 .01472 m
.30392 .01472 L
.35994 .01472 L
.35994 .01472 L
F
.30392 .01472 m
.30392 .01472 L
.35994 .01472 L
.35994 .01472 L
s
.35994 .01472 m
.35994 .01472 L
.41597 .01472 L
.41597 .01472 L
F
.35994 .01472 m
.35994 .01472 L
.41597 .01472 L
.41597 .01472 L
s
.41597 .01472 m
.41597 .01472 L
.47199 .01472 L
.47199 .01472 L
F
.41597 .01472 m
.41597 .01472 L
.47199 .01472 L
.47199 .01472 L
s
.47199 .01472 m
.47199 .01472 L
.52801 .01472 L
.52801 .01472 L
F
.47199 .01472 m
.47199 .01472 L
.52801 .01472 L
.52801 .01472 L
s
.52801 .01472 m
.52801 .01472 L
.58403 .01472 L
.58403 .01472 L
F
.52801 .01472 m
.52801 .01472 L
.58403 .01472 L
.58403 .01472 L
s
.58403 .01472 m
.58403 .01472 L
.64006 .01472 L
.64006 .01472 L
F
.58403 .01472 m
.58403 .01472 L
.64006 .01472 L
.64006 .01472 L
s
.64006 .01472 m
.64006 .01472 L
.69608 .01472 L
.69608 .01472 L
F
.64006 .01472 m
.64006 .01472 L
.69608 .01472 L
.69608 .01472 L
s
.69608 .01472 m
.69608 .01472 L
.7521 .01472 L
.7521 .01472 L
F
.69608 .01472 m
.69608 .01472 L
.7521 .01472 L
.7521 .01472 L
s
.7521 .01472 m
.7521 .01472 L
.80812 .01472 L
.80812 .01472 L
F
.7521 .01472 m
.7521 .01472 L
.80812 .01472 L
.80812 .01472 L
s
.80812 .01472 m
.80812 .01472 L
.86415 .01472 L
.86415 .01472 L
F
.80812 .01472 m
.80812 .01472 L
.86415 .01472 L
.86415 .01472 L
s
.86415 .01472 m
.86415 .60332 L
.92017 .60332 L
.92017 .01472 L
F
.86415 .01472 m
.86415 .60332 L
.92017 .60332 L
.92017 .01472 L
s
.92017 .01472 m
.92017 .01472 L
.97619 .01472 L
.97619 .01472 L
F
.92017 .01472 m
.92017 .01472 L
.97619 .01472 L
.97619 .01472 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`00012R000`400?l00000o`00003ooooooona
ooooo`00oooooonaooooo`00oooooonaooooo`00Foooool00ooMgMgo0000omgMg@06ooooo`03oiRH
V?l0003oEEEE00Cooooo00Koc<c<ob4Q8Ol0003o0000oc8b<_oMgMdQooooo`03oa0@4?l0003o0000
00;o000000?ogMgMooooooooool00_ooool01?mVIVKo0000oc8b<_o^k^hMooooo`03oa0@4?l0003o
000000;o000000CogMgMooooooooooooQhN71?l000000ol@413oooooooooo`03ooooo`03oiRHV?l0
003oEEEE00Cooooo00Koc<c<ob4Q8Ol0003o0000oc8b<_oMgMdNooooo`03oa0@4?l0003o000000;o
000000GogMgMooooooooooooc<c<ob4Q8@02o`000003oc8b<_oMgMgooooo01cooooo00?o410@o`00
0?l000000_l000000ooMgMgoooooooooo`02ooooo`03omgMgOl0003ogMgM00Kooooo00?oV9RHo`00
0?mEEED01?ooool01_o<c<co8B4Qo`000?l0003o<S8bomgMgAcooooo00?oQhN7o`000?l000000_l0
00000ol@413oooooooooo`03ooooo`04ofIVI_l0003o<S8bonk^kSoooooo001Looooo`03oc8b<_n7
QhOooooo00Gooooo00?o<S8bo`000?l000001?ooool01_o<c<coZJVYooooooooooooV9RHob4Q8B?o
oooo00?o0000ooooooooool01?ooool2ohN7Q`03oooooon7QhOoA4A401oooooo00?o0000oooooooo
ool00oooool00oo^k^ko<S8bolc<c008ooooo`03oc8b<_l0003o000000Cooooo00Koc<c<ojVYZOoo
oooooooooiRHV?lQ8B4Pooooo`03o`000?oooooooooo00?ooooo00Koc<c<ojVYZOoooooooooooiRH
V?lQ8B4Oooooo`03o`000?oooooooooo00Kooooo00?o<S8bohN7Qoooool01Oooool00olb<S;o0000
o`000004ooooo`06olc<c?nYZJWooooooooooonHV9So8B4Q7?ooool00oo^k^ko<S8bolc<c007oooo
o`;oQhN700?oooooohN7Qom4A4@0?oooool005cooooo00?oV9RHob4Q8Oooool01Oooool00onYZJWo
8B4QogMgM`09ooooo`03ob4Q8Onj^[[ooooo027ooooo00?o0000ooooooooool01?ooool01Olb<S;o
oooooooooooooooo000001oooooo00?o0000ooooooooool01?ooool00oo^k^ko<S8bojVYZ@07oooo
o`03ojVYZOlQ8B7oMgMg00Wooooo00?o8B4QokZj^_ooool07_ooool00ol0003oooooooooo`08oooo
o`03ob4Q8Onj^[[ooooo01gooooo00?o0000ooooooooool01_ooool00onHV9So8B4Qooooo`05oooo
o`03ojVYZOlQ8B7oMgMg00Wooooo00?o8B4QokZj^_ooool06oooool00oo^k^ko<S8bojVYZ@06oooo
o`05oc8b<_ooooooooooooooool00000?oooool005cooooo00?ok^k^o`000?o<c<`04Oooool00olQ
8B7o^[Zjooooo`0Qooooo`03o`000?oooooooooo00Cooooo00Ko<S8boooooooooooooooooc8b<_nj
^[XNooooo`03o`000?oooooooooo00Gooooo00?ok^k^ob4Q8OnHV9P04_ooool00olQ8B7o^[Zjoooo
o`0Nooooo`03o`000?oooooooooo00Sooooo00?o8B4QokZj^_ooool07Oooool00ol0003ooooooooo
o`06ooooo`03onk^k_l0003oc<c<017ooooo00?o8B4QokZj^_ooool07?ooool00oo^k^ko8B4QoiRH
V005ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj?_ooool005gooooo00?oEEEEofIVI_ooool0
3?ooool01OmVIVKogMgMoooooon7QhOo410@02?ooooo00?o0000ooooooooool01?ooool01_lb<S;o
oooooooooooooooo<S8bokZj^Qkooooo00?o0000ooooooooool01_ooool00oo^k^ko<S8bolc<c00=
ooooo`05ofIVI_oMgMgoooooohN7Qol@41008?ooool00ol0003oooooooooo`04ooooo`05ofIVI_oM
gMgoooooohN7Qol@41007oooool00ol0003oooooooooo`07ooooo`03oeEEEOmVIVKooooo00cooooo
00GoIVIVomgMgOooooooQhN7oa0@400Oooooo`03onk^k_lb<S;oc<c<00Cooooo00Ko<S8boooooooo
oooooooooc8b<_nj^[Xnooooo`00GOooool00onj^[[o410@ooooo`0<ooooo`05o`000?lQ8B7o0000
oa0@4?o<c<`08oooool00ol0003oooooooooo`04ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj
7_ooool00ol0003oooooooooo`07ooooo`03onk^k_m4A4Cooooo00cooooo00Go0000ob4Q8Ol0003o
410@olc<c00Pooooo`03o`000?oooooooooo00Cooooo00Go0000ob4Q8Ol0003o410@olc<c00Ooooo
o`03o`000?oooooooooo00Oooooo00?o^[Zjoa0@4?ooool03?ooool01Ol0003o8B4Qo`000?l@413o
c<c<023ooooo00?ok^k^odA4A?ooool00oooool01_lb<S;ooooooooooooooooo<S8bokZj^Skooooo
001Nooooo`03oa0@4?o<c<cooooo00_ooooo00?o0000ooooooooool09Oooool00ol0003ooooooooo
o`04ooooo`05oc8b<_o^k^koooooonk^k_l000007oooool00ol0003oooooooooo`04ooooo`05okZj
^_oooooooooooooooolb<S803Oooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`08ooooo`03oa0@4?o<c<cooooo00_o
oooo00?o0000ooooooooool07oooool01Onj^[[ooooooooooooooooo<S8b00Cooooo00Go<S8bonk^
k_ooooook^k^o`00000oooooo`00G_ooool00on7QhOoIVIVooooo`0;ooooo`03o`000?oooooooooo
02?ooooo00?oQhN7okZj^_l000001_ooool01On7QhOoIVIVoooooomVIVKoA4A401gooooo00?oQhN7
okZj^_l000001Oooool01_o<c<co0000ohN7Qooooooo^[Zjob4Q8@gooooo00?o0000ooooooooool0
8?ooool00on7QhOo^[Zjo`000006ooooo`03o`000?oooooooooo01oooooo00?oQhN7okZj^_l00000
2_ooool00on7QhOoIVIVooooo`0;ooooo`03o`000?oooooooooo01kooooo00Koc<c<o`000?n7QhOo
oooookZj^_lQ8B44ooooo`05ohN7QomVIVKoooooofIVI_m4A4@0?oooool005[ooooo1Ol000000olb
<S;oooooooooo`0:ooooo`Co000000?o410@ooooooooool07oooool00on7QhOo<S8bo`000007oooo
o`04ofIVI_l0003o<S8bonk^kQgooooo00?oQhN7oc8b<_l000001_ooool01OnYZJWo8B4Qo`000?l@
413oc<c<00gooooo1?l000000ol@413oooooooooo`0Looooo`03ohN7Qolb<S;o000000Kooooo1?l0
00000ol@413oooooooooo`0Kooooo`03ohN7Qolb<S;o000000Kooooo1Ol000000olb<S;ooooooooo
o`0:ooooo`Co000000?o410@ooooooooool06oooool01OnYZJWo8B4Qo`000?l@413oc<c<00Gooooo
00CoIVIVo`000?lb<S;ok^k^?oooool0037ooooo00?o0000ooooooooool0oooooommooooo`00<Ooo
ool00ol0003oooooooooo`3ooooooggooooo000aooooo`03o`000?oooooooooo0?ooooooOOooool0
037ooooo00?o0000ooooooooool0oooooommooooo`00<Oooool00ol0003oooooooooo`3ooooooggo
oooo000aooooo`03o`000?oooooooooo0?ooooooOOooool002Soooooool0001go`0001;ooooo000a
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07
oooooaKo00002_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool01ooooolFo`0000[ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0I
ooooo`00<Oooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo00Oooooo5_l0000Doooo
o`03o`000?oooooooooo037ooooo00?o0000ooooooooool0<_ooool00ol0003oooooooooo`0aoooo
o`03o`000?oooooooooo037ooooo5_l0000`ooooo`00<Oooool00ol0003oooooooooo`0koooooaKo
0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000
<?ooool0037ooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool0
0ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooooooo
03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o0000ooooooooool0>ooooolFo`000>Go
oooo5_l0000`ooooo`00<Oooool2o`0003cooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o
0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0003oooooooooo`0k
oooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooooooo03_ooooo5_l0003Uoooo
oaKo0000<?ooool0037ooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00
<Oooool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oo
oooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o0000ooooooooool0>ooooolF
o`000>Gooooo5_l0000`ooooo`00<Oooool2o`0003cooooo5_l0003UoooooaKo0000<?ooool0037o
oooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0003ooooo
ooooo`0koooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooooooo03_ooooo5_l0
003UoooooaKo0000<?ooool0037ooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`
ooooo`00<Oooool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000aooooo`03
o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o0000ooooooooool0
>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0003oooooooooo`0koooooaKo0000iOoo
oolFo`00033ooooo000aooooo`;o0000??oooolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0
003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooooooo03_o
oooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo
5_l0000`ooooo`00<Oooool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000a
ooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o0000oooo
ooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0003oooooooooo`0koooooaKo
0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000
<?ooool0037ooooo0_l0000loooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooo
oooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o0000ooooooooool0>ooooolFo`00
0>Gooooo5_l0000`ooooo`00<Oooool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033o
oooo000aooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o
0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`005?ooool01?mVIVKo0000oc8b<_o^
k^h5ooooo`03oiRHV?l0003oEEEE00Gooooo00?o410@o`000?l000000_l000000ooMgMgooooooooo
o`04ooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool001?ooooo0_n7QhL0
0oooooooQhN7odA4A005ooooo`03oc8b<_l0003o000000Oooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000Cooooo`05oc8b<_oooooooooo
ooooool000001Oooool00onYZJWo8B4QogMgM`07ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`004oooool01_lb<S;ooooooooooooooooo
<S8bokZj^Pkooooo00?o0000ooooooooool01oooool3o`0003_ooooo5_l0003UoooooaKo0000<?oo
ool001?ooooo00Ko<S8boooooooooooooooooc8b<_nj^[X>ooooo`03o`000?oooooooooo00Oooooo
00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`004oooool01_lb<S;ooooooooo
oooooooo<S8bokZj^Pkooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0koooooaKo
0000iOoooolFo`00033ooooo000Cooooo`05oc8b<_o^k^koooooonk^k_l000003oooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool001?ooooo
00GoQhN7ofIVI_ooooooIVIVodA4A00=ooooo`03ohN7Qonj^[[o000000Wooooo00?o0000oooooooo
ool0>ooooolFo`000>Gooooo5_l0000`ooooo`005?ooool01?mVIVKo0000oc8b<_o^k^h=ooooo`03
ohN7Qolb<S;o000000Wooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00
<Oooool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oo
oooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo0_l0000loooooaKo0000iOoooolF
o`00033ooooo000aooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0037o
oooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0003ooooo
ooooo`0koooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooooooo03_ooooo5_l0
003UoooooaKo0000<?ooool0037ooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`
ooooo`00<Oooool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000aooooo`03
o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o0000ooooooooool0
>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool2o`0003cooooo5_l0003UoooooaKo0000<?oo
ool0037ooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0
003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooooooo03_o
oooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo
5_l0000`ooooo`00<Oooool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000a
ooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o0000oooo
ooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0003oooooooooo`0koooooaKo
0000iOoooolFo`00033ooooo000aooooo`;o0000??oooolFo`000>Gooooo5_l0000`ooooo`00<Ooo
ool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooo
oooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o0000ooooooooool0>ooooolFo`00
0>Gooooo5_l0000`ooooo`00<Oooool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033o
oooo000aooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o
0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0003oooooooooo`0k
oooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooooooo03_ooooo5_l0003Uoooo
oaKo0000<?ooool0037ooooo0_l0000loooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`00
0?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o0000ooooooooool0>ooo
oolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0003oooooooooo`0koooooaKo0000iOoooolF
o`00033ooooo000aooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0037o
oooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`005?ooool01?mVIVKo0000
oc8b<_o^k^h5ooooo`03oiRHV?l0003oEEEE00Cooooo00?oQhN7o`000?l000000_l000000ol@413o
ooooooooo`05ooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool001?ooooo
0_n7QhL00oooooooQhN7odA4A005ooooo`03oc8b<_l0003o000000Cooooo00?ok^k^oc8b<_o<c<`0
2_ooool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000Cooooo`05oc8b<_oo
ooooooooooooool000001Oooool00onYZJWo8B4QogMgM`05ooooo`03onk^k_lb<S;oZJVY00Wooooo
00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`004oooool01_lb<S;ooooooooo
oooooooo<S8bokZj^Pgooooo00?ok^k^ob4Q8OnHV9P02?ooool3o`0003_ooooo5_l0003UoooooaKo
0000<?ooool001?ooooo00Ko<S8boooooooooooooooooc8b<_nj^[X>ooooo`03onk^k_lb<S;oc<c<
00Oooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`004oooool01_lb<S;o
oooooooooooooooo<S8bokZj^Poooooo00?ok^k^odA4A?ooool01_ooool00ol0003oooooooooo`0k
oooooaKo0000iOoooolFo`00033ooooo000Cooooo`05oc8b<_o^k^koooooonk^k_l000003Oooool0
1Onj^[[ooooooooooooooooo<S8b00Oooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0
000`ooooo`004oooool01On7QhOoIVIVoooooomVIVKoA4A400cooooo00Koc<c<o`000?n7QhOooooo
okZj^_lQ8B47ooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool001Cooooo
00CoIVIVo`000?lb<S;ok^k^3Oooool01OnYZJWo8B4Qo`000?l@413oc<c<00Oooooo00?o0000oooo
ooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0003oooooooooo`0koooooaKo
0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000
<?ooool0037ooooo0_l0000loooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooo
oooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o0000ooooooooool0>ooooolFo`00
0>Gooooo5_l0000`ooooo`00<Oooool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033o
oooo000aooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o
0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0003oooooooooo`0k
oooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooooooo03_ooooo5_l0003Uoooo
oaKo0000<?ooool0037ooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00
<Oooool2o`0003cooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o0000ooooooooool0>ooo
oolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0003oooooooooo`0koooooaKo0000iOoooolF
o`00033ooooo000aooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0037o
oooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0003ooooo
ooooo`0koooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooooooo03_ooooo5_l0
003UoooooaKo0000<?ooool0037ooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`
ooooo`00<Oooool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000aooooo`;o
0000??oooolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0003oooooooooo`0koooooaKo0000
iOoooolFo`00033ooooo000aooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?oo
ool0037ooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0
003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooooooo03_o
oooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo
5_l0000`ooooo`00<Oooool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000a
ooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo0_l0000loooo
oaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo
0000<?ooool0037ooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Ooo
ool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooo
oooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o0000ooooooooool0>ooooolFo`00
0>Gooooo5_l0000`ooooo`005?ooool01?mVIVKo0000oc8b<_o^k^h5ooooo`03oiRHV?l0003oEEEE
00Cooooo00Ko^[ZjodA4A?l0003o0000ob4Q8Oo<c<`7ooooo`03o`000?oooooooooo03_ooooo5_l0
003UoooooaKo0000<?ooool001?ooooo0_n7QhL00oooooooQhN7odA4A005ooooo`03oc8b<_l0003o
000000Cooooo00OoZJVYoiRHV?oooooooooookZj^_l0003ok^k^00Kooooo00?o0000ooooooooool0
>ooooolFo`000>Gooooo5_l0000`ooooo`004oooool01Olb<S;ooooooooooooooooo000000Gooooo
00?oZJVYob4Q8OmgMgL02Oooool00olb<S;o^[Zjooooo`05ooooo`03o`000?oooooooooo03_ooooo
5_l0003UoooooaKo0000<?ooool001?ooooo00Ko<S8boooooooooooooooooc8b<_nj^[X?ooooo`03
onk^k_l0003ogMgM00Kooooo0ol0000koooooaKo0000iOoooolFo`00033ooooo000Cooooo`06oc8b
<_oooooooooooooooolb<S;o^[Zj3_ooool00omVIVKo410@ohN7Q`07ooooo`03o`000?oooooooooo
03_ooooo5_l0003UoooooaKo0000<?ooool001?ooooo00Ko<S8boooooooooooooooooc8b<_nj^[X>
ooooo`03omgMgOmgMgOoIVIV00Oooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`
ooooo`004oooool01Olb<S;ok^k^ooooooo^k^ko0000017ooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000Cooooo`05ohN7QomVIVKooooo
ofIVI_m4A4@03Oooool01Om4A4Co^[ZjoooooonHV9So410@00Oooooo00?o0000ooooooooool0>ooo
oolFo`000>Gooooo5_l0000`ooooo`005?ooool01?mVIVKo0000oc8b<_o^k^h=ooooo`05ohN7Qol@
413o0000oa0@4?o<c<`01oooool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo
000aooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o0000
ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool2o`0003cooooo5_l0003Uoooo
oaKo0000<?ooool0037ooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00
<Oooool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oo
oooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o0000ooooooooool0>ooooolF
o`000>Gooooo5_l0000`ooooo`00<Oooool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00
033ooooo000aooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo
00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0003ooooooooo
o`0koooooaKo0000iOoooolFo`00033ooooo000aooooo`;o0000??oooolFo`000>Gooooo5_l0000`
ooooo`00<Oooool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000aooooo`03
o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o0000ooooooooool0
>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0003oooooooooo`0koooooaKo0000iOoo
oolFo`00033ooooo000aooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0
037ooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0003o
ooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooooooo03_ooooo
5_l0003UoooooaKo0000<?ooool0037ooooo0_l0000loooooaKo0000iOoooolFo`00033ooooo000a
ooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o0000oooo
ooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0003oooooooooo`0koooooaKo
0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000
<?ooool0037ooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool0
0ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooooooo
03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o0000ooooooooool0>ooooolFo`000>Go
oooo5_l0000`ooooo`00<Oooool2o`0003cooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o
0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0003oooooooooo`0k
oooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooooooo03_ooooo5_l0003Uoooo
oaKo0000<?ooool0037ooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00
<Oooool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000Dooooo`04ofIVI_l0
003o<S8bonk^kPGooooo00?oV9RHo`000?mEEED01oooool3o`0000Oooooo00?o0000ooooooooool0
>ooooolFo`000>Gooooo5_l0000`ooooo`004oooool2ohN7Q`03oooooon7QhOoA4A400Gooooo00?o
<S8bo`000?l000002?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo03_ooooo5_l0
003UoooooaKo0000<?ooool001?ooooo00Go<S8booooooooooooooooo`000005ooooo`03ojVYZOlQ
8B7oMgMg00Cooooo00?o<S8bo`000?l000000ol00007ooooo`?o0000>ooooolFo`000>Gooooo5_l0
000`ooooo`004oooool01_lb<S;ooooooooooooooooo<S8bokZj^P_ooooo00KoEEEEogMgMooooooo
ooooo`000?oMgMd7ooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool001?o
oooo00Ko<S8boooooooooooooooooc8b<_nj^[X;ooooo`05onk^k_l0003ogMgMooooool000002?oo
ool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000Cooooo`06oc8b<_oooooo
oooooooooolb<S;o^[Zj3?ooool01?nHV9SoA4A4ooooool00008ooooo`03o`000?oooooooooo03_o
oooo5_l0003UoooooaKo0000<?ooool001?ooooo00Go<S8bonk^k_ooooook^k^o`00000>ooooo`03
oc8b<_nj^[[o000000Sooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00
4oooool01On7QhOoIVIVoooooomVIVKoA4A400kooooo00?oc<c<ob4Q8Ol000002?ooool00ol0003o
ooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000Dooooo`04ofIVI_l0003o<S8bonk^kPoo
oooo00?oIVIVo`000?ooool01oooool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033o
oooo000aooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o
0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool2o`0003cooooo5_l0003U
oooooaKo0000<?ooool0037ooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`oooo
o`00<Oooool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`00
0?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o0000ooooooooool0>ooo
oolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0003oooooooooo`0koooooaKo0000iOoooolF
o`00033ooooo000aooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0037o
oooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0003ooooo
ooooo`0koooooaKo0000iOoooolFo`00033ooooo000aooooo`;o0000??oooolFo`000>Gooooo5_l0
000`ooooo`00<Oooool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000aoooo
o`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o0000oooooooo
ool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0003oooooooooo`0koooooaKo0000
iOoooolFo`00033ooooo000aooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?oo
ool0037ooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0
003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooooooo03_o
oooo5_l0003UoooooaKo0000<?ooool0037ooooo0_l0000loooooaKo0000iOoooolFo`00033ooooo
000aooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o0000
ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0003oooooooooo`0koooo
oaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooooooo03_ooooo5_l0003UoooooaKo
0000<?ooool0037ooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Ooo
ool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooo
oooo03_ooooo5_l0003UoooooaKo0000<?ooool0037ooooo00?o0000ooooooooool0>ooooolFo`00
0>Gooooo5_l0000`ooooo`00<Oooool2o`0003cooooo5_l0003UoooooaKo0000<?ooool0037ooooo
00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`00<Oooool00ol0003ooooooooo
o`0koooooaKo0000iOoooolFo`00033ooooo000aooooo`03o`000?oooooooooo03_ooooo5_l0003U
oooooaKo0000<?ooool0037ooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`oooo
o`00<Oooool00ol0003oooooooooo`0koooooaKo0000iOoooolFo`00033ooooo000Dooooo`04ofIV
I_l0003o<S8bonk^kPGooooo00?oV9RHo`000?mEEED01?ooool01_o<c<co8B4Qo`000?l0003o<S8b
omgMg@Oooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`004oooool2ohN7
Q`03oooooon7QhOoA4A400Gooooo00?o<S8bo`000?l000001?ooool01_o<c<coZJVYoooooooooooo
V9RHob4Q8@Oooooo00?o0000ooooooooool0>ooooolFo`000>Gooooo5_l0000`ooooo`004oooool0
1Olb<S;ooooooooooooooooo000000Gooooo00?oZJVYob4Q8OmgMgL02Oooool00olQ8B7o^[Zjoooo
o`05ooooo`?o0000>ooooolFo`000>Gooooo5_l0000`ooooo`004oooool01_lb<S;ooooooooooooo
oooo<S8bokZj^Q3ooooo00?o8B4QokZj^_ooool01Oooool00ol0003oooooooooo`3ooooooggooooo
000Cooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj3?ooool01OmVIVKogMgMoooooon7QhOo410@
00Oooooo00?o0000ooooooooool0oooooommooooo`004oooool01_lb<S;ooooooooooooooooo<S8b
okZj^Pcooooo00Go0000ob4Q8Ol0003o410@olc<c007ooooo`03o`000?oooooooooo0?ooooooOOoo
ool001?ooooo00Go<S8bonk^k_ooooook^k^o`00000=ooooo`03o`000?oooooooooo00Wooooo00?o
0000ooooooooool0oooooommooooo`004oooool01On7QhOoIVIVoooooomVIVKoA4A400gooooo00?o
0000ooooooooool02Oooool00ol0003oooooooooo`3ooooooggooooo000Dooooo`04ofIVI_l0003o
<S8bonk^kPgooooo1?l000000ol@413oooooooooo`05ooooo`03o`000?oooooooooo0?ooooooOOoo
ool00?oooooo/Oooool00?oooooo/Oooool00?oooooo/Oooool00?oooooo/Oooool00?oooooo/Ooo
ool00?oooooo/Oooool00>cooooo0ol000000olb<S;oooooooooo`2nooooo`00k?ooool00onj^[[o
0000ooooo`31ooooo`00k?ooool00onj^[[o0000ooooo`31ooooo`00d_ooool01_mVIVKo0000o`00
0?lQ8B7oMgMgonk^kP?ooooo00KoQhN7oa0@4?l0003o0000ofIVI_o^k^h3ooooo`06ohN7Qol@413o
0000o`000?mVIVKok^k^0_ooool00onj^[[o0000oiRHV002o`000003ofIVI_oooooooooo0;cooooo
003Aooooo`07ogMgMomEEEGooooooooooooMgMgo8B4QogMgM`02ooooo`07ohN7QomEEEGok^k^oooo
ooo^k^koEEEEodA4A002ooooo`07ohN7QomEEEGok^k^ooooooo^k^koEEEEodA4A002ooooo`03okZj
^_l0003oMgMg00;ooooo0_mgMgNmooooo`00dOooool00olQ8B7oooooooooo`06ooooo`03ob4Q8Ooo
oooooooo00?ooooo00Co0000omgMgOoooooo8B4Q1Oooool01Ol0003ogMgMoooooonj^[[o410@00Co
oooo00?o8B4Qooooooooool0^oooool00=7ooooo00?o<S8booooooooool01_ooool00olb<S;ooooo
ooooo`03ooooo`04oc8b<_nj^[[ooooooc8b<PGooooo00Go<S8bokZj^_oooooo^[Zjoc8b<P04oooo
o`03oc8b<_oooooooooo0;_ooooo003Aooooo`03ob4Q8Ooooooooooo00;ooooo00GoMgMgoiRHV?oo
ooooooooob4Q8@05ooooo`04o`000?oMgMgoooooob4Q8@Gooooo00Ko0000omgMgOoooooo^[Zjo`00
0?o^k^h2ooooo`03onk^k_lQ8B7ooooo0;cooooo003Aooooo`07ogMgMomEEEGok^k^oooooonj^[[o
0000ogMgM`02ooooo`05ohN7QomEEEGok^k^ooooooo^k^h00_mEEED2ooooo`05ohN7QomEEEGok^k^
ooooooo^k^h00_mEEED2ooooo`03okZj^_l0003oA4A400;ogMgM00?oA4A4ogMgMoooool0_?ooool0
0=;ooooo00?oIVIVo`000?l000000_lQ8B401_mgMgOoooooooooooooooooQhN7oa0@40;o000000?o
MgMgooooooooool00_ooool01On7QhOo410@o`000?l0003oMgMg00?ooooo00?o410@o`000?mgMgL0
0_l000000omVIVKoooooooooo`2looooo`00oooooonaooooo`00oooooonaooooo`00oooooonaoooo
o`00oooooonaooooo`00oooooonaooooo`00oooooonaooooo`00\
\>"],
  ImageRangeCache->{{{73.4375, 302.812}, {728.625, 587.312}} -> {-3.99292, \
2.47608, 0.0720599, 0.00342927}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["wdistribution[ss,frand[0.5],1,0,5,22,1,\"rand\"]", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "cdfde070-6886-40d1-b8f2-97acac1ec2d0"],

Cell[BoxData[
    \({17, 1, 8}\)], "Print"],

Cell[BoxData[
    \("binned..."\)], "Print"],

Cell[BoxData[
    \("top summed..."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Average is "\[InvisibleSpace]12.475000000000001`\),
      SequenceForm[ "Average is ", 12.475000000000001],
      Editable->False]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.256303 0.0560224 0.0147151 2.35442 [
[.16387 .00222 -9 -9 ]
[.16387 .00222 9 0 ]
[.30392 .00222 -6 -9 ]
[.30392 .00222 6 0 ]
[.44398 .00222 -12 -9 ]
[.44398 .00222 12 0 ]
[.58403 .00222 -6 -9 ]
[.58403 .00222 6 0 ]
[.72409 .00222 -12 -9 ]
[.72409 .00222 12 0 ]
[.86415 .00222 -6 -9 ]
[.86415 .00222 6 0 ]
[.01131 .13244 -24 -4.5 ]
[.01131 .13244 0 4.5 ]
[.01131 .25016 -18 -4.5 ]
[.01131 .25016 0 4.5 ]
[.01131 .36788 -24 -4.5 ]
[.01131 .36788 0 4.5 ]
[.01131 .4856 -18 -4.5 ]
[.01131 .4856 0 4.5 ]
[.01131 .60332 -24 -4.5 ]
[.01131 .60332 0 4.5 ]
[.5 .63053 -14 0 ]
[.5 .63053 14 12 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16387 .01472 m
.16387 .02097 L
s
[(7.5)] .16387 .00222 0 1 Mshowa
.30392 .01472 m
.30392 .02097 L
s
[(10)] .30392 .00222 0 1 Mshowa
.44398 .01472 m
.44398 .02097 L
s
[(12.5)] .44398 .00222 0 1 Mshowa
.58403 .01472 m
.58403 .02097 L
s
[(15)] .58403 .00222 0 1 Mshowa
.72409 .01472 m
.72409 .02097 L
s
[(17.5)] .72409 .00222 0 1 Mshowa
.86415 .01472 m
.86415 .02097 L
s
[(20)] .86415 .00222 0 1 Mshowa
.125 Mabswid
.05182 .01472 m
.05182 .01847 L
s
.07983 .01472 m
.07983 .01847 L
s
.10784 .01472 m
.10784 .01847 L
s
.13585 .01472 m
.13585 .01847 L
s
.19188 .01472 m
.19188 .01847 L
s
.21989 .01472 m
.21989 .01847 L
s
.2479 .01472 m
.2479 .01847 L
s
.27591 .01472 m
.27591 .01847 L
s
.33193 .01472 m
.33193 .01847 L
s
.35994 .01472 m
.35994 .01847 L
s
.38796 .01472 m
.38796 .01847 L
s
.41597 .01472 m
.41597 .01847 L
s
.47199 .01472 m
.47199 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.52801 .01472 m
.52801 .01847 L
s
.55602 .01472 m
.55602 .01847 L
s
.61204 .01472 m
.61204 .01847 L
s
.64006 .01472 m
.64006 .01847 L
s
.66807 .01472 m
.66807 .01847 L
s
.69608 .01472 m
.69608 .01847 L
s
.7521 .01472 m
.7521 .01847 L
s
.78011 .01472 m
.78011 .01847 L
s
.80812 .01472 m
.80812 .01847 L
s
.83613 .01472 m
.83613 .01847 L
s
.89216 .01472 m
.89216 .01847 L
s
.92017 .01472 m
.92017 .01847 L
s
.94818 .01472 m
.94818 .01847 L
s
.97619 .01472 m
.97619 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13244 m
.03006 .13244 L
s
[(0.05)] .01131 .13244 1 0 Mshowa
.02381 .25016 m
.03006 .25016 L
s
[(0.1)] .01131 .25016 1 0 Mshowa
.02381 .36788 m
.03006 .36788 L
s
[(0.15)] .01131 .36788 1 0 Mshowa
.02381 .4856 m
.03006 .4856 L
s
[(0.2)] .01131 .4856 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(0.25)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .03826 m
.02756 .03826 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .08535 m
.02756 .08535 L
s
.02381 .10889 m
.02756 .10889 L
s
.02381 .15598 m
.02756 .15598 L
s
.02381 .17952 m
.02756 .17952 L
s
.02381 .20307 m
.02756 .20307 L
s
.02381 .22661 m
.02756 .22661 L
s
.02381 .2737 m
.02756 .2737 L
s
.02381 .29724 m
.02756 .29724 L
s
.02381 .32079 m
.02756 .32079 L
s
.02381 .34433 m
.02756 .34433 L
s
.02381 .39142 m
.02756 .39142 L
s
.02381 .41497 m
.02756 .41497 L
s
.02381 .43851 m
.02756 .43851 L
s
.02381 .46205 m
.02756 .46205 L
s
.02381 .50914 m
.02756 .50914 L
s
.02381 .53269 m
.02756 .53269 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .57977 m
.02756 .57977 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(rand) show
87.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
1 g
.02381 .01472 m
.02381 .01472 L
.07983 .01472 L
.07983 .01472 L
F
0 g
.5 Mabswid
.02381 .01472 m
.02381 .01472 L
.07983 .01472 L
.07983 .01472 L
s
1 g
.07983 .01472 m
.07983 .01472 L
.13585 .01472 L
.13585 .01472 L
F
0 g
.07983 .01472 m
.07983 .01472 L
.13585 .01472 L
.13585 .01472 L
s
1 g
.13585 .01472 m
.13585 .01472 L
.19188 .01472 L
.19188 .01472 L
F
0 g
.13585 .01472 m
.13585 .01472 L
.19188 .01472 L
.19188 .01472 L
s
1 g
.19188 .01472 m
.19188 .30902 L
.2479 .30902 L
.2479 .01472 L
F
0 g
.19188 .01472 m
.19188 .30902 L
.2479 .30902 L
.2479 .01472 L
s
1 g
.2479 .01472 m
.2479 .30902 L
.30392 .30902 L
.30392 .01472 L
F
0 g
.2479 .01472 m
.2479 .30902 L
.30392 .30902 L
.30392 .01472 L
s
1 g
.30392 .01472 m
.30392 .60332 L
.35994 .60332 L
.35994 .01472 L
F
0 g
.30392 .01472 m
.30392 .60332 L
.35994 .60332 L
.35994 .01472 L
s
1 g
.35994 .01472 m
.35994 .01472 L
.41597 .01472 L
.41597 .01472 L
F
0 g
.35994 .01472 m
.35994 .01472 L
.41597 .01472 L
.41597 .01472 L
s
1 g
.41597 .01472 m
.41597 .30902 L
.47199 .30902 L
.47199 .01472 L
F
0 g
.41597 .01472 m
.41597 .30902 L
.47199 .30902 L
.47199 .01472 L
s
1 g
.47199 .01472 m
.47199 .30902 L
.52801 .30902 L
.52801 .01472 L
F
0 g
.47199 .01472 m
.47199 .30902 L
.52801 .30902 L
.52801 .01472 L
s
1 g
.52801 .01472 m
.52801 .01472 L
.58403 .01472 L
.58403 .01472 L
F
0 g
.52801 .01472 m
.52801 .01472 L
.58403 .01472 L
.58403 .01472 L
s
1 g
.58403 .01472 m
.58403 .30902 L
.64006 .30902 L
.64006 .01472 L
F
0 g
.58403 .01472 m
.58403 .30902 L
.64006 .30902 L
.64006 .01472 L
s
1 g
.64006 .01472 m
.64006 .01472 L
.69608 .01472 L
.69608 .01472 L
F
0 g
.64006 .01472 m
.64006 .01472 L
.69608 .01472 L
.69608 .01472 L
s
1 g
.69608 .01472 m
.69608 .01472 L
.7521 .01472 L
.7521 .01472 L
F
0 g
.69608 .01472 m
.69608 .01472 L
.7521 .01472 L
.7521 .01472 L
s
1 g
.7521 .01472 m
.7521 .01472 L
.80812 .01472 L
.80812 .01472 L
F
0 g
.7521 .01472 m
.7521 .01472 L
.80812 .01472 L
.80812 .01472 L
s
1 g
.80812 .01472 m
.80812 .01472 L
.86415 .01472 L
.86415 .01472 L
F
0 g
.80812 .01472 m
.80812 .01472 L
.86415 .01472 L
.86415 .01472 L
s
1 g
.86415 .01472 m
.86415 .30902 L
.92017 .30902 L
.92017 .01472 L
F
0 g
.86415 .01472 m
.86415 .30902 L
.92017 .30902 L
.92017 .01472 L
s
1 g
.92017 .01472 m
.92017 .01472 L
.97619 .01472 L
.97619 .01472 L
F
0 g
.92017 .01472 m
.92017 .01472 L
.97619 .01472 L
.97619 .01472 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`00012R000`400?l00000o`00003ooooooona
ooooo`00oooooonaooooo`00oooooonaooooo`00Goooool00ooMgMgo0000omgMg@06ooooo`03oiRH
V?l0003oEEEE00Cooooo00Koc<c<ob4Q8Ol0003o0000oc8b<_oMgMdRooooo`03oa0@4?l0003o0000
00;o000000?ogMgMooooooooool00_ooool01?mVIVKo0000oc8b<_o^k^hMooooo`03oa0@4?l0003o
000000;o000000CogMgMooooooooooooQhN71?l000000ol@413oooooooooo`03ooooo`03oiRHV?l0
003oEEEE00Cooooo00Koc<c<ob4Q8Ol0003o0000oc8b<_oMgMdMooooo`03oa0@4?l0003o000000;o
000000GogMgMooooooooooooc<c<ob4Q8@02o`000003oc8b<_oMgMgooooo01cooooo00?o410@o`00
0?l000000_l000000ooMgMgoooooooooo`02ooooo`03omgMgOl0003ogMgM00Kooooo00?oV9RHo`00
0?mEEED01?ooool01_o<c<co8B4Qo`000?l0003o<S8bomgMgAgooooo00?oQhN7o`000?l000000_l0
00000ol@413oooooooooo`03ooooo`04ofIVI_l0003o<S8bonk^kS[ooooo001Pooooo`03oc8b<_n7
QhOooooo00Gooooo00?o<S8bo`000?l000001?ooool01_o<c<coZJVYooooooooooooV9RHob4Q8BCo
oooo00?o0000ooooooooool01?ooool2ohN7Q`03oooooon7QhOoA4A401oooooo00?o0000oooooooo
ool00oooool00oo^k^ko<S8bolc<c008ooooo`03oc8b<_l0003o000000Cooooo00Koc<c<ojVYZOoo
oooooooooiRHV?lQ8B4Oooooo`03o`000?oooooooooo00?ooooo00Koc<c<ojVYZOoooooooooooiRH
V?lQ8B4Oooooo`03o`000?oooooooooo00Kooooo00?o<S8bohN7Qoooool01Oooool00olb<S;o0000
o`000004ooooo`06olc<c?nYZJWooooooooooonHV9So8B4Q7Oooool00oo^k^ko<S8bolc<c007oooo
o`;oQhN700?oooooohN7Qom4A4@0>_ooool0063ooooo00?oV9RHob4Q8Oooool01Oooool00onYZJWo
8B4QogMgM`09ooooo`03ob4Q8Onj^[[ooooo02;ooooo00?o0000ooooooooool01?ooool01Olb<S;o
oooooooooooooooo000001oooooo00?o0000ooooooooool01?ooool00oo^k^ko<S8bojVYZ@07oooo
o`03ojVYZOlQ8B7oMgMg00Wooooo00?o8B4QokZj^_ooool07Oooool00ol0003oooooooooo`08oooo
o`03ob4Q8Onj^[[ooooo01gooooo00?o0000ooooooooool01_ooool00onHV9So8B4Qooooo`05oooo
o`03ojVYZOlQ8B7oMgMg00Wooooo00?o8B4QokZj^_ooool07?ooool00oo^k^ko<S8bojVYZ@06oooo
o`05oc8b<_ooooooooooooooool00000>_ooool0063ooooo00?ok^k^o`000?o<c<`04Oooool00olQ
8B7o^[Zjooooo`0Rooooo`03o`000?oooooooooo00Cooooo00Ko<S8boooooooooooooooooc8b<_nj
^[XNooooo`03o`000?oooooooooo00Gooooo00?ok^k^ob4Q8OnHV9P04_ooool00olQ8B7o^[Zjoooo
o`0Mooooo`03o`000?oooooooooo00Sooooo00?o8B4QokZj^_ooool07Oooool00ol0003ooooooooo
o`06ooooo`03onk^k_l0003oc<c<017ooooo00?o8B4QokZj^_ooool07Oooool00oo^k^ko8B4QoiRH
V005ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj>Oooool0067ooooo00?oEEEEofIVI_ooool0
3?ooool01OmVIVKogMgMoooooon7QhOo410@02Cooooo00?o0000ooooooooool01?ooool01_lb<S;o
oooooooooooooooo<S8bokZj^Qkooooo00?o0000ooooooooool01_ooool00oo^k^ko<S8bolc<c00=
ooooo`05ofIVI_oMgMgoooooohN7Qol@41007oooool00ol0003oooooooooo`04ooooo`05ofIVI_oM
gMgoooooohN7Qol@41007oooool00ol0003oooooooooo`07ooooo`03oeEEEOmVIVKooooo00cooooo
00GoIVIVomgMgOooooooQhN7oa0@400Pooooo`03onk^k_lb<S;oc<c<00Cooooo00Ko<S8boooooooo
oooooooooc8b<_nj^[Xiooooo`00HOooool00onj^[[o410@ooooo`0<ooooo`05o`000?lQ8B7o0000
oa0@4?o<c<`09?ooool00ol0003oooooooooo`04ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj
7_ooool00ol0003oooooooooo`07ooooo`03onk^k_m4A4Cooooo00cooooo00Go0000ob4Q8Ol0003o
410@olc<c00Oooooo`03o`000?oooooooooo00Cooooo00Go0000ob4Q8Ol0003o410@olc<c00Ooooo
o`03o`000?oooooooooo00Oooooo00?o^[Zjoa0@4?ooool03?ooool01Ol0003o8B4Qo`000?l@413o
c<c<027ooooo00?ok^k^odA4A?ooool00oooool01_lb<S;ooooooooooooooooo<S8bokZj^SWooooo
001Rooooo`03oa0@4?o<c<cooooo00_ooooo00?o0000ooooooooool09_ooool00ol0003ooooooooo
o`04ooooo`05oc8b<_o^k^koooooonk^k_l000007oooool00ol0003oooooooooo`04ooooo`05okZj
^_oooooooooooooooolb<S803Oooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`08ooooo`03oa0@4?o<c<cooooo00_o
oooo00?o0000ooooooooool08?ooool01Onj^[[ooooooooooooooooo<S8b00Cooooo00Go<S8bonk^
k_ooooook^k^o`00000jooooo`00H_ooool00on7QhOoIVIVooooo`0;ooooo`03o`000?oooooooooo
02Cooooo00?oQhN7okZj^_l000001_ooool01On7QhOoIVIVoooooomVIVKoA4A401gooooo00?oQhN7
okZj^_l000001Oooool01_o<c<co0000ohN7Qooooooo^[Zjob4Q8@gooooo00?o0000ooooooooool0
7oooool00on7QhOo^[Zjo`000006ooooo`03o`000?oooooooooo01oooooo00?oQhN7okZj^_l00000
2_ooool00on7QhOoIVIVooooo`0;ooooo`03o`000?oooooooooo01oooooo00Koc<c<o`000?n7QhOo
oooookZj^_lQ8B44ooooo`05ohN7QomVIVKoooooofIVI_m4A4@0>_ooool005kooooo1Ol000000olb
<S;oooooooooo`0:ooooo`Co000000?o410@ooooooooool08?ooool00on7QhOo<S8bo`000007oooo
o`04ofIVI_l0003o<S8bonk^kQgooooo00?oQhN7oc8b<_l000001_ooool01OnYZJWo8B4Qo`000?l@
413oc<c<00gooooo1?l000000ol@413oooooooooo`0Kooooo`03ohN7Qolb<S;o000000Kooooo1?l0
00000ol@413oooooooooo`0Kooooo`03ohN7Qolb<S;o000000Kooooo1Ol000000olb<S;ooooooooo
o`0:ooooo`Co000000?o410@ooooooooool07?ooool01OnYZJWo8B4Qo`000?l@413oc<c<00Gooooo
00CoIVIVo`000?lb<S;ok^k^>_ooool003Gooooo00?o0000ooooooooool0oooooomiooooo`00=Ooo
ool00ol0003oooooooooo`3oooooogWooooo000eooooo`03o`000?oooooooooo0?ooooooNOooool0
03Gooooo00?o0000ooooooooool0oooooomiooooo`00=Oooool00ol0003oooooooooo`3oooooogWo
oooo000eooooo`03o`000?oooooooooo0?ooooooNOooool002coooooool0001go`0000kooooo000e
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0B
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo01Cooooo000eooooo`03o`000?oooooooooo03;ooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool07?ooool00ol0003oooooooooo`0booooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool0:Oooool003Gooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo01;ooooo00?o0000ooooooooool0DOooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo02Wooooo000eooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo057ooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`0Yooooo`00=Oooool00ol0003oooooooooo`0looooo`03o`000?oo
oooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oo
oooooooo01;ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Booooo`03o`000?oo
oooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`1Aooooo`03o`000?oo
oooooooo01;ooooo00?o0000ooooooooool0:Oooool003Gooooo00?o0000ooooooooool0??ooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04_ooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0DOooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo000eooooo`03o`000?oooooooooo
03cooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo
01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo
01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo
057ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Yooooo`00=Oooool00ol0003o
ooooooooo`0looooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003o
ooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04Oooool00ol0003o
ooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003o
ooooooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0:Oooool003Gooooo
0ol0000looooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003ooooo
ooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04Oooool00ol0003ooooo
ooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003ooooo
ooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0:Oooool003Gooooo00?o
0000ooooooooool0??ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o
0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o
0000ooooooooool0DOooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo000e
ooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0B
ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0B
ooooo`03o`000?oooooooooo057ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Y
ooooo`00=Oooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool0:Oooool003Gooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo01;ooooo00?o0000ooooooooool0DOooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo02Wooooo000eooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo057ooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`0Yooooo`00=Oooool00ol0003oooooooooo`0looooo`03o`000?oo
oooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oo
oooooooo01;ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Booooo`03o`000?oo
oooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`1Aooooo`03o`000?oo
oooooooo01;ooooo00?o0000ooooooooool0:Oooool003Gooooo00?o0000ooooooooool0??ooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04_ooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0DOooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo000eooooo`?o0000??ooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04_ooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0DOooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo000eooooo`03o`000?oooooooooo03co
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;o
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo01;o
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo057o
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Yooooo`00=Oooool00ol0003ooooo
ooooo`0looooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003ooooo
ooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04Oooool00ol0003ooooo
ooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003ooooo
ooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0:Oooool003Gooooo00?o
0000ooooooooool0??ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o
0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o
0000ooooooooool0DOooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo000e
ooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0B
ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0B
ooooo`03o`000?oooooooooo057ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Y
ooooo`00=Oooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool0:Oooool003Gooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo01;ooooo00?o0000ooooooooool0DOooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo02Wooooo000eooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo057ooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`0Yooooo`00=Oooool00ol0003oooooooooo`0looooo`03o`000?oo
oooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oo
oooooooo01;ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Booooo`03o`000?oo
oooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`1Aooooo`03o`000?oo
oooooooo01;ooooo00?o0000ooooooooool0:Oooool003Gooooo0ol0000looooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`1Aooooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool0:Oooool003Gooooo00?o0000ooooooooool0??ooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04_ooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0DOooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo000eooooo`03o`000?oooooooooo03co
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;o
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo01;o
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo057o
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Yooooo`00=Oooool00ol0003ooooo
ooooo`0looooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003ooooo
ooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04Oooool00ol0003ooooo
ooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003ooooo
ooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0:Oooool003Gooooo00?o
0000ooooooooool0??ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o
0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o
0000ooooooooool0DOooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo000e
ooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0B
ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0B
ooooo`03o`000?oooooooooo057ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Y
ooooo`00=Oooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool0:Oooool003Gooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo01;ooooo00?o0000ooooooooool0DOooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo02Wooooo000eooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo057ooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`0Yooooo`00=Oooool3o`0003cooooo00?o0000ooooooooool04_oo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_oo
ool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_oo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo057ooooo00?o0000ooooooooool04_oo
ool00ol0003oooooooooo`0Yooooo`00=Oooool00ol0003oooooooooo`0looooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`1Aooooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool0:Oooool003Gooooo00?o0000ooooooooool0??ooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04_ooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0DOooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo000eooooo`03o`000?oooooooooo03co
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;o
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo01;o
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo057o
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Yooooo`00=Oooool00ol0003ooooo
ooooo`0looooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003ooooo
ooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04Oooool00ol0003ooooo
ooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003ooooo
ooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0:Oooool003Gooooo00?o
0000ooooooooool0??ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o
0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o
0000ooooooooool0DOooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo000@
ooooo`04ofIVI_l0003o<S8bonk^kPGooooo00?oV9RHo`000?mEEED01_ooool01?mVIVKo0000oc8b
<_o^k^h3ooooo`06olc<c?lQ8B7o0000o`000?lb<S;ogMgM1_ooool00ol0003oooooooooo`0loooo
o`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`1Aoooo
o`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0:Oooool000oooooo0_n7QhL00ooooooo
QhN7odA4A005ooooo`03oc8b<_l0003o000000Gooooo0_n7QhL00oooooooQhN7odA4A003ooooo`06
olc<c?nYZJWooooooooooonHV9So8B4Q1_ooool00ol0003oooooooooo`0looooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`1Aooooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool0:Oooool000oooooo00Go<S8booooooooooooooooo`000005
ooooo`03ojVYZOlQ8B7oMgMg00Gooooo00Go<S8booooooooooooooooo`000008ooooo`03ob4Q8Onj
^[[ooooo00Cooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`0Booooo`03o`000?oo
oooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oo
oooooooo01;ooooo00?o0000ooooooooool0DOooool00ol0003oooooooooo`0Booooo`03o`000?oo
oooooooo02Wooooo000?ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj3?ooool01_lb<S;ooooo
oooooooooooo<S8bokZj^POooooo00?o8B4QokZj^_ooool01?ooool4o`0003_ooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo057ooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`0Yooooo`003oooool01_lb<S;ooooooooooooooooo<S8b
okZj^Pcooooo00Ko<S8boooooooooooooooooc8b<_nj^[X3ooooo`05ofIVI_oMgMgoooooohN7Qol@
41001_ooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool04Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool0:Oooool000oooooo00Ko<S8boooooooooooooooooc8b<_nj^[X<ooooo`06oc8b<_oooooooooo
oooooolb<S;o^[Zj0oooool01Ol0003o8B4Qo`000?l@413oc<c<00Kooooo00?o0000ooooooooool0
??ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0
DOooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo000?ooooo`05oc8b<_o^
k^koooooonk^k_l000003Oooool01Olb<S;ok^k^ooooooo^k^ko000000Cooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool04Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool0:Oooool000oooooo00GoQhN7ofIVI_ooooooIVIVodA4A00=ooooo`05ohN7QomVIVKoooooofIV
I_m4A4@01?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo03cooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo057ooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`0Yooooo`004?ooool01?mVIVKo0000oc8b<_o^k^h>oooo
o`04ofIVI_l0003o<S8bonk^kPCooooo1?l000000ol@413oooooooooo`04ooooo`03o`000?oooooo
oooo03cooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo057ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Yooooo`00=Oooool00ol0
003oooooooooo`0looooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0
003oooooooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0:Oooool003Go
oooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;o
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;o
oooo00?o0000ooooooooool0DOooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo02Wo
oooo000eooooo`?o0000??ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo
00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool0DOooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo
000eooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo057ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Yooooo`00=Oooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool04_ooool00ol0003oooooooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool0:Oooool003Gooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0DOooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo02Wooooo000eooooo`03o`000?oooooooooo03cooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo057ooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`0Yooooo`00=Oooool00ol0003oooooooooo`0looooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`1Aooooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool0:Oooool003Gooooo00?o0000ooooooooool0??oo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_oo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04_oo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0DOoo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo000eooooo`03o`000?oooooo
oooo03cooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo057ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Yooooo`00=Oooool00ol0
003oooooooooo`0looooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0
003oooooooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0:Oooool003Go
oooo0ol0000looooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003o
ooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04Oooool00ol0003o
ooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003o
ooooooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0:Oooool003Gooooo
00?o0000ooooooooool0??ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo
00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool0DOooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo
000eooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo057ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Yooooo`00=Oooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool04_ooool00ol0003oooooooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool0:Oooool003Gooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0DOooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo02Wooooo000eooooo`03o`000?oooooooooo03cooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo057ooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`0Yooooo`00=Oooool00ol0003oooooooooo`0looooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`1Aooooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool0:Oooool003Gooooo00?o0000ooooooooool0??oo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_oo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04_oo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0DOoo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo000eooooo`03o`000?oooooo
oooo03cooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo057ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Yooooo`00=Oooool3o`00
03cooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo
01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo
01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo
057ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Yooooo`00=Oooool00ol0003o
ooooooooo`0looooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003o
ooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04Oooool00ol0003o
ooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003o
ooooooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0:Oooool003Gooooo
00?o0000ooooooooool0??ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo
00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool0DOooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo
000eooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo057ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Yooooo`00=Oooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool04_ooool00ol0003oooooooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool0:Oooool003Gooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0DOooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo02Wooooo000eooooo`03o`000?oooooooooo03cooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo057ooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`0Yooooo`00=Oooool00ol0003oooooooooo`0looooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`1Aooooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool0:Oooool003Gooooo00?o0000ooooooooool0??oo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_oo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04_oo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0DOoo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo000eooooo`?o0000??ooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04_ooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0DOooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo000eooooo`03o`000?oooooooooo
03cooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo
01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo
01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo
057ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Yooooo`00=Oooool00ol0003o
ooooooooo`0looooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003o
ooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04Oooool00ol0003o
ooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003o
ooooooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0:Oooool003Gooooo
00?o0000ooooooooool0??ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo
00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool0DOooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo
000eooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo057ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Yooooo`00=Oooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool04_ooool00ol0003oooooooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool0:Oooool001Wooooo00CoIVIVo`000?lb<S;ok^k^1Oooool00onHV9So0000oeEEE@05
ooooo`03oa0@4?l0003o000000;o000000?ogMgMooooooooool00oooool00ol0003oooooooooo`0l
ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0B
ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0B
ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`1A
ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0:Oooool001Sooooo0_n7QhL00ooo
ooooQhN7odA4A005ooooo`03oc8b<_l0003o000000Oooooo00?o0000ooooooooool01_ooool00ol0
003oooooooooo`0looooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0
003oooooooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0:Oooool001So
oooo00Go<S8booooooooooooooooo`000005ooooo`03ojVYZOlQ8B7oMgMg00Oooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool0:Oooool001Sooooo00Ko<S8boooooooooooooooooc8b<_nj^[X>ooooo`03o`000?oooooo
oooo00Kooooo1?l0000kooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool0
0ol0003oooooooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0:Oooool0
01Sooooo00Ko<S8boooooooooooooooooc8b<_nj^[X>ooooo`03o`000?oooooooooo00Kooooo00?o
0000ooooooooool0??ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o
0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o
0000ooooooooool0DOooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo000H
ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj3_ooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo03cooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo057ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Yooooo`006?oo
ool01Olb<S;ok^k^ooooooo^k^ko000000oooooo00?o0000ooooooooool01_ooool00ol0003ooooo
ooooo`0looooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003ooooo
ooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04Oooool00ol0003ooooo
ooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003ooooo
ooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0:Oooool001Sooooo00Go
QhN7ofIVI_ooooooIVIVodA4A00=ooooo`03ohN7Qonj^[[o000000Sooooo00?o0000ooooooooool0
??ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0
DOooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo000Iooooo`04ofIVI_l0
003o<S8bonk^kPgooooo00?oQhN7oc8b<_l000002?ooool00ol0003oooooooooo`0looooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`1Aooooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool0:Oooool003Gooooo00?o0000ooooooooool0??oo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_oo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04_oo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0DOoo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo000eooooo`03o`000?oooooo
oooo03cooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo057ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Yooooo`00=Oooool3o`00
03cooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo
01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo
01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo
057ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Yooooo`00=Oooool00ol0003o
ooooooooo`0looooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003o
ooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04Oooool00ol0003o
ooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003o
ooooooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0:Oooool003Gooooo
00?o0000ooooooooool0??ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo
00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool0DOooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo
000eooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo057ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Yooooo`00=Oooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool04_ooool00ol0003oooooooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool0:Oooool003Gooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0DOooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo02Wooooo000eooooo`03o`000?oooooooooo03cooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo057ooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`0Yooooo`00=Oooool00ol0003oooooooooo`0looooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`1Aooooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool0:Oooool003Gooooo00?o0000ooooooooool0??oo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_oo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04_oo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0DOoo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo000eooooo`?o0000??ooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04_ooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0DOooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo000eooooo`03o`000?oooooooooo
03cooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo
01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo
01;ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo
057ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Yooooo`00=Oooool00ol0003o
ooooooooo`0looooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003o
ooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04Oooool00ol0003o
ooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003o
ooooooooo`1Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0:Oooool003Gooooo
00?o0000ooooooooool0??ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo
00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool0DOooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo02Wooooo
000eooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo057ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Yooooo`00=Oooool00ol0003oooooooooo`0looooob_o00005?ooool00ol0003oooooooooo`0B
ooooob[o00005?oooolFo`0005?ooooo5_l0000[ooooo`00=Oooool00ol0003oooooooooo`1Voooo
o`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0n_ooool003Gooooo00?o0000oooooooo
ool0I_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo0?[ooooo000eooooo`03o`00
0?oooooooooo06Kooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`3jooooo`00=Ooo
ool3o`0006Kooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`3jooooo`00=Oooool0
0ol0003oooooooooo`1Vooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0n_ooool0
03Gooooo00?o0000ooooooooool0I_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo
0?[ooooo000eooooo`03o`000?oooooooooo06Kooooo00?o0000ooooooooool04_ooool00ol0003o
ooooooooo`3jooooo`00=Oooool00ol0003oooooooooo`1Vooooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool0n_ooool003Gooooo00?o0000ooooooooool0I_ooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo0?[ooooo000eooooo`03o`000?oooooooooo06Kooooo00?o0000
ooooooooool04_ooool00ol0003oooooooooo`3jooooo`00=Oooool00ol0003oooooooooo`1Voooo
o`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0n_ooool003Gooooo00?o0000oooooooo
ool0I_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo0?[ooooo000eooooo`?o0000
I_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo0?[ooooo000eooooo`03o`000?oo
oooooooo06Kooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`3jooooo`00=Oooool0
0ol0003oooooooooo`1Vooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0n_ooool0
03Gooooo00?o0000ooooooooool0I_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo
0?[ooooo000eooooo`03o`000?oooooooooo06Kooooo00?o0000ooooooooool04_ooool00ol0003o
ooooooooo`3jooooo`00=Oooool00ol0003oooooooooo`1Vooooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool0n_ooool0013ooooo00CoIVIVo`000?lb<S;ok^k^1Oooool00onHV9So0000
oeEEE@05ooooo`03oa0@4?l0003o000000;o000000GogMgMooooooooooooc<c<ob4Q8@02o`000003
oc8b<_oMgMgooooo00Gooooo00?o0000ooooooooool0I_ooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo0?[ooooo000?ooooo`;oQhN700?oooooohN7Qom4A4@01Oooool00olb<S;o0000
o`000007ooooo`03o`000?oooooooooo00?ooooo00Koc<c<ojVYZOoooooooooooiRHV?lQ8B46oooo
o`03o`000?oooooooooo06Kooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`3joooo
o`003oooool01Olb<S;ooooooooooooooooo000000Gooooo00?oZJVYob4Q8OmgMgL01oooool00ol0
003oooooooooo`08ooooo`03ob4Q8Onj^[[ooooo00Cooooo00?o0000ooooooooool0I_ooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo0?[ooooo000?ooooo`06oc8b<_oooooooooooooo
oolb<S;o^[Zj3_ooool00ol0003oooooooooo`08ooooo`03ob4Q8Onj^[[ooooo00Cooooo1?l0001U
ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0n_ooool000oooooo00Ko<S8boooo
oooooooooooooc8b<_nj^[X>ooooo`03o`000?oooooooooo00Cooooo00GoIVIVomgMgOooooooQhN7
oa0@4006ooooo`03o`000?oooooooooo06Kooooo00?o0000ooooooooool04_ooool00ol0003ooooo
ooooo`3jooooo`003oooool01_lb<S;ooooooooooooooooo<S8bokZj^Pkooooo00?o0000oooooooo
ool01?ooool01Ol0003o8B4Qo`000?l@413oc<c<00Kooooo00?o0000ooooooooool0I_ooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo0?[ooooo000?ooooo`05oc8b<_o^k^koooooonk^
k_l000003oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool0I_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo0?[ooooo000?ooooo`05
ohN7QomVIVKoooooofIVI_m4A4@03Oooool00on7QhOo^[Zjo`000006ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool0I_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo
0?[ooooo000@ooooo`04ofIVI_l0003o<S8bonk^kPgooooo00?oQhN7oc8b<_l000001_ooool4o`00
0003oa0@4?oooooooooo00Cooooo00?o0000ooooooooool0I_ooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo0?[ooooo000eooooo`03o`000?oooooooooo06Kooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`3jooooo`00=Oooool00ol0003oooooooooo`1Vooooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool0n_ooool003Gooooo0ol0001Vooooo`03o`000?oo
oooooooo01;ooooo00?o0000ooooooooool0n_ooool003Gooooo00?o0000ooooooooool0I_ooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo0?[ooooo000eooooo`03o`000?oooooooooo
06Kooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`3jooooo`00=Oooool00ol0003o
ooooooooo`1Vooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0n_ooool003Gooooo
00?o0000ooooooooool0I_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo0?[ooooo
000eooooo`03o`000?oooooooooo06Kooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`3jooooo`00=Oooool00ol0003oooooooooo`1Vooooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool0n_ooool003Gooooo00?o0000ooooooooool0I_ooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo0?[ooooo000eooooo`03o`000?oooooooooo06Kooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`3jooooo`00=Oooool3o`0006Kooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`3jooooo`00=Oooool00ol0003oooooooooo`1Vooooo`03o`000?oo
oooooooo01;ooooo00?o0000ooooooooool0n_ooool003Gooooo00?o0000ooooooooool0I_ooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo0?[ooooo000eooooo`03o`000?oooooooooo
06Kooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`3jooooo`00=Oooool00ol0003o
ooooooooo`1Vooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0n_ooool003Gooooo
00?o0000ooooooooool0I_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo0?[ooooo
000eooooo`03o`000?oooooooooo06Kooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`3jooooo`00=Oooool00ol0003oooooooooo`1Vooooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool0n_ooool003Gooooo00?o0000ooooooooool0I_ooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo0?[ooooo000eooooo`?o0000I_ooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo0?[ooooo000eooooo`03o`000?oooooooooo06Kooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`3jooooo`00=Oooool00ol0003oooooooooo`1Vooooo`03o`000?oo
oooooooo01;ooooo00?o0000ooooooooool0n_ooool003Gooooo00?o0000ooooooooool0I_ooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo0?[ooooo000eooooo`03o`000?oooooooooo
06Kooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`3jooooo`00=Oooool00ol0003o
ooooooooo`1Vooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0n_ooool003Gooooo
00?o0000ooooooooool0I_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo0?[ooooo
000eooooo`03o`000?oooooooooo06Kooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`3jooooo`00=Oooool00ol0003oooooooooo`1Vooooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool0n_ooool003Gooooo0ol0001Vooooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool0n_ooool003Gooooo00?o0000ooooooooool0I_ooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo0?[ooooo000eooooo`03o`000?oooooooooo06Kooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`3jooooo`00=Oooool00ol0003oooooooooo`1Vooooo`03o`000?oo
oooooooo01;ooooo00?o0000ooooooooool0n_ooool003Gooooo00?o0000ooooooooool0I_ooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo0?[ooooo000eooooo`03o`000?oooooooooo
06Kooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`3jooooo`006Oooool01?mVIVKo
0000oc8b<_o^k^h5ooooo`03oiRHV?l0003oEEEE00Cooooo00?oQhN7o`000?l000000_l000000ol@
413oooooooooo`04ooooo`03o`000?oooooooooo06Kooooo00?o0000ooooooooool04_ooool00ol0
003oooooooooo`3jooooo`006?ooool2ohN7Q`03oooooon7QhOoA4A400Gooooo00?o<S8bo`000?l0
00001?ooool00oo^k^ko<S8bolc<c009ooooo`03o`000?oooooooooo06Kooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`3jooooo`006?ooool01Olb<S;ooooooooooooooooo000000Go
oooo00?oZJVYob4Q8OmgMgL01Oooool00oo^k^ko<S8bojVYZ@08ooooo`Co0000IOooool00ol0003o
ooooooooo`0Booooo`03o`000?oooooooooo0?[ooooo000Hooooo`06oc8b<_oooooooooooooooolb
<S;o^[Zj3Oooool00oo^k^ko8B4QoiRHV007ooooo`03o`000?oooooooooo06Kooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`3jooooo`006?ooool01_lb<S;ooooooooooooooooo<S8b
okZj^Pkooooo00?ok^k^oc8b<_o<c<`01_ooool00ol0003oooooooooo`1Vooooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool0n_ooool001Sooooo00Ko<S8boooooooooooooooooc8b<_nj
^[X?ooooo`03onk^k_m4A4Cooooo00Gooooo00?o0000ooooooooool0I_ooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo0?[ooooo000Hooooo`05oc8b<_o^k^koooooonk^k_l000003Ooo
ool01Onj^[[ooooooooooooooooo<S8b00Kooooo00?o0000ooooooooool0I_ooool00ol0003ooooo
ooooo`0Booooo`03o`000?oooooooooo0?[ooooo000Hooooo`05ohN7QomVIVKoooooofIVI_m4A4@0
3?ooool01_o<c<co0000ohN7Qooooooo^[Zjob4Q8@Kooooo00?o0000ooooooooool0I_ooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo0?[ooooo000Iooooo`04ofIVI_l0003o<S8bonk^
kPgooooo00GoZJVYob4Q8Ol0003o410@olc<c006ooooo`03o`000?oooooooooo06Kooooo00?o0000
ooooooooool04_ooool00ol0003oooooooooo`3jooooo`00=Oooool00ol0003oooooooooo`1Voooo
o`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0n_ooool003Gooooo00?o0000oooooooo
ool0I_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo0?[ooooo000eooooo`?o0000
I_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo0?[ooooo000eooooo`03o`000?oo
oooooooo06Kooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`3jooooo`00=Oooool0
0ol0003oooooooooo`1Vooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0n_ooool0
03Gooooo00?o0000ooooooooool0I_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo
0?[ooooo000eooooo`03o`000?oooooooooo06Kooooo00?o0000ooooooooool04_ooool00ol0003o
ooooooooo`3jooooo`00=Oooool00ol0003oooooooooo`1Vooooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool0n_ooool003Gooooo00?o0000ooooooooool0I_ooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo0?[ooooo000eooooo`03o`000?oooooooooo06Kooooo00?o0000
ooooooooool04_ooool00ol0003oooooooooo`3jooooo`00=Oooool00ol0003oooooooooo`1Voooo
o`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0n_ooool003Gooooo0ol0001Vooooo`03
o`000?oooooooooo01;ooooo00?o0000ooooooooool0n_ooool003Gooooo00?o0000ooooooooool0
I_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo0?[ooooo000eooooo`03o`000?oo
oooooooo06Kooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`3jooooo`00=Oooool0
0ol0003oooooooooo`1Vooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0n_ooool0
03Gooooo00?o0000ooooooooool0I_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo
0?[ooooo000eooooo`03o`000?oooooooooo06Kooooo00?o0000ooooooooool04_ooool00ol0003o
ooooooooo`3jooooo`00=Oooool00ol0003oooooooooo`1Vooooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool0n_ooool003Gooooo00?o0000ooooooooool0I_ooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo0?[ooooo000eooooo`03o`000?oooooooooo06Kooooo00?o0000
ooooooooool04_ooool00ol0003oooooooooo`3jooooo`00=Oooool3o`0006Kooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`3jooooo`00=Oooool00ol0003oooooooooo`1Vooooo`03
o`000?oooooooooo01;ooooo00?o0000ooooooooool0n_ooool003Gooooo00?o0000ooooooooool0
I_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo0?[ooooo000eooooo`03o`000?oo
oooooooo06Kooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`3jooooo`00=Oooool0
0ol0003oooooooooo`1Vooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0n_ooool0
03Gooooo00?o0000ooooooooool0I_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo
0?[ooooo000eooooo`03o`000?oooooooooo06Kooooo00?o0000ooooooooool04_ooool00ol0003o
ooooooooo`3jooooo`00=Oooool00ol0003oooooooooo`1Vooooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool0n_ooool003Gooooo00?o0000ooooooooool0I_ooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo0?[ooooo000eooooo`?o0000I_ooool00ol0003oooooooooo`0B
ooooo`03o`000?oooooooooo0?[ooooo000eooooo`03o`000?oooooooooo06Kooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`3jooooo`00=Oooool00ol0003oooooooooo`1Vooooo`03
o`000?oooooooooo01;ooooo00?o0000ooooooooool0n_ooool003Gooooo00?o0000ooooooooool0
I_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo0?[ooooo000eooooo`03o`000?oo
oooooooo06Kooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`3jooooo`00=Oooool0
0ol0003oooooooooo`1Vooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0n_ooool0
013ooooo00CoIVIVo`000?lb<S;ok^k^1Oooool00onHV9So0000oeEEE@04ooooo`03ohN7Qol0003o
000000;o000000Ko410@ooooooooooooooooolc<c?lQ8B42o`000003oc8b<_oMgMgooooo00Gooooo
00?o0000ooooooooool0I_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo0?[ooooo
000?ooooo`;oQhN700?oooooohN7Qom4A4@01Oooool00olb<S;o0000o`000004ooooo`03onk^k_lb
<S;oc<c<00Kooooo00Koc<c<ojVYZOoooooooooooiRHV?lQ8B46ooooo`03o`000?oooooooooo06Ko
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`3jooooo`003oooool01Olb<S;ooooo
oooooooooooo000000Gooooo00?oZJVYob4Q8OmgMgL01Oooool00oo^k^ko<S8bojVYZ@0:ooooo`03
ob4Q8Onj^[[ooooo00Cooooo1?l0001UoooooaKo0000o?ooool000oooooo00Ko<S8boooooooooooo
oooooc8b<_nj^[X=ooooo`03onk^k_lQ8B7oV9RH00Wooooo00?o8B4QokZj^_ooool01?ooool00ol0
003oooooooooo`3oooooogWooooo000?ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj3_ooool0
0oo^k^ko<S8bolc<c004ooooo`05ofIVI_oMgMgoooooohN7Qol@41001_ooool00ol0003ooooooooo
o`3oooooogWooooo000?ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj3oooool00oo^k^koA4A4
ooooo`03ooooo`05o`000?lQ8B7o0000oa0@4?o<c<`01_ooool00ol0003oooooooooo`3oooooogWo
oooo000?ooooo`05oc8b<_o^k^koooooonk^k_l000003Oooool01Onj^[[ooooooooooooooooo<S8b
00Cooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`3oooooogWooooo000?ooooo`05
ohN7QomVIVKoooooofIVI_m4A4@03?ooool01_o<c<co0000ohN7Qooooooo^[Zjob4Q8@Cooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`3oooooogWooooo000@ooooo`04ofIVI_l0003o
<S8bonk^kPgooooo00GoZJVYob4Q8Ol0003o410@olc<c004ooooo`Co000000?o410@ooooooooool0
1?ooool00ol0003oooooooooo`3oooooogWooooo003ooooook7ooooo003ooooook7ooooo003ooooo
ok7ooooo003ooooook7ooooo003ooooook7ooooo003ooooook7ooooo003ooooook7ooooo003ooooo
ok7ooooo003ooooook7ooooo003Fooooo`03oa0@4?l0003o000000;o000000Wo410@oooooooooooo
oooooiRHV?l@413o0000ob4Q8OnHV9P00_l000000ooMgMgooooooa0@4002o`000004ooooool0003o
0000oa0@40?ooooo00OoMgMgo`000?l0003oA4A4ojVYZOl0003o410@0;Oooooo003Hooooo`03o`00
0?oooooooooo00Cooooo00Ko8B4Qonk^k_ooooook^k^ogMgMol00004ooooo`05o`000?oooooooooo
ooooool000000oooool01omgMgOoEEEEonk^k_ooooooc<c<ob4Q8Ol00000^?ooool00=Sooooo00?o
0000ooooooooool01?ooool01_lQ8B7oZJVYoooooooooooogMgMo`0000Cooooo00Go0000oooooooo
ooooooooo`000003ooooo`03ob4Q8Ooooooooooo00;ooooo00?o^[Zjo`000?ooool0]oooool00=So
oooo00?o0000ooooooooool01?ooool01_o<c<coA4A4o`000?l0003o410@o`0000Cooooo00Go0000
ooooooooooooooooo`000003ooooo`03oc8b<_oooooooooo00?ooooo00?o0000ooooooooool0]_oo
ool00=Sooooo00?o0000olc<c?ooool02Oooool00ol0003oooooooooo`02ooooo`05o`000?oooooo
ooooooooool000000oooool00olQ8B7oooooooooo`02ooooo`03olc<c?l0003ooooo0;Oooooo003H
ooooo`09o`000?lb<S;oV9RHoooooonj^[[ogMgMooooooo<c<coV9RH00;ooooo00?oQhN7ob4Q8Ooo
ool00oooool01Ol0003oQhN7oooooonj^[[o410@00?ooooo00OoZJVYoeEEEOo^k^koooooomgMgOlQ
8B7o00000;Sooooo003Fooooo`05oa0@4?l0003o0000onk^k_mVIVH00_l000001?nYZJWooooookZj
^_lQ8B42o`000003ob4Q8Oo<c<cooooo00;ooooo0_l000001?mVIVKo0000o`000?nj^[X4ooooo`06
ojVYZOl@413o0000o`000?mgMgOo0000^?ooool00?Oooooo00?o0000ooooooooool0]_ooool00?Oo
oooo00?o0000ooooooooool0]_ooool00?Gooooo00?o410@o`000?l00000^?ooool00?oooooo/Ooo
ool00?oooooo/Oooool00?oooooo/Oooool00001\
\>"],
  ImageRangeCache->{{{73.4375, 302.812}, {300.375, 159.062}} -> {-4.2091, \
0.320177, 0.0720599, 0.00171463}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Open  ]],

Cell["\<\
These are the results shown in Figure 5 and Table 1 of my 1995 \
Biophysical Journal paper.\
\>", "Text",
  CellFrame->True,
  ExpressionUUID -> "3ec622cb-0cc6-4771-affe-6ffd80a9a078",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[0.833326]]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{0, 1440}, {0, 877}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{714, 822},
WindowMargins->{{8, Automatic}, {1, Automatic}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowSelection->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1.5,
StyleDefinitions -> "Default.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 917, 18, 383, "Text",
  InitializationCell->True],
Cell[2674, 71, 222, 4, 62, "Input"],
Cell[2899, 77, 253, 8, 58, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],

Cell[CellGroupData[{
Cell[3177, 89, 198, 5, 41, "Subsubsection"],
Cell[3378, 96, 491, 9, 151, "Text"],
Cell[3872, 107, 246, 5, 73, "Text"],
Cell[4121, 114, 153, 5, 58, "Input"],
Cell[4277, 121, 230, 5, 73, "Text"],

Cell[CellGroupData[{
Cell[4532, 130, 201, 9, 138, "Input"],
Cell[4736, 141, 228, 4, 34, "Print"],
Cell[4967, 147, 37, 1, 40, "Output"]
}, Open  ]],
Cell[5019, 151, 510, 9, 151, "Text"],
Cell[5532, 162, 152, 2, 38, "Input"],

Cell[CellGroupData[{
Cell[5709, 168, 244, 6, 98, "Input"],
Cell[5956, 176, 69, 1, 40, "Output"]
}, Open  ]],
Cell[6040, 180, 254, 10, 158, "Input"],
Cell[6297, 192, 158, 3, 62, "Input"],
Cell[6458, 197, 178, 7, 98, "Input"],

Cell[CellGroupData[{
Cell[6661, 208, 230, 7, 98, "Input"],
Cell[6894, 217, 190, 4, 34, "Print"],
Cell[7087, 223, 191, 4, 34, "Print"],
Cell[7281, 229, 282, 5, 34, "Print"],
Cell[7566, 236, 681, 15, 196, "Print"],
Cell[8250, 253, 62, 1, 34, "Print"],
Cell[8315, 256, 41, 1, 34, "Print"],
Cell[8359, 259, 75, 1, 34, "Print"],
Cell[8437, 262, 41, 1, 34, "Print"],
Cell[8481, 265, 60, 1, 34, "Print"],
Cell[8544, 268, 73, 1, 34, "Print"],
Cell[8620, 271, 51, 1, 34, "Print"],
Cell[8674, 274, 412, 8, 34, "Print"],
Cell[9089, 284, 67, 1, 34, "Print"],
Cell[9159, 287, 79, 1, 34, "Print"],
Cell[9241, 290, 79, 1, 34, "Print"],
Cell[9323, 293, 413, 9, 56, "Print"],
Cell[9739, 304, 190, 4, 34, "Print"],
Cell[9932, 310, 195, 4, 34, "Print"],
Cell[10130, 316, 282, 5, 34, "Print"],
Cell[10415, 323, 681, 15, 196, "Print"],
Cell[11099, 340, 62, 1, 34, "Print"],
Cell[11164, 343, 43, 1, 34, "Print"],
Cell[11210, 346, 75, 1, 34, "Print"],
Cell[11288, 349, 48, 1, 34, "Print"],
Cell[11339, 352, 60, 1, 34, "Print"],
Cell[11402, 355, 101, 2, 34, "Print"],
Cell[11506, 359, 51, 1, 34, "Print"],
Cell[11560, 362, 413, 8, 34, "Print"],
Cell[11976, 372, 412, 8, 34, "Print"],
Cell[12391, 382, 412, 8, 34, "Print"],
Cell[12806, 392, 67, 1, 34, "Print"],
Cell[12876, 395, 81, 1, 34, "Print"],
Cell[12960, 398, 79, 1, 34, "Print"],
Cell[13042, 401, 413, 9, 56, "Print"],
Cell[13458, 412, 190, 4, 34, "Print"],
Cell[13651, 418, 195, 4, 34, "Print"],
Cell[13849, 424, 282, 5, 34, "Print"],
Cell[14134, 431, 681, 15, 196, "Print"],
Cell[14818, 448, 62, 1, 34, "Print"],
Cell[14883, 451, 42, 1, 34, "Print"],
Cell[14928, 454, 75, 1, 34, "Print"],
Cell[15006, 457, 48, 1, 34, "Print"],
Cell[15057, 460, 60, 1, 34, "Print"],
Cell[15120, 463, 102, 2, 34, "Print"],
Cell[15225, 467, 51, 1, 34, "Print"],
Cell[15279, 470, 412, 8, 34, "Print"],
Cell[15694, 480, 411, 8, 34, "Print"],
Cell[16108, 490, 414, 8, 34, "Print"],
Cell[16525, 500, 67, 1, 34, "Print"],
Cell[16595, 503, 81, 1, 34, "Print"],
Cell[16679, 506, 79, 1, 34, "Print"],
Cell[16761, 509, 414, 9, 56, "Print"],
Cell[17178, 520, 190, 4, 34, "Print"],
Cell[17371, 526, 208, 4, 34, "Print"],
Cell[17582, 532, 282, 5, 34, "Print"],
Cell[17867, 539, 681, 15, 196, "Print"],
Cell[18551, 556, 62, 1, 34, "Print"],
Cell[18616, 559, 45, 1, 34, "Print"],
Cell[18664, 562, 75, 1, 34, "Print"],
Cell[18742, 565, 49, 1, 34, "Print"],
Cell[18794, 568, 60, 1, 34, "Print"],
Cell[18857, 571, 122, 2, 34, "Print"],
Cell[18982, 575, 51, 1, 34, "Print"],
Cell[19036, 578, 414, 8, 34, "Print"],
Cell[19453, 588, 414, 8, 34, "Print"],
Cell[19870, 598, 410, 8, 34, "Print"],
Cell[20283, 608, 414, 8, 34, "Print"],
Cell[20700, 618, 413, 8, 34, "Print"],
Cell[21116, 628, 412, 8, 34, "Print"],
Cell[21531, 638, 67, 1, 34, "Print"],
Cell[21601, 641, 83, 1, 34, "Print"],
Cell[21687, 644, 79, 1, 34, "Print"],
Cell[21769, 647, 412, 9, 56, "Print"],
Cell[22184, 658, 190, 4, 34, "Print"],
Cell[22377, 664, 210, 4, 34, "Print"],
Cell[22590, 670, 282, 5, 34, "Print"],
Cell[22875, 677, 681, 15, 196, "Print"],
Cell[23559, 694, 62, 1, 34, "Print"],
Cell[23624, 697, 45, 1, 34, "Print"],
Cell[23672, 700, 75, 1, 34, "Print"],
Cell[23750, 703, 51, 1, 34, "Print"],
Cell[23804, 706, 60, 1, 34, "Print"],
Cell[23867, 709, 122, 2, 34, "Print"],
Cell[23992, 713, 51, 1, 34, "Print"],
Cell[24046, 716, 412, 8, 34, "Print"],
Cell[24461, 726, 412, 8, 34, "Print"],
Cell[24876, 736, 412, 8, 34, "Print"],
Cell[25291, 746, 412, 8, 34, "Print"],
Cell[25706, 756, 412, 8, 34, "Print"],
Cell[26121, 766, 414, 8, 34, "Print"],
Cell[26538, 776, 67, 1, 34, "Print"],
Cell[26608, 779, 84, 1, 34, "Print"],
Cell[26695, 782, 79, 1, 34, "Print"],
Cell[26777, 785, 412, 9, 56, "Print"],
Cell[27192, 796, 190, 4, 34, "Print"],
Cell[27385, 802, 205, 4, 34, "Print"],
Cell[27593, 808, 282, 5, 34, "Print"],
Cell[27878, 815, 681, 15, 196, "Print"],
Cell[28562, 832, 62, 1, 34, "Print"],
Cell[28627, 835, 46, 1, 34, "Print"],
Cell[28676, 838, 75, 1, 34, "Print"],
Cell[28754, 841, 58, 1, 34, "Print"],
Cell[28815, 844, 60, 1, 34, "Print"],
Cell[28878, 847, 142, 2, 34, "Print"],
Cell[29023, 851, 51, 1, 34, "Print"],
Cell[29077, 854, 413, 8, 34, "Print"],
Cell[29493, 864, 413, 8, 34, "Print"],
Cell[29909, 874, 413, 8, 34, "Print"],
Cell[30325, 884, 411, 8, 34, "Print"],
Cell[30739, 894, 414, 8, 34, "Print"],
Cell[31156, 904, 414, 8, 34, "Print"],
Cell[31573, 914, 413, 8, 34, "Print"],
Cell[31989, 924, 414, 8, 34, "Print"],
Cell[32406, 934, 414, 8, 34, "Print"],
Cell[32823, 944, 414, 8, 34, "Print"],
Cell[33240, 954, 67, 1, 34, "Print"],
Cell[33310, 957, 86, 1, 34, "Print"],
Cell[33399, 960, 79, 1, 34, "Print"],
Cell[33481, 963, 413, 9, 56, "Print"],
Cell[33897, 974, 190, 4, 34, "Print"],
Cell[34090, 980, 218, 4, 34, "Print"],
Cell[34311, 986, 282, 5, 34, "Print"],
Cell[34596, 993, 681, 15, 196, "Print"],
Cell[35280, 1010, 62, 1, 34, "Print"],
Cell[35345, 1013, 48, 1, 34, "Print"],
Cell[35396, 1016, 75, 1, 34, "Print"],
Cell[35474, 1019, 58, 1, 34, "Print"],
Cell[35535, 1022, 60, 1, 34, "Print"],
Cell[35598, 1025, 170, 3, 58, "Print"],
Cell[35771, 1030, 51, 1, 34, "Print"],
Cell[35825, 1033, 414, 8, 34, "Print"],
Cell[36242, 1043, 414, 8, 34, "Print"],
Cell[36659, 1053, 413, 8, 34, "Print"],
Cell[37075, 1063, 414, 8, 34, "Print"],
Cell[37492, 1073, 414, 8, 34, "Print"],
Cell[37909, 1083, 414, 8, 34, "Print"],
Cell[38326, 1093, 414, 8, 34, "Print"],
Cell[38743, 1103, 414, 8, 34, "Print"],
Cell[39160, 1113, 414, 8, 34, "Print"],
Cell[39577, 1123, 414, 8, 34, "Print"],
Cell[39994, 1133, 414, 8, 34, "Print"],
Cell[40411, 1143, 413, 8, 34, "Print"],
Cell[40827, 1153, 414, 8, 34, "Print"],
Cell[41244, 1163, 414, 8, 34, "Print"],
Cell[41661, 1173, 414, 8, 34, "Print"],
Cell[42078, 1183, 67, 1, 34, "Print"],
Cell[42148, 1186, 88, 1, 34, "Print"],
Cell[42239, 1189, 79, 1, 34, "Print"],
Cell[42321, 1192, 413, 9, 56, "Print"]
}, Open  ]],
Cell[42749, 1204, 145, 2, 47, "Text"],
Cell[42897, 1208, 990, 17, 331, "Text"],
Cell[43890, 1227, 186, 5, 47, "Text"],

Cell[CellGroupData[{
Cell[44101, 1236, 142, 2, 38, "Input"],
Cell[44246, 1240, 67, 1, 34, "Print"],
Cell[44316, 1243, 77, 1, 34, "Print"],
Cell[44396, 1246, 60, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[44493, 1252, 350, 9, 120, "Input"],
Cell[44846, 1263, 67, 1, 34, "Print"],
Cell[44916, 1266, 79, 1, 34, "Print"],
Cell[44998, 1269, 205, 5, 59, "Print"],
Cell[45206, 1276, 67, 1, 34, "Print"],
Cell[45276, 1279, 81, 1, 34, "Print"],
Cell[45360, 1282, 201, 5, 59, "Print"],
Cell[45564, 1289, 67, 1, 34, "Print"],
Cell[45634, 1292, 81, 1, 34, "Print"],
Cell[45718, 1295, 201, 5, 59, "Print"],
Cell[45922, 1302, 67, 1, 34, "Print"],
Cell[45992, 1305, 83, 1, 34, "Print"],
Cell[46078, 1308, 204, 5, 59, "Print"],
Cell[46285, 1315, 67, 1, 34, "Print"],
Cell[46355, 1318, 84, 1, 34, "Print"],
Cell[46442, 1321, 201, 5, 59, "Print"],
Cell[46646, 1328, 67, 1, 34, "Print"],
Cell[46716, 1331, 86, 1, 34, "Print"],
Cell[46805, 1334, 201, 5, 59, "Print"],
Cell[47009, 1341, 67, 1, 34, "Print"],
Cell[47079, 1344, 88, 1, 34, "Print"],
Cell[47170, 1347, 201, 5, 59, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[47420, 1358, 195, 5, 41, "Subsubsection"],
Cell[47618, 1365, 201, 5, 73, "Text"],

Cell[CellGroupData[{
Cell[47844, 1374, 120, 2, 38, "Input"],
Cell[47967, 1378, 53, 1, 40, "Output"]
}, Open  ]],
Cell[48035, 1382, 509, 10, 175, "Text"],
Cell[48547, 1394, 321, 8, 97, "Text"],
Cell[48871, 1404, 153, 2, 38, "Input"],
Cell[49027, 1408, 275, 11, 178, "Input"],

Cell[CellGroupData[{
Cell[49327, 1423, 144, 2, 38, "Input"],
Cell[49474, 1427, 428, 11, 54, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[49939, 1443, 144, 2, 38, "Input"],
Cell[50086, 1447, 477, 12, 54, "Print"]
}, Open  ]],
Cell[50578, 1462, 427, 9, 149, "Text"],
Cell[51008, 1473, 196, 5, 47, "Text"],

Cell[CellGroupData[{
Cell[51229, 1482, 195, 5, 58, "Input"],
Cell[51427, 1489, 51, 1, 34, "Print"],
Cell[51481, 1492, 51, 1, 34, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[51569, 1498, 158, 2, 38, "Input"],
Cell[51730, 1502, 43, 1, 34, "Print"],
Cell[51776, 1505, 44, 1, 34, "Print"],
Cell[51823, 1508, 48, 1, 34, "Print"],
Cell[51874, 1511, 154, 3, 34, "Print"],
Cell[52031, 1516, 32012, 791, 279, 7159, 480, "GraphicsData", "PostScript", \
"Graphics"],
Cell[84046, 2309, 130, 3, 40, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[84213, 2317, 158, 2, 38, "Input"],
Cell[84374, 2321, 43, 1, 34, "Print"],
Cell[84420, 2324, 44, 1, 34, "Print"],
Cell[84467, 2327, 48, 1, 34, "Print"],
Cell[84518, 2330, 180, 3, 34, "Print"],
Cell[84701, 2335, 65025, 1231, 279, 7298, 514, "GraphicsData", "PostScript", \
"Graphics"],
Cell[149729, 3568, 130, 3, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[149886, 3575, 261, 7, 97, "Text"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

