(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     52557,       1526]*)
(*NotebookOutlinePosition[     53508,       1559]*)
(*  CellTagsIndexPosition[     53464,       1555]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
CHR 2 November 1994
These are the examples that form part of my hydrodynamics paper.\
\>", "Text",\

  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "1075b40e-736a-4c10-884a-be9ee475c4c7"],

Cell[TextData[{
  "CHR started 18 Feb 2020. Test of reproducibility for the ReScience 10-year \
reproducibility challenge (https://rescience.github.io/ten-years/). Chosen \
paper is Robert, C.H. (1995) Estimating Friction Coefficients of Mixed \
Globular/Chain Molecules, such as Protein/DNA Complexes. Biophys J. 69, \
840-48.\n\nThe code in this file came from the 1995 notebooks \"Example 2 \
1-over-r.nb\" and \"Example 2 dinucleosomes.nb\", extracted into \
Figure4_1995.nb preserving the original results. Reproduction trials were run \
using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5.2 and 12.0.\nChanges from original code:\n- added dependence on library \
s6.1 (Get[...])\n- changed boolean variable MonteCarlo to montecarlo \
(MonteCarlo became a reserved word in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ")\n- modified call from doKirkwood to original doKirkwood0 from library \
s6.0\n- added comments\n\nResults to compare to originals are indicated by \
blue text boxes."
}], "Text",
  CellFrame->True,
  InitializationCell->True,
  ExpressionUUID -> "3ad83b4d-c761-49ed-b0f4-ac55148621ae",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[0.833326]],

Cell[BoxData[
    \(\(Get["\<ReScience/\>" <> "\<s6.1_repro.m\>"];\)\)], "Input",
  InitializationCell->True,
  ExpressionUUID -> "ade6552f-33e7-413e-bfcc-dcb979c4bd13"],

Cell["\<\
Off[General::spell];
Off[General::spell1];\
\>", "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "b34d097c-68a5-47ff-8bcf-52efa782d3a4"],

Cell[CellGroupData[{

Cell["Paper: Use Kirkwood and vary the number of turns", "Subsubsection",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "7c431f2e-0432-407b-bbd8-9127b3909b80"],

Cell["\<\
First clear the randomizing orientation matrix so that all of the \
chain pictures will be aligned in the same coordinate system.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "6361f81e-d74a-4815-9857-f38cc6a73675"],

Cell["\<\
ClearAll[A0];
A0=Identity[3];\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "9465f752-6915-4ca0-8ec1-dfd94d1f294e"],

Cell["\<\
Then define a couple of things to make the example easier to do... \
Here the DNA chain is of length template (bp), and there are nnukes \
nucleosomes on it. The nucleosomes begin and end the chain. The linker length \
in bp is calculated, and the \"chain\" defined.  Remember that the chain of \
segments includes one segment for each free basepair (the linker) and one \
segment for each nucleosome.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "3a4028b0-dd0c-4069-a0d5-390604225bd4"],

Cell["\<\
linker[length_,t_]:=length-t wrapbp;
ns[length_,t_]:=2+linker[length,t];
chain[length_,t_]:={ns[length,t],{1,ns[length,t]}};\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "278e0d01-d29f-4859-a92d-242302dd8b7b"],

Cell["\<\
template=354;
nnukes=2;\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "b775c4bf-ccd8-4541-ab31-0344eb18866b"],

Cell[CellGroupData[{

Cell["\<\
turns=1.75;
chain[template,nnukes]\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "5bd053b4-c1f9-4ead-b1dc-bd8963dda793"],

Cell[BoxData[
    \({64, {1, 64}}\)], "Output"]
}, Open  ]],

Cell["\<\
Calculate the Kirkwood estimates of the frictional coefficients. \
This procedure (Kirkwood) does not require Monte Carlo trials, remember, so I \
don't need to bother anymore with A0.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "e3ffeab5-bb4d-4f33-9419-86111dacc677"],

Cell["\<\
template=354;
nnukes=2;
collective=True;
test=True;
progress=True;
montecarlo=False;\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "3616f58d-10b7-418e-90f0-a5e742521131"],

Cell[CellGroupData[{

Cell["\<\
definebasepair;
Do[\tturns=turns0;
\tdefinenuke;
\tdefinephysicalnuke;
\tassembleelements[chain[template,nnukes]];
\tmakeAs[chain[template,nnukes]];
\tdoKirkwood[chain[template,nnukes]],
{turns0,1.5,2.0,0.1}];\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "db4141bf-47d1-4c4b-87ce-8fe12c6d9797",
  FontSize->10],

Cell[BoxData[
    InterpretationBox[\("n = "\[InvisibleSpace]20\[InvisibleSpace]" ; dl = "\
\[InvisibleSpace]21.080057703417086`\),
      SequenceForm[ "n = ", 20, " ; dl = ", 21.080057703417086],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Chain of "\[InvisibleSpace]106\[InvisibleSpace]" \
segments,"\),
      SequenceForm[ "Chain of ", 106, " segments,"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("with displacements at segments "\[InvisibleSpace]{1, 
          106}\),
      SequenceForm[ "with displacements at segments ", {1, 106}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Stokes offset "\[InvisibleSpace]3.0076424054539146`\
\[InvisibleSpace]" A at "\[InvisibleSpace]50\[InvisibleSpace]" bp"\),
      SequenceForm[ 
      "Stokes offset ", 3.0076424054539146, " A at ", 50, " bp"],
      Editable->False]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
            {\("persistence\nlength"\), "510.`", "\<\"A\"\>"},
            {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
            {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
            {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
            {"\<\"turns\"\>", "1.5`", "\<\"turns\"\>"},
            {"\<\"pitch\"\>", \(-28.571`\), "\<\"A/turn\"\>"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("Array of chain lengths (bp)"\)], "Print"],

Cell[BoxData[
    \({0, 104, 0}\)], "Print"],

Cell[BoxData[
    \("Array of friction element positions (bp)"\)], "Print"],

Cell[BoxData[
    \({1, 53, 106}\)], "Print"],

Cell[BoxData[
    \("Array of Stokes radii (A)"\)], "Print"],

Cell[BoxData[
    \({55.717081770182105`, 56.26690933246489`, 
      55.717081770182105`}\)], "Print"],

Cell[BoxData[
    \("...doKirkwood..."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]" \
"\[InvisibleSpace]174.72278016856492`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]174.1142483570199`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 2, " ", 174.72278016856492, " corrected:", 
        174.1142483570199],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]328.7198554436894`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]324.3925110404323`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 3, " ", 328.71985544368943, " corrected:", 
        324.39251104043228],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]177.66872102126544`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]177.02689589602213`\),
      SequenceForm[ 
      "i,j,rij:", "*", 2, " ", 3, " ", 177.66872102126544, " corrected:", 
        177.02689589602213],
      Editable->False]], "Print"],

Cell[BoxData[
    \({"np", "nchain", "mass1", "vbar1"}\)], "Print"],

Cell[BoxData[
    \({{106, {1, 106}}, 354, 450640, 0.6463074738150186`}\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1,s1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(3.211668203237934`*^-7\ \
g\)\/s, \(2.0854101928677802`*^-7\ g\)\/s, 1.2626422301711332`*^-12\ s}\),
      SequenceForm[ "   ", {
        Times[ 3.2116682032379339*^-07, g, 
          Power[ s, -1]], 
        Times[ 2.0854101928677802*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.2626422301711332*^-12, s]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("n = "\[InvisibleSpace]20\[InvisibleSpace]" ; dl = "\
\[InvisibleSpace]22.45693170152919`\),
      SequenceForm[ "n = ", 20, " ; dl = ", 22.456931701529189],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Chain of "\[InvisibleSpace]90\[InvisibleSpace]" \
segments,"\),
      SequenceForm[ "Chain of ", 90, " segments,"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("with displacements at segments "\[InvisibleSpace]{1, 
          90}\),
      SequenceForm[ "with displacements at segments ", {1, 90}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Stokes offset "\[InvisibleSpace]3.0076424054539146`\
\[InvisibleSpace]" A at "\[InvisibleSpace]50\[InvisibleSpace]" bp"\),
      SequenceForm[ 
      "Stokes offset ", 3.0076424054539146, " A at ", 50, " bp"],
      Editable->False]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
            {\("persistence\nlength"\), "510.`", "\<\"A\"\>"},
            {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
            {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
            {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
            {"\<\"turns\"\>", "1.6`", "\<\"turns\"\>"},
            {"\<\"pitch\"\>", \(-28.571`\), "\<\"A/turn\"\>"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("Array of chain lengths (bp)"\)], "Print"],

Cell[BoxData[
    \({0, 88, 0}\)], "Print"],

Cell[BoxData[
    \("Array of friction element positions (bp)"\)], "Print"],

Cell[BoxData[
    \({1, 45, 90}\)], "Print"],

Cell[BoxData[
    \("Array of Stokes radii (A)"\)], "Print"],

Cell[BoxData[
    \({56.139388672678535`, 50.56849284147468`, 
      56.139388672678535`}\)], "Print"],

Cell[BoxData[
    \("...doKirkwood..."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]" \
"\[InvisibleSpace]151.70139316032936`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]151.31818494183037`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 2, " ", 151.70139316032936, " corrected:", 
        151.31818494183037],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]291.8241765333811`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]289.00128830593`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 3, " ", 291.82417653338109, " corrected:", 
        289.00128830593002],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]154.67255298398132`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]154.2645621351069`\),
      SequenceForm[ 
      "i,j,rij:", "*", 2, " ", 3, " ", 154.67255298398132, " corrected:", 
        154.2645621351069],
      Editable->False]], "Print"],

Cell[BoxData[
    \({"np", "nchain", "mass1", "vbar1"}\)], "Print"],

Cell[BoxData[
    \({{90, {1, 90}}, 354, 450640, 0.6463074738150186`}\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1,s1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(3.1187123056735216`*^-7\ g\)\
\/s, \(1.9610145851540484`*^-7\ g\)\/s, 1.342737069208152`*^-12\ s}\),
      SequenceForm[ "   ", {
        Times[ 3.1187123056735216*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.9610145851540484*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.342737069208152*^-12, s]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("n = "\[InvisibleSpace]20\[InvisibleSpace]" ; dl = "\
\[InvisibleSpace]23.828322591761847`\),
      SequenceForm[ "n = ", 20, " ; dl = ", 23.828322591761847],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Chain of "\[InvisibleSpace]74\[InvisibleSpace]" \
segments,"\),
      SequenceForm[ "Chain of ", 74, " segments,"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("with displacements at segments "\[InvisibleSpace]{1, 
          74}\),
      SequenceForm[ "with displacements at segments ", {1, 74}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Stokes offset "\[InvisibleSpace]3.0076424054539146`\
\[InvisibleSpace]" A at "\[InvisibleSpace]50\[InvisibleSpace]" bp"\),
      SequenceForm[ 
      "Stokes offset ", 3.0076424054539146, " A at ", 50, " bp"],
      Editable->False]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
            {\("persistence\nlength"\), "510.`", "\<\"A\"\>"},
            {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
            {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
            {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
            {"\<\"turns\"\>", "1.7`", "\<\"turns\"\>"},
            {"\<\"pitch\"\>", \(-28.571`\), "\<\"A/turn\"\>"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("Array of chain lengths (bp)"\)], "Print"],

Cell[BoxData[
    \({0, 72, 0}\)], "Print"],

Cell[BoxData[
    \("Array of friction element positions (bp)"\)], "Print"],

Cell[BoxData[
    \({1, 37, 74}\)], "Print"],

Cell[BoxData[
    \("Array of Stokes radii (A)"\)], "Print"],

Cell[BoxData[
    \({56.55543582127602`, 44.67712957198618`, 56.55543582127602`}\)], "Print"],

Cell[BoxData[
    \("...doKirkwood..."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]" \
"\[InvisibleSpace]128.80902271110944`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]128.5880741737774`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 2, " ", 128.80902271110944, " corrected:", 
        128.58807417377739],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]241.53930091092656`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]239.93173142967242`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 3, " ", 241.53930091092656, " corrected:", 
        239.93173142967242],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]131.78571038098897`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]131.5473725408056`\),
      SequenceForm[ 
      "i,j,rij:", "*", 2, " ", 3, " ", 131.78571038098897, " corrected:", 
        131.54737254080561],
      Editable->False]], "Print"],

Cell[BoxData[
    \({"np", "nchain", "mass1", "vbar1"}\)], "Print"],

Cell[BoxData[
    \({{74, {1, 74}}, 354, 450640, 0.6463074738150186`}\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1,s1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(3.0218214926835236`*^-7\ g\)\
\/s, \(1.8187282757404906`*^-7\ g\)\/s, 1.447784703117411`*^-12\ s}\),
      SequenceForm[ "   ", {
        Times[ 3.0218214926835236*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.8187282757404906*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.4477847031174111*^-12, s]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("n = "\[InvisibleSpace]20\[InvisibleSpace]" ; dl = "\
\[InvisibleSpace]25.193895755258747`\),
      SequenceForm[ "n = ", 20, " ; dl = ", 25.193895755258747],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Chain of "\[InvisibleSpace]56\[InvisibleSpace]" \
segments,"\),
      SequenceForm[ "Chain of ", 56, " segments,"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("with displacements at segments "\[InvisibleSpace]{1, 
          56}\),
      SequenceForm[ "with displacements at segments ", {1, 56}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Stokes offset "\[InvisibleSpace]3.0076424054539146`\
\[InvisibleSpace]" A at "\[InvisibleSpace]50\[InvisibleSpace]" bp"\),
      SequenceForm[ 
      "Stokes offset ", 3.0076424054539146, " A at ", 50, " bp"],
      Editable->False]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
            {\("persistence\nlength"\), "510.`", "\<\"A\"\>"},
            {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
            {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
            {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
            {"\<\"turns\"\>", "1.8`", "\<\"turns\"\>"},
            {"\<\"pitch\"\>", \(-28.571`\), "\<\"A/turn\"\>"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("Array of chain lengths (bp)"\)], "Print"],

Cell[BoxData[
    \({0, 54, 0}\)], "Print"],

Cell[BoxData[
    \("Array of friction element positions (bp)"\)], "Print"],

Cell[BoxData[
    \({1, 28, 56}\)], "Print"],

Cell[BoxData[
    \("Array of Stokes radii (A)"\)], "Print"],

Cell[BoxData[
    \({57.01628855207165`, 37.789456544957446`, 
      57.01628855207165`}\)], "Print"],

Cell[BoxData[
    \("...doKirkwood..."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]" \
"\[InvisibleSpace]103.62250313014115`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]103.52061473479114`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 2, " ", 103.62250313014115, " corrected:", 
        103.52061473479114],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]182.45515240804966`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]181.74752539968847`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 3, " ", 182.45515240804966, " corrected:", 
        181.74752539968847],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]106.5456911430546`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]106.43328474052215`\),
      SequenceForm[ 
      "i,j,rij:", "*", 2, " ", 3, " ", 106.5456911430546, " corrected:", 
        106.43328474052215],
      Editable->False]], "Print"],

Cell[BoxData[
    \({"np", "nchain", "mass1", "vbar1"}\)], "Print"],

Cell[BoxData[
    \({{56, {1, 56}}, 354, 450640, 0.6463074738150186`}\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1,s1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(2.9075663600047107`*^-7\ g\)\
\/s, \(1.6366951715792215`*^-7\ g\)\/s, 1.6088072003068988`*^-12\ s}\),
      SequenceForm[ "   ", {
        Times[ 2.9075663600047107*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.6366951715792215*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.6088072003068988*^-12, s]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("n = "\[InvisibleSpace]20\[InvisibleSpace]" ; dl = "\
\[InvisibleSpace]26.55331803428749`\),
      SequenceForm[ "n = ", 20, " ; dl = ", 26.553318034287489],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Chain of "\[InvisibleSpace]40\[InvisibleSpace]" \
segments,"\),
      SequenceForm[ "Chain of ", 40, " segments,"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("with displacements at segments "\[InvisibleSpace]{1, 
          40}\),
      SequenceForm[ "with displacements at segments ", {1, 40}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Stokes offset "\[InvisibleSpace]3.0076424054539146`\
\[InvisibleSpace]" A at "\[InvisibleSpace]50\[InvisibleSpace]" bp"\),
      SequenceForm[ 
      "Stokes offset ", 3.0076424054539146, " A at ", 50, " bp"],
      Editable->False]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
            {\("persistence\nlength"\), "510.`", "\<\"A\"\>"},
            {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
            {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
            {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
            {"\<\"turns\"\>", "1.9`", "\<\"turns\"\>"},
            {"\<\"pitch\"\>", \(-28.571`\), "\<\"A/turn\"\>"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("Array of chain lengths (bp)"\)], "Print"],

Cell[BoxData[
    \({0, 38, 0}\)], "Print"],

Cell[BoxData[
    \("Array of friction element positions (bp)"\)], "Print"],

Cell[BoxData[
    \({1, 20, 40}\)], "Print"],

Cell[BoxData[
    \("Array of Stokes radii (A)"\)], "Print"],

Cell[BoxData[
    \({57.41977121149366`, 31.11516799555567`, 57.41977121149366`}\)], "Print"],

Cell[BoxData[
    \("...doKirkwood..."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]" \
"\[InvisibleSpace]82.71654800800671`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]82.67539365830228`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 2, " ", 82.716548008006711, " corrected:", 
        82.675393658302283],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]138.4420903239821`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]138.16493523154116`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 3, " ", 138.44209032398209, " corrected:", 
        138.16493523154116],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]85.47155233210788`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]85.42457813891437`\),
      SequenceForm[ 
      "i,j,rij:", "*", 2, " ", 3, " ", 85.471552332107876, " corrected:", 
        85.42457813891437],
      Editable->False]], "Print"],

Cell[BoxData[
    \({"np", "nchain", "mass1", "vbar1"}\)], "Print"],

Cell[BoxData[
    \({{40, {1, 40}}, 354, 450640, 0.6463074738150186`}\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1,s1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(2.795200379663063`*^-7\ \
g\)\/s, \(1.4636825726566017`*^-7\ g\)\/s, 1.7989740575820545`*^-12\ s}\),
      SequenceForm[ "   ", {
        Times[ 2.7952003796630628*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.4636825726566017*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.7989740575820545*^-12, s]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("n = "\[InvisibleSpace]20\[InvisibleSpace]" ; dl = "\
\[InvisibleSpace]27.906257816099018`\),
      SequenceForm[ "n = ", 20, " ; dl = ", 27.906257816099018],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Chain of "\[InvisibleSpace]24\[InvisibleSpace]" \
segments,"\),
      SequenceForm[ "Chain of ", 24, " segments,"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("with displacements at segments "\[InvisibleSpace]{1, 
          24}\),
      SequenceForm[ "with displacements at segments ", {1, 24}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Stokes offset "\[InvisibleSpace]3.0076424054539146`\
\[InvisibleSpace]" A at "\[InvisibleSpace]50\[InvisibleSpace]" bp"\),
      SequenceForm[ 
      "Stokes offset ", 3.0076424054539146, " A at ", 50, " bp"],
      Editable->False]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
            {\("persistence\nlength"\), "510.`", "\<\"A\"\>"},
            {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
            {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
            {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
            {"\<\"turns\"\>", "2.`", "\<\"turns\"\>"},
            {"\<\"pitch\"\>", \(-28.571`\), "\<\"A/turn\"\>"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("Array of chain lengths (bp)"\)], "Print"],

Cell[BoxData[
    \({0, 22, 0}\)], "Print"],

Cell[BoxData[
    \("Array of friction element positions (bp)"\)], "Print"],

Cell[BoxData[
    \({1, 12, 24}\)], "Print"],

Cell[BoxData[
    \("Array of Stokes radii (A)"\)], "Print"],

Cell[BoxData[
    \({57.81766172943429`, 23.79541967922709`, 57.81766172943429`}\)], "Print"],

Cell[BoxData[
    \("...doKirkwood..."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]" \
"\[InvisibleSpace]65.09401328700297`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]65.08280493120671`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 2, " ", 65.094013287002966, " corrected:", 
        65.082804931206709],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]125.45610700514469`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]125.36569372404733`\),
      SequenceForm[ 
      "i,j,rij:", "*", 1, " ", 3, " ", 125.45610700514469, " corrected:", 
        125.36569372404733],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]67.3880280384592`\[InvisibleSpace]" corrected:"\
\[InvisibleSpace]67.37428826502251`\),
      SequenceForm[ 
      "i,j,rij:", "*", 2, " ", 3, " ", 67.388028038459197, " corrected:", 
        67.374288265022514],
      Editable->False]], "Print"],

Cell[BoxData[
    \({"np", "nchain", "mass1", "vbar1"}\)], "Print"],

Cell[BoxData[
    \({{24, {1, 24}}, 354, 450640, 0.6463074738150186`}\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1,s1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(2.670258911402653`*^-7\ \
g\)\/s, \(1.349560800092194`*^-7\ g\)\/s, 1.9510991846860903`*^-12\ s}\),
      SequenceForm[ "   ", {
        Times[ 2.6702589114026532*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.349560800092194*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.9510991846860903*^-12, s]}],
      Editable->False]], "Print"]
}, Open  ]]
}, Open  ]],

Cell["\<\
These results, while close, do not exactly match the output in the \
original notebooks. The reason was a small chain-statistics correction \
applied to the \"doKirkwood\" function after the figure was made; here is the \
calculation with the original function, here named \"doKirkwood0\", which has \
been added to the library file s6.1.\
\>", "Text",
  CellFrame->True,
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[0.833326]],

Cell[CellGroupData[{

Cell["\<\
definebasepair;
Do[\tturns=turns0;
\tdefinenuke;
\tdefinephysicalnuke;
\tassembleelements[chain[template,nnukes]];
\tmakeAs[chain[template,nnukes]];
\tdoKirkwood0[chain[template,nnukes]],
{turns0,1.5,2.0,0.1}];\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "db4141bf-47d1-4c4b-87ce-8fe12c6d9797",
  FontSize->10],

Cell[BoxData[
    InterpretationBox[\("n = "\[InvisibleSpace]20\[InvisibleSpace]" ; dl = "\
\[InvisibleSpace]21.080057703417086`\),
      SequenceForm[ "n = ", 20, " ; dl = ", 21.080057703417086],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Chain of "\[InvisibleSpace]106\[InvisibleSpace]" \
segments,"\),
      SequenceForm[ "Chain of ", 106, " segments,"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("with displacements at segments "\[InvisibleSpace]{1, 
          106}\),
      SequenceForm[ "with displacements at segments ", {1, 106}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Stokes offset "\[InvisibleSpace]3.0076424054539146`\
\[InvisibleSpace]" A at "\[InvisibleSpace]50\[InvisibleSpace]" bp"\),
      SequenceForm[ 
      "Stokes offset ", 3.0076424054539146, " A at ", 50, " bp"],
      Editable->False]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
            {\("persistence\nlength"\), "510.`", "\<\"A\"\>"},
            {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
            {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
            {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
            {"\<\"turns\"\>", "1.5`", "\<\"turns\"\>"},
            {"\<\"pitch\"\>", \(-28.571`\), "\<\"A/turn\"\>"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("Array of chain lengths (bp)"\)], "Print"],

Cell[BoxData[
    \({0, 104, 0}\)], "Print"],

Cell[BoxData[
    \("Array of friction element positions (bp)"\)], "Print"],

Cell[BoxData[
    \({1, 53, 106}\)], "Print"],

Cell[BoxData[
    \("Array of Stokes radii (A)"\)], "Print"],

Cell[BoxData[
    \({55.717081770182105`, 56.26690933246489`, 
      55.717081770182105`}\)], "Print"],

Cell[BoxData[
    \("\n...doKirkwood..."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]" \
"\[InvisibleSpace]174.72278016856492`\),
      SequenceForm[ "i,j,rij:", "*", 1, " ", 2, " ", 174.72278016856492],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]328.7198554436894`\),
      SequenceForm[ "i,j,rij:", "*", 1, " ", 3, " ", 328.71985544368943],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]177.66872102126544`\),
      SequenceForm[ "i,j,rij:", "*", 2, " ", 3, " ", 177.66872102126544],
      Editable->False]], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1,s1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(3.211668203237934`*^-7\ \
g\)\/s, \(2.0894984898700697`*^-7\ g\)\/s, 1.9510991846860903`*^-12\ s}\),
      SequenceForm[ "   ", {
        Times[ 3.2116682032379339*^-07, g, 
          Power[ s, -1]], 
        Times[ 2.0894984898700697*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.9510991846860903*^-12, s]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("n = "\[InvisibleSpace]20\[InvisibleSpace]" ; dl = "\
\[InvisibleSpace]22.45693170152919`\),
      SequenceForm[ "n = ", 20, " ; dl = ", 22.456931701529189],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Chain of "\[InvisibleSpace]90\[InvisibleSpace]" \
segments,"\),
      SequenceForm[ "Chain of ", 90, " segments,"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("with displacements at segments "\[InvisibleSpace]{1, 
          90}\),
      SequenceForm[ "with displacements at segments ", {1, 90}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Stokes offset "\[InvisibleSpace]3.0076424054539146`\
\[InvisibleSpace]" A at "\[InvisibleSpace]50\[InvisibleSpace]" bp"\),
      SequenceForm[ 
      "Stokes offset ", 3.0076424054539146, " A at ", 50, " bp"],
      Editable->False]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
            {\("persistence\nlength"\), "510.`", "\<\"A\"\>"},
            {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
            {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
            {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
            {"\<\"turns\"\>", "1.6`", "\<\"turns\"\>"},
            {"\<\"pitch\"\>", \(-28.571`\), "\<\"A/turn\"\>"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("Array of chain lengths (bp)"\)], "Print"],

Cell[BoxData[
    \({0, 88, 0}\)], "Print"],

Cell[BoxData[
    \("Array of friction element positions (bp)"\)], "Print"],

Cell[BoxData[
    \({1, 45, 90}\)], "Print"],

Cell[BoxData[
    \("Array of Stokes radii (A)"\)], "Print"],

Cell[BoxData[
    \({56.139388672678535`, 50.56849284147468`, 
      56.139388672678535`}\)], "Print"],

Cell[BoxData[
    \("\n...doKirkwood..."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]" \
"\[InvisibleSpace]151.70139316032936`\),
      SequenceForm[ "i,j,rij:", "*", 1, " ", 2, " ", 151.70139316032936],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]291.8241765333811`\),
      SequenceForm[ "i,j,rij:", "*", 1, " ", 3, " ", 291.82417653338109],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]154.67255298398132`\),
      SequenceForm[ "i,j,rij:", "*", 2, " ", 3, " ", 154.67255298398132],
      Editable->False]], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1,s1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(3.1187123056735216`*^-7\ g\)\
\/s, \(1.9640696531698164`*^-7\ g\)\/s, 1.9510991846860903`*^-12\ s}\),
      SequenceForm[ "   ", {
        Times[ 3.1187123056735216*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.9640696531698164*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.9510991846860903*^-12, s]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("n = "\[InvisibleSpace]20\[InvisibleSpace]" ; dl = "\
\[InvisibleSpace]23.828322591761847`\),
      SequenceForm[ "n = ", 20, " ; dl = ", 23.828322591761847],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Chain of "\[InvisibleSpace]74\[InvisibleSpace]" \
segments,"\),
      SequenceForm[ "Chain of ", 74, " segments,"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("with displacements at segments "\[InvisibleSpace]{1, 
          74}\),
      SequenceForm[ "with displacements at segments ", {1, 74}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Stokes offset "\[InvisibleSpace]3.0076424054539146`\
\[InvisibleSpace]" A at "\[InvisibleSpace]50\[InvisibleSpace]" bp"\),
      SequenceForm[ 
      "Stokes offset ", 3.0076424054539146, " A at ", 50, " bp"],
      Editable->False]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
            {\("persistence\nlength"\), "510.`", "\<\"A\"\>"},
            {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
            {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
            {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
            {"\<\"turns\"\>", "1.7`", "\<\"turns\"\>"},
            {"\<\"pitch\"\>", \(-28.571`\), "\<\"A/turn\"\>"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("Array of chain lengths (bp)"\)], "Print"],

Cell[BoxData[
    \({0, 72, 0}\)], "Print"],

Cell[BoxData[
    \("Array of friction element positions (bp)"\)], "Print"],

Cell[BoxData[
    \({1, 37, 74}\)], "Print"],

Cell[BoxData[
    \("Array of Stokes radii (A)"\)], "Print"],

Cell[BoxData[
    \({56.55543582127602`, 44.67712957198618`, 56.55543582127602`}\)], "Print"],

Cell[BoxData[
    \("\n...doKirkwood..."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]" \
"\[InvisibleSpace]128.80902271110944`\),
      SequenceForm[ "i,j,rij:", "*", 1, " ", 2, " ", 128.80902271110944],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]241.53930091092656`\),
      SequenceForm[ "i,j,rij:", "*", 1, " ", 3, " ", 241.53930091092656],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]131.78571038098897`\),
      SequenceForm[ "i,j,rij:", "*", 2, " ", 3, " ", 131.78571038098897],
      Editable->False]], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1,s1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(3.0218214926835236`*^-7\ g\)\
\/s, \(1.8209115471218407`*^-7\ g\)\/s, 1.9510991846860903`*^-12\ s}\),
      SequenceForm[ "   ", {
        Times[ 3.0218214926835236*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.8209115471218407*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.9510991846860903*^-12, s]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("n = "\[InvisibleSpace]20\[InvisibleSpace]" ; dl = "\
\[InvisibleSpace]25.193895755258747`\),
      SequenceForm[ "n = ", 20, " ; dl = ", 25.193895755258747],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Chain of "\[InvisibleSpace]56\[InvisibleSpace]" \
segments,"\),
      SequenceForm[ "Chain of ", 56, " segments,"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("with displacements at segments "\[InvisibleSpace]{1, 
          56}\),
      SequenceForm[ "with displacements at segments ", {1, 56}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Stokes offset "\[InvisibleSpace]3.0076424054539146`\
\[InvisibleSpace]" A at "\[InvisibleSpace]50\[InvisibleSpace]" bp"\),
      SequenceForm[ 
      "Stokes offset ", 3.0076424054539146, " A at ", 50, " bp"],
      Editable->False]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
            {\("persistence\nlength"\), "510.`", "\<\"A\"\>"},
            {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
            {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
            {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
            {"\<\"turns\"\>", "1.8`", "\<\"turns\"\>"},
            {"\<\"pitch\"\>", \(-28.571`\), "\<\"A/turn\"\>"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("Array of chain lengths (bp)"\)], "Print"],

Cell[BoxData[
    \({0, 54, 0}\)], "Print"],

Cell[BoxData[
    \("Array of friction element positions (bp)"\)], "Print"],

Cell[BoxData[
    \({1, 28, 56}\)], "Print"],

Cell[BoxData[
    \("Array of Stokes radii (A)"\)], "Print"],

Cell[BoxData[
    \({57.01628855207165`, 37.789456544957446`, 
      57.01628855207165`}\)], "Print"],

Cell[BoxData[
    \("\n...doKirkwood..."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]" \
"\[InvisibleSpace]103.62250313014115`\),
      SequenceForm[ "i,j,rij:", "*", 1, " ", 2, " ", 103.62250313014115],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]182.45515240804966`\),
      SequenceForm[ "i,j,rij:", "*", 1, " ", 3, " ", 182.45515240804966],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]106.5456911430546`\),
      SequenceForm[ "i,j,rij:", "*", 2, " ", 3, " ", 106.5456911430546],
      Editable->False]], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1,s1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(2.9075663600047107`*^-7\ g\)\
\/s, \(1.6380458075439286`*^-7\ g\)\/s, 1.9510991846860903`*^-12\ s}\),
      SequenceForm[ "   ", {
        Times[ 2.9075663600047107*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.6380458075439286*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.9510991846860903*^-12, s]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("n = "\[InvisibleSpace]20\[InvisibleSpace]" ; dl = "\
\[InvisibleSpace]26.55331803428749`\),
      SequenceForm[ "n = ", 20, " ; dl = ", 26.553318034287489],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Chain of "\[InvisibleSpace]40\[InvisibleSpace]" \
segments,"\),
      SequenceForm[ "Chain of ", 40, " segments,"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("with displacements at segments "\[InvisibleSpace]{1, 
          40}\),
      SequenceForm[ "with displacements at segments ", {1, 40}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Stokes offset "\[InvisibleSpace]3.0076424054539146`\
\[InvisibleSpace]" A at "\[InvisibleSpace]50\[InvisibleSpace]" bp"\),
      SequenceForm[ 
      "Stokes offset ", 3.0076424054539146, " A at ", 50, " bp"],
      Editable->False]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
            {\("persistence\nlength"\), "510.`", "\<\"A\"\>"},
            {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
            {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
            {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
            {"\<\"turns\"\>", "1.9`", "\<\"turns\"\>"},
            {"\<\"pitch\"\>", \(-28.571`\), "\<\"A/turn\"\>"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("Array of chain lengths (bp)"\)], "Print"],

Cell[BoxData[
    \({0, 38, 0}\)], "Print"],

Cell[BoxData[
    \("Array of friction element positions (bp)"\)], "Print"],

Cell[BoxData[
    \({1, 20, 40}\)], "Print"],

Cell[BoxData[
    \("Array of Stokes radii (A)"\)], "Print"],

Cell[BoxData[
    \({57.41977121149366`, 31.11516799555567`, 57.41977121149366`}\)], "Print"],

Cell[BoxData[
    \("\n...doKirkwood..."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]" \
"\[InvisibleSpace]82.71654800800671`\),
      SequenceForm[ "i,j,rij:", "*", 1, " ", 2, " ", 82.716548008006711],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]138.4420903239821`\),
      SequenceForm[ "i,j,rij:", "*", 1, " ", 3, " ", 138.44209032398209],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]85.47155233210788`\),
      SequenceForm[ "i,j,rij:", "*", 2, " ", 3, " ", 85.471552332107876],
      Editable->False]], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1,s1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(2.795200379663063`*^-7\ \
g\)\/s, \(1.4644183163679808`*^-7\ g\)\/s, 1.9510991846860903`*^-12\ s}\),
      SequenceForm[ "   ", {
        Times[ 2.7952003796630628*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.4644183163679808*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.9510991846860903*^-12, s]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("n = "\[InvisibleSpace]20\[InvisibleSpace]" ; dl = "\
\[InvisibleSpace]27.906257816099018`\),
      SequenceForm[ "n = ", 20, " ; dl = ", 27.906257816099018],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Chain of "\[InvisibleSpace]24\[InvisibleSpace]" \
segments,"\),
      SequenceForm[ "Chain of ", 24, " segments,"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("with displacements at segments "\[InvisibleSpace]{1, 
          24}\),
      SequenceForm[ "with displacements at segments ", {1, 24}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Stokes offset "\[InvisibleSpace]3.0076424054539146`\
\[InvisibleSpace]" A at "\[InvisibleSpace]50\[InvisibleSpace]" bp"\),
      SequenceForm[ 
      "Stokes offset ", 3.0076424054539146, " A at ", 50, " bp"],
      Editable->False]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
            {\("persistence\nlength"\), "510.`", "\<\"A\"\>"},
            {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
            {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
            {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
            {"\<\"turns\"\>", "2.`", "\<\"turns\"\>"},
            {"\<\"pitch\"\>", \(-28.571`\), "\<\"A/turn\"\>"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("Array of chain lengths (bp)"\)], "Print"],

Cell[BoxData[
    \({0, 22, 0}\)], "Print"],

Cell[BoxData[
    \("Array of friction element positions (bp)"\)], "Print"],

Cell[BoxData[
    \({1, 12, 24}\)], "Print"],

Cell[BoxData[
    \("Array of Stokes radii (A)"\)], "Print"],

Cell[BoxData[
    \({57.81766172943429`, 23.79541967922709`, 57.81766172943429`}\)], "Print"],

Cell[BoxData[
    \("\n...doKirkwood..."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]" \
"\[InvisibleSpace]65.09401328700297`\),
      SequenceForm[ "i,j,rij:", "*", 1, " ", 2, " ", 65.094013287002966],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]125.45610700514469`\),
      SequenceForm[ "i,j,rij:", "*", 1, " ", 3, " ", 125.45610700514469],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i,j,rij:"\[InvisibleSpace]"*"\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]" \
"\[InvisibleSpace]67.3880280384592`\),
      SequenceForm[ "i,j,rij:", "*", 2, " ", 3, " ", 67.388028038459197],
      Editable->False]], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1,s1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(2.670258911402653`*^-7\ \
g\)\/s, \(1.349825209795697`*^-7\ g\)\/s, 1.9510991846860903`*^-12\ s}\),
      SequenceForm[ "   ", {
        Times[ 2.6702589114026532*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.3498252097956969*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.9510991846860903*^-12, s]}],
      Editable->False]], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
In the article, the f1 values calculated as above were stored in \
\"flist\" and converted to Dt values in the file \"Example 2 dinucleosomes.nb\
\" for Figure 4 using the following code. The calculated values are identical \
to those stored here (and plotted in that figure).\
\>", "Text",
  CellFrame->True,
  CellChangeTimes -> {{3.794913010238946*^9, 3.7949130931811733`*^9}},
  ExpressionUUID -> "84bae3b3-ac46-4383-b5ae-e13e048a6fcd",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[0.833326]],

Cell["\<\
turnlist={1.5,1.6,1.7,1.8,1.9,2.0};
flist={2.0895,1.96407,1.82091,1.63805,1.46442,1.34983};
Dtlist=10^7 gettrans[flist 10^-7,296.15]/.
\t{cm->1,g->1,s->1}\
\>", "Input",
  GroupPageBreakWithin->Automatic,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "5038a395-cced-4109-8d50-d79ea3864bca"]
}, Open  ]],

Cell[BoxData[
    \({1.9565175875026726`, 2.0814652731760246`, 2.245110136737584`, 
      2.495737919530438`, 2.7916468629811346`, 
      3.0286358275389005`}\)], "Output"]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{0, 1440}, {0, 877}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{714, 822},
WindowMargins->{{8, Automatic}, {1, Automatic}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowSelection->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1.5,
StyleDefinitions -> "Default.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 203, 6, 73, "Text"],
Cell[1960, 59, 1205, 24, 513, "Text",
  InitializationCell->True],
Cell[3168, 85, 169, 3, 39, "Input",
  InitializationCell->True],
Cell[3340, 90, 253, 8, 58, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],

Cell[CellGroupData[{
Cell[3618, 102, 166, 2, 41, "Subsubsection"],
Cell[3787, 106, 246, 5, 73, "Text"],
Cell[4036, 113, 147, 5, 58, "Input"],
Cell[4186, 120, 518, 9, 151, "Text"],
Cell[4707, 131, 242, 6, 78, "Input"],
Cell[4952, 139, 141, 5, 58, "Input"],

Cell[CellGroupData[{
Cell[5118, 148, 152, 5, 58, "Input"],
Cell[5273, 155, 47, 1, 40, "Output"]
}, Open  ]],
Cell[5335, 159, 301, 6, 99, "Text"],
Cell[5639, 167, 202, 9, 138, "Input"],

Cell[CellGroupData[{
Cell[5866, 180, 343, 12, 154, "Input"],
Cell[6212, 194, 230, 4, 34, "Print"],
Cell[6445, 200, 190, 4, 34, "Print"],
Cell[6638, 206, 210, 4, 34, "Print"],
Cell[6851, 212, 282, 5, 34, "Print"],
Cell[7136, 219, 680, 15, 196, "Print"],
Cell[7819, 236, 62, 1, 34, "Print"],
Cell[7884, 239, 44, 1, 34, "Print"],
Cell[7931, 242, 75, 1, 34, "Print"],
Cell[8009, 245, 45, 1, 34, "Print"],
Cell[8057, 248, 60, 1, 34, "Print"],
Cell[8120, 251, 102, 2, 34, "Print"],
Cell[8225, 255, 51, 1, 34, "Print"],
Cell[8279, 258, 412, 8, 34, "Print"],
Cell[8694, 268, 412, 8, 34, "Print"],
Cell[9109, 278, 414, 8, 34, "Print"],
Cell[9526, 288, 67, 1, 34, "Print"],
Cell[9596, 291, 84, 1, 34, "Print"],
Cell[9683, 294, 79, 1, 34, "Print"],
Cell[9765, 297, 414, 9, 56, "Print"],
Cell[10182, 308, 229, 4, 34, "Print"],
Cell[10414, 314, 188, 4, 34, "Print"],
Cell[10605, 320, 208, 4, 34, "Print"],
Cell[10816, 326, 282, 5, 34, "Print"],
Cell[11101, 333, 680, 15, 196, "Print"],
Cell[11784, 350, 62, 1, 34, "Print"],
Cell[11849, 353, 43, 1, 34, "Print"],
Cell[11895, 356, 75, 1, 34, "Print"],
Cell[11973, 359, 44, 1, 34, "Print"],
Cell[12020, 362, 60, 1, 34, "Print"],
Cell[12083, 365, 102, 2, 34, "Print"],
Cell[12188, 369, 51, 1, 34, "Print"],
Cell[12242, 372, 414, 8, 34, "Print"],
Cell[12659, 382, 410, 8, 34, "Print"],
Cell[13072, 392, 412, 8, 34, "Print"],
Cell[13487, 402, 67, 1, 34, "Print"],
Cell[13557, 405, 82, 1, 34, "Print"],
Cell[13642, 408, 79, 1, 34, "Print"],
Cell[13724, 411, 413, 9, 56, "Print"],
Cell[14140, 422, 230, 4, 34, "Print"],
Cell[14373, 428, 188, 4, 34, "Print"],
Cell[14564, 434, 208, 4, 34, "Print"],
Cell[14775, 440, 282, 5, 34, "Print"],
Cell[15060, 447, 680, 15, 196, "Print"],
Cell[15743, 464, 62, 1, 34, "Print"],
Cell[15808, 467, 43, 1, 34, "Print"],
Cell[15854, 470, 75, 1, 34, "Print"],
Cell[15932, 473, 44, 1, 34, "Print"],
Cell[15979, 476, 60, 1, 34, "Print"],
Cell[16042, 479, 93, 1, 34, "Print"],
Cell[16138, 482, 51, 1, 34, "Print"],
Cell[16192, 485, 413, 8, 34, "Print"],
Cell[16608, 495, 414, 8, 34, "Print"],
Cell[17025, 505, 413, 8, 34, "Print"],
Cell[17441, 515, 67, 1, 34, "Print"],
Cell[17511, 518, 82, 1, 34, "Print"],
Cell[17596, 521, 79, 1, 34, "Print"],
Cell[17678, 524, 414, 9, 56, "Print"],
Cell[18095, 535, 230, 4, 34, "Print"],
Cell[18328, 541, 188, 4, 34, "Print"],
Cell[18519, 547, 208, 4, 34, "Print"],
Cell[18730, 553, 282, 5, 34, "Print"],
Cell[19015, 560, 680, 15, 196, "Print"],
Cell[19698, 577, 62, 1, 34, "Print"],
Cell[19763, 580, 43, 1, 34, "Print"],
Cell[19809, 583, 75, 1, 34, "Print"],
Cell[19887, 586, 44, 1, 34, "Print"],
Cell[19934, 589, 60, 1, 34, "Print"],
Cell[19997, 592, 101, 2, 34, "Print"],
Cell[20101, 596, 51, 1, 34, "Print"],
Cell[20155, 599, 414, 8, 34, "Print"],
Cell[20572, 609, 414, 8, 34, "Print"],
Cell[20989, 619, 412, 8, 34, "Print"],
Cell[21404, 629, 67, 1, 34, "Print"],
Cell[21474, 632, 82, 1, 34, "Print"],
Cell[21559, 635, 79, 1, 34, "Print"],
Cell[21641, 638, 415, 9, 56, "Print"],
Cell[22059, 649, 229, 4, 34, "Print"],
Cell[22291, 655, 188, 4, 34, "Print"],
Cell[22482, 661, 208, 4, 34, "Print"],
Cell[22693, 667, 282, 5, 34, "Print"],
Cell[22978, 674, 680, 15, 196, "Print"],
Cell[23661, 691, 62, 1, 34, "Print"],
Cell[23726, 694, 43, 1, 34, "Print"],
Cell[23772, 697, 75, 1, 34, "Print"],
Cell[23850, 700, 44, 1, 34, "Print"],
Cell[23897, 703, 60, 1, 34, "Print"],
Cell[23960, 706, 93, 1, 34, "Print"],
Cell[24056, 709, 51, 1, 34, "Print"],
Cell[24110, 712, 412, 8, 34, "Print"],
Cell[24525, 722, 413, 8, 34, "Print"],
Cell[24941, 732, 411, 8, 34, "Print"],
Cell[25355, 742, 67, 1, 34, "Print"],
Cell[25425, 745, 82, 1, 34, "Print"],
Cell[25510, 748, 79, 1, 34, "Print"],
Cell[25592, 751, 414, 9, 56, "Print"],
Cell[26009, 762, 230, 4, 34, "Print"],
Cell[26242, 768, 188, 4, 34, "Print"],
Cell[26433, 774, 208, 4, 34, "Print"],
Cell[26644, 780, 282, 5, 34, "Print"],
Cell[26929, 787, 679, 15, 196, "Print"],
Cell[27611, 804, 62, 1, 34, "Print"],
Cell[27676, 807, 43, 1, 34, "Print"],
Cell[27722, 810, 75, 1, 34, "Print"],
Cell[27800, 813, 44, 1, 34, "Print"],
Cell[27847, 816, 60, 1, 34, "Print"],
Cell[27910, 819, 93, 1, 34, "Print"],
Cell[28006, 822, 51, 1, 34, "Print"],
Cell[28060, 825, 412, 8, 34, "Print"],
Cell[28475, 835, 414, 8, 34, "Print"],
Cell[28892, 845, 411, 8, 34, "Print"],
Cell[29306, 855, 67, 1, 34, "Print"],
Cell[29376, 858, 82, 1, 34, "Print"],
Cell[29461, 861, 79, 1, 34, "Print"],
Cell[29543, 864, 412, 9, 56, "Print"]
}, Open  ]]
}, Open  ]],
Cell[29982, 877, 448, 9, 175, "Text"],

Cell[CellGroupData[{
Cell[30455, 890, 344, 12, 154, "Input"],
Cell[30802, 904, 230, 4, 34, "Print"],
Cell[31035, 910, 190, 4, 34, "Print"],
Cell[31228, 916, 210, 4, 34, "Print"],
Cell[31441, 922, 282, 5, 34, "Print"],
Cell[31726, 929, 680, 15, 196, "Print"],
Cell[32409, 946, 62, 1, 34, "Print"],
Cell[32474, 949, 44, 1, 34, "Print"],
Cell[32521, 952, 75, 1, 34, "Print"],
Cell[32599, 955, 45, 1, 34, "Print"],
Cell[32647, 958, 60, 1, 34, "Print"],
Cell[32710, 961, 102, 2, 34, "Print"],
Cell[32815, 965, 53, 1, 58, "Print"],
Cell[32871, 968, 295, 5, 34, "Print"],
Cell[33169, 975, 294, 5, 34, "Print"],
Cell[33466, 982, 295, 5, 34, "Print"],
Cell[33764, 989, 79, 1, 34, "Print"],
Cell[33846, 992, 414, 9, 56, "Print"],
Cell[34263, 1003, 229, 4, 34, "Print"],
Cell[34495, 1009, 188, 4, 34, "Print"],
Cell[34686, 1015, 208, 4, 34, "Print"],
Cell[34897, 1021, 282, 5, 34, "Print"],
Cell[35182, 1028, 680, 15, 196, "Print"],
Cell[35865, 1045, 62, 1, 34, "Print"],
Cell[35930, 1048, 43, 1, 34, "Print"],
Cell[35976, 1051, 75, 1, 34, "Print"],
Cell[36054, 1054, 44, 1, 34, "Print"],
Cell[36101, 1057, 60, 1, 34, "Print"],
Cell[36164, 1060, 102, 2, 34, "Print"],
Cell[36269, 1064, 53, 1, 58, "Print"],
Cell[36325, 1067, 295, 5, 34, "Print"],
Cell[36623, 1074, 294, 5, 34, "Print"],
Cell[36920, 1081, 295, 5, 34, "Print"],
Cell[37218, 1088, 79, 1, 34, "Print"],
Cell[37300, 1091, 415, 9, 56, "Print"],
Cell[37718, 1102, 230, 4, 34, "Print"],
Cell[37951, 1108, 188, 4, 34, "Print"],
Cell[38142, 1114, 208, 4, 34, "Print"],
Cell[38353, 1120, 282, 5, 34, "Print"],
Cell[38638, 1127, 680, 15, 196, "Print"],
Cell[39321, 1144, 62, 1, 34, "Print"],
Cell[39386, 1147, 43, 1, 34, "Print"],
Cell[39432, 1150, 75, 1, 34, "Print"],
Cell[39510, 1153, 44, 1, 34, "Print"],
Cell[39557, 1156, 60, 1, 34, "Print"],
Cell[39620, 1159, 93, 1, 34, "Print"],
Cell[39716, 1162, 53, 1, 58, "Print"],
Cell[39772, 1165, 295, 5, 34, "Print"],
Cell[40070, 1172, 295, 5, 34, "Print"],
Cell[40368, 1179, 295, 5, 34, "Print"],
Cell[40666, 1186, 79, 1, 34, "Print"],
Cell[40748, 1189, 415, 9, 56, "Print"],
Cell[41166, 1200, 230, 4, 34, "Print"],
Cell[41399, 1206, 188, 4, 34, "Print"],
Cell[41590, 1212, 208, 4, 34, "Print"],
Cell[41801, 1218, 282, 5, 34, "Print"],
Cell[42086, 1225, 680, 15, 196, "Print"],
Cell[42769, 1242, 62, 1, 34, "Print"],
Cell[42834, 1245, 43, 1, 34, "Print"],
Cell[42880, 1248, 75, 1, 34, "Print"],
Cell[42958, 1251, 44, 1, 34, "Print"],
Cell[43005, 1254, 60, 1, 34, "Print"],
Cell[43068, 1257, 101, 2, 34, "Print"],
Cell[43172, 1261, 53, 1, 58, "Print"],
Cell[43228, 1264, 295, 5, 34, "Print"],
Cell[43526, 1271, 295, 5, 34, "Print"],
Cell[43824, 1278, 293, 5, 34, "Print"],
Cell[44120, 1285, 79, 1, 34, "Print"],
Cell[44202, 1288, 415, 9, 56, "Print"],
Cell[44620, 1299, 229, 4, 34, "Print"],
Cell[44852, 1305, 188, 4, 34, "Print"],
Cell[45043, 1311, 208, 4, 34, "Print"],
Cell[45254, 1317, 282, 5, 34, "Print"],
Cell[45539, 1324, 680, 15, 196, "Print"],
Cell[46222, 1341, 62, 1, 34, "Print"],
Cell[46287, 1344, 43, 1, 34, "Print"],
Cell[46333, 1347, 75, 1, 34, "Print"],
Cell[46411, 1350, 44, 1, 34, "Print"],
Cell[46458, 1353, 60, 1, 34, "Print"],
Cell[46521, 1356, 93, 1, 34, "Print"],
Cell[46617, 1359, 53, 1, 58, "Print"],
Cell[46673, 1362, 294, 5, 34, "Print"],
Cell[46970, 1369, 294, 5, 34, "Print"],
Cell[47267, 1376, 294, 5, 34, "Print"],
Cell[47564, 1383, 79, 1, 34, "Print"],
Cell[47646, 1386, 414, 9, 56, "Print"],
Cell[48063, 1397, 230, 4, 34, "Print"],
Cell[48296, 1403, 188, 4, 34, "Print"],
Cell[48487, 1409, 208, 4, 34, "Print"],
Cell[48698, 1415, 282, 5, 34, "Print"],
Cell[48983, 1422, 679, 15, 196, "Print"],
Cell[49665, 1439, 62, 1, 34, "Print"],
Cell[49730, 1442, 43, 1, 34, "Print"],
Cell[49776, 1445, 75, 1, 34, "Print"],
Cell[49854, 1448, 44, 1, 34, "Print"],
Cell[49901, 1451, 60, 1, 34, "Print"],
Cell[49964, 1454, 93, 1, 34, "Print"],
Cell[50060, 1457, 53, 1, 58, "Print"],
Cell[50116, 1460, 294, 5, 34, "Print"],
Cell[50413, 1467, 295, 5, 34, "Print"],
Cell[50711, 1474, 293, 5, 34, "Print"],
Cell[51007, 1481, 79, 1, 34, "Print"],
Cell[51089, 1484, 413, 9, 56, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[51539, 1498, 517, 10, 149, "Text"],
Cell[52059, 1510, 307, 8, 118, "Input"]
}, Open  ]],
Cell[52381, 1521, 172, 3, 40, "Output"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

