(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    262633,       7140]*)
(*NotebookOutlinePosition[    263638,       7175]*)
(*  CellTagsIndexPosition[    263594,       7171]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
17-30 January 1995 CHR,  continuing from \"Oseen\", 2 November 1994
Use Zimm (1980) formulation to solve hydrodynamics of a given subunit array. \
Compare various aspects of the Kirkwood/Bloomfield et al. (which I will \
sometimes call \"K/B\") approximation.\
\>", "Text",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "dd8c626d-d4db-429b-b842-5b3ee75eaba8"],

Cell[TextData[{
  "CHR started 18 Feb 2020. Test of reproducibility for the ReScience 10-year \
reproducibility challenge (https://rescience.github.io/ten-years/). Chosen \
paper is Robert, C.H. (1995) Estimating Friction Coefficients of Mixed \
Globular/Chain Molecules, such as Protein/DNA Complexes. Biophys J. 69, \
840-48.\n\nAll code in this file came from the original notebook \"s6.0 Zimm \
(1980).nb\" and was run using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " versions 5.2 and 12.0.\nChanges:\n- added dependence on library s6.1.1 \
(Get[...])\n- added comments\n- copied in MatrixForm tables of original \
results for direct comparison\n- added new final plot that matches Figure 3 \
in the published article for easier comparison\n\nBlue and gray boxes \
indicate results to compare to originals as well as certain comments."
}], "Text",
  CellFrame->True,
  InitializationCell->True,
  ExpressionUUID -> "4e3a218b-be26-4640-a1f2-d8b9b5531067",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[0.833326]],

Cell[BoxData[
    \(\(Get["\<ReScience/\>" <> "\<s6.1_repro.m\>"];\)\)], "Input",
  InitializationCell->True,
  ExpressionUUID -> "bc8446c2-357a-4acf-b781-b5ca975580fb"],

Cell[CellGroupData[{

Cell["\<\
General functions to define interaction tensor, velocity \
perturbations, etc.\
\>", "Subsubsection",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "eee7abd4-1720-47d7-a2f2-566ce75c99f4"],

Cell["\<\
Off[General::spell];
Off[General::spell1];\
\>", "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "1ee83d32-0cac-416d-9dc0-227be9be9d10"],

Cell["avg[x_]:=Apply[Plus,x]/Length[x];", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "aa933b91-b2cb-450c-a913-2ccd9b203711"],

Cell["\<\
l[r_]:=Sqrt[r.r];
rr[r_]:=Outer[Times,r,r];
Id[n_]:=IdentityMatrix[n];
zero[n_]:=Table[0,{n},{n}];\
\>", "Input",
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "f8be7ac8-0a76-4829-9d88-cdd3af80299b"],

Cell["T[r_]:=1/(8 Pi nu l[r])(Id[Length[r]]+rr[r]/l[r]^2);", "Input",
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "ec8d89f7-da76-4331-bbf5-945812918872"],

Cell[CellGroupData[{

Cell["MatrixForm[T[{x,y,z}]]", "Input",
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "71d203c7-48ba-49db-a40c-a7a9d5bb1cc2"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(\(1 + 
                    x\^2\/\(x\^2 + y\^2 + z\^2\)\)\/\(8\ nu\ \[Pi]\ \@\(x\^2 \
+ y\^2 + z\^2\)\)\), \(\(x\ y\)\/\(8\ nu\ \[Pi]\ \((x\^2 + y\^2 + \
z\^2)\)\^\(3/2\)\)\), \(\(x\ z\)\/\(8\ nu\ \[Pi]\ \((x\^2 + y\^2 + \
z\^2)\)\^\(3/2\)\)\)},
            {\(\(x\ y\)\/\(8\ nu\ \[Pi]\ \((x\^2 + y\^2 + \
z\^2)\)\^\(3/2\)\)\), \(\(1 + 
                    y\^2\/\(x\^2 + y\^2 + z\^2\)\)\/\(8\ nu\ \[Pi]\ \@\(x\^2 \
+ y\^2 + z\^2\)\)\), \(\(y\ z\)\/\(8\ nu\ \[Pi]\ \((x\^2 + y\^2 + \
z\^2)\)\^\(3/2\)\)\)},
            {\(\(x\ z\)\/\(8\ nu\ \[Pi]\ \((x\^2 + y\^2 + \
z\^2)\)\^\(3/2\)\)\), \(\(y\ z\)\/\(8\ nu\ \[Pi]\ \((x\^2 + y\^2 + \
z\^2)\)\^\(3/2\)\)\), \(\(1 + 
                    z\^2\/\(x\^2 + y\^2 + z\^2\)\)\/\(8\ nu\ \[Pi]\ \@\(x\^2 \
+ y\^2 + z\^2\)\)\)}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["Velocity and velocity perturbation functions.", "Text",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "ac37265c-0aeb-4626-a25d-05efddfe381e"],

Cell["\<\
V[i_,{p_,radius_}]:=Id[3]/(6 Pi nu radius[[i]])
dV[i_,j_,{p_,radius_}]:=T[p[[j]]-p[[i]]];
u[i_,{p_,radius_}]:={-p[[i,2]],p[[i,1]],0};
z[i_,{p_,radius_}]:={p[[i,2]],-p[[i,1]],0};\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "1f054c95-0db6-45f4-9945-8358f971a3f2"],

Cell["Demonstrate some velocity profiles", "Text",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "ac596702-0e90-4447-93e4-c7d3f17f6fb7"],

Cell[TextData[{
  "The perturbation of the velocity of the fluid at a given point r{x,y,z} \
with respect to a frictional sphere is given by the following expression for \
dv for a force f {x,y,z} acting on the center.\n\nThe viscosity nu has \
typically the units of poise, or g/(cm sec). If distances are in cm and force \
is (g cm/sec",
  StyleBox["2",
    FontSize->10,
    FontVariations->{"CompatibilityType"->"Superscript"}],
  "), the velocity given here is cm/sec.\nThe relative velocity dv0 is the \
relative solvent velocity perturbation about a particle travelling with \
whatever velocity results from a unit force acting on it, expressed in terms \
of the distance relative to the particle radius. The factor of the particle \
radius cancels. A positive value says that the sphere is dragging fluid with \
it."
}], "Text",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "fbedbbcd-1ce7-494c-9450-2c98eba0ce76"],

Cell["\<\
ClearAll[dv,dv0];
dv[r_,f_]:=T[r].f;
dv0[r0_,f0_]:=dv[r0,f0] 6 Pi nu; \
\>", "Input",
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "6da2bbb1-d1cf-4d61-bed3-8614e1ee61e4"],

Cell[CellGroupData[{

Cell["dv[{1,0,0} cm,{1,0,0} g cm/s^2]/.nu->g/(cm s)", "Input",
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "c1253b67-e300-4faa-a823-c372f457934d"],

Cell[BoxData[
    \({\@cm\^2\/\(4\ \[Pi]\ s\), 0, 0}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["dv0[{1,0,0},{1,0,0}]", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "219a4c04-751f-4f0e-b78e-e1be5a51824c"],

Cell[BoxData[
    \({3\/2, 0, 0}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["dv0[{1.1,0,0},{fx,fy,fz}]", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "6859774f-bd9c-47f1-9612-bd42799852ca"],

Cell[BoxData[
    \({1.3636363636363635`\ fx, 0.6818181818181818`\ fy, 
      0.6818181818181818`\ fz}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Plot3D[r={x,y,0};l[N[dv0[r,{1,0,0}]]],
\t{x,-2,2},{y,-2,2},PlotPoints->20,
\tAxesLabel->{\"x\",\"y\",\"z\"}]\
\>", "Input",
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "f37e8b4b-cd36-40d8-8d04-f7a0962fd2e0"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.11022e-16 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -12 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.17646 .18758 -11.7989 -9 ]
[.17646 .18758 .20112 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.50253 .05935 -5.27396 -9 ]
[.50253 .05935 .72604 0 ]
[.68156 -0.01098 -4.96123 -9 ]
[.68156 -0.01098 1.03877 0 ]
[.29165 .07573 -9.31117 -12 ]
[.29165 .07573 .68883 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 12 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 12 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 6 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.91861 .21225 0 -8.04169 ]
[.91861 .21225 10 3.95831 ]
[.02188 .27912 -18 -2.75415 ]
[.02188 .27912 0 6.24585 ]
[.01265 .33696 -6 -2.80311 ]
[.01265 .33696 0 6.19689 ]
[.00307 .39701 -18 -2.85412 ]
[.00307 .39701 0 6.14588 ]
[-0.00688 .45939 -6 -2.90733 ]
[-0.00688 .45939 0 6.09267 ]
[-0.05457 .39542 -10 -3.77786 ]
[-0.05457 .39542 0 8.22214 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(-2)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(-1)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(1)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(2)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
gsave
.29165 .07573 -70.3112 -16 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(-2)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(-1)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(1)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(2)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
gsave
.91861 .21225 -61 -12.0417 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03411 .27438 m
.04023 .272 L
s
[(0.5)] .02188 .27912 1 -0.38797 Mshowa
.02493 .33233 m
.03107 .33002 L
s
[(1)] .01265 .33696 1 -0.37709 Mshowa
.01539 .3925 m
.02155 .39025 L
s
[(1.5)] .00307 .39701 1 -0.36575 Mshowa
.00549 .45501 m
.01167 .45282 L
s
[(2)] -0.00688 .45939 1 -0.35393 Mshowa
.125 Mabswid
.0323 .2858 m
.03597 .28438 L
s
.03048 .2973 m
.03415 .29589 L
s
.02864 .30889 m
.03232 .30749 L
s
.02679 .32057 m
.03047 .31917 L
s
.02305 .34419 m
.02673 .34281 L
s
.02116 .35613 m
.02484 .35476 L
s
.01925 .36816 m
.02294 .3668 L
s
.01733 .38029 m
.02102 .37893 L
s
.01344 .40481 m
.01714 .40347 L
s
.01147 .41722 m
.01518 .41588 L
s
.00949 .42972 m
.0132 .42839 L
s
.0075 .44232 m
.01121 .441 L
s
.03591 .26304 m
.03958 .26161 L
s
.00346 .46781 m
.00717 .4665 L
s
.00141 .4807 m
.00513 .4794 L
s
gsave
-0.05457 .39542 -71 -7.77786 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(z) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.633 .79 .957 r
.38864 .59703 .40497 .60819 .43202 .60088 .41587 .59007 Metetra
.637 .798 .96 r
.41587 .59007 .43202 .60088 .45937 .5932 .44342 .58273 Metetra
.642 .807 .962 r
.44342 .58273 .45937 .5932 .48701 .58506 .47127 .57488 Metetra
.651 .815 .962 r
.47127 .57488 .48701 .58506 .51493 .57638 .49942 .56638 Metetra
.661 .823 .961 r
.49942 .56638 .51493 .57638 .54313 .56713 .52786 .55712 Metetra
.672 .827 .958 r
.52786 .55712 .54313 .56713 .57161 .55737 .55659 .54712 Metetra
.679 .828 .955 r
.55659 .54712 .57161 .55737 .60035 .5473 .58558 .53658 Metetra
.68 .823 .952 r
.58558 .53658 .60035 .5473 .62937 .53725 .61485 .52596 Metetra
.671 .815 .952 r
.61485 .52596 .62937 .53725 .6587 .52764 .64442 .51588 Metetra
.654 .805 .956 r
.64442 .51588 .6587 .52764 .68836 .51874 .67434 .50682 Metetra
.635 .8 .962 r
.67434 .50682 .68836 .51874 .71838 .51057 .70463 .49879 Metetra
.622 .8 .967 r
.70463 .49879 .71838 .51057 .74876 .50283 .73532 .49131 Metetra
.619 .805 .971 r
.73532 .49131 .74876 .50283 .77951 .49513 .76637 .48376 Metetra
.625 .813 .972 r
.76637 .48376 .77951 .49513 .8106 .48712 .79776 .47568 Metetra
.636 .818 .97 r
.79776 .47568 .8106 .48712 .84201 .47859 .82945 .46683 Metetra
.649 .82 .966 r
.82945 .46683 .84201 .47859 .87373 .46947 .86144 .45719 Metetra
.66 .818 .96 r
.86144 .45719 .87373 .46947 .90574 .45977 .89372 .44685 Metetra
.668 .814 .954 r
.89372 .44685 .90574 .45977 .93806 .44956 .92629 .43596 Metetra
.674 .809 .948 r
.92629 .43596 .93806 .44956 .97067 .43894 .95916 .42464 Metetra
.619 .791 .965 r
.37194 .58599 .38864 .59703 .41587 .59007 .39936 .57954 Metetra
.62 .802 .969 r
.39936 .57954 .41587 .59007 .44342 .58273 .42709 .57276 Metetra
.624 .814 .973 r
.42709 .57276 .44342 .58273 .47127 .57488 .45516 .56545 Metetra
.633 .826 .975 r
.45516 .56545 .47127 .57488 .49942 .56638 .48354 .5574 Metetra
.647 .839 .974 r
.48354 .5574 .49942 .56638 .52786 .55712 .51224 .54838 Metetra
.663 .849 .971 r
.51224 .54838 .52786 .55712 .55659 .54712 .54123 .53827 Metetra
.678 .853 .966 r
.54123 .53827 .55659 .54712 .58558 .53658 .57049 .52723 Metetra
.683 .849 .962 r
.57049 .52723 .58558 .53658 .61485 .52596 .60003 .51586 Metetra
.673 .838 .962 r
.60003 .51586 .61485 .52596 .64442 .51588 .62986 .50515 Metetra
.648 .824 .968 r
.62986 .50515 .64442 .51588 .67434 .50682 .66005 .49592 Metetra
.619 .815 .976 r
.66005 .49592 .67434 .50682 .70463 .49879 .69065 .4882 Metetra
.599 .815 .983 r
.69065 .4882 .70463 .49879 .73532 .49131 .72165 .48115 Metetra
.598 .824 .986 r
.72165 .48115 .73532 .49131 .76637 .48376 .75303 .47379 Metetra
.612 .835 .985 r
.75303 .47379 .76637 .48376 .79776 .47568 .78473 .46548 Metetra
.632 .841 .98 r
.78473 .46548 .79776 .47568 .82945 .46683 .81671 .45606 Metetra
.651 .841 .973 r
.81671 .45606 .82945 .46683 .86144 .45719 .84896 .44563 Metetra
.666 .837 .965 r
.84896 .44563 .86144 .45719 .89372 .44685 .88149 .43439 Metetra
.676 .829 .957 r
.88149 .43439 .89372 .44685 .92629 .43596 .91431 .42257 Metetra
.682 .82 .949 r
.91431 .42257 .92629 .43596 .95916 .42464 .94743 .41037 Metetra
.599 .791 .972 r
.35488 .575 .37194 .58599 .39936 .57954 .38246 .56927 Metetra
.595 .803 .979 r
.38246 .56927 .39936 .57954 .42709 .57276 .41038 .56332 Metetra
.595 .817 .985 r
.41038 .56332 .42709 .57276 .45516 .56545 .43864 .55692 Metetra
.6 .835 .989 r
.43864 .55692 .45516 .56545 .48354 .5574 .46726 .54975 Metetra
.615 .855 .989 r
.46726 .54975 .48354 .5574 .51224 .54838 .49622 .54141 Metetra
.638 .874 .985 r
.49622 .54141 .51224 .54838 .54123 .53827 .5255 .53153 Metetra
.666 .886 .979 r
.5255 .53153 .54123 .53827 .57049 .52723 .55506 .52007 Metetra
.683 .886 .973 r
.55506 .52007 .57049 .52723 .60003 .51586 .58489 .50773 Metetra
.674 .872 .973 r
.58489 .50773 .60003 .51586 .62986 .50515 .61501 .49607 Metetra
.634 .85 .982 r
.61501 .49607 .62986 .50515 .66005 .49592 .64549 .48668 Metetra
.583 .833 .992 r
.64549 .48668 .66005 .49592 .69065 .4882 .67642 .47957 Metetra
.553 .834 .998 r
.67642 .47957 .69065 .4882 .72165 .48115 .70779 .47319 Metetra
.56 .849 .997 r
.70779 .47319 .72165 .48115 .75303 .47379 .73951 .46593 Metetra
.592 .865 .994 r
.73951 .46593 .75303 .47379 .78473 .46548 .77152 .45707 Metetra
.629 .872 .988 r
.77152 .45707 .78473 .46548 .81671 .45606 .80378 .44662 Metetra
.658 .869 .979 r
.80378 .44662 .81671 .45606 .84896 .44563 .83628 .43493 Metetra
.677 .858 .968 r
.83628 .43493 .84896 .44563 .88149 .43439 .86905 .42241 Metetra
.688 .845 .958 r
.86905 .42241 .88149 .43439 .91431 .42257 .9021 .40938 Metetra
.693 .831 .949 r
.9021 .40938 .91431 .42257 .94743 .41037 .93545 .39606 Metetra
.573 .786 .98 r
.33742 .56396 .35488 .575 .38246 .56927 .36515 .55915 Metetra
.559 .798 .988 r
.36515 .55915 .38246 .56927 .41038 .56332 .39324 .55436 Metetra
.547 .813 .995 r
.39324 .55436 .41038 .56332 .43864 .55692 .4217 .54936 Metetra
.538 .833 .999 r
.4217 .54936 .43864 .55692 .46726 .54975 .45054 .54375 Metetra
.542 .859 .997 r
.45054 .54375 .46726 .54975 .49622 .54141 .47976 .53689 Metetra
.568 .889 .988 r
.47976 .53689 .49622 .54141 .5255 .53153 .50935 .52801 Metetra
.616 .918 .977 r
.50935 .52801 .5255 .53153 .55506 .52007 .53925 .51652 Metetra
.662 .932 .97 r
.53925 .51652 .55506 .52007 .58489 .50773 .56942 .50294 Metetra
.665 .92 .975 r
.56942 .50294 .58489 .50773 .61501 .49607 .59985 .48978 Metetra
.598 .884 .991 r
.59985 .48978 .61501 .49607 .64549 .48668 .63066 .48023 Metetra
.495 .843 .995 r
.63066 .48023 .64549 .48668 .67642 .47957 .66198 .47431 Metetra
.442 .836 .982 r
.66198 .47431 .67642 .47957 .70779 .47319 .69375 .46885 Metetra
.477 .865 .974 r
.69375 .46885 .70779 .47319 .73951 .46593 .72583 .46131 Metetra
.556 .899 .979 r
.72583 .46131 .73951 .46593 .77152 .45707 .75814 .45111 Metetra
.627 .911 .982 r
.75814 .45111 .77152 .45707 .80378 .44662 .79066 .43881 Metetra
.672 .902 .977 r
.79066 .43881 .80378 .44662 .83628 .43493 .82339 .42518 Metetra
.695 .882 .967 r
.82339 .42518 .83628 .43493 .86905 .42241 .85637 .41086 Metetra
.704 .861 .957 r
.85637 .41086 .86905 .42241 .9021 .40938 .88963 .39625 Metetra
.706 .842 .947 r
.88963 .39625 .9021 .40938 .93545 .39606 .9232 .3816 Metetra
.541 .775 .985 r
.31958 .55265 .33742 .56396 .36515 .55915 .34744 .54896 Metetra
.512 .784 .994 r
.34744 .54896 .36515 .55915 .39324 .55436 .37567 .54568 Metetra
.473 .793 .999 r
.37567 .54568 .39324 .55436 .4217 .54936 .40428 .54267 Metetra
.426 .803 .992 r
.40428 .54267 .4217 .54936 .45054 .54375 .43331 .53955 Metetra
.38 .811 .964 r
.43331 .53955 .45054 .54375 .47976 .53689 .46278 .53555 Metetra
.365 .827 .915 r
.46278 .53555 .47976 .53689 .50935 .52801 .49269 .5293 Metetra
.421 .867 .872 r
.49269 .5293 .50935 .52801 .53925 .51652 .52298 .51907 Metetra
.535 .925 .866 r
.52298 .51907 .53925 .51652 .56942 .50294 .55356 .50424 Metetra
.594 .948 .898 r
.55356 .50424 .56942 .50294 .59985 .48978 .58436 .48849 Metetra
.47 .884 .93 r
.58436 .48849 .59985 .48978 .63066 .48023 .61557 .47879 Metetra
.223 .741 .857 r
.61557 .47879 .63066 .48023 .66198 .47431 .64736 .47517 Metetra
.151 .694 .762 r
.64736 .47517 .66198 .47431 .69375 .46885 .67959 .47068 Metetra
.289 .787 .788 r
.67959 .47068 .69375 .46885 .72583 .46131 .71204 .46157 Metetra
.489 .902 .883 r
.71204 .46157 .72583 .46131 .75814 .45111 .74461 .44836 Metetra
.632 .948 .946 r
.74461 .44836 .75814 .45111 .79066 .43881 .77733 .43281 Metetra
.699 .936 .964 r
.77733 .43281 .79066 .43881 .82339 .42518 .81024 .41626 Metetra
.722 .905 .96 r
.81024 .41626 .82339 .42518 .85637 .41086 .8434 .39952 Metetra
.726 .875 .951 r
.8434 .39952 .85637 .41086 .88963 .39625 .87686 .38297 Metetra
.723 .849 .942 r
.87686 .38297 .88963 .39625 .9232 .3816 .91065 .36676 Metetra
.507 .759 .987 r
.30135 .54078 .31958 .55265 .34744 .54896 .32932 .53833 Metetra
.455 .759 .995 r
.32932 .53833 .34744 .54896 .37567 .54568 .35766 .53685 Metetra
.373 .749 .99 r
.35766 .53685 .37567 .54568 .40428 .54267 .38639 .5364 Metetra
.245 .714 .944 r
.38639 .5364 .40428 .54267 .43331 .53955 .41556 .53691 Metetra
.072 .628 .811 r
.41556 .53691 .43331 .53955 .46278 .53555 .44521 .53781 Metetra
.076 0 0 r
.44521 .53781 .46278 .53555 .49269 .5293 .4754 .53742 Metetra
.089 0 0 r
.4754 .53742 .49269 .5293 .52298 .51907 .50612 .5322 Metetra
.50612 .5322 .52298 .51907 .55356 .50424 .53723 .51773 Metetra
.53723 .51773 .55356 .50424 .58436 .48849 .56853 .49717 Metetra
.56853 .49717 .58436 .48849 .61557 .47879 .60023 .48733 Metetra
.307 0 0 r
.60023 .48733 .61557 .47879 .64736 .47517 .63265 .48831 Metetra
.242 0 0 r
.63265 .48831 .64736 .47517 .67959 .47068 .6654 .48321 Metetra
.6654 .48321 .67959 .47068 .71204 .46157 .69815 .46875 Metetra
.407 .828 .656 r
.69815 .46875 .71204 .46157 .74461 .44836 .73088 .44927 Metetra
.658 .972 .87 r
.73088 .44927 .74461 .44836 .77733 .43281 .76372 .42835 Metetra
.743 .964 .936 r
.76372 .42835 .77733 .43281 .81024 .41626 .79677 .40771 Metetra
.756 .921 .945 r
.79677 .40771 .81024 .41626 .8434 .39952 .8301 .38793 Metetra
.75 .881 .939 r
.8301 .38793 .8434 .39952 .87686 .38297 .86374 .36913 Metetra
.739 .851 .932 r
.86374 .36913 .87686 .38297 .91065 .36676 .89775 .35123 Metetra
.477 .738 .985 r
.28276 .528 .30135 .54078 .32932 .53833 .31082 .52675 Metetra
.401 .724 .989 r
.31082 .52675 .32932 .53833 .35766 .53685 .33924 .52712 Metetra
.267 .684 .967 r
.33924 .52712 .35766 .53685 .38639 .5364 .36803 .52957 Metetra
.03 .566 .851 r
.36803 .52957 .38639 .5364 .41556 .53691 .39726 .53467 Metetra
.288 0 0 r
.39726 .53467 .41556 .53691 .44521 .53781 .42699 .54287 Metetra
.505 0 0 r
.42699 .54287 .44521 .53781 .4754 .53742 .45732 .55369 Metetra
.544 .072 .085 r
.45732 .55369 .4754 .53742 .50612 .5322 .48839 .56313 Metetra
.422 .022 .173 r
.48839 .56313 .50612 .5322 .53723 .51773 .52021 .55866 Metetra
.159 0 .123 r
.52021 .55866 .53723 .51773 .56853 .49717 .5523 .52984 Metetra
.364 0 .16 r
.5523 .52984 .56853 .49717 .60023 .48733 .58473 .51993 Metetra
.558 .163 .25 r
.58473 .51993 .60023 .48733 .63265 .48831 .61809 .52911 Metetra
.353 0 .215 r
.61809 .52911 .63265 .48831 .6654 .48321 .6513 .5138 Metetra
.037 0 0 r
.6513 .5138 .6654 .48321 .69815 .46875 .68412 .48422 Metetra
.68412 .48422 .69815 .46875 .73088 .44927 .71685 .453 Metetra
.733 .988 .796 r
.71685 .453 .73088 .44927 .76372 .42835 .74973 .42425 Metetra
.802 .975 .904 r
.74973 .42425 .76372 .42835 .79677 .40771 .78288 .39849 Metetra
.793 .92 .923 r
.78288 .39849 .79677 .40771 .8301 .38793 .81636 .37533 Metetra
.772 .876 .923 r
.81636 .37533 .8301 .38793 .86374 .36913 .85021 .3542 Metetra
.754 .845 .92 r
.85021 .3542 .86374 .36913 .89775 .35123 .88444 .33463 Metetra
.459 .716 .979 r
.26383 .51388 .28276 .528 .31082 .52675 .29198 .51359 Metetra
.368 .69 .981 r
.29198 .51359 .31082 .52675 .33924 .52712 .32046 .51552 Metetra
.197 .621 .948 r
.32046 .51552 .33924 .52712 .36803 .52957 .34929 .52061 Metetra
0 .431 .779 r
.34929 .52061 .36803 .52957 .39726 .53467 .3785 .53035 Metetra
.514 0 0 r
.3785 .53035 .39726 .53467 .42699 .54287 .40816 .54714 Metetra
.719 .224 .064 r
.40816 .54714 .42699 .54287 .45732 .55369 .43837 .57474 Metetra
.757 .359 .298 r
.43837 .57474 .45732 .55369 .48839 .56313 .4694 .61746 Metetra
.511 .172 .329 r
.4694 .61746 .48839 .56313 .52021 .55866 .50208 .61793 Metetra
.45 .124 .32 r
.50208 .61793 .52021 .55866 .5523 .52984 .53532 .60822 Metetra
.478 .176 .376 r
.53532 .60822 .5523 .52984 .58473 .51993 .56896 .5984 Metetra
.478 .176 .376 r
.56896 .5984 .58473 .51993 .61809 .52911 .60302 .58845 Metetra
.378 .061 .295 r
.60302 .58845 .61809 .52911 .6513 .5138 .63717 .56815 Metetra
0 0 .088 r
.63717 .56815 .6513 .5138 .68412 .48422 .66965 .50454 Metetra
.622 .827 .425 r
.66965 .50454 .68412 .48422 .71685 .453 .70225 .45588 Metetra
.858 .997 .782 r
.70225 .45588 .71685 .453 .74973 .42425 .73515 .41794 Metetra
.855 .952 .876 r
.73515 .41794 .74973 .42425 .78288 .39849 .76843 .38701 Metetra
.819 .896 .897 r
.76843 .38701 .78288 .39849 .81636 .37533 .80211 .36069 Metetra
.787 .857 .903 r
.80211 .36069 .81636 .37533 .85021 .3542 .83618 .33751 Metetra
.763 .83 .904 r
.83618 .33751 .85021 .3542 .88444 .33463 .87067 .31652 Metetra
.459 .697 .97 r
.24459 .49809 .26383 .51388 .29198 .51359 .27284 .49827 Metetra
.37 .664 .971 r
.27284 .49827 .29198 .51359 .32046 .51552 .30139 .50106 Metetra
.203 .588 .944 r
.30139 .50106 .32046 .51552 .34929 .52061 .33026 .50772 Metetra
0 .392 .8 r
.33026 .50772 .34929 .52061 .3785 .53035 .35946 .52049 Metetra
.561 0 0 r
.35946 .52049 .3785 .53035 .40816 .54714 .38899 .54358 Metetra
.81 .334 .077 r
.38899 .54358 .40816 .54714 .43837 .57474 .41888 .58613 Metetra
.673 .196 .111 r
.41888 .58613 .43837 .57474 .4694 .61746 .45055 .60973 Metetra
.587 .873 .994 r
.45055 .60973 .4694 .61746 .50208 .61793 .48365 .59992 Metetra
.645 .763 .934 r
.48365 .59992 .50208 .61793 .53532 .60822 .51715 .58999 Metetra
.645 .763 .934 r
.51715 .58999 .53532 .60822 .56896 .5984 .55107 .57993 Metetra
.645 .763 .934 r
.55107 .57993 .56896 .5984 .60302 .58845 .58541 .56976 Metetra
.645 .763 .934 r
.58541 .56976 .60302 .58845 .63717 .56815 .62018 .55945 Metetra
.91 .893 .8 r
.62018 .55945 .63717 .56815 .66965 .50454 .65407 .51499 Metetra
.938 .95 .628 r
.65407 .51499 .66965 .50454 .70225 .45588 .6867 .45067 Metetra
.924 .933 .793 r
.6867 .45067 .70225 .45588 .73515 .41794 .71978 .40584 Metetra
.868 .886 .846 r
.71978 .40584 .73515 .41794 .76843 .38701 .7533 .37136 Metetra
.822 .85 .869 r
.7533 .37136 .76843 .38701 .80211 .36069 .78725 .34298 Metetra
.789 .826 .881 r
.78725 .34298 .80211 .36069 .83618 .33751 .82162 .31846 Metetra
.764 .808 .888 r
.82162 .31846 .83618 .33751 .87067 .31652 .85641 .29652 Metetra
.476 .683 .957 r
.22509 .48038 .24459 .49809 .27284 .49827 .25346 .48041 Metetra
.404 .651 .958 r
.25346 .48041 .27284 .49827 .30139 .50106 .28213 .48305 Metetra
.281 .587 .945 r
.28213 .48305 .30139 .50106 .33026 .50772 .3111 .4896 Metetra
.053 .449 .878 r
.3111 .4896 .33026 .50772 .35946 .52049 .34036 .50227 Metetra
0 .157 .648 r
.34036 .50227 .35946 .52049 .38899 .54358 .36991 .52533 Metetra
.735 .243 0 r
.36991 .52533 .38899 .54358 .41888 .58613 .39972 .56795 Metetra
0 .184 .671 r
.39972 .56795 .41888 .58613 .45055 .60973 .43144 .59152 Metetra
.645 .763 .934 r
.43144 .59152 .45055 .60973 .48365 .59992 .4648 .58149 Metetra
.645 .763 .934 r
.4648 .58149 .48365 .59992 .51715 .58999 .49857 .57133 Metetra
.645 .763 .934 r
.49857 .57133 .51715 .58999 .55107 .57993 .53276 .56104 Metetra
.645 .763 .934 r
.53276 .56104 .55107 .57993 .58541 .56976 .56738 .55063 Metetra
.645 .763 .934 r
.56738 .55063 .58541 .56976 .62018 .55945 .60244 .54008 Metetra
.872 .803 .78 r
.60244 .54008 .62018 .55945 .65407 .51499 .6368 .49518 Metetra
.916 .794 .712 r
.6368 .49518 .65407 .51499 .6867 .45067 .66998 .43032 Metetra
.875 .801 .774 r
.66998 .43032 .6867 .45067 .71978 .40584 .70352 .38507 Metetra
.836 .8 .816 r
.70352 .38507 .71978 .40584 .7533 .37136 .73744 .35022 Metetra
.804 .794 .843 r
.73744 .35022 .7533 .37136 .78725 .34298 .77176 .32149 Metetra
.778 .788 .861 r
.77176 .32149 .78725 .34298 .82162 .31846 .80649 .29664 Metetra
.758 .782 .873 r
.80649 .29664 .82162 .31846 .85641 .29652 .84164 .27438 Metetra
.504 .675 .941 r
.20533 .46072 .22509 .48038 .25346 .48041 .23386 .45996 Metetra
.456 .647 .94 r
.23386 .45996 .25346 .48041 .28213 .48305 .26271 .46145 Metetra
.384 .601 .933 r
.26271 .46145 .28213 .48305 .3111 .4896 .29187 .46615 Metetra
.277 .524 .908 r
.29187 .46615 .3111 .4896 .34036 .50227 .32135 .47556 Metetra
.124 .398 .85 r
.32135 .47556 .34036 .50227 .36991 .52533 .35118 .49213 Metetra
0 .227 .745 r
.35118 .49213 .36991 .52533 .39972 .56795 .38141 .51969 Metetra
0 .102 .643 r
.38141 .51969 .39972 .56795 .43144 .59152 .41223 .56266 Metetra
.521 .612 .884 r
.41223 .56266 .43144 .59152 .4648 .58149 .44551 .56264 Metetra
.645 .763 .934 r
.44551 .56264 .4648 .58149 .49857 .57133 .47955 .55224 Metetra
.645 .763 .934 r
.47955 .55224 .49857 .57133 .53276 .56104 .51402 .54172 Metetra
.645 .763 .934 r
.51402 .54172 .53276 .56104 .56738 .55063 .54894 .53106 Metetra
.752 .793 .886 r
.54894 .53106 .56738 .55063 .60244 .54008 .58411 .50985 Metetra
.877 .737 .703 r
.58411 .50985 .60244 .54008 .6368 .49518 .61826 .44461 Metetra
.784 .637 .698 r
.61826 .44461 .6368 .49518 .66998 .43032 .65228 .39458 Metetra
.795 .693 .752 r
.65228 .39458 .66998 .43032 .70352 .38507 .68645 .35547 Metetra
.788 .726 .794 r
.68645 .35547 .70352 .38507 .73744 .35022 .72089 .32347 Metetra
.775 .743 .824 r
.72089 .32347 .73744 .35022 .77176 .32149 .75566 .29616 Metetra
.76 .752 .846 r
.75566 .29616 .77176 .32149 .80649 .29664 .79081 .27201 Metetra
.746 .756 .861 r
.79081 .27201 .80649 .29664 .84164 .27438 .82636 .25008 Metetra
.535 .671 .925 r
.18532 .43927 .20533 .46072 .23386 .45996 .21406 .43723 Metetra
.507 .648 .92 r
.21406 .43723 .23386 .45996 .26271 .46145 .24314 .43682 Metetra
.473 .615 .91 r
.24314 .43682 .26271 .46145 .29187 .46615 .27257 .43855 Metetra
.436 .57 .89 r
.27257 .43855 .29187 .46615 .32135 .47556 .30239 .44297 Metetra
.407 .514 .855 r
.30239 .44297 .32135 .47556 .35118 .49213 .33266 .45057 Metetra
.413 .461 .801 r
.33266 .45057 .35118 .49213 .38141 .51969 .36351 .46084 Metetra
.476 .433 .73 r
.36351 .46084 .38141 .51969 .41223 .56266 .39521 .4697 Metetra
.57 .436 .659 r
.39521 .4697 .41223 .56266 .44551 .56264 .42811 .46425 Metetra
.651 .487 .648 r
.42811 .46425 .44551 .56264 .47955 .55224 .462 .43376 Metetra
.581 .423 .633 r
.462 .43376 .47955 .55224 .51402 .54172 .49574 .42269 Metetra
.515 .377 .632 r
.49574 .42269 .51402 .54172 .54894 .53106 .52993 .4312 Metetra
.607 .456 .652 r
.52993 .4312 .54894 .53106 .58411 .50985 .56466 .41454 Metetra
.655 .493 .652 r
.56466 .41454 .58411 .50985 .61826 .44461 .59938 .38322 Metetra
.706 .571 .7 r
.59938 .38322 .61826 .44461 .65228 .39458 .63405 .35022 Metetra
.735 .633 .746 r
.63405 .35022 .65228 .39458 .68645 .35547 .66881 .31975 Metetra
.745 .677 .785 r
.66881 .31975 .68645 .35547 .72089 .32347 .70378 .29234 Metetra
.745 .705 .814 r
.70378 .29234 .72089 .32347 .75566 .29616 .73904 .26758 Metetra
.739 .723 .837 r
.73904 .26758 .75566 .29616 .79081 .27201 .77463 .24488 Metetra
.732 .734 .853 r
.77463 .24488 .79081 .27201 .82636 .25008 .81061 .22377 Metetra
.563 .671 .911 r
.16504 .41636 .18532 .43927 .21406 .43723 .19402 .41274 Metetra
.549 .652 .903 r
.19402 .41274 .21406 .43723 .24314 .43682 .22338 .4101 Metetra
.536 .627 .889 r
.22338 .4101 .24314 .43682 .27257 .43855 .25313 .40852 Metetra
.528 .598 .867 r
.25313 .40852 .27257 .43855 .30239 .44297 .28332 .40791 Metetra
.531 .565 .835 r
.28332 .40791 .30239 .44297 .33266 .45057 .31405 .40768 Metetra
.552 .535 .79 r
.31405 .40768 .33266 .45057 .36351 .46084 .34542 .4061 Metetra
.59 .514 .738 r
.34542 .4061 .36351 .46084 .39521 .4697 .37759 .39948 Metetra
.628 .503 .692 r
.37759 .39948 .39521 .4697 .42811 .46425 .41058 .38328 Metetra
.641 .497 .671 r
.41058 .38328 .42811 .46425 .462 .43376 .44403 .36073 Metetra
.602 .483 .69 r
.44403 .36073 .462 .43376 .49574 .42269 .47749 .34927 Metetra
.544 .446 .694 r
.47749 .34927 .49574 .42269 .52993 .4312 .51131 .34896 Metetra
.574 .453 .677 r
.51131 .34896 .52993 .4312 .56466 .41454 .54577 .34236 Metetra
.624 .501 .692 r
.54577 .34236 .56466 .41454 .59938 .38322 .5806 .32602 Metetra
.667 .558 .723 r
.5806 .32602 .59938 .38322 .63405 .35022 .61563 .30447 Metetra
.696 .61 .757 r
.61563 .30447 .63405 .35022 .66881 .31975 .65084 .28142 Metetra
.712 .652 .788 r
.65084 .28142 .66881 .31975 .70378 .29234 .68626 .25863 Metetra
.719 .682 .813 r
.68626 .25863 .70378 .29234 .73904 .26758 .72197 .23673 Metetra
.72 .703 .834 r
.72197 .23673 .73904 .26758 .77463 .24488 .75801 .2158 Metetra
.717 .718 .849 r
.75801 .2158 .77463 .24488 .81061 .22377 .79441 .19579 Metetra
.587 .673 .899 r
.14445 .39234 .16504 .41636 .19402 .41274 .1737 .38709 Metetra
.582 .658 .89 r
.1737 .38709 .19402 .41274 .22338 .4101 .20334 .38224 Metetra
.579 .64 .875 r
.20334 .38224 .22338 .4101 .25313 .40852 .23342 .37764 Metetra
.581 .619 .855 r
.23342 .37764 .25313 .40852 .28332 .40791 .26398 .3729 Metetra
.591 .598 .827 r
.26398 .3729 .28332 .40791 .31405 .40768 .29509 .36721 Metetra
.609 .578 .794 r
.29509 .36721 .31405 .40768 .34542 .4061 .32682 .35915 Metetra
.633 .565 .76 r
.32682 .35915 .34542 .4061 .37759 .39948 .35922 .34689 Metetra
.653 .558 .735 r
.35922 .34689 .37759 .39948 .41058 .38328 .3922 .3298 Metetra
.656 .558 .732 r
.3922 .3298 .41058 .38328 .44403 .36073 .42549 .31173 Metetra
.626 .556 .756 r
.42549 .31173 .44403 .36073 .47749 .34927 .45892 .29993 Metetra
.58 .531 .764 r
.45892 .29993 .47749 .34927 .51131 .34896 .4927 .29445 Metetra
.583 .517 .745 r
.4927 .29445 .51131 .34896 .54577 .34236 .52705 .28803 Metetra
.615 .536 .743 r
.52705 .28803 .54577 .34236 .5806 .32602 .5619 .27674 Metetra
.647 .572 .757 r
.5619 .27674 .5806 .32602 .61563 .30447 .59712 .26116 Metetra
.672 .61 .778 r
.59712 .26116 .61563 .30447 .65084 .28142 .63264 .24308 Metetra
.689 .644 .799 r
.63264 .24308 .65084 .28142 .68626 .25863 .66844 .22395 Metetra
.699 .671 .819 r
.66844 .22395 .68626 .25863 .72197 .23673 .70455 .20458 Metetra
.703 .691 .836 r
.70455 .20458 .72197 .23673 .75801 .2158 .74099 .18538 Metetra
.704 .706 .849 r
.74099 .18538 .75801 .2158 .79441 .19579 .77781 .16651 Metetra
.607 .678 .891 r
.12352 .36756 .14445 .39234 .1737 .38709 .15304 .36077 Metetra
.606 .665 .882 r
.15304 .36077 .1737 .38709 .20334 .38224 .18297 .35396 Metetra
.608 .652 .868 r
.18297 .35396 .20334 .38224 .23342 .37764 .21335 .3469 Metetra
.613 .638 .851 r
.21335 .3469 .23342 .37764 .26398 .3729 .24423 .33916 Metetra
.624 .624 .83 r
.24423 .33916 .26398 .3729 .29509 .36721 .27565 .33007 Metetra
.638 .612 .807 r
.27565 .33007 .29509 .36721 .32682 .35915 .30764 .31881 Metetra
.654 .605 .787 r
.30764 .31881 .32682 .35915 .35922 .34689 .34018 .30477 Metetra
.665 .603 .776 r
.34018 .30477 .35922 .34689 .3922 .3298 .37318 .28849 Metetra
.664 .607 .782 r
.37318 .28849 .3922 .3298 .42549 .31173 .40647 .27263 Metetra
.64 .608 .802 r
.40647 .27263 .42549 .31173 .45892 .29993 .43998 .26051 Metetra
.607 .591 .81 r
.43998 .26051 .45892 .29993 .4927 .29445 .47385 .25218 Metetra
.6 .575 .798 r
.47385 .25218 .4927 .29445 .52705 .28803 .50822 .24429 Metetra
.616 .578 .789 r
.50822 .24429 .52705 .28803 .5619 .27674 .54313 .23416 Metetra
.638 .597 .791 r
.54313 .23416 .5619 .27674 .59712 .26116 .57849 .2212 Metetra
.658 .621 .802 r
.57849 .2212 .59712 .26116 .63264 .24308 .61424 .20598 Metetra
.673 .646 .815 r
.61424 .20598 .63264 .24308 .66844 .22395 .65035 .18933 Metetra
.683 .668 .829 r
.65035 .18933 .66844 .22395 .70455 .20458 .6868 .1719 Metetra
.69 .686 .841 r
.6868 .1719 .70455 .20458 .74099 .18538 .72363 .15414 Metetra
.693 .7 .852 r
.72363 .15414 .74099 .18538 .77781 .16651 .76083 .13629 Metetra
.622 .683 .886 r
.10221 .3423 .12352 .36756 .15304 .36077 .13198 .33415 Metetra
.623 .673 .877 r
.13198 .33415 .15304 .36077 .18297 .35396 .16219 .32572 Metetra
.627 .664 .866 r
.16219 .32572 .18297 .35396 .21335 .3469 .19285 .31678 Metetra
.634 .654 .852 r
.19285 .31678 .21335 .3469 .24423 .33916 .22401 .30699 Metetra
.643 .645 .837 r
.22401 .30699 .24423 .33916 .27565 .33007 .25568 .2959 Metetra
.654 .639 .823 r
.25568 .2959 .27565 .33007 .30764 .31881 .28787 .28313 Metetra
.665 .636 .812 r
.28787 .28313 .30764 .31881 .34018 .30477 .32054 .26865 Metetra
.671 .638 .809 r
.32054 .26865 .34018 .30477 .37318 .28849 .35361 .25317 Metetra
.666 .642 .817 r
.35361 .25317 .37318 .28849 .40647 .27263 .38698 .2384 Metetra
.648 .643 .831 r
.38698 .2384 .40647 .27263 .43998 .26051 .42063 .22598 Metetra
.624 .632 .838 r
.42063 .22598 .43998 .26051 .47385 .25218 .45464 .21593 Metetra
.615 .619 .832 r
.45464 .21593 .47385 .25218 .50822 .24429 .48914 .20659 Metetra
.622 .615 .823 r
.48914 .20659 .50822 .24429 .54313 .23416 .52415 .19628 Metetra
.636 .623 .821 r
.52415 .19628 .54313 .23416 .57849 .2212 .55966 .18421 Metetra
.65 .637 .824 r
.55966 .18421 .57849 .2212 .61424 .20598 .59562 .17041 Metetra
.663 .654 .831 r
.59562 .17041 .61424 .20598 .65035 .18933 .63199 .15525 Metetra
.673 .671 .84 r
.63199 .15525 .65035 .18933 .6868 .1719 .66876 .13915 Metetra
.679 .685 .848 r
.66876 .13915 .6868 .1719 .72363 .15414 .70592 .12246 Metetra
.683 .697 .857 r
.70592 .12246 .72363 .15414 .76083 .13629 .7435 .10542 Metetra
.633 .688 .884 r
.08046 .31676 .10221 .3423 .13198 .33415 .11049 .30745 Metetra
.636 .681 .876 r
.11049 .30745 .13198 .33415 .16219 .32572 .14095 .29773 Metetra
.64 .675 .867 r
.14095 .29773 .16219 .32572 .19285 .31678 .17188 .28741 Metetra
.646 .668 .857 r
.17188 .28741 .19285 .31678 .22401 .30699 .20328 .27624 Metetra
.654 .663 .846 r
.20328 .27624 .22401 .30699 .25568 .2959 .23517 .26398 Metetra
.662 .66 .837 r
.23517 .26398 .25568 .2959 .28787 .28313 .26754 .2505 Metetra
.669 .66 .832 r
.26754 .2505 .28787 .28313 .32054 .26865 .30034 .23599 Metetra
.672 .663 .833 r
.30034 .23599 .32054 .26865 .35361 .25317 .33352 .22107 Metetra
.667 .666 .84 r
.33352 .22107 .35361 .25317 .38698 .2384 .36703 .20679 Metetra
.652 .666 .851 r
.36703 .20679 .38698 .2384 .42063 .22598 .40085 .19406 Metetra
.636 .659 .856 r
.40085 .19406 .42063 .22598 .45464 .21593 .43505 .18288 Metetra
.627 .649 .853 r
.43505 .18288 .45464 .21593 .48914 .20659 .46971 .17236 Metetra
.628 .644 .847 r
.46971 .17236 .48914 .20659 .52415 .19628 .50488 .16144 Metetra
.637 .646 .843 r
.50488 .16144 .52415 .19628 .55966 .18421 .54056 .14946 Metetra
.647 .654 .843 r
.54056 .14946 .55966 .18421 .59562 .17041 .57672 .13622 Metetra
.657 .665 .846 r
.57672 .13622 .59562 .17041 .63199 .15525 .61334 .12184 Metetra
.665 .676 .851 r
.61334 .12184 .63199 .15525 .66876 .13915 .6504 .10654 Metetra
.672 .687 .856 r
.6504 .10654 .66876 .13915 .70592 .12246 .68789 .09056 Metetra
.676 .697 .862 r
.68789 .09056 .70592 .12246 .7435 .10542 .72581 .0741 Metetra
.642 .694 .883 r
.05826 .29105 .08046 .31676 .11049 .30745 .08853 .28078 Metetra
.645 .689 .877 r
.08853 .28078 .11049 .30745 .14095 .29773 .11923 .27005 Metetra
.649 .684 .869 r
.11923 .27005 .14095 .29773 .17188 .28741 .15039 .25871 Metetra
.655 .68 .862 r
.15039 .25871 .17188 .28741 .20328 .27624 .18201 .24661 Metetra
.661 .678 .855 r
.18201 .24661 .20328 .27624 .23517 .26398 .2141 .23364 Metetra
.667 .677 .85 r
.2141 .23364 .23517 .26398 .26754 .2505 .24664 .21981 Metetra
.671 .678 .848 r
.24664 .21981 .26754 .2505 .30034 .23599 .2796 .20535 Metetra
.672 .681 .85 r
.2796 .20535 .30034 .23599 .33352 .22107 .31293 .19074 Metetra
.666 .683 .856 r
.31293 .19074 .33352 .22107 .36703 .20679 .3466 .17666 Metetra
.655 .683 .864 r
.3466 .17666 .36703 .20679 .40085 .19406 .38061 .16361 Metetra
.643 .678 .868 r
.38061 .16361 .40085 .19406 .43505 .18288 .41502 .15161 Metetra
.635 .671 .867 r
.41502 .15161 .43505 .18288 .46971 .17236 .44988 .14013 Metetra
.635 .666 .863 r
.44988 .14013 .46971 .17236 .50488 .16144 .48524 .12852 Metetra
.639 .665 .859 r
.48524 .12852 .50488 .16144 .54056 .14946 .52112 .11625 Metetra
.646 .669 .857 r
.52112 .11625 .54056 .14946 .57672 .13622 .5575 .10309 Metetra
.654 .675 .858 r
.5575 .10309 .57672 .13622 .61334 .12184 .59436 .08901 Metetra
.66 .683 .86 r
.59436 .08901 .61334 .12184 .6504 .10654 .6317 .07411 Metetra
.666 .691 .864 r
.6317 .07411 .6504 .10654 .68789 .09056 .6695 .05854 Metetra
.67 .699 .868 r
.6695 .05854 .68789 .09056 .72581 .0741 .70776 .04243 Metetra
.648 .699 .883 r
.03556 .26522 .05826 .29105 .08853 .28078 .06606 .25415 Metetra
.652 .696 .878 r
.06606 .25415 .08853 .28078 .11923 .27005 .09699 .24262 Metetra
.655 .693 .873 r
.09699 .24262 .11923 .27005 .15039 .25871 .12837 .23053 Metetra
.66 .69 .868 r
.12837 .23053 .15039 .25871 .18201 .24661 .1602 .21778 Metetra
.665 .689 .863 r
.1602 .21778 .18201 .24661 .2141 .23364 .19249 .20435 Metetra
.669 .689 .86 r
.19249 .20435 .2141 .23364 .24664 .21981 .2252 .19031 Metetra
.671 .691 .86 r
.2252 .19031 .24664 .21981 .2796 .20535 .25832 .17587 Metetra
.671 .693 .863 r
.25832 .17587 .2796 .20535 .31293 .19074 .29182 .16139 Metetra
.666 .695 .868 r
.29182 .16139 .31293 .19074 .3466 .17666 .32568 .14732 Metetra
.657 .694 .873 r
.32568 .14732 .3466 .17666 .38061 .16361 .35991 .13395 Metetra
.648 .691 .876 r
.35991 .13395 .38061 .16361 .41502 .15161 .39454 .12129 Metetra
.642 .686 .876 r
.39454 .12129 .41502 .15161 .44988 .14013 .42962 .10903 Metetra
.64 .681 .873 r
.42962 .10903 .44988 .14013 .48524 .12852 .46521 .09674 Metetra
.642 .68 .87 r
.46521 .09674 .48524 .12852 .52112 .11625 .5013 .08403 Metetra
.647 .681 .868 r
.5013 .08403 .52112 .11625 .5575 .10309 .53791 .07068 Metetra
.652 .685 .868 r
.53791 .07068 .5575 .10309 .59436 .08901 .57503 .0566 Metetra
.657 .69 .869 r
.57503 .0566 .59436 .08901 .6317 .07411 .61264 .04182 Metetra
.662 .696 .871 r
.61264 .04182 .6317 .07411 .6695 .05854 .65075 .0264 Metetra
.666 .701 .873 r
.65075 .0264 .6695 .05854 .70776 .04243 .68934 .01045 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(-2)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(-1)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(1)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(2)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
gsave
.29165 .07573 -70.3112 -16 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 233.562},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001GR000`400?l00000o`00003ooooooona
ooooo`00oooooonaooooo`00oooooonaooooo`00oooooonaooooo`00oooooonaooooo`00oooooona
ooooo`00oooooonaooooo`00oooooonaooooo`00oooooonaooooo`00oooooonaooooo`00oooooolZ
ooooo`03ohN7Qol0003o000000;o000000?o410@ooooooooool0Ooooool00?oooooo:_ooool00oo^
k^ko<S8bolc<c024ooooo`00ooooool[ooooo`03onk^k_lb<S;oZJVY08?ooooo003oooooobcooooo
00?ok^k^ob4Q8OnHV9P0P_ooool00?oooooo;Oooool00oo^k^ko<S8bolc<c021ooooo`00ooooool^
ooooo`03onk^k_m4A4Cooooo083ooooo003oooooob_ooooo00Go^[Zjoooooooooooooooooc8b<P21
ooooo`00oooooolZooooo`06olc<c?l0003oQhN7oooooonj^[[o8B4Q4_ooool00on7QhOo0000o`00
0002o`000003oa0@4?oooooooooo06Oooooo003oooooob_ooooo00GoZJVYob4Q8Ol0003o410@olc<
c00Booooo`03onk^k_lb<S;oc<c<06cooooo003ooooood?ooooo00?ok^k^oc8b<_nYZJT0Joooool0
0?oooooo>Oooool00ol@413o0000o`000003o`000003oa0@4?oooooooooo00;ooooo00?ok^k^ob4Q
8OnHV9P0J_ooool00?ooooooAOooool00oo^k^ko<S8bolc<c01Yooooo`00oooooom6ooooo`03onk^
k_m4A4Cooooo06Sooooo003ooooood?ooooo00Go^[Zjoooooooooooooooooc8b<P1Yooooo`00oooo
oolbooooo`;o00003_ooool01_o<c<co0000ohN7Qooooooo^[Zjob4Q8FWooooo003ooooooboooooo
0ol000000ooooooo0000ooooo`0>ooooo`05ojVYZOlQ8B7o0000oa0@4?o<c<`0JOooool00?oooooo
;Oooool2o`0000Cooooo0_l0001looooo`00oooooolZooooo`?o00001_ooool00ol0003oooooo`00
001kooooo`00oooooolXooooo`;o00002Oooool00ol0003oooooo`00001kooooo`00oooooolUoooo
o`?o00002oooool2o`000003ooooool0003ooooo07Wooooo003oooooob?ooooo0ol0000:ooooo`Go
00000_ooool00ol0003oooooooooo`1gooooo`00oooooolPooooo`?o00000oooool00ol0003ooooo
ooooo`04ooooo`?o00000onZ/ml01Ol0003oZ[?Oo`000?oooooo000007Wooooo003ooooooakooooo
0_l0000;ooooo`;o00001_nZ/ml00ol0003oZ[?Oo`000002ooooo`03o`000?oooooooooo07Kooooo
003ooooooa_ooooo0ol0000:ooooo`?o00002OnZ/ml00ol0003oZ[?Oo`000002ooooo`03o`000?oo
oooooooo07Gooooo003ooooooaSooooo0ol0000:ooooo`?o00003?nZ/ml01_l0003oZ[?OojZcgol0
003oooooo`0007Oooooo003ooooooaKooooo0_l0000;ooooo`;o00003onZ/ml01Ol0003oZ[?OojZc
gol0003ooooo00;o0000M_ooool00?oooooo4oooool3o`000003ooooool0003ooooo00Oooooo0ol0
00000onY/]ko0000ojZcg`0>ojZcg`05o`000?nZ/mooZ[?OojZcgol000000_ooool00ol0003ooooo
ooooo`1cooooo`00oooooolAooooo`;o00001Oooool00ol0003oooooooooo`03ooooo`;o00001OnY
/]h00ol0003oZ[?OojZcg`0<ojZcg`05o`000?nZ/mooZ[?OojZcgol000000_ooool00ol0003ooooo
ooooo`1cooooo`00hoooool00ol@413o0000o`000002o`000003omgMgOoooooooooo02;ooooo0ol0
000:ooooo`?o00002?nY/]h00ol0003oZ[?OojZcg`0;ojZcg`03o`000?nZ/mooZ[?O00;oZ[?O00Co
0000oooooooooooo0000M?ooool00>Gooooo00?o0000ooooooooool08oooool2o`0000_ooooo0_l0
000;ojVbgP03o`000?nZ/mooZ[?O00_oZ[?O00?o0000ojZcgonZ/ml00onZ/ml01?l0003ooooooooo
ool0001cooooo`00iOooool00ol0003oooooooooo`0Pooooo`?o00002_ooool3o`0000koZK;N00?o
0000ojZcgonZ/ml02_nZ/ml00ol0003oZ[?OojZcg`03ojZcg`04o`000?ooooooooooo`0007?ooooo
003Uooooo`03o`000?oooooooooo01kooooo0ol0000:ooooo`;o00004_nY/]h00ol0003oZ[?OojZc
g`09ojZcg`03o`000?nZ/mooZ[?O00?oZ[?O0_l00002ooooo`03o`000?oooooooooo073ooooo002;
ooooo`06omgMgOl0003o0000oa0@4?ooooooEEEE0_l000000ooMgMgoooooooooo`1?ooooo`03o`00
0?oooooooooo01_ooooo0ol00003ooooo`03o`000?oooooooooo00Cooooo0ol000000onX/=ko0000
ojVbgP0AojVbgP03o`000?nZ/mooZ[?O00WoZ[?O00?o0000ojZcgonZ/ml00ol000001On[/]ko0000
oooooooooooo000007;ooooo002<ooooo`07onk^k_lQ8B7oV9RHooooooo<c<co410@olc<c01Boooo
o`03o`000?oooooooooo01Wooooo0_l0000;ooooo`;o00001OnX/=h00ol0003oZK;NojVbgP0@ojVb
gP03o`000?nZ/mooZ[?O00SoZ[?O0ol00005oj^bgP04o`000?ooooooooooo`00077ooooo002=oooo
o`05onk^k_l@413oV9RHoa0@4?o<c<`0Doooool00ol0003oooooooooo`0Fooooo`?o00002oooool2
o`0000SoZ;3N00?o0000ojVbg_nY/]h04?nY/]h00ol0003oZ[?OojZcg`05ojZcg`?o00001on[/]h0
1Ol0003ooooooooooooooooo0000073ooooo002>ooooo`03okZj^_l0003o^[Zj05;ooooo00?oQhN7
okZj^_l000005_ooool2o`0000_ooooo0ol0000:ojR`gP03o`000?nY/]koZK;N013oZK;N00?o0000
ojZcgonZ/ml00onZ/ml2o`0000;oZk;N00?o0000oj^bg_n[/]h01_n[/]h00ol0003oooooo`000002
o`0006oooooo002=ooooo`05onk^k_lQ8B7o<S8bob4Q8Oo^k^h0DOooool00on7QhOo<S8bo`00000C
ooooo`?o00002oooool2o`0000koZ;3N00?o0000ojVbg_nY/]h04?nY/]h00ol0003oZ[?Oo`000002
o`0000CoZk;N00?o0000oj^bg_n[/]h01_n[/]h01Ol0003ooooooooooooooooo000006oooooo002=
ooooo`06odA4A?mEEEGooooooiRHV?lQ8B7ok^k^I?ooool2o`000003ooooool0003ooooo00Wooooo
0_l0000@ojR`gP03o`000?nY/]koZK;N013oZK;N0_l00007oj^bgP03o`000?n[/]koZk;N00OoZk;N
00Go0000ooooooooooooooooo`00001^ooooo`00S?ooool01?l@413o0000oeEEEOooool3o`000003
omgMgOoooooooooo05kooooo0ol00004ooooo`03o`000?oooooooooo00Cooooo0ol000000onV[mko
0000ojR`gP0@ojR`gP03o`000?nY/]koZK;N00goZK;N0_l000000onZ/=go0000oj^bgP06oj^bgP03
o`000?n[/]koZk;N00SoZk;N00Co0000oooooooooooo0000K_ooool00?;ooooo0_l0000;ooooo`?o
00001OnV[mh00ol0003oZ;3NojR`gP0?ojR`gP03o`000?nY/]koZK;N00[oZK;N0_l00004ojZ`g@03
o`000?n[/]koZk;N00GoZk;N00?o0000oj^bg_n[/]h01on[/]h01Ol0003ooooooooooooooooo0000
06gooooo003_ooooo`?o00002_ooool3o`0000SoYZoN00?o0000ojR`g_nX/=h03onX/=h00ol0003o
ZK;NojVbgP07ojVbgP?o00001_nZ/=d00ol0003oZk;Noj^bgP05oj^bgP03o`000?n[/]koZk;N00So
Zk;N00Go0000ooooooooooooooooo`00001/ooooo`00kOooool2o`0000[ooooo0ol0000<ojJ_gP03
o`000?nX/=koZ;3N00ooZ;3N00?o0000ojVbg_nY/]h01?nY/]h2o`0000[oZ[3M00?o0000oj^bg_n[
/]h01?n[/]h00ol0003oZk;Noj^bgP08oj^bgP05o`000?ooooooooooooooool00000K?ooool00>[o
oooo0ol00009ooooo`?o00004?nV[mh00ol0003oZ;3NojR`gP0>ojR`gP03o`000?nY/]koZK;N00;o
ZK;N0_l0000<ojZ`g@03o`000?n[/]koZk;N00CoZk;N00?o0000oj^bg_n[/]h02On[/]h01Ol0003o
oooooooooooooooo000006_ooooo003Xooooo`;o00000oooool00ol0003oooooooooo`03ooooo`?o
000000?oYJkNo`000?nV[mh04?nV[mh00ol0003oZ;3NojR`gP0?ojR`gP04o`000?nY/]ko0000o`00
00ooZ[3M00?o0000oj^bg_n[/]h00on[/]h00ol0003oZk;Noj^bgP09oj^bgP03o`000?oooooooooo
00;ooooo00?o0000ooooooooool0J?ooool00>Gooooo0ol00006ooooo`03o`000?oooooo000000;o
00001OnU[]h00ol0003oYZoNojJ_gP0?ojJ_gP03o`000?nX/=koZ;3N00koZ;3N0_l0000BojZ`g@03
o`000?n[/]koZk;N00;oZk;N00?o0000oj^bg_n[/]h02On[/]h2o`0000?ooooo00?o0000oooooooo
ool0J?ooool00>;ooooo0ol00008ooooo`?o00002OnU[]h00ol0003oYZoNojJ_gP0>ojJ_gP03o`00
0?nX/=koZ;3N00_oZ;3N0ol000000onX[]co0000ojZ`g@0AojZ`g@03o`000?n[/]koZk;N00;oZk;N
00?o0000oj^bg_n[/]h01_n[/]h3o`000003ojfbg?l0003ooooo00;ooooo0_l0001Yooooo`00h?oo
ool2o`0000Sooooo0ol0000<ojF^gP03o`000?nV[mkoYZoN00ooYZoN00?o0000ojR`g_nX/=h01onX
/=h3o`0000GoZ:kL00?o0000ojZ`gOnZ/=d04?nZ/=d01Ol0003oZk;Noj^bg_n[/]ko000000KoZk;N
0_l00005ojfbg003o`000?oooooooooo00;ooooo00?o0000ooooooooool0I_ooool00=gooooo0ol0
0008ooooo`;o00004?nU[]h00ol0003oYZoNojJ_gP0?ojJ_gP03o`000?nX/=koZ;3N00?oZ;3N0ol0
0008ojR^g003o`000?nZ/=goZ[3M013oZ[3M00Go0000oj^bg_n[/]koZk;No`000003oj^bgP?o0000
1on]/]`00ol0003oooooooooo`02ooooo`03o`000?oooooooooo06Kooooo003Kooooo`;o00000ooo
ool00ol0003oooooooooo`02ooooo`?o000000?oY:kNo`000?nU[]h03onU[]h00ol0003oYZoNojJ_
gP0?ojJ_gP03o`000?nX/=koZ;3N00?o00003?nX[]`00ol0003oZ[3MojZ`g@0@ojZ`g@05o`000?n[
/]koZk;No`000?n[/]h00_l0000;ojfbg003o`000?oooooooooo00;ooooo00?o0000ooooooooool0
IOooool00=Sooooo0ol00007ooooo`?o00001OnT[]h00ol0003oYJkNojF^gP0>ojF^gP03o`000?nV
[mkoYZoN00koYZoN0ol0000@ojR^g003o`000?nZ/=goZ[3M00ooZ[3M00?o0000oj^bg_l000000_l0
000>ojfbg003o`000?oooooooooo00;ooooo00?o0000ooooooooool0I?ooool00=Kooooo0_l00007
ooooo`?o00002OnT[]h00ol0003oYJkNojF^gP0>ojF^gP03o`000?nV[mkoYZoN00[oYZoN0ol00000
0onW[=_o0000ojR^g00@ojR^g003o`000?nZ/=goZ[3M00ooZ[3M0_l000000on]/]co0000ojfbg00>
ojfbg003o`000?oooooooooo00;ooooo00?o0000ooooooooool0I?ooool00=?ooooo0ol00006oooo
o`?o00003?nT[]h00ol0003oYJkNojF^gP0>ojF^gP03o`000?nV[mkoYZoN00SoYZoN0_l00005ojN/
f`03o`000?nX[]coZ:kL00ooZ:kL00?o0000ojZ`gOnZ/=d02onZ/=d3o`000004ojb_fol0003o[K;L
o`00013o[K;L00?o0000ooooooooool00_ooool00ol0003oooooooooo`1Sooooo`00dOooool2o`00
00Oooooo0_l0000@ojB^gP03o`000?nU[]koYJkN00koYJkN00?o0000ojJ_g_nV[mh01OnV[mh2o`00
00SoYjcK00?o0000ojR^g?nX[]`03_nX[]`00ol0003oZ[3MojZ`g@09ojZ`g@;o00001On/[m/2o`00
013o[K;L00?o0000ooooooooool00oooool00ol0003oooooooooo`1Rooooo`00c_ooool3o`000003
ooooool0003ooooo00?ooooo0ol000000onS[]oo0000ojB^gP0?ojB^gP03o`000?nU[]koYJkN00ko
YJkN00?o0000ojJ_g_nV[mh00_nV[mh3o`0000[oYjcK00?o0000ojR^g?nX[]`03onX[]`00ol0003o
Z[3MojZ`g@05ojZ`g@?o00001on/[m/2o`00017o[K;L00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`1Rooooo`00X_ooool01?mVIVKo0000oc8b<_o^k^hVooooo`;o00001Oooool4o`0000Go
XjkO00?o0000ojB^g_nT[]h03_nT[]h00ol0003oYJkNojF^gP0>ojF^gP04o`000?nV[mko0000o`00
00koYjcK00?o0000ojR^g?nX[]`03onX[]`00ol0003oZ[3MojZ`g@02ojZ`g@;o00002on/[m/00ol0
003o[K;Lojfbg00@ojfbg003o`000?oooooooooo00;ooooo00?o0000ooooooooool0HOooool00:7o
oooo0_n7QhL00oooooooQhN7odA4A00Sooooo`?o00001Oooool3o`0000SoXjkO00?o0000ojB^g_nT
[]h03onT[]h00ol0003oYJkNojF^gP0=ojF^gP;o00004?nW[=/00ol0003oZ:kLojR^g00?ojR^g003
o`000?nZ/=go000000;o00003On/[m/2o`00017o[K;L00Oo0000ooooooooooooooooo`000?oooooo
000006;ooooo002Qooooo`05oc8b<_ooooooooooooooool000008Oooool2o`0000Gooooo0ol0000<
oj>^g`03o`000?nT[]koY:kN00koY:kN00?o0000ojF^g_nU[]h02_nU[]h3o`000003ojF[fol0003o
YjcK013oYjcK00?o0000ojR^g?nX[]`03_nX[]`2o`00017o[:oK00?o0000ojfbg?n]/]`03on]/]`2
o`0000Cooooo00?o0000ooooooooool0H?ooool00:7ooooo00Ko<S8boooooooooooooooooc8b<_nj
^[XMooooo`?o00001Oooool2o`0000ooXjkO00?o0000ojB^g_nT[]h03onT[]h00ol0003oYJkNojF^
gP06ojF^gP?o00001OnUZm/00ol0003oYjcKojN/f`0?ojN/f`03o`000?nX[]coZ:kL00[oZ:kL0ol0
00000onZ[MWo0000ojb_f`0@ojb_f`;o00003_n]/]`2o`000003ojjbfol0003ooooo00Cooooo00?o
0000ooooooooool04Oooool00ol@413o0000o`000002o`000003omgMgOoooooooooo04Kooooo002Q
ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj6oooool3o`0000Cooooo0ol000000onT[n3o0000
oj>^g`0?oj>^g`03o`000?nT[]koY:kN00koY:kN00?o0000ojF^g_nU[]h00onU[]h3o`0000SoYJ_K
00?o0000ojN/fonW[=/03onW[=/00ol0003oZ:kLojR^g008ojR^g0;o00001OnZ[MT00ol0003o[:oK
ojb_f`0>ojb_f`;o00003?n]/]`2o`0000Co[[;K00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`0Booooo`03o`000?oooooooooo04Wooooo002Qooooo`06oc8b<_oooooooooooooooolb<S;o
^[Zj6?ooool3o`0000?ooooo1?l00005ojB_h003o`000?nS[]ooXjkO00koXjkO00?o0000ojB^g_nT
[]h03_nT[]h00ol0003oYJkNo`000002o`0000coYJ_K00?o0000ojN/fonW[=/03onW[=/00ol0003o
Z:kLojR^g005ojR^g0;o00002?nZ[MT00ol0003o[:oKojb_f`0=ojb_f`03o`000?n/[m_o000000So
[K;L0ol00006ojjbf`03o`000?oooooooooo00?ooooo00?o0000ooooooooool04_ooool00ol0003o
ooooooooo`19ooooo`00XOooool01Olb<S;ok^k^ooooooo^k^ko000001Oooooo0_l00004ooooo`?o
00002OnT[n000ol0003oXjkOoj>^g`0=oj>^g`03o`000?nT[]koY:kN00koY:kN0_l0000?ojF[f`03
o`000?nW[=_oYjcK00ooYjcK00?o0000ojR^g?nX[]`00_nX[]`3o`0000[oZZgI00?o0000ojb_fon/
[m/03On/[m/00ol0003o[:oKo`000006ojfbg0;o00002_n^/]/00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo00Gooooo00?o410@o`000?l000000ol000000ol@413oooooooooo`03ooooo`03
o`000?oooooooooo04Wooooo002Qooooo`05ohN7QomVIVKoooooofIVI_m4A4@05?ooool3o`0000?o
oooo0ol0000<ojB_h003o`000?nS[]ooXjkO00koXjkO00?o0000ojB^g_nT[]h02_nT[]h3o`000003
oj>Zfol0003oYJ_K00ooYJ_K00?o0000ojN/fonW[=/03onW[=/01?l0003oZ:kLo`000?l0000>ojZ]
f@03o`000?n/[m_o[:oK00co[:oK00Co0000ojb_fon/[m_o00000on]/]`2o`0000go[[;K00?o0000
ooooooooool00oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo04Wooooo002Roooo
o`04ofIVI_l0003o<S8bonk^kQ;ooooo0_l00004ooooo`;o00004?nT[n000ol0003oXjkOoj>^g`0=
oj>^g`03o`000?nT[]koY:kN00OoY:kN0ol00005oj>Zf`03o`000?nUZm_oYJ_K00koYJ_K00?o0000
ojN/fonW[=/03_nW[=/2o`00013oZZgI00?o0000ojb_fon/[m/03?n/[m/01Ol0003o[:oKojb_fol0
003o[K;L00;o00003on^/]/00ol0003oooooooooo`03ooooo`03o`000?oooooooooo013ooooo00?o
0000ooooooooool0BOooool00;Gooooo0ol00003ooooo`?o000000?oYK3Po`000?nT[n003onT[n00
0ol0003oXjkOoj>^g`0>oj>^g`03o`000?nT[]koY:kN00?oY:kN0ol00008oj>Zf`03o`000?nUZm_o
YJ_K00koYJ_K00?o0000ojN/fonW[=/02onW[=/3o`000003ojRZf?l0003oZZgI013oZZgI00?o0000
ojb_fon/[m/02on/[m/00ol0003o[:oKojb_f`02o`0001;o[[;K00?o0000ooooooooool00oooool0
0ol0003oooooooooo`0?ooooo`03o`000?oooooooooo04Wooooo002booooo`?o00000oooool3o`00
00GoYK3P00?o0000ojB_h?nT[n003_nT[n000ol0003oXjkOoj>^g`0=oj>^g`03o`000?nT[]koY:kN
00?o00003?nSZ]/00ol0003oYJ_KojF[f`0>ojF[f`03o`000?nW[=_oYjcK00SoYjcK0_l00005ojRZ
f003o`000?nZ[MWoZZgI00ooZZgI00?o0000ojb_fon/[m/02_n/[m/3o`000003ojf_fOl0003o[[;K
017o[[;K00?o0000ooooooooool00oooool2o`0000kooooo00?oQhN7okZj^_l00000Boooool00;3o
oooo0_l00003ooooo`?o00002OnU/>000ol0003oY:oPojB_h00>ojB_h003o`000?nS[]ooXjkO00co
XjkO0ol0000?oj>Zf`03o`000?nUZm_oYJ_K00koYJ_K00?o0000ojN/fonW[=/01OnW[=/3o`0000Oo
Z:[H00?o0000ojZ]fOnZ[MT03onZ[MT00ol0003o[:oKojb_f`08ojb_f`?o00001?n][mT00ol0003o
[[;Kojjbf`0@ojjbf`03o`000?oooooooooo00;o000000?oooooo`000?ooool03Oooool00on7QhOo
<S8bo`00001;ooooo`00[Oooool3o`0000;ooooo0ol0000<ojF`h003o`000?nT[n3oY:oP00koY:oP
00?o0000oj>^gonS[]l02OnS[]l3o`000003oj:Zg?l0003oXj[K013oXj[K00?o0000ojF[fonUZm/0
3_nUZm/00ol0003oYjcKojN/f`02ojN/f`;o00002onXZ]P00ol0003oZZgIojZ]f@0?ojZ]f@03o`00
0?n/[m_o[:oK00Go[:oK0_l00002ojf_f@03o`000?n][mWo[JoI00;o[JoI00?o0000ojjbfon^/]/0
4On^/]/00ol0003oooooooooo`03ooooo`03o`000?oooooooooo05Wooooo002[ooooo`;o00000ooo
ool2o`00013oYK3P00?o0000ojB_h?nT[n003_nT[n000ol0003oXjkOoj>^g`05oj>^g`?o00001OnR
Z]`00ol0003oXj[Koj>Zf`0?oj>Zf`03o`000?nUZm_oYJ_K00goYJ_K00?o0000ojN/fol000000_l0
000=ojRZf003o`000?nZ[MWoZZgI00ooZZgI00?o0000ojb_fon/[m/00_n/[m/3o`0000Co[JoI00?o
0000ojf_fOn][mT00on][mT00ol0003o[[;Kojjbf`0@ojjbf`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool0FOooool00:Sooooo1?l000001_oooooo0000o`000?l0003oZ;7Oo`00017oYK3P
00?o0000ojB_h?nT[n003OnT[n000ol0003oXjkOoj>^g`03oj>^g`;o00002OnRZ]`00ol0003oXj[K
oj>Zf`0>oj>Zf`03o`000?nUZm_oYJ_K00goYJ_K0_l0000AojRZf003o`000?nZ[MWoZZgI00ooZZgI
00Co0000ojb_fol0003o00001on][mT00ol0003o[JoIojf_f@04ojf_f@03o`000?n^/]_o[[;K00oo
[[;K0_l00005ooooo`03o`000?oooooooooo05Sooooo002Vooooo`;o00000_ooool3o`0000GoZ;7O
00?o0000ojF`h?nU/>003_nU/>000ol0003oY:oPojB_h00>ojB_h003o`000?nS[]oo000000;o0000
2onRZ]`00ol0003oXj[Koj>Zf`0?oj>Zf`03o`000?nUZm_oYJ_K00WoYJ_K0ol000000onUYmOo0000
ojRZf00AojRZf003o`000?nZ[MWoZZgI00koZZgI0_l00009ojf_f@03o`000?n][mWo[JoI00Co[JoI
00?o0000ojjbfon^/]/03On^/]/2o`000003ok6cf_l0003ooooo00Gooooo00?o0000ooooooooool0
Eoooool00:?ooooo0ol00002ooooo`;o00000_nX/Ml00ol0003oZ;7OojRag`04ojRag`03o`000?nU
/>3oYK3P00koYK3P00?o0000ojB_h?nT[n003?nT[n03o`0000ooXZ[L00?o0000oj>ZfonSZ]/03_nS
Z]/00ol0003oYJ_KojF[f`06ojF[f`?o00001OnUYmL00ol0003oZ:[HojRZf00?ojRZf003o`000?nZ
[MWoZZgI00_oZZgI0ol000000on/ZmOo0000ojf_f@08ojf_f@03o`000?n][mWo[JoI00Go[JoI00?o
0000ojjbfon^/]/02_n^/]/2o`0000Co/K?J00?o0000ooooooooool00oooool00ol0003ooooooooo
o`1Gooooo`00XOooool2o`0000;ooooo0ol0000;ojRag`03o`000?nU/>3oYK3P00ooYK3P00?o0000
ojB_h?nT[n002?nT[n03o`0000;oXZ_M00?o0000oj:Zg?nRZ]`03OnRZ]`00ol0003oXj[Koj>Zf`0?
oj>Zf`03o`000?nUZm_oYJ_K00;oYJ_K0ol00009ojFWe`03o`000?nXZ]SoZ:[H00ooZ:[H00?o0000
ojZ]fOnZ[MT02?nZ[MT2o`0000Go[:_G00?o0000ojf_fOn][mT01_n][mT00ol0003o[JoIojf_f@05
ojf_f@03o`000?n^/]_o[[;K00Oo[[;K0ol00006ok6cfP03o`000?oooooooooo00Cooooo00?o0000
ooooooooool0E_ooool009kooooo0ol00002ooooo`;o00003onX/Ml00ol0003oYK3PojF`h00>ojF`
h003o`000?nT[n3oY:oP00CoY:oP1?l00006oj:[g@03o`000?nRZ]coXZ[L00goXZ[L00?o0000oj>Z
fonSZ]/03_nSZ]/00ol0003oYJ_Ko`000002o`0000coYJOG00?o0000ojRZf?nXZ]P03onXZ]P00ol0
003oZZgIojZ]f@05ojZ]f@?o00001on/ZmL00ol0003o[JoIojf_f@07ojf_f@03o`000?n][mWo[JoI
00Go[JoI00?o0000ojjbfon^/]/01?n^/]/2o`0000[o/K?J00?o0000ooooooooool01?ooool00ol0
003oooooooooo`1Eooooo`00W?ooool3o`0000;ooooo0_l000000onZ/Mko0000ojRag`0?ojRag`03
o`000?nU/>3oYK3P00koYK3P00?o0000ojB_h?nT[n000ol0000:oj:[g@03o`000?nRZ]coXZ[L00ko
XZ[L00?o0000oj>ZfonSZ]/03OnSZ]/2o`00013oYJOG00?o0000ojRZf?nXZ]P03onXZ]P00ol0003o
ZZgIojZ]f@02ojZ]f@;o00002on/ZmL00ol0003o[JoIojf_f@06ojf_f@03o`000?n][mWo[JoI00Ko
[JoI00Co0000ojjbfon^/]_o[[;K0_l0000<ok6cfP03o`000?oooooooooo00Cooooo0_l0001Foooo
o`00VOooool3o`0000?ooooo0_l00004ojZagP03o`000?nX/MooZ;7O00goZ;7O00?o0000ojF`h?nU
/>003_nU/>03o`0000koXZ_M00?o0000oj:Zg?nRZ]`03OnRZ]`00ol0003oXj[Koj>Zf`0:oj>Zf`?o
000000?oXjGGo`000?nUYmL03onUYmL00ol0003oZ:[HojRZf00?ojRZf003o`000?nZ[MWo000000;o
00003On/ZmL00ol0003o[JoIojf_f@06ojf_f@03o`000?n][mWo[JoI00Ko[JoI00Co0000ojjbfol0
003o00003ona/mX00ol0003oooooooooo`02ooooo`03o`000?oooooo000005Kooooo002Gooooo`;o
00000oooool3o`0000OoZ[7N00?o0000ojRagonX/Ml03OnX/Ml00ol0003oYK3PojF`h00:ojF`h0?o
000000?oY:gNo`000?nRZmd03onRZmd00ol0003oXZ[Loj:Zg00=oj:Zg003o`000?nSZ]_oXj[K00Ko
Xj[K0ol00005oj>Ue`03o`000?nUYmOoYJOG00koYJOG00?o0000ojRZf?nXZ]P03_nXZ]P2o`00017o
[:_G00?o0000ojf_fOn][mT01On][mT00ol0003o[JoIojf_f@06ojf_f@;o00004Ona/mX00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo05?ooooo002Dooooo`?o00000oooool2o`0000[oZ[7N
00?o0000ojRagonX/Ml03_nX/Ml00ol0003oYK3PojF`h006ojF`h0?o00001OnT[Mh00ol0003oXZ_M
oj:[g@0=oj:[g@03o`000?nRZ]coXZ[L00goXZ[L00?o0000oj>ZfonSZ]/00onSZ]/3o`0000SoXjGG
00?o0000ojFWeonUYmL03onUYmL00ol0003oZ:[HojRZf00:ojRZf0?o000000?oZJODo`000?n/ZmL0
4On/ZmL00ol0003o[JoIojf_f@04ojf_f@03o`000?n][mWo[JoI00Co[JoI0_l000000on`[mOo0000
ok6cfP0Aok6cfP03o`000?oooooooooo00Cooooo00?o0000ooooooooool0Doooool009;ooooo0_l0
0004ooooo`;o00003OnZ/Mh00ol0003oZ;7OojRag`0=ojRag`03o`000?nU/>3oYK3P00?oYK3P0ol0
0009ojB]gP03o`000?nRZmgoXZ_M00goXZ_M00?o0000oj:Zg?nRZ]`03OnRZ]`00ol0003oXj[Ko`00
0002o`0000coXjGG00?o0000ojFWeonUYmL03_nUYmL00ol0003oZ:[HojRZf008ojRZf0;o00001OnY
Ym@00ol0003o[:_Gojb[e`0?ojb[e`03o`000?n][mWo[JoI00Co[JoI00?o0000ojf_fOn][mT00_n]
[mT2o`0000Co/:oG00?o0000ok6cf_na/mX03ona/mX00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo05;ooooo001Rooooo`03oa0@4?l0003o000000;o000000?ogMgMooooooooool09Oooool3
o`0000Cooooo0_l0000@ojZagP03o`000?nX/MooZ;7O00goZ;7O00?o0000ojF`h?l000000_l0000<
ojB]gP03o`000?nRZmgoXZ_M00goXZ_M00?o0000oj:Zg?nRZ]`03?nRZ]`3o`00013oXjGG00?o0000
ojFWeonUYmL03_nUYmL00ol0003oZ:[HojRZf005ojRZf0;o00001onYYm@00ol0003o[:_Gojb[e`0@
ojb[e`03o`000?n][mWo[JoI00?o[JoI00?o0000ojf_fOn][mT00_l00006ok2_e`03o`000?na/m[o
/K?J013o/K?J00?o0000ooooooooool01Oooool00ol0003oooooooooo`1Aooooo`00I?ooool00ol0
003oooooooooo`0Vooooo`;o00000oooool4o`000003oj^ag?l0003oZ[7N00ooZ[7N00?o0000ojRa
gonX/Ml03OnX/Ml2o`00013oY:gN00?o0000oj:[gOnRZmd03OnRZmd00ol0003oXZ[Loj:Zg008oj:Z
g0?o00000_nPY=P00ol0003oXjGGoj>Ue`0>oj>Ue`03o`000?nUYmOoYJOG00koYJOG00?o0000ojRZ
f?nXZ]P00_nXZ]P3o`0000[oZJOD00?o0000ojb[eon/ZmL03on/ZmL00ol0003o[JoIojf_f@03ojf_
f@?o00002On`[mL00ol0003o/K?Jok6cfP0?ok6cfP03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool0DOooool006Cooooo00?o0000ooooooooool08oooool3o`0000Cooooo0_l00005oj^ag003
o`000?nZ/MkoZ[7N00koZ[7N00?o0000ojRagonX/Ml02OnX/Ml3o`000003ojN^gOl0003oY:gN013o
Y:gN00?o0000oj:[gOnRZmd03OnRZmd00ol0003oXZ[Loj:Zg003oj:Zg0Co00001_nPY=P00ol0003o
XjGGoj>Ue`0>oj>Ue`03o`000?nUYmOoYJOG00koYJOG00Co0000ojRZf?l0003o00003OnYYm@00ol0
003o[:_Gojb[e`0@ojb[e`04o`000?n][mWo[JoIojf_f@;o00003?n`[mL00ol0003o/K?Jok6cfP0>
ok6cfP;o00001oooool00ol0003oooooooooo`1@ooooo`00F?ooool00ol@413o0000o`000003o`00
0003oa0@4?oooooooooo00?ooooo00?o0000ooooooooool08Oooool2o`0000Gooooo0_l00008oj^a
g003o`000?nZ/MkoZ[7N00koZ[7N00?o0000ojRagonX/Ml01OnX/Ml3o`0000GoYjkM00?o0000ojB]
g_nT[Mh03_nT[Mh00ol0003oXZ_Moj:[g@0=oj:[g@03o`000?nRZ]coXZ[L00?o00002_nPY=P00ol0
003oXjGGoj>Ue`0>oj>Ue`03o`000?nUYmOoYJOG00koYJOG0_l0000@ojVWe003o`000?n/ZmOo[:_G
00oo[:_G00Ko0000ojf_fOl0003o0000ok2_eol0000<ok2_e`03o`000?na/m[o/K?J00co/K?J0_l0
00000ond]=Wo0000ooooo`07ooooo`03o`000?oooooooooo04oooooo001Tooooo`03o`000?oooooo
oooo01kooooo0ol00004ooooo`?o00002on[/M`00ol0003oZ[7NojZagP0=ojZagP03o`000?nX/Moo
Z;7O00?oZ;7O0_l00009ojN^g@03o`000?nT[MkoY:gN00koY:gN00?o0000oj:[gOnRZmd02onRZmd4
o`0000koX:CH00?o0000oj>UeonSYML03_nSYML00ol0003oYJOGojFWe`0:ojFWe`?o000000?oYZ?B
o`000?nYYm@03onYYm@00ol0003o[:_Gojb[e`0?ojb[e`;o00000on`[mL00ol0003o/:oGok2_e`0;
ok2_e`03o`000?na/m[o/K?J00Wo/K?J0_l00004okBdf@03o`000?oooooooooo00Cooooo0_l0001A
ooooo`00I?ooool00ol0003oooooooooo`0Looooo`;o000000?oooooo`000?ooool00_ooool2o`00
00koZk7L00?o0000ojZag_nZ/Mh03_nZ/Mh00ol0003oZ;7Oo`000002o`0000_oYjkM00?o0000ojB]
g_nT[Mh03onT[Mh00ol0003oXZ_Moj:[g@07oj:[g@?o00000_nPY]X00ol0003oX:CHoj2Tf00>oj2T
f003o`000?nSYMOoXjGG00goXjGG00?o0000ojFWeonUYmL02?nUYmL2o`0000GoYZ?B00?o0000ojVW
e?nYYm@03_nYYm@00ol0003o[:_Gojb[e`0<ojb[e`;o000000?o[Z_Do`000?n`[mL00_n`[mL00ol0
003o/:oGok2_e`0;ok2_e`03o`000?na/m[o/K?J00Oo/K?J0_l00007okBdf@03o`000?oooooooooo
00Gooooo00?o0000ooooooooool0C_ooool006Cooooo00?o0000ooooooooool06Oooool3o`0000Go
oooo0_l0000Aoj^ag003o`000?nZ/MkoZ[7N00goZ[7N0_l0000?ojN^g@03o`000?nT[MkoY:gN00ko
Y:gN00?o0000oj:[gOnRZmd01?nRZmd3o`0000KoX:KJ00?o0000oj2Tf?nPY=P03OnPY=P00ol0003o
XjGGoj>Ue`0>oj>Ue`03o`000?nUYmOoYJOG00GoYJOG0_l00007ojJSdP03o`000?nYYmCoZJOD00ko
ZJOD00?o0000ojb[eon/ZmL02_n/ZmL2o`0000Co[Z_D00Co0000ok2_eon`[mOo00003_n`[mL00ol0
003o/K?Jok6cfP04ok6cfP;o00002Ond]=T00ol0003oooooooooo`06ooooo`03o`000?oooooooooo
04gooooo001Rooooo`03ohN7Qonj^[[o000001Sooooo0ol00005ooooo`?o000000?oZk3Lo`000?n[
/M`04On[/M`00ol0003oZ[7NojZagP09ojZagP?o000000?oZZkKo`000?nW[]d03onW[]d00ol0003o
Y:gNojB]gP0>ojB]gP03o`000?nRZmgoXZ_M00?o00002OnPY]X00ol0003oX:CHoj2Tf00>oj2Tf003
o`000?nSYMOoXjGG00koXjGG00Co0000ojFWeonUYmOoYJOG0ol0000:ojJSdP03o`000?nYYmCoZJOD
00koZJOD00?o0000ojb[eon/ZmL01_n/ZmL3o`0000Ko[Z_D00Co0000ok2_eon`[mOo00003on`[mL0
1?l0003o/K?Jok6cf_na/mX2o`0000co];CI00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`1=ooooo`00H_ooool00on7QhOo<S8bo`00000Fooooo`;o00001Oooool3o`0000GoZk3L00?o0000
oj^ag?n[/M`03on[/M`00ol0003oZ[7NojZagP06ojZagP?o00001OnZ[]/00ol0003oYjkMojN^g@0=
ojN^g@03o`000?nT[MkoY:gN00koY:gN0ol0000=oj2VfP03o`000?nPY=SoX:CH00goX:CH00?o0000
oj>UeonSYML03_nSYML01?l0003oYJOGo`000?l0000=ojJSdP03o`000?nYYmCoZJOD00koZJOD00?o
0000ojb[eon/ZmL01?n/ZmL2o`0000[o[Z_D00?o0000ok2_eol000003on`[mL01?l0003o/K?Jo`00
0?l0000?okBdf@03o`000?oooooooooo00Gooooo00?o0000ooooooooool0C?ooool007Sooooo0ol0
0005ooooo`;o00002On[/=`00ol0003oZk7Loj^ag00?oj^ag003o`000?nZ/MkoZ[7N00?oZ[7N0_l0
0009ojZ^f`03o`000?nW[]goYjkM00goYjkM00?o0000ojB]g_nT[Mh02_nT[Mh3o`000003oj:Xfol0
003oX:KJ00koX:KJ00?o0000oj2Tf?nPY=P03OnPY=P00ol0003oXjGGoj>Ue`0=oj>Ue`;o00004?nV
Xm800ol0003oZJODojVWe00>ojVWe004o`000?n/ZmOo[:_Gojb[e`;o00003?n^Zm@00ol0003o/:oG
o`00000?ok2_e`;o00004Ond]=T00ol0003oooooooooo`06ooooo`03o`000?oooooooooo04_ooooo
001fooooo`;o00000_ooool00ol0003oooooooooo`03o`0000coZk3L00?o0000oj^ag?n[/M`03on[
/M`00ol0003oZ[7No`000002o`0000_oZZkK00?o0000ojN^gOnW[]d03_nW[]d00ol0003oY:gNojB]
gP06ojB]gP?o00001OnRZ=/00ol0003oX:KJoj2VfP0<oj2VfP03o`000?nPY=SoX:CH00goX:CH00?o
0000oj>UeonSYML02_nSYML3o`000003oj:Od_l0003oYZ?B00ooYZ?B00?o0000ojVWe?nYYm@03_nY
Ym@01?l0003o[:_Go`000?l0000?ojj[e003o`000?n`[mOo000000co/:oG0_l000000onc/=Ko0000
okBdf@0AokBdf@03o`000?oooooooooo00Gooooo00?o0000ooooooooool0:oooool01Olb<S;o0000
o`000?l0003o<S8b01_ooooo001cooooo`?o00001Oooool2o`00013oZk3L00?o0000oj^ag?n[/M`0
3_n[/M`2o`0000ooZZkK00?o0000ojN^gOnW[]d03OnW[]d00ol0003oY:gNojB]gP03ojB]gP?o0000
2?nRZ=/00ol0003oX:KJoj2VfP0=oj2VfP03o`000?nPY=SoX:CH00goX:CH00?o0000oj>UeonSYML0
1_nSYML3o`0000GoXYoB00?o0000ojJSd_nVXm803_nVXm800ol0003oZJODojVWe00=ojVWe0;o0000
4_n^Zm@2o`0000_o/:oG00?o0000ok>`e_nc/=H00_nc/=H00ol0003o];CIokBdf@0?okBdf@03o`00
0?oooooooooo00Kooooo00?o0000ooooooooool0;?ooool00onHV9So410@ooooo`0Kooooo`00LOoo
ool2o`0000Kooooo0_l000000on[/=co0000oj^`g00@oj^`g003o`000?n[/McoZk7L00_oZk7L0_l0
00000on/[]Wo0000ojZ^f`0?ojZ^f`03o`000?nW[]goYjkM00goYjkM00?o0000ojB]g_l000000_l0
000<oj:Xf`03o`000?nPY][oX:KJ00coX:KJ00?o0000oj2Tf?nPY=P03_nPY=P00ol0003oXjGGoj>U
e`02oj>Ue`?o00002?nRWm800ol0003oYZ?BojJSdP0>ojJSdP03o`000?nYYmCoZJOD00[oZJOD0ol0
00000on/YM3o0000ojj[e00Aojj[e0;o00002On`[mL2o`0000Go/k3F00?o0000okBdfOnd]=T04?nd
]=T00ol0003oooooooooo`06ooooo`03o`000?oooooooooo02cooooo00?o410@oiRHV?ooool06_oo
ool006kooooo0ol00006ooooo`;o00001?n[/=`00ol0003oZk3Loj^`g00>oj^`g003o`000?n[/Mco
Zk7L00WoZk7L0_l00004ojb^f@03o`000?nZ[]_oZZkK00goZZkK00?o0000ojN^gOnW[]d03OnW[]d2
o`0000ooXZSK00?o0000oj2Vf_nPY]X03OnPY]X00ol0003oX:CHoj2Tf00=oj2Tf003o`000?nSYMOo
000000;o00003?nRWm800ol0003oYZ?BojJSdP0>ojJSdP03o`000?nYYmCoZJOD00OoZJOD0_l00005
ojbUd003o`000?n^ZmCo[Z_D013o[Z_D00?o0000ok2_eon`[mL01On`[mL2o`0000So/k3F00?o0000
okBdfOnd]=T03ond]=T2o`0000Kooooo0_l0000^ooooo`03ogMgMol@413ooooo01[ooooo001/oooo
o`;o00001oooool2o`0000OoZk3L00?o0000oj^`g?n[/=`03_n[/=`00ol0003oZk7Loj^ag005oj^a
g0?o00001on/[]T00ol0003oZZkKojZ^f`0=ojZ^f`03o`000?nW[]goYjkM00WoYjkM0ol000000onV
Z]Wo0000oj:Xf`0?oj:Xf`03o`000?nPY][oX:KJ00coX:KJ00?o0000oj2Tf?nPY=P03?nPY=P3o`00
00ooXYoB00?o0000ojJSd_nVXm803_nVXm800ol0003oZJODojVWe005ojVWe0;o00001on/YM000ol0
003o[Z_Dojj[e00@ojj[e003o`000?n`[mOo/:oG00?o/:oG0_l0000;ok>`eP03o`000?nd]=Wo];CI
00co];CI0_l000000ong]mWo0000ooooo`07ooooo`03o`000?oooooooooo02_ooooo00?o410@o`00
0?nj^[X06_ooool006Wooooo0ol00002ooooo`03o`000?oooooooooo00;ooooo0_l0000:oj^`g003
o`000?n[/=coZk3L00koZk3L00?o0000oj^ag?n[/M`00_n[/M`2o`0000[o[:kI00?o0000ojZ^fonZ
[]/03_nZ[]/00ol0003oYjkMojN^g@05ojN^g@?o00001OnVZ]T00ol0003oXZSKoj:Xf`0>oj:Xf`03
o`000?nPY][oX:KJ00coX:KJ00?o0000oj2Tf?nPY=P02?nPY=P3o`0000;oWigB00?o0000oj:Od_nR
Wm803_nRWm800ol0003oYZ?BojJSdP0>ojJSdP04o`000?nYYmCoZJODojVWe0?o00002_n/YM000ol0
003o[Z_Dojj[e00?ojj[e0;o00000on`[mL00ol0003o/k3Fok>`eP0;ok>`eP03o`000?nd]=Wo];CI
00_o];CI00?o0000okNgfOng]mT00_ng]mT00ol0003oooooooooo`06ooooo`03o`000?oooooooooo
02Wooooo00CoV9RHob4Q8OnHV9So<S8b6_ooool006Oooooo0_l00006ooooo`04o`000?oooooo0000
o`0000coZk3L00?o0000oj^`g?n[/=`03on[/=`01?l0003oZk7Lo`000?l0000=ojb^f@03o`000?nZ
[]_oZZkK00goZZkK00?o0000ojN^gOnW[]d00onW[]d2o`0000WoYZ[I00?o0000oj:XfonRZ=/03OnR
Z=/00ol0003oX:KJoj2VfP0=oj2VfP03o`000?nPY=SoX:CH00?oX:CH1?l00006oinMdP03o`000?nR
Wm;oXYoB00goXYoB00?o0000ojJSd_nVXm803_nVXm801?l0003oZJODo`000?l0000=ojbUd003o`00
0?n^ZmCo[Z_D00oo[Z_D0_l000000on`[mOo0000o`00000?ok>`eP03o`000?nd]=Wo];CI00So];CI
0_l00005okNgf@03o`000?oooooooooo00Kooooo00?o0000ooooooooool0:Oooool01Ol@413o^[Zj
ooooool@413o^[Zj01Wooooo001Tooooo`?o00002?ooool2o`0000ooZk3L00?o0000oj^`g?n[/=`0
3_n[/=`2o`00013o[:kI00?o0000ojZ^fonZ[]/03OnZ[]/00ol0003oYjkMo`000002o`0000_oYZ[I
00?o0000oj:XfonRZ=/03_nRZ=/00ol0003oX:KJoj2VfP0<oj2VfP03o`000?nPY=SoX:CH00?o0000
2_nOWM800ol0003oXYoBoj:OdP0>oj:OdP03o`000?nVXm;oYZ?B00goYZ?B0_l0000@ojbUd003o`00
0?n^ZmCo[Z_D00ko[Z_D0ol0000Aok>`eP03o`000?nd]=Wo];CI00Ko];CI0_l00008okNgf@03o`00
0?oooooooooo00Kooooo00?o0000ooooooooool09oooool01_nHV9SoA4A4ooooooooooooV9RHoc8b
<QWooooo001Rooooo`;o00002?ooool3o`000003ojZ`g?l0003oZk3L00ooZk3L00?o0000oj^`g?n[
/=`02on[/=`2o`000003oj^]fOl0003o[:kI00oo[:kI00?o0000ojZ^fonZ[]/03OnZ[]/2o`0000oo
YZ[I00?o0000oj:XfonRZ=/03OnRZ=/00ol0003oX:KJoj2VfP0;oj2VfPCo00003_nOWM800ol0003o
XYoBoj:OdP0=oj:OdP03o`000?nVXm;oYZ?B00[oYZ?B0ol000000onXW/go0000ojbUd00@ojbUd003
o`000?n^ZmCo[Z_D00co[Z_D0_l000000onbZm7o0000ok>`eP0Aok>`eP03o`000?nd]=Wo];CI00?o
];CI0_l0000:okNgf@03o`000?oooooooooo00Oooooo00?o0000ooooooooool09_ooool00ol@413o
gMgMooooo`02ooooo`03oa0@4?nj^[[ooooo01Oooooo001Oooooo`?o00001oooool3o`0000GoZ[3L
00?o0000oj^`g?n[/=`03_n[/=`00ol0003oZk3Loj^`g008oj^`g0;o00001?n[[MT00ol0003o[:kI
ojb^f@0>ojb^f@03o`000?nZ[]_oZZkK00WoZZkK0ol000000onZZ]Oo0000ojJZf@0?ojJZf@03o`00
0?nRZ=_oXZSK00goXZSK00?o0000oj2Vf_nPY]X01OnPY]X5o`0000;oWIkD00?o0000oinMd_nOWM80
3OnOWM800ol0003oXYoBoj:OdP0>oj:OdP03o`000?nVXm;oYZ?B00OoYZ?B0_l00005ojRNc@03o`00
0?n/YM3o[:G@00ko[:G@00?o0000ojj[e?n^Zm@02_n^Zm@2o`000005ok:[dOl0003o/Z_Aok:[dOl0
00004_nc/=H01Ol0003o];CIokBdfOnd]=Wo000000go]kOI00?o0000ooooooooool01_ooool00ol0
003oooooooooo`0Uooooo`;o000000CoA4A4ooooooooooooA4A40_l000000ooMgMgoooooooooo`0E
ooooo`00GOooool2o`0000?ooooo00?o0000ooooooooool00_ooool2o`0000WoZ[3L00?o0000oj^`
g?n[/=`03On[/=`00ol0003oZk3Loj^`g005oj^`g0?o00001on[[MT00ol0003o[:kIojb^f@0>ojb^
f@03o`000?nZ[]_oZZkK00GoZZkK0ol00005ojZZe`03o`000?nVZ]WoYZ[I00goYZ[I00?o0000oj:X
fonRZ=/03OnRZ=/00ol0003oX:KJoj2VfP05o`0000SoWIkD00?o0000oinMd_nOWM803OnOWM800ol0
003oXYoBoj:OdP0=oj:OdP03o`000?nVXm;oYZ?B00GoYZ?B0_l00007ojRNc@03o`000?n/YM3o[:G@
00oo[:G@00?o0000ojj[e?n^Zm@01_n^Zm@3o`0000?o/Z_A00Co0000ok:[dOnbZm7o00004_nc/=H0
1?l0003o];CIo`000?l0000?okNgf@03o`000?oooooooooo00Kooooo00?o0000ooooooooool0A?oo
ool005[ooooo0ol00007ooooo`?o00003?nZ/=`00ol0003oZk3Loj^`g00=oj^`g003o`000?n[/=co
Zk3L00;oZk3L0_l0000:oj^]f@03o`000?n/[]Wo[:kI00ko[:kI00?o0000ojZ^fonZ[]/00onZ[]/2
o`0000WoZZ[G00?o0000ojJZfOnVZ]T03OnVZ]T00ol0003oXZSKoj:Xf`0;oj:Xf`Co00003OnMW]@0
0ol0003oWigBoinMdP0=oinMdP03o`000?nRWm;oXYoB00koXYoB00Co0000ojJSd_nVXm;oYZ?B0ol0
000:ojRNc@03o`000?n/YM3o[:G@00ko[:G@00?o0000ojj[e?n^Zm@01?n^Zm@2o`0000Ko/Z_A00Go
0000ok:[dOnbZm7o/Z_Ao`00000Aok>`eP;o00004Ong]mT00ol0003oooooooooo`06ooooo`;o0000
AOooool005Sooooo0_l00008ooooo`;o00003onZ/=`00ol0003oZk3Loj^`g00>oj^`g004o`000?n[
/=co0000o`0000goZjgI00?o0000ojb^fOn/[]T03_n/[]T00ol0003oZZkKo`000002o`0000_oZZ[G
00?o0000ojJZfOnVZ]T03_nVZ]T00ol0003oXZSKoj:Xf`07oj:Xf`?o00000_nOXMH00ol0003oWIkD
oifNe00=oifNe003o`000?nOWM;oWigB00goWigB00?o0000oj:Od_nRWm803OnRWm801?l0003oYZ?B
o`000?l0000=ojRNc@03o`000?n/YM3o[:G@00oo[:G@00Co0000ojj[e?n^ZmCo[Z_D0_l00008ok:[
d@05o`000?nbZm7o/Z_Aok:[dOl000003onc/=H2o`000003okRceOl0003o]kOI017o]kOI00?o0000
ooooooooool01?ooool00ol0003oooooo`000015ooooo`00EOooool3o`0000Oooooo0ol000000onX
/=ko0000ojZ`g00?ojZ`g003o`000?n[/=coZk3L00goZk3L0_l0000@oj^]f@03o`000?n/[]Wo[:kI
00go[:kI0_l0000?ojZZe`03o`000?nVZ]WoYZ[I00goYZ[I00?o0000oj:XfonRZ=/01?nRZ=/3o`00
00KoWj7F00?o0000oifNe?nMW]@03?nMW]@00ol0003oWigBoinMdP0=oinMdP03o`000?nRWm;oXYoB
00goXYoB0_l0000@ojRNc@03o`000?n/YM3o[:G@00ko[:G@00Co0000ojj[e?l0003o00002_nbZm40
0ol0003o/Z_Aok:[d@02ok:[d@03o`000?nc/=Ko/k3F00[o/k3F0_l00004okRce@03o`000?ng]mWo
]kOI00oo]kOI00?o0000ooooooooool01oooool00ol0003oooooooooo`09ooooo`04ofIVI_l0003o
<S8bonk^kSGooooo000Wooooo`03ohN7Qol0003o000000;o000000?o410@ooooooooool09?ooool2
o`000003ooooool0003ooooo00Cooooo0ol00005ojR`gP03o`000?nZ/=coZ[3L00koZ[3L00?o0000
oj^`g?n[/=`02On[/=`3o`000003ojZ]fOl0003oZjgI00ooZjgI00?o0000ojb^fOn/[]T02on/[]T2
o`000003ojbYeOl0003oZZ[G00ooZZ[G00?o0000ojJZfOnVZ]T03OnVZ]T00ol0003oXZSKoj:Xf`03
o`0000WoWj7F00?o0000oifNe?nMW]@03OnMW]@00ol0003oWigBoinMdP0=oinMdP03o`000?nRWm;o
XYoB00WoXYoB0ol000000onSV<[o0000ojRNc@0?ojRNc@03o`000?n/YM3o[:G@00ko[:G@0_l0000<
ok:[d@03o`000?nbZm7o/Z_A00;o/Z_A00?o0000ok>`e_nc/=H02?nc/=H2o`0000Ko^;?E00?o0000
okNgfOng]mT03ong]mT2o`0000Sooooo00?o0000ooooooooool02?ooool2ohN7Q`03oooooon7QhOo
A4A403Gooooo000Wooooo`03onk^k_lb<S;oc<c<02Kooooo0ol00007ooooo`;o00002OnX/=h00ol0
003oZ[3LojZ`g00=ojZ`g003o`000?n[/=coZk3L00KoZk3L0ol00005ojZ]f@03o`000?n[[MWoZjgI
00koZjgI00?o0000ojb^fOn/[]T02?n/[]T2o`0000Co[:WE00?o0000ojZZeonZZ]L03OnZZ]L00ol0
003oYZ[IojJZf@0=ojJZf@?o00003OnOXMH00ol0003oWIkDoifNe00<oifNe003o`000?nOWM;oWigB
00goWigB00?o0000oj:Od_nRWm801_nRWm83o`0000GoXiS:00?o0000ojRNcOnXW/d03_nXW/d00ol0
003o[:G@ojbUd00;ojbUd0;o000000?o/:C<o`000?nbZm402onbZm400ol0003o/Z_Aok:[d@03ok:[
d@03o`000?nc/=Ko/k3F00Ko/k3F00?o0000okRceOnh/mD01onh/mD00ol0003o]kOIokNgf@0=okNg
f@03o`000?nk^m[o000000Wooooo00?o0000ooooooooool01oooool01Olb<S;ooooooooooooooooo
000003Gooooo000Xooooo`03onk^k_lb<S;oZJVY02?ooooo0_l00007ooooo`?o00003?nX/=h00ol0
003oZ[3LojZ`g00=ojZ`g003o`000?n[/=coZk3L00?oZk3L0_l00009ojZ]f@03o`000?n[[MWoZjgI
00koZjgI00?o0000ojb^fOn/[]T01?n/[]T3o`0000Oo[:WE00?o0000ojZZeonZZ]L03OnZZ]L00ol0
003oYZ[IojJZf@09ojJZf@?o000000?oYJCDo`000?nOXMH03OnOXMH00ol0003oWIkDoifNe00=oifN
e003o`000?nOWM;oWigB00goWigB00?o0000oj:Od_nRWm800_nRWm83o`0000SoXiS:00?o0000ojRN
cOnXW/d03_nXW/d00ol0003o[:G@ojbUd00:ojbUd003o`000?n`Y<co/:C<00;o/:C<00?o0000ok:[
dOnbZm402_nbZm400ol0003o/Z_Aok:[d@02ok:[d@03o`000?nc/=Ko/k3F00Co/k3F0_l0000:okRc
e@03o`000?ng]mWo]kOI00_o]kOI0_l00003ok^kfP03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool01_ooool01_lb<S;ooooooooooooooooo<S8bokZj^SCooooo000Nooooo`03oa0@4?l0003o
000000?o000000?o410@ooooooooool00_ooool00oo^k^ko8B4QoiRHV00Oooooo`?o00001oooool2
o`0000ooZ;3N00?o0000ojZ`g?nZ/=`03_nZ/=`00ol0003oZk3Lo`000002o`0000_oZZgI00?o0000
oj^]fOn[[MT03_n[[MT00ol0003o[:kIojb^f@02ojb^f@;o00002_n/ZMD00ol0003oZZ[GojZZe`0>
ojZZe`03o`000?nVZ]WoYZ[I00GoYZ[I0ol00005ojFTe003o`000?nOXMKoWj7F00coWj7F00?o0000
oifNe?nMW]@03?nMW]@00ol0003oWigBoinMdP0=oinMdP03o`000?nRWm;o000000;o00003?nSV<X0
0ol0003oZ9k=ojRNc@0=ojRNc@03o`000?n/YM3o[:G@00So[:G@0_l00005ok2Tc003o`000?nbZm7o
/Z_A00[o/Z_A00?o0000ok:[dOnbZm400onbZm401?l0003o/k3Fok>`e_nc/=H2o`0000go^;?E00?o
0000okNgfOng]mT02Ong]mT00ol0003o^k_Jok^kfP03ok^kfP03o`000?oooooooooo00Oooooo00?o
0000ooooooooool01_ooool01_lb<S;ooooooooooooooooo<S8bokZj^SCooooo000Zooooo`03onk^
k_lb<S;oc<c<01_ooooo0ol00007ooooo`?o000000?oYk7Oo`000?nX/=h03onX/=h00ol0003oZ[3L
ojZ`g00=ojZ`g0;o00003onZ[MT00ol0003oZjgIoj^]f@0>oj^]f@04o`000?n/[]Wo0000o`0000go
[:WE00?o0000ojZZeonZZ]L03OnZZ]L00ol0003oYZ[IojJZf@03ojJZf@;o00002?nUY=@00ol0003o
Wj7FoinQeP0<oinQeP03o`000?nMW]CoWIkD00goWIkD00?o0000oinMd_nOWM802onOWM83o`0000oo
XiS:00?o0000ojRNcOnXW/d03_nXW/d00ol0003o[:G@ojbUd005ojbUd0;o00002?n`Y<`00ol0003o
/Z_Aok:[d@09ok:[d@03o`000?nbZm7o/Z_A00?o/Z_A00Co0000ok>`e_l0003o00003onh/mD00ol0
003o]kOIokNgf@07okNgf@;o00001onk^mX00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Gooooo00Ko<S8boooooooooooooooooc8b<_nj^[Xdooooo`00:oooool00oo^k^koA4A4ooooo`0H
ooooo`;o00000oooool00ol0003oooooooooo`02ooooo`;o00001OnW/Ml00ol0003oZ;3NojR`gP0>
ojR`gP03o`000?nZ/=coZ[3L00WoZ[3L0ol000000onY[M[o0000ojZ]f@0?ojZ]f@03o`000?n[[MWo
ZjgI00goZjgI0_l0000?ojbYe@03o`000?nZZ]OoZZ[G00koZZ[G00?o0000ojJZfOl000000_l0000;
ojFTe003o`000?nOXMKoWj7F00coWj7F00?o0000oifNe?nMW]@03?nMW]@00ol0003oWigBoinMdP08
oinMdP?o00000_nMTlT00ol0003oXiS:oj>HbP0=oj>HbP03o`000?nXW/goZ9k=00koZ9k=00?o0000
ojbUd?n/YM000on/YM02o`0000[o/:C<00?o0000ok:[dOnbZm402OnbZm400ol0003o/Z_Aok:[d@03
ok:[d@;o00004_nh/mD00ol0003o]kOIokNgf@04okNgf@;o00002Onk^mX00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Cooooo00Go<S8bonk^k_ooooook^k^o`00000eooooo`00:?ooool0
1Onj^[[ooooooooooooooooo<S8b01Kooooo0ol00008ooooo`;o00002?nW/Ml00ol0003oZ;3NojR`
gP0=ojR`gP03o`000?nZ/=coZ[3L00KoZ[3L0ol00005ojV]fP03o`000?nZ[MWoZZgI00goZZgI00?o
0000oj^]fOn[[MT02on[[MT2o`000003oj^Xe?l0003o[:WE00oo[:WE00?o0000ojZZeonZZ]L03OnZ
Z]L2o`0000ooYJCD00?o0000oinQe_nOXMH03?nOXMH00ol0003oWIkDoifNe00<oifNe003o`000?nO
WM;oWigB00?oWigB1?l00006oifCb@03o`000?nSV<[oXiS:00goXiS:00?o0000ojRNcOnXW/d03_nX
W/d01Ol0003o[:G@ojbUd?n/YM3o000000go/:C<00?o0000ok:[dOnbZm402?nbZm400ol0003o/Z_A
ok:[d@02ok:[d@03o`000?nh[]3o000001;o^;?E00?o0000okNgfOng]mT00ong]mT00ol0003o^k_J
ok^kfP0:ok^kfP03o`000?oooooooooo00Kooooo0_l00006ooooo`05ohN7QomVIVKoooooofIVI_m4
A4@0=Oooool002Oooooo00Koc<c<o`000?n7QhOooooookZj^_lQ8B4Dooooo`;o00002?ooool3o`00
00_oYk7O00?o0000ojR`g_nX/=h03OnX/=h00ol0003oZ[3LojZ`g003ojZ`g0;o00002OnY[MX00ol0
003oZZgIojZ]f@0=ojZ]f@03o`000?n[[MWoZjgI00SoZjgI0_l00004oj^Xe003o`000?n/ZMGo[:WE
00ko[:WE00?o0000ojZZeonZZ]L02_nZZ]L2o`000003ojZTdOl0003oYJCD00koYJCD00?o0000oinQ
e_nOXMH03?nOXMH00ol0003oWIkDoifNe00<oifNe003o`000?nOWM;oWigB00?o00002_nMTlT00ol0
003oXiS:oj>HbP0=oj>HbP03o`000?nXW/goZ9k=00koZ9k=00Co0000ojbUd?l0003o00003_n`Y<`0
0ol0003o/Z_Aok:[d@08ok:[d@03o`000?nbZm7o/Z_A00;o00000onh[]000ol0003o^;?EokRce@0@
okRce@03o`000?ng]mWo]kOI00;o00003_nk^mX00ol0003oooooooooo`04ooooo`04o`000?oooooo
ooooo`0000Kooooo00CoIVIVo`000?lb<S;ok^k^=Oooool002Sooooo00GoZJVYob4Q8Ol0003o410@
olc<c00Aooooo`?o00002?ooool2o`0000ooYk7O00?o0000ojR`g_nX/=h03OnX/=h00ol0003oZ[3L
o`000002o`0000_oZJgJ00?o0000ojZ]fOnZ[MT03_nZ[MT00ol0003oZjgIoj^]f@04oj^]f@?o0000
1on[Z=@00ol0003o[:WEojbYe@0=ojbYe@03o`000?nZZ]OoZZ[G00SoZZ[G0_l00004ojZTd@03o`00
0?nUY=CoYJCD00goYJCD00?o0000oinQe_nOXMH03?nOXMH00ol0003oWIkDoifNe00:oifNe0Co0000
3_nMTlT00ol0003oXiS:oj>HbP0=oj>HbP03o`000?nXW/goZ9k=00goZ9k=0_l0000Aok2Tc003o`00
0?nbZm7o/Z_A00Oo/Z_A00?o0000ok:[dOl000001Onh[]000ol0003o^;?EokRce@0@okRce@03o`00
0?ng]mWo0000013o^k_J00?o0000ooooooooool02?ooool00ol0003oooooooooo`0looooo`00??oo
ool2o`000003ooooool0003ooooo00Gooooo0ol000000onV/^3o0000ojNag`0?ojNag`03o`000?nX
/=koZ;3N00coZ;3N0_l0000?ojV]fP03o`000?nZ[MWoZZgI00goZZgI00?o0000oj^]fOn[[MT00_n[
[MT2o`0000[oZjSD00?o0000ojbYeOn/ZMD03_n/ZMD00ol0003oZZ[GojZZe`04ojZZe`?o00001_nZ
Y=400ol0003oYJCDojFTe00=ojFTe003o`000?nOXMKoWj7F00coWj7F00?o0000oifNe?nMW]@01onM
W]@3o`0000;oVI?<00?o0000oifCbOnMTlT03OnMTlT00ol0003oXiS:oj>HbP0=oj>HbP03o`000?nX
W/goZ9k=00_oZ9k=0_l000000on/W<Oo0000ok2Tc00@ok2Tc003o`000?nbZm7o/Z_A00Ko/Z_A0ol0
0007okR^d003o`000?nh/mGo^;?E00oo^;?E0_l0000Bok^kfP03o`000?oooooooooo00Oooooo00?o
0000ooooooooool0??ooool003Wooooo0ol00007ooooo`?o00001OnV/^000ol0003oYk7OojNag`0=
ojNag`03o`000?nX/=koZ;3N00WoZ;3N0ol000000onW[]co0000ojV]fP0?ojV]fP03o`000?nZ[MWo
ZZgI00goZZgI00Co0000oj^]fOl0003o00003On[Z=@00ol0003o[:WEojbYe@0=ojbYe@03o`000?nZ
Z]OoZZ[G00;oZZ[G0_l0000:ojZTd@03o`000?nUY=CoYJCD00goYJCD00?o0000oinQe_nOXMH03?nO
XMH00ol0003oWIkDoifNe003oifNe0?o00001_nITl`00ol0003oWI?9oifCb@0=oifCb@03o`000?nS
V<[oXiS:00goXiS:00?o0000ojRNcOnXW/d02?nXW/d2o`0000Co[9c700?o0000ok2Tc?n`Y<`03on`
Y<`00ol0003o/Z_Aok:[d@02ok:[d@Go00002?nh[]000ol0003o^;?EokRce@0>okRce@03o`000?nm
^MKo000001;o^k_J00?o0000ooooooooool02?ooool00ol0003oooooooooo`0kooooo`00=oooool2
o`0000Oooooo0ol00009ojJbh003o`000?nW/MooYk7O00goYk7O00?o0000ojR`g_nX/=h01_nX/=h2
o`0000GoYjkL00?o0000ojV]f_nY[MX03OnY[MX00ol0003oZZgIojZ]f@0=ojZ]f@;o00003on[Z=@0
0ol0003o[:WEojbYe@0>ojbYe@04o`000?nZZ]Oo0000o`0000goZZCA00?o0000ojFTe?nUY=@03?nU
Y=@00ol0003oWj7FoinQeP0<oinQeP03o`000?nMW]CoWIkD00?o00002OnITl`00ol0003oWI?9oifC
b@0=oifCb@03o`000?nSV<[oXiS:00goXiS:00?o0000ojRNcOnXW/d01_nXW/d2o`0000Ko[9c700?o
0000ok2Tc?n`Y<`03on`Y<`00ol0003o/Z_Ao`000002o`000003ok:[dOl0003o^:k@00;o^:k@00?o
0000okR^d?nh[]001_nh[]000ol0003o^;?EokRce@0;okRce@;o00000onm^MH00ol0003o^k_Jok^k
fP0?ok^kfP;o00002_ooool00ol0003oooooooooo`0jooooo`00=?ooool3o`0000Kooooo0ol0000=
ojJbh003o`000?nW/MooYk7O00goYk7O00?o0000ojR`g_nX/=h00onX/=h2o`0000SoYjkL00?o0000
ojV]f_nY[MX03OnY[MX00ol0003oZZgIojZ]f@09ojZ]f@?o000000?oZJSFo`000?n[Z=@03on[Z=@0
0ol0003o[:WEojbYe@0=ojbYe@;o00003onZY=400ol0003oYJCDojFTe00=ojFTe003o`000?nOXMKo
Wj7F00[oWj7F1?l0000=oiVCc003o`000?nMTlWoWI?900goWI?900?o0000oj>Hb_nSV<X03?nSV<X0
0ol0003oZ9k=ojRNc@04ojRNc@;o00002On/W<L00ol0003o/:C<ok2Tc00=ok2Tc0?o00000_nbZm42
o`0000Go^:k@00?o0000okR^d?nh[]001_nh[]000ol0003o^;?EokRce@09okRce@03o`000?nm^MKo
_KWF00Co_KWF00?o0000ok^kf_nk^mX03?nk^mX2o`000003okk1g?l0003ooooo00Wooooo00?o0000
ooooooooool0>_ooool003?ooooo0_l00005ooooo`?o000000?oYK;Ro`000?nV/^003_nV/^000ol0
003oYk7OojNag`0=ojNag`03o`000?nX/=ko000000;o00002onW[]`00ol0003oZJgJojV]fP0=ojV]
fP03o`000?nZ[MWoZZgI00GoZZgI0ol00005ojVXeP03o`000?n[Z=CoZjSD00koZjSD00?o0000ojbY
eOn/ZMD02_n/ZMD2o`000003oj^Scol0003oZZCA00ooZZCA00?o0000ojFTe?nUY=@03OnUY=@00ol0
003oWj7FoinQeP04oinQePGo00000_nKUll00ol0003oVI?<oiVCc00<oiVCc003o`000?nMTlWoWI?9
00goWI?900?o0000oj>Hb_nSV<X03OnSV<X01?l0003oZ9k=ojRNcOnXW/d2o`0000_o[9c700?o0000
ok2Tc?n`Y<`02_n`Y<`3o`0000;o/:C<00?o0000ok:[dOl000002?nh[]000ol0003o^:k@okR^d005
okR^d003o`000?nh/mGo^;?E00Oo^;?E0_l00007okfieP03o`000?nk^m[o^k_J00_o^k_J00?o0000
okk1g?nn`M`00_nn`M`00ol0003oooooooooo`08ooooo`03o`000?oooooooooo03Wooooo000coooo
o`?o00000_ooool2o`0000GoYK;R00?o0000ojJbh?nV/^003OnV/^000ol0003oYk7OojNag`0<ojNa
g`;o00003_nW[]`00ol0003oZJgJojV]fP0=ojV]fP03o`000?nZ[MWoZZgI00?oZZgI0_l00009ojVX
eP03o`000?n[Z=CoZjSD00goZjSD00?o0000ojbYeOn/ZMD02?n/ZMD2o`0000CoZj??00?o0000ojZT
dOnZY=403OnZY=400ol0003oYJCDojFTe00=ojFTe003o`000?nOXMKoWj7F00Co00002?nKUll00ol0
003oVI?<oiVCc00;oiVCc003o`000?nMTlWoWI?900goWI?900?o0000oj>Hb_nSV<X03OnSV<X01?l0
003oZ9k=o`000?l0000>ojbLa`03o`000?n`Y<co/:C<00Ko/:C<0ol00005ok2Tc0;o00002Onh[]00
0ol0003o^:k@okR^d006okR^d003o`000?nh/mGo^;?E00Co^;?E0_l0000:okfieP03o`000?nk^m[o
^k_J00So^k_J0_l00006okk1g003o`000?oooooooooo00Oooooo0_l0000jooooo`00<oooool00ol0
003oooooooooo`02o`0000SoYK;R00?o0000ojJbh?nV/^003?nV/^000ol0003oYk7OojNag`09ojNa
g`?o000000?oYZoNo`000?nW[]`03_nW[]`00ol0003oZJgJojV]fP0=ojV]fP03o`000?nZ[MWo0000
00;o00002onYZ=H00ol0003oZjSDoj^Xe00>oj^Xe003o`000?n/ZMGo[:WE00Co[:WE0ol00006oj^S
c`03o`000?nZY=7oZZCA00koZZCA00?o0000ojFTe?nUY=@03?nUY=@3o`0000coViO?00?o0000oiVC
c?nITl`03?nITl`00ol0003oWI?9oifCb@0=oifCb@03o`000?nSV<[oXiS:00coXiS:0_l0000@ojbL
a`03o`000?n`Y<co/:C<00?o/:C<0ol00007ok2Tc003o`000?nfY/Wo000000[o^:k@00?o0000okR^
d?nh[]001Onh[]000ol0003o^;?EokRce@03okRce@03o`000?nm^MKo_KWF00[o_KWF00?o0000ok^k
f_nk^mX01_nk^mX2o`0000So_/7L00?o0000ooooooooool01_ooool00ol0003oooooo`00000joooo
o`00<_ooool4o`0000_oYK;R00?o0000ojJbh?nV/^003?nV/^000ol0003oYk7OojNag`06ojNag`;o
00001OnV[mh00ol0003oYjkLojN^g00=ojN^g003o`000?nY[M[oZJgJ00coZJgJ0_l0000?ojVXeP03
o`000?n[Z=CoZjSD00goZjSD00?o0000ojbYeOn/ZMD00_n/ZMD2o`0000[oZj??00?o0000ojZTdOnZ
Y=403OnZY=400ol0003oYJCDojFTe009ojFTe0?o000000?oXi_=o`000?nKUll03OnKUll00ol0003o
VI?<oiVCc00;oiVCc003o`000?nMTlWoWI?900goWI?900?o0000oj>Hb_nSV<X02_nSV<X2o`000003
ojFB`Ol0003o[9c7013o[9c700?o0000ok2Tc?l000000_l00008ok2Tc0;o00000onfY/T00ol0003o
^:k@okR^d008okR^d003o`000?nh[]3o^:k@00Go^:k@00?o0000okRceOnh/mD00_l0000>okfieP03
o`000?nk^m[o^k_J00?o^k_J0_l0000;okk1g003o`000?oooooooooo00Sooooo00?o0000oooooooo
ool0=oooool003;ooooo00?o0000ojFbh_nU/^803OnU/^800ol0003oY[;PojJbh00<ojJbh003o`00
0?nW/MooYk7O00?oYk7O0_l00008ojJ_gP03o`000?nW[]coYjkL00goYjkL00?o0000ojV]f_nY[MX0
2?nY[MX3o`000003ojNYf?l0003oZJSF00koZJSF00?o0000oj^Xe?n[Z=@03_n[Z=@01?l0003o[:WE
o`000?l0000<oj^Sc`03o`000?nZY=7oZZCA00koZZCA00?o0000ojFTe?nUY=@01OnUY=@3o`0000Go
Xi_=00?o0000oi^GconKUll02onKUll00ol0003oVI?<oiVCc00<oiVCc003o`000?nMTlWoWI?900go
WI?900?o0000oj>Hb_nSV<X01onSV<X2o`0000CoYI;100?o0000ojbLaon/W<L03_n/W<L2o`0000[o
/:C<00?o0000okJVbOnfY/T00onfY/T00ol0003o^:k@okR^d008okR^d003o`000?nh[]3o^:k@00Go
^:k@00?o0000okRceOl000004Onm^MH01Ol0003o^k_Jok^kf_nk^m[o000000ko_/7L00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`0fooooo`00<_ooool00ol0003oYK;RojFbhP0>ojFbhP03
o`000?nV/^3oY[;P00coY[;P00?o0000ojNagol000000_l0000;ojJ_gP03o`000?nW[]coYjkL00co
YjkL00?o0000ojV]f_nY[MX01_nY[MX2o`0000GoYjWH00?o0000ojVXe_nYZ=H03OnYZ=H00ol0003o
ZjSDoj^Xe00=oj^Xe0;o00003on[Xll00ol0003oZZCAojZTd@0>ojZTd@03o`000?nUY=CoYJCD00;o
YJCD0_l00008oj>Kc@03o`000?nKUlooViO?00_oViO?00?o0000oiVCc?nITl`03?nITl`00ol0003o
WI?9oifCb@0=oifCb@03o`000?nSV<[oXiS:00CoXiS:0ol00006ojFB`@03o`000?n/W<Oo[9c700_o
[9c71?l00009ok2Tc0;o00001onfY/T00ol0003o^:k@okR^d008okR^d003o`000?nh[]3o^:k@00Co
^:k@0_l0000BokfieP04o`000?nk^m[o0000o`0000oo_/7L00?o0000ooooooooool02?ooool00ol0
003oooooooooo`0fooooo`00<_ooool2o`0000ooYK;R00?o0000ojJbh?nV/^003?nV/^02o`0000ko
YZoN00?o0000ojN^g?nW[]`03OnW[]`00ol0003oZJgJojV]fP03ojV]fP;o00002?nWZMP00ol0003o
ZJSFojVXeP0=ojVXeP03o`000?n[Z=CoZjSD00[oZjSD0_l000000onZX/oo0000oj^Sc`0>oj^Sc`03
o`000?nZY=7oZZCA00koZZCA00?o0000ojFTe?l000000_l0000;oj>Kc@03o`000?nKUlooViO?00_o
ViO?00?o0000oiVCc?nITl`03?nITl`00ol0003oWI?9oifCb@0=oifCb@04o`000?nSV<[oXiS:oj>H
bP;o00002_nUT/400ol0003o[9c7ojbLa`07ojbLa`?o00001?n/W<L00ol0003o/:C<ok2Tc004ok2T
c0;o00002OnfY/T00ol0003o^:k@okR^d009okR^d003o`000?nh[]3o^:k@00;o^:k@00?o0000okjd
d?l000004_nm^MH2o`0001;o_/7L00?o0000ooooooooool02?ooool00ol0003oooooooooo`0eoooo
o`00<Oooool2o`000003ooooool0003oYK;R00koYK;R00?o0000ojJbh?nV/^002?nV/^03o`000003
ojF`h?l0003oYZoN00koYZoN00?o0000ojN^g?nW[]`03OnW[]`00ol0003oZJgJo`000002o`0000[o
YjWH00?o0000ojVXe_nYZ=H03OnYZ=H00ol0003oZjSDoj^Xe008oj^Xe0;o00001?nZX/l00ol0003o
Zj??oj^Sc`0=oj^Sc`03o`000?nZY=7oZZCA00goZZCA0_l0000>oj>Kc@03o`000?nKUlooViO?00_o
ViO?00?o0000oiVCc?nITl`03?nITl`00ol0003oWI?9oifCb@0=oifCb@04o`000?nSV<[o0000o`00
00coYI;100?o0000ojbLaon/W<L01?n/W<L3o`0000Oo[9c700?o0000ok2Tc?n`Y<`00on`Y<`00ol0
003o]ZK9okJVb@0:okJVb@03o`000?nh[]3o^:k@00Wo^:k@00Co0000okR^d?l0003o00000onn]=00
0ol0003o_KWFokfieP0>okfieP03o`000?o2`=So000001;o_/7L0_l0000:ooooo`03o`000?oooooo
oooo03Cooooo000booooo`04o`000?ooooooooooo`0000ooYK;R00?o0000ojJbh?nV/^001?nV/^03
o`0000GoYK3P00?o0000ojJ_g_nV[mh03OnV[mh00ol0003oYjkLojN^g00;ojN^g0?o00003_nWZMP0
0ol0003oZJSFojVXeP0=ojVXeP03o`000?n[Z=CoZjSD00CoZjSD0ol00006ojZRc`03o`000?n[Xloo
Zj??00goZj??00?o0000ojZTdOnZY=402_nZY=43o`000003ojVKb?l0003oXi_=00koXi_=00?o0000
oi^GconKUll02onKUll00ol0003oVI?<oiVCc00<oiVCc003o`000?nMTlWoWI?900coWI?90_l0000?
ojFB`@03o`000?n/W<Oo[9c700?o00002on/W<L00ol0003o/:C<ok2Tc002o`0000ko]ZK900?o0000
okR^d?nh[]002?nh[]02o`0000Ko_[C@00?o0000okfie_nm^MH03?nm^MH01Ol0003o`/3Hol;0f?o2
`=So0000013o_/7L00?o0000ol;8gol000002_ooool00ol0003oooooooooo`0dooooo`00<_ooool0
1Ol0003ooooooooooooooooo000000ooYK;R00?o0000ojJbh?nV/^000ol00009ojF`h003o`000?nV
[mkoYZoN00coYZoN00?o0000ojN^g?nW[]`02?nW[]`3o`0000;oYJ_K00?o0000ojNYf?nWZMP03?nW
ZMP00ol0003oZJSFojVXeP0=ojVXeP03o`000?n[Z=CoZjSD00;oZjSD0_l0000:ojZRc`03o`000?n[
XlooZj??00goZj??00?o0000ojZTdOnZY=401onZY=42o`0000GoZI_800?o0000oj>KcOnSVld03?nS
Vld00ol0003oViO?oi^Gc`0;oi^Gc`03o`000?nITlcoVI?<00coVI?<00?o0000oifCbOnMTlT02OnM
TlT3o`000003oif9__l0003oYI;100koYI;10ol0000>ojbLa`03o`000?n`Y<co0000013o]ZK900?o
0000okR^d?nh[]001onh[]03o`0000Ko_[C@00?o0000okfie_nm^MH02_nm^MH2o`0000Go`/3H00?o
0000okk1g?nn`M`02onn`M`2o`0000?o`/SO00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`0cooooo`005Oooool01?mVIVKo0000oc8b<_o^k^h5ooooo`03oiRHV?l0003oEEEE00Cooooo00Ko
c<c<ob4Q8Ol0003o0000oc8b<_oMgMd6ooooo`03o`000?oooooooooo00?ooooo00?o0000ojFbh_nU
/^803?nU/^83o`0000goYK3P00?o0000ojJ_g_nV[mh03?nV[mh00ol0003oYjkLojN^g004ojN^g0?o
00001_nUZm/00ol0003oYjWHojNYf00<ojNYf003o`000?nYZ=KoZJSF00goZJSF00Co0000oj^Xe?l0
003o00003OnZX/l00ol0003oZj??oj^Sc`0<oj^Sc`03o`000?nZY=7oZZCA00GoZZCA0_l00007ojVK
b003o`000?nSVlgoXi_=00goXi_=00?o0000oi^GconKUll02onKUll00ol0003oVI?<oiVCc00;oiVC
c003o`000?nMTlWoWI?900KoWI?90ol00005oif9_P03o`000?nUT/7oYI;100WoYI;10ol000000onU
T/7o0000ojbLa`0>ojbLa`;o00004_nfY/T00ol0003o^:k@okR^d004okR^d0;o00000onn]=000ol0
003o_[C@okjdd004okjdd003o`000?nm^MKo_KWF00So_KWF00?o0000ol;0f?o2`=P01Oo2`=P00ol0
003o_/7Lokk1g00:okk1g003o`000?o2b=oo`/SO00Co`/SO00?o0000ooooooooool01_ooool00ol0
003oooooo`00000dooooo`005?ooool2ohN7Q`03oooooon7QhOoA4A400Gooooo00?o<S8bo`000?l0
00001?ooool01_o<c<coZJVYooooooooooooV9RHob4Q8@Kooooo0_l00005ooooo`03o`000?nU/^;o
YK;R00SoYK;R0ol000000onT/N;o0000ojF`h00>ojF`h003o`000?nV[mkoYZoN00coYZoN00?o0000
ojN^g?nW[]`00ol0000:ojF[f`03o`000?nWZMSoYjWH00coYjWH00?o0000ojVXe_nYZ=H03?nYZ=H2
o`0000ooZZ;?00?o0000oj^Scon[Xll03On[Xll01?l0003oZZCAojZTdOnZY=43o`0000[oZI_800?o
0000oj>KcOnSVld03?nSVld00ol0003oViO?oi^Gc`0;oi^Gc`03o`000?nITlcoVI?<00coVI?<00?o
0000oifCbOnMTlT00_nMTlT3o`0000SoWHVn00?o0000ojFB`OnUT/401_nUT/43o`0000CoYI;100?o
0000ojbLaon/W<L03?n/W<L00ol0003o/Yc1o`00000BokJVb@03o`000?nh[]3o^:k@00?o^:k@00?o
0000okjdd?nn]=001?nn]=000ol0003o_[C@okjdd004okjdd003o`000?nm^MKo_KWF00Ko_KWF00?o
0000ol;0f?o2`=P01oo2`=P00ol0003o_/7Lokk1g007okk1g0;o00001oo2b=l00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo03;ooooo000Dooooo`05oc8b<_ooooooooooooooool000001Ooo
ool00onYZJWo8B4QogMgM`09ooooo`03ob4Q8Onj^[[ooooo00Cooooo00?o0000ooooooooool01Ooo
ool00ol0003oYK;RojFbhP04ojFbhP?o00001OnT/N800ol0003oYK3PojF`h00<ojF`h003o`000?nV
[mkoYZoN00coYZoN0ol0000=ojF[f`03o`000?nWZMSoYjWH00coYjWH00?o0000ojVXe_nYZ=H02OnY
Z=H3o`000003ojNSd_l0003oZZ;?00ooZZ;?00?o0000oj^Scon[Xll03?n[Xll01?l0003oZZCAo`00
0?l0000=ojVKb003o`000?nSVlgoXi_=00coXi_=00?o0000oi^GconKUll02onKUll00ol0003oVI?<
oiVCc00<oiVCc003o`000?nMTlWo000000;o00002onMRKh00ol0003oYI;1ojFB`@04ojFB`@;o0000
1onUT/400ol0003o[9c7ojbLa`0:ojbLa`;o00000onbW<400ol0003o]ZK9okJVb@0@okJVb@03o`00
0?nh[]3o^:k@00;o00001onn]=000ol0003o_[C@okjdd004okjdd003o`000?nm^MKo_KWF00Go_KWF
00?o0000ol;0f?o2`=P02Oo2`=P00ol0003o_/7Lokk1g005okk1g003o`000?o2b=oo`/SO00So`/SO
00?o0000ooooooooool02?ooool00ol0003oooooooooo`0aooooo`005?ooool01_lb<S;ooooooooo
oooooooo<S8bokZj^Q3ooooo00?o8B4QokZj^_ooool01?ooool00ol0003oooooooooo`06ooooo`03
o`000?nU/^;oYK;R00?o00002OnT/N800ol0003oYK3PojF`h00<ojF`h003o`000?nV[mkoYZoN00So
YZoN0ol000000onS[=go0000ojF[f`0>ojF[f`03o`000?nWZMSoYjWH00coYjWH00?o0000ojVXe_nY
Z=H01OnYZ=H3o`0000GoYj?B00?o0000ojZRconZX/l03OnZX/l00ol0003oZj??oj^Sc`0<oj^Sc`;o
00004?nYVlP00ol0003oXi_=oj>Kc@0<oj>Kc@03o`000?nKUlooViO?00_oViO?00?o0000oiVCc?nI
Tl`02OnITl`4o`0000ooWHVn00?o0000ojFB`OnUT/400ol0000:ojFB`@03o`000?n/W<Oo[9c700So
[9c700?o0000ok:L`OnbW<400onbW<400ol0003o]ZK9okJVb@0@okJVb@03o`000?nh[]3o000000[o
_[C@00?o0000okjdd?nn]=001?nn]=000ol0003o_KWFokfieP02okfieP;o00003Oo2`=P00ol0003o
_/7Lokk1g003okk1g003o`000?o2b=oo`/SO00[o`/SO00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`0`ooooo`005?ooool01_lb<S;ooooooooooooooooo<S8bokZj^Pcooooo00GoIVIVomgM
gOooooooQhN7oa0@4006ooooo`03o`000?oooooooooo00Oooooo0_l0000=ojBahP03o`000?nU/>3o
YK3P00coYK3P00?o0000ojJ_g_nV[mh01?nV[mh3o`0000GoXjcM00?o0000ojF[fonUZm/03OnUZm/0
0ol0003oYjWHojNYf00;ojNYf003o`000?nYZ=KoZJSF00?oZJSF0_l00008ojNSdP03o`000?nZX/oo
ZZ;?00koZZ;?00?o0000oj^Scon[Xll02On[Xll2o`000003ojZJa_l0003oZI_800ooZI_800?o0000
oj>KcOnSVld03?nSVld00ol0003oViO?oi^Gc`0;oi^Gc`03o`000?nITlcoVI?<00;oVI?<1ol00003
oiF4_P03o`000?nMRKkoWHVn00goWHVn0ol0000=ojFB`@03o`000?n/W<Oo[9c700Ko[9c70_l00007
ok:L`@03o`000?nfY/Wo]ZK900oo]ZK90_l0000<okjdd003o`000?nn]=3o_[C@00?o_[C@00Go0000
okfie_nm^MKo_KWFo`00000?ol;0f004o`000?nn`Mco_/7Lokk1g0;o00003Oo2b=l00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo033ooooo000Dooooo`06oc8b<_oooooooooooooooolb<S;o
^[Zj3?ooool01Ol0003o8B4Qo`000?l@413oc<c<00Kooooo00?o0000ooooooooool01oooool00ol0
003oY;7RojBahP0=ojBahP03o`000?nU/>3oYK3P00coYK3P00?o0000ojJ_g_nV[mh00ol00009oj>/
g@03o`000?nUZm_oYJ_K00coYJ_K00?o0000ojNYf?nWZMP03?nWZMP00ol0003oZJSFo`000002o`00
00_oYj?B00?o0000ojZRconZX/l03OnZX/l00ol0003oZj??oj^Sc`07oj^Sc`;o00001?nZV/H00ol0
003oZI_8ojVKb00>ojVKb003o`000?nSVlgoXi_=00coXi_=00?o0000oi^GconKUll02?nKUll7o`00
00_oUHBn00?o0000oif9__nMRKh02OnMRKh4o`00013oYI;100?o0000ojbLaon/W<L01?n/W<L00ol0
003o/Yc1ok:L`@07ok:L`@03o`000?nfY/Wo]ZK900ko]ZK900?o0000okj]b?l000003Onn]=000ol0
003o_[C@okjdd003okjdd003o`000?nm^MKo0000017o`/3H00?o0000okk1g?l000004?o2b=l00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo02oooooo000Dooooo`05oc8b<_o^k^koooooonk^
k_l000003Oooool00ol0003oooooooooo`07ooooo`;o00002_ooool00ol0003oY;7RojBahP0<ojBa
hP03o`000?nU/>3oYK3P00coYK3P0ol0000=oj>/g@03o`000?nUZm_oYJ_K00coYJ_K00?o0000ojNY
f?nWZMP02onWZMP2o`0000ooYj?B00?o0000ojZRconZX/l03OnZX/l00ol0003oZj??oj^Sc`04oj^S
c`;o00001_nZV/H00ol0003oZI_8ojVKb00>ojVKb003o`000?nSVlgoXi_=00coXi_=00Co0000oi^G
conKUlooViO?1ol00003oiB7``03o`000?nEQ;koUHBn00coUHBn00?o0000oif9__nMRKh01_nMRKh3
o`0000CoWHVn00?o0000ojFB`OnUT/403OnUT/400ol0003o[9c7ojbLa`03ojbLa`03o`000?nbW<7o
/Yc100Wo/Yc100?o0000okJVbOnfY/T03?nfY/T01Ol0003o_Zg8okj]b?nn[LSo000000co_[C@00?o
0000okjdd?nn]=000onn]=02o`0001;o`/3H0_l0000Aol;8g`;o00002_ooool00ol0003ooooooooo
o`0^ooooo`005?ooool01On7QhOoIVIVoooooomVIVKoA4A400gooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`0:ooooo`03o`000?nT/N;oY;7R00coY;7R00?o0000ojF`h?nU/>002?nU
/>03o`000003oj:^h?l0003oXjcM00goXjcM00?o0000ojF[fonUZm/03OnUZm/00ol0003oYjWHojNY
f007ojNYf0?o000000?oY:GFo`000?nWXm803_nWXm800ol0003oZZ;?ojZRc`0>ojZRc`04o`000?n[
XlooZj??oj^Sc`;o00002OnZV/H00ol0003oZI_8ojVKb00=ojVKb003o`000?nSVlgoXi_=00coXi_=
1?l0000;oiB7``03o`000?nEQ;koUHBn00_oUHBn00?o0000oif9__nMRKh00onMRKh3o`0000OoWHVn
00?o0000ojFB`OnUT/403_nUT/400ol0003o[9c7ojbLa`02o`0000co/Yc100?o0000okJVbOnfY/T0
2onfY/T00ol0003o_Zg8okj]b002okj]b003o`000?nn]=3o_[C@00_o_[C@00Oo0000okjdd?nn]=3o
_[C@o`000?o6_];o0000017o`/3H00?o0000olO9g?l000004?o2b=l00ol0003o`lkSo`000009oooo
o`;o0000<?ooool001Gooooo00CoIVIVo`000?lb<S;ok^k^3Oooool4o`000003oa0@4?oooooooooo
00?ooooo00?o0000ooooooooool02oooool00ol0003oY;7RojBahP0<ojBahP03o`000?nU/>3oYK3P
00CoYK3P0ol00005oj:^h003o`000?nS[=goXjcM00coXjcM00?o0000ojF[fonUZm/03?nUZm/00ol0
003oYjWHojNYf004ojNYf0?o00001OnTYMH00ol0003oYj?BojNSdP0=ojNSdP03o`000?nZX/ooZZ;?
00goZZ;?00Co0000oj^Scol0003o00002onZV/H00ol0003oZI_8ojVKb00>ojVKb003o`000?nSVlgo
Xi_=00SoXi_=0ol000000onPS/7o0000oiB7``0<oiB7``03o`000?nEQ;koUHBn00coUHBn00?o0000
oif9__l000000_l0000:oif9_P03o`000?nUT/7oYI;100koYI;100?o0000ojbLaol000003onbW<40
0ol0003o]ZK9okJVb@09okJVb@03o`000?nn[LSo_Zg800Co_Zg800?o0000okjdd?nn]=002onn]=00
0ol0003o_[C@o`000003olJndP03o`000?o2`=So`/3H00co`/3H0_l00003olO9g003o`000?o2b=oo
`/SO00_o`/SO0_l00003ol?>h`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0;Oooool0
033ooooo00?o0000ooooooooool03?ooool00ol0003oY;7RojBahP0<ojBahP03o`000?nU/>3oYK3P
00?o00002OnR[^000ol0003oXjcMoj>/g@0<oj>/g@03o`000?nUZm_oYJ_K00coYJ_K00?o0000ojNY
f?nWZMP00ol00009ojBUeP03o`000?nWXm;oYj?B00coYj?B00?o0000ojZRconZX/l03OnZX/l2o`00
00koZY[600?o0000ojVKb?nYVlP03OnYVlP00ol0003oXi_=oj>Kc@05oj>Kc@?o00001OnPS/400ol0
003oU8O3oiB7``0:oiB7``03o`000?nEQ;koUHBn00_oUHBn0ol0000>oif9_P03o`000?nUT/7oYI;1
00goYI;10_l0000Aok:L`@03o`000?nfY/Wo]ZK900Ko]ZK90_l00007okj]b003o`000?nn]=3o_[C@
00_o_[C@0_l00005olJndP03o`000?o2`=So`/3H00[o`/3H00?o0000olO9g?o7bM`01?o7bM`00ol0
003o`/SOol;8g`09ol;8g`03o`000?o3c^?o`lkS00Co`lkS00?o0000ooooooooool01oooool00ol0
003oooooooooo`0]ooooo`00<?ooool2o`0000kooooo00?o0000ojBah_nT/N802onT/N83o`0000go
XZkP00?o0000oj>/gOnS[=d03?nS[=d00ol0003oYJ_KojF[f`0;ojF[f`?o00003?nTYMH00ol0003o
Yj?BojNSdP0=ojNSdP03o`000?nZX/ooZZ;?00[oZZ;?0_l000000onWV/Wo0000ojZJaP0=ojZJaP03
o`000?nYVlSoZI_800koZI_800?o0000oj>KcOnSVld00_nSVld2o`0000SoX8k100?o0000oiB7`onD
Ql<02onDQl<00ol0003oUHBnoiF4_P08oiF4_P;o000000?oUHBno`000?nMRKh03_nMRKh00ol0003o
YI;1ojFB`@0<ojFB`@03o`000?nZS[Wo0000017o/Yc100?o0000okJVbOnfY/T01OnfY/T00ol0003o
_Zg8okj]b008okj]b003o`000?nn]=3o_[C@00Wo_[C@0ol00005olJndP03o`000?o2`=So`/3H00Wo
`/3H00?o0000olO9g?o7bM`01Oo7bM`00ol0003o`/SOol;8g`07ol;8g`;o00002?o3c^<00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo02cooooo000_ooooo`;o00004?ooool00ol0003oY;7R
ojBahP07ojBahP?o000000?oX[3Ro`000?nR[^003_nR[^000ol0003oXjcMoj>/g@0;oj>/g@03o`00
0?nUZm_oYJ_K00SoYJ_K0ol000000onRYm[o0000ojBUeP0=ojBUeP03o`000?nWXm;oYj?B00coYj?B
00?o0000ojZRconZX/l02?nZX/l2o`0000CoYi[900?o0000ojZJa_nZV/H03?nZV/H00ol0003oZI_8
ojVKb00=ojVKb003o`000?nSVlgo000000;o00002_nPS/400ol0003oU8O3oiB7``0;oiB7``03o`00
0?nEQ;koUHBn00GoUHBn0ol00004oiF4_P03o`000?nMRKkoWHVn00coWHVn00?o0000ojFB`OnUT/40
2_nUT/42o`0000?oZXji00?o0000ok:L`OnbW<403onbW<400ol0003o]ZK9okJVb@03okJVb@03o`00
0?nn[LSo_Zg800[o_Zg800?o0000okjdd?nn]=001onn]=001Ol0003oa[kBolJnd_o6_];o000000Go
a[kB00?o0000ol;0f?o2`=P01_o2`=P2o`0000WoalWL00?o0000ol;8goo2b=l01Oo2b=l00ol0003o
`lkSol?>h`08ol?>h`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0:oooool002oooooo
00?o0000ooooooooool04?ooool00ol0003oY;7RojBahP03ojBahP?o00001OnR/>800ol0003oXZkP
oj:^h00=oj:^h003o`000?nS[=goXjcM00_oXjcM00?o0000ojF[fonUZm/01?nUZm/3o`0000GoXZOJ
00?o0000ojBUe_nTYMH02onTYMH00ol0003oYj?BojNSdP0=ojNSdP03o`000?nZX/ooZZ;?00CoZZ;?
0ol00006ojNJb@03o`000?nZV/KoZY[600coZY[600?o0000ojVKb?nYVlP03OnYVlP2o`0000koX8k1
00?o0000oiB7`onDQl<02_nDQl<00ol0003oUHBnoiF4_P02oiF4_P?o00001onEQ;h00ol0003oWHVn
oif9_P0=oif9_P03o`000?nUT/7oYI;100SoYI;100?o0000ojZ>^OnZS[T00onZS[T00ol0003o/Yc1
ok:L`@0?ok:L`@03o`000?nfY/Wo]ZK900;o]ZK900?o0000okj]b?nn[LP02onn[LP00ol0003o_[C@
okjdd006okjdd003o`000?o6_];oa[kB00?oa[kB00?o0000olJnd_o6_]800_o6_]800ol0003o`/3H
ol;0f005ol;0f003o`000?o7bMcoalWL00[oalWL00?o0000ol;8goo2b=l00oo2b=l00ol0003o`lkS
ol?>h`0:ol?>h`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0:oooool002oooooo00?o
0000ooooooooool04Oooool00ol0003oY;7Ro`000002o`0000WoX[3R00?o0000oj:^h?nR[^003?nR
[^000ol0003oXjcMoj>/g@0<oj>/g@03o`000?nUZm_oYJ_K00?o00002OnRYmX00ol0003oY:GFojBU
eP0;ojBUeP03o`000?nWXm;oYj?B00goYj?B00Co0000ojZRconZX/ooZZ;?0_l00009ojNJb@03o`00
0?nZV/KoZY[600goZY[600?o0000ojVKb?nYVlP02_nYVlP2o`000003ojN>^ol0003oX8k100goX8k1
00?o0000oiB7`onDQl<02onDQl<4o`0000[oUHBn00?o0000oif9__nMRKh03OnMRKh00ol0003oYI;1
ojFB`@06ojFB`@;o00001_nZS[T00ol0003o/Yc1ok:L`@0@ok:L`@04o`000?nfY/Wo]ZK9o`0000oo
_Zg800?o0000okjdd?nn]=000onn]=02o`0000Koa[kB00?o0000olJnd_o6_]800oo6_]800ol0003o
`/3Hol;0f002ol;0f0;o00003Oo7bM`01?l0003o`/SOol;8goo2b=l2o`0000ko`lkS00?o0000oooo
ooooool01oooool00ol0003oooooooooo`0Zooooo`00;oooool00ol0003oooooooooo`0Booooo`03
o`000?nR/>;oX[3R00_oX[3R00?o0000oj:^h?nR[^003?nR[^000ol0003oXjcMoj>/g@0:oj>/g@Co
00003?nRYmX00ol0003oY:GFojBUeP0<ojBUeP03o`000?nWXm;oYj?B00coYj?B00Co0000ojZRcol0
003o00003?nWV/T00ol0003oZY[6ojZJaP0<ojZJaP03o`000?nYVlSoZI_800SoZI_80_l00004ojN>
^`03o`000?nPS/7oX8k100_oX8k100?o0000oiB7`onDQl<02OnDQl<3o`0000koUHBn00?o0000oif9
__nMRKh03?nMRKh00ol0003oYI;1ojFB`@04ojFB`@;o00002OnZS[T00ol0003o/Yc1ok:L`@0?ok:L
`@03o`000?nfY/Wo0000013o_Zg800?o0000okjdd?nn]=000_nn]=000ol0003oa[kBolJndP07olJn
dP03o`000?o6_];oa[kB00?oa[kB00Co0000ol;0f?o2`=So00004?o7bM`00ol0003o`/SOo`00000@
ol?>h`;o00002Oooool00ol0003oooooooooo`0Yooooo`00;_ooool3o`0001?ooooo00?o0000oj:`
h_nR/>803?nR/>800ol0003oXZkPoj:^h00<oj:^h003o`000?nS[=goXjcM00GoXjcM1?l00002oj2Y
g@03o`000?nRYm[oXZOJ00coXZOJ00?o0000ojBUe_nTYMH02onTYMH00ol0003oYj?BojNSdP0;ojNS
dP?o00003_nWV/T00ol0003oZY[6ojZJaP0=ojZJaP03o`000?nYVlSoZI_800GoZI_80_l00006ojN>
^`03o`000?nPS/7oX8k100coX8k100?o0000oiB7`onDQl<01OnDQl<3o`0000;oU8O300?o0000oiF4
__nEQ;h03?nEQ;h00ol0003oWHVnoif9_P0=oif9_P03o`000?nUT/7oYI;100;oYI;100?o0000ojZ>
^OnZS[T02OnZS[T00ol0003o/Yc1ok:L`@0?ok:L`@;o00004_nn[LP01?l0003o_[C@okjdd?l0000;
olJndP03o`000?o6_];oa[kB00;oa[kB00?o0000ol;0f?l000004Oo7bM`2o`0000oo`lkS0_l00000
0oo3e>Oo0000ooooo`07ooooo`;o0000:oooool002oooooo00?o0000ooooooooool04oooool00ol0
003oX[3Roj:`hP0<oj:`hP03o`000?nR[^3oXZkP00coXZkP00?o0000oj>/gOnS[=d01?l00007oj2Y
g@03o`000?nRYm[oXZOJ00_oXZOJ00?o0000ojBUe_nTYMH03?nTYMH00ol0003oYj?BojNSdP07ojNS
dP?o00000_nSW<h00ol0003oYi[9ojNJb@0=ojNJb@03o`000?nZV/KoZY[600coZY[600?o0000ojVK
b?nYVlP01?nYVlP00ol0003oYhjkojN>^`06ojN>^`03o`000?nPS/7oX8k100coX8k100?o0000oiB7
`onDQl<00_nDQl<3o`0000KoU8O300?o0000oiF4__nEQ;h02onEQ;h00ol0003oWHVnoif9_P0=oif9
_P03o`000?nUT/7oYI;100;o00003OnZS[T00ol0003o/Yc1ok:L`@0=ok:L`@03o`000?nlX[ko0000
01;o_Zg800?o0000okjdd?l000003Oo6_]801?l0003oa[kBolJnd_o6_]82o`00017oalWL00?o0000
olWChOl000003_o3c^<00ol0003o`mCWol?Di`02ol?Di`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool02?ooool00ol@413o0000o`000002o`000003omgMgOoooooooooo01Sooooo000_oooo
o`03o`000?oooooooooo01Cooooo00?o0000oj:`h_nR/>802onR/>800ol0003oXZkPoj:^h00<oj:^
h0?o00003?nPZMd00ol0003oXZOJoj:WfP0;oj:WfP03o`000?nTYMKoY:GF00_oY:GF00?o0000ojNS
d_nWXm801?nWXm83o`0000KoXic>00?o0000ojNJbOnWV/T03?nWV/T00ol0003oZY[6ojZJaP0=ojZJ
aP04o`000?nYVlSoZI_8ojVKb0;o00002_nWS[/00ol0003oX8k1oj2>`@0;oj2>`@03o`000?nDQl?o
000000;o00002OnDQl<00ol0003oUHBnoiF4_P0<oiF4_P03o`000?nMRKkoWHVn00coWHVn00?o0000
ojFB`Ol000003onZS[T00ol0003o/Yc1ok:L`@0<ok:L`@05o`000?nlX[ko_::nokbR__l000004Onn
[LP2o`0000koa[kB00Ko0000olJnd_o6_];o0000olg;eol0000?olO9g0;o00000oo9dn400ol0003o
`lkSol?>h`09ol?>h`;o00001_o3e>L00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool06oooool002oooooo00?o0000ooooooooool05Oooool00ol0003oX[3R
oj:`hP0;oj:`hP03o`000?nR[^3oXZkP00SoXZkP0ol000000onO[>3o0000oj2Yg@0<oj2Yg@03o`00
0?nRYm[oXZOJ00coXZOJ00?o0000ojBUe_nTYMH02onTYMH00ol0003oYj?BojNSdP03o`0000WoXic>
00?o0000ojNJbOnWV/T03OnWV/T00ol0003oZY[6ojZJaP0<ojZJaP04o`000?nYVlSo0000o`0000co
Yhjk00?o0000oj2>`OnPS/402onPS/42o`0000goU8O300?o0000oiF4__nEQ;h02onEQ;h00ol0003o
WHVnoif9_P0<oif9_P;o00004?nZS[T00ol0003o/Yc1ok:L`@0;ok:L`@03o`000?nlX[ko_::n00;o
_::n00?o0000okj]b?nn[LP03_nn[LP00ol0003obKW;o`00000?olJndP;o00000oo=bmL00ol0003o
alWLolO9g00;olO9g003o`000?o9dn7obM?Q00CobM?Q00?o0000ol?>hoo3c^<01_o3c^<2o`0000Wo
`mCW00?o0000ooooooooool01_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo01_o
oooo000^ooooo`?o00005oooool00ol0003oX[3Roj:`hP0;oj:`hP03o`000?nR[^3oXZkP00CoXZkP
0ol00005oin/h003o`000?nPZMgoX:WM00_oX:WM00?o0000oj:Wf_nRYmX02onRYmX00ol0003oY:GF
ojBUeP0;ojBUeP?o00003OnSW<h00ol0003oYi[9ojNJb@0<ojNJb@03o`000?nZV/KoZY[600coZY[6
0_l0000>ojN>^`03o`000?nPS/7oX8k100SoX8k10ol000000onPS/7o0000oiB7``0<oiB7``03o`00
0?nEQ;koUHBn00_oUHBn00?o0000oif9__nMRKh02OnMRKh3o`000003oin0/Ol0003oZXji013oZXji
00?o0000ok:L`OnbW<402OnbW<400ol0003o_::nokbR_P04okbR_P03o`000?nn[LSo_Zg800co_Zg8
00Go0000olViboo9^L_obKW;o`00000>olJndP;o00001?o=bmL00ol0003oalWLolO9g008olO9g0;o
00002?o9dn400ol0003o`lkSol?>h`03ol?>h`;o00002oo3e>L00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool06oooool002kooooo00?o0000ooooooooool0
5oooool00ol0003oX[3Roj:`hP0<oj:`hP03o`000?nR[^3oXZkP00?o00002OnO[>000ol0003oX:WM
oj2Yg@0;oj2Yg@03o`000?nRYm[oXZOJ00_oXZOJ00?o0000ojBUe_nTYMH01onTYMH3o`000003oinO
e?l0003oXic>00goXic>00?o0000ojNJbOnWV/T03?nWV/T00ol0003oZY[6ojZJaP0:ojZJaP;o0000
00?oYhjlo`000?nWS[/03_nWS[/00ol0003oX8k1oj2>`@04oj2>`@?o00001?nPS/400ol0003oU8O3
oiB7``0;oiB7``03o`000?nEQ;koUHBn00coUHBn00?o0000oif9__nMRKh01_nMRKh2o`0000CoWh2a
00?o0000ojZ>^OnZS[T03onZS[T00ol0003o/Yc1ok:L`@08ok:L`@03o`000?nlX[ko_::n00Go_::n
00?o0000okj]b?nn[LP02onn[LP00ol0003obKW;olVib`03olVib`03o`000?o6_];oa[kB00[oa[kB
00?o0000olg;eol000001Oo=bmL00ol0003oalWLolO9g005olO9g0;o00002_o9dn400ol0003o`lkS
ol?>h`02ol?>h`03o`000?o3e>Oo`mCW00co`mCW00?o0000ooooooooool01oooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo01_ooooo000^ooooo`03o`000?oooooooooo01Sooooo00?o
0000oj:`h_nR/>802_nR/>84o`0000goWjcP00?o0000oj2YgOnPZMd02_nPZMd00ol0003oXZOJoj:W
fP0;oj:WfP03o`000?nTYMKoY:GF00CoY:GF0ol00005oinOe003o`000?nSW<koXic>00_oXic>00?o
0000ojNJbOnWV/T03OnWV/T00ol0003oZY[6ojZJaP07ojZJaP;o00001?nWS[`00ol0003oYhjkojN>
^`0<ojN>^`04o`000?nPS/7oX8k1oj2>`@?o00002?nPS/400ol0003oU8O3oiB7``0;oiB7``03o`00
0?nEQ;koUHBn00_oUHBn00?o0000oif9__nMRKh01?nMRKh2o`0000OoWh2a00?o0000ojZ>^OnZS[T0
3_nZS[T00ol0003o/Yc1ok:L`@06ok:L`@;o00002?nlX[h00ol0003o_Zg8okj]b00:okj]b003o`00
0?o9^L_obKW;00CobKW;00?o0000olJnd_o6_]802?o6_]82o`0000?ocL_G00?o0000olg;eoo=bmL0
0_o=bmL00ol0003oalWLolO9g004olO9g003o`000?o9dn7obM?Q00_obM?Q00Co0000ol?>hol0003o
00003oo3e>L2o`0000Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Kooooo`00
8_ooool00ol@413o0000o`000002o`000003omgMgOoooooooooo00Cooooo00?o0000ooooooooool0
6Oooool00ol0003oX[3Roj:`hP05oj:`hPCo00000_nO[^800ol0003oWjcPoin/h00<oin/h003o`00
0?nPZMgoX:WM00_oX:WM00?o0000oj:Wf_nRYmX02onRYmX00ol0003oY:GFojBUeP03o`0000SoWioD
00?o0000oj>Lc_nSW<h03?nSW<h00ol0003oYi[9ojNJb@0<ojNJb@03o`000?nZV/KoZY[600GoZY[6
0_l00006ojN>_003o`000?nWS[_oYhjk00goYhjk0ol0000;oj2>`@03o`000?nDQl?oU8O300_oU8O3
00?o0000oiF4__nEQ;h02onEQ;h01?l0003oWHVnoif9__nMRKh3o`0000WoWh2a00?o0000ojZ>^OnZ
S[T03onZS[T00ol0003o/Yc1ok:L`@04ok:L`@03o`000?nlX[ko_::n00Wo_::n00?o0000okj]b?nn
[LP02?nn[LP00ol0003obKW;olVib`06olVib`03o`000?o6_];oa[kB00Koa[kB00?o0000olg;eoo=
bmL01?o=bmL00ol0003ocL_Golg;e`02olg;e`04o`000?o7bMcoalWLolO9g0;o00003_o9dn42o`00
013o`mCW00?o0000ol7Hjol000002?ooool2o`0000Sooooo00?o0000ooooooooool06oooool002Co
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Jooooo`03o`000?nR/>;oX[3R00Co
00001onO[^800ol0003oWjcPoin/h00<oin/h003o`000?nPZMgoX:WM00_oX:WM00?o0000oj:Wf_nR
YmX02OnRYmX4o`0000coWioD00?o0000oj>Lc_nSW<h02onSW<h00ol0003oYi[9ojNJb@0=ojNJb@03
o`000?nZV/KoZY[600?oZY[600?o0000ojN>_?nWS[`01_nWS[`00ol0003oYhjkojN>^`0:ojN>^`Co
00003OnPS/400ol0003oU8O3oiB7``0;oiB7``03o`000?nEQ;koUHBn00coUHBn0ol0000<oin0/@03
o`000?nZS[WoZXji00ooZXji00?o0000ok:L`OnbW<400onbW<400ol0003o_::nokbR_P0:okbR_P03
o`000?nn[LSo_Zg800Ko_Zg80_l0000:olVib`03o`000?o6_];oa[kB00Coa[kB00?o0000olg;eoo=
bmL01_o=bmL00ol0003ocL_Golg;e`02olg;e`03o`000?o7bMco000000oobM?Q00?o0000olWKiol0
00003_o3e>L2o`0000?o`MS[00?o0000ooooooooool01?ooool01?l0003oooooooooool00005oooo
o`03ohN7Qonj^[[o000001gooooo000Tooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool06oooool2o`0000coWjkR00?o0000oin/h?nO[>003?nO[>000ol0003oX:WMoj2Yg@0:oj2Yg@03
o`000?nRYm[oXZOJ00GoXZOJ1?l00002oibSf@03o`000?nOWmCoWioD00_oWioD00?o0000oj>Lc_nS
W<h03?nSW<h00ol0003oYi[9ojNJb@0<ojNJb@04o`000?nZV/KoZY[6ojZJaP;o00002_nWS[`00ol0
003oYhjkojN>^`06ojN>^`?o00000onWS[/00ol0003oX8k1oj2>`@0<oj2>`@03o`000?nDQl?oU8O3
00_oU8O300?o0000oiF4__nEQ;h02OnEQ;h3o`0000ooWh2a00?o0000ojZ>^OnZS[T03onZS[T01Ol0
003o/Yc1ok:L`OnbW<7o000000ko_::n00?o0000okj]b?nn[LP01?nn[LP00ol0003obKW;olVib`0;
olVib`03o`000?o6_];oa[kB00;oa[kB00?o0000olg;eoo=bmL01oo=bmL00ol0003ocL_Golg;e`02
olg;e`;o00003_o9dn42o`0000?obM_W00?o0000ol?Dioo3e>L02Oo3e>L2o`0000Ko`MS[00?o0000
ooooooooool01_ooool00ol0003oooooooooo`03ooooo`03ohN7Qolb<S;o000001gooooo000Toooo
o`03o`000?oooooooooo00Kooooo00?o0000ooooooooool07?ooool00ol0003oWjkRoin^hP0<oin^
hP03o`000?nO[>3oWjcP00_oWjcP00?o0000oj2YgOnPZMd02onPZMd00ol0003oXZOJoj:WfP04o`00
00OoW:?I00?o0000oinOe?nOWm@02onOWm@00ol0003oXic>oj>LcP0;oj>LcP03o`000?nWV/WoYi[9
00coYi[900Co0000ojZJa_l0003o00003?nWS[`00ol0003oYhjkojN>^`03ojN>^`?o00001onWS[/0
0ol0003oX8k1oj2>`@0;oj2>`@03o`000?nDQl?oU8O300_oU8O300?o0000oiF4__nEQ;h01?nEQ;h5
o`0000;oTW>]00?o0000oin0/OnOP;403OnOP;400ol0003oZXjiojZ>^@0?ojZ>^@04o`000?nbW<7o
/Yc1o`0000oo_::n00?o0000okj]b?nn[LP00onn[LP00ol0003obKW;olVib`0<olVib`05o`000?o6
_];oa[kBolJnd_l000002oo=bmL01_l0003ocL_Golg;eol0003od]WNo`0000gobM?Q00?o0000olWK
ioo9fnL01?o9fnL00ol0003o`mCWol?Di`07ol?Di`03o`000?o1f>_o`MS[00Oo`MS[00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`0Rooooo`009?ooool00ol0003oooooooooo`06ooooo`03
o`000?oooooooooo01gooooo00?o0000oin^h_nO[^803?nO[^800ol0003oWjcPoin/h00;oin/h003
o`000?nPZMgoX:WM00SoX:WM1Ol0000<oibSf@03o`000?nOWmCoWioD00[oWioD00?o0000oj>Lc_nS
W<h03?nSW<h00ol0003oYi[9ojNJb@0;ojNJb@;o00003_nWS[`01?l0003oYhjkojN>^onWS[/2o`00
00[oYhjk00?o0000oj2>`OnPS/402onPS/400ol0003oU8O3oiB7``0;oiB7``03o`000?nEQ;koUHBn
00Co00001onBLjd00ol0003oWh2aoin0/@0=oin0/@03o`000?nZS[WoZXji00ooZXji00?o0000ok:L
`Ol000004OnlX[h01Ol0003o_Zg8okj]b?nn[LSo0000013obKW;00?o0000olJnd_l000003Oo=bmL2
o`0000?od]WN00?o0000olWChOo9dn402?o9dn42o`0000SobM_W00?o0000ol?Dioo3e>L01?o3e>L2
o`0000_o`MS[00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Qooooo`009?ooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo01kooooo00?o0000oin^h_nO[^802onO[^800ol0
003oWjcPoin/h00<oin/h004o`000?nPZMgoX:WMoj2Yg@Ko00000onKY]h00ol0003oW:?IoibSf@0;
oibSf@03o`000?nOWmCoWioD00_oWioD00?o0000oj>Lc_nSW<h02onSW<h00ol0003oYi[9ojNJb@08
ojNJb@?o000000?oXY32o`000?nWS[`03_nWS[`3o`0000coYhjk00?o0000oj2>`OnPS/402_nPS/4B
o`0000coTW>]00?o0000oin0/OnOP;403OnOP;400ol0003oZXjiojZ>^@0>ojZ>^@;o00004_nlX[h0
1?l0003o_Zg8okj]b?l0000BolVib`03o`000?o=bmOocL_G00cocL_G0_l00004om;IgP03o`000?o9
dn7obM?Q00KobM?Q00?o0000olWKioo9fnL02Oo9fnL01?l0003o`mCWol?Dioo3e>L2o`0000go`MS[
0_l00007ooooo`03o`000?oooooooooo027ooooo000Tooooo`03o`000?oooooooooo00Kooooo00?o
0000ooooooooool07oooool00ol0003oWjkRoin^hP0;oin^hP03o`000?nO[>3oWjcP00[oWjcP1Ol0
000:oi^VgP03o`000?nLXmWoW:?I00_oW:?I00?o0000oinOe?nOWm@02onOWm@00ol0003oXic>oj>L
cP0:oj>LcP03o`000?nWV/WoYi[900GoYi[90ol00005oj:@`P03o`000?nWS[coYhjl00WoYhjl1?l0
000?ojN>^`03o`000?nPS/7oX8k100KoX8k10ol00002oiYk/003o`000?n;L[7oRg:a00_oRg:a00?o
0000oi9c[OnBLjd02onBLjd00ol0003oWh2aoin0/@0=oin0/@03o`000?nZS[WoZXji00goZXji00?o
0000okBB/ol000004_nlX[h00ol0003o_Zg8o`00000BolVib`;o00003Oo=bmL00ol0003od]WNo`00
0005om;IgP03o`000?o9dn7obM?Q00CobM?Q00?o0000olWKioo9fnL02oo9fnL00ol0003o`mCWo`00
000=ol7Hj`;o000000?o_MW^o`000?ooool01oooool00ol0003oooooooooo`0Pooooo`008_ooool0
0on7QhOo^[Zjo`000007ooooo`?o00008Oooool00ol0003oWjkRoin^hP0;oin^hP03o`000?nO[>3o
WjcP00GoWjcP1?l00002oi^Zh@03o`000?nKY]koVjKN00_oVjKN00?o0000oibSfOnLXmT02_nLXmT0
0ol0003oWioDoinOe00;oinOe003o`000?nSW<koXic>00_oXic>00?o0000ojNJbOnWV/T00_nWV/T2
o`0000SoXY3200?o0000ojN>_?nWS[`01_nWS[`3o`0000?oYhjl00?o0000ojN>^onWS[/03OnWS[/0
0ol0003oX8k1oj2>`@03oj2>`@?o00001OnJNk000ol0003oRg:aoh]b/@0;oh]b/@03o`000?nBLjgo
TW>]00_oTW>]00?o0000oin0/OnOP;403OnOP;400ol0003oZXjiojZ>^@0<ojZ>^@05o`000?ndT[?o
]9:cokBB/ol000004_nlX[h00ol0003obKW;olVib`0@olVib`04o`000?oFc=3oe/c@o`0000[ocL_G
0_l00003om;IgP03o`000?oBfMkod]WN00?od]WN00Co0000olWChOo9dn7obM?Q0_l0000>olWKi`;o
00003?o1f>/2o`0000Co_MW^00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Oooooo`00
8_ooool00on7QhOo<S8bo`000008ooooo`03o`000?oooooooooo023ooooo00?o0000oin^h_nO[^80
3?nO[^800ol0003oWjcPoin/h004o`0000OoVj[Q00?o0000oi^Vg_nKY]h02_nKY]h00ol0003oW:?I
oibSf@0;oibSf@03o`000?nOWmCoWioD00_oWioD00?o0000oj>Lc_nSW<h02_nSW<h00ol0003oYi[9
o`000002o`0000[oXY3200?o0000ojN>_?nWS[`00onWS[`3o`0000OoYhjl00?o0000ojN>^onWS[/0
3?nWS[/00ol0003oX8k1oj2>`@03o`0000WoVW^`00?o0000oh]b/On;L[402on;L[400ol0003oTW>]
oi9c[@0;oi9c[@03o`000?nOP;7oWh2a00goWh2a00?o0000ojZ>^OnZS[T02_nZS[T00ol0003o]9:c
okBB/`02okBB/`03o`000?nlX[ko_::n013o_::n00?o0000olViboo9^L/03oo9^L/00ol0003oe/c@
omK<d002omK<d003o`000?o=bmOocL_G00KocL_G00?o0000om;Ig_oBfMh01?oBfMh00ol0003od]WN
om;IgP03om;IgP03o`000?o9dn7o000000kobM_W0_l00002olGPk003o`000?o1f>_o`MS[00Oo`MS[
0_l00007okgIkP03o`000?oooooooooo00Cooooo0_l0000Qooooo`00;?ooool00ol0003ooooooooo
o`0Rooooo`03o`000?nO[^;oWjkR00[oWjkR1?l0000<oi^Zh@03o`000?nKY]koVjKN00[oVjKN00?o
0000oibSfOnLXmT02onLXmT00ol0003oWioDoinOe00:oinOe003o`000?nSW<koXic>00WoXic>0ol0
000>oj:@`P03o`000?nWS[co000000;o00002_nWS[`00ol0003oYhjkojN>^`0<ojN>^`?o00003?nJ
Nk000ol0003oRg:aoh]b/@0;oh]b/@03o`000?nBLjgoTW>]00_oTW>]00?o0000oin0/OnOP;403OnO
P;400ol0003oZXjiojZ>^@09ojZ>^@03o`000?ndT[?o]9:c00?o]9:c00?o0000okbR__nlX[h03onl
X[h00ol0003obk70o`00000?olVib`03o`000?oFc=3oe/c@00Coe/c@00?o0000olg;eoo=bmL01?o=
bmL00ol0003od]WNom;IgP06om;IgP03o`000?oBfMkod]WN00;od]WN0_l0000>olWKi`03o`000?o5
h>coaN3/00?oaN3/00?o0000ol7Hjoo1f>/01Oo1f>/00ol0003o_MW^okgIkP08okgIkP03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool07_ooool002cooooo00?o0000ooooooooool08oooool0
0ol0003oWjkRoin^hP05oin^hPCo00000_nK[N@00ol0003oVj[Qoi^Zh@0;oi^Zh@03o`000?nKY]ko
VjKN00_oVjKN00?o0000oibSfOnLXmT02_nLXmT00ol0003oWioDoinOe00;oinOe003o`000?nSW<ko
Xic>00CoXic>1?l00002oi^Cb`03o`000?nRT<;oXY3200_oXY320ol0000=ojN>_003o`000?nWS[_o
Yhjk00_oYhjk00?o0000ojAoZol000003OnJNk000ol0003oRg:aoh]b/@0;oh]b/@03o`000?nBLjgo
TW>]00_oTW>]00?o0000oin0/OnOP;403OnOP;400ol0003oZXjiojZ>^@08ojZ>^@03o`000?ndT[?o
]9:c00Go]9:c00?o0000okbR__nlX[h03OnlX[h01?l0003obk70ol^a`?l0000>olVib`03o`000?oF
c=3oe/c@00Goe/c@00?o0000olg;eoo=bmL00oo=bmL00ol0003od]WNom;IgP07om;IgP07o`000?oB
fMkod]WNom;Ig_l0003odNGUo`00000<olWKi`;o00001oo5h>`00ol0003o`MS[ol7Hj`02ol7Hj`;o
00003?nmfNh00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01gooooo000/ooooo`03o`00
0?oooooooooo02Cooooo00?o0000oin^h_nO[^801?l00007oi^]i003o`000?nKZ^7oVj[Q00_oVj[Q
00?o0000oi^Vg_nKY]h02_nKY]h00ol0003oW:?IoibSf@0;oibSf@03o`000?nOWmCoWioD00[oWioD
00?o0000oj>Lc_nSW<h01?l00007oi^Cb`03o`000?nRT<;oXY3200OoXY320ol000000onRT<;o0000
ojN>_00>ojN>_003o`000?nWS[_oYhjk00SoYhjk0_l00002ojAoZ`03o`000?nJNk3oVW^`00coVW^`
00?o0000oh]b/On;L[402_n;L[400ol0003oTW>]oi9c[@0;oi9c[@03o`000?nOP;7oWh2a00koWh2a
00?o0000ojZ>^OnZS[T01_nZS[T00ol0003o]9:cokBB/`06okBB/`03o`000?nlX[ko_::n00co_::n
00?o0000ol^a`?o;/L000_o;/L000ol0003obKW;olVib`0:olVib`03o`000?oFc=3oe/c@00Ooe/c@
00Go0000olg;eoo=bmOocL_Go`00000;om;IgP03o`000?oBfMko000000?odNGU00?o0000olWKioo9
fnL01oo9fnL2o`0000[oaN3/00Co0000ol7Hjol0003o00003onmfNh00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo01gooooo000[ooooo`?o00009_ooool2o`0000coVjgT00?o0000oi^ZhOnK
Z^402onKZ^400ol0003oVjKNoi^VgP0:oi^VgP03o`000?nLXmWoW:?I00[oW:?I00?o0000oinOe?nO
Wm@02?nOWm@5o`0000_oVi?;00?o0000oj:@`_nRT<801OnRT<82o`0000GoXY3200?o0000ojN>_?nW
S[`03?nWS[`00ol0003oYhjkojN>^`07ojN>^`03o`000?nTOj_oY7n[00?oY7n[00?o0000oiYk/?nJ
Nk002onJNk000ol0003oRg:aoh]b/@0:oh]b/@03o`000?nBLjgoTW>]00coTW>]00?o0000oin0/OnO
P;403OnOP;400ol0003oZXjiojZ>^@05ojZ>^@03o`000?ndT[?o]9:c00So]9:c00?o0000okbR__nl
X[h02_nlX[h00ol0003obk70ol^a`004ol^a`003o`000?o9^L_obKW;00SobKW;00?o0000omK<d?oF
c=002OoFc=000ol0003ocL_Go`00000<om;IgP;o00001OoAiND00ol0003obM_WolWKi`04olWKi`;o
00003?o5h>`2o`00017o_MW^0_l00006ooooo`03o`000?oooooooooo01cooooo000/ooooo`03o`00
0?oooooooooo02Gooooo00?o0000oi^]i?nK[N@03?nK[N@00ol0003oVj[Qoi^Zh@0:oi^Zh@03o`00
0?nKY]koVjKN00_oVjKN00?o0000oibSfOnLXmT02_nLXmT01?l0003oWioDoinOe?nOWm@6o`0000?o
UiWC00?o0000oi^CbonKTl/02onKTl/01?l0003oXY32oj:@`_nRT<83o`0000OoXY3200?o0000ojN>
_?nWS[`03?nWS[`00ol0003oYhjkojN>^`05ojN>^`;o00001_nTOj/00ol0003oVW^`oiYk/00;oiYk
/003o`000?n;L[7oRg:a00_oRg:a00?o0000oi9c[OnBLjd02onBLjd00ol0003oWh2aoin0/@0=oin0
/@03o`000?nZS[WoZXji00CoZXji00?o0000okBB/ondT[<02OndT[<00ol0003o_::nokbR_P09okbR
_P03o`000?o;/L3obk7000Gobk7000?o0000olViboo9^L/01oo9^L/00ol0003oe/c@omK<d00;omK<
d003o`000?oBfMkod]WN00[od]WN00?o0000om7UiOl000001_oAiND00ol0003obM_WolWKi`02olWK
i`03o`000?o5h>coaN3/00_oaN3/00?o0000okoQl?l000003_nmfNh3o`000003okWIlOl0003ooooo
00Kooooo00?o0000ooooooooool06oooool002cooooo00?o0000ooooooooool09_ooool00ol0003o
VjgToi^]i00<oi^]i003o`000?nKZ^7oVj[Q00[oVj[Q00?o0000oi^Vg_nKY]h02_nKY]h00ol0003o
W:?IoibSf@08oibSf@Ko00002_nGVM<00ol0003oVi?;oi^Cb`0:oi^Cb`Co00002_nRT<800ol0003o
YhjlojN>_00=ojN>_003o`000?nWS[_oYhjk00?oYhjk00?o0000ojAoZonTOj/01_nTOj/00ol0003o
VW^`oiYk/00;oiYk/003o`000?n;L[7oRg:a00_oRg:a00?o0000oi9c[OnBLjd02onBLjd00ol0003o
Wh2aoin0/@0>oin0/@03o`000?nZS[WoZXji00;oZXji00?o0000okBB/ondT[<02ondT[<00ol0003o
_::nokbR_P07okbR_P03o`000?o;/L3obk7000Oobk7000?o0000olViboo9^L/01Oo9^L/00ol0003o
e/c@omK<d00<omK<d0;o00002_oBfMh01Ol0003odNGUom7UiOoAiNGo000000KodNGU00Co0000olWK
iol0003o00003?o5h>`2o`0000?o_n7`00?o0000okgIk_nmfNh02OnmfNh2o`0000Go^MWa00?o0000
ooooooooool01?ooool00ol0003oooooooooo`0Kooooo`00:oooool00ol0003oooooooooo`0Xoooo
o`03o`000?nK[NCoVjgT00_oVjgT00?o0000oi^ZhOnKZ^402onKZ^400ol0003oVjKNoi^VgP0:oi^V
gP04o`000?nLXmWoW:?IoibSf@Ko00000onDW]X00ol0003oUiWCoiNId`0:oiNId`03o`000?nKTl_o
Vi?;00SoVi?;0ol0000>oj:@`P03o`000?nWS[coYhjl00coYhjl00?o0000ojN>^onWS[/00_nWS[/0
0ol0003oY7n[ojAoZ`07ojAoZ`03o`000?nJNk3oVW^`00coVW^`00?o0000oh]b/On;L[402_n;L[40
0ol0003oTW>]oi9c[@0<oi9c[@03o`000?nOP;7oWh2a00goWh2a00Go0000ojZ>^OnZS[WoZXjio`00
000>okBB/`03o`000?nlX[ko_::n00Ko_::n00?o0000ol^a`?o;/L002?o;/L000ol0003obKW;olVi
b`04olVib`03o`000?oFc=3oe/c@00coe/c@00Co0000omkRf?oNh]So00002?oBfMh00ol0003odNGU
om7Ui@03om7Ui@03o`000?oAiNGodNGU00?odNGU0ol0000;olGPk0;o00001_nohO000ol0003o_MW^
okgIkP06okgIkP;o00002?nifO400ol0003oooooooooo`03ooooo`;o00007?ooool002_ooooo0_l0
000Zooooo`03o`000?nK[NCoVjgT00_oVjgT00?o0000oi^ZhOnKZ^402_nKZ^400ol0003oVjKNoi^V
gP08oi^VgPKo00002_nDW]X00ol0003oUiWCoiNId`0:oiNId`03o`000?nKTl_oVi?;00CoVi?;0ol0
0003oi^Cb`03o`000?nRT<;oXY3200_oXY3200?o0000ojN>_?nWS[`03?nWS[`00ol0003oYhjkojN>
^`02o`0000_oY7n[00?o0000oiYk/?nJNk002onJNk000ol0003oRg:aoh]b/@0:oh]b/@03o`000?nB
LjgoTW>]00coTW>]00?o0000oin0/OnOP;403OnOP;401?l0003oZXjiojZ>^Ol0000?okBB/`03o`00
0?nlX[ko_::n00Ko_::n00?o0000ol^a`?o;/L002Oo;/L000ol0003obKW;olVib`02olVib`03o`00
0?oFc=3oe/c@00coe/c@00?o0000omkRf?oNh]P00_oNh]P00ol0003od]WNom;IgP03om;IgP;o0000
1ooAiND01Ol0003odNGUom7UiOoAiNGo000000?obn_/00?o0000olGPk?o5h>`01oo5h>`00ol0003o
_n7`okoQl007okoQl003o`000?nmfNko_MW^00;o_MW^0ol0000;okWIl@05o`000?oooooooooooooo
ool000000_ooool00ol0003oooooooooo`0Iooooo`00:oooool00ol0003oooooooooo`0Zooooo`03
o`000?nK[NCoVjgT00_oVjgT00?o0000oi^ZhOnKZ^402_nKZ^401?l0003oVjKNoi^Vg_nKY]h6o`00
00?oU:?O00?o0000oiBNf_nDW]X02_nDW]X00ol0003oUiWCoiNId`0:oiNId`04o`000?nKTl_oVi?;
oi^Cb`?o00001_nKTl/00ol0003oXY32oj:@`P0;oj:@`P03o`000?nWS[coYhjl00goYhjl0_l0000=
ojAoZ`03o`000?nJNk3oVW^`00_oVW^`00?o0000oh]b/On;L[402on;L[400ol0003oTW>]oi9c[@0;
oi9c[@03o`000?nOP;7oWh2a00koWh2a0_l0000AokBB/`03o`000?nlX[ko_::n00Co_::n00?o0000
ol^a`?o;/L002oo;/L001?l0003obKW;olVibol0000>omK<d003o`000?oNh]Sog^;H00Cog^;H00Go
0000om;Ig_oBfMkod]WNo`000009om7Ui@04o`000?oAiNGo0000o`0000Gobn_/00?o0000olGPk?o5
h>`01?o5h>`2o`0000_o_n7`00Co0000okgIk_l0003o00003_nifO42o`0000Gooooo00?o0000oooo
ooooool06Oooool002_ooooo00?o0000ooooooooool0:oooool00ol0003oVjgToi^]i00;oi^]i003
o`000?nKZ^7oVj[Q00CoVj[Q2Ol0000:oiBSg`03o`000?nDW][oU9kJ00[oU9kJ00?o0000oiNIdonG
VM<02OnGVM<4o`0000[oVi?;00?o0000oj:@`_nRT<802onRT<800ol0003oYhjlojN>_00;ojN>_0;o
00003_nTOj/00ol0003oVW^`oiYk/00<oiYk/003o`000?n;L[7oRg:a00[oRg:a00?o0000oi9c[OnB
Ljd02onBLjd00ol0003oWh2aoin0/@0=oin0/@;o00004_ndT[<00ol0003o_::nokbR_P03okbR_P03
o`000?o;/L3obk7000cobk7000?o0000olVibol000003_oFc=000ol0003og^;HomkRf006omkRf003
o`000?oBfMko000000_odNGU00?o0000ol_[k?o;jn`01_o;jn`01?l0003oaN3/olGPk?o5h>`2o`00
00go_n7`0_l0000>okWIl@;o000000?o]=Obo`000?ooool01Oooool00ol0003oooooooooo`0Hoooo
o`00:oooool00ol0003oooooooooo`0/ooooo`03o`000?nK[NCoVjgT00WoVjgT2?l00006oiBXh`03
o`000?nDXmooU:?O00[oU:?O00?o0000oiBNf_nDW]X02_nDW]X00ol0003oUiWCoiNId`07oiNId`Co
00003?nKTl/00ol0003oXY32oj:@`P0;oj:@`P03o`000?nWS[coYhjl00WoYhjl0_l000000onPP;7o
0000ojAoZ`0=ojAoZ`03o`000?nJNk3oVW^`00coVW^`00?o0000oh]b/On;L[402_n;L[400ol0003o
TW>]oi9c[@0<oi9c[@03o`000?nOP;7oWh2a00_oWh2a00?o0000ojMnY_l000004ondT[<01Ol0003o
_::nokbR__nlX[ko0000013obk7000?o0000omK<d?oFc=003?oFc=000ol0003og^;HomkRf008omkR
f003o`000?oAiNGodNGU00SodNGU0_l000000oo;jnco0000ol_[k007ol_[k003o`000?o5h>co0000
00go_n7`0_l00002okWOl`03o`000?nifO7o^MWa00Wo^MWa0_l00004okCGlP03o`000?oooooooooo
00Cooooo00?o0000ooooooooool05oooool002_ooooo00?o0000ooooooooool0;Oooool00ol0003o
VjgToi^]i004oi^]i0Co00000_nF[>H00ol0003oU:SSoiBXh`0:oiBXh`03o`000?nDXmooU:?O00[o
U:?O00?o0000oiBNf_nDW]X02_nDW]X00ol0003oUiWCoiNId`04oiNId`;o00000onGVM<00ol0003o
Vi?;oi^Cb`0;oi^Cb`03o`000?nRT<;oXY3200[oXY3200?o0000ojN>_?nWS[`01onWS[`2o`0000?o
X82a00?o0000ojAoZonTOj/03OnTOj/00ol0003oVW^`oiYk/00;oiYk/003o`000?n;L[7oRg:a00[o
Rg:a00?o0000oi9c[OnBLjd03?nBLjd00ol0003oWh2aoin0/@0:oin0/@05o`000?nWOZKoYgjVojMn
Y_l000004_ndT[<01?l0003o_::nokbR__l0000Aol^a`003o`000?oFc=3oe/c@00_oe/c@00?o0000
omkRf?oNh]P02?oNh]P00ol0003of_?Po`000008om7Ui@03o`000?o;jncobn_/00;obn_/00?o0000
ol_[k?o;jn`01Oo;jn`3o`0000_o_n7`0_l00005okWOl`03o`000?nifO7o^MWa00Go^MWa0ol00007
okCGlP03o`000?oooooooooo00?ooooo00?o0000ooooooooool05oooool002[ooooo0ol0000_oooo
o`03o`000?nK[NCoVjgT00?o00001onF[>H00ol0003oU:SSoiBXh`0:oiBXh`03o`000?nDXmooU:?O
00[oU:?O00?o0000oiBNf_nDW]X02OnDW]X01?l0003oUiWCoiNIdonGVM<3o`0000KoUiWC00?o0000
oi^CbonKTl/02_nKTl/00ol0003oXY32oj:@`P0;oj:@`P03o`000?nWS[coYhjl00?oYhjl0ol00006
oj20/@03o`000?nTOj_oY7n[00coY7n[00?o0000oiYk/?nJNk002onJNk000ol0003oRg:aoh]b/@0:
oh]b/@03o`000?nBLjgoTW>]00coTW>]00?o0000oin0/OnOP;402OnOP;400ol0003oYgjVojMnYP02
ojMnYP03o`000?ndT[?o]9:c013o]9:c00?o0000okbR__l000004Oo;/L000ol0003oglg6o`00000;
omK<d003o`000?oNh]Sog^;H00Sog^;H00Go0000om[ch?oJln3of_?Po`000006om7Ui@03o`000?o;
jncobn_/00?obn_/00?o0000ol_[k?o;jn`01?o;jn`01Ol0003o`N_aol7[lOo1jo7o000000Oo_n7`
0ol00008okWOl`03o`000?nifO7o^MWa00;o^MWa0_l0000;okCGlP03o`000?oooooooooo00?ooooo
00?o0000ooooooooool05_ooool002[ooooo00?o0000ooooooooool0<?ooool2o`0000_oUZcV00?o
0000oiBXhonDZ><02_nDZ><00ol0003oU:?OoiBSg`09oiBSg`03o`000?nDW][oU9kJ00[oU9kJ0ol0
0009oiNId`03o`000?nKTl_oVi?;00_oVi?;00?o0000oj:@`_nRT<802_nRT<801?l0003oYhjlojN>
_?nWS[`2o`0000WoX82a00?o0000ojAoZonTOj/03?nTOj/00ol0003oVW^`oiYk/00<oiYk/003o`00
0?n;L[7oRg:a00[oRg:a00?o0000oi9c[OnBLjd03?nBLjd00ol0003oWh2aoin0/@07oin0/@03o`00
0?nWOZKoYgjV00?oYgjV00?o0000okBB/ondT[<04OndT[<00ol0003obk70ol^a`00?ol^a`005o`00
0?oOcLKoglg6omo=a_l000002OoFc=000ol0003og^;HomkRf008omkRf003o`000?oJln3of_?P00?o
f_?P00Co0000om7UiOoAiNGodNGU0_l00007ol_[k004o`000?o;jncobn_/ol_[k0;o00001Oo1jo40
0ol0003o_n7`okoQl002okoQl0;o00003?nigo<01?l0003o^MWao`000?l0000>okCGlP03o`000?oo
oooooooo00;ooooo0_l0000Gooooo`001?ooool00oo^k^ko0000o`000004o`0001oooooo00?o0000
ooooooooool0<?ooool00ol0003oUZcVoiJ/iP0;oiJ/iP03o`000?nDZ>?oU:SS00WoU:SS00?o0000
oiBSgonDXml02_nDXml00ol0003oU9kJoiBNfP06oiBNfPCo00003?nGVM<00ol0003oVi?;oi^Cb`0:
oi^Cb`03o`000?nRT<;oXY3200[oXY3200Co0000ojN>_?l0003o00002onPP;400ol0003oY7n[ojAo
Z`0<ojAoZ`03o`000?nJNk3oVW^`00coVW^`00?o0000oh]b/On;L[402_n;L[400ol0003oTW>]oi9c
[@0<oi9c[@03o`000?nOP;7oWh2a00KoWh2a00?o0000ojMnY_nWOZH01OnWOZH00ol0003o]9:cokBB
/`0@okBB/`03o`000?o;/L3obk7000kobk7000?o0000omo=a_oOcLH00ooOcLH00ol0003oe/c@omK<
d005omK<d003o`000?oNh]Sog^;H00Sog^;H00?o0000om[ch?oJln001OoJln000ol0003odNGUo`00
000:ol_[k0?o00002?o1jo401?l0003o_n7`o`000?l0000>okWOl`;o00004?ndeo82o`0000;ooooo
00?o0000ooooool000005oooool000Gooooo00?oEEEEob4Q8Oo^k^h00_ooool00olQ8B7ooooooa0@
4004o`000003omgMgOoooooooooo00;ooooo00?oV9RHo`000?mEEED01?ooool01_o<c<co8B4Qo`00
0?l0003o<S8bomgMg@Oooooo00?o0000ooooooooool0<Oooool00ol0003oUZcVoiJ/iP0:oiJ/iP03
o`000?nDZ>?oU:SS00[oU:SS00?o0000oiBSgonDXml02OnDXml00ol0003oU9kJoiBNfP03oiBNfP?o
00001?nDW]X00ol0003oUiWCoiNId`09oiNId`03o`000?nKTl_oVi?;00[oVi?;00?o0000oj:@`_nR
T<802OnRT<83o`0000goX82a00?o0000ojAoZonTOj/03OnTOj/00ol0003oVW^`oiYk/00;oiYk/003
o`000?n;L[7oRg:a00[oRg:a00?o0000oi9c[OnBLjd03?nBLjd00ol0003oWh2aoin0/@05oin0/@03
o`000?nWOZKoYgjV00KoYgjV00?o0000okBB/ondT[<03ondT[<00ol0003ob:>bo`00000?ol^a`003
o`000?oOcLKoglg600Coglg600?o0000omK<d?oFc=000ooFc=000ol0003og^;HomkRf008omkRf003
o`000?oJln3of_?P00Kof_?P0ol0000:ol_[k0;o00002Oo1jo42o`0000ko^Moc0_l00002okCLm003
o`000?ndeo;o]=Ob00[o]=Ob0ol000000onae?;o0000ooooo`04ooooo`03o`000?oooooooooo01Co
oooo0005ooooo`04onk^k_lQ8B7o8B4Qonk^kPGooooo00?o0000ooooooooool01Oooool00olb<S;o
0000o`000004ooooo`06olc<c?nYZJWooooooooooonHV9So8B4Q1oooool00ol0003oooooooooo`0b
ooooo`03o`000?nF[>KoUZcV00[oUZcV00?o0000oiBXhonDZ><02_nDZ><00ol0003oU:?OoiBSg`09
oiBSg`03o`000?nDW][o000000;o00001onDW]X00ol0003oUiWCoiNId`09oiNId`03o`000?nKTl_o
Vi?;00_oVi?;00?o0000oj:@`_nRT<801?nRT<84o`0000;oUh>l00?o0000oj20/OnPP;402onPP;40
0ol0003oY7n[ojAoZ`0=ojAoZ`03o`000?nJNk3oVW^`00coVW^`00?o0000oh]b/On;L[402On;L[40
0ol0003oTW>]oi9c[@0<oi9c[@03o`000?nOP;7oWh2a00CoWh2a00?o0000ojMnY_nWOZH01onWOZH0
0ol0003o]9:cokBB/`0>okBB/`04o`000?o8Xk;ob:>bo`0000kobk7000?o0000omo=a_oOcLH01_oO
cLH01Ol0003oe/c@omK<d?oFc=3o000000[og^;H00?o0000om[ch?oJln001_oJln001Ol0003ocOWW
olgiioo=nNOo000000Oobn_/0_l000000oo1jo7o0000ol7[l@06ol7[l@;o00000_nhioD00ol0003o
^MocokWOl`09okWOl`;o00001Ondg?@00ol0003o]=ObokCGlP06okCGlP?o00001Onae?800ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo01Cooooo0006ooooo`04onk^k_lQ8B7o8B4Qonk^kPCo
oooo00?o0000ooooooooool01Oooool00onYZJWo8B4QogMgM`09ooooo`03ob4Q8Onj^[[ooooo00Co
oooo0ol0000dooooo`03o`000?nF[>KoUZcV00[oUZcV00?o0000oiBXhonDZ><02OnDZ><00ol0003o
U:?OoiBSg`08oiBSg`?o00002onDW]X00ol0003oUiWCoiNId`09oiNId`03o`000?nKTl_oVi?;00[o
Vi?;00?o0000oj:@`_nRT<801?l00006oiN3_003o`000?nPP;7oX82a00coX82a00?o0000ojAoZonT
Oj/03?nTOj/00ol0003oVW^`oiYk/00<oiYk/003o`000?n;L[7oRg:a00WoRg:a00?o0000oi9c[OnB
Ljd03OnBLjd00ol0003oWh2aoin0/@02oin0/@03o`000?nWOZKoYgjV00WoYgjV00?o0000okBB/ond
T[<03OndT[<01Ol0003ob:>bolRS/_o8Xk;o000000cobk7000?o0000omo=a_oOcLH02?oOcLH00ol0
003oe/c@o`00000:omkRf003o`000?oJln3of_?P00Kof_?P00?o0000olgiioo=nNL00oo=nNL2o`00
00?obn_/0_l00004ol7[l@03o`000?o1jo7o`N_a00;o`N_a0_l00005okSWm@03o`000?nigo?o^Moc
00Go^Moc0ol00008okCLm003o`000?ndeo;o]=Ob00?o]=Ob0_l00009ok7DlP03o`000?oooooooooo
00;ooooo00?o0000ooooooooool04oooool000Oooooo00Cok^k^ob4Q8OlQ8B7ok^k^0oooool00ol0
003oooooooooo`0Aooooo`03ob4Q8Onj^[[ooooo00Cooooo00?o0000ooooooooool0=Oooool00ol0
003oUZcVoiJ/iP09oiJ/iP03o`000?nDZ>?oU:SS00[oU:SS00?o0000oiBSgonDXml01?nDXml3o`00
00;oU:?O00?o0000oiBNf_nDW]X02OnDW]X00ol0003oUiWCoiNId`09oiNId`03o`000?nKTl_oVi?;
00GoVi?;2?l0000;oiN3_003o`000?nPP;7oX82a00_oX82a00?o0000ojAoZonTOj/03?nTOj/00ol0
003oVW^`oiYk/00<oiYk/003o`000?n;L[7oRg:a00[oRg:a00?o0000oi9c[OnBLjd03?nBLjd01Ol0
003oWh2aoin0/OnOP;7o000000coYgjV00?o0000okBB/ondT[<03?ndT[<00ol0003ob:>bolRS/P02
olRS/P03o`000?o;/L3obk7000Wobk7000?o0000omo=a_oOcLH02_oOcLH2o`0000Wog^;H00?o0000
om[ch?oJln001OoJln02o`0000SocOWW00?o0000ol_[k?l000001oo1jo401?l0003o`N_ao`000?l0
0008okSWm@03o`000?nigo?o^Moc00;o^Moc0_l0000<okCLm003o`000?ndeo;o000000;o00003?na
e?800ol0003oooooooooo`02ooooo`03o`000?oooooooooo01;ooooo0005ooooo`06ob4Q8Ooooooo
ooooonk^k_lQ8B7oEEEE0oooool00ol0003oooooooooo`0=ooooo`05ofIVI_oMgMgoooooohN7Qol@
41001_ooool00ol0003oooooooooo`0fooooo`03o`000?nF[>KoUZcV00WoUZcV00?o0000oiBXhonD
Z><02_nDZ><01?l0003oU:?OoiBSgonDXml2o`000003oiBSgol0003o000002;o00001_n=R<X00ol0
003oUh>loiN3_00:oiN3_003o`000?nPP;7oX82a00_oX82a00?o0000ojAoZonTOj/03?nTOj/00ol0
003oVW^`oiYk/00<oiYk/003o`000?n;L[7oRg:a00[oRg:a00?o0000oi9c[OnBLjd03?nBLjd01?l0
003oWh2aoin0/Ol0000=ojMnYP03o`000?ndT[?o]9:c00_o]9:c00?o0000olRS/_o8Xk801?o8Xk80
0ol0003obk70ol^a`007ol^a`003o`000?oOcLKoglg600_oglg600?o0000onc^bol000001ooNh]P0
0ol0003of_?Pom[ch005om[ch003o`000?o=nNOocOWW00SocOWW0ol00007ol7[l@;o00002onhioD0
1?l0003o^Moco`000?l0000>okCLm0;o00004?nae?801Ol0003ooooooooooooooooo000001Cooooo
0005ooooo`Ko00000oooool00ol0003oooooooooo`0=ooooo`05o`000?lQ8B7o0000oa0@4?o<c<`0
1_ooool00ol0003oooooooooo`0gooooo`03o`000?nF[>KoUZcV00WoUZcV00?o0000oiBXhonDZ><0
1?nDZ><<o`0000GoRJ3S00?o0000ohNIgOn7VMd02On7VMd00ol0003oQi3EohN@e@09ohN@e@03o`00
0?n=R<[oSHS:00_oSHS:00?o0000oiN3_?nGPk`02OnGPk`00ol0003oX82aoj20/@0;oj20/@03o`00
0?nTOj_oY7n[00goY7n[00?o0000oiYk/?nJNk003?nJNk000ol0003oRg:aoh]b/@09oh]b/@03o`00
0?nBLjgoTW>]00goTW>]0_l0000?ojMnYP03o`000?ndT[?o]9:c00[o]9:c00?o0000olRS/_o8Xk80
1?o8Xk800ol0003obk70ol^a`007ol^a`003o`000?oOcLKoglg600[oglg600Go0000onc^boo/k/_o
k>k;o`000005omkRf003o`000?oJln3of_?P00Gof_?P00?o0000olgiioo=nNL02?o=nNL01?l0003o
__K_okkfkonnm^l2o`0000Co`N_a0ol0000;okSWm@?o00003?ndg?@3o`0000;o/=Se00?o0000ok7D
l_nae?803?nae?83o`0000?ooooo00?o0000ooooooooool04Oooool000kooooo00?o0000oooooooo
ool03Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo03Sooooo00?o0000oiJ/i_nF
[>H01?nF[>H;o`0000?oS:KW1?l0000;ohVPh`03o`000?n7VMgoQiWM00WoQiWM00?o0000ohN@eOn7
T=D02On7T=D00ol0003oSHS:ohf8bP0:ohf8bP03o`000?nGPkcoUh>l00WoUh>l00?o0000oj20/OnP
P;403?nPP;400ol0003oY7n[ojAoZ`0<ojAoZ`03o`000?nJNk3oVW^`00coVW^`00?o0000oh]b/On;
L[402On;L[400ol0003oTW>]oi9c[@0<oi9c[@;o00004?nWOZH00ol0003o]9:cokBB/`09okBB/`03
o`000?o8Xk;ob:>b00Kob:>b00?o0000ol^a`?o;/L001Oo;/L000ol0003oglg6omo=aP0:omo=aP03
o`000?o/k/_ok>k;00?ok>k;00Go0000omkRf?oNh]Sog^;Ho`000007om[ch003o`000?o=nNOocOWW
00OocOWW0_l00006okkfk`04o`000?o1jo7o0000o`0000?o^>Oe00?o0000okSWmOnhioD01OnhioD3
o`0000?o/N7g00?o0000okCLm?ndg?@01_ndg?@3o`0000Ko/=Se00?o0000ok7Dl_nae?802?nae?83
o`0000?o[]7b00Go0000ooooool0003oooooo`000008ooooo`03ohN7Qol0003o000000;o000000?o
410@ooooooooool00_ooool000cooooo00?oQhN7okZj^_l000003oooool00ol0003oooooooooo`07
ooooo`?o0000>_ooool6o`0000GoT:_Y00?o0000ohbVion<Y^L00on<Y^L3o`0000CoS:KW00?o0000
ohVPhon9X><02On9X><00ol0003oQiWMohNIg@09ohNIg@03o`000?n7T=GoQi3E00SoQi3E00?o0000
ohf8b_n=R<X02_n=R<X00ol0003oUh>loiN3_00:oiN3_003o`000?nPP;7oX82a00_oX82a00?o0000
ojAoZonTOj/03?nTOj/00ol0003oVW^`oiYk/00<oiYk/003o`000?n;L[7oRg:a00[oRg:a00?o0000
oi9c[OnBLjd02OnBLjd2o`000003oi]dY_l0003oYgjV00ooYgjV00?o0000okBB/ondT[<02?ndT[<0
0ol0003ob:>bolRS/P07olRS/P03o`000?o;/L3obk7000Cobk7000?o0000omo=a_oOcLH02_oOcLH0
0ol0003ok>k;onc^b`05onc^b`03o`000?oNh]So000000Kof_?P0_l00008olgii`;o00002?nnm^l3
o`0000Go^>Oe00Co0000okSWmOnhioGo^>Oe0ol00007ok7Qm`03o`000?ndg?Co]=cd00?o]=cd0_l0
000:ok3Hm@03o`000?nae?;o/MCb00Co/MCb0ol00007ojkAlP04o`000?ooooooooooo`0000Sooooo
00?ok^k^oc8b<_o<c<`01oooool000cooooo00?oQhN7oc8b<_l000003oooool4o`000003oa0@4?oo
oooooooo00Cooooo00?o0000ooooooooool0>Oooool00ol0003oT:_Yoi2[j@09oi2[j@03o`000?n<
Y^Oo000000;o00002?n<Y^L00ol0003oRJ3SohVPh`08ohVPh`03o`000?n7VMgoQiWM00WoQiWM00?o
0000ohN@eOn7T=D02On7T=D00ol0003oSHS:ohf8bP0:ohf8bP03o`000?nGPkcoUh>l00WoUh>l00?o
0000oj20/OnPP;402onPP;400ol0003oY7n[ojAoZ`0<ojAoZ`03o`000?nJNk3oVW^`00goVW^`00?o
0000oh]b/On;L[402On;L[400ol0003oTW>]oi9c[@07oi9c[@;o00000onKM:H00ol0003oYgjVojMn
YP0?ojMnYP03o`000?ndT[?o]9:c00Oo]9:c00?o0000olRS/_o8Xk802?o8Xk800ol0003obk70ol^a
`002ol^a`003o`000?oOcLKoglg600_oglg600?o0000onc^boo/k//01_o/k//2o`0000Gof_?P00?o
0000olgiioo=nNL01oo=nNL00ol0003o__K_okkfk`06okkfk`;o00000onbkoH2o`0000?o^>Oe00Co
0000okSWmOl0003o00002onahOL00ol0003o]=cdo`000002o`0000go/=Se00?o0000ok7Dl_nae?80
0ol0000;ojkAlP04o`000?ooooooooooo`0000Sooooo00?ok^k^oc8b<_nYZJT01_ooool002Sooooo
00?o0000ooooooooool0>oooool00ol0003oT:_Yoi2[j@07oi2[j@?o00002on<Y^L00ol0003oRJ3S
ohVPh`09ohVPh`03o`000?n7VMgoQiWM00WoQiWM00?o0000ohN@eOn7T=D02?n7T=D00ol0003oSHS:
ohf8bP0:ohf8bP03o`000?nGPkcoUh>l00WoUh>l00?o0000oj20/OnPP;402onPP;400ol0003oY7n[
ojAoZ`0=ojAoZ`03o`000?nJNk3oVW^`00_oVW^`1?l00009oh]b/@03o`000?nBLjgoTW>]00GoTW>]
0_l00005oi]dYP03o`000?nWOZKoYgjV00ooYgjV00?o0000okBB/ondT[<01_ndT[<00ol0003ob:>b
olRS/P09olRS/P03o`000?o;/L3obk7000;obk7000?o0000omo=a_oOcLH02_oOcLH00ol0003ok>k;
onc^b`07onc^b`03o`000?oKolSo000000;o000000?of_?Po`000?o=nNL01oo=nNL2o`0000Oo__K_
0_l00007ok;_mP03o`000?nhioGo000000;o00003OnahOL2o`00013o/=Se0ol0000?ojkAlP04o`00
0?ooooooooooo`0000Sooooo00?ok^k^ob4Q8OnHV9P01Oooool002Sooooo00?o0000ooooooooool0
??ooool00ol0003oT:_Yoi2[j@03oi2[j@?o00000on@ZnT00ol0003oS:KWohbVi`09ohbVi`03o`00
0?n9X>?oRJ3S00WoRJ3S00?o0000ohNIgOn7VMd02?n7VMd00ol0003oQi3EohN@e@09ohN@e@03o`00
0?n=R<[oSHS:00WoSHS:00?o0000oiN3_?nGPk`02OnGPk`00ol0003oX82aoj20/@0;oj20/@03o`00
0?nTOj_oY7n[00goY7n[00?o0000oiYk/?nJNk002?nJNk03o`000004oiA/X_l0003oPf2Qoh=PX@?o
00001_n;L[400ol0003oTW>]oi9c[@03oi9c[@;o00002?nKM:H00ol0003oYgjVojMnYP0>ojMnYP03
o`000?ndT[?o]9:c00Ko]9:c00?o0000olRS/_o8Xk802_o8Xk801?l0003obk70ol^a`?l0000<omo=
aP03o`000?o/k/_ok>k;00Ook>k;00?o0000om_ob?oKolP00_oKolP4o`0000GocOWW0_l00006okkf
k`?o00002OnbkoH3o`0000;o/N7g00?o0000ok7QmonahOL01onahOL3o`0000;o[M_g00?o0000ok3H
mOn`f?D02_n`f?D3o`000003ojgDm?l0003o[]7b00oo[]7b0_l000000ooooooo0000ooooo`08oooo
o`03onk^k_lb<S;oc<c<00Cooooo000Xooooo`03o`000?oooooooooo03gooooo00?o0000oi2[jOl0
00000_l00007oi2[j@03o`000?n<Y^OoS:KW00WoS:KW00?o0000ohVPhon9X><02?n9X><00ol0003o
QiWMohNIg@09ohNIg@03o`000?n7T=GoQi3E00SoQi3E00?o0000ohf8b_n=R<X02_n=R<X00ol0003o
Uh>loiN3_009oiN3_003o`000?nPP;7oX82a00_oX82a00?o0000ojAoZonTOj/03?nTOj/00ol0003o
VW^`oiYk/005oiYk/0?o00001?nDK:800ol0003oPf2Qoh=PX@03oh=PX@?o00000on;L[401?l0003o
TW>]oi9c[OnBLjd2o`0000[oVgBV00?o0000ojMnY_nWOZH03onWOZH00ol0003o]9:cokBB/`04okBB
/`03o`000?o8Xk;ob:>b00_ob:>b00?o0000ol^a`?l000003?oOcLH00ol0003ok>k;onc^b`07onc^
b`03o`000?oKolSofoo800;ofoo800?o0000ok_lbonko</00_nko</3o`000003olgiiol0003o__K_
00Go__K_0_l0000:ok;_mP;o00000on/i_X01?l0003o/N7gok7Qmol00005ok7Qm`?o00001_n]foL0
0ol0003o/=Seok3Hm@06ok3Hm@?o00001On]e?@00ol0003o[]7bojkAlP0:ojkAlP?o000000Go[<ob
o`000?ooooooooooo`000009ooooo`03onk^k_m4A4Cooooo00?ooooo000Xooooo`;o0000?_ooool2
o`0000_oT:_Y00?o0000ohbVion<Y^L02On<Y^L00ol0003oRJ3SohVPh`08ohVPh`03o`000?n7VMgo
QiWM00WoQiWM00?o0000ohN@eOn7T=D02?n7T=D00ol0003oSHS:ohf8bP09ohf8bP03o`000?nGPkco
Uh>l00WoUh>l00?o0000oj20/OnPP;402onPP;400ol0003oY7n[ojAoZ`0<ojAoZ`03o`000?nJNk3o
VW^`00;oVW^`0ol00007oiA/XP03o`000?n3H:7oPf2Q00KoPf2Q0ol000001?n;L[7o0000o`000?l0
000<oi]dYP03o`000?nWOZKoYgjV00ooYgjV00?o0000okBB/ondT[<00ondT[<00ol0003ob:>bolRS
/P0=olRS/P03o`000?oOcLKoglg600[oglg600?o0000onc^boo/k//01oo/k//00ol0003ofoo8om_o
b002om_ob003o`000?nko<_o^oc;00Go^oc;1Ol00002okkfk`;o00002_nbkoH2o`0000Ko[>Kj00?o
0000ok7Qmol000000onahOL2o`0000[o[M_g00?o0000ok3HmOn`f?D00on`f?D2o`0000Wo[MCd00?o
0000ojkAl_n^dO801_n^dO83o`0000Go[<ob1?l00005ooooo`05okZj^_oooooooooooooooolb<S80
1?ooool002Sooooo00?o0000ooooooooool0>_ooool3o`0000;ooooo00?o0000oi2[jOn@ZnT02On@
ZnT00ol0003oS:KWohbVi`08ohbVi`03o`000?n9X>?oRJ3S00WoRJ3S00?o0000ohNIgOn7VMd02?n7
VMd00ol0003oQi3EohN@e@08ohN@e@03o`000?n=R<[oSHS:00WoSHS:00?o0000oiN3_?nGPk`02OnG
Pk`00ol0003oX82aoj20/@0;oj20/@03o`000?nTOj_oY7n[00goY7n[1?l0000;oiA/XP03o`000?n3
H:7oPf2Q00SoPf2Q0_l0000>oi]dYP03o`000?nWOZKoYgjV00ooYgjV00?o0000okBB/ondT[<00ond
T[<00ol0003ob:>bolRS/P0=olRS/P03o`000?oOcLKoglg600[oglg600?o0000onc^boo/k//01_o/
k//00ol0003ofoo8om_ob002om_ob003o`000?nko<_o^oc;00Go^oc;00?o0000ojShg_nXn=h00onX
n=h3o`0000So/^of0ol00009ojcVnP03o`000?nahOOo000000;o00003On]foL00ol0003o/=Seo`00
0002o`0000co[MCd00?o0000ojkAl_n^dO800on^dO82o`0000Wo[<ob00?o0000ooooool000001?oo
ool01_o<c<co0000ohN7Qooooooo^[Zjob4Q8@Cooooo000Xooooo`03o`000?oooooooooo03Oooooo
0ol00006ooooo`03o`000?n@ZnWoT:_Y00WoT:_Y00?o0000ohbVion<Y^L02?n<Y^L00ol0003oRJ3S
ohVPh`08ohVPh`03o`000?n7VMgoQiWM00WoQiWM00?o0000ohN@eOn7T=D02?n7T=D00ol0003oSHS:
ohf8bP09ohf8bP03o`000?nGPkcoUh>l00SoUh>l00?o0000oj20/OnPP;402onPP;400ol0003oY7n[
ojAoZ`0<ojAoZ`;o00003_nDK:800ol0003oPf2Qoh=PX@09oh=PX@03o`000?nKM:KoVgBV00coVgBV
00?o0000ojMnY_nWOZH04?nWOZH01Ol0003o]9:cokBB/ondT[?o000000oob:>b00?o0000on[;]_l0
00002_oOcLH00ol0003ok>k;onc^b`06onc^b`03o`000?oKolSofoo800;ofoo800?o0000ok_lbonk
o</01?nko</2o`0000CoZ?SN0_l00003oj7blP;o00001?nbkoH2o`0000co[>Kj1?l0000=ojgKm`?o
00004?n]e?@00ol0003o[]7bo`000002o`0000_o[<ob00?o0000ooooool000001Oooool01OnYZJWo
8B4Qo`000?l@413oc<c<00Cooooo000Xooooo`03o`000?oooooooooo03Cooooo0ol0000:ooooo`03
o`000?n@ZnWoT:_Y00CoT:_Y5ol00004ohVPh`03o`000?n7VMgoQiWM00SoQiWM00?o0000ohN@eOn7
T=D02?n7T=D00ol0003oSHS:ohf8bP09ohf8bP03o`000?nGPkcoUh>l00WoUh>l00?o0000oj20/OnP
P;402_nPP;400ol0003oY7n[ojAoZ`0;ojAoZ`03o`000?nVO:Go000000koU6bR00?o0000oh=PXOn3
H:402On3H:400ol0003oVgBVoi]dYP0=oi]dYP03o`000?nWOZKoYgjV00ooYgjV00Co0000okBB/ond
T[?o00004?o8Xk801?l0003oj/^fon[;]_l00008omo=aP03o`000?o/k/_ok>k;00Kok>k;00Co0000
om_ob?oKolSofoo80_l00005ok_lb`;o00001?nXn=h2o`0000OoXO;b00Co0000ok;_m_l0003o0000
2on/i_X3o`0000?oZ=kj00?o0000ojgKmon]foL02?n]foL3o`0000?oZ]Kg00?o0000ojgDm?n]e?@0
3?n]e?@3o`0000oo[<ob0_l0000>ooooo`009oooool00ol0003oooooooooo`0booooo`?o00003_oo
ool6o`0000GoR:_/00?o0000oh6Ujon1YN/02?n1YN/00ol0003oNIgXogVMj004ogVMj0co00001?n7
VMd00ol0003oQi3EohN@e@08ohN@e@03o`000?n=R<[oSHS:00SoSHS:00?o0000oiN3_?nGPk`02OnG
Pk`00ol0003oX82aoj20/@0;oj20/@03o`000?nTOj_oY7n[00WoY7n[00Co0000ojIlYOnVO:Go0000
3_nDK:800ol0003oPf2Qoh=PX@09oh=PX@03o`000?nKM:KoVgBV00goVgBV00?o0000ojMnY_nWOZH0
3onWOZH01?l0003o]9:cokBB/ol0000?olRS/P03o`000?oZbkKoj/^f00;oj/^f00?o0000omo=a_oO
cLH01?oOcLH00ol0003ok>k;onc^b`06onc^b`05o`000?oKolSofoo8om_ob?l000001_nko</00ol0
003oZ?SNojShgP02ojShgP;o00002OnQl_83o`0000[o[>Kj0_l00007ojSNnP03o`000?n]foOo[M_g
00Co[M_g0ol00007oj[Fm`03o`000?n]e?Co[MCd00So[MCd0ol00002oj_@m003o`000?n/co;o[<ob
00co[<ob0ol0000>ooooo`009oooool2o`00033ooooo0ol0000Booooo`03o`000?n8ZncoR:_/00So
R:_/00?o0000oh6Ujon1YN/02?n1YN/00ol0003oNIgXogVMj008ogVMj003o`000?m_TN?oKi7S00Co
Ki7S2?l00007ohN@e@03o`000?n=R<[oSHS:00WoSHS:00?o0000oiN3_?nGPk`02?nGPk`00ol0003o
X82aoj20/@0;oj20/@03o`000?nTOj_oY7n[00SoY7n[00Go0000ojIlYOnVO:GoYWbUo`00000>oiA/
XP03o`000?n3H:7oPf2Q00[oPf2Q00?o0000oi]dY_nKM:H03?nKM:H00ol0003oYgjVojMnYP0@ojMn
YP;o00004?o8Xk800ol0003oj/^fon[;]P03on[;]P03o`000?oOcLKoglg600?oglg600?o0000onc^
boo/k//01_o/k//01?l0003ofoo8om_ob?l00005ok_lb`;o00001?nXn=h00ol0003oXO;boj7blP06
oj7blP?o00000onPjO/2o`0000Ko[>Kj0_l0000:ojSNnP03o`000?n]foOo[M_g00?o00002onZe_L0
0ol0003o[MCdojgDm004ojgDm0?o00001_n[d?@00ol0003o[<obojc?lP08ojc?lP?o00000oooool0
0ol0003oooooooooo`0;ooooo`009oooool00ol0003oooooooooo`0/ooooo`?o00005_ooool00ol0
003oR:_/ohR[k008ohR[k003o`000?n1YN_oPJG[00SoPJG[00?o0000ogVMj?miWNP02?miWNP00ol0
003oKi7SofnAh`08ofnAh`03o`000?mXPm[oJ8?J00Co00001?n7T=D00ol0003oSHS:ohf8bP08ohf8
bP03o`000?nGPkcoUh>l00SoUh>l00?o0000oj20/OnPP;402onPP;400ol0003oY7n[ojAoZ`07ojAo
Z`03o`000?nVO:GoYWbU00?oYWbU00?o0000oiA/X_nDK:802onDK:800ol0003oPf2Qoh=PX@0:oh=P
X@03o`000?nKM:KoVgBV00coVgBV00?o0000ojMnY_nWOZH04?nWOZH00ol0003ob:>bolRS/P0>olRS
/P03o`000?oZbkKoj/^f00Goj/^f00Go0000omo=a_oOcLKoglg6o`000008onc^b`04o`000?oKolSo
foo8o`0000Co^oc;0_l00004ojShgP;o00001onQl_82o`0000SoX>Wk0_l000001?n/i_[o0000o`00
0?l0000<ojSNnP?o00003onZe_L00ol0003o[MCdojgDm003o`0000[oZm3d00?o0000ojc?l_n/co80
1?n/co83o`0000Kooooo00?o0000ooooooooool02oooool002Oooooo00?o0000ooooooooool0:Ooo
ool3o`0001[ooooo00?o0000ohR[k?n8Zn`02?n8Zn`00ol0003oPJG[oh6Uj`08oh6Uj`03o`000?mi
WNSoNIgX00SoNIgX00?o0000ofnAhom_TN<02?m_TN<00ol0003oJ8?JofR3fP03ofR3fPGo00002_n=
R<X00ol0003oUh>loiN3_009oiN3_003o`000?nPP;7oX82a00[oX82a00?o0000ojAoZonTOj/01_nT
Oj/00ol0003oYWbUojIlY@04ojIlY@03o`000?nDK:;oU6bR00_oU6bR00?o0000oh=PXOn3H:402_n3
H:400ol0003oVgBVoi]dYP0<oi]dYP03o`000?nWOZKoYgjV013oYgjV00?o0000olRS/_o8Xk803_o8
Xk800ol0003oj/^fon[;]P06on[;]P03o`000?oOcLKo000000Sok>k;00Co0000om_ob?oKolSo0000
1?nko</00ol0003oZ?SNojShgP02ojShgP;o00001onQl_82o`0000[oX>Wk1?l0000;ojSNnP?o0000
00?oY]Oio`000?l000003_nZe_L4o`0000koZm3d00?o0000ojc?l_n/co800ol00009ooooo`03o`00
0?oooooooooo00_ooooo000Wooooo`03o`000?oooooooooo02Oooooo0_l0000Nooooo`03o`000?n8
ZncoR:_/00SoR:_/00?o0000oh6Ujon1YN/02?n1YN/00ol0003oNIgXogVMj008ogVMj003o`000?m_
TN?oKi7S00OoKi7S00?o0000ofR3f_mXPmX01omXPmX4o`0000SoSHS:00?o0000oiN3_?nGPk`02?nG
Pk`00ol0003oX82aoj20/@0;oj20/@03o`000?nTOj_oY7n[00CoY7n[00?o0000ojIlYOnVO:D01OnV
O:D00ol0003oU6bRoiA/XP0<oiA/XP03o`000?n3H:7oPf2Q00WoPf2Q00?o0000oi]dY_nKM:H03?nK
M:H00ol0003oYgjVojMnYP0?ojMnYP03o`000?oP_;?o000000kob:>b00?o0000on[;]_oZbkH02?oZ
bkH2o`0000Ook>k;00Go0000om_ob?oKolSo0000ok_lb`0<o`0000?oXO;b0ol00009oj3Yn`?o0000
1?nQgo`00ol0003oZ=kjojSNnP06ojSNnP;o00001OnVeoT2o`0000[oZ]Kg0ol00003ojSAm@03o`00
0?n[d?CoZm3d00coZm3d0ol0000<ooooo`03o`000?oooooooooo00_ooooo000Wooooo`?o00009?oo
ool3o`00027ooooo00?o0000ohR[k?n8Zn`02?n8Zn`00ol0003oPJG[oh6Uj`07oh6Uj`03o`000?mi
WNSoNIgX00SoNIgX00?o0000ofnAhom_TN<02?m_TN<00ol0003oJ8?JofR3fP07ofR3fP03o`000?mY
M/goJGK=00?o00001On=R<X00ol0003oUh>loiN3_008oiN3_003o`000?nPP;7oX82a00_oX82a00?o
0000ojAoZonTOj/00onTOj/00ol0003oYWbUojIlY@06ojIlY@03o`000?nDK:;oU6bR00coU6bR00?o
0000oh=PXOn3H:402On3H:400ol0003oVgBVoi]dYP0=oi]dYP03o`000?nWOZKoYgjV00koYgjV00?o
0000on2l/ol000003_o8Xk800ol0003oj/^fon[;]P08on[;]P04o`000?o`lj3o0000o`0000Cok>k;
00?o0000om_ob?l000001Ol00002ofSCY`?o00001Ommi^84o`0000SoX>Wk0ol00008oj7Oo003o`00
0?nXg_[oZ=kj00?oZ=kj0_l00008ojKGn@;o00001_nZe_L3o`0000OoZ=7e00?o0000oj_@m?n[d?@0
2?n[d?@3o`0000oooooo00?o0000ooooooooool02oooool002Kooooo0_l0000Sooooo`?o00009Ooo
ool00ol0003oR:_/ohR[k008ohR[k003o`000?n1YN_oPJG[00OoPJG[00?o0000ogVMj?miWNP02?mi
WNP00ol0003oKi7SofnAh`07ofnAh`03o`000?mXPm[oJ8?J00SoJ8?J00?o0000ofUfcOmYM/d00_mY
M/d3o`0000;oSHS:00?o0000oiN3_?nGPk`02?nGPk`00ol0003oX82aoj20/@0;oj20/@03o`000?nT
Oj_oY7n[00;oY7n[00?o0000ojIlYOnVO:D01onVO:D00ol0003oU6bRoiA/XP0<oiA/XP03o`000?n3
H:7oPf2Q00[oPf2Q00?o0000oi]dY_nKM:H03?nKM:H00ol0003oYgjVojMnYP0=ojMnYP04o`000?oP
_;?oh;bco`0000gob:>b00?o0000on[;]_oZbkH02?oZbkH00ol0003ol?>Poo3cX002oo3cX0;o0000
00Gok>k;o`000?l0003o0000oioCK004o`000003ofSCYol0003o000000GoONKR0ol00004ohkVnP?o
00000_nPjO/3o`0000coXMol00?o0000ojSNn_l000000_l0000;ojKGn@;o00000_nZe_L3o`0000_o
Z=7e00?o0000oj_@m?n[d?@01?n[d?@3o`0001;ooooo00?o0000ooooooooool02oooool002Kooooo
00?o0000ooooooooool07oooool3o`0002Wooooo00?o0000ohR[k?n8Zn`02?n8Zn`00ol0003oPJG[
oh6Uj`07oh6Uj`03o`000?miWNSoNIgX00SoNIgX00?o0000ofnAhom_TN<01om_TN<00ol0003oJ8?J
ofR3fP07ofR3fP03o`000?mYM/goJGK=00GoJGK=1?l0000:oiN3_003o`000?nPP;7oX82a00[oX82a
00Go0000ojAoZonTOj_oY7n[o`00000:ojIlY@03o`000?nDK:;oU6bR00coU6bR00?o0000oh=PXOn3
H:402_n3H:400ol0003oVgBVoi]dYP0<oi]dYP03o`000?nWOZKoYgjV00goYgjV00Go0000on2l/ooP
_;?oh;bco`00000<olRS/P03o`000?oZbkKoj/^f00Soj/^f00?o0000oo3cX?o`lj001?o`lj001?l0
003oWm=/oioCK?nOdf`3o`000003ofSCYol0003o000000CoONKR0ol00008ohkVnPCo00003_nQgo`4
o`0000goY]Oi1?l0000?ojSAm@03o`000?n[d?CoZm3d00?o00005Oooool00ol0003oooooooooo`0;
ooooo`006Oooool00on7QhOo0000o`000002o`000003oa0@4?oooooooooo00Gooooo00?o0000oooo
ooooool07?ooool3o`0002gooooo4_l00003oh6Uj`03o`000?miWNSoNIgX00OoNIgX00?o0000ofnA
hom_TN<02?m_TN<00ol0003oJ8?JofR3fP06ofR3fP03o`000?mYM/goJGK=00SoJGK=0ol00008oiN3
_003o`000?nPP;7oX82a00[oX82a00Co0000ojAoZonTOj_o00002onVO:D00ol0003oU6bRoiA/XP0<
oiA/XP03o`000?n3H:7oPf2Q00[oPf2Q00?o0000oi]dY_nKM:H03?nKM:H00ol0003oYgjVojMnYP0<
ojMnYP03o`000?oP_;?oh;bc00;oh;bc00?o0000olRS/_o8Xk802Oo8Xk800ol0003oj/^fon[;]P08
on[;]P03o`000?o`lj3ol?>P00Gol?>P00?o0000oioCK?nOdf`01Ol00003oggVhP?o00001_n>i_X5
o`0000CoUmgn0_l00007oj7Oo0Go00001?nQeoX00ol0003oY]OiojKGn@08ojKGn@Co000000?oY]7g
o`000?nXdOD03OnXdOD4o`0001Wooooo00?o0000ooooooooool02_ooool001Wooooo00?ok^k^oc8b
<_o<c<`02_ooool00ol0003oooooooooo`0Iooooo`?o0000<?ooool00ol0003oPJc`oh6/l008oh6/
l003o`000?mdYO3oM:G`00CoM:G`2?l00006ogVMj003o`000?m_TN?oKi7S00OoKi7S00?o0000ofR3
f_mXPmX01omXPmX00ol0003oJGK=ofUfc@07ofUfc@03o`000?miK[[oNFjj00?o00001OnGPk`00ol0
003oX82aoj20/@0;oj20/@;o00003OnVO:D00ol0003oU6bRoiA/XP0;oiA/XP03o`000?n3H:7oPf2Q
00[oPf2Q00?o0000oi]dY_nKM:H03?nKM:H00ol0003oYgjVojMnYP0;ojMnYP03o`000?oP_;?oh;bc
00?oh;bc00?o0000olRS/_o8Xk802Oo8Xk800ol0003oj/^fon[;]P08on[;]P03o`000?o`lj3ol?>P
00Col?>P00?o0000oioCK?nOdf`02ol00003ohkVnPCo00002onGgOh00ol0003oXMoloj7Oo004o`00
00[oXMOj00?o0000ojKGnOnVeoT01?nVeoT3o`0000CoY]7g00?o0000ojKAmol000002_nXdOD3o`00
01gooooo00?o0000ooooooooool02_ooool001[ooooo00?ok^k^oc8b<_nYZJT02Oooool00ol0003o
ooooooooo`0Fooooo`?o0000=?ooool00ol0003oPJc`oh6/l008oh6/l003o`000?mdYO3oM:G`00So
M:G`00?o0000of:Ik_mRVNh01_l000000omiWNSo0000ofnAh`08ofnAh`03o`000?mXPm[oJ8?J00Ko
J8?J00?o0000ofUfcOmYM/d01omYM/d00ol0003oNFjjogU^^P03ogU^^P?o00000_nGPk`00ol0003o
X82aoj20/@08oj20/@Co00003_nVO:D00ol0003oU6bRoiA/XP0;oiA/XP03o`000?n3H:7oPf2Q00[o
Pf2Q00?o0000oi]dY_nKM:H03OnKM:H00ol0003oYgjVojMnYP0:ojMnYP03o`000?oP_;?oh;bc00Co
h;bc00?o0000olRS/_o8Xk801oo8Xk800ol0003oj/^fon[;]P08on[;]P03o`000?o`lj3ol?>P00Co
l?>P00?o0000oioCK?nOdf`01_l00005og[Mn@Co00003onGgOh3o`0000ooXMOj00?o0000ojKGnOnV
eoT00ol00008ojKAm`03o`000?nVdOOo000000KoZ=7e0ol0000Pooooo`03o`000?oooooooooo00[o
oooo000Kooooo`03onk^k_lQ8B7oV9RH00Oooooo0ol0000Dooooo`?o0000>?ooool00ol0003oPJc`
oh6/l008oh6/l003o`000?mdYO3oM:G`00SoM:G`00?o0000of:Ik_mRVNh01OmRVNh5o`0000KoKi7S
00?o0000ofR3f_mXPmX01omXPmX00ol0003oJGK=ofUfc@07ofUfc@03o`000?miK[[oNFjj00GoNFjj
1?l00002oj20/@Oo00000onAKjP00ol0003oYWbUojIlY@0<ojIlY@03o`000?nDK:;oU6bR00coU6bR
00?o0000oh=PXOn3H:402On3H:400ol0003oVgBVoi]dYP0=oi]dYP03o`000?nWOZKoYgjV00WoYgjV
00?o0000on2l/ooP_;<01OoP_;<00ol0003ob:>bolRS/P07olRS/P03o`000?oZbkKoj/^f00Soj/^f
00?o0000oo3cX?o`lj001?o`lj001?l0003oWm=/o`000?l00006og[Mn@Co00001?n?fOl00ol0003o
UmgnoiOMoP09oiOMoP?o00000onLeO`00ol0003oXMOjoj7GnP0;oj7GnPCo00002onVdOL01?l0003o
Y]7gojKAmol00002ojSAm@?o00008oooool00ol0003oooooooooo`0:ooooo`007?ooool00oo^k^ko
<S8bolc<c006ooooo`03o`000?oooooooooo01;ooooo0_l0000looooo`03o`000?n1[?3oPJc`00So
PJc`00?o0000ogBUl?mdYO002?mdYO000ol0003oHYW^of:IkP06of:IkP03o`000?m6Q^SoAXKX00Co
00000om_TN<00ol0003oJ8?JofR3fP06ofR3fP03o`000?mYM/goJGK=00OoJGK=00?o0000ogU^^_mi
K[X02?miK[X3o`0000[oTFnX00?o0000ojIlYOnVO:D03?nVO:D00ol0003oU6bRoiA/XP0<oiA/XP03
o`000?n3H:7oPf2Q00[oPf2Q00?o0000oi]dY_nKM:H03?nKM:H00ol0003oYgjVojMnYP09ojMnYP03
o`000?oP_;?oh;bc00Goh;bc00?o0000olRS/_o8Xk801_o8Xk800ol0003oj/^fon[;]P08on[;]P03
o`000?o`lj3ol?>P00Col?>P00?o0000oioCK?l000001?mjgOT4o`0000WoSmWo0_l00006oiOMoP?o
00001onLeO`00ol0003oXMOjoj7GnP05oj7GnPGo00001?nRdOP00ol0003oY]7gojKAm`09ojKAm`Go
00009_ooool00ol0003oooooooooo`0:ooooo`007Oooool00oo^k^koA4A4ooooo`05ooooo`03o`00
0?oooooooooo00oooooo0ol0000oooooo`03o`000?n1[?3oPJc`00SoPJc`00?o0000ogBUl?mdYO00
2?mdYO000ol0003oHYW^of:IkP06of:IkP03o`000?m6Q^SoAXKX00?oAXKX1?l00009ofR3fP03o`00
0?mYM/goJGK=00KoJGK=00?o0000ogU^^_miK[X02?miK[X00ol0003oTFnXoi5_Z00:oi5_Z003o`00
0?nVO:GoYWbU00coYWbU00?o0000oiA/X_nDK:803?nDK:800ol0003oPf2Qoh=PX@0:oh=PX@03o`00
0?nKM:KoVgBV00coVgBV00?o0000ojMnY_nWOZH02?nWOZH00ol0003oh;bcon2l/`07on2l/`03o`00
0?o8Xk;ob:>b00Gob:>b00?o0000on[;]_oZbkH02?oZbkH00ol0003ol?>Poo3cX003oo3cX004o`00
0?nOdfco0000og7Fn`Co00003on?fOl00ol0003oUmgnoiOMoP03o`0000_oW=Gl00?o0000oj7Gn_nQ
eoX01?l0000:oj;An003o`000?nVdOOoY]7g00GoY]7g1Ol0000Yooooo`03o`000?oooooooooo00[o
oooo000Jooooo`05okZj^_oooooooooooooooolb<S801_ooool00ol0003oooooooooo`0<ooooo`?o
0000@oooool00ol0003oPJc`oh6/l008oh6/l003o`000?mdYO3oM:G`00SoM:G`00?o0000of:Ik_mR
VNh01_mRVNh00ol0003oAXKXodJ6j005odJ6j0?o00001omXPmX00ol0003oJGK=ofUfc@07ofUfc@03
o`000?miK[[oNFjj00OoNFjj00?o0000oi5_Z?nAKjP02onAKjP00ol0003oYWbUojIlY@0;ojIlY@03
o`000?nDK:;oU6bR00coU6bR00?o0000oh=PXOn3H:402_n3H:400ol0003oVgBVoi]dYP0<oi]dYP03
o`000?nWOZKoYgjV00SoYgjV00?o0000on2l/ooP_;<01ooP_;<00ol0003ob:>bolRS/P04olRS/P03
o`000?oZbkKoj/^f00Soj/^f00?o0000oo3cX?o`lj001?o`lj04o`0000CoSMGo0_l0000;ohoIo`Go
00003OnLeO`4o`0000ooX]7h00?o0000ojKAmonVdOL01?l00004ooooo`03o`000?oooooooooo02Oo
oooo00?o0000ooooooooool02_ooool001Wooooo00Koc<c<o`000?n7QhOooooookZj^_lQ8B46oooo
o`03o`000?oooooooooo00Wooooo0ol00017ooooo`03o`000?n1[?3oPJc`00SoPJc`00?o0000ogBU
l?mdYO002?mdYO000ol0003oHYW^of:IkP06of:IkP03o`000?m6Q^SoAXKX00GoAXKX00Co0000oamU
fOl0003o00001OmXPmX00ol0003oJGK=ofUfc@07ofUfc@03o`000?miK[[oNFjj00OoNFjj00?o0000
oi5_Z?nAKjP02onAKjP00ol0003oYWbUojIlY@0<ojIlY@03o`000?nDK:;oU6bR00_oU6bR00?o0000
oh=PXOn3H:402_n3H:400ol0003oVgBVoi]dYP0=oi]dYP03o`000?nWOZKoYgjV00KoYgjV00?o0000
on2l/ooP_;<02?oP_;<00ol0003ob:>bolRS/P04olRS/P03o`000?oZbkKoj/^f00Soj/^f00?o0000
oo3cX?o`lj000oo`lj02o`0000WoSMGo00Co0000ohoIoon?fOooSmWo1ol00005oiWBo0;o00001onL
eO`4o`0000?oWm3h00?o0000oj;An?nRdOP03?nRdOP4o`0000Wooooo00?o0000ooooooooool09ooo
ool00ol0003oooooooooo`09ooooo`006_ooool01OnYZJWo8B4Qo`000?l@413oc<c<00Gooooo0ol0
0007ooooo`?o0000BooooolBo`0000CoM:G`00?o0000of:Ik_mRVNh01_mRVNh00ol0003oAXKXodJ6
j005odJ6j004o`000?lOIMWo7fGIo`0000GoJ8?J00?o0000ofUfcOmYM/d01_mYM/d00ol0003oNFjj
ogU^^P08ogU^^P03o`000?nAKjSoTFnX00[oTFnX00?o0000ojIlYOnVO:D03?nVO:D00ol0003oU6bR
oiA/XP0;oiA/XP03o`000?n3H:7oPf2Q00[oPf2Q00?o0000oi]dY_nKM:H03OnKM:H00ol0003oYgjV
ojMnYP06ojMnYP03o`000?oP_;?oh;bc00Woh;bc00?o0000olRS/_o8Xk800_o8Xk800ol0003oj/^f
on[;]P08on[;]P03o`000?o`lj3ol?>P00?ol?>P0_l00009ohgEo`Go00003_nId_`00ol0003oW=Gl
oicEo004o`0000SoWm3h00?o0000oj;An?nRdOP02?nRdOP3o`0000kooooo00?o0000ooooooooool0
9_ooool00ol0003oooooooooo`09ooooo`009Oooool00ol0003oooooooooo`03ooooo`?o0000D?oo
ool00ol0003oNJkdogV^m008ogV^m003o`000?mWY_GoIjKe00;oIjKe2?l00005of:IkP03o`000?m6
Q^SoAXKX00KoAXKX00?o0000oamUfOlOIMT00_l00003ofR3fP03o`000?mYM/goJGK=00KoJGK=00?o
0000ogU^^_miK[X02?miK[X00ol0003oTFnXoi5_Z00:oi5_Z003o`000?nVO:GoYWbU00coYWbU00?o
0000oiA/X_nDK:803?nDK:800ol0003oPf2Qoh=PX@0:oh=PX@03o`000?nKM:KoVgBV00coVgBV00?o
0000ojMnY_nWOZH01OnWOZH00ol0003oh;bcon2l/`0:on2l/`03o`000?o8Xk;ob:>b00;ob:>b00?o
0000on[;]_oZbkH02?oZbkH00ol0003ol?>Poo3cX002oo3cX0;o00001_n=eOl4o`0000CoVM3k00?o
0000oiWBo?nId_`02onId_`4o`0000goWm3h00?o0000oj;An?nRdOP01?nRdOP3o`0001;ooooo00?o
0000ooooooooool09Oooool00ol0003oooooooooo`09ooooo`009?ooool01?l0003ooooooooooooo
ool3o`0005Cooooo00?o0000ogV^m?mi[_@02?mi[_@00ol0003oIjKeofNVm@07ofNVm@03o`000?m7
U_7o000000?o00000_mRVNh00ol0003oAXKXodJ6j006odJ6j004o`000?lOIMWo7fGIoamUf@;o0000
0_mXPmX00ol0003oJGK=ofUfc@06ofUfc@03o`000?miK[[oNFjj00OoNFjj00?o0000oi5_Z?nAKjP0
2_nAKjP00ol0003oYWbUojIlY@0<ojIlY@03o`000?nDK:;oU6bR00coU6bR00?o0000oh=PXOn3H:40
2_n3H:400ol0003oVgBVoi]dYP0<oi]dYP03o`000?nWOZKoYgjV00GoYgjV00?o0000on2l/ooP_;<0
2_oP_;<01Ol0003ob:>bolRS/_o8Xk;o000000[oj/^f00?o0000oo3cX?o`lj000oo`lj02o`0000;o
SMGo1?l00009oiW@n`;o00001onId_`4o`0000?oW/kh00?o0000oio@n?nOd?P03?nOd?P00ol0003o
X]7hoj;An003o`0001Gooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`09ooooo`00
9?ooool4o`0005Sooooo00?o0000ogV^m?mi[_@02?mi[_@00ol0003oIjKeofNVm@07ofNVm@03o`00
0?m7U_7oAiKa00;oAiKa1?l00007odJ6j003o`000?lOIMWo7fGI00?o7fGI00?o0000ofR3f_l00000
2?mYM/d00ol0003oNFjjogU^^P07ogU^^P03o`000?nAKjSoTFnX00_oTFnX00?o0000ojIlYOnVO:D0
2onVO:D00ol0003oU6bRoiA/XP0<oiA/XP03o`000?n3H:7oPf2Q00[oPf2Q00?o0000oi]dY_nKM:H0
3?nKM:H00ol0003oYgjVojMnYP04ojMnYP03o`000?oP_;?oh;bc00coh;bc00Co0000olRS/_o8Xk;o
00002_oZbkH00ol0003ol?>Poo3cX002oo3cX0Go00003onId?/00ol0003oVM;loiWBo004o`0000So
W/kh00?o0000oio@n?nOd?P02_nOd?P4o`0001Wooooo00?o0000ooooooooool09?ooool00ol0003o
ooooooooo`09ooooo`009?ooool2o`0005_ooooo00?o0000ogV^m?mi[_@02?mi[_@00ol0003oIjKe
ofNVm@07ofNVm@03o`000?m7U_7oAiKa00CoAiKa0ol00006odJ6j003o`000?lOIMWo7fGI00?o7fGI
0_l00008ofUfc@03o`000?miK[[oNFjj00OoNFjj00?o0000oi5_Z?nAKjP02onAKjP00ol0003oYWbU
ojIlY@0;ojIlY@03o`000?nDK:;oU6bR00coU6bR00?o0000oh=PXOn3H:402_n3H:400ol0003oVgBV
oi]dYP0<oi]dYP03o`000?nWOZKoYgjV00CoYgjV00?o0000on2l/ooP_;<03?oP_;<00ol0003ob:>b
o`00000:on[;]P03o`000?o`lj3ol?>P00;ol?>P0_l00004oik@n@03o`000?nId?_oVM3k00_oVM3k
1?l0000=oik>n003o`000?nOd?SoWm3h00GoWm3h1?l0000Nooooo`03o`000?oooooooooo02?ooooo
00?o0000ooooooooool02Oooool002Kooooo00?o0000ooooooooool0FOooool00ol0003oNJkdogV^
m008ogV^m003o`000?mWY_GoIjKe00OoIjKe00?o0000odNFlOm7U_401_m7U_43o`0000CoAXKX00?o
0000oamUfOlOIMT01?lOIMT2o`0000OoJGK=00?o0000ogU^^_miK[X01omiK[X00ol0003oTFnXoi5_
Z00:oi5_Z003o`000?nVO:GoYWbU00_oYWbU00?o0000oiA/X_nDK:803?nDK:800ol0003oPf2Qoh=P
X@0:oh=PX@03o`000?nKM:KoVgBV00goVgBV00?o0000ojMnY_nWOZH00_nWOZH00ol0003oh;bcon2l
/`0=on2l/`03o`000?o8Xk;o000000[oj/^f00?o0000oo3cX?o`lj000_o`lj000ol0003oW]3ioik@
n@04oik@n@;o00001onId?/4o`0000?oWlcg00?o0000oik>n?nNc_P03?nNc_P00ol0003oWm3hoio@
n004o`0002?ooooo00?o0000ooooooooool08_ooool00ol0003oooooooooo`09ooooo`009oooool0
0ol0003oooooooooo`1Iooooo`03o`000?mi[_CoNJkd00SoNJkd00?o0000ofNVmOmWY_D01omWY_D0
0ol0003oAiKaodNFl@06odNFl@04o`000?l=L^3o0000o`0000;oAXKX00?o0000oamUfOlOIMT01?lO
IMT00ol0003o03Zno`000006ofUfc@03o`000?miK[[oNFjj00OoNFjj00?o0000oi5_Z?nAKjP02_nA
KjP00ol0003oYWbUojIlY@0<ojIlY@03o`000?nDK:;oU6bR00_oU6bR00?o0000oh=PXOn3H:402_n3
H:400ol0003oVgBVoi]dYP0=oi]dYP05o`000?nWOZKoYgjVojMnY_l000004OoP_;<00ol0003oj/^f
on[;]P08on[;]P03o`000?o`lj3ol?>P00;ol?>P00?o0000oik@nOnNd?T01onNd?T00ol0003oVM3k
oiW@n`04o`0000SoWlcg00?o0000oik>n?nNc_P02_nNc_P4o`0002Oooooo00?o0000ooooooooool0
8_ooool00ol0003oooooooooo`09ooooo`00:?ooool00ol0003oooooooooo`1Ioooooa;o00000omW
Y_D00ol0003oAiKaodNFl@06odNFl@03o`000?l=L^3o3G;P00;o000000?oAXKXo`000?lOIMT01OlO
IMT00ol0003o03Zno`000005ofUfc@03o`000?miK[[oNFjj00OoNFjj00?o0000oi5_Z?nAKjP02_nA
KjP00ol0003oYWbUojIlY@0<ojIlY@03o`000?nDK:;oU6bR00_oU6bR00?o0000oh=PXOn3H:402on3
H:400ol0003oVgBVoi]dYP0<oi]dYP05o`000?nWOZKoYgjVojMnY_l000004OoP_;<00ol0003oj/^f
on[;]P08on[;]P04o`000?o`lj3ol?>Poo3cX0;o00002OnNd?T3o`0000goWlcg00?o0000oik>n?nN
c_P01OnNc_P4o`0002cooooo00?o0000ooooooooool08_ooool00ol0003oooooooooo`08ooooo`00
:Oooool2o`0005_ooooo00?o0000ogFbn?me/_P02?me/_P00ol0003oGZWhoejYn002oejYn0Oo0000
1_m7U_401?l0003o3G;Po`ebh?l=L^03o`0000Go7fGI00Co0000o`0j__l0>[ko00001OmYM/d00ol0
003oNFjjogU^^P06ogU^^P03o`000?nAKjSoTFnX00[oTFnX00?o0000ojIlYOnVO:D03?nVO:D00ol0
003oU6bRoiA/XP0<oiA/XP03o`000?n3H:7oPf2Q00[oPf2Q00?o0000oi]dY_nKM:H03?nKM:H01?l0
003oYgjVojMnY_l0000Aon2l/`03o`000?oOcLOo000000Soj/^f00?o0000oo3cX?o`lj000_o`lj00
0ol0003oW]3ioik@n@05oik@n@?o00000_nRc?H00ol0003oWlcgoio<m`0<oio<m`03o`000?nNc_So
W/kh00Co0000<Oooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo00Sooooo000[oooo
o`03o`000?oooooooooo05Wooooo00?o0000ogFbn?me/_P02?me/_P00ol0003oGZWhoejYn007oejY
n0Go00000om7U_400ol0003o3G;Po`ebh003o`ebh0;o00001?lOIMT01?l0003o03Zno`0j__l00004
ofUfc@03o`000?miK[[oNFjj00KoNFjj00?o0000oi5_Z?nAKjP02onAKjP00ol0003oYWbUojIlY@0;
ojIlY@03o`000?nDK:;oU6bR00coU6bR00?o0000oh=PXOn3H:402_n3H:400ol0003oVgBVoi]dYP0<
oi]dYP04o`000?nWOZKoYgjVo`00013oh;bc00Go0000omo=aooOcLOoglg7o`000007on[;]P05o`00
0?o`lj3ol?>Poo3cX?l000001OnNd?T3o`0000KoX/cf00?o0000oio<monOc?L02_nOc?L4o`0003Go
oooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`08ooooo`00;?ooool00ol0003ooooo
ooooo`1Iooooo`;o00002Ome/_P2o`0000SoGZWh00Co0000oc>FlOlcU_7o<iKa1Ol00005o`ebh0;o
00000olOIMT01Ol0003o03Zno`0j__l0>[ko000000?oJGK=00?o0000ogU^^_miK[X01omiK[X00ol0
003oTFnXoi5_Z00:oi5_Z003o`000?nVO:GoYWbU00_oYWbU00?o0000oiA/X_nDK:803?nDK:800ol0
003oPf2Qoh=PX@0:oh=PX@03o`000?nKM:KoVgBV00goVgBV0_l0000@on2l/`03o`000?oOcLOoglg7
00?oglg700?o0000on[;]_oZbkH00ooZbkH00ol0003ol?>Poo3cX003o`0000;oW]3i0ol0000:oj;<
mP03o`000?nOc?OoWlcg00GoWlcg1?l0000jooooo`03o`000?oooooooooo023ooooo00?o0000oooo
ooooool02?ooool002gooooo00?o0000ooooooooool0F_ooool00ol0003oMK;hogFbn008ogFbn003
o`000?mNZOSoGZWh00KoGZWh0_l00005oc>Fl@?o00001?l=L^02o`0000?o7fGI00Go0000o`0j__l0
>[ko03Zno`000002ofUfc@03o`000?miK[[oNFjj00OoNFjj00?o0000oi5_Z?nAKjP02_nAKjP00ol0
003oYWbUojIlY@0;ojIlY@03o`000?nDK:;oU6bR00coU6bR00?o0000oh=PXOn3H:402_n3H:400ol0
003oVgBVoi]dYP0=oi]dYP;o00003ooP_;<00ol0003oglg7omo=a`05omo=a`03o`000?oZbkKoj/^f
00;oj/^f00Co0000oo3cX?l0003oj>C<1?l0000>oj;<mP03o`000?nOc?OoWlcg00Co0000?oooool0
0ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00Sooooo000^ooooo`;o0000Foooool00ol0
003oMK;hogFbn008ogFbn003o`000?mNZOSoGZWh00OoGZWh00?o0000oc>FlOlcU_401OlcU_42o`00
00?o3G;P0_l00003oamUf@05o`000?l0>[ko03Zno`0j__l000000_mYM/d00ol0003oNFjjogU^^P06
ogU^^P03o`000?nAKjSoTFnX00[oTFnX00?o0000ojIlYOnVO:D02onVO:D00ol0003oU6bRoiA/XP0<
oiA/XP03o`000?n3H:7oPf2Q00[oPf2Q00?o0000oi]dY_nKM:H03?nKM:H2o`00013oh;bc00?o0000
omo=aooOcLL01_oOcLL00ol0003oj/^fon[;]P03o`000003onSTc?l0003oYlkd00?oYlkd00?o0000
oj;<m_nRc?H02_nRc?H4o`0004Cooooo00?o0000ooooooooool07_ooool00ol0003oooooooooo`08
ooooo`00<?ooool00ol0003oooooooooo`1Ioooooa;o00000omNZOP00ol0003o<iKaoc>Fl@05oc>F
l@Co000000Ko3G;Po`000?l0003o0000oamUfOl00004o`0j_P03o`000?mYM/go000000SoNFjj00?o
0000oi5_Z?nAKjP02_nAKjP00ol0003oYWbUojIlY@0<ojIlY@03o`000?nDK:;oU6bR00_oU6bR00?o
0000oh=PXOn3H:402on3H:400ol0003oVgBVoi]dYP09oi]dYP;o000000?o`<_Ro`000?oP_;<03_oP
_;<00ol0003oglg7omo=a`08omo=a`03o`000?oZbkKo000000?oj>C<00?o0000ojO>m?nWc_@00onW
c_@00ol0003oX/cfoj;<mP05oj;<mPCo0000B?ooool00ol0003oooooooooo`0Nooooo`03o`000?oo
oooooooo00Sooooo000aooooo`03o`000?oooooooooo05[ooooo00?o0000ogFgn_me]oX02?me]oX0
0ol0003oG[3koej`n`02oej`n`So00001OlcU_400ol0003o06C<o`000002o`000004o`0XYOl0003o
7fGIo`0000Co03Zn0_l00008ogU^^P03o`000?nAKjSoTFnX00_oTFnX00?o0000ojIlYOnVO:D02onV
O:D00ol0003oU6bRoiA/XP0;oiA/XP03o`000?n3H:7oPf2Q00_oPf2Q00?o0000oi]dY_nKM:H02?nK
M:H00ol0003o`<_Rol3;hP02ol3;hP03o`000?oP_;?oh;bc00_oh;bc00?o0000omo=aooOcLL02_oO
cLL01Ol0003oj>C<onSTc?oXi<co000000OoYlkd00?o0000oj;<m_nRc?H01?l0001=ooooo`03o`00
0?oooooooooo01kooooo00?o0000ooooooooool01oooool003;ooooo00?o0000ooooooooool0F_oo
ool00ol0003oMKOjogFgnP08ogFgnP;o00002?mN/?/7o`000004oc>FlOl0003o06C<o`1Tc0;o0000
00?o02RUo`000?l000001Ol0>[h2o`0000SoNFjj00?o0000oi5_Z?nAKjP02_nAKjP00ol0003oYWbU
ojIlY@0;ojIlY@03o`000?nDK:;oU6bR00coU6bR00?o0000oh=PXOn3H:402_n3H:400ol0003oVgBV
oi]dYP06oi]dYP;o00001Oo0bn800ol0003oh;bcon2l/`0:on2l/`03o`000?oOcLOoglg700_oglg7
00Go0000onSTc?oXi<coj>C<o`000007ojO>m0?o0000D_ooool00ol0003oooooooooo`0Mooooo`03
o`000?oooooooooo00Oooooo000cooooo`03o`000?oooooooooo05[ooooo00?o0000ogFgn_me]oX0
2Ome]oX00ol0003oG[3koej`n`07oej`n`03o`000?lbW_;o<Ykb00;o<Ykb1Ol000000ol0I<co0000
o`000002o`0000Go03Zn00?o0000ogU^^_miK[X01_miK[X00ol0003oTFnXoi5_Z00:oi5_Z003o`00
0?nVO:GoYWbU00_oYWbU00?o0000oiA/X_nDK:803?nDK:800ol0003oPf2Qoh=PX@0:oh=PX@03o`00
0?nKM:KoVgBV00CoVgBV0_l00008ol3;hP03o`000?oP_;?oh;bc00Woh;bc00?o0000omo=aooOcLL0
2_oOcLL01Ol0003oj>C<onSTc?oXi<co000000GoYlkd0ol0001Fooooo`03o`000?oooooooooo01co
oooo00?o0000ooooooooool01oooool003Cooooo0_l0001Kooooo`03o`000?me]o[oMKOj00WoMKOj
00?o0000oej`nomN/?/01omN/?/2o`0000Ko<Ykb1_l00005o`0j_P03o`000?miK[[oNFjj00KoNFjj
00?o0000oi5_Z?nAKjP02_nAKjP00ol0003oYWbUojIlY@0;ojIlY@03o`000?nDK:;oU6bR00coU6bR
00?o0000oh=PXOn3H:402_n3H:400ol0003oVgBVoi]dYP02oi]dYP;o00002oo0bn800ol0003oh;bc
on2l/`07on2l/`03o`000?oOcLOoglg700[oglg700?o0000onSTc?oXi<`00_oXi<`00ol0003oYlkd
ojO>m003o`0005Wooooo00?o0000ooooooooool07?ooool00ol0003oooooooooo`07ooooo`00=_oo
ool00ol0003oooooooooo`1Iooooo`03o`000?me]o[oMKOj00CoMKOj5ol00002oc:NlPCo00001Ol0
>[h00ol0003oNFjjogU^^P05ogU^^P03o`000?nAKjSoTFnX00[oTFnX00?o0000ojIlYOnVO:D02onV
O:D00ol0003oU6bRoiA/XP0<oiA/XP03o`000?n3H:7oPf2Q00_oPf2Q00Co0000oi]dY_nKM:Ko0000
3Oo0bn800ol0003oh;bcon2l/`06on2l/`03o`000?oOcLOoglg700[oglg700?o0000onSTc?oXi<`0
0_oXi<`4o`0005gooooo00?o0000ooooooooool06oooool00ol0003oooooooooo`07ooooo`00=ooo
ool00ol0003oooooooooo`1Iooooo`Ko00001omj_?`00ol0003oI[WmofJio@08ofJio@;o00000om4
[oL6o`0000Go03Zn0_l00006ogU^^P03o`000?nAKjSoTFnX00_oTFnX00?o0000ojIlYOnVO:D02onV
O:D00ol0003oU6bRoiA/XP0;oiA/XP03o`000?n3H:7oPf2Q00_oPf2Q0ol0000?ol3;hP03o`000?oP
_;?oh;bc00Coh;bc00?o0000omo=aooOcLL02_oOcLL00ol0003oj>C<onSTc003onSTc003o`000?oo
oooooooo05oooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`07ooooo`00>?ooool0
0ol0003oooooooooo`1Jooooo`03o`000?mj_?coN[cl00WoN[cl0_l0000:ofJio@03o`000?m4[oOo
A:og00KoA:og00?o0000o`0j__l0>[h00_l0>[h00ol0003o01ZTo`000006ogU^^P03o`000?nAKjSo
TFnX00[oTFnX00?o0000ojIlYOnVO:D02onVO:D00ol0003oU6bRoiA/XP0;oiA/XP03o`000?n3H:7o
Pf2Q00WoPf2Q0ol0000Aol3;hP03o`000?oP_;?oh;bc00?oh;bc00?o0000omo=aooOcLL02_oOcLL0
0ol0003oj>C<onSTc003onSTc003o`000?oooooooooo067ooooo00?o0000ooooooooool06Oooool0
0ol0003oooooooooo`07ooooo`00>Oooool2o`0005_ooooo0_l0000;ogZlo003o`000?mV^OgoI[Wm
00SoI[Wm0_l00007odB_m`03o`000?l0>[ko03Zn00;o03Zn0_l00006ogU^^P03o`000?nAKjSoTFnX
00[oTFnX00?o0000ojIlYOnVO:D02onVO:D00ol0003oU6bRoiA/XP0;oiA/XP03o`000?n3H:7oPf2Q
00KoPf2Q0ol00003ojG3k`03o`000?o0bn;o`<_R00oo`<_R00?o0000on2l/ooP_;<00_oP_;<00ol0
003oglg7omo=a`0:omo=a`03o`000?oXi<coj>C<00?oj>C<00?o0000ooooooooool0HOooool00ol0
003oooooooooo`0Jooooo`03o`000?oooooooooo00Kooooo000kooooo`03o`000?oooooooooo05[o
oooo00?o0000ogZlo?mj_?`02Omj_?`00ol0003oI[WmofJio@04ofJio@go00001?l0>[h00ol0003o
01ZTo`000005ogU^^P03o`000?nAKjSoTFnX00[oTFnX00?o0000ojIlYOnVO:D02onVO:D00ol0003o
U6bRoiA/XP0<oiA/XP03o`000?n3H:7oPf2Q00;oPf2Q0ol00007ojG3k`03o`000?o0bn;o`<_R00oo
`<_R00Co0000on2l/ooP_;?o00003?oOcLL00ol0003oj>C<onSTc003onSTc003o`000?oooooooooo
06?ooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`06ooooo`00??ooool00ol0003o
ooooooooo`1Jooooo`03o`000?mj_?coN[cl00CoN[cl2ol00007ogC2oP;o00001?mO_od01Ol0003o
03Zno`0j__l0>[ko000000;o01ZT00?o0000ogU^^_miK[X00_miK[X00ol0003oTFnXoi5_Z00:oi5_
Z003o`000?nVO:GoYWbU00_oYWbU00?o0000oiA/X_nDK:803?nDK:800ol0003oPf2Qo`000002o`00
00_oYL?_00?o0000ol3;h_o0bn803_o0bn800ol0003oh;bco`00000<omo=a`03o`000?oXi<coj>C<
00?oj>C<00?o0000ooooooooool0IOooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo
00Kooooo000mooooo`03o`000?oooooooooo05[ooooo1_l00007oh72o0;o00002omd`_h00ol0003o
Gkomoenoo@02oenoo@05o`000?l0>[ko03Zno`0j__l000000_l06Z@01Ol0003oNFjjogU^^_miK[[o
000000coTFnX00?o0000ojIlYOnVO:D02onVO:D00ol0003oU6bRoiA/XP0:oiA/XPCo00003onU`nl0
0ol0003o`<_Rol3;hP0<ol3;hP?o00003?oOcLL00ol0003oj>C<onSTc004onSTc003o`000?oooooo
oooo06Gooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`06ooooo`00?_ooool2o`00
05cooooo00?o0000oh72o?n1`_`02_n1`_`00ol0003oM<;nogC2oP09ogC2oP;o00000omO_od01?l0
003o03Zno`0j__l00002o`0JY003o`000?miK[[oNFjj00;oNFjj00?o0000oi5_Z?nAKjP02_nAKjP0
0ol0003oYWbUojIlY@0:ojIlY@03o`000?nDK:;oU6bR00OoU6bR0ol00002ojG3k`03o`000?nU`noo
YL?_00ooYL?_00?o0000ol3;h_o0bn802?o0bn83o`0000?oYL?_00?o0000omo=aooOcLL02?oOcLL0
0ol0003oj>C<onSTc004onSTc003o`000?oooooooooo06Oooooo00?o0000ooooooooool05oooool0
0ol0003oooooooooo`06ooooo`00@?ooool00ol0003oooooooooo`1Jooooo`;o00002on1`_`2o`00
00KoM<;n2Ol00003o`0j_P04o`000?l06ZCo01ZTo`0000?oNFjj00?o0000oi5_Z?nAKjP02_nAKjP0
0ol0003oYWbUojIlY@0;ojIlY@03o`000?nDK:;oU6bR00;oU6bR1?l00006ojG3k`03o`000?nU`noo
YL?_00ooYL?_00?o0000ol3;h_o0bn801?o0bn83o`0000OoYL?_00?o0000omo=aooOcLL01ooOcLL0
0ol0003oj>C<onSTc004onSTc003o`000?oooooooooo06Sooooo00?o0000ooooooooool05_ooool0
0ol0003oooooooooo`06ooooo`00@Oooool00ol0003oooooooooo`1Kooooo`03o`000?n1`_coPL;l
00OoPL;l2Ol00007oh?8oP?o00000_l0>[h01Ol0003o01ZTo`0JY?l06ZCo000000;oNFjj00?o0000
oi5_Z?nAKjP02_nAKjP00ol0003oYWbUojIlY@0;ojIlY@03o`000?nDK:;o000000;o00002onU`nl0
0ol0003oYL?_ojG3k`0?ojG3k`03o`000?o0bn;o`<_R00?o00002onU`nl00ol0003oglg7omo=a`05
omo=a`03o`000?oXi<coj>C<00Coj>C<00?o0000ooooooooool0J_ooool00ol0003oooooooooo`0E
ooooo`03o`000?oooooooooo00Kooooo0012ooooo`03o`000?oooooooooo05_ooooo00Co0000oh72
o?n1`_coPL;l1Ol00005oh[6o0;o00003?n3b?h00ol0003o03Zno`000004o`0JY003o`000?miK[[o
000000coTFnX00?o0000ojIlYOnVO:D02OnVO:D4o`0000ooYL?_00?o0000ojG3konU`nl03OnU`nl4
o`0000ooYL?_00?o0000omo=aooOcLL00ooOcLL00ol0003oj>C<onSTc005onSTc003o`000?oooooo
oooo06[ooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`06ooooo`00@oooool2o`00
05cooooo0ol0000<oh[6o003o`000?n3b?koPlSn00SoPlSn0_l00002o`0j_P07o`000?l06ZCo01ZT
o`0JY?l0003oNFjjo`00000<oi5_Z003o`000?nVO:GoYWbU00KoYWbU0ol00003ojG3k`03o`000?nU
`nooYL?_00koYL?_00?o0000ojG3konU`nl02OnU`nl3o`0000?oYL?_00?o0000ojG3konU`nl03_nU
`nl01Ol0003oglg7omo=aooOcLOo000000Ooj>C<00?o0000ooooooooool0K?ooool00ol0003ooooo
ooooo`0Eooooo`03o`000?oooooooooo00Gooooo0015ooooo`03o`000?oooooooooo05_ooooo0_l0
000<oh[6o0;o00000on3b?h5o`0000;oSlcl00?o0000o`0j__l000001?l06Z@00ol0003oNFjjo`00
000<oi5_Z003o`000?nVO:GoYWbU00;oYWbU0ol00007ojG3k`03o`000?nU`nooYL?_00koYL?_00?o
0000ojG3konU`nl01?nU`nl4o`0000OoYL?_00?o0000ojG3konU`nl03_nU`nl00ol0003oglg7o`00
0008onSTc003o`000?oooooooooo06gooooo00?o0000ooooooooool05?ooool00ol0003ooooooooo
o`05ooooo`00A_ooool00ol0003oooooooooo`1Looooo`03o`000?n:a_coR/Kl00SoR/Kl1_l00008
oho<o0;o00001Ol06Z@2o`0000coTFnX00?o0000ojIlYOl000000_l0000;ojG3k`03o`000?nU`noo
YL?_00koYL?_00?o0000ojG3konU`nl00ol0000<ojG3k`03o`000?nU`nooYL?_00coYL?_1?l00007
onSTc003o`000?oooooooooo06oooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`05
ooooo`00Aoooool00ol0003oooooooooo`1Looooo`;o00000on:a_`5o`0000GoT/Wj0_l00008oho<
o0;o00001Ol06Z@?o`0000ooYL?_00?o0000ojG3konU`nl03?nU`nl4o`00013oYL?_00?o0000ojG3
konU`nl02?nU`nl3o`0000CoYL?_0_l00005onSTc003o`000?oooooooooo06oooooo00?o0000oooo
ooooool04oooool00ol0003oooooooooo`05ooooo`00B?ooool2o`0005kooooo0ol0000<oi;9nP03
o`000?n?c?coSlcl00GoSlcl0_l00005o`0JY003o`000?n5W>;oQIcR00[oQIcR00?o0000ojG3konU
`nl03onU`nl00ol0003oYL?_ojG3k`08ojG3k`?o00000onU`nl00ol0003oYL?_ojG3k`0?ojG3k`03
o`000?nU`nooYL?_00CoYL?_0ol00009ojG3k`05o`000?oXi<coj>C<onSTc?l00000Loooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo00Gooooo001:ooooo`03o`000?oooooooooo05go
oooo0_l0000<oi;9nP;o00000on?c?`4o`0000Ko01ZT00?o0000ohFLh_n5W>802_n5W>800ol0003o
YL?_ojG3k`0?ojG3k`03o`000?nU`nooYL?_00CoYL?_0ol00007ojG3k`03o`000?nU`nooYL?_00oo
YL?_00?o0000ojG3konU`nl00ol0000=ojG3k`;o000000?oj>C<o`000?ooool0Loooool00ol0003o
ooooooooo`0Aooooo`03o`000?oooooooooo00Gooooo001;ooooo`03o`000?oooooooooo05kooooo
00?o0000oi;9n_nBbOX02?nBbOX6o`0000CoV<gj0_l00004o`0JY003o`000?n5W>;oQIcR00_oQIcR
00?o0000ojG3konU`nl03onU`nl00ol0003oYL?_ojG3k`03o`0000_oYL?_00?o0000ojG3konU`nl0
3OnU`nl4o`00017oYL?_0_l0001fooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0
1Oooool004cooooo00?o0000ooooooooool0G_ooool2o`0000?oT/Wj1Ol00005oiW:n0;o00001?nH
cOX2o`0000Co01ZT00?o0000ohFLh_n5W>802on5W>800ol0003oYL?_ojG3k`0=ojG3k`Co00003onU
`nl00ol0003oYL?_ojG3k`09ojG3k`?o00000_nU`nl00ol0003oYL?_ojG3k`0?ojG3k`03o`000?oo
oooooooo07Kooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`04ooooo`00COooool0
0ol0003oooooooooo`1Oooooo`?o00003?nIb_P00ol0003oV<gjoiS=nP02oiS=nP;o00001?l06Z@0
0ol0003oQIcRohFLhP0;ohFLhP03o`000?nU`nooYL?_00WoYL?_0ol00003ojG3k`03o`000?nU`noo
YL?_00koYL?_00?o0000ojG3konU`nl01?nU`nl4o`0000KoYL?_00?o0000ojG3konU`nl03?nU`nl2
o`0007[ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`04ooooo`00C_ooool2o`00
067ooooo00?o0000oiW:n?nIb_P02onIb_P2o`0000;oV<gj1?l00002o`0JY003o`000?n5W>;oQIcR
00coQIcR00?o0000ojG3konU`nl01?nU`nl4o`0000OoYL?_00?o0000ojG3konU`nl03_nU`nl00ol0
003oYL?_ojG3k`03o`0000_oYL?_00?o0000ojG3konU`nl02OnU`nl2o`0007gooooo00?o0000oooo
ooooool03oooool00ol0003oooooooooo`04ooooo`00D?ooool00ol0003oooooooooo`1Oooooo`;o
00002onIb_P4o`0000;oW/gh00?o0000o`0_Zol000000_l06Z@00ol0003oQIcRohFLhP0<ohFLhP03
o`000?nU`nooYL?_00?o00003?nU`nl00ol0003oYL?_ojG3k`0<ojG3k`Co00003onU`nl00ol0003o
YL?_ojG3k`07ojG3k`03o`000?oooooooooo07gooooo00?o0000ooooooooool03oooool00ol0003o
ooooooooo`04ooooo`00DOooool00ol0003oooooooooo`1Pooooo`03o`000?nIb_SoVL[h00CoVL[h
1?l00004oik:m`08o`000?nNcOSoW/gho`000?l0;j_o0000o`0JY?l0000=ohFLhPCo00004?nU`nl0
0ol0003oYL?_ojG3k`08ojG3k`?o00000onU`nl00ol0003oYL?_ojG3k`0>ojG3k`03o`000?nU`noo
YL?_00CoYL?_0_l00021ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool01?ooool0
05;ooooo00?o0000ooooooooool0H?ooool00ol0003oVL[hoiW:n003o`0000WoW/[g0_l000000onN
cOSo0000o`0_Z`03o`0000WoQIcR0ol00004ojG3k`03o`000?nU`nooYL?_00koYL?_00?o0000ojG3
konU`nl01?nU`nl3o`0000OoYL?_00?o0000ojG3konU`nl03_nU`nl01?l0003oYL?_ojG3konU`nl2
o`0008Cooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`04ooooo`00Doooool2o`00
067ooooo0_l0000>oik:m`05o`000?nNcOSo0000o`000?l0;j/00_l00005ohFLhP?o00002?nU`nl0
0ol0003oYL?_ojG3k`0>ojG3k`03o`000?nU`nooYL?_00?o00002onU`nl00ol0003oYL?_ojG3k`0>
ojG3k`03o`000?nU`noo000008Oooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`04
ooooo`00EOooool00ol0003oooooooooo`1Pooooo`;o00002onNb_L4o`000004oj?<mOl0003o02n[
o`0000;oQIcR0ol0000<ojG3k`03o`000?nU`nooYL?_00coYL?_1?l0000?ojG3k`03o`000?nU`noo
YL?_00coYL?_0ol00028ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool00oooool0
05Kooooo00?o0000ooooooooool0HOooool00ol0003oW/[goik:m`05oik:m`?o00001?nRb_@6o`00
013oYL?_00?o0000ojG3konU`nl02?nU`nl3o`0000?oYL?_00?o0000ojG3konU`nl03_nU`nl00ol0
003oYL?_ojG3k`06ojG3k`Go0000S?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo
00?ooooo001Gooooo`03o`000?oooooooooo067ooooo0_l00002oik:m`?o00002OnRb_@01Ol0003o
Xlceo`000?l0;j_o0000013oYL?_00?o0000ojG3konU`nl01?nU`nl3o`0000OoYL?_00?o0000ojG3
konU`nl03_nU`nl00ol0003oYL?_ojG3k`05o`0009;ooooo00?o0000ooooooooool02oooool00ol0
003oooooooooo`03ooooo`00F?ooool2o`0006?ooooo0_l0000=oj;:m0Go00004?nU`nl00ol0003o
YL?_ojG3k`03o`0000_oYL?_00?o0000ojG3konU`nl03?nU`nl4o`0009Sooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`03ooooo`00F_ooool00ol0003oooooooooo`1Rooooo`03o`00
0?nRb_CoX/[d00[oX/[d1_l0000>ojG3k`Co00003onU`nl00ol0003oYL?_ojG3k`08ojG3k`?o0000
W?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00?ooooo001Kooooo`03o`000?oo
oooooooo06;ooooo0_l00006oj;:m0Co00001Oooool2o`0000[oYL?_0ol00003oiKOoP03o`000?nU
`nooYL?_00koYL?_00?o0000ojG3konU`nl01?nU`nl3o`000:3ooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`03ooooo`00G?ooool00ol0003oooooooooo`1Sooooo`03o`000?nRb_Co
X/[d00?o00002_ooool2o`0000KoYL?_0ol00007oiKOoP03o`000?nU`nooYL?_00koYL?_00?o0000
ojG3konU`nl00ol0002Tooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00oooool0
05gooooo0_l0001Tooooo`;o00003oooool00ol0003oYL?_ojG3k`03o`0000_oU]on00?o0000ojG3
konU`nl03?nU`nl4o`000:Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`03oooo
o`00Goooool00ol0003oooooooooo`1Qooooo`03o`000?oooooooooo00oooooo0_l0000?oiKOoP03
o`000?nU`nooYL?_00SoYL?_0ol0002/ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool00_ooool0063ooooo00?o0000ooooooooool0H?ooool00ol0003oooooooooo`0Aooooo`?o0000
3OnFgoh00ol0003oYL?_ojG3k`04ojG3k`?o0000/?ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00;ooooo001Qooooo`03o`000?oooooooooo05oooooo00?o0000ooooooooool05?oo
ool2o`0000coU]on00?o0000ojG3konU`nl00ol0002dooooo`03o`000?oooooooooo00Kooooo00?o
0000ooooooooool00_ooool006;ooooo0_l0001Oooooo`03o`000?oooooooooo01Kooooo3ol0002g
ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool00_ooool006Cooooo00?o0000oooo
ooooool0G?ooool00ol0003oooooooooo`3Mooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool00_ooool006Gooooo00?o0000ooooooooool0Foooool00ol0003oooooooooo`3Nooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool006Kooooo00?o0000ooooooooool0
F_ooool00ol0003oooooooooo`3Oooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
0_ooool006Oooooo00?o0000ooooooooool0FOooool00ol0003oooooooooo`3Oooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool00Oooool006Sooooo0_l0001Iooooo`03o`000?oooooo
oooo0>3ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`01ooooo`00J_ooool00ol0
003oooooooooo`1Fooooo`03o`000?oooooooooo0>7ooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`01ooooo`00Joooool00ol0003oooooooooo`1Eooooo`03o`000?oooooooooo0>;o
oooo00Go0000ooooooooooooooooo`000003ooooo`00K?ooool00ol0003oooooooooo`1Cooooo`03
o`000?oooooooooo0>?ooooo00Go0000ooooooooooooooooo`000003ooooo`00KOooool2o`0005?o
oooo00?o0000ooooooooool0i?ooool01?l0003oooooooooool00003ooooo`00Koooool00ol0003o
ooooooooo`1@ooooo`03o`000?oooooooooo0>Gooooo00?o0000ooooool000000oooool0073ooooo
00?o0000ooooooooool0Coooool00ol0003oooooooooo`3Uooooo`04o`000?ooooooooooo`0000;o
oooo001aooooo`03o`000?oooooooooo04kooooo00?o0000ooooooooool0i_ooool00ol0003ooooo
o`000002ooooo`00L_ooool2o`0004kooooo00?o0000ooooooooool0ioooool2o`0000;ooooo001d
ooooo`03o`000?oooooooooo04_ooooo00?o0000ooooooooool0i_ooool3o`0000;ooooo001eoooo
o`03o`000?oooooooooo04[ooooo00?o0000ooooooooool0h_ooool4o`0000Gooooo001fooooo`03
o`000?oooooooooo04Wooooo00?o0000ooooooooool0g_ooool4o`0000Wooooo001gooooo`;o0000
BOooool00ol0003oooooooooo`3Kooooo`?o00003Oooool007Wooooo00?o0000ooooooooool0A_oo
ool00ol0003oooooooooo`3Gooooo`Co00004?ooool007[ooooo00?o0000ooooooooool0AOooool0
0ol0003oooooooooo`3Cooooo`Co00005?ooool007_ooooo00?o0000ooooooooool0A?ooool00ol0
003oooooooooo`3?ooooo`Co00006?ooool007cooooo0_l00014ooooo`03o`000?oooooooooo0<_o
oooo1?l0000Looooo`00O_ooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo0<Sooooo
0ol0000Pooooo`00Ooooool00ol0003oooooooooo`10ooooo`03o`000?oooooooooo0<Cooooo1?l0
000Sooooo`00P?ooool00ol0003oooooooooo`0oooooo`03o`000?oooooooooo0<3ooooo1?l0000W
ooooo`00POooool00ol0003oooooooooo`0nooooo`03o`000?oooooooooo0;cooooo1?l0000[oooo
o`00P_ooool2o`0003kooooo00?o0000ooooooooool0^?ooool4o`0002oooooo0024ooooo`03o`00
0?oooooooooo03_ooooo00?o0000ooooooooool0]?ooool4o`0003?ooooo0025ooooo`03o`000?oo
oooooooo03[ooooo00?o0000ooooooooool0/Oooool3o`0003Oooooo0026ooooo`03o`000?oooooo
oooo03Wooooo00?o0000ooooooooool0[Oooool4o`0003[ooooo0027ooooo`;o0000>Oooool00ol0
003oooooooooo`2Yooooo`Co0000?_ooool008Wooooo00?o0000ooooooooool0=_ooool00ol0003o
ooooooooo`2Uooooo`Co0000@_ooool008[ooooo00?o0000ooooooooool0=Oooool00ol0003ooooo
ooooo`2Qooooo`Co0000A_ooool008_ooooo00?o0000ooooooooool0=?ooool00ol0003ooooooooo
o`2Mooooo`Co0000B_ooool008cooooo0_l0000dooooo`03o`000?oooooooooo09[ooooo0ol0001>
ooooo`00S_ooool00ol0003oooooooooo`0`ooooo`03o`000?oooooooooo09Oooooo1?l0001Aoooo
o`00Soooool00ol0003oooooooooo`0_ooooo`03o`000?oooooooooo09?ooooo1?l0001Eooooo`00
T?ooool00ol0003oooooooooo`0^ooooo`03o`000?oooooooooo08oooooo1?l0001Iooooo`00TOoo
ool2o`0002kooooo00?o0000ooooooooool0Roooool4o`0005gooooo002Cooooo`03o`000?oooooo
oooo02_ooooo00?o0000ooooooooool0R?ooool3o`00067ooooo002Dooooo`03o`000?oooooooooo
02[ooooo00?o0000ooooooooool0Q?ooool4o`0006Cooooo002Eooooo`03o`000?oooooooooo02Wo
oooo00?o0000ooooooooool0P?ooool4o`0006Sooooo002Fooooo`;o0000:Oooool00ol0003ooooo
ooooo`1looooo`Co0000K?ooool009Sooooo00?o0000ooooooooool09_ooool00ol0003ooooooooo
o`1hooooo`Co0000L?ooool009Wooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`1d
ooooo`Co0000M?ooool009[ooooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`1aoooo
o`?o0000N?ooool009_ooooo00?o0000ooooooooool08oooool00ol0003oooooooooo`1]ooooo`Co
0000Noooool009cooooo0_l0000Sooooo`03o`000?oooooooooo06Wooooo1?l0001oooooo`00W_oo
ool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo06Gooooo1?l00023ooooo`00Woooool0
0ol0003oooooooooo`0Oooooo`03o`000?oooooooooo067ooooo1?l00027ooooo`00X?ooool00ol0
003oooooooooo`0Nooooo`03o`000?oooooooooo05gooooo1?l0002;ooooo`00XOooool2o`0001ko
oooo00?o0000ooooooooool0F_ooool3o`0008oooooo002Sooooo`03o`000?oooooooooo01_ooooo
00?o0000ooooooooool0E_ooool4o`0009;ooooo002Tooooo`03o`000?oooooooooo01[ooooo00?o
0000ooooooooool0D_ooool4o`0009Kooooo002Uooooo`03o`000?oooooooooo01Wooooo00?o0000
ooooooooool0C_ooool4o`0009[ooooo002Vooooo`;o00006Oooool00ol0003oooooooooo`1:oooo
o`Co0000W_ooool00:Sooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`17ooooo`?o
0000X_ooool00:Wooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`13ooooo`Co0000
YOooool00:[ooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0oooooo`Co0000ZOoo
ool00:_ooooo0_l0000Dooooo`03o`000?oooooooooo03_ooooo1?l0002]ooooo`00[Oooool00ol0
003oooooooooo`0Aooooo`03o`000?oooooooooo03Oooooo1?l0002aooooo`00[_ooool00ol0003o
ooooooooo`0@ooooo`03o`000?oooooooooo03?ooooo1?l0002eooooo`00[oooool00ol0003ooooo
ooooo`0?ooooo`03o`000?oooooooooo033ooooo0ol0002iooooo`00/?ooool2o`0000kooooo00?o
0000ooooooooool0;Oooool4o`000;cooooo002booooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool0:Oooool4o`000<3ooooo002cooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool09Oooool4o`000<Cooooo002dooooo`03o`000?oooooooooo00Wooooo00?o0000oooooooo
ool08Oooool4o`000<Sooooo002eooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
7Oooool4o`000<cooooo002fooooo`;o00002?ooool00ol0003oooooooooo`0Jooooo`?o0000d?oo
ool00;Sooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Fooooo`Co0000doooool0
0;Wooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Booooo`Co0000eoooool00;[o
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0>ooooo`Co0000foooool00;_ooooo
0_l00003ooooo`03o`000?oooooooooo00[ooooo1?l0003Oooooo`00_Oooool01?l0003ooooooooo
ool00009ooooo`?o0000hoooool00;kooooo00?o0000ooooool000001Oooool4o`000>Kooooo002o
ooooo`;o000000?oooooo`000?l000000_l0003Zooooo`00`?ooool2o`000>kooooo003ooooook7o
oooo003ooooook7ooooo003ooooook7ooooo003ooooook7ooooo003ooooook7ooooo003ooooook7o
oooo0000\
\>"],
  ImageRangeCache->{{{73.4375, 302.812}, {527.75, 341.938}} -> {-0.423256, \
1.56475, 0.00364714, 0.00364714}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
  "This 3D plot was not displayed in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 12.0. (It was calculated here as an exploration, and is not part of the \
original article)."
}], "Text",
  CellFrame->True,
  ExpressionUUID -> "7f54a880-0913-48f4-83cf-005bad9924bf",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[0.833326]],

Cell[CellGroupData[{

Cell["\<\
Define matrix flatteners to set up the linear hydrodynamics \
equations:\
\>", "Subsubsection",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "5e8b84ab-d81c-46c5-84b4-01fb4b61d7b5"],

Cell["\<\
flatmat[M_]:= Module[{Mt,Mf},
\tMt=Transpose[M,{1,3,2,4}];
\tMf=Table[Flatten[Mt[[i,j]]],{i,Length[Mt]},{j,Length[Mt[[1]]]}];
\tN[Flatten[Mf,1]]
];\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "ac8541a0-926b-4b11-9f9e-aeeeb2083c4d"],

Cell["flatvec[x_]:=Flatten[x,1];", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "ee083062-60c5-4dfd-b1cd-2663ccf65525"],

Cell["\<\
complete[M_,geo_]:=Module[{base,n,npoints,Mc},
\t(*\tUgly but necessary, since the additional equations required
\t\tto solve the tableau destroy the \"tensorness\" of the matrix
\t\tof matrices. *)
\tdim=Length[M];
\tn=dim/3-1;
\tMc=Table[0,{dim+1},{dim+1}];
\tDo[\tMc[[i,j]]=M[[i,j]],{i,dim},{j,dim}];
\tDo[\tbase=(i-1)*3;
\t\tMc[[base+1,dim+1]]=Evaluate[u[i,geo]][[1]];
\t\tMc[[base+2,dim+1]]=Evaluate[u[i,geo]][[2]];
\t\tMc[[base+3,dim+1]]=Evaluate[u[i,geo]][[3]],
\t{i,n}];
\tbottom=Flatten[Table[z[i,geo],{i,n}]];
\tDo[ Mc[[dim+1,j]]=bottom[[j]],{j,3*n}];
\tReturn[Mc]
];\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "0ef32b1d-1efb-45bc-a8e8-f3fafbdc8c58"],

Cell["Show tensor->matrix flattening in action:", "Text",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "66a8535f-39c9-4240-9196-1cbe3555aba6"],

Cell["\<\
M={\t{{{a1111,a1112},{a1121,a1122}},{{a1211,a1212},{a1221,a1222}}},
\t{{{a2111,a2112},{a2121,a2122}},{{a2211,a2212},{a2221,a2222}}} };\
\>", \
"Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "7f4e9cf7-6654-476a-a0da-f5283632157e"],

Cell[CellGroupData[{

Cell["MatrixForm[M]", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "058bf719-e40f-4ffb-9e16-a6c05476cf06"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"a1111", "a1112"},
                    {"a1121", "a1122"}
                    },
                  RowSpacings->1,
                  ColumnSpacings->1,
                  ColumnAlignments->{Left}], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"a1211", "a1212"},
                    {"a1221", "a1222"}
                    },
                  RowSpacings->1,
                  ColumnSpacings->1,
                  ColumnAlignments->{Left}], "\[NoBreak]", ")"}]},
            {
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"a2111", "a2112"},
                    {"a2121", "a2122"}
                    },
                  RowSpacings->1,
                  ColumnSpacings->1,
                  ColumnAlignments->{Left}], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"a2211", "a2212"},
                    {"a2221", "a2222"}
                    },
                  RowSpacings->1,
                  ColumnSpacings->1,
                  ColumnAlignments->{Left}], "\[NoBreak]", ")"}]}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MatrixForm[Transpose[M,{1,3,2,4}]]", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "1ec396bf-a54e-408a-b6d2-28c6e7c4ed64"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"a1111", "a1112"},
                    {"a1211", "a1212"}
                    },
                  RowSpacings->1,
                  ColumnSpacings->1,
                  ColumnAlignments->{Left}], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"a1121", "a1122"},
                    {"a1221", "a1222"}
                    },
                  RowSpacings->1,
                  ColumnSpacings->1,
                  ColumnAlignments->{Left}], "\[NoBreak]", ")"}]},
            {
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"a2111", "a2112"},
                    {"a2211", "a2212"}
                    },
                  RowSpacings->1,
                  ColumnSpacings->1,
                  ColumnAlignments->{Left}], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"a2121", "a2122"},
                    {"a2221", "a2222"}
                    },
                  RowSpacings->1,
                  ColumnSpacings->1,
                  ColumnAlignments->{Left}], "\[NoBreak]", ")"}]}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MatrixForm[flatmat[M]]", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "d5113092-c639-418c-8d0a-2fba707f0d3c"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"a1111", "a1112", "a1211", "a1212"},
            {"a1121", "a1122", "a1221", "a1222"},
            {"a2111", "a2112", "a2211", "a2212"},
            {"a2121", "a2122", "a2221", "a2222"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Random-orientation matrix definition", "Subsubsection",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "c05606c5-274e-4043-af34-d971f81c998b"],

Cell["\<\
These are from my Nov'94 hydrodynamics program for the random \
orientation of a chain\
\>", "Text",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "efb3c98a-06a1-41f0-97f5-3750b357ec53"],

Cell["\<\
Ax[w_]:={\t{1,0,0},
\t\t\t{0,Cos[w],Sin[w]},
\t\t\t{0,-Sin[w],Cos[w]}\t};
Ay[w_]:={\t{Cos[w],0,-Sin[w]},
\t\t\t{0,1,0},
\t\t\t{Sin[w],0,Cos[w]}\t};
Az[w_]:={\t{Cos[w],Sin[w],0},
\t\t\t{-Sin[w],Cos[w],0},
\t\t\t{0,0,1}\t};\
\>", "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "1ccbb2cc-64b4-4dc2-bda9-0b2b2b350ebc"],

Cell["\<\
AO:=Az[Random[Real,N[{0,2 Pi}]]].Ax[Random[Real,N[{0,2 Pi}]]].
\tAz[Random[Real,N[{0,2 Pi}]]];
\t\t\t\t\t\t(*\tRandom overall orientation matrix *)\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "ef06c4db-2bf8-47c0-9f89-1639614c4987"],

Cell["\<\
rotate[A_,o_]:=Module[{i,j,depth},
\t(*\tRoutine to rotate vectors even when they are assembled
\t\tinto groups and lists of those groups. Rotation matrix
\t\tis A, vector object is o *)
\tdepth=Depth[N[o]];
\tWhich[\tdepth==1,Print[\"Not done: \",depth];Return[o],
\t\t\tdepth==2,Return[N[A].o],
\t\t\tdepth==3,Return[Transpose[N[A].Transpose[o]]],
\t\t\tdepth==4,Return[Map[
\t\t\t\t\t\tTranspose[N[A].Transpose[#]] &,o ]
\t\t\t\t\t ],
\t\t\tdepth>=5,Print[\"Not done: \",depth];Return[o]
\t]
];\t\t\t\
\>", "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "ab54fce8-9d39-41a5-9a6a-5d3c05207b4f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Higher level (automating) routines", "Subsubsection",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "f57a4022-40b1-4c93-b702-9ea1fde1812c"],

Cell["\<\

element[i_,j_,geo_]:=If[And[i<n+1,j<n+1],
\t\t\t\t\t\tIf[i==j,V[i,geo],dV[i,j,geo]],
\t\t\t\t\t\tIf[i<j,-Id[3],If[i==j,zero[3],Id[3]]]
\t\t\t\t\t];\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "f10376da-b9e9-43da-aa89-13ffaeb6d7f6"],

Cell["\<\
ClearAll[hydro];
hydro[geo_]:=Module[{},
\t(*\tSet up and solve tableau AC.xc = yc for xc for a given
\t\trigid set of particles at positions p with radii s and
\t\tfor a given viscosity nu (here nu->1). 'geo' is a
\t\tstructurecontaining a list of coordinates and an
\t\tassociated list of hydrodynamic radii *)
\tn=Length[geo[[1]]];
\tIf[\ttest,
\t\tPrint[\"Hydrodynamics of an assembly of \",n,\" spheres\"];
\t\tPrint[\" {x,y,z}   radius\"];
\t\tPrint[MatrixForm[Transpose[geo]]]
\t];
\tA=Table[element[i,j,geo]/.nu->1,{i,n+1},{j,n+1}];
\tAA=flatmat[A];
\tAC=complete[AA,geo];
\txx=Join[Table[Map[#<>ToString[i] &,{\"fx\",\"fy\",\"fz\"}],{i,n}],
\t\t{{\"ux\",\"uy\",\"uz\",\"omega z\"}}];
\txc=flatvec[xx];\t
\tyy=Join[Table[{0,0,0},{n}],{0,0,1,0}];
\tyc=flatvec[yy];
\tIf[test,Print[\"Matrix is size: \",Dimensions[AC]]];
\tG=Inverse[AC];
\tdata=Append[data,G.yc];
\tIf[test,Return[MatrixForm[Transpose[{xc,G.yc}]]]]
];\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "c6654cea-41d8-49f3-825a-f8efe9b8efff"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Show relationships between equivalent sphere radius and distance in \
\"lollipop\" geometry \
\>", "Subsubsection",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "5776372b-14c3-461f-a38f-c780f9a48b47"],

Cell["\<\
Copy over the constants used for the equivalent sphere \
calculations.\
\>", "Text",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "0a639cd4-09f4-4bd8-a344-937d5e6dafb8"],

Cell["\<\
el0=3.4;\t\t\t\t(* bp length, A *)
persistence=150 el0;\t(* persistence length, A *)
repeat0=10.4;\t\t\t(* helical repeat of free chain bp/turn *)\
\>", "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "64025076-4ee2-46ad-8228-54be75977252"],

Cell["\<\
NAvo=6.02 10^23;
ro=1.003;\t\t\t\t(* density, g/cm^3 *)
visc=0.01016;\t\t\t(* viscosity, g/(cm s) or \"Poise\" *)\
\>", "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "dd215ac0-60e2-4a74-b719-536d4f528f0f"],

Cell["\<\
mbpa=660;\t\t\t\t(* basepair mol. weight, g/mole *)
rbpa=1.8294;\t\t\t(* basepair Stokes radius, A *)
vDNA=0.55;\t\t\t\t(* specific volume of DNA, cm^3/g *)
dDNA=27;\t\t\t\t(* Yamagawa-Fujii (YF) diam, A *)
switchbp=50;\t\t\t(* point at which we switch from YF
\t\t\t\t\t\t   to ellipsoid model, bp *)\
\>", "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "4b8d55ac-9139-4a86-a9a3-07ed35808cb0"],

Cell["\<\
mbpa=660;\t\t\t\t(* basepair mol. weight, g/mole *)
rbpa=1.8294;\t\t\t(* basepair Stokes radius, A *)
vDNA=0.55;\t\t\t\t(* specific volume of DNA, cm^3/g *)
dDNA=27;\t\t\t\t(* Yamagawa-Fujii (YF) diam, A *)
switchbp=50;\t\t\t(* point at which we switch from YF
\t\t\t\t\t\t   to ellipsoid model, bp *)\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "f3b95965-3e81-4ded-ae0b-9ff7dfe87b30"],

Cell[CellGroupData[{

Cell["findoffset", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "a884608e-6fee-4ca7-a509-3808c951be05"],

Cell[BoxData[
    InterpretationBox[\("Stokes offset "\[InvisibleSpace]3.0076424054539146`\
\[InvisibleSpace]" A at "\[InvisibleSpace]50\[InvisibleSpace]" bp"\),
      SequenceForm[ 
      "Stokes offset ", 3.0076424054539146, " A at ", 50, " bp"],
      Editable->False]], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Plot[{rootr2[i/2],rbpb[i]},{i,0.1,10000},
\tPlotRange->{-5000,5000},
\tAxesLabel->{\"DNA\\nlength, bp\",\"\[CapitalARing]\"}]\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "91e87679-451e-449a-a1f9-a6a6572a20e4"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 9.52381e-05 0.309017 6.18034e-05 [
[.21429 .29652 -12 -9 ]
[.21429 .29652 12 0 ]
[.40476 .29652 -12 -9 ]
[.40476 .29652 12 0 ]
[.59524 .29652 -12 -9 ]
[.59524 .29652 12 0 ]
[.78571 .29652 -12 -9 ]
[.78571 .29652 12 0 ]
[.97619 .29652 -15 -9 ]
[.97619 .29652 15 0 ]
[1.025 .30902 0 -12.25 ]
[1.025 .30902 64 12.25 ]
[.01131 .0618 -30 -4.5 ]
[.01131 .0618 0 4.5 ]
[.01131 .18541 -30 -4.5 ]
[.01131 .18541 0 4.5 ]
[.01131 .43262 -24 -4.5 ]
[.01131 .43262 0 4.5 ]
[.01131 .55623 -24 -4.5 ]
[.01131 .55623 0 4.5 ]
[.02381 .64303 -5.03125 0 ]
[.02381 .64303 5.03125 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30902 m
.21429 .31527 L
s
[(2000)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(4000)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(6000)] .59524 .29652 0 1 Mshowa
.78571 .30902 m
.78571 .31527 L
s
[(8000)] .78571 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(10000)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.5 .30902 m
.5 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -16.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 32.5 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(DNA) show
63.000 25.500 moveto
(length) show
99.000 25.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
111.000 25.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(bp) show
123.000 25.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.02381 .0618 m
.03006 .0618 L
s
[(-4000)] .01131 .0618 1 0 Mshowa
.02381 .18541 m
.03006 .18541 L
s
[(-2000)] .01131 .18541 1 0 Mshowa
.02381 .43262 m
.03006 .43262 L
s
[(2000)] .01131 .43262 1 0 Mshowa
.02381 .55623 m
.03006 .55623 L
s
[(4000)] .01131 .55623 1 0 Mshowa
.125 Mabswid
.02381 .09271 m
.02756 .09271 L
s
.02381 .12361 m
.02756 .12361 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .21631 m
.02756 .21631 L
s
.02381 .24721 m
.02756 .24721 L
s
.02381 .27812 m
.02756 .27812 L
s
.02381 .33992 m
.02756 .33992 L
s
.02381 .37082 m
.02756 .37082 L
s
.02381 .40172 m
.02756 .40172 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .49443 m
.02756 .49443 L
s
.02381 .52533 m
.02756 .52533 L
s
.02381 .0309 m
.02756 .0309 L
s
.02381 .58713 m
.02756 .58713 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66.0312 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding MacintoshRomanEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\201) show
69.062 13.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02382 .30903 m
.04263 .32773 L
.06245 .34386 L
.10459 .37024 L
.14264 .38844 L
.18315 .40442 L
.22215 .41768 L
.26359 .43021 L
.30352 .44117 L
.34193 .45092 L
.3828 .4606 L
.42215 .46938 L
.45998 .47738 L
.50027 .48551 L
.53904 .49299 L
.58027 .50062 L
.61998 .5077 L
.65817 .51427 L
.69881 .52104 L
.73794 .52737 L
.77952 .53389 L
.81959 .54 L
.85814 .54574 L
.89914 .55168 L
.93863 .55728 L
.97619 .56248 L
s
.02382 .30974 m
.04263 .31438 L
.06245 .31797 L
.10459 .32422 L
.14264 .32896 L
.18315 .3335 L
.22215 .33766 L
.26359 .34215 L
.30352 .34686 L
.34193 .35212 L
.3828 .35907 L
.40312 .36333 L
.42215 .36801 L
.45998 .3803 L
.48023 .38939 L
.49876 .40018 L
.51774 .41499 L
.52849 .42589 L
.53846 .43837 L
.54903 .45507 L
.55899 .47555 L
.56792 .49984 L
.57293 .51694 L
.57759 .53605 L
.5871 .58882 L
s
.5871 .58882 m
.59081 .61803 L
s
.6264 .61803 m
.62642 0 L
s
.66132 0 m
.66352 .02067 L
.66842 .05539 L
.6738 .08517 L
.6795 .11012 L
.68908 .14172 L
.69963 .16693 L
.70975 .18507 L
.71902 .19819 L
.72984 .21051 L
.73989 .21985 L
.75885 .23358 L
.77956 .24468 L
.80006 .25303 L
.81866 .25906 L
.8587 .26873 L
.89721 .27531 L
.93818 .28049 L
.97619 .28419 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False,
  ImageRangeCache->{{{73.4375, 302.812}, {420.375, 279.062}} -> {-6858.14, \
22908.3, 55.23, 85.1085}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Plot[{rootr2[i/2],rbpb[i]},{i,0.1,2000},
\tAxesLabel->{\"DNA\\nlength, bp\",\"radius, \[CapitalARing]\"}]\
\>", "Input",\

  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "03b7336d-5ae4-43f2-aed0-e9187754460d"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00047619 0.0147151 0.000342788 [
[.2619 .00222 -9 -9 ]
[.2619 .00222 9 0 ]
[.5 .00222 -12 -9 ]
[.5 .00222 12 0 ]
[.7381 .00222 -12 -9 ]
[.7381 .00222 12 0 ]
[.97619 .00222 -12 -9 ]
[.97619 .00222 12 0 ]
[1.025 .01472 0 -12.25 ]
[1.025 .01472 64 12.25 ]
[.01131 .10041 -18 -4.5 ]
[.01131 .10041 0 4.5 ]
[.01131 .18611 -18 -4.5 ]
[.01131 .18611 0 4.5 ]
[.01131 .27181 -18 -4.5 ]
[.01131 .27181 0 4.5 ]
[.01131 .3575 -24 -4.5 ]
[.01131 .3575 0 4.5 ]
[.01131 .4432 -24 -4.5 ]
[.01131 .4432 0 4.5 ]
[.01131 .5289 -24 -4.5 ]
[.01131 .5289 0 4.5 ]
[.01131 .61459 -24 -4.5 ]
[.01131 .61459 0 4.5 ]
[.02381 .64303 -29.0312 0 ]
[.02381 .64303 29.0312 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(500)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(1000)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(1500)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(2000)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -16.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 32.5 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(DNA) show
63.000 25.500 moveto
(length) show
99.000 25.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
111.000 25.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(bp) show
123.000 25.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.02381 .10041 m
.03006 .10041 L
s
[(250)] .01131 .10041 1 0 Mshowa
.02381 .18611 m
.03006 .18611 L
s
[(500)] .01131 .18611 1 0 Mshowa
.02381 .27181 m
.03006 .27181 L
s
[(750)] .01131 .27181 1 0 Mshowa
.02381 .3575 m
.03006 .3575 L
s
[(1000)] .01131 .3575 1 0 Mshowa
.02381 .4432 m
.03006 .4432 L
s
[(1250)] .01131 .4432 1 0 Mshowa
.02381 .5289 m
.03006 .5289 L
s
[(1500)] .01131 .5289 1 0 Mshowa
.02381 .61459 m
.03006 .61459 L
s
[(1750)] .01131 .61459 1 0 Mshowa
.125 Mabswid
.02381 .03185 m
.02756 .03185 L
s
.02381 .04899 m
.02756 .04899 L
s
.02381 .06613 m
.02756 .06613 L
s
.02381 .08327 m
.02756 .08327 L
s
.02381 .11755 m
.02756 .11755 L
s
.02381 .13469 m
.02756 .13469 L
s
.02381 .15183 m
.02756 .15183 L
s
.02381 .16897 m
.02756 .16897 L
s
.02381 .20325 m
.02756 .20325 L
s
.02381 .22039 m
.02756 .22039 L
s
.02381 .23753 m
.02756 .23753 L
s
.02381 .25467 m
.02756 .25467 L
s
.02381 .28895 m
.02756 .28895 L
s
.02381 .30608 m
.02756 .30608 L
s
.02381 .32322 m
.02756 .32322 L
s
.02381 .34036 m
.02756 .34036 L
s
.02381 .37464 m
.02756 .37464 L
s
.02381 .39178 m
.02756 .39178 L
s
.02381 .40892 m
.02756 .40892 L
s
.02381 .42606 m
.02756 .42606 L
s
.02381 .46034 m
.02756 .46034 L
s
.02381 .47748 m
.02756 .47748 L
s
.02381 .49462 m
.02756 .49462 L
s
.02381 .51176 m
.02756 .51176 L
s
.02381 .54604 m
.02756 .54604 L
s
.02381 .56318 m
.02756 .56318 L
s
.02381 .58031 m
.02756 .58031 L
s
.02381 .59745 m
.02756 .59745 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -90.0312 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding MacintoshRomanEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(radius) show
99.000 13.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
111.000 13.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\201) show
117.062 13.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02386 .01477 m
.06249 .06001 L
.10462 .1051 L
.14419 .14395 L
.18225 .17851 L
.22275 .21266 L
.26175 .24328 L
.30319 .27368 L
.34312 .30114 L
.38153 .32605 L
.42239 .35113 L
.46174 .37403 L
.49958 .39502 L
.53986 .41638 L
.57863 .43606 L
.61985 .45613 L
.65956 .47473 L
.69775 .49198 L
.73839 .50973 L
.77752 .52627 L
.8191 .54329 L
.85917 .55922 L
.89772 .57412 L
.93872 .58956 L
.97619 .60332 L
s
.02386 .01872 m
.06249 .0312 L
.10462 .04149 L
.14419 .0501 L
.18225 .05777 L
.22275 .06543 L
.26175 .07241 L
.30319 .07949 L
.34312 .08601 L
.38153 .09204 L
.42239 .09824 L
.46174 .104 L
.49958 .10938 L
.53986 .11495 L
.57863 .12017 L
.61985 .12559 L
.65956 .13069 L
.69775 .13551 L
.73839 .14055 L
.77752 .14533 L
.8191 .15035 L
.85917 .15513 L
.89772 .1597 L
.93872 .16454 L
.97619 .16895 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False,
  ImageRangeCache->{{{73.4375, 302.812}, {621.062, 479.75}} -> {-1311.63, \
8630.12, 10.8552, 15.0797}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Plot[{rootr2[i/2],rbpb[i]},{i,0.1,200},
\tPlotRange->{0,150},
\tAxesLabel->{\"DNA\\nlength, bp\",\"\[CapitalARing]\"}]\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "f2d186d1-3d7d-427c-bd10-7d21f9b4ebc3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0047619 0 0.00412023 [
[.2619 -0.0125 -6 -9 ]
[.2619 -0.0125 6 0 ]
[.5 -0.0125 -9 -9 ]
[.5 -0.0125 9 0 ]
[.7381 -0.0125 -9 -9 ]
[.7381 -0.0125 9 0 ]
[.97619 -0.0125 -9 -9 ]
[.97619 -0.0125 9 0 ]
[1.025 0 0 -12.25 ]
[1.025 0 64 12.25 ]
[.01131 .0824 -12 -4.5 ]
[.01131 .0824 0 4.5 ]
[.01131 .16481 -12 -4.5 ]
[.01131 .16481 0 4.5 ]
[.01131 .24721 -12 -4.5 ]
[.01131 .24721 0 4.5 ]
[.01131 .32962 -12 -4.5 ]
[.01131 .32962 0 4.5 ]
[.01131 .41202 -18 -4.5 ]
[.01131 .41202 0 4.5 ]
[.01131 .49443 -18 -4.5 ]
[.01131 .49443 0 4.5 ]
[.01131 .57683 -18 -4.5 ]
[.01131 .57683 0 4.5 ]
[.02381 .64303 -5.03125 0 ]
[.02381 .64303 5.03125 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 0 m
.2619 .00625 L
s
[(50)] .2619 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(100)] .5 -0.0125 0 1 Mshowa
.7381 0 m
.7381 .00625 L
s
[(150)] .7381 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(200)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
1.025 0 -61 -16.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 32.5 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(DNA) show
63.000 25.500 moveto
(length) show
99.000 25.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
111.000 25.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(bp) show
123.000 25.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.02381 .0824 m
.03006 .0824 L
s
[(20)] .01131 .0824 1 0 Mshowa
.02381 .16481 m
.03006 .16481 L
s
[(40)] .01131 .16481 1 0 Mshowa
.02381 .24721 m
.03006 .24721 L
s
[(60)] .01131 .24721 1 0 Mshowa
.02381 .32962 m
.03006 .32962 L
s
[(80)] .01131 .32962 1 0 Mshowa
.02381 .41202 m
.03006 .41202 L
s
[(100)] .01131 .41202 1 0 Mshowa
.02381 .49443 m
.03006 .49443 L
s
[(120)] .01131 .49443 1 0 Mshowa
.02381 .57683 m
.03006 .57683 L
s
[(140)] .01131 .57683 1 0 Mshowa
.125 Mabswid
.02381 .0206 m
.02756 .0206 L
s
.02381 .0412 m
.02756 .0412 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .12361 m
.02756 .12361 L
s
.02381 .14421 m
.02756 .14421 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .20601 m
.02756 .20601 L
s
.02381 .22661 m
.02756 .22661 L
s
.02381 .26781 m
.02756 .26781 L
s
.02381 .28842 m
.02756 .28842 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .35022 m
.02756 .35022 L
s
.02381 .37082 m
.02756 .37082 L
s
.02381 .39142 m
.02756 .39142 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .45322 m
.02756 .45322 L
s
.02381 .47383 m
.02756 .47383 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .53563 m
.02756 .53563 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .59743 m
.02756 .59743 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66.0312 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding MacintoshRomanEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\201) show
69.062 13.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02429 .0007 m
.0629 .05724 L
.10502 .11833 L
.14457 .17516 L
.18261 .22933 L
.22309 .28647 L
.26207 .34098 L
.30349 .39839 L
.3434 .4532 L
.3818 .50547 L
.42264 .56058 L
.46197 .61318 L
s
.46197 .61318 m
.46564 .61803 L
s
.02429 .04809 m
.0629 .06864 L
.10502 .08799 L
.14457 .10464 L
.18261 .11973 L
.22309 .13507 L
.26207 .14929 L
.30349 .16328 L
.3434 .17649 L
.3818 .18897 L
.42264 .202 L
.46197 .21432 L
.49979 .22597 L
.54006 .23818 L
.57881 .24976 L
.62001 .26189 L
.6597 .27342 L
.69788 .28437 L
.7385 .29587 L
.77761 .30682 L
.81917 .31832 L
.85922 .32928 L
.89775 .33972 L
.93873 .35071 L
.97619 .36066 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False,
  ImageRangeCache->{{{73.4375, 302.812}, {238.375, 97.0625}} -> {-116.798, \
117.89, 1.03985, 1.2018}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Plot[{rootr2[i/2],rbpb[i]},{i,0.1,20},
\tAxesLabel->{\"DNA\\nlength, bp\",\"\[CapitalARing]\"}]\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "a8a9d7e7-17f1-4a4a-9581-8cb70d29cd58"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.047619 0.0147151 0.0175042 [
[.2619 .00222 -3 -9 ]
[.2619 .00222 3 0 ]
[.5 .00222 -6 -9 ]
[.5 .00222 6 0 ]
[.7381 .00222 -6 -9 ]
[.7381 .00222 6 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[1.025 .01472 0 -12.25 ]
[1.025 .01472 64 12.25 ]
[.01131 .10224 -6 -4.5 ]
[.01131 .10224 0 4.5 ]
[.01131 .18976 -12 -4.5 ]
[.01131 .18976 0 4.5 ]
[.01131 .27728 -12 -4.5 ]
[.01131 .27728 0 4.5 ]
[.01131 .3648 -12 -4.5 ]
[.01131 .3648 0 4.5 ]
[.01131 .45232 -12 -4.5 ]
[.01131 .45232 0 4.5 ]
[.01131 .53984 -12 -4.5 ]
[.01131 .53984 0 4.5 ]
[.02381 .64303 -5.03125 0 ]
[.02381 .64303 5.03125 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(5)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(10)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(15)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(20)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -16.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 32.5 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(DNA) show
63.000 25.500 moveto
(length) show
99.000 25.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
111.000 25.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(bp) show
123.000 25.500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.02381 .10224 m
.03006 .10224 L
s
[(5)] .01131 .10224 1 0 Mshowa
.02381 .18976 m
.03006 .18976 L
s
[(10)] .01131 .18976 1 0 Mshowa
.02381 .27728 m
.03006 .27728 L
s
[(15)] .01131 .27728 1 0 Mshowa
.02381 .3648 m
.03006 .3648 L
s
[(20)] .01131 .3648 1 0 Mshowa
.02381 .45232 m
.03006 .45232 L
s
[(25)] .01131 .45232 1 0 Mshowa
.02381 .53984 m
.03006 .53984 L
s
[(30)] .01131 .53984 1 0 Mshowa
.125 Mabswid
.02381 .03222 m
.02756 .03222 L
s
.02381 .04972 m
.02756 .04972 L
s
.02381 .06723 m
.02756 .06723 L
s
.02381 .08473 m
.02756 .08473 L
s
.02381 .11974 m
.02756 .11974 L
s
.02381 .13724 m
.02756 .13724 L
s
.02381 .15475 m
.02756 .15475 L
s
.02381 .17225 m
.02756 .17225 L
s
.02381 .20726 m
.02756 .20726 L
s
.02381 .22477 m
.02756 .22477 L
s
.02381 .24227 m
.02756 .24227 L
s
.02381 .25977 m
.02756 .25977 L
s
.02381 .29478 m
.02756 .29478 L
s
.02381 .31229 m
.02756 .31229 L
s
.02381 .32979 m
.02756 .32979 L
s
.02381 .3473 m
.02756 .3473 L
s
.02381 .3823 m
.02756 .3823 L
s
.02381 .39981 m
.02756 .39981 L
s
.02381 .41731 m
.02756 .41731 L
s
.02381 .43482 m
.02756 .43482 L
s
.02381 .46982 m
.02756 .46982 L
s
.02381 .48733 m
.02756 .48733 L
s
.02381 .50483 m
.02756 .50483 L
s
.02381 .52234 m
.02756 .52234 L
s
.02381 .55735 m
.02756 .55735 L
s
.02381 .57485 m
.02756 .57485 L
s
.02381 .59235 m
.02756 .59235 L
s
.02381 .60986 m
.02756 .60986 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66.0312 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding MacintoshRomanEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\201) show
69.062 13.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02857 .01769 m
.06701 .0417 L
.10894 .06786 L
.14831 .0924 L
.18618 .11599 L
.22648 .14107 L
.26528 .16519 L
.30652 .1908 L
.34625 .21545 L
.38447 .23915 L
.42513 .26433 L
.46429 .28856 L
.50193 .31184 L
.54202 .3366 L
.5806 .36041 L
.62162 .3857 L
.66113 .41004 L
.69913 .43342 L
.73957 .45829 L
.77851 .48221 L
.81988 .5076 L
.85975 .53205 L
.8981 .55555 L
.9389 .58052 L
.97619 .60332 L
s
.02857 .219 m
.06701 .22856 L
.10894 .23871 L
.14831 .24799 L
.18618 .25673 L
.22648 .26584 L
.26528 .27445 L
.30652 .28343 L
.34625 .29195 L
.38447 .30001 L
.42513 .30848 L
.46429 .31651 L
.50193 .32415 L
.54202 .33218 L
.5806 .33982 L
.62162 .34786 L
.66113 .35552 L
.69913 .36282 L
.73957 .37051 L
.77851 .37785 L
.81988 .38558 L
.85975 .39296 L
.8981 .40001 L
.9389 .40745 L
.97619 .4142 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False,
  ImageRangeCache->{{{73.4375, 302.812}, {439.062, 297.75}} -> {-10.7486, \
96.0058, 0.101024, 0.27483}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Simulate lollipops to see applicability of Kirkwood/BDvH \
approximation\
\>", "Subsubsection",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "0c797c40-fed6-49d4-8b87-2fa15993c93c"],

Cell["\<\
I make a two-particle system here that is again like one in my \
paper. The separation is taken as the center of the array of linker spheres \
(smaller spheres) from the previous example. First orient perpendicular to \
sedimentation direction, then nearly parallel (I used a 5 degree angle with \
the z axis. When the linear assembly is exactly parallel, the set of \
equations becomes singular).\
\>", "Text",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "fd0e09d5-11a9-4fa2-9d7b-ee09ef5afa35"],

Cell["\<\
test=True;
data={};
nall={};
radiiall={};
uall={};
fzall={};
fBzall={};
AFzall={};
AFBzall={};\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "e8baed60-7586-4ccd-8736-73b12f69f907"],

Cell[CellGroupData[{

Cell["\<\
Do[\tnbp=N[Exp[i/2.2]];
\tpoints={{0,0,0},{57+rootr2[nbp/2],0,0}};
\tradii={57,rbpb[nbp]};

\thydro[{points,radii}];
\tftrue=G.yc;

\tftruez=ftrue[[Range[3,3 n,3]]];
\tutruez=ftrue[[3 n+3]];
\tAAz=AA[[Range[3,3 n,3],Range[3,3 n,3]]];
\tAFz=N[-6 Pi radii AAz.DiagonalMatrix[ftruez]];
\tDo[AFz[[i,i]]=N[6 Pi radii[[i]] utruez],{i,Length[AFz]}];

\tfbloomz=N[Map[#/Apply[Plus,radii] &,radii]];
\tAAz=AA[[Range[3,3 n,3],Range[3,3 n,3]]];
\tAFBz=N[-6 Pi radii AAz.DiagonalMatrix[fbloomz]];
\tDo[AFBz[[i,i]]=N[6 Pi radii[[i]] utruez],{i,Length[AFBz]}];

\tAppendTo[nall,nbp];
\tAppendTo[radiiall,radii];
\tAppendTo[uall,utruez];
\tAppendTo[fzall,N[Apply[Plus,Apply[Plus,Transpose[AFz]]]]];
\tAppendTo[fBzall,N[Apply[Plus,Apply[Plus,Transpose[AFBz]]]]];
\tAppendTo[AFzall,AFz];
\tAppendTo[AFBzall,AFBz],
{i,-2,9}];\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "35adb82c-2295-41dd-b49f-642f7b069a60"],

Cell[BoxData[
    InterpretationBox[\("Hydrodynamics of an assembly of "\[InvisibleSpace]2\
\[InvisibleSpace]" spheres"\),
      SequenceForm[ "Hydrodynamics of an assembly of ", 2, " spheres"],
      Editable->False]], "Print"],

Cell[BoxData[
    \(" {x,y,z}   radius"\)], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\({0, 0, 0}\), "57"},
            {\({57.68476027811842`, 0, 0}\), "11.877548930570839`"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Matrix is size: "\[InvisibleSpace]{10, 10}\),
      SequenceForm[ "Matrix is size: ", {10, 10}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Hydrodynamics of an assembly of "\[InvisibleSpace]2\
\[InvisibleSpace]" spheres"\),
      SequenceForm[ "Hydrodynamics of an assembly of ", 2, " spheres"],
      Editable->False]], "Print"],

Cell[BoxData[
    \(" {x,y,z}   radius"\)], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\({0, 0, 0}\), "57"},
            {\({58.07867153881721`, 0, 0}\), "12.034323655022325`"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Matrix is size: "\[InvisibleSpace]{10, 10}\),
      SequenceForm[ "Matrix is size: ", {10, 10}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Hydrodynamics of an assembly of "\[InvisibleSpace]2\
\[InvisibleSpace]" spheres"\),
      SequenceForm[ "Hydrodynamics of an assembly of ", 2, " spheres"],
      Editable->False]], "Print"],

Cell[BoxData[
    \(" {x,y,z}   radius"\)], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\({0, 0, 0}\), "57"},
            {\({58.6990560800066`, 0, 0}\), "12.27881508474096`"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Matrix is size: "\[InvisibleSpace]{10, 10}\),
      SequenceForm[ "Matrix is size: ", {10, 10}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Hydrodynamics of an assembly of "\[InvisibleSpace]2\
\[InvisibleSpace]" spheres"\),
      SequenceForm[ "Hydrodynamics of an assembly of ", 2, " spheres"],
      Editable->False]], "Print"],

Cell[BoxData[
    \(" {x,y,z}   radius"\)], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\({0, 0, 0}\), "57"},
            {\({59.675934953492884`, 0, 0}\), "12.658177878173772`"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Matrix is size: "\[InvisibleSpace]{10, 10}\),
      SequenceForm[ "Matrix is size: ", {10, 10}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Hydrodynamics of an assembly of "\[InvisibleSpace]2\
\[InvisibleSpace]" spheres"\),
      SequenceForm[ "Hydrodynamics of an assembly of ", 2, " spheres"],
      Editable->False]], "Print"],

Cell[BoxData[
    \(" {x,y,z}   radius"\)], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\({0, 0, 0}\), "57"},
            {\({61.21370026922342`, 0, 0}\), "13.24269970542914`"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Matrix is size: "\[InvisibleSpace]{10, 10}\),
      SequenceForm[ "Matrix is size: ", {10, 10}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Hydrodynamics of an assembly of "\[InvisibleSpace]2\
\[InvisibleSpace]" spheres"\),
      SequenceForm[ "Hydrodynamics of an assembly of ", 2, " spheres"],
      Editable->False]], "Print"],

Cell[BoxData[
    \(" {x,y,z}   radius"\)], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\({0, 0, 0}\), "57"},
            {\({63.6332477157901`, 0, 0}\), "14.13512582760237`"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Matrix is size: "\[InvisibleSpace]{10, 10}\),
      SequenceForm[ "Matrix is size: ", {10, 10}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Hydrodynamics of an assembly of "\[InvisibleSpace]2\
\[InvisibleSpace]" spheres"\),
      SequenceForm[ "Hydrodynamics of an assembly of ", 2, " spheres"],
      Editable->False]], "Print"],

Cell[BoxData[
    \(" {x,y,z}   radius"\)], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\({0, 0, 0}\), "57"},
            {\({67.43737735001169`, 0, 0}\), "15.482728885765107`"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Matrix is size: "\[InvisibleSpace]{10, 10}\),
      SequenceForm[ "Matrix is size: ", {10, 10}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Hydrodynamics of an assembly of "\[InvisibleSpace]2\
\[InvisibleSpace]" spheres"\),
      SequenceForm[ "Hydrodynamics of an assembly of ", 2, " spheres"],
      Editable->False]], "Print"],

Cell[BoxData[
    \(" {x,y,z}   radius"\)], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\({0, 0, 0}\), "57"},
            {\({73.41142780769728`, 0, 0}\), "17.49353584482057`"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Matrix is size: "\[InvisibleSpace]{10, 10}\),
      SequenceForm[ "Matrix is size: ", {10, 10}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Hydrodynamics of an assembly of "\[InvisibleSpace]2\
\[InvisibleSpace]" spheres"\),
      SequenceForm[ "Hydrodynamics of an assembly of ", 2, " spheres"],
      Editable->False]], "Print"],

Cell[BoxData[
    \(" {x,y,z}   radius"\)], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\({0, 0, 0}\), "57"},
            {\({82.77595057310057`, 0, 0}\), "20.46002691653451`"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Matrix is size: "\[InvisibleSpace]{10, 10}\),
      SequenceForm[ "Matrix is size: ", {10, 10}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Hydrodynamics of an assembly of "\[InvisibleSpace]2\
\[InvisibleSpace]" spheres"\),
      SequenceForm[ "Hydrodynamics of an assembly of ", 2, " spheres"],
      Editable->False]], "Print"],

Cell[BoxData[
    \(" {x,y,z}   radius"\)], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\({0, 0, 0}\), "57"},
            {\({97.4130217274855`, 0, 0}\), "24.79605828146948`"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Matrix is size: "\[InvisibleSpace]{10, 10}\),
      SequenceForm[ "Matrix is size: ", {10, 10}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Hydrodynamics of an assembly of "\[InvisibleSpace]2\
\[InvisibleSpace]" spheres"\),
      SequenceForm[ "Hydrodynamics of an assembly of ", 2, " spheres"],
      Editable->False]], "Print"],

Cell[BoxData[
    \(" {x,y,z}   radius"\)], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\({0, 0, 0}\), "57"},
            {\({120.18883379815287`, 0, 0}\), "31.094880546605893`"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Matrix is size: "\[InvisibleSpace]{10, 10}\),
      SequenceForm[ "Matrix is size: ", {10, 10}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Hydrodynamics of an assembly of "\[InvisibleSpace]2\
\[InvisibleSpace]" spheres"\),
      SequenceForm[ "Hydrodynamics of an assembly of ", 2, " spheres"],
      Editable->False]], "Print"],

Cell[BoxData[
    \(" {x,y,z}   radius"\)], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\({0, 0, 0}\), "57"},
            {\({155.3827154959182`, 0, 0}\), "40.03772654369161`"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Matrix is size: "\[InvisibleSpace]{10, 10}\),
      SequenceForm[ "Matrix is size: ", {10, 10}],
      Editable->False]], "Print"]
}, Open  ]],

Cell["Results for orientation 1 (aligned in x direction)", "Text",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "3f2e8089-40cf-46f6-9cd4-ce07a2ba234a"],

Cell[CellGroupData[{

Cell["\<\
MatrixForm[N[Transpose[{nall,radiiall,uall,fzall,fBzall}],4]]\
\>", \
"Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "103ed379-464f-4b14-9d5c-00e8bff902a9"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {
              "0.402890321529133`", \({57.`3.9999999999999996, 
                11.877548930570839`}\), "0.000916278299255406`", 
              "0.9999999999999999`", "0.9340183206785704`"},
            {
              "0.6347364189402819`", \({57.`3.9999999999999996, 
                12.034323655022325`}\), "0.0009155269078632255`", 
              "1.0000000000000002`", "0.9347151620927788`"},
            {"1.`", \({57.`3.9999999999999996, 12.27881508474096`}\), 
              "0.0009143142497740865`", "1.`", "0.9358188084507466`"},
            {
              "1.5754571033903182`", \({57.`3.9999999999999996, 
                12.658177878173772`}\), "0.0009123353701727042`", "1.`", 
              "0.937564778929949`"},
            {
              "2.482065084623012`", \({57.`3.9999999999999996, 
                13.24269970542914`}\), "0.0009090604123202538`", 
              "0.9999999999999999`", "0.9403102686065897`"},
            {
              "3.9103870686464153`", \({57.`3.9999999999999996, 
                14.13512582760237`}\), "0.0009035563500196947`", "1.`", 
              "0.9445559648440504`"},
            {
              "6.160647084304639`", \({57.`3.9999999999999996, 
                15.482728885765107`}\), "0.0008941922255138094`", 
              "0.9999999999999999`", "0.9508869995827748`"},
            {
              "9.705835210448596`", \({57.`3.9999999999999996, 
                17.49353584482057`}\), "0.0008782491451633619`", "1.`", 
              "0.9597085663966838`"},
            {
              "15.291127026637104`", \({57.`3.9999999999999996, 
                20.46002691653451`}\), "0.0008516826460829171`", 
              "0.9999999999999999`", "0.9707018752034524`"},
            {
              "24.090514692959104`", \({57.`3.9999999999999996, 
                24.79605828146948`}\), "0.0008096780536246925`", 
              "0.9999999999999999`", "0.9823051890071554`"},
            {
              "37.95357249735125`", \({57.`3.9999999999999996, 
                31.094880546605893`}\), "0.0007486240975994876`", 
              "1.0000000000000002`", "0.9920310357192708`"},
            {
              "59.79422538999145`", \({57.`3.9999999999999996, 
                40.03772654369161`}\), "0.0006696849851832517`", "1.`", 
              "0.997898215119642`"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The values in this table match exactly those in the original ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebook (but with a different number of significant figures provided), \
copied below:"
}], "Text",
  CellFrame->True,
  ExpressionUUID -> "19e0ad2a-7a83-4fbf-8f15-4891014b2f88",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[0.833326]],

Cell[OutputFormData["\<\
MatrixForm[{{0.4028903215291329984, {57., \
11.87754893057077024}, 
 
    0.0009162782992554211008, 1., 0.9340183206785410912}, 
 
   {0.6347364189402818552, {57., 12.03432365502225954}, 
 
    0.0009155269078632304049, 1., 0.9347151620927694008}, 
 
   {1., {57., 12.27881508474089497}, 0.0009143142497740764362, 1., 
 
    0.9358188084507654646}, {1.575457103390318266, 
 
    {57., 12.65817787817370561}, 0.0009123353701727025776, 1., 
 
    0.9375647789299521531}, {2.482065084623011977, 
 
    {57., 13.24269970542908097}, 0.0009090604123202511157, 1., 
 
    0.9403102686065944433}, {3.910387068646415636, 
 
    {57., 14.13512582760230466}, 0.0009035563500196934039, 1., 
 
    0.9445559648440521558}, {6.160647084304639614, 
 
    {57., 15.4827288857650432}, 0.0008941922255138103687, 1., 
 
    0.9508869995827738861}, {9.70583521044859737, 
 
    {57., 17.49353584482051243}, 0.0008782491451633630181, 1., 
 
    0.9597085663966829894}, {15.29112702663710731, 
 
    {57., 20.46002691653445146}, 0.0008516826460829173572, 1., 
 
    0.9707018752034526873}, {24.09051469295910709, 
 
    {57., 24.7960582814694225}, 0.0008096780536246922953, 1., 
 
    0.9823051890071555347}, {37.95357249735125726, 
 
    {57., 31.09488054660584041}, 0.0007486240975994876542, 1., 
 
    0.9920310357192703564}, {59.79422538999145958, 
 
    {57., 40.03772654369157374}, 0.0006696849851832519147, 1., 
 
    0.9978982151196419793}}]\
\>", "\<\
0.4029         {57., 11.88}   \
0.0009163      1.             0.934

0.6347         {57., 12.03}   0.0009155      1.             0.9347

1.             {57., 12.28}   0.0009143      1.             0.9358

1.575          {57., 12.66}   0.0009123      1.             0.9376

2.482          {57., 13.24}   0.0009091      1.             0.9403

3.91           {57., 14.14}   0.0009036      1.             0.9446

6.161          {57., 15.48}   0.0008942      1.             0.9509

9.706          {57., 17.49}   0.0008782      1.             0.9597

15.29          {57., 20.46}   0.0008517      1.             0.9707

24.09          {57., 24.8}    0.0008097      1.             0.9823

37.95          {57., 31.09}   0.0007486      1.             0.992

59.79          {57., 40.04}   0.0006697      1.             0.9979\
\>"], \
"Output",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "b736fcb3-2214-4b0e-84d4-3859f905e7a8"],

Cell[CellGroupData[{

Cell["\<\
ListPlot[Transpose[{nall,fBzall}],
\tPlotJoined->True,
\tAxesLabel->{\"length, bp\",\"F(eq 4)/F(true)\"},
\tPlotRange->{0.9,1}]\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "61168add-9771-44a2-8670-0c703bc45450"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0159276 -5.56231 6.18034 [
[.18309 .60553 -6 -9 ]
[.18309 .60553 6 0 ]
[.34236 .60553 -6 -9 ]
[.34236 .60553 6 0 ]
[.50164 .60553 -6 -9 ]
[.50164 .60553 6 0 ]
[.66092 .60553 -6 -9 ]
[.66092 .60553 6 0 ]
[.82019 .60553 -6 -9 ]
[.82019 .60553 6 0 ]
[.97947 .60553 -6 -9 ]
[.97947 .60553 6 0 ]
[1.025 .61803 0 -6 ]
[1.025 .61803 64 6 ]
[.01131 0 -18 -4.5 ]
[.01131 0 0 4.5 ]
[.01131 .12361 -24 -4.5 ]
[.01131 .12361 0 4.5 ]
[.01131 .24721 -24 -4.5 ]
[.01131 .24721 0 4.5 ]
[.01131 .37082 -24 -4.5 ]
[.01131 .37082 0 4.5 ]
[.01131 .49443 -24 -4.5 ]
[.01131 .49443 0 4.5 ]
[.02381 .64303 -47 0 ]
[.02381 .64303 47 12 ]
[ 0 0 0 0 ]
[ 1 .62428 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18309 .61803 m
.18309 .62428 L
s
[(10)] .18309 .60553 0 1 Mshowa
.34236 .61803 m
.34236 .62428 L
s
[(20)] .34236 .60553 0 1 Mshowa
.50164 .61803 m
.50164 .62428 L
s
[(30)] .50164 .60553 0 1 Mshowa
.66092 .61803 m
.66092 .62428 L
s
[(40)] .66092 .60553 0 1 Mshowa
.82019 .61803 m
.82019 .62428 L
s
[(50)] .82019 .60553 0 1 Mshowa
.97947 .61803 m
.97947 .62428 L
s
[(60)] .97947 .60553 0 1 Mshowa
.125 Mabswid
.05566 .61803 m
.05566 .62178 L
s
.08752 .61803 m
.08752 .62178 L
s
.11938 .61803 m
.11938 .62178 L
s
.15123 .61803 m
.15123 .62178 L
s
.21494 .61803 m
.21494 .62178 L
s
.2468 .61803 m
.2468 .62178 L
s
.27865 .61803 m
.27865 .62178 L
s
.31051 .61803 m
.31051 .62178 L
s
.37422 .61803 m
.37422 .62178 L
s
.40607 .61803 m
.40607 .62178 L
s
.43793 .61803 m
.43793 .62178 L
s
.46978 .61803 m
.46978 .62178 L
s
.53349 .61803 m
.53349 .62178 L
s
.56535 .61803 m
.56535 .62178 L
s
.5972 .61803 m
.5972 .62178 L
s
.62906 .61803 m
.62906 .62178 L
s
.69277 .61803 m
.69277 .62178 L
s
.72463 .61803 m
.72463 .62178 L
s
.75648 .61803 m
.75648 .62178 L
s
.78834 .61803 m
.78834 .62178 L
s
.85205 .61803 m
.85205 .62178 L
s
.8839 .61803 m
.8839 .62178 L
s
.91576 .61803 m
.91576 .62178 L
s
.94761 .61803 m
.94761 .62178 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
gsave
1.025 .61803 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(length) show
99.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
111.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(bp) show
123.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.02381 0 m
.03006 0 L
s
[(0.9)] .01131 0 1 0 Mshowa
.02381 .12361 m
.03006 .12361 L
s
[(0.92)] .01131 .12361 1 0 Mshowa
.02381 .24721 m
.03006 .24721 L
s
[(0.94)] .01131 .24721 1 0 Mshowa
.02381 .37082 m
.03006 .37082 L
s
[(0.96)] .01131 .37082 1 0 Mshowa
.02381 .49443 m
.03006 .49443 L
s
[(0.98)] .01131 .49443 1 0 Mshowa
.125 Mabswid
.02381 .0309 m
.02756 .0309 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .09271 m
.02756 .09271 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .21631 m
.02756 .21631 L
s
.02381 .27812 m
.02756 .27812 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33992 m
.02756 .33992 L
s
.02381 .40172 m
.02756 .40172 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .52533 m
.02756 .52533 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .58713 m
.02756 .58713 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -108 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(F) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
69.000 13.000 moveto
(H) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(eq) show
93.000 13.000 moveto
(4) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
99.000 13.000 moveto
(L) show
105.000 13.000 moveto
(\\220) show
111.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(F) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
117.000 13.000 moveto
(H) show
123.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(true) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
147.000 13.000 moveto
(L) show
153.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.03023 .21024 m
.03392 .21455 L
.03974 .22137 L
.0489 .23216 L
.06334 .24913 L
.08609 .27537 L
.12193 .3145 L
.1784 .36902 L
.26736 .43696 L
.40751 .50867 L
.62832 .56878 L
.97619 .60504 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False,
  ImageRangeCache->{{{73.4375, 302.812}, {636.812, 495.5}} -> {-49.6518, \
1.44507, 0.357728, 0.000921914}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Open  ]],

Cell["\<\
In the article, the data were plotted in Figure 3 using \
CricketGraph, but the relevant files are no longer readable. Below I mocked \
up the essential parts of this figure using the recalculated data. (Note that \
only the last 7 data points were used in making the published plot.)\
\>", \
"Text",
  CellFrame->True,
  ExpressionUUID -> "cbbf5cba-3507-4246-bafa-f4780dff865f",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[0.833326]],

Cell[CellGroupData[{

Cell["\<\
Show[
\tGraphics[{Dashing[{0.01,0.015}],Line[{{11,0.92},{10.5,1}}]}],
\t\tListPlot[Transpose[{Take[nall,-7],Take[fBzall,-7]}],
\t\tPlotJoined->True,
\t\tDisplayFunction->Identity
\t],
\tAxesLabel->{\"length, bp\",\"F(eq 4)/F(true)\"},
\tPlotRange->{{0,60},{0.92,1}},AspectRatio->8.0/7.5,Axes->True, Frame->True,
\tDisplayFunction->$DisplayFunction
]\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "4ad653e2-d64b-4ffa-bfb4-df13ddec533a"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.06667 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 0.0166667 -12.2667 13.3333 [
[.16667 -0.0125 -6 -9 ]
[.16667 -0.0125 6 0 ]
[.33333 -0.0125 -6 -9 ]
[.33333 -0.0125 6 0 ]
[.5 -0.0125 -6 -9 ]
[.5 -0.0125 6 0 ]
[.66667 -0.0125 -6 -9 ]
[.66667 -0.0125 6 0 ]
[.83333 -0.0125 -6 -9 ]
[.83333 -0.0125 6 0 ]
[1 -0.0125 -6 -9 ]
[1 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .13333 -24 -4.5 ]
[-0.0125 .13333 0 4.5 ]
[-0.0125 .26667 -24 -4.5 ]
[-0.0125 .26667 0 4.5 ]
[-0.0125 .4 -24 -4.5 ]
[-0.0125 .4 0 4.5 ]
[-0.0125 .53333 -24 -4.5 ]
[-0.0125 .53333 0 4.5 ]
[-0.0125 .66667 -24 -4.5 ]
[-0.0125 .66667 0 4.5 ]
[-0.0125 .8 -24 -4.5 ]
[-0.0125 .8 0 4.5 ]
[-0.0125 .93333 -24 -4.5 ]
[-0.0125 .93333 0 4.5 ]
[-0.0125 1.06667 -6 -4.5 ]
[-0.0125 1.06667 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1.06667 .125 0 ]
[ 1 0 .125 0 ]
[1.025 0 0 -6 ]
[1.025 0 64 6 ]
[0 1.09167 -47 0 ]
[0 1.09167 47 12 ]
[ 0 0 0 0 ]
[ 1 1.06667 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16667 0 m
.16667 .00625 L
s
[(10)] .16667 -0.0125 0 1 Mshowa
.33333 0 m
.33333 .00625 L
s
[(20)] .33333 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(30)] .5 -0.0125 0 1 Mshowa
.66667 0 m
.66667 .00625 L
s
[(40)] .66667 -0.0125 0 1 Mshowa
.83333 0 m
.83333 .00625 L
s
[(50)] .83333 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(60)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.03333 0 m
.03333 .00375 L
s
.06667 0 m
.06667 .00375 L
s
.1 0 m
.1 .00375 L
s
.13333 0 m
.13333 .00375 L
s
.2 0 m
.2 .00375 L
s
.23333 0 m
.23333 .00375 L
s
.26667 0 m
.26667 .00375 L
s
.3 0 m
.3 .00375 L
s
.36667 0 m
.36667 .00375 L
s
.4 0 m
.4 .00375 L
s
.43333 0 m
.43333 .00375 L
s
.46667 0 m
.46667 .00375 L
s
.53333 0 m
.53333 .00375 L
s
.56667 0 m
.56667 .00375 L
s
.6 0 m
.6 .00375 L
s
.63333 0 m
.63333 .00375 L
s
.7 0 m
.7 .00375 L
s
.73333 0 m
.73333 .00375 L
s
.76667 0 m
.76667 .00375 L
s
.8 0 m
.8 .00375 L
s
.86667 0 m
.86667 .00375 L
s
.9 0 m
.9 .00375 L
s
.93333 0 m
.93333 .00375 L
s
.96667 0 m
.96667 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .13333 m
.00625 .13333 L
s
[(0.93)] -0.0125 .13333 1 0 Mshowa
0 .26667 m
.00625 .26667 L
s
[(0.94)] -0.0125 .26667 1 0 Mshowa
0 .4 m
.00625 .4 L
s
[(0.95)] -0.0125 .4 1 0 Mshowa
0 .53333 m
.00625 .53333 L
s
[(0.96)] -0.0125 .53333 1 0 Mshowa
0 .66667 m
.00625 .66667 L
s
[(0.97)] -0.0125 .66667 1 0 Mshowa
0 .8 m
.00625 .8 L
s
[(0.98)] -0.0125 .8 1 0 Mshowa
0 .93333 m
.00625 .93333 L
s
[(0.99)] -0.0125 .93333 1 0 Mshowa
0 1.06667 m
.00625 1.06667 L
s
[(1)] -0.0125 1.06667 1 0 Mshowa
.125 Mabswid
0 .02667 m
.00375 .02667 L
s
0 .05333 m
.00375 .05333 L
s
0 .08 m
.00375 .08 L
s
0 .10667 m
.00375 .10667 L
s
0 .16 m
.00375 .16 L
s
0 .18667 m
.00375 .18667 L
s
0 .21333 m
.00375 .21333 L
s
0 .24 m
.00375 .24 L
s
0 .29333 m
.00375 .29333 L
s
0 .32 m
.00375 .32 L
s
0 .34667 m
.00375 .34667 L
s
0 .37333 m
.00375 .37333 L
s
0 .42667 m
.00375 .42667 L
s
0 .45333 m
.00375 .45333 L
s
0 .48 m
.00375 .48 L
s
0 .50667 m
.00375 .50667 L
s
0 .56 m
.00375 .56 L
s
0 .58667 m
.00375 .58667 L
s
0 .61333 m
.00375 .61333 L
s
0 .64 m
.00375 .64 L
s
0 .69333 m
.00375 .69333 L
s
0 .72 m
.00375 .72 L
s
0 .74667 m
.00375 .74667 L
s
0 .77333 m
.00375 .77333 L
s
0 .82667 m
.00375 .82667 L
s
0 .85333 m
.00375 .85333 L
s
0 .88 m
.00375 .88 L
s
0 .90667 m
.00375 .90667 L
s
0 .96 m
.00375 .96 L
s
0 .98667 m
.00375 .98667 L
s
0 1.01333 m
.00375 1.01333 L
s
0 1.04 m
.00375 1.04 L
s
.25 Mabswid
0 0 m
0 1.06667 L
s
0 1.06042 m
0 1.06667 L
s
.16667 1.06042 m
.16667 1.06667 L
s
.33333 1.06042 m
.33333 1.06667 L
s
.5 1.06042 m
.5 1.06667 L
s
.66667 1.06042 m
.66667 1.06667 L
s
.83333 1.06042 m
.83333 1.06667 L
s
.125 Mabswid
.03333 1.06292 m
.03333 1.06667 L
s
.06667 1.06292 m
.06667 1.06667 L
s
.1 1.06292 m
.1 1.06667 L
s
.13333 1.06292 m
.13333 1.06667 L
s
.2 1.06292 m
.2 1.06667 L
s
.23333 1.06292 m
.23333 1.06667 L
s
.26667 1.06292 m
.26667 1.06667 L
s
.3 1.06292 m
.3 1.06667 L
s
.36667 1.06292 m
.36667 1.06667 L
s
.4 1.06292 m
.4 1.06667 L
s
.43333 1.06292 m
.43333 1.06667 L
s
.46667 1.06292 m
.46667 1.06667 L
s
.53333 1.06292 m
.53333 1.06667 L
s
.56667 1.06292 m
.56667 1.06667 L
s
.6 1.06292 m
.6 1.06667 L
s
.63333 1.06292 m
.63333 1.06667 L
s
.7 1.06292 m
.7 1.06667 L
s
.73333 1.06292 m
.73333 1.06667 L
s
.76667 1.06292 m
.76667 1.06667 L
s
.8 1.06292 m
.8 1.06667 L
s
.86667 1.06292 m
.86667 1.06667 L
s
.9 1.06292 m
.9 1.06667 L
s
.93333 1.06292 m
.93333 1.06667 L
s
.96667 1.06292 m
.96667 1.06667 L
s
.25 Mabswid
0 1.06667 m
1 1.06667 L
s
.99375 0 m
1 0 L
s
.99375 .13333 m
1 .13333 L
s
.99375 .26667 m
1 .26667 L
s
.99375 .4 m
1 .4 L
s
.99375 .53333 m
1 .53333 L
s
.99375 .66667 m
1 .66667 L
s
.99375 .8 m
1 .8 L
s
.99375 .93333 m
1 .93333 L
s
.125 Mabswid
.99625 .02667 m
1 .02667 L
s
.99625 .05333 m
1 .05333 L
s
.99625 .08 m
1 .08 L
s
.99625 .10667 m
1 .10667 L
s
.99625 .16 m
1 .16 L
s
.99625 .18667 m
1 .18667 L
s
.99625 .21333 m
1 .21333 L
s
.99625 .24 m
1 .24 L
s
.99625 .29333 m
1 .29333 L
s
.99625 .32 m
1 .32 L
s
.99625 .34667 m
1 .34667 L
s
.99625 .37333 m
1 .37333 L
s
.99625 .42667 m
1 .42667 L
s
.99625 .45333 m
1 .45333 L
s
.99625 .48 m
1 .48 L
s
.99625 .50667 m
1 .50667 L
s
.99625 .56 m
1 .56 L
s
.99625 .58667 m
1 .58667 L
s
.99625 .61333 m
1 .61333 L
s
.99625 .64 m
1 .64 L
s
.99625 .69333 m
1 .69333 L
s
.99625 .72 m
1 .72 L
s
.99625 .74667 m
1 .74667 L
s
.99625 .77333 m
1 .77333 L
s
.99625 .82667 m
1 .82667 L
s
.99625 .85333 m
1 .85333 L
s
.99625 .88 m
1 .88 L
s
.99625 .90667 m
1 .90667 L
s
.99625 .96 m
1 .96 L
s
.99625 .98667 m
1 .98667 L
s
.99625 1.01333 m
1 1.01333 L
s
.99625 1.04 m
1 1.04 L
s
.25 Mabswid
1 0 m
1 1.06667 L
s
0 0 m
1 0 L
s
gsave
1.025 0 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(length) show
99.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
111.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(bp) show
123.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
0 1.06667 L
s
gsave
0 1.09167 -108 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(F) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
69.000 13.000 moveto
(H) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(eq) show
93.000 13.000 moveto
(4) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
99.000 13.000 moveto
(L) show
105.000 13.000 moveto
(\\220) show
111.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(F) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
117.000 13.000 moveto
(H) show
123.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(true) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
147.000 13.000 moveto
(L) show
153.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1.06667 L
0 1.06667 L
closepath
clip
newpath
.5 Mabswid
[ .01 .015 ] 0 setdash
.18333 0 m
.175 1.06667 L
s
[ ] 0 setdash
.06517 .32741 m
.10268 .41183 L
.16176 .52945 L
.25485 .67603 L
.40151 .83074 L
.63256 .96041 L
.99657 1.03864 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{269.938, 287.875},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False,
  ImageRangeCache->{{{73.4375, 288.375}, {396.312, 167.062}} -> {-54.1385, \
0.993164, 0.390054, 0.000487569}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{0, 1440}, {0, 877}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{714, 822},
WindowMargins->{{Automatic, 3}, {1, Automatic}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowSelection->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1.5,
StyleDefinitions -> "Default.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 404, 8, 125, "Text",
  InitializationCell->True],
Cell[2161, 61, 1041, 19, 487, "Text",
  InitializationCell->True],
Cell[3205, 82, 169, 3, 39, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[3399, 89, 232, 6, 41, "Subsubsection",
  InitializationCell->True],
Cell[3634, 97, 253, 8, 58, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[3890, 107, 171, 3, 38, "Input",
  InitializationCell->True],
Cell[4064, 112, 279, 9, 98, "Input",
  InitializationCell->True],
Cell[4346, 123, 225, 4, 58, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[4596, 131, 195, 4, 38, "Input",
  InitializationCell->True],
Cell[4794, 137, 1053, 23, 228, "Output"]
}, Open  ]],
Cell[5862, 163, 182, 3, 47, "Text",
  InitializationCell->True],
Cell[6047, 168, 323, 8, 98, "Input",
  InitializationCell->True],
Cell[6373, 178, 171, 3, 47, "Text",
  InitializationCell->True],
Cell[6547, 183, 957, 18, 312, "Text",
  InitializationCell->True],
Cell[7507, 203, 251, 8, 78, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[7783, 215, 218, 4, 38, "Input",
  InitializationCell->True],
Cell[8004, 221, 66, 1, 66, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8107, 227, 158, 3, 38, "Input",
  InitializationCell->True],
Cell[8268, 232, 46, 1, 58, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8351, 238, 163, 3, 38, "Input",
  InitializationCell->True],
Cell[8517, 243, 116, 2, 40, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8670, 250, 289, 8, 78, "Input",
  InitializationCell->True],
Cell[8962, 260, 169021, 2940, 363, 39883, 1341, "GraphicsData", "PostScript", \
"Graphics"],
Cell[177986, 3202, 137, 3, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[178150, 3209, 363, 10, 97, "Text"],

Cell[CellGroupData[{
Cell[178538, 3223, 226, 6, 41, "Subsubsection",
  InitializationCell->True],
Cell[178767, 3231, 293, 9, 158, "Input",
  InitializationCell->True],
Cell[179063, 3242, 164, 3, 38, "Input",
  InitializationCell->True],
Cell[179230, 3247, 723, 21, 398, "Input",
  InitializationCell->True],
Cell[179956, 3270, 178, 3, 47, "Text",
  InitializationCell->True],
Cell[180137, 3275, 282, 7, 138, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[180444, 3286, 151, 3, 38, "Input",
  InitializationCell->True],
Cell[180598, 3291, 1462, 38, 106, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[182097, 3334, 172, 3, 38, "Input",
  InitializationCell->True],
Cell[182272, 3339, 1462, 38, 106, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[183771, 3382, 160, 3, 38, "Input",
  InitializationCell->True],
Cell[183934, 3387, 470, 12, 106, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[184453, 3405, 182, 3, 41, "Subsubsection",
  InitializationCell->True],
Cell[184638, 3410, 231, 6, 73, "Text",
  InitializationCell->True],
Cell[184872, 3418, 432, 15, 198, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[185307, 3435, 293, 7, 118, "Input",
  InitializationCell->True],
Cell[185603, 3444, 714, 20, 418, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[186354, 3469, 180, 3, 41, "Subsubsection",
  InitializationCell->True],
Cell[186537, 3474, 294, 9, 158, "Input",
  InitializationCell->True],
Cell[186834, 3485, 1070, 30, 718, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[187941, 3520, 246, 6, 64, "Subsubsection",
  InitializationCell->True],
Cell[188190, 3528, 215, 6, 47, "Text",
  InitializationCell->True],
Cell[188408, 3536, 357, 9, 98, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[188768, 3547, 324, 9, 98, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[189095, 3558, 512, 12, 258, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[189610, 3572, 447, 10, 258, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[190082, 3586, 148, 3, 38, "Input",
  InitializationCell->True],
Cell[190233, 3591, 282, 5, 34, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[190552, 3601, 271, 7, 78, "Input",
  InitializationCell->True],
Cell[190826, 3610, 7772, 413, 279, 7545, 407, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[198601, 4025, 130, 3, 40, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[198768, 4033, 253, 7, 58, "Input",
  InitializationCell->True],
Cell[199024, 4042, 8515, 457, 279, 8287, 451, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[207542, 4501, 130, 3, 40, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[207709, 4509, 264, 7, 78, "Input",
  InitializationCell->True],
Cell[207976, 4518, 7592, 415, 279, 7365, 409, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[215571, 4935, 130, 3, 40, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[215738, 4943, 241, 6, 58, "Input",
  InitializationCell->True],
Cell[215982, 4951, 7966, 437, 279, 7737, 431, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[223951, 5390, 130, 3, 40, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[224130, 5399, 226, 6, 41, "Subsubsection",
  InitializationCell->True],
Cell[224359, 5407, 542, 10, 151, "Text",
  InitializationCell->True],
Cell[224904, 5419, 240, 13, 198, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[225169, 5436, 953, 30, 678, "Input",
  InitializationCell->True],
Cell[226125, 5468, 228, 4, 34, "Print"],
Cell[226356, 5474, 52, 1, 34, "Print"],
Cell[226411, 5477, 373, 10, 54, "Print"],
Cell[226787, 5489, 169, 3, 34, "Print"],
Cell[226959, 5494, 228, 4, 34, "Print"],
Cell[227190, 5500, 52, 1, 34, "Print"],
Cell[227245, 5503, 373, 10, 54, "Print"],
Cell[227621, 5515, 169, 3, 34, "Print"],
Cell[227793, 5520, 228, 4, 34, "Print"],
Cell[228024, 5526, 52, 1, 34, "Print"],
Cell[228079, 5529, 371, 10, 54, "Print"],
Cell[228453, 5541, 169, 3, 34, "Print"],
Cell[228625, 5546, 228, 4, 34, "Print"],
Cell[228856, 5552, 52, 1, 34, "Print"],
Cell[228911, 5555, 374, 10, 54, "Print"],
Cell[229288, 5567, 169, 3, 34, "Print"],
Cell[229460, 5572, 228, 4, 34, "Print"],
Cell[229691, 5578, 52, 1, 34, "Print"],
Cell[229746, 5581, 372, 10, 54, "Print"],
Cell[230121, 5593, 169, 3, 34, "Print"],
Cell[230293, 5598, 228, 4, 34, "Print"],
Cell[230524, 5604, 52, 1, 34, "Print"],
Cell[230579, 5607, 371, 10, 54, "Print"],
Cell[230953, 5619, 169, 3, 34, "Print"],
Cell[231125, 5624, 228, 4, 34, "Print"],
Cell[231356, 5630, 52, 1, 34, "Print"],
Cell[231411, 5633, 373, 10, 54, "Print"],
Cell[231787, 5645, 169, 3, 34, "Print"],
Cell[231959, 5650, 228, 4, 34, "Print"],
Cell[232190, 5656, 52, 1, 34, "Print"],
Cell[232245, 5659, 372, 10, 54, "Print"],
Cell[232620, 5671, 169, 3, 34, "Print"],
Cell[232792, 5676, 228, 4, 34, "Print"],
Cell[233023, 5682, 52, 1, 34, "Print"],
Cell[233078, 5685, 372, 10, 54, "Print"],
Cell[233453, 5697, 169, 3, 34, "Print"],
Cell[233625, 5702, 228, 4, 34, "Print"],
Cell[233856, 5708, 52, 1, 34, "Print"],
Cell[233911, 5711, 371, 10, 54, "Print"],
Cell[234285, 5723, 169, 3, 34, "Print"],
Cell[234457, 5728, 228, 4, 34, "Print"],
Cell[234688, 5734, 52, 1, 34, "Print"],
Cell[234743, 5737, 374, 10, 54, "Print"],
Cell[235120, 5749, 169, 3, 34, "Print"],
Cell[235292, 5754, 228, 4, 34, "Print"],
Cell[235523, 5760, 52, 1, 34, "Print"],
Cell[235578, 5763, 372, 10, 54, "Print"],
Cell[235953, 5775, 169, 3, 34, "Print"]
}, Open  ]],
Cell[236137, 5781, 187, 3, 47, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[236349, 5788, 209, 6, 58, "Input",
  InitializationCell->True],
Cell[236561, 5796, 2610, 54, 309, "Output"]
}, Open  ]],
Cell[239186, 5853, 385, 10, 123, "Text"],
Cell[239574, 5865, 2389, 77, 321, "Output"],

Cell[CellGroupData[{
Cell[241988, 5946, 273, 8, 98, "Input",
  InitializationCell->True],
Cell[242264, 5956, 8209, 419, 279, 7977, 413, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[250476, 6377, 130, 3, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[250633, 6384, 456, 10, 149, "Text"],

Cell[CellGroupData[{
Cell[251114, 6398, 495, 14, 338, "Input",
  InitializationCell->True],
Cell[251612, 6414, 10872, 718, 444, 10633, 712, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[262487, 7134, 130, 3, 40, "Output"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

