(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    231341,       4311]*)
(*NotebookOutlinePosition[    232346,       4346]*)
(*  CellTagsIndexPosition[    232302,       4342]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
CHR   20 April 1993
Final calculations for Figure 2 in the hydrodynamics paper... I leave the \
Garcia de la Torre results at the values already calculated (in Figure 2 \
data-- \"Garcia de la Torre Final\" or Cricket Graph file) and use my \
Kirkwood subroutine on radii and intersphere distances calculated for this \
example, which is particularly simple since the DNA is treated in the rigid \
limit.\
\>", "SmallText",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "2a0a6e22-83d7-42bb-87af-32bbc5311837"],

Cell["\<\
Notice that the Yamakawa and Fujii equation for the sedimentation \
behavior in the limit of an infinite persistence length (rigid rod) reduces \
to 3.620 (log[masstrue]-3.552) For Kovacic and van Holde's fit to the DNA \
data.\
\>", "SmallText",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "07cc8f0e-0494-4ec4-b2f8-3a26d6015466"],

Cell[TextData[{
  "CHR started 18 Feb 2020. Test of reproducibility for the ReScience 10-year \
reproducibility challenge (https://rescience.github.io/ten-years/). Chosen \
paper is Robert, C.H. (1995) Estimating Friction Coefficients of Mixed \
Globular/Chain Molecules, such as Protein/DNA Complexes. Biophys J. 69, \
840-48.\n\nAll code in this file came from the original notebooks \"Example 2 \
1-over-r.nb\" and \"Example 2 dinucleosomes.nb\" and run using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5.2 and 12.0.\nChanges:\n- lines were added to save results for lollipop \
and dumbbell assemblies and to plot them at the end of the notebook\n- \
semicolons at end of commands producing graphics were suppressed to see the \
output\n- removed the mysterious \"t=.\" command starting this notebook. A \
misprint? Or a sign of higher intelligence?\n\nResults to compare to \
originals are indicated by blue text boxes."
}], "Text",
  CellFrame->True,
  ExpressionUUID -> "70f864aa-41b5-45d4-aa48-14efe28c603b",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[0.833326]],

Cell["\<\
Off[General::spell];
Off[General::spell1];\
\>", "Input",
  PageBreakWithin->Automatic,
  GroupPageBreakWithin->Automatic,
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "1c861089-8971-4b93-aa83-d198f2a06979"],

Cell["\<\
NAvo=6.02 10^23;
ro=1.003;\t\t\t\t\t\t(* density, g/cm^3 *)
visc=0.01016;\t\t\t\t\t(* viscosity, g/(cm s) or \"Poise\" *)
persistencelength=34000 10^-8;\t(* persistence length, cm *)
el=3.4 10^-8;\t\t\t\t\t(* height of basepair, cm *)
lx={0,0,1};\t\t\t\t\t\t(* chain vector for a basepair *)
ctorsion=2.4 10^-19;\t\t\t(* not used-- ergs/radian? *)
mhistone=108500;\t\t\t\t(* octamer mol. weight, g/mole *)
mbp=660;\t\t\t\t\t\t(* basepair mol. weight, g/mole *)
vdna=0.55;\t\t\t\t\t\t(* specific volume of DNA, cm^3/g *)
vhistone=0.75;\t\t\t\t\t(* same but of protein, cm^3/g *)
score=10.7 10^-13;\t\t\t\t(* core sedimentation coeff, sec *)
dDNA=27 10^-8;\t\t\t\t\t(* Yamagawa-Fujii (Y-F) diam, cm *)
switchbp=50;\t\t\t\t\t(* point at which we switch from *)
\t\t\t\t\t\t\t\t(* Y-F to ellipsoid model, bp *)\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "977f2be0-ffa2-4f12-8b29-cd79a234905c"],

Cell["\<\
doKirkwoodG:=Block[{i,j,sum,sumradii},
\t(*\tCalculates friction and sedimentation coefficients, f1 and
\t\ts1, according to the standard Kirkwood-Riseman theory.\t*)
\tsumradii=Sum[radii[[i]],{i,ntot}];
\tsum=0;
\tDo[\tDo[\trirj=N[radii[[i]] radii[[j]]];
\t\t\tIf[\trirj>0,
\t\t\t\tdelsum=rirj/rij[[i,j]],
\t\t\t\tdelsum=0
\t\t\t];
\t\t\tIf[\ttest,
\t\t\t\tPrint[\"   i,j,rij(cm): \",i,\" \",j,\" \",N[rij[[i,j]]]]
\t\t\t];
\t\t\tsum=sum+delsum,
\t\t{j,i+1,ntot}],
\t{i,ntot}];
\t(* Notice we only counted the distance of each pair once,
\t   but we multiplied by two to make up for it.  Now calculate
\t   frictional coeff and convert from basepairs to cm: *)
\tffree=6 Pi visc sumradii g/s;
\tf1=6 Pi visc sumradii/(1 + 2 sum/sumradii) g/s;
\tPrint[\"   Kirkwood results: {f free-draining,f1}\"];
\tPrint[\"   \",N[{ffree,f1}]]
];\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "a3fc05c1-596d-4903-b136-5cbe08c3a53a"],

Cell["\<\
snaked[i_]:=Module[{j},
\ts1=3.620 (Log[10,i 660]-3.552) 10^-13;
\trstokes=((i 660) (1-vdna ro)/(NAvo s1))/(6 Pi visc)
];\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "62222df1-7473-4492-91cf-58976cb8aaf5"],

Cell["\<\
Define radii of rigid-model DNA spheres and of globular region in \
cm:\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "610c079a-48f2-4055-bd63-c1cc43fa2a31"],

Cell["\<\
r1=57 10^-8;
r2=16.534 10^-8; (*\tEqual volume achieved
\t\t\t\t\tby r2=Sqrt[3/2] 13.5 A *)\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "c67f137b-eb9a-4295-8cbe-6a4233622174"],

Cell["Values of the ratio L = length/r1 to use in the comparison.", "Text",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "db9d08d1-9e8b-417e-a737-2c8957138ca8"],

Cell["\<\
(*\tValues of length/r1 to use in comparison and corresponding
\tnumbers of basepairs: *)
lengthp={3,4,5,6,8,10,12,14,16};
nbasepairs=(lengthp r1)/(3.4 10^-8);\
\>", "Input",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "153c6721-d0ea-40b6-8c57-3c89c16d393c"],

Cell[CellGroupData[{

Cell["nbasepairs", "Input",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "dff6ad5f-2314-4407-b946-e22830ae080a"],

Cell[BoxData[
    \({50.29411764705882`, 67.05882352941177`, 83.8235294117647`, 
      100.58823529411764`, 134.11764705882354`, 167.6470588235294`, 
      201.17647058823528`, 234.70588235294116`, 
      268.2352941176471`}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(test = False;\)\)], "Input",
  ExpressionUUID -> "8804ab71-13ed-464a-a4ac-6a70c4a62bd2"],

Cell[TextData[StyleBox["LOLLIPOPS",
  FontFamily->"Geneva",
  FontSize->14]], "Text",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "8d8c80bd-811f-4bde-8704-5040ab27573c"],

Cell[CellGroupData[{

Cell["\<\
f1Kirk={};
f1robert={};
frictionratio={};
rij={};
Do[
\tPrint[nbasepairs[[k]],\" bp spacer\"];
\t
\tPrint[\"My model:\"];
\tntot=2;
\tsnaked[nbasepairs[[k]]];
\tradii={r1,rstokes};
\trij={{0,r1 + lengthp[[k]] r1/2},{r1 + lengthp[[k]] r1/2,0}};
\tdoKirkwoodG;
\tf1robert=Append[f1robert,f1];

\tPrint[\"Kirk's model:\"];\t
\tntot=lengthp[[k]]+1;
\tradii={r1};
\tDo[radii=Append[radii,r2],{i,lengthp[[k]]}];
\trij=Table[0,{i,ntot},{j,ntot}];
\tDo[ Do[\t
\t\t\trij[[i,j]]=radii[[i]] + (j-i-1) 2 r2 + r2,
\t\t{j,i+1,ntot}],
\t{i,ntot}];
\tdoKirkwoodG;
\tf1Kirk=Append[f1Kirk,N[f1]],

{k,Length[lengthp]}];\
\>", "Input",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "a9134c89-3784-460e-9780-6fd109d8f463"],

Cell[BoxData[
    InterpretationBox[\(50.29411764705882`\[InvisibleSpace]" bp spacer"\),
      SequenceForm[ 50.294117647058819, " bp spacer"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("My model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(1.7963443598900903`*^-7\ g\)\
\/s, \(1.3672367749476332`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 1.7963443598900903*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.3672367749476332*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Kirk's model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(2.0415507661134405`*^-7\ g\)\
\/s, \(1.0629414798301575`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 2.0415507661134405*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.0629414798301575*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(67.05882352941177`\[InvisibleSpace]" bp spacer"\),
      SequenceForm[ 67.058823529411768, " bp spacer"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("My model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(1.923943874264986`*^-7\ \
g\)\/s, \(1.4932693345698687`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 1.9239438742649861*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.4932693345698687*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Kirk's model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(2.3581958606418703`*^-7\ g\)\
\/s, \(1.1061862133255019`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 2.3581958606418703*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.1061862133255019*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(83.8235294117647`\[InvisibleSpace]" bp spacer"\),
      SequenceForm[ 83.823529411764696, " bp spacer"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("My model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(2.0473628117810054`*^-7\ g\)\
\/s, \(1.6162281809839142`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 2.0473628117810054*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.6162281809839142*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Kirk's model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(2.6748409551702996`*^-7\ g\)\
\/s, \(1.1579215268571271`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 2.6748409551702996*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.1579215268571271*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(100.58823529411764`\[InvisibleSpace]" bp spacer"\),
      SequenceForm[ 100.58823529411764, " bp spacer"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("My model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(2.1670113313068928`*^-7\ g\)\
\/s, \(1.7362080970893917`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 2.1670113313068928*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.7362080970893917*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Kirk's model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(2.991486049698729`*^-7\ \
g\)\/s, \(1.214287117893351`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 2.9914860496987289*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.2142871178933511*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(134.11764705882354`\[InvisibleSpace]" bp spacer"\),
      SequenceForm[ 134.11764705882354, " bp spacer"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("My model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(2.3970601528697356`*^-7\ g\)\
\/s, \(1.9682867019165014`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 2.3970601528697356*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.9682867019165014*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Kirk's model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(3.624776238755588`*^-7\ \
g\)\/s, \(1.3337841072825942`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 3.624776238755588*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.3337841072825942*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(167.6470588235294`\[InvisibleSpace]" bp spacer"\),
      SequenceForm[ 167.64705882352939, " bp spacer"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("My model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(2.617426214541176`*^-7\ \
g\)\/s, \(2.1915722001004071`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 2.617426214541176*^-07, g, 
          Power[ s, -1]], 
        Times[ 2.1915722001004071*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Kirk's model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(4.258066427812447`*^-7\ \
g\)\/s, \(1.4569452943609176`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 4.2580664278124471*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.4569452943609176*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(201.17647058823528`\[InvisibleSpace]" bp spacer"\),
      SequenceForm[ 201.17647058823528, " bp spacer"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("My model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(2.8303111252001224`*^-7\ g\)\
\/s, \(2.407714246175438`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 2.8303111252001224*^-07, g, 
          Power[ s, -1]], 
        Times[ 2.407714246175438*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Kirk's model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(4.891356616869307`*^-7\ \
g\)\/s, \(1.580960911565478`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 4.8913566168693068*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.5809609115654781*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(234.70588235294116`\[InvisibleSpace]" bp spacer"\),
      SequenceForm[ 234.70588235294116, " bp spacer"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("My model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(3.037191121350788`*^-7\ \
g\)\/s, \(2.617938782889637`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 3.0371911213507881*^-07, g, 
          Power[ s, -1]], 
        Times[ 2.617938782889637*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Kirk's model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(5.524646805926166`*^-7\ \
g\)\/s, \(1.7046702109509283`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 5.5246468059261664*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.7046702109509283*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(268.2352941176471`\[InvisibleSpace]" bp spacer"\),
      SequenceForm[ 268.23529411764707, " bp spacer"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("My model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(3.239103721097575`*^-7\ \
g\)\/s, \(2.823164720967342`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 3.2391037210975749*^-07, g, 
          Power[ s, -1]], 
        Times[ 2.823164720967342*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Kirk's model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(6.157936994983026`*^-7\ \
g\)\/s, \(1.8275658908281284`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 6.1579369949830261*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.8275658908281284*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"]
}, Open  ]],

Cell["\<\
CHR Feb 2020. Lollipop geometry friction coefficients are identical \
to the corresponding results in \"Figure 2 calculations.nb\" with the \
exception of the number of reported significant figures (6 here versus 4 in \
the original). The 1st and 3rd columns of figures were plotted as the solid \
lines in Figure 2. (The dotted lines and black circles in Figure 2 were \
obtained from previous work.)\
\>", "Text",
  CellFrame->True,
  ExpressionUUID -> "d2e49376-16a4-40ea-aec1-16792c2d4981",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[0.833326]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[
      Transpose[{N[nbasepairs, 3], N[f1robert, 4], N[f1Kirk, 4]}]]\)], "Input",\

  ExpressionUUID -> "edf8556d-39a3-451c-bbf2-367780a4d7ef"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {
              "50.29411764705882`", \(\(1.3672367749476332`*^-7\ g\)\/s\), \(\
\(1.0629414798301575`*^-7\ g\)\/s\)},
            {
              "67.05882352941177`", \(\(1.4932693345698687`*^-7\ g\)\/s\), \(\
\(1.1061862133255019`*^-7\ g\)\/s\)},
            {
              "83.8235294117647`", \(\(1.6162281809839142`*^-7\ g\)\/s\), \
\(\(1.1579215268571271`*^-7\ g\)\/s\)},
            {
              "100.58823529411764`", \(\(1.7362080970893917`*^-7\ g\)\/s\), \
\(\(1.214287117893351`*^-7\ g\)\/s\)},
            {
              "134.11764705882354`", \(\(1.9682867019165014`*^-7\ g\)\/s\), \
\(\(1.3337841072825942`*^-7\ g\)\/s\)},
            {
              "167.6470588235294`", \(\(2.1915722001004071`*^-7\ g\)\/s\), \(\
\(1.4569452943609176`*^-7\ g\)\/s\)},
            {
              "201.17647058823528`", \(\(2.407714246175438`*^-7\ g\)\/s\), \(\
\(1.580960911565478`*^-7\ g\)\/s\)},
            {
              "234.70588235294116`", \(\(2.617938782889637`*^-7\ g\)\/s\), \(\
\(1.7046702109509283`*^-7\ g\)\/s\)},
            {
              "268.2352941176471`", \(\(2.823164720967342`*^-7\ g\)\/s\), \
\(\(1.8275658908281284`*^-7\ g\)\/s\)}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(\(\(xLollipop = nbasepairs;\)\[IndentingNewLine]
    \(yLollipop = f1robert;\)\ \[IndentingNewLine]
    \(yLollipop2 = f1Kirk;\)\)\(\ \)\)\)], "Input",
  CellFrame->True,
  ExpressionUUID -> "84c8bb8c-1c6d-4ba0-91ba-586260321b16",
  Background->GrayLevel[0.833326]],

Cell["\<\
Copy-paste the original output here for comparison. The \
recalculated results match to all significant figures.\
\>", "Text",
  CellFrame->True,
  ExpressionUUID -> "b9a9c1f7-8c41-446e-bbfe-ed757de131a4",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[0.833326]],

Cell[GraphicsData["PostScript", "\<\
%!PS-Adobe-2.0 EPSF-1.2
%%BoundingBox: 18 18 349 356
%%HiResBoundingBox: 18.375 18.375 348.375 355.875
%%Creator: (Mathematica 5.2 for Macintosh)
%%CreationDate: (Sunday, March 29, 2020) (19:18:16)
%%Title: Clipboard
%%DocumentNeededResources: (atend)
%%DocumentFonts: (atend)
%%DocumentNeededFonts: (atend)
%%EndComments
0 374.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def

%%MathematicaCell
%Cell[GraphicsData[\"PICT\", \\
%\"\\<\\
%24X04`0X0?@1100A0_l<0?ooool0:00001<\\
%000440000m0000000000N00402P0C
%02P0m09@02`02P0F1d=_MG9YIG800`0F00d02@0^00@0000002/Y6bPP820P820P
%820P820P820P820P820P82dg820P820P820P820P82dg000Z1BXP820P820P820P
%820P820a;S<f=b0a<20P86LP820a;S0f<b0a<20P86L0:PDZ820P820P820P820P
%820P;Bd];Bd];Bd];Bd]820P;Bd];Bd];Bd];Bd]02T2:R0P820P820P820P820P
%82d];Bd];Bd];Bd]820P82d];Bd];Bd];Bd]800X02X0:B@e<2hc820P820P820P
%820P820P87<P820P820P820P820P87<002X::20P820P820P820P820P820P820P
%820P;CLP820P820P820P820P;CL0:PDZ820P820P820P820P820P<Bhd>C<P<C0P
%821W820P<Bha<3HP<C0P821W02X5:R0P820P820P820P820P82d];Bd];Bd];Bd]
%;B0P82d];Bd];Bd];Bd];@0Y0RXP820P820P820P820P820];Bd];Bd];Bd];B0P
%820];Bd];Bd];Bd];B00:01302TT=SL^<B0P820P820P820P820P821c820P820P
%820P820P821c000Z2RPP820P820P820P820P820P820P820P82dg820P820P820P
%820P82dg02X5:R0P820P820P820P820P834^=S4f834`820PIb0P834^<CDh834`
%820PI`0Z1BXP820P820P820P820P820];Bd];Bd];Bd];BdP820];Bd];Bd];Bd]
%;Bd0:@8Z820P820P820P820P820P;Bd];Bd];Bd];BdP820P;Bd];Bd];Bd];BdP
%02P0G00Y93Pc;SPP820P820P820P820P820PLb0P820P820P820P820PL`00:PXX
%820P820P820P820P820P820P820P820]=b0P820P820P820P820]=`0Z1BXP820P
%820P820P820P820a;SLc=R0a<20P86LP820a;S8a=20a<20P86L0:PDZ820P820P
%820P820P820P;Bd];Bd];Bd];Bd]820P;Bd];Bd];Bd];Bd]02T2:R0P820P820P
%820P820P82d];Bd];Bd];Bd]820P82d];Bd];Bd];Bd]800X07D0:B@a<34^820P
%820P820P820P820P87<P820P820P820P820P87<002X::20P820P820P820P820P
%820P820P820P;CLP820P820P820P820P;CL0:PDZ820P820P820P820P820P<Bhi
%=SPP<C0P821W820P<Bhc<c@P<C0P821W02X5:R0P820P820P820P820P82d];Bd]
%;Bd];Bd];B0P82d];Bd];Bd];Bd];@0Y0RXP820P820P820P820P820];Bd];Bd]
%;Bd];B0P820];Bd];Bd];Bd];B00:02>02TT<C<d;R0P820P820P820P820P821c
%820P820P820P820P821c000Z2RPP820P820P820P820P820P820P820P82dg820P
%820P820P820P82dg02X5:R0P820P820P820P820P838^<CTb834`820PIb0P834^
%=3Dg834`820PI`0Z1BXP820P820P820P820P820];Bd];Bd];Bd];BdP820];Bd]
%;Bd];Bd];Bd0:@8Z820P820P820P820P820P;Bd];Bd];Bd];BdP820P;Bd];Bd]
%;Bd];BdP02P0Y`0Y934f>2hP820P820P820P820P820PLb0P820P820P820P820P
%L`00:PXX820P820P820P820P820P820P820P820]=b0P820P820P820P820]=`0Z
%1BXP820P820P820P820P820b;S@`>20a<20P86LP820a;SDh<B0a<20P86L0:PDZ
%820P820P820P820P820P;Bd];Bd];Bd];Bd]820P;Bd];Bd];Bd];Bd]02T2:R0P
%820P820P820P820P82d];Bd];Bd];Bd]820P82d];Bd];Bd];Bd]800X0<00:B@b
%<34^820P820P820P820P820P87<P820P820P820P820P87<002X::20P820P820P
%820P820P820P820P820P;CLP820P820P820P820P;CL0:PDZ820P820P820P820P
%820P<Rhf<CPP<C0P821W820P<Bhg<3DP<C0P821W02X5:R0P820P820P820P820P
%82d];Bd];Bd];Bd];B0P82d];Bd];Bd];Bd];@0Y0RXP820P820P820P820P820]
%;Bd];Bd];Bd];B0P820];Bd];Bd];Bd];B00:03I02TT<S<e;R0P820P820P820P
%820P821c820P820P820P820P821c000Z2RPP820P820P820P820P820P820P820P
%82dg820P820P820P820P82dg02X5:R0P820P820P820P820P838^>38c834`820P
%Ib0P834^>38h834`820PI`0Z1BXP820P820P820P820P820];Bd];Bd];Bd];BdP
%820];Bd];Bd];Bd];Bd0:@8Z820P820P820P820P820P;Bd];Bd];Bd];BdP820P
%;Bd];Bd];Bd];BdP02P0lP0Y938f>2hP820P820P820P820P820PLb0P820P820P
%820P820PL`00o`\\>\"], \"Graphics\",
%  CellFrame->True,
%  ImageSize->{220, 225},
%  ImageMargins->{{0, Inherited}, {Inherited, Inherited}},
%  ImageRegion->{{-0, 1}, {0, 1}},
%  FontSize->9,
%  Background->GrayLevel[0.833326]]
%%EndMathematicaCell
0.833 0.833 0.833 setrgbcolor
newpath
 6.000 367.250 moveto
 1242.438 367.250 lineto
 1242.438 6.000 lineto
 6.000 6.000 lineto
 6.000 367.250 lineto
closepath
fill
0.000 0.000 0.000 setrgbcolor
1.5 setlinewidth
/Courier findfont 9 scalefont setfont
20 30 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 38 moveto (               1.367 10   g   1.063 10   g) show
/Courier findfont 9 scalefont setfont
20 45 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 45 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 53 moveto (50.3                s              s) show
/Courier findfont 9 scalefont setfont
20 68 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 75 moveto (               1.493 10   g   1.106 10   g) show
/Courier findfont 9 scalefont setfont
20 83 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 83 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 90 moveto (67.1                s              s) show
/Courier findfont 9 scalefont setfont
20 105 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 113 moveto (               1.616 10   g   1.158 10   g) show
/Courier findfont 9 scalefont setfont
20 120 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 120 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 128 moveto (83.8                s              s) show
/Courier findfont 9 scalefont setfont
20 143 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 150 moveto (               1.736 10   g   1.214 10   g) show
/Courier findfont 9 scalefont setfont
20 158 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 158 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 165 moveto (101.                s              s) show
/Courier findfont 9 scalefont setfont
20 180 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 187 moveto (               1.968 10   g   1.334 10   g) show
/Courier findfont 9 scalefont setfont
20 195 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 195 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 202 moveto (134.                s              s) show
/Courier findfont 9 scalefont setfont
20 217 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 225 moveto (               2.192 10   g   1.457 10   g) show
/Courier findfont 9 scalefont setfont
20 232 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 232 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 240 moveto (168.                s              s) show
/Courier findfont 9 scalefont setfont
20 255 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 262 moveto (               2.408 10   g   1.581 10   g) show
/Courier findfont 9 scalefont setfont
20 270 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 270 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 277 moveto (201.                s              s) show
/Courier findfont 9 scalefont setfont
20 292 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 300 moveto (               2.618 10   g   1.705 10   g) show
/Courier findfont 9 scalefont setfont
20 307 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 307 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 315 moveto (235.                s              s) show
/Courier findfont 9 scalefont setfont
20 330 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 337 moveto (               2.823 10   g   1.828 10   g) show
/Courier findfont 9 scalefont setfont
20 345 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 345 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 352 moveto (268.                s              s) show
%%Trailer
%%EOF
\
\>"], "Graphics",
  CellFrame->True,
  Evaluatable->False,
  ImageSize->{331, 338},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "6b67c8a3-ac97-47b5-903b-3887c37d4673",
  FontSize->9,
  Background->GrayLevel[0.833326],
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007`0001nb000`400?l00000o`00003ooooEeMGa
omGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGa
omGEe@00oooEeMGaomGEe@001?oEeMD6o`0000CoeMGE0_l00005omGEe@Co00001OoEeMD00ol0003o
eMGEomGEe@23omGEe@Go0000LooEeMD5o`000<ooeMGE0004omGEe@03o`000?oEeMGoeMGE00;oeMGE
00Go0000omGEeOoEeMGoeMGEo`000002omGEe@05o`000?oEeMGoeMGEomGEeOl000001?oEeMD00ol0
003oeMGEomGEe@28omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0L?oEeMD00ol0
003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE0<coeMGE0005omGEe@03o`000?oEeMGoeMGE00Co
eMGE00?o0000omGEeOoEeMD00_oEeMD01?l0003oeMGEomGEeOl00004omGEe@03o`000?oEeMGoeMGE
08goeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@3<omGEe@001_oEeMD00ol0003o
eMGEomGEe@03omGEe@03o`000?oEeMGoeMGE00;oeMGE00Co0000omGEeOoEeMGo00001?oEeMD00ol0
003oeMGEomGEe@29omGEe@Co0000M?oEeMD4o`000<ooeMGE0007omGEe@03o`000?oEeMGoeMGE00;o
eMGE0_l00002omGEe@03o`000?oEeMGoeMGE00;oeMGE1?l0002;omGEe@03o`000?oEeMGoeMGE07Go
eMGE00?o0000omGEeOoEeMD0dOoEeMD000SoeMGE00Ko0000omGEeOoEeMGoeMGEo`000?oEeMD2o`00
00CoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@28omGEe@03o`000?oEeMGoeMGE
00;oeMGE00?o0000omGEeOoEeMD0L?oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE
0<coeMGE0009omGEe@04o`000?oEeMGoeMGEo`0000OoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0
003oeMGEomGEe@29omGEe@Go0000LooEeMD5o`000<koeMGE0004omGEe@03o`000?oEeMGoeMGE00;o
eMGE00Go0000omGEeOoEeMGoeMGEo`000006omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGE
eOoEeMD0oooEeMGEomGEe@001OoEeMD4o`0000GoeMGE0_l00005omGEe@Co0000oooEeMGHomGEe@00
oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00NooEeMEOo`0001Wo
eMGEGol0002NomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGE
e@00oooEeMGaomGEe@00eOoEeMD3o`0007GoeMGE0ol0002PomGEe@00f?oEeMD00ol0003oeMGEomGE
e@1eomGEe@03o`000?oEeMGoeMGE09goeMGE003IomGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000
omGEeOoEeMD0W?oEeMD007coeMGE1_l00004omGEe@03o`000?oEeMGoeMGE00CoeMGE1?l00003omGE
e@Ko00000ooEeMD4o`0000_oeMGE1Ol00004omGEe@?o00007OoEeMD3o`000003omGEeOl0003oeMGE
01WoeMGE1Ol00005omGEe@03o`000?oEeMGoeMGE00CoeMGE1?l00003omGEe@Ko00000ooEeMD4o`00
00_oeMGE1Ol00004omGEe@?o00007OoEeMD3o`000003omGEeOl0003oeMGE09goeMGE001lomGEe@03
o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD02?oEeMD00ol0003oeMGEomGEe@02omGEe@04
o`000?oEeMGoeMGEo`0000CoeMGE00Co0000omGEeOoEeMGo00001?oEeMD00ol0003oeMGEomGEe@0:
omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000KomGEe@04o`000?oE
eMGoeMGEomGEe@;o00007?oEeMD00ol0003oeMGEomGEe@0;omGEe@03o`000?oEeMGoeMGE00;oeMGE
00Co0000omGEeOoEeMGo00001?oEeMD01?l0003oeMGEomGEeOl00004omGEe@03o`000?oEeMGoeMGE
00[oeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001_oeMGE00Co0000
omGEeOoEeMGoeMGE0_l0002NomGEe@00OOoEeMD00ol0003oeMGEomGEe@0<omGEe@03o`000?oEeMGo
eMGE00;oeMGE00Go0000omGEeOoEeMGoeMGEo`00000;omGEe@03o`000?oEeMGoeMGE00[oeMGE00?o
0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001[oeMGE00?o0000omGEeOoEeMD0
0ooEeMD00ol0003oeMGEomGEe@0JomGEe@03o`000?oEeMGoeMGE00_oeMGE00?o0000omGEeOoEeMD0
0_oEeMD01Ol0003oeMGEomGEeOoEeMGo000000KoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003o
eMGEomGEe@0:omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000JomGE
e@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD0W?oEeMD007koeMGE00?o0000omGEeOoE
eMD02ooEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoE
eMD02?oEeMD00ol0003oeMGEomGEe@0:omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoE
eMGoeMGEo`00000JomGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD06_oEeMD00ol0
003oeMGEomGEe@0;omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0
003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD02_oEeMD00ol0
003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006_oEeMD00ol0003oeMGEomGEe@03
omGEe@03o`000?oEeMGoeMGE09coeMGE001oomGEe@03o`000?oEeMGoeMGE00_oeMGE1?l00006omGE
e@03o`000?oEeMGoeMGE00CoeMGE0ol0000=omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGE
eOoEeMGoeMGEo`00000JomGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD06_oEeMD0
0ol0003oeMGEomGEe@0<omGEe@Co00001_oEeMD00ol0003oeMGEomGEe@03omGEe@Co00003OoEeMD0
0ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006_oEeMD00ol0003oeMGEomGE
e@03omGEe@03o`000?oEeMGoeMGE09coeMGE0020omGEe@03o`000?oEeMGoeMGE00WoeMGE00?o0000
omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@04omGEe@03o`000?oEeMGoeMGE00KoeMGE00?o0000
omGEeOoEeMD02_oEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006ooE
eMD01?l0003oeMGEomGEeOoEeMD2o`0001coeMGE00?o0000omGEeOoEeMD02ooEeMD00ol0003oeMGE
omGEe@02omGEe@03o`000?oEeMGoeMGE00CoeMGE00Go0000omGEeOoEeMGoeMGEo`000004omGEe@03
o`000?oEeMGoeMGE00[oeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo0000
01_oeMGE00Co0000omGEeOoEeMGoeMGE0_l0002NomGEe@00POoEeMD00ol0003oeMGEomGEe@08omGE
e@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD01OoEeMD00ol0003oeMGEomGEe@05omGE
e@03o`000?oEeMGoeMGE00SoeMGE00?o0000omGEeOl000001OoEeMD01Ol0003oeMGEomGEeOoEeMGo
000001coeMGE0ol000000ooEeMGo0000omGEe@0IomGEe@03o`000?oEeMGo000000goeMGE00?o0000
omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@05omGEe@04o`000?oEeMGoeMGEo`0000CoeMGE00?o
0000omGEeOoEeMD02?oEeMD00ol0003oeMGEo`000005omGEe@05o`000?oEeMGoeMGEomGEeOl00000
7?oEeMD3o`000003omGEeOl0003oeMGE09goeMGE001lomGEe@03o`000?oEeMGoeMGE00;oeMGE00?o
0000omGEeOoEeMD02?oEeMD00ol0003oeMGEomGEe@02omGEe@04o`000?oEeMGoeMGEo`0000CoeMGE
00Co0000omGEeOoEeMGo00001?oEeMD00ol0003oeMGEomGEe@09omGEe@;o00001OoEeMD01Ol0003o
eMGEomGEeOoEeMGo000003coeMGE0_l0000=omGEe@03o`000?oEeMGoeMGE00;oeMGE00Co0000omGE
eOoEeMGo00001?oEeMD01?l0003oeMGEomGEeOl00004omGEe@03o`000?oEeMGoeMGE00WoeMGE0_l0
0005omGEe@05o`000?oEeMGoeMGEomGEeOl00000_ooEeMD007goeMGE1?l0000<omGEe@Co00001?oE
eMD4o`0000CoeMGE1?l0000=omGEe@03o`000?oEeMGoeMGE00CoeMGE0ol0000nomGEe@03o`000?oE
eMGoeMGE00coeMGE1?l00004omGEe@Co00001?oEeMD4o`0000goeMGE00?o0000omGEeOoEeMD01?oE
eMD3o`000<3oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE0036omGEe@03o`000?oEeMGoeMGE07Go
eMGE00?o0000omGEeOoEeMD0[ooEeMD00<KoeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGE
omGEe@2_omGEe@00aooEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE0:koeMGE002k
omGEe@Oo00001OoEeMD00ol0003oeMGEomGEe@1YomGEe@Oo00001OoEeMD00ol0003oeMGEomGEe@2^
omGEe@00b?oEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE0:goeMGE0038omGEe@03
o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0[OoEeMD00<WoeMGE00?o0000omGEeOoEeMD0
MOoEeMD00ol0003oeMGEomGEe@2/omGEe@00a?oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oE
eMGoeMGE073oeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@2/omGEe@00a?oEeMD6
o`0007;oeMGE1_l0002^omGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooE
eMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooE
eMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@001?oE
eMD6o`0000?oeMGE1?l00004omGEe@?o00001_oEeMD00ol0003oeMGEomGEe@23omGEe@Go0000LooE
eMD5o`000<ooeMGE0004omGEe@03o`000?oEeMGoeMGE00;oeMGE00Co0000omGEeOoEeMGo00001?oE
eMD01?l0003oeMGEomGEeOl00003omGEe@03o`000?oEeMGoeMGE08WoeMGE00?o0000omGEeOoEeMD0
0_oEeMD00ol0003oeMGEomGEe@1`omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0
c?oEeMD000GoeMGE00?o0000omGEeOoEeMD02OoEeMD00ol0003oeMGEomGEe@05omGEe@03o`000?oE
eMGoeMGE08goeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@3<omGEe@001_oEeMD0
0ol0003oeMGEomGEe@08omGEe@03o`000?oEeMGoeMGE00GoeMGE00?o0000omGEeOoEeMD0ROoEeMD4
o`0007CoeMGE1?l0003?omGEe@001ooEeMD00ol0003oeMGEomGEe@04omGEe@?o00001ooEeMD00ol0
003oeMGEomGEe@29omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0dOoEeMD000So
eMGE00?o0000omGEeOoEeMD01_oEeMD00ol0003oeMGEomGEe@04o`0008coeMGE00?o0000omGEeOoE
eMD00_oEeMD00ol0003oeMGEomGEe@1`omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoE
eMD0c?oEeMD000WoeMGE00?o0000omGEeOoEeMD01OoEeMD01?l0003oeMGEomGEeOl0002@omGEe@Go
0000LooEeMD5o`000<koeMGE0004omGEe@03o`000?oEeMGoeMGE00;oeMGE00Co0000omGEeOoEeMGo
00001?oEeMD01?l0003oeMGEomGEeOl0003oomGEeMcoeMGE0005omGEe@Co00001?oEeMD4o`0000?o
eMGE1_l0003oomGEeMOoeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGE
eO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE001komGEeEoo00006OoEeMEOo`0009koeMGE003o
omGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003EomGEe@?o0000MOoE
eMD3o`000:3oeMGE003HomGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0WOoEeMD0
0=WoeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2LomGEe@00O?oEeMD6o`0000Co
eMGE00?o0000omGEeOoEeMD01OoEeMD2o`0000CoeMGE1Ol00004omGEe@Co00002ooEeMD5o`0000Co
eMGE0ol0000MomGEe@?o000000?oeMGEo`000?oEeMD06OoEeMD5o`0000GoeMGE00?o0000omGEeOoE
eMD01OoEeMD00ol0003oeMGEomGEe@04omGEe@?o00001OoEeMD3o`0000coeMGE1Ol00004omGEe@?o
00007OoEeMD3o`000003omGEeOl0003oeMGE09goeMGE001lomGEe@03o`000?oEeMGoeMGE00;oeMGE
00?o0000omGEeOoEeMD02OoEeMD01?l0003oeMGEomGEeOl00005omGEe@03o`000?oEeMGoeMGE00?o
eMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@0:omGEe@03o`000?oEeMGoeMGE00?o
eMGE00Go0000omGEeOoEeMGoeMGEo`00000KomGEe@04o`000?oEeMGoeMGEomGEe@;o00007?oEeMD0
0ol0003oeMGEomGEe@0=omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00
0003omGEe@05o`000?oEeMGoeMGEomGEeOl000003OoEeMD00ol0003oeMGEomGEe@03omGEe@05o`00
0?oEeMGoeMGEomGEeOl000006ooEeMD01?l0003oeMGEomGEeOoEeMD2o`0009koeMGE001momGEe@03
o`000?oEeMGoeMGE00coeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@02omGEe@03
o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@0:omGEe@03
o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03o`000?oEeMGoeMGE
00?oeMGE00?o0000omGEeOoEeMD06_oEeMD00ol0003oeMGEomGEe@0>omGEe@03o`000?oEeMGoeMGE
00;oeMGE00Go0000omGEeOoEeMGoeMGEo`000008omGEe@03o`000?oEeMGoeMGE00[oeMGE00?o0000
omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001[oeMGE00?o0000omGEeOoEeMD00ooE
eMD00ol0003oeMGEomGEe@2LomGEe@00O_oEeMD00ol0003oeMGEomGEe@0;omGEe@03o`000?oEeMGo
eMGE00;oeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGo
eMGE00;oeMGE00?o0000omGEeOoEeMD02_oEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGo
eMGEomGEeOl000006_oEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE01[oeMGE00?o
0000omGEeOoEeMD03_oEeMD00ol0003oeMGEomGEe@02omGEe@05o`000?oEeMGoeMGEomGEeOl00000
2?oEeMD00ol0003oeMGEomGEe@0:omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGo
eMGEo`00000JomGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD0W?oEeMD007ooeMGE
00?o0000omGEeOoEeMD02_oEeMD2o`0000;oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGE
omGEe@04omGEe@Co00003OoEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl0
00006_oEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE01[oeMGE00?o0000omGEeOoE
eMD03ooEeMD01Ol0003oeMGEomGEeOoEeMGo000000?oeMGE00?o0000omGEeOoEeMD01OoEeMD00ol0
003oeMGEomGEe@0;omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000J
omGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD0W?oEeMD0083oeMGE00?o0000omGE
eOoEeMD02OoEeMD01?l0003oeMGEo`000?l00006omGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000
omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@0:omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000
omGEeOoEeMGoeMGEo`00000KomGEe@04o`000?oEeMGoeMGEomGEe@;o00007?oEeMD00ol0003oeMGE
omGEe@0?omGEe@05o`000?oEeMGoeMGEomGEeOl000000ooEeMD01?l0003oeMGEomGEeOoEeMD4o`00
00koeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001_oeMGE00Co0000
omGEeOoEeMGoeMGE0_l0002NomGEe@00POoEeMD00ol0003oeMGEomGEe@08omGEe@03o`000?oEeMGo
eMGE00GoeMGE00?o0000omGEeOl000001OoEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGo
eMGE00SoeMGE00?o0000omGEeOl000001OoEeMD01Ol0003oeMGEomGEeOoEeMGo000001coeMGE0ol0
00000ooEeMGo0000omGEe@0IomGEe@03o`000?oEeMGo000001;oeMGE00Co0000omGEeOoEeMGo0000
0ooEeMD01Ol0003oeMGEomGEeOoEeMGo000000ooeMGE00?o0000omGEeOl000001OoEeMD01Ol0003o
eMGEomGEeOoEeMGo000001coeMGE0ol000000ooEeMGo0000omGEe@2MomGEe@00O?oEeMD00ol0003o
eMGEomGEe@02omGEe@03o`000?oEeMGoeMGE00WoeMGE00?o0000omGEeOoEeMD01OoEeMD2o`0000Go
eMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@09omGEe@;o00001OoEeMD01Ol0003o
eMGEomGEeOoEeMGo000003coeMGE0_l0000=omGEe@03o`000?oEeMGoeMGE00;oeMGE00Co0000omGE
eOoEeMGo00000ooEeMD01Ol0003oeMGEomGEeOoEeMGo0000013oeMGE0_l00005omGEe@05o`000?oE
eMGoeMGEomGEeOl00000_ooEeMD007goeMGE1?l0000=omGEe@;o00001_oEeMD00ol0003oeMGEomGE
e@04omGEe@Co00003OoEeMD00ol0003oeMGEomGEe@04omGEe@?o0000?_oEeMD00ol0003oeMGEomGE
e@0;omGEe@Ko00000ooEeMD3o`0000CoeMGE1_l0000<omGEe@03o`000?oEeMGoeMGE00CoeMGE0ol0
0030omGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00a_oEeMD00ol0003oeMGE
omGEe@1eomGEe@03o`000?oEeMGoeMGE0:ooeMGE0036omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o
0000omGEeOoEeMD0[ooEeMD00<OoeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2^
omGEe@00^ooEeMD7o`0000GoeMGE00?o0000omGEeOoEeMD0JOoEeMD7o`0000GoeMGE00?o0000omGE
eOoEeMD0[_oEeMD00<SoeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2]omGEe@00
b?oEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE0:goeMGE0039omGEe@03o`000?oE
eMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0[?oEeMD00<CoeMGE00?o0000omGEeOoEeMD00_oEeMD0
0ol0003oeMGEomGEe@1`omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0[?oEeMD0
0<CoeMGE1_l0001bomGEe@Ko0000[_oEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoE
eMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoE
eMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoE
eMD000CoeMGE1_l00003omGEe@?o00001?oEeMD5o`0000GoeMGE00?o0000omGEeOoEeMD0PooEeMD5
o`0007?oeMGE1Ol0003?omGEe@001?oEeMD00ol0003oeMGEomGEe@02omGEe@04o`000?oEeMGoeMGE
o`0000?oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@2;omGEe@03o`000?oEeMGo
eMGE00;oeMGE00?o0000omGEeOoEeMD0L?oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGo
eMGE0<coeMGE0005omGEe@03o`000?oEeMGoeMGE00CoeMGE00Go0000omGEeOoEeMGoeMGEo`000005
omGEe@03o`000?oEeMGoeMGE093oeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@3<
omGEe@001_oEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000001OoEeMD0
0ol0003oeMGEomGEe@2<omGEe@Co0000M?oEeMD4o`000<ooeMGE0007omGEe@03o`000?oEeMGoeMGE
00;oeMGE00Go0000omGEeOoEeMGoeMGEo`000005omGEe@03o`000?oEeMGoeMGE08_oeMGE00?o0000
omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@3AomGEe@002?oEeMD01Ol0003oeMGEomGEeOoEeMGo
000000?oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@2;omGEe@03o`000?oEeMGo
eMGE00;oeMGE00?o0000omGEeOoEeMD0L?oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGo
eMGE0<coeMGE0009omGEe@04o`000?oEeMGoeMGEo`0000?oeMGE00Oo0000omGEeOoEeMGoeMGEo`00
0?oEeMGo000008koeMGE1Ol0001comGEe@Go0000c_oEeMD000CoeMGE00?o0000omGEeOoEeMD00_oE
eMD01?l0003oeMGEomGEeOl00003omGEe@03o`000?oEeMGoeMGE00;oeMGE0_l0003oomGEeM[oeMGE
0005omGEe@Co00001?oEeMD3o`0000KoeMGE00?o0000omGEeOoEeMD0oooEeMGHomGEe@00oooEeMGa
omGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00NooEeMEO
o`0001WoeMGEGol0002NomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooE
eMGaomGEe@00oooEeMGaomGEe@00eOoEeMD3o`0007GoeMGE0ol0002PomGEe@00f?oEeMD00ol0003o
eMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE09goeMGE003IomGEe@03o`000?oEeMGoeMGE07GoeMGE
00?o0000omGEeOoEeMD0W?oEeMD007coeMGE1_l00004omGEe@03o`000?oEeMGoeMGE00GoeMGE1?l0
0003omGEe@?o00001OoEeMD4o`0000_oeMGE1Ol00004omGEe@?o00007OoEeMD3o`000003omGEeOl0
003oeMGE01WoeMGE1Ol00005omGEe@03o`000?oEeMGoeMGE00CoeMGE0ol00005omGEe@Co00000ooE
eMD5o`0000_oeMGE1Ol00004omGEe@?o00007OoEeMD3o`000003omGEeOl0003oeMGE09goeMGE001l
omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD03?oEeMD01Ol0003oeMGEomGEeOoE
eMGo000000?oeMGE00Go0000omGEeOoEeMGoeMGEo`000004omGEe@03o`000?oEeMGoeMGE00[oeMGE
00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001_oeMGE00Co0000omGEeOoE
eMGoeMGE0_l0000LomGEe@03o`000?oEeMGoeMGE00_oeMGE00Go0000omGEeOoEeMGoeMGEo`000003
omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@0=
omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000KomGEe@04o`000?oE
eMGoeMGEomGEe@;o0000W_oEeMD007goeMGE00?o0000omGEeOoEeMD04?oEeMD01Ol0003oeMGEomGE
eOoEeMGo000000?oeMGE00Go0000omGEeOoEeMGoeMGEo`000004omGEe@03o`000?oEeMGoeMGE00[o
eMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001[oeMGE00?o0000omGE
eOoEeMD00ooEeMD00ol0003oeMGEomGEe@0JomGEe@03o`000?oEeMGoeMGE013oeMGE00Co0000omGE
eOoEeMGo00001?oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE00goeMGE00?o0000
omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001[oeMGE00?o0000omGEeOoEeMD00ooE
eMD00ol0003oeMGEomGEe@2LomGEe@00O_oEeMD00ol0003oeMGEomGEe@0;omGEe@Ko00000_oEeMD0
1Ol0003oeMGEomGEeOoEeMGo000000?oeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGE
e@0:omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03o`00
0?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD06_oEeMD00ol0003oeMGEomGEe@0@omGEe@04o`00
0?oEeMGoeMGEo`0000CoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@0=omGEe@03
o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03o`000?oEeMGoeMGE
00?oeMGE00?o0000omGEeOoEeMD0W?oEeMD007ooeMGE00?o0000omGEeOoEeMD02_oEeMD01Ol0003o
eMGEomGEeOoEeMGo000000?oeMGE00Go0000omGEeOoEeMGoeMGEo`000004omGEe@Co00003OoEeMD0
0ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006_oEeMD00ol0003oeMGEomGE
e@03omGEe@03o`000?oEeMGoeMGE01[oeMGE00?o0000omGEeOoEeMD03ooEeMD00ol0003oeMGEomGE
e@02omGEe@Co00001OoEeMD00ol0003oeMGEomGEe@0=omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go
0000omGEeOoEeMGoeMGEo`00000JomGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD0
W?oEeMD0083oeMGE00?o0000omGEeOoEeMD02_oEeMD01?l0003oeMGEomGEeOl00003omGEe@05o`00
0?oEeMGoeMGEomGEeOl000000ooEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE00[o
eMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001_oeMGE00Co0000omGE
eOoEeMGoeMGE0_l0000LomGEe@03o`000?oEeMGoeMGE00_oeMGE1?l00004omGEe@03o`000?oEeMGo
eMGE00;oeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@0=omGEe@03o`000?oEeMGo
eMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000KomGEe@04o`000?oEeMGoeMGEomGEe@;o0000
W_oEeMD0087oeMGE00?o0000omGEeOoEeMD02_oEeMD00ol0003oeMGEo`000003omGEe@05o`000?oE
eMGoeMGEomGEeOl000000ooEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE00SoeMGE
00?o0000omGEeOl000001OoEeMD01Ol0003oeMGEomGEeOoEeMGo000001coeMGE0ol000000ooEeMGo
0000omGEe@0IomGEe@03o`000?oEeMGo000000goeMGE00?o0000omGEeOoEeMD01OoEeMD00ol0003o
eMGEomGEe@02omGEe@06o`000?oEeMGoeMGEo`000?oEeMGo00003OoEeMD00ol0003oeMGEo`000005
omGEe@05o`000?oEeMGoeMGEomGEeOl000007?oEeMD3o`000003omGEeOl0003oeMGE09goeMGE001l
omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD02ooEeMD2o`0000?oeMGE00Go0000
omGEeOoEeMGoeMGEo`000003omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD02OoE
eMD2o`0000GoeMGE00Go0000omGEeOoEeMGoeMGEo`00000lomGEe@;o00003OoEeMD00ol0003oeMGE
omGEe@05omGEe@03o`000?oEeMGoeMGE00;oeMGE00Co0000omGEeOoEeMGoeMGE0_l0000>omGEe@;o
00001OoEeMD01Ol0003oeMGEomGEeOoEeMGo00000;ooeMGE001momGEe@Co00003ooEeMD00ol0003o
eMGEomGEe@02omGEe@?o00001OoEeMD4o`0000goeMGE00?o0000omGEeOoEeMD01?oEeMD3o`0003ko
eMGE00?o0000omGEeOoEeMD02ooEeMD6o`0000?oeMGE1?l00005omGEe@03o`000?oEeMGoeMGE00go
eMGE00?o0000omGEeOoEeMD01?oEeMD3o`000<3oeMGE003oomGEeO7oeMGE0036omGEe@03o`000?oE
eMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0[ooEeMD00<KoeMGE00?o0000omGEeOoEeMD0MOoEeMD0
0ol0003oeMGEomGEe@2_omGEe@00aooEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE
0:koeMGE002komGEe@Oo00001OoEeMD00ol0003oeMGEomGEe@1YomGEe@Oo00001OoEeMD00ol0003o
eMGEomGEe@2^omGEe@00b?oEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE0:goeMGE
0038omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0[OoEeMD00<WoeMGE00?o0000
omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2/omGEe@00a?oEeMD00ol0003oeMGEomGEe@02omGE
e@03o`000?oEeMGoeMGE073oeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@2/omGE
e@00a?oEeMD6o`0007;oeMGE1_l0002^omGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGa
omGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGa
omGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGa
omGEe@00oooEeMGaomGEe@001?oEeMD5o`0000GoeMGE0_l00005omGEe@Co00001OoEeMD00ol0003o
eMGEomGEe@23omGEe@Go0000LooEeMD5o`000<ooeMGE0006omGEe@03o`000?oEeMGoeMGE00CoeMGE
00Co0000omGEeOoEeMGo00000ooEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE08So
eMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@1`omGEe@03o`000?oEeMGoeMGE00;o
eMGE00?o0000omGEeOoEeMD0c?oEeMD000KoeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGE
omGEe@02omGEe@04o`000?oEeMGoeMGEo`0000CoeMGE00?o0000omGEeOoEeMD0SOoEeMD00ol0003o
eMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE0<coeMGE0006omGEe@03o`000?oEeMGoeMGE00?oeMGE
00?o0000omGEeOoEeMD00_oEeMD01?l0003oeMGEomGEeOl00004omGEe@03o`000?oEeMGoeMGE08Wo
eMGE1?l0001domGEe@Co0000cooEeMD000KoeMGE00?o0000omGEeOoEeMD00ooEeMD2o`0000;oeMGE
00?o0000omGEeOoEeMD00_oEeMD4o`0008_oeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGE
omGEe@3AomGEe@001_oEeMD00ol0003oeMGEomGEe@03omGEe@04o`000?oEeMGo0000o`0000CoeMGE
00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@28omGEe@03o`000?oEeMGoeMGE00;oeMGE
00?o0000omGEeOoEeMD0L?oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE0<coeMGE
0004omGEe@03o`000?oEeMGo000000GoeMGE00?o0000omGEeOoEeMD01OoEeMD00ol0003oeMGEomGE
e@02omGEe@03o`000?oEeMGoeMGE08WoeMGE1Ol0001comGEe@Go0000c_oEeMD000GoeMGE0_l00006
omGEe@03o`000?oEeMGoeMGE00CoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@3o
omGEeMGoeMGE0006omGEe@03o`000?oEeMGoeMGE00GoeMGE0_l00005omGEe@Co0000oooEeMGHomGE
e@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGE
e@00oooEeMGaomGEe@00NooEeMEOo`0001WoeMGEGol0002NomGEe@00oooEeMGaomGEe@00oooEeMGa
omGEe@00oooEeMGaomGEe@00eOoEeMD3o`0007GoeMGE0ol0002PomGEe@00f?oEeMD00ol0003oeMGE
omGEe@1eomGEe@03o`000?oEeMGoeMGE09goeMGE003IomGEe@03o`000?oEeMGoeMGE07GoeMGE00?o
0000omGEeOoEeMD0W?oEeMD007coeMGE1_l00004omGEe@03o`000?oEeMGoeMGE00?oeMGE1Ol00005
omGEe@;o00001?oEeMD6o`0000[oeMGE1Ol00004omGEe@?o00007OoEeMD3o`000003omGEeOl0003o
eMGE01WoeMGE1Ol00005omGEe@03o`000?oEeMGoeMGE00GoeMGE1?l00003omGEe@?o00001_oEeMD0
0ol0003oeMGEomGEe@0;omGEe@Go00001?oEeMD3o`0001goeMGE0ol000000ooEeMGo0000omGEe@2M
omGEe@00O?oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE00[oeMGE00?o0000omGE
eOoEeMD01ooEeMD01Ol0003oeMGEomGEeOoEeMGo000000CoeMGE00?o0000omGEeOoEeMD02_oEeMD0
0ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006ooEeMD01?l0003oeMGEomGE
eOoEeMD2o`0001coeMGE00?o0000omGEeOoEeMD03ooEeMD01Ol0003oeMGEomGEeOoEeMGo000000?o
eMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@0=omGEe@03o`000?oEeMGoeMGE00?o
eMGE00Go0000omGEeOoEeMGoeMGEo`00000KomGEe@04o`000?oEeMGoeMGEomGEe@;o0000W_oEeMD0
07goeMGE00?o0000omGEeOoEeMD03_oEeMD00ol0003oeMGEomGEe@08omGEe@05o`000?oEeMGoeMGE
omGEeOl000004?oEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006_oE
eMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE01[oeMGE00?o0000omGEeOoEeMD03ooE
eMD00ol0003oeMGEomGEe@06omGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD03?oE
eMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006_oEeMD00ol0003oeMGE
omGEe@03omGEe@03o`000?oEeMGoeMGE09coeMGE001nomGEe@03o`000?oEeMGoeMGE00goeMGE00?o
0000omGEeOoEeMD01OoEeMD2o`000003omGEeOl0003oeMGE00?oeMGE00?o0000omGEeOoEeMD03OoE
eMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006_oEeMD00ol0003oeMGE
omGEe@03omGEe@03o`000?oEeMGoeMGE01[oeMGE00?o0000omGEeOoEeMD02ooEeMD6o`0000OoeMGE
00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@0<omGEe@03o`000?oEeMGoeMGE00?oeMGE
00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoE
eMD0W?oEeMD007ooeMGE00?o0000omGEeOoEeMD03?oEeMD00ol0003oeMGEomGEe@04omGEe@03o`00
0?oEeMGoeMGE00;o00001OoEeMD00ol0003oeMGEomGEe@0<omGEe@03o`000?oEeMGoeMGE00?oeMGE
00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoE
eMD06_oEeMD00ol0003oeMGEomGEe@0;omGEe@05o`000?oEeMGoeMGEomGEeOl000001ooEeMD00ol0
003oeMGEomGEe@05omGEe@03o`000?oEeMGoeMGE00_oeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0
003oeMGEomGEeOoEeMGo000001[oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@2L
omGEe@00P?oEeMD00ol0003oeMGEomGEe@0;omGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGE
eOoEeMD00_oEeMD00ol0003oeMGEomGEe@04omGEe@03o`000?oEeMGoeMGE00_oeMGE00?o0000omGE
eOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001_oeMGE00Co0000omGEeOoEeMGoeMGE0_l0
000LomGEe@03o`000?oEeMGoeMGE00coeMGE00Co0000omGEeOoEeMGo00000ooEeMD4o`0000SoeMGE
00?o0000omGEeOoEeMD02ooEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl0
00006ooEeMD01?l0003oeMGEomGEeOoEeMD2o`0009koeMGE0021omGEe@03o`000?oEeMGoeMGE00So
eMGE00?o0000omGEeOl000001OoEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE00Go
eMGE00?o0000omGEeOoEeMD02?oEeMD00ol0003oeMGEo`000005omGEe@05o`000?oEeMGoeMGEomGE
eOl000007?oEeMD3o`000003omGEeOl0003oeMGE01WoeMGE00?o0000omGEeOl000003ooEeMD00ol0
003oeMGEo`000003omGEe@03o`000?oEeMGoeMGE00[oeMGE00?o0000omGEeOoEeMD02?oEeMD00ol0
003oeMGEo`000005omGEe@05o`000?oEeMGoeMGEomGEeOl000007?oEeMD3o`000003omGEeOl0003o
eMGE09goeMGE001lomGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD02OoEeMD2o`00
00KoeMGE00Co0000omGEeOoEeMGo00000ooEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGo
eMGE00WoeMGE0_l00005omGEe@05o`000?oEeMGoeMGEomGEeOl00000??oEeMD2o`00013oeMGE0_l0
0003omGEe@03o`000?oEeMGoeMGE00GoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGE
e@09omGEe@;o00001OoEeMD01Ol0003oeMGEomGEeOoEeMGo00000;ooeMGE001momGEe@Co00003OoE
eMD00ol0003oeMGEomGEe@05omGEe@;o00001OoEeMD4o`0000goeMGE00?o0000omGEeOoEeMD01?oE
eMD3o`0003koeMGE00?o0000omGEeOoEeMD03ooEeMD01?l0003oeMGEomGEeOoEeMD6o`0000;oeMGE
1_l0000<omGEe@03o`000?oEeMGoeMGE00CoeMGE0ol00030omGEe@00oooEeMGaomGEe@00oooEeMGa
omGEe@00oooEeMGaomGEe@00a_oEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE0:oo
eMGE0036omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0[ooEeMD00<OoeMGE00?o
0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2^omGEe@00^ooEeMD7o`0000GoeMGE00?o0000
omGEeOoEeMD0JOoEeMD7o`0000GoeMGE00?o0000omGEeOoEeMD0[_oEeMD00<SoeMGE00?o0000omGE
eOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2]omGEe@00b?oEeMD00ol0003oeMGEomGEe@1eomGEe@03
o`000?oEeMGoeMGE0:goeMGE0039omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0
[?oEeMD00<CoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@1`omGEe@03o`000?oE
eMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0[?oEeMD00<CoeMGE1_l0001bomGEe@Ko0000[_oEeMD0
0?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD0
0?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD0
0?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD000CoeMGE1Ol00004
omGEe@Co00001OoEeMD4o`0000CoeMGE00?o0000omGEeOoEeMD0PooEeMD5o`0007?oeMGE1Ol0003?
omGEe@001_oEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGE
eOoEeMD01?oEeMD00ol0003oeMGEomGEe@29omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGE
eOoEeMD0L?oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE0<coeMGE0006omGEe@03
o`000?oEeMGoeMGE00SoeMGE00?o0000omGEeOoEeMD01?oEeMD00ol0003oeMGEomGEe@2>omGEe@03
o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0c?oEeMD000KoeMGE00?o0000omGEeOoEeMD0
2?oEeMD00ol0003oeMGEomGEe@06o`0008_oeMGE1?l0001domGEe@Co0000cooEeMD000KoeMGE00?o
0000omGEeOoEeMD01OoEeMD3o`0000?oeMGE00Go0000omGEeOoEeMGoeMGEo`00002;omGEe@03o`00
0?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0dOoEeMD000KoeMGE00?o0000omGEeOoEeMD02?oE
eMD01Ol0003oeMGEomGEeOoEeMGo000000;oeMGE00?o0000omGEeOoEeMD0ROoEeMD00ol0003oeMGE
omGEe@02omGEe@03o`000?oEeMGoeMGE073oeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGE
omGEe@3<omGEe@001?oEeMD00ol0003oeMGEo`00000:omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o
0000omGEeOl00000S?oEeMD5o`0007?oeMGE1Ol0003>omGEe@001OoEeMD2o`0000GoeMGE00?o0000
omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@03omGEe@;o0000oooEeMGHomGEe@001_oEeMD00ol0
003oeMGEomGEe@04omGEe@Co00001ooEeMD00ol0003oeMGEomGEe@3oomGEeMKoeMGE003oomGEeO7o
eMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE001komGEeEoo00006OoEeMEOo`00
09koeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGE
eO7oeMGE003EomGEe@?o0000MOoEeMD3o`000:3oeMGE003HomGEe@03o`000?oEeMGoeMGE07GoeMGE
00?o0000omGEeOoEeMD0WOoEeMD00=WoeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGE
e@2LomGEe@00O?oEeMD5o`0000GoeMGE00?o0000omGEeOoEeMD01OoEeMD2o`0000KoeMGE0_l00005
omGEe@Co00002ooEeMD5o`0000CoeMGE0ol0000MomGEe@?o000000?oeMGEo`000?oEeMD06OoEeMD5
o`0000GoeMGE00?o0000omGEeOoEeMD01?oEeMD4o`0000CoeMGE1?l00005omGEe@Co00002_oEeMD5
o`0000CoeMGE0ol0000MomGEe@?o000000?oeMGEo`000?oEeMD0WOoEeMD007koeMGE00?o0000omGE
eOoEeMD03ooEeMD00ol0003oeMGEomGEe@02omGEe@04o`000?oEeMGoeMGEo`0000?oeMGE00?o0000
omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@0:omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000
omGEeOoEeMGoeMGEo`00000KomGEe@04o`000?oEeMGoeMGEomGEe@;o00007?oEeMD00ol0003oeMGE
omGEe@0;omGEe@03o`000?oEeMGoeMGE00;oeMGE00Co0000omGEeOoEeMGo00001?oEeMD00ol0003o
eMGEomGEe@04omGEe@03o`000?oEeMGoeMGE00_oeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003o
eMGEomGEeOoEeMGo000001_oeMGE00Co0000omGEeOoEeMGoeMGE0_l0002NomGEe@00O_oEeMD00ol0
003oeMGEomGEe@0@omGEe@04o`000?oEeMGoeMGEo`0000CoeMGE00Co0000omGEeOoEeMGo00001?oE
eMD00ol0003oeMGEomGEe@0:omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGE
o`00000JomGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD06_oEeMD00ol0003oeMGE
omGEe@0@omGEe@03o`000?oEeMGoeMGE00GoeMGE00?o0000omGEeOoEeMD01?oEeMD00ol0003oeMGE
omGEe@0;omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03
o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD0W?oEeMD007koeMGE00?o0000omGEeOoEeMD0
3OoEeMD2o`000005omGEeOl0003oeMGEomGEeOl000001?oEeMD01?l0003oeMGEomGEeOl00004omGE
e@03o`000?oEeMGoeMGE00[oeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo
000001[oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@0JomGEe@03o`000?oEeMGo
eMGE013oeMGE00?o0000omGEeOoEeMD01OoEeMD00ol0003oeMGEomGEe@06o`0000coeMGE00?o0000
omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001[oeMGE00?o0000omGEeOoEeMD00ooE
eMD00ol0003oeMGEomGEe@2LomGEe@00O_oEeMD00ol0003oeMGEomGEe@0<omGEe@03o`000?oEeMGo
eMGE00;o00000_oEeMD2o`0000;oeMGE00?o0000omGEeOoEeMD00_oEeMD4o`0000goeMGE00?o0000
omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001[oeMGE00?o0000omGEeOoEeMD00ooE
eMD00ol0003oeMGEomGEe@0JomGEe@03o`000?oEeMGoeMGE00goeMGE0ol00005omGEe@?o00000ooE
eMD01Ol0003oeMGEomGEeOoEeMGo000000goeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGE
omGEeOoEeMGo000001[oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@2LomGEe@00
O_oEeMD00ol0003oeMGEomGEe@0;omGEe@03o`000?oEeMGoeMGE00;oeMGE00Go0000omGEeOoEeMGo
0000omGEe@02o`0000CoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@0:omGEe@03
o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000KomGEe@04o`000?oEeMGoeMGE
omGEe@;o00007?oEeMD00ol0003oeMGEomGEe@0@omGEe@03o`000?oEeMGoeMGE00GoeMGE00Go0000
omGEeOoEeMGoeMGEo`000002omGEe@03o`000?oEeMGoeMGE00_oeMGE00?o0000omGEeOoEeMD00ooE
eMD01Ol0003oeMGEomGEeOoEeMGo000001_oeMGE00Co0000omGEeOoEeMGoeMGE0_l0002NomGEe@00
O?oEeMD00ol0003oeMGEo`00000=omGEe@03o`000?oEeMGoeMGE00;oeMGE00Co0000omGEeOoEeMGo
00001ooEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE00SoeMGE00?o0000omGEeOl0
00001OoEeMD01Ol0003oeMGEomGEeOoEeMGo000001coeMGE0ol000000ooEeMGo0000omGEe@0IomGE
e@03o`000?oEeMGo000001;oeMGE00?o0000omGEeOoEeMD01OoEeMD00ol0003oeMGEomGEe@02omGE
e@03o`000?oEeMGo000000_oeMGE00?o0000omGEeOl000001OoEeMD01Ol0003oeMGEomGEeOoEeMGo
000001coeMGE0ol000000ooEeMGo0000omGEe@2MomGEe@00OOoEeMD2o`0000koeMGE00Co0000omGE
eOoEeMGo00001?oEeMD00ol0003oeMGEomGEe@04omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000
omGEeOoEeMD02OoEeMD2o`0000GoeMGE00Go0000omGEeOoEeMGoeMGEo`00000lomGEe@;o00003OoE
eMD00ol0003oeMGEomGEe@02omGEe@04o`000?oEeMGoeMGEo`0000CoeMGE00?o0000omGEeOoEeMD0
0ooEeMD2o`0000coeMGE0_l00005omGEe@05o`000?oEeMGoeMGEomGEeOl00000_ooEeMD007koeMGE
00?o0000omGEeOoEeMD03OoEeMD2o`0000KoeMGE0_l00005omGEe@Co00003OoEeMD00ol0003oeMGE
omGEe@04omGEe@?o0000?_oEeMD00ol0003oeMGEomGEe@0<omGEe@Co00001?oEeMD4o`0000OoeMGE
00?o0000omGEeOoEeMD02ooEeMD00ol0003oeMGEomGEe@04omGEe@?o0000`?oEeMD00?ooeMGElOoE
eMD00?ooeMGElOoEeMD00<KoeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2_omGE
e@00a_oEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE0:ooeMGE0037omGEe@03o`00
0?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0[_oEeMD00;_oeMGE1ol00005omGEe@03o`000?oE
eMGoeMGE06WoeMGE1ol00005omGEe@03o`000?oEeMGoeMGE0:koeMGE0038omGEe@03o`000?oEeMGo
eMGE07GoeMGE00?o0000omGEeOoEeMD0[OoEeMD00<SoeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0
003oeMGEomGEe@2]omGEe@00bOoEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE0:co
eMGE0034omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0L?oEeMD00ol0003oeMGE
omGEe@02omGEe@03o`000?oEeMGoeMGE0:coeMGE0034omGEe@Ko0000L_oEeMD6o`000:koeMGE003o
omGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003o
omGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003o
omGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE0004omGEe@Go00001?oEeMD3o`0000CoeMGE
1Ol00005omGEe@03o`000?oEeMGoeMGE08?oeMGE1Ol0001comGEe@Go0000cooEeMD000KoeMGE00?o
0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000000GoeMGE00?o0000omGEeOoEeMD0
RooEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE073oeMGE00?o0000omGEeOoEeMD0
0_oEeMD00ol0003oeMGEomGEe@3<omGEe@001_oEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oE
eMGoeMGEomGEeOl000001OoEeMD00ol0003oeMGEomGEe@2@omGEe@03o`000?oEeMGoeMGE07GoeMGE
00?o0000omGEeOoEeMD0c?oEeMD000KoeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGE
eOoEeMGo000000GoeMGE00?o0000omGEeOoEeMD0S?oEeMD4o`0007CoeMGE1?l0003?omGEe@001_oE
eMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000001OoEeMD00ol0003oeMGE
omGEe@2;omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0dOoEeMD000KoeMGE00?o
0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000000GoeMGE00?o0000omGEeOoEeMD0
RooEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE073oeMGE00?o0000omGEeOoEeMD0
0_oEeMD00ol0003oeMGEomGEe@3<omGEe@001?oEeMD00ol0003oeMGEo`000005omGEe@05o`000?oE
eMGoeMGEomGEeOl000000ooEeMD00ol0003oeMGEo`00002>omGEe@Go0000LooEeMD5o`000<koeMGE
0005omGEe@;o00001OoEeMD01Ol0003oeMGEomGEeOoEeMGo000000CoeMGE0_l0003oomGEeM[oeMGE
0006omGEe@03o`000?oEeMGoeMGE00CoeMGE0ol00006omGEe@03o`000?oEeMGoeMGE0?ooeMGEf?oE
eMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoE
eMD007_oeMGEGol0000IomGEeEoo0000W_oEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGE
lOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00=GoeMGE0ol0001eomGEe@?o0000X?oEeMD00=So
eMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2MomGEe@00fOoEeMD00ol0003oeMGE
omGEe@1eomGEe@03o`000?oEeMGoeMGE09coeMGE001lomGEe@Go00001OoEeMD00ol0003oeMGEomGE
e@05omGEe@03o`000?oEeMGoeMGE00CoeMGE1?l00005omGEe@;o00003?oEeMD5o`0000CoeMGE0ol0
000MomGEe@?o000000?oeMGEo`000?oEeMD06OoEeMD5o`0000GoeMGE00?o0000omGEeOoEeMD00ooE
eMD6o`0000;oeMGE1Ol00005omGEe@Co00002_oEeMD5o`0000CoeMGE0ol0000MomGEe@?o000000?o
eMGEo`000?oEeMD0WOoEeMD007koeMGE00?o0000omGEeOoEeMD03OoEeMD00ol0003oeMGEomGEe@03
omGEe@03o`000?oEeMGoeMGE00;oeMGE00Go0000omGEeOoEeMGoeMGEo`000002omGEe@03o`000?oE
eMGoeMGE00_oeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001_oeMGE
00Co0000omGEeOoEeMGoeMGE0_l0000LomGEe@03o`000?oEeMGoeMGE00_oeMGE00?o0000omGEeOoE
eMD00_oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE00OoeMGE00?o0000omGEeOoE
eMD02ooEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006ooEeMD01?l0
003oeMGEomGEeOoEeMD2o`0009koeMGE001nomGEe@03o`000?oEeMGoeMGE00koeMGE00?o0000omGE
eOoEeMD01ooEeMD01?l0003oeMGEomGEeOl00004omGEe@03o`000?oEeMGoeMGE00[oeMGE00?o0000
omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001[oeMGE00?o0000omGEeOoEeMD00ooE
eMD00ol0003oeMGEomGEe@0JomGEe@03o`000?oEeMGoeMGE00coeMGE00?o0000omGEeOoEeMD01_oE
eMD00ol0003oeMGEomGEe@07omGEe@03o`000?oEeMGoeMGE00_oeMGE00?o0000omGEeOoEeMD00ooE
eMD01Ol0003oeMGEomGEeOoEeMGo000001[oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGE
omGEe@2LomGEe@00O_oEeMD00ol0003oeMGEomGEe@0>omGEe@03o`000?oEeMGoeMGE00OoeMGE00Co
0000omGEeOoEeMGo00001?oEeMD00ol0003oeMGEomGEe@0:omGEe@03o`000?oEeMGoeMGE00?oeMGE
00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoE
eMD06_oEeMD00ol0003oeMGEomGEe@0=omGEe@03o`000?oEeMGoeMGE00GoeMGE00?o0000omGEeOoE
eMD00ooEeMD6o`0000coeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo0000
01[oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@2LomGEe@00O_oEeMD00ol0003o
eMGEomGEe@0?omGEe@03o`000?oEeMGoeMGE00?oeMGE0ol00003omGEe@;o00000_oEeMD00ol0003o
eMGEomGEe@0;omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000JomGE
e@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD06_oEeMD00ol0003oeMGEomGEe@0>omGE
e@03o`000?oEeMGoeMGE00CoeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo
000000goeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001[oeMGE00?o
0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@2LomGEe@00O_oEeMD00ol0003oeMGEomGEe@0?
omGEe@03o`000?oEeMGoeMGE00KoeMGE00Go0000omGEeOoEeMGo0000omGEe@02o`0000koeMGE00?o
0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001_oeMGE00Co0000omGEeOoEeMGo
eMGE0_l0000LomGEe@03o`000?oEeMGoeMGE00ooeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003o
eMGEomGEe@04omGEe@04o`000?oEeMGoeMGEo`0000goeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0
003oeMGEomGEeOoEeMGo000001_oeMGE00Co0000omGEeOoEeMGoeMGE0_l0002NomGEe@00O?oEeMD0
0ol0003oeMGEo`00000BomGEe@03o`000?oEeMGoeMGE00GoeMGE00Co0000omGEeOoEeMGo00003ooE
eMD00ol0003oeMGEo`000005omGEe@05o`000?oEeMGoeMGEomGEeOl000007?oEeMD3o`000003omGE
eOl0003oeMGE01WoeMGE00?o0000omGEeOl000004_oEeMD01_l0003oeMGEomGEeOl0003oeMGEo`00
00OoeMGE00?o0000omGEeOl000002ooEeMD00ol0003oeMGEo`000005omGEe@05o`000?oEeMGoeMGE
omGEeOl000007?oEeMD3o`000003omGEeOl0003oeMGE09goeMGE001momGEe@;o00003OoEeMD00ol0
003oeMGEomGEe@02omGEe@04o`000?oEeMGoeMGEo`0000CoeMGE00Go0000omGEeOoEeMGoeMGEo`00
000?omGEe@;o00001OoEeMD01Ol0003oeMGEomGEeOoEeMGo000003coeMGE0_l0000=omGEe@03o`00
0?oEeMGoeMGE00;oeMGE00Co0000omGEeOoEeMGoeMGE0_l00008omGEe@;o00003?oEeMD2o`0000Go
eMGE00Go0000omGEeOoEeMGoeMGEo`00002oomGEe@00O_oEeMD00ol0003oeMGEomGEe@0;omGEe@Ko
00000ooEeMD4o`0000GoeMGE0_l0000>omGEe@03o`000?oEeMGoeMGE00CoeMGE0ol0000nomGEe@03
o`000?oEeMGoeMGE00coeMGE1?l00005omGEe@03o`000?oEeMGoeMGE00OoeMGE00?o0000omGEeOoE
eMD02ooEeMD00ol0003oeMGEomGEe@04omGEe@?o0000`?oEeMD00?ooeMGElOoEeMD00<KoeMGE00?o
0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2_omGEe@00a_oEeMD00ol0003oeMGEomGEe@1e
omGEe@03o`000?oEeMGoeMGE0:ooeMGE0037omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGE
eOoEeMD0[_oEeMD00;_oeMGE1ol00005omGEe@03o`000?oEeMGoeMGE06WoeMGE1ol00005omGEe@03
o`000?oEeMGoeMGE0:koeMGE0038omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0
[OoEeMD00<SoeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2]omGEe@00bOoEeMD0
0ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE0:coeMGE0034omGEe@03o`000?oEeMGoeMGE
00;oeMGE00?o0000omGEeOoEeMD0L?oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE
0:coeMGE0034omGEe@Ko0000L_oEeMD6o`000:koeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003o
omGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003o
omGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003o
omGEeO7oeMGE003oomGEeO7oeMGE0005omGEe@Co00001?oEeMD4o`0000GoeMGE00?o0000omGEeOoE
eMD01?oEeMD4o`0008?oeMGE1Ol0001comGEe@Go0000cooEeMD000CoeMGE00?o0000omGEeOoEeMD0
0_oEeMD01?l0003oeMGEomGEeOl00004omGEe@03o`000?oEeMGoeMGE00SoeMGE00?o0000omGEeOoE
eMD00_oEeMD00ol0003oeMGEomGEe@20omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoE
eMD0L?oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE0<coeMGE0004omGEe@03o`00
0?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD01OoEeMD00ol0003oeMGEomGEe@08omGEe@03o`00
0?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0QOoEeMD00ol0003oeMGEomGEe@1eomGEe@03o`00
0?oEeMGoeMGE0<coeMGE0004omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD01OoE
eMD00ol0003oeMGEomGEe@08omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0POoE
eMD4o`0007CoeMGE1?l0003?omGEe@001OoEeMD4o`0000GoeMGE0ol0000<omGEe@Co0000PooEeMD0
0ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE0=7oeMGE0004omGEe@03o`000?oEeMGoeMGE
00;oeMGE00?o0000omGEeOoEeMD01OoEeMD00ol0003oeMGEomGEe@08omGEe@03o`000?oEeMGoeMGE
00;oeMGE00?o0000omGEeOoEeMD0P?oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE
073oeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@3<omGEe@001?oEeMD00ol0003o
eMGEomGEe@02omGEe@03o`000?oEeMGoeMGE00GoeMGE00?o0000omGEeOoEeMD02?oEeMD00ol0003o
eMGEomGEe@02omGEe@03o`000?oEeMGoeMGE087oeMGE1Ol0001comGEe@Go0000c_oEeMD000CoeMGE
00?o0000omGEeOoEeMD00_oEeMD01?l0003oeMGEomGEeOl00004omGEe@03o`000?oEeMGoeMGE00So
eMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@3oomGEeLgoeMGE0005omGEe@Co0000
1?oEeMD4o`0000coeMGE1?l0003oomGEeM3oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGE
eO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE001komGEeEoo00006OoEeMEO
o`0009koeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003EomGEe@?o0000MOoE
eMD3o`000:3oeMGE003HomGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0WOoEeMD0
0=WoeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2LomGEe@00O?oEeMD5o`0000Go
eMGE00?o0000omGEeOoEeMD01OoEeMD2o`0000CoeMGE1Ol00005omGEe@;o00003?oEeMD5o`0000Co
eMGE0ol0000MomGEe@?o000000?oeMGEo`000?oEeMD06OoEeMD5o`0000GoeMGE00?o0000omGEeOoE
eMD00ooEeMD5o`0000CoeMGE0ol00005omGEe@Co00002ooEeMD5o`0000CoeMGE0ol0000MomGEe@?o
000000?oeMGEo`000?oEeMD0WOoEeMD007koeMGE00?o0000omGEeOoEeMD03?oEeMD01?l0003oeMGE
omGEeOl00005omGEe@03o`000?oEeMGoeMGE00CoeMGE00Co0000omGEeOoEeMGo00003OoEeMD00ol0
003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006ooEeMD01?l0003oeMGEomGEeOoE
eMD2o`0001coeMGE00?o0000omGEeOoEeMD03OoEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oE
eMGoeMGEomGEeOl000000ooEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE00[oeMGE
00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001_oeMGE00Co0000omGEeOoE
eMGoeMGE0_l0002NomGEe@00O_oEeMD00ol0003oeMGEomGEe@0;omGEe@03o`000?oEeMGoeMGE00;o
eMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE00;o
eMGE00?o0000omGEeOoEeMD02_oEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGE
eOl000006_oEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE01[oeMGE00?o0000omGE
eOoEeMD03OoEeMD00ol0003oeMGEomGEe@08omGEe@04o`000?oEeMGoeMGEo`0000CoeMGE00?o0000
omGEeOoEeMD02_oEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006_oE
eMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE09coeMGE001nomGEe@03o`000?oEeMGo
eMGE00_oeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGo
eMGE00?oeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@0:omGEe@03o`000?oEeMGo
eMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03o`000?oEeMGoeMGE00?oeMGE00?o
0000omGEeOoEeMD06_oEeMD00ol0003oeMGEomGEe@0=omGEe@03o`000?oEeMGoeMGE00SoeMGE00Co
0000omGEeOoEeMGo00001?oEeMD00ol0003oeMGEomGEe@0:omGEe@03o`000?oEeMGoeMGE00?oeMGE
00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoE
eMD0W?oEeMD007koeMGE00?o0000omGEeOoEeMD02ooEeMD2o`0000;oeMGE00?o0000omGEeOoEeMD0
0ooEeMD00ol0003oeMGEomGEe@03omGEe@;o00000_oEeMD00ol0003oeMGEomGEe@0;omGEe@03o`00
0?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03o`000?oEeMGoeMGE00?o
eMGE00?o0000omGEeOoEeMD06_oEeMD00ol0003oeMGEomGEe@0=omGEe@03o`000?oEeMGoeMGE00Oo
eMGE00?o0000omGEeOoEeMD00_oEeMD4o`0000goeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003o
eMGEomGEeOoEeMGo000001[oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@2LomGE
e@00O_oEeMD00ol0003oeMGEomGEe@0;omGEe@04o`000?oEeMGo0000o`0000KoeMGE00?o0000omGE
eOoEeMD00ooEeMD01?l0003oeMGEo`000?l0000>omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000
omGEeOoEeMGoeMGEo`00000KomGEe@04o`000?oEeMGoeMGEomGEe@;o00007?oEeMD00ol0003oeMGE
omGEe@0=omGEe@03o`000?oEeMGoeMGE00?oeMGE1?l00004omGEe@03o`000?oEeMGoeMGE00;oeMGE
00?o0000omGEeOoEeMD02_oEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl0
00006ooEeMD01?l0003oeMGEomGEeOoEeMD2o`0009koeMGE001lomGEe@03o`000?oEeMGo000000go
eMGE00?o0000omGEeOoEeMD01OoEeMD00ol0003oeMGEo`000005omGEe@03o`000?oEeMGoeMGE00go
eMGE00?o0000omGEeOl000001OoEeMD01Ol0003oeMGEomGEeOoEeMGo000001coeMGE0ol000000ooE
eMGo0000omGEe@0IomGEe@03o`000?oEeMGo000000goeMGE00?o0000omGEeOl000001OoEeMD00ol0
003oeMGEomGEe@05omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD02?oEeMD00ol0
003oeMGEo`000005omGEe@05o`000?oEeMGoeMGEomGEeOl000007?oEeMD3o`000003omGEeOl0003o
eMGE09goeMGE001momGEe@;o00003_oEeMD00ol0003oeMGEomGEe@05omGEe@;o00001_oEeMD00ol0
003oeMGEomGEe@0=omGEe@;o00001OoEeMD01Ol0003oeMGEomGEeOoEeMGo000003coeMGE0_l0000>
omGEe@;o00001OoEeMD00ol0003oeMGEomGEe@05omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000
omGEeOoEeMD02OoEeMD2o`0000GoeMGE00Go0000omGEeOoEeMGoeMGEo`00002oomGEe@00O_oEeMD0
0ol0003oeMGEomGEe@0=omGEe@;o00001_oEeMD00ol0003oeMGEomGEe@05omGEe@;o00003_oEeMD0
0ol0003oeMGEomGEe@04omGEe@?o0000?_oEeMD00ol0003oeMGEomGEe@0=omGEe@03o`000?oEeMGo
eMGE00?oeMGE1_l00003omGEe@Co00003OoEeMD00ol0003oeMGEomGEe@04omGEe@?o0000`?oEeMD0
0?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00<KoeMGE00?o0000omGEeOoEeMD0MOoE
eMD00ol0003oeMGEomGEe@2_omGEe@00a_oEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGo
eMGE0:ooeMGE0037omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0[_oEeMD00;_o
eMGE1ol00005omGEe@03o`000?oEeMGoeMGE06WoeMGE1ol00005omGEe@03o`000?oEeMGoeMGE0:ko
eMGE0038omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0[OoEeMD00<SoeMGE00?o
0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2]omGEe@00bOoEeMD00ol0003oeMGEomGEe@1e
omGEe@03o`000?oEeMGoeMGE0:coeMGE0034omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGE
eOoEeMD0L?oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE0:coeMGE0034omGEe@Ko
0000L_oEeMD6o`000:koeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGE
eO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGE
eO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGE
eO7oeMGE0006omGEe@;o00001_oEeMD00ol0003oeMGEomGEe@05omGEe@03o`000?oEeMGoeMGE00?o
eMGE1Ol00023omGEe@Go0000LooEeMD5o`000<ooeMGE0005omGEe@04o`000?oEeMGoeMGEo`0000Go
eMGE00?o0000omGEeOoEeMD03OoEeMD00ol0003oeMGEomGEe@23omGEe@03o`000?oEeMGoeMGE00;o
eMGE00?o0000omGEeOoEeMD0L?oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE0<co
eMGE0004omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGE
omGEe@0<omGEe@03o`000?oEeMGoeMGE08SoeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGE
omGEe@3<omGEe@001?oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE00?oeMGE00?o
0000omGEeOoEeMD03?oEeMD00ol0003oeMGEomGEe@24omGEe@Co0000M?oEeMD4o`000<ooeMGE0004
omGEe@;o00000_oEeMD00ol0003oeMGEomGEe@05omGEe@03o`000?oEeMGoeMGE00_oeMGE00?o0000
omGEeOoEeMD0PooEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE0=7oeMGE0004omGE
e@04o`000?oEeMGo0000o`0000SoeMGE00?o0000omGEeOoEeMD02ooEeMD00ol0003oeMGEomGEe@23
omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0L?oEeMD00ol0003oeMGEomGEe@02
omGEe@03o`000?oEeMGoeMGE0<coeMGE0004omGEe@03o`000?oEeMGoeMGE00[oeMGE00?o0000omGE
eOoEeMD02?oEeMD00ol0003oeMGEo`000026omGEe@Go0000LooEeMD5o`000<koeMGE0005omGEe@03
o`000?oEeMGoeMGE00CoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@09omGEe@;o
0000oooEeMGBomGEe@001_oEeMD2o`0000CoeMGE1_l0000<omGEe@03o`000?oEeMGoeMGE0?ooeMGE
d?oEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD007_oeMGE
Gol0000IomGEeEoo0000W_oEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?oo
eMGElOoEeMD00?ooeMGElOoEeMD00=GoeMGE0ol0001eomGEe@?o0000X?oEeMD00=SoeMGE00?o0000
omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2MomGEe@00fOoEeMD00ol0003oeMGEomGEe@1eomGE
e@03o`000?oEeMGoeMGE09coeMGE001lomGEe@Go00001OoEeMD00ol0003oeMGEomGEe@05omGEe@Co
00001?oEeMD2o`0000GoeMGE1?l0000;omGEe@Go00001?oEeMD3o`0001goeMGE0ol000000ooEeMGo
0000omGEe@0IomGEe@Go00001OoEeMD00ol0003oeMGEomGEe@03omGEe@Go00001?oEeMD3o`0000Ko
eMGE0_l0000<omGEe@Go00001?oEeMD3o`0001goeMGE0ol000000ooEeMGo0000omGEe@2MomGEe@00
O_oEeMD00ol0003oeMGEomGEe@0?omGEe@03o`000?oEeMGoeMGE00GoeMGE00Go0000omGEeOoEeMGo
eMGEo`000004omGEe@03o`000?oEeMGoeMGE00[oeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003o
eMGEomGEeOoEeMGo000001_oeMGE00Co0000omGEeOoEeMGoeMGE0_l0000LomGEe@03o`000?oEeMGo
eMGE00goeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000000CoeMGE00Co
0000omGEeOoEeMGo00003OoEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl0
00006ooEeMD01?l0003oeMGEomGEeOoEeMD2o`0009koeMGE001nomGEe@03o`000?oEeMGoeMGE00oo
eMGE00?o0000omGEeOoEeMD01_oEeMD00ol0003oeMGEomGEe@05omGEe@03o`000?oEeMGoeMGE00[o
eMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001[oeMGE00?o0000omGE
eOoEeMD00ooEeMD00ol0003oeMGEomGEe@0JomGEe@03o`000?oEeMGoeMGE00goeMGE00?o0000omGE
eOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000000?oeMGE00?o0000omGEeOoEeMD00_oEeMD0
0ol0003oeMGEomGEe@0:omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00
000JomGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD0W?oEeMD007koeMGE00?o0000
omGEeOoEeMD02ooEeMD6o`0000CoeMGE0_l000000ooEeMGo0000omGEe@06omGEe@03o`000?oEeMGo
eMGE00[oeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001[oeMGE00?o
0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@0JomGEe@03o`000?oEeMGoeMGE00goeMGE00?o
0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000000?oeMGE00?o0000omGEeOoEeMD0
0_oEeMD00ol0003oeMGEomGEe@0:omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGo
eMGEo`00000JomGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD0W?oEeMD007koeMGE
00?o0000omGEeOoEeMD02ooEeMD01Ol0003oeMGEomGEeOoEeMGo000000CoeMGE00?o0000omGEeOoE
eMD00_l00004omGEe@?o00003OoEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGE
eOl000006_oEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE01[oeMGE00?o0000omGE
eOoEeMD03OoEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000000ooEeMD2
o`0000;oeMGE00?o0000omGEeOoEeMD02ooEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGo
eMGEomGEeOl000006_oEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE09coeMGE001n
omGEe@03o`000?oEeMGoeMGE00coeMGE00Co0000omGEeOoEeMGo00000ooEeMD00ol0003oeMGEomGE
e@02omGEe@03o`000?oEeMGoeMGE00GoeMGE00?o0000omGEeOoEeMD02_oEeMD00ol0003oeMGEomGE
e@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006ooEeMD01?l0003oeMGEomGEeOoEeMD2o`0001co
eMGE00?o0000omGEeOoEeMD03OoEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGE
eOl000000ooEeMD01?l0003oeMGEo`000?l0000>omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000
omGEeOoEeMGoeMGEo`00000KomGEe@04o`000?oEeMGoeMGEomGEe@;o0000W_oEeMD007coeMGE00?o
0000omGEeOl000003ooEeMD00ol0003oeMGEo`000003omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o
0000omGEeOoEeMD01OoEeMD00ol0003oeMGEomGEe@08omGEe@03o`000?oEeMGo000000GoeMGE00Go
0000omGEeOoEeMGoeMGEo`00000LomGEe@?o000000?oeMGEo`000?oEeMD06OoEeMD00ol0003oeMGE
o`00000=omGEe@03o`000?oEeMGo000000GoeMGE00Go0000omGEeOoEeMGoeMGEo`000003omGEe@03
o`000?oEeMGoeMGE00goeMGE00?o0000omGEeOl000001OoEeMD01Ol0003oeMGEomGEeOoEeMGo0000
01coeMGE0ol000000ooEeMGo0000omGEe@2MomGEe@00OOoEeMD2o`00013oeMGE0_l00004omGEe@04
o`000?oEeMGoeMGEo`0000?oeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@09omGE
e@;o00001OoEeMD01Ol0003oeMGEomGEeOoEeMGo000003coeMGE0_l0000>omGEe@;o00001OoEeMD0
1Ol0003oeMGEomGEeOoEeMGo000000CoeMGE00?o0000omGEeOoEeMD03OoEeMD2o`0000GoeMGE00Go
0000omGEeOoEeMGoeMGEo`00002oomGEe@00O_oEeMD00ol0003oeMGEomGEe@0?omGEe@03o`000?oE
eMGoeMGE00?oeMGE0_l00005omGEe@Co00003OoEeMD00ol0003oeMGEomGEe@04omGEe@?o0000?_oE
eMD00ol0003oeMGEomGEe@0=omGEe@03o`000?oEeMGoeMGE00CoeMGE0ol00006omGEe@;o00003_oE
eMD00ol0003oeMGEomGEe@04omGEe@?o0000`?oEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00<Ko
eMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2_omGEe@00a_oEeMD00ol0003oeMGE
omGEe@1eomGEe@03o`000?oEeMGoeMGE0:ooeMGE0037omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o
0000omGEeOoEeMD0[_oEeMD00;_oeMGE1ol00005omGEe@03o`000?oEeMGoeMGE06WoeMGE1ol00005
omGEe@03o`000?oEeMGoeMGE0:koeMGE0038omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGE
eOoEeMD0[OoEeMD00<SoeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2]omGEe@00
bOoEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE0:coeMGE0034omGEe@03o`000?oE
eMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0L?oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oE
eMGoeMGE0:coeMGE0034omGEe@Ko0000L_oEeMD6o`000:koeMGE003oomGEeO7oeMGE003oomGEeO7o
eMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7o
eMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7o
eMGE003oomGEeO7oeMGE0005omGEe@?o00001OoEeMD3o`0000KoeMGE00?o0000omGEeOoEeMD01?oE
eMD4o`0008?oeMGE1Ol0001comGEe@Go0000cooEeMD000CoeMGE00Go0000omGEeOoEeMGoeMGEo`00
0003omGEe@05o`000?oEeMGoeMGEomGEeOl000002ooEeMD00ol0003oeMGEomGEe@02omGEe@03o`00
0?oEeMGoeMGE083oeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@1`omGEe@03o`00
0?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0c?oEeMD000WoeMGE00Co0000omGEeOoEeMGo0000
0ooEeMD00ol0003oeMGEomGEe@0>omGEe@03o`000?oEeMGoeMGE08GoeMGE00?o0000omGEeOoEeMD0
MOoEeMD00ol0003oeMGEomGEe@3<omGEe@002OoEeMD01?l0003oeMGEomGEeOl00003omGEe@03o`00
0?oEeMGoeMGE00koeMGE00?o0000omGEeOoEeMD0POoEeMD4o`0007CoeMGE1?l0003?omGEe@002?oE
eMD01Ol0003oeMGEomGEeOoEeMGo000000?oeMGE00?o0000omGEeOoEeMD02ooEeMD3o`0008?oeMGE
00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@3AomGEe@001?oEeMD4o`0000CoeMGE00Go
0000omGEeOoEeMGoeMGEo`00000@omGEe@03o`000?oEeMGoeMGE083oeMGE00?o0000omGEeOoEeMD0
0_oEeMD00ol0003oeMGEomGEe@1`omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0
c?oEeMD000CoeMGE00?o0000omGEeOoEeMD01OoEeMD01Ol0003oeMGEomGEeOoEeMGo0000013oeMGE
00?o0000omGEeOoEeMD0POoEeMD5o`0007?oeMGE1Ol0003>omGEe@001?oEeMD00ol0003oeMGEomGE
e@05omGEe@05o`000?oEeMGoeMGEomGEeOl000002ooEeMD00ol0003oeMGEomGEe@02omGEe@03o`00
0?oEeMGoeMGE0?ooeMGEcOoEeMD000CoeMGE1_l00003omGEe@?o00003OoEeMD4o`000?ooeMGEd?oE
eMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoE
eMD00?ooeMGElOoEeMD007_oeMGEGol0000IomGEeEoo0000W_oEeMD00?ooeMGElOoEeMD00?ooeMGE
lOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00=GoeMGE0ol0001eomGEe@?o0000X?oEeMD00=So
eMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2MomGEe@00fOoEeMD00ol0003oeMGE
omGEe@1eomGEe@03o`000?oEeMGoeMGE09coeMGE001lomGEe@Go00001OoEeMD00ol0003oeMGEomGE
e@04omGEe@Co00001OoEeMD2o`0000KoeMGE00?o0000omGEeOoEeMD02ooEeMD5o`0000CoeMGE0ol0
000MomGEe@?o000000?oeMGEo`000?oEeMD06OoEeMD5o`0000GoeMGE00?o0000omGEeOoEeMD01?oE
eMD3o`0000KoeMGE0_l00005omGEe@Co00002ooEeMD5o`0000CoeMGE0ol0000MomGEe@?o000000?o
eMGEo`000?oEeMD0WOoEeMD007koeMGE00?o0000omGEeOoEeMD02ooEeMD00ol0003oeMGEomGEe@02
omGEe@05o`000?oEeMGoeMGEomGEeOl000000_oEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oE
eMGoeMGE00goeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001_oeMGE
00Co0000omGEeOoEeMGoeMGE0_l0000LomGEe@03o`000?oEeMGoeMGE00_oeMGE00Go0000omGEeOoE
eMGoeMGEo`000004omGEe@04o`000?oEeMGoeMGEo`0000?oeMGE00?o0000omGEeOoEeMD00_oEeMD0
0ol0003oeMGEomGEe@0:omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00
000KomGEe@04o`000?oEeMGoeMGEomGEe@;o0000W_oEeMD007koeMGE00?o0000omGEeOoEeMD04?oE
eMD01?l0003oeMGEomGEeOl00004omGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD0
3?oEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006_oEeMD00ol0003o
eMGEomGEe@03omGEe@03o`000?oEeMGoeMGE01[oeMGE00?o0000omGEeOoEeMD02ooEeMD01Ol0003o
eMGEomGEeOoEeMGo000000?oeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@05omGE
e@03o`000?oEeMGoeMGE00[oeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo
000001[oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@2LomGEe@00O_oEeMD00ol0
003oeMGEomGEe@0@omGEe@04o`000?oEeMGoeMGEo`0000CoeMGE00?o0000omGEeOoEeMD00ooEeMD0
0ol0003oeMGEomGEe@0<omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00
000JomGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD06_oEeMD00ol0003oeMGEomGE
e@0;omGEe@05o`000?oEeMGoeMGEomGEeOl000000ooEeMD00ol0003oeMGEomGEe@02omGEe@03o`00
0?oEeMGoeMGE00GoeMGE00?o0000omGEeOoEeMD02_oEeMD00ol0003oeMGEomGEe@03omGEe@05o`00
0?oEeMGoeMGEomGEeOl000006_oEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE09co
eMGE001nomGEe@03o`000?oEeMGoeMGE00goeMGE0ol00003omGEe@;o00000_oEeMD00ol0003oeMGE
omGEe@05omGEe@03o`000?oEeMGoeMGE00_oeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGE
omGEeOoEeMGo000001[oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@0JomGEe@03
o`000?oEeMGoeMGE00_oeMGE00Go0000omGEeOoEeMGoeMGEo`000003omGEe@;o00000_oEeMD00ol0
003oeMGEomGEe@03omGEe@?o00003OoEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGE
omGEeOl000006_oEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE09coeMGE001nomGE
e@03o`000?oEeMGoeMGE013oeMGE00Go0000omGEeOoEeMGo0000omGEe@02o`0000SoeMGE00?o0000
omGEeOoEeMD02ooEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006ooE
eMD01?l0003oeMGEomGEeOoEeMD2o`0001coeMGE00?o0000omGEeOoEeMD02ooEeMD01Ol0003oeMGE
omGEeOoEeMGo000000?oeMGE00Co0000omGEeOl0003o00002OoEeMD00ol0003oeMGEomGEe@0:omGE
e@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000KomGEe@04o`000?oEeMGo
eMGEomGEe@;o0000W_oEeMD007coeMGE00?o0000omGEeOl000004_oEeMD01?l0003oeMGEomGEeOl0
000<omGEe@03o`000?oEeMGoeMGE00SoeMGE00?o0000omGEeOl000001OoEeMD01Ol0003oeMGEomGE
eOoEeMGo000001coeMGE0ol000000ooEeMGo0000omGEe@0IomGEe@03o`000?oEeMGo000000goeMGE
00Go0000omGEeOoEeMGoeMGEo`000003omGEe@03o`000?oEeMGoeMGE00[oeMGE00?o0000omGEeOoE
eMD02?oEeMD00ol0003oeMGEo`000005omGEe@05o`000?oEeMGoeMGEomGEeOl000007?oEeMD3o`00
0003omGEeOl0003oeMGE09goeMGE001momGEe@;o00003OoEeMD00ol0003oeMGEomGEe@02omGEe@05
o`000?oEeMGoeMGEomGEeOl000001_oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE
00WoeMGE0_l00005omGEe@05o`000?oEeMGoeMGEomGEeOl00000??oEeMD2o`0000goeMGE00Go0000
omGEeOoEeMGoeMGEo`000004omGEe@03o`000?oEeMGoeMGE00CoeMGE00?o0000omGEeOoEeMD00_oE
eMD00ol0003oeMGEomGEe@09omGEe@;o00001OoEeMD01Ol0003oeMGEomGEeOoEeMGo00000;ooeMGE
001nomGEe@03o`000?oEeMGoeMGE00coeMGE1?l00005omGEe@;o00001?oEeMD6o`0000coeMGE00?o
0000omGEeOoEeMD01?oEeMD3o`0003koeMGE00?o0000omGEeOoEeMD03?oEeMD3o`0000KoeMGE0_l0
0005omGEe@Co00003OoEeMD00ol0003oeMGEomGEe@04omGEe@?o0000`?oEeMD00?ooeMGElOoEeMD0
0?ooeMGElOoEeMD00?ooeMGElOoEeMD00<KoeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGE
omGEe@2_omGEe@00a_oEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE0:ooeMGE0037
omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0[_oEeMD00;_oeMGE1ol00005omGE
e@03o`000?oEeMGoeMGE06WoeMGE1ol00005omGEe@03o`000?oEeMGoeMGE0:koeMGE0038omGEe@03
o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0[OoEeMD00<SoeMGE00?o0000omGEeOoEeMD0
MOoEeMD00ol0003oeMGEomGEe@2]omGEe@00bOoEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oE
eMGoeMGE0:coeMGE0034omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0L?oEeMD0
0ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE0:coeMGE0034omGEe@Ko0000L_oEeMD6o`00
0:koeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGE
eO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE0000\
\>"]],

Cell[TextData[StyleBox["DUMBBELLS",
  FontFamily->"Geneva",
  FontSize->14]], "Text",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "740d14c2-3b9a-4b9d-9930-f1f12161a0c6"],

Cell[TextData[StyleBox["Here are the dumbbell calculations.  We use a linear \
array that is the same as\nbefore, but another subunit is added at the end.",
  FontFamily->"Geneva",
  FontWeight->"Plain"]], "Text",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "77e1a716-7389-42c6-8cfb-df98878aa870"],

Cell[CellGroupData[{

Cell["\<\
f1Kirk={};
f1robert={};
frictionratio={};
rij={};
Do[
\tPrint[nbasepairs[[k]],\" bp spacer\"];
\t
\tPrint[\"My model:\"];
\tntot=3;
\tsnaked[nbasepairs[[k]]];
\tradii={r1,rstokes,r1};
\trij={{0,r1 + lengthp[[k]] r1/2,2 r1 + lengthp[[k]] r1},
\t\t {0,0,r1 + lengthp[[k]] r1/2},
\t\t {0,0,0}};
\tdoKirkwoodG;
\tf1robert=Append[f1robert,f1];

\tPrint[\"Kirk's model:\"];\t
\tntot=lengthp[[k]]+2;
\tradii={r1};
\tDo[radii=Append[radii,r2],{i,lengthp[[k]]}];
\tradii=Append[radii,r1];
\trij=Table[0,{i,ntot},{j,ntot}];
\tDo[ Do[\tIf[\tj<ntot,
\t\t\t\trij[[i,j]]=radii[[i]] + (j-i-1) 2 r2 + r2,
\t\t\t\trij[[i,j]]=radii[[i]] + (j-i-1) 2 r2 + radii[[j]]
\t\t\t],
\t\t{j,i+1,ntot}],
\t{i,ntot}];
\tdoKirkwoodG;
\tf1Kirk=Append[f1Kirk,N[f1]],

{k,Length[lengthp]}];\
\>", "Input",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "f192879c-eece-4888-a711-e8121504a79e"],

Cell[BoxData[
    InterpretationBox[\(50.29411764705882`\[InvisibleSpace]" bp spacer"\),
      SequenceForm[ 50.294117647058819, " bp spacer"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("My model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(2.8879598424182434`*^-7\ g\)\
\/s, \(1.8733129814633894`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 2.8879598424182434*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.8733129814633894*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Kirk's model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(3.1331662486415936`*^-7\ g\)\
\/s, \(1.4686045034706145`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 3.1331662486415936*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.4686045034706145*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(67.05882352941177`\[InvisibleSpace]" bp spacer"\),
      SequenceForm[ 67.058823529411768, " bp spacer"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("My model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(3.0155593567931384`*^-7\ g\)\
\/s, \(2.025660123601962`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 3.0155593567931384*^-07, g, 
          Power[ s, -1]], 
        Times[ 2.0256601236019619*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Kirk's model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(3.449811343170023`*^-7\ \
g\)\/s, \(1.50246287146377`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 3.4498113431700229*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.50246287146377*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(83.8235294117647`\[InvisibleSpace]" bp spacer"\),
      SequenceForm[ 83.823529411764696, " bp spacer"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("My model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(3.138978294309158`*^-7\ \
g\)\/s, \(2.168799700448361`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 3.1389782943091582*^-07, g, 
          Power[ s, -1]], 
        Times[ 2.1687997004483609*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Kirk's model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(3.766456437698452`*^-7\ \
g\)\/s, \(1.5439205505528974`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 3.7664564376984522*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.5439205505528974*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(100.58823529411764`\[InvisibleSpace]" bp spacer"\),
      SequenceForm[ 100.58823529411764, " bp spacer"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("My model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(3.2586268138350456`*^-7\ g\)\
\/s, \(2.3049312020097144`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 3.2586268138350456*^-07, g, 
          Power[ s, -1]], 
        Times[ 2.3049312020097144*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Kirk's model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(4.083101532226881`*^-7\ \
g\)\/s, \(1.5903348457716407`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 4.0831015322268809*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.5903348457716407*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(134.11764705882354`\[InvisibleSpace]" bp spacer"\),
      SequenceForm[ 134.11764705882354, " bp spacer"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("My model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(3.488675635397889`*^-7\ \
g\)\/s, \(2.5615553986838474`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 3.4886756353978893*^-07, g, 
          Power[ s, -1]], 
        Times[ 2.5615553986838474*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Kirk's model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(4.7163917212837406`*^-7\ g\)\
\/s, \(1.6921236789650012`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 4.7163917212837406*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.6921236789650012*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(167.6470588235294`\[InvisibleSpace]" bp spacer"\),
      SequenceForm[ 167.64705882352939, " bp spacer"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("My model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(3.709041697069329`*^-7\ \
g\)\/s, \(2.802867244790704`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 3.7090416970693291*^-07, g, 
          Power[ s, -1]], 
        Times[ 2.8028672447907041*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Kirk's model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(5.3496819103406`*^-7\ \
g\)\/s, \(1.800548390249779`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 5.3496819103406002*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.8005483902497789*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(201.17647058823528`\[InvisibleSpace]" bp spacer"\),
      SequenceForm[ 201.17647058823528, " bp spacer"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("My model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(3.921926607728275`*^-7\ \
g\)\/s, \(3.032983355178597`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 3.921926607728275*^-07, g, 
          Power[ s, -1]], 
        Times[ 3.0329833551785971*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Kirk's model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(5.982972099397459`*^-7\ \
g\)\/s, \(1.9122698880095092`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 5.9829720993974588*^-07, g, 
          Power[ s, -1]], 
        Times[ 1.9122698880095092*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(234.70588235294116`\[InvisibleSpace]" bp spacer"\),
      SequenceForm[ 234.70588235294116, " bp spacer"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("My model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(4.1288066038789417`*^-7\ g\)\
\/s, \(3.2544660366026573`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 4.1288066038789417*^-07, g, 
          Power[ s, -1]], 
        Times[ 3.2544660366026573*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Kirk's model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(6.616262288454318`*^-7\ \
g\)\/s, \(2.0255902967328093`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 6.6162622884543185*^-07, g, 
          Power[ s, -1]], 
        Times[ 2.0255902967328093*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(268.2352941176471`\[InvisibleSpace]" bp spacer"\),
      SequenceForm[ 268.23529411764707, " bp spacer"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("My model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(4.330719203625728`*^-7\ \
g\)\/s, \(3.4690290645114094`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 4.330719203625728*^-07, g, 
          Power[ s, -1]], 
        Times[ 3.4690290645114094*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Kirk's model:"\)], "Print"],

Cell[BoxData[
    \("   Kirkwood results: {f free-draining,f1}"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("   "\[InvisibleSpace]{\(7.249552477511177`*^-7\ \
g\)\/s, \(2.1395825044474415`*^-7\ g\)\/s}\),
      SequenceForm[ "   ", {
        Times[ 7.2495524775111771*^-07, g, 
          Power[ s, -1]], 
        Times[ 2.1395825044474415*^-07, g, 
          Power[ s, -1]]}],
      Editable->False]], "Print"]
}, Open  ]],

Cell["\<\
CHR Feb 2020. Dumbbell geometry friction coefficients are identical \
to the corresponding results in \"Figure 2 calculations.nb\" with the \
exception of the number of reported significant figures (6 here versus 4 in \
the original). The 1st and 3rd columns of figures were plotted as the solid \
lines in Figure 2. (The dotted lines and black circles in Figure 2 were \
obtained from previous work.)\
\>", "Text",
  CellFrame->True,
  ExpressionUUID -> "db92427a-7006-4c0f-82db-379c3406f611",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[0.833326]],

Cell[CellGroupData[{

Cell["\<\
MatrixForm[Transpose[{N[nbasepairs,3],N[f1robert,4],N[f1Kirk,4]}]]\
\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "7a2fa8db-5b6f-4824-8707-594aea979f9a"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {
              "50.29411764705882`", \(\(1.8733129814633894`*^-7\ g\)\/s\), \(\
\(1.4686045034706145`*^-7\ g\)\/s\)},
            {
              "67.05882352941177`", \(\(2.025660123601962`*^-7\ g\)\/s\), \
\(\(1.50246287146377`*^-7\ g\)\/s\)},
            {
              "83.8235294117647`", \(\(2.168799700448361`*^-7\ g\)\/s\), \
\(\(1.5439205505528974`*^-7\ g\)\/s\)},
            {
              "100.58823529411764`", \(\(2.3049312020097144`*^-7\ g\)\/s\), \
\(\(1.5903348457716407`*^-7\ g\)\/s\)},
            {
              "134.11764705882354`", \(\(2.5615553986838474`*^-7\ g\)\/s\), \
\(\(1.6921236789650012`*^-7\ g\)\/s\)},
            {
              "167.6470588235294`", \(\(2.802867244790704`*^-7\ g\)\/s\), \
\(\(1.800548390249779`*^-7\ g\)\/s\)},
            {
              "201.17647058823528`", \(\(3.032983355178597`*^-7\ g\)\/s\), \(\
\(1.9122698880095092`*^-7\ g\)\/s\)},
            {
              "234.70588235294116`", \(\(3.2544660366026573`*^-7\ g\)\/s\), \
\(\(2.0255902967328093`*^-7\ g\)\/s\)},
            {
              "268.2352941176471`", \(\(3.4690290645114094`*^-7\ g\)\/s\), \(\
\(2.1395825044474415`*^-7\ g\)\/s\)}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(\(\(xDumbbell = nbasepairs;\)\[IndentingNewLine]
    \(yDumbbell = f1robert;\)\ \[IndentingNewLine]
    \(yDumbbell2 = f1Kirk;\)\)\(\ \)\)\)], "Input",
  CellFrame->True,
  ExpressionUUID -> "032bf2ad-cf5d-431f-9939-455117192e46",
  Background->GrayLevel[0.833326]],

Cell["\<\
Copy-paste the original output here for comparison. The \
recalculated results match to all provided significant figures.\
\>", "Text",
  CellFrame->True,
  ExpressionUUID -> "1d51e8c9-4b34-40de-ab5c-6d2c7d6d07cc",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[0.833326]],

Cell[GraphicsData["PostScript", "\<\
%!PS-Adobe-2.0 EPSF-1.2
%%BoundingBox: 18 18 349 356
%%HiResBoundingBox: 18.375 18.375 348.375 355.875
%%Creator: (Mathematica 5.2 for Macintosh)
%%CreationDate: (Sunday, March 29, 2020) (19:18:30)
%%Title: Clipboard
%%DocumentNeededResources: (atend)
%%DocumentFonts: (atend)
%%DocumentNeededFonts: (atend)
%%EndComments
0 374.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def

%%MathematicaCell
%Cell[GraphicsData[\"PICT\", \\
%\"\\<\\
%24X04`0X0?@1100A0_l<0?ooool0:00001<\\
%000440000m0000000000N00402P0C
%02P0m09@02`02P0F1d=_MG9YIG800`0F00d02@0^00@0000002/Y6bPP820P820P
%820P820P820P820P820P82dg820P820P820P820P82dg000Z1BXP820P820P820P
%820P820a;SPg<b0a<20P86LP820a;S@f>B0a<20P86L0:PDZ820P820P820P820P
%820P;Bd];Bd];Bd];Bd]820P;Bd];Bd];Bd];Bd]02T2:R0P820P820P820P820P
%82d];Bd];Bd];Bd]820P82d];Bd];Bd];Bd]800X02X0:B@e<2hc820P820P820P
%820P820P87<P820P820P820P820P87<002X::20P820P820P820P820P820P820P
%820P;CLP820P820P820P820P;CL0:PDZ820P820P820P820P820P<Rh`<SHP<C0P
%821W820P<Bhe<38P<C0P821W02X5:R0P820P820P820P820P82d];Bd];Bd];Bd]
%;B0P82d];Bd];Bd];Bd];@0Y0RXP820P820P820P820P820];Bd];Bd];Bd];B0P
%820];Bd];Bd];Bd];B00:01302TT=SL^<B0P820P820P820P820P821c820P820P
%820P820P821c000Z2RPP820P820P820P820P820P820P820P82dg820P820P820P
%820P82dg02X5:R0P820P820P820P820P838^<CHi834`820PIb0P834^=C@d834`
%820PI`0Z1BXP820P820P820P820P820];Bd];Bd];Bd];BdP820];Bd];Bd];Bd]
%;Bd0:@8Z820P820P820P820P820P;Bd];Bd];Bd];BdP820P;Bd];Bd];Bd];BdP
%02P0G00Y93Pc;SPP820P820P820P820P820PLb0P820P820P820P820PL`00:PXW
%820P820P820P820P820P820P820P820]=b0P820P820P820P82dg000Z1BTP820P
%820P820P820P820b;S<`=B0a<20P86LP820a;SDi834`820PI`00:PDY820P820P
%820P820P820P;Bd];Bd];Bd];Bd]820P;Bd];Bd];Bd];Bd002T2:B0P820P820P
%820P820P82d];Bd];Bd];Bd]820P82d];Bd];Bd];BdP000X07D0:B@a<34^820P
%820P820P820P820P87<P820P820P820P820P87<002X::20P820P820P820P820P
%820P820P820P;CLP820P820P820P820P;CL0:PDZ820P820P820P820P820P<Rhe
%=S8P<C0P821W820P<Bhf>C8P<C0P821W02X5:R0P820P820P820P820P82d];Bd]
%;Bd];Bd];B0P82d];Bd];Bd];Bd];@0Y0RXP820P820P820P820P820];Bd];Bd]
%;Bd];B0P820];Bd];Bd];Bd];B00:02>02TT<C<d;R0P820P820P820P820P821c
%820P820P820P820P821c000Z2RPP820P820P820P820P820P820P820P82dg820P
%820P820P820P82dg02X5:R0P820P820P820P820P838^>30c834`820PIb0P834^
%>30a834`820PI`0Z1BXP820P820P820P820P820];Bd];Bd];Bd];BdP820];Bd]
%;Bd];Bd];Bd0:@8Z820P820P820P820P820P;Bd];Bd];Bd];BdP820P;Bd];Bd]
%;Bd];BdP02P0Y`0Y934f>2hP820P820P820P820P820PLb0P820P820P820P820P
%L`00:PXX820P820P820P820P820P820P820P820]=b0P820P820P820P820]=`0Z
%1BXP820P820P820P820P820c;S0c<b0a<20P86LP820a;STa<R0a<20P86L0:PDZ
%820P820P820P820P820P;Bd];Bd];Bd];Bd]820P;Bd];Bd];Bd];Bd]02T2:R0P
%820P820P820P820P82d];Bd];Bd];Bd]820P82d];Bd];Bd];Bd]800X0<00:B@b
%<34^820P820P820P820P820P87<P820P820P820P820P87<002X::20P820P820P
%820P820P820P820P820P;CLP820P820P820P820P;CL0:PDZ820P820P820P820P
%820P<bhb=C@P<C0P821W820P<Rh`<SHP<C0P821W02X5:R0P820P820P820P820P
%82d];Bd];Bd];Bd];B0P82d];Bd];Bd];Bd];@0Y0RXP820P820P820P820P820]
%;Bd];Bd];Bd];B0P820];Bd];Bd];Bd];B00:03I02TT<S<e;R0P820P820P820P
%820P821c820P820P820P820P821c000Z2RLP820P820P820P820P820P820P820P
%82dg820P820P820P820P;CL002X5:B0P820P820P820P820P83<^=3Hi834`820P
%Ib0P838^<C@P<C0P821W000Z1BTP820P820P820P820P820];Bd];Bd];Bd];BdP
%820];Bd];Bd];Bd];@00:@8Y820P820P820P820P820P;Bd];Bd];Bd];BdP820P
%;Bd];Bd];Bd];B0002P0lP0Y938f>2hP820P820P820P820P820PLb0P820P820P
%820P820PL`00o`\\>\"], \"Graphics\",
%  CellFrame->True,
%  ImageSize->{220, 225},
%  ImageMargins->{{0, Inherited}, {Inherited, Inherited}},
%  ImageRegion->{{-0, 1}, {0, 1}},
%  FontSize->9,
%  Background->GrayLevel[0.833326]]
%%EndMathematicaCell
0.833 0.833 0.833 setrgbcolor
newpath
 6.000 367.250 moveto
 1242.438 367.250 lineto
 1242.438 6.000 lineto
 6.000 6.000 lineto
 6.000 367.250 lineto
closepath
fill
0.000 0.000 0.000 setrgbcolor
1.5 setlinewidth
/Courier findfont 9 scalefont setfont
20 30 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 38 moveto (               1.873 10   g   1.469 10   g) show
/Courier findfont 9 scalefont setfont
20 45 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 45 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 53 moveto (50.3                s              s) show
/Courier findfont 9 scalefont setfont
20 68 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 75 moveto (               2.026 10   g   1.502 10   g) show
/Courier findfont 9 scalefont setfont
20 83 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 83 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 90 moveto (67.1                s              s) show
/Courier findfont 9 scalefont setfont
20 105 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 113 moveto (               2.169 10   g   1.544 10   g) show
/Courier findfont 9 scalefont setfont
20 120 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 120 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 128 moveto (83.8                s              s) show
/Courier findfont 9 scalefont setfont
20 143 moveto (                       -7            -7) show
/Courier findfont 9 scalefont setfont
20 150 moveto (               2.305 10   g   1.59 10   g) show
/Courier findfont 9 scalefont setfont
20 158 moveto (               ------------   -----------) show
/Courier findfont 9 scalefont setfont
23 158 moveto (               -----------    ---------- ) show
/Courier findfont 9 scalefont setfont
20 165 moveto (101.                s              s) show
/Courier findfont 9 scalefont setfont
20 180 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 187 moveto (               2.562 10   g   1.692 10   g) show
/Courier findfont 9 scalefont setfont
20 195 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 195 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 202 moveto (134.                s              s) show
/Courier findfont 9 scalefont setfont
20 217 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 225 moveto (               2.803 10   g   1.801 10   g) show
/Courier findfont 9 scalefont setfont
20 232 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 232 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 240 moveto (168.                s              s) show
/Courier findfont 9 scalefont setfont
20 255 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 262 moveto (               3.033 10   g   1.912 10   g) show
/Courier findfont 9 scalefont setfont
20 270 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 270 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 277 moveto (201.                s              s) show
/Courier findfont 9 scalefont setfont
20 292 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 300 moveto (               3.254 10   g   2.026 10   g) show
/Courier findfont 9 scalefont setfont
20 307 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 307 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 315 moveto (235.                s              s) show
/Courier findfont 9 scalefont setfont
20 330 moveto (                       -7            -7) show
/Courier findfont 9 scalefont setfont
20 337 moveto (               3.469 10   g   2.14 10   g) show
/Courier findfont 9 scalefont setfont
20 345 moveto (               ------------   -----------) show
/Courier findfont 9 scalefont setfont
23 345 moveto (               -----------    ---------- ) show
/Courier findfont 9 scalefont setfont
20 352 moveto (268.                s              s) show
%%Trailer
%%EOF
\
\>"], "Graphics",
  CellFrame->True,
  Evaluatable->False,
  ImageSize->{331, 338},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "f9dfc2a8-01e8-4a17-8c7a-5f8a5323ea9f",
  FontSize->9,
  Background->GrayLevel[0.833326],
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007`0001nb000`400?l00000o`00003ooooEeMGa
omGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGa
omGEe@00oooEeMGaomGEe@001?oEeMD6o`0000CoeMGE0_l00005omGEe@Co00001OoEeMD00ol0003o
eMGEomGEe@23omGEe@Go0000LooEeMD5o`000<ooeMGE0004omGEe@03o`000?oEeMGoeMGE00;oeMGE
00Go0000omGEeOoEeMGoeMGEo`000002omGEe@05o`000?oEeMGoeMGEomGEeOl000001?oEeMD00ol0
003oeMGEomGEe@28omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0L?oEeMD00ol0
003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE0<coeMGE0005omGEe@03o`000?oEeMGoeMGE00Co
eMGE00?o0000omGEeOoEeMD00_oEeMD01?l0003oeMGEomGEeOl00004omGEe@03o`000?oEeMGoeMGE
08goeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@3<omGEe@001_oEeMD00ol0003o
eMGEomGEe@03omGEe@03o`000?oEeMGoeMGE00;oeMGE00Co0000omGEeOoEeMGo00001?oEeMD00ol0
003oeMGEomGEe@29omGEe@Co0000M?oEeMD4o`000<ooeMGE0007omGEe@03o`000?oEeMGoeMGE00;o
eMGE0_l00002omGEe@03o`000?oEeMGoeMGE00;oeMGE1?l0002;omGEe@03o`000?oEeMGoeMGE07Go
eMGE00?o0000omGEeOoEeMD0dOoEeMD000SoeMGE00Ko0000omGEeOoEeMGoeMGEo`000?oEeMD2o`00
00CoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@28omGEe@03o`000?oEeMGoeMGE
00;oeMGE00?o0000omGEeOoEeMD0L?oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE
0<coeMGE0009omGEe@04o`000?oEeMGoeMGEo`0000OoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0
003oeMGEomGEe@29omGEe@Go0000LooEeMD5o`000<koeMGE0004omGEe@03o`000?oEeMGoeMGE00;o
eMGE00Go0000omGEeOoEeMGoeMGEo`000006omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGE
eOoEeMD0oooEeMGEomGEe@001OoEeMD4o`0000GoeMGE0_l00005omGEe@Co0000oooEeMGHomGEe@00
oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00NooEeMEOo`0001Wo
eMGEEol0002VomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGE
e@00oooEeMGaomGEe@00eOoEeMD3o`0006goeMGE0ol0002XomGEe@00f?oEeMD00ol0003oeMGEomGE
e@1]omGEe@03o`000?oEeMGoeMGE0:GoeMGE003IomGEe@03o`000?oEeMGoeMGE06goeMGE00?o0000
omGEeOoEeMD0Y?oEeMD007goeMGE1?l00005omGEe@03o`000?oEeMGoeMGE00GoeMGE1?l00004omGE
e@;o00001_oEeMD2o`0000coeMGE1Ol00004omGEe@?o00007OoEeMD3o`000003omGEeOl0003oeMGE
01WoeMGE1_l00004omGEe@03o`000?oEeMGoeMGE00?oeMGE1Ol00005omGEe@Co00002_oEeMD5o`00
00CoeMGE0ol0000MomGEe@?o000000?oeMGEo`000?oEeMD0YOoEeMD007coeMGE00?o0000omGEeOoE
eMD00_oEeMD00ol0003oeMGEomGEe@0<omGEe@03o`000?oEeMGoeMGE00;oeMGE00Co0000omGEeOoE
eMGo00001ooEeMD00ol0003oeMGEomGEe@0;omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGE
eOoEeMGoeMGEo`00000KomGEe@04o`000?oEeMGoeMGEomGEe@;o00006_oEeMD00ol0003oeMGEomGE
e@02omGEe@03o`000?oEeMGoeMGE00[oeMGE00?o0000omGEeOoEeMD01ooEeMD00ol0003oeMGEomGE
e@0;omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000KomGEe@04o`00
0?oEeMGoeMGEomGEe@;o0000Y_oEeMD0087oeMGE00?o0000omGEeOoEeMD03?oEeMD01Ol0003oeMGE
omGEeOoEeMGo000000CoeMGE00?o0000omGEeOoEeMD01OoEeMD00ol0003oeMGEomGEe@0:omGEe@03
o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03o`000?oEeMGoeMGE
00?oeMGE00?o0000omGEeOoEeMD06OoEeMD00ol0003oeMGEomGEe@0>omGEe@03o`000?oEeMGoeMGE
00OoeMGE00?o0000omGEeOoEeMD02ooEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGE
omGEeOl000006_oEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE0:CoeMGE0021omGE
e@03o`000?oEeMGoeMGE00SoeMGE1_l00002omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGE
eOoEeMD00_oEeMD2o`000003omGEeOl0003oeMGE00_oeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0
003oeMGEomGEeOoEeMGo000001[oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@0J
omGEe@03o`000?oEeMGoeMGE00goeMGE00?o0000omGEeOoEeMD00ooEeMD6o`0000coeMGE00?o0000
omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001[oeMGE00?o0000omGEeOoEeMD00ooE
eMD00ol0003oeMGEomGEe@2TomGEe@00O_oEeMD3o`0000_oeMGE00Go0000omGEeOoEeMGoeMGEo`00
0003omGEe@;o00000_oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE00;o00003?oE
eMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006_oEeMD00ol0003oeMGE
omGEe@03omGEe@03o`000?oEeMGoeMGE01_oeMGE00?o0000omGEeOoEeMD03?oEeMD00ol0003oeMGE
omGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000003OoEeMD00ol0003oeMGEomGEe@03omGEe@05
o`000?oEeMGoeMGEomGEeOl000006_oEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE
0:CoeMGE0021omGEe@03o`000?oEeMGoeMGE00WoeMGE00Co0000omGEeOoEeMGo00000ooEeMD01?l0
003oeMGEo`000?l00004omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD02_oEeMD0
0ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006ooEeMD01?l0003oeMGEomGE
eOoEeMD2o`0001koeMGE00?o0000omGEeOoEeMD02ooEeMD00ol0003oeMGEomGEe@04omGEe@04o`00
0?oEeMGoeMGEo`0000goeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo0000
01_oeMGE00Co0000omGEeOoEeMGoeMGE0_l0002VomGEe@00POoEeMD00ol0003oeMGEomGEe@0:omGE
e@03o`000?oEeMGo000000?oeMGE00?o0000omGEeOoEeMD01OoEeMD00ol0003oeMGEomGEe@02omGE
e@03o`000?oEeMGoeMGE00SoeMGE00?o0000omGEeOl000001OoEeMD01Ol0003oeMGEomGEeOoEeMGo
000001coeMGE0ol000000ooEeMGo0000omGEe@0NomGEe@03o`000?oEeMGoeMGE00SoeMGE00?o0000
omGEeOl000001ooEeMD00ol0003oeMGEo`00000;omGEe@03o`000?oEeMGo000000GoeMGE00Go0000
omGEeOoEeMGoeMGEo`00000LomGEe@?o000000?oeMGEo`000?oEeMD0YOoEeMD007coeMGE00?o0000
omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@0;omGEe@;o00001?oEeMD00ol0003oeMGEomGEe@05
omGEe@04o`000?oEeMGoeMGEo`0000coeMGE0_l00005omGEe@05o`000?oEeMGoeMGEomGEeOl00000
>ooEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE00WoeMGE0_l00008omGEe@;o0000
3?oEeMD2o`0000GoeMGE00Go0000omGEeOoEeMGoeMGEo`000037omGEe@00OOoEeMD4o`0000ooeMGE
00?o0000omGEeOoEeMD00ooEeMD2o`0000KoeMGE0_l0000>omGEe@03o`000?oEeMGoeMGE00CoeMGE
0ol0000momGEe@Co00003OoEeMD00ol0003oeMGEomGEe@07omGEe@03o`000?oEeMGoeMGE00_oeMGE
00?o0000omGEeOoEeMD01?oEeMD3o`000<SoeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE0036omGE
e@03o`000?oEeMGoeMGE06goeMGE00?o0000omGEeOoEeMD0]ooEeMD00<KoeMGE00?o0000omGEeOoE
eMD0KOoEeMD00ol0003oeMGEomGEe@2gomGEe@00aooEeMD00ol0003oeMGEomGEe@1]omGEe@03o`00
0?oEeMGoeMGE0;KoeMGE002komGEe@Oo00001OoEeMD00ol0003oeMGEomGEe@1QomGEe@Oo00001OoE
eMD00ol0003oeMGEomGEe@2fomGEe@00b?oEeMD00ol0003oeMGEomGEe@1]omGEe@03o`000?oEeMGo
eMGE0;GoeMGE0038omGEe@03o`000?oEeMGoeMGE06goeMGE00?o0000omGEeOoEeMD0]OoEeMD00<Wo
eMGE00?o0000omGEeOoEeMD0KOoEeMD00ol0003oeMGEomGEe@2domGEe@00a?oEeMD00ol0003oeMGE
omGEe@02omGEe@03o`000?oEeMGoeMGE06SoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGE
omGEe@2domGEe@00a?oEeMD6o`0006[oeMGE1_l0002fomGEe@00oooEeMGaomGEe@00oooEeMGaomGE
e@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGE
e@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGE
e@00oooEeMGaomGEe@001?oEeMD6o`0000?oeMGE1?l00004omGEe@?o00001_oEeMD00ol0003oeMGE
omGEe@23omGEe@Go0000LooEeMD5o`000<ooeMGE0004omGEe@03o`000?oEeMGoeMGE00;oeMGE00Co
0000omGEeOoEeMGo00001?oEeMD01?l0003oeMGEomGEeOl00003omGEe@03o`000?oEeMGoeMGE08Wo
eMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@1`omGEe@03o`000?oEeMGoeMGE00;o
eMGE00?o0000omGEeOoEeMD0c?oEeMD000GoeMGE00?o0000omGEeOoEeMD02OoEeMD00ol0003oeMGE
omGEe@05omGEe@03o`000?oEeMGoeMGE08goeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGE
omGEe@3<omGEe@001_oEeMD00ol0003oeMGEomGEe@08omGEe@03o`000?oEeMGoeMGE00GoeMGE00?o
0000omGEeOoEeMD0ROoEeMD4o`0007CoeMGE1?l0003?omGEe@001ooEeMD00ol0003oeMGEomGEe@04
omGEe@?o00001ooEeMD00ol0003oeMGEomGEe@29omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000
omGEeOoEeMD0dOoEeMD000SoeMGE00?o0000omGEeOoEeMD01_oEeMD00ol0003oeMGEomGEe@04o`00
08coeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@1`omGEe@03o`000?oEeMGoeMGE
00;oeMGE00?o0000omGEeOoEeMD0c?oEeMD000WoeMGE00?o0000omGEeOoEeMD01OoEeMD01?l0003o
eMGEomGEeOl0002@omGEe@Go0000LooEeMD5o`000<koeMGE0004omGEe@03o`000?oEeMGoeMGE00;o
eMGE00Co0000omGEeOoEeMGo00001?oEeMD01?l0003oeMGEomGEeOl0003oomGEeMcoeMGE0005omGE
e@Co00001?oEeMD4o`0000?oeMGE1_l0003oomGEeMOoeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE
003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE001komGEeEoo0000
6OoEeMEOo`0009koeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7o
eMGE003EomGEe@?o0000MOoEeMD3o`000:3oeMGE003HomGEe@03o`000?oEeMGoeMGE07GoeMGE00?o
0000omGEeOoEeMD0WOoEeMD00=WoeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2L
omGEe@00OOoEeMD4o`0000GoeMGE00?o0000omGEeOoEeMD00ooEeMD6o`0000?oeMGE0ol00006omGE
e@Co00002_oEeMD5o`0000CoeMGE0ol0000MomGEe@?o000000?oeMGEo`000?oEeMD06OoEeMD6o`00
00CoeMGE00?o0000omGEeOoEeMD01?oEeMD3o`0000CoeMGE1_l00004omGEe@;o00003?oEeMD5o`00
00CoeMGE0ol0000MomGEe@?o000000?oeMGEo`000?oEeMD0WOoEeMD007coeMGE00?o0000omGEeOoE
eMD00_oEeMD00ol0003oeMGEomGEe@08omGEe@03o`000?oEeMGoeMGE00;oeMGE00Co0000omGEeOoE
eMGo00000ooEeMD00ol0003oeMGEomGEe@05omGEe@03o`000?oEeMGoeMGE00_oeMGE00?o0000omGE
eOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001_oeMGE00Co0000omGEeOoEeMGoeMGE0_l0
000JomGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD02?oEeMD01Ol0003oeMGEomGE
eOoEeMGo000000?oeMGE00?o0000omGEeOoEeMD00_oEeMD01Ol0003oeMGEomGEeOoEeMGo000000;o
eMGE00?o0000omGEeOoEeMD02ooEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGE
eOl000006ooEeMD01?l0003oeMGEomGEeOoEeMD2o`0009koeMGE0021omGEe@03o`000?oEeMGoeMGE
00WoeMGE00?o0000omGEeOoEeMD02OoEeMD00ol0003oeMGEomGEe@04omGEe@03o`000?oEeMGoeMGE
00_oeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001[oeMGE00?o0000
omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@0IomGEe@03o`000?oEeMGoeMGE00coeMGE00Go0000
omGEeOoEeMGoeMGEo`000004omGEe@03o`000?oEeMGoeMGE00CoeMGE00?o0000omGEeOoEeMD00_oE
eMD00ol0003oeMGEomGEe@0:omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGE
o`00000JomGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD0W?oEeMD0087oeMGE00?o
0000omGEeOoEeMD02_oEeMD00ol0003oeMGEomGEe@08omGEe@03o`000?oEeMGoeMGE00Ko00003?oE
eMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006_oEeMD00ol0003oeMGE
omGEe@03omGEe@03o`000?oEeMGoeMGE01[oeMGE00?o0000omGEeOoEeMD02ooEeMD01Ol0003oeMGE
omGEeOoEeMGo000000GoeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@02omGEe@03
o`000?oEeMGoeMGE00[oeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo0000
01[oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@2LomGEe@00O_oEeMD3o`0000ko
eMGE00?o0000omGEeOoEeMD01_oEeMD01Ol0003oeMGEomGEeOoEeMGo000000?oeMGE00?o0000omGE
eOoEeMD02ooEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006_oEeMD0
0ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE01_oeMGE00?o0000omGEeOoEeMD02_oEeMD0
1Ol0003oeMGEomGEeOoEeMGo000000KoeMGE00?o0000omGEeOoEeMD00_oEeMD2o`0000;oeMGE00?o
0000omGEeOoEeMD02ooEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl00000
6_oEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE09coeMGE0021omGEe@03o`000?oE
eMGoeMGE00coeMGE00Co0000omGEeOoEeMGoeMGE1?l00005omGEe@04o`000?oEeMGoeMGEo`0000go
eMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001_oeMGE00Co0000omGE
eOoEeMGoeMGE0_l0000NomGEe@03o`000?oEeMGoeMGE00WoeMGE00Go0000omGEeOoEeMGoeMGEo`00
0007omGEe@06o`000?oEeMGoeMGEomGEeOl0003oeMGE0_l0000>omGEe@03o`000?oEeMGoeMGE00?o
eMGE00Go0000omGEeOoEeMGoeMGEo`00000KomGEe@04o`000?oEeMGoeMGEomGEe@;o0000W_oEeMD0
087oeMGE00?o0000omGEeOoEeMD03OoEeMD01?l0003oeMGEomGEeOl00009omGEe@03o`000?oEeMGo
000000_oeMGE00?o0000omGEeOl000001OoEeMD01Ol0003oeMGEomGEeOoEeMGo000001coeMGE0ol0
00000ooEeMGo0000omGEe@0NomGEe@03o`000?oEeMGoeMGE00SoeMGE00Go0000omGEeOoEeMGoeMGE
o`000008omGEe@04o`000?oEeMGoeMGEo`0000ooeMGE00?o0000omGEeOl000001OoEeMD01Ol0003o
eMGEomGEeOoEeMGo000001coeMGE0ol000000ooEeMGo0000omGEe@2MomGEe@00O?oEeMD00ol0003o
eMGEomGEe@02omGEe@03o`000?oEeMGoeMGE00SoeMGE00?o0000omGEeOoEeMD00_oEeMD01?l0003o
eMGEomGEeOl0000:omGEe@;o00003?oEeMD2o`0000GoeMGE00Go0000omGEeOoEeMGoeMGEo`00000k
omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD02?oEeMD01Ol0003oeMGEomGEeOoE
eMGo000000?oeMGE00?o0000omGEeOoEeMD00_oEeMD01Ol0003oeMGEomGEeOoEeMGo000000ooeMGE
0_l00005omGEe@05o`000?oEeMGoeMGEomGEeOl00000_ooEeMD007goeMGE1?l0000<omGEe@Co0000
0ooEeMD6o`0000KoeMGE00?o0000omGEeOoEeMD02ooEeMD00ol0003oeMGEomGEe@04omGEe@?o0000
?OoEeMD4o`0000coeMGE0ol00005omGEe@Co00001OoEeMD2o`0000koeMGE00?o0000omGEeOoEeMD0
1?oEeMD3o`000<3oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE0036omGEe@03
o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0[ooEeMD00<KoeMGE00?o0000omGEeOoEeMD0
MOoEeMD00ol0003oeMGEomGEe@2_omGEe@00aooEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oE
eMGoeMGE0:koeMGE002komGEe@Oo00001OoEeMD00ol0003oeMGEomGEe@1YomGEe@Oo00001OoEeMD0
0ol0003oeMGEomGEe@2^omGEe@00b?oEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE
0:goeMGE0038omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0[OoEeMD00<WoeMGE
00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2/omGEe@00a?oEeMD00ol0003oeMGEomGE
e@02omGEe@03o`000?oEeMGoeMGE073oeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGE
e@2/omGEe@00a?oEeMD6o`0007;oeMGE1_l0002^omGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00
oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00
oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00
oooEeMGaomGEe@001?oEeMD6o`0000?oeMGE0ol00004omGEe@Go00001OoEeMD00ol0003oeMGEomGE
e@23omGEe@Go0000LooEeMD5o`000<ooeMGE0004omGEe@03o`000?oEeMGoeMGE00;oeMGE00Co0000
omGEeOoEeMGo00000ooEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE08_oeMGE00?o
0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@1`omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o
0000omGEeOoEeMD0c?oEeMD000GoeMGE00?o0000omGEeOoEeMD01?oEeMD01Ol0003oeMGEomGEeOoE
eMGo000000GoeMGE00?o0000omGEeOoEeMD0T?oEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oE
eMGoeMGE0<coeMGE0006omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00
0005omGEe@03o`000?oEeMGoeMGE08coeMGE1?l0001domGEe@Co0000cooEeMD000OoeMGE00?o0000
omGEeOoEeMD00_oEeMD01Ol0003oeMGEomGEeOoEeMGo000000GoeMGE00?o0000omGEeOoEeMD0RooE
eMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE0=7oeMGE0008omGEe@05o`000?oEeMGo
eMGEomGEeOl000000ooEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE08_oeMGE00?o
0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@1`omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o
0000omGEeOoEeMD0c?oEeMD000WoeMGE00Co0000omGEeOoEeMGo00000ooEeMD01ol0003oeMGEomGE
eOoEeMGo0000omGEeOl00000S_oEeMD5o`0007?oeMGE1Ol0003>omGEe@001?oEeMD00ol0003oeMGE
omGEe@02omGEe@04o`000?oEeMGoeMGEo`0000?oeMGE00?o0000omGEeOoEeMD00_oEeMD2o`000?oo
eMGEf_oEeMD000GoeMGE1?l00004omGEe@?o00001_oEeMD00ol0003oeMGEomGEe@3oomGEeMSoeMGE
003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE
001komGEeEoo00006OoEeMEOo`0009koeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7o
eMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003EomGEe@?o0000MOoEeMD3o`000:3oeMGE003HomGE
e@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0WOoEeMD00=WoeMGE00?o0000omGEeOoE
eMD0MOoEeMD00ol0003oeMGEomGEe@2LomGEe@00OOoEeMD4o`0000GoeMGE00?o0000omGEeOoEeMD0
1?oEeMD3o`0000GoeMGE1?l00004omGEe@Co00002ooEeMD5o`0000CoeMGE0ol0000MomGEe@?o0000
00?oeMGEo`000?oEeMD06OoEeMD5o`0000GoeMGE00?o0000omGEeOoEeMD01OoEeMD2o`0000CoeMGE
1Ol00003omGEe@Ko00002_oEeMD5o`0000CoeMGE0ol0000MomGEe@?o000000?oeMGEo`000?oEeMD0
WOoEeMD007coeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@08omGEe@05o`000?oE
eMGoeMGEomGEeOl000000ooEeMD00ol0003oeMGEomGEe@02omGEe@04o`000?oEeMGoeMGEo`0000Co
eMGE00?o0000omGEeOoEeMD02_oEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGE
eOl000006ooEeMD01?l0003oeMGEomGEeOoEeMD2o`0001coeMGE00?o0000omGEeOoEeMD03ooEeMD0
0ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD00_oEeMD0
0ol0003oeMGEomGEe@0:omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00
000KomGEe@04o`000?oEeMGoeMGEomGEe@;o0000W_oEeMD0087oeMGE00?o0000omGEeOoEeMD02?oE
eMD01Ol0003oeMGEomGEeOoEeMGo000000SoeMGE00?o0000omGEeOoEeMD01OoEeMD00ol0003oeMGE
omGEe@0:omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03
o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD06_oEeMD00ol0003oeMGEomGEe@0@omGEe@03
o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD01?oEeMD00ol0003oeMGEomGEe@0>omGEe@03
o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03o`000?oEeMGoeMGE
00?oeMGE00?o0000omGEeOoEeMD0W?oEeMD0087oeMGE00?o0000omGEeOoEeMD02?oEeMD01Ol0003o
eMGEomGEeOoEeMGo000000SoeMGE00?o0000omGEeOoEeMD01OoEeMD00ol0003oeMGEomGEe@0:omGE
e@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03o`000?oEeMGo
eMGE00?oeMGE00?o0000omGEeOoEeMD06_oEeMD00ol0003oeMGEomGEe@0=omGEe@;o000000?oeMGE
o`000?oEeMD00ooEeMD00ol0003oeMGEomGEe@05omGEe@03o`000?oEeMGoeMGE00goeMGE00?o0000
omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001[oeMGE00?o0000omGEeOoEeMD00ooE
eMD00ol0003oeMGEomGEe@2LomGEe@00O_oEeMD3o`0000_oeMGE00Go0000omGEeOoEeMGoeMGEo`00
0005omGEe@?o00001OoEeMD3o`0000goeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGE
eOoEeMGo000001[oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@0JomGEe@03o`00
0?oEeMGoeMGE00coeMGE00?o0000omGEeOoEeMD00_l00004omGEe@03o`000?oEeMGoeMGE00KoeMGE
00?o0000omGEeOoEeMD03?oEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl0
00006_oEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE09coeMGE0021omGEe@03o`00
0?oEeMGoeMGE00SoeMGE00Go0000omGEeOoEeMGoeMGEo`000008omGEe@03o`000?oEeMGoeMGE00Go
eMGE00?o0000omGEeOoEeMD02_oEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGE
eOl000006ooEeMD01?l0003oeMGEomGEeOoEeMD2o`0001coeMGE00?o0000omGEeOoEeMD02ooEeMD0
0ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD01ooEeMD0
0ol0003oeMGEomGEe@0;omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00
000KomGEe@04o`000?oEeMGoeMGEomGEe@;o0000W_oEeMD0087oeMGE00?o0000omGEeOoEeMD02?oE
eMD01Ol0003oeMGEomGEeOoEeMGo000000SoeMGE00?o0000omGEeOoEeMD01OoEeMD00ol0003oeMGE
omGEe@08omGEe@03o`000?oEeMGo000000GoeMGE00Go0000omGEeOoEeMGoeMGEo`00000LomGEe@?o
000000?oeMGEo`000?oEeMD06OoEeMD00ol0003oeMGEo`00000=omGEe@03o`000?oEeMGoeMGE00;o
eMGE00Ko0000omGEeOoEeMGo0000omGEeOl0000:omGEe@03o`000?oEeMGoeMGE00SoeMGE00?o0000
omGEeOl000001OoEeMD01Ol0003oeMGEomGEeOoEeMGo000001coeMGE0ol000000ooEeMGo0000omGE
e@2MomGEe@00O?oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE00SoeMGE00Go0000
omGEeOoEeMGoeMGEo`000003omGEe@03o`000?oEeMGoeMGE00;oeMGE00Co0000omGEeOoEeMGo0000
1?oEeMD00ol0003oeMGEomGEe@09omGEe@;o00001OoEeMD01Ol0003oeMGEomGEeOoEeMGo000003co
eMGE0_l0000>omGEe@04o`000?oEeMGoeMGEo`0000CoeMGE0_l00005omGEe@03o`000?oEeMGoeMGE
00;oeMGE00?o0000omGEeOoEeMD02OoEeMD2o`0000GoeMGE00Go0000omGEeOoEeMGoeMGEo`00002o
omGEe@00OOoEeMD4o`0000coeMGE0ol00005omGEe@Co00001?oEeMD4o`0000goeMGE00?o0000omGE
eOoEeMD01?oEeMD3o`0003koeMGE00?o0000omGEeOoEeMD03OoEeMD2o`0000KoeMGE00?o0000omGE
eOoEeMD01?oEeMD4o`0000goeMGE00?o0000omGEeOoEeMD01?oEeMD3o`000<3oeMGE003oomGEeO7o
eMGE0036omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0[ooEeMD00<KoeMGE00?o
0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2_omGEe@00aooEeMD00ol0003oeMGEomGEe@1e
omGEe@03o`000?oEeMGoeMGE0:koeMGE002komGEe@Oo00001OoEeMD00ol0003oeMGEomGEe@1YomGE
e@Oo00001OoEeMD00ol0003oeMGEomGEe@2^omGEe@00b?oEeMD00ol0003oeMGEomGEe@1eomGEe@03
o`000?oEeMGoeMGE0:goeMGE0038omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0
[OoEeMD00<WoeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2/omGEe@00a?oEeMD0
0ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE073oeMGE00?o0000omGEeOoEeMD00_oEeMD0
0ol0003oeMGEomGEe@2/omGEe@00a?oEeMD6o`0007;oeMGE1_l0002^omGEe@00oooEeMGaomGEe@00
oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00
oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00
oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@001?oEeMD5o`0000GoeMGE0_l00005omGE
e@Co00001OoEeMD00ol0003oeMGEomGEe@23omGEe@Go0000LooEeMD5o`000<ooeMGE0006omGEe@03
o`000?oEeMGoeMGE00CoeMGE00Co0000omGEeOoEeMGo00000ooEeMD00ol0003oeMGEomGEe@02omGE
e@03o`000?oEeMGoeMGE08SoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@1`omGE
e@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0c?oEeMD000KoeMGE00?o0000omGEeOoE
eMD00ooEeMD00ol0003oeMGEomGEe@02omGEe@04o`000?oEeMGoeMGEo`0000CoeMGE00?o0000omGE
eOoEeMD0SOoEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE0<coeMGE0006omGEe@03
o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD00_oEeMD01?l0003oeMGEomGEeOl00004omGE
e@03o`000?oEeMGoeMGE08WoeMGE1?l0001domGEe@Co0000cooEeMD000KoeMGE00?o0000omGEeOoE
eMD00ooEeMD2o`0000;oeMGE00?o0000omGEeOoEeMD00_oEeMD4o`0008_oeMGE00?o0000omGEeOoE
eMD0MOoEeMD00ol0003oeMGEomGEe@3AomGEe@001_oEeMD00ol0003oeMGEomGEe@03omGEe@04o`00
0?oEeMGo0000o`0000CoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@28omGEe@03
o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0L?oEeMD00ol0003oeMGEomGEe@02omGEe@03
o`000?oEeMGoeMGE0<coeMGE0004omGEe@03o`000?oEeMGo000000GoeMGE00?o0000omGEeOoEeMD0
1OoEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE08WoeMGE1Ol0001comGEe@Go0000
c_oEeMD000GoeMGE0_l00006omGEe@03o`000?oEeMGoeMGE00CoeMGE00?o0000omGEeOoEeMD00_oE
eMD00ol0003oeMGEomGEe@3oomGEeMGoeMGE0006omGEe@03o`000?oEeMGoeMGE00GoeMGE0_l00005
omGEe@Co0000oooEeMGHomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooE
eMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00NooEeMEOo`0001WoeMGEGol0002NomGEe@00
oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00eOoEeMD3o`0007GoeMGE0ol0002PomGE
e@00f?oEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE09goeMGE003IomGEe@03o`00
0?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0W?oEeMD007coeMGE1_l00004omGEe@03o`000?oE
eMGoeMGE00CoeMGE1?l00004omGEe@?o00001OoEeMD4o`0000_oeMGE1Ol00004omGEe@?o00007OoE
eMD3o`000003omGEeOl0003oeMGE01WoeMGE1Ol00005omGEe@03o`000?oEeMGoeMGE00CoeMGE1?l0
0004omGEe@?o00001?oEeMD5o`0000_oeMGE1Ol00004omGEe@?o00007OoEeMD3o`000003omGEeOl0
003oeMGE09goeMGE001lomGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD02?oEeMD0
0ol0003oeMGEomGEe@02omGEe@04o`000?oEeMGoeMGEo`0000?oeMGE00Go0000omGEeOoEeMGoeMGE
o`000004omGEe@03o`000?oEeMGoeMGE00[oeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGE
omGEeOoEeMGo000001_oeMGE00Co0000omGEeOoEeMGoeMGE0_l0000LomGEe@03o`000?oEeMGoeMGE
00_oeMGE00?o0000omGEeOoEeMD00_oEeMD01?l0003oeMGEomGEeOl00003omGEe@03o`000?oEeMGo
eMGE00?oeMGE00?o0000omGEeOoEeMD03OoEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGo
eMGEomGEeOl000006ooEeMD01?l0003oeMGEomGEeOoEeMD2o`0009koeMGE001momGEe@03o`000?oE
eMGoeMGE00coeMGE00?o0000omGEeOoEeMD00_oEeMD01?l0003oeMGEomGEeOl00003omGEe@03o`00
0?oEeMGoeMGE00KoeMGE00?o0000omGEeOoEeMD02_oEeMD00ol0003oeMGEomGEe@03omGEe@05o`00
0?oEeMGoeMGEomGEeOl000006_oEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE01[o
eMGE00?o0000omGEeOoEeMD02ooEeMD00ol0003oeMGEomGEe@02omGEe@04o`000?oEeMGoeMGEo`00
00?oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@0=omGEe@03o`000?oEeMGoeMGE
00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000
omGEeOoEeMD0W?oEeMD007koeMGE00?o0000omGEeOoEeMD02ooEeMD00ol0003oeMGEomGEe@02omGE
e@04o`000?oEeMGoeMGEo`0000?oeMGE00?o0000omGEeOoEeMD01_oEeMD00ol0003oeMGEomGEe@0:
omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03o`000?oE
eMGoeMGE00?oeMGE00?o0000omGEeOoEeMD06_oEeMD00ol0003oeMGEomGEe@0;omGEe@03o`000?oE
eMGoeMGE00;oeMGE00Co0000omGEeOoEeMGo00000ooEeMD00ol0003oeMGEomGEe@03omGEe@03o`00
0?oEeMGoeMGE00goeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001[o
eMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@2LomGEe@00OooEeMD00ol0003oeMGE
omGEe@0;omGEe@Co00000ooEeMD01Ol0003oeMGEomGEeOoEeMGo000000GoeMGE0ol0000=omGEe@03
o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03o`000?oEeMGoeMGE
00?oeMGE00?o0000omGEeOoEeMD06_oEeMD00ol0003oeMGEomGEe@0<omGEe@Co00000ooEeMD01Ol0
003oeMGEomGEeOoEeMGo000000GoeMGE00?o0000omGEeOoEeMD03OoEeMD00ol0003oeMGEomGEe@03
omGEe@05o`000?oEeMGoeMGEomGEeOl000006_oEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oE
eMGoeMGE09coeMGE0020omGEe@03o`000?oEeMGoeMGE00WoeMGE00?o0000omGEeOoEeMD00_oEeMD0
1?l0003oeMGEomGEeOl00003omGEe@03o`000?oEeMGoeMGE00KoeMGE00?o0000omGEeOoEeMD02_oE
eMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006ooEeMD01?l0003oeMGE
omGEeOoEeMD2o`0001coeMGE00?o0000omGEeOoEeMD02ooEeMD00ol0003oeMGEomGEe@02omGEe@04
o`000?oEeMGoeMGEo`0000?oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@0=omGE
e@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000KomGEe@04o`000?oEeMGo
eMGEomGEe@;o0000W_oEeMD0087oeMGE00?o0000omGEeOoEeMD02?oEeMD00ol0003oeMGEomGEe@02
omGEe@04o`000?oEeMGoeMGEo`0000?oeMGE00?o0000omGEeOoEeMD01_oEeMD00ol0003oeMGEomGE
e@08omGEe@03o`000?oEeMGo000000GoeMGE00Go0000omGEeOoEeMGoeMGEo`00000LomGEe@?o0000
00?oeMGEo`000?oEeMD06OoEeMD00ol0003oeMGEo`00000=omGEe@03o`000?oEeMGoeMGE00;oeMGE
00Co0000omGEeOoEeMGo00000ooEeMD01ol0003oeMGEomGEeOoEeMGo0000omGEeOl000003OoEeMD0
0ol0003oeMGEo`000005omGEe@05o`000?oEeMGoeMGEomGEeOl000007?oEeMD3o`000003omGEeOl0
003oeMGE09goeMGE001lomGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD02?oEeMD0
0ol0003oeMGEomGEe@02omGEe@04o`000?oEeMGoeMGEo`0000?oeMGE00Go0000omGEeOoEeMGoeMGE
o`000004omGEe@03o`000?oEeMGoeMGE00WoeMGE0_l00005omGEe@05o`000?oEeMGoeMGEomGEeOl0
0000??oEeMD2o`0000goeMGE00?o0000omGEeOoEeMD00_oEeMD01?l0003oeMGEomGEeOl00003omGE
e@03o`000?oEeMGoeMGE00;oeMGE0_l0000>omGEe@;o00001OoEeMD01Ol0003oeMGEomGEeOoEeMGo
00000;ooeMGE001momGEe@Co00003?oEeMD4o`0000CoeMGE0ol00005omGEe@Co00003OoEeMD00ol0
003oeMGEomGEe@04omGEe@?o0000?_oEeMD00ol0003oeMGEomGEe@0<omGEe@Co00001?oEeMD3o`00
00KoeMGE00?o0000omGEeOoEeMD03OoEeMD00ol0003oeMGEomGEe@04omGEe@?o0000`?oEeMD00?oo
eMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00<KoeMGE00?o0000omGEeOoEeMD0MOoEeMD0
0ol0003oeMGEomGEe@2_omGEe@00a_oEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE
0:ooeMGE0037omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0[_oEeMD00;_oeMGE
1ol00005omGEe@03o`000?oEeMGoeMGE06WoeMGE1ol00005omGEe@03o`000?oEeMGoeMGE0:koeMGE
0038omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0[OoEeMD00<SoeMGE00?o0000
omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2]omGEe@00bOoEeMD00ol0003oeMGEomGEe@1eomGE
e@03o`000?oEeMGoeMGE0:coeMGE0034omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoE
eMD0L?oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE0:coeMGE0034omGEe@Ko0000
L_oEeMD6o`000:koeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7o
eMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7o
eMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7o
eMGE0004omGEe@Go00001?oEeMD4o`0000GoeMGE1?l00004omGEe@03o`000?oEeMGoeMGE08?oeMGE
1Ol0001comGEe@Go0000cooEeMD000KoeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGE
e@02omGEe@03o`000?oEeMGoeMGE00CoeMGE00?o0000omGEeOoEeMD0ROoEeMD00ol0003oeMGEomGE
e@02omGEe@03o`000?oEeMGoeMGE073oeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGE
e@3<omGEe@001_oEeMD00ol0003oeMGEomGEe@08omGEe@03o`000?oEeMGoeMGE00CoeMGE00?o0000
omGEeOoEeMD0S_oEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE0<coeMGE0006omGE
e@03o`000?oEeMGoeMGE00SoeMGE00?o0000omGEeOoEeMD01_l0002;omGEe@Co0000M?oEeMD4o`00
0<ooeMGE0006omGEe@03o`000?oEeMGoeMGE00GoeMGE0ol00003omGEe@05o`000?oEeMGoeMGEomGE
eOl00000RooEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE0=7oeMGE0006omGEe@03
o`000?oEeMGoeMGE00SoeMGE00Go0000omGEeOoEeMGoeMGEo`000002omGEe@03o`000?oEeMGoeMGE
08WoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@1`omGEe@03o`000?oEeMGoeMGE
00;oeMGE00?o0000omGEeOoEeMD0c?oEeMD000CoeMGE00?o0000omGEeOl000002_oEeMD00ol0003o
eMGEomGEe@02omGEe@03o`000?oEeMGo000008coeMGE1Ol0001comGEe@Go0000c_oEeMD000GoeMGE
0_l00005omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD00ooEeMD2o`000?ooeMGE
f?oEeMD000KoeMGE00?o0000omGEeOoEeMD01?oEeMD4o`0000OoeMGE00?o0000omGEeOoEeMD0oooE
eMGFomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00NooE
eMEOo`0001WoeMGEGol0002NomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00
oooEeMGaomGEe@00oooEeMGaomGEe@00eOoEeMD3o`0007GoeMGE0ol0002PomGEe@00f?oEeMD00ol0
003oeMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE09goeMGE003IomGEe@03o`000?oEeMGoeMGE07Go
eMGE00?o0000omGEeOoEeMD0W?oEeMD007coeMGE1_l00004omGEe@03o`000?oEeMGoeMGE00CoeMGE
0ol00006omGEe@;o00001?oEeMD6o`0000[oeMGE1Ol00004omGEe@?o00007OoEeMD3o`000003omGE
eOl0003oeMGE01WoeMGE1Ol00005omGEe@03o`000?oEeMGoeMGE00GoeMGE0_l00006omGEe@;o0000
1?oEeMD6o`0000[oeMGE1Ol00004omGEe@?o00007OoEeMD3o`000003omGEeOl0003oeMGE09goeMGE
001lomGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD02?oEeMD01Ol0003oeMGEomGE
eOoEeMGo000000CoeMGE00Co0000omGEeOoEeMGo00000ooEeMD00ol0003oeMGEomGEe@02omGEe@03
o`000?oEeMGoeMGE00[oeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo0000
01_oeMGE00Co0000omGEeOoEeMGoeMGE0_l0000LomGEe@03o`000?oEeMGoeMGE00coeMGE00Co0000
omGEeOoEeMGo00001ooEeMD01Ol0003oeMGEomGEeOoEeMGo000000CoeMGE00?o0000omGEeOoEeMD0
2_oEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006ooEeMD01?l0003o
eMGEomGEeOoEeMD2o`0009koeMGE001momGEe@03o`000?oEeMGoeMGE017oeMGE00Co0000omGEeOoE
eMGo00001?oEeMD01Ol0003oeMGEomGEeOoEeMGo0000013oeMGE00?o0000omGEeOoEeMD00ooEeMD0
1Ol0003oeMGEomGEeOoEeMGo000001[oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGE
e@0JomGEe@03o`000?oEeMGoeMGE00_oeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGE
e@05omGEe@05o`000?oEeMGoeMGEomGEeOl000004?oEeMD00ol0003oeMGEomGEe@03omGEe@05o`00
0?oEeMGoeMGEomGEeOl000006_oEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE09co
eMGE001nomGEe@03o`000?oEeMGoeMGE013oeMGE00Co0000omGEeOoEeMGo00001?oEeMD00ol0003o
eMGEomGEe@02omGEe@03o`000?oEeMGoeMGE00goeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003o
eMGEomGEeOoEeMGo000001[oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@0JomGE
e@03o`000?oEeMGoeMGE00_oeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@02omGE
e@;o000000?oeMGEo`000?oEeMD00ooEeMD00ol0003oeMGEomGEe@0=omGEe@03o`000?oEeMGoeMGE
00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000
omGEeOoEeMD0W?oEeMD007ooeMGE00?o0000omGEeOoEeMD03_oEeMD01?l0003oeMGEomGEeOoEeMD2
o`0000;oeMGE00?o0000omGEeOoEeMD01?oEeMD00ol0003oeMGEomGEe@0<omGEe@03o`000?oEeMGo
eMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03o`000?oEeMGoeMGE00?oeMGE00?o
0000omGEeOoEeMD06_oEeMD00ol0003oeMGEomGEe@0;omGEe@;o00000_oEeMD00ol0003oeMGEomGE
e@02omGEe@03o`000?oEeMGoeMGE00;o00001OoEeMD00ol0003oeMGEomGEe@0<omGEe@03o`000?oE
eMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03o`000?oEeMGoeMGE00?oeMGE
00?o0000omGEeOoEeMD0W?oEeMD0083oeMGE00?o0000omGEeOoEeMD02OoEeMD4o`0000CoeMGE00Co
0000omGEeOl0003o00002?oEeMD00ol0003oeMGEomGEe@0;omGEe@03o`000?oEeMGoeMGE00?oeMGE
00Go0000omGEeOoEeMGoeMGEo`00000KomGEe@04o`000?oEeMGoeMGEomGEe@;o00007?oEeMD00ol0
003oeMGEomGEe@0;omGEe@04o`000?oEeMGo0000o`0000CoeMGE00?o0000omGEeOoEeMD00_oEeMD0
0ol0003oeMGEomGEe@04omGEe@03o`000?oEeMGoeMGE00_oeMGE00?o0000omGEeOoEeMD00ooEeMD0
1Ol0003oeMGEomGEeOoEeMGo000001_oeMGE00Co0000omGEeOoEeMGoeMGE0_l0002NomGEe@00POoE
eMD00ol0003oeMGEomGEe@08omGEe@03o`000?oEeMGoeMGE00GoeMGE00?o0000omGEeOoEeMD02_oE
eMD00ol0003oeMGEomGEe@08omGEe@03o`000?oEeMGo000000GoeMGE00Go0000omGEeOoEeMGoeMGE
o`00000LomGEe@?o000000?oeMGEo`000?oEeMD06OoEeMD00ol0003oeMGEo`00000=omGEe@03o`00
0?oEeMGoeMGE00GoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@05omGEe@03o`00
0?oEeMGoeMGE00SoeMGE00?o0000omGEeOl000001OoEeMD01Ol0003oeMGEomGEeOoEeMGo000001co
eMGE0ol000000ooEeMGo0000omGEe@2MomGEe@00O?oEeMD00ol0003oeMGEomGEe@02omGEe@03o`00
0?oEeMGoeMGE00SoeMGE00?o0000omGEeOoEeMD01_oEeMD00ol0003oeMGEomGEe@04omGEe@03o`00
0?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD02OoEeMD2o`0000GoeMGE00Go0000omGEeOoEeMGo
eMGEo`00000lomGEe@;o00003_oEeMD00ol0003oeMGEomGEe@05omGEe@04o`000?oEeMGoeMGEo`00
00?oeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@09omGEe@;o00001OoEeMD01Ol0
003oeMGEomGEeOoEeMGo00000;ooeMGE001momGEe@Co00002ooEeMD6o`0000CoeMGE0_l00005omGE
e@Co00003OoEeMD00ol0003oeMGEomGEe@04omGEe@?o0000?_oEeMD00ol0003oeMGEomGEe@0=omGE
e@;o00001_oEeMD2o`0000GoeMGE1?l0000=omGEe@03o`000?oEeMGoeMGE00CoeMGE0ol00030omGE
e@00oooEeMGaomGEe@00oooEeMGaomGEe@00a_oEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oE
eMGoeMGE0:ooeMGE0036omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0[ooEeMD0
0<OoeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2^omGEe@00^ooEeMD7o`0000Go
eMGE00?o0000omGEeOoEeMD0JOoEeMD7o`0000GoeMGE00?o0000omGEeOoEeMD0[_oEeMD00<SoeMGE
00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2]omGEe@00b?oEeMD00ol0003oeMGEomGE
e@1eomGEe@03o`000?oEeMGoeMGE0:goeMGE0039omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000
omGEeOoEeMD0[?oEeMD00<CoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@1`omGE
e@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0[?oEeMD00<CoeMGE1_l0001bomGEe@Ko
0000[_oEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?oo
eMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?oo
eMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD000CoeMGE1Ol00004omGE
e@?o00001?oEeMD5o`0000GoeMGE00?o0000omGEeOoEeMD0PooEeMD5o`0007?oeMGE1Ol0003?omGE
e@001_oEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000001OoEeMD00ol0
003oeMGEomGEe@2;omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0L?oEeMD00ol0
003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE0<coeMGE0006omGEe@03o`000?oEeMGoeMGE00?o
eMGE00Go0000omGEeOoEeMGoeMGEo`000005omGEe@03o`000?oEeMGoeMGE093oeMGE00?o0000omGE
eOoEeMD0MOoEeMD00ol0003oeMGEomGEe@3<omGEe@001_oEeMD00ol0003oeMGEomGEe@03omGEe@05
o`000?oEeMGoeMGEomGEeOl000001OoEeMD00ol0003oeMGEomGEe@2<omGEe@Co0000M?oEeMD4o`00
0<ooeMGE0006omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`000005omGE
e@03o`000?oEeMGoeMGE08_oeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@3AomGE
e@001_oEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000001OoEeMD00ol0
003oeMGEomGEe@2;omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0L?oEeMD00ol0
003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE0<coeMGE0004omGEe@03o`000?oEeMGo000000Go
eMGE00Go0000omGEeOoEeMGoeMGEo`000003omGEe@03o`000?oEeMGo000008koeMGE1Ol0001comGE
e@Go0000c_oEeMD000GoeMGE0_l00005omGEe@05o`000?oEeMGoeMGEomGEeOl000001?oEeMD2o`00
0?ooeMGEf_oEeMD000KoeMGE00?o0000omGEeOoEeMD01?oEeMD3o`0000KoeMGE00?o0000omGEeOoE
eMD0oooEeMGHomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGE
e@00oooEeMGaomGEe@00NooEeMEOo`0001WoeMGEEol0002VomGEe@00oooEeMGaomGEe@00oooEeMGa
omGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00eOoEeMD3o`0006goeMGE0ol0
002XomGEe@00f?oEeMD00ol0003oeMGEomGEe@1]omGEe@03o`000?oEeMGoeMGE0:GoeMGE003IomGE
e@03o`000?oEeMGoeMGE06goeMGE00?o0000omGEeOoEeMD0Y?oEeMD007coeMGE1_l00004omGEe@03
o`000?oEeMGoeMGE00CoeMGE1?l00004omGEe@?o00001OoEeMD3o`0000coeMGE1Ol00004omGEe@?o
00007OoEeMD3o`000003omGEeOl0003oeMGE01WoeMGE1Ol00005omGEe@03o`000?oEeMGoeMGE00Co
eMGE0ol00006omGEe@;o00003?oEeMD5o`0000CoeMGE0ol0000MomGEe@?o000000?oeMGEo`000?oE
eMD0YOoEeMD007coeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@08omGEe@03o`00
0?oEeMGoeMGE00;oeMGE00Co0000omGEeOoEeMGo00000ooEeMD01Ol0003oeMGEomGEeOoEeMGo0000
00?oeMGE00?o0000omGEeOoEeMD02ooEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGE
omGEeOl000006ooEeMD01?l0003oeMGEomGEeOoEeMD2o`0001coeMGE00?o0000omGEeOoEeMD02ooE
eMD01Ol0003oeMGEomGEeOoEeMGo000000OoeMGE00?o0000omGEeOoEeMD02ooEeMD00ol0003oeMGE
omGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006ooEeMD01?l0003oeMGEomGEeOoEeMD2o`00
0:KoeMGE001momGEe@03o`000?oEeMGoeMGE017oeMGE00Co0000omGEeOoEeMGo00000ooEeMD00ol0
003oeMGEomGEe@06omGEe@03o`000?oEeMGoeMGE00[oeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0
003oeMGEomGEeOoEeMGo000001[oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@0J
omGEe@03o`000?oEeMGoeMGE013oeMGE00?o0000omGEeOoEeMD01OoEeMD00ol0003oeMGEomGEe@0:
omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03o`000?oE
eMGoeMGE00?oeMGE00?o0000omGEeOoEeMD0Y?oEeMD007koeMGE00?o0000omGEeOoEeMD04?oEeMD0
1?l0003oeMGEomGEeOl00003omGEe@03o`000?oEeMGoeMGE00KoeMGE00?o0000omGEeOoEeMD02_oE
eMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006_oEeMD00ol0003oeMGE
omGEe@03omGEe@03o`000?oEeMGoeMGE01[oeMGE00?o0000omGEeOoEeMD04?oEeMD00ol0003oeMGE
omGEe@02omGEe@;o000000?oeMGEo`000?oEeMD02ooEeMD00ol0003oeMGEomGEe@03omGEe@05o`00
0?oEeMGoeMGEomGEeOl000006_oEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE0:Co
eMGE001oomGEe@03o`000?oEeMGoeMGE00coeMGE0ol00003omGEe@05o`000?oEeMGoeMGEomGEeOl0
00001ooEeMD00ol0003oeMGEomGEe@0;omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoE
eMGoeMGEo`00000JomGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD06_oEeMD00ol0
003oeMGEomGEe@0?omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD00_l0000<omGE
e@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03o`000?oEeMGo
eMGE00?oeMGE00?o0000omGEeOoEeMD0Y?oEeMD0083oeMGE00?o0000omGEeOoEeMD03_oEeMD01?l0
003oeMGEomGEeOl00003omGEe@04o`000?oEeMGoeMGEomGEe@Co00003_oEeMD00ol0003oeMGEomGE
e@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006ooEeMD01?l0003oeMGEomGEeOoEeMD2o`0001co
eMGE00?o0000omGEeOoEeMD02ooEeMD4o`0000CoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003o
eMGEomGEe@0:omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000KomGE
e@04o`000?oEeMGoeMGEomGEe@;o0000Y_oEeMD0087oeMGE00?o0000omGEeOoEeMD03OoEeMD01?l0
003oeMGEomGEeOl00003omGEe@05o`000?oEeMGoeMGEomGEeOl000003ooEeMD00ol0003oeMGEo`00
0005omGEe@05o`000?oEeMGoeMGEomGEeOl000007?oEeMD3o`000003omGEeOl0003oeMGE01WoeMGE
00?o0000omGEeOl000003OoEeMD00ol0003oeMGEomGEe@05omGEe@03o`000?oEeMGoeMGE00;oeMGE
00?o0000omGEeOoEeMD02?oEeMD00ol0003oeMGEo`000005omGEe@05o`000?oEeMGoeMGEomGEeOl0
00007?oEeMD3o`000003omGEeOl0003oeMGE0:GoeMGE001lomGEe@03o`000?oEeMGoeMGE00;oeMGE
00?o0000omGEeOoEeMD02?oEeMD00ol0003oeMGEomGEe@02omGEe@04o`000?oEeMGoeMGEo`0000?o
eMGE00Go0000omGEeOoEeMGoeMGEo`00000@omGEe@;o00001OoEeMD01Ol0003oeMGEomGEeOoEeMGo
000003coeMGE0_l0000=omGEe@03o`000?oEeMGoeMGE00KoeMGE00Co0000omGEeOoEeMGo00003?oE
eMD2o`0000GoeMGE00Go0000omGEeOoEeMGoeMGEo`000037omGEe@00OOoEeMD4o`0000coeMGE1?l0
0004omGEe@?o00001?oEeMD6o`0000coeMGE00?o0000omGEeOoEeMD01?oEeMD3o`0003koeMGE00?o
0000omGEeOoEeMD02ooEeMD6o`0000CoeMGE0_l0000>omGEe@03o`000?oEeMGoeMGE00CoeMGE0ol0
0038omGEe@00oooEeMGaomGEe@00a_oEeMD00ol0003oeMGEomGEe@1]omGEe@03o`000?oEeMGoeMGE
0;OoeMGE0036omGEe@03o`000?oEeMGoeMGE06goeMGE00?o0000omGEeOoEeMD0]ooEeMD00<OoeMGE
00?o0000omGEeOoEeMD0KOoEeMD00ol0003oeMGEomGEe@2fomGEe@00^ooEeMD7o`0000GoeMGE00?o
0000omGEeOoEeMD0HOoEeMD7o`0000GoeMGE00?o0000omGEeOoEeMD0]_oEeMD00<SoeMGE00?o0000
omGEeOoEeMD0KOoEeMD00ol0003oeMGEomGEe@2eomGEe@00b?oEeMD00ol0003oeMGEomGEe@1]omGE
e@03o`000?oEeMGoeMGE0;GoeMGE0039omGEe@03o`000?oEeMGoeMGE06goeMGE00?o0000omGEeOoE
eMD0]?oEeMD00<CoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@1XomGEe@03o`00
0?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0]?oEeMD00<CoeMGE1_l0001ZomGEe@Ko0000]_oE
eMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoE
eMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoE
eMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD000GoeMGE1?l0
0004omGEe@Co00001OoEeMD00ol0003oeMGEomGEe@04omGEe@Co0000PooEeMD5o`0007?oeMGE1Ol0
003?omGEe@001?oEeMD00ol0003oeMGEomGEe@02omGEe@04o`000?oEeMGoeMGEo`0000CoeMGE00?o
0000omGEeOoEeMD02?oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE083oeMGE00?o
0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@1`omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o
0000omGEeOoEeMD0c?oEeMD000CoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@05
omGEe@03o`000?oEeMGoeMGE00SoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@25
omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0c?oEeMD000CoeMGE00?o0000omGE
eOoEeMD00_oEeMD00ol0003oeMGEomGEe@05omGEe@03o`000?oEeMGoeMGE00SoeMGE00?o0000omGE
eOoEeMD00_oEeMD00ol0003oeMGEomGEe@21omGEe@Co0000M?oEeMD4o`000<ooeMGE0005omGEe@Co
00001OoEeMD3o`0000coeMGE1?l00023omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoE
eMD0dOoEeMD000CoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@05omGEe@03o`00
0?oEeMGoeMGE00SoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@20omGEe@03o`00
0?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0L?oEeMD00ol0003oeMGEomGEe@02omGEe@03o`00
0?oEeMGoeMGE0<coeMGE0004omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD01OoE
eMD00ol0003oeMGEomGEe@08omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0POoE
eMD5o`0007?oeMGE1Ol0003>omGEe@001?oEeMD00ol0003oeMGEomGEe@02omGEe@04o`000?oEeMGo
eMGEo`0000CoeMGE00?o0000omGEeOoEeMD02?oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oE
eMGoeMGE0?ooeMGEcOoEeMD000GoeMGE1?l00004omGEe@Co00003?oEeMD4o`000?ooeMGEd?oEeMD0
0?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD0
0?ooeMGElOoEeMD007_oeMGEGol0000IomGEeEoo0000W_oEeMD00?ooeMGElOoEeMD00?ooeMGElOoE
eMD00?ooeMGElOoEeMD00=GoeMGE0ol0001eomGEe@?o0000X?oEeMD00=SoeMGE00?o0000omGEeOoE
eMD0MOoEeMD00ol0003oeMGEomGEe@2MomGEe@00fOoEeMD00ol0003oeMGEomGEe@1eomGEe@03o`00
0?oEeMGoeMGE09coeMGE001lomGEe@Ko00001?oEeMD00ol0003oeMGEomGEe@03omGEe@Go00001OoE
eMD2o`0000KoeMGE0_l0000<omGEe@Go00001?oEeMD3o`0001goeMGE0ol000000ooEeMGo0000omGE
e@0IomGEe@Go00001OoEeMD00ol0003oeMGEomGEe@04omGEe@?o00001_oEeMD4o`0000CoeMGE1?l0
000:omGEe@Go00001?oEeMD3o`0001goeMGE0ol000000ooEeMGo0000omGEe@2MomGEe@00O?oEeMD0
0ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE00[oeMGE00?o0000omGEeOoEeMD01?oEeMD0
1?l0003oeMGEomGEeOl00007omGEe@03o`000?oEeMGoeMGE00_oeMGE00?o0000omGEeOoEeMD00ooE
eMD01Ol0003oeMGEomGEeOoEeMGo000001_oeMGE00Co0000omGEeOoEeMGoeMGE0_l0000LomGEe@03
o`000?oEeMGoeMGE00_oeMGE00Go0000omGEeOoEeMGoeMGEo`000007omGEe@03o`000?oEeMGoeMGE
00GoeMGE00?o0000omGEeOoEeMD02ooEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGE
omGEeOl000006ooEeMD01?l0003oeMGEomGEeOoEeMD2o`0009koeMGE001momGEe@03o`000?oEeMGo
eMGE00koeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGo
eMGE00GoeMGE00?o0000omGEeOoEeMD02_oEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGo
eMGEomGEeOl000006_oEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE01[oeMGE00?o
0000omGEeOoEeMD04?oEeMD00ol0003oeMGEomGEe@04omGEe@03o`000?oEeMGoeMGE00GoeMGE00?o
0000omGEeOoEeMD02ooEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl00000
6_oEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE09coeMGE001nomGEe@03o`000?oE
eMGoeMGE00goeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oE
eMGoeMGE00;oeMGE0_l000000ooEeMGo0000omGEe@0;omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go
0000omGEeOoEeMGoeMGEo`00000JomGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD0
6_oEeMD00ol0003oeMGEomGEe@0@omGEe@03o`000?oEeMGoeMGE00Ko00000_oEeMD6o`0000coeMGE
00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001[oeMGE00?o0000omGEeOoE
eMD00ooEeMD00ol0003oeMGEomGEe@2LomGEe@00OooEeMD00ol0003oeMGEomGEe@0<omGEe@03o`00
0?oEeMGoeMGE00?oeMGE0_l00002omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0
0_l0000<omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03
o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD06_oEeMD00ol0003oeMGEomGEe@0?omGEe@05
o`000?oEeMGoeMGEomGEeOl000000ooEeMD01Ol0003oeMGEomGEeOoEeMGo000000?oeMGE00?o0000
omGEeOoEeMD02ooEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006_oE
eMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE09coeMGE0020omGEe@03o`000?oEeMGo
eMGE00_oeMGE00?o0000omGEeOoEeMD00ooEeMD01?l0003oeMGEo`000?l00004omGEe@03o`000?oE
eMGoeMGE00;oeMGE00?o0000omGEeOoEeMD02_oEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oE
eMGoeMGEomGEeOl000006ooEeMD01?l0003oeMGEomGEeOoEeMD2o`0001coeMGE00?o0000omGEeOoE
eMD02ooEeMD4o`0000GoeMGE00Co0000omGEeOoEeMGo00001?oEeMD01?l0003oeMGEomGEeOl0000=
omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000KomGEe@04o`000?oE
eMGoeMGEomGEe@;o0000W_oEeMD0087oeMGE00?o0000omGEeOoEeMD02?oEeMD00ol0003oeMGEo`00
0005omGEe@03o`000?oEeMGoeMGE00GoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGE
e@08omGEe@03o`000?oEeMGo000000GoeMGE00Go0000omGEeOoEeMGoeMGEo`00000LomGEe@?o0000
00?oeMGEo`000?oEeMD06OoEeMD00ol0003oeMGEo`00000=omGEe@03o`000?oEeMGoeMGE00OoeMGE
00?o0000omGEeOl000001OoEeMD00ol0003oeMGEo`00000;omGEe@03o`000?oEeMGo000000GoeMGE
00Go0000omGEeOoEeMGoeMGEo`00000LomGEe@?o000000?oeMGEo`000?oEeMD0WOoEeMD007coeMGE
00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@09omGEe@;o00001_oEeMD00ol0003oeMGE
omGEe@05omGEe@04o`000?oEeMGoeMGEo`0000coeMGE0_l00005omGEe@05o`000?oEeMGoeMGEomGE
eOl00000??oEeMD2o`0000goeMGE00?o0000omGEeOoEeMD02?oEeMD2o`0000KoeMGE0_l0000<omGE
e@;o00001OoEeMD01Ol0003oeMGEomGEeOoEeMGo00000;ooeMGE001momGEe@Co00003OoEeMD00ol0
003oeMGEomGEe@05omGEe@;o00001_oEeMD2o`0000koeMGE00?o0000omGEeOoEeMD01?oEeMD3o`00
03koeMGE00?o0000omGEeOoEeMD02ooEeMD6o`0000KoeMGE00?o0000omGEeOoEeMD01OoEeMD00ol0
003oeMGEomGEe@0;omGEe@03o`000?oEeMGoeMGE00CoeMGE0ol00030omGEe@00oooEeMGaomGEe@00
oooEeMGaomGEe@00oooEeMGaomGEe@00a_oEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGo
eMGE0:ooeMGE0036omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0[ooEeMD00<Oo
eMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2^omGEe@00^ooEeMD7o`0000GoeMGE
00?o0000omGEeOoEeMD0JOoEeMD7o`0000GoeMGE00?o0000omGEeOoEeMD0[_oEeMD00<SoeMGE00?o
0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2]omGEe@00b?oEeMD00ol0003oeMGEomGEe@1e
omGEe@03o`000?oEeMGoeMGE0:goeMGE0039omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGE
eOoEeMD0[?oEeMD00<CoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@1`omGEe@03
o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0[?oEeMD00<CoeMGE1_l0001bomGEe@Ko0000
[_oEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGE
lOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGE
lOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD000KoeMGE
0_l00006omGEe@03o`000?oEeMGoeMGE00GoeMGE00?o0000omGEeOoEeMD00ooEeMD5o`0008?oeMGE
1Ol0001comGEe@Go0000cooEeMD000GoeMGE00Co0000omGEeOoEeMGo00001OoEeMD00ol0003oeMGE
omGEe@0=omGEe@03o`000?oEeMGoeMGE08?oeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGE
omGEe@1`omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0c?oEeMD000CoeMGE00?o
0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE00coeMGE00?o
0000omGEeOoEeMD0R?oEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE0<coeMGE0004
omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@0<
omGEe@03o`000?oEeMGoeMGE08CoeMGE1?l0001domGEe@Co0000cooEeMD000CoeMGE0_l00002omGE
e@03o`000?oEeMGoeMGE00GoeMGE00?o0000omGEeOoEeMD02ooEeMD00ol0003oeMGEomGEe@23omGE
e@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0dOoEeMD000CoeMGE00Co0000omGEeOl0
003o00002?oEeMD00ol0003oeMGEomGEe@0;omGEe@03o`000?oEeMGoeMGE08?oeMGE00?o0000omGE
eOoEeMD00_oEeMD00ol0003oeMGEomGEe@1`omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGE
eOoEeMD0c?oEeMD000CoeMGE00?o0000omGEeOoEeMD02_oEeMD00ol0003oeMGEomGEe@08omGEe@03
o`000?oEeMGo000008KoeMGE1Ol0001comGEe@Go0000c_oEeMD000GoeMGE00?o0000omGEeOoEeMD0
1?oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE00WoeMGE0_l0003oomGEeM;oeMGE
0006omGEe@;o00001?oEeMD6o`0000coeMGE00?o0000omGEeOoEeMD0oooEeMG@omGEe@00oooEeMGa
omGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00NooEeMEOo`0001WoeMGEGol0
002NomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooE
eMGaomGEe@00eOoEeMD3o`0007GoeMGE0ol0002PomGEe@00f?oEeMD00ol0003oeMGEomGEe@1eomGE
e@03o`000?oEeMGoeMGE09goeMGE003IomGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoE
eMD0W?oEeMD007coeMGE1_l00004omGEe@03o`000?oEeMGoeMGE00CoeMGE0ol00004omGEe@Ko0000
1?oEeMD2o`0000coeMGE1Ol00004omGEe@?o00007OoEeMD3o`000003omGEeOl0003oeMGE01WoeMGE
1Ol00005omGEe@03o`000?oEeMGoeMGE00CoeMGE0ol00005omGEe@?o00001?oEeMD6o`0000[oeMGE
1Ol00004omGEe@?o00007OoEeMD3o`000003omGEeOl0003oeMGE09goeMGE001lomGEe@03o`000?oE
eMGoeMGE00;oeMGE00?o0000omGEeOoEeMD02?oEeMD01Ol0003oeMGEomGEeOoEeMGo000000?oeMGE
00?o0000omGEeOoEeMD00_oEeMD01Ol0003oeMGEomGEeOoEeMGo000000;oeMGE00?o0000omGEeOoE
eMD02ooEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006ooEeMD01?l0
003oeMGEomGEeOoEeMD2o`0001coeMGE00?o0000omGEeOoEeMD02ooEeMD01Ol0003oeMGEomGEeOoE
eMGo000000?oeMGE00Go0000omGEeOoEeMGoeMGEo`000003omGEe@03o`000?oEeMGoeMGE00;oeMGE
00?o0000omGEeOoEeMD02_oEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl0
00006ooEeMD01?l0003oeMGEomGEeOoEeMD2o`0009koeMGE001momGEe@03o`000?oEeMGoeMGE00co
eMGE00Go0000omGEeOoEeMGoeMGEo`000004omGEe@03o`000?oEeMGoeMGE00CoeMGE00?o0000omGE
eOoEeMD00_oEeMD00ol0003oeMGEomGEe@0:omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGE
eOoEeMGoeMGEo`00000JomGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD06_oEeMD0
0ol0003oeMGEomGEe@0@omGEe@04o`000?oEeMGoeMGEo`0000?oeMGE00?o0000omGEeOoEeMD00_oE
eMD00ol0003oeMGEomGEe@0>omGEe@03o`000?oEeMGoeMGE00?oeMGE00Go0000omGEeOoEeMGoeMGE
o`00000JomGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGEeOoEeMD0W?oEeMD007koeMGE00?o
0000omGEeOoEeMD02ooEeMD01Ol0003oeMGEomGEeOoEeMGo000000GoeMGE00?o0000omGEeOoEeMD0
0ooEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE00[oeMGE00?o0000omGEeOoEeMD0
0ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001[oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003o
eMGEomGEe@0JomGEe@03o`000?oEeMGoeMGE013oeMGE00Co0000omGEeOoEeMGo00000ooEeMD00ol0
003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE00goeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0
003oeMGEomGEeOoEeMGo000001[oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@2L
omGEe@00OooEeMD00ol0003oeMGEomGEe@0:omGEe@05o`000?oEeMGoeMGEomGEeOl000001_oEeMD0
0ol0003oeMGEomGEe@02omGEe@;o00000_oEeMD00ol0003oeMGEomGEe@0;omGEe@03o`000?oEeMGo
eMGE00?oeMGE00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03o`000?oEeMGoeMGE00?oeMGE00?o
0000omGEeOoEeMD06_oEeMD00ol0003oeMGEomGEe@0?omGEe@05o`000?oEeMGoeMGEomGEeOl00000
0ooEeMD00ol0003oeMGEomGEe@04omGEe@03o`000?oEeMGoeMGE00coeMGE00?o0000omGEeOoEeMD0
0ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001[oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003o
eMGEomGEe@2LomGEe@00P?oEeMD00ol0003oeMGEomGEe@09omGEe@05o`000?oEeMGoeMGEomGEeOl0
00001ooEeMD01_l0003oeMGEomGEeOoEeMGo0000omGEe@;o00003_oEeMD00ol0003oeMGEomGEe@03
omGEe@05o`000?oEeMGoeMGEomGEeOl000006ooEeMD01?l0003oeMGEomGEeOoEeMD2o`0001coeMGE
00?o0000omGEeOoEeMD02ooEeMD4o`0000CoeMGE00Go0000omGEeOoEeMGoeMGEo`000007omGEe@03
o`000?oEeMGoeMGE00_oeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo0000
01_oeMGE00Co0000omGEeOoEeMGoeMGE0_l0002NomGEe@00POoEeMD00ol0003oeMGEomGEe@08omGE
e@05o`000?oEeMGoeMGEomGEeOl000002?oEeMD01?l0003oeMGEomGEeOl0000?omGEe@03o`000?oE
eMGo000000GoeMGE00Go0000omGEeOoEeMGoeMGEo`00000LomGEe@?o000000?oeMGEo`000?oEeMD0
6OoEeMD00ol0003oeMGEo`00000=omGEe@03o`000?oEeMGoeMGE00GoeMGE00Go0000omGEeOoEeMGo
eMGEo`000008omGEe@03o`000?oEeMGoeMGE00SoeMGE00?o0000omGEeOl000001OoEeMD01Ol0003o
eMGEomGEeOoEeMGo000001coeMGE0ol000000ooEeMGo0000omGEe@2MomGEe@00O?oEeMD00ol0003o
eMGEomGEe@02omGEe@03o`000?oEeMGoeMGE00SoeMGE00Go0000omGEeOoEeMGoeMGEo`000003omGE
e@03o`000?oEeMGoeMGE00;oeMGE00Go0000omGEeOoEeMGoeMGEo`00000?omGEe@;o00001OoEeMD0
1Ol0003oeMGEomGEeOoEeMGo000003coeMGE0_l0000=omGEe@03o`000?oEeMGoeMGE00GoeMGE00Go
0000omGEeOoEeMGoeMGEo`000003omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0
2OoEeMD2o`0000GoeMGE00Go0000omGEeOoEeMGoeMGEo`00002oomGEe@00OOoEeMD4o`0000coeMGE
0ol00005omGEe@Co00001OoEeMD2o`0000koeMGE00?o0000omGEeOoEeMD01?oEeMD3o`0003koeMGE
00?o0000omGEeOoEeMD02ooEeMD6o`0000?oeMGE0ol00005omGEe@Co00003OoEeMD00ol0003oeMGE
omGEe@04omGEe@?o0000`?oEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00<KoeMGE00?o0000omGE
eOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2_omGEe@00a_oEeMD00ol0003oeMGEomGEe@1eomGEe@03
o`000?oEeMGoeMGE0:ooeMGE0037omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0
[_oEeMD00;_oeMGE1ol00005omGEe@03o`000?oEeMGoeMGE06WoeMGE1ol00005omGEe@03o`000?oE
eMGoeMGE0:koeMGE0038omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0[OoEeMD0
0<SoeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2]omGEe@00bOoEeMD00ol0003o
eMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE0:coeMGE0034omGEe@03o`000?oEeMGoeMGE00;oeMGE
00?o0000omGEeOoEeMD0L?oEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE0:coeMGE
0034omGEe@Ko0000L_oEeMD6o`000:koeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7o
eMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7o
eMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7oeMGE003oomGEeO7o
eMGE0005omGEe@?o00001OoEeMD3o`0000KoeMGE00?o0000omGEeOoEeMD01?oEeMD4o`0008?oeMGE
1Ol0001comGEe@Go0000cooEeMD000CoeMGE00Go0000omGEeOoEeMGoeMGEo`000003omGEe@05o`00
0?oEeMGoeMGEomGEeOl000002ooEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE083o
eMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@1`omGEe@03o`000?oEeMGoeMGE00;o
eMGE00?o0000omGEeOoEeMD0c?oEeMD000WoeMGE00Co0000omGEeOoEeMGo00000ooEeMD00ol0003o
eMGEomGEe@0>omGEe@03o`000?oEeMGoeMGE08GoeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003o
eMGEomGEe@3<omGEe@002OoEeMD01?l0003oeMGEomGEeOl00003omGEe@03o`000?oEeMGoeMGE00ko
eMGE00?o0000omGEeOoEeMD0POoEeMD4o`0007CoeMGE1?l0003?omGEe@002?oEeMD01Ol0003oeMGE
omGEeOoEeMGo000000?oeMGE00?o0000omGEeOoEeMD02ooEeMD3o`0008?oeMGE00?o0000omGEeOoE
eMD0MOoEeMD00ol0003oeMGEomGEe@3AomGEe@001?oEeMD4o`0000CoeMGE00Go0000omGEeOoEeMGo
eMGEo`00000@omGEe@03o`000?oEeMGoeMGE083oeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003o
eMGEomGEe@1`omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGEeOoEeMD0c?oEeMD000CoeMGE
00?o0000omGEeOoEeMD01OoEeMD01Ol0003oeMGEomGEeOoEeMGo0000013oeMGE00?o0000omGEeOoE
eMD0POoEeMD5o`0007?oeMGE1Ol0003>omGEe@001?oEeMD00ol0003oeMGEomGEe@05omGEe@05o`00
0?oEeMGoeMGEomGEeOl000002ooEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oEeMGoeMGE0?oo
eMGEcOoEeMD000CoeMGE1_l00003omGEe@?o00003OoEeMD4o`000?ooeMGEd?oEeMD00?ooeMGElOoE
eMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoE
eMD007_oeMGEGol0000IomGEeEoo0000W_oEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGE
lOoEeMD00?ooeMGElOoEeMD00=GoeMGE0ol0001eomGEe@?o0000X?oEeMD00=SoeMGE00?o0000omGE
eOoEeMD0MOoEeMD00ol0003oeMGEomGEe@2MomGEe@00fOoEeMD00ol0003oeMGEomGEe@1eomGEe@03
o`000?oEeMGoeMGE09coeMGE001lomGEe@Go00001OoEeMD00ol0003oeMGEomGEe@04omGEe@Co0000
1OoEeMD00ol0003oeMGEomGEe@04omGEe@Co00002ooEeMD5o`0000CoeMGE0ol0000MomGEe@?o0000
00?oeMGEo`000?oEeMD06OoEeMD5o`0000GoeMGE00?o0000omGEeOoEeMD01OoEeMD4o`0000CoeMGE
0_l00006omGEe@;o00003?oEeMD5o`0000CoeMGE0ol0000MomGEe@?o000000?oeMGEo`000?oEeMD0
WOoEeMD007koeMGE00?o0000omGEeOoEeMD02ooEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oE
eMGoeMGE00;oeMGE00?o0000omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@02omGEe@03o`000?oE
eMGoeMGE00[oeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001_oeMGE
00Co0000omGEeOoEeMGoeMGE0_l0000LomGEe@03o`000?oEeMGoeMGE00ooeMGE00?o0000omGEeOoE
eMD00_oEeMD01?l0003oeMGEomGEeOl00007omGEe@03o`000?oEeMGoeMGE00_oeMGE00?o0000omGE
eOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001_oeMGE00Co0000omGEeOoEeMGoeMGE0_l0
002NomGEe@00O_oEeMD00ol0003oeMGEomGEe@0;omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000
omGEeOoEeMD00ooEeMD00ol0003oeMGEomGEe@07omGEe@03o`000?oEeMGoeMGE00[oeMGE00?o0000
omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001[oeMGE00?o0000omGEeOoEeMD00ooE
eMD00ol0003oeMGEomGEe@0JomGEe@03o`000?oEeMGoeMGE00ooeMGE00Go0000omGEeOoEeMGoeMGE
o`000004omGEe@03o`000?oEeMGoeMGE00GoeMGE00?o0000omGEeOoEeMD02_oEeMD00ol0003oeMGE
omGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006_oEeMD00ol0003oeMGEomGEe@03omGEe@03
o`000?oEeMGoeMGE09coeMGE001nomGEe@03o`000?oEeMGoeMGE00_oeMGE00?o0000omGEeOoEeMD0
0_oEeMD00ol0003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE00OoeMGE00?o0000omGEeOoEeMD0
2_oEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006_oEeMD00ol0003o
eMGEomGEe@03omGEe@03o`000?oEeMGoeMGE01[oeMGE00?o0000omGEeOoEeMD02ooEeMD6o`0000;o
eMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@02omGEe@;o000000?oeMGEo`000?oE
eMD02ooEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006_oEeMD00ol0
003oeMGEomGEe@03omGEe@03o`000?oEeMGoeMGE09coeMGE001nomGEe@03o`000?oEeMGoeMGE00co
eMGE1?l00007omGEe@03o`000?oEeMGoeMGE00?oeMGE0ol0000=omGEe@03o`000?oEeMGoeMGE00?o
eMGE00Go0000omGEeOoEeMGoeMGEo`00000JomGEe@03o`000?oEeMGoeMGE00?oeMGE00?o0000omGE
eOoEeMD06_oEeMD00ol0003oeMGEomGEe@0;omGEe@05o`000?oEeMGoeMGEomGEeOl000000ooEeMD2
o`0000;oeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@02o`0000coeMGE00?o0000
omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001[oeMGE00?o0000omGEeOoEeMD00ooE
eMD00ol0003oeMGEomGEe@2LomGEe@00O_oEeMD00ol0003oeMGEomGEe@0;omGEe@03o`000?oEeMGo
eMGE00;oeMGE00?o0000omGEeOoEeMD01?oEeMD00ol0003oeMGEomGEe@06omGEe@03o`000?oEeMGo
eMGE00[oeMGE00?o0000omGEeOoEeMD00ooEeMD01Ol0003oeMGEomGEeOoEeMGo000001_oeMGE00Co
0000omGEeOoEeMGoeMGE0_l0000LomGEe@03o`000?oEeMGoeMGE00coeMGE00Co0000omGEeOoEeMGo
00000ooEeMD01?l0003oeMGEo`000?l00004omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGE
eOoEeMD02_oEeMD00ol0003oeMGEomGEe@03omGEe@05o`000?oEeMGoeMGEomGEeOl000006ooEeMD0
1?l0003oeMGEomGEeOoEeMD2o`0009koeMGE001lomGEe@03o`000?oEeMGo000000goeMGE00?o0000
omGEeOoEeMD00_oEeMD00ol0003oeMGEomGEe@05omGEe@03o`000?oEeMGoeMGE00GoeMGE00?o0000
omGEeOoEeMD02?oEeMD00ol0003oeMGEo`000005omGEe@05o`000?oEeMGoeMGEomGEeOl000007?oE
eMD3o`000003omGEeOl0003oeMGE01WoeMGE00?o0000omGEeOl000003ooEeMD00ol0003oeMGEo`00
0003omGEe@03o`000?oEeMGoeMGE00GoeMGE00?o0000omGEeOoEeMD00_oEeMD00ol0003oeMGEomGE
e@08omGEe@03o`000?oEeMGo000000GoeMGE00Go0000omGEeOoEeMGoeMGEo`00000LomGEe@?o0000
00?oeMGEo`000?oEeMD0WOoEeMD007goeMGE0_l0000=omGEe@03o`000?oEeMGoeMGE00;oeMGE00Co
0000omGEeOoEeMGo00001?oEeMD01?l0003oeMGEomGEeOl00004omGEe@03o`000?oEeMGoeMGE00Wo
eMGE0_l00005omGEe@05o`000?oEeMGoeMGEomGEeOl00000??oEeMD2o`00013oeMGE0_l00004omGE
e@03o`000?oEeMGoeMGE00GoeMGE00Co0000omGEeOoEeMGo00003?oEeMD2o`0000GoeMGE00Go0000
omGEeOoEeMGoeMGEo`00002oomGEe@00O_oEeMD00ol0003oeMGEomGEe@0<omGEe@Co00000ooEeMD6
o`0000?oeMGE1?l0000=omGEe@03o`000?oEeMGoeMGE00CoeMGE0ol0000nomGEe@03o`000?oEeMGo
eMGE00ooeMGE00?o0000omGEeOoEeMD00ooEeMD2o`0000KoeMGE0_l0000>omGEe@03o`000?oEeMGo
eMGE00CoeMGE0ol00030omGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00oooEeMGaomGEe@00a_oE
eMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE0:ooeMGE0036omGEe@03o`000?oEeMGo
eMGE07GoeMGE00?o0000omGEeOoEeMD0[ooEeMD00<OoeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0
003oeMGEomGEe@2^omGEe@00^ooEeMD7o`0000GoeMGE00?o0000omGEeOoEeMD0JOoEeMD7o`0000Go
eMGE00?o0000omGEeOoEeMD0[_oEeMD00<SoeMGE00?o0000omGEeOoEeMD0MOoEeMD00ol0003oeMGE
omGEe@2]omGEe@00b?oEeMD00ol0003oeMGEomGEe@1eomGEe@03o`000?oEeMGoeMGE0:goeMGE0039
omGEe@03o`000?oEeMGoeMGE07GoeMGE00?o0000omGEeOoEeMD0[?oEeMD00<CoeMGE00?o0000omGE
eOoEeMD00_oEeMD00ol0003oeMGEomGEe@1`omGEe@03o`000?oEeMGoeMGE00;oeMGE00?o0000omGE
eOoEeMD0[?oEeMD00<CoeMGE1_l0001bomGEe@Ko0000[_oEeMD00?ooeMGElOoEeMD00?ooeMGElOoE
eMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoEeMD00?ooeMGElOoE
eMD00?ooeMGElOoEeMD00001\
\>"]],

Cell["\<\
For convenience, the relevant values are plotted below in the \
format close to that used in the article (the article's approach as solid \
lines versus the standard approach as dashes). The data points indicated as \
filled circles in Figure 2 were taken from previous results and are not \
shown.\
\>", "Text",
  CellFrame->True,
  ExpressionUUID -> "72afb9ed-e13f-4bb4-9229-714a393260eb",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[0.833326]],

Cell[CellGroupData[{

Cell["\<\
Show[
\tListPlot[Transpose[{xLollipop,10^7 yLollipop}]/.{g->1,s->1},
\t\tPlotJoined->True, AspectRatio->1, Axes->True, Frame->True,
\t\tDisplayFunction->Identity
\t],
\tListPlot[Transpose[{xLollipop,10^7 \
yLollipop2}]/.{g->1,s->1},PlotStyle->{Dashing[{0.03,0.02}]},
\t\tPlotJoined->True, AspectRatio->1, Axes->True, Frame->True,
\t\tDisplayFunction->Identity
\t],
\tListPlot[Transpose[{xDumbbell,10^7 yDumbbell}]/.{g->1,s->1},
\t\tPlotJoined->True, AspectRatio->1, Axes->True, Frame->True,
\t\tDisplayFunction->Identity
\t],
\tListPlot[Transpose[{xDumbbell,10^7 \
yDumbbell2}]/.{g->1,s->1},PlotStyle->{Dashing[{0.03,0.02}]},
\t\tPlotJoined->True, AspectRatio->1, Axes->True, Frame->True,
\t\tDisplayFunction->Identity
\t],
\tAxesLabel->{\"spacer length, bp\",\"friction coefficient x 10^7\"},
\tPlotRange->{{0,290},{0,3.5}}, AspectRatio->1, Axes->True, Frame->True,
\tDisplayFunction->$DisplayFunction
]\
\>", "Input",
  CellFrame->True,
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  ExpressionUUID -> "8b558c01-3599-4c45-9a66-fec2f41aa663",
  Background->GrayLevel[0.833326]],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 0.00344828 0 0.285714 [
[.17241 -0.0125 -6 -9 ]
[.17241 -0.0125 6 0 ]
[.34483 -0.0125 -9 -9 ]
[.34483 -0.0125 9 0 ]
[.51724 -0.0125 -9 -9 ]
[.51724 -0.0125 9 0 ]
[.68966 -0.0125 -9 -9 ]
[.68966 -0.0125 9 0 ]
[.86207 -0.0125 -9 -9 ]
[.86207 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .14286 -18 -4.5 ]
[-0.0125 .14286 0 4.5 ]
[-0.0125 .28571 -6 -4.5 ]
[-0.0125 .28571 0 4.5 ]
[-0.0125 .42857 -18 -4.5 ]
[-0.0125 .42857 0 4.5 ]
[-0.0125 .57143 -6 -4.5 ]
[-0.0125 .57143 0 4.5 ]
[-0.0125 .71429 -18 -4.5 ]
[-0.0125 .71429 0 4.5 ]
[-0.0125 .85714 -6 -4.5 ]
[-0.0125 .85714 0 4.5 ]
[-0.0125 1 -18 -4.5 ]
[-0.0125 1 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[1.025 0 0 -6 ]
[1.025 0 106 6 ]
[0 1.025 -83 0 ]
[0 1.025 83 12 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17241 0 m
.17241 .00625 L
s
[(50)] .17241 -0.0125 0 1 Mshowa
.34483 0 m
.34483 .00625 L
s
[(100)] .34483 -0.0125 0 1 Mshowa
.51724 0 m
.51724 .00625 L
s
[(150)] .51724 -0.0125 0 1 Mshowa
.68966 0 m
.68966 .00625 L
s
[(200)] .68966 -0.0125 0 1 Mshowa
.86207 0 m
.86207 .00625 L
s
[(250)] .86207 -0.0125 0 1 Mshowa
.125 Mabswid
.03448 0 m
.03448 .00375 L
s
.06897 0 m
.06897 .00375 L
s
.10345 0 m
.10345 .00375 L
s
.13793 0 m
.13793 .00375 L
s
.2069 0 m
.2069 .00375 L
s
.24138 0 m
.24138 .00375 L
s
.27586 0 m
.27586 .00375 L
s
.31034 0 m
.31034 .00375 L
s
.37931 0 m
.37931 .00375 L
s
.41379 0 m
.41379 .00375 L
s
.44828 0 m
.44828 .00375 L
s
.48276 0 m
.48276 .00375 L
s
.55172 0 m
.55172 .00375 L
s
.58621 0 m
.58621 .00375 L
s
.62069 0 m
.62069 .00375 L
s
.65517 0 m
.65517 .00375 L
s
.72414 0 m
.72414 .00375 L
s
.75862 0 m
.75862 .00375 L
s
.7931 0 m
.7931 .00375 L
s
.82759 0 m
.82759 .00375 L
s
.89655 0 m
.89655 .00375 L
s
.93103 0 m
.93103 .00375 L
s
.96552 0 m
.96552 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .14286 m
.00625 .14286 L
s
[(0.5)] -0.0125 .14286 1 0 Mshowa
0 .28571 m
.00625 .28571 L
s
[(1)] -0.0125 .28571 1 0 Mshowa
0 .42857 m
.00625 .42857 L
s
[(1.5)] -0.0125 .42857 1 0 Mshowa
0 .57143 m
.00625 .57143 L
s
[(2)] -0.0125 .57143 1 0 Mshowa
0 .71429 m
.00625 .71429 L
s
[(2.5)] -0.0125 .71429 1 0 Mshowa
0 .85714 m
.00625 .85714 L
s
[(3)] -0.0125 .85714 1 0 Mshowa
0 1 m
.00625 1 L
s
[(3.5)] -0.0125 1 1 0 Mshowa
.125 Mabswid
0 .02857 m
.00375 .02857 L
s
0 .05714 m
.00375 .05714 L
s
0 .08571 m
.00375 .08571 L
s
0 .11429 m
.00375 .11429 L
s
0 .17143 m
.00375 .17143 L
s
0 .2 m
.00375 .2 L
s
0 .22857 m
.00375 .22857 L
s
0 .25714 m
.00375 .25714 L
s
0 .31429 m
.00375 .31429 L
s
0 .34286 m
.00375 .34286 L
s
0 .37143 m
.00375 .37143 L
s
0 .4 m
.00375 .4 L
s
0 .45714 m
.00375 .45714 L
s
0 .48571 m
.00375 .48571 L
s
0 .51429 m
.00375 .51429 L
s
0 .54286 m
.00375 .54286 L
s
0 .6 m
.00375 .6 L
s
0 .62857 m
.00375 .62857 L
s
0 .65714 m
.00375 .65714 L
s
0 .68571 m
.00375 .68571 L
s
0 .74286 m
.00375 .74286 L
s
0 .77143 m
.00375 .77143 L
s
0 .8 m
.00375 .8 L
s
0 .82857 m
.00375 .82857 L
s
0 .88571 m
.00375 .88571 L
s
0 .91429 m
.00375 .91429 L
s
0 .94286 m
.00375 .94286 L
s
0 .97143 m
.00375 .97143 L
s
.25 Mabswid
0 0 m
0 1 L
s
0 .99375 m
0 1 L
s
.17241 .99375 m
.17241 1 L
s
.34483 .99375 m
.34483 1 L
s
.51724 .99375 m
.51724 1 L
s
.68966 .99375 m
.68966 1 L
s
.86207 .99375 m
.86207 1 L
s
.125 Mabswid
.03448 .99625 m
.03448 1 L
s
.06897 .99625 m
.06897 1 L
s
.10345 .99625 m
.10345 1 L
s
.13793 .99625 m
.13793 1 L
s
.2069 .99625 m
.2069 1 L
s
.24138 .99625 m
.24138 1 L
s
.27586 .99625 m
.27586 1 L
s
.31034 .99625 m
.31034 1 L
s
.37931 .99625 m
.37931 1 L
s
.41379 .99625 m
.41379 1 L
s
.44828 .99625 m
.44828 1 L
s
.48276 .99625 m
.48276 1 L
s
.55172 .99625 m
.55172 1 L
s
.58621 .99625 m
.58621 1 L
s
.62069 .99625 m
.62069 1 L
s
.65517 .99625 m
.65517 1 L
s
.72414 .99625 m
.72414 1 L
s
.75862 .99625 m
.75862 1 L
s
.7931 .99625 m
.7931 1 L
s
.82759 .99625 m
.82759 1 L
s
.89655 .99625 m
.89655 1 L
s
.93103 .99625 m
.93103 1 L
s
.96552 .99625 m
.96552 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 0 m
1 0 L
s
.99375 .14286 m
1 .14286 L
s
.99375 .28571 m
1 .28571 L
s
.99375 .42857 m
1 .42857 L
s
.99375 .57143 m
1 .57143 L
s
.99375 .71429 m
1 .71429 L
s
.99375 .85714 m
1 .85714 L
s
.125 Mabswid
.99625 .02857 m
1 .02857 L
s
.99625 .05714 m
1 .05714 L
s
.99625 .08571 m
1 .08571 L
s
.99625 .11429 m
1 .11429 L
s
.99625 .17143 m
1 .17143 L
s
.99625 .2 m
1 .2 L
s
.99625 .22857 m
1 .22857 L
s
.99625 .25714 m
1 .25714 L
s
.99625 .31429 m
1 .31429 L
s
.99625 .34286 m
1 .34286 L
s
.99625 .37143 m
1 .37143 L
s
.99625 .4 m
1 .4 L
s
.99625 .45714 m
1 .45714 L
s
.99625 .48571 m
1 .48571 L
s
.99625 .51429 m
1 .51429 L
s
.99625 .54286 m
1 .54286 L
s
.99625 .6 m
1 .6 L
s
.99625 .62857 m
1 .62857 L
s
.99625 .65714 m
1 .65714 L
s
.99625 .68571 m
1 .68571 L
s
.99625 .74286 m
1 .74286 L
s
.99625 .77143 m
1 .77143 L
s
.99625 .8 m
1 .8 L
s
.99625 .82857 m
1 .82857 L
s
.99625 .88571 m
1 .88571 L
s
.99625 .91429 m
1 .91429 L
s
.99625 .94286 m
1 .94286 L
s
.99625 .97143 m
1 .97143 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
s
gsave
1.025 0 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(spacer) show
105.000 13.000 moveto
(length) show
141.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
153.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(bp) show
165.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
0 1 L
s
gsave
0 1.025 -144 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(friction) show
117.000 13.000 moveto
(coefficient) show
189.000 13.000 moveto
(x) show
201.000 13.000 moveto
(10) show
213.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(^) show
219.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(7) show
225.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.17343 .39064 m
.23124 .42665 L
.28905 .46178 L
.34686 .49606 L
.46247 .56237 L
.57809 .62616 L
.69371 .68792 L
.80933 .74798 L
.92495 .80662 L
s
[ .03 .02 ] 0 setdash
.17343 .3037 m
.23124 .31605 L
.28905 .33083 L
.34686 .34694 L
.46247 .38108 L
.57809 .41627 L
.69371 .4517 L
.80933 .48705 L
.92495 .52216 L
s
[ ] 0 setdash
.17343 .53523 m
.23124 .57876 L
.28905 .61966 L
.34686 .65855 L
.46247 .73187 L
.57809 .80082 L
.69371 .86657 L
.80933 .92985 L
.92495 .99115 L
s
[ .03 .02 ] 0 setdash
.17343 .4196 m
.23124 .42928 L
.28905 .44112 L
.34686 .45438 L
.46247 .48346 L
.57809 .51444 L
.69371 .54636 L
.80933 .57874 L
.92495 .61131 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{394.625, 394.625},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40009?0002Cb000`400?l00000o`00003ooooooooo
oooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo
003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003ooooooooo
ooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool0
0?oooooooooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooo
oomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00
oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooo
oe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003o
ooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003ooooooooooooo
DOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oo
oooooooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomA
ooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooo
oooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7o
oooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003ooooo
ooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOoo
ool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooo
oooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAoooo
o`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooo
oooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo
003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003ooooooooo
ooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool0
0?oooooooooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooo
oomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00
oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooo
oe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003o
ooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003ooooooooooooo
DOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oo
oooooooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomA
ooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooo
oooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7o
oooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003ooooo
ooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOoo
ool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooo
oooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAoooo
o`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooo
oooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo
003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo002Xooooo`06
olc<c?lQ8B7o0000o`000?lb<S;ogMgM1Oooool01?mVIVKo0000oc8b<_o^k^hQooooo`03oa0@4?l0
003o000000;o000000?ogMgMooooooooool00_ooool01?mVIVKo0000oc8b<_o^k^h5ooooo`04ofIV
I_l0003o<S8bonk^kQgooooo00?o410@o`000?l000000_l000001OoMgMgoooooooooooo<c<co8B4Q
00;o000000?o<S8bomgMgOooool01?ooool01?mVIVKo0000oc8b<_o^k^hKooooo`03ohN7Qol0003o
000000;o000000?o410@ooooooooool00oooool01?mVIVKo0000oc8b<_o^k^h5ooooo`04ofIVI_l0
003o<S8bonk^kQcooooo00?oQhN7o`000?l000000_l000001_l@413oooooooooooooooooc<c<ob4Q
8@;o000000?o<S8bomgMgOooool01?ooool01?mVIVKo0000oc8b<_o^k^k5ooooo`00Z?ooool01_o<
c<coZJVYooooooooooooV9RHob4Q8@Cooooo0_n7QhL00oooooooQhN7odA4A00Sooooo`03o`000?oo
oooooooo00Cooooo0_n7QhL00oooooooQhN7odA4A004ooooo`;oQhN700?oooooohN7Qom4A4@07ooo
ool00ol0003oooooooooo`03ooooo`06olc<c?nYZJWooooooooooonHV9So8B4Q1?ooool2ohN7Q`03
oooooon7QhOoA4A401_ooooo00?ok^k^oc8b<_o<c<`01oooool2ohN7Q`03oooooon7QhOoA4A400Co
oooo0_n7QhL00oooooooQhN7odA4A00Looooo`03onk^k_lb<S;oc<c<00Kooooo00Koc<c<ojVYZOoo
oooooooooiRHV?lQ8B44ooooo`;oQhN700?oooooohN7Qom4A4@0aOooool00:gooooo00?o8B4QokZj
^_ooool00_ooool01Olb<S;ooooooooooooooooo000002?ooooo00?o0000ooooooooool01?ooool0
1Olb<S;ooooooooooooooooo000000Cooooo00Go<S8booooooooooooooooo`00000Oooooo`03o`00
0?oooooooooo00Sooooo00?o8B4QokZj^_ooool00_ooool01Olb<S;ooooooooooooooooo000001co
oooo00?ok^k^oc8b<_nYZJT01_ooool01Olb<S;ooooooooooooooooo000000Cooooo00Go<S8boooo
ooooooooooooo`00000Mooooo`03onk^k_lb<S;oZJVY00[ooooo00?o8B4QokZj^_ooool00_ooool0
1Olb<S;ooooooooooooooooo00000<Gooooo002]ooooo`03ob4Q8Onj^[[ooooo00;ooooo00Ko<S8b
oooooooooooooooooc8b<_nj^[XRooooo`03o`000?oooooooooo00Cooooo00Ko<S8boooooooooooo
oooooc8b<_nj^[X3ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj7_ooool00ol0003ooooooooo
o`08ooooo`03ob4Q8Onj^[[ooooo00;ooooo00Ko<S8boooooooooooooooooc8b<_nj^[XLooooo`03
onk^k_lQ8B7oV9RH00Gooooo00Ko<S8boooooooooooooooooc8b<_nj^[X3ooooo`06oc8b<_oooooo
oooooooooolb<S;o^[Zj7Oooool00oo^k^ko8B4QoiRHV009ooooo`03ob4Q8Onj^[[ooooo00;ooooo
00Ko<S8boooooooooooooooooc8b<_nj^[[4ooooo`00ZOooool01OmVIVKogMgMoooooon7QhOo410@
00Cooooo00Ko<S8boooooooooooooooooc8b<_nj^[XRooooo`03o`000?oooooooooo00Cooooo00Ko
<S8boooooooooooooooooc8b<_nj^[X3ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj7_ooool0
0ol0003oooooooooo`04ooooo`05ofIVI_oMgMgoooooohN7Qol@41001?ooool01_lb<S;ooooooooo
oooooooo<S8bokZj^Qgooooo00?ok^k^oc8b<_o<c<`01?ooool01_lb<S;ooooooooooooooooo<S8b
okZj^P?ooooo00Ko<S8boooooooooooooooooc8b<_nj^[XNooooo`03onk^k_lb<S;oc<c<00Cooooo
00GoIVIVomgMgOooooooQhN7oa0@4004ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zja?ooool0
0:Wooooo00Go0000ob4Q8Ol0003o410@olc<c004ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj
8_ooool00ol0003oooooooooo`04ooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj0oooool01_lb
<S;ooooooooooooooooo<S8bokZj^Qkooooo00?o0000ooooooooool01?ooool01Ol0003o8B4Qo`00
0?l@413oc<c<00Cooooo00Ko<S8boooooooooooooooooc8b<_nj^[XNooooo`03onk^k_m4A4Cooooo
00?ooooo00Ko<S8boooooooooooooooooc8b<_nj^[X3ooooo`06oc8b<_oooooooooooooooolb<S;o
^[Zj7oooool00oo^k^koA4A4ooooo`03ooooo`05o`000?lQ8B7o0000oa0@4?o<c<`01?ooool01_lb
<S;ooooooooooooooooo<S8bokZj^/Cooooo002Yooooo`03o`000?oooooooooo00Kooooo00Go<S8b
onk^k_ooooook^k^o`00000Sooooo`03o`000?oooooooooo00Cooooo00Go<S8bonk^k_ooooook^k^
o`000004ooooo`05oc8b<_o^k^koooooonk^k_l000007oooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo00Kooooo00Go<S8bonk^k_ooooook^k^o`00000Looooo`05okZj^_oooooooooo
oooooolb<S801?ooool01Olb<S;ok^k^ooooooo^k^ko000000Cooooo00Go<S8bonk^k_ooooook^k^
o`00000Mooooo`05okZj^_oooooooooooooooolb<S801?ooool00ol0003oooooooooo`06ooooo`05
oc8b<_o^k^koooooonk^k_l00000aOooool00:Wooooo00?o0000ooooooooool01_ooool01On7QhOo
IVIVoooooomVIVKoA4A4027ooooo00?oQhN7okZj^_l000001_ooool01On7QhOoIVIVoooooomVIVKo
A4A400Cooooo00GoQhN7ofIVI_ooooooIVIVodA4A00Mooooo`03ohN7Qonj^[[o000000Kooooo00?o
0000ooooooooool01_ooool01On7QhOoIVIVoooooomVIVKoA4A401_ooooo00Koc<c<o`000?n7QhOo
oooookZj^_lQ8B44ooooo`05ohN7QomVIVKoooooofIVI_m4A4@01?ooool01On7QhOoIVIVoooooomV
IVKoA4A401cooooo00Koc<c<o`000?n7QhOooooookZj^_lQ8B44ooooo`03o`000?oooooooooo00Ko
oooo00GoQhN7ofIVI_ooooooIVIVodA4A00booooo`?o000000?o<S8booooooooool0C?ooool01OmE
EEGo0000o`000?m4A4Cok^k^033ooooo0ol000000olb<S;oooooooooo`06ooooo`00ZOooool4o`00
0003oa0@4?oooooooooo00?ooooo00CoIVIVo`000?lb<S;ok^k^8Oooool00on7QhOo<S8bo`000007
ooooo`04ofIVI_l0003o<S8bonk^kPGooooo00CoIVIVo`000?lb<S;ok^k^7Oooool00on7QhOo<S8b
o`000006ooooo`Co000000?o410@ooooooooool00oooool01?mVIVKo0000oc8b<_o^k^hLooooo`05
ojVYZOlQ8B7o0000oa0@4?o<c<`01Oooool01?mVIVKo0000oc8b<_o^k^h5ooooo`04ofIVI_l0003o
<S8bonk^kQgooooo00GoZJVYob4Q8Ol0003o410@olc<c004ooooo`Co000000?o410@ooooooooool0
0oooool01?mVIVKo0000oc8b<_o^k^hbooooo`03okZj^_l0003ooooo05;ooooo00?oQhN7oc8b<_oo
ool05Oooool00oo<c<co0000onk^kP0Gooooo`03okZj^_l0003ooooo00Wooooo003ooooookgooooo
00?o^[Zjo`000?ooool0Doooool00ol0003oooooooooo`0Dooooo`03onk^k_l0003oEEEE01Oooooo
00?o^[Zjo`000?ooool02Oooool00?oooooo]?ooool01_l0003o<S8bo`000?l0003o410@oiRHV0?o
oooo00?o^[Zjo`000?nHV9P00_l000002OmVIVKoooooooooooooooooV9RHoa0@4?l0003o8B4QoiRH
V002o`000004omgMgOooooooooooofIVIP;o000000?o8B4QogMgMoo^k^h00oooool01_mVIVKo0000
o`000?l0003oA4A4oiRHV0;ooooo00?o410@o`000?l000000_l000000ol@413oooooooooo`0:oooo
o`03oa0@4?l0003o000000?o000000Go<S8booooooooooooooooofIVIP03o`000005odA4A?nHV9So
ooooooooool@41000_l000001?oooooo0000o`000?l@4103ooooo`05ofIVI_l0003o0000ofIVI_l0
00001Oooool02?nHV9So410@o`000?l@413oEEEEolc<c?oooooo410@0_l000001?oooooo0000o`00
0?l@4104ooooo`03odA4A?l0003o^[Zj00gooooo00?o410@o`000?mVIVH00_l000001omgMgOooooo
oooooooooooo^[Zjo`000?nHV9P00_l000000omVIVKoooooooooo`04ooooo`00oooooondooooo`07
o`000?n7QhOooooooooooooMgMgo410@omgMg@02ooooo`03okZj^_l0003oMgMg00;ooooo0_mgMgL2
ooooo`06ob4Q8Oo^k^koooooonk^k_mgMgOo00000oooool01omgMgOoEEEEoooooooooooogMgMob4Q
8OmgMgL00_ooool01omgMgOoEEEEonk^k_ooooook^k^oiRHV?lb<S801?ooool00ol0003ooooooooo
o`0@ooooo`03o`000?oooooooooo00?ooooo00OoMgMgoeEEEOo^k^koooooonk^k_nHV9So<S8b00?o
oooo00Go0000ooooooooooooooooo`000003ooooo`06ogMgMomEEEGok^k^omgMgOlQ8B7o00001Ooo
ool01_l0003oc<c<oooooooMgMgoQhN7ojVYZ@;ooooo00Go0000ooooooooooooooooo`000005oooo
o`03oiRHV?l0003o<S8b00kooooo00Co0000odA4A?o^k^kooooo0_mgMgL2ooooo`03okZj^_l0003o
MgMg00;ooooo0_mgMgL5ooooo`00oooooondooooo`07odA4A?ooooooooooooooooo^k^ko410@olc<
c002ooooo`03okZj^_l@413ooooo00?ooooo00Go8B4Qoooooooooooo8B4QojVYZ@02ooooo`03omgM
gOl0003ooooo00;ooooo00?o8B4Qooooooooool01_ooool00ol0003ok^k^ooooo`08ooooo`03o`00
0?oooooooooo013ooooo00?o0000ooooooooool00oooool00ol0003ok^k^ooooo`07ooooo`05o`00
0?ooooooooooooooool000000oooool01_lQ8B7oooooooooooooooooc<c<o`0000Gooooo00?o0000
ooooooooool01Oooool01Ol0003ooooooooooooooooo000001Kooooo00?o0000omgMgOooool00_oo
ool01Olb<S;ooooooooooonj^[[o410@00Cooooo00?o8B4Qooooooooool00oooool00?oooooo]?oo
ool01_o<c<co8B4Qo`000?l0003o410@ogMgM`?ooooo00?o^[Zjoc8b<_ooool00oooool01Olb<S;o
ooooooooooo<c<coA4A400;o000000?o410@o`000?ooool00_ooool00olb<S;oooooooooo`06oooo
o`Oo000000GogMgMooooooooooooooooo`00000Booooo`03o`000?oooooooooo00?ooooo1ol00000
1?oMgMgoooooooooool00003ooooo`05o`000?oooooooooooooooolb<S801?ooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo00Gooooo00Go0000ooooooooooooooooo`00000Fooooo`03
o`000?oooooooooo00;ooooo00Go<S8boooooooooooo^[Zjoc8b<P04ooooo`03oc8b<_oooooooooo
00?ooooo001loooooooo0000;_l0000:ooooo`03ob4Q8OoMgMgooooo00Kooooo00?o^[Zjo`000?o^
k^h00_ooool00oo^k^ko8B4Qooooo`06ooooo`05o`000?oooooooooooooooolQ8B401?ooool01_mg
MgOoV9RHoooooooooooo410@omgMg@?ooooo00?oV9RHo`000?ooool00oooool00ol0003oc<c<oooo
o`0@ooooo`03o`000?oooooooooo00?ooooo00?o410@omgMgOooool00_ooool00onHV9So0000oooo
o`02ooooo`05o`000?ooooooooooooooool000000oooool01_lb<S;ooooooooooooooooogMgMo`00
00Gooooo00?o0000ooooooooool01Oooool01Ol0003ooooooooooooooooo000001Kooooo00?o0000
omgMgOooool00_ooool01_lb<S;ooooooooooonj^[[o0000onk^kP;ooooo00?ok^k^ob4Q8Oooool0
1?ooool007cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Sooooo00Ko8B4Qonk^k_ooooook^k^oeEEEOnHV9P3ooooo`03okZj^_l0003oA4A400;o
gMgM00KoA4A4ogMgMoooooooooooolc<c?nHV9P2ooooo`03ohN7QolQ8B7ooooo00;ooooo00OoMgMg
oeEEEOo^k^kooooookZj^_l0003oMgMg00;ooooo00OoMgMgob4Q8OoMgMgoooooomgMgOl@413oIVIV
00Cooooo00Ko0000oc8b<_nHV9SooooookZj^_oMgMd=ooooo`03o`000?oooooooooo00?ooooo00Oo
MgMgob4Q8OoMgMgoooooomgMgOl@413oIVIV00?ooooo00Go0000ohN7Qooooooo^[Zjoa0@4003oooo
o`;oMgMg00Coooooonk^k_m4A4Co00000oooool00ol@413o0000o`000003o`000009ogMgMooooooo
ooooooooool0003oQhN7oooooonj^[[o410@01Kooooo00Co0000odA4A?o^k^kooooo0_mgMgL2oooo
o`03okZj^_l0003oA4A400;ogMgM00?oA4A4ogMgMoooool01?ooool007cooooo00?o0000oooooooo
ool0<Oooool00ol0003oooooooooo`0`ooooo`03o`000?oooooooooo037ooooo00?o0000oooooooo
ool0<Oooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo02Kooooo00?o0000oooooooo
ool02?ooool01_nHV9So0000o`000?l@413o8B4QogMgM`?ooooo00?o410@o`000?mgMgL00_l00000
1_mVIVKooooooooooooooooo^[Zjob4Q8@;o000000?o8B4Qolc<c?ooool00oooool00omVIVKo0000
o`000002ob4Q8@09ogMgMooooooooooooooooomgMgOo410@o`000?l@413oMgMg00?ooooo00Go410@
o`000?l0003ok^k^ofIVIP02o`000003ojVYZOoooooooooo00_ooooo00?o0000ooooooooool01?oo
ool01OmgMgOo410@o`000?l@413oMgMg00?ooooo0_l000001?mVIVKo0000o`000?nj^[X4ooooo`06
ofIVI_l0003o0000oeEEEOl0003o<S8b1?ooool00olb<S;oooooooooo`05ooooo`05o`000?mgMgOo
0000o`000?nj^[X05_ooool01Ol0003oIVIVo`000?l0003oIVIV00?ooooo00?o410@o`000?mgMgL0
0_l000000omVIVKoooooooooo`04ooooo`00O?ooool00ol0003oooooooooo`3oooooob[ooooo00?o
0000ooooooooool0B_ooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool06?ooool00ol0003oooooooooo`0Aooooo`00O?ooool00ol0003oooooooooo`3o
ooooob[ooooo00?o0000ooooooooool0B_ooool00ol0003oooooooooo`0Pooooo`03oa0@4?oooooo
oooo00Gooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0Aooooo`00O?ooool00ol0
003oooooooooo`3oooooob[ooooo00?o0000ooooooooool0B?ooool00ol@413o0000o`00000Yoooo
o`03oa0@4?l0003ooooo01Sooooo00?o410@o`000?ooool04_ooool007cooooo00?o0000oooooooo
ool0oooooolZooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo0?oooooo
:_ooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003oooooooooo`3oooooob[ooooo00?o
0000ooooooooool0Y?ooool007cooooo0_l0003oooooob[ooooo0_l0002Vooooo`00O?ooool00ol0
003oooooooooo`3oooooob[ooooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000oooooooo
ool0oooooolZooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo0?oooooo
:_ooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003oooooooooo`3oooooob[ooooo00?o
0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0oooooolZooooo`03o`000?oooooo
oooo0:Cooooo001looooo`03o`000?oooooooooo0?oooooo:_ooool00ol0003oooooooooo`2Toooo
o`00O?ooool00ol0003oooooooooo`3oooooob[ooooo00?o0000ooooooooool0Y?ooool007cooooo
0_l0003oooooob[ooooo0_l0002Vooooo`00O?ooool00ol0003oooooooooo`3oooooob[ooooo00?o
0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0oooooolZooooo`03o`000?oooooo
oooo0:Cooooo001looooo`03o`000?oooooooooo0?oooooo:_ooool00ol0003oooooooooo`2Toooo
o`00O?ooool00ol0003oooooooooo`3oooooob[ooooo00?o0000ooooooooool0Y?ooool007cooooo
00?o0000ooooooooool0oooooolZooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oo
oooooooo0?oooooo:_ooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003oooooooooo`3o
ooooob[ooooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0oooooolZoooo
o`03o`000?oooooooooo0:Cooooo001looooo`;o0000oooooolZooooo`;o0000Y_ooool007cooooo
00?o0000ooooooooool0oooooolZooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oo
oooooooo0?oooooo:_ooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003oooooooooo`3o
ooooob[ooooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0oooooolZoooo
o`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo0?oooooo:_ooool00ol0003o
ooooooooo`2Tooooo`00O?ooool00ol0003oooooooooo`3oooooob[ooooo00?o0000ooooooooool0
Y?ooool007cooooo00?o0000ooooooooool0oooooolZooooo`03o`000?oooooooooo0:Cooooo001l
ooooo`;o0000oooooolZooooo`;o0000Y_ooool007cooooo00?o0000ooooooooool0oooooolZoooo
o`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo0?oooooo:_ooool00ol0003o
ooooooooo`2Tooooo`00O?ooool00ol0003oooooooooo`3oooooob[ooooo00?o0000ooooooooool0
Y?ooool007cooooo00?o0000ooooooooool0oooooolZooooo`03o`000?oooooooooo0:Cooooo001l
ooooo`03o`000?oooooooooo0?oooooo:_ooool00ol0003oooooooooo`2Tooooo`00H?ooool01?mV
IVKo0000oc8b<_o^k^h5ooooo`03oiRHV?l0003oEEEE00Cooooo00Koc<c<ob4Q8Ol0003o0000oc8b
<_oMgMd6ooooo`03o`000?oooooooooo0?oooooo:_ooool00ol0003oooooooooo`2Tooooo`00Gooo
ool2ohN7Q`03oooooon7QhOoA4A400Gooooo00?o<S8bo`000?l000001?ooool01_o<c<coZJVYoooo
ooooooooV9RHob4Q8@Kooooo00?o0000ooooooooool0oooooolZooooo`03o`000?oooooooooo0:Co
oooo001Oooooo`05oc8b<_ooooooooooooooool000001Oooool00onYZJWo8B4QogMgM`09ooooo`03
ob4Q8Onj^[[ooooo00Cooooo00?o0000ooooooooool0oooooolZooooo`03o`000?oooooooooo0:Co
oooo001Oooooo`06oc8b<_oooooooooooooooolb<S;o^[Zj4?ooool00olQ8B7o^[Zjooooo`04oooo
o`?o0000oooooolXooooo`?o0000Y_ooool005oooooo00Ko<S8boooooooooooooooooc8b<_nj^[X<
ooooo`05ofIVI_oMgMgoooooohN7Qol@41001_ooool00ol0003oooooooooo`3oooooob[ooooo00?o
0000ooooooooool0Y?ooool005oooooo00Ko<S8boooooooooooooooooc8b<_nj^[X<ooooo`05o`00
0?lQ8B7o0000oa0@4?o<c<`01_ooool00ol0003oooooooooo`3oooooob[ooooo00?o0000oooooooo
ool0Y?ooool005oooooo00Go<S8bonk^k_ooooook^k^o`00000=ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool0oooooolZooooo`03o`000?oooooooooo0:Cooooo001Oooooo`05ohN7
QomVIVKoooooofIVI_m4A4@03Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo0?oo
oooo:_ooool00ol0003oooooooooo`2Tooooo`00H?ooool01?mVIVKo0000oc8b<_o^k^h=ooooo`Co
000000?o410@ooooooooool01?ooool00ol0003oooooooooo`3oooooob[ooooo00?o0000oooooooo
ool0Y?ooool007cooooo00?o0000ooooooooool0oooooolZooooo`03o`000?oooooooooo0:Cooooo
001looooo`03o`000?oooooooooo0?oooooo:_ooool00ol0003oooooooooo`2Tooooo`00O?ooool2
o`000?oooooo:_ooool2o`000:Kooooo001looooo`03o`000?oooooooooo0?oooooo:_ooool00ol0
003oooooooooo`2Tooooo`00O?ooool00ol0003oooooooooo`3oooooob[ooooo00?o0000oooooooo
ool0Y?ooool007cooooo00?o0000ooooooooool0oooooolZooooo`03o`000?oooooooooo0:Cooooo
001looooo`03o`000?oooooooooo0?oooooo:_ooool00ol0003oooooooooo`2Tooooo`00O?ooool0
0ol0003oooooooooo`3oooooob[ooooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000oooo
ooooool0oooooolZooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo0?oo
oooo:_ooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003oooooooooo`3oooooob[ooooo
00?o0000ooooooooool0Y?ooool007cooooo0_l0003oooooob[ooooo0_l0002Vooooo`00O?ooool0
0ol0003oooooooooo`3oooooob[ooooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000oooo
ooooool0oooooolZooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo0?oo
oooo:_ooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003oooooooooo`3oooooob[ooooo
00?o0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0oooooolZooooo`03o`000?oo
oooooooo0:Cooooo001looooo`03o`000?oooooooooo0?oooooo:_ooool00ol0003oooooooooo`2T
ooooo`00O?ooool00ol0003oooooooooo`3oooooob[ooooo00?o0000ooooooooool0Y?ooool007co
oooo0_l0003oooooob[ooooo0_l0002Vooooo`00O?ooool00ol0003oooooooooo`3oooooob[ooooo
00?o0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0oooooolZooooo`03o`000?oo
oooooooo0:Cooooo001looooo`03o`000?oooooooooo0?oooooo:_ooool00ol0003oooooooooo`2T
ooooo`00O?ooool00ol0003oooooooooo`3oooooob[ooooo00?o0000ooooooooool0Y?ooool007co
oooo00?o0000ooooooooool0oooooolZooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`00
0?oooooooooo0?oooooo:_ooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003ooooooooo
o`3oooooob[ooooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0oooooolZ
ooooo`03o`000?oooooooooo0:Cooooo001looooo`;o0000oooooolZooooo`;o0000Y_ooool007co
oooo00?o0000ooooooooool0oooooolZooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`00
0?oooooooooo0?oooooo:_ooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003ooooooooo
o`3oooooob[ooooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0oooooolZ
ooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo0?oooooo:_ooool00ol0
003oooooooooo`2Tooooo`00LOooool00ol@413o0000o`000002o`000003omgMgOoooooooooo00?o
oooo00?o0000ooooooooool0oooooolZooooo`03o`000?oooooooooo0:Cooooo001cooooo`03o`00
0?oooooooooo00Kooooo00?o0000ooooooooool0oooooolZooooo`03o`000?oooooooooo0:Cooooo
001cooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0oooooolZooooo`03o`000?oo
oooooooo0:Cooooo001cooooo`03o`000?oooooooooo00Kooooo0ol0003oooooobSooooo0ol0002V
ooooo`00Loooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo0?oooooo:_ooool00ol0
003oooooooooo`2Tooooo`00Loooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo0?oo
oooo:_ooool00ol0003oooooooooo`2Tooooo`00Loooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo0?oooooo:_ooool00ol0003oooooooooo`2Tooooo`00LOooool00on7QhOo^[Zjo`00
0008ooooo`03o`000?oooooooooo0?oooooo:_ooool00ol0003oooooooooo`2Tooooo`00LOooool0
0on7QhOo<S8bo`000008ooooo`03o`000?oooooooooo037ooooo0ol0003eooooo`03o`000?oooooo
oooo0:Cooooo001looooo`03o`000?oooooooooo03Cooooo1Ol0003`ooooo`03o`000?oooooooooo
0:Cooooo001looooo`03o`000?oooooooooo03Wooooo0_l0003^ooooo`03o`000?oooooooooo0:Co
oooo001looooo`;o0000@Oooool2o`000>Kooooo0_l0002Vooooo`00O?ooool00ol0003ooooooooo
o`12ooooo`Co0000hoooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003oooooooooo`16
ooooo`?o0000h?ooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003oooooooooo`3ooooo
ob[ooooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0C_ooool4o`000=Oo
oooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0D_ooool5o`000=;ooooo
00?o0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0Eoooool00ol0003ooooooooo
o`3?ooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo0?oooooo:_ooool0
0ol0003oooooooooo`2Tooooo`00O?ooool00ol0003oooooooooo`1Mooooo`?o0000bOooool00ol0
003oooooooooo`2Tooooo`00O?ooool2o`00067ooooo1?l00034ooooo`;o0000Y_ooool007cooooo
00?o0000ooooooooool0I?ooool2o`000<?ooooo00?o0000ooooooooool0Y?ooool007cooooo00?o
0000ooooooooool0oooooolZooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooo
oooo06_ooooo0ol0002kooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo
06kooooo1Ol0002fooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo07?o
oooo0_l0002dooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo0?oooooo
:_ooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003oooooooooo`1jooooo`;o0000[Ooo
ool00ol0003oooooooooo`2Tooooo`00O?ooool2o`0007gooooo0ol0002Yooooo`;o0000Y_ooool0
07cooooo00?o0000ooooooooool0Ooooool3o`000:Oooooo00?o0000ooooooooool0Y?ooool007co
oooo00?o0000ooooooooool0P_ooool00ol0003oooooooooo`2Tooooo`03o`000?oooooooooo0:Co
oooo001looooo`03o`000?oooooooooo08Sooooo0_l0002Oooooo`03o`000?oooooooooo0:Cooooo
001looooo`03o`000?oooooooooo08[ooooo0ol0002Looooo`03o`000?oooooooooo0:Cooooo001l
ooooo`03o`000?oooooooooo08gooooo0ol0002Iooooo`03o`000?oooooooooo0:Cooooo001loooo
o`03o`000?oooooooooo037ooooo0_l0001Mooooo`03o`000?oooooooooo09Kooooo00?o0000oooo
ooooool0Y?ooool007cooooo00?o0000ooooooooool0<oooool00ol0003oooooooooo`3cooooo`03
o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo03Cooooo0_l0001Pooooo`?o0000
T?ooool00ol0003oooooooooo`2Tooooo`00O?ooool2o`0003Oooooo00?o0000ooooooooool0H?oo
ool5o`0008[ooooo0_l0002Vooooo`00O?ooool00ol0003oooooooooo`0gooooo`;o0000IOooool2
o`0008Wooooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0>Oooool2o`00
0>kooooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0>oooool00ol0003o
ooooooooo`1Wooooo`;o0000P_ooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003ooooo
ooooo`0looooo`;o0000JOooool3o`0007oooooo00?o0000ooooooooool0Y?ooool007cooooo00?o
0000ooooooooool0?_ooool00ol0003oooooooooo`1Yooooo`?o0000O?ooool00ol0003ooooooooo
o`2Tooooo`00Goooool00ol@413o0000o`000002o`000003omgMgOoooooooooo00;ooooo00?oV9RH
o`000?mEEED01?ooool01_o<c<co8B4Qo`000?l0003o<S8bomgMg@Kooooo00?o0000ooooooooool0
<Oooool6o`0000Sooooo0_l0001/ooooo`03o`000?oooooooooo07Wooooo00?o0000ooooooooool0
Y?ooool0067ooooo00?o0000ooooooooool01Oooool00olb<S;o0000o`000004ooooo`06olc<c?nY
ZJWooooooooooonHV9So8B4Q1_ooool00ol0003oooooooooo`0gooooo`Co00001_ooool00ol0003o
ooooooooo`1_ooooo`?o0000Loooool00ol0003oooooooooo`2Tooooo`00HOooool00ol0003ooooo
ooooo`05ooooo`03ojVYZOlQ8B7oMgMg00Wooooo00?o8B4QokZj^_ooool01?ooool3o`00043ooooo
1?l0001booooo`?o0000K_ooool3o`000:Kooooo001Qooooo`03o`000?oooooooooo017ooooo00?o
8B4QokZj^_ooool01?ooool00ol0003oooooooooo`12ooooo`Go0000L_ooool3o`0006gooooo00?o
0000ooooooooool0Y?ooool0067ooooo00?o0000ooooooooool03Oooool01OmVIVKogMgMoooooon7
QhOo410@00Kooooo00?o0000ooooooooool0A_ooool4o`0007;ooooo00?o0000ooooooooool0J_oo
ool00ol0003oooooooooo`2Tooooo`00HOooool00ol0003oooooooooo`0=ooooo`05o`000?lQ8B7o
0000oa0@4?o<c<`01_ooool00ol0003oooooooooo`18ooooo`03o`000?oooooooooo00Cooooo1?l0
003Fooooo`03o`000?oooooooooo0:Cooooo001Qooooo`03o`000?oooooooooo00gooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`19ooooo`;o00002?ooool4o`0006[ooooo0ol0001U
ooooo`03o`000?oooooooooo0:Cooooo001Oooooo`03ohN7Qonj^[[o000000oooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`1;ooooo`;o00002_ooool00ol0003oooooooooo`1Zoooo
o`Go0000H?ooool00ol0003oooooooooo`2Tooooo`00Goooool00on7QhOo<S8bo`00000?ooooo`Co
000000?o410@ooooooooool01?ooool00ol0003oooooooooo`1=ooooo`;o00003_ooool3o`0006Wo
oooo0_l0001Nooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo04oooooo
0_l0000?ooooo`Co0000aOooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003ooooooooo
o`1Aooooo`03o`000?oooooooooo013ooooo0ol0001Yooooo`;o0000Eoooool00ol0003ooooooooo
o`2Tooooo`00O?ooool2o`0005?ooooo0_l0001nooooo`?o0000Doooool2o`000:Kooooo001loooo
o`03o`000?oooooooooo05Cooooo0_l0000Fooooo`?o0000I_ooool3o`00057ooooo00?o0000oooo
ooooool0Y?ooool007cooooo00?o0000ooooooooool0E_ooool00ol0003oooooooooo`0Fooooo`Co
0000IOooool00ol0003oooooooooo`1>ooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`00
0?oooooooooo05Oooooo0_l0000Jooooo`;o0000]?ooool00ol0003oooooooooo`2Tooooo`00O?oo
ool00ol0003oooooooooo`1Iooooo`03o`000?oooooooooo08;ooooo0ol00018ooooo`03o`000?oo
oooooooo0:Cooooo001looooo`03o`000?oooooooooo05[ooooo0_l0000Nooooo`?o0000I?ooool5
o`0004?ooooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0G?ooool2o`00
01oooooo1Ol0001Tooooo`;o0000@Oooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003o
ooooooooo`1Nooooo`03o`000?oooooooooo027ooooo0_l0002Uooooo`03o`000?oooooooooo0:Co
oooo001looooo`03o`000?oooooooooo05oooooo0_l0000Xooooo`;o0000HOooool3o`0003[ooooo
00?o0000ooooooooool0Y?ooool007cooooo0_l0001Rooooo`03o`000?oooooooooo02Oooooo0ol0
001Qooooo`?o0000=_ooool2o`000:Kooooo001looooo`03o`000?oooooooooo06;ooooo0_l0000Z
ooooo`?o0000HOooool3o`0003Cooooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000oooo
ooooool0I?ooool00ol0003oooooooooo`0Zooooo`03o`000?oooooooooo067ooooo00?o0000oooo
ooooool0<Oooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003oooooooooo`1Uooooo`;o
0000<?ooool3o`00067ooooo0_l0000/ooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`00
0?oooooooooo06Oooooo0_l0000aooooo`Go0000G_ooool3o`0002Wooooo00?o0000ooooooooool0
Y?ooool007cooooo00?o0000ooooooooool0JOooool00ol0003oooooooooo`0cooooo`;o0000Gooo
ool3o`0002Kooooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0J_ooool2
o`0009Oooooo00?o0000ooooooooool08oooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0
003oooooooooo`1/ooooo`;o0000>?ooool3o`00083ooooo00?o0000ooooooooool0Y?ooool007co
oooo0_l0001_ooooo`;o0000>Oooool4o`0005cooooo0ol0000Looooo`;o0000Y_ooool007cooooo
00?o0000ooooooooool0L?ooool00ol0003oooooooooo`0jooooo`;o0000GOooool5o`0001Sooooo
00?o0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0LOooool2o`0009kooooo0_l0
000Fooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo07?ooooo0_l0000o
ooooo`?o0000L_ooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003oooooooooo`1eoooo
o`;o0000@?ooool5o`0006gooooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000oooooooo
ool0Moooool00ol0003oooooooooo`12ooooo`;o0000Joooool00ol0003oooooooooo`2Tooooo`00
O?ooool00ol0003oooooooooo`0aooooo`;o0000AOooool2o`000:oooooo00?o0000ooooooooool0
Y?ooool007cooooo00?o0000ooooooooool0<oooool00ol0003oooooooooo`14ooooo`;o0000Aooo
ool3o`0006?ooooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0=?ooool0
0ol0003oooooooooo`15ooooo`;o0000B?ooool4o`0005oooooo00?o0000ooooooooool0Y?ooool0
07cooooo0_l0000fooooo`03o`000?oooooooooo04Kooooo00?o0000ooooooooool0BOooool2o`00
05cooooo0_l0002Vooooo`00O?ooool00ol0003oooooooooo`0fooooo`03o`000?oooooooooo04Ko
oooo0_l0002Xooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo03Oooooo
0_l00018ooooo`;o0000C_ooool3o`0005Gooooo00?o0000ooooooooool0Y?ooool007cooooo00?o
0000ooooooooool0>Oooool00ol0003oooooooooo`17ooooo`;o0000Coooool5o`00053ooooo00?o
0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0>_ooool00ol0003oooooooooo`18
ooooo`03o`000?oooooooooo057ooooo0_l0001>ooooo`03o`000?oooooooooo0:Cooooo001loooo
o`03o`000?oooooooooo03_ooooo00?o0000ooooooooool0B?ooool2o`000:7ooooo00?o0000oooo
ooooool0Y?ooool0073ooooo00?oQhN7o`000?l000000_l000000ol@413oooooooooo`04ooooo`03
o`000?oooooooooo03cooooo0_l0001:ooooo`;o0000E_ooool3o`0004Kooooo00?o0000oooooooo
ool0Y?ooool0073ooooo00?ok^k^oc8b<_o<c<`02Oooool00ol0003oooooooooo`0nooooo`03o`00
0?oooooooooo04Wooooo0_l0001Gooooo`Co0000@_ooool00ol0003oooooooooo`2Tooooo`00LOoo
ool00oo^k^ko<S8bojVYZ@08ooooo`?o0000?oooool00ol0003oooooooooo`1:ooooo`03o`000?oo
oooooooo05Sooooo0_l0000nooooo`?o0000Y_ooool007;ooooo00?ok^k^ob4Q8OnHV9P01oooool0
0ol0003oooooooooo`10ooooo`03o`000?oooooooooo04[ooooo0_l0002Jooooo`03o`000?oooooo
oooo0:Cooooo001cooooo`03onk^k_lb<S;oc<c<00Kooooo00?o0000ooooooooool0@Oooool00ol0
003oooooooooo`1;ooooo`;o0000GOooool2o`0003Wooooo00?o0000ooooooooool0Y?ooool007Co
oooo00?ok^k^odA4A?ooool01Oooool00ol0003oooooooooo`12ooooo`;o0000COooool2o`0005go
oooo0ol0000fooooo`03o`000?oooooooooo0:Cooooo001aooooo`05okZj^_oooooooooooooooolb
<S801_ooool00ol0003oooooooooo`14ooooo`03o`000?oooooooooo04cooooo0_l0001Nooooo`?o
0000<oooool00ol0003oooooooooo`2Tooooo`00L?ooool01_o<c<co0000ohN7Qooooooo^[Zjob4Q
8@Kooooo00?o0000ooooooooool0AOooool2o`0004kooooo00?o0000ooooooooool0G_ooool2o`00
037ooooo00?o0000ooooooooool0Y?ooool0077ooooo00GoZJVYob4Q8Ol0003o410@olc<c006oooo
o`03o`000?oooooooooo04Oooooo00?o0000ooooooooool0C?ooool2o`0006Cooooo0ol0000Zoooo
o`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo04Sooooo0_l0001>ooooo`;o
0000IOooool3o`0002Oooooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0
B_ooool00ol0003oooooooooo`1=ooooo`;o0000I_ooool3o`0002Cooooo00?o0000ooooooooool0
Y?ooool007cooooo0_l0001<ooooo`;o0000Coooool2o`0006Oooooo00?o0000ooooooooool08?oo
ool2o`000:Kooooo001looooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0C_ooool0
0ol0003oooooooooo`1Zooooo`?o00006oooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0
003oooooooooo`1>ooooo`;o0000Coooool2o`0006gooooo0ol0000Hooooo`03o`000?oooooooooo
0:Cooooo001looooo`03o`000?oooooooooo053ooooo00?o0000ooooooooool0C_ooool2o`0006ko
oooo0_l0000Fooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo057ooooo
0_l0001@ooooo`;o0000Q?ooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003ooooooooo
o`1Cooooo`03o`000?oooooooooo04oooooo0_l00022ooooo`03o`000?oooooooooo0:Cooooo001l
ooooo`03o`000?oooooooooo05Cooooo0_l0001Aooooo`03o`000?oooooooooo07oooooo00?o0000
ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0E_ooool00ol0003oooooooooo`1?oooo
o`;o0000Ooooool00ol0003oooooooooo`2Tooooo`00O?ooool2o`0005Sooooo0_l0001Aooooo`;o
0000O?ooool2o`000:Kooooo001looooo`03o`000?oooooooooo05Wooooo00?o0000ooooooooool0
D?ooool2o`0007_ooooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0F_oo
ool2o`0005;ooooo0_l0001iooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooo
oooo05cooooo0_l0001Booooo`;o0000Moooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0
003oooooooooo`1Nooooo`03o`000?oooooooooo057ooooo0_l0001eooooo`03o`000?oooooooooo
0:Cooooo001looooo`03o`000?oooooooooo05oooooo0_l0001Cooooo`;o0000Loooool00ol0003o
ooooooooo`2Tooooo`00O?ooool00ol0003oooooooooo`1Qooooo`03o`000?oooooooooo05;ooooo
0_l0001aooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo06;ooooo0_l0
001Dooooo`;o0000Koooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003oooooooooo`1T
ooooo`03o`000?oooooooooo05?ooooo0_l0001]ooooo`03o`000?oooooooooo0:Cooooo001loooo
o`;o0000I_ooool2o`0005Gooooo00?o0000ooooooooool0JOooool2o`000:Kooooo001looooo`03
o`000?oooooooooo06Oooooo00?o0000ooooooooool0Doooool2o`0006[ooooo00?o0000oooooooo
ool0Y?ooool007cooooo00?o0000ooooooooool0J?ooool2o`0005Gooooo0_l0001Xooooo`03o`00
0?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo06[ooooo0_l0001Eooooo`;o0000I_oo
ool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003oooooooooo`1/ooooo`03o`000?oooooo
oooo05Cooooo0_l0001Tooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo
06gooooo0_l0001Fooooo`;o0000H_ooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003o
ooooooooo`1_ooooo`03o`000?oooooooooo05Gooooo0_l0001Pooooo`03o`000?oooooooooo0:Co
oooo001looooo`03o`000?oooooooooo073ooooo0_l0001Gooooo`;o0000G_ooool00ol0003ooooo
ooooo`2Tooooo`00O?ooool00ol0003oooooooooo`1booooo`;o0000Eoooool2o`0005cooooo00?o
0000ooooooooool0Y?ooool007cooooo0_l0001eooooo`03o`000?oooooooooo05Kooooo0_l0001I
ooooo`;o0000Y_ooool007cooooo00?o0000ooooooooool0MOooool2o`0005Sooooo0_l0001Hoooo
o`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo07Oooooo00?o0000oooooooo
ool0Eoooool2o`0005Kooooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0
N?ooool2o`0005Wooooo0_l0001Dooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oo
oooooooo07[ooooo00?o0000ooooooooool0F?ooool2o`0005;ooooo00?o0000ooooooooool0Y?oo
ool007cooooo00?o0000ooooooooool0Noooool2o`0005[ooooo0_l0001@ooooo`03o`000?oooooo
oooo0:Cooooo001Nooooo`03ohN7Qol0003o000000;o000000?o410@ooooooooool00oooool00onH
V9So0000oeEEE@04ooooo`06olc<c?lQ8B7o0000o`000?lb<S;ogMgM1_ooool00ol0003ooooooooo
o`1mooooo`;o0000F_ooool2o`0004kooooo00?o0000ooooooooool0Y?ooool005kooooo00?ok^k^
oc8b<_o<c<`02?ooool00olb<S;o0000o`000004ooooo`06olc<c?nYZJWooooooooooonHV9So8B4Q
1_ooool00ol0003oooooooooo`1oooooo`03o`000?oooooooooo05Wooooo0_l0001<ooooo`03o`00
0?oooooooooo0:Cooooo001Oooooo`03onk^k_lb<S;oZJVY00Oooooo00?oZJVYob4Q8OmgMgL02Ooo
ool00olQ8B7o^[Zjooooo`04ooooo`?o0000P?ooool2o`0005_ooooo0_l00018ooooo`?o0000Y_oo
ool0063ooooo00?ok^k^ob4Q8OnHV9P04_ooool00olQ8B7o^[Zjooooo`04ooooo`03o`000?oooooo
oooo08;ooooo00?o0000ooooooooool0F_ooool00ol0003oooooooooo`17ooooo`03o`000?oooooo
oooo0:Cooooo001Qooooo`03onk^k_lb<S;oc<c<00gooooo00GoIVIVomgMgOooooooQhN7oa0@4006
ooooo`03o`000?oooooooooo08?ooooo0_l0001Kooooo`;o0000Aoooool00ol0003oooooooooo`2T
ooooo`00H_ooool00oo^k^koA4A4ooooo`0<ooooo`05o`000?lQ8B7o0000oa0@4?o<c<`01_ooool0
0ol0003oooooooooo`25ooooo`;o0000Foooool2o`0004Gooooo00?o0000ooooooooool0Y?ooool0
05oooooo00Go^[Zjoooooooooooooooooc8b<P0=ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool0Qoooool00ol0003oooooooooo`1Jooooo`;o0000@oooool00ol0003oooooooooo`2T
ooooo`00G_ooool01_o<c<co0000ohN7Qooooooo^[Zjob4Q8@gooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`28ooooo`;o0000G?ooool2o`00047ooooo00?o0000ooooooooool0Y?oo
ool005oooooo00GoZJVYob4Q8Ol0003o410@olc<c00=ooooo`Co000000?o410@ooooooooool01?oo
ool00ol0003oooooooooo`2:ooooo`03o`000?oooooooooo05_ooooo0_l0000oooooo`03o`000?oo
oooooooo0:Cooooo001looooo`03o`000?oooooooooo08_ooooo0_l0001Mooooo`;o0000?Oooool0
0ol0003oooooooooo`2Tooooo`00O?ooool00ol0003oooooooooo`2=ooooo`;o0000GOooool2o`00
03_ooooo00?o0000ooooooooool0Y?ooool007cooooo0_l0002@ooooo`03o`000?oooooooooo05co
oooo0_l0000hooooo`;o0000Y_ooool007cooooo00?o0000ooooooooool0T?ooool2o`0005kooooo
0_l0000gooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo09;ooooo0_l0
001Nooooo`;o0000=Oooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003oooooooooo`2D
ooooo`03o`000?oooooooooo05gooooo0_l0000cooooo`03o`000?oooooooooo0:Cooooo001loooo
o`03o`000?oooooooooo09Gooooo0_l0001Oooooo`;o0000<Oooool00ol0003oooooooooo`2Toooo
o`00O?ooool00ol0003oooooooooo`2Gooooo`03o`000?oooooooooo05kooooo0_l0000_ooooo`03
o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo09Sooooo0_l0001Pooooo`03o`00
0?oooooooooo02cooooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0V_oo
ool2o`0005oooooo0_l0000/ooooo`03o`000?oooooooooo0:Cooooo001looooo`;o0000WOooool0
0ol0003oooooooooo`1Nooooo`;o0000:Oooool2o`000:Kooooo001looooo`03o`000?oooooooooo
09gooooo0_l0001Pooooo`;o0000:?ooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003o
ooooooooo`2Oooooo`03o`000?oooooooooo05oooooo0_l0000Vooooo`03o`000?oooooooooo0:Co
oooo001looooo`03o`000?oooooooooo0:3ooooo0_l0001Qooooo`;o00009?ooool00ol0003ooooo
ooooo`2Tooooo`00O?ooool00ol0003oooooooooo`2Rooooo`;o0000HOooool2o`0002;ooooo00?o
0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0Y?ooool00ol0003oooooooooo`1P
ooooo`;o00008?ooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003oooooooooo`2Uoooo
o`;o0000H_ooool2o`0001kooooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000oooooooo
ool0Yoooool2o`0006;ooooo00?o0000ooooooooool06oooool00ol0003oooooooooo`2Tooooo`00
O?ooool00ol0003oooooooooo`2Yooooo`03o`000?oooooooooo063ooooo0_l0000Kooooo`03o`00
0?oooooooooo0:Cooooo001looooo`;o0000Zoooool2o`0006;ooooo0_l0000Hooooo`;o0000Y_oo
ool007cooooo00?o0000ooooooooool0[?ooool2o`0006;ooooo0_l0000Gooooo`03o`000?oooooo
oooo0:Cooooo001looooo`03o`000?oooooooooo0:kooooo00?o0000ooooooooool0HOooool00ol0
003oooooooooo`0Dooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo0:oo
oooo0_l0001hooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo0;7ooooo
0_l0001fooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo0;?ooooo0_l0
001dooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo0;Gooooo00?o0000
ooooooooool0LOooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003oooooooooo`2foooo
o`;o0000LOooool00ol0003oooooooooo`2Tooooo`00O?ooool2o`000;Wooooo0_l0001^ooooo`;o
0000Y_ooool007cooooo00?o0000ooooooooool0^_ooool2o`0006gooooo00?o0000ooooooooool0
Y?ooool007cooooo00?o0000ooooooooool0_?ooool00ol0003oooooooooo`1Zooooo`03o`000?oo
oooooooo0:Cooooo001looooo`03o`000?oooooooooo0;gooooo0_l0001Zooooo`03o`000?oooooo
oooo0:Cooooo001looooo`03o`000?oooooooooo0;oooooo0_l0001Xooooo`03o`000?oooooooooo
0:Cooooo001looooo`03o`000?oooooooooo0<7ooooo0_l0001Vooooo`03o`000?oooooooooo0:Co
oooo001looooo`03o`000?oooooooooo0<?ooooo00?o0000ooooooooool0Hoooool00ol0003ooooo
ooooo`2Tooooo`00L?ooool01_nj^[[oA4A4o`000?l0003o8B4Qolc<c0Kooooo00?o0000oooooooo
ool0a?ooool2o`0006?ooooo00?o0000ooooooooool0Y?ooool0073ooooo00OoZJVYoiRHV?oooooo
oooookZj^_l0003ok^k^00Gooooo00?o0000ooooooooool0a_ooool2o`00067ooooo00?o0000oooo
ooooool0Y?ooool007Gooooo00?o<S8bokZj^_ooool01?ooool3o`000<Sooooo0_l0001Mooooo`?o
0000Y_ooool007Cooooo00?ok^k^o`000?oMgMd01Oooool00ol0003oooooooooo`3:ooooo`03o`00
0?oooooooooo05cooooo00?o0000ooooooooool0Y?ooool007?ooooo00?oIVIVoa0@4?n7QhL01_oo
ool00ol0003oooooooooo`3;ooooo`;o0000G?ooool00ol0003oooooooooo`2Tooooo`00Loooool0
0ooMgMgoMgMgofIVIP06ooooo`03o`000?oooooooooo0<gooooo0_l0001Jooooo`03o`000?oooooo
oooo0:Cooooo001eooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0coooool2o`00
05Sooooo00?o0000ooooooooool0Y?ooool0077ooooo00GoA4A4okZj^_ooooooV9RHoa0@4006oooo
o`03o`000?oooooooooo0=7ooooo0_l0001Fooooo`03o`000?oooooooooo0:Cooooo001aooooo`05
ohN7Qol@413o0000oa0@4?o<c<`01_ooool00ol0003oooooooooo`3Cooooo`03o`000?oooooooooo
05?ooooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0e?ooool2o`0005?o
oooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0e_ooool2o`00057ooooo
00?o0000ooooooooool0Y?ooool007cooooo0_l0003Iooooo`;o0000C_ooool2o`000:Kooooo001l
ooooo`03o`000?oooooooooo0=[ooooo0_l0001=ooooo`03o`000?oooooooooo0:Cooooo001loooo
o`03o`000?oooooooooo0=cooooo0_l0001;ooooo`03o`000?oooooooooo0:Cooooo001looooo`03
o`000?oooooooooo0=kooooo0_l00019ooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`00
0?oooooooooo0>3ooooo00?o0000ooooooooool0A_ooool00ol0003oooooooooo`2Tooooo`00O?oo
ool00ol0003oooooooooo`3Qooooo`;o0000A_ooool00ol0003oooooooooo`2Tooooo`00O?ooool0
0ol0003oooooooooo`3Sooooo`;o0000A?ooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0
003oooooooooo`3Uooooo`;o0000@_ooool00ol0003oooooooooo`2Tooooo`00O?ooool2o`000>So
oooo0_l0000oooooo`;o0000Y_ooool007cooooo00?o0000ooooooooool0jOooool2o`0003kooooo
00?o0000ooooooooool0Y?ooool007cooooo00?o0000ooooooooool0joooool00ol0003ooooooooo
o`0kooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo0>cooooo0_l0000k
ooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo0>kooooo0_l0000ioooo
o`03o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo0?3ooooo0_l0000gooooo`03
o`000?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo0?;ooooo0_l0000eooooo`03o`00
0?oooooooooo0:Cooooo001looooo`03o`000?oooooooooo0?Cooooo0_l0000cooooo`03o`000?oo
oooooooo0:Cooooo001looooo`03o`000?oooooooooo0?Kooooo0_l0000aooooo`03o`000?oooooo
oooo0:Cooooo001looooo`;o0000nOooool2o`0002kooooo0_l0002Vooooo`00O?ooool00ol0003o
ooooooooo`3jooooo`03o`000?oooooooooo02cooooo00?o0000ooooooooool0Y?ooool007cooooo
00?o0000ooooooooool0noooool2o`0002cooooo00?o0000ooooooooool0Y?ooool007cooooo00?o
0000ooooooooool0oOooool2o`0002[ooooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000
ooooooooool0ooooool2o`0002Sooooo00?o0000ooooooooool0Y?ooool007cooooo00?o0000oooo
ooooool0ooooool2ooooo`;o00009_ooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003o
ooooooooo`3oooooo`Cooooo0_l0000Tooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`00
0?oooooooooo0?oooooo1_ooool2o`0002;ooooo00?o0000ooooooooool0Y?ooool007cooooo0_l0
003oooooo`Wooooo0_l0000Oooooo`;o0000Y_ooool007cooooo00?o0000ooooooooool0ooooool:
ooooo`;o00007_ooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003oooooooooo`3ooooo
o`cooooo00?o0000ooooooooool06oooool00ol0003oooooooooo`2Tooooo`00O?ooool00ol0003o
ooooooooo`3oooooo`gooooo0_l0000Kooooo`03o`000?oooooooooo0:Cooooo001looooo`03o`00
0?oooooooooo0?oooooo3oooool2o`0001Wooooo00?o0000ooooooooool0Y?ooool007cooooo00?o
0000ooooooooool0oooooolAooooo`;o00005oooool00ol0003oooooooooo`2Tooooo`00G_ooool0
1_nj^[[oA4A4o`000?l0003o8B4Qolc<c0Gooooo00?oV9RHo`000?mEEED01?ooool01_o<c<co8B4Q
o`000?l0003o<S8bomgMg@Kooooo00?o0000ooooooooool0oooooolCooooo`03o`000?oooooooooo
01Cooooo00?o0000ooooooooool0Y?ooool005kooooo00OoZJVYoiRHV?oooooooooookZj^_l0003o
k^k^00Cooooo00?o<S8bo`000?l000001?ooool01_o<c<coZJVYooooooooooooV9RHob4Q8@Kooooo
00?o0000ooooooooool0<Oooool00ol0003oooooooooo`0`ooooo`03o`000?oooooooooo037ooooo
00?o0000ooooooooool0<Oooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo02Kooooo
00?o0000ooooooooool0Y?ooool006?ooooo00?o<S8bokZj^_ooool00oooool00onYZJWo8B4QogMg
M`09ooooo`03ob4Q8Onj^[[ooooo00Cooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo0:Cooooo001Rooooo`03onk^k_l0003ogMgM013ooooo00?o8B4Q
okZj^_ooool01?ooooooo`0002ko0000Y_ooool0067ooooo00?oIVIVoa0@4?n7QhL03Oooool01OmV
IVKogMgMoooooon7QhOo410@0?oooooof_ooool0067ooooo00?ogMgMogMgMomVIVH03Oooool01Ol0
003o8B4Qo`000?l@413oc<c<0?oooooof_ooool006?ooooo00?o0000ooooooooool02oooool00ol0
003oooooooooo`3oooooomcooooo001Oooooo`05odA4A?nj^[[ooooooiRHV?l@41003Oooool00ol0
003oooooooooo`3oooooomcooooo001Oooooo`05ohN7Qol@413o0000oa0@4?o<c<`03Oooool4o`00
0003oa0@4?oooooooooo0?oooooof?ooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo
003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003ooooooooo
ooooDOooool00?oooooooooooomAooooo`001?ooool00ol@413o0000o`000002o`000005oa0@4?oo
ooooooooooooool@41001?l000001Ol@413ooooooooooooooooo<S8b00Go000000Go410@oooooooo
ooooooooofIVIP02o`000003ob4Q8OmgMgOok^k^00Cooooo00SoV9RHoa0@4?l0003o410@oeEEEOo<
c<cooooooc8b<PGo000000Ko410@ooooooooooooooooohN7Qol@4102o`000005ofIVI_o^k^kooooo
ooooool@41000_l000001?oooooo0000o`000?l@410<ooooo`06ofIVI_l0003o0000ob4Q8OmgMgOo
k^k^0oooool01_n7QhOo410@o`000?l0003oIVIVonk^kP?ooooo00KoIVIVo`000?l0003o0000odA4
A?nHV9P2ooooo`03oa0@4?l0003o000000;o000000Go410@oooooooooooooooooa0@4004o`000005
oa0@4?oooooooooooooooolb<S801Ol000001Ol@413oooooooooooooooooIVIV00;o000000?o8B4Q
ogMgMoo^k^h00_ooool00olb<S;o0000o`000003o`000005oa0@4?oooooooooooooooomVIVH00ol0
00001Om4A4CoV9RHoooooooooooo410@00;o000000Coooooo`000?l0003o410@1?ooool01_nHV9So
410@o`000?l@413oEEEEolc<c0Wooooo00KogMgMo`000?l0003o410@oooooomEEED2o`000003omgM
gOoooooooooo00Wooooo00?o410@o`000?l000000_l000000ooMgMgoooooooooo`02ooooo`04ofIV
I_l0003o<S8bonk^kPkooooo00?ogMgMo`000?oMgMd0oooooomMooooo`001_ooool00ol0003ooooo
ooooo`06ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00oooool01omgMgOoEEEE
oooooooooooogMgMob4Q8OmgMgL01?ooool01_l0003oc<c<oooooooMgMgoQhN7ojVYZ@Cooooo00?o
0000ooooooooool00oooool01on7QhOoEEEEonk^k_ooooook^k^oeEEEOm4A4@00oooool01Ol0003o
oooooooooooooooo000000cooooo00OoMgMgoeEEEOooooooooooomgMgOlQ8B7oMgMg00;ooooo00Oo
QhN7oeEEEOo^k^koooooonk^k_mEEEGoA4A400;ooooo00OoMgMgoeEEEOo^k^koooooonk^k_nHV9So
<S8b00Cooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooo
oooo00?ooooo00OoMgMgoeEEEOooooooooooomgMgOlQ8B7oMgMg00Gooooo00?o0000ooooooooool0
0oooool01omgMgOoEEEEonk^k_ooooook^k^oiRHV?lb<S800oooool01Ol0003ooooooooooooooooo
000000Gooooo00Ko0000olc<c?oooooogMgMohN7QonYZJT:ooooo`07onk^k_lQ8B7oV9RHooooooo<
c<co410@olc<c00>ooooo`03o`000?oooooooooo00Cooooo0_n7QhL00oooooooQhN7odA4A00?oooo
o`03oc8b<_n7QhOooooo0?ooooooG?ooool000Kooooo00?o0000ooooooooool01_ooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00?ooooo00?o8B4Qooooooooool02?ooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00?ooooo00?o8B4Qooooooooool00oooool01Ol0003o
gMgMoooooooooooo000000?ooooo00?o0000ooooooooool02_ooool00olQ8B7oooooooooo`06oooo
o`03ob4Q8Ooooooooooo00?ooooo00Go0000omgMgOoooooo0000onk^kP09ooooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`03ooooo`03ob4Q8Ooooooo
oooo00Wooooo00?o0000ooooooooool00oooool00ol0003ok^k^ooooo`07ooooo`05o`000?oooooo
ooooooooool000001Oooool00ol0003oooooooooo`0>ooooo`05onk^k_l@413oV9RHoa0@4?o<c<`0
3oooool00ol0003oooooooooo`04ooooo`05oc8b<_ooooooooooooooool000003oooool00onHV9So
8B4Qooooo`3ooooooecooooo0006ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`03ooooo`03oc8b<_oooooooooo00Sooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`03ooooo`03oc8b<_oooooooooo00?ooooo00Go<S8bokZj^_oooooo
ooooo`000003ooooo`03o`000?oooooooooo00[ooooo00?o<S8booooooooool01_ooool00olb<S;o
ooooooooo`03ooooo`03oc8b<_nj^[[ooooo00Oo000000GogMgMooooooooooooooooo`000008oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00oooool00olb<S;oooooooooo`09oooo
o`03o`000?oooooooooo00?ooooo1ol000001?oMgMgoooooooooool00003ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool03oooool00onj^[[o0000okZj^P0@ooooo`03o`000?oooooo
oooo00Cooooo00Ko<S8boooooooooooooooooc8b<_nj^[X>ooooo`03onk^k_l0003oc<c<0?oooooo
G?ooool000Kooooo00?o0000ooooooooool01_ooool00ol0003oc<c<ooooo`07ooooo`03o`000?oo
oooooooo00?ooooo00?o8B4Qooooooooool00_ooool00omgMgOoV9RHooooo`03ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool00oooool00olQ8B7oooooooooo`03ooooo`05o`000?oM
gMgoooooooooool000000oooool00ol0003oooooooooo`0:ooooo`03ob4Q8Ooooooooooo00;ooooo
00GoMgMgoiRHV?ooooooooooob4Q8@05ooooo`05o`000?oMgMgooooooa0@4?oMgMd00oooool00onH
V9So0000ooooo`03ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`03ooooo`03ob4Q8Ooooooooooo00;ooooo00?oMgMgoiRHV?ooool01?ooool00ol0
003oooooooooo`03ooooo`03oa0@4?oMgMgooooo00;ooooo00?oV9RHo`000?ooool00_ooool01Ol0
003ooooooooooooooooo000000Gooooo00?o0000ooooooooool03_ooool01Oo^k^ko8B4Qoc8b<_lQ
8B7ok^k^00oooooo00?o0000ooooooooool01?ooool01_lb<S;ooooooooooooooooo<S8bokZj^Poo
oooo00?oEEEEofIVI_ooool0oooooomKooooo`001_ooool00ol0003oooooooooo`06ooooo`06o`00
0?lb<S;oV9RHoooooonj^[[ogMgM1?ooool00ol0003oooooooooo`03ooooo`07ogMgMomEEEGok^k^
oooooonj^[[o0000ogMgM`02ooooo`03oa0@4?l0003o000000?o000000?oMgMgooooooooool00ooo
ool00ol0003oooooooooo`03ooooo`05ohN7QomEEEGok^k^ooooooo^k^h00_mEEED3ooooo`05o`00
0?n7QhOooooookZj^_l@41003?ooool01omgMgOoEEEEonk^k_oooooo^[Zjo`000?mgMgL00_ooool0
1On7QhOoEEEEonk^k_ooooook^k^00;oEEEE0_ooool01omgMgOo8B4QomgMgOoooooogMgMoa0@4?mV
IVH01?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool00oooool01omgMgOoEEEEonk^k_oooooo^[Zjo`000?mgMgL01Oooool00ol0003oooooooooo`03
ooooo`07ogMgMolQ8B7ogMgMoooooooMgMgo410@ofIVIP03ooooo`05o`000?n7QhOooooookZj^_l@
41000oooool00ol@413o0000o`000003o`000003ogMgMooooooooooo00[ooooo00KoA4A4oeEEEOoo
ooooV9RHob4Q8Oo^k^h>ooooo`03o`000?oooooooooo00Cooooo00Ko<S8boooooooooooooooooc8b
<_nj^[X?ooooo`03okZj^_l@413ooooo0?ooooooFoooool000Cooooo00?o410@o`000?l000000ol0
00001?o^k^koooooooooool@4102o`000005onk^k_mVIVKo0000o`000?nYZJT00_ooool00ol@413o
0000o`000006ooooo`03ofIVI_l0003o000000;o8B4Q00?oMgMgooooooooool00_ooool00olb<S;o
ooooooooo`05ooooo`03oa0@4?l0003o000000Kooooo00GoQhN7oa0@4?l0003o0000ogMgM`03oooo
o`;o000000CoIVIVo`000?l0003o^[Zj3Oooool00omVIVKo0000o`000002ob4Q8@06ogMgMooooooo
oooooooooon7QhOo410@0_l000000omgMgOoooooooooo`02ooooo`05ogMgMol@413o0000oa0@4?mg
MgL00oooool00ol@413o0000o`000003o`000004onk^k_oooooooooooa0@40Go000000Gok^k^oooo
oooooooooooooa0@4002o`0000Kooooo00?oIVIVo`000?l000000_lQ8B401OmgMgOooooooooooooo
oooo410@00;o00001_ooool01OmgMgOo410@o`000?l@413oMgMg00?ooooo0_l000001?mVIVKo0000
o`000?nj^[X5ooooo`03oc8b<_oooooooooo00gooooo00Co410@o`000?mEEEGooooo0ol000000ooM
gMgoooooooooo`0;ooooo`03o`000?oooooooooo00Cooooo00Go<S8bonk^k_ooooook^k^o`00000A
ooooo`03oa0@4?o<c<cooooo0?ooooooF_ooool000Kooooo00?o0000ooooooooool08Oooool00ol0
003oooooooooo`15ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0<oooool00ol0
003oooooooooo`0Pooooo`03ohN7Qonj^[[o000000Kooooo00GoQhN7ofIVI_ooooooIVIVodA4A004
ooooo`05oc8b<_o^k^koooooonk^k_lb<S802?ooool00on7QhOoIVIVooooo`3ooooooe[ooooo0006
ooooo`03oa0@4?nYZJWooooo027ooooo00?o410@ooooooooool0AOooool00ol@413oZJVYooooo`06
ooooo`03oa0@4?nYZJWooooo03?ooooo00?o410@ooooooooool08?ooool00on7QhOo<S8bo`000007
ooooo`04ofIVI_l0003o<S8bonk^kPCooooo00Goc<c<oc8b<_oMgMgo<S8bolc<c004ooooo`Go0000
00?o<S8booooooooool0oooooomIooooo`001_ooool01Oo<c<co8B4Qo`000?l0003oMgMg00kooooo
00?o0000ogMgMoooool06?ooool00ol0003oMgMgooooo`0kooooo`05olc<c?lQ8B7o0000o`000?mg
MgL01?ooool01Oo<c<co8B4Qo`000?l0003oMgMg00Gooooo00?o0000ogMgMoooool03oooool00ol0
003oMgMgooooo`1=ooooo`03ojVYZOl0003oV9RH0?ooooooI_ooool00?oooooooooooomAooooo`00
oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooo
oe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003o
ooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003ooooooooooooo
DOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oo
oooooooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomA
ooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooo
oooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7o
oooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003ooooo
ooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOoo
ool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooo
oooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAoooo
o`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooo
oooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo
003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003ooooooooo
ooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool0
0?oooooooooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooo
oomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00
oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooo
oe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003o
ooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003ooooooooooooo
DOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oo
oooooooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomA
ooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooo
oooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7o
oooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003ooooo
ooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOoo
ool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooo
oooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAoooo
o`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooo
oooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo
003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003ooooooooo
ooooDOooool00?oooooooooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool0
0?oooooooooooomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooo
oomAooooo`00oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00
oooooooooooooe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00oooooooooooo
oe7ooooo003oooooooooooooDOooool00?oooooooooooomAooooo`00\
\>"],
  ImageRangeCache->{{{0, 590.938}, {590.938, 0}} -> {-120.377, -1.64974, \
1.45031, 0.0175037}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{0, 1440}, {0, 877}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{714, 822},
WindowMargins->{{Automatic, 3}, {1, Automatic}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowSelection->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1.5,
StyleDefinitions -> "Default.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 526, 10, 150, "SmallText"],
Cell[2283, 63, 349, 7, 84, "SmallText"],
Cell[2635, 72, 1098, 19, 487, "Text"],
Cell[3736, 93, 253, 8, 58, "Input",
  PageBreakWithin->Automatic,
  InitializationCell->True],
Cell[3992, 103, 979, 20, 598, "Input",
  InitializationCell->True],
Cell[4974, 125, 979, 28, 638, "Input",
  InitializationCell->True],
Cell[5956, 155, 267, 8, 118, "Input",
  InitializationCell->True],
Cell[6226, 165, 188, 5, 47, "Text"],
Cell[6417, 172, 209, 6, 78, "Input"],
Cell[6629, 180, 195, 3, 47, "Text"],
Cell[6827, 185, 304, 8, 118, "Input"],

Cell[CellGroupData[{
Cell[7156, 197, 147, 3, 38, "Input"],
Cell[7306, 202, 238, 4, 64, "Output"]
}, Open  ]],
Cell[7559, 209, 110, 2, 39, "Input"],
Cell[7672, 213, 205, 5, 53, "Text"],

Cell[CellGroupData[{
Cell[7902, 222, 746, 32, 618, "Input"],
Cell[8651, 256, 177, 3, 34, "Print"],
Cell[8831, 261, 44, 1, 34, "Print"],
Cell[8878, 264, 76, 1, 34, "Print"],
Cell[8957, 267, 341, 8, 56, "Print"],
Cell[9301, 277, 48, 1, 34, "Print"],
Cell[9352, 280, 76, 1, 34, "Print"],
Cell[9431, 283, 341, 8, 56, "Print"],
Cell[9775, 293, 177, 3, 34, "Print"],
Cell[9955, 298, 44, 1, 34, "Print"],
Cell[10002, 301, 76, 1, 34, "Print"],
Cell[10081, 304, 340, 8, 56, "Print"],
Cell[10424, 314, 48, 1, 34, "Print"],
Cell[10475, 317, 76, 1, 34, "Print"],
Cell[10554, 320, 341, 8, 56, "Print"],
Cell[10898, 330, 176, 3, 34, "Print"],
Cell[11077, 335, 44, 1, 34, "Print"],
Cell[11124, 338, 76, 1, 34, "Print"],
Cell[11203, 341, 341, 8, 56, "Print"],
Cell[11547, 351, 48, 1, 34, "Print"],
Cell[11598, 354, 76, 1, 34, "Print"],
Cell[11677, 357, 341, 8, 56, "Print"],
Cell[12021, 367, 178, 3, 34, "Print"],
Cell[12202, 372, 44, 1, 34, "Print"],
Cell[12249, 375, 76, 1, 34, "Print"],
Cell[12328, 378, 341, 8, 56, "Print"],
Cell[12672, 388, 48, 1, 34, "Print"],
Cell[12723, 391, 76, 1, 34, "Print"],
Cell[12802, 394, 339, 8, 56, "Print"],
Cell[13144, 404, 178, 3, 34, "Print"],
Cell[13325, 409, 44, 1, 34, "Print"],
Cell[13372, 412, 76, 1, 34, "Print"],
Cell[13451, 415, 341, 8, 56, "Print"],
Cell[13795, 425, 48, 1, 34, "Print"],
Cell[13846, 428, 76, 1, 34, "Print"],
Cell[13925, 431, 339, 8, 56, "Print"],
Cell[14267, 441, 177, 3, 34, "Print"],
Cell[14447, 446, 44, 1, 34, "Print"],
Cell[14494, 449, 76, 1, 34, "Print"],
Cell[14573, 452, 339, 8, 56, "Print"],
Cell[14915, 462, 48, 1, 34, "Print"],
Cell[14966, 465, 76, 1, 34, "Print"],
Cell[15045, 468, 340, 8, 56, "Print"],
Cell[15388, 478, 178, 3, 34, "Print"],
Cell[15569, 483, 44, 1, 34, "Print"],
Cell[15616, 486, 76, 1, 34, "Print"],
Cell[15695, 489, 339, 8, 56, "Print"],
Cell[16037, 499, 48, 1, 34, "Print"],
Cell[16088, 502, 76, 1, 34, "Print"],
Cell[16167, 505, 339, 8, 56, "Print"],
Cell[16509, 515, 178, 3, 34, "Print"],
Cell[16690, 520, 44, 1, 34, "Print"],
Cell[16737, 523, 76, 1, 34, "Print"],
Cell[16816, 526, 338, 8, 56, "Print"],
Cell[17157, 536, 48, 1, 34, "Print"],
Cell[17208, 539, 76, 1, 34, "Print"],
Cell[17287, 542, 340, 8, 56, "Print"],
Cell[17630, 552, 177, 3, 34, "Print"],
Cell[17810, 557, 44, 1, 34, "Print"],
Cell[17857, 560, 76, 1, 34, "Print"],
Cell[17936, 563, 338, 8, 56, "Print"],
Cell[18277, 573, 48, 1, 34, "Print"],
Cell[18328, 576, 76, 1, 34, "Print"],
Cell[18407, 579, 340, 8, 56, "Print"]
}, Open  ]],
Cell[18762, 590, 571, 11, 175, "Text"],

Cell[CellGroupData[{
Cell[19358, 605, 173, 4, 85, "Input"],
Cell[19534, 611, 1447, 35, 411, "Output"]
}, Open  ]],
Cell[20996, 649, 287, 6, 109, "Input"],
Cell[21286, 657, 282, 7, 97, "Text"],
Cell[21571, 666, 65846, 902, 543, 8954, 193, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False],
Cell[87420, 1570, 205, 5, 53, "Text"],
Cell[87628, 1577, 333, 6, 105, "Text"],

Cell[CellGroupData[{
Cell[87986, 1587, 901, 37, 738, "Input"],
Cell[88890, 1626, 177, 3, 34, "Print"],
Cell[89070, 1631, 44, 1, 34, "Print"],
Cell[89117, 1634, 76, 1, 34, "Print"],
Cell[89196, 1637, 341, 8, 56, "Print"],
Cell[89540, 1647, 48, 1, 34, "Print"],
Cell[89591, 1650, 76, 1, 34, "Print"],
Cell[89670, 1653, 341, 8, 56, "Print"],
Cell[90014, 1663, 177, 3, 34, "Print"],
Cell[90194, 1668, 44, 1, 34, "Print"],
Cell[90241, 1671, 76, 1, 34, "Print"],
Cell[90320, 1674, 340, 8, 56, "Print"],
Cell[90663, 1684, 48, 1, 34, "Print"],
Cell[90714, 1687, 76, 1, 34, "Print"],
Cell[90793, 1690, 336, 8, 56, "Print"],
Cell[91132, 1700, 176, 3, 34, "Print"],
Cell[91311, 1705, 44, 1, 34, "Print"],
Cell[91358, 1708, 76, 1, 34, "Print"],
Cell[91437, 1711, 339, 8, 56, "Print"],
Cell[91779, 1721, 48, 1, 34, "Print"],
Cell[91830, 1724, 76, 1, 34, "Print"],
Cell[91909, 1727, 340, 8, 56, "Print"],
Cell[92252, 1737, 178, 3, 34, "Print"],
Cell[92433, 1742, 44, 1, 34, "Print"],
Cell[92480, 1745, 76, 1, 34, "Print"],
Cell[92559, 1748, 341, 8, 56, "Print"],
Cell[92903, 1758, 48, 1, 34, "Print"],
Cell[92954, 1761, 76, 1, 34, "Print"],
Cell[93033, 1764, 340, 8, 56, "Print"],
Cell[93376, 1774, 178, 3, 34, "Print"],
Cell[93557, 1779, 44, 1, 34, "Print"],
Cell[93604, 1782, 76, 1, 34, "Print"],
Cell[93683, 1785, 340, 8, 56, "Print"],
Cell[94026, 1795, 48, 1, 34, "Print"],
Cell[94077, 1798, 76, 1, 34, "Print"],
Cell[94156, 1801, 341, 8, 56, "Print"],
Cell[94500, 1811, 177, 3, 34, "Print"],
Cell[94680, 1816, 44, 1, 34, "Print"],
Cell[94727, 1819, 76, 1, 34, "Print"],
Cell[94806, 1822, 339, 8, 56, "Print"],
Cell[95148, 1832, 48, 1, 34, "Print"],
Cell[95199, 1835, 76, 1, 34, "Print"],
Cell[95278, 1838, 337, 8, 56, "Print"],
Cell[95618, 1848, 178, 3, 34, "Print"],
Cell[95799, 1853, 44, 1, 34, "Print"],
Cell[95846, 1856, 76, 1, 34, "Print"],
Cell[95925, 1859, 338, 8, 56, "Print"],
Cell[96266, 1869, 48, 1, 34, "Print"],
Cell[96317, 1872, 76, 1, 34, "Print"],
Cell[96396, 1875, 340, 8, 56, "Print"],
Cell[96739, 1885, 178, 3, 34, "Print"],
Cell[96920, 1890, 44, 1, 34, "Print"],
Cell[96967, 1893, 76, 1, 34, "Print"],
Cell[97046, 1896, 341, 8, 56, "Print"],
Cell[97390, 1906, 48, 1, 34, "Print"],
Cell[97441, 1909, 76, 1, 34, "Print"],
Cell[97520, 1912, 340, 8, 56, "Print"],
Cell[97863, 1922, 177, 3, 34, "Print"],
Cell[98043, 1927, 44, 1, 34, "Print"],
Cell[98090, 1930, 76, 1, 34, "Print"],
Cell[98169, 1933, 339, 8, 56, "Print"],
Cell[98511, 1943, 48, 1, 34, "Print"],
Cell[98562, 1946, 76, 1, 34, "Print"],
Cell[98641, 1949, 340, 8, 56, "Print"]
}, Open  ]],
Cell[98996, 1960, 571, 11, 175, "Text"],

Cell[CellGroupData[{
Cell[99592, 1975, 186, 5, 58, "Input"],
Cell[99781, 1982, 1445, 35, 411, "Output"]
}, Open  ]],
Cell[101241, 2020, 287, 6, 109, "Input"],
Cell[101531, 2028, 291, 7, 97, "Text"],
Cell[101825, 2037, 65559, 899, 543, 8946, 193, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False],
Cell[167387, 2938, 468, 10, 149, "Text"],

Cell[CellGroupData[{
Cell[167880, 2952, 1104, 29, 702, "Input",
  InitializationCell->True],
Cell[168987, 2983, 62205, 1320, 604, 9575, 666, "GraphicsData", "PostScript", \
"Graphics"],
Cell[231195, 4305, 130, 3, 40, "Output"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

