(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    124827,       3020]
NotebookOptionsPosition[    102223,       2742]
NotebookOutlinePosition[    102874,       2767]
CellTagsIndexPosition[    102831,       2764]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "CHR started 18 Feb 2020. Test of reproducibility for the ReScience 10-year \
reproducibility challenge (https://rescience.github.io/ten-years/). Chosen \
paper is Robert, C.H. (1995) Estimating Friction Coefficients of Mixed \
Globular/Chain Molecules, such as Protein/DNA Complexes. Biophys J. 69, \
840-48.\n\nAll code in this file came from the original notebook \"Example 3 \
3x208.nb\" and was run using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " versions 5.2 and 12.0.\nChanges:\n- added dependence on library \
s6.1_repro.m\n- added dependence on additional routines I had written in \
other libraries and gathered into \"extra.m\"\n- removed terminal semicolons \
to see graphical output"
}], "Text",
 CellFrame->True,
 InitializationCell->True,
 FontColor->RGBColor[0, 0, 1],
 Background->GrayLevel[
  0.833326],ExpressionUUID->"4395c488-107e-4ad3-a23d-de7f84ef685a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Get", "[", 
   RowBox[{"\"\<ReScience/\>\"", "<>", "\"\<s6.1_repro.m\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Get", "[", 
   RowBox[{"\"\<ReScience/\>\"", "<>", "\"\<extra.m\>\""}], "]"}], 
  ";"}]}], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"4ed2792d-9bd3-49da-8ab2-4888e1d3c66f"],

Cell["\<\
Off[General::spell];
Off[General::spell1];\
\>", "Input",
 PageBreakWithin->Automatic,
 GroupPageBreakWithin->Automatic,
 InitializationCell->True,
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[3]:=",ExpressionUUID->"f08b2882-2bf3-47da-9f86-2fbf65286844"],

Cell[CellGroupData[{

Cell["\<\
Hydro MS Example 3: Vary nucleosome placements on template: 1.75 turns\
\>", "Subsubsection",
 ImageRegion->{{0, 1}, {0, 
  1}},ExpressionUUID->"7fa35ed6-7d93-41e1-bfdb-5d3b93f1230d"],

Cell["\<\
Here are the calculations for the examples given in my paper for a chromatin \
saturation process. A trimer of positioning sites is envisioned, and the \
frictional properties of all possible species are calculated. Since when I \
did these I hadn't yet reactivated the sedimentation coefficient subroutine, \
I calculate all the sedimentation coefficients all at the end.\
\>", "Text",
 ImageRegion->{{0, 1}, {0, 
  1}},ExpressionUUID->"9b2ee285-ce70-41d7-ab50-fe22f9016d3c"],

Cell["\<\
First clear the randomizing orientation matrix so that all of the chain \
pictures will be aligned in the same coordinate system.\
\>", "Text",
 ImageRegion->{{0, 1}, {0, 
  1}},ExpressionUUID->"0e9665a1-362a-4319-bd3c-b1ae4a7bccc1"],

Cell["\<\
ClearAll[A0];
A0=IdentityMatrix[3];\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[5]:=",ExpressionUUID->"e9dad861-7470-42d9-bfa6-2871a5ee526a"],

Cell["\<\
Define the chain and the nucleosomes for this example. Default parameters \
include persistence length of 150 bp.\
\>", "Text",
 ImageRegion->{{0, 1}, {0, 
  1}},ExpressionUUID->"3930d682-a671-4fee-becb-ea92bf0f3f61"],

Cell[CellGroupData[{

Cell["\<\
turns=1.75;
definebasepair;
definenuke;
definephysicalnuke;
chaininitialize;
wrapbp\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[7]:=",ExpressionUUID->"5e42c659-122b-4f9f-9720-ad9095434504"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n = \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" ; dl = \"\>", "\[InvisibleSpace]", 
   "24.51185724694005`"}],
  SequenceForm["n = ", 20, " ; dl = ", 24.51185724694005],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125617148*^9, 3.8001927422098637`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"f0d5c03d-7bab-4e65-bde0-37fe81a26981"],

Cell[BoxData["146"], "Output",
 CellChangeTimes->{3.794913125636505*^9, 3.800192742216257*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"e4075db1-46d0-4333-93d2-8303b4fbb7de"]
}, Open  ]],

Cell["\<\
Now define a couple of things to make the example easier to do. The DNA chain \
is of length template (bp), and there are nnukes nucleosomes on it. The \
nucleosomes begin and end the chain. The linker length in bp is calculated, \
and the \"chain\" defined.  Remember that the chain of segments includes one \
segment for each free basepair (the linker) and one segment for each \
nucleosome.\
\>", "Text",
 ImageRegion->{{0, 1}, {0, 
  1}},ExpressionUUID->"8f0f56c8-3c72-495e-9edd-484fe897c1b9"],

Cell["ntemplate=624;\t\t\t(* total length, bp *)", "Input",
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[13]:=",ExpressionUUID->"462bea87-c9e2-4eee-a0f8-e8fa1f2d17f9"],

Cell[CellGroupData[{

Cell["\<\
species={{1},{2},{3},{1,2},{1,3},{2,3},{1,2,3}};
nt[spots_]:=ntemplate - Length[spots] wrapbp + Length[spots];
Map[nt,species]\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[14]:=",ExpressionUUID->"cb93d1fa-4a75-4a3c-8d7a-1da163fd72a4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "479", ",", "479", ",", "479", ",", "334", ",", "334", ",", "334", ",", 
   "189"}], "}"}]], "Output",
 CellChangeTimes->{3.794913125775825*^9, 3.800192742404718*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"fe254ca5-a6cf-495b-a4ca-abf900ffcf09"]
}, Open  ]],

Cell["\<\
chain={\t{479,{1}},
\t\t{479,{209}},
\t\t{479,{417}},
\t\t{334,{1,64}},
\t\t{334,{1,272}},
\t\t{334,{209,272}},
\t\t{189,{1,64,127}}\t};\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[17]:=",ExpressionUUID->"feb75349-28d4-4223-a028-710b0067f4b2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"persistence", "=", 
   RowBox[{"150", " ", "el0"}]}], ";"}], "\n", 
 RowBox[{"definebasepair", ";"}]}], "Input",
 CellLabel->"In[18]:=",ExpressionUUID->"2a13c0cf-b8ac-45a7-aa83-1e9028272846"],

Cell["\<\
collective=True;
test=True;
progress=True;
montecarlo=False;\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[20]:=",ExpressionUUID->"2b92c31c-c934-4219-a5e1-86f523c56f05"],

Cell[CellGroupData[{

Cell["\<\
Do[\tassembleelements[chain[[isp]]];
\tmakeAs[chain[[isp]]];
\tdoKirkwood[chain[[isp]]],
{isp,Length[species]}];\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[24]:=",ExpressionUUID->"c89b7b0a-7e39-4194-bde8-dcdd7c05f5de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Chain of \"\>", "\[InvisibleSpace]", "479", 
   "\[InvisibleSpace]", "\<\" segments,\"\>"}],
  SequenceForm["Chain of ", 479, " segments,"],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192742688122*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"77775a1b-4902-452a-98b3-bb873c31588d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"with displacements at segments \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "1", "}"}]}],
  SequenceForm["with displacements at segments ", {1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192742693376*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"fdf95070-4323-4477-b0e3-7631c4664774"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Stokes offset \"\>", "\[InvisibleSpace]", 
   "3.0076424054539217`", "\[InvisibleSpace]", "\<\" A at \"\>", 
   "\[InvisibleSpace]", "50", "\[InvisibleSpace]", "\<\" bp\"\>"}],
  SequenceForm["Stokes offset ", 3.0076424054539217`, " A at ", 50, " bp"],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192742697145*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"3c25bacb-284b-4341-876d-1fab365a225d"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
     {"\<\"persistence\\nlength\"\>", "510.`", "\<\"A\"\>"},
     {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
     {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
     {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
     {"\<\"turns\"\>", "1.75`", "\<\"turns\"\>"},
     {"\<\"pitch\"\>", 
      RowBox[{"-", "28.571`"}], "\<\"A/turn\"\>"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192742788497*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"807f1935-1d2b-436b-aa41-dc3307fd1ea4"],

Cell[BoxData["\<\"Array of chain lengths (bp)\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192742853232*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"af28771c-7db4-4927-8958-b7366262ebc9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "478"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192742857757*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"4975ea1b-836c-4525-907e-c95b3efc555a"],

Cell[BoxData["\<\"Array of friction element positions (bp)\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927428615313`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"c3251801-a793-4299-93b9-14382161f2cc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "240"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192742865315*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"3220305c-6b4f-4a0f-8c9a-ed44ba5c1832"],

Cell[BoxData["\<\"Array of Stokes radii (A)\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927428687572`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"4fd2537f-65e6-4ea4-a529-b8a6a6d6045a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"56.81238789104189`", ",", "163.0216893780777`"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927428732777`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"b3a3aadf-db05-45eb-832d-d45437baae3d"],

Cell[BoxData["\<\"...doKirkwood...\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927428767967`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"e00e72e5-4664-4dca-95c2-8f96c98da9e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "645.8155571508559`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "610.4217021660207`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 2, " ", 645.8155571508559, " corrected:", 
   610.4217021660207],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927428809757`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"4b967d0d-76e1-43f0-8759-bbe37ee45006"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"np\"\>", ",", "\<\"nchain\"\>", ",", "\<\"mass1\"\>", 
   ",", "\<\"vbar1\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927428852453`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"9a562779-2e96-4f3b-9dfb-7a6e792b2166"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"479", ",", 
     RowBox[{"{", "1", "}"}]}], "}"}], ",", "624", ",", "520340", ",", 
   "0.5917035015566745`"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192742890037*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"3920a314-0e9a-4974-aa55-9e45df69a950"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1,s1}\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192742893941*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"3d8037b0-6749-4c50-89ad-3e3a786ed123"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"4.2100751286712484`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"3.699420629960029`*^-7", " ", "g"}], "s"], ",", 
     RowBox[{"9.498180247177795`*^-13", " ", "s"}]}], "}"}]}],
  SequenceForm[
  "   ", {4.2100751286712484`*^-7 $CellContext`g/$CellContext`s, 
    3.699420629960029*^-7 $CellContext`g/$CellContext`s, 
    9.498180247177795*^-13 $CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.80019274289812*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"48081bd0-4842-46ff-bb8b-5afdb9737153"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Chain of \"\>", "\[InvisibleSpace]", "479", 
   "\[InvisibleSpace]", "\<\" segments,\"\>"}],
  SequenceForm["Chain of ", 479, " segments,"],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192742902961*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"0de99b6c-4f83-4518-be33-8deaedec142e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"with displacements at segments \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "209", "}"}]}],
  SequenceForm["with displacements at segments ", {209}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192742907609*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"480d27b8-ecc1-44f0-a0bb-1c2372ca31f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Stokes offset \"\>", "\[InvisibleSpace]", 
   "3.0076424054539217`", "\[InvisibleSpace]", "\<\" A at \"\>", 
   "\[InvisibleSpace]", "50", "\[InvisibleSpace]", "\<\" bp\"\>"}],
  SequenceForm["Stokes offset ", 3.0076424054539217`, " A at ", 50, " bp"],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192742911862*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"0f87c008-2400-4828-837f-07ffdab73e2f"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
     {"\<\"persistence\\nlength\"\>", "510.`", "\<\"A\"\>"},
     {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
     {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
     {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
     {"\<\"turns\"\>", "1.75`", "\<\"turns\"\>"},
     {"\<\"pitch\"\>", 
      RowBox[{"-", "28.571`"}], "\<\"A/turn\"\>"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.80019274291648*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"131e96a6-042a-4658-b0d8-65d3ab4b1937"],

Cell[BoxData["\<\"Array of chain lengths (bp)\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.80019274292278*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"94026f0c-97d5-472b-a9af-02f356bebe57"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"208", ",", "270"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927429268007`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"1fea4c55-70ae-461a-88d3-5a0f143c73e3"],

Cell[BoxData["\<\"Array of friction element positions (bp)\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192742930408*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"11e7ac0d-8b5b-4d33-87f6-d7d35ee3745d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"104", ",", "209", ",", "344"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192742934267*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"9404d6b1-40c2-4a12-9ac4-ec724ab94094"],

Cell[BoxData["\<\"Array of Stokes radii (A)\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192742938383*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"b7fc53cb-4e18-4a6e-80d3-03d5cbb77933"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "89.9681832769593`", ",", "56.81238789104189`", ",", 
   "108.17184797520562`"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927429425097`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"17014da0-7a8d-42c9-8bcf-a89c4a1ffecd"],

Cell[BoxData["\<\"...doKirkwood...\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192742946134*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"2762943c-0543-4b39-af90-80b5a5c802f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "324.43031401801034`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "320.1594381327741`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 2, " ", 324.43031401801034`, " corrected:", 
   320.1594381327741],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927429502373`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"c3a5dd7b-32be-4e85-b473-634b0656bcb9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "472.9184509146817`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "446.831193475157`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 3, " ", 472.9184509146817, " corrected:", 
   446.831193475157],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192743367298*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"da3bc4b2-66c1-4df5-9d68-0479e63967c5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "403.0334189559262`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "394.63833091738644`"}],
  SequenceForm[
  "i,j,rij:", "*", 2, " ", 3, " ", 403.0334189559262, " corrected:", 
   394.63833091738644`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192743451198*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"b06b8416-4261-49ac-a3db-86557fe6cab5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"np\"\>", ",", "\<\"nchain\"\>", ",", "\<\"mass1\"\>", 
   ",", "\<\"vbar1\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192743518484*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"fde27f5d-1acd-410a-93a8-f14a41663fb2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"479", ",", 
     RowBox[{"{", "209", "}"}]}], "}"}], ",", "624", ",", "520340", ",", 
   "0.5917035015566745`"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927435237703`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"424b3f3e-f61b-445f-bf64-b9b9fc531d36"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1,s1}\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192743528054*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"7e963c71-5845-469c-8180-2c5faa462790"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"4.88263172008301`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"3.442705591770239`*^-7", " ", "g"}], "s"], ",", 
     RowBox[{"1.0206438807165194`*^-12", " ", "s"}]}], "}"}]}],
  SequenceForm[
  "   ", {4.88263172008301*^-7 $CellContext`g/$CellContext`s, 
    3.442705591770239*^-7 $CellContext`g/$CellContext`s, 
    1.0206438807165194`*^-12 $CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192743532751*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"22169333-a59e-440e-b39d-a49c4c6d451c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Chain of \"\>", "\[InvisibleSpace]", "479", 
   "\[InvisibleSpace]", "\<\" segments,\"\>"}],
  SequenceForm["Chain of ", 479, " segments,"],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192743538196*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"0670e2c8-b114-42ac-a3f0-9b315a5f0841"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"with displacements at segments \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "417", "}"}]}],
  SequenceForm["with displacements at segments ", {417}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192743543021*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"0a66d10f-9e5f-41f4-9ce5-f2cfad89af7a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Stokes offset \"\>", "\[InvisibleSpace]", 
   "3.0076424054539217`", "\[InvisibleSpace]", "\<\" A at \"\>", 
   "\[InvisibleSpace]", "50", "\[InvisibleSpace]", "\<\" bp\"\>"}],
  SequenceForm["Stokes offset ", 3.0076424054539217`, " A at ", 50, " bp"],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192743547374*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"ed1df9f3-614b-42df-9a54-e41ac3c88660"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
     {"\<\"persistence\\nlength\"\>", "510.`", "\<\"A\"\>"},
     {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
     {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
     {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
     {"\<\"turns\"\>", "1.75`", "\<\"turns\"\>"},
     {"\<\"pitch\"\>", 
      RowBox[{"-", "28.571`"}], "\<\"A/turn\"\>"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192743552484*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"2f212b49-46a3-40f5-8987-1484b0dd88d5"],

Cell[BoxData["\<\"Array of chain lengths (bp)\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192743559273*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"ea57b51b-654d-43d7-b2c1-5091bf4d136a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"416", ",", "62"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192743563587*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"19dc9257-8fb6-4981-95d0-9539fdbaa9bd"],

Cell[BoxData["\<\"Array of friction element positions (bp)\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192743567492*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"60415385-7987-4adf-ba42-2ffc1fd522bd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"208", ",", "417", ",", "448"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192743572246*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"61c2aa1a-ae6f-4127-9a25-d625186ca78f"],

Cell[BoxData["\<\"Array of Stokes radii (A)\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927435763903`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"01f7a6a5-c0b3-411f-9d45-f986d1dde8cd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "147.48346391059283`", ",", "56.81238789104189`", ",", 
   "40.885858384248856`"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192743580741*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"d99b793e-17b9-4b46-8bfc-1f0cc4aaa4d1"],

Cell[BoxData["\<\"...doKirkwood...\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.80019274358486*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"dd99ca9b-3bf3-4c11-b665-db3488ed15b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "580.1828562491935`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "554.5140033133057`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 2, " ", 580.1828562491935, " corrected:", 
   554.5140033133057],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927435900393`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"87552ecd-fc53-41b5-a2e0-6de88e599e3a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "558.289936859844`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "527.4933940719919`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 3, " ", 558.289936859844, " corrected:", 
   527.4933940719919],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927448075666`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"983086bd-3fdf-4612-ae19-063c6738e559"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "114.66687786172504`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "114.51956364643796`"}],
  SequenceForm[
  "i,j,rij:", "*", 2, " ", 3, " ", 114.66687786172504`, " corrected:", 
   114.51956364643796`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192744813593*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"60676d84-2ef0-402d-a892-9b18f96f2f0c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"np\"\>", ",", "\<\"nchain\"\>", ",", "\<\"mass1\"\>", 
   ",", "\<\"vbar1\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192744819063*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"37756874-d785-4269-b2d0-e28b1e1c43e0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"479", ",", 
     RowBox[{"{", "417", "}"}]}], "}"}], ",", "624", ",", "520340", ",", 
   "0.5917035015566745`"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192744823784*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"f3cbd045-d02f-4350-8729-1d908fb10b62"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1,s1}\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192744828595*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"88bf1846-9c21-4af6-a9c6-126887936fac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"4.6955114188007187`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"3.3977162729210837`*^-7", " ", "g"}], "s"], ",", 
     RowBox[{"1.0341582737065845`*^-12", " ", "s"}]}], "}"}]}],
  SequenceForm[
  "   ", {4.6955114188007187`*^-7 $CellContext`g/$CellContext`s, 
    3.3977162729210837`*^-7 $CellContext`g/$CellContext`s, 
    1.0341582737065845`*^-12 $CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192744833592*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"333933c8-5785-4bdc-9d16-3616a67a39a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Chain of \"\>", "\[InvisibleSpace]", "334", 
   "\[InvisibleSpace]", "\<\" segments,\"\>"}],
  SequenceForm["Chain of ", 334, " segments,"],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192744838687*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"7d8bb3cf-877d-461f-bfbe-ca7761a40bdf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"with displacements at segments \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "64"}], "}"}]}],
  SequenceForm["with displacements at segments ", {1, 64}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192744843412*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"fae4dabc-43b3-401d-a52b-9d6115cb1dd9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Stokes offset \"\>", "\[InvisibleSpace]", 
   "3.0076424054539217`", "\[InvisibleSpace]", "\<\" A at \"\>", 
   "\[InvisibleSpace]", "50", "\[InvisibleSpace]", "\<\" bp\"\>"}],
  SequenceForm["Stokes offset ", 3.0076424054539217`, " A at ", 50, " bp"],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192744848837*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"f07e16bd-e9fa-4e5b-9663-899394b28ac1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
     {"\<\"persistence\\nlength\"\>", "510.`", "\<\"A\"\>"},
     {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
     {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
     {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
     {"\<\"turns\"\>", "1.75`", "\<\"turns\"\>"},
     {"\<\"pitch\"\>", 
      RowBox[{"-", "28.571`"}], "\<\"A/turn\"\>"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192744853993*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"5a3048d9-4582-4d46-a965-7f0aa999d7a4"],

Cell[BoxData["\<\"Array of chain lengths (bp)\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192744859988*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"4d06a514-63d7-42e5-8fab-c00f50cc5a5f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "62", ",", "270"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192744864842*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"87c89a74-4f4c-4155-ab84-995345f75bde"],

Cell[BoxData["\<\"Array of friction element positions (bp)\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192744868853*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"8e572136-385d-4c42-a178-b55418b26596"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "32", ",", "64", ",", "199"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927448730173`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"756e7de3-42a2-491f-8bac-5ddb2eb467d8"],

Cell[BoxData["\<\"Array of Stokes radii (A)\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927448771257`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"2977c7f7-5763-4b47-9383-bc86e680d8fd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "56.81238789104189`", ",", "40.885858384248856`", ",", "56.81238789104189`",
    ",", "108.17184797520562`"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927448818808`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"8f4501d0-ba0f-4694-b31f-0fc64f8e3a34"],

Cell[BoxData["\<\"...doKirkwood...\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192744885783*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"4810fcdc-c4e7-49ae-ba1e-d28c1855dd3e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "114.66687786172504`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "114.51956364643796`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 2, " ", 114.66687786172504`, " corrected:", 
   114.51956364643796`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192744890191*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"aeafc14e-fcf8-48fa-bc0f-6a9c023e3045"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "216.18081933111512`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "215.09375144101062`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 3, " ", 216.18081933111512`, " corrected:", 
   215.09375144101062`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192744895801*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"5a59ffc3-adf9-4c7a-891a-02f46fca7e7f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "389.4119092049929`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "373.6500147841259`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 4, " ", 389.4119092049929, " corrected:", 
   373.6500147841259],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192745133453*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"118961cc-b57b-46bb-94d4-53ea94735fc0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "117.62366420737646`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "117.46298054434494`"}],
  SequenceForm[
  "i,j,rij:", "*", 2, " ", 3, " ", 117.62366420737646`, " corrected:", 
   117.46298054434494`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927451387577`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"3e2c3615-337b-4d9d-8191-3ac658acc105"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "380.3077621656541`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "368.77534320017975`"}],
  SequenceForm[
  "i,j,rij:", "*", 2, " ", 4, " ", 380.3077621656541, " corrected:", 
   368.77534320017975`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192745277001*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"98abfd8e-42ad-4ca7-9c55-5d35c9879693"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "403.0334189559262`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "394.63833091738644`"}],
  SequenceForm[
  "i,j,rij:", "*", 3, " ", 4, " ", 403.0334189559262, " corrected:", 
   394.63833091738644`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192745372857*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"1f853aad-dfa7-4f9e-bcfb-9b7dd0f770f2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"np\"\>", ",", "\<\"nchain\"\>", ",", "\<\"mass1\"\>", 
   ",", "\<\"vbar1\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192745428549*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"4e9cad3a-cc0e-4a32-8d79-c178fabe2c0c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"334", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "64"}], "}"}]}], "}"}], ",", "624", ",", "628840", 
   ",", "0.6190159659054768`"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927454336367`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"7934a0f2-9982-4c82-acd5-2d730322e6db"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1,s1}\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927454381733`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"81f0e7d1-cafe-454a-827c-deaee47edaf1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"5.0306713069233`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"2.867550387439596`*^-7", " ", "g"}], "s"], ",", 
     RowBox[{"1.3810751418654742`*^-12", " ", "s"}]}], "}"}]}],
  SequenceForm[
  "   ", {5.0306713069233*^-7 $CellContext`g/$CellContext`s, 
    2.867550387439596*^-7 $CellContext`g/$CellContext`s, 
    1.3810751418654742`*^-12 $CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927454435883`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"47567e48-48e0-4371-815f-824930db18ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Chain of \"\>", "\[InvisibleSpace]", "334", 
   "\[InvisibleSpace]", "\<\" segments,\"\>"}],
  SequenceForm["Chain of ", 334, " segments,"],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.80019274544893*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"c8088a6b-7626-469a-8d64-d1ce5cb85c78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"with displacements at segments \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "272"}], "}"}]}],
  SequenceForm["with displacements at segments ", {1, 272}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192745453302*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"35b27229-61fc-4a1a-b93e-18bc45783f61"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Stokes offset \"\>", "\[InvisibleSpace]", 
   "3.0076424054539217`", "\[InvisibleSpace]", "\<\" A at \"\>", 
   "\[InvisibleSpace]", "50", "\[InvisibleSpace]", "\<\" bp\"\>"}],
  SequenceForm["Stokes offset ", 3.0076424054539217`, " A at ", 50, " bp"],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927454580593`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"20b5c476-5eb0-40cd-b941-d86c22d40c60"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
     {"\<\"persistence\\nlength\"\>", "510.`", "\<\"A\"\>"},
     {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
     {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
     {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
     {"\<\"turns\"\>", "1.75`", "\<\"turns\"\>"},
     {"\<\"pitch\"\>", 
      RowBox[{"-", "28.571`"}], "\<\"A/turn\"\>"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192745463065*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"1d0f4db5-92e4-4860-84c2-41d36974ccdc"],

Cell[BoxData["\<\"Array of chain lengths (bp)\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192745469046*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"b5329933-fa93-47ef-b7ca-e3fe60f94ab2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "270", ",", "62"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192745473146*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"36bd2fc4-1b23-4ada-8b05-f0f6efb2faae"],

Cell[BoxData["\<\"Array of friction element positions (bp)\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192745477222*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"7ff7fb59-3e83-49b9-a98e-6dcc03ae9ccf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "136", ",", "272", ",", "303"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192745481653*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"03e18cea-68fb-47c0-83ef-d6dc2311800f"],

Cell[BoxData["\<\"Array of Stokes radii (A)\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.80019274548543*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"c8200b04-9840-4294-9ebb-97ddd6ebaba6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "56.81238789104189`", ",", "108.17184797520562`", ",", "56.81238789104189`",
    ",", "40.885858384248856`"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192745489707*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"5a44317e-4ac4-4f4a-90e8-a039456e246a"],

Cell[BoxData["\<\"...doKirkwood...\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927454940157`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"16e8d1ec-6885-443b-a128-49cb96763f1c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "403.0334189559262`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "394.63833091738644`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 2, " ", 403.0334189559262, " corrected:", 
   394.63833091738644`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192745498663*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"29819909-cc93-47f1-9593-615435ffddfc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "715.0896873239398`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "667.6613839236503`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 3, " ", 715.0896873239398, " corrected:", 
   667.6613839236503],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192745503633*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"2790aad0-4fa5-46bf-b18d-9da696116d86"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "692.2355887402933`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "638.5842332995603`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 4, " ", 692.2355887402933, " corrected:", 
   638.5842332995603],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192747566296*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"c85f88e3-d90a-40aa-93ae-7fe4bd0397f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "405.636231573881`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "397.07418637837964`"}],
  SequenceForm[
  "i,j,rij:", "*", 2, " ", 3, " ", 405.636231573881, " corrected:", 
   397.07418637837964`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192747647097*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"2f4ffbeb-9230-4e8c-ba22-55ce4bc481f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "382.27903461744233`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "370.6868389603757`"}],
  SequenceForm[
  "i,j,rij:", "*", 2, " ", 4, " ", 382.27903461744233`, " corrected:", 
   370.6868389603757],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927479262323`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"c059e918-0715-46c9-bf3d-078f2fc9767c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "114.66687786172504`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "114.51956364643796`"}],
  SequenceForm[
  "i,j,rij:", "*", 3, " ", 4, " ", 114.66687786172504`, " corrected:", 
   114.51956364643796`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192747932391*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"14353727-8b3f-4e07-90f4-56367511ef16"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"np\"\>", ",", "\<\"nchain\"\>", ",", "\<\"mass1\"\>", 
   ",", "\<\"vbar1\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192747937325*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"d97bb84f-66ed-43e1-a14a-301b35584db5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"334", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "272"}], "}"}]}], "}"}], ",", "624", ",", "628840", 
   ",", "0.6190159659054768`"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.80019274794219*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"64662844-565f-411e-a67b-41b4a7dcb878"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1,s1}\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192747946784*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"6110f28a-9685-41f8-a006-74af3431b827"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"5.0306713069233`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"3.253621026145971`*^-7", " ", "g"}], "s"], ",", 
     RowBox[{"1.2171984771166338`*^-12", " ", "s"}]}], "}"}]}],
  SequenceForm[
  "   ", {5.0306713069233*^-7 $CellContext`g/$CellContext`s, 
    3.253621026145971*^-7 $CellContext`g/$CellContext`s, 
    1.2171984771166338`*^-12 $CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192747951769*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"3e74e1ce-2ead-461e-947e-5cc0ec9760c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Chain of \"\>", "\[InvisibleSpace]", "334", 
   "\[InvisibleSpace]", "\<\" segments,\"\>"}],
  SequenceForm["Chain of ", 334, " segments,"],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192747956894*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"6dd2cc4f-f5ae-40dc-9de5-0153b08c4964"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"with displacements at segments \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"209", ",", "272"}], "}"}]}],
  SequenceForm["with displacements at segments ", {209, 272}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927479618397`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"f8b921b2-b765-484d-ba64-b03324f084c5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Stokes offset \"\>", "\[InvisibleSpace]", 
   "3.0076424054539217`", "\[InvisibleSpace]", "\<\" A at \"\>", 
   "\[InvisibleSpace]", "50", "\[InvisibleSpace]", "\<\" bp\"\>"}],
  SequenceForm["Stokes offset ", 3.0076424054539217`, " A at ", 50, " bp"],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192747966323*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"1c8e4ab4-a840-4e1e-872c-648518b272d7"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
     {"\<\"persistence\\nlength\"\>", "510.`", "\<\"A\"\>"},
     {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
     {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
     {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
     {"\<\"turns\"\>", "1.75`", "\<\"turns\"\>"},
     {"\<\"pitch\"\>", 
      RowBox[{"-", "28.571`"}], "\<\"A/turn\"\>"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927479712143`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"342536a8-7ecb-4eaa-9d21-bbe9bd061681"],

Cell[BoxData["\<\"Array of chain lengths (bp)\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192747977412*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"bc9c049c-0bcb-40b0-b864-4787c2b665c5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"208", ",", "62", ",", "62"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192747981847*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"47a84176-1fc5-4a59-99e3-4a517acda023"],

Cell[BoxData["\<\"Array of friction element positions (bp)\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192747985588*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"44961394-dcbf-46da-8f2e-3080e2c99d7a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"104", ",", "209", ",", "240", ",", "272", ",", "303"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927479897738`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"6e3fe57e-3bd9-4eea-b90c-736277432061"],

Cell[BoxData["\<\"Array of Stokes radii (A)\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192747993906*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"b7028bbe-a4ad-4396-90bc-a704c604c2c6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "89.9681832769593`", ",", "56.81238789104189`", ",", "40.885858384248856`", 
   ",", "56.81238789104189`", ",", "40.885858384248856`"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927479981947`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"717edde3-774b-40b6-86a5-4469fa43adf7"],

Cell[BoxData["\<\"...doKirkwood...\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192748002541*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"31377b34-4168-43b1-87ee-5b6b2e1b11f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "324.43031401801034`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "320.1594381327741`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 2, " ", 324.43031401801034`, " corrected:", 
   320.1594381327741],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192748006728*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"5ae2095d-4d17-431a-af92-b708dbcf364a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "301.2323890607516`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "294.87406815958417`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 3, " ", 301.2323890607516, " corrected:", 
   294.87406815958417`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192748199353*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"8e695ff1-d9b9-48d3-90bb-43cbafa304e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "317.6373919599505`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "307.90543697726275`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 4, " ", 317.6373919599505, " corrected:", 
   307.90543697726275`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927485024757`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"785ff34a-f1ad-4d4d-a339-cd740c9d619f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "5", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "358.9741319823608`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "344.3224010759045`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 5, " ", 358.9741319823608, " corrected:", 
   344.3224010759045],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192748974537*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"b54dfff6-8a88-4662-9657-b2656ccaddd7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "114.66687786172504`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "114.51956364643796`"}],
  SequenceForm[
  "i,j,rij:", "*", 2, " ", 3, " ", 114.66687786172504`, " corrected:", 
   114.51956364643796`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.80019274898004*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"f14993f1-85c3-475c-aec4-e62fe541f438"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "216.18081933111512`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "215.09375144101062`"}],
  SequenceForm[
  "i,j,rij:", "*", 2, " ", 4, " ", 216.18081933111512`, " corrected:", 
   215.09375144101062`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192749055387*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"acc907a3-2bbb-4582-a738-50b1dba262b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "5", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "177.42851600296217`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "175.5273008559039`"}],
  SequenceForm[
  "i,j,rij:", "*", 2, " ", 5, " ", 177.42851600296217`, " corrected:", 
   175.5273008559039],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192749111917*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"1341d037-c887-44fb-8d96-7235f45b8a9d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "117.62366420737646`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "117.46298054434494`"}],
  SequenceForm[
  "i,j,rij:", "*", 3, " ", 4, " ", 117.62366420737646`, " corrected:", 
   117.46298054434494`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927491173573`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"419388b9-66a7-435a-ad95-37ed41fe6f0d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "5", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "111.33731180467954`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "110.77745077256809`"}],
  SequenceForm[
  "i,j,rij:", "*", 3, " ", 5, " ", 111.33731180467954`, " corrected:", 
   110.77745077256809`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192749195179*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"d76fc0c8-7105-4f0e-bff9-98415cb1b93e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "5", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "114.66687786172504`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "114.51956364643796`"}],
  SequenceForm[
  "i,j,rij:", "*", 4, " ", 5, " ", 114.66687786172504`, " corrected:", 
   114.51956364643796`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192749251505*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"94c595e7-c76d-4f8a-b653-c62bf06a5c9c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"np\"\>", ",", "\<\"nchain\"\>", ",", "\<\"mass1\"\>", 
   ",", "\<\"vbar1\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192749256896*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"777f17cd-fd8a-4e2c-8a60-b2291b857b99"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"334", ",", 
     RowBox[{"{", 
      RowBox[{"209", ",", "272"}], "}"}]}], "}"}], ",", "624", ",", "628840", 
   ",", "0.6190159659054768`"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927492621927`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"0e33d31d-c563-4f07-87e9-15323776442c"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1,s1}\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192749266518*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"46f1c6d0-c9cf-4b10-80e8-84f4b11d69e8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"5.465061373683699`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"2.5813641929615643`*^-7", " ", "g"}], "s"], ",", 
     RowBox[{"1.5341897780010398`*^-12", " ", "s"}]}], "}"}]}],
  SequenceForm[
  "   ", {5.465061373683699*^-7 $CellContext`g/$CellContext`s, 
    2.5813641929615643`*^-7 $CellContext`g/$CellContext`s, 
    1.5341897780010398`*^-12 $CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192749271256*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"4d011242-5a1b-48fa-87ff-d9ac44a823da"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Chain of \"\>", "\[InvisibleSpace]", "189", 
   "\[InvisibleSpace]", "\<\" segments,\"\>"}],
  SequenceForm["Chain of ", 189, " segments,"],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192749276286*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"5b53b3ee-d9ac-4946-bafb-03ca6c23f07b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"with displacements at segments \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "64", ",", "127"}], "}"}]}],
  SequenceForm["with displacements at segments ", {1, 64, 127}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192749280905*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"636aa2b4-9616-4cab-92e8-d53f6a7e724a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Stokes offset \"\>", "\[InvisibleSpace]", 
   "3.0076424054539217`", "\[InvisibleSpace]", "\<\" A at \"\>", 
   "\[InvisibleSpace]", "50", "\[InvisibleSpace]", "\<\" bp\"\>"}],
  SequenceForm["Stokes offset ", 3.0076424054539217`, " A at ", 50, " bp"],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192749285527*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"8ec07a3a-2ec3-4bdf-a7f3-495694058502"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
     {"\<\"persistence\\nlength\"\>", "510.`", "\<\"A\"\>"},
     {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
     {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
     {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
     {"\<\"turns\"\>", "1.75`", "\<\"turns\"\>"},
     {"\<\"pitch\"\>", 
      RowBox[{"-", "28.571`"}], "\<\"A/turn\"\>"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192749290495*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"64ce649a-b238-474f-9dff-708bfb4593ca"],

Cell[BoxData["\<\"Array of chain lengths (bp)\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192749296569*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"ba36eb09-f869-4688-8097-bf46bd3f37b9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "62", ",", "62", ",", "62"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.80019274930098*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"ba411623-4171-408f-8538-5e9df24b6366"],

Cell[BoxData["\<\"Array of friction element positions (bp)\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192749304955*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"74497149-83d6-499d-b730-5bc5e50fbb65"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "32", ",", "64", ",", "95", ",", "127", ",", "158"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.80019274930935*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"49fc2bf0-5d2f-4976-ac8e-ed4287b79972"],

Cell[BoxData["\<\"Array of Stokes radii (A)\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192749313397*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"3f043e02-7432-42c4-a2ff-d72305dae13b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "56.81238789104189`", ",", "40.885858384248856`", ",", "56.81238789104189`",
    ",", "40.885858384248856`", ",", "56.81238789104189`", ",", 
   "40.885858384248856`"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.80019274931774*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"3f23cbf0-dde6-4c0b-ace8-e61ad4dbffe6"],

Cell[BoxData["\<\"...doKirkwood...\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192749321844*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"76def429-6d3f-4eb3-a8fb-e474a3c88fbb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "114.66687786172504`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "114.51956364643796`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 2, " ", 114.66687786172504`, " corrected:", 
   114.51956364643796`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192749326179*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"d224015a-e7cd-4455-9ba2-7fc1fa8e342a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "216.18081933111512`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "215.09375144101062`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 3, " ", 216.18081933111512`, " corrected:", 
   215.09375144101062`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.80019274933141*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"a765b665-11fb-4d28-a099-a8cc09697e3c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "177.42851600296217`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "175.5273008559039`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 4, " ", 177.42851600296217`, " corrected:", 
   175.5273008559039],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927493363237`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"d5943ffe-daf2-4081-a3a2-45ac04c4b384"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "5", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "207.82100286151973`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "203.99921228448463`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 5, " ", 207.82100286151973`, " corrected:", 
   203.99921228448463`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192749448636*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"c3518f8f-43d9-4018-9f69-c90df851d8b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "6", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "245.64670725143483`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "238.9570929766298`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 6, " ", 245.64670725143483`, " corrected:", 
   238.9570929766298],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927497472563`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"63696bb0-871d-409c-b632-ec8f8d201f07"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "117.62366420737646`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "117.46298054434494`"}],
  SequenceForm[
  "i,j,rij:", "*", 2, " ", 3, " ", 117.62366420737646`, " corrected:", 
   117.46298054434494`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192749752993*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"6a1cf098-0867-40a5-8768-c92918bb1ba4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "111.33731180467953`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "110.77745077256807`"}],
  SequenceForm[
  "i,j,rij:", "*", 2, " ", 4, " ", 111.33731180467953`, " corrected:", 
   110.77745077256807`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927498290253`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"6db06a69-129d-46d4-8e4d-97544a10768e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "5", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "178.21424088986402`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "176.26649376934822`"}],
  SequenceForm[
  "i,j,rij:", "*", 2, " ", 5, " ", 178.21424088986402`, " corrected:", 
   176.26649376934822`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927498871107`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"9b4bc113-92c1-4e0e-9e3f-b25f48828d26"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "6", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "184.85807333874726`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "181.45856687382246`"}],
  SequenceForm[
  "i,j,rij:", "*", 2, " ", 6, " ", 184.85807333874726`, " corrected:", 
   181.45856687382246`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192750064362*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"be805f13-8ab5-4090-8612-279c483d73b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "114.66687786172504`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "114.51956364643796`"}],
  SequenceForm[
  "i,j,rij:", "*", 3, " ", 4, " ", 114.66687786172504`, " corrected:", 
   114.51956364643796`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192750070163*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"6fe92b4e-bbb1-4d92-8b1e-1554877ce9de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "5", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "216.18081933111512`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "215.09375144101062`"}],
  SequenceForm[
  "i,j,rij:", "*", 3, " ", 5, " ", 216.18081933111512`, " corrected:", 
   215.09375144101062`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927501452312`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"0028bea0-b599-4a43-a2b9-33e31c6ccf92"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "6", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "177.42851600296214`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "175.52730085590386`"}],
  SequenceForm[
  "i,j,rij:", "*", 3, " ", 6, " ", 177.42851600296214`, " corrected:", 
   175.52730085590386`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192750201811*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"b5e353f3-7c2d-4cfc-b036-a68a3d82d22c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "5", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "117.62366420737646`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "117.46298054434494`"}],
  SequenceForm[
  "i,j,rij:", "*", 4, " ", 5, " ", 117.62366420737646`, " corrected:", 
   117.46298054434494`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192750207522*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"3e142c6d-8340-4f8c-86b9-3e3de152f0a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "6", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "111.3373118046795`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "110.77745077256805`"}],
  SequenceForm[
  "i,j,rij:", "*", 4, " ", 6, " ", 111.3373118046795, " corrected:", 
   110.77745077256805`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927502798347`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"ad07f438-1798-4644-9898-dabe154fabcf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "5", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "6", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "114.66687786172504`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "114.51956364643796`"}],
  SequenceForm[
  "i,j,rij:", "*", 5, " ", 6, " ", 114.66687786172504`, " corrected:", 
   114.51956364643796`],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.8001927503357353`*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"6de24d8e-b347-426b-88b8-851d6f184acc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"np\"\>", ",", "\<\"nchain\"\>", ",", "\<\"mass1\"\>", 
   ",", "\<\"vbar1\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192750341031*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"167c7b41-74ad-418d-bf6e-2aec7b0806bd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"189", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "64", ",", "127"}], "}"}]}], "}"}], ",", "624", ",", 
   "737340", ",", "0.6382903409553259`"}], "}"}]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192750346086*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"d08a81ad-9e01-4ca6-bd80-80e34788f21d"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1,s1}\"\>"], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192750350439*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"2c441a24-a4de-4fa1-8d69-b47f07c3248d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"5.61310096052399`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"2.1559699301318994`*^-7", " ", "g"}], "s"], ",", 
     RowBox[{"2.044012144761513`*^-12", " ", "s"}]}], "}"}]}],
  SequenceForm[
  "   ", {5.61310096052399*^-7 $CellContext`g/$CellContext`s, 
    2.1559699301318994`*^-7 $CellContext`g/$CellContext`s, 
    2.044012144761513*^-12 $CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794913125998341*^9, 3.800192750355019*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"5e705944-3128-480e-86a3-16bb75292a4a"]
}, Open  ]],

Cell["Calculate sedimentation coefficients", "Text",
 ImageRegion->{{0, 1}, {0, 
  1}},ExpressionUUID->"8b54dffa-8e21-49b5-a682-07023b00e999"],

Cell["\<\
In the preceding doKirkwood loop output, the sedimentation coefficients s1 \
for each species (3rd value in the brackets) are calculated at the same time \
as the friction coefficients, but they were not calculated in the original \
1995 output. In 1995, before running the loop, I apparently executed the cell \
defining doKirkwood in my library notebook manually (I did not yet use the \
\"Get\" command to load the library functions), and forgot to execute the \
cell defining the sediment[] function. This is why in the original output the \
sedimentation coefficients s1 had to be recalculated in this section, and at \
that point I must have executed the library cell defining the \"sediment\" \
function. No trace of this, however. This is an example of the pitfalls of \
\"hidden state\" in notebook computing.\
\>", "Text",
 CellFrame->True,
 FontColor->RGBColor[0, 0, 1],
 Background->GrayLevel[
  0.833326],ExpressionUUID->"f77fd227-6c62-474a-b82d-39fe00bdd1bb"],

Cell["\<\
First check \"sediment\" routine for a mononucleosome core particle\
\>", "Text",
 ImageRegion->{{0, 1}, {0, 
  1}},ExpressionUUID->"aadf60b2-f268-4aee-a75e-9a546ff1106d"],

Cell[CellGroupData[{

Cell["sediment[{1,{1}},1.09 10^-7 g/s]", "Input",
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[25]:=",ExpressionUUID->"0191a282-381b-4281-a82a-01c4fd343e60"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"np\"\>", ",", "\<\"nchain\"\>", ",", "\<\"mass1\"\>", 
   ",", "\<\"vbar1\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.794913133498178*^9, 3.800192750549185*^9},
 CellLabel->
  "During evaluation of \
In[25]:=",ExpressionUUID->"d75cc5fe-c4e8-4512-b5ce-8a367af5a672"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", "1", "}"}]}], "}"}], ",", "146", ",", "204860", ",", 
   "0.6559259982427024`"}], "}"}]], "Print",
 CellChangeTimes->{3.794913133498178*^9, 3.800192750554641*^9},
 CellLabel->
  "During evaluation of \
In[25]:=",ExpressionUUID->"5ec892c8-b204-4086-b0ef-800420c66371"],

Cell[BoxData[
 RowBox[{"1.068058779603158`*^-12", " ", "s"}]], "Output",
 CellChangeTimes->{3.794913133506618*^9, 3.800192750558201*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"4f877bc3-e164-410c-a65f-0f7e8bbe6e2c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "f1values={",
 StyleBox["3.69942,3.44271,3.39772,2.86755,\n            \
3.25362,2.58136,2.15597",
  FontWeight->"Plain"],
 "} 10^-7 g/s;\nDo[Print[\"\\n\",sediment[chain[[isp]],f1values[[isp]]]],\n\
{isp,Length[chain]}];"
}], "Input",
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[26]:=",ExpressionUUID->"491321cd-3ee5-4d53-8a7a-9adadcd02bfc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"np\"\>", ",", "\<\"nchain\"\>", ",", "\<\"mass1\"\>", 
   ",", "\<\"vbar1\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.7949131335902576`*^9, 3.8001927506379843`*^9},
 CellLabel->
  "During evaluation of \
In[26]:=",ExpressionUUID->"3d99bf88-2024-49aa-94f3-e477fe043655"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"479", ",", 
     RowBox[{"{", "1", "}"}]}], "}"}], ",", "624", ",", "520340", ",", 
   "0.5917035015566745`"}], "}"}]], "Print",
 CellChangeTimes->{3.7949131335902576`*^9, 3.800192750692832*^9},
 CellLabel->
  "During evaluation of \
In[26]:=",ExpressionUUID->"7ce48f1b-3047-470c-a17c-40915eebae04"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"9.498181864586445`*^-13", " ", "s"}]}],
  SequenceForm["\n", 9.498181864586445*^-13 $CellContext`s],
  Editable->False]], "Print",
 CellChangeTimes->{3.7949131335902576`*^9, 3.800192750696933*^9},
 CellLabel->
  "During evaluation of \
In[26]:=",ExpressionUUID->"f7cacdde-4d05-4d70-98d4-849d9974418c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"np\"\>", ",", "\<\"nchain\"\>", ",", "\<\"mass1\"\>", 
   ",", "\<\"vbar1\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.7949131335902576`*^9, 3.8001927507012367`*^9},
 CellLabel->
  "During evaluation of \
In[26]:=",ExpressionUUID->"ba235362-08e7-4126-8459-710c26bb32eb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"479", ",", 
     RowBox[{"{", "209", "}"}]}], "}"}], ",", "624", ",", "520340", ",", 
   "0.5917035015566745`"}], "}"}]], "Print",
 CellChangeTimes->{3.7949131335902576`*^9, 3.800192750705529*^9},
 CellLabel->
  "During evaluation of \
In[26]:=",ExpressionUUID->"f3d28cf3-dc83-4e90-9bfa-811c3ba3c4ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"1.0206425738295815`*^-12", " ", "s"}]}],
  SequenceForm["\n", 1.0206425738295815`*^-12 $CellContext`s],
  Editable->False]], "Print",
 CellChangeTimes->{3.7949131335902576`*^9, 3.800192750709301*^9},
 CellLabel->
  "During evaluation of \
In[26]:=",ExpressionUUID->"c6dc43c5-efeb-4c07-beca-0f824823d2ad"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"np\"\>", ",", "\<\"nchain\"\>", ",", "\<\"mass1\"\>", 
   ",", "\<\"vbar1\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.7949131335902576`*^9, 3.800192750713032*^9},
 CellLabel->
  "During evaluation of \
In[26]:=",ExpressionUUID->"7e1541a6-8500-4ffa-814c-3c668aca5153"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"479", ",", 
     RowBox[{"{", "417", "}"}]}], "}"}], ",", "624", ",", "520340", ",", 
   "0.5917035015566745`"}], "}"}]], "Print",
 CellChangeTimes->{3.7949131335902576`*^9, 3.8001927507168093`*^9},
 CellLabel->
  "During evaluation of \
In[26]:=",ExpressionUUID->"255206da-ee39-4d51-8292-9cc46b424982"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"1.0341571393018961`*^-12", " ", "s"}]}],
  SequenceForm["\n", 1.0341571393018961`*^-12 $CellContext`s],
  Editable->False]], "Print",
 CellChangeTimes->{3.7949131335902576`*^9, 3.800192750720345*^9},
 CellLabel->
  "During evaluation of \
In[26]:=",ExpressionUUID->"bdd9fbed-014d-4ba4-863b-1fdf005c5ae3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"np\"\>", ",", "\<\"nchain\"\>", ",", "\<\"mass1\"\>", 
   ",", "\<\"vbar1\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.7949131335902576`*^9, 3.800192750724373*^9},
 CellLabel->
  "During evaluation of \
In[26]:=",ExpressionUUID->"ec5fa352-c4a6-4f39-b1f4-d1fc3adb0ac6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"334", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "64"}], "}"}]}], "}"}], ",", "624", ",", "628840", 
   ",", "0.6190159659054768`"}], "}"}]], "Print",
 CellChangeTimes->{3.7949131335902576`*^9, 3.8001927507282248`*^9},
 CellLabel->
  "During evaluation of \
In[26]:=",ExpressionUUID->"7f492d2a-3a8d-42bd-a065-9319903d5573"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"1.381075328464904`*^-12", " ", "s"}]}],
  SequenceForm["\n", 1.381075328464904*^-12 $CellContext`s],
  Editable->False]], "Print",
 CellChangeTimes->{3.7949131335902576`*^9, 3.8001927507317743`*^9},
 CellLabel->
  "During evaluation of \
In[26]:=",ExpressionUUID->"36f378dc-4511-4388-8dac-9b89641c7c4a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"np\"\>", ",", "\<\"nchain\"\>", ",", "\<\"mass1\"\>", 
   ",", "\<\"vbar1\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.7949131335902576`*^9, 3.800192750735498*^9},
 CellLabel->
  "During evaluation of \
In[26]:=",ExpressionUUID->"8167e219-d158-44ba-b6f0-b3c9017b4188"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"334", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "272"}], "}"}]}], "}"}], ",", "624", ",", "628840", 
   ",", "0.6190159659054768`"}], "}"}]], "Print",
 CellChangeTimes->{3.7949131335902576`*^9, 3.8001927507395773`*^9},
 CellLabel->
  "During evaluation of \
In[26]:=",ExpressionUUID->"4b89e399-a41b-4b16-8a04-721cbf122e8d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"1.2171988610039082`*^-12", " ", "s"}]}],
  SequenceForm["\n", 1.2171988610039082`*^-12 $CellContext`s],
  Editable->False]], "Print",
 CellChangeTimes->{3.7949131335902576`*^9, 3.800192750743174*^9},
 CellLabel->
  "During evaluation of \
In[26]:=",ExpressionUUID->"f701b125-79cc-4998-afc2-92193dc0492b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"np\"\>", ",", "\<\"nchain\"\>", ",", "\<\"mass1\"\>", 
   ",", "\<\"vbar1\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.7949131335902576`*^9, 3.8001927507468157`*^9},
 CellLabel->
  "During evaluation of \
In[26]:=",ExpressionUUID->"3a5de997-a575-4cb1-9212-b4460daedfc0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"334", ",", 
     RowBox[{"{", 
      RowBox[{"209", ",", "272"}], "}"}]}], "}"}], ",", "624", ",", "628840", 
   ",", "0.6190159659054768`"}], "}"}]], "Print",
 CellChangeTimes->{3.7949131335902576`*^9, 3.800192750750729*^9},
 CellLabel->
  "During evaluation of \
In[26]:=",ExpressionUUID->"47f08d71-80d5-49b5-aaf5-fa714b5ce076"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"1.5341922700202746`*^-12", " ", "s"}]}],
  SequenceForm["\n", 1.5341922700202746`*^-12 $CellContext`s],
  Editable->False]], "Print",
 CellChangeTimes->{3.7949131335902576`*^9, 3.8001927507545443`*^9},
 CellLabel->
  "During evaluation of \
In[26]:=",ExpressionUUID->"2db93629-b818-4b87-9e6b-458ed0ab9a98"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"np\"\>", ",", "\<\"nchain\"\>", ",", "\<\"mass1\"\>", 
   ",", "\<\"vbar1\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.7949131335902576`*^9, 3.800192750758478*^9},
 CellLabel->
  "During evaluation of \
In[26]:=",ExpressionUUID->"26c80789-0e92-4e32-9ed8-9249e60a29a6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"189", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "64", ",", "127"}], "}"}]}], "}"}], ",", "624", ",", 
   "737340", ",", "0.6382903409553259`"}], "}"}]], "Print",
 CellChangeTimes->{3.7949131335902576`*^9, 3.800192750762454*^9},
 CellLabel->
  "During evaluation of \
In[26]:=",ExpressionUUID->"4e682dd2-9745-4b3a-a88f-eab01a560149"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"2.0440120785216095`*^-12", " ", "s"}]}],
  SequenceForm["\n", 2.0440120785216095`*^-12 $CellContext`s],
  Editable->False]], "Print",
 CellChangeTimes->{3.7949131335902576`*^9, 3.800192750766007*^9},
 CellLabel->
  "During evaluation of \
In[26]:=",ExpressionUUID->"b0f51a68-5537-4803-bcd8-aa4a07578678"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Hydro MS Example 3: Generate sedimentation distributions for trimer\
\>", "Subsubsection",
 ImageRegion->{{0, 1}, {0, 
  1}},ExpressionUUID->"66e34c8a-7580-44a5-935b-8836e432267b"],

Cell["\<\
First use the Kovacik and van Holde to calculate the sedimentation of the \
free DNA\
\>", "Text",
 ImageRegion->{{0, 1}, {0, 
  1}},ExpressionUUID->"107312f5-7813-4b1b-bcee-aa5545a19e4a"],

Cell[CellGroupData[{

Cell["rYF[3 208]", "Input",
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[28]:=",ExpressionUUID->"b5ad5f73-3744-46fa-83c2-928c93be03d3"],

Cell[BoxData["197.51471778741566`"], "Output",
 CellChangeTimes->{3.794913133737771*^9, 3.800192750845972*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"27f950dc-0f5b-4801-8911-a9216b3de478"]
}, Open  ]],

Cell["\<\
This function rYF returns the hydrodynamic radius, not the sedimentation \
coefficient, so part of this calculation was apparently deleted from the \
notebook. I didn't pursue this further, because calculating the hydrodynamics \
of free DNA is not part of the novelty of the article. The correct value for \
3x208 bp of free DNA is 8.1 S.\
\>", "Text",
 CellFrame->True,
 FontColor->RGBColor[0, 0, 1],
 Background->GrayLevel[
  0.833326],ExpressionUUID->"cb01a7b8-97ea-4174-9a91-121338f73899"],

Cell["\<\
The sedimentation coefficients as calculated above are identical to those  \
recopied to the list below, after scaling to Svedburg units of 10^-13 s.\
\>", "Text",
 CellFrame->True,
 FontColor->RGBColor[0, 0, 1],
 Background->GrayLevel[
  0.833326],ExpressionUUID->"e7c2ca17-1672-43a8-a5d4-77ff21c9778c"],

Cell["ss={8.1,9.5,10.2,10.3,13.8,12.2,15.3,20.4};", "Input",
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[29]:=",ExpressionUUID->"caaf747d-e6d7-4f36-b25f-960b78903644"],

Cell["\<\
fcoop[x_]:=Module[{a,b},
\ta=(1-x);
\tb=x;
\t{a,0,0,0,0,0,0,b}];
frand[x_]:=Module[{a,b},
\ta=(1-x);
\tb=x;
\t{a^3,a^2 b,a^2 b,a^2 b,a b^2,a b^2,a b^2,b^3}];\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[30]:=",ExpressionUUID->"9a8c58da-12bc-4fa2-a98e-57c3442b1a23"],

Cell[CellGroupData[{

Cell["Print[MatrixForm[{ss,fcoop[0.5]}]]", "Input",
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[32]:=",ExpressionUUID->"f9a87104-33b9-4352-92d8-1227e0f452c9"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"8.1`", "9.5`", "10.2`", "10.3`", "13.8`", "12.2`", "15.3`", "20.4`"},
     {"0.5`", "0", "0", "0", "0", "0", "0", "0.5`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.7949131338473*^9, 3.800192751055193*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"662ac89c-2c66-4615-9309-797adb3c8f0c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Print[MatrixForm[{ss,frand[0.5]}]]", "Input",
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[33]:=",ExpressionUUID->"f1761510-e5e5-4fc1-9655-178729caa3a3"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"8.1`", "9.5`", "10.2`", "10.3`", "13.8`", "12.2`", "15.3`", "20.4`"},
     {"0.125`", "0.125`", "0.125`", "0.125`", "0.125`", "0.125`", "0.125`", 
      "0.125`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.79491313390781*^9, 3.800192751136014*^9},
 CellLabel->
  "During evaluation of \
In[33]:=",ExpressionUUID->"62c8c5a6-f8a6-4605-9989-2edd13f48cd8"]
}, Open  ]],

Cell["\<\
The two saturation models fcoop (perfectly cooperative saturation) and frand \
(random saturation) were calculated using elementary statistics (see article \
text) and used to weight the calculated sedimentaiton coefficients for the \
plotted distributions.\
\>", "Text",
 CellFrame->True,
 FontColor->RGBColor[0, 0, 1],
 Background->GrayLevel[
  0.833326],ExpressionUUID->"1dd4dddc-4a2d-421d-8409-1d6888f9f2f8"],

Cell["\<\
Demonstrate that the sum of species fractions is always unity for both models\
\
\>", "Text",
 ImageRegion->{{0, 1}, {0, 
  1}},ExpressionUUID->"ee6e3eb8-bd76-42c8-856d-567b6bde59e7"],

Cell[CellGroupData[{

Cell["\<\
Print[Simplify[Apply[Plus,fcoop[x]]]];
Print[Simplify[Apply[Plus,frand[x]]]];\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[34]:=",ExpressionUUID->"53a6af11-0002-4b4e-94a3-abd887eb03d7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.794913133992732*^9, 3.800192751267165*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"17d93d1e-7948-4d3e-a8ed-9928a21d5c62"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.794913133992732*^9, 3.800192751322462*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"45968c82-ea4c-436d-baec-209028bb1e66"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Show[wdistribution[ss,fcoop[0.5],1,0,5,22,0,\"cooperative assembly\"],
\tPlotRange->{{5,22},{0,0.52}},
\tFrame\[Rule]True,
\tFrameLabel\[Rule]{\"sedimentation coefficient, Svedburg\",\"fraction in bin\
\"}]\
\>", "Input",
 CellChangeTimes->{{3.8001927019229116`*^9, 3.8001927030909367`*^9}, {
   3.800204915941196*^9, 3.800204929362658*^9}, 3.8002049763460484`*^9, {
   3.8002442823803*^9, 3.800244344876628*^9}, {3.80026960773801*^9, 
   3.800269667918395*^9}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[51]:=",ExpressionUUID->"40b77697-23ac-4e90-96ee-6ef62c6f07df"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"17", ",", "1", ",", "8"}], "}"}]], "Print",
 CellChangeTimes->{
  3.800244350908637*^9, {3.800269639546452*^9, 3.800269668926815*^9}},
 CellLabel->
  "During evaluation of \
In[51]:=",ExpressionUUID->"a1c5197b-b2d4-41e1-b8cb-e2033354a6c7"],

Cell[BoxData["\<\"binned...\"\>"], "Print",
 CellChangeTimes->{
  3.800244350908637*^9, {3.800269639546452*^9, 3.8002696689339447`*^9}},
 CellLabel->
  "During evaluation of \
In[51]:=",ExpressionUUID->"22a114f3-1907-4edb-b986-0af7202bcfac"],

Cell[BoxData["\<\"top summed...\"\>"], "Print",
 CellChangeTimes->{
  3.800244350908637*^9, {3.800269639546452*^9, 3.800269668956793*^9}},
 CellLabel->
  "During evaluation of \
In[51]:=",ExpressionUUID->"236b16cc-648b-4fbc-aa22-a8ba4722f732"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Average is \"\>", "\[InvisibleSpace]", "14.25`"}],
  SequenceForm["Average is ", 14.25],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.800244350908637*^9, {3.800269639546452*^9, 3.800269668960958*^9}},
 CellLabel->
  "During evaluation of \
In[51]:=",ExpressionUUID->"6e708a03-6f89-42d8-a2e4-26deb83afd03"],

Cell[BoxData[
 GraphicsBox[{{
    {GrayLevel[0], RectangleBox[{5, 0}, {6, 0}]}, 
    {GrayLevel[0], LineBox[{{5, 0}, {5, 0}, {6, 0}, {6, 0}}]}}, {
    {GrayLevel[0], RectangleBox[{6, 0}, {7, 0}]}, 
    {GrayLevel[0], LineBox[{{6, 0}, {6, 0}, {7, 0}, {7, 0}}]}}, {
    {GrayLevel[0], RectangleBox[{7, 0}, {8, 0}]}, 
    {GrayLevel[0], LineBox[{{7, 0}, {7, 0}, {8, 0}, {8, 0}}]}}, {
    {GrayLevel[0], RectangleBox[{8, 0}, {9, 0.5}]}, 
    {GrayLevel[0], LineBox[{{8, 0}, {8, 0.5}, {9, 0.5}, {9, 0}}]}}, {
    {GrayLevel[0], RectangleBox[{9, 0}, {10, 0}]}, 
    {GrayLevel[0], LineBox[{{9, 0}, {9, 0}, {10, 0}, {10, 0}}]}}, {
    {GrayLevel[0], RectangleBox[{10, 0}, {11, 0}]}, 
    {GrayLevel[0], LineBox[{{10, 0}, {10, 0}, {11, 0}, {11, 0}}]}}, {
    {GrayLevel[0], RectangleBox[{11, 0}, {12, 0}]}, 
    {GrayLevel[0], LineBox[{{11, 0}, {11, 0}, {12, 0}, {12, 0}}]}}, {
    {GrayLevel[0], RectangleBox[{12, 0}, {13, 0}]}, 
    {GrayLevel[0], LineBox[{{12, 0}, {12, 0}, {13, 0}, {13, 0}}]}}, {
    {GrayLevel[0], RectangleBox[{13, 0}, {14, 0}]}, 
    {GrayLevel[0], LineBox[{{13, 0}, {13, 0}, {14, 0}, {14, 0}}]}}, {
    {GrayLevel[0], RectangleBox[{14, 0}, {15, 0}]}, 
    {GrayLevel[0], LineBox[{{14, 0}, {14, 0}, {15, 0}, {15, 0}}]}}, {
    {GrayLevel[0], RectangleBox[{15, 0}, {16, 0}]}, 
    {GrayLevel[0], LineBox[{{15, 0}, {15, 0}, {16, 0}, {16, 0}}]}}, {
    {GrayLevel[0], RectangleBox[{16, 0}, {17, 0}]}, 
    {GrayLevel[0], LineBox[{{16, 0}, {16, 0}, {17, 0}, {17, 0}}]}}, {
    {GrayLevel[0], RectangleBox[{17, 0}, {18, 0}]}, 
    {GrayLevel[0], LineBox[{{17, 0}, {17, 0}, {18, 0}, {18, 0}}]}}, {
    {GrayLevel[0], RectangleBox[{18, 0}, {19, 0}]}, 
    {GrayLevel[0], LineBox[{{18, 0}, {18, 0}, {19, 0}, {19, 0}}]}}, {
    {GrayLevel[0], RectangleBox[{19, 0}, {20, 0}]}, 
    {GrayLevel[0], LineBox[{{19, 0}, {19, 0}, {20, 0}, {20, 0}}]}}, {
    {GrayLevel[0], RectangleBox[{20, 0}, {21, 0.5}]}, 
    {GrayLevel[0], LineBox[{{20, 0}, {20, 0.5}, {21, 0.5}, {21, 0}}]}}, {
    {GrayLevel[0], RectangleBox[{21, 0}, {22, 0}]}, 
    {GrayLevel[0], LineBox[{{21, 0}, {21, 0}, {22, 0}, {22, 0}}]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{
    FormBox["\"sedimentation coefficient, Svedburg\"", TraditionalForm], 
    FormBox["\"fraction in bin\"", TraditionalForm]},
  PlotLabel->FormBox["\"cooperative assembly\"", TraditionalForm],
  PlotRange->{{5, 22}, {0, 0.52}}]], "Output",
 CellChangeTimes->{
  3.800244350934333*^9, {3.800269639566359*^9, 3.80026966896805*^9}},
 CellLabel->"Out[51]=",ExpressionUUID->"7ccd070d-d15d-44a3-bae9-deab028d9f57"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Show[wdistribution[ss,frand[0.5],1,0,5,22,1,\"random assembly\"],
\tPlotRange->{{5,22},{0,0.52}},
\tFrame\[Rule]True,
\tFrameLabel\[Rule]{\"sedimentation coefficient, Svedburg\",\"fraction in bin\
\"}]\
\>", "Input",
 CellChangeTimes->{{3.800192707719819*^9, 3.800192707928403*^9}, {
   3.800244386405744*^9, 3.8002444255576563`*^9}, 3.800269701416847*^9},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[52]:=",ExpressionUUID->"cdfde070-6886-40d1-b8f2-97acac1ec2d0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"17", ",", "1", ",", "8"}], "}"}]], "Print",
 CellChangeTimes->{3.800244426994177*^9, 3.8002697040554*^9},
 CellLabel->
  "During evaluation of \
In[52]:=",ExpressionUUID->"49864507-99d9-46c6-bfa5-85ec6bd25bb1"],

Cell[BoxData["\<\"binned...\"\>"], "Print",
 CellChangeTimes->{3.800244426994177*^9, 3.800269704066949*^9},
 CellLabel->
  "During evaluation of \
In[52]:=",ExpressionUUID->"9ae911e1-3f2d-46d9-8cc5-78406d306a3a"],

Cell[BoxData["\<\"top summed...\"\>"], "Print",
 CellChangeTimes->{3.800244426994177*^9, 3.800269704071122*^9},
 CellLabel->
  "During evaluation of \
In[52]:=",ExpressionUUID->"91e13461-bc61-4f9c-ac15-3d49ca8c85fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Average is \"\>", "\[InvisibleSpace]", "12.475000000000001`"}],
  
  SequenceForm["Average is ", 12.475000000000001`],
  Editable->False]], "Print",
 CellChangeTimes->{3.800244426994177*^9, 3.800269704075387*^9},
 CellLabel->
  "During evaluation of \
In[52]:=",ExpressionUUID->"d8078000-73ad-4b44-b5b5-b20cb11c3af9"],

Cell[BoxData[
 GraphicsBox[{{
    {GrayLevel[1], RectangleBox[{5, 0}, {6, 0}]}, 
    {GrayLevel[0], LineBox[{{5, 0}, {5, 0}, {6, 0}, {6, 0}}]}}, {
    {GrayLevel[1], RectangleBox[{6, 0}, {7, 0}]}, 
    {GrayLevel[0], LineBox[{{6, 0}, {6, 0}, {7, 0}, {7, 0}}]}}, {
    {GrayLevel[1], RectangleBox[{7, 0}, {8, 0}]}, 
    {GrayLevel[0], LineBox[{{7, 0}, {7, 0}, {8, 0}, {8, 0}}]}}, {
    {GrayLevel[1], RectangleBox[{8, 0}, {9, 0.125}]}, 
    {GrayLevel[0], LineBox[{{8, 0}, {8, 0.125}, {9, 0.125}, {9, 0}}]}}, {
    {GrayLevel[1], RectangleBox[{9, 0}, {10, 0.125}]}, 
    {GrayLevel[0], LineBox[{{9, 0}, {9, 0.125}, {10, 0.125}, {10, 0}}]}}, {
    {GrayLevel[1], RectangleBox[{10, 0}, {11, 0.25}]}, 
    {GrayLevel[0], LineBox[{{10, 0}, {10, 0.25}, {11, 0.25}, {11, 0}}]}}, {
    {GrayLevel[1], RectangleBox[{11, 0}, {12, 0}]}, 
    {GrayLevel[0], LineBox[{{11, 0}, {11, 0}, {12, 0}, {12, 0}}]}}, {
    {GrayLevel[1], RectangleBox[{12, 0}, {13, 0.125}]}, 
    {GrayLevel[0], LineBox[{{12, 0}, {12, 0.125}, {13, 0.125}, {13, 0}}]}}, {
    {GrayLevel[1], RectangleBox[{13, 0}, {14, 0.125}]}, 
    {GrayLevel[0], LineBox[{{13, 0}, {13, 0.125}, {14, 0.125}, {14, 0}}]}}, {
    {GrayLevel[1], RectangleBox[{14, 0}, {15, 0}]}, 
    {GrayLevel[0], LineBox[{{14, 0}, {14, 0}, {15, 0}, {15, 0}}]}}, {
    {GrayLevel[1], RectangleBox[{15, 0}, {16, 0.125}]}, 
    {GrayLevel[0], LineBox[{{15, 0}, {15, 0.125}, {16, 0.125}, {16, 0}}]}}, {
    {GrayLevel[1], RectangleBox[{16, 0}, {17, 0}]}, 
    {GrayLevel[0], LineBox[{{16, 0}, {16, 0}, {17, 0}, {17, 0}}]}}, {
    {GrayLevel[1], RectangleBox[{17, 0}, {18, 0}]}, 
    {GrayLevel[0], LineBox[{{17, 0}, {17, 0}, {18, 0}, {18, 0}}]}}, {
    {GrayLevel[1], RectangleBox[{18, 0}, {19, 0}]}, 
    {GrayLevel[0], LineBox[{{18, 0}, {18, 0}, {19, 0}, {19, 0}}]}}, {
    {GrayLevel[1], RectangleBox[{19, 0}, {20, 0}]}, 
    {GrayLevel[0], LineBox[{{19, 0}, {19, 0}, {20, 0}, {20, 0}}]}}, {
    {GrayLevel[1], RectangleBox[{20, 0}, {21, 0.125}]}, 
    {GrayLevel[0], LineBox[{{20, 0}, {20, 0.125}, {21, 0.125}, {21, 0}}]}}, {
    {GrayLevel[1], RectangleBox[{21, 0}, {22, 0}]}, 
    {GrayLevel[0], LineBox[{{21, 0}, {21, 0}, {22, 0}, {22, 0}}]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{
    FormBox["\"sedimentation coefficient, Svedburg\"", TraditionalForm], 
    FormBox["\"fraction in bin\"", TraditionalForm]},
  PlotLabel->FormBox["\"random assembly\"", TraditionalForm],
  PlotRange->{{5, 22}, {0, 0.52}}]], "Output",
 CellChangeTimes->{3.800244427021982*^9, 3.800269704131971*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"d18b1905-b4ae-4260-b199-fff3cf5b2d87"]
}, Open  ]],

Cell["\<\
These are the results shown in Figure 5 and Table 1 of my 1995 Biophysical \
Journal paper.\
\>", "Text",
 CellFrame->True,
 FontColor->RGBColor[0, 0, 1],
 Background->GrayLevel[
  0.833326],ExpressionUUID->"3ec622cb-0cc6-4771-affe-6ffd80a9a078"]
},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{1064, 872},
WindowMargins->{{240, Automatic}, {130, Automatic}},
ShowSelection->True,
ShowCellLabel->True,
ShowCellTags->False,
Magnification->1.5,
FrontEndVersion->"12.0 for Linux ARM (32-bit) (June 23, 2019)",
StyleDefinitions->"Default.nb",
PrivateNotebookOptions -> {"ColorPalette" -> {RGBColor, -1}},
RenderingOptions -> {"ObjectDithering" -> True},
RenderingOptions -> {"RasterDithering" -> False}
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 906, 18, 471, "Text",ExpressionUUID->"4395c488-107e-4ad3-a23d-de7f84ef685a",
 InitializationCell->True],
Cell[1467, 40, 352, 9, 82, "Input",ExpressionUUID->"4ed2792d-9bd3-49da-8ab2-4888e1d3c66f"],
Cell[1822, 51, 267, 8, 100, "Input",ExpressionUUID->"f08b2882-2bf3-47da-9f86-2fbf65286844",
 PageBreakWithin->Automatic,
 InitializationCell->True],
Cell[CellGroupData[{
Cell[2114, 63, 193, 4, 110, "Subsubsection",ExpressionUUID->"7fa35ed6-7d93-41e1-bfdb-5d3b93f1230d"],
Cell[2310, 69, 486, 8, 196, "Text",ExpressionUUID->"9b2ee285-ce70-41d7-ab50-fe22f9016d3c"],
Cell[2799, 79, 243, 5, 90, "Text",ExpressionUUID->"0e9665a1-362a-4319-bd3c-b1ae4a7bccc1"],
Cell[3045, 86, 170, 5, 76, "Input",ExpressionUUID->"e9dad861-7470-42d9-bfa6-2871a5ee526a"],
Cell[3218, 93, 227, 5, 90, "Text",ExpressionUUID->"3930d682-a671-4fee-becb-ea92bf0f3f61"],
Cell[CellGroupData[{
Cell[3470, 102, 218, 9, 190, "Input",ExpressionUUID->"5e42c659-122b-4f9f-9720-ad9095434504"],
Cell[3691, 113, 439, 10, 37, "Print",ExpressionUUID->"f0d5c03d-7bab-4e65-bde0-37fe81a26981"],
Cell[4133, 125, 173, 2, 53, "Output",ExpressionUUID->"e4075db1-46d0-4333-93d2-8303b4fbb7de"]
}, Open  ]],
Cell[4321, 130, 507, 9, 303, "Text",ExpressionUUID->"8f0f56c8-3c72-495e-9edd-484fe897c1b9"],
Cell[4831, 141, 170, 2, 47, "Input",ExpressionUUID->"462bea87-c9e2-4eee-a0f8-e8fa1f2d17f9"],
Cell[CellGroupData[{
Cell[5026, 147, 262, 6, 104, "Input",ExpressionUUID->"cb93d1fa-4a75-4a3c-8d7a-1da163fd72a4"],
Cell[5291, 155, 287, 6, 74, "Output",ExpressionUUID->"fe254ca5-a6cf-495b-a4ca-abf900ffcf09"]
}, Open  ]],
Cell[5593, 164, 272, 10, 218, "Input",ExpressionUUID->"feb75349-28d4-4223-a028-710b0067f4b2"],
Cell[5868, 176, 227, 5, 82, "Input",ExpressionUUID->"2a13c0cf-b8ac-45a7-aa83-1e9028272846"],
Cell[6098, 183, 196, 7, 133, "Input",ExpressionUUID->"2b92c31c-c934-4219-a5e1-86f523c56f05"],
Cell[CellGroupData[{
Cell[6319, 194, 248, 7, 133, "Input",ExpressionUUID->"c89b7b0a-7e39-4194-bde8-dcdd7c05f5de"],
Cell[6570, 203, 388, 9, 37, "Print",ExpressionUUID->"77775a1b-4902-452a-98b3-bb873c31588d"],
Cell[6961, 214, 393, 9, 37, "Print",ExpressionUUID->"fdf95070-4323-4477-b0e3-7631c4664774"],
Cell[7357, 225, 500, 10, 37, "Print",ExpressionUUID->"3c25bacb-284b-4341-876d-1fab365a225d"],
Cell[7860, 237, 1003, 25, 221, "Print",ExpressionUUID->"807f1935-1d2b-436b-aa41-dc3307fd1ea4"],
Cell[8866, 264, 230, 4, 37, "Print",ExpressionUUID->"af28771c-7db4-4927-8958-b7366262ebc9"],
Cell[9099, 270, 243, 6, 37, "Print",ExpressionUUID->"4975ea1b-836c-4525-907e-c95b3efc555a"],
Cell[9345, 278, 245, 4, 37, "Print",ExpressionUUID->"c3251801-a793-4299-93b9-14382161f2cc"],
Cell[9593, 284, 243, 6, 37, "Print",ExpressionUUID->"3220305c-6b4f-4a0f-8c9a-ed44ba5c1832"],
Cell[9839, 292, 230, 4, 37, "Print",ExpressionUUID->"4fd2537f-65e6-4ea4-a529-b8a6a6d6045a"],
Cell[10072, 298, 277, 6, 37, "Print",ExpressionUUID->"b3a3aadf-db05-45eb-832d-d45437baae3d"],
Cell[10352, 306, 221, 4, 37, "Print",ExpressionUUID->"e00e72e5-4664-4dca-95c2-8f96c98da9e9"],
Cell[10576, 312, 679, 15, 37, "Print",ExpressionUUID->"4b967d0d-76e1-43f0-8759-bbe37ee45006"],
Cell[11258, 329, 313, 7, 37, "Print",ExpressionUUID->"9a562779-2e96-4f3b-9dfb-7a6e792b2166"],
Cell[11574, 338, 367, 10, 37, "Print",ExpressionUUID->"3920a314-0e9a-4974-aa55-9e45df69a950"],
Cell[11944, 350, 247, 4, 37, "Print",ExpressionUUID->"3d8037b0-6749-4c50-89ad-3e3a786ed123"],
Cell[12194, 356, 721, 18, 64, "Print",ExpressionUUID->"48081bd0-4842-46ff-bb8b-5afdb9737153"],
Cell[12918, 376, 388, 9, 37, "Print",ExpressionUUID->"0de99b6c-4f83-4518-be33-8deaedec142e"],
Cell[13309, 387, 397, 9, 37, "Print",ExpressionUUID->"480d27b8-ecc1-44f0-a0bb-1c2372ca31f3"],
Cell[13709, 398, 500, 10, 37, "Print",ExpressionUUID->"0f87c008-2400-4828-837f-07ffdab73e2f"],
Cell[14212, 410, 1002, 25, 221, "Print",ExpressionUUID->"131e96a6-042a-4658-b0d8-65d3ab4b1937"],
Cell[15217, 437, 229, 4, 37, "Print",ExpressionUUID->"94026f0c-97d5-472b-a9af-02f356bebe57"],
Cell[15449, 443, 247, 6, 37, "Print",ExpressionUUID->"1fea4c55-70ae-461a-88d3-5a0f143c73e3"],
Cell[15699, 451, 243, 4, 37, "Print",ExpressionUUID->"11e7ac0d-8b5b-4d33-87f6-d7d35ee3745d"],
Cell[15945, 457, 257, 6, 37, "Print",ExpressionUUID->"9404d6b1-40c2-4a12-9ac4-ec724ab94094"],
Cell[16205, 465, 228, 4, 37, "Print",ExpressionUUID->"b7fc53cb-4e18-4a6e-80d3-03d5cbb77933"],
Cell[16436, 471, 311, 8, 37, "Print",ExpressionUUID->"17014da0-7a8d-42c9-8bcf-a89c4a1ffecd"],
Cell[16750, 481, 219, 4, 37, "Print",ExpressionUUID->"2762943c-0543-4b39-af90-80b5a5c802f6"],
Cell[16972, 487, 682, 15, 37, "Print",ExpressionUUID->"c3a5dd7b-32be-4e85-b473-634b0656bcb9"],
Cell[17657, 504, 675, 15, 37, "Print",ExpressionUUID->"da3bc4b2-66c1-4df5-9d68-0479e63967c5"],
Cell[18335, 521, 680, 15, 37, "Print",ExpressionUUID->"b06b8416-4261-49ac-a3db-86557fe6cab5"],
Cell[19018, 538, 311, 7, 37, "Print",ExpressionUUID->"fde27f5d-1acd-410a-93a8-f14a41663fb2"],
Cell[19332, 547, 371, 10, 37, "Print",ExpressionUUID->"424b3f3e-f61b-445f-bf64-b9b9fc531d36"],
Cell[19706, 559, 247, 4, 37, "Print",ExpressionUUID->"7e963c71-5845-469c-8180-2c5faa462790"],
Cell[19956, 565, 720, 18, 64, "Print",ExpressionUUID->"22169333-a59e-440e-b39d-a49c4c6d451c"],
Cell[20679, 585, 388, 9, 37, "Print",ExpressionUUID->"0670e2c8-b114-42ac-a3f0-9b315a5f0841"],
Cell[21070, 596, 397, 9, 37, "Print",ExpressionUUID->"0a66d10f-9e5f-41f4-9ce5-f2cfad89af7a"],
Cell[21470, 607, 500, 10, 37, "Print",ExpressionUUID->"ed1df9f3-614b-42df-9a54-e41ac3c88660"],
Cell[21973, 619, 1003, 25, 221, "Print",ExpressionUUID->"2f212b49-46a3-40f5-8987-1484b0dd88d5"],
Cell[22979, 646, 230, 4, 37, "Print",ExpressionUUID->"ea57b51b-654d-43d7-b2c1-5091bf4d136a"],
Cell[23212, 652, 244, 6, 37, "Print",ExpressionUUID->"19dc9257-8fb6-4981-95d0-9539fdbaa9bd"],
Cell[23459, 660, 243, 4, 37, "Print",ExpressionUUID->"60415385-7987-4adf-ba42-2ffc1fd522bd"],
Cell[23705, 666, 257, 6, 37, "Print",ExpressionUUID->"61c2aa1a-ae6f-4127-9a25-d625186ca78f"],
Cell[23965, 674, 230, 4, 37, "Print",ExpressionUUID->"01f7a6a5-c0b3-411f-9d45-f986d1dde8cd"],
Cell[24198, 680, 311, 8, 37, "Print",ExpressionUUID->"d99b793e-17b9-4b46-8bfc-1f0cc4aaa4d1"],
Cell[24512, 690, 218, 4, 37, "Print",ExpressionUUID->"dd99ca9b-3bf3-4c11-b665-db3488ed15b0"],
Cell[24733, 696, 679, 15, 37, "Print",ExpressionUUID->"87552ecd-fc53-41b5-a2e0-6de88e599e3a"],
Cell[25415, 713, 677, 15, 37, "Print",ExpressionUUID->"983086bd-3fdf-4612-ae19-063c6738e559"],
Cell[26095, 730, 683, 15, 37, "Print",ExpressionUUID->"60676d84-2ef0-402d-a892-9b18f96f2f0c"],
Cell[26781, 747, 311, 7, 37, "Print",ExpressionUUID->"37756874-d785-4269-b2d0-e28b1e1c43e0"],
Cell[27095, 756, 369, 10, 37, "Print",ExpressionUUID->"f3cbd045-d02f-4350-8729-1d908fb10b62"],
Cell[27467, 768, 247, 4, 37, "Print",ExpressionUUID->"88bf1846-9c21-4af6-a9c6-126887936fac"],
Cell[27717, 774, 728, 18, 64, "Print",ExpressionUUID->"333933c8-5785-4bdc-9d16-3616a67a39a2"],
Cell[28448, 794, 388, 9, 37, "Print",ExpressionUUID->"7d8bb3cf-877d-461f-bfbe-ca7761a40bdf"],
Cell[28839, 805, 423, 10, 37, "Print",ExpressionUUID->"fae4dabc-43b3-401d-a52b-9d6115cb1dd9"],
Cell[29265, 817, 500, 10, 37, "Print",ExpressionUUID->"f07e16bd-e9fa-4e5b-9663-899394b28ac1"],
Cell[29768, 829, 1003, 25, 221, "Print",ExpressionUUID->"5a3048d9-4582-4d46-a965-7f0aa999d7a4"],
Cell[30774, 856, 230, 4, 37, "Print",ExpressionUUID->"4d06a514-63d7-42e5-8fab-c00f50cc5a5f"],
Cell[31007, 862, 254, 6, 37, "Print",ExpressionUUID->"87c89a74-4f4c-4155-ab84-995345f75bde"],
Cell[31264, 870, 243, 4, 37, "Print",ExpressionUUID->"8e572136-385d-4c42-a178-b55418b26596"],
Cell[31510, 876, 267, 6, 37, "Print",ExpressionUUID->"756e7de3-42a2-491f-8bac-5ddb2eb467d8"],
Cell[31780, 884, 230, 4, 37, "Print",ExpressionUUID->"2977c7f7-5763-4b47-9383-bc86e680d8fd"],
Cell[32013, 890, 340, 8, 37, "Print",ExpressionUUID->"8f4501d0-ba0f-4694-b31f-0fc64f8e3a34"],
Cell[32356, 900, 219, 4, 37, "Print",ExpressionUUID->"4810fcdc-c4e7-49ae-ba1e-d28c1855dd3e"],
Cell[32578, 906, 683, 15, 37, "Print",ExpressionUUID->"aeafc14e-fcf8-48fa-bc0f-6a9c023e3045"],
Cell[33264, 923, 683, 15, 37, "Print",ExpressionUUID->"5a59ffc3-adf9-4c7a-891a-02f46fca7e7f"],
Cell[33950, 940, 677, 15, 37, "Print",ExpressionUUID->"118961cc-b57b-46bb-94d4-53ea94735fc0"],
Cell[34630, 957, 685, 15, 37, "Print",ExpressionUUID->"3e2c3615-337b-4d9d-8191-3ac658acc105"],
Cell[35318, 974, 680, 15, 37, "Print",ExpressionUUID->"98abfd8e-42ad-4ca7-9c55-5d35c9879693"],
Cell[36001, 991, 680, 15, 37, "Print",ExpressionUUID->"1f853aad-dfa7-4f9e-bcfb-9b7dd0f770f2"],
Cell[36684, 1008, 311, 7, 37, "Print",ExpressionUUID->"4e9cad3a-cc0e-4a32-8d79-c178fabe2c0c"],
Cell[36998, 1017, 397, 11, 37, "Print",ExpressionUUID->"7934a0f2-9982-4c82-acd5-2d730322e6db"],
Cell[37398, 1030, 249, 4, 37, "Print",ExpressionUUID->"81f0e7d1-cafe-454a-827c-deaee47edaf1"],
Cell[37650, 1036, 720, 18, 64, "Print",ExpressionUUID->"47567e48-48e0-4371-815f-824930db18ad"],
Cell[38373, 1056, 387, 9, 37, "Print",ExpressionUUID->"c8088a6b-7626-469a-8d64-d1ce5cb85c78"],
Cell[38763, 1067, 425, 10, 37, "Print",ExpressionUUID->"35b27229-61fc-4a1a-b93e-18bc45783f61"],
Cell[39191, 1079, 502, 10, 37, "Print",ExpressionUUID->"20b5c476-5eb0-40cd-b941-d86c22d40c60"],
Cell[39696, 1091, 1003, 25, 221, "Print",ExpressionUUID->"1d0f4db5-92e4-4860-84c2-41d36974ccdc"],
Cell[40702, 1118, 230, 4, 37, "Print",ExpressionUUID->"b5329933-fa93-47ef-b7ca-e3fe60f94ab2"],
Cell[40935, 1124, 254, 6, 37, "Print",ExpressionUUID->"36bd2fc4-1b23-4ada-8b05-f0f6efb2faae"],
Cell[41192, 1132, 243, 4, 37, "Print",ExpressionUUID->"7ff7fb59-3e83-49b9-a98e-6dcc03ae9ccf"],
Cell[41438, 1138, 267, 6, 37, "Print",ExpressionUUID->"03e18cea-68fb-47c0-83ef-d6dc2311800f"],
Cell[41708, 1146, 227, 4, 37, "Print",ExpressionUUID->"c8200b04-9840-4294-9ebb-97ddd6ebaba6"],
Cell[41938, 1152, 338, 8, 37, "Print",ExpressionUUID->"5a44317e-4ac4-4f4a-90e8-a039456e246a"],
Cell[42279, 1162, 221, 4, 37, "Print",ExpressionUUID->"16e8d1ec-6885-443b-a128-49cb96763f1c"],
Cell[42503, 1168, 680, 15, 37, "Print",ExpressionUUID->"29819909-cc93-47f1-9593-615435ffddfc"],
Cell[43186, 1185, 677, 15, 37, "Print",ExpressionUUID->"2790aad0-4fa5-46bf-b18d-9da696116d86"],
Cell[43866, 1202, 677, 15, 37, "Print",ExpressionUUID->"c85f88e3-d90a-40aa-93ae-7fe4bd0397f4"],
Cell[44546, 1219, 678, 15, 37, "Print",ExpressionUUID->"2f4ffbeb-9230-4e8c-ba22-55ce4bc481f6"],
Cell[45227, 1236, 682, 15, 37, "Print",ExpressionUUID->"c059e918-0715-46c9-bf3d-078f2fc9767c"],
Cell[45912, 1253, 683, 15, 37, "Print",ExpressionUUID->"14353727-8b3f-4e07-90f4-56367511ef16"],
Cell[46598, 1270, 311, 7, 37, "Print",ExpressionUUID->"d97bb84f-66ed-43e1-a14a-301b35584db5"],
Cell[46912, 1279, 395, 11, 37, "Print",ExpressionUUID->"64662844-565f-411e-a67b-41b4a7dcb878"],
Cell[47310, 1292, 247, 4, 37, "Print",ExpressionUUID->"6110f28a-9685-41f8-a006-74af3431b827"],
Cell[47560, 1298, 718, 18, 64, "Print",ExpressionUUID->"3e74e1ce-2ead-461e-947e-5cc0ec9760c0"],
Cell[48281, 1318, 388, 9, 37, "Print",ExpressionUUID->"6dd2cc4f-f5ae-40dc-9de5-0153b08c4964"],
Cell[48672, 1329, 431, 10, 37, "Print",ExpressionUUID->"f8b921b2-b765-484d-ba64-b03324f084c5"],
Cell[49106, 1341, 500, 10, 37, "Print",ExpressionUUID->"1c8e4ab4-a840-4e1e-872c-648518b272d7"],
Cell[49609, 1353, 1005, 25, 221, "Print",ExpressionUUID->"342536a8-7ecb-4eaa-9d21-bbe9bd061681"],
Cell[50617, 1380, 230, 4, 37, "Print",ExpressionUUID->"bc9c049c-0bcb-40b0-b864-4787c2b665c5"],
Cell[50850, 1386, 255, 6, 37, "Print",ExpressionUUID->"47a84176-1fc5-4a59-99e3-4a517acda023"],
Cell[51108, 1394, 243, 4, 37, "Print",ExpressionUUID->"44961394-dcbf-46da-8f2e-3080e2c99d7a"],
Cell[51354, 1400, 286, 7, 37, "Print",ExpressionUUID->"6e3fe57e-3bd9-4eea-b90c-736277432061"],
Cell[51643, 1409, 228, 4, 37, "Print",ExpressionUUID->"b7028bbe-a4ad-4396-90bc-a704c604c2c6"],
Cell[51874, 1415, 366, 8, 37, "Print",ExpressionUUID->"717edde3-774b-40b6-86a5-4469fa43adf7"],
Cell[52243, 1425, 219, 4, 37, "Print",ExpressionUUID->"31377b34-4168-43b1-87ee-5b6b2e1b11f5"],
Cell[52465, 1431, 680, 15, 37, "Print",ExpressionUUID->"5ae2095d-4d17-431a-af92-b708dbcf364a"],
Cell[53148, 1448, 680, 15, 37, "Print",ExpressionUUID->"8e695ff1-d9b9-48d3-90bb-43cbafa304e9"],
Cell[53831, 1465, 682, 15, 37, "Print",ExpressionUUID->"785ff34a-f1ad-4d4d-a339-cd740c9d619f"],
Cell[54516, 1482, 677, 15, 37, "Print",ExpressionUUID->"b54dfff6-8a88-4662-9657-b2656ccaddd7"],
Cell[55196, 1499, 682, 15, 37, "Print",ExpressionUUID->"f14993f1-85c3-475c-aec4-e62fe541f438"],
Cell[55881, 1516, 683, 15, 37, "Print",ExpressionUUID->"acc907a3-2bbb-4582-a738-50b1dba262b1"],
Cell[56567, 1533, 680, 15, 37, "Print",ExpressionUUID->"1341d037-c887-44fb-8d96-7235f45b8a9d"],
Cell[57250, 1550, 685, 15, 37, "Print",ExpressionUUID->"419388b9-66a7-435a-ad95-37ed41fe6f0d"],
Cell[57938, 1567, 683, 15, 37, "Print",ExpressionUUID->"d76fc0c8-7105-4f0e-bff9-98415cb1b93e"],
Cell[58624, 1584, 683, 15, 37, "Print",ExpressionUUID->"94c595e7-c76d-4f8a-b653-c62bf06a5c9c"],
Cell[59310, 1601, 311, 7, 37, "Print",ExpressionUUID->"777f17cd-fd8a-4e2c-8a60-b2291b857b99"],
Cell[59624, 1610, 400, 11, 37, "Print",ExpressionUUID->"0e33d31d-c563-4f07-87e9-15323776442c"],
Cell[60027, 1623, 247, 4, 37, "Print",ExpressionUUID->"46f1c6d0-c9cf-4b10-80e8-84f4b11d69e8"],
Cell[60277, 1629, 725, 18, 64, "Print",ExpressionUUID->"4d011242-5a1b-48fa-87ff-d9ac44a823da"],
Cell[61005, 1649, 388, 9, 37, "Print",ExpressionUUID->"5b53b3ee-d9ac-4946-bafb-03ca6c23f07b"],
Cell[61396, 1660, 440, 10, 37, "Print",ExpressionUUID->"636aa2b4-9616-4cab-92e8-d53f6a7e724a"],
Cell[61839, 1672, 500, 10, 37, "Print",ExpressionUUID->"8ec07a3a-2ec3-4bdf-a7f3-495694058502"],
Cell[62342, 1684, 1003, 25, 221, "Print",ExpressionUUID->"64ce649a-b238-474f-9dff-708bfb4593ca"],
Cell[63348, 1711, 230, 4, 37, "Print",ExpressionUUID->"ba36eb09-f869-4688-8097-bf46bd3f37b9"],
Cell[63581, 1717, 263, 6, 37, "Print",ExpressionUUID->"ba411623-4171-408f-8538-5e9df24b6366"],
Cell[63847, 1725, 243, 4, 37, "Print",ExpressionUUID->"74497149-83d6-499d-b730-5bc5e50fbb65"],
Cell[64093, 1731, 290, 7, 37, "Print",ExpressionUUID->"49fc2bf0-5d2f-4976-ac8e-ed4287b79972"],
Cell[64386, 1740, 228, 4, 37, "Print",ExpressionUUID->"3f043e02-7432-42c4-a2ff-d72305dae13b"],
Cell[64617, 1746, 396, 9, 37, "Print",ExpressionUUID->"3f23cbf0-dde6-4c0b-ace8-e61ad4dbffe6"],
Cell[65016, 1757, 219, 4, 37, "Print",ExpressionUUID->"76def429-6d3f-4eb3-a8fb-e474a3c88fbb"],
Cell[65238, 1763, 683, 15, 37, "Print",ExpressionUUID->"d224015a-e7cd-4455-9ba2-7fc1fa8e342a"],
Cell[65924, 1780, 682, 15, 37, "Print",ExpressionUUID->"a765b665-11fb-4d28-a099-a8cc09697e3c"],
Cell[66609, 1797, 682, 15, 37, "Print",ExpressionUUID->"d5943ffe-daf2-4081-a3a2-45ac04c4b384"],
Cell[67294, 1814, 683, 15, 37, "Print",ExpressionUUID->"c3518f8f-43d9-4018-9f69-c90df851d8b5"],
Cell[67980, 1831, 682, 15, 37, "Print",ExpressionUUID->"63696bb0-871d-409c-b632-ec8f8d201f07"],
Cell[68665, 1848, 683, 15, 37, "Print",ExpressionUUID->"6a1cf098-0867-40a5-8768-c92918bb1ba4"],
Cell[69351, 1865, 685, 15, 37, "Print",ExpressionUUID->"6db06a69-129d-46d4-8e4d-97544a10768e"],
Cell[70039, 1882, 685, 15, 37, "Print",ExpressionUUID->"9b4bc113-92c1-4e0e-9e3f-b25f48828d26"],
Cell[70727, 1899, 683, 15, 37, "Print",ExpressionUUID->"be805f13-8ab5-4090-8612-279c483d73b0"],
Cell[71413, 1916, 683, 15, 37, "Print",ExpressionUUID->"6fe92b4e-bbb1-4d92-8b1e-1554877ce9de"],
Cell[72099, 1933, 685, 15, 37, "Print",ExpressionUUID->"0028bea0-b599-4a43-a2b9-33e31c6ccf92"],
Cell[72787, 1950, 683, 15, 37, "Print",ExpressionUUID->"b5e353f3-7c2d-4cfc-b036-a68a3d82d22c"],
Cell[73473, 1967, 683, 15, 37, "Print",ExpressionUUID->"3e142c6d-8340-4f8c-86b9-3e3de152f0a8"],
Cell[74159, 1984, 682, 15, 37, "Print",ExpressionUUID->"ad07f438-1798-4644-9898-dabe154fabcf"],
Cell[74844, 2001, 685, 15, 37, "Print",ExpressionUUID->"6de24d8e-b347-426b-88b8-851d6f184acc"],
Cell[75532, 2018, 311, 7, 37, "Print",ExpressionUUID->"167c7b41-74ad-418d-bf6e-2aec7b0806bd"],
Cell[75846, 2027, 407, 11, 37, "Print",ExpressionUUID->"d08a81ad-9e01-4ca6-bd80-80e34788f21d"],
Cell[76256, 2040, 247, 4, 37, "Print",ExpressionUUID->"2c441a24-a4de-4fa1-8d69-b47f07c3248d"],
Cell[76506, 2046, 720, 18, 64, "Print",ExpressionUUID->"5e705944-3128-480e-86a3-16bb75292a4a"]
}, Open  ]],
Cell[77241, 2067, 142, 2, 54, "Text",ExpressionUUID->"8b54dffa-8e21-49b5-a682-07023b00e999"],
Cell[77386, 2071, 983, 16, 400, "Text",ExpressionUUID->"f77fd227-6c62-474a-b82d-39fe00bdd1bb"],
Cell[78372, 2089, 181, 4, 54, "Text",ExpressionUUID->"aadf60b2-f268-4aee-a75e-9a546ff1106d"],
Cell[CellGroupData[{
Cell[78578, 2097, 160, 2, 47, "Input",ExpressionUUID->"0191a282-381b-4281-a82a-01c4fd343e60"],
Cell[78741, 2101, 311, 7, 37, "Print",ExpressionUUID->"d75cc5fe-c4e8-4512-b5ce-8a367af5a672"],
Cell[79055, 2110, 365, 10, 37, "Print",ExpressionUUID->"5ec892c8-b204-4086-b0ef-800420c66371"],
Cell[79423, 2122, 215, 3, 74, "Output",ExpressionUUID->"4f877bc3-e164-410c-a65f-0f7e8bbe6e2c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[79675, 2130, 363, 9, 133, "Input",ExpressionUUID->"491321cd-3ee5-4d53-8a7a-9adadcd02bfc"],
Cell[80041, 2141, 315, 7, 37, "Print",ExpressionUUID->"3d99bf88-2024-49aa-94f3-e477fe043655"],
Cell[80359, 2150, 369, 10, 37, "Print",ExpressionUUID->"7ce48f1b-3047-470c-a17c-40915eebae04"],
Cell[80731, 2162, 394, 9, 71, "Print",ExpressionUUID->"f7cacdde-4d05-4d70-98d4-849d9974418c"],
Cell[81128, 2173, 315, 7, 37, "Print",ExpressionUUID->"ba235362-08e7-4126-8459-710c26bb32eb"],
Cell[81446, 2182, 371, 10, 37, "Print",ExpressionUUID->"f3d28cf3-dc83-4e90-9bfa-811c3ba3c4ed"],
Cell[81820, 2194, 397, 9, 71, "Print",ExpressionUUID->"c6dc43c5-efeb-4c07-beca-0f824823d2ad"],
Cell[82220, 2205, 313, 7, 37, "Print",ExpressionUUID->"7e1541a6-8500-4ffa-814c-3c668aca5153"],
Cell[82536, 2214, 373, 10, 37, "Print",ExpressionUUID->"255206da-ee39-4d51-8292-9cc46b424982"],
Cell[82912, 2226, 397, 9, 71, "Print",ExpressionUUID->"bdd9fbed-014d-4ba4-863b-1fdf005c5ae3"],
Cell[83312, 2237, 313, 7, 37, "Print",ExpressionUUID->"ec5fa352-c4a6-4f39-b1f4-d1fc3adb0ac6"],
Cell[83628, 2246, 399, 11, 37, "Print",ExpressionUUID->"7f492d2a-3a8d-42bd-a065-9319903d5573"],
Cell[84030, 2259, 396, 9, 71, "Print",ExpressionUUID->"36f378dc-4511-4388-8dac-9b89641c7c4a"],
Cell[84429, 2270, 313, 7, 37, "Print",ExpressionUUID->"8167e219-d158-44ba-b6f0-b3c9017b4188"],
Cell[84745, 2279, 400, 11, 37, "Print",ExpressionUUID->"4b89e399-a41b-4b16-8a04-721cbf122e8d"],
Cell[85148, 2292, 397, 9, 71, "Print",ExpressionUUID->"f701b125-79cc-4998-afc2-92193dc0492b"],
Cell[85548, 2303, 315, 7, 37, "Print",ExpressionUUID->"3a5de997-a575-4cb1-9212-b4460daedfc0"],
Cell[85866, 2312, 400, 11, 37, "Print",ExpressionUUID->"47f08d71-80d5-49b5-aaf5-fa714b5ce076"],
Cell[86269, 2325, 399, 9, 71, "Print",ExpressionUUID->"2db93629-b818-4b87-9e6b-458ed0ab9a98"],
Cell[86671, 2336, 313, 7, 37, "Print",ExpressionUUID->"26c80789-0e92-4e32-9ed8-9249e60a29a6"],
Cell[86987, 2345, 409, 11, 37, "Print",ExpressionUUID->"4e682dd2-9745-4b3a-a88f-eab01a560149"],
Cell[87399, 2358, 397, 9, 71, "Print",ExpressionUUID->"b0f51a68-5537-4803-bcd8-aa4a07578678"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[87845, 2373, 190, 4, 69, "Subsubsection",ExpressionUUID->"66e34c8a-7580-44a5-935b-8836e432267b"],
Cell[88038, 2379, 198, 5, 54, "Text",ExpressionUUID->"107312f5-7813-4b1b-bcee-aa5545a19e4a"],
Cell[CellGroupData[{
Cell[88261, 2388, 138, 2, 47, "Input",ExpressionUUID->"b5ad5f73-3744-46fa-83c2-928c93be03d3"],
Cell[88402, 2392, 189, 2, 74, "Output",ExpressionUUID->"27f950dc-0f5b-4801-8911-a9216b3de478"]
}, Open  ]],
Cell[88606, 2397, 504, 10, 187, "Text",ExpressionUUID->"cb01a7b8-97ea-4174-9a91-121338f73899"],
Cell[89113, 2409, 314, 7, 116, "Text",ExpressionUUID->"e7c2ca17-1672-43a8-a5d4-77ff21c9778c"],
Cell[89430, 2418, 171, 2, 47, "Input",ExpressionUUID->"caaf747d-e6d7-4f36-b25f-960b78903644"],
Cell[89604, 2422, 293, 11, 247, "Input",ExpressionUUID->"9a8c58da-12bc-4fa2-a98e-57c3442b1a23"],
Cell[CellGroupData[{
Cell[89922, 2437, 162, 2, 47, "Input",ExpressionUUID->"f9a87104-33b9-4352-92d8-1227e0f452c9"],
Cell[90087, 2441, 744, 19, 57, "Print",ExpressionUUID->"662ac89c-2c66-4615-9309-797adb3c8f0c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[90868, 2465, 162, 2, 47, "Input",ExpressionUUID->"f1761510-e5e5-4fc1-9655-178729caa3a3"],
Cell[91033, 2469, 786, 20, 57, "Print",ExpressionUUID->"62c8c5a6-f8a6-4605-9989-2edd13f48cd8"]
}, Open  ]],
Cell[91834, 2492, 422, 9, 151, "Text",ExpressionUUID->"1dd4dddc-4a2d-421d-8409-1d6888f9f2f8"],
Cell[92259, 2503, 193, 5, 54, "Text",ExpressionUUID->"ee6e3eb8-bd76-42c8-856d-567b6bde59e7"],
Cell[CellGroupData[{
Cell[92477, 2512, 213, 5, 76, "Input",ExpressionUUID->"53a6af11-0002-4b4e-94a3-abd887eb03d7"],
Cell[92693, 2519, 284, 7, 37, "Print",ExpressionUUID->"17d93d1e-7948-4d3e-a8ed-9928a21d5c62"],
Cell[92980, 2528, 284, 7, 37, "Print",ExpressionUUID->"45968c82-ea4c-436d-baec-209028bb1e66"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[93313, 2541, 583, 12, 133, "Input",ExpressionUUID->"40b77697-23ac-4e90-96ee-6ef62c6f07df"],
Cell[93899, 2555, 279, 7, 37, "Print",ExpressionUUID->"a1c5197b-b2d4-41e1-b8cb-e2033354a6c7"],
Cell[94181, 2564, 241, 5, 37, "Print",ExpressionUUID->"22a114f3-1907-4edb-b986-0af7202bcfac"],
Cell[94425, 2571, 243, 5, 37, "Print",ExpressionUUID->"236b16cc-648b-4fbc-aa22-a8ba4722f732"],
Cell[94671, 2578, 363, 9, 37, "Print",ExpressionUUID->"6e708a03-6f89-42d8-a2e4-26deb83afd03"],
Cell[95037, 2589, 2650, 47, 420, "Output",ExpressionUUID->"7ccd070d-d15d-44a3-bae9-deab028d9f57"]
}, Open  ]],
Cell[CellGroupData[{
Cell[97724, 2641, 477, 10, 133, "Input",ExpressionUUID->"cdfde070-6886-40d1-b8f2-97acac1ec2d0"],
Cell[98204, 2653, 250, 6, 37, "Print",ExpressionUUID->"49864507-99d9-46c6-bfa5-85ec6bd25bb1"],
Cell[98457, 2661, 212, 4, 37, "Print",ExpressionUUID->"9ae911e1-3f2d-46d9-8cc5-78406d306a3a"],
Cell[98672, 2667, 216, 4, 37, "Print",ExpressionUUID->"91e13461-bc61-4f9c-ac15-3d49ca8c85fc"],
Cell[98891, 2673, 366, 9, 37, "Print",ExpressionUUID->"d8078000-73ad-4b44-b5b5-b20cb11c3af9"],
Cell[99260, 2684, 2688, 46, 420, "Output",ExpressionUUID->"d18b1905-b4ae-4260-b199-fff3cf5b2d87"]
}, Open  ]],
Cell[101963, 2733, 256, 7, 116, "Text",ExpressionUUID->"3ec622cb-0cc6-4771-affe-6ffd80a9a078"]
}
]
*)

