(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    123423,       3085]
NotebookOptionsPosition[    100193,       2813]
NotebookOutlinePosition[    100843,       2838]
CellTagsIndexPosition[    100800,       2835]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
CHR 2 November 1994
These are the examples that form part of my hydrodynamics paper.\
\>", "Text",
 ImageRegion->{{0, 1}, {0, 
  1}},ExpressionUUID->"1075b40e-736a-4c10-884a-be9ee475c4c7"],

Cell[TextData[{
 "CHR started 18 Feb 2020. Test of reproducibility for the ReScience 10-year \
reproducibility challenge (https://rescience.github.io/ten-years/). Chosen \
paper is Robert, C.H. (1995) Estimating Friction Coefficients of Mixed \
Globular/Chain Molecules, such as Protein/DNA Complexes. Biophys J. 69, \
840-48.\n\nThe code in this file came from the 1995 notebooks \"Example 2 \
1-over-r.nb\" and \"Example 2 dinucleosomes.nb\", extracted into \
Figure4_1995.nb preserving the original results. Reproduction trials were run \
using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 5.2 and 12.0.\nChanges from original code:\n- added dependence on library \
s6.1 (Get[...])\n- changed boolean variable MonteCarlo to montecarlo \
(MonteCarlo became a reserved word in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ")\n- modified call from doKirkwood to original doKirkwood0 from library \
s6.0\n- added comments\n\nResults to compare to originals are indicated by \
blue text boxes."
}], "Text",
 CellFrame->True,
 InitializationCell->True,
 FontColor->RGBColor[0, 0, 1],
 Background->GrayLevel[
  0.833326],ExpressionUUID->"3ad83b4d-c761-49ed-b0f4-ac55148621ae"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Get", "[", 
   RowBox[{"\"\<ReScience/\>\"", "<>", "\"\<s6.1_repro.m\>\""}], "]"}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[1]:=",ExpressionUUID->"ade6552f-33e7-413e-bfcc-dcb979c4bd13"],

Cell["\<\
Off[General::spell];
Off[General::spell1];\
\>", "Input",
 PageBreakWithin->Automatic,
 GroupPageBreakWithin->Automatic,
 InitializationCell->True,
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[2]:=",ExpressionUUID->"b34d097c-68a5-47ff-8bcf-52efa782d3a4"],

Cell[CellGroupData[{

Cell["Paper: Use Kirkwood and vary the number of turns", "Subsubsection",
 ImageRegion->{{0, 1}, {0, 
  1}},ExpressionUUID->"7c431f2e-0432-407b-bbd8-9127b3909b80"],

Cell["\<\
First clear the randomizing orientation matrix so that all of the chain \
pictures will be aligned in the same coordinate system.\
\>", "Text",
 ImageRegion->{{0, 1}, {0, 
  1}},ExpressionUUID->"6361f81e-d74a-4815-9857-f38cc6a73675"],

Cell["\<\
ClearAll[A0];
A0=Identity[3];\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[4]:=",ExpressionUUID->"9465f752-6915-4ca0-8ec1-dfd94d1f294e"],

Cell["\<\
Then define a couple of things to make the example easier to do... Here the \
DNA chain is of length template (bp), and there are nnukes nucleosomes on it. \
The nucleosomes begin and end the chain. The linker length in bp is \
calculated, and the \"chain\" defined.  Remember that the chain of segments \
includes one segment for each free basepair (the linker) and one segment for \
each nucleosome.\
\>", "Text",
 ImageRegion->{{0, 1}, {0, 
  1}},ExpressionUUID->"3a4028b0-dd0c-4069-a0d5-390604225bd4"],

Cell["\<\
linker[length_,t_]:=length-t wrapbp;
ns[length_,t_]:=2+linker[length,t];
chain[length_,t_]:={ns[length,t],{1,ns[length,t]}};\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[6]:=",ExpressionUUID->"278e0d01-d29f-4859-a92d-242302dd8b7b"],

Cell["\<\
template=354;
nnukes=2;\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[9]:=",ExpressionUUID->"b775c4bf-ccd8-4541-ab31-0344eb18866b"],

Cell[CellGroupData[{

Cell["\<\
turns=1.75;
chain[template,nnukes]\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[11]:=",ExpressionUUID->"5bd053b4-c1f9-4ead-b1dc-bd8963dda793"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"64", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "64"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.794912878421199*^9, 3.795416944067486*^9, 
  3.7954174205817537`*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"468c3ba0-26db-48bc-b1dc-450a6c781f7a"]
}, Open  ]],

Cell["\<\
Calculate the Kirkwood estimates of the frictional coefficients. This \
procedure (Kirkwood) does not require Monte Carlo trials, remember, so I \
don't need to bother anymore with A0.\
\>", "Text",
 ImageRegion->{{0, 1}, {0, 
  1}},ExpressionUUID->"e3ffeab5-bb4d-4f33-9419-86111dacc677"],

Cell["\<\
template=354;
nnukes=2;
collective=True;
test=True;
progress=True;
montecarlo=False;\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[13]:=",ExpressionUUID->"3616f58d-10b7-418e-90f0-a5e742521131"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
definebasepair;
Do[\tturns=turns0;
\tdefinenuke;
\tdefinephysicalnuke;
\tassembleelements[chain[template,nnukes]];
\tmakeAs[chain[template,nnukes]];
\tdoKirkwood[chain[template,nnukes]],
{turns0,1.5,2.0,0.1}];\
\>", "Input",
 CellChangeTimes->{3.7954170934361687`*^9},
 ImageRegion->{{0, 1}, {0, 1}},
 FontSize->10,
 CellLabel->"In[19]:=",ExpressionUUID->"da015576-7748-4ac6-9c18-7dd2fbc80fd2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n = \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" ; dl = \"\>", "\[InvisibleSpace]", 
   "21.08005770341709`"}],
  SequenceForm["n = ", 20, " ; dl = ", 21.08005770341709],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417420726742*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"8841c72a-da98-4c1a-a24e-c64f3ed92643"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Chain of \"\>", "\[InvisibleSpace]", "106", 
   "\[InvisibleSpace]", "\<\" segments,\"\>"}],
  SequenceForm["Chain of ", 106, " segments,"],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417420732115*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"8a15d5ac-8e59-4b5a-b7d1-48b281f0e3f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"with displacements at segments \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "106"}], "}"}]}],
  SequenceForm["with displacements at segments ", {1, 106}],
  Editable->False]], "Print",
 CellChangeTimes->{3.7954174207361183`*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"e9183e6e-f4b4-40a6-8590-25587c319b4a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Stokes offset \"\>", "\[InvisibleSpace]", 
   "3.0076424054539217`", "\[InvisibleSpace]", "\<\" A at \"\>", 
   "\[InvisibleSpace]", "50", "\[InvisibleSpace]", "\<\" bp\"\>"}],
  SequenceForm["Stokes offset ", 3.0076424054539217`, " A at ", 50, " bp"],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417420739821*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"21b5f7a0-a57a-44bd-b722-f50b2cdacff8"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
     {"\<\"persistence\\nlength\"\>", "510.`", "\<\"A\"\>"},
     {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
     {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
     {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
     {"\<\"turns\"\>", "1.5`", "\<\"turns\"\>"},
     {"\<\"pitch\"\>", 
      RowBox[{"-", "28.571`"}], "\<\"A/turn\"\>"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.795417420798689*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"530d4ac3-6ded-4db3-a744-547eea419735"],

Cell[BoxData["\<\"Array of chain lengths (bp)\"\>"], "Print",
 CellChangeTimes->{3.795417420811329*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"51db0381-a6c1-4007-a97a-afc50f127304"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "104", ",", "0"}], "}"}]], "Print",
 CellChangeTimes->{3.795417420815156*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"61a1b141-e22b-4b05-b69e-94c0bc0bf687"],

Cell[BoxData["\<\"Array of friction element positions (bp)\"\>"], "Print",
 CellChangeTimes->{3.795417420818532*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"c6eccaa1-9a43-4287-87fc-4c3f330c9b14"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "53", ",", "106"}], "}"}]], "Print",
 CellChangeTimes->{3.795417420823976*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"4b4c8dde-9d36-412f-91f5-90eb6fca7871"],

Cell[BoxData["\<\"Array of Stokes radii (A)\"\>"], "Print",
 CellChangeTimes->{3.795417420827388*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"4b06a105-2530-4647-a3b6-544425fe9d75"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "55.717081770182105`", ",", "56.266909332464884`", ",", 
   "55.717081770182105`"}], "}"}]], "Print",
 CellChangeTimes->{3.795417420830977*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"f72d2185-3196-4d10-bc4e-f0577f4f9a6e"],

Cell[BoxData["\<\"...doKirkwood...\"\>"], "Print",
 CellChangeTimes->{3.795417420834364*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"6721bd20-bc4f-4503-8442-6df92694a0c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "174.72278016856492`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "174.1142483570199`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 2, " ", 174.72278016856492`, " corrected:", 
   174.1142483570199],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417420838056*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"708723a7-6e9c-474e-9896-ef93001db35b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "328.7198554436895`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "324.39251104043234`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 3, " ", 328.7198554436895, " corrected:", 
   324.39251104043234`],
  Editable->False]], "Print",
 CellChangeTimes->{3.7954174208428183`*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"7aaa6499-d105-4939-b9eb-c76552cc0bff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "177.66872102126544`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "177.02689589602213`"}],
  SequenceForm[
  "i,j,rij:", "*", 2, " ", 3, " ", 177.66872102126544`, " corrected:", 
   177.02689589602213`],
  Editable->False]], "Print",
 CellChangeTimes->{3.7954174208489037`*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"1eb3716c-aa45-48cb-abe7-f0a45f91c48f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"np\"\>", ",", "\<\"nchain\"\>", ",", "\<\"mass1\"\>", 
   ",", "\<\"vbar1\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.795417420858347*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"48c9bedc-f942-466d-9d0c-d348de2a1056"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"106", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "106"}], "}"}]}], "}"}], ",", "354", ",", "450640", 
   ",", "0.6463074738150186`"}], "}"}]], "Print",
 CellChangeTimes->{3.795417420862914*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"4f461c8e-3eed-4ae3-9472-586f772ae08b"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1,s1}\"\>"], "Print",
 CellChangeTimes->{3.795417420867741*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"047d3fa5-d8f6-40ce-bba5-cc925e14c163"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"3.211668203237934`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"2.0854101928677802`*^-7", " ", "g"}], "s"], ",", 
     RowBox[{"1.2626422301711332`*^-12", " ", "s"}]}], "}"}]}],
  SequenceForm[
  "   ", {3.211668203237934*^-7 $CellContext`g/$CellContext`s, 
    2.0854101928677802`*^-7 $CellContext`g/$CellContext`s, 
    1.2626422301711332`*^-12 $CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417420872458*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"0d3ec3ef-208d-41f1-b736-5a7854f83cbb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n = \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" ; dl = \"\>", "\[InvisibleSpace]", 
   "22.45693170152919`"}],
  SequenceForm["n = ", 20, " ; dl = ", 22.45693170152919],
  Editable->False]], "Print",
 CellChangeTimes->{3.7954174208785877`*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"a2489aba-7bd4-41cb-9d98-d91e49424215"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Chain of \"\>", "\[InvisibleSpace]", "90", 
   "\[InvisibleSpace]", "\<\" segments,\"\>"}],
  SequenceForm["Chain of ", 90, " segments,"],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417420882876*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"2e40a306-2fc8-4cbe-894b-3bea602fcb9e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"with displacements at segments \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "90"}], "}"}]}],
  SequenceForm["with displacements at segments ", {1, 90}],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417420887314*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"7851b8a8-6179-47b3-b556-e1f3fcf4acd9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Stokes offset \"\>", "\[InvisibleSpace]", 
   "3.0076424054539217`", "\[InvisibleSpace]", "\<\" A at \"\>", 
   "\[InvisibleSpace]", "50", "\[InvisibleSpace]", "\<\" bp\"\>"}],
  SequenceForm["Stokes offset ", 3.0076424054539217`, " A at ", 50, " bp"],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417420891409*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"11ef62ab-d5f9-4de4-9bfa-2d8f3aa6b539"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
     {"\<\"persistence\\nlength\"\>", "510.`", "\<\"A\"\>"},
     {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
     {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
     {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
     {"\<\"turns\"\>", "1.6`", "\<\"turns\"\>"},
     {"\<\"pitch\"\>", 
      RowBox[{"-", "28.571`"}], "\<\"A/turn\"\>"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.7954174208960533`*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"1cf2ef35-7cd7-44b6-8615-5e11fa24aa35"],

Cell[BoxData["\<\"Array of chain lengths (bp)\"\>"], "Print",
 CellChangeTimes->{3.795417420901704*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"ddb4f18b-fbc1-4209-a53e-f52730032bb7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "88", ",", "0"}], "}"}]], "Print",
 CellChangeTimes->{3.795417420905574*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"057d6e9d-22d7-4621-91ae-e58ae37404ea"],

Cell[BoxData["\<\"Array of friction element positions (bp)\"\>"], "Print",
 CellChangeTimes->{3.795417420909123*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"96c2f3f5-4b4e-493a-b4cd-e602d09cbbd2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "45", ",", "90"}], "}"}]], "Print",
 CellChangeTimes->{3.795417420913196*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"5d5f04f8-3b50-432b-802f-8f01f3d3f114"],

Cell[BoxData["\<\"Array of Stokes radii (A)\"\>"], "Print",
 CellChangeTimes->{3.795417420917089*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"b26dcbb4-2b36-4d3c-a587-70c93bc31744"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "56.13938867267854`", ",", "50.5684928414747`", ",", "56.13938867267854`"}],
   "}"}]], "Print",
 CellChangeTimes->{3.7954174209211807`*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"b36366fa-4091-4a40-a268-87e77fcfc4d7"],

Cell[BoxData["\<\"...doKirkwood...\"\>"], "Print",
 CellChangeTimes->{3.7954174209251623`*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"0e36c4d3-f334-4356-b5b4-065b0e782d1c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "151.70139316032936`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "151.31818494183037`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 2, " ", 151.70139316032936`, " corrected:", 
   151.31818494183037`],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417420929249*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"9d7da79c-a9bf-402d-a53f-47d50e82f1f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "291.8241765333811`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "289.00128830593`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 3, " ", 291.8241765333811, " corrected:", 
   289.00128830593],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417420933692*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"2c2db20e-8fbf-4431-b908-3c303df11306"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "154.67255298398132`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "154.2645621351069`"}],
  SequenceForm[
  "i,j,rij:", "*", 2, " ", 3, " ", 154.67255298398132`, " corrected:", 
   154.2645621351069],
  Editable->False]], "Print",
 CellChangeTimes->{3.7954174209384003`*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"90824d94-45fb-40f9-99d6-6e0670f2e4d8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"np\"\>", ",", "\<\"nchain\"\>", ",", "\<\"mass1\"\>", 
   ",", "\<\"vbar1\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.795417420942979*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"1932a078-63ca-4d18-8397-8312f386e81e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"90", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "90"}], "}"}]}], "}"}], ",", "354", ",", "450640", 
   ",", "0.6463074738150186`"}], "}"}]], "Print",
 CellChangeTimes->{3.795417420947628*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"f3c38c6a-c8d4-4a0d-9fbe-88ca6ab7d60a"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1,s1}\"\>"], "Print",
 CellChangeTimes->{3.7954174209515*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"b315f574-1c20-4382-869a-5de89d217098"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"3.1187123056735237`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.9610145851540484`*^-7", " ", "g"}], "s"], ",", 
     RowBox[{"1.342737069208152`*^-12", " ", "s"}]}], "}"}]}],
  SequenceForm[
  "   ", {3.1187123056735237`*^-7 $CellContext`g/$CellContext`s, 
    1.9610145851540484`*^-7 $CellContext`g/$CellContext`s, 
    1.342737069208152*^-12 $CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417420955861*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"42f6682b-79f3-45c9-8547-dd18f8274408"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n = \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" ; dl = \"\>", "\[InvisibleSpace]", 
   "23.828322591761847`"}],
  SequenceForm["n = ", 20, " ; dl = ", 23.828322591761847`],
  Editable->False]], "Print",
 CellChangeTimes->{3.79541742096068*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"36cb4f54-00c6-40b9-9613-543dea5f219b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Chain of \"\>", "\[InvisibleSpace]", "74", 
   "\[InvisibleSpace]", "\<\" segments,\"\>"}],
  SequenceForm["Chain of ", 74, " segments,"],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417420965067*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"aafb49d2-1d1c-43c9-9e45-423ef9ed724e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"with displacements at segments \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "74"}], "}"}]}],
  SequenceForm["with displacements at segments ", {1, 74}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79541742096951*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"180fc54d-7076-47af-893d-e068ece5675b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Stokes offset \"\>", "\[InvisibleSpace]", 
   "3.0076424054539217`", "\[InvisibleSpace]", "\<\" A at \"\>", 
   "\[InvisibleSpace]", "50", "\[InvisibleSpace]", "\<\" bp\"\>"}],
  SequenceForm["Stokes offset ", 3.0076424054539217`, " A at ", 50, " bp"],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417420973775*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"474eb64e-d08c-4e01-8f08-55ff3dbd87e2"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
     {"\<\"persistence\\nlength\"\>", "510.`", "\<\"A\"\>"},
     {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
     {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
     {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
     {"\<\"turns\"\>", "1.7`", "\<\"turns\"\>"},
     {"\<\"pitch\"\>", 
      RowBox[{"-", "28.571`"}], "\<\"A/turn\"\>"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.795417420978595*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"53cad888-f3b9-44c1-bd44-e46de1e39c7f"],

Cell[BoxData["\<\"Array of chain lengths (bp)\"\>"], "Print",
 CellChangeTimes->{3.795417420984448*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"fcd44dda-f9ce-4001-99fb-4503e9cc851c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "72", ",", "0"}], "}"}]], "Print",
 CellChangeTimes->{3.79541742098801*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"100a40be-4312-4a63-9cc7-4261416f2b0c"],

Cell[BoxData["\<\"Array of friction element positions (bp)\"\>"], "Print",
 CellChangeTimes->{3.795417420991238*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"989f2cfa-d437-450f-8ca4-c5f3f9e27655"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "37", ",", "74"}], "}"}]], "Print",
 CellChangeTimes->{3.795417420994817*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"83aed88e-0376-40d0-bbc9-a779b127ec7e"],

Cell[BoxData["\<\"Array of Stokes radii (A)\"\>"], "Print",
 CellChangeTimes->{3.7954174209980707`*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"7781e9fd-bbeb-430e-a02b-662c6257ef91"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "56.55543582127602`", ",", "44.67712957198618`", ",", 
   "56.55543582127602`"}], "}"}]], "Print",
 CellChangeTimes->{3.7954174210022*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"0d80cdc4-7bd4-4cb4-afc8-3e6b7cac8be1"],

Cell[BoxData["\<\"...doKirkwood...\"\>"], "Print",
 CellChangeTimes->{3.795417421006445*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"c3a05784-2454-4906-a92a-15c2910f00b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "128.80902271110944`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "128.5880741737774`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 2, " ", 128.80902271110944`, " corrected:", 
   128.5880741737774],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417421014027*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"a471f3c1-a11d-4657-85ce-f5e64f34c703"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "241.53930091092656`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "239.93173142967242`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 3, " ", 241.53930091092656`, " corrected:", 
   239.93173142967242`],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417421018461*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"1bfc2400-b9c9-48fa-bf56-195353f7c6ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "131.78571038098897`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "131.5473725408056`"}],
  SequenceForm[
  "i,j,rij:", "*", 2, " ", 3, " ", 131.78571038098897`, " corrected:", 
   131.5473725408056],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417421023052*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"f39ccff1-d136-4ea9-96cb-c604345510ed"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"np\"\>", ",", "\<\"nchain\"\>", ",", "\<\"mass1\"\>", 
   ",", "\<\"vbar1\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.7954174210274057`*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"0402d08a-7768-40af-a8dc-fe8190340277"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"74", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "74"}], "}"}]}], "}"}], ",", "354", ",", "450640", 
   ",", "0.6463074738150186`"}], "}"}]], "Print",
 CellChangeTimes->{3.79541742103146*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"8b7c2a76-13ee-4376-a83d-86fbcc0e80f0"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1,s1}\"\>"], "Print",
 CellChangeTimes->{3.7954174210350113`*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"cdc05201-63a2-49d2-8fc4-7e52b8432c10"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"3.0218214926835236`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.8187282757404906`*^-7", " ", "g"}], "s"], ",", 
     RowBox[{"1.447784703117411`*^-12", " ", "s"}]}], "}"}]}],
  SequenceForm[
  "   ", {3.0218214926835236`*^-7 $CellContext`g/$CellContext`s, 
    1.8187282757404906`*^-7 $CellContext`g/$CellContext`s, 
    1.447784703117411*^-12 $CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417421039057*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"d762e49c-f873-48d7-b643-fc95690736e0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n = \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" ; dl = \"\>", "\[InvisibleSpace]", 
   "25.193895755258747`"}],
  SequenceForm["n = ", 20, " ; dl = ", 25.193895755258747`],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417421043663*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"914da682-530d-4ae2-bfd2-c8d04d38e6ae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Chain of \"\>", "\[InvisibleSpace]", "56", 
   "\[InvisibleSpace]", "\<\" segments,\"\>"}],
  SequenceForm["Chain of ", 56, " segments,"],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417421047655*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"aec2a856-7a75-4b84-ae10-f043b0ea2d23"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"with displacements at segments \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "56"}], "}"}]}],
  SequenceForm["with displacements at segments ", {1, 56}],
  Editable->False]], "Print",
 CellChangeTimes->{3.7954174210515203`*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"1262763e-a42d-4c7e-b6e8-05f84c205a88"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Stokes offset \"\>", "\[InvisibleSpace]", 
   "3.0076424054539217`", "\[InvisibleSpace]", "\<\" A at \"\>", 
   "\[InvisibleSpace]", "50", "\[InvisibleSpace]", "\<\" bp\"\>"}],
  SequenceForm["Stokes offset ", 3.0076424054539217`, " A at ", 50, " bp"],
  Editable->False]], "Print",
 CellChangeTimes->{3.79541742105552*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"c034f217-a460-4b36-8ea3-afdd760b516f"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
     {"\<\"persistence\\nlength\"\>", "510.`", "\<\"A\"\>"},
     {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
     {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
     {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
     {"\<\"turns\"\>", "1.8`", "\<\"turns\"\>"},
     {"\<\"pitch\"\>", 
      RowBox[{"-", "28.571`"}], "\<\"A/turn\"\>"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.795417421059841*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"25f76876-da39-47d3-b1ff-db81e7f0b05b"],

Cell[BoxData["\<\"Array of chain lengths (bp)\"\>"], "Print",
 CellChangeTimes->{3.7954174210653954`*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"6e4d4126-49c4-401f-9ca9-8c58056446d4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "54", ",", "0"}], "}"}]], "Print",
 CellChangeTimes->{3.795417421069069*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"dc298834-ade7-4e9f-853a-96a686a34a99"],

Cell[BoxData["\<\"Array of friction element positions (bp)\"\>"], "Print",
 CellChangeTimes->{3.7954174210724163`*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"57ddd0c0-5da3-4c21-b8b0-61e649978553"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "28", ",", "56"}], "}"}]], "Print",
 CellChangeTimes->{3.79541742107615*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"3ffe1c70-6393-4da3-88e3-e376b9626acd"],

Cell[BoxData["\<\"Array of Stokes radii (A)\"\>"], "Print",
 CellChangeTimes->{3.795417421079591*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"97619d44-7aa6-4a96-b728-8a544c3b7582"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "57.01628855207166`", ",", "37.789456544957446`", ",", 
   "57.01628855207166`"}], "}"}]], "Print",
 CellChangeTimes->{3.795417421083392*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"7d495470-03ad-4617-90b5-f2b7c6f6f17d"],

Cell[BoxData["\<\"...doKirkwood...\"\>"], "Print",
 CellChangeTimes->{3.795417421087029*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"047e0714-ed82-4ac4-ba54-b25ad445ffb4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "103.62250313014115`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "103.52061473479114`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 2, " ", 103.62250313014115`, " corrected:", 
   103.52061473479114`],
  Editable->False]], "Print",
 CellChangeTimes->{3.79541742109081*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"87a5682d-84d2-44b2-b0b5-f0be7d4b519f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "182.45515240804966`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "181.74752539968847`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 3, " ", 182.45515240804966`, " corrected:", 
   181.74752539968847`],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417421095232*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"7cc8cdc1-64cc-4a93-a750-31036ae5e63f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "106.5456911430546`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "106.43328474052215`"}],
  SequenceForm[
  "i,j,rij:", "*", 2, " ", 3, " ", 106.5456911430546, " corrected:", 
   106.43328474052215`],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417421099566*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"58b4db53-35fc-4739-82a6-fb196b879394"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"np\"\>", ",", "\<\"nchain\"\>", ",", "\<\"mass1\"\>", 
   ",", "\<\"vbar1\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.795417421103774*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"e4019281-71d1-449e-98e6-130e1cb0efa1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"56", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "56"}], "}"}]}], "}"}], ",", "354", ",", "450640", 
   ",", "0.6463074738150186`"}], "}"}]], "Print",
 CellChangeTimes->{3.79541742110793*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"243465ae-f5f1-4500-9ea6-4e7e7c2e8e67"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1,s1}\"\>"], "Print",
 CellChangeTimes->{3.795417421111453*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"a114c3f7-b0a0-4aa1-9f9e-e5b992788f8d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"2.907566360004712`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.636695171579222`*^-7", " ", "g"}], "s"], ",", 
     RowBox[{"1.6088072003068984`*^-12", " ", "s"}]}], "}"}]}],
  SequenceForm[
  "   ", {2.907566360004712*^-7 $CellContext`g/$CellContext`s, 
    1.636695171579222*^-7 $CellContext`g/$CellContext`s, 
    1.6088072003068984`*^-12 $CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417421115672*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"4f583887-1d59-4bdf-ab73-8a5df5fb1051"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n = \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" ; dl = \"\>", "\[InvisibleSpace]", 
   "26.553318034287496`"}],
  SequenceForm["n = ", 20, " ; dl = ", 26.553318034287496`],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417421120223*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"fe49ca39-f8ec-48cb-b774-3da6a10054a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Chain of \"\>", "\[InvisibleSpace]", "40", 
   "\[InvisibleSpace]", "\<\" segments,\"\>"}],
  SequenceForm["Chain of ", 40, " segments,"],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417421124359*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"bcce7de9-025c-4e53-8789-e0197d62dcbf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"with displacements at segments \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "40"}], "}"}]}],
  SequenceForm["with displacements at segments ", {1, 40}],
  Editable->False]], "Print",
 CellChangeTimes->{3.7954174211284113`*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"e37dd354-1ab3-49ad-8ce3-4d1290c6c50f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Stokes offset \"\>", "\[InvisibleSpace]", 
   "3.0076424054539217`", "\[InvisibleSpace]", "\<\" A at \"\>", 
   "\[InvisibleSpace]", "50", "\[InvisibleSpace]", "\<\" bp\"\>"}],
  SequenceForm["Stokes offset ", 3.0076424054539217`, " A at ", 50, " bp"],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417421132313*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"324f5a94-6a05-40aa-80c8-3a8857484090"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
     {"\<\"persistence\\nlength\"\>", "510.`", "\<\"A\"\>"},
     {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
     {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
     {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
     {"\<\"turns\"\>", "1.9`", "\<\"turns\"\>"},
     {"\<\"pitch\"\>", 
      RowBox[{"-", "28.571`"}], "\<\"A/turn\"\>"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.795417421136776*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"ef14a7a0-5597-47b9-a4ec-2906881b21ae"],

Cell[BoxData["\<\"Array of chain lengths (bp)\"\>"], "Print",
 CellChangeTimes->{3.795417421142277*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"f90ba78f-a608-4a12-9939-46577e2cc364"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "38", ",", "0"}], "}"}]], "Print",
 CellChangeTimes->{3.795417421146119*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"b5798ea0-004e-4824-9a1e-418155a039d4"],

Cell[BoxData["\<\"Array of friction element positions (bp)\"\>"], "Print",
 CellChangeTimes->{3.795417421149516*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"db8e60f4-5dbc-4682-9c48-05877230320f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "20", ",", "40"}], "}"}]], "Print",
 CellChangeTimes->{3.795417421153255*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"0f608d2f-8bdd-48c9-9232-4bc338f75835"],

Cell[BoxData["\<\"Array of Stokes radii (A)\"\>"], "Print",
 CellChangeTimes->{3.795417421156686*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"3e8c12d6-1bad-4e4c-b556-df25cc6e2a1d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "57.41977121149367`", ",", "31.115167995555677`", ",", 
   "57.41977121149367`"}], "}"}]], "Print",
 CellChangeTimes->{3.795417421160391*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"7431eb0a-34d0-4c5b-9c87-e53eb7f90b5d"],

Cell[BoxData["\<\"...doKirkwood...\"\>"], "Print",
 CellChangeTimes->{3.795417421163992*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"7403075b-7ef2-409e-bd3e-d4482493b586"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "82.71654800800671`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "82.67539365830228`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 2, " ", 82.71654800800671, " corrected:", 
   82.67539365830228],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417421167901*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"9ce3e74f-9120-4ec9-858f-0b76ff4780c8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "138.4420903239821`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "138.16493523154116`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 3, " ", 138.4420903239821, " corrected:", 
   138.16493523154116`],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417421172245*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"296c84c7-6f21-4929-ba77-f75df34f3d84"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "85.47155233210788`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "85.42457813891437`"}],
  SequenceForm[
  "i,j,rij:", "*", 2, " ", 3, " ", 85.47155233210788, " corrected:", 
   85.42457813891437],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417421176651*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"5e8772fc-90bb-41f9-be34-3929a19011d4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"np\"\>", ",", "\<\"nchain\"\>", ",", "\<\"mass1\"\>", 
   ",", "\<\"vbar1\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.795417421180894*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"e2d12a75-6794-4723-b8e6-f28c55c353f0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"40", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "40"}], "}"}]}], "}"}], ",", "354", ",", "450640", 
   ",", "0.6463074738150186`"}], "}"}]], "Print",
 CellChangeTimes->{3.7954174211851883`*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"a283fd7f-ea49-4d8d-85d2-1cc5e1a20f30"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1,s1}\"\>"], "Print",
 CellChangeTimes->{3.7954174211887903`*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"2e5a0798-9033-4db4-a296-66f4fdf819e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"2.795200379663064`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.463682572656602`*^-7", " ", "g"}], "s"], ",", 
     RowBox[{"1.7989740575820543`*^-12", " ", "s"}]}], "}"}]}],
  SequenceForm[
  "   ", {2.795200379663064*^-7 $CellContext`g/$CellContext`s, 
    1.463682572656602*^-7 $CellContext`g/$CellContext`s, 
    1.7989740575820543`*^-12 $CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.7954174211929007`*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"8beb1147-5265-4a86-89e9-a141b656ae82"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n = \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" ; dl = \"\>", "\[InvisibleSpace]", 
   "27.906257816099018`"}],
  SequenceForm["n = ", 20, " ; dl = ", 27.906257816099018`],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417421197569*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"85aeb96b-84b1-4e5c-b6a3-99746be44902"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Chain of \"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" segments,\"\>"}],
  SequenceForm["Chain of ", 24, " segments,"],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417421201535*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"519649e0-de27-4350-bcbc-3a6a45aa4136"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"with displacements at segments \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "24"}], "}"}]}],
  SequenceForm["with displacements at segments ", {1, 24}],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417421205635*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"7d8112e1-a1a1-4874-8803-7c3ed059e98f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Stokes offset \"\>", "\[InvisibleSpace]", 
   "3.0076424054539217`", "\[InvisibleSpace]", "\<\" A at \"\>", 
   "\[InvisibleSpace]", "50", "\[InvisibleSpace]", "\<\" bp\"\>"}],
  SequenceForm["Stokes offset ", 3.0076424054539217`, " A at ", 50, " bp"],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417421209564*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"eeaa3a5d-b42d-4d73-a8ea-2a6a51f9f7a5"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
     {"\<\"persistence\\nlength\"\>", "510.`", "\<\"A\"\>"},
     {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
     {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
     {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
     {"\<\"turns\"\>", "2.`", "\<\"turns\"\>"},
     {"\<\"pitch\"\>", 
      RowBox[{"-", "28.571`"}], "\<\"A/turn\"\>"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.79541742121404*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"f761e2ab-790d-43d9-b238-39cdd887619b"],

Cell[BoxData["\<\"Array of chain lengths (bp)\"\>"], "Print",
 CellChangeTimes->{3.795417421219529*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"36dc5ddb-77d2-4ff3-bd06-678a87a9e0d5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "22", ",", "0"}], "}"}]], "Print",
 CellChangeTimes->{3.795417421223338*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"2ddafc70-b02e-48fe-ac1c-48cb2264133e"],

Cell[BoxData["\<\"Array of friction element positions (bp)\"\>"], "Print",
 CellChangeTimes->{3.7954174212270737`*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"ad46bdf4-0487-4488-af0b-ec2c24aa35d7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "12", ",", "24"}], "}"}]], "Print",
 CellChangeTimes->{3.7954174212308903`*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"48fb77cc-2c31-455c-bdf8-a38c461868cb"],

Cell[BoxData["\<\"Array of Stokes radii (A)\"\>"], "Print",
 CellChangeTimes->{3.795417421234438*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"61d47c28-da07-4c49-9eda-359fdc1c5556"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "57.8176617294343`", ",", "23.795419679227102`", ",", "57.8176617294343`"}],
   "}"}]], "Print",
 CellChangeTimes->{3.795417421238256*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"c5988d8b-3867-4a9b-9f95-8cd7ecb48351"],

Cell[BoxData["\<\"...doKirkwood...\"\>"], "Print",
 CellChangeTimes->{3.795417421241838*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"ce502b22-54fb-46f9-b3ae-69b99ba3d831"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "65.09401328700297`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "65.08280493120671`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 2, " ", 65.09401328700297, " corrected:", 
   65.08280493120671],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417421245905*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"7d7dbf6f-d96f-4836-ac54-2739a6b30817"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "125.45610700514469`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "125.36569372404733`"}],
  SequenceForm[
  "i,j,rij:", "*", 1, " ", 3, " ", 125.45610700514469`, " corrected:", 
   125.36569372404733`],
  Editable->False]], "Print",
 CellChangeTimes->{3.7954174212503366`*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"0d4f27f7-9f3b-45a3-970c-3999628bfab0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "67.3880280384592`", 
   "\[InvisibleSpace]", "\<\" corrected:\"\>", "\[InvisibleSpace]", 
   "67.37428826502251`"}],
  SequenceForm[
  "i,j,rij:", "*", 2, " ", 3, " ", 67.3880280384592, " corrected:", 
   67.37428826502251],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417421254775*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"1172537f-0ed6-4dfb-a133-116fec6a0974"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"np\"\>", ",", "\<\"nchain\"\>", ",", "\<\"mass1\"\>", 
   ",", "\<\"vbar1\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.795417421259021*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"25f5bbc5-738b-4489-a6ee-b686cc5c891d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"24", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "24"}], "}"}]}], "}"}], ",", "354", ",", "450640", 
   ",", "0.6463074738150186`"}], "}"}]], "Print",
 CellChangeTimes->{3.795417421263237*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"531f7953-7161-482b-a641-3b43df35cdcf"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1,s1}\"\>"], "Print",
 CellChangeTimes->{3.795417421267007*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"f3c62eb1-5ea1-47cb-aec1-222e4e3d51c1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"2.670258911402653`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.3495608000921938`*^-7", " ", "g"}], "s"], ",", 
     RowBox[{"1.9510991846860903`*^-12", " ", "s"}]}], "}"}]}],
  SequenceForm[
  "   ", {2.670258911402653*^-7 $CellContext`g/$CellContext`s, 
    1.3495608000921938`*^-7 $CellContext`g/$CellContext`s, 
    1.9510991846860903`*^-12 $CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.795417421271289*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"cba1dadf-571b-4c08-ae1e-efc53b77a0ab"]
}, Open  ]],

Cell["\<\
These results, while close to the output in the original notebooks, do not \
exactly match it. The reason was a small chain-statistics correction applied \
to the doKirkwood function after the figure was made; here is the calculation \
with the original function, here named doKirkwood0, which has been added to \
the library file s6.1.\
\>", "Text",
 CellChangeTimes->{{3.795431868791305*^9, 3.7954319161246634`*^9}},
 FontColor->RGBColor[0, 0, 1],
 Background->GrayLevel[
  0.85],ExpressionUUID->"c070de73-0891-4c33-b89d-e2f6dffba53f"],

Cell[CellGroupData[{

Cell["\<\
definebasepair;
Do[\tturns=turns0;
\tdefinenuke;
\tdefinephysicalnuke;
\tassembleelements[chain[template,nnukes]];
\tmakeAs[chain[template,nnukes]];
\tdoKirkwood0[chain[template,nnukes]],
{turns0,1.5,2.0,0.1}];\
\>", "Input",
 CellChangeTimes->{3.7954170144974003`*^9, 3.7954173833258677`*^9},
 ImageRegion->{{0, 1}, {0, 1}},
 FontSize->10,
 CellLabel->"In[21]:=",ExpressionUUID->"db4141bf-47d1-4c4b-87ce-8fe12c6d9797"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n = \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" ; dl = \"\>", "\[InvisibleSpace]", 
   "21.08005770341709`"}],
  SequenceForm["n = ", 20, " ; dl = ", 21.08005770341709],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174213716803`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"2cc302a7-0484-4fa5-9747-eca17e2346bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Chain of \"\>", "\[InvisibleSpace]", "106", 
   "\[InvisibleSpace]", "\<\" segments,\"\>"}],
  SequenceForm["Chain of ", 106, " segments,"],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174213776608`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"ddae914c-6392-4bc4-9b35-a0ebd17bd8f0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"with displacements at segments \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "106"}], "}"}]}],
  SequenceForm["with displacements at segments ", {1, 106}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421382057*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"0fd9124e-1604-4d43-ade9-d969c6c3ddd6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Stokes offset \"\>", "\[InvisibleSpace]", 
   "3.0076424054539217`", "\[InvisibleSpace]", "\<\" A at \"\>", 
   "\[InvisibleSpace]", "50", "\[InvisibleSpace]", "\<\" bp\"\>"}],
  SequenceForm["Stokes offset ", 3.0076424054539217`, " A at ", 50, " bp"],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421386428*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"b2117b8d-d350-4863-aa48-0da96511fb60"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
     {"\<\"persistence\\nlength\"\>", "510.`", "\<\"A\"\>"},
     {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
     {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
     {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
     {"\<\"turns\"\>", "1.5`", "\<\"turns\"\>"},
     {"\<\"pitch\"\>", 
      RowBox[{"-", "28.571`"}], "\<\"A/turn\"\>"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421391204*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"751ab272-69fe-4eb3-9053-4ae6f599d49f"],

Cell[BoxData["\<\"Array of chain lengths (bp)\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174213972397`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"4b07b573-4f91-472e-9bd8-b078e2b7a8cd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "104", ",", "0"}], "}"}]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421401332*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"e33e0ccd-b853-49e8-8c27-c6934e6be0cc"],

Cell[BoxData["\<\"Array of friction element positions (bp)\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421405102*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"749da190-437f-4070-b747-cd0739a00b2a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "53", ",", "106"}], "}"}]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421409191*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"86a9abc8-85f2-4117-9660-d22e106f86e4"],

Cell[BoxData["\<\"Array of Stokes radii (A)\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421412936*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"50e5fb1b-eeeb-4c1b-9b13-413b2d7387c0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "55.717081770182105`", ",", "56.266909332464884`", ",", 
   "55.717081770182105`"}], "}"}]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421417091*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"c2767252-ec6c-4f79-8f6a-57df39effd3f"],

Cell[BoxData["\<\"\\n...doKirkwood...\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421421033*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"884074ec-7898-4f07-bdb5-c8bc71a779d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "174.72278016856492`"}],
  SequenceForm["i,j,rij:", "*", 1, " ", 2, " ", 174.72278016856492`],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421425473*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"7804e6b1-6c7e-410e-a4cc-de71d35b7684"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "328.7198554436895`"}],
  SequenceForm["i,j,rij:", "*", 1, " ", 3, " ", 328.7198554436895],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174214302073`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"880ffab2-ed0d-43e1-b9d8-aab645fda340"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "177.66872102126544`"}],
  SequenceForm["i,j,rij:", "*", 2, " ", 3, " ", 177.66872102126544`],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421435095*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"3a2ba6ac-4e93-4182-8d0d-9569c2f430ee"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1,s1}\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421439794*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"3e60bfb3-d600-4afa-90cd-2d27b4a905f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"3.211668203237934`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"2.0894984898700697`*^-7", " ", "g"}], "s"], ",", 
     RowBox[{"1.9510991846860903`*^-12", " ", "s"}]}], "}"}]}],
  SequenceForm[
  "   ", {3.211668203237934*^-7 $CellContext`g/$CellContext`s, 
    2.0894984898700697`*^-7 $CellContext`g/$CellContext`s, 
    1.9510991846860903`*^-12 $CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174214445457`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"8669f208-0595-40de-937d-10374688f047"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n = \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" ; dl = \"\>", "\[InvisibleSpace]", 
   "22.45693170152919`"}],
  SequenceForm["n = ", 20, " ; dl = ", 22.45693170152919],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174214497023`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"c9a30ec0-5bc2-4262-aaf3-013713a100c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Chain of \"\>", "\[InvisibleSpace]", "90", 
   "\[InvisibleSpace]", "\<\" segments,\"\>"}],
  SequenceForm["Chain of ", 90, " segments,"],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421454254*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"09ba9728-6041-48ea-8833-a0ac09f4362e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"with displacements at segments \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "90"}], "}"}]}],
  SequenceForm["with displacements at segments ", {1, 90}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421458572*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"2d2e1d8f-d117-4537-9da4-768be54b70b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Stokes offset \"\>", "\[InvisibleSpace]", 
   "3.0076424054539217`", "\[InvisibleSpace]", "\<\" A at \"\>", 
   "\[InvisibleSpace]", "50", "\[InvisibleSpace]", "\<\" bp\"\>"}],
  SequenceForm["Stokes offset ", 3.0076424054539217`, " A at ", 50, " bp"],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174214628487`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"b74473b3-9d85-429b-b2c7-a62e14647746"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
     {"\<\"persistence\\nlength\"\>", "510.`", "\<\"A\"\>"},
     {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
     {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
     {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
     {"\<\"turns\"\>", "1.6`", "\<\"turns\"\>"},
     {"\<\"pitch\"\>", 
      RowBox[{"-", "28.571`"}], "\<\"A/turn\"\>"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421467737*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"4e6f8b49-801d-4fef-a126-4f60718ac630"],

Cell[BoxData["\<\"Array of chain lengths (bp)\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421473666*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"26a71d0c-5e84-4fa7-baea-0e451a9c26e6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "88", ",", "0"}], "}"}]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421477892*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"0e881bcc-907b-4474-9392-31114942eb34"],

Cell[BoxData["\<\"Array of friction element positions (bp)\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174214817953`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"bcd29170-0d44-48d5-8040-36476ec3b54b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "45", ",", "90"}], "}"}]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421486026*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"afe71175-73fc-4753-88c9-539eeea60a0a"],

Cell[BoxData["\<\"Array of Stokes radii (A)\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174214898643`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"5cfc0351-398c-43d9-8236-761aad5e5ae7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "56.13938867267854`", ",", "50.5684928414747`", ",", "56.13938867267854`"}],
   "}"}]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421494306*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"0645540c-c610-40e3-a289-538be4095679"],

Cell[BoxData["\<\"\\n...doKirkwood...\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421498547*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"6252a816-8bb0-470c-95bd-2c9aa2742249"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "151.70139316032936`"}],
  SequenceForm["i,j,rij:", "*", 1, " ", 2, " ", 151.70139316032936`],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421503027*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"66bbfb40-7731-4fc5-a745-9bfa5f15183c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "291.8241765333811`"}],
  SequenceForm["i,j,rij:", "*", 1, " ", 3, " ", 291.8241765333811],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421507853*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"84a5dd78-2c7a-41c5-bc7d-1051d708b80f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "154.67255298398132`"}],
  SequenceForm["i,j,rij:", "*", 2, " ", 3, " ", 154.67255298398132`],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174215125017`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"f6705244-bc43-4471-a035-82da6e8b9ea5"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1,s1}\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421517054*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"1ae51596-ea0a-4d71-b6f1-9d9244860d15"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"3.1187123056735237`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.9640696531698172`*^-7", " ", "g"}], "s"], ",", 
     RowBox[{"1.9510991846860903`*^-12", " ", "s"}]}], "}"}]}],
  SequenceForm[
  "   ", {3.1187123056735237`*^-7 $CellContext`g/$CellContext`s, 
    1.9640696531698172`*^-7 $CellContext`g/$CellContext`s, 
    1.9510991846860903`*^-12 $CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421522355*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"e3ae828c-3d5b-4124-afc1-b99a3ec514ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n = \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" ; dl = \"\>", "\[InvisibleSpace]", 
   "23.828322591761847`"}],
  SequenceForm["n = ", 20, " ; dl = ", 23.828322591761847`],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421527726*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"b932ae68-d99c-4fe6-a0b0-b64c3e60917c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Chain of \"\>", "\[InvisibleSpace]", "74", 
   "\[InvisibleSpace]", "\<\" segments,\"\>"}],
  SequenceForm["Chain of ", 74, " segments,"],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174215320597`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"64b827ff-6185-4b5d-ae8e-371e2fed7b3e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"with displacements at segments \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "74"}], "}"}]}],
  SequenceForm["with displacements at segments ", {1, 74}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421536624*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"eb54d7c7-dbcf-4b0b-8daf-52081440df17"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Stokes offset \"\>", "\[InvisibleSpace]", 
   "3.0076424054539217`", "\[InvisibleSpace]", "\<\" A at \"\>", 
   "\[InvisibleSpace]", "50", "\[InvisibleSpace]", "\<\" bp\"\>"}],
  SequenceForm["Stokes offset ", 3.0076424054539217`, " A at ", 50, " bp"],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421540986*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"32500267-8cfb-4f8e-affb-e82c9322055f"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
     {"\<\"persistence\\nlength\"\>", "510.`", "\<\"A\"\>"},
     {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
     {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
     {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
     {"\<\"turns\"\>", "1.7`", "\<\"turns\"\>"},
     {"\<\"pitch\"\>", 
      RowBox[{"-", "28.571`"}], "\<\"A/turn\"\>"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421546194*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"6e33e21a-0853-434a-9042-d20f7adc45d4"],

Cell[BoxData["\<\"Array of chain lengths (bp)\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174215526133`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"03f632a0-b476-430e-b016-2e9bfdc36e41"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "72", ",", "0"}], "}"}]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421557046*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"48e1a991-b7a3-4a7d-b26d-6b6d0263dd5c"],

Cell[BoxData["\<\"Array of friction element positions (bp)\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174215609837`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"262013f4-823b-49c2-a8d2-367abab41530"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "37", ",", "74"}], "}"}]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421565318*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"f6fcc409-3c7b-4171-957a-5fb9891183ae"],

Cell[BoxData["\<\"Array of Stokes radii (A)\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174215692787`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"0e1bb8df-30f6-42f2-a806-f3452cd9bb40"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "56.55543582127602`", ",", "44.67712957198618`", ",", 
   "56.55543582127602`"}], "}"}]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174215735188`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"36ce3d6a-0c56-40ed-aee8-5be52562b0e3"],

Cell[BoxData["\<\"\\n...doKirkwood...\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.79541742157755*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"4e4cfe7e-ace4-4b02-a479-54308c5775ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "128.80902271110944`"}],
  SequenceForm["i,j,rij:", "*", 1, " ", 2, " ", 128.80902271110944`],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.79541742158189*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"367fd8a5-5141-4a68-96f4-57766b8f4bcf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "241.53930091092656`"}],
  SequenceForm["i,j,rij:", "*", 1, " ", 3, " ", 241.53930091092656`],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421586815*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"4529d435-ea2d-4ce1-b9ef-2173db5e6b0e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "131.78571038098897`"}],
  SequenceForm["i,j,rij:", "*", 2, " ", 3, " ", 131.78571038098897`],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421591736*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"9a593b82-491e-45a2-a77c-33a02ce998c2"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1,s1}\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421596538*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"aff20a05-43d2-4c69-8781-8ec95b7c0f7b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"3.0218214926835236`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.8209115471218405`*^-7", " ", "g"}], "s"], ",", 
     RowBox[{"1.9510991846860903`*^-12", " ", "s"}]}], "}"}]}],
  SequenceForm[
  "   ", {3.0218214926835236`*^-7 $CellContext`g/$CellContext`s, 
    1.8209115471218405`*^-7 $CellContext`g/$CellContext`s, 
    1.9510991846860903`*^-12 $CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421601315*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"bf65cb8e-117e-4086-ae92-fb5bf3fc9694"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n = \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" ; dl = \"\>", "\[InvisibleSpace]", 
   "25.193895755258747`"}],
  SequenceForm["n = ", 20, " ; dl = ", 25.193895755258747`],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421606553*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"50d94cfb-578b-4d77-aa08-a32cda360dc3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Chain of \"\>", "\[InvisibleSpace]", "56", 
   "\[InvisibleSpace]", "\<\" segments,\"\>"}],
  SequenceForm["Chain of ", 56, " segments,"],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421611026*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"b8a9e9e5-5295-4654-b1b0-7bff97a71e2f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"with displacements at segments \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "56"}], "}"}]}],
  SequenceForm["with displacements at segments ", {1, 56}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421615573*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"9db5de87-0c31-4429-9287-13be67585d17"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Stokes offset \"\>", "\[InvisibleSpace]", 
   "3.0076424054539217`", "\[InvisibleSpace]", "\<\" A at \"\>", 
   "\[InvisibleSpace]", "50", "\[InvisibleSpace]", "\<\" bp\"\>"}],
  SequenceForm["Stokes offset ", 3.0076424054539217`, " A at ", 50, " bp"],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421620175*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"10bf2b2b-d000-48bf-8022-4b69566e1eca"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
     {"\<\"persistence\\nlength\"\>", "510.`", "\<\"A\"\>"},
     {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
     {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
     {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
     {"\<\"turns\"\>", "1.8`", "\<\"turns\"\>"},
     {"\<\"pitch\"\>", 
      RowBox[{"-", "28.571`"}], "\<\"A/turn\"\>"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421625655*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"5de43ac3-7b3a-4d24-868c-eaca39ab4638"],

Cell[BoxData["\<\"Array of chain lengths (bp)\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.79541742167912*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"40a4fc86-074b-41f7-a79d-c7b460bab9cd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "54", ",", "0"}], "}"}]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421684204*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"1e67fe34-c405-41c8-abc7-b07f68848daa"],

Cell[BoxData["\<\"Array of friction element positions (bp)\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421687955*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"644dd507-559c-4d48-b417-fc7e18be830d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "28", ",", "56"}], "}"}]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421691744*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"8d6a73d1-8c27-4b6b-b055-0989a202d8c8"],

Cell[BoxData["\<\"Array of Stokes radii (A)\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421695488*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"58e4851e-cd65-4ae6-9ca6-d6f294413e97"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "57.01628855207166`", ",", "37.789456544957446`", ",", 
   "57.01628855207166`"}], "}"}]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421699216*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"b93793e9-41cd-4756-b4e4-af4116a4e494"],

Cell[BoxData["\<\"\\n...doKirkwood...\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.79541742170268*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"fd1727ee-e366-416f-82bf-1e6312210293"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "103.62250313014115`"}],
  SequenceForm["i,j,rij:", "*", 1, " ", 2, " ", 103.62250313014115`],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421706592*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"dcf13acf-ea17-48f0-8280-a43b8a0cddc6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "182.45515240804966`"}],
  SequenceForm["i,j,rij:", "*", 1, " ", 3, " ", 182.45515240804966`],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421710778*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"cd158f24-3ab7-48bc-9b0e-25235ea6205b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "106.5456911430546`"}],
  SequenceForm["i,j,rij:", "*", 2, " ", 3, " ", 106.5456911430546],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421715016*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"440eb11a-f8cc-4938-80d0-f9eca1717900"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1,s1}\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174217189827`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"6344940e-274b-4487-8112-aee7143dd311"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"2.907566360004712`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.638045807543929`*^-7", " ", "g"}], "s"], ",", 
     RowBox[{"1.9510991846860903`*^-12", " ", "s"}]}], "}"}]}],
  SequenceForm[
  "   ", {2.907566360004712*^-7 $CellContext`g/$CellContext`s, 
    1.638045807543929*^-7 $CellContext`g/$CellContext`s, 
    1.9510991846860903`*^-12 $CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421723154*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"392fa860-7a3c-4706-9112-1c6d1db1a3c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n = \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" ; dl = \"\>", "\[InvisibleSpace]", 
   "26.553318034287496`"}],
  SequenceForm["n = ", 20, " ; dl = ", 26.553318034287496`],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174217279787`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"bdf2b0b0-fee3-4596-bea6-89a614a4292b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Chain of \"\>", "\[InvisibleSpace]", "40", 
   "\[InvisibleSpace]", "\<\" segments,\"\>"}],
  SequenceForm["Chain of ", 40, " segments,"],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421731956*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"f9e12c3d-f545-473a-b2fa-8afa1783b0ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"with displacements at segments \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "40"}], "}"}]}],
  SequenceForm["with displacements at segments ", {1, 40}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174217359867`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"29801323-b9b5-40fc-a8a1-8760d0086e28"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Stokes offset \"\>", "\[InvisibleSpace]", 
   "3.0076424054539217`", "\[InvisibleSpace]", "\<\" A at \"\>", 
   "\[InvisibleSpace]", "50", "\[InvisibleSpace]", "\<\" bp\"\>"}],
  SequenceForm["Stokes offset ", 3.0076424054539217`, " A at ", 50, " bp"],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421740089*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"51d7b70d-f995-4e19-a3eb-b524a232ac5c"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
     {"\<\"persistence\\nlength\"\>", "510.`", "\<\"A\"\>"},
     {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
     {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
     {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
     {"\<\"turns\"\>", "1.9`", "\<\"turns\"\>"},
     {"\<\"pitch\"\>", 
      RowBox[{"-", "28.571`"}], "\<\"A/turn\"\>"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421744631*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"7d8f62d7-07c7-4211-a67c-eb7e98578f88"],

Cell[BoxData["\<\"Array of chain lengths (bp)\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421750101*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"b1cf39a9-ceb3-42be-932b-63325f1fed4b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "38", ",", "0"}], "}"}]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421753847*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"f1d58c52-2d3e-4567-9b5b-df541bf807be"],

Cell[BoxData["\<\"Array of friction element positions (bp)\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421757337*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"97d1d54f-5bd0-4879-9dc1-20ad621b8257"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "20", ",", "40"}], "}"}]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421761113*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"d8ee2e44-8d43-46e8-88bd-eb3308cfdeba"],

Cell[BoxData["\<\"Array of Stokes radii (A)\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174217646637`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"df74e2b5-a0e0-4064-aeb0-51bf13ec00ca"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "57.41977121149367`", ",", "31.115167995555677`", ",", 
   "57.41977121149367`"}], "}"}]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421768455*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"d02cfd24-6ce7-4dbe-8b4e-fa6b3f00adc8"],

Cell[BoxData["\<\"\\n...doKirkwood...\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421771983*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"752761c7-2bb4-449d-87a8-8cc22e9305ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "82.71654800800671`"}],
  SequenceForm["i,j,rij:", "*", 1, " ", 2, " ", 82.71654800800671],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174217758636`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"be7b4eca-786a-467d-ab73-3ea09c5b26a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "138.4420903239821`"}],
  SequenceForm["i,j,rij:", "*", 1, " ", 3, " ", 138.4420903239821],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174217802353`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"c9d4ea3e-6e13-4204-b29e-e8e72e202393"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "85.47155233210788`"}],
  SequenceForm["i,j,rij:", "*", 2, " ", 3, " ", 85.47155233210788],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421784504*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"65505d3a-f959-4212-8622-703555a9a305"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1,s1}\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421788663*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"096a3e97-2c12-4c4b-b354-dfbe72e3ae4f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"2.795200379663064`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.4644183163679808`*^-7", " ", "g"}], "s"], ",", 
     RowBox[{"1.9510991846860903`*^-12", " ", "s"}]}], "}"}]}],
  SequenceForm[
  "   ", {2.795200379663064*^-7 $CellContext`g/$CellContext`s, 
    1.4644183163679808`*^-7 $CellContext`g/$CellContext`s, 
    1.9510991846860903`*^-12 $CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421792841*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"c3c75457-13e3-4061-aa4a-c81535322981"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n = \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" ; dl = \"\>", "\[InvisibleSpace]", 
   "27.906257816099018`"}],
  SequenceForm["n = ", 20, " ; dl = ", 27.906257816099018`],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421797572*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"a902adcb-8493-4190-a635-ac128892342a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Chain of \"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" segments,\"\>"}],
  SequenceForm["Chain of ", 24, " segments,"],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421801549*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"f456b5e6-8269-4807-9459-ce8e6b03b0cd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"with displacements at segments \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "24"}], "}"}]}],
  SequenceForm["with displacements at segments ", {1, 24}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421805624*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"ee631f7d-d206-45d4-a235-4626eeb5ed0c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Stokes offset \"\>", "\[InvisibleSpace]", 
   "3.0076424054539217`", "\[InvisibleSpace]", "\<\" A at \"\>", 
   "\[InvisibleSpace]", "50", "\[InvisibleSpace]", "\<\" bp\"\>"}],
  SequenceForm["Stokes offset ", 3.0076424054539217`, " A at ", 50, " bp"],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174218095903`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"069996ae-d748-4ca9-95fb-45b7b11e1006"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"el0\"\>", "3.4`", "\<\"A\"\>"},
     {"\<\"persistence\\nlength\"\>", "510.`", "\<\"A\"\>"},
     {"\<\"repeat0\"\>", "10.4`", "\<\"bp/turn\"\>"},
     {"\<\"repeat1\"\>", "10.15`", "\<\"bp/turn\"\>"},
     {"\<\"radius\"\>", "44.916`", "\<\"A\"\>"},
     {"\<\"turns\"\>", "2.`", "\<\"turns\"\>"},
     {"\<\"pitch\"\>", 
      RowBox[{"-", "28.571`"}], "\<\"A/turn\"\>"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421814186*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"8fc3d1a3-368a-4e9f-8108-68681372944b"],

Cell[BoxData["\<\"Array of chain lengths (bp)\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421819762*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"a20ab612-e603-4075-9da7-442619a91c6c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "22", ",", "0"}], "}"}]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174218236*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"e7c924a8-9901-447a-a566-7c04a8e30f00"],

Cell[BoxData["\<\"Array of friction element positions (bp)\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174218312063`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"ae0b2745-6984-4838-9b52-7746af832aa1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "12", ",", "24"}], "}"}]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421835701*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"3ab329a8-1890-44c6-89c8-5d83d43d4304"],

Cell[BoxData["\<\"Array of Stokes radii (A)\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421839686*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"4b90cd64-150f-4d9f-94c2-3e78bf77a8c3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "57.8176617294343`", ",", "23.795419679227102`", ",", "57.8176617294343`"}],
   "}"}]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421843809*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"c1cac4fd-bd92-4572-88f5-f5e06643cc96"],

Cell[BoxData["\<\"\\n...doKirkwood...\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421848051*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"0405177b-8d8a-4a75-9597-756d4c8e4440"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "65.09401328700297`"}],
  SequenceForm["i,j,rij:", "*", 1, " ", 2, " ", 65.09401328700297],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421852397*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"47333fea-2056-44a2-8a6e-06a219ae6363"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "125.45610700514469`"}],
  SequenceForm["i,j,rij:", "*", 1, " ", 3, " ", 125.45610700514469`],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421857194*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"3f0b33f2-ec6a-4d23-92bd-d1b2efeb9f57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i,j,rij:\"\>", "\[InvisibleSpace]", "\<\"*\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "67.3880280384592`"}],
  SequenceForm["i,j,rij:", "*", 2, " ", 3, " ", 67.3880280384592],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.795417421861939*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"7fb989a8-d9ec-46d4-a664-e8ea694c584a"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1,s1}\"\>"], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174218665733`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"d8215182-2033-45c2-b719-8a0b0ea46f73"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"2.670258911402653`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.3498252097956967`*^-7", " ", "g"}], "s"], ",", 
     RowBox[{"1.9510991846860903`*^-12", " ", "s"}]}], "}"}]}],
  SequenceForm[
  "   ", {2.670258911402653*^-7 $CellContext`g/$CellContext`s, 
    1.3498252097956967`*^-7 $CellContext`g/$CellContext`s, 
    1.9510991846860903`*^-12 $CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491287864566*^9, 3.795416944337825*^9, 
  3.7954174218714523`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"aceefc6b-b54c-4a91-8382-733478dd29e7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
In the article, the f1 values calculated as above were stored in \"flist\" \
and converted to Dt values in the file \"Example 2 dinucleosomes.nb\" for \
Figure 4 using the following code. The calculated values are identical to \
those stored here (and plotted in that figure).\
\>", "Text",
 CellFrame->True,
 CellChangeTimes->{{3.794913010238946*^9, 3.7949130931811733`*^9}},
 FontColor->RGBColor[0, 0, 1],
 Background->GrayLevel[
  0.833326],ExpressionUUID->"84bae3b3-ac46-4383-b5ae-e13e048a6fcd"],

Cell["\<\
turnlist={1.5,1.6,1.7,1.8,1.9,2.0};
flist={2.0895,1.96407,1.82091,1.63805,1.46442,1.34983};
Dtlist=10^7 gettrans[flist 10^-7,296.15]/.
\t{cm->1,g->1,s->1}\
\>", "Input",
 GroupPageBreakWithin->Automatic,
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[23]:=",ExpressionUUID->"5038a395-cced-4109-8d50-d79ea3864bca"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.9565175875026726`", ",", "2.0814652731760246`", ",", 
   "2.245110136737584`", ",", "2.495737919530438`", ",", 
   "2.7916468629811346`", ",", "3.0286358275389005`"}], "}"}]], "Output",
 CellChangeTimes->{3.7949128792502213`*^9, 3.795416944912794*^9, 
  3.7954174225863333`*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"80a7ab39-0254-4ab4-865c-ac9a6af31731"]
},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{714, 822},
WindowMargins->{{Automatic, 144}, {Automatic, 112}},
ShowSelection->True,
ShowCellLabel->True,
ShowCellTags->False,
Magnification->1.5,
FrontEndVersion->"12.0 for Linux ARM (32-bit) (June 23, 2019)",
StyleDefinitions->"Default.nb",
PrivateNotebookOptions -> {"ColorPalette" -> {RGBColor, -1}},
RenderingOptions -> {"ObjectDithering" -> True},
RenderingOptions -> {"RasterDithering" -> False}
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 198, 5, 125, "Text",ExpressionUUID->"1075b40e-736a-4c10-884a-be9ee475c4c7"],
Cell[759, 27, 1190, 24, 861, "Text",ExpressionUUID->"3ad83b4d-c761-49ed-b0f4-ac55148621ae",
 InitializationCell->True],
Cell[1952, 53, 243, 6, 71, "Input",ExpressionUUID->"ade6552f-33e7-413e-bfcc-dcb979c4bd13",
 InitializationCell->True],
Cell[2198, 61, 267, 8, 100, "Input",ExpressionUUID->"b34d097c-68a5-47ff-8bcf-52efa782d3a4",
 PageBreakWithin->Automatic,
 InitializationCell->True],
Cell[CellGroupData[{
Cell[2490, 73, 163, 2, 110, "Subsubsection",ExpressionUUID->"7c431f2e-0432-407b-bbd8-9127b3909b80"],
Cell[2656, 77, 243, 5, 125, "Text",ExpressionUUID->"6361f81e-d74a-4815-9857-f38cc6a73675"],
Cell[2902, 84, 164, 5, 76, "Input",ExpressionUUID->"9465f752-6915-4ca0-8ec1-dfd94d1f294e"],
Cell[3069, 91, 515, 9, 303, "Text",ExpressionUUID->"3a4028b0-dd0c-4069-a0d5-390604225bd4"],
Cell[3587, 102, 259, 6, 104, "Input",ExpressionUUID->"278e0d01-d29f-4859-a92d-242302dd8b7b"],
Cell[3849, 110, 158, 5, 76, "Input",ExpressionUUID->"b775c4bf-ccd8-4541-ab31-0344eb18866b"],
Cell[CellGroupData[{
Cell[4032, 119, 170, 5, 76, "Input",ExpressionUUID->"5bd053b4-c1f9-4ead-b1dc-bd8963dda793"],
Cell[4205, 126, 294, 7, 74, "Output",ExpressionUUID->"468c3ba0-26db-48bc-b1dc-450a6c781f7a"]
}, Open  ]],
Cell[4514, 136, 298, 6, 161, "Text",ExpressionUUID->"e3ffeab5-bb4d-4f33-9419-86111dacc677"],
Cell[4815, 144, 220, 9, 190, "Input",ExpressionUUID->"3616f58d-10b7-418e-90f0-a5e742521131"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5072, 158, 404, 13, 199, "Input",ExpressionUUID->"da015576-7748-4ac6-9c18-7dd2fbc80fd2"],
Cell[5479, 173, 416, 10, 37, "Print",ExpressionUUID->"8841c72a-da98-4c1a-a24e-c64f3ed92643"],
Cell[5898, 185, 366, 9, 37, "Print",ExpressionUUID->"8a15d5ac-8e59-4b5a-b7d1-48b281f0e3f3"],
Cell[6267, 196, 405, 10, 37, "Print",ExpressionUUID->"e9183e6e-f4b4-40a6-8590-25587c319b4a"],
Cell[6675, 208, 478, 10, 37, "Print",ExpressionUUID->"21b5f7a0-a57a-44bd-b722-f50b2cdacff8"],
Cell[7156, 220, 980, 25, 221, "Print",ExpressionUUID->"530d4ac3-6ded-4db3-a744-547eea419735"],
Cell[8139, 247, 208, 4, 37, "Print",ExpressionUUID->"51db0381-a6c1-4007-a97a-afc50f127304"],
Cell[8350, 253, 231, 6, 37, "Print",ExpressionUUID->"61a1b141-e22b-4b05-b69e-94c0bc0bf687"],
Cell[8584, 261, 221, 4, 37, "Print",ExpressionUUID->"c6eccaa1-9a43-4287-87fc-4c3f330c9b14"],
Cell[8808, 267, 232, 6, 37, "Print",ExpressionUUID->"4b4c8dde-9d36-412f-91f5-90eb6fca7871"],
Cell[9043, 275, 206, 4, 37, "Print",ExpressionUUID->"4b06a105-2530-4647-a3b6-544425fe9d75"],
Cell[9252, 281, 290, 8, 37, "Print",ExpressionUUID->"f72d2185-3196-4d10-bc4e-f0577f4f9a6e"],
Cell[9545, 291, 197, 4, 37, "Print",ExpressionUUID->"6721bd20-bc4f-4503-8442-6df92694a0c2"],
Cell[9745, 297, 658, 15, 37, "Print",ExpressionUUID->"708723a7-6e9c-474e-9896-ef93001db35b"],
Cell[10406, 314, 660, 15, 37, "Print",ExpressionUUID->"7aaa6499-d105-4939-b9eb-c76552cc0bff"],
Cell[11069, 331, 663, 15, 37, "Print",ExpressionUUID->"1eb3716c-aa45-48cb-abe7-f0a45f91c48f"],
Cell[11735, 348, 289, 7, 37, "Print",ExpressionUUID->"48c9bedc-f942-466d-9d0c-d348de2a1056"],
Cell[12027, 357, 374, 11, 37, "Print",ExpressionUUID->"4f461c8e-3eed-4ae3-9472-586f772ae08b"],
Cell[12404, 370, 225, 4, 37, "Print",ExpressionUUID->"047d3fa5-d8f6-40ce-bba5-cc925e14c163"],
Cell[12632, 376, 703, 18, 97, "Print",ExpressionUUID->"0d3ec3ef-208d-41f1-b736-5a7854f83cbb"],
Cell[13338, 396, 418, 10, 37, "Print",ExpressionUUID->"a2489aba-7bd4-41cb-9d98-d91e49424215"],
Cell[13759, 408, 364, 9, 37, "Print",ExpressionUUID->"2e40a306-2fc8-4cbe-894b-3bea602fcb9e"],
Cell[14126, 419, 401, 10, 37, "Print",ExpressionUUID->"7851b8a8-6179-47b3-b556-e1f3fcf4acd9"],
Cell[14530, 431, 478, 10, 37, "Print",ExpressionUUID->"11ef62ab-d5f9-4de4-9bfa-2d8f3aa6b539"],
Cell[15011, 443, 982, 25, 221, "Print",ExpressionUUID->"1cf2ef35-7cd7-44b6-8615-5e11fa24aa35"],
Cell[15996, 470, 208, 4, 37, "Print",ExpressionUUID->"ddb4f18b-fbc1-4209-a53e-f52730032bb7"],
Cell[16207, 476, 230, 6, 37, "Print",ExpressionUUID->"057d6e9d-22d7-4621-91ae-e58ae37404ea"],
Cell[16440, 484, 221, 4, 37, "Print",ExpressionUUID->"96c2f3f5-4b4e-493a-b4cd-e602d09cbbd2"],
Cell[16664, 490, 231, 6, 37, "Print",ExpressionUUID->"5d5f04f8-3b50-432b-802f-8f01f3d3f114"],
Cell[16898, 498, 206, 4, 37, "Print",ExpressionUUID->"b26dcbb4-2b36-4d3c-a587-70c93bc31744"],
Cell[17107, 504, 287, 8, 37, "Print",ExpressionUUID->"b36366fa-4091-4a40-a268-87e77fcfc4d7"],
Cell[17397, 514, 199, 4, 37, "Print",ExpressionUUID->"0e36c4d3-f334-4356-b5b4-065b0e782d1c"],
Cell[17599, 520, 661, 15, 37, "Print",ExpressionUUID->"9d7da79c-a9bf-402d-a53f-47d50e82f1f1"],
Cell[18263, 537, 651, 15, 37, "Print",ExpressionUUID->"2c2db20e-8fbf-4431-b908-3c303df11306"],
Cell[18917, 554, 660, 15, 37, "Print",ExpressionUUID->"90824d94-45fb-40f9-99d6-6e0670f2e4d8"],
Cell[19580, 571, 289, 7, 37, "Print",ExpressionUUID->"1932a078-63ca-4d18-8397-8312f386e81e"],
Cell[19872, 580, 372, 11, 37, "Print",ExpressionUUID->"f3c38c6a-c8d4-4a0d-9fbe-88ca6ab7d60a"],
Cell[20247, 593, 223, 4, 37, "Print",ExpressionUUID->"b315f574-1c20-4382-869a-5de89d217098"],
Cell[20473, 599, 703, 18, 97, "Print",ExpressionUUID->"42f6682b-79f3-45c9-8547-dd18f8274408"],
Cell[21179, 619, 418, 10, 37, "Print",ExpressionUUID->"36cb4f54-00c6-40b9-9613-543dea5f219b"],
Cell[21600, 631, 364, 9, 37, "Print",ExpressionUUID->"aafb49d2-1d1c-43c9-9e45-423ef9ed724e"],
Cell[21967, 642, 400, 10, 37, "Print",ExpressionUUID->"180fc54d-7076-47af-893d-e068ece5675b"],
Cell[22370, 654, 478, 10, 37, "Print",ExpressionUUID->"474eb64e-d08c-4e01-8f08-55ff3dbd87e2"],
Cell[22851, 666, 980, 25, 221, "Print",ExpressionUUID->"53cad888-f3b9-44c1-bd44-e46de1e39c7f"],
Cell[23834, 693, 208, 4, 37, "Print",ExpressionUUID->"fcd44dda-f9ce-4001-99fb-4503e9cc851c"],
Cell[24045, 699, 229, 6, 37, "Print",ExpressionUUID->"100a40be-4312-4a63-9cc7-4261416f2b0c"],
Cell[24277, 707, 221, 4, 37, "Print",ExpressionUUID->"989f2cfa-d437-450f-8ca4-c5f3f9e27655"],
Cell[24501, 713, 231, 6, 37, "Print",ExpressionUUID->"83aed88e-0376-40d0-bbc9-a779b127ec7e"],
Cell[24735, 721, 208, 4, 37, "Print",ExpressionUUID->"7781e9fd-bbeb-430e-a02b-662c6257ef91"],
Cell[24946, 727, 285, 8, 37, "Print",ExpressionUUID->"0d80cdc4-7bd4-4cb4-afc8-3e6b7cac8be1"],
Cell[25234, 737, 197, 4, 37, "Print",ExpressionUUID->"c3a05784-2454-4906-a92a-15c2910f00b4"],
Cell[25434, 743, 658, 15, 37, "Print",ExpressionUUID->"a471f3c1-a11d-4657-85ce-f5e64f34c703"],
Cell[26095, 760, 661, 15, 37, "Print",ExpressionUUID->"1bfc2400-b9c9-48fa-bf56-195353f7c6ca"],
Cell[26759, 777, 658, 15, 37, "Print",ExpressionUUID->"f39ccff1-d136-4ea9-96cb-c604345510ed"],
Cell[27420, 794, 291, 7, 37, "Print",ExpressionUUID->"0402d08a-7768-40af-a8dc-fe8190340277"],
Cell[27714, 803, 371, 11, 37, "Print",ExpressionUUID->"8b7c2a76-13ee-4376-a83d-86fbcc0e80f0"],
Cell[28088, 816, 227, 4, 37, "Print",ExpressionUUID->"cdc05201-63a2-49d2-8fc4-7e52b8432c10"],
Cell[28318, 822, 703, 18, 97, "Print",ExpressionUUID->"d762e49c-f873-48d7-b643-fc95690736e0"],
Cell[29024, 842, 419, 10, 37, "Print",ExpressionUUID->"914da682-530d-4ae2-bfd2-c8d04d38e6ae"],
Cell[29446, 854, 364, 9, 37, "Print",ExpressionUUID->"aec2a856-7a75-4b84-ae10-f043b0ea2d23"],
Cell[29813, 865, 403, 10, 37, "Print",ExpressionUUID->"1262763e-a42d-4c7e-b6e8-05f84c205a88"],
Cell[30219, 877, 477, 10, 37, "Print",ExpressionUUID->"c034f217-a460-4b36-8ea3-afdd760b516f"],
Cell[30699, 889, 980, 25, 221, "Print",ExpressionUUID->"25f76876-da39-47d3-b1ff-db81e7f0b05b"],
Cell[31682, 916, 210, 4, 37, "Print",ExpressionUUID->"6e4d4126-49c4-401f-9ca9-8c58056446d4"],
Cell[31895, 922, 230, 6, 37, "Print",ExpressionUUID->"dc298834-ade7-4e9f-853a-96a686a34a99"],
Cell[32128, 930, 223, 4, 37, "Print",ExpressionUUID->"57ddd0c0-5da3-4c21-b8b0-61e649978553"],
Cell[32354, 936, 230, 6, 37, "Print",ExpressionUUID->"3ffe1c70-6393-4da3-88e3-e376b9626acd"],
Cell[32587, 944, 206, 4, 37, "Print",ExpressionUUID->"97619d44-7aa6-4a96-b728-8a544c3b7582"],
Cell[32796, 950, 288, 8, 37, "Print",ExpressionUUID->"7d495470-03ad-4617-90b5-f2b7c6f6f17d"],
Cell[33087, 960, 197, 4, 37, "Print",ExpressionUUID->"047e0714-ed82-4ac4-ba54-b25ad445ffb4"],
Cell[33287, 966, 660, 15, 37, "Print",ExpressionUUID->"87a5682d-84d2-44b2-b0b5-f0be7d4b519f"],
Cell[33950, 983, 661, 15, 37, "Print",ExpressionUUID->"7cc8cdc1-64cc-4a93-a750-31036ae5e63f"],
Cell[34614, 1000, 658, 15, 37, "Print",ExpressionUUID->"58b4db53-35fc-4739-82a6-fb196b879394"],
Cell[35275, 1017, 289, 7, 37, "Print",ExpressionUUID->"e4019281-71d1-449e-98e6-130e1cb0efa1"],
Cell[35567, 1026, 371, 11, 37, "Print",ExpressionUUID->"243465ae-f5f1-4500-9ea6-4e7e7c2e8e67"],
Cell[35941, 1039, 225, 4, 37, "Print",ExpressionUUID->"a114c3f7-b0a0-4aa1-9f9e-e5b992788f8d"],
Cell[36169, 1045, 700, 18, 64, "Print",ExpressionUUID->"4f583887-1d59-4bdf-ab73-8a5df5fb1051"],
Cell[36872, 1065, 419, 10, 37, "Print",ExpressionUUID->"fe49ca39-f8ec-48cb-b774-3da6a10054a4"],
Cell[37294, 1077, 364, 9, 37, "Print",ExpressionUUID->"bcce7de9-025c-4e53-8789-e0197d62dcbf"],
Cell[37661, 1088, 403, 10, 37, "Print",ExpressionUUID->"e37dd354-1ab3-49ad-8ce3-4d1290c6c50f"],
Cell[38067, 1100, 478, 10, 37, "Print",ExpressionUUID->"324f5a94-6a05-40aa-80c8-3a8857484090"],
Cell[38548, 1112, 980, 25, 221, "Print",ExpressionUUID->"ef14a7a0-5597-47b9-a4ec-2906881b21ae"],
Cell[39531, 1139, 208, 4, 37, "Print",ExpressionUUID->"f90ba78f-a608-4a12-9939-46577e2cc364"],
Cell[39742, 1145, 230, 6, 37, "Print",ExpressionUUID->"b5798ea0-004e-4824-9a1e-418155a039d4"],
Cell[39975, 1153, 221, 4, 37, "Print",ExpressionUUID->"db8e60f4-5dbc-4682-9c48-05877230320f"],
Cell[40199, 1159, 231, 6, 37, "Print",ExpressionUUID->"0f608d2f-8bdd-48c9-9232-4bc338f75835"],
Cell[40433, 1167, 206, 4, 37, "Print",ExpressionUUID->"3e8c12d6-1bad-4e4c-b556-df25cc6e2a1d"],
Cell[40642, 1173, 288, 8, 37, "Print",ExpressionUUID->"7431eb0a-34d0-4c5b-9c87-e53eb7f90b5d"],
Cell[40933, 1183, 197, 4, 37, "Print",ExpressionUUID->"7403075b-7ef2-409e-bd3e-d4482493b586"],
Cell[41133, 1189, 655, 15, 37, "Print",ExpressionUUID->"9ce3e74f-9120-4ec9-858f-0b76ff4780c8"],
Cell[41791, 1206, 658, 15, 37, "Print",ExpressionUUID->"296c84c7-6f21-4929-ba77-f75df34f3d84"],
Cell[42452, 1223, 655, 15, 37, "Print",ExpressionUUID->"5e8772fc-90bb-41f9-be34-3929a19011d4"],
Cell[43110, 1240, 289, 7, 37, "Print",ExpressionUUID->"e2d12a75-6794-4723-b8e6-f28c55c353f0"],
Cell[43402, 1249, 374, 11, 37, "Print",ExpressionUUID->"a283fd7f-ea49-4d8d-85d2-1cc5e1a20f30"],
Cell[43779, 1262, 227, 4, 37, "Print",ExpressionUUID->"2e5a0798-9033-4db4-a296-66f4fdf819e6"],
Cell[44009, 1268, 702, 18, 64, "Print",ExpressionUUID->"8beb1147-5265-4a86-89e9-a141b656ae82"],
Cell[44714, 1288, 419, 10, 37, "Print",ExpressionUUID->"85aeb96b-84b1-4e5c-b6a3-99746be44902"],
Cell[45136, 1300, 364, 9, 37, "Print",ExpressionUUID->"519649e0-de27-4350-bcbc-3a6a45aa4136"],
Cell[45503, 1311, 401, 10, 37, "Print",ExpressionUUID->"7d8112e1-a1a1-4874-8803-7c3ed059e98f"],
Cell[45907, 1323, 478, 10, 37, "Print",ExpressionUUID->"eeaa3a5d-b42d-4d73-a8ea-2a6a51f9f7a5"],
Cell[46388, 1335, 978, 25, 221, "Print",ExpressionUUID->"f761e2ab-790d-43d9-b238-39cdd887619b"],
Cell[47369, 1362, 208, 4, 37, "Print",ExpressionUUID->"36dc5ddb-77d2-4ff3-bd06-678a87a9e0d5"],
Cell[47580, 1368, 230, 6, 37, "Print",ExpressionUUID->"2ddafc70-b02e-48fe-ac1c-48cb2264133e"],
Cell[47813, 1376, 223, 4, 37, "Print",ExpressionUUID->"ad46bdf4-0487-4488-af0b-ec2c24aa35d7"],
Cell[48039, 1382, 233, 6, 37, "Print",ExpressionUUID->"48fb77cc-2c31-455c-bdf8-a38c461868cb"],
Cell[48275, 1390, 206, 4, 37, "Print",ExpressionUUID->"61d47c28-da07-4c49-9eda-359fdc1c5556"],
Cell[48484, 1396, 285, 8, 37, "Print",ExpressionUUID->"c5988d8b-3867-4a9b-9f95-8cd7ecb48351"],
Cell[48772, 1406, 197, 4, 37, "Print",ExpressionUUID->"ce502b22-54fb-46f9-b3ae-69b99ba3d831"],
Cell[48972, 1412, 655, 15, 37, "Print",ExpressionUUID->"7d7dbf6f-d96f-4836-ac54-2739a6b30817"],
Cell[49630, 1429, 663, 15, 37, "Print",ExpressionUUID->"0d4f27f7-9f3b-45a3-970c-3999628bfab0"],
Cell[50296, 1446, 653, 15, 37, "Print",ExpressionUUID->"1172537f-0ed6-4dfb-a133-116fec6a0974"],
Cell[50952, 1463, 289, 7, 37, "Print",ExpressionUUID->"25f5bbc5-738b-4489-a6ee-b686cc5c891d"],
Cell[51244, 1472, 372, 11, 37, "Print",ExpressionUUID->"531f7953-7161-482b-a641-3b43df35cdcf"],
Cell[51619, 1485, 225, 4, 37, "Print",ExpressionUUID->"f3c62eb1-5ea1-47cb-aec1-222e4e3d51c1"],
Cell[51847, 1491, 703, 18, 64, "Print",ExpressionUUID->"cba1dadf-571b-4c08-ae1e-efc53b77a0ab"]
}, Open  ]],
Cell[52565, 1512, 547, 10, 291, "Text",ExpressionUUID->"c070de73-0891-4c33-b89d-e2f6dffba53f"],
Cell[CellGroupData[{
Cell[53137, 1526, 429, 13, 199, "Input",ExpressionUUID->"db4141bf-47d1-4c4b-87ce-8fe12c6d9797"],
Cell[53569, 1541, 464, 11, 37, "Print",ExpressionUUID->"2cc302a7-0484-4fa5-9747-eca17e2346bd"],
Cell[54036, 1554, 414, 10, 37, "Print",ExpressionUUID->"ddae914c-6392-4bc4-9b35-a0ebd17bd8f0"],
Cell[54453, 1566, 449, 11, 37, "Print",ExpressionUUID->"0fd9124e-1604-4d43-ade9-d969c6c3ddd6"],
Cell[54905, 1579, 524, 11, 37, "Print",ExpressionUUID->"b2117b8d-d350-4863-aa48-0da96511fb60"],
Cell[55432, 1592, 1026, 26, 221, "Print",ExpressionUUID->"751ab272-69fe-4eb3-9053-4ae6f599d49f"],
Cell[56461, 1620, 256, 5, 37, "Print",ExpressionUUID->"4b07b573-4f91-472e-9bd8-b078e2b7a8cd"],
Cell[56720, 1627, 277, 7, 37, "Print",ExpressionUUID->"e33e0ccd-b853-49e8-8c27-c6934e6be0cc"],
Cell[57000, 1636, 267, 5, 37, "Print",ExpressionUUID->"749da190-437f-4070-b747-cd0739a00b2a"],
Cell[57270, 1643, 278, 7, 37, "Print",ExpressionUUID->"86a9abc8-85f2-4117-9660-d22e106f86e4"],
Cell[57551, 1652, 252, 5, 37, "Print",ExpressionUUID->"50e5fb1b-eeeb-4c1b-9b13-413b2d7387c0"],
Cell[57806, 1659, 336, 9, 37, "Print",ExpressionUUID->"c2767252-ec6c-4f79-8f6a-57df39effd3f"],
Cell[58145, 1670, 246, 5, 70, "Print",ExpressionUUID->"884074ec-7898-4f07-bdb5-c8bc71a779d2"],
Cell[58394, 1677, 568, 12, 37, "Print",ExpressionUUID->"7804e6b1-6c7e-410e-a4cc-de71d35b7684"],
Cell[58965, 1691, 567, 12, 37, "Print",ExpressionUUID->"880ffab2-ed0d-43e1-b9d8-aab645fda340"],
Cell[59535, 1705, 568, 12, 37, "Print",ExpressionUUID->"3a2ba6ac-4e93-4182-8d0d-9569c2f430ee"],
Cell[60106, 1719, 271, 5, 37, "Print",ExpressionUUID->"3e60bfb3-d600-4afa-90cd-2d27b4a905f3"],
Cell[60380, 1726, 751, 19, 64, "Print",ExpressionUUID->"8669f208-0595-40de-937d-10374688f047"],
Cell[61134, 1747, 464, 11, 37, "Print",ExpressionUUID->"c9a30ec0-5bc2-4262-aaf3-013713a100c0"],
Cell[61601, 1760, 410, 10, 37, "Print",ExpressionUUID->"09ba9728-6041-48ea-8833-a0ac09f4362e"],
Cell[62014, 1772, 447, 11, 37, "Print",ExpressionUUID->"2d2e1d8f-d117-4537-9da4-768be54b70b8"],
Cell[62464, 1785, 526, 11, 37, "Print",ExpressionUUID->"b74473b3-9d85-429b-b2c7-a62e14647746"],
Cell[62993, 1798, 1026, 26, 221, "Print",ExpressionUUID->"4e6f8b49-801d-4fef-a126-4f60718ac630"],
Cell[64022, 1826, 254, 5, 37, "Print",ExpressionUUID->"26a71d0c-5e84-4fa7-baea-0e451a9c26e6"],
Cell[64279, 1833, 276, 7, 37, "Print",ExpressionUUID->"0e881bcc-907b-4474-9392-31114942eb34"],
Cell[64558, 1842, 269, 5, 37, "Print",ExpressionUUID->"bcd29170-0d44-48d5-8040-36476ec3b54b"],
Cell[64830, 1849, 277, 7, 37, "Print",ExpressionUUID->"afe71175-73fc-4753-88c9-539eeea60a0a"],
Cell[65110, 1858, 254, 5, 37, "Print",ExpressionUUID->"5cfc0351-398c-43d9-8236-761aad5e5ae7"],
Cell[65367, 1865, 331, 9, 37, "Print",ExpressionUUID->"0645540c-c610-40e3-a289-538be4095679"],
Cell[65701, 1876, 246, 5, 70, "Print",ExpressionUUID->"6252a816-8bb0-470c-95bd-2c9aa2742249"],
Cell[65950, 1883, 568, 12, 37, "Print",ExpressionUUID->"66bbfb40-7731-4fc5-a745-9bfa5f15183c"],
Cell[66521, 1897, 565, 12, 37, "Print",ExpressionUUID->"84a5dd78-2c7a-41c5-bc7d-1051d708b80f"],
Cell[67089, 1911, 570, 12, 37, "Print",ExpressionUUID->"f6705244-bc43-4471-a035-82da6e8b9ea5"],
Cell[67662, 1925, 271, 5, 37, "Print",ExpressionUUID->"1ae51596-ea0a-4d71-b6f1-9d9244860d15"],
Cell[67936, 1932, 752, 19, 64, "Print",ExpressionUUID->"e3ae828c-3d5b-4124-afc1-b99a3ec514ab"],
Cell[68691, 1953, 465, 11, 37, "Print",ExpressionUUID->"b932ae68-d99c-4fe6-a0b0-b64c3e60917c"],
Cell[69159, 1966, 412, 10, 37, "Print",ExpressionUUID->"64b827ff-6185-4b5d-ae8e-371e2fed7b3e"],
Cell[69574, 1978, 447, 11, 37, "Print",ExpressionUUID->"eb54d7c7-dbcf-4b0b-8daf-52081440df17"],
Cell[70024, 1991, 524, 11, 37, "Print",ExpressionUUID->"32500267-8cfb-4f8e-affb-e82c9322055f"],
Cell[70551, 2004, 1026, 26, 221, "Print",ExpressionUUID->"6e33e21a-0853-434a-9042-d20f7adc45d4"],
Cell[71580, 2032, 256, 5, 37, "Print",ExpressionUUID->"03f632a0-b476-430e-b016-2e9bfdc36e41"],
Cell[71839, 2039, 276, 7, 37, "Print",ExpressionUUID->"48e1a991-b7a3-4a7d-b26d-6b6d0263dd5c"],
Cell[72118, 2048, 269, 5, 37, "Print",ExpressionUUID->"262013f4-823b-49c2-a8d2-367abab41530"],
Cell[72390, 2055, 277, 7, 37, "Print",ExpressionUUID->"f6fcc409-3c7b-4171-957a-5fb9891183ae"],
Cell[72670, 2064, 254, 5, 37, "Print",ExpressionUUID->"0e1bb8df-30f6-42f2-a806-f3452cd9bb40"],
Cell[72927, 2071, 335, 9, 37, "Print",ExpressionUUID->"36ce3d6a-0c56-40ed-aee8-5be52562b0e3"],
Cell[73265, 2082, 245, 5, 70, "Print",ExpressionUUID->"4e4cfe7e-ace4-4b02-a479-54308c5775ad"],
Cell[73513, 2089, 567, 12, 37, "Print",ExpressionUUID->"367fd8a5-5141-4a68-96f4-57766b8f4bcf"],
Cell[74083, 2103, 568, 12, 37, "Print",ExpressionUUID->"4529d435-ea2d-4ce1-b9ef-2173db5e6b0e"],
Cell[74654, 2117, 568, 12, 37, "Print",ExpressionUUID->"9a593b82-491e-45a2-a77c-33a02ce998c2"],
Cell[75225, 2131, 271, 5, 37, "Print",ExpressionUUID->"aff20a05-43d2-4c69-8781-8ec95b7c0f7b"],
Cell[75499, 2138, 752, 19, 64, "Print",ExpressionUUID->"bf65cb8e-117e-4086-ae92-fb5bf3fc9694"],
Cell[76254, 2159, 465, 11, 37, "Print",ExpressionUUID->"50d94cfb-578b-4d77-aa08-a32cda360dc3"],
Cell[76722, 2172, 410, 10, 37, "Print",ExpressionUUID->"b8a9e9e5-5295-4654-b1b0-7bff97a71e2f"],
Cell[77135, 2184, 447, 11, 37, "Print",ExpressionUUID->"9db5de87-0c31-4429-9287-13be67585d17"],
Cell[77585, 2197, 524, 11, 37, "Print",ExpressionUUID->"10bf2b2b-d000-48bf-8022-4b69566e1eca"],
Cell[78112, 2210, 1026, 26, 221, "Print",ExpressionUUID->"5de43ac3-7b3a-4d24-868c-eaca39ab4638"],
Cell[79141, 2238, 253, 5, 37, "Print",ExpressionUUID->"40a4fc86-074b-41f7-a79d-c7b460bab9cd"],
Cell[79397, 2245, 276, 7, 37, "Print",ExpressionUUID->"1e67fe34-c405-41c8-abc7-b07f68848daa"],
Cell[79676, 2254, 267, 5, 37, "Print",ExpressionUUID->"644dd507-559c-4d48-b417-fc7e18be830d"],
Cell[79946, 2261, 277, 7, 37, "Print",ExpressionUUID->"8d6a73d1-8c27-4b6b-b055-0989a202d8c8"],
Cell[80226, 2270, 252, 5, 37, "Print",ExpressionUUID->"58e4851e-cd65-4ae6-9ca6-d6f294413e97"],
Cell[80481, 2277, 334, 9, 37, "Print",ExpressionUUID->"b93793e9-41cd-4756-b4e4-af4116a4e494"],
Cell[80818, 2288, 245, 5, 70, "Print",ExpressionUUID->"fd1727ee-e366-416f-82bf-1e6312210293"],
Cell[81066, 2295, 568, 12, 37, "Print",ExpressionUUID->"dcf13acf-ea17-48f0-8280-a43b8a0cddc6"],
Cell[81637, 2309, 568, 12, 37, "Print",ExpressionUUID->"cd158f24-3ab7-48bc-9b0e-25235ea6205b"],
Cell[82208, 2323, 565, 12, 37, "Print",ExpressionUUID->"440eb11a-f8cc-4938-80d0-f9eca1717900"],
Cell[82776, 2337, 273, 5, 37, "Print",ExpressionUUID->"6344940e-274b-4487-8112-aee7143dd311"],
Cell[83052, 2344, 746, 19, 64, "Print",ExpressionUUID->"392fa860-7a3c-4706-9112-1c6d1db1a3c4"],
Cell[83801, 2365, 467, 11, 37, "Print",ExpressionUUID->"bdf2b0b0-fee3-4596-bea6-89a614a4292b"],
Cell[84271, 2378, 410, 10, 37, "Print",ExpressionUUID->"f9e12c3d-f545-473a-b2fa-8afa1783b0ea"],
Cell[84684, 2390, 449, 11, 37, "Print",ExpressionUUID->"29801323-b9b5-40fc-a8a1-8760d0086e28"],
Cell[85136, 2403, 524, 11, 37, "Print",ExpressionUUID->"51d7b70d-f995-4e19-a3eb-b524a232ac5c"],
Cell[85663, 2416, 1026, 26, 221, "Print",ExpressionUUID->"7d8f62d7-07c7-4211-a67c-eb7e98578f88"],
Cell[86692, 2444, 254, 5, 37, "Print",ExpressionUUID->"b1cf39a9-ceb3-42be-932b-63325f1fed4b"],
Cell[86949, 2451, 276, 7, 37, "Print",ExpressionUUID->"f1d58c52-2d3e-4567-9b5b-df541bf807be"],
Cell[87228, 2460, 267, 5, 37, "Print",ExpressionUUID->"97d1d54f-5bd0-4879-9dc1-20ad621b8257"],
Cell[87498, 2467, 277, 7, 37, "Print",ExpressionUUID->"d8ee2e44-8d43-46e8-88bd-eb3308cfdeba"],
Cell[87778, 2476, 254, 5, 37, "Print",ExpressionUUID->"df74e2b5-a0e0-4064-aeb0-51bf13ec00ca"],
Cell[88035, 2483, 334, 9, 37, "Print",ExpressionUUID->"d02cfd24-6ce7-4dbe-8b4e-fa6b3f00adc8"],
Cell[88372, 2494, 246, 5, 70, "Print",ExpressionUUID->"752761c7-2bb4-449d-87a8-8cc22e9305ab"],
Cell[88621, 2501, 567, 12, 37, "Print",ExpressionUUID->"be7b4eca-786a-467d-ab73-3ea09c5b26a3"],
Cell[89191, 2515, 567, 12, 37, "Print",ExpressionUUID->"c9d4ea3e-6e13-4204-b29e-e8e72e202393"],
Cell[89761, 2529, 565, 12, 37, "Print",ExpressionUUID->"65505d3a-f959-4212-8622-703555a9a305"],
Cell[90329, 2543, 271, 5, 37, "Print",ExpressionUUID->"096a3e97-2c12-4c4b-b354-dfbe72e3ae4f"],
Cell[90603, 2550, 749, 19, 64, "Print",ExpressionUUID->"c3c75457-13e3-4061-aa4a-c81535322981"],
Cell[91355, 2571, 465, 11, 37, "Print",ExpressionUUID->"a902adcb-8493-4190-a635-ac128892342a"],
Cell[91823, 2584, 410, 10, 37, "Print",ExpressionUUID->"f456b5e6-8269-4807-9459-ce8e6b03b0cd"],
Cell[92236, 2596, 447, 11, 37, "Print",ExpressionUUID->"ee631f7d-d206-45d4-a235-4626eeb5ed0c"],
Cell[92686, 2609, 526, 11, 37, "Print",ExpressionUUID->"069996ae-d748-4ca9-95fb-45b7b11e1006"],
Cell[93215, 2622, 1025, 26, 221, "Print",ExpressionUUID->"8fc3d1a3-368a-4e9f-8108-68681372944b"],
Cell[94243, 2650, 254, 5, 37, "Print",ExpressionUUID->"a20ab612-e603-4075-9da7-442619a91c6c"],
Cell[94500, 2657, 274, 7, 37, "Print",ExpressionUUID->"e7c924a8-9901-447a-a566-7c04a8e30f00"],
Cell[94777, 2666, 269, 5, 37, "Print",ExpressionUUID->"ae0b2745-6984-4838-9b52-7746af832aa1"],
Cell[95049, 2673, 277, 7, 37, "Print",ExpressionUUID->"3ab329a8-1890-44c6-89c8-5d83d43d4304"],
Cell[95329, 2682, 252, 5, 37, "Print",ExpressionUUID->"4b90cd64-150f-4d9f-94c2-3e78bf77a8c3"],
Cell[95584, 2689, 331, 9, 37, "Print",ExpressionUUID->"c1cac4fd-bd92-4572-88f5-f5e06643cc96"],
Cell[95918, 2700, 246, 5, 70, "Print",ExpressionUUID->"0405177b-8d8a-4a75-9597-756d4c8e4440"],
Cell[96167, 2707, 565, 12, 37, "Print",ExpressionUUID->"47333fea-2056-44a2-8a6e-06a219ae6363"],
Cell[96735, 2721, 568, 12, 37, "Print",ExpressionUUID->"3f0b33f2-ec6a-4d23-92bd-d1b2efeb9f57"],
Cell[97306, 2735, 563, 12, 37, "Print",ExpressionUUID->"7fb989a8-d9ec-46d4-a664-e8ea694c584a"],
Cell[97872, 2749, 273, 5, 37, "Print",ExpressionUUID->"d8215182-2033-45c2-b719-8a0b0ea46f73"],
Cell[98148, 2756, 751, 19, 64, "Print",ExpressionUUID->"aceefc6b-b54c-4a91-8382-733478dd29e7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[98936, 2780, 509, 10, 222, "Text",ExpressionUUID->"84bae3b3-ac46-4383-b5ae-e13e048a6fcd"],
Cell[99448, 2792, 324, 8, 133, "Input",ExpressionUUID->"5038a395-cced-4109-8d50-d79ea3864bca"]
}, Open  ]],
Cell[99787, 2803, 402, 8, 109, "Output",ExpressionUUID->"80a7ab39-0254-4ab4-865c-ac9a6af31731"]
}
]
*)

