(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    122751,       2892]
NotebookOptionsPosition[    106407,       2689]
NotebookOutlinePosition[    107056,       2714]
CellTagsIndexPosition[    107013,       2711]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
CHR   20 April 1993
Final calculations for Figure 2 in the hydrodynamics paper... I leave the \
Garcia de la Torre results at the values already calculated (in Figure 2 \
data-- \"Garcia de la Torre Final\" or Cricket Graph file) and use my \
Kirkwood subroutine on radii and intersphere distances calculated for this \
example, which is particularly simple since the DNA is treated in the rigid \
limit.\
\>", "SmallText",
 ImageRegion->{{0, 1}, {0, 
  1}},ExpressionUUID->"2a0a6e22-83d7-42bb-87af-32bbc5311837"],

Cell["\<\
Notice that the Yamakawa and Fujii equation for the sedimentation behavior in \
the limit of an infinite persistence length (rigid rod) reduces to 3.620 \
(log[masstrue]-3.552) For Kovacic and van Holde's fit to the DNA data.\
\>", "SmallText",
 ImageRegion->{{0, 1}, {0, 
  1}},ExpressionUUID->"07cc8f0e-0494-4ec4-b2f8-3a26d6015466"],

Cell[TextData[{
 "CHR started 18 Feb 2020. Test of reproducibility for the ReScience 10-year \
reproducibility challenge (https://rescience.github.io/ten-years/). Chosen \
paper is Robert, C.H. (1995) Estimating Friction Coefficients of Mixed \
Globular/Chain Molecules, such as Protein/DNA Complexes. Biophys J. 69, \
840-48.\n\nAll code in this file came from the original notebooks \"Example 2 \
1-over-r.nb\" and \"Example 2 dinucleosomes.nb\" and run using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 5.2 and 12.0.\nChanges:\n- lines were added to save results for lollipop \
and dumbbell assemblies and to plot them at the end of the notebook\n- \
semicolons at end of commands producing graphics were suppressed to see the \
output\n- removed the mysterious \"t=.\" command starting this notebook. A \
misprint? Or a sign of higher intelligence?\n\nResults to compare to \
originals are indicated by blue text boxes."
}], "Text",
 CellFrame->True,
 FontColor->RGBColor[0, 0, 1],
 Background->GrayLevel[
  0.833326],ExpressionUUID->"70f864aa-41b5-45d4-aa48-14efe28c603b"],

Cell["\<\
Off[General::spell];
Off[General::spell1];\
\>", "Input",
 PageBreakWithin->Automatic,
 GroupPageBreakWithin->Automatic,
 InitializationCell->True,
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[1]:=",ExpressionUUID->"1c861089-8971-4b93-aa83-d198f2a06979"],

Cell["\<\
NAvo=6.02 10^23;
ro=1.003;\t\t\t\t\t\t(* density, g/cm^3 *)
visc=0.01016;\t\t\t\t\t(* viscosity, g/(cm s) or \"Poise\" *)
persistencelength=34000 10^-8;\t(* persistence length, cm *)
el=3.4 10^-8;\t\t\t\t\t(* height of basepair, cm *)
lx={0,0,1};\t\t\t\t\t\t(* chain vector for a basepair *)
ctorsion=2.4 10^-19;\t\t\t(* not used-- ergs/radian? *)
mhistone=108500;\t\t\t\t(* octamer mol. weight, g/mole *)
mbp=660;\t\t\t\t\t\t(* basepair mol. weight, g/mole *)
vdna=0.55;\t\t\t\t\t\t(* specific volume of DNA, cm^3/g *)
vhistone=0.75;\t\t\t\t\t(* same but of protein, cm^3/g *)
score=10.7 10^-13;\t\t\t\t(* core sedimentation coeff, sec *)
dDNA=27 10^-8;\t\t\t\t\t(* Yamagawa-Fujii (Y-F) diam, cm *)
switchbp=50;\t\t\t\t\t(* point at which we switch from *)
\t\t\t\t\t\t\t\t(* Y-F to ellipsoid model, bp *)\
\>", "Input",
 InitializationCell->True,
 AspectRatioFixed->False,
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[3]:=",ExpressionUUID->"977f2be0-ffa2-4f12-8b29-cd79a234905c"],

Cell["\<\
doKirkwoodG:=Block[{i,j,sum,sumradii},
\t(*\tCalculates friction and sedimentation coefficients, f1 and
\t\ts1, according to the standard Kirkwood-Riseman theory.\t*)
\tsumradii=Sum[radii[[i]],{i,ntot}];
\tsum=0;
\tDo[\tDo[\trirj=N[radii[[i]] radii[[j]]];
\t\t\tIf[\trirj>0,
\t\t\t\tdelsum=rirj/rij[[i,j]],
\t\t\t\tdelsum=0
\t\t\t];
\t\t\tIf[\ttest,
\t\t\t\tPrint[\"   i,j,rij(cm): \",i,\" \",j,\" \",N[rij[[i,j]]]]
\t\t\t];
\t\t\tsum=sum+delsum,
\t\t{j,i+1,ntot}],
\t{i,ntot}];
\t(* Notice we only counted the distance of each pair once,
\t   but we multiplied by two to make up for it.  Now calculate
\t   frictional coeff and convert from basepairs to cm: *)
\tffree=6 Pi visc sumradii g/s;
\tf1=6 Pi visc sumradii/(1 + 2 sum/sumradii) g/s;
\tPrint[\"   Kirkwood results: {f free-draining,f1}\"];
\tPrint[\"   \",N[{ffree,f1}]]
];\
\>", "Input",
 InitializationCell->True,
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[18]:=",ExpressionUUID->"a3fc05c1-596d-4903-b136-5cbe08c3a53a"],

Cell["\<\
snaked[i_]:=Module[{j},
\ts1=3.620 (Log[10,i 660]-3.552) 10^-13;
\trstokes=((i 660) (1-vdna ro)/(NAvo s1))/(6 Pi visc)
];\
\>", "Input",
 InitializationCell->True,
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[19]:=",ExpressionUUID->"62222df1-7473-4492-91cf-58976cb8aaf5"],

Cell["\<\
Define radii of rigid-model DNA spheres and of globular region in cm:\
\>", "Text",
 ImageRegion->{{0, 1}, {0, 
  1}},ExpressionUUID->"610c079a-48f2-4055-bd63-c1cc43fa2a31"],

Cell["\<\
r1=57 10^-8;
r2=16.534 10^-8; (*\tEqual volume achieved
\t\t\t\t\tby r2=Sqrt[3/2] 13.5 A *)\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[20]:=",ExpressionUUID->"c67f137b-eb9a-4295-8cbe-6a4233622174"],

Cell["Values of the ratio L = length/r1 to use in the comparison.", "Text",
 AspectRatioFixed->False,
 ImageRegion->{{0, 1}, {0, 
  1}},ExpressionUUID->"db9d08d1-9e8b-417e-a737-2c8957138ca8"],

Cell["\<\
(*\tValues of length/r1 to use in comparison and corresponding
\tnumbers of basepairs: *)
lengthp={3,4,5,6,8,10,12,14,16};
nbasepairs=(lengthp r1)/(3.4 10^-8);\
\>", "Input",
 AspectRatioFixed->False,
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[22]:=",ExpressionUUID->"153c6721-d0ea-40b6-8c57-3c89c16d393c"],

Cell[CellGroupData[{

Cell["nbasepairs", "Input",
 AspectRatioFixed->False,
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[25]:=",ExpressionUUID->"dff6ad5f-2314-4407-b946-e22830ae080a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "50.29411764705882`", ",", "67.05882352941177`", ",", "83.8235294117647`", 
   ",", "100.58823529411764`", ",", "134.11764705882354`", ",", 
   "167.6470588235294`", ",", "201.17647058823528`", ",", 
   "234.70588235294116`", ",", "268.2352941176471`"}], "}"}]], "Output",
 CellChangeTimes->{3.7949127483898163`*^9, 3.7952683189790277`*^9, 
  3.800177189459919*^9, 3.800181930981*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"e286b613-6163-4fa3-bef5-e6378d3ef18c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"test", "=", "False"}], ";"}]], "Input",
 CellLabel->"In[26]:=",ExpressionUUID->"8804ab71-13ed-464a-a4ac-6a70c4a62bd2"],

Cell[TextData[StyleBox["LOLLIPOPS",
 FontFamily->"Geneva",
 FontSize->14]], "Text",
 AspectRatioFixed->False,
 ImageRegion->{{0, 1}, {0, 
  1}},ExpressionUUID->"8d8c80bd-811f-4bde-8704-5040ab27573c"],

Cell[CellGroupData[{

Cell["\<\
f1Kirk={};
f1robert={};
frictionratio={};
rij={};
Do[
\tPrint[nbasepairs[[k]],\" bp spacer\"];
\t
\tPrint[\"My model:\"];
\tntot=2;
\tsnaked[nbasepairs[[k]]];
\tradii={r1,rstokes};
\trij={{0,r1 + lengthp[[k]] r1/2},{r1 + lengthp[[k]] r1/2,0}};
\tdoKirkwoodG;
\tf1robert=Append[f1robert,f1];

\tPrint[\"Kirk's model:\"];\t
\tntot=lengthp[[k]]+1;
\tradii={r1};
\tDo[radii=Append[radii,r2],{i,lengthp[[k]]}];
\trij=Table[0,{i,ntot},{j,ntot}];
\tDo[ Do[\t
\t\t\trij[[i,j]]=radii[[i]] + (j-i-1) 2 r2 + r2,
\t\t{j,i+1,ntot}],
\t{i,ntot}];
\tdoKirkwoodG;
\tf1Kirk=Append[f1Kirk,N[f1]],

{k,Length[lengthp]}];\
\>", "Input",
 AspectRatioFixed->False,
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[27]:=",ExpressionUUID->"a9134c89-3784-460e-9780-6fd109d8f463"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"50.29411764705882`", "\[InvisibleSpace]", "\<\" bp spacer\"\>"}],
  SequenceForm[50.29411764705882, " bp spacer"],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931177455*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"8de170d1-d21d-4bbf-beca-4be858910db3"],

Cell[BoxData["\<\"My model:\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931182681*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"6d9636ac-cfd3-4174-8777-fdc5883b3854"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.8001819311863728`*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"0fc3b615-05ae-48e9-a370-4e44298daa41"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"1.7963443598900903`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.367236774947633`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {1.7963443598900903`*^-7 $CellContext`g/$CellContext`s, 
    1.367236774947633*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931190798*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"0315ffc9-36b4-4cb0-a65a-069ece8eb4c8"],

Cell[BoxData["\<\"Kirk's model:\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931194832*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"f19ba4b6-5bf2-4b0c-9f3e-09d0affad841"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931198143*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"ec419610-1500-4a72-b50f-c5080e9eb1ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"2.0415507661134405`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.0629414798301575`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {2.0415507661134405`*^-7 $CellContext`g/$CellContext`s, 
    1.0629414798301575`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931202075*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"60159124-d32f-4844-9bd2-28048cdf2ea5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"67.05882352941177`", "\[InvisibleSpace]", "\<\" bp spacer\"\>"}],
  SequenceForm[67.05882352941177, " bp spacer"],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931206595*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"2a6b1d66-10b5-4ffb-9d73-acc4f08e1a10"],

Cell[BoxData["\<\"My model:\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931210299*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"03d74aae-b582-4000-bd7c-5410727144d3"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.8001819312136393`*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"a475f116-ade0-4cc1-9fa3-0262b98b2806"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"1.923943874264986`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.4932693345698687`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {1.923943874264986*^-7 $CellContext`g/$CellContext`s, 
    1.4932693345698687`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.8001819312175817`*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"988e681d-b820-4c4f-953d-4eec73c30878"],

Cell[BoxData["\<\"Kirk's model:\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.8001819312220087`*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"1047bcf5-2fdc-40ba-90c4-c94023ee223f"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931225627*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"0424a385-15cb-4eb6-a0fe-e6e3032d72cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"2.3581958606418703`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.1061862133255019`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {2.3581958606418703`*^-7 $CellContext`g/$CellContext`s, 
    1.1061862133255019`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931229539*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"043f5792-5dcc-48ac-b67e-77bd9de5f692"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"83.8235294117647`", "\[InvisibleSpace]", "\<\" bp spacer\"\>"}],
  SequenceForm[83.8235294117647, " bp spacer"],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931233775*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"bb01584e-6ca5-45cb-8876-10304ef067e9"],

Cell[BoxData["\<\"My model:\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931237626*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"95abf50d-35f9-4742-a9c2-108a9540255e"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931241315*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"2b0209ed-234d-4929-a4ad-1f5a5675330d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"2.0473628117810054`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.6162281809839142`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {2.0473628117810054`*^-7 $CellContext`g/$CellContext`s, 
    1.6162281809839142`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.8001819312452106`*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"d4ddf2ed-f66f-43f4-a3d5-4dcec39bf79a"],

Cell[BoxData["\<\"Kirk's model:\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.8001819312493134`*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"3aa47b5d-8bd4-4702-8e00-9ed418176017"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931253092*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"1cb06f15-e3c7-4018-9ce4-c8433ea50b2e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"2.6748409551702996`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.1579215268571271`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {2.6748409551702996`*^-7 $CellContext`g/$CellContext`s, 
    1.1579215268571271`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931257182*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"7ea176ee-935f-476c-b2fb-c5f44c74a350"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"100.58823529411764`", "\[InvisibleSpace]", "\<\" bp spacer\"\>"}],
  SequenceForm[100.58823529411764`, " bp spacer"],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931261581*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"3898ab42-c5ca-424d-90d3-361476eb8064"],

Cell[BoxData["\<\"My model:\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931265172*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"90bf75c1-426c-4414-a496-a5835578f92e"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.8001819312689867`*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"9d8ac8f0-8058-4dea-a59a-a73c9b8f5e21"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"2.1670113313068928`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.7362080970893914`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {2.1670113313068928`*^-7 $CellContext`g/$CellContext`s, 
    1.7362080970893914`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931273085*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"d5995678-073a-47af-b2c8-a7b3ad5706a0"],

Cell[BoxData["\<\"Kirk's model:\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931277123*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"bf60a824-8868-4fcf-9c27-1e1a1348081d"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.8001819312806168`*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"928f96ed-a607-457c-a8fc-5ba74090b627"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"2.9914860496987284`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.2142871178933508`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {2.9914860496987284`*^-7 $CellContext`g/$CellContext`s, 
    1.2142871178933508`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931284861*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"a3b4f48a-3733-4d63-aa52-7fee47e44782"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"134.11764705882354`", "\[InvisibleSpace]", "\<\" bp spacer\"\>"}],
  SequenceForm[134.11764705882354`, " bp spacer"],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931289309*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"46431cbf-92e3-48a3-a3a6-f0809527a53f"],

Cell[BoxData["\<\"My model:\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931292817*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"4c747b72-e6ab-44e8-a382-af85ebb1e543"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931296193*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"bb6d6b49-1a35-43ba-8b5e-423b1cbed67e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"2.3970601528697356`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.9682867019165014`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {2.3970601528697356`*^-7 $CellContext`g/$CellContext`s, 
    1.9682867019165014`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931300501*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"4550c92d-550c-4f83-b662-efe75668638b"],

Cell[BoxData["\<\"Kirk's model:\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.80018193130472*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"bed48aeb-ed66-4440-acf0-19162b17ae0a"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.8001819313081284`*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"8687761a-e77f-4561-9f9e-2af7465599cd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"3.6247762387555875`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.3337841072825942`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {3.6247762387555875`*^-7 $CellContext`g/$CellContext`s, 
    1.3337841072825942`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931312077*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"a7777602-a732-40ca-a821-1a1d0c2c94e0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"167.6470588235294`", "\[InvisibleSpace]", "\<\" bp spacer\"\>"}],
  SequenceForm[167.6470588235294, " bp spacer"],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931316751*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"928fd954-bd09-4634-b180-e37c30ee861d"],

Cell[BoxData["\<\"My model:\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931320475*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"28016caa-556c-4d04-8c3a-c19521aee06a"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.8001819313239183`*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"951da11a-b493-434a-a568-172ab946d9f0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"2.6174262145411754`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"2.1915722001004071`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {2.6174262145411754`*^-7 $CellContext`g/$CellContext`s, 
    2.1915722001004071`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931328011*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"4ca60293-769a-4514-b071-b36dca8c580f"],

Cell[BoxData["\<\"Kirk's model:\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931332488*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"c25e349c-01c2-4fdb-88a1-5b0d4721612c"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931336131*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"d98b5218-dfd8-4503-b2b0-ac54ac2a454f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"4.258066427812447`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.4569452943609173`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {4.258066427812447*^-7 $CellContext`g/$CellContext`s, 
    1.4569452943609173`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931340172*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"6789d297-9798-46d9-b193-1f1e7c37abdd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"201.17647058823528`", "\[InvisibleSpace]", "\<\" bp spacer\"\>"}],
  SequenceForm[201.17647058823528`, " bp spacer"],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931344421*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"cba6f593-d1fd-4b48-8d6d-be7557d0bb69"],

Cell[BoxData["\<\"My model:\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931348324*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"e8aca33d-20f1-4a59-b364-7741197bad71"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931351932*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"b15df392-1dce-49c2-8ba9-70f60bf10748"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"2.830311125200122`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"2.4077142461754365`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {2.830311125200122*^-7 $CellContext`g/$CellContext`s, 
    2.4077142461754365`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.8001819313560467`*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"ce9d9554-7c3e-45c0-a83c-c50f2e072227"],

Cell[BoxData["\<\"Kirk's model:\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.8001819313602047`*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"fd443b75-d525-4247-b9ae-194ea02ddaac"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931364059*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"162bf2ef-4133-459e-b003-8d725fb30040"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"4.891356616869307`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.580960911565478`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {4.891356616869307*^-7 $CellContext`g/$CellContext`s, 
    1.580960911565478*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931368376*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"c175dce1-cdac-47de-b584-e227a3eb5f3a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"234.70588235294116`", "\[InvisibleSpace]", "\<\" bp spacer\"\>"}],
  SequenceForm[234.70588235294116`, " bp spacer"],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.8001819313726683`*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"73767975-2eca-4bf9-baa5-8c5b8827e385"],

Cell[BoxData["\<\"My model:\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931376299*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"5c2440aa-19ea-4348-8a04-ed31584c7d60"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.8001819313801727`*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"148e516b-685a-4949-a525-67052aaaa0f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"3.0371911213507876`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"2.6179387828896365`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {3.0371911213507876`*^-7 $CellContext`g/$CellContext`s, 
    2.6179387828896365`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931384369*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"c6f0bae1-1005-4eda-9822-9a69a2e3218f"],

Cell[BoxData["\<\"Kirk's model:\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.80018193138848*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"4b147f6c-23ba-49ec-9f49-c01ac9abf087"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931392007*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"c029cea2-787e-464a-88dc-acf380aabb41"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"5.524646805926165`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.7046702109509283`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {5.524646805926165*^-7 $CellContext`g/$CellContext`s, 
    1.7046702109509283`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.8001819313963013`*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"42b13cc3-e31d-46ea-9b1a-452820318e39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"268.2352941176471`", "\[InvisibleSpace]", "\<\" bp spacer\"\>"}],
  SequenceForm[268.2352941176471, " bp spacer"],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.80018193140084*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"ca6d315b-51af-44fa-b453-459c2229caf4"],

Cell[BoxData["\<\"My model:\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.80018193140444*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"b7026685-763f-4460-88ea-74c44cde7c42"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931407914*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"8e77771b-0322-4ac4-a7c4-2e01a1ad91ae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"3.2391037210975744`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"2.823164720967342`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {3.2391037210975744`*^-7 $CellContext`g/$CellContext`s, 
    2.823164720967342*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.8001819314123173`*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"d4edac5d-137b-4061-8d81-2a49a1b39a7d"],

Cell[BoxData["\<\"Kirk's model:\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931416729*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"13a920cc-b6c8-4047-8b4a-7a1a0010488b"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931420285*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"4eda37da-e138-4dd0-b539-3e9197a01fa7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"6.157936994983025`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.8275658908281281`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {6.157936994983025*^-7 $CellContext`g/$CellContext`s, 
    1.8275658908281281`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.79491274855989*^9, 3.79526831913798*^9, 
  3.8001773616609707`*^9, 3.800181931424292*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"75e26ab7-96dc-4b18-b7fa-85d10fc36998"]
}, Open  ]],

Cell["\<\
CHR Feb 2020. Lollipop geometry friction coefficients are identical to the \
corresponding results in \"Figure 2 calculations.nb\" with the exception of \
the number of reported significant figures (6 here versus 4 in the original). \
The 1st and 3rd columns of figures were plotted as the solid lines in Figure \
2. (The dotted lines and black circles in Figure 2 were obtained from \
previous work.)\
\>", "Text",
 CellFrame->True,
 FontColor->RGBColor[0, 0, 1],
 Background->GrayLevel[
  0.833326],ExpressionUUID->"d2e49376-16a4-40ea-aec1-16792c2d4981"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"N", "[", 
      RowBox[{"nbasepairs", ",", "3"}], "]"}], ",", 
     RowBox[{"N", "[", 
      RowBox[{"f1robert", ",", "4"}], "]"}], ",", 
     RowBox[{"N", "[", 
      RowBox[{"f1Kirk", ",", "4"}], "]"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[32]:=",ExpressionUUID->"edf8556d-39a3-451c-bbf2-367780a4d7ef"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"50.29411764705882`", 
      FractionBox[
       RowBox[{"1.367236774947633`*^-7", " ", "g"}], "s"], 
      FractionBox[
       RowBox[{"1.0629414798301575`*^-7", " ", "g"}], "s"]},
     {"67.05882352941177`", 
      FractionBox[
       RowBox[{"1.4932693345698687`*^-7", " ", "g"}], "s"], 
      FractionBox[
       RowBox[{"1.1061862133255019`*^-7", " ", "g"}], "s"]},
     {"83.8235294117647`", 
      FractionBox[
       RowBox[{"1.6162281809839142`*^-7", " ", "g"}], "s"], 
      FractionBox[
       RowBox[{"1.1579215268571271`*^-7", " ", "g"}], "s"]},
     {"100.58823529411764`", 
      FractionBox[
       RowBox[{"1.7362080970893914`*^-7", " ", "g"}], "s"], 
      FractionBox[
       RowBox[{"1.2142871178933508`*^-7", " ", "g"}], "s"]},
     {"134.11764705882354`", 
      FractionBox[
       RowBox[{"1.9682867019165014`*^-7", " ", "g"}], "s"], 
      FractionBox[
       RowBox[{"1.3337841072825942`*^-7", " ", "g"}], "s"]},
     {"167.6470588235294`", 
      FractionBox[
       RowBox[{"2.1915722001004071`*^-7", " ", "g"}], "s"], 
      FractionBox[
       RowBox[{"1.4569452943609173`*^-7", " ", "g"}], "s"]},
     {"201.17647058823528`", 
      FractionBox[
       RowBox[{"2.4077142461754365`*^-7", " ", "g"}], "s"], 
      FractionBox[
       RowBox[{"1.580960911565478`*^-7", " ", "g"}], "s"]},
     {"234.70588235294116`", 
      FractionBox[
       RowBox[{"2.6179387828896365`*^-7", " ", "g"}], "s"], 
      FractionBox[
       RowBox[{"1.7046702109509283`*^-7", " ", "g"}], "s"]},
     {"268.2352941176471`", 
      FractionBox[
       RowBox[{"2.823164720967342`*^-7", " ", "g"}], "s"], 
      FractionBox[
       RowBox[{"1.8275658908281281`*^-7", " ", "g"}], "s"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.794912748872012*^9, 3.7952683194707527`*^9, 
  3.800177362116291*^9, 3.8001819315537577`*^9},
 CellLabel->
  "Out[32]//MatrixForm=",ExpressionUUID->"3bd52cdb-d789-42df-8c32-\
de601c7a4766"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"xLollipop", "=", "nbasepairs"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"yLollipop", "=", "f1robert"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"yLollipop2", "=", "f1Kirk"}], ";"}], " "}]}], "Input",
 CellFrame->True,
 Background->GrayLevel[0.833326],
 CellLabel->"In[33]:=",ExpressionUUID->"84c8bb8c-1c6d-4ba0-91ba-586260321b16"],

Cell["\<\
Copy-paste the original output here for comparison. The recalculated results \
match to all significant figures.\
\>", "Text",
 CellFrame->True,
 FontColor->RGBColor[0, 0, 1],
 Background->GrayLevel[
  0.833326],ExpressionUUID->"b9a9c1f7-8c41-446e-bbfe-ed757de131a4"],

Cell[GraphicsData["PostScript", "\<\
%!PS-Adobe-2.0 EPSF-1.2
%%BoundingBox: 18 18 349 356
%%HiResBoundingBox: 18.375 18.375 348.375 355.875
%%Creator: (Mathematica 5.2 for Macintosh)
%%CreationDate: (Sunday, March 29, 2020) (19:18:16)
%%Title: Clipboard
%%DocumentNeededResources: (atend)
%%DocumentFonts: (atend)
%%DocumentNeededFonts: (atend)
%%EndComments
0 374.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def

%%MathematicaCell
%Cell[GraphicsData[\"PICT\", \\
%\"\\<\\
%24X04`0X0?@1100A0_l<0?ooool0:00001<\\
%000440000m0000000000N00402P0C
%02P0m09@02`02P0F1d=_MG9YIG800`0F00d02@0^00@0000002/Y6bPP820P820P
%820P820P820P820P820P82dg820P820P820P820P82dg000Z1BXP820P820P820P
%820P820a;S<f=b0a<20P86LP820a;S0f<b0a<20P86L0:PDZ820P820P820P820P
%820P;Bd];Bd];Bd];Bd]820P;Bd];Bd];Bd];Bd]02T2:R0P820P820P820P820P
%82d];Bd];Bd];Bd]820P82d];Bd];Bd];Bd]800X02X0:B@e<2hc820P820P820P
%820P820P87<P820P820P820P820P87<002X::20P820P820P820P820P820P820P
%820P;CLP820P820P820P820P;CL0:PDZ820P820P820P820P820P<Bhd>C<P<C0P
%821W820P<Bha<3HP<C0P821W02X5:R0P820P820P820P820P82d];Bd];Bd];Bd]
%;B0P82d];Bd];Bd];Bd];@0Y0RXP820P820P820P820P820];Bd];Bd];Bd];B0P
%820];Bd];Bd];Bd];B00:01302TT=SL^<B0P820P820P820P820P821c820P820P
%820P820P821c000Z2RPP820P820P820P820P820P820P820P82dg820P820P820P
%820P82dg02X5:R0P820P820P820P820P834^=S4f834`820PIb0P834^<CDh834`
%820PI`0Z1BXP820P820P820P820P820];Bd];Bd];Bd];BdP820];Bd];Bd];Bd]
%;Bd0:@8Z820P820P820P820P820P;Bd];Bd];Bd];BdP820P;Bd];Bd];Bd];BdP
%02P0G00Y93Pc;SPP820P820P820P820P820PLb0P820P820P820P820PL`00:PXX
%820P820P820P820P820P820P820P820]=b0P820P820P820P820]=`0Z1BXP820P
%820P820P820P820a;SLc=R0a<20P86LP820a;S8a=20a<20P86L0:PDZ820P820P
%820P820P820P;Bd];Bd];Bd];Bd]820P;Bd];Bd];Bd];Bd]02T2:R0P820P820P
%820P820P82d];Bd];Bd];Bd]820P82d];Bd];Bd];Bd]800X07D0:B@a<34^820P
%820P820P820P820P87<P820P820P820P820P87<002X::20P820P820P820P820P
%820P820P820P;CLP820P820P820P820P;CL0:PDZ820P820P820P820P820P<Bhi
%=SPP<C0P821W820P<Bhc<c@P<C0P821W02X5:R0P820P820P820P820P82d];Bd]
%;Bd];Bd];B0P82d];Bd];Bd];Bd];@0Y0RXP820P820P820P820P820];Bd];Bd]
%;Bd];B0P820];Bd];Bd];Bd];B00:02>02TT<C<d;R0P820P820P820P820P821c
%820P820P820P820P821c000Z2RPP820P820P820P820P820P820P820P82dg820P
%820P820P820P82dg02X5:R0P820P820P820P820P838^<CTb834`820PIb0P834^
%=3Dg834`820PI`0Z1BXP820P820P820P820P820];Bd];Bd];Bd];BdP820];Bd]
%;Bd];Bd];Bd0:@8Z820P820P820P820P820P;Bd];Bd];Bd];BdP820P;Bd];Bd]
%;Bd];BdP02P0Y`0Y934f>2hP820P820P820P820P820PLb0P820P820P820P820P
%L`00:PXX820P820P820P820P820P820P820P820]=b0P820P820P820P820]=`0Z
%1BXP820P820P820P820P820b;S@`>20a<20P86LP820a;SDh<B0a<20P86L0:PDZ
%820P820P820P820P820P;Bd];Bd];Bd];Bd]820P;Bd];Bd];Bd];Bd]02T2:R0P
%820P820P820P820P82d];Bd];Bd];Bd]820P82d];Bd];Bd];Bd]800X0<00:B@b
%<34^820P820P820P820P820P87<P820P820P820P820P87<002X::20P820P820P
%820P820P820P820P820P;CLP820P820P820P820P;CL0:PDZ820P820P820P820P
%820P<Rhf<CPP<C0P821W820P<Bhg<3DP<C0P821W02X5:R0P820P820P820P820P
%82d];Bd];Bd];Bd];B0P82d];Bd];Bd];Bd];@0Y0RXP820P820P820P820P820]
%;Bd];Bd];Bd];B0P820];Bd];Bd];Bd];B00:03I02TT<S<e;R0P820P820P820P
%820P821c820P820P820P820P821c000Z2RPP820P820P820P820P820P820P820P
%82dg820P820P820P820P82dg02X5:R0P820P820P820P820P838^>38c834`820P
%Ib0P834^>38h834`820PI`0Z1BXP820P820P820P820P820];Bd];Bd];Bd];BdP
%820];Bd];Bd];Bd];Bd0:@8Z820P820P820P820P820P;Bd];Bd];Bd];BdP820P
%;Bd];Bd];Bd];BdP02P0lP0Y938f>2hP820P820P820P820P820PLb0P820P820P
%820P820PL`00o`\\>\"], \"Graphics\",
%  CellFrame->True,
%  ImageSize->{220, 225},
%  ImageMargins->{{0, Inherited}, {Inherited, Inherited}},
%  ImageRegion->{{-0, 1}, {0, 1}},
%  FontSize->9,
%  Background->GrayLevel[0.833326]]
%%EndMathematicaCell
0.833 0.833 0.833 setrgbcolor
newpath
 6.000 367.250 moveto
 1242.438 367.250 lineto
 1242.438 6.000 lineto
 6.000 6.000 lineto
 6.000 367.250 lineto
closepath
fill
0.000 0.000 0.000 setrgbcolor
1.5 setlinewidth
/Courier findfont 9 scalefont setfont
20 30 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 38 moveto (               1.367 10   g   1.063 10   g) show
/Courier findfont 9 scalefont setfont
20 45 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 45 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 53 moveto (50.3                s              s) show
/Courier findfont 9 scalefont setfont
20 68 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 75 moveto (               1.493 10   g   1.106 10   g) show
/Courier findfont 9 scalefont setfont
20 83 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 83 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 90 moveto (67.1                s              s) show
/Courier findfont 9 scalefont setfont
20 105 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 113 moveto (               1.616 10   g   1.158 10   g) show
/Courier findfont 9 scalefont setfont
20 120 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 120 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 128 moveto (83.8                s              s) show
/Courier findfont 9 scalefont setfont
20 143 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 150 moveto (               1.736 10   g   1.214 10   g) show
/Courier findfont 9 scalefont setfont
20 158 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 158 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 165 moveto (101.                s              s) show
/Courier findfont 9 scalefont setfont
20 180 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 187 moveto (               1.968 10   g   1.334 10   g) show
/Courier findfont 9 scalefont setfont
20 195 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 195 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 202 moveto (134.                s              s) show
/Courier findfont 9 scalefont setfont
20 217 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 225 moveto (               2.192 10   g   1.457 10   g) show
/Courier findfont 9 scalefont setfont
20 232 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 232 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 240 moveto (168.                s              s) show
/Courier findfont 9 scalefont setfont
20 255 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 262 moveto (               2.408 10   g   1.581 10   g) show
/Courier findfont 9 scalefont setfont
20 270 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 270 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 277 moveto (201.                s              s) show
/Courier findfont 9 scalefont setfont
20 292 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 300 moveto (               2.618 10   g   1.705 10   g) show
/Courier findfont 9 scalefont setfont
20 307 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 307 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 315 moveto (235.                s              s) show
/Courier findfont 9 scalefont setfont
20 330 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 337 moveto (               2.823 10   g   1.828 10   g) show
/Courier findfont 9 scalefont setfont
20 345 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 345 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 352 moveto (268.                s              s) show
%%Trailer
%%EOF
\
\>"], "Graphics",
 CellFrame->True,
 Evaluatable->False,
 ImageSize->{331, 338},
 ImageMargins->{{43, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontSize->9,
 Background->GrayLevel[
  0.833326],ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],ExpressionUUID->"6b67c8a3-ac97-47b5-903b-3887c37d4673"],

Cell[TextData[StyleBox["DUMBBELLS",
 FontFamily->"Geneva",
 FontSize->14]], "Text",
 AspectRatioFixed->False,
 ImageRegion->{{0, 1}, {0, 
  1}},ExpressionUUID->"740d14c2-3b9a-4b9d-9930-f1f12161a0c6"],

Cell[TextData[StyleBox["Here are the dumbbell calculations.  We use a linear \
array that is the same as\nbefore, but another subunit is added at the end.",
 FontFamily->"Geneva",
 FontWeight->"Plain"]], "Text",
 AspectRatioFixed->False,
 ImageRegion->{{0, 1}, {0, 
  1}},ExpressionUUID->"77e1a716-7389-42c6-8cfb-df98878aa870"],

Cell[CellGroupData[{

Cell["\<\
f1Kirk={};
f1robert={};
frictionratio={};
rij={};
Do[
\tPrint[nbasepairs[[k]],\" bp spacer\"];
\t
\tPrint[\"My model:\"];
\tntot=3;
\tsnaked[nbasepairs[[k]]];
\tradii={r1,rstokes,r1};
\trij={{0,r1 + lengthp[[k]] r1/2,2 r1 + lengthp[[k]] r1},
\t\t {0,0,r1 + lengthp[[k]] r1/2},
\t\t {0,0,0}};
\tdoKirkwoodG;
\tf1robert=Append[f1robert,f1];

\tPrint[\"Kirk's model:\"];\t
\tntot=lengthp[[k]]+2;
\tradii={r1};
\tDo[radii=Append[radii,r2],{i,lengthp[[k]]}];
\tradii=Append[radii,r1];
\trij=Table[0,{i,ntot},{j,ntot}];
\tDo[ Do[\tIf[\tj<ntot,
\t\t\t\trij[[i,j]]=radii[[i]] + (j-i-1) 2 r2 + r2,
\t\t\t\trij[[i,j]]=radii[[i]] + (j-i-1) 2 r2 + radii[[j]]
\t\t\t],
\t\t{j,i+1,ntot}],
\t{i,ntot}];
\tdoKirkwoodG;
\tf1Kirk=Append[f1Kirk,N[f1]],

{k,Length[lengthp]}];\
\>", "Input",
 AspectRatioFixed->False,
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[36]:=",ExpressionUUID->"f192879c-eece-4888-a711-e8121504a79e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"50.29411764705882`", "\[InvisibleSpace]", "\<\" bp spacer\"\>"}],
  SequenceForm[50.29411764705882, " bp spacer"],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931700828*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"47595c39-4c1e-4cf5-9b68-8c76de200b8d"],

Cell[BoxData["\<\"My model:\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.80018193170573*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"e48de843-05fd-4edc-a5da-0bdf37dae98d"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931709222*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"502b9a35-6dfb-42bc-b7c5-9e36903e80db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"2.8879598424182434`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.873312981463389`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {2.8879598424182434`*^-7 $CellContext`g/$CellContext`s, 
    1.873312981463389*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931713166*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"33647824-25c2-4472-b13d-59cb6ccc4bd7"],

Cell[BoxData["\<\"Kirk's model:\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.8001819317177896`*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"9f6fc9f2-7cd7-4588-9482-74d3f40543d6"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.8001819317213497`*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"ad12fe56-d5e1-43e1-8cfb-79fd3e7f882f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"3.1331662486415936`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.4686045034706145`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {3.1331662486415936`*^-7 $CellContext`g/$CellContext`s, 
    1.4686045034706145`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931725335*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"f369de19-5425-44fa-9cf1-29ce5795e99c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"67.05882352941177`", "\[InvisibleSpace]", "\<\" bp spacer\"\>"}],
  SequenceForm[67.05882352941177, " bp spacer"],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931729561*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"a6f867be-80be-480e-9e7c-23146f1124f3"],

Cell[BoxData["\<\"My model:\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931733467*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"b6913fa0-9a92-4560-b5d1-7c10963a86a8"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.8001819317369537`*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"6ccb02a8-65b0-4794-b573-f6e97fe7872f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"3.0155593567931384`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"2.025660123601962`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {3.0155593567931384`*^-7 $CellContext`g/$CellContext`s, 
    2.025660123601962*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931740954*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"87bfac6c-77ec-4ba6-b518-72a469595c83"],

Cell[BoxData["\<\"Kirk's model:\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.8001819317450323`*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"6a85ac5a-9dcb-4ce2-94c0-84f19202abd9"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931748867*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"e1d3149c-98f9-4729-b7bc-ad8aa0467732"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"3.449811343170023`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.5024628714637697`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {3.449811343170023*^-7 $CellContext`g/$CellContext`s, 
    1.5024628714637697`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931752969*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"82b3e359-e26a-4866-893a-d06302295eb9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"83.8235294117647`", "\[InvisibleSpace]", "\<\" bp spacer\"\>"}],
  SequenceForm[83.8235294117647, " bp spacer"],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931757182*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"f079e982-f7f9-4293-95de-fddf853af126"],

Cell[BoxData["\<\"My model:\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931760766*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"f4e1569b-3083-41bd-9866-8eac348cb36c"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931764556*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"865680db-3122-4455-b6e2-45cf6ca03599"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"3.138978294309158`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"2.1687997004483607`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {3.138978294309158*^-7 $CellContext`g/$CellContext`s, 
    2.1687997004483607`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931768629*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"be42d43a-a922-4a05-b4d2-1ea19d807cdc"],

Cell[BoxData["\<\"Kirk's model:\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931772784*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"c8879fc5-410c-4a78-a7f4-eafc36a4be63"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931776231*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"cd012f79-4e01-4bbc-9c7d-34805f9f85c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"3.766456437698452`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.5439205505528972`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {3.766456437698452*^-7 $CellContext`g/$CellContext`s, 
    1.5439205505528972`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931780669*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"68d6abe2-63d2-4004-baac-211cc8250a1d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"100.58823529411764`", "\[InvisibleSpace]", "\<\" bp spacer\"\>"}],
  SequenceForm[100.58823529411764`, " bp spacer"],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931784974*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"a977ec06-9057-4f4a-b107-cf05098444a1"],

Cell[BoxData["\<\"My model:\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931788497*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"45d52f44-b035-4be8-b901-10187b015209"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.8001819317920322`*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"85939a21-38e7-4369-8d86-54f89506e897"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"3.2586268138350456`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"2.3049312020097141`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {3.2586268138350456`*^-7 $CellContext`g/$CellContext`s, 
    2.3049312020097141`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931795969*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"e6c3af1a-4238-48e1-ad08-0311defcb604"],

Cell[BoxData["\<\"Kirk's model:\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.8001819318006763`*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"ea22c5f8-7f2a-4ef4-b447-09de62a33a09"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931804195*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"067cede3-5636-43fb-a8eb-a694a0a846ae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"4.083101532226881`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.590334845771641`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {4.083101532226881*^-7 $CellContext`g/$CellContext`s, 
    1.590334845771641*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931808133*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"b9d10194-3e5c-4962-9346-53703b36b205"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"134.11764705882354`", "\[InvisibleSpace]", "\<\" bp spacer\"\>"}],
  SequenceForm[134.11764705882354`, " bp spacer"],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931812872*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"15211a40-49c6-42b8-b436-975430c75475"],

Cell[BoxData["\<\"My model:\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.8001819318165417`*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"4ff85d85-de94-4c69-a2e3-19c634edc48a"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931820026*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"5e95615f-20fc-4805-9f36-0d5dc2b4e7c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"3.4886756353978887`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"2.5615553986838464`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {3.4886756353978887`*^-7 $CellContext`g/$CellContext`s, 
    2.5615553986838464`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.8001819318238*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"ee569cba-ed6d-4534-9467-dfeb2fe01dd5"],

Cell[BoxData["\<\"Kirk's model:\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.8001819318279257`*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"600862d4-298e-4377-a54a-188316a3a4c0"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931831812*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"42b99a09-4e9b-4560-9faf-0f489688fc1a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"4.7163917212837406`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.6921236789650012`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {4.7163917212837406`*^-7 $CellContext`g/$CellContext`s, 
    1.6921236789650012`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931835795*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"53f11ae1-ed70-43bc-8b61-244e6bff0458"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"167.6470588235294`", "\[InvisibleSpace]", "\<\" bp spacer\"\>"}],
  SequenceForm[167.6470588235294, " bp spacer"],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931839926*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"70f7553b-d94b-426f-854d-478348da9a6b"],

Cell[BoxData["\<\"My model:\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.8001819318433647`*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"2d9cb617-4fc2-41a6-a4a8-2b3189ad463e"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931847019*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"f0bab25b-67ca-4d5c-88ec-6dcafb07c13a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"3.7090416970693285`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"2.802867244790704`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {3.7090416970693285`*^-7 $CellContext`g/$CellContext`s, 
    2.802867244790704*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931850917*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"e3e29598-8be5-4737-89b9-4951da8b1fed"],

Cell[BoxData["\<\"Kirk's model:\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.8001819318551073`*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"238fb67a-7396-4fce-aadc-d9d7ab0d53f1"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931858423*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"aea00776-e302-4e18-9e8e-6efcb4d84fe3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"5.349681910340599`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.800548390249779`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {5.349681910340599*^-7 $CellContext`g/$CellContext`s, 
    1.800548390249779*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931862678*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"9bf92bb6-d28f-48ac-86da-2c654f2aa1a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"201.17647058823528`", "\[InvisibleSpace]", "\<\" bp spacer\"\>"}],
  SequenceForm[201.17647058823528`, " bp spacer"],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931867177*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"3230ac4d-5140-4dc5-8a3b-c9cece4068e5"],

Cell[BoxData["\<\"My model:\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.8001819318707647`*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"9addfb02-a985-423f-a616-89ec0e0403d6"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931874058*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"ebc08239-0ac9-47cc-8cb3-e9dc6c090ea4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"3.921926607728274`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"3.0329833551785966`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {3.921926607728274*^-7 $CellContext`g/$CellContext`s, 
    3.0329833551785966`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931877904*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"b48bb5e8-233d-41ed-bc43-261a729eb522"],

Cell[BoxData["\<\"Kirk's model:\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931882304*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"71816cb3-8196-477f-9681-cc20ec2a8f02"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931885826*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"1de83882-cf7e-4e1c-82a5-0b6fee6c0b92"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"5.982972099397459`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"1.9122698880095092`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {5.982972099397459*^-7 $CellContext`g/$CellContext`s, 
    1.9122698880095092`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931889715*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"beb63249-7b68-41c8-a930-ae781b8b6db4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"234.70588235294116`", "\[InvisibleSpace]", "\<\" bp spacer\"\>"}],
  SequenceForm[234.70588235294116`, " bp spacer"],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931893838*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"717be505-fd19-45b7-809c-c8da7cab9dfe"],

Cell[BoxData["\<\"My model:\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931897677*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"50abd6dc-a60a-4df0-bef6-1bf92cd6a890"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931901251*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"81ad2a94-c147-4a36-a6f0-9f7f81887052"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"4.1288066038789396`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"3.2544660366026563`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {4.1288066038789396`*^-7 $CellContext`g/$CellContext`s, 
    3.2544660366026563`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931905119*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"5f6ccc9d-1abb-4719-af45-94a15f4e1e3b"],

Cell[BoxData["\<\"Kirk's model:\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931909163*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"02fd517c-c973-46cf-a556-58d7872f55cf"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931912944*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"59a52437-d61f-419e-bed3-83fac51f4198"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"6.616262288454318`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"2.0255902967328093`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {6.616262288454318*^-7 $CellContext`g/$CellContext`s, 
    2.0255902967328093`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931917059*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"10498910-8ba8-4ec6-8450-a0f78ecfc829"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"268.2352941176471`", "\[InvisibleSpace]", "\<\" bp spacer\"\>"}],
  SequenceForm[268.2352941176471, " bp spacer"],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931921294*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"c3437385-d885-41ce-a2ff-4a97d1ceadbc"],

Cell[BoxData["\<\"My model:\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931924871*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"1fe3d9fb-bf23-491e-a526-cdd4f07de94f"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931928627*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"db935fe3-5496-479e-a785-5ce818bb5f8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"4.330719203625727`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"3.469029064511409`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {4.330719203625727*^-7 $CellContext`g/$CellContext`s, 
    3.469029064511409*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.8001819319327307`*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"45849622-da27-4f9e-86e7-7aaa2146db73"],

Cell[BoxData["\<\"Kirk's model:\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931936755*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"295ad2fe-4ee0-426c-bc40-e5289c4c7799"],

Cell[BoxData["\<\"   Kirkwood results: {f free-draining,f1}\"\>"], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931940185*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"83449fe8-8cf7-45b4-92df-aab7d6aab30b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"7.249552477511178`*^-7", " ", "g"}], "s"], ",", 
     FractionBox[
      RowBox[{"2.1395825044474407`*^-7", " ", "g"}], "s"]}], "}"}]}],
  SequenceForm[
  "   ", {7.249552477511178*^-7 $CellContext`g/$CellContext`s, 
    2.1395825044474407`*^-7 $CellContext`g/$CellContext`s}],
  Editable->False]], "Print",
 CellChangeTimes->{3.794912748978628*^9, 3.795268319587899*^9, 
  3.8001774635862226`*^9, 3.800181931944412*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"5bc0f319-69a8-4218-9099-67f6f619723b"]
}, Open  ]],

Cell["\<\
CHR Feb 2020. Dumbbell geometry friction coefficients are identical to the \
corresponding results in \"Figure 2 calculations.nb\" with the exception of \
the number of reported significant figures (6 here versus 4 in the original). \
The 1st and 3rd columns of figures were plotted as the solid lines in Figure \
2. (The dotted lines and black circles in Figure 2 were obtained from \
previous work.)\
\>", "Text",
 CellFrame->True,
 FontColor->RGBColor[0, 0, 1],
 Background->GrayLevel[
  0.833326],ExpressionUUID->"db92427a-7006-4c0f-82db-379c3406f611"],

Cell[CellGroupData[{

Cell["\<\
MatrixForm[Transpose[{N[nbasepairs,3],N[f1robert,4],N[f1Kirk,4]}]]\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[41]:=",ExpressionUUID->"7a2fa8db-5b6f-4824-8707-594aea979f9a"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"50.29411764705882`", 
      FractionBox[
       RowBox[{"1.873312981463389`*^-7", " ", "g"}], "s"], 
      FractionBox[
       RowBox[{"1.4686045034706145`*^-7", " ", "g"}], "s"]},
     {"67.05882352941177`", 
      FractionBox[
       RowBox[{"2.025660123601962`*^-7", " ", "g"}], "s"], 
      FractionBox[
       RowBox[{"1.5024628714637697`*^-7", " ", "g"}], "s"]},
     {"83.8235294117647`", 
      FractionBox[
       RowBox[{"2.1687997004483607`*^-7", " ", "g"}], "s"], 
      FractionBox[
       RowBox[{"1.5439205505528972`*^-7", " ", "g"}], "s"]},
     {"100.58823529411764`", 
      FractionBox[
       RowBox[{"2.3049312020097141`*^-7", " ", "g"}], "s"], 
      FractionBox[
       RowBox[{"1.590334845771641`*^-7", " ", "g"}], "s"]},
     {"134.11764705882354`", 
      FractionBox[
       RowBox[{"2.5615553986838464`*^-7", " ", "g"}], "s"], 
      FractionBox[
       RowBox[{"1.6921236789650012`*^-7", " ", "g"}], "s"]},
     {"167.6470588235294`", 
      FractionBox[
       RowBox[{"2.802867244790704`*^-7", " ", "g"}], "s"], 
      FractionBox[
       RowBox[{"1.800548390249779`*^-7", " ", "g"}], "s"]},
     {"201.17647058823528`", 
      FractionBox[
       RowBox[{"3.0329833551785966`*^-7", " ", "g"}], "s"], 
      FractionBox[
       RowBox[{"1.9122698880095092`*^-7", " ", "g"}], "s"]},
     {"234.70588235294116`", 
      FractionBox[
       RowBox[{"3.2544660366026563`*^-7", " ", "g"}], "s"], 
      FractionBox[
       RowBox[{"2.0255902967328093`*^-7", " ", "g"}], "s"]},
     {"268.2352941176471`", 
      FractionBox[
       RowBox[{"3.469029064511409`*^-7", " ", "g"}], "s"], 
      FractionBox[
       RowBox[{"2.1395825044474407`*^-7", " ", "g"}], "s"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.7949127493412647`*^9, 3.795268319984799*^9, 
  3.800177464114244*^9, 3.8001819320768347`*^9},
 CellLabel->
  "Out[41]//MatrixForm=",ExpressionUUID->"13d58ded-55f7-4d76-8328-\
2a3cdd2ea533"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"xDumbbell", "=", "nbasepairs"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"yDumbbell", "=", "f1robert"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"yDumbbell2", "=", "f1Kirk"}], ";"}], " "}]}], "Input",
 CellFrame->True,
 Background->GrayLevel[0.833326],
 CellLabel->"In[42]:=",ExpressionUUID->"032bf2ad-cf5d-431f-9939-455117192e46"],

Cell["\<\
Copy-paste the original output here for comparison. The recalculated results \
match to all provided significant figures.\
\>", "Text",
 CellFrame->True,
 FontColor->RGBColor[0, 0, 1],
 Background->GrayLevel[
  0.833326],ExpressionUUID->"1d51e8c9-4b34-40de-ab5c-6d2c7d6d07cc"],

Cell[GraphicsData["PostScript", "\<\
%!PS-Adobe-2.0 EPSF-1.2
%%BoundingBox: 18 18 349 356
%%HiResBoundingBox: 18.375 18.375 348.375 355.875
%%Creator: (Mathematica 5.2 for Macintosh)
%%CreationDate: (Sunday, March 29, 2020) (19:18:30)
%%Title: Clipboard
%%DocumentNeededResources: (atend)
%%DocumentFonts: (atend)
%%DocumentNeededFonts: (atend)
%%EndComments
0 374.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def

%%MathematicaCell
%Cell[GraphicsData[\"PICT\", \\
%\"\\<\\
%24X04`0X0?@1100A0_l<0?ooool0:00001<\\
%000440000m0000000000N00402P0C
%02P0m09@02`02P0F1d=_MG9YIG800`0F00d02@0^00@0000002/Y6bPP820P820P
%820P820P820P820P820P82dg820P820P820P820P82dg000Z1BXP820P820P820P
%820P820a;SPg<b0a<20P86LP820a;S@f>B0a<20P86L0:PDZ820P820P820P820P
%820P;Bd];Bd];Bd];Bd]820P;Bd];Bd];Bd];Bd]02T2:R0P820P820P820P820P
%82d];Bd];Bd];Bd]820P82d];Bd];Bd];Bd]800X02X0:B@e<2hc820P820P820P
%820P820P87<P820P820P820P820P87<002X::20P820P820P820P820P820P820P
%820P;CLP820P820P820P820P;CL0:PDZ820P820P820P820P820P<Rh`<SHP<C0P
%821W820P<Bhe<38P<C0P821W02X5:R0P820P820P820P820P82d];Bd];Bd];Bd]
%;B0P82d];Bd];Bd];Bd];@0Y0RXP820P820P820P820P820];Bd];Bd];Bd];B0P
%820];Bd];Bd];Bd];B00:01302TT=SL^<B0P820P820P820P820P821c820P820P
%820P820P821c000Z2RPP820P820P820P820P820P820P820P82dg820P820P820P
%820P82dg02X5:R0P820P820P820P820P838^<CHi834`820PIb0P834^=C@d834`
%820PI`0Z1BXP820P820P820P820P820];Bd];Bd];Bd];BdP820];Bd];Bd];Bd]
%;Bd0:@8Z820P820P820P820P820P;Bd];Bd];Bd];BdP820P;Bd];Bd];Bd];BdP
%02P0G00Y93Pc;SPP820P820P820P820P820PLb0P820P820P820P820PL`00:PXW
%820P820P820P820P820P820P820P820]=b0P820P820P820P82dg000Z1BTP820P
%820P820P820P820b;S<`=B0a<20P86LP820a;SDi834`820PI`00:PDY820P820P
%820P820P820P;Bd];Bd];Bd];Bd]820P;Bd];Bd];Bd];Bd002T2:B0P820P820P
%820P820P82d];Bd];Bd];Bd]820P82d];Bd];Bd];BdP000X07D0:B@a<34^820P
%820P820P820P820P87<P820P820P820P820P87<002X::20P820P820P820P820P
%820P820P820P;CLP820P820P820P820P;CL0:PDZ820P820P820P820P820P<Rhe
%=S8P<C0P821W820P<Bhf>C8P<C0P821W02X5:R0P820P820P820P820P82d];Bd]
%;Bd];Bd];B0P82d];Bd];Bd];Bd];@0Y0RXP820P820P820P820P820];Bd];Bd]
%;Bd];B0P820];Bd];Bd];Bd];B00:02>02TT<C<d;R0P820P820P820P820P821c
%820P820P820P820P821c000Z2RPP820P820P820P820P820P820P820P82dg820P
%820P820P820P82dg02X5:R0P820P820P820P820P838^>30c834`820PIb0P834^
%>30a834`820PI`0Z1BXP820P820P820P820P820];Bd];Bd];Bd];BdP820];Bd]
%;Bd];Bd];Bd0:@8Z820P820P820P820P820P;Bd];Bd];Bd];BdP820P;Bd];Bd]
%;Bd];BdP02P0Y`0Y934f>2hP820P820P820P820P820PLb0P820P820P820P820P
%L`00:PXX820P820P820P820P820P820P820P820]=b0P820P820P820P820]=`0Z
%1BXP820P820P820P820P820c;S0c<b0a<20P86LP820a;STa<R0a<20P86L0:PDZ
%820P820P820P820P820P;Bd];Bd];Bd];Bd]820P;Bd];Bd];Bd];Bd]02T2:R0P
%820P820P820P820P82d];Bd];Bd];Bd]820P82d];Bd];Bd];Bd]800X0<00:B@b
%<34^820P820P820P820P820P87<P820P820P820P820P87<002X::20P820P820P
%820P820P820P820P820P;CLP820P820P820P820P;CL0:PDZ820P820P820P820P
%820P<bhb=C@P<C0P821W820P<Rh`<SHP<C0P821W02X5:R0P820P820P820P820P
%82d];Bd];Bd];Bd];B0P82d];Bd];Bd];Bd];@0Y0RXP820P820P820P820P820]
%;Bd];Bd];Bd];B0P820];Bd];Bd];Bd];B00:03I02TT<S<e;R0P820P820P820P
%820P821c820P820P820P820P821c000Z2RLP820P820P820P820P820P820P820P
%82dg820P820P820P820P;CL002X5:B0P820P820P820P820P83<^=3Hi834`820P
%Ib0P838^<C@P<C0P821W000Z1BTP820P820P820P820P820];Bd];Bd];Bd];BdP
%820];Bd];Bd];Bd];@00:@8Y820P820P820P820P820P;Bd];Bd];Bd];BdP820P
%;Bd];Bd];Bd];B0002P0lP0Y938f>2hP820P820P820P820P820PLb0P820P820P
%820P820PL`00o`\\>\"], \"Graphics\",
%  CellFrame->True,
%  ImageSize->{220, 225},
%  ImageMargins->{{0, Inherited}, {Inherited, Inherited}},
%  ImageRegion->{{-0, 1}, {0, 1}},
%  FontSize->9,
%  Background->GrayLevel[0.833326]]
%%EndMathematicaCell
0.833 0.833 0.833 setrgbcolor
newpath
 6.000 367.250 moveto
 1242.438 367.250 lineto
 1242.438 6.000 lineto
 6.000 6.000 lineto
 6.000 367.250 lineto
closepath
fill
0.000 0.000 0.000 setrgbcolor
1.5 setlinewidth
/Courier findfont 9 scalefont setfont
20 30 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 38 moveto (               1.873 10   g   1.469 10   g) show
/Courier findfont 9 scalefont setfont
20 45 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 45 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 53 moveto (50.3                s              s) show
/Courier findfont 9 scalefont setfont
20 68 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 75 moveto (               2.026 10   g   1.502 10   g) show
/Courier findfont 9 scalefont setfont
20 83 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 83 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 90 moveto (67.1                s              s) show
/Courier findfont 9 scalefont setfont
20 105 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 113 moveto (               2.169 10   g   1.544 10   g) show
/Courier findfont 9 scalefont setfont
20 120 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 120 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 128 moveto (83.8                s              s) show
/Courier findfont 9 scalefont setfont
20 143 moveto (                       -7            -7) show
/Courier findfont 9 scalefont setfont
20 150 moveto (               2.305 10   g   1.59 10   g) show
/Courier findfont 9 scalefont setfont
20 158 moveto (               ------------   -----------) show
/Courier findfont 9 scalefont setfont
23 158 moveto (               -----------    ---------- ) show
/Courier findfont 9 scalefont setfont
20 165 moveto (101.                s              s) show
/Courier findfont 9 scalefont setfont
20 180 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 187 moveto (               2.562 10   g   1.692 10   g) show
/Courier findfont 9 scalefont setfont
20 195 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 195 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 202 moveto (134.                s              s) show
/Courier findfont 9 scalefont setfont
20 217 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 225 moveto (               2.803 10   g   1.801 10   g) show
/Courier findfont 9 scalefont setfont
20 232 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 232 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 240 moveto (168.                s              s) show
/Courier findfont 9 scalefont setfont
20 255 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 262 moveto (               3.033 10   g   1.912 10   g) show
/Courier findfont 9 scalefont setfont
20 270 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 270 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 277 moveto (201.                s              s) show
/Courier findfont 9 scalefont setfont
20 292 moveto (                       -7             -7) show
/Courier findfont 9 scalefont setfont
20 300 moveto (               3.254 10   g   2.026 10   g) show
/Courier findfont 9 scalefont setfont
20 307 moveto (               ------------   ------------) show
/Courier findfont 9 scalefont setfont
23 307 moveto (               -----------    ----------- ) show
/Courier findfont 9 scalefont setfont
20 315 moveto (235.                s              s) show
/Courier findfont 9 scalefont setfont
20 330 moveto (                       -7            -7) show
/Courier findfont 9 scalefont setfont
20 337 moveto (               3.469 10   g   2.14 10   g) show
/Courier findfont 9 scalefont setfont
20 345 moveto (               ------------   -----------) show
/Courier findfont 9 scalefont setfont
23 345 moveto (               -----------    ---------- ) show
/Courier findfont 9 scalefont setfont
20 352 moveto (268.                s              s) show
%%Trailer
%%EOF
\
\>"], "Graphics",
 CellFrame->True,
 Evaluatable->False,
 ImageSize->{331, 338},
 ImageMargins->{{43, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontSize->9,
 Background->GrayLevel[
  0.833326],ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],ExpressionUUID->"f9dfc2a8-01e8-4a17-8c7a-5f8a5323ea9f"],

Cell["\<\
For convenience, the relevant values are plotted below in the format close to \
that used in the article (the article's approach as solid lines versus the \
standard approach as dashes). The data points indicated as filled circles in \
Figure 2 were taken from previous results and are not shown.\
\>", "Text",
 CellFrame->True,
 FontColor->RGBColor[0, 0, 1],
 Background->GrayLevel[
  0.833326],ExpressionUUID->"72afb9ed-e13f-4bb4-9229-714a393260eb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"xlabel", "=", "\"\<Spacer length, bp\>\""}], ";", 
  RowBox[{"ylabel", "=", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<frictional coefficient x\>\"", ",", " ", 
      RowBox[{"Superscript", "[", 
       RowBox[{"10", ",", "7"}], "]"}], ",", "\"\<g/s\>\""}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8001858175301437`*^9, 3.8001858489831343`*^9}},
 CellLabel->"In[95]:=",ExpressionUUID->"3ce55973-622c-4e73-be88-a87875475c5e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "plotdark", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotdark", "[", 
   RowBox[{"xs_", ",", "ys_", ",", 
    RowBox[{"plotstyle_:", "Automatic"}], ",", 
    RowBox[{"plotrange_:", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "290"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3.5"}], "}"}]}], "}"}]}]}], "]"}], ":=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"xs", ",", "ys"}], "}"}], "]"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", " ", "plotstyle"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "plotrange"}], ",", "\[IndentingNewLine]", 
    RowBox[{"AspectRatio", "->", "1"}], ",", 
    RowBox[{"DisplayFunction", "->", "Identity"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.800182791937796*^9, 3.800182899785672*^9}, 
   3.8001829329923477`*^9, {3.8001831453041077`*^9, 3.8001831659731493`*^9}, {
   3.8001832687462797`*^9, 3.800183310305031*^9}, {3.800183356580821*^9, 
   3.800183359430996*^9}, {3.800184590917583*^9, 3.8001845963682632`*^9}, {
   3.800184642512829*^9, 3.8001847278037033`*^9}, {3.8001847602075453`*^9, 
   3.800184774898835*^9}, {3.800185553694281*^9, 3.800185571534341*^9}, {
   3.800185628969751*^9, 3.80018563526235*^9}, {3.800185910468443*^9, 
   3.800185943501163*^9}, 
   3.800185988421072*^9},ExpressionUUID->"b2bcb359-65ea-4450-9a17-\
ffbc3a8e33a6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"plotdark", "[", 
    RowBox[{"xLollipop", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"10", "^", "7"}], " ", "yLollipop"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"g", "->", "1"}], ",", 
        RowBox[{"s", "->", "1"}]}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"plotdark", "[", 
    RowBox[{"xLollipop", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"10", "^", "7"}], " ", "yLollipop2"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"g", "->", "1"}], ",", 
        RowBox[{"s", "->", "1"}]}], "}"}]}], ",", 
     RowBox[{"Dashing", "[", 
      RowBox[{"{", 
       RowBox[{"0.03", ",", "0.015"}], "}"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"plotdark", "[", 
    RowBox[{"xDumbbell", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"10", "^", "7"}], " ", "yDumbbell"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"g", "->", "1"}], ",", 
        RowBox[{"s", "->", "1"}]}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"plotdark", "[", 
    RowBox[{"xDumbbell", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"10", "^", "7"}], " ", "yDumbbell2"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"g", "->", "1"}], ",", 
        RowBox[{"s", "->", "1"}]}], "}"}]}], ",", 
     RowBox[{"Dashing", "[", 
      RowBox[{"{", 
       RowBox[{"0.025", ",", "0.015"}], "}"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"xlabel", ",", "ylabel"}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"DisplayFunction", "->", "$DisplayFunction"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.800182935671574*^9, 3.800183036378436*^9}, {
   3.800183081627975*^9, 3.8001830895946503`*^9}, {3.8001831936918917`*^9, 
   3.800183239355936*^9}, {3.8001834283630238`*^9, 3.80018346113378*^9}, {
   3.800183495608466*^9, 3.800183511344406*^9}, 3.800183574654832*^9, {
   3.800184483157413*^9, 3.800184490191914*^9}, {3.80018489313655*^9, 
   3.800184914488112*^9}, {3.800184960943347*^9, 3.800185029689052*^9}, {
   3.800185213437587*^9, 3.8001852186271763`*^9}, {3.800185347626811*^9, 
   3.800185364107099*^9}, 3.8001854422202997`*^9, 3.8001855436014833`*^9, {
   3.800185587656954*^9, 3.800185595502532*^9}, {3.80018564747395*^9, 
   3.800185672054677*^9}, {3.800185760782446*^9, 3.800185779456546*^9}, {
   3.800185867517221*^9, 3.800185891527465*^9}, {3.8001859938459578`*^9, 
   3.800185999850762*^9}, {3.800186058977103*^9, 
   3.800186060703742*^9}},ExpressionUUID->"599b4132-d509-41cb-a677-\
b89d78e62fab"],

Cell[BoxData[
 GraphicsBox[{{{}, {{{}, {}, 
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
        NCache[
         Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
       LineBox[{{50.29411764705882, 1.3672367749476328`}, {67.05882352941177, 
        1.4932693345698687`}, {83.8235294117647, 1.6162281809839143`}, {
        100.58823529411764`, 1.7362080970893914`}, {134.11764705882354`, 
        1.9682867019165013`}, {167.6470588235294, 2.191572200100407}, {
        201.17647058823528`, 2.4077142461754364`}, {234.70588235294116`, 
        2.6179387828896363`}, {268.2352941176471, 2.823164720967342}}]}}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       NCache[
        Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6]}, {
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
        NCache[
         Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[
       1.6]}, {}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
        NCache[
         Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[
       1.6]}, {}}}, {{}, {}}}, {{}, {{{}, {}, 
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
        NCache[
         Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
       Dashing[{0.03, 0.015}], 
       LineBox[{{50.29411764705882, 1.0629414798301575`}, {67.05882352941177, 
        1.1061862133255018`}, {83.8235294117647, 1.157921526857127}, {
        100.58823529411764`, 1.2142871178933508`}, {134.11764705882354`, 
        1.3337841072825942`}, {167.6470588235294, 1.4569452943609174`}, {
        201.17647058823528`, 1.5809609115654781`}, {234.70588235294116`, 
        1.7046702109509282`}, {268.2352941176471, 1.827565890828128}}]}}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       NCache[
        Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
      Dashing[{0.03, 0.015}]}, {
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
        NCache[
         Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
       Dashing[{0.03, 0.015}]}, {}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
        NCache[
         Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
       Dashing[{0.03, 0.015}]}, {}}}, {{}, {}}}, {{}, {{{}, {}, 
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
        NCache[
         Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
       LineBox[{{50.29411764705882, 1.873312981463389}, {67.05882352941177, 
        2.025660123601962}, {83.8235294117647, 2.1687997004483606`}, {
        100.58823529411764`, 2.304931202009714}, {134.11764705882354`, 
        2.561555398683846}, {167.6470588235294, 2.802867244790704}, {
        201.17647058823528`, 3.0329833551785965`}, {234.70588235294116`, 
        3.2544660366026563`}, {268.2352941176471, 3.469029064511409}}]}}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       NCache[
        Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6]}, {
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
        NCache[
         Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[
       1.6]}, {}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
        NCache[
         Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[
       1.6]}, {}}}, {{}, {}}}, {{}, {{{}, {}, 
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
        NCache[
         Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
       Dashing[{0.025, 0.015}], 
       LineBox[{{50.29411764705882, 1.4686045034706146`}, {67.05882352941177, 
        1.5024628714637698`}, {83.8235294117647, 1.5439205505528972`}, {
        100.58823529411764`, 1.5903348457716409`}, {134.11764705882354`, 
        1.6921236789650012`}, {167.6470588235294, 1.800548390249779}, {
        201.17647058823528`, 1.9122698880095093`}, {234.70588235294116`, 
        2.025590296732809}, {268.2352941176471, 2.1395825044474406`}}]}}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       NCache[
        Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
      Dashing[{0.025, 0.015}]}, {
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
        NCache[
         Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
       Dashing[{0.025, 0.015}]}, {}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
        NCache[
         Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
       Dashing[{0.025, 0.015}]}, {}}}, {{}, {}}}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"Spacer length, bp\"", TraditionalForm], 
    FormBox[
     TemplateBox[{"\"frictional coefficient x\"", 
       TemplateBox[{"10", "7"}, "Superscript", SyntaxForm -> SuperscriptBox], 
       "\"g/s\""}, "RowDefault"], TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{
    FormBox["\"Spacer length, bp\"", TraditionalForm], 
    FormBox[
     TemplateBox[{"\"frictional coefficient x\"", 
       TemplateBox[{"10", "7"}, "Superscript", SyntaxForm -> SuperscriptBox], 
       "\"g/s\""}, "RowDefault"], TraditionalForm]},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 290}, {0, 3.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.800185674346044*^9, {3.800185870503861*^9, 3.8001858816177483`*^9}, 
   3.800185930219329*^9, 3.8001860018168583`*^9},
 CellLabel->
  "Out[102]=",ExpressionUUID->"fa203155-bda2-496a-b6d6-e2b79cfcf052"]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{1387, 1031},
WindowMargins->{{8, Automatic}, {15, Automatic}},
ShowSelection->True,
ShowCellLabel->True,
ShowCellTags->False,
Magnification->1.5,
FrontEndVersion->"12.0 for Linux ARM (32-bit) (June 23, 2019)",
StyleDefinitions->"Default.nb",
PrivateNotebookOptions -> {"ColorPalette" -> {RGBColor, -1}},
RenderingOptions -> {"ObjectDithering" -> True},
RenderingOptions -> {"RasterDithering" -> False}
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 523, 10, 144, "SmallText",ExpressionUUID->"2a0a6e22-83d7-42bb-87af-32bbc5311837"],
Cell[1084, 32, 344, 6, 79, "SmallText",ExpressionUUID->"07cc8f0e-0494-4ec4-b2f8-3a26d6015466"],
Cell[1431, 40, 1088, 19, 471, "Text",ExpressionUUID->"70f864aa-41b5-45d4-aa48-14efe28c603b"],
Cell[2522, 61, 267, 8, 100, "Input",ExpressionUUID->"1c861089-8971-4b93-aa83-d198f2a06979",
 PageBreakWithin->Automatic,
 InitializationCell->True],
Cell[2792, 71, 994, 20, 470, "Input",ExpressionUUID->"977f2be0-ffa2-4f12-8b29-cd79a234905c",
 InitializationCell->True],
Cell[3789, 93, 996, 28, 727, "Input",ExpressionUUID->"a3fc05c1-596d-4903-b136-5cbe08c3a53a",
 InitializationCell->True],
Cell[4788, 123, 284, 8, 157, "Input",ExpressionUUID->"62222df1-7473-4492-91cf-58976cb8aaf5",
 InitializationCell->True],
Cell[5075, 133, 183, 4, 54, "Text",ExpressionUUID->"610c079a-48f2-4055-bd63-c1cc43fa2a31"],
Cell[5261, 139, 227, 6, 104, "Input",ExpressionUUID->"c67f137b-eb9a-4295-8cbe-6a4233622174"],
Cell[5491, 147, 191, 3, 54, "Text",ExpressionUUID->"db9d08d1-9e8b-417e-a737-2c8957138ca8"],
Cell[5685, 152, 321, 8, 133, "Input",ExpressionUUID->"153c6721-d0ea-40b6-8c57-3c89c16d393c"],
Cell[CellGroupData[{
Cell[6031, 164, 164, 3, 47, "Input",ExpressionUUID->"dff6ad5f-2314-4407-b946-e22830ae080a"],
Cell[6198, 169, 505, 9, 74, "Output",ExpressionUUID->"e286b613-6163-4fa3-bef5-e6378d3ef18c"]
}, Open  ]],
Cell[6718, 181, 153, 3, 47, "Input",ExpressionUUID->"8804ab71-13ed-464a-a4ac-6a70c4a62bd2"],
Cell[6874, 186, 199, 5, 50, "Text",ExpressionUUID->"8d8c80bd-811f-4bde-8704-5040ab27573c"],
Cell[CellGroupData[{
Cell[7098, 195, 763, 32, 817, "Input",ExpressionUUID->"a9134c89-3784-460e-9780-6fd109d8f463"],
Cell[7864, 229, 405, 9, 37, "Print",ExpressionUUID->"8de170d1-d21d-4bbf-beca-4be858910db3"],
Cell[8272, 240, 259, 5, 37, "Print",ExpressionUUID->"6d9636ac-cfd3-4174-8777-fdc5883b3854"],
Cell[8534, 247, 293, 5, 37, "Print",ExpressionUUID->"0fc3b615-05ae-48e9-a370-4e44298daa41"],
Cell[8830, 254, 667, 17, 64, "Print",ExpressionUUID->"0315ffc9-36b4-4cb0-a65a-069ece8eb4c8"],
Cell[9500, 273, 263, 5, 37, "Print",ExpressionUUID->"f19ba4b6-5bf2-4b0c-9f3e-09d0affad841"],
Cell[9766, 280, 291, 5, 37, "Print",ExpressionUUID->"ec419610-1500-4a72-b50f-c5080e9eb1ea"],
Cell[10060, 287, 670, 17, 64, "Print",ExpressionUUID->"60159124-d32f-4844-9bd2-28048cdf2ea5"],
Cell[10733, 306, 405, 9, 37, "Print",ExpressionUUID->"2a6b1d66-10b5-4ffb-9d73-acc4f08e1a10"],
Cell[11141, 317, 259, 5, 37, "Print",ExpressionUUID->"03d74aae-b582-4000-bd7c-5410727144d3"],
Cell[11403, 324, 293, 5, 37, "Print",ExpressionUUID->"a475f116-ade0-4cc1-9fa3-0262b98b2806"],
Cell[11699, 331, 669, 17, 64, "Print",ExpressionUUID->"988e681d-b820-4c4f-953d-4eec73c30878"],
Cell[12371, 350, 265, 5, 37, "Print",ExpressionUUID->"1047bcf5-2fdc-40ba-90c4-c94023ee223f"],
Cell[12639, 357, 291, 5, 37, "Print",ExpressionUUID->"0424a385-15cb-4eb6-a0fe-e6e3032d72cb"],
Cell[12933, 364, 670, 17, 64, "Print",ExpressionUUID->"043f5792-5dcc-48ac-b67e-77bd9de5f692"],
Cell[13606, 383, 403, 9, 37, "Print",ExpressionUUID->"bb01584e-6ca5-45cb-8876-10304ef067e9"],
Cell[14012, 394, 259, 5, 37, "Print",ExpressionUUID->"95abf50d-35f9-4742-a9c2-108a9540255e"],
Cell[14274, 401, 291, 5, 37, "Print",ExpressionUUID->"2b0209ed-234d-4929-a4ad-1f5a5675330d"],
Cell[14568, 408, 672, 17, 64, "Print",ExpressionUUID->"d4ddf2ed-f66f-43f4-a3d5-4dcec39bf79a"],
Cell[15243, 427, 265, 5, 37, "Print",ExpressionUUID->"3aa47b5d-8bd4-4702-8e00-9ed418176017"],
Cell[15511, 434, 291, 5, 37, "Print",ExpressionUUID->"1cb06f15-e3c7-4018-9ce4-c8433ea50b2e"],
Cell[15805, 441, 670, 17, 64, "Print",ExpressionUUID->"7ea176ee-935f-476c-b2fb-c5f44c74a350"],
Cell[16478, 460, 408, 9, 37, "Print",ExpressionUUID->"3898ab42-c5ca-424d-90d3-361476eb8064"],
Cell[16889, 471, 259, 5, 37, "Print",ExpressionUUID->"90bf75c1-426c-4414-a496-a5835578f92e"],
Cell[17151, 478, 293, 5, 37, "Print",ExpressionUUID->"9d8ac8f0-8058-4dea-a59a-a73c9b8f5e21"],
Cell[17447, 485, 670, 17, 64, "Print",ExpressionUUID->"d5995678-073a-47af-b2c8-a7b3ad5706a0"],
Cell[18120, 504, 263, 5, 37, "Print",ExpressionUUID->"bf60a824-8868-4fcf-9c27-1e1a1348081d"],
Cell[18386, 511, 293, 5, 37, "Print",ExpressionUUID->"928f96ed-a607-457c-a8fc-5ba74090b627"],
Cell[18682, 518, 670, 17, 64, "Print",ExpressionUUID->"a3b4f48a-3733-4d63-aa52-7fee47e44782"],
Cell[19355, 537, 408, 9, 37, "Print",ExpressionUUID->"46431cbf-92e3-48a3-a3a6-f0809527a53f"],
Cell[19766, 548, 259, 5, 37, "Print",ExpressionUUID->"4c747b72-e6ab-44e8-a382-af85ebb1e543"],
Cell[20028, 555, 291, 5, 37, "Print",ExpressionUUID->"bb6d6b49-1a35-43ba-8b5e-423b1cbed67e"],
Cell[20322, 562, 670, 17, 64, "Print",ExpressionUUID->"4550c92d-550c-4f83-b662-efe75668638b"],
Cell[20995, 581, 262, 5, 37, "Print",ExpressionUUID->"bed48aeb-ed66-4440-acf0-19162b17ae0a"],
Cell[21260, 588, 293, 5, 37, "Print",ExpressionUUID->"8687761a-e77f-4561-9f9e-2af7465599cd"],
Cell[21556, 595, 670, 17, 64, "Print",ExpressionUUID->"a7777602-a732-40ca-a821-1a1d0c2c94e0"],
Cell[22229, 614, 405, 9, 37, "Print",ExpressionUUID->"928fd954-bd09-4634-b180-e37c30ee861d"],
Cell[22637, 625, 259, 5, 37, "Print",ExpressionUUID->"28016caa-556c-4d04-8c3a-c19521aee06a"],
Cell[22899, 632, 293, 5, 37, "Print",ExpressionUUID->"951da11a-b493-434a-a568-172ab946d9f0"],
Cell[23195, 639, 670, 17, 64, "Print",ExpressionUUID->"4ca60293-769a-4514-b071-b36dca8c580f"],
Cell[23868, 658, 263, 5, 37, "Print",ExpressionUUID->"c25e349c-01c2-4fdb-88a1-5b0d4721612c"],
Cell[24134, 665, 291, 5, 37, "Print",ExpressionUUID->"d98b5218-dfd8-4503-b2b0-ac54ac2a454f"],
Cell[24428, 672, 667, 17, 64, "Print",ExpressionUUID->"6789d297-9798-46d9-b193-1f1e7c37abdd"],
Cell[25098, 691, 408, 9, 37, "Print",ExpressionUUID->"cba6f593-d1fd-4b48-8d6d-be7557d0bb69"],
Cell[25509, 702, 259, 5, 37, "Print",ExpressionUUID->"e8aca33d-20f1-4a59-b364-7741197bad71"],
Cell[25771, 709, 291, 5, 37, "Print",ExpressionUUID->"b15df392-1dce-49c2-8ba9-70f60bf10748"],
Cell[26065, 716, 669, 17, 64, "Print",ExpressionUUID->"ce9d9554-7c3e-45c0-a83c-c50f2e072227"],
Cell[26737, 735, 265, 5, 37, "Print",ExpressionUUID->"fd443b75-d525-4247-b9ae-194ea02ddaac"],
Cell[27005, 742, 291, 5, 37, "Print",ExpressionUUID->"162bf2ef-4133-459e-b003-8d725fb30040"],
Cell[27299, 749, 664, 17, 64, "Print",ExpressionUUID->"c175dce1-cdac-47de-b584-e227a3eb5f3a"],
Cell[27966, 768, 410, 9, 37, "Print",ExpressionUUID->"73767975-2eca-4bf9-baa5-8c5b8827e385"],
Cell[28379, 779, 259, 5, 37, "Print",ExpressionUUID->"5c2440aa-19ea-4348-8a04-ed31584c7d60"],
Cell[28641, 786, 293, 5, 37, "Print",ExpressionUUID->"148e516b-685a-4949-a525-67052aaaa0f5"],
Cell[28937, 793, 670, 17, 64, "Print",ExpressionUUID->"c6f0bae1-1005-4eda-9822-9a69a2e3218f"],
Cell[29610, 812, 262, 5, 37, "Print",ExpressionUUID->"4b147f6c-23ba-49ec-9f49-c01ac9abf087"],
Cell[29875, 819, 291, 5, 37, "Print",ExpressionUUID->"c029cea2-787e-464a-88dc-acf380aabb41"],
Cell[30169, 826, 669, 17, 64, "Print",ExpressionUUID->"42b13cc3-e31d-46ea-9b1a-452820318e39"],
Cell[30841, 845, 404, 9, 37, "Print",ExpressionUUID->"ca6d315b-51af-44fa-b453-459c2229caf4"],
Cell[31248, 856, 258, 5, 37, "Print",ExpressionUUID->"b7026685-763f-4460-88ea-74c44cde7c42"],
Cell[31509, 863, 291, 5, 37, "Print",ExpressionUUID->"8e77771b-0322-4ac4-a7c4-2e01a1ad91ae"],
Cell[31803, 870, 669, 17, 64, "Print",ExpressionUUID->"d4edac5d-137b-4061-8d81-2a49a1b39a7d"],
Cell[32475, 889, 263, 5, 37, "Print",ExpressionUUID->"13a920cc-b6c8-4047-8b4a-7a1a0010488b"],
Cell[32741, 896, 291, 5, 37, "Print",ExpressionUUID->"4eda37da-e138-4dd0-b539-3e9197a01fa7"],
Cell[33035, 903, 667, 17, 64, "Print",ExpressionUUID->"75e26ab7-96dc-4b18-b7fa-85d10fc36998"]
}, Open  ]],
Cell[33717, 923, 566, 11, 187, "Text",ExpressionUUID->"d2e49376-16a4-40ea-aec1-16792c2d4981"],
Cell[CellGroupData[{
Cell[34308, 938, 432, 11, 47, "Input",ExpressionUUID->"edf8556d-39a3-451c-bbf2-367780a4d7ef"],
Cell[34743, 951, 2360, 63, 482, "Output",ExpressionUUID->"3bd52cdb-d789-42df-8c32-de601c7a4766"]
}, Open  ]],
Cell[37118, 1017, 423, 12, 142, "Input",ExpressionUUID->"84c8bb8c-1c6d-4ba0-91ba-586260321b16"],
Cell[37544, 1031, 277, 7, 80, "Text",ExpressionUUID->"b9a9c1f7-8c41-446e-bbfe-ed757de131a4"],
Cell[37824, 1040, 12796, 261, 545, 8954, 193, "GraphicsData", "PostScript", "Graphics",ExpressionUUID->"6b67c8a3-ac97-47b5-903b-3887c37d4673",
 Evaluatable->False],
Cell[50623, 1303, 199, 5, 50, "Text",ExpressionUUID->"740d14c2-3b9a-4b9d-9930-f1f12161a0c6"],
Cell[50825, 1310, 327, 6, 86, "Text",ExpressionUUID->"77e1a716-7389-42c6-8cfb-df98878aa870"],
Cell[CellGroupData[{
Cell[51177, 1320, 918, 37, 959, "Input",ExpressionUUID->"f192879c-eece-4888-a711-e8121504a79e"],
Cell[52098, 1359, 407, 9, 37, "Print",ExpressionUUID->"47595c39-4c1e-4cf5-9b68-8c76de200b8d"],
Cell[52508, 1370, 260, 5, 37, "Print",ExpressionUUID->"e48de843-05fd-4edc-a5da-0bdf37dae98d"],
Cell[52771, 1377, 293, 5, 37, "Print",ExpressionUUID->"502b9a35-6dfb-42bc-b7c5-9e36903e80db"],
Cell[53067, 1384, 669, 17, 64, "Print",ExpressionUUID->"33647824-25c2-4472-b13d-59cb6ccc4bd7"],
Cell[53739, 1403, 267, 5, 37, "Print",ExpressionUUID->"9f6fc9f2-7cd7-4588-9482-74d3f40543d6"],
Cell[54009, 1410, 295, 5, 37, "Print",ExpressionUUID->"ad12fe56-d5e1-43e1-8cfb-79fd3e7f882f"],
Cell[54307, 1417, 672, 17, 64, "Print",ExpressionUUID->"f369de19-5425-44fa-9cf1-29ce5795e99c"],
Cell[54982, 1436, 407, 9, 37, "Print",ExpressionUUID->"a6f867be-80be-480e-9e7c-23146f1124f3"],
Cell[55392, 1447, 261, 5, 37, "Print",ExpressionUUID->"b6913fa0-9a92-4560-b5d1-7c10963a86a8"],
Cell[55656, 1454, 295, 5, 37, "Print",ExpressionUUID->"6ccb02a8-65b0-4794-b573-f6e97fe7872f"],
Cell[55954, 1461, 669, 17, 64, "Print",ExpressionUUID->"87bfac6c-77ec-4ba6-b518-72a469595c83"],
Cell[56626, 1480, 267, 5, 37, "Print",ExpressionUUID->"6a85ac5a-9dcb-4ce2-94c0-84f19202abd9"],
Cell[56896, 1487, 293, 5, 37, "Print",ExpressionUUID->"e1d3149c-98f9-4729-b7bc-ad8aa0467732"],
Cell[57192, 1494, 669, 17, 64, "Print",ExpressionUUID->"82b3e359-e26a-4866-893a-d06302295eb9"],
Cell[57864, 1513, 405, 9, 37, "Print",ExpressionUUID->"f079e982-f7f9-4293-95de-fddf853af126"],
Cell[58272, 1524, 261, 5, 37, "Print",ExpressionUUID->"f4e1569b-3083-41bd-9866-8eac348cb36c"],
Cell[58536, 1531, 293, 5, 37, "Print",ExpressionUUID->"865680db-3122-4455-b6e2-45cf6ca03599"],
Cell[58832, 1538, 669, 17, 64, "Print",ExpressionUUID->"be42d43a-a922-4a05-b4d2-1ea19d807cdc"],
Cell[59504, 1557, 265, 5, 37, "Print",ExpressionUUID->"c8879fc5-410c-4a78-a7f4-eafc36a4be63"],
Cell[59772, 1564, 293, 5, 37, "Print",ExpressionUUID->"cd012f79-4e01-4bbc-9c7d-34805f9f85c6"],
Cell[60068, 1571, 669, 17, 64, "Print",ExpressionUUID->"68d6abe2-63d2-4004-baac-211cc8250a1d"],
Cell[60740, 1590, 410, 9, 37, "Print",ExpressionUUID->"a977ec06-9057-4f4a-b107-cf05098444a1"],
Cell[61153, 1601, 261, 5, 37, "Print",ExpressionUUID->"45d52f44-b035-4be8-b901-10187b015209"],
Cell[61417, 1608, 295, 5, 37, "Print",ExpressionUUID->"85939a21-38e7-4369-8d86-54f89506e897"],
Cell[61715, 1615, 672, 17, 64, "Print",ExpressionUUID->"e6c3af1a-4238-48e1-ad08-0311defcb604"],
Cell[62390, 1634, 267, 5, 37, "Print",ExpressionUUID->"ea22c5f8-7f2a-4ef4-b447-09de62a33a09"],
Cell[62660, 1641, 293, 5, 37, "Print",ExpressionUUID->"067cede3-5636-43fb-a8eb-a694a0a846ae"],
Cell[62956, 1648, 666, 17, 64, "Print",ExpressionUUID->"b9d10194-3e5c-4962-9346-53703b36b205"],
Cell[63625, 1667, 410, 9, 37, "Print",ExpressionUUID->"15211a40-49c6-42b8-b436-975430c75475"],
Cell[64038, 1678, 263, 5, 37, "Print",ExpressionUUID->"4ff85d85-de94-4c69-a2e3-19c634edc48a"],
Cell[64304, 1685, 293, 5, 37, "Print",ExpressionUUID->"5e95615f-20fc-4805-9f36-0d5dc2b4e7c9"],
Cell[64600, 1692, 670, 17, 64, "Print",ExpressionUUID->"ee569cba-ed6d-4534-9467-dfeb2fe01dd5"],
Cell[65273, 1711, 267, 5, 37, "Print",ExpressionUUID->"600862d4-298e-4377-a54a-188316a3a4c0"],
Cell[65543, 1718, 293, 5, 37, "Print",ExpressionUUID->"42b99a09-4e9b-4560-9faf-0f489688fc1a"],
Cell[65839, 1725, 672, 17, 64, "Print",ExpressionUUID->"53f11ae1-ed70-43bc-8b61-244e6bff0458"],
Cell[66514, 1744, 407, 9, 37, "Print",ExpressionUUID->"70f7553b-d94b-426f-854d-478348da9a6b"],
Cell[66924, 1755, 263, 5, 37, "Print",ExpressionUUID->"2d9cb617-4fc2-41a6-a4a8-2b3189ad463e"],
Cell[67190, 1762, 293, 5, 37, "Print",ExpressionUUID->"f0bab25b-67ca-4d5c-88ec-6dcafb07c13a"],
Cell[67486, 1769, 669, 17, 64, "Print",ExpressionUUID->"e3e29598-8be5-4737-89b9-4951da8b1fed"],
Cell[68158, 1788, 267, 5, 37, "Print",ExpressionUUID->"238fb67a-7396-4fce-aadc-d9d7ab0d53f1"],
Cell[68428, 1795, 293, 5, 37, "Print",ExpressionUUID->"aea00776-e302-4e18-9e8e-6efcb4d84fe3"],
Cell[68724, 1802, 666, 17, 64, "Print",ExpressionUUID->"9bf92bb6-d28f-48ac-86da-2c654f2aa1a9"],
Cell[69393, 1821, 410, 9, 37, "Print",ExpressionUUID->"3230ac4d-5140-4dc5-8a3b-c9cece4068e5"],
Cell[69806, 1832, 263, 5, 37, "Print",ExpressionUUID->"9addfb02-a985-423f-a616-89ec0e0403d6"],
Cell[70072, 1839, 293, 5, 37, "Print",ExpressionUUID->"ebc08239-0ac9-47cc-8cb3-e9dc6c090ea4"],
Cell[70368, 1846, 669, 17, 64, "Print",ExpressionUUID->"b48bb5e8-233d-41ed-bc43-261a729eb522"],
Cell[71040, 1865, 265, 5, 37, "Print",ExpressionUUID->"71816cb3-8196-477f-9681-cc20ec2a8f02"],
Cell[71308, 1872, 293, 5, 37, "Print",ExpressionUUID->"1de83882-cf7e-4e1c-82a5-0b6fee6c0b92"],
Cell[71604, 1879, 669, 17, 64, "Print",ExpressionUUID->"beb63249-7b68-41c8-a930-ae781b8b6db4"],
Cell[72276, 1898, 410, 9, 37, "Print",ExpressionUUID->"717be505-fd19-45b7-809c-c8da7cab9dfe"],
Cell[72689, 1909, 261, 5, 37, "Print",ExpressionUUID->"50abd6dc-a60a-4df0-bef6-1bf92cd6a890"],
Cell[72953, 1916, 293, 5, 37, "Print",ExpressionUUID->"81ad2a94-c147-4a36-a6f0-9f7f81887052"],
Cell[73249, 1923, 672, 17, 64, "Print",ExpressionUUID->"5f6ccc9d-1abb-4719-af45-94a15f4e1e3b"],
Cell[73924, 1942, 265, 5, 37, "Print",ExpressionUUID->"02fd517c-c973-46cf-a556-58d7872f55cf"],
Cell[74192, 1949, 293, 5, 37, "Print",ExpressionUUID->"59a52437-d61f-419e-bed3-83fac51f4198"],
Cell[74488, 1956, 669, 17, 64, "Print",ExpressionUUID->"10498910-8ba8-4ec6-8450-a0f78ecfc829"],
Cell[75160, 1975, 407, 9, 37, "Print",ExpressionUUID->"c3437385-d885-41ce-a2ff-4a97d1ceadbc"],
Cell[75570, 1986, 261, 5, 37, "Print",ExpressionUUID->"1fe3d9fb-bf23-491e-a526-cdd4f07de94f"],
Cell[75834, 1993, 293, 5, 37, "Print",ExpressionUUID->"db935fe3-5496-479e-a785-5ce818bb5f8e"],
Cell[76130, 2000, 668, 17, 64, "Print",ExpressionUUID->"45849622-da27-4f9e-86e7-7aaa2146db73"],
Cell[76801, 2019, 265, 5, 37, "Print",ExpressionUUID->"295ad2fe-4ee0-426c-bc40-e5289c4c7799"],
Cell[77069, 2026, 293, 5, 37, "Print",ExpressionUUID->"83449fe8-8cf7-45b4-92df-aab7d6aab30b"],
Cell[77365, 2033, 669, 17, 64, "Print",ExpressionUUID->"5bc0f319-69a8-4218-9099-67f6f619723b"]
}, Open  ]],
Cell[78049, 2053, 566, 11, 187, "Text",ExpressionUUID->"db92427a-7006-4c0f-82db-379c3406f611"],
Cell[CellGroupData[{
Cell[78640, 2068, 202, 4, 47, "Input",ExpressionUUID->"7a2fa8db-5b6f-4824-8707-594aea979f9a"],
Cell[78845, 2074, 2357, 63, 482, "Output",ExpressionUUID->"13d58ded-55f7-4d76-8328-2a3cdd2ea533"]
}, Open  ]],
Cell[81217, 2140, 423, 12, 142, "Input",ExpressionUUID->"032bf2ad-cf5d-431f-9939-455117192e46"],
Cell[81643, 2154, 286, 7, 80, "Text",ExpressionUUID->"1d51e8c9-4b34-40de-ab5c-6d2c7d6d07cc"],
Cell[81932, 2163, 12995, 264, 545, 8946, 193, "GraphicsData", "PostScript", "Graphics",ExpressionUUID->"f9dfc2a8-01e8-4a17-8c7a-5f8a5323ea9f",
 Evaluatable->False],
Cell[94930, 2429, 461, 9, 151, "Text",ExpressionUUID->"72afb9ed-e13f-4bb4-9229-714a393260eb"],
Cell[95394, 2440, 495, 11, 82, "Input",ExpressionUUID->"3ce55973-622c-4e73-be88-a87875475c5e"],
Cell[95892, 2453, 1478, 32, 150, "Input",ExpressionUUID->"b2bcb359-65ea-4450-9a17-ffbc3a8e33a6"],
Cell[CellGroupData[{
Cell[97395, 2489, 2833, 69, 328, "Input",ExpressionUUID->"599b4132-d509-41cb-a677-b89d78e62fab"],
Cell[100231, 2560, 6160, 126, 583, "Output",ExpressionUUID->"fa203155-bda2-496a-b6d6-e2b79cfcf052"]
}, Open  ]]
}
]
*)

