% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_when.R
\name{mutate_when}
\alias{mutate_when}
\title{Conditional update of columns in data.table}
\usage{
mutate_when(data, when, ...)
}
\arguments{
\item{data}{data.frame}

\item{when}{An object which can be coerced to logical mode}

\item{...}{Name-value pairs of expressions}
}
\value{
data.table
}
\description{
Integrate \code{mutate} and \code{case_when} in \pkg{dplyr} and make
a new tidy verb for data.table.
}
\examples{
iris[3:8,]
iris[3:8,] \%>\%
  mutate_when(Petal.Width == .2,
              one = 1,Sepal.Length=2)
}
\seealso{
\code{\link[dplyr]{case_when}}
}
