% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longer_dt.R
\name{longer_dt}
\alias{longer_dt}
\title{Pivot data from wide to long}
\usage{
longer_dt(.data, ..., name = "name", value = "value", na.rm = FALSE)
}
\arguments{
\item{.data}{A data.frame}

\item{...}{Pattern for unchanged group or unquoted names. Pattern can accept
regular expression to match column names. It can recieve what \code{select_dt}
recieves.}

\item{name}{Name for the measured variable names column.
The default name is 'name'.}

\item{value}{Name for the molten data values column(s).
The default name is 'value'.}

\item{na.rm}{If \code{TRUE}, \code{NA} values will be removed from the molten data.}
}
\value{
A data.table
}
\description{
Analogous function for \code{pivot_longer} in \pkg{tidyr}.
}
\examples{

## Example 1:
stocks = data.frame(
  time = as.Date('2009-01-01') + 0:9,
  X = rnorm(10, 0, 1),
  Y = rnorm(10, 0, 2),
  Z = rnorm(10, 0, 4)
)

stocks

stocks \%>\%
  longer_dt(time)

stocks \%>\%
  longer_dt("ti")

# Example 2:

\donttest{
  library(tidyr)

  billboard \%>\%
    longer_dt(
      -"wk",
      name = "week",
      value = "rank",
      na.rm = TRUE
    )

  # or use:
  billboard \%>\%
    longer_dt(
      artist,track,date.entered,
      name = "week",
      value = "rank",
      na.rm = TRUE
    )

  # or use:
  billboard \%>\%
    longer_dt(
      1:3,
      name = "week",
      value = "rank",
      na.rm = TRUE
    )
}
}
\seealso{
\code{\link[tidyfst]{wider_dt}},
  \code{\link[data.table]{melt}},
  \code{\link[tidyr]{pivot_longer}}
}
