% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windrose_rasters.R
\name{windrose_rasters}
\alias{windrose_rasters}
\title{Generate a windrose raster stack from a stack of windfield rasters}
\usage{
windrose_rasters(w, outfile, order = "uvuv", ncores = 1, ...)
}
\arguments{
\item{w}{Raster stack of u and v wind components; note that these must be in
lat-long coordinates.}

\item{outfile}{File path to save output raster to.}

\item{order}{Either "uvuv" (the default) or "uuvv", indicating whether the u
and v components of the w object are alternating.}

\item{ncores}{Integer indicating the number of computing cores to use for
parallel processing. If multiple cores are used, an output file will be
saved for each core, appending the core number to the user-supplied
filename.}

\item{...}{Additional arguments passed to `windrose`}
}
\value{
An 8-layer raster stack, where each layer is wind conductance from
  the focal cell to one of its neighbors (clockwise starting in the SW).
}
\description{
Generate a windrose raster stack from a stack of windfield rasters
}
