% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windrose.R
\name{windrose}
\alias{windrose}
\title{Calculate 8-neighbor edge loadings from a time series of u and v windspeeds}
\usage{
windrose(x, p = 1)
}
\arguments{
\item{x}{A vector of wind data containing: latitude, resolution, u
windspeeds, v windspeeds}

\item{p}{A positive number indicating the power to raise windspeeds to (see details)}
}
\value{
A vector of 8 conductance values to neighboring cells, clockwise
  starting with the southwest neighbor. If input windspeeds are in m/s,
  values are in (1 / seconds ^ p)
}
\description{
Calculate 8-neighbor edge loadings from a time series of u and v windspeeds
}
\details{
A value of p = 0 will ignore speed, assigning weights based on
  direction only. P = 1 assumes conductance is proportional to windspeed, p =
  2 assumes it's proportional to aerodynamic drag, and p = 3 assumes it's
  proportional to force. Any intermediate value can also be used.
}
