% 2020.02.12, Yaohua Xie
%
% pInfo - the information of people in this group.
% cResult - the checked results of people in this group.
% M - each group will be divided into M smaller groups.
function HandleThisGroup(pInfo, M)

global chkResult;
if (size(pInfo,1) > M) % The group has more people than M.
    % Divide pInfo into smaller sub-groups:
    N = floor(size(pInfo,1)/M); % The number of people in each of the sub-group.
    for i = 1 : M % Handle each sub-group.
        s = (i-1)*N + 1; % The starting number of the present sub-group.
        if (i < M)
            pInfoSub = pInfo(s:s+N-1, :);
        else
            % The last sub-group includes all the rest people:
            pInfoSub = pInfo(s:size(pInfo,1), :);
        end
        
        rSubGroup = CheckOneGroup(pInfoSub); % Get the result of the present sub-group.
        if (rSubGroup ==  true)
            % If this sub-group includes ill people, further check this sub-group recursively:
            HandleThisGroup(pInfoSub, M);
        else
            ExcludeOneGroup(pInfoSub);
        end

    end
else % The group has no more people than M.
    % Do not divide pInfo again, but check each person one by one:
    for i = 1 : size(pInfo,1)
        % Check each person's illness status, and recorded in
        % the cResult element with the same serial number:
        chkResult(pInfo(i,1), 2) = CheckOnePerson(pInfo(i, :));
   end
end