% 2020.02.12, Yaohua Xie
% This function represents the procedure of checking whether a group
% includes any ill people or not. In this function, this procedure is
% simulated by checking the sum of all the elements in this group.
% (sum=0: has no ill person, sum>0: has at least one ill person).
%
% pInfo - the information of people in this group.
function result = CheckOneGroup(pInfo)

global nGroupChecked;

S = sum(pInfo(:, 2));
if (S == 0)
    result = 0;
    nGroupChecked = nGroupChecked + 1;
elseif (S > 0)
    result = 1;
    nGroupChecked = nGroupChecked + 1;
else
    result = NaN;
end
