# -*- coding: utf-8 -*-
"""
/***************************************************************************
 modelDialog
                                 A QGIS plugin
 Landslide Susceptibility Zoning
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2019-06-22
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Giacomo Titti & Alessandro Sarretta
        email                : giacomotitti@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt.QtCore import pyqtSlot,  Qt,  QUrl,  QFileInfo
from PyQt5 import uic
from PyQt5 import QtCore, QtGui, QtWidgets
from PyQt5.QtGui import QIcon
from qgis.core import *
from qgis.PyQt import uic
from qgis.PyQt import QtNetwork
from qgis.PyQt.QtGui import QIntValidator
from qgis.PyQt.QtWidgets import *
from qgis.utils import iface

import json
import os
import processing
import datetime
import tempfile
import math

from qgis.analysis import QgsZonalStatistics
from PyQt5 import QtGui, QtWidgets, uic, QtCore
from PyQt5.QtCore import pyqtSignal
from collections import OrderedDict

from qgis.core import Qgis, QgsFeedback, QgsGeometry, QgsWkbTypes, QgsRasterLayer, QgsProject, QgsVectorLayer, QgsRectangle, QgsCoordinateReferenceSystem,QgsExpressionContextUtils,QgsMapLayer
from qgis.gui import QgsFileWidget, QgsMapTool, QgsRubberBand, QgsProjectionSelectionWidget
from qgis.core import QgsProcessing

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterExtent
import processing
from qgis import gui

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'LSZ_dialog_base.ui'))



class modelDialog(QtWidgets.QDialog, FORM_CLASS):
    #closingPlugin = pyqtSignal()

    def __init__(self, parent=None):
        """Constructor."""
        super(modelDialog, self).__init__(parent)
        self.setupUi(self)
        self.iface = iface



        #self.tabs.blockSignals(False) #now listen the currentChanged signal


        self.comboExtentChoiche = comboExtent(self)
        self.comboExtentChoiche.setObjectName("extent_choice")
        self.gridLayout_2.addWidget(self.comboExtentChoiche, 47, 2, 1, 1)

        self.crsChoice = QgsProjectionSelectionWidget()
        self.crsChoice.setObjectName("crs_choice")
        self.gridLayout_2.addWidget(self.crsChoice, 63, 2, 1, 1)

        self.comboExtentChoiche.setCurrentIndex(0)
        self.crsChoice.setCrs(QgsCoordinateReferenceSystem('EPSG:3857'))

        self.ext=self.comboExtentChoiche.currentExtent()
        self.mMapLayerComboBox_2.setFilters(QgsMapLayerProxyModel.PointLayer)

        self.checkBox.setEnabled(True)
        self.checkBox.setChecked(True)
        self.mMapLayerComboBox.setFilters(QgsMapLayerProxyModel.PolygonLayer)
        self.checkBox.toggled.connect(self.mMapLayerComboBox.setEnabled)

        self.mMapLayerComboBox_4.setFilters(QgsMapLayerProxyModel.RasterLayer)

        self.checkBox_6.setEnabled(True)
        self.checkBox_6.setChecked(True)
        self.mMapLayerComboBox_6.setFilters(QgsMapLayerProxyModel.RasterLayer)

        self.checkBox_6.toggled.connect(self.mMapLayerComboBox_6.setEnabled)
        self.checkBox_6.toggled.connect(self.lineEdit_7.setEnabled)
        self.checkBox_6.toggled.connect(self.pushButton_7.setEnabled)

        self.checkBox_8.setEnabled(True)
        self.checkBox_8.setChecked(True)
        self.mMapLayerComboBox_8.setFilters(QgsMapLayerProxyModel.RasterLayer)

        self.checkBox_8.toggled.connect(self.mMapLayerComboBox_8.setEnabled)
        self.checkBox_8.toggled.connect(self.lineEdit_8.setEnabled)
        self.checkBox_8.toggled.connect(self.pushButton_8.setEnabled)

        self.checkBox_10.setEnabled(True)
        self.checkBox_10.setChecked(True)
        self.mMapLayerComboBox_10.setFilters(QgsMapLayerProxyModel.RasterLayer)

        self.checkBox_10.toggled.connect(self.mMapLayerComboBox_10.setEnabled)
        self.checkBox_10.toggled.connect(self.lineEdit_9.setEnabled)
        self.checkBox_10.toggled.connect(self.pushButton_9.setEnabled)

        self.checkBox_2.setEnabled(True)
        self.checkBox_2.setChecked(False)
        self.lineEdit_16.setEnabled(False)
        self.pushButton_12.setEnabled(False)
        self.checkBox_2.toggled.connect(self.lineEdit_16.setEnabled)
        self.checkBox_2.toggled.connect(self.pushButton_12.setEnabled)

        self.mMapLayerComboBox_3.setFilters(QgsMapLayerProxyModel.VectorLayer)
        self.mMapLayerComboBox_5.setFilters(QgsMapLayerProxyModel.RasterLayer)
        self.mMapLayerComboBox_7.setFilters(QgsMapLayerProxyModel.VectorLayer)
        self.mMapLayerComboBox_9.setFilters(QgsMapLayerProxyModel.VectorLayer)

        self.indice=0
        self.methodindice=0
        #self.tabs = QTabWidget()
        #self.tabs.blockSignals(True) #just for not showing the initial message
        self.tabWidget.currentChanged.connect(self.onChange) #changed!

        self.comboBox.addItem("Weight of Evidence",0)
        self.comboBox.addItem("Frequency Ratio",1)
        self.comboBox.currentIndexChanged.connect(self.selectionchange)

        self.ii=0
        self.groupBoxlista={}
        self.mMapLayerComboBoxlista={}
        self.pushButtonlista={}
        self.lineEditlista={}
        self.lineEditname={}
        #self.pushButton_2.clicked.connect(self.clickMethod)
        #self.second_start = True
        self.checkBox_3.setEnabled(True)
        self.checkBox_3.setChecked(False)
        self.lineEdit_2.setEnabled(False)
        self.pushButton_3.setEnabled(False)
        self.checkBox_3.toggled.connect(self.lineEdit_2.setEnabled)
        self.checkBox_3.toggled.connect(self.pushButton_3.setEnabled)

    def clickMethod(self):
        causenumber=self.ii
        if causenumber<=5:#10 cause
            self.groupBoxlista[self.ii]='groupBox'+str(self.ii)
            self.mMapLayerComboBoxlista[self.ii]='mMapLayerComboBox'+str(self.ii)
            self.pushButtonlista[self.ii]='pushButton'+str(self.ii)
            self.lineEditlista[self.ii]='lineEdit'+str(self.ii)
            self.lineEditname[self.ii]='lineEdit'+str(self.ii)
            self.groupBoxlista[self.ii] = QtWidgets.QGroupBox(self.scrollAreaWidgetContents)
            self.groupBoxlista[self.ii].setAutoFillBackground(True)
            self.groupBoxlista[self.ii].setFlat(False)
            self.groupBoxlista[self.ii].setObjectName("groupBox"+str(self.ii))
            self.gridLayout_n = QtWidgets.QGridLayout(self.groupBoxlista[self.ii])
            self.gridLayout_n.setObjectName("gridLayout_"+str(self.ii))
            self.pushButtonlista[self.ii] = QtWidgets.QPushButton(self.groupBoxlista[self.ii])
            self.pushButtonlista[self.ii].setObjectName("pushButton_"+str(self.ii))
            self.gridLayout_n.addWidget(self.pushButtonlista[self.ii], 2, 1, 1, 1)
            self.lineEditlista[self.ii] = QtWidgets.QLineEdit(self.groupBoxlista[self.ii])
            self.lineEditlista[self.ii].setObjectName("lineEdit_"+str(self.ii))
            self.gridLayout_n.addWidget(self.lineEditlista[self.ii], 2, 0, 1, 1)
            self.label_n = QtWidgets.QLabel(self.groupBoxlista[self.ii])
            self.label_n.setObjectName("label_"+str(self.ii))
            self.gridLayout_n.addWidget(self.label_n, 1, 0, 1, 1)
            self.mMapLayerComboBoxlista[self.ii] = gui.QgsMapLayerComboBox(self.groupBoxlista[self.ii])
            self.mMapLayerComboBoxlista[self.ii].setObjectName("mMapLayerComboBox_"+str(self.ii))
            self.mMapLayerComboBoxlista[self.ii].setFilters(QgsMapLayerProxyModel.RasterLayer)
            self.gridLayout_n.addWidget(self.mMapLayerComboBoxlista[self.ii], 0, 0, 1, 1)
            self.gridLayout_2.addWidget(self.groupBoxlista[self.ii], 23+self.ii, 2, 1, 1)
            self.groupBoxlista[self.ii].setTitle(QtCore.QCoreApplication.translate("WoEDialogBase", "Cause "+str(self.ii+5)))
            self.pushButtonlista[self.ii].setText(QtCore.QCoreApplication.translate("WoEDialogBase", "..."))
            self.label_n.setText(QtCore.QCoreApplication.translate("WoEDialogBase", "Cause "+str(self.ii+5)+" classes"))
            self.lineEditlista[self.ii].clear()
            self.pushButtonlista[self.ii].clicked.connect(self.selecttxt)
            self.ii+=1

    def selecttxt(self):
        filename, _ = QFileDialog.getOpenFileName(self, "Select input classes cause "+str(self.ii+4),"", '*.txt')
        self.lineEditlista[self.ii-1].setText(filename)

    def selectionchange(self,i):
        self.methodindice=i
        print("Items in the list are :")
        for count in range(self.comboBox.count()):
            print(self.comboBox.itemText(count))
            print("Current index",i,"selection changed ",self.comboBox.currentText())

    def onChange(self,i): #changed!
        self.indice=i
        QgsMessageLog.logMessage(str(i), tag="WoE")

    def closeEvent(self, event):
        #self.reset_form()
        for y in range(self.ii):
            self.groupBoxlista[y].setParent(None)
        self.ii=0

class comboExtent(QtWidgets.QComboBox):

    def __init__(self, parentModule, parent=None):
        super(comboExtent, self).__init__(parent)
        self.iface = parentModule.iface
        self.contextMapTool = selectExtentMapTool(self)
        self.activated.connect(self.checkItem)
        self.addItem("CANVAS EXTENT",'C')

    def showPopup(self):
        self.clear()
        self.addItem("CANVAS EXTENT",'C')
        for id,layer in QgsProject.instance().mapLayers().items():
            self.addItem("%s [%s]" % (layer.name(),layer.crs().authid()), layer)
        super(comboExtent, self).showPopup()

    def currentExtent(self):
        if self.currentData() == 'S':
            return self.selectedExtent
        elif self.currentData() == 'C':
            return self.iface.mapCanvas().extent()
        else:
            return self.currentData().extent()

    def checkItem(self):
        self.contextMapTool.reset()
        if self.currentData() == 'S':
            self.iface.mapCanvas().setMapTool(self.contextMapTool)

class selectExtentMapTool(QgsMapTool):

    def __init__(self, parentObj):
        self.parentObj = parentObj
        self.iface = parentObj.iface
        QgsMapTool.__init__(self, self.iface.mapCanvas())
        self.contextShape = QgsRubberBand(self.iface.mapCanvas(),QgsWkbTypes.LineGeometry )
        self.contextShape.setWidth( 1 )
        self.contextShape.setColor(QtCore.Qt.red)
        self.pressed = False

    def canvasPressEvent(self, event):
        self.pressed = True
        self.pressx = event.pos().x()
        self.pressy = event.pos().y()
        self.movex = event.pos().x()
        self.movey = event.pos().y()
        self.PressedPoint = self.iface.mapCanvas().getCoordinateTransform().toMapCoordinates(self.pressx, self.pressy)

    def canvasMoveEvent(self, event):
        if self.pressed:
            x = event.pos().x()
            y = event.pos().y()
            movedPoint = self.iface.mapCanvas().getCoordinateTransform().toMapCoordinates(x, y)
            self.contextShape.reset()
            self.contextgeom = QgsGeometry.fromRect(QgsRectangle(self.PressedPoint,movedPoint)).convertToType(QgsWkbTypes.LineGeometry)
            self.contextShape.setToGeometry(self.contextgeom)

    def canvasReleaseEvent(self, event):
        if self.pressed:
            x = event.pos().x()
            y = event.pos().y()
            releasedPoint = self.iface.mapCanvas().getCoordinateTransform().toMapCoordinates(x, y)
            self.pressed = False
            self.parentObj.selectedExtent = QgsRectangle(self.PressedPoint,releasedPoint)
            self.parentObj.iface.mapCanvas().setMapTool(None)

    def reset(self):
        self.contextShape.reset()


#class on():
    # def onChange(self,i): #changed!
    #     QtGui.QMessageBox.information(self,"Tab Index Changed!",           "Current Tab Index: %d" % i ) #changed!
