# -*- coding: utf-8 -*-
"""
/***************************************************************************
 model
                                 A QGIS plugin
 Landslide Susceptibility Zoning
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-06-22
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Giacomo Titti & Alessandro Sarretta
        email                : giacomotitti@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAction, QApplication, QWidget, QInputDialog, QLineEdit, QFileDialog

from .resources import *
from .LSZ_dialog import modelDialog
import os.path
##############################
import numpy as np
from osgeo import gdal,osr
import sys
import math
import csv
from .classe import WoE
#from .testroc import classifier
from qgis.core import QgsMessageLog, QgsProject, QgsRasterLayer
#import scipy.misc as im
import sys
##############################
#from .roc_dialog import gaDialog
#import os.path
#import numpy as np
import matplotlib.pyplot as plt
#from itertools import cycle
#from sklearn import svm, datasets
#from sklearn.metrics import roc_curve, auc
# from sklearn.model_selection import train_test_split
# from sklearn.preprocessing import label_binarize
# from sklearn.multiclass import OneVsRestClassifier
# # #from scipy import interp
# from sklearn.metrics import roc_auc_score
#import operator
from .testroc import classifier
#############################

class model:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'model_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&SZ')
        self.toolbar = self.iface.addToolBar(u'SZ')
        self.toolbar.setObjectName(u'SZ')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None#none


    #####################################################

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('model', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/sz/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Susceptibiliy Zoning'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&SZ'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar
    def select_txt_file(self):
        filename, _ = QFileDialog.getOpenFileName(self.dlg, "Select input classes cause 1","", '*.txt')
        self.dlg.lineEdit_6.setText(filename)

    def select_txt2_file(self):
        filename, _ = QFileDialog.getOpenFileName(self.dlg, "Select input classes cause 2","", '*.txt')
        self.dlg.lineEdit_7.setText(filename)

    def select_txt3_file(self):
        filename, _ = QFileDialog.getOpenFileName(self.dlg, "Select input classes cause 3","", '*.txt')
        self.dlg.lineEdit_8.setText(filename)

    def select_txt4_file(self):
        filename, _ = QFileDialog.getOpenFileName(self.dlg, "Select input classes cause 4","", '*.txt')
        self.dlg.lineEdit_9.setText(filename)

    # def selecttxt(self,y):
    #     print('ciao')
    #     filename, _ = QFileDialog.getOpenFileName(self.dlg, "Select input classes cause "+str(y+5),"", '*.txt')
    #     self.dlg.lineEditlista[y].setText(filename)

    def select_input16_file(self):
        filename= QFileDialog.getExistingDirectory(self.dlg, "Work folder","")
        self.dlg.lineEdit_16.setText(filename)

    #output file save
    def select_output_file(self):
        filename, _ = QFileDialog.getSaveFileName(self.dlg, "Select output raster ","", '*.tif')
        if not QtCore.QFileInfo(filename).suffix():
            filename += ".tif"
        self.dlg.lineEdit_5.setText(filename)

    #output file save roc
    def select_output_fileroc(self):
        filename, _ = QFileDialog.getSaveFileName(self.dlg, "Select output classification","", '*.txt')
        if not QtCore.QFileInfo(filename).suffix():
            filename += ".txt"
        self.dlg.lineEdit.setText(filename)

    def select_input3_file(self):
        filename= QFileDialog.getExistingDirectory(self.dlg, "Work folder","")
        self.dlg.lineEdit_2.setText(filename)


    def run(self):
        """Run method that performs all the real work"""

        if self.first_start == True:
            self.first_start = False
            self.dlg = modelDialog()
                ########################################
                # #input txt classes
            self.dlg.lineEdit_6.clear()
            self.dlg.pushButton_6.clicked.connect(self.select_txt_file)
            self.dlg.lineEdit_7.clear()
            self.dlg.pushButton_7.clicked.connect(self.select_txt2_file)
            self.dlg.lineEdit_8.clear()
            self.dlg.pushButton_8.clicked.connect(self.select_txt3_file)
            self.dlg.lineEdit_9.clear()
            self.dlg.pushButton_9.clicked.connect(self.select_txt4_file)
            self.dlg.pushButton_2.clicked.connect(self.dlg.clickMethod)
            # #inventory,dem,fold
            self.dlg.lineEdit_16.clear()
            self.dlg.pushButton_12.clicked.connect(self.select_input16_file)
            #output button
            self.dlg.lineEdit_5.clear()
            self.dlg.pushButton_5.clicked.connect(self.select_output_file)
            ########################################
            #roc
            self.dlg.lineEdit_2.clear()
            self.dlg.pushButton_3.clicked.connect(self.select_input3_file)
            #print(self.dlg.ii, 'stampa')
            # show the dialog)
            # Run the dialog event loop
        # show the dialog
        self.dlg.show()

        result = self.dlg.exec_()
        # See if OK was pressed

        if result:
            #print('daie')
            self.testo = WoE()
            self.rock = classifier()
            if self.dlg.indice==0:
                # import class classe###################
                #     raise ValueError  # Cause 1 cannot be empty, see 'WoE' Log Messages Panel
                if len(self.dlg.lineEdit_6.text())==0:
                    QgsMessageLog.logMessage('ERROR: Classes 1 classes cannot be empty', tag="SZ")
                    raise ValueError  # Cause 1 classes cannot be empty, see 'SZ' Log Messages Panel
                else:
                    self.testo.Wcause1a=self.dlg.mMapLayerComboBox_4.currentLayer().dataProvider().dataSourceUri()
                    if self.testo.Wcause1a.rfind('|')==-1:
                        self.testo.Wcause1=self.testo.Wcause1a[:]
                    else:
                        self.testo.Wcause1=self.testo.Wcause1a[:self.testo.Wcause1a.rfind('|')]
                    #QgsMessageLog.logMessage(self.testo.Wcause1, tag="SZ")
                    self.testo.classes1=self.dlg.lineEdit_6.text()
                    QgsMessageLog.logMessage(self.testo.classes1, tag="SZ")

                if self.dlg.checkBox_6.isChecked()==False:
                    self.testo.Wcause2=None
                    self.testo.classes2=None
                elif len(self.dlg.lineEdit_7.text())==0 and self.dlg.checkBox_6 == True:
                    QgsMessageLog.logMessage('ERROR: Classes 2 cannot be empty', tag="SZ")
                    raise ValueError  # inventory cannot be empty, see 'SZ' Log Messages Panel
                else:
                    self.testo.Wcause2a=self.dlg.mMapLayerComboBox_6.currentLayer().dataProvider().dataSourceUri()
                    if self.testo.Wcause2a.rfind('|')==-1:
                        self.testo.Wcause2=self.testo.Wcause2a[:]
                    else:
                        self.testo.Wcause2=self.testo.Wcause2a[:self.testo.Wcause2a.rfind('|')]
                    self.testo.classes2=self.dlg.lineEdit_7.text()

                if self.dlg.checkBox_8.isChecked()==False:
                    self.testo.Wcause3=None
                    self.testo.classes3=None
                elif len(self.dlg.lineEdit_8.text())==0 and self.dlg.checkBox_8 == True:
                    QgsMessageLog.logMessage('ERROR: Classes 3 cannot be empty', tag="SZ")
                    raise ValueError  # inventory cannot be empty, see 'SZ' Log Messages Panel
                else:
                    self.testo.Wcause3a=self.dlg.mMapLayerComboBox_8.currentLayer().dataProvider().dataSourceUri()
                    if self.testo.Wcause3a.rfind('|')==-1:
                        self.testo.Wcause3=self.testo.Wcause3a[:]
                    else:
                        self.testo.Wcause3=self.testo.Wcause3a[:self.testo.Wcause3a.rfind('|')]
                    self.testo.classes3=self.dlg.lineEdit_8.text()

                if self.dlg.checkBox_10.isChecked()==False:
                    self.testo.Wcause4=None
                    self.testo.classes4=None
                elif len(self.dlg.lineEdit_9.text())==0 and self.dlg.checkBox_10 == True:
                    QgsMessageLog.logMessage('ERROR: Classes 4 cannot be empty', tag="SZ")
                    raise ValueError  # inventory cannot be empty, see 'SZ' Log Messages Panel
                else:
                    self.testo.Wcause4a=self.dlg.mMapLayerComboBox_10.currentLayer().dataProvider().dataSourceUri()
                    if self.testo.Wcause4a.rfind('|')==-1:
                        self.testo.Wcause4=self.testo.Wcause4a[:]
                    else:
                        self.testo.Wcause4=self.testo.Wcause4a[:self.testo.Wcause4a.rfind('|')]
                    self.testo.classes4=self.dlg.lineEdit_9.text()

                self.testo.inventorya=self.dlg.mMapLayerComboBox_2.currentLayer().dataProvider().dataSourceUri()
                if self.testo.inventorya.rfind('|')==-1:
                    self.testo.inventory=self.testo.inventorya[:]
                else:
                    self.testo.inventory=self.testo.inventorya[:self.testo.inventorya.rfind('|')]

                self.testo.ii=self.dlg.ii
                for y in range(self.dlg.ii):
                    self.testo.Wcauselista={}
                    self.testo.classeslista={}
                    self.testo.Wcauselista[y]='self.testo.Wcause'+str(y+5)
                    if len(self.dlg.lineEditlista[y].text())==0:
                        QgsMessageLog.logMessage('ERROR: Classes 1 classes cannot be empty', tag="SZ")
                        raise ValueError  # Cause 1 classes cannot be empty, see 'SZ' Log Messages Panel
                    else:
                        Wcause1a=self.dlg.mMapLayerComboBoxlista[y].currentLayer().dataProvider().dataSourceUri()
                        if Wcause1a.rfind('|')==-1:
                            self.testo.Wcauselista[y]=Wcause1a[:]
                        else:
                            self.testo.Wcauselista[y]=Wcause1a[:Wcause1a.rfind('|')]
                        #QgsMessageLog.logMessage(self.testo.Wcause1, tag="SZ")
                        self.testo.classeslista[y]=self.dlg.lineEditlista[y].text()
                        #QgsMessageLog.logMessage(self.testo.classes1, tag="SZ")

                if len(self.dlg.lineEdit_5.text())==0:
                    QgsMessageLog.logMessage('ERROR: LSIout cannot be empty', tag="SZ")
                    raise ValueError  # LSIout cannot be empty, see 'SZ' Log Messages Panel
                else:
                    self.testo.LSIout=self.dlg.lineEdit_5.text()

                if self.dlg.checkBox_2.isChecked()==False:
                    self.testo.fold='/tmp'
                elif len(self.dlg.lineEdit_16.text())==0 and self.dlg.checkBox_2.isChecked()==True:
                    QgsMessageLog.logMessage('ERROR: workfolder cannot be empty', tag="SZ")
                    raise ValueError  # workfolder cannot be empty, see 'SZ' Log Messages Panel
                else:
                    self.testo.fold=self.dlg.lineEdit_16.text()

                if self.dlg.checkBox.isChecked() == True:
                    self.testo.polya=self.dlg.mMapLayerComboBox.currentLayer().dataProvider().dataSourceUri()
                    if self.testo.polya.rfind('|')==-1:
                        self.testo.poly=self.testo.polya[:]
                    else:
                        self.testo.poly=self.testo.polya[:self.testo.polya.rfind('|')]
                    self.testo.polynum=1
                else:
                    self.testo.poly=None
                    self.testo.polynum=0
                #xmin,ymin,xmax,ymax
                self.testo.xmax=round(self.dlg.comboExtentChoiche.currentExtent().xMaximum(),2)
                self.testo.ymax=round(self.dlg.comboExtentChoiche.currentExtent().yMaximum(),2)
                self.testo.xmin=round(self.dlg.comboExtentChoiche.currentExtent().xMinimum(),2)
                self.testo.ymin=round(self.dlg.comboExtentChoiche.currentExtent().yMinimum(),2)
                self.testo.epsg=self.dlg.crsChoice.crs().authid()


                self.testo.w=abs(round(self.dlg.doubleSpinBox_5.value(),4))
                self.testo.h=abs(round(self.dlg.doubleSpinBox_6.value(),4))

                self.testo.method=self.dlg.methodindice

                self.testo.iter()
                self.testo.sumWf()
                self.testo.saveLSI()

                rlayer = QgsRasterLayer(self.testo.LSIout, "LSI")
                # first add the layer
                QgsProject.instance().addMapLayer(rlayer)


            elif self.dlg.indice==1:
                self.rock.inva=self.dlg.mMapLayerComboBox_3.currentLayer().dataProvider().dataSourceUri()
                if self.rock.inva.rfind('|')==-1:
                    self.rock.inv=self.rock.inva[:]
                else:
                    self.rock.inv=self.rock.inva[:self.rock.inva.rfind('|')]

                self.rock.lsia=self.dlg.mMapLayerComboBox_5.currentLayer().dataProvider().dataSourceUri()
                if self.rock.lsia.rfind('|')==-1:
                    self.rock.lsi=self.rock.lsia[:]
                else:
                    self.rock.lsi=self.rock.lsia[:self.rock.lsia.rfind('|')]

                self.rock.vala=self.dlg.mMapLayerComboBox_7.currentLayer().dataProvider().dataSourceUri()
                if self.rock.vala.rfind('|')==-1:
                    self.rock.val=self.rock.vala[:]
                else:
                    self.rock.val=self.rock.vala[:self.rock.vala.rfind('|')]

                self.rock.traina=self.dlg.mMapLayerComboBox_9.currentLayer().dataProvider().dataSourceUri()
                if self.rock.traina.rfind('|')==-1:
                    self.rock.train=self.rock.traina[:]
                else:
                    self.rock.train=self.rock.traina[:self.rock.traina.rfind('|')]

                # if len(self.dlg.lineEdit.text())==0:
                #     QgsMessageLog.logMessage('ERROR: output cannot be empty', tag="ROC tool")
                #     raise ValueError  # output cannot be empty, see 'ROCclassy' Log Messages Panel
                # else:
                #     self.rock.out=self.dlg.lineEdit.text()

                if self.dlg.checkBox_3.isChecked()==False:
                    self.rock.fold='/tmp'
                elif len(self.dlg.lineEdit_2.text())==0 and self.dlg.checkBox_3.isChecked()==True:
                    QgsMessageLog.logMessage('ERROR: workfolder cannot be empty', tag="ROC tool")
                    raise ValueError  # workfolder cannot be empty, see 'SZ' Log Messages Panel
                else:
                    self.rock.fold=self.dlg.lineEdit_2.text()

                self.rock.input()
                self.rock.classy()
                self.rock.stamp()



        QgsMessageLog.logMessage('Task completed', tag="SZ")
