function OccupationByUSState()

if exist(fullfile('+HCP', '+examples', 'figures'), 'dir')==0
    mkdir(fullfile('+HCP', '+examples', 'figures'));
end

% Load data
data = HCP.examples.get.OccupationByUSState();
% Select variables to use in heatmap with clustering
occupations = data.Properties.VariableNames(20:width(data));

% Initialize HeatmapCovariatePlot
p = HCP.HeatmapCovariatePlot(data,...
    'font_size', 6,...
    'left_labels_space', 35,...
    'covariate_row_margin', 1,...
    'covariate_legend_intraspace', 6,...
    'covariate_legend_entry_width', 9,...
    'heatmap_labels_font_size', 5);

% Add sub-block with region annotation
b1 = p.blocks.AddSubBlock();
b1.AddCovariateRow('state_region',...
    'title', 'Region');

% Add sub-block with weather-related annotation
b2 = p.blocks.AddSubBlock();
b2.AddCovariateRow('frost',...
    'cmap', brewermap(1024, 'Blues'),...
    'clim', [0, 200],...
    'title', 'Frost',...
    'unit', '[days]');

% Add sub-block with annotations for population demographics
b3 = p.blocks.AddSubBlock('title', 'Population');
b3.AddCovariateRow('total_residents_millions',...
    'clim', [0, 40],...
    'title', 'Residents',...
    'unit', '[mill]');
b3.AddCovariateRow('male_to_female_ratio',...
    'cmap', brewermap(1024, 'RdBu'),...
    'clim', [0.90, 1.1],...
    'title', 'Ratio male to female');
b3.AddCovariateRow('adults_to_children_ratio',...
    'cmap', brewermap(1024, 'YlGn'),...
    'clim', [1.8, 3.1],...
    'title', 'Ratio adults to children');
b3.AddCovariateRow('adults_with_children_to_adults_with_no_children_ratio',...
    'cmap', brewermap(1024, 'YlGn'),...
    'clim', [0.4, 0.8],...
    'title', 'Ratio adults with to without children');
b3.AddCovariateRow('citizen_to_non_citizen_ratio',...
    'clim', [0, 100],...
    'title', 'Ratio citizen to non-citizen');
b3.AddCovariateRow('registered_to_actually_voted_ratio',...
    'clim', [1, 1.3],...
    'title', 'Ratio registered to actual voters');
b3.AddCovariateRow('community_supervision_percent',...
    'cmap', brewermap(1024, 'Blues'),...
    'clim', [0, 2.5],...
    'title', 'Community supervision',...
    'unit', '[%]');
b3.AddCovariateRow('incarcerated_percent',...
    'cmap', brewermap(1024, 'Blues'),...
    'clim', [0, 1.1],...
    'title', 'Incarcerated',...
    'unit', '[%]');
b3.AddCovariateRow('people_experiencing_homelessness_percent',...
    'cmap', brewermap(1024, 'Blues'),...
    'clim', [0, 0.6],...
    'title', 'Homeless',...
    'unit', '[%]');
b3.AddCovariateRow('median_household_income_k',...
    'cmap', brewermap(1024, 'YlOrRd'),...
    'clim', [40, 80],...
    'title', 'Median household income',...
    'unit', '[$K]');
b3.AddCovariateRow('per_capita_state_spending_k',...
    'cmap', brewermap(1024, 'YlOrRd'),...
    'clim', [0, 15],...
    'title', 'Per-capita state spending',...
    'unit', '[$K]');
b3.AddCovariateRow('per_capita_state_collections_k',...
    'cmap', brewermap(1024, 'YlOrRd'),...
    'clim', [0, 5.5],...
    'title', 'Per-capita state collections',...
    'unit', '[$K]');
b3.AddCovariateRow('per_capita_gross_state_product_k',...
    'cmap', brewermap(1024, 'YlOrRd'),...
    'clim', [0, 100],...
    'title', 'Per-capita gross state product',...
    'unit', '[$K]');

% Add sub-block with unemployment annotation
b4 = p.blocks.AddSubBlock();
b4.AddCovariateRow('unemployment_rate_seasonally_adjusted',...
    'cmap', brewermap(1024, 'Greys'),...
    'clim', [0, 0.07],...
    'title', 'Unemployment rate (adjusted)');

% Add heatmap with clustering for selected features
p.blocks.AddHeatmap(occupations,...
    'distance', 'spearman',...
    'title', 'Percent of residents');

% Plot
p.Plot();

% Export figure as pdf
p.Export(fullfile('+HCP', '+examples', 'figures',...
    'occupation_by_us_state.pdf'),...
    '-w180',...
    '-rx');
end
