function Cars()

if exist(fullfile('+HCP', '+examples', 'figures'), 'dir')==0
    mkdir(fullfile('+HCP', '+examples', 'figures'));
end

% Load data
data = HCP.examples.get.Cars();

% Initialize HeatmapCovariatePlot
p = HCP.HeatmapCovariatePlot(data,...
    'left_labels_space', 20);

% Add metadata features
p.blocks.AddCovariateRow('Model_Year',...
    'cmap', [198, 219, 239; 66, 146, 198; 8, 81, 156]./255,...
    'title', 'Model year');
p.blocks.AddCovariateRow('Origin');
p.blocks.AddCovariateRow('Cylinders',...
    'cmap', brewermap(numel(data.Cylinders), 'Reds'),...
    'unit', '[#]');

% Add heatmap with clustering for selected car features
p.blocks.AddHeatmap({'MPG', 'Displacement', 'Horsepower', 'Weight', 'Acceleration'},...
    'height_per_feature', 2,...
    'standardize', true,...
    'show_sample_dendrogram', false,...
    'show_feature_dendrogram', true,...
    'n_feature_clusters', 2,...
    'feature_cluster_cmap', brewermap(2, 'Greys'),...
    'show_sample_labels', false,...
    'title', 'Z-scores');

% Plot
p.Plot();

% Export figure as pdf
p.Export(fullfile('+HCP', '+examples', 'figures',...
    'cars.pdf'),...
    '-w180',...
    '-rx');
end
