
#include <algorithm>
#include <iostream>

#include "mpi.h"


#define MPI_TYPE MPI_FLOAT

using btw_num_t = float;

int vertices = 20;
int edges = 20;

template <typename T>
struct Vector final {
  T *data;
  size_t size;

  // ~Vector() {
  //   delete[] data;
  // }
  Vector() = default;
  Vector(size_t n) : size(n) {
    data = new T[n];
  }

  void fill (T val) {
    std::fill(data, data + size, val);
  }
};

struct BetweennessResult {
  Vector<btw_num_t> VertexBetweenness;
  Vector<btw_num_t> EdgeBetweenness;
};

BetweennessResult Calculate(int start, int end) {

  auto generate = [start, end] (size_t n) -> Vector<btw_num_t> {
    Vector<btw_num_t> v(n);
    std::transform(v.data + start, v.data + end, v.data + start,
                   [] (btw_num_t x) { return x + 1; });
    return v;
  };

  return { generate(vertices), generate(edges) };
}

int main (int argc, char *argv[]) {

  MPI_Init(&argc, &argv);

  int startVertex = 0;
  int endVertex = vertices;
  int chunkSize = 6;

  int rank, size;
  int *slaveInvolved = new int[size];
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);
  MPI_Comm_size(MPI_COMM_WORLD, &size);

  enum MessageTag { wantWork, work, result };
  int jobStart = startVertex;
  int jobEnd = endVertex;
  int endsSended = 0;

  if (rank == 0) { // MASTER
    Vector<btw_num_t> betweenness(vertices);
    betweenness.fill(0);

    Vector<btw_num_t> edgeBetweenness(edges);
    edgeBetweenness.fill(0);

    while (true) {
      int wantWork;
      MPI_Request recvRequest;
      MPI_Irecv(&wantWork, 1, MPI_INT, MPI_ANY_SOURCE, MessageTag::wantWork,
                MPI_COMM_WORLD, &recvRequest);
      MPI_Status status;
      MPI_Wait(&recvRequest, &status);
      int slaveRank = status.MPI_SOURCE;

      if (wantWork == 1) {
        int work[2];

        // if (jobStart < jobEnd) {
        //   work[0] = jobStart;
        //   if (jobStart + chunkSize <= jobEnd) {
        //     work[1] = jobStart + chunkSize;
        //   } else {
        //     work[1] = jobStart + jobEnd % chunkSize;
        //   }
        // } else {
        //   work[0] = -1;
        //   endsSended++;
        // }

        MPI_Request sendRequest;
        MPI_Isend(&work, 2, MPI_INT, slaveRank, MessageTag::work,
                  MPI_COMM_WORLD, &sendRequest);
        MPI_Wait(&sendRequest, MPI_STATUS_IGNORE);

        jobStart += chunkSize;

        if (endsSended == size - 1) {
          break;
        }
      } else {
        Vector<btw_num_t> subBetweenness(vertices + edges);

        MPI_Request subBtwnRecvRequest;
        MPI_Irecv(subBetweenness.data, vertices + edges, MPI_TYPE,
                  slaveRank, MessageTag::result, MPI_COMM_WORLD,
                  &subBtwnRecvRequest);
        MPI_Wait(&subBtwnRecvRequest, MPI_STATUS_IGNORE);

        // for (size_t i = 0; i < vertices; i++) {
        //   betweenness.data[i] = betweenness.data[i] + subBetweenness.data[i];
        // }

        // for (size_t i = 0; i < edges; i++) {
        //   edgeBetweenness.data[i] = edgeBetweenness.data[i] + subBetweenness.data[i + vertices];
        // }
      }
    }

    // print resulting betweenness
    // btw_num_t *p_idx = betweenness.data;
    // std::cout << *p_idx;
    // p_idx++;
    // std::for_each(p_idx, betweenness.data + betweenness.size, [] (btw_num_t x) { std::cout << ", " << x; });
    // std::cout << std::endl;

  // } else { // SLAVE
  //   int  wantWork;

  //   while (true) {
  //     wantWork = 1;
  //     MPI_Request sendRequest;
  //     MPI_Isend(&wantWork, 1, MPI_INT, 0, MessageTag::wantWork, MPI_COMM_WORLD, &sendRequest);
  //     MPI_Wait(&sendRequest, MPI_STATUS_IGNORE);

  //     int work[2];
  //     MPI_Request recvRequest;
  //     MPI_Irecv(&work, 2, MPI_INT, 0, MessageTag::work, MPI_COMM_WORLD, &recvRequest);
  //     MPI_Wait(&recvRequest, MPI_STATUS_IGNORE);

  //     if (work[0] == -1) {
  //       // std::cout << std::endl
  //       //           << "slave[" << rank << "] involved: "
  //       //           << slaveInvolved[rank] << "x.\n";
  //       break;
  //     } else {
  //       slaveInvolved[rank]++;
  //       Vector<btw_num_t> results(vertices + edges);
  //       Vector<btw_num_t> subBetweenness;
  //       Vector<btw_num_t> subEdgeBetweenness;

  //       BetweennessResult result = Calculate(work[0], work[1]);
  //       subBetweenness = result.VertexBetweenness;
  //       subEdgeBetweenness = result.EdgeBetweenness;

  //       for (size_t i = 0; i < edges; i++) {
  //         results.data[i] = subBetweenness.data[i];
  //       }

  //       for (size_t i = 0; i < edges; i++) {
  //         results.data[i + vertices] = subEdgeBetweenness.data[i];
  //       }

  //       wantWork = 0;

  //       MPI_Request askWorkRequest;
  //       MPI_Isend(&wantWork, 1, MPI_INT, 0, MessageTag::wantWork, MPI_COMM_WORLD, &askWorkRequest);
  //       MPI_Wait(&askWorkRequest, MPI_STATUS_IGNORE);

  //       MPI_Request sendResultRequest;
  //       MPI_Isend(results.data, vertices + edges, MPI_TYPE,
  //                 0, MessageTag::result, MPI_COMM_WORLD,
  //                 &sendResultRequest);
  //       MPI_Wait(&sendResultRequest, MPI_STATUSES_IGNORE);
  //     }
  //   }
  }

  MPI_Finalize();
  return 0;
}
