#include "Common.h"
#include "mpi.h"

int main (int argc, char *argv[]) {

  int message_size = parse_args(argc, argv);

  MPI_Init(&argc, &argv);

  int startVertex = 0;
  int endVertex = vertices;

  int rank, size;
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);
  MPI_Comm_size(MPI_COMM_WORLD, &size);

  enum MessageTag { wantWork, work, result };
  int jobStart = startVertex;
  int jobEnd = endVertex;
  int endsSended = 0;

  if (rank == 0) { // MASTER
    Vector<btw_num_t> betweenness(vertices);
    betweenness.fill(0);

    Vector<btw_num_t> edgeBetweenness(edges);
    edgeBetweenness.fill(0);

    int *work = new int[message_size];
    std::fill(work, work + message_size, 7);

    while (true) {
      int wantWork;
      MPI_Request recvRequest;
      MPI_Irecv(&wantWork, 1, MPI_INT, MPI_ANY_SOURCE, MessageTag::wantWork,
                MPI_COMM_WORLD, &recvRequest);
      MPI_Status status;
      MPI_Wait(&recvRequest, &status);
      int slaveRank = status.MPI_SOURCE;

      if (wantWork == 1) {

        if (jobStart < jobEnd) {
          work[0] = jobStart;
          if (jobStart + chunkSize < jobEnd) {
            work[1] = jobStart + chunkSize;
          } else {
            work[1] = jobEnd - 1;
          }
        } else {
          work[0] = -1;
          endsSended++;
        }

        MPI_Request sendRequest;
        MPI_Isend(work, message_size, MPI_INT, slaveRank, MessageTag::work,
                  MPI_COMM_WORLD, &sendRequest);
        MPI_Wait(&sendRequest, MPI_STATUS_IGNORE);

        jobStart += chunkSize;

        if (endsSended == size - 1) {
          break;
        }
      } else {
        Vector<btw_num_t> subBetweenness(vertices + edges);

        MPI_Request subBtwnRecvRequest;
        MPI_Irecv(subBetweenness.data, vertices + edges, MPI_TYPE,
                  slaveRank, MessageTag::result, MPI_COMM_WORLD,
                  &subBtwnRecvRequest);
        MPI_Wait(&subBtwnRecvRequest, MPI_STATUS_IGNORE);

        for (size_t i = 0; i < vertices; i++) {
          betweenness.data[i] = betweenness.data[i] + subBetweenness.data[i];
        }

        for (size_t i = 0; i < edges; i++) {
          edgeBetweenness.data[i] = edgeBetweenness.data[i] + subBetweenness.data[i + vertices];
        }
      }
    }
  } else { // SLAVE

    while (true) {
      int wantWork = 1;
      MPI_Request sendRequest;
      MPI_Isend(&wantWork, 1, MPI_INT, 0, MessageTag::wantWork, MPI_COMM_WORLD, &sendRequest);
      MPI_Wait(&sendRequest, MPI_STATUS_IGNORE);

      int *work = new int[message_size];
      MPI_Request recvRequest;
      MPI_Irecv(work, message_size, MPI_INT, 0, MessageTag::work, MPI_COMM_WORLD, &recvRequest);
      MPI_Wait(&recvRequest, MPI_STATUS_IGNORE);

      if (work[0] == -1) {
        break;
      } else {
        Vector<btw_num_t> results(vertices + edges);

        BetweennessResult subBtwn = Calculate(work[0], work[1], rank);
        delete[] work;

        for (size_t i = 0; i < vertices; i++) {
          results.data[i] = subBtwn.VertexBetweenness.data[i];
        }
        for (size_t i = 0; i < edges; i++) {
          results.data[i + vertices] = subBtwn.EdgeBetweenness.data[i];
        }

        int doNotWantWork = 0;
        MPI_Request askWorkRequest;
        MPI_Isend(&doNotWantWork, 1, MPI_INT, 0, MessageTag::wantWork, MPI_COMM_WORLD, &askWorkRequest);
        MPI_Wait(&askWorkRequest, MPI_STATUS_IGNORE);

        MPI_Request sendResultRequest;
        MPI_Isend(results.data, vertices + edges, MPI_TYPE,
                  0, MessageTag::result, MPI_COMM_WORLD,
                  &sendResultRequest);
        MPI_Wait(&sendResultRequest, MPI_STATUSES_IGNORE);
      }
    }
  }

  MPI_Finalize();
  return 0;
}
