#include <algorithm>
#include <cassert>
#include <iostream>
#include <sstream>
#include <string>

#define assertm(exp, msg) assert(((void)msg, exp))

#define MPI_TYPE MPI_FLOAT
using btw_num_t = float;

int vertices = 3000;
int edges = 5000;
int chunkSize = 10;

template <typename T>
struct Vector final {
  T *data;
  size_t size;

  ~Vector() {
    delete[] data;
  }

  Vector() = delete;
 Vector(size_t n) : size(n) {
    data = new T[n];
  }

  void fill (T val) {
    std::fill(data, data + size, val);
  }
};

struct BetweennessResult {
  Vector<btw_num_t> VertexBetweenness;
  Vector<btw_num_t> EdgeBetweenness;
};

BetweennessResult Calculate(int start, int end, int rank) {

  auto generate = [start, end] (size_t n) -> Vector<btw_num_t> {
    Vector<btw_num_t> v(n);
    std::transform(v.data + start, v.data + end, v.data + start,
                   [] (btw_num_t x) { return x + 1; });
    return v;
  };

  // std::cout << "rank: " << rank << " calculate betweenness." << std::endl;
  return { generate(vertices), generate(edges) };
}

std::string message_size_str(int message_size) {
  std::stringstream ss;

  long msize = sizeof(int) * message_size;
  if (msize >= 1e9) {
    ss << msize / 1e9f << " GB";
  } else if (msize >= 1e6) {
    ss << msize / 1e6f << " MB";
  } else if (msize >= 1e3) {
    ss << msize / 1e3f << " KB";
  } else {
    ss << msize << " B";
  }
  return ss.str();
}

int parse_args(int argc, char *argv[]) {
  assertm(argc >= 2, "The size of work is expected.");

  int message_size = atoi(argv[1]);

  assertm(message_size >= 2, "Message size has to be at least 2.");

  std::cout << "Message size: " << message_size_str(message_size) << std::endl;
  return message_size;
}
